(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     57527,       1098]
NotebookOptionsPosition[     57160,       1081]
NotebookOutlinePosition[     57584,       1099]
CellTagsIndexPosition[     57541,       1096]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", "$PathnameSeparator", 
     "<>", "\"\<output_expressions_mathematica\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Panel", ",", " ", 
    RowBox[{
     RowBox[{"stiffener", "'"}], "s", " ", "base", " ", "and", " ", 
     RowBox[{"stiffener", "'"}], "s", " ", "flange", " ", "k0"}], ",", " ", 
    "kG0", ",", " ", "kA", ",", " ", "cA", ",", " ", 
    RowBox[{"kM", " ", "will", " ", "all", " ", "be", " ", "reused"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "only", " ", "the", " ", "connection", " ", "matrices", " ", "will", " ", 
    "be", " ", "herein", " ", "defined"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Displacements", " ", "for", " ", "panel"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uA", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"fAu", "*", "gAu"}], ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vA", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"fAv", "*", "gAv"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wA", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"fAw", "*", "gAw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wAxi", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"fAwxi", "*", "gAw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"wAeta", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"fAw", "*", "gAweta"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uB", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"fBu", "*", "gBu"}], ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vB", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"fBv", "*", "gBv"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wB", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"fBw", "*", "gBw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wBxi", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"fBwxi", "*", "gBw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"wBeta", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"fBw", "*", "gBweta"}]}], "}"}]}], ";"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Displacements", " ", "for", " ", 
    RowBox[{"stiffener", "'"}], "s", " ", "base"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uAb", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pAu", "*", "qAu"}], ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vAb", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"pAv", "*", "qAv"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wAb", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"pAw", "*", "qAw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wAxib", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"pAwxi", "*", "qAw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"wAetab", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"pAw", "*", "qAweta"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uBb", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pBu", "*", "qBu"}], ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vBb", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"pBv", "*", "qBv"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wBb", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"pBw", "*", "qBw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wBxib", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"pBwxi", "*", "qBw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"wBetab", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"pBw", "*", "qBweta"}]}], "}"}]}], ";"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Displacements", " ", "for", " ", 
    RowBox[{"stiffener", "'"}], "s", " ", "flange"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uAf", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rAu", "*", "sAu"}], ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vAf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"rAv", "*", "sAv"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wAf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"rAw", "*", "sAw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"wAetaf", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"rAw", "*", "sAweta"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uBf", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rBu", "*", "sBu"}], ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vBf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"rBv", "*", "sBv"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wBf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"rBw", "*", "sBw"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"wBetaf", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"rBw", "*", "sBweta"}]}], "}"}]}], ";"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"Note", " ", "below", " ", "that", " ", "in", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", "-", 
         RowBox[{"uf", "'"}]}], ")"}], "^", "2"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"u", ".", "u"}], " ", "-", " ", 
        RowBox[{"u", ".", "uf"}], " ", "-", " ", 
        RowBox[{"uf", ".", "u"}], "+", " ", 
        RowBox[{"uf", ".", 
         RowBox[{"uf", "^", "2"}]}]}], ")"}], "\[IndentingNewLine]", "we", 
      " ", "only", " ", "want", " ", "the", " ", "upper", " ", "triangle", 
      " ", "of", " ", "the", " ", "connectivity", " ", "matrix"}]}], ",", 
    "    ", "\[IndentingNewLine]", "  ", 
    RowBox[{"thus", " ", "-", 
     RowBox[{
      RowBox[{"uf", ".", "u"}], " ", "is", " ", "ignored"}]}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Connection", " ", "between", " ", "panel", " ", "skin", " ", "and", " ", 
    RowBox[{"stiffener", "'"}], "s", " ", "base"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"connection", " ", "panel"}], "-", 
    RowBox[{"base", " ", "integrated", " ", "over", " ", 
     RowBox[{"xi", "'"}], " ", "and", " ", 
     RowBox[{"eta", "'"}]}]}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kCpp", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", " ", 
      RowBox[{"b", "/", "4"}]}], ")"}], "*", "kt", 
    RowBox[{"(", " ", "\[IndentingNewLine]", "      ", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", "uA", "}"}], "]"}], ".", 
       RowBox[{"{", "uB", "}"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", "vA", "}"}], "]"}], ".", 
       RowBox[{"{", "vB", "}"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", "wA", "}"}], "]"}], ".", 
       RowBox[{"{", "wB", "}"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "uA", "}"}], "]"}], ".", 
        RowBox[{"{", "wBxi", "}"}]}], "*", 
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"dpb", "/", "a"}]}], ")"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAxi", "}"}], "]"}], ".", 
        RowBox[{"{", "uB", "}"}]}], "*", 
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"dpb", "/", "a"}]}], ")"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "vA", "}"}], "]"}], ".", 
        RowBox[{"{", "wBeta", "}"}]}], "*", 
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"dpb", "/", "b"}]}], ")"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAeta", "}"}], "]"}], ".", 
        RowBox[{"{", "vB", "}"}]}], "*", 
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"dpb", "/", "b"}]}], ")"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAxi", "}"}], "]"}], ".", 
        RowBox[{"{", "wBxi", "}"}]}], "*", "4", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"dpb", "/", "a"}], ")"}], "^", "2"}]}], 
      "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAeta", "}"}], "]"}], ".", 
        RowBox[{"{", "wBeta", "}"}]}], "*", "4", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"dpb", "/", "b"}], ")"}], "^", "2"}]}]}], 
     "\[IndentingNewLine]", ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kCpb", "=", 
   RowBox[{
    RowBox[{"-", "c1"}], 
    RowBox[{"(", 
     RowBox[{"a", " ", 
      RowBox[{"b", "/", "4"}]}], ")"}], "*", "kt", 
    RowBox[{"(", " ", "\[IndentingNewLine]", "     ", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", " ", 
        RowBox[{"{", "uA", "}"}], "]"}], ".", 
       RowBox[{"{", "uBb", "}"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", "vA", "}"}], "]"}], ".", 
       RowBox[{"{", "vBb", "}"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", "wA", "}"}], "]"}], ".", 
       RowBox[{"{", "wBb", "}"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAxi", "}"}], "]"}], ".", 
        RowBox[{"{", "uBb", "}"}]}], "*", 
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"dpb", "/", "a"}]}], ")"}]}], "\[IndentingNewLine]", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAeta", "}"}], "]"}], ".", 
        RowBox[{"{", "vBb", "}"}]}], "*", 
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"dpb", "/", "b"}]}], ")"}]}]}], "\[IndentingNewLine]", 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kCbbpb", "=", 
    RowBox[{"c1", 
     RowBox[{"(", 
      RowBox[{"a", " ", 
       RowBox[{"b", "/", "4"}]}], ")"}], "*", "kt", 
     RowBox[{"(", " ", "\[IndentingNewLine]", "     ", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "uAb", "}"}], "]"}], ".", 
        RowBox[{"{", "uBb", "}"}]}], "\[IndentingNewLine]", "+", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "vAb", "}"}], "]"}], ".", 
        RowBox[{"{", "vBb", "}"}]}], "\[IndentingNewLine]", "+", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAb", "}"}], "]"}], ".", 
        RowBox[{"{", "wBb", "}"}]}]}], "\[IndentingNewLine]", ")"}]}]}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Connection", " ", "between", " ", 
    RowBox[{"stiffener", "'"}], "s", " ", "base", " ", "and", " ", "flange"}],
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kCbbbf", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "/", "2"}], ")"}], "*", "kt", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "uAb", "}"}], "]"}], ".", 
        RowBox[{"{", "uBb", "}"}]}], "\[IndentingNewLine]", "+", " ", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "vAb", "}"}], "]"}], ".", 
        RowBox[{"{", "vBb", "}"}]}], "\[IndentingNewLine]", "+", " ", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAb", "}"}], "]"}], ".", 
        RowBox[{"{", "wBb", "}"}]}], "\[IndentingNewLine]", "  ", "+", 
       RowBox[{
        RowBox[{"kr", " ", "/", "kt"}], "*", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "/", "bb"}], ")"}], "wAetab"}], "}"}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "/", "bb"}], ")"}], "wBetab"}], "}"}]}]}]}], 
      ")"}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kCbf", "=", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"a", "/", "2"}], ")"}]}], "*", "kt", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", " ", 
         RowBox[{"{", "uAb", "}"}], "]"}], ".", 
        RowBox[{"{", "uBf", "}"}]}], "\[IndentingNewLine]", "+", " ", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "vAb", "}"}], "]"}], ".", 
        RowBox[{"{", "wBf", "}"}]}], "\[IndentingNewLine]", "-", " ", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAb", "}"}], "]"}], ".", 
        RowBox[{"{", "vBf", "}"}]}], "\[IndentingNewLine]", "+", 
       RowBox[{
        RowBox[{"kr", "/", "kt"}], "*", " ", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "/", "bb"}], ")"}], "wAetab"}], "}"}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "/", "bf"}], ")"}], "wBetaf"}], "}"}]}]}]}], 
      ")"}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kCff", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "/", "2"}], ")"}], "*", "kt", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "uAf", "}"}], "]"}], ".", 
        RowBox[{"{", "uBf", "}"}]}], "\[IndentingNewLine]", "+", " ", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "wAf", "}"}], "]"}], ".", 
        RowBox[{"{", "wBf", "}"}]}], "\[IndentingNewLine]", "+", " ", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"{", "vAf", "}"}], "]"}], ".", 
        RowBox[{"{", "vBf", "}"}]}], "\[IndentingNewLine]", "+", 
       RowBox[{
        RowBox[{"kr", "/", "kt"}], "*", " ", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "/", "bf"}], ")"}], "wAetaf"}], "}"}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "/", "bf"}], ")"}], "wBetaf"}], "}"}]}]}]}], 
      ")"}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"OpenWrite", "[", "\"\<fortran_kCpp.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"s", ",", 
    RowBox[{"FortranForm", "[", "kCpp", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "s", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"OpenWrite", "[", "\"\<fortran_kCpb.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"s", ",", 
    RowBox[{"FortranForm", "[", "kCpb", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "s", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"OpenWrite", "[", "\"\<fortran_kCbbpb.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"s", ",", 
    RowBox[{"FortranForm", "[", "kCbbpb", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "s", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"OpenWrite", "[", "\"\<fortran_kCbbbf.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"s", ",", 
    RowBox[{"FortranForm", "[", "kCbbbf", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "s", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"OpenWrite", "[", "\"\<fortran_kCbf.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"s", ",", 
    RowBox[{"FortranForm", "[", "kCbf", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "s", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"OpenWrite", "[", "\"\<fortran_kCff.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"s", ",", 
    RowBox[{"FortranForm", "[", "kCff", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Close", "[", "s", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5988751343024645`*^9, 3.598875149345325*^9}, {
   3.5988753108685637`*^9, 3.5988754321825027`*^9}, {3.598875479589214*^9, 
   3.5988755888094606`*^9}, 3.598875669691087*^9, {3.5988757097403774`*^9, 
   3.598875714802667*^9}, {3.598876419867995*^9, 3.598876470219875*^9}, {
   3.5988765343775444`*^9, 3.5988765453261704`*^9}, {3.5988765959400654`*^9, 
   3.598876606698681*^9}, {3.5988766473450055`*^9, 3.598876648712084*^9}, {
   3.598876704392268*^9, 3.5988767609205017`*^9}, {3.5988768236120872`*^9, 
   3.5988768269512787`*^9}, {3.5988768811743803`*^9, 3.598876910409052*^9}, {
   3.5988775028619385`*^9, 3.5988776175945005`*^9}, {3.5988776677223682`*^9, 
   3.5988776704695253`*^9}, {3.598877707026616*^9, 3.5988777811488557`*^9}, {
   3.5988778368220396`*^9, 3.5988778370500526`*^9}, {3.598877962448225*^9, 
   3.5988782071672225`*^9}, {3.5988784095227966`*^9, 3.59887864298915*^9}, {
   3.5988786775651274`*^9, 3.5988788208083205`*^9}, {3.598878884983991*^9, 
   3.5988789131836042`*^9}, {3.598878959114231*^9, 3.5988790727597313`*^9}, {
   3.598879133614212*^9, 3.5988792102165937`*^9}, {3.5988793276843123`*^9, 
   3.598879329754431*^9}, {3.59887957364038*^9, 3.5988796752711935`*^9}, {
   3.5988799419774475`*^9, 3.5988799476387715`*^9}, {3.598880004988052*^9, 
   3.5988800058301*^9}, {3.5988800420891743`*^9, 3.598880179809051*^9}, {
   3.5988802970207553`*^9, 3.5988803020230412`*^9}, 3.5988803406492505`*^9, 
   3.5988803958574085`*^9, 3.5988843138085203`*^9, {3.5988845886632404`*^9, 
   3.598884661836426*^9}, {3.598884945999679*^9, 3.598884981487709*^9}, {
   3.5988851178425083`*^9, 3.598885129732188*^9}, {3.5988851623350525`*^9, 
   3.598885167740362*^9}, {3.598889756412819*^9, 3.59888976919855*^9}, {
   3.598890243568183*^9, 3.5988902788182325`*^9}, {3.598890998621744*^9, 
   3.5988910004678497`*^9}, {3.598891399075649*^9, 3.598891643710641*^9}, {
   3.5988916877631607`*^9, 3.598891950161169*^9}, {3.5988921837895317`*^9, 
   3.5988926061946917`*^9}, {3.598892658503684*^9, 3.5988927533031063`*^9}, {
   3.5988928209009724`*^9, 3.598892850346657*^9}, {3.598892962158052*^9, 
   3.5988929865724487`*^9}, {3.598893040179515*^9, 3.598893317650385*^9}, {
   3.598893349510207*^9, 3.598893414857945*^9}, {3.5988934532411404`*^9, 
   3.598893456407322*^9}, {3.598893567842695*^9, 3.5988936027056894`*^9}, 
   3.5988937334091654`*^9, {3.5988937690862055`*^9, 3.5988938136977572`*^9}, {
   3.598893855144128*^9, 3.5988938768413687`*^9}, {3.5989008394098825`*^9, 
   3.5989009329788465`*^9}, {3.598901001556567*^9, 3.598901247506599*^9}, {
   3.5989015148677177`*^9, 3.598901541459239*^9}, {3.598901597638452*^9, 
   3.598901619842722*^9}, {3.59890169218886*^9, 3.5989017065556817`*^9}, {
   3.598901820250185*^9, 3.598901859666439*^9}, {3.5989019027429028`*^9, 
   3.5989021657859483`*^9}, {3.598902264550597*^9, 3.598902266162689*^9}, {
   3.598902380233214*^9, 3.5989023862195563`*^9}, {3.5989024342673044`*^9, 
   3.59890249066153*^9}, 3.59890252213433*^9, {3.5989283180587726`*^9, 
   3.5989283229130507`*^9}, {3.5989307440843363`*^9, 
   3.5989307484055443`*^9}, {3.5989308871769876`*^9, 
   3.5989309123554325`*^9}, {3.5989309979527826`*^9, 3.598931174591893*^9}, {
   3.598931234464798*^9, 3.5989312421088114`*^9}, {3.5989312797516775`*^9, 
   3.5989313035417194`*^9}, {3.598931447842772*^9, 3.5989314986520615`*^9}, {
   3.598931558868167*^9, 3.5989315800530043`*^9}, {3.5989317911681747`*^9, 
   3.5989318004501915`*^9}, {3.5989324456732283`*^9, 
   3.5989324464862747`*^9}, {3.5989328893606057`*^9, 
   3.5989330227812366`*^9}, {3.5989330749782224`*^9, 3.598933096754468*^9}, 
   3.598933207745816*^9, {3.598933315349971*^9, 3.5989334576691113`*^9}, {
   3.5989335193266373`*^9, 3.5989336409245925`*^9}, {3.5989337123766794`*^9, 
   3.5989337571212387`*^9}, {3.5989338200608387`*^9, 3.59893382253598*^9}, {
   3.598933872032811*^9, 3.598933872445835*^9}, {3.598933921258627*^9, 
   3.5989343830810413`*^9}, {3.598934471816117*^9, 3.598934477057417*^9}, {
   3.5989346025635953`*^9, 3.598934607990906*^9}, 3.5989357722394967`*^9, {
   3.598937289850994*^9, 3.5989372905217953`*^9}, {3.59893737290554*^9, 
   3.5989373892331686`*^9}, {3.5989378698544126`*^9, 3.598937965544981*^9}, {
   3.5989403021974573`*^9, 3.598940325923815*^9}, {3.5989404292897267`*^9, 
   3.598940429753753*^9}, {3.598940484633892*^9, 3.5989405463884244`*^9}, {
   3.5989406255849543`*^9, 3.5989406583168263`*^9}, {3.598940744685766*^9, 
   3.598940744871777*^9}, {3.59894082342627*^9, 3.5989409081201143`*^9}, 
   3.5989409741928935`*^9, {3.598941080525975*^9, 3.5989410951618123`*^9}, {
   3.5989411763134537`*^9, 3.598941199996809*^9}, {3.598941323328863*^9, 
   3.5989413410518765`*^9}, {3.5989413838193226`*^9, 3.598941418107284*^9}, {
   3.59894147765969*^9, 3.5989414853631306`*^9}, {3.5989415196480913`*^9, 
   3.5989415598783927`*^9}, {3.5989416249101124`*^9, 3.598941653385741*^9}, {
   3.598941813269886*^9, 3.5989418141589365`*^9}, {3.598941928595482*^9, 
   3.5989419505697393`*^9}, {3.5989420387787848`*^9, 
   3.5989420423249874`*^9}, {3.5989420735267715`*^9, 
   3.5989420995952625`*^9}, {3.598942162502861*^9, 3.598942197037836*^9}, {
   3.598942360156166*^9, 3.5989423615652466`*^9}, {3.5989424551666*^9, 
   3.598942521280382*^9}, {3.598942604497142*^9, 3.598942611254528*^9}, 
   3.5989426559970875`*^9, {3.598942697467459*^9, 3.5989428328192005`*^9}, {
   3.598942894615735*^9, 3.5989429033772364`*^9}, {3.598942950413927*^9, 
   3.5989429588694105`*^9}, {3.5989429960965395`*^9, 
   3.5989432881182423`*^9}, {3.5989463865184608`*^9, 
   3.5989463938128777`*^9}, {3.598946427188787*^9, 3.5989464309310007`*^9}, {
   3.5989464879652634`*^9, 3.5989464890233235`*^9}, {3.5989465415773296`*^9, 
   3.5989465948033743`*^9}, {3.598946657336951*^9, 3.5989467237547493`*^9}, {
   3.5989467912236085`*^9, 3.5989467919186487`*^9}, {3.5989468286947517`*^9, 
   3.598947002239678*^9}, {3.598947046580214*^9, 3.598947050161419*^9}, {
   3.5989471369873853`*^9, 3.598947176511646*^9}, {3.598947226504505*^9, 
   3.598947283849785*^9}, {3.5989473191518044`*^9, 3.598947320110859*^9}, {
   3.598947396647237*^9, 3.5989475024302874`*^9}, {3.598947556425376*^9, 
   3.598947605616189*^9}, {3.5989476817575445`*^9, 3.598947940226328*^9}, {
   3.5989479843508515`*^9, 3.5989479966745567`*^9}, {3.5989480925050373`*^9, 
   3.598948099923462*^9}, {3.5989481859433823`*^9, 3.5989482942445765`*^9}, {
   3.598948342116315*^9, 3.598948342665346*^9}, {3.598948381092544*^9, 
   3.598948398915563*^9}, 3.598948429952338*^9, 3.598948465970399*^9, {
   3.5989485131270957`*^9, 3.59894851529622*^9}, {3.59894854886514*^9, 
   3.59894859868499*^9}, {3.5989492197195106`*^9, 3.598949227157936*^9}, {
   3.5989492661921687`*^9, 3.5989492687833166`*^9}, {3.5989494288864746`*^9, 
   3.598949442571257*^9}, {3.5989494873338175`*^9, 3.598949519864678*^9}, {
   3.598949568399454*^9, 3.5989495694755154`*^9}, 3.5989496158311667`*^9, {
   3.598949727408549*^9, 3.5989497637656283`*^9}, {3.598949827415269*^9, 
   3.598949827889296*^9}, {3.5989500902032995`*^9, 3.5989500956716123`*^9}, 
   3.5989507114158306`*^9, {3.598952980884637*^9, 3.5989529973055763`*^9}, {
   3.598957466597205*^9, 3.598957483430168*^9}, {3.598957555606296*^9, 
   3.598957590505292*^9}, {3.5989576659356065`*^9, 3.5989577327594285`*^9}, {
   3.598957849311095*^9, 3.598957860429731*^9}, {3.598957937391133*^9, 
   3.598957944207523*^9}, {3.5989580490555196`*^9, 3.5989580801012955`*^9}, {
   3.5989581170834107`*^9, 3.5989581606899047`*^9}, {3.598958760223196*^9, 
   3.598958788981841*^9}, {3.598958818984557*^9, 3.598958819660596*^9}, {
   3.59895885015434*^9, 3.598959041927309*^9}, {3.598959664781934*^9, 
   3.598959836280743*^9}, {3.5989599195805073`*^9, 3.5989600401544037`*^9}, {
   3.5989601035640306`*^9, 3.598960104128063*^9}, {3.5989601554439983`*^9, 
   3.5989601566070647`*^9}, 3.598960193784191*^9, 3.598960309731823*^9, {
   3.5989621763145857`*^9, 3.598962183858017*^9}, {3.5989624612098804`*^9, 
   3.598962475481697*^9}, {3.5989625181551375`*^9, 3.598962533497015*^9}, 
   3.5990380589814873`*^9, {3.599039065738877*^9, 3.5990391194269476`*^9}, {
   3.599039680189021*^9, 3.5990397056494775`*^9}, {3.599040616635583*^9, 
   3.5990406172746196`*^9}, {3.599041429305065*^9, 3.5990414297000875`*^9}, 
   3.5990415101156874`*^9, {3.5990416092203555`*^9, 3.5990416223561068`*^9}, {
   3.5990417281541586`*^9, 3.599041757649845*^9}, {3.599041958725346*^9, 
   3.59904197452125*^9}, {3.5990421625350037`*^9, 3.5990421632540445`*^9}, {
   3.5991910375335283`*^9, 3.599191086860815*^9}, {3.5991911684645586`*^9, 
   3.599191182114582*^9}, {3.59919133416885*^9, 3.599191387739344*^9}, {
   3.5991923725646772`*^9, 3.5991923804738913`*^9}, 3.59919242541757*^9, {
   3.599547303663577*^9, 3.5995474528081074`*^9}, {3.599547556025011*^9, 
   3.599547813222722*^9}, {3.59954794780942*^9, 3.5995480687243357`*^9}, {
   3.599548126367633*^9, 3.599548193469471*^9}, 3.5995507096043854`*^9, {
   3.599550861245059*^9, 3.5995508919968176`*^9}, {3.599550968578198*^9, 
   3.5995510382031803`*^9}, {3.599551076213354*^9, 3.5995511047639875`*^9}, 
   3.5995512284830637`*^9, {3.599551261296941*^9, 3.5995512624100046`*^9}, {
   3.5995513174951553`*^9, 3.599551335259171*^9}, {3.599555382517661*^9, 
   3.5995553905711217`*^9}, {3.5995554906778474`*^9, 
   3.5995555130101247`*^9}, {3.599558329900242*^9, 3.5995583489363303`*^9}, {
   3.5995584073126693`*^9, 3.5995584079257045`*^9}, 3.599561217520404*^9, {
   3.599561277803852*^9, 3.5995612783418827`*^9}, {3.601054837836965*^9, 
   3.6010548545819225`*^9}, 3.6010550310190144`*^9, {3.601055062097792*^9, 
   3.601055092218515*^9}, {3.6010578042656355`*^9, 3.601057804644657*^9}, {
   3.6010934147001796`*^9, 3.601093452577046*^9}, {3.601093513900754*^9, 
   3.601093587408083*^9}, {3.6010936308541594`*^9, 3.601093639262574*^9}, {
   3.6010942107361393`*^9, 3.601094255835819*^9}, 3.60109431332192*^9, {
   3.6010949780822067`*^9, 3.6010949928554325`*^9}, {3.601095104848029*^9, 
   3.6010951052536297`*^9}, {3.601095627230361*^9, 3.601095650068801*^9}, {
   3.601095725741334*^9, 3.6010957297349405`*^9}, {3.6010973259793453`*^9, 
   3.601097414696701*^9}, {3.6010975148800774`*^9, 3.6010975154884777`*^9}, {
   3.6010985531116076`*^9, 3.6010985936872787`*^9}, {3.6010986458537703`*^9, 
   3.6010986464933715`*^9}, {3.601099027830043*^9, 3.601099053585688*^9}, 
   3.6011805374775176`*^9, {3.601208683718072*^9, 3.601208701722101*^9}, {
   3.6012087400332923`*^9, 3.6012087408183374`*^9}, {3.6012088574933186`*^9, 
   3.6012088580373497`*^9}, {3.6012303878174653`*^9, 
   3.6012304190532517`*^9}, {3.6012305073062997`*^9, 3.601230507738324*^9}, 
   3.601231286825886*^9, {3.6012314158592663`*^9, 3.6012314169193263`*^9}, {
   3.601272568083086*^9, 3.601272568546113*^9}, {3.601272743561123*^9, 
   3.6012727440401506`*^9}, {3.6012729040032997`*^9, 3.601272931484872*^9}, {
   3.6012742326072917`*^9, 3.60127423328333*^9}, 3.6012742708864813`*^9, {
   3.6012743224734316`*^9, 3.6012743463958*^9}, {3.601274432020697*^9, 
   3.6012744325637283`*^9}, {3.601274486423809*^9, 3.6012744904960423`*^9}, {
   3.601274746667694*^9, 3.601274748624806*^9}, {3.601274824524147*^9, 
   3.601274824955172*^9}, {3.6012748779612036`*^9, 3.601274889714876*^9}, {
   3.6012785497712193`*^9, 3.60127856219993*^9}, {3.6012790546820984`*^9, 
   3.6012790552161293`*^9}, 3.6012795345495453`*^9, {3.602230055587788*^9, 
   3.6022300559309883`*^9}, {3.6022307317613792`*^9, 
   3.6022307364569874`*^9}, {3.6022307941614885`*^9, 3.602230794567089*^9}, {
   3.602233375089223*^9, 3.6022333898624487`*^9}, {3.6029135627990055`*^9, 
   3.60291356568617*^9}, 3.6029140963325214`*^9, {3.602943141909201*^9, 
   3.602943212849259*^9}, 3.602995774425704*^9, 3.6029959082373576`*^9, {
   3.602995995576353*^9, 3.6029960005556383`*^9}, {3.6029974763840504`*^9, 
   3.6029974875146875`*^9}, {3.603000481871955*^9, 3.603000493072595*^9}, {
   3.6030005284976215`*^9, 3.6030006191468067`*^9}, 3.6030008018372555`*^9, {
   3.603000878459638*^9, 3.6030009545379896`*^9}, {3.6030963410867662`*^9, 
   3.603096342705859*^9}, {3.6030963794319596`*^9, 3.6030963795329657`*^9}, {
   3.6036983564295273`*^9, 3.6036983689582434`*^9}, {3.603698401081081*^9, 
   3.603698431182803*^9}, {3.603698476868416*^9, 3.6036984779384766`*^9}, {
   3.6036986497723055`*^9, 3.6036989475363364`*^9}, {3.603698989365729*^9, 
   3.6036992283904004`*^9}, {3.603699369671481*^9, 3.603699512983678*^9}, {
   3.6036995669807663`*^9, 3.603699567232781*^9}, {3.60369960864215*^9, 
   3.6036996114383097`*^9}, {3.6036996840764637`*^9, 3.603699785491265*^9}, {
   3.603699829027755*^9, 3.603699830841859*^9}, {3.603699875537415*^9, 
   3.6036999033420057`*^9}, {3.6037003600311265`*^9, 3.6037003606641626`*^9}, 
   3.603714985761771*^9, 3.6037150175665903`*^9, {3.603715070759633*^9, 
   3.6037150997942934`*^9}, {3.603719957295127*^9, 3.6037199777792983`*^9}, {
   3.6040366176747265`*^9, 3.6040366412640758`*^9}, {3.6040366963952293`*^9, 
   3.6040366989973783`*^9}, {3.604036769775457*^9, 3.6040367701654577`*^9}, {
   3.604036802270314*^9, 3.604036833033568*^9}, {3.6042974554489994`*^9, 
   3.6042974866537848`*^9}, {3.604298170884066*^9, 3.6042981966145377`*^9}, {
   3.6044599656434393`*^9, 3.6044599673438425`*^9}, {3.60614833369323*^9, 
   3.6061483532712646`*^9}, {3.6073951216434402`*^9, 3.60739512215947*^9}, {
   3.607395159101583*^9, 3.607395175401515*^9}, {3.6094086502076426`*^9, 
   3.609408652352646*^9}, {3.6127085758214483`*^9, 3.6127086470667734`*^9}, {
   3.612708966639769*^9, 3.6127089671233697`*^9}, {3.6127090819083714`*^9, 
   3.6127090875867815`*^9}, 3.613279645351218*^9, 3.6159760991199274`*^9, 
   3.615976221178909*^9, 3.615976744181823*^9, {3.6212330002619343`*^9, 
   3.621233020127071*^9}, {3.6212330638005686`*^9, 3.621233108418121*^9}, {
   3.621233139207882*^9, 3.621233177184054*^9}, {3.6212332578276663`*^9, 
   3.621233262280921*^9}, {3.621233324980507*^9, 3.621233555770708*^9}, {
   3.6212335928778305`*^9, 3.62123374585758*^9}, {3.6212337843277807`*^9, 
   3.6212338173596697`*^9}, {3.6212338505015655`*^9, 
   3.6212338749949665`*^9}, {3.6212339559475965`*^9, 3.621233987423397*^9}, {
   3.6212340266136384`*^9, 3.6212341240772133`*^9}, {3.621234175724167*^9, 
   3.621234375401588*^9}, {3.621234452833017*^9, 3.6212347040593863`*^9}, {
   3.6212348349308715`*^9, 3.6212348555310497`*^9}, {3.621234910131173*^9, 
   3.6212349822602987`*^9}, {3.6212350185163717`*^9, 3.621235085459201*^9}, {
   3.621237366532671*^9, 3.621237411737256*^9}, {3.6212378071258717`*^9, 
   3.6212378337553945`*^9}, {3.621237935967241*^9, 3.621238211896023*^9}, {
   3.6212382698473377`*^9, 3.6212384079502363`*^9}, {3.621238728364563*^9, 
   3.6212387292116117`*^9}, {3.621238830740419*^9, 3.621238833531578*^9}, {
   3.6212392461271777`*^9, 3.6212392863684793`*^9}, {3.6212393522822495`*^9, 
   3.6212393562744775`*^9}, 3.6212395983973265`*^9, {3.621239722107402*^9, 
   3.6212397225544276`*^9}, 3.6212398296195517`*^9, 3.621240111760689*^9, {
   3.6212414105519753`*^9, 3.621241604455066*^9}, {3.6212416462904587`*^9, 
   3.621241646549474*^9}, 3.6212417561547427`*^9, {3.621241992988289*^9, 
   3.621241993927343*^9}, {3.621242590103442*^9, 3.621242617199992*^9}, {
   3.621243342489476*^9, 3.621243369065996*^9}, {3.6212434194768796`*^9, 
   3.6212434499286213`*^9}, 3.621243485135635*^9, {3.6212443271707964`*^9, 
   3.6212443278328342`*^9}, {3.621244775971466*^9, 3.62124480644821*^9}, {
   3.6212669306119175`*^9, 3.621266936227927*^9}, {3.6212669716867895`*^9, 
   3.6212669827472095`*^9}, {3.6212670387437077`*^9, 
   3.6212670451085186`*^9}, {3.6212672699205136`*^9, 3.621267294864958*^9}, {
   3.6212673753922987`*^9, 3.6212673909611263`*^9}, {3.6212674311467967`*^9, 
   3.6212674903801007`*^9}, {3.621267799764906*^9, 3.6212678030090914`*^9}, {
   3.6212689133363247`*^9, 3.621268916080482*^9}, {3.621270777538951*^9, 
   3.621270778539008*^9}, {3.6212709200221004`*^9, 3.621270921559189*^9}, 
   3.621272900470376*^9, {3.6212730754483843`*^9, 3.621273198777438*^9}, {
   3.6212732364205914`*^9, 3.6212734791684756`*^9}, {3.621273550697567*^9, 
   3.6212735543957787`*^9}, {3.621273621541619*^9, 3.621273806257184*^9}, {
   3.6212740714123497`*^9, 3.6212741141237926`*^9}, {3.621274263353485*^9, 
   3.621274275287506*^9}, {3.621274314365575*^9, 3.6212743338812094`*^9}, {
   3.621274540378772*^9, 3.6212745407219725`*^9}, {3.6212774627007046`*^9, 
   3.6212774632623053`*^9}, {3.621346414889677*^9, 3.6213464395040846`*^9}, {
   3.621526117229822*^9, 3.621526119913027*^9}, 3.6215263293745947`*^9, {
   3.621526459868824*^9, 3.621526460446025*^9}, {3.6215744911545935`*^9, 
   3.6215746539899073`*^9}, {3.6215755392685423`*^9, 
   3.6215755496841383`*^9}, {3.62157934050296*^9, 3.621579407409787*^9}, {
   3.6215794388185835`*^9, 3.621579449036168*^9}, {3.621579738054699*^9, 
   3.6215797408228574`*^9}, {3.621579780683137*^9, 3.621579824247629*^9}, {
   3.621580485680461*^9, 3.621580540441593*^9}, {3.6215806639836593`*^9, 
   3.6215806646376963`*^9}, {3.621580747850456*^9, 3.6215807826114445`*^9}, {
   3.621587979901106*^9, 3.6215880215454874`*^9}, {3.6215883980980253`*^9, 
   3.6215883997581205`*^9}, {3.6215910305995955`*^9, 3.621591058669201*^9}, 
   3.621591100908617*^9, {3.621591596245949*^9, 3.621591630062883*^9}, {
   3.621592773990312*^9, 3.6215927741343203`*^9}, {3.621777055778906*^9, 
   3.6217771483578343`*^9}, {3.6217772056874733`*^9, 3.62177720935203*^9}, {
   3.621777321667511*^9, 3.621777508364892*^9}, {3.621780935538426*^9, 
   3.6217811402187853`*^9}, {3.621781223084579*^9, 3.62178125979947*^9}, {
   3.6217813325110984`*^9, 3.6217813396222134`*^9}, {3.6217815443250203`*^9, 
   3.6217815687171974`*^9}, {3.6217820212720313`*^9, 
   3.6217820216765394`*^9}, {3.6217821673287735`*^9, 3.621782195957987*^9}, {
   3.6217823298788137`*^9, 3.6217823328001094`*^9}, {3.621782521477871*^9, 
   3.621782527379466*^9}, {3.621782582831681*^9, 3.6217825874550056`*^9}, {
   3.6217826213608265`*^9, 3.621782621994586*^9}, {3.6217833889822507`*^9, 
   3.6217833940500293`*^9}, {3.6217834469344244`*^9, 
   3.6217834544938374`*^9}, {3.6217840057717333`*^9, 
   3.6217840076588364`*^9}, {3.621785422014118*^9, 3.621785435825366*^9}, {
   3.6217854697022047`*^9, 3.62178548086657*^9}, {3.6217856581285934`*^9, 
   3.6217856584210978`*^9}, {3.6217856902940884`*^9, 3.621785713864951*^9}, {
   3.6217857600239115`*^9, 3.6217857647939844`*^9}, {3.621785861927229*^9, 
   3.621785862572239*^9}, {3.62178637575739*^9, 3.6217863833640184`*^9}, {
   3.621786500709749*^9, 3.6217865015162616`*^9}, {3.6217865479993253`*^9, 
   3.621786548417832*^9}, {3.621829905118165*^9, 3.6218299409378276`*^9}, {
   3.6218313155179815`*^9, 3.621831321820392*^9}, {3.621831748148846*^9, 
   3.621831752704054*^9}, {3.62183666795435*^9, 3.6218366963307996`*^9}, {
   3.621837573409544*^9, 3.621837574345546*^9}, 3.621838686262958*^9, {
   3.6218406500132446`*^9, 3.6218406856593075`*^9}, {3.621841309550804*^9, 
   3.6218413134040103`*^9}, {3.621842025862212*^9, 3.6218421442352204`*^9}, {
   3.6218422092698903`*^9, 3.6218422242771163`*^9}, {3.6218422723196015`*^9, 
   3.6218422755644073`*^9}, {3.621842363363762*^9, 3.6218423643777637`*^9}, {
   3.6218424840420003`*^9, 3.62184250659964*^9}, {3.6218603377584705`*^9, 
   3.621860371803748*^9}, {3.6218783281070004`*^9, 3.6218785368007374`*^9}, {
   3.621878977117501*^9, 3.621879138527753*^9}, 3.621879170543498*^9, {
   3.62187929578794*^9, 3.621879313048709*^9}, {3.621917705923849*^9, 
   3.6219177950769715`*^9}, {3.621918190775628*^9, 3.621918243379689*^9}, {
   3.621918317157076*^9, 3.621918346374277*^9}, {3.621918575455056*^9, 
   3.6219186178082085`*^9}, {3.6219189961292458`*^9, 
   3.6219190185658417`*^9}, {3.6219190760392303`*^9, 
   3.6219191028181443`*^9}, {3.621919255086749*^9, 3.621919275699568*^9}, {
   3.621919964261272*^9, 3.621919979933014*^9}, {3.621922014309088*^9, 
   3.6219220545944614`*^9}, {3.6219221018239403`*^9, 3.621922107238524*^9}, {
   3.6219276828477*^9, 3.6219277399178295`*^9}, {3.62192792708348*^9, 
   3.621927930724786*^9}, {3.621927981266817*^9, 3.621927983186846*^9}, {
   3.6219307373261595`*^9, 3.6219307796397247`*^9}, 3.6219308346195197`*^9, {
   3.6219308872682676`*^9, 3.6219308924268656`*^9}, {3.621934623973336*^9, 
   3.6219346480892067`*^9}, {3.6219347038100657`*^9, 3.621934728088689*^9}, {
   3.6219347869350967`*^9, 3.621934864456788*^9}, {3.6219349235069466`*^9, 
   3.621934971813939*^9}, 3.621935115742877*^9, {3.621935151154171*^9, 
   3.6219351944710875`*^9}, {3.6219355611850386`*^9, 
   3.6219355735509787`*^9}, {3.621935712388118*^9, 3.6219357157331696`*^9}, {
   3.6219358176119857`*^9, 3.6219358812889643`*^9}, {3.621935961905102*^9, 
   3.621936061316129*^9}, {3.621936252043792*^9, 3.6219362552725916`*^9}, {
   3.621936529697872*^9, 3.6219366082480826`*^9}, {3.6219369855361133`*^9, 
   3.6219370244397135`*^9}, {3.6219371608775744`*^9, 
   3.6219372462751436`*^9}, {3.6219372906490765`*^9, 
   3.6219373211527987`*^9}, {3.621937382250989*^9, 3.6219374960624943`*^9}, {
   3.621937538152643*^9, 3.621937544904499*^9}, {3.621937588792925*^9, 
   3.6219375889441776`*^9}, {3.621937635561902*^9, 3.621937652097906*^9}, {
   3.6219394257305512`*^9, 3.621939535531743*^9}, {3.621939572980072*^9, 
   3.621939622826846*^9}, {3.6219396534725695`*^9, 3.6219397206788564`*^9}, {
   3.6219398310081606`*^9, 3.6219398466091824`*^9}, 3.621939896891842*^9, {
   3.6219399900923915`*^9, 3.6219400984373245`*^9}, {3.6219401448250437`*^9, 
   3.6219402193241997`*^9}, {3.621954326839961*^9, 3.621954332597371*^9}, {
   3.621955723584013*^9, 3.621955724161214*^9}, {3.621955767181292*^9, 
   3.6219557792909136`*^9}, {3.6219590527501173`*^9, 
   3.6219590798221645`*^9}, {3.6219592221620355`*^9, 3.621959238642665*^9}, {
   3.6219621648628283`*^9, 3.6219622327539496`*^9}, {3.6219635158008084`*^9, 
   3.6219635694963055`*^9}, {3.621963857564521*^9, 3.6219638917609835`*^9}, {
   3.621967306987949*^9, 3.6219673332507954`*^9}, {3.621971049160574*^9, 
   3.621971110969283*^9}, {3.621971294824112*^9, 3.6219713140629454`*^9}, {
   3.6219725399367867`*^9, 3.621972550376205*^9}, 3.6219726082603073`*^9, {
   3.6219732012323737`*^9, 3.621973233407631*^9}, {3.6219735610237894`*^9, 
   3.6219736116598787`*^9}, {3.6220060611808233`*^9, 
   3.6220060745686474`*^9}, {3.622046593089623*^9, 3.622046596053628*^9}, {
   3.622049322846985*^9, 3.622049330473849*^9}, {3.6223895031995463`*^9, 
   3.6223895039483476`*^9}, 3.6223899073054714`*^9, {3.641152658139067*^9, 
   3.641153383536669*^9}, {3.6411534194937725`*^9, 3.6411534330259285`*^9}, {
   3.641153562406846*^9, 3.64115359593962*^9}, {3.6411547248493385`*^9, 
   3.6411547740826893`*^9}, {3.641154825569203*^9, 3.641154846590076*^9}, 
   3.6411557015579214`*^9, {3.6412474373296824`*^9, 3.6412474799532385`*^9}, {
   3.6412476361887307`*^9, 3.641247662595234*^9}, {3.6412479087351704`*^9, 
   3.6412479277689652`*^9}, {3.6412479628602448`*^9, 
   3.6412479818926425`*^9}, {3.641248023308259*^9, 3.641248064530526*^9}, {
   3.641248289238597*^9, 3.6412483113055477`*^9}, {3.6412483495188313`*^9, 
   3.641248349643832*^9}, {3.6413162646514997`*^9, 3.64131629725132*^9}, {
   3.641316361915925*^9, 3.6413164276927395`*^9}, {3.6413164649142847`*^9, 
   3.6413165330445366`*^9}, {3.641318612287731*^9, 3.6413186291785145`*^9}, {
   3.641663336248727*^9, 3.641663342732314*^9}, {3.6416691906395903`*^9, 
   3.641669368459526*^9}, {3.6416694142736287`*^9, 3.6416697693660765`*^9}, {
   3.6416699607171874`*^9, 3.641669962157259*^9}, {3.641677943646654*^9, 
   3.641677948288726*^9}, {3.6416781537412663`*^9, 3.641678212127894*^9}, {
   3.6416782590529137`*^9, 3.641678371953929*^9}, {3.641678540041363*^9, 
   3.6416785493087015`*^9}, {3.6416785812938557`*^9, 
   3.6416786135452123`*^9}, {3.641678643916754*^9, 3.641678693981888*^9}, {
   3.6416787939678965`*^9, 3.64167882498138*^9}, {3.641678862388879*^9, 
   3.6416788631082816`*^9}, {3.641678909888339*^9, 3.641678915607916*^9}, {
   3.6416789535738864`*^9, 3.6416790205763426`*^9}, {3.6416791674837503`*^9, 
   3.6416791728744464`*^9}, {3.6416792945043793`*^9, 
   3.6416793520673776`*^9}, {3.6416794064897003`*^9, 3.641679425005477*^9}, {
   3.641679458913615*^9, 3.6416795154679623`*^9}, {3.6419848036654463`*^9, 
   3.6419848196736913`*^9}, {3.6420024149359336`*^9, 3.642002420291833*^9}, 
   3.6420025431609235`*^9, {3.6420025887733736`*^9, 3.642002887233524*^9}, {
   3.642002934373904*^9, 3.6420029861488895`*^9}, {3.6420030333637543`*^9, 
   3.6420030855691075`*^9}, 3.6420031213997555`*^9, {3.642003155270647*^9, 
   3.6420031637876625`*^9}, {3.6420032214746075`*^9, 3.642003242616245*^9}, {
   3.642004283660613*^9, 3.64200432840889*^9}, {3.642004431006479*^9, 
   3.642004451189131*^9}, 3.6420045500168147`*^9, {3.642004599960501*^9, 
   3.6420046109561157`*^9}, {3.642004743031557*^9, 3.642004752477306*^9}, {
   3.6420048325871935`*^9, 3.6420048807997847`*^9}, 3.642015262491372*^9, {
   3.6420154002833757`*^9, 3.642015400397476*^9}, {3.642015442469143*^9, 
   3.6420154573476543`*^9}, {3.6420155106219273`*^9, 3.642015532958993*^9}, {
   3.642015564607443*^9, 3.6420155709418983`*^9}, {3.642015614436632*^9, 
   3.6420156148228965`*^9}, {3.6420156966432223`*^9, 3.64201569853856*^9}, {
   3.6420157608567715`*^9, 3.642015762153658*^9}, {3.6420158123095264`*^9, 
   3.642015847204176*^9}, {3.6420607560036144`*^9, 3.642060799781307*^9}, {
   3.642084903745249*^9, 3.642084913318552*^9}, {3.6488034087667727`*^9, 
   3.648803429318816*^9}, 3.6488037122677207`*^9, {3.6488039840415754`*^9, 
   3.6488040340651283`*^9}, {3.6488269201513085`*^9, 3.648826921057568*^9}, 
   3.648890317922845*^9, {3.6488923322014437`*^9, 3.6488923333577075`*^9}, {
   3.6489350947840223`*^9, 3.6489352480023146`*^9}, {3.6489354591501503`*^9, 
   3.648935502744089*^9}, {3.648935536518777*^9, 3.648935793214138*^9}, {
   3.6489360307969494`*^9, 3.6489361527096844`*^9}, {3.648936330475607*^9, 
   3.6489363353089557`*^9}, {3.648974787029746*^9, 3.6489748137701006`*^9}, {
   3.6489748439821405`*^9, 3.6489748450915256`*^9}, {3.6489754052795076`*^9, 
   3.6489754075607767`*^9}, {3.6489754493409963`*^9, 
   3.6489755413951745`*^9}, {3.648975693051486*^9, 3.64897570483673*^9}, {
   3.648975758184078*^9, 3.6489757797837467`*^9}, {3.648981677592518*^9, 
   3.6489816819831996`*^9}, {3.6489822375893393`*^9, 3.648982258240199*^9}, {
   3.6489907720611544`*^9, 3.648990795877912*^9}, {3.648990999412507*^9, 
   3.648991019089803*^9}, {3.6490247116000338`*^9, 3.649024873487891*^9}, {
   3.6490257325454826`*^9, 3.6490257360299015`*^9}, {3.6491715602832146`*^9, 
   3.6491715611738486`*^9}, {3.6491734457373652`*^9, 
   3.6491734880059423`*^9}, {3.649173562449072*^9, 3.649173565950635*^9}, {
   3.6495331203896284`*^9, 3.6495333292727876`*^9}, {3.6495345052187853`*^9, 
   3.6495345330754185`*^9}, {3.649534651347715*^9, 3.649534658944684*^9}, {
   3.6496007231444054`*^9, 3.649600730738228*^9}, {3.649601580648828*^9, 
   3.6496015820238457`*^9}, {3.64960161689815*^9, 3.649601706271*^9}, {
   3.649601742007561*^9, 3.6496017589141703`*^9}, {3.649601858097133*^9, 
   3.6496020307547865`*^9}, {3.649602074516796*^9, 3.6496021087691336`*^9}, {
   3.649602162352887*^9, 3.649602299713805*^9}, {3.6496023547903905`*^9, 
   3.649602355384145*^9}, {3.649602426933305*^9, 3.6496030726136804`*^9}, 
   3.649603112254395*^9, {3.6496042353551455`*^9, 3.649604250699957*^9}, {
   3.649604309315129*^9, 3.6496043269220448`*^9}, {3.649604453493013*^9, 
   3.6496044823291683`*^9}, {3.6496046427129807`*^9, 3.649604663267518*^9}, {
   3.6496047586374645`*^9, 3.649604759668724*^9}, {3.649604900625437*^9, 
   3.649605021519856*^9}, {3.649605100180196*^9, 3.649605125710761*^9}, {
   3.6496075828160105`*^9, 3.6496076334195967`*^9}, {3.649612114547909*^9, 
   3.6496121153109317`*^9}, {3.6496619689681625`*^9, 3.649662048651778*^9}, {
   3.649664260755787*^9, 3.6496643299177885`*^9}, {3.6496643645737667`*^9, 
   3.6496644143704157`*^9}, {3.6496644514075966`*^9, 
   3.6496644586914487`*^9}, {3.649664493348879*^9, 3.649664531965005*^9}, {
   3.64966460206013*^9, 3.649664605848925*^9}, 3.649665103198258*^9, {
   3.649683126569213*^9, 3.6496834825970078`*^9}, {3.649683568346365*^9, 
   3.64968359191543*^9}, {3.649683932743315*^9, 3.649684230707288*^9}, {
   3.649684591695336*^9, 3.649684605964039*^9}, {3.649684735311468*^9, 
   3.6496847538736877`*^9}, {3.64968479044557*^9, 3.6496847955393643`*^9}, {
   3.649684853659749*^9, 3.649684914618099*^9}, {3.649684977332818*^9, 
   3.6496851210687256`*^9}, {3.649687466201195*^9, 3.64968748094165*^9}, {
   3.6496875340726337`*^9, 3.649687544672761*^9}, {3.649688083268279*^9, 
   3.649688363058158*^9}, {3.6496884170796638`*^9, 3.6496884336749935`*^9}, {
   3.6496884700673146`*^9, 3.6496886496424565`*^9}, {3.6496887769791365`*^9, 
   3.6496888440460567`*^9}, {3.6496888848931293`*^9, 
   3.6496888913655205`*^9}, {3.6496942975646224`*^9, 
   3.6496945509628496`*^9}, {3.649694590897425*^9, 3.649694701914793*^9}, {
   3.649694735138938*^9, 3.6496947479163437`*^9}, {3.649694806831876*^9, 
   3.649694830801711*^9}, {3.649694874751917*^9, 3.649694882373395*^9}, {
   3.6497084444265285`*^9, 3.6497086229777126`*^9}, {3.6497086566663666`*^9, 
   3.6497086574007483`*^9}, {3.649708698016097*^9, 3.649708711218729*^9}, {
   3.6497087597697706`*^9, 3.6497088398924627`*^9}, {3.649708928277959*^9, 
   3.649709074639885*^9}, {3.649710541661715*^9, 3.6497107196774964`*^9}, {
   3.649710774374589*^9, 3.6497107756683855`*^9}, {3.6497108106756344`*^9, 
   3.649710942561676*^9}, {3.64971104269436*^9, 3.649711049457201*^9}, {
   3.6497110856040273`*^9, 3.6497110931433697`*^9}, {3.64975160409785*^9, 
   3.6497516267386684`*^9}, {3.6497521294006977`*^9, 3.649752134681994*^9}, {
   3.650058016856728*^9, 3.6500581696208053`*^9}, {3.6500585412217464`*^9, 
   3.6500585963344584`*^9}, {3.650058634857835*^9, 3.65005880048958*^9}, {
   3.650058833570309*^9, 3.650058973812615*^9}, {3.6500590627481527`*^9, 
   3.6500590767790947`*^9}, {3.6500595042182407`*^9, 3.650059520198344*^9}, {
   3.650059675022875*^9, 3.650059679659378*^9}, {3.650060074510356*^9, 
   3.6500600804968567`*^9}, {3.6501355000675664`*^9, 
   3.6501355498443527`*^9}, {3.6501376205052137`*^9, 
   3.6501379093098755`*^9}, {3.6501379463258047`*^9, 3.650137993123067*^9}, {
   3.6501380296312294`*^9, 3.6501380417406993`*^9}, {3.650138072027849*^9, 
   3.650138115812213*^9}, {3.6501381694063897`*^9, 3.6501383943473625`*^9}, {
   3.6501392042273817`*^9, 3.65013924511856*^9}, {3.652209452843474*^9, 
   3.652209503226533*^9}, {3.652267005440235*^9, 3.6522670068308697`*^9}, {
   3.652267166755729*^9, 3.652267179554284*^9}, {3.6523119728731136`*^9, 
   3.6523120115318613`*^9}, {3.6523126400698624`*^9, 
   3.6523126752957773`*^9}, {3.6523128100306354`*^9, 
   3.6523128246259584`*^9}, {3.652312880669179*^9, 3.652312884375801*^9}, {
   3.652315788712077*^9, 3.6523157918422904`*^9}, {3.652358215846537*^9, 
   3.6523582835255404`*^9}, {3.653467497321311*^9, 3.6534675778723907`*^9}, {
   3.653467696310006*^9, 3.6534677884760356`*^9}, {3.6534678513641806`*^9, 
   3.6534678901155767`*^9}, {3.653467921006519*^9, 3.6534679622097325`*^9}, {
   3.6534679952569304`*^9, 3.6534680462052393`*^9}, {3.653468107143365*^9, 
   3.6534681130184245`*^9}, {3.653468467423293*^9, 3.6534685233899913`*^9}, {
   3.653468560734124*^9, 3.6534687183306427`*^9}, {3.6534687585810566`*^9, 
   3.653468787690729*^9}, {3.6534688522882395`*^9, 3.6534688873733397`*^9}, {
   3.65346893405175*^9, 3.6534690194205647`*^9}, {3.6534690663696604`*^9, 
   3.6534690900678644`*^9}, 3.6534691487209854`*^9, 3.6534692180162487`*^9, {
   3.653470892227764*^9, 3.653470907509273*^9}, {3.6534711228832026`*^9, 
   3.653471158971959*^9}, {3.65351372403915*^9, 3.653513796612208*^9}, {
   3.6559033775628223`*^9, 3.655903410344462*^9}, {3.6559035829590373`*^9, 
   3.6559039799439297`*^9}, {3.655904086320739*^9, 3.6559042374156904`*^9}, {
   3.6559042758667192`*^9, 3.6559044915765305`*^9}, {3.6559045273244724`*^9, 
   3.6559046267211323`*^9}, {3.655904667112239*^9, 3.655904675752966*^9}, {
   3.6559047160972476`*^9, 3.655904976819119*^9}, {3.6559050398889513`*^9, 
   3.655905142370371*^9}, {3.655905208576679*^9, 3.655905212014163*^9}, {
   3.655909765600686*^9, 3.655909789712*^9}, {3.6559118625942745`*^9, 
   3.6559120210720444`*^9}, {3.6559120576670246`*^9, 
   3.6559120584326587`*^9}, {3.6559140895716667`*^9, 
   3.6559141613300943`*^9}, {3.655915162991477*^9, 3.6559151979526834`*^9}, {
   3.655915387979005*^9, 3.655915798719816*^9}, {3.6559158380021095`*^9, 
   3.655916048816142*^9}, {3.6559161505032654`*^9, 3.6559161886167545`*^9}, {
   3.6559162461426597`*^9, 3.6559162613098593`*^9}, {3.655916314089177*^9, 
   3.6559163655683913`*^9}, {3.655917169193136*^9, 3.655917245144165*^9}, {
   3.655917310926583*^9, 3.6559173408521385`*^9}, {3.65591754173892*^9, 
   3.6559177106211596`*^9}, {3.6559181697202606`*^9, 3.655918322576687*^9}, {
   3.6559183576015425`*^9, 3.6559183738645163`*^9}, {3.655919987127823*^9, 
   3.6559200937338147`*^9}, {3.655920229188808*^9, 3.6559203547159014`*^9}, {
   3.6559215008808947`*^9, 3.6559217059262595`*^9}, {3.655921803665161*^9, 
   3.6559218527802844`*^9}, {3.6559222632873077`*^9, 
   3.6559222802021875`*^9}, {3.6559223230602465`*^9, 3.655922326311695*^9}, {
   3.6559223826834545`*^9, 3.6559223910440583`*^9}, {3.6559224334152393`*^9, 
   3.6559224654526386`*^9}, {3.6559225228495693`*^9, 3.655922594797303*^9}, {
   3.6559230399542675`*^9, 3.6559230485011673`*^9}, {3.6559231200693455`*^9, 
   3.6559231232399626`*^9}, {3.6559237102118273`*^9, 3.655923722568249*^9}, {
   3.655923937968996*^9, 3.6559240940542126`*^9}, {3.6560955529343987`*^9, 
   3.6560956204865475`*^9}, {3.656095677080618*^9, 3.656095678870897*^9}, {
   3.6560966486112103`*^9, 3.6560966495018425`*^9}, {3.6560982009834843`*^9, 
   3.656098204358515*^9}, {3.6560983338128633`*^9, 3.65609835869228*^9}, {
   3.656098391779984*^9, 3.6560983937487535`*^9}, {3.6560984806780815`*^9, 
   3.656098538673654*^9}, {3.656272126185845*^9, 3.6562721411100683`*^9}, {
   3.656272182102259*^9, 3.656272185370568*^9}, {3.656499926440303*^9, 
   3.656499990775908*^9}, {3.6565000266686115`*^9, 3.6565000480131855`*^9}, {
   3.6565001945416107`*^9, 3.6565004732634935`*^9}, {3.65650057019965*^9, 
   3.656500611150279*^9}, {3.656500683162779*^9, 3.6565007883506966`*^9}, {
   3.656500851076388*^9, 3.6565008861251817`*^9}, {3.65651204619003*^9, 
   3.6565122139163*^9}, {3.656512260277774*^9, 3.656512394194894*^9}, {
   3.65651243537475*^9, 3.656512699100842*^9}, {3.656512759647215*^9, 
   3.656512763279192*^9}, {3.656512836385004*^9, 3.6565129793457465`*^9}, {
   3.6565130194647694`*^9, 3.656513088558637*^9}, {3.6565132075681715`*^9, 
   3.6565132199745502`*^9}, {3.656584595738651*^9, 3.6565846252233286`*^9}, {
   3.657314024016385*^9, 3.6573141477542768`*^9}, {3.6573141924330945`*^9, 
   3.6573143362530127`*^9}, {3.657314372960434*^9, 3.657314451937585*^9}, {
   3.657314502014596*^9, 3.6573146389341254`*^9}, {3.6573146749574823`*^9, 
   3.6573147912912235`*^9}, {3.6573148339387274`*^9, 3.657314859072728*^9}, {
   3.657315024660161*^9, 3.65731502522272*^9}, {3.6573151553185916`*^9, 
   3.6573152776000333`*^9}, 3.6573153102358522`*^9, {3.657315386354059*^9, 
   3.657315390369796*^9}, 3.657315849160017*^9, {3.657315957447778*^9, 
   3.657315979994988*^9}, {3.6573938898281336`*^9, 3.6573940902060947`*^9}, {
   3.657394128300408*^9, 3.657394195609679*^9}, {3.6573942761536183`*^9, 
   3.657394418198121*^9}, {3.6573944486393557`*^9, 3.6573944910060835`*^9}, {
   3.65739453478798*^9, 3.6573946344481*^9}, {3.657394685995737*^9, 
   3.6573949199384813`*^9}, {3.6576558431931725`*^9, 
   3.6576559272319593`*^9}, {3.657656256744691*^9, 3.657656621779212*^9}, {
   3.6576568587458687`*^9, 3.657656862131169*^9}, {3.6576570768160048`*^9, 
   3.6576571547501097`*^9}, {3.6576571921614847`*^9, 
   3.6576571955632687`*^9}, {3.6576643188781395`*^9, 
   3.6576643516237054`*^9}, {3.65766447624356*^9, 3.6576644934707184`*^9}, {
   3.657993924349655*^9, 3.6579939427564945`*^9}, {3.6579939746174326`*^9, 
   3.6579940482118134`*^9}, {3.6579940893098793`*^9, 
   3.6579941874172764`*^9}, {3.6579942748390994`*^9, 3.657994287228136*^9}, {
   3.6579943337212925`*^9, 3.657994440339776*^9}, {3.6579953765310907`*^9, 
   3.657995424612873*^9}, {3.658003362723033*^9, 3.6580033912993503`*^9}, {
   3.663357777469425*^9, 3.6633578330713224`*^9}, {3.6633578757486954`*^9, 
   3.663357948422894*^9}, {3.663357992596091*^9, 3.6633579933331394`*^9}, {
   3.6633583014340286`*^9, 3.663358429303893*^9}, {3.663358515723521*^9, 
   3.663358517996009*^9}, {3.663358557499445*^9, 3.663358754129057*^9}, {
   3.663358797551422*^9, 3.6633591242258244`*^9}, {3.6633591593828917`*^9, 
   3.663359159905525*^9}, {3.6633591981511555`*^9, 3.66335924331194*^9}, {
   3.66497883031569*^9, 3.664978831453204*^9}, {3.6649788703272295`*^9, 
   3.664979256550037*^9}, {3.664979504607872*^9, 3.6649796656759853`*^9}, {
   3.664979720746095*^9, 3.664979741843167*^9}, {3.6649797939994864`*^9, 
   3.6649798837166967`*^9}, {3.664979915496761*^9, 3.6649799557487946`*^9}, {
   3.664980098248025*^9, 3.6649801003790846`*^9}, {3.6649878422025647`*^9, 
   3.664987919414427*^9}, 3.665856103325365*^9, {3.6658565315898933`*^9, 
   3.6658565972756815`*^9}, {3.665856628248652*^9, 3.6658566628489447`*^9}, {
   3.66585670183406*^9, 3.6658567145101757`*^9}, {3.665857253901951*^9, 
   3.665857285218116*^9}, {3.665857365618902*^9, 3.6658573913473434`*^9}, {
   3.6658586998005304`*^9, 3.665858706888776*^9}, {3.666028500287612*^9, 
   3.66602854337737*^9}, {3.6660286005840197`*^9, 3.6660286889064465`*^9}, {
   3.66602875771447*^9, 3.6660289484236126`*^9}, {3.666028989230996*^9, 
   3.6660289975790944`*^9}, 3.66602939338018*^9, {3.666167593925926*^9, 
   3.666167645604035*^9}, {3.6696733447234755`*^9, 3.66967336704379*^9}, {
   3.6696735026281137`*^9, 3.669673508823384*^9}, {3.6696745156967487`*^9, 
   3.669674516973898*^9}, {3.669891424684828*^9, 3.6698916447231493`*^9}, {
   3.6699319697869864`*^9, 3.6699319898402348`*^9}, {3.669932069827885*^9, 
   3.6699321229066563`*^9}, {3.6699327237030897`*^9, 3.66993274182361*^9}, {
   3.669932880143398*^9, 3.6699328833422337`*^9}, {3.670012091555955*^9, 
   3.6700122359819717`*^9}, {3.6700122932756033`*^9, 3.67001231952803*^9}, {
   3.6700123581805983`*^9, 3.6700124695716534`*^9}, {3.6701089564281435`*^9, 
   3.6701090122279043`*^9}, {3.6701790468603907`*^9, 3.670179063119768*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.6661695074810305`*^9, 3.666169509528839*^9}, 
   3.666170126946135*^9}]
},
Evaluator->"Local 2",
WindowSize->{766, 792},
WindowMargins->{{Automatic, -7}, {-7, Automatic}},
CellContext->Notebook,
Magnification->0.8999999761581421,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 56476, 1055, 2210, "Input"],
Cell[57036, 1077, 120, 2, 29, "Input"]
}
]
*)

(* End of internal cache information *)
