"""
    FactSet ESG API

    FactSet ESG (powered by FactSet Truvalue Labs) applies machine learning to uncover risks and opportunities from companies' Environmental, Social and Governance (ESG) behavior, which are aggregated and categorized into continuously updated, material ESG scores. The service focuses on company ESG behavior from external sources and includes both positive and negative events that go beyond traditional sources of ESG risk data.<p> FactSet ESG extracts, analyzes, and generates scores from millions of documents each month collected from more than 100,000 data sources in over 30 languages. Sources include news, trade journals, NGOs, watchdog groups, trade blogs, industry reports and social media. Products deliver investable insights by revealing value and risk factors from unstructured data at the speed of current events.</p>   # noqa: E501

    The version of the OpenAPI document: 1.5.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fds.sdk.FactSetESG.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from fds.sdk.FactSetESG.exceptions import ApiAttributeError



class FieldsSdgSpotlights(ModelSimple):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'value': ([str],),
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {}

    read_only_vars = set()

    _composed_schemas = None

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):
        """FieldsSdgSpotlights - a model defined in OpenAPI

        Note that value can be passed either in args or in kwargs, but not in both.

        Args:
            args[0] ([str]): Request available SDG Spotlights data fields to be included in the response. Default is all fields. _fsymId_,_orgId_, _date_, _spotlightId_, _groupId_ and _requestId_ are always included.     |field|description|   |----|----|   |orgId|Unique identifier assigned by Truvalue that is applied on an organization level |   |spotlightId|Unique identifier assigned by Truvalue identifying a Spotlight ESG event that is detected at the company level, within a single category. |   |orgName|The current name of the organization according to Truvalue (not point-in-time)|   |groupId|Unique identifier assigned by Truvalue identifying a Spotlight group using the Spotlight ID of the Primary Spotlight. |   |primarySpotlight|Value indicating the primary Spotlight in a Spotlight Group. It could be either \"Yes\" or \"No\".|   |spotlightCategory|SDG category tagged to each Spotlight.|    |status|Indicates status of a spotlight, which can be one of Completed or Ongoing. |   |removed|Displays the date a Spotlight was removed from the dataset, if it has been removed.|    |startDate|Date when a Spotlight has met the volume threshold for Spotlight consideration. Score and volume change metadata are associated with this date.|   |liveDate|Date when a Spotlight meets confidence threshold and is considered a Spotlight. This date should never precede start_date. |             |firstArticleDate|Date of earliest article in the Spotlight as of the Start Date. |   |finalArticleDate|Date of final article in the Spotlight. This value can change over the course of the Spotlight until the Spotlight is marked as completed.|       |organizationalVolumeThreshold| The article volume needed to create a Spotlight, as set by the company's overall volume level classification on the Start Date. |    |totalSpotlightVolume|Total number of articles in the Spotlight. This number will change until the Spotlight is marked as completed.|             |startDateVolume|Number of articles in the Spotlight on the Start Date when it met the volume threshold. Does not include the number of articles that were added to the Spotlight after the Spotlight Start Date.|   |primaryArticleSource|Source of the primary article.|    |primaryArticleUrl|URL of the primary article.|              |primaryArticleHeadline|Headline of primary Spotlight article.|             |primaryArticleBulletpoints|Bullet points summarizing the primary article. |   |meanArtScoreFinalDate|Average score of articles in Spotlight on Final Article Date. This score will continue to change until the Spotlight is marked as completed.|      |meanArtScoreStartDate|Average score of articles in Spotlight on Start Date. This score will not change throughout the history of the spotlight.|             |meanPulseScore|Average of pulse scores for each day from First Article Date to Final Article Date, including scores for both Start Date and Final Article Date.|   |primaryArticleSource|Headline of primary Spotlight article.|    |pulseBeforeFirstArticle|Pulse score for category at end-of-day on day before the First Article Date. |              |pulseOnFinalArticleDate|Pulse score for category at the end-of-day on the Final Article Date.|             |pulseOnStartDate|Pulse score for the category at the end-of-day on the Start Date. |   |zScoreOnFinalDate|Z-score for Spotlight as of Final Article Date. This score will continue to change until the Spotlight is marked as completed.|          |zScoreOnStartDate|Z-score for Spotlight as of Start Date. This score will not change throughout the history of the spotlight.|   |startoutLvlOnFinalDate|Describes if the spotlight is a High, Medium, or Low standout spotlight.  This score will continue to change until the Spotlight is marked as completed.|    |startoutLvlOnStartDate|Describes if the spotlight is a High, Medium, or Low standout spotlight.|           .  # noqa: E501

        Keyword Args:
            value ([str]): Request available SDG Spotlights data fields to be included in the response. Default is all fields. _fsymId_,_orgId_, _date_, _spotlightId_, _groupId_ and _requestId_ are always included.     |field|description|   |----|----|   |orgId|Unique identifier assigned by Truvalue that is applied on an organization level |   |spotlightId|Unique identifier assigned by Truvalue identifying a Spotlight ESG event that is detected at the company level, within a single category. |   |orgName|The current name of the organization according to Truvalue (not point-in-time)|   |groupId|Unique identifier assigned by Truvalue identifying a Spotlight group using the Spotlight ID of the Primary Spotlight. |   |primarySpotlight|Value indicating the primary Spotlight in a Spotlight Group. It could be either \"Yes\" or \"No\".|   |spotlightCategory|SDG category tagged to each Spotlight.|    |status|Indicates status of a spotlight, which can be one of Completed or Ongoing. |   |removed|Displays the date a Spotlight was removed from the dataset, if it has been removed.|    |startDate|Date when a Spotlight has met the volume threshold for Spotlight consideration. Score and volume change metadata are associated with this date.|   |liveDate|Date when a Spotlight meets confidence threshold and is considered a Spotlight. This date should never precede start_date. |             |firstArticleDate|Date of earliest article in the Spotlight as of the Start Date. |   |finalArticleDate|Date of final article in the Spotlight. This value can change over the course of the Spotlight until the Spotlight is marked as completed.|       |organizationalVolumeThreshold| The article volume needed to create a Spotlight, as set by the company's overall volume level classification on the Start Date. |    |totalSpotlightVolume|Total number of articles in the Spotlight. This number will change until the Spotlight is marked as completed.|             |startDateVolume|Number of articles in the Spotlight on the Start Date when it met the volume threshold. Does not include the number of articles that were added to the Spotlight after the Spotlight Start Date.|   |primaryArticleSource|Source of the primary article.|    |primaryArticleUrl|URL of the primary article.|              |primaryArticleHeadline|Headline of primary Spotlight article.|             |primaryArticleBulletpoints|Bullet points summarizing the primary article. |   |meanArtScoreFinalDate|Average score of articles in Spotlight on Final Article Date. This score will continue to change until the Spotlight is marked as completed.|      |meanArtScoreStartDate|Average score of articles in Spotlight on Start Date. This score will not change throughout the history of the spotlight.|             |meanPulseScore|Average of pulse scores for each day from First Article Date to Final Article Date, including scores for both Start Date and Final Article Date.|   |primaryArticleSource|Headline of primary Spotlight article.|    |pulseBeforeFirstArticle|Pulse score for category at end-of-day on day before the First Article Date. |              |pulseOnFinalArticleDate|Pulse score for category at the end-of-day on the Final Article Date.|             |pulseOnStartDate|Pulse score for the category at the end-of-day on the Start Date. |   |zScoreOnFinalDate|Z-score for Spotlight as of Final Article Date. This score will continue to change until the Spotlight is marked as completed.|          |zScoreOnStartDate|Z-score for Spotlight as of Start Date. This score will not change throughout the history of the spotlight.|   |startoutLvlOnFinalDate|Describes if the spotlight is a High, Medium, or Low standout spotlight.  This score will continue to change until the Spotlight is marked as completed.|    |startoutLvlOnStartDate|Describes if the spotlight is a High, Medium, or Low standout spotlight.|           .  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """
        # required up here when default value is not given
        _path_to_item = kwargs.pop('_path_to_item', ())

        if 'value' in kwargs:
            value = kwargs.pop('value')
        elif args:
            args = list(args)
            value = args.pop(0)
        else:
            raise ApiTypeError(
                "value is required, but not passed in args or kwargs and doesn't have default",
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)
        self.value = value
        if kwargs:
            raise ApiTypeError(
                "Invalid named arguments=%s passed to %s. Remove those invalid named arguments." % (
                    kwargs,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):
        """FieldsSdgSpotlights - a model defined in OpenAPI

        Note that value can be passed either in args or in kwargs, but not in both.

        Args:
            args[0] ([str]): Request available SDG Spotlights data fields to be included in the response. Default is all fields. _fsymId_,_orgId_, _date_, _spotlightId_, _groupId_ and _requestId_ are always included.     |field|description|   |----|----|   |orgId|Unique identifier assigned by Truvalue that is applied on an organization level |   |spotlightId|Unique identifier assigned by Truvalue identifying a Spotlight ESG event that is detected at the company level, within a single category. |   |orgName|The current name of the organization according to Truvalue (not point-in-time)|   |groupId|Unique identifier assigned by Truvalue identifying a Spotlight group using the Spotlight ID of the Primary Spotlight. |   |primarySpotlight|Value indicating the primary Spotlight in a Spotlight Group. It could be either \"Yes\" or \"No\".|   |spotlightCategory|SDG category tagged to each Spotlight.|    |status|Indicates status of a spotlight, which can be one of Completed or Ongoing. |   |removed|Displays the date a Spotlight was removed from the dataset, if it has been removed.|    |startDate|Date when a Spotlight has met the volume threshold for Spotlight consideration. Score and volume change metadata are associated with this date.|   |liveDate|Date when a Spotlight meets confidence threshold and is considered a Spotlight. This date should never precede start_date. |             |firstArticleDate|Date of earliest article in the Spotlight as of the Start Date. |   |finalArticleDate|Date of final article in the Spotlight. This value can change over the course of the Spotlight until the Spotlight is marked as completed.|       |organizationalVolumeThreshold| The article volume needed to create a Spotlight, as set by the company's overall volume level classification on the Start Date. |    |totalSpotlightVolume|Total number of articles in the Spotlight. This number will change until the Spotlight is marked as completed.|             |startDateVolume|Number of articles in the Spotlight on the Start Date when it met the volume threshold. Does not include the number of articles that were added to the Spotlight after the Spotlight Start Date.|   |primaryArticleSource|Source of the primary article.|    |primaryArticleUrl|URL of the primary article.|              |primaryArticleHeadline|Headline of primary Spotlight article.|             |primaryArticleBulletpoints|Bullet points summarizing the primary article. |   |meanArtScoreFinalDate|Average score of articles in Spotlight on Final Article Date. This score will continue to change until the Spotlight is marked as completed.|      |meanArtScoreStartDate|Average score of articles in Spotlight on Start Date. This score will not change throughout the history of the spotlight.|             |meanPulseScore|Average of pulse scores for each day from First Article Date to Final Article Date, including scores for both Start Date and Final Article Date.|   |primaryArticleSource|Headline of primary Spotlight article.|    |pulseBeforeFirstArticle|Pulse score for category at end-of-day on day before the First Article Date. |              |pulseOnFinalArticleDate|Pulse score for category at the end-of-day on the Final Article Date.|             |pulseOnStartDate|Pulse score for the category at the end-of-day on the Start Date. |   |zScoreOnFinalDate|Z-score for Spotlight as of Final Article Date. This score will continue to change until the Spotlight is marked as completed.|          |zScoreOnStartDate|Z-score for Spotlight as of Start Date. This score will not change throughout the history of the spotlight.|   |startoutLvlOnFinalDate|Describes if the spotlight is a High, Medium, or Low standout spotlight.  This score will continue to change until the Spotlight is marked as completed.|    |startoutLvlOnStartDate|Describes if the spotlight is a High, Medium, or Low standout spotlight.|           .  # noqa: E501

        Keyword Args:
            value ([str]): Request available SDG Spotlights data fields to be included in the response. Default is all fields. _fsymId_,_orgId_, _date_, _spotlightId_, _groupId_ and _requestId_ are always included.     |field|description|   |----|----|   |orgId|Unique identifier assigned by Truvalue that is applied on an organization level |   |spotlightId|Unique identifier assigned by Truvalue identifying a Spotlight ESG event that is detected at the company level, within a single category. |   |orgName|The current name of the organization according to Truvalue (not point-in-time)|   |groupId|Unique identifier assigned by Truvalue identifying a Spotlight group using the Spotlight ID of the Primary Spotlight. |   |primarySpotlight|Value indicating the primary Spotlight in a Spotlight Group. It could be either \"Yes\" or \"No\".|   |spotlightCategory|SDG category tagged to each Spotlight.|    |status|Indicates status of a spotlight, which can be one of Completed or Ongoing. |   |removed|Displays the date a Spotlight was removed from the dataset, if it has been removed.|    |startDate|Date when a Spotlight has met the volume threshold for Spotlight consideration. Score and volume change metadata are associated with this date.|   |liveDate|Date when a Spotlight meets confidence threshold and is considered a Spotlight. This date should never precede start_date. |             |firstArticleDate|Date of earliest article in the Spotlight as of the Start Date. |   |finalArticleDate|Date of final article in the Spotlight. This value can change over the course of the Spotlight until the Spotlight is marked as completed.|       |organizationalVolumeThreshold| The article volume needed to create a Spotlight, as set by the company's overall volume level classification on the Start Date. |    |totalSpotlightVolume|Total number of articles in the Spotlight. This number will change until the Spotlight is marked as completed.|             |startDateVolume|Number of articles in the Spotlight on the Start Date when it met the volume threshold. Does not include the number of articles that were added to the Spotlight after the Spotlight Start Date.|   |primaryArticleSource|Source of the primary article.|    |primaryArticleUrl|URL of the primary article.|              |primaryArticleHeadline|Headline of primary Spotlight article.|             |primaryArticleBulletpoints|Bullet points summarizing the primary article. |   |meanArtScoreFinalDate|Average score of articles in Spotlight on Final Article Date. This score will continue to change until the Spotlight is marked as completed.|      |meanArtScoreStartDate|Average score of articles in Spotlight on Start Date. This score will not change throughout the history of the spotlight.|             |meanPulseScore|Average of pulse scores for each day from First Article Date to Final Article Date, including scores for both Start Date and Final Article Date.|   |primaryArticleSource|Headline of primary Spotlight article.|    |pulseBeforeFirstArticle|Pulse score for category at end-of-day on day before the First Article Date. |              |pulseOnFinalArticleDate|Pulse score for category at the end-of-day on the Final Article Date.|             |pulseOnStartDate|Pulse score for the category at the end-of-day on the Start Date. |   |zScoreOnFinalDate|Z-score for Spotlight as of Final Article Date. This score will continue to change until the Spotlight is marked as completed.|          |zScoreOnStartDate|Z-score for Spotlight as of Start Date. This score will not change throughout the history of the spotlight.|   |startoutLvlOnFinalDate|Describes if the spotlight is a High, Medium, or Low standout spotlight.  This score will continue to change until the Spotlight is marked as completed.|    |startoutLvlOnStartDate|Describes if the spotlight is a High, Medium, or Low standout spotlight.|           .  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """
        # required up here when default value is not given
        _path_to_item = kwargs.pop('_path_to_item', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if 'value' in kwargs:
            value = kwargs.pop('value')
        elif args:
            args = list(args)
            value = args.pop(0)
        else:
            raise ApiTypeError(
                "value is required, but not passed in args or kwargs and doesn't have default",
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)
        self.value = value
        if kwargs:
            raise ApiTypeError(
                "Invalid named arguments=%s passed to %s. Remove those invalid named arguments." % (
                    kwargs,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        return self
