/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scene.IContractClassIdentifiers;
import scene.IMethodIdentifiers;
import scene.MethodAttribute;
import scene.MethodIdentifiers;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003JK\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020\u0003H\u0016J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001R\u0016\u0010\n\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\t\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006'"}, d2={"Lscene/ContractClassIdentifiers;", "Lscene/IContractClassIdentifiers;", "instanceId", "Ljava/math/BigInteger;", "name", "", "methods", "", "Lscene/MethodIdentifiers;", "wholeContractMethod", "constructorMethod", "(Ljava/math/BigInteger;Ljava/lang/String;Ljava/util/Map;Lscene/MethodIdentifiers;Lscene/MethodIdentifiers;)V", "getConstructorMethod", "()Lscene/MethodIdentifiers;", "getInstanceId", "()Ljava/math/BigInteger;", "getMethods", "()Ljava/util/Map;", "getName", "()Ljava/lang/String;", "getWholeContractMethod", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "getDeclaredMethods", "", "Lscene/IMethodIdentifiers;", "getMethodBySigHash", "sig", "hashCode", "", "toString", "Shared"})
public final class ContractClassIdentifiers
implements IContractClassIdentifiers {
    @NotNull
    private final BigInteger instanceId;
    @NotNull
    private final String name;
    @NotNull
    private final Map<BigInteger, MethodIdentifiers> methods;
    @Nullable
    private final MethodIdentifiers wholeContractMethod;
    @Nullable
    private final MethodIdentifiers constructorMethod;

    public ContractClassIdentifiers(@NotNull BigInteger instanceId, @NotNull String name, @NotNull Map<BigInteger, MethodIdentifiers> methods, @Nullable MethodIdentifiers wholeContractMethod, @Nullable MethodIdentifiers constructorMethod) {
        Intrinsics.checkNotNullParameter(instanceId, "instanceId");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(methods, "methods");
        this.instanceId = instanceId;
        this.name = name;
        this.methods = methods;
        this.wholeContractMethod = wholeContractMethod;
        this.constructorMethod = constructorMethod;
    }

    @Override
    @NotNull
    public BigInteger getInstanceId() {
        return this.instanceId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Map<BigInteger, MethodIdentifiers> getMethods() {
        return this.methods;
    }

    @Override
    @Nullable
    public MethodIdentifiers getWholeContractMethod() {
        return this.wholeContractMethod;
    }

    @Override
    @Nullable
    public MethodIdentifiers getConstructorMethod() {
        return this.constructorMethod;
    }

    @Override
    @Nullable
    public IMethodIdentifiers getMethodBySigHash(@NotNull BigInteger sig) {
        Intrinsics.checkNotNullParameter(sig, "sig");
        return this.getMethods().get(sig);
    }

    @Override
    @NotNull
    public Collection<IMethodIdentifiers> getDeclaredMethods() {
        return CollectionsKt.plus(this.getMethods().values(), (Iterable)CollectionsKt.listOfNotNull(this.getConstructorMethod()));
    }

    @Override
    @Nullable
    public IMethodIdentifiers getWholeContract() {
        return IContractClassIdentifiers.DefaultImpls.getWholeContract(this);
    }

    @Override
    @Nullable
    public IMethodIdentifiers getConstructor() {
        return IContractClassIdentifiers.DefaultImpls.getConstructor(this);
    }

    @Override
    @NotNull
    public List<IMethodIdentifiers> getMethods() {
        return IContractClassIdentifiers.DefaultImpls.getMethods(this);
    }

    @Override
    @Nullable
    public IMethodIdentifiers getMethodByUniqueAttribute(@NotNull MethodAttribute.Unique attr) {
        return IContractClassIdentifiers.DefaultImpls.getMethodByUniqueAttribute(this, attr);
    }

    @NotNull
    public final BigInteger component1() {
        return this.getInstanceId();
    }

    @NotNull
    public final String component2() {
        return this.getName();
    }

    @NotNull
    public final Map<BigInteger, MethodIdentifiers> component3() {
        return this.getMethods();
    }

    @Nullable
    public final MethodIdentifiers component4() {
        return this.getWholeContractMethod();
    }

    @Nullable
    public final MethodIdentifiers component5() {
        return this.getConstructorMethod();
    }

    @NotNull
    public final ContractClassIdentifiers copy(@NotNull BigInteger instanceId, @NotNull String name, @NotNull Map<BigInteger, MethodIdentifiers> methods, @Nullable MethodIdentifiers wholeContractMethod, @Nullable MethodIdentifiers constructorMethod) {
        Intrinsics.checkNotNullParameter(instanceId, "instanceId");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(methods, "methods");
        return new ContractClassIdentifiers(instanceId, name, methods, wholeContractMethod, constructorMethod);
    }

    public static /* synthetic */ ContractClassIdentifiers copy$default(ContractClassIdentifiers contractClassIdentifiers, BigInteger bigInteger, String string, Map map2, MethodIdentifiers methodIdentifiers, MethodIdentifiers methodIdentifiers2, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger = contractClassIdentifiers.getInstanceId();
        }
        if ((n & 2) != 0) {
            string = contractClassIdentifiers.getName();
        }
        if ((n & 4) != 0) {
            map2 = contractClassIdentifiers.getMethods();
        }
        if ((n & 8) != 0) {
            methodIdentifiers = contractClassIdentifiers.getWholeContractMethod();
        }
        if ((n & 0x10) != 0) {
            methodIdentifiers2 = contractClassIdentifiers.getConstructorMethod();
        }
        return contractClassIdentifiers.copy(bigInteger, string, map2, methodIdentifiers, methodIdentifiers2);
    }

    @NotNull
    public String toString() {
        return "ContractClassIdentifiers(instanceId=" + this.getInstanceId() + ", name=" + this.getName() + ", methods=" + this.getMethods() + ", wholeContractMethod=" + this.getWholeContractMethod() + ", constructorMethod=" + this.getConstructorMethod() + ")";
    }

    public int hashCode() {
        int result2 = this.getInstanceId().hashCode();
        result2 = result2 * 31 + this.getName().hashCode();
        result2 = result2 * 31 + ((Object)this.getMethods()).hashCode();
        result2 = result2 * 31 + (this.getWholeContractMethod() == null ? 0 : this.getWholeContractMethod().hashCode());
        result2 = result2 * 31 + (this.getConstructorMethod() == null ? 0 : this.getConstructorMethod().hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContractClassIdentifiers)) {
            return false;
        }
        ContractClassIdentifiers contractClassIdentifiers = (ContractClassIdentifiers)other;
        if (!Intrinsics.areEqual(this.getInstanceId(), contractClassIdentifiers.getInstanceId())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getName(), contractClassIdentifiers.getName())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getMethods(), contractClassIdentifiers.getMethods())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getWholeContractMethod(), contractClassIdentifiers.getWholeContractMethod())) {
            return false;
        }
        return Intrinsics.areEqual(this.getConstructorMethod(), contractClassIdentifiers.getConstructorMethod());
    }
}

