/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scene.ContractClassIdentifiers;
import scene.ContractUniverse;
import scene.IContractClassIdentifiers;
import scene.IMethodIdentifiers;
import scene.ISceneIdentifiers;
import scene.MethodAttribute;
import spec.cvlast.SolidityContract;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J)\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00032\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lscene/SceneIdentifiers;", "Lscene/ISceneIdentifiers;", "contracts", "", "Lscene/ContractClassIdentifiers;", "precompiledContracts", "(Ljava/util/List;Ljava/util/List;)V", "component1", "component2", "copy", "equals", "", "other", "", "getContractOrNull", "Lscene/IContractClassIdentifiers;", "s", "Lspec/cvlast/SolidityContract;", "Lbridge/NamedContractIdentifier;", "a", "Ljava/math/BigInteger;", "getContracts", "getMethods", "Lscene/IMethodIdentifiers;", "sigHash", "getPrecompiledContracts", "hashCode", "", "toString", "", "Shared"})
public final class SceneIdentifiers
implements ISceneIdentifiers {
    @NotNull
    private final List<ContractClassIdentifiers> contracts;
    @NotNull
    private final List<ContractClassIdentifiers> precompiledContracts;

    public SceneIdentifiers(@NotNull List<ContractClassIdentifiers> contracts, @NotNull List<ContractClassIdentifiers> precompiledContracts) {
        Intrinsics.checkNotNullParameter(contracts, "contracts");
        Intrinsics.checkNotNullParameter(precompiledContracts, "precompiledContracts");
        this.contracts = contracts;
        this.precompiledContracts = precompiledContracts;
    }

    @Override
    @Nullable
    public IContractClassIdentifiers getContractOrNull(@NotNull SolidityContract s) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(s, "s");
            Iterator iterator2 = SequencesKt.plus(CollectionsKt.asSequence((Iterable)this.precompiledContracts), CollectionsKt.asSequence((Iterable)this.contracts)).iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                ContractClassIdentifiers it = (ContractClassIdentifiers)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), s.getName())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public IContractClassIdentifiers getContractOrNull(@NotNull BigInteger a) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(a, "a");
            Iterator iterator2 = SequencesKt.plus(CollectionsKt.asSequence((Iterable)this.precompiledContracts), CollectionsKt.asSequence((Iterable)this.contracts)).iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                ContractClassIdentifiers it = (ContractClassIdentifiers)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getInstanceId(), a)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IMethodIdentifiers> getMethods(@NotNull BigInteger sigHash) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(sigHash, "sigHash");
        Iterable $this$mapNotNull$iv = this.contracts;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IMethodIdentifiers it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ContractClassIdentifiers it = (ContractClassIdentifiers)element$iv$iv;
            boolean bl2 = false;
            if (it.getMethodBySigHash(sigHash) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<IContractClassIdentifiers> getContracts() {
        return this.contracts;
    }

    @Override
    @NotNull
    public List<IContractClassIdentifiers> getPrecompiledContracts() {
        return this.precompiledContracts;
    }

    @Override
    @NotNull
    public List<IContractClassIdentifiers> getContracts(@NotNull BigInteger sighash) {
        return ISceneIdentifiers.DefaultImpls.getContracts(this, sighash);
    }

    @Override
    @NotNull
    public IContractClassIdentifiers getContract(@NotNull SolidityContract s) {
        return ISceneIdentifiers.DefaultImpls.getContract((ISceneIdentifiers)this, s);
    }

    @Override
    @NotNull
    public IContractClassIdentifiers getContract(@NotNull BigInteger a) {
        return ISceneIdentifiers.DefaultImpls.getContract((ISceneIdentifiers)this, a);
    }

    @Override
    @NotNull
    public IMethodIdentifiers getMethod(@NotNull BigInteger contractId, @NotNull BigInteger sigHash) {
        return ISceneIdentifiers.DefaultImpls.getMethod((ISceneIdentifiers)this, contractId, sigHash);
    }

    @Override
    @NotNull
    public IMethodIdentifiers getMethod(@NotNull SolidityContract contractName, @NotNull BigInteger sigHash) {
        return ISceneIdentifiers.DefaultImpls.getMethod((ISceneIdentifiers)this, contractName, sigHash);
    }

    @Override
    @NotNull
    public IMethodIdentifiers getMethod(@NotNull SolidityContract contractName, @NotNull MethodAttribute.Unique methodAttribute) {
        return ISceneIdentifiers.DefaultImpls.getMethod((ISceneIdentifiers)this, contractName, methodAttribute);
    }

    @Override
    @NotNull
    public IMethodIdentifiers getMethod(@NotNull BigInteger contractId, @NotNull MethodAttribute.Unique methodAttribute) {
        return ISceneIdentifiers.DefaultImpls.getMethod((ISceneIdentifiers)this, contractId, methodAttribute);
    }

    @Override
    public boolean hasMethod(@NotNull BigInteger contractId, @NotNull BigInteger sigHash) {
        return ISceneIdentifiers.DefaultImpls.hasMethod((ISceneIdentifiers)this, contractId, sigHash);
    }

    @Override
    public boolean hasMethod(@NotNull SolidityContract contractName, @NotNull BigInteger sigHash) {
        return ISceneIdentifiers.DefaultImpls.hasMethod((ISceneIdentifiers)this, contractName, sigHash);
    }

    @Override
    @NotNull
    public ContractUniverse getContractUniverse() {
        return ISceneIdentifiers.DefaultImpls.getContractUniverse(this);
    }

    private final List<ContractClassIdentifiers> component1() {
        return this.contracts;
    }

    private final List<ContractClassIdentifiers> component2() {
        return this.precompiledContracts;
    }

    @NotNull
    public final SceneIdentifiers copy(@NotNull List<ContractClassIdentifiers> contracts, @NotNull List<ContractClassIdentifiers> precompiledContracts) {
        Intrinsics.checkNotNullParameter(contracts, "contracts");
        Intrinsics.checkNotNullParameter(precompiledContracts, "precompiledContracts");
        return new SceneIdentifiers(contracts, precompiledContracts);
    }

    public static /* synthetic */ SceneIdentifiers copy$default(SceneIdentifiers sceneIdentifiers, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = sceneIdentifiers.contracts;
        }
        if ((n & 2) != 0) {
            list2 = sceneIdentifiers.precompiledContracts;
        }
        return sceneIdentifiers.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "SceneIdentifiers(contracts=" + this.contracts + ", precompiledContracts=" + this.precompiledContracts + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.contracts).hashCode();
        result2 = result2 * 31 + ((Object)this.precompiledContracts).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SceneIdentifiers)) {
            return false;
        }
        SceneIdentifiers sceneIdentifiers = (SceneIdentifiers)other;
        if (!Intrinsics.areEqual(this.contracts, sceneIdentifiers.contracts)) {
            return false;
        }
        return Intrinsics.areEqual(this.precompiledContracts, sceneIdentifiers.precompiledContracts);
    }
}

