from enum import Enum


class EErrorCode(Enum):
    UNABLE_TO_LOAD_PROJECT = 100
    UNABLE_TO_FIND_VENV = 150
    UNABLE_TO_DISCOVER_TOOLCHAIN = 200
    UNABLE_TO_INSTALL_CONAN_BUILD_TOOLS = 220
    UNABLE_TO_INSTALL_CONAN_DEPENDENCIES = 222
    UNABLE_TO_LOAD_DEPENDENCIES = 280
    UNABLE_TO_VALIDATE_TARGETS = 290
    UNABLE_TO_CREATE_CONFIGURATIONS = 300
    UNABLE_TO_RESOLVE_CLI_TOOLS_FULLPATH = 350
    UNABLE_TO_RESOLVE_VARIANTS = 400
    UNABLE_TO_EMIT_PROJECT = 500
    UNABLE_TO_COMMIT_FS = 550
    UNABLE_TO_CREATE_VS_PROJECTS = 600
    UNABLE_TO_CREATE_VS_SOLUTION = 650
    UNABLE_TO_CLEAN = 700
    COMPILATION_FAILED = 800
    UNKNOWN_ERROR = 666


class ReturnErrorcode(Exception):
    error_code: EErrorCode = 0x0

    def __init__(self, code: EErrorCode):
        self.error_code = code
