import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association#id TagAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the object identifier for the tag association.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association#object_name TagAssociation#object_name}
    */
    readonly objectName: string;
    /**
    * Specifies the type of object to add a tag to. ex: 'ACCOUNT', 'COLUMN', 'DATABASE', etc. For more information: https://docs.snowflake.com/en/user-guide/object-tagging.html#supported-objects
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association#object_type TagAssociation#object_type}
    */
    readonly objectType: string;
    /**
    * If true, skips validation of the tag association. It can take up to an hour for the SNOWFLAKE.TAG_REFERENCES table to update, and also requires ACCOUNT_ADMIN role to read from. https://docs.snowflake.com/en/sql-reference/account-usage/tag_references.html
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association#skip_validation TagAssociation#skip_validation}
    */
    readonly skipValidation?: boolean | cdktf.IResolvable;
    /**
    * Specifies the identifier for the tag. Note: format must follow: "databaseName"."schemaName"."tagName" or "databaseName.schemaName.tagName" or "databaseName|schemaName.tagName" (snowflake_tag.tag.id)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association#tag_id TagAssociation#tag_id}
    */
    readonly tagId: string;
    /**
    * Specifies the value of the tag, (e.g. 'finance' or 'engineering')
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association#tag_value TagAssociation#tag_value}
    */
    readonly tagValue: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association#timeouts TagAssociation#timeouts}
    */
    readonly timeouts?: TagAssociationTimeouts;
}
export interface TagAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association#create TagAssociation#create}
    */
    readonly create?: string;
}
export declare function tagAssociationTimeoutsToTerraform(struct?: TagAssociationTimeoutsOutputReference | TagAssociationTimeouts | cdktf.IResolvable): any;
export declare class TagAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TagAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: TagAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association snowflake_tag_association}
*/
export declare class TagAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_tag_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/tag_association snowflake_tag_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TagAssociationConfig
    */
    constructor(scope: Construct, id: string, config: TagAssociationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    get objectTypeInput(): string | undefined;
    private _skipValidation?;
    get skipValidation(): boolean | cdktf.IResolvable;
    set skipValidation(value: boolean | cdktf.IResolvable);
    resetSkipValidation(): void;
    get skipValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _tagId?;
    get tagId(): string;
    set tagId(value: string);
    get tagIdInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    get tagValueInput(): string | undefined;
    private _timeouts;
    get timeouts(): TagAssociationTimeoutsOutputReference;
    putTimeouts(value: TagAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | TagAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
