/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.qameta.allure.CommandlineConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoader.class);
    private final Path configFile;

    public ConfigLoader(Path configFile) {
        this.configFile = configFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommandlineConfig load() {
        if (Files.notExists(this.configFile, new LinkOption[0])) {
            LOGGER.error("Could not find config file {}. Using the empty configuration", (Object)this.configFile);
            return new CommandlineConfig();
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try (InputStream is = Files.newInputStream(this.configFile, new OpenOption[0]);){
            CommandlineConfig commandlineConfig = (CommandlineConfig)mapper.readValue(is, CommandlineConfig.class);
            return commandlineConfig;
        }
        catch (IOException e) {
            LOGGER.error("Could not load config file {}. Using the empty configuration", (Object)this.configFile);
            return new CommandlineConfig();
        }
    }
}

