/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.mail;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.qameta.allure.Aggregator;
import io.qameta.allure.context.FreemarkerContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailPlugin
implements Aggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailPlugin.class);

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) throws IOException {
        FreemarkerContext context = (FreemarkerContext)configuration.requireContext(FreemarkerContext.class);
        Path exportFolder = Files.createDirectories(outputDirectory.resolve("export"), new FileAttribute[0]);
        Path mailFile = exportFolder.resolve("mail.html");
        try (BufferedWriter writer = Files.newBufferedWriter(mailFile, new OpenOption[0]);){
            Template template = context.getValue().getTemplate("mail.html.ftl");
            template.process(new HashMap(), (Writer)writer);
        }
        catch (TemplateException e) {
            LOGGER.error("Could't write mail file", (Throwable)e);
        }
    }
}

