/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.qameta.allure.entity.Attachment;
import io.qameta.allure.entity.Parameter;
import io.qameta.allure.entity.Step;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface Summarizable {
    public String getStatusMessage();

    public List<Step> getSteps();

    public List<Attachment> getAttachments();

    public List<Parameter> getParameters();

    @JsonProperty
    default public long getStepsCount() {
        List<Object> steps = Objects.isNull(this.getSteps()) ? Collections.emptyList() : this.getSteps();
        long stepsCount = steps.size();
        return steps.stream().map(Summarizable::getStepsCount).reduce(stepsCount, Long::sum);
    }

    @JsonProperty
    default public long getAttachmentsCount() {
        List<Object> attachments = Objects.isNull(this.getAttachments()) ? Collections.emptyList() : this.getAttachments();
        List<Object> steps = Objects.isNull(this.getSteps()) ? Collections.emptyList() : this.getSteps();
        long attachmentsCount = Objects.isNull(attachments) ? 0L : (long)attachments.size();
        return steps.stream().map(Summarizable::getAttachmentsCount).reduce(attachmentsCount, Long::sum);
    }

    @JsonProperty
    default public boolean shouldDisplayMessage() {
        Optional<String> message = Optional.ofNullable(this.getStatusMessage());
        return message.isPresent() && this.getSteps().stream().noneMatch(step -> step.hasMessage((String)message.get()));
    }

    default public boolean hasMessage(String message) {
        Optional<String> current = Optional.ofNullable(this.getStatusMessage()).filter(s -> Objects.equals(s, message));
        return current.isPresent() || this.getSteps().stream().anyMatch(step -> step.hasMessage(message));
    }

    @JsonProperty
    default public boolean hasContent() {
        List<Object> attachments = Objects.isNull(this.getAttachments()) ? Collections.emptyList() : this.getAttachments();
        List<Object> steps = Objects.isNull(this.getSteps()) ? Collections.emptyList() : this.getSteps();
        List<Object> parameters = Objects.isNull(this.getParameters()) ? Collections.emptyList() : this.getParameters();
        return steps.size() + attachments.size() + parameters.size() > 0 || this.shouldDisplayMessage();
    }
}

