/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElement
implements Iterable<XmlElement> {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<XmlElement> children = new ArrayList<XmlElement>();
    private final String name;
    private final String value;

    public XmlElement(Element element) {
        this.name = element.getNodeName();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            this.attributes.put(item.getNodeName(), item.getNodeValue());
        }
        StringBuilder textValue = new StringBuilder();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                this.children.add(new XmlElement((Element)node));
            }
            if (node.getNodeType() == 3) {
                textValue.append(node.getNodeValue());
            }
            if (node.getNodeType() != 4) continue;
            textValue.append(((CharacterData)node).getData());
        }
        this.value = textValue.toString();
    }

    public List<XmlElement> get(String name) {
        return this.children.stream().filter(this.elementWithName(name)).collect(Collectors.toList());
    }

    public Optional<XmlElement> getFirst(String name) {
        return this.children.stream().filter(this.elementWithName(name)).findFirst();
    }

    public boolean contains(String name) {
        return this.children.stream().anyMatch(this.elementWithName(name));
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Double getDoubleAttribute(String key) {
        return Double.parseDouble(this.attributes.get(key));
    }

    public boolean containsAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<XmlElement> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Iterator<XmlElement> iterator() {
        return this.children.iterator();
    }

    private Predicate<XmlElement> elementWithName(String name) {
        return xmlElement -> Objects.equals(xmlElement.getName(), name);
    }
}

