/*
 * Decompiled with CFR 0.152.
 */
package org.allurefw.allure1;

import com.github.baev.BadXmlCharactersFilterReader;
import com.github.baev.BadXmlCharactersFilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.allurefw.allure1.AllureConstants;
import org.allurefw.allure1.AllureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.LabelName;
import ru.yandex.qatools.allure.model.ObjectFactory;
import ru.yandex.qatools.allure.model.TestSuiteResult;

public final class AllureUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureUtils.class);

    AllureUtils() {
        throw new IllegalStateException("Don't instance AllureUtils");
    }

    public static String generateAttachmentName() {
        return String.format("%s%s", UUID.randomUUID().toString(), "-attachment");
    }

    public static String generateTestSuiteXmlName() {
        return String.format("%s%s.xml", UUID.randomUUID().toString(), "-testsuite");
    }

    public static String generateTestSuiteJsonName() {
        return String.format("%s%s.json", UUID.randomUUID().toString(), "-testsuite");
    }

    public static List<Path> listAttachmentFiles(Path ... directories) throws IOException {
        return AllureUtils.listFiles(AllureConstants.ATTACHMENTS_FILE_GLOB, directories);
    }

    public static List<Path> listTestSuiteXmlFiles(Path ... directories) throws IOException {
        return AllureUtils.listFiles(AllureConstants.TEST_SUITE_XML_FILE_GLOB, directories);
    }

    public static List<Path> listTestSuiteJsonFiles(Path ... directories) throws IOException {
        return AllureUtils.listFiles(AllureConstants.TEST_SUITE_JSON_FILE_GLOB, directories);
    }

    public static List<Path> listFiles(String glob, Path ... directories) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path directory : directories) {
            result.addAll(AllureUtils.listFiles(glob, directory));
        }
        return result;
    }

    public static List<Path> listFiles(String glob, Path directory) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return result;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, glob);){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                result.add(path);
            }
        }
        return result;
    }

    public static void marshalTestSuite(TestSuiteResult testSuite, Path file) {
        try (BadXmlCharactersFilterWriter writer = new BadXmlCharactersFilterWriter(file);){
            AllureUtils.marshaller(TestSuiteResult.class).marshal(new ObjectFactory().createTestSuite(testSuite), (Writer)writer);
        }
        catch (Exception e) {
            LOGGER.error("Error during marshalling testSuite", (Throwable)e);
        }
    }

    public static TestSuiteResult unmarshalTestSuite(Path testSuite) throws IOException {
        try (BadXmlCharactersFilterReader reader = new BadXmlCharactersFilterReader(testSuite);){
            TestSuiteResult testSuiteResult = (TestSuiteResult)JAXB.unmarshal((Reader)reader, TestSuiteResult.class);
            return testSuiteResult;
        }
    }

    public static Marshaller marshaller(Class<?> clazz) {
        Marshaller m = AllureUtils.createMarshallerForClass(clazz);
        AllureUtils.setPropertySafely(m, "jaxb.formatted.output", true);
        AllureUtils.setPropertySafely(m, "jaxb.encoding", StandardCharsets.UTF_8.toString());
        return m;
    }

    public static Marshaller createMarshallerForClass(Class<?> clazz) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{clazz}).createMarshaller();
        }
        catch (JAXBException e) {
            throw new AllureException("Can't create marshaller for class " + clazz, e);
        }
    }

    public static void setPropertySafely(Marshaller marshaller, String name, Object value) {
        try {
            marshaller.setProperty(name, value);
        }
        catch (PropertyException e) {
            LOGGER.warn(String.format("Can't set \"%s\" property to given marshaller", name), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Validator getSchemaValidator() {
        try (InputStream schemaFile = AllureUtils.class.getClassLoader().getResourceAsStream("xsd/allure1_model.xsd");){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new StreamSource(schemaFile));
            Validator validator = schema.newValidator();
            return validator;
        }
        catch (IOException e) {
            throw new AllureException("Could not find xsd/allure1_model.xsd", e);
        }
        catch (SAXException e) {
            throw new AllureException("Could not create schema validator", e);
        }
    }

    public static void validateResults(Path ... directories) {
        try {
            Validator validator = AllureUtils.getSchemaValidator();
            for (Path suite : AllureUtils.listTestSuiteXmlFiles(directories)) {
                validator.validate(new StreamSource(suite.toFile()));
            }
        }
        catch (IOException e) {
            throw new AllureException("Could not validate results", e);
        }
        catch (SAXException e) {
            throw new AllureException("Error during results validation", e);
        }
    }

    public static Label createLabel(LabelName name, String value) {
        return new Label().withName(name.value()).withValue(value);
    }
}

