"""
Unicode code point dictionary.
Based on Unicode.org Unihan database.
"""
__license__ = 'GPL 3'
__copyright__ = '2010 Hiroshi Miura <miurahr@linux.com>'
__docformat__ = 'restructuredtext en'

CODEPOINTS = {
    'x34':[
        'Qiu ','Tian ','','','Kua ','Wu ','Yin ','','','','','','Si ','','','',
        '','','','','','','Ye ','','','','','','Chou ','','','',
        '','Nuo ','','','Qiu ','','','','Xu ','Xing ','','Xiong ','Liu ','Lin ','Xiang ','Yong ',
        'Xin ','Zhen ','Dai ','Wu ','Pan ','','','Ma ','Qian ','Yi ','Zhong ','N ','Cheng ','Fung ','','',
        '','Zhuo ','Fang ','Ao ','Wu ','Zuo ','','Zhou ','Dong ','Su ','Yi ','Jiong ','Wang ','Lei ','Nao ','Zhu ',
        'Suk ','','','','Xu ','','','Saan ','Jie ','Die ','Nuo ','Su ','Yi ','Long ','Ying ','Beng ',
        '','','','Lan ','Miao ','Yi ','Li ','Ji ','Yu ','Luo ','Chai ','Nom ','','','Hun ','Xu ',
        'Hui ','Rao ','','Zhou ','Caam ','Han ','Xi ','Tai ','Ai ','Hui ','Jun ','Ma ','Lue ','Tang ','Xiao ','Tiao ',
        'Zha ','Yu ','Ku ','Er ','Nang ','Qi ','Chi ','Mu ','Han ','Tang ','Se ','Si ','Qiong ','Lei ','Sa ','',
        '','Hui ','Pu ','Ta ','Shu ','Zoeng ','Ou ','Tai ','','Mian ','Wen ','Diao ','Yu ','Mie ','Jun ','Niao ',
        'Xie ','You ','','','She ','Fung ','Lei ','Li ','Sin ','Luo ','Sek ','Ji ','','Kwaan ','','',
        'Quan ','','Cai ','Liang ','Gu ','Mao ','Gung ','Gua ','Sui ','Din ','','Mao ','Man ','Hyun ','Shi ','Li ',
        '','Wang ','Kou ','Chui ','Zhen ','Ding ','','','Bing ','Huan ','Dong ','Gong ','Cang ','','Lian ','Jiong ',
        'Lu ','Xing ','','Nan ','Xie ','','Bi ','Jie ','Su ','Hung ','Geoi6','Gung ','You ','Xing ','Qi ','Ngo ',
        'Dian ','Fu ','Luo ','Qia ','Jie ','Tong ','Bak ','Yan ','Ci ','Fan ','Lang ','','Fu ','He ','Diu ','Li ',
        'Hua ','Tou ','Pian ','Dai ','Jun ','E ','Qie ','Yi ','Jue ','Rui ','Jian ','Gong ','Chi ','Chong ','Chi ','',
        ],
    'x35':[
        'Lue ','Daang ','Lin ','Jue ','Su ','Xiao ','Chan ','Put ','','Zhu ','Dan ','Jian ','Zhou ','Duo ','Xie ','Li ',
        'Cim ','Chi ','Xi ','Jian ','','Ji ','','Fei ','Chu ','Bang ','Kou ','','Ba ','Liang ','Kuai ','',
        'He ','Bit ','Jue ','Lei ','Shen ','Pi ','Yang ','Lu ','Bei ','E ','Lu ','','Coek ','Che ','Nuo ','Suan ',
        'Heng ','Yu ','','Gui ','Yi ','Xian ','Gong ','Lou ','Cam ','Le ','Shi ','Pei ','Sun ','Yao ','Jie ','Zou ',
        '','Que ','Yin ','Him ','Zhi ','Jia ','Hu ','La ','Hou ','Ke ','Bou ','Jing ','Ai ','Deoi ','E ','Chu ',
        'Xie ','Chu ','Wei ','','Teng ','Huan ','Su ','You ','Caam ','Jun ','Zhao ','Xu ','Shi ','','Caat ','Kui ',
        'Soeng ','He ','Gai ','Yan ','Qiu ','Yi ','Hua ','Si ','Fan ','Zhang ','Dan ','Fang ','Song ','Ao ','Fu ','Nei ',
        'He ','You ','Hua ','Hung ','Chen ','Guo ','Ng ','Hua ','Li ','Fa ','Hao ','Pou ','Dung6','Si ','','',
        'Le ','Lin ','Yi ','Hou ','Zaau ','Xu ','Qu ','Er ','','','','','','','','Nei ',
        'Wei ','Xie ','Ti ','Hong ','Tun ','Bo ','Nie ','Yin ','San ','','','','','','Wai ','Shou ',
        'Ba ','Ye ','Ji ','Tou ','Han ','Jiong ','Dong ','Wen ','Lu ','Sou ','Guo ','Ling ','','Tian ','Lun ','',
        '','','','','','ge ','Ye ','Shi ','Xue ','Fen ','Chun ','Rou ','Duo ','Ze ','E ','Xie ',
        'Zaau ','E ','Sheng ','Wen ','Man ','Hu ','Ge ','Xia ','Man ','Bi ','Ji ','Hou ','Zhi ','','Gaa ','',
        '','Bai ','Ai ','Ci ','Hin ','Gou ','Dan ','Bai ','Bo ','Na ','Li ','Xiao ','Xiu ','','','',
        '','','Dong ','Ti ','Cu ','Kuo ','Lao ','Zhi ','Ai ','Xi ','','Qie ','Zaa ','Hei ','','',
        'Chu ','Ji ','Huo ','Ta ','Yan ','Xu ','Put ','Sai ','','','','Go6','Ye ','Xiang ','Heoi ','Xia ',
        ],
    'x36':[
        'Zuo ','Yi ','Ci ','','','Xian ','Tai ','Rong ','Yi ','Zhi ','Yi ','Xian ','Ju ','Ji ','Han ','',
        'Pao ','Li ','','Lan ','Can ','Han ','Yan ','','','Yan ','Han ','Haam ','Chi ','Nian ','Huo ','',
        'Bi ','Xia ','Weng ','Xuan ','Waan ','You ','Qin ','Xu ','Nei ','Bi ','Hao ','Jing ','Ao ','Ao ','','',
        'Zam ','Taan ','Ju ','Zaau ','Zuo ','Bu ','Jie ','Ai ','Zang ','Ci ','Fa ','Zaan ','','','','Nie ',
        'Liu ','Mang ','Dui ','Bong ','Bi ','Bao ','','Chu ','Han ','Tian ','Chang ','','','Do ','Wai ','Fu ',
        'Duo ','Yu ','Ye ','Kui ','Han ','Kuai ','','Kuai ','Ziu ','Long ','Sing ','Bu ','Chi ','Xie ','Nie ','Lang ',
        'Yi ','Zung ','Man ','Zhang ','Xia ','Gun ','','','Ji ','Liao ','Ye ','Ji ','Yin ','','Da ','Yi ',
        'Xie ','Hao ','Yong ','Han ','Chan ','Tai ','Tang ','Zhi ','Bao ','Meng ','Gui ','Chan ','Lei ','','Xi ','',
        'Hei ','Qiao ','Rang ','Yun ','','Long ','Fu ','Zuk ','','Gu ','Hoi ','Diu ','Hua ','Guo ','','Gao ',
        'Tao ','','Shan ','Lai ','Nie ','Fu ','Gao ','Qie ','Ban ','Gaa ','','Xi ','Xu ','Kui ','Meng ','Chuo ',
        'Hiu ','Ji ','Nu ','Xiao ','Yi ','Yu ','Yi ','Yan ','','Ran ','Hao ','Sha ','Gwan ','You ','Daam ','Xin ',
        'Bi ','Zaau ','Dian ','O ','Bu ','Dung ','Si ','Er ','Si ','Mao ','Yun ','Gei ','Naau ','Qiao ','','Pao ',
        '','Ping ','Nuo ','Jie ','Zi ','Er ','Duo ','','','','Duo ','','','Qie ','Leoi ','Ou ',
        'Sou ','Can ','Dou ','Ci ','Peng ','Yi ','So ','Zuo ','Po ','Qie ','Tong ','Xin ','You ','Bei ','Long ','',
        '','','','','','Ta ','Lan ','Man ','Qiang ','Zhou ','Yan ','Sek ','Lu ','Sik ','Sao ','Mian ',
        'Fan ','Rui ','Fa ','Cha ','Nao ','Cing ','Chou ','Gai ','Shu ','Pian ','Aam ','Kui ','Sha ','Saan ','Xian ','Zhi ',
        ],
    'x37':[
        '','','Fung ','Lian ','Xun ','Xu ','Mi ','Hui ','Mu ','Zung ','Pang ','Yi ','Gou ','Tang ','Qi ','Yun ',
        'Shu ','Fu ','Yi ','Da ','','Lian ','Cao ','Can ','Ju ','Lu ','Su ','Nen ','Ao ','An ','Qian ','',
        'Ceoi ','Sung ','','Ran ','Shen ','Mai ','Han ','Yue ','Er ','Ao ','Xian ','Ma ','','','Lan ','Hei ',
        'Yue ','Dong ','Weng ','Huai ','Meng ','Niao ','Wan ','Mi ','Nie ','Qu ','Zan ','Lian ','Zhi ','Zi ','Hai ','Xu ',
        'Hao ','Xun ','Zhi ','Fan ','Chun ','Gou ','','Chun ','Luan ','Zhu ','Shou ','Liao ','Jie ','Xie ','Ding ','Jie ',
        'Rong ','Mang ','Geoi ','Ge ','Yao ','Ning ','Yi ','Lang ','Yong ','Yin ','','Su ','Sik ','Lin ','Ya ','Mao ',
        'Ming ','Zui ','Yu ','Ye ','Gou ','Mi ','Jun ','Wen ','','Hoi ','Dian ','Long ','','Xing ','Cui ','Qiao ',
        'Mian ','Meng ','Qin ','','Wan ','De ','Ai ','','Bian ','Nou ','Lian ','Jin ','Zyu ','Chui ','Zuo ','Bo ',
        'Fui ','Yao ','Tui ','Ji ','Aam ','Guo ','Ji ','Wei ','Bui6','Zaat ','Xu ','Nian ','Yun ','','Ba ','Zhe ',
        'Ju ','Wei ','Xi ','Qi ','Yi ','Xie ','Ci ','Qiu ','Tun ','Niao ','Qi ','Ji ','Teoi ','','','Dian ',
        'Lao ','Zhan ','Zi ','Fan ','Yin ','Cen ','Ji ','Hui ','Zai ','Lan ','Nao ','Ju ','Qin ','Dai ','Shutsu ','Jie ',
        'Xu ','Cung ','Yong ','Dou ','Chi ','Tou ','Min ','Huang ','Sui ','Ke ','Zu ','Hao ','Cheng ','Xue ','Ni ','Chi ',
        'Lian ','An ','Chi ','Si ','Xiang ','Yang ','Hua ','Cuo ','Qiu ','Lao ','Fu ','Dui ','Mang ','Lang ','Tuo ','Han ',
        'Mang ','Bo ','Kwan ','Qi ','Han ','','Long ','Ban ','Tiao ','Lao ','Qi ','Zan ','Mi ','Pei ','Zhan ','Xiang ',
        'Gang ','','Qi ','','Lu ','Caam ','Yun ','E ','Quan ','Min ','Wei ','Quan ','Shu ','Min ','Daat6','',
        'Ming ','Yao ','Jue ','Li ','Kuai ','Gang ','Yuan ','Da ','Gou ','Lao ','Lou ','Qian ','Ao ','Biao ','Zung ','Mang ',
        ],
    'x38':[
        'Dao ','Caam ','Ao ','','Xi ','Fu ','Daan ','Jiu ','Run ','Tong ','Qu ','E ','Hei ','Ji ','Ji ','Hua ',
        'Jiao ','Zui ','Biao ','Meng ','Bai ','Wei ','Ji ','Ao ','Yu ','Hao ','Dui ','Wo ','Ni ','Cuan ','','Li ',
        'Lu ','Niao ','Hua ','Lai ','','Lu ','Fung ','Mi ','Yu ','Fong ','Ju ','','','Zhan ','Pang ','Yi ',
        '','Ji ','Bi ','','Ren ','Fong ','Fan ','Ge ','Ku ','Jie ','Miao ','Hei ','Si ','Tong ','Zyun ','Ci ',
        'Bi ','Kai ','Li ','Fong ','Sun ','Nuo ','Fong ','Ji ','Men ','Xian ','Qia ','E ','Mao ','','Saam ','Tou ',
        'Zin ','Qiao ','Zeon ','Kwaan ','Wu ','Zing ','Chuang ','Ti ','Lian ','Bi ','Haat6','Mang ','Xue ','Feng ','Lei ','Zou ',
        'Zheng ','Chu ','Man ','Long ','','Yin ','Baan ','Zheng ','Qian ','Luan ','Nie ','Yi ','','Ji ','Ji ','Zhai ',
        'Yu ','Jiu ','Huan ','Di ','Kaap ','Ling ','Ji ','Ben ','Zha ','Ci ','Dan ','Liao ','Yi ','Zhao ','Xian ','Chi ',
        'Ci ','Chi ','Yan ','Lang ','Dou ','Long ','Chan ','','Tui ','Cha ','Ai ','Chi ','','Ying ','Cha ','Tou ',
        '','Tui ','Cha ','Yao ','Zong ','Zung ','Pun ','Qiao ','Lian ','Qin ','Lu ','Yan ','Kong ','Sou ','Yi ','Chan ',
        'Jiong ','Jiang ','','Jing ','','Dong ','Go ','Juan ','Han ','Di ','Wu ','','Hong ','Tou ','Chi ','Min ',
        'Bi ','','Xun ','Lu ','Sai ','She ','Bi ','','Bi ','','Xian ','Wei ','Bie ','Er ','Juan ','',
        'Zhen ','Bei ','Yi ','Yu ','Qu ','Zan ','Mi ','Ni ','Si ','Gung ','','Daan ','Shan ','Tai ','Mu ','Jing ',
        'Bian ','Rong ','Ceng ','Can ','Ding ','','','','Keoi ','Di ','Tong ','Ta ','Xing ','Sung ','Duo ','Xi ',
        'Tong ','','Ti ','Shan ','Jian ','Zhi ','Wai ','Yin ','','','Huan ','Zhong ','Qi ','Zung ','','Xie ',
        'Xie ','Ze ','Wei ','','','Ta ','Zhan ','Ning ','','','Sam ','Yi ','Ren ','Shu ','Cha ','Zhuo ',
        ],
    'x39':[
        '','Mian ','Ji ','Fang ','Pei ','Ai ','Fan ','Ao ','Qin ','Qia ','Xiao ','Fan ','Gaam ','Qiao ','Go ','Tong ',
        'Tip ','You ','Gou ','Ben ','Fu ','Chu ','Zhu ','','Chu ','Zaan ','Hang ','Nin ','Jue ','Cung ','Cha ','Kong ',
        'Lie ','Li ','Xu ','Paang ','Yu ','Hai ','Li ','Hou ','Gong ','Ke ','Yuan ','De ','Hui ','Giu ','Kuang ','Jiong ',
        'Zan ','Fu ','Qie ','Bei ','Xi ','Ci ','Pang ','Haam ','Xi ','Qiu ','Huang ','Nan ','','Chou ','San ','Jim ',
        'De ','De ','Te ','Men ','Ling ','Shou ','Dian ','Can ','Die ','Che ','Peng ','Zi ','Ju ','Ji ','Lai ','Tian ',
        'Yuan ','Zaau ','Cai ','Qi ','Yu ','Lian ','Cung ','','','','Yu ','Ji ','Wei ','Mi ','Cui ','Xie ',
        'Xu ','Xi ','Qiu ','Hui ','Ging ','Yu ','Qie ','Shun ','Chui ','Duo ','Lou ','Deon ','Pang ','Tai ','Zhou ','Yin ',
        'Sou ','Fei ','Shen ','Yuan ','Yi ','Hun ','Se ','Ye ','Min ','Fen ','He ','','Yin ','Ce ','Ni ','Ao ',
        'Feng ','Lian ','Chang ','Chan ','Ma ','Di ','Fu ','Lu ','','Yi ','Hua ','Caa ','Tui ','E ','Hua ','Sun ',
        'Ni ','Lian ','Li ','Xian ','Yan ','Long ','Men ','Jian ','Gik ','','Bian ','Yu ','Huo ','Miao ','Chou ','Hai ',
        '','Le ','Jie ','Wei ','Yi ','Huan ','He ','Can ','Lan ','Yin ','Xie ','Zaat ','Luo ','Ling ','Qian ','Huo ',
        'Cim ','Wo ','Zoi ','','Ge ','Zyu ','Die ','Yong ','Ji ','Ang ','Ru ','Xi ','Shuang ','Xu ','Yi ','Hu ',
        'Ji ','Qu ','Tian ','Sau ','Qian ','Mu ','Gaan ','Mao ','Yin ','Gai ','Ba ','Xian ','Mao ','Fang ','Ya ','Gong ',
        'Song ','Wei ','Xue ','Gwaa ','Guai ','Jiu ','E ','Zi ','Cui ','Bi ','Wa ','Hin ','Lie ','Gaa ','','Kuai ',
        '','Hai ','Zaan ','Zhu ','Chong ','Xian ','Xuan ','So ','Qiu ','Pei ','Gui ','Er ','Gong ','Qiong ','Bak6','Lao ',
        'Li ','Chen ','San ','Bo ','Wo ','Pou ','Hang ','Duo ','Paang ','Te ','Ta ','Zhi ','Biao ','Gu ','Fat ','Coeng ',
        ],
    'x3a':[
        'Bing ','Zhi ','Dong ','Cheng ','Zhao ','Nei ','Lin ','Po ','Ji ','Min ','Wei ','Che ','Gou ','Bong ','Ru ','Taan ',
        'Bu ','Zung ','Kui ','Lao ','Han ','Ying ','Zhi ','Jie ','Xing ','Xie ','Xun ','Shan ','Qian ','Xie ','Su ','Hai ',
        'Mi ','Hun ','Nang ','','Hui ','Na ','Song ','Ben ','Liu ','Jie ','Huang ','Lan ','','Hu ','Dou ','Huo ',
        'Ge ','Yao ','Ce ','Gui ','Jian ','Jian ','Chou ','Jin ','Ma ','Hui ','Men ','Can ','Lue ','Pi ','Yang ','Ju ',
        'Ju ','Que ','','','Shai ','Cau ','Jiu ','Hua ','Xian ','Xie ','Syun ','Su ','Fei ','Ce ','Ye ','',
        '','','Qin ','Hui ','Tun ','Ling ','Qiang ','Xi ','Yi ','Nim ','Meng ','Tuan ','Lan ','Hao ','Ci ','Zhai ',
        'Piao ','Luo ','Mi ','Buk ','Fu ','Cam ','Xie ','Bo ','Hui ','Qi ','Xie ','','Hei ','Bo ','Qian ','Ban ',
        'Jiao ','Jue ','Kun ','Song ','Ju ','E ','Nie ','','Die ','Die ','Pei ','Gui ','Zi ','Qi ','Chui ','Gwaat6',
        'Yu ','Qin ','Faat ','Ke ','Fu ','Gaang ','Di ','Xian ','Gui ','He ','Qun ','Han ','Tong ','Bo ','Shan ','Bi ',
        'Lu ','Ye ','Ni ','Chuai ','San ','Diao ','Lu ','Tou ','Lian ','Ke ','San ','Zhen ','Chuai ','Lian ','Mao ','Deon ',
        'Qian ','Ke ','Shao ','Qiao ','Bi ','Zaa ','Yin ','Kaap ','Shan ','Su ','Sa ','Rui ','Zhuo ','Lu ','Ling ','Cha ',
        'Zaai ','Huan ','','','Jia ','Ban ','Hu ','Dou ','Caam ','Lou ','','Juan ','Ke ','Suo ','Ge ','Zhe ',
        'Ding ','Duan ','Zhu ','Yan ','Pang ','Cha ','','','','','Yi ','Zin ','','You ','Gun ','Yao ',
        'Yao ','Shi ','Gong ','Qi ','Gen ','Gwong ','','Hou ','Mi ','Fu ','Hu ','Guang ','Dan ','Dai ','Tou ','Yan ',
        '','Dung ','Qu ','','Chang ','Ming ','Tou ','Bao ','On ','Ceon ','Zung ','Xian ','','','','Mao ',
        'Lang ','Nan ','Pei ','Chen ','Hau ','Fei ','Cou ','Gei ','Qie ','Dai ','Sik ','Kun ','Die ','Lu ','Thung ','',
        ],
    'x3b':[
        '','Caap ','Yu ','Tai ','Chan ','Man ','Mian ','Huan ','Wan ','Nuan ','Huan ','Hou ','Jing ','Bo ','Xian ','Li ',
        'Jin ','','Mang ','Piao ','Hao ','Yang ','','Xian ','Su ','Wei ','Che ','Kap ','Jin ','Ceng ','He ','',
        'Shai ','Ling ','Fui ','Dui ','Zaap ','Pu ','Yue ','Bo ','','Hui ','Die ','Yan ','Ju ','Jiao ','Kuai ','Lie ',
        'Yu ','Ti ','Tim ','Wu ','Hong ','Xiao ','Hao ','','Tiu ','Zaang ','','Huang ','Fu ','','','Dun ',
        '','Reng ','Jiao ','Gong ','Xin ','','','Yuan ','Jue ','Hua ','Sik ','Bang ','Mou ','Cat ','Gong ','Wei ',
        '','Mei ','Si ','Bian ','Lu ','Keoi ','','','He ','She ','Lu ','Pai ','Rong ','Qiu ','Lie ','Gong ',
        'Xian ','Xi ','Hing ','','Niao ','','','','Xie ','Lei ','Fu ','Cuan ','Zhuo ','Fei ','Zuo ','Die ',
        'Ji ','He ','Ji ','','Gin ','','','','Tu ','Xian ','Yan ','Tang ','Ta ','Di ','Jue ','Ang ',
        'Han ','Yao ','Ju ','Rui ','Bang ','Zeoi ','Nie ','Tian ','Nai ','','','You ','Mian ','Zin ','Bui ','Nai ',
        'Xing ','Qi ','Zaan ','Gen ','Tong ','Er ','Jia ','Qin ','Mao ','E ','Li ','Chi ','Zong ','He ','Jie ','Ji ',
        '','Guan ','Hou ','Gai ','Cung ','Fen ','Se ','Waat ','Ji ','Sik ','Qiong ','He ','Zung ','Xian ','Jie ','Hua ',
        'Bi ','Sing ','Caai ','Zhen ','Sau ','Zin ','Shi ','Gai ','Song ','Zhi ','Ben ','','','','Lang ','Bi ',
        'Xian ','Bang ','Dai ','Cat ','Zi ','Pi ','Chan ','Bi ','Su ','Huo ','Hen ','Ying ','Chuan ','Jiang ','Nen ','Gu ',
        'Fang ','','','Ta ','Cui ','Sai ','De ','Ran ','Kuan ','Che ','Da ','Hu ','Cui ','Lu ','Juan ','Lu ',
        'Qian ','Pao ','Zhen ','Fan ','Li ','Cao ','Qi ','','','Ti ','Ling ','Qu ','Lian ','Lu ','Shu ','Gong ',
        'Zhe ','Biao ','Jin ','Qing ','','','Zong ','Pu ','Jin ','Biao ','Jian ','Gun ','','Ban ','Zou ','Lie ',
        ],
    'x3c':[
        'Li ','Luo ','Shen ','Mian ','Jian ','Di ','Bei ','Cim ','Lian ','Zeon ','Xun ','Pin ','Que ','Long ','Zui ','Gou ',
        'Jue ','San ','She ','','Xie ','Hei ','Lan ','Cu ','Yi ','Nuo ','Li ','Yue ','','Yi ','Ci ','Ji ',
        'Kang ','Xie ','Hang ','Zi ','Ke ','Hui ','Qu ','Hai6','Hei ','Hoi ','Wa ','Caam ','Xun ','Haap6','Shen ','Kou ',
        'Qie ','Sha ','Xu ','Ya ','Po ','Zu ','You ','Zi ','Lian ','Jin ','Xia ','Yi ','Qie ','Mi ','Jiao ','Hei ',
        'Chi ','Shi ','Fong ','Yin ','Mo ','Yi ','Hei ','Se ','Jin ','Ye ','Zaau ','Que ','Che ','Luan ','Kwaan ','Zheng ',
        '','','Ho ','','Se ','Gwai ','Cui ','Zaau ','An ','Xiu ','Can ','Chuan ','Zha ','','Ji ','Bo ',
        'Fu ','Sing ','Lang ','Tui ','Sek6','Ling ','E ','Wo ','Lian ','Du ','Men ','Lan ','Wei ','Duan ','Kuai ','Ai ',
        'Zai ','Hui ','Yi ','Mo ','Zi ','Ben ','Beng ','','Bi ','Li ','Lu ','Luo ','Hoi ','Dan ','Goi ','Que ',
        'Chen ','Hung ','Cheng ','Jiu ','Kou ','Ji ','Ling ','Ci ','Shao ','Kai ','Rui ','Chuo ','Neng ','Zi ','Lou ','Bao ',
        '','','Bao ','Rong ','Saan ','Lei ','Siu ','Fu ','Qu ','Saau ','Saa ','Zhi ','Tan ','Rong ','Zu ','Ying ',
        'Mao ','Nai ','Bian ','Saau ','Seoi ','Tang ','Han ','Zao ','Rong ','','Dang ','Pu ','Ziu ','Tan ','','Ran ',
        'Ning ','Lie ','Die ','Die ','Zhong ','Siu ','Lu ','Dan ','Kap ','Gui ','Ji ','Ni ','Yi ','Nian ','Yu ','Wang ',
        'Guo ','Ze ','Yan ','Cui ','Xian ','Jiao ','Shu ','Fu ','Pei ','Ngoet ','Zaau ','Zaau ','At ','Bu ','Bian ','Chi ',
        'Sa ','Yi ','Bian ','','Dui ','Lan ','Zi ','Chai ','Cung ','Xuan ','Yu ','Yu ','Zaau ','Hong ','Cung ','',
        'Ta ','Gwo ','','','Suk6','Ju ','Xie ','Xi ','Jian ','Tan ','Pan ','Ta ','Xuan ','Xian ','Niao ','Tan ',
        'Gaau ','','','','Mi ','Ji ','Gou ','Wen ','Faa ','Wang ','You ','Ze ','Bi ','Mi ','Goeng ','Xie ',
        ],
    'x3d':[
        'Fan ','Yi ','Dam ','Lei ','Ying ','Siu ','Jin ','She ','Yin ','Ji ','Zyun ','Su ','','','','Wang ',
        'Mian ','Su ','Yi ','Zai ','Se ','Ji ','Luo ','Zaau ','Mao ','Zha ','Sui ','Zhi ','Bian ','Li ','Caai ','',
        '','','','','','Qiao ','Guan ','','Zhen ','Zung ','Nie ','Jun ','Xie ','Yao ','Xie ','Zi ',
        'Neng ','Sam ','Si ','Long ','Chen ','Mi ','Que ','Dam ','Na ','','','','Su ','Xie ','Bo ','Ding ',
        'Cuan ','Fong ','Chuang ','Che ','Han ','Dan ','Hao ','','','','Shen ','Mi ','Chan ','Men ','Han ','Cui ',
        'Jue ','He ','Fei ','Shi ','Che ','Shen ','Nu ','Fu ','Man ','Cing ','','','','Yi ','Chou ','Mei ',
        'Faat ','Bao ','Lei ','Ke ','Dian ','Bi ','Sui ','Ge ','Bi ','Yi ','Xian ','Ni ','Ying ','Zhu ','Chun ','Feng ',
        'Xu ','Piao ','Wu ','Liao ','Cang ','Zou ','Ceoi ','Bian ','Yao ','Huan ','Pai ','Sou ','','Dui ','Jing ','Xi ',
        'Bak6','Guo ','','','Yan ','Xue ','Chu ','Heng ','Ying ','','','','Lian ','Xian ','Huan ','Zaan ',
        '','Lian ','Shan ','Cang ','Bei ','Jian ','Shu ','Fan ','Dian ','','Ba ','Yu ','Zyun ','','Nang ','Lei ',
        'Yi ','Dai ','','Chan ','Chao ','Gon ','Jin ','Nen ','Pei ','','','Liao ','Mei ','Jiu ','Siu ','Liu ',
        'Han ','','Yong ','Jin ','Chi ','Ren ','Nong ','','','Hong ','Tian ','Bung ','Oi ','Gwaa ','Biu ','Bo ',
        'Qiong ','','Shu ','Cui ','Hui ','Chao ','Dou ','Guai ','E ','Wei ','Fen ','Tan ','','Lun ','He ','Yong ',
        'Hui ','Nim6','Yu ','Zong ','Yan ','Qiu ','Zhao ','Jiong ','Tai ','Zin ','','Bou ','','Dut ','','Tui ',
        'Lin ','Jiong ','Zha ','Sing ','He ','Zing ','Xu ','','','Hei ','Cui ','Qing ','Mo ','Fung ','Zou ','Beng ',
        'Li ','','','Yan ','Ge ','Mo ','Bei ','Juan ','Die ','Shao ','','Wu ','Yan ','','Jue ','Hin ',
        ],
    'x3e':[
        'Tai ','Han ','','Dian ','Ji ','Jie ','','','Ziu ','Xie ','La ','Fan ','Huo ','Xi ','Nie ','Mi ',
        'Ran ','Cuan ','Yin ','Mi ','','Jue ','Keoi ','Tong ','Wan ','Ze ','Li ','Shao ','Kong ','Kan ','Ban ','Taai ',
        'Tiao ','Syu ','Bei ','Ye ','Pian ','Chan ','Hu ','Ken ','Gaau ','An ','Chun ','Qian ','Bei ','Baa ','Fen ','Fo ',
        'Tuo ','Tuo ','Zuo ','Ling ','','Gui ','Zin ','Shi ','Hou ','Lie ','Saa ','Si ','Fung ','Bei ','Ren ','Du ',
        'Bo ','Liang ','Ci ','Bi ','Ji ','Zong ','Fai ','He ','Li ','Yuan ','Yue ','Saau ','Chan ','Di ','Lei ','Jin ',
        'Chong ','Si ','Pu ','Yi ','Goeng ','Fun ','Huan ','Tao ','Ru ','Ying ','Ying ','Rao ','Yin ','Shi ','Yin ','Jue ',
        'Tun ','Xuan ','Gaa ','Zung ','Qie ','Zhu ','Ciu ','Zoeng ','You ','','Saan ','Xi ','Shi ','Yi ','Mo ','Zaau ',
        '','Hu ','Xiao ','Wu ','Gang ','Jing ','Ting ','Shi ','Ni ','Gang ','Ta ','Waai ','Chu ','Chan ','Piao ','Diao ',
        'Nao ','Nao ','Gan ','Gou ','Yu ','Hou ','','Si ','Ci ','Hu ','Yang ','Zung ','Xian ','Ban ','Rong ','Lou ',
        'Zhao ','Can ','Liao ','Piao ','Hai ','Fan ','Han ','Dan ','Zhan ','','Ta ','Zhu ','Ban ','Jian ','Yu ','Zhuo ',
        'You ','Li ','Kut ','Hei ','Cim ','Chan ','Lian ','Hei ','Si ','Jiu ','Pu ','Qiu ','Gong ','Zi ','Yu ','',
        'Si ','Reng ','Niu ','Mei ','Baat ','Jiu ','','Xu ','Ping ','Bian ','Mao ','','','','','Yi ',
        'You ','Gwai ','Ping ','Kuk ','Bao ','Hui ','','','','Bu ','Mang ','La ','Tu ','Wu ','Li ','Ling ',
        '','Ji ','Jun ','Lit6','Duo ','Jue ','Dai ','Bei ','','','','','','La ','Bian ','Sui ',
        'Tu ','Die ','','','','','','Duo ','','','Sui ','Bi ','Tu ','Se ','Can ','Tu ',
        'Mian ','Zeon ','Lu ','','','Zhan ','Bi ','Ji ','Cen ','Hyun ','Li ','','','Sui ','Zung ','Shu ',
        ],
    'x3f':[
        '','','E ','','Gei ','','','Qiong ','Luo ','Yin ','Tun ','Gu ','Yu ','Lei ','Bei ','Nei ',
        'Pian ','Lian ','Qiu ','Lian ','Waan ','Dong ','Li ','Ding ','Wa ','Zhou ','Gong ','Xing ','Ang ','Fan ','Peng ','Bai ',
        'Tuo ','Syu ','E ','Bai ','Qi ','Chu ','Gong ','Tong ','Han ','Cheng ','Jia ','Huan ','Xing ','Dian ','Mai ','Dong ',
        'E ','Ruan ','Lie ','Sheng ','Ou ','Di ','Yu ','Chuan ','Rong ','Hong ','Tang ','Cong ','Piao ','Shuang ','Lu ','Tong ',
        'Zheng ','Li ','Sa ','Ban ','Si ','Dang ','Dong ','Guai ','Yi ','Han ','Xie ','Luo ','Liu ','Ham ','Dan ','',
        'Cim ','Tan ','Saang ','','','You ','Nan ','','Gang ','Jun ','Chi ','Kou ','Wan ','Li ','Liu ','Lie ',
        'Xia ','Baai ','An ','Yu ','Ju ','Rou ','Xun ','Zi ','Cuo ','Can ','Zeng ','Yong ','Fu ','Ruan ','Sing ','Xi ',
        'Shu ','Jiao ','Jiao ','Han ','Zhang ','Zong ','','Shui ','Chen ','Fan ','Ji ','Zi ','','Gu ','Wu ','Wo ',
        'Qie ','Shu ','Hoi ','Tuo ','Du ','Si ','Ran ','Mu ','Fu ','Ling ','Ji ','Xiu ','Xuan ','Nai ','At ','Jie ',
        'Li ','Da ','Ji ','Zyun ','Lu ','Shen ','Li ','Lang ','Geng ','Yin ','Se ','Qin ','Qie ','Che ','You ','Bu ',
        'Huang ','Que ','Lai ','Zaam ','Hong ','Xu ','Bang ','Ke ','Qi ','Gwaai ','Sheng ','Pin ','Gaai ','Zhou ','Huang ','Tui ',
        'Hu ','Bei ','','','Zaa ','Ji ','Gu ','Sai ','Gao ','Chai ','Ma ','Zhu ','Tui ','Tui ','Lian ','Lang ',
        'Baan ','','Zing ','Dai ','Ai ','Xian ','Gwo ','Xi ','Zung ','Tui ','Can ','Sao ','Cim ','Jie ','Fen ','Qun ',
        '','Yao ','Dao ','Jia ','Lei ','Yan ','Lu ','Tui ','Ying ','Pi ','Luo ','Li ','Bie ','Hoeng ','Mao ','Bai ',
        'huang ','Dau ','Yao ','He ','Chun ','Hu ','Ning ','Chou ','Li ','Tang ','Huan ','Bi ','Baa ','Che ','Yang ','Da ',
        'Ao ','Xue ','Zi ','','Daap ','Ran ','Bong ','Zao ','Wan ','Ta ','Bao ','Gon ','Yan ','Gaai ','Zhu ','Ya ',
        ],
    'x40':[
        'Fan ','You ','On ','Tui ','Meng ','She ','Jin ','Gu ','Qi ','Qiao ','Jiao ','Yan ','','Kan ','Mian ','Xian ',
        'San ','Na ','Cin ','Huan ','Niu ','Cheng ','Tin ','Jue ','Xi ','Qi ','Ang ','Mei ','Gu ','','Tou ','Fan ',
        'Qu ','Chan ','Shun ','Bi ','Mao ','Shuo ','Gu ','Hong ','Huan ','Luo ','Hang ','Jia ','Quan ','Goi ','Mang ','Bu ',
        'Gu ','Fung ','Mu ','Ai ','Ying ','Shun ','Lang ','Jie ','Di ','Jie ','Cau ','Pin ','Ren ','Yan ','Du ','Di ',
        '','Lang ','Xian ','Biu ','Xing ','Bei ','An ','Mi ','Qi ','Qi ','Wo ','She ','Yu ','Jia ','Cheng ','Yao ',
        'Ying ','Yang ','Ji ','Jie ','Han ','Min ','Lou ','Kai ','Yao ','Yan ','Sun ','Gui ','Huang ','Ying ','Sheng ','Cha ',
        'Lian ','','Xuan ','Chuan ','Che ','Ni ','Qu ','Miao ','Huo ','Yu ','Nan ','Hu ','Ceng ','Biu ','Qian ','She ',
        'Jiang ','Ao ','Mai ','Mang ','Zhan ','Bian ','Jiao ','Jue ','Nong ','Bi ','Shi ','Li ','Mo ','Lie ','Mie ','Mo ',
        'Xi ','Chan ','Qu ','Jiao ','Huo ','Zin ','Xu ','Nang ','Tong ','Hou ','Yu ','','Cung ','Bo ','Zuan ','Diu ',
        'Chuo ','Ci ','Jie ','Kwai ','Xing ','Hui ','Shi ','Gwaat6','Caam ','','Yao ','Yu ','Bang ','Jie ','Zhe ','Gaa ',
        'She ','Di ','Dong ','Ci ','Fu ','Min ','Zhen ','Zhen ','','Yan ','Diao ','Hong ','Gong ','Diu6','Lue ','Guai ',
        'La ','Cui ','Fa ','Cuo ','Yan ','Gung ','Jie ','Gwaai ','Guo ','Suo ','Wan ','Zheng ','Nie ','Diao ','Lai ','Ta ',
        'Cui ','Aa ','Gun ','','','Dai ','','Mian ','Gaai ','Min ','Ju ','Yu ','Zan ','Zhao ','Ze ','Saang ',
        '','Pan ','He ','Gou ','Hong ','Lao ','Wu ','Chuo ','Hang ','Lu ','Cu ','Lian ','Zi ','Qiao ','Shu ','',
        'xuan ','Cen ','Zaam ','Hui ','Su ','Chuang ','Deon ','Long ','','Nao ','Tan ','Dan ','Wei ','Gan ','Da ','Li ',
        'Caat ','Xian ','Pan ','La ','Zyu ','Niao ','Huai ','Ying ','Xian ','Lan ','Mo ','Ba ','','Fu ','Bi ','Fu ',
        ],
    'x41':[
        'Huo ','Yi ','Liu ','Zoeng ','Zaan ','Juan ','Huo ','Cheng ','Dou ','E ','','Yan ','Zhui ','Du ','Qi ','Yu ',
        'Quan ','Huo ','Nie ','Heng ','Ju ','She ','','','Peng ','Ming ','Cao ','Lou ','Li ','Chun ','','Cui ',
        'Shan ','Daam ','Qi ','','Lai ','Ling ','Liao ','Reng ','Yu ','Nao ','Chuo ','Qi ','Yi ','Nian ','Fu ','Jian ',
        'Ya ','Fong ','Chui ','Cin ','','','Bi ','Dan ','Po ','Nian ','Zhi ','Chao ','Tian ','Tian ','Rou ','Yi ',
        'Lie ','An ','He ','Qiong ','Li ','Gwai ','Zi ','Su ','Yuan ','Ya ','Du ','Wan ','Gyun ','Dong ','You ','Hui ',
        'Jian ','Rui ','Mang ','Ju ','Zi ','Geoi ','An ','Sui ','Lai ','Hun ','Qiang ','Coeng ','Duo ','Hung ','Na ','Can ',
        'Ti ','Xu ','Jiu ','Huang ','Qi ','Jie ','Mao ','Yan ','Heoi ','Zhi ','Tui ','','Ai ','Pang ','Cang ','Tang ',
        'En ','Hun ','Qi ','Chu ','Suo ','Zhuo ','Nou ','Tu ','Zu ','Lou ','Miao ','Li ','Man ','Gu ','Cen ','Hua ',
        'Mei ','Gou ','Lian ','Dao ','Shan ','Ci ','','','Zhi ','Ba ','Cui ','Qiu ','','Long ','Cim ','Fei ',
        'Guo ','Cheng ','Jiu ','E ','Cung ','Jue ','Hong ','Jiao ','Cuan ','Yao ','Tong ','Cha ','You ','Shu ','Yao ','Ge ',
        'Huan ','Lang ','Jue ','Chen ','Cyun ','Cyun ','Shen ','Fo ','Ming ','Ming ','Hung ','Chuang ','Yun ','Han6','Jin ','Chuo ',
        'Zyu ','Tan ','Hong ','Qiong ','','Cheng ','Zaau ','Yu ','Cheng ','Tong ','Pun ','Qiao ','Fo ','Ju ','Lan ','Yi ',
        'Rong ','Si ','Hin ','Si ','Ngat ','Fa ','','Meng ','Gui ','','','Hai ','Qiao ','Chuo ','Que ','Dui ',
        'Li ','Ba ','Jie ','Seoi ','Luo ','Deoi ','Yun ','Zung ','Hu ','Yin ','Pok ','Zhi ','Lian ','Zim ','Gan ','Jian ',
        'Zhou ','Zhu ','Ku ','Na ','Dui ','Ze ','Yang ','Zhu ','Gong ','Yi ','Ci ','Gei ','Chuang ','Lao ','Ren ','Rong ',
        'Zing ','Na ','Ce ','Zin ','','Yi ','Jue ','Bi ','Cheng ','Jun ','Chou ','Hui ','Chi ','Zhi ','Yan ','',
        ],
    'x42':[
        'Saan ','Lun ','Bing ','Zhao ','Han ','Yu ','Dai ','Zhao ','Fei ','Sha ','Ling ','Ta ','Zeoi ','Mang ','Ye ','Bao ',
        'Kui ','Gua ','Nan ','Ge ','Gaa ','Chi ','Fo ','Suo ','Ci ','Zhou ','Tai ','Kuai ','Qin ','Seoi ','Du ','Ce ',
        'Huan ','Gung ','Sai ','Zheng ','Qian ','Gan ','Zung ','Wei ','','','Xi ','Na ','Pu ','Huai ','Ju ','Zaan ',
        'Sau ','Tou ','Pan ','Ta ','Qian ','Zung ','Rong ','Luo ','Hu ','Sou ','Zung ','Pu ','Mie ','Gan ','Shuo ','Mai ',
        'Shu ','Ling ','Lei ','Jiang ','Leng ','Zhi ','Diao ','','San ','Hu ','Fan ','Mei ','Sui ','Jian ','Tang ','Xie ',
        'Fu ','Mo ','Fan ','Lei ','Can ','Ceng ','Ling ','Zaap ','Cong ','Yun ','Meng ','Yu ','Zhi ','Qi ','Dan ','Huo ',
        'Wei ','Tan ','Se ','Xie ','Sou ','Song ','Cin ','Liu ','Yi ','Aau ','Lei ','Li ','Fei ','Lie ','Lin ','Xian ',
        'Yao ','Aau ','Bie ','Xian ','Rang ','Zhuan ','Soeng ','Dan ','Bian ','Ling ','Hong ','Qi ','Liao ','Ban ','Mi ','Hu ',
        'Hu ','Caap ','Ce ','Pei ','Qiong ','Ming ','Jiu ','Bu ','Mei ','San ','Mei ','Zong ','','Li ','Quan ','Sam ',
        'En ','Xiang ','Zing ','Shi ','Zing ','Gin ','Lan ','Huang ','Jiu ','Yan ','Deoi ','Sa ','Tuan ','Xie ','Zhe ','Men ',
        'Xi ','Man ','Zoeng ','Huang ','Tan ','Xiao ','Ya ','Bi ','Luo ','Fan ','Li ','Cui ','Cha ','Chou ','Di ','Kuang ',
        'Chu ','Cim ','Chan ','Mi ','Qian ','Qiu ','Zhen ','Zi ','Heoi ','Cim ','Gu ','Yan ','Chi ','Guai ','Mu ','Bo ',
        'Kua ','Geng ','Yao ','Mao ','Wang ','','','','Ru ','Jue ','Zing ','Min ','Jiang ','O ','Zhan ','Zuo ',
        'Yue ','Bing ','Nou6','Zhou ','Bi ','Ren ','Yu ','Gin ','Chuo ','Er ','Yi ','Mi ','Qing ','Zing ','Wang ','Ji ',
        'Bu ','Syu ','Bie ','Fan ','Yao ','Li ','Fan ','Qu ','Fu ','Er ','O ','Zang ','Zim ','Huo ','Jin ','Qi ',
        'Ju ','Lai ','Che ','Bei ','Niu ','Yi ','Xu ','Liu ','Xun ','Fu ','Cau ','Nin ','Ting ','Beng ','Zha ','Wui ',
        ],
    'x43':[
        'Fo ','Zaau ','Ou ','Shuo ','Geng ','Tang ','Gui ','Hui ','Ta ','Gong ','Yao ','Daap ','Qi ','Han ','Lue ','Mi ',
        'Mi ','Gin ','Lu ','Fan ','Ou ','Mi ','Jie ','Fu ','Mi ','Huang ','Su ','Yao ','Nie ','Jin ','Lian ','Bi ',
        'Qing ','Ti ','Ling ','Zuan ','Zhi ','Yin ','Dao ','Chou ','Cai ','Mi ','Yan ','Lan ','Chong ','Ziu ','Soeng ','Guan ',
        'She ','Luo ','Fan ','Si ','Luo ','Zhu ','Zi ','Chou ','Juan ','Jiong ','Er ','Yi ','Rui ','Cai ','Ren ','Fu ',
        'Lan ','Sui ','Yu ','Yao ','Dian ','Ling ','Zhu ','Ta ','Ping ','Qian ','Jue ','Chui ','Bu ','Gu ','Cun ','',
        'Han ','Han ','Mou ','Hu ','Hong ','Di ','Fu ','Xuan ','Mi ','Mei ','Lang ','Gu ','Zhao ','Ta ','Yu ','Zong ',
        'Li ','Liao ','Wu ','Lei ','Ji ','Lei ','Li ','Zong ','Bo ','Ang ','Kui ','Tuo ','Ping ','Cau ','Zhao ','Gui ',
        'Zaan ','Xu ','Nai ','Chuo ','Duo ','Kaap ','Dong ','Gui ','Bo ','Zin ','Huan ','Xuan ','Can ','Li ','Tui ','Huang ',
        'Xue ','Hu ','Bao ','Ran ','Tiao ','Fu ','Liao ','Zaau ','Yi ','Shu ','Po ','He ','Cu ','Fu ','Na ','An ',
        'Chao ','Lu ','Zhan ','Ta ','Fu ','Gwaang ','Zang ','Qiao ','Su ','Baan ','Guan ','','Fan ','Chu ','','Er ',
        'Er ','Nuan ','Qi ','Si ','Chu ','','Yan ','Bang ','An ','Zi ','Ne ','Chuang ','Ba ','Ciu ','Ti ','Han ',
        'Zuo ','Ba ','Zhe ','Wa ','Sheng ','Bi ','Er ','Zhu ','Wu ','Wen ','Zhi ','Zhou ','Lu ','Wen ','Gun ','Qiu ',
        'La ','Zai ','Sou ','Mian ','Zhi ','Qi ','Cao ','Piao ','Lian ','Saap ','Long ','Su ','Qi ','Yuan ','Feng ','Heoi ',
        'Jue ','Di ','Pian ','Guan ','Niu ','Ren ','Zhen ','Gai ','Pi ','Tan ','Chao ','Chun ','Ho ','Chun ','Mo ','Bie ',
        'Qi ','Shi ','Bi ','Jue ','Si ','Taam ','Hua ','Na ','Hui ','Kaap ','Er ','Caau ','Mou ','Zyu ','Xi ','Zhi ',
        'Ren ','Ju ','Die ','Zhe ','Shao ','Meng ','Bi ','Han ','Yu ','Xian ','Pong ','Neng ','Can ','Bu ','Pong ','Qi ',
        ],
    'x44':[
        'Ji ','Niao ','Lu ','Jiong ','Han ','Yi ','Cai ','Chun ','Zhi ','Zi ','Da ','Cung ','Tian ','Zhou ','Daai ','Chun ',
        'Cau ','Zhe ','Zaa ','Rou ','Bin ','Ji ','Yi ','Du ','Jue ','Ge ','Ji ','Dap ','Can ','Suo ','Ruo ','Xiang ',
        'Huang ','Qi ','Zhu ','Cuo ','Chi ','Weng ','Haap6','Kao ','Gu ','Kai ','Fan ','Sung ','Cao ','Zhi ','Chan ','Lei ',
        'Gaau ','Zak6','Zhe ','Yu ','Gui ','Huang ','Jin ','Daan ','Guo ','Sao ','Tan ','','Xi ','Man ','Duo ','Ao ',
        'Pi ','Wu ','Ai ','Meng ','Pi ','Meng ','Yang ','Zhi ','Bo ','Ying ','Wei ','Nao ','Lan ','Yan ','Chan ','Quan ',
        'Zhen ','Pu ','','Tai ','Fei ','Shu ','','Dang ','Cha ','Ran ','Tian ','Chi ','Ta ','Jia ','Shun ','Huang ',
        'Liao ','Caa ','Dou ','','Jin ','E ','Keoi ','Fu ','Duo ','','E ','','Yao ','Di ','','Di ',
        'Bu ','Man ','Che ','Lun ','Qi ','Mu ','Can ','','Zung ','Sau ','Fan ','You ','Saau ','Da ','','Su ',
        'Fu ','Ji ','Jiang ','Cao ','Bo ','Teng ','Che ','Fu ','Bu ','Wu ','Haai ','Yang ','Ming ','Pang ','Mang ','Zang ',
        'Meng ','Cao ','Tiao ','Kai ','Bai ','Xiao ','Xin ','Qi ','Seoi ','','Shao ','Heng ','Niu ','Xiao ','Chen ','Daan ',
        'Fan ','Yin ','Ang ','Ran ','Ri ','Fa ','Fan ','Qu ','Shi ','He ','Bian ','Dai ','Mo ','Deng ','','',
        'Hong ','Zing ','Cha ','Duo ','You ','Hao ','Tin ','Kut ','Xian ','Lei ','Jin ','Qi ','','Mei ','Zi ','',
        '','','Yan ','Yi ','Yin ','Qi ','Zhe ','Xi ','Yi ','Ye ','E ','','Zhi ','Han ','Chuo ','',
        'Chun ','Bing ','Kuai ','Chou ','','Tuo ','Qiong ','Cung ','Jiu ','Gwai ','Cu ','Fu ','','Meng ','Li ','Lie ',
        'Ta ','Zi ','Gu ','Liang ','Fat ','La ','Dian ','Ci ','Aang ','','','Ji ','','Cha ','Mao ','Du ',
        'Zaan ','Chai ','Rui ','Hen ','Ruan ','','Lai ','Xing ','Gan ','Yi ','Mei ','','He ','Ji ','So ','Han ',
        ],
    'x45':[
        'Seoi ','Li ','Zi ','Zu ','Yao ','Geoi ','Li ','Qi ','Gan ','Li ','','','','','Su ','Chou ',
        '','Xie ','Bei ','Xu ','Jing ','Pu ','Ling ','Xiang ','Zuo ','Diao ','Chun ','Qing ','Nan ','','Lu ','Chi ',
        'Shao ','Yu ','Hua ','Li ','','Siu ','','Li ','','','Dui ','','Yi ','Ning ','Si ','Hu ',
        'Fu ','Zaap ','Cheng ','Nan ','Ce ','Gaan ','Ti ','Qin ','Biao ','Sui ','Wei ','Deon ','Se ','Ai ','E ','Jie ',
        'Kuan ','Fei ','','Yin ','Zing ','Sao ','Dou ','Hui ','Xie ','Ze ','Tan ','Chang ','Zhi ','Yi ','Fu ','E ',
        '','Jun ','Gaa ','Cha ','Xian ','Man ','Syun ','Bi ','Ling ','Jie ','Kui ','Jia ','','Cing ','Lang ','Guk ',
        'Fei ','Lu ','Zha ','He ','','Ni ','Ying ','Xiao ','Teng ','Lao ','Ze ','Kui ','Goeng ','Qian ','Ju ','Piao ',
        'Ban ','Dou ','Lin ','Mi ','Zhuo ','Xie ','Hu ','Mi ','Gaai ','Za ','Cong ','Ge ','Nan ','Zhu ','Yan ','Han ',
        'Ceoi ','Yi ','Luan ','Yue ','Ran ','Ling ','Niang ','Yu ','Nue ','Heoi ','Yi ','Nue ','Qin ','Qian ','Xia ','Chu ',
        'Jin ','Mi ','','Na ','Han ','Zu ','Xia ','Yan ','Tu ','','Wu ','Suo ','Yin ','Chong ','Zhou ','Mang ',
        'Yuan ','Nu ','Miao ','Sao ','Wan ','Li ','','Na ','Shi ','Bi ','Ci ','Bang ','','Juan ','Xiang ','Gui ',
        'Pai ','Hong ','Xun ','Zha ','Yao ','Kwan ','','Hei ','E ','Yang ','Tiao ','You ','Jue ','Li ','','Li ',
        '','Ji ','Hu ','Zhan ','Fu ','Chang ','Guan ','Ju ','Meng ','Coeng ','Cheng ','Mou ','Sing ','Li ','Zaan ','',
        'Si ','Yi ','Bing ','Cung ','Hou ','Wan ','Chi ','','Ge ','Han ','Bo ','Saau ','Liu ','Can ','Can ','Yi ',
        'Xuan ','Yan ','Suo ','Gao ','Yong ','Zung ','Fung ','Hong ','Yu ','Cik ','Zhe ','Ma ','Fung ','','Shuang ','Jin ',
        'Guan ','Pu ','Lin ','','Ting ','Goeng ','La ','Yi ','Zung ','Ci ','Yan ','Jie ','Faan ','Wei ','Xian ','Ning ',
        ],
    'x46':[
        'Fu ','Ge ','','Mo ','Fu ','Nai ','Xian ','Wen ','Li ','Can ','Mie ','','Ni ','Chai ','Wan ','Xu ',
        'Nu ','Mai ','Co ','Kan ','Ho ','Hang ','','Faai ','Yu ','Wei ','Zhu ','Gei ','Gan ','Yi ','','',
        'Fu ','Bi ','Zhu ','Zi ','Shu ','Xia ','Ni ','','Jiao ','Xuan ','Cung ','Nou ','Rong ','Die ','Sa ','Sau ',
        '','Yu ','','Kaam ','Zung ','Lu ','Han ','','Yi ','Zui ','Zhan ','Su ','Wan ','Ni ','Guan ','Jue ',
        'Beng ','Can ','Zung ','Duo ','Qi ','Yao ','Gui ','Nuan ','Hou ','Xun ','Xie ','','Hui ','','Xie ','Bo ',
        'Ke ','Ceoi ','Xu ','Bai ','Aau ','Chu ','Bang ','Ti ','Chu ','Chi ','Niao ','Guan ','Feng ','Xie ','Dang ','Duo ',
        'Jue ','Hui ','Zeng ','Sa ','Duo ','Ling ','Meng ','Fan ','Guo ','Meng ','Long ','','Ying ','Hin ','Guan ','Cu ',
        'Li ','Du ','Ceng ','E ','Sin ','Saai ','','De ','De ','Jiang ','Lian ','','Shao ','Xi ','Si ','Wei ',
        '','','He ','You ','Lu ','Lai ','Ou ','Sheng ','Juan ','Qi ','','Yun ','','Qi ','Zong ','Leng ',
        'Ji ','Mai ','Chuang ','Nian ','Baan ','Li ','Ling ','Gong ','Chen ','','Xian ','Hu ','Bei ','Zu ','Dai ','Dai ',
        'Hun ','Soi ','Che ','Ti ','','Nuo ','Zhi ','Liu ','Fei ','Jiao ','Gwaan ','Ao ','Lin ','','Reng ','Tao ',
        'Pi ','Xin ','Shan ','Xie ','Wa ','Tao ','Tin ','Xi ','Xie ','Pi ','Yao ','Yao ','Nu ','Hao ','Nin ','Yin ',
        'Fan ','Nan ','Chi ','Wang ','Yuan ','Xia ','Zhou ','Yuan ','Shi ','Mi ','','Ge ','Pao ','Fei ','Hu ','Ni ',
        'Ci ','Mi ','Bian ','Gam ','Na ','Yu ','E ','Zhi ','Nin ','Xu ','Lue ','Hui ','Xun ','Nao ','Han ','Jia ',
        'Dou ','Hua ','Tuk ','','Cu ','Xi ','Song ','Mi ','Xin ','Wu ','Qiong ','Zheng ','Chou ','Xing ','Jiu ','Ju ',
        'Hun ','Ti ','Man ','Jian ','Qi ','Shou ','Lei ','Wan ','Che ','Can ','Jie ','You ','Hui ','Zha ','Su ','Ge ',
        ],
    'x47':[
        'Nao ','Xi ','','Deoi ','Chi ','Wei ','Mo ','Gun ','Cau ','','Zao ','Hui ','Luan ','Liao ','Lao ','',
        '','Qia ','Ao ','Nie ','Sui ','Mai ','Tan ','Xin ','Jing ','An ','Ta ','Chan ','Wei ','Tuan ','Ji ','Chen ',
        'Che ','Xu ','Xian ','Xin ','','Daan ','','Nao ','','Yan ','Qiu ','Hong ','Song ','Jun ','Liao ','Ju ',
        '','Man ','Lie ','','Chu ','Chi ','Xiang ','Cam ','Mei ','Shu ','Ce ','Chi ','Gu ','Yu ','Zaam ','',
        'Liao ','Lao ','Shu ','Zhe ','Soeng ','','Fat ','Fui ','E ','','Sha ','Zong ','Jue ','Jun ','','Lou ',
        'Wei ','Cung ','Zhu ','La ','Fun ','Zhe ','Zhao ','Zaau ','Yi ','','Ni ','Bo ','Syun ','Yi ','Hao ','Ya ',
        'Huan ','Man ','Man ','Qu ','Lao ','Hao ','','Men ','Xian ','Zhen ','Shu ','Zuo ','Zhu ','Gou ','Xuan ','Yi ',
        'Ti ','xie ','Jin ','Can ','Zai ','Bu ','Liang ','Zhi ','Ji ','Wan ','Guan ','Ceoi ','Qing ','Ai ','Fu ','Gui ',
        'Gou ','Xian ','Ruan ','Zhi ','Biao ','Yi ','Suo ','Die ','Gui ','Sheng ','Xun ','Chen ','She ','Qing ','','',
        'Chun ','Hong ','Dong ','Cheng ','Wei ','Die ','Shu ','Caai ','Ji ','Za ','Qi ','','Fu ','Ao ','Fu ','Po ',
        '','Tan ','Zha ','Che ','Qu ','You ','He ','Hou ','Gui ','E ','Jiang ','Yun ','Tou ','Qiu ','','Fu ',
        'Zuo ','Hu ','','Bo ','','Jue ','Di ','Jue ','Fu ','Huang ','','Yong ','Chui ','Suo ','Chi ','Hin ',
        '','','Man ','Ca ','Qi ','Jian ','Bi ','Gei ','Zhi ','Zhu ','Qu ','Zhan ','Ji ','Dian ','','Li ',
        'Li ','La ','Quan ','Ding ','Fu ','Cha ','Tang ','Shi ','Hang ','Qie ','Qi ','Bo ','Na ','Tou ','Chu ','Cu ',
        'Yue ','Di ','Chen ','Chu ','Bi ','Mang ','Ba ','Tian ','Min ','Lie ','Feng ','Caang ','Qiu ','Tiao ','Fu ','Kuo ',
        'Jian ','Ci ','','','Zhen ','Qiu ','Cuo ','Chi ','Kui ','Lie ','Bang ','Du ','Wu ','So ','Jue ','Lu ',
        ],
    'x48':[
        'Chang ','Zai ','Chu ','Liang ','Tian ','Kun ','Chang ','Jue ','Tu ','Hua ','Fei ','Bi ','','Qia ','Wo ','Ji ',
        'Qu ','Kui ','Hu ','Cu ','Sui ','','','Qiu ','Pi ','Bei ','Wa ','Jiao ','Rong ','','Cu ','Die ',
        'Chi ','Cuo ','Meng ','Xuan ','Duo ','Bie ','Zhe ','Chu ','Chan ','Gui ','Duan ','Zou ','Deng ','Lai ','Teng ','Yue ',
        'Quan ','Shu ','Ling ','','Qin ','Fu ','She ','Tiao ','','Ai ','','Qiong ','Diao ','Hai ','Shan ','Wai ',
        'Zhan ','Long ','Jiu ','Li ','','Min ','Rong ','Yue ','Jue ','Kang ','Fan ','Qi ','Hong ','Fu ','Lu ','Hong ',
        'Tuo ','Min ','Tian ','Juan ','Qi ','Zheng ','Jing ','Gong ','Tian ','Lang ','Mao ','Yin ','Lu ','Yun ','Ju ','Pi ',
        '','Xie ','Bian ','','Zeoi ','Rong ','Sang ','Wu ','Cha ','Gu ','Chan ','Peng ','Man ','Saau ','Zung ','Shuang ',
        'Keng ','Zhuan ','Chan ','Si ','Chuang ','Sui ','Bei ','Kai ','','Zhi ','Wei ','Min ','Ling ','','Nei ','Ling ',
        'Qi ','Yue ','Lip ','Yi ','Xi ','Chen ','','Rong ','Chen ','Nong ','You ','Ji ','Bo ','Fang ','Gei ','',
        'Cu ','Di ','Gaau ','Yu ','Ge ','Xu ','Lu ','He ','','Bai ','Gong ','Jiong ','Gwai ','Ya ','Nu ','You ',
        'Song ','Xie ','Cang ','Yao ','Shu ','Yan ','Shuai ','Liao ','Sung ','Yu ','Bo ','Sui ','Cin ','Yan ','Lei ','Lin ',
        'Tai ','Du ','Yue ','Ji ','Cin ','Yun ','Bong ','','','Ju ','Ceot ','Chen ','Cung ','Xiang ','Xian ','On ',
        'Gui ','Yu ','Lei ','','Tu ','Chen ','Xing ','Qiu ','Hang ','','Dang ','Cai ','Di ','Yan ','Ci ','Gung ',
        'Zing ','Chan ','','Li ','Suo ','Ma ','Ma ','','Tang ','Pei ','Lou ','Sat ','Cuo ','Tu ','E ','Can ',
        'Jie ','Ti ','Ji ','Dang ','Jiao ','Bi ','Lei ','Yi ','Chun ','Chun ','Po ','Li ','Zai ','Tai ','Po ','Tian ',
        'Ju ','Xu ','Fan ','','Xu ','Er ','Huo ','Zyu ','Ran ','Fa ','Gyun ','','Liang ','Ti ','Mi ','',
        ],
    'x49':[
        '','Cen ','Mei ','Yin ','Mian ','Tu ','Kui ','Sau ','Hei ','Mi ','Rong ','Guo ','Coeng ','Mi ','Ju ','Pi ',
        'Jin ','Wang ','Ji ','Meng ','Jian ','Xue ','Bao ','Gan ','Chan ','Li ','Li ','Qiu ','Dun ','Ying ','Yun ','Chen ',
        'Ji ','Ran ','','Lue ','','Gui ','Yue ','Hui ','Pi ','Cha ','Duo ','Chan ','So ','Kuan ','She ','Xing ',
        'Weng ','Shi ','Chi ','Ye ','Han ','Fei ','Ye ','Yan ','Zuan ','Saau ','Yin ','Duo ','Xian ','Gwaan ','Tou ','Qie ',
        'Chan ','Han ','Meng ','Yue ','Cu ','Qian ','Jin ','Shan ','Mu ','Zyun ','Coeng ','Baang ','Zheng ','Zhi ','Chun ','Yu ',
        'Mou ','Wan ','Chou ','Kei ','Su ','Pie ','Tian ','Kuan ','Cu ','Sui ','Co ','Jie ','Jian ','Ao ','Jiao ','Ye ',
        'Saam ','Ye ','Long ','Zao ','Bao ','Lian ','','Huan ','Lu ','Wei ','Xian ','Tie ','Bo ','Zheng ','Zhu ','Ba ',
        'Meng ','Xie ','Aau ','Zaau ','Teon ','Xiao ','Li ','Zha ','Mi ','','Ye ','','','Put ','Xie ','',
        '','Bong ','Shan ','Coeng ','','Shan ','Jue ','Ji ','Fang ','','Niao ','Ao ','Chu ','Wu ','Guan ','Xie ',
        'Ting ','Xie ','Dang ','Zim ','Tan ','Ping ','Xia ','Xu ','Bi ','Si ','Huo ','Zheng ','Wu ','','Run ','Chuai ',
        'Shi ','Huan ','Kuo ','Fu ','Chuai ','Xian ','Qin ','Qie ','Lan ','','Ya ','Zing ','Que ','','Chun ','Zhi ',
        'Gau ','Kui ','Qian ','Hang ','Yi ','Ni ','Zheng ','Chuai ','','Shi ','Cap ','Ci ','Jue ','Xu ','Yun ','',
        '','Chu ','Dao ','Dian ','Ge ','Ti ','Hong ','Ni ','','Li ','','Xian ','Seoi ','Xi ','Xuan ','',
        'Gwik ','Taai ','Lai ','Zau ','Mu ','Cheng ','Jian ','Bi ','Qi ','Ling ','Hao ','Bang ','Tang ','Di ','Fu ','Xian ',
        'Shuan ','Zung ','Keoi ','Zaan ','Pu ','Hui ','Wei ','Yi ','Ye ','','Che ','Hao ','Baai ','','Xian ','Chan ',
        'Hun ','Gaau ','Han ','Ci ','Zi ','Qi ','Kui ','Rou ','Gu ','Zing ','Xiong ','Gap ','Hu ','Cui ','Syu ','Que ',
        ],
    'x4a':[
        'Di ','Che ','Cau ','','Yan ','Liao ','Bi ','Soeng ','Ban ','Zing ','','Nue ','Bao ','Ying ','Hong ','Ci ',
        'Qia ','Ti ','Yu ','Lei ','Bao ','Wu ','Ji ','Fu ','Xian ','Cen ','Fat ','Se ','Baang ','Cing ','Yu ','Waa ',
        'Ai ','Han ','Dan ','Ge ','Di ','Hu ','Pang ','Zaam ','Zaa ','Ling ','Mai ','Mai ','Lian ','Siu ','Xue ','Zhen ',
        'Po ','Fu ','Nou ','Xi ','Dui ','Dan ','Yun ','Xian ','Yin ','Suk ','Dui ','Beng ','Hu ','Fei ','Fei ','Qian ',
        'Bei ','Fei ','','Shi ','Tian ','Zhan ','Jian ','','Hui ','Fu ','Wan ','Mo ','Qiao ','Liao ','','Mie ',
        'Ge ','Hong ','Yu ','Qi ','Duo ','Ang ','Saa ','Ba ','Di ','Xuan ','Di ','Bi ','Zhou ','Pao ','Nian ','Yi ',
        'Ting ','Jia ','Da ','Duo ','Xi ','Dan ','Tiao ','Xie ','Chang ','Yuan ','Guan ','Liang ','Beng ','Gei ','Lu ','Ji ',
        'Xuan ','Shu ','Dou ','Shu ','Hu ','Yun ','Chan ','Bong ','Rong ','E ','Zung ','Ba ','Feng ','Zyu ','Zhe ','Fen ',
        'Guan ','Bu ','Ge ','Deon ','Huang ','Du ','Ti ','Bo ','Qian ','La ','Long ','Wei ','Zhan ','Lan ','Seoi ','Na ',
        'Bi ','Tuo ','Jiao ','','Bu ','Ju ','Po ','Xia ','Wei ','Fu ','He ','Fan ','Chan ','Hu ','Za ','',
        'Saai ','Zai ','Zai ','Zai ','Fan ','Die ','Hong ','Chi ','Bao ','Yin ','','Haang ','Bo ','Ruan ','Chou ','Ying ',
        'Zi ','Gai ','Kwaan ','Yun ','Zhen ','Ya ','Zeoi ','Hou ','Min ','Pei ','Ge ','Bian ','Zyut ','Hao ','Mi ','Sheng ',
        'Gen ','Bi ','Duo ','Chun ','Chua ','San ','Cheng ','Ran ','Zen ','Mao ','Bo ','Tui ','Pi ','Fu ','Zyut ','Hei ',
        'Lin ','Hei ','Men ','Wu ','Qi ','Zhi ','Chen ','Xia ','He ','Sang ','Gwaa ','Hou ','Au ','Fu ','Rao ','Hun ',
        'Pei ','Qian ','Si ','Xi ','Ming ','Kui ','Ge ','','Ao ','San ','Shuang ','Lou ','Zhen ','Hui ','Can ','Ci ',
        'Lin ','Na ','Han ','Du ','Jin ','Mian ','Fan ','E ','Nao ','Hong ','Hong ','Xue ','Xue ','Pau ','Bi ','Ciu ',
        ],
    'x4b':[
        'You ','Yi ','Xue ','Sa ','Yu ','Li ','Li ','Yuan ','Dui ','Hao ','Qie ','Leng ','Paau ','Fat ','Guo ','Bu ',
        'Wei ','Wei ','Saau ','An ','Xu ','Shang ','Heng ','Yang ','Gwik ','Yao ','Fan ','Bi ','Ci ','Heng ','Tao ','Liu ',
        'Fei ','Zhu ','Tou ','Qi ','Chao ','Yi ','Dou ','Yuan ','Cu ','Zai ','Bo ','Can ','Yang ','Tou ','Yi ','Nian ',
        'Shao ','Ben ','Ngaau ','Ban ','Mo ','Ai ','En ','She ','Caan ','Zhi ','Yang ','Jian ','Yuan ','Dui ','Ti ','Wei ',
        'Xun ','Zhi ','Yi ','Ren ','Shi ','Hu ','Ne ','Yi ','Jian ','Sui ','Ying ','Bao ','Hu ','Hu ','Xie ','',
        'Yang ','Lian ','Sik ','En ','Deoi ','Jian ','Zhu ','Ying ','Yan ','Jin ','Chuang ','Dan ','','Kuai ','Yi ','Ye ',
        'Jian ','En ','Ning ','Ci ','Qian ','Xue ','Bo ','Mi ','Shui ','Mi ','Liang ','Qi ','Qi ','Shou ','Bi ','Bo ',
        'Beng ','Bie ','Ni ','Wei ','Huan ','Fan ','Qi ','Liu ','Fu ','Ang ','Ang ','Fan ','Qi ','Qun ','Tuo ','Yi ',
        'Bo ','Pian ','Bo ','Keoi ','Xuan ','','Baai6','Yu ','Chi ','Lu ','Yi ','Li ','Zaau ','Niao ','Xi ','Wu ',
        'Gwing ','Lei ','Pei ','Zhao ','Zui ','Chuo ','Coeng ','An ','Er ','Yu ','Leng ','Fu ','Sha ','Huan ','Chu ','Sou ',
        'Bik ','Bi ','Die ','Song ','Di ','Li ','Giu ','Han ','Zai ','Gu ','Cheng ','Lou ','Mo ','Mi ','Mai ','Ao ',
        'Dan ','Zhu ','Huang ','Fan ','Deng ','Tong ','','Du ','Hu ','Wei ','Ji ','Chi ','Lin ','Biu ','Pang ','Jian ',
        'Nie ','Luo ','Ji ','Ngon ','Waa ','Nie ','Yi ','Gwaat6','Wan ','Ya ','Qia ','Bo ','Hau ','Ling ','Gan ','Huo ',
        'Hai ','Hong ','Heng ','Kui ','Cen ','Ting ','Lang ','Bi ','Huan ','Po ','Ou ','Jian ','Ti ','Sui ','Kwaa ','Dui ',
        'Ao ','Jian ','Mo ','Gui ','Kuai ','An ','Ma ','Qing ','Fen ','','Kao ','Hao ','Duo ','Cim ','Nai ','Seoi ',
        'Jie ','Fu ','Pa ','Sung ','Chang ','Nie ','Man ','Sung ','Ci ','Cim ','Kuo ','Gai ','Di ','Fu ','Tiao ','Zu ',
        ],
    'x4c':[
        'Wo ','Fei ','Cai ','Peng ','Shi ','Sou ','Rou ','Qi ','Cha ','Pan ','Bo ','Man ','Zong ','Ci ','Gui ','Ji ',
        'Lan ','Siu ','Meng ','Mian ','Pan ','Lu ','Cuan ','Gau ','Liu ','Yi ','Wen ','Li ','Li ','Zeng ','Zhu ','Hun ',
        'Shen ','Chi ','Xing ','Wang ','Dung ','Huo ','Pi ','Bou6','Mei ','Che ','Mei ','Chao ','Ju ','Nou ','','Ni ',
        'Ru ','Ling ','Ya ','','Qi ','Zi ','','Bang ','Gung ','Ze ','Jie ','Yu ','Xin ','Bei ','Ba ','Tuo ',
        'Ong ','Qiao ','You ','Di ','Jie ','Mo ','Sheng ','Shan ','Qi ','Shan ','Mi ','Dan ','Yi ','Geng ','Geng ','Tou ',
        'Fu ','Xue ','Yi ','Ting ','Tiao ','Mou ','Liu ','Caan ','Li ','Suk ','Lu ','Xu ','Cuo ','Ba ','Liu ','Ju ',
        'Zhan ','Ju ','Zang ','Zu ','Xian ','Zhi ','','','Zhi ','','','La ','Seoi ','Geng ','E ','Mu ',
        'Zhong ','Di ','Yan ','Zin ','Geng ','Zung ','Lang ','Yu ','Caau ','Na ','Hai ','Hua ','Zhan ','Coeng ','Lou ','Chan ',
        'Die ','Wei ','Xuan ','Zao ','Min ','Kwai ','Sou ','','','Si ','Tuo ','Cen ','Kuan ','Teng ','Nei ','Lao ',
        'Lu ','Yi ','Xie ','Yan ','Qing ','Pu ','Chou ','Xian ','Guan ','Jie ','Lai ','Meng ','Ye ','Ceoi ','Li ','Yin ',
        'Ceon ','Cau ','Teng ','Yu ','','Gau ','Cha ','Du ','Hong ','Si ','Xi ','Gaau ','Qi ','Ci ','Yuan ','Ji ',
        'Yun ','Fang ','Gung ','Hang ','Zhen ','Hu ','','','Jie ','Pei ','Gan ','Xuan ','Saang ','Dao ','Qiao ','Ci ',
        'Die ','Ba ','Tiao ','Wan ','Ci ','Zhi ','Bai ','Wu ','Bao ','Dan ','Ba ','Tong ','Gyun ','Gung ','Jiu ','Gui ',
        'Ci ','You ','Yuan ','Lao ','Jiu ','Fou ','Nei ','E ','E ','Xing ','He ','Yan ','Tu ','Bu ','Beng ','Kou ',
        'Chui ','Zeoi ','Qi ','Yuan ','Bit ','','Hyun ','Hou ','Huang ','Ziu ','Juan ','Kui ','E ','Ji ','Mo ','Chong ',
        'Bao ','Wu ','Zhen ','Xu ','Da ','Chi ','Gaai ','Cong ','Ma ','Kou ','Yan ','Can ','Aau ','He ','Dang ','Lan ',
        ],
    'x4d':[
        'Tong ','Yu ','Hang ','Nao ','Li ','Fen ','Pu ','Ling ','Ao ','Xuan ','Yi ','Xuan ','Meng ','Ang ','Lei ','Yan ',
        'Bao ','Die ','Ling ','Shi ','Jiao ','Lie ','Jing ','Ju ','Ti ','Pi ','Gang ','Jiao ','Huai ','Bu ','Di ','Huan ',
        'Yao ','Li ','Mi ','Fu ','Saang ','Gaa ','Ren ','Wai ','','Piao ','Lu ','Ling ','Yi ','Cai ','Shan ','Fat ',
        'Shu ','Tuo ','Mo ','He ','Tie ','Bing ','Peng ','Hun ','Fu ','Guo ','Bu ','Li ','Chan ','Bai ','Cuo ','Meng ',
        'Suo ','Qiang ','Zhi ','Kuang ','Bi ','Ao ','Meng ','Xian ','Guk ','Tou ','Teon ','Wei ','Cim ','Tan ','Caau ','Lao ',
        'Chan ','Ni ','Ni ','Li ','Dong ','Ju ','Jian ','Fu ','Sha ','Zha ','Tao ','Jian ','Nong ','Ya ','Jing ','Gan ',
        'Di ','Jian ','Mei ','Da ','Jian ','She ','Xie ','Zai ','Mang ','Li ','Gun ','Yu ','Ta ','Zhe ','Yang ','Tuan ',
        'Soeng ','He ','Diao ','Wei ','Yun ','Zha ','Qu ','Waa ','Caau ','Zi ','Ting ','Gu ','Soeng ','Ca ','Fu ','Tie ',
        'Ta ','Ta ','Zhuo ','Han ','Ping ','He ','Ceoi ','Zhou ','Bo ','Liu ','Nu ','Kaap ','Pao ','Di ','Sha ','Ti ',
        'Kuai ','Ti ','Qi ','Ji ','Chi ','Pa ','Jin ','Ke ','Li ','Ju ','Qu ','La ','Gu ','Qia ','Qi ','Xian ',
        'Jian ','Shi ','Xian ','Ai ','Hua ','Ju ','Ze ','Yao ','Tam ','Ji ','Cha ','Kan ','Gin ','','Yan ','Gwaai ',
        'Ziu ','Tong ','Nan ','Yue ','Ceoi ','Chi ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x4e':[
        'Ichi ','Tei ','Kou ','Shichi ','Shou ','Ka ','','Man ','Jou ','San ','Jou ','Ka ','Ki ','Fu ','Yo ','Ben ',
        'Kai ','Chuu ','Chuu ','Sen ','Sha ','Hi ','Se ','Sei ','Kyuu ','Hei ','Ye ','Cong ','Dong ','Si ','Shou ','Chuu ',
        'Kyuu ','Ryou ','Chuu ','Yuu ','Ryou ','Yan ','Hei ','Sang ','Kon ','Kyuu ','Ka ','A ','Qiang ','Chuu ','Keki ','Kai ',
        'Hou ','Kan ','Sen ','San ','Lin ','Saku ','Chu ','Ha ','Gan ','Tan ','Wei ','Shu ','Sei ','Rei ','Kyo ','Hetsu ',
        'Futsu ','I ','Gai ','Dai ','Shime ','Kyuu ','Kyuu ','Taku ','Eu ','Yi ','','Shi ','Wu ','Saku ','Ko ','Bou ',
        'Le ','Gin ','Hei ','Hau ','Qiao ','Ko ','Kai ','Jou ','Jou ','Otsu ','In ','','Ba ','Kyuu ','Kotsu ','Ya ',
        'Xi ','Xiang ','Gai ','Kyuu ','Hal ','','Shu ','Twul ','Shi ','Kei ','Dou ','Jia ','Kel ','Shi ','','Ol ',
        'Mai ','Ran ','Cal ','Nyuu ','Setsu ','En ','Fu ','Sha ','Na ','Kan ','Sol ','El ','Cwul ','','Kan ','Chi ',
        'Ki ','Ken ','Ran ','Rin ','I ','Ketsu ','Ryou ','Ma ','Yo ','Sou ','Ji ','Ji ','Ni ','Choku ','U ','U ',
        'Yu ','Un ','Go ','Ki ','Go ','Sei ','Shi ','Sai ','Sen ','Kou ','Ya ','Sa ','A ','Sei ','A ','Kyoku ',
        'Tou ','Bou ','Kou ','Ta ','Kou ','Gai ','Eki ','Chan ','Kyou ','Mu ','','Kyou ','Kyou ','Tei ','Ryou ','Kyou ',
        'Kei ','Ya ','Qin ','Haku ','You ','Xie ','Tan ','Ren ','Ta ','Bi ','Jin ','Ren ','Shuu ','La ','Bou ','Yi ',
        'Shuu ','Jin ','Roku ','Tei ','Soku ','Hu ','Fu ','Kyuu ','Hatsu ','Shou ','Kon ','Kai ','Bing ','Jou ','Juu ','Butsu ',
        'San ','Lun ','Sya ','Cang ','Shi ','Shi ','Ta ','Jou ','Fu ','Sen ','Ken ','Ta ','Kou ','Dou ','Jin ','Sen ',
        'Kan ','Kitsu ','Haku ','Dai ','Rei ','I ','Chao ','Chang ','Sa ','','Yi ','Mu ','Men ','Jin ','Ka ','Sou ',
        'Gyou ','Ken ','Chuu ','Hi ','Gatsu ','Ko ','Ken ','Kai ','Yao ','Feng ','Cang ','Nin ','Kyou ','Hin ','Tei ','Hou ',
        ],
    'x4f':[
        'Shou ','Ki ','Hai ','Yo ','Chou ','Ton ','Wen ','Eki ','Shin ','Kou ','I ','Kyuu ','Ai ','Go ','Ki ','Fuku ',
        'Batsu ','Kyuu ','Kin ','Hai ','Shin ','Hu ','Do ','Gin ','Yuu ','Ka ','Kai ','Yu ','Sai ','Den ','San ','Wei ',
        'Chuan ','Kuruma ','Ya ','Ken ','Shang ','Chang ','Lun ','Cang ','Xun ','Shin ','Wei ','Zhu ','','Ken ','Do ','Haku ',
        'Ko ','Ji ','Ji ','Setsu ','Han ','Kyoku ','Rei ','Chuu ','Shin ','Sho ','Shi ','Hou ','Ji ','Kya ','Hi ','I ',
        'Shi ','Ai ','Yai ','Ten ','Han ','Mai ','Tan ','Cho ','Ho ','Kyo ','Bi ','Shou ','Shi ','I ','Tei ','Juu ',
        'Sa ','Yuu ','Au ','Tei ','Chin ','Ka ','Hitsu ','Ta ','Sha ','Yo ','Itsu ','Butsu ','Saku ','Kou ','Nei ','Tou ',
        'Ji ','Ken ','Kyo ','You ','Wa ','Qian ','','Ka ','','Hai ','Kuwai ','Kaku ','Ryou ','Xiang ','Kou ','You ',
        'Haku ','Hou ','Ming ','Ka ','Ji ','Hei ','Kitsu ','Kou ','Katsu ','Ki ','Sen ','Chou ','Kou ','Shi ','Itsu ','Shi ',
        'Kei ','Shin ','Taku ','Kan ','Shitsu ','Kai ','Rai ','I ','Shi ','Ka ','Kou ','Rei ','In ','Ji ','Bi ','Shu ',
        'Kyoku ','Yuu ','An ','Rotsu ','Bou ','Ji ','Ron ','Tou ','Ta ','Choku ','Shun ','Kyou ','Chuu ','I ','Jo ','Sen ',
        'Kyou ','Ka ','Bu ','Ryo ','Ko ','Jiao ','Zhen ','Ce ','Qiao ','Kuai ','Chai ','Nei ','Nong ','Jin ','Bu ','Kou ',
        'Jiong ','Cheng ','Shin ','Sa ','Chuu ','Shin ','Ryo ','Kyoku ','Shu ','Tei ','Shin ','Tatsu ','Hotsu ','Dan ','Kou ','Ben ',
        'Tai ','Gu ','Kei ','Soku ','Ga ','Kyuu ','Sho ','Kyau ','Koku ','Go ','Shun ','Chuu ','Fu ','Ryou ','Sho ','Seu ',
        'Ri ','You ','Kon ','Gau ','Ken ','San ','Hai ','Zoku ','Fu ','Ki ','Ri ','Ben ','Hei ','Ho ','Yu ','Shi ',
        'Kyou ','Shin ','Shuu ','Mata ','Omokage ','Kuruma ','Chou ','','Yan ','Lia ','Li ','Rai ','Si ','Jian ','Shuu ','Fu ',
        'Ka ','Ku ','Kou ','Hai ','Sen ','Hyou ','Shuku ','Hi ','Hou ','Ya ','En ','Bi ','Iku ','Kin ','Hi ','Chi ',
        ],
    'x50':[
        'Chou ','Chi ','Hei ','Kyuu ','Kou ','Sai ','Ryou ','En ','Rai ','Sou ','Sou ','Ko ','Kuwan ','Bai ','Ten ','Shuku ',
        'Shuku ','Mon ','Tou ','Tan ','Kutsu ','Sui ','Kou ','Hou ','Shou ','Kou ','I ','Ki ','Teki ','Kan ','Kei ','Shaku ',
        'Ki ','Shou ','Shou ','Hou ','Chi ','Kou ','Ken ','Sou ','Kyo ','Sen ','Gei ','Rin ','Taku ','I ','Ra ','Shou ',
        'Ryou ','Kon ','Tou ','Shi ','Hon ','Bu ','Ku ','Dai ','Cai ','Ken ','Zhai ','Ya ','Chi ','Sha ','Qing ','',
        'Ei ','Shou ','Sen ','En ','Dan ','Shou ','Shun ','Ka ','Ketsu ','I ','U ','Hei ','Ja ','Tei ','Wai ','Hen ',
        'Gan ','Huu ','Tou ','Aku ','E ','Kai ','Sha ','Sei ','Kan ','Tei ','Saku ','Sou ','Tei ','Hai ','You ','Kuwau ',
        'Eu ','Tan ','Seu ','En ','Yu ','Ken ','Sho ','Ta ','Shi ','Huu ','Hiyoku ','Chi ','Sou ','Ben ','Shuu ','I ',
        'Setsu ','Shun ','Shi ','Tan ','Soku ','Tei ','Guu ','Chuu ','Chuu ','Bi ','San ','Rou ','Jie ','Gi ','Fen ','Chang ',
        'Kai ','Sou ','Chi ','So ','Katsu ','Fu ','Gen ','Jou ','Ritsu ','Ru ','In ','Kau ','Ba ','Bou ','Ten ','Tou ',
        'Kou ','Ketsu ','Kei ','Sen ','Ken ','Kaku ','Sau ','Chu ','San ','Bi ','Kou ','You ','Eu ','Tan ','Sa ','Au ',
        'Hatsu ','Hei ','Ka ','Dai ','Sai ','Tang ','Cot ','Bin ','Chu ','Nuo ','San ','Lei ','Sai ','You ','Sou ','Sou ',
        'Hou ','Shou ','Gou ','Den ','U ','Sai ','Soku ','Shou ','Sau ','Kyou ','Tei ','Sa ','Han ','Shou ','Kei ','En ',
        'Tei ','Setsu ','Rou ','Bi ','Heu ','Kin ','Ren ','Riku ','Ban ','Sen ','Sen ','Tan ','You ','Dou ','Sen ','Zou ',
        'Sen ','Kyou ','Jiong ','Tai ','Son ','Boku ','Ki ','Rau ','Shou ','Kou ','Ryou ','Ki ','Tou ','San ','Gi ','Ki ',
        'Fan ','Hui ','Sen ','Sen ','Tan ','Kyou ','Shyuu ','Sou ','Hun ','Kan ','Kitsu ','E ','Seu ','Sen ','Dou ','Rin ',
        'Hoku ','Ko ','','Su ','Xian ','Kyou ','Bin ','Ye ','Kin ','Ka ','Shou ','Heki ','Hou ','Shuu ','Ai ','Shi ',
        ],
    'x51':[
        'Gi ','Shun ','Dou ','Sen ','Oku ','Tou ','Kei ','Ken ','Kai ','Ken ','Sho ','Tan ','Keu ','Sa ','Sai ','',
        'Hin ','Gan ','Ju ','Tai ','Chuu ','Sei ','Ran ','Gi ','Jin ','Ken ','Bou ','Bu ','Dau ','Kei ','Ji ','Shou ',
        'Ryou ','Rai ','Ryo ','Kou ','Hou ','Iku ','Hyou ','San ','Shitsu ','Shi ','Yuu ','Hao ','Shin ','Shin ','Reki ','Tou ',
        'I ','Rou ','Cho ','San ','Shou ','Shuu ','Hui ','Rei ','Ra ','San ','Da ','Tou ','Gen ','Rai ','Nang ','Jin ',
        'Kotsu ','In ','Shin ','Gen ','Kei ','Juu ','Chou ','Kyou ','Sen ','Kou ','Tai ','Koku ','Da ','Men ','To ','Chou ',
        'Ji ','Da ','Ji ','Shin ','To ','Shi ','Yan ','En ','Shi ','Sip ','Tou ','Qian ','Tou ','Fen ','Mao ','Shin ',
        'Dou ','Payk ','Kyou ','Li ','Kou ','Nyuu ','Bou ','Dai ','Zen ','Ryou ','Yu ','Hachi ','Kou ','Roku ','Kei ','',
        'Lan ','Kyou ','Tian ','Guan ','Xing ','Hei ','Ki ','Gu ','Ten ','Ji ','Ppwun ','Yang ','Ken ','Shou ','Ki ','Yi ',
        'Ki ','Chan ','Kei ','Bou ','Zen ','Dai ','En ','Mao ','Gang ','Nen ','Satsu ','Kei ','Satsu ','Sai ','Ka ','Kei ',
        'Bou ','Chuu ','Bou ','Kou ','Ku ','Ben ','Beki ','Jou ','In ','Sha ','Kan ','Jun ','Nong ','Gi ','Bi ','Shi ',
        'Kan ','Bou ','Chou ','Shu ','En ','Mei ','Kou ','Lam ','Fu ','Sha ','Beki ','Hyou ','Tou ','Tai ','Gang ','Feng ',
        'Hyou ','Go ','Chuu ','Ketsu ','Go ','Kyou ','Ya ','Rei ','Han ','Hutsu ','Bin ','Dong ','Shou ','Retsu ','Kyou ','Sen ',
        'Jing ','Shu ','Bai ','Tu ','Sei ','Ko ','Jun ','Shou ','Sou ','Ryou ','Sei ','Chou ','Ryou ','Tou ','Gan ','Gen ',
        'In ','Sou ','Gi ','Ritsu ','Sau ','Bei ','Jun ','Sai ','Shi ','Taku ','Jin ','Rin ','Rin ','Gyou ','Ki ','Du ',
        'Ki ','Bon ','Bon ','Han ','Hou ','Kyo ','Sho ','Tako ','Fuu ','Kogarashi ','Nagu ','Fu ','Feng ','Hyou ','Fuu ','Kai ',
        'Kou ','Gai ','Kan ','Tou ','Hyou ','Kan ','Kyou ','Kai ','Totsu ','Ou ','Shutsu ','Ji ','Dang ','Kan ','Kan ','Zao ',
        ],
    'x52':[
        'Tou ','Teu ','Tau ','Jin ','Jin ','Sou ','Bun ','Setsu ','Gai ','Ki ','Kan ','Sen ','Son ','Chu ','Fun ','Ki ',
        'Tan ','Kei ','Ka ','Gun ','Ketsu ','Ri ','Getsu ','Retsu ','Ryuu ','Ze ','Gang ','Chuang ','Hutsu ','Sho ','Sho ','Chou ',
        'San ','Bin ','Rei ','Zhong ','Han ','Betsu ','Kyou ','Gou ','Hou ','Ri ','San ','Betsu ','San ','Jing ','Katsu ','Gen ',
        'Tou ','Sou ','Kei ','Ko ','Ta ','Ji ','Sei ','Satsu ','Ken ','Satsu ','Shi ','Koku ','Kyou ','Gui ','Ci ','Gui ',
        'Kai ','Ta ','Ji ','Tei ','Kei ','Rou ','Ra ','Soku ','Yuan ','Sa ','Saku ','Koku ','Ratsu ','Zen ','Satsu ','Sou ',
        'Gua ','Jian ','Saku ','Li ','Teki ','Hi ','Bou ','San ','Ki ','Sou ','Shi ','Gou ','Wan ','Haku ','Ki ','Tetsu ',
        'Kei ','En ','Toku ','Ken ','Zai ','Haku ','En ','Ju ','Kaku ','Jou ','Sen ','Taku ','Tan ','Oku ','Ka ','Fuku ',
        'Jou ','Ken ','Katsu ','Tou ','Gai ','Sou ','Juan ','San ','Tan ','Riku ','Ri ','Huu ','San ','Hyou ','Kou ','Shou ',
        'Katsu ','Syou ','Ketsu ','Kaku ','Satsu ','Taku ','Ren ','Geki ','Heki ','Ru ','Kai ','Syou ','Kei ','Ken ','Ken ','Tang ',
        'Kaku ','Zai ','Ken ','Gi ','Ken ','Shitsu ','San ','San ','Ba ','Ri ','Chaku ','Ryoku ','Atsu ','Kan ','Hen ','Kou ',
        'Ka ','Wu ','Mai ','Retsu ','Kin ','Kou ','Kyou ','Shi ','Dong ','Jo ','Do ','Gou ','Ku ','Shou ','Itsu ','Sho ',
        'Baku ','Rei ','Kei ','Rou ','Rou ','Ken ','Kou ','You ','Ai ','Kou ','Bou ','Kyou ','Katsu ','Retsu ','Gai ','Sei ',
        'Koku ','Kei ','Kou ','Botsu ','Bin ','Choku ','Rou ','Yuu ','You ','Ben ','Ke ','Xun ','Ken ','Kei ','Lu ','Hou ',
        'Bau ','Rai ','Roku ','Kai ','Ben ','Dou ','Kyaku ','Bou ','Kan ','Mu ','Ei ','Kun ','Ou ','Shou ','Rou ','Bo ',
        'Riku ','Heu ','Sei ','Seki ','Kin ','Kyou ','Sou ','Kan ','You ','Ei ','Kyaku ','Han ','Ken ','Tong ','Ju ','Tan ',
        'Kyou ','Bai ','Kun ','Kun ','Ryo ','Rei ','Ketsu ','Jou ','Kan ','Hou ','Shaku ','In ','Kyuu ','Bun ','Kou ','Butsu ',
        ],
    'x53':[
        'In ','Monme ','Niou ','Katsu ','Kai ','Hou ','Sou ','','Kyou ','Hyou ','Kiku ','Tou ','Kou ','Ho ','Ou ','Hou ',
        'Hoku ','Kyuu ','Tou ','Kyou ','Qiong ','Hi ','Ka ','Hoku ','Dou ','Shi ','Hou ','Kyuu ','I ','Sou ','Shou ','Kou ',
        'Shou ','Kyou ','Kotsu ','Kou ','Kyaku ','Hen ','Gui ','Kyou ','Zou ','Kyou ','Hi ','Kotsu ','Yu ','Ki ','Gui ','Wai ',
        'Tan ','Ki ','Ren ','Ren ','San ','Toku ','Jiu ','Kyo ','Kei ','Hitsu ','Ku ','I ','An ','En ','Hen ','Toku ',
        'Ku ','Juu ','Shin ','Sen ','Juu ','Sou ','Sotsu ','Shou ','Go ','Ki ','Han ','Sei ','Shuu ','Ban ','Hua ','Xie ',
        'Ban ','Hi ','Sotsu ','Taku ','Kyou ','Tan ','Mai ','Nan ','Tan ','Shou ','Haku ','Shutsu ','Boku ','Kan ','Hen ','Bu ',
        'Sen ','Sahu ','Lu ','Yuu ','Sei ','Sei ','Ka ','Wo ','Setsu ','Setsu ','Jie ','Wei ','Gau ','Kyou ','Shi ','Bou ',
        'In ','Ki ','Shou ','Soku ','Kyaku ','Ran ','Shi ','Kan ','Sha ','Jutsu ','Kin ','Kyaku ','Gotsu ','Soku ','Gaku ','Kyou ',
        'Shitsu ','','Kan ','Sen ','Yaku ','Ting ','Li ','Taku ','Kan ','Rei ','Ka ','Atsu ','Yan ','She ','Shi ','Sa ',
        'Pang ','','Kahu ','Gai ','Shitsu ','Ce ','Bou ','Tei ','Rin ','Sha ','Kou ','Ting ','Shi ','Saku ','Hi ','Gen ',
        'Shi ','Gen ','Xiang ','Yan ','Reki ','Ketsu ','Ka ','Ten ','Zu ','Kyuu ','Kin ','Gou ','Ki ','En ','Shi ','Reki ',
        'Shou ','Lan ','Rei ','Gen ','En ','Gen ','Shi ','Kou ','Rin ','Jiu ','Kyo ','Kyo ','Uk ','Rui ','Du ','Xian ',
        'Sen ','San ','San ','San ','San ','San ','Ai ','Tai ','Yuu ','Sha ','Kyuu ','Yuu ','Sou ','Han ','Shuu ','Kai ',
        'Hatsu ','Fa ','Jaku ','Shi ','Shuku ','Tetsu ','Shu ','Ju ','Hen ','Jo ','Ka ','Han ','Sou ','Kou ','I ','Sou ',
        'Chou ','Ei ','Sou ','Kou ','Ko ','Ku ','Rei ','Ka ','Tou ','Kou ','Shi ','Kyou ','Shou ','Hatsu ','Tei ','Ka ',
        'Dai ','Shitsu ','Shi ','U ','Qiu ','Ha ','Kyou ','Gou ','Shi ','Iu ','Kamasu ','Roku ','Chou ','Ji ','Duk ','Hong ',
        ],
    'x54':[
        'Mie ','Ku ','Bou ','Kitsu ','Kaku ','Ten ','You ','Zi ','Gou ','Kichi ','Chou ','Sun ','Dou ','Mei ','Kou ','Ri ',
        'To ','Kou ','Ta ','Ka ','Se ','Ryo ','A ','Ma ','Gou ','Kuu ','I ','Kun ','Chuu ','Rin ','Don ','Gin ',
        'Hai ','Hitsu ','Shin ','Shin ','Kai ','Hou ','Hi ','Ha ','Ton ','Fun ','Guu ','Gan ','Kin ','Kou ','Sen ','Kei ',
        'Kou ','Shi ','Shin ','Go ','Go ','Byou ','Totsu ','Ketsu ','Kyuu ','Sui ','Tou ','Fun ','Kou ','In ','Go ','Koku ',
        'Ga ','Kin ','Ryo ','Aku ','Koku ','Bai ','Bou ','Kei ','Tei ','Go ','Koku ','Hu ','Kyou ','Un ','Seki ','Shou ',
        'Totsu ','Don ','Fu ','Yi ','Dai ','Ou ','Li ','Bai ','Yuan ','Kuai ','','Qiang ','Wu ','E ','Shi ','Gen ',
        'Hon ','Bun ','Ji ','Bou ','Rei ','Zen ','Iu ','Tei ','Shuu ','Shi ','Ju ','Tehu ','Ki ','Ei ','Ki ','Hei ',
        'Shi ','Ko ','Shi ','Mi ','Ku ','Ka ','Do ','Kou ','Hi ','Itsu ','Kyou ','Shin ','Ko ','Mei ','Tatsu ','Ka ',
        'So ','Kan ','Sou ','Ta ','Totsu ','Tou ','Hou ','Hetsu ','Hutsu ','Au ','Wa ','Saku ','Wa ','Kai ','Kyuu ','Ei ',
        'Ho ','Da ','Shu ','Wa ','Rou ','Ko ','Ka ','Zuo ','Bu ','Long ','Dong ','Ning ','Ta ','Si ','Xian ','Kaku ',
        'Shuu ','Ji ','Gaku ','Kou ','Ta ','Ki ','I ','Retsu ','Shi ','Bi ','Bi ','Shi ','Kou ','Kitsu ','Tou ','Kaku ',
        'Shutsu ','Satsu ','Shou ','Gai ','Kai ','Kuu ','Kuui ','Tau ','Kan ','Atsu ','Ken ','Ku ','Ka ','In ','Rou ','I ',
        'Ai ','Hin ','Shin ','Tou ','Kou ','Kou ','Shi ','Ai ','Gou ','Sai ','Iku ','Tetsu ','Pai ','Kyou ','Gai ','Kon ',
        'Kuang ','Ya ','Da ','Xiao ','Bi ','Yue ','','Hua ','Sasou ','Kuai ','Duo ','','Ji ','Nong ','Mou ','Yo ',
        'Kou ','In ','Rou ','Pou ','Bou ','Ka ','Ga ','Ka ','Shou ','Ri ','Da ','Shoku ','Ka ','Koku ','Kou ','Ken ',
        'Rou ','Hotsu ','Tetsu ','Tatsu ','Liang ','Ba ','Ba ','Retsu ','Sai ','Fou ','Ho ','Kan ','Kou ','Kou ','Yatsu ','Ka ',
        ],
    'x55':[
        'Iu ','Gen ','Gu ','Koku ','Bai ','Kan ','Sa ','Shin ','Ou ','Kai ','Kyou ','To ','Sen ','Kan ','Ri ','Ki ',
        'Tou ','Zei ','Shuu ','Che ','Go ','Sou ','A ','Tou ','Kei ','Teki ','Shin ','Ma ','Mal ','Kou ','Dou ','Kes ',
        'Lao ','Ryou ','Suo ','Zao ','Kan ','Laang ','Sha ','Soku ','Zuo ','Wo ','Hou ','Gin ','Ka ','Ki ','Shuu ','Yui ',
        'Setsu ','Shou ','Ji ','Rei ','Kyou ','An ','Sha ','Yo ','Ten ','Yo ','Tian ','Rai ','Sahu ','Seki ','Da ','Kotsu ',
        'Gai ','Tou ','Nou ','Shuu ','Taku ','Taku ','Shou ','Teki ','Kou ','Ran ','A ','Kyou ','Kou ','Ton ','Go ','Mon ',
        'Sai ','Sou ','Kotsu ','Kei ','Kei ','Tou ','Tan ','Tan ','En ','Shi ','Hi ','Sai ','Setsu ','Ka ','A ','Kei ',
        'Tetsu ','Hai ','Ryou ','Kan ','Hi ','Sha ','Rahu ','Ze ','Qing ','Gua ','Pa ','Zhe ','Se ','Zhuan ','Gou ','Kaku ',
        'Luo ','Yan ','Di ','Quan ','Tan ','Bo ','Ding ','Lang ','Xiao ','Geoi ','Tang ','Shi ','Tei ','Gan ','Shuu ','Tan ',
        'Kaku ','Gyou ','Ki ','Nan ','Zen ','Yu ','Tetsu ','Ratsu ','Kai ','Kou ','Kan ','Chou ','Shuku ','Sai ','Ka ','Sha ',
        'Yu ','In ','San ','Eu ','Aku ','Ben ','Hu ','Gin ','Zen ','Kai ','Kan ','Kan ','Ki ','Katsu ','Soku ','Ki ',
        'Zhong ','I ','Tehu ','Ku ','Kou ','To ','Jou ','Ken ','Ryou ','Yu ','Sou ','Kitsu ','Kyou ','Gen ','Tan ','Pen ',
        'Kuu ','Ri ','Yaku ','Sa ','I ','Miao ','Ei ','Pen ','Phos ','Kui ','Xi ','Yu ','Jie ','Lou ','Ku ','Sou ',
        'Kaku ','Tei ','Eu ','Kou ','Sa ','Kyuu ','Shou ','Shoku ','You ','So ','Kou ','Kyou ','Eki ','Saku ','Ba ','Sa ',
        'Katsu ','Kahu ','Tou ','Sou ','Shin ','Shoku ','Shuhu ','Atsu ','Kei ','Hou ','O ','Ken ','Shi ','Kaku ','Shi ','Sa ',
        'Luo ','Rou ','Ratsu ','Shi ','Shi ','Kou ','Sa ','Garon ','Kai ','Sa ','Qin ','Nie ','He ','Cis ','Sai ','Ng ',
        'Ge ','Na ','Dia ','Ai ','','Tong ','Hitsu ','Gou ','Gou ','Ren ','Sui ','Sha ','Baku ','Soku ','Sou ','Tan ',
        ],
    'x56':[
        'Saku ','Sahu ','Kyou ','Chong ','Keu ','Kai ','Tan ','San ','Sau ','Ka ','Gai ','Xiao ','Heu ','Rou ','Katsu ','Ka ',
        'Hau ','Ko ','Kei ','Kaku ','Ou ','Ken ','Saku ','Shou ','Kyo ','Ha ','Toku ','Ma ','Ba ','Hu ','Roku ','To ',
        'Katsu ','Tang ','Ye ','Beng ','Ying ','Saai ','Jiao ','Mi ','Shou ','Ka ','Bai ','Dam ','Sai ','Hou ','Tou ','Shou ',
        'Ki ','Shoku ','Tou ','Ki ','Shi ','Keu ','Sei ','Kou ','Bu ','Reu ','Kyou ','Ki ','Kyuu ','Tan ','Tan ','Boku ',
        'Son ','O ','Son ','Han ','Kitsu ','Ki ','Sou ','Tou ','Shuku ','Tan ','Itsu ','Ton ','Sou ','Seu ','Itsu ','Kyuu ',
        'Ki ','Hao ','Lian ','Kyo ','Tou ','Ki ','Yin ','Boku ','Ketsu ','Kin ','Eibiro ','Gou ','Lu ','Si ','Gen ','You ',
        'Tatsu ','Sen ','Iku ','Chu ','Kin ','Dou ','Etsu ','Hui ','Ki ','Kaku ','Sou ','I ','Zei ','Kyou ','En ','Ai ',
        'You ','Kyaku ','Kuwai ','Gu ','Fun ','Dou ','Katsu ','Kin ','Ton ','Tou ','Hanashi ','Sai ','Pi ','Pi ','In ','Sui ',
        'Dei ','Teki ','Ran ','Tou ','Kaku ','Ju ','Kou ','Kaku ','You ','Duo ','Hi ','Chuu ','Sei ','Shin ','Kau ','Tei ',
        'Shou ','','','Ca ','Tei ','Ro ','Hui ','Haku ','Iu ','Gou ','Gin ','Hu ','Bi ','Kaku ','Tetsu ','Ri ',
        'Ryuu ','Haai ','Nou ','Xiao ','Mo ','En ','Reki ','Ro ','Rou ','Haku ','Tan ','Shin ','Hin ','Hi ','Kou ','Huo ',
        'Mo ','Ki ','Ta ','Koku ','Gen ','San ','Ou ','Jau ','Dian ','La ','Ta ','Gou ','Shaku ','Setsu ','Kan ','Huo ',
        'Ten ','Shou ','Gou ','Sou ','Li ','Ten ','Tai ','Li ','Gei ','Ra ','Nou ','Satsu ','So ','Xi ','So ','Kan ',
        'Satsu ','Shoku ','Lan ','Ketsu ','Dou ','Trom ','Lo ','I ','Kai ','In ','Shuu ','Shi ','Jin ','Ken ','Kai ','Shin ',
        'In ','Juu ','Shuu ','Dan ','Ton ','Kou ','En ','Kei ','Hen ','Yun ','Sou ','Kotsu ','Kai ','Gan ','Ka ','Koku ',
        'Kon ','Sou ','I ','To ','Wei ','Lun ','Koku ','Kin ','Ri ','Rei ','Ko ','Koku ','Tai ','Koku ','Tu ','Yuu ',
        ],
    'x57':[
        'Koku ','Gin ','Kon ','Ho ','Gyo ','Kan ','Yuan ','Rin ','Ken ','Gyo ','Sei ','Koku ','Sen ','I ','En ','Ken ',
        'Ku ','Ho ','En ','En ','Ou ','Toshokan ','To ','To ','Dan ','Lue ','Kai ','Eki ','Kan ','Ran ','Ran ','Do ',
        'Atsu ','Tu ','Tei ','Kutsu ','Haku ','Roku ','Iri ','Atsu ','Zai ','U ','Gitsu ','Au ','O ','Kei ','Hi ','I ',
        'Chi ','Qian ','Qian ','Shiu ','Shaku ','Dang ','Qia ','Akutsu ','Yama ','Kuang ','Chang ','Ki ','Nie ','Botsu ','Gyuu ','Katsu ',
        'Shi ','Shi ','Han ','Xun ','Tou ','Kin ','Bai ','Kin ','Keng ','Ton ','Bou ','Hun ','Hon ','Tan ','Kan ','Hai ',
        'Za ','Kou ','Hi ','Xing ','Di ','Jing ','Ji ','Kai ','Di ','Kei ','Ken ','Tan ','Li ','Ba ','Wu ','Fen ',
        'Zhui ','Ha ','Han ','Tang ','Kon ','Sho ','Tan ','Seki ','I ','Kan ','Hei ','Ten ','Ka ','Dei ','Dai ','Hi ',
        'Kei ','Au ','Hutsu ','Au ','Riku ','Kyou ','Boku ','Ka ','Gou ','Ketsu ','Hatsu ','Chi ','Taku ','Rei ','Cho ','Fu ',
        'Ko ','Chi ','Sui ','Ratsu ','Long ','Long ','Lu ','Ao ','Tai ','Hou ','','Kei ','Tou ','Ji ','Ke ','Rotsu ',
        'Shi ','Chi ','Lei ','Gai ','Shyou ','Kou ','Dui ','Teu ','Huku ','Kuu ','Geu ','Da ','Da ','Ki ','Ta ','You ',
        'Gin ','Hatsu ','Kou ','En ','Tetsu ','Keu ','Ken ','Kei ','Shu ','Sei ','Ha ','Dian ','Kyou ','Wu ','Kua ','',
        'Tao ','Dang ','Kai ','Gake ','Nao ','An ','Sei ','Xian ','Kan ','Hou ','Hu ','Hai ','Eki ','Gin ','Kan ','Sho ',
        'Sui ','Shin ','Kau ','Ai ','Hou ','Fang ','Kaku ','You ','Shun ','Jia ','Di ','Mai ','Rou ','Xuan ','Jou ','Sen ',
        'Shin ','Zhe ','Rachi ','Rachi ','Ho ','Tei ','Gomi ','Bu ','Shi ','Xun ','Guo ','Jiong ','Sho ','Ten ','Tei ','Iki ',
        'Fu ','O ','Ken ','Sai ','Hi ','Sei ','Wan ','Ku ','Lun ','Sau ','Kong ','Shou ','Tou ','Tai ','Tan ','En ',
        'Sai ','Shyuu ','Hou ','Kan ','Shoku ','Ta ','Gei ','Shitsu ','Eki ','Bai ','Ki ','Shun ','Ki ','Sou ','Shu ','Dei ',
        ],
    'x58':[
        'Kutsu ','Ka ','Dou ','Kon ','Gen ','Ken ','Tai ','Kin ','Kou ','Iku ','A ','Hou ','Ko ','To ','Leng ','',
        'Ya ','Qian ','','An ','','Da ','Nao ','Tu ','Shou ','In ','Hun ','Hiyoku ','Ren ','Ka ','Teu ','Ten ',
        'Kou ','Hou ','Bao ','Gu ','Tei ','Bou ','Kai ','Zen ','Getsu ','Kou ','Kan ','Zong ','Yu ','Kau ','Gaku ','Gyou ',
        'En ','Hou ','Shitsu ','Bi ','Jou ','To ','Ku ','An ','Hu ','Shou ','Kai ','Shin ','Kou ','Kou ','Chuan ','Kan ',
        'Hei ','Rui ','Xiang ','Huang ','Leng ','Duan ','','Xuan ','Ki ','Seki ','Kai ','Ei ','Tou ','Shou ','You ','Kai ',
        'So ','So ','Shi ','Beki ','Tou ','Ou ','Shou ','To ','Tou ','Kaku ','Chou ','Ritsu ','Hou ','Hau ','Soku ','Sou ',
        'Dui ','Ten ','O ','Tei ','Ken ','Kaku ','Zhen ','Ai ','Kyou ','En ','Kan ','Ten ','Yuan ','Wen ','Xie ','Liu ',
        'Ama ','Lang ','Jou ','Peng ','Hou ','Jin ','Koku ','Lu ','Ou ','Zan ','Bai ','Baku ','Sen ','Sau ','Juku ','Rou ',
        'Chi ','Ban ','Hyou ','Kyou ','Soku ','Sho ','Tetsu ','Shou ','Kan ','You ','Ten ','Shin ','Shaku ','Ki ','Kuwaku ','Shou ',
        'Kin ','Teki ','Shou ','Bo ','Sai ','Yan ','Tou ','Zou ','Qi ','Qiang ','Liang ','','Tsui ','Kou ','Zou ','Kyo ',
        'Sen ','Sen ','Hatsu ','Haku ','Kuai ','Tou ','Han ','Que ','Boku ','Ton ','Dun ','Shun ','Chi ','Sei ','Da ','Da ',
        'Tan ','Tou ','Bo ','Fun ','Huang ','Tan ','Da ','Ye ','Sho ','Mama ','Ou ','Shou ','Keki ','Kau ','Kon ','Eki ',
        'Pi ','Heki ','Ten ','Jiang ','Ya ','You ','Kaku ','Dan ','On ','Kyo ','Kai ','Dang ','Jou ','Zan ','Ken ','Kan ',
        'Shi ','Gaku ','Ai ','Atsu ','Tau ','Gou ','Zen ','Mama ','Rui ','Kou ','Ro ','En ','Tan ','I ','Kai ','Ryou ',
        'Rou ','Ei ','Reki ','Rin ','Jou ','Ten ','Xun ','Gan ','Rai ','Ha ','','Shi ','Jin ','','Sou ','Sou ',
        'Sei ','Ichi ','Bai ','Kaku ','Shu ','Zhuang ','Hu ','Ko ','Kon ','Ichi ','Ko ','Sei ','Kon ','Ju ','Bou ','Shun ',
        ],
    'x59':[
        'Shou ','Yi ','Chi ','Ko ','Chu ','Kou ','Hou ','Bei ','Cay ','Hen ','Sui ','Shun ','Ryou ','Fu ','Sa ','Ka ',
        'Kei ','','Dou ','Ka ','Ki ','Seki ','Gai ','En ','Bou ','Shuku ','Ta ','Ta ','Ya ','Sei ','Uys ','Gou ',
        'Kou ','Ki ','Mu ','Bou ','In ','Ka ','Chen ','Tai ','Shoku ','Ten ','Ta ','Fu ','Ketsu ','You ','Ou ','Kou ',
        'Kou ','Shitsu ','Tou ','Tai ','Tou ','En ','Hi ','I ','Ko ','Jia ','Duo ','Kwu ','Kuang ','Yun ','Kou ','Ha ',
        'Bou ','Lian ','Huan ','Tei ','En ','Hou ','Ken ','Ki ','Na ','Hou ','Xie ','Fen ','Ten ','','Kei ','Sou ',
        'Kan ','Setsu ','Kai ','Ta ','Hon ','Eki ','Jiang ','Tou ','Jou ','Hon ','Kei ','Kou ','Hi ','Chou ','Shun ','Kou ',
        'Ten ','Gau ','Sha ','Wan ','Pan ','Ou ','Wu ','Ou ','Shou ','Ren ','Datsu ','In ','Shou ','Seki ','Fun ','Katsu ',
        'Hi ','Ren ','Sha ','Jo ','Do ','Tei ','Dai ','Sen ','Kan ','Chi ','Jiu ','Dan ','Ta ','Kou ','Sen ','Gan ',
        'Ji ','Shaku ','Jo ','Hi ','Bou ','Kou ','Zhuang ','Fu ','Ma ','Dan ','Nin ','Fu ','Sei ','Ken ','Kai ','Bun ',
        'Shou ','Pa ','To ','Ki ','Keng ','Chuu ','You ','Sen ','Un ','Myou ','Huu ','Shi ','Yue ','Sou ','Juu ','An ',
        'Dou ','Kin ','Hun ','Hi ','Yo ','Da ','Hou ','Gen ','Bou ','Wu ','Yu ','Gui ','To ','Hatsu ','Ji ','Chuu ',
        'Chaku ','Shou ','Datsu ','Dai ','En ','Tou ','Ken ','Chitsu ','A ','Mai ','Batsu ','Sai ','Hi ','Shin ','Shou ','E ',
        'Ka ','Ku ','Fa ','Sei ','Bin ','Han ','Bo ','Hu ','Rei ','Shi ','Shi ','Shi ','Zen ','San ','Au ','Ban ',
        'So ','Ko ','Shi ','Sei ','I ','Zi ','Kyo ','San ','Hin ','Nin ','You ','Tou ','Kyou ','Su ','Kitsu ','Kai ',
        'Shou ','Katsu ','Ken ','Kou ','Kou ','Bo ','Kan ','Kan ','I ','Den ','Tetsu ','Ki ','Ki ','Ken ','Kou ','Kou ',
        'Jun ','Ka ','An ','Bei ','Retsu ','Hai ','Ou ','Yuu ','Ken ','Ta ','Shin ','In ','Shi ','Ki ','Sen ','Shi ',
        ],
    'x5a':[
        'Shuu ','I ','Hong ','A ','Ru ','Ya ','Rao ','Jiao ','Luan ','Hei ','Ken ','Shao ','Ri ','Sei ','Ketsu ','Bou ',
        '','Sha ','Bo ','Bi ','Ke ','Saku ','Saku ','Tei ','Jou ','Gou ','Nan ','Go ','Da ','Pei ','Dai ','Ken ',
        'Shin ','Zhi ','Han ','Tei ','Sou ','Ga ','Pin ','Tai ','Ban ','Ben ','Go ','Yan ','Bu ','Ki ','Den ','Go ',
        'Ji ','Yu ','Wa ','','Xian ','Shu ','Shu ','Tsui ','Ki ','Ken ','Zhui ','Dong ','Shou ','Lu ','Gai ','A ',
        'A ','Rou ','Ben ','Sou ','Hou ','Kiku ','Ba ','Sai ','Ryou ','En ','Hyou ','Xiao ','Shuku ','Ki ','Hui ','Fu ',
        'Wa ','Zui ','Tan ','Hi ','','Shou ','Ten ','Gei ','Ken ','Jing ','Kon ','Kei ','Kan ','Ten ','Kei ','Ko ',
        'Wan ','Lai ','Hi ','In ','Shuu ','Dou ','Fu ','Sei ','Lun ','Gen ','Ran ','Kun ','In ','A ','','Li ',
        'Ten ','Xian ','Hwa ','Kaku ','Ying ','Chan ','Shen ','Tei ','Tou ','Yao ','Bu ','Dan ','Shaku ','Ka ','Tou ','Sei ',
        'Yu ','Wei ','Ti ','Juu ','Bi ','Dan ','Ruan ','Qin ','','Wu ','Sen ','Shun ','Bou ','Fu ','So ','Tan ',
        'Ki ','Zhong ','Bai ','Kou ','Ben ','En ','Ei ','Ken ','','I ','Bi ','En ','Tei ','Shuu ','Shi ','Setsu ',
        'Ta ','Lian ','Bou ','Ran ','Shi ','Hen ','I ','Kai ','Jiu ','Ko ','Ou ','','Ho ','Shu ','Tou ','Gui ',
        'Shiu ','Eu ','Hei ','Seki ','En ','You ','Jou ','Joku ','Shi ','Riu ','Bi ','Han ','Ou ','Bo ','Kou ','Ki ',
        'Shin ','Ka ','Sou ','Zhen ','Gen ','Cha ','You ','Bei ','Seu ','Shitsu ','So ','Jou ','Ken ','Tau ','Pang ','Rou ',
        'Jou ','Bao ','Ai ','Pi ','Pin ','Ei ','Hyou ','Ou ','Rui ','Seb ','Ban ','Ei ','Shau ','Kau ','Shou ','Jiyuku ',
        'Ri ','Chaku ','Ki ','En ','Jin ','Sen ','Kou ','Ce ','Kan ','Don ','Rau ','Bo ','Sha ','Ko ','Ko ','Ao ',
        'Nen ','Qiang ','Maa ','Hetsu ','Ko ','Bu ','Seu ','Ta ','Sen ','Bau ','Kan ','Kan ','Mo ','Reu ','Lian ','Kaku ',
        ],
    'x5b':[
        'Ki ','Tou ','Shoku ','Shu ','','Kuwa ','Xi ','Kuwai ','Deu ','Ki ','Yan ','Sen ','Kyou ','Bi ','Han ','Han ',
        'Sen ','Yi ','Wei ','Keu ','Hu ','Shi ','Hei ','Sen ','Sui ','Shou ','Ren ','Ken ','','Jou ','Tou ','Yi ',
        'San ','Ai ','Jou ','Tau ','Ba ','Chou ','Chiu ','Shin ','Shi ','Yu ','Hin ','','Shu ','Dai ','En ','Tai ',
        'Ei ','Can ','Jou ','','Ei ','Mian ','Kaka ','Ba ','Shin ','Xing ','Ni ','Du ','Riwa ','En ','Ran ','En ',
        'Sou ','Rei ','Jiao ','Jou ','Lan ','Sen ','Ying ','Sawa ','Sui ','Quan ','Mi ','Ri ','Ren ','Gen ','Shoku ','Lan ',
        'Shi ','Getsu ','Ketsu ','Jue ','Kou ','You ','Shi ','Ji ','Son ','Sun ','Fu ','Botsu ','Shi ','Kou ','Shin ','Mou ',
        'Si ','Tai ','Bao ','Ki ','Ko ','Do ','Gaku ','','Sen ','Kai ','Luan ','Son ','Huai ','Mie ','Sou ','Kan ',
        'Juku ','Sen ','A ','Shi ','Ni ','Fu ','Shi ','Ri ','Gaku ','Bo ','Ju ','Dai ','Getsu ','Getsu ','Ei ','San ',
        'Ben ','Cho ','Rong ','Ta ','Ki ','Taku ','Kyou ','U ','Shu ','An ','Totsu ','Sou ','Kan ','Niku ','Eu ','Kou ',
        'Gi ','Sei ','Chun ','Bitsu ','Shu ','Tou ','Kou ','Shuu ','Kan ','Chuu ','Tei ','En ','Gi ','Hou ','Shi ','Jitsu ',
        'Chong ','Shen ','Kyaku ','Sen ','Shitsu ','Yuu ','Kan ','Yi ','Tewa ','Shi ','Xian ','Kyuu ','Sei ','Kun ','Kyuu ','Kou ',
        'Sai ','Sa ','Hou ','Gai ','En ','Shou ','Ka ','Shin ','Shin ','You ','Kou ','Mitsu ','Kou ','Kuan ','Bin ','Shuku ',
        'Sai ','San ','Jaku ','En ','Ki ','In ','Mitsu ','Kou ','Qing ','Kaku ','Tei ','Ken ','Fu ','Nei ','Hei ','Kan ',
        'Bi ','Shin ','Kan ','Guu ','Shoku ','Nei ','Shin ','Nei ','Shi ','Yu ','Hou ','Kan ','Nei ','Shin ','Baku ','Satsu ',
        'Ku ','Ka ','Shin ','Kotsu ','Go ','Ryou ','Jitsu ','Nei ','Sai ','Shin ','I ','Sha ','Kan ','Hui ','Ryou ','Shun ',
        'Kan ','Gei ','Gi ','Hou ','Shin ','Chou ','Hou ','Feng ','Sun ','Tai ','Ji ','Xun ','Dao ','Rin ','Tai ','Ju ',
        ],
    'x5c':[
        'Ha ','Fuu ','Sen ','Hu ','Sha ','Koku ','Shou ','Shou ','Sen ','I ','Son ','Jin ','Shu ','Tai ','Dou ','Shou ',
        'Setsu ','Shou ','Ji ','Ji ','Ji ','Ga ','Sen ','Shuku ','Chen ','Shou ','Shou ','','Ga ','Chang ','Ryou ','Sen ',
        'Sen ','','Ou ','Ou ','Yuu ','Ryou ','Ryou ','Yao ','Bou ','Ou ','Ou ','Ou ','Kai ','Gyou ','Ta ','Ki ',
        'Shou ','Shuu ','Kan ','Kotsu ','Gan ','Tai ','Kan ','Kan ','Shi ','In ','Shaku ','Kou ','Ni ','Jin ','Bi ','Nyou ',
        'Kyoku ','Hi ','Ceng ','Ki ','Hi ','Kyo ','Kai ','Ten ','Kutsu ','Ti ','Kai ','Oku ','Chou ','Shi ','Shi ','Hei ',
        'Geki ','Setsu ','Chen ','Ki ','Dei ','Ten ','Sei ','','Man ','A ','Rou ','Hei ','Tei ','Fei ','Zoku ','Tei ',
        'To ','Ru ','Ru ','Shi ','Sou ','Ri ','Ju ','Tei ','Ku ','Kyaku ','Ryou ','Kyaku ','Zoku ','Ki ','Sa ','Ton ',
        'Geki ','San ','','Sen ','Ryoku ','Gatsu ','Nata ','','Long ','Kitsu ','Ki ','Jin ','Gotsu ','Kan ','Shin ','Yu ',
        'Shutsu ','Sui ','Qi ','','Yue ','Han ','Eu ','Gou ','Ka ','Butsu ','Setsu ','Gou ','Kyuu ','Qian ','Fen ','Guwan ',
        'Ki ','Shin ','Ken ','Ki ','Sa ','Kai ','Qu ','Gang ','Xian ','Ao ','Lan ','Dao ','Ba ','Saku ','Zuo ','You ',
        'Kyo ','Kou ','Ke ','Kou ','Ketsu ','Ha ','Ryuu ','Teu ','So ','Gan ','Hutsu ','Shuu ','Kou ','Rei ','Ta ','Hi ',
        'You ','Tai ','Kou ','Gaku ','Ku ','Ko ','Haku ','Bin ','Gan ','Tiao ','Rei ','Ji ','Yuri ','Dong ','Sen ','Kui ',
        'Shuu ','Mao ','Tong ','Xue ','Yi ','Kura ','Kahu ','Kou ','Raku ','Gaku ','Hu ','Shun ','Tetsu ','Lu ','Gon ','Ji ',
        'Kai ','Quan ','Tou ','Yi ','Bo ','Shi ','An ','Gi ','Kan ','Ji ','Bitsu ','Ri ','Kei ','Tou ','Ki ','You ',
        'Touge ','Kyou ','Li ','Gyou ','Jiao ','Zheng ','Luan ','Jiao ','Ga ','Ga ','Yoku ','Ya ','Ho ','Shou ','Kin ','Hou ',
        'Hou ','Dou ','Ri ','You ','Ken ','Kou ','Tou ','Shin ','Sei ','To ','Kou ','Shun ','Hao ','Kyou ','Yin ','Yu ',
        ],
    'x5d':[
        'Lang ','Kan ','Lao ','Lai ','Ken ','Que ','Kou ','Suu ','Shuu ','Ta ','','Ka ','Ju ','Rai ','Ki ','Bin ',
        'Kon ','Kon ','Shutsu ','Gu ','Sai ','Gai ','Gai ','Kou ','Ron ','Ron ','Ryou ','Kutsu ','Duo ','Sau ','Guo ','Gin ',
        'Tou ','Kan ','Sou ','I ','Kou ','Hei ','En ','Shuu ','Sehu ','Hou ','Zu ','Kutsu ','Dong ','Zhan ','Gu ','Yin ',
        '','Shoku ','Kou ','Yu ','Wai ','Seu ','Hou ','Shiu ','Ton ','Tei ','I ','Zhi ','Shi ','Sai ','Yao ','Gaku ',
        'Chiu ','Kan ','Ritsu ','Gen ','Mei ','Kan ','Kei ','Kei ','Kan ','Tei ','Shou ','Bi ','Kan ','Wu ','Guu ','Zong ',
        'Ran ','Ketsu ','Gan ','Gan ','Wei ','Sou ','Sa ','Sei ','Rong ','Yamashina ','Qin ','Yu ','Ki ','Lou ','To ','Ki ',
        'Gei ','Ou ','Sou ','Tau ','Kei ','Ketsu ','Ai ','Riu ','O ','Suu ','Kou ','Zi ','Kai ','Hou ','Dian ','Sa ',
        'Ken ','You ','Getsu ','Sa ','Ji ','','Tao ','Shou ','Zong ','Kyou ','Reu ','','San ','Tetsu ','Shin ','Tei ',
        'To ','Ru ','Shou ','San ','San ','Ao ','Sau ','Ku ','Shau ','Sui ','Sui ','Tou ','Tou ','Shihu ','Yu ','Bo ',
        'Ryuu ','Xiang ','Shou ','Ha ','Kin ','Seu ','Yan ','Lao ','Zhan ','Rin ','Ryou ','Ryou ','Shin ','Tou ','Ta ','Son ',
        'Kyou ','Kei ','Gyou ','Qiao ','Yao ','Jue ','Zhan ','Eki ','Kaku ','Dau ','Gyou ','Gyou ','Gi ','Gatsu ','Ken ','Shiu ',
        'Kai ','Katsu ','Kei ','Di ','Au ','Sai ','','Gi ','Kou ','Tou ','Rei ','Za ','Sho ','Gaku ','Yin ','',
        'Satsu ','Li ','Sui ','Rou ','Long ','Dian ','Kou ','Ki ','Ju ','San ','Ying ','Ki ','Gan ','Gi ','Dou ','Ken ',
        'Chou ','San ','Ran ','Ten ','Ten ','','Gan ','Yan ','Gen ','Ki ','Yan ','Sen ','Kai ','Sen ','Shuu ','Kou ',
        'Kei ','Jun ','Chao ','Sou ','Rehu ','Kou ','Sa ','Kou ','Kyo ','Kyou ','Kek ','Fu ','Pwu ','Pwu ','Shi ','Qiu ',
        'Qiu ','Ki ','I ','Shi ','Ha ','Shi ','Zhao ','Kou ','I ','Kin ','Son ','Kan ','Phas ','Son ','Kin ','Hutsu ',
        ],
    'x5e':[
        'Sou ','Bi ','Shi ','Fu ','Tei ','Shuai ','Han ','Den ','Shi ','Fen ','Ha ','Shi ','Ki ','Ko ','Tan ','Wei ',
        'Zhang ','Do ','Tai ','Ma ','Hi ','Batsu ','Jou ','Fu ','Ren ','Chitsu ','Sou ','Haku ','Zhi ','Tei ','Mo ','Eki ',
        'Gei ','Hei ','Kahu ','Ken ','Geyo ','Sotsu ','Tai ','Zheng ','Sei ','Seu ','Zhen ','Shi ','Kun ','Seki ','Hou ','Tai ',
        'Ki ','Chou ','Hei ','Chou ','Satsu ','Wan ','Tai ','I ','Jou ','Sha ','Qi ','Ze ','Guo ','Bou ','To ','Hou ',
        'Tei ','Su ','Beki ','I ','Aku ','Fuku ','Yi ','Hou ','Hei ','Tazuna ','Kou ','Han ','Kou ','Tou ','Beki ','Ka ',
        'Tou ','Ki ','Zhong ','Shin ','Ban ','Maku ','Hyou ','Kaku ','Saku ','Baku ','Hou ','Shou ','Kei ','Sen ','Hoku ','Shi ',
        'Ko ','Han ','Tou ','Hei ','Hei ','','Beki ','Seu ','Sen ','Hun ','Bou ','Hou ','Chuu ','Betsu ','Chu ','Setsu ',
        'Ken ','Ran ','Kan ','Hei ','Nen ','Ken ','Hei ','Hei ','Kou ','Kan ','You ','Gen ','You ','Yuu ','Ki ','Gen ',
        'Hi ','Chou ','Shoku ','Kou ','Sou ','Mo ','Qing ','Hi ','Kin ','Ton ','Shou ','Ki ','Ga ','Hai ','Kai ','Jo ',
        'Lu ','Wu ','','Ku ','Ying ','Tei ','Hou ','Ten ','Ya ','Miao ','Kou ','Shi ','Fu ','Tong ','Pang ','Fei ',
        'Shou ','Yi ','Chitsu ','Teu ','Chi ','Kyuu ','Taku ','Za ','Kou ','Tu ','Ki ','Ko ','Bou ','Tei ','Iu ','Ho ',
        'Hei ','Chou ','Rai ','Hi ','Seki ','An ','Sho ','Kou ','You ','Tuo ','Song ','Sho ','Qing ','Dou ','Yu ','Byou ',
        'Sou ','Shi ','Shou ','Hai ','Jiu ','Ahu ','Kai ','Riu ','Ka ','Ren ','Rou ','Shuu ','Chi ','Pou ','Kei ','Jiu ',
        'Kyuu ','Kin ','Gou ','Kaku ','Rou ','In ','Ryou ','Tai ','Roku ','Yoku ','Zu ','Ten ','To ','Shi ','Kin ','Byou ',
        'Shou ','Bu ','Hai ','Kou ','Koc ','Kai ','Heki ','Shau ','Kai ','Rin ','Rin ','Ryou ','Ryo ','','Ei ','Sen ',
        'Chou ','You ','Rei ','Chou ','In ','Jun ','En ','Tei ','Teki ','Po ','Ken ','Kai ','Dai ','Kai ','Kyou ','Juu ',
        ],
    'x5f':[
        'Kai ','Ben ','I ','Ki ','Rou ','Hun ','Kyo ','En ','Eki ','Jou ','Hei ','Yoku ','Itsu ','Ni ','San ','Shiki ',
        'Ni ','Shi ','Shi ','Kyuu ','Chou ','In ','Te ','Futsu ','Kou ','O ','Tai ','Shi ','Kyou ','Ha ','Shen ','Tei ',
        'Zhang ','Kutsu ','Tou ','Hu ','Tei ','Mi ','Gen ','Ko ','Seu ','Do ','Jing ','Shin ','I ','Bi ','Ken ','Wan ',
        'Sou ','Jaku ','Xuan ','Jing ','Ton ','Chou ','Gyau ','Kyou ','Hou ','Dan ','Kyou ','Hitsu ','Hitsu ','You ','Dan ','Ken ',
        'Kou ','Sei ','Hotsu ','Hitsu ','Kou ','Nagi ','Bie ','You ','Dan ','Kuwaku ','Kyou ','Kau ','Bi ','Kuwaku ','Wan ','Kuwaku ',
        'Kei ','Kei ','Gui ','Tou ','Roku ','Lu ','Tan ','Sui ','Tei ','I ','I ','I ','I ','I ','I ','Kaku ',
        'Kuwaku ','San ','Kei ','Bun ','Tou ','Gen ','Gen ','Iku ','Chi ','Sai ','Hyou ','Chou ','Hin ','Hou ','Yong ','Heu ',
        'Shou ','Ei ','Chi ','Teki ','Shaku ','Ta ','Kihu ','Hou ','Shou ','Yaku ','Ou ','Che ','Hi ','Chi ','Rei ','Futsu ',
        'Ou ','Sei ','So ','Ou ','Kei ','Tai ','Sei ','Shun ','Kon ','You ','Kai ','Ritsu ','Go ','Ai ','Cheng ','Choku ',
        'Jo ','Kei ','To ','Juu ','','Lai ','Sou ','Toku ','Hai ','Shi ','','Ki ','Shou ','Chi ','Juu ','Zhou ',
        'Rai ','Gyo ','Shou ','Jie ','Takeshi ','Chi ','Jia ','Hen ','Kou ','Fuku ','Jun ','I ','Hou ','You ','Bi ','Kei ',
        'Sei ','Hyou ','Chi ','Toku ','Chou ','Chou ','Bie ','Toku ','Shou ','Tetsu ','Jiao ','Wei ','Kyou ','Ki ','Mei ','Long ',
        'Xiang ','Bao ','Qu ','Shin ','Ritsushinben ','Hitsu ','Yi ','Roku ','Jin ','Tou ','Ding ','Kai ','Ki ','Nin ','Ren ','Chan ',
        'Kun ','Toku ','Toku ','Kan ','Kitsu ','Shi ','Son ','Shi ','Bou ','Bou ','Xi ','Fan ','Ou ','Ten ','Bin ','Min ',
        'Chuu ','Chuu ','Go ','Ji ','Go ','Xi ','Ye ','You ','Gan ','Sou ','Shou ','Kai ','Yo ','Hen ','Shi ','Ki ',
        'Sui ','Shin ','Tai ','Ton ','Qian ','Nen ','Kon ','Kyou ','Jiku ','Wang ','Ken ','Kin ','Kou ','Kotsu ','Kai ','Fun ',
        ],
    'x60':[
        'Huai ','Tai ','Song ','Wu ','Ou ','Chang ','Chuang ','Kyo ','Yi ','Bao ','Chou ','Min ','Pei ','Saku ','Shin ','You ',
        'Kou ','Ban ','Do ','Dou ','Sei ','Ha ','Fu ','Chou ','Ko ','Ko ','Sho ','Datsu ','Rei ','Shi ','Chou ','Tei ',
        'Tai ','I ','Tu ','You ','Hu ','Kyuu ','Hou ','Sei ','En ','Ji ','Kai ','Futsu ','Xi ','Hitsu ','You ','Kyou ',
        'Xuan ','Sou ','Bing ','Kyou ','Xu ','Jutsu ','Pi ','Xi ','Xi ','Tan ','Koraeru ','Zong ','Dui ','','Ki ','Yi ',
        'Shi ','In ','Jun ','Ji ','Xi ','Lao ','Kou ','Kyou ','Bou ','Shi ','Kyou ','Ren ','Chou ','Kou ','Die ','Hao ',
        'Kyou ','Ki ','Kou ','Xi ','Kyou ','Jo ','Shi ','Ko ','Qiu ','You ','I ','Hui ','Chi ','Kai ','Yi ','Kyou ',
        'Kai ','Rin ','Kai ','Shi ','Jutsu ','Chi ','Xiang ','Jiku ','Kon ','On ','Kaku ','Dou ','Ten ','Kyou ','Quan ','Soku ',
        'Kou ','Etsu ','Peng ','Ken ','De ','Kei ','E ','Kyuu ','Tong ','Yan ','Kai ','Ce ','Nao ','Yun ','Bou ','You ',
        'Yong ','En ','Hi ','Kon ','Shou ','Etsu ','Yo ','Yu ','Kai ','Shitsu ','Tetsu ','Rin ','Tei ','Kan ','Kou ','Qie ',
        'Ti ','Ho ','Yuu ','Ken ','Kai ','Ki ','Hai ','Ban ','I ','Heng ','Shou ','Sen ','Cheng ','Kai ','Go ','Go ',
        'Yuu ','Li ','Ryou ','Kan ','Sou ','Yoku ','Etsu ','Ri ','Ji ','Nou ','Aku ','Que ','Xuan ','Qian ','Wu ','Min ',
        'Sou ','Hi ','Hi ','Toku ','Sui ','Chou ','Mon ','Rei ','Ki ','Guan ','Guan ','Kei ','Tou ','Sei ','Kou ','Tian ',
        'Lun ','Xi ','Kan ','Kun ','Deki ','Jou ','Chuu ','Ton ','Ka ','Sen ','Ryou ','Wan ','Yuan ','Jin ','Ki ','Ran ',
        'Yu ','Waku ','He ','Ken ','Tan ','Teki ','Teki ','Nie ','Bou ','Tetsu ','Kotsu ','Kon ','Seki ','Shou ','Kin ','I ',
        'Kei ','O ','Sa ','Sou ','Jian ','You ','Dian ','Ku ','San ','Cheng ','Toku ','Bei ','Qie ','Can ','Dan ','Guan ',
        'Da ','Nou ','Un ','Sou ','Zui ','Chou ','Kou ','Shun ','Kei ','Ja ','Sei ','Soku ','Hen ','Kon ','Zong ','Ti ',
        ],
    'x61':[
        'Shou ','Shuu ','Botsu ','Ken ','Wei ','Ge ','Ken ','I ','Yu ','Yu ','Hyoku ','Xuan ','Kan ','Bin ','Hyoku ','I ',
        'Ben ','You ','Kei ','Tou ','In ','Gaku ','Shin ','Bou ','Ke ','Kaku ','Gu ','Ai ','Kyou ','Yan ','Zen ','Kan ',
        'Un ','Sou ','Sai ','Leng ','Fen ','','Kui ','Ki ','Kaku ','Gong ','Un ','So ','So ','Qi ','Yao ','Song ',
        'Kau ','Shitsu ','Gu ','Ju ','Sou ','Deki ','Kyou ','Kai ','Zheng ','You ','Cao ','Sun ','Shin ','Haku ','Ki ','Gen ',
        'Xie ','Kon ','You ','Yang ','Ritsu ','Sou ','Tou ','In ','Ji ','Kin ','Ken ','Tai ','Kou ','Un ','Shin ','Ming ',
        '','She ','Cong ','Hyou ','Mo ','Bo ','Guo ','Chi ','San ','Zan ','Zan ','Cui ','Min ','Toku ','Shou ','Dou ',
        'Gou ','Shuang ','Man ','Kan ','Que ','Zou ','Jiu ','Kei ','Gai ','Lian ','Ou ','Shou ','Kin ','Gin ','Ryo ','Shou ',
        'I ','Tan ','Ban ','Kan ','Shou ','You ','Kei ','Kou ','Tei ','Zhi ','Lou ','Ken ','Seki ','Qi ','Yoku ','Hyou ',
        'Ryou ','Sou ','Yuu ','Tou ','Chi ','Tong ','Cheng ','Kei ','Qu ','Peng ','Hai ','Hetsu ','Chun ','Kyou ','Zou ','Chi ',
        'Ren ','Hyou ','Kai ','Kei ','Shou ','Cheng ','Gin ','Gin ','Ki ','Ki ','Tan ','Tan ','Ta ','Tai ','Dui ','Shoku ',
        'Ketsu ','Ce ','Xiao ','Fan ','Fun ','Rou ','Lao ','Dou ','Kan ','Kei ','Kan ','Bin ','Kei ','Ryou ','Bu ','Can ',
        'Jue ','Cu ','Ken ','Tan ','Sheng ','Pi ','Oku ','Chu ','Sen ','Dou ','Tan ','Tan ','Kei ','Song ','Kan ','Jiao ',
        'Wai ','Ken ','Tou ','Kin ','Qin ','Qu ','Sou ','Kon ','Kai ','You ','Ou ','Bou ','Eki ','Rin ','Shoku ','Shun ',
        'Kai ','Men ','Lan ','Ai ','Rin ','En ','Gua ','Xia ','Chi ','Yu ','Yin ','Dai ','Bou ','Gai ','Bou ','Tsui ',
        'Qi ','Ba ','Ran ','Mon ','Chyuu ','Zhi ','Da ','Da ','Yan ','You ','Bo ','Zhi ','Kou ','Kou ','You ','Fu ',
        'Liu ','Mie ','Chou ','','Zan ','Meng ','Ran ','Kai ','Ken ','Rang ','Zan ','Ji ','Ku ','Kan ','Shou ','I ',
        ],
    'x62':[
        'Ren ','Dan ','Mi ','Tou ','Kyaku ','Gang ','Gang ','Tou ','Ka ','Etsu ','Bo ','Jian ','Jutsu ','Ju ','Juu ','Xi ',
        'Sei ','Ga ','Kai ','Ka ','San ','Shou ','Waku ','Qiang ','Zhan ','Dong ','Seki ','Katsu ','Tetsu ','Zoku ','Katsu ','Geki ',
        'Shoku ','Kan ','Shuu ','Ki ','Gai ','Deng ','Sen ','Sou ','Ge ','Sen ','Setsu ','Yoku ','Jian ','Yan ','Riku ','Gi ',
        'Sen ','Gi ','Gi ','Taku ','Tai ','Gu ','Ko ','Ko ','Ko ','Aku ','Shi ','Rei ','Bou ','Ko ','Rei ','Bou ',
        'Sho ','Hen ','Ten ','Kei ','Shou ','I ','I ','Sen ','Ko ','Hi ','Yan ','Shu ','Shu ','Sai ','Satsu ','Qiu ',
        'Roku ','Hoku ','Hai ','Da ','Jou ','Futsu ','Hameru ','Zai ','Taku ','Zhang ','Chou ','Kou ','U ','Ku ','Kan ','Shen ',
        'Sa ','Yi ','Gu ','Kou ','Gotsu ','Tuo ','Qian ','Zhi ','Sate ','Kuo ','Men ','Sao ','Yang ','Juu ','Fun ','Ta ',
        'Rao ','Sou ','Qian ','Han ','Jia ','Yu ','Fu ','Ao ','Xi ','Hi ','Tei ','Zi ','Aku ','Ton ','Ka ','Shou ',
        'Gi ','Yan ','Kyou ','Ben ','Shou ','Ju ','Wen ','Hu ','Getsu ','Ketsu ','Ha ','Qin ','Zhen ','Shou ','Un ','Gan ',
        'Dotsu ','Yoku ','Jo ','Sou ','Hou ','Tou ','Tou ','Kou ','Setsu ','Pou ','Fu ','Hou ','Batsu ','Ao ','Taku ','Tuan ',
        'Kou ','Lun ','Qiang ','','Hu ','Bao ','Hei ','Zhi ','Hou ','Tan ','Pu ','Hi ','Tai ','Yao ','Zhen ','Zha ',
        'Yang ','Hou ','He ','Ji ','Yi ','Tei ','Chitsu ','Hi ','Za ','Matsu ','Bai ','Shin ','Ou ','Chuu ','Kyo ','Bin ',
        'Chu ','Jia ','Futsu ','Zhan ','Chu ','Tan ','Taku ','Bo ','Den ','Ratsu ','Fu ','Hou ','Han ','Haku ','Rei ','Da ',
        'Kai ','Kan ','Kyo ','Taku ','Batsu ','Ta ','Ta ','Ou ','Kou ','Setsu ','Hen ','Shou ','Hai ','Hai ','Di ','Ni ',
        'Kyo ','Kaku ','Long ','Jian ','','Yong ','Lan ','Ning ','Bo ','Ze ','Sen ','Shuu ','Katsu ','Shiki ','Kitsu ','Jou ',
        'Nin ','Kyou ','Kyou ','Ken ','Sen ','Son ','Satsu ','Gou ','Chi ','Xie ','Ce ','Hui ','Hou ','Ei ','Shuu ','Da ',
        ],
    'x63':[
        'Bo ','Ji ','Kei ','Chitsu ','Kou ','Duo ','Duo ','Shi ','Ketsu ','An ','Rou ','Shin ','Kaku ','Kou ','Ku ','Dong ',
        'Da ','Chou ','Lie ','Ta ','Lu ','Die ','Atsu ','Jue ','Mushiru ','Kyo ','Zhi ','Luan ','Ya ','Zhua ','Ta ','Kyou ',
        'Nao ','Dang ','Jiao ','Zheng ','Ji ','Hui ','Xun ','Ku ','Ai ','Tatsu ','Da ','Za ','Bo ','Kou ','Ti ','Shin ',
        'Cheng ','Suo ','Suo ','Keng ','Mei ','Rou ','Kyoku ','Peng ','Jian ','Yuu ','Tei ','Shan ','Da ','Ban ','Kyou ','Sou ',
        'Feng ','Kaku ','Go ','Kun ','Kyuu ','Tong ','Kon ','Huo ','Tu ','Soku ','Hou ','Ratsu ','Hatsu ','Kan ','Sou ','Detsu ',
        'En ','Ze ','Shou ','Se ','Kaku ','Ho ','Huan ','Ho ','Son ','Yi ','Zhai ','Ryo ','Sou ','Tatsu ','Lao ','Sun ',
        'Bang ','Jian ','Kan ','Dao ','','Wan ','Kin ','Hou ','Sha ','Retsu ','Min ','Mon ','Hu ','Hai ','Kyo ','Dao ',
        'Wo ','Gai ','Ken ','Yue ','Fun ','Ten ','Sui ','Shou ','Totsu ','Ben ','Natsu ','Nen ','Da ','Sotsu ','Wo ','Sei ',
        'Kin ','Cheng ','Ten ','Sou ','Ron ','Qing ','Gang ','Tatsu ','Ju ','Tou ','Hou ','Di ','Shou ','Gun ','Ki ','Tou ',
        'Kou ','Qi ','Hai ','Shu ','Kan ','Ryou ','Eki ','Ya ','Kutsu ','Sou ','Ryou ','Ka ','Yi ','Huo ','En ','Tou ',
        'Ryaku ','Sai ','Tan ','Sei ','Hyou ','Setsu ','Teki ','Kou ','Sui ','En ','So ','Sou ','Kiku ','Ten ','Ken ','Kou ',
        'Bai ','Shou ','Kei ','Lu ','Kaku ','Haba ','','Zhi ','Dan ','Maang ','Xian ','Sou ','Guan ','Hou ','En ','Nuo ',
        'Kan ','Tei ','Jiu ','Sen ','Yu ','Ken ','Ki ','Nan ','Kou ','Juu ','Pi ','Wei ','Sai ','Zou ','Sen ','Byou ',
        'Tei ','Getsu ','Sou ','Shi ','Sou ','Chin ','Yuu ','Shun ','Heng ','Bian ','You ','Kan ','En ','Zuan ','An ','Xu ',
        'Satsu ','Aku ','Ke ','Shi ','Ji ','Tei ','La ','La ','Cheng ','Kai ','Shuu ','Jiu ','Totsu ','Kei ','Ki ','Geng ',
        'Chong ','Shuo ','Setsu ','Setsu ','En ','Ken ','Ya ','Sou ','Sa ','Hai ','You ','','Dam ','Lan ','Wen ','Qin ',
        ],
    'x64':[
        'Chan ','Ge ','Lou ','Zong ','Geng ','Jiao ','Kou ','Qin ','Yong ','Kaku ','Shuu ','Chi ','Zhan ','Son ','Sun ','Haku ',
        'Chiku ','Rong ','Hou ','Sa ','Sou ','Ke ','You ','Tou ','Shi ','Nu ','Xie ','Jian ','Sou ','Qiu ','Kou ','Xian ',
        'Saku ','Sang ','Shin ','Mie ','Aku ','Tai ','Jaku ','Shan ','Tou ','Ketsu ','Tou ','Pan ','Han ','Tou ','Li ','Tou ',
        'Kotsu ','Zhi ','Wa ','Xia ','Ken ','On ','Shou ','Tian ','Zhen ','E ','Kei ','Nuo ','Quan ','Ta ','Saku ','Kaku ',
        'Wu ','En ','Setsu ','Kang ','She ','Shu ','Bai ','You ','Bin ','Sou ','Tan ','Satsu ','Chan ','Suo ','Kyuu ','Shou ',
        'Chuang ','Kaku ','Hei ','Hou ','Shutsu ','Di ','Qi ','','Teki ','Lian ','Tou ','Chi ','Kan ','Roku ','Luo ','Rou ',
        'Sou ','Kai ','Hu ','Sa ','Chuang ','Tang ','Hua ','Sai ','Nai ','Ma ','Jiang ','Gui ','Ying ','Seki ','Ao ','Shi ',
        'Nie ','Man ','Shan ','Kou ','Cho ','Suo ','Tan ','Jiao ','Mo ','Mo ','Shou ','San ','Keng ','Hyou ','Jiang ','Yin ',
        'Gou ','Qian ','Liao ','Geki ','Ying ','Ketsu ','Pie ','Hetsu ','Rou ','Dun ','Xian ','Ruan ','Kui ','Zan ','Yi ','San ',
        'Chou ','Chou ','San ','Dou ','Heng ','Sei ','Qian ','Huang ','Tou ','Son ','Nen ','Rin ','Zheng ','Ki ','Shu ','Kyou ',
        'Ji ','Sou ','Dan ','Tan ','Tetsu ','Hatsu ','Sha ','Jue ','Shou ','Ryou ','Ben ','Bu ','Kyou ','Ha ','Satsu ','Zhuo ',
        'San ','Tuo ','Boku ','Kin ','Dun ','Nian ','','Xie ','Lu ','Kaku ','Cuan ','Tachi ','Kan ','Kou ','Ta ','Ren ',
        'Gan ','You ','Rai ','Kuo ','Ryo ','Sen ','Zhuo ','Taku ','Pu ','Saku ','Geki ','Tou ','Saku ','Sou ','Kei ','Jing ',
        'Kan ','Shou ','Kin ','Kuai ','Tan ','Kei ','Ge ','Heki ','Haku ','Ao ','Kyo ','Ye ','','Mang ','Sou ','Mi ',
        'Sei ','Tai ','Teki ','Tou ','Kou ','Ran ','Satsu ','Kyo ','Ye ','Ju ','You ','Ye ','Gi ','Kyo ','Ji ','Hin ',
        'Dou ','Kaku ','Teki ','Jie ','Kaku ','Ma ','Sen ','Ketsu ','Lie ','Tan ','Hai ','Sou ','Lu ','Ryaku ','Jou ','Teki ',
        ],
    'x65':[
        'Han ','You ','Lei ','Sa ','Cho ','San ','Nian ','Xian ','Kun ','Kaku ','Fuki ','La ','Han ','Ying ','Lu ','Rou ',
        'Qian ','Qian ','Zan ','Ken ','Ran ','San ','Ei ','Mei ','Jou ','Sen ','','San ','Kei ','Setsu ','Ra ','Kun ',
        'Mi ','Li ','San ','Ren ','Tan ','Zuan ','Rei ','Dian ','Wa ','Tou ','Kaku ','Kaku ','Ran ','Li ','Dou ','Shi ',
        'Ki ','Ki ','Qi ','Xin ','Hoku ','Boku ','Shuu ','Kou ','Yuu ','Kai ','I ','Kou ','Kan ','Han ','Hou ','Sei ',
        'Bo ','Dian ','Kou ','Bin ','Wu ','Ko ','He ','Saku ','Kou ','Bi ','Chu ','Kaku ','Di ','Jo ','Kyou ','Bin ',
        'Shin ','Kyuu ','Chin ','Duo ','Gyo ','Choku ','Gou ','Hai ','Jo ','Kyou ','Duo ','Lian ','Nie ','Hei ','Shou ','Ten ',
        'Tatsu ','I ','Kan ','San ','Ke ','Yan ','Ton ','Ki ','Dou ','Kou ','Tatsu ','Seku ','Kei ','You ','Xia ','Bin ',
        'Suu ','Ai ','Kou ','Ai ','Sei ','Teki ','Zhen ','Fu ','Suu ','Liao ','Ku ','Kei ','Xi ','Kyou ','Sen ','Kyou ',
        'Zhuo ','Eki ','Ren ','Hei ','Li ','Kou ','Kou ','Bun ','Gaku ','Sei ','Sei ','Zhai ','Hin ','Jue ','Sai ','',
        'Hi ','Han ','Han ','Lan ','Yu ','Ran ','Wei ','To ','Shou ','Ryou ','Jia ','Koku ','Sha ','Ka ','Yu ','Shin ',
        'Kaku ','Atsu ','Tou ','Shuku ','Kin ','Seki ','Gin ','Fu ','Qiang ','Zhan ','Qu ','Shaku ','Zan ','Dan ','Saku ','Shi ',
        'Shin ','Zhuo ','Taku ','Kin ','Rin ','Zhuo ','Chu ','Dan ','Zhu ','Hou ','Xie ','Hang ','O ','Shi ','Pei ','You ',
        'Mye ','Hou ','Ki ','Sen ','Bou ','Ryo ','Hai ','Pi ','Ryuu ','Fu ','Fang ','Sen ','Sei ','Jing ','Ji ','Zoku ',
        'Chou ','Yi ','Ryuu ','Shao ','Ken ','Es ','I ','Ki ','Shi ','Han ','Piao ','Han ','Zhan ','Guai ','Sui ','Yo ',
        'Bu ','Ki ','Ki ','Ki ','Huo ','Nichi ','Tan ','Kyuu ','Shi ','Sou ','Xie ','Tiao ','Jun ','Kyoku ','Xu ','Xu ',
        'Kan ','Kan ','Tai ','Di ','Ku ','Tan ','Shi ','Kuang ','Yang ','Ji ','Ou ','Bin ','Min ','Tun ','Shun ','Go ',
        ],
    'x66':[
        'In ','Bei ','Kou ','Soku ','Han ','Jie ','Kon ','Shou ','Ko ','Hou ','Kou ','Gui ','Shou ','Ken ','Mei ','Kon ',
        'Fen ','Kin ','Kotsu ','Eki ','Seki ','Kin ','En ','Ze ','Fang ','Tan ','Shen ','Ju ','You ','San ','Hei ','Sei ',
        'Ei ','Ken ','Hotsu ','Shin ','Rei ','Shun ','Kou ','Mai ','Saku ','Batsu ','Hen ','Ku ','Kon ','Shou ','Shou ','Ze ',
        'Shi ','Iku ','Fei ','Tetsu ','Bou ','Jitsu ','Chou ','On ','Dong ','Ai ','Bing ','Kou ','Chuu ','Long ','Xian ','Kou ',
        'Chou ','Chou ','Ji ','Kou ','Kou ','Ken ','Kai ','Xu ','Jiao ','Shin ','Shitsu ','Shin ','Shou ','Tong ','Kou ','An ',
        'Gai ','Kyou ','Sai ','Xiao ','Ye ','Yun ','Hui ','Kan ','Kan ','Shun ','Ban ','Ken ','Kon ','Chuu ','Ki ','Sei ',
        'Sei ','Ho ','Setsu ','Zhe ','Go ','Han ','Kai ','Kou ','Shin ','Ban ','Ten ','Taku ','Sai ','Zhou ','Fu ','Kei ',
        'Seki ','Shan ','Yi ','Seki ','Sei ','Kei ','Shou ','Ki ','Tei ','Eki ','Chi ','An ','En ','Lin ','Ryou ','Shou ',
        'Ou ','Gyou ','Zan ','Hi ','Ken ','Xuan ','Yi ','Ka ','Un ','Ki ','Fu ','Bin ','Kei ','Etsu ','Ei ','Sho ',
        'I ','Sho ','Sei ','Mao ','Nan ','Jian ','Dan ','An ','You ','Shun ','You ','Sa ','Fu ','Mei ','Jiao ','Kai ',
        'Kou ','Weng ','Chou ','Qi ','Kou ','Yan ','Reki ','Ai ','Ki ','Gui ','Men ','Zan ','Xie ','Kou ','Bo ','Mo ',
        'Cong ','Jitsu ','Shou ','Hui ','Bou ','Kan ','Xuan ','Chuan ','Ryou ','Sen ','Dan ','Kei ','Hetsu ','Lin ','Ton ','Ki ',
        'Ei ','Ki ','Kou ','Tai ','You ','You ','Reki ','Don ','Tou ','Gyou ','Fei ','Qin ','Shou ','Hao ','Eki ','Kyou ',
        'Xing ','Sen ','Jiao ','Bao ','Kei ','Yan ','Ai ','Ye ','Ru ','Sho ','Bou ','Kun ','You ','Baku ','Li ','Shin ',
        'Kou ','Jou ','','Yan ','Huo ','Lu ','Gi ','Rong ','Rou ','Dou ','Luo ','Ran ','Sai ','Tang ','Gan ','Chu ',
        'Etsu ','Ou ','Kyoku ','Ei ','Kou ','Ei ','Hu ','Katsu ','Sho ','Sou ','Sou ','Shou ','Ban ','Zo ','So ','Tai ',
        ],
    'x67':[
        'Sai ','Can ','Xu ','Kai ','Yin ','Ketsu ','Fen ','Hi ','Getsu ','Yuu ','Ruan ','Hou ','Han ','Fuku ','Rei ','Hi ',
        'Kyou ','','Niku ','Chou ','Saku ','Chin ','Rou ','Rou ','Sen ','Mei ','Huang ','Bou ','Ton ','Chou ','Ki ','Ki ',
        'Ei ','Zong ','Bou ','Tong ','Lang ','','Bou ','Rou ','Boku ','Tou ','Mi ','Matsu ','Hon ','Satsu ','Jutsu ','Jutsu ',
        '','Shu ','Ren ','Hatsu ','Boku ','Da ','Da ','Tou ','Ryoku ','Qiu ','Ki ','Jiu ','Bi ','Kyuu ','Tou ','Shi ',
        'Sha ','Eburi ','Za ','Quan ','Qian ','U ','Kan ','O ','Sa ','San ','Xun ','Fan ','Gotsu ','Zi ','Ri ','Kyou ',
        'Zai ','Son ','Ren ','Hyou ','Taku ','Tei ','Jou ','Mang ','Chi ','Yoku ','Gu ','Gong ','Do ','Chi ','Ko ','Soku ',
        'Kou ','Jou ','Moku ','Soma ','Tochi ','Rai ','Sugi ','Man ','Yang ','Ma ','Byou ','Si ','Gen ','Kou ','Hai ','Hai ',
        'Ketsu ','Tou ','Kou ','You ','Ken ','Sho ','Chun ','Ha ','Shu ','Hua ','Xin ','Chuu ','Cho ','Chou ','Shou ','Han ',
        'Song ','Kyou ','Yue ','Jin ','Kou ','Kei ','Mao ','Hi ','Bi ','Ou ','Ang ','Hou ','Fun ','Yi ','Hu ','Dan ',
        'Seki ','Ko ','Ya ','Shu ','Xun ','Chin ','You ','Rin ','Zei ','Ga ','Mai ','Sou ','Ka ','Shi ','Cong ','Yun ',
        'Waku ','Masu ','Suu ','Zao ','','Li ','Ro ','Jian ','Cheng ','Shou ','Qiang ','Feng ','Nan ','Xiao ','Xian ','Ko ',
        'Hei ','I ','Shi ','Ki ','Kai ','Kyou ','Ka ','Ka ','Ku ','Hou ','Mo ','Ei ','You ','Sou ','Shi ','Nie ',
        'Hi ','Ta ','I ','Rei ','Hei ','Ji ','Rou ','He ','Han ','Han ','Shuu ','Dai ','Ci ','Yang ','Fu ','Haku ',
        'Bou ','Kan ','Shitsu ','Sen ','Nyuu ','Mao ','Zhao ','Shou ','Sha ','Kou ','Yuu ','Shen ','Kyo ','Taku ','Saku ','Nan ',
        'Ning ','Ei ','Tei ','Zhi ','Sa ','Sa ','Tan ','Ko ','','Kyuu ','Ao ','Fu ','Kan ','Bo ','Totsu ','Ka ',
        'Na ','Chuu ','Hi ','Ryuu ','Sai ','Saku ','Shi ','Shuku ','Pei ','Shi ','Guai ','Sa ','Yao ','Jue ','Kyuu ','Shi ',
        ],
    'x68':[
        'Zhi ','Liu ','Toga ','Tochi ','Ei ','Saku ','','Biao ','San ','Jie ','Long ','Dong ','Lu ','Sayng ','Li ','Lan ',
        'Yong ','Shu ','Xun ','Sen ','Kei ','Zhen ','Sei ','Ritsu ','Yi ','Kou ','Zhen ','Li ','Su ','Ten ','Kan ','Hei ',
        'Ren ','Kou ','Haku ','Ren ','Bing ','Zi ','Chou ','Ei ','Setsu ','Ku ','Chu ','Son ','Sei ','Ji ','Er ','Iku ',
        'Hatsu ','Kyou ','Gou ','Rou ','Sen ','Li ','','Yang ','Kaku ','Kon ','Zhi ','Choku ','Kou ','Sai ','Luan ','Fuku ',
        'Ketsu ','Kou ','Kei ','Tou ','Kou ','Gai ','Kyou ','Ru ','An ','An ','Ken ','Yi ','Taku ','Ko ','Shitsu ','Qiong ',
        'Dou ','Sou ','Sou ','Kan ','Kitsu ','Kyuu ','Xue ','Ta ','Tsui ','U ','Zan ','Kasei ','Ou ','Masu ','','San ',
        'Ya ','Nao ','Zhen ','Tou ','Qi ','Qiao ','Hua ','Kai ','Jiang ','Zhuang ','Xun ','Sa ','Sha ','Zhen ','Hai ','Tei ',
        'Katsu ','Kei ','Hotsu ','Ben ','Fu ','Zui ','Tou ','Kaku ','Xi ','Rou ','Ryuu ','Hou ','Shitsu ','Wen ','Kun ','Kan ',
        'Cu ','Ryou ','Kyuu ','Tei ','You ','Bai ','Hou ','Long ','Hou ','Zhuang ','Di ','Xuan ','Tu ','Sou ','Ou ','Koku ',
        'Bi ','Di ','Han ','Shi ','Shi ','Ren ','Hai ','Kou ','Ken ','Huan ','Ban ','Da ','Kyou ','Jou ','Ji ','Kyou ',
        'Ryo ','Kan ','Shou ','Shin ','Fen ','Shou ','Mu ','Go ','Ri ','Ri ','Tou ','Cen ','Ying ','Sa ','Kiku ','Tei ',
        'Kai ','Kon ','Setsu ','So ','Chan ','Fuu ','Bi ','Jing ','Li ','Bin ','Fumoto ','Shikimi ','Tou ','Zhi ','Lai ','Lian ',
        'Jian ','Setsu ','Ling ','Li ','Ki ','Hei ','Rin ','Cong ','Sen ','Men ','Ki ','Ki ','Sai ','Kon ','Chan ','Toku ',
        'Hi ','Hai ','Bou ','Hou ','Kon ','Shu ','Tou ','Sou ','Kyoku ','Rei ','Hou ','Yu ','Yo ','Ko ','Hun ','Tou ',
        'Tou ','Kou ','Wang ','Tei ','Xi ','Han ','Cheng ','San ','Kei ','Yuan ','En ','Yoku ','Ken ','Eki ','Shin ','Jin ',
        'Soi ','Rou ','Sei ','Zhuo ','Fu ','Kan ','Rai ','Zou ','Zou ','Tou ','Kan ','Fen ','Hun ','Chin ','Qiong ','Nie ',
        ],
    'x69':[
        'Wan ','Kaku ','Lu ','Hao ','Setsu ','I ','Chuu ','Ju ','Kiku ','Jou ','Sotsu ','Ryou ','Kou ','Shoku ','Tsui ','A ',
        'Kyo ','Hei ','Shou ','Taku ','Zi ','Bin ','Hou ','Tei ','Chu ','Sugi ','Kunugi ','Momiji ','Ken ','Gui ','Xi ','Du ',
        'Qian ','Kunugi ','Kai ','Shide ','Luo ','Nagi ','Ken ','Myeng ','Tafu ','','Kunugi ','Zhan ','','Tuo ','Sen ','Duo ',
        'Ya ','Fuu ','Wei ','Wai ','Tan ','Ka ','Shu ','Jian ','I ','Chin ','Xi ','En ','Yan ','Ten ','Zhan ','Chin ',
        'Yu ','He ','Sa ','Wo ','Pian ','Hyku ','Yao ','Huo ','Xu ','Jaku ','You ','La ','Yan ','Ben ','Kon ','Kui ',
        'Jie ','Kui ','Si ','Fuu ','Setsu ','Da ','Zhi ','Ken ','Mu ','Bou ','So ','Ko ','Ko ','Ren ','Rou ','Ting ',
        'Nan ','Yu ','Shuu ','Bi ','Sou ','Ken ','Ken ','Ying ','Tei ','Hen ','You ','Shuu ','Ketsu ','Gyou ','Cho ','Jun ',
        'Yu ','Sou ','I ','Bai ','Tei ','Goku ','Jie ','Kai ','Shuu ','Ei ','Juu ','Kou ','Rou ','Gaku ','Hazou ','Katsura ',
        'Komai ','Muro ','Gai ','Tan ','Lan ','Otsu ','Yu ','Chen ','Lu ','Ju ','Sakaki ','','Pi ','Setsu ','Ka ','Yi ',
        'Zhan ','Fu ','Doku ','Mi ','Rou ','You ','Koku ','Jian ','Ku ','Ta ','Yao ','Shin ','Bou ','Sha ','Yuan ','Zi ',
        'Bei ','So ','Jia ','Yao ','Jie ','Kou ','Kan ','Hi ','Sa ','Qian ','Ma ','Shun ','Yuan ','Sha ','Ei ','Shi ',
        'Zhi ','Sui ','Otsu ','Ting ','Ryuu ','Rong ','Tang ','Kaku ','Tai ','Si ','Shou ','Tou ','Kou ','Xi ','Kotsu ','Ki ',
        'Kao ','Kou ','Sun ','Han ','Tao ','Kaku ','Xun ','Ten ','Dou ','Ji ','Saku ','Kou ','Tsui ','Sou ','Sa ','Qian ',
        'Kai ','Bai ','Xu ','Kou ','Gao ','Zhuo ','Taku ','Kyou ','You ','Ten ','Jia ','Jian ','Zui ','Tou ','Rou ','Bin ',
        'Zhu ','','Shuu ','Qi ','Lian ','Ei ','Yong ','San ','Kaku ','Gai ','Gai ','Tan ','Hua ','Shuku ','Shin ','Sai ',
        'Beng ','Yuu ','Koku ','Shou ','Hu ','Kan ','Kui ','Yi ','Nie ','Kou ','Kang ','Ki ','Gui ','Sou ','Ban ','Kin ',
        ],
    'x6a':[
        'Teki ','Tou ','Gaku ','Rou ','Chen ','Shou ','Li ','Xiu ','Qing ','Shuang ','Han ','Tou ','Kan ','Ji ','Suo ','Rui ',
        'Lu ','Ryou ','Mitsu ','Rou ','Sou ','Soku ','Ke ','Cho ','Tang ','Hyou ','Roku ','Kyuu ','Shu ','Sa ','Suu ','Shou ',
        'Bon ','Mo ','Boku ','You ','Jou ','Peng ','Zhu ','Sha ','Sei ','Ken ','Ou ','Kashi ','Cong ','','Hokuso ','Qiang ',
        'Tara ','Ying ','Ji ','Xin ','Shoku ','Shou ','Sai ','Sou ','Boku ','Ju ','Ka ','Ki ','Zhen ','Son ','Etsu ','Sen ',
        'Xi ','Xun ','Dian ','Fa ','Kan ','Bo ','Bu ','Zei ','Dou ','Rin ','Ryou ','Kyou ','Xian ','Run ','Han ','Zhan ',
        'Taku ','Rou ','Un ','Shun ','Tui ','Tou ','Tou ','Meng ','Kitsu ','Tou ','Su ','Ketsu ','Jue ','Tan ','Hui ','Ki ',
        'Nuo ','Shou ','Da ','Ning ','Zui ','Zhu ','Tou ','Sou ','Fen ','Qiong ','Zen ','Ou ','Cen ','Gu ','Liu ','Lao ',
        'Gao ','Zu ','Zusa ','Nude ','Ca ','San ','Ji ','Dou ','Shou ','Lu ','Gaan ','','Yuan ','Ta ','Shu ','Kyou ',
        'Tan ','Rin ','Nong ','In ','Geki ','Sui ','San ','Sui ','Xuan ','Tei ','Gan ','Kyoku ','Zui ','Yoku ','Go ','Pu ',
        'En ','Rai ','Feng ','Hui ','Dang ','Ji ','Sui ','Haku ','Bi ','Ding ','Chu ','Ta ','Kai ','Shuu ','Kai ','Ka ',
        'Kei ','Zhe ','Ken ','Shou ','Dao ','Gi ','Biao ','Song ','She ','Rin ','Reki ','Satsu ','Bou ','Yin ','Tou ','Tai ',
        'Hen ','Ki ','','Bin ','Kaku ','Ji ','Qian ','Mi ','Nei ','Yi ','Gao ','Kan ','In ','Ji ','Kei ','En ',
        'Qi ','Mitsu ','Tou ','Ki ','Chun ','Ji ','Kai ','Po ','Tou ','Chu ','Han ','Mian ','Yuu ','Zhi ','Guang ','Qian ',
        'Rui ','Rai ','Sa ','Ro ','Rei ','San ','Ryo ','Mie ','Hui ','Ou ','Ryo ','Shitsu ','Kou ','Toku ','En ','Reki ',
        'Fei ','Zhuo ','Sou ','Lian ','Sen ','Chu ','','Sho ','Ro ','Yan ','Reki ','Zhu ','Shin ','Jie ','E ','Su ',
        'Kai ','Getsu ','Yo ','Long ','Lai ','','Xian ','Kwi ','Ju ','Xiao ','Rei ','Ou ','Sen ','In ','You ','Ying ',
        ],
    'x6b':[
        'Xiang ','Nong ','Haku ','San ','Ran ','Kyo ','Sou ','Shou ','Wei ','Sou ','Ken ','Qu ','Cang ','','Yu ','Ra ',
        'Rei ','San ','Ran ','Dang ','Jue ','Em ','Ran ','Ran ','Zhu ','Lei ','Li ','Ha ','Nang ','Utsu ','Rei ','Tsuki ',
        'Ketsu ','Ji ','Huan ','Gon ','Yo ','Yu ','Qian ','Ou ','Ku ','Chao ','Chu ','Keki ','Kai ','Yi ','Jue ','Kitsu ',
        'Xu ','Xia ','Yoku ','Kuai ','Lang ','Kan ','Saku ','Ki ','Ai ','I ','Gi ','Kutsu ','Chi ','Kin ','Kan ','Tan ',
        'Kan ','Kan ','Chuan ','Sou ','','Yin ','Kin ','Ketsu ','Yu ','Ken ','Kyou ','Yi ','Ka ','O ','Tan ','Jin ',
        'Ou ','Hu ','Teki ','Kan ','Kyo ','Pen ','Ki ','Xiao ','Kutsu ','Kyuu ','Sen ','Kan ','Chu ','Eki ','Kan ','Yo ',
        'Setsu ','Kan ','Shi ','Sei ','Shi ','Ho ','Bu ','Ki ','Bu ','Ho ','Wai ','Kyo ','Qian ','Chi ','Juu ','Shi ',
        'Shuu ','Zhong ','Sei ','Sei ','Reki ','Saku ','Yu ','Li ','Ki ','Gatsu ','Dai ','Shi ','Jian ','Setsu ','Botsu ','Botsu ',
        'You ','Botsu ','So ','You ','Ten ','Sou ','Tai ','Shang ','Xu ','Jun ','Shu ','Zan ','Jue ','Hyou ','Qia ','Qiu ',
        'Su ','Kyou ','Yun ','Lian ','Yi ','Fuu ','Shoku ','You ','Zan ','Hun ','Dan ','Kyoku ','Ye ','','In ','Otsu ',
        'Shuu ','Bin ','Tei ','Kin ','Shou ','Yin ','Diao ','Cu ','Kai ','San ','Ei ','Tan ','To ','Kyou ','Ren ','Hin ',
        'Toku ','Sen ','Sen ','Shu ','Ou ','Dan ','Zhu ','In ','Kei ','Ei ','Satsu ','Kaku ','Kaku ','Kou ','Shun ','Ten ',
        'Ki ','Ki ','Gu ','Kaku ','Keki ','Ki ','Ou ','Hui ','Duan ','I ','Xiao ','Bu ','Kan ','Bo ','Mai ','Mai ',
        'Ai ','Zuo ','Doku ','Iku ','Hi ','Bi ','Hi ','Pi ','Hi ','Bi ','San ','Mou ','','','Pu ','Mushiru ',
        'Jia ','Sen ','Sai ','Boku ','Tuo ','Xun ','Ji ','Juu ','Xian ','Ju ','Mu ','Kou ','Kyuu ','Dou ','Mushiru ','Tan ',
        'Pei ','Kiku ','Duo ','Zei ','Bi ','San ','','Bou ','Sui ','Yu ','Yu ','Tuo ','He ','Jian ','Ta ','San ',
        ],
    'x6c':[
        'Lu ','Mu ','Ri ','Tong ','Juu ','Shou ','Pu ','Luo ','Sen ','Sou ','Zhan ','Meng ','Luo ','Ku ','Chou ','Shi ',
        'Tei ','Min ','Ketsu ','Bou ','Ki ','Pie ','Nai ','Ki ','Dao ','Sen ','Chuan ','Fun ','Ri ','Nei ','','Hutsu ',
        'Shen ','Dong ','Qing ','Ki ','In ','Xi ','Gai ','You ','An ','Ya ','Ke ','Qing ','A ','Dong ','Tan ','Lu ',
        'Qing ','Yang ','Un ','Un ','Sui ','Sanzui ','Shou ','Hyou ','Ei ','Kan ','Sui ','Roku ','Ni ','Ton ','Han ','Ki ',
        'Tei ','Juu ','Kyuu ','Bin ','Ze ','Mian ','Cuan ','Hui ','Diao ','Yi ','Sa ','Saku ','Chuan ','Kan ','Han ','Tai ',
        'Seki ','Tuo ','Bou ','Qiu ','Kitsu ','San ','Pai ','Kan ','Qian ','O ','O ','Shin ','Shi ','Jo ','Kou ','Kou ',
        'Chi ','O ','Tsuchi ','','Tang ','Zhi ','Chi ','Ken ','Beki ','Itsu ','Ou ','Kei ','Jing ','Zei ','Jun ','Kou ',
        'Ta ','Quan ','Kyuu ','Hen ','Hen ','Gan ','Bun ','Zhong ','Hou ','Kyou ','Ketsu ','Ko ','','Ki ','Fun ','Xu ',
        'Xu ','Shin ','Ki ','Yoku ','Yun ','Gen ','Kou ','En ','Chin ','Chin ','Dan ','You ','Ton ','Go ','Huo ','Qi ',
        'Boku ','Rou ','Botsu ','Tou ','Ben ','Butsu ','Chuu ','Ten ','Hi ','Sa ','Shi ','Hai ','Han ','Zhui ','Za ','Kou ',
        'Liu ','Botsu ','Taku ','Feng ','Ou ','Li ','Lun ','Cang ','Feng ','Wei ','Hu ','Matsu ','Mei ','Shu ','Sho ','Zan ',
        'Taku ','Ta ','Ta ','Ka ','Rei ','Dei ','Yi ','Fa ','Futsu ','Yu ','Ten ','Ji ','Shou ','Ko ','Ten ','En ',
        'Si ','Kyou ','Kei ','Ju ','Ei ','Shuu ','Itsu ','Jia ','Zhong ','Sen ','Haku ','Hui ','Hitsu ','Hon ','Zhuo ','Chutsu ',
        'Ryoku ','Yuu ','Ko ','Ou ','Kan ','Hou ','Bou ','Shi ','Hu ','Hou ','Sei ','Han ','Tei ','So ','Ning ','Cheng ',
        'Rei ','Hou ','Ha ','Kyuu ','Si ','Dei ','Ju ','Etsu ','Chuu ','Sou ','Rui ','Ken ','Ketsu ','Fu ','Han ','Bin ',
        'Tai ','Ou ','Sei ','Ei ','Kan ','Ryuu ','Xue ','Long ','Lu ','','Bo ','Xie ','Po ','Ze ','Jing ','Yin ',
        ],
    'x6d':[
        'Zhou ','Ji ','Yi ','Hui ','Kai ','Zui ','Cheng ','In ','Wei ','Hou ','Sen ','You ','Retsu ','Si ','Ki ','Ji ',
        'Xing ','Huku ','Sei ','Saku ','Zhi ','Yin ','Wu ','Sen ','Kao ','Shu ','Kou ','Raku ','','An ','Dou ','I ',
        'Mou ','Lei ','Yi ','Mi ','Quan ','Shin ','Baku ','I ','Kou ','Ei ','Kou ','Kyoku ','Shuo ','Kuang ','Tou ','Ketsu ',
        'Ju ','Ji ','Shuu ','Jo ','Ping ','Shun ','Kyou ','Zhi ','Kou ','En ','Ming ','Katsu ','Ai ','Kou ','Ha ','O ',
        'Qu ','Ryuu ','Yi ','Jia ','Jou ','Sen ','Jiang ','Jiao ','Cheng ','Shi ','Zhuo ','Ce ','Pal ','Kuai ','Ji ','Liu ',
        'Chan ','Hun ','Hu ','Nong ','Xun ','Jin ','Lie ','Kyuu ','Wei ','Setsu ','Shun ','Han ','Hin ','Mang ','Saku ','Yuu ',
        'Xi ','Hotsu ','Dou ','Kan ','Kou ','Yuu ','Ho ','Tei ','Lan ','Kou ','Rou ','Han ','Ri ','Geng ','Fu ','Go ',
        'Ren ','Chun ','Feng ','Yi ','Yoku ','Tong ','Lao ','Kai ','Shin ','Shou ','Chong ','Weng ','Bai ','Sui ','Cheng ','Pei ',
        'Xian ','Shen ','To ','Kun ','Pin ','Netsu ','Han ','Tei ','Shou ','Shou ','Nian ','Tu ','Yuu ','Xiao ','Sen ','Ting ',
        'E ','Sou ','Ton ','Ken ','San ','Tei ','Rei ','Sei ','Shi ','Rui ','Sei ','Tou ','Toku ','Lao ','Lai ','Lian ',
        'Wei ','Wo ','Yun ','Kan ','Di ','','Run ','Jian ','Zhang ','Se ','Huu ','Guan ','Kei ','Shou ','Shuan ','Gai ',
        'Chuo ','Zhang ','Eki ','Kong ','En ','Kan ','Tuo ','Tou ','Ko ','Wa ','Ju ','Gan ','Ryou ','Kon ','Ta ','Toku ',
        'Ten ','Qie ','De ','Juan ','Shi ','Seki ','Kou ','Ki ','Kotsu ','Guo ','Kan ','Rin ','Shou ','Zhou ','Hou ','Kou ',
        'Chang ','Shuku ','Sei ','Fang ','Chi ','Riku ','Dou ','Ju ','Tou ','Sou ','Rui ','Sei ','Peng ','Hi ','Shou ','Ten ',
        'Hi ','Tan ','Yoku ','Ni ','Yo ','Roku ','Kan ','Mi ','Jou ','Ryou ','Rin ','In ','Sai ','Qu ','Wai ','Iku ',
        'Den ','Shin ','Piao ','Shun ','Otsu ','En ','Rai ','Kon ','Sei ','En ','Sen ','Ten ','Byou ','Zhi ','Yin ','Mi ',
        ],
    'x6e':[
        'Hon ','Yuan ','Wen ','Re ','Hi ','Sei ','Yuan ','Katsu ','Sai ','Shou ','En ','Juu ','Roku ','Zi ','Du ','',
        'Jian ','Min ','Pi ','Kei ','Yu ','En ','Shen ','Shin ','Rou ','Kan ','Sho ','Gen ','Nuan ','Yu ','Shuu ','Tei ',
        'Kyo ','To ','Huu ','Sa ','Botsu ','Aku ','Ka ','Tei ','Wei ','On ','Ru ','Setsu ','Soku ','I ','Ka ','Kou ',
        'Yan ','Hong ','Sen ','Mi ','Katsu ','Mao ','Ei ','Yan ','Yuu ','Kou ','Byou ','Sei ','Bi ','Zai ','Kon ','Nai ',
        'Kui ','Shi ','E ','Hai ','Bi ','Ren ','Qi ','Qi ','Bai ','Ten ','Sou ','I ','Can ','Tan ','Ben ','Kai ',
        'Mo ','Sho ','Shuu ','Hon ','Sen ','Jian ','Ko ','Hou ','Shou ','Yi ','Yin ','Tan ','Shoku ','Kai ','Tou ','Kou ',
        'Tan ','Yu ','Hyoku ','Bin ','Shi ','Tu ','Sheng ','Yuu ','Keki ','Zhong ','','Shou ','Jiao ','qiu ','In ','Tou ',
        'Long ','Huo ','Kan ','Dan ','Ban ','You ','Sen ','Chui ','Liang ','Chan ','Yan ','Jun ','Nie ','Shi ','Wan ','Shitsu ',
        'Man ','Ying ','Ratsu ','Kui ','','Jian ','Xu ','Lu ','Ki ','Gai ','','','Hatsu ','Shin ','Gui ','Tou ',
        'Gen ','Suo ','Yuan ','Ren ','Yao ','Meng ','Jun ','Sheng ','Kou ','Tai ','Da ','Wa ','Ryuu ','Kou ','Sao ','Mei ',
        'Sa ','Shi ','Itsu ','Lun ','Ma ','Ho ','Mi ','Ritsu ','Cai ','Wu ','Kei ','On ','Qiang ','Shoku ','Shi ','So ',
        'Yi ','Shin ','Sou ','Un ','Xiu ','Yin ','You ','Kon ','Su ','Su ','Deki ','Tou ','Shi ','Joku ','Wei ','Han ',
        'Chiku ','Cho ','Bou ','Ou ','Sou ','Metsu ','He ','Ten ','Kou ','Kou ','Ki ','Ji ','Deki ','Chi ','Kei ','Hu ',
        'Jie ','Katsu ','Ge ','Sai ','Tou ','Tou ','Sui ','Bi ','Jiao ','Hui ','Kon ','Yin ','Gao ','Sou ','Tai ','Yan ',
        'She ','Man ','Ying ','Chun ','Lu ','Lan ','Luan ','','Bin ','Tan ','Yu ','Shuu ','Ko ','Hitsu ','Hyuu ','Tai ',
        'Jiang ','Kou ','Shin ','Shang ','Teki ','Mi ','Ao ','Ro ','Ko ','Ko ','You ','San ','Fan ','You ','Kon ','Man ',
        ],
    'x6f':[
        'Qing ','Ryou ','Hyou ','Ji ','Gai ','Jiao ','Shitsu ','Xi ','Sei ','Roku ','Ru ','Long ','Kin ','Kaku ','Cong ','Rou ',
        'Zhi ','Gai ','Qiang ','Ri ','En ','Sou ','Kou ','Cong ','Shin ','Tuan ','Ou ','Tou ','Ye ','Xi ','Mi ','Tang ',
        'Baku ','Shang ','Kan ','Ran ','Lan ','Wa ','Gi ','Qian ','Feng ','Sen ','I ','Man ','Shi ','Bou ','Kang ','Tou ',
        'Hou ','Sou ','Chou ','Shou ','Chong ','Xu ','Kan ','Kuo ','Zen ','Yan ','Chuang ','Ryou ','Sai ','Ti ','You ','Shou ',
        'Sou ','Ei ','Hong ','Xun ','Shu ','Kan ','Ying ','Xiao ','','','Xu ','Lian ','Zhi ','Wei ','Pi ','Ketsu ',
        'Jiao ','Hatsu ','Tou ','Kei ','Ketsu ','Wu ','Pa ','Shuu ','Han ','Ki ','Shuku ','Sen ','Sen ','Kyuu ','Ro ','Seki ',
        'Sun ','Ton ','Kou ','Min ','Jun ','Su ','Rou ','Zhen ','Sou ','Yi ','Di ','Wan ','Tan ','Tan ','Chou ','Jin ',
        'Kai ','','Shao ','Tu ','Cho ','San ','Hei ','Bi ','San ','Chan ','San ','Shu ','Dou ','Ho ','Rin ','Wei ',
        'Juu ','Juu ','Chou ','Gei ','Chou ','Hua ','Gyou ','Rou ','Tetsu ','Gan ','Cun ','Kou ','Shi ','Shu ','Hou ','Han ',
        'Un ','Ryuu ','Kou ','Huku ','Kou ','He ','Kan ','Kan ','Shan ','Seki ','Iku ','','Lan ','','Yu ','Rin ',
        'Shou ','Sou ','Dang ','Kan ','Taku ','Kai ','Yo ','Rei ','Sei ','Xue ','Rei ','Man ','Zi ','Yong ','Kai ','San ',
        'Ren ','Ten ','Ye ','Iku ','Huan ','Shin ','Sen ','Man ','Dan ','Tan ','Yi ','Sui ','Heki ','Ju ','Ta ','Qin ',
        'Geki ','Daku ','Ren ','Nou ','Guo ','Shin ','Fun ','Shoku ','Shuu ','Sui ','Kai ','Chu ','Ta ','Song ','Ding ','',
        'Zhu ','Lai ','Bin ','Lian ','Dei ','Shitsu ','Shu ','Mi ','Nei ','Ying ','Ei ','Meng ','Jin ','Qi ','Hi ','Sai ',
        'Gou ','Ju ','Zui ','Wo ','Tou ','Yin ','Yin ','Dui ','Shi ','Kaku ','Jing ','Ran ','Shun ','Ai ','Hoku ','Taku ',
        'I ','Hin ','Gu ','Sen ','Xing ','Hin ','Katsu ','Fei ','','Boku ','Sen ','Wei ','Roku ','San ','Ryo ','Li ',
        ],
    'x70':[
        'Yuu ','You ','Lu ','Si ','Jie ','Ei ','Toku ','Ou ','Hui ','Sha ','Pan ','Shin ','Biao ','Ten ','Mo ','Ryuu ',
        'Jian ','Baku ','Shoku ','Chou ','Gu ','Hin ','Huo ','Ken ','Ro ','Qin ','Kan ','Ei ','Yong ','Reki ','Jou ','Shou ',
        'Ei ','Sui ','Wei ','Kai ','Huai ','Hao ','Cho ','Sou ','Rai ','Dui ','Fan ','Hu ','Rai ','','','Ei ',
        'Bi ','Ji ','Ren ','Jian ','Ei ','Fen ','Lin ','Yoku ','Jian ','Seku ','Chan ','Dai ','Jou ','Jian ','Ran ','Fan ',
        'Shuang ','Yuan ','Zhuo ','Huu ','Shou ','Lei ','Lan ','Cong ','Ku ','You ','Sen ','Hou ','Kan ','Que ','En ','Hao ',
        'Hyeng ','Sai ','Zan ','Luan ','En ','Ri ','Mi ','Shan ','Dan ','Dang ','Jiao ','Chan ','','Kou ','Ha ','Zhu ',
        'Lan ','Lan ','Nang ','Wan ','Ran ','Shun ','Xian ','En ','Gan ','En ','Yu ','Ka ','Hyou ','Mie ','Kou ','Tou ',
        'Kai ','Xiao ','Xiao ','','Hong ','Rei ','Sou ','Zhuan ','Kyuu ','Zha ','Xie ','Chi ','Shaku ','Sai ','Sai ','Can ',
        'Yang ','Ki ','Zhong ','Fen ','Niu ','Kei ','Bun ','Po ','Yi ','Ro ','Sui ','Pi ','Kai ','Pan ','En ','Kai ',
        'Pang ','Mu ','Sou ','Liao ','Kei ','Kou ','Ton ','Kou ','Kin ','Sha ','Kwang ','You ','Wei ','Qiang ','','Da ',
        'Xia ','Zheng ','Zhu ','Ke ','Shou ','Fu ','Ba ','Duo ','Duo ','Ling ','Zhuo ','Ken ','Ko ','Tan ','Hou ','Kei ',
        'Hou ','Tai ','Tai ','Hei ','You ','Tong ','Han ','Shu ','Saku ','Ten ','I ','Shi ','Lian ','Chi ','Huang ','',
        'Hu ','Shuo ','Lan ','Jing ','Jiao ','Xu ','Xing ','Quan ','Retsu ','Kan ','You ','Kou ','Xiu ','Xian ','Yin ','U ',
        'Zhou ','You ','Shi ','Ei ','Tou ','Ketsu ','Sai ','Kai ','Kou ','Raku ','Xia ','Zhu ','Ten ','Jou ','Po ','En ',
        'Hui ','Guang ','Zhe ','Hui ','Kou ','','Fan ','Shao ','Ye ','Hui ','','Tang ','Jin ','Re ','','Xi ',
        'Fu ','Kei ','Che ','Pu ','Jing ','Zhuo ','Ting ','Wan ','Hai ','Hou ','Kou ','Shan ','Hu ','Hou ','Chi ','Rong ',
        ],
    'x71':[
        'Hu ','','Shu ','Kaku ','Kun ','Koku ','Etsu ','Shou ','Xi ','En ','Han ','Sou ','Shun ','Di ','Xie ','Kyoku ',
        'Wu ','','Lua ','Han ','En ','Kan ','Men ','Ju ','Chou ','Hou ','Fun ','Lin ','Kon ','Hun ','Ton ','Xi ',
        'Sai ','Mu ','Hong ','Ju ','Fu ','Wo ','Shou ','Cong ','Feng ','Ping ','Qiong ','Zetsu ','Xi ','Kei ','Xin ','Shaku ',
        'En ','En ','Yi ','Jue ','Yu ','Gang ','Zen ','Pi ','Ko ','','Sheng ','Shou ','Shou ','','Nam ','Geng ',
        'Wat ','Shin ','He ','Kui ','Zhong ','Tan ','Ka ','Ki ','Feng ','Ren ','Ken ','Sei ','Kou ','Jiao ','Sen ','Bi ',
        'Ei ','Sha ','I ','Tuan ','Tian ','Ki ','Dan ','Dan ','Chan ','En ','Kei ','Jiong ','Iku ','Mei ','Satsu ','Wei ',
        'You ','Xin ','Kei ','Rou ','Bai ','Kan ','Ku ','Shou ','Wai ','Han ','Qiu ','Sui ','You ','Lie ','Sha ','',
        'Gao ','Gua ','Bao ','Hu ','Un ','Xia ','','','Bian ','Kou ','Tui ','Tang ','Chao ','Sen ','En ','Bo ',
        'You ','Xie ','Xi ','Wu ','Soku ','Un ','He ','Koku ','Ki ','Yun ','Yuu ','Nai ','Sen ','','Yao ','Kun ',
        'Mi ','Lian ','Kei ','Wu ','You ','Kou ','En ','Qiang ','Liu ','Ki ','Hitsu ','Hyou ','Zong ','Lu ','Jian ','Juku ',
        'Yuu ','Lou ','Hou ','Sui ','Yi ','Tong ','Jue ','Zong ','I ','Hu ','Yi ','Zhi ','Gou ','Wei ','Liao ','Zen ',
        'Ou ','Netsu ','Kei ','Man ','','Shang ','Cuan ','Zeng ','Jian ','Ki ','Ki ','Xi ','Yi ','Xiao ','Shi ','Kou ',
        'Sen ','You ','Qian ','Nen ','En ','Xian ','Qiao ','Zun ','Tou ','Ton ','Shen ','Shou ','Fun ','Si ','Ryou ','Yu ',
        'Rin ','Tong ','Shou ','Fun ','Han ','En ','Shin ','Ran ','Mei ','Tou ','Itsu ','Jing ','Mon ','','','Ei ',
        'Iku ','Yi ','Xue ','Lan ','Tai ','Sou ','San ','Sui ','Xi ','Que ','Cong ','Lian ','Ki ','Shoku ','Shou ','Ling ',
        'Wei ','Yi ','Xie ','Zhao ','Hui ','Tatsu ','Nung ','Lan ','Jiyu ','Sen ','Kao ','Kun ','Jin ','Chou ','Tou ','You ',
        ],
    'x72':[
        'Kaku ','Lan ','Biao ','Rong ','Li ','Mo ','Baku ','Zetsu ','Ryo ','Rou ','Ao ','Xun ','Kuang ','Shaku ','','Li ',
        'Ro ','Jue ','Liao ','En ','Xi ','Xie ','Long ','You ','','Rang ','Yaku ','Ran ','Cong ','Shaku ','Tong ','Kan ',
        '','Che ','Mi ','Tang ','Ran ','Zhu ','Laam ','Ling ','San ','Yu ','Sou ','Tsumekanmuri ','Ha ','Sou ','Pao ','Shou ',
        'En ','Ai ','I ','','Kaku ','Shaku ','Fu ','Ye ','Ha ','Ta ','Ya ','Kou ','Sho ','Sou ','Ji ','Shou ',
        'Sou ','Ka ','Sou ','Ouchou ','Qiang ','You ','Shou ','Hen ','Han ','Pan ','Shao ','Sen ','Hai ','Du ','Sou ','Chu ',
        'Sou ','Bian ','Chou ','Bou ','Haku ','Sou ','Yuu ','','Toku ','Ga ','Tou ','Gyuu ','Ushihen ','Hin ','Kyuu ','Bou ',
        'Ta ','Bo ','Rou ','Jin ','Mang ','Fang ','Mao ','Boku ','Kou ','Motsu ','Yan ','Ka ','Hai ','Si ','Sen ','Ko ',
        'You ','Ka ','Sei ','Mu ','Tei ','Qian ','Quan ','Sen ','Shi ','Toku ','Xi ','Bou ','Kou ','Ken ','Go ','Koku ',
        'Sei ','Ri ','Ri ','Pou ','I ','Gang ','Zhi ','Hon ','Quan ','Jun ','Du ','Ju ','Jia ','Ken ','Hou ','Pian ',
        'Ke ','Ju ','Kou ','Su ','Xi ','Bei ','Raku ','Jie ','Ma ','San ','Wei ','Bou ','Dun ','Tong ','','Jiang ',
        'Gi ','Li ','Toku ','Lie ','Pi ','Piao ','Bao ','Gi ','Shuu ','Wei ','Kui ','Chou ','Ken ','Kemonohen ','Hatsu ','Han ',
        'Qiu ','Keki ','Sai ','Chuo ','Kan ','Ge ','Jou ','Guang ','Ma ','Yuu ','Kang ','Bo ','Hou ','Ya ','Gin ','Huan ',
        'Jou ','In ','Kyou ','Juu ','Teki ','Qing ','Chuu ','Boku ','Bei ','Hi ','Ju ','Ni ','Sei ','Pao ','Kou ','Tuo ',
        'Ko ','Ling ','Hi ','Pi ','Ni ','Ou ','Yuu ','Kou ','Ketsu ','Sho ','Dan ','Haku ','Gu ','Sen ','Ning ','Kan ',
        'Gan ','Kou ','Kaku ','Zhao ','Ji ','Shun ','Shan ','Ta ','Rong ','Shu ','Tong ','Lao ','Doku ','Kyou ','Shi ','Hua ',
        'Zheng ','Yu ','Sun ','Yo ','Hei ','Mang ','Xi ','Ken ','Ri ','Kyou ','Gen ','San ','Rou ','Hai ','Sei ','Yan ',
        ],
    'x73':[
        'Sha ','Li ','Kan ','Xian ','Kei ','Hai ','Fei ','Ou ','Ba ','Qi ','Gei ','Hyou ','Yin ','Rai ','Xi ','Jian ',
        'Qiang ','Kun ','En ','Ka ','Zong ','Mi ','Shou ','I ','Sei ','Sou ','Ya ','Mou ','Sai ','Sotsu ','Sha ','Ryou ',
        'Cen ','Luo ','Ko ','Zong ','Ki ','Wai ','Feng ','Ka ','En ','Sei ','Cho ','Byou ','I ','Yuan ','Ken ','Tan ',
        'Ya ','Dou ','Katsu ','Jia ','Kou ','Hen ','Yuu ','Yuu ','Mei ','Zha ','You ','Son ','Bo ','Bei ','Katsu ','En ',
        'Sou ','Ma ','Yuan ','Gai ','Goku ','Shi ','Hao ','','Yi ','Zhen ','Sou ','Hao ','Man ','Kyou ','Shou ','Baku ',
        'Shou ','Chan ','Gou ','Ao ','Hao ','Cui ','Fun ','Ketsu ','Hei ','Bi ','Huang ','Pu ','Lin ','Kitsu ','Tou ','Gyou ',
        'Ryou ','Shuo ','Xiao ','Juu ','Ton ','Xi ','Katsu ','Ken ','Doku ','Wai ','Kai ','Ken ','Kai ','Ta ','Sen ','Kun ',
        'Dou ','Hin ','Kaku ','Nou ','Meng ','Ryou ','Nyou ','Kou ','Juu ','Ro ','Datsu ','Ken ','Bi ','Rang ','Huan ','Nao ',
        'Ra ','Ken ','Qi ','Kyaku ','Gen ','Myou ','Ji ','Ritsu ','Lu ','Gyoku ','Su ','Ou ','Qiu ','Ga ','Tei ','Le ',
        'Hatsu ','Ji ','Hong ','Teki ','Chuan ','Kan ','Kyuu ','U ','Ki ','Yu ','Yang ','Ma ','Kou ','Wu ','Hu ','Bin ',
        'Kai ','Ya ','Hin ','Bian ','Bang ','Getsu ','Ketsu ','Yun ','Jue ','Gan ','Kan ','Bai ','Dan ','Hin ','Wei ','Huan ',
        'Xian ','Qiang ','Rei ','Tai ','Yi ','Gan ','Ping ','Ten ','Fu ','Ken ','Xi ','Ha ','Sei ','Kou ','Jia ','Shou ',
        'Haku ','Ci ','Ka ','Ran ','Sheng ','Shin ','I ','Zu ','Ka ','Bin ','San ','Ryuu ','Hitsu ','Chin ','Chin ','Kaku ',
        'Fa ','Long ','Shin ','Kou ','Jian ','Li ','Kou ','Xian ','Zhou ','Kyou ','Yan ','Xiu ','Yang ','Ku ','Raku ','Su ',
        'Shu ','Kin ','Gin ','Shun ','Bao ','Ji ','Kyou ','You ','Xia ','Kou ','Kei ','Chong ','Xu ','Han ','Hai ','',
        'Dang ','Ei ','Hun ','Wen ','Ga ','Tei ','Di ','Bu ','Go ','Sei ','Kun ','Bai ','Bei ','Tei ','Gen ','Shuku ',
        ],
    'x74':[
        'Kan ','Zen ','Yan ','Kyuu ','Ken ','Rou ','Ri ','Shuu ','Fu ','Ryuu ','Ya ','Xi ','Ling ','Li ','Jin ','Lian ',
        'Suo ','Sa ','','Wan ','Dian ','Pin ','Zhan ','Cui ','Min ','Yu ','Kyo ','Chin ','Lai ','Wen ','Sheng ','Wei ',
        'Dian ','Chu ','Taku ','Pei ','Sou ','Ko ','Ki ','E ','Kon ','Shou ','Ki ','Hou ','En ','Koku ','Sou ','Kan ',
        'En ','Chou ','Hai ','Rin ','Kin ','Bi ','Ha ','Que ','Zhuo ','Kin ','Hou ','','Qiong ','Du ','Jie ','Kon ',
        'U ','Bou ','Mei ','Chun ','Sen ','Tei ','Sei ','Tai ','Rou ','Min ','Zhen ','I ','Ruan ','Kan ','Jie ','Chuan ',
        'Jian ','Ten ','Chou ','Lian ','Quan ','Ka ','Duan ','En ','Ye ','Dou ','Ko ','Ei ','Yu ','Kou ','Zui ','Shitsu ',
        'Ryuu ','','You ','Sa ','You ','Wen ','O ','Shin ','Shin ','Ei ','Ba ','Tou ','Liu ','Tou ','Ritsu ','Rou ',
        'Kai ','Ten ','Shou ','Sa ','Jue ','Zhao ','You ','Ai ','Bin ','Tu ','Chang ','Kun ','Zhuan ','Cong ','Kin ','Yi ',
        'Sai ','Sou ','Qi ','Ri ','Ying ','Sou ','Kyuu ','Sen ','Ao ','Rin ','Men ','Shou ','Yin ','','Ying ','Tei ',
        'Ro ','Bu ','Tou ','xiu ','Zeng ','Xun ','Qu ','Dang ','Rin ','Ryou ','Kei ','Su ','Kou ','Gui ','Haku ','Ei ',
        'Han ','Shin ','Ryuu ','Ki ','','Jing ','Ai ','Heki ','San ','Kyo ','Sou ','Tou ','Jiao ','Gun ','Tan ','Kai ',
        'Kan ','Shitsu ','Sui ','Tian ','','Yo ','Jin ','Lu ','Bin ','Shuu ','Wen ','Sui ','Lan ','Ji ','Ji ','Sen ',
        'Ruan ','Huo ','Gai ','Lei ','Du ','Li ','Zhi ','Rou ','Rei ','San ','Kei ','Zhe ','Kai ','Sui ','La ','Rou ',
        'Ro ','Li ','Zan ','Ran ','Ei ','Mi ','Xiang ','Xi ','Kan ','Dao ','San ','Kan ','Ka ','Bo ','Tetsu ','Haku ',
        'Ko ','Zhi ','Hyou ','Ben ','Shou ','Li ','Ga ','Dekaguramu ','Kou ','Kiroguramu ','Han ','Hon ','Fang ','Dan ','Ou ','Ou ',
        'Deshiguramu ','Miriguramu ','Ton ','Hu ','Rii ','Yi ','Hei ','Shi ','Hekutogura ','Juan ','Chou ','Chi ','Sarake ','Dang ','Meng ','Hou ',
        ],
    'x75':[
        'Zhui ','Hei ','Bian ','Shuu ','Ken ','Senchigura ','Shi ','Ying ','Qi ','Xian ','Lou ','Di ','Ou ','Bou ','Sen ','Peng ',
        'Lin ','Sou ','Bu ','Heki ','Dan ','Ou ','Ou ','Gen ','Kan ','Dai ','Shin ','Ten ','Ten ','Han ','Shou ','Sei ',
        'Sei ','Shin ','San ','San ','Zui ','Sei ','So ','Shin ','You ','Shutsu ','Roku ','Ho ','You ','Beng ','Feng ','Nei ',
        'Den ','Yuu ','Kou ','Shin ','Sou ','Dian ','Futsu ','Dan ','Ten ','Hei ','Chou ','Ga ','Chou ','Ken ','Shi ','Mou ',
        'Hi ','Qi ','Liu ','Shun ','Ryuu ','Chang ','Ho ','In ','Han ','Fu ','Kou ','Ten ','Kai ','Kai ','Ken ','I ',
        'Fuku ','Hata ','Ho ','Tap ','Han ','Jiang ','Wa ','Tou ','Nan ','Ryuu ','Hon ','Shin ','Chiku ','Ho ','Bou ','Shoku ',
        'Hata ','Kai ','Hitsu ','Da ','Shi ','Ryaku ','Kei ','Ryaku ','Pan ','Kesa ','Ban ','Kaku ','Yo ','Yo ','Mu ','Shun ',
        'I ','Ryuu ','Yo ','Jou ','Chuu ','Kaku ','Tou ','Tetsu ','Ki ','Wan ','Kyou ','Shou ','Chou ','Ton ','Sui ','Ki ',
        'Cha ','Ryu ','Jou ','Tuan ','Lin ','Kyou ','Kyou ','Chuu ','Bo ','Jou ','Jou ','So ','Nie ','Dan ','So ','So ',
        'Chi ','Gi ','Daku ','Zai ','Chou ','Hi ','Jie ','Liao ','Gang ','Gitsu ','Kyuu ','Zhou ','Ka ','San ','Xu ','Nue ',
        'Li ','Yang ','Chin ','Yuu ','Ha ','Kai ','Jue ','Zhi ','Xia ','Cui ','Bi ','Eki ','Li ','Zong ','Chuang ','Feng ',
        'Zhu ','Hou ','Hi ','Kan ','A ','Shi ','Xie ','Qi ','Tan ','Shin ','Hou ','Zhi ','Tou ','Sho ','Shitsu ','Hi ',
        'Ku ','Sen ','Ka ','Ken ','Sa ','Byou ','Datsu ','Shou ','Yong ','Jing ','Sen ','Chong ','Tou ','I ','Kai ','I ',
        'Hui ','Duo ','You ','Chi ','Ji ','Kon ','Ya ','Bai ','Tou ','Kei ','Xiao ','Tsuu ','Toku ','Mang ','Hi ','Shou ',
        'San ','Ho ','Ri ','Shi ','Sa ','Duo ','Wu ','Sa ','Lao ','Sou ','Huan ','Xian ','Eki ','Peng ','Chou ','Kan ',
        'Tan ','Hi ','Ma ','Rin ','Chi ','Ji ','Dian ','An ','Chi ','Hi ','Hi ','Min ','Ko ','Dui ','A ','I ',
        ],
    'x76':[
        'Yo ','Sui ','A ','Shoku ','Shaku ','Dan ','Shen ','Shou ','Kei ','Yu ','Kou ','Fuu ','Ratsu ','You ','Shen ','To ',
        'Yu ','Gua ','Gon ','Tan ','Ku ','Ka ','In ','Yi ','Lu ','Sou ','Jue ','Sei ','Shoku ','Kan ','Ei ','On ',
        'Seki ','Sou ','Han ','Kai ','Ryuu ','Sa ','Sou ','Gyaku ','Dian ','Tou ','Pie ','Tan ','Zhang ','Hyou ','Shin ','Cu ',
        'Rui ','Yi ','Shou ','Chuu ','Shou ','Sai ','Sou ','Suo ','Ka ','Chou ','Rou ','Rou ','Baku ','Jin ','Yin ','Ying ',
        'Kou ','Fuku ','Ryou ','Ryuu ','Shou ','Ryuu ','Rou ','Kan ','Hai ','Tan ','In ','Kaku ','Gan ','Ban ','Xian ','Guan ',
        'Guai ','Nong ','Yu ','Wei ','Yi ','You ','Heki ','Lei ','Rei ','Sho ','Dan ','Lin ','Den ','Lin ','Lai ','Hetsu ',
        'Ji ','Chi ','You ','Xian ','Setsu ','Chou ','Mak6','Reki ','Kaku ','Rai ','Shaku ','Dian ','Sen ','Ei ','In ','Ku ',
        'You ','Tan ','Ten ','Luo ','Ren ','Luan ','Hatsu ','','Ki ','Po ','Hotsu ','Tou ','Hotsu ','Haku ','Hyaku ','Qie ',
        'Hyuu ','Sou ','Zao ','Bou ','Teki ','Hae ','Kai ','Kou ','Ki ','Ci ','Ling ','Kou ','Batsu ','Soku ','Kou ','Peng ',
        'Kou ','Ai ','E ','Kou ','Han ','Hyoku ','Kan ','Chou ','Qian ','Seki ','Gai ','Kyou ','Kou ','Kou ','Hao ','Saku ',
        'Sai ','Hao ','Kyou ','You ','Ha ','Kou ','Kyou ','Ai ','Sei ','Huang ','Reki ','Piao ','He ','Shaku ','Hi ','Gan ',
        'Hou ','Zhou ','Jun ','Qiu ','Shun ','Que ','Zha ','Ko ','Kun ','Kun ','Suu ','Zha ','Gu ','Ten ','Du ','Bai ',
        'Qi ','Ei ','U ','Hai ','Zhao ','Chuu ','Bon ','He ','Ei ','Ka ','Eki ','Hatsu ','Wan ','Kou ','Ou ','Zhan ',
        'Yan ','Jian ','Kou ','Yu ','Kai ','Fan ','Gai ','Tou ','Pan ','Fu ','Qiu ','Sei ','Tou ','Lu ','San ','Mei ',
        'Rei ','Jin ','Xu ','Kan ','Ban ','Kan ','Ou ','Ro ','Shu ','Zhou ','Tou ','An ','Ko ','Li ','Moku ','Ding ',
        'Kan ','Ku ','Mou ','Mang ','Choku ','Qi ','Gin ','Tian ','Shou ','Shun ','Xin ','Kei ','Han ','Feng ','Jun ','Min ',
        ],
    'x77':[
        'Bei ','Sei ','Shi ','Yun ','Ben ','Pan ','Hou ','Byou ','Tan ','Bi ','Bou ','Kan ','Ken ','Ou ','Shi ','Yang ',
        'Zheng ','Yao ','Shin ','Huo ','Tou ','Shin ','Kuang ','Ku ','Shen ','Chi ','Sei ','Mai ','Batsu ','Zhu ','Shin ','Shin ',
        'Min ','Di ','Wan ','Die ','Tei ','Sei ','Sei ','Chao ','Sou ','Gen ','Bing ','Mi ','Long ','Ki ','Tou ','Bei ',
        'Die ','Yi ','Er ','Ming ','Ken ','Shi ','Kyou ','Ken ','Bou ','Chin ','Chou ','Yang ','Gan ','Baku ','Shuu ','Mai ',
        'Chaku ','Zheng ','Bi ','Jun ','Shao ','Kan ','Kan ','Tei ','Cheng ','Cuo ','En ','E ','Wan ','Ken ','Ki ','Kon ',
        'Lai ','Jian ','Sen ','Tian ','Hun ','Wan ','Chou ','Seki ','Qiong ','Lie ','Gai ','Sei ','Sei ','Li ','Rai ','Sui ',
        'Ken ','Sui ','Ki ','Toku ','Hei ','Hei ','Boku ','Kon ','Gei ','Lu ','Eki ','Shou ','Sai ','Zhou ','Yu ','Hun ',
        'Batsu ','Ka ','Sei ','Kei ','Kon ','','Chun ','Jian ','Mei ','To ','Kou ','Xuan ','Ti ','Kei ','Kou ','Ei ',
        'Bou ','Xu ','Fa ','Wen ','Byou ','Chou ','Ki ','Mi ','Weng ','Kou ','Dang ','Shin ','Kou ','Sou ','Katsu ','Qiong ',
        'Mao ','Mei ','Man ','Shui ','Saku ','Shou ','Ei ','Diao ','Ou ','Mo ','Shun ','Cong ','Lou ','Chi ','Ban ','Hyou ',
        'Dou ','Ji ','Bou ','','Run ','Betsu ','Xi ','Shou ','Pu ','Zhu ','Dou ','Shen ','Shun ','Ryou ','Tetsu ','Kan ',
        'Kan ','You ','Xu ','Dou ','Mou ','Rin ','Ki ','Xian ','Ye ','Ai ','Hui ','Sen ','Ken ','Ko ','Shou ','Ku ',
        'Wei ','Chou ','Sao ','Gei ','Xun ','Yao ','Huo ','Mou ','Ben ','Hin ','Mian ','Li ','Kuang ','Kaku ','Xuan ','Mian ',
        'Huo ','Ro ','Bou ','Long ','Guan ','Ban ','Xi ','Chiku ','Tang ','Kan ','Shoku ','Mu ','Kin ','Lin ','Itsu ','Saku ',
        'Saku ','Jue ','Shi ','I ','Shin ','Chi ','Kou ','Shin ','Ying ','Ku ','Chuu ','Jiao ','Sa ','Tan ','Wai ','Kyou ',
        'Sou ','Waku ','Bai ','Shaku ','Tei ','Qi ','Ji ','Zi ','Kan ','Wu ','Tuo ','Kotsu ','Kou ','Xi ','Fan ','Kuang ',
        ],
    'x78':[
        'Dang ','Ma ','Sa ','Dan ','Jue ','Rei ','Hu ','Min ','Nuo ','Keki ','Kang ','Zhi ','Sei ','Kan ','Kai ','Fen ',
        'E ','Ga ','Hi ','Zhe ','Ken ','Sai ','Zhuan ','Che ','Dun ','Pan ','Yan ','','Feng ','Kyou ','Mo ','Zha ',
        'Sho ','Giku ','Ra ','Ta ','Tuo ','Shi ','Sai ','Chin ','Ai ','Fei ','Mu ','Zhu ','Li ','Hen ','Do ','Ping ',
        'Hou ','Ling ','Hou ','Le ','Ha ','Ou ','Po ','Shin ','Za ','Nuo ','Rei ','Long ','Tong ','','Li ','Kou ',
        'Chu ','Keng ','Quan ','Shu ','Kou ','Kei ','E ','Dou ','Katsu ','Lu ','Wei ','Ai ','Raku ','Ken ','Kei ','Ken ',
        'Tong ','Peng ','Sei ','','Hong ','Shuo ','Xia ','Qiao ','','Gai ','Qiao ','','Kou ','Shou ','Kaku ','Chan ',
        'Rou ','Kou ','Yu ','Kou ','Kou ','Mang ','Long ','Yong ','Sha ','Che ','Gi ','Ryuu ','Kou ','Mang ','Kaku ','Ken ',
        'Sha ','Kun ','Hazama ','','Kaki ','Lu ','Chen ','Jian ','Nue ','Song ','Taku ','Keng ','Hou ','Yan ','Tsui ','Kong ',
        'Ceng ','Go ','Zong ','Qing ','Lin ','Jun ','Ha ','Tei ','Min ','Diao ','Sen ','He ','Roku ','Gai ','Sai ','Shaku ',
        'Ling ','Hi ','Yin ','Tai ','Bu ','Ki ','Lun ','Wan ','Ten ','Gang ','Hai ','Qi ','Chen ','Zen ','Gan ','Katsu ',
        'Ding ','Toku ','Tuo ','Ketsu ','Ei ','Bian ','Ke ','Heki ','Wai ','Seki ','Chin ','Duan ','Ka ','Tou ','Ti ','Dou ',
        'Hou ','Ken ','Tei ','Tan ','Cha ','Seki ','Qi ','','Feng ','Xuan ','Kaku ','Kaku ','Ba ','Kou ','Ten ','Sotsu ',
        'E ','Ji ','Liu ','Si ','Tang ','Hou ','Katsu ','Hei ','I ','Sou ','Rai ','Sa ','Ten ','Xia ','Kei ','Lian ',
        'Han ','Gai ','In ','Tai ','Taku ','Kai ','Rou ','','Qing ','Gun ','Sen ','San ','Qi ','Ao ','Peng ','Riku ',
        'Ro ','Kan ','Qiang ','Chen ','In ','Lei ','Hyou ','Seki ','Ma ','Qi ','Sai ','Zong ','Kei ','Chuo ','','Ki ',
        'Shan ','Lao ','Kyo ','Sou ','Tou ','Jian ','Seki ','Rin ','Ding ','Dian ','Kou ','Han ','Za ','Kou ','Di ','Reki ',
        ],
    'x79':[
        'Kan ','Shou ','','Zhang ','Qiao ','Dun ','Ken ','Iku ','Zhui ','He ','Huo ','Zhai ','Rai ','Ke ','So ','Ji ',
        'Kaku ','Tou ','Gi ','Jiang ','Pi ','Pi ','Yu ','Pin ','Qi ','Gai ','Kai ','Jian ','Yo ','Ruan ','Bou ','Hou ',
        'Ji ','Haku ','','Mie ','Ca ','Kin ','Kou ','Rai ','Lei ','Shitsu ','Rei ','Reki ','Ban ','Kaku ','Pao ','Ying ',
        'Li ','Rou ','Long ','Mo ','Haku ','Sou ','Guan ','Lan ','Zan ','Yan ','Shi ','Shi ','Rei ','Jou ','Sha ','Yaku ',
        'Shi ','Ki ','Ta ','Ma ','Kai ','You ','Ken ','Ki ','Ki ','Shi ','Hou ','Tai ','Zhong ','','Yi ','Seki ',
        'Yuu ','Chitsu ','Tiao ','Futsu ','Hu ','Hi ','So ','Shi ','San ','Mi ','So ','Kyo ','Ko ','Shuku ','Shin ','Sui ',
        'Shi ','Chai ','Dei ','Lu ','Yu ','Shou ','Wu ','Chou ','Hyou ','Shu ','Gui ','Kou ','Zhi ','Sai ','Gao ','Zhen ',
        'Gao ','Shui ','Shin ','Chen ','Gai ','Kun ','Di ','Tou ','Huo ','Tou ','Ki ','Ko ','Kan ','Zui ','Ryou ','Roku ',
        'Rin ','Kin ','Dao ','Zhi ','Roku ','Zen ','Bei ','Zhe ','Hui ','You ','Kei ','In ','Shi ','Ka ','Tei ','Fuku ',
        'Yuan ','Gu ','Xian ','You ','Shi ','I ','Bai ','Si ','Tei ','','Zhuo ','Shin ','Ei ','Shoku ','Gao ','Tang ',
        'Si ','Ba ','Ta ','','Xuan ','Qi ','Gyo ','Ki ','Ki ','Shi ','Zen ','Tan ','Kuai ','Sui ','Rei ','Jou ',
        'Dei ','Tou ','Li ','Jou ','Yaku ','Ti ','Zan ','Lei ','Juu ','U ','Guu ','Chi ','Xie ','Kin ','Ka ','Toku ',
        'Shuu ','Shi ','Jin ','Toku ','Shi ','Cha ','Gan ','Gei ','Sen ','Hei ','Nen ','Shuu ','Qiu ','Chuu ','Fen ','Kou ',
        'Yun ','Ka ','Byou ','Zhi ','Kou ','Hi ','Shi ','Yu ','Hi ','Ku ','Han ','Pi ','Ni ','Reki ','Yuu ','So ',
        'Hi ','Hatsu ','Rei ','Matsu ','Shou ','Den ','Shin ','Ou ','Zuo ','Chitsu ','Chi ','Jotsu ','Kyo ','Shi ','Huo ','Ji ',
        'Shou ','Tou ','Zhi ','Huo ','He ','Yin ','Zi ','Zhi ','Katsu ','Ren ','Du ','I ','Shu ','Hui ','Nong ','Fu ',
        ],
    'x7a':[
        'Ki ','Kao ','Rou ','Hu ','Ze ','Zei ','Lu ','Kon ','Kan ','Kou ','Tei ','Tei ','To ','Sou ','Zei ','Ya ',
        'Lun ','Riku ','Gu ','Zuo ','Jin ','Shun ','Bang ','Hai ','Ki ','Choku ','Chi ','Kon ','Ryou ','Peng ','Ka ','Rin ',
        'Chuu ','Sotsu ','Yu ','Su ','Lue ','','Yi ','Kei ','Bian ','Ji ','Fu ','Hyoku ','Nuo ','Katsu ','Shu ','Sou ',
        'Sho ','Shou ','Tou ','On ','Ren ','Shi ','Yu ','Shoku ','Kiku ','Shin ','Chi ','Tou ','Ka ','Kei ','Kou ','Kou ',
        'Koku ','Rong ','Sui ','You ','Sei ','Kou ','Boku ','San ','Bon ','Chi ','Ji ','Lu ','So ','Seki ','Ei ','On ',
        'Shuu ','Se ','','Yi ','Huang ','Shou ','Ki ','Sui ','Xiao ','Hoku ','Jiao ','Zhuo ','Tou ','Sai ','Lu ','Sui ',
        'Jou ','Shoku ','Ai ','Jou ','Nuo ','Yo ','','Sei ','Tui ','On ','Shou ','Kaku ','Gong ','Ryo ','Biao ','',
        'Jou ','Zhuo ','Li ','Zan ','Ketsu ','Atsu ','Kyuu ','Qiong ','Seki ','Kyuu ','Kuu ','Yu ','Sen ','Sei ','You ','Sen ',
        'Chun ','Totsu ','Rou ','Setsu ','Saku ','You ','Bin ','Bao ','You ','Bing ','Wa ','Chutsu ','Jiao ','Qiao ','Diao ','Wu ',
        'Kei ','You ','Chitsu ','Sou ','You ','Chou ','Kou ','Sou ','Kin ','Xiao ','Cheng ','Kou ','Cuan ','Wo ','Tan ','Kutsu ',
        'Ka ','Zhui ','Xu ','Sotsu ','','Kui ','Dou ','','Yin ','Ka ','Wa ','Ya ','Yu ','Ju ','Kyuu ','You ',
        'You ','Tiao ','Chao ','Wa ','Tian ','Chou ','Ku ','Liao ','Xi ','Go ','Ki ','Sou ','Sou ','Fun ','Kuan ','Ryuu ',
        'Cheng ','Cui ','Piao ','Sou ','Zan ','Kyou ','Kyuu ','Tou ','Sou ','Rou ','Setsu ','Ritsu ','Sho ','Dekaritto ','Fuu ','Kirorittoru ',
        'Chu ','Kou ','Ki ','Miririttoru ','','Deshiritto ','Shu ','Miao ','Ju ','Tan ','Cho ','Rei ','Ryuu ','Hei ','Jing ','Kei ',
        'Shou ','Hekutoritto ','Shi ','Shun ','Hong ','Dou ','Shou ','Jing ','Chou ','Gi ','Ju ','Sei ','Ku ','Ketsu ','Ping ','Tan ',
        'Senchiritto ','Sen ','Ceng ','Deng ','Shun ','Huai ','Kyou ','Kan ','Kei ','Chiku ','Toku ','Roku ','Hou ','U ','Shi ','Kan ',
        ],
    'x7b':[
        'Mang ','Zhu ','Utsubo ','Du ','Kei ','Xiao ','Ha ','San ','Kyuu ','Zhen ','Sou ','Jun ','Ya ','Zhui ','Yuan ','Kotsu ',
        'Gang ','Shou ','Cen ','Pi ','Hitsu ','Jian ','Yi ','Dong ','Sen ','Sou ','Xia ','Teki ','Zhu ','Na ','Chi ','Ko ',
        'Ryuu ','Qie ','Min ','Hou ','Tiao ','Shi ','Fu ','Saku ','Hon ','Hai ','Tan ','Shi ','Dai ','Rei ','Saku ','Do ',
        'Hutsu ','Kou ','Fan ','Ka ','Ka ','Han ','Shi ','Mao ','Po ','Sasa ','Jian ','Qiong ','Long ','Souke ','Bian ','Raku ',
        'Kei ','Kyoku ','Chi ','Yin ','Yao ','Sen ','Hitsu ','Kyou ','Katsu ','Tou ','Jiao ','Kin ','Sen ','Jun ','Jo ','Batsu ',
        'Kyou ','Chiku ','Tou ','Ji ','Tou ','Kou ','Saku ','Zhong ','Kou ','Lai ','Bi ','Shai ','Dang ','Sou ','Ce ','Fu ',
        'In ','Tu ','Pa ','Li ','Rou ','Kyo ','Kan ','Ken ','Han ','Tou ','Kou ','Zhi ','Sei ','San ','Sei ','Cho ',
        'Saku ','Shou ','Sou ','Tei ','Kyou ','En ','Gao ','Kai ','Gan ','Chou ','Kyou ','Gang ','Yun ','O ','Qian ','Shou ',
        'Jian ','Pu ','Lai ','Zou ','Hai ','Bi ','Hei ','Ka ','Chi ','Kai ','Yu ','Sen ','Zhao ','Ko ','Ko ','Sou ',
        'Sei ','Sou ','Sou ','Lu ','Haku ','Ki ','Rin ','San ','Kin ','Fuku ','Satsu ','Ko ','Kou ','Kan ','Ken ','Kin ',
        'Sui ','Kan ','Yuan ','Ce ','Ju ','Ha ','Ze ','Qie ','Tuo ','Luo ','Tan ','Xiao ','Joku ','Sen ','','Hen ',
        'Shun ','Shou ','Sen ','Ping ','Shin ','Sei ','Ko ','Shi ','Cho ','Yue ','Shun ','Ritsu ','Oku ','Tou ','Shuo ','Ji ',
        'Setsu ','Kou ','Sei ','Mei ','Han ','Sui ','Ten ','Hen ','Hou ','Chiku ','Kou ','Kyou ','Kou ','Qiu ','Miao ','Kan ',
        '','Kui ','Sik ','Lou ','Un ','He ','Tou ','Waku ','Chou ','Kou ','Hi ','Jaku ','Zheng ','Kou ','Nie ','Qian ',
        'Shou ','San ','Gong ','Pang ','Toku ','Ritsu ','Hei ','Zhuo ','Cho ','Shi ','Chi ','Zhu ','Qiang ','Rou ','Lan ','Jian ',
        'Bu ','Li ','Sui ','Hitsu ','Teki ','Sou ','En ','Hou ','Shin ','San ','Hai ','Piao ','Tou ','Yu ','Betsu ','Zhuan ',
        ],
    'x7c':[
        'Saku ','Shi ','Ke ','I ','Ko ','Chan ','Kou ','Sou ','Ping ','Shuu ','Ji ','Ki ','Soku ','Rou ','Saku ','Roku ',
        'Nian ','Sa ','San ','Sen ','Sa ','Le ','Duan ','Yana ','Shou ','Haku ','Mi ','Shi ','Dang ','Liao ','Tan ','Ten ',
        'Hu ','Kan ','Min ','Ki ','Dai ','Kyou ','Tou ','Kou ','Shun ','Lao ','Shin ','Shou ','Ro ','Shi ','Zan ','',
        'Pai ','Hata ','Pai ','Kan ','Kyo ','Du ','Roku ','En ','Ha ','Tou ','Sai ','Ke ','Long ','Sen ','Ren ','Bo ',
        'Chuu ','Lai ','','Ran ','Kui ','Yu ','Waku ','Hao ','Zhen ','Tai ','Teki ','Mi ','Chuu ','Seki ','','Hata ',
        'Tou ','Sen ','Shuu ','Han ','Su ','Ryuu ','Sen ','Zhuo ','Tou ','Ryoku ','Ro ','Sen ','Taku ','Ei ','Gyo ','Rai ',
        'Rou ','Shinshi ','Lian ','Ran ','Sen ','Yaku ','Zhong ','Kyo ','Lian ','Hen ','Duan ','Zuan ','Ri ','Shi ','Ra ','Ying ',
        'Waku ','Zhuo ','Yu ','Bei ','Di ','Dekameetoru ','Shen ','Zhe ','Shen ','Jo ','Xie ','Lei ','Sen ','Shi ','Momi ','Cun ',
        '','Kiromeetoru ','Kume ','Hi ','Ban ','Wu ','Sa ','Kou ','Rou ','Fun ','Bi ','Sui ','','Mirimeetoru ','Chi ','Ta ',
        'Ro ','Ba ','Ryuu ','Gan ','Kyo ','Haku ','Mo ','So ','Nen ','Zhou ','Li ','Shuku ','Tiao ','Li ','Sei ','Zoku ',
        'Kou ','Tou ','Shi ','Ce ','Etsu ','Shuku ','Rin ','Shou ','Hekutomeetoru ','','Fen ','Ji ','','Sukumo ','Ryou ','Xian ',
        'Fuu ','Ryou ','San ','Kou ','Li ','Etsu ','Roku ','Kiku ','Qi ','Sui ','Hai ','Chou ','Rin ','Sou ','Sei ','Ka ',
        'Kouji ','San ','San ','Tang ','Hen ','Juu ','Mian ','Kou ','Sho ','Sou ','Ko ','Jian ','Zan ','Shi ','Senchimeeto ','Setsu ',
        'Fu ','Ni ','Hi ','Koku ','Shuu ','Kou ','Tou ','Kyuu ','Sukumo ','Sou ','Sou ','Tang ','Bi ','San ','Fun ','Sou ',
        'Kou ','Jiang ','Bo ','San ','San ','Nuo ','Shi ','Ryou ','Jiang ','Kai ','Bo ','Kai ','','Zong ','Xian ','Da ',
        'Dan ','Nie ','Rei ','Zuo ','Teki ','Getsu ','Chou ','Lan ','Shi ','Si ','Kyuu ','Kei ','Gong ','Zheng ','Kyuu ','You ',
        ],
    'x7d':[
        'Ki ','Cha ','Chuu ','Shun ','Yaku ','Ku ','U ','Kotsu ','Kan ','Jin ','Bin ','Mon ','Qiu ','Tou ','Zi ','Tou ',
        'Chuu ','Huu ','Kei ','Sho ','Shun ','Hi ','Chin ','Sa ','Kou ','Shi ','Kyuu ','Fun ','Un ','Jin ','Tan ','Jin ',
        'So ','Bou ','Saku ','Sai ','Jiu ','Zha ','Ha ','Jin ','Fu ','Zhi ','Sei ','Shi ','Chuu ','Kou ','Satsu ','Rui ',
        'Sei ','Hutsu ','Setsu ','Shin ','Bei ','Cho ','Qu ','Ling ','Zhu ','Shou ','Kon ','Yang ','Hutsu ','Ta ','Shin ','Tai ',
        'Chutsu ','Shi ','Shuu ','Gen ','So ','Kei ','Ban ','Ku ','Baku ','Shu ','Zui ','Kou ','Kei ','Jin ','Kou ','Setsu ',
        'Ketsu ','Shu ','Chou ','Kai ','Bai ','Zetsu ','Kou ','Kotsu ','Ci ','Kan ','Kou ','Jou ','Ketsu ','Ku ','Kou ','Quan ',
        'Gai ','Raku ','Ken ','Hou ','Xian ','Hi ','Kyuu ','Tou ','Juu ','Tiao ','In ','Lei ','Xie ','Quan ','Jo ','Gai ',
        'Tetsu ','Tou ','Shi ','Kou ','Xiang ','Kai ','Zetsu ','Zhi ','Ken ','Ken ','Chi ','Bun ','Zhen ','Ryo ','Cheng ','Kyuu ',
        'Shu ','Hou ','Tou ','Shou ','Wan ','Shin ','Kou ','Xiu ','Tei ','Tou ','Xie ','Kou ','Keki ','Hutsu ','Ting ','Sui ',
        'Dui ','Kon ','Fu ','Kei ','Hu ','Zhi ','En ','Gei ','Feng ','Kei ','Zoku ','Kase ','Sou ','Chin ','Ta ','Rei ',
        'Ryoku ','Liang ','Chuu ','Ken ','Shao ','Qi ','Ki ','Shun ','Qi ','Wan ','Sen ','Sen ','Ju ','I ','Kei ','Tou ',
        'Wan ','Kou ','Mou ','Hou ','Tei ','Sai ','Kuwa ','Sai ','Rin ','Ryuu ','Ki ','Tan ','Bei ','Shaku ','Ryou ','Men ',
        'Qi ','Qie ','Tan ','Shou ','Kon ','Shuu ','Seki ','Shi ','Xing ','Liang ','Kin ','Hi ','Zui ','Bin ','Yoku ','Sou ',
        'Fan ','Ryoku ','Sho ','Ying ','Zhang ','Kasuri ','Sho ','Shou ','Kan ','Kaku ','Sen ','Ruan ','Ben ','Shuu ','Tan ','Zhong ',
        'Tei ','Bin ','Bou ','En ','Setsu ','Hou ','Shi ','Qiu ','Hen ','Kan ','Kou ','Sou ','Men ','I ','Fu ','I ',
        'Yu ','Kou ','Byou ','Xie ','Ren ','Sou ','Hen ','Yun ','Yin ','Tei ','Kai ','Chi ','Un ','Cheng ','Chan ','Dai ',
        ],
    'x7e':[
        'Ka ','En ','Sou ','Xu ','Jou ','Odoshi ','Kou ','Sen ','Ei ','Shin ','Ei ','Tsui ','Ni ','Bang ','Gu ','Pan ',
        'Shuu ','Ken ','Sa ','Quan ','Shuang ','Un ','Xia ','Sai ','Xi ','Rong ','Tao ','Baku ','In ','Shin ','Kou ','Joku ',
        'Koku ','Sai ','Tou ','Ken ','Su ','Zhen ','Juu ','Tou ','Kou ','Cai ','Bi ','Hou ','Shuku ','Ri ','Shuku ','En ',
        'Xi ','Juu ','Rui ','Ten ','Ken ','Ban ','Chuu ','Ru ','Mo ','Hyou ','Ren ','Bi ','Xuan ','Sou ','Seki ','San ',
        'Sui ','Han ','Shuai ','Hou ','Ei ','Sou ','Kyuu ','You ','Kyou ','Hun ','Sen ','Kei ','Zung ','Shuu ','Bin ','Xuan ',
        'Kei ','Qiao ','Shou ','Zuo ','Shoku ','Zen ','San ','Lin ','Kitsu ','Han ','Ryou ','Chuo ','Zun ','Kan ','Jou ','Sen ',
        'Rui ','Shuu ','Kai ','Hua ','San ','Ki ','Kyou ','Un ','Da ','Jou ','Kai ','Kei ','Se ','Ken ','Kyou ','Ken ',
        'Sou ','Cong ','Jie ','Shaku ','Bo ','Chan ','Yi ','Nao ','Sui ','Eki ','Shai ','Ju ','Kei ','Hin ','Ten ','Ran ',
        'Pu ','Kun ','San ','Kasuri ','Peng ','Li ','Boku ','Rai ','Ketsu ','San ','Kou ','You ','Zoku ','Rui ','Sen ','Ten ',
        'Kou ','Ro ','Ten ','Ei ','San ','Shou ','Sen ','Zui ','Sab ','Luo ','Shi ','Tou ','Ran ','Rui ','Ren ','Si ',
        'Jiu ','Yu ','Hong ','Zhou ','Xian ','He ','Yue ','Ji ','Wan ','Kuang ','Ji ','Ren ','Wei ','Yun ','Kou ','Chun ',
        'Pi ','Sha ','Gang ','Na ','Ren ','Zong ','Lun ','Fen ','Zhi ','Wen ','Fang ','Cho ','Yin ','Niu ','Shu ','Xian ',
        'Gan ','Xie ','Fu ','Lian ','Zu ','Shen ','Xi ','Zhi ','Zhong ','Zhou ','Ban ','Fu ','Zhuo ','Shao ','Yi ','Jing ',
        'Dai ','Bang ','Rong ','Jie ','Ku ','Rao ','Die ','Heng ','Hui ','Gei ','Xuan ','Jiang ','Luo ','Jue ','Jiao ','Tong ',
        'Geng ','Xiao ','Juan ','Xiu ','Xi ','Sui ','Tao ','Ji ','Ti ','Ji ','Xu ','Ling ','Ying ','Xu ','Qi ','Fei ',
        'Chuo ','Zhang ','Gun ','Sheng ','Wei ','Mian ','Shou ','Beng ','Chou ','Tou ','Liu ','Quan ','Zong ','Zhan ','Wan ','Lu ',
        ],
    'x7f':[
        'Zhui ','Zi ','Ke ','Xiang ','Jian ','Mian ','Lan ','Ti ','Miao ','Qi ','Yun ','Hui ','Si ','Duo ','Duan ','Bian ',
        'Sen ','Gou ','Zhui ','Huan ','Di ','Lu ','Bian ','Min ','Yuan ','Jin ','Fu ','Ru ','Zhen ','Feng ','Shuai ','Gao ',
        'Chan ','Li ','Yi ','Jian ','Bin ','Piao ','Man ','Lei ','Ying ','Suo ','Mou ','Sao ','Xie ','Liao ','Shan ','Zeng ',
        'Jiang ','Qian ','Zao ','Huan ','Jiao ','Zuan ','Kan ','Sha ','Kou ','Fou ','Ketsu ','Fu ','Ketsu ','Hachi ','Hei ','Tou ',
        'Diu6','Gang ','Ying ','Ou ','Kei ','Ka ','Guan ','Son ','Tan ','Cang ','Qi ','Weng ','Ou ','Rai ','Tan ','Ro ',
        'Kan ','Bou ','Mou ','Mou ','Bou ','Kan ','','Luo ','Fu ','Mi ','Fa ','Ro ','Shu ','Sha ','Mao ','Ko ',
        'Bin ','Kou ','Ba ','Kai ','Tei ','Ken ','Hu ','Shin ','An ','Tou ','Zai ','Kei ','Zhuo ','Yoku ','Chi ','An ',
        'Batsu ','Gun ','Sho ','Si ','Pi ','Ba ','Ryuu ','Hi ','Batsu ','Ri ','Chao ','Wei ','Bi ','Kei ','Sou ','Shou ',
        'Ryuu ','Ji ','Ken ','Beki ','Zhao ','Ra ','Hi ','Ki ','Ki ','Luan ','You ','Ba ','Kyou ','Tatsu ','Bi ','You ',
        'Yuu ','Yuu ','Fen ','Ba ','Kou ','Yang ','Ko ','Kyou ','Sou ','Gao ','Rei ','Yi ','Cho ','Tei ','Shuu ','Qian ',
        'Yi ','Sen ','Jou ','Gun ','Gun ','Qiang ','Kan ','Suo ','Sen ','Gi ','You ','Qiang ','Xian ','Yu ','Kou ','Katsu ',
        'Tang ','Yuan ','Gi ','Fan ','Sen ','Fen ','Sen ','Lian ','Rui ','Kou ','Nou ','Qiang ','San ','U ','Gong ','Gei ',
        'Chuu ','Ou ','Fen ','Kou ','Chi ','Shi ','Sui ','Fu ','Kou ','Pen ','Yoku ','La ','Yoku ','Pi ','Rei ','Ryuu ',
        'Zhi ','Qu ','Shuu ','Xie ','Shou ','Kyuu ','Xi ','Qi ','Qiao ','Hui ','Hui ','Yuu ','Se ','Hong ','Jiang ','Keki ',
        'Sui ','Hi ','Tao ','Sou ','Chi ','Sho ','Sen ','Xuan ','Shi ','Hen ','Zong ','Gan ','Ki ','Hou ','Kaku ','Koku ',
        'Kan ','Ao ','Hyou ','Ei ','Lian ','Qu ','','Lin ','Pen ','Gyou ','Gou ','Hon ','Yoku ','Kai ','Ken ','Tou ',
        ],
    'x80':[
        'You ','Rou ','','Kou ','Mou ','Sha ','Ki ','Kou ','Kou ','Kou ','Tetsu ','Tetsu ','Ji ','Sa ','Zen ','Ji ',
        'Tai ','Tan ','Rai ','Tei ','Shi ','Kou ','Sou ','Mou ','Un ','Ha ','Pi ','Chi ','Shi ','Sho ','Ka ','Kyo ',
        'Kou ','Jo ','Lao ','Lun ','Seki ','Tang ','Gou ','Lou ','Dou ','Jiang ','Pang ','Ze ','Rou ','Ji ','Rou ','Huo ',
        'Yuu ','Mo ','Huai ','Ji ','Chou ','Tei ','Ya ','Tou ','Song ','Kin ','Un ','Chi ','Tan ','Tan ','Kou ','Kou ',
        'Shoku ','','Nie ','Dan ','Shin ','Che ','Rei ','Zheng ','You ','Wa ','Ryou ','Long ','Zhi ','Ning ','Tiao ','Er ',
        'Ya ','Die ','Katsu ','','Lian ','Hao ','Sei ','Lie ','Hei ','Jing ','Shuu ','Bi ','Di ','Guo ','Bun ','Sei ',
        'Hei ','Sou ','Shikato ','','Tei ','Yu ','Sou ','Kui ','Ren ','Kui ','Cong ','Ren ','Weng ','Ki ','Ren ','Ren ',
        'Sou ','Gou ','Sei ','Shou ','Chou ','Gai ','Jou ','Shoku ','Dan ','Dei ','qie ','Ji ','Chou ','Chou ','Rou ','Itsu ',
        'Yu ','Chou ','Si ','Su ','I ','Shuku ','Shi ','Chou ','Chou ','Niku ','Yi ','Roku ','Ki ','Qiu ','Kou ','Cao ',
        'Ge ','Di ','Huan ','Kou ','Yi ','Ren ','Shou ','Ru ','Chuu ','Yuan ','To ','Kou ','Yuu ','Kan ','Sa ','Wo ',
        'Chang ','Ko ','Shi ','Han ','Fu ','Hi ','Fun ','Hai ','Pang ','Ken ','Bou ','Shun ','Yuu ','Dotsu ','Hang ','Kou ',
        'Ran ','Kou ','Iku ','Wen ','Kou ','Jin ','Pi ','Qian ','Kitsu ','Hi ','Hai ','Ken ','Jing ','Tai ','Shen ','Zhong ',
        'Zhang ','Xie ','Shen ','I ','Chuu ','Die ','Tan ','Fei ','Hatsu ','Bo ','Ku ','Tian ','Hai ','Ko ','Tai ','Shi ',
        'Ku ','Zhi ','Dei ','Ping ','Shi ','Hu ','Han ','Shin ','Ken ','So ','Hai ','Kou ','Sheng ','Chi ','Hou ','Mu ',
        'Kyo ','Ko ','Ke ','Yi ','In ','Sho ','Yang ','Long ','Dong ','Ka ','Lu ','Jing ','Nu ','In ','Hou ','Ko ',
        'I ','Kou ','Kai ','Kaku ','Dou ','Zhi ','Kou ','Xiong ','Kyou ','Ji ','Atsu ','Xing ','Hen ','Nou ','Shi ','',
        ],
    'x81':[
        'Cheng ','Tiao ','Shi ','Zei ','Mei ','Kyou ','Zei ','Kyou ','Myaku ','Myaku ','Seki ','Kyou ','Nin ','Kuai ','Sa ','Zang ',
        'Qi ','Nao ','Mi ','Nong ','Luan ','Wan ','Hotsu ','Bun ','Kan ','Qiu ','Kyaku ','Kei ','Ju ','Heng ','Sa ','Lie ',
        'Sen ','Ting ','Mei ','Shin ','Shin ','Qian ','Te ','Sai ','Cu ','Shuu ','Xin ','Datsu ','Hou ','Cheng ','Nei ','Ho ',
        'Tou ','Datsu ','Niao ','Nou ','Pi ','Ko ','Gua ','Li ','Lian ','Chou ','Zei ','Jie ','Ryou ','Zhou ','Hi ','Biao ',
        'Lun ','Hen ','Guo ','Kui ','Chui ','Tan ','Ten ','Dai ','Jing ','Jie ','Seki ','Eki ','You ','Ren ','Jin ','Chuo ',
        'Fu ','Fu ','Kyo ','Hi ','Kou ','Wan ','Dong ','Hi ','Kaku ','Zong ','Ding ','Wu ','Mei ','Ruan ','Zhuan ','Chitsu ',
        'Sou ','Ra ','Ou ','Di ','An ','Sei ','Nou ','Shu ','Sen ','Dan ','Yun ','Shou ','Rou ','Gaku ','Sai ','Totsu ',
        'You ','Ken ','Wei ','Jiao ','Yu ','Jia ','Duan ','Hyoku ','Chou ','Fuku ','Sen ','Ni ','Mian ','Otsu ','Teng ','Tai ',
        'Hou ','Ken ','Ryo ','Otsu ','Shuu ','Tou ','So ','Zhui ','Kaku ','Yi ','Haku ','Ryou ','Seki ','Pi ','Kai ','Kou ',
        'Ryo ','Bin ','','Chou ','Lu ','Kaku ','Hou ','Chuai ','Hyou ','Jiang ','Fu ','Tou ','Maku ','Shitsu ','Sen ','Lu ',
        'Kou ','Ying ','Rou ','Chitsu ','Tara ','Chun ','Lian ','Tong ','Bou ','Ji ','Zha ','Liao ','Cui ','Gui ','Kyou ','Teng ',
        'Han ','Zhi ','Shou ','Sen ','Ko ','Sui ','Run ','Xiang ','Zui ','Fen ','You ','Tan ','Zhua ','Tan ','Kai ','Dou ',
        'Den ','Lian ','Hi ','You ','Jue ','Shoku ','Oku ','Juan ','Rou ','Ren ','Sou ','Den ','Gu ','Sei ','Sui ','Hin ',
        'Xun ','Dau ','Huo ','Zou ','Xian ','Hyou ','Xing ','Kon ','Rou ','En ','Ryo ','Koku ','Zang ','Ra ','Ku ','Zou ',
        'Ren ','Dei ','Zang ','Shin ','Kan ','Ga ','Guang ','Zou ','Rin ','Guang ','Shi ','Kyou ','Nie ','Shuu ','Ji ','Gao ',
        'Shuu ','Ben ','Getsu ','Shi ','Chi ','Kaku ','Sen ','Die ','Jitsu ','Shuu ','Tai ','Shin ','Kyuu ','Kan ','Yu ','Sou ',
        ],
    'x82':[
        'You ','Yo ','Shou ','Shaku ','Shaku ','Kyuu ','Yu ','Yo ','Kyou ','Kyo ','Kyuu ','Xin ','Zetsu ','Sha ','Sha ','Kyuu ',
        'Shi ','Tan ','Jo ','Shi ','Ten ','Dan ','Ho ','Ho ','Kan ','Kuu ','Ten ','Sen ','Shun ','Katsu ','Bu ','Shuu ',
        'Dao ','Kou ','San ','Yi ','','Pa ','Tai ','Fan ','Han ','Sen ','Kou ','Hou ','Han ','Que ','Ro ','Zhong ',
        'Jian ','Cang ','Rei ','Chiku ','Taku ','Ta ','Haku ','Ken ','Ka ','Sen ','Kou ','Lu ','Hong ','Pang ','Xi ','',
        'Fu ','Zao ','Feng ','Ri ','Sou ','Yo ','Rou ','Tei ','','Wei ','Bo ','Mou ','Nian ','Ju ','Kou ','Shuu ',
        'Zong ','Hen ','Mao ','Die ','Dou6','Bang ','Sa ','Yi ','Sou ','Sou ','Sou ','Lou ','Tai ','Sori ','Yao ','Dou ',
        'Tou ','Dang ','Shou ','Ro ','Gi ','Jie ','Kan ','Waku ','Mou ','Qi ','Ro ','Ro ','Chan ','Sou ','Kon ','Ryou ',
        'Jian ','Kan ','Shoku ','Yan ','Hotsu ','Ping ','En ','En ','Sou ','','Yi ','Roku ','Ting ','Kyuu ','Gai ','Jou ',
        'Shou ','Kou ','Jie ','Hou ','Kan ','Yi ','Chai ','Ben ','Ba ','Kai ','Sen ','U ','Yu ','Shaku ','Kyuu ','Tu ',
        'Xia ','Ki ','Bou ','Zi ','Ki ','Sui ','Chi ','Xiang ','Hi ','Fu ','Ton ','I ','Wu ','Shi ','Qi ','San ',
        'Bun ','Ken ','Ren ','Huu ','Kou ','Kai ','Ro ','Cho ','Kyuu ','Kin ','Ki ','Gen ','Fun ','Ba ','Zei ','Shin ',
        'Ki ','Ka ','Kuwa ','Hou ','Butsu ','Jue ','Gou ','Shi ','Gei ','Kin ','Ou ','Suu ','Bou ','Ga ','Hi ','Jou ',
        'Hang ','Cong ','Yin ','You ','Bian ','Gai ','Susa ','Wei ','Li ','Pi ','E ','Xian ','Chang ','Cang ','Meng ','Su ',
        'Tei ','En ','Zen ','Rei ','Tai ','Chou ','Di ','Byou ','Qiong ','Ryuu ','You ','Ka ','Boku ','Pei ','Hou ','Kou ',
        'Bin ','I ','I ','Kyo ','Hi ','Jaku ','Ku ','Cho ','Dei ','Bo ','Hei ','Sen ','Qiu ','You ','Xian ','Hon ',
        'Hong ','Ei ','Zha ','Tou ','So ','Die ','Detsu ','Kan ','Hu ','Hei ','Mai ','Fu ','Sheng ','Ko ','Hitsu ','Wei ',
        ],
    'x83':[
        'Hutsu ','Satsu ','Mo ','Han ','Ka ','Bou ','Bou ','Hatsu ','Shi ','Matsu ','Shi ','Shi ','Chi ','Kyoku ','Kei ','Long ',
        '','Niao ','','Xue ','Ying ','Qiong ','Kaku ','Mei ','Ri ','Rong ','Yin ','Kon ','Sen ','Sai ','Shin ','Itsu ',
        'Xiu ','U ','Retsu ','Go ','Ji ','Gui ','Ce ','Chong ','Shi ','Gou ','Guang ','Bou ','Shi ','Keki ','Shou ','Fuku ',
        'Yu ','Shu ','Ji ','Kou ','Kai ','In ','Cha ','Hai ','Jou ','Jo ','Shuu ','Mang ','Tou ','Chuu ','','Zhu ',
        'Jun ','Huan ','Ka ','Sen ','Kai ','Tou ','Kei ','Kou ','Chuan ','Sou ','Kei ','Er ','An ','Kyou ','Chi ','Jin ',
        'Sen ','Tei ','Kou ','Hei ','Ri ','Kin ','Hou ','Shoku ','Sou ','Da ','Jia ','Rao ','Bi ','Ze ','Qiao ','Hui ',
        'Qi ','Dang ','','Rong ','Hun ','Ying ','Luo ','Ying ','Xun ','Jin ','Sun ','Yin ','Mai ','Hong ','Zhou ','Yao ',
        'To ','Wei ','Chu ','Tou ','Fu ','Jin ','Yin ','Ka ','Hotsu ','Bu ','Yun ','Teki ','To ','I ','Sui ','Sei ',
        'Shin ','Wu ','Hetsu ','Xi ','Kou ','Ri ','Hu ','Cho ','Mo ','Chi ','Sou ','Ji ','Duo ','Kyuu ','Sa ','Suo ',
        'Chen ','Feng ','Kyo ','Mai ','Mou ','Kou ','Kei ','Che ','Shin ','Kin ','En ','Tei ','Teki ','Sa ','Kan ','Kan ',
        'Yuu ','Cuo ','Kyou ','Wang ','You ','Niu ','Sou ','Kan ','Rou ','Hu ','Ga ','Bo ','Bun ','Setsu ','Nan ','Mu ',
        'Kan ','Rai ','Lian ','Shi ','Wo ','To ','Lian ','Huo ','You ','Ying ','Ying ','Nuc ','Chun ','Bou ','Mou ','Shi ',
        'En ','Sei ','Di ','Qu ','Dong ','Kan ','Zou ','Ko ','La ','Ryoku ','Kiku ','Wei ','Kin ','Nie ','Kon ','Ka ',
        'Hoku ','Shi ','Gao ','Ka ','Hoku ','Lun ','Shou ','Chou ','Suu ','Chui ','Zhan ','Men ','Sai ','Hatsu ','Li ','To ',
        'Ha ','Han ','Bao ','Qin ','Juan ','Xi ','Qin ','Di ','Shou ','Hai ','Tou ','Kin ','Zhao ','Tai ','Geng ','Ka ',
        'Ko ','Ryou ','Hi ','Jin ','An ','Wang ','Hou ','Sou ','En ','Sho ','Jian ','Rin ','Tan ','Shuku ','Tian ','Dao ',
        ],
    'x84':[
        'Hu ','Ki ','He ','Sui ','Tou ','Shun ','Hi ','Chou ','Huan ','Fei ','Rai ','Sei ','Hou ','Hei ','I ','Tan ',
        'Sha ','Kan ','Yan ','Gi ','Tiao ','Sei ','Wan ','Ce ','Nai ','Kutabireru ','Tuo ','Kyuu ','Tie ','Luo ','','',
        'Hou ','','Yaji ','','Ying ','Ying ','Ying ','Xiao ','Sa ','Shuu ','Kuwa ','Xiang ','Man ','Yu ','Yu ','Huu ',
        'Lian ','Ken ','Yuan ','Nan ','Ze ','Wa ','Chun ','Xiao ','Yu ','Hen ','Mao ','An ','Gaku ','Raku ','Ying ','Huo ',
        'Gua ','Jiang ','Mian ','Zuo ','Zuo ','Sho ','Ho ','Juu ','Shi ','You ','An ','Qu ','Jian ','Huku ','Ritsu ','Sen ',
        'Pen ','Hou ','Kou ','Hong ','Hou ','Yan ','Totsu ','Cho ','Shi ','Shou ','Chin ','Katsu ','Katsu ','Jing ','Mi ','Huang ',
        'Shin ','Ho ','Gai ','Tou ','Chuu ','Sen ','I ','Hotsu ','Wei ','Ha ','Kei ','Ko ','Sou ','Ka ','Tan ','Yaku ',
        'Sui ','Sou ','Quan ','I ','Shin ','Ki ','Tei ','Gun ','Sai ','Shi ','Shuu ','Lan ','Sou ','You ','Yuan ','Mei ',
        'Yun ','Shutsu ','Tei ','Zhuan ','Kan ','Sukumo ','Xue ','Chan ','Kai ','Kui ','','Shou ','Lou ','Wei ','Pai ','',
        'Shuu ','Yin ','Shi ','Jun ','Shi ','Un ','Shin ','Lang ','Nu ','Bou ','He ','Que ','San ','Yuan ','Ri ','Kon ',
        'Xi ','Hou ','Chu ','Xu ','Tu ','Liu ','Waku ','Zhen ','Sen ','So ','Haku ','Cuo ','Yuan ','Suu ','Yu ','Kai ',
        'Pan ','Ho ','Ho ','Na ','Saku ','Xi ','Fen ','Yun ','Jou ','Ken ','Shitsu ','Jaku ','Sou ','On ','Bei ','Kou ',
        'Son ','Shin ','Mei ','Huo ','Chiku ','Liu ','Seki ','Kotsu ','Kou ','You ','Ou ','Gai ','Sa ','Shi ','Tang ','Ra ',
        'Joku ','Sa ','Xian ','Hai ','Yao ','Gui ','Hi ','Zong ','Gun ','Za ','Chou ','Ce ','Hai ','Lan ','','Ji ',
        'Li ','Can ','Lang ','Yu ','','Ying ','Mo ','Shou ','Tiao ','Mao ','Tou ','Zhu ','Hou ','An ','Ren ','Sou ',
        'Shi ','Hei ','Kyuu ','Jin ','Shun ','Jie ','Wei ','Tai ','Cao ','Yu ','Gei ','Shuu ','Ryou ','Hitsu ','Lu ','Shuku ',
        ],
    'x85':[
        'Hou ','Zhang ','Rui ','Kyou ','Man ','Yan ','Ryou ','Kike ','Piao ','Gun ','Han ','Di ','Soku ','Lu ','Setsu ','Shou ',
        'Teki ','Betsu ','Xun ','Ban ','Fuku ','Tei ','Cuo ','Sho ','Shin ','Xuan ','Utsu ','Hu ','Gou ','Mi ','Rou ','Zoku ',
        'Zhong ','Sai ','Ha ','Shou ','Bitsu ','Sou ','Chou ','Sei ','Jun ','Yin ','Sen ','En ','So ','In ','Kui ','Chin ',
        'Hu ','Sha ','Kou ','Sen ','Ma ','Zou ','Sonoko ','Qiang ','Dou ','Lian ','Lin ','Kou ','Ai ','Hei ','Li ','I ',
        'Kyoku ','Jin ','Sheng ','Ban ','Meng ','Ou ','Ten ','Dian ','Shin ','Shou ','Zui ','Zui ','Lei ','Yu ','Kyou ','Cho ',
        'Kuwa ','Kan ','Bai ','Un ','Bao ','Yuu ','Kyo ','Ro ','Jou ','Kei ','Gaku ','Teng ','Hi ','Setsu ','Sai ','Hitsu ',
        'Jo ','Hun ','Kai ','Shun ','Zui ','Ya ','Xu ','Fu ','Ketsu ','Tou ','Bu ','Tou ','Si ','Shou ','Xi ','Rou ',
        'Un ','','Qi ','Kan ','Yun ','Sun ','Ling ','Yo ','Xia ','You ','Shuu ','Kou ','Si ','Dou ','Rai ','Ken ',
        'Un ','Iku ','Xi ','Hao ','Haku ','Kou ','Ai ','Bi ','Kai ','Wai ','Kei ','Shi ','Kyou ','Luan ','Mie ','Yoku ',
        'Rou ','Kyou ','Can ','Shin ','Shoku ','Lian ','Ke ','En ','Tatsu ','Tei ','Tang ','Setsu ','Heki ','Sen ','Sun ','Ren ',
        'Han ','Ding ','Kai ','Gu ','Kai ','Shoku ','Sen ','Kou ','Kou ','Satsu ','Shin ','Kun ','Yaku ','Hai ','Sou ','Sho ',
        'Kun ','Dui ','Pin ','Wei ','Nou ','Chou ','Bai ','Ju ','Hyou ','Tai ','Sei ','Zao ','Chin ','Shin ','Shi ','Gi ',
        'Ying ','Kou ','Sou ','Xiao ','Qi ','Fa ','Jian ','Sho ','Kui ','Sha ','Hen ','Chou ','Mi ','Ran ','Shin ','Zou ',
        'Baku ','Qiong ','Qie ','Xian ','','Guu ','Xian ','Su ','Ryo ','Yi ','Shoku ','Xie ','Rei ','Gei ','La ','Rui ',
        'Kyou ','Di ','Zhi ','Bei ','Tou ','Yaku ','Ba ','Huan ','Hyou ','Han ','Sou ','Tan ','Tui ','Kyuu ','Qiao ','Wei ',
        'Liu ','Hui ','','Kou ','Un ','','Reki ','Sho ','Chu ','Ai ','Rin ','Sou ','Ken ','Chen ','Rai ','Kaku ',
        ],
    'x86':[
        'Taku ','Wu ','Zui ','Rui ','Ki ','Kou ','Ro ','So ','Tui ','Mang ','Un ','Hin ','Yu ','Kun ','Ki ','Kei ',
        'Ken ','Ma ','Hagi ','So ','Jiong ','','Getsu ','Haku ','Jou ','Ei ','Sen ','Iku ','Ju ','Lian ','Ren ','Yin ',
        'Qiang ','Ou ','Rou ','Tong ','Wei ','Yue ','Ling ','Ku ','Yao ','Han ','Mi ','Lan ','Kui ','Ran ','Ji ','Tou ',
        'Katsura ','Lei ','Lei ','Hua ','Feng ','Zhi ','Gi ','Kui ','San ','Huai ','Ri ','Ji ','Bi ','Ryuu ','Huai ','Ra ',
        'Sei ','Ki ','Ro ','Jian ','San ','','Rui ','Quan ','Kyou ','Yi ','Luan ','Men ','Bie ','Ko ','Ko ','Lu ',
        'Gyaku ','Lu ','Shi ','Kou ','Ken ','Sho ','Ko ','Kyo ','Sa ','Huku ','Kyo ','Kyo ','Ryo ','Ko ','Gu ','Gou ',
        'Kou ','Kyo ','Hou ','Hou ','Gan ','Zhan ','Zhan ','Ki ','Ban ','Keki ','Shu ','Chuu ','Kyuu ','Diao ','Ji ','Kyuu ',
        'Cheng ','Shitsu ','','Di ','Zhe ','Sha ','U ','Kan ','Zi ','Kou ','Ki ','Bou ','Ge ','Sui ','Xia ','Chai ',
        'Shi ','Yi ','Ma ','Xiang ','Fang ','E ','Pa ','Chi ','Ken ','Bun ','Bun ','Zei ','Hou ','Hi ','Yue ','Yue ',
        'Jun ','Ki ','Tong ','In ','Qi ','San ','Gen ','Jue ','Kai ','Qin ','Ki ','Zhong ','Ka ','Ci ','Mu ','Wang ',
        'Fen ','Hun ','Hang ','Kou ','Sou ','Fu ','Zen ','Kai ','Hu ','Shi ','Tou ','Hou ','Xian ','Ji ','Te ','Kyuu ',
        'Yuu ','Saku ','Ping ','Chi ','Yuu ','Ka ','Kan ','Kyo ','Reki ','Hu ','Ran ','Zha ','Gou ','Pi ','Bo ','Ken ',
        'Shu ','Chou ','Bie ','Hei ','Ko ','Zen ','Sho ','Ja ','Tie ','Rei ','Gu ','Tan ','Gu ','Kei ','Rei ','Cheng ',
        'Qu ','Bou ','Kaku ','Ci ','Kai ','Kai ','Mang ','Huu ','Yang ','A ','Retsu ','Shu ','I ','Xian ','Katsu ','Kou ',
        'Rei ','Yi ','Ping ','Kitsu ','Kou ','Setsu ','Yi ','Bou ','Mo ','Kyou ','Qie ','Gui ','Kyou ','Shitsu ','Ban ','Ebi ',
        'Zhi ','Jia ','Rao ','Si ','Qi ','Xing ','Lie ','Qiu ','Sou ','You ','Kyou ','Zei ','Sha ','Bai ','Ga ','Han ',
        ],
    'x87':[
        'Shoku ','Xuan ','Hou ','Shin ','Shin ','Hu ','Ken ','Tetsu ','Go ','Fu ','Ri ','Rou ','Bi ','Sho ','En ','Yuu ',
        'Kyou ','Tan ','En ','Ten ','Ten ','Zei ','Kai ','Gua ','Chi ','Shou ','Hi ','Ju ','Mitsu ','Qi ','Ki ','Iku ',
        'Jun ','Sho ','Meng ','Kyou ','Si ','Seki ','Lun ','Li ','Shou ','Chou ','Tao ','Kun ','Gan ','Han ','Yoku ','Hou ',
        'Fei ','Hi ','I ','Dun ','Eki ','Yuan ','Su ','Ken ','Qian ','Zei ','Gei ','Sei ','I ','Ryou ','Ka ','En ',
        'Tou ','E ','Ban ','Tei ','Wang ','San ','Yang ','Ying ','Guo ','Sen ','','Rou ','Ka ','Soku ','Katsu ','Ting ',
        'Mai ','Xu ','Mian ','Yu ','Jie ','Shoku ','Xuan ','Kou ','En ','Hen ','Rou ','Wei ','Fu ','En ','Mei ','I ',
        'Fuku ','Zen ','Xie ','Yuu ','Shuu ','Bou ','Ka ','Ying ','Shitsu ','Chong ','Tou ','Zhu ','Zong ','Ti ','Fuku ','En ',
        'Hui ','Mou ','Ratsu ','Du ','Ko ','Qiu ','Chou ','Li ','Ka ','Yun ','Ju ','Nan ','Lou ','Qun ','Rong ','You ',
        'Jiang ','','Rou ','Hou ','Shi ','Shi ','Shi ','Kei ','Gen ','O ','Lian ','Shuu ','Han ','Yuu ','Rong ','Ji ',
        'O ','Qiu ','Han ','Shin ','Yi ','Hei ','Hua ','Tou ','Gi ','Du ','Nai ','He ','Hu ','Hui ','Ba ','Mei ',
        'I ','Wen ','Kei ','Tou ','Yu ','Cang ','So ','Ebi ','Man ','','Shang ','Seki ','Sou ','Chi ','Tei ','Gou ',
        'Lu ','I ','Zhi ','Tou ','Chen ','Hyou ','Qu ','Pi ','Yu ','Jian ','Ra ','Rou ','Qin ','Shuu ','In ','Shou ',
        'Shutsu ','Bun ','Jiao ','Wan ','Chitsu ','Zhe ','Ba ','Ba ','Kaku ','Ryuu ','Bou ','Shitsu ','Cong ','Li ','Dani ','Xiao ',
        'Tou ','Zhang ','Bou ','Xiang ','Mo ','Sui ','Shi ','Qiu ','Te ','Shoku ','Hou ','Peng ','Kyou ','Qu ','Bie ','Ryou ',
        'Han ','Gui ','Ki ','Ki ','Sen ','Huang ','Fei ','Lao ','Jue ','Jue ','Kei ','In ','Sen ','Shou ','Shan ','Gyou ',
        'Xiao ','Bou ','Ki ','Jin ','Si ','','Tei ','Tou ','Rei ','Kai ','Sen ','Gi ','Jing ','Da ','Sen ','Kei ',
        ],
    'x88':[
        'Ci ','Kyou ','She ','Ra ','Qin ','You ','Tai ','Li ','Ze ','Ken ','Ren ','Shoku ','Ze ','Katsu ','Bou ','Kai ',
        'Sei ','Ei ','Ken ','Bou ','Kou ','Da ','Kaku ','Zhuo ','Setsu ','Hen ','Kaku ','Betsu ','Han ','Lei ','Setsu ','Rou ',
        'Mi ','Rei ','Shun ','Rei ','Qiu ','Nie ','Lu ','To ','Shou ','Zhu ','Long ','Li ','Long ','Hou ','Etsu ','Beng ',
        'Shou ','Ko ','Ken ','Ying ','','Kei ','San ','Qu ','Quan ','To ','San ','Ban ','Kyaku ','Jie ','Zhu ','Zha ',
        'Ketsu ','Kou ','Jiku ','Hai ','Jiku ','Kin ','Shuu ','Mo ','Ji ','Kaku ','Betsu ','Kyoku ','Kou ','En ','Kan ','Yuan ',
        '','Rei ','Ken ','Jutsu ','Xian ','Tou ','Kou ','Gai ','Kan ','Gyo ','Ko ','Ei ','Dou ','Shou ','Ei ','Dou ',
        'Shun ','Kou ','Ku ','I ','Koromohen ','Bu ','Kan ','Yu ','Hyou ','Sai ','Yi ','San ','Chen ','Fu ','Kon ','Fen ',
        'Sa ','Kyou ','Dou ','Zhong ','Dan ','Jitsu ','Zhong ','Chuu ','Xie ','Ki ','Xie ','Zen ','Zhi ','Jin ','Kin ','Kin ',
        'Kin ','En ','Bei ','Chai ','Ao ','Niao ','Hui ','Ran ','Ka ','Tuo ','Ling ','Tai ','Bao ','Hou ','Yao ','Zuo ',
        'Bi ','Shao ','Tan ','Ju ','He ','Shu ','Shuu ','Shin ','I ','Ha ','Hatsu ','Tei ','Batsu ','Fu ','Kon ','Chitsu ',
        'Chitsu ','Ran ','Han ','Yi ','Bou ','','Na ','Kou ','Ken ','Chan ','Kyo ','Hi ','Gun ','Xi ','Ne ','Bo ',
        'Horo ','Fuku ','Yi ','Shi ','Ko ','Jin ','Jiang ','Kou ','Cun ','Mo ','Ketsu ','Er ','Luo ','Jo ','Chu ','Kei ',
        'In ','Sai ','Retsu ','Kamishimo ','Yuki ','Sou ','Dang ','Seot ','Kon ','Ken ','Jou ','Shu ','Kou ','Kon ','Tei ','Ri ',
        'Juan ','Shin ','Hou ','Koku ','Ei ','Yuu ','Zhen ','Liu ','Kyuu ','Kun ','Ji ','Youu ','Ho ','Sou ','Sei ','Sa ',
        'Qun ','Ri ','Lian ','Lian ','Ku ','Jian ','Fou ','Sen ','Hi ','Gun ','Tau ','Yuan ','Ling ','Chi ','Chang ','Chuu ',
        'Tatsu ','Hyou ','Ryou ','Shou ','Hai ','Hai ','Fei ','En ','Ra ','Ka ','Yan ','Du ','Seki ','Sei ','Kyo ','Qi ',
        ],
    'x89':[
        'Ji ','Seki ','Kai ','Ken ','Tsuma ','Ti ','Shi ','Fuku ','Chong ','Xie ','Hen ','Die ','Kon ','Tan ','Shuu ','Yuu ',
        'Katsu ','Yuan ','Hou ','Ho ','Fu ','Yu ','Tan ','Yan ','I ','Hai ','Cho ','Lu ','Ena ','Tan ','On ','Da ',
        'Kou ','Da ','Huai ','Rong ','Yuan ','Joku ','Dai ','Kei ','Sa ','Ban ','Tai ','Chi ','Sang ','Niao ','Ying ','Jie ',
        'Ken ','Kaie ','Ko ','Lian ','Bao ','Ri ','Chou ','Shi ','Rou ','Gei ','Chou ','Setsu ','Xian ','Wei ','Hyou ','Cao ',
        'Seki ','Kyou ','Shin ','Hou ','Jou ','Chihaya ','Hoku ','Jian ','Zhuan ','Kan ','Zui ','Ji ','Tan ','Zatsu ','Fan ','Hatsu ',
        'Xiang ','Xin ','Hetsu ','Rao ','Man ','Ran ','Ou ','Taku ','Gui ','Cao ','Sui ','Jou ','Sen ','Lian ','Heki ','Kin ',
        'Tou ','Shoku ','Tan ','Hi ','Ran ','Pu ','Ju ','Zhi ','','Shu ','Betsu ','Seki ','Bai ','Ketsu ','Haku ','Shin ',
        'Rai ','Long ','Shuu ','Sen ','Ran ','Shou ','Dai ','Tasuki ','Zan ','Shi ','Ken ','Han ','Gei ','Ran ','Aka ','Sei ',
        'Xi ','You ','Feng ','Tan ','','Biao ','Fuku ','Ha ','Kaku ','Ki ','Ki ','Ken ','Kan ','Hen ','Yan ','Ki ',
        'Kaku ','Pian ','Mao ','Beki ','Eki ','Betsu ','Shi ','Shi ','Ten ','Ra ','Kaku ','Biki ','Chou ','Lian ','Yao ','Shi ',
        'Kin ','Geki ','Shan ','Wei ','Xi ','Ten ','Yu ','Ran ','E ','To ','Shin ','Pang ','Ki ','Ming ','Ying ','Kou ',
        'So ','Zhan ','Kin ','Kan ','Tou ','Kan ','Ra ','Shu ','Kan ','Wei ','Kaku ','Qu ','Ra ','Ran ','Shen ','Teki ',
        'Kan ','Jian ','Guan ','Yan ','Gui ','Mi ','Shi ','Zhan ','Lan ','Jue ','Ji ','Xi ','Di ','Tian ','Yu ','Gou ',
        'Jin ','Qu ','Kaku ','Jiu ','Kin ','So ','Ketsu ','Shi ','Sou ','Ji ','Ko ','Dan ','Shi ','Tei ','Shang ','Hua ',
        'Quan ','Ge ','Chi ','Kai ','Gui ','Kou ','Shoku ','Kai ','Hun ','Kyuu ','Xing ','Soku ','Ni ','Ki ','Lu ','Zhi ',
        'Zha ','Hitsu ','Xing ','Koku ','Shou ','Gong ','Shi ','Xue ','Shoku ','Kei ','Yi ','Lu ','Jue ','Kei ','Yan ','Kei ',
        ],
    'x8a':[
        'Gen ','Gonben ','Tei ','Fu ','Kyuu ','Kyuu ','Jiao ','Kou ','Kei ','Fan ','Jin ','Diao ','Kou ','Cha ','Tou ','Ku ',
        'Ketsu ','Shi ','Jin ','Kun ','Gin ','San ','Kitsu ','Taku ','Ki ','Xun ','Yin ','Ka ','Fen ','Ga ','You ','Shou ',
        'Shin ','Yin ','Kin ','Ketsu ','Kon ','Totsu ','Shin ','You ','Zhi ','Xiong ','Hou ','Shin ','Sou ','Setsu ','Xian ','Sa ',
        'Tun ','Kyo ','Yi ','Yaku ','So ','Chi ','Ka ','Shin ','He ','Xu ','Shin ','Chuu ','Shou ','Kou ','Shi ','Zi ',
        'Tan ','Ko ','Fu ','Ken ','Die ','Rei ','Tei ','You ','Ri ','Dou ','Pan ','Zhou ','Gan ','Ei ','Kyo ','Ao ',
        'Sa ','Ta ','Tai ','Kyo ','Shou ','Hyou ','Hi ','Kyou ','Kutsu ','Ba ','Da ','So ','Tou ','Cho ','Shi ','Zhe ',
        'Ei ','Ku ','Jun ','Kei ','Huang ','Kou ','Shi ','Satsu ','Jiao ','Shi ','Hen ','Ta ','Kou ','Ki ','Sen ','Hui ',
        'Kitsu ','Wa ','Gai ','Shou ','Wei ','Shin ','Shuu ','Tou ','Mi ','Sen ','Bii ','Gaku ','Kai ','Yan ','Kyou ','Kai ',
        'Ji ','Beng ','Chou ','Shi ','Rui ','Chuu ','Kyou ','Ko ','Wu ','Yo ','Teng ','Ki ','Shi ','Nin ','Su ','Rou ',
        'Ga ','Kyou ','Ki ','Sei ','Ting ','Tan ','Hotsu ','Ten ','Yuu ','Kou ','Shou ','Qin ','Shua ','An ','Go ','Kou ',
        'Sei ','Kai ','Xian ','Fu ','Go ','Kou ','Shou ','Ho ','Kai ','Kei ','Setsu ','Zhen ','Setsu ','Toku ','Yasashi ','Shou ',
        'Sui ','Jie ','Ka ','Kutsu ','Cong ','Xiao ','Sui ','Bou ','Xuan ','Hi ','Chi ','Tou ','Gi ','Na ','Gin ','Chou ',
        'Pi ','Chuo ','Ten ','Chin ','Jun ','Ji ','Ki ','Dan ','Sui ','Zui ','Kiku ','Sei ','Kan ','Sou ','Ze ','Shu ',
        'Qian ','Taku ','Ryou ','Sen ','Shuku ','Kou ','Ron ','Shin ','Biao ','Huai ','Jou ','Yu ','Chou ','Sho ','Hen ','Shi ',
        'Ken ','Shi ','Kon ','Hua ','Gaku ','Zhong ','Tei ','Kai ','Fu ','Pu ','Ting ','Kan ','Kei ','Yu ','Shi ','Chuan ',
        'Shi ','Ki ','Yin ','An ','Kan ','Nan ','Shin ','Fuu ','Sho ','Yang ','Gen ','Heng ','Ken ','Ge ','Daku ','Shuu ',
        ],
    'x8b':[
        'Bou ','Etsu ','I ','','Tou ','Sou ','Sen ','Ken ','Bo ','','Kou ','Kaku ','Ka ','Ying ','Mei ','Xiao ',
        'Hitsu ','Kei ','Qiang ','Chen ','Gyaku ','Ti ','Shoku ','Bou ','Chi ','Ken ','Shi ','Kou ','Gen ','Sha ','Kaku ','Tou ',
        'You ','You ','','Yu ','Biao ','Cong ','Kei ','Li ','Bo ','Mo ','Shang ','Taku ','Byou ','Sei ','Ze ','Jie ',
        'Ren ','Lou ','Can ','Ou ','Guan ','Xi ','Zhuo ','Gyou ','Ao ','Kin ','Zhe ','Yi ','Ko ','Jiang ','Ban ','Chao ',
        'Han ','Ka ','Sen ','Ku ','Sou ','Shuu ','Ki ','She ','Tai ','Shou ','Nao ','Lan ','Ka ','You ','Kitsu ','Ki ',
        'Zun ','Jiao ','Ha ','Kei ','Sen ','Mu ','Shin ','Zha ','Shiki ','Shou ','Tan ','Shin ','Fu ','Sheng ','Ken ','Sou ',
        'Tan ','Dang ','Sui ','Sen ','Ji ','Jiao ','Kei ','Lian ','Nou ','Yi ','Ai ','Sen ','Hi ','Ki ','Hua ','Yaku ',
        'Gi ','Zen ','Jou ','Nou ','Ken ','Zhui ','Tou ','Go ','Chuu ','Kou ','Ye ','Ying ','Kan ','Yo ','Sen ','Hui ',
        'Toku ','Taku ','Xuan ','San ','Ru ','Shin ','Ei ','Chan ','Li ','Yi ','Hen ','Shou ','En ','Gaku ','Shuu ','Ei ',
        'Shuu ','Yao ','San ','Jou ','In ','Ran ','Shin ','Huo ','Zhe ','Kan ','San ','Yi ','Tou ','Zhan ','Getsu ','Toku ',
        'Yan ','Ji ','Ding ','Fu ','Ren ','Ji ','Jie ','Hong ','Tao ','Rang ','Shan ','Qi ','Taku ','Xun ','Yi ','Xun ',
        'Ji ','Ren ','Jiang ','Hui ','Ou ','Ju ','Ya ','Ne ','Xu ','E ','Lun ','Xiong ','Song ','Feng ','She ','Fang ',
        'Jue ','Zheng ','Gu ','He ','Ping ','Zu ','Shi ','Xiong ','Zha ','Su ','Zhen ','Di ','Zou ','Ci ','Qu ','Zhao ',
        'Bi ','Yi ','Yi ','Kuang ','Lei ','Shi ','Gua ','Shi ','Jie ','Hui ','Cheng ','Zhu ','Shen ','Hua ','Dan ','Gou ',
        'Quan ','Gui ','Xun ','Yi ','Zheng ','Gai ','Xiang ','Cha ','Hun ','Xu ','Zhou ','Jie ','Wu ','Yu ','Qiao ','Wu ',
        'Gao ','You ','Hui ','Kuang ','Shuo ','Song ','Ai ','Qing ','Zhu ','Zou ','Nuo ','Du ','Zhuo ','Fei ','Ke ','Wei ',
        ],
    'x8c':[
        'Yu ','Shui ','Shen ','Diao ','Chan ','Liang ','Zhun ','Sui ','Tan ','Shen ','Yi ','Mou ','Chen ','Die ','Huang ','Jian ',
        'Xie ','Nue ','Ye ','Wei ','E ','Yu ','Xuan ','Chan ','Zi ','An ','Yan ','Di ','Mi ','Pian ','Xu ','Mo ',
        'Dang ','Su ','Xie ','Yao ','Bang ','Shi ','Qian ','Mi ','Jin ','Man ','Zhe ','Jian ','Miu ','Tan ','Zen ','Qiao ',
        'Lan ','Pu ','Jue ','Yan ','Qian ','Zhan ','Chen ','Koku ','Sen ','Kou ','Ka ','Jue ','Hong ','Kan ','Kou ','Kei ',
        'Xi ','Katsu ','Liao ','Han ','Du ','Rou ','Tou ','Kou ','Ki ','Shi ','Hou ','Tou ','En ','Bi ','Ju ','Kan ',
        'Hou ','Chitsu ','Zhi ','En ','En ','Shi ','Chu ','Ka ','Ton ','Gi ','Ton ','Eki ','Ken ','Ha ','Hou ','E ',
        'Cu ','Shou ','Ken ','Ken ','Kon ','Gai ','Kyo ','Fu ','Ki ','Hin ','Gou ','Yo ','Cho ','Ka ','Fen ','Xi ',
        'Bo ','Wen ','Huan ','Hin ','Di ','Sou ','Hun ','Yi ','Chi ','Hou ','Sai ','Kan ','Hi ','Na ','Hi ','Gou ',
        'Na ','You ','Chou ','Mo ','Si ','Kyuu ','Kan ','Kon ','He ','Kaku ','Haku ','Kan ','Bou ','Ri ','Gei ','Bi ',
        'Yu ','Jia ','Tan ','Byou ','Hi ','Xi ','E ','Ju ','Baku ','Chu ','Tan ','Kan ','Kyaku ','Bai ','Tei ','Yuan ',
        'Fu ','Zai ','Kou ','Te ','I ','Hang ','Wan ','Hin ','Ka ','Han ','Don ','Kan ','Seki ','Shitsu ','Ni ','Cho ',
        'Sei ','Bi ','Shi ','Ni ','Ki ','Pian ','Hen ','Bai ','Tai ','Sei ','Kyou ','Hi ','Ten ','I ','Chi ','Bou ',
        'Ga ','Hi ','Ro ','Chin ','Wai ','Kai ','Hen ','Shi ','Ko ','Shutsu ','Zoku ','Kou ','Gai ','Sou ','Sen ','Ei ',
        'Xun ','Shin ','Sha ','Hin ','Hin ','Kyuu ','Sha ','Chuan ','Zang ','Shuu ','Rai ','San ','Shi ','Chin ','Shou ','Tian ',
        'Bai ','Shoku ','Ken ','Bai ','Sen ','Sui ','Fu ','Tan ','Sou ','Cong ','Shitsu ','Ji ','Chou ','To ','Jin ','Kei ',
        'Shun ','Yun ','Hou ','Zai ','Rai ','Huu ','Cang ','Sei ','You ','Ai ','Tan ','Fu ','Kou ','Sai ','Saku ','Rou ',
        ],
    'x8d':[
        'Wei ','Hai ','Chen ','Wan ','Shi ','Zei ','Biao ','In ','Zou ','Tan ','San ','Gan ','','Sen ','Wan ','Ei ',
        'Shin ','Gan ','Ken ','Zou ','Hi ','Du ','Shoku ','Ken ','','Xuan ','Long ','Kou ','Zou ','Bei ','Zhen ','Fu ',
        'Yuan ','Gong ','Cai ','Ze ','Xian ','Bai ','Zhang ','Huo ','Zhi ','Fan ','Tan ','Pin ','Bian ','Gou ','Zhu ','Guan ',
        'Er ','Jian ','Bi ','Shi ','Tie ','Gui ','Kuang ','Dai ','Mao ','Fei ','He ','Yi ','Zei ','Zhi ','Jia ','Hui ',
        'Zi ','Ren ','Lu ','Zang ','Zi ','Gai ','Jin ','Qiu ','Zhen ','Lai ','She ','Fu ','Du ','Ji ','Shu ','Shang ',
        'Si ','Hi ','Zhou ','Geng ','Pei ','Tan ','Lai ','Feng ','Zhui ','Fu ','Zhuan ','Sai ','Ze ','Yan ','Zan ','In ',
        'Zeng ','Shan ','Ying ','Gan ','Seki ','Keki ','Sha ','Tan ','Xiong ','Kyoku ','Cheng ','Kaku ','Tei ','Sha ','Ka ','Tang ',
        'Sou ','Sou ','Li ','Kyuu ','Fu ','Zhao ','Gan ','Ki ','Shan ','Qiong ','Qin ','Xian ','Ci ','Jue ','Qin ','Chi ',
        'Ci ','Chin ','Chin ','Die ','Sho ','Chou ','Di ','Se ','Tan ','Zhu ','Etsu ','Qu ','Jie ','Chi ','Chu ','Gua ',
        'Ketsu ','Shi ','Tiao ','Duo ','Lie ','Kan ','Suo ','Cu ','Xi ','Chou ','Su ','Yin ','Ju ','Jian ','Shaku ','Tou ',
        'Taku ','Cui ','Lu ','Shu ','Dang ','Qiu ','Shi ','Ti ','Suu ','Chi ','Huang ','Kyou ','Kyou ','Yao ','Zao ','Kan ',
        '','Zan ','San ','Soku ','Pa ','Haku ','Ku ','Kotsu ','Dun ','Ketsu ','Fu ','Chin ','Gen ','Fang ','Shi ','Sa ',
        'Getsu ','Pa ','Ki ','Yue ','Qiang ','Taku ','Tai ','Ei ','Den ','Ling ','Bai ','Batsu ','Tetsu ','Ku ','Ta ','Ka ',
        'Ci ','Hou ','Qia ','Zhu ','Ku ','Chou ','Seki ','Fu ','Pan ','Sho ','San ','Ha ','Ni ','Kyo ','Li ','Kon ',
        'Yi ','Seki ','Dai ','Sen ','Kou ','Ta ','Zhu ','Sen ','Ko ','Zhuai ','Ki ','Kyou ','Ki ','Xiang ','Chi ','Ro ',
        'Hou ','Chi ','Kou ','Chou ','Sai ','Sen ','Ta ','Qiao ','Bi ','Xian ','Ta ','Ji ','Kyoku ','Ki ','Shu ','To ',
        ],
    'x8e':[
        'Chu ','Kei ','Nie ','Xiao ','Haku ','Tei ','Shun ','Mou ','Sho ','Ryou ','You ','Kyaku ','Chou ','Qiao ','Mau ','Tou ',
        'Sen ','Ki ','Wo ','Wei ','Tou ','Jie ','Seki ','Nie ','Ju ','Ju ','Lun ','Lu ','Leng ','Ka ','Kyo ','Chi ',
        'En ','Ken ','Teki ','Hou ','Zu ','Qie ','Ki ','Shuku ','Zong ','Cai ','Shou ','Peng ','Zhi ','Zheng ','Dian ','Zhi ',
        'Yu ','Taku ','Dun ','Shun ','You ','Shou ','Tei ','Ta ','Chin ','Sen ','Jian ','Gua ','Tang ','Ku ','Fu ','Zu ',
        'Chou ','Hen ','Juu ','Nuo ','Tei ','Cha ','Tui ','Ken ','Tou ','Sa ','Kei ','Tou ','Shou ','Ten ','Ten ','Tei ',
        'Seki ','Nie ','Man ','Liu ','San ','Hitsu ','Chong ','Lu ','Liao ','Shuku ','Tang ','Tai ','Shuku ','Shi ','Ki ','Seki ',
        'Seki ','You ','Teki ','Man ','Shou ','Lian ','Beng ','Zao ','Nian ','Hetsu ','Tui ','Ju ','Tou ','Sou ','Xian ','Han ',
        'Shuu ','Shou ','Son ','Bo ','Shuu ','Zu ','Ketsu ','Jue ','Lin ','Tou ','Kyou ','Kyou ','Boku ','Liao ','Dun ','Cuan ',
        'Kuang ','Sou ','Tatsu ','Heki ','Heki ','Choku ','Ju ','Cho ','Qiao ','Ton ','Chuu ','Sei ','Wu ','Yaku ','Nian ','Lin ',
        'Ryou ','Teki ','Reki ','Chi ','Ten ','Chu ','Duan ','Ei ','Long ','Rin ','Sen ','Ei ','Zuan ','Ran ','Shou ','Rang ',
        'Xie ','Jou ','Tou ','Qu ','Jie ','Cuan ','Zuan ','Shi ','Kui ','Kyaku ','Rin ','Shin ','Kyuu ','Tan ','Segare ','Ku ',
        'Tei ','Ta ','Ta ','Kyuu ','Lang ','Nerau ','Luo ','Ai ','Ji ','Ju ','Tou ','Utsuke ','','Yan ','Shitsuke ','Kang ',
        'Ku ','Rou ','Lao ','Ta ','Shoku ','Yagate ','Tei ','Tou ','Yagate ','Yu ','Sha ','Atsu ','Ki ','Gun ','Wei ','Getsu ',
        'Sen ','Tei ','Ken ','Fan ','Jin ','Shan ','Tsumugikuruma ','Shu ','Tun ','Chen ','Dai ','Aku ','Dou ','Qi ','Mao ','Nan ',
        'Jin ','Fan ','Ten ','Gou ','Hu ','Qu ','Huang ','Di ','Rei ','Dai ','Ao ','Shin ','Fan ','Kyou ','Ou ','Peng ',
        'Hai ','Ko ','Gu ','Pao ','Zhu ','Rong ','E ','Hatsu ','Jiku ','Shi ','You ','Ka ','Itsu ','Kei ','Shoku ','Byou ',
        ],
    'x8f':[
        'Ji ','Qiong ','Kyoku ','Kaku ','Guang ','Ro ','Kai ','Sen ','Chuu ','Sai ','Chi ','She ','Ryou ','Yu ','Shao ','Yuu ',
        'Kan ','Yun ','Chou ','Ban ','Fu ','Kei ','Shuu ','Gei ','Ryou ','Chou ','Zhan ','Ryou ','Shi ','Ki ','Bou ','Tetsu ',
        'Ka ','Kan ','Yi ','Hou ','Qian ','Kon ','Ren ','Byou ','Kan ','Hai ','Rin ','Pai ','Ryou ','Zen ','Juu ','Shuu ',
        'Yang ','Xian ','Chuan ','Sou ','Chun ','Katsu ','Yuu ','Kou ','Yu ','Fuku ','Shi ','Fuku ','Wen ','Ben ','Ten ','Yo ',
        'On ','Tou ','Koku ','Shin ','Katsu ','En ','Roku ','Kou ','Chao ','Ten ','Wei ','Hun ','Sori ','Tetsu ','Kyou ','San ',
        'Pu ','Rau ','Hun ','Han ','Rin ','Katsu ','Se ','Kan ','Kan ','Yi ','Ji ','Dui ','Ji ','Yo ','Kan ','Gou ',
        'Lei ','Hi ','Reki ','Reki ','Ro ','Rin ','Che ','Ya ','Gui ','Xuan ','Di ','Ren ','Zhuan ','E ','Lun ','Ruan ',
        'Hong ','Gu ','Ke ','Lu ','Zhou ','Zhi ','Yi ','Hu ','Zhen ','Li ','Yao ','Qing ','Shi ','Zai ','Zhi ','Jiao ',
        'Zhou ','Quan ','Lu ','Jiao ','Zhe ','Fu ','Liang ','Nian ','Bei ','Hui ','Gun ','Wang ','Liang ','Chuo ','Zi ','Cou ',
        'Fu ','Ji ','Wen ','Shu ','Pei ','Yuan ','Xia ','Zhan ','Lu ','Che ','Lin ','Shin ','Ko ','Ji ','Ji ','Heki ',
        'Sai ','Hen ','La ','Ratsu ','Ji ','Setsu ','Han ','Ben ','Ben ','Bian ','','Bian ','Ban ','Ji ','Hen ','Ben ',
        'Shin ','Joku ','Nou ','Nong ','Zhen ','Chaku ','Chaku ','Suberu ','Shou ','Hen ','Hen ','Tsuji ','Komu ','Liao ','Tatsu ','Ten ',
        'Kan ','Sen ','U ','Yu ','Kitsu ','Jin ','I ','Guo ','Mai ','Qi ','Sou ','Ou ','tu ','Chun ','Gei ','Ti ',
        'Un ','Kin ','Kou ','Ga ','Hen ','Go ','Da ','E ','Huan ','Zhe ','Totemo ','Jin ','Yuan ','Wei ','Lian ','Chi ',
        'Shou ','Ni ','Chou ','Sei ','I ','Kei ','Ka ','Chen ','Tai ','Ji ','Teki ','Haku ','Ou ','Tetsu ','Saku ','Tou ',
        'Jutsu ','Ta ','Kep ','Jing ','Kai ','Tou ','Yuu ','Mei ','Hou ','Seki ','Dai ','I ','Jie ','Tsui ','Retsu ','Xun ',
        ],
    'x90':[
        'Tai ','Sou ','Katsu ','Tou ','Hou ','Kou ','Gyaku ','Dun ','Kei ','Xuan ','Xun ','Ho ','Yuu ','Shou ','Shuu ','Tou ',
        'Chiku ','Kyuu ','Di ','Tei ','To ','Kei ','Teki ','Tou ','Gi ','Gen ','Ts ','Kyou ','Wu ','Sei ','Tei ','Soku ',
        'Zou ','Shun ','Hou ','Ren ','Suo ','Kai ','Li ','Sako ','Rai ','Kamu ','Saku ','Jue ','Hou ','Kan ','Tai ','Ryoku ',
        'Yuu ','Shuu ','Shin ','Iku ','Taku ','Ki ','I ','Keki ','Itsu ','Tatsu ','En ','Luo ','Hitsu ','Nuo ','Yu ','Tou ',
        'Sui ','Ton ','Sui ','Gen ','Sen ','Chi ','Ti ','Guu ','Shi ','Tei ','Yuu ','Un ','Gaku ','Hen ','Ka ','Atsu ',
        'Ka ','Kou ','Shuu ','Dou ','Tatsu ','I ','Appare ','Yi ','Kou ','You ','Chu ','Ryuu ','Son ','Tou ','Tei ','Chi ',
        'En ','So ','Tou ','Ken ','','You ','Kan ','Shou ','Gou ','Teki ','Ce ','Chi ','Soku ','Sou ','Sha ','Ton ',
        'Tei ','Lou ','Chi ','Cuo ','Rin ','Jun ','Jou ','Sen ','Sen ','Itsu ','I ','Wu ','Ryou ','Kyo ','Shi ','Hi ',
        'You ','Bai ','Kai ','Sui ','Kan ','Ken ','Teng ','Ji ','Baku ','Hen ','Hen ','Ryou ','Rei ','Yuan ','Yuu ','Ra ',
        'Ri ','Yuu ','Ting ','Deng ','Qi ','You ','Shan ','Kan ','U ','Bou ','Ru ','Kyou ','','Kuang ','Fu ','Kang ',
        'Hin ','Hou ','Kei ','Da ','','Shin ','Hou ','Yuan ','Son ','Huo ','Ya ','Bang ','Wu ','Ju ','You ','Kan ',
        'Tai ','Kyuu ','Hitsu ','Hi ','Hei ','Shou ','Hai ','Wa ','Tei ','Zou ','Ye ','Lin ','Kuang ','Kei ','Chu ','Shi ',
        'Ku ','Iku ','Gai ','Kou ','Keki ','Shitsu ','Ji ','Shun ','Kou ','Xing ','Kou ','Xi ','Kei ','Nuo ','Rou ','Jia ',
        'Kuai ','Zheng ','Rou ','Yun ','Yan ','Sei ','Dou ','Chi ','Ryo ','Hu ','Wu ','Fu ','Kou ','Kaku ','Rou ','Kou ',
        'Geng ','Gun ','Ei ','Bo ','Geki ','Hai ','Li ','Yun ','Bu ','Xiao ','Qi ','Hi ','Qing ','Kaku ','','Tan ',
        'Shuu ','Ping ','Lai ','Ni ','Chin ','Yuu ','Bu ','Kyou ','Dan ','Ju ','Yong ','Qiao ','Yi ','To ','En ','Bi ',
        ],
    'x91':[
        'Jaku ','Bei ','Gaku ','Yu ','Ken ','Gu ','Un ','Hou ','Ki ','Kyou ','Xiang ','Sou ','Tang ','Mei ','Xi ','Ru ',
        'Chiku ','Zi ','Suu ','Ju ','O ','Kyou ','Un ','Kou ','You ','Hi ','Baku ','Chao ','Hu ','Liao ','Gin ','Zhuan ',
        'Ko ','Qiao ','En ','Shou ','Man ','Kyou ','Xu ','Tou ','Bi ','Shin ','Bi ','Ceng ','Wei ','Tei ','Bou ','Sen ',
        'Rin ','Ha ','Tan ','Meng ','Gyou ','Cao ','Kai ','Hou ','Meng ','Shuu ','Kou ','Lian ','Sab ','Ten ','You ','Qi ',
        'Yan ','Chan ','Zan ','Rei ','Huan ','Xi ','Fuu ','San ','Ri ','Yuu ','Tei ','Shuu ','Shaku ','Hai ','Chuu ','I ',
        'Hang ','Yu ','Shu ','En ','Sui ','Mao ','Tan ','Ku ','Tou ','Shin ','Hun ','Sakenomoto ','','Yun ','Tai ','Tian ',
        'Qia ','Ta ','Saku ','Kan ','Ko ','So ','Hatsu ','Shuu ','Zai ','Mei ','Raku ','Setsu ','Shuu ','Yuu ','Tong ','Zhi ',
        'Xian ','Shou ','Tei ','In ','To ','Kou ','Bai ','Koku ','San ','Rai ','Ho ','Sui ','Hai ','Yan ','Xi ','Niang ',
        'Wei ','Ryoku ','Rin ','En ','Tao ','Hai ','San ','Shun ','Tan ','Sui ','Tetsu ','Saku ','Kun ','Tei ','Dai ','Du ',
        'Ko ','Sho ','Sei ','Tan ','Shyuu ','Shun ','Un ','Hatsu ','Kou ','Sou ','Mi ','Quan ','Shuu ','Cuo ','Un ','Yong ',
        'Ang ','Sa ','Kai ','Tang ','Shou ','Piao ','San ','Yu ','Ri ','Zao ','Rou ','I ','Shou ','Hoku ','Shou ','Kei ',
        'Tan ','Hatsu ','Jou ','Eki ','Rei ','Kyo ','Gen ','Yi ','Jou ','Ru ','Kun ','Shuu ','En ','Rei ','Mi ','Bi ',
        'Jou ','Kin ','Shou ','Shi ','Mi ','Gen ','Han ','Sai ','Shaku ','Yuu ','Shi ','Shaku ','Ri ','Chou ','Ya ','Ryou ',
        'Ri ','Kin ','','Hyuu ','Itsu ','Liao ','Tou ','Shou ','Tei ','Haku ','Kyuu ','Koku ','Fu ','Shin ','Shuu ','Hatsu ',
        'Luan ','Fu ','Nai ','Chou ','San ','Shou ','Kou ','Sen ','Zi ','Han ','U ','Hua ','Kan ','Kou ','Sen ','Bou ',
        'Jitsu ','Tei ','Si ','Xi ','Yi ','Sa ','Shi ','To ','Xi ','Jo ','Qian ','Kyuu ','Ken ','Heki ','Ye ','Kin ',
        ],
    'x92':[
        'Ha ','Hou ','Chen ','Xing ','Tou ','Getsu ','En ','Hu ','Pi ','Dou ','Shin ','E ','Etsu ','Don ','Kou ','Yin ',
        'Ken ','Han ','Sou ','Jin ','Shou ','Chuu ','Hun ','Yun ','Gi ','Qin ','Pi ','Guo ','Kou ','In ','Kin ','Shi ',
        'Yi ','Zhong ','Nie ','Kai ','Jitsu ','Ka ','Ta ','Kang ','Habaki ','Ro ','Ngaak ','','Taku ','Zi ','Dei ','Totsu ',
        'Shi ','Min ','Gu ','A ','Rei ','Hei ','Shi ','Ko ','Hatsu ','Hi ','Gyoku ','Si ','Saku ','Bu ','Chuu ','Ten ',
        'Kou ','Zhen ','Shi ','Shi ','Tetsu ','Kyo ','Ten ','Shi ','Sha ','Ken ','Shou ','Hou ','He ','Hi ','Sou ','Sho ',
        'Seki ','Haku ','Zhu ','Chi ','Za ','Po ','Tong ','Kan ','Futsu ','Tai ','Ryuu ','En ','Fuu ','Ryuu ','Etsu ','Pi ',
        'Ei ','Han ','Hachi ','Jie ','Kou ','Shutsu ','Sei ','Bou ','Dei ','Jou ','Di ','Jia ','Mu ','Dan ','Shin ','I ',
        'Shi ','Kou ','Ka ','Bei ','Jian ','Tou ','Kei ','Kou ','Kou ','Shi ','Er ','Raku ','Hei ','Shuku ','Bou ','Kou ',
        'Gin ','Jun ','Zhou ','Juu ','Shang ','Dou ','Mo ','Lei ','Tei ','Itsu ','Shutsu ','Ren ','Zun ','Chitsu ','Kyou ','Shan ',
        'Chi ','Sen ','Kei ','Sen ','Pi ','Tetsu ','Shu ','Kou ','Mei ','Kai ','You ','Sen ','Kan ','Xiu ','Jun ','Sa ',
        'Rou ','Ji ','Pi ','Ru ','Bei ','I ','Yin ','Kou ','An ','Diu ','You ','Shoku ','Kao ','Sen ','Luan ','Kasugai ',
        'Ai ','Diao ','Kan ','Ei ','Shi ','Keng ','Kyuu ','Shou ','Shou ','Shuu ','Sou ','Tei ','Sa ','Katsu ','Gong ','Shou ',
        'Tou ','Ryo ','Bai ','Rou ','Wan ','Shi ','In ','Hai ','Yoku ','Su ','Yu ','Sen ','Tei ','Hotsu ','Kan ','Kyou ',
        'Kou ','Cuan ','Hou ','Ten ','Wan ','Shi ','Si ','Ken ','Ka ','Gyo ','Tiao ','Gong ','Saku ','Retsu ','Xing ','Sen ',
        'Shin ','Kan ','Lue ','Ya ','Jo ','Tou ','Ju ','Ken ','Tetsu ','Bou ','Ho ','Li ','Han ','Ei ','Sei ','Gao ',
        'Ri ','Te ','Byou ','Chuu ','','Tu ','Liu ','Zui ','Kyo ','Chou ','En ','Ken ','Kou ','Diao ','Tao ','Shou ',
        ],
    'x93':[
        'Rin ','Guo ','Ryou ','Bei ','Roku ','Li ','Sei ','Pou ','Ken ','Min ','Zui ','Peng ','An ','Hi ','Xian ','A ',
        'Sui ','Rai ','A ','Kong ','Tou ','Kon ','Du ','Wei ','Tsui ','Shi ','Sou ','Ben ','Jou ','Sou ','Shun ','Tan ',
        'Jou ','Ki ','Sen ','Tei ','Ki ','Iku ','Kin ','Kan ','Byou ','Shou ','Ten ','Seki ','Ren ','Tao ','Ko ','Saku ',
        'Shu ','Zhen ','Roku ','Mou ','Roku ','Nie ','Hyou ','Atsu ','Lai ','Ken ','Kazari ','Bu ','Nai ','Wan ','Zan ','',
        'De ','Xian ','','Huo ','Kei ','','Men ','Kai ','Ei ','Tei ','Ren ','Ka ','Xian ','To ','Tu ','Wei ',
        'Sou ','Huu ','Juu ','Ji ','Gaku ','Kun ','Chin ','Tei ','Satsu ','Hong ','You ','Tan ','Ka ','Yu ','Kou ','Xing ',
        'Kou ','Wei ','Fu ','Zhao ','Sou ','Ketsu ','She ','Kou ','Kui ','Ten ','Bou ','Qiao ','Shuu ','Kou ','Chuu ','Sou ',
        'Kan ','You ','Min ','Kan ','Tan ','Ken ','Shou ','Kui ','Hu ','Xuan ','Ta ','Jie ','Shin ','Hen ','Shou ','Shi ',
        'Shuu ','Ya ','Bi ','Pai ','Ai ','Jie ','','Mei ','Sa ','Ta ','Hau ','Katsu ','Ren ','Saku ','Xi ','Ryuu ',
        'Soku ','Ye ','Dou ','Weng ','You ','Tou ','Sa ','Sou ','Reki ','Shuo ','Tsui ','Haku ','Pan ','Sa ','Hei ','Sang ',
        'Gang ','Shi ','Wu ','Ei ','Kou ','Tiao ','Ryuu ','Gai ','Shun ','Sai ','Sou ','Ban ','Kou ','Chin ','Chin ','Luo ',
        'Itsu ','Yuan ','Tang ','Nie ','Soku ','Ka ','Ka ','Ma ','Juan ','Kasugai ','Habaki ','Suo ','','','','Na ',
        'Lu ','Sa ','Ou ','Zoku ','Tan ','Shyuu ','Kan ','Sen ','Ren ','Shyuu ','Gyou ','Ban ','Baku ','Ra ','Bi ','Wei ',
        'Ryuu ','Teki ','Qiao ','Sou ','Yi ','Lu ','Ou ','Kou ','Shou ','Sai ','Qi ','Shou ','Tou ','Man ','You ','San ',
        'Feng ','Kyou ','Hyou ','Shu ','Rou ','Shuu ','Shou ','Rou ','San ','Jian ','Cao ','Li ','Xia ','Xi ','Kang ','',
        'Beng ','','','Zheng ','Lu ','Hua ','Ji ','Hoku ','Tei ','Kyou ','Hatsu ','Rin ','Suo ','Shuu ','San ','Cheng ',
        ],
    'x94':[
        'Kui ','Shi ','Ryuu ','Dou ','Kou ','Pie ','Sui ','Han ','Kyou ','Sen ','Yang ','Tang ','Xiang ','Tetsu ','Shou ','Son ',
        'Ryou ','Jie ','Lao ','Tai ','Shin ','San ','Ki ','Kan ','Shou ','Tou ','A ','Ying ','Dui ','Jue ','Nou ','Tei ',
        'Pu ','Tetsu ','','','Ding ','Shan ','Kai ','Jian ','Fei ','Sui ','Lu ','Sen ','Hui ','Yu ','Ren ','Shaku ',
        'Qiao ','Sen ','Taku ','Rai ','Heki ','Tetsu ','Kan ','Ye ','Taku ','Guo ','Tou ','Kyo ','Fen ','Tatsu ','Bei ','I ',
        'Ai ','Ban ','Xun ','Tyou ','Chuu ','Kou ','Zhui ','Ji ','Gei ','Ta ','Kaku ','Qing ','Hin ','Ying ','Kui ','Ning ',
        'Xu ','Kan ','Kan ','Yari ','Cha ','Shitsu ','Mie ','Li ','Lei ','Kei ','San ','Kou ','Shou ','Peng ','Rou ','Toku ',
        'Shaku ','Saku ','Ryo ','Hyou ','Bao ','Lu ','','Thoa ','Rou ','E ','Ro ','Kin ','Jian ','Ran ','Haku ','Sen ',
        'Yaku ','San ','Jou ','Jian ','Xi ','Kan ','Cang ','Jou ','Lei ','Cuan ','Qu ','Pan ','Ra ','San ','Ran ','Saku ',
        'Nie ','Kaku ','Tang ','Shoku ','Ran ','Jin ','Qiu ','Yi ','Zhen ','Ding ','Zhao ','Po ','Diao ','Tu ','Qian ','Chuan ',
        'Shan ','Ji ','Fan ','Diao ','Men ','Nu ','Xi ','Chai ','Xing ','Gai ','Bu ','Tai ','Ju ','Dun ','Chao ','Zhong ',
        'Na ','Bei ','Gang ','Ban ','Qian ','Yao ','Qin ','Jun ','Wu ','Gou ','Kang ','Fang ','Huo ','Dou ','Niu ','Ba ',
        'Yu ','Qian ','Zheng ','Qian ','Gu ','Bo ','E ','Po ','Bu ','Ba ','Yue ','Zuan ','Mu ','Dan ','Jia ','Dian ',
        'You ','Tie ','Bo ','Ling ','Shuo ','Qian ','Liu ','Hou ','Shi ','Xuan ','She ','Bi ','Ni ','Pi ','Duo ','Xing ',
        'Kao ','Lao ','Er ','Bou ','A ','You ','Cheng ','Jia ','Ye ','Nao ','Zhi ','Dang ','Tong ','Lu ','Diao ','Yin ',
        'Kai ','Zha ','Zhu ','Xian ','Ting ','Diu ','Sen ','Hua ','Quan ','Sha ','Jia ','Yao ','Ge ','Ming ','Zheng ','Se ',
        'Jiao ','Yi ','Chan ','Chong ','Tang ','An ','Yin ','Ru ','Zhu ','Lao ','Pu ','Wu ','Lai ','Te ','Lian ','Keng ',
        ],
    'x95':[
        'Xiao ','Suo ','Li ','Zheng ','Chu ','Guo ','Gao ','Tie ','Xiu ','Cuo ','Lue ','Feng ','Xin ','Liu ','Kai ','Jian ',
        'Rui ','Ti ','Lang ','Qian ','Ju ','A ','Qiang ','Duo ','Tian ','Cuo ','Mao ','Ben ','Qi ','De ','Kua ','Kun ',
        'Chang ','Xi ','Gu ','Luo ','Chui ','Zhui ','Jin ','Zhi ','Xian ','Juan ','Huo ','Pou ','Tan ','Ding ','Jian ','Ju ',
        'Meng ','Zi ','Qie ','Ying ','Kai ','Qiang ','Song ','E ','Cha ','Qiao ','Shou ','Duan ','Sou ','Kou ','Huan ','Ai ',
        'Du ','Mei ','Lou ','Zi ','Fei ','Mei ','Mo ','Zhen ','Bo ','Ge ','Nie ','Tang ','Juan ','Nie ','Na ','Liu ',
        'Hao ','Bang ','Yi ','Jia ','Bin ','Rong ','Biao ','Tang ','Man ','Luo ','Beng ','Yong ','Jing ','Di ','Zu ','Xuan ',
        'Ryuu ','Tan ','Jue ','Liao ','Pu ','Lu ','Dui ','Lan ','Pu ','Cuan ','Qiang ','Deng ','Huo ','Lei ','Kan ','Zhuo ',
        'Lian ','Yi ','Cha ','Biao ','Rou ','Chan ','Xiang ','Chou ','Chou ','Kyuu ','Ao ','Die ','Qu ','Liao ','Bi ','Chang ',
        'Mon ','Ma ','San ','Sen ','Koku ','Men ','Yan ','Hei ','Kan ','Hei ','Tsukaeru ','Kai ','Kou ','Hou ','Kou ','Jun ',
        'San ','Kan ','Xian ','Kan ','Bin ','Xia ','Yuru ','Dou ','Kou ','Tou ','','Peng ','Xia ','Rei ','Hen ','Hi ',
        'Tama ','Gai ','Kan ','Kaku ','Kou ','Batsu ','Shuku ','Kou ','Kei ','Ben ','Hai ','Kon ','Rou ','Ro ','Ting ','Sha ',
        'Ju ','Etsu ','Etsu ','Chan ','Keki ','Lin ','Shou ','Shai ','Kun ','En ','Ben ','En ','A ','Kon ','Yoku ','Bun ',
        'Xiang ','Bao ','Xiang ','Geki ','Yao ','Wen ','Han ','An ','I ','In ','Katsu ','Ketsu ','Ran ','To ','','Phwung ',
        'Ten ','Getsu ','Tou ','Kai ','Kou ','Ketsu ','Chin ','Kan ','Tou ','Kei ','Ki ','Tang ','Kan ','Hyou ','Kn ','Kyuu ',
        'Kai ','Sen ','Heki ','Dang ','Kan ','Tatsu ','Gon ','','Men ','Shuan ','Shan ','Yan ','Han ','Bi ','Wen ','Chuang ',
        'Run ','Wei ','Xian ','Hong ','Jian ','Min ','Kang ','Men ','Zha ','Nao ','Gui ','Wen ','Ta ','Min ','Lu ','Kai ',
        ],
    'x96':[
        'Fa ','Ge ','He ','Kun ','Jiu ','Yue ','Lang ','To ','Yu ','Yan ','Chang ','Xi ','Wen ','Hun ','Yan ','E ',
        'Chan ','Lan ','Qu ','Hui ','Kuo ','Que ','Ge ','Tian ','Ta ','Que ','Kan ','Huan ','Fu ','Kozatohen ','Roku ','Dui ',
        'Xin ','Sen ','Gotsu ','Yi ','Chi ','In ','You ','Dou ','Aku ','Sheng ','Han ','Pei ','Kou ','Yun ','Gen ','Shi ',
        'Pi ','Sei ','Bou ','You ','Yin ','Zhen ','Jie ','Tei ','Aku ','Qu ','Kyo ','So ','So ','En ','Ling ','A ',
        'Da ','Ta ','Ha ','Bing ','Fu ','Ji ','Lu ','Long ','Chen ','Xing ','Duo ','Rou ','Haku ','Kou ','Shu ','Ta ',
        'Gen ','Er ','Ki ','Yu ','Gai ','Shan ','Kai ','Shou ','Kei ','Chun ','Fu ','Hei ','Kou ','Sen ','Shou ','Choku ',
        'Pu ','Tou ','In ','Jin ','Jo ','Kan ','Tou ','Nie ','Yun ','Xian ','Bai ','Pei ','Suu ','Yi ','Tai ','Lun ',
        'In ','Ju ','Sui ','Chin ','Hi ','Ryou ','Tou ','Kan ','Riku ','','Ken ','In ','Sho ','You ','Jou ','Kyou ',
        'Chong ','En ','In ','Shu ','Tei ','Guu ','Ryuu ','Wei ','Wai ','Getsu ','Tai ','Ta ','An ','Kou ','Kai ','Zui ',
        'In ','Kai ','Yan ','Hui ','Kaku ','In ','O ','Kai ','Ai ','Geki ','Tou ','Sai ','Shou ','Tou ','Ao ','Geki ',
        'In ','','Rao ','Rin ','Tai ','Tou ','Hei ','Sui ','Zui ','Ou ','Ken ','Fen ','Ni ','Er ','Sei ','Tou ',
        'Shitsu ','In ','Shitsu ','Ki ','Rou ','Xi ','Tai ','Rei ','Rei ','Sui ','Koku ','Seki ','Jun ','Jun ','Nan ','Yi ',
        'Jaku ','Gan ','Qin ','Ya ','Yuu ','Ga ','Shuu ','Ko ','Kan ','Chi ','Kou ','Sen ','Shi ','You ','Sho ','Chu ',
        'Hu ','Zatsu ','Raku ','Yu ','Chou ','Chou ','Sui ','Han ','Waku ','Sou ','Kan ','Suu ','Zatsu ','You ','Kei ','Kei ',
        'Chou ','Liu ','Ri ','Nan ','Xue ','Za ','Ji ','Ji ','U ','U ','Setsu ','Da ','Fou ','Se ','Mu ','Bun ',
        'Fun ','Hou ','Un ','Li ','Li ','Ang ','Rei ','Rai ','An ','Haku ','Mu ','Den ','Dang ','Xing ','Wu ','Zhao ',
        ],
    'x97':[
        'Ju ','Ji ','Boku ','Chin ','Shou ','Shou ','Tei ','Shin ','Hai ','Bai ','Rei ','Qi ','Chou ','Kaku ','Sou ','Hi ',
        'Weng ','Ten ','Yin ','Gei ','Zhu ','Tun ','Rin ','','Dong ','Ei ','Bou ','Rei ','Sou ','Rei ','Ka ','Hong ',
        'Yin ','Baku ','Baku ','In ','Ryuu ','Meng ','Bin ','Mu ','I ','Huo ','In ','Xi ','Yi ','Ai ','Dan ','Deng ',
        'San ','Itsu ','Ro ','Ryuu ','Dai ','Ji ','Pang ','Yang ','Haku ','Heki ','Wei ','','Xi ','Sei ','Bai ','Meng ',
        'Meng ','Rai ','Reki ','Kaku ','Ai ','Fei ','Tai ','Long ','Rei ','Ai ','Fuu ','Li ','Bao ','','Kaku ','Kaku ',
        'Bing ','Sei ','Sei ','Jing ','Tian ','Shin ','Sei ','Tei ','Qing ','Sei ','Sei ','Ten ','Sei ','Tian ','Hi ','Fei ',
        'Kou ','Hi ','Men ','Men ','Hou ','Ye ','Ten ','Kai ','You ','Kaku ','Tei ','Sai ','Jian ','Jin ','Teki ','Du ',
        'Wu ','Jin ','Qin ','Kin ','Ka ','Niu ','Ha ','In ','Sou ','Ketsu ','Matsu ','So ','Tan ','Ban ','Yi ','Ou ',
        'Tou ','Hi ','Jia ','Hong ','Hou ','Ou ','Tomo ','Yin ','Jia ','Tou ','Ji ','Ai ','An ','An ','Hen ','Kyou ',
        'Kohaze ','Da ','Qiao ','Ting ','Wan ','Gou ','Sai ','Tou ','Sou ','Ken ','Kou ','Beng ','Tou ','Zhang ','Hei ','Kaku ',
        'Kiku ','La ','Shou ','Juu ','Bang ','Yi ','Shuu ','Qiu ','Katsu ','Xiao ','Mu ','Kiku ','Ken ','Hen ','Tei ','Jian ',
        'On ','Tou ','Kou ','Tou ','Fuku ','Ai ','Han ','Ge ','Hitsu ','Kaku ','Tou ','Lou ','Ki ','Qiao ','Ka ','Ki ',
        'Jian ','Kyou ','Chan ','Datsu ','Aku ','Ken ','Sen ','Toku ','Betsu ','Sen ','Ran ','I ','Jin ','Futsu ','Bai ','Juan ',
        'Kou ','I ','Qiao ','Kan ','Chou ','','Rou ','Un ','Shou ','I ','Ge ','Hai ','Tou ','Kou ','On ','',
        'Hitsu ','Sakan ','Hui ','Du ','Batsu ','Du ','Wei ','Ren ','Fu ','Han ','Wei ','Yun ','Tao ','Kyuu ','Kyou ','Sen ',
        'Xie ','Sen ','Sei ','On ','Sou ','In ','Shou ','Raku ','Hou ','Heng ','Ei ','In ','Peng ','Yin ','Yin ','Kyou ',
        ],
    'x98':[
        'Hu ','Ketsu ','Chou ','Kei ','Kui ','Kou ','Jun ','Kan ','Shu ','I ','Kyoku ','Gu ','Shou ','Gi ','Ki ','Kou ',
        'Yo ','Gan ','Han ','Ton ','Teki ','Dan ','Han ','Ha ','Ryou ','Saku ','Kei ','Lei ','Kan ','Qiao ','Atsu ','E ',
        'Gai ','Kitsu ','Gua ','Shin ','I ','I ','Kai ','Dui ','Pian ','Ping ','Lei ','Fu ','Kyou ','Tou ','Kai ','Kai ',
        'Kyou ','Le ','Tei ','Tei ','Ei ','In ','Hu ','Kan ','Kei ','Tai ','Tui ','Hin ','Rai ','Tai ','Shi ','Zi ',
        'Chui ','Ding ','Lai ','Yan ','Kan ','Jian ','Ka ','Sui ','Jiong ','Qin ','I ','Sai ','Dai ','Gaku ','Gaku ','Gan ',
        'Hun ','Kan ','Gyou ','Sen ','Gan ','Ken ','Shin ','Gi ','Gan ','Sou ','Ten ','Ten ','Jiang ','Ku ','Rui ','Liao ',
        'Piao ','Yi ','Ban ','Shuku ','Rao ','Kou ','Shou ','Ko ','Xun ','Qian ','Kai ','Sen ','Ju ','Hong ','Bin ','Ken ',
        'Hin ','Ro ','Lan ','Shou ','Kan ','Ye ','Ding ','Qing ','Han ','Xiang ','Shun ','Xu ','Xu ','Wan ','Gu ','Dun ',
        'Qi ','Ban ','Song ','Hang ','Yu ','Lu ','Ling ','Po ','Jing ','Jie ','Jia ','Tian ','Han ','Ying ','Jiong ','Hai ',
        'Yi ','Pin ','Hui ','Tui ','Han ','Ei ','Ying ','Ke ','Ti ','Yong ','E ','Zhuan ','Yan ','E ','Nie ','Man ',
        'Dian ','Sang ','Hao ','Lei ','Zhan ','Ru ','Pin ','Quan ','Fuu ','Biao ','Oroshi ','Fu ','Xia ','Sen ','Hyou ','Satsu ',
        'Hatsu ','Tai ','Lie ','Katsu ','Sen ','Shao ','Ku ','Hyou ','Shi ','Wei ','You ','You ','Sou ','Kai ','Sao ','Han ',
        'Liu ','Xi ','Ryuu ','Hyou ','Hyou ','Ryuu ','Hyou ','Hyou ','Hyou ','Liao ','','Se ','Fuu ','Biao ','Feng ','Yang ',
        'Zhan ','Biao ','Sa ','Ju ','Si ','Sou ','Yao ','Liu ','Piao ','Biao ','Biao ','Hi ','Hon ','Fei ','Fei ','Shoku ',
        'Shi ','San ','Ki ','Tei ','Si ','Taku ','Ken ','Son ','Xiang ','Ton ','Jin ','Yo ','Juan ','Choku ','In ','Han ',
        'Han ','Sun ','In ','Shu ','I ','Zhai ','Hitsu ','Jie ','Tao ','Liu ','Ci ','Tie ','Shi ','Hou ','Shoku ','Duo ',
        ],
    'x99':[
        'Hai ','Jin ','Ten ','Kou ','Jia ','Hei ','Yao ','To ','Shi ','Shou ','You ','Yang ','Ji ','Yan ','Le ','Yi ',
        'San ','Hotsu ','Dai ','Ga ','Ho ','Shun ','Tou ','Soku ','Yo ','Shi ','Kou ','Kon ','Ka ','Shoku ','Sen ','Tetsu ',
        'Hei ','Kan ','Hou ','Ye ','Tan ','Fei ','Chou ','Dai ','Kan ','E ','Nuan ','Un ','Ko ','Huang ','Tetsu ','Hui ',
        'Jian ','Kou ','Ei ','Tou ','Fun ','Dai ','Gu ','Cha ','Song ','Tou ','Haku ','Kou ','Ki ','Ki ','Ryuu ','Sou ',
        'Tou ','You ','Un ','Mo ','Tang ','Man ','Hitsu ','Yo ','Shuu ','Kin ','San ','Ki ','Sen ','Zen ','Shi ','Dan ',
        'I ','Ki ','Jou ','Cheng ','You ','Tou ','Hui ','Kyou ','Sen ','Fun ','Hai ','Bou ','En ','Mo ','San ','Shou ',
        'Ra ','Zuan ','Nang ','Shi ','Ding ','Ji ','Tuo ','Xing ','Tun ','Xi ','Ren ','Yu ','Chi ','Fan ','Yin ','Jian ',
        'Shi ','Bao ','Si ','Duo ','Yi ','Er ','Rao ','Xiang ','Jia ','Le ','Jiao ','Yi ','Bing ','Bo ','Dou ','E ',
        'Yu ','Nei ','Jun ','Guo ','Hun ','Xian ','Guan ','Cha ','Kui ','Gu ','Sou ','Chan ','Ye ','Mo ','Bo ','Liu ',
        'Xiu ','Jin ','Man ','San ','Zhuan ','Nang ','Shu ','Ki ','Kaku ','Kou ','Fen ','Hatsu ','Ni ','Hitsu ','Bo ','To ',
        'Han ','Fei ','Jian ','An ','Ai ','Fuku ','Ken ','Wen ','Kei ','Fen ','Bin ','Xing ','Ba ','Gyo ','Hyou ','Han ',
        'Teki ','Ta ','Taku ','Chi ','Shun ','Shu ','Zhi ','Pei ','Xin ','Jitsu ','Sou ','Yin ','Bun ','Chuu ','Dan ','Ro ',
        'You ','Baku ','Bao ','Ketsu ','Ta ','Eki ','Ku ','','Ku ','Kei ','Bo ','Zhao ','Yuan ','Peng ','Zhou ','Ju ',
        'Chuu ','Do ','Ku ','Hi ','Sou ','Ga ','Ling ','Zhen ','Tai ','Fu ','You ','Shi ','Hitsu ','Ta ','Da ','Shi ',
        'Liu ','Ba ','Hen ','Tao ','Zhi ','Rong ','Teng ','Tou ','Xun ','Quan ','Shin ','Kei ','Ji ','Kai ','Haku ','',
        'In ','Raku ','Shuu ','Dan ','Kai ','Ryuu ','Ju ','Song ','Shin ','Bou ','Liang ','Kan ','Tu ','Ken ','Tai ','Shun ',
        ],
    'x9a':[
        'E ','Tei ','Sei ','Gai ','Ryoku ','Sui ','Zhou ','She ','Hen ','Kun ','Tao ','Rai ','Sou ','Ke ','Ki ','Ki ',
        'Ken ','Hi ','Sou ','Ken ','Jie ','Yao ','Bu ','Hen ','Cong ','Hen ','Qian ','Fei ','Huang ','Jian ','Kaku ','Yu ',
        'Tei ','Quan ','Ka ','Sou ','Ki ','Rou ','Si ','Ka ','Tan ','Kui ','Sou ','Ken ','Cheng ','Shitsu ','Ryuu ','Pang ',
        'Tou ','Xi ','Cao ','Toku ','Yan ','Gen ','Shuu ','Sou ','Sen ','Li ','Chi ','Shuang ','Lu ','Xi ','Ra ','Zhang ',
        'Baku ','Gou ','San ','Hyou ','Sou ','Ku ','Bi ','Chi ','Yu ','Xu ','Ka ','Hatsu ','Shuku ','Gyou ','Rin ','Chan ',
        'Dun ','Ryuu ','Tan ','Zeng ','Ten ','Kyou ','Tetsu ','Ken ','Luo ','Zhan ','Kyou ','Eki ','Ye ','Taku ','Bin ','Shuu ',
        'Yan ','Peng ','Ryo ','Teng ','Jou ','Ki ','Shuang ','Ju ','Xi ','Kan ','Ri ','Hyuu ','Ma ','Yu ','Tuo ','Xun ',
        'Chi ','Qu ','Ri ','Bo ','Lu ','Zang ','Shi ','Si ','Fu ','Ju ','Zou ','Zhu ','Tuo ','Nu ','Jia ','Yi ',
        'Tai ','Xiao ','Ma ','Yin ','Jiao ','Hua ','Luo ','Hai ','Pian ','Hyuu ','Li ','Cheng ','Yan ','Xin ','Shin ','Jun ',
        'Qi ','Qi ','Ke ','Zhui ','Sou ','Su ','Can ','Pian ','Zhi ','Kui ','Sao ','Wu ','Ao ','Liu ','Qian ','Shan ',
        'Piao ','Luo ','Cong ','Chan ','Zou ','Ji ','Shuang ','Xiang ','Kotsu ','Wei ','I ','I ','U ','Kan ','Yoku ','Kou ',
        'Tou ','Xie ','Haku ','Bi ','Shi ','Tai ','Tei ','Ku ','Kai ','Kou ','Gou ','Ka ','Kaku ','Tui ','Kou ','Hen ',
        'Hi ','Kai ','Ka ','Gu ','Zui ','Lou ','Haku ','Xiao ','Hou ','Bo ','Ci ','Kuan ','Bin ','Mo ','Ryou ','Rou ',
        'Kou ','Toku ','Sou ','Zui ','Tei ','Hin ','Kan ','Ro ','Kou ','Kou ','Qiao ','Kou ','Kyou ','Lao ','Sou ','Hyou ',
        'Kon ','Kun ','Tei ','Hou ','Kyuu ','Zen ','Bou ','Tan ','Kun ','Bin ','Hatsu ','Chou ','Hi ','Shi ','Hatsu ','Zen ',
        'Ti ','Hou ','Hi ','Bou ','Futsu ','Ji ','Rong ','Kyoku ','','Kyuu ','Gatsu ','Kei ','Peng ','Sa ','Shao ','Sa ',
        ],
    'x9b':[
        'Tei ','Ri ','Bin ','Sou ','Tei ','Hou ','Shou ','Zheng ','Ken ','Sou ','Shun ','Sen ','Ta ','Ko ','Ratsu ','Jiu ',
        'Ki ','Lian ','Shin ','Bin ','Peng ','Mo ','San ','Man ','Ban ','Sou ','Shu ','Ryou ','Kan ','Qian ','Nong ','Kan ',
        'Katsu ','Ning ','Hin ','Ryou ','Rang ','Tou ','Tou ','Tou ','Kou ','Geki ','Tou ','Kan ','Tou ','Tou ','Kyuu ','Chou ',
        'Utsu ','Utsu ','Reki ','Ken ','Fu ','Sen ','Ki ','Sou ','Liu ','Ki ','Shou ','Shuku ','Ki ','Bi ','Ji ','Qi ',
        'Jie ','Kai ','Kon ','Batsu ','Haku ','Mi ','Xu ','Yan ','Shou ','Liang ','Yu ','Tai ','Ki ','Bou ','Ryou ','Gi ',
        'Jian ','Chi ','Piao ','Bi ','Ma ','Ki ','Kyo ','Shuu ','En ','Zhan ','Gyo ','Tou ','Jin ','Ji ','Eri ','Gong ',
        'Tuo ','Teki ','Ji ','Sho ','E ','Gou ','Sa ','Hang ','Ton ','Hachi ','Kai ','Shin ','Han ','Gen ','Hi ','Ro ',
        'Wen ','Hu ','Ro ','Shi ','Hou ','Fun ','Na ','Yuu ','Namazu ','Todo ','He ','Xia ','Qu ','Han ','Pi ','Rei ',
        'Ta ','Bo ','Qiu ','Hyou ','Futsu ','Hitsu ','Sei ','Bi ','Ju ','Chou ','Haku ','Yuu ','Gun ','Hi ','Nen ','Sei ',
        'Tai ','Hou ','Fu ','Sa ','Kyo ','Gu ','Kajika ','Konoshiro ','','Ta ','Kitsu ','Shu ','Hou ','Shou ','Ji ','An ',
        'Gai ','Tiao ','Zhu ','Yin ','Lie ','Luo ','Tou ','I ','Shi ','Hou ','I ','Kou ','Ho ','Kei ','Sen ','Ge ',
        'Kai ','Bora ','Mate ','Kao ','Gori ','Duo ','Jun ','Tei ','Ben ','Sou ','Za ','Sa ','Shin ','Yu ','Dai ','Chou ',
        'Kon ','Kou ','','Wu ','Qiu ','Ting ','Ho ','Kan ','Yuu ','Ri ','Sa ','Sa ','Gao ','Meng ','Ugui ','Asari ',
        'Subashiri ','Kazunoko ','Kochi ','Ni ','Shi ','Qi ','Sei ','Shou ','Dai ','Chun ','Ji ','Chou ','Qie ','Ko ','Zhou ','Tou ',
        'Lai ','Hi ','Gei ','Eki ','Kon ','Riku ','Jiu ','Shou ','Gei ','Lun ','Ryou ','Sou ','Li ','Meng ','Zong ','Sei ',
        'Nen ','Shachi ','Dojou ','Sukesou ','Shi ','Sou ','Hun ','Tei ','Kou ','Sei ','Sho ','La ','Zong ','Seki ','Bian ','Hen ',
        ],
    'x9c':[
        'Kan ','Sen ','Soku ','Wai ','I ','Yu ','Shun ','Rou ','Chou ','Kou ','Ren ','En ','Shuu ','Shuu ','Jian ','Hyoku ',
        'Gaku ','You ','Fuku ','Sai ','Kan ','Ka ','Ta ','Hu ','Muroaji ','Haya ','Haraka ','On ','Ken ','Hao ','O ','Fang ',
        'Sao ','Ryuu ','Ba ','Shi ','Shi ','Kan ','Shi ','Tou ','Chou ','You ','Kou ','Rong ','Qian ','Ki ','On ','Iwashi ',
        'Hatahata ','Ren ','Gou ','Le ','Hui ','Bin ','Sei ','Chou ','Qu ','Ken ','Sou ','Ban ','Xi ','Shuu ','Hyou ','Ji ',
        'Ji ','Chiku ','Shou ','Shuu ','Sen ','Shou ','Shou ','Kou ','Setsu ','Betsu ','Itsu ','Qu ','Xiang ','Bo ','Kyou ','Shin ',
        'Shuku ','Huang ','Son ','Sen ','Sen ','Fan ','Kei ','Rin ','Shin ','Miao ','Kisu ','Eso ','Kyou ','Fun ','Kan ','Kou ',
        'Kai ','Zei ','Sao ','Tan ','Kan ','Gui ','Sheng ','Rei ','Shou ','Hatahata ','Shiira ','Ai ','Ru ','Ji ','Sho ','Huo ',
        'Shiira ','Li ','Ryou ','Li ','Mie ','Shin ','Shou ','Gaku ','Ro ','Guan ','Li ','Sen ','Yu ','Dao ','Ji ','You ',
        'Tun ','Lu ','Fang ','Ba ','He ','Bo ','Ping ','Nian ','Lu ','Yuu ','Sa ','Fu ','Haku ','Bao ','Hou ','Hi ',
        'Tai ','Gui ','Jie ','Kao ','Wei ','Er ','Tong ','Ze ','Hou ','Kai ','Ji ','Jiao ','Xian ','Za ','Xiang ','Xun ',
        'Geng ','Li ','Lian ','Jian ','Li ','Shi ','Tiao ','Gun ','Sha ','Wan ','Jun ','Ji ','Kochi ','Qing ','Ling ','Qi ',
        'Zou ','Fei ','Kun ','Chang ','Gu ','Ni ','Nian ','Diao ','Jing ','Sou ','Shi ','Zi ','Fen ','Die ','Hyaku ','Chang ',
        'Shi ','On ','Wei ','Sai ','E ','Qiu ','Fu ','Huang ','Quan ','Jiang ','Bian ','Sao ','Ao ','Qi ','Ta ','Yin ',
        'Yao ','Fang ','Jian ','Le ','Biao ','Xue ','Bie ','Man ','Min ','Yong ','Wei ','Xi ','Jue ','Shan ','Lin ','Zun ',
        'Huo ','Gan ','Li ','Zhan ','Guan ','Chou ','Itsu ','Fu ','Li ','Kyuu ','Bu ','Gan ','Fu ','Diao ','Kei ','Hou ',
        'Nio ','Gan ','Shi ','Hou ','Mei ','Bao ','En ','Shi ','Hu ','Ken ','Fu ','Fen ','Wen ','Jian ','Shi ','Yu ',
        ],
    'x9d':[
        'Fou ','Yao ','Ketsu ','Ketsu ','Pi ','Huan ','Chin ','Hou ','Gan ','A ','Zheng ','Hou ','Feng ','Wen ','Ou ','Te ',
        'Jia ','Do ','Rei ','Mie ','Fu ','Ta ','Wen ','Ryuu ','Hen ','Zhi ','Ge ','En ','Shi ','Ku ','You ','Shi ',
        'Dan ','Ju ','You ','Ko ','Zhong ','Yu ','You ','Rong ','Ou ','Tie ','Itsu ','Shigi ','Ou ','Zhui ','Wu ','Ji ',
        'Katsu ','Ai ','Shi ','An ','Kou ','Jiao ','Ji ','Lie ','Zhu ','Ren ','Tei ','Kou ','Ro ','Jo ','Bou ','Kou ',
        'Ren ','Kou ','Kyuu ','Chuu ','Shi ','Raku ','Chidori ','Toki ','Ten ','Luan ','Kou ','Ji ','Yu ','Huan ','Tuo ','Bu ',
        'Bu ','Ken ','Yu ','Hotsu ','Shun ','Xun ','Bi ','Xi ','Jun ','Geki ','Tu ','Jing ','Tei ','Ga ','Ga ','Kyou ',
        'Koku ','Bu ','Shin ','Rai ','Ikaruga ','Kakesu ','Lu ','Hei ','Shu ','Fuku ','An ','Tou ','Hou ','Qin ','Qian ','Hi ',
        'Chou ','Lu ','Jaku ','Jian ','Ju ','Tu ','A ','En ','Qi ','Li ','Ya ','Sui ','Kou ','Zhui ','Kon ','Sheng ',
        'Qi ','Jing ','Yi ','Geki ','Sei ','Zi ','Rai ','Tou ','Qi ','Shun ','Kou ','Ju ','Qu ','Isuka ','Kikuitadaki ','Kei ',
        'Shu ','','Seki ','Byou ','Rou ','An ','Shuu ','Tei ','Ko ','Ti ','Gaku ','Jie ','Mao ','Fu ','Chun ','Tu ',
        'Yan ','Katsu ','Yuan ','Pian ','Kon ','Mei ','Hu ','Ying ','Dun ','Boku ','Keki ','Tsugumi ','Sou ','Fang ','Koku ','Ou ',
        'Yuan ','Ken ','Ou ','Shi ','Kaku ','Suu ','Tang ','Xia ','Jaku ','Ryuu ','Seki ','Kotsu ','Ken ','Zhun ','Han ','Shi ',
        'Zi ','Geki ','You ','An ','Kei ','Li ','Ten ','Kou ','Ti ','Tei ','Geki ','Tu ','Ma ','Jiao ','Gao ','Ten ',
        'Chen ','Li ','Zhuan ','Sha ','Gou ','You ','Ei ','Ou ','Chi ','Shi ','Ryuu ','Rong ','Lou ','Bi ','Sou ','Saku ',
        'Gyo ','Wu ','Jue ','Yin ','Quan ','Shi ','Shou ','I ','Hua ','Hetsu ','Ying ','Shuku ','Huang ','Ban ','Kyou ','Ryou ',
        'En ','Kao ','Shuu ','Kan ','Kan ','Tu ','Mai ','Zun ','Itsu ','You ','Ro ','Tuan ','Xian ','Kaku ','I ','Pi ',
        ],
    'x9e':[
        'Shu ','Luo ','Kei ','Yi ','Ji ','Zhe ','Yu ','Sen ','Ye ','Yang ','Heki ','Ning ','Huo ','Mi ','You ','Meng ',
        'Teki ','Gaku ','Yo ','Lei ','Bao ','Ro ','Kaku ','Long ','Shuang ','Yaku ','Ou ','Kan ','Ku ','Ri ','Ran ','Niao ',
        'Jiu ','Ji ','Yuan ','Ming ','Shi ','Ou ','Ya ','Cang ','Bao ','Zhen ','Gu ','Dong ','Lu ','Ya ','Xiao ','Yang ',
        'Rei ','Zhi ','Qu ','Yuan ','Kaku ','Tuo ','Si ','Zhi ','Er ','Gua ','Xiu ','Heng ','Zhou ','Ge ','Luan ','Hong ',
        'Bu ','Bo ','Li ','Juan ','Hu ','E ','Yu ','Xian ','Ti ','Wu ','Que ','Miao ','An ','Kun ','Bei ','Peng ',
        'Qian ','Chun ','Geng ','Yuan ','Su ','Hu ','He ','E ','Gu ','Qiu ','Zi ','Mei ','Mu ','Ni ','Yao ','Ou ',
        'Liu ','Seki ','Geki ','Jian ','He ','Yi ','Ying ','Zhe ','Liao ','Liao ','Jiao ','Jiu ','Yu ','Lu ','Xuan ','Zhan ',
        'Ying ','Huo ','Meng ','Guan ','Shuang ','Ro ','Kyou ','Ling ','Ken ','Kan ','Sa ','Kan ','Ken ','En ','Cuo ','Roku ',
        'Yuu ','So ','Ki ','Hou ','So ','Hou ','Zhu ','Kin ','Shu ','Jian ','Mi ','Bi ','Gu ','Liu ','Shin ','Kin ',
        'Lin ','Gei ','Ki ','Roku ','Jiu ','Kin ','Kei ','Rei ','Kyou ','Yan ','Jia ','Bei ','Li ','Sha ','Shou ','Rin ',
        'Jing ','Ji ','Ling ','Yan ','So ','Baku ','Baku ','Ge ','Shou ','Fu ','Men ','Mian ','Fu ','Hou ','Kyo ','Kiku ',
        'Bou ','Fu ','Xian ','Rai ','Kiku ','Ben ','','Feng ','Fu ','Kiku ','Men ','Ma ','Ma ','Mo ','Ki ','Ro ',
        'Zou ','Nen ','Fen ','Kou ','Kou ','Jin ','Kou ','Tian ','Tou ','Heng ','Xi ','Kou ','Kou ','Sho ','Rei ','Nen ',
        'Chi ','Koku ','Koku ','Yi ','Ken ','Tan ','Xi ','Tuan ','Moku ','Moku ','Qian ','Tai ','Chutsu ','Yuu ','Ten ','Ei ',
        'Katsu ','En ','Qu ','Mei ','En ','Gei ','Yu ','Rei ','Tou ','Du ','Can ','Yin ','Kan ','En ','Tan ','An ',
        'Shin ','Tai ','San ','Yi ','Bai ','Tan ','En ','Toku ','Ro ','Chi ','Fen ','Futsu ','Ho ','Bou ','Min ','Gen ',
        ],
    'x9f':[
        'Cu ','Qu ','Chou ','Wai ','Zhu ','Chi ','Mang ','Gou ','Betsu ','Ta ','Bi ','Yuan ','Chao ','Tuo ','Tei ','Beki ',
        'Dai ','Tei ','Shi ','Ko ','Ko ','Tou ','Fun ','Tou ','Yuan ','Hei ','Chou ','Kou ','Qi ','Yuan ','Tang ','Tou ',
        'So ','Sho ','Fun ','Fei ','Wen ','Ba ','Chou ','Tuo ','Tong ','Qu ','Sei ','Seki ','Yuu ','Shi ','Ting ','Go ',
        'Nian ','Sei ','Kon ','Ju ','En ','Tu ','Ti ','Kei ','Xian ','En ','Rui ','Bi ','Gyou ','Gu ','Kan ','Gotsu ',
        'Wu ','Kou ','Xi ','Katsu ','Sha ','Kyuu ','Ou ','Sa ','Nong ','Nang ','Sei ','Sai ','Ji ','Zi ','Sei ','Sei ',
        'Qi ','Ji ','Shi ','Shin ','Shin ','Kotsu ','Ga ','Kin ','Kai ','Pao ','Saku ','Shi ','Zi ','Chi ','Gen ','So ',
        'Chou ','Rei ','Rei ','Shutsu ','Quan ','Xie ','Gin ','Ketsu ','Kyuu ','Gou ','Soku ','Kun ','Gyo ','Sho ','Gi ','Gei ',
        'Saku ','Seku ','Ku ','Gun ','Xian ','Gou ','Gaku ','Aku ','Yi ','Chuo ','Shuu ','Dian ','Chu ','Kin ','Ya ','Chi ',
        'Chen ','He ','Ken ','Ju ','Ling ','Pao ','Tiao ','Zi ','Ken ','Yu ','Chuo ','Qu ','Wo ','Ryuu ','Pang ','Kyou ',
        'Hou ','En ','Ryu ','Long ','Kyou ','Gan ','Tou ','Rei ','Tou ','Long ','Gong ','Kan ','Ki ','Shuu ','Betsu ','Gui ',
        'Yaku ','Sui ','Ka ','Kaku ','Kai ','Yaku ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Shan ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'xf9':[
        'Kay ','Kayng ','Ke ','Ko ','Kol ','Koc ','Kwi ','Kwi ','Kyun ','Kul ','Kum ','Na ','Na ','Na ','La ','Na ',
        'Na ','Na ','Na ','Na ','Nak ','Nak ','Nak ','Nak ','Nak ','Nak ','Nak ','Nan ','Nan ','Nan ','Nan ','Nan ',
        'Nan ','Nam ','Nam ','Nam ','Nam ','Nap ','Nap ','Nap ','Long ','Nang ','Nang ','Nang ','Nang ','Nay ','Nayng ','No ',
        'No ','No ','No ','No ','No ','No ','Lou ','No ','No ','No ','No ','Nok ','Nok ','Nok ','Nok ','Nok ',
        'Nok ','Non ','Nong ','Nong ','Nong ','Nong ','Noy ','Noy ','Noy ','Noy ','Nwu ','Nwu ','Nwu ','Nwu ','Nwu ','Nwu ',
        'Nwu ','Nwu ','Nuk ','Nuk ','Num ','Nung ','Nung ','Nung ','Nung ','Nung ','Twu ','La ','Lak ','Lak ','Lan ','Lyeng ',
        'Lo ','Lyul ','Li ','Pey ','Pen ','Pyen ','Pwu ','Pwul ','Pi ','Sak ','Sak ','Sam ','Sayk ','Sayng ','Sep ','Sey ',
        'Sway ','Sin ','Sim ','Sip ','Ya ','Yak ','Yak ','Yang ','Yang ','Yang ','Yang ','Yang ','Yang ','Yang ','Yang ','Ye ',
        'Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Yek ','Yek ','Yek ','Yek ','Yen ','Yen ',
        'Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yel ','Yel ','Yel ','Yel ',
        'Yel ','Yel ','Yem ','Yem ','Yem ','Yem ','Yem ','Yep ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ',
        'Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yey ','Yey ','Yey ','Yey ','O ','Yo ','Yo ','Yo ','Yo ','Yo ','Yo ',
        'Yo ','Yo ','Yo ','Yo ','Yong ','Wun ','Wen ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ',
        'Yu ','Yuk ','Yuk ','Yuk ','Yun ','Yun ','Yun ','Yun ','Yul ','Yul ','Yul ','Yul ','Yung ','I ','I ','I ',
        'I ','I ','I ','I ','I ','I ','I ','I ','I ','I ','I ','Ik ','Ik ','In ','In ','In ',
        'In ','In ','In ','In ','Im ','Im ','Im ','Ip ','Ip ','Ip ','Cang ','Cek ','Ci ','Cip ','Cha ','Chek ',
        ],
    'xfa':[
        'Chey ','Thak ','Thak ','Thang ','Thayk ','Thong ','Pho ','Phok ','Hang ','Hang ','Hyen ','Hwak ','Kotsu ','Kaku ','','Coc ',
        'Chou ','','Sei ','','','Ki ','Cho ','Eki ','Rei ','Shin ','Shou ','Fuku ','Sei ','Sei ','U ','',
        'Hagi ','','Sho ','','','Itsu ','To ','','','','Han ','Shi ','Kan ','Kaku ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x200':[
        'Ha ','Qi ','','','','Hai ','','','','Qiu ','','','','Shi ','','',
        '','','','','jue ','','','','','','','yu ','','','','',
        '','','','','','','','Ba ','Cup ','','Kha ','','','','','',
        '','','','','Trut ','','','','','','','','','lu ','','',
        '','','','','','','','','','','','','','','','',
        '','Duoi ','','','','','','','','','Cui ','','','','','',
        '','','','','','Ga ','','','','','Nham ','','','','','',
        '','','','','','','','','Suot ','','','','','','','',
        '','','','','','','','','jie ','','','','','','','',
        '','','','','Zi ','','','','','','','','','Zung ','','',
        '','','Pai ','','Dui ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','jiu ','','','','','',
        ],
    'x201':[
        'Vu ','','','','','','','','','','','','','jie ','','',
        '','jue ','','','','','','','','','','','','','','',
        '','','','','','','Gop ','Vai ','','Hai ','','','','','','',
        '','','','Kep ','','','Nham ','','','','','Lam ','Nam ','Vai ','','wei ',
        '','','jie ','','','','','','','','','','','Mat ','Mat ','',
        'Mat ','','Mat ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','zhang ','','','Mat ','','','',
        '','','','','','','','','','','','','Yong ','','','',
        'xu ','','','','','','','','','','','','','','','',
        '','','','','','','','','','Faan ','','','','','','',
        '','','','Trum ','','','dan ','','','','','','','','','',
        '','','','','','','','','','','','','','Voi ','','',
        '','','','','','Va ','','','chu ','','','','','','','',
        '','','','','','','','','','','','','','','','qu ',
        '','','','','','','','','','','','','Hua ','Top ','','',
        ],
    'x202':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','yun ','','','','','','','','','','','',
        'dan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Nay ','',
        'Tray ','','','','','','','ju ','','du ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','jian ','','','','','','','','Ngai ','','Nho ','Thay ','','',
        '','','','','','','','Bing ','','zhuan ','shu ','','jue ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','lian ','','','','','','','','she ','',
        '','','','','','May ','Mu ','','','fu ','','','ju ','','','',
        '','','','','','','','','','','Tao ','','','','','',
        ],
    'x203':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Wu ','','','','','','','','shuai ','','',
        'gai ','','','','zhuang ','','','','','','','','','fu ','','',
        '','Man ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','But ','','','','','yao ','','','','Gap ','','bie ',
        '','','qu ','','','yang ','','','','','','','','sha ','','',
        '','','','','','','','','','','Xum ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Cap ','Bay ','','','','','jue ','',
        '','','','yu ','','','','sa ','','','','dun ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','xiao ','','','','','yu ','qu ','','','','',
        '','','','','','Ngai ','','','','','','','','Tui ','','',
        '','','','Giong ','','','','','','','','','','','','',
        ],
    'x204':[
        '','meng ','','','','','','','','jie ','shu ','','','su ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','meng ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Trom ','','','Long ','','','','',
        '','','','','','Ngua ','','','','','nei ','nei ','','','zhai ','',
        '','','','','','','','','','','','','Nhau ','','','cu ',
        '','','','','','','','','','','','','','','','',
        '','','','','wu ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Rang ','','','','','','','','','','',
        '','','','','','lian ','','Tin ','','','','','','','fan ','',
        'Truoc ','','','','','','','','','','','','','','','',
        'Quanh ','','','','Mong ','','','fu ','','','','','','','','',
        '','','','','','','','','Vao ','Nhui ','','','','','','',
        '','','','','','','','','','Lon ','','Tron ','Sip ','','','',
        ],
    'x205':[
        '','','','Xi ','','','','','','Juan ','','','','','','',
        '','hai ','','','','lun ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','heng ','','','','','','','','','Zheng ','','','','',
        '','','','','Nap ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'cheng ','','','qia ','','','yu ','','','','','','','zhao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Xuong ','','','','','','','',
        '','','','','','','','','Nap ','','','','','','','',
        '','','','','Bay ','Chong ','','','','','','','','','','Ngat ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','qiu ','xie ','','','','','','',
        '','','','','','','','','','','','die ','','','','',
        '','','','Lun ','','','Ping ','','die ','','','','','','','',
        'Tron ','','','','','','','','','Ret ','','','','liu ','','',
        ],
    'x206':[
        '','bu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','lai ','','',
        '','','he ','jiao ','','','','','','','','','','','','',
        '','','','','','','','','','','','wu ','','','','',
        '','','','','','','ju ','','','','','','','','','',
        '','','','','jiu ','wei ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','xian ','','','','chang ','','','','','',
        'Moc ','','','','he ','','','','','','','','','','','',
        '','','Ra ','','','','','','','','','','','','','Got ',
        '','zhe ','','','','ju ','','','','Shan ','Sha ','','','','','',
        '','','','','','','','','','','','','Cham ','','','',
        '','','','','','','','','','cu ','','','','','','',
        '','','','','Chem ','','','','','','Tiu ','','','','','',
        '','','','','','','','','fen ','','','','','','','',
        ],
    'x207':[
        '','','','jiu ','xu ','','','','','','','','','','Xian ','',
        'kuai ','','','','','','','','','bu ','','','','','','',
        '','','','','qia ','','','','','','','','','','Hui ','',
        '','Pai ','','','','','','','','ju ','','','Qia ','','','',
        '','','','','','','','Bao ','','','','','','','','',
        '','','','','','Cun ','','','qia ','','','','','','','',
        '','','','','','','','','','','','','','Peng ','','',
        '','','','','','','','','','Gaai ','','','','','','',
        '','','','zhe ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Got ','Bam ','','','','','','','','','','gun ','Lou ','','',
        'Jiao ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','yao ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Hoat ','','','','','','','','','','',
        '','','','','','','','','','','','ze ,bai','','','','',
        ],
    'x208':[
        '','','','','zhao ','','','','','Bua ','','','','','','',
        '','Tet ','','','du ','','','','','','','','','','','',
        'du ','','','','','','','','','Truoc ','','','','Chom ','','die ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Gang ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','duan ','','','','','','','','','Khuot ','','','','','',
        '','','','','','','','han ','','','','','','','','',
        '','Nhoc ','','','','','','','','','juan ','','','Vam ','Giup ','Giup ',
        '','','','dian ','Jue ','','','','','','','','Lu ','','','',
        '','','','','','','','','','','','','','','','',
        '','','Ruon ','','','','','','','10383.060,wan ','','','','','','',
        'yun ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','qu ','shao ','','','','',
        '','','','pao ','','','','','','','bao ','','','','fu ','jiu ',
        ],
    'x209':[
        '','','','','','','Cho ','','','','','','Cho ','','hua ','Bao ',
        '','','','','','','','','','','','','','mao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','diao ','','','',
        '','','','','','','','','','','','','','','wei ','',
        '','diao ','','','','','','','','','','','','','','',
        '','','','','Giau ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','sa ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','luan ','Muoi ','','','','','','Gan ',
        '','','','','','','','','','Chuc ','','Lung ','','','','',
        '','','','','','','Tron ','yu ','','','','','','Nhu ','','',
        '','','','','','he ','','','','shao ','','','','','','',
        '','','','','','','','','','Hui ','','','','','','',
        '','','','','','','','','','','','','','','','heng ',
        ],
    'x20a':[
        '','','','wai ','','','','','','','jue ','','','','zhuan ','',
        '','','','','','','','','','','','','','','','',
        '','','jun ','','','','','','','','','','','ju ','','',
        '','','','','','bang ','','','','','','','','','','',
        '','','','','','','','','zhu ','','','','','','','',
        '','','','','','Me ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Li ','','','','','',
        '','','','mei ','','','','','','','','','','','','',
        'liu ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','jue ','','Day ','','','','','','','','','','Rot ',
        '','','','','','','','','','','','','','','','',
        '','','','yu ','','','','','','','','','','','tu ','',
        '','','','','','','','','','shan ','','','','','','',
        ],
    'x20b':[
        '','','','','','','guan ','','','','','','','','','',
        '','','Cut ','','','','','','','','','Mo ','','fu ','','',
        'Mot ','','','bang ','','','','','','','biao ','','','','jie ','',
        '','','','','','','Jin ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Zhuo ','','','','','bian ','','','','','','tun ',
        '','','','','','','','','','','de ','','zhu ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Naai ','Aa ','','','','','','',
        '','','','','','mang ','','','','','','','','','Ngot ','sa ,san',
        '','','','','','','','','Daai6','','','Jai ','','','','',
        '','','','zhe ','','','','','ban ','jie ','','','','','','',
        '','','','','','','Cai ','','','','','','','','Hin ','pian ',
        '','','','','bian ','','','reng ','','reng ','','','Danh ','Zi ','','',
        ],
    'x20c':[
        '','','Ngoen ','','','','','','','','','Jaau ','Mut ','','','Mom ',
        '','an ','','he ','','','','','','Khen ','','hu ,gao','','','','',
        '','','','','','','','','','','','','','Meo ','','',
        '','','Eot ','','','','','Lo ','','','dai ','wai ,wai','','','','',
        '','Tam ','Dat ','Nip ','','Quai ','','','','','','','','Phom ','','',
        '','','','Ngai ','','','','','Ngaak6','','','','Chun ','','','',
        '','sa ,shai','','','','Fik ','','','','','','','','','','',
        '','','na ','','','','','Ming ','San ','','','','','','','',
        '','','','','','','','','','','','','shu ','','','Nham ',
        '','','','Hang ','','','Ji ','','','','','','Zaang ','','','',
        '','','','','','','Nhung ','','','','','','','','Khinh ','',
        '','ge ','','','','Gip ','','die ','','','','','','fu ','','Shu ',
        '','Kwan ','','','','','','he ','','','','','qia ','','','Ce ',
        'Vang ','','','','','Caau ','Dap6','','Nhu ','Thay ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Tu ','','','','','','','cheng ','','',
        ],
    'x20d':[
        '','','','','','','','','','','','Phao ','Nhanh ','Nhan ','','Mang ',
        'Nuc ','','','','','Miu ','Voi ','','','','','Gung ','','','','',
        '','xiao ','','','','Ngoam ','zhu ','','','','','Thut ','','','','',
        'Gau6','hu ','ta ','Ngaau ','','zao ','','','','','','','dao ','','na ','',
        '','','','','','','Daam ','Koe ','Mui ','Hong ','','','','','','',
        'Mep ','','','','','','','','Mun ','','','','','','','',
        '','','','ya ','','','','zhen ,chun','de ','Go ','','','','','','Gwit ',
        '','E ','','','','','','xuan ','','','','','Mang ','Faat ','Waak ','Pe ',
        'Tham ','Nhu ','','','','','','','Se ','','Pha ','','','','','',
        '','U ','','','','Nhau ','Uong ','','Sat ','Bop ','','','Zai ','','','',
        '','Troi ','Du ','Mai ','','Kung ','','Dim6','','','','da ','nang ','','','Chut ',
        '','','Gap6','','','','','','jue ','he ','','','','','','',
        '','','dai ','','','zhu ','','','','','','','','ta ','','',
        '','','','','','','bian ','','','xu ','','','','','','',
        '','','','','Phao ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x20e':[
        '','pai ','Giot ','','Inh ','','','','','Kak ','Tap ','','','Me ','Naa ','Ge ',
        'Kam ','Soek ','Bou ','','','','','Xua ','Tuc ','Song ','','','','','','Bai ',
        '','','','','','','Khan ','','','','','Tau ','','','','',
        '','','','','','','','','','yu ','Ngaak6','','','','Map ','',
        'xun ','wa ','','ang ','han ','','','','','','','','Lan ','','','',
        '','yao ','','ge ','','bao ','','','xu ','','','','','','','',
        '','','','','','','','','','','','','','Ko ','','',
        '','','','Git6','','','','Ngo ','Kam ','Lan ','Maai ','Zam6','','Cay ','','',
        '','','','','','','','','','','','','Gwe ','','','',
        'huan ','','','','','','','','Long ','Thoi ','Ban ','','','Gaak ','','ku ',
        'Lung ','','Gaa ','','','','','','','Trou ','He ','Loe ','He ','','','',
        '','Hung ','','','','Chac ','Nop ','','','Ri ','Que ','Cop ','Xui ','','Chau ','Ngoan ',
        '','Guong ','Ngon ','Han ','Oang ','','','','','','','','','huan ','','zu ',
        '','','','','','','','Le ','Zeot6','he ','','','','','','',
        '','','','','Don ','zhao ','','','','','','','tu ','','','',
        '','','','','Long ','','','','','','Aa6','Bai ','Dau6','','','',
        ],
    'x20f':[
        '','','','','','','','','','','','','','','','',
        '','','','','','Paai ','','Zaam ','wu ','','','','','','','',
        '','','jiang ,qiang','','','','Muon ','','','lun ','Day ','','','But ','Ngai ','Ho ',
        'Kang ','Loe ','','','','Danh ','','Thay ','','','','Ji ','','','','',
        '','Xo ','','Zap ','Tham ','Thung ','Nuot ','','','','','Nac ','Syut ','','Nhai ','',
        'Ngo ','','Neng ','Ngon ','Thua ','','Giuc ','','','','','Oam ','','','','',
        '','','','','Kik ','','','','','','','','','','','',
        '','','','','','yu ','','','','','','zhe ','','','','',
        'Hup ','','','','','','','','','','','','','He ','','Ce ',
        '','','','','','','','','','','','Ngoang ','','','','',
        '','','shu ','Rum ','','','Bai ','','','la ','','','','We ','','',
        '','','','','Baang ','Zaa ','Ging ','','','Nuot ','','','Cyut ','Nhun ','Nhap ','',
        '','Si ','Xep ','','','','','','','','','','','','','',
        '','','Het ','sa ','','qiao ','','','','','','Lu ','hua ','','','',
        '','','','','','','','','','','Gaa ','Saau ','Soe ','Wet ','','Ngui ',
        '','','','','','Khan ','','','','','','','','','','',
        ],
    'x210':[
        '','','','','','','','','','','','','','','','',
        '','','','','Lu ','','','','','','','','','Nam6','Zip ','',
        'Bei6','','','','','Phao ','','','','Lok ','','Bam ','','','','',
        '','Hao ','Goi ','','','','','Ron ','','','xie ','','','','','',
        'han ','','','','','','','','fan ','','','','','ai ','yu ','Am ',
        '','','','','','','','','','','Hon ','','Wo ','Hang ','Xao ','',
        '','','','','','','','','','','','','','','','Dyut ',
        '','','','zhan ','','Gan ','Zit ','Doeng ','Kwaat ','','Ngon ','Ziu ','','','','',
        'Khao ','','','Hun ','','','','Mom ','Buk6','','yu ','','','Eng ','','',
        '','Ban ','','','','','Lai ','','','','','','','Zuk6','','bao ',
        '','shu ','','','','','','','','','Ze ','peng ','','','Ngau ','',
        'Ran ','','Ray ','Troi ','','','','Khoan ','','','','','','','','',
        'E ','Leng ','','','lai ','','','Bai6','Kwaak ','Gaa ','','','','Chem ','Phan ','Doe6',
        '','','Boc ','Bo ','','Gung ','Le ','Mua ','','Mut ','','','','lun ','','',
        '','','','','Laai6','','','','','','','','','','','',
        '','','','','Ceoi ','Ngung ','Sek ','','','Chen ','','','','','Phac ','Thot ',
        ],
    'x211':[
        '','Lum ','','','','','','','','','','','','Ruc ','Gam ','Ham ',
        '','','dao ','','','','','','','','','','','','','Haa ',
        '','Zaai ','','','','','Lom ','','','Khan ','Toe ','Khem ','Hun ','','','Jik ',
        'Tot ','cu ','ru ','','','Ji ','','','','luan ','','','','Soe ','','',
        '','','','','','e ,ei','','','Laa ','Dang ','Bun ','Hum ','','','','Lai ',
        'Lanh ','Ngong ','','','','','','','la ','yun ','','','','','','',
        '','','','','','die ','','Nan ','','','','','Hoai ','','','',
        '','huan ','','','','','','','','','','huan ','','','','',
        'Gwang ','Nhau ','','','Nhep ','wan ','','Wok ','','','','','','','','',
        '','Nham ','','','','lian ','Trom ','','','','Gu ','','','','Giau ','',
        '','','','','','jiu ','','','','','','','','','','',
        'dun ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','die ','','','','','','Doe ','','','','','he ','',
        'zhe ','','','','','','wei ','','','tu ','','','','','','hun ',
        '','','','','','dang ','he ','tai ','Quay ','','yu ','Nhot ','ya ','','','',
        ],
    'x212':[
        '','','','','','jue ','','','','','','','','','Mui ','',
        '','','','yuan ','','','','','','You ','','','','','','',
        '','','','','','','','','yu ','','','','','','','',
        '','','','','','','lei ','','','','','','','','','',
        '','','','','','','','','','','','','','','Cong ','',
        '','','tun ','','','','Cong ','','','','','','','','','',
        '','','','','','','','','','bao ','','','','','','',
        '','','','','lu ,hu','','','jie ','','','','','','','Tum ','Moc ',
        '','','','','','','','','','','','','','shu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Sanh ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','gao ',
        '','','','','','','','','','de ','','','yu ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x213':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','guai ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'hu ','','','','','','','','Che ','Vung ','Lam ','','Mun ','Nui ','','',
        '','','','','','zhai ','','','du ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','du ','','','','','','',
        '','an ','','','','','','','','','','Bun ','Nam ','','','Hang ',
        '','','','','','','','','','','','','','Thong ','su ','',
        '','','','','Gung ','','','','','','zhu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','xia ','','','','','','','',
        '','Luong ','','','','Tret ','Xay ','Bui ','','','','','','','','bai ',
        '','','','','','','','','','','','','','','','',
        ],
    'x214':[
        '','','','','','','','','','','','','chu ','','','',
        '','','','','','','xian ','Hoc ','','','','','','fu ','','',
        '','','','','','sa ','','','','','','','','','Ve ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Coi ','Chum ','','','','Thoai ','','','','','','Lan ','Sui ','',
        '','','','','','','','','','','','','','Coi ','','',
        '','','Gom ','','','','','','','','','','','','yu ','',
        '','sa ','','Juk ','Lan ','','','','','','yu ','','','ju ','','',
        '','','shu ','xian ','','','gai ','','','','','','','','','',
        '','','','','','','','','','','','Cau ','','','Suong ','',
        '','','','','','','','','','','','','','','','',
        '','','','Loi ','Vung ','','','','','','','','','','','San ',
        '','','lai ','','Lam ','','','','','','','','','','','',
        '','','','','','Chen ','zhan ','','','','','','','','','Chum ',
        '','','','','','','','','','','','','','','','',
        ],
    'x215':[
        '','','','','','','','','','','','','','','','',
        '','','','','Lan ','','','','','','','','','','','',
        '','','','','','','','','','','shu ','','','','','',
        '','','','','yu ','','','','','','','','','','','Trau ',
        '','','','','','','','','','','','','','','','',
        '','','kua ','','','','','hai ','','','','','','','','',
        '','','','','','','','hang ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','yun ','','','','','','','','','','','','','',
        '','','','','','','','','','','guai ','','','','','su ',
        '','Bon ','','','','','','','','','','','','','','',
        '','','Sai ','','','','','','','','','Lam ','','','Tum ','',
        'Muong ','','','','','','','Peng ','','','','','','','','',
        '','','','','','chun ','','','','','','','','','','',
        '','','','','','','','','','fan ','','','','','','',
        ],
    'x216':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','zhe ','Mat ','Lon ',
        'juan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','jie ','','','','','','','bie ','','','','','',
        '','','','','Canh ','Nhon ','','','','','','','','','','',
        '','Bi ','','Xon ','','','','yan ','wei ','','','','hao ','','','',
        '','','','','meng ','','','','','','Lon ','','','','','',
        'jue ','To ','To ','','','','Hai ','','','','','','','','','',
        '','','','','','','','','','zhang ','','da ','','hao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','can ','','',
        '','','','','Nua ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x217':[
        'fan ','','hu ','','','','','','','','','','','','','',
        '','','','','','','','','','','ru ','','','','','',
        '','','','','','','','','','','','','','','','zhe ',
        '','Ji ','gao ','','','','','','','','','','','','','',
        '','','','Bua ','','','','','chu ','','zhe ','','','','','',
        '','','','','Kep ','Va ','','','','','cheng ','','du ','','','nian ',
        '','','','','','','Vu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','cu ','','','pan ',
        'hu ','','','xian ','','','','','','','fu ','nai ','','','','',
        '','','','','','','','','','','','','','','Nen ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','lian ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x218':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','hao ','','yang ','','','','','','fu ','',
        '','','','Cuoi ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'juan ','','Nhang ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','qu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhuan ','','','','','','','','dang ','','','','','','','',
        'Sau ','','','','','','','','','','man ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Sui ','','',
        '','','','','','','','','shu ','','','','','','','',
        '','','','','han ','Ban ','','','','','','','','','','',
        '','','nei ','','','','','','Cuoi ','','','','','','cai ','jie ',
        '','','','','','','','','','','','Sen ','','','','',
        ],
    'x219':[
        '','','','','','','','','','','Chua ','','','','fan ','',
        '','','','Moi ','Moi ','','','zhu ','','na ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','jiao ','','','','Nhat ','xiao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Con ','ju ,ru','','','','','','Me ','','','',
        '','xu ','','','fu ','So ','','','','','','','','','','',
        '','','','','','er ','','','','','','shu ','','','','',
        '','','','','','','','Rot ','','','','Chat ','','','Nhang ','',
        '','','','xiao ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','mian ','','','','','wa ','','pao ','','','','','','',
        '','','','','','','heng ','','zhu ','','','','','','','',
        '','','','','','','','','','dai ','','','','','','',
        ],
    'x21a':[
        '','','','','Xia ','ju ','','','','','','','','','','',
        '','','','','','','','zao ','','','','','','','','',
        '','','','yu ','','','','Tot ','','','','','','','','',
        '','','jie ','','Ning ','nai ','','','','','','','','','','yu ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','jie ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','an ','','','Xum ','','','',
        'ceng ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Sao ','','','','','','','','','','','','','','',
        '','','','','','','Lung ','','','','','','','','','',
        ],
    'x21b':[
        '','','','','','','','','Xuong ','sai ','yu ','jiao ','','','','',
        '','','','','','','','','20960.020,lao ','','','','','','yu ','',
        '','','','','','','','','','','','wu ','','','','',
        '','','','','','','','Tac ','','','','','Gang ','','','',
        '','','de ','','','','','','','Ban ','','','','','','',
        'shuan ','','','','','Cut ','','','','','','','Mon ','','','',
        '','','bai ','','','','','Chut ','','','','','Be ','','','',
        '','Chut ','Trut ','kao ','','','','','luan ','','','Nhon ','','','','',
        '','','','','','','Mon ','Chut ','','Mon ','','May ','Be ','Chut ','','',
        '','','','Choai ','','','','','','nai ','','','','','','',
        'May ','','','Be ','Be ','Be ','Zao ','','','Be ','','Nhen ','Mon ','Nhon ','Mon ','',
        '','','Tho ','','','Chuong ','Chuong ','','Nhon ','','','','','Nhon ','','',
        'Oat ','','','','','','','wu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'ga ','','','','chao ','','','','','','','','','ga ','','',
        ],
    'x21c':[
        '','','','','','hu ','','','','','','','','','','',
        'qiao ','','','','','','','','','','','','','','','',
        '','','xie ','','','','','','','','Duk ','','','','','',
        '','','','','','','','','','','','','','ai ','','pu ',
        '','','','','','','Shu ','','','','','','','','','',
        '','','','','','','','','','','','','zhao ','','','',
        '','','','xu ','','','','','','Thuoc ','','','','','','',
        '','zhu ','','','','','','die ','Gang ','','qu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Ti ','','jue ','','','qiu ','','','','','',
        '','','Ke ','jiang ','','','','','','','yun ','','Gwat6','','','',
        'qu ','','','','','','','','','','','','','','','',
        'Ngoe ','','kai ','Cuoi ','','','','','','','','','','','','',
        '','chu ','','','','','','','ju ','','','','Cuoi ','Rot ','','',
        '','','','','','Toi ','','','','','','','','','','',
        '','','','Cuoi ','lu ','','','','','','','','','','jue ','',
        ],
    'x21d':[
        '','','','','','','lu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','ya ','','',
        '','hu ,jie','','','','','','','','','','','','','','',
        '','','','','','','','','','Ngut ','','','','','','',
        '','','','','','','','','hu ','ang ','','fu ','','','','',
        '','','','','','','','','','','','','mu ','','','',
        '','','','','','','','','','','Cu ','','','','','',
        'Nui ','','yao ','ai ','','','','','','fan ','','ju ','','','','',
        'qie ','','','','','','','','','','','','','','','',
        '','','kuang ','','','','ya ','','Ngan ','','kan ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','','','','','bie ','','','han ','','na ','','',
        '','','','','wu ','gao ','','','','','','','','','','',
        '','','','','','','','','','','','ya ','','','','',
        ],
    'x21e':[
        '','','','','','','','','','','','','zhu ','','jie ','Voi ',
        '','','','','xie ','','','ya ','','','','','','','','',
        '','','','','','','ze ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','ya ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Nghi ','','','','','','','','','','','','','die ','','',
        '','','','','','','','','','hu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','die ','','','','','','','','','','','pen ','','','',
        '','','','','','','Din ','','','','','','','','','',
        '','','','','tu ','','','xia ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Voi ','','Seoi ','Von ','Chon ','','','','','','','','',
        'zhu ','','','','','','','','gun ','man ','','','zu ','','hu ','',
        '','lei ','','','','','','','','','','','','','','',
        ],
    'x21f':[
        '','','','','die ','','','','','','','','','','','',
        '','','','dian ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','wei ','','','','','','','','','','','','','kuai ','',
        '','','','','','yun ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Non ','','','','',
        '','Jie ','bang ','','','','','','','','','','','','','',
        '','','','','','','','kuang ','','','','','','','','',
        '','','','ceng ','','dang ','','','','','','','','','','',
        '','','','','','','','','hai ','','','','Doc ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','nang ','','',
        '','','','','','yu ','','','','','','','','','','yu ',
        '','','','','','','','','','','Nao ','','xun ','','ju ','',
        ],
    'x220':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','wan ','','','','','','','','',
        '','','','','','Vang ','Sua ','Tron ','Sang ','','','','Lon ','','Sam ','',
        '','To ','Lon ','','','han ','','','','','','','fu ','','','',
        'fu ','','','','','','','','','','','Trang ','','Va ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','jue ','','','','','',
        '','','','','','','','','Phuon ','','','bu ','','','','',
        'fu ','','','','xuan ','','fu ','','','','','','','','Du ','',
        'xie ','Shi ','','','','','','','','','','','Vua ','','','',
        '','','','','','','','','','','','','','','','',
        'Tranh ','yuan ','','','','','','','','mao ','qian ','','','','','',
        'wu ','','','','','','','Lei ','Long ','','Vua ','','','','','',
        '','','','','','Ta ','','han ','qian ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','la ','','','','','','','','','','','',
        ],
    'x221':[
        '','','','Phoi ','','','','','','','','','','he ,ge','bang ','',
        'meng ','','','wu ','dai ','','','','','','','','han ','Bau ','','',
        '','','','','','','','cu ','','','','','','','','Man ',
        '','','','','','xiang ','Hua ','','','','','','','','','',
        '','','','','','','Manh ','','','mao ','','ceng ','','','','Lian ',
        '','','dan ','','','','Lian ','','','','','','','dian ','','',
        '','','','','gai ','Ju ','','','','','zu ','','Chan ','','','',
        '','','','','','','','','','yao ','','','nei ','','','',
        '','','neng ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','ge ','','Jian ','',
        'Lai ','Nin ','','','','Nam ','jian ','May ','May ','','May ','','','','','',
        'hu ','','','','','','','','','','chen ','','','','','',
        '','','','','','','','Guan ','yan ','Doi ','','','','','','',
        '','','','','','','','sha ','','','','','','','han ','',
        '','Khuya ','','','','','ren ','','','','fan ','','','','','',
        '','','','','bu ','na ','','','','','','','','','','',
        ],
    'x222':[
        '','','','','','','','','Nap ','','','','','','','',
        '','','','','','bai ','','','Roku ','','','kun ','','qiu ','','',
        'cu ,la','','','','','','','','','','','','','','','',
        '','','pu ','','','','','','','','','jie ','','zhan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','du ,tu','','','',
        '','','hu ','','jia ','','','','la ','','','','','','','',
        '','','','','','','','','','','','','','Kho ','U ','ma ',
        '','','','','','','','','','','','','','Zu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','yu ','','lu ','','','','','','',
        '','fen ','','','','','','','','','','','','','','',
        '','','','','','yu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','xian ','',
        '','','','','','','','','','wu ','','','','','','',
        ],
    'x223':[
        '','','','','qu ','','','','','','Rong ','','Rong ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','fu ','','yu ','','','','',
        '','','','','','','','','','','','','','','gao ','juan ',
        '','','','','','quan ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','die ','','','','','','dai ','','su ','',
        '','','','','jie ','','qu ','','han ','','','','','','','',
        '','jie ','','','','juan ','','','','','dan ','','','','','',
        '','','','','','hu ','','','','jue ','','yu ','','','','',
        '','','','','','','','','','','','','','fu ','','',
        '','Ban ','','','','','','','','','','','','','','',
        '','','Cong ','Cong ','xun ','','','','','','','','','liu ','','',
        '','','','Beng ','','','','jue ','','','','','','','','Von ',
        ],
    'x224':[
        '','','','','yuan ','','','','','','','','','','Khom ','',
        '','','','','','','','','','','','','','','cheng ','',
        '','','','','','','','King ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','jiu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','hu ','','','','','','',
        '','','','','','','','','','','','','','','Bay ','',
        '','','fu ','','chu ','','','','','','','','','','lan ','',
        '','','','','','','','','','','','','','','','',
        'yu ','','','','','','','','','','','','','','jiao ','',
        '','','','','','','','','','','','ang ','','','','',
        '','','','','sa ','','','','','','','','ge ','','','',
        '','','kua ','','','','','','','','','','xie ','','','',
        '','','wu ,hu','','','xiu ','','','','','','','','','','',
        ],
    'x225':[
        '','','yan ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','yu ','','','yu ','','','','','','','yu ','','','',
        '','','liu ','','20832.030,yu ','','','','','','','','','','','',
        '','','','','','shuai ','','','','','','yuan ','','','','',
        '','shuai ','','','','','','','','','','','','','','ao ',
        '','','','','','','','','','','jiao ','','sa ','xian ','zha ','dian ',
        '','','','','','','','','San ','','','shan ','','','','',
        'Suot ','','','','','','','','tiao ','','','','','','','su ',
        '','','','','','Sau ','Sau ','','','','','','','xian ','','',
        '','yu ','','','','','jue ','nang ','','','','','','','','',
        '','','','','','ru ','','','','','','','','','','',
        '','','','','xia ','','','','','Nuoi ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','wu ','','','','','','','chang ','','Lo ','','','',
        ],
    'x226':[
        '','','','','qiu ','Maau ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Rung ','Rap ','',
        '','','','','','','','','Jiang ','','','','','','','',
        '','wu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Hung ','','','','','','','','','Nhon ','E ','Tim ','kan ','',
        '','Lung6','','','','','','','','','','','','','','',
        'xian ','','','','','','ju ','','','','','miao ','','','','',
        '','su ','','','','','Ti ','','','','','','','','','',
        '','','','','','','','','','','hu ','','','','','',
        '','','','','','','','','','Khuay ','','zhu ','Ngop ','','','',
        '','','','qiu ','ya ','','','','','','','','','','bie ','',
        '','','','','','','xiang ','','','','ru ','wang ','','','','ya ',
        '','','','','','','','','yu ','','','','','','','',
        '','','','','Mang ','Zang ','','','','','','','','','','',
        ],
    'x227':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Vung ','','','','','','','','',
        '','','','','','','','','','','','Xing ','Duo ','','','',
        '','','','','','','sao ','','Nao ','','','','','','','jia ',
        'tu ','','du ','','','','','','','','','','mao ','yao ','','',
        '','','','','','','','','','Vui ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','wu ','Fit ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'hai ','','','','','','','','','','','','','','','gao ',
        '','','','','','','fu ','','','','','','','liu ','','',
        '','','','','','Fit ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Chua ','','Nan ','','','Nep ','','','Chac ','Cham ','','','','','','',
        '','','','yang ','','','','','','','','','','','','',
        'ai ','teng ','','','','','','','','Nhuoc ','','','','','','',
        ],
    'x228':[
        '','','','Geng6','Sung ','Thung ','','','','','','','','','','',
        'Ngo ','','','','','','','','','','','','','','','',
        '','sao ','','','','Gan ','Hon ','','','Mo ','','shu ','','','','Lang ',
        '','','fu ','Bie ','','Tang ','','xiang ','','','','','','dang ','','',
        '','','dang ','','','','','','','','','','','ge ','yu ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhao ','','','','','','','','','','','','','','','',
        '','','Ghet ','','Ngung ','','','','','','','','chang ','zhe ','','',
        '','','su ','','','','','','','','kai ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Khan ','','',
        'Ngay ','','','','Quo ','','','','','','','','','','','ai ',
        '','','','','','','','','','','','','','','','',
        'liu ','','','','','','','Khuay ','','','','','','','','',
        '','','','','','','','','','Hung ','','','','','','chu ',
        ],
    'x229':[
        '','sao ','','','','','','','','','','','','','','',
        'liu ','','','','','','','','meng ','','zhan ','','','Cham ','','',
        '','','','','zhuang ','','','','','','','','','','','',
        '','','','','','','','','','Goe ','','','','','','',
        '','','teng ','zhu ','','','Lung ','','Lo ','','','','','','','',
        '','','','','','','Trai ','','xie ','','jiao ','','','','Chong ','',
        'Sung ','','','','','','','','','','','','','','','',
        '','','','','','','','Ngoi ','','','','','','','','',
        '','','Laan ','','','','','','','','','','qu ','','qiu ','Zai ',
        '','','','','','','','','','','hua ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','shu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','han ','ge ','','','','','','','','',
        '','','Ta ','','','','','','','','','','','','','',
        ],
    'x22a':[
        '','','','','','','','','','','','','','','','jue ',
        '','','','','','','','zei ','','','','','jie ','','','',
        '','','','','','hu ','hu ','','','','','chu ','','','','',
        '','','','','','','','','','','','','','','','',
        '','ju ','','','zhu ','','','','','','Quanh ','','','','','',
        '','','','ge ','','','','','','','','','Ho ','','','',
        '','','shan ','','Muon ','','Zit ','Hat ','','','','','','Thuon ','Dat ','jue ',
        '','','','','','','','','hai ','xia ','','','','','Chop ','',
        '','','','cu ','','','','','','','','','','','','',
        '','','','','','','','Vuc ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Ngat ','Vat ','Nang ','','','','','Muc ','','','','','','','zhang ','',
        '','','','Keo ','','That ','Vun ','','','','','','Tha ','','','Kam ',
        'jie ','','','','','Wing ','Trot ','','So ','','','','Trum ','Rung ','Quay ','',
        '','','','Bac ','','','Haku ','','Ngung ','','','Lat ','','nu ','','',
        'zhe ','','','','','zu ','','','','','','nie ','','','','',
        ],
    'x22b':[
        '','','','','Bung ','','','','','','','','','','','',
        'Muc ','','','','','','','Chui ','','','','','','','','',
        '','','','Tay ','Khuong ','Giang ','','','','','','','','','Vot ','',
        '','Khep ','','','','','','nan ','','','','','dun ','','','Kaai ',
        '','','','Dau ','','','Chou ','','','','','','','','','',
        '','Thuoc ','','','','','','','','','','','Xac ','','','',
        '','','','','','bian ','','','','','','','','','','Quet ',
        '','','','Giau ','Khuay ','','','Vom ','','Lan ','Dui ','Xoi ','','','','',
        '','','','','','','','','','','ya ','','','','','bang ',
        '','Luk ','','','','','','','','','','','','','sao ','',
        '','','','','','','','','','Co ','Ron ','','Chut ','Co ','','',
        '','','','','','','','','','','','','','','','Quay ',
        '','','','','','lu ,jue','','','','xie ','Dik ','','zhai ','','Ngaau ','',
        'Co ','','','Va ','Quat ','Ngoi ','Khep ','Quay ','Huo ','','','Sap ','Buoc ','Ven ','','',
        'Va ','Roc ','Sua ','','','','Lay ','','','','','','','','yu ','',
        '','Sau ','wan ','xue ','','','','','','ge ','','','','','mao ','',
        ],
    'x22c':[
        '','','','','','','fu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Wo ','','','','','Gap ','Zung ','pan ',
        '','','','','jie ','','','','jia ','','','','jia ','','Boi ','',
        'Gieo ','Waa ','','','','Dap6','','','','Cai ','Phung ','Xoi ','','Nhot ','','Sin ',
        '','','Saak ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Kek ','','','','','','','',
        '','','','','Bung ','','','','','','','','','Run ','','',
        '','Laa ','','Rung ','Cau ','','','Gay ','','Kap ','Mai ','Mo ','','','','',
        '','Cau ','Long ','','','Cou ','','Sou ','Lou ','','','','die ','','','zhu ',
        '','','Bat ','','','','Ngou ','','zu ','','','','','','','',
        '','lang ','','','','','','','','','','','Saai ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x22d':[
        '','','','','','','','Chap ','Daat ','','Chop ','Chong ','','','','',
        'Day ','','Paang ','','','Ning ','','','Xay ','','','','Xau ','','Nhung ','',
        '','','fen ','','','','','','','','','','ban ','','','',
        '','lei ','xie ,jie','','','','','','','','','','','','','',
        '','','','','Cou ','','','yang ','','','','','Deoi ','','','',
        '','','','Paang ','','','','','','','','','','','','',
        '','','','','','zao ','','Gaan ','','Doi ','','','Don ','','','',
        '','Khoi ','','Sum ','Quay ','','Don ','Cat ','Xap ','','','','Vot ','Ro ','','',
        '','','','','','Sip ','','','','','','','','Saap ','','',
        '','Niao ','guai ','','','','','','','','','','Ngung ','','','Cui ',
        'Saau ','','','Die ','Loe ','','','','','','','','','','','Maan ',
        '','','','','','','bang ','','Bum ','','Dom ','Bung ','Ngoi ','','','Don ',
        '','Nem ','Xan ','','','Tro ','Chen ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Ban ','','','','','','','','','','Deoi ','',
        '','','Hang ','','','Vo ','liu ','','','','du ','','','','','jie ',
        ],
    'x22e':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Lan ','','','',
        '','','','Niao ','','cuan ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Choc ','Gai ','Mac ','Rung ','','Xe ','','','','','yu ',
        '','Zaang6','','','','','','','','lan ','','','','','','',
        '','','','Keo ','Xau ','','','','Tum ','Suong ','','','','','','',
        '','','','xiao ','','','','','','','','','','Giam ','Que ','',
        '','','','','','','','yao ','','ta ','','Naan ','','','','',
        '','','Bung ','','Bau ','','','','','','','','','Uon ','','chan ',
        '','','','','','','','','','','','','','','','',
        '','','','Maan ','yu ','','','','','Chia ','Chia ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','cheng ','','','','','','','','','hai ','','','',
        '','','','','','','','','sa ','','','','','','jie ,fu','',
        '','','','','','','','','','','','','','','','',
        ],
    'x22f':[
        '','','','','','','','','','','','','bao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','qia ','','','','','','','','jiao ','','','','',
        '','','','','','','','','','','xue ','','','','','',
        '','','','','','','','da ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','mao ','','','','','','','','','','','jiu ','','',
        '','','','','Duk ','','','','','','','','Va ','','','',
        '','wei ','','','yu ','du ','','','','','cheng ','','','','','',
        '','','kuai ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','lu ','','','',
        '','','','','','','','','','','','','','','','wen ',
        '','','meng ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','man ','','','',
        '','xie ','luan ','','','','cheng ','cheng ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x230':[
        'lei ','','','','qun ','','','','','','','','','chen ','','cheng ',
        '','','Chong ','','','','','','','','','','','','','Va ',
        '','','','fu ','','','','san ','','','','','','','','sa ',
        '','','','','','','','','','','','','','','fu ','',
        '','','','','','','','','','','','','','dao ','','',
        '','','','','Lon ','','gan ','tan ','','','','','man ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','qia ','','','','','','','','','','','',
        '','','','','','','','','','','yun ','','','','','',
        '','','','','','','','','','','','','','xiang ','','',
        '','','','','','','','','','','','','xiao ','','','',
        '','','','dang ','','zhuan ','','','','','','','','','','',
        '','','','','','','','','','dang ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','yan ','',
        ],
    'x231':[
        '','','','','','','','','','','','','','','fu ','',
        '','','','','','','','','','Huang ','','','','yan ','','hu ',
        '','','','','','','','','','','','','','','','',
        '','','','','liang ','','','','','','wei ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Khuya ','Khuya ','','','','','','',
        '','jue ','','','','','','','','','','','','','','',
        'xiang ','','','','','Tam ','Luc ','','','','','','','','','',
        '','','','','','','','','','','','','','','','Phoi ',
        'Trua ','','xu ','','','xian ','','','','gan ','','','','','','',
        '','','','','','','','hao ','','','','','','','Chang ','',
        'Giay ','','','','','fu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Sao ',
        '','','Bie ','','','','','','dai ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x232':[
        '','','','','','','','','','','mu ','','','die ','','',
        '','','','Phoi ','','Mai ','','Ngay ','','','','Quat ','Ngay ','','Hong ','',
        'bian ','','Tia ','','','tu ','','','','','','','','','','',
        'Nau ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Ui ','Trua ','',
        '','','','','','sang ','','ang ','nai ','','','','','','Gou ','',
        '','','','','','','','','','ya ','','','','','','',
        '','','','','','Rua ','','','','','','','','','','',
        '','','','mao ','','','','','','','','Se ','','Mo ','Chop ','',
        '','','','','meng ','','','','','','','','','sang ','xu ','kan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Bay ','',
        'Sao ','Toi ','','','','','','','','yu ','dan ','','','','','pu ',
        '','','','','','','','','','','','','','','ai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Som ','','',
        ],
    'x233':[
        '','Trua ','Trua ','','','','Trua ','','','Khuya ','','Som ','Rua ','','','de ',
        '','','','','','','','','','','','','','Nang ','','',
        'chun ','','','','','','','','xun ','','','','','','','',
        '','','','','','','','','','','Xeo ','','','','','',
        'Nguc ','','','','','','','ju ','','','','Cui ','','Oam ','','cha ',
        '','','','','','','','','','','','yu ','','','','',
        '','','','','','','kuang ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Luo ','','','','','','','','','',
        '','','','','nian ','','','','','','hu ','','','','Trang ','',
        '','','','','','','','','','','','','','','','',
        '','','','','Dun ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','shu ','','','','','','','','pai ',
        '','','','','','','','','','','','','','','','',
        '','','','','Jan ','','','he ','','','','','','','Zai ','Then ',
        ],
    'x234':[
        '','','','','','Nhum ','Thot ','','','','','','','','','',
        '','','','','','','','','','','','','','Xop ','','',
        '','','','','','','','','','','','','','','','',
        '','','Queo ','','','','','','','','han ','','','','','',
        '','Cung ','hu ','','','','','','','','','','','','Roi ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Gian ','','','Sim ','','','','Nen ','','','','fu ',
        '','','dian ','','','','qiao ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Mang ','','','','','','','','','','','','',
        '','Xoai ','Sao ','Cong ','','','','han ','kuang ','','','','','','','',
        '','','','','','','','','','sha ,jie','','','Gou ','','','',
        '','','shan ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Lau ',
        ],
    'x235':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Cui ','Bap ',
        '','Pha ','Xoi ','Ngoc ','','Chanh ','Nhai ','','Kang ','','','','','','','',
        '','','','','','','','','','','mao ','','Gon ','','','',
        '','','','yu ','','pao ','','','','','','','','','','',
        '','','','','','','','','Hay ','','','','','','','',
        '','','','','','','','','','','','','Noc ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','yun ','','','','','','','','','',
        '','','','','','Peng ','Chay ','Chay ','','','Ca ','','','','','',
        'Suot ','Trac ','','ju ','','','','','','','qu ','','jue ','','ang ','',
        '','','','','','','','','','ru ','','','xun ','','','',
        '','','','','','','','','','','','','','','','',
        'reng ','','','Chua ','','','','','','','','','','','','',
        '','','','','','','','','','','Cha ','','','','','',
        '','','','','','','ta ','','','yang ','','','','','Son ','',
        ],
    'x236':[
        '','Ca ','','Cay ','Thot ','','','','Son ','Cum ','','','','','','',
        '','','','','','','','Nik ','','bang ','Seot ','','','','','',
        '','','','chun ','','','Yi ','','','','','','','','','',
        '','','','','','','','','','','','','','Nau ','Vai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Rac ','','','','','','',
        '','','juan ','','','','','','','','Mo ','Sop ','','','Chay ','Rui ',
        '','','','','jie ','zhe ','hu ','','Sot ','Con ','Mam ','','','','','',
        '','','','jie ','','','','pao ','','','','ye ','','','lei ','',
        'ru ','','','juan ','','Jaap ','','','','','','','','','','',
        '','','zhuan ','','','','jiang ','hao ','','','dun ','','','','','',
        '','','','','','','','','','','Hong ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Xanh ',
        '','Gu ','','Khay ','','Be ','','','','Then ','Tu ','hu ','','','','',
        '','Dom ','','','','','','','ze ','','','die ','','zha ','','',
        ],
    'x237':[
        '','','sa ','','','','','','','','','Mo ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','juan ','','','','ai ','','','',
        'Lim ','Son ','','','','','','','','','wen ','','','','Chua ','',
        '','','hun ','','','ai ','','','','Duoi ','','ta ','','','','gao ',
        '','yu ,yu','','','','','','hu ','','','','','10389.190,bian ','su ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Khu ','Cuoi ','','','dun ','','','','','','','Tram ','',
        '','meng ','','lu ','tan ','','','liu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'lian ','','','','','','','','','','','','','','','',
        '','','','Mong ','','','','xiao ','','huai ','','','','','','',
        '','liu ','wu ','','','','','','','','','','','','','',
        '','','','','','','','','','Dui ','','','Ran ','','','',
        'yu ','Kyo ','','','','','','','mei ','','lian ','','','lao ','','',
        ],
    'x238':[
        '','','','','','','','','','','','','','','','',
        '','','Tham ','Pheo ','','Chua ','Chua ','Que ','Gau ','','liu ','','zhao ','','','',
        '','','','','','','','','','Tram ','','','','','','',
        '','Tram ','','','','','','','','','','','','Ha ','','',
        '','','','','','','','','','yu ','','','','','cen ','',
        '','','','Tram ','','yan ','','','','','','','','Vui ','','die ',
        '','','','','Nen ','','','lei ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','xu ','','','','','',
        '','','yu ','','','','qian ','','','','','','','','','',
        '','','','','','dian ','','','','','','','','','','',
        'zu ','','','','','','chu ','','','','','','','','','',
        '','','','','','','','','dian ','','','','','','yu ','',
        '','','','','','','','','','','an ','','','','hun ','',
        '','','','dian ','','','','','','','','','','','sha ','',
        '','','xie ','','da ','','','','','','sha ','','','','','',
        ],
    'x239':[
        '','zhu ','','','','','','','ze ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','shu ',
        '','','','','','','','','','','','','','','','',
        '','','ta ','wan ','','','','','','','wang ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','guan ','','','','','','','','','','',
        '','','','tu ','','','','ta ','','chu ','','','zhu ','','da ','',
        '','','','','','','','','','','','','','Ngay ','','',
        '','','','','','','','','','','','','','','','',
        'chu ','chu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Laai ','du ','','','','','die ','','','','','','','',
        '','','','','','','','','','bai ','','dian ','','qiu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','nao ','','',
        ],
    'x23a':[
        'luan ','','die ','','qia ','','','mao ','','','','','','','','',
        '','','','wu ','tao ','','','','','','','zu ','ma ','','','',
        '','','','jiang ','xu ','','','Giuoc ','','','','','','Quan ','','',
        '','','du ','xiang ','','','','','','','','','','','','hun ',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','guan ','','','','','','er ','','','','','',
        '','','liao ','','','','Ngoeo ','shan ','','','','','','zhai ','','ye ',
        'diao ','','','','jiang ','','','','Toi ','huai ','yu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Ji ','','','','','','','','','','dian ','','','bian ','','',
        '','','','','','','','','gu ','','','','','','','',
        '','','','','','','','','hu ','','','','','','su ','',
        '','','','','','','','','','','','','dao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','xie ','','','Van ','','dai ','','','','','','',
        ],
    'x23b':[
        '','','guan ','','','','pei ','','','','','','','','jue ','juan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','ba ','ba ','','','','','','wu ','','',
        'bao ','','','Su ','','','','','','','','','','','','',
        '','','','','','','','','fu ','','','','','ge ','','',
        'ru ','','','','','','','','','','','','','','','Ria ',
        'Mao ','','','qiu ,qu','','','','','','','','Mau ','','','','',
        '','','','','','','','Ngu ','','','de ','','jie ','jie ','','',
        '','','','','','','','','','','','','','','','',
        'san ','','chun ','','','','nai ','','','','','','','','','',
        'de ','','','','','','','','','','','','','','','',
        'mao ','','','','','','','','','','','ru ','','','wu ','',
        '','','','','','','','','','','ta ','','','','','',
        '','','','','','','','','','men ','','','','','','',
        '','pei ','','','','','','','qu ','','','','su ','','','',
        ],
    'x23c':[
        '','','','','','','','','','','','qu ','','','','',
        '','','','','','sao ','','','kun ','','','','','','jie ','',
        'qu ','qu ','','','','meng ','','','','','','','du ','','','',
        '','','','','','','','','','','','qu ','','','','',
        '','','kun ','','','','Ho ','','','','','','','dan ','','',
        '','','','xiao ,hao','','','','','','','','','','','','',
        '','','','','','','','','','','','','Hoi ','','','',
        'Ram ','','','liu ','','','Vuc ','','','','','','','','','Nhop ',
        '','','','','','','','','','','','','','Ngut ','','',
        '','','','','','','','','','','','','','','','',
        'Ngot ','','','','','','','','','','','','','','','',
        '','','he ','','','','','Nap6','','','','','','','guai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','fan ','','','jie ',
        '','','','','zhan ','','','','Deoi ','','','','','piao ','','',
        '','','','','','','','','','','','','Doe ','','','',
        ],
    'x23d':[
        '','','','','','','','','','','','','','','','',
        '','','','jian ','','','','','','','Hup ','Nhung ','','','','',
        '','','zao ','zhuang ','','','','','','','','','','','','',
        '','','','','','','','','','','','','mao ','tan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Bung ','',
        '','','','','Ngam ','','','','zhu ','','','','gan ','','','',
        '','','','','','','','','','','','','','zhuang ','','',
        'pao ','','','','','','','','su ','','','','','ju ','','',
        '','can ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Loi ','',
        'Nhom ','','','','','','','','','','','','','','','',
        ],
    'x23e':[
        '','','','xu ','','','','bian ','','','','','','','huai ','',
        '','','','','','','','','','','she ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','Lut ','','Tran ','','','','','','qiao ,xiao','','Cong ',
        '','','','','','qian ','','','','xie ','','','hu ','','','xun ',
        '','','','','','na ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','tao ','',
        'qiao ','','','','','','','','','','','','','','','',
        'Nuot ','','','Bui ','','','','Xoi ','','Duoi ','','','','dang ,xiang','','',
        '','','','','','Ma ','','','','','shu ','','fu ','','','',
        'xie ','lang ','','','','','','','','zhe ','','','can ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x23f':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','','','ze ','shuai ','','','Bot ','','','','','Vui ',
        'Lung ','Ngau ','Doi ','Xop ','','','','Lot ','','','','','Tran ','Lang ','','',
        'Ngau ','','','','','','Veo ','','','ru ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','an ','jian ','','53066.030,teng ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Doi ','','','','Khoi ','','','Xoi ','Bui ','',
        '','','','Ngau ','','','fu ','','su ','','lian ','','he ','','','',
        'ze ','','','','','','','','','','','','','','','',
        '','','','xiao ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x240':[
        '','','','','','','','','','han ','','','','','','',
        '','','','Loc ','','','Ngoi ','Rua ','Vung ','','','','Tanh ','yu ','','',
        '','','','','','','la ','','','jian ','','','','','','',
        '','','bian ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Dao ','Khoi ','','','','Trong ','Bot ','','Chua ','','','','',
        'Dao ','dan ','jie ','bai ','','','xian ','','','','','','','','','',
        '','cai ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','zhuan ','','','','','Rua ','Dan ','Phun ','Loi ','Toe ','','',
        '','','','','','','','','','','lan ','','yao ','','','xuan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Leo ','','Muong ','',
        '','','','','','','','Thuot ','lan ','','','','','','','',
        '','','','','','','Deng ','','','','xun ','','','','','',
        ],
    'x241':[
        '','','','','','','','','','','','','','','','',
        '','fan ','','','','','','','','','','','','','','',
        '','','','','','ta ','','pan ','','','','','','','','Trong ',
        'Nhan ','','Can ','','','','','','','','','','','','','',
        '','','','','','','','','','','yan ','','','','man ','',
        '','','can ','','','','','','','','','','Veo ','','','',
        '','','','men ','','','','','','','','','','','','',
        '','','shuan ','','','','','','','','','','','','','',
        '','cheng ','','','','','','','','','','','','Chi ','','',
        '','','','','','','','','','','','','gua ','','xu ','',
        '','','','Saap6','','','','','','','','','','','','',
        '','','','','','','','','Tom ','','','','','','','',
        '','','','','','','','','','','','','Kho ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Say ','Phoi ','Tat ','','','','','Bep ','',
        '','','Nhum ','','','','','','','','','','','','Ying ','',
        ],
    'x242':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Lui ','',
        'Sot ','Ngut ','','','','','','he ','','','Cho ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','lao ','shao ','',
        '','','','Tro ','','Tro ','Se ','Heo ','Ngun ','','','Toa ','Rang ','','','',
        '','','','','','','','','fu ','','','kai ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Luk6','','','','','','','','','','','','','',
        'Roi ','','','Tro ','Nhem ','','','','','Rom ','','Phoi ','Phoi ','Lom ','','',
        'Ben ','','','','','','la ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhu ','','','','','','Ranh ','Nau ','Khet ','Kho ','','Phoi ','Kho ','Choi ','Um ','',
        ],
    'x243':[
        '','','su ','','','','','','','','','','','Hok ','','',
        'han ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','gan ','','','','','','',
        '','','','Hay ','','','Ngot ','Nau ','','Ngun ','','','','','','',
        '','Chong ','','shu ','','Jau ','','','','','','','zao ','','','',
        'Jit6','','','','Zhang ','','','','','','','','','','','',
        '','','','','','','Loa ','','','','','','','','','',
        '','','','','','','','','','','','','','Quac ','','',
        '','','Phap ','','','Tat ','','','','','','Ram ','','','','',
        '','','','','','','','zhu ','','','','','','','','',
        '','Zuan ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Nhoi ','','Ho ','Thui ','Khet ','Thap ','Se ','','Rao ','Buot ','','','','',
        '','chu ','Zhou ','','','','','','','','','','','','','',
        ],
    'x244':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Ham ','Nau ','','Soi ','','',
        'Luoc ','','','','','','','','','kai ','','','','','','',
        '','','cuan ','','','','','','','','','','','','','',
        '','','','xian ','','','','','Chang ','','','','','Hung ','','',
        '','','','','','Xun ','','','','','','','','','','',
        '','','','','','','','','','','','Bung ','Loe ','','','Sem ',
        '','','','','','','','ye ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Nung ','Nau ','','yao ','','Nhui ',
        '','','Lom ','','','','Sem ','','','','','','','','','',
        '','','','','Thap ','','','','','','','ta ','','','','',
        '','','','','','','Ram ','','','','','','','','','',
        '','','','Lo ','','','','','','','','','','','','',
        '','','','','','','','','','Ben ','','','','','','',
        '','','','','','','','','','','Vau ','','','','dao ','',
        ],
    'x245':[
        '','','','','','','','','','','','ju ','','','','',
        '','','','','','','','','','','shang ','Su ','','','','',
        '','','','bao ','','','','','','','','','','','','Vuot ',
        '','','','','','','','Danh ','','','','','','','','',
        '','','','','','','','','','','shen ','','','','','',
        '','','','','Cha ','','','','','','','','','','zhu ','',
        '','','','','','','','','','','','','','Jiang ','','Jiang ',
        '','','','','','','','diao ','','','','','','','','',
        '','','','','','','zhan ','','','','','','','','','',
        '','','die ','ze ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','he ','','','','ju ','','','','Lop ','','','','xiang ','','',
        '','cu ','','','','','Mui ','','Sip ','','','','','','','pei ',
        '','','','cheng ','','','','','','','','lian ','','','','',
        '','','','','','','','','die ','','shu ','','','','','',
        '','','Tam ','','','pu ','','','','Phuon ','','chan ','','','','',
        ],
    'x246':[
        'dao ','','','','','','','','','','','Nga ','','','','',
        '','','','Nanh ','hu ','','','','','','','chun ','','','','',
        'tian ','','','chen ','','','','','','','','','','','','',
        '','','zhuang ','','','hu ','','shu ','','','','','','','','',
        '','','','','','bai ','','','','','','','','','','qu ',
        '','','xie ','','zhao ','','','','','','','tu ','','','','',
        '','','','','','','','','','','','','','','Ngau ','',
        '','','','','Caau ','','','','','','','','','','','',
        '','','','','','mu ','','Nghe ','','','die ','','','','yu ','',
        '','','','','','','','','','','du ','','','','','',
        '','du ','','','mei ','','Co ','Sao ','','','','','','','','xiu ',
        '','','','','','bu ','','','','','','','','','','',
        '','','','','','','','Chan ','','','','','','','','',
        '','','','','','','','','','','','','','su ','Nghe ','',
        'Trau ','','ceng ','ta ','','','jue ','xun ','','','','','','qun ','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x247':[
        '','','','','huai ','','','zhan ','','','','','','','','',
        '','','','','ju ','ba ','lei ','','','','','','','','','',
        '','','','','zhe ','','','','','','','','San ','Tu ','','Kap6',
        '','','','','','21335.010,yan ','','hu ','','yu ','','','','','','',
        '','','mu ','','','','','','','','','','','','','',
        'hao ','Muop ','na ','','','','','','hu ','','','','','','Chuot ','',
        '','','','','','','','bao ','','','','','','','lu ','',
        '','','','','','','','','','Chu ','','','','','','',
        '','','','','','','','','','shu ','','','','','','',
        '','','','San ','Thac ','Tay ','','','','','','zang ','','','yu ','',
        'cha ','xie ','','','','','Moi ','Khon ','','','','','','','','',
        'qiu ','','hu ','zai ','jue ','','han ','','','','','Hum ','','','','an ',
        'zao ','','','sha ','','xian ','','','','an ','','','','zhe ','jue ','',
        '','','','','','','','','lu ','','','','','xia ','xiao ','',
        '','','dun ','','','','','','','','tu ','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x248':[
        '','','','','Ga ','Voi ','','ge ','','','','Trau ','','','','',
        'ta ','Lau ','','','','','','','','','su ','','','','','ta ',
        '','','','','','','','','','','fu ','','','','','',
        'Gau ','','','','','','','','','','','','','cu ','','',
        '','','','su ','','','','','','','','','','','','',
        '','','','','','','','','','','','Nanh ','','','','huan ',
        '','','','','','','','','','','','','','','Ran ','',
        '','','','','','','xu ','','','','','','','','','',
        '','huan ','su ','','','','','Vuot ','San ','','lu ','','','','','',
        '','','','ju ,qu','Nhen ','Dou ','','','su ','','','','','','','ze ',
        '','','','','','','','','','','Lie ','','','','','',
        '','','','','','ai ','','','','','xie ','','','Nhat ','','',
        '','','','','Beo ','','','','','','','','xiao ','','','',
        '','xie ','','','','','','','','','','','','','','',
        '','Doc ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x249':[
        '','','','','','','','','','','da ','','','','','',
        'su ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','wai ','','','','',
        'Vua ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','su ','','','liu ','','','','','','','','',
        '','','','','','','','','','','','','','Xa ','','',
        'mao ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Cung ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','yu ','Cong ','','','','','',
        '','','','jian ','','','','','','wan ','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x24a':[
        '','','','','','','','','','','','','','lu ','qu ','',
        '','','','','','','hu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','zhuan ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','hao ','xiang ','','','hao ','','',
        '','dian ,tian','ge ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','chan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','qia ','jiao ','','','','','','','','Dua ',
        ],
    'x24b':[
        'Dua ','','','','','','','','Hau ','','','','','','','',
        '','','','','','','','','','','','Lu ','','yan ','','',
        '','','','','','','wa ','zu ','fan ','','','','','','','',
        '','xu ','','','','','','na ','Sanh ','','','','','','','',
        '','','','','','','','','diao ','','','','','fan ','','',
        '','wu ','','','','','','','','','','','','','','fu ',
        'na ','','','','','','','','','','','','','','','',
        '','hu ','','','su ','','','','','','','','','xu ','','',
        '','','','Ang ','','','','','','','','','','','lei ','heng ',
        '','Be ','','','','','','Lo ','','','lei ','','shan ','','','',
        'Muong ','','','','','','','lu ','Lung ','','jun ','','','Chan ','','xie ',
        '','zhe ','','','','','','liu ','lei ','','','','dai ','','Ngot ','Ngot ',
        '','','','','','','Ngon ','','','','','','','','','',
        '','Lam ','','','','','','','','','','','','','','',
        '','','','','','','','','Song ','Song ','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x24c':[
        '','','','','','','','','','','','','','','','',
        '','pu ','','','','','','','','','','','','','','hang ',
        '','','','','','','zha ','','','','','','chao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','na ','na ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','diao ','','','','','','',
        '','','','','','','','xie ','','','','','','fu ','','',
        '','','Duoi ','','','','','','','','','','Ruong ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','juan ','','','','','','','',
        'mao ','','','','','','','','','','','','','','','',
        '','','','','','cha ','Trai ','Trai ','','han ','','','','','','',
        '','','','','','yu ','','','','','','','','','','',
        '','','Trong ','','','','','','Roc ','','','','','','','zhu ',
        'Ve ','Ruong ','','','lei ','','','','','','','','','Ruong ','','',
        ],
    'x24d':[
        '','','','','','','','','','','','','','die ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Ngat ','','','','','','','','Bot ','','huan ',
        '','du ','','','','','','','','','','','','','','',
        '','','','','','','','','','','du ','','','','','',
        'wu ','','wen ','','','','','','','','To ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Si ','','','qia ','','','','hai ','','',
        '','','','','','','','','Tay ','','','','','','Chau ','',
        '','Nhan ','Ben ','','','tun ','fu ','','','','','','zhuang ','','','',
        '','','','','','','','','','','','','','','du ','',
        '','chuan ','','','','','','','Naa ','Guoc ','','Nghen ','Mang ','Mut ','','',
        '','','fei ','jian ','','','','Wak6','','','','','','','','',
        '','jiu ','','','lun ','','','','dao ','de ','','','','','','la ',
        '','','ju ','','','','','','','','Mang ','Cek ','','','','Loet ',
        '','','','Nhom ','','','Buou ','','','wai ','','','','','','',
        ],
    'x24e':[
        '','','','','','','','','','','dai ','','','','','',
        '','fu ','Ngung ','','','','','fu ','','','','','','','','',
        '','','','','','','','Hoen ','','','','yun ','','','su ','',
        '','','','','','bu ','','qun ','','','','Naa ','','','','',
        '','','','','','','','','','','','jue ','','','','',
        'Lit ','','','','','','Hen ','','Nhoc ','Choc ','','chen ','','','','',
        '','','','hu ','teng ','','','','lian ','','','','','','','',
        '','','','','','','','','','','','','Buou ','Not ','','Ngo ',
        '','','','','','','','bian ','','','','','','','','',
        '','','','Bie ','','','','','','','','','','','','',
        '','','','','','','','Zang ','','','shan ','','','Buot ','Gua ','Mun ',
        'Khom ','','','','Buou ','','','','','','','juan ','lu ','','ao ','',
        '','','','','','','','','','','','','','','Cum ','',
        'Hom ','','Toi ','','','','','','','','','','','','','',
        '','','ai ','','','','','','','','','Nhoi ','','','','',
        '','lu ','','','','','bian ','','','','','','','','','',
        ],
    'x24f':[
        '','meng ','','','','','','','','','','chan ','','','','',
        'guan ,huan','','','','','','','jue ','lei ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ju ','','','','','Dang ','','','','','','','',
        '','','','','','huan ','','','','','','','','','','',
        '','','','er ','','huan ','','Nguoi ','','','','','','','','',
        '','','','chang ','','','','','','','','','','','','',
        '','zu ','','','','Phau ','','','Trang ','bai ','lu ','','','','','nian ',
        '','','','','zhu ','hu ','','','','','','','','','','',
        '','','','Tram ','Vang ','','','','','','','miao ','','','','Ho ',
        '','','','','','','','','','','','yao ','','','','',
        'Nguoi ','','','','','bie ','','','','','','','','','','',
        '','','Saai ','','cun ','','','','','','','','','','Pi ','nan ',
        '','','','','','','','wa ','','','','','','','','xun ',
        '','','','cheng ','','','Da ','han ','xiao ','','Zaap ','','','','','',
        'Trong ','','','','lu ','','','','','','','','','ta ','','',
        ],
    'x250':[
        '','du ','','','','','','','','','','','Giay ','','','',
        '','','','liu ','lu ','','','','','','','','','','','',
        '','','','xue ,qiao','','la ','','','','','','','Jim ','','','',
        'la ','','du ','Mo ','','lu ','','','','','','','','','xiang ','',
        '','','jie ','mang ','','','','','','','','','','','','',
        '','','Ngaau ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','diao ','',
        '','','','','','','','','','','','','','','','',
        '','Jim ','','ju ','','','','','','Trom ','','tu ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','hu ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'cha ','','','','','','','','','','','','','','','',
        '','Mam ','','','qu ','','','','','','Mam ','Mam ','','','','',
        '','','','','','','','','Vuc ','','','','','','','',
        '','Nhap ','','','','fan ','','','','chuan ','yao ','','','','du ','',
        ],
    'x251':[
        '','meng ','','','','','','','mu ','','','','','','Cik ','',
        '','fu ','','','','','','','','','','','','mian ','','',
        '','','','','','','','','','','','Gap6','','','Nham ','Ngom ',
        'Nhon ','','mie ','','Xue ','xu ,yu','','','','bao ','','','','','','',
        '','','','Nhon ','','','','','Laap ','','','','','','','',
        '','dian ','fan ','','','','','','','','','','','','','Ngaau ',
        'Hau ','er ','','','','','','','','','','','','','','',
        '','','Chau ','','','wei ','','','','','xu ','','','','Zong ','',
        'Giuong ','','','Nho ','','','','','','yu ','','','jue ','','','',
        '','','','','','','','','','','','xu ','wang ','','juan ','',
        '','','','','','xie ','liu ','','','','','','','','','',
        '','','nao ','','','','wan ','jiu ','','Ngop ','Dau ','Ru ','Le ','','','Quau ',
        'Mang ','Tro ','Bet ','','','','','','Nhon ','','','','han ,qia','','','xu ',
        '','','jie ','','','','','','jun ','','','','','','dian ','',
        '','','','Gwat6','','','','','','','','','','','','mai ',
        '','','','','','','Him ','','','','','Tro ','','','','xu ',
        ],
    'x252':[
        '','','','','chuang ','','mao ','','','huan ','sha ','','','','','kuang ',
        '','','','','','','die ','','','la ','','lu ','','','','Sou ',
        '','','','','','','','','','','','','','','leng ','',
        '','','Kip ','Chot ','Nguoc ','Nhon ','Nam6','','','','','','','','','',
        'guan ','ju ','','nai ','','ge ','','','','','ma ','teng ','','','','',
        '','','','','','','','','','','','','chen ','','','',
        '','','','','','','','','','','','','Let ','','Soc ','',
        'han ,qia','','','','','Ma ','lu ','','','','die ','','','','','',
        'Xam ','','','','','','','','','','xu ','','Caau ','','','',
        '','','','chan ','','','','','Ghe ','Zong ','','','','Chop ','Quac ','Nhan ',
        '','','','','Nguoi ','','Mu ','','','','','guan ','','zun ','','xie ',
        '','','','','Toet ','','','','','','','','','','','',
        '','','','','','','','Caang ','','','','','Sa ','','','',
        '','','Tre ','','','Trom ','','','Saau ','','','','','','','Xi ',
        '','','','jia ','','','','','','','','','','','','',
        '','','Lem ','Coi ','Ngam ','Him ','Lam ','','Soi ','','','','','','','',
        ],
    'x253':[
        'Xet ','','','','','','','','Trom ','','pan ','','','','','',
        'liu ','','','','','','','','','','','Lai6','','','','',
        '','','','','','Khoe ','Len ','','','','','','','xuan ','','meng ',
        'wei ','42521.120,meng ','','','','','','','Dim ','Ngam ','yao ','','','','','',
        '','','','','','','','','','','','','','Lom ','','',
        '','','Cham ','','lei ','','','','Nheo ','','bian ','Ngom ','','','','',
        '','','','hao ','','','','','','','zhai ','','','','','',
        '','ze ','na ','','','','','','','','','','','','','',
        '','','','','','','kai ','','wu ','','','','','ze ','','',
        'yu ','zan ','','','','xu ','','xu ','','','','','','','','',
        '','','cuan ','cuan ','cuan ','','','','','','','','','','','',
        '','','','','','','','','qia ','','tiao ','','','','','',
        '','','','','','','','huan ','','','','','','','','',
        '','','wu ','','','','','','jue ','','','','','ya ','','',
        '','','','','kua ','','','','','','','','','','an ','zhe ',
        '','','','','','','','','','','','','','','','Van ',
        ],
    'x254':[
        '','pu ','','','','','Van ','Ngan ','So ','Ngan ','','','','Ngan ','','Coc ',
        '','','Cut ','','Van ','ya ','','','Shi ','','','','','','Mong ','',
        '','','','','','','','','','yun ','','','','','','',
        '','','','','','','','','','','','','','zhe ','','hu ',
        '','','Chai ','','','','','die ','','','','guai ','','','','',
        '','ao ','','','','','','','','','','','','','','',
        '','','bu ','','','Sinh ','','','','','Nao ','','','','','du ',
        'guai ','','Ran ','','','','Loi ','','','','','','dian ','','','',
        'wu ','','','','','','','','','','','','','','','',
        '','','','','','','','','xun ','','','','','','','',
        '','','','','','','','ya ','lu ','','','','','chu ','','',
        '','','','kang ','','','hua ','','','','','','','','','',
        '','','','','Mai ','','','','','Sanh ','','','','du ','','',
        'jie ','','xian ,kan','','','','','','','','','','','','','',
        '','','','','','','','','','','','','dao ','','','',
        '','','','','Mai ','','','Canh ','','','','','','','','Tuo ',
        ],
    'x255':[
        'Gwang ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','yu ','','','','','','','','','','','','','',
        '','shan ','','','','Ji ','','','','','','','','','','Ham ',
        '','','','','Mai ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','zhe ','','','','','','','','','','','','',
        '','','jue ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','la ','','',
        '','','Quanh ','','','','','','','','','','','','','',
        '','','','','','','','','zao ','Cuoi ','','','','','','',
        '','','','','','','','','','','','','','','','du ',
        '','','','','','','','','','','','','','','','',
        '','','','ta ','','','','','','','dao ','','Chen ','','','',
        '','','','','','','','','Nen ','','','qu ','','ca ','','',
        '','','','','','xiang ','','','','','lan ','','','','','',
        ],
    'x256':[
        '','','','','yu ','','','','','','jiao ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','fu ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Rung ','','','','','','','','','','','','',
        '','','','xun ','','','ru ','','','Lay ','','','','','','',
        '','','','','','','','','','','','','','','','yu ',
        '','','jun ','','','','','','','','lu ','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhun ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','liu ','','','','','','','','','','',
        '','nu ','','','','','','','','','','','','feng ','lu ','',
        '','','','','','zhuan ','','zhe ','','','lu ','','','','','jue ',
        'liao ','','','','','','','','','','','','','','','',
        ],
    'x257':[
        '','','','','','','','','','','','','Ao ','','','',
        '','','Yan ','','','','','','','zan ','','','','','','',
        '','','','','','Yi ','','','','','','','','','jun ','',
        '','','','','','','','','','','','','','','','',
        'she ','','','','wan ','','','','','','','','','','','',
        '','','gua ','','jie ','','he ,xie','','','','','','','','','du ',
        '','','Li ','','','jie ','','ba ','yu ','','','','','','','',
        '','','','','','','','','he ','','','','','Cay ','du ,zha','',
        '','','','','he ','','','','','','','','','he ','','zhu ',
        '','','','','','','Giong ','','zun ','','ru ','Duo ','jiang ','','','',
        '','','','','','','','heng ','','','','','','','','zu ',
        '','','','','ku ','','','','','','','','','','','',
        '','','','he ','','','','','','','','','','','','',
        '','','','','','','','','','','chang ','','','','','',
        '','','','','','','','','','','mao ','','','','','',
        '','','','','','','','','','Lui ','','','Bap ','','','',
        ],
    'x258':[
        '','','','','','huan ','','','','','','','','','','',
        '','','','','','','','','','','','','yang ','','','',
        '','','','','','','','','','','','','Trau ','Giong ','Rom ','Rom ',
        '','','','','chang ','','','liu ','','jie ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','jun ','jiao ','','','','','','','','','','','',
        '','','','','Ji ','','','','','','','','','ai ','','',
        '','','','Nanh ','Mam ','','','','','','','','','','zun ','',
        'Cau ','','','','','','','','','','','','','','','hu ',
        '','','','','','','','','','','','','','','','',
        '','','cheng ','','','','kuai ','','ge ','xie ','','jie ','','','','',
        '','','','','','','zu ','','pu ','','','','','','','',
        '','','','','','','','','','','','meng ','','','','xiang ',
        '','','','','lu ','','','','','','','','','','','',
        '','','','','','','','','mu ','ran ','','','','','','',
        ],
    'x259':[
        '','','','','','','','','','','','zhe ','','','','',
        '','','','','','','','','jue ','','','','','','','',
        '','','','','','','ai ','','nu ','','','','','','','',
        '','','','','','mian ','','','','','','','','','','',
        '','','','','','Lung ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','wa ',
        '','','','','','','','','','','','','','','','',
        '','cheng ','','','','yang ','','','','liu ','','','','qiu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','fu ','','','','','','qia ','dian ',
        '','','jiao ','','','','','','','','','','','','','',
        '','','','','','','xian ','','','','','','','','','',
        '','','','','','','','','','','','','','','Hang ','',
        '','','','','','liu ','','','','','','','','','','',
        '','','','tu ','','','','','','Nup ','','','','','zhe ','',
        'hua ','','','','','','','fu ','','Tam ','','qu ','','','','',
        ],
    'x25a':[
        '','','','','','','','','','','','','liu ','fu ','dan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Trong ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Hoam ','','Chui ','','','','','','',
        '','','','','','','','','','','','','','ca ','','',
        '','','','zhu ','hai ','','','','','','','','','','','',
        '','','Hai ','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','','','','','','fu ','','','Trong ','Trong ','',
        '','','','','','','','','','','','','','','','',
        '','cu ','','','pang ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','dun ','','','',
        'lu ','Deon6','','','','','','','','chen ','','','huang ','shi ','','',
        ],
    'x25b':[
        '','','','','','','','','','','','','','','','',
        '','','','yao ','','','','','','ju ','','','','','','',
        '','','','','','','','','Khau ','Nia ','','','','','Giang ','Kao ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Mang ','Mau ',
        '','qiu ','dun ','','','','','','','','mang ','','','miao ','yuan ','',
        'wu ','','','','','','','','','','','','fei ','','meng ','',
        '','','','','','','Mang ','','','','','','','','','',
        '','','','','','','','Buong ','Hum ','Bu ','','','','','','',
        '','','','','','hang ','','ju ','nian ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Manh ','Tre ','Mui ','','',
        '','','Toi ','Trum ','','dang ','du ','','ye ','','','','','','','pai ',
        '','','','','','','jian ,sha','','','','Trau ','','','','yu ','',
        '','','','','','','','','zhu ','','','','','','','',
        ],
    'x25c':[
        '','','','','','','','','','','Thap ','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','shan ','liu ','','','','','','','hu ','','','','','',
        '','','','xian ','','','','','','','','mu ','','','zhai ','',
        '','','nu ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Ro ','','','','Ghi ','Gianh ','','',
        '','','','','','','','','','','','','','juan ','','',
        '','','','','dan ','','','dan ','','hu ','','','','','lu ','chuan ',
        'wu ','','','','','','','du ','','','shuang ','fu ','ju ','','','diao ',
        'wang ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','fu ','','','','','','xun ','','',
        'Khay ','','','','','','bu ','','','','','','','','','',
        '','fen ','dian ','','','','','','','','suan ','','an ','','','',
        '','','du ','','','','','','dan ','','','','','','','',
        ],
    'x25d':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Thung ','Mui ','','','','','','','',
        '','','','','','','','','ai ','ge ','ju ','tun ,dian','','qia ','','',
        '','jian ','','','','suan ','','','','','','qiang ','','','','',
        '','','','','','','','','','','','','','','','dian ',
        '','','','','','','Toi ','Hom ','Ray ','','Lak6','Nong ','','','jie ','zhu ',
        '','','','','zhao ','','','','','','','','','','','sa ',
        '','','','','','','','','','','','','','','','Mung ',
        'Thung ','','Gay ','','','liu ','','','','','','','','','','',
        '','','','','','','','','','','','','hu ','','','',
        '','','','','','','','','','','','','','','Toi ','',
        '','','','','','','','','','','die ','','','','','',
        '','ban ','','','','','hu ','','','','','','','','','',
        '','','','','yu ','die ','','','','','','','','','yu ','',
        '','','','','','','','','','','','','','','','',
        '','fu ','','','','','','','','','Mo ','May ','cu ','','','',
        ],
    'x25e':[
        '','Nan ','','','','','','','dang ','','','','','','','',
        '','','','','','','','','','','','','','Trum ','','',
        '','','','shan ','yu ','','','','','','yu ','','','','','',
        '','','','','','tun ','','','','','','','','','','',
        'Tam ','','','','','','','fan ','','Nap6','','','','zhu ','','',
        '','','','','yu ','','','','','','','can ','','','','',
        '','','','','','','','','','','','','','','','',
        'Lau ','','','','bu ','chu ','','liu ','Bot ','','','','','','','',
        '','','','','','','','','','','ge ','','','','','',
        '','Tam ','','Lo ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Com ','','','','',
        '','','','','','','','xian ','','he ','','','','','','',
        '','','','','','','','','','','Nam ','','','','bu ','No6',
        '','May ','','','','','sa ','','','mian ','','','','','','',
        '','','','','xia ','','','','Bun ','','','','','','','',
        ],
    'x25f':[
        'zu ','','','ze ','','','','','','','','','','','','',
        '','','','','','Lep ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','xiao ','','','Thung ','','','','','','','','','Com ','','xian ',
        'jian ','','','','Men ','','','','Miao ','','','','','','','',
        '','Phan ','','','Xia ','','','','','','','','niang ','','','',
        '','','','','','','he ','','lian ','','','','','','','',
        '','','','Men ','','zhu ','','','','','','reng ','jie ','','','',
        '','','','','','wu ','','','','','','cu ','','','','',
        '','','','','','','','fu ','hu ','','','','','','jue ','diao ',
        '','','','','','','','','','','','','','','Buoc ','',
        '','Vuong ','Tim ','na ','','','','','','','','','','','','',
        '','','','','','','','Giay ','','','','','','dai ','','',
        '','','','','Khau ','','','','','','','','','','','pai ',
        '','','','','','','','chao ','','','','','','','','',
        ],
    'x260':[
        '','','','','','','','Jing ','','','Dai ','','','','','Thua ',
        '','','','','','','Kep ','','','','','','zhuang ','','','',
        'liu ','','','','','','','','No ','','','','','','','',
        '','','','','','','','','mao ','Thun ','Xe ','Cui ','Noi ','Keo ','Rang ','',
        'Boi ','Nuoc ','','','','','zhuan ,juan,shuan','nian ','','','hua ','','','','','yan ',
        'jue ','','','','','','','','','','','','die ','','','',
        '','','','Go ','','','','','','','','','','','','',
        '','','','','','','','','','Ro ','','','May ','Vuong ','','',
        '','','','','','','','','','','fu ','','','','','',
        '','','','','wan ','','','Sok ','','','','The ','','','','',
        '','','','','','Dam ','','','','','','','','','','',
        '','','','','','','','','','','','Luot ','','','','Buoc ',
        '','','','','','','','','','','','','','','','',
        'Tao ','','','liu ','he ','','','','','','','','','','','',
        '','','','','mu ','','','','','','','','','','Gai ','',
        '','','','','','','','','','','','','','','','',
        ],
    'x261':[
        '','Thun ','Dai ','','Quan ','','May ','','','','','','Chap ','','','',
        '','','','Xau ','die ','','','','','','','','','','Van ','',
        'Nut ','','','Cuon ','','','','','','','','','','','','',
        '','','','','Chai ','','','','Xung ','','Rang ','Quan ','','qu ','','',
        'xun ','','','','zhe ','','dian ','','','','','','','','','',
        '','xun ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Tan ','',
        '','Thua ','','','','','','','','','','','','ju ','','yun ',
        '','','','','','','','','','','','lai ','','','','',
        '','','','','','','','','','','Neo ','','','','wu ','Mung ',
        '','','','','','','','','','','','','','','','Ban ',
        '','','','','','','','','','','','la ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Roi ','','','','','','','','','la ','','','','',
        '','','','','','','','','','','','','yao ','','Chung ','',
        '','','','','','','','','he ','','','','','','','',
        ],
    'x262':[
        '','','Nhau ','nang ','','die ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','yu ','','','','','','','','','','','','',
        '','','','','','','','','yu ','','','','','','','',
        '','','','','','','Cha ','','','liu ','','','','','','',
        '','','','','','','','','Caang ','bian ','','','','','','ya ',
        '','','','','','','','ya ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','hu ','cen ','','','','','','','','','','','','',
        'ju ','','','','','','','','hu ','','Bon ','Tu ','','','','',
        '','','','','','','fu ','hu ','','','','','','','','',
        '','','','','','','','','','','','','','meng ','fu ','liu ',
        '','','','','','xie ','','','xian ','','','','','','','',
        '','','','','lu ','','','','','','','','','','','',
        '','','yu ','han ','','','Ra ','','','','dan ','','','','','yu ',
        '','','','','','','','','','','','','','','','',
        ],
    'x263':[
        '','','','','','','','','','su ','su ','','','','','',
        '','','liao ','','','lu ','','','','','','','','','','lu ',
        '','','','','','','huan ','','','','','','','','','',
        '','','','','','','','du ','','','','','','','','',
        'nan ','','','','','quan ','','','','','','','','','','fen ',
        '','','ta ','tun ','','','','','','','','','','','','',
        '','','','','','','','','','Gu ','fen ','','','','','',
        '','','','','','','','','shan ','','','','','','','',
        '','','','','su ','','','chuan ','','','','','','','','',
        '','','jie ','','','','','','yu ','','','Guong ','chuan ','','','',
        '','Xinh ','','','','','wu ','','','','','','Tanh ','fu ','','',
        'gu ','','','','','','','','','','','','','','','',
        'ren ','','','','','jue ','','','','','','','','','','',
        '','','','Bon ','','du ','','hu ','','','','','yu ','','','',
        '','','mai ','','','','','','huai ','','','','','','','',
        '','','','','','','','','','','','yu ,yu','','','','',
        ],
    'x264':[
        '','','','','','','','Taap ','Fen ','','','','','','','',
        '','','','','','','','','','','','qu ,yu','','','','',
        '','fu ','','','hai ','','','','','','','','','','','',
        'chai ','','','','','','','','','','','','','','','',
        '','','','','','','','ta ','','','','zu ','','xu ','yan ','chai ',
        '','','','','','','','','','','','','ge ','','','',
        '','','','','','','','','','','','','','','','',
        '','','ta ','','','','ta ','','','fu ','','','','','liu ','',
        '','','','','','han ','','','','','','','','','','he ',
        '','yu ','','','','','','','','','','','Zin ','','','',
        '','','','','','','la ','','','','','','','','','',
        'tai ','','','','','Khu ','shu ','Bou ','','','dao ','','','','','',
        '','','','','','Gia ','','Khu ','','Lu ','','wang ','','','nai ','',
        'jue ','','','','','','','','','','','','','','','',
        '','Ma ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x265':[
        '','','','','','tu ','','','ze ','','','','','fu ','','',
        '','','','','','','','','','Cay ','','','','','','',
        'pai ','','','','','','kuai ','','','','','','qu ','','zhe ','sha ',
        '','','','','','','','','','nai ','','','','','','tian ',
        '','','','','','','ye ','','','','','','','','','sao ',
        '','','Zim ','xu ','','','','','','qu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'duo ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','hua ','','',
        '','Nghe ','','','','','','','','','','','','','','',
        '','','','','','','','yan ','','','','','','','','',
        '','','','','','','','','','','','Tai ','hu ','','','Dap ',
        '','tian ','','','','','','','','','','','','ai ','','Lang ',
        'ai ','zhe ','','lu ','','','','zhe ','','','','','','','Ghe ','',
        '','','','hu ','','','','','','','','','','','','',
        '','','','','','','','','','','','ju ','','','','',
        ],
    'x266':[
        '','','','','','','','','','','','','','wai ,wa','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Paa ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'pan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Moc ','Mao ','Hong ','Tim ','','','','','','','','ju ','dai ',
        '','','','','zhu ','Wan ','Gu ','','','ban ','','mai ','Ci ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Ping ','','','Zaap ','','','','','','','','','',
        '','','','hen ','','','','','','','','xie ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Ruot ','','','ku ',
        'na ','','','','xuan ','','','','he ','','Nam6','','Ham ','','','',
        '','','','','','','','','','','','','','','','',
        '','','jue ','','','','','','','','Bet ','Thon ','','','Nuc ','Mang ',
        ],
    'x267':[
        '','','','xu ','','','','','','','','','','pang ','','',
        '','','','','','','Ngaa6','','Vu ','','','','','','Ron ','',
        '','','','','','','','','','','','','','','','',
        '','','','','tun ','','','','','','','','','','','',
        '','','','','Rang ','','','','Ngac ','','','Mun ','Mep ','','Phop ','',
        '','','','','','','','','','','','','','huan ','','',
        '','Jim ','','','ban ','','','','','','','','tu ','','','',
        '','','','xu ','','','','','','','','','','','','',
        '','Tuoi ','','','','','','','','','','','','','Nghen ','',
        '','','','Phay ','','','','','','','','','','','','',
        '','','Tao ','Sao ','','zhe ','','','','','','sai ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Bo ','Zin ','Gay ','Suoi ','Khu ',
        '','','','tun ','','','','Nem ','','','','','ze ','','','',
        'cu ','','','','Xiu ','','','','','','','','','','','',
        '','','hun ','ju ','','','Nem ','','','','','','','','Khu ','',
        ],
    'x268':[
        '','cu ','','','','xun ','Sun ','ceng ','','','','','','','','',
        '','','jue ','','','','pao ','','Vai ','','','','','','','',
        '','','jiu ','zhe ','','','shu ','','','','','','','','','',
        '','Phet ','','','','Roi ','Seo ','','','','','','','','','sa ',
        '','','','','du ','','Fat ','','','','','Ron ','','','','',
        '','','','','','','','','','','','','','','Ngam ','Lung ',
        'Song ','','Rau ','','','','','','san ','','','','','yu ','','',
        '','yao ,shao','','','','hun ','Lom ','','','','','','','','','',
        '','','','','','','','','','','Pok ','','Duk6','','guang ','',
        '','','','Mak6','','','','','','','','','','','','',
        'Rang ','','','','','','','meng ','','','','','','','','',
        '','','','Vai ','Lot ','','','','','','','','','','','',
        '','','','','lei ','','','Lo ','','','','','','','Nan ','',
        '','','qu ','','','','','Nhau ','','Nang ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Zak ','','','','','','','lian ','','','','','','','',
        ],
    'x269':[
        '','','','','','','','','','','ru ','yao ','','','Gao ','',
        '','','','','','','','','','wa ','','','','','','',
        '','','','','','','Hot ','zhai ','','','','','hai ','','Thoi ','Kham ',
        '','','','','','','','','','','','','','','','',
        '','wu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Xue ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','fen ','','','','','','','','Kyo ','','xiao ','','','','',
        '','','cheng ','','','','','','','yu ','','yu ','','','','',
        '','','','','','','','','','','','','','juan ,fan','','',
        '','','','Lau ','','Weng ','','','','','','','','','','',
        '','','','','','','tian ','','hu ','','','ta ','','','ta ','ta ',
        '','','','','','ta ','','','','','','','huai ','','','',
        '','ta ','Loe ','','','hua ','','','zhuan ','','Laai ','','','','','',
        ],
    'x26a':[
        '','','Mua ','','','','','','fu ','wu ','','fu ','','','ta ','',
        '','Chai ','','','','','chao ','','','','','','Qua ','','','',
        '','fu ','','','','','jia ','','','','','','','','','',
        '','','','wu ','','','','','','','','Khoang ','','','','',
        '','','','','','','','','','','','bai ','','','','',
        '','','','','','','','','','','Mui ','Gu ','','','yu ','',
        '','fu ','xian ','','','','','','','','','','','','','',
        '','sheng ','','','','jian ','','','','','','','','','','sha ',
        '','','','','','','','lu ','Ao ','','','','','','','Thong ',
        '','','','','dun ','','','','jue ','ta ','zun ','','','teng ','','',
        'hua ','','','','','','','','','','peng ','','','','','',
        '','','','','','Ghe ','','','','','','Khoang ','Ghe ','','','',
        'teng ','','','','','','','','','','','','','','','',
        '','','','','','','','','','ba ','','','','','','',
        '','','','','','','','','','','wa ','','','','','xun ',
        'meng ','','','','','','','','','','','','','','','',
        ],
    'x26b':[
        '','','wu ','zhe ','','','','','','','','','','','','',
        '','','','','','','qiu ','','','','hu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','zhu ','','','','','','','',
        '','','','','','','','','hu ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Tup ','','','Hung ','','','','','',
        'ru ','','','','','','','','','','','jiu ','','','','',
        '','jiao ','','','','','','','','','','','','','','',
        '','pu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Nen ','','','','','fu ','','','','','','',
        '','','','','','xu ','','','','','','','','','','',
        '','zao ','','','','','','','','','','','','','','',
        '','','','cu ','','','','','','','xiao ','','Dua ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x26c':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fen ','','','','Ngon ',
        '','','Nua ','','Lau ','','','','','','qiu ','','','dun ','','',
        '','','','ye ','','','','','','','fu ','','','','','',
        'yu ','','yu ','yu ','Gu ','','','','','','','meng ','','','','',
        '','','mu ','','Bei ','','Fu ','','','','','','xiao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Nhai ','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','wan ',
        '','','','','','','','Lei6','','','','Rom ','','','Muop ','',
        '','hao ,mao','','xie ','','','','','','','','','','','','',
        'nai ,na','','','fu ','du ','','','','','Tre ','','','','','bai ','',
        '','','','xun ','','','','','','','','','he ','','','',
        '','','','','','','meng ','','','','','','','juan ','ru ','',
        ],
    'x26d':[
        '','','','','','','','','','hu ','','Mong ','jun ','she ','','',
        '','','','','meng ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Ke ','','','Nu ','','','','','',
        '','','','hun ','','','','','','','','','zu ','','','',
        '','','','','jie ','','','','','','','','jun ','','','',
        '','','','','','','','','','','','shan ','','','','',
        '','ta ','','','','','','','','heng ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Kou ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Chu ','','',
        '','','','','','','qiang ','','','Bom ','','','','','','Mai ',
        '','','','hu ','','','','hai ','ru ','meng ','','','','wu ','','',
        ],
    'x26e':[
        '','','','','','','','','','qia ','','','','','','',
        'lu ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','pei ','','','','','',
        '','fu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','zhao ','','','','',
        '','','','Thom ','','','Voi ','Bui ','','Nhai ','','Dam ','','','','',
        '','','','','','','','du ','','','','','','','','',
        '','','','','','','ju ','','','','','chuan ','Lao ','','','hu ',
        '','','jie ','xiang ','','','','','xiang ','','','lang ','','','','',
        '','','shuan ','','','chu ','','','','','','','','','','',
        '','dan ','','','','sa ','','','','','','','','','','',
        'Zaau ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x26f':[
        '','','','Sang ','','','','','ju ','','leng ','lu ','','','','',
        '','','','','','','','','','','Lum ','San ','San ','','Dua ','Khay ',
        'Sung ','','she ','','','','','sa ','','','mao ','qu ','','','','Zuk6',
        '','juan ','','','','he ','','','','','','mei ','','','','',
        '','','lu ','mian ','dian ','','','','','','Waa ','','','','lu ','fu ',
        '','','zei ','','Om ','','','','','','','','dan ','','wan ','',
        '','','','','','','','','','','','','','','','',
        'Tranh ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','sha ','','','','lu ','',
        'Dua ','','','','','','','','','dan ','','','','','','',
        '','','','','','','jian ','lu ','','','','','','ta ','','',
        'chu ','fu ','','','','','dang ','','','','lu ','','','','','',
        'jie ','','','','','','lu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x270':[
        '','','','','chang ','','meng ','','','','','','su ','','','Sung ',
        '','Giong ','Non ','Ru ','','sa ','','','','','','','Sam ','','','',
        '','zhan ','','','','','','','Lop ','','','','','','','',
        '','chai ','','','','','','','','','xie ','','','','','',
        '','','','xu ','','','','','','fan ','meng ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Ghem ','','','','','','','','','','','',
        '','zhan ','jian ','han ','dan ','','jian ','','','','','','','','','',
        '','','','','hu ','','','','','','','meng ','ju ','','','',
        '','meng ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Dua ','','','','chu ',
        '','','','','','','','','','','','','','','','',
        'yu ','','','','','','','','','','','','','','','',
        '','','','','','','Muong ','Khoai ','','','','','','','','',
        ],
    'x271':[
        '','','','','','','','','','','Han ','','','','','fu ',
        '','','qu ','','','','','','','','','ju ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Mo ','','','','','','','','','','','','','',
        '','','','','','','','','diao ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Men ','Muong ','','',
        'hu ','','','','','','','','','','nang ','','','','','',
        '','','','','Thuoc ','','','','','','','','','','','',
        'gan ','','','','','','','','','','','','','','','',
        '','xu ','','lu ','','','','','','','','','','','','hu ',
        '','','','','','','','','','','','','','','','',
        '','','','','lu ','','','','zu ','','','','','','he ','',
        '','','','','','','','','','','','','','shu ','','',
        'yao ','','','','','','','','','','','','','','he ','',
        'hu ','','','','','','','','','','','','hao ','','','zu ',
        ],
    'x272':[
        '','','','','xia ','','','','','','','','ge ','','','',
        '','ge ','','','','','ge ','','','','42573.210,zhu ','','teng ','ya ','','',
        '','','','','','','','','','','','','','wu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','tai ','','','','','','','','Trun ','Vat ','','','','','',
        '','','xue ','yu ','fan ','','','','','bu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Gwaai ','','dai ,de','','Buom ','Nhong ','','','','Vat ','',
        'Trut ','','','','','','','','ku ','','','qu ','','','','ru ',
        '','','','','','xu ','','','','','','','he ','','','',
        '','','','','','Gong ','Doe ','','','','','','','','','',
        'Chau ','','','','','','','','','','Saa ','','du ','Zhe ','','',
        '','','','kao ','','','','','','','','','','','','Moi ',
        '','na ','','','','','Mei ','','','','','','','','','',
        '','','','','','Cuong ','Mot ','','','','Chay ','','Nhong ','Mang ','','',
        ],
    'x273':[
        '','','Bo ','','','','','Bang ','fu ','lu ','','','','lu ','','ta ',
        '','','','Fu ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Cua ','','','','','Ngai ','','','','Cua ',
        '','','','shuai ','','jue ','','','','fan ','','','','','','',
        'jie ','','','','','','','','','jie ','yu ','','','','','feng ',
        '','die ','','','lian ','hu ','','','','','','','','','','dian ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Chau ','','',
        '','','','','','shan ','','','','','','','','','','',
        '','','zu ','','zhe ','','','','','','','','','','','',
        '','','xie ','xie ','','','','','','','','','','','','',
        '','','','liu ','','','','','','','','','','','','',
        '','','','','','jie ','','','','','','sha ','','','','Nhuc ',
        'Sam ','','','Bo ','Choi ','','','Nhuc ','','ai ','','','','','','zhu ',
        ],
    'x274':[
        '','su ','','xie ','yu ,yu','Zeoi ','','','zu ','','','','','','','',
        '','','su ','','','','Luon ','','','wu ','','','','','','',
        '','','Hou ','','','','','','','','','','','','','',
        'du ','','','lu ','su ','','','','','','','','','','Bo ','Sung ',
        '','Sam ','','Ngao ','','Vet ','Chang ','','','','','','','','','',
        'yu ','','Giun ','','dai ','','','','dang ','zu ','','','','chuan ','','',
        'du ','','','','','','xie ','zhe ','','','','sao ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','fu ','','','Buom ','','Sau ','','Rua ','','Rom ','Rua ','Rua ','e ','',
        '','','','','','','','','','fu ','','','lei ','','','',
        '','','','','','','','','chai ','','','','','','','',
        '','','','','','','','','','','','','','lei ','','zei ',
        '','ai ','','','','','','','','','','','','Ban ','','',
        '','','','','','','fei ','','','','','','','','','',
        '','','','','','','','','','','','','','','','Ngoe ',
        'Sam ','','','','','','','','','','','','','','','',
        ],
    'x275':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ta ','','','','','','','','','du ','qiu ','','',
        '','','','','chai ','','','','','','','','e ','','','',
        '','','','','','','','','','','','','','','qu ','',
        '','','','','','','','','','','Trai ','','','','','',
        '','fu ','','','','','','chai ','zang ','','','','','','','',
        '','','','','Naan ','','','','','','shuang ','','','','','',
        '','','','','','','ta ','','','','','','','','','',
        '','','','','','','','','','','fu ','','','','','',
        '','','','','','','Moi ','','','','','','','','an ','',
        '','','','','','','','','','','','','','','','xiang ',
        '','','','','','','','','n ','','','san ','hu ','','zu ','',
        '','','','','','','','Jiku ','','','','','','','','',
        '','','','','','','','','','la ','yu ,qu','jue ','','','','',
        '','shu ,yu','','','Jung ','','','Jutsu ','jian ','','','','','','','shuai ',
        ],
    'x276':[
        '','','Chong ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','hu ','','','','','','','','','','','','','',
        '','','','','','','','','','Taai ','','','','','','',
        'La ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','pu ','','che ','','',
        '','','','','','','','53077.090,jian ','','','','','','zhan ','yuan ','',
        '','','','','','','yu ','','','','','Lot ','','','','',
        'mu ','huan ','','','e ','Long6','','','','','','peng ','','','','',
        '','','','','Tung ','','','','','','','','','','','',
        'Song ','','Xong ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Trang ','Lun ','May ','','','','','','',
        '','','','','du ','','','tu ','','','','','','','hu ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Toi ','','','','','','','','',
        ],
    'x277':[
        '','Sha ','','','','','','','','','','','','','','',
        '','','','','','','Chan ','Mo ','','Xong ','','','','','','',
        'shuai ','','','','','','su ','','','','','','','','','',
        '','','','','','','','','','','Bau ','','','','','',
        '','','','jue ','','','','','','','','','','','','',
        '','zhan ','heng ','','qu ','wei ','','','bao ','','','','','','Gei ','',
        '','','','','','','','','Cheo ','Toang ','','','','','','',
        '','','ju ','he ','','','','','','','','','','','','',
        'shu ','','','','','','','','','','','','','','','yu ',
        '','meng ','hu ','','','','','','','','','','','','','',
        '','','','','','','','','','jie ','La ','shu ','jie ','lei ','','',
        'zu ','','','','','','','','','','su ','','','','','',
        '','','','xie ','','','','','','','','','','','','',
        '','','','','','','','','nang ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x278':[
        '','','','','','','','','cha ','','mao ','','','','','',
        '','','xian ','','','','','','','','','chan ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','gao ','','','',
        '','','','','','','','','','','Thay ','','','','','',
        '','jiu ','','','','','','','','','','','','','','',
        '','yun ','','','','','','','','','','','','','','',
        '','','','','lian ','','','','','','','','','','','',
        '','','','','','','','','','','','lao ','','','','',
        '','Don ','','','','','','','','','','','','Lai6','','',
        '','','yao ','','','','','wei ','','','','','','','','',
        '','','','','','','chu ','','','','','','','e ','','',
        '','','','','','','','','Caau ','','','','qiao ','','','',
        '','','ju ','','','qiu ','','','','','','','','','','',
        '','','hun ','','','','','Dia ','','','','','','','','',
        '','','','','','lun ','','','jue ','','','ju ','hu ','','','',
        ],
    'x279':[
        '','','','','','','','','','','','','','','','',
        '','ju ','','','','qiu ','','','','','','','','','','',
        'zhe ','','','','','','','','','','','','','Ba ','','',
        '','','','','','','','','','Thoi ','','','jue ','','','',
        '','','','Choi ','','','su ','','','','','','kuang ','','jue ','',
        '','','','','Va ','','','','','','','','','','tan ','',
        '','','','','','','','','','','','','','','','hu ',
        '','fu ','','','yang ','','','ren ','','','Kwan ','','yun ','','','xun ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','pu ','',
        'Ngaak ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Beng ',
        'Ngoa ','','','','wang ','','','','','','','','','','','',
        '','','','xu ','','','','','','','','','','Ngaa6','','',
        '','','','','','','','','','','','','','','','Khoang ',
        '','','','','','','tu ','','bie ','','','zha ','','','','',
        ],
    'x27a':[
        '','','','','','','','','','','Zaa6','','','','','',
        '','','','','','','','','','','','','','','','',
        '','chen ','','','','','','','','','','','','','','',
        '','','','','','','','','','lu ','','','','','Tam ','',
        '','','','','','yan ','','','','','','','','','','',
        '','','','','','','','','','Daan ','','','','su ','','',
        '','','','','','','','','','','','','','','','',
        'bian ','','la ','','','','qia ','','','','','','','','','',
        '','','','','','nu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','he ,ge','',
        '','','','','','','','','ma ','','','','','','','',
        '','','','','','','','','','xia ','','','','','','',
        '','','','','','','','','','','yu ','','','','','',
        '','jie ','xia ','','','','','cha ','','','','yang ','','','','',
        '','','wang ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Mo ','','jiu ','',
        ],
    'x27b':[
        '','hao ','','','','','','','','','','fa ','','','','',
        '','','','','','','','','','','','','','','yun ','',
        '','','','','','','','','Wai ','','gun ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','dan ','','','','','','','meng ','','','','','',
        '','','','','teng ','','','','','','','','Leoi6','sa ','','',
        '','','','','','','','','','','','','','','','',
        '','','','he ','','','','','','','','','','shan ','','',
        '','','','','','','','','','','','','','','','',
        '','ta ','','','','','','liu ','','','','','','','','',
        '','','','','','','','','','','','jue ','','','','',
        '','fen ','','','','he ','','','','','zhan ','','tai ','qian ','','',
        '','','','','Hang ','Hang ','','','','','','','','lao ','','',
        '','','','','','','jun ','','','','','','','','','',
        '','','','','','zai ','juan ','','','chu ','','','','','','',
        'kan ','','','','','Phong ','','','','','','','','','','',
        ],
    'x27c':[
        '','','','','','','','yu ','wu ','','Tian ','','','','','',
        '','','','','','','','Nanh ','','','','','','','','',
        '','','','','','','','Shuu ','','','han ','chu ','','tun ','','',
        '','','','','','','','','','na ','','','','','','ai ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','mai ','','','','lun ','jue ,jun','','',
        '','','','','','','','','','','','','','','','',
        '','','','huai ','','','','','','','','','','','','',
        '','','','','','ceng ','','hu ','','','','ju ','sha ','meng ','','',
        '','','','','','','','wei ','','','','','','','','',
        '','','zhe ','','','hu ','','','','','','Cop ','','','','',
        '','','','','','qu ','','','','','','','Beo ','','','',
        '','','fu ','','','','','Cop ','','','','','','','wu ','pei ',
        '','','','','','','','','Hum ','','','sha ','','zhao ','wei ','',
        '','','','','','','','','','tuan ','','','mei ','','','',
        '','','','','','','','','gu ','shao ','','','','','','',
        ],
    'x27d':[
        '','','peng ','','','','','','','','huan ','Beo ','fu ','','biao ','',
        '','','','','','biao ','','','','','guai ','','','','','',
        '','','','','','pei ','','','','','Suo ','','','','','Me ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Qua ',
        'pai ','','','','','','','','ai ','','','','','','','',
        '','','','She ','','','','','','','','','','','','',
        '','','','','Zaang ','','','','','','yun ','','','xu ','','',
        '','','','','cheng ','','','','','','','','','','','',
        'yu ','','','','','','','','','','','','','','','',
        '','','','','','cha ','Faan ','ze ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'fen ','xie ','','','','','','','','','','','','Xoe ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','shan ','','Mua ','','','','','','ju ','',
        ],
    'x27e':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','Zhuan ','xue ','','','','','','','','',
        '','','','','','','lan ','ju ','','xun ','zhan ','gun ','','','','',
        '','','','','','','','','','','','Bui ','','','','chai ',
        '','','','','','','','','reng ','','','Vay ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Son ','','','xu ','','',
        '','Tham ','hu ','gan ','','','','','','','','','','','hu ','',
        'Tham ','Tham ','','','','','','','','','','','','','','',
        'jue ','','zu ','','','','','','','','','','jiao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','chu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','xian ','','','','','ju ','','Mut6','','','','','','',
        '','','','','','','','','','','','','','','','',
        'hu ,zao','qiu ','','fu ','lang ','sha ','','','','','','','','','','',
        ],
    'x27f':[
        '','','','','','','','','','','','','','Lanh ','','',
        '','xu ','','','leng ','','','fu ','','','','','cu ','','','',
        '','','','','dao ','','','','jie ,jue','','','yu ','','','Tang ','shu ,yu',
        '','','','','','','','','','','','','','','','',
        '','','','','jie ','','','Day ','Day ','','','','','','','',
        '','','Cau ','','','','','','','','','','','','','jie ',
        '','','','','','lu ','','chu ','','','','lian ','','','','',
        '','','','','','','e ','su ','Jue ','','','ju ','','','','',
        '','','','','','','xuan ','','','','','','Tron ','','','',
        'jiao ','','','','','','','','','','yu ','','','xun ','','',
        'xun ','','','ju ','','du ','','','','xun ,xuan','','','','','','jie ',
        '','qu ','','','','jue ','','','','','','jiu ','','','','Treo ',
        '','','','','','','','','','ku ,wu','','ku ','zha ','','','ba ',
        'Chen ','Nhac ','Dam6','hu ','nu ','e ','','','','','','','','','','',
        '','','','','','bie ','','','','ge ','','Tau ','','','','',
        '','','','','','','','yu ','','Mau ','Xoat ','ju ','','','','',
        ],
    'x280':[
        '','','','','','','','','Buoc ','','','','','Dung ','Lop ','',
        'Rong ','','','','','','hai ','','','','','cun ','','','','',
        '','','','Kei ','Leoi ','','','','','','','','zai ','','','',
        'Bang ','','','','xun ','','','','','','','','','','','',
        '','xuan ','xie ','','han ','','','tun ','Gaang ','','cen ','','','Ren ','Choanh ','',
        '','','','','','','','','','','','','','Buot ','','',
        '','Noi ','','','','','','Noi ','Cuong ','','Dau ','','','','','',
        'Xui ','','','','','','','','','','','','Bon ','de ','','',
        '','','','peng ','','','','','','','','','','','','',
        'Leoi ','','','','Doc ','','','Co ','','','','','','','tan ','',
        '','','','wu ','','','chuan ','','','','','','','du ','','',
        '','hun ','','','','','','','','','','','','Dam6','Naam ','',
        '','','','','','','','','','','','','Giay ','Tot ','','Xam ',
        'Giay ','','','','','Soc ','kua ','teng ','','','ta ','sa ','','','Pun ','Pun ',
        '','','','sao ','','','','','','Sin ','','','','zu ','','',
        '','','jie ','neng ','','','','Chuc ','','','','','To ','Nhuc ','Xung ','',
        ],
    'x281':[
        '','','','','','','','','','','Te ','','','','','',
        '','','','','shuan ','zu ','','','','','','','','','','',
        'Tat ','','','','','','','','','','','','','','','yu ',
        '','','','','Sup ','','','','','','Chui ','','','','Ghe ','Giong ',
        '','Sup ','Mop ','','','','','','','Lung ','','xiao ','','Ren ','','Laam ',
        '','','shu ,chu','','','','','','','','','','','Jaang ','Nhap ','',
        '','','','','','Bay ','','','','','','','','','','',
        '','','','','','','','Doi ','','','','','','','Sum ','',
        '','','Khum ','','zhu ','','','cha ','juan ','','','','','','zei ','',
        '','','','','','','','','','','','','','Cui ','','',
        'Quay ','Dep ','','','','Tuon ','','','','','Jaang ','','','','','Buk6',
        'ta ,da','','','','','','','','','','','','','','','',
        '','kuang ','','','','bao ','lai ','','','Leo ','','','','','','',
        '','','','','','','lu ','','','','','','','','','',
        '','','','','','','chan ','','','zhan ','','','','','','',
        '','','','','','Nhao ','Khuy ','','','','','','','','','',
        ],
    'x282':[
        '','','','','','','','Laam ','die ','','','','','','','',
        '','','','leng ','','','','','','','Pei ','','','','','',
        '','','','','','','','','','','','zhu ','','','','',
        '','','','','','','','','','','ye ','','','','','',
        '','huang ','','','','','','','','Pei ','','','','','','',
        '','','','','','','Nei ','','','','','','','','Lung ','',
        'Ban ','','','','','','','','','','','','','mei ','','',
        '','tang ','','','','','','','','','','','Wu ','xiang ','','',
        '','','','','','','','','','','','','Lan ','','','',
        '','','','','','','','','','','','Laak ','','','','',
        '','','','','','','','','','','','','','','','',
        '','yu ','','','','','','','','','dai ','','xuan ','','','jue ',
        '','','','','','','','','du ','','','','','Wan ','','',
        '','','','','','','','','zha ','','','pao ','','','bu ','he ',
        '','','Lip ','','So ','','','ju ','hun ','','','','','','','Zhuai ',
        '','','','','','','','','','','','','','','','',
        ],
    'x283':[
        '','','','','zang ','','','','','','','','','','xu ','',
        '','','','','','','','','jun ','','','','','','','',
        'lu ','','','','','fu ','','','','Tang ','','','chao ','ta ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Co ','','','he ','','','','','','','mu ','',
        '','','xian ,jian','','','','','','','','','du ','','','','',
        '','','','','','','Sau ','','','peng ','','','','','','ju ',
        '','','','Yao ','','','','','','','','','','','','',
        '','','','','','','So ','','','','','','','','','',
        '','','','','yang ','','','','','','','','','','','Truoc ',
        'Truoc ','','','','','','','peng ','','','','jian ','jiao ','','','',
        '','','','peng ','Dang ','','qu ','','mu ','','','','','','fen ','',
        '','','','','','','','','','shuan ','jian ','','','','','',
        '','','','','lu ,du','','','','','','ge ','','','','','',
        '','','','','','xian ','','So ','','','','','','','','',
        '','','','xie ','ge ','','','','','jue ','','','','','','',
        ],
    'x284':[
        '','die ','','zhe ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','ku ','','qu ','','ge ','ban ','','','','','','','','Cay ','',
        '','ban ','','','','','','','','','','','','','ban ,bian','',
        '','','','','','','','','','','','','chen ','','','',
        '','','Tu ','','','','','','','','','','Xuong ','','','',
        '','','','','','wu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','pan ','','','','','','','qiu ','','','','','',
        '','','','','','','','','','','','','bie ','','kan ','',
        '','','','','','','','','nai ','','','','','','','',
        '','','','','','','','','','','Quanh ','','','','','',
        '','','','','','','','','','','die ','','','','','',
        '','','','','','','','','','','','','','','dai ','',
        '','Lung ','','','','','','','','','','','','','','',
        'jie ','','','','ya ','','','','','','','','','','','pei ',
        ],
    'x285':[
        '','','','','','','','','Choi ','','Suot ','','Co ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','shu ','','','','','','','','','ta ',
        '','','','','','','','','','','','','','','','Chuc ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'ze ','','chu ','','','','qiu ','','','','','','','','','',
        '','','','','','','','','','','','','','jie ','','',
        '','','','','','Sang ','','','','','','','yang ','','','jiu ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Mau ','','','','','','','','',
        '','xian ','','','','','xiang ','sha ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','dao ','','','','','','','','','Nhanh ','yu ,ju','','',
        '','chao ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','da ','',
        ],
    'x286':[
        '','','jiu ','','','','','','','sha ','','','','','','',
        '','','','','','','','','','xian ','','','','','xian ','',
        '','','','','','','','','','','','','','','jiu ','',
        '','Nhanh ','','','kao ','','','','','','','','','','','',
        '','','','','','','','','','','','','','Keo ','ta ','zan ',
        '','','','','zhu ','','Suot ','','','','','','','Lui ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','xiang ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','bian ','','','','','','','','','','',
        '','','','','','','','qie ','','','','','','','hao ','',
        '','','cun ','','ru ','zai ','','','','','','','','','','',
        '','','','','','','','','','','','','','shao ','han ','',
        'jun ','','bu ','','','','kuai ','','','','','','xiang ','','','',
        '','yun ','','','','pu ','','','','','','','pei ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x287':[
        '','','','','','','','','','','','','huan ','qiao ','','',
        '','','','','','','yu ','','mei ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','he ','','','he ','','','','','','','','','','chuang ','xu ',
        '','','','','','','','','','','','zhai ','','','','',
        '','guan ','','','','','','','','','','tu ','shun ','','hu ','',
        '','','','','','','dang ','','','','','','','feng ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'cheng ','','','yu ','','zhu ,chu','','qun ','','qu ','','ge ','','','','',
        '','','','','','','','','gai ','','','meng ','','','','',
        '','','','qu ','','','','','','','','','wan ','lei ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','dai ','','','','','','','','','','','qiu ','','',
        ],
    'x288':[
        '','','','','','','','','','Tam ','','','','','','',
        '','','Faan ','','','','bao ','','','','','','','','','',
        '','','','','','wei ','','','','','','','hao ','','','',
        '','','Giam ','Gay ','Sua ','Xoang ','','','','','','','','','','',
        '','','','jiao ','','','','','','Dam ','','','nei ','','yan ','',
        '','','','','','','','zha ','','','','','','','','',
        '','','','yan ','','','','','Gay ','','','hun ','','mu ','','',
        '','','','','','','','','','','','','Giam ','','','',
        '','','','','','','','liu ','han ','','meng ','hu ','','','','',
        '','','','','','','','','','','','','','','','Cay ',
        'meng ','','mu ','','hu ','Mi ','shai ,zha','','','','chao ','','','','','nian ',
        '','','','','','','','','','','','','','','','',
        '','','','','','chuai ','','','','','','','','','','',
        '','','','','','','','hu ','meng ','pao ','','','','','','',
        '','','','','Giam ','Dau ','Zeoi6','','lan ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x289':[
        '','','','','','','','','','','','','','','','',
        '','juan ','','','','','','','','','','','','','','',
        '','guang ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','jie ','','','','','','','','','','','','','',
        '','','','','','','','','','','','hu ','','','','',
        '','','','cen ','','','','','','','','','','','','',
        '','','','','','','dai ','','','','','','','','','',
        'Keo ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','','','Nen ','','','','','','Lao ','','',
        'liu ','','','','','','','','','','','','','','','',
        '','','','','','','Bua ','','','','','','','','','',
        '','xiang ','','','','bian ','','wu ','','','','','Bong ','','','',
        'Gang ','','','Xot ','','','','','','','sao ','','','','','',
        'zu ','','','','','','','','','','','','','','','',
        ],
    'x28a':[
        '','','','','','Hoat ','','','','','','','','','','',
        '','','','','','','','quan ','','','chao ','he ','','','','',
        'Cuoc ','wu ','','','Khep ','','Mai ','Thep ','','','','','','','','',
        'ruan ','','','zu ','','','yu ','tu ','meng ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','mao ','','','yu ','','','',
        'zu ','','','','','','','','','','','','','xia ','','',
        '','','','','','jian ','','','','','','','','','yu ','',
        '','','','','','liu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ruan ','','','yan ','','','','','','','','','',
        '','','','','Bam ','Lon ','','','Choc ','','Sat ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Han ','','','','','',
        '','','','','','Cuoc ','','','','','','','','','','',
        ],
    'x28b':[
        '','','','','','','','','','Dui ','','','','','','',
        'jue ','','','','ruan ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','zhu ','','','','','','','Baang ','Bay ','','Choang ',
        '','','Choang ','die ','','','','','','','','','','','','',
        '','Thau ','','','','','','','','','','','','','','',
        '','','','','','','','','','','Com ','','','','','',
        '','','','','','','','Bung ','Hom ','Cun ','','','','','','',
        'Nhon ','Thoi ','','','yu ','','','','Ban ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','cai ','','','','','','','','','','','jiang ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Dui ','','','','','','','',
        ],
    'x28c':[
        '','','qian ','','','','','','','','','','','','','ta ',
        '','diao ','','','','','','','','','','','jue ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Nen ','','','','yu ','','Ben ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','duan ','','','','','',
        '','','','','','','dao ','','','','','','','','','',
        '','','','','','','','','','','','','cen ','Dai ','Dai ','',
        '','','','','jun ','','','','zhu ','','an ','','','','','',
        '','','qiu ','','','','','','','','','','','','','',
        '','','','','','','','','','','','feng ','wu ','jiao ','','',
        'peng ','','','','','','','','','','','','','','','',
        'niao ','','chan ','','','','nang ','','','','Gau ','','','Cat6','','',
        '','','Diu ','','men ','','','','tun ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','die ','','','','','',
        ],
    'x28d':[
        '','','','','','','','','','','','','','','xu ','',
        '','Kuang ','','wei ','','','','die ','','','','','','','','',
        '','','he ','yan ','','','Cua ','','','tu ','','','hu ','','','',
        'chu ','','','','','','','','','','men ','','','','','',
        '','','','','','','','','','','zhe ','','','','','',
        '','','','','','','','','','','xie ','','','ta ','','fu ',
        '','','','Cua ','','','yu ','','','','xie ','','xian ','jian ','xu ','',
        '','','','','','','','','','','','','','','','',
        '','yan ','ai ','','','','','','','','jun ','','','','','',
        '','','','','','','','lang ','','Lan ','','','','shu ','','',
        '','','yu ','','','','','','','','','','hua ','wen ','','e ',
        '','','','','','','','','','Gwaan ','','','','','','',
        '','niu ','','','xiang ','','sa ','','','','','','','','run ','',
        '','','','jian ','xu ','','','','','shu ','','','','','','',
        '','','','','','xie ','','','','','','','','','','Cua ',
        '','','','','','','Cua ','','','','','','','','dang ','',
        ],
    'x28e':[
        '','','','','','','','','','','','','','Cup ','','',
        'reng ','','','','','','','han ','','','Ji ','gai ','','','','',
        '','','','','','','','','','','','','Zhen ','','','',
        'ju ','','','','','','','','','','','','','','','',
        '','','','','','','xuan ','','','','','','','','','',
        '','','','','','','','','xu ','','cheng ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','zhao ','','','','','','','',
        '','','','','','fu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','duan ','','','','qiu ','','','','','','','xun ','',
        '','','','','','','','','','Jiao ','','','','','','',
        '','','yan ','','','','','','','','','','','xu ','','',
        '','','','','','','','die ','','','','','','','','',
        '','','','','','','','liu ','','','','Luong ','','','','',
        '','','Xia ','','','','Geki ','','','','','','','','','',
        ],
    'x28f':[
        '','','','','','','','','zhan ','cuan ','wu ','','','','jue ','',
        '','','','','xun ','','','','','','Be ','','','','','',
        '','','','','chen ','','','','','','','qu ','','','zhan ','',
        '','jue ','','','','','','','','','','','','qu ','','meng ',
        '','','pu ','','','','','','','','','','','du ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','xia ',
        '','','','','','','','','','','','','','','','dai ',
        '','','','','','','','','','','','','yu ','','','',
        '','','','','fang ','','','','','','','','','','','',
        '','','','','die ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','tiao ','',
        '','','','','','','','','','','','','','','','wu ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','wei ','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x290':[
        '','','','','','','','','','','','run ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','wei ','','','','','','','','','','','','',
        '','','','Song ','','','','','','','','','','','','',
        '','','','','','','','','','','','','wei ','','','',
        '','','','','','','','','','','','','','','cai ','',
        '','','','','','','Loi ','','','','','','','','','',
        '','','','','','','Ngat ','','','','','','','','','',
        'Con ','Ngut ','','shai ','tun ','','','','','','','','','','fu ','Che ',
        'Ram ','Bung ','','','fu ','Phat ','ze ','pu ','','','','','','','pao ','Mu ',
        '','','','','hua ','','','','','','','','','','','',
        '','','','Rei ','','dian ','Set ','','','','','','','','','',
        'yan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','xuan ','','','','','',
        'dai ','','','','','','','','','','','','','','','',
        '','','','','ba ','','','dai ','','','','','','','','',
        ],
    'x291':[
        '','','','','','lu ','','','','','','ru ','','','Mua ','Bung ',
        '','','','','','dan ','meng ','xia ','','','','','','','','',
        '','','','','','','peng ','','Guot ','','','','','','','wu ',
        'Set ','','May ','','','Nap ','Xoi ','piao ','','','','','','','ze ','',
        '','','','','lu ','','','bu ','','','','','','man ','','',
        '','','','','','','','','','','','Bung ','','','','',
        'nan ','','he ','','','','','','','','','','','','cen ','',
        '','','','','','','','','','May ','Rau ','Zyu ','','','dan ','fu ',
        '','','','','','sa ','','','','','','Rao ','','Rao ','liu ','',
        'Sam ','','','','dian ','','','','','','','','','','','',
        'Mong ','Rao ','','','','','','','','','','','Mong ','','','',
        '','','','','','','','Sam ','','','','','','','Khuya ','',
        '','','','','','Mu ','Sam ','hun ','','','','','','Loa ','','',
        'qu ','','','','','','','','','','','','','','','',
        '','','Xanh ','','','','','','','','','','','','','fei ',
        '','','','','','','','','','','','','','fei ','','',
        ],
    'x292':[
        '','','Bay ','','','','','','pang ','dan ','','ai ','','','','',
        '','','','','','','','mai ','','','','','','','dao ','',
        '','','','','chu ','','','','','','','','wan ','','diao ','',
        '','','suan ','','','','','','','mian ','','','','','','',
        'lan ','','','','','','','','','','','','','','','',
        'gan ','','','','jian ','','','','','','','','hang ','','','',
        '','','','','','xuan ','','','','','','','','','','',
        'ang ','','','','','fen ','','','ju ','','','','','fu ','','qu ',
        '','','','ma ','','bao ','','yu ','','','','','','mai ','','',
        '','','','','jiao ','','','','','','','','','','','',
        '','','','','','','','','','','','','bu ','','','',
        '','','','','','zhe ','bu ','','','','jue ','xun ','','Hia ','','',
        '','','bai ','','','ta ','','','nao ','yu ','','','','','','',
        '','','','','','','','','Xie ','diao ','','','','','die ','fu ,fu',
        '','','xuan ,yun','','yu ','','','Xie ','fu ','','','xuan ','','','','',
        '','','','','','','','la ','','','gao ','','','e ','','mei ',
        ],
    'x293':[
        '','','','','','','','ta ','','ta ','','','','','','',
        'ta ','','','','','','','','ta ','','','','','','','',
        '','','','','','','','','','','ze ','lu ','','','xu ','',
        '','','xu ','','','','','','','','','','','','','',
        '','','bao ','','','','','','','','','sheng ','','','','fu ',
        '','','','','','','','Bang ','','','','','','','','',
        '','','Roi ','Dep ','','','','','','','','','','','','',
        '','','','xu ','','','','jue ','','','','','lu ','','','',
        '','','','','','','','','','','','','','','ge ','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','wei ','','','','yu ','','bai ','','ta ','','',
        '','','','','','yun ','yun ','duan ','','wei ','','','','','','',
        '','','','','','','hun ','','','','','','','','bai ','yu ',
        '','','','','','','','','','','','','','','','',
        '','','','','yu ','','','','','juan ','jue ','','','','','',
        ],
    'x294':[
        '','','','','','sa ','','','','','','','','','','',
        '','','','','','','','','','','fu ','peng ','','','','',
        '','zu ','','','','','','','','','','su ','','','','',
        '','','','','','','zhe ','','','','','','su ','','','',
        '','e ','','','','','','','guang ','','','','','ao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','men ','','','','','','','','','la ','',
        '','','','','yao ','','','','','xuan ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','yan ','','','','','','','','','',
        '','','','','','','','','','','','','','','qiu ','',
        '','','','','','','','','','','fu ','','','','wu ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','fu ','','','','','Ngup ','Mang ','bie ','','',
        '','','','','an ','Ngok6','wu ','','','','lu ','','','','','',
        '','','','','','','','','','','','jue ','','','','',
        ],
    'x295':[
        'wai ','','dun ','','jie ','','','','','','zhuan ','hang ','','','','',
        '','','','','','qiu ','','Lei ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ze ','xu ','','','','','','','','xu ','','','',
        'ao ','','','','','','','','','','','','','','','',
        'liao ','','','','','wai ','','','','','','','','','','',
        'han ','','','','dan ','','','','','','','','','Gai ','','',
        '','','','','','','','','','','','','','','yuan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','peng ','','','','',
        '','','','','tun ','','','','','','','','fu ','','','',
        '','','','','','','','','','','han ','','fu ','','','',
        '','','','To ','','','','','','sa ','','','','','','',
        'hua ','','','','','qiu ','','','','','','','','','sa ','',
        '','','','','han ','','','','','liu ','','','','','','',
        '','','','','Bung6','','','','','','','','','wu ','','',
        ],
    'x296':[
        'zhao ','','','','May ','','','','','','la ','','','yuan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','To ','yu ','','','','','','','','','','','',
        'su ','shuai ','','yu ','','','','','','su ','','yu ','','','','',
        '','','','','liu ','','cheng ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','niu ','','','','Bay ','','','','',
        '','','','','yu ','','','','','','','','','','','',
        '','','','','Nhu ','','niu ','','','','','na ','','','','',
        '','','','','','','','Qua ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','No ','Qua ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','zai ','','','mao ','','yu ','','','yu ','','',
        '','','','','','','','','','','ju ','','lu ','','','',
        ],
    'x297':[
        '','','','ju ','','','','Juan ','','','','','','','','',
        '','','','','','','','','','','','','','','','ang ',
        'Mam ','','','','','','','','','','','','','','','',
        '','','fu ','','','','','','','','','','','yan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','wu ','','yu ','','','','','','','','',
        'Qiu ','','','','','su ','','','','','','','','','','',
        '','','','','','','','','','','','Chan ','','jiang ','','',
        '','','','','','','','','zhu ','','','','','','','',
        '','','','','','','','','','','','','','','hai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','han ',
        '','yuan ,xuan','Qua ','','','','','ao ','','','','shan ','','','','',
        '','yu ','','','Caat ','','','','','','','','','','meng ','',
        '','','','','','','jie ','','','','','','','','huai ','',
        '','','','yu ','','','chan ,jie','','','','','Nang ','','','','',
        ],
    'x298':[
        '','','','','','','','','','','','','','','','',
        '','Ding ','','','Mao ','','','','','','','','','','','',
        'Cui ','','','','','','','Guc ','','','','','','','','wei ',
        '','Chui ','','Chui ','Cui ','Choi ','','fu ','','','','','','','','',
        '','','','yu ','','','','','','','','Thom ','','','','',
        '','','','','hai ','peng ','','','','','','','','','','bie ',
        '','','','','','','','','','','','fan ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','wan ','','','','','','','','wen ','','','',
        'zhe ','','','','ban ','bu ','','','','','','ge ','','','liu ','',
        '','','','','','','Giong ','','','','hu ','','','','','',
        'fu ','','Sai ','qu ','','','yu ','','','jiu ','','shu ','','','','fu ',
        '','','','','','','','','','','xu ','','','','','',
        '','Ngon ','','','','','','','','','','','fu ','bu ','','',
        '','','','','','','','','','zhe ','','','','','tu ','',
        '','lu ','','','','','','','fu ','','','','','','','',
        ],
    'x299':[
        '','','','','','','','','','','xian ,jian','kun ','','','','',
        '','','','','','','','','','cheng ','','','','','tan ','',
        'xie ','','','duan ','','','','','','e ','','','','','','',
        '','','','','','','','','','','yu ','','','','','',
        '','','','','','','','zhan ','','','','Au6','qia ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','yu ','','',
        '','','','','','','','','','','','','','tu ','','zu ',
        '','','','','','','','','','bie ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'bang ','yu ','Jyu ','','','','','','','','','','','','','',
        '','','','','','','','','','xian ','meng ','','','','','',
        '','','','','','','','cai ','du ','','','','','','','jue ',
        '','','ju ','','','','','','qu ','','','','','','','',
        '','jue ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x29a':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','yu ','','yu ','','','ba ','','','',
        'ya ','','','','','','','','','fan ','','','','Que ','','',
        '','','ma ','','','','','','','','','','Kheo ','','','',
        '','','','','','','','Song ','','','','','','Peng ','','',
        '','','','','','','Song ','','','','','','','','','',
        'zu ','leng ','','','','','','dan ','','','Xuong ','Xuong ','','','du ','bian ',
        '','qia ','he ','','','','yan ','','','','','teng ','','','','Hom ',
        '','','','hai ','','','','','','xu ','','','','','','',
        '','','','','','','','Jue ','','','','pu ','','','Sun ','',
        '','','','','','','','','','','','','','','','',
        '','','','','yan ','So ','','','','','','','','Cut ','','',
        'kai ','mao ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','sao ','','','','','','','','','',
        '','','','','ju ','','','','','cheng ','','','','','','',
        ],
    'x29b':[
        '','','','','','','','','','','','','','','Zam ','',
        '','Chom ','','','','','','','','','','','ju ','','','zha ',
        '','','','','','','','','','','','','','','','',
        '','dao ','','','','','','','','','','','','','','',
        '','','','','','','','','','','ju ','','','','','',
        '','','','','','','','','','','','','Xui ','','','dao ',
        '','','an ','','','han ','','','','','','','','','','',
        '','','','','','Quan ','Rau ','','','','fu ','','','','','',
        '','qia ','','','','na ','','','','','','','','','','',
        '','','','','Quan ','','','','','','','','','ya ','','',
        '','','','','','','','','','','','','','Ria ','','',
        '','','','','','','','','','','','','','','','',
        '','Rau ','','','zun ','','nao ','','','','','','','','cheng ','',
        '','','','','','','','','jiao ','','','yao ','','','can ','',
        '','','','','','','','','','','','','','Ban ','','Xoam ',
        '','pu ','zhuang ','','','','','','','','','','','la ','','',
        ],
    'x29c':[
        '','','','zhan ','','','','','Nheo ','','','','','bian ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','ju ','','','','jue ','','yu ','','','','','hu ',
        '','','','xie ','er ','','','','','','','','','','','',
        '','','','','','','','','','','er ,xian','','yu ','hu ','','',
        '','','','','','','','','','ku ','','','','','jiao ','',
        '','','','','','','','','ru ','','','','','','','',
        '','yu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','hao ','','','niu ','','hua ',
        '','','','','','','','','','','','','','','','',
        'zhu ','Coi ','','','','Troi ','','','','','','','zhu ','','','',
        '','','zu ','','','','','','','','','','','','yu ','',
        '','','','','','','lai ','','','','Ranh ','','wu ','','fu ','zhuan ',
        '','','su ','','yao ','','','','','','','','','','','',
        '','','yan ','','','zhu ','','','','','','','','','','',
        '','','','Troi ','','ju ','','','','','','','','','','',
        ],
    'x29d':[
        '','','','','','','','shai ','','yun ','','','','','','',
        '','','jiang ','','','','','','ju ','','Troi ','','','teng ','wei ','',
        '','gu ','','','liao ','','','','','','','','','','','',
        '','','meng ','cha ','','','','','','qu ','','lei ','','','','',
        '','','','Troi ','','qu ','','','','','','Gyo ','','qiu ','','hua ',
        '','','','','','','','','','','du ','','','Chai ','','',
        '','','','','','','mu ','','','','','','hu ','','','',
        '','','','','','','','','','fu ','','','','Tom ','','',
        '','','zhu ','','zhu ','Ci ','','','','Pou ','','','','','','',
        '','','','','','','mu ','','','','','','','','','Buop ',
        '','meng ','','','','','guai ','jiu ','','mu ','','','Si ','wu ','','ru ',
        '','zha ','','','','','','','','','','','','','','',
        '','','xie ','','jiang ','','','Hung ','','','Thu ','','','','','',
        'ju ','','','','','Luon ','bu ','','','','','','','','','',
        '','','','','','','','','','','','','','jiang ','','',
        'xun ','','','','','','Mang ','','','','','qia ','','','','',
        ],
    'x29e':[
        '','','','tu ','hua ','','','','','','','','','','','',
        'ru ','','','','','','','','','','','','','','','',
        '','','','','','','','','Yi ','','','','','','Bong ','Chuoi ',
        'Go ','','','','','','','','Thia ','','','','','','ye ','',
        '','','','','hai ','','','','','','','','','','an ','ba ',
        '','han ','','','','','','','','','','','','','','nai ',
        '','','','','Thu ','','','','','Nau ','','Tep ','','Chay ','Mu ','Tuoi ',
        '','chu ','','','','','','','','','ge ','','han ','','na ','ge ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Bon ','','Trau ','','','','','Bong ','','Bon ','xie ','','','','Soc ',
        'yu ,wu','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Mam ','','Sop ','Dua ','','Tram ','','bu ','jian ','','wu ','Tram ','','zhuan ','','Vay ',
        '','','','','','','','','','','','','','','','',
        '','','','','','die ','','','','','Vay ','Leo ','','','','',
        ],
    'x29f':[
        'Vay ','','','','','','','','Ao ','','','','','','','',
        '','','','','','','','','','ge ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','xu ','','','Sau ','Lui ','','','','wei ','',
        '','','','','','','Ruoc ','','','','','','','','','',
        '','','','','Sau ','Luon ','','','','qu ','','','','','','',
        '','','','','','','','ba ','Nheo ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','han ,yan','','',
        '','bao ','','','','','','xun ','','','','','','','','',
        '','','','','','','jie ','','','','','hu ','','','','fu ',
        '','','mao ','','','','','','','','','','','','','',
        '','','','bao ','','','','','Mao ','','Khuou ','','','ju ','Caa ','qu ',
        '','','','','','qu ','','','Khuou ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a0':[
        '','','','','Chim ','','','','','','','','','','','',
        '','','Shi ','','','','','','jiang ','','','','','','','',
        'xun ','','','ju ','','','','','','','','','','','','',
        '','','','','','','','','','','fu ','','','','jie ','',
        'yu ','','','','Ket ','Sac ','Hau ','Song ','zhuang ','','','cheng ','','jie ','','chen ',
        '','','','','','','qu ','','','','','','','','','',
        'jue ','yan ','','','','ju ','','','','','','','','','xiu ','',
        '','','','','Coc ','Coc ','','','','','','','','su ','','',
        '','','','','','','','','','yu ','','fu ','ta ','','','',
        '','','hu ','','','','','','','','','','mei ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Cun ','','yu ','','','','','','','','pen ','fu ','',
        '','','liu ','','','','','','jie ','','','','','yu ','yu ','Mei ',
        '','mao ','','fu ','','','','','','','','jian ','','','','',
        '','','','','','','','','','','','','','','','',
        '','Hau ','','','Ga ','','','','','','','','','','','Ge ',
        ],
    'x2a1':[
        '','','xia ','','','Set ','','','','','qu ','','','','ge ','',
        '','su ','','','','','','','','','','','','','','',
        '','','','','','Cut ','','','','','','','','','hu ,gu','',
        '','','','mai ','','','','','','','','','','','','',
        '','','','','su ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Cuoc ','Choi ','Ri ','Sam ','','','','Tu ','','',
        '','','','','','','','','jie ','','','','','','','',
        '','','qu ','','','','','','','','','xie ','','','','',
        '','','','','','','','','','','','','','','','',
        'fu ','','','','','Khuou ','Tu ','','','','','','','','','',
        'ya ','liu ','','','','','can ','64272.110,chu ','','','','','','','','jian ',
        '','','','','','','chu ,du','','ai ','','','Cui ','','','Quam ','',
        '','xun ','','','','','','','','','','','','yu ','','',
        '','','','','','','','','','Ngan ','','Cui ','','cai ','','liu ',
        '','','jie ','','','','','','','la ','','','','','','',
        ],
    'x2a2':[
        '','','','','','','','','lai ','','he ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','jue ','','','','guan ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Muoi ','','tan ','','En ','','','','','','kan ',
        '','bian ','','','Muoi ','','','','','','','','','','','gan ',
        '','','','','','Mam ','','gan ,tan','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','xiao ','','zhu ','','yu ','','','','',
        '','jian ','','','','','','','','yu ','','','','zu ','','',
        'nuan ','','','','','','','','','','','','','su ','','',
        '','pu ','','','','','','','','','','','','','yu ','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a3':[
        '','','','','','na ','qu ','','','','','tun ','','','','',
        '','','','ku ','su ','','','','','','','','','','','ze ',
        '','','','ge ','','','','jie ','','','tiao ','','','','','',
        '','','','','','','shu ','','','','','','','hun ','','nie ',
        '','jun ','hu ','','lu ','','','','chao ','','','','','','','fu ',
        '','','','','','','','','','','','','','yun ','','',
        '','','','','','','','xuan ','','','','','','','','',
        '','','','','','','shan ','','Qu ','du ','','sao ','','','','kuang ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','liu ','','','','','','','','','','mei ','','',
        '','','','','tun ','kang ','tun ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','heng ','','','','','','Huang ','','','','','','',
        '','','','','','','','','','','kuang ','piao ','','','','',
        '','','','hu ','','','bao ','','','','','hu ','','','','',
        ],
    'x2a4':[
        'Naa ','','','','','','bie ','','','','','','','','','',
        '','','','','','','','','','','','','','dai ,tai','du ','',
        '','','','','','tai ','','shu ','','','','','','','su ','',
        '','','','','','','','','','','','','','','','',
        '','','cha ','','lu ','','yu ','','yan ','','qiao ','','yu ','','','tu ',
        '','Ngam ','tun ','','','','','','','','','','','yu ','','',
        '','','','','','','','die ','cha ','dian ','','','','','','',
        '','','','','','','','wai ','','','','','','zhai ','','',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','','','','Tham ','','','','','ma ','','','',
        '','','','','','','','','','','mai ','','Nung ','','','',
        '','','','','','','','','','','','','','','dan ','teng ',
        '','','','','','','','','','','yu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','cu ','','','','','','','','','','Sam ','','','','',
        'cu ','','','','','','','','','','','','','','','',
        ],
    'x2a5':[
        '','','Ding ','','','','','','','','','','','peng ','','',
        '','','','','','','','','','','','','','','','',
        'Trong ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','hu ','','','','','','',
        '','','','','','','','','','','','','','cu ','jun ','',
        '','','','','','','','','er ','','','','','ai ','hu ','',
        '','hu ','','','','','','','','','','','','','','',
        '','','','','jiao ','','','','pu ','','','jie ','lu ','','','',
        'yao ,ya','','','','','','','','','Hou ','','qiu ','jue ','','','',
        '','','','','','','','','','xu ','','','','Ngui ','','',
        '','','','','','','su ','liao ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','pa ','','','','','','','','','na ','','',
        '','','','','','','zhan ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a6':[
        '','Kap6','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','zu ','','','zhan ','','','','','',
        '','','Ji ','','','Rang ','','','','he ','qia ','','','','','',
        '','','','','','','','','hu ','','yan ','','','','','',
        '','','','','','','','','','','','Nak ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','jue ','','','','','','','','','','',
        '','','','','','','','','','','Trong ','','','','','',
        '','','','','','zhe ','','','','Gwi ','','','gan ','','','cu ',
        '','','','','','','','','','zhu ','','','','','','',
        'xiao ','','','','','Rua ','','Rua ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a7':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a8':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Bai ','','','','','','','Zhan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Luan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2aa':[
        '','','','','','','','','','','Song ','','','','','',
        '','','','','','','','Jue ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Yong ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2ae':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Nu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Cong ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2af':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Xian ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b0':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Li ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Fei ','','','','','','','',
        '','','','','','','','','','Su ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Kou ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b1':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Chi ','','','','','','','',
        '','','','','','','','','Xun ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b2':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Qia ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Gong ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b3':[
        'Ji ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Luo ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Yi ','','','','','','',
        '','','Nao ','','','','','','','','','','','','','',
        'Xi ','','Xiao ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Jiao ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b4':[
        '','','','','Yue ','','Kuai ','','','Ling ','','','','','','',
        'Ni ','','','Bu ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Han ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Fu ','','Cong ','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b5':[
        '','','','','','','','','','','','','','','Jue ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Duo ','','','','','','','Su ','','','','','','','Huang ','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b6':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Han ','Ai ','','','','Ti ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Xu ','Gong ','','','','','','',
        '','','Ping ','','Hui ','Shi ','','','','Pu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Zhi ','','','Jue ','',
        '','','Ning ','','','','','','','','','','','','','',
        '','','','','','','Chi ','','Ti ','','','','','','','',
        ],
    'x2f8':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Gai ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2f9':[
        '','','','','','','','Baan6','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ]
}
