"""
Unicode code point dictionary.
Based on Unicode.org Unihan database.
"""
__license__ = 'GPL 3'
__copyright__ = '2010 Hiroshi Miura <miurahr@linux.com>'
__docformat__ = 'restructuredtext en'

CODEPOINTS = {
    'x34':[
        'Qiu ','Tian ','','','Kua ','Wu ','Yin ','','','','','','Si ','','','',
        '','','','','','','Ye ','','','','','','Chou ','','','',
        '','Nuo ','','','Qiu ','','','','Xu ','Xing ','','Xiong ','Liu ','Lin ','Xiang ','Yong ',
        'Xin ','Zhen ','Dai ','Wu ','Pan ','','','Ma ','Qian ','Yi ','Zhong ','N ','Cheng ','Fung ','','',
        '','Zhuo ','Fang ','Ao ','Wu ','Zuo ','','Zhou ','Dong ','Su ','Yi ','Jiong ','Wang ','Lei ','Nao ','Zhu ',
        'Suk ','','','','Xu ','','','Saan ','Jie ','Die ','Nuo ','Su ','Yi ','Long ','Ying ','Beng ',
        '','','','Lan ','Miao ','Yi ','Li ','Ji ','Yu ','Luo ','Chai ','Nom ','','','Hun ','Xu ',
        'Hui ','Rao ','','Zhou ','Caam ','Han ','Xi ','Tai ','Ai ','Hui ','Jun ','Ma ','Lue ','Tang ','Xiao ','Tiao ',
        'Zha ','Yu ','Ku ','Er ','Nang ','Qi ','Chi ','Mu ','Han ','Tang ','Se ','Si ','Qiong ','Lei ','Sa ','',
        '','Hui ','Pu ','Ta ','Shu ','Zoeng ','Ou ','Tai ','','Mian ','Wen ','Diao ','Yu ','Mie ','Jun ','Niao ',
        'Xie ','You ','','','She ','Fung ','Lei ','Li ','Sin ','Luo ','Sek ','Ji ','','Kwaan ','','',
        'Quan ','','Cai ','Liang ','Gu ','Mao ','Gung ','Gua ','Sui ','Din ','','Mao ','Man ','Hyun ','Shi ','Li ',
        '','Wang ','Kou ','Chui ','Zhen ','Ding ','','','Bing ','Huan ','Dong ','Gong ','Cang ','','Lian ','Jiong ',
        'Lu ','Xing ','','Nan ','Xie ','','Bi ','Jie ','Su ','Hung ','Geoi6','Gung ','You ','Xing ','Qi ','Phay ',
        'Dian ','Fu ','Luo ','Qia ','Jie ','Tong ','Bak ','Yan ','Ci ','Fan ','Lang ','','Fu ','He ','Diu ','Li ',
        'Hua ','Tou ','Pian ','Dai ','Jun ','E ','Qie ','Yi ','Jue ','Rui ','Jian ','Gong ','Chi ','Chong ','Chi ','',
        ],
    'x35':[
        'Lue ','Daang ','Lin ','Jue ','Su ','Xiao ','Chan ','Put ','','Zhu ','Dan ','Jian ','Zhou ','Duo ','Xie ','Li ',
        'Cim ','Chi ','Xi ','Jian ','','Ji ','','Fei ','Chu ','Bang ','Kou ','','Ba ','Liang ','Kuai ','',
        'He ','Bit ','Jue ','Lei ','Shen ','Pi ','Yang ','Lu ','Bei ','E ','Lu ','','Coek ','Che ','Nuo ','Suan ',
        'Heng ','Yu ','','Gui ','Yi ','Xian ','Gong ','Lou ','Cam ','Le ','Shi ','Pei ','Sun ','Yao ','Jie ','Zou ',
        '','Que ','Yin ','Him ','Zhi ','Jia ','Hu ','La ','Hou ','Ke ','Bou ','Jing ','Ai ','Deoi ','E ','Chu ',
        'Xie ','Chu ','Wei ','','Teng ','Huan ','Su ','You ','Caam ','Jun ','Zhao ','Xu ','Shi ','','Caat ','Kui ',
        'Soeng ','He ','Gai ','Yan ','Qiu ','Yi ','Hua ','Si ','Fan ','Zhang ','Dan ','Fang ','Song ','Ao ','Fu ','Nei ',
        'He ','You ','Hua ','Hung ','Chen ','Guo ','Ng ','Hua ','Li ','Fa ','Hao ','Pou ','Dung6','Si ','','',
        'Le ','Lin ','Yi ','Hou ','Zaau ','Xu ','Qu ','Er ','','','','','','','','Nei ',
        'Wei ','Xie ','Ti ','Hong ','Tun ','Bo ','Nie ','Yin ','San ','','','','','','Wai ','Shou ',
        'Ba ','Ye ','Ji ','Tou ','Han ','Jiong ','Dong ','Wen ','Lu ','Sou ','Guo ','Ling ','','Tian ','Lun ','',
        '','','','','','ge ','Ye ','Shi ','Xue ','Fen ','Chun ','Rou ','Duo ','Ze ','E ','Xie ',
        'Zaau ','E ','Sheng ','Wen ','Man ','Hu ','Ge ','Xia ','Man ','Bi ','Ji ','Hou ','Zhi ','','Gaa ','',
        '','Bai ','Ai ','Ci ','Hin ','Gou ','Dan ','Bai ','Bo ','Na ','Li ','Xiao ','Xiu ','','','',
        '','','Dong ','Ti ','Cu ','Kuo ','Lao ','Zhi ','Ai ','Xi ','','Qie ','Zaa ','Hei ','','',
        'Chu ','Ji ','Huo ','Ta ','Yan ','Xu ','Put ','Sai ','','','','Go6','Ye ','Xiang ','Heoi ','Xia ',
        ],
    'x36':[
        'Zuo ','Yi ','Ci ','','','Xian ','Tai ','Rong ','Yi ','Zhi ','Yi ','Xian ','Ju ','Ji ','Han ','',
        'Pao ','Li ','','Lan ','Can ','Han ','Yan ','','','Yan ','Han ','Haam ','Chi ','Nian ','Huo ','',
        'Bi ','Xia ','Weng ','Xuan ','Waan ','You ','Qin ','Xu ','Nei ','Bi ','Hao ','Jing ','Ao ','Ao ','','',
        'Zam ','Taan ','Ju ','Zaau ','Zuo ','Bu ','Jie ','Ai ','Zang ','Ci ','Fa ','Zaan ','','','','Nie ',
        'Liu ','Mang ','Dui ','Bong ','Bi ','Bao ','','Chu ','Han ','Tian ','Chang ','','','Do ','Wai ','Fu ',
        'Duo ','Yu ','Ye ','Kui ','Han ','Kuai ','','Kuai ','Ziu ','Long ','Sing ','Bu ','Chi ','Xie ','Nie ','Lang ',
        'Yi ','Zung ','Man ','Zhang ','Xia ','Gun ','','','Ji ','Liao ','Ye ','Ji ','Yin ','','Da ','Yi ',
        'Xie ','Hao ','Yong ','Han ','Chan ','Tai ','Tang ','Zhi ','Bao ','Meng ','Gui ','Chan ','Lei ','','Xi ','',
        'Hei ','Qiao ','Rang ','Yun ','','Long ','Fu ','Zuk ','','Gu ','Hoi ','Diu ','Hua ','Guo ','','Gao ',
        'Tao ','','Shan ','Lai ','Nie ','Fu ','Gao ','Qie ','Ban ','Gaa ','','Xi ','Xu ','Kui ','Meng ','Chuo ',
        'Hiu ','Ji ','Nu ','Xiao ','Yi ','Yu ','Yi ','Yan ','','Ran ','Hao ','Sha ','Gwan ','You ','Daam ','Xin ',
        'Bi ','Zaau ','Dian ','O ','Bu ','Dung ','Si ','Er ','Si ','Mao ','Yun ','Gei ','Naau ','Qiao ','','Pao ',
        '','Ping ','Nuo ','Jie ','Zi ','Er ','Duo ','','','','Duo ','','','Qie ','Leoi ','Ou ',
        'Sou ','Can ','Dou ','Ci ','Peng ','Yi ','So ','Zuo ','Po ','Qie ','Tong ','Xin ','You ','Bei ','Long ','',
        '','','','','','Ta ','Lan ','Man ','Qiang ','Zhou ','Yan ','Sek ','Lu ','Sik ','Sao ','Mian ',
        'Fan ','Rui ','Fa ','Cha ','Nao ','Cing ','Chou ','Gai ','Shu ','Pian ','Aam ','Kui ','Sha ','Saan ','Xian ','Zhi ',
        ],
    'x37':[
        '','','Fung ','Lian ','Xun ','Xu ','Mi ','Hui ','Mu ','Zung ','Pang ','Yi ','Gou ','Tang ','Qi ','Yun ',
        'Shu ','Fu ','Yi ','Da ','','Lian ','Cao ','Can ','Ju ','Lu ','Su ','Nen ','Ao ','An ','Qian ','',
        'Ceoi ','Sung ','','Ran ','Shen ','Mai ','Han ','Yue ','Er ','Ao ','Xian ','Ma ','','','Lan ','Hei ',
        'Yue ','Dong ','Weng ','Huai ','Meng ','Niao ','Wan ','Mi ','Nie ','Qu ','Zan ','Lian ','Zhi ','Zi ','Hai ','Xu ',
        'Hao ','Xun ','Zhi ','Fan ','Chun ','Gou ','','Chun ','Luan ','Zhu ','Shou ','Liao ','Jie ','Xie ','Ding ','Jie ',
        'Rong ','Mang ','Geoi ','Ge ','Yao ','Ning ','Yi ','Lang ','Yong ','Yin ','','Su ','Sik ','Lin ','Ya ','Mao ',
        'Ming ','Zui ','Yu ','Ye ','Gou ','Mi ','Jun ','Wen ','','Hoi ','Dian ','Long ','','Xing ','Cui ','Qiao ',
        'Mian ','Meng ','Qin ','','Wan ','De ','Ai ','','Bian ','Nou ','Lian ','Jin ','Zyu ','Chui ','Zuo ','Bo ',
        'Fui ','Yao ','Tui ','Ji ','Aam ','Guo ','Ji ','Wei ','Bui6','Zaat ','Xu ','Nian ','Yun ','','Ba ','Zhe ',
        'Ju ','Wei ','Xi ','Qi ','Yi ','Xie ','Ci ','Qiu ','Tun ','Niao ','Qi ','Ji ','Teoi ','','','Dian ',
        'Lao ','Zhan ','Zi ','Fan ','Yin ','Cen ','Ji ','Hui ','Zai ','Lan ','Nao ','Ju ','Qin ','Dai ','Shutsu ','Jie ',
        'Xu ','Cung ','Yong ','Dou ','Chi ','Tou ','Min ','Huang ','Sui ','Ke ','Zu ','Hao ','Cheng ','Xue ','Ni ','Chi ',
        'Lian ','An ','Chi ','Si ','Xiang ','Yang ','Hua ','Cuo ','Qiu ','Lao ','Fu ','Dui ','Mang ','Lang ','Tuo ','Han ',
        'Mang ','Bo ','Kwan ','Qi ','Han ','','Long ','Ban ','Tiao ','Lao ','Qi ','Zan ','Mi ','Pei ','Zhan ','Xiang ',
        'Gang ','','Qi ','','Lu ','Caam ','Yun ','E ','Quan ','Min ','Wei ','Quan ','Shu ','Min ','Daat6','',
        'Ming ','Yao ','Jue ','Li ','Kuai ','Gang ','Yuan ','Da ','Gou ','Lao ','Lou ','Qian ','Ao ','Biao ','Zung ','Mang ',
        ],
    'x38':[
        'Dao ','Caam ','Ao ','','Xi ','Fu ','Daan ','Jiu ','Run ','Tong ','Qu ','E ','Hei ','Ji ','Ji ','Hua ',
        'Jiao ','Zui ','Biao ','Meng ','Bai ','Wei ','Ji ','Ao ','Yu ','Hao ','Dui ','Wo ','Ni ','Cuan ','','Li ',
        'Lu ','Niao ','Hua ','Lai ','','Lu ','Fung ','Mi ','Yu ','Fong ','Ju ','','','Zhan ','Pang ','Yi ',
        '','Ji ','Bi ','','Ren ','Fong ','Fan ','Ge ','Ku ','Jie ','Miao ','Hei ','Si ','Tong ','Zyun ','Ci ',
        'Bi ','Kai ','Li ','Fong ','Sun ','Nuo ','Fong ','Ji ','Men ','Xian ','Qia ','E ','Mao ','','Saam ','Tou ',
        'Zin ','Qiao ','Zeon ','Kwaan ','Wu ','Zing ','Chuang ','Ti ','Lian ','Bi ','Haat6','Mang ','Xue ','Feng ','Lei ','Zou ',
        'Zheng ','Chu ','Man ','Long ','','Yin ','Baan ','Zheng ','Qian ','Luan ','Nie ','Yi ','','Ji ','Ji ','Zhai ',
        'Yu ','Jiu ','Huan ','Di ','Lup ','Ling ','Ji ','Ben ','Zha ','Ci ','Dan ','Liao ','Yi ','Zhao ','Xian ','Chi ',
        'Ci ','Chi ','Yan ','Lang ','Dou ','Long ','Chan ','','Tui ','Cha ','Ai ','Chi ','','Ying ','Cha ','Tou ',
        '','Tui ','Cha ','Yao ','Zong ','Zung ','Pun ','Qiao ','Lian ','Qin ','Lu ','Yan ','Kong ','Sou ','Yi ','Chan ',
        'Jiong ','Jiang ','','Jing ','','Dong ','Go ','Juan ','Han ','Di ','Wu ','','Hong ','Tou ','Chi ','Min ',
        'Bi ','','Xun ','Lu ','Sai ','She ','Bi ','','Bi ','','Xian ','Wei ','Bie ','Er ','Juan ','',
        'Zhen ','Bei ','Yi ','Yu ','Qu ','Zan ','Mi ','Ni ','Si ','Gung ','','Daan ','Shan ','Tai ','Mu ','Jing ',
        'Bian ','Rong ','Ceng ','Can ','Ding ','','','','Keoi ','Di ','Tong ','Ta ','Xing ','Sung ','Duo ','Xi ',
        'Tong ','','Ti ','Shan ','Jian ','Zhi ','Wai ','Yin ','','','Huan ','Zhong ','Qi ','Zung ','','Xie ',
        'Xie ','Ze ','Wei ','','','Ta ','Zhan ','Ning ','','','Sam ','Yi ','Ren ','Shu ','Cha ','Zhuo ',
        ],
    'x39':[
        '','Mian ','Ji ','Fang ','Pei ','Ai ','Fan ','Ao ','Qin ','Qia ','Xiao ','Fan ','Gaam ','Qiao ','Go ','Tong ',
        'Tip ','You ','Gou ','Ben ','Fu ','Chu ','Zhu ','','Chu ','Zaan ','Hang ','Nin ','Jue ','Cung ','Cha ','Kong ',
        'Lie ','Li ','Xu ','Paang ','Yu ','Hai ','Li ','Hou ','Gong ','Ke ','Yuan ','De ','Hui ','Giu ','Kuang ','Jiong ',
        'Zan ','Fu ','Qie ','Bei ','Xi ','Ci ','Pang ','Haam ','Xi ','Qiu ','Huang ','Nan ','','Chou ','San ','Jim ',
        'De ','De ','Te ','Men ','Ling ','Shou ','Dian ','Can ','Die ','Che ','Peng ','Zi ','Ju ','Ji ','Lai ','Tian ',
        'Yuan ','Zaau ','Cai ','Qi ','Yu ','Lian ','Cung ','','','','Yu ','Ji ','Wei ','Mi ','Cui ','Xie ',
        'Xu ','Xi ','Qiu ','Hui ','Ging ','Yu ','Qie ','Shun ','Chui ','Duo ','Lou ','Deon ','Pang ','Tai ','Zhou ','Yin ',
        'Sou ','Fei ','Shen ','Yuan ','Yi ','Hun ','Se ','Ye ','Min ','Fen ','He ','','Yin ','Ce ','Ni ','Ao ',
        'Feng ','Lian ','Chang ','Chan ','Ma ','Di ','Hu ','Lu ','','Yi ','Hua ','Caa ','Tui ','E ','Hua ','Sun ',
        'Ni ','Lian ','Li ','Xian ','Yan ','Long ','Men ','Jian ','Gik ','','Bian ','Yu ','Huo ','Miao ','Chou ','Hai ',
        '','Le ','Jie ','Wei ','Yi ','Huan ','He ','Can ','Lan ','Yin ','Xie ','Zaat ','Luo ','Ling ','Qian ','Huo ',
        'Cim ','Wo ','Zoi ','','Ge ','Zyu ','Die ','Yong ','Ji ','Ang ','Ru ','Xi ','Shuang ','Xu ','Yi ','Hu ',
        'Ji ','Qu ','Tian ','Sau ','Qian ','Mu ','Gaan ','Mao ','Yin ','Gai ','Ba ','Xian ','Mao ','Fang ','Ya ','Gong ',
        'Song ','Wei ','Xue ','Gwaa ','Guai ','Jiu ','E ','Zi ','Cui ','Bi ','Wa ','Hin ','Lie ','Gaa ','','Kuai ',
        '','Hai ','Zaan ','Zhu ','Chong ','Xian ','Xuan ','So ','Qiu ','Pei ','Gui ','Er ','Gong ','Qiong ','Bak6','Lao ',
        'Li ','Chen ','San ','Bo ','Wo ','Pou ','Hang ','Duo ','Paang ','Te ','Ta ','Zhi ','Biao ','Gu ','Hot ','Coeng ',
        ],
    'x3a':[
        'Bing ','Zhi ','Dong ','Cheng ','Zhao ','Nei ','Lin ','Po ','Ji ','Min ','Wei ','Che ','Gou ','Bong ','Ru ','Taan ',
        'Bu ','Zung ','Kui ','Lao ','Han ','Ying ','Zhi ','Jie ','Xing ','Xie ','Xun ','Shan ','Qian ','Xie ','Su ','Hai ',
        'Mi ','Hun ','Nang ','','Hui ','Na ','Song ','Ben ','Liu ','Jie ','Huang ','Lan ','','Hu ','Dou ','Huo ',
        'Ge ','Yao ','Ce ','Gui ','Jian ','Jian ','Chou ','Jin ','Ma ','Hui ','Men ','Can ','Lue ','Pi ','Yang ','Ju ',
        'Ju ','Que ','','','Shai ','Cau ','Jiu ','Hua ','Xian ','Xie ','Syun ','Su ','Fei ','Ce ','Ye ','',
        '','','Qin ','Hui ','Tun ','Ling ','Qiang ','Xi ','Yi ','Nim ','Meng ','Tuan ','Lan ','Hao ','Ci ','Zhai ',
        'Piao ','Luo ','Mi ','Buk ','Fu ','Cam ','Xie ','Bo ','Hui ','Qi ','Xie ','','Hei ','Bo ','Qian ','Ban ',
        'Jiao ','Jue ','Kun ','Song ','Ju ','E ','Nie ','','Die ','Die ','Pei ','Gui ','Zi ','Qi ','Chui ','Gwaat6',
        'Yu ','Qin ','Faat ','Ke ','Fu ','Gaang ','Di ','Xian ','Gui ','He ','Qun ','Han ','Tong ','Bo ','Shan ','Bi ',
        'Lu ','Ye ','Ni ','Chuai ','San ','Diao ','Lu ','Tou ','Lian ','Ke ','San ','Zhen ','Chuai ','Lian ','Mao ','Deon ',
        'Qian ','Ke ','Shao ','Qiao ','Bi ','Zaa ','Yin ','Kaap ','Shan ','Su ','Sa ','Rui ','Zhuo ','Lu ','Ling ','Cha ',
        'Zaai ','Huan ','','','Jia ','Ban ','Hu ','Dou ','Caam ','Lou ','','Juan ','Ke ','Suo ','Ge ','Zhe ',
        'Ding ','Duan ','Zhu ','Yan ','Pang ','Cha ','','','','','Yi ','Zin ','','You ','Gun ','Yao ',
        'Yao ','Shi ','Gong ','Qi ','Gen ','Gwong ','','Hou ','Mi ','Fu ','Hu ','Guang ','Dan ','Dai ','Tou ','Yan ',
        '','Dung ','Qu ','','Chang ','Ming ','Tou ','Bao ','On ','Ceon ','Zung ','Xian ','','','','Mao ',
        'Lang ','Nan ','Pei ','Chen ','Hau ','Fei ','Cou ','Gei ','Qie ','Dai ','Sik ','Kun ','Die ','Lu ','Thung ','',
        ],
    'x3b':[
        '','Caap ','Yu ','Tai ','Chan ','Man ','Mian ','Huan ','Wan ','Nuan ','Huan ','Hou ','Jing ','Bo ','Xian ','Li ',
        'Jin ','','Mang ','Piao ','Hao ','Yang ','','Xian ','Su ','Wei ','Che ','Kap ','Jin ','Ceng ','He ','',
        'Shai ','Ling ','Fui ','Dui ','Zaap ','Pu ','Yue ','Bo ','','Hui ','Die ','Yan ','Ju ','Jiao ','Kuai ','Lie ',
        'Yu ','Ti ','Tim ','Wu ','Hong ','Xiao ','Hao ','','Tiu ','Zaang ','','Huang ','Fu ','','','Dun ',
        '','Reng ','Jiao ','Gong ','Xin ','','','Yuan ','Jue ','Hua ','Sik ','Bang ','Mou ','Cat ','Gong ','Wei ',
        '','Mei ','Si ','Bian ','Lu ','Keoi ','','','He ','She ','Lu ','Pai ','Rong ','Qiu ','Lie ','Gong ',
        'Xian ','Xi ','Hing ','','Niao ','','','','Xie ','Lei ','Fu ','Cuan ','Zhuo ','Fei ','Zuo ','Die ',
        'Ji ','He ','Ji ','','Gin ','','','','Tu ','Xian ','Yan ','Tang ','Ta ','Di ','Jue ','Ang ',
        'Han ','Yao ','Ju ','Rui ','Bang ','Zeoi ','Nie ','Tian ','Nai ','','','You ','Mian ','Zin ','Bui ','Nai ',
        'Xing ','Qi ','Zaan ','Gen ','Tong ','Er ','Jia ','Qin ','Mao ','E ','Li ','Chi ','Zong ','He ','Jie ','Ji ',
        '','Guan ','Hou ','Gai ','Cung ','Fen ','Se ','Waat ','Ji ','Sik ','Qiong ','He ','Zung ','Xian ','Jie ','Hua ',
        'Bi ','Sing ','Caai ','Zhen ','Sau ','Zin ','Shi ','Gai ','Song ','Zhi ','Ben ','','','','Lang ','Bi ',
        'Xian ','Bang ','Dai ','Cat ','Zi ','Pi ','Chan ','Bi ','Su ','Huo ','Hen ','Ying ','Chuan ','Jiang ','Nen ','Gu ',
        'Fang ','','','Ta ','Cui ','Sai ','De ','Ran ','Kuan ','Che ','Da ','Hu ','Cui ','Lu ','Juan ','Lu ',
        'Qian ','Pao ','Zhen ','Fan ','Li ','Cao ','Qi ','','','Ti ','Ling ','Qu ','Lian ','Lu ','Shu ','Gong ',
        'Zhe ','Biao ','Jin ','Qing ','','','Zong ','Pu ','Jin ','Biao ','Jian ','Gun ','','Ban ','Zou ','Lie ',
        ],
    'x3c':[
        'Li ','Luo ','Shen ','Mian ','Jian ','Di ','Bei ','Cim ','Lian ','Zeon ','Xun ','Pin ','Que ','Long ','Zui ','Gou ',
        'Jue ','San ','She ','','Xie ','Hei ','Lan ','Cu ','Yi ','Nuo ','Li ','Yue ','','Yi ','Ci ','Ji ',
        'Kang ','Xie ','Hang ','Zi ','Ke ','Hui ','Qu ','Hai6','Hei ','Hoi ','Wa ','Caam ','Xun ','Haap6','Shen ','Kou ',
        'Qie ','Sha ','Xu ','Ya ','Po ','Zu ','You ','Zi ','Lian ','Jin ','Xia ','Yi ','Qie ','Mi ','Jiao ','Hei ',
        'Chi ','Shi ','Fong ','Yin ','Mo ','Yi ','Hei ','Se ','Jin ','Ye ','Zaau ','Que ','Che ','Luan ','Kwaan ','Zheng ',
        '','','Ho ','','Se ','Gwai ','Cui ','Zaau ','An ','Xiu ','Can ','Chuan ','Zha ','','Ji ','Bo ',
        'Fu ','Sing ','Lang ','Tui ','Sek6','Ling ','E ','Wo ','Lian ','Du ','Men ','Lan ','Wei ','Duan ','Kuai ','Ai ',
        'Zai ','Hui ','Yi ','Mo ','Zi ','Ben ','Beng ','','Bi ','Li ','Lu ','Luo ','Hoi ','Dan ','Goi ','Que ',
        'Chen ','Hung ','Cheng ','Jiu ','Kou ','Ji ','Ling ','Ci ','Shao ','Kai ','Rui ','Chuo ','Neng ','Zi ','Lou ','Bao ',
        '','','Bao ','Rong ','Saan ','Lei ','Siu ','Fu ','Qu ','Saau ','Saa ','Zhi ','Tan ','Rong ','Zu ','Ying ',
        'Mao ','Nai ','Bian ','Saau ','Seoi ','Tang ','Han ','Zao ','Rong ','','Dang ','Pu ','Ziu ','Tan ','','Ran ',
        'Ning ','Lie ','Die ','Die ','Zhong ','Siu ','Lu ','Dan ','Kap ','Gui ','Ji ','Ni ','Yi ','Nian ','Yu ','Wang ',
        'Guo ','Ze ','Yan ','Cui ','Xian ','Jiao ','Shu ','Fu ','Pei ','Ngoet ','Zaau ','Zaau ','Nhop ','Bu ','Bian ','Chi ',
        'Sa ','Yi ','Bian ','','Dui ','Lan ','Zi ','Chai ','Cung ','Xuan ','Yu ','Yu ','Zaau ','Hong ','Cung ','',
        'Ta ','Gwo ','','','Suk6','Ju ','Xie ','Xi ','Jian ','Tan ','Pan ','Ta ','Xuan ','Xian ','Niao ','Tan ',
        'Gaau ','','','','Mi ','Ji ','Gou ','Wen ','Faa ','Wang ','You ','Ze ','Bi ','Mi ','Goeng ','Xie ',
        ],
    'x3d':[
        'Fan ','Yi ','Dam ','Lei ','Ying ','Siu ','Jin ','She ','Yin ','Ji ','Zyun ','Su ','','','','Wang ',
        'Mian ','Su ','Yi ','Zai ','Se ','Ji ','Luo ','Zaau ','Mao ','Zha ','Sui ','Zhi ','Bian ','Li ','Caai ','',
        '','','','','','Qiao ','Guan ','','Zhen ','Zung ','Nie ','Jun ','Xie ','Yao ','Xie ','Zi ',
        'Neng ','Sam ','Si ','Long ','Chen ','Mi ','Que ','Dam ','Na ','','','','Su ','Xie ','Bo ','Ding ',
        'Cuan ','Fong ','Chuang ','Che ','Han ','Dan ','Hao ','','','','Shen ','Mi ','Chan ','Men ','Han ','Cui ',
        'Jue ','He ','Fei ','Shi ','Che ','Shen ','Nu ','Fu ','Man ','Cing ','','','','Yi ','Chou ','Mei ',
        'Faat ','Bao ','Lei ','Ke ','Dian ','Bi ','Sui ','Ge ','Bi ','Yi ','Xian ','Ni ','Ying ','Zhu ','Chun ','Feng ',
        'Xu ','Piao ','Wu ','Liao ','Cang ','Zou ','Ceoi ','Bian ','Yao ','Huan ','Pai ','Sou ','','Dui ','Jing ','Xi ',
        'Bak6','Guo ','','','Yan ','Xue ','Chu ','Heng ','Ying ','','','','Lian ','Xian ','Huan ','Zaan ',
        '','Lian ','Shan ','Cang ','Bei ','Jian ','Shu ','Fan ','Dian ','','Ba ','Yu ','Zyun ','','Nang ','Lei ',
        'Yi ','Dai ','','Chan ','Chao ','Gon ','Jin ','Nen ','Pei ','','','Liao ','Mei ','Jiu ','Siu ','Liu ',
        'Han ','','Yong ','Jin ','Chi ','Ren ','Nong ','','','Hong ','Tian ','Bung ','Oi ','Gwaa ','Biu ','Bo ',
        'Qiong ','','Shu ','Cui ','Hui ','Chao ','Dou ','Guai ','E ','Wei ','Fen ','Tan ','','Lun ','He ','Yong ',
        'Hui ','Nim6','Yu ','Zong ','Yan ','Qiu ','Zhao ','Jiong ','Tai ','Zin ','','Bou ','','Dut ','','Tui ',
        'Lin ','Jiong ','Zha ','Sing ','He ','Zing ','Xu ','','','Hei ','Cui ','Qing ','Mo ','Fung ','Zou ','Beng ',
        'Li ','','','Yan ','Ge ','Mo ','Bei ','Juan ','Die ','Shao ','','Wu ','Yan ','','Jue ','Hin ',
        ],
    'x3e':[
        'Tai ','Han ','','Dian ','Ji ','Jie ','','','Ziu ','Xie ','La ','Fan ','Huo ','Xi ','Nie ','Mi ',
        'Ran ','Cuan ','Yin ','Mi ','','Jue ','Keoi ','Tong ','Wan ','Ze ','Li ','Shao ','Kong ','Kan ','Ban ','Taai ',
        'Tiao ','Syu ','Bei ','Ye ','Pian ','Chan ','Hu ','Ken ','Gaau ','An ','Chun ','Qian ','Bei ','Baa ','Fen ','Fo ',
        'Tuo ','Tuo ','Zuo ','Ling ','','Gui ','Zin ','Shi ','Hou ','Lie ','Saa ','Si ','Fung ','Bei ','Ren ','Du ',
        'Bo ','Liang ','Ci ','Bi ','Ji ','Zong ','Fai ','He ','Li ','Yuan ','Yue ','Saau ','Chan ','Di ','Lei ','Jin ',
        'Chong ','Si ','Pu ','Yi ','Goeng ','Fun ','Huan ','Tao ','Ru ','Ying ','Ying ','Rao ','Yin ','Shi ','Yin ','Jue ',
        'Tun ','Xuan ','Gaa ','Zung ','Qie ','Zhu ','Ciu ','Zoeng ','You ','','Saan ','Xi ','Shi ','Yi ','Mo ','Huou ',
        '','Hu ','Xiao ','Wu ','Gang ','Jing ','Ting ','Shi ','Ni ','Gang ','Ta ','Waai ','Chu ','Chan ','Piao ','Diao ',
        'Nao ','Nao ','Gan ','Gou ','Yu ','Hou ','','Si ','Ci ','Hu ','Yang ','Zung ','Xian ','Ban ','Rong ','Lou ',
        'Zhao ','Can ','Liao ','Piao ','Hai ','Fan ','Han ','Dan ','Zhan ','','Ta ','Zhu ','Ban ','Jian ','Yu ','Zhuo ',
        'You ','Li ','Kut ','Hei ','Cim ','Chan ','Lian ','Heo ','Si ','Jiu ','Pu ','Qiu ','Gong ','Zi ','Yu ','',
        'Si ','Reng ','Niu ','Mei ','Baat ','Jiu ','','Xu ','Ping ','Bian ','Mao ','','','','','Yi ',
        'You ','Gwai ','Ping ','Kuk ','Bao ','Hui ','','','','Bu ','Mang ','La ','Tu ','Wu ','Li ','Ling ',
        '','Ji ','Jun ','Lit6','Duo ','Jue ','Dai ','Bei ','','','','','','La ','Bian ','Sui ',
        'Tu ','Die ','','','','','','Duo ','','','Sui ','Bi ','Tu ','Se ','Can ','Tu ',
        'Mian ','Zeon ','Lu ','','','Zhan ','Bi ','Ji ','Cen ','Hyun ','Li ','','','Sui ','Zung ','Shu ',
        ],
    'x3f':[
        '','','E ','','Gei ','','','Qiong ','Luo ','Yin ','Tun ','Gu ','Yu ','Lei ','Bei ','Nei ',
        'Pian ','Lian ','Qiu ','Lian ','Waan ','Dong ','Li ','Ding ','Wa ','Zhou ','Gong ','Xing ','Ang ','Fan ','Peng ','Bai ',
        'Tuo ','Syu ','E ','Bai ','Qi ','Chu ','Gong ','Tong ','Han ','Cheng ','Jia ','Huan ','Xing ','Dian ','Mai ','Dong ',
        'E ','Ruan ','Lie ','Sheng ','Ou ','Di ','Yu ','Chuan ','Rong ','Hong ','Tang ','Cong ','Piao ','Shuang ','Lu ','Tong ',
        'Zheng ','Li ','Sa ','Ban ','Si ','Dang ','Dong ','Guai ','Yi ','Han ','Xie ','Luo ','Liu ','Ham ','Dan ','',
        'Cim ','Tan ','Saang ','','','You ','Nan ','','Gang ','Jun ','Chi ','Kou ','Wan ','Li ','Liu ','Lie ',
        'Xia ','Baai ','An ','Yu ','Ju ','Rou ','Xun ','Zi ','Cuo ','Can ','Zeng ','Yong ','Fu ','Ruan ','Sing ','Xi ',
        'Shu ','Jiao ','Jiao ','Han ','Zhang ','Zong ','','Shui ','Chen ','Fan ','Ji ','Zi ','','Gu ','Wu ','Cui ',
        'Qie ','Shu ','Hoi ','Tuo ','Du ','Si ','Ran ','Mu ','Fu ','Ling ','Ji ','Xiu ','Xuan ','Nai ','At ','Jie ',
        'Li ','Da ','Ji ','Zyun ','Lu ','Shen ','Li ','Lang ','Geng ','Yin ','Se ','Qin ','Qie ','Che ','You ','Bu ',
        'Huang ','Que ','Lai ','Zaam ','Hong ','Xu ','Bang ','Ke ','Qi ','Gwaai ','Sheng ','Pin ','Gaai ','Zhou ','Huang ','Tui ',
        'Hu ','Bei ','','','Zaa ','Ji ','Gu ','Sai ','Gao ','Chai ','Ma ','Zhu ','Tui ','Tui ','Lian ','Lang ',
        'Baan ','','Zing ','Dai ','Ai ','Xian ','Gwo ','Xi ','Zung ','Tui ','Can ','Sao ','Cim ','Jie ','Fen ','Qun ',
        '','Yao ','Dao ','Jia ','Lei ','Yan ','Lu ','Tui ','Ying ','Pi ','Luo ','Li ','Bie ','Hoeng ','Mao ','Bai ',
        'huang ','Dau ','Yao ','He ','Chun ','Hu ','Ning ','Chou ','Li ','Tang ','Huan ','Bi ','Baa ','Che ','Yang ','Da ',
        'Ao ','Xue ','Zi ','','Daap ','Ran ','Bong ','Zao ','Wan ','Ta ','Bao ','Gon ','Yan ','Gaai ','Zhu ','Ya ',
        ],
    'x40':[
        'Fan ','You ','On ','Tui ','Meng ','She ','Jin ','Gu ','Qi ','Qiao ','Jiao ','Yan ','','Kan ','Mian ','Xian ',
        'San ','Na ','Cin ','Huan ','Niu ','Cheng ','Tin ','Jue ','Xi ','Qi ','Ang ','Mei ','Gu ','','Tou ','Fan ',
        'Qu ','Chan ','Shun ','Bi ','Mao ','Shuo ','Gu ','Hong ','Huan ','Luo ','Hang ','Jia ','Quan ','Goi ','Mang ','Bu ',
        'Gu ','Fung ','Mu ','Ai ','Ying ','Shun ','Lang ','Jie ','Di ','Jie ','Cau ','Pin ','Ren ','Yan ','Du ','Di ',
        '','Lang ','Xian ','Biu ','Xing ','Bei ','An ','Mi ','Qi ','Qi ','Wo ','She ','Yu ','Jia ','Cheng ','Yao ',
        'Ying ','Yang ','Ji ','Jie ','Han ','Min ','Lou ','Kai ','Yao ','Yan ','Sun ','Gui ','Huang ','Ying ','Sheng ','Cha ',
        'Lian ','','Xuan ','Chuan ','Che ','Ni ','Qu ','Miao ','Huo ','Yu ','Nan ','Hu ','Ceng ','Biu ','Qian ','She ',
        'Jiang ','Ao ','Mai ','Mang ','Zhan ','Bian ','Jiao ','Jue ','Nong ','Bi ','Shi ','Li ','Mo ','Lie ','Mie ','Mo ',
        'Xi ','Chan ','Qu ','Jiao ','Huo ','Zin ','Xu ','Nang ','Tong ','Hou ','Yu ','','Cung ','Bo ','Zuan ','Diu ',
        'Chuo ','Ci ','Jie ','Kwai ','Xing ','Hui ','Shi ','Gwaat6','Caam ','','Yao ','Yu ','Bang ','Jie ','Zhe ','Gaa ',
        'She ','Di ','Dong ','Ci ','Fu ','Min ','Zhen ','Zhen ','','Yan ','Diao ','Hong ','Gong ','Diu6','Lue ','Guai ',
        'La ','Cui ','Fa ','Cuo ','Yan ','Gung ','Jie ','Gwaai ','Guo ','Suo ','Wan ','Zheng ','Nie ','Diao ','Lai ','Ta ',
        'Cui ','Aa ','Gun ','','','Dai ','','Mian ','Gaai ','Min ','Ju ','Yu ','Zan ','Zhao ','Ze ','Saang ',
        '','Pan ','He ','Gou ','Hong ','Lao ','Wu ','Chuo ','Hang ','Lu ','Cu ','Lian ','Zi ','Qiao ','Shu ','',
        'xuan ','Cen ','Zaam ','Hui ','Su ','Chuang ','Deon ','Long ','','Nao ','Tan ','Dan ','Wei ','Gan ','Da ','Li ',
        'Caat ','Xian ','Pan ','La ','Zyu ','Niao ','Huai ','Ying ','Xian ','Lan ','Mo ','Ba ','','Fu ','Bi ','Fu ',
        ],
    'x41':[
        'Huo ','Yi ','Liu ','Zoeng ','Zaan ','Juan ','Huo ','Cheng ','Dou ','E ','','Yan ','Zhui ','Du ','Qi ','Yu ',
        'Quan ','Huo ','Nie ','Heng ','Ju ','She ','','','Peng ','Ming ','Cao ','Lou ','Li ','Chun ','','Cui ',
        'Shan ','Daam ','Qi ','','Lai ','Ling ','Liao ','Reng ','Yu ','Nao ','Chuo ','Qi ','Yi ','Nian ','Fu ','Jian ',
        'Ya ','Fong ','Chui ','Cin ','','','Bi ','Dan ','Po ','Nian ','Zhi ','Chao ','Tian ','Tian ','Rou ','Yi ',
        'Lie ','An ','He ','Qiong ','Li ','Gwai ','Zi ','Su ','Yuan ','Ya ','Du ','Wan ','Gyun ','Dong ','You ','Hui ',
        'Jian ','Rui ','Mang ','Ju ','Zi ','Geoi ','An ','Sui ','Lai ','Hun ','Qiang ','Coeng ','Duo ','Hung ','Na ','Can ',
        'Ti ','Xu ','Jiu ','Huang ','Qi ','Jie ','Mao ','Yan ','Heoi ','Zhi ','Tui ','','Ai ','Pang ','Cang ','Tang ',
        'En ','Hun ','Qi ','Chu ','Suo ','Zhuo ','Nou ','Tu ','Zu ','Lou ','Miao ','Li ','Man ','Gu ','Cen ','Hua ',
        'Mei ','Gou ','Lian ','Dao ','Shan ','Ci ','','','Zhi ','Ba ','Cui ','Qiu ','','Long ','Cim ','Fei ',
        'Guo ','Cheng ','Jiu ','E ','Cung ','Jue ','Hong ','Jiao ','Cuan ','Yao ','Tong ','Cha ','You ','Shu ','Yao ','Ge ',
        'Huan ','Lang ','Jue ','Chen ','Cyun ','Cyun ','Shen ','Fo ','Ming ','Ming ','Hung ','Chuang ','Yun ','Han6','Jin ','Chuo ',
        'Zyu ','Tan ','Hong ','Qiong ','','Cheng ','Zaau ','Yu ','Cheng ','Tong ','Pun ','Qiao ','Fo ','Ju ','Lan ','Yi ',
        'Rong ','Si ','Hin ','Si ','Ngat ','Fa ','','Meng ','Gui ','','','Hai ','Qiao ','Chuo ','Que ','Dui ',
        'Li ','Ba ','Jie ','Seoi ','Luo ','Deoi ','Yun ','Zung ','Hu ','Yin ','Pok ','Zhi ','Lian ','Zim ','Gan ','Jian ',
        'Zhou ','Zhu ','Ku ','Na ','Dui ','Ze ','Yang ','Zhu ','Gong ','Yi ','Ci ','Gei ','Chuang ','Lao ','Ren ','Rong ',
        'Zing ','Na ','Ce ','Zin ','','Yi ','Jue ','Bi ','Cheng ','Jun ','Chou ','Hui ','Chi ','Zhi ','Yan ','',
        ],
    'x42':[
        'Saan ','Lun ','Bing ','Zhao ','Han ','Yu ','Dai ','Zhao ','Fei ','Sha ','Ling ','Ta ','Zeoi ','Mang ','Ye ','Bao ',
        'Kui ','Gua ','Nan ','Ge ','Gaa ','Chi ','Fo ','Suo ','Ci ','Zhou ','Tai ','Kuai ','Qin ','Seoi ','Du ','Ce ',
        'Huan ','Gung ','Sai ','Zheng ','Qian ','Gan ','Zung ','Wei ','','','Xi ','Na ','Pu ','Huai ','Ju ','Zaan ',
        'Sau ','Tou ','Pan ','Ta ','Qian ','Zung ','Rong ','Luo ','Hu ','Sou ','Zung ','Pu ','Mie ','Gan ','Shuo ','Mai ',
        'Shu ','Ling ','Lei ','Jiang ','Leng ','Zhi ','Diao ','','San ','Hu ','Fan ','Mei ','Sui ','Jian ','Tang ','Xie ',
        'Fu ','Mo ','Fan ','Lei ','Can ','Ceng ','Ling ','Zaap ','Cong ','Yun ','Meng ','Yu ','Zhi ','Qi ','Dan ','Huo ',
        'Wei ','Tan ','Se ','Xie ','Sou ','Song ','Cin ','Liu ','Yi ','Aau ','Lei ','Li ','Fei ','Lie ','Lin ','Xian ',
        'Yao ','Aau ','Bie ','Xian ','Rang ','Zhuan ','Soeng ','Dan ','Bian ','Ling ','Hong ','Qi ','Liao ','Ban ','Mi ','Hu ',
        'Hu ','Caap ','Ce ','Pei ','Qiong ','Ming ','Jiu ','Bu ','Mei ','San ','Mei ','Zong ','','Li ','Quan ','Sam ',
        'En ','Xiang ','Zing ','Shi ','Zing ','Gin ','Lan ','Huang ','Jiu ','Yan ','Deoi ','Sa ','Tuan ','Xie ','Zhe ','Men ',
        'Xi ','Man ','Zoeng ','Huang ','Tan ','Xiao ','Ya ','Bi ','Luo ','Fan ','Li ','Cui ','Cha ','Chou ','Di ','Kuang ',
        'Chu ','Cim ','Chan ','Mi ','Qian ','Qiu ','Zhen ','Chai ','Heoi ','Cim ','Gu ','Yan ','Chi ','Guai ','Mu ','Bo ',
        'Kua ','Geng ','Yao ','Mao ','Wang ','','','','Ru ','Jue ','Zing ','Min ','Jiang ','O ','Zhan ','Zuo ',
        'Yue ','Bing ','Nou6','Zhou ','Bi ','Ren ','Yu ','Gin ','Chuo ','Er ','Yi ','Mi ','Qing ','Zing ','Wang ','Ji ',
        'Bu ','Syu ','Bie ','Fan ','Yao ','Li ','Fan ','Qu ','Fu ','Er ','O ','Zang ','Zim ','Huo ','Jin ','Qi ',
        'Ju ','Lai ','Che ','Bei ','Niu ','Yi ','Xu ','Liu ','Xun ','Fu ','Cau ','Nin ','Ting ','Beng ','Zha ','Wui ',
        ],
    'x43':[
        'Fo ','Zaau ','Ou ','Shuo ','Geng ','Tang ','Gui ','Hui ','Ta ','Gong ','Yao ','Daap ','Qi ','Han ','Lue ','Mi ',
        'Mi ','Gin ','Lu ','Fan ','Ou ','Mi ','Jie ','Fu ','Mi ','Huang ','Su ','Yao ','Nie ','Jin ','Lian ','Bi ',
        'Qing ','Ti ','Ling ','Zuan ','Zhi ','Yin ','Dao ','Chou ','Cai ','Mi ','Yan ','Lan ','Chong ','Ziu ','Soeng ','Guan ',
        'She ','Luo ','Fan ','Si ','Luo ','Zhu ','Zi ','Chou ','Juan ','Jiong ','Er ','Yi ','Rui ','Cai ','Ren ','Fu ',
        'Lan ','Sui ','Yu ','Yao ','Dian ','Ling ','Zhu ','Ta ','Ping ','Qian ','Jue ','Chui ','Bu ','Gu ','Cun ','',
        'Han ','Han ','Mou ','Hu ','Hong ','Di ','Fu ','Xuan ','Mi ','Mei ','Lang ','Gu ','Zhao ','Ta ','Yu ','Zong ',
        'Li ','Liao ','Wu ','Lei ','Ji ','Lei ','Li ','Zong ','Bo ','Ang ','Kui ','Tuo ','Ping ','Cau ','Zhao ','Gui ',
        'Zaan ','Xu ','Nai ','Chuo ','Duo ','Kaap ','Dong ','Gui ','Bo ','Zin ','Huan ','Xuan ','Can ','Li ','Tui ','Huang ',
        'Xue ','Hu ','Bao ','Ran ','Tiao ','Fu ','Liao ','Zaau ','Yi ','Shu ','Po ','He ','Cu ','Fu ','Na ','An ',
        'Chao ','Lu ','Zhan ','Ta ','Fu ','Gwaang ','Zang ','Qiao ','Su ','Baan ','Guan ','','Fan ','Chu ','','Er ',
        'Er ','Nuan ','Qi ','Si ','Chu ','','Yan ','Bang ','An ','Zi ','Ne ','Chuang ','Ba ','Ciu ','Ti ','Han ',
        'Zuo ','Ba ','Zhe ','Wa ','Sheng ','Bi ','Er ','Zhu ','Wu ','Wen ','Zhi ','Zhou ','Lu ','Wen ','Gun ','Qiu ',
        'La ','Zai ','Sou ','Mian ','Zhi ','Qi ','Cao ','Piao ','Lian ','Saap ','Long ','Su ','Qi ','Yuan ','Feng ','Heoi ',
        'Jue ','Di ','Pian ','Guan ','Niu ','Ren ','Zhen ','Gai ','Pi ','Tan ','Chao ','Chun ','Ho ','Chun ','Mo ','Bie ',
        'Qi ','Shi ','Bi ','Jue ','Si ','Taam ','Hua ','Na ','Hui ','Kaap ','Er ','Caau ','Mou ','Zyu ','Xi ','Zhi ',
        'Ren ','Ju ','Die ','Zhe ','Shao ','Meng ','Bi ','Han ','Yu ','Xian ','Pong ','Neng ','Can ','Bu ','Bong ','Qi ',
        ],
    'x44':[
        'Ji ','Niao ','Lu ','Jiong ','Han ','Yi ','Cai ','Chun ','Zhi ','Zi ','Da ','Cung ','Tian ','Zhou ','Daai ','Chun ',
        'Cau ','Zhe ','Zaa ','Rou ','Bin ','Ji ','Yi ','Du ','Jue ','Ge ','Ji ','Dap ','Can ','Suo ','Ruo ','Xiang ',
        'Huang ','Qi ','Zhu ','Cuo ','Chi ','Weng ','Haap6','Kao ','Gu ','Kai ','Fan ','Sung ','Cao ','Zhi ','Chan ','Lei ',
        'Gaau ','Zak6','Zhe ','Yu ','Gui ','Huang ','Jin ','Daan ','Guo ','Sao ','Tan ','','Xi ','Man ','Duo ','Ao ',
        'Pi ','Wu ','Ai ','Meng ','Pi ','Meng ','Yang ','Zhi ','Bo ','Ying ','Wei ','Nao ','Lan ','Yan ','Chan ','Quan ',
        'Zhen ','Pu ','','Tai ','Fei ','Shu ','','Dang ','Cha ','Ran ','Tian ','Chi ','Ta ','Jia ','Shun ','Huang ',
        'Liao ','Caa ','Dou ','','Jin ','E ','Keoi ','Fu ','Duo ','','E ','','Yao ','Di ','','Di ',
        'Bu ','Man ','Che ','Lun ','Qi ','Mu ','Can ','','Zung ','Sau ','Fan ','You ','Saau ','Da ','','Su ',
        'Fu ','Ji ','Jiang ','Cao ','Bo ','Teng ','Che ','Fu ','Bu ','Wu ','Haai ','Yang ','Ming ','Pang ','Mang ','Zang ',
        'Meng ','Cao ','Tiao ','Kai ','Bai ','Xiao ','Xin ','Qi ','Seoi ','','Shao ','Heng ','Niu ','Xiao ','Chen ','Daan ',
        'Fan ','Yin ','Ang ','Ran ','Ri ','Fa ','Fan ','Qu ','Shi ','He ','Bian ','Dai ','Mo ','Deng ','','',
        'Hong ','Zing ','Cha ','Duo ','You ','Hao ','Tin ','Kut ','Xian ','Lei ','Jin ','Qi ','','Mei ','Zi ','',
        '','','Yan ','Yi ','Yin ','Qi ','Zhe ','Xi ','Yi ','Ye ','E ','','Zhi ','Han ','Chuo ','',
        'Chun ','Bing ','Kuai ','Chou ','','Tuo ','Qiong ','Cung ','Jiu ','Gwai ','Cu ','Fu ','','Meng ','Li ','Lie ',
        'Ta ','Zi ','Gu ','Liang ','Fat ','La ','Dian ','Ci ','Aang ','','','Ji ','','Cha ','Mao ','Du ',
        'Zaan ','Chai ','Rui ','Hen ','Ruan ','','Lai ','Xing ','Gan ','Yi ','Mei ','','He ','Ji ','So ','Han ',
        ],
    'x45':[
        'Seoi ','Li ','Zi ','Zu ','Yao ','Geoi ','Li ','Qi ','Gan ','Li ','','','','','Su ','Chou ',
        '','Xie ','Bei ','Xu ','Jing ','Pu ','Ling ','Xiang ','Zuo ','Diao ','Chun ','Qing ','Nan ','','Lu ','Chi ',
        'Shao ','Yu ','Hua ','Li ','','Siu ','','Li ','','','Dui ','','Yi ','Ning ','Si ','Hu ',
        'Fu ','Zaap ','Cheng ','Nan ','Ce ','Gaan ','Ti ','Qin ','Biao ','Sui ','Wei ','Deon ','Se ','Ai ','E ','Jie ',
        'Kuan ','Fei ','','Yin ','Zing ','Sao ','Dou ','Hui ','Xie ','Ze ','Tan ','Chang ','Zhi ','Yi ','Fu ','E ',
        '','Jun ','Gaa ','Cha ','Xian ','Man ','Syun ','Bi ','Ling ','Jie ','Kui ','Jia ','','Sang ','Lang ','Guk ',
        'Fei ','Lu ','Zha ','He ','','Ni ','Ying ','Xiao ','Teng ','Lao ','Ze ','Kui ','Goeng ','Qian ','Ju ','Piao ',
        'Ban ','Dou ','Lin ','Mi ','Zhuo ','Xie ','Hu ','Mi ','Gaai ','Za ','Cong ','Ge ','Nan ','Zhu ','Yan ','Han ',
        'Ceoi ','Yi ','Luan ','Yue ','Ran ','Ling ','Niang ','Yu ','Nue ','Heoi ','Yi ','Nue ','Qin ','Qian ','Xia ','Chu ',
        'Jin ','Mi ','','Na ','Han ','Zu ','Xia ','Yan ','Tu ','','Wu ','Suo ','Yin ','Chong ','Zhou ','Mang ',
        'Yuan ','Nu ','Miao ','Sao ','Wan ','Li ','','Na ','Shi ','Bi ','Ci ','Bang ','','Juan ','Xiang ','Gui ',
        'Pai ','Hong ','Xun ','Zha ','Yao ','Kwan ','','He ','E ','Yang ','Tiao ','You ','Jue ','Li ','','Li ',
        '','Ji ','Hu ','Zhan ','Fu ','Chang ','Guan ','Ju ','Meng ','Coeng ','Cheng ','Mou ','Sing ','Li ','Zaan ','',
        'Si ','Yi ','Bing ','Cung ','Hou ','Wan ','Chi ','','Ge ','Han ','Bo ','Saau ','Liu ','Can ','Can ','Yi ',
        'Xuan ','Yan ','Suo ','Gao ','Yong ','Zung ','Fung ','Hong ','Yu ','Cik ','Zhe ','Ma ','Fung ','','Shuang ','Jin ',
        'Guan ','Pu ','Lin ','','Ting ','Goeng ','La ','Yi ','Zung ','Ci ','Yan ','Jie ','Faan ','Wei ','Xian ','Ning ',
        ],
    'x46':[
        'Fu ','Ge ','','Mo ','Fu ','Nai ','Xian ','Wen ','Li ','Can ','Mie ','','Ni ','Chai ','Wan ','Xu ',
        'Nu ','Mai ','Co ','Kan ','Ho ','Hang ','','Faai ','Yu ','Wei ','Zhu ','Gei ','Gan ','Yi ','','',
        'Fu ','Bi ','Zhu ','Zi ','Shu ','Xia ','Ni ','','Jiao ','Xuan ','Cung ','Nou ','Rong ','Die ','Sa ','Sau ',
        '','Yu ','','Kaam ','Zung ','Lu ','Han ','','Yi ','Zui ','Zhan ','Su ','Wan ','Ni ','Guan ','Jue ',
        'Beng ','Can ','Zung ','Duo ','Qi ','Yao ','Gui ','Nuan ','Hou ','Xun ','Xie ','','Hui ','','Xie ','Bo ',
        'Ke ','Ceoi ','Xu ','Bai ','Aau ','Chu ','Bang ','Ti ','Chu ','Chi ','Niao ','Guan ','Feng ','Xie ','Dang ','Duo ',
        'Jue ','Hui ','Zeng ','Sa ','Duo ','Ling ','Meng ','Fan ','Guo ','Meng ','Long ','','Ying ','Hin ','Guan ','Cu ',
        'Li ','Du ','Ceng ','E ','Sin ','Saai ','','De ','De ','Jiang ','Lian ','','Shao ','Xi ','Si ','Wei ',
        '','','He ','You ','Lu ','Lai ','Ou ','Sheng ','Juan ','Qi ','','Yun ','','Qi ','Zong ','Leng ',
        'Ji ','Mai ','Chuang ','Nian ','Baan ','Li ','Ling ','Gong ','Chen ','','Xian ','Hu ','Bei ','Zu ','Dai ','Dai ',
        'Hun ','Soi ','Che ','Ti ','','Nuo ','Zhi ','Liu ','Fei ','Jiao ','Gwaan ','Ao ','Lin ','','Reng ','Tao ',
        'Pi ','Xin ','Shan ','Xie ','Wa ','Tao ','Tin ','Xi ','Xie ','Pi ','Yao ','Yao ','Nu ','Hao ','Nin ','Yin ',
        'Fan ','Nan ','Chi ','Wang ','Yuan ','Xia ','Zhou ','Yuan ','Shi ','Mi ','','Ge ','Pao ','Fei ','Hu ','Ni ',
        'Ci ','Mi ','Bian ','Gam ','Na ','Yu ','E ','Zhi ','Nin ','Xu ','Lue ','Hui ','Xun ','Nao ','Han ','Jia ',
        'Dou ','Hua ','Tuk ','','Cu ','Xi ','Song ','Mi ','Xin ','Wu ','Qiong ','Zheng ','Chou ','Xing ','Jiu ','Ju ',
        'Hun ','Ti ','Man ','Jian ','Qi ','Shou ','Lei ','Wan ','Che ','Can ','Jie ','You ','Hui ','Zha ','Su ','Ge ',
        ],
    'x47':[
        'Nao ','Xi ','','Deoi ','Chi ','Wei ','Mo ','Gun ','Cau ','','Zao ','Hui ','Luan ','Liao ','Lao ','',
        '','Qia ','Ao ','Nie ','Sui ','Mai ','Tan ','Xin ','Jing ','An ','Ta ','Chan ','Wei ','Tuan ','Ji ','Chen ',
        'Che ','Xu ','Xian ','Xin ','','Daan ','','Nao ','','Yan ','Qiu ','Hong ','Song ','Jun ','Liao ','Ju ',
        '','Man ','Lie ','','Chu ','Chi ','Xiang ','Cam ','Mei ','Shu ','Ce ','Chi ','Gu ','Yu ','Zaam ','',
        'Liao ','Lao ','Shu ','Zhe ','Soeng ','','Fat ','Fui ','E ','','Sha ','Zong ','Jue ','Jun ','','Lou ',
        'Wei ','Cung ','Zhu ','La ','Fun ','Zhe ','Zhao ','Zaau ','Yi ','','Ni ','Bo ','Syun ','Yi ','Hao ','Ya ',
        'Huan ','Man ','Man ','Qu ','Lao ','Hao ','','Men ','Xian ','Zhen ','Shu ','Zuo ','Zhu ','Gou ','Xuan ','Yi ',
        'Ti ','xie ','Jin ','Can ','Zai ','Bu ','Liang ','Zhi ','Ji ','Wan ','Guan ','Ceoi ','Qing ','Ai ','Fu ','Gui ',
        'Gou ','Xian ','Ruan ','Zhi ','Biao ','Yi ','Suo ','Die ','Gui ','Sheng ','Xun ','Chen ','She ','Qing ','','',
        'Chun ','Hong ','Dong ','Cheng ','Wei ','Die ','Shu ','Caai ','Ji ','Za ','Qi ','','Fu ','Ao ','Fu ','Po ',
        '','Tan ','Zha ','Che ','Qu ','You ','He ','Hou ','Gui ','E ','Jiang ','Yun ','Tou ','Qiu ','','Fu ',
        'Zuo ','Hu ','','Bo ','','Jue ','Di ','Jue ','Fu ','Huang ','','Yong ','Chui ','Suo ','Chi ','Hin ',
        '','','Man ','Ca ','Qi ','Jian ','Bi ','Gei ','Zhi ','Zhu ','Qu ','Zhan ','Ji ','Dian ','','Li ',
        'Li ','La ','Quan ','Ding ','Fu ','Cha ','Tang ','Shi ','Hang ','Qie ','Qi ','Bo ','Na ','Tou ','Chu ','Cu ',
        'Yue ','Di ','Chen ','Chu ','Bi ','Mang ','Ba ','Tian ','Min ','Lie ','Feng ','Caang ','Qiu ','Tiao ','Fu ','Kuo ',
        'Jian ','Ci ','','','Zhen ','Qiu ','Cuo ','Chi ','Kui ','Lie ','Bang ','Du ','Wu ','So ','Jue ','Lu ',
        ],
    'x48':[
        'Chang ','Zai ','Chu ','Liang ','Tian ','Kun ','Chang ','Jue ','Tu ','Hua ','Fei ','Bi ','','Qia ','Wo ','Ji ',
        'Qu ','Kui ','Hu ','Cu ','Sui ','','','Qiu ','Pi ','Bei ','Wa ','Jiao ','Rong ','','Cu ','Die ',
        'Chi ','Cuo ','Meng ','Xuan ','Duo ','Bie ','Zhe ','Chu ','Chan ','Gui ','Duan ','Zou ','Deng ','Lai ','Teng ','Yue ',
        'Quan ','Shu ','Ling ','','Qin ','Fu ','She ','Tiao ','','Ai ','','Qiong ','Diao ','Hai ','Shan ','Wai ',
        'Zhan ','Long ','Jiu ','Li ','','Min ','Rong ','Yue ','Jue ','Kang ','Fan ','Qi ','Hong ','Fu ','Lu ','Hong ',
        'Tuo ','Min ','Tian ','Juan ','Qi ','Zheng ','Jing ','Gong ','Tian ','Lang ','Mao ','Yin ','Lu ','Yun ','Ju ','Pi ',
        '','Xie ','Bian ','','Zeoi ','Rong ','Sang ','Wu ','Cha ','Gu ','Chan ','Peng ','Man ','Saau ','Zung ','Shuang ',
        'Keng ','Zhuan ','Chan ','Si ','Chuang ','Sui ','Bei ','Kai ','','Zhi ','Wei ','Min ','Ling ','','Nei ','Ling ',
        'Qi ','Yue ','Lip ','Yi ','Xi ','Chen ','','Rong ','Chen ','Nong ','You ','Ji ','Bo ','Fang ','Gei ','',
        'Cu ','Di ','Gaau ','Yu ','Ge ','Xu ','Lu ','He ','','Bai ','Gong ','Jiong ','Gwai ','Ya ','Nu ','You ',
        'Song ','Xie ','Cang ','Yao ','Shu ','Yan ','Shuai ','Liao ','Sung ','Yu ','Bo ','Sui ','Cin ','Yan ','Lei ','Lin ',
        'Tai ','Du ','Yue ','Ji ','Cin ','Yun ','Bong ','','','Ju ','Ceot ','Chen ','Cung ','Xiang ','Xian ','On ',
        'Gui ','Yu ','Lei ','','Tu ','Chen ','Xing ','Qiu ','Hang ','','Dang ','Cai ','Di ','Yan ','Ci ','Gung ',
        'Zing ','Chan ','','Li ','Suo ','Ma ','Ma ','','Tang ','Pei ','Lou ','Sat ','Cuo ','Tu ','E ','Can ',
        'Jie ','Ti ','Ji ','Dang ','Jiao ','Bi ','Lei ','Yi ','Chun ','Chun ','Po ','Li ','Zai ','Tai ','Po ','Tian ',
        'Ju ','Xu ','Fan ','','Xu ','Er ','Huo ','Chua ','Ran ','Fa ','Gyun ','','Liang ','Ti ','Mi ','',
        ],
    'x49':[
        '','Cen ','Mei ','Yin ','Mian ','Tu ','Kui ','Sau ','Hei ','Mi ','Rong ','Guo ','Coeng ','Mi ','Ju ','Pi ',
        'Jin ','Wang ','Ji ','Meng ','Jian ','Xue ','Bao ','Gan ','Chan ','Li ','Li ','Qiu ','Dun ','Ying ','Yun ','Chen ',
        'Ji ','Ran ','','Lue ','','Gui ','Yue ','Hui ','Pi ','Cha ','Duo ','Chan ','So ','Kuan ','She ','Xing ',
        'Weng ','Shi ','Chi ','Ye ','Han ','Fei ','Ye ','Yan ','Zuan ','Saau ','Yin ','Duo ','Xian ','Gwaan ','Tou ','Qie ',
        'Chan ','Han ','Meng ','Yue ','Cu ','Qian ','Jin ','Shan ','Mu ','Zyun ','Coeng ','Baang ','Zheng ','Zhi ','Chun ','Yu ',
        'Mou ','Wan ','Chou ','Kei ','Su ','Pie ','Tian ','Kuan ','Cu ','Sui ','Co ','Jie ','Jian ','Ao ','Jiao ','Ye ',
        'Saam ','Ye ','Long ','Zao ','Bao ','Lian ','','Huan ','Lu ','Wei ','Xian ','Tie ','Bo ','Zheng ','Zhu ','Ba ',
        'Meng ','Xie ','Aau ','Zaau ','Teon ','Xiao ','Li ','Zha ','Mi ','','Ye ','','','Put ','Xie ','',
        '','Bong ','Shan ','Coeng ','','Shan ','Jue ','Ji ','Fang ','','Niao ','Ao ','Chu ','Wu ','Guan ','Xie ',
        'Ting ','Xie ','Dang ','Zim ','Tan ','Ping ','Xia ','Xu ','Bi ','Si ','Huo ','Zheng ','Wu ','','Run ','Chuai ',
        'Shi ','Huan ','Kuo ','Fu ','Chuai ','Xian ','Qin ','Qie ','Lan ','','Ya ','Zing ','Que ','','Chun ','Zhi ',
        'Gau ','Kui ','Qian ','Hang ','Yi ','Ni ','Zheng ','Chuai ','','Shi ','Cap ','Ci ','Jue ','Xu ','Yun ','',
        '','Chu ','Dao ','Dian ','Ge ','Ti ','Hong ','Ni ','','Li ','','Xian ','Seoi ','Xi ','Xuan ','',
        'Gwik ','Taai ','Lai ','Zau ','Mu ','Cheng ','Jian ','Bi ','Qi ','Ling ','Hao ','Bang ','Tang ','Di ','Fu ','Xian ',
        'Shuan ','Zung ','Keoi ','Zaan ','Pu ','Hui ','Wei ','Yi ','Ye ','','Che ','Hao ','Baai ','','Xian ','Chan ',
        'Hun ','Gaau ','Han ','Ci ','Zi ','Qi ','Kui ','Rou ','Gu ','Zing ','Xiong ','Gap ','Hu ','Cui ','Syu ','Que ',
        ],
    'x4a':[
        'Di ','Che ','Cau ','','Yan ','Liao ','Bi ','Soeng ','Ban ','Zing ','','Nue ','Bao ','Ying ','Hong ','Ci ',
        'Qia ','Ti ','Yu ','Lei ','Bao ','Wu ','Ji ','Fu ','Xian ','Cen ','Fat ','Se ','Baang ','Cing ','Yu ','Waa ',
        'Ai ','Han ','Dan ','Ge ','Di ','Hu ','Pang ','Zaam ','Zaa ','Ling ','Mai ','Mai ','Lian ','Siu ','Xue ','Zhen ',
        'Po ','Fu ','Nou ','Xi ','Dui ','Dan ','Yun ','Xian ','Yin ','Suk ','Dui ','Beng ','Hu ','Fei ','Fei ','Qian ',
        'Bei ','Fei ','','Shi ','Tian ','Zhan ','Jian ','','Hui ','Fu ','Wan ','Mo ','Qiao ','Liao ','','Mie ',
        'Ge ','Hong ','Yu ','Qi ','Duo ','Ang ','Saa ','Ba ','Di ','Xuan ','Di ','Bi ','Zhou ','Pao ','Nian ','Yi ',
        'Ting ','Jia ','Da ','Duo ','Xi ','Dan ','Tiao ','Xie ','Chang ','Yuan ','Guan ','Liang ','Beng ','Gei ','Lu ','Ji ',
        'Xuan ','Shu ','Dou ','Shu ','Hu ','Yun ','Chan ','Bong ','Rong ','E ','Zung ','Ba ','Feng ','Zyu ','Zhe ','Fen ',
        'Guan ','Bu ','Ge ','Deon ','Huang ','Du ','Ti ','Bo ','Qian ','La ','Long ','Wei ','Zhan ','Lan ','Seoi ','Na ',
        'Bi ','Tuo ','Jiao ','','Bu ','Ju ','Po ','Xia ','Wei ','Fu ','He ','Fan ','Chan ','Hu ','Za ','',
        'Saai ','Zai ','Zai ','Zai ','Fan ','Die ','Hong ','Chi ','Bao ','Yin ','','Haang ','Bo ','Ruan ','Chou ','Ying ',
        'Zi ','Gai ','Kwaan ','Yun ','Zhen ','Ya ','Zeoi ','Hou ','Min ','Pei ','Ge ','Bian ','Zyut ','Hao ','Mi ','Sheng ',
        'Gen ','Bi ','Duo ','Chun ','Chua ','San ','Cheng ','Ran ','Zen ','Mao ','Bo ','Tui ','Pi ','Fu ','Zyut ','Hei ',
        'Lin ','Hei ','Men ','Wu ','Qi ','Zhi ','Chen ','Xia ','He ','Sang ','Gwaa ','Hou ','Au ','Fu ','Rao ','Hun ',
        'Pei ','Qian ','Si ','Xi ','Ming ','Kui ','Ge ','','Ao ','San ','Shuang ','Lou ','Zhen ','Hui ','Can ','Ci ',
        'Lin ','Na ','Han ','Du ','Jin ','Mian ','Fan ','E ','Nao ','Hong ','Hong ','Xue ','Xue ','Pau ','Bi ','Ciu ',
        ],
    'x4b':[
        'You ','Yi ','Xue ','Sa ','Yu ','Li ','Li ','Yuan ','Dui ','Hao ','Qie ','Leng ','Paau ','Fat ','Guo ','Bu ',
        'Wei ','Wei ','Saau ','An ','Xu ','Shang ','Heng ','Yang ','Gwik ','Yao ','Fan ','Bi ','Ci ','Heng ','Tao ','Liu ',
        'Fei ','Zhu ','Tou ','Qi ','Chao ','Yi ','Dou ','Yuan ','Cu ','Zai ','Bo ','Can ','Yang ','Tou ','Yi ','Nian ',
        'Shao ','Ben ','Ngaau ','Ban ','Mo ','Ai ','En ','She ','Caan ','Zhi ','Yang ','Jian ','Yuan ','Dui ','Ti ','Wei ',
        'Xun ','Zhi ','Yi ','Ren ','Shi ','Hu ','Ne ','Yi ','Jian ','Sui ','Ying ','Bao ','Hu ','Hu ','Xie ','',
        'Yang ','Lian ','Sik ','En ','Deoi ','Jian ','Zhu ','Ying ','Yan ','Jin ','Chuang ','Dan ','','Kuai ','Yi ','Ye ',
        'Jian ','En ','Ning ','Ci ','Qian ','Xue ','Bo ','Mi ','Shui ','Mi ','Liang ','Qi ','Qi ','Shou ','Bi ','Bo ',
        'Beng ','Bie ','Ni ','Wei ','Huan ','Fan ','Qi ','Liu ','Fu ','Ang ','Ang ','Fan ','Qi ','Qun ','Tuo ','Yi ',
        'Bo ','Pian ','Bo ','Keoi ','Xuan ','','Baai6','Yu ','Chi ','Lu ','Yi ','Li ','Zaau ','Niao ','Xi ','Wu ',
        'Gwing ','Lei ','Pei ','Zhao ','Zui ','Chuo ','Coeng ','An ','Er ','Yu ','Leng ','Fu ','Sha ','Huan ','Chu ','Sou ',
        'Bik ','Bi ','Die ','Song ','Di ','Li ','Giu ','Han ','Zai ','Gu ','Cheng ','Lou ','Mo ','Mi ','Mai ','Ao ',
        'Dan ','Zhu ','Huang ','Fan ','Deng ','Tong ','','Du ','Hu ','Wei ','Ji ','Chi ','Lin ','Biu ','Pang ','Jian ',
        'Nie ','Luo ','Ji ','Ngon ','Waa ','Nie ','Yi ','Gwaat6','Wan ','Ya ','Qia ','Bo ','Hau ','Ling ','Gan ','Huo ',
        'Hai ','Hong ','Heng ','Kui ','Cen ','Ting ','Lang ','Bi ','Huan ','Po ','Ou ','Jian ','Ti ','Sui ','Kwaa ','Dui ',
        'Ao ','Jian ','Mo ','Gui ','Kuai ','An ','Ma ','Qing ','Fen ','','Kao ','Hao ','Duo ','Cim ','Nai ','Seoi ',
        'Jie ','Fu ','Pa ','Sung ','Chang ','Nie ','Man ','Sung ','Ci ','Cim ','Kuo ','Gai ','Di ','Fu ','Tiao ','Zu ',
        ],
    'x4c':[
        'Wo ','Fei ','Cai ','Peng ','Shi ','Sou ','Rou ','Qi ','Cha ','Pan ','Bo ','Man ','Zong ','Ci ','Gui ','Ji ',
        'Lan ','Siu ','Meng ','Mian ','Pan ','Lu ','Cuan ','Gau ','Liu ','Yi ','Wen ','Li ','Li ','Zeng ','Zhu ','Hun ',
        'Shen ','Chi ','Xing ','Wang ','Dung ','Huo ','Pi ','Bou6','Mei ','Che ','Mei ','Chao ','Ju ','Nou ','','Ni ',
        'Ru ','Ling ','Ya ','','Qi ','Zi ','','Bang ','Gung ','Ze ','Jie ','Yu ','Xin ','Bei ','Ba ','Tuo ',
        'Ong ','Qiao ','You ','Di ','Jie ','Mo ','Sheng ','Shan ','Qi ','Shan ','Mi ','Dan ','Yi ','Geng ','Geng ','Tou ',
        'Fu ','Xue ','Yi ','Ting ','Tiao ','Mou ','Liu ','Caan ','Li ','Suk ','Lu ','Xu ','Cuo ','Ba ','Liu ','Ju ',
        'Zhan ','Ju ','Zang ','Zu ','Xian ','Zhi ','','','Zhi ','','','La ','Seoi ','Geng ','E ','Mu ',
        'Zhong ','Di ','Yan ','Zin ','Geng ','Zung ','Lang ','Yu ','Caau ','Na ','Hai ','Hua ','Zhan ','Coeng ','Lou ','Chan ',
        'Die ','Wei ','Xuan ','Zao ','Min ','Kwai ','Sou ','','','Si ','Tuo ','Cen ','Kuan ','Teng ','Nei ','Lao ',
        'Lu ','Yi ','Xie ','Yan ','Qing ','Pu ','Chou ','Xian ','Guan ','Jie ','Lai ','Meng ','Ye ','Ceoi ','Li ','Yin ',
        'Ceon ','Cau ','Teng ','Yu ','','Gau ','Cha ','Du ','Hong ','Si ','Xi ','Gaau ','Qi ','Ci ','Yuan ','Ji ',
        'Yun ','Fang ','Gung ','Hang ','Zhen ','Hu ','','','Jie ','Pei ','Gan ','Xuan ','Saang ','Dao ','Qiao ','Ci ',
        'Die ','Ba ','Tiao ','Wan ','Ci ','Zhi ','Bai ','Wu ','Bao ','Dan ','Ba ','Tong ','Gyun ','Gung ','Jiu ','Gui ',
        'Ci ','You ','Yuan ','Lao ','Jiu ','Fou ','Nei ','E ','E ','Xing ','He ','Yan ','Tu ','Bu ','Beng ','Kou ',
        'Chui ','Zeoi ','Qi ','Yuan ','Bit ','','Hyun ','Hou ','Huang ','Ziu ','Juan ','Kui ','E ','Ji ','Mo ','Chong ',
        'Bao ','Wu ','Zhen ','Xu ','Da ','Chi ','Gaai ','Cong ','Ma ','Kou ','Yan ','Can ','Aau ','He ','Dang ','Lan ',
        ],
    'x4d':[
        'Tong ','Yu ','Hang ','Nao ','Li ','Fen ','Pu ','Ling ','Ao ','Xuan ','Yi ','Xuan ','Meng ','Ang ','Lei ','Yan ',
        'Bao ','Die ','Ling ','Shi ','Jiao ','Lie ','Jing ','Ju ','Ti ','Pi ','Gang ','Jiao ','Huai ','Bu ','Di ','Huan ',
        'Yao ','Li ','Mi ','Fu ','Saang ','Gaa ','Ren ','Wai ','','Piao ','Lu ','Ling ','Yi ','Cai ','Shan ','Fat ',
        'Shu ','Tuo ','Mo ','He ','Tie ','Bing ','Peng ','Hun ','Fu ','Guo ','Bu ','Li ','Chan ','Bai ','Cuo ','Meng ',
        'Suo ','Qiang ','Zhi ','Kuang ','Bi ','Ao ','Meng ','Xian ','Guk ','Tou ','Teon ','Wei ','Cim ','Tan ','Caau ','Lao ',
        'Chan ','Ni ','Ni ','Li ','Dong ','Ju ','Jian ','Fu ','Sha ','Zha ','Tao ','Jian ','Nong ','Ya ','Jing ','Gan ',
        'Di ','Jian ','Mei ','Da ','Jian ','She ','Xie ','Zai ','Mang ','Li ','Gun ','Yu ','Ta ','Zhe ','Yang ','Tuan ',
        'Soeng ','He ','Diao ','Wei ','Yun ','Zha ','Qu ','Waa ','Caau ','Zi ','Ting ','Gu ','Soeng ','Ca ','Fu ','Tie ',
        'Ta ','Ta ','Zhuo ','Han ','Ping ','He ','Ceoi ','Zhou ','Bo ','Liu ','Nu ','Kaap ','Pao ','Di ','Sha ','Ti ',
        'Kuai ','Ti ','Qi ','Ji ','Chi ','Pa ','Jin ','Ke ','Li ','Ju ','Qu ','La ','Gu ','Qia ','Qi ','Xian ',
        'Jian ','Shi ','Xian ','Ai ','Hua ','Ju ','Ze ','Yao ','Tam ','Ji ','Cha ','Kan ','Gin ','','Yan ','Gwaai ',
        'Ziu ','Tong ','Nan ','Yue ','Ceoi ','Chi ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x4e':[
        'Il ','Ceng ','Kyo ','Chil ','Sang ','Ha ','','Man ','Cang ','Sam ','Sang ','Ha ','Ki ','Pwu ','Ye ','Myen ',
        'Kal ','Chwuk ','Chou ','Zhuan ','Cha ','Pi ','Sey ','Shi ','Kwu ','Pyeng ','Ye ','Cong ','Dong ','Si ','Sung ','Cwu ',
        'Kwu ','Lyang ','Cwu ','Yu ','Lyang ','Yan ','Pyeng ','Sang ','Kon ','Kwu ','Kay ','A ','Qiang ','Cwung ','Kuk ','Jie ',
        'Pong ','Kwan ','Koc ','Chan ','Lin ','Chak ','Cwu ','Ha ','Hwan ','Tan ','Wei ','Cwu ','Ceng ','Li ','Ju ','Pyel ',
        'Pwul ','Yi ','Yey ','Nay ','Shime ','Kwu ','Kwu ','Cek ','Yo ','Yi ','','Ci ','Wu ','Sa ','Ho ','Phip ',
        'Le ','Im ','Ping ','Pang ','Qiao ','Hu ','Koy ','Sung ','Sung ','Ul ','Yin ','','Mya ','Kwu ','Kel ','Ya ',
        'Xi ','Xiang ','Gai ','Kyu ','Hal ','','Shu ','Twul ','Si ','Kyey ','Nang ','Kal ','Kel ','Tol ','','Ol ',
        'Mai ','Lan ','Cal ','Yu ','Xue ','Yan ','Phol ','Sal ','Na ','Gan ','Sol ','El ','Cwul ','','Kan ','Chi ',
        'Kwi ','Ken ','Lan ','Lin ','Uy ','Kwel ','Lyo ','Ma ','Ye ','Zheng ','Sa ','Sa ','I ','Chok ','Wu ','Yu ',
        'Wul ','Wun ','Ho ','Ki ','O ','Ceng ','Si ','Sui ','Sen ','Kung ','Ya ','Sa ','A ','Cey ','A ','Kuk ',
        'Twu ','Mang ','Hang ','Ta ','Kyo ','Hay ','Yek ','Chan ','Hyeng ','Mu ','','Hyang ','Kyeng ','Ceng ','Lyang ','Xiang ',
        'Kyeng ','Ya ','Qin ','Pak ','Yu ','Xie ','Tan ','Lyem ','Duo ','Mi ','In ','In ','Ji ','La ','Mang ','Yi ',
        'Sip ','In ','Luk ','Ding ','Chuk ','Jin ','Pwu ','Kwu ','Ba ','Zhang ','Kum ','Kay ','Bing ','Ing ','Cong ','Pwul ',
        'San ','Lun ','Sya ','Cang ','Ca ','Sa ','Tha ','Cang ','Pwu ','Sen ','Hen ','Cha ','Hong ','Tong ','In ','Chen ',
        'Gan ','Hul ','Cak ','Tay ','Lyeng ','I ','Chao ','Chang ','Sa ','','Yi ','Mu ','Men ','In ','Ka ','Chao ',
        'Ang ','Qian ','Cwung ','Pi ','Wan ','O ','Ken ','Kay ','Yao ','Feng ','Cang ','Im ','Wang ','Pin ','Di ','Pang ',
        ],
    'x4f':[
        'Cong ','Ki ','Pei ','Ye ','Diao ','Ton ','Wen ','Yek ','Sim ','Hang ','I ','Kup ','Ai ','O ','Ki ','Pok ',
        'Pel ','Hyu ','Jin ','Bei ','Dan ','Fu ','Tang ','Zhong ','You ','Hwa ','Hoy ','Yu ','Col ','Cen ','San ','Wei ',
        'Chuan ','Che ','Ya ','Hyen ','Shang ','Chang ','Lun ','Cang ','Xun ','Sin ','Wei ','Zhu ','','Xuan ','Nu ','Payk ',
        'Ko ','Ni ','Ni ','Xie ','Pan ','Xu ','Lyeng ','Zhou ','Sin ','Qu ','Sa ','Phayng ','Sa ','Ka ','Pi ','Yi ',
        'Sa ','I ','Ceng ','Cen ','Han ','Mai ','Tan ','Ce ','Pho ','Kwu ','Phi ','So ','Ci ','Wi ','Ce ','Cwu ',
        'Cwa ','Wu ','Ang ','Pwun ','Cem ','Ha ','Phil ','Tha ','Sa ','Ye ','Il ','Pwul ','Cak ','Kwu ','Nyeng ','Tong ',
        'Ni ','Xuan ','Qu ','Yong ','Wa ','Qian ','','Ka ','','Phay ','Hoy ','He ','Lao ','Xiang ','Ge ','Yang ',
        'Peyk ','Fa ','Ming ','Ka ','I ','Pyeng ','Kil ','Hang ','Kwal ','Kwey ','Cen ','Co ','Kyo ','Cha ','Il ','Sa ',
        'Hyeng ','Sin ','Thak ','Kan ','Cil ','Hay ','Lay ','I ','Chi ','Kwa ','Kwang ','Lyey ','Yin ','Si ','Mi ','Cwu ',
        'Hyek ','Yu ','An ','Lu ','Mo ','Er ','Lyun ','Tong ','Cha ','Chik ','Swun ','Kong ','Cwu ','Uy ','Ye ','Jian ',
        'Hyep ','Ka ','Zai ','Lye ','Ko ','Jiao ','Zhen ','Ce ','Qiao ','Kuai ','Chai ','Ning ','Nong ','Jin ','Mo ','Hwu ',
        'Jiong ','Cheng ','Cin ','Cwa ','Chou ','Chim ','Lye ','Kwuk ','Twu ','Ceng ','Shen ','Thal ','Bo ','Nan ','Hao ','Phyen ',
        'Tui ','Yu ','Kyey ','Chok ','A ','Kwu ','Xu ','Kwang ','Ku ','O ','Cwun ','Up ','Po ','Lyang ','Co ','So ',
        'Li ','Yong ','Hun ','Kyeng ','Hyen ','San ','Pai ','Sok ','Pwu ','Huy ','Li ','Myen ','Ping ','Po ','Yu ','Sa ',
        'Hyep ','Sin ','Xiu ','O ','Cey ','Ke ','Chou ','','Yan ','Lia ','Li ','Lai ','Si ','Jian ','Swu ','Pwu ',
        'Hwa ','Kwu ','Hyo ','Pay ','Chen ','Phyo ','Swuk ','Pi ','Pong ','A ','Em ','Pi ','Yu ','Xin ','Pi ','Jian ',
        ],
    'x50':[
        'Chang ','Chi ','Pyeng ','Kwu ','Hyo ','Swi ','Lyang ','Wan ','Lai ','Chang ','Zong ','Kay ','Kwan ','Pay ','Cen ','Swuk ',
        'Swuk ','Mwun ','To ','Tam ','Kwul ','Swu ','Hayng ','Pwung ','Tang ','Hwu ','Uy ','Ki ','Chek ','Kan ','Kyeng ','Cha ',
        'Hyu ','Chang ','Chep ','Pang ','Chi ','Kong ','Kwen ','Cong ','Ke ','Chen ','Yey ','Lyun ','Thak ','Wi ','La ','Song ',
        'Lung ','Hon ','Tong ','Sa ','Pwun ','Wu ','Kwu ','Nai ','Cai ','Kem ','Zhai ','Ya ','Chi ','Sha ','Qing ','',
        'Ying ','Ching ','Jian ','En ','Nan ','Tong ','Chwun ','Ka ','Key ','Wi ','Yu ','Bing ','Ya ','Ti ','Oy ','Phyen ',
        'An ','Feng ','Thang ','Ak ','E ','Hay ','Cha ','Sheng ','Kan ','Di ','Cwu ','Sap ','Ceng ','Pay ','Yep ','Hwang ',
        'Yo ','Zhan ','Cho ','Yan ','You ','Ken ','Xu ','Zha ','Chi ','Pwu ','Phip ','Chi ','Chong ','Myen ','Ji ','Uy ',
        'Sel ','Xun ','Si ','Duan ','Chuk ','Ceng ','Wu ','Thwu ','Thwu ','Pi ','Za ','Lu ','Jie ','Wi ','Fen ','Chang ',
        'Koy ','Sou ','Zhi ','So ','Xia ','Pwu ','Yuan ','Rong ','Li ','Ru ','Yun ','Kang ','Ma ','Pang ','Cen ','Tang ',
        'Hao ','Kel ','Hyey ','Sen ','Kyem ','Kak ','Chang ','Chu ','San ','Pi ','Hyo ','Yong ','Yo ','Thap ','Sa ','Yang ',
        'Fa ','Bing ','Ka ','Dai ','Zai ','Tang ','Cot ','Bin ','Chu ','Nuo ','Can ','Lei ','Choy ','Yong ','Co ','Chong ',
        'Pwung ','Song ','O ','Cen ','Kwu ','Chay ','Cou ','Sang ','Qiang ','Jing ','Cey ','Sa ','Han ','Cang ','Kyeng ','En ',
        'Di ','Sel ','Lwu ','Bei ','Phyo ','Kun ','Lyen ','Lyuk ','Man ','Chem ','Sen ','Tham ','Ying ','Tong ','Cwun ','Sang ',
        'Shan ','Kyo ','Kwun ','Tui ','Cwun ','Pok ','Huy ','Lao ','Chang ','Guang ','Lyo ','Ki ','Deng ','Can ','Wi ','Ki ',
        'Fan ','Hui ','Chen ','Cham ','Than ','Yo ','Chwu ','Sung ','Pwun ','Han ','Kyel ','E ','Cho ','Cham ','Tong ','Lin ',
        'Pwuk ','Gu ','','Su ','Xian ','Kang ','Min ','Yep ','Kum ','Ka ','Qiao ','Pyek ','Feng ','Chwu ','Ay ','Sa ',
        ],
    'x51':[
        'Uy ','Cwun ','Nong ','Chen ','Ek ','Dang ','Kyeng ','Hyen ','Koy ','Kem ','Chu ','Tam ','Kyo ','Sha ','Zai ','',
        'Pin ','Ap ','Yu ','Tay ','Cwu ','Cey ','Lan ','Uy ','Cin ','Qian ','Meng ','Mwu ','Nyeng ','Qiong ','Ni ','Sang ',
        'Lyep ','Loy ','Lye ','Kuang ','Pho ','Yuk ','Phyo ','Chan ','Cil ','Sa ','Wu ','Ho ','Chen ','Chun ','Li ','Teng ',
        'Wei ','Long ','Ce ','Cham ','Sang ','Swuk ','Hyey ','Lye ','La ','Chan ','Na ','Tang ','Em ','Lay ','Nang ','In ',
        'Ol ','Yun ','Cam ','Wen ','Hyeng ','Chwung ','Co ','Hyung ','Sen ','Kwang ','Thay ','Kuk ','Thay ','Myen ','Tho ','Chang ',
        'A ','Thay ','A ','Chim ','Tho ','Si ','Yen ','Yen ','Shi ','Sip ','Tang ','Chen ','Twu ','Fen ','Mao ','Sin ',
        'Dou ','Payk ','Kung ','Li ','Huang ','Ip ','Mang ','Nay ','Cen ','Lyang ','Yu ','Phal ','Kong ','Lyuk ','Hyey ','',
        'Lan ','Kong ','Tian ','Guan ','Xing ','Pyeng ','Ki ','Kwu ','Cen ','Ca ','Ppwun ','Yang ','Kyem ','Shou ','Ji ','Yi ',
        'Ki ','Chan ','Kyeng ','Mo ','Yem ','Nay ','Wen ','Mao ','Gang ','Yem ','Chayk ','Jiong ','Chayk ','Cay ','Gua ','Kyeng ',
        'Mo ','Cwu ','Mo ','Kwu ','Hwu ','Myen ','Myek ','Yong ','Yu ','Sa ','Kan ','Jun ','Nong ','Uy ','Mi ','Sek ',
        'Kwan ','Mong ','Chong ','Chwi ','Wen ','Myeng ','Kou ','Lam ','Pwu ','Sa ','Myek ','Ping ','Tong ','Tai ','Gang ','Feng ',
        'Ping ','Ho ','Chwung ','Kyel ','Ho ','Hwang ','Ya ','Layng ','Pan ','Pwul ','Min ','Dong ','Xian ','Lyel ','Xia ','Jian ',
        'Jing ','Swu ','Mei ','Tu ','Che ','Ko ','Cwun ','Song ','Ceng ','Lyang ','Cheng ','Co ','Lung ','Tong ','Gan ','Kam ',
        'Yin ','Cwu ','Uy ','Yul ','Chang ','Ming ','Cwun ','Choy ','Si ','Duo ','Kum ','Lum ','Lum ','Ung ','Huy ','Du ',
        'Kwey ','Pem ','Pem ','Pem ','Feng ','Ke ','Che ','Tako ','Phwung ','Mok ','Ci ','Fu ','Feng ','Ping ','Phwung ','Kai ',
        'Hwang ','Kay ','Gan ','Tung ','Ping ','Kam ','Hyung ','Koy ','Chel ','Yo ','Chwul ','Ji ','Dang ','Ham ','Ham ','Zao ',
        ],
    'x52':[
        'To ','Co ','To ','In ','In ','Chang ','Pwun ','Cel ','Yey ','Ji ','Kan ','Chen ','Chon ','Chu ','Mwun ','Ki ',
        'Dan ','Hyeng ','Hwa ','Wan ','Kyel ','Li ','Wel ','Lyel ','Lyu ','Ze ','Gang ','Chuang ','Pwul ','Cho ','Qu ','Ju ',
        'San ','Min ','Ling ','Zhong ','Phan ','Pyel ','Kep ','Kep ','Pho ','Li ','San ','Pyel ','Chan ','Jing ','Kwal ','Gen ',
        'To ','Chang ','Kyu ','Ko ','Tha ','I ','Cey ','Sway ','Kwen ','Chal ','Ca ','Kak ','Jie ','Gui ','Ci ','Gui ',
        'Kai ','Duo ','Ji ','Chey ','Kyeng ','Lou ','Gen ','Chik ','Yuan ','Cwa ','Sak ','Kuk ','Lal ','Cen ','Chal ','Chang ',
        'Gua ','Jian ','Chak ','Li ','Chek ','Pi ','Pwu ','Can ','Qi ','Chang ','Sa ','Kang ','Wan ','Pak ','Ki ','Chel ',
        'Kyeng ','Sem ','Zhuo ','Kem ','Ji ','Pak ','Em ','Ju ','Koyk ','Ing ','Cen ','Thak ','Tan ','Ok ','Kwa ','Pwu ',
        'Sheng ','Jian ','Hal ','Cha ','Kay ','Chang ','Juan ','San ','Tan ','Lyuk ','Li ','Fou ','Shan ','Phyo ','Kou ','Cho ',
        'Kwal ','Qiao ','Kwey ','Hoyk ','Cha ','Zhuo ','Lian ','Kuk ','Pyek ','Lyu ','Hoy ','Co ','Kwi ','Kem ','Kem ','Tang ',
        'Hwak ','Cey ','Kem ','Uy ','Kem ','Zhi ','Cham ','Chan ','Ma ','Li ','Chok ','Lyek ','Ya ','Quan ','Ban ','Kong ',
        'Ka ','Wu ','Mai ','Lyel ','Kun ','Keng ','Hyep ','Zhi ','Dong ','Co ','No ','Kep ','Kwu ','Cho ','Il ','Zhu ',
        'Miao ','Lye ','Jing ','Lao ','Lo ','Kwen ','Kwu ','Yang ','Wa ','Hyo ','Mou ','Kwang ','Hal ','Lie ','Hayk ','Shi ',
        'Kuk ','Kyeng ','Hao ','Pal ','Min ','Chik ','Lang ','Yong ','Yong ','Myen ','Ke ','Xun ','Kwen ','Kyeng ','Lu ','Pou ',
        'Meng ','Lay ','Luk ','Kai ','Min ','Tong ','Wuk ','Wuk ','Kam ','Mwu ','Yi ','Hwun ','Weng ','Sung ','Lo ','Mo ',
        'Lyuk ','Phyo ','Sey ','Cek ','Kun ','Qiang ','Cho ','Kwen ','Yang ','Yey ','Jue ','Fan ','Juan ','Tong ','Ke ','Tan ',
        'Hyep ','May ','Hwun ','Hwun ','Lye ','Lye ','Chel ','Yang ','Kwen ','Pho ','Cak ','Kyun ','Kwu ','Mwun ','Kwu ','Mwul ',
        ],
    'x53':[
        'Kyun ','Mwun ','Nay ','Kay ','Kay ','Pho ','Chong ','','Hung ','Phyeng ','Kwuk ','To ','Hap ','Pho ','Ap ','Pho ',
        'Pok ','Kwung ','Tap ','Kwu ','Qiong ','Pi ','Hwa ','Pwuk ','Noy ','Si ','Pang ','Kwu ','I ','Cap ','Cang ','Kang ',
        'Cang ','Kwang ','Hu ','Kap ','Qu ','Pyen ','Gui ','Hyep ','Zang ','Kuang ','Pi ','Hu ','Yu ','Kwey ','Gui ','Hoy ',
        'Tan ','Kwey ','Lyem ','Lyem ','San ','Tok ','Kwu ','Qu ','Hyey ','Phil ','Kwu ','Yey ','Ap ','En ','Phyen ','Nik ',
        'Kwu ','Sip ','Sin ','Chen ','Ip ','Sap ','Col ','Sung ','O ','Hwey ','Pan ','Sey ','Sip ','Man ','Hua ','Xie ',
        'Man ','Pi ','Col ','Thak ','Hyep ','Tan ','Mai ','Nam ','Tan ','Cip ','Pak ','Shuai ','Pok ','Kwan ','Pyen ','Key ',
        'Cem ','Cap ','Lu ','Yu ','Lu ','Xi ','Kway ','Wo ','Sel ','Cel ','Jie ','Wei ','Ang ','Kong ','Chi ','Myo ',
        'In ','Wi ','So ','Cuk ','Kak ','Lan ','Si ','Kwen ','Sa ','Hyul ','Kun ','Kak ','Ol ','Cuk ','Ak ','Kyeng ',
        'Sul ','','Em ','Cem ','Ayk ','Ting ','Li ','Chayk ','Han ','Lye ','A ','Ap ','Yan ','She ','Ci ','Zha ',
        'Pang ','','He ','Ay ','Cil ','Ce ','Pang ','Ti ','Li ','She ','Hwu ','Ting ','Zui ','Co ','Pi ','Wen ',
        'Chuk ','Yuan ','Xiang ','Yan ','Lyek ','Kwel ','Ha ','Dian ','Cwu ','Kwu ','Kun ','Ao ','Kwey ','Yem ','Si ','Li ',
        'Chang ','Em ','Lye ','Em ','Yan ','Wen ','Sa ','Koyng ','Lin ','Kwu ','Ke ','Ke ','Uk ','Lwi ','Du ','Xian ',
        'Zhuan ','Sam ','Sam ','Cham ','Cham ','Cham ','Ai ','Dai ','Wu ','Cha ','Kup ','Wu ','Ssang ','Pan ','Shou ','Kway ',
        'Ba ','Fa ','Yak ','Sa ','Swuk ','Chel ','Chwi ','Swu ','Pyen ','Se ','Ka ','Pan ','Sou ','Gao ','Wi ','Swu ',
        'Die ','Yey ','Chong ','Kwu ','Ko ','Kwu ','Lyeng ','Gua ','To ','Ko ','Ci ','Kyu ','So ','Phal ','Ceng ','Ka ',
        'Thay ','Cil ','Sa ','Wu ','Kwu ','Pha ','Hyep ','Ho ','Sa ','Tan ','Ip ','Le ','Diao ','Ji ','Duk ','Hong ',
        ],
    'x54':[
        'Mie ','Yu ','Mang ','Hul ','Kak ','Hyen ','Yo ','Zi ','Hap ','Kil ','Cek ','Chon ','Tong ','Myeng ','Hwu ','Li ',
        'Tho ','Hyang ','Tha ','Xia ','Ye ','Lye ','A ','Ma ','Wu ','Xue ','Uy ','Kwun ','Chou ','Lin ','Than ','Um ',
        'Phyey ','Phil ','Sim ','Qin ','Jie ','Bu ','Pwu ','Pha ','Twun ','Pwun ','Wa ','Ham ','Un ','Hang ','Cen ','Kyey ',
        'Hong ','Ci ','Sin ','O ','O ','Myo ','Nwul ','Hyel ','Hup ','Chwi ','Twu ','Mwun ','Hwu ','Hwu ','O ','Ko ',
        'Ha ','Jun ','Lye ','Ay ','Ge ','May ','May ','Qi ','Ceng ','O ','Ko ','Fu ','Kyu ','Hong ','Chek ','Sung ',
        'Nwul ','Than ','Fu ','Yi ','Dai ','Ou ','Li ','Bai ','Yuan ','Kuai ','','Qiang ','Wu ','Ayk ','Shi ','Hyen ',
        'Pen ','Wen ','Ni ','Bou ','Lyeng ','Ran ','Yu ','Cey ','Cwu ','Shi ','Cwu ','Chep ','Hi ','Yey ','Ki ','Ping ',
        'Ca ','Ko ','Zi ','Mi ','Kwu ','Ka ','No ','Hap ','Pi ','Il ','Hyo ','Sin ','Ho ','Myeng ','Tal ','Ke ',
        'Ce ','Kan ','Cap ','Tuo ','Tol ','Pou ','Pho ','Phil ','Pwul ','Ang ','Hwa ','Sa ','Hwa ','Hay ','Kwu ','Yeng ',
        'Pwu ','Que ','Cwu ','Wa ','Ka ','Ko ','Ka ','Zuo ','Bu ','Long ','Dong ','Ning ','Tha ','Si ','Xian ','Huo ',
        'Cip ','I ','Ak ','Guang ','Tha ','Huy ','I ','Lyel ','Ca ','Mi ','Mi ','Ci ','Kyo ','Kil ','Cwu ','Kak ',
        'Shuai ','Chal ','So ','Hay ','Hui ','Kua ','Si ','To ','Ham ','E ','Hwen ','Hyu ','Kway ','In ','Lao ','I ',
        'Ay ','Phwum ','Sin ','Tong ','Hong ','Hyung ','Chi ','Wa ','Hap ','Cay ','Yu ','Di ','Pai ','Sang ','Ay ','Hen ',
        'Kuang ','Ya ','Da ','Xiao ','Bi ','Yue ','','Hua ','Sasou ','Kuai ','Duo ','','Ji ','Nong ','Mou ','Yo ',
        'Hao ','Wen ','Long ','Pou ','Pang ','Ka ','A ','Chi ','Cho ','Li ','Na ','Cok ','Ha ','Kok ','Hyo ','Hyen ',
        'Lo ','Pal ','Chel ','Chal ','Liang ','Ba ','Ma ','Lyel ','Sui ','Pwu ','Pho ','Han ','Hyeng ','Kyeng ','Shuo ','Ka ',
        ],
    'x55':[
        'Yu ','En ','Gu ','Gu ','Phay ','Ham ','Sa ','Cin ','Up ','Ay ','Kyep ','Tu ','Yen ','Wan ','Li ','Huy ',
        'Tang ','Zuo ','Qiu ','Che ','O ','Co ','A ','Dou ','Qi ','Di ','Chim ','Ma ','Mal ','Hong ','Dou ','Kes ',
        'Lao ','Liang ','Suo ','Zao ','Hwan ','Laang ','Sha ','Ji ','Zuo ','Wo ','Pong ','Kum ','Ho ','Ki ','Swu ','Yu ',
        'Shua ','Chang ','A ','Lye ','Kang ','An ','Cha ','Yuk ','Cem ','E ','Tian ','Lai ','Sap ','Xi ','Tha ','Hol ',
        'Ay ','Co ','Nyo ','Sap ','Thak ','Thak ','Sang ','Cek ','Heng ','Lam ','A ','Kyo ','Xiang ','Thon ','O ','Mwun ',
        'Chway ','Cap ','Hu ','Kyey ','Qi ','To ','Tam ','Tam ','Ye ','Ca ','Pi ','Cui ','Chel ','Wa ','A ','Kyey ',
        'Zhe ','Pay ','Liang ','Ham ','Pi ','Sha ','La ','Ze ','Qing ','Gua ','Pa ','Zhe ','Se ','Zhuan ','Nie ','Guo ',
        'Luo ','Yan ','Di ','Quan ','Tan ','Bo ','Ding ','Lang ','Xiao ','Geoi ','Tang ','Si ','Cey ','Am ','Chwu ','Tam ',
        'Kayk ','Ong ','Wei ','Nam ','Sen ','Yuk ','Chel ','Lal ','Kay ','Hwu ','Ham ','Chep ','Cwu ','Cay ','Wai ','Ya ',
        'Yu ','Um ','Cam ','Yo ','Ak ','Mian ','Hu ','Wun ','Chen ','Hwey ','Hwan ','Hwan ','Huy ','Kal ','Cul ','Wi ',
        'Cong ','Wei ','Sha ','Hwu ','Hwang ','Du ','Yep ','Hwen ','Lyang ','Yu ','Sang ','Kkik ','Kyo ','An ','Tan ','Pen ',
        'Sik ','Li ','Yak ','Sa ','Wei ','Miao ','Yeng ','Pen ','Phos ','Kui ','Xi ','Yu ','Jie ','Lou ','Ku ','So ',
        'Hak ','Cey ','Yo ','Hyo ','Sa ','Hwu ','Chang ','Sayk ','Ong ','So ','Hong ','Hyep ','I ','Suo ','Ma ','Cha ',
        'Hal ','Hap ','Thap ','Sang ','Cin ','Yok ','Sou ','Wa ','Ji ','Pang ','O ','Kyem ','Ki ','Kyek ','Ca ','Cha ',
        'La ','Ong ','Ol ','Sa ','Chi ','Hao ','Suo ','Lyun ','Hai ','Sway ','Qin ','Nie ','He ','Cis ','Sai ','Ng ',
        'Ge ','Na ','Dia ','Ai ','','Tong ','Phil ','O ','O ','Lyen ','Choy ','Cha ','Mak ','Swu ','Cwu ','Tham ',
        ],
    'x56':[
        'Di ','Chuk ','Kyo ','Chong ','Kyo ','Kay ','Than ','Sam ','Co ','Ka ','Ay ','Xiao ','Phyo ','Lwu ','Al ','Ha ',
        'Kyo ','Ho ','Hyey ','Koyk ','Kwu ','En ','Chayk ','Sang ','He ','Po ','De ','Ma ','Ma ','Hu ','Luk ','To ',
        'Al ','Tang ','Ye ','Beng ','Ying ','Saai ','Jiao ','Mi ','So ','Hwa ','Mai ','Yen ','Choy ','Peng ','Cho ','So ',
        'Ki ','Chok ','Co ','Koy ','Chwi ','Hyo ','Si ','Ho ','Mwu ','Lyo ','Kyo ','Huy ','Hyu ','Than ','Tam ','Mwuk ',
        'Son ','O ','Cwun ','Pen ','Chi ','Wi ','Cham ','Tam ','Chwuk ','Tam ','Yul ','Thon ','Cayng ','Cho ','Yel ','Hup ',
        'Ki ','Hao ','Lian ','He ','Deng ','Wi ','Yin ','Pu ','Jue ','Qin ','Xun ','Nie ','Lu ','Si ','Em ','Ying ',
        'Tal ','Dan ','Wuk ','Cwu ','Kum ','Nong ','El ','Hway ','Ki ','Ak ','Co ','Huy ','Se ','Kyo ','Yen ','Ay ',
        'Ong ','Kyak ','Khway ','Wu ','Pwun ','Dao ','Kal ','Xin ','Thon ','Dang ','Sin ','Sai ','Pi ','Pi ','Yin ','Zui ',
        'Nyeng ','Di ','Lam ','Thap ','Hoyk ','Yu ','Hyo ','Ha ','Ya ','Duo ','Pi ','Chou ','Cey ','Cin ','Ho ','Chey ',
        'Chang ','','','Ca ','Chey ','Lo ','Hui ','Pak ','Wu ','Kyo ','Un ','Hak ','Mwuk ','Huang ','Zhe ','Li ',
        'Lyu ','Haai ','Nang ','Xiao ','Mo ','Yen ','Lyek ','Lo ','Long ','Fu ','Tam ','Chin ','Pin ','Pi ','Hyang ','Huo ',
        'Mo ','Huy ','Tha ','Ko ','Em ','Chan ','Ayng ','Yang ','Dian ','La ','Ta ','Hyo ','Cak ','Chuo ','Hwan ','Huo ',
        'Cen ','Sep ','Hyo ','Cap ','Li ','Chen ','Chay ','Li ','Yey ','La ','Nang ','Chal ','Su ','Huy ','So ','Kan ',
        'Cal ','Chok ','Lan ','Sel ','Nang ','Trom ','Lo ','Kwuk ','Hui ','In ','Swu ','Sa ','Nin ','Ken ','Hoy ','Sin ',
        'In ','Nan ','Tuan ','Tan ','Ton ','Kang ','Yen ','Kyeng ','Pian ','Wun ','Chang ','Hol ','Hoy ','Wan ','Wa ','Guo ',
        'Kon ','Chong ','Wi ','To ','Wei ','Lun ','Kwuk ','Kyun ','Ri ','Lyeng ','Ko ','Guo ','Tai ','Kwuk ','Tu ','Yu ',
        ],
    'x57':[
        'Kwuk ','Un ','Hon ','Pho ','E ','Ham ','Yuan ','Lyun ','Kwen ','E ','Cheng ','Kwuk ','Chen ','Wi ','Wen ','Kwen ',
        'Ku ','Fu ','Wen ','Wen ','E ','Toshokan ','To ','To ','Tan ','Lue ','Hui ','Yek ','Wen ','Lan ','Luan ','Tho ',
        'Ya ','Tu ','Ting ','Sheng ','Pu ','Lok ','Iri ','Ap ','Cay ','Wei ','Ge ','Yu ','O ','Kyu ','Pi ','Yi ',
        'Ci ','Qian ','Qian ','Zhen ','Zhuo ','Dang ','Qia ','Akutsu ','Yama ','Kuang ','Chang ','Ki ','Nie ','Mo ','Kup ','Jia ',
        'Ci ','Zhi ','Phan ','Xun ','Tou ','Qin ','Fen ','Kyun ','Keng ','Tun ','Pang ','Fen ','Pwun ','Tam ','Kam ','Pay ',
        'Cwa ','Kayng ','Bi ','Xing ','Di ','Jing ','Ji ','Kuai ','Di ','Jing ','Jian ','Tan ','Li ','Ba ','Wu ','Fen ',
        'Zhui ','Pha ','Pan ','Tang ','Kon ','Qu ','Than ','Chek ','I ','Kam ','Phyeng ','Cem ','Gua ','Ni ','Tay ','Pay ',
        'Kyeng ','Ang ','Fo ','Yo ','Liu ','Kwu ','Mu ','Ka ','Kwu ','Xue ','Ba ','Ci ','Thak ','Ling ','Zhu ','Fu ',
        'Hu ','Zhi ','Swu ','La ','Long ','Long ','Lu ','Ao ','Tay ','Pao ','','Hyeng ','Tong ','Ji ','Ke ','Lu ',
        'Ci ','Chi ','Lei ','Hay ','Yin ','Hwu ','Dui ','Zhao ','Fu ','Guang ','Yao ','Duo ','Duo ','Gui ','Tha ','Yang ',
        'Un ','Fa ','Kwu ','Wen ','Cil ','Xie ','Ken ','Jiong ','Shou ','Seng ','Ha ','Dian ','Hong ','Wu ','Kua ','',
        'Tao ','Dang ','Kai ','Gake ','Nao ','An ','Xing ','Xian ','Wan ','Bang ','Pei ','Ba ','Yi ','Un ','Han ','Xu ',
        'Chui ','Cen ','Geng ','Ay ','Peng ','Fang ','Kak ','Yong ','Cwun ','Hyep ','Di ','May ','Lang ','Xuan ','Seng ','Yen ',
        'Jin ','Chel ','Lal ','Lie ','Pu ','Cheng ','Gomi ','Bu ','Shi ','Xun ','Guo ','Jiong ','Ya ','Nian ','Di ','Yek ',
        'Pwu ','Ya ','Juan ','Sui ','Pi ','Cheng ','Wan ','Ju ','Lun ','Zheng ','Kong ','Chong ','Dong ','Thay ','Tan ','An ',
        'Chay ','Shu ','Beng ','Kam ','Sik ','Duo ','Yi ','Cip ','Yi ','Pay ','Ki ','Cwun ','Ki ','So ','Ju ','Ni ',
        ],
    'x58':[
        'Kwul ','Ke ','Tang ','Kon ','Ni ','Kyen ','Thoy ','Kun ','Kang ','Yuk ','Ak ','Pwul ','Gu ','Tu ','Leng ','',
        'Ya ','Qian ','','An ','','Tha ','Nao ','Tol ','Cheng ','In ','Hun ','Bi ','Lian ','Kwa ','Chep ','Zhuan ',
        'Hwu ','Po ','Bao ','Yu ','Cey ','Mao ','Kyey ','Yen ','E ','Geng ','Kam ','Zong ','Yu ','Huang ','E ','Yo ',
        'En ','Po ','Ji ','Mei ','Cang ','To ','Tuo ','Yin ','Feng ','Zhong ','Kyey ','Zhen ','Feng ','Gang ','Chuan ','Jian ',
        'Pyeng ','Rui ','Xiang ','Huang ','Leng ','Duan ','','Xuan ','Ji ','Chek ','Koy ','Yeng ','Thap ','Sup ','Yong ','Kay ',
        'So ','So ','Si ','Mi ','Thap ','Weng ','Cheng ','To ','Tang ','Ko ','Chong ','Li ','Pong ','Bang ','Say ','Zang ',
        'Dui ','Cen ','O ','Cheng ','Hwun ','Ge ','Zhen ','Ai ','Gong ','Yem ','Kan ','Cen ','Yuan ','Wen ','Xie ','Liu ',
        'Ama ','Lang ','Chang ','Peng ','Beng ','Cin ','Cu ','Lu ','Ou ','Cham ','Mei ','Mo ','Cen ','Sang ','Swuk ','Lou ',
        'Ci ','Man ','Biao ','Kyeng ','Qi ','Se ','Di ','Zhang ','Kan ','Yong ','Cem ','Chen ','Zhi ','Ki ','Guo ','Qiang ',
        'Kun ','Di ','Shang ','Myo ','Cui ','Yan ','Ta ','Cung ','Qi ','Qiang ','Liang ','','Chwu ','Yo ','Cung ','He ',
        'Shan ','Sen ','Ba ','Pok ','Kuai ','Dong ','Fan ','Que ','Mwuk ','Ton ','Dun ','Cwun ','Di ','Sheng ','Tha ','Duo ',
        'Tam ','Tung ','Wu ','Pwun ','Huang ','Tan ','Da ','Ye ','Sho ','Mama ','O ','Cang ','Ji ','Qiao ','Kan ','Yi ',
        'Pi ','Pyek ','Dian ','Kang ','Ye ','Ong ','Bo ','Tan ','Lan ','Ju ','Huai ','Dang ','Yang ','Qian ','Hwun ','Lan ',
        'Xi ','Hak ','Ai ','Ap ','To ','Ho ','Ruan ','Mama ','Lwu ','Kwang ','Lo ','Yan ','Tam ','Yu ','Koy ','Long ',
        'Long ','Rui ','Li ','Lin ','Yang ','Ten ','Xun ','Yan ','Lei ','Pha ','','Sa ','Im ','','Cang ','Cang ',
        'Seng ','Il ','May ','Ke ','Zhu ','Zhuang ','Hu ','Hu ','Kun ','Il ','Ho ','Se ','Ho ','Swu ','Mang ','Zun ',
        ],
    'x59':[
        'Shou ','Yi ','Zhi ','Gu ','Chu ','Jiang ','Pong ','Bei ','Cay ','Pyen ','Sui ','Qun ','Ling ','Fu ','Zuo ','Ha ',
        'Hyeng ','','Nao ','Xia ','Ki ','Sek ','Oy ','Yuan ','Mao ','Swuk ','Ta ','Duo ','Ya ','Qing ','Uys ','Gou ',
        'Gou ','Qi ','Mong ','Meng ','In ','Kwa ','Chen ','Tay ','Ze ','Chen ','Thay ','Pwu ','Khway ','Yo ','Ang ','Hang ',
        'Gao ','Sil ','Ben ','Tai ','Tou ','Yan ','Bi ','I ','Kwa ','Jia ','Duo ','Kwu ','Kuang ','Yun ','Hyep ','Pa ',
        'En ','Lian ','Huan ','Di ','Em ','Pao ','Quan ','Ki ','Nay ','Pong ','Xie ','Fen ','Cem ','','Kyu ','Cwu ',
        'Hwan ','Kyey ','Kai ','Cha ','Pwun ','Hyek ','Jiang ','Thwu ','Cang ','Ben ','Hay ','Xiang ','Fei ','Diao ','Xun ','Keng ',
        'Cen ','Ao ','Sa ','Weng ','Pan ','O ','Wu ','O ','Cang ','Lyem ','Thal ','Yun ','Cang ','Sek ','Pwun ','Huo ',
        'Bi ','Lian ','Duo ','Nye ','No ','Ding ','Nay ','Qian ','Kan ','Ta ','Jiu ','Nan ','Cha ','Ho ','Xian ','Fan ',
        'Ji ','Cak ','Ye ','Pi ','Mang ','Hong ','Zhuang ','Fu ','Ma ','Dan ','Im ','Fu ','Jing ','Yen ','Xie ','Wen ',
        'Zhong ','Pha ','Thwu ','Ki ','Keng ','Zhong ','Yo ','Kum ','Yun ','Myo ','Pei ','Shi ','Yue ','Cang ','Niu ','Yan ',
        'Na ','Xin ','Fen ','Pi ','Yu ','Tha ','Feng ','Wan ','Pang ','Wu ','Yu ','Gui ','Thwu ','Ba ','Ni ','Chwuk ',
        'Zhuo ','Zhao ','Tal ','Nai ','Yuan ','Tou ','Xuan ','Zhi ','E ','May ','Mo ','Che ','Bi ','Shen ','Chep ','E ',
        'He ','Xu ','Fa ','Ceng ','Min ','Ban ','Mo ','Fu ','Lyeng ','Ca ','Zi ','Si ','Ran ','San ','Yang ','Man ',
        'Ce ','Ko ','Sa ','Seng ','Wi ','Zi ','Ju ','San ','Pin ','Im ','Yo ','Tong ','Kang ','Cwu ','Kil ','Gai ',
        'Shang ','Kuo ','Yen ','Kyo ','Kwu ','Mo ','Kan ','Jian ','I ','Nian ','Cil ','Huy ','Huy ','Xian ','Hang ','Guang ',
        'Jun ','Kua ','Yan ','Ming ','Lie ','Pei ','Yan ','You ','Yen ','Cha ','Sin ','In ','Chi ','Gui ','Quan ','Ca ',
        ],
    'x5a':[
        'Song ','Wi ','Hong ','Way ','Lou ','Ya ','Rao ','Jiao ','Luan ','Ping ','Xian ','Shao ','Li ','Cheng ','Xiao ','Mang ',
        '','Sa ','Wu ','Mi ','Ke ','Lai ','Chuo ','Ding ','Nang ','Hyeng ','Nan ','O ','Na ','Pei ','Nei ','Yen ',
        'Sin ','Zhi ','Han ','Cey ','Zhuang ','A ','Pin ','Thay ','Han ','Man ','Wu ','Yan ','Wu ','Ay ','Yan ','O ',
        'Si ','Yu ','Wa ','','Xian ','Chwu ','Chwi ','Shui ','Qi ','Xian ','Zhui ','Dong ','Chang ','Lu ','Ai ','A ',
        'A ','Lwu ','Mian ','Cong ','Pou ','Ju ','Pha ','Cai ','Ding ','Wan ','Biao ','Xiao ','Swuk ','Qi ','Hui ','Fu ',
        'Wa ','Wo ','Tan ','Fei ','','Jie ','Tian ','Ni ','Quan ','Jing ','Hon ','Jing ','Qian ','Dian ','Xing ','Hu ',
        'Wa ','Lai ','Pi ','In ','Zhou ','Chuo ','Pwu ','Ceng ','Lun ','Yan ','Lam ','Kun ','Um ','Ya ','','Li ',
        'Dian ','Xian ','Hwa ','Hua ','Ying ','Chan ','Shen ','Ceng ','Dang ','Yao ','Wu ','Nan ','Ruo ','Jia ','Tou ','Se ',
        'Yu ','Wei ','Ti ','Rou ','Mi ','Dan ','Ruan ','Qin ','','Wu ','Qian ','Chun ','Mao ','Pwu ','Jie ','Duan ',
        'Xi ','Zhong ','May ','Hwang ','Mian ','Am ','Ying ','Xuan ','','Wei ','Mi ','Wen ','Zhen ','Qiu ','Ti ','Sel ',
        'Tuo ','Lian ','Mo ','Ran ','Si ','Pian ','Wei ','Way ','Jiu ','Hu ','O ','','Ho ','Xu ','Tou ','Gui ',
        'Zou ','Yao ','Pi ','Sik ','Yuan ','Ing ','Rong ','Ru ','Chi ','Liu ','Mi ','Pan ','On ','Ma ','Kwu ','Koy ',
        'Qin ','Ka ','Swu ','Zhen ','Wen ','Cha ','Yong ','Ming ','Ayng ','Cil ','Su ','Nyo ','Hyem ','Tao ','Pang ','Lang ',
        'Nao ','Bao ','Ai ','Pi ','Pin ','Yi ','Phyo ','Kwu ','Lei ','Sen ','Man ','Yey ','Zhang ','Kang ','Yong ','Ni ',
        'Li ','Cek ','Kyu ','En ','Jin ','Cen ','Hang ','Ce ','Han ','Nwun ','Lao ','Mo ','Zhe ','Ho ','Ho ','O ',
        'Nen ','Qiang ','Maa ','Pie ','Gu ','Wu ','Cho ','Tuo ','Zhan ','Mao ','Han ','Han ','Mo ','Lyo ','Lian ','Hua ',
        ],
    'x5b':[
        'Kyu ','Deng ','Zhi ','Xu ','','Hwa ','Xi ','Hui ','Yo ','Huy ','Yan ','Sen ','Kyo ','Mei ','Fan ','Fan ',
        'Xian ','Yi ','Wei ','Jiao ','Fu ','Shi ','Phyey ','Shan ','Sui ','Cang ','Lian ','Hyen ','','Niao ','Dong ','Yi ',
        'Can ','Ai ','Yang ','Neng ','Ma ','Co ','Chou ','Jin ','Ca ','Yu ','Pin ','','Xu ','Nay ','Yan ','Tai ',
        'Yeng ','Can ','Nyo ','','Yeng ','Mian ','Kaka ','Ma ','Shen ','Xing ','Ni ','Du ','Liu ','Yuan ','Lan ','Yen ',
        'Sang ','Ling ','Jiao ','Yang ','Lan ','Sem ','Ying ','Shuang ','Shuai ','Quan ','Mi ','Li ','Lyen ','Yan ','Zhu ','Lan ',
        'Ca ','Hyel ','Jue ','Jue ','Kong ','Ing ','Ca ','Ca ','Con ','Sun ','Pwu ','Phay ','Ca ','Hyo ','Xin ','Mayng ',
        'Si ','Thay ','Bao ','Kyey ','Ko ','No ','Hak ','','Zhuan ','Hay ','Luan ','Son ','Huai ','Mie ','Cong ','Qian ',
        'Swuk ','Can ','Ya ','Ca ','Ni ','Pwu ','Ca ','Li ','Hak ','Bo ','Yu ','Lai ','El ','El ','Ying ','San ',
        'Mian ','Ce ','Yong ','Ta ','Gui ','Tayk ','Qiong ','Wu ','Swu ','An ','Ka ','Song ','Wan ','Rou ','Yao ','Koyng ',
        'Yi ','Jing ','Zhun ','Pok ','Zhu ','Thang ','Hoyng ','Cong ','Kwan ','Cwu ','Ceng ','Wan ','Uy ','Po ','Shi ','Sil ',
        'Chong ','Shen ','Kayk ','Sen ','Sil ','Yu ','Hwan ','Yi ','Tiao ','Shi ','Xian ','Kwung ','Seng ','Qun ','Kwung ','Xiao ',
        'Cay ','Zha ','Bao ','Hay ','Yen ','So ','Ka ','Shen ','Sin ','Yong ','Huang ','Mil ','Kou ','Kuan ','Bin ','Swuk ',
        'Chay ','Zan ','Cek ','Wen ','Ki ','In ','Mil ','Kwu ','Qing ','Que ','Zhen ','Jian ','Pwu ','Ning ','Bing ','Huan ',
        'May ','Qin ','Han ','Wu ','Sik ','Nyeng ','Chim ','Nyeng ','Chi ','Yu ','Bao ','Kwan ','Nyeng ','Chim ','Mak ','Chal ',
        'Ju ','Kwa ','Chim ','Hu ','O ','Lyo ','Sil ','Nyeng ','Chay ','Sim ','Wei ','Sa ','Kwan ','Hyey ','Lyo ','Cwun ',
        'Hwan ','Yi ','Yi ','Po ','Qin ','Chong ','Po ','Feng ','Chon ','Tay ','Sa ','Xun ','Dao ','Lu ','Tay ','Swu ',
        ],
    'x5c':[
        'Po ','Pong ','Cen ','Fu ','Sa ','Kuk ','Cang ','Cang ','Cen ','Wi ','Con ','Sim ','Cwu ','Tay ','To ','So ',
        'Ji ','So ','Er ','I ','I ','Ga ','Chem ','Shu ','Chen ','Sang ','Sang ','','Ga ','Chang ','Liao ','Sen ',
        'Sen ','','Wang ','Wang ','Wu ','Liao ','Liao ','Yao ','Pang ','Wang ','Wang ','Wang ','Ga ','Yo ','Duo ','Kui ',
        'Zhong ','Chwi ','Gan ','Gu ','Gan ','Tui ','Gan ','Gan ','Si ','Yun ','Chek ','Ko ','Ni ','Cin ','Mi ','Nyo ',
        'Kwuk ','Pi ','Ceng ','Xi ','Bi ','Ke ','Kyey ','Cen ','Kwul ','Ti ','Jie ','Ok ','Diao ','Si ','Si ','Pyeng ',
        'Kuk ','Sel ','Chen ','Xi ','Ni ','Cen ','Xi ','','Man ','E ','Lou ','Pyeng ','Ti ','Fei ','Chok ','Xie ',
        'To ','Lu ','Lwu ','Xi ','Chung ','Li ','Ju ','Xie ','Kwu ','Jue ','Liao ','Jue ','Sok ','Xi ','Che ','Twun ',
        'Ni ','San ','','Sen ','Li ','Xue ','Nata ','','Long ','Hul ','Ki ','Ren ','Wu ','Han ','Shen ','Yu ',
        'Chwul ','Sui ','Qi ','','Yue ','Ban ','Yao ','Ang ','Ha ','Wu ','Cel ','E ','Kup ','Qian ','Fen ','Wan ',
        'Ki ','Cam ','Kyem ','Qi ','Cha ','Jie ','Qu ','Gang ','Xian ','Ao ','Lan ','Dao ','Ba ','Cak ','Zuo ','Yang ',
        'Ju ','Kang ','Ke ','Kwu ','Xue ','Pha ','Lip ','Cho ','Ce ','Am ','Pwul ','Swu ','Kap ','Lyeng ','Tuo ','Pei ',
        'You ','Tay ','Kuang ','Ak ','Qu ','Ho ','Po ','Min ','An ','Tiao ','Lyeng ','Chi ','Yuri ','Dong ','Cem ','Kui ',
        'Swu ','Mao ','Tong ','Xue ','Yi ','Kura ','He ','Ke ','Luo ','E ','Fu ','Swun ','Die ','Lu ','An ','Er ',
        'Gai ','Quan ','Tong ','Yi ','Mu ','Shi ','An ','Wei ','Hu ','Chi ','Mi ','Li ','Ji ','Tong ','Wei ','You ',
        'Sang ','Xia ','Li ','Yo ','Jiao ','Zheng ','Luan ','Jiao ','A ','A ','Yu ','Ye ','Bu ','Cho ','Qun ','Pong ',
        'Pong ','No ','Li ','You ','Hyen ','Hong ','To ','Shen ','Cheng ','Tu ','Geng ','Cwun ','Hao ','Hyep ','Yin ','Yu ',
        ],
    'x5d':[
        'Lang ','Kan ','Lao ','Lai ','Hem ','Que ','Kong ','Swung ','Chong ','Ta ','','Hua ','Ju ','Lay ','Ki ','Min ',
        'Kon ','Kon ','Zu ','Gu ','Choy ','Ay ','Ay ','Kang ','Lun ','Lyun ','Leng ','Kwul ','Duo ','Zheng ','Guo ','Um ',
        'Dong ','Han ','Cayng ','Wei ','Hyo ','Pi ','Em ','Swung ','Jie ','Pwung ','Zu ','Jue ','Dong ','Zhan ','Gu ','Yin ',
        '','Ze ','Huang ','Yu ','Oy ','Yang ','Feng ','Qiu ','Dun ','Ti ','Yi ','Zhi ','Shi ','Cay ','Yao ','E ',
        'Zhu ','Kam ','Lyul ','Yan ','Mei ','Gan ','Ji ','Ji ','Huan ','Ting ','Sheng ','Mi ','Kam ','Wu ','Yu ','Zong ',
        'Lam ','Jue ','Am ','Am ','Oy ','Zong ','Cha ','Sui ','Rong ','Yamashina ','Kum ','Yu ','Ki ','Lou ','Tu ','Dui ',
        'Xi ','Weng ','Cang ','Dang ','Hong ','Jie ','Ai ','Liu ','Wu ','Swung ','Qiao ','Zi ','Oy ','Beng ','Dian ','Cha ',
        'Qian ','Yong ','Nie ','Cuo ','Ji ','','Tao ','Song ','Zong ','Jiang ','Liao ','','Chan ','Die ','Cen ','Ding ',
        'Tu ','Lwu ','Cang ','Zhan ','Cham ','Ao ','Cao ','Kwu ','Qiang ','Zui ','Zui ','To ','Dao ','Xi ','Yu ','Bo ',
        'Long ','Xiang ','Cung ','Bo ','Kum ','Cho ','Yan ','Lao ','Zhan ','Lin ','Liao ','Liao ','Jin ','Tung ','Duo ','Zun ',
        'Kyo ','Gui ','Yo ','Qiao ','Yao ','Jue ','Zhan ','Yek ','Xue ','Nao ','Ep ','Ep ','Yi ','E ','Hem ','Ji ',
        'Hay ','Ke ','Xi ','Di ','Ao ','Zui ','','Uy ','Yeng ','Dao ','Lyeng ','Za ','Se ','Ak ','Yin ','',
        'Jie ','Li ','Sui ','Long ','Long ','Dian ','Ying ','Xi ','Ju ','Cham ','Ying ','Kyu ','Yan ','Oy ','Nao ','Quan ',
        'Chao ','Chan ','Man ','Cen ','Cen ','','Am ','Yan ','Yan ','Nao ','Hen ','Chuan ','Gui ','Chen ','Cwu ','Huang ',
        'Jing ','Swun ','So ','Chao ','Lie ','Kong ','Cwa ','Kyo ','Ke ','Gong ','Kek ','Mwu ','Pwu ','Pwu ','Cha ','Qiu ',
        'Qiu ','Ki ','I ','Sa ','Pha ','Chi ','Zhao ','Hang ','Yi ','Kun ','Son ','Kwen ','Phas ','Son ','Ken ','Fu ',
        ],
    'x5e':[
        'Za ','Bi ','Si ','Pho ','Ding ','Shuai ','Pem ','Nie ','Shi ','Pwun ','Pa ','Zhi ','Huy ','Hu ','Dan ','Wei ',
        'Zhang ','Thang ','Dai ','Ma ','Pei ','Mal ','Chep ','Fu ','Lyem ','Cil ','Chwu ','Payk ','Zhi ','Cey ','Mo ','Yi ',
        'Yi ','Ping ','Qia ','Juan ','Ru ','Sol ','Tay ','Zheng ','Sey ','Qiao ','Zhen ','Sa ','Qun ','Sek ','Bang ','Tay ',
        'Kwi ','Chou ','Ping ','Cang ','Sha ','Wan ','Tay ','Yu ','Sang ','Sha ','Qi ','Ze ','Guo ','Mo ','Du ','Hwu ',
        'Ceng ','Xu ','Mi ','Wi ','Ak ','Phok ','Yi ','Pang ','Ping ','Tazuna ','Gong ','Pan ','Hwang ','Dao ','Myek ','Jia ',
        'Teng ','Hui ','Zhong ','Shan ','Man ','Mak ','Biao ','Guo ','Chayk ','Mu ','Pang ','Zhang ','Jiong ','Chan ','Pok ','Chi ',
        'Hu ','Pen ','Tang ','Phyey ','Hei ','','Mi ','Qiao ','Chem ','Fen ','Mong ','Pang ','Cwu ','Mie ','Chu ','Jie ',
        'Hen ','Lan ','Kan ','Phyeng ','Nyen ','Qian ','Pyeng ','Pyeng ','Hayng ','Kan ','Yo ','Hwan ','Yu ','Yu ','Ki ','Em ',
        'Pi ','Cheng ','Ze ','Kwang ','Cang ','Mo ','Qing ','Pi ','Qin ','Dun ','Sang ','Ki ','Ya ','Bai ','Jie ','Se ',
        'Lu ','Wu ','','Ku ','Ying ','Ce ','Pho ','Cem ','Ya ','Miao ','Kyeng ','Ci ','Pwu ','Tong ','Pang ','Fei ',
        'Sang ','Yi ','Zhi ','Tiao ','Zhi ','Xiu ','To ','Cwa ','Xiao ','Tu ','Gui ','Ko ','Pang ','Ceng ','You ','Bu ',
        'Ding ','Cheng ','Lai ','Pi ','Ji ','Am ','Se ','Kang ','Yong ','Tuo ','Song ','Se ','Qing ','Yu ','Yu ','Miao ',
        'Sou ','Chi ','Sang ','Phyey ','Kwu ','He ','Hui ','Liu ','Ha ','Lyem ','Lang ','Swu ','Zhi ','Pou ','Qing ','Kwu ',
        'Kwu ','Kun ','Ao ','Kwak ','Lou ','Um ','Lyo ','Dai ','Lu ','Yi ','Cwu ','Cen ','Tu ','Si ','Hum ','Myo ',
        'Chang ','Mwu ','Phyey ','Kwang ','Koc ','Koy ','Bi ','Cang ','Hay ','Lum ','Lin ','Liao ','Lye ','','Ying ','Xian ',
        'Ting ','Ong ','Li ','Cheng ','Yin ','Xun ','Yen ','Ceng ','Di ','Po ','Ken ','Hoy ','Nay ','Hoy ','Gong ','Ip ',
        ],
    'x5f':[
        'Kai ','Pyen ','Yi ','Ki ','Long ','Fen ','Ju ','Kam ','Hyek ','Zang ','Phyey ','Ik ','Yi ','I ','San ','Sik ',
        'Er ','Si ','Si ','Kwung ','Co ','In ','Hu ','Pwul ','Hong ','Wu ','Tui ','I ','Jiang ','Ba ','Shen ','Cey ',
        'Zhang ','Jue ','To ','Fu ','Di ','Mi ','Hyen ','Ho ','Chao ','No ','Jing ','Zhen ','Yi ','Mi ','Quan ','Wan ',
        'Shao ','Yak ','Xuan ','Jing ','Ton ','Cang ','Jiang ','Kang ','Peng ','Than ','Kang ','Bi ','Phil ','She ','Than ','Jian ',
        'Kwu ','Sei ','Pal ','Bi ','Kou ','Nagi ','Pyel ','Xiao ','Than ','Kuo ','Kang ','Hong ','Mi ','Kuo ','Man ','Jue ',
        'Ji ','Ji ','Gui ','Tang ','Lok ','Lu ','Tan ','Hyey ','Chey ','Hwi ','Hwi ','I ','Yi ','I ','I ','Huo ',
        'Huo ','Shan ','Hyeng ','Wen ','Tong ','En ','En ','Wuk ','Chi ','Chay ','Phyo ','Co ','Pin ','Phayng ','Yong ','Piao ',
        'Chang ','Yeng ','Chi ','Chi ','Zhuo ','Tuo ','Ji ','Pang ','Zhong ','Yek ','Wang ','Che ','Phi ','Chi ','Ling ','Pwul ',
        'Wang ','Ceng ','Co ','Wang ','Kyeng ','Tay ','Xi ','Swun ','Hun ','Yang ','Hoy ','Lyul ','Hwu ','Wa ','Cheng ','Zhi ',
        'Se ','Kyeng ','To ','Cong ','','Lai ','Cong ','Tuk ','Pay ','Sa ','','Qi ','Sang ','Zhi ','Cong ','Zhou ',
        'Lay ','E ','Xie ','Cha ','Jian ','Chi ','Jia ','Phyen ','Hwang ','Pok ','Swun ','Wei ','Pang ','Yo ','Mi ','Hyey ',
        'Zheng ','Piao ','Chi ','Tek ','Cing ','Cing ','Bie ','Tek ','Chong ','Chel ','Jiao ','Wei ','Yo ','Hwi ','Mei ','Long ',
        'Xiang ','Bao ','Qu ','Sim ','Ritsushinben ','Phil ','Yi ','Le ','Ren ','To ','Ding ','Gai ','Ki ','In ','Ren ','Chan ',
        'Tham ','Te ','Thuk ','Gan ','Qi ','Shi ','Chon ','Ci ','Mang ','Mang ','Xi ','Fan ','Ung ','Chem ','Min ','Min ',
        'Chwung ','Chwung ','O ','Ji ','O ','Xi ','Ye ','You ','Wan ','Cong ','Zhong ','Khway ','Yu ','Pyen ','Ki ','Qi ',
        'Cui ','Chim ','Tai ','Tun ','Qian ','Nyem ','Hun ','Hyung ','Nyu ','Wang ','Xian ','Hun ','Kang ','Hol ','Kai ','Pwun ',
        ],
    'x60':[
        'Huai ','Tai ','Song ','Wu ','Ou ','Chang ','Chuang ','Ju ','Yi ','Bao ','Cho ','Min ','Pei ','Cak ','Zen ','Ang ',
        'Kou ','Ban ','No ','Nao ','Ceng ','Pha ','Pho ','Chep ','Gu ','Ho ','Ju ','Tal ','Lyeng ','Sa ','Chou ','Di ',
        'Thay ','I ','Tu ','You ','Fu ','Kup ','Phyeng ','Seng ','Wen ','Ni ','Koy ','Fu ','Xi ','Bi ','You ','Kep ',
        'Xuan ','Chong ','Bing ','Hwang ','Xu ','Chu ','Pi ','Xi ','Xi ','Tan ','Koraeru ','Zong ','Dui ','','Ki ','Yi ',
        'Chi ','Im ','Swun ','Si ','Xi ','Lao ','Hang ','Kwang ','Mo ','Zhi ','Hyep ','Lyen ','Tiao ','Hwang ','Die ','Hao ',
        'Kong ','Gui ','Hang ','Xi ','Xiao ','Se ','Shi ','Kua ','Qiu ','Yang ','Ey ','Hui ','Chi ','Kwal ','Yi ','Hyung ',
        'Koy ','Lin ','Hoy ','Ca ','Hyul ','Chi ','Xiang ','Nu ','Han ','Un ','Kak ','Thong ','Nyem ','Kong ','Quan ','Sik ',
        'Hup ','Yue ','Peng ','Ken ','De ','Hyey ','E ','Kyuu ','Tong ','Yan ','Kai ','Ce ','Nao ','Yun ','Mang ','Yong ',
        'Yong ','Yen ','Pi ','Kon ','Cho ','Yel ','Yu ','Yu ','Jie ','Sil ','Zhe ','Lin ','Cey ','Han ','Hao ','Hyep ',
        'Ti ','Bu ','Up ','Qian ','Hoy ','Huy ','Phay ','Mwun ','Yi ','Heng ','Song ','Cen ','Cheng ','Kui ','Wu ','O ',
        'Yu ','Li ','Lyang ','Hwan ','Chong ','Yi ','Yel ','Li ','Nin ','Noy ','Ak ','Que ','Xuan ','Qian ','Wu ','Min ',
        'Cong ','Pi ','Pi ','Tek ','Chwey ','Chang ','Min ','Li ','Kyey ','Guan ','Guan ','Hayng ','To ','Che ','Kong ','Tian ',
        'Lun ','Xi ','Kan ','Kun ','Nyek ','Ceng ','Chwu ','Ton ','Guo ','Chem ','Liang ','Wan ','Yuan ','Jin ','Ji ','Lam ',
        'Yu ','Hok ','He ','Kwen ','Tan ','Chek ','Chek ','Nie ','Mang ','Chel ','Hol ','Hon ','Sek ','Chang ','Xin ','Yu ',
        'Hyey ','Ak ','Swa ','Chong ','Jian ','Yong ','Dian ','Ju ','Cham ','Cheng ','Tek ','Bei ','Qie ','Can ','Dan ','Guan ',
        'Tha ','Noy ','Wun ','Sang ','Chwey ','Die ','Hwang ','Cwun ','Kyeng ','Ya ','Seng ','Chuk ','Phyen ','Hun ','Zong ','Ti ',
        ],
    'x61':[
        'Cho ','Swu ','Bei ','Sen ','Wei ','Ge ','Ken ','Wei ','Yu ','Yu ','Bi ','Xuan ','Huan ','Min ','Phyak ','Uy ',
        'Mian ','Yong ','Kai ','Dang ','Um ','Ak ','Chen ','Mou ','Ke ','Ke ','Wu ','Ay ','Hyep ','Yan ','Nuo ','Kam ',
        'On ','Zong ','Sai ','Leng ','Fen ','','Kui ','Koy ','Que ','Gong ','Yun ','Su ','So ','Ki ','Yao ','Song ',
        'Hwang ','Ji ','Gu ','Ju ','Chang ','Ni ','Xie ','Kay ','Zheng ','Yong ','Cao ','Sun ','Sin ','Bo ','Kay ','Wen ',
        'Xie ','Hun ','Yong ','Yang ','Lyul ','Sao ','To ','Un ','Ca ','Xu ','Kyem ','Thay ','Hwang ','On ','Shen ','Ming ',
        '','She ','Cong ','Phyo ','Mo ','Mo ','Guo ','Chi ','Cham ','Cham ','Cham ','Cui ','Min ','Thuk ','Zhang ','Thong ',
        'O ','Shuang ','Man ','Kwan ','Kak ','Zao ','Jiu ','Hyey ','Kay ','Lian ','Ou ','Cong ','Jin ','Yin ','Lye ','Shang ',
        'Wi ','Tan ','Man ','Kan ','Sup ','Yong ','Kyeng ','Kang ','Di ','Zhi ','Lwu ','Juan ','Chek ','Chek ','Yok ','Ping ',
        'Liao ','Chong ','Wu ','Yong ','Zhi ','Tong ','Cheng ','Qi ','Qu ','Peng ','Pi ','Pyel ','Chun ','Kyo ','Cung ','Chi ',
        'Lyen ','Ping ','Kwey ','Hui ','Cho ','Cheng ','Un ','Yin ','Huy ','Huy ','Than ','Tan ','Duo ','Dui ','Dui ','Su ',
        'Jue ','Ce ','Xiao ','Fan ','Pwun ','Lao ','Lao ','Tong ','Kam ','Key ','Xian ','Min ','Kyeng ','Liao ','Mwu ','Cham ',
        'Jue ','Cu ','Hen ','Tan ','Sheng ','Pi ','Ek ','Chu ','Sem ','Nao ','Tam ','Than ','Kyeng ','Song ','Kam ','Jiao ',
        'Wai ','Huan ','Dong ','Kun ','Qin ','Qu ','Co ','Kan ','Hay ','Ung ','O ','Mwu ','Yek ','Lin ','Se ','Jun ',
        'Huai ','Men ','Lan ','Ai ','Lin ','Yem ','Gua ','Ha ','Chi ','Yu ','Yin ','Dai ','Meng ','Ai ','Mong ','Tay ',
        'Qi ','Mo ','Lan ','Mwun ','Chou ','Zhi ','Na ','Nuo ','Yan ','Yang ','Bo ','Zhi ','Kuang ','Kuang ','You ','Fu ',
        'Liu ','Mie ','Cing ','','Chan ','Meng ','La ','Hoy ','Hyen ','Rang ','Cham ','Ji ','Kwu ','Hwan ','Sep ','Uy ',
        ],
    'x62':[
        'Lyen ','Nan ','Mi ','Tang ','Jue ','Gang ','Gang ','Tang ','Kwa ','Yue ','Mwu ','Jian ','Swul ','Swu ','Yung ','Xi ',
        'Seng ','A ','Kyey ','Ge ','Can ','Cang ','Hok ','Qiang ','Zhan ','Dong ','Chek ','Jia ','Die ','Cek ','Al ','Kuk ',
        'Shi ','Kam ','Cip ','Kui ','Gai ','Deng ','Cen ','Chang ','Ge ','Cen ','Cel ','Yu ','Jian ','Yan ','Lyuk ','Huy ',
        'Cen ','Huy ','Huy ','Chak ','Tay ','Kwu ','Ho ','Ho ','Ho ','Ayk ','Shi ','Lye ','Mao ','Hu ','Lye ','Pang ',
        'So ','Phyen ','Dian ','Kyeng ','Shang ','Yi ','Yi ','Sen ','Ho ','Pi ','Yem ','Swu ','Shu ','Cay ','Chal ','Qiu ',
        'Le ','Pok ','Pay ','Tha ','Reng ','Pwul ','Hameru ','Cay ','Thak ','Zhang ','Diao ','Kang ','Yu ','Ku ','Han ','Shen ',
        'Cha ','Yi ','Gu ','Kwu ','Wu ','Tuo ','Qian ','Zhi ','In ','Kuo ','Men ','Sao ','Yang ','Niu ','Pwun ','Cha ',
        'Rao ','Kup ','Qian ','Pan ','Jia ','Yu ','Pwu ','Ao ','Xi ','Pi ','Ci ','Zi ','Ayk ','Dun ','Co ','Sung ',
        'Ki ','Yan ','Kuang ','Pyen ','Cho ','Ju ','Mwun ','Hu ','Yue ','Kyel ','Pha ','Qin ','Zhen ','Zheng ','Yun ','Wan ',
        'Nu ','Ek ','Se ','Co ','Pwu ','Thwu ','Twu ','Hang ','Cel ','Pou ','Fu ','Pho ','Pal ','Ao ','Thayk ','Tuan ',
        'Kou ','Lun ','Qiang ','','Hu ','Bao ','Bing ','Zhi ','Phyeng ','Tan ','Pu ','Phi ','Thay ','Yao ','Zhen ','Zha ',
        'Yang ','Pho ','He ','Ni ','Yi ','Ce ','Chi ','Pi ','Za ','Mal ','Mei ','Shen ','Ap ','Chwu ','Qu ','Min ',
        'Chu ','Jia ','Pwul ','Zhan ','Cwu ','Tan ','Thak ','Mwu ','Nyem ','Lap ','Pwu ','Pho ','Pan ','Pak ','Ling ','Na ',
        'Koy ','Kyem ','Ke ','Chek ','Pal ','Tha ','Tha ','Yo ','Kwu ','Col ','Pan ','Cho ','Pay ','Bai ','Di ','Ni ',
        'Ke ','Hwak ','Long ','Jian ','','Yong ','Lan ','Ning ','Pal ','Ze ','Qian ','Hen ','Kwal ','Sik ','Kil ','Cung ',
        'Nin ','Kong ','Gong ','Kwen ','Shuan ','Con ','Chal ','Ko ','Chi ','Xie ','Ce ','Hui ','Phyeng ','Yey ','Sup ','Na ',
        ],
    'x63':[
        'Bo ','Ci ','Kway ','Zhi ','Kuo ','Duo ','Duo ','Ci ','Sel ','An ','Nong ','Zhen ','Kyek ','Jiao ','Ku ','Dong ',
        'Na ','To ','Lyen ','Zha ','Lu ','Die ','Wa ','Jue ','Lyut ','Ju ','Zhi ','Luan ','Ya ','Zhua ','Ta ','Xie ',
        'Nao ','Dang ','Jiao ','Zheng ','Ji ','Hui ','Xun ','Ku ','Ay ','Tuo ','Na ','Cwa ','Bo ','Geng ','Ti ','Cin ',
        'Cheng ','Suo ','Suo ','Keng ','Mei ','Long ','Ju ','Peng ','Jian ','Up ','Ceng ','Yen ','Nuo ','Man ','Hyep ','Cha ',
        'Feng ','Jiao ','O ','Kwun ','Kwu ','Tong ','Kon ','Huo ','Tu ','Chak ','Pou ','Le ','Phal ','Han ','So ','Nal ',
        'Yen ','Ze ','Song ','Ye ','Jue ','Pho ','Huan ','Chek ','Zun ','Yi ','Zhai ','Lu ','Sou ','Tuo ','Lao ','Sun ',
        'Bang ','Jian ','Hwan ','Dao ','','Wan ','Qin ','Pong ','Sa ','Lyel ','Min ','Mwun ','Fu ','Bai ','Ke ','Dao ',
        'Wo ','Ay ','Kwen ','Yue ','Zong ','Chen ','Chwu ','Chep ','Tu ','Ben ','Nal ','Nyem ','Nuo ','Zu ','Wo ','Se ',
        'Hun ','Cheng ','Dian ','So ','Lyun ','Qing ','Gang ','Chel ','Swu ','To ','Pwu ','Di ','Cang ','Gun ','Ki ','To ',
        'Qia ','Qi ','Pay ','Shu ','Qian ','Ling ','Ayk ','Ya ','Kwul ','Zheng ','Liang ','Kway ','Yey ','Huo ','Shan ','Ceng ',
        'Lyak ','Chay ','Tham ','Chey ','Bing ','Cep ','Ti ','Kong ','Chwu ','Em ','Co ','Zou ','Kwuk ','Tian ','Qian ','Ken ',
        'Bai ','Shou ','Key ','Lu ','Guo ','Haba ','','Zhi ','Dan ','Maang ','Xian ','So ','Guan ','Peng ','Yen ','Nuo ',
        'Kan ','Zhen ','Jiu ','Cen ','Yu ','Yan ','Kyu ','Nan ','Hong ','Yu ','Pi ','Wei ','Sai ','Zou ','Xuan ','Myo ',
        'Cey ','Nie ','Sap ','Shi ','Zong ','Zhen ','Up ','Shun ','Heng ','Bian ','Yang ','Hwan ','Am ','Zuan ','An ','Se ',
        'Al ','Ak ','Ke ','Chwi ','Ji ','Ti ','La ','La ','Cheng ','Kay ','Jiu ','Chwu ','Tu ','Key ','Hwi ','Geng ',
        'Chong ','Shuo ','Sel ','Xie ','Wen ','Ken ','Ya ','Sap ','Zha ','Bei ','Yao ','','Dam ','Lan ','Wen ','Qin ',
        ],
    'x64':[
        'Chan ','Ge ','Lou ','Zong ','Geng ','Jiao ','Kwu ','Qin ','Yong ','Kak ','Chou ','Chi ','Zhan ','Son ','Sun ','Pak ',
        'Hyuk ','Rong ','Pang ','Cha ','So ','Ke ','Yo ','To ','Zhi ','Nu ','Xie ','Jian ','Swu ','Qiu ','Gao ','Xian ',
        'Shuo ','Sang ','Cin ','Mie ','Ayk ','Chwu ','Nuo ','Shan ','Thap ','Jie ','Tang ','Pan ','Pan ','Thap ','Li ','To ',
        'Kol ','Zhi ','Wa ','Xia ','Qian ','Wen ','Chang ','Tian ','Zhen ','E ','Hyu ','Nuo ','Quan ','Cha ','Chak ','Ge ',
        'Wu ','En ','Sep ','Kang ','She ','Shu ','Bai ','Yao ','Bin ','Sou ','Tan ','Sa ','Chan ','Suo ','Liao ','Chong ',
        'Chuang ','Guo ','Pyeng ','Feng ','Shuai ','Di ','Qi ','','Cek ','Lian ','Tang ','Chi ','Guan ','Lu ','Luo ','Lou ',
        'Chong ','Gai ','Hu ','Zha ','Chuang ','Tang ','Hua ','Choy ','Nai ','Ma ','Jiang ','Gui ','Ying ','Chek ','Ao ','Ci ',
        'Nie ','Man ','Shan ','Kwu ','Shu ','Suo ','Tuan ','Jiao ','Mo ','Mo ','Cep ','Sem ','Keng ','Phyo ','Jiang ','Yin ',
        'Gou ','Qian ','Liao ','Kyek ','Ying ','Kwey ','Pie ','Pie ','Lo ','Dun ','Xian ','Ruan ','Kui ','Zan ','Yi ','Xun ',
        'Thayng ','Thayng ','Sal ','Yo ','Heng ','Se ','Qian ','Huang ','Thap ','Cwun ','Nyen ','Lin ','Zheng ','Hwi ','Tang ','Kyo ',
        'Ji ','Cao ','Dan ','Dan ','Chel ','Pal ','Che ','Jue ','Xiao ','Lyo ','Ben ','Mwu ','Qiao ','Pha ','Chwal ','Zhuo ',
        'Chan ','Tuo ','Pak ','Qin ','Dun ','Nian ','','Xie ','Lu ','Kyo ','Cuan ','Tal ','Kam ','Qiao ','Kwa ','Kem ',
        'Gan ','Ong ','Lei ','Kuo ','Lo ','Chen ','Zhuo ','Thayk ','Pu ','Chak ','Kyek ','Dang ','Suo ','Co ','Kyeng ','Jing ',
        'Hwan ','Jie ','Kum ','Kuai ','Tam ','Hyu ','Ge ','Pyek ','Pyek ','Ao ','Ke ','Ye ','','Mang ','Sou ','Mi ',
        'Cey ','Tay ','Thak ','To ','Xing ','Lam ','Chal ','Ke ','Ye ','Ru ','Ye ','Ye ','Uy ','Hwa ','Ji ','Pin ',
        'Ning ','Kak ','Chek ','Jie ','Hwak ','Mo ','Jian ','Xie ','Lie ','Tan ','Pha ','Sou ','Lu ','Lue ','Yo ','Zhi ',
        ],
    'x65':[
        'Pan ','Yang ','Long ','Sa ','The ','Zan ','Nian ','Hen ','Jun ','Huo ','Lye ','La ','Han ','Ying ','Lu ','Long ',
        'Qian ','Qian ','Zan ','Qian ','Lan ','San ','Ying ','Mei ','Yang ','Cham ','','Cuan ','Xie ','Sep ','Luo ','Jun ',
        'Mi ','Li ','Chan ','Lyen ','Than ','Zuan ','Li ','Dian ','Wa ','Dang ','Kyo ','Hwak ','Lam ','Li ','Nang ','Ci ',
        'Gui ','Gui ','Ki ','Xin ','Pu ','Sui ','Swu ','Ko ','Yu ','Kay ','Yi ','Kong ','Gan ','Pan ','Pang ','Ceng ',
        'Bo ','Dian ','Kou ','Min ','Wu ','Ko ','He ','Ce ','Hyo ','Mi ','Chu ','Ge ','Di ','Se ','Kyo ','Min ',
        'Chen ','Kwu ','Zhen ','Duo ','E ','Chik ','O ','Phay ','Se ','Kyo ','Duo ','Lian ','Nie ','Phyey ','Chang ','Dian ',
        'Duo ','I ','Kam ','San ','Ke ','Yan ','Ton ','Qi ','Dou ','Hyo ','Duo ','Jiao ','Kyeng ','Yang ','Xia ','Min ',
        'Swu ','Ai ','Ko ','Ai ','Ceng ','Cek ','Zhen ','Pwu ','Swu ','Liao ','Qu ','Xiong ','Xi ','Jiao ','Sen ','Jiao ',
        'Zhuo ','Twu ','Lyem ','Phyey ','Li ','Hyo ','Hyo ','Mwun ','Hak ','Qi ','Qi ','Zhai ','Pin ','Jue ','Zhai ','',
        'Pi ','Pan ','Ban ','Lan ','Yu ','Lan ','Wei ','Twu ','Sheng ','Lyo ','Jia ','Kok ','Sa ','Ka ','Yu ','Cim ',
        'Jiao ','Al ','Tou ','Chu ','Kun ','Chek ','Yin ','Pwu ','Qiang ','Zhan ','Qu ','Cak ','Cham ','Tan ','Zhuo ','Sa ',
        'Sin ','Cak ','Chak ','Qin ','Lin ','Zhuo ','Chu ','Tan ','Zhu ','Pang ','Xie ','Hang ','E ','Si ','Pei ','Yu ',
        'Mye ','Pang ','Ki ','Cen ','Mo ','Lye ','Phay ','Pi ','Liu ','Pwu ','Pang ','Sen ','Ceng ','Jing ','Ni ','Cok ',
        'Zhao ','Yi ','Lyu ','Shao ','Jian ','Es ','Yi ','Ki ','Zhi ','Fan ','Piao ','Fan ','Zhan ','Guai ','Sui ','Yu ',
        'Mwu ','Ji ','Ki ','Ki ','Huo ','Il ','Tan ','Kwu ','Ci ','Co ','Xie ','Tiao ','Swun ','Wuk ','Xu ','Xu ',
        'Kan ','Han ','Tay ','Di ','Wu ','Chan ','Shi ','Kuang ','Yang ','Shi ','Wang ','Min ','Min ','Ton ','Chun ','O ',
        ],
    'x66':[
        'Yun ','Bei ','Ang ','Chi ','Ban ','Jie ','Kon ','Sung ','Hu ','Pang ','Ho ','Gui ','Chang ','Xuan ','Myeng ','Hon ',
        'Pwun ','Kum ','Hu ','Yek ','Sek ','Hun ','Yan ','Ze ','Fang ','Tan ','Shen ','Ke ','Yang ','Zan ','Pyeng ','Seng ',
        'Yeng ','Hyen ','Pei ','Zhen ','Lyeng ','Chwun ','Hao ','May ','Cak ','Mo ','Bian ','Kwu ','Hun ','So ','Zong ','Si ',
        'Ha ','Wuk ','Fei ','Die ','Myo ','Nil ','Chang ','On ','Dong ','Ai ','Pyeng ','Ang ','Cwu ','Long ','Xian ','Kuang ',
        'Tiao ','Co ','Si ','Hwang ','Hwang ','Xuan ','Kui ','Xu ','Kyo ','Cin ','Zhi ','Cin ','Sang ','Tong ','Hong ','An ',
        'Gai ','Xiang ','Shai ','Xiao ','Ye ','Yun ','Hui ','Han ','Han ','Cwun ','Man ','Hyen ','Kun ','Cwu ','Huy ','Seng ',
        'Sheng ','Pho ','Cel ','Zhe ','O ','Hwan ','Hoy ','Ho ','Sin ','Man ','Tian ','Thak ','Swi ','Zhou ','Po ','Kyeng ',
        'Sek ','Shan ','Yi ','Sek ','Cheng ','Qi ','Ceng ','Kwi ','Ceng ','Yi ','Ci ','Am ','Wan ','Lin ','Liang ','Chang ',
        'Wang ','Hyo ','Zan ','Hi ','Hwen ','Xuan ','Yi ','Ka ','Hwun ','Hwi ','Fu ','Min ','Kyu ','He ','Yeng ','Du ',
        'Wi ','Se ','Qing ','Mao ','Nan ','Jian ','Nan ','Am ','Yang ','Chun ','Yao ','Suo ','Jin ','Myeng ','Kyo ','Kai ',
        'Ko ','Weng ','Chang ','Ki ','Hao ','Yan ','Li ','Ai ','Ki ','Gui ','Men ','Cam ','Sel ','Hao ','Mo ','Mo ',
        'Cong ','Nil ','Cang ','Hye ','Phok ','Han ','Xuan ','Chuan ','Lyo ','Sem ','Dan ','Kyeng ','Pie ','Lin ','Ton ','Huy ',
        'Ey ','Ki ','Huang ','Tai ','Yep ','Yep ','Lyek ','Tam ','Tong ','Hyo ','Fei ','Qin ','Zhao ','Hao ','Yi ','Xiang ',
        'Xing ','Sen ','Jiao ','Pho ','Jing ','Yan ','Ay ','Ye ','Ru ','Se ','Mong ','Hwun ','Yo ','Pho ','Li ','Chen ',
        'Kwang ','Cep ','','Yen ','Huo ','Lu ','Huy ','Rong ','Long ','Nang ','La ','Luan ','Swa ','Tang ','Em ','Chok ',
        'Wal ','Yue ','Kok ','Yey ','Kyeng ','Ye ','Hu ','Kal ','Se ','Co ','Co ','Shou ','Man ','Ceng ','Cung ','Chey ',
        ],
    'x67':[
        'Choy ','Can ','Xu ','Hoy ','Yin ','Kel ','Fen ','Pi ','Wel ','Yu ','Ruan ','Pwung ','Pan ','Pok ','Ling ','Fei ',
        'Qu ','','Nu ','Tiao ','Sak ','Cim ','Lang ','Lang ','Juan ','Ming ','Huang ','Mang ','Tun ','Co ','Ki ','Ki ',
        'Ying ','Zong ','Wang ','Tong ','Lang ','','Mong ','Long ','Mok ','Tung ','Mi ','Mal ','Pon ','Chal ','Chwul ','Chwul ',
        '','Cwu ','Ren ','Pha ','Pak ','Tha ','Tha ','Dao ','Li ','Qiu ','Kwey ','Jiu ','Bi ','Hwu ','Ting ','Ci ',
        'Sha ','Eburi ','Za ','Quan ','Qian ','Yu ','Kan ','Wu ','Cha ','Sam ','Xun ','Fan ','Wu ','Zi ','Li ','Hayng ',
        'Cay ','Chon ','Ren ','Phyo ','Tuo ','Di ','Cang ','Mang ','Chi ','Yi ','Gu ','Gong ','Twu ','Yi ','Ki ','Sok ',
        'Kang ','Co ','Moku ','Son ','Tochi ','Lai ','Sugi ','Mang ','Yang ','Ma ','Cho ','Si ','Wen ','Hang ','Phyey ','Pay ',
        'Kel ','Tong ','Ko ','Myo ','Xian ','Ce ','Chun ','Pha ','Shu ','Hua ','Xin ','Nyu ','Ce ','Chou ','Song ','Phan ',
        'Song ','Ji ','Yue ','Jin ','Gou ','Ji ','Mao ','Pi ','Bi ','Wang ','Ang ','Pang ','Pwun ','Yi ','Fu ','Nam ',
        'Sek ','Hu ','Ya ','Twu ','Xun ','Chim ','Yao ','Lim ','Yey ','Wa ','May ','Zhao ','Kwa ','Ci ','Cong ','Yun ',
        'Waku ','Dou ','Shu ','Zao ','','Li ','Ro ','Jian ','Cheng ','Shou ','Qiang ','Feng ','Nan ','Xiao ','Xian ','Ko ',
        'Phyeng ','Tay ','Si ','Ci ','Guai ','Xiao ','Ka ','Ka ','Kwu ','Fu ','Mo ','Yi ','Ye ','Ye ','Si ','Nie ',
        'Bi ','Tha ','Yi ','Ling ','Pyeng ','Ni ','La ','He ','Pan ','Fan ','Cong ','Dai ','Ci ','Yang ','Fu ','Payk ',
        'Mo ','Kam ','Chil ','Yem ','Yu ','Mao ','Zhao ','Song ','Ca ','Hap ','Yu ','Shen ','Gui ','Thak ','Cak ','Nam ',
        'Ning ','Yong ','Ce ','Zhi ','Zha ','Sa ','Dan ','Gu ','','Kwu ','Ao ','Fu ','Kan ','Bo ','Duo ','Ka ',
        'Nay ','Cwu ','Bi ','Lyu ','Si ','Chayk ','Sa ','Chwuk ','Pei ','Si ','Guai ','Sa ','Yao ','Jue ','Kwu ','Si ',
        ],
    'x68':[
        'Zhi ','Liu ','Mei ','Hoy ','Yeng ','Chayk ','','Biao ','Zhan ','Jie ','Long ','Dong ','Lu ','Sayng ','Li ','Lan ',
        'Yong ','Shu ','Swun ','Cen ','Qi ','Zhen ','Se ','Lyul ','Yi ','Xiang ','Zhen ','Li ','Su ','Kwal ','Kan ','Bing ',
        'Ren ','Kyo ','Payk ','Ren ','Bing ','Zi ','Chou ','Yi ','Jie ','Xu ','Cwu ','Jian ','Zui ','Er ','I ','Wuk ',
        'Fa ','Kong ','Ko ','Lao ','Cen ','Li ','','Yang ','Hayk ','Kun ','Zhi ','Sik ','Kyek ','Cay ','Luan ','Fu ',
        'Kel ','Hang ','Kyey ','To ','Kwang ','Wei ','Kwang ','Ru ','An ','An ','Juan ','Yi ','Zhuo ','Ku ','Cil ','Qiong ',
        'Tong ','Sang ','Sang ','Hwan ','Kil ','Jiu ','Xue ','Duo ','Zhui ','Yu ','Zan ','Kasei ','Ayng ','Masu ','','Zhan ',
        'Ya ','Nao ','Zhen ','Dang ','Qi ','Qiao ','Hua ','Hoy ','Jiang ','Zhuang ','Xun ','Suo ','Sha ','Cin ','Bei ','Ceng ',
        'Gua ','Jing ','Bo ','Ben ','Pwu ','Rui ','Thong ','Kak ','Xi ','Lang ','Liu ','Feng ','Qi ','Wen ','Kwun ','Han ',
        'Cu ','Lyang ','Qiu ','Ceng ','You ','May ','Pang ','Long ','Peng ','Zhuang ','Di ','Xuan ','Tu ','Zao ','Ao ','Kok ',
        'Bi ','Di ','Han ','Cay ','Chi ','Ren ','Bei ','Kyeng ','Jian ','Huan ','Wan ','Na ','Jia ','Co ','Ji ','Hyo ',
        'Lye ','Wan ','Cho ','Sim ','Fen ','Song ','Meng ','O ','Li ','Li ','Dou ','Cen ','Ying ','Sa ','Ju ','Cey ',
        'Kyey ','Kon ','Zhuo ','So ','Chan ','Pem ','Mi ','Jing ','Li ','Bing ','Fumoto ','Shikimi ','Tao ','Zhi ','Lai ','Lian ',
        'Jian ','Zhuo ','Ling ','Li ','Ki ','Pyeng ','Zhun ','Cong ','Qian ','Myen ','Ki ','Ki ','Chay ','Kon ','Chan ','Te ',
        'Pi ','Pai ','Pong ','Pou ','Hun ','Cong ','Ceng ','Co ','Kuk ','Li ','Pwung ','Yu ','Yu ','Gu ','Hun ','Tong ',
        'Tang ','Gang ','Wang ','Chey ','Xi ','Fan ','Cheng ','Can ','Kyey ','Yuan ','Yan ','Yu ','Kwen ','Yi ','Sam ','Ren ',
        'Chui ','Leng ','Se ','Zhuo ','Fu ','Ke ','Lai ','Zou ','Zou ','To ','Kwan ','Pwun ','Pwun ','Chen ','Qiong ','Nie ',
        ],
    'x69':[
        'Wan ','Kwak ','Lu ','Hao ','Cep ','Uy ','Chou ','Ju ','Ju ','Cheng ','Zuo ','Lyang ','Qiang ','Sik ','Chwu ','Ya ',
        'Ju ','Pi ','Cho ','Zhuo ','Zi ','Bin ','Peng ','Ding ','Chu ','Chang ','Mun ','Momiji ','Kem ','Gui ','Xi ','Du ',
        'Qian ','Kunugi ','Kai ','Shide ','Luo ','Zhi ','Ken ','Myeng ','Tafu ','','Peng ','Zhan ','','Tuo ','Sen ','Duo ',
        'Ya ','Fou ','Wei ','Wei ','Tan ','Jia ','Cong ','Jian ','Yi ','Chim ','Po ','Yan ','Yan ','Yen ','Zhan ','Chwun ',
        'Yu ','He ','Sa ','Wo ','Pian ','Bi ','Yao ','Huo ','Xu ','Ruo ','Yang ','La ','Yan ','Ben ','Hun ','Kyu ',
        'Jie ','Kui ','Si ','Phwung ','Sel ','Tha ','Zhi ','Ken ','Mu ','Mwu ','Cho ','Hu ','Hu ','Lyen ','Lung ','Ting ',
        'Nam ','Yu ','Yu ','Mi ','Song ','Wen ','Wen ','Ying ','Ceng ','Pian ','Cep ','Cup ','Kal ','Ep ','Ce ','Swun ',
        'Yu ','Cou ','Wei ','May ','Di ','Kuk ','Jie ','Hay ','Chwu ','Yeng ','Rou ','Heng ','Lwu ','Le ','Hazou ','Katsura ',
        'Pin ','Muro ','Kay ','Tan ','Lan ','Yun ','Yu ','Chen ','Lu ','Ju ','Sakaki ','','Pi ','Xie ','Ka ','Yi ',
        'Zhan ','Pwu ','Nai ','Mi ','Lang ','Yong ','Kok ','Jian ','Kwu ','Ta ','Yao ','Cin ','Pang ','Sha ','Yuan ','Cay ',
        'Ming ','Su ','Jia ','Yao ','Kel ','Hwang ','Kan ','Pi ','Ca ','Qian ','Ma ','Sun ','Yuan ','Sa ','Yeng ','Shi ',
        'Ci ','Choy ','Yun ','Ting ','Lyu ','Rong ','Tang ','Kyo ','Zhai ','Si ','Sheng ','Thap ','Hap ','Xi ','Kol ','Qi ',
        'Ko ','Ko ','Sun ','Pan ','Tao ','Ge ','Xun ','Cen ','Nou ','Ji ','Sak ','Kwu ','Thoy ','Chang ','Cha ','Qian ',
        'Koy ','Mei ','Xu ','Kong ','Gao ','Zhuo ','Tuo ','Kyou ','Yang ','Cen ','Jia ','Jian ','Zui ','Tou ','Rou ','Bin ',
        'Zhu ','','Xi ','Qi ','Lian ','Hyey ','Yong ','Cham ','Kwak ','Kay ','Kay ','Tuan ','Hua ','Sayk ','Sen ','Cui ',
        'Beng ','You ','Kok ','Jiang ','Hu ','Huan ','Kui ','Yi ','Nie ','Ko ','Kang ','Kyu ','Gui ','Co ','Man ','Kun ',
        ],
    'x6a':[
        'Cek ','Zhuang ','Ak ','Lang ','Chen ','Cong ','Li ','Xiu ','Qing ','Shuang ','Pen ','Thong ','Guan ','Ji ','Suo ','Lei ',
        'Lu ','Lyang ','Mil ','Lwu ','So ','Su ','Ke ','Ce ','Tang ','Phyo ','Lu ','Kyu ','Shu ','Zha ','Chwu ','Cang ',
        'Men ','Mo ','Niao ','Yang ','Tiao ','Peng ','Zhu ','Sha ','Chi ','Kwen ','Hoyng ','Kyen ','Cong ','','Hokuso ','Qiang ',
        'Tara ','Ying ','Er ','Xin ','Zhi ','Cho ','Zui ','Cong ','Pok ','Swu ','Hwa ','Kwey ','Zhen ','Cwun ','Yue ','Zhan ',
        'Xi ','Xun ','Dian ','Pel ','Kam ','Mo ','Wu ','Chwi ','Yo ','Lin ','Lyu ','Kyo ','Xian ','Run ','Fan ','Zhan ',
        'Thak ','Lao ','Wun ','Swun ','Tui ','Cheng ','Tang ','Meng ','Kyul ','Tung ','Swuk ','Jue ','Jue ','Tan ','Hui ','Ki ',
        'Nuo ','Sang ','Tha ','Ning ','Rui ','Zhu ','Tong ','Zeng ','Fen ','Qiong ','Ran ','Hoyng ','Cen ','Gu ','Liu ','Lao ',
        'Gao ','Chu ','Zusa ','Nude ','Ca ','San ','Ji ','Dou ','Shou ','Lu ','Gian ','','Yuan ','Ta ','Shu ','Kang ',
        'Tan ','Lin ','Nong ','Yin ','Kyek ','Sui ','Shan ','Zui ','Xuan ','Ceng ','Gan ','Ju ','Zui ','Ek ','Kum ','Pu ',
        'Chem ','Lei ','Feng ','Hui ','Tang ','Ji ','Sui ','Pyek ','Bi ','Ding ','Chu ','Zhua ','Hoy ','Cup ','Jie ','Ka ',
        'Kyeng ','Zhe ','Kem ','Cang ','Dao ','Yi ','Biao ','Song ','She ','Lin ','Reki ','Cha ','Meng ','Yin ','To ','Tay ',
        'Mian ','Qi ','','Pin ','Huo ','Ji ','Yem ','Mi ','Ning ','Yi ','Gao ','Ham ','Un ','Er ','Qing ','Yem ',
        'Qi ','Mi ','To ','Kwey ','Chun ','Ji ','Kui ','Po ','Deng ','Chu ','Han ','Mian ','You ','Zhi ','Guang ','Qian ',
        'Lei ','Lei ','Sa ','Lo ','Li ','Cuan ','Lu ','Mie ','Hui ','Ou ','Lye ','Cul ','Ko ','Tok ','Yen ','Lyek ',
        'Fei ','Zhuo ','Sou ','Lian ','Sen ','Chu ','','Zhu ','Lu ','Yan ','Lyek ','Zhu ','Chin ','Jie ','E ','Su ',
        'Huai ','Nie ','Yu ','Long ','Lai ','','Hen ','Kwi ','Ju ','Xiao ','Ling ','Ayng ','Chem ','Yin ','You ','Ying ',
        ],
    'x6b':[
        'Xiang ','Nong ','Pak ','Cham ','Lan ','Ju ','Shuang ','She ','Wei ','Cong ','Kwen ','Qu ','Cang ','','Yu ','Luo ',
        'Li ','Chan ','Lan ','Dang ','Jue ','Em ','Lam ','Lan ','Zhu ','Lei ','Li ','Ba ','Nang ','Yu ','Lyeng ','Tsuki ',
        'Hum ','Cha ','Huan ','Hun ','Yu ','Yu ','Qian ','Ou ','Xu ','Chao ','Chu ','Chi ','Hay ','Yi ','Jue ','Xi ',
        'Xu ','Xia ','Yok ','Kuai ','Lang ','Kuan ','Shuo ','Huy ','Ay ','Uy ','Ki ','Hwul ','Chi ','Hum ','Kwan ','Kam ',
        'Kuan ','Kan ','Chuan ','Sap ','','Yin ','Hum ','Hel ','Yu ','Kyem ','Xiao ','Yi ','Ka ','Wu ','Than ','Jin ',
        'Kwu ','Hu ','Ti ','Hwan ','He ','Pen ','Xi ','Xiao ','Xu ','Hup ','Sen ','Kem ','Chu ','Yi ','Kan ','Ye ',
        'Chel ','Hwan ','Ci ','Ceng ','Cha ','Po ','Mwu ','Ki ','Bu ','Po ','Way ','Ju ','Qian ','Chi ','Se ','Chi ',
        'Se ','Zhong ','Sey ','Sey ','Li ','Cuo ','Yu ','Lyek ','Kwi ','Al ','Dai ','Sa ','Jian ','Zhe ','Mo ','Mol ',
        'Yo ','Mol ','Co ','Ang ','Cin ','Sheng ','Thay ','Shang ','Xu ','Swun ','Swu ','Can ','Jue ','Phyo ','Qia ','Qiu ',
        'Su ','Kung ','Yun ','Lian ','Yi ','Fou ','Sik ','Ye ','Can ','Hun ','Dan ','Ji ','Ye ','','Wun ','Wen ',
        'Chou ','Bin ','Chey ','Jin ','Sang ','Yin ','Diao ','Cu ','Hui ','Cuan ','Yi ','Than ','Du ','Kang ','Lyem ','Pin ',
        'Du ','Sen ','Sem ','Swi ','Ou ','Tan ','Zhu ','Un ','Qing ','Yi ','Sal ','Kak ','Kak ','Hyo ','Jun ','Cen ',
        'Hwey ','Hwey ','Gu ','Que ','Kyek ','Uy ','Kwu ','Hui ','Duan ','Yi ','Xiao ','Mwu ','Guan ','Mo ','May ','May ',
        'Ai ','Zuo ','Tok ','Yuk ','Pi ','Bi ','Pi ','Pi ','Pi ','Bi ','Cham ','Mo ','','','Pu ','Mushiru ',
        'Jia ','Zhan ','Sai ','Mu ','Tuo ','Xun ','Er ','Rong ','Xian ','Ju ','Mu ','Ho ','Kwu ','Dou ','Mushiru ','Tam ',
        'Pei ','Ju ','Duo ','Chwi ','Bi ','San ','','Mao ','Sui ','Shu ','Yu ','Tuo ','He ','Jian ','Ta ','Sam ',
        ],
    'x6c':[
        'Lu ','Mu ','Mao ','Tong ','Rong ','Chang ','Pu ','Luo ','Cen ','Sao ','Zhan ','Meng ','Luo ','Qu ','Die ','Ssi ',
        'Ce ','Min ','Jue ','Mayng ','Qi ','Pie ','Nai ','Ki ','Dao ','Xian ','Chuan ','Pwun ','Ri ','Nei ','','Fu ',
        'Shen ','Dong ','Qing ','Ki ','In ','Xi ','Hai ','Yang ','An ','Ya ','Ke ','Qing ','Ya ','Dong ','Dan ','Lu ',
        'Qing ','Yang ','On ','On ','Swu ','Sanzui ','Zheng ','Ping ','Yeng ','Dang ','Sui ','Le ','Ni ','Than ','Pem ','Kwey ',
        'Ceng ','Cip ','Kwu ','Pha ','Ze ','Mian ','Cuan ','Hui ','Diao ','Yi ','Cha ','Cak ','Chuan ','Wan ','Pem ','Tay ',
        'Sek ','Tuo ','Mang ','Qiu ','Hul ','San ','Pai ','Han ','Qian ','O ','O ','Sin ','Sa ','Ye ','Hong ','Kang ',
        'Ci ','O ','Tsuchi ','','Tang ','Zhi ','Chi ','Qian ','Myek ','Yul ','Wang ','Qing ','Jing ','Yey ','Jun ','Hong ',
        'Thay ','Quan ','Kup ','Bian ','Pha ','Gan ','Mwun ','Zhong ','Fang ','Xiong ','Kyel ','Hang ','','Ki ','Pwun ','Xu ',
        'Xu ','Sim ','Ki ','Ok ','Wun ','Wen ','Hang ','Yen ','Chim ','Chim ','Dan ','You ','Ton ','Ho ','Huo ','Qi ',
        'Mok ','Rou ','Mol ','Tap ','Myen ','Mwul ','Chwung ','Tian ','Pi ','Sa ','Ci ','Phay ','Pan ','Zhui ','Za ','Gou ',
        'Liu ','Mei ','Thayk ','Feng ','Ou ','Li ','Lun ','Cang ','Feng ','Wei ','Hu ','Mal ','May ','Shu ','Ce ','Zan ',
        'Thak ','Tha ','Tuo ','Ha ','Li ','Mi ','Yi ','Fa ','Pi ','Yu ','Tian ','Chi ','So ','Ko ','Chem ','Yen ',
        'Si ','Hwang ','Hyeng ','Ju ','Sel ','Swi ','Il ','Jia ','Zhong ','Chen ','Pak ','Hui ','Phil ','Ben ','Zhuo ','Chu ',
        'Luk ','Yu ','Gu ','Hong ','Kem ','Pep ','Mao ','Sa ','Hu ','Phyeng ','Ca ','Pem ','Ci ','So ','Ning ','Cheng ',
        'Lyeng ','Pho ','Pha ','Up ','Si ','Ni ','Ju ','Yue ','Cwu ','Sheng ','Lei ','Hyen ','Xue ','Fu ','Pan ','Min ',
        'Thay ','Ang ','Ji ','Yeng ','Guan ','Beng ','Xue ','Long ','Lu ','','Bo ','Xie ','Po ','Ze ','Jing ','Yin ',
        ],
    'x6d':[
        'Zhou ','Ji ','Yi ','Hui ','Hoy ','Zui ','Cheng ','In ','Wei ','Hou ','Chen ','Yang ','Lyel ','Si ','Ji ','Er ',
        'Xing ','Po ','Sey ','Suo ','Zhi ','Yin ','Wu ','Sey ','Kao ','Swu ','Jiang ','Lak ','','An ','Tong ','I ',
        'Mou ','Lei ','Yi ','Mi ','Quan ','Cin ','Mo ','Yu ','Xiao ','Sel ','Hong ','Hyek ','Sok ','Kuang ','To ','Qie ',
        'Ju ','Er ','Cwu ','Ru ','Ping ','Swun ','Hyung ','Zhi ','Kwang ','Wen ','Myeng ','Hwal ','Wa ','Hup ','Pha ','Wu ',
        'Qu ','Lyu ','Yi ','Jia ','Jing ','Chen ','Jiang ','Jiao ','Cheng ','Shi ','Zhuo ','Ce ','Pal ','Kuai ','Ji ','Liu ',
        'Chan ','Hun ','Hu ','Nong ','Xun ','Jin ','Lie ','Qiu ','Wei ','Cel ','Cwun ','Han ','Pin ','Mang ','Zhuo ','You ',
        'Xi ','Pal ','Dou ','Wan ','Koyng ','Up ','Pho ','Yeng ','Lan ','Ho ','Lang ','Han ','Li ','Geng ','Pwu ','Wu ',
        'Lian ','Chun ','Feng ','Yi ','Yok ','Tong ','Lao ','Hay ','Chim ','Hyep ','Chong ','Weng ','Mei ','Sui ','Cheng ','Phay ',
        'Xian ','Shen ','To ','Kun ','Pin ','Nyel ','Han ','Kyeng ','So ','Sep ','Nian ','Tu ','Yong ','Hyo ','Yen ','Ting ',
        'E ','So ','Tun ','Yen ','Cam ','Chey ','Li ','Shui ','Si ','Lwu ','Shui ','Tao ','Tok ','Lao ','Lai ','Lian ',
        'Wei ','Wo ','Yun ','Hwan ','Di ','','Run ','Jian ','Zhang ','Se ','Pwu ','Kwan ','Xing ','Shou ','Shuan ','Ay ',
        'Chuo ','Zhang ','Ayk ','Kong ','Wan ','Ham ','Tuo ','Tong ','Hwu ','Wo ','Ju ','Gan ','Lyang ','Hun ','Ta ','Thak ',
        'Ceng ','Qie ','De ','Kwen ','Chi ','Sek ','Hyo ','Ki ','Kwul ','Guo ','Han ','Lim ','Tang ','Zhou ','Peng ','Ho ',
        'Chang ','Swuk ','Che ','Fang ','Chi ','Lu ','Nyo ','Ju ','To ','Cong ','Lwu ','Zhi ','Peng ','Pi ','Song ','Tian ',
        'Pi ','Tam ','Yek ','Ni ','E ','Lok ','Kem ','Mi ','Ceng ','Ling ','Lyun ','Um ','Swi ','Qu ','Hoy ','Yu ',
        'Nian ','Sim ','Piao ','Swun ','Wa ','Yen ','Lay ','Hon ','Cheng ','Em ','Chen ','Chem ','Myo ','Zhi ','Yin ','Mi ',
        ],
    'x6e':[
        'Ben ','Yuan ','Wen ','Re ','Fei ','Cheng ','Yuan ','Kal ','Cey ','Sep ','Yuan ','Juu ','Lok ','Zi ','Du ','',
        'Jian ','Min ','Pi ','Kei ','Yu ','Yuan ','Shen ','Cham ','Rou ','Hwan ','Ce ','Kam ','Nuan ','Thwu ','Qiu ','Ceng ',
        'Ke ','To ','Feng ','Sa ','Pal ','Ak ','Wa ','Di ','Oy ','On ','Ru ','Sel ','Chuk ','Wi ','Ge ','Hang ',
        'Yan ','Hong ','Sen ','Mi ','Kal ','Mao ','Yeng ','Yen ','Yu ','Hong ','Myo ','Xing ','Mi ','Cay ','Hon ','Nai ',
        'Kui ','Shi ','E ','Pay ','Mi ','Lyen ','Qi ','Qi ','Mei ','Tian ','Cwu ','Wei ','Can ','Tan ','Myen ','Hui ',
        'Mo ','Se ','Ji ','Pwun ','Cen ','Jian ','Ho ','Feng ','Sang ','Yi ','Yin ','Tam ','Sik ','Jie ','Ceng ','Hwang ',
        'Tan ','Yu ','Bi ','Min ','Shi ','Tu ','Sheng ','Yong ','Qu ','Zhong ','','Chwu ','Jiao ','qiu ','In ','Thang ',
        'Long ','Huo ','Wen ','Nam ','Ban ','You ','Quan ','Chui ','Liang ','Chan ','Po ','Chun ','Nie ','Zi ','Wan ','Sup ',
        'Man ','Yeng ','Ratsu ','Kui ','','Jian ','Xu ','Lu ','Gui ','Kay ','','','Pal ','Jin ','Gui ','Tang ',
        'Wen ','Suo ','Yuan ','Lian ','Yao ','Mong ','Cwun ','Sheng ','Hap ','Tai ','Da ','Wa ','Lyu ','Kwu ','Sao ','Myeng ',
        'Zha ','Shi ','Il ','Lun ','Ma ','Pwu ','Wei ','Lyul ','Cai ','Wu ','Kyey ','On ','Qiang ','Ze ','Shi ','So ',
        'Yi ','Cin ','Swu ','Yun ','Xiu ','Un ','Yong ','Hon ','Su ','Su ','Nik ','Ta ','Shi ','Yok ','Wei ','Pan ',
        'Chu ','Ce ','Pang ','Ong ','Chang ','Myel ','He ','Dian ','Ho ','Hwang ','Xi ','Ca ','Chek ','Zhi ','Hyeng ','Fu ',
        'Jie ','Hwal ','Ge ','Cay ','To ','Tung ','Sui ','Bi ','Jiao ','Hoy ','Kon ','Yin ','Gao ','Long ','Zhi ','Yan ',
        'She ','Man ','Ying ','Chun ','Lu ','Lan ','Luan ','','Bin ','Tan ','Yu ','Sou ','Ho ','Phil ','Biao ','Chey ',
        'Jiang ','Kou ','Cham ','Shang ','Cek ','Mil ','Ao ','Lo ','Ho ','Hu ','You ','Chan ','Fan ','Yong ','Kon ','Man ',
        ],
    'x6f':[
        'Qing ','E ','Phyo ','Ji ','Ay ','Jiao ','Chil ','Xi ','Ji ','Lok ','Lu ','Long ','Kun ','Guo ','Cong ','Lwu ',
        'Zhi ','Kay ','Qiang ','Li ','Yen ','Co ','Jiao ','Cong ','Chun ','Tan ','Kwu ','Teng ','Ye ','Xi ','Mi ','Tang ',
        'Mak ','Shang ','Han ','Lyen ','Lan ','Wa ','Li ','Qian ','Feng ','Xuan ','Uy ','Man ','Ci ','Mang ','Kang ','Ta ',
        'Pwul ','Swu ','Chang ','Cang ','Chong ','Xu ','Huan ','Kuo ','Cem ','Yan ','Chuang ','Liao ','Choy ','Ti ','Yang ','Cang ',
        'Cong ','Yeng ','Hong ','Xun ','Shu ','Guan ','Ying ','Xiao ','','','Xu ','Lian ','Zhi ','Wei ','Pi ','Yul ',
        'Jiao ','Pal ','Dang ','Hui ','Kyel ','Wu ','Pa ','Cip ','Pan ','Kyu ','Swu ','Cam ','Cam ','Hup ','Lo ','Sek ',
        'Sun ','Ton ','Hwang ','Min ','Lyun ','Su ','Lyo ','Zhen ','Zhong ','Yi ','Di ','Wan ','Dan ','Tam ','Co ','Sim ',
        'Kwey ','','Shao ','Tu ','Ce ','San ','Hei ','Bi ','San ','Chan ','Can ','Shu ','Tong ','Po ','Lin ','Wei ',
        'Se ','Sap ','Cing ','Jiong ','Cing ','Hua ','Yo ','Lao ','Chel ','Kem ','Cun ','Hoyng ','Si ','Cwu ','Phayng ','Han ',
        'Wun ','Liu ','Hong ','Fu ','Ho ','He ','Xian ','Kan ','San ','Sek ','Iku ','','Lan ','','Yu ','Lum ',
        'Mian ','Co ','Dang ','Han ','Thayk ','Xie ','Yu ','Lyey ','Se ','Xue ','Ling ','Man ','Zi ','Yong ','Hoy ','Chan ',
        'Lian ','Cen ','Ye ','O ','Huan ','Zhen ','Cen ','Man ','Dan ','Tam ','Yi ','Sui ','Pi ','Ju ','Tan ','Qin ',
        'Kyek ','Thak ','Lyem ','Nong ','Guo ','Jin ','Pwun ','Sayk ','Ji ','Swu ','Yey ','Chu ','Ta ','Song ','Ding ','',
        'Zhu ','Lai ','Bin ','Lian ','Mi ','Sup ','Shu ','Mi ','Nyeng ','Ying ','Yeng ','Mong ','Jin ','Qi ','Pi ','Cey ',
        'Ho ','Yu ','Zui ','Wo ','To ','Yin ','Yin ','Dui ','Ci ','Ho ','Jing ','Lam ','Cwun ','Ai ','Pok ','Thak ',
        'Wei ','Pin ','Gu ','Cam ','Yeng ','Hin ','Kuo ','Fei ','','Boku ','Chen ','Wei ','Luo ','Zan ','Lye ','Li ',
        ],
    'x70':[
        'You ','Yang ','Lu ','Si ','Jie ','Hyeng ','Tok ','Wang ','Hui ','Sa ','Pan ','Sin ','Biao ','Chan ','Mo ','Lyu ',
        'Jian ','Phok ','Sayk ','Cing ','Gu ','Pin ','Huo ','Xian ','Lo ','Qin ','Han ','Yeng ','Yung ','Lyek ','Ceng ','So ',
        'Ying ','Sui ','Wei ','Hay ','Huai ','Hao ','Ce ','Lyong ','Loy ','Dui ','Fan ','Hu ','Loy ','','','Yeng ',
        'Mi ','Ji ','Lyem ','Jian ','Ying ','Fen ','Lin ','Ik ','Chem ','Yue ','Chan ','Dai ','Yang ','Jian ','Lan ','Fan ',
        'Shuang ','Yuan ','Zhuo ','Feng ','Sep ','Lei ','Lan ','Cong ','Qu ','Yong ','Qian ','Fa ','Kwan ','Que ','Yem ','Hao ',
        'Hyeng ','Say ','Zan ','Lan ','Yan ','Li ','Mi ','Shan ','Than ','Dang ','Jiao ','Chan ','','Ho ','Pha ','Zhu ',
        'Lan ','Lan ','Nang ','Man ','Luan ','Xun ','Xian ','Yem ','Gan ','Yem ','Yu ','Hwa ','Biao ','Mie ','Guang ','Ceng ',
        'Hoy ','Xiao ','Xiao ','','Hong ','Lyeng ','Zao ','Zhuan ','Kwu ','Zha ','Xie ','Chi ','Cak ','Cay ','Cay ','Can ',
        'Yang ','Ki ','Zhong ','Fen ','Niu ','Kyeng ','Mwun ','Po ','Yi ','Lo ','Chwi ','Pi ','Kai ','Pan ','Yem ','Kai ',
        'Pang ','Mu ','Cho ','Liao ','Gui ','Hang ','Tun ','Guang ','Hun ','Ca ','Kwang ','Guang ','Wei ','Qiang ','','Da ',
        'Xia ','Ceng ','Zhu ','Ke ','So ','Fu ','Ba ','Duo ','Duo ','Ling ','Zhuo ','Hyen ','Ke ','Than ','Pho ','Hyeng ',
        'Pho ','Tai ','Tai ','Pyeng ','Yang ','Tong ','Han ','Cwu ','Cak ','Cem ','Wi ','Shi ','Lian ','Chi ','Huang ','',
        'Hu ','Shuo ','Lan ','Jing ','Jiao ','Xu ','Xing ','Quan ','Lyel ','Hwan ','Yang ','Hyo ','Xiu ','Xian ','Yin ','O ',
        'Zhou ','Yao ','Shi ','Kyey ','Tong ','Xue ','Zai ','Kai ','Hong ','Lak ','Xia ','Zhu ','Hwen ','Cung ','Po ','Yen ',
        'Hui ','Guang ','Zhe ','Hoy ','Kao ','','Fan ','Shao ','Ye ','Hui ','','Tang ','Jin ','Re ','','Xi ',
        'Fu ','Kyeng ','Che ','Pu ','Jing ','Zhuo ','Ting ','Wan ','Hai ','Phayng ','Lang ','Shan ','Hu ','Pong ','Chi ','Rong ',
        ],
    'x71':[
        'Hu ','','Shu ','He ','Hwun ','Ku ','Jue ','Xiao ','Xi ','En ','Han ','Zhuang ','Cwun ','Di ','Xie ','Ji ',
        'Wu ','','Lua ','Han ','Yen ','Hwan ','Men ','Ju ','Chou ','Pay ','Pwun ','Lin ','Hon ','Hun ','Ton ','Xi ',
        'Swi ','Mwu ','Hong ','Ju ','Fu ','Wo ','Cho ','Cong ','Feng ','Ping ','Qiong ','Ruo ','Xi ','Kyeng ','Hun ','Cak ',
        'Yen ','Hyek ','Yi ','Jue ','Yu ','Gang ','Yen ','Pi ','Gu ','','Sheng ','Chang ','So ','','Nam ','Geng ',
        'Wat ','Chen ','He ','Kui ','Zhong ','Duan ','Ha ','Hwi ','Feng ','Lyen ','Hwen ','Xing ','Hwang ','Jiao ','Cen ','Bi ',
        'Yeng ','Ca ','Wi ','Tuan ','Tian ','Huy ','Nan ','Nan ','Chan ','Yen ','Jiong ','Jiong ','Wuk ','Mei ','Sal ','Wei ',
        'Ye ','Xin ','Kyeng ','Rou ','May ','Hwan ','Hwu ','Co ','Oy ','Pen ','Qiu ','Sui ','Yang ','Lie ','Ca ','',
        'Gao ','Gua ','Bao ','Hu ','Yun ','Xia ','','','Bian ','Gou ','Tui ','Tang ','Chao ','Sen ','En ','Bo ',
        'Yep ','Xie ','Xi ','Wu ','Sik ','On ','He ','Hyo ','Huy ','Wun ','Wung ','Nai ','Shan ','','Yao ','Hwun ',
        'Mi ','Lian ','Hyeng ','Wu ','Yong ','Kou ','En ','Qiang ','Liu ','Huy ','Bi ','Phyo ','Zong ','Lu ','Jian ','Swuk ',
        'Sup ','Lou ','Pong ','Sui ','Ik ','Tong ','Jue ','Zong ','Wi ','Hu ','Yi ','Zhi ','O ','Wei ','Liao ','Sen ',
        'Ou ','Yel ','Kyeng ','Man ','','Shang ','Cuan ','Zeng ','Jian ','Huy ','Huy ','Xi ','Yi ','Xiao ','Chi ','Huang ',
        'Chan ','Yep ','Qian ','Yen ','Yan ','Xian ','Qiao ','Zun ','Tung ','Ton ','Shen ','Cho ','Fen ','Si ','Lyo ','Yu ',
        'Lin ','Tong ','So ','Fen ','Pen ','Yen ','Sim ','Lan ','Mei ','Thang ','Yi ','Jing ','Men ','','','Yeng ',
        'Wuk ','Yi ','Xue ','Lan ','Tai ','Co ','Chan ','Swu ','Xi ','Que ','Cong ','Lian ','Hwey ','Chok ','Sep ','Ling ',
        'Wei ','Yi ','Xie ','Zhao ','Hui ','Tatsu ','Nung ','Lan ','Ru ','Huy ','Kao ','Hwun ','Sin ','Chou ','To ','Yo ',
        ],
    'x72':[
        'Hyek ','Lan ','Biao ','Rong ','Li ','Mo ','Phok ','Sel ','Lu ','La ','Ao ','Hwun ','Kwang ','Sak ','','Li ',
        'Lo ','Jue ','Liao ','Yan ','Huy ','Xie ','Long ','Yep ','','Rang ','Yak ','Lan ','Cong ','Jue ','Tong ','Kwan ',
        '','Che ','Mi ','Tang ','Lan ','Chok ','Laam ','Ling ','Chan ','Yu ','Co ','Lam ','Pha ','Cayng ','Pao ','Cheng ',
        'Wen ','Ai ','Wi ','','Jue ','Cak ','Pwu ','Ye ','Pha ','Ta ','Ya ','Hyo ','Zu ','Sang ','I ','Qiang ',
        'Sang ','Ge ','Cang ','Die ','Qiang ','Yong ','Cang ','Phyen ','Phan ','Pan ','Shao ','Cen ','Phay ','Du ','Chuang ','Tou ',
        'Zha ','Bian ','Chep ','Pang ','Pak ','Chuang ','Yu ','','Tok ','A ','Thayng ','Wu ','Ushihen ','Pin ','Jiu ','Mo ',
        'Tuo ','Mo ','Loy ','Ren ','Mang ','Fang ','Mao ','Mok ','Gang ','Mwul ','Yan ','Ge ','Bei ','Si ','Jian ','Ko ',
        'You ','Ge ','Sayng ','Mu ','Ce ','Qian ','Quan ','Quan ','Ca ','Thuk ','Xi ','Mang ','Keng ','Kyen ','Wu ','Gu ',
        'Se ','Li ','Li ','Pou ','Ji ','Gang ','Zhi ','Pwun ','Quan ','Run ','Du ','Ju ','Jia ','Ken ','Feng ','Pian ',
        'Ke ','Ju ','Ho ','Chu ','Xi ','Bei ','Lak ','Jie ','Ma ','San ','Wei ','Li ','Ton ','Tong ','','Jiang ',
        'Gi ','Li ','Tok ','Lie ','Pi ','Piao ','Bao ','Huy ','Chou ','Wei ','Kui ','Chou ','Kyen ','Hyun ','Ba ','Pem ',
        'Qiu ','Ji ','Cai ','Cak ','An ','Hil ','Cang ','Guang ','Ma ','You ','Kang ','Bo ','Hou ','Ya ','Yin ','Huan ',
        'Sang ','Yun ','Kwang ','Niu ','Cek ','Qing ','Zhong ','Mu ','Bei ','Pi ','Ju ','Ni ','Sheng ','Pao ','Ap ','Tuo ',
        'Ho ','Ling ','Pi ','Pi ','Ni ','Ao ','You ','Kwu ','Yue ','Ce ','Dan ','Po ','Gu ','Xian ','Ning ','Huan ',
        'Hen ','Kyo ','Hak ','Zhao ','Ji ','Swun ','Shan ','Ta ','Yung ','Swu ','Tong ','Lao ','Tok ','Xia ','Shi ','Hua ',
        'Zheng ','Yu ','Sun ','Yu ','Phyey ','Mang ','Xi ','Kyen ','Li ','Hyep ','Un ','San ','Lang ','Phay ','Zhi ','Yan ',
        ],
    'x73':[
        'Sha ','Li ','Han ','Xian ','Jing ','Pai ','Fei ','Yao ','Ba ','Ki ','Yey ','Biao ','Yin ','Lai ','Xi ','Jian ',
        'Qiang ','Kun ','Yan ','Kwa ','Zong ','Mi ','Chang ','Uy ','Cey ','Cayng ','Ya ','Mayng ','Si ','Col ','She ','Ryou ',
        'Cen ','Luo ','Ho ','Zong ','Ji ','Oy ','Feng ','Wa ','Wen ','Seng ','Ce ','Myo ','Wei ','Yuan ','Hen ','Tuan ',
        'Ya ','No ','Xie ','Jia ','Hwu ','Bian ','Yu ','Yu ','Mei ','Zha ','Yao ','Sun ','Bo ','Ming ','Hwal ','Wen ',
        'Sou ','Ma ','Yuan ','Ay ','Ok ','Sa ','Hao ','','Yi ','Zhen ','Chuang ','Hao ','Man ','Jing ','Jiang ','Mu ',
        'Cang ','Chan ','O ','Ao ','Hao ','Cui ','Fen ','Kwel ','Phyey ','Bi ','Huang ','Pu ','Lin ','Yu ','Tong ','Yao ',
        'Lyo ','Shuo ','Xiao ','Swu ','Ton ','Xi ','Ge ','Juan ','Tok ','Yey ','Hoy ','Hem ','Hay ','Ta ','Xian ','Hwun ',
        'Yeng ','Pin ','Hoyk ','Nou ','Meng ','Lyep ','Nao ','Kwang ','Swu ','Lu ','Tal ','Hen ','Mi ','Rang ','Huan ','Nao ',
        'Luo ','Hem ','Qi ','Jue ','Hyen ','Miao ','Ca ','Sol ','Lo ','Ok ','Su ','Wang ','Qiu ','Ga ','Ceng ','Le ',
        'Ba ','Ji ','Hong ','Di ','Chen ','Kan ','Kwu ','Wu ','Ki ','Ye ','Yang ','Ma ','Gong ','Wu ','Pwu ','Min ',
        'Kay ','Ya ','Bin ','Bian ','Bang ','Yue ','Kyel ','Yun ','Kak ','Wan ','Jian ','May ','Dan ','Pin ','Wei ','Huan ',
        'Xian ','Qiang ','Lyeng ','Tay ','Yi ','An ','Ping ','Cem ','Fu ','Hyeng ','Xi ','Pha ','Ci ','Gou ','Jia ','Shao ',
        'Pak ','Ci ','Ka ','Ran ','Sheng ','Shen ','I ','Zu ','Ka ','Min ','San ','Liu ','Phil ','Cin ','Zhen ','Kak ',
        'Fa ','Long ','Cin ','Jiao ','Jian ','Li ','Kwang ','Xian ','Zhou ','Kong ','Yan ','Xiu ','Yang ','Hwu ','Lak ','Su ',
        'Cwu ','Qin ','Un ','Swun ','Po ','I ','Hyang ','Yao ','Xia ','Hyeng ','Kyu ','Chwung ','Xu ','Pan ','Phay ','',
        'Dang ','Ei ','Hun ','Wen ','E ','Ceng ','Di ','Mwu ','Wu ','Seng ','Jun ','Mei ','Bei ','Ceng ','Hyen ','Chuo ',
        ],
    'x74':[
        'Han ','Sen ','Yan ','Kwu ','Hyen ','Lang ','Li ','Swu ','Fu ','Lyu ','Ye ','Xi ','Ling ','Li ','Cin ','Lian ',
        'Suo ','Sa ','','Wan ','Dian ','Pin ','Zhan ','Cui ','Min ','Yu ','Ju ','Chim ','Lai ','Wen ','Sheng ','Wei ',
        'Cen ','Swu ','Thak ','Pei ','Cayng ','Ho ','Ki ','E ','Kon ','Chang ','Ki ','Pong ','Wan ','Lu ','Cong ','Kwan ',
        'Yem ','Co ','Pay ','Lim ','Kum ','Pi ','Pha ','Que ','Thak ','Qin ','Pep ','','Qiong ','Du ','Jie ','Hun ',
        'Wu ','Mo ','Mei ','Chwun ','Sen ','Cey ','Seng ','Dai ','Rou ','Min ','Zhen ','Wi ','Ruan ','Huan ','Hay ','Chuan ',
        'Jian ','Zhuan ','Yang ','Lian ','Quan ','Ha ','Duan ','Wen ','Ye ','No ','Ho ','Yeng ','Yu ','Hwang ','Se ','Sul ',
        'Lyu ','','Yong ','Sway ','Yo ','On ','Wu ','Jin ','Cin ','Hyeng ','Ma ','Tao ','Liu ','Tang ','Li ','Lang ',
        'Koy ','Cen ','Chang ','Cha ','Jue ','Zhao ','Yo ','Ai ','Bin ','Tu ','Chang ','Kun ','Zhuan ','Cong ','Kun ','Yi ',
        'Choy ','Cong ','Ki ','Li ','Ying ','Suo ','Kwu ','Sen ','Ao ','Lyen ','Mwun ','Cang ','Yin ','','Ying ','Zhi ',
        'Lu ','Wu ','Deng ','xiu ','Zeng ','Xun ','Qu ','Dang ','Lin ','Liao ','Qiong ','Su ','Hwang ','Koy ','Pak ','Kyeng ',
        'Fan ','Cin ','Liu ','Ki ','','Kyeng ','Ai ','Pyek ','Chan ','Qu ','Co ','Tang ','Jiao ','Gun ','Tan ','Hui ',
        'Hwan ','Se ','Swu ','Tian ','','Ye ','Jin ','Lu ','Bin ','Swu ','Wen ','Zui ','Lan ','Say ','Ji ','Sen ',
        'Ruan ','Huo ','Gai ','Lei ','Du ','Li ','Cil ','Rou ','Li ','Zan ','Kyeng ','Zhe ','Gui ','Sui ','La ','Lyong ',
        'Lu ','Li ','Zan ','Lan ','Yeng ','Mi ','Xiang ','Xi ','Kwan ','Dao ','Chan ','Hwan ','Kwa ','Bo ','Die ','Bao ',
        'Ho ','Zhi ','Phyo ','Phan ','Rang ','Li ','Wa ','Dekaguramu ','Jiang ','Chen ','Fan ','Pen ','Fang ','Dan ','Ong ','Ou ',
        'Deshiguramu ','Miriguramu ','Thon ','Hu ','Ling ','Yi ','Pyeng ','Ca ','Hekutogura ','Juan ','Chang ','Chi ','Sarake ','Dang ','Meng ','Pou ',
        ],
    'x75':[
        'Zhui ','Pyeng ','Bian ','Chwu ','Kyen ','Senchigura ','Ci ','Ying ','Qi ','Xian ','Lou ','Di ','Kwu ','Meng ','Cen ','Peng ',
        'Lin ','Cung ','Wu ','Pyek ','Dan ','Ong ','Ying ','Yan ','Kam ','Dai ','Sim ','Chem ','Chem ','Han ','Sang ','Sayng ',
        'Qing ','Shen ','San ','San ','Rui ','Sayng ','So ','Sen ','Yong ','Shuai ','Lu ','Po ','Yong ','Beng ','Feng ','Nyeng ',
        'Cen ','Yu ','Kap ','Sin ','Zha ','Dian ','Fu ','Nam ','Cen ','Ping ','Ceng ','Hwa ','Ceng ','Kyen ','Zi ','Meng ',
        'Pi ','Qi ','Liu ','Xun ','Liu ','Chang ','Mu ','Kyun ','Fan ','Fu ','Kyeng ','Cen ','Kyey ','Jie ','Kyen ','Oy ',
        'Fu ','Cen ','Mu ','Tap ','Pan ','Jiang ','Wa ','Da ','Nan ','Lyu ','Pwun ','Cin ','Chwuk ','Mwu ','Mu ','Ce ',
        'Cen ','Gai ','Phil ','Da ','Chi ','Lyak ','Hyu ','Lyak ','Pan ','Kesa ','Pen ','Hwa ','Yu ','Yu ','Mwu ','Cwun ',
        'I ','Liu ','Yu ','Die ','Chou ','Hwa ','Tang ','Chuo ','Ki ','Wan ','Kang ','Sheng ','Chang ','Tuan ','Lei ','Ki ',
        'Cha ','Liu ','Jou ','Tuan ','Lin ','Jiang ','Kang ','Cwu ','Pyek ','Die ','Chep ','Phil ','Nie ','Dan ','So ','So ',
        'Zhi ','Uy ','Chuang ','Nai ','Ceng ','Bi ','Jie ','Liao ','Gang ','Hul ','Kwu ','Zhou ','Xia ','San ','Xu ','Nue ',
        'Li ','Yang ','Chen ','Yu ','Pha ','Kay ','Jue ','Zhi ','Xia ','Chwi ','Bi ','Yek ','Li ','Zong ','Chuang ','Feng ',
        'Zhu ','Pho ','Phi ','Kam ','A ','Ca ','Xie ','Qi ','Tal ','Cin ','Fa ','Zhi ','Tong ','Ce ','Cil ','Fei ',
        'Kwu ','Dian ','Ka ','Hyen ','Zha ','Pyeng ','Ni ','Cung ','Yong ','Jing ','Cen ','Chong ','Tong ','I ','Hay ','Wei ',
        'Hui ','Duo ','Yang ','Chi ','Chi ','Hun ','Ya ','Mei ','Twu ','Kyeng ','Xiao ','Thong ','Tu ','Mang ','Pi ','Xiao ',
        'Suan ','Pu ','Li ','Ci ','Cwa ','Duo ','Wu ','Sa ','Lao ','Swu ','Huan ','Xian ','Yi ','Peng ','Zhang ','Guan ',
        'Tam ','Fei ','Ma ','Lim ','Chi ','Ji ','Dian ','An ','Chi ','Pi ','Pi ','Min ','Ko ','Dui ','E ','Wi ',
        ],
    'x76':[
        'E ','Chwi ','Ya ','Zhu ','Cu ','Dan ','Shen ','Cong ','Kyey ','Yu ','Hou ','Phwung ','La ','Yang ','Shen ','Tu ',
        'Yu ','Gua ','Wen ','Huan ','Ku ','Ha ','Yin ','Yi ','Lu ','So ','Jue ','Chi ','Xi ','Guan ','Yi ','On ',
        'Chek ','Chang ','Pan ','Lei ','Lyu ','Chai ','Swu ','Hak ','Dian ','Da ','Pie ','Tan ','Zhang ','Biao ','Shen ','Cok ',
        'La ','Yi ','Zong ','Chwu ','Cang ','Zhai ','Sou ','Suo ','Que ','Diao ','Lou ','Lwu ','Mo ','Jin ','Yin ','Ying ',
        'Huang ','Fu ','Lyo ','Lyung ','Qiao ','Liu ','Lo ','Xian ','Phyey ','Tan ','Yin ','He ','Am ','Ban ','Kan ','Guan ',
        'Guai ','Nong ','Yu ','Wei ','Yi ','Ong ','Pyek ','Lei ','Lye ','Shu ','Dan ','Lin ','Cen ','Lin ','Lai ','Bie ',
        'Ji ','Chi ','Yang ','Xian ','Cel ','Cing ','Mak6','Lyek ','Kwak ','La ','Shaku ','Dian ','Sen ','Yeng ','Un ','Kwu ',
        'Yong ','Than ','Cen ','Luo ','Luan ','Luan ','Bo ','','Kyey ','Po ','Pal ','Tung ','Pal ','Payk ','Payk ','Qie ',
        'Kup ','Co ','Zao ','Mo ','Cek ','Pa ','Kay ','Hwang ','Gui ','Ci ','Ling ','Ko ','Mo ','Ji ','Kyo ','Peng ',
        'Ko ','Ai ','E ','Ho ','Han ','Bi ','Hwan ','Chou ','Qian ','Xi ','Ay ','Hyo ','Ho ','Huang ','Ho ','Ze ',
        'Cui ','Hao ','Xiao ','Ye ','Pha ','Hao ','Jiao ','Ai ','Xing ','Huang ','Li ','Piao ','Hak ','Jiao ','Phi ','Gan ',
        'Pao ','Zhou ','Jun ','Qiu ','Cwun ','Que ','Sa ','Gu ','Kwun ','Jun ','Chwu ','Zha ','Gu ','Zhan ','Du ','Myeng ',
        'Qi ','Ying ','Wu ','Pay ','Zhao ','Zhong ','Pwun ','He ','Yeng ','He ','Ik ','Bo ','Wan ','Hap ','Ang ','Zhan ',
        'Yan ','Jian ','Hap ','Yu ','Hoy ','Fan ','Kay ','Dao ','Pan ','Po ','Qiu ','Seng ','To ','Lu ','Can ','Mayng ',
        'Li ','Cin ','Xu ','Kam ','Pan ','Kwan ','An ','Lo ','Shu ','Zhou ','Thang ','An ','Ko ','Li ','Mok ','Ding ',
        'Gan ','Yu ','Mayng ','Mang ','Cik ','Qi ','Ruan ','Tian ','Sang ','Swun ','Xin ','Hyey ','Pan ','Feng ','Swun ','Min ',
        ],
    'x77':[
        'Ming ','Seng ','Shi ','Yun ','Myen ','Pan ','Fang ','Myo ','Tham ','Mi ','Mo ','Kan ','Hyen ','Ou ','Shi ','Yang ',
        'Zheng ','Yao ','Shen ','Huo ','Da ','Zhen ','Kuang ','Ju ','Shen ','Chi ','Sayng ','May ','Mo ','Zhu ','Cin ','Zhen ',
        'Myen ','Di ','Yuan ','Die ','Yi ','Ca ','Ca ','Chao ','Cap ','Hyen ','Bing ','Mi ','Long ','Sui ','Dong ','Mi ',
        'Die ','Yi ','Er ','Ming ','Swun ','Chi ','Kuang ','Kwen ','Mo ','Zhen ','Co ','Yang ','An ','Mo ','Cwung ','Mai ',
        'Chak ','Zheng ','Mei ','Jun ','Shao ','Han ','Hwan ','Cey ','Cheng ','Cuo ','Juan ','E ','Wan ','Hyen ','Xi ','Kun ',
        'Lai ','Jian ','Sem ','Tian ','Hun ','Wan ','Ling ','Shi ','Qiong ','Lie ','Ay ','Ceng ','Zheng ','Li ','Lai ','Swu ',
        'Kwen ','Swu ','Swu ','Tok ','Bi ','Pi ','Mok ','Hun ','Yey ','Lu ','Yi ','Chep ','Chay ','Zhou ','Yu ','Hun ',
        'Ma ','Xia ','Xing ','Xi ','Gun ','','Chun ','Ken ','Mei ','To ','Hou ','Xuan ','Ti ','Kyu ','Ko ','Yey ',
        'Mao ','Xu ','Fa ','Wen ','Miao ','Chou ','Kui ','Mi ','Weng ','Kou ','Dang ','Cin ','Ke ','Swu ','Hal ','Qiong ',
        'Mao ','Myeng ','Man ','Shui ','Ze ','Zhang ','Yey ','Diao ','Ou ','Mak ','Shun ','Cong ','Lou ','Chi ','Man ','Piao ',
        'Tang ','Ji ','Mong ','','Run ','Pyel ','Xi ','Qiao ','Pu ','Zhu ','Cing ','Shen ','Swun ','Lyo ','Che ','Xian ',
        'Kam ','Ye ','Xu ','Tong ','Mou ','Lin ','Kui ','Xian ','Ye ','Ay ','Hui ','Chem ','Kem ','Ko ','Zhao ','Kwu ',
        'Wei ','Chou ','Sao ','Nyeng ','Xun ','Yao ','Huo ','Mong ','Mian ','Pin ','Mian ','Li ','Kuang ','Hwak ','Xuan ','Mian ',
        'Huo ','Lu ','Meng ','Long ','Guan ','Man ','Xi ','Chok ','Tang ','Kem ','Chok ','Mo ','Kung ','Lin ','Yul ','Shuo ',
        'Ce ','Hwak ','Si ','Uy ','Shen ','Ci ','Hou ','Sin ','Ying ','Kwu ','Zhou ','Jiao ','Cuo ','Tan ','Way ','Kyo ',
        'Cung ','Huo ','Bai ','Sek ','Ding ','Qi ','Ji ','Zi ','Gan ','Wu ','Thak ','Kol ','Kang ','Sek ','Fan ','Kuang ',
        ],
    'x78':[
        'Dang ','Ma ','Sa ','Dan ','Jue ','Li ','Fu ','Min ','Nuo ','Huo ','Kang ','Zhi ','Chey ','Kan ','Jie ','Pwun ',
        'E ','A ','Pi ','Zhe ','Yen ','Sway ','Zhuan ','Che ','Dun ','Pan ','Yan ','','Feng ','Fa ','Mo ','Zha ',
        'Qu ','Yu ','La ','Tuo ','Tuo ','Ci ','Chay ','Chim ','Ai ','Fei ','Mu ','Zhu ','Lip ','Phyem ','Nu ','Ping ',
        'Phayng ','Ling ','Pho ','Le ','Pha ','Bo ','Po ','Shen ','Za ','Nuo ','Lye ','Long ','Tong ','','Li ','Kou ',
        'Chu ','Keng ','Quan ','Cwu ','Kuang ','Kyu ','E ','Nao ','Jia ','Lu ','Wei ','Ai ','Luo ','Ken ','Xing ','Yen ',
        'Tong ','Peng ','Xi ','','Hong ','Shuo ','Xia ','Qiao ','','Wei ','Qiao ','','Kayng ','Cho ','Que ','Chan ',
        'Lang ','Hong ','Yu ','Xiao ','Xia ','Mang ','Long ','Yong ','Cha ','Che ','E ','Lyu ','Kyeng ','Mang ','Hak ','Yen ',
        'Sha ','Kun ','Yu ','','Kaki ','Lu ','Chen ','Jian ','Nue ','Song ','Zhuo ','Keng ','Pwung ','Yan ','Zhui ','Kong ',
        'Ceng ','Ki ','Zong ','Qing ','Lin ','Jun ','Bo ','Ceng ','Min ','Diao ','Jian ','He ','Lok ','Ay ','Sway ','Cak ',
        'Ling ','Pi ','Yin ','Tay ','Wu ','Qi ','Lun ','Wan ','Dian ','Gang ','Bei ','Qi ','Chen ','Ruan ','Yan ','Sel ',
        'Ding ','Du ','Tuo ','Kal ','Yeng ','Bian ','Ke ','Pyek ','Oy ','Sek ','Zhen ','Duan ','Xia ','Thang ','Ti ','Nao ',
        'Peng ','Jian ','Di ','Tan ','Cha ','Seki ','Qi ','','Feng ','Xuan ','Hwak ','Hwak ','Ma ','Gong ','Nyen ','Su ',
        'E ','Ca ','Liu ','Si ','Tang ','Pang ','Hua ','Pi ','Oy ','Sang ','Loy ','Cha ','Zhen ','Xia ','Kyey ','Lyem ',
        'Pan ','Ay ','Yun ','Dui ','Chayk ','Kay ','La ','','Qing ','Gun ','Cen ','Chan ','Qi ','Ao ','Peng ','Lu ',
        'Nyo ','Kan ','Qiang ','Chen ','Yin ','Lei ','Biao ','Cek ','Ma ','Qi ','Choy ','Zong ','Kyeng ','Chuo ','','Ki ',
        'Shan ','Lao ','Qu ','Zeng ','Tung ','Kan ','Xi ','Lin ','Ding ','Dian ','Kwang ','Pan ','Cap ','Kyo ','Di ','Li ',
        ],
    'x79':[
        'Kan ','Cho ','','Zhang ','Qiao ','Dun ','Xian ','Yu ','Zhui ','He ','Huo ','Zhai ','Loy ','Ke ','Cho ','Kup ',
        'Que ','Tang ','Uy ','Jiang ','Pi ','Pi ','Ye ','Pin ','Qi ','Ay ','Kai ','Jian ','Yu ','Ruan ','Meng ','Pao ',
        'Ci ','Bo ','','Mie ','Ca ','Xian ','Kwang ','Loy ','Lei ','Zhi ','Lye ','Lyek ','Pan ','Hwak ','Pao ','Ying ',
        'Li ','Long ','Long ','Mo ','Bo ','Shuang ','Guan ','Lan ','Zan ','Yan ','Si ','Shi ','Lyey ','Reng ','Sa ','Yue ',
        'Sa ','Ki ','Ta ','Ma ','Xie ','Yo ','Chen ','Ki ','Ki ','Ci ','Phayng ','Dui ','Zhong ','','Yi ','Shi ',
        'Wu ','Zhi ','Tiao ','Pwul ','Pwu ','Pi ','Co ','Ci ','Suan ','Mei ','Co ','Ke ','Ho ','Chwuk ','Sin ','Swu ',
        'Sa ','Chai ','Ni ','Lu ','Yu ','Sang ','Wu ','Co ','Phyo ','Zhu ','Gui ','Xia ','Zhi ','Cey ','Gao ','Zhen ',
        'Gao ','Shui ','Jin ','Chen ','Gai ','Kun ','Di ','To ','Huo ','Tao ','Ki ','Gu ','Kwan ','Zui ','Ling ','Lok ',
        'Phwum ','Kum ','Dao ','Zhi ','Lu ','Sen ','Bei ','Zhe ','Hui ','You ','Kyey ','In ','Zi ','Hwa ','Ceng ','Pok ',
        'Yuan ','Wu ','Xian ','Yang ','Cey ','Yi ','Mei ','Si ','Di ','','Zhuo ','Zhen ','Yong ','Cik ','Gao ','Tang ',
        'Si ','Ma ','Ta ','','Xuan ','Qi ','E ','Huy ','Ki ','Si ','Sen ','Tam ','Kuai ','Sui ','Lyey ','Nong ',
        'Ni ','To ','Li ','Yang ','Yak ','Ti ','Zan ','Lei ','Rou ','Wu ','Ong ','Li ','Xie ','Kum ','Hwa ','Tok ',
        'Swu ','Sa ','Ren ','Tok ','Zi ','Cha ','Kan ','Yi ','Xian ','Pyeng ','Nyen ','Chwu ','Qiu ','Chwung ','Fen ','Hao ',
        'Yun ','Kwa ','Cho ','Zhi ','Geng ','Pi ','Ci ','Yu ','Pi ','Ku ','Ban ','Pi ','Ni ','Li ','You ','Co ',
        'Pi ','Ba ','Lyeng ','Mal ','Ching ','Nian ','Cin ','Ang ','Zuo ','Cil ','Ci ','Chwul ','Ke ','Zi ','Huo ','Ji ',
        'Ching ','Tong ','Zhi ','Huo ','He ','Yin ','Zi ','Zhi ','Kal ','Ren ','Du ','I ','Zhu ','Hui ','Nong ','Fu ',
        ],
    'x7a':[
        'Huy ','Ko ','Lang ','Fu ','Ze ','Sey ','Lu ','Kun ','Kan ','Geng ','Cey ','Ceng ','To ','Cho ','Sey ','Ya ',
        'Lun ','Lu ','Gu ','Zuo ','Im ','Zhun ','Bang ','Phay ','Ji ','Cik ','Chi ','Kun ','Lung ','Peng ','Kwa ','Phwum ',
        'Co ','Zu ','Yu ','Su ','Lue ','','Yi ','Sel ','Bian ','Ji ','Fu ','Bi ','Nuo ','Jie ','Cong ','Zong ',
        'Xu ','Ching ','To ','On ','Lian ','Zi ','Wuk ','Cik ','Xu ','Cin ','Zhi ','To ','Ka ','Kyey ','Gao ','Ko ',
        'Kok ','Rong ','Sui ','You ','Ji ','Kang ','Mok ','Shan ','Men ','Chi ','Ji ','Lu ','So ','Cek ','Yeng ','On ',
        'Chwu ','Se ','','Yi ','Huang ','Qie ','Ji ','Swu ','Xiao ','Pu ','Jiao ','Zhuo ','Tong ','Sai ','Lu ','Sui ',
        'Nong ','Sayk ','Yey ','Rang ','Nuo ','Yu ','','Ji ','Tui ','On ','Cheng ','Hwak ','Gong ','Lu ','Biao ','',
        'Yang ','Zhuo ','Li ','Zan ','Hyel ','Al ','Kwu ','Qiong ','Xi ','Kwung ','Kong ','Yu ','Sen ','Ceng ','Yo ','Chen ',
        'Twun ','Tol ','Lo ','Cel ','Chak ','Yo ','Phyem ','Bao ','Yo ','Bing ','Wa ','Zhu ','Jiao ','Qiao ','Diao ','Wu ',
        'Gui ','Yao ','Cil ','Chang ','Yao ','Co ','Kyo ','Chang ','Kwun ','Xiao ','Cheng ','Kwu ','Cuan ','Wo ','Dan ','Kwul ',
        'Kwa ','Zhui ','Xu ','Sol ','','Kui ','Dou ','','Yin ','Wa ','Wa ','Ya ','Yu ','Ju ','Kwung ','Yo ',
        'Yao ','Tiao ','Chao ','Yu ','Tian ','Diao ','Kwu ','Liao ','Xi ','O ','Kyu ','Chang ','Zhao ','Fun ','Kwan ','Lyung ',
        'Cheng ','Cui ','Piao ','Zao ','Chan ','Kyu ','Qiong ','Twu ','Co ','Long ','Cel ','Lip ','Chu ','Dekaritto ','Fou ','Kirorittoru ',
        'Chu ','Hong ','Qi ','Miririttoru ','','Deshiritto ','Shu ','Myo ','Ju ','Cham ','Zhu ','Ling ','Lyong ','Pyeng ','Jing ','Kyeng ',
        'Cang ','Hekutoritto ','Sa ','Cwun ','Hong ','Tong ','Song ','Jing ','Diao ','Yi ','Swu ','Jing ','Qu ','Kal ','Ping ','Tan ',
        'Shao ','Zhuan ','Ceng ','Deng ','Cui ','Huai ','Kyeng ','Kan ','Kyeng ','Cwuk ','Chwuk ','Le ','Peng ','Wu ','Chi ','Kan ',
        ],
    'x7b':[
        'Mang ','Zhu ','Utsubo ','Du ','Ji ','Xiao ','Pha ','Suan ','Kup ','Zhen ','Co ','Swun ','A ','Zhui ','Yuan ','Hol ',
        'Gang ','So ','Kum ','Pi ','Bi ','Jian ','Yi ','Dong ','Cem ','Sayng ','Xia ','Cek ','Zhu ','Na ','Thay ','Gu ',
        'Lip ','Qie ','Min ','Bao ','Tiao ','Sa ','Pwu ','Chayk ','Pwun ','Pei ','Tal ','Zi ','Cey ','Lyeng ','Ze ','No ',
        'Fu ','Gou ','Fan ','Ka ','Ge ','Pem ','Shi ','Mao ','Po ','Sey ','Jian ','Kong ','Long ','Souke ','Bian ','Luo ',
        'Gui ','Qu ','Chi ','Yin ','Yao ','Sen ','Phil ','Qiong ','Kwal ','Tung ','Jiao ','Kun ','Cen ','Swun ','Ru ','Pel ',
        'Kwang ','Chwuk ','Thong ','Kyey ','Tap ','Xing ','Chayk ','Zhong ','Kou ','Lai ','Bi ','Shai ','Dang ','Zheng ','Ce ','Pwu ',
        'Kyun ','Tu ','Pa ','Li ','Lang ','Ke ','Kwan ','Kyen ','Han ','Thong ','Xia ','Zhi ','Seng ','Suan ','Se ','Zhu ',
        'Zuo ','So ','Shao ','Ceng ','Ce ','Yen ','Gao ','Kuai ','Gan ','Chou ','Kyou ','Gang ','Yun ','O ','Qian ','So ',
        'Jian ','Pu ','Lai ','Zou ','Bi ','Bi ','Bi ','Kay ','Chi ','Guai ','Yu ','Cen ','Zhao ','Ko ','Ho ','Cayng ',
        'Jing ','Sha ','Chwu ','Lu ','Pak ','Ki ','Lin ','San ','Jun ','Pok ','Cha ','Gu ','Kong ','Kyem ','Quan ','Jun ',
        'Chwu ','Kwan ','Yuan ','Ce ','Ju ','Bo ','Ze ','Qie ','Tuo ','Luo ','Tan ','Xiao ','Ruo ','Cen ','','Bian ',
        'Sun ','Sang ','Xian ','Ping ','Cam ','Sheng ','Hu ','Shi ','Ce ','Yue ','Chun ','Lu ','Wu ','Dong ','So ','Ji ',
        'Cel ','Hwang ','Xing ','Mei ','Pem ','Chui ','Cen ','Phyen ','Feng ','Chwuk ','Hong ','Hyep ','Hwu ','Qiu ','Miao ','Qian ',
        '','Kui ','Sik ','Lou ','Wun ','He ','Tang ','Yue ','Chou ','Ko ','Fei ','Yak ','Zheng ','Kwu ','Nie ','Qian ',
        'So ','Chan ','Gong ','Pang ','Tok ','Lyul ','Pi ','Zhuo ','Chu ','Sa ','Ci ','Zhu ','Qiang ','Long ','Lan ','Jian ',
        'Bu ','Li ','Hui ','Phil ','Di ','Cong ','Yan ','Pong ','Sen ','Zhuan ','Pai ','Piao ','Dou ','Yu ','Myel ','Zhuan ',
        ],
    'x7c':[
        'Chayk ','Xi ','Guo ','Yi ','Hu ','Chan ','Kou ','Cok ','Ping ','Chwu ','Ji ','Kwey ','Su ','Lou ','Zha ','Lok ',
        'Nian ','Sa ','Chan ','Sen ','Sa ','Le ','Duan ','Yana ','So ','Bo ','Mi ','Si ','Dang ','Liao ','Tan ','Cem ',
        'Po ','Kan ','Min ','Kui ','Dai ','Jiao ','Deng ','Hwang ','Sun ','Lao ','Cam ','So ','Lu ','Shi ','Zan ','',
        'Pai ','Hata ','Pai ','Gan ','Ju ','Du ','Lu ','Chem ','Pha ','Dang ','Sai ','Ke ','Long ','Chem ','Lyem ','Pwu ',
        'Zhou ','Lai ','','Lam ','Kui ','Yu ','Yue ','Hao ','Zhen ','Tai ','Ti ','Mi ','Cwu ','Cek ','','Hata ',
        'Tung ','Zhuan ','Cwu ','Fan ','Swu ','Zhou ','Sen ','Zhuo ','Teng ','Lu ','Lu ','Cen ','Thak ','Ying ','Yu ','Loy ',
        'Long ','Shinshi ','Lian ','Lan ','Chem ','Yak ','Zhong ','Ke ','Lian ','Pyen ','Duan ','Zuan ','Li ','Si ','Luo ','Ying ',
        'Yue ','Zhuo ','Yu ','Mi ','Di ','Fan ','Shen ','Zhe ','Shen ','Nu ','Xie ','Lyu ','Xian ','Zi ','In ','Cun ',
        '','Chen ','Kume ','Pi ','Ban ','Wu ','Sha ','Kang ','Rou ','Pwun ','Bi ','Cui ','','Mo ','Chi ','Ta ',
        'Ro ','Ba ','Lip ','Gan ','Ju ','Pak ','Mo ','Co ','Cem ','Zhou ','Li ','Su ','Tiao ','Li ','Xi ','Sok ',
        'Hong ','Tong ','Ca ','Ce ','Wel ','Cwuk ','Lin ','Cang ','Payk ','','Fen ','Ji ','','Sukumo ','Lyang ','Xian ',
        'Fu ','Lyang ','Chan ','Kayng ','Li ','Wel ','Lu ','Ju ','Qi ','Swu ','Bai ','Zhang ','Lin ','Cong ','Ceng ','Guo ',
        'Kouji ','San ','San ','Tang ','Bian ','Yu ','Myen ','Hou ','Xu ','Zong ','Ho ','Jian ','Zan ','Ci ','Li ','Xie ',
        'Fu ','Ni ','Bei ','Gu ','Xiu ','Ko ','Tang ','Kwu ','Sukumo ','Co ','Cang ','Tang ','Mi ','Sam ','Pwun ','Co ',
        'Kang ','Jiang ','Mo ','San ','Can ','Na ','Xi ','Lyang ','Jiang ','Kuai ','Bo ','Huan ','','Zong ','Xian ','Na ',
        'Tan ','Nie ','Lye ','Zuo ','Cek ','Nie ','Co ','Lan ','Sa ','Si ','Kyu ','Kyey ','Gong ','Zheng ','Kyu ','You ',
        ],
    'x7d':[
        'Ki ','Cha ','Cwu ','Swun ','Yak ','Hong ','Wu ','Hul ','Hwan ','Ren ','Mwun ','Mwun ','Qiu ','Nap ','Zi ','Tou ',
        'Nyu ','Fou ','Jie ','Se ','Swun ','Pi ','Yin ','Sa ','Koyng ','Ci ','Kup ','Pwun ','Wun ','Ren ','Dan ','Jin ',
        'So ','Pang ','Sayk ','Cui ','Jiu ','Zha ','Ha ','Jin ','Fu ','Zhi ','Ci ','Ca ','Cwu ','Hong ','Chal ','Lwu ',
        'Sey ','Pwul ','Sel ','Sin ','Bei ','Ce ','Qu ','Ling ','Zhu ','So ','Kam ','Yang ','Fu ','Tuo ','Zhen ','Dai ',
        'Chu ','Shi ','Cong ','Hyen ','Co ','Kyeng ','Pan ','Ju ','Mo ','Swul ','Zui ','Kou ','Kyeng ','Im ','Heng ','Xie ',
        'Kyel ','Zhu ','Chou ','Gua ','Bai ','Cel ','Kwang ','Hu ','Ci ','Hwan ','Geng ','Co ','Hyel ','Ku ','Kyo ','Quan ',
        'Gai ','Lak ','Hyen ','Pyeng ','Xian ','Fu ','Kup ','Tong ','Yung ','Co ','In ','Lei ','Xie ','Quan ','Se ','Gai ',
        'Cil ','Thong ','Sa ','Kang ','Xiang ','Hui ','Cel ','Zhi ','Jian ','Kyen ','Chi ','Mian ','Zhen ','Lu ','Cheng ','Kwu ',
        'Shu ','Bang ','Tong ','Cho ','Wan ','Qin ','Kyeng ','Xiu ','Ti ','Xiu ','Xie ','Hong ','Xi ','Fu ','Ceng ','Yu ',
        'Dui ','Kun ','Fu ','Kyeng ','Hu ','Zhi ','Yan ','Jiong ','Pong ','Kyey ','Sok ','Kase ','Cong ','Lin ','Duo ','Li ',
        'Lok ','Liang ','Cwu ','Kwen ','Shao ','Ki ','Ki ','Cwun ','Qi ','Wen ','Qian ','Sen ','Swu ','Yu ','Kyey ','Tao ',
        'Kwan ','Kang ','Mang ','Pwung ','Chel ','Chay ','Guo ','Cui ','Lyun ','Liu ','Ki ','Than ','Bei ','Cak ','Lung ','Myen ',
        'Qi ','Qie ','Tan ','Zong ','Kon ','Zou ','Yi ','Chi ','Xing ','Liang ','Kin ','Pi ','Yu ','Min ','Yu ','Chong ',
        'Fan ','Lok ','Se ','Ying ','Zhang ','Kasuri ','Se ','Sang ','Ham ','Ke ','Sen ','Ruan ','Myen ','Cip ','Tan ','Zhong ',
        'Chey ','Min ','Miao ','Yen ','Xie ','Bao ','Si ','Qiu ','Phyen ','Wan ','Geng ','Cong ','Myen ','Wei ','Fu ','Wi ',
        'Yu ','Gou ','Myo ','Xie ','Lyen ','Zong ','Phyen ','Yun ','Yin ','Cey ','Gua ','Chi ','On ','Cheng ','Chan ','Dai ',
        ],
    'x7e':[
        'Xia ','Yen ','Chong ','Xu ','Jou ','Odoshi ','Geng ','Sen ','Yeng ','Cin ','Ayk ','Chwu ','Ni ','Bang ','Gu ','Pan ',
        'Chwu ','Kyem ','Cuo ','Quan ','Shuang ','On ','Xia ','Choy ','Kyey ','Rong ','Tao ','Pak ','Yun ','Cin ','Ho ','Yo ',
        'Kok ','Cay ','Tung ','Hyen ','Su ','Zhen ','Cong ','Tao ','Kou ','Cai ','Bi ','Pong ','Cu ','Li ','Chwuk ','Yen ',
        'Xi ','Cong ','Lyu ','Kyen ','Kyen ','Man ','Zhi ','Lwu ','Mo ','Phyo ','Lian ','Mi ','Xuan ','Chong ','Cek ','Shan ',
        'Sui ','Pen ','Shuai ','Pwung ','Yey ','So ','Mwu ','Yo ','Kang ','Hun ','Sem ','Kyey ','Zung ','Swu ','Ran ','Xuan ',
        'Sey ','Qiao ','Cung ','Zuo ','Cik ','Sen ','San ','Lin ','Yu ','Pen ','Lyo ','Chuo ','Zun ','Jian ','Yo ','Chan ',
        'Rui ','Swu ','Kwey ','Hua ','Chan ','Xi ','Kang ','Un ','Da ','Sung ','Hoy ','Kyey ','Se ','Kyen ','Jiang ','Hyen ',
        'Co ','Cong ','Jie ','Jiao ','Bo ','Chan ','Ek ','Nao ','Sui ','Yek ','Shai ','Xu ','Kyey ','Pin ','Kyen ','Lan ',
        'Pu ','Hwun ','Chan ','Qi ','Peng ','Li ','Mo ','Loy ','Hil ','Chan ','Kwang ','You ','Sok ','Lyu ','Xian ','Cen ',
        'Kou ','Lu ','Chan ','Yeng ','Cay ','Xiang ','Sem ','Zui ','Chan ','Luo ','Xi ','To ','Lam ','Lei ','Lian ','Si ',
        'Jiu ','Yu ','Hong ','Zhou ','Xian ','He ','Yue ','Ji ','Wan ','Kuang ','Ji ','Ren ','Wei ','Yun ','Koyng ','Chun ',
        'Pi ','Sha ','Gang ','Na ','Ren ','Zong ','Lun ','Fen ','Zhi ','Wen ','Fang ','Ce ','Yin ','Niu ','Shu ','Xian ',
        'Gan ','Xie ','Fu ','Lian ','Zu ','Shen ','Xi ','Zhi ','Zhong ','Zhou ','Ban ','Fu ','Zhuo ','Shao ','Yi ','Jing ',
        'Dai ','Bang ','Rong ','Jie ','Ku ','Rao ','Die ','Heng ','Hui ','Gei ','Xuan ','Jiang ','Luo ','Jue ','Jiao ','Tong ',
        'Geng ','Xiao ','Juan ','Xiu ','Xi ','Sui ','Tao ','Ji ','Ti ','Ji ','Xu ','Ling ','Ying ','Xu ','Qi ','Fei ',
        'Chuo ','Zhang ','Gun ','Sheng ','Wei ','Mian ','Shou ','Beng ','Chou ','Tao ','Liu ','Quan ','Zong ','Zhan ','Wan ','Lu ',
        ],
    'x7f':[
        'Zhui ','Zi ','Ke ','Xiang ','Jian ','Mian ','Lan ','Ti ','Miao ','Qi ','On ','Hui ','Si ','Duo ','Duan ','Bian ',
        'Sen ','Gou ','Zhui ','Huan ','Di ','Lu ','Bian ','Min ','Yuan ','Jin ','Fu ','Ru ','Zhen ','Feng ','Shuai ','Gao ',
        'Chan ','Li ','Yi ','Jian ','Bin ','Piao ','Man ','Lei ','Ying ','Suo ','Mou ','Sao ','Xie ','Liao ','Shan ','Zeng ',
        'Jiang ','Qian ','Zao ','Huan ','Jiao ','Zuan ','Pwu ','Sa ','Hang ','Fou ','Kyel ','Fou ','Ketsu ','Bo ','Pyeng ','Hang ',
        'Diu6','Gang ','Ying ','Ayng ','Kyeng ','Ha ','Guan ','Cwun ','Tan ','Cang ','Qi ','Ong ','Ayng ','Loy ','Tam ','Lu ',
        'Kwan ','Wang ','Wang ','Gang ','Mang ','Han ','','Luo ','Pwu ','Mi ','Fa ','Gu ','Zhu ','Ce ','Mao ','Ko ',
        'Min ','Kang ','Ba ','Kway ','Ti ','Juan ','Pwu ','Lin ','Em ','Zhao ','Coy ','Kway ','Zhuo ','Yu ','Chi ','An ',
        'Pel ','Nan ','Se ','Si ','Pi ','May ','Liu ','Pha ','Pel ','Li ','Chao ','Wei ','Phil ','Kyey ','Cung ','Tong ',
        'Liu ','Ji ','Kyen ','Mi ','Zhao ','La ','Pi ','Ki ','Ki ','Luan ','Yang ','Mi ','Kang ','Ta ','Mi ','Yang ',
        'You ','You ','Fen ','Ba ','Ko ','Yang ','Ko ','Kang ','Cang ','Gao ','Lyeng ','Yi ','Zhu ','Ce ','Swu ','Qian ',
        'Yi ','Sen ','Rong ','Qun ','Kwun ','Qiang ','Huan ','Suo ','Sen ','Uy ','You ','Kang ','Xian ','Yu ','Geng ','Kal ',
        'Tang ','Yuan ','Huy ','Fan ','Shan ','Fen ','Cen ','Lian ','Li ','Kayng ','Nou ','Qiang ','Chan ','Wu ','Gong ','Yi ',
        'Chong ','Ong ','Fen ','Hong ','Chi ','Si ','Cui ','Fu ','Xia ','Pen ','Ik ','La ','Ik ','Pi ','Lyeng ','Liu ',
        'Zhi ','Qu ','Sup ','Xie ','Sang ','Hup ','Hup ','Qi ','Qiao ','Hui ','Hwi ','So ','Se ','Hong ','Jiang ','Cek ',
        'Chwi ','Pi ','Tao ','Sap ','Si ','Zhu ','Cen ','Xuan ','Shi ','Phyen ','Zong ','Wan ','Hwi ','Hou ','Hayk ','He ',
        'Han ','Ko ','Piao ','Yey ','Lian ','Qu ','','Lin ','Pen ','Kyo ','Ko ','Pen ','Ik ','Hui ','Hyen ','Dao ',
        ],
    'x80':[
        'Yo ','Lo ','','Ko ','Mo ','Ca ','Ki ','Kwu ','Kwu ','Kwu ','Die ','Die ','I ','Shua ','Ruan ','Er ',
        'Nay ','Tan ','Loy ','Ting ','Ca ','Kyeng ','Cho ','Mo ','Wun ','Pha ','Pi ','Chi ','Si ','Chu ','Ka ','Ju ',
        'He ','Se ','Lao ','Lun ','Ji ','Tang ','Wu ','Lou ','Nwu ','Jiang ','Pang ','Ze ','Lwu ','Ki ','Lao ','Huo ',
        'Wu ','Mo ','Huai ','I ','Zhe ','Ting ','Ya ','Da ','Song ','Qin ','Yun ','Chi ','Dan ','Tham ','Hong ','Kyeng ',
        'Zhi ','','Nie ','Tam ','Zhen ','Che ','Lyeng ','Zheng ','You ','Wa ','Lyo ','Long ','Zhi ','Ning ','Tiao ','Er ',
        'Ya ','Die ','Kwal ','','Lian ','Ho ','Seng ','Lie ','Ping ','Jing ','Chwi ','Bi ','Di ','Guo ','Mwun ','Xu ',
        'Ping ','Cong ','Shikato ','','Ting ','Yu ','Cong ','Kui ','Ren ','Kui ','Cong ','Lyen ','Weng ','Kui ','Lyen ','Lyen ',
        'Chong ','O ','Seng ','Yong ','Cheng ','Oy ','Sep ','Cik ','Dan ','Ning ','qie ','Ji ','Cheng ','Cheng ','Long ','Yul ',
        'Yu ','Zhao ','Si ','Su ','I ','Swuk ','Sa ','Co ','Zhao ','Yuk ','Yi ','Luk ','Ki ','Qiu ','Ken ','Cao ',
        'Ge ','Di ','Huan ','Hwang ','Yi ','Ren ','Cho ','Ru ','Cwu ','Yuan ','Twu ','Hang ','Rong ','Kan ','Cha ','Wo ',
        'Chang ','Ko ','Ci ','Han ','Fu ','Pi ','Pwun ','Pei ','Pang ','Kyen ','Pang ','Swun ','You ','Nwul ','Hang ','Kung ',
        'Ran ','Koyng ','Yuk ','Wen ','Hyo ','Ki ','Pi ','Qian ','Xi ','Xi ','Phyey ','Ken ','Jing ','Tai ','Shen ','Zhong ',
        'Zhang ','Xie ','Shen ','Wi ','Cwu ','Die ','Tan ','Fei ','Ba ','Bo ','Kwu ','Tian ','Pay ','Gua ','Thay ','Zi ',
        'Ku ','Zhi ','Ni ','Ping ','Zi ','Pwu ','Pan ','Zhen ','Xian ','Co ','Pay ','Kap ','Sheng ','Zhi ','Pho ','Mu ',
        'Ke ','Ho ','Ke ','Yi ','Yun ','Se ','Yang ','Long ','Dong ','Ka ','Lu ','Jing ','Nu ','Yan ','Pang ','Kwa ',
        'Yi ','Kwang ','Hai ','Ge ','Tong ','Zhi ','Xiao ','Hyung ','Hyung ','Er ','E ','Xing ','Pyen ','Nung ','Ca ','',
        ],
    'x81':[
        'Cheng ','Tiao ','Ci ','Cui ','Mei ','Hyep ','Chwi ','Hyep ','Mayk ','Mayk ','Chek ','Kyou ','Nin ','Kuai ','Sa ','Zang ',
        'Qi ','Nao ','Mi ','Nong ','Luan ','Wan ','Pal ','Wen ','Wan ','Qiu ','Kak ','Kyeng ','Rou ','Heng ','Cuo ','Lie ',
        'Shan ','Ting ','Mei ','Swun ','Sin ','Qian ','Te ','Choy ','Cu ','Swu ','Xin ','Thal ','Pao ','Cheng ','Nei ','Pho ',
        'Twu ','Thal ','Niao ','Noy ','Pi ','Ko ','Gua ','Li ','Lian ','Chang ','Swu ','Jie ','Liang ','Zhou ','Pi ','Biao ',
        'Lun ','Pyen ','Guo ','Kui ','Chui ','Dan ','Cen ','Nei ','Jing ','Jie ','Sek ','Ayk ','Yan ','Ren ','Sin ','Chuo ',
        'Pwu ','Pwu ','Ke ','Pi ','Kang ','Wan ','Dong ','Pi ','Guo ','Zong ','Ding ','Wu ','Mei ','Ruan ','Zhuan ','Cil ',
        'Cwu ','Gua ','Ou ','Di ','Am ','Seng ','Noy ','Yu ','Chuan ','Nan ','Yun ','Cong ','Rou ','Ak ','Sai ','Tu ',
        'Yo ','Ken ','Wei ','Jiao ','Yu ','Jia ','Tan ','Phik ','Cang ','Pok ','Sen ','Ni ','Mian ','Wa ','Tung ','Thoy ',
        'Pang ','Qian ','Lye ','Ol ','Swu ','Tang ','So ','Zhui ','Kyek ','Yi ','Pak ','Lyo ','Ji ','Pi ','Xie ','Ko ',
        'Lu ','Bin ','','Chang ','Lu ','Guo ','Pang ','Chuai ','Phyo ','Jiang ','Pwu ','Tang ','Mak ','Sul ','Cen ','Lu ',
        'Kyo ','Ying ','Lu ','Cil ','Tara ','Chun ','Lian ','Tong ','Phayng ','Ni ','Zha ','Liao ','Cui ','Gui ','Xiao ','Teng ',
        'Pen ','Zhi ','Jiao ','Sen ','Mwu ','Chwey ','Run ','Xiang ','Swu ','Pwun ','Ung ','Dan ','Zhua ','Tam ','Hoy ','Nong ',
        'Twun ','Lian ','Pi ','Yong ','Jue ','Chu ','Ek ','Juan ','La ','Lian ','Co ','Tun ','Gu ','Cey ','Cui ','Pin ',
        'Xun ','No ','Huo ','Cang ','Xian ','Biao ','Xing ','Kuan ','Lap ','Yen ','Lye ','Huo ','Zang ','La ','Qu ','Cang ',
        'Lyen ','Ni ','Zang ','Sin ','Qian ','Wa ','Guang ','Cang ','Lim ','Guang ','Ca ','Jiao ','El ','Chwi ','Ji ','Gao ',
        'Chou ','Mian ','Nie ','Ci ','Chi ','Ge ','Chen ','Die ','Zhi ','Xiu ','Tay ','Cin ','Kwu ','Xian ','Yu ','Cha ',
        ],
    'x82':[
        'Yao ','Ye ','Yong ','Sek ','Sek ','Kwu ','Yu ','Ye ','Hung ','Ju ','Kwu ','Xin ','Sel ','Sa ','Sha ','Jiu ',
        'Ci ','Tan ','Se ','Shi ','Tian ','Dan ','Pho ','Pu ','Kwan ','Hua ','Tan ','Chen ','Swun ','Xia ','Mwu ','Cwu ',
        'Dao ','Kang ','Shan ','Yi ','','Pa ','Tai ','Fan ','Ban ','Chuan ','Hang ','Pang ','Pan ','Que ','Ro ','Zhong ',
        'Jian ','Cang ','Ling ','Chwuk ','Ze ','Tha ','Pak ','Hyen ','Ka ','Sen ','Xia ','Lu ','Hong ','Pang ','Xi ','',
        'Pwu ','Zao ','Feng ','Li ','Shao ','Ye ','Lang ','Ceng ','','Wei ','Bo ','Meng ','Nian ','Ke ','Huang ','Shou ',
        'Zong ','Phyen ','Mao ','Die ','Dou6','Bang ','Cha ','Yi ','So ','Chang ','Co ','Lou ','Dai ','Sori ','Yao ','Tong ',
        'Tou ','Dang ','Tan ','Lu ','Uy ','Jie ','Ham ','Huo ','Mong ','Qi ','Lo ','Lo ','Chan ','Shuang ','Kan ','Lyang ',
        'Jian ','Kan ','Sayk ','Yan ','Pwul ','Ping ','Yem ','Yem ','Cho ','','Yi ','Le ','Ting ','Qiu ','Ay ','Nai ',
        'Tiao ','Jiao ','Jie ','Peng ','Wan ','Yi ','Chai ','Mian ','Mi ','Gan ','Chen ','Wu ','Yu ','Cak ','Kwung ','Tu ',
        'Xia ','Qi ','Mang ','Zi ','Hwey ','Sui ','Zhi ','Xiang ','Pi ','Pwu ','Twun ','Wei ','Wu ','Ci ','Qi ','Sam ',
        'Wen ','Kem ','In ','Pwu ','Kou ','Kay ','Ho ','Se ','Kup ','Kum ','Ki ','Wen ','Pwun ','Pha ','Yey ','Sim ',
        'Ki ','Hwa ','Hua ','Pang ','Wu ','Jue ','Gou ','Ci ','Wun ','Kun ','Ao ','Chwu ','Mo ','A ','Pi ','Ing ',
        'Hang ','Cong ','Yin ','You ','Bian ','Yey ','Susa ','Wei ','Li ','Pi ','E ','Xian ','Chang ','Cang ','Meng ','Su ',
        'Yi ','Wen ','Yem ','Lyeng ','Thay ','Cho ','Di ','Myo ','Qiong ','Li ','Yong ','Ka ','Mok ','Pei ','Pho ','Kwu ',
        'Min ','I ','Yi ','Ke ','Pi ','Yak ','Ko ','Ce ','Ni ','Bo ','Bing ','Cem ','Qiu ','Yao ','Xian ','Pwun ',
        'Hong ','Yeng ','Zha ','Tong ','Ce ','Die ','Nie ','Gan ','Hu ','Phyeng ','May ','Pwu ','Sheng ','Ko ','Phil ','Mi ',
        ],
    'x83':[
        'Pwul ','Cwul ','Mwu ','Pem ','Ka ','Mo ','Mao ','Ba ','Ca ','Mal ','Zi ','Di ','Chi ','Ji ','Jing ','Long ',
        '','Niao ','','Xue ','Ying ','Qiong ','Ge ','Myeng ','Li ','Rong ','Yin ','Kan ','Chen ','Chay ','Chen ','Yu ',
        'Xiu ','Zi ','Lie ','O ','Ji ','Gui ','Ce ','Chong ','Ca ','Gou ','Kwang ','Mang ','Si ','Jiao ','Jiao ','Pok ',
        'Yu ','Swu ','Ca ','Kang ','Hoy ','In ','Ta ','Fa ','Yong ','Ye ','Chong ','Mang ','Tong ','Zhong ','','Zhu ',
        'Swun ','Huan ','Kua ','Cen ','Gai ','Da ','Hyeng ','Hayng ','Chuan ','Cho ','Hyeng ','Er ','An ','Shou ','Chi ','Im ',
        'Chen ','Cey ','Hwang ','Ping ','Li ','Jin ','Lao ','Shu ','Cang ','Da ','Jia ','Rao ','Bi ','Ze ','Qiao ','Hui ',
        'Qi ','Dang ','','Rong ','Hun ','Ying ','Luo ','Ying ','Xun ','Jin ','Sun ','Yin ','Mai ','Hong ','Zhou ','Yao ',
        'Du ','Wei ','Chu ','Twu ','Fu ','Ren ','Yin ','Ha ','Bi ','Bu ','Yun ','Cek ','Tu ','Sui ','Sui ','Cheng ',
        'Chen ','Wu ','Bie ','Xi ','Geng ','Li ','Fu ','Zhu ','Mo ','Li ','Cang ','Ji ','Duo ','Qiu ','Sa ','Suo ',
        'Chen ','Feng ','Ke ','May ','Meng ','Xing ','Kyeng ','Che ','Sin ','Jun ','Yen ','Ceng ','Diao ','Cwa ','Kwan ','Ham ',
        'Yu ','Cuo ','Hyep ','Wang ','Chen ','Niu ','Shao ','Xian ','Lang ','Pwu ','A ','Mak ','Wen ','Jie ','Nan ','Mu ',
        'Kan ','Lay ','Lian ','Shi ','Wo ','To ','Lian ','Huo ','You ','Ying ','Ying ','Nuc ','Chun ','Mang ','Mang ','Ca ',
        'Wan ','Cheng ','Cek ','Qu ','Dong ','Kwan ','Zou ','Gu ','La ','Lok ','Kwuk ','Mi ','Kyun ','Nie ','Kun ','He ',
        'Pu ','Chi ','Gao ','Kwa ','Pok ','Lun ','Chang ','Chou ','Swung ','Chui ','Zhan ','Men ','Chay ','Ba ','Li ','To ',
        'Pha ','Ham ','Bao ','Qin ','Juan ','Xi ','Qin ','Di ','Jie ','Po ','Dang ','Kun ','Zhao ','Tai ','Geng ','Hwa ',
        'Ko ','Lung ','Pi ','Jin ','Am ','Wang ','Pong ','Zhou ','Yan ','Ce ','Jian ','Lin ','Tan ','Swu ','Tian ','Dao ',
        ],
    'x84':[
        'Hu ','Qi ','He ','Chwey ','To ','Chwun ','Pi ','Cang ','Huan ','Fei ','Lay ','Che ','Mayng ','Phyeng ','Wi ','Dan ',
        'Sha ','Huan ','Yan ','Yi ','Tiao ','Qi ','Wan ','Ce ','Nai ','Kutabireru ','Tuo ','Jiu ','Tie ','Luo ','','',
        'Meng ','','Yaji ','','Ying ','Ying ','Ying ','Xiao ','Sa ','Chwu ','Ke ','Xiang ','Man ','Yu ','Yu ','Fu ',
        'Lian ','Hwen ','Yuan ','Nan ','Ze ','Wa ','Chun ','Xiao ','Yu ','Phyen ','Mao ','An ','Ak ','Lak ','Ying ','Huo ',
        'Gua ','Jiang ','Mian ','Zuo ','Zuo ','Ju ','Po ','Rou ','Xi ','Yep ','Am ','Qu ','Jian ','Fu ','Lu ','Jing ',
        'Pen ','Phwung ','Hong ','Hong ','Hou ','Yan ','Tu ','Ce ','Zi ','Xiang ','Sim ','Kal ','Jie ','Jing ','Mi ','Huang ',
        'Shen ','Pho ','Gai ','Tong ','Zhou ','Qian ','Wi ','Bo ','Wei ','Pha ','Kyey ','Ho ','Cang ','Ka ','Duan ','Yak ',
        'Jun ','Chong ','Quan ','Wi ','Zhen ','Kyu ','Ting ','Hwun ','Xi ','Shi ','Cup ','Lan ','Zong ','Yao ','Yuan ','Mei ',
        'Yun ','Shu ','Chey ','Zhuan ','Guan ','Sukumo ','Xue ','Chan ','Kai ','Kui ','','Cang ','Lou ','Wi ','Pai ','',
        'Swu ','Yin ','Shi ','Chun ','Si ','Yun ','Zhen ','Lang ','Nu ','Mong ','He ','Que ','San ','Yuan ','Li ','Kwu ',
        'Xi ','Pang ','Chu ','Xu ','Tu ','Liu ','Wo ','Zhen ','Chen ','Zu ','Po ','Cuo ','Yuan ','Chwu ','Yu ','Koy ',
        'Pan ','Pu ','Pho ','Na ','Sak ','Xi ','Fen ','Yun ','Cung ','Kyem ','Cil ','Yak ','Chang ','En ','Mi ','Ho ',
        'So ','Cin ','Myeng ','Huo ','Chwuk ','Liu ','Sek ','Gu ','Lang ','Yong ','Ong ','Kay ','Cuo ','Si ','Tang ','Luo ',
        'Yok ','Sa ','Xian ','Pay ','Yao ','Gui ','Pi ','Zong ','Gun ','Za ','Swu ','Ce ','Hai ','Lan ','','Ji ',
        'Li ','Can ','Lang ','Yu ','','Ying ','Mo ','Diao ','Tiao ','Mao ','Tong ','Zhu ','Pong ','Am ','Lyen ','Chong ',
        'Xi ','Phyeng ','Qiu ','Jin ','Swun ','Jie ','Wei ','Tui ','Cao ','Yu ','Yi ','Ji ','Lyo ','Phil ','Lu ','Swuk ',
        ],
    'x85':[
        'Pwu ','Zhang ','Luo ','Jiang ','Man ','Yan ','Lung ','Ji ','Piao ','Gun ','Han ','Di ','Su ','Lu ','She ','Shang ',
        'Di ','Myel ','Xun ','Man ','Pok ','Chey ','Cuo ','Ca ','Sam ','Xuan ','Wul ','Hu ','Ao ','Mi ','Lwu ','Cwu ',
        'Zhong ','Chay ','Po ','Cang ','Mi ','Chong ','Co ','Hui ','Jun ','Yin ','Cem ','Yan ','So ','Um ','Kui ','Cin ',
        'Hu ','Sha ','Kou ','Qian ','Ma ','Cang ','Sonoko ','Qiang ','Dou ','Lian ','Lin ','Kou ','Ai ','Phyey ','Li ','Wi ',
        'Ji ','Tam ','Sheng ','Pen ','Meng ','Ou ','Chen ','Dian ','Xun ','Cho ','Yey ','Yey ','Lei ','Yu ','Kyo ','Chu ',
        'Hua ','Jian ','Mai ','Wun ','Bao ','Yu ','Ke ','Lu ','Yo ','Hyey ','E ','Teng ','Fei ','Jue ','Chey ','Fa ',
        'Ru ','Pwun ','Kui ','Swun ','Yu ','Ya ','Xu ','Fu ','Kwel ','Thang ','Mwu ','Tong ','Si ','So ','Xi ','Long ',
        'On ','','Qi ','Jian ','Yun ','Sun ','Ling ','Yu ','Xia ','Yong ','Cup ','Hong ','Si ','Nong ','Loy ','Xuan ',
        'On ','Yu ','Xi ','Hao ','Pak ','Hao ','Ay ','Mi ','Hui ','Yey ','Kyey ','Ci ','Hyang ','Luan ','Mie ','Uy ',
        'Leng ','Kang ','Can ','Shen ','Cang ','Lian ','Ke ','Wen ','Da ','Chi ','Tang ','Sel ','Pyek ','Tam ','Sun ','Lian ',
        'Fan ','Ding ','Jie ','Gu ','Hay ','Chok ','Chen ','Kao ','Hwung ','Sal ','Sin ','Hwun ','Yak ','Hai ','Sou ','Se ',
        'Hwun ','Dui ','Pin ','Wei ','Neng ','Chou ','Mai ','Ru ','Piao ','Tai ','Cey ','Zao ','Chen ','Zhen ','Er ','Ni ',
        'Ying ','Ko ','Cong ','Xiao ','Qi ','Fa ','Jian ','Xu ','Kui ','Ca ','Bian ','Diao ','Mi ','Lam ','Sin ','Cang ',
        'Myo ','Qiong ','Qie ','Xian ','','Wu ','Xian ','Su ','Lu ','Yi ','Xu ','Xie ','Lye ','Yey ','La ','Lei ',
        'Xiao ','Di ','Zhi ','Bei ','Tung ','Yak ','Mo ','Huan ','Biao ','Pen ','Swu ','Tan ','Tui ','Qiong ','Qiao ','Wei ',
        'Liu ','Hui ','','Gao ','On ','','Li ','Ce ','Chu ','Ay ','Lin ','Co ','Xuan ','Chin ','Lai ','Kwak ',
        ],
    'x86':[
        'Thak ','Wu ','Yey ','Rui ','Ki ','Heng ','Lo ','So ','Tui ','Mang ','On ','Pin ','Yu ','Xun ','Ji ','Jiong ',
        'Xian ','Mo ','Hagi ','Su ','Jiong ','','El ','Pyek ','Yang ','Yi ','Sen ','Yu ','Ju ','Lian ','Lian ','Yin ',
        'Qiang ','Ying ','Long ','Tong ','Wei ','Yue ','Ling ','Ke ','Yao ','Pen ','Mi ','Lan ','Kui ','Lan ','Ji ','Thang ',
        'Katsura ','Lei ','Lei ','Hua ','Feng ','Zhi ','Wei ','Kui ','Zhan ','Huai ','Li ','Ji ','Mi ','Lei ','Huai ','La ',
        'Ji ','Ki ','Lu ','Jian ','San ','','Lei ','Quan ','Xiao ','Yi ','Luan ','Men ','Bie ','Hu ','Ho ','Lu ',
        'Hak ','Lu ','Si ','Hyo ','Ken ','Che ','Hu ','Xu ','Cuo ','Fu ','He ','He ','Lo ','Hu ','Wu ','Ho ',
        'Jiao ','Ju ','Guo ','Bao ','Yan ','Zhan ','Zhan ','Hyu ','Ban ','Xi ','Shu ','Hwey ','Kyu ','Diao ','Ji ','Kyu ',
        'Cheng ','Sul ','','Di ','Zhe ','She ','Yu ','Gan ','Ca ','Hong ','Hwey ','Meng ','Ge ','Sui ','Xia ','Chai ',
        'Shi ','Yi ','Ma ','Xiang ','Fang ','E ','Pa ','Chi ','Qian ','Wen ','Mwun ','Yey ','Pang ','Pi ','Yue ','Yue ',
        'Jun ','Qi ','Tong ','In ','Qi ','Chen ','Yuan ','Jue ','Hui ','Qin ','Qi ','Zhong ','Ya ','Ci ','Mu ','Wang ',
        'Fen ','Fen ','Hang ','Kong ','Co ','Fu ','Ran ','Jie ','Pwu ','Chi ','Twu ','Piao ','Xian ','Ni ','Te ','Kwu ',
        'Yu ','Chayk ','Ping ','Chi ','Yu ','He ','Han ','Ju ','Li ','Fu ','Ran ','Zha ','Gou ','Pi ','Bo ','Xian ',
        'Cwu ','Diao ','Bie ','Bing ','Gu ','Cem ','Ce ','Sa ','Tie ','Lyeng ','Gu ','Tan ','Gu ','Hyeng ','Li ','Cheng ',
        'Qu ','Mou ','Ge ','Ci ','Hoy ','Hui ','Mang ','Fu ','Yang ','Wa ','Lie ','Cwu ','Yi ','Xian ','Hwal ','Kyo ',
        'Li ','Yi ','Ping ','Kil ','Hap ','She ','Yi ','Wang ','Mo ','Kong ','Qie ','Gui ','Kong ','Cil ','Man ','Ebi ',
        'Zhi ','Jia ','Rao ','Si ','Qi ','Xing ','Lie ','Qiu ','So ','Yong ','Jia ','Sey ','Che ','Bai ','A ','Han ',
        ],
    'x87':[
        'Chok ','Xuan ','Pong ','Sin ','Zhen ','Fu ','Hyen ','Zhe ','O ','Pwu ','Li ','Lang ','Bi ','Chu ','Yuan ','You ',
        'Jie ','Tan ','Yan ','Ting ','Dian ','Sey ','Hoy ','Gua ','Ci ','Song ','Pi ','Ju ','Mil ','Ki ','Qi ','Yu ',
        'Jun ','Sa ','Meng ','Qiang ','Si ','Sek ','Lun ','Li ','Cep ','Co ','Tao ','Kun ','Gan ','Han ','Yu ','Bang ',
        'Fei ','Pi ','Wei ','Dun ','Chek ','Yen ','Su ','Kwen ','Qian ','Rui ','Yey ','Cheng ','Wei ','Liang ','Guo ','Wen ',
        'Tong ','E ','Ban ','Di ','Wang ','Can ','Yang ','Ying ','Guo ','Sen ','','Lap ','Kwa ','Ji ','Kal ','Ting ',
        'Mai ','Xu ','Mian ','Yu ','Jie ','Sik ','Xuan ','Hwang ','Yan ','Phyen ','Rou ','Wei ','Fu ','Yuan ','Mei ','Wi ',
        'Pok ','Ruan ','Xie ','You ','Yu ','Mo ','Ha ','Ying ','Sul ','Chong ','Tang ','Zhu ','Zong ','Ti ','Pok ','Yuan ',
        'Hui ','Meng ','La ','Du ','Hwu ','Qiu ','Cep ','Li ','Wa ','Yun ','Ju ','Nan ','Lou ','Qun ','Rong ','Ying ',
        'Jiang ','','Lang ','Pang ','Si ','Xi ','Ci ','Xi ','Yuan ','Weng ','Lian ','Sou ','Pan ','Yung ','Rong ','Ji ',
        'Wu ','Qiu ','Han ','Qin ','Yi ','Bi ','Hua ','Tang ','Uy ','Du ','Nai ','He ','Hu ','Hui ','Ma ','Myeng ',
        'Yi ','Wen ','Hyeng ','Tung ','Yu ','Cang ','So ','Ebi ','Man ','','Shang ','Shi ','Cao ','Li ','Di ','Ao ',
        'Lu ','Wei ','Zhi ','Tang ','Cin ','Piao ','Qu ','Pi ','Yu ','Jian ','La ','Lwu ','Qin ','Cong ','Yin ','Jiang ',
        'Sol ','Wen ','Jiao ','Wan ','Chip ','Zhe ','Ma ','Ma ','Guo ','Liu ','Mo ','Sil ','Cong ','Li ','Man ','Xiao ',
        'Tou ','Zhang ','Mang ','Xiang ','Mo ','Zui ','Si ','Qiu ','Te ','Zhi ','Phayng ','Phayng ','Jiao ','Qu ','Bie ','Liao ',
        'Pan ','Gui ','Xi ','Ki ','Zhuan ','Huang ','Fei ','Lao ','Jue ','Jue ','Hui ','Yin ','Sen ','Jiao ','Shan ','Yo ',
        'Xiao ','Mou ','Chwung ','Xun ','Si ','','Cheng ','Tang ','Li ','Hay ','Shan ','Uy ','Jing ','Da ','Sem ','Qi ',
        ],
    'x88':[
        'Ci ','Xiang ','She ','La ','Qin ','Sung ','Chai ','Li ','Ze ','Xuan ','Lian ','Zhu ','Ze ','Kal ','Mang ','Xie ',
        'Qi ','Yeng ','Jian ','Meng ','Hao ','Yu ','Huo ','Zhuo ','Jie ','Bin ','He ','Mie ','Fan ','Lei ','Jie ','Lap ',
        'Mi ','Lye ','Cwun ','Lye ','Qiu ','Nie ','Lu ','Du ','Xiao ','Zhu ','Long ','Li ','Long ','Feng ','Ye ','Beng ',
        'Shang ','Ko ','Kyen ','Ying ','','Xi ','Cam ','Qu ','Quan ','Twu ','Can ','Man ','Jue ','Jie ','Zhu ','Zha ',
        'Hyel ','Huang ','Niu ','Pei ','Nyuk ','Hun ','Cwung ','Mo ','Er ','Ke ','Myel ','Xi ','Hayng ','Yen ','Kan ','Yuan ',
        '','Ling ','Hyen ','Swul ','Xian ','Tong ','Long ','Ka ','Xian ','A ','Hu ','Wi ','Dao ','Chwung ','Wi ','Dao ',
        'Zhun ','Hyeng ','Kwu ','Uy ','Koromohen ','Bu ','Gan ','Yu ','Phyo ','Cha ','Yi ','Sam ','Chen ','Fu ','Kon ','Fen ',
        'Soy ','Jie ','Nap ','Zhong ','Dan ','Ri ','Zhong ','Chwung ','Xie ','Qi ','Xie ','Ran ','Zhi ','Im ','Kum ','Kum ',
        'Jun ','Wen ','Myey ','Chai ','Ao ','Niao ','Wi ','Ran ','Ka ','Tuo ','Ling ','Tay ','Bao ','Pho ','Yao ','Zuo ',
        'Bi ','Shao ','Tan ','Ju ','He ','Shu ','Swu ','Cin ','Yi ','Pa ','Bo ','Ce ','Wa ','Pwu ','Kon ','Zhi ',
        'Zhi ','Ran ','Pen ','Yi ','Mwu ','','Na ','Kou ','Xian ','Chan ','Ke ','Phi ','Gun ','Xi ','Ne ','Bo ',
        'Horo ','Pok ','Yi ','Chi ','Ko ','Ren ','Jiang ','Jia ','Cun ','Mo ','Jie ','Er ','Luo ','Ru ','Zhu ','Gui ',
        'In ','Cay ','Lyel ','Kamishimo ','Yuki ','Cang ','Dang ','Seot ','Kun ','Ken ','Nyo ','Shu ','Jia ','Kon ','Cheng ','Li ',
        'Juan ','Shen ','Pwu ','Ge ','Yey ','Yu ','Zhen ','Liu ','Kwu ','Kwun ','Ji ','Yi ','Po ','Cang ','Shui ','Sa ',
        'Qun ','Li ','Lian ','Lian ','Ku ','Jian ','Fou ','Chan ','Pi ','Gun ','Tao ','Yuan ','Ling ','Chi ','Chang ','Cwu ',
        'Duo ','Phyo ','Liang ','Sang ','Pay ','Pey ','Fei ','Yuan ','La ','Kwa ','Yan ','Du ','Xi ','Cey ','Ke ','Qi ',
        ],
    'x89':[
        'Ji ','Zhi ','Gua ','Ken ','Che ','Ti ','Ti ','Pok ','Chong ','Xie ','Phyen ','Die ','Kon ','Duan ','Xiu ','Xiu ',
        'Kal ','Yuan ','Pho ','Po ','Fu ','Yu ','Tuan ','Yan ','Wi ','Pey ','Ce ','Lu ','Ena ','Tan ','Yun ','Da ',
        'Gou ','Da ','Huai ','Rong ','Yuan ','Yo ','Nai ','Kyeng ','Suo ','Ban ','Thoy ','Chi ','Sang ','Niao ','Ying ','Jie ',
        'Ken ','Huai ','Ku ','Lian ','Bao ','Li ','Sup ','Shi ','Lwu ','Yi ','Chep ','Sel ','Xian ','Wei ','Biao ','Cao ',
        'Ji ','Kang ','Sen ','Bao ','Yang ','Chihaya ','Pu ','Jian ','Zhuan ','Jian ','Zui ','Ji ','Dan ','Cap ','Fan ','Bo ',
        'Xiang ','Xin ','Bie ','Rao ','Man ','Lan ','O ','Duo ','Koy ','Cao ','Sui ','Nong ','Chem ','Lian ','Pyek ','Kum ',
        'Tang ','Shu ','Tan ','Bi ','Lam ','Pu ','Yu ','Zhi ','','Shu ','Mal ','Shi ','Bai ','Hil ','Bo ','Chin ',
        'Lai ','Long ','Sup ','Xian ','Lan ','Zhe ','Dai ','Tasuki ','Zan ','Shi ','Jian ','Pan ','Yi ','Ran ','Ya ','Se ',
        'Xi ','Yo ','Feng ','Tam ','','Biao ','Pok ','Phay ','Hayk ','Ki ','Ji ','Kyen ','Kwan ','Bian ','Yan ','Kyu ',
        'Jue ','Pian ','Mao ','Myek ','Mi ','Mie ','Si ','Sa ','Cem ','Luo ','Kak ','Mi ','Tiao ','Lian ','Yao ','Zhi ',
        'Jun ','Kyek ','Shan ','Wei ','Xi ','Tian ','Yu ','Lam ','Ak ','To ','Chin ','Pang ','Ki ','Ming ','Ying ','Kwu ',
        'Qu ','Zhan ','Kun ','Kwan ','Deng ','Jian ','Luo ','Che ','Jian ','Wei ','Kak ','Qu ','Luo ','Lam ','Shen ','Cek ',
        'Kwan ','Jian ','Guan ','Yan ','Gui ','Mi ','Shi ','Zhan ','Lan ','Jue ','Ji ','Xi ','Di ','Tian ','Yu ','Gou ',
        'Jin ','Qu ','Kak ','Jiu ','Kun ','Cu ','Kyel ','Zhi ','Chao ','Ji ','Ko ','Dan ','Ca ','Ce ','Shang ','Hua ',
        'Quan ','Ge ','Chi ','Hay ','Gui ','Koyng ','Chok ','Jie ','Hun ','Qiu ','Xing ','Sok ','Ni ','Ji ','Lu ','Zhi ',
        'Zha ','Phil ','Xing ','Kok ','Sang ','Gong ','Chi ','Xue ','Chok ','Xi ','Yi ','Lu ','Jue ','Xi ','Yan ','Xi ',
        ],
    'x8a':[
        'En ','Gonben ','Ceng ','Pwu ','Qiu ','Qiu ','Jiao ','Koyng ','Kyey ','Pem ','Sin ','Diao ','Hong ','Cha ','Tho ','Xu ',
        'Al ','I ','Ren ','Hwun ','Un ','San ','Hul ','Thak ','Ki ','Xun ','Un ','Wa ','Fen ','A ','Yao ','Song ',
        'Shen ','Yin ','Hun ','Kyel ','Xiao ','Nwul ','Chen ','You ','Zhi ','Xiong ','Pang ','Xin ','Chao ','Sel ','Xian ','Sha ',
        'Tun ','He ','Yi ','Yek ','So ','Chi ','Ka ','Shen ','He ','Xu ','Cin ','Cwu ','Ceng ','Gou ','Ca ','Zi ',
        'Zhan ','Ko ','Fu ','Quan ','Die ','Ling ','Ce ','Yang ','Li ','Nao ','Pan ','Cwu ','Gan ','Yi ','Ke ','Ao ',
        'Sa ','I ','I ','Qu ','Co ','Phyeng ','Phi ','Hyeng ','Kwul ','Ba ','Da ','Ce ','Tao ','Zhu ','Sa ','Zhe ',
        'Yeng ','Hwu ','Swun ','Yey ','Huang ','He ','Si ','Cha ','Jiao ','Si ','Hen ','Tha ','Kwu ','Kwey ','Cen ','Hui ',
        'Hil ','Hwa ','Hay ','Sang ','Wei ','Sen ','Chou ','Tong ','Mi ','Chem ','Ming ','E ','Hoy ','Yan ','Xiong ','Kway ',
        'Er ','Beng ','Co ','Chi ','Loy ','Cwu ','Kwang ','Kwa ','Wu ','Yey ','Teng ','Ji ','Ci ','In ','Su ','Lang ',
        'E ','Kwang ','Huy ','Se ','Ting ','Than ','Bo ','Chan ','Yu ','Heng ','Cho ','Qin ','Shua ','An ','E ','Xiao ',
        'Seng ','Kyey ','Hyen ','Mwu ','O ','Ko ','Song ','Pho ','Hoy ','Jing ','Sel ','Zhen ','Sel ','Tok ','Yasashi ','Chang ',
        'Swu ','Jie ','Kwa ','Qu ','Cong ','Xiao ','Swu ','Wang ','Xuan ','Pi ','Chi ','Ta ','Uy ','Na ','Un ','Co ',
        'Pi ','Chuo ','Chem ','Chen ','Swun ','Ji ','Qi ','Tam ','Zhui ','Wi ','Ju ','Cheng ','Jian ','Cayng ','Ze ','Chwu ',
        'Qian ','Chak ','Lyang ','Jian ','Zhu ','Hao ','Lon ','Sim ','Biao ','Huai ','Pian ','Yu ','Chep ','Se ','Phyen ','Si ',
        'Hwen ','Si ','Wen ','Hua ','Ak ','Zhong ','Chey ','Hay ','Fu ','Pu ','Ceng ','Kan ','Qi ','Yu ','Ca ','Chuan ',
        'Si ','Hwi ','Yin ','Am ','Ham ','Nan ','Sim ','Phwung ','Cey ','Yang ','En ','Heng ','Hwen ','Ge ','Nak ','Qi ',
        ],
    'x8b':[
        'Mo ','Al ','Wi ','','Tung ','Zou ','Shan ','Ken ','Bo ','','Huang ','Huo ','Ka ','Ying ','Mi ','Xiao ',
        'Mil ','Hyey ','Qiang ','Chen ','Hak ','Ti ','So ','Pang ','Chi ','Kyem ','Ik ','Kang ','Wen ','Sa ','Xue ','Tao ',
        'Yo ','Yao ','','Wu ','Biao ','Cong ','Kyeng ','Li ','Mo ','Mo ','Shang ','Cek ','Lyu ','Cen ','Ze ','Jie ',
        'Lian ','Lou ','Can ','Kwu ','Guan ','Xi ','Zhuo ','O ','Ao ','Kun ','Zhe ','Yi ','Hu ','Jiang ','Man ','Chao ',
        'Han ','Hwa ','Chan ','Hwu ','Zeng ','Se ','Xi ','She ','Dui ','Cung ','Nao ','Lan ','Wa ','Ying ','Hyul ','Ki ',
        'Zun ','Jiao ','Bo ','Hui ','Sen ','Mu ','Cham ','Zha ','Sik ','Cho ','Tam ','Zen ','Po ','Sheng ','Xuan ','Co ',
        'Tan ','Dang ','Sui ','Qian ','Ji ','Jiao ','Kyeng ','Lian ','Nou ','Yi ','Ai ','Sem ','Pi ','Hui ','Hua ','Yek ',
        'Uy ','Sen ','Rang ','Nou ','Kyen ','Zhui ','Ta ','Ho ','Zhou ','Hao ','Ye ','Ying ','Jian ','Yey ','Jian ','Hyey ',
        'Tok ','Zhe ','Xuan ','Chan ','Lei ','Shen ','Wei ','Chan ','Li ','Yu ','Pyen ','Zhe ','Yen ','E ','Swu ','Wei ',
        'Swu ','Yao ','Cham ','Yang ','Yin ','Lan ','Cham ','Huo ','Zhe ','Hwan ','Chan ','Yi ','Tang ','Zhan ','En ','Du ',
        'Yan ','Ji ','Ding ','Fu ','Ren ','Ji ','Jie ','Hong ','Tao ','Rang ','Shan ','Qi ','Thak ','Xun ','Yi ','Xun ',
        'Ji ','Ren ','Jiang ','Hui ','Ou ','Ju ','Ya ','Ne ','Xu ','E ','Lun ','Xiong ','Song ','Feng ','She ','Fang ',
        'Jue ','Zheng ','Gu ','He ','Ping ','Zu ','Shi ','Xiong ','Zha ','Su ','Zhen ','Di ','Zou ','Ci ','Qu ','Zhao ',
        'Bi ','Yi ','Yi ','Kuang ','Lei ','Shi ','Gua ','Shi ','Jie ','Hui ','Cheng ','Zhu ','Shen ','Hua ','Dan ','Gou ',
        'Quan ','Gui ','Xun ','Yi ','Zheng ','Gai ','Xiang ','Cha ','Hun ','Xu ','Zhou ','Jie ','Wu ','Yu ','Qiao ','Wu ',
        'Gao ','You ','Hui ','Kuang ','Shuo ','Song ','Ai ','Qing ','Zhu ','Zou ','Nuo ','Du ','Zhuo ','Fei ','Ke ','Wei ',
        ],
    'x8c':[
        'Yu ','Shui ','Shen ','Diao ','Chan ','Liang ','Zhun ','Sui ','Tan ','Shen ','Yi ','Mou ','Chen ','Die ','Huang ','Jian ',
        'Xie ','Nue ','Ye ','Wei ','E ','Yu ','Xuan ','Chan ','Zi ','An ','Yan ','Di ','Mi ','Pian ','Se ','Mo ',
        'Dang ','Su ','Xie ','Yao ','Bang ','Shi ','Qian ','Mi ','Jin ','Man ','Zhe ','Jian ','Miu ','Tan ','Zen ','Qiao ',
        'Lan ','Pu ','Jue ','Yan ','Qian ','Zhan ','Chen ','Kok ','Qian ','Hong ','Xia ','Jue ','Hong ','Han ','Hong ','Kyey ',
        'Xi ','Hwal ','Liao ','Han ','Du ','Long ','Twu ','Kang ','Kay ','Si ','Lyey ','Deng ','Wan ','Bi ','Swu ','Xian ',
        'Phwung ','Zhi ','Zhi ','Yan ','Yan ','Si ','Chwuk ','Hui ','Tun ','Yi ','Ton ','Yi ','Jian ','Ba ','Hou ','E ',
        'Cu ','Sang ','Hwan ','Yen ','Ken ','Gai ','Qu ','Fu ','Huy ','Bin ','Ho ','Yey ','Ce ','Jia ','Fen ','Xi ',
        'Bo ','Wen ','Huan ','Pin ','Di ','Zong ','Fen ','Yi ','Chi ','Phyo ','Si ','An ','Pi ','Na ','Pi ','Gou ',
        'Na ','You ','Cho ','Mayk ','Si ','Hyu ','Huan ','Kun ','He ','He ','Mayk ','Han ','Mo ','Li ','Ni ','Bi ',
        'Yu ','Jia ','Tuan ','Myo ','Pi ','Xi ','E ','Ju ','Mayk ','Chu ','Tan ','Huan ','Jue ','Phay ','Ceng ','Yuan ',
        'Pwu ','Cay ','Kong ','Te ','Yi ','Hang ','Wan ','Pin ','Hwa ','Phan ','Tham ','Kwan ','Chayk ','Zhi ','Er ','Ce ',
        'Sey ','Bi ','Ca ','I ','Kwi ','Pian ','Phyem ','May ','Tay ','Sheng ','Hwang ','Pi ','Chep ','I ','Chi ','Mwu ',
        'Ha ','Pwun ','Loy ','Im ','Hoy ','Gai ','Pyen ','Ca ','Ka ','Xu ','Cek ','Jiao ','Gai ','Zang ','Jian ','Ying ',
        'Xun ','Cin ','She ','Pin ','Pin ','Qiu ','She ','Chuan ','Zang ','Cwu ','Loy ','Chan ','Sa ','Chen ','Sang ','Tian ',
        'Pay ','Kayng ','Hyen ','May ','Chen ','Sui ','Pwu ','Tan ','Cong ','Cong ','Cil ','Ji ','Cang ','To ','Jin ','Xiong ',
        'Shun ','Yun ','Bao ','Zai ','Loy ','Feng ','Cang ','Ji ','Sheng ','Ai ','Zhuan ','Pwu ','Kwu ','Say ','Sayk ','Liao ',
        ],
    'x8d':[
        'Wei ','Bai ','Chen ','Zhuan ','Ci ','Chwey ','Biao ','Yun ','Cung ','Tan ','Chan ','An ','','Sem ','Wan ','Yeng ',
        'Sin ','Gan ','Xian ','Cang ','Pi ','Du ','Sok ','Yan ','','Xuan ','Long ','Kong ','Cang ','Bei ','Zhen ','Fu ',
        'Yuan ','Gong ','Cai ','Ze ','Xian ','Bai ','Zhang ','Huo ','Zhi ','Fan ','Tan ','Pin ','Bian ','Gou ','Zhu ','Guan ',
        'Er ','Jian ','Bi ','Shi ','Tie ','Gui ','Kuang ','Dai ','Mao ','Fei ','He ','Yi ','Zei ','Zhi ','Jia ','Hui ',
        'Zi ','Ren ','Lu ','Zang ','Zi ','Gai ','Jin ','Qiu ','Zhen ','Lai ','She ','Fu ','Du ','Ji ','Shu ','Shang ',
        'Si ','Bi ','Cwu ','Geng ','Pei ','Tan ','Lai ','Feng ','Zhui ','Fu ','Zhuan ','Sai ','Ze ','Yan ','Zan ','Yun ',
        'Zeng ','Shan ','Ying ','Gan ','Cek ','Xi ','Sa ','Nan ','Xiong ','Xi ','Cheng ','Hyek ','Cheng ','Ca ','Xia ','Tang ',
        'Cwu ','Zou ','Li ','Kyu ','Pwu ','Zhao ','Kan ','Ki ','Shan ','Qiong ','Qin ','Xian ','Ci ','Jue ','Qin ','Chi ',
        'Ci ','Cin ','Chen ','Die ','Ju ','Cho ','Di ','Se ','Zhan ','Zhu ','Wel ','Qu ','Jie ','Chi ','Cwu ','Gua ',
        'Hyel ','Ca ','Tiao ','Duo ','Lie ','Gan ','Suo ','Cu ','Xi ','Co ','Su ','Yin ','Ju ','Jian ','Que ','Tang ',
        'Cho ','Cui ','Lu ','Chwi ','Dang ','Qiu ','Zi ','Ti ','Chwu ','Chi ','Huang ','Kyo ','Qiao ','Yao ','Zao ','Ti ',
        '','Zan ','Chan ','Cok ','Pa ','Pak ','Ku ','Ke ','Dun ','Jue ','Pwu ','Chen ','Kyen ','Fang ','Ci ','Sap ',
        'Yue ','Pa ','Ki ','Yue ','Qiang ','Tuo ','Thay ','Yi ','Nian ','Ling ','Mei ','Pal ','Cil ','Ku ','Tha ','Ka ',
        'Ci ','Pao ','Qia ','Zhu ','Ju ','Cep ','Chek ','Pwu ','Pan ','Ju ','San ','Pha ','Ni ','Ke ','Li ','Kun ',
        'Yi ','Cek ','Dai ','Sen ','Kyo ','Duo ','Zhu ','Quan ','Kwa ','Zhuai ','Kwey ','Kong ','Kyu ','Xiang ','Chi ','Lo ',
        'Beng ','Chi ','Jia ','Co ','Cai ','Chen ','Ta ','Qiao ','Bi ','Xian ','Duo ','Ji ','Kwuk ','Ki ','Shu ','Tu ',
        ],
    'x8e':[
        'Chu ','Jing ','Nie ','Xiao ','Bo ','Chi ','Cwun ','Mou ','So ','Lyang ','Yong ','Jiao ','Chou ','Qiao ','Mau ','Tap ',
        'Chen ','Qi ','Wo ','Wei ','Thak ','Jie ','Ji ','Nie ','Ju ','Ju ','Lun ','Lu ','Leng ','Kwa ','Ke ','Ci ',
        'Wan ','Quan ','Ti ','Pwu ','Zu ','Qie ','Ji ','Cu ','Zong ','Chay ','Cong ','Peng ','Zhi ','Zheng ','Dian ','Zhi ',
        'Yu ','Thak ','Dun ','Chun ','Yong ','Cong ','Cey ','Zhe ','Chen ','Tan ','Jian ','Gua ','Tang ','Wu ','Fu ','Zu ',
        'Cep ','Phyen ','Yu ','Nuo ','Cey ','Cha ','Tui ','Ken ','To ','Cha ','Hyey ','Ta ','Chang ','Zhan ','Dian ','Cey ',
        'Ji ','Nie ','Man ','Liu ','Zhan ','Phil ','Chong ','Lu ','Liao ','Chwuk ','Tang ','Dai ','Chwuk ','Xi ','Kui ','Cek ',
        'Chek ','Qiang ','Di ','Man ','Cong ','Lian ','Beng ','Zao ','Nian ','Pyel ','Tui ','Ju ','Deng ','Chung ','Xian ','Pen ',
        'Cwu ','Zhong ','Cwun ','Bo ','Chwuk ','Zu ','Kwel ','Jue ','Lin ','Ta ','Kyo ','Qiao ','Pok ','Liao ','Dun ','Cuan ',
        'Kuang ','Co ','Ta ','Bi ','Bi ','Chok ','Ju ','Ce ','Qiao ','Ton ','Cwu ','Cey ','Wu ','Yak ','Nian ','Lin ',
        'Lyep ','Chek ','Lyek ','Ci ','Cen ','Chu ','Duan ','Wei ','Long ','Lin ','Sen ','Wei ','Zuan ','Lan ','Sep ','Rang ',
        'Xie ','Sep ','Ta ','Qu ','Jie ','Cuan ','Zuan ','Xi ','Kui ','Kwak ','Lin ','Sin ','Kwung ','Dan ','Segare ','Qu ',
        'Ti ','Tha ','Duo ','Kwung ','Lang ','Nerau ','Luo ','Ai ','Ji ','Ju ','Tang ','Utsuke ','','Yan ','Shitsuke ','Kang ',
        'Kwu ','Lou ','Lao ','Tuo ','Zhi ','Yagate ','Chey ','Dao ','Yagate ','Yu ','Cha ','Al ','Kwey ','Kwun ','Wei ','Yue ',
        'Xin ','Di ','Hen ','Fan ','Ren ','Shan ','Qiang ','Shu ','Tun ','Chen ','Dai ','E ','Na ','Qi ','Mao ','Yen ',
        'Ren ','Fan ','Cen ','Hong ','Hu ','Qu ','Huang ','Di ','Lyeng ','Dai ','Ao ','Cin ','Fan ','Kuang ','Ang ','Peng ',
        'Bei ','Gu ','Gu ','Pao ','Zhu ','Rong ','E ','Ba ','Chwuk ','Ci ','Cho ','Ka ','Il ','Kyeng ','Sik ','Pyeng ',
        ],
    'x8f':[
        'Er ','Qiong ','Ju ','Kyo ','Guang ','Lo ','Kai ','Cen ','Cwu ','Cay ','Zhi ','She ','Liang ','Yu ','Shao ','You ',
        'Huan ','Yun ','Chep ','Man ','Po ','Kyeng ','Zhou ','Ni ','Ling ','Zhe ','Zhan ','Lyang ','Chi ','Hwi ','Mang ','Chel ',
        'Guo ','Kan ','Yi ','Peng ','Qian ','Gun ','Lyen ','Pyeng ','Kwan ','Pay ','Lyun ','Pai ','Liang ','Ruan ','Rou ','Cip ',
        'Yang ','Xian ','Chuan ','Cwu ','Chun ','Ge ','You ','Hong ','Swu ','Pok ','Zi ','Pok ','Wen ','Ben ','Cen ','Ye ',
        'On ','Tao ','Kok ','Zhen ','Hal ','Wen ','Lok ','Jiu ','Chao ','Cen ','Wei ','Hun ','Sori ','Chel ','Kyo ','Zhan ',
        'Pu ','Lao ','Pwun ','Fan ','Lin ','Ge ','Se ','Kem ','Hwan ','Yi ','Ji ','Dui ','Er ','Ye ','Ham ','Koyng ',
        'Lei ','Pi ','Lyek ','Lyek ','Lo ','Lin ','Che ','Ya ','Gui ','Xuan ','Di ','Ren ','Zhuan ','E ','Lun ','Ruan ',
        'Hong ','Gu ','Ke ','Lu ','Zhou ','Zhi ','Yi ','Hu ','Zhen ','Li ','Yao ','Qing ','Shi ','Zai ','Zhi ','Jiao ',
        'Zhou ','Quan ','Lu ','Jiao ','Zhe ','Fu ','Liang ','Nian ','Bei ','Hui ','Gun ','Wang ','Liang ','Chuo ','Zi ','Cou ',
        'Fu ','Ji ','Wen ','Shu ','Pei ','Yuan ','Xia ','Zhan ','Lu ','Che ','Lin ','Sin ','Ko ','Ci ','Sa ','Phi ',
        'Zui ','Bian ','Lal ','Lal ','Ci ','Xue ','Phan ','Bian ','Pyen ','Bian ','','Bian ','Ban ','Sa ','Pyen ','Pyen ',
        'Cin ','Yok ','Nong ','Nong ','Zhen ','Chuo ','Chuo ','Suberu ','Reng ','Pyen ','Pyen ','Sip ','Ip ','Liao ','Da ','Chen ',
        'Kan ','Qian ','O ','O ','Hul ','Sin ','Yi ','Guo ','Mai ','Qi ','Za ','Wang ','tu ','Twun ','Yeng ','Ti ',
        'Yun ','Kun ','Hang ','A ','Pan ','O ','Da ','E ','Huan ','Zhe ','Totemo ','Jin ','Yuan ','Wei ','Lian ','Chi ',
        'Che ','Ni ','Cho ','Zhi ','I ','Hyeng ','Ka ','Chen ','Thay ','I ','Cek ','Pak ','Wang ','Cil ','Ze ','Tao ',
        'Swul ','Tuo ','Kep ','Jing ','Hoy ','Tong ','You ','Mi ','Pyeng ','Cek ','Nay ','Yi ','Jie ','Chwu ','Lie ','Xun ',
        ],
    'x90':[
        'Thoy ','Song ','Kwal ','To ','Pang ','Hwu ','Yek ','Ci ','Hyeng ','Xuan ','Xun ','Pho ','Yu ','So ','Qiu ','Thwu ',
        'Chwuk ','Kwu ','Di ','Di ','To ','Kyeng ','Cek ','Twu ','Yi ','Ce ','Thong ','Guang ','Wu ','Se ','Lyeng ','Sok ',
        'Co ','Cwun ','Pong ','Lyen ','Suo ','Hoy ','Li ','Sako ','Lai ','Ben ','Cuo ','Jue ','Beng ','Huan ','Chey ','Lu ',
        'Yu ','Cwu ','Cin ','Yu ','Thak ','Kyu ','Wi ','Ti ','Il ','Da ','Wen ','Luo ','Phip ','Nuo ','Yu ','Dang ',
        'Sui ','Twun ','Swu ','Yan ','Chuan ','Ci ','Ti ','Wu ','Shi ','Ceng ','Yu ','Wun ','E ','Phyen ','Kwa ','Al ',
        'Ha ','Hwang ','Cwu ','To ','Tal ','Wi ','Appare ','Yi ','Kwu ','Yo ','Chu ','Lyu ','Son ','Tap ','Chey ','Ci ',
        'Wen ','So ','Ta ','Kyen ','','Yao ','Guan ','Zhang ','O ','Cek ','Ce ','Chi ','Sok ','Co ','Cha ','Twun ',
        'Di ','Lou ','Ci ','Cuo ','Lin ','Cwun ','Yo ','Chen ','Sen ','Yu ','Yu ','Wu ','Lyo ','Ke ','Shi ','Phi ',
        'Yo ','May ','Hay ','Swu ','Hwan ','Cen ','Teng ','I ','Mak ','Bian ','Pyen ','La ','Lye ','Yuan ','Yao ','La ',
        'Li ','Up ','Ting ','Deng ','Qi ','Ong ','Shan ','Han ','Yu ','Mang ','Ru ','Kong ','','Kuang ','Fu ','Kang ',
        'Pin ','Pang ','Hyeng ','Na ','','Shen ','Pang ','Yuan ','Chon ','Huo ','Sa ','Bang ','Wu ','Ju ','You ','Han ',
        'Thay ','Kwu ','Bi ','Pi ','Pyeng ','So ','Phay ','Wa ','Ce ','Zou ','Ye ','Lin ','Kuang ','Kyu ','Cwu ','Shi ',
        'Ku ','Wuk ','Gai ','Hap ','Kuk ','Cil ','Ji ','Xun ','Hou ','Xing ','Kyo ','Xi ','Gui ','Nuo ','Lang ','Jia ',
        'Kuai ','Zheng ','Rou ','Yun ','Yan ','Cheng ','Dou ','Chi ','Lu ','Fu ','Wu ','Fu ','Ko ','Hak ','Lang ','Kyep ',
        'Geng ','Kwun ','Yeng ','Bo ','Kuk ','Bei ','Li ','Yun ','Pwu ','Xiao ','Che ','Pi ','Qing ','Kwak ','','Tam ',
        'Zou ','Ping ','Lai ','Ni ','Chim ','Wu ','Bu ','Hyang ','Dan ','Ju ','Yong ','Qiao ','Yi ','To ','Yan ','Mei ',
        ],
    'x91':[
        'Ruo ','Bei ','Ak ','Yu ','Juan ','Yu ','Yun ','Hou ','Kui ','Hyang ','Xiang ','Sou ','Tang ','Ming ','Xi ','Ru ',
        'Chu ','Zi ','Chwu ','Ju ','O ','Hyang ','Yun ','Hao ','Yong ','Pi ','Mo ','Chao ','Fu ','Liao ','Un ','Zhuan ',
        'Hu ','Qiao ','En ','Cang ','Man ','Qiao ','Xu ','Tung ','Bi ','Xin ','Bi ','Ceng ','Wei ','Ceng ','Mao ','Shan ',
        'Lin ','Pha ','Tan ','Meng ','Ep ','Cao ','Hoy ','Feng ','Meng ','Zou ','Kwang ','Lian ','Zan ','Cen ','You ','Qi ',
        'Yan ','Chan ','Zan ','Ling ','Huan ','Xi ','Feng ','Zan ','Lyek ','Yu ','Ceng ','Chwu ','Cak ','Pay ','Cwu ','Yi ',
        'Hang ','Yu ','Cwu ','Yan ','Zui ','Mao ','Tham ','Hwu ','Tou ','Zhen ','Fen ','Sakenomoto ','','Yun ','Tai ','Tian ',
        'Qia ','Tuo ','Cho ','Kem ','Ko ','So ','Pal ','Chou ','Zai ','Myeng ','Lak ','Chuo ','Swu ','You ','Tong ','Zhi ',
        'Xian ','Cang ','Ceng ','Yin ','To ','Hyo ','May ','Hok ','San ','Loy ','Pu ','Zui ','Hai ','Yan ','Xi ','Niang ',
        'Wei ','Lu ','Lan ','Em ','Tao ','Pei ','Zhan ','Swun ','Tan ','Chwi ','Chuo ','Cho ','Kun ','Cey ','Mian ','Du ',
        'Ho ','Xu ','Seng ','Tan ','Jiu ','Chun ','On ','Pal ','Ke ','Sou ','Mi ','Quan ','Chwu ','Cuo ','On ','Yong ',
        'Ang ','Zha ','Hay ','Tang ','Cang ','Piao ','Shan ','Yu ','Li ','Zao ','Lyo ','Uy ','Cang ','Bu ','Cho ','Hyey ',
        'Tan ','Pal ','Nong ','Yi ','Lyey ','Kyak ','Jiao ','Yi ','Niang ','Ru ','Xun ','Chou ','Yan ','Ling ','Mi ','Mi ',
        'Yang ','Hun ','Jiao ','Si ','Mi ','Yem ','Pyen ','Chay ','Sek ','Yu ','Shi ','Sek ','Li ','Cwung ','Ya ','Lyang ',
        'Li ','Kim ','','Ga ','Yi ','Liao ','Dao ','Soy ','Ceng ','Po ','Qiu ','He ','Pwu ','Chim ','Zhi ','Ba ',
        'Luan ','Fu ','Nai ','Co ','Sam ','Qiao ','Kwu ','Chen ','Zi ','Fan ','Wu ','Hua ','Han ','Kong ','Qi ','Mang ',
        'Ri ','Di ','Si ','Xi ','Yi ','Chay ','Shi ','Tu ','Xi ','Nu ','Qian ','Kyuu ','Jian ','Pi ','Ye ','Kun ',
        ],
    'x92':[
        'Ba ','Fang ','Chen ','Xing ','Dou ','Yue ','Yan ','Pwu ','Pi ','Na ','Xin ','E ','Jue ','Twun ','Gou ','Yin ',
        'Kem ','Phan ','Sap ','Ren ','Cho ','Niu ','Fen ','Yun ','Ji ','Qin ','Pi ','Guo ','Hoyng ','Yin ','Kyun ','Co ',
        'Yi ','Zhong ','Nie ','Gai ','Ri ','Huo ','Tai ','Kang ','Habaki ','Ro ','Ngaak ','','Duo ','Zi ','Ni ','Tu ',
        'Shi ','Min ','Gu ','Ke ','Lyeng ','Pyeng ','Yi ','Ko ','Pal ','Pi ','Ok ','Si ','Zuo ','Bu ','You ','Cen ',
        'Kap ','Cin ','Shi ','Shi ','Chel ','Ke ','Chan ','Shi ','Shi ','Hyen ','Zhao ','Pho ','He ','Bi ','Sayng ','Se ',
        'Sek ','Pak ','Cwu ','Chi ','Za ','Po ','Tong ','Kyem ','Fu ','Zhai ','Liu ','Yen ','Fu ','Li ','Wel ','Pi ',
        'Yang ','Ban ','Pal ','Jie ','Kwu ','Swul ','Ceng ','Mu ','Ni ','Nie ','Di ','Jia ','Mu ','Dan ','Shen ','Yi ',
        'Si ','Kwang ','Ka ','Bei ','Jian ','Tong ','Xing ','Hong ','Kyo ','Chi ','Er ','Ge ','Pyeng ','Shi ','Mo ','Ha ',
        'Un ','Jun ','Zhou ','Chong ','Shang ','Tong ','Mo ','Lei ','Ji ','Yu ','Xu ','Im ','Zun ','Zhi ','Kong ','Shan ',
        'Chi ','Sen ','Xing ','Cen ','Pi ','Chel ','Swu ','Hou ','Myeng ','Kwa ','Co ','Sem ','Ham ','Xiu ','Jun ','Cha ',
        'Lao ','Ji ','Pi ','Ru ','Mi ','Yi ','Yin ','Guang ','An ','Diu ','You ','Se ','Kao ','Cen ','Luan ','Kasugai ',
        'Ai ','Diao ','Han ','Yey ','Shi ','Keng ','Kwu ','So ','Zhe ','Swu ','Zang ','Ti ','Cuo ','Gua ','Gong ','Zhong ',
        'Dou ','Lu ','Mei ','Lang ','Wan ','Xin ','Yun ','Bei ','Ok ','Su ','Yu ','Chan ','Ceng ','Bo ','Han ','Hyep ',
        'Hong ','Cen ','Pong ','Chan ','Wan ','Zhi ','Si ','Hyen ','Wu ','Wu ','Tiao ','Gong ','Zhuo ','Lue ','Xing ','Chim ',
        'Shen ','Han ','Lue ','Xie ','Se ','Ceng ','Ju ','Xian ','Tie ','Mang ','Pho ','Li ','Pan ','Yey ','Cheng ','Gao ',
        'Li ','Te ','Pyeng ','Zhu ','','Tu ','Liu ','Zui ','Ke ','Cheng ','Wen ','Jian ','Kang ','Co ','Tao ','Chang ',
        ],
    'x93':[
        'Lun ','Guo ','Ling ','Bei ','Lok ','Li ','Cheng ','Pou ','Juan ','Min ','Zui ','Peng ','An ','Pi ','Xian ','A ',
        'Chwu ','Lei ','A ','Kong ','Ta ','Kon ','Du ','Wei ','Chwu ','Chi ','Cayng ','Ben ','Nie ','Cong ','Swun ','Tam ',
        'Ceng ','Ki ','Cen ','Chel ','Ki ','Yu ','Kum ','Kwan ','Myo ','Chang ','Cen ','Sek ','Tong ','Tao ','Ko ','Chak ',
        'Shu ','Zhen ','Lok ','Meng ','Lu ','Hua ','Biao ','Ga ','Lai ','Ken ','Kazari ','Bu ','Nai ','Wan ','Zan ','',
        'De ','Xian ','','Huo ','Liang ','','Men ','Kai ','Yeng ','Si ','Lyen ','Kwa ','Xian ','To ','Tu ','Wei ',
        'Cong ','Fu ','Rou ','Ji ','Ak ','Rou ','Chen ','Cey ','Zha ','Hong ','Yang ','Tan ','Ha ','Wu ','Keng ','Xing ',
        'Koyng ','Wei ','Fu ','Zhao ','Sap ','Qie ','She ','Hong ','Kui ','Tian ','Mwu ','Cho ','Cho ','Hou ','Yu ','Cong ',
        'Hwan ','Ye ','Min ','Jian ','Duan ','Ken ','Si ','Kui ','Hu ','Xuan ','Zhe ','Jie ','Chim ','Bian ','Cong ','Zi ',
        'Xiu ','Ye ','Mei ','Pai ','Ai ','Jie ','','Mei ','Chuo ','Ta ','Pang ','Xia ','Kyem ','Suo ','Xi ','Lyu ',
        'Zu ','Ye ','Nou ','Weng ','Yong ','Tang ','Sway ','Cayng ','Ge ','Shuo ','Chwu ','Pak ','Pan ','Sa ','Bi ','Sang ',
        'Gang ','Ca ','Wu ','Hyeng ','Hwang ','Tiao ','Liu ','Kay ','Sun ','Sha ','Sou ','Wan ','Ho ','Cin ','Cin ','Luo ',
        'Il ','Yuan ','Tang ','Nie ','Xi ','Jia ','Ge ','Ma ','Juan ','Kasugai ','Habaki ','Suo ','','','','Na ',
        'Lu ','Sway ','Ou ','Cok ','Tuan ','Xiu ','Guan ','Sen ','Lyen ','Shou ','O ','Man ','Mak ','Luo ','Bi ','Wei ',
        'Liu ','Cek ','Qiao ','Cong ','Yi ','Lu ','O ','Kayng ','Cang ','Cui ','Qi ','Chang ','Tang ','Man ','Yong ','San ',
        'Feng ','Kyeng ','Phyo ','Shu ','Lwu ','Xiu ','Chong ','Long ','Cham ','Jian ','Cao ','Li ','Xia ','Xi ','Kang ','',
        'Beng ','','','Zheng ','Lu ','Hua ','Cip ','Pu ','Hui ','Qiang ','Po ','Lin ','Suo ','Swu ','San ','Cheng ',
        ],
    'x94':[
        'Kui ','Si ','Liu ','Nyo ','Hoyng ','Pie ','Sui ','Fan ','Qiao ','Quan ','Yang ','Tang ','Xiang ','Jue ','Jiao ','Cwun ',
        'Lyo ','Jie ','Lao ','Tay ','Sim ','Zan ','Ji ','Jian ','Cong ','Tung ','Ya ','Ying ','Dui ','Jue ','Nou ','Ti ',
        'Pu ','Tie ','','','Ding ','Sen ','Kai ','Jian ','Fei ','Sui ','Lo ','Cen ','Hui ','Yu ','Lian ','Zhuo ',
        'Qiao ','Qian ','Zhuo ','Lei ','Bi ','Chel ','Hwan ','Ye ','Thak ','Guo ','Tang ','Ju ','Fen ','Da ','Bei ','Yi ',
        'Ai ','Zong ','Hwun ','Diao ','Cwu ','Heng ','Zhui ','Ji ','Nie ','Ta ','Hwak ','Qing ','Pin ','Ying ','Kui ','Ning ',
        'Xu ','Kam ','Kam ','Yari ','Cha ','Cil ','Mie ','Li ','Lei ','Ji ','Zuan ','Kwang ','Shang ','Peng ','Lap ','Du ',
        'Sak ','Chuo ','Lye ','Phyo ','Bao ','Lu ','','Thoa ','Long ','E ','Lo ','Xin ','Jian ','Lan ','Bo ','Jian ',
        'Yak ','Cham ','Yang ','Jian ','Xi ','Kwan ','Cang ','Sep ','Lei ','Cuan ','Qu ','Pan ','La ','Chan ','Lan ','Chak ',
        'Nie ','Jue ','Tang ','Shu ','Lan ','Jin ','Qiu ','Yi ','Zhen ','Ding ','Zhao ','Po ','Diao ','Tu ','Qian ','Chuan ',
        'Shan ','Sap ','Fan ','Diao ','Men ','Nu ','Xi ','Chai ','Xing ','Gai ','Bu ','Tai ','Ju ','Dun ','Chao ','Zhong ',
        'Na ','Bei ','Gang ','Ban ','Qian ','Yao ','Qin ','Jun ','Wu ','Gou ','Kang ','Fang ','Huo ','Dou ','Niu ','Ba ',
        'Yu ','Qian ','Zheng ','Qian ','Gu ','Bo ','E ','Po ','Bu ','Ba ','Yue ','Zuan ','Mu ','Dan ','Jia ','Dian ',
        'You ','Tie ','Bo ','Ling ','Shuo ','Qian ','Liu ','Bao ','Shi ','Xuan ','She ','Bi ','Ni ','Pi ','Duo ','Xing ',
        'Kao ','Lao ','Er ','Mang ','Ya ','You ','Cheng ','Jia ','Ye ','Nao ','Zhi ','Dang ','Tong ','Lu ','Diao ','Yin ',
        'Kai ','Zha ','Zhu ','Xian ','Ting ','Diu ','Xian ','Hua ','Quan ','Sha ','Jia ','Yao ','Ge ','Ming ','Zheng ','Se ',
        'Jiao ','Yi ','Chan ','Chong ','Tang ','An ','Yin ','Ru ','Zhu ','Lao ','Pu ','Wu ','Lai ','Te ','Lian ','Keng ',
        ],
    'x95':[
        'Xiao ','Suo ','Li ','Zheng ','Chu ','Guo ','Gao ','Tie ','Xiu ','Cuo ','Lue ','Feng ','Xin ','Liu ','Kai ','Jian ',
        'Rui ','Ti ','Lang ','Qian ','Ju ','A ','Qiang ','Duo ','Tian ','Cuo ','Mao ','Ben ','Ki ','De ','Kua ','Kun ',
        'Chang ','Xi ','Gu ','Luo ','Chui ','Zhui ','Jin ','Zhi ','Xian ','Juan ','Huo ','Pou ','Tan ','Ding ','Jian ','Ju ',
        'Meng ','Zi ','Qie ','Yeng ','Kai ','Qiang ','Song ','E ','Cha ','Qiao ','Cong ','Duan ','Sou ','Koyng ','Huan ','Ai ',
        'Du ','Mei ','Lou ','Zi ','Fei ','Mei ','Mo ','Zhen ','Bo ','Ge ','Nie ','Tang ','Juan ','Nie ','Na ','Liu ',
        'Hao ','Bang ','Yi ','Jia ','Bin ','Rong ','Biao ','Tang ','Man ','Luo ','Beng ','Yong ','Jing ','Di ','Zu ','Xuan ',
        'Liu ','Tan ','Jue ','Liao ','Pu ','Lu ','Dui ','Lan ','Pu ','Cuan ','Qiang ','Deng ','Huo ','Lei ','Huan ','Zhuo ',
        'Lian ','Yi ','Cha ','Biao ','La ','Chan ','Xiang ','Cang ','Chang ','Jiu ','Ao ','Die ','Qu ','Liao ','Mi ','Chang ',
        'Mwun ','Ma ','Shuan ','Sem ','Huo ','Men ','Yan ','Bi ','Han ','Phyey ','San ','Kay ','Kang ','Beng ','Koyng ','Lyun ',
        'San ','Han ','Han ','Kan ','Min ','Xia ','Yuru ','Dou ','Kap ','Nao ','','Peng ','Xia ','Ling ','Bian ','Pi ',
        'Run ','He ','Kwan ','Kak ','Hap ','Pel ','Chwuk ','Hong ','Kyu ','Min ','Se ','Kon ','Lang ','Lye ','Ting ','Sha ',
        'Ju ','Yel ','Yel ','Chan ','Qu ','Lin ','Cheng ','Shai ','Kun ','Em ','Wen ','Yem ','An ','Hon ','Yek ','Wen ',
        'Xiang ','Bao ','Xiang ','Kyek ','Yao ','Wen ','Ban ','Am ','Wi ','Yin ','Hwal ','Kyel ','Lan ','To ','','Phwung ',
        'Tian ','Nie ','Ta ','Kay ','Hap ','Kwel ','Chum ','Kwan ','Dou ','Qi ','Kyu ','Tang ','Kwan ','Piao ','Ham ','Xi ',
        'Kwey ','Chen ','Pyek ','Dang ','Huan ','Tal ','Wen ','','Men ','Shuan ','Shan ','Yan ','Han ','Bi ','Wen ','Chuang ',
        'Run ','Wei ','Xian ','Hong ','Jian ','Min ','Kang ','Men ','Zha ','Nao ','Gui ','Wen ','Ta ','Min ','Lu ','Kai ',
        ],
    'x96':[
        'Fa ','Ge ','He ','Kun ','Jiu ','Yue ','Lang ','Du ','Yu ','Yan ','Chang ','Xi ','Wen ','Hun ','Yan ','E ',
        'Chan ','Lan ','Qu ','Hui ','Kuo ','Que ','Ge ','Tian ','Ta ','Que ','Kan ','Huan ','Pwu ','Pwu ','Le ','Dui ',
        'Xin ','Chen ','Ol ','Yi ','Chi ','Yin ','Yang ','Dou ','Ayk ','Sheng ','Phan ','Pei ','Keng ','Yun ','Wan ','Ci ',
        'Pi ','Ceng ','Pang ','Yang ','Yin ','Zhen ','Jie ','Cheng ','E ','Qu ','Di ','Co ','Co ','Cem ','Ling ','A ',
        'Tha ','Tuo ','Phi ','Bing ','Pwu ','Ji ','Lu ','Long ','Chen ','Xing ','Duo ','Lwu ','Mayk ','Kang ','Shu ','La ',
        'Han ','Er ','Gui ','Yu ','Hay ','Shan ','Xun ','Qiao ','Hyeng ','Chun ','Fu ','Phyey ','Hyep ','Sem ','Sung ','Chek ',
        'Pu ','Twu ','Wen ','Cin ','Cey ','Ham ','Tou ','Nie ','Yun ','Xian ','Pay ','Pei ','Chwu ','Yi ','Dui ','Lun ',
        'Um ','Ju ','Swu ','Cin ','Pi ','Lung ','To ','Ham ','Lyuk ','','Hem ','Yin ','Ce ','Yang ','Reng ','Shan ',
        'Chong ','Yan ','Yin ','Yu ','Cey ','Wu ','Lyung ','Wei ','Oy ','El ','Tay ','Swu ','An ','Hwang ','Kyey ','Swu ',
        'Un ','Ki ','Yan ','Hui ','Kyek ','Wun ','Wu ','Oy ','Ay ','Kuk ','Tang ','Cey ','Cang ','Dao ','Ao ','Xi ',
        'Un ','','Rao ','Lin ','Thoy ','Deng ','Pi ','Swu ','Swu ','O ','Hem ','Fen ','Ni ','Er ','Ji ','Dao ',
        'Sup ','Un ','E ','Hyu ','Long ','Xi ','I ','Lyey ','Lyey ','Chwu ','He ','Chek ','Cwun ','Jun ','Nan ','Yi ',
        'Cak ','An ','Qin ','Ya ','Wung ','A ','Cip ','Ko ','Huan ','Chi ','Gou ','Cwun ','Ca ','Ong ','Ce ','Chu ',
        'Hu ','Cap ','Lak ','Yu ','Chou ','Co ','Swu ','Han ','Huo ','Ssang ','Kwan ','Chwu ','Cap ','Ong ','Kyey ','Xi ',
        'Chou ','Liu ','Li ','Nan ','Xue ','Za ','Ji ','Ji ','Wu ','Wu ','Sel ','Na ','Fou ','Se ','Mu ','Mwun ',
        'Pwun ','Pang ','Wun ','Li ','Li ','Ang ','Lyeng ','Loy ','An ','Pak ','Mong ','Cen ','Dang ','Xing ','Wu ','Zhao ',
        ],
    'x97':[
        'Swu ','Ji ','Mu ','Chen ','So ','Sap ','Ceng ','Cin ','Phay ','May ','Ling ','Qi ','Cwu ','Kwak ','Sap ','Pi ',
        'Weng ','Cem ','Yin ','Yey ','Cwu ','Tun ','Lim ','','Dong ','Yeng ','Wu ','Ling ','Sang ','Ling ','Ha ','Hong ',
        'Yin ','Mo ','Mai ','Wun ','Liu ','Meng ','Pin ','Mwu ','Wei ','Huo ','Um ','Xi ','Yi ','Ai ','Dan ','Deng ',
        'Sen ','Yu ','Lo ','Long ','Dai ','Ji ','Pang ','Yang ','Phay ','Pyek ','Wei ','','Xi ','Cey ','May ','Meng ',
        'Meng ','Lei ','Lyek ','Huo ','Ay ','Fei ','Chey ','Long ','Lyeng ','Ay ','Feng ','Li ','Po ','','He ','He ',
        'Bing ','Cheng ','Cheng ','Jing ','Tian ','Zhen ','Ceng ','Cheng ','Qing ','Jing ','Ceng ','Cen ','Ceng ','Chen ','Pi ','Fei ',
        'Ko ','Mi ','Myen ','Mian ','Pao ','Ye ','Cen ','Hui ','Yep ','Hyek ','Ding ','Cha ','Jian ','In ','Di ','Du ',
        'Wu ','Ren ','Qin ','Kun ','Hwa ','Nyu ','Pha ','In ','Sa ','Na ','Mal ','Zu ','Tal ','Ban ','Yi ','Yao ',
        'To ','Phi ','Jia ','Hong ','Pho ','Ang ','Tomo ','Yin ','Jia ','Tao ','Ji ','Hyey ','An ','An ','Hen ','Kong ',
        'Kohaze ','Da ','Qiao ','Ting ','Man ','Ying ','Sui ','Tiao ','Cho ','Xuan ','Kong ','Beng ','Ta ','Zhang ','Bing ','Kuo ',
        'Kwuk ','La ','Xie ','Yu ','Bang ','Yi ','Chwu ','Qiu ','Kal ','Xiao ','Mu ','Kwu ','Ken ','Phyen ','Cey ','Jian ',
        'On ','To ','Kwu ','Ta ','Pi ','Xie ','Pan ','Ge ','Phil ','Kwak ','Tou ','Lou ','Gui ','Kyo ','Xue ','Ji ',
        'Jian ','Kang ','Chan ','Tal ','Huo ','Xian ','Chen ','Du ','Wa ','Chen ','Lan ','Wi ','Ren ','Pwul ','Mei ','Juan ',
        'Kap ','Wei ','Qiao ','Han ','Chang ','','Rou ','Xun ','She ','Wi ','Ge ','Bei ','To ','Kwu ','On ','',
        'Phil ','Wi ','Hui ','Du ','Wa ','Du ','Wei ','Ren ','Fu ','Han ','Wei ','Yun ','Tao ','Kwu ','Kwu ','Xian ',
        'Xie ','Sem ','Cey ','Um ','Za ','Wun ','So ','Le ','Peng ','Heng ','Yeng ','Wun ','Peng ','Yin ','Yin ','Hyang ',
        ],
    'x98':[
        'Ho ','Hyel ','Ceng ','Kyeng ','Kui ','Hang ','Swun ','Han ','Swu ','I ','Wuk ','Gu ','Song ','Kyu ','Ki ','Hang ',
        'Yey ','Wan ','Pan ','Ton ','Di ','Dan ','Pan ','Pha ','Lyeng ','Ce ','Kyeng ','Lei ','He ','Qiao ','Al ','E ',
        'Wei ','Hil ','Gua ','Sin ','I ','Shen ','Hay ','Dui ','Pian ','Ping ','Lei ','Pwu ','Hyep ','Twu ','Hoy ','Kui ',
        'Hyep ','Le ','Ting ','Cheng ','Ying ','Jun ','Hu ','Am ','Kyeng ','Thoy ','Tui ','Pin ','Loy ','Thoy ','Zi ','Ca ',
        'Chui ','Ding ','Loy ','Yan ','Han ','Jian ','Kwa ','Chwi ','Kyeng ','Qin ','Yi ','Si ','Cey ','Ayk ','Ak ','An ',
        'Hun ','Kan ','Ong ','Cen ','An ','Hyen ','Sin ','Yi ','Wen ','Sang ','Cen ','Cen ','Jiang ','Ku ','Lyu ','Liao ',
        'Piao ','Yi ','Man ','Qi ','Rao ','Ho ','Cho ','Ko ','Xun ','Qian ','Hui ','Cen ','Ru ','Hong ','Bin ','Hyen ',
        'Pin ','Lo ','Lan ','Sep ','Kwan ','Ye ','Ding ','Qing ','Han ','Xiang ','Shun ','Xu ','Xu ','Wan ','Gu ','Dun ',
        'Qi ','Ban ','Song ','Hang ','Yu ','Lu ','Ling ','Po ','Jing ','Jie ','Jia ','Tian ','Han ','Ying ','Jiong ','Hai ',
        'Yi ','Pin ','Hui ','Tui ','Han ','Ying ','Ying ','Ke ','Ti ','Yong ','E ','Zhuan ','Yan ','E ','Nie ','Man ',
        'Dian ','Sang ','Hao ','Lei ','Zhan ','Ru ','Pin ','Quan ','Phwung ','Biao ','Oroshi ','Fu ','Xia ','Cem ','Biao ','Sap ',
        'Ba ','Thay ','Lyel ','Kwal ','Xuan ','Shao ','Kwu ','Bi ','Si ','Wei ','Yang ','Yao ','Swu ','Kai ','Sao ','Pem ',
        'Liu ','Xi ','Lyo ','Piao ','Phyo ','Liu ','Phyo ','Phyo ','Biao ','Lyo ','','Sil ','Feng ','Biao ','Feng ','Yang ',
        'Zhan ','Biao ','Sa ','Ju ','Si ','Sou ','Yao ','Liu ','Piao ','Biao ','Biao ','Pi ','Pen ','Fei ','Fei ','Sik ',
        'Shi ','Son ','Ki ','Ceng ','Si ','Tuo ','Cen ','Son ','Xiang ','Tun ','Im ','E ','Juan ','Chik ','Um ','Pan ',
        'Fan ','Son ','Um ','Zhu ','I ','Zhai ','Bi ','Jie ','Tao ','Liu ','Ci ','Chel ','Sa ','Pho ','Sik ','Duo ',
        ],
    'x99':[
        'Hai ','Im ','Tian ','Kyo ','Jia ','Pyeng ','Yao ','Tong ','Ci ','Hyang ','Yang ','Yang ','I ','Yan ','Le ','Yi ',
        'Chan ','Bo ','Noy ','A ','Pho ','Cwun ','Dou ','Su ','Ye ','Shi ','Hyo ','Hun ','Guo ','Shi ','Cen ','Zhui ',
        'Pyeng ','Xian ','Bu ','Ye ','Tan ','Fei ','Cang ','Wi ','Kwan ','E ','Nan ','Hun ','Ho ','Huang ','Chel ','Hui ',
        'Cen ','Hwu ','He ','Tang ','Fen ','Wei ','Gu ','Cha ','Song ','Tang ','Bo ','Gao ','Huy ','Kwey ','Liu ','Sou ',
        'Tao ','Ye ','On ','Mo ','Tang ','Man ','Bi ','Yu ','Swu ','Kun ','Can ','Kwey ','Chan ','Sen ','Chi ','Dan ',
        'Uy ','Ki ','Yo ','Cheng ','Ong ','To ','Hui ','Hyang ','Zhan ','Fen ','Hai ','Meng ','Yem ','Mo ','Cham ','Xiang ',
        'Luo ','Zuan ','Nang ','Shi ','Ceng ','Ji ','Tuo ','Xing ','Tun ','Xi ','Ren ','Yu ','Chi ','Fan ','Yin ','Jian ',
        'Shi ','Bao ','Si ','Duo ','Yi ','Er ','Rao ','Xiang ','Jia ','Le ','Jiao ','Yi ','Bing ','Bo ','Dou ','E ',
        'Yu ','Nei ','Jun ','Guo ','Hun ','Xian ','Guan ','Cha ','Kui ','Gu ','Sou ','Chan ','Ye ','Mo ','Bo ','Liu ',
        'Xiu ','Jin ','Man ','Can ','Zhuan ','Nang ','Swu ','Kyu ','Koyk ','Hyang ','Fen ','Ba ','Ni ','Phil ','Bo ','Tu ',
        'Han ','Fei ','Jian ','Am ','Ai ','Pok ','Xian ','Wen ','Hyeng ','Fen ','Bin ','Xing ','Ma ','E ','Phwung ','Han ',
        'Cek ','Tha ','Tuo ','Chi ','Swun ','Zhu ','Zhi ','Pei ','Xin ','Il ','Sa ','Yin ','Wen ','Zhi ','Dan ','Lu ',
        'You ','Pak ','Bao ','Kuai ','Tha ','Yek ','Kwu ','','Kwu ','Kyeng ','Bo ','Zhao ','Yuan ','Peng ','Zhou ','Ke ',
        'Cwu ','No ','Kwu ','Pi ','Zang ','Ka ','Ling ','Zhen ','Tha ','Pwu ','Yang ','Sa ','Phil ','Tha ','Tha ','Sa ',
        'Liu ','Ma ','Pyen ','Tao ','Zhi ','Rong ','Teng ','Dong ','Swun ','Quan ','Sin ','Jiong ','Er ','Hay ','Pak ','',
        'Yin ','Lak ','Shuu ','Dan ','Xie ','Liu ','Ju ','Song ','Chim ','Mang ','Liang ','Han ','Tu ','Hyen ','Tui ','Cwun ',
        ],
    'x9a':[
        'E ','Ping ','Seng ','Ay ','Lok ','Chwu ','Zhou ','She ','Pyeng ','Kun ','Tao ','Lay ','Zong ','Kwa ','Ki ','Ki ',
        'Yan ','Pi ','So ','Hem ','Jie ','Yao ','Mwu ','Pian ','Chong ','Phyen ','Qian ','Pi ','Huang ','Jian ','Huo ','Yu ',
        'Ti ','Quan ','Xia ','Zong ','Kui ','Rou ','Si ','Gua ','Tuo ','Kui ','Sou ','Ken ','Cheng ','Cul ','Liu ','Pang ',
        'Tung ','Xi ','Cao ','Du ','Yan ','Wen ','Chwu ','So ','Sen ','Li ','Zhi ','Shuang ','Lu ','Xi ','La ','Zhang ',
        'Mayk ','O ','Cham ','Phyo ','Chong ','Kwu ','Bi ','Zhi ','Yu ','Xu ','Hwa ','Bo ','Swuk ','Hyo ','Lin ','Can ',
        'Dun ','Liu ','Than ','Zeng ','Tan ','Kyo ','Tie ','Hem ','La ','Zhan ','Kyeng ','Yek ','Ye ','Tuo ','Bin ','Chwi ',
        'Yan ','Peng ','Lye ','Teng ','Yang ','Ki ','Shuang ','Ju ','Xi ','Hwan ','Lye ','Biao ','Ma ','Yu ','Tuo ','Xun ',
        'Chi ','Qu ','Il ','Bo ','Lu ','Zang ','Shi ','Si ','Fu ','Ju ','Zou ','Zhu ','Tuo ','Nu ','Jia ','Yi ',
        'Tai ','Xiao ','Ma ','Yin ','Jiao ','Hua ','Luo ','Hai ','Pian ','Biao ','Li ','Cheng ','Yan ','Xin ','Qin ','Jun ',
        'Qi ','Qi ','Ke ','Zhui ','Zong ','Swuk ','Can ','Pian ','Zhi ','Kui ','Sao ','Wu ','Ao ','Liu ','Qian ','Shan ',
        'Piao ','Luo ','Cong ','Chan ','Zou ','Ji ','Shuang ','Xiang ','Kol ','Wei ','I ','I ','Yu ','Gan ','Yi ','Hang ',
        'Thwu ','Xie ','Bao ','Bi ','Chi ','Ti ','Cey ','Ko ','Hay ','Kyo ','Gou ','Kua ','Kyek ','Tui ','Geng ','Pyen ',
        'Pi ','Kwa ','Ka ','Yu ','Sui ','Lou ','Pak ','Xiao ','Pang ','Bo ','Ci ','Kuan ','Bin ','Mo ','Liao ','Lwu ',
        'Nao ','Chok ','Cang ','Swu ','Chey ','Pin ','Kwan ','Lo ','Ko ','Ko ','Qiao ','Kao ','Qiao ','Lao ','Zao ','Phyo ',
        'Kun ','Kon ','Ti ','Pang ','Xiu ','Yem ','Mo ','Dan ','Kun ','Bin ','Fa ','Cho ','Pi ','Ca ','Pal ','Yem ',
        'Chey ','Pao ','Phi ','Mao ','Pwul ','Er ','Rong ','Qu ','','Hyu ','Kwal ','Kyey ','Peng ','Cwa ','Shao ','Sha ',
        ],
    'x9b':[
        'Ti ','Li ','Pin ','Zong ','Ti ','Pwul ','Song ','Zheng ','Kwen ','Zong ','Swun ','Cen ','Duo ','Ho ','La ','Jiu ',
        'Ki ','Lian ','Cin ','Bin ','Peng ','Mo ','Sam ','Man ','Man ','Sung ','Swu ','Lie ','Qian ','Qian ','Nong ','Hwan ',
        'Kwal ','Ning ','Pin ','Lyep ','Rang ','Dou ','Dou ','Lyo ','Hong ','Hyek ','Thwu ','Han ','Dou ','Dou ','Kwu ','Cheng ',
        'Wul ','Wul ','Kyek ','Juan ','Fu ','Qian ','Gui ','Zong ','Liu ','Gui ','Sang ','Yu ','Kwi ','Mei ','Ji ','Qi ',
        'Jie ','Koy ','Hon ','Pal ','Payk ','May ','Xu ','Yan ','So ','Liang ','Yu ','Chwu ','Qi ','Mang ','Lyang ','Wi ',
        'Jian ','Li ','Piao ','Bi ','Ma ','Ji ','Xu ','Chou ','Yem ','Zhan ','E ','Dao ','In ','Ji ','Eri ','Gong ',
        'Tuo ','Diao ','Ji ','Xu ','E ','E ','Sa ','Hang ','Tun ','Mo ','Jie ','Shen ','Fan ','Yuan ','Bi ','Lo ',
        'Wen ','Hu ','Lu ','Za ','Pang ','Fen ','Na ','You ','Namazu ','Todo ','He ','Xia ','Qu ','Han ','Pi ','Ling ',
        'Tha ','Bo ','Qiu ','Phyeng ','Fu ','Bi ','Ji ','Wei ','Ju ','Diao ','Bo ','You ','Gun ','Pi ','Cem ','Xing ',
        'Thay ','Pho ','Pwu ','Ca ','Ju ','Gu ','Kajika ','Tong ','','Ta ','Kil ','Shu ','Hou ','Sang ','I ','An ',
        'Wei ','Tiao ','Zhu ','Yin ','Lie ','Luo ','Tong ','Cey ','Ci ','Bing ','Yu ','Kyo ','Bu ','Hay ','Sen ','Ge ',
        'Hui ','Bora ','Mate ','Kao ','Gori ','Duo ','Jun ','Ti ','Mian ','So ','Za ','Sha ','Qin ','Yu ','Nei ','Zhe ',
        'Kon ','Kyeng ','','Wu ','Qiu ','Ting ','Pho ','Hon ','Tiao ','Li ','Sa ','Sa ','Gao ','Meng ','Ugui ','Asari ',
        'Subashiri ','Kazunoko ','Yong ','Ni ','Chi ','Qi ','Cheng ','Xiang ','Nei ','Chun ','Ji ','Co ','Qie ','Ko ','Zhou ','Dong ',
        'Lai ','Pi ','Yey ','Yi ','Kon ','Lu ','Jiu ','Chang ','Kyeng ','Lun ','Lung ','Chwu ','Li ','Meng ','Zong ','Zhi ',
        'Nian ','Shachi ','Dojou ','Sukesou ','Shi ','Shen ','Hun ','Cey ','Hou ','Xing ','Zhu ','La ','Zong ','Cuk ','Bian ','Phyen ',
        ],
    'x9c':[
        'Huan ','Quan ','Ze ','Wei ','Wei ','Yu ','Qun ','Rou ','Cep ','Hwang ','Lyen ','Yan ','Chwu ','Chwu ','Jian ','Bi ',
        'Ak ','Yang ','Pok ','Say ','Jian ','Ha ','Tuo ','Hu ','Muroaji ','Ruo ','Haraka ','Wen ','Jian ','Hao ','Wu ','Fang ',
        'Sao ','Liu ','Ma ','Si ','Sa ','Hwan ','Shi ','Teng ','Thap ','Yo ','Ge ','Rong ','Qian ','Ki ','On ','Yak ',
        'Hatahata ','Lyen ','O ','Luk ','Hui ','Min ','Ji ','Co ','Qu ','Kyen ','So ','Man ','Xi ','Qiu ','Phyo ','Ji ',
        'Ji ','Zhu ','Jiang ','Qiu ','Zhuan ','Yong ','Zhang ','Kang ','Sel ','Pyel ','Jue ','Qu ','Xiang ','Bo ','Jiao ','Sim ',
        'Su ','Huang ','Cwun ','Sen ','Sen ','Fan ','Kwel ','Lin ','Sim ','Miao ','Xi ','Eso ','Kyou ','Pwun ','Guan ','Hwu ',
        'Hoy ','Zei ','Sao ','Cen ','Gan ','Gui ','Sheng ','Lyey ','Chang ','Hatahata ','Shiira ','Ai ','Ru ','Cey ','Xu ','Huo ',
        'Shiira ','Li ','Lie ','Li ','Mie ','Zhen ','Xiang ','E ','Lo ','Guan ','Lye ','Sen ','Yu ','Dao ','Ji ','You ',
        'Tun ','Lu ','Fang ','Ba ','He ','Bo ','Ping ','Nian ','Lu ','You ','Zha ','Fu ','Bo ','Bao ','Hou ','Pi ',
        'Tai ','Gui ','Jie ','Kao ','Wei ','Er ','Tong ','Ze ','Hou ','Kuai ','Ji ','Jiao ','Xian ','Za ','Xiang ','Xun ',
        'Geng ','Li ','Lian ','Jian ','Li ','Shi ','Tiao ','Gun ','Sha ','Wan ','Jun ','Ji ','Yong ','Qing ','Ling ','Qi ',
        'Zou ','Fei ','Kun ','Chang ','Gu ','Ni ','Nian ','Diao ','Jing ','Shen ','Shi ','Zi ','Fen ','Die ','Bi ','Chang ',
        'Shi ','Wen ','Wei ','Sai ','E ','Qiu ','Fu ','Huang ','Quan ','Jiang ','Bian ','Sao ','Ao ','Qi ','Ta ','Yin ',
        'Yao ','Fang ','Jian ','Le ','Biao ','Xue ','Bie ','Man ','Min ','Yong ','Wei ','Xi ','Jue ','Shan ','Lin ','Zun ',
        'Huo ','Gan ','Li ','Zhan ','Guan ','Co ','Ul ','Pwu ','Li ','Kwu ','Bu ','Yan ','Pwu ','Diao ','Kyey ','Pong ',
        'Nio ','Gan ','Shi ','Pong ','Myeng ','Bao ','Yen ','Zhi ','Hu ','Qin ','Fu ','Fen ','Wen ','Jian ','Shi ','Yu ',
        ],
    'x9d':[
        'Fou ','Yao ','Jue ','Kyek ','Pi ','Huan ','Cim ','Po ','An ','A ','Zheng ','Fang ','Pong ','Wen ','Ou ','Te ',
        'Jia ','Nu ','Lyeng ','Mie ','Fu ','Tha ','Wen ','Li ','Pyen ','Chi ','Ge ','Wen ','Zi ','Qu ','Xiao ','Chi ',
        'Dan ','Ju ','You ','Ko ','Zhong ','Yu ','Ang ','Rong ','Ap ','Tie ','Yu ','Shigi ','Ying ','Zhui ','Wu ','Er ',
        'Kwal ','Ai ','Zhi ','Yan ','Heng ','Jiao ','Al ','Lie ','Zhu ','Ren ','Yi ','Hong ','Luo ','Ru ','Mou ','Ge ',
        'Ren ','Kyo ','Hyu ','Zhou ','Chi ','Luo ','Chidori ','Toki ','Ten ','Luan ','Jia ','Ji ','Yu ','Huan ','Tuo ','Bu ',
        'Wu ','Kyen ','Yu ','Pal ','Cwun ','Xun ','Bi ','Xi ','Jun ','Ju ','Tu ','Jing ','Cey ','A ','A ','Kuang ',
        'Kok ','Mwu ','Shen ','Lai ','Ikaruga ','Kakesu ','Lu ','Ping ','Shu ','Pok ','An ','Zhao ','Pwung ','Qin ','Qian ','Phil ',
        'Co ','Lu ','Cak ','Jian ','Ju ','Tu ','Ya ','Wen ','Qi ','Li ','Ye ','Chwu ','Kong ','Zhui ','Kon ','Sheng ',
        'Qi ','Jing ','Yi ','Yi ','Cheng ','Zi ','Lai ','Dong ','Qi ','Swun ','Geng ','Ju ','Qu ','Isuka ','Kikuitadaki ','Ji ',
        'Shu ','','Chi ','Miao ','Rou ','An ','Chwu ','Ti ','Hu ','Ti ','Ak ','Jie ','Mao ','Fu ','Chun ','Tu ',
        'Yan ','Kal ','Yuan ','Pian ','Kon ','Mei ','Hu ','Ying ','Dun ','Mok ','Ju ','Tsugumi ','Cheng ','Fang ','Gu ','Ayng ',
        'Yuan ','Xuan ','Weng ','Shi ','Hak ','Chwu ','Tang ','Xia ','Yak ','Lyu ','Ji ','Kol ','Jian ','Zhun ','Han ','Ca ',
        'Zi ','Ik ','Yo ','Yan ','Kyey ','Li ','Tian ','Kwu ','Ti ','Ti ','Ni ','Tu ','Ma ','Jiao ','Gao ','Tian ',
        'Chen ','Li ','Zhuan ','Ca ','Ao ','Yao ','Yey ','Kwu ','Chi ','Ci ','Liao ','Rong ','Lou ','Bi ','Shuang ','Zhuo ',
        'Yu ','Wu ','Jue ','Yin ','Quan ','Si ','Cho ','Yi ','Hua ','Pyel ','Ayng ','Swuk ','Huang ','Fan ','Jiao ','Liao ',
        'Yen ','Ko ','Chwi ','Han ','Xian ','Tu ','Mai ','Zun ','Hul ','Ung ','Lo ','Tuan ','Xian ','Hak ','Yi ','Pyek ',
        ],
    'x9e':[
        'Shu ','Luo ','Qi ','Yi ','Ji ','Zhe ','Yu ','Cen ','Ye ','Yang ','Pi ','Ning ','Huo ','Mi ','Ying ','Mong ',
        'Di ','Yue ','Yu ','Lei ','Bao ','Lo ','He ','Long ','Shuang ','Yue ','Ayng ','Kwan ','Kwu ','Li ','Lan ','Niao ',
        'Jiu ','Ji ','Yuan ','Ming ','Shi ','Ou ','Ya ','Cang ','Bao ','Zhen ','Gu ','Dong ','Lu ','Ya ','Xiao ','Yang ',
        'Ling ','Zhi ','Qu ','Yuan ','Xue ','Tuo ','Si ','Zhi ','Er ','Gua ','Xiu ','Heng ','Zhou ','Ge ','Luan ','Hong ',
        'Wu ','Bo ','Li ','Juan ','Hu ','E ','Yu ','Xian ','Ti ','Wu ','Que ','Miao ','An ','Kun ','Bei ','Peng ',
        'Qian ','Chun ','Geng ','Yuan ','Su ','Hu ','He ','E ','Gu ','Chwu ','Zi ','Mei ','Mu ','Ni ','Yao ','Weng ',
        'Liu ','Ji ','Ni ','Jian ','He ','Yi ','Ying ','Zhe ','Liao ','Liao ','Jiao ','Jiu ','Yu ','Lu ','Xuan ','Zhan ',
        'Ying ','Huo ','Meng ','Guan ','Shuang ','Lo ','Kung ','Lyeng ','Jian ','Ham ','Cuo ','Kem ','Jian ','Yem ','Cuo ','Lok ',
        'Wu ','Cu ','Kwey ','Biao ','Chwu ','Biao ','Zhu ','Kyun ','Cwu ','Jian ','Mi ','Mi ','Wu ','Liu ','Chen ','Kyun ',
        'Lin ','Yey ','Ki ','Lok ','Jiu ','Jun ','Jing ','Li ','Xiang ','Yan ','Jia ','Mi ','Li ','Sa ','Cang ','Lin ',
        'Jing ','Ji ','Ling ','Yan ','Chwu ','Mayk ','Mayk ','Ge ','Chao ','Pwu ','Myen ','Mian ','Fu ','Pao ','Qu ','Kwuk ',
        'Mo ','Fu ','Xian ','Lai ','Kwuk ','Myen ','','Feng ','Fu ','Kwuk ','Myen ','Ma ','Ma ','Ma ','Hwi ','Ma ',
        'Zou ','Nen ','Fen ','Hwang ','Hwang ','Kum ','Guang ','Tian ','Tou ','Heng ','Xi ','Kuang ','Hoyng ','Se ','Lye ','Cem ',
        'Li ','Huk ','Huk ','Yi ','Kem ','Dan ','Ki ','Tuan ','Mwuk ','Mo ','Kyem ','Tay ','Chwul ','Yu ','Cem ','I ',
        'Hil ','Yan ','Qu ','Mei ','Yan ','Kyeng ','Yu ','Li ','Tang ','Du ','Can ','Yin ','An ','Yan ','Tam ','Am ',
        'Zhen ','Dai ','Cham ','Yi ','Mi ','Tam ','Yem ','Tok ','Lu ','Zhi ','Pwun ','Pwul ','Po ','Min ','Min ','Wen ',
        ],
    'x9f':[
        'Chwuk ','Qu ','Co ','Wa ','Cwu ','Zhi ','Mang ','O ','Pyel ','Tha ','Pyek ','Yuan ','Chao ','Tuo ','Ceng ','Mi ',
        'Nay ','Ding ','Zi ','Ko ','Gu ','Tong ','Fen ','To ','Yuan ','Pi ','Chang ','Gao ','Qi ','Yuan ','Tang ','Teng ',
        'Se ','Shu ','Pwun ','Fei ','Wen ','Ba ','Diao ','Tuo ','Tong ','Qu ','Sheng ','Sek ','Yu ','Shi ','Ting ','O ',
        'Nian ','Jing ','Hun ','Ju ','En ','Tu ','Ti ','Hyey ','Kyem ','En ','Lei ','Pi ','Yao ','Kwu ','Han ','Wu ',
        'Wu ','Hou ','Xi ','Ge ','Cha ','Xiu ','Weng ','Zha ','Nong ','Nang ','Ca ','Cay ','Ji ','Zi ','Cay ','Cey ',
        'Qi ','Ji ','Chi ','Chen ','Chin ','Hul ','Ya ','Un ','Xie ','Pho ','Cuo ','Shi ','Cha ','Chi ','Nian ','Ce ',
        'Cho ','Lyeng ','Ling ','Chek ','Quan ','Xie ','Kan ','Sel ','Jiu ','Kyo ','Chak ','Kon ','E ','Chu ','Yi ','Ni ',
        'Cuo ','Zou ','Wu ','Nen ','Xian ','Ou ','Ak ','Ak ','Yi ','Chuo ','Zou ','Dian ','Chu ','Jin ','Ya ','Chi ',
        'Chen ','He ','Ken ','Ju ','Ling ','Pao ','Tiao ','Zi ','Ken ','Yu ','Chuo ','Qu ','Wo ','Lyong ','Pang ','Gong ',
        'Pang ','Yan ','Lyong ','Long ','Kong ','Kam ','Ta ','Ling ','Ta ','Long ','Gong ','Kan ','Kwu ','Chwu ','Pyel ','Gui ',
        'Yak ','Chwi ','Hwa ','Jue ','Hay ','Yu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Shan ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'xf9':[
        'Kay ','Kayng ','Ke ','Ko ','Kol ','Koc ','Kwi ','Kwi ','Kyun ','Kul ','Kum ','Na ','Na ','Na ','Na ','Na ',
        'Na ','Na ','Na ','Na ','Nak ','Nak ','Nak ','Nak ','Nak ','Nak ','Nak ','Nan ','Nan ','Nan ','Nan ','Nan ',
        'Nan ','Nam ','Nam ','Nam ','Nam ','Nap ','Nap ','Nap ','Nang ','Nang ','Nang ','Nang ','Nang ','Nay ','Nayng ','No ',
        'No ','No ','No ','No ','No ','No ','No ','No ','No ','No ','No ','Nok ','Nok ','Nok ','Nok ','Nok ',
        'Nok ','Non ','Nong ','Nong ','Nong ','Nong ','Noy ','Noy ','Noy ','Noy ','Nwu ','Nwu ','Nwu ','Nwu ','Nwu ','Nwu ',
        'Nwu ','Nwu ','Nuk ','Nuk ','Num ','Nung ','Nung ','Nung ','Nung ','Nung ','Twu ','La ','Lak ','Lak ','Lan ','Lyeng ',
        'Lo ','Lyul ','Li ','Pey ','Pen ','Pyen ','Pwu ','Pwul ','Pi ','Sak ','Sak ','Sam ','Sayk ','Sayng ','Sep ','Sey ',
        'Sway ','Sin ','Sim ','Sip ','Ya ','Yak ','Yak ','Yang ','Yang ','Yang ','Yang ','Yang ','Yang ','Yang ','Yang ','Ye ',
        'Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Yek ','Yek ','Yek ','Yek ','Yen ','Yen ',
        'Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yel ','Yel ','Yel ','Yel ',
        'Yel ','Yel ','Yem ','Yem ','Yem ','Yem ','Yem ','Yep ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ',
        'Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yey ','Yey ','Yey ','Yey ','O ','Yo ','Yo ','Yo ','Yo ','Yo ','Yo ',
        'Yo ','Yo ','Yo ','Yo ','Yong ','Wun ','Wen ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ',
        'Yu ','Yuk ','Yuk ','Yuk ','Yun ','Yun ','Yun ','Yun ','Yul ','Yul ','Yul ','Yul ','Yung ','I ','I ','I ',
        'I ','I ','I ','I ','I ','I ','I ','I ','I ','I ','I ','Ik ','Ik ','In ','In ','In ',
        'In ','In ','In ','In ','Im ','Im ','Im ','Ip ','Ip ','Ip ','Cang ','Cek ','Ci ','Cip ','Cha ','Chek ',
        ],
    'xfa':[
        'Chey ','Thak ','Thak ','Thang ','Thayk ','Thong ','Pho ','Phok ','Hang ','Hang ','Hyen ','Hwak ','Ol ','Huo ','','Coc ',
        'Chong ','','Cheng ','','','Huy ','Ce ','Ik ','Lyey ','Sin ','Sang ','Pok ','Ceng ','Ceng ','Wu ','',
        'Hagi ','','Cey ','','','Il ','To ','','','','Pan ','Sa ','Kwan ','Hak ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x200':[
        'Ha ','Qi ','','','','Hai ','','','','Qiu ','','','','Shi ','','',
        '','','','','jue ','','','','','','','yu ','','','','',
        '','','','','','','','Ba ','Cup ','','Kha ','','','','','',
        '','','','','Trut ','','','','','','','','','lu ','','',
        '','','','','','','','','','','','','','','','',
        '','Duoi ','','','','','','','','','Cui ','','','','','',
        '','','','','','Ga ','','','','','Nham ','','','','','',
        '','','','','','','','','Suot ','','','','','','','',
        '','','','','','','','','jie ','','','','','','','',
        '','','','','Zi ','','','','','','','','','Zung ','','',
        '','','Pai ','','Dui ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','jiu ','','','','','',
        ],
    'x201':[
        'Vu ','','','','','','','','','','','','','jie ','','',
        '','jue ','','','','','','','','','','','','','','',
        '','','','','','','Gop ','Vai ','','Hai ','','','','','','',
        '','','','Kep ','','','Nham ','','','','','Lam ','Nam ','Vai ','','wei ',
        '','','jie ','','','','','','','','','','','Mat ','Mat ','',
        'Mat ','','Mat ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','zhang ','','','Mat ','','','',
        '','','','','','','','','','','','','Yong ','','','',
        'xu ','','','','','','','','','','','','','','','',
        '','','','','','','','','','Faan ','','','','','','',
        '','','','Trum ','','','dan ','','','','','','','','','',
        '','','','','','','','','','','','','','Voi ','','',
        '','','','','','Va ','','','chu ','','','','','','','',
        '','','','','','','','','','','','','','','','qu ',
        '','','','','','','','','','','','','Hua ','Top ','','',
        ],
    'x202':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','yun ','','','','','','','','','','','',
        'dan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Nay ','',
        'Tray ','','','','','','','ju ','','du ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','jian ','','','','','','','','Ngai ','','Nho ','Thay ','','',
        '','','','','','','','Bing ','','zhuan ','shu ','','jue ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','lian ','','','','','','','','she ','',
        '','','','','','May ','Mu ','','','fu ','','','ju ','','','',
        '','','','','','','','','','','Tao ','','','','','',
        ],
    'x203':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Wu ','','','','','','','','shuai ','','',
        'gai ','','','','zhuang ','','','','','','','','','fu ','','',
        '','Man ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','But ','','','','','yao ','','','','Gap ','','bie ',
        '','','qu ','','','yang ','','','','','','','','sha ','','',
        '','','','','','','','','','','Xum ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Cap ','Bay ','','','','','jue ','',
        '','','','yu ','','','','sa ','','','','dun ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','xiao ','','','','','yu ','qu ','','','','',
        '','','','','','Ngai ','','','','','','','','Tui ','','',
        '','','','Giong ','','','','','','','','','','','','',
        ],
    'x204':[
        '','meng ','','','','','','','','jie ','shu ','','','su ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','meng ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Trom ','','','Long ','','','','',
        '','','','','','Ngua ','','','','','nei ','nei ','','','zhai ','',
        '','','','','','','','','','','','','Nhau ','','','cu ',
        '','','','','','','','','','','','','','','','',
        '','','','','wu ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Rang ','','','','','','','','','','',
        '','','','','','lian ','','Tin ','','','','','','','fan ','',
        'Truoc ','','','','','','','','','','','','','','','',
        'Quanh ','','','','Mong ','','','fu ','','','','','','','','',
        '','','','','','','','','Vao ','Nhui ','','','','','','',
        '','','','','','','','','','Lon ','','Tron ','Sip ','','','',
        ],
    'x205':[
        '','','','Xi ','','','','','','Juan ','','','','','','',
        '','hai ','','','','lun ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','heng ','','','','','','','','','Zheng ','','','','',
        '','','','','Nap ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'cheng ','','','qia ','','','yu ','','','','','','','zhao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Xuong ','','','','','','','',
        '','','','','','','','','Nap ','','','','','','','',
        '','','','','Bay ','Chong ','','','','','','','','','','Ngat ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','qiu ','xie ','','','','','','',
        '','','','','','','','','','','','die ','','','','',
        '','','','Lun ','','','Ping ','','die ','','','','','','','',
        'Tron ','','','','','','','','','Ret ','','','','liu ','','',
        ],
    'x206':[
        '','bu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','lai ','','',
        '','','he ','jiao ','','','','','','','','','','','','',
        '','','','','','','','','','','','wu ','','','','',
        '','','','','','','ju ','','','','','','','','','',
        '','','','','jiu ','wei ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','xian ','','','','chang ','','','','','',
        'Moc ','','','','he ','','','','','','','','','','','',
        '','','Ra ','','','','','','','','','','','','','Got ',
        '','zhe ','','','','ju ','','','','Shan ','Sha ','','','','','',
        '','','','','','','','','','','','','Cham ','','','',
        '','','','','','','','','','cu ','','','','','','',
        '','','','','Chem ','','','','','','Tiu ','','','','','',
        '','','','','','','','','fen ','','','','','','','',
        ],
    'x207':[
        '','','','jiu ','xu ','','','','','','','','','','Xian ','',
        'kuai ','','','','','','','','','bu ','','','','','','',
        '','','','','qia ','','','','','','','','','','Hui ','',
        '','Pai ','','','','','','','','ju ','','','Qia ','','','',
        '','','','','','','','Bao ','','','','','','','','',
        '','','','','','Cun ','','','qia ','','','','','','','',
        '','','','','','','','','','','','','','Peng ','','',
        '','','','','','','','','','Gaai ','','','','','','',
        '','','','zhe ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Got ','Bam ','','','','','','','','','','gun ','Lou ','','',
        'Jiao ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','yao ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Hoat ','','','','','','','','','','',
        '','','','','','','','','','','','ze ,bai','','','','',
        ],
    'x208':[
        '','','','','zhao ','','','','','Bua ','','','','','','',
        '','Tet ','','','du ','','','','','','','','','','','',
        'du ','','','','','','','','','Truoc ','','','','Chom ','','die ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Gang ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','duan ','','','','','','','','','Khuot ','','','','','',
        '','','','','','','','han ','','','','','','','','',
        '','Nhoc ','','','','','','','','','juan ','','','Vam ','Giup ','Giup ',
        '','','','dian ','Jue ','','','','','','','','Lu ','','','',
        '','','','','','','','','','','','','','','','',
        '','','Ruon ','','','','','','','10383.060,wan ','','','','','','',
        'yun ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','qu ','shao ','','','','',
        '','','','pao ','','','','','','','bao ','','','','fu ','jiu ',
        ],
    'x209':[
        '','','','','','','Cho ','','','','','','Cho ','','hua ','Bao ',
        '','','','','','','','','','','','','','mao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','diao ','','','',
        '','','','','','','','','','','','','','','wei ','',
        '','diao ','','','','','','','','','','','','','','',
        '','','','','Giau ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','sa ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','luan ','Muoi ','','','','','','Gan ',
        '','','','','','','','','','Chuc ','','Lung ','','','','',
        '','','','','','','Tron ','yu ','','','','','','Nhu ','','',
        '','','','','','he ','','','','shao ','','','','','','',
        '','','','','','','','','','Hui ','','','','','','',
        '','','','','','','','','','','','','','','','heng ',
        ],
    'x20a':[
        '','','','wai ','','','','','','','jue ','','','','zhuan ','',
        '','','','','','','','','','','','','','','','',
        '','','jun ','','','','','','','','','','','ju ','','',
        '','','','','','bang ','','','','','','','','','','',
        '','','','','','','','','zhu ','','','','','','','',
        '','','','','','Me ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Li ','','','','','',
        '','','','mei ','','','','','','','','','','','','',
        'liu ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','jue ','','Day ','','','','','','','','','','Rot ',
        '','','','','','','','','','','','','','','','',
        '','','','yu ','','','','','','','','','','','tu ','',
        '','','','','','','','','','shan ','','','','','','',
        ],
    'x20b':[
        '','','','','','','guan ','','','','','','','','','',
        '','','Cut ','','','','','','','','','Mo ','','fu ','','',
        'Mot ','','','bang ','','','','','','','biao ','','','','jie ','',
        '','','','','','','Jin ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Zhuo ','','','','','bian ','','','','','','tun ',
        '','','','','','','','','','','de ','','zhu ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Naai ','Leo ','','','','','','',
        '','','','','','mang ','','','','','','','','','Ngot ','sa ,san',
        '','','','','','','','','Daai6','','','Jai ','','','','',
        '','','','zhe ','','','','','ban ','jie ','','','','','','',
        '','','','','','','Thet ','','','','','','','','Hin ','pian ',
        '','','','','bian ','','','reng ','','reng ','','','Danh ','Chui ','','',
        ],
    'x20c':[
        '','','Ngoen ','','','','','','','','','Jaau ','Mut ','','','Mom ',
        '','an ','','he ','','','','','','Khen ','','hu ,gao','','','','',
        '','','','','','','','','','','','','','Meo ','','',
        '','','Eot ','','','','','Lo ','','','dai ','wai ,wai','','','','',
        '','Tam ','Dat ','Nip ','','Quai ','','','','','','','','Phom ','','',
        '','','','Ngai ','','','','','Ngaak6','','','','Chun ','','','',
        '','sa ,shai','','','','Fik ','','','','','','','','','','',
        '','','na ','','','','','Ming ','San ','','','','','','','',
        '','','','','','','','','','','','','shu ','','','Nham ',
        '','','','Hang ','','','E ','','','','','','Gianh ','','','',
        '','','','','','','Nhung ','','','','','','','','Khinh ','',
        '','ge ','','','','Mep ','','die ','','','','','','fu ','','Shu ',
        '','Kwan ','','','','','','he ','','','','','qia ','','','Ce ',
        'Vang ','','','','','Caau ','Dap6','','Nhu ','Thay ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Tu ','','','','','','','cheng ','','',
        ],
    'x20d':[
        '','','','','','','','','','','','Phao ','Nhanh ','Nhan ','','Mang ',
        'Nuc ','','','','','Miu ','Voi ','','','','','Gung ','','','','',
        '','xiao ','','','','Ngoam ','zhu ','','','','','Thut ','','','','',
        'Gau6','hu ','ta ','Ngaau ','','zao ','','','','','','','dao ','','na ','',
        '','','','','','','Daam ','Koe ','Mui ','Hong ','','','','','','',
        'Mep ','','','','','','','','Mun ','','','','','','','',
        '','','','ya ','','','','zhen ,chun','de ','Go ','','','','','','Gwit ',
        '','E ','','','','','','xuan ','','','','','Mang ','Faat ','Waak ','Pe ',
        'Tham ','Nhu ','','','','','','','Se ','','Pha ','','','','','',
        '','U ','','','','Nhau ','Uong ','','Sat ','Bop ','','','Zai ','','','',
        '','Troi ','Du ','Mai ','','Khung ','','Dim6','','','','da ','nang ','','','Chut ',
        '','','Gap6','','','','','','jue ','he ','','','','','','',
        '','','dai ','','','zhu ','','','','','','','','ta ','','',
        '','','','','','','bian ','','','xu ','','','','','','',
        '','','','','Phao ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x20e':[
        '','pai ','Giot ','','Inh ','','','','','Kak ','Tap ','','','Me ','Naa ','Ge ',
        'Kam ','Soek ','Bou ','','','','','Xua ','Tuc ','Song ','','','','','','Bai ',
        '','','','','','','Khan ','','','','','Tau ','','','','',
        '','','','','','','','','','yu ','Ngaak6','','','','Map ','',
        'xun ','wa ','','ang ','han ','','','','','','','','Lan ','','','',
        '','yao ','','ge ','','bao ','','','xu ','','','','','','','',
        '','','','','','','','','','','','','','Ko ','','',
        '','','','Git6','','','','Ngo ','Kam ','Lan ','Maai ','Zam6','','Cay ','','',
        '','','','','','','','','','','','','Gwe ','','','',
        'huan ','','','','','','','','Long ','Thoi ','Ban ','','','Gaak ','','ku ',
        'Lung ','','Gaa ','','','','','','','Trou ','He ','Loe ','He ','','','',
        '','Hung ','','','','Chac ','Nop ','','','Ri ','Que ','Cop ','Xui ','','Chau ','Ngoan ',
        '','Guong ','Ngon ','Han ','Oang ','','','','','','','','','huan ','','zu ',
        '','','','','','','','Le ','Zeot6','he ','','','','','','',
        '','','','','Don ','zhao ','','','','','','','tu ','','','',
        '','','','','Long ','','','','','','Aa6','Bai ','Dau6','','','',
        ],
    'x20f':[
        '','','','','','','','','','','','','','','','',
        '','','','','','Paai ','','Zaam ','wu ','','','','','','','',
        '','','jiang ,qiang','','','','Muon ','','','lun ','Day ','','','But ','Ngai ','Ho ',
        'Kang ','Loe ','','','','Danh ','','Thay ','','','','Ji ','','','','',
        '','Xo ','','Zap ','Tham ','Thung ','Nuot ','','','','','Nac ','Toet ','','Nhai ','',
        'Ngo ','','Neng ','Ngon ','Thua ','','Giuc ','','','','','Oam ','','','','',
        '','','','','Kik ','','','','','','','','','','','',
        '','','','','','yu ','','','','','','zhe ','','','','',
        'Hup ','','','','','','','','','','','','','He ','','Ce ',
        '','','','','','','','','','','','Ngoang ','','','','',
        '','','shu ','Rum ','','','Bai ','','','la ','','','','We ','','',
        '','','','','Baang ','Zaa ','Ging ','','','Nuot ','','','Cyut ','Nhun ','Nhap ','',
        '','Si ','Xep ','','','','','','','','','','','','','',
        '','','Het ','sa ','','qiao ','','','','','','Lu ','hua ','','','',
        '','','','','','','','','','','Gaa ','Saau ','Soe ','Wet ','','Ngui ',
        '','','','','','Khan ','','','','','','','','','','',
        ],
    'x210':[
        '','','','','','','','','','','','','','','','',
        '','','','','Lu ','','','','','','','','','Nam6','Zip ','',
        'Bei6','','','','','Phao ','','','','Lok ','','Bam ','','','','',
        '','Hao ','Cay ','','','','','Ron ','','','xie ','','','','','',
        'han ','','','','','','','','fan ','','','','','ai ','yu ','Am ',
        '','','','','','','','','','','Hon ','','Wo ','Hang ','Xao ','',
        '','','','','','','','','','','','','','','','Dyut ',
        '','','','zhan ','','Gan ','Zit ','Doeng ','Kwaat ','','Ngon ','Ziu ','','','','',
        'Khao ','','','Hun ','','','','Mom ','Voc ','','yu ','','','Eng ','','',
        '','Ban ','','','','','Lai ','','','','','','','Zuk6','','bao ',
        '','shu ','','','','','','','','','Ze ','peng ','','','Ngau ','',
        'Ran ','','Ray ','Troi ','','','','Khoan ','','','','','','','','',
        'E ','Leng ','','','lai ','','','Bai6','Kwaak ','Gaa ','','','','Chem ','Phan ','Doe6',
        '','','Boc ','Bo ','','Gung ','Le ','Mua ','','Mut ','','','','lun ','','',
        '','','','','Laai6','','','','','','','','','','','',
        '','','','','Ceoi ','Ngung ','Sek ','','','Chen ','','','','','Phac ','Thot ',
        ],
    'x211':[
        '','Lum ','','','','','','','','','','','','Ruc ','Gam ','Ham ',
        '','','dao ','','','','','','','','','','','','','Haa ',
        '','Chay ','','','','','Lom ','','','Khan ','Toe ','Khem ','Hun ','','','Jik ',
        'Tot ','cu ','ru ','','','Ji ','','','','luan ','','','','Soe ','','',
        '','','','','','e ,ei','','','Laa ','Dang ','Bun ','Hum ','','','','Lai ',
        'Lanh ','Ngong ','','','','','','','la ','yun ','','','','','','',
        '','','','','','die ','','Nan ','','','','','Hoai ','','','',
        '','huan ','','','','','','','','','','huan ','','','','',
        'Gwang ','Nhau ','','','Nhep ','wan ','','Wok ','','','','','','','','',
        '','Nham ','','','','lian ','Trom ','','','','Gu ','','','','Giau ','',
        '','','','','','jiu ','','','','','','','','','','',
        'dun ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','die ','','','','','','Doe ','','','','','he ','',
        'zhe ','','','','','','wei ','','','tu ','','','','','','hun ',
        '','','','','','dang ','he ','tai ','Quay ','','yu ','Nhot ','ya ','','','',
        ],
    'x212':[
        '','','','','','jue ','','','','','','','','','Mui ','',
        '','','','yuan ','','','','','','You ','','','','','','',
        '','','','','','','','','yu ','','','','','','','',
        '','','','','','','lei ','','','','','','','','','',
        '','','','','','','','','','','','','','','Cong ','',
        '','','tun ','','','','Cong ','','','','','','','','','',
        '','','','','','','','','','bao ','','','','','','',
        '','','','','lu ,hu','','','jie ','','','','','','','Tum ','Moc ',
        '','','','','','','','','','','','','','shu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Sanh ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','gao ',
        '','','','','','','','','','de ','','','yu ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x213':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','guai ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'hu ','','','','','','','','Che ','Vung ','Lam ','','Mun ','Nui ','','',
        '','','','','','zhai ','','','du ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','du ','','','','','','',
        '','an ','','','','','','','','','','Bun ','Nam ','','','Hang ',
        '','','','','','','','','','','','','','Thong ','su ','',
        '','','','','Gung ','','','','','','zhu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','xia ','','','','','','','',
        '','Luong ','','','','Tret ','Xay ','Bui ','','','','','','','','bai ',
        '','','','','','','','','','','','','','','','',
        ],
    'x214':[
        '','','','','','','','','','','','','chu ','','','',
        '','','','','','','xian ','Hoc ','','','','','','fu ','','',
        '','','','','','sa ','','','','','','','','','Ve ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Coi ','Chum ','','','','Thoai ','','','','','','Lan ','Sui ','',
        '','','','','','','','','','','','','','Coi ','','',
        '','','Gom ','','','','','','','','','','','','yu ','',
        '','sa ','','Juk ','Lan ','','','','','','yu ','','','ju ','','',
        '','','shu ','xian ','','','gai ','','','','','','','','','',
        '','','','','','','','','','','','Cau ','','','Suong ','',
        '','','','','','','','','','','','','','','','',
        '','','','Loi ','Vung ','','','','','','','','','','','San ',
        '','','lai ','','Lam ','','','','','','','','','','','',
        '','','','','','Chen ','zhan ','','','','','','','','','Chum ',
        '','','','','','','','','','','','','','','','',
        ],
    'x215':[
        '','','','','','','','','','','','','','','','',
        '','','','','Lan ','','','','','','','','','','','',
        '','','','','','','','','','','shu ','','','','','',
        '','','','','yu ','','','','','','','','','','','Trau ',
        '','','','','','','','','','','','','','','','',
        '','','kua ','','','','','hai ','','','','','','','','',
        '','','','','','','','hang ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','yun ','','','','','','','','','','','','','',
        '','','','','','','','','','','guai ','','','','','su ',
        '','Bon ','','','','','','','','','','','','','','',
        '','','Sai ','','','','','','','','','Lam ','','','Tum ','',
        'Muong ','','','','','','','Peng ','','','','','','','','',
        '','','','','','chun ','','','','','','','','','','',
        '','','','','','','','','','fan ','','','','','','',
        ],
    'x216':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','zhe ','Mat ','Lon ',
        'juan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','jie ','','','','','','','bie ','','','','','',
        '','','','','Canh ','Nhon ','','','','','','','','','','',
        '','Bi ','','Xon ','','','','yan ','wei ','','','','hao ','','','',
        '','','','','meng ','','','','','','Lon ','','','','','',
        'jue ','To ','To ','','','','Hai ','','','','','','','','','',
        '','','','','','','','','','zhang ','','da ','','hao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','can ','','',
        '','','','','Nua ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x217':[
        'fan ','','hu ','','','','','','','','','','','','','',
        '','','','','','','','','','','ru ','','','','','',
        '','','','','','','','','','','','','','','','zhe ',
        '','Ji ','gao ','','','','','','','','','','','','','',
        '','','','Bua ','','','','','chu ','','zhe ','','','','','',
        '','','','','Kep ','Va ','','','','','cheng ','','du ','','','nian ',
        '','','','','','','Vu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','cu ','','','pan ',
        'hu ','','','xian ','','','','','','','fu ','nai ','','','','',
        '','','','','','','','','','','','','','','Nen ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','lian ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x218':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','hao ','','yang ','','','','','','fu ','',
        '','','','Cuoi ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'juan ','','Nhang ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','qu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhuan ','','','','','','','','dang ','','','','','','','',
        'Sau ','','','','','','','','','','man ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Sui ','','',
        '','','','','','','','','shu ','','','','','','','',
        '','','','','han ','Ban ','','','','','','','','','','',
        '','','nei ','','','','','','Cuoi ','','','','','','cai ','jie ',
        '','','','','','','','','','','','Sen ','','','','',
        ],
    'x219':[
        '','','','','','','','','','','Chua ','','','','fan ','',
        '','','','Moi ','Moi ','','','zhu ','','na ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','jiao ','','','','Nhat ','xiao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Con ','ju ,ru','','','','','','Me ','','','',
        '','xu ','','','fu ','So ','','','','','','','','','','',
        '','','','','','er ','','','','','','shu ','','','','',
        '','','','','','','','Rot ','','','','Chat ','','','Nhang ','',
        '','','','xiao ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','mian ','','','','','wa ','','pao ','','','','','','',
        '','','','','','','heng ','','zhu ','','','','','','','',
        '','','','','','','','','','dai ','','','','','','',
        ],
    'x21a':[
        '','','','','Xia ','ju ','','','','','','','','','','',
        '','','','','','','','zao ','','','','','','','','',
        '','','','yu ','','','','Tot ','','','','','','','','',
        '','','jie ','','Ning ','nai ','','','','','','','','','','yu ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','jie ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','an ','','','Xum ','','','',
        'ceng ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Sao ','','','','','','','','','','','','','','',
        '','','','','','','Lung ','','','','','','','','','',
        ],
    'x21b':[
        '','','','','','','','','Xuong ','sai ','yu ','jiao ','','','','',
        '','','','','','','','','20960.020,lao ','','','','','','yu ','',
        '','','','','','','','','','','','wu ','','','','',
        '','','','','','','','Tac ','','','','','Gang ','','','',
        '','','de ','','','','','','','Ban ','','','','','','',
        'shuan ','','','','','Cut ','','','','','','','Mon ','','','',
        '','','bai ','','','','','Chut ','','','','','Be ','','','',
        '','Chut ','Trut ','kao ','','','','','luan ','','','Nhon ','','','','',
        '','','','','','','Mon ','Chut ','','Mon ','','May ','Be ','Chut ','','',
        '','','','Choai ','','','','','','nai ','','','','','','',
        'May ','','','Be ','Be ','Be ','Zao ','','','Be ','','Nhen ','Mon ','Nhon ','Mon ','',
        '','','Tho ','','','Chuong ','Chuong ','','Nhon ','','','','','Nhon ','','',
        'Oat ','','','','','','','wu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'ga ','','','','chao ','','','','','','','','','ga ','','',
        ],
    'x21c':[
        '','','','','','hu ','','','','','','','','','','',
        'qiao ','','','','','','','','','','','','','','','',
        '','','xie ','','','','','','','','Duk ','','','','','',
        '','','','','','','','','','','','','','ai ','','pu ',
        '','','','','','','Shu ','','','','','','','','','',
        '','','','','','','','','','','','','zhao ','','','',
        '','','','xu ','','','','','','Thuoc ','','','','','','',
        '','zhu ','','','','','','die ','Gang ','','qu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Ti ','','jue ','','','qiu ','','','','','',
        '','','Ke ','jiang ','','','','','','','yun ','','Gwat6','','','',
        'qu ','','','','','','','','','','','','','','','',
        'Ngoe ','','kai ','Cuoi ','','','','','','','','','','','','',
        '','chu ','','','','','','','ju ','','','','Cuoi ','Rot ','','',
        '','','','','','Toi ','','','','','','','','','','',
        '','','','Cuoi ','lu ','','','','','','','','','','jue ','',
        ],
    'x21d':[
        '','','','','','','lu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','ya ','','',
        '','hu ,jie','','','','','','','','','','','','','','',
        '','','','','','','','','','Ngut ','','','','','','',
        '','','','','','','','','hu ','ang ','','fu ','','','','',
        '','','','','','','','','','','','','mu ','','','',
        '','','','','','','','','','','Cu ','','','','','',
        'Nui ','','yao ','ai ','','','','','','fan ','','ju ','','','','',
        'qie ','','','','','','','','','','','','','','','',
        '','','kuang ','','','','ya ','','Ngan ','','kan ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','','','','','bie ','','','han ','','na ','','',
        '','','','','wu ','gao ','','','','','','','','','','',
        '','','','','','','','','','','','ya ','','','','',
        ],
    'x21e':[
        '','','','','','','','','','','','','zhu ','','jie ','Voi ',
        '','','','','xie ','','','ya ','','','','','','','','',
        '','','','','','','ze ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','ya ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Nghi ','','','','','','','','','','','','','die ','','',
        '','','','','','','','','','hu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','die ','','','','','','','','','','','pen ','','','',
        '','','','','','','Din ','','','','','','','','','',
        '','','','','tu ','','','xia ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Voi ','','Seoi ','Von ','Chon ','','','','','','','','',
        'zhu ','','','','','','','','gun ','man ','','','zu ','','hu ','',
        '','lei ','','','','','','','','','','','','','','',
        ],
    'x21f':[
        '','','','','die ','','','','','','','','','','','',
        '','','','dian ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','wei ','','','','','','','','','','','','','kuai ','',
        '','','','','','yun ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Non ','','','','',
        '','Jie ','bang ','','','','','','','','','','','','','',
        '','','','','','','','kuang ','','','','','','','','',
        '','','','ceng ','','dang ','','','','','','','','','','',
        '','','','','','','','','hai ','','','','Doc ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','nang ','','',
        '','','','','','yu ','','','','','','','','','','yu ',
        '','','','','','','','','','','Nao ','','xun ','','ju ','',
        ],
    'x220':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','wan ','','','','','','','','',
        '','','','','','Vang ','Sua ','Tron ','Sang ','','','','Lon ','','Sam ','',
        '','To ','Lon ','','','han ','','','','','','','fu ','','','',
        'fu ','','','','','','','','','','','Trang ','','Va ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','jue ','','','','','',
        '','','','','','','','','Phuon ','','','bu ','','','','',
        'fu ','','','','xuan ','','fu ','','','','','','','','Du ','',
        'xie ','Shi ','','','','','','','','','','','Vua ','','','',
        '','','','','','','','','','','','','','','','',
        'Tranh ','yuan ','','','','','','','','mao ','qian ','','','','','',
        'wu ','','','','','','','Lei ','Long ','','Vua ','','','','','',
        '','','','','','Ta ','','han ','qian ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','la ','','','','','','','','','','','',
        ],
    'x221':[
        '','','','Phoi ','','','','','','','','','','he ,ge','bang ','',
        'meng ','','','wu ','dai ','','','','','','','','han ','Bau ','','',
        '','','','','','','','cu ','','','','','','','','Man ',
        '','','','','','xiang ','Hua ','','','','','','','','','',
        '','','','','','','Manh ','','','mao ','','ceng ','','','','Lian ',
        '','','dan ','','','','Lian ','','','','','','','dian ','','',
        '','','','','gai ','Ju ','','','','','zu ','','Chan ','','','',
        '','','','','','','','','','yao ','','','nei ','','','',
        '','','neng ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','ge ','','Jian ','',
        'Lai ','Nin ','','','','Nam ','jian ','May ','May ','','May ','','','','','',
        'hu ','','','','','','','','','','chen ','','','','','',
        '','','','','','','','Guan ','yan ','Doi ','','','','','','',
        '','','','','','','','sha ','','','','','','','han ','',
        '','Khuya ','','','','','ren ','','','','fan ','','','','','',
        '','','','','bu ','na ','','','','','','','','','','',
        ],
    'x222':[
        '','','','','','','','','Nap ','','','','','','','',
        '','','','','','bai ','','','Roku ','','','kun ','','qiu ','','',
        'cu ,la','','','','','','','','','','','','','','','',
        '','','pu ','','','','','','','','','jie ','','zhan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','du ,tu','','','',
        '','','hu ','','jia ','','','','la ','','','','','','','',
        '','','','','','','','','','','','','','Kho ','U ','ma ',
        '','','','','','','','','','','','','','Zu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','yu ','','lu ','','','','','','',
        '','fen ','','','','','','','','','','','','','','',
        '','','','','','yu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','xian ','',
        '','','','','','','','','','wu ','','','','','','',
        ],
    'x223':[
        '','','','','qu ','','','','','','Rong ','','Rong ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','fu ','','yu ','','','','',
        '','','','','','','','','','','','','','','gao ','juan ',
        '','','','','','quan ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','die ','','','','','','dai ','','su ','',
        '','','','','jie ','','qu ','','han ','','','','','','','',
        '','jie ','','','','juan ','','','','','dan ','','','','','',
        '','','','','','hu ','','','','jue ','','yu ','','','','',
        '','','','','','','','','','','','','','fu ','','',
        '','Ban ','','','','','','','','','','','','','','',
        '','','Cong ','Cong ','xun ','','','','','','','','','liu ','','',
        '','','','Beng ','','','','jue ','','','','','','','','Von ',
        ],
    'x224':[
        '','','','','yuan ','','','','','','','','','','Khom ','',
        '','','','','','','','','','','','','','','cheng ','',
        '','','','','','','','King ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','jiu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','hu ','','','','','','',
        '','','','','','','','','','','','','','','Bay ','',
        '','','fu ','','chu ','','','','','','','','','','lan ','',
        '','','','','','','','','','','','','','','','',
        'yu ','','','','','','','','','','','','','','jiao ','',
        '','','','','','','','','','','','ang ','','','','',
        '','','','','sa ','','','','','','','','ge ','','','',
        '','','kua ','','','','','','','','','','xie ','','','',
        '','','wu ,hu','','','xiu ','','','','','','','','','','',
        ],
    'x225':[
        '','','yan ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','yu ','','','yu ','','','','','','','yu ','','','',
        '','','liu ','','20832.030,yu ','','','','','','','','','','','',
        '','','','','','shuai ','','','','','','yuan ','','','','',
        '','shuai ','','','','','','','','','','','','','','ao ',
        '','','','','','','','','','','jiao ','','sa ','xian ','zha ','dian ',
        '','','','','','','','','San ','','','shan ','','','','',
        'Suot ','','','','','','','','tiao ','','','','','','','su ',
        '','','','','','Sau ','Sau ','','','','','','','xian ','','',
        '','yu ','','','','','jue ','nang ','','','','','','','','',
        '','','','','','ru ','','','','','','','','','','',
        '','','','','xia ','','','','','Nuoi ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','wu ','','','','','','','chang ','','Lo ','','','',
        ],
    'x226':[
        '','','','','qiu ','Maau ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Rung ','Rap ','',
        '','','','','','','','','Jiang ','','','','','','','',
        '','wu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Hung ','','','','','','','','','Nhon ','E ','Tim ','kan ','',
        '','Lung6','','','','','','','','','','','','','','',
        'xian ','','','','','','ju ','','','','','miao ','','','','',
        '','su ','','','','','Ti ','','','','','','','','','',
        '','','','','','','','','','','hu ','','','','','',
        '','','','','','','','','','Khuay ','','zhu ','Ngop ','','','',
        '','','','qiu ','ya ','','','','','','','','','','bie ','',
        '','','','','','','xiang ','','','','ru ','wang ','','','','ya ',
        '','','','','','','','','yu ','','','','','','','',
        '','','','','Mang ','Zang ','','','','','','','','','','',
        ],
    'x227':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Vung ','','','','','','','','',
        '','','','','','','','','','','','Xing ','Duo ','','','',
        '','','','','','','sao ','','Nao ','','','','','','','jia ',
        'tu ','','du ','','','','','','','','','','mao ','yao ','','',
        '','','','','','','','','','Vui ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','wu ','Fit ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'hai ','','','','','','','','','','','','','','','gao ',
        '','','','','','','fu ','','','','','','','liu ','','',
        '','','','','','Fit ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Chua ','','Nan ','','','Nep ','','','Chac ','Cham ','','','','','','',
        '','','','yang ','','','','','','','','','','','','',
        'ai ','teng ','','','','','','','','Nhuoc ','','','','','','',
        ],
    'x228':[
        '','','','Geng6','Sung ','Thung ','','','','','','','','','','',
        'Ngo ','','','','','','','','','','','','','','','',
        '','sao ','','','','Gan ','Hon ','','','Mo ','','shu ','','','','Lang ',
        '','','fu ','Bie ','','Tang ','','xiang ','','','','','','dang ','','',
        '','','dang ','','','','','','','','','','','ge ','yu ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhao ','','','','','','','','','','','','','','','',
        '','','Ghet ','','Ngung ','','','','','','','','chang ','zhe ','','',
        '','','su ','','','','','','','','kai ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Khan ','','',
        'Ngay ','','','','Quo ','','','','','','','','','','','ai ',
        '','','','','','','','','','','','','','','','',
        'liu ','','','','','','','Khuay ','','','','','','','','',
        '','','','','','','','','','Hung ','','','','','','chu ',
        ],
    'x229':[
        '','sao ','','','','','','','','','','','','','','',
        'liu ','','','','','','','','meng ','','zhan ','','','Cham ','','',
        '','','','','zhuang ','','','','','','','','','','','',
        '','','','','','','','','','Goe ','','','','','','',
        '','','teng ','zhu ','','','Lung ','','Lo ','','','','','','','',
        '','','','','','','Trai ','','xie ','','jiao ','','','','Chong ','',
        'Sung ','','','','','','','','','','','','','','','',
        '','','','','','','','Ngoi ','','','','','','','','',
        '','','Laan ','','','','','','','','','','qu ','','qiu ','Zai ',
        '','','','','','','','','','','hua ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','shu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','han ','ge ','','','','','','','','',
        '','','Ta ','','','','','','','','','','','','','',
        ],
    'x22a':[
        '','','','','','','','','','','','','','','','jue ',
        '','','','','','','','zei ','','','','','jie ','','','',
        '','','','','','hu ','hu ','','','','','chu ','','','','',
        '','','','','','','','','','','','','','','','',
        '','ju ','','','zhu ','','','','','','Quanh ','','','','','',
        '','','','ge ','','','','','','','','','Ho ','','','',
        '','','shan ','','Muon ','','Zit ','Hat ','','','','','','Thuon ','Dat ','jue ',
        '','','','','','','','','hai ','xia ','','','','','Chop ','',
        '','','','cu ','','','','','','','','','','','','',
        '','','','','','','','Vuc ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Ngat ','Vat ','Nang ','','','','','Muc ','','','','','','','zhang ','',
        '','','','Keo ','','That ','Vun ','','','','','','Tha ','','','Kam ',
        'jie ','','','','','Wing ','Trot ','','So ','','','','Trum ','Rung ','Quay ','',
        '','','','Bac ','','','Haku ','','Ngung ','','','Lat ','','nu ','','',
        'zhe ','','','','','zu ','','','','','','nie ','','','','',
        ],
    'x22b':[
        '','','','','Bung ','','','','','','','','','','','',
        'Muc ','','','','','','','Chui ','','','','','','','','',
        '','','','Tay ','Khuong ','Giang ','','','','','','','','','Vot ','',
        '','Khep ','','','','','','nan ','','','','','dun ','','','Xoi ',
        '','','','Dau ','','','Chou ','','','','','','','','','',
        '','Thuoc ','','','','','','','','','','','Xac ','','','',
        '','','','','','bian ','','','','','','','','','','Quet ',
        '','','','Giau ','Khuay ','','','Vom ','','Lan ','Dui ','Xoi ','','','','',
        '','','','','','','','','','','ya ','','','','','bang ',
        '','Luk ','','','','','','','','','','','','','sao ','',
        '','','','','','','','','','Co ','Ron ','','Chut ','Co ','','',
        '','','','','','','','','','','','','','','','Quay ',
        '','','','','','lu ,jue','','','','xie ','Dik ','','zhai ','','Ngaau ','',
        'Co ','','','Va ','Quat ','Ngoi ','Khep ','Quay ','Huo ','','','Sap ','Buoc ','Ven ','','',
        'Va ','Roc ','Sua ','','','','Lay ','','','','','','','','yu ','',
        '','Sau ','wan ','xue ','','','','','','ge ','','','','','mao ','',
        ],
    'x22c':[
        '','','','','','','fu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Wo ','','','','','Gap ','Zung ','pan ',
        '','','','','jie ','','','','jia ','','','','jia ','','Boi ','',
        'Gieo ','Waa ','','','','Dap6','','','','Cai ','Phung ','Xoi ','','Nhot ','','Sin ',
        '','','Saak ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Kek ','','','','','','','',
        '','','','','Bung ','','','','','','','','','Run ','','',
        '','Laa ','','Rung ','Cau ','','','Gay ','','Cap ','Mai ','Mo ','','','','',
        '','Cau ','Sang ','','','Cao ','','Sou ','Lou ','','','','die ','','','zhu ',
        '','','Bat ','','','','Ngao ','','zu ','','','','','','','',
        '','lang ','','','','','','','','','','','Saai ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x22d':[
        '','','','','','','','Chap ','Daat ','','Chop ','Chong ','','','','',
        'Day ','','Phanh ','','','Ning ','','','Xay ','','','','Xau ','','Nhung ','',
        '','','fen ','','','','','','','','','','ban ','','','',
        '','lei ','xie ,jie','','','','','','','','','','','','','',
        '','','','','Cou ','','','yang ','','','','','Dui ','','','',
        '','','','Paang ','','','','','','','','','','','','',
        '','','','','','zao ','','Dan ','','Doi ','','','Don ','','','',
        '','Khoi ','','Sum ','Quay ','','Don ','Cat ','Xap ','','','','Vot ','Ro ','','',
        '','','','','','Sip ','','','','','','','','Saap ','','',
        '','Niao ','guai ','','','','','','','','','','Ngung ','','','Cui ',
        'Saau ','','','Die ','Loe ','','','','','','','','','','','Maan ',
        '','','','','','','bang ','','Bum ','','Dom ','Bung ','Ngoi ','','','Don ',
        '','Nem ','Xan ','','','Tro ','Chen ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Ban ','','','','','','','','','','Dui ','',
        '','','Hang ','','','Vo ','liu ','','','','du ','','','','','jie ',
        ],
    'x22e':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Lan ','','','',
        '','','','Niao ','','cuan ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Choc ','Gai ','Mac ','Rung ','','Xe ','','','','','yu ',
        '','Zaang6','','','','','','','','lan ','','','','','','',
        '','','','Keo ','Xau ','','','','Tum ','Suong ','','','','','','',
        '','','','xiao ','','','','','','','','','','Giam ','Que ','',
        '','','','','','','','yao ','','ta ','','Naan ','','','','',
        '','','Bung ','','Bau ','','','','','','','','','Uon ','','chan ',
        '','','','','','','','','','','','','','','','',
        '','','','Man ','yu ','','','','','Chia ','Chia ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','cheng ','','','','','','','','','hai ','','','',
        '','','','','','','','','sa ','','','','','','jie ,fu','',
        '','','','','','','','','','','','','','','','',
        ],
    'x22f':[
        '','','','','','','','','','','','','bao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','qia ','','','','','','','','jiao ','','','','',
        '','','','','','','','','','','xue ','','','','','',
        '','','','','','','','da ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','mao ','','','','','','','','','','','jiu ','','',
        '','','','','Duk ','','','','','','','','Va ','','','',
        '','wei ','','','yu ','du ','','','','','cheng ','','','','','',
        '','','kuai ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','lu ','','','',
        '','','','','','','','','','','','','','','','wen ',
        '','','meng ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','man ','','','',
        '','xie ','luan ','','','','cheng ','cheng ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x230':[
        'lei ','','','','qun ','','','','','','','','','chen ','','cheng ',
        '','','Chong ','','','','','','','','','','','','','Va ',
        '','','','fu ','','','','san ','','','','','','','','sa ',
        '','','','','','','','','','','','','','','fu ','',
        '','','','','','','','','','','','','','dao ','','',
        '','','','','Lon ','','gan ','tan ','','','','','man ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','qia ','','','','','','','','','','','',
        '','','','','','','','','','','yun ','','','','','',
        '','','','','','','','','','','','','','xiang ','','',
        '','','','','','','','','','','','','xiao ','','','',
        '','','','dang ','','zhuan ','','','','','','','','','','',
        '','','','','','','','','','dang ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','yan ','',
        ],
    'x231':[
        '','','','','','','','','','','','','','','fu ','',
        '','','','','','','','','','Huang ','','','','yan ','','hu ',
        '','','','','','','','','','','','','','','','',
        '','','','','liang ','','','','','','wei ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Khuya ','Khuya ','','','','','','',
        '','jue ','','','','','','','','','','','','','','',
        'xiang ','','','','','Tam ','Luc ','','','','','','','','','',
        '','','','','','','','','','','','','','','','Phoi ',
        'Trua ','','xu ','','','xian ','','','','gan ','','','','','','',
        '','','','','','','','hao ','','','','','','','Chang ','',
        'Giay ','','','','','fu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Sao ',
        '','','Bie ','','','','','','dai ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x232':[
        '','','','','','','','','','','mu ','','','die ','','',
        '','','','Phoi ','','Mai ','','Ngay ','','','','Quat ','Ngay ','','Hong ','',
        'bian ','','Tia ','','','tu ','','','','','','','','','','',
        'Nau ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Ui ','Trua ','',
        '','','','','','sang ','','ang ','nai ','','','','','','Gou ','',
        '','','','','','','','','','ya ','','','','','','',
        '','','','','','Rua ','','','','','','','','','','',
        '','','','mao ','','','','','','','','Se ','','Mo ','Chop ','',
        '','','','','meng ','','','','','','','','','sang ','xu ','kan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Bay ','',
        'Sao ','Toi ','','','','','','','','yu ','dan ','','','','','pu ',
        '','','','','','','','','','','','','','','ai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Som ','','',
        ],
    'x233':[
        '','Trua ','Trua ','','','','Trua ','','','Khuya ','','Som ','Rua ','','','de ',
        '','','','','','','','','','','','','','Nang ','','',
        'chun ','','','','','','','','xun ','','','','','','','',
        '','','','','','','','','','','Xeo ','','','','','',
        'Nguc ','','','','','','','ju ','','','','Cui ','','Oam ','','cha ',
        '','','','','','','','','','','','yu ','','','','',
        '','','','','','','kuang ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Luo ','','','','','','','','','',
        '','','','','nian ','','','','','','hu ','','','','Trang ','',
        '','','','','','','','','','','','','','','','',
        '','','','','Dun ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','shu ','','','','','','','','pai ',
        '','','','','','','','','','','','','','','','',
        '','','','','Jan ','','','he ','','','','','','','Zai ','Then ',
        ],
    'x234':[
        '','','','','','Nhum ','Thot ','','','','','','','','','',
        '','','','','','','','','','','','','','Xop ','','',
        '','','','','','','','','','','','','','','','',
        '','','Queo ','','','','','','','','han ','','','','','',
        '','Cung ','hu ','','','','','','','','','','','','Roi ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Gian ','','','Sim ','','','','Nen ','','','','fu ',
        '','','dian ','','','','qiao ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Mang ','','','','','','','','','','','','',
        '','Xoai ','Sao ','Cong ','','','','han ','kuang ','','','','','','','',
        '','','','','','','','','','sha ,jie','','','Gou ','','','',
        '','','shan ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Lau ',
        ],
    'x235':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Cui ','Bap ',
        '','Pha ','Xoi ','Ngoc ','','Chanh ','Nhai ','','Kang ','','','','','','','',
        '','','','','','','','','','','mao ','','Gon ','','','',
        '','','','yu ','','pao ','','','','','','','','','','',
        '','','','','','','','','Hay ','','','','','','','',
        '','','','','','','','','','','','','Noc ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','yun ','','','','','','','','','',
        '','','','','','Peng ','Chay ','Chay ','','','Ca ','','','','','',
        'Suot ','Trac ','','ju ','','','','','','','qu ','','jue ','','ang ','',
        '','','','','','','','','','ru ','','','xun ','','','',
        '','','','','','','','','','','','','','','','',
        'reng ','','','Chua ','','','','','','','','','','','','',
        '','','','','','','','','','','Cha ','','','','','',
        '','','','','','','ta ','','','yang ','','','','','Son ','',
        ],
    'x236':[
        '','Ca ','','Cay ','Thot ','','','','Son ','Cum ','','','','','','',
        '','','','','','','','Nik ','','bang ','Seot ','','','','','',
        '','','','chun ','','','Yi ','','','','','','','','','',
        '','','','','','','','','','','','','','Nau ','Vai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Rac ','','','','','','',
        '','','juan ','','','','','','','','Mo ','Sop ','','','Chay ','Rui ',
        '','','','','jie ','zhe ','hu ','','Sot ','Con ','Mam ','','','','','',
        '','','','jie ','','','','pao ','','','','ye ','','','lei ','',
        'ru ','','','juan ','','Jaap ','','','','','','','','','','',
        '','','zhuan ','','','','jiang ','hao ','','','dun ','','','','','',
        '','','','','','','','','','','Hong ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Xanh ',
        '','Gu ','','Khay ','','Be ','','','','Then ','Tu ','hu ','','','','',
        '','Dom ','','','','','','','ze ','','','die ','','zha ','','',
        ],
    'x237':[
        '','','sa ','','','','','','','','','Mo ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','juan ','','','','ai ','','','',
        'Lim ','Son ','','','','','','','','','wen ','','','','Chua ','',
        '','','hun ','','','ai ','','','','Duoi ','','ta ','','','','gao ',
        '','yu ,yu','','','','','','hu ','','','','','10389.190,bian ','su ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Khu ','Cuoi ','','','dun ','','','','','','','Tram ','',
        '','meng ','','lu ','tan ','','','liu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'lian ','','','','','','','','','','','','','','','',
        '','','','Mong ','','','','xiao ','','huai ','','','','','','',
        '','liu ','wu ','','','','','','','','','','','','','',
        '','','','','','','','','','Dui ','','','Ran ','','','',
        'yu ','Kyo ','','','','','','','mei ','','lian ','','','lao ','','',
        ],
    'x238':[
        '','','','','','','','','','','','','','','','',
        '','','Tham ','Pheo ','','Chua ','Chua ','Que ','Gau ','','liu ','','zhao ','','','',
        '','','','','','','','','','Tram ','','','','','','',
        '','Tram ','','','','','','','','','','','','Ha ','','',
        '','','','','','','','','','yu ','','','','','cen ','',
        '','','','Tram ','','yan ','','','','','','','','Vui ','','die ',
        '','','','','Nen ','','','lei ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','xu ','','','','','',
        '','','yu ','','','','qian ','','','','','','','','','',
        '','','','','','dian ','','','','','','','','','','',
        'zu ','','','','','','chu ','','','','','','','','','',
        '','','','','','','','','dian ','','','','','','yu ','',
        '','','','','','','','','','','an ','','','','hun ','',
        '','','','dian ','','','','','','','','','','','sha ','',
        '','','xie ','','da ','','','','','','sha ','','','','','',
        ],
    'x239':[
        '','zhu ','','','','','','','ze ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','shu ',
        '','','','','','','','','','','','','','','','',
        '','','ta ','wan ','','','','','','','wang ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','guan ','','','','','','','','','','',
        '','','','tu ','','','','ta ','','chu ','','','zhu ','','da ','',
        '','','','','','','','','','','','','','Ngay ','','',
        '','','','','','','','','','','','','','','','',
        'chu ','chu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Laai ','du ','','','','','die ','','','','','','','',
        '','','','','','','','','','bai ','','dian ','','qiu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','nao ','','',
        ],
    'x23a':[
        'luan ','','die ','','qia ','','','mao ','','','','','','','','',
        '','','','wu ','tao ','','','','','','','zu ','ma ','','','',
        '','','','jiang ','xu ','','','Giuoc ','','','','','','Quan ','','',
        '','','du ','xiang ','','','','','','','','','','','','hun ',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','guan ','','','','','','er ','','','','','',
        '','','liao ','','','','Ngoeo ','shan ','','','','','','zhai ','','ye ',
        'diao ','','','','jiang ','','','','Toi ','huai ','yu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Ji ','','','','','','','','','','dian ','','','bian ','','',
        '','','','','','','','','gu ','','','','','','','',
        '','','','','','','','','hu ','','','','','','su ','',
        '','','','','','','','','','','','','dao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','xie ','','','Van ','','dai ','','','','','','',
        ],
    'x23b':[
        '','','guan ','','','','pei ','','','','','','','','jue ','juan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','ba ','ba ','','','','','','wu ','','',
        'bao ','','','Su ','','','','','','','','','','','','',
        '','','','','','','','','fu ','','','','','ge ','','',
        'ru ','','','','','','','','','','','','','','','Ria ',
        'Mao ','','','qiu ,qu','','','','','','','','Mau ','','','','',
        '','','','','','','','Ngu ','','','de ','','jie ','jie ','','',
        '','','','','','','','','','','','','','','','',
        'san ','','chun ','','','','nai ','','','','','','','','','',
        'de ','','','','','','','','','','','','','','','',
        'mao ','','','','','','','','','','','ru ','','','wu ','',
        '','','','','','','','','','','ta ','','','','','',
        '','','','','','','','','','men ','','','','','','',
        '','pei ','','','','','','','qu ','','','','su ','','','',
        ],
    'x23c':[
        '','','','','','','','','','','','qu ','','','','',
        '','','','','','sao ','','','kun ','','','','','','jie ','',
        'qu ','qu ','','','','meng ','','','','','','','du ','','','',
        '','','','','','','','','','','','qu ','','','','',
        '','','kun ','','','','Ho ','','','','','','','dan ','','',
        '','','','xiao ,hao','','','','','','','','','','','','',
        '','','','','','','','','','','','','Hoi ','','','',
        'Ram ','','','liu ','','','Vuc ','','','','','','','','','Nhop ',
        '','','','','','','','','','','','','','Ngut ','','',
        '','','','','','','','','','','','','','','','',
        'Ngot ','','','','','','','','','','','','','','','',
        '','','he ','','','','','Nap6','','','','','','','guai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','fan ','','','jie ',
        '','','','','zhan ','','','','Deoi ','','','','','piao ','','',
        '','','','','','','','','','','','','Doe ','','','',
        ],
    'x23d':[
        '','','','','','','','','','','','','','','','',
        '','','','jian ','','','','','','','Hup ','Nhung ','','','','',
        '','','zao ','zhuang ','','','','','','','','','','','','',
        '','','','','','','','','','','','','mao ','tan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Bung ','',
        '','','','','Ngam ','','','','zhu ','','','','gan ','','','',
        '','','','','','','','','','','','','','zhuang ','','',
        'pao ','','','','','','','','su ','','','','','ju ','','',
        '','can ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Loi ','',
        'Nhom ','','','','','','','','','','','','','','','',
        ],
    'x23e':[
        '','','','xu ','','','','bian ','','','','','','','huai ','',
        '','','','','','','','','','','she ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','Lut ','','Tran ','','','','','','qiao ,xiao','','Cong ',
        '','','','','','qian ','','','','xie ','','','hu ','','','xun ',
        '','','','','','na ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','tao ','',
        'qiao ','','','','','','','','','','','','','','','',
        'Nuot ','','','Bui ','','','','Xoi ','','Duoi ','','','','dang ,xiang','','',
        '','','','','','Ma ','','','','','shu ','','fu ','','','',
        'xie ','lang ','','','','','','','','zhe ','','','can ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x23f':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','','','ze ','shuai ','','','Bot ','','','','','Vui ',
        'Lung ','Ngau ','Doi ','Xop ','','','','Lot ','','','','','Tran ','Lang ','','',
        'Ngau ','','','','','','Veo ','','','ru ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','an ','jian ','','53066.030,teng ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Doi ','','','','Khoi ','','','Xoi ','Bui ','',
        '','','','Ngau ','','','fu ','','su ','','lian ','','he ','','','',
        'ze ','','','','','','','','','','','','','','','',
        '','','','xiao ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x240':[
        '','','','','','','','','','han ','','','','','','',
        '','','','Loc ','','','Ngoi ','Rua ','Vung ','','','','Tanh ','yu ','','',
        '','','','','','','la ','','','jian ','','','','','','',
        '','','bian ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Dao ','Khoi ','','','','Trong ','Bot ','','Chua ','','','','',
        'Dao ','dan ','jie ','bai ','','','xian ','','','','','','','','','',
        '','cai ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','zhuan ','','','','','Rua ','Dan ','Phun ','Loi ','Toe ','','',
        '','','','','','','','','','','lan ','','yao ','','','xuan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Leo ','','Muong ','',
        '','','','','','','','Thuot ','lan ','','','','','','','',
        '','','','','','','Deng ','','','','xun ','','','','','',
        ],
    'x241':[
        '','','','','','','','','','','','','','','','',
        '','fan ','','','','','','','','','','','','','','',
        '','','','','','ta ','','pan ','','','','','','','','Trong ',
        'Nhan ','','Can ','','','','','','','','','','','','','',
        '','','','','','','','','','','yan ','','','','man ','',
        '','','can ','','','','','','','','','','Veo ','','','',
        '','','','men ','','','','','','','','','','','','',
        '','','shuan ','','','','','','','','','','','','','',
        '','cheng ','','','','','','','','','','','','Chi ','','',
        '','','','','','','','','','','','','gua ','','xu ','',
        '','','','Saap6','','','','','','','','','','','','',
        '','','','','','','','','Tom ','','','','','','','',
        '','','','','','','','','','','','','Kho ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Say ','Phoi ','Tat ','','','','','Bep ','',
        '','','Nhum ','','','','','','','','','','','','Ying ','',
        ],
    'x242':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Lui ','',
        'Sot ','Ngut ','','','','','','he ','','','Cho ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','lao ','shao ','',
        '','','','Tro ','','Tro ','Se ','Heo ','Ngun ','','','Toa ','Rang ','','','',
        '','','','','','','','','fu ','','','kai ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Luoc ','','','','','','','','','','','','','',
        'Roi ','','','Tro ','Nhem ','','','','','Rom ','','Phoi ','Phoi ','Lom ','','',
        'Ben ','','','','','','la ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhu ','','','','','','Ranh ','Nau ','Khet ','Kho ','','Phoi ','Kho ','Choi ','Um ','',
        ],
    'x243':[
        '','','su ','','','','','','','','','','','Hok ','','',
        'han ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','gan ','','','','','','',
        '','','','Hay ','','','Ngot ','Nau ','','Ngun ','','','','','','',
        '','Chong ','','shu ','','Jau ','','','','','','','zao ','','','',
        'Jit6','','','','Zhang ','','','','','','','','','','','',
        '','','','','','','Loa ','','','','','','','','','',
        '','','','','','','','','','','','','','Quac ','','',
        '','','Phap ','','','Tat ','','','','','','Ram ','','','','',
        '','','','','','','','zhu ','','','','','','','','',
        '','Zuan ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Nhoi ','','Ho ','Thui ','Khet ','Thap ','Se ','','Rao ','Buot ','','','','',
        '','chu ','Zhou ','','','','','','','','','','','','','',
        ],
    'x244':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Ham ','Nau ','','Soi ','','',
        'Luoc ','','','','','','','','','kai ','','','','','','',
        '','','cuan ','','','','','','','','','','','','','',
        '','','','xian ','','','','','Chang ','','','','','Hung ','','',
        '','','','','','Xun ','','','','','','','','','','',
        '','','','','','','','','','','','Bung ','Loe ','','','Sem ',
        '','','','','','','','ye ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Nung ','Nau ','','yao ','','Nhui ',
        '','','Lom ','','','','Sem ','','','','','','','','','',
        '','','','','Thap ','','','','','','','ta ','','','','',
        '','','','','','','Ram ','','','','','','','','','',
        '','','','Lo ','','','','','','','','','','','','',
        '','','','','','','','','','Ben ','','','','','','',
        '','','','','','','','','','','Vau ','','','','dao ','',
        ],
    'x245':[
        '','','','','','','','','','','','ju ','','','','',
        '','','','','','','','','','','shang ','Su ','','','','',
        '','','','bao ','','','','','','','','','','','','Vuot ',
        '','','','','','','','Danh ','','','','','','','','',
        '','','','','','','','','','','shen ','','','','','',
        '','','','','Cha ','','','','','','','','','','zhu ','',
        '','','','','','','','','','','','','','Jiang ','','Jiang ',
        '','','','','','','','diao ','','','','','','','','',
        '','','','','','','zhan ','','','','','','','','','',
        '','','die ','ze ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','he ','','','','ju ','','','','Lop ','','','','xiang ','','',
        '','cu ','','','','','Mui ','','Sip ','','','','','','','pei ',
        '','','','cheng ','','','','','','','','lian ','','','','',
        '','','','','','','','','die ','','shu ','','','','','',
        '','','Tam ','','','pu ','','','','Phuon ','','chan ','','','','',
        ],
    'x246':[
        'dao ','','','','','','','','','','','Nga ','','','','',
        '','','','Nanh ','hu ','','','','','','','chun ','','','','',
        'tian ','','','chen ','','','','','','','','','','','','',
        '','','zhuang ','','','hu ','','shu ','','','','','','','','',
        '','','','','','bai ','','','','','','','','','','qu ',
        '','','xie ','','zhao ','','','','','','','tu ','','','','',
        '','','','','','','','','','','','','','','Ngau ','',
        '','','','','Caau ','','','','','','','','','','','',
        '','','','','','mu ','','Nghe ','','','die ','','','','yu ','',
        '','','','','','','','','','','du ','','','','','',
        '','du ','','','mei ','','Co ','Sao ','','','','','','','','xiu ',
        '','','','','','bu ','','','','','','','','','','',
        '','','','','','','','Chan ','','','','','','','','',
        '','','','','','','','','','','','','','su ','Nghe ','',
        'Trau ','','ceng ','ta ','','','jue ','xun ','','','','','','qun ','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x247':[
        '','','','','huai ','','','zhan ','','','','','','','','',
        '','','','','ju ','ba ','lei ','','','','','','','','','',
        '','','','','zhe ','','','','','','','','San ','Tu ','','Cop ',
        '','','','','','21335.010,yan ','','hu ','','yu ','','','','','','',
        '','','mu ','','','','','','','','','','','','','',
        'hao ','Muop ','na ','','','','','','hu ','','','','','','Chuot ','',
        '','','','','','','','bao ','','','','','','','lu ','',
        '','','','','','','','','','Chu ','','','','','','',
        '','','','','','','','','','shu ','','','','','','',
        '','','','San ','Thac ','Tay ','','','','','','zang ','','','yu ','',
        'cha ','xie ','','','','','Moi ','Khon ','','','','','','','','',
        'qiu ','','hu ','zai ','jue ','','han ','','','','','Hum ','','','','an ',
        'zao ','','','sha ','','xian ','','','','an ','','','','zhe ','jue ','',
        '','','','','','','','','lu ','','','','','xia ','xiao ','',
        '','','dun ','','','','','','','','tu ','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x248':[
        '','','','','Ga ','Voi ','','ge ','','','','Trau ','','','','',
        'ta ','Lau ','','','','','','','','','su ','','','','','ta ',
        '','','','','','','','','','','fu ','','','','','',
        'Gau ','','','','','','','','','','','','','cu ','','',
        '','','','su ','','','','','','','','','','','','',
        '','','','','','','','','','','','Nanh ','','','','huan ',
        '','','','','','','','','','','','','','','Ran ','',
        '','','','','','','xu ','','','','','','','','','',
        '','huan ','su ','','','','','Vuot ','San ','','lu ','','','','','',
        '','','','ju ,qu','Nhen ','Dou ','','','su ','','','','','','','ze ',
        '','','','','','','','','','','Lie ','','','','','',
        '','','','','','ai ','','','','','xie ','','','Nhat ','','',
        '','','','','Beo ','','','','','','','','xiao ','','','',
        '','xie ','','','','','','','','','','','','','','',
        '','Doc ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x249':[
        '','','','','','','','','','','da ','','','','','',
        'su ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','wai ','','','','',
        'Vua ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','su ','','','liu ','','','','','','','','',
        '','','','','','','','','','','','','','Xa ','','',
        'mao ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Cung ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','yu ','Cong ','','','','','',
        '','','','jian ','','','','','','wan ','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x24a':[
        '','','','','','','','','','','','','','lu ','qu ','',
        '','','','','','','hu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','zhuan ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','hao ','xiang ','','','hao ','','',
        '','dian ,tian','ge ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','chan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','qia ','jiao ','','','','','','','','Dua ',
        ],
    'x24b':[
        'Dua ','','','','','','','','Hau ','','','','','','','',
        '','','','','','','','','','','','Lu ','','yan ','','',
        '','','','','','','wa ','zu ','fan ','','','','','','','',
        '','xu ','','','','','','na ','Sanh ','','','','','','','',
        '','','','','','','','','diao ','','','','','fan ','','',
        '','wu ','','','','','','','','','','','','','','fu ',
        'na ','','','','','','','','','','','','','','','',
        '','hu ','','','su ','','','','','','','','','xu ','','',
        '','','','Ang ','','','','','','','','','','','lei ','heng ',
        '','Be ','','','','','','Lo ','','','lei ','','shan ','','','',
        'Muong ','','','','','','','lu ','Lung ','','jun ','','','Chan ','','xie ',
        '','zhe ','','','','','','liu ','lei ','','','','dai ','','Ngot ','Ngot ',
        '','','','','','','Ngon ','','','','','','','','','',
        '','Lam ','','','','','','','','','','','','','','',
        '','','','','','','','','Song ','Song ','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x24c':[
        '','','','','','','','','','','','','','','','',
        '','pu ','','','','','','','','','','','','','','hang ',
        '','','','','','','zha ','','','','','','chao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','na ','na ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','diao ','','','','','','',
        '','','','','','','','xie ','','','','','','fu ','','',
        '','','Duoi ','','','','','','','','','','Ruong ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','juan ','','','','','','','',
        'mao ','','','','','','','','','','','','','','','',
        '','','','','','cha ','Trai ','Trai ','','han ','','','','','','',
        '','','','','','yu ','','','','','','','','','','',
        '','','Trong ','','','','','','Roc ','','','','','','','zhu ',
        'Ve ','Ruong ','','','lei ','','','','','','','','','Ruong ','','',
        ],
    'x24d':[
        '','','','','','','','','','','','','','die ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Ngat ','','','','','','','','Bot ','','huan ',
        '','du ','','','','','','','','','','','','','','',
        '','','','','','','','','','','du ','','','','','',
        'wu ','','wen ','','','','','','','','To ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Si ','','','qia ','','','','hai ','','',
        '','','','','','','','','Tay ','','','','','','Chau ','',
        '','Nhan ','Ben ','','','tun ','fu ','','','','','','zhuang ','','','',
        '','','','','','','','','','','','','','','du ','',
        '','chuan ','','','','','','','Naa ','Guoc ','','Nghen ','Mang ','Mut ','','',
        '','','fei ','jian ','','','','Wak6','','','','','','','','',
        '','jiu ','','','lun ','','','','dao ','de ','','','','','','la ',
        '','','ju ','','','','','','','','Mang ','Cek ','','','','Loet ',
        '','','','Nhom ','','','Buou ','','','wai ','','','','','','',
        ],
    'x24e':[
        '','','','','','','','','','','dai ','','','','','',
        '','fu ','Ngung ','','','','','fu ','','','','','','','','',
        '','','','','','','','Hoen ','','','','yun ','','','su ','',
        '','','','','','bu ','','qun ','','','','Naa ','','','','',
        '','','','','','','','','','','','jue ','','','','',
        'Lit ','','','','','','Hen ','','Nhoc ','Choc ','','chen ','','','','',
        '','','','hu ','teng ','','','','lian ','','','','','','','',
        '','','','','','','','','','','','','Buou ','Not ','','Ngo ',
        '','','','','','','','bian ','','','','','','','','',
        '','','','Bie ','','','','','','','','','','','','',
        '','','','','','','','Zang ','','','shan ','','','Buot ','Gua ','Mun ',
        'Khom ','','','','Buou ','','','','','','','juan ','lu ','','ao ','',
        '','','','','','','','','','','','','','','Cum ','',
        'Hom ','','Toi ','','','','','','','','','','','','','',
        '','','ai ','','','','','','','','','Nhoi ','','','','',
        '','lu ','','','','','bian ','','','','','','','','','',
        ],
    'x24f':[
        '','meng ','','','','','','','','','','chan ','','','','',
        'guan ,huan','','','','','','','jue ','lei ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ju ','','','','','Dang ','','','','','','','',
        '','','','','','huan ','','','','','','','','','','',
        '','','','er ','','huan ','','Nguoi ','','','','','','','','',
        '','','','chang ','','','','','','','','','','','','',
        '','zu ','','','','Phau ','','','Trang ','bai ','lu ','','','','','nian ',
        '','','','','zhu ','hu ','','','','','','','','','','',
        '','','','Tram ','Vang ','','','','','','','miao ','','','','Ho ',
        '','','','','','','','','','','','yao ','','','','',
        'Nguoi ','','','','','bie ','','','','','','','','','','',
        '','','Saai ','','cun ','','','','','','','','','','Pi ','nan ',
        '','','','','','','','wa ','','','','','','','','xun ',
        '','','','cheng ','','','Da ','han ','xiao ','','Zaap ','','','','','',
        'Trong ','','','','lu ','','','','','','','','','ta ','','',
        ],
    'x250':[
        '','du ','','','','','','','','','','','Giay ','','','',
        '','','','liu ','lu ','','','','','','','','','','','',
        '','','','xue ,qiao','','la ','','','','','','','Jim ','','','',
        'la ','','du ','Mo ','','lu ','','','','','','','','','xiang ','',
        '','','jie ','mang ','','','','','','','','','','','','',
        '','','Ngaau ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','diao ','',
        '','','','','','','','','','','','','','','','',
        '','Jim ','','ju ','','','','','','Trom ','','tu ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','hu ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'cha ','','','','','','','','','','','','','','','',
        '','Mam ','','','qu ','','','','','','Mam ','Mam ','','','','',
        '','','','','','','','','Vuc ','','','','','','','',
        '','Nhap ','','','','fan ','','','','chuan ','yao ','','','','du ','',
        ],
    'x251':[
        '','meng ','','','','','','','mu ','','','','','','Cik ','',
        '','fu ','','','','','','','','','','','','mian ','','',
        '','','','','','','','','','','','Gap6','','','Nham ','Ngom ',
        'Nhon ','','mie ','','Xue ','xu ,yu','','','','bao ','','','','','','',
        '','','','Nhon ','','','','','Laap ','','','','','','','',
        '','dian ','fan ','','','','','','','','','','','','','Ngaau ',
        'Hau ','er ','','','','','','','','','','','','','','',
        '','','Chau ','','','wei ','','','','','xu ','','','','Zong ','',
        'Giuong ','','','Nho ','','','','','','yu ','','','jue ','','','',
        '','','','','','','','','','','','xu ','wang ','','juan ','',
        '','','','','','xie ','liu ','','','','','','','','','',
        '','','nao ','','','','wan ','jiu ','','Ngop ','Dau ','Ru ','Le ','','','Quau ',
        'Mang ','Tro ','Bet ','','','','','','Nhon ','','','','han ,qia','','','xu ',
        '','','jie ','','','','','','jun ','','','','','','dian ','',
        '','','','Gwat6','','','','','','','','','','','','mai ',
        '','','','','','','Him ','','','','','Tro ','','','','xu ',
        ],
    'x252':[
        '','','','','chuang ','','mao ','','','huan ','sha ','','','','','kuang ',
        '','','','','','','die ','','','la ','','lu ','','','','Sou ',
        '','','','','','','','','','','','','','','leng ','',
        '','','Ngap ','Chot ','Nguoc ','Nhon ','Nom ','','','','','','','','','',
        'guan ','ju ','','nai ','','ge ','','','','','ma ','teng ','','','','',
        '','','','','','','','','','','','','chen ','','','',
        '','','','','','','','','','','','','Let ','','Soc ','',
        'han ,qia','','','','','Ma ','lu ','','','','die ','','','','','',
        'Xam ','','','','','','','','','','xu ','','Caau ','','','',
        '','','','chan ','','','','','Ghe ','Zong ','','','','Chop ','Quac ','Nhan ',
        '','','','','Nguoi ','','Mu ','','','','','guan ','','zun ','','xie ',
        '','','','','Toet ','','','','','','','','','','','',
        '','','','','','','','Caang ','','','','','Sa ','','','',
        '','','Tre ','','','Trom ','','','Saau ','','','','','','','Xi ',
        '','','','jia ','','','','','','','','','','','','',
        '','','Lem ','Coi ','Ngam ','Him ','Lam ','','Soi ','','','','','','','',
        ],
    'x253':[
        'Xet ','','','','','','','','Trom ','','pan ','','','','','',
        'liu ','','','','','','','','','','','Lai6','','','','',
        '','','','','','Khoe ','Len ','','','','','','','xuan ','','meng ',
        'wei ','42521.120,meng ','','','','','','','Dim ','Ngam ','yao ','','','','','',
        '','','','','','','','','','','','','','Lom ','','',
        '','','Cham ','','lei ','','','','Nheo ','','bian ','Ngom ','','','','',
        '','','','hao ','','','','','','','zhai ','','','','','',
        '','ze ','na ','','','','','','','','','','','','','',
        '','','','','','','kai ','','wu ','','','','','ze ','','',
        'yu ','zan ','','','','xu ','','xu ','','','','','','','','',
        '','','cuan ','cuan ','cuan ','','','','','','','','','','','',
        '','','','','','','','','qia ','','tiao ','','','','','',
        '','','','','','','','huan ','','','','','','','','',
        '','','wu ','','','','','','jue ','','','','','ya ','','',
        '','','','','kua ','','','','','','','','','','an ','zhe ',
        '','','','','','','','','','','','','','','','Van ',
        ],
    'x254':[
        '','pu ','','','','','Van ','Ngan ','So ','Ngan ','','','','Ngan ','','Coc ',
        '','','Cut ','','Van ','ya ','','','Shi ','','','','','','Mong ','',
        '','','','','','','','','','yun ','','','','','','',
        '','','','','','','','','','','','','','zhe ','','hu ',
        '','','Chai ','','','','','die ','','','','guai ','','','','',
        '','ao ','','','','','','','','','','','','','','',
        '','','bu ','','','Sinh ','','','','','Nao ','','','','','du ',
        'guai ','','Ran ','','','','Loi ','','','','','','dian ','','','',
        'wu ','','','','','','','','','','','','','','','',
        '','','','','','','','','xun ','','','','','','','',
        '','','','','','','','ya ','lu ','','','','','chu ','','',
        '','','','kang ','','','hua ','','','','','','','','','',
        '','','','','Mai ','','','','','Sanh ','','','','du ','','',
        'jie ','','xian ,kan','','','','','','','','','','','','','',
        '','','','','','','','','','','','','dao ','','','',
        '','','','','Mai ','','','Canh ','','','','','','','','Tuo ',
        ],
    'x255':[
        'Gwang ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','yu ','','','','','','','','','','','','','',
        '','shan ','','','','Ji ','','','','','','','','','','Ham ',
        '','','','','Mai ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','zhe ','','','','','','','','','','','','',
        '','','jue ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','la ','','',
        '','','Quanh ','','','','','','','','','','','','','',
        '','','','','','','','','zao ','Cuoi ','','','','','','',
        '','','','','','','','','','','','','','','','du ',
        '','','','','','','','','','','','','','','','',
        '','','','ta ','','','','','','','dao ','','Chen ','','','',
        '','','','','','','','','Nen ','','','qu ','','ca ','','',
        '','','','','','xiang ','','','','','lan ','','','','','',
        ],
    'x256':[
        '','','','','yu ','','','','','','jiao ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','fu ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Rung ','','','','','','','','','','','','',
        '','','','xun ','','','ru ','','','Lay ','','','','','','',
        '','','','','','','','','','','','','','','','yu ',
        '','','jun ','','','','','','','','lu ','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhun ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','liu ','','','','','','','','','','',
        '','nu ','','','','','','','','','','','','feng ','lu ','',
        '','','','','','zhuan ','','zhe ','','','lu ','','','','','jue ',
        'liao ','','','','','','','','','','','','','','','',
        ],
    'x257':[
        '','','','','','','','','','','','','Ao ','','','',
        '','','Yan ','','','','','','','zan ','','','','','','',
        '','','','','','Yi ','','','','','','','','','jun ','',
        '','','','','','','','','','','','','','','','',
        'she ','','','','wan ','','','','','','','','','','','',
        '','','gua ','','jie ','','he ,xie','','','','','','','','','du ',
        '','','Li ','','','jie ','','ba ','yu ','','','','','','','',
        '','','','','','','','','he ','','','','','Cay ','du ,zha','',
        '','','','','he ','','','','','','','','','he ','','zhu ',
        '','','','','','','Giong ','','zun ','','ru ','Duo ','jiang ','','','',
        '','','','','','','','heng ','','','','','','','','zu ',
        '','','','','ku ','','','','','','','','','','','',
        '','','','he ','','','','','','','','','','','','',
        '','','','','','','','','','','chang ','','','','','',
        '','','','','','','','','','','mao ','','','','','',
        '','','','','','','','','','Lui ','','','Bap ','','','',
        ],
    'x258':[
        '','','','','','huan ','','','','','','','','','','',
        '','','','','','','','','','','','','yang ','','','',
        '','','','','','','','','','','','','Trau ','Giong ','Rom ','Rom ',
        '','','','','chang ','','','liu ','','jie ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','jun ','jiao ','','','','','','','','','','','',
        '','','','','Ji ','','','','','','','','','ai ','','',
        '','','','Nanh ','Mam ','','','','','','','','','','zun ','',
        'Cau ','','','','','','','','','','','','','','','hu ',
        '','','','','','','','','','','','','','','','',
        '','','cheng ','','','','kuai ','','ge ','xie ','','jie ','','','','',
        '','','','','','','zu ','','pu ','','','','','','','',
        '','','','','','','','','','','','meng ','','','','xiang ',
        '','','','','lu ','','','','','','','','','','','',
        '','','','','','','','','mu ','ran ','','','','','','',
        ],
    'x259':[
        '','','','','','','','','','','','zhe ','','','','',
        '','','','','','','','','jue ','','','','','','','',
        '','','','','','','ai ','','nu ','','','','','','','',
        '','','','','','mian ','','','','','','','','','','',
        '','','','','','Lung ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','wa ',
        '','','','','','','','','','','','','','','','',
        '','cheng ','','','','yang ','','','','liu ','','','','qiu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','fu ','','','','','','qia ','dian ',
        '','','jiao ','','','','','','','','','','','','','',
        '','','','','','','xian ','','','','','','','','','',
        '','','','','','','','','','','','','','','Hang ','',
        '','','','','','liu ','','','','','','','','','','',
        '','','','tu ','','','','','','Nup ','','','','','zhe ','',
        'hua ','','','','','','','fu ','','Tam ','','qu ','','','','',
        ],
    'x25a':[
        '','','','','','','','','','','','','liu ','fu ','dan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Trong ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Hoam ','','Chui ','','','','','','',
        '','','','','','','','','','','','','','ca ','','',
        '','','','zhu ','hai ','','','','','','','','','','','',
        '','','Hai ','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','','','','','','fu ','','','Trong ','Trong ','',
        '','','','','','','','','','','','','','','','',
        '','cu ','','','pang ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','dun ','','','',
        'lu ','Deon6','','','','','','','','chen ','','','huang ','shi ','','',
        ],
    'x25b':[
        '','','','','','','','','','','','','','','','',
        '','','','yao ','','','','','','ju ','','','','','','',
        '','','','','','','','','Khau ','Nia ','','','','','Giang ','Kao ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Mang ','Mau ',
        '','qiu ','dun ','','','','','','','','mang ','','','miao ','yuan ','',
        'wu ','','','','','','','','','','','','fei ','','meng ','',
        '','','','','','','Mang ','','','','','','','','','',
        '','','','','','','','Buong ','Hum ','Bu ','','','','','','',
        '','','','','','hang ','','ju ','nian ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Manh ','Tre ','Mui ','','',
        '','','Toi ','Trum ','','dang ','du ','','ye ','','','','','','','pai ',
        '','','','','','','jian ,sha','','','','Trau ','','','','yu ','',
        '','','','','','','','','zhu ','','','','','','','',
        ],
    'x25c':[
        '','','','','','','','','','','Thap ','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','shan ','liu ','','','','','','','hu ','','','','','',
        '','','','xian ','','','','','','','','mu ','','','zhai ','',
        '','','nu ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Ro ','','','','Ghi ','Gianh ','','',
        '','','','','','','','','','','','','','juan ','','',
        '','','','','dan ','','','dan ','','hu ','','','','','lu ','chuan ',
        'wu ','','','','','','','du ','','','shuang ','fu ','ju ','','','diao ',
        'wang ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','fu ','','','','','','xun ','','',
        'Khay ','','','','','','bu ','','','','','','','','','',
        '','fen ','dian ','','','','','','','','suan ','','an ','','','',
        '','','du ','','','','','','dan ','','','','','','','',
        ],
    'x25d':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Thung ','Mui ','','','','','','','',
        '','','','','','','','','ai ','ge ','ju ','tun ,dian','','qia ','','',
        '','jian ','','','','suan ','','','','','','qiang ','','','','',
        '','','','','','','','','','','','','','','','dian ',
        '','','','','','','Toi ','Hom ','Ray ','','Lak6','Nong ','','','jie ','zhu ',
        '','','','','zhao ','','','','','','','','','','','sa ',
        '','','','','','','','','','','','','','','','Mung ',
        'Thung ','','Gay ','','','liu ','','','','','','','','','','',
        '','','','','','','','','','','','','hu ','','','',
        '','','','','','','','','','','','','','','Toi ','',
        '','','','','','','','','','','die ','','','','','',
        '','ban ','','','','','hu ','','','','','','','','','',
        '','','','','yu ','die ','','','','','','','','','yu ','',
        '','','','','','','','','','','','','','','','',
        '','fu ','','','','','','','','','Mo ','May ','cu ','','','',
        ],
    'x25e':[
        '','Nan ','','','','','','','dang ','','','','','','','',
        '','','','','','','','','','','','','','Trum ','','',
        '','','','shan ','yu ','','','','','','yu ','','','','','',
        '','','','','','tun ','','','','','','','','','','',
        'Tam ','','','','','','','fan ','','Nap6','','','','zhu ','','',
        '','','','','yu ','','','','','','','can ','','','','',
        '','','','','','','','','','','','','','','','',
        'Lau ','','','','bu ','chu ','','liu ','Bot ','','','','','','','',
        '','','','','','','','','','','ge ','','','','','',
        '','Tam ','','Lo ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Com ','','','','',
        '','','','','','','','xian ','','he ','','','','','','',
        '','','','','','','','','','','Nam ','','','','bu ','No6',
        '','May ','','','','','sa ','','','mian ','','','','','','',
        '','','','','xia ','','','','Bun ','','','','','','','',
        ],
    'x25f':[
        'zu ','','','ze ','','','','','','','','','','','','',
        '','','','','','Lep ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','xiao ','','','Thung ','','','','','','','','','Com ','','xian ',
        'jian ','','','','Men ','','','','Miao ','','','','','','','',
        '','Phan ','','','Xia ','','','','','','','','niang ','','','',
        '','','','','','','he ','','lian ','','','','','','','',
        '','','','Men ','','zhu ','','','','','','reng ','jie ','','','',
        '','','','','','wu ','','','','','','cu ','','','','',
        '','','','','','','','fu ','hu ','','','','','','jue ','diao ',
        '','','','','','','','','','','','','','','Buoc ','',
        '','Vuong ','Tim ','na ','','','','','','','','','','','','',
        '','','','','','','','Giay ','','','','','','dai ','','',
        '','','','','Khau ','','','','','','','','','','','pai ',
        '','','','','','','','chao ','','','','','','','','',
        ],
    'x260':[
        '','','','','','','','Jing ','','','Dai ','','','','','Thua ',
        '','','','','','','Kep ','','','','','','zhuang ','','','',
        'liu ','','','','','','','','No ','','','','','','','',
        '','','','','','','','','mao ','Thun ','Xe ','Cui ','Noi ','Keo ','Rang ','',
        'Boi ','Nuoc ','','','','','zhuan ,juan,shuan','nian ','','','hua ','','','','','yan ',
        'jue ','','','','','','','','','','','','die ','','','',
        '','','','Go ','','','','','','','','','','','','',
        '','','','','','','','','','Ro ','','','May ','Vuong ','','',
        '','','','','','','','','','','fu ','','','','','',
        '','','','','wan ','','','Sok ','','','','The ','','','','',
        '','','','','','Dam ','','','','','','','','','','',
        '','','','','','','','','','','','Luot ','','','','Buoc ',
        '','','','','','','','','','','','','','','','',
        'Tao ','','','liu ','he ','','','','','','','','','','','',
        '','','','','mu ','','','','','','','','','','Gai ','',
        '','','','','','','','','','','','','','','','',
        ],
    'x261':[
        '','Thun ','Dai ','','Quan ','','May ','','','','','','Chap ','','','',
        '','','','Xau ','die ','','','','','','','','','','Van ','',
        'Nut ','','','Cuon ','','','','','','','','','','','','',
        '','','','','Chai ','','','','Xung ','','Rang ','Quan ','','qu ','','',
        'xun ','','','','zhe ','','dian ','','','','','','','','','',
        '','xun ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Tan ','',
        '','Thua ','','','','','','','','','','','','ju ','','yun ',
        '','','','','','','','','','','','lai ','','','','',
        '','','','','','','','','','','Neo ','','','','wu ','Mung ',
        '','','','','','','','','','','','','','','','Ban ',
        '','','','','','','','','','','','la ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Roi ','','','','','','','','','la ','','','','',
        '','','','','','','','','','','','','yao ','','Chung ','',
        '','','','','','','','','he ','','','','','','','',
        ],
    'x262':[
        '','','Nhau ','nang ','','die ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','yu ','','','','','','','','','','','','',
        '','','','','','','','','yu ','','','','','','','',
        '','','','','','','Cha ','','','liu ','','','','','','',
        '','','','','','','','','Caang ','bian ','','','','','','ya ',
        '','','','','','','','ya ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','hu ','cen ','','','','','','','','','','','','',
        'ju ','','','','','','','','hu ','','Bon ','Tu ','','','','',
        '','','','','','','fu ','hu ','','','','','','','','',
        '','','','','','','','','','','','','','meng ','fu ','liu ',
        '','','','','','xie ','','','xian ','','','','','','','',
        '','','','','lu ','','','','','','','','','','','',
        '','','yu ','han ','','','Ra ','','','','dan ','','','','','yu ',
        '','','','','','','','','','','','','','','','',
        ],
    'x263':[
        '','','','','','','','','','su ','su ','','','','','',
        '','','liao ','','','lu ','','','','','','','','','','lu ',
        '','','','','','','huan ','','','','','','','','','',
        '','','','','','','','du ','','','','','','','','',
        'nan ','','','','','quan ','','','','','','','','','','fen ',
        '','','ta ','tun ','','','','','','','','','','','','',
        '','','','','','','','','','Gu ','fen ','','','','','',
        '','','','','','','','','shan ','','','','','','','',
        '','','','','su ','','','chuan ','','','','','','','','',
        '','','jie ','','','','','','yu ','','','Guong ','chuan ','','','',
        '','Xinh ','','','','','wu ','','','','','','Tanh ','fu ','','',
        'gu ','','','','','','','','','','','','','','','',
        'ren ','','','','','jue ','','','','','','','','','','',
        '','','','Bon ','','du ','','hu ','','','','','yu ','','','',
        '','','mai ','','','','','','huai ','','','','','','','',
        '','','','','','','','','','','','yu ,yu','','','','',
        ],
    'x264':[
        '','','','','','','','Taap ','Fen ','','','','','','','',
        '','','','','','','','','','','','qu ,yu','','','','',
        '','fu ','','','hai ','','','','','','','','','','','',
        'chai ','','','','','','','','','','','','','','','',
        '','','','','','','','ta ','','','','zu ','','xu ','yan ','chai ',
        '','','','','','','','','','','','','ge ','','','',
        '','','','','','','','','','','','','','','','',
        '','','ta ','','','','ta ','','','fu ','','','','','liu ','',
        '','','','','','han ','','','','','','','','','','he ',
        '','yu ','','','','','','','','','','','Zin ','','','',
        '','','','','','','la ','','','','','','','','','',
        'tai ','','','','','Khu ','shu ','Bou ','','','dao ','','','','','',
        '','','','','','Gia ','','Khu ','','Lu ','','wang ','','','nai ','',
        'jue ','','','','','','','','','','','','','','','',
        '','Ma ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x265':[
        '','','','','','tu ','','','ze ','','','','','fu ','','',
        '','','','','','','','','','Cay ','','','','','','',
        'pai ','','','','','','kuai ','','','','','','qu ','','zhe ','sha ',
        '','','','','','','','','','nai ','','','','','','tian ',
        '','','','','','','ye ','','','','','','','','','sao ',
        '','','Zim ','xu ','','','','','','qu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'duo ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','hua ','','',
        '','Nghe ','','','','','','','','','','','','','','',
        '','','','','','','','yan ','','','','','','','','',
        '','','','','','','','','','','','Tai ','hu ','','','Dap ',
        '','tian ','','','','','','','','','','','','ai ','','Lang ',
        'ai ','zhe ','','lu ','','','','zhe ','','','','','','','Ghe ','',
        '','','','hu ','','','','','','','','','','','','',
        '','','','','','','','','','','','ju ','','','','',
        ],
    'x266':[
        '','','','','','','','','','','','','','wai ,wa','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Paa ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'pan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Moc ','Mao ','Hong ','Tim ','','','','','','','','ju ','dai ',
        '','','','','zhu ','Wan ','Gu ','','','ban ','','mai ','Ci ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Ping ','','','Zaap ','','','','','','','','','',
        '','','','hen ','','','','','','','','xie ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Ruot ','','','ku ',
        'na ','','','','xuan ','','','','he ','','Nam6','','Ham ','','','',
        '','','','','','','','','','','','','','','','',
        '','','jue ','','','','','','','','Bet ','Thon ','','','Nuc ','Mang ',
        ],
    'x267':[
        '','','','xu ','','','','','','','','','','pang ','','',
        '','','','','','','Ngaa6','','Vu ','','','','','','Ron ','',
        '','','','','','','','','','','','','','','','',
        '','','','','tun ','','','','','','','','','','','',
        '','','','','Rang ','','','','Ngac ','','','Mun ','Mep ','','Phop ','',
        '','','','','','','','','','','','','','huan ','','',
        '','Jim ','','','ban ','','','','','','','','tu ','','','',
        '','','','xu ','','','','','','','','','','','','',
        '','Tuoi ','','','','','','','','','','','','','Nghen ','',
        '','','','Phay ','','','','','','','','','','','','',
        '','','Tao ','Sao ','','zhe ','','','','','','sai ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Bo ','Zin ','Gay ','Suoi ','Khu ',
        '','','','tun ','','','','Nem ','','','','','ze ','','','',
        'cu ','','','','Xiu ','','','','','','','','','','','',
        '','','hun ','ju ','','','Nem ','','','','','','','','Khu ','',
        ],
    'x268':[
        '','cu ','','','','xun ','Sun ','ceng ','','','','','','','','',
        '','','jue ','','','','pao ','','Vai ','','','','','','','',
        '','','jiu ','zhe ','','','shu ','','','','','','','','','',
        '','Phet ','','','','Roi ','Seo ','','','','','','','','','sa ',
        '','','','','du ','','Fat ','','','','','Ron ','','','','',
        '','','','','','','','','','','','','','','Ngam ','Lung ',
        'Song ','','Rau ','','','','','','san ','','','','','yu ','','',
        '','yao ,shao','','','','hun ','Lom ','','','','','','','','','',
        '','','','','','','','','','','Pok ','','Duk6','','guang ','',
        '','','','Mak6','','','','','','','','','','','','',
        'Rang ','','','','','','','meng ','','','','','','','','',
        '','','','Vai ','Lot ','','','','','','','','','','','',
        '','','','','lei ','','','Lo ','','','','','','','Nan ','',
        '','','qu ','','','','','Nhau ','','Nang ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Zak ','','','','','','','lian ','','','','','','','',
        ],
    'x269':[
        '','','','','','','','','','','ru ','yao ','','','Gao ','',
        '','','','','','','','','','wa ','','','','','','',
        '','','','','','','Hot ','zhai ','','','','','hai ','','Thoi ','Kham ',
        '','','','','','','','','','','','','','','','',
        '','wu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Xue ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','fen ','','','','','','','','Kyo ','','xiao ','','','','',
        '','','cheng ','','','','','','','yu ','','yu ','','','','',
        '','','','','','','','','','','','','','juan ,fan','','',
        '','','','Lau ','','Weng ','','','','','','','','','','',
        '','','','','','','tian ','','hu ','','','ta ','','','ta ','ta ',
        '','','','','','ta ','','','','','','','huai ','','','',
        '','ta ','Loe ','','','hua ','','','zhuan ','','Laai ','','','','','',
        ],
    'x26a':[
        '','','Mua ','','','','','','fu ','wu ','','fu ','','','ta ','',
        '','Chai ','','','','','chao ','','','','','','Qua ','','','',
        '','fu ','','','','','jia ','','','','','','','','','',
        '','','','wu ','','','','','','','','Khoang ','','','','',
        '','','','','','','','','','','','bai ','','','','',
        '','','','','','','','','','','Mui ','Gu ','','','yu ','',
        '','fu ','xian ','','','','','','','','','','','','','',
        '','sheng ','','','','jian ','','','','','','','','','','sha ',
        '','','','','','','','lu ','Ao ','','','','','','','Thong ',
        '','','','','dun ','','','','jue ','ta ','zun ','','','teng ','','',
        'hua ','','','','','','','','','','peng ','','','','','',
        '','','','','','Ghe ','','','','','','Khoang ','Ghe ','','','',
        'teng ','','','','','','','','','','','','','','','',
        '','','','','','','','','','ba ','','','','','','',
        '','','','','','','','','','','wa ','','','','','xun ',
        'meng ','','','','','','','','','','','','','','','',
        ],
    'x26b':[
        '','','wu ','zhe ','','','','','','','','','','','','',
        '','','','','','','qiu ','','','','hu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','zhu ','','','','','','','',
        '','','','','','','','','hu ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Tup ','','','Hung ','','','','','',
        'ru ','','','','','','','','','','','jiu ','','','','',
        '','jiao ','','','','','','','','','','','','','','',
        '','pu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Nen ','','','','','fu ','','','','','','',
        '','','','','','xu ','','','','','','','','','','',
        '','zao ','','','','','','','','','','','','','','',
        '','','','cu ','','','','','','','xiao ','','Dua ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x26c':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fen ','','','','Ngon ',
        '','','Nua ','','Lau ','','','','','','qiu ','','','dun ','','',
        '','','','ye ','','','','','','','fu ','','','','','',
        'yu ','','yu ','yu ','Gu ','','','','','','','meng ','','','','',
        '','','mu ','','Bei ','','Fu ','','','','','','xiao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Nhai ','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','wan ',
        '','','','','','','','Lei6','','','','Rom ','','','Muop ','',
        '','hao ,mao','','xie ','','','','','','','','','','','','',
        'nai ,na','','','fu ','du ','','','','','Tre ','','','','','bai ','',
        '','','','xun ','','','','','','','','','he ','','','',
        '','','','','','','meng ','','','','','','','juan ','ru ','',
        ],
    'x26d':[
        '','','','','','','','','','hu ','','Mong ','jun ','she ','','',
        '','','','','meng ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Ke ','','','Nu ','','','','','',
        '','','','hun ','','','','','','','','','zu ','','','',
        '','','','','jie ','','','','','','','','jun ','','','',
        '','','','','','','','','','','','shan ','','','','',
        '','ta ','','','','','','','','heng ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Kou ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Chu ','','',
        '','','','','','','qiang ','','','Bom ','','','','','','Mai ',
        '','','','hu ','','','','hai ','ru ','meng ','','','','wu ','','',
        ],
    'x26e':[
        '','','','','','','','','','qia ','','','','','','',
        'lu ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','pei ','','','','','',
        '','fu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','zhao ','','','','',
        '','','','Thom ','','','Voi ','Bui ','','Nhai ','','Dam ','','','','',
        '','','','','','','','du ','','','','','','','','',
        '','','','','','','ju ','','','','','chuan ','Lao ','','','hu ',
        '','','jie ','xiang ','','','','','xiang ','','','lang ','','','','',
        '','','shuan ','','','chu ','','','','','','','','','','',
        '','dan ','','','','sa ','','','','','','','','','','',
        'Zaau ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x26f':[
        '','','','Sang ','','','','','ju ','','leng ','lu ','','','','',
        '','','','','','','','','','','Lum ','San ','San ','','Dua ','Khay ',
        'Sung ','','she ','','','','','sa ','','','mao ','qu ','','','','Zuk6',
        '','juan ','','','','he ','','','','','','mei ','','','','',
        '','','lu ','mian ','dian ','','','','','','Waa ','','','','lu ','fu ',
        '','','zei ','','Om ','','','','','','','','dan ','','wan ','',
        '','','','','','','','','','','','','','','','',
        'Tranh ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','sha ','','','','lu ','',
        'Dua ','','','','','','','','','dan ','','','','','','',
        '','','','','','','jian ','lu ','','','','','','ta ','','',
        'chu ','fu ','','','','','dang ','','','','lu ','','','','','',
        'jie ','','','','','','lu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x270':[
        '','','','','chang ','','meng ','','','','','','su ','','','Sung ',
        '','Giong ','Non ','Ru ','','sa ','','','','','','','Sam ','','','',
        '','zhan ','','','','','','','Lop ','','','','','','','',
        '','chai ','','','','','','','','','xie ','','','','','',
        '','','','xu ','','','','','','fan ','meng ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Ghem ','','','','','','','','','','','',
        '','zhan ','jian ','han ','dan ','','jian ','','','','','','','','','',
        '','','','','hu ','','','','','','','meng ','ju ','','','',
        '','meng ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Dua ','','','','chu ',
        '','','','','','','','','','','','','','','','',
        'yu ','','','','','','','','','','','','','','','',
        '','','','','','','Muong ','Khoai ','','','','','','','','',
        ],
    'x271':[
        '','','','','','','','','','','Han ','','','','','fu ',
        '','','qu ','','','','','','','','','ju ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Mo ','','','','','','','','','','','','','',
        '','','','','','','','','diao ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Men ','Muong ','','',
        'hu ','','','','','','','','','','nang ','','','','','',
        '','','','','Thuoc ','','','','','','','','','','','',
        'gan ','','','','','','','','','','','','','','','',
        '','xu ','','lu ','','','','','','','','','','','','hu ',
        '','','','','','','','','','','','','','','','',
        '','','','','lu ','','','','zu ','','','','','','he ','',
        '','','','','','','','','','','','','','shu ','','',
        'yao ','','','','','','','','','','','','','','he ','',
        'hu ','','','','','','','','','','','','hao ','','','zu ',
        ],
    'x272':[
        '','','','','xia ','','','','','','','','ge ','','','',
        '','ge ','','','','','ge ','','','','42573.210,zhu ','','teng ','ya ','','',
        '','','','','','','','','','','','','','wu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','tai ','','','','','','','','Trun ','Vat ','','','','','',
        '','','xue ','yu ','fan ','','','','','bu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Gwaai ','','dai ,de','','Buom ','Nhong ','','','','Vat ','',
        'Trut ','','','','','','','','ku ','','','qu ','','','','ru ',
        '','','','','','xu ','','','','','','','he ','','','',
        '','','','','','Gong ','Doe ','','','','','','','','','',
        'Chau ','','','','','','','','','','Saa ','','du ','Zhe ','','',
        '','','','kao ','','','','','','','','','','','','Moi ',
        '','na ','','','','','Mei ','','','','','','','','','',
        '','','','','','Cuong ','Mot ','','','','Chay ','','Nhong ','Mang ','','',
        ],
    'x273':[
        '','','Bo ','','','','','Bang ','fu ','lu ','','','','lu ','','ta ',
        '','','','Fu ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Cua ','','','','','Ngai ','','','','Cua ',
        '','','','shuai ','','jue ','','','','fan ','','','','','','',
        'jie ','','','','','','','','','jie ','yu ','','','','','feng ',
        '','die ','','','lian ','hu ','','','','','','','','','','dian ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Chau ','','',
        '','','','','','shan ','','','','','','','','','','',
        '','','zu ','','zhe ','','','','','','','','','','','',
        '','','xie ','xie ','','','','','','','','','','','','',
        '','','','liu ','','','','','','','','','','','','',
        '','','','','','jie ','','','','','','sha ','','','','Nhuc ',
        'Sam ','','','Bo ','Choi ','','','Nhuc ','','ai ','','','','','','zhu ',
        ],
    'x274':[
        '','su ','','xie ','yu ,yu','Zeoi ','','','zu ','','','','','','','',
        '','','su ','','','','Luon ','','','wu ','','','','','','',
        '','','Hou ','','','','','','','','','','','','','',
        'du ','','','lu ','su ','','','','','','','','','','Bo ','Sung ',
        '','Sam ','','Ngao ','','Vet ','Chang ','','','','','','','','','',
        'yu ','','Giun ','','dai ','','','','dang ','zu ','','','','chuan ','','',
        'du ','','','','','','xie ','zhe ','','','','sao ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','fu ','','','Buom ','','Sau ','','Rua ','','Rom ','Rua ','Rua ','e ','',
        '','','','','','','','','','fu ','','','lei ','','','',
        '','','','','','','','','chai ','','','','','','','',
        '','','','','','','','','','','','','','lei ','','zei ',
        '','ai ','','','','','','','','','','','','Ban ','','',
        '','','','','','','fei ','','','','','','','','','',
        '','','','','','','','','','','','','','','','Ngoe ',
        'Sam ','','','','','','','','','','','','','','','',
        ],
    'x275':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ta ','','','','','','','','','du ','qiu ','','',
        '','','','','chai ','','','','','','','','e ','','','',
        '','','','','','','','','','','','','','','qu ','',
        '','','','','','','','','','','Trai ','','','','','',
        '','fu ','','','','','','chai ','zang ','','','','','','','',
        '','','','','Naan ','','','','','','shuang ','','','','','',
        '','','','','','','ta ','','','','','','','','','',
        '','','','','','','','','','','fu ','','','','','',
        '','','','','','','Moi ','','','','','','','','an ','',
        '','','','','','','','','','','','','','','','xiang ',
        '','','','','','','','','n ','','','san ','hu ','','zu ','',
        '','','','','','','','Jiku ','','','','','','','','',
        '','','','','','','','','','la ','yu ,qu','jue ','','','','',
        '','shu ,yu','','','Jung ','','','Jutsu ','jian ','','','','','','','shuai ',
        ],
    'x276':[
        '','','Chong ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','hu ','','','','','','','','','','','','','',
        '','','','','','','','','','Taai ','','','','','','',
        'La ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','pu ','','che ','','',
        '','','','','','','','53077.090,jian ','','','','','','zhan ','yuan ','',
        '','','','','','','yu ','','','','','Lot ','','','','',
        'mu ','huan ','','','e ','Long6','','','','','','peng ','','','','',
        '','','','','Tung ','','','','','','','','','','','',
        'Song ','','Xong ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Trang ','Lun ','May ','','','','','','',
        '','','','','du ','','','tu ','','','','','','','hu ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Toi ','','','','','','','','',
        ],
    'x277':[
        '','Sha ','','','','','','','','','','','','','','',
        '','','','','','','Chan ','Mo ','','Xong ','','','','','','',
        'shuai ','','','','','','su ','','','','','','','','','',
        '','','','','','','','','','','Bau ','','','','','',
        '','','','jue ','','','','','','','','','','','','',
        '','zhan ','heng ','','qu ','wei ','','','bao ','','','','','','Gei ','',
        '','','','','','','','','Cheo ','Toang ','','','','','','',
        '','','ju ','he ','','','','','','','','','','','','',
        'shu ','','','','','','','','','','','','','','','yu ',
        '','meng ','hu ','','','','','','','','','','','','','',
        '','','','','','','','','','jie ','La ','shu ','jie ','lei ','','',
        'zu ','','','','','','','','','','su ','','','','','',
        '','','','xie ','','','','','','','','','','','','',
        '','','','','','','','','nang ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x278':[
        '','','','','','','','','cha ','','mao ','','','','','',
        '','','xian ','','','','','','','','','chan ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','gao ','','','',
        '','','','','','','','','','','Thay ','','','','','',
        '','jiu ','','','','','','','','','','','','','','',
        '','yun ','','','','','','','','','','','','','','',
        '','','','','lian ','','','','','','','','','','','',
        '','','','','','','','','','','','lao ','','','','',
        '','Don ','','','','','','','','','','','','Lai6','','',
        '','','yao ','','','','','wei ','','','','','','','','',
        '','','','','','','chu ','','','','','','','e ','','',
        '','','','','','','','','Caau ','','','','qiao ','','','',
        '','','ju ','','','qiu ','','','','','','','','','','',
        '','','hun ','','','','','Dia ','','','','','','','','',
        '','','','','','lun ','','','jue ','','','ju ','hu ','','','',
        ],
    'x279':[
        '','','','','','','','','','','','','','','','',
        '','ju ','','','','qiu ','','','','','','','','','','',
        'zhe ','','','','','','','','','','','','','Ba ','','',
        '','','','','','','','','','Thoi ','','','jue ','','','',
        '','','','Choi ','','','su ','','','','','','kuang ','','jue ','',
        '','','','','Va ','','','','','','','','','','tan ','',
        '','','','','','','','','','','','','','','','hu ',
        '','fu ','','','yang ','','','ren ','','','Kwan ','','yun ','','','xun ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','pu ','',
        'Ngaak ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Beng ',
        'Ngoa ','','','','wang ','','','','','','','','','','','',
        '','','','xu ','','','','','','','','','','Ngaa6','','',
        '','','','','','','','','','','','','','','','Khoang ',
        '','','','','','','tu ','','bie ','','','zha ','','','','',
        ],
    'x27a':[
        '','','','','','','','','','','Zaa6','','','','','',
        '','','','','','','','','','','','','','','','',
        '','chen ','','','','','','','','','','','','','','',
        '','','','','','','','','','lu ','','','','','Tam ','',
        '','','','','','yan ','','','','','','','','','','',
        '','','','','','','','','','Daan ','','','','su ','','',
        '','','','','','','','','','','','','','','','',
        'bian ','','la ','','','','qia ','','','','','','','','','',
        '','','','','','nu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','he ,ge','',
        '','','','','','','','','ma ','','','','','','','',
        '','','','','','','','','','xia ','','','','','','',
        '','','','','','','','','','','yu ','','','','','',
        '','jie ','xia ','','','','','cha ','','','','yang ','','','','',
        '','','wang ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Mo ','','jiu ','',
        ],
    'x27b':[
        '','hao ','','','','','','','','','','fa ','','','','',
        '','','','','','','','','','','','','','','yun ','',
        '','','','','','','','','Wai ','','gun ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','dan ','','','','','','','meng ','','','','','',
        '','','','','teng ','','','','','','','','Leoi6','sa ','','',
        '','','','','','','','','','','','','','','','',
        '','','','he ','','','','','','','','','','shan ','','',
        '','','','','','','','','','','','','','','','',
        '','ta ','','','','','','liu ','','','','','','','','',
        '','','','','','','','','','','','jue ','','','','',
        '','fen ','','','','he ','','','','','zhan ','','tai ','qian ','','',
        '','','','','Hang ','Hang ','','','','','','','','lao ','','',
        '','','','','','','jun ','','','','','','','','','',
        '','','','','','zai ','juan ','','','chu ','','','','','','',
        'kan ','','','','','Phong ','','','','','','','','','','',
        ],
    'x27c':[
        '','','','','','','','yu ','wu ','','Tian ','','','','','',
        '','','','','','','','Nanh ','','','','','','','','',
        '','','','','','','','Shuu ','','','han ','chu ','','tun ','','',
        '','','','','','','','','','na ','','','','','','ai ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','mai ','','','','lun ','jue ,jun','','',
        '','','','','','','','','','','','','','','','',
        '','','','huai ','','','','','','','','','','','','',
        '','','','','','ceng ','','hu ','','','','ju ','sha ','meng ','','',
        '','','','','','','','wei ','','','','','','','','',
        '','','zhe ','','','hu ','','','','','','Cop ','','','','',
        '','','','','','qu ','','','','','','','Beo ','','','',
        '','','fu ','','','','','Cop ','','','','','','','wu ','pei ',
        '','','','','','','','','Hum ','','','sha ','','zhao ','wei ','',
        '','','','','','','','','','tuan ','','','mei ','','','',
        '','','','','','','','','gu ','shao ','','','','','','',
        ],
    'x27d':[
        '','','peng ','','','','','','','','huan ','Beo ','fu ','','biao ','',
        '','','','','','biao ','','','','','guai ','','','','','',
        '','','','','','pei ','','','','','Suo ','','','','','Me ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Qua ',
        'pai ','','','','','','','','ai ','','','','','','','',
        '','','','She ','','','','','','','','','','','','',
        '','','','','Danh ','','','','','','yun ','','','xu ','','',
        '','','','','cheng ','','','','','','','','','','','',
        'yu ','','','','','','','','','','','','','','','',
        '','','','','','cha ','Faan ','ze ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'fen ','xie ','','','','','','','','','','','','Xoe ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','shan ','','Mua ','','','','','','ju ','',
        ],
    'x27e':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','Zhuan ','xue ','','','','','','','','',
        '','','','','','','lan ','ju ','','xun ','zhan ','gun ','','','','',
        '','','','','','','','','','','','Bui ','','','','chai ',
        '','','','','','','','','reng ','','','Vay ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Son ','','','xu ','','',
        '','Tham ','hu ','gan ','','','','','','','','','','','hu ','',
        'Tham ','Tham ','','','','','','','','','','','','','','',
        'jue ','','zu ','','','','','','','','','','jiao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','chu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','xian ','','','','','ju ','','Mut6','','','','','','',
        '','','','','','','','','','','','','','','','',
        'hu ,zao','qiu ','','fu ','lang ','sha ','','','','','','','','','','',
        ],
    'x27f':[
        '','','','','','','','','','','','','','Lanh ','','',
        '','xu ','','','leng ','','','fu ','','','','','cu ','','','',
        '','','','','dao ','','','','jie ,jue','','','yu ','','','Tang ','shu ,yu',
        '','','','','','','','','','','','','','','','',
        '','','','','jie ','','','Day ','Day ','','','','','','','',
        '','','Cau ','','','','','','','','','','','','','jie ',
        '','','','','','lu ','','chu ','','','','lian ','','','','',
        '','','','','','','e ','su ','Jue ','','','ju ','','','','',
        '','','','','','','xuan ','','','','','','Tron ','','','',
        'jiao ','','','','','','','','','','yu ','','','xun ','','',
        'xun ','','','ju ','','du ','','','','xun ,xuan','','','','','','jie ',
        '','qu ','','','','jue ','','','','','','jiu ','','','','Treo ',
        '','','','','','','','','','ku ,wu','','ku ','zha ','','','ba ',
        'Chen ','Nhac ','Dam6','hu ','nu ','e ','','','','','','','','','','',
        '','','','','','bie ','','','','ge ','','Dau ','','','','',
        '','','','','','','','yu ','','Mau ','Xoat ','ju ','','','','',
        ],
    'x280':[
        '','','','','','','','','Buoc ','','','','','Dung ','Lop ','',
        'Rong ','','','','','','hai ','','','','','cun ','','','','',
        '','','','Kei ','Choi ','','','','','','','','zai ','','','',
        'Bang ','','','','xun ','','','','','','','','','','','',
        '','xuan ','xie ','','han ','','','tun ','Gaang ','','cen ','','','Ren ','Choanh ','',
        '','','','','','','','','','','','','','Buot ','','',
        '','Noi ','','','','','','Noi ','Cuong ','','Dau ','','','','','',
        'Xui ','','','','','','','','','','','','Bon ','de ','','',
        '','','','peng ','','','','','','','','','','','','',
        'Leoi ','','','','Doc ','','','Co ','','','','','','','tan ','',
        '','','','wu ','','','chuan ','','','','','','','du ','','',
        '','hun ','','','','','','','','','','','','Dam6','Naam ','',
        '','','','','','','','','','','','','Giay ','Tot ','','Xam ',
        'Giay ','','','','','Soc ','kua ','teng ','','','ta ','sa ','','','Pun ','Pun ',
        '','','','sao ','','','','','','Sin ','','','','zu ','','',
        '','','jie ','neng ','','','','Chuc ','','','','','To ','Nhuc ','Xung ','',
        ],
    'x281':[
        '','','','','','','','','','','Te ','','','','','',
        '','','','','shuan ','zu ','','','','','','','','','','',
        'Tat ','','','','','','','','','','','','','','','yu ',
        '','','','','Sup ','','','','','','Chui ','','','','Ghe ','Giong ',
        '','Sup ','Mop ','','','','','','','Lung ','','xiao ','','Ren ','','Laam ',
        '','','shu ,chu','','','','','','','','','','','Jaang ','Nhap ','',
        '','','','','','Bay ','','','','','','','','','','',
        '','','','','','','','Doi ','','','','','','','Sum ','',
        '','','Khum ','','zhu ','','','cha ','juan ','','','','','','zei ','',
        '','','','','','','','','','','','','','Cui ','','',
        'Quay ','Dep ','','','','Tuon ','','','','','Jaang ','','','','','Buk6',
        'ta ,da','','','','','','','','','','','','','','','',
        '','kuang ','','','','bao ','lai ','','','Leo ','','','','','','',
        '','','','','','','lu ','','','','','','','','','',
        '','','','','','','chan ','','','zhan ','','','','','','',
        '','','','','','Nhao ','Khuy ','','','','','','','','','',
        ],
    'x282':[
        '','','','','','','','Laam ','die ','','','','','','','',
        '','','','leng ','','','','','','','Pei ','','','','','',
        '','','','','','','','','','','','zhu ','','','','',
        '','','','','','','','','','','ye ','','','','','',
        '','huang ','','','','','','','','Pei ','','','','','','',
        '','','','','','','Nei ','','','','','','','','Lung ','',
        'Ban ','','','','','','','','','','','','','mei ','','',
        '','tang ','','','','','','','','','','','Wu ','xiang ','','',
        '','','','','','','','','','','','','Lan ','','','',
        '','','','','','','','','','','','Laak ','','','','',
        '','','','','','','','','','','','','','','','',
        '','yu ','','','','','','','','','dai ','','xuan ','','','jue ',
        '','','','','','','','','du ','','','','','Wan ','','',
        '','','','','','','','','zha ','','','pao ','','','bu ','he ',
        '','','Lip ','','So ','','','ju ','hun ','','','','','','','Zhuai ',
        '','','','','','','','','','','','','','','','',
        ],
    'x283':[
        '','','','','zang ','','','','','','','','','','xu ','',
        '','','','','','','','','jun ','','','','','','','',
        'lu ','','','','','fu ','','','','Tang ','','','chao ','ta ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Co ','','','he ','','','','','','','mu ','',
        '','','xian ,jian','','','','','','','','','du ','','','','',
        '','','','','','','Sau ','','','peng ','','','','','','ju ',
        '','','','Yao ','','','','','','','','','','','','',
        '','','','','','','So ','','','','','','','','','',
        '','','','','yang ','','','','','','','','','','','Truoc ',
        'Truoc ','','','','','','','peng ','','','','jian ','jiao ','','','',
        '','','','peng ','Dang ','','qu ','','mu ','','','','','','fen ','',
        '','','','','','','','','','shuan ','jian ','','','','','',
        '','','','','lu ,du','','','','','','ge ','','','','','',
        '','','','','','xian ','','So ','','','','','','','','',
        '','','','xie ','ge ','','','','','jue ','','','','','','',
        ],
    'x284':[
        '','die ','','zhe ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','ku ','','qu ','','ge ','ban ','','','','','','','','Cay ','',
        '','ban ','','','','','','','','','','','','','ban ,bian','',
        '','','','','','','','','','','','','chen ','','','',
        '','','Tu ','','','','','','','','','','Xuong ','','','',
        '','','','','','wu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','pan ','','','','','','','qiu ','','','','','',
        '','','','','','','','','','','','','bie ','','kan ','',
        '','','','','','','','','nai ','','','','','','','',
        '','','','','','','','','','','Quanh ','','','','','',
        '','','','','','','','','','','die ','','','','','',
        '','','','','','','','','','','','','','','dai ','',
        '','Lung ','','','','','','','','','','','','','','',
        'jie ','','','','ya ','','','','','','','','','','','pei ',
        ],
    'x285':[
        '','','','','','','','','Choi ','','Suot ','','Co ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','shu ','','','','','','','','','ta ',
        '','','','','','','','','','','','','','','','Chuc ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'ze ','','chu ','','','','qiu ','','','','','','','','','',
        '','','','','','','','','','','','','','jie ','','',
        '','','','','','Sang ','','','','','','','yang ','','','jiu ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Mau ','','','','','','','','',
        '','xian ','','','','','xiang ','sha ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','dao ','','','','','','','','','Nhanh ','yu ,ju','','',
        '','chao ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','da ','',
        ],
    'x286':[
        '','','jiu ','','','','','','','sha ','','','','','','',
        '','','','','','','','','','xian ','','','','','xian ','',
        '','','','','','','','','','','','','','','jiu ','',
        '','Nhanh ','','','kao ','','','','','','','','','','','',
        '','','','','','','','','','','','','','Keo ','ta ','zan ',
        '','','','','zhu ','','Suot ','','','','','','','Lui ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','xiang ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','bian ','','','','','','','','','','',
        '','','','','','','','qie ','','','','','','','hao ','',
        '','','cun ','','ru ','zai ','','','','','','','','','','',
        '','','','','','','','','','','','','','shao ','han ','',
        'jun ','','bu ','','','','kuai ','','','','','','xiang ','','','',
        '','yun ','','','','pu ','','','','','','','pei ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x287':[
        '','','','','','','','','','','','','huan ','qiao ','','',
        '','','','','','','yu ','','mei ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','he ','','','he ','','','','','','','','','','chuang ','xu ',
        '','','','','','','','','','','','zhai ','','','','',
        '','guan ','','','','','','','','','','tu ','shun ','','hu ','',
        '','','','','','','dang ','','','','','','','feng ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'cheng ','','','yu ','','zhu ,chu','','qun ','','qu ','','ge ','','','','',
        '','','','','','','','','gai ','','','meng ','','','','',
        '','','','qu ','','','','','','','','','wan ','lei ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','dai ','','','','','','','','','','','qiu ','','',
        ],
    'x288':[
        '','','','','','','','','','Tam ','','','','','','',
        '','','Faan ','','','','bao ','','','','','','','','','',
        '','','','','','wei ','','','','','','','hao ','','','',
        '','','Giam ','Gay ','Sua ','Xoang ','','','','','','','','','','',
        '','','','jiao ','','','','','','Dam ','','','nei ','','yan ','',
        '','','','','','','','zha ','','','','','','','','',
        '','','','yan ','','','','','Gay ','','','hun ','','mu ','','',
        '','','','','','','','','','','','','Giam ','','','',
        '','','','','','','','liu ','han ','','meng ','hu ','','','','',
        '','','','','','','','','','','','','','','','Cay ',
        'meng ','','mu ','','hu ','Mi ','shai ,zha','','','','chao ','','','','','nian ',
        '','','','','','','','','','','','','','','','',
        '','','','','','chuai ','','','','','','','','','','',
        '','','','','','','','hu ','meng ','pao ','','','','','','',
        '','','','','Giam ','Dau ','Zeoi6','','lan ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x289':[
        '','','','','','','','','','','','','','','','',
        '','juan ','','','','','','','','','','','','','','',
        '','guang ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','jie ','','','','','','','','','','','','','',
        '','','','','','','','','','','','hu ','','','','',
        '','','','cen ','','','','','','','','','','','','',
        '','','','','','','dai ','','','','','','','','','',
        'Keo ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','','','Nen ','','','','','','Lao ','','',
        'liu ','','','','','','','','','','','','','','','',
        '','','','','','','Bua ','','','','','','','','','',
        '','xiang ','','','','bian ','','wu ','','','','','Bong ','','','',
        'Gang ','','','Xot ','','','','','','','sao ','','','','','',
        'zu ','','','','','','','','','','','','','','','',
        ],
    'x28a':[
        '','','','','','Hoat ','','','','','','','','','','',
        '','','','','','','','quan ','','','chao ','he ','','','','',
        'Cuoc ','wu ','','','Khep ','','Mai ','Thep ','','','','','','','','',
        'ruan ','','','zu ','','','yu ','tu ','meng ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','mao ','','','yu ','','','',
        'zu ','','','','','','','','','','','','','xia ','','',
        '','','','','','jian ','','','','','','','','','yu ','',
        '','','','','','liu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ruan ','','','yan ','','','','','','','','','',
        '','','','','Bam ','Lon ','','','Choc ','','Sat ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Han ','','','','','',
        '','','','','','Cuoc ','','','','','','','','','','',
        ],
    'x28b':[
        '','','','','','','','','','Dui ','','','','','','',
        'jue ','','','','ruan ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','zhu ','','','','','','','Baang ','Bay ','','Choang ',
        '','','Choang ','die ','','','','','','','','','','','','',
        '','Thau ','','','','','','','','','','','','','','',
        '','','','','','','','','','','Com ','','','','','',
        '','','','','','','','Bung ','Hom ','Cun ','','','','','','',
        'Nhon ','Thoi ','','','yu ','','','','Ban ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','cai ','','','','','','','','','','','jiang ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Dui ','','','','','','','',
        ],
    'x28c':[
        '','','qian ','','','','','','','','','','','','','ta ',
        '','diao ','','','','','','','','','','','jue ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Nen ','','','','yu ','','Ben ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','duan ','','','','','',
        '','','','','','','dao ','','','','','','','','','',
        '','','','','','','','','','','','','cen ','Dai ','Dai ','',
        '','','','','jun ','','','','zhu ','','an ','','','','','',
        '','','qiu ','','','','','','','','','','','','','',
        '','','','','','','','','','','','feng ','wu ','jiao ','','',
        'peng ','','','','','','','','','','','','','','','',
        'niao ','','chan ','','','','nang ','','','','Gau ','','','Cat6','','',
        '','','Mon ','','men ','','','','tun ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','die ','','','','','',
        ],
    'x28d':[
        '','','','','','','','','','','','','','','xu ','',
        '','Kuang ','','wei ','','','','die ','','','','','','','','',
        '','','he ','yan ','','','Cua ','','','tu ','','','hu ','','','',
        'chu ','','','','','','','','','','men ','','','','','',
        '','','','','','','','','','','zhe ','','','','','',
        '','','','','','','','','','','xie ','','','ta ','','fu ',
        '','','','Cua ','','','yu ','','','','xie ','','xian ','jian ','xu ','',
        '','','','','','','','','','','','','','','','',
        '','yan ','ai ','','','','','','','','jun ','','','','','',
        '','','','','','','','lang ','','Lan ','','','','shu ','','',
        '','','yu ','','','','','','','','','','hua ','wen ','','e ',
        '','','','','','','','','','Gwaan ','','','','','','',
        '','niu ','','','xiang ','','sa ','','','','','','','','run ','',
        '','','','jian ','xu ','','','','','shu ','','','','','','',
        '','','','','','xie ','','','','','','','','','','Cua ',
        '','','','','','','Cua ','','','','','','','','dang ','',
        ],
    'x28e':[
        '','','','','','','','','','','','','','Cup ','','',
        'reng ','','','','','','','han ','','','Ji ','gai ','','','','',
        '','','','','','','','','','','','','Zhen ','','','',
        'ju ','','','','','','','','','','','','','','','',
        '','','','','','','xuan ','','','','','','','','','',
        '','','','','','','','','xu ','','cheng ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','zhao ','','','','','','','',
        '','','','','','fu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','duan ','','','','qiu ','','','','','','','xun ','',
        '','','','','','','','','','Jiao ','','','','','','',
        '','','yan ','','','','','','','','','','','xu ','','',
        '','','','','','','','die ','','','','','','','','',
        '','','','','','','','liu ','','','','Luong ','','','','',
        '','','Xia ','','','','Geki ','','','','','','','','','',
        ],
    'x28f':[
        '','','','','','','','','zhan ','cuan ','wu ','','','','jue ','',
        '','','','','xun ','','','','','','Be ','','','','','',
        '','','','','chen ','','','','','','','qu ','','','zhan ','',
        '','jue ','','','','','','','','','','','','qu ','','meng ',
        '','','pu ','','','','','','','','','','','du ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','xia ',
        '','','','','','','','','','','','','','','','dai ',
        '','','','','','','','','','','','','yu ','','','',
        '','','','','fang ','','','','','','','','','','','',
        '','','','','die ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','tiao ','',
        '','','','','','','','','','','','','','','','wu ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','wei ','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x290':[
        '','','','','','','','','','','','run ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','wei ','','','','','','','','','','','','',
        '','','','Song ','','','','','','','','','','','','',
        '','','','','','','','','','','','','wei ','','','',
        '','','','','','','','','','','','','','','cai ','',
        '','','','','','','Loi ','','','','','','','','','',
        '','','','','','','Ngat ','','','','','','','','','',
        'Con ','Ngut ','','shai ','tun ','','','','','','','','','','fu ','Che ',
        'Ram ','Bung ','','','fu ','Phat ','ze ','pu ','','','','','','','pao ','Mu ',
        '','','','','hua ','','','','','','','','','','','',
        '','','','Rei ','','dian ','Set ','','','','','','','','','',
        'yan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','xuan ','','','','','',
        'dai ','','','','','','','','','','','','','','','',
        '','','','','ba ','','','dai ','','','','','','','','',
        ],
    'x291':[
        '','','','','','lu ','','','','','','ru ','','','Mua ','Bung ',
        '','','','','','dan ','meng ','xia ','','','','','','','','',
        '','','','','','','peng ','','Guot ','','','','','','','wu ',
        'Set ','','May ','','','Nap ','Xoi ','piao ','','','','','','','ze ','',
        '','','','','lu ','','','bu ','','','','','','man ','','',
        '','','','','','','','','','','','Bung ','','','','',
        'nan ','','he ','','','','','','','','','','','','cen ','',
        '','','','','','','','','','May ','Rau ','Zyu ','','','dan ','fu ',
        '','','','','','sa ','','','','','','Rao ','','Rao ','liu ','',
        'Sam ','','','','dian ','','','','','','','','','','','',
        'Mong ','Rao ','','','','','','','','','','','Mong ','','','',
        '','','','','','','','Sam ','','','','','','','Khuya ','',
        '','','','','','Mu ','Sam ','hun ','','','','','','Loa ','','',
        'qu ','','','','','','','','','','','','','','','',
        '','','Xanh ','','','','','','','','','','','','','fei ',
        '','','','','','','','','','','','','','fei ','','',
        ],
    'x292':[
        '','','Bay ','','','','','','pang ','dan ','','ai ','','','','',
        '','','','','','','','mai ','','','','','','','dao ','',
        '','','','','chu ','','','','','','','','wan ','','diao ','',
        '','','suan ','','','','','','','mian ','','','','','','',
        'lan ','','','','','','','','','','','','','','','',
        'gan ','','','','jian ','','','','','','','','hang ','','','',
        '','','','','','xuan ','','','','','','','','','','',
        'ang ','','','','','fen ','','','ju ','','','','','fu ','','qu ',
        '','','','ma ','','bao ','','yu ','','','','','','mai ','','',
        '','','','','jiao ','','','','','','','','','','','',
        '','','','','','','','','','','','','bu ','','','',
        '','','','','','zhe ','bu ','','','','jue ','xun ','','Hia ','','',
        '','','bai ','','','ta ','','','nao ','yu ','','','','','','',
        '','','','','','','','','Xie ','diao ','','','','','die ','fu ,fu',
        '','','xuan ,yun','','yu ','','','Xie ','fu ','','','xuan ','','','','',
        '','','','','','','','la ','','','gao ','','','e ','','mei ',
        ],
    'x293':[
        '','','','','','','','ta ','','ta ','','','','','','',
        'ta ','','','','','','','','ta ','','','','','','','',
        '','','','','','','','','','','ze ','lu ','','','xu ','',
        '','','xu ','','','','','','','','','','','','','',
        '','','bao ','','','','','','','','','sheng ','','','','fu ',
        '','','','','','','','Bang ','','','','','','','','',
        '','','Roi ','Dep ','','','','','','','','','','','','',
        '','','','xu ','','','','jue ','','','','','lu ','','','',
        '','','','','','','','','','','','','','','ge ','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','wei ','','','','yu ','','bai ','','ta ','','',
        '','','','','','yun ','yun ','duan ','','wei ','','','','','','',
        '','','','','','','hun ','','','','','','','','bai ','yu ',
        '','','','','','','','','','','','','','','','',
        '','','','','yu ','','','','','juan ','jue ','','','','','',
        ],
    'x294':[
        '','','','','','sa ','','','','','','','','','','',
        '','','','','','','','','','','fu ','peng ','','','','',
        '','zu ','','','','','','','','','','su ','','','','',
        '','','','','','','zhe ','','','','','','su ','','','',
        '','e ','','','','','','','guang ','','','','','ao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','men ','','','','','','','','','la ','',
        '','','','','yao ','','','','','xuan ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','yan ','','','','','','','','','',
        '','','','','','','','','','','','','','','qiu ','',
        '','','','','','','','','','','fu ','','','','wu ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','fu ','','','','','Ngup ','Mang ','bie ','','',
        '','','','','an ','Ngok6','wu ','','','','lu ','','','','','',
        '','','','','','','','','','','','jue ','','','','',
        ],
    'x295':[
        'wai ','','dun ','','jie ','','','','','','zhuan ','hang ','','','','',
        '','','','','','qiu ','','Lei ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ze ','xu ','','','','','','','','xu ','','','',
        'ao ','','','','','','','','','','','','','','','',
        'liao ','','','','','wai ','','','','','','','','','','',
        'han ','','','','dan ','','','','','','','','','Gai ','','',
        '','','','','','','','','','','','','','','yuan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','peng ','','','','',
        '','','','','tun ','','','','','','','','fu ','','','',
        '','','','','','','','','','','han ','','fu ','','','',
        '','','','To ','','','','','','sa ','','','','','','',
        'hua ','','','','','qiu ','','','','','','','','','sa ','',
        '','','','','han ','','','','','liu ','','','','','','',
        '','','','','Bung6','','','','','','','','','wu ','','',
        ],
    'x296':[
        'zhao ','','','','May ','','','','','','la ','','','yuan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','To ','yu ','','','','','','','','','','','',
        'su ','shuai ','','yu ','','','','','','su ','','yu ','','','','',
        '','','','','liu ','','cheng ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','niu ','','','','Bay ','','','','',
        '','','','','yu ','','','','','','','','','','','',
        '','','','','Nhu ','','niu ','','','','','na ','','','','',
        '','','','','','','','Qua ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','No ','Qua ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','zai ','','','mao ','','yu ','','','yu ','','',
        '','','','','','','','','','','ju ','','lu ','','','',
        ],
    'x297':[
        '','','','ju ','','','','Juan ','','','','','','','','',
        '','','','','','','','','','','','','','','','ang ',
        'Mam ','','','','','','','','','','','','','','','',
        '','','fu ','','','','','','','','','','','yan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','wu ','','yu ','','','','','','','','',
        'Qiu ','','','','','su ','','','','','','','','','','',
        '','','','','','','','','','','','Chan ','','jiang ','','',
        '','','','','','','','','zhu ','','','','','','','',
        '','','','','','','','','','','','','','','hai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','han ',
        '','yuan ,xuan','Qua ','','','','','ao ','','','','shan ','','','','',
        '','yu ','','','Caat ','','','','','','','','','','meng ','',
        '','','','','','','jie ','','','','','','','','huai ','',
        '','','','yu ','','','chan ,jie','','','','','Nang ','','','','',
        ],
    'x298':[
        '','','','','','','','','','','','','','','','',
        '','Ding ','','','Mao ','','','','','','','','','','','',
        'Cui ','','','','','','','Guc ','','','','','','','','wei ',
        '','Chui ','','Chui ','Cui ','Choi ','','fu ','','','','','','','','',
        '','','','yu ','','','','','','','','Thom ','','','','',
        '','','','','hai ','peng ','','','','','','','','','','bie ',
        '','','','','','','','','','','','fan ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','wan ','','','','','','','','wen ','','','',
        'zhe ','','','','ban ','bu ','','','','','','ge ','','','liu ','',
        '','','','','','','Giong ','','','','hu ','','','','','',
        'fu ','','Sai ','qu ','','','yu ','','','jiu ','','shu ','','','','fu ',
        '','','','','','','','','','','xu ','','','','','',
        '','Ngon ','','','','','','','','','','','fu ','bu ','','',
        '','','','','','','','','','zhe ','','','','','tu ','',
        '','lu ','','','','','','','fu ','','','','','','','',
        ],
    'x299':[
        '','','','','','','','','','','xian ,jian','kun ','','','','',
        '','','','','','','','','','cheng ','','','','','tan ','',
        'xie ','','','duan ','','','','','','e ','','','','','','',
        '','','','','','','','','','','yu ','','','','','',
        '','','','','','','','zhan ','','','','Au6','qia ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','yu ','','',
        '','','','','','','','','','','','','','tu ','','zu ',
        '','','','','','','','','','bie ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'bang ','yu ','Jyu ','','','','','','','','','','','','','',
        '','','','','','','','','','xian ','meng ','','','','','',
        '','','','','','','','cai ','du ','','','','','','','jue ',
        '','','ju ','','','','','','qu ','','','','','','','',
        '','jue ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x29a':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','yu ','','yu ','','','ba ','','','',
        'ya ','','','','','','','','','fan ','','','','Que ','','',
        '','','ma ','','','','','','','','','','Kheo ','','','',
        '','','','','','','','Song ','','','','','','Peng ','','',
        '','','','','','','Song ','','','','','','','','','',
        'zu ','leng ','','','','','','dan ','','','Xuong ','Xuong ','','','du ','bian ',
        '','qia ','he ','','','','yan ','','','','','teng ','','','','Hom ',
        '','','','hai ','','','','','','xu ','','','','','','',
        '','','','','','','','Jue ','','','','pu ','','','Sun ','',
        '','','','','','','','','','','','','','','','',
        '','','','','yan ','So ','','','','','','','','Cut ','','',
        'kai ','mao ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','sao ','','','','','','','','','',
        '','','','','ju ','','','','','cheng ','','','','','','',
        ],
    'x29b':[
        '','','','','','','','','','','','','','','Zam ','',
        '','Chom ','','','','','','','','','','','ju ','','','zha ',
        '','','','','','','','','','','','','','','','',
        '','dao ','','','','','','','','','','','','','','',
        '','','','','','','','','','','ju ','','','','','',
        '','','','','','','','','','','','','Xui ','','','dao ',
        '','','an ','','','han ','','','','','','','','','','',
        '','','','','','Quan ','Rau ','','','','fu ','','','','','',
        '','qia ','','','','na ','','','','','','','','','','',
        '','','','','Quan ','','','','','','','','','ya ','','',
        '','','','','','','','','','','','','','Ria ','','',
        '','','','','','','','','','','','','','','','',
        '','Rau ','','','zun ','','nao ','','','','','','','','cheng ','',
        '','','','','','','','','jiao ','','','yao ','','','can ','',
        '','','','','','','','','','','','','','Ban ','','Xoam ',
        '','pu ','zhuang ','','','','','','','','','','','la ','','',
        ],
    'x29c':[
        '','','','zhan ','','','','','Nheo ','','','','','bian ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','ju ','','','','jue ','','yu ','','','','','hu ',
        '','','','xie ','er ','','','','','','','','','','','',
        '','','','','','','','','','','er ,xian','','yu ','hu ','','',
        '','','','','','','','','','ku ','','','','','jiao ','',
        '','','','','','','','','ru ','','','','','','','',
        '','yu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','hao ','','','niu ','','hua ',
        '','','','','','','','','','','','','','','','',
        'zhu ','Coi ','','','','Troi ','','','','','','','zhu ','','','',
        '','','zu ','','','','','','','','','','','','yu ','',
        '','','','','','','lai ','','','','Ranh ','','wu ','','fu ','zhuan ',
        '','','su ','','yao ','','','','','','','','','','','',
        '','','yan ','','','zhu ','','','','','','','','','','',
        '','','','Troi ','','ju ','','','','','','','','','','',
        ],
    'x29d':[
        '','','','','','','','shai ','','yun ','','','','','','',
        '','','jiang ','','','','','','ju ','','Troi ','','','teng ','wei ','',
        '','gu ','','','liao ','','','','','','','','','','','',
        '','','meng ','cha ','','','','','','qu ','','lei ','','','','',
        '','','','Troi ','','qu ','','','','','','Gyo ','','qiu ','','hua ',
        '','','','','','','','','','','du ','','','Chai ','','',
        '','','','','','','mu ','','','','','','hu ','','','',
        '','','','','','','','','','fu ','','','','Tom ','','',
        '','','zhu ','','zhu ','Ci ','','','','Pou ','','','','','','',
        '','','','','','','mu ','','','','','','','','','Buop ',
        '','meng ','','','','','guai ','jiu ','','mu ','','','Si ','wu ','','ru ',
        '','zha ','','','','','','','','','','','','','','',
        '','','xie ','','jiang ','','','Hung ','','','Thu ','','','','','',
        'ju ','','','','','Luon ','bu ','','','','','','','','','',
        '','','','','','','','','','','','','','jiang ','','',
        'xun ','','','','','','Mang ','','','','','qia ','','','','',
        ],
    'x29e':[
        '','','','tu ','hua ','','','','','','','','','','','',
        'ru ','','','','','','','','','','','','','','','',
        '','','','','','','','','Yi ','','','','','','Bong ','Chuoi ',
        'Go ','','','','','','','','Thia ','','','','','','ye ','',
        '','','','','hai ','','','','','','','','','','an ','ba ',
        '','han ','','','','','','','','','','','','','','nai ',
        '','','','','Thu ','','','','','Nau ','','Tep ','','Chay ','Mu ','Tuoi ',
        '','chu ','','','','','','','','','ge ','','han ','','na ','ge ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Bon ','','Trau ','','','','','Bong ','','Bon ','xie ','','','','Soc ',
        'yu ,wu','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Mam ','','Sop ','Dua ','','Tram ','','bu ','jian ','','wu ','Tram ','','zhuan ','','Vay ',
        '','','','','','','','','','','','','','','','',
        '','','','','','die ','','','','','Vay ','Leo ','','','','',
        ],
    'x29f':[
        'Vay ','','','','','','','','Ao ','','','','','','','',
        '','','','','','','','','','ge ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','xu ','','','Sau ','Lui ','','','','wei ','',
        '','','','','','','Ruoc ','','','','','','','','','',
        '','','','','Sau ','Luon ','','','','qu ','','','','','','',
        '','','','','','','','ba ','Nheo ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','han ,yan','','',
        '','bao ','','','','','','xun ','','','','','','','','',
        '','','','','','','jie ','','','','','hu ','','','','fu ',
        '','','mao ','','','','','','','','','','','','','',
        '','','','bao ','','','','','Mao ','','Khuou ','','','ju ','Caa ','qu ',
        '','','','','','qu ','','','Khuou ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a0':[
        '','','','','Chim ','','','','','','','','','','','',
        '','','Shi ','','','','','','jiang ','','','','','','','',
        'xun ','','','ju ','','','','','','','','','','','','',
        '','','','','','','','','','','fu ','','','','jie ','',
        'yu ','','','','Ket ','Sac ','Hau ','Song ','zhuang ','','','cheng ','','jie ','','chen ',
        '','','','','','','qu ','','','','','','','','','',
        'jue ','yan ','','','','ju ','','','','','','','','','xiu ','',
        '','','','','Coc ','Coc ','','','','','','','','su ','','',
        '','','','','','','','','','yu ','','fu ','ta ','','','',
        '','','hu ','','','','','','','','','','mei ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Cun ','','yu ','','','','','','','','pen ','fu ','',
        '','','liu ','','','','','','jie ','','','','','yu ','yu ','Mei ',
        '','mao ','','fu ','','','','','','','','jian ','','','','',
        '','','','','','','','','','','','','','','','',
        '','Hau ','','','Ga ','','','','','','','','','','','Ge ',
        ],
    'x2a1':[
        '','','xia ','','','Set ','','','','','qu ','','','','ge ','',
        '','su ','','','','','','','','','','','','','','',
        '','','','','','Cut ','','','','','','','','','hu ,gu','',
        '','','','mai ','','','','','','','','','','','','',
        '','','','','su ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Cuoc ','Choi ','Ri ','Sam ','','','','Tu ','','',
        '','','','','','','','','jie ','','','','','','','',
        '','','qu ','','','','','','','','','xie ','','','','',
        '','','','','','','','','','','','','','','','',
        'fu ','','','','','Khuou ','Tu ','','','','','','','','','',
        'ya ','liu ','','','','','can ','64272.110,chu ','','','','','','','','jian ',
        '','','','','','','chu ,du','','ai ','','','Cui ','','','Quam ','',
        '','xun ','','','','','','','','','','','','yu ','','',
        '','','','','','','','','','Ngan ','','Cui ','','cai ','','liu ',
        '','','jie ','','','','','','','la ','','','','','','',
        ],
    'x2a2':[
        '','','','','','','','','lai ','','he ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','jue ','','','','guan ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Muoi ','','tan ','','En ','','','','','','kan ',
        '','bian ','','','Muoi ','','','','','','','','','','','gan ',
        '','','','','','Mam ','','gan ,tan','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','xiao ','','zhu ','','yu ','','','','',
        '','jian ','','','','','','','','yu ','','','','zu ','','',
        'nuan ','','','','','','','','','','','','','su ','','',
        '','pu ','','','','','','','','','','','','','yu ','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a3':[
        '','','','','','na ','qu ','','','','','tun ','','','','',
        '','','','ku ','su ','','','','','','','','','','','ze ',
        '','','','ge ','','','','jie ','','','tiao ','','','','','',
        '','','','','','','shu ','','','','','','','hun ','','nie ',
        '','jun ','hu ','','lu ','','','','chao ','','','','','','','fu ',
        '','','','','','','','','','','','','','yun ','','',
        '','','','','','','','xuan ','','','','','','','','',
        '','','','','','','shan ','','Qu ','du ','','sao ','','','','kuang ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','liu ','','','','','','','','','','mei ','','',
        '','','','','tun ','kang ','tun ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','heng ','','','','','','Huang ','','','','','','',
        '','','','','','','','','','','kuang ','piao ','','','','',
        '','','','hu ','','','bao ','','','','','hu ','','','','',
        ],
    'x2a4':[
        'Naa ','','','','','','bie ','','','','','','','','','',
        '','','','','','','','','','','','','','dai ,tai','du ','',
        '','','','','','tai ','','shu ','','','','','','','su ','',
        '','','','','','','','','','','','','','','','',
        '','','cha ','','lu ','','yu ','','yan ','','qiao ','','yu ','','','tu ',
        '','Ngam ','tun ','','','','','','','','','','','yu ','','',
        '','','','','','','','die ','cha ','dian ','','','','','','',
        '','','','','','','','wai ','','','','','','zhai ','','',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','','','','Tham ','','','','','ma ','','','',
        '','','','','','','','','','','mai ','','Nung ','','','',
        '','','','','','','','','','','','','','','dan ','teng ',
        '','','','','','','','','','','yu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','cu ','','','','','','','','','','Sam ','','','','',
        'cu ','','','','','','','','','','','','','','','',
        ],
    'x2a5':[
        '','','Ding ','','','','','','','','','','','peng ','','',
        '','','','','','','','','','','','','','','','',
        'Trong ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','hu ','','','','','','',
        '','','','','','','','','','','','','','cu ','jun ','',
        '','','','','','','','','er ','','','','','ai ','hu ','',
        '','hu ','','','','','','','','','','','','','','',
        '','','','','jiao ','','','','pu ','','','jie ','lu ','','','',
        'yao ,ya','','','','','','','','','Hou ','','qiu ','jue ','','','',
        '','','','','','','','','','xu ','','','','Ngui ','','',
        '','','','','','','su ','liao ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','pa ','','','','','','','','','na ','','',
        '','','','','','','zhan ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a6':[
        '','Kap6','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','zu ','','','zhan ','','','','','',
        '','','Ji ','','','Rang ','','','','he ','qia ','','','','','',
        '','','','','','','','','hu ','','yan ','','','','','',
        '','','','','','','','','','','','Nak ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','jue ','','','','','','','','','','',
        '','','','','','','','','','','Trong ','','','','','',
        '','','','','','zhe ','','','','Gwi ','','','gan ','','','cu ',
        '','','','','','','','','','zhu ','','','','','','',
        'xiao ','','','','','Rua ','','Rua ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a7':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a8':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Bai ','','','','','','','Zhan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Luan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2aa':[
        '','','','','','','','','','','Song ','','','','','',
        '','','','','','','','Jue ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Yong ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2ae':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Nu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Cong ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2af':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Xian ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b0':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Li ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Fei ','','','','','','','',
        '','','','','','','','','','Su ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Kou ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b1':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Chi ','','','','','','','',
        '','','','','','','','','Xun ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b2':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Qia ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Gong ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b3':[
        'Ji ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Luo ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Yi ','','','','','','',
        '','','Nao ','','','','','','','','','','','','','',
        'Xi ','','Xiao ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Jiao ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b4':[
        '','','','','Yue ','','Kuai ','','','Ling ','','','','','','',
        'Ni ','','','Bu ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Han ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Fu ','','Cong ','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b5':[
        '','','','','','','','','','','','','','','Jue ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Duo ','','','','','','','Su ','','','','','','','Huang ','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b6':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Han ','Ai ','','','','Ti ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Xu ','Gong ','','','','','','',
        '','','Ping ','','Hui ','Shi ','','','','Pu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Zhi ','','','Jue ','',
        '','','Ning ','','','','','','','','','','','','','',
        '','','','','','','Chi ','','Ti ','','','','','','','',
        ],
    'x2f8':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Gai ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2f9':[
        '','','','','','','','Baan6','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ]
}
