"""
Unicode code point dictionary.
Based on Unicode.org Unihan database.
"""
__license__ = 'GPL 3'
__copyright__ = '2010 Hiroshi Miura <miurahr@linux.com>'
__docformat__ = 'restructuredtext en'

CODEPOINTS = {
    'x34':[
        'Qiu ','Tian ','','','Kua ','Wu ','Yin ','','','','','','Si ','','','',
        '','','','','','','Ye ','','','','','','Chou ','','','',
        '','Nuo ','','','Qiu ','','','','Xu ','Xing ','','Xiong ','Liu ','Lin ','Xiang ','Yong ',
        'Xin ','Zhen ','Dai ','Wu ','Pan ','','','Ma ','Qian ','Yi ','Zhong ','N ','Cheng ','Fung ','','',
        '','Zhuo ','Fang ','Ao ','Wu ','Zuo ','','Zhou ','Dong ','Su ','Yi ','Jiong ','Wang ','Lei ','Nao ','Zhu ',
        'Suk ','','','','Xu ','','','Saan ','Jie ','Die ','Nuo ','Su ','Yi ','Long ','Ying ','Beng ',
        '','','','Lan ','Miao ','Yi ','Li ','Ji ','Yu ','Luo ','Chai ','Nom ','','','Hun ','Xu ',
        'Hui ','Rao ','','Zhou ','Caam ','Han ','Xi ','Tai ','Ai ','Hui ','Jun ','Ma ','Lue ','Tang ','Xiao ','Tiao ',
        'Zha ','Yu ','Ku ','Er ','Nang ','Qi ','Chi ','Mu ','Han ','Tang ','Se ','Si ','Qiong ','Lei ','Sa ','',
        '','Hui ','Pu ','Ta ','Shu ','Zoeng ','Ou ','Tai ','','Mian ','Wen ','Diao ','Yu ','Mie ','Jun ','Niao ',
        'Xie ','You ','','','She ','Fung ','Lei ','Li ','Sin ','Luo ','Sek ','Ji ','','Kwaan ','','',
        'Quan ','','Cai ','Liang ','Gu ','Mao ','Gung ','Gua ','Sui ','Din ','','Mao ','Man ','Hyun ','Shi ','Li ',
        '','Wang ','Kou ','Chui ','Zhen ','Ding ','','','Bing ','Huan ','Dong ','Gong ','Cang ','','Lian ','Jiong ',
        'Lu ','Xing ','','Nan ','Xie ','','Bi ','Jie ','Su ','Hung ','Geoi6','Gung ','You ','Xing ','Qi ','Phay ',
        'Dian ','Fu ','Luo ','Qia ','Jie ','Tong ','Bak ','Yan ','Ci ','Fan ','Lang ','','Fu ','He ','Diu ','Li ',
        'Hua ','Tou ','Pian ','Dai ','Jun ','E ','Qie ','Yi ','Jue ','Rui ','Jian ','Gong ','Chi ','Chong ','Chi ','',
        ],
    'x35':[
        'Lue ','Daang ','Lin ','Jue ','Su ','Xiao ','Chan ','Put ','','Zhu ','Dan ','Jian ','Zhou ','Duo ','Xie ','Li ',
        'Cim ','Chi ','Xi ','Jian ','','Ji ','','Fei ','Chu ','Bang ','Kou ','','Ba ','Liang ','Kuai ','',
        'He ','Bit ','Jue ','Lei ','Shen ','Pi ','Yang ','Lu ','Bei ','E ','Lu ','','Coek ','Che ','Nuo ','Suan ',
        'Heng ','Yu ','','Gui ','Yi ','Xian ','Gong ','Lou ','Cam ','Le ','Shi ','Pei ','Sun ','Yao ','Jie ','Zou ',
        '','Que ','Yin ','Him ','Zhi ','Jia ','Hu ','La ','Hou ','Ke ','Bou ','Jing ','Ai ','Deoi ','E ','Chu ',
        'Xie ','Chu ','Wei ','','Teng ','Huan ','Su ','You ','Caam ','Jun ','Zhao ','Xu ','Shi ','','Caat ','Kui ',
        'Soeng ','He ','Gai ','Yan ','Qiu ','Yi ','Hua ','Si ','Fan ','Zhang ','Dan ','Fang ','Song ','Ao ','Fu ','Nei ',
        'Mau ','You ','Hua ','Hung ','Chen ','Uong ','Ng ','Hua ','Lap ','Fa ','Hao ','Pou ','Dung6','Si ','','',
        'Le ','Lin ','Yi ','Hou ','Zaau ','Xu ','Qu ','Nhe ','','','','','','','','Nei ',
        'Wei ','Xie ','Ti ','Hong ','Tun ','Bo ','Nie ','Sum ','San ','','','','','','Wai ','Shou ',
        'Ba ','Ye ','Ji ','Tou ','Han ','Jiong ','Dong ','Wen ','Lu ','Sou ','Guo ','Ling ','','Tian ','Lun ','',
        '','','','','','ge ','Ye ','Shi ','Xue ','Fen ','Chun ','Rou ','Duo ','Ze ','E ','Xie ',
        'Zaau ','E ','Sheng ','Wen ','Man ','Hu ','Ge ','Xia ','Man ','Bi ','Ji ','Hou ','Zhi ','','Gaa ','',
        '','Boi ','Ai ','Ci ','Hin ','Gou ','Thao ','Bai ','Bo ','Na ','Trat ','Xiao ','Suc ','','','',
        '','','Rong ','Ti ','Cu ','Kuo ','Lao ','Zhi ','Ai ','Xi ','','Qie ','Zaa ','Hei ','','',
        'Chu ','Ji ','Huo ','Ta ','Yan ','Xu ','Put ','Sai ','','','','Go6','Ye ','Xiang ','Heoi ','Xia ',
        ],
    'x36':[
        'Zuo ','Yi ','Ci ','','','Xian ','Tai ','Vang ','Yi ','Zhi ','Yi ','Xian ','Ju ','Ji ','Han ','',
        'Pao ','Li ','','Ran ','Can ','Han ','Yan ','','','Yan ','Han ','Haam ','Chi ','Nian ','Huo ','',
        'Bi ','Xia ','Weng ','Xuan ','Waan ','You ','Qin ','Xu ','Nei ','Bi ','Hao ','Jing ','Ao ','Ao ','','',
        'Zam ','Taan ','Ju ','Zaau ','Zuo ','Bu ','Jie ','Ai ','Zang ','Ci ','Fa ','Zaan ','','','','Nie ',
        'Liu ','Mang ','Dui ','Bong ','Bi ','Bao ','','Chu ','Han ','Tian ','Chang ','','','Do ','Wai ','Fu ',
        'Duo ','Yu ','Ye ','Kui ','Han ','Kuai ','','Kuai ','Ziu ','Long ','Sing ','Bu ','Chi ','Xie ','Nie ','Lang ',
        'Yi ','Zung ','Man ','Zhang ','Ho ','Gun ','','','Ji ','Liao ','Ye ','Ji ','Yin ','','Da ','Yi ',
        'Xie ','Hao ','Yong ','Han ','Chan ','Tai ','Tang ','Zhi ','Bao ','Meng ','Gui ','Chan ','Lei ','','Xi ','',
        'Hei ','Qiao ','Rang ','Yun ','','Long ','Fu ','Zuk ','','Gu ','Hoi ','Diu ','Hua ','Guo ','','Gao ',
        'Tao ','','Shan ','Lai ','Nie ','Fu ','Gao ','Qie ','Ban ','Gaa ','','Xi ','Xu ','Kui ','Meng ','Chuo ',
        'Hiu ','Ji ','Nu ','Xiao ','Yi ','Yu ','Yi ','Yan ','','Ran ','Hao ','Sha ','Gwan ','You ','Daam ','Xin ',
        'Bi ','Zaau ','Dian ','O ','Bu ','Dung ','Si ','Er ','Si ','Mao ','Yun ','Gei ','Naau ','Qiao ','','Pao ',
        '','Ping ','Nuo ','Jie ','Zi ','Er ','Duo ','','','','Duo ','','','Qie ','Leoi ','Ou ',
        'Sou ','Can ','Dou ','Ci ','Peng ','Yi ','So ','Zuo ','Po ','Qie ','Tong ','Xin ','You ','Bei ','Long ','',
        '','','','','','Ta ','Lan ','Man ','Qiang ','Zhou ','Em ','Sek ','Lu ','Sik ','Sao ','Mian ',
        'Fan ','Rui ','Fa ','Cha ','Nao ','Cing ','Chou ','Gai ','Shu ','Pian ','Aam ','Kui ','Sha ','Saan ','Xian ','Zhi ',
        ],
    'x37':[
        '','','Fung ','Lian ','Xun ','Xu ','Mi ','Hui ','Mu ','Zung ','Pang ','Yi ','Gou ','Tang ','Qi ','Yun ',
        'Shu ','Fu ','Yi ','Da ','','Lian ','Cao ','Can ','Ju ','Lu ','Su ','Nen ','Ao ','An ','Qian ','',
        'Ceoi ','Sung ','','Ran ','Shen ','Mai ','Han ','Yue ','Er ','Ao ','Xian ','Ma ','','','Lan ','Hei ',
        'Yue ','Dong ','Weng ','Huai ','Meng ','Niao ','Wan ','Mi ','Nie ','Qu ','Zan ','Lian ','Zhi ','Zi ','Hai ','Xu ',
        'Hao ','Xun ','Zhi ','Fan ','Chun ','Gou ','','Chun ','Luan ','Zhu ','Shou ','Liao ','Jie ','Xie ','Ding ','Jie ',
        'Rong ','Mang ','Geoi ','Ge ','Yao ','Ning ','Yi ','Lang ','Yong ','Yin ','','Su ','Sik ','Lin ','Ya ','Mao ',
        'Ming ','Zui ','Yu ','Ye ','Gou ','Mi ','Jun ','Wen ','','Hoi ','Dian ','Long ','','Xing ','Cui ','Qiao ',
        'Mian ','Meng ','Qin ','','Wan ','De ','Ai ','','Bian ','Nou ','Lian ','Jin ','Zyu ','Chui ','Zuo ','Bo ',
        'Fui ','Yao ','Tui ','Ji ','Aam ','Guo ','Ji ','Wei ','Bui6','Zaat ','Xu ','Nian ','Yun ','','Ba ','Zhe ',
        'Ju ','Wei ','Xi ','Qi ','Yi ','Xie ','Ci ','Qiu ','Tun ','Niao ','Qi ','Ji ','Teoi ','','','Dian ',
        'Lao ','Zhan ','Zi ','Fan ','Yin ','Cen ','Ji ','Hui ','Zai ','Lan ','Nao ','Ju ','Qin ','Dai ','Shutsu ','Jie ',
        'Xu ','Cung ','Yong ','Dou ','Chi ','Tou ','Min ','Huang ','Sui ','Ke ','Zu ','Hao ','Cheng ','Xue ','Ni ','Chi ',
        'Lian ','An ','Chi ','Si ','Xiang ','Yang ','Hua ','Cuo ','Qiu ','Lao ','Fu ','Dui ','Mang ','Lang ','Tuo ','Han ',
        'Mang ','Bo ','Kwan ','Qi ','Han ','','Long ','Ban ','Tiao ','Lao ','Qi ','Zan ','Mi ','Pei ','Zhan ','Xiang ',
        'Gang ','','Qi ','','Lu ','Caam ','Yun ','E ','Quan ','Min ','Wei ','Quan ','Shu ','Min ','Daat6','',
        'Ming ','Yao ','Jue ','Li ','Kuai ','Gang ','Yuan ','Da ','Gou ','Lao ','Lou ','Qian ','Ao ','Biao ','Zung ','Mang ',
        ],
    'x38':[
        'Dao ','Caam ','Ao ','','Xi ','Fu ','Daan ','Jiu ','Run ','Tong ','Qu ','E ','Hei ','Ji ','Ji ','Hua ',
        'Jiao ','Zui ','Biao ','Meng ','Bai ','Wei ','Ji ','Ao ','Yu ','Hao ','Dui ','Wo ','Ni ','Cuan ','','Li ',
        'Lu ','Niao ','Hua ','Lai ','','Lu ','Fung ','Mi ','Yu ','Fong ','Ju ','','','Zhan ','Pang ','Yi ',
        '','Ji ','Bi ','','Ren ','Fong ','Fan ','Ge ','Ku ','Jie ','Miao ','Hei ','Si ','Tong ','Zyun ','Ci ',
        'Bi ','Kai ','Li ','Fong ','Sun ','Nuo ','Fong ','Ji ','Men ','Xian ','Qia ','E ','Mao ','','Saam ','Tou ',
        'Zin ','Qiao ','Zeon ','Kwaan ','Wu ','Zing ','Chuang ','Ti ','Lian ','Bi ','Haat6','Mang ','Xue ','Feng ','Lei ','Zou ',
        'Zheng ','Chu ','Man ','Long ','','Yin ','Baan ','Zheng ','Qian ','Luan ','Nie ','Yi ','','Ji ','Ji ','Zhai ',
        'Yu ','Jiu ','Huan ','Di ','Lup ','Ling ','Ji ','Ben ','Zha ','Ci ','Dan ','Liao ','Yi ','Zhao ','Xian ','Chi ',
        'Ci ','Chi ','Yan ','Lang ','Dou ','Long ','Chan ','','Tui ','Cha ','Ai ','Chi ','','Ying ','Cha ','Tou ',
        '','Tui ','Cha ','Yao ','Zong ','Zung ','Pun ','Qiao ','Lian ','Qin ','Lu ','Yan ','Kong ','Sou ','Yi ','Chan ',
        'Jiong ','Jiang ','','Jing ','','Dong ','Go ','Juan ','Han ','Di ','Wu ','','Hong ','Tou ','Chi ','Min ',
        'Bi ','','Xun ','Lu ','Sai ','She ','Bi ','','Bi ','','Xian ','Wei ','Bie ','Er ','Juan ','',
        'Zhen ','Bei ','Yi ','Yu ','Qu ','Zan ','Mi ','Ni ','Si ','Gung ','','Daan ','Shan ','Tai ','Mu ','Jing ',
        'Bian ','Rong ','Ceng ','Can ','Ding ','','','','Keoi ','Di ','Tong ','Ta ','Xing ','Sung ','Duo ','Xi ',
        'Tong ','','Ti ','Shan ','Jian ','Zhi ','Wai ','Yin ','','','Huan ','Zhong ','Qi ','Zung ','','Xie ',
        'Xie ','Ze ','Wei ','','','Ta ','Zhan ','Ning ','','','Sam ','Yi ','Ren ','Shu ','Cha ','Zhuo ',
        ],
    'x39':[
        '','Mian ','Ji ','Fang ','Pei ','Ai ','Fan ','Ao ','Qin ','Qia ','Xiao ','Fan ','Gaam ','Qiao ','Go ','Tong ',
        'Tip ','You ','Gou ','Ben ','Fu ','Chu ','Zhu ','','Chu ','Zaan ','Hang ','Nin ','Jue ','Cung ','Cha ','Kong ',
        'Lie ','Li ','Xu ','Paang ','Yu ','Hai ','Li ','Hou ','Gong ','Ke ','Yuan ','De ','Hui ','Giu ','Kuang ','Jiong ',
        'Zan ','Fu ','Qie ','Bei ','Xi ','Ci ','Pang ','Haam ','Xi ','Qiu ','Huang ','Nan ','','Chou ','San ','Jim ',
        'De ','De ','Te ','Men ','Ling ','Shou ','Dian ','Can ','Die ','Che ','Peng ','Zi ','Ju ','Ji ','Lai ','Tian ',
        'Yuan ','Zaau ','Cai ','Qi ','Yu ','Lian ','Cung ','','','','Yu ','Ji ','Wei ','Mi ','Cui ','Xie ',
        'Xu ','Xi ','Qiu ','Hui ','Ging ','Ngung ','Qie ','Shun ','Chui ','Duo ','Lou ','Deon ','Pang ','Tai ','Zhou ','Yin ',
        'Sou ','Fei ','Shen ','Yuan ','Yi ','Hun ','Se ','Ye ','Min ','Fen ','He ','','Yin ','Ce ','Ni ','Ao ',
        'Feng ','Lian ','Chang ','Chan ','Ma ','Di ','Hu ','Lu ','','Yi ','Hua ','Caa ','Tui ','E ','Hua ','Sun ',
        'Ni ','Lian ','Li ','Xian ','Yan ','Long ','Muon ','Jian ','Gik ','','Bian ','Yu ','Huo ','Miao ','Chou ','Hai ',
        '','Le ','Jie ','Wei ','Yi ','Huan ','He ','Can ','Lan ','Yin ','Xie ','Zaat ','Luo ','Ling ','Qian ','Huo ',
        'Cim ','Wo ','Zoi ','','Ge ','Zyu ','Die ','Yong ','Ji ','Ang ','Ru ','Xi ','Shuang ','Xu ','Yi ','Hu ',
        'Ji ','Qu ','Tian ','Sau ','Qian ','Mu ','Gaan ','Mao ','Yin ','Gai ','Ba ','Xian ','Mao ','Phang ','Ya ','Gong ',
        'Song ','Wei ','Xue ','Gwaa ','Guai ','Jiu ','E ','Zi ','Cui ','Bi ','Wa ','Hin ','Lie ','Gaa ','','Kuai ',
        '','Hai ','Zaan ','Zhu ','Chong ','Xian ','Xuan ','So ','Qiu ','Pei ','Gui ','Er ','Gong ','Qiong ','Bak6','Lao ',
        'Li ','Chen ','San ','Bo ','Wo ','Pou ','Hang ','Duo ','Paang ','Te ','Ta ','Zhi ','Biao ','Gu ','Hot ','Coeng ',
        ],
    'x3a':[
        'Bing ','Zhi ','Dong ','Cheng ','Zhao ','Nei ','Lin ','Po ','Ji ','Min ','Wei ','Che ','Gou ','Bong ','Ru ','Taan ',
        'Bu ','Zung ','Kui ','Lao ','Han ','Ying ','Zhi ','Jie ','Xing ','Xie ','Xun ','Shan ','Qian ','Xie ','Su ','Hai ',
        'Mi ','Hun ','Nang ','','Hui ','Na ','Song ','Ben ','Liu ','Jie ','Huang ','Lan ','','Hu ','Dou ','Huo ',
        'Ge ','Yao ','Ce ','Gui ','Jian ','Jian ','Chou ','Jin ','Ma ','Hui ','Men ','Can ','Lue ','Pi ','Yang ','Ju ',
        'Ju ','Que ','','','Shai ','Cau ','Jiu ','Hua ','Xian ','Xie ','Syun ','Su ','Fei ','Ce ','Ye ','',
        '','','Cam ','Hui ','Tun ','Ling ','Qiang ','Xi ','Yi ','Nim ','Meng ','Tuan ','Giam ','Hao ','Ci ','Zhai ',
        'Piao ','Luo ','Mi ','Buk ','Fu ','Cam ','Xie ','Bo ','Hui ','Qi ','Xie ','','Hei ','Bo ','Qian ','Ban ',
        'Jiao ','Jue ','Kun ','Song ','Ju ','E ','Nie ','','Die ','Die ','Pei ','Gui ','Zi ','Qi ','Chui ','Gwaat6',
        'Yu ','Qin ','Faat ','Ke ','Fu ','Gaang ','Di ','Xian ','Gui ','He ','Qun ','Han ','Tong ','Bo ','Shan ','Bi ',
        'Lu ','Ye ','Ni ','Chuai ','San ','Diao ','Lu ','Tou ','Lian ','Ke ','San ','Zhen ','Chuai ','Lian ','Mao ','Deon ',
        'Qian ','Ke ','Shao ','Qiao ','Bi ','Zaa ','Yin ','Kaap ','Shan ','Su ','Sa ','Rui ','Zhuo ','Lu ','Ling ','Cha ',
        'Zaai ','Huan ','','','Jia ','Ban ','Hu ','Dou ','Caam ','Lou ','','Juan ','Ke ','Suo ','Ge ','Zhe ',
        'Ding ','Duan ','Zhu ','Yan ','Pang ','Cha ','','','','','Yi ','Zin ','','You ','Gun ','Yao ',
        'Yao ','Shi ','Gong ','Qi ','Gen ','Gwong ','','Hou ','Mi ','Fu ','Hu ','Guang ','Dan ','Dai ','Tou ','Yan ',
        '','Dung ','Qu ','','Chang ','Ming ','Tou ','Bao ','On ','Ceon ','Zung ','Xian ','','','','Mao ',
        'Lang ','Nan ','Pei ','Chen ','Hau ','Fei ','Cou ','Gei ','Qie ','Dai ','Sik ','Kun ','Die ','Lu ','Thung ','',
        ],
    'x3b':[
        '','Caap ','Yu ','Tai ','Chan ','Man ','Mian ','Huan ','Wan ','Nuan ','Huan ','Hou ','Jing ','Bo ','Xian ','Li ',
        'Jin ','','Mang ','Piao ','Hao ','Yang ','','Xian ','Su ','Wei ','Che ','Kap ','Jin ','Ceng ','He ','',
        'Shai ','Ling ','Fui ','Dui ','Zaap ','Pu ','Yue ','Bo ','','Hui ','Die ','Yan ','Ju ','Jiao ','Kuai ','Lie ',
        'Yu ','Ti ','Tim ','Wu ','Hong ','Xiao ','Hao ','','Tiu ','Zaang ','','Huang ','Fu ','','','Dun ',
        '','Reng ','Jiao ','Gong ','Xin ','','','Yuan ','Jue ','Hua ','Sik ','Bang ','Mou ','Cat ','Gong ','Wei ',
        '','Mei ','Si ','Bian ','Lu ','Keoi ','','','He ','She ','Lu ','Pai ','Rong ','Qiu ','Lie ','Gong ',
        'Xian ','Xi ','Hing ','','Niao ','','','','Xie ','Lei ','Fu ','Cuan ','Zhuo ','Fei ','Zuo ','Die ',
        'Ji ','He ','Ji ','','Gin ','','','','Tu ','Xian ','Yan ','Tang ','Ta ','Di ','Jue ','Ang ',
        'Han ','Yao ','Ju ','Rui ','Bang ','Zeoi ','Nie ','Tian ','Nai ','','','You ','Mian ','Zin ','Bui ','Nai ',
        'Xing ','Qi ','Zaan ','Gen ','Tong ','Er ','Jia ','Qin ','Mao ','E ','Li ','Chi ','Zong ','He ','Jie ','Ji ',
        '','Guan ','Hou ','Gai ','Cung ','Fen ','Se ','Waat ','Ji ','Sik ','Qiong ','He ','Zung ','Xian ','Jie ','Hua ',
        'Bi ','Sing ','Caai ','Zhen ','Sau ','Zin ','Shi ','Gai ','Song ','Zhi ','Ben ','','','','Lang ','Bi ',
        'Xian ','Bang ','Dai ','Cat ','Zi ','Pi ','Chan ','Bi ','Su ','Huo ','Hen ','Ying ','Chuan ','Jiang ','Nen ','Gu ',
        'Fang ','','','Ta ','Cui ','Sai ','De ','Ran ','Kuan ','Che ','Da ','Hu ','Cui ','Ro ','Juan ','Lu ',
        'Qian ','Pao ','Zhen ','Fan ','Li ','Cao ','Qi ','','','Ti ','Ling ','Qu ','Lian ','Lu ','Shu ','Gong ',
        'Zhe ','Biao ','Cum ','Qing ','','','Zong ','Buc ','Jin ','Biao ','Jian ','Gun ','','Ban ','Zou ','Xop ',
        ],
    'x3c':[
        'Li ','Luo ','Shen ','Mian ','Jian ','Di ','Bei ','Cim ','Lian ','Zeon ','Xun ','Pin ','Que ','Long ','Zui ','Gou ',
        'Jue ','San ','She ','','Xie ','Hei ','Lan ','Cu ','Yi ','Nuo ','Li ','Yue ','','Yi ','Ci ','Ji ',
        'Kang ','Xie ','Hang ','Zi ','Ke ','Hui ','Qu ','Hai6','Hei ','Hoi ','Wa ','Caam ','Xun ','Haap6','Shen ','Kou ',
        'Qie ','Sha ','Xu ','Ya ','Po ','Zu ','You ','Zi ','Lian ','Jin ','Xia ','Yi ','Qie ','Mi ','Jiao ','Hei ',
        'Chi ','Shi ','Fong ','Yin ','Mo ','Yi ','Hei ','Se ','Jin ','Ye ','Zaau ','Que ','Che ','Luan ','Kwaan ','Zheng ',
        '','','Ho ','','Se ','Gwai ','Cui ','Zaau ','An ','Xiu ','Can ','Chuan ','Zha ','','Ji ','Bo ',
        'Fu ','Sing ','Lang ','Tui ','Sek6','Ling ','E ','Wo ','Lian ','Du ','Men ','Lan ','Wei ','Duan ','Kuai ','Ai ',
        'Zai ','Hui ','Yi ','Mo ','Zi ','Ben ','Beng ','','Bi ','Li ','Lu ','Luo ','Hoi ','Dan ','Goi ','Que ',
        'Chen ','Hung ','Cheng ','Jiu ','Kou ','Ji ','Ling ','Ci ','Shao ','Kai ','Rui ','Chuo ','Neng ','Zi ','Lou ','Bao ',
        '','','Bao ','Rong ','Saan ','Lei ','Siu ','Fu ','Qu ','Saau ','Saa ','Zhi ','Tan ','Rong ','Zu ','Ying ',
        'Mao ','Nai ','Bian ','Saau ','Seoi ','Tang ','Han ','Zao ','Rong ','','Dang ','Pu ','Ziu ','Tan ','','Ran ',
        'Ning ','Lie ','Die ','Die ','Zhong ','Siu ','Lu ','Dan ','Kap ','Gui ','Ji ','Ni ','Yi ','Nian ','Yu ','Wang ',
        'Guo ','Ze ','Yan ','Cui ','Xian ','Jiao ','Shu ','Fu ','Pei ','Ngoet ','Zaau ','Zaau ','Nhop ','Bu ','Bian ','Chi ',
        'Sa ','Yi ','Bian ','','Dui ','Lan ','Zi ','Chai ','Cung ','Xuan ','Yu ','Yu ','Zaau ','Hong ','Cung ','',
        'Ta ','Gwo ','','','Suk6','Ju ','Xie ','Xi ','Jian ','Tan ','Pan ','Ta ','Xuan ','Xian ','Niao ','Tan ',
        'Gaau ','','','','Mi ','Ji ','Gou ','Wen ','Faa ','Wang ','You ','Ze ','Bi ','Mi ','Goeng ','Xie ',
        ],
    'x3d':[
        'Fan ','Yi ','Dam ','Lei ','Ying ','Siu ','Jin ','She ','Yin ','Ji ','Zyun ','Su ','','','','Wang ',
        'Mian ','Su ','Yi ','Zai ','Se ','Ji ','Luo ','Zaau ','Mao ','Zha ','Sui ','Zhi ','Bian ','Li ','Caai ','',
        '','','','','','Qiao ','Guan ','','Zhen ','Zung ','Nie ','Jun ','Xie ','Yao ','Xie ','Zi ',
        'Neng ','Sam ','Si ','Long ','Chen ','Mi ','Que ','Dam ','Na ','','','','Su ','Xie ','Bo ','Ding ',
        'Cuan ','Fong ','Chuang ','Che ','Han ','Dan ','Hao ','','','','Shen ','Mi ','Chan ','Men ','Han ','Cui ',
        'Jue ','He ','Fei ','Shi ','Che ','Shen ','Nu ','Fu ','Man ','Cing ','','','','Yi ','Chou ','Mei ',
        'Faat ','Bao ','Loi ','Ke ','Dian ','Bi ','Sui ','Ge ','Bi ','Yi ','Xian ','Ni ','Ying ','Zhu ','Chun ','Feng ',
        'Xu ','Piao ','Wu ','Liao ','Cang ','Zou ','Ceoi ','Bian ','Yao ','Huan ','Pai ','Sou ','','Dui ','Jing ','Xi ',
        'Bak6','Guo ','','','Yan ','Xue ','Chu ','Heng ','Ying ','','','','Lian ','Xian ','Huan ','Zaan ',
        '','Lian ','Shan ','Cang ','Bei ','Jian ','Shu ','Fan ','Dian ','','Ba ','Yu ','Zyun ','','Nang ','Lei ',
        'Yi ','Dai ','','Chan ','Chao ','Gon ','Jin ','Nen ','Pei ','','','Liao ','Mei ','Jiu ','Siu ','Liu ',
        'Han ','','Yong ','Jin ','Chi ','Ren ','Nong ','','','Hong ','Tian ','Bung ','Oi ','Gwaa ','Biu ','Bo ',
        'Qiong ','','Shu ','Cui ','Hui ','Chao ','Dou ','Guai ','E ','Wei ','Fen ','Tan ','','Lun ','He ','Yong ',
        'Hui ','Nim6','Yu ','Zong ','Yan ','Qiu ','Zhao ','Jiong ','Tai ','Zin ','','Bou ','','Dut ','','Tui ',
        'Lin ','Jiong ','Zha ','Sing ','He ','Zing ','Xu ','','','Hei ','Cui ','Qing ','Mo ','Fung ','Zou ','Beng ',
        'Li ','','','Yan ','Ge ','Mo ','Bei ','Juan ','Die ','Shao ','','Wu ','Yan ','','Jue ','Hin ',
        ],
    'x3e':[
        'Tai ','Han ','','Dian ','Ji ','Jie ','','','Ziu ','Xie ','La ','Fan ','Huo ','Xi ','Nie ','Mi ',
        'Ran ','Cuan ','Yin ','Mi ','','Jue ','Keoi ','Tong ','Wan ','Ze ','Li ','Shao ','Kong ','Kan ','Ban ','Taai ',
        'Tiao ','Syu ','Bei ','Ye ','Pian ','Chan ','Hu ','Ken ','Gaau ','An ','Chun ','Qian ','Bei ','Baa ','Fen ','Fo ',
        'Tuo ','Tuo ','Zuo ','Ling ','','Gui ','Zin ','Shi ','Hou ','Lie ','Saa ','Si ','Fung ','Bei ','Ren ','Du ',
        'Bo ','Liang ','Ci ','Bi ','Ji ','Zong ','Fai ','He ','Li ','Yuan ','Yue ','Saau ','Chan ','Di ','Lei ','Jin ',
        'Chong ','Si ','Pu ','Yi ','Goeng ','Fun ','Huan ','Tao ','Ru ','Ying ','Ying ','Rao ','Yin ','Shi ','Yin ','Jue ',
        'Tun ','Xuan ','Gaa ','Zung ','Qie ','Zhu ','Ciu ','Zoeng ','You ','','Saan ','Xi ','Shi ','Yi ','Mo ','Huou ',
        '','Hu ','Xiao ','Wu ','Gang ','Jing ','Ting ','Shi ','Ni ','Gang ','Ta ','Waai ','Chu ','Chan ','Piao ','Diao ',
        'Nao ','Nao ','Gan ','Gou ','Yu ','Hou ','','Si ','Ci ','Hu ','Yang ','Zung ','Xian ','Ban ','Rong ','Lou ',
        'Zhao ','Can ','Liao ','Piao ','Voi ','Fan ','Han ','Dan ','Zhan ','','Ta ','Zhu ','Ban ','Jian ','Yu ','Zhuo ',
        'You ','Li ','Kut ','Hei ','Cim ','Chan ','Lian ','Heo ','Si ','Jiu ','Pu ','Qiu ','Gong ','Zi ','Yu ','',
        'Si ','Reng ','Niu ','Mei ','Baat ','Jiu ','','Xu ','Ping ','Bian ','Mao ','','','','','Yi ',
        'You ','Gwai ','Ping ','Kuk ','Bao ','Hui ','','','','Bu ','Mang ','La ','Tu ','Wu ','Li ','Ling ',
        '','Ji ','Jun ','Lit6','Duo ','Jue ','Dai ','Bei ','','','','','','La ','Bian ','Sui ',
        'Tu ','Die ','','','','','','Duo ','','','Sui ','Bi ','Tu ','Se ','Can ','Tu ',
        'Mian ','Zeon ','Lu ','','','Zhan ','Bi ','Ji ','Cen ','Hyun ','Li ','','','Sui ','Zung ','Shu ',
        ],
    'x3f':[
        '','','E ','','Gei ','','','Qiong ','Luo ','Yin ','Tun ','Gu ','Yu ','Lei ','Bei ','Nei ',
        'Pian ','Lian ','Qiu ','Lian ','Waan ','Dong ','Li ','Ding ','Wa ','Zhou ','Gong ','Xing ','Ang ','Fan ','Peng ','Bai ',
        'Tuo ','Syu ','E ','Bai ','Qi ','Chu ','Gong ','Tong ','Han ','Cheng ','Jia ','Huan ','Xing ','Dian ','Mai ','Dong ',
        'E ','Ruan ','Lie ','Sheng ','Ou ','Di ','Yu ','Chuan ','Rong ','Hong ','Tang ','Cong ','Piao ','Shuang ','Lu ','Tong ',
        'Zheng ','Li ','Sa ','Ban ','Si ','Dang ','Dong ','Guai ','Yi ','Han ','Xie ','Luo ','Liu ','Ham ','Dan ','',
        'Cim ','Tan ','Saang ','','','You ','Nan ','','Gang ','Jun ','Chi ','Kou ','Wan ','Li ','Liu ','Lie ',
        'Xia ','Baai ','An ','Yu ','Ju ','Rou ','Xun ','Zi ','Cuo ','Can ','Zeng ','Yong ','Fu ','Ruan ','Sing ','Xi ',
        'Shu ','Jiao ','Jiao ','Han ','Zhang ','Zong ','','Shui ','Chen ','Fan ','Ji ','Zi ','','Gu ','Wu ','Cui ',
        'Qie ','Shu ','Hoi ','Tuo ','Ru ','Si ','Ran ','Mu ','Fu ','Ling ','Ji ','Xiu ','Xuan ','Nai ','At ','Jie ',
        'Li ','Da ','Ji ','Zyun ','Lu ','Shen ','Li ','Lang ','Geng ','Yin ','Se ','Qin ','Qie ','Che ','You ','Bu ',
        'Huang ','Que ','Lai ','Zaam ','Hong ','Xu ','Bang ','Ke ','Qi ','Gwaai ','Sheng ','Pin ','Gaai ','Zhou ','Huang ','Tui ',
        'Hu ','Bei ','','','Zaa ','Ji ','Gu ','Sai ','Gao ','Chai ','Ma ','Zhu ','Tui ','Tui ','Hem ','Lang ',
        'Baan ','','Zing ','Dai ','Ai ','Xian ','Gwo ','Xi ','Zung ','Tui ','Can ','Sao ','Cim ','Jie ','Fen ','Qun ',
        '','Yao ','Dao ','Jia ','Lei ','Yan ','Lu ','Tui ','Ying ','Pi ','Luo ','Li ','Bie ','Hoeng ','Mao ','Bai ',
        'huang ','Dau ','Yao ','He ','Chun ','Hu ','Ning ','Chou ','Li ','Tang ','Huan ','Bi ','Baa ','Che ','Yang ','Da ',
        'Ao ','Xue ','Zi ','','Daap ','Ran ','Bong ','Zao ','Wan ','Ta ','Bao ','Gon ','Yan ','Gaai ','Zhu ','Ya ',
        ],
    'x40':[
        'Fan ','You ','On ','Tui ','Meng ','She ','Jin ','Gu ','Qi ','Qiao ','Jiao ','Yan ','','Kan ','Mian ','Xian ',
        'San ','Na ','Cin ','Huan ','Niu ','Cheng ','Tin ','Jue ','Xi ','Qi ','Ang ','Mei ','Gu ','','Tou ','Fan ',
        'Qu ','Xem ','Shun ','Bi ','Mao ','Shuo ','Gu ','Hong ','Huan ','Luo ','Hang ','Jia ','Quan ','Goi ','Mang ','Bu ',
        'Gu ','Fung ','Mu ','Ai ','Ying ','Shun ','Lang ','Jie ','Di ','Jie ','Cau ','Pin ','Ren ','Yan ','Du ','Di ',
        '','Lang ','Xian ','Biu ','Xing ','Bei ','An ','Mi ','Qi ','Qi ','Wo ','She ','Yu ','Jia ','Cheng ','Yao ',
        'Ying ','Yang ','Ji ','Jie ','Han ','Min ','Lou ','Kai ','Yao ','Yan ','Sun ','Coi ','Huang ','Ying ','Sheng ','Cha ',
        'Lian ','','Xuan ','Chuan ','Che ','Ni ','Qu ','Miao ','Huo ','Yu ','Nan ','Hu ','Ceng ','Biu ','Qian ','She ',
        'Jiang ','Ao ','Mai ','Mang ','Zhan ','Bian ','Jiao ','Jue ','Nong ','Bi ','Shi ','Li ','Mo ','Lie ','Mie ','Mo ',
        'Xi ','Chan ','Qu ','Jiao ','Huo ','Zin ','Xu ','Nang ','Tong ','Hou ','Yu ','','Cung ','Bo ','Zuan ','Diu ',
        'Chuo ','Ci ','Jie ','Kwai ','Xing ','Hui ','Shi ','Gwaat6','Caam ','','Yao ','Yu ','Bang ','Jie ','Zhe ','Gaa ',
        'She ','Di ','Dong ','Ci ','Fu ','Min ','Zhen ','Zhen ','','Yan ','Diao ','Hong ','Gong ','Diu6','Lue ','Guai ',
        'La ','Cui ','Fa ','Cuo ','Yan ','Gung ','Jie ','Gwaai ','Guo ','Suo ','Wan ','Zheng ','Nie ','Diao ','Lai ','Ta ',
        'Cui ','Aa ','Gun ','','','Dai ','','Mian ','Gaai ','Min ','Ju ','Yu ','Zan ','Zhao ','Ze ','Saang ',
        '','Pan ','He ','Gou ','Hong ','Lao ','Wu ','Chuo ','Hang ','Lu ','Cu ','Lian ','Zi ','Qiao ','Shu ','',
        'xuan ','Cen ','Zaam ','Hui ','Su ','Chuang ','Deon ','Long ','','Nao ','Tan ','Dan ','Wei ','Gan ','Da ','Li ',
        'Caat ','Xian ','Pan ','La ','Zyu ','Niao ','Huai ','Ying ','Xian ','Lan ','Mo ','Ba ','','Fu ','Bi ','Fu ',
        ],
    'x41':[
        'Huo ','Yi ','Liu ','Zoeng ','Zaan ','Juan ','Huo ','Cheng ','Dou ','E ','','Yan ','Zhui ','Du ','Qi ','Yu ',
        'Quan ','Huo ','Nie ','Heng ','Ju ','She ','','','Peng ','Ming ','Cao ','Lou ','Li ','Chun ','','Cui ',
        'Shan ','Daam ','Qi ','','Lai ','Ling ','Liao ','Reng ','Yu ','Nao ','Chuo ','Qi ','Yi ','Nian ','Fu ','Jian ',
        'Ya ','Fong ','Chui ','Cin ','','','Bi ','Dan ','Po ','Nian ','Zhi ','Chao ','Tian ','Tian ','Rou ','Yi ',
        'Lie ','An ','He ','Qiong ','Li ','Gwai ','Zi ','Su ','Yuan ','Ya ','Du ','Wan ','Gyun ','Dong ','You ','Hui ',
        'Jian ','Rui ','Mang ','Ju ','Zi ','Geoi ','An ','Sui ','Lai ','Hun ','Qiang ','Coeng ','Duo ','Hung ','Na ','Can ',
        'Ti ','Xu ','Jiu ','Huang ','Qi ','Jie ','Mao ','Yan ','Heoi ','Zhi ','Tui ','','Ai ','Pang ','Cang ','Tang ',
        'En ','Hun ','Qi ','Chu ','Suo ','Zhuo ','Nou ','Tu ','Zu ','Lou ','Miao ','Li ','Man ','Gu ','Cen ','Hua ',
        'Mei ','Gou ','Lian ','Dao ','Shan ','Ci ','','','Zhi ','Ba ','Cui ','Qiu ','','Long ','Cim ','Fei ',
        'Guo ','Cheng ','Jiu ','E ','Cung ','Jue ','Hong ','Jiao ','Cuan ','Yao ','Tong ','Cha ','You ','Shu ','Yao ','Ge ',
        'Huan ','Lang ','Jue ','Chen ','Cyun ','Cyun ','Shen ','Fo ','Ming ','Ming ','Hung ','Chuang ','Yun ','Han6','Jin ','Chuo ',
        'Zyu ','Tan ','Hong ','Qiong ','','Cheng ','Zaau ','Yu ','Cheng ','Tong ','Pun ','Qiao ','Fo ','Ju ','Lan ','Yi ',
        'Rong ','Si ','Hin ','Si ','Ngat ','Fa ','','Meng ','Gui ','','','Hai ','Qiao ','Chuo ','Que ','Dui ',
        'Li ','Ba ','Jie ','Seoi ','Luo ','Deoi ','Yun ','Zung ','Hu ','Yin ','Pok ','Zhi ','Lian ','Zim ','Gan ','Jian ',
        'Zhou ','Zhu ','Ku ','Na ','Dui ','Ze ','Yang ','Zhu ','Gong ','Yi ','Ci ','Gei ','Chuang ','Lao ','Ren ','Rong ',
        'Zing ','Na ','Ce ','Zin ','','Yi ','Jue ','Bi ','Cheng ','Jun ','Chou ','Hui ','Chi ','Zhi ','Yan ','',
        ],
    'x42':[
        'Saan ','Lun ','Bing ','Zhao ','Han ','Yu ','Dai ','Zhao ','Fei ','Sha ','Ling ','Ta ','Zeoi ','Mang ','Ye ','Bao ',
        'Kui ','Gua ','Nan ','Ge ','Gaa ','Chi ','Fo ','Suo ','Ci ','Zhou ','Tai ','Kuai ','Qin ','Seoi ','Du ','Ce ',
        'Huan ','Gung ','Sai ','Zheng ','Qian ','Gan ','Zung ','Wei ','','','Xi ','Nap ','Pu ','Huai ','Ju ','Zaan ',
        'Sau ','Tou ','Pan ','Ta ','Qian ','Zung ','Rong ','Luo ','Hu ','Sou ','Zung ','Pu ','Mie ','Gan ','Shuo ','Mai ',
        'Shu ','Ling ','Lei ','Jiang ','Leng ','Zhi ','Diao ','','San ','Hu ','Fan ','Mei ','Sui ','Jian ','Tang ','Xie ',
        'Fu ','Mo ','Fan ','Lei ','Can ','Ceng ','Ling ','Zaap ','Cong ','Yun ','Meng ','Yu ','Zhi ','Qi ','Dan ','Huo ',
        'Wei ','Tan ','Se ','Xie ','Sou ','Song ','Cin ','Liu ','Yi ','Aau ','Lei ','Li ','Fei ','Lie ','Lin ','Xian ',
        'Yao ','Aau ','Bie ','Xian ','Rang ','Zhuan ','Soeng ','Dan ','Bian ','Ling ','Hong ','Qi ','Liao ','Ban ','Mi ','Hu ',
        'Hu ','Caap ','Ce ','Pei ','Qiong ','Ming ','Jiu ','Bu ','Mei ','San ','Mei ','Zong ','','Li ','Quan ','Sam ',
        'En ','Xiang ','Zing ','Shi ','Zing ','Gin ','Lan ','Huang ','Jiu ','Yan ','Deoi ','Sa ','Tuan ','Xie ','Zhe ','Men ',
        'Xi ','Man ','Zoeng ','Huang ','Tan ','Xiao ','Ya ','Bi ','Luo ','Fan ','Li ','Cui ','Cha ','Chou ','Di ','Kuang ',
        'Chu ','Cim ','Chan ','Mi ','Qian ','Qiu ','Zhen ','Chai ','Heoi ','Cim ','Gu ','Yan ','Chi ','Guai ','Mu ','Bo ',
        'Kua ','Geng ','Yao ','Mao ','Wang ','','','','Ru ','Jue ','Zing ','Min ','Jiang ','O ','Zhan ','Zuo ',
        'Yue ','Bing ','Nou6','Zhou ','Bi ','Ren ','Luot ','Gin ','Chuo ','Er ','Yi ','Mi ','Qing ','Zing ','Wang ','Ji ',
        'Bu ','Syu ','Bie ','Fan ','Yao ','Luoi ','Moi ','Qu ','Fu ','Er ','O ','Zang ','Zim ','Huo ','Jin ','Qi ',
        'Ju ','Lai ','Che ','Bei ','Niu ','Yi ','Xu ','Liu ','Xun ','Fu ','Cau ','Nin ','Ting ','Beng ','Zha ','Wui ',
        ],
    'x43':[
        'Fo ','Zaau ','Ou ','Shuo ','Geng ','Tang ','Gui ','Hui ','Ta ','Gong ','Yao ','Daap ','Qi ','Han ','Lue ','Mi ',
        'Mi ','Gin ','Lu ','Fan ','Ou ','Mi ','Jie ','Fu ','Mi ','Huang ','Su ','Yao ','Nie ','Jin ','Lian ','Bi ',
        'Qing ','Ti ','Ling ','Zuan ','Zhi ','Yin ','Dao ','Chou ','Cai ','Mi ','Yan ','Lan ','Chong ','Ziu ','Soeng ','Guan ',
        'She ','Luo ','Fan ','Si ','Luo ','Zhu ','Zi ','Chou ','Juan ','Jiong ','Er ','Yi ','Rui ','Cai ','Ren ','Fu ',
        'Lan ','Sui ','Yu ','Yao ','Dian ','Ling ','Zhu ','Ta ','Ping ','Qian ','Jue ','Chui ','Bu ','Gu ','Cun ','',
        'Han ','Han ','Mou ','Hu ','Hong ','Di ','Fu ','Xuan ','Mi ','Mei ','Lang ','Gu ','Zhao ','Ta ','Yu ','Zong ',
        'Li ','Liao ','Wu ','Lei ','Ji ','Lei ','Li ','Zong ','Bo ','Ang ','Kui ','Tuo ','Ping ','Cau ','Zhao ','Gui ',
        'Zaan ','Xu ','Nai ','Chuo ','Duo ','Kaap ','Dong ','Gui ','Bo ','Zin ','Huan ','Xuan ','Can ','Li ','Tui ','Huang ',
        'Xue ','Hu ','Bao ','Ran ','Tiao ','Fu ','Liao ','Zaau ','Yi ','Shu ','Po ','He ','Cu ','Fu ','Na ','An ',
        'Chao ','Lu ','Zhan ','Ta ','Fu ','Gwaang ','Zang ','Qiao ','Su ','Baan ','Guan ','','Fan ','Chu ','','Er ',
        'Er ','Nuan ','Qi ','Si ','Chu ','','Yan ','Bang ','An ','Zi ','Ne ','Chuang ','Ba ','Ciu ','Ti ','Han ',
        'Zuo ','Ba ','Zhe ','Wa ','Sheng ','Bi ','Er ','Zhu ','Wu ','Wen ','Zhi ','Zhou ','Lu ','Wen ','Gun ','Qiu ',
        'La ','Zai ','Sou ','Mian ','Zhi ','Qi ','Cao ','Piao ','Lian ','Saap ','Long ','Su ','Qi ','Yuan ','Feng ','Heoi ',
        'Jue ','Di ','Pian ','Guan ','Niu ','Ren ','Zhen ','Gai ','Pi ','Tan ','Chao ','Chun ','Ho ','Chun ','Mo ','Bie ',
        'Qi ','Shi ','Bi ','Jue ','Si ','Taam ','Hua ','Da ','Hui ','Kaap ','Er ','Caau ','Mou ','Zyu ','Xi ','Zhi ',
        'Ren ','Ju ','Die ','Zhe ','Teo ','Meng ','Bi ','Han ','Yu ','Xian ','Pong ','Neng ','Can ','Bu ','Bong ','Qi ',
        ],
    'x44':[
        'Ji ','Niao ','Lu ','Jiong ','Han ','Yi ','Cai ','Chun ','Zhi ','Zi ','Da ','Cung ','Tian ','Zhou ','Daai ','Chun ',
        'Cau ','Zhe ','Zaa ','Rou ','Bin ','Ji ','Yi ','Du ','Jue ','Ge ','Ji ','Dap ','Can ','Suo ','Ruo ','Xiang ',
        'Huang ','Qi ','Zhu ','Cuo ','Chi ','Weng ','Haap6','Kao ','Gu ','Kai ','Fan ','Sung ','Cao ','Zhi ','Chan ','Lei ',
        'Gaau ','Zak6','Zhe ','Yu ','Gui ','Huang ','Jin ','Daan ','Guo ','Sao ','Tan ','','Xi ','Man ','Duo ','Ao ',
        'Pi ','Wu ','Ai ','Meng ','Pi ','Meng ','Yang ','Zhi ','Bo ','Ying ','Wei ','Nao ','Lan ','Yan ','Chan ','Quan ',
        'Zhen ','Pu ','','Tai ','Fei ','Shu ','','Dang ','Cha ','Ran ','Tian ','Chi ','Ta ','Jia ','Shun ','Huang ',
        'Liao ','Caa ','Dou ','','Jin ','E ','Keoi ','Fu ','Duo ','','E ','','Yao ','Di ','','Di ',
        'Bu ','Man ','Che ','Lun ','Qi ','Mu ','Can ','','Zung ','Sau ','Fan ','You ','Saau ','Da ','','Su ',
        'Fu ','Ji ','Jiang ','Cao ','Bo ','Teng ','Che ','Fu ','Bu ','Wu ','Haai ','Yang ','Ming ','Pang ','Mang ','Zang ',
        'Meng ','Cao ','Tiao ','Kai ','Bai ','Xiao ','Xin ','Qi ','Seoi ','','Shao ','Heng ','Ngau ','Xiao ','Chen ','Daan ',
        'Fan ','Yin ','Ang ','Ran ','Ri ','Fa ','Fan ','Qu ','Shi ','He ','Bian ','Dai ','Mo ','Deng ','','',
        'Hong ','Zing ','Cha ','Duo ','You ','Hao ','Tin ','Kut ','Xian ','Lei ','Jin ','Qi ','','Mei ','Zi ','',
        '','','Yan ','Yi ','Yin ','Qi ','Zhe ','Xi ','Yi ','Ye ','E ','','Zhi ','Han ','Chuo ','',
        'Chun ','Bing ','Kuai ','Chou ','','Tuo ','Qiong ','Cung ','Jiu ','Gwai ','Cu ','Fu ','','Meng ','Li ','Lie ',
        'Ta ','Zi ','Gu ','Liang ','Fat ','La ','Dian ','Ci ','Aang ','','','Ji ','','Cha ','Mao ','Du ',
        'Zaan ','Chai ','Rui ','Hen ','Ruan ','','Lai ','Xing ','Gan ','Yi ','Mei ','','He ','Ji ','So ','Han ',
        ],
    'x45':[
        'Seoi ','Li ','Zi ','Zu ','Yao ','Geoi ','Li ','Qi ','Gan ','Li ','','','','','Su ','Chou ',
        '','Xie ','Bei ','Xu ','Jing ','Pu ','Ling ','Xiang ','Zuo ','Diao ','Chun ','Qing ','Nan ','','Lu ','Chi ',
        'Shao ','Yu ','Hua ','Li ','','Siu ','','Li ','','','Dui ','','Yi ','Ning ','Si ','Hu ',
        'Fu ','Zaap ','Cheng ','Nan ','Ce ','Gaan ','Ti ','Qin ','Biao ','Sui ','Wei ','Deon ','Se ','Ai ','E ','Jie ',
        'Kuan ','Fei ','','Yin ','Zing ','Sao ','Dou ','Hui ','Xie ','Ze ','Tan ','Chang ','Zhi ','Yi ','Fu ','E ',
        '','Jun ','Gaa ','Cha ','Xian ','Man ','Syun ','Bi ','Ling ','Jie ','Kui ','Jia ','','Sang ','Lang ','Guk ',
        'Fei ','Lu ','Zha ','He ','','Ni ','Ying ','Xiao ','Teng ','Lao ','Ze ','Kui ','Goeng ','Qian ','Ju ','Piao ',
        'Ban ','Dou ','Lin ','Mi ','Zhuo ','Xie ','Hu ','Mi ','Gaai ','Za ','Cong ','Ge ','Nan ','Zhu ','Yan ','Han ',
        'Ceoi ','Yi ','Luan ','Yue ','Ran ','Ling ','Niang ','Yu ','Nue ','Heoi ','Yi ','Nue ','Qin ','Qian ','Xia ','Chu ',
        'Jin ','Mi ','','Na ','Han ','Zu ','Xia ','Yan ','Tu ','','Wu ','Suo ','Yin ','Chong ','Zhou ','Mang ',
        'Yuan ','Nu ','Miao ','Sao ','Wan ','Li ','','Na ','Shi ','Bi ','Ci ','Bang ','','Juan ','Xiang ','Gui ',
        'Pai ','Hong ','Xun ','Zha ','Yao ','Kwan ','','He ','E ','Yang ','Tiao ','You ','Jue ','Li ','','Li ',
        '','Ji ','Hu ','Zhan ','Fu ','Chang ','Guan ','Ju ','Meng ','Coeng ','Cheng ','Mou ','Sing ','Li ','Zaan ','',
        'Si ','Yi ','Bing ','Cung ','Hou ','Wan ','Chi ','','Ge ','Han ','Bo ','Saau ','Liu ','Can ','Can ','Yi ',
        'Xuan ','Yan ','Suo ','Gao ','Yong ','Zung ','Fung ','Hong ','Yu ','Cik ','Zhe ','Ma ','Fung ','','Shuang ','Jin ',
        'Guan ','Pu ','Lin ','','Ting ','Goeng ','La ','Yi ','Zung ','Ci ','Yan ','Jie ','Faan ','Wei ','Xian ','Ning ',
        ],
    'x46':[
        'Fu ','Ge ','','Mo ','Fu ','Nai ','Xian ','Wen ','Li ','Can ','Mie ','','Ni ','Chai ','Wan ','Xu ',
        'Nu ','Mai ','Co ','Kan ','Ho ','Hang ','','Faai ','Yu ','Wei ','Zhu ','Gei ','Gan ','Yi ','','',
        'Fu ','Bi ','Zhu ','Zi ','Shu ','Xia ','Ni ','','Jiao ','Xuan ','Cung ','Nou ','Rong ','Die ','Sa ','Sau ',
        '','Yu ','','Kaam ','Zung ','Lu ','Han ','','Yi ','Zui ','Zhan ','Su ','Wan ','Ni ','Guan ','Jue ',
        'Beng ','Can ','Zung ','Duo ','Qi ','Yao ','Gui ','Nuan ','Hou ','Xun ','Xie ','','Hui ','','Xie ','Bo ',
        'Ke ','Ceoi ','Xu ','Bai ','Aau ','Chu ','Bang ','Ti ','Chu ','Chi ','Niao ','Guan ','Feng ','Xie ','Dang ','Duo ',
        'Jue ','Hui ','Zeng ','Sa ','Duo ','Ling ','Meng ','Fan ','Guo ','Meng ','Long ','','Ying ','Hin ','Guan ','Cu ',
        'Li ','Du ','Ceng ','E ','Sin ','Saai ','','De ','De ','Jiang ','Lian ','','Shao ','Xi ','Si ','Wei ',
        '','','He ','You ','Lu ','Lai ','Ou ','Sheng ','Juan ','Qi ','','Yun ','','Qi ','Zong ','Leng ',
        'Ji ','Mai ','Chuang ','Nian ','Baan ','Li ','Ling ','Gong ','Chen ','','Xian ','Hu ','Bei ','Zu ','Dai ','Dai ',
        'Hun ','Soi ','Che ','Ti ','','Nuo ','Zhi ','Liu ','Fei ','Jiao ','Gwaan ','Ao ','Lin ','','Reng ','Tao ',
        'Pi ','Xin ','Shan ','Xie ','Wa ','Tao ','Tin ','Xi ','Xie ','Pi ','Yao ','Yao ','Nu ','Hao ','Nin ','Yin ',
        'Fan ','Nan ','Chi ','Wang ','Yuan ','Xia ','Zhou ','Yuan ','Shi ','Mi ','','Ge ','Pao ','Fei ','Hu ','Ni ',
        'Ci ','Mi ','Bian ','Gam ','Na ','Yu ','E ','Zhi ','Nin ','Xu ','Lue ','Hui ','Xun ','Nao ','Han ','Jia ',
        'Dou ','Hua ','Tuk ','','Cu ','Xi ','Song ','Mi ','Xin ','Wu ','Qiong ','Zheng ','Chou ','Xing ','Jiu ','Ju ',
        'Hun ','Ti ','Man ','Jian ','Qi ','Shou ','Lei ','Wan ','Che ','Can ','Jie ','You ','Hui ','Zha ','Su ','Ge ',
        ],
    'x47':[
        'Nao ','Xi ','','Deoi ','Chi ','Wei ','Mo ','Gun ','Cau ','','Zao ','Hui ','Luan ','Liao ','Lao ','',
        '','Qia ','Ao ','Nie ','Sui ','Mai ','Tan ','Xin ','Jing ','An ','Ta ','Chan ','Wei ','Tuan ','Ji ','Chen ',
        'Che ','Xu ','Xian ','Xin ','','Daan ','','Nao ','','Yan ','Qiu ','Hong ','Song ','Jun ','Liao ','Ju ',
        '','Man ','Lie ','','Chu ','Chi ','Xiang ','Cam ','Mei ','Shu ','Ce ','Chi ','Gu ','Yu ','Zaam ','',
        'Liao ','Lao ','Shu ','Zhe ','Soeng ','','Fat ','Fui ','E ','','Sha ','Zong ','Jue ','Jun ','','Lou ',
        'Wei ','Cung ','Zhu ','La ','Fun ','Zhe ','Zhao ','Zaau ','Yi ','','Ni ','Bo ','Syun ','Yi ','Hao ','Ya ',
        'Huan ','Man ','Man ','Qu ','Lao ','Hao ','','Men ','Xian ','Zhen ','Shu ','Zuo ','Zhu ','Gou ','Xuan ','Yi ',
        'Ti ','xie ','Jin ','Can ','Zai ','Bu ','Liang ','Zhi ','Ji ','Wan ','Guan ','Ceoi ','Qing ','Ai ','Fu ','Gui ',
        'Gou ','Xian ','Ruan ','Zhi ','Biao ','Yi ','Suo ','Die ','Gui ','Sheng ','Xun ','Chen ','She ','Qing ','','',
        'Chun ','Hong ','Dong ','Cheng ','Wei ','Die ','Shu ','Caai ','Ji ','Za ','Qi ','','Fu ','Ao ','Fu ','Po ',
        '','Tan ','Zha ','Che ','Qu ','You ','He ','Hou ','Gui ','E ','Jiang ','Yun ','Tou ','Qiu ','','Fu ',
        'Zuo ','Hu ','','Bo ','','Jue ','Di ','Jue ','Fu ','Huang ','','Yong ','Chui ','Suo ','Chi ','Hin ',
        '','','Man ','Ca ','Qi ','Jian ','Bi ','Gei ','Zhi ','Zhu ','Qu ','Zhan ','Ji ','Dian ','','Li ',
        'Li ','La ','Quan ','Ding ','Fu ','Cha ','Tang ','Shi ','Hang ','Qie ','Qi ','Bo ','Na ','Tou ','Chu ','Cu ',
        'Yue ','Di ','Chen ','Chu ','Bi ','Mang ','Ba ','Tian ','Min ','Lie ','Feng ','Caang ','Kheo ','Tiao ','Fu ','Kuo ',
        'Jian ','Ci ','','','Zhen ','Qiu ','Cuo ','Chi ','Kui ','Lie ','Bang ','Du ','Wu ','So ','Jue ','Lu ',
        ],
    'x48':[
        'Chang ','Zai ','Chu ','Liang ','Tian ','Kun ','Chang ','Jue ','Tu ','Hua ','Fei ','Bi ','','Qia ','Wo ','Ji ',
        'Qu ','Kui ','Hu ','Cu ','Sui ','','','Qiu ','Pi ','Bei ','Wa ','Jiao ','Rong ','','Cu ','Die ',
        'Chi ','Cuo ','Meng ','Xuan ','Duo ','Bie ','Zhe ','Chu ','Chan ','Gui ','Duan ','Zou ','Deng ','Lai ','Teng ','Yue ',
        'Quan ','Shu ','Ling ','','Qin ','Fu ','She ','Tiao ','','Ai ','','Qiong ','Diao ','Hai ','Shan ','Wai ',
        'Zhan ','Long ','Jiu ','Li ','','Min ','Rong ','Yue ','Jue ','Kang ','Fan ','Qi ','Hong ','Fu ','Lu ','Hong ',
        'Tuo ','Min ','Tian ','Juan ','Qi ','Zheng ','Jing ','Gong ','Tian ','Lang ','Mao ','Yin ','Lu ','Yun ','Ju ','Pi ',
        '','Xie ','Bian ','','Zeoi ','Rong ','Sang ','Wu ','Cha ','Gu ','Chan ','Peng ','Man ','Saau ','Zung ','Shuang ',
        'Keng ','Zhuan ','Chan ','Si ','Chuang ','Sui ','Bei ','Kai ','','Zhi ','Wei ','Min ','Ling ','','Nei ','Ling ',
        'Qi ','Yue ','Lip ','Yi ','Xi ','Chen ','','Rong ','Chen ','Nong ','You ','Ji ','Bo ','Fang ','Gei ','',
        'Cu ','Di ','Gaau ','Yu ','Ge ','Xu ','Lu ','He ','','Bai ','Gong ','Jiong ','Gwai ','Ya ','Nu ','You ',
        'Song ','Xie ','Cang ','Yao ','Shu ','Yan ','Suot ','Liao ','Sung ','Yu ','Bo ','Sui ','Cin ','Yan ','Lei ','Lin ',
        'Tai ','Du ','Yue ','Ji ','Cin ','Yun ','Bong ','','','Ju ','Ceot ','Chen ','Cung ','Xiang ','Xian ','On ',
        'Gui ','Yu ','Lei ','','Tu ','Chen ','Xing ','Qiu ','Hang ','','Dang ','Cai ','Di ','Yan ','Ci ','Gung ',
        'Zing ','Chan ','','Li ','Suo ','Ma ','Ma ','','Tang ','Pei ','Lou ','Sat ','Cuo ','Tu ','E ','Can ',
        'Jie ','Ti ','Ji ','Dang ','Jiao ','Bi ','Lei ','Yi ','Chun ','Chun ','Po ','Li ','Zai ','Tai ','Po ','Tian ',
        'Ju ','Xu ','Fan ','','Xu ','Er ','Huo ','Chua ','Ran ','Fa ','Gyun ','','Liang ','Ti ','Mi ','',
        ],
    'x49':[
        '','Cen ','Mei ','Yin ','Mian ','Tu ','Kui ','Sau ','Hei ','Mi ','Rong ','Guo ','Coeng ','Mi ','Ju ','Pi ',
        'Jin ','Wang ','Ji ','Meng ','Jian ','Xue ','Bao ','Gan ','Chan ','Li ','Li ','Qiu ','Dun ','Ying ','Yun ','Chen ',
        'Ji ','Ran ','','Lue ','','Gui ','Yue ','Hui ','Pi ','Cha ','Duo ','Chan ','So ','Kuan ','She ','Xing ',
        'Weng ','Shi ','Chi ','Ye ','Han ','Fei ','Ye ','Yan ','Zuan ','Saau ','Yin ','Duo ','Xian ','Gwaan ','Tou ','Qie ',
        'Chan ','Han ','Meng ','Yue ','Cu ','Qian ','Jin ','Shan ','Mu ','Zyun ','Coeng ','Baang ','Zheng ','Zhi ','Chun ','Yu ',
        'Mou ','Wan ','Chou ','Kei ','Su ','Pie ','Tian ','Kuan ','Cu ','Sui ','Co ','Jie ','Jian ','Ao ','Jiao ','Ye ',
        'Saam ','Ye ','Long ','Zao ','Bao ','Lian ','','Huan ','Lu ','Wei ','Xian ','Tie ','Bo ','Zheng ','Zhu ','Ba ',
        'Meng ','Xie ','Aau ','Zaau ','Teon ','Xiao ','Li ','Zha ','Mi ','','Ye ','','','Put ','Xie ','',
        '','Bong ','Shan ','Coeng ','','Shan ','Jue ','Ji ','Fang ','','Niao ','Ao ','Chu ','Wu ','Guan ','Xie ',
        'Ting ','Xie ','Dang ','Zim ','Tan ','Ping ','Xia ','Xu ','Bi ','Si ','Huo ','Zheng ','Wu ','','Run ','Chuai ',
        'Shi ','Huan ','Kuo ','Fu ','Chuai ','Xian ','Qin ','Qie ','Lan ','','Ya ','Zing ','Que ','','Chun ','Zhi ',
        'Gau ','Kui ','Qian ','Hang ','Yi ','Ni ','Zheng ','Chuai ','','Shi ','Cap ','Ci ','Jue ','Xu ','Yun ','',
        '','Chu ','Dao ','Dian ','Ge ','Ti ','Hong ','Ni ','','Li ','','Xian ','Seoi ','Xi ','Xuan ','',
        'Gwik ','Taai ','Lai ','Zau ','Mu ','Cheng ','Jian ','Bi ','Qi ','Ling ','Hao ','Bang ','Tang ','Di ','Fu ','Xian ',
        'Shuan ','Zung ','Keoi ','Zaan ','Pu ','Hui ','Wei ','Yi ','Ye ','','Che ','Hao ','Baai ','','Xian ','Chan ',
        'Hun ','Gaau ','Han ','Ci ','Zi ','Qi ','Kui ','Rou ','Gu ','Zing ','Xiong ','Gap ','Hu ','Cui ','Syu ','Que ',
        ],
    'x4a':[
        'Di ','Che ','Cau ','','Yan ','Liao ','Bi ','Soeng ','Ban ','Zing ','','Nue ','Bao ','Ying ','Hong ','Ci ',
        'Qia ','Ti ','Yu ','Lei ','Bao ','Wu ','Ji ','Fu ','Xian ','Cen ','Fat ','Se ','Baang ','Cing ','Yu ','Waa ',
        'Ai ','Han ','Dan ','Ge ','Di ','Hu ','Pang ','Zaam ','Zaa ','Ling ','Mai ','Mai ','Lian ','Siu ','Xue ','Zhen ',
        'Po ','Fu ','Nou ','Xi ','Dui ','Dan ','Yun ','Xian ','Yin ','Suk ','Dui ','Beng ','Hu ','Fei ','Fei ','Qian ',
        'Bei ','Fei ','','Shi ','Tian ','Zhan ','Jian ','','Hui ','Fu ','Wan ','Mo ','Qiao ','Liao ','','Mie ',
        'Ge ','Hong ','Yu ','Qi ','Duo ','Ang ','Saa ','Ba ','Di ','Xuan ','Di ','Bi ','Zhou ','Pao ','Nian ','Yi ',
        'Ting ','Jia ','Da ','Duo ','Xi ','Dan ','Tiao ','Xie ','Chang ','Yuan ','Guan ','Liang ','Beng ','Gei ','Lu ','Ji ',
        'Xuan ','Shu ','Dou ','Shu ','Hu ','Yun ','Chan ','Bong ','Rong ','E ','Zung ','Ba ','Feng ','Zyu ','Zhe ','Fen ',
        'Guan ','Bu ','Ge ','Deon ','Huang ','Du ','Ti ','Bo ','Qian ','La ','Long ','Wei ','Zhan ','Lan ','Seoi ','Na ',
        'Bi ','Tuo ','Jiao ','','Bu ','Ju ','Po ','Xia ','Wei ','Fu ','He ','Fan ','Chan ','Hu ','Za ','',
        'Saai ','Zai ','Zai ','Zai ','Fan ','Die ','Hong ','Chi ','Bao ','Yin ','','Haang ','Bo ','Ruan ','Chou ','Ying ',
        'Zi ','Gai ','Kwaan ','Yun ','Zhen ','Ya ','Zeoi ','Hou ','Min ','Pei ','Ge ','Bian ','Zyut ','Hao ','Mi ','Sheng ',
        'Gen ','Bi ','Duo ','Chun ','Chua ','San ','Cheng ','Ran ','Zen ','Mao ','Bo ','Tui ','Pi ','Fu ','Zyut ','Hei ',
        'Lin ','Hei ','Men ','Wu ','Qi ','Zhi ','Chen ','Xia ','He ','Sang ','Gwaa ','Hou ','Au ','Fu ','Rao ','Hun ',
        'Pei ','Qian ','Si ','Xi ','Ming ','Kui ','Ge ','','Ao ','San ','Shuang ','Lou ','Zhen ','Hui ','Can ','Ci ',
        'Lin ','Na ','Han ','Du ','Jin ','Mian ','Fan ','E ','Nao ','Hong ','Hong ','Xue ','Xue ','Pau ','Bi ','Ciu ',
        ],
    'x4b':[
        'You ','Yi ','Xue ','Sa ','Yu ','Li ','Li ','Yuan ','Dui ','Hao ','Qie ','Leng ','Paau ','Fat ','Guo ','Bu ',
        'Wei ','Wei ','Saau ','An ','Xu ','Shang ','Heng ','Yang ','Gwik ','Yao ','Fan ','Bi ','Ci ','Heng ','Tao ','Liu ',
        'Fei ','Zhu ','Tou ','Qi ','Chao ','Yi ','Dou ','Yuan ','Cu ','Zai ','Bo ','Can ','Yang ','Tou ','Yi ','Nian ',
        'Shao ','Ben ','Ngaau ','Ban ','Mo ','Ai ','En ','She ','Caan ','Zhi ','Yang ','Jian ','Yuan ','Dui ','Ti ','Wei ',
        'Xun ','Zhi ','Yi ','Ren ','Shi ','Hu ','Ne ','Yi ','Jian ','Sui ','Ying ','Bao ','Hu ','Hu ','Xie ','',
        'Yang ','Lian ','Sik ','En ','Deoi ','Jian ','Zhu ','Ying ','Yan ','Jin ','Chuang ','Dan ','','Kuai ','Yi ','Ye ',
        'Jian ','En ','Ning ','Ci ','Qian ','Xue ','Bo ','Mi ','Shui ','Mi ','Liang ','Qi ','Qi ','Shou ','Bi ','Bo ',
        'Beng ','Bie ','Ni ','Wei ','Huan ','Fan ','Qi ','Liu ','Fu ','Ang ','Ang ','Fan ','Qi ','Qun ','Tuo ','Yi ',
        'Bo ','Pian ','Bo ','Keoi ','Xuan ','','Baai6','Yu ','Chi ','Lu ','Yi ','Li ','Zaau ','Niao ','Xi ','Wu ',
        'Gwing ','Lei ','Pei ','Zhao ','Zui ','Chuo ','Coeng ','An ','Er ','Yu ','Leng ','Fu ','Sha ','Huan ','Chu ','Sou ',
        'Bik ','Bi ','Die ','Song ','Di ','Li ','Giu ','Han ','Zai ','Gu ','Cheng ','Lou ','Mo ','Mi ','Mai ','Ao ',
        'Dan ','Zhu ','Huang ','Fan ','Deng ','Tong ','','Du ','Hu ','Wei ','Ji ','Chi ','Lin ','Biu ','Pang ','Jian ',
        'Nie ','Luo ','Ji ','Ngon ','Waa ','Nie ','Yi ','Gwaat6','Wan ','Ya ','Qia ','Bo ','Hau ','Ling ','Gan ','Huo ',
        'Hai ','Hong ','Heng ','Kui ','Cen ','Ting ','Lang ','Bi ','Huan ','Po ','Ou ','Jian ','Ti ','Sui ','Kwaa ','Dui ',
        'Ao ','Jian ','Mo ','Gui ','Kuai ','An ','Ma ','Qing ','Fen ','','Kao ','Hao ','Duo ','Cim ','Nai ','Seoi ',
        'Jie ','Fu ','Pa ','Sung ','Chang ','Nie ','Man ','Sung ','Ci ','Cim ','Kuo ','Gai ','Di ','Fu ','Tiao ','Zu ',
        ],
    'x4c':[
        'Wo ','Fei ','Cai ','Peng ','Shi ','Sou ','Rou ','Qi ','Cha ','Pan ','Bo ','Man ','Zong ','Ci ','Gui ','Ji ',
        'Lan ','Siu ','Meng ','Mian ','Pan ','Lu ','Cuan ','Gau ','Liu ','Yi ','Wen ','Li ','Li ','Zeng ','Zhu ','Hun ',
        'Shen ','Chi ','Xing ','Wang ','Dung ','Huo ','Pi ','Bou6','Mei ','Che ','Mei ','Chao ','Ju ','Nou ','','Ni ',
        'Ru ','Ling ','Ya ','','Qi ','Zi ','','Bang ','Gung ','Ze ','Jie ','Yu ','Xin ','Bei ','Ba ','Tuo ',
        'Ong ','Qiao ','You ','Di ','Jie ','Mo ','Sheng ','Shan ','Qi ','Shan ','Mi ','Dan ','Yi ','Geng ','Geng ','Tou ',
        'Fu ','Xue ','Yi ','Ting ','Tiao ','Mou ','Liu ','Caan ','Li ','Suk ','Lu ','Xu ','Cuo ','Ba ','Liu ','Ju ',
        'Zhan ','Ju ','Zang ','Zu ','Xian ','Zhi ','','','Zhi ','','','La ','Seoi ','Geng ','E ','Mu ',
        'Zhong ','Di ','Yan ','Zin ','Geng ','Zung ','Lang ','Yu ','Caau ','Na ','Hai ','Hua ','Zhan ','Coeng ','Lou ','Chan ',
        'Die ','Wei ','Xuan ','Zao ','Min ','Kwai ','Sou ','','','Si ','Tuo ','Cen ','Kuan ','Teng ','Nei ','Lao ',
        'Lu ','Yi ','Xie ','Yan ','Qing ','Pu ','Chou ','Xian ','Guan ','Jie ','Lai ','Meng ','Ye ','Ceoi ','Li ','Yin ',
        'Ceon ','Cau ','Teng ','Yu ','','Gau ','Cha ','Du ','Hong ','Si ','Xi ','Gaau ','Qi ','Ci ','Yuan ','Ji ',
        'Yun ','Fang ','Gung ','Hang ','Zhen ','Hu ','','','Jie ','Pei ','Gan ','Xuan ','Saang ','Dao ','Qiao ','Ci ',
        'Die ','Ba ','Tiao ','Wan ','Ci ','Zhi ','Bai ','Wu ','Bao ','Dan ','Ba ','Tong ','Gyun ','Gung ','Jiu ','Gui ',
        'Ci ','You ','Yuan ','Lao ','Jiu ','Fou ','Nei ','E ','E ','Xing ','He ','Yan ','Tu ','Bu ','Beng ','Kou ',
        'Chui ','Zeoi ','Qi ','Yuan ','Bit ','','Hyun ','Hou ','Huang ','Ziu ','Juan ','Kui ','E ','Ji ','Mo ','Chong ',
        'Bao ','Vo ','Zhen ','Xu ','Da ','Chi ','Gaai ','Cong ','Ma ','Kou ','Yan ','Can ','Aau ','He ','Dang ','Lan ',
        ],
    'x4d':[
        'Tong ','Yu ','Hang ','Nao ','Li ','Fen ','Pu ','Ling ','Ao ','Xuan ','Yi ','Xuan ','Meng ','Ang ','Lei ','Yan ',
        'Bao ','Die ','Ling ','Shi ','Jiao ','Lie ','Jing ','Ju ','Ti ','Pi ','Gang ','Jiao ','Huai ','Bu ','Di ','Huan ',
        'Yao ','Li ','Mi ','Fu ','Saang ','Gaa ','Ren ','Wai ','','Piao ','Lu ','Ling ','Yi ','Cai ','Shan ','Fat ',
        'Shu ','Tuo ','Mo ','He ','Tie ','Bing ','Peng ','Hun ','Fu ','Guo ','Bu ','Li ','Chan ','Bai ','Cuo ','Meng ',
        'Suo ','Qiang ','Zhi ','Kuang ','Bi ','Ao ','Meng ','Xian ','Guk ','Tou ','Teon ','Wei ','Cim ','Tan ','Caau ','Lao ',
        'Chan ','Ni ','Ni ','Li ','Dong ','Ju ','Jian ','Fu ','Sha ','Zha ','Tao ','Jian ','Nong ','Ya ','Jing ','Gan ',
        'Di ','Jian ','Mei ','Da ','Jian ','She ','Xie ','Zai ','Mang ','Li ','Gun ','Yu ','Ta ','Zhe ','Yang ','Tuan ',
        'Soeng ','He ','Diao ','Wei ','Yun ','Zha ','Qu ','Waa ','Caau ','Zi ','Ting ','Gu ','Soeng ','Ca ','Fu ','Tie ',
        'Ta ','Ta ','Zhuo ','Han ','Ping ','He ','Ceoi ','Zhou ','Bo ','Liu ','Nu ','Kaap ','Pao ','Di ','Sha ','Ti ',
        'Kuai ','Ti ','Qi ','Ji ','Chi ','Pa ','Jin ','Ke ','Li ','Ju ','Qu ','La ','Gu ','Qia ','Qi ','Xian ',
        'Jian ','Shi ','Xian ','Ai ','Hua ','Ju ','Ze ','Yao ','Tam ','Ji ','Cha ','Kan ','Gin ','','Yan ','Gwaai ',
        'Ziu ','Tong ','Nan ','Yue ','Ceoi ','Chi ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x4e':[
        'Nhat ','Ding ','Kao ','That ','Shang ','Xia ','','Wan ','Zhang ','Tam ','Shang ','Xia ','Ji ','Bat ','Yu ','Mian ',
        'Gai ','Suu ','Chou ','Zhuan ','Qie ','Pi ','Shi ','Shi ','Khau ','Bing ','Ye ','Cong ','Dong ','Si ','Cheng ','Diu ',
        'Qiu ','Liang ','Diu ','You ','Liang ','Yan ','Bing ','Sang ','Gun ','Jiu ','Ge ','A ','Qiang ','Trung ','Ji ','Jie ',
        'Phong ','Guan ','Chuan ','Chan ','Lin ','Zhuo ','Zhu ','Ha ','Hoan ','Dan ','Wei ','Chua ','Jing ','Li ','Ju ','Pie ',
        'Fu ','Yi ','Yi ','Nai ','Shime ','Cuu ','Jiu ','Zhe ','Yao ','Yi ','','Chi ','Wu ','Zha ','Hu ','Fa ',
        'Le ','Zhong ','Ping ','Pang ','Qiao ','Hu ','Quai ','Cheng ','Cheng ','Yi ','Yin ','','Mie ','Cuu ','Khat ','Ye ',
        'Xi ','Xiang ','Gai ','Jiu ','Hal ','','Shu ','Twul ','Shi ','Ji ','Nang ','Jia ','Kel ','Shi ','','Ol ',
        'Mai ','Luan ','Cal ','Vu ','Xue ','Yan ','Fu ','Sha ','Na ','Gan ','Sol ','El ','Cwul ','','Gan ','Chi ',
        'Gui ','Gan ','Luan ','Lin ','Yi ','Jue ','Le ','Ma ','Yu ','Zheng ','Shi ','Shi ','Er ','Suc ','Vu ','Yu ',
        'Yu ','Van ','Hu ','Qi ','Wu ','Jing ','Si ','Sui ','Gen ','Gen ','Ya ','Ta ','Ya ','Qi ','Ya ','Cac ',
        'Tou ','Vong ','Cang ','Ta ','Giao ','Hai ','Yi ','Chan ','Hanh ','Mu ','','Xiang ','Kinh ','Ting ','Liang ','Xiang ',
        'Jing ','Ye ','Qin ','Bo ','You ','Xie ','Dan ','Lian ','Duo ','Wei ','Nhan ','Ren ','Ji ','La ','Wang ','Yi ',
        'Shi ','Nhan ','Le ','Ding ','Trac ','Jin ','Boc ','Chou ','Ba ','Zhang ','Kim ','Gioi ','Bing ','Nhung ','Cong ','Fo ',
        'San ','Lun ','Sya ','Cang ','Tu ','Shi ','Tha ','Zhang ','Fu ','Xian ','Xian ','Tuo ','Hong ','Tong ','Ren ','Qian ',
        'Gan ','Yi ','Di ','Dai ','Ling ','Yi ','Chao ','Chang ','Sa ','','Yi ','Mu ','Men ','Ren ','Jia ','Chao ',
        'Yang ','Qian ','Zhong ','Pi ','Wan ','Wu ','Jian ','Jia ','Yao ','Feng ','Cang ','Ren ','Wang ','Fen ','Di ','Fang ',
        ],
    'x4f':[
        'Zhong ','Qi ','Pei ','Yu ','Diao ','Dun ','Wen ','Yi ','Xin ','Kang ','Y ','Ji ','Ai ','Wu ','Ji ','Phuc ',
        'Fa ','Huu ','Jin ','Bei ','Dan ','Fu ','Tang ','Zhong ','You ','Huo ','Hoi ','Yu ','Cui ','Chuan ','San ','Wei ',
        'Chuan ','Che ','Ya ','Xian ','Shang ','Chang ','Lun ','Cang ','Xun ','Nho ','Wei ','Zhu ','','Xuan ','Nu ','Bo ',
        'Gu ','Ni ','Ni ','Xie ','Ban ','To ','Ranh ','Zhou ','Shen ','Qu ','Si ','Beng ','Si ','Gia ','Pi ','Yi ',
        'Si ','Ai ','Zheng ','Dian ','Han ','Mai ','Dan ','Zhu ','Bu ','Qu ','Bi ','Shao ','Ci ','Wei ','Di ','Tru ',
        'Zuo ','You ','Yang ','Ti ','Zhan ','He ','Bi ','Tuo ','She ','Du ','Yi ','Fo ','Zuo ','Kou ','Ning ','Tong ',
        'Ni ','Xuan ','Qu ','Yong ','Wa ','Qian ','','Ka ','','Pei ','Hui ','He ','Lao ','Xiang ','Ge ','Yang ',
        'Bai ','Fa ','Ming ','Giai ','Er ','Bing ','Ji ','Hen ','Huo ','Gui ','Quan ','Tiao ','Jiao ','Ci ','Yi ','Shi ',
        'Xing ','Shen ','Tuo ','Kan ','Zhi ','Gai ','Lai ','Yi ','Chi ','Kua ','Guang ','Li ','Yin ','Shi ','Mi ','Zhu ',
        'Xu ','You ','An ','Lu ','Mou ','Er ','Lun ','Tong ','Cha ','Chi ','Xun ','Cung ','Zhou ','Y ','Ru ','Jian ',
        'Xia ','Jia ','Zai ','Lu ','Ko ','Jiao ','Zhen ','Ce ','Qiao ','Kuai ','Chai ','Ning ','Nong ','Jin ','Wu ','Hou ',
        'Jiong ','Cheng ','Zhen ','Zuo ','Chou ','Xam ','Lu ','Ju ','Shu ','Ting ','Shen ','Tuo ','But ','Nan ','Hao ','Bian ',
        'Tui ','Yu ','Xi ','Xuc ','E ','Qiu ','Xu ','Kuang ','Ku ','Wu ','Tuan ','Yi ','Fu ','Lang ','Zu ','Qiao ',
        'Li ','Yong ','Hun ','Jing ','Xian ','San ','Pai ','Tuc ','Fu ','Xi ','Li ','Fu ','Ping ','Bao ','Yu ','Si ',
        'Xia ','Xin ','Xiu ','Yu ','Ti ','Che ','Chou ','','Yan ','Lia ','Li ','Lai ','Si ','Jian ','Tu ','Fu ',
        'He ','Cau ','Xiao ','Pai ','Jian ','Biao ','Chu ','Fei ','Feng ','Ya ','Em ','Bei ','Yu ','Xin ','Bi ','Jian ',
        ],
    'x50':[
        'Tranh ','Chi ','Bing ','Zan ','Yao ','Cui ','Lia ','Wan ','Lai ','Cang ','Zong ','Ge ','Guan ','Boi ','Tian ','Shu ',
        'Shu ','Men ','Dao ','Tan ','Jue ','Chui ','Xing ','Peng ','Tang ','Hou ','Yi ','Qi ','Ti ','Gan ','Jing ','Jie ',
        'Sui ','Xuong ','Jie ','Fang ','Zhi ','Kong ','Juan ','Zong ','Ju ','Qian ','Ni ','Luan ','Xac ','Wei ','Luo ','Song ',
        'Leng ','Hun ','Dong ','Zi ','Ben ','Wu ','Ju ','Nai ','Cai ','Jian ','Zhai ','Ye ','Zhi ','Sha ','Qing ','',
        'Ying ','Cheng ','Jian ','Yan ','Nuan ','Zhong ','Chun ','Jia ','Jie ','Wei ','Yu ','Bing ','Ruo ','Ti ','Wei ','Pian ',
        'Yan ','Feng ','Tang ','Wo ','E ','Xie ','Che ','Sheng ','Kan ','Di ','Zuo ','Cha ','Ting ','Bei ','Ye ','Huang ',
        'Yao ','Zhan ','Chou ','Yan ','You ','Jian ','Xu ','Zha ','Thay ','Fu ','Bi ','Zhi ','Zong ','Mian ','Ji ','Yi ',
        'Xie ','Xun ','Si ','Duan ','Trac ','Trinh ','Ou ','Tou ','Tou ','Bei ','Za ','Lu ','Jie ','Wei ','Fen ','Chang ',
        'Gui ','Sou ','Zhi ','Su ','Xia ','Fu ','Yuan ','Rong ','Li ','Ru ','Yun ','Gou ','Ma ','Bang ','Dian ','Tang ',
        'Hao ','Jie ','Xi ','Shan ','Qian ','Jue ','Cang ','Chu ','Tan ','Bei ','Xiao ','Yong ','Yao ','Tan ','Suo ','Yang ',
        'Fa ','Bing ','Jia ','Dai ','Zai ','Tang ','Cot ','Bin ','Chu ','Nuo ','Can ','Lei ','Cui ','Yong ','Zao ','Zong ',
        'Peng ','Song ','Ao ','Chuan ','Yu ','Zhai ','Cou ','Thuong ','Qiang ','Jing ','Chi ','Sha ','Han ','Zhang ','Khuynh ','Yan ',
        'Di ','Xi ','Lu ','Bei ','Piao ','Jin ','Lian ','Lu ','Man ','Qian ','Xian ','Tan ','Ying ','Dong ','Zhuan ','Xiang ',
        'Shan ','Qiao ','Jiong ','Tui ','Zun ','Boc ','Xi ','Lao ','Chang ','Guang ','Liao ','Qi ','Deng ','Chan ','Wei ','Ji ',
        'Fan ','Hui ','Chuan ','Jian ','Dan ','Jiao ','Jiu ','Tang ','Fen ','Xian ','Jue ','E ','Jiao ','Jian ','Tong ','Lin ',
        'Bo ','Gu ','','Su ','Xian ','Jiang ','Min ','Ye ','Jin ','Jia ','Qiao ','Pi ','Feng ','Zhou ','Ai ','Sai ',
        ],
    'x51':[
        'Nghi ','Jun ','Nung ','Chan ','Yi ','Dang ','Jing ','Xuan ','Cui ','Jian ','Chu ','Dan ','Jiao ','Sha ','Zai ','',
        'Bin ','An ','Nho ','Tai ','Chou ','Chai ','Lan ','Ni ','Jin ','Qian ','Meng ','Wu ','Ning ','Qiong ','Ni ','Chang ',
        'Lie ','Lei ','Lu ','Kuang ','Bao ','Du ','Biao ','Zan ','Zhi ','Si ','You ','Hao ','Chen ','Chen ','Li ','Teng ',
        'Wei ','Long ','Chu ','Sam ','Rang ','Shu ','Hui ','Li ','Luo ','Zan ','Nuo ','Tang ','Yan ','Lei ','Nang ','Er ',
        'Ngot ','Yun ','Zan ','Yuan ','Huynh ','Sung ','Zhao ','Hung ','Xian ','Quang ','Dui ','Khac ','Dui ','Mian ','Tu ','Chang ',
        'Er ','Dui ','Er ','Xin ','Tu ','Si ','Yan ','Yan ','Shi ','Sip ','Dang ','Qian ','Dou ','Fen ','Mao ','Shen ',
        'Dou ','Payk ','Jing ','Li ','Huang ','Ru ','Wang ','Nei ','Toan ','Liang ','Yu ','Ba ','Gong ','Luc ','Xi ','',
        'Lan ','Cong ','Tian ','Guan ','Xing ','Binh ','Qi ','Cu ','Dian ','Zi ','Ppwun ','Yang ','Jian ','Shou ','Ji ','Yi ',
        'Ji ','Chan ','Jiong ','Bou ','Ran ','Noi ','En ','Mao ','Gang ','Ran ','Ce ','Jiong ','Ce ','Zai ','Gua ','Jiong ',
        'Mao ','Zhou ','Mao ','Gou ','Xu ','Mian ','Mi ','Rong ','Yin ','Xie ','Kan ','Jun ','Nong ','Yi ','Mi ','Shi ',
        'Guan ','Meng ','Zhong ','Ju ','Oan ','Minh ','Kou ','Lam ','Fu ','Xie ','Mi ','Bing ','Dong ','Tai ','Gang ','Feng ',
        'Bang ','Hu ','Chong ','Jue ','Hu ','Huong ','Ye ','Leng ','Pan ','Fu ','Min ','Dong ','Xian ','Ret ','Xia ','Jian ',
        'Jing ','Shu ','Mei ','Tu ','Qi ','Gu ','Chon ','Song ','Jing ','Liang ','Qing ','Diao ','Lang ','Dong ','Gan ','Jian ',
        'Yin ','Cou ','Yi ','Li ','Cang ','Ming ','Jun ','Cui ','Si ','Duo ','Jin ','Lin ','Lin ','Ngung ','Xi ','Du ',
        'Ji ','Pham ','Fan ','Fan ','Feng ','Ju ','Chu ','Tako ','Feng ','Kogarashi ','Nagu ','Fu ','Feng ','Ping ','Feng ','Kai ',
        'Huang ','Kai ','Gan ','Deng ','Ping ','Qu ','Hung ','Kuai ','Tu ','Ao ','Xuat ','Ji ','Dang ','Han ','Han ','Zao ',
        ],
    'x52':[
        'Dao ','Diao ','Dao ','Ren ','Ren ','Chuang ','Phan ','Qie ','Yi ','Ji ','San ','Qian ','Cun ','Chu ','Wen ','Ji ',
        'Dan ','Xing ','Hua ','Wan ','Jue ','Li ','Yue ','Lie ','Liu ','Ze ','Gang ','Chuang ','Fu ','So ','Qu ','Ju ',
        'San ','Min ','Ling ','Zhong ','Pan ','Bie ','Jie ','Jie ','Bao ','Li ','Shan ','Bie ','Chan ','Jing ','Gua ','Gen ',
        'Dao ','Chuang ','Kui ','Ku ','Duo ','Er ','Zhi ','Shua ','Quan ','Cha ','Ci ','Khac ','Jie ','Gui ','Ci ','Gui ',
        'Kai ','Duo ','Ji ','Ti ','Jing ','Lou ','Gen ','Tac ','Yuan ','Cuo ','Tuoc ','Ke ','La ','Qian ','Cha ','Chuang ',
        'Gua ','Jian ','Cuo ','Li ','Ti ','Fei ','Bo ','Chan ','Qi ','Chuang ','Zi ','Gang ','Wan ','Bo ','Ji ','Duo ',
        'Qing ','Yan ','Zhuo ','Jian ','Ji ','Bo ','Yan ','Cua ','Huo ','Sheng ','Jian ','Duo ','Duan ','Wu ','Gua ','Fu ',
        'Sheng ','Jian ','Cat ','Zha ','Kai ','Chuang ','Juan ','Chan ','Tuan ','Lu ','Li ','Fou ','Shan ','Piao ','Kou ','Jiao ',
        'Gua ','Qiao ','Khoet ','Hua ','Chep ','Zhuo ','Lian ','Ju ','Pi ','Liu ','Gui ','Jiao ','Gui ','Jian ','Jian ','Tang ',
        'Huo ','Ji ','Jian ','Yi ','Jian ','Zhi ','Chan ','Cuan ','Mo ','Li ','Zhu ','Li ','Ya ','Quan ','Ban ','Gong ',
        'Gia ','Wu ','Mai ','Lie ','Jin ','Keng ','Xie ','Zhi ','Dong ','Zhu ','Nu ','Jie ','Cu ','Shao ','Yi ','Zhu ',
        'Miao ','Li ','Jing ','Lao ','Lao ','Juan ','Kou ','Yang ','Wa ','Xiao ','Mou ','Kuang ','Jie ','Lie ','He ','Shi ',
        'Ke ','Jin ','Hao ','Bot ','Min ','Chi ','Lang ','Yong ','Yong ','Mian ','Ke ','Xun ','Juan ','Qing ','Lu ','Pou ',
        'Meng ','Sac ','Lac ','Kai ','Mian ','Dong ','Huc ','Xu ','Kan ','Vu ','Yi ','Huan ','Weng ','Thang ','Lao ','Mu ',
        'Lu ','Piao ','Shi ','Ji ','Qin ','Qiang ','Jiao ','Quan ','Yang ','Yi ','Jue ','Fan ','Juan ','Tong ','Ju ','Dan ',
        'Xie ','Mai ','Xun ','Xun ','Lu ','Li ','Che ','Rang ','Quan ','Bao ','Chuoc ','Yun ','Jiu ','Bao ','Gou ','Wu ',
        ],
    'x53':[
        'Yun ','Monme ','Niou ','Gai ','Gai ','Bao ','Cong ','','Hung ','Peng ','Ju ','Tao ','Ge ','Pu ','An ','Pao ',
        'Fu ','Gong ','Da ','Jiu ','Qiong ','Bi ','Hua ','Bei ','Nao ','Chi ','Fang ','Jiu ','Yi ','Za ','Jiang ','Kang ',
        'Jiang ','Kuang ','Hu ','Hop ','Qu ','Bian ','Gui ','Qie ','Zang ','Kuang ','Fei ','Hu ','Tou ','Gui ','Gui ','Hui ',
        'Dan ','Gui ','Lian ','Lian ','Suan ','Du ','Jiu ','Qu ','Xi ','That ','Qu ','Yi ','Hop ','Yan ','Bian ','Ni ',
        'Khu ','Shi ','Xin ','Qian ','Nian ','Sa ','Zu ','Thang ','Ngo ','Hui ','Ban ','Shi ','Tap ','Wan ','Hua ','Xie ',
        'Wan ','Bei ','Tot ','Zhuo ','Xie ','Dan ','Mai ','Nam ','Dan ','Ji ','Bo ','Shuai ','Boc ','Kuang ','Bian ','Bu ',
        'Zhan ','Qia ','Lu ','You ','Lu ','Xi ','Gua ','Wo ','Xie ','Jie ','Jie ','Wei ','Ngang ','Qiong ','Zhi ','Mao ',
        'Yin ','Nguy ','Shao ','Ji ','Que ','Luan ','Shi ','Juan ','Xie ','Xu ','Jin ','Khuoc ','Wu ','Ji ','E ','Khanh ',
        'Xi ','','Chang ','Zhan ','E ','Ting ','Li ','Zhe ','Han ','Li ','Ya ','Ya ','Yan ','She ','Zhi ','Zha ',
        'Pang ','','He ','Day ','Zhi ','Ce ','Pang ','Ti ','Li ','She ','Hou ','Ting ','Zui ','Cuo ','Fei ','Yuan ',
        'Ce ','Yuan ','Xiang ','Yan ','Li ','Jue ','Sha ','Dian ','Chu ','Jiu ','Qin ','Ao ','Gui ','Yan ','Si ','Li ',
        'Chang ','Lan ','Li ','Yan ','Yan ','Yuan ','Si ','Gong ','Lin ','Qiu ','Qu ','Qu ','Uk ','Lei ','Du ','Xian ',
        'Zhuan ','San ','Can ','Tham ','Can ','Can ','Ai ','Dai ','You ','Cha ','Ji ','You ','Song ','Fan ','Shou ','Guai ',
        'Ba ','Fa ','Ruo ','Shi ','Thuc ','Zhuo ','Qu ','Thu ','Bian ','Xu ','Jia ','Pan ','Sou ','Gao ','Wei ','Sou ',
        'Die ','Rui ','Cong ','Kou ','Gu ','Cau ','Ling ','Gua ','Tao ','Khau ','Zhi ','Jiao ','Zhao ','Bot ','Ding ','Ke ',
        'Thai ','Chi ','Su ','You ','Qiu ','Po ','Xie ','Hao ','Ti ','Tan ','Chi ','Le ','Diao ','Ji ','Duk ','Hong ',
        ],
    'x54':[
        'Mie ','Hu ','Mang ','Chi ','Ge ','Xuan ','Yao ','Zi ','He ','Ji ','Diao ','Cun ','Tong ','Danh ','Hou ','Li ',
        'Tu ','Huong ','Cha ','Xia ','Ye ','Lu ','A ','Ma ','Ou ','Xue ','Yi ','Quan ','Chou ','Lin ','Tun ','Ngam ',
        'Fei ','Bi ','Qin ','Tam ','Jie ','Bu ','Fou ','Va ','Dun ','Phan ','Hoe ','Ham ','Ting ','Hang ','Shun ','Qi ',
        'Hong ','Zhi ','Shen ','Wu ','Wu ','Chao ','Ne ','Xue ','Cop ','Xuy ','Dou ','Wen ','Hong ','Ou ','Ngo ','Gao ',
        'Ya ','Jun ','Lu ','E ','Ge ','Mei ','Ngoc ','Qi ','Cheng ','Wu ','Gao ','Fu ','Jiao ','Hong ','Chi ','Sheng ',
        'Ne ','Tun ','Fu ','Yi ','Dai ','Ou ','Li ','Bai ','Yuan ','Kuai ','','Qiang ','Wu ','E ','Te ','Quan ',
        'Pen ','Ran ','Nai ','M ','Ling ','Ran ','You ','Di ','Chu ','Shi ','Zhou ','Tie ','Xi ','The ','Qi ','Ping ',
        'Zi ','Oa ','Zi ','Wei ','Gau ','Ha ','Nao ','Xia ','Pei ','Yi ','Xiao ','Shen ','Hu ','Ming ','Da ','Qu ',
        'Ju ','Cam ','Za ','Tuo ','Duo ','Pou ','Bau ','Bi ','Phot ','Yang ','He ','Zha ','Hoa ','Hay ','Jiu ','Yong ',
        'Fu ','Que ','Chu ','Wa ','Ka ','Gu ','Ka ','Zuo ','Bu ','Long ','Giong ','Ning ','Ta ','Si ','Xian ','Huo ',
        'Qi ','Er ','E ','Quang ','Zha ','Choi ','Yi ','Lie ','Zi ','Mie ','Mi ','Zhi ','Rao ','Gat ','Chau ','Ge ',
        'Shuai ','Zan ','Xiao ','Cay ','Hui ','Kua ','Huai ','Tao ','Xian ','E ','Xuan ','Hiu ','Oa ','Yan ','Lao ','Yi ',
        'Ai ','Pin ','Shen ','Tong ','Hong ','Xiong ','Duo ','Oa ','Ha ','Tai ','Yu ','Di ','Pai ','Xiang ','Ai ','Gan ',
        'Kuang ','Ya ','Da ','Xiao ','Bi ','Yue ','','Hua ','Sasou ','Kuai ','Duo ','','Ji ','Nong ','Mou ','Yo ',
        'Hao ','Yuan ','Trong ','Pou ','Mang ','Ca ','Nga ','Chi ','Shao ','Li ','Na ','Zu ','Ha ','Ku ','Hao ','Xian ',
        'Rao ','Buot ','Zhe ','Zha ','Liang ','Ba ','Mie ','Le ','Sui ','Fou ','Bu ','Han ','Heng ','Geng ','Shuo ','Ge ',
        ],
    'x55':[
        'You ','Ngon ','Gu ','Gu ','Bai ','Han ','Suo ','Chun ','Yi ','Ai ','Jia ','Tu ','Xian ','Huan ','Li ','Hoi ',
        'Tang ','Zuo ','Qiu ','Che ','Wu ','Zao ','Ya ','Dou ','Qi ','Di ','Qin ','Ma ','Mal ','Hong ','Dou ','Kes ',
        'Lao ','Liang ','Suo ','Zao ','Huan ','Laang ','Sha ','Ji ','Zuo ','Wo ','Feng ','Cam ','Hu ','Qi ','Shou ','Wei ',
        'Shua ','Xuong ','Er ','Li ','Qiang ','An ','Jie ','Yo ','Nian ','Yu ','Tian ','Lai ','Thep ','Xi ','Tuo ','Hu ',
        'Nhai ','Zhou ','Nou ','Ken ','Troc ','Zhuo ','Thuong ','Di ','Heng ','Lam ','A ','Xiao ','Xiang ','Tun ','Wu ','Wen ',
        'Cui ','Sha ','Quat ','Qi ','Qi ','Tao ','Dan ','Dan ','Ye ','Zi ','Bi ','Cui ','Chuo ','He ','Ya ','Qi ',
        'Zhe ','Fei ','Liang ','Ham ','Pi ','Sha ','La ','Ze ','Qing ','Quay ','Pa ','Gia ','Se ','Zhuan ','Nie ','Guo ',
        'Luo ','Nham ','Di ','Quan ','Tan ','Bo ','Ding ','Lang ','Xiao ','Geoi ','Tang ','Chi ','Ti ','An ','Jiu ','Dan ',
        'Ka ','Ngum ','Wei ','Nan ','Shan ','Yu ','Zhe ','La ','Jie ','Hou ','Han ','Die ','Zhou ','Chai ','Oa ','Re ',
        'Yu ','Yin ','Zan ','Eo ','O ','Mian ','Hu ','Yun ','Chuan ','Hui ','Huan ','Huan ','Xi ','He ','Ji ','Kui ',
        'Zhong ','Wei ','Sha ','Xu ','Huang ','Du ','Nham ','Xuan ','Liang ','Yu ','Tang ','Chi ','Qiao ','Yan ','Dan ','Pen ',
        'Can ','Li ','Yo ','Zha ','Wei ','Miao ','Ying ','Pen ','Phos ','Kui ','Xi ','Du ','Jie ','Lou ','Ku ','Sao ',
        'Huo ','Ti ','Yao ','Gao ','A ','Xiu ','Qiang ','Se ','Yong ','Nho ','Hong ','Xie ','Yi ','Suo ','Mua ','Cha ',
        'Hai ','Ke ','Ta ','Sang ','Xin ','Ru ','Sou ','Cut ','Ji ','Bang ','Wu ','Khem ','Shi ','Ge ','Zi ','Jie ',
        'Luo ','Weng ','Wa ','Si ','Chi ','Hao ','Suo ','Garon ','Hai ','Suo ','Qin ','Nie ','He ','Cis ','Sai ','Ng ',
        'Ge ','Na ','Dia ','Ai ','','Tong ','Bi ','Ngao ','Ao ','Lian ','Cui ','Zhe ','Mo ','Sou ','Sou ','Tan ',
        ],
    'x56':[
        'Di ','Qi ','Jiao ','Chong ','Jiao ','Kai ','Han ','Tham ','Tao ','Jia ','Ai ','Xiao ','Piao ','Lau ','Ga ','Gu ',
        'Xiao ','Hu ','Hui ','Guo ','Ou ','Xian ','Ze ','Chang ','Xu ','Po ','De ','Ma ','Ma ','Hu ','Lei ','Du ',
        'Ga ','Tang ','Ye ','Beng ','Ying ','Saai ','Jiao ','Mi ','Xiao ','Hua ','Mai ','Ran ','Choi ','Peng ','Lao ','Xiao ',
        'Ji ','Zhu ','Trao ','Kui ','Zui ','Xiao ','Si ','Hao ','Fu ','Liao ','Qiao ','Hi ','Xiu ','Tan ','Tan ','Hei ',
        'Sun ','E ','Ton ','Fan ','Chi ','Vay ','Zan ','Chuang ','Cu ','Dan ','Yu ','Tun ','Cheng ','Jiao ','Ye ','Hap ',
        'Qi ','Hao ','Lian ','Xu ','Deng ','Hui ','Yin ','Pu ','Jue ','Qin ','Xun ','Nie ','Lu ','Si ','Yan ','Ying ',
        'Da ','Dan ','O ','Zhou ','Jin ','Nong ','Yue ','Hui ','Qi ','E ','Zao ','Yi ','Shi ','Jiao ','Yuan ','Ai ',
        'Yong ','Jue ','Goi ','Yu ','Phun ','Dao ','Gat ','Ham ','Dun ','Dang ','Hanashi ','Sai ','Pi ','Pi ','Yin ','Zui ',
        'Ning ','Di ','Lan ','Ta ','Huo ','Nheo ','Hao ','Xia ','Ya ','Doi ','Xi ','Tru ','Ji ','Jin ','Hao ','Ti ',
        'Chang ','','','Ca ','Ti ','Lu ','Hui ','Bo ','You ','Nie ','Yin ','Hu ','Mut ','Huang ','Zhe ','Li ',
        'Liu ','Haai ','Nang ','Xiao ','Mo ','Yan ','Li ','Lo ','Lung ','Fu ','Dan ','Chen ','Pin ','Pi ','Xiang ','Huo ',
        'Mo ','Xi ','Duo ','Ku ','Yan ','Chan ','Inh ','Rang ','Dian ','La ','Ta ','Xiao ','Jiao ','Chuo ','Huan ','Huo ',
        'Zhuan ','Nie ','Hiu ','Ca ','Le ','Chan ','Chai ','Li ','Yi ','La ','Nang ','Zan ','Su ','Xi ','So ','Jian ',
        'Za ','Chuc ','Lan ','Nie ','Nang ','Trom ','Lo ','Wei ','Hui ','Yin ','Tu ','Si ','Nin ','Jian ','Hui ','Xin ',
        'Nhan ','Nan ','Tuan ','Tuan ','Dun ','Kang ','Yuan ','Jiong ','Pian ','Yun ','Cong ','Hu ','Hui ','Yuan ','E ','Guo ',
        'Khon ','Song ','Wei ','Tu ','Wei ','Lun ','Guo ','Khuan ','Ri ','Ling ','Co ','Quoc ','Tai ','Guo ','Tu ','You ',
        ],
    'x57':[
        'Guo ','Yin ','Hun ','Bo ','Yu ','Han ','Yuan ','Lun ','Quan ','Yu ','Qing ','Quoc ','Chuan ','Wei ','Yuan ','Quan ',
        'Ku ','Fu ','Yuan ','Yuan ','E ','Toshokan ','Tu ','Tu ','Tuan ','Lue ','Hui ','Yi ','Yuan ','Luan ','Luan ','Tu ',
        'Ya ','Tu ','Ting ','Sheng ','Pu ','Lu ','Iri ','Ya ','Zai ','Wei ','Ge ','Yu ','Wu ','Gui ','Pi ','Yi ',
        'Di ','Qian ','Qian ','Zhen ','Zhuo ','Dang ','Qia ','Akutsu ','Yama ','Kuang ','Chang ','Qi ','Nie ','Mo ','Ji ','Jia ',
        'Zhi ','Zhi ','Ban ','Xun ','Tou ','Qin ','Fen ','Quan ','Keng ','Tun ','Fang ','Phan ','Ben ','Tan ','Kan ','Huai ',
        'Zuo ','Ganh ','Bi ','Xing ','Di ','Jing ','Ji ','Kuai ','Di ','Jing ','Jian ','Tan ','Li ','Ba ','Wu ','Vun ',
        'Zhui ','Pha ','Pan ','Tang ','Kun ','Qu ','Tan ','Zhi ','Tuo ','Gan ','Ping ','Dian ','Gua ','Noi ','Tai ','Pi ',
        'Jiong ','Yang ','Fo ','Ao ','Liu ','Qiu ','Mu ','Ke ','Gou ','Xue ','Ba ','Chi ','Che ','Ling ','Zhu ','Fu ',
        'Hu ','Zhi ','Thuy ','Lap ','Long ','Long ','Lu ','Ao ','Tai ','Bau ','','Xing ','Dong ','Ji ','Ke ','Lu ',
        'Ci ','Chi ','Lei ','Gay ','Yin ','Hou ','Dui ','Zhao ','Fu ','Guang ','Yao ','Duo ','Duo ','Gui ','Cha ','Yang ',
        'Yin ','Fa ','Gou ','Yuan ','Die ','Xie ','Ken ','Jiong ','Shou ','E ','Ha ','Dian ','Hong ','Wu ','Khoai ','',
        'Tao ','Dang ','Kai ','Gake ','Nao ','Ang ','Xing ','Xian ','Huan ','Bang ','Pei ','Ba ','Yi ','Yin ','Han ','Xu ',
        'Chui ','Cen ','Geng ','Ai ','Peng ','Fang ','Que ','Yong ','Xun ','Jia ','Di ','Mai ','Lang ','Xuan ','Thanh ','Yan ',
        'Jin ','Zhe ','Lei ','Lie ','Pu ','Cheng ','Gomi ','Bu ','Shi ','Xun ','Guo ','Jiong ','Ye ','Nam ','Di ','Yu ',
        'Bu ','Ya ','Juan ','Sui ','Pi ','Cheng ','Wan ','Ju ','Lun ','Zheng ','Kong ','Chong ','Dong ','Dai ','Tan ','An ',
        'Cai ','Shu ','Beng ','Kan ','Zhi ','Duo ','Yi ','Chap ','Yi ','Pei ','Co ','Zhun ','Qi ','Sao ','Ju ','Ni ',
        ],
    'x58':[
        'Ku ','Ke ','Tang ','Kun ','Ni ','Jian ','Dui ','Jin ','Gang ','Yu ','E ','Peng ','Gu ','Tu ','Leng ','',
        'Ya ','Qian ','','An ','','Duo ','Nao ','Tu ','Cheng ','Yin ','Hun ','Bi ','Lian ','Guo ','Die ','Zhuan ',
        'Hou ','Bao ','Bao ','Yu ','Di ','Mao ','Jie ','Ruan ','E ','Geng ','Kham ','Zong ','Yu ','Huang ','E ','Yao ',
        'Yan ','Bao ','Ji ','Mei ','Chang ','Du ','Tuo ','Om ','Feng ','Zhong ','Jie ','Zhen ','Feng ','Gang ','Chuan ','Jian ',
        'Hei ','Rui ','Xiang ','Huang ','Leng ','Duan ','','Xuan ','Ji ','Ji ','Khoi ','Ying ','Ta ','Cheng ','Yong ','Kai ',
        'Su ','Su ','Shi ','Mi ','Ta ','Weng ','Cheng ','Tu ','Tang ','Que ','Zhong ','Li ','Peng ','Bang ','Tac ','Zang ',
        'Dui ','Tian ','Wu ','Cheng ','Ven ','Ge ','Zhen ','Ai ','Gong ','Yan ','Kan ','Tian ','Yuan ','Wen ','Xie ','Liu ',
        'Ama ','Lang ','Chang ','Vung ','Beng ','Chen ','Cu ','Lu ','Ou ','Qian ','Mei ','Mo ','Zhuan ','Shuang ','Thuc ','Lou ',
        'Chi ','Man ','Biao ','Jing ','Qi ','Shu ','Di ','Zhang ','Kan ','Yong ','Dian ','Chen ','Zhi ','Xi ','Guo ','Qiang ',
        'Jin ','Di ','Shang ','Mo ','Cui ','Yan ','Ta ','Zeng ','Qi ','Qiang ','Liang ','','Zhui ','Qiao ','Tang ','Xu ',
        'Shan ','Shan ','Ba ','Pu ','Kuai ','Dong ','Fan ','Que ','Mo ','Dun ','Dun ','Zun ','Di ','Sheng ','Duo ','Duo ',
        'Tan ','Deng ','Wu ','Fen ','Huang ','Tan ','Da ','Ye ','Sho ','Mama ','Ao ','Qiang ','Ji ','Qiao ','Ken ','Yi ',
        'Pi ','Bi ','Dian ','Jiang ','Ye ','Yong ','Bo ','Tan ','Lan ','Ju ','Huai ','Dang ','Rang ','Qian ','Xun ','Lan ',
        'Xi ','He ','Ai ','Ya ','Dao ','Hao ','Ruan ','Mama ','Lei ','Kuang ','Lu ','Yan ','Tan ','Wei ','Huai ','Long ',
        'Long ','Rui ','Li ','Lin ','Rang ','Ten ','Xun ','Yan ','Lei ','Ba ','','Shi ','Nham ','','Zhuang ','Zhuang ',
        'Sheng ','Yi ','Mai ','Ke ','Zhu ','Zhuang ','Hu ','Hu ','Kun ','Nhat ','Hu ','Xu ','Kun ','Tho ','Mang ','Zun ',
        ],
    'x59':[
        'Shou ','Yi ','Zhi ','Gu ','Chu ','Jiang ','Feng ','Bei ','Cay ','Bian ','Sui ','Qun ','Ling ','Fu ','Zuo ','Xia ',
        'Xiong ','','Nao ','Xia ','Kui ','Xi ','Wai ','Yuan ','Mao ','Tuc ','Duo ','Duo ','Ye ','Qing ','Uys ','Gou ',
        'Gou ','Qi ','Meng ','Meng ','Yin ','Huo ','Chen ','Da ','Ze ','Tian ','Tai ','Phu ','Guai ','Yao ','Yang ','Hang ',
        'Gao ','That ','Ben ','Tai ','Tou ','Yan ','Bi ','Yi ','Khoa ','Jia ','Duo ','Kwu ','Kuang ','Yun ','Jia ','Pa ',
        'En ','Lian ','Huan ','Di ','Yan ','Pao ','Quan ','Qi ','Nai ','Phung ','Xie ','Fen ','Dian ','','Kui ','Tau ',
        'Huan ','Qi ','Kai ','She ','Ben ','Yi ','Jiang ','Tao ','Zang ','Ben ','Xi ','Xiang ','Fei ','Diao ','Xun ','Keng ',
        'Dian ','Ao ','Xa ','Weng ','Pan ','Ao ','Wu ','Ao ','Jiang ','Lian ','Duo ','Yun ','Jiang ','Shi ','Phan ','Huo ',
        'Bi ','Lian ','Duo ','Nu ','Nu ','Ding ','Nai ','Qian ','Gian ','Ta ','Jiu ','Nan ','Cha ','Hao ','Xian ','Fan ',
        'Ji ','Shuo ','Nhu ','Phi ','Wang ','Hong ','Zhuang ','Fu ','Ma ','Dan ','Ren ','Fu ','Jing ','Ngon ','Xie ','Wen ',
        'Zhong ','Pa ','Du ','Ji ','Keng ','Zhong ','Yao ','Jin ','Yun ','Miao ','Pei ','Shi ','Yue ','Trang ','Niu ','Yan ',
        'Na ','Xin ','Fen ','Bi ','Yu ','Tuo ','Feng ','Yuan ','Fang ','Wu ','Yu ','Gui ','Du ','Ba ','Ni ','Dau ',
        'Zhuo ','Zhao ','Da ','Nai ','Yuan ','Tou ','Xuan ','Zhi ','E ','Muoi ','Mo ','Qi ','Bi ','Shen ','Qie ','E ',
        'He ','Xu ','Fa ','Zheng ','Min ','Nua ','Mu ','Fu ','Lanh ','Zi ','Zi ','Shi ','Ran ','Shan ','Yang ','Man ',
        'Thu ','Gu ','Si ','Xing ','Wei ','Zi ','Ju ','Shan ','Pin ','Ren ','Yao ','Tong ','Jiang ','Shu ','Ji ','Gai ',
        'Shang ','Kuo ','Juan ','Jiao ','Gou ','Mu ','Gian ','Jian ','Yi ','Nian ','Zhi ','Ji ','Ji ','Xian ','Heng ','Guang ',
        'Jun ','Kua ','Yan ','Ming ','Lie ','Pei ','Yan ','You ','Yan ','Cha ','Shen ','Nhan ','Chi ','Gui ','Quan ','Tu ',
        ],
    'x5a':[
        'Song ','Uy ','Hong ','Wa ','Lou ','Ya ','Rao ','Jiao ','Luan ','Ping ','Xian ','Shao ','Li ','Cheng ','Xiao ','Mang ',
        '','Suo ','Wu ','Wei ','Ke ','Lai ','Chuo ','Ding ','Nuong ','Xing ','Nan ','Yu ','Na ','Pei ','Nei ','Juan ',
        'Shen ','Zhi ','Han ','Di ','Zhuang ','Nga ','Pin ','Tui ','Han ','Mian ','Wu ','Yan ','Wu ','Xi ','Yan ','Yu ',
        'Si ','Yu ','Wa ','','Xian ','Ju ','Thu ','Shui ','Qi ','Xian ','Zhui ','Dong ','Chang ','Lu ','Ai ','E ',
        'E ','Lau ','Mian ','Cong ','Pou ','Ju ','Ba ','Cai ','Ding ','Wan ','Biao ','Xiao ','Shu ','Qi ','Hui ','Fu ',
        'E ','Wo ','Tan ','Fei ','','Jie ','Tian ','Ni ','Quan ','Jing ','Hun ','Jing ','Qian ','Dian ','Xing ','Hu ',
        'Wa ','Lai ','Bi ','Yin ','Zhou ','Chuo ','Phu ','Jing ','Lun ','Yan ','Lam ','Kun ','Dam ','Ya ','','Li ',
        'Dian ','Xian ','Hwa ','Hua ','Ying ','Chan ','Shen ','Ting ','Dang ','Yao ','Wu ','Nan ','Ruo ','Jia ','Tou ','Xu ',
        'Yu ','Wei ','Ti ','Rou ','Mei ','Dan ','Ruan ','Qin ','','Wu ','Qian ','Chun ','Mao ','Fu ','Chua ','Duan ',
        'Xi ','Zhong ','Moi ','Huang ','Mian ','An ','Ying ','Xuan ','','Wei ','Mei ','Yuan ','Zhen ','Qiu ','Ti ','Xie ',
        'Tuo ','Lian ','Mao ','Ran ','Si ','Pian ','Wei ','Oa ','Jiu ','Hu ','Ao ','','Bou ','Xu ','Tou ','Gui ',
        'Zou ','Yao ','Pi ','Xi ','Yuan ','Ying ','Rong ','Ru ','Chi ','Liu ','Mei ','Pan ','Ao ','Ma ','Gou ','Kui ',
        'Qin ','Jia ','Dau ','Zhen ','Yuan ','Cha ','Yong ','Ming ','Ying ','Ji ','Su ','Niao ','Xian ','Tao ','Pang ','Lang ',
        'Nao ','Bao ','Ai ','Pi ','Pin ','Yi ','Piao ','Yu ','Lei ','Xuan ','Man ','Yi ','Zhang ','Kang ','Yong ','Ni ',
        'Li ','Di ','Gui ','Yan ','Jin ','Zhuan ','Chang ','Ce ','Han ','Non ','Lao ','Mo ','Zhe ','Hu ','Hu ','Ao ',
        'Nen ','Qiang ','Maa ','Pie ','Gu ','Wu ','Jiao ','Tuo ','Zhan ','Mao ','Xian ','Xian ','Mo ','Liao ','Lian ','Hua ',
        ],
    'x5b':[
        'Gui ','Deng ','Zhi ','Xu ','','Hua ','Xi ','Hui ','Rao ','Xi ','Yan ','Chan ','Jiao ','Mei ','Fan ','Fan ',
        'Xian ','Yi ','Wei ','Jiao ','Fu ','Shi ','Bi ','Shan ','Sui ','Qiang ','Lian ','Huan ','','Niao ','Dong ','Yi ',
        'Can ','Ai ','Niang ','Neng ','Ma ','Tiao ','Chou ','Jin ','Ci ','Yu ','Pin ','','Xu ','Nai ','Yan ','Tai ',
        'Anh ','Can ','Niao ','','Ying ','Mian ','Kaka ','Ma ','Shen ','Xing ','Ni ','Du ','Liu ','Yuan ','Lan ','Yan ',
        'Shuang ','Ling ','Jiao ','Niang ','Lan ','Xian ','Ying ','Shuang ','Shuai ','Quan ','Mi ','Li ','Luan ','Yan ','Zhu ','Lan ',
        'Zi ','Jie ','Jue ','Jue ','Kong ','Yun ','Zi ','Zi ','Cun ','Sun ','Fu ','But ','Zi ','Xiao ','Xin ','Meng ',
        'Si ','Tai ','Bao ','Ji ','Gu ','Nua ','Xue ','','Zhuan ','Hai ','Luan ','Sun ','Huai ','Mie ','Cong ','Qian ',
        'Shu ','Chan ','Ya ','Zi ','Ni ','Fu ','Zi ','Li ','Hoc ','Bo ','Nho ','Lai ','Nie ','Nie ','Ying ','Luan ',
        'Mian ','Ning ','Rong ','Ta ','Gui ','Zhai ','Qiong ','Yu ','Thu ','An ','Tu ','Tong ','Hoan ','Rou ','Yao ','Hong ',
        'Yi ','Jing ','Zhun ','Mi ','Zhu ','Dang ','Hong ','Zong ','Quan ','Tru ','Ding ','Wan ','Nghi ','Bao ','Shi ','Shi ',
        'Chong ','Shen ','Ke ','Xuan ','That ','You ','Huan ','Yi ','Tiao ','Shi ','Xian ','Cung ','Cheng ','Qun ','Gong ','Xiao ',
        'Zai ','Zha ','Bao ','Hai ','Yan ','Xiao ','Gia ','Shen ','Chen ','Dung ','Huang ','Mi ','Kou ','Kuan ','Bin ','Tuc ',
        'Cai ','Zan ','Ji ','Yuan ','Gui ','Yin ','Mi ','Khau ','Qing ','Que ','Zhen ','Jian ','Phu ','Ning ','Bing ','Huan ',
        'Mei ','Qin ','Han ','Ngu ','Shi ','Ning ','Jin ','Ning ','Zhi ','Yu ','Bao ','Kuan ','Ning ','Qin ','Mo ','Cha ',
        'Ju ','Gua ','Qin ','Hu ','Wu ','Liao ','Shi ','Ning ','Zhai ','Shen ','Wei ','Xie ','Khoan ','Hui ','Liao ','Jun ',
        'Huan ','Yi ','Yi ','Bao ','Qin ','Chong ','Bao ','Feng ','Thon ','Dui ','Si ','Xun ','Dao ','Lu ','Dui ','Tho ',
        ],
    'x5c':[
        'Po ','Phong ','Zhuan ','Fu ','She ','Ke ','Jiang ','Tuong ','Zhuan ','Wei ','Zun ','Xun ','Shu ','Dui ','Dao ','Xiao ',
        'Ji ','Shao ','Er ','Er ','Er ','Ga ','Jian ','Shu ','Chen ','Shang ','Chuong ','','Ga ','Chang ','Liao ','Xian ',
        'Xian ','','Wang ','Wang ','You ','Liao ','Liao ','Yao ','Mang ','Wang ','Wang ','Wang ','Ga ','Yao ','Duo ','Kui ',
        'Zhong ','Jiu ','Gan ','Gu ','Gan ','Tui ','Gan ','Gan ','Thay ','Yin ','Chi ','Kao ','Ni ','Jin ','Wei ','Niao ',
        'Cuc ','Pi ','Ceng ','Xi ','Bi ','Cu ','Jie ','Tian ','Khuat ','Ti ','Jie ','Wu ','Diao ','Thi ','Shi ','Ping ',
        'Ji ','Xie ','Chen ','Xi ','Ni ','Zhan ','Xi ','','Man ','E ','Lou ','Ping ','Ti ','Fei ','Shu ','Xie ',
        'Tu ','Lu ','Lu ','Xi ','Ceng ','Lu ','Ju ','Xie ','Ju ','Jue ','Liao ','Jue ','Thuoc ','Xi ','Che ','Truan ',
        'Ni ','Son ','','Xian ','Li ','Xue ','Nata ','','Long ','Yi ','Qi ','Ren ','Wu ','Han ','Shen ','Yu ',
        'Chu ','Sui ','Qi ','','Yue ','Ban ','Yao ','Ang ','Ya ','Wu ','Jie ','E ','Ji ','Qian ','Fen ','Yuan ',
        'Qi ','Cen ','Qian ','Qi ','Cha ','Jie ','Qu ','Gang ','Xian ','Ao ','Lan ','Dao ','Ba ','Zuo ','Zuo ','Yang ',
        'Ju ','Gang ','Ke ','Gou ','Xue ','Bei ','Li ','Tiao ','Ju ','Nham ','Fu ','Xiu ','Jia ','Ling ','Tuo ','Pei ',
        'You ','Dai ','Kuang ','Yue ','Qu ','Hu ','Po ','Min ','Ngan ','Tiao ','Ling ','Chi ','Yuri ','Dong ','Sen ','Kui ',
        'Xiu ','Mao ','Tong ','Xue ','Yi ','Kura ','He ','Ke ','Luo ','E ','Fu ','Xun ','Die ','Lu ','An ','Er ',
        'Gai ','Quan ','Tong ','Yi ','Mu ','Shi ','An ','Wei ','Hu ','Zhi ','Mi ','Li ','Ji ','Tong ','Wei ','You ',
        'Touge ','Xia ','Li ','Yao ','Jiao ','Zheng ','Luan ','Jiao ','E ','E ','Yu ','Ye ','Bu ','Qiao ','Qun ','Feng ',
        'Feng ','Nao ','Li ','You ','Xian ','Hong ','Dao ','Shen ','Cheng ','Tu ','Geng ','Jun ','Hao ','Xia ','Yin ','Yu ',
        ],
    'x5d':[
        'Lang ','Kan ','Lao ','Lai ','Xian ','Que ','Kong ','Sung ','Chong ','Ta ','','Hua ','Ju ','Lai ','Qi ','Min ',
        'Kun ','Kun ','Zu ','Gu ','Cui ','Ya ','Day ','Gang ','Lun ','Son ','Leng ','Jue ','Duo ','Zheng ','Guo ','Yin ',
        'Dong ','Han ','Zheng ','Wei ','Yao ','Pi ','Yan ','Song ','Jie ','Beng ','Zu ','Jue ','Dong ','Zhan ','Gu ','Yin ',
        '','Ze ','Huang ','Yu ','Wei ','Yang ','Feng ','Qiu ','Dun ','Ti ','Yi ','Zhi ','Shi ','Zai ','Yao ','E ',
        'Zhu ','Kham ','Lu ','Yan ','Mei ','Gan ','Ji ','Ji ','Huan ','Ting ','Sheng ','Mi ','Qian ','Wu ','Yu ','Zong ',
        'Lan ','Jue ','Yan ','Yan ','Wei ','Zong ','Cha ','Sui ','Rong ','Yamashina ','Qin ','Yu ','Ki ','Lou ','Tu ','Dui ',
        'Xi ','Weng ','Cang ','Dang ','Hong ','Jie ','Ai ','Liu ','Wu ','Tung ','Qiao ','Zi ','Wei ','Beng ','Dian ','Cuo ',
        'Qian ','Yong ','Nie ','Cuo ','Ji ','','Tao ','Song ','Zong ','Jiang ','Liao ','','Chan ','Die ','Cen ','Ding ',
        'Tu ','Lou ','Zhang ','Zhan ','Zhan ','Ao ','Cao ','Qu ','Qiang ','Zui ','Zui ','Dao ','Dao ','Xi ','Yu ','Bo ',
        'Long ','Xiang ','Ceng ','Bo ','Qin ','Jiao ','Yan ','Lao ','Zhan ','Lin ','Liao ','Liao ','Jin ','Deng ','Duo ','Zun ',
        'Jiao ','Gui ','Yao ','Qiao ','Yao ','Jue ','Zhan ','Yi ','Xue ','Nao ','Ye ','Ye ','Yi ','E ','Xian ','Ji ',
        'Xie ','Ke ','Xi ','Di ','Ao ','Zui ','','Yi ','Rong ','Dao ','Ling ','Za ','Yu ','Yue ','Yin ','',
        'Jie ','Li ','Sui ','Long ','Long ','Dian ','Ying ','Xi ','Ju ','Chan ','Ying ','Kui ','Yan ','Nguy ','Nao ','Quan ',
        'Chao ','Cuan ','Luan ','Dian ','Dian ','','Nham ','Yan ','Yan ','Nao ','Yan ','Chuan ','Gui ','Chuan ','Chau ','Huang ',
        'Jing ','Xun ','Sao ','Chao ','Lie ','Gong ','Zuo ','Qiao ','Ju ','Gong ','Kek ','Wu ','Pwu ','Pwu ','Sai ','Qiu ',
        'Qiu ','Ji ','Yi ','Si ','Ba ','Zhi ','Zhao ','Xiang ','Yi ','Jin ','Xun ','Juan ','Phas ','Ron ','Can ','Fu ',
        ],
    'x5e':[
        'Za ','Bi ','Shi ','Bo ','Ding ','Shuai ','Fan ','Nie ','Shi ','Fen ','Pa ','Zhi ','Hoi ','Hu ','Dan ','Wei ',
        'Zhang ','Tang ','Dai ','Ma ','Pei ','Pa ','Tie ','Fu ','Lian ','Zhi ','Zhou ','Bo ','Zhi ','Di ','Mo ','Yi ',
        'Yi ','Ping ','Qia ','Juan ','Ru ','Shuai ','Dai ','Zheng ','Shui ','Qiao ','Zhen ','Su ','Qun ','Xi ','Bang ','Dai ',
        'Gui ','Chou ','Ping ','Truong ','Sha ','Wan ','Dai ','Wei ','Chang ','Sha ','Qi ','Ze ','Guo ','Mao ','Du ','Hou ',
        'Tranh ','Xu ','Mi ','Wei ','Wo ','Fu ','Yi ','Bang ','Ping ','Tazuna ','Gong ','Pan ','Huang ','Thao ','Mi ','Jia ',
        'Teng ','Hui ','Zhong ','Shan ','Man ','Mu ','Biao ','Guo ','Ze ','Mu ','Bang ','Truong ','Jiong ','Chan ','Fu ','Zhi ',
        'Hu ','Phan ','Choang ','Bi ','Hei ','','Mi ','Qiao ','Chan ','Fen ','Meng ','Bang ','Chou ','Mie ','Chu ','Jie ',
        'Xian ','Lan ','Can ','Ping ','Nian ','Qian ','Bing ','Bing ','Xing ','Gan ','Yao ','Huan ','You ','You ','Ji ','Yan ',
        'Pi ','Ting ','Ze ','Guang ','Chang ','Mo ','Qing ','Bi ','Qin ','Dun ','Sang ','Gui ','Ya ','Bai ','Jie ','Xu ',
        'Lu ','Wu ','','Ku ','Ying ','Di ','Pao ','Dian ','Ya ','Miao ','Canh ','Ci ','Fu ','Tong ','Pang ','Fei ',
        'Xiang ','Yi ','Zhi ','Tiao ','Zhi ','Xiu ','Du ','Toa ','Xiao ','Tu ','Gui ','Kho ','Pang ','Ting ','You ','Bu ',
        'Ding ','Cheng ','Lai ','Bei ','Ji ','Am ','Shu ','Khang ','Yong ','Tuo ','Song ','Shu ','Qing ','Yu ','Yu ','Miao ',
        'Sou ','Ce ','Ruong ','Fei ','Jiu ','He ','Hui ','Liu ','Sha ','Lian ','Lang ','Sou ','Zhi ','Pou ','Qing ','Jiu ',
        'Jiu ','Jin ','Ao ','Kuo ','Lou ','Yin ','Liao ','Dai ','Lu ','Yi ','Chu ','Chan ','Tu ','Si ','Xin ','Miao ',
        'Chang ','Vu ','Fei ','Guang ','Koc ','Kuai ','Bi ','Qiang ','Xie ','Lin ','Lin ','Liao ','Lu ','','Ying ','Xian ',
        'Ting ','Yong ','Li ','Ting ','Yin ','Xun ','Dang ','Ting ','Di ','Po ','Jian ','Hui ','Nai ','Hui ','Trap ','Nian ',
        ],
    'x5f':[
        'Kai ','Bian ','Yi ','Qi ','Long ','Fen ','Ju ','Yan ','Yi ','Zang ','Bi ','Yi ','Yi ','Er ','San ','Shi ',
        'Er ','Shi ','Shi ','Cung ','Diao ','Yin ','Hu ','Phat ','Hong ','Wu ','Tui ','Chi ','Jiang ','Ba ','Shen ','Di ',
        'Zhang ','Jue ','Tao ','Fu ','Di ','Mi ','Xian ','Hu ','Chao ','Nu ','Jing ','Zhen ','Yi ','Mi ','Quan ','Wan ',
        'Shao ','Ruo ','Xuan ','Jing ','Dun ','Truong ','Jiang ','Cang ','Peng ','Dan ','Qiang ','Bi ','Bi ','She ','Dan ','Jian ',
        'Gou ','Sei ','Fa ','Bi ','Kou ','Nagi ','Bie ','Xiao ','Dan ','Kuo ','Cuong ','Hong ','Mi ','Kuo ','Wan ','Jue ',
        'Ji ','Ji ','Gui ','Dang ','Lu ','Lu ','Tuan ','Hui ','Zhi ','Hui ','Hui ','Yi ','Yi ','Yi ','Yi ','Huo ',
        'Huo ','Shan ','Xing ','Wen ','Tong ','Yan ','Yan ','Yu ','Chi ','Cai ','Biao ','Diao ','Ban ','Banh ','Yong ','Piao ',
        'Zhang ','Ying ','Chi ','Chi ','Zhuo ','Tuo ','Ji ','Pang ','Zhong ','Yi ','Wang ','Che ','Bi ','Chi ','Ling ','Phot ',
        'Wang ','Chinh ','Cu ','Wang ','Jing ','Dai ','Xi ','Xun ','Hen ','Yang ','Huai ','Lu ','Hou ','Wa ','Cheng ','Zhi ',
        'Xu ','Jing ','Tu ','Cong ','','Lai ','Cong ','De ','Pai ','Xi ','','Qi ','Chang ','Zhi ','Cong ','Zhou ',
        'Lai ','Yu ','Xie ','Jie ','Jian ','Chi ','Jia ','Bian ','Huang ','Fu ','Xun ','Wei ','Bang ','Yao ','Vi ','Xi ',
        'Zheng ','Piao ','Chi ','De ','Zheng ','Trung ','Bie ','De ','Chong ','Che ','Jiao ','Wei ','Jiao ','Hui ','Mei ','Long ',
        'Xiang ','Bao ','Qu ','Tam ','Ritsushinben ','Tat ','Hat ','Le ','Ren ','Dao ','Ding ','Gai ','Ji ','Ren ','Ren ','Thin ',
        'Tan ','Thac ','Thac ','Gan ','Qi ','Shi ','Cun ','Zhi ','Vong ','Mang ','Xi ','Fan ','Ying ','Tian ','Min ','Min ',
        'Trung ','Chong ','Wu ','Ji ','Wu ','Xi ','Ye ','You ','Wan ','Cong ','Zhong ','Kuai ','Yu ','Bian ','Zhi ','Qi ',
        'Cui ','Chen ','Tai ','Tun ','Qian ','Nian ','Hun ','Xiong ','Niu ','Wang ','Xian ','Xin ','Kang ','Hot ','Kai ','Fen ',
        ],
    'x60':[
        'Huai ','Tai ','Song ','Wu ','Ou ','Chang ','Chuang ','Ju ','Yi ','Bao ','Chao ','Min ','Pei ','Zuo ','Zen ','Yang ',
        'Kou ','Ban ','No ','Nao ','Zheng ','Pa ','Bo ','Tie ','Gu ','Hu ','Ju ','Da ','Lanh ','Tu ','Chou ','Di ',
        'Dai ','Yi ','Tu ','You ','Fu ','Cap ','Peng ','Xing ','Yuan ','Ni ','Guai ','Fu ','Xi ','Bi ','You ','Qie ',
        'Xuan ','Cong ','Bing ','Huang ','Xu ','Truot ','Pi ','Xi ','Xi ','Tan ','Koraeru ','Zong ','Dui ','','Ki ','Yi ',
        'Chi ','Ren ','Xun ','Shi ','Ghet ','Lau ','Heng ','Kuang ','Mu ','Zhi ','Xie ','Lian ','Tiao ','Huang ','Die ','Hao ',
        'Kong ','Nguay ','Heng ','Xi ','Xiao ','Shu ','Shi ','Kua ','Qiu ','Yang ','Hui ','Hui ','Chi ','Jia ','Yi ','Hung ',
        'Guai ','Lin ','Hui ','Zi ','Xu ','Chi ','Xiang ','Nu ','Hen ','En ','Ke ','Tong ','Tian ','Cung ','Quan ','Xi ',
        'Qia ','Yue ','Peng ','Ken ','De ','Hui ','E ','Kyuu ','Tong ','Yan ','Kai ','Ce ','Nao ','Yun ','Mang ','Yong ',
        'Yong ','Yuan ','Pi ','Kun ','Qiao ','Dot ','Yu ','Do ','Jie ','Xi ','Zhe ','Lin ','Ti ','Han ','Hao ','Qie ',
        'Ti ','Bu ','Yi ','Qian ','Hoi ','Xi ','Bei ','Man ','Yi ','Heng ','Song ','Thoan ','Cheng ','Kui ','Wu ','Wu ',
        'You ','Li ','Liang ','Huan ','Cong ','Yi ','Yue ','Li ','Nin ','Nao ','E ','Que ','Xuan ','Qian ','Wu ','Min ',
        'Cong ','Fei ','Bi ','Duo ','Cui ','Chang ','Muon ','Li ','Ji ','Guan ','Guan ','Xing ','Dao ','Qi ','Kong ','Tian ',
        'Lun ','Xi ','Kan ','Kun ','Ni ','Qing ','Chou ','Run ','Guo ','Chan ','Kinh ','Wan ','Yuan ','Cam ','Ji ','Lin ',
        'Yu ','Huo ','He ','Quan ','Tan ','Ti ','Ti ','Nie ','Wang ','Chuo ','Hot ','Hun ','Xi ','Chang ','Xin ','Wei ',
        'Hui ','E ','Rui ','Zong ','Jian ','Yong ','Dian ','Ju ','Can ','Cheng ','De ','Bei ','Qie ','Can ','Dan ','Guan ',
        'Duo ','Nao ','Yun ','Xiang ','Nhoai ','Die ','Hoang ','Chun ','Qiong ','Re ','Xing ','Ce ','Bian ','Hun ','Zong ','Ti ',
        ],
    'x61':[
        'Qiao ','Chou ','Bei ','Xuan ','Wei ','Ge ','Qian ','Wei ','Yu ','Yu ','Bi ','Xuan ','Huan ','Min ','Bi ','Yi ',
        'Mian ','Yong ','Kai ','Dang ','Yin ','E ','Chen ','Mou ','Ke ','Ke ','Ngu ','Ai ','Qie ','Yan ','Nuo ','Gan ',
        'Yun ','Zong ','Sai ','Leng ','Fen ','','Kui ','Kui ','Que ','Gong ','Yun ','Su ','Su ','Qi ','Yao ','Song ',
        'Huang ','Ji ','Gu ','Ju ','Chuang ','Ni ','Xie ','Kai ','Zheng ','Yong ','Cao ','Sun ','Shen ','Bo ','Kai ','Yuan ',
        'Xie ','Hun ','Yong ','Yang ','Li ','Sao ','Tao ','Yin ','Ci ','Xu ','Qian ','Tai ','Huang ','Yun ','Shen ','Ming ',
        '','She ','Cong ','Piao ','Mo ','Mo ','Guo ','Chi ','Can ','Can ','Can ','Cui ','Min ','Te ','Zhang ','Tong ',
        'Ao ','Shuang ','Man ','Quen ','Que ','Zao ','Jiu ','Hui ','Kai ','Lian ','Ou ','Tung ','Jin ','Yin ','Lu ','Shang ',
        'Wei ','Tuan ','Man ','Ghen ','She ','Yong ','Qing ','Kang ','Di ','Zhi ','Lou ','Juan ','Qi ','Qi ','Duc ','Ping ',
        'Liao ','Cong ','You ','Chong ','Zhi ','Tong ','Cheng ','Qi ','Qu ','Peng ','Bei ','Bie ','Chun ','Jiao ','Zeng ','Chi ',
        'Lian ','Ping ','Kui ','Hui ','Qiao ','Cheng ','Yin ','Yin ','Xi ','Xi ','Dan ','Tan ','Duo ','Dui ','Dui ','Su ',
        'Jue ','Ce ','Xiao ','Fan ','Fen ','Lao ','Lao ','Chong ','Han ','Qi ','Xian ','Min ','Jing ','Liao ','Wu ','Can ',
        'Jue ','Cu ','Xian ','Tan ','Sheng ','Pi ','Yi ','Chu ','Xian ','Nao ','Dan ','Tan ','Jing ','Song ','Han ','Jiao ',
        'Wai ','Huan ','Dong ','Qin ','Qin ','Qu ','Cao ','Khan ','Xie ','Ying ','Ao ','Mao ','Yi ','Lin ','Se ','Jun ',
        'Huai ','Men ','Lan ','Ai ','Lin ','Yan ','Gua ','Xia ','Chi ','Yu ','Yin ','Dai ','Meng ','Ai ','Mong ','Dui ',
        'Qi ','Mo ','Nham ','Men ','Chou ','Zhi ','Nhua ','Nuo ','Yan ','Yang ','Bo ','Zhi ','Kuang ','Kuang ','You ','Fu ',
        'Liu ','Mie ','Cheng ','','Chan ','Meng ','Lan ','Hoai ','Xuan ','Rang ','Chan ','Ji ','Ju ','Huan ','She ','Yi ',
        ],
    'x62':[
        'Lian ','Nan ','Mi ','Tang ','Jue ','Gang ','Gang ','Gang ','Qua ','Yue ','Wu ','Jian ','Tuat ','Thu ','Nhung ','Xi ',
        'Thanh ','Wo ','Gioi ','Ge ','Jian ','Qiang ','Huo ','Qiang ','Zhan ','Dong ','Qi ','Jia ','Die ','Zei ','Jia ','Ji ',
        'Shi ','Kan ','Ji ','Kui ','Gai ','Deng ','Zhan ','Chuang ','Ge ','Jian ','Jie ','Yu ','Jian ','Yan ','Lu ','Xi ',
        'Zhan ','Xi ','Xi ','Chuo ','Dai ','Qu ','Hu ','Ho ','Hu ','E ','Shi ','Li ','Mao ','Hu ','Li ','Fang ',
        'Suo ','Bian ','Dian ','Jiong ','Shang ','Yi ','Yi ','Shan ','Hu ','Fei ','Yan ','Shou ','Shu ','Tai ','Zha ','Qiu ',
        'Le ','Boc ','Bat ','Da ','Reng ','Chang ','Hameru ','Zai ','Tuo ','Zhang ','Diao ','Giang ','Vo ','Ku ','Han ','Shen ',
        'Xoa ','Yi ','Ngat ','Khau ','Wu ','Tuo ','Qian ','Zhi ','Nhan ','Kuo ','Men ','Sao ','Yang ','Niu ','Ban ','Che ',
        'Rao ','Gap ','Qian ','Ban ','Jia ','Yu ','Phu ','Ao ','Xi ','Pi ','Zhi ','Zi ','E ','Dun ','Quo ','Cheng ',
        'Ji ','Yan ','Kuang ','Bian ','Sao ','Ju ','Wen ','Hu ','Ngoat ','Khoet ','Ba ','Qin ','Zhen ','Zheng ','Yun ','Wan ',
        'Nu ','Yi ','Shu ','Co ','Pou ','Tou ','Dou ','Kang ','Zhe ','Pou ','Fu ','Phao ','Ba ','Ao ','Ze ','Tuan ',
        'Kou ','Lun ','Qiang ','','Hu ','Bao ','Bing ','Zhi ','Banh ','Tan ','Pu ','Pho ','Tai ','Yao ','Zhen ','Zha ',
        'Yang ','Bao ','He ','Nai ','Yi ','Di ','That ','Pho ','Za ','Mo ','Mei ','Shen ','Ya ','Chou ','Qu ','Min ',
        'Chu ','Gio ','Phat ','Zhan ','Zhu ','Dan ','Chai ','Mu ','Nian ','Lap ','Fu ','Pao ','Ban ','Pai ','Ling ','Na ',
        'Guai ','Qian ','Ju ','Tuo ','Ba ','Tuo ','Tuo ','Huc ','Cau ','Chut ','Pan ','Zhao ','Bai ','Bai ','Di ','Ni ',
        'Ju ','Kuo ','Long ','Jian ','','Dung ','Lan ','Ning ','Bo ','Ze ','Tay ','Gan ','Kuo ','Shi ','Cat ','Chung ',
        'Nhum ','Gong ','Gong ','Quan ','Shuan ','Cun ','Zan ','Kao ','Chi ','Xie ','Ce ','Hui ','Phanh ','Ye ','Shi ','Na ',
        ],
    'x63':[
        'Bo ','Chi ','Gua ','Choi ','Quang ','Duo ','Duo ','Zhi ','Qie ','An ','Nong ','Zhen ','Ge ','Gieo ','Ku ','Rung ',
        'Ru ','Tiao ','Tret ','Zha ','Lu ','Die ','Wa ','Jue ','Lyut ','Ju ','Zhi ','Luan ','Ya ','Zhua ','Ta ','Xie ',
        'Nao ','Dang ','Jiao ','Zheng ','Ji ','Hui ','Xun ','Ku ','Ai ','Tuo ','Nuo ','Cuo ','Vot ','Geng ','Ti ','Chan ',
        'Cheng ','Suo ','Suo ','Keng ','Mei ','Long ','Ju ','Vang ','Ken ','Yi ','Ting ','Shan ','Noa ','Wan ','Xie ','Thoc ',
        'Feng ','Keo ','Wu ','Khuan ','Jiu ','Tong ','Kun ','Huo ','Gio ','Zhuo ','Pou ','Le ','Ba ','Han ','Shao ','Nie ',
        'Juan ','Ze ','Song ','Ye ','Jue ','Bu ','Huan ','Bu ','Thoa ','Yi ','Zhai ','Lu ','Sou ','Tuo ','Lao ','Sun ',
        'Banh ','Jian ','Huan ','Dao ','','Uon ','Qin ','Peng ','She ','Lie ','Min ','Men ','Fu ','Bai ','Ju ','Dao ',
        'Wo ','Nhay ','Cuon ','Yue ','Zong ','Chen ','Chui ','Jie ','Tu ','Ben ','Nai ','Nian ','Nuo ','Zu ','Wo ','Xi ',
        'Xian ','Cheng ','Dian ','Sao ','Lun ','Qing ','Gang ','Suot ','Thu ','Trao ','Pou ','Di ','Zhang ','Gun ','Ji ','Tao ',
        'Qia ','Cai ','Bai ','Shu ','Qian ','Ling ','Ye ','Ya ','Jue ','Zheng ','Liang ','Gua ','Yi ','Huo ','Shan ','Zheng ',
        'Luot ','Cai ','Tan ','Che ','Bing ','Jie ','Ti ','Khong ','Suy ','Yan ','Tho ','Zou ','Cuc ','Tian ','Qian ','Ken ',
        'Bai ','Shou ','Jie ','Lu ','Guo ','Haba ','','Zhi ','Dan ','Maang ','Xian ','Sao ','Guan ','Peng ','Yuan ','Nhac ',
        'Jian ','Rinh ','Dua ','Jian ','Yu ','Yan ','Kui ','Nan ','Hong ','Rou ','Pi ','Wei ','Sai ','Zou ','Xuan ','Miao ',
        'Ti ','Nie ','Chap ','Shi ','Zong ','Zhen ','Yi ','Shun ','Heng ','Bian ','Duong ','Huan ','Yan ','Zuan ','An ','Xu ',
        'Ya ','Wo ','Ke ','Chuai ','Ji ','Ti ','La ','La ','Cheng ','Kai ','Jiu ','Jiu ','Dut ','Jie ','Huy ','Geng ',
        'Chong ','Shuo ','She ','Xie ','Yuan ','Qian ','Ye ','Cha ','Zha ','Bei ','Yao ','','Dam ','Lan ','Wen ','Qin ',
        ],
    'x64':[
        'Chan ','Ge ','Lou ','Zong ','Geng ','Jiao ','Cau ','Qin ','Dong ','Que ','So ','Chi ','Zhan ','Ton ','Dun ','Bo ',
        'Chu ','Rong ','Beng ','Sai ','Trao ','Ke ','Gieo ','Dao ','Zhi ','Nu ','Xie ','Gom ','Suu ','Qiu ','Cao ','Xian ',
        'Shuo ','Sang ','Jin ','Mie ','E ','Chui ','Nuo ','Shan ','Ta ','Jie ','Tang ','Pan ','Bung ','Da ','Lat ','Tao ',
        'Hu ','Zhi ','Wa ','Xia ','Qian ','Wen ','Qiang ','Tian ','Zhen ','E ','Xi ','Nuo ','Quan ','Cha ','Zha ','Ge ',
        'Wu ','En ','She ','Kang ','She ','Shu ','Bai ','Yao ','Bin ','Sou ','Tan ','Sa ','Chan ','Suo ','Liao ','Chong ',
        'Chuang ','Guo ','Bing ','Feng ','Shuai ','Di ','Qi ','','Zhai ','Lian ','Tang ','Chi ','Guan ','Lu ','Luo ','Lua ',
        'Zong ','Gai ','Hu ','Zha ','Chuang ','Tang ','Hua ','Cui ','Nai ','Mo ','Ruon ','Gui ','Ying ','Zhi ','Ao ','Zhi ',
        'Nie ','Man ','Shan ','Khua ','Shu ','Suo ','Tuan ','Jiao ','Mo ','Mo ','Zhe ','Shan ','Ken ','Piao ','Jiang ','Yin ',
        'Gou ','Qian ','Liao ','Ji ','Ying ','Quet ','Pie ','Pie ','Lau ','Dun ','Xian ','Ruan ','Quay ','Zan ','Nhat ','Xun ',
        'Cheng ','Cheng ','Sa ','Nheo ','Heng ','Si ','Qian ','Huang ','Da ','Zun ','Nian ','Lin ','Zheng ','Vay ','Chang ','Keo ',
        'Ji ','Cao ','Dan ','Dan ','Che ','Bo ','Che ','Jue ','Xiao ','Liao ','Ben ','Fu ','Qiao ','Bo ','Cuo ','Zhuo ',
        'Zhuan ','Tuo ','Vuc ','Qin ','Dun ','Nian ','','Xie ','Lu ','Jiao ','Cuan ','Ta ','Han ','Qiao ','Zhua ','Jian ',
        'Gan ','Yong ','Lei ','Nong ','Lu ','Chen ','Zhuo ','Ze ','Pu ','Thoc ','Ji ','Dang ','Suo ','Cao ','Qing ','Jing ',
        'Huan ','Jie ','Qin ','Kuai ','Dan ','Xi ','Ge ','Pi ','Bo ','Ao ','Co ','Ye ','','Mang ','Sou ','Mi ',
        'Ji ','Tai ','Zhuo ','Dao ','Xing ','Lan ','Ca ','Ju ','Ye ','Ru ','Ye ','Ye ','Ni ','Wo ','Ji ','Bin ',
        'Ning ','Ge ','Zhi ','Jie ','Kuo ','Mo ','Jian ','Xie ','Lie ','Tan ','Bai ','Sou ','Lu ','Lue ','Rao ','Zhi ',
        ],
    'x65':[
        'Pan ','Yang ','Lei ','Sa ','Shu ','Zan ','Nian ','Xian ','Jun ','Huo ','Li ','La ','Han ','Ying ','Lu ','Long ',
        'Qian ','Qian ','Zan ','Qian ','Dan ','San ','Ying ','Mei ','Rang ','Som ','','Cuan ','Xie ','Nhep ','Ra ','Jun ',
        'Mi ','Li ','Zan ','Luan ','Tan ','Zuan ','Li ','Dian ','Wa ','Dang ','Jiao ','Jue ','Lan ','Li ','Nang ','Chi ',
        'Gui ','Gui ','Qi ','Xin ','Pu ','Sui ','Thu ','Kao ','You ','Gai ','Yi ','Gong ','Gan ','Ban ','Fang ','Zheng ',
        'Bo ','Dian ','Kou ','Min ','Wu ','Co ','He ','Ce ','Xiao ','Mi ','Chu ','Ge ','Di ','Xu ','Jiao ','Min ',
        'Chen ','Jiu ','Zhen ','Duo ','Yu ','Sac ','Ngao ','Bai ','Xu ','Jiao ','Duo ','Lian ','Nie ','Bi ','Chang ','Dian ',
        'Duo ','Yi ','Gan ','San ','Ke ','Yan ','Dun ','Qi ','Dou ','Xiao ','Duo ','Jiao ','Jing ','Yang ','Xia ','Min ',
        'Shu ','Ai ','Xao ','Ai ','Zheng ','Di ','Zhen ','Fu ','So ','Liao ','Qu ','Xiong ','Xi ','Jiao ','Sen ','Jiao ',
        'Zhuo ','Yi ','Lian ','Bi ','Li ','Xiao ','Xiao ','Van ','Xue ','Qi ','Qi ','Zhai ','Bin ','Jue ','Trai ','',
        'Fei ','Ban ','Ban ','Lan ','Yu ','Lan ','Wei ','Dou ','Sheng ','Liao ','Jia ','Hu ','Ta ','Jia ','Yu ','Cham ',
        'Jiao ','Wo ','Tou ','Chu ','Can ','Chi ','Yin ','Bua ','Qiang ','Zhan ','Qu ','Zhuo ','Zhan ','Duan ','Zhuo ','Si ',
        'Tan ','Zhuo ','Zhuo ','Qin ','Lin ','Zhuo ','Chu ','Duan ','Zhu ','Phuong ','Xie ','Hang ','Yu ','Thi ','Pei ','You ',
        'Mye ','Bang ','Qi ','Zhan ','Mao ','Lu ','Pei ','Pi ','Liu ','Fu ','Fang ','Toan ','Tinh ','Jing ','Ni ','Toc ',
        'Zhao ','Yi ','Liu ','Shao ','Jian ','Es ','Yi ','Qi ','Zhi ','Fan ','Piao ','Phuon ','Zhan ','Guai ','Sui ','Yu ',
        'Wu ','Ji ','Ji ','Ji ','Huo ','Ri ','Dan ','Jiu ','Zhi ','Zao ','Xie ','Tiao ','Xun ','Xu ','Xu ','Xu ',
        'Gan ','Han ','Tai ','Di ','Hu ','Chan ','Shi ','Kuang ','Yang ','Shi ','Wang ','Min ','Min ','Tun ','Chun ','Wu ',
        ],
    'x66':[
        'Yun ','Bei ','Ngang ','Ze ','Ban ','Jie ','Con ','Thang ','Hu ','Fang ','Hao ','Gui ','Chang ','Xuan ','Minh ','Hun ',
        'Fen ','Qin ','Hu ','Yi ','Xi ','Xin ','Yan ','Ze ','Fang ','Tan ','Shen ','Ju ','Yang ','Zan ','Bing ','Tinh ',
        'Ying ','Xuan ','Pei ','Zhen ','Ling ','Chun ','Hao ','Muoi ','Zuo ','Mo ','Bian ','Xu ','Hun ','Zhao ','Zong ','Shi ',
        'Shi ','Yu ','Fei ','Die ','Mao ','Ni ','Chang ','Wen ','Dong ','Ai ','Bing ','Ang ','Zhou ','Long ','Xian ','Kuang ',
        'Tiao ','Chao ','Shi ','Huang ','Huang ','Xuan ','Kui ','Xu ','Jiao ','Jin ','Zhi ','Jin ','Shang ','Tong ','Hong ','Yan ',
        'Gai ','Xiang ','Shai ','Xiao ','Ye ','Yun ','Hui ','Han ','Han ','Jun ','Wan ','Xian ','Kun ','Zhou ','Xi ','Sheng ',
        'Sheng ','Bu ','Zhe ','Zhe ','Wu ','Han ','Hui ','Hao ','Chen ','Wan ','Tian ','Zhuo ','Zui ','Zhou ','Pu ','Jing ',
        'Xi ','Shan ','Yi ','Xi ','Qing ','Qi ','Tinh ','Gui ','Zhen ','Yi ','Zhi ','An ','Wan ','Lin ','Liang ','Chang ',
        'Wang ','Xiao ','Zan ','Hi ','Xuan ','Xuan ','Yi ','Xia ','Yun ','Hui ','Fu ','Min ','Kui ','He ','Ying ','Du ',
        'Wei ','Shu ','Qing ','Mao ','Nan ','Jian ','Nuan ','An ','Yang ','Chun ','Yao ','Suo ','Jin ','Ming ','Jiao ','Kai ',
        'Gao ','Weng ','Suong ','Qi ','Hao ','Yan ','Li ','Ai ','Ji ','Gui ','Men ','Zan ','Xie ','Hao ','Mo ','Mo ',
        'Cong ','Ni ','Zhang ','Hui ','Bao ','Han ','Xuan ','Chuan ','Liao ','Xian ','Dan ','Jing ','Pie ','Lin ','Tun ','Xi ',
        'Yi ','Ji ','Huang ','Tai ','Ye ','Ye ','Li ','Tan ','Tong ','Xiao ','Fei ','Qin ','Zhao ','Hao ','Yi ','Xiang ',
        'Xing ','Sen ','Jiao ','Bao ','Jing ','Yan ','Ai ','Ye ','Ru ','Shu ','Meng ','Xun ','Yao ','Pu ','Li ','Chen ',
        'Kuang ','Die ','','Yan ','Huo ','Trua ','Xi ','Rong ','Long ','Nang ','Luo ','Luan ','Shai ','Tang ','Yan ','Chu ',
        'Yue ','Yue ','Khuc ','Day ','Xau ','Ye ','Hu ','He ','Thu ','Tao ','Cao ','Shou ','Man ','Ceng ','Ceng ','Ti ',
        ],
    'x67':[
        'Toi ','Can ','Xu ','Hoi ','Yin ','Qie ','Fen ','Pi ','Yue ','You ','Ruan ','Peng ','Ban ','Phuc ','Ling ','Xoet ',
        'Qu ','','Nu ','Tiao ','Shuo ','Zhen ','Lang ','Lang ','Juan ','Ming ','Huang ','Vong ','Tun ','Zhao ','Ji ','Qi ',
        'Ying ','Zong ','Wang ','Tong ','Lang ','','Meng ','Long ','Moc ','Deng ','Mui ','Mo ','Ben ','Zha ','Shu ','Zhu ',
        '','Cho ','Ren ','Ba ','Phac ','Duo ','Duo ','Dao ','Li ','Qiu ','Co ','Jiu ','Bi ','Xiu ','Ting ','Ci ',
        'Sha ','Eburi ','Za ','Quan ','Then ','Vu ','Con ','Wu ','Cha ','Shan ','Xun ','Fan ','Wu ','Zi ','Li ','Xing ',
        'Cai ','Cun ','Ren ','Shao ','Tuo ','Di ','Zhang ','Mang ','Chi ','Yi ','Gu ','Gong ','Du ','Yi ','Qi ','Thut ',
        'Gang ','Tiao ','Moku ','Son ','Tochi ','Lai ','Sugi ','Mang ','Yang ','Ma ','Miao ','Si ','Yuan ','Hang ','Fei ','Bei ',
        'Jie ','Hoc ','Gao ','Yao ','Xian ','Chu ','Chun ','Pa ','Shu ','Hua ','Tam ','Chou ','Zhu ','Chou ','Tung ','Ban ',
        'Song ','Ji ','Yue ','Jin ','Gou ','Ji ','Mao ','Pi ','Bi ','Wang ','Ang ','Fang ','Fen ','Yi ','Fu ','Nan ',
        'Xi ','Hu ','Ya ','Dou ','Xun ','Zhen ','Yao ','Lam ','Rui ','E ','Mai ','Zhao ','Guo ','Chi ','Cong ','Yun ',
        'Waku ','Dou ','Shu ','Zao ','','Li ','Ro ','Jian ','Cheng ','Shou ','Qiang ','Feng ','Nan ','Xiao ','Sim ','Ku ',
        'Ping ','Yi ','Xi ','Zhi ','Guai ','Xiao ','Jia ','Da ','Cu ','Fu ','Mo ','Yi ','Ye ','Ye ','Shi ','Nie ',
        'Bi ','Xa ','Yi ','Ranh ','Bing ','Ni ','La ','He ','Pan ','Muop ','Zhong ','Dai ','Ci ','Yang ','Fu ','Bai ',
        'Mou ','Gan ','Qi ','Nhuom ','Nhu ','Mao ','Zhao ','Song ','Zhe ','Xia ','Dau ','Shen ','Gui ','Tuo ','Zuo ','Nan ',
        'Ning ','Yong ','Di ','Zhi ','Zha ','Tra ','Dan ','Gu ','','Jiu ','Ao ','Fu ','Jian ','Bo ','Duo ','Ke ',
        'Nai ','Tru ','Bi ','Liu ','Sai ','Zha ','Si ','Zhu ','Pei ','Shi ','Guai ','Cha ','Yao ','Jue ','Jiu ','Shi ',
        ],
    'x68':[
        'Zhi ','Liu ','Mei ','Tochi ','Rong ','Zha ','','Biao ','Zhan ','Jie ','Long ','Dong ','Lu ','Sanh ','Li ','Lan ',
        'Vanh ','Shu ','Xun ','Thoen ','Qi ','Zhen ','Qi ','Li ','Yi ','Xiang ','Zhen ','Li ','Su ','Gua ','Kan ','Bing ',
        'Ren ','Xiao ','Bo ','Ren ','Bing ','Zi ','Chou ','Yi ','Jie ','Xu ','Zhu ','Jian ','Zui ','Er ','Er ','You ',
        'Fa ','Gong ','Kao ','Lao ','Zhan ','Li ','','Yang ','He ','Can ','Zhi ','Shi ','Ge ','Zai ','Luan ','Fu ',
        'Jie ','Hanh ','Gui ','Tao ','Quang ','Wei ','Kuang ','Ru ','An ','An ','Juan ','Yi ','Zhuo ','Ku ','Chuoi ','Qiong ',
        'Tong ','Tang ','Sang ','Huan ','Jie ','Jiu ','Xue ','Duo ','Zhui ','Yu ','Zan ','Kasei ','Ying ','Masu ','','Zhan ',
        'Ya ','Nao ','Zhen ','Dang ','Qi ','Qiao ','Hua ','Kuai ','Jiang ','Zhuang ','Xun ','Suo ','Sha ','Zhen ','Bei ','Ting ',
        'Gua ','Jing ','Vut ','Ben ','Fu ','Rui ','Thung ','Jue ','Xi ','Lang ','Liu ','Feng ','Qi ','Wen ','Jun ','Gan ',
        'Cu ','Luong ','Qiu ','Ting ','You ','Mai ','Buong ','Long ','Peng ','Zhuang ','Di ','Xuan ','Tu ','Zao ','Ao ','Gu ',
        'Bi ','Di ','Han ','Zi ','Zhi ','Ren ','Voi ','Geng ','Jian ','Huan ','Wan ','Nuo ','Jia ','Tiao ','Ji ','Xiao ',
        'Lu ','Hun ','Shao ','Cen ','Fen ','Song ','Meng ','Wu ','Li ','Li ','Dou ','Cen ','Ying ','Thoi ','Coc ','Ti ',
        'Gioi ','Kun ','Zhuo ','So ','Chan ','Fan ','Wei ','Jing ','Li ','Bing ','Fumoto ','Shikimi ','Tao ','Zhi ','Lai ','Lian ',
        'Jian ','Zhuo ','Ranh ','Li ','Qi ','Bing ','Zhun ','Cong ','Qian ','Mian ','Qi ','Qi ','Cai ','Gun ','Chan ','Te ',
        'Fei ','Pai ','Bang ','Pou ','Hun ','Zong ','Cheng ','Zao ','Gac ','Li ','Peng ','Yu ','Yu ','Gu ','Hun ','Nham ',
        'Tang ','Gang ','Wang ','Di ','Xi ','Fan ','Ranh ','Zhan ','Qi ','Yuan ','Yan ','Yu ','Quan ','Yi ','Chum ','Ren ',
        'Chui ','Sang ','Qi ','Zhuo ','Fu ','Ke ','Lai ','Zou ','Zou ','Zhuo ','Quan ','Fen ','Fen ','Chen ','Qiong ','Nie ',
        ],
    'x69':[
        'Wan ','Guo ','Lu ','Hao ','Jie ','Yi ','Chou ','Gu ','Ju ','Cheng ','Chot ','Liang ','Qiang ','Zhi ','Zhui ','Ya ',
        'Ju ','Bei ','Jiao ','Zhuo ','Zi ','Bin ','Peng ','Ding ','Chu ','Sugi ','Mun ','Momiji ','Jian ','Gui ','Xi ','Du ',
        'Qian ','Kunugi ','Kai ','Shide ','Luo ','Tre ','Ken ','Myeng ','Tafu ','','Peng ','Zhan ','','Tuo ','Sen ','Duo ',
        'Da ','Fou ','Wei ','Wei ','Duan ','Jia ','Zong ','Jian ','Yi ','Shen ','Xi ','Yan ','Yan ','Chuan ','Zhan ','Chun ',
        'Yu ','He ','Zha ','Wo ','Pian ','Bi ','Yao ','Huo ','Xu ','Ruo ','Duong ','La ','Yan ','Ben ','Hun ','Kui ',
        'Jie ','Kui ','Si ','Phong ','Xie ','Tuo ','Zhi ','Jian ','Mu ','Mao ','Chu ','Hu ','Hu ','Lian ','Leng ','Ting ',
        'Nan ','Yu ','Giua ','Me ','Song ','Xuan ','Xuan ','Ying ','Zhen ','Pian ','Ye ','Ji ','Jie ','Ye ','Chu ','Shun ',
        'Yu ','Cou ','Wei ','Mei ','Di ','Ji ','Jie ','Kai ','Qiu ','Ying ','Rou ','Heng ','Lou ','Le ','Hazou ','Katsura ',
        'Pin ','Muro ','Gai ','Tan ','Lan ','Yun ','Yu ','Chen ','Lu ','Ju ','Sakaki ','','Pi ','Xie ','Jia ','Yi ',
        'Zhan ','Fu ','Nai ','Mi ','Lang ','Rong ','Keo ','Jian ','Ju ','Ta ','Yao ','Zhen ','Bang ','Sha ','Yuan ','Zi ',
        'Ming ','Su ','Jia ','Yao ','Jie ','Huang ','Gan ','Fei ','Zha ','Qian ','Ma ','Sun ','Yuan ','Xie ','Vinh ','Shi ',
        'Zhi ','Cui ','Yun ','Ting ','Liu ','Rong ','Tang ','Que ','Zhai ','Si ','Sheng ','Ta ','Ke ','Xi ','Cot ','Qi ',
        'Kao ','Cau ','Sun ','Ban ','Tao ','Ge ','Xun ','Dian ','Noc ','Ji ','Shuo ','Gou ','Dui ','Thuong ','Xay ','Qian ',
        'Huai ','Mei ','Suc ','Gang ','Cau ','Zhuo ','Tuo ','Kyou ','Yang ','Dian ','Jia ','Jian ','Zui ','Tou ','Rou ','Bin ',
        'Zhu ','','Xi ','Qi ','Lian ','Hui ','Yong ','Qian ','Guo ','Gai ','Gai ','Tuan ','Hua ','Cu ','Sen ','Cui ',
        'Beng ','You ','Hu ','Jiang ','Hu ','Huan ','Guoc ','Yi ','Nie ','Gao ','Kang ','Gui ','Gui ','Tau ','Man ','Jin ',
        ],
    'x6a':[
        'Di ','Thung ','Le ','Lang ','Chen ','Cong ','Li ','Xiu ','Qing ','Shuang ','Phan ','Tong ','Guan ','Ji ','Suo ','Lei ',
        'Lu ','Liang ','Mi ','Lou ','Sao ','Su ','Ke ','Vu ','Tang ','Biao ','Lu ','Jiu ','Shu ','Zha ','Xu ','Zhang ',
        'Men ','Mo ','Niao ','Yang ','Tiao ','Peng ','Zhu ','Sha ','Xi ','Quan ','Heng ','Jian ','Cong ','','Hokuso ','Qiang ',
        'Tara ','Ying ','Er ','Xin ','Zhi ','Qiao ','Chuoi ','Cong ','Pu ','Thu ','Hua ','Kui ','Zhen ','Zun ','Yue ','Zhan ',
        'Xi ','Xun ','Dian ','Fa ','Gan ','Mo ','Wu ','Qiao ','Nao ','Sang ','Liu ','Qiao ','Xian ','Run ','Fan ','Zhan ',
        'Tuo ','Lao ','Yun ','Shun ','Tui ','Cheng ','Tang ','Meng ','Quat ','Chanh ','Su ','Cot ','Jue ','Tan ','Hui ','Co ',
        'Nuo ','Xiang ','Tuo ','Ning ','Rui ','Zhu ','Chuang ','Zeng ','Fen ','Qiong ','Ran ','Heng ','Tram ','Gu ','Liu ','Rao ',
        'Gao ','Chu ','Zusa ','Nude ','Ca ','San ','Ji ','Dau ','Shou ','Lu ','Gian ','','Yuan ','Thot ','Shu ','Jiang ',
        'Tan ','Day ','Nong ','Yin ','Xi ','Sui ','Shan ','Zui ','Xuan ','Cheng ','Gan ','Ju ','Zui ','Yi ','Qin ','Pu ',
        'Yan ','Rui ','Feng ','Hui ','Dang ','Ji ','Sui ','Bo ','Bi ','Ding ','Chu ','Zhua ','Coi ','Ji ','Jie ','Jia ',
        'Qing ','Zhe ','Ghem ','Qiang ','Dao ','Yi ','Biao ','Song ','She ','Lin ','Reki ','Cha ','Meng ','Yin ','Tao ','Tai ',
        'Mian ','Qi ','','Bin ','Huo ','Ji ','Qian ','Mi ','Ning ','Yi ','Cao ','Jian ','Yin ','Er ','Qing ','Yan ',
        'Qi ','Mi ','Zhao ','Gui ','Chun ','Ji ','Kui ','Po ','Deng ','Chu ','Han ','Mian ','You ','Zhi ','Guang ','Qian ',
        'Lei ','Lei ','Sa ','Lu ','Li ','Cuan ','Lu ','Mie ','Hui ','Ou ','Lu ','Jie ','Gao ','Du ','Yuan ','Li ',
        'Fei ','Zhuo ','Sou ','Lian ','Sen ','Chu ','','Zhu ','Lu ','Yan ','Li ','Zhu ','Chen ','Jie ','E ','Su ',
        'Huai ','Nie ','Yu ','Long ','Lai ','','Xian ','Kwi ','Ju ','Xiao ','Ling ','Ying ','Jian ','Yin ','You ','Ying ',
        ],
    'x6b':[
        'Xiang ','Nong ','Bo ','Chan ','Lan ','Ju ','Shuang ','She ','Wei ','Cong ','Quan ','Qu ','Cang ','','Yu ','Luo ',
        'Li ','Zan ','Luan ','Dang ','Jue ','Em ','Lan ','Lan ','Zhu ','Lei ','Li ','Ba ','Nang ','Yu ','Ling ','Tsuki ',
        'Qian ','Ci ','Huan ','Han ','Yu ','Yu ','Qian ','Ou ','Xu ','Chao ','Chu ','Chi ','Kai ','Yi ','Jue ','Xi ',
        'Xu ','Xia ','Duc ','Kuai ','Lang ','Kuan ','Shuo ','Xi ','Ai ','Yi ','Khi ','Xu ','Chi ','Kham ','Kuan ','Kan ',
        'Kuan ','Kan ','Chuan ','Sha ','','Yin ','Can ','Xie ','Yu ','Qian ','Xiao ','Yi ','Ca ','Wu ','Tan ','Jin ',
        'Ou ','Hu ','Ti ','Huan ','Xu ','Pen ','Xi ','Xiao ','Xu ','Xi ','Sen ','Han ','Chu ','Yi ','Kan ','Ru ',
        'Chuo ','Hoan ','Zhi ','Zheng ','Thu ','Bo ','Wu ','Qi ','Bu ','Bu ','Quay ','Ju ','Qian ','Chi ','Se ','Chi ',
        'Se ','Zhong ','Sui ','Sui ','Li ','Cuo ','Yu ','Li ','Gui ','Dai ','Dai ','Phoi ','Jian ','Zhe ','Mo ','Mo ',
        'Yao ','Mo ','Cu ','Trua ','Tian ','Sheng ','Dai ','Shang ','Xu ','Xun ','Thua ','Can ','Jue ','Piao ','Qia ','Qiu ',
        'Su ','Qing ','Yun ','Lian ','Yi ','Fou ','Zhi ','Ye ','Can ','Hun ','Dan ','Ji ','Ye ','','Yun ','Wen ',
        'Chou ','Bin ','Ti ','Jin ','Shang ','Yin ','Diao ','Cu ','Hui ','Cuan ','Yi ','Dan ','Du ','Jiang ','Lian ','Tan ',
        'Du ','Sen ','Jian ','Shu ','Ou ','Duan ','Zhu ','Yin ','Qing ','Yi ','Sha ','Que ','Ke ','Yao ','Jun ','Dian ',
        'Hui ','Hui ','Gu ','Que ','Ji ','Yi ','Ou ','Hui ','Duan ','Yi ','Xiao ','Wu ','Guan ','Mu ','Mei ','Mei ',
        'Ai ','Zuo ','Du ','Yu ','Bi ','Bi ','Bi ','Pi ','Pi ','Bi ','Chan ','Mao ','','','Pu ','Mushiru ',
        'Jia ','Zhan ','Sai ','Mu ','Tuo ','Xun ','Er ','Rong ','Xian ','Ju ','Mu ','Hao ','Qiu ','Dou ','Mushiru ','Tan ',
        'Pei ','Ju ','Duo ','Cui ','Bi ','San ','','Mao ','Sui ','Shu ','Yu ','Tuo ','He ','Jian ','Ta ','San ',
        ],
    'x6c':[
        'Lu ','Mu ','Li ','Tong ','Rong ','Chang ','Pu ','Luo ','Chen ','Sao ','Zhan ','Meng ','Luo ','Qu ','Die ','Shi ',
        'Di ','Dan ','Jue ','Manh ','Qi ','Pie ','Nai ','Qi ','Dao ','Xian ','Chuan ','Fen ','Ri ','Nei ','','Fu ',
        'Shen ','Dong ','Qing ','Qi ','Yin ','Xi ','Hai ','Yang ','An ','Ya ','Ke ','Qing ','Ya ','Dong ','Dan ','Lu ',
        'Qing ','Yang ','Yun ','Yun ','Heo ','Sanzui ','Zheng ','Bing ','Vang ','Dang ','Sui ','Le ','Ni ','Tun ','Fan ','Gui ',
        'Ting ','Chap ','Qiu ','Bin ','Ze ','Mian ','Cuan ','Hui ','Diao ','Yi ','Xoa ','Zhuo ','Chuan ','Wan ','Fan ','Dai ',
        'Xi ','Tuo ','Mang ','Qiu ','Qi ','Khung ','Pai ','Han ','Qian ','Wu ','Wu ','Vam ','Si ','Nho ','Gong ','Giang ',
        'Chi ','Wu ','Tsuchi ','','Tang ','Zhi ','Chi ','Qian ','Mi ','Gu ','Wang ','Qing ','Jing ','Rui ','Jun ','Hong ',
        'Tai ','Quan ','Cum ','Bian ','Bian ','Ngam ','Wen ','Zhong ','Fang ','Xiong ','Jue ','Hang ','','Qi ','Fen ','Do ',
        'Xu ','Tam ','Yi ','Wo ','Yun ','Yuan ','Hang ','Yan ','Chen ','Chen ','Dan ','You ','Xon ','Hu ','Huo ','Qi ',
        'Muc ','Rou ','Mo ','Ta ','Mian ','Vat ','Khem ','Tian ','Bi ','Vanh ','Zhi ','Pei ','Pan ','Zhui ','Za ','Gou ',
        'Liu ','Mei ','Ze ','Feng ','Ou ','Li ','Lun ','Cang ','Feng ','Wei ','Hu ','Mo ','Mei ','Shu ','Ju ','Zan ',
        'Tuo ','Sang ','Tuo ','Ha ','Li ','Mi ','Yi ','Fa ','Fei ','You ','Tian ','Zhi ','Zhao ','Gu ','Cham ','Yan ',
        'Si ','Kuang ','Jiong ','Ju ','Tuot ','Tu ','Yi ','Jia ','Zhong ','Quan ','Bo ','Hui ','Mi ','Ben ','Zhuo ','Chu ',
        'Le ','Ao ','Gu ','Hong ','Gan ','Fa ','Mao ','Si ','Hu ','Ping ','Ci ','Fan ','Chi ','Su ','Ning ','Cheng ',
        'Ling ','Bau ','Ba ','Khap ','Si ','Ni ','Ju ','Yue ','Chu ','Sheng ','Thot ','Xuan ','Xue ','Fu ','Pan ','Min ',
        'Tai ','Yang ','Ji ','Yong ','Guan ','Beng ','Xue ','Long ','Lu ','','Bo ','Xie ','Po ','Ze ','Jing ','Yin ',
        ],
    'x6d':[
        'Zhou ','Ji ','Yi ','Hui ','Hui ','Tuoi ','Cheng ','Yin ','Wei ','Hou ','Jian ','Duong ','Ret ','Si ','Ji ','Er ',
        'Xing ','Fu ','Sa ','Suo ','Zhi ','Yin ','Wu ','Xi ','Kao ','Chua ','Jiang ','Luo ','','An ','Dong ','Yi ',
        'Mou ','Gioi ','Yi ','Mi ','Quan ','Jin ','Mo ','Wei ','Xiao ','Xie ','Hong ','Xu ','Shuo ','Kuang ','Tao ','Qie ',
        'Ju ','Er ','Zhou ','Nho ','Ping ','Xun ','Xiong ','Zhi ','Guang ','Huan ','Ming ','Huo ','Wa ','Qia ','Pai ','Wu ',
        'Qu ','Luu ','Yi ','Jia ','Jing ','Qian ','Jiang ','Jiao ','Cheng ','Shi ','Zhuo ','Ce ','Pal ','Kuai ','Ji ','Liu ',
        'Chan ','Hun ','Hu ','Nong ','Xun ','Jin ','Lie ','Gau ','Wei ','Zhe ','Jun ','Han ','Bang ','Mang ','Zhuo ','You ',
        'Ho ','Bot ','Dou ','Wan ','Hong ','Yi ','Pu ','Ying ','Lan ','Hao ','Lang ','Han ','Li ','Geng ','Phu ','Wu ',
        'Lian ','Chun ','Feng ','Yi ','Yu ','Tong ','Lao ','Hai ','Tam ','Jia ','Chong ','Weng ','Mei ','Sui ','Cheng ','Pei ',
        'Xian ','Shen ','Do ','Kun ','Pin ','Nie ','Han ','Kinh ','Xiao ','She ','Nian ','Tu ','Yong ','Xiao ','Xian ','Ting ',
        'E ','Su ','Tun ','Quen ','Cen ','Ti ','Rang ','Shui ','Si ','Lei ','Shui ','Tao ','Du ','Lao ','Thui ','Lian ',
        'Wei ','Wo ','Yun ','Huan ','Di ','','Run ','Jian ','Zhang ','Se ','Fu ','Guan ','Xing ','Shou ','Shuan ','Ya ',
        'Chuo ','Zhang ','Ye ','Kong ','Wo ','Han ','Tuo ','Dong ','He ','Wo ','Ju ','Gan ','Luong ','Hun ','Ta ','Zhuo ',
        'Dian ','Qie ','De ','Juan ','Zi ','Xi ','Yao ','Qi ','Gu ','Guo ','Han ','Lam ','Tang ','Zhou ','Peng ','Hao ',
        'Chang ','Shu ','Qi ','Fang ','Chi ','Lu ','Nao ','Ju ','Tao ','Cong ','Lei ','Zhi ','Peng ','Fei ','Song ','Tian ',
        'Pi ','Dan ','Yu ','Ni ','Yu ','Lu ','Gan ','Mi ','Jing ','Lang ','Lun ','Dam ','Cui ','Qu ','Hoai ','Roc ',
        'Nian ','Tham ','Piao ','Choang ','Wa ','Yuan ','Lai ','Hun ','Qing ','Yan ','Qian ','Tian ','Miao ','Zhi ','Yin ','Mi ',
        ],
    'x6e':[
        'Ben ','Yuan ','Wen ','Nuoc ','Fei ','Thanh ','Yuan ','Ke ','Ji ','She ','Yuan ','Juu ','Lu ','Zi ','Du ','',
        'Jian ','Min ','Pi ','Kei ','Yu ','Yuan ','Shen ','Shen ','Rou ','Huan ','Zhu ','Jian ','Nuan ','Yu ','Qiu ','Ting ',
        'Qu ','Du ','Feng ','Zha ','Bot ','Wo ','Wo ','Di ','Wei ','Wen ','Ru ','Xie ','Trac ','Ngan ','Ge ','Gang ',
        'Yan ','Hong ','Xuan ','Mi ','Ke ','Mao ','Ying ','Yan ','You ','Hong ','Miao ','Xing ','Mei ','Zai ','Hun ','Nai ',
        'Kui ','Shi ','E ','Pai ','Mua ','Lian ','Qi ','Qi ','Mei ','Tian ','Cou ','Wei ','Can ','Tuan ','Mian ','Hui ',
        'Mo ','Xu ','Ji ','Bun ','Jian ','Jian ','Hu ','Feng ','Tuong ','Yi ','Yin ','Zhan ','Shi ','Jie ','Cheng ','Huang ',
        'Tan ','Yu ','Bi ','Min ','Shi ','Dot ','Sheng ','Rung ','Xo ','Zhong ','','Jiao ','Jiao ','qiu ','Yin ','Thang ',
        'Long ','Huo ','Yuan ','Nuom ','Ban ','You ','Quan ','Chui ','Liang ','Chan ','Yan ','Chun ','Nie ','Zi ','Wan ','Shi ',
        'Man ','Ying ','Ratsu ','Kui ','','Jian ','Xu ','Lu ','Gui ','Gai ','','','Po ','Jin ','Gui ','Tang ',
        'Yuan ','Suo ','Yuan ','Lian ','Yao ','Trung ','Zhun ','Sheng ','Hup ','Tai ','Da ','Wa ','Liu ','Gou ','Sao ','Ming ',
        'Zha ','Shi ','Yi ','Lun ','Ma ','Pu ','Wei ','Rot ','Cai ','Wu ','Khe ','Wen ','Qiang ','Ze ','Shi ','Su ',
        'Yi ','Zhen ','Sou ','Yun ','Xiu ','Yin ','Rong ','Hun ','Su ','Su ','Ni ','Ta ','Shi ','Ru ','Wei ','Pan ',
        'Soc ','Chu ','Pang ','Weng ','Cang ','Mie ','He ','Chan ','Hao ','Huang ','Xi ','Zi ','Di ','Zhi ','Xing ','Fu ',
        'Jie ','Got ','Ge ','Zi ','Thao ','Teng ','Sui ','Bi ','Jiao ','Hui ','Gun ','Yin ','Gao ','Long ','Zhi ','Yan ',
        'She ','Man ','Ying ','Chun ','Lu ','Lan ','Luan ','','Bin ','Tan ','Yu ','Sou ','Hu ','Bi ','Biao ','Zhi ',
        'Jiang ','Kou ','Ruom ','Shang ','Di ','Mi ','Ao ','Lu ','Hu ','Hu ','You ','Chan ','Fan ','Yong ','Gun ','Man ',
        ],
    'x6f':[
        'Qing ','Ngu ','Piao ','Ji ','Ya ','Jiao ','Qi ','Xi ','Ji ','Loc ','Sau ','Long ','Jin ','Guo ','Cong ','Lou ',
        'Zhi ','Ngay ','Qiang ','Li ','Yan ','Cao ','Jiao ','Cong ','Chun ','Tuan ','Ou ','Teng ','Ye ','Xi ','Mi ','Tang ',
        'Mo ','Shang ','Han ','Lan ','Lan ','Wa ','Li ','Qian ','Vung ','Xuan ','Yi ','Man ','Zi ','Mang ','Kang ','Ta ',
        'Peng ','Shu ','Truong ','Zhang ','Chong ','Xu ','Huan ','Kuo ','Jian ','Yan ','Chuang ','Liao ','Cui ','Ti ','Yang ','Jiang ',
        'Cong ','Ying ','Hong ','Xun ','Shu ','Guan ','Ying ','Xiao ','','','Xu ','Lian ','Zhi ','Wei ','Pi ','Jue ',
        'Jiao ','Po ','Dang ','Hui ','Jie ','Wu ','Pa ','Ji ','Pan ','Voi ','Xiao ','Qian ','Qian ','Xi ','Lu ','Xi ',
        'Lun ','Dun ','Huang ','Min ','Run ','Su ','Lao ','Zhen ','Zhong ','Yi ','Di ','Wan ','Dan ','Tan ','Chao ','Xun ',
        'Kui ','','Shao ','Tu ','Zhu ','San ','Hei ','Vuot ','Shan ','Chan ','Chan ','Shu ','Tong ','Pu ','Lin ','Wei ',
        'Se ','Se ','Cheng ','Jiong ','Cheng ','Hua ','Khu ','Lao ','Che ','Gan ','Cun ','Heng ','Si ','Shu ','Peng ','Han ',
        'Yun ','Liu ','Hong ','Fu ','Hao ','He ','Xian ','Jian ','Shan ','Xi ','Iku ','','Lan ','','Yu ','Lin ',
        'Mian ','Zao ','Dang ','Huan ','Ze ','Xie ','Yu ','Li ','Shi ','Xue ','Ling ','Man ','Zi ','Yong ','Goi ','Can ',
        'Lian ','Dian ','Ye ','Ao ','Huan ','Zhen ','Chan ','Man ','Dan ','Dan ','Yi ','Sui ','Pi ','Ju ','Ta ','Qin ',
        'Ji ','Troc ','Lian ','Nong ','Guo ','Jin ','Fen ','Se ','Xap ','Sui ','Hui ','Chu ','Ta ','Song ','Ding ','',
        'Zhu ','Lai ','Bin ','Lian ','Mi ','Shi ','Shu ','Mi ','Ning ','Ying ','Ying ','Meng ','Jin ','Qi ','Tia ','Ji ',
        'Hao ','Nhua ','Zui ','Wo ','Tao ','Yin ','Yin ','Dui ','Ci ','Huo ','Jing ','Lan ','Jun ','Ai ','Pu ','Zhuo ',
        'Wei ','Bin ','Gu ','Qian ','Xing ','Ban ','Kuo ','Fei ','','Boku ','Jian ','Wei ','Luo ','Zan ','Lu ','Li ',
        ],
    'x70':[
        'You ','Yang ','Lu ','Si ','Jie ','Ying ','Du ','Wang ','Hui ','Xie ','Pan ','Shen ','Biao ','Chan ','Mo ','Liu ',
        'Tuom ','Pu ','Se ','Cheng ','Gu ','Bin ','Huo ','Xian ','Lu ','Qin ','Han ','Ying ','Yong ','Li ','Jing ','Xiao ',
        'Ying ','Sui ','Wei ','Xie ','Huai ','Hao ','Zhu ','Long ','Lai ','Dui ','Fan ','Hu ','Lai ','','','Ying ',
        'Mi ','Ji ','Lian ','Jian ','Ying ','Fen ','Lin ','Yi ','Jian ','Yue ','Chan ','Dai ','Rang ','Jian ','Nham ','Fan ',
        'Shuang ','Yuan ','Zhuo ','Feng ','She ','Lei ','Lan ','Cong ','Qu ','Yong ','Qian ','Fa ','Guan ','Que ','Yan ','Hao ',
        'Hyeng ','Ngo ','Zan ','Luan ','Yan ','Li ','Mi ','Shan ','Tan ','Dang ','Jiao ','Chan ','','Hao ','Ba ','Luoc ',
        'Lan ','Lan ','Nang ','Wan ','Luan ','Xun ','Xian ','Yan ','Gan ','Yan ','Yu ','Huo ','Biao ','Mie ','Guang ','Deng ',
        'Hui ','Xiao ','Xiao ','','Hong ','Linh ','Zao ','Zhuan ','Jiu ','Zha ','Xie ','Chi ','Chuoc ','Tai ','Tai ','Can ',
        'Yang ','Qi ','Zhong ','Fen ','Niu ','Jiong ','Wen ','Po ','Yi ','Lu ','Chui ','Pi ','Kai ','Pan ','Yan ','Kai ',
        'Pang ','Mu ','Sao ','Liao ','Gui ','Kang ','Tun ','Guang ','Xin ','Zhi ','Kwang ','Guang ','Wei ','Qiang ','','Da ',
        'Xia ','Zheng ','Zhu ','Ke ','Zhao ','Phut ','Ba ','Duo ','Duo ','Ling ','Zhuo ','Xuan ','Ju ','Than ','Pao ','Jiong ',
        'Pao ','Tai ','Tai ','Bing ','Yang ','Tong ','Han ','Zhu ','Zha ','Dian ','Wei ','Shi ','Lian ','Chi ','Huang ','',
        'Hu ','Shuo ','Lan ','Jing ','Jiao ','Xu ','Xing ','Quan ','Lie ','Huan ','Rang ','Xiao ','Xiu ','Xian ','Yin ','Wu ',
        'Zhou ','Yao ','Shi ','Wei ','Tong ','Xue ','Zai ','Kai ','Hong ','Luo ','Xia ','Chuc ','Xuan ','Chung ','Po ','Yan ',
        'Hui ','Guang ','Zhe ','Tro ','Kao ','','Fan ','Shao ','Ye ','Hui ','','Tang ','Jin ','Re ','','Xi ',
        'Fu ','Jiong ','Che ','Pu ','Jing ','Zhuo ','Ting ','Wan ','Hai ','Phanh ','Lang ','Shan ','Hu ','Feng ','Chi ','Rong ',
        ],
    'x71':[
        'Hu ','','Shu ','He ','Xun ','Ku ','Jue ','Xiao ','Xi ','Yan ','Han ','Zhuang ','Jun ','Di ','Xie ','Ji ',
        'Wu ','','Lua ','Han ','Yan ','Huan ','Men ','Ju ','Chou ','Vui ','Fen ','Lin ','Kun ','Hun ','Hung ','Xi ',
        'Sot ','Wu ','Hong ','Ju ','Fu ','Wo ','Jiao ','Cong ','Feng ','Ping ','Qiong ','Ruo ','Xi ','Qiong ','Xin ','Zhuo ',
        'Yan ','Yan ','Yi ','Jue ','Yu ','Gang ','Ran ','Pi ','Gu ','','Sheng ','Chang ','Shao ','','Nam ','Geng ',
        'Wat ','Chen ','He ','Kui ','Zhong ','Duan ','Xia ','Hui ','Feng ','Lian ','Xuan ','Xing ','Huang ','Jiao ','Jian ','Bi ',
        'Ying ','Zhu ','Wei ','Tuan ','Tian ','Xi ','Nuan ','Nuan ','Chan ','Yan ','Jiong ','Jiong ','Yu ','Mei ','Sha ','Wei ',
        'Ye ','Xin ','Qiong ','Rou ','Mei ','Huan ','Xu ','Zhao ','Oi ','Fan ','Qiu ','Sui ','Yang ','Lie ','Zhu ','',
        'Gao ','Gua ','Bao ','Hu ','Yun ','Xia ','','','Bian ','Gou ','Tui ','Tang ','Chao ','Shan ','En ','Bo ',
        'Huang ','Xie ','Xi ','Wu ','Tat ','Yun ','He ','He ','Xi ','Yun ','Hung ','Nai ','Shan ','','Yao ','Xun ',
        'Mi ','Lian ','Ying ','Wu ','Rong ','Kou ','En ','Qiang ','Liu ','Hay ','Bi ','Biao ','Zong ','Lu ','Jian ','Thuc ',
        'Yi ','Lou ','Feng ','Thui ','Yi ','Tong ','Jue ','Zong ','Yun ','Hu ','Yi ','Zhi ','Ao ','Wei ','Liao ','Han ',
        'Ou ','Re ','Jiong ','Man ','','Shang ','Cuan ','Tung ','Jian ','Xi ','Xi ','Xi ','Yi ','Xiao ','Xe ','Huang ',
        'Chan ','Ye ','Qian ','Nhen ','Yan ','Xian ','Qiao ','Zun ','Deng ','Dun ','Shen ','Jiao ','Fen ','Si ','Liao ','Yu ',
        'Lan ','Tong ','Shao ','Fen ','Fan ','Yan ','Xun ','Lan ','Mei ','Tang ','Yi ','Jing ','Men ','','','Ying ',
        'Yu ','Yi ','Xue ','Lan ','Tai ','Zao ','Can ','Sui ','Xi ','Que ','Cong ','Lian ','Hui ','Zhu ','Xie ','Ling ',
        'Wei ','Yi ','Xie ','Zhao ','Hui ','Tatsu ','Nung ','Lan ','Ru ','Xian ','Kao ','Hun ','Jin ','Chou ','Dao ','Yao ',
        ],
    'x72':[
        'He ','Lan ','Biao ','Rong ','Li ','Mo ','Bao ','Ruo ','Lu ','Dop ','Ao ','Xun ','Kuang ','Shuo ','','Li ',
        'Chua ','Jue ','Liao ','Yan ','Xi ','Xie ','Long ','Ye ','','Rang ','Yue ','Lan ','Cong ','Jue ','Tong ','Guan ',
        '','Che ','Mi ','Tang ','Lan ','Zhu ','Laam ','Ling ','Cuan ','Yu ','Zhua ','Lam ','Pa ','Tranh ','Pao ','Cheng ',
        'Vuon ','Ai ','Vay ','','Jue ','Tuoc ','Fu ','Ye ','Ba ','Die ','Ye ','Yao ','Zu ','Sung ','Er ','Qiang ',
        'Chuang ','Ge ','Zang ','Die ','Qiang ','Yong ','Teo ','Pian ','Ban ','Pan ','Shao ','Jian ','Bai ','Du ','Chuang ','Tou ',
        'Zha ','Bian ','Die ','Bang ','Bo ','Chuang ','You ','','Du ','Nha ','Cheng ','Nguu ','Ushihen ','Pin ','Jiu ','Mou ',
        'Tuo ','Mu ','Lao ','Ren ','Mang ','Fang ','Mao ','Mu ','Gang ','Wu ','Yan ','Ge ','Bei ','Si ','Jian ','Gu ',
        'You ','Ge ','Sinh ','Mu ','Di ','Qian ','Quan ','Quan ','Zi ','Te ','Xi ','Mang ','Keng ','Qian ','Wu ','Gu ',
        'Xi ','Li ','Li ','Pou ','Ji ','Gang ','Zhi ','Ben ','Quan ','Run ','Du ','Ju ','Jia ','Jian ','Feng ','Pian ',
        'Ke ','Ju ','Kao ','Chu ','Xi ','Bei ','Luo ','Jie ','Ma ','San ','Wei ','Li ','Dun ','Tong ','','Jiang ',
        'Nghe ','Li ','Du ','Lie ','Pi ','Piao ','Bao ','Xi ','Chou ','Wei ','Kui ','Chou ','Quan ','Hyun ','Ba ','Fan ',
        'Qiu ','Ji ','Cai ','Chuo ','An ','Ge ','Zhuang ','Guang ','Ma ','You ','Kang ','Bo ','Hou ','Ya ','Yin ','Huan ',
        'Zhuang ','Yun ','Kuang ','Niu ','Di ','Qing ','Zhong ','Mu ','Bei ','Pi ','Ju ','Ni ','Sheng ','Pao ','Xia ','Tuo ',
        'Hu ','Ling ','Fei ','Pi ','Nai ','Ao ','You ','Gou ','Yue ','Ju ','Dan ','Po ','Gu ','Xian ','Ning ','Huan ',
        'Hen ','Jiao ','He ','Zhao ','Ji ','Xun ','Shan ','Ta ','Rong ','Shou ','Tong ','Lao ','Du ','Xia ','Shi ','Hua ',
        'Zheng ','Yu ','Sun ','Yu ','Bi ','Mang ','Xi ','Juan ','Li ','Xia ','Yin ','Suan ','Lang ','Bei ','Zhi ','Yan ',
        ],
    'x73':[
        'Sha ','Li ','Han ','Xian ','Jing ','Pai ','Fei ','Yao ','Ba ','Qi ','Ni ','Biao ','Yin ','Lai ','Xi ','Jian ',
        'Qiang ','Kun ','Yan ','Guo ','Zong ','Mi ','Chang ','Yi ','Zhi ','Zheng ','Ya ','Meng ','Cai ','Cu ','She ','Ryou ',
        'Cen ','Luo ','Hu ','Zong ','Ji ','Wei ','Feng ','Wo ','Yuan ','Xing ','Zhu ','Mao ','Wei ','Yuan ','Xian ','Tuan ',
        'Ya ','Nao ','Xie ','Jia ','Hou ','Bian ','You ','You ','Mei ','Zha ','Yao ','Sun ','Bo ','Ming ','Hua ','Yuan ',
        'Sou ','Ma ','Yuan ','Dai ','Yu ','Tep ','Hao ','','Yi ','Zhen ','Chuang ','Hao ','Man ','Jing ','Jiang ','Mu ',
        'Zhang ','Chan ','Ngao ','Ngao ','Hao ','Cui ','Fen ','Jue ','Bi ','Bi ','Huang ','Pu ','Lin ','Yu ','Tong ','Yao ',
        'Liao ','Shuo ','Xiao ','Juu ','Ton ','Xi ','Ge ','Juan ','Du ','Hui ','Kuai ','Xian ','Xie ','Ta ','Xian ','Xun ',
        'Nanh ','Pin ','Huo ','Nou ','Meng ','Lop ','Nao ','Guang ','Thu ','Lu ','Ta ','Xian ','Mi ','Rang ','Huan ','Nao ',
        'Luo ','Xian ','Qi ','Jue ','Xuan ','Miao ','Zi ','Lu ','Lu ','Ngoc ','Su ','Vuong ','Qiu ','Ga ','Ding ','Le ',
        'Ba ','Ji ','Hong ','Di ','Chuan ','Gan ','Jiu ','Yu ','Ji ','Yu ','Yang ','Ma ','Gong ','Wu ','Fu ','Min ',
        'Jie ','Nga ','Bin ','Bian ','Bang ','Yue ','Jue ','Yun ','Jue ','Wan ','Jian ','Mei ','Dan ','Pi ','Wei ','Huan ',
        'Xian ','Qiang ','Ling ','Ngan ','Yi ','An ','Ping ','Dian ','Fu ','Xuan ','Xi ','Bo ','Ci ','Gou ','Jia ','Shao ',
        'Po ','Ci ','Ke ','Ran ','Sheng ','Shen ','Yi ','Zu ','Jia ','Min ','San ','Liu ','Bi ','Tran ','Zhen ','Jue ',
        'Fa ','Long ','Jin ','Jiao ','Jian ','Li ','Guang ','Xian ','Zhou ','Gong ','Yan ','Xiu ','Yang ','Xu ','Luo ','Su ',
        'Chau ','Qin ','Ken ','Xun ','Bao ','Er ','Xiang ','Yao ','Xia ','Heng ','Gui ','Chong ','Xu ','Ban ','Pei ','',
        'Dang ','Ei ','Hun ','Wen ','E ','Cheng ','Di ','Wu ','Wu ','Cheng ','Jun ','Mei ','Bei ','Ting ','Xian ','Chuo ',
        ],
    'x74':[
        'Han ','Xuan ','Yan ','Qiu ','Quan ','Lang ','Li ','Xiu ','Fu ','Luu ','Ye ','Xi ','Ling ','Li ','Jin ','Lian ',
        'Suo ','Sa ','','Wan ','Dian ','Pin ','Zhan ','Cui ','Min ','Yu ','Ju ','Chen ','Trai ','Wen ','Sheng ','Wei ',
        'Dian ','Chu ','Zhuo ','Pei ','Cheng ','Hu ','Qi ','E ','Kun ','Chang ','Qi ','Beng ','Wan ','Lu ','Cong ','Guan ',
        'Yan ','Diao ','Bei ','Lin ','Qin ','Pi ','Ba ','Que ','Zhuo ','Qin ','Fa ','','Qiong ','Du ','Jie ','Hun ',
        'Yu ','Mao ','Mei ','Chun ','Xuan ','Ti ','Xing ','Dai ','Rou ','Min ','Zhen ','Wei ','Ruan ','Huan ','Jie ','Chuan ',
        'Jian ','Zhuan ','Yang ','Lian ','Quan ','Xia ','Duan ','Yuan ','Ye ','Nao ','Hu ','Ying ','Yu ','Huang ','Rui ','Sat ',
        'Liu ','','Rong ','Suo ','Rom ','Wen ','Wu ','Jin ','Jin ','Ying ','Ma ','Tao ','Liu ','Tang ','Li ','Lang ',
        'Gui ','Tian ','Qiang ','Cuo ','Jue ','Zhao ','Yao ','Ai ','Bin ','Tu ','Chang ','Kun ','Zhuan ','Cong ','Jin ','Yi ',
        'Cui ','Cong ','Qi ','Li ','Ying ','Suo ','Qiu ','Xuan ','Ao ','Lian ','Men ','Zhang ','Yin ','','Ying ','Zhi ',
        'Lu ','Wu ','Deng ','xiu ','Zeng ','Xun ','Qu ','Dang ','Lin ','Liao ','Qiong ','Su ','Huang ','Gui ','Pu ','Jing ',
        'Fan ','Jin ','Liu ','Ji ','','Jing ','Ai ','Bi ','Can ','Qu ','Zao ','Dang ','Jiao ','Gun ','Tan ','Hui ',
        'Huan ','Se ','Sui ','Tian ','','Yu ','Jin ','Lu ','Bin ','Shou ','Wen ','Zui ','Lan ','Xi ','Ji ','Xuan ',
        'Ruan ','Huo ','Gai ','Lei ','Du ','Li ','Zhi ','Rou ','Li ','Zan ','Qiong ','Zhe ','Gui ','Sui ','La ','Long ',
        'Lu ','Li ','Zan ','Lan ','Ying ','Mi ','Xiang ','Xi ','Guan ','Dao ','Zan ','Huan ','Qua ','Bo ','Die ','Bao ',
        'Hu ','Zhi ','Piao ','Ban ','Rang ','Li ','Wa ','Dekaguramu ','Jiang ','Cin ','Fan ','Pen ','Fang ','Dan ','Weng ','Ou ',
        'Deshiguramu ','Miriguramu ','Ton ','Hu ','Ling ','Yi ','Ping ','Ci ','Hekutogura ','Juan ','Chang ','Chi ','Sarake ','Dang ','Meng ','Pou ',
        ],
    'x75':[
        'Zhui ','Ping ','Bian ','Zhou ','Zhen ','Senchigura ','Ci ','Ying ','Qi ','Xian ','Lou ','Di ','Ou ','Manh ','Zhuan ','Peng ',
        'Lin ','Zeng ','Wu ','Pi ','Dan ','Weng ','Ying ','Yan ','Gan ','Dai ','Shen ','Tian ','Tian ','Han ','Chang ','Sinh ',
        'Qing ','Shen ','Chan ','Chan ','Rui ','Sheng ','Su ','Sen ','Dung ','Shuai ','Lu ','Fu ','Yong ','Beng ','Feng ','Ning ',
        'Tian ','Do ','Jia ','Shen ','Zha ','Dian ','Fu ','Nam ','Dian ','Ping ','Ting ','Hua ','Ting ','Quan ','Zi ','Meng ',
        'Bi ','Qi ','Liu ','Xun ','Liu ','Chang ','Mu ','Yun ','Fan ','Fu ','Geng ','Tian ','Gioi ','Jie ','Quan ','Wei ',
        'Fu ','Tian ','Mu ','Tap ','Pan ','Jiang ','Wa ','Da ','Nan ','Luu ','Ben ','Zhen ','Chu ','Mu ','Mu ','Ce ',
        'Hata ','Gai ','Bi ','Da ','Zhi ','Lue ','Qi ','Lue ','Pan ','Kesa ','Fan ','Hua ','Yu ','Yu ','Mu ','Jun ',
        'Yi ','Luu ','Yu ','Die ','Chou ','Hua ','Dang ','Chuo ','Ji ','Wan ','Cung ','Sheng ','Chang ','Tuan ','Lei ','Ji ',
        'Cha ','Liu ','Jou ','Tuan ','Lin ','Jiang ','Jiang ','Chou ','Bo ','Die ','Die ','Sat ','Nie ','Dan ','Shu ','So ',
        'Zhi ','Yi ','Chuang ','Nai ','Ding ','Bi ','Jie ','Liao ','Gang ','Ge ','Jiu ','Zhou ','Xia ','Shan ','Xu ','Nue ',
        'Li ','Yang ','Chen ','You ','Ba ','Jie ','Jue ','Zhi ','Xia ','Cui ','Bi ','Yi ','Li ','Zong ','Chuang ','Feng ',
        'Zhu ','Pao ','Pi ','Gan ','Ke ','Ci ','Xie ','Qi ','Dan ','Zhen ','Fa ','Zhi ','Teng ','Thu ','Ji ','Fei ',
        'Khu ','Dian ','Jia ','Xian ','Zha ','Bing ','Ni ','Zheng ','Yong ','Jing ','Quan ','Chong ','Tong ','Yi ','Kai ','Wei ',
        'Hui ','Duo ','Yang ','Chi ','Zhi ','Not ','Ya ','Mei ','Dou ','Jing ','Xiao ','Thong ','Tu ','Mang ','Pi ','Xiao ',
        'Suan ','Pu ','Li ','Zhi ','Cuo ','Duo ','Wu ','Sha ','Lao ','Shou ','Huan ','Xian ','Yi ','Peng ','Zhang ','Guan ',
        'Tan ','Fei ','Ma ','Lin ','Chi ','Ji ','Dian ','An ','Chi ','Bi ','Bi ','Min ','Gu ','Dui ','E ','Wei ',
        ],
    'x76':[
        'Yu ','Cui ','Ya ','Zhu ','Cu ','Dan ','Shen ','Zhong ','Ji ','Yu ','Hou ','Phong ','La ','Yang ','Shen ','Tu ',
        'Yu ','Gua ','Wen ','Huan ','Ku ','Jia ','Yin ','Yi ','Lu ','Sao ','Jue ','Chi ','Xi ','Guan ','Yi ','Wen ',
        'Ji ','Chuang ','Ban ','Lei ','Liu ','Chai ','Xau ','Nue ','Dian ','Da ','Pie ','Tan ','Zhang ','Biao ','Shen ','Cu ',
        'Luo ','Yi ','Zong ','Chou ','Chuong ','Zhai ','Sou ','Suo ','Que ','Diao ','Lou ','Lu ','Mo ','Jin ','Yin ','Ying ',
        'Huang ','Fu ','Liao ','Long ','Qiao ','Liu ','Lao ','Xian ','Fei ','Dan ','Yin ','He ','Ai ','Ban ','Xian ','Guan ',
        'Guai ','Nong ','Yu ','Wei ','Yi ','Yong ','Pi ','Lei ','Li ','Shu ','Dan ','Lin ','Dian ','Lin ','Lai ','Bie ',
        'Ji ','Si ','Yang ','Xian ','Jie ','Zheng ','Mak6','Li ','Huo ','Lai ','Zik ','Dian ','Xuan ','Ying ','Yin ','Qu ',
        'Ung ','Tan ','Dian ','Luo ','Luan ','Luan ','Bo ','','Gui ','Po ','Fa ','Deng ','Fa ','Bai ','Bai ','Qie ',
        'Bi ','Zao ','Zao ','Mao ','De ','Pa ','Giai ','Hoang ','Gui ','Ci ','Ling ','Gao ','Mo ','Ji ','Jiao ','Peng ',
        'Cau ','Ai ','E ','Hao ','Han ','Bi ','Wan ','Chou ','Qian ','Xi ','Ai ','Jiong ','Hao ','Huang ','Hao ','Ze ',
        'Cui ','Hao ','Xiao ','Ye ','Po ','Hao ','Jiao ','Ai ','Xing ','Huang ','Li ','Piao ','He ','Jiao ','Pi ','Gan ',
        'Pao ','Zhou ','Jun ','Qiu ','Cun ','Que ','Zha ','Gu ','Jun ','Jun ','Zhou ','Zha ','Gu ','Zhan ','Du ','Min ',
        'Qi ','Ying ','Yu ','Bei ','Zhao ','Zhong ','Pho ','He ','Ying ','He ','Yi ','Bo ','Wan ','He ','Ang ','Zhan ',
        'Yan ','Jian ','Hop ','Yu ','Kui ','Fan ','Gai ','Dao ','Pan ','Fu ','Qiu ','Sheng ','Dao ','Lu ','Chen ','Meng ',
        'Li ','Jin ','Xu ','Jian ','Ban ','Guan ','An ','Lu ','Shu ','Zhou ','Dang ','An ','Gu ','Li ','Muc ','Ding ',
        'Gan ','Xu ','Mang ','Mang ','Zhi ','Qi ','Ruan ','Tian ','Tuong ','Dun ','Xin ','Xi ','Pan ','Feng ','Dun ','Min ',
        ],
    'x77':[
        'Ming ','Sheng ','Shi ','Yun ','Mian ','Pan ','Fang ','Miao ','Dan ','Mi ','Mao ','Kan ','Xian ','Ou ','Shi ','Yang ',
        'Zheng ','Yao ','Shen ','Mu ','Da ','Zhen ','Kuang ','Ju ','Shen ','Chi ','Sheng ','Muoi ','Mat ','Zhu ','Zhen ','Chan ',
        'Mian ','Di ','Yuan ','Die ','Yi ','Zi ','Zi ','Chao ','Zha ','Xuan ','Bing ','Mi ','Long ','Sui ','Dong ','Mi ',
        'Die ','Yi ','Er ','Ming ','Xuan ','Chi ','Kuang ','Juan ','Mou ','Zhen ','Tiao ','Yang ','Cua ','Mo ','Chung ','Mai ',
        'Zhao ','Zheng ','Mei ','Jun ','Shao ','Han ','Huan ','Di ','Cheng ','Cuo ','Juan ','E ','Wan ','Xian ','Xi ','Kun ',
        'Lai ','Jian ','Shan ','Tian ','Hun ','Wan ','Ling ','Shi ','Qiong ','Lie ','Yai ','Jing ','Zheng ','Li ','Lai ','Sui ',
        'Juan ','Shui ','Sui ','Du ','Bi ','Bi ','Muc ','Hun ','Ni ','Lu ','Yi ','Jie ','Cai ','Zhou ','Yu ','Hun ',
        'Ma ','Xia ','Xing ','Xi ','Gun ','','Chun ','Jian ','Mei ','Du ','Hou ','Xuan ','Ti ','Kui ','Gao ','Rui ',
        'Mao ','Xu ','Fa ','Wen ','Miao ','Chou ','Kui ','Mi ','Weng ','Kou ','Dang ','Tran ','Ke ','Sou ','Xia ','Qiong ',
        'Mao ','Ming ','Man ','Shui ','Ze ','Zhang ','Yi ','Diao ','Ou ','Mo ','Shun ','Cong ','Lou ','Chi ','Man ','Piao ',
        'Cheng ','Ji ','Meng ','','Run ','Pie ','Xi ','Qiao ','Pu ','Zhu ','Deng ','Shen ','Shun ','Liao ','Che ','Xian ',
        'Kan ','Ye ','Xu ','Chang ','Mou ','Lin ','Kui ','Xian ','Ye ','Ai ','Hui ','Zhan ','Lim ','Gu ','Zhao ','Ju ',
        'Wei ','Chou ','Sao ','Ning ','Xun ','Yao ','Huo ','Meng ','Mian ','Bin ','Mian ','Li ','Kuang ','Jue ','Xuan ','Mian ',
        'Huo ','Lu ','Meng ','Long ','Guan ','Man ','Xi ','Chu ','Tang ','Kan ','Zhu ','Mau ','Cang ','Lin ','Yu ','Shuo ',
        'Ce ','Jue ','Ngao ','Yi ','Shen ','Tri ','Hou ','Shen ','Ying ','Ju ','Zhou ','Jiao ','Cuo ','Duan ','Ai ','Jiao ',
        'Zeng ','Huo ','Bai ','Shi ','Ding ','Qi ','Ji ','Zi ','Gan ','Wu ','Tuo ','Ku ','Qiang ','Xi ','Fan ','Kuang ',
        ],
    'x78':[
        'Dang ','Ma ','Sha ','Dan ','Jue ','Li ','Fu ','Min ','Nuo ','Huo ','Kang ','Zhi ','Qi ','Kan ','Jie ','Fen ',
        'E ','Ya ','Pi ','Zhe ','Khan ','Sui ','Zhuan ','Che ','Dun ','Pan ','Yan ','','Feng ','Fa ','Mo ','Zha ',
        'Qu ','Yu ','Luo ','Tuo ','Tuo ','Di ','Zhai ','Kham ','Ai ','Fei ','Mu ','Zhu ','Li ','Bian ','Nu ','Ping ',
        'Peng ','Ling ','Bau ','Le ','Po ','Bo ','Po ','Shen ','Za ','Nuo ','Li ','Long ','Tong ','','Li ','Kou ',
        'Chu ','Keng ','Quan ','Zhu ','Kuang ','Gui ','E ','Nao ','Jia ','Lu ','Wei ','Ai ','Ngac ','Ken ','Xing ','Yan ',
        'Tong ','Peng ','Xi ','','Hong ','Shuo ','Xia ','Qiao ','','Wei ','Qiao ','','Keng ','Xiao ','Que ','Chan ',
        'Lang ','Hong ','Yu ','Xiao ','Xia ','Mang ','Long ','Yong ','Che ','Che ','E ','Luu ','Khu ','Mang ','Que ','Kho ',
        'Sha ','Kun ','Yu ','','Kaki ','Lu ','Chen ','Jian ','Nue ','Song ','Zhuo ','Keng ','Peng ','Yan ','Zhui ','Kong ',
        'Ceng ','Qi ','Zong ','Qing ','Lin ','Jun ','Bo ','Ding ','Min ','Diao ','Jian ','He ','Lu ','Ai ','Sui ','Que ',
        'Ling ','Bei ','Yin ','Dui ','Wu ','Qi ','Lun ','Wan ','Dian ','Gang ','Bei ','Qi ','Chen ','Ruan ','Yan ','Die ',
        'Ding ','Du ','Tuo ','Jie ','Ying ','Bian ','Ke ','Bi ','Wei ','Shuo ','Zhen ','Duan ','Xia ','Dang ','Ti ','Nao ',
        'Peng ','Jian ','Di ','Tan ','Cha ','Seki ','Qi ','','Feng ','Xuan ','Que ','Que ','Ma ','Gong ','Nian ','Su ',
        'E ','Ci ','Liu ','Si ','Tang ','Bang ','Hua ','Pi ','Wei ','Sang ','Loi ','Cuo ','Zhen ','Xia ','Qi ','Lian ',
        'Pan ','Wei ','Yun ','Dui ','Zhe ','Ke ','La ','','Qing ','Gun ','Zhuan ','Chan ','Qi ','Ao ','Peng ','Lu ',
        'Lu ','Kan ','Qiang ','Chen ','Yin ','Lei ','Biao ','Qi ','Mai ','Qi ','Cui ','Zong ','Qing ','Chuo ','','Ji ',
        'Shan ','Lao ','Qu ','Zeng ','Deng ','Jian ','Xi ','Co ','Ding ','Dian ','Hoang ','Pan ','Za ','Qiao ','Di ','Li ',
        ],
    'x79':[
        'Kan ','Jiao ','','Zhang ','Qiao ','Dun ','Xian ','Yu ','Zhui ','He ','Huo ','Zhai ','Lei ','Ke ','Chu ','Ji ',
        'Que ','Dang ','Yi ','Jiang ','Pi ','Pi ','Yu ','Pin ','Qi ','Ai ','Kai ','Jian ','Yu ','Ruan ','Meng ','Pao ',
        'Ci ','Bo ','','Mie ','Ca ','Xian ','Kuang ','Lei ','Lei ','Zhi ','Li ','Li ','Troi ','Que ','Pao ','Ying ',
        'Li ','Long ','Long ','Mo ','Bo ','Shuang ','Guan ','Lan ','Zan ','Yan ','Shi ','Shi ','Li ','Reng ','She ','Yue ',
        'Si ','Qi ','Ta ','Ma ','Xie ','Yao ','Xian ','Qi ','Qi ','Zhi ','Beng ','Dui ','Zhong ','','Yi ','Shi ',
        'You ','Zhi ','Tiao ','Fu ','Fu ','Mi ','Zu ','Zhi ','Suan ','Mei ','To ','Qu ','Hu ','Chuc ','Shen ','Sui ',
        'Ci ','Chai ','Mi ','Lu ','Yu ','Xiang ','Wu ','Tiao ','Piao ','Zhu ','Gui ','Xia ','Zhi ','Ji ','Gao ','Zhen ',
        'Gao ','Shui ','Jin ','Chen ','Gai ','Kun ','Di ','Dao ','Huo ','Tao ','Qi ','Gu ','Guan ','Zui ','Ling ','Loc ',
        'Bing ','Cam ','Dao ','Zhi ','Lu ','Shan ','Bei ','Zhe ','Hui ','You ','Xi ','Yin ','Zi ','Huo ','Zhen ','Phuc ',
        'Yuan ','Wu ','Xian ','Yang ','Ti ','Yi ','Mei ','Si ','Di ','','Zhuo ','Zhen ','Yong ','Ji ','Gao ','Tang ',
        'Si ','Ma ','Ta ','','Xuan ','Qi ','Yu ','Xi ','Ji ','Si ','Chan ','Tan ','Kuai ','Sui ','Li ','Nong ',
        'Ni ','Dao ','Li ','Rang ','Yue ','Ti ','Zan ','Lei ','Rou ','Yu ','Yu ','Le ','Xie ','Qin ','He ','Tu ',
        'Tu ','Tu ','Ren ','Tu ','Zi ','Cha ','Gan ','Yi ','Xian ','Bing ','Nian ','Thu ','Qiu ','Zhong ','Fen ','Hao ',
        'Yun ','Khoa ','Miao ','Zhi ','Geng ','Bi ','Zhi ','Yu ','Mi ','Ku ','Ban ','Pi ','Ni ','Li ','You ','Zu ',
        'Pi ','Ba ','Ling ','Mo ','Cheng ','Nian ','Qin ','Yang ','Zuo ','Zhi ','Zhi ','Shu ','Ju ','Zi ','Huo ','Ji ',
        'Xung ','Tong ','Zhi ','Huo ','He ','Yin ','Zi ','Gie ','Jie ','Ren ','Du ','Yi ','Zhu ','Hui ','Nong ','Fu ',
        ],
    'x7a':[
        'Hi ','Kao ','Lang ','Fu ','Ze ','Shui ','Lu ','Kun ','Gan ','Geng ','Ti ','Cheng ','Tu ','Shao ','Shui ','Ya ',
        'Lun ','Lu ','Gu ','Zuo ','Ren ','Zhun ','Bang ','Bai ','Ji ','Zhi ','Zhi ','Kun ','Leng ','Peng ','Ke ','Bing ',
        'Chou ','Zu ','Yu ','Su ','Lue ','','Yi ','Xi ','Bian ','Ji ','Fu ','Bi ','Nuo ','Jie ','Zhong ','Zong ',
        'Xu ','Xung ','Dao ','Wen ','Lian ','Zi ','Yu ','Ji ','Xu ','Zhen ','Zhi ','Dao ','Jia ','Ji ','Gao ','Gao ',
        'Gu ','Rong ','Sui ','You ','Ji ','Kang ','Mu ','Shan ','Men ','Zhi ','Cay ','Lu ','Su ','Ji ','Ying ','Wen ',
        'Qiu ','Se ','','Yi ','Huang ','Qie ','Ji ','Sui ','Xiao ','Pu ','Jiao ','Zhuo ','Tong ','Sai ','Lu ','Sui ',
        'Nong ','Se ','Hui ','Rang ','Nuo ','Yu ','','Ji ','Tui ','Wen ','Cheng ','Huo ','Gong ','Hot ','Biao ','',
        'Rang ','Zhuo ','Li ','Zan ','Xue ','Wa ','Jiu ','Qiong ','Xi ','Khum ','Kong ','Yu ','Sen ','Jing ','Yao ','Chuan ',
        'Zhun ','Tu ','Lao ','Qie ','Zhai ','Yao ','Bian ','Bao ','Yao ','Bing ','Wa ','Zhu ','Jiao ','Qiao ','Diao ','Wu ',
        'Gui ','Yao ','Zhi ','Chuang ','Yao ','Tiao ','Jiao ','Song ','Jiong ','Xiao ','Cheng ','Kou ','Cuan ','Wo ','Dan ','Ku ',
        'Ke ','Zhui ','Xu ','Su ','','Kui ','Dou ','','Yin ','Wo ','Wa ','Ya ','Yu ','Ju ','Cung ','Yao ',
        'Yao ','Tiao ','Chao ','Yu ','Tian ','Diao ','Ju ','Liao ','Xi ','Wu ','Kui ','Chuang ','Zhao ','Fun ','Kuan ','Long ',
        'Cheng ','Cui ','Piao ','Zao ','Cuan ','Qiao ','Qiong ','Dou ','Zao ','Long ','Qie ','Li ','Chu ','Dekaritto ','Fou ','Kirorittoru ',
        'Chu ','Hong ','Qi ','Miririttoru ','','Deshiritto ','Shu ','Miao ','Ju ','Zhan ','Zhu ','Ling ','Long ','Bing ','Jing ','Jing ',
        'Chuong ','Hekutoritto ','Si ','Jun ','Hong ','Tong ','Song ','Jing ','Diao ','Yi ','Shu ','Jing ','Qu ','Jie ','Ping ','Duan ',
        'Shao ','Zhuan ','Ceng ','Deng ','Cui ','Huai ','Jing ','Kan ','Jing ','Truc ','Zhu ','Le ','Peng ','Yu ','Chi ','Gan ',
        ],
    'x7b':[
        'Mang ','Zhu ','Utsubo ','Du ','Ji ','Xiao ','Ba ','Suan ','Ji ','Zhen ','Zhao ','Sun ','Ya ','Zhui ','Yuan ','Hu ',
        'Gang ','Xiao ','Cen ','Pi ','Bi ','Jian ','Yi ','Dong ','Shan ','Dam ','Xia ','Di ','Zhu ','Na ','Chi ','Gu ',
        'Li ','Qie ','Min ','Bao ','Tiao ','Si ','Bua ','Ce ','Ben ','Pei ','Da ','Zi ','Di ','Ling ','Ze ','Nu ',
        'Fu ','Cau ','Fan ','Jia ','Ge ','Fan ','Shi ','Mao ','Po ','Sasa ','Jian ','Qiong ','Long ','Souke ','Bian ','Luo ',
        'Gui ','Qu ','Chi ','Yin ','Yao ','Xian ','But ','Qiong ','Gua ','Deng ','Jiao ','Gan ','Quan ','Sun ','Ru ','Fa ',
        'Kuang ','Truc ','Tong ','Ji ','Da ','Xing ','Ce ','Zhong ','Kou ','Lai ','Bi ','Shai ','Dang ','Zheng ','Ce ','Fu ',
        'Yun ','Tu ','Pa ','Li ','Lang ','Ju ','Guan ','Jian ','Han ','Thung ','Xia ','Zhi ','Cheng ','Toan ','Shi ','Zhu ',
        'Zuo ','Xiao ','Shao ','Ting ','Ce ','Yan ','Gao ','Kuai ','Gan ','Chou ','Kyou ','Gang ','Yun ','O ','Qian ','Xiao ',
        'Jian ','Pu ','Lai ','Zou ','Bi ','Bi ','Bi ','Ge ','Chi ','Guai ','Yu ','Jian ','Zhao ','Gu ','Chi ','Tranh ',
        'Jing ','Sha ','Zhou ','Lu ','Bo ','Kia ','Lin ','Suan ','Jun ','Fu ','Zha ','Gu ','Kong ','Qian ','Quan ','Jun ',
        'Chui ','Guan ','Yuan ','Ce ','Nhot ','Bo ','Ze ','Qie ','Tuo ','Luo ','Dan ','Xiao ','Ruo ','Jian ','','Bian ',
        'Sun ','Ruong ','Xian ','Ping ','Bu ','Sheng ','Hu ','Shi ','Zhu ','Yue ','Chun ','Lu ','Wu ','Dong ','Shuo ','Ji ',
        'Jie ','Huang ','Xing ','Mei ','Fan ','Chui ','Zhuan ','Pian ','Feng ','Troc ','Hong ','Qie ','Hou ','Qiu ','Miao ','Qian ',
        '','Kui ','Sik ','Lou ','Yun ','He ','Tang ','Yue ','Chou ','Gau ','Fei ','Ruo ','Zheng ','Gou ','Nie ','Qian ',
        'Xiao ','Cuan ','Gong ','Pang ','Du ','Li ','Bi ','Zhuo ','Chu ','Ray ','Chi ','Zhu ','Qiang ','Long ','Lan ','Jian ',
        'Bu ','Li ','Hui ','Bi ','Di ','Cong ','Yan ','Bong ','Sen ','Zhuan ','Pai ','Piao ','Dou ','Yu ','Mie ','Zhuan ',
        ],
    'x7c':[
        'Ze ','Xi ','Guo ','Yi ','Hu ','Chan ','Kou ','Cu ','Ping ','Chou ','Ji ','Gui ','Su ','Lou ','Zha ','Lu ',
        'Nian ','Suo ','Cuan ','Sen ','Suo ','Le ','Duan ','Yana ','Xiao ','Bo ','Mi ','Si ','Thang ','Liao ','Dan ','Dian ',
        'Fu ','Jian ','Min ','Kui ','Dai ','Jiao ','Deng ','Huang ','Sun ','Lau ','Tram ','Xiao ','Ro ','Shi ','Zan ','',
        'Pai ','Hata ','Pai ','Gan ','Ju ','Du ','Lu ','Yan ','Bo ','Dang ','Sai ','Ke ','Long ','Qian ','Lian ','Bu ',
        'Zhou ','Lai ','','Lan ','Kui ','Yu ','Yue ','Hao ','Zhen ','Tai ','Ti ','Mi ','Chou ','Ji ','','Hata ',
        'Teng ','Zhuan ','Zhou ','Fan ','Sou ','Zhou ','Tam ','Zhuo ','Teng ','Lu ','Gat ','Jian ','Tuo ','Ying ','Yu ','Lai ',
        'Long ','Shinshi ','Lian ','Tran ','Qian ','Yue ','Zhong ','Qu ','Lian ','Bian ','Duan ','Zuan ','Li ','Si ','Luo ','Ying ',
        'Yue ','Zhuo ','Yu ','Mi ','Di ','Fan ','Shen ','Zhe ','Shen ','Nu ','Xie ','Lei ','Xian ','Zi ','Ni ','Cun ',
        '','Qian ','Kume ','Bi ','Ban ','Wu ','Sha ','Kang ','Rou ','Phan ','Bi ','Cui ','','Li ','Chi ','Ta ',
        'Ro ','Ba ','Li ','Gan ','Ju ','Po ','Mo ','Cu ','Nian ','Zhou ','Li ','Su ','Tiao ','Li ','Xi ','Su ',
        'Hong ','Tong ','Zi ','Ce ','Yue ','Zhou ','Lin ','Zhuang ','Bai ','','Fen ','Ji ','','Sukumo ','Liang ','Xian ',
        'Fu ','Liang ','Can ','Geng ','Li ','Yue ','Lu ','Ju ','Qi ','Cui ','Bai ','Zhang ','Lin ','Zong ','Tinh ','Guo ',
        'Kouji ','San ','San ','Tang ','Bian ','Rou ','Mian ','Hou ','Xu ','Zong ','Hu ','Jian ','Zan ','Ci ','Li ','Xie ',
        'Fu ','Ni ','Bei ','Gu ','Xiu ','Gao ','Tang ','Qiu ','Sukumo ','Cao ','Zhuang ','Tang ','Mi ','Tam ','Phan ','Zao ',
        'Kang ','Jiang ','Mo ','San ','San ','Nuo ','Xi ','Luong ','Jiang ','Kuai ','Bo ','Huan ','','Zong ','Xian ','Nuo ',
        'Tuan ','Nie ','Li ','Zuo ','Di ','Nie ','Tiao ','Lan ','Mi ','Si ','Jiu ','Xi ','Gong ','Zheng ','Jiu ','You ',
        ],
    'x7d':[
        'Ji ','Cha ','Zhou ','Xun ','Yue ','Hong ','Yu ','Hot ','Wan ','Ren ','Wen ','Van ','Qiu ','Na ','Zi ','Tou ',
        'Neo ','Fou ','Jie ','Shu ','Chun ','Pi ','Yin ','Sa ','Hong ','Zhi ','Cap ','Phan ','Yun ','Ren ','Dan ','Jin ',
        'To ','Fang ','Suo ','Cui ','Jiu ','Zha ','Ha ','Jin ','Fu ','Zhi ','Ci ','Zi ','Chou ','Hong ','Za ','Lei ',
        'Toi ','Fu ','Xie ','Thang ','Bei ','Zhu ','Qu ','Ling ','Zhu ','Shao ','Gan ','Yang ','Fu ','Tuo ','Zhen ','Dai ',
        'Chu ','Shi ','Chung ','Xian ','Zu ','Jiong ','Ban ','Ju ','Mo ','Shu ','Zui ','Kou ','Jing ','Ren ','Heng ','Day ',
        'Jie ','Zhu ','Chou ','Gua ','Bai ','Jue ','Quang ','Hu ','Ci ','Geng ','Geng ','Tao ','Xie ','Ku ','Jiao ','Quan ',
        'Gai ','Luo ','Xuan ','Bing ','Xian ','Fu ','Cap ','Tong ','Nhung ','Tiao ','Yin ','Lei ','Xie ','Quan ','Xu ','Gai ',
        'Die ','Thong ','To ','Jiang ','Xiang ','Hui ','Jue ','Zhi ','Ken ','Juan ','Chi ','Mian ','Zhen ','Lu ','Cheng ','Qiu ',
        'Shu ','Bang ','Tong ','Xiao ','Wan ','Qin ','Geng ','Xiu ','Ti ','Tu ','Xie ','Hong ','Xi ','Fu ','Ting ','Noi ',
        'Dui ','Kun ','Fu ','Kinh ','Hu ','Zhi ','Yan ','Jiong ','Feng ','Ji ','Zoku ','Kase ','Zong ','Lin ','Duo ','Li ',
        'Luc ','Liang ','Chou ','Cuon ','Shao ','Qi ','Qi ','Zhun ','Qi ','Wan ','Qian ','Xian ','Shou ','Wei ','Qi ','Tao ',
        'Wan ','Cuong ','Wang ','Beng ','Zhui ','Cai ','Guo ','Cui ','Luan ','Liu ','Qi ','Zhan ','Bei ','Xuoc ','Trang ','Mian ',
        'Qi ','Qie ','Tan ','Zong ','Gun ','Zou ','Yi ','Zi ','Xing ','Liang ','Jin ','Fei ','Rui ','Min ','Yu ','Zong ',
        'Fan ','Lu ','Xu ','Ying ','Zhang ','Kasuri ','Xu ','Xiang ','Dam ','Ke ','Xian ','Ruan ','Mian ','Ji ','Duan ','Zhong ',
        'Di ','Min ','Miao ','Yuan ','Xie ','Bao ','Si ','Qiu ','Bian ','Huan ','Geng ','Cong ','Mian ','Wei ','Fu ','Wei ',
        'Yu ','Gou ','Miao ','Xie ','Lian ','Zong ','Bian ','Yun ','Yin ','Ti ','Gua ','Zhi ','Yun ','Cheng ','Chan ','Dai ',
        ],
    'x7e':[
        'Xia ','Yuan ','Zong ','Xu ','Jou ','Odoshi ','Geng ','Sen ','Quanh ','Jin ','Yi ','Zhui ','Ni ','Bang ','Lam ','Pan ',
        'Zhou ','Jian ','Cuo ','Quan ','Shuang ','Yun ','Xia ','Cui ','Xi ','Rong ','Tao ','Fu ','Yun ','Chen ','Gao ','Nhoc ',
        'Hu ','Zai ','Teng ','Xian ','Su ','Zhen ','Zong ','Tao ','Kou ','Cai ','Bi ','Feng ','Cu ','Li ','Suo ','Yin ',
        'Xi ','Tung ','Lei ','Zhuan ','Qian ','Man ','Zhi ','Lua ','Mac ','Piao ','Lian ','Mi ','Xuan ','Zong ','Ji ','Shan ',
        'Sui ','Fan ','Shuai ','Beng ','Yi ','Sao ','Mou ','Yao ','Qiang ','Hun ','Sen ','Xi ','Zung ','Xiu ','Ran ','Xuan ',
        'Sui ','Qiao ','Zeng ','Zuo ','Zhi ','Shan ','San ','Lin ','Yu ','Fan ','Liao ','Chuo ','Zun ','Jian ','Rao ','Chan ',
        'Rui ','Xiu ','Hui ','Hua ','Zuan ','Xi ','Qiang ','Un ','Da ','Sheng ','Hui ','Xi ','Se ','Ken ','Jiang ','Huan ',
        'Thao ','Cong ','Jie ','Nhau ','Bo ','Chan ','Giay ','Nao ','Sui ','Yi ','Shai ','Xu ','Ji ','Bin ','Qian ','Lan ',
        'Buoc ','Xun ','Zuan ','Qi ','Peng ','Li ','Mo ','Lei ','Xie ','Zuan ','Kuang ','You ','Tuc ','Lei ','Xian ','Chan ',
        'Kou ','Lu ','Chan ','Ying ','Cai ','Xiang ','Xian ','Zui ','Zuan ','La ','Xi ','Dao ','Lan ','Lei ','Lian ','Si ',
        'Jiu ','Yu ','Hong ','Zhou ','Xian ','He ','Yue ','Ji ','Wan ','Kuang ','Ji ','Ren ','Wei ','Yun ','Hong ','Chun ',
        'Pi ','Sha ','Gang ','Na ','Ren ','Zong ','Lun ','Fen ','Zhi ','Wen ','Fang ','Zhu ','Yin ','Niu ','Shu ','Xian ',
        'Gan ','Xie ','Fu ','Lian ','Zu ','Shen ','Xi ','Zhi ','Zhong ','Zhou ','Ban ','Fu ','Zhuo ','Shao ','Yi ','Jing ',
        'Dai ','Bang ','Rong ','Jie ','Ku ','Rao ','Die ','Heng ','Hui ','Gei ','Xuan ','Jiang ','Luo ','Jue ','Jiao ','Tong ',
        'Geng ','Xiao ','Juan ','Xiu ','Xi ','Sui ','Tao ','Ji ','Ti ','Ji ','Xu ','Ling ','Ying ','Xu ','Qi ','Fei ',
        'Chuo ','Zhang ','Gun ','Sheng ','Wei ','Mian ','Shou ','Beng ','Chou ','Tao ','Liu ','Quan ','Zong ','Zhan ','Wan ','Lu ',
        ],
    'x7f':[
        'Zhui ','Zi ','Ke ','Xiang ','Jian ','Mian ','Lan ','Ti ','Miao ','Qi ','Yun ','Hui ','Si ','Duo ','Duan ','Bian ',
        'Xian ','Gou ','Zhui ','Huan ','Di ','Lu ','Bian ','Min ','Yuan ','Jin ','Fu ','Ru ','Zhen ','Feng ','Shuai ','Gao ',
        'Chan ','Li ','Yi ','Jian ','Bin ','Piao ','Man ','Lei ','Ying ','Suo ','Mou ','Sao ','Xie ','Liao ','Shan ','Zeng ',
        'Jiang ','Qian ','Zao ','Huan ','Jiao ','Zuan ','Fou ','Xie ','Cong ','Fou ','Que ','Fou ','Ketsu ','Bo ','Ping ','Hou ',
        'Diu6','Gang ','Ying ','Ying ','Qing ','Xia ','Guan ','Zun ','Tan ','Cang ','Qi ','Weng ','Ying ','Lei ','Tan ','Lu ',
        'Guan ','Wang ','Wang ','Gang ','Wang ','Han ','','Luo ','Fu ','Mi ','Fa ','Gu ','Zhu ','Ju ','Mao ','Gu ',
        'Min ','Gang ','Ba ','Gua ','Ti ','Juan ','Fu ','Lin ','Yan ','Zhao ','Toi ','Gua ','Zhuo ','Yu ','Zhi ','An ',
        'Fa ','Nan ','Shu ','Si ','Pi ','Ma ','Liu ','Ba ','Fa ','Li ','Chao ','Wei ','Bi ','Ji ','Zeng ','Tong ',
        'Liu ','Ji ','Juan ','Mi ','Zhao ','La ','Pi ','Ji ','Ji ','Luan ','Duong ','Mi ','Qiang ','Ta ','Mei ','Yang ',
        'You ','You ','Fen ','Ba ','Gao ','Yang ','Gu ','Qiang ','Zang ','Gao ','Ling ','Yi ','Zhu ','Di ','Xiu ','Qian ',
        'Yi ','Xian ','Rong ','Qun ','Qun ','Qiang ','Huan ','Suo ','Xian ','Yi ','You ','Qiang ','Xian ','Yu ','Canh ','Jie ',
        'Tang ','Yuan ','Xi ','Fan ','Shan ','Fen ','Shan ','Lian ','Lei ','Geng ','Nou ','Qiang ','Chan ','Yu ','Gong ','Yi ',
        'Chong ','Weng ','Fen ','Hong ','Chi ','Chi ','Cui ','Fu ','Xia ','Pen ','Yi ','La ','Yi ','Pi ','Ling ','Liu ',
        'Zhi ','Qu ','Xi ','Xie ','Xiang ','Hap ','Xi ','Qi ','Qiao ','Hui ','Hui ','Xiao ','Se ','Hong ','Jiang ','Di ',
        'Cui ','Fei ','Tao ','Sha ','Chi ','Zhu ','Jian ','Xuan ','Shi ','Pian ','Zong ','Wan ','Hui ','Hou ','He ','He ',
        'Han ','Ao ','Piao ','Yi ','Lian ','Qu ','','Lin ','Pen ','Qiao ','Ao ','Fan ','Yi ','Hui ','Xuan ','Dao ',
        ],
    'x80':[
        'Yao ','Lao ','','Kao ','Mao ','Zhe ','Qi ','Gou ','Gou ','Gou ','Die ','Die ','Er ','Shua ','Ruan ','Er ',
        'Nai ','Zhuan ','Lei ','Ting ','Zi ','Canh ','Chao ','Hao ','Yun ','Ba ','Pi ','Chi ','Si ','Chu ','Roi ','Ju ',
        'He ','Chu ','Lao ','Lun ','Ji ','Tang ','Ou ','Lou ','Nou ','Jiang ','Pang ','Ze ','Lou ','Ji ','Lao ','Huo ',
        'You ','Mo ','Huai ','Er ','Zhe ','Ting ','Ye ','Da ','Song ','Qin ','Yun ','Chi ','Dan ','Dan ','Hong ','Geng ',
        'Zhi ','','Nie ','Dan ','Zhen ','Che ','Ling ','Zheng ','You ','Wa ','Liao ','Long ','Zhi ','Ning ','Tiao ','Er ',
        'Ya ','Die ','Gua ','','Lian ','Hao ','Sheng ','Lie ','Pin ','Jing ','Tu ','Bi ','Di ','Guo ','Wen ','Xu ',
        'Ping ','Cong ','Shikato ','','Ting ','Yu ','Cong ','Kui ','Ren ','Kui ','Cong ','Lian ','Weng ','Kui ','Lian ','Lian ',
        'Cong ','Ao ','Thanh ','Song ','Ting ','Kui ','Nie ','Zhi ','Dan ','Ning ','qie ','Ji ','Ting ','Ting ','Long ','Yu ',
        'Yu ','Zhao ','Si ','Su ','Yi ','Su ','Si ','Zhao ','Zhao ','Rou ','Yi ','Lei ','Ji ','Qiu ','Ken ','Cao ',
        'Ge ','Di ','Huan ','Huang ','Yi ','Ren ','Xiao ','Ru ','Zhou ','Yuan ','Du ','Gang ','Rong ','Gan ','Cha ','Wo ',
        'Chang ','Gu ','Chi ','Han ','Fu ','Fei ','Fen ','Pei ','Pang ','Jian ','Fang ','Zhun ','You ','Noi ','Hang ','Ken ',
        'Ran ','Quang ','Duc ','Wen ','Yao ','Jin ','Pi ','Qian ','Xi ','Xi ','Fei ','Ken ','Jing ','Tai ','Shen ','Zhong ',
        'Zhang ','Xie ','Than ','Wei ','Tru ','Die ','Dan ','Fei ','Ba ','Bo ','Qu ','Tian ','Boi ','Gua ','Thai ','Zi ',
        'Ku ','Zhi ','Ni ','Ping ','Zi ','Fu ','Pang ','Zhen ','Xian ','Zuo ','Pei ','Jia ','Thang ','Zhi ','Bao ','Mu ',
        'Qu ','Hu ','Ke ','Yi ','Yin ','Xu ','Yang ','Long ','Dong ','Ka ','Lu ','Jing ','Nu ','Nhan ','Pang ','Kua ',
        'Yi ','Guang ','Hai ','Ge ','Dong ','Zhi ','Xiao ','Xiong ','Xiong ','Er ','E ','Xing ','Pian ','Nang ','Zi ','',
        ],
    'x81':[
        'Cheng ','Tiao ','Zhi ','Cui ','Mei ','Xie ','Cui ','Xie ','Mai ','Mai ','Ji ','Kyou ','Nin ','Kuai ','Sa ','Zang ',
        'Qi ','Nao ','Mi ','Nong ','Luan ','Wan ','Bo ','Wen ','Guan ','Qiu ','Jiao ','Jing ','Rou ','Heng ','Cuo ','Lie ',
        'Shan ','Ting ','Mei ','Chun ','Shen ','Qian ','Te ','Zui ','Cu ','Xiu ','Xin ','Tuo ','Pao ','Cheng ','Nei ','Fu ',
        'Dou ','Tuo ','Niao ','Nou ','Pi ','Gu ','Gua ','Li ','Lian ','Truong ','Cui ','Jie ','Liang ','Zhou ','Pi ','Biao ',
        'Lun ','Pian ','Guo ','Kui ','Chui ','Dan ','Tian ','Nei ','Jing ','Jie ','La ','Yi ','Yan ','Ren ','Shen ','Chuo ',
        'Fu ','Fu ','Ju ','Fei ','Xoang ','Wan ','Dong ','Pi ','Guo ','Zong ','Ding ','Wu ','Mei ','Ruan ','Zhuan ','Zhi ',
        'Cou ','Gua ','Ou ','Di ','An ','Tanh ','Nao ','Yu ','Chuan ','Nem ','Yun ','Zhong ','Rou ','E ','Sai ','Tu ',
        'Yao ','Jian ','Wei ','Jiao ','Yu ','Jia ','Duan ','Bi ','Chang ','Phuc ','Xian ','Ni ','Mian ','Wa ','Teng ','Tui ',
        'Bang ','Qian ','Lu ','Wa ','Sou ','Tang ','Su ','Zhui ','Ge ','Yi ','Bo ','Liao ','Ji ','Pi ','Xie ','Cao ',
        'Lu ','Bin ','','Chang ','Lu ','Guo ','Pang ','Chuai ','Piao ','Jiang ','Fu ','Tang ','Mo ','Xi ','Zhuan ','Lu ',
        'Keo ','Ying ','Lu ','Zhi ','Tara ','Chun ','Lian ','Tong ','Banh ','Ni ','Zha ','Liao ','Cui ','Gui ','Xiao ','Teng ',
        'Fan ','Zhi ','Jiao ','Shan ','Hu ','Cui ','Run ','Xiang ','Sui ','Fen ','Ying ','Dan ','Zhua ','Dan ','Kuai ','Nong ',
        'Tun ','Lian ','Bi ','Yong ','Jue ','Chu ','Yi ','Juan ','La ','Lian ','Sao ','Tun ','Gu ','Qi ','Cui ','Bin ',
        'Xun ','Ru ','Huo ','Zang ','Xian ','Biao ','Xing ','Kuan ','La ','Yan ','Lu ','Huo ','Zang ','Luo ','Qu ','Zang ',
        'Luan ','Ni ','Zang ','Chen ','Qian ','Wo ','Guang ','Tang ','Lin ','Guang ','Zi ','Jiao ','Nie ','Xu ','Ji ','Gao ',
        'Chou ','Mian ','Nie ','Zhi ','Zhi ','Ge ','Jian ','Die ','Zhi ','Xiu ','Tai ','Zhen ','Coi ','Xian ','Yu ','Cha ',
        ],
    'x82':[
        'Yao ','Yu ','Thung ','Xi ','Xi ','Jiu ','Yu ','Yu ','Hung ','Cu ','Jiu ','Xin ','She ','She ','Sha ','Jiu ',
        'Shi ','Tan ','Thu ','Shi ','Tian ','Dan ','Pho ','Pu ','Guan ','Hua ','Tan ','Chuan ','Thuan ','Xia ','Wu ','Zhou ',
        'Dao ','Gang ','Shan ','Yi ','','Pa ','Tai ','Fan ','Ban ','Chuan ','Hang ','Fang ','Ban ','Que ','Ro ','Zhong ',
        'Jian ','Cang ','Ling ','Zhu ','Ze ','Duo ','Bo ','Xian ','Ge ','Chuan ','Xia ','Lu ','Hong ','Pang ','Xi ','',
        'Fu ','Zao ','Feng ','Li ','Shao ','Yu ','Lang ','Ting ','','Wei ','Bo ','Manh ','Nian ','Ju ','Huang ','Shou ',
        'Zong ','Bian ','Mao ','Die ','Dou6','Bang ','Cha ','Yi ','Sao ','Cang ','Tau ','Lou ','Dai ','Sori ','Yao ','Tong ',
        'Tou ','Dang ','Tan ','Lu ','Yi ','Jie ','Jian ','Huo ','Meng ','Qi ','Lu ','Lu ','Chan ','Shuang ','Can ','Luong ',
        'Jian ','Gian ','Sac ','Yan ','Fu ','Ping ','Yan ','Yan ','Cao ','','Yi ','Le ','Ting ','Qiu ','Ai ','Nai ',
        'Tiao ','Jiao ','Jie ','Peng ','Wan ','Yi ','Chai ','Mian ','Mie ','Gan ','Qian ','Yu ','Yu ','Shao ','Khung ','Tu ',
        'Xia ','Qi ','Mang ','Zi ','Hui ','Sui ','Zhi ','Xiang ','Pi ','Phu ','Tun ','Wei ','Wu ','Chi ','Qi ','Sam ',
        'Wen ','Qian ','Ren ','Bup ','Kou ','Jie ','Lu ','Xu ','Ji ','Qin ','Qi ','Yuan ','Fen ','Ba ','Noi ','Xin ',
        'Ji ','Hoa ','Hua ','Fang ','Wu ','Jue ','Gou ','Zhi ','Yun ','Qin ','Ao ','So ','Mao ','Ya ','Nao ','Nhang ',
        'Hang ','Cong ','Yin ','You ','Bian ','Yi ','Susa ','Wei ','Li ','Pi ','E ','Xian ','Chang ','Cang ','Meng ','Su ',
        'Yi ','Yuan ','Ran ','Linh ','Tai ','Tiao ','Di ','Meo ','Qiong ','Li ','Yong ','Ke ','Mu ','Bac ','Bao ','Gou ',
        'Min ','Yi ','Yi ','Ju ','Phi ','Ruo ','Ku ','Zhu ','Ni ','Bo ','Bing ','Shan ','Qiu ','Yao ','Xian ','Ben ',
        'Hong ','Anh ','Zha ','Rong ','Ju ','Die ','Nie ','Gan ','Hu ','Ping ','Mei ','Fu ','Sheng ','Gu ','Bi ','Wei ',
        ],
    'x83':[
        'Phat ','Zhuo ','Mao ','Fan ','Nha ','Mao ','Mao ','Ba ','Zi ','Mo ','Zi ','Di ','Chi ','Ji ','Jing ','Long ',
        '','Niao ','','Xue ','Ying ','Qiong ','Ge ','Ming ','Li ','Rong ','Yin ','Gen ','Qian ','Chai ','Chen ','Yu ',
        'Xiu ','Zi ','Lie ','Wu ','Ji ','Gui ','Thuoc ','Chong ','Ci ','Gou ','Guang ','Muong ','Chi ','Jiao ','Jiao ','Fu ',
        'Yu ','Zhu ','Zi ','Jiang ','Hui ','Yin ','Tra ','Fa ','Rong ','Nha ','Sung ','Mang ','Tong ','Zhong ','','Zhu ',
        'Xun ','Huan ','Kua ','Quan ','Gai ','Da ','Jing ','Hanh ','Chuan ','Cao ','Jing ','Er ','An ','Shou ','Chuoi ','Ren ',
        'Jian ','Sun ','Hoang ','Ping ','Li ','Jin ','Lao ','Shu ','Zhuang ','Da ','Jia ','Rao ','Bi ','Ze ','Qiao ','Hui ',
        'Qi ','Dang ','','Rong ','Hun ','Ying ','Luo ','Ying ','Xun ','Jin ','Sun ','Yin ','Mai ','Hong ','Zhou ','Yao ',
        'Du ','Wei ','Chu ','Dou ','Fu ','Ren ','Yin ','He ','Mut ','Bu ','Yun ','Di ','Dua ','Sui ','Sui ','Cheng ',
        'Chen ','Wu ','Bie ','Xi ','Geng ','Li ','Bo ','Zhu ','Mo ','Li ','Trang ','Ji ','Duo ','Qiu ','Sha ','Suo ',
        'Chen ','Feng ','Ju ','Moi ','Meng ','Xing ','Hanh ','Che ','Shen ','Jun ','Yan ','Ting ','Diao ','Cuo ','Guan ','Han ',
        'You ','Cuo ','Jia ','Wang ','You ','Niu ','Shao ','Xian ','Lang ','Fu ','E ','Mo ','Wen ','Jie ','Nan ','Mu ',
        'Vay ','Lai ','Lian ','Shi ','Wo ','To ','Lian ','Huo ','You ','Ying ','Ying ','Nuc ','Chun ','Mang ','Mang ','Ci ',
        'Wan ','Jing ','Di ','Qu ','Dong ','Jian ','Zou ','Gu ','La ','Lu ','Cuc ','Wei ','Jun ','Nie ','Kun ','He ',
        'Pu ','Zi ','Gao ','Guo ','Fu ','Ham ','Chang ','Chou ','Song ','Chui ','Zhan ','Men ','Cai ','Ba ','Li ','Tho ',
        'Bo ','Han ','Bao ','Qin ','Juan ','Xi ','Qin ','Di ','Jie ','Pu ','Dang ','Jin ','Zhao ','Tai ','Geng ','Hoa ',
        'Gu ','Lang ','Fei ','Jin ','Am ','Wang ','Phung ','Zhou ','Yan ','Ju ','Jian ','Lum ','Tan ','Shu ','Tian ','Dao ',
        ],
    'x84':[
        'Hu ','Qi ','He ','Cui ','Tao ','Chun ','Pi ','Chang ','Huan ','Fei ','Lai ','Qi ','Manh ','Ping ','Wei ','Dan ',
        'Sha ','Huan ','Yan ','Yi ','Tiao ','Qi ','Wan ','Ce ','Nai ','Kutabireru ','Tuo ','Jiu ','Tie ','Luo ','','',
        'Meng ','','Yaji ','','Ying ','Ying ','Ying ','Xiao ','Sa ','Qiu ','Ke ','Xiang ','Wan ','Yu ','Yu ','Fu ',
        'Lian ','Xuan ','Yuan ','Nan ','Ze ','Wo ','Chun ','Xiao ','Yu ','Pian ','Mao ','An ','E ','Luo ','Ying ','Huo ',
        'Gua ','Jiang ','Mian ','Zuo ','Zuo ','Ju ','Bao ','Nhu ','Xi ','Ye ','An ','Qu ','Jian ','Fu ','Lu ','Jing ',
        'Pen ','Feng ','Hong ','Hong ','Hou ','Yan ','Nhut ','Zhu ','Zi ','Xiang ','Shen ','Ge ','Jie ','Jing ','Mi ','Huang ',
        'Shen ','Pu ','Gai ','Dong ','Zhou ','Qian ','Wei ','Bo ','Wei ','Ba ','Ji ','Hu ','Zang ','Jia ','Duan ','Yao ',
        'Jun ','Cong ','Quan ','Wei ','Zhen ','Kui ','Ting ','Hun ','Toi ','Shi ','Qi ','Lan ','Zong ','Yao ','Yuan ','Mei ',
        'Yun ','Shu ','Di ','Zhuan ','Guan ','Sukumo ','Xue ','Chan ','Kai ','Kui ','','Jiang ','Lou ','Wei ','Pai ','',
        'Sou ','Yin ','Shi ','Chun ','Shi ','Yun ','Zhen ','Lang ','Nu ','Meng ','He ','Que ','Suan ','Yuan ','Li ','Ju ',
        'Xi ','Bang ','Chu ','Xu ','Tu ','Liu ','Wo ','Zhen ','Qian ','Zu ','Po ','Cuo ','Yuan ','Chu ','Yu ','Kuai ',
        'Pan ','Pu ','Pu ','Na ','Shuo ','Xi ','Fen ','Yun ','Chung ','Jian ','Ji ','Ruo ','Cang ','En ','Mi ','Hao ',
        'Sun ','Zhen ','Ming ','Sau ','Xu ','Liu ','Xi ','Gu ','Lang ','Rong ','Weng ','Gai ','Cuo ','Shi ','Tang ','Luo ',
        'Doi ','Suo ','Xian ','Bui ','Yao ','Gui ','Bi ','Zong ','Gun ','Za ','Xiu ','Ce ','Hai ','Lan ','','Ji ',
        'Li ','Can ','Lang ','Yu ','','Ying ','Mo ','Diao ','Tiao ','Mao ','Tong ','Zhu ','Peng ','An ','Sen ','Cong ',
        'Xi ','Ping ','Qiu ','Jin ','Chun ','Jie ','Wei ','Tui ','Cao ','Yu ','Yi ','Giap ','Liao ','Bi ','Lu ','Su ',
        ],
    'x85':[
        'Bu ','Zhang ','Luo ','Jiang ','Man ','Yan ','Ling ','Ji ','Piao ','Gun ','Han ','Di ','Su ','Lu ','She ','Shang ',
        'Di ','Mie ','Xun ','Mon ','Bo ','Di ','Cuo ','Zhe ','Sam ','Xuan ','Wei ','Hu ','Ao ','Mi ','Lou ','Cu ',
        'Zhong ','Cai ','Po ','Jiang ','Mi ','Cong ','Niao ','Hui ','Jun ','Yin ','Jian ','Yan ','Shu ','Yin ','Kui ','Chen ',
        'Hu ','Sha ','Kou ','Qian ','Ma ','Zang ','Sonoko ','Qiang ','Dou ','Lian ','Lin ','Kou ','Ai ','Bi ','Li ','Wei ',
        'Ji ','Tum ','Sheng ','Fan ','Muong ','Ou ','Chan ','Dian ','Xun ','Jiao ','Rui ','Rui ','Lei ','Yu ','Qiao ','Chu ',
        'Hua ','Jian ','Mai ','Yun ','Bao ','You ','Qu ','Lu ','Rao ','Hui ','E ','Teng ','Fei ','Jue ','Zui ','Fa ',
        'Ru ','Fen ','Kui ','Shun ','Rui ','Ya ','Xu ','Fu ','Jue ','Dang ','Wu ','Tong ','Si ','Xiao ','Xi ','Long ',
        'Yun ','','Qi ','Jian ','Yun ','Sun ','Ling ','Yu ','Xia ','Yong ','Ji ','Hong ','Si ','Nong ','Lei ','Xuan ',
        'Yun ','Yu ','Xi ','Hao ','Bo ','Hao ','Ai ','Wei ','Hui ','Wei ','Ji ','Ci ','Xiang ','Luan ','Mie ','Yi ',
        'Leng ','Jiang ','Can ','Shen ','Qiang ','Rom ','Ke ','Yuan ','Da ','Ti ','Tang ','Xue ','Bi ','Zhan ','Sun ','Lian ',
        'Fan ','Ding ','Jie ','Gu ','Xie ','Shu ','Jian ','Kao ','Hong ','Sa ','Xin ','Xun ','Yao ','Hai ','Sou ','Shu ',
        'Xun ','Dui ','Pin ','Wei ','Neng ','Chou ','Mai ','Nho ','Piao ','Tai ','Ci ','Zao ','Chen ','Zhen ','Er ','Ni ',
        'Ying ','Gao ','Cong ','Xiao ','Qi ','Fa ','Jian ','Xu ','Kui ','Jie ','Bian ','Diao ','Mi ','Lam ','Jin ','Cang ',
        'Miao ','Qiong ','Qie ','Xian ','','Ou ','Xian ','Su ','Lu ','Yi ','Xu ','Xie ','Li ','Yi ','La ','Lei ',
        'Xiao ','Di ','Zhi ','Bei ','Teng ','Yao ','Mo ','Huan ','Biao ','Fan ','Su ','Tan ','Tui ','Qiong ','Qiao ','Wei ',
        'Liu ','Hui ','','Gao ','Yun ','','Li ','Shu ','Chu ','Ai ','Lin ','Zao ','Xuan ','Chen ','Lai ','Huo ',
        ],
    'x86':[
        'Tuo ','Wu ','Rui ','Rui ','Qi ','Heng ','Lu ','To ','Tui ','Mang ','Yun ','Pin ','Yu ','Xun ','Ji ','Jiong ',
        'Xian ','Mo ','Hagi ','Su ','Jiong ','','Nie ','Bo ','Rang ','Yi ','Xian ','Yu ','Ju ','Lem ','Lian ','Yin ',
        'Qiang ','Ying ','Lung ','Tong ','Wei ','Yue ','Ling ','Qu ','Yao ','Fan ','Mi ','Lan ','Kui ','Lan ','Ji ','Dang ',
        'Katsura ','Lei ','Lei ','Hua ','Feng ','Zhi ','Wei ','Kui ','Zhan ','Huai ','Loe ','Ji ','Mi ','Lei ','Huai ','Luo ',
        'Ji ','Kui ','Lu ','Jian ','San ','','Lei ','Quan ','Xiao ','Yi ','Luan ','Men ','Bie ','Hu ','Hu ','Lu ',
        'Nue ','Lu ','Si ','Xiao ','Qian ','Xu ','Hu ','Xu ','Cuo ','Fu ','Hu ','Xu ','Lu ','Hu ','Yu ','Hao ',
        'Jiao ','Ju ','Guo ','Bao ','Yan ','Zhan ','Zhan ','Khuya ','Ban ','Xi ','Shu ','Trung ','Gu ','Diao ','Ji ','Cu ',
        'Cheng ','Shi ','','Di ','Zhe ','She ','Yu ','Gan ','Tua ','Hong ','Hui ','Meng ','Ge ','Sui ','Xia ','Chai ',
        'Shi ','Yi ','Ma ','Xiang ','Fang ','E ','Pa ','Chi ','Qian ','Wen ','Wen ','Rui ','Bang ','Bi ','Yue ','Yue ',
        'Jun ','Qi ','Tong ','Yin ','Qi ','Can ','Yuan ','Jue ','Hui ','Qin ','Qi ','Zhong ','Ya ','Ci ','Mu ','Wang ',
        'Fen ','Fen ','Hang ','Gong ','Tao ','Fu ','Ran ','Jie ','Phu ','Si ','Dou ','Bau ','Xian ','Ni ','Te ','Qiu ',
        'You ','Zha ','Ping ','Chi ','You ','Ha ','Han ','Ju ','Li ','Fu ','Ran ','Zha ','Gou ','Pi ','Bo ','Xian ',
        'Chau ','Diao ','Bie ','Bing ','Gu ','Ran ','Qu ','Xa ','Tie ','Ling ','Gu ','Dan ','Gu ','Ying ','Li ','Cheng ',
        'Qu ','Mou ','Cac ','Ci ','Hui ','Hui ','Mang ','Fu ','Yang ','Wa ','Lie ','Chau ','Yi ','Xian ','Kuo ','Giao ',
        'Li ','Yi ','Ping ','Jie ','Ha ','She ','Nhan ','Wang ','Mo ','Qiong ','Qie ','Gui ','Gong ','Chay ','Man ','Ebi ',
        'Zhi ','Jia ','Rao ','Si ','Qi ','Xing ','Lie ','Qiu ','Shao ','Nhong ','Jia ','Tui ','Che ','Bai ','E ','Han ',
        ],
    'x87':[
        'Xoc ','Xuan ','Ong ','Shen ','Zhen ','Fu ','Xian ','Zhe ','Wu ','Fu ','Li ','Lang ','Bi ','Chu ','Yuan ','You ',
        'Jie ','Dan ','Yan ','Ting ','Dian ','Shui ','Hui ','Gua ','Zhi ','Song ','Bay ','Ju ','Mi ','Qi ','Qi ','Yu ',
        'Jun ','La ','Meng ','Qiang ','Si ','Xi ','Trun ','Li ','Die ','Tiao ','Tao ','Kun ','Gan ','Han ','Yu ','Bang ',
        'Fei ','Pi ','Wei ','Dun ','Yi ','Yuan ','Su ','Quan ','Qian ','Rui ','Ni ','Qing ','Wei ','Liang ','Guo ','Wan ',
        'Dong ','E ','Ban ','Di ','Wang ','Can ','Yang ','Ying ','Guo ','Chan ','','La ','Ke ','Ji ','He ','Ting ',
        'Mai ','Xu ','Mian ','Yu ','Jie ','Shi ','Xuan ','Huang ','Yan ','Bian ','Rou ','Wei ','Fu ','Yuan ','Mei ','Wei ',
        'Fu ','Ruan ','Xie ','Du ','Qiu ','Mao ','Xia ','Ying ','Shi ','Trun ','Tang ','Zhu ','Zong ','Ti ','Fu ','Yuan ',
        'Hui ','Meng ','La ','Noc ','Ha ','Qiu ','Die ','Li ','Gua ','Yun ','Ju ','Nan ','Lou ','Qun ','Rong ','Ying ',
        'Jiang ','','Lang ','Pang ','Si ','Xi ','Ci ','Xi ','Yuan ','Ong ','Lian ','Sou ','Ban ','Rong ','Rong ','Ji ',
        'Wu ','Qiu ','Han ','Qin ','Yi ','Bi ','Hua ','Tang ','Yi ','Du ','Nai ','He ','Hu ','Hui ','Ma ','Ming ',
        'Yi ','Wen ','Ying ','Teng ','Yu ','Cang ','So ','Ebi ','Man ','','Shang ','Shi ','Cao ','Chi ','Di ','Ao ',
        'Lu ','Wei ','Zhi ','Tang ','Chen ','Piao ','Qu ','Pi ','Yu ','Jian ','Luo ','Sau ','Qin ','Zhong ','Yin ','Jiang ',
        'Shuai ','Wen ','Jiao ','Wan ','Zhe ','Zhe ','Ma ','Ma ','Guo ','Liu ','Mao ','Xi ','Cong ','Li ','Man ','Xiao ',
        'Tou ','Zhang ','Mang ','Xiang ','Mo ','Zui ','Si ','Qiu ','Te ','Zhi ','Peng ','Peng ','Jiao ','Qu ','Bie ','Liu ',
        'Pan ','Ve ','Xi ','Ji ','Zhuan ','Huang ','Fei ','Lao ','Jue ','Jue ','Hui ','Yin ','Chan ','Jiao ','Shan ','Rao ',
        'Xiao ','Mou ','Trung ','Xun ','Si ','','Cheng ','Dang ','Li ','Xie ','Shan ','Yi ','Jing ','Da ','Chan ','Qi ',
        ],
    'x88':[
        'Ci ','Xiang ','She ','Luo ','Qin ','Ying ','Chai ','Li ','Ze ','Xuan ','Lian ','Zhu ','Ze ','Xie ','Mang ','Xie ',
        'Qi ','Rong ','Jian ','Meng ','Hao ','Ru ','Huo ','Zhuo ','Jie ','Bin ','He ','Mot ','Fan ','Lei ','Jie ','La ',
        'Mi ','Li ','Chun ','Li ','Qiu ','Nie ','Lu ','Du ','Xiao ','Zhu ','Long ','Li ','Long ','Feng ','Ye ','Beng ',
        'Shang ','Gu ','Juan ','Ying ','','Xi ','Can ','Qu ','Quan ','Du ','Can ','Man ','Jue ','Jie ','Zhu ','Zha ',
        'Xie ','Huang ','Niu ','Pei ','Nu ','Xin ','Zhong ','Mo ','Er ','Ke ','Met ','Xi ','Hang ','Yan ','Kan ','Yuan ',
        '','Ling ','Xuan ','Shu ','Xian ','Tong ','Long ','Jie ','Xian ','Ya ','Hu ','Wei ','Dao ','Chong ','Wei ','Dao ',
        'Zhun ','Heng ','Qu ','Y ','Koromohen ','Bu ','Gan ','Yu ','Biao ','Cha ','Yi ','Oam ','Chen ','Fu ','Gun ','Fen ',
        'Suy ','Jie ','Na ','Zhong ','Dan ','Ri ','Zhong ','Zhong ','Xie ','Qi ','Xie ','Ran ','Zhi ','Ren ','Kham ','Jin ',
        'Jun ','Yuan ','Mei ','Chai ','Ao ','Niao ','Hui ','Ran ','Ca ','Tuo ','Ling ','Dai ','Bao ','Bao ','Yao ','Ven ',
        'Bi ','Cheo ','Tan ','Ju ','He ','Shu ','Tu ','Zhen ','Yi ','Pa ','Bo ','Di ','Wa ','Fu ','Gon ','Zhi ',
        'Zhi ','Ran ','Pan ','Yi ','Mao ','','Na ','Kou ','Xian ','Chan ','Qu ','Bei ','Gun ','Xi ','Ne ','Bo ',
        'Horo ','Fu ','Yi ','Chi ','Kho ','Ren ','Jiang ','Jia ','Cun ','Mo ','Jie ','Er ','Luo ','Ru ','Zhu ','Gui ',
        'Yin ','Trai ','Lie ','Kamishimo ','Yuki ','Zhuang ','Dang ','Seot ','Kun ','Ken ','Niao ','Shu ','Jia ','Kun ','Cheng ','Li ',
        'Juan ','Shen ','Bau ','Ge ','Yi ','Yu ','Zhen ','Liu ','Qiu ','Qun ','Ji ','Yi ','Bu ','Trang ','Shui ','Sha ',
        'Qun ','Li ','Lian ','Lian ','Ku ','Jian ','Fou ','Chan ','Bi ','Gun ','Tao ','Yuan ','Ling ','Chi ','Chang ','Chou ',
        'Duo ','Biao ','Liang ','Chang ','Bui ','Pei ','Fei ','Yuan ','Luo ','Guo ','Yan ','Du ','Xi ','Zhi ','Ju ','Qi ',
        ],
    'x89':[
        'Ji ','Zhi ','Gua ','Ken ','Tsuma ','Ti ','Ti ','Fu ','Chong ','Xie ','Bian ','Die ','Kun ','Duan ','Xiu ','Xiu ',
        'He ','Yuan ','Bao ','Bao ','Fu ','Yu ','Tuan ','Yan ','Hui ','Bei ','Chu ','Lu ','Ena ','Tan ','Yun ','Da ',
        'Gou ','Da ','Huai ','Rong ','Yuan ','Ru ','Nai ','Jiong ','Suo ','Ban ','Tun ','Chi ','Sang ','Niao ','Ying ','Jie ',
        'Qian ','Huai ','Kho ','Lian ','Bao ','Li ','Chap ','Shi ','Lu ','Yi ','Die ','Xie ','Xian ','Wei ','Biao ','Cao ',
        'Ji ','Jiang ','Sen ','Bao ','Xiang ','Chihaya ','Boc ','Jian ','Zhuan ','Jian ','Tui ','Ji ','Dan ','Za ','Fan ','Bo ',
        'Xiang ','Xin ','Bie ','Rao ','Man ','Lan ','Ao ','Duo ','Gui ','Cao ','Sui ','Nong ','Chan ','Lian ','Bi ','Jin ',
        'Dang ','Shu ','Tan ','Bi ','Lan ','Pu ','Ru ','Zhi ','','Shu ','Wa ','Shi ','Bai ','Xie ','Bo ','Chen ',
        'Lai ','Long ','Xi ','Xian ','Lan ','Zhe ','Dai ','Tasuki ','Zan ','Shi ','Jian ','Pan ','Yi ','Ran ','Ya ','Tay ',
        'Xi ','Yao ','Feng ','Tan ','','Biao ','Fu ','Ba ','He ','Ji ','Ji ','Jian ','Guan ','Bian ','Yan ','Qui ',
        'Jue ','Pian ','Mao ','Mi ','Mi ','Mie ','Shi ','Si ','Zhan ','Luo ','Jue ','Mi ','Tiao ','Lian ','Yao ','Zhi ',
        'Jun ','Xi ','Shan ','Wei ','Xi ','Tian ','Yu ','Lan ','E ','Du ','Than ','Pang ','Ji ','Ming ','Ying ','Gou ',
        'Qu ','Zhan ','Jin ','Guan ','Deng ','Jian ','Luo ','Qu ','Jian ','Wei ','Jue ','Qu ','Luo ','Lan ','Shen ','Di ',
        'Quan ','Jian ','Guan ','Yan ','Gui ','Mi ','Shi ','Zhan ','Lan ','Jue ','Ji ','Xi ','Di ','Tian ','Yu ','Gou ',
        'Jin ','Qu ','Jiao ','Jiu ','Jin ','Cu ','Jue ','Zhi ','Chao ','Ji ','Gu ','Dan ','Zi ','Di ','Shang ','Khoe ',
        'Quan ','Ge ','Chi ','Jie ','Gui ','Gong ','Chu ','Jie ','Hun ','Qiu ','Xing ','Su ','Ni ','Ji ','Lu ','Zhi ',
        'Zha ','Bi ','Xing ','Hu ','Shang ','Gong ','Zhi ','Xue ','Xuc ','Xi ','Yi ','Lu ','Jue ','Xi ','Yan ','Xi ',
        ],
    'x8a':[
        'Yan ','Gonben ','Ding ','Fu ','Qiu ','Qiu ','Jiao ','Hong ','Ji ','Fan ','Xun ','Diao ','Hong ','Cha ','Tao ','Xu ',
        'Jie ','Yi ','Ren ','Huan ','Yin ','Shan ','Qi ','Tuo ','Ji ','Xun ','Yin ','Ngoa ','Fen ','Ya ','Yao ','Tung ',
        'Shen ','Yin ','Xin ','Jue ','Xiao ','Dot ','Chen ','You ','Zhi ','Xiong ','Fang ','Xin ','Chao ','She ','Xian ','Sha ',
        'Tun ','Xu ','Yi ','Yi ','To ','Chi ','He ','Shen ','He ','Xu ','Zhen ','Chu ','Zheng ','Gou ','Zi ','Zi ',
        'Zhan ','Gu ','Fu ','Quan ','Die ','Ling ','Di ','Yang ','Li ','Nao ','Pan ','Zhou ','Gan ','Yi ','Ju ','Ao ',
        'Zha ','Tuo ','Yi ','Qu ','Zhao ','Ping ','Bi ','Xiong ','Qu ','Ba ','Da ','Tro ','Tao ','Zhu ','Ci ','Zhe ',
        'Yong ','Xu ','Xun ','Yi ','Huang ','He ','Shi ','Cha ','Jiao ','Thi ','Hen ','Cha ','Gou ','Gui ','Quan ','Hui ',
        'Jie ','Hua ','Gai ','Xiang ','Wei ','Shen ','Chou ','Tong ','Mi ','Zhan ','Ming ','E ','Hui ','Yan ','Xiong ','Gua ',
        'Er ','Beng ','Tiao ','Chi ','Lei ','Tru ','Kuang ','Khoa ','Wu ','Yu ','Teng ','Ji ','Zhi ','Ren ','Su ','Lang ',
        'E ','Kuang ','E ','Shi ','Ting ','Dan ','Bo ','Chan ','Du ','Heng ','Qiao ','Qin ','Shua ','An ','Yu ','Xiao ',
        'Thanh ','Jie ','Xian ','Vu ','Wu ','Gao ','Tung ','Pu ','Hoi ','Jing ','Shuo ','Zhen ','Shuo ','Du ','Yasashi ','Chang ',
        'Shui ','Jie ','Ke ','Qu ','Cong ','Xiao ','Sui ','Wang ','Xuan ','Fei ','Chi ','Ta ','Yi ','Na ','Yin ','Diao ',
        'Pi ','Chuo ','Chan ','Chen ','Zhun ','Ji ','Qi ','Tan ','Zhui ','Wei ','Ju ','Qing ','Jian ','Zheng ','Ze ','Zou ',
        'Qian ','Zhuo ','Liang ','Jian ','Zhu ','Hao ','Lun ','Shen ','Biao ','Huai ','Pian ','Hua ','Die ','Xu ','Pian ','Shi ',
        'Xuan ','Shi ','Hun ','Hua ','E ','Zhong ','Di ','Hai ','Fu ','Pu ','Ting ','Jian ','Qi ','Du ','Zi ','Chuan ',
        'Xi ','Hui ','Yin ','Am ','Xian ','Nan ','Chen ','Phung ','Chu ','Yang ','Yan ','Heng ','Xuan ','Ge ','Nuo ','Qi ',
        ],
    'x8b':[
        'Muu ','Ye ','Wei ','','Teng ','Zou ','Shan ','Jian ','Bo ','','Huang ','Huo ','Ge ','Ying ','Mi ','Xiao ',
        'Mi ','Xi ','Qiang ','Chen ','Huoc ','Ti ','Su ','Bang ','Chi ','Qian ','Shi ','Jiang ','Yuan ','Xie ','Xue ','Tao ',
        'Dao ','Yao ','','Yu ','Biao ','Cong ','Qing ','Li ','Mo ','Mo ','Shang ','Zhe ','Miu ','Jian ','Ze ','Jie ',
        'Lian ','Lou ','Can ','Ou ','Guan ','Xi ','Zhuo ','Ao ','Ao ','Jin ','Zhe ','Yi ','Hu ','Jiang ','Man ','Chao ',
        'Han ','Hua ','Chan ','Xu ','Zeng ','Se ','Xi ','She ','Dui ','Zheng ','Nao ','Lan ','E ','Ying ','Jue ','Ji ',
        'Zun ','Jiao ','Bo ','Hui ','Zhuan ','Mu ','Zen ','Zha ','Shi ','Qiao ','Tan ','Zen ','Pu ','Sheng ','Xuan ','Zao ',
        'Tan ','Dang ','Sui ','Qian ','Ji ','Jiao ','Jing ','Lian ','Nou ','Yi ','Ai ','Zhan ','Pi ','Hui ','Hua ','Yi ',
        'Yi ','Shan ','Rang ','Nou ','Qian ','Zhui ','Ta ','Ho ','Zhou ','Hao ','Ye ','Ying ','Jian ','Yu ','Jian ','Hui ',
        'Du ','Zhe ','Xuan ','Zan ','Lei ','Shen ','Wei ','Chan ','Li ','Yi ','Bian ','Zhe ','Yan ','E ','Thu ','Wei ',
        'Chou ','Yao ','Sam ','Rang ','Yin ','Lan ','Chen ','Huo ','Zhe ','Huan ','Zan ','Yi ','Dang ','Zhan ','Yan ','Du ',
        'Yan ','Ji ','Ding ','Fu ','Ren ','Ji ','Jie ','Hong ','Tao ','Rang ','Shan ','Qi ','Tuo ','Xun ','Yi ','Xun ',
        'Ji ','Ren ','Jiang ','Hui ','Ou ','Ju ','Ya ','Ne ','Xu ','E ','Lun ','Xiong ','Song ','Feng ','She ','Fang ',
        'Jue ','Zheng ','Gu ','He ','Ping ','Zu ','Shi ','Xiong ','Zha ','Su ','Zhen ','Di ','Zou ','Ci ','Qu ','Zhao ',
        'Bi ','Yi ','Yi ','Kuang ','Lei ','Shi ','Gua ','Shi ','Jie ','Hui ','Cheng ','Zhu ','Shen ','Hua ','Dan ','Gou ',
        'Quan ','Gui ','Xun ','Yi ','Zheng ','Gai ','Xiang ','Cha ','Hun ','Xu ','Zhou ','Jie ','Wu ','Yu ','Qiao ','Wu ',
        'Gao ','You ','Hui ','Kuang ','Shuo ','Song ','Ai ','Qing ','Zhu ','Zou ','Nuo ','Du ','Zhuo ','Fei ','Ke ','Wei ',
        ],
    'x8c':[
        'Yu ','Shui ','Shen ','Diao ','Chan ','Liang ','Zhun ','Sui ','Tan ','Shen ','Yi ','Mou ','Chen ','Die ','Huang ','Jian ',
        'Xie ','Nue ','Ye ','Wei ','E ','Yu ','Xuan ','Chan ','Zi ','An ','Yan ','Di ','Mi ','Pian ','Xu ','Mo ',
        'Dang ','Su ','Xie ','Yao ','Bang ','Shi ','Qian ','Mi ','Jin ','Man ','Zhe ','Jian ','Miu ','Tan ','Zen ','Qiao ',
        'Lan ','Pu ','Jue ','Yan ','Qian ','Zhan ','Chen ','Coc ','Qian ','Hong ','Xia ','Jue ','Hong ','Han ','Hong ','Xi ',
        'Xi ','Huo ','Liao ','Han ','Du ','Long ','Dou ','Jiang ','Qi ','Chi ','Li ','Deng ','Wan ','Bi ','Shu ','Xian ',
        'Phong ','Zhi ','Zhi ','Yan ','Yan ','Shi ','Chu ','Hui ','Tun ','Yi ','Tun ','Yi ','Jian ','Ba ','Hou ','E ',
        'Cu ','Xiang ','Huan ','Jian ','Ken ','Gai ','Qu ','Fu ','Xi ','Bin ','Hao ','Yu ','Tru ','Jia ','Fen ','Xi ',
        'Bo ','Wen ','Huan ','Bin ','Di ','Zong ','Fen ','Yi ','Zhi ','Beo ','Sai ','An ','Pi ','Na ','Pi ','Gou ',
        'Na ','You ','Diao ','Mo ','Si ','Huou ','Huan ','Kun ','He ','He ','Mo ','Han ','Mao ','Li ','Ni ','Bi ',
        'Yu ','Jia ','Tuan ','Mao ','Pi ','Xi ','E ','Ju ','Mo ','Chu ','Tan ','Huan ','Jue ','Bei ','Trinh ','Yuan ',
        'Phu ','Tai ','Cong ','Te ','Yi ','Hang ','Wan ','Pin ','Huo ','Fan ','Tham ','Quan ','Ze ','Zhi ','Er ','Zhu ',
        'Shi ','Bi ','Zi ','Er ','Gui ','Pian ','Bian ','Mai ','Dai ','Sheng ','Kuang ','Fei ','Tie ','Yi ','Chi ','Mao ',
        'He ','Bi ','Lo ','Lin ','Hui ','Gai ','Pian ','Zi ','Jia ','Xu ','Zei ','Jiao ','Gai ','Zang ','Jian ','Ying ',
        'Xun ','Zhen ','She ','Tan ','Bin ','Qiu ','She ','Chuan ','Zang ','Zhou ','Lai ','Zan ','Ci ','Chen ','Shang ','Tian ',
        'Pei ','Geng ','Xian ','Mai ','Jian ','Sui ','Phu ','Tan ','Cong ','Cong ','Chat ','Ji ','Zhang ','Du ','Jin ','Xiong ',
        'Shun ','Yun ','Bao ','Zai ','Lai ','Phung ','Cang ','Ji ','Sheng ','Ai ','Zhuan ','Fu ','Gou ','Sai ','Ze ','Liao ',
        ],
    'x8d':[
        'Wei ','Bai ','Chen ','Zhuan ','Zhi ','Zhui ','Biao ','Yun ','Zeng ','Tan ','Zan ','Yan ','','Shan ','Wan ','Ying ',
        'Jin ','Gan ','Xian ','Tang ','Bi ','Du ','Chuoc ','Yan ','','Xuan ','Long ','Gan ','Zang ','Bei ','Zhen ','Fu ',
        'Yuan ','Gong ','Cai ','Ze ','Xian ','Bai ','Zhang ','Huo ','Zhi ','Fan ','Tan ','Pin ','Bian ','Gou ','Zhu ','Guan ',
        'Er ','Jian ','Bi ','Shi ','Tie ','Gui ','Kuang ','Dai ','Mao ','Fei ','He ','Yi ','Zei ','Zhi ','Jia ','Hui ',
        'Zi ','Ren ','Lu ','Zang ','Zi ','Gai ','Jin ','Qiu ','Zhen ','Lai ','She ','Fu ','Du ','Ji ','Shu ','Shang ',
        'Si ','Bi ','Zhou ','Geng ','Pei ','Tan ','Lai ','Feng ','Zhui ','Fu ','Zhuan ','Sai ','Ze ','Yan ','Zan ','Yun ',
        'Zeng ','Shan ','Ying ','Gan ','Chi ','Xi ','She ','Nan ','Xiong ','Xi ','Cheng ','He ','Cheng ','Zhe ','Xia ','Tang ',
        'Zou ','Zou ','Li ','Jiu ','Fu ','Zhao ','Gan ','Qi ','Shan ','Qiong ','Qin ','Xian ','Ci ','Jue ','Qin ','Chi ',
        'Ci ','San ','Chen ','Die ','Ju ','Chao ','Di ','Se ','Zhan ','Zhu ','Yue ','Qu ','Jie ','Chi ','Chu ','Gua ',
        'Xue ','Ci ','Tiao ','Duo ','Lie ','Gan ','Suo ','Cu ','Xi ','Zhao ','Su ','Yin ','Ju ','Jian ','Que ','Tang ',
        'Chuo ','Cui ','Lu ','Thu ','Dang ','Qiu ','Zi ','Ti ','Xu ','Chi ','Huang ','Qiao ','Qiao ','Yao ','Zao ','Ti ',
        '','Zan ','Zan ','Tuc ','Pa ','Bao ','Ku ','Ke ','Dun ','Jue ','Fu ','Chen ','Jian ','Fang ','Zhi ','Sa ',
        'Yue ','Pa ','Qi ','Yue ','Qiang ','Tuo ','Tai ','Yi ','Nian ','Ling ','Mei ','Ba ','Die ','Ku ','Tuo ','Jia ',
        'Ci ','Pao ','Qia ','Zhu ','Ju ','Die ','Zhi ','Fu ','Pan ','Ju ','Shan ','Bo ','Ni ','Ju ','Li ','Ngan ',
        'Yi ','Ji ','Dai ','Xian ','Jiao ','Duo ','Zhu ','Quan ','Kua ','Zhuai ','Gui ','Qiong ','Kui ','Xiang ','Choi ','Lo ',
        'Beng ','Zhi ','Jia ','Tiao ','Cai ','Jian ','Ta ','Qiao ','Bi ','Xian ','Duo ','Ji ','Ju ','Ji ','Shu ','Tu ',
        ],
    'x8e':[
        'Chu ','Jing ','Nie ','Xiao ','Bo ','Chi ','Qun ','Mou ','Shu ','Lang ','Yong ','Jiao ','Chou ','Qiao ','Mau ','Ta ',
        'Jian ','Qi ','Wo ','Wei ','Zhuo ','Jie ','Ji ','Nie ','Guoc ','Ju ','Lun ','Lu ','Leng ','Huai ','Ju ','Chi ',
        'Wan ','Quan ','Ti ','Voi ','Zu ','Qie ','Ji ','Cu ','Zong ','Cai ','Zong ','Peng ','Zhi ','Zheng ','Dian ','Zhi ',
        'Yu ','Duo ','Dun ','Chun ','Yong ','Zhong ','Di ','Zhe ','Chen ','Chuai ','Jian ','Gua ','Tang ','Ju ','Fu ','Zu ',
        'Die ','Pian ','Rou ','Nuo ','Ti ','Cha ','Tui ','Jian ','Dao ','Tha ','Xi ','Ta ','Qiang ','Zhan ','Chan ','Ti ',
        'Ji ','Nie ','Man ','Liu ','Zhan ','Bi ','Chong ','Lu ','Liao ','Cu ','Tang ','Dai ','Toc ','Xi ','Kui ','Ji ',
        'Zhi ','Qiang ','Di ','Pan ','Zong ','Lian ','Beng ','Zao ','Nian ','Bie ','Tui ','Ju ','Deng ','Ceng ','Xian ','Fan ',
        'Chu ','Zhong ','Dun ','Bo ','Cu ','Zu ','Jue ','Jue ','Lin ','Ta ','Qiao ','Qiao ','Pu ','Liao ','Dun ','Cuan ',
        'Kuang ','Zao ','Ta ','Bi ','Bi ','Ghen ','Ju ','Chu ','Qiao ','Dun ','Tru ','Ji ','Wu ','Yue ','Nian ','Lin ',
        'Lie ','Zhi ','Li ','Zhi ','Chan ','Chu ','Duan ','Wei ','Long ','Lin ','Xian ','Wei ','Zuan ','Lan ','Xie ','Rang ',
        'Xie ','Nie ','Ta ','Qu ','Jie ','Cuan ','Zuan ','Xi ','Kui ','Jue ','Lin ','Than ','Cung ','Dan ','Segare ','Qu ',
        'Ti ','Duo ','Duo ','Gong ','Lang ','Nerau ','Luo ','Ai ','Ji ','Ju ','Tang ','Utsuke ','','Yan ','Shitsuke ','Kang ',
        'Xo ','Lou ','Lao ','Tuo ','Zhi ','Yagate ','Ti ','Dao ','Yagate ','Yu ','Xa ','Ya ','Gui ','Quan ','Wei ','Ngot ',
        'Xin ','Di ','Xuan ','Fan ','Ren ','Shan ','Qiang ','Shu ','Tun ','Chen ','Dai ','E ','Na ','Qi ','Mao ','Ruan ',
        'Ren ','Fan ','Zhuan ','Hong ','Hu ','Qu ','Huang ','Di ','Ling ','Dai ','Ao ','Zhen ','Fan ','Kuang ','Ang ','Peng ',
        'Bei ','Gu ','Gu ','Pao ','Zhu ','Rong ','E ','Ba ','Truc ','Zhi ','Yao ','Ke ','Yi ','Qing ','Shi ','Ping ',
        ],
    'x8f':[
        'Er ','Qiong ','Ju ','Jiao ','Guang ','Lu ','Kai ','Quan ','Zhou ','Zai ','Zhi ','She ','Liang ','Yu ','Shao ','You ',
        'Huan ','Yun ','Zhe ','Wan ','Fu ','Khinh ','Zhou ','Ni ','Ling ','Zhe ','Zhan ','Liang ','Zi ','Huy ','Wang ','Chuo ',
        'Guo ','Kan ','Yi ','Peng ','Qian ','Gun ','Nian ','Pian ','Guan ','Boi ','Luan ','Pai ','Liang ','Ruan ','Rou ','Ji ',
        'Yang ','Xian ','Chuan ','Cou ','Chun ','Ge ','You ','Hong ','Thau ','Fu ','Zi ','Fu ','Wen ','Ben ','Zhan ','Yu ',
        'Wen ','Tao ','Gu ','Zhen ','Xia ','Yuan ','Lu ','Jiu ','Chao ','Zhuan ','Wei ','Hun ','Sori ','Che ','Jiao ','Zhan ',
        'Pu ','Lao ','Fen ','Fan ','Lin ','Ge ','Se ','Kan ','Huan ','Yi ','Ji ','Dui ','Er ','Yu ','Xian ','Hong ',
        'Lei ','Pei ','Li ','Li ','Lu ','Lin ','Che ','Ya ','Gui ','Xuan ','Di ','Ren ','Zhuan ','E ','Lun ','Ruan ',
        'Hong ','Gu ','Ke ','Lu ','Zhou ','Zhi ','Yi ','Hu ','Zhen ','Li ','Yao ','Qing ','Shi ','Zai ','Zhi ','Jiao ',
        'Zhou ','Quan ','Lu ','Jiao ','Zhe ','Fu ','Liang ','Nian ','Bei ','Hui ','Gun ','Wang ','Liang ','Chuo ','Zi ','Cou ',
        'Fu ','Ji ','Wen ','Shu ','Pei ','Yuan ','Xia ','Zhan ','Lu ','Che ','Lin ','Tan ','Gu ','Ci ','Ci ','Pi ',
        'Zui ','Bian ','La ','La ','Ci ','Xue ','Ban ','Bian ','Bian ','Bian ','','Bian ','Ban ','Ci ','Bian ','Bian ',
        'Chen ','Nhoc ','Nong ','Nong ','Zhen ','Chuo ','Chuo ','Suberu ','Reng ','Bian ','Bian ','Tsuji ','Komu ','Liao ','Da ','Chan ',
        'Gan ','Qian ','Vu ','Yu ','Hat ','Xun ','Yi ','Guo ','Mai ','Qi ','Za ','Wang ','tu ','Zhun ','Ying ','Ti ',
        'Yun ','Jin ','Hang ','Ya ','Fan ','Wu ','Da ','E ','Huan ','Zhe ','Totemo ','Jin ','Yuan ','Wei ','Lian ','Chi ',
        'Che ','Ni ','Tiao ','Zhi ','Yi ','Jiong ','Da ','Chen ','Dai ','Er ','Di ','Po ','Wang ','Die ','Ze ','Tao ',
        'Shu ','Tuo ','Kep ','Jing ','Hui ','Tong ','You ','Mi ','Beng ','Ji ','Nai ','Yi ','Jie ','Truy ','Luot ','Xun ',
        ],
    'x90':[
        'Tui ','Tong ','Shi ','Tao ','Pang ','Hou ','Ni ','Dun ','Jiong ','Xuan ','Xun ','Bu ','You ','Xiao ','Tua ','Thau ',
        'Truc ','Qiu ','Di ','Di ','Tu ','Jing ','Ti ','Dou ','Yi ','Zhe ','Tong ','Guang ','Wu ','Shi ','Cheng ','Toc ',
        'Zao ','Qun ','Phung ','Lian ','Suo ','Hui ','Li ','Sako ','Lai ','Ben ','Cuo ','Jue ','Beng ','Huan ','Dai ','Lu ',
        'You ','Chu ','Jin ','Yu ','Ruoc ','Kui ','Wei ','Ti ','Yi ','Da ','Yuan ','Luo ','Bi ','Nuo ','Du ','Dang ',
        'Sui ','Tron ','Sui ','Yan ','Chuan ','Chi ','Ti ','Ngo ','Shi ','Zhen ','Du ','Yun ','E ','Bian ','Guo ','E ',
        'Xia ','Huang ','Qiu ','Dao ','Da ','Vi ','Appare ','Yi ','Gou ','Yao ','Chu ','Liu ','Xun ','Ta ','Di ','Chi ',
        'Yuan ','Su ','Ta ','Qian ','','Yao ','Guan ','Zhang ','Ngao ','Shi ','Ce ','Chi ','Su ','Tao ','Zhe ','Ron ',
        'Di ','Lou ','Chi ','Cuo ','Lin ','Tuan ','Rao ','Qian ','Xuan ','Yu ','Di ','Wu ','Liao ','Ju ','Shi ','Bi ',
        'Yao ','Mai ','Xie ','Sui ','Hoan ','Zhan ','Teng ','Er ','Miao ','Bian ','Bian ','La ','Li ','Yuan ','Yao ','Luo ',
        'Li ','Yi ','Ting ','Deng ','Qi ','Yong ','Shan ','Han ','Yu ','Muong ','Ru ','Qiong ','','Kuang ','Fu ','Kang ',
        'Bin ','Fang ','Xing ','Na ','','Shen ','Vang ','Yuan ','Cun ','Huo ','Ta ','Bang ','Wu ','Ju ','You ','Han ',
        'Tai ','Qiu ','Bi ','Pei ','Bing ','Shao ','Bei ','Wa ','Di ','Zou ','Ye ','Lin ','Kuang ','Gui ','Chau ','Shi ',
        'Ku ','Yu ','Gai ','He ','Xi ','Zhi ','Ji ','Xun ','Hou ','Xing ','Jiao ','Xi ','Gui ','Nuo ','Lang ','Jia ',
        'Kuai ','Zheng ','Rou ','Yun ','Yan ','Cheng ','Dou ','Chi ','Lu ','Fu ','Wu ','Fu ','Gao ','Hao ','Lang ','Jia ',
        'Geng ','Jun ','Ying ','Bo ','Xi ','Bei ','Li ','Yun ','Bo ','Xiao ','Qi ','Pi ','Qing ','Guo ','','Tan ',
        'Zou ','Ping ','Lai ','Ni ','Chen ','You ','Bu ','Xiang ','Dan ','Ju ','Yong ','Qiao ','Yi ','Du ','Yan ','Mei ',
        ],
    'x91':[
        'Ruo ','Bei ','E ','Yu ','Juan ','Yu ','Yun ','Hou ','Kui ','Xiang ','Xiang ','Sou ','Tang ','Ming ','Xi ','Ru ',
        'Chu ','Zi ','Zou ','Ju ','Wu ','Huong ','Yun ','Hao ','Yong ','Bi ','Mo ','Chao ','Fu ','Liao ','Yin ','Zhuan ',
        'Hu ','Qiao ','Yan ','Zhang ','Man ','Qiao ','Xu ','Deng ','Bi ','Xin ','Bi ','Ceng ','Wei ','Zheng ','Mao ','Shan ',
        'Lan ','Po ','Dan ','Meng ','Ye ','Cao ','Kuai ','Feng ','Meng ','Zou ','Kuang ','Lian ','Zan ','Chan ','You ','Qi ',
        'Yan ','Chan ','Zan ','Ling ','Huan ','Xi ','Feng ','Zan ','Li ','Dau ','Ding ','Qiu ','Chuoc ','Phoi ','Zhou ','Yi ',
        'Hang ','Yu ','Jiu ','Yan ','Zui ','Mao ','Dan ','Xu ','Tou ','Zhen ','Fen ','Sakenomoto ','','Yun ','Tai ','Tian ',
        'Qia ','Tuo ','Zuo ','Han ','Gu ','Su ','Po ','Chou ','Zai ','Ming ','Lao ','Chuo ','Thu ','You ','Tong ','Zhi ',
        'Xian ','Jiang ','Xanh ','Yin ','Tu ','Jiao ','Mei ','Khoc ','Suan ','Lei ','Pu ','Zui ','Hai ','Yan ','Xi ','Niang ',
        'Wei ','Lu ','Lan ','Yan ','Tao ','Pei ','Zhan ','Chun ','Tan ','Zui ','Chuo ','Cu ','Kun ','Ti ','Mian ','Du ',
        'Hu ','Xu ','Xing ','Tan ','Jiu ','Chun ','Yun ','Po ','Ke ','Sou ','Mi ','Quan ','Xau ','Say ','Yun ','Yong ',
        'Ang ','Zha ','Hai ','Tang ','Jiang ','Piao ','Shan ','Yu ','Li ','Zao ','Lao ','Y ','Tuong ','Bu ','Jiao ','Xi ',
        'Tan ','Po ','Nong ','Yi ','Li ','Ju ','Jiao ','Yi ','Niang ','Ru ','Xun ','Chou ','Yan ','Ling ','Mi ','Mi ',
        'Niang ','Xin ','Jiao ','Xi ','Mi ','Yan ','Bian ','Cai ','Shi ','You ','Shi ','Shi ','Li ','Trong ','Ye ','Liang ',
        'Li ','Kim ','','Ga ','Yi ','Liao ','Dao ','Zhao ','Ding ','Po ','Qiu ','He ','Fu ','Cham ','Zhi ','Ngoat ',
        'Luan ','Fu ','Nai ','Diao ','Shan ','Qiao ','Kou ','Chuan ','Zi ','Fan ','Yu ','Hua ','Han ','Cong ','Qi ','Mang ',
        'Ri ','Di ','Si ','Xi ','Yi ','Thoa ','Shi ','Tu ','Xi ','Nu ','Qian ','Kyuu ','Jian ','Pi ','Ye ','Yin ',
        ],
    'x92':[
        'Ba ','Fang ','Chen ','Xing ','Dou ','Yue ','Yan ','Fu ','Pi ','Na ','Xin ','E ','Khoet ','Nhon ','Gou ','Yin ',
        'Qian ','Ban ','Ji ','Ren ','Chao ','Niu ','Fen ','Yun ','Ji ','Qin ','Pi ','Guo ','Hong ','Yin ','Jun ','Shi ',
        'Yi ','Zhong ','Nie ','Gai ','Ri ','Huo ','Tai ','Kang ','Habaki ','Ro ','Ngaak ','','Duo ','Zi ','Ban ','Tu ',
        'Shi ','Min ','Gu ','Ke ','Ling ','Bing ','Yi ','Gu ','Bo ','Pi ','Yu ','Si ','Zuo ','Bua ','You ','Dian ',
        'Jia ','Zhen ','Shi ','Shi ','Tie ','Ju ','Chan ','Shi ','Shi ','Xuan ','Zhao ','Bao ','He ','Bi ','Sheng ','Chu ',
        'Shi ','Bo ','Zhu ','Chi ','Za ','Po ','Tong ','Qian ','Fu ','Zhai ','Liu ','Qian ','Fu ','Li ','Yue ','Pi ',
        'Yang ','Ban ','Bo ','Jie ','Cau ','Shu ','Zheng ','Mu ','Ni ','Nie ','Di ','Jia ','Mu ','Dan ','Shen ','Yi ',
        'Si ','Kuang ','Ka ','Bei ','Jian ','Tong ','Xing ','Hong ','Jiao ','Chi ','Er ','Ge ','Bing ','Shi ','Mou ','Ha ',
        'Ngan ','Jun ','Zhou ','Sung ','Shang ','Tong ','Mo ','Lei ','Ji ','Yu ','Nhong ','Ren ','Zun ','Zhi ','Qiong ','Shan ',
        'Chi ','Ten ','Xing ','Quan ','Pi ','Tie ','Zhu ','Hou ','Ming ','Gio ','Yao ','Xian ','Xian ','Xiu ','Jun ','Cha ',
        'Lao ','Ji ','Pi ','Ru ','Mi ','Yi ','Yin ','Guang ','An ','Diu ','You ','Se ','Kao ','Qian ','Luan ','Kasugai ',
        'Ai ','Diao ','Han ','Rui ','Shi ','Keng ','Qiu ','Tiu ','Zhe ','Xiu ','Zang ','Ti ','Cuo ','Gua ','Gong ','Zhong ',
        'Dou ','Lu ','Mei ','Lang ','Wan ','Xin ','Yun ','Bei ','Wu ','Su ','Yu ','Chan ','Ting ','Bo ','Han ','Jia ',
        'Hong ','Cuan ','Feng ','Chan ','Wan ','Zhi ','Si ','Xuan ','Wu ','Wu ','Tiao ','Gong ','Zhuo ','Lue ','Xing ','Xam ',
        'Shen ','Han ','Lue ','Xie ','Chu ','Cat ','Cuoc ','Xian ','Tie ','Mang ','Pho ','Li ','Pan ','Nhon ','Cheng ','Gao ',
        'Li ','Te ','Lap ','Zhu ','','Tu ','Liu ','Zui ','Cua ','Chang ','Yuan ','Jian ','Gang ','Diao ','Tao ','Chang ',
        ],
    'x93':[
        'Lun ','Guo ','Ling ','Bei ','Lu ','Li ','Thanh ','Pou ','Juan ','Min ','Zui ','Peng ','An ','Pi ','Xian ','Ya ',
        'Dui ','Lei ','A ','Kong ','Ta ','Kun ','Du ','Wei ','Chui ','Zi ','Tranh ','Ben ','Nie ','Cong ','Dui ','Tan ',
        'Ding ','Qi ','Qian ','Zhuo ','Qi ','Yu ','Gam ','Guan ','Mao ','Chang ','Tian ','Xi ','Lian ','Tao ','Gu ','Cuo ',
        'Shu ','Zhen ','Lu ','Meng ','Lu ','Hua ','Biao ','Ga ','Lai ','Ken ','Kazari ','Bu ','Nai ','Wan ','Zan ','',
        'De ','Xian ','','Huo ','Liang ','','Men ','Kai ','Ying ','Di ','Lian ','Guo ','Xian ','Du ','Tu ','Wei ',
        'Cong ','Fu ','Rou ','Ji ','E ','Rou ','Chen ','Ti ','Zha ','Hong ','Yang ','Duan ','Xia ','Yu ','Keng ','Xing ',
        'Huang ','Wei ','Fu ','Zhao ','Cha ','Qie ','She ','Hong ','Kui ','Tian ','Mou ','Qiao ','Qiao ','Hou ','Thau ','Cong ',
        'Huan ','Ye ','Min ','Jian ','Duan ','Jian ','Si ','Kui ','Hu ','Xuan ','Zhe ','Jie ','Cham ','Bian ','Chung ','Zi ',
        'Xiu ','Ye ','Mei ','Pai ','Ai ','Jie ','','Mei ','Chuo ','Ta ','Bang ','Xia ','Guom ','Suo ','Xi ','Liu ',
        'Zu ','Ye ','Nou ','Weng ','Rong ','Tang ','Suo ','Thuong ','Ge ','Shuo ','Chui ','Bo ','Pan ','Sa ','Bi ','Sang ',
        'Gang ','Zi ','Wu ','Ying ','Huang ','Tiao ','Liu ','Kai ','Sun ','Sha ','Sou ','Wan ','Nhum ','Zhen ','Tran ','Luo ',
        'Yi ','Yuan ','Tang ','Nie ','Xi ','Jia ','Ge ','Ma ','Juan ','Kasugai ','Habaki ','Suo ','','','','Na ',
        'Lu ','Suo ','Ou ','Zu ','Tuan ','Xiu ','Guan ','Xuan ','Lian ','Shou ','Ao ','Man ','Mo ','Luo ','Bi ','Wei ',
        'Liu ','Di ','Qiao ','Cong ','Yi ','Lu ','Ao ','Tret ','Qiang ','Cui ','Qi ','Chang ','Tang ','Man ','Yong ','Chan ',
        'Feng ','Jing ','Tiu ','Shu ','Lou ','Xiu ','Cong ','Long ','Zan ','Jian ','Cao ','Li ','Xia ','Xi ','Kang ','',
        'Beng ','','','Zheng ','Lu ','Hua ','Ji ','Pu ','Hui ','Qiang ','Po ','Lin ','Suo ','Xiu ','San ','Cheng ',
        ],
    'x94':[
        'Kui ','Si ','Liu ','Nao ','Heng ','Pie ','Sui ','Fan ','Qiao ','Quan ','Yang ','Tang ','Xiang ','Jue ','Jiao ','Zun ',
        'Banh ','Jie ','Lao ','Dui ','Tan ','Zan ','Ji ','Jian ','Zhong ','Deng ','Ya ','Ying ','Dui ','Jue ','Nou ','Ti ',
        'Pu ','Tie ','','','Ding ','Shan ','Kai ','Jian ','Fei ','Sui ','Lu ','Juan ','Hui ','Yu ','Lian ','Zhuo ',
        'Khuan ','Qian ','Zhuo ','Lei ','Bi ','Tie ','Huan ','Ye ','Duo ','Guo ','Dang ','Ju ','Fen ','Da ','Bei ','Yi ',
        'Ai ','Zong ','Xun ','Diao ','Zhu ','Heng ','Zhui ','Ji ','Nie ','Ta ','Huo ','Qing ','Bin ','Ying ','Kui ','Ning ',
        'Xu ','Jian ','Jian ','Yari ','Cha ','Zhi ','Mie ','Li ','Lei ','Ji ','Zuan ','Kuang ','Shang ','Peng ','La ','Du ',
        'Thuoc ','Chuo ','Lu ','Biao ','Bao ','Lu ','','Thoa ','Long ','E ','Lu ','Xin ','Jian ','Lan ','Bo ','Jian ',
        'Yao ','Chan ','Xiang ','Jian ','Xi ','Guan ','Cang ','Nie ','Lei ','Cuan ','Qu ','Pan ','La ','Zuan ','Luan ','Zao ',
        'Nie ','Jue ','Tang ','Shu ','Lan ','Jin ','Qiu ','Yi ','Zhen ','Ding ','Zhao ','Po ','Diao ','Tu ','Qian ','Chuan ',
        'Shan ','Ji ','Fan ','Diao ','Men ','Nu ','Xi ','Chai ','Xing ','Gai ','Bu ','Tai ','Ju ','Dun ','Chao ','Zhong ',
        'Na ','Bei ','Gang ','Ban ','Qian ','Yao ','Qin ','Jun ','Wu ','Gou ','Kang ','Fang ','Huo ','Dou ','Niu ','Ba ',
        'Yu ','Qian ','Zheng ','Qian ','Gu ','Bo ','E ','Po ','Bu ','Ba ','Yue ','Zuan ','Mu ','Dan ','Jia ','Dian ',
        'You ','Tie ','Bo ','Ling ','Shuo ','Qian ','Liu ','Bao ','Shi ','Xuan ','She ','Bi ','Ni ','Pi ','Duo ','Xing ',
        'Kao ','Lao ','Er ','Mang ','Ya ','You ','Cheng ','Jia ','Ye ','Nao ','Zhi ','Dang ','Tong ','Lu ','Diao ','Yin ',
        'Kai ','Zha ','Zhu ','Xian ','Ting ','Diu ','Xian ','Hua ','Quan ','Sha ','Jia ','Yao ','Ge ','Ming ','Zheng ','Se ',
        'Jiao ','Yi ','Chan ','Chong ','Tang ','An ','Yin ','Ru ','Zhu ','Lao ','Pu ','Wu ','Lai ','Te ','Lian ','Keng ',
        ],
    'x95':[
        'Xiao ','Suo ','Li ','Zheng ','Chu ','Guo ','Gao ','Tie ','Xiu ','Cuo ','Lue ','Feng ','Xin ','Liu ','Kai ','Jian ',
        'Rui ','Ti ','Lang ','Qian ','Ju ','A ','Qiang ','Duo ','Tian ','Cuo ','Mao ','Ben ','Qi ','De ','Kua ','Kun ',
        'Chang ','Xi ','Gu ','Luo ','Chui ','Zhui ','Jin ','Zhi ','Xian ','Juan ','Huo ','Pou ','Tan ','Ding ','Jian ','Ju ',
        'Meng ','Zi ','Qie ','Ying ','Kai ','Qiang ','Song ','E ','Cha ','Qiao ','Zhong ','Duan ','Sou ','Huang ','Huan ','Ai ',
        'Du ','Mei ','Lou ','Zi ','Fei ','Mei ','Mo ','Zhen ','Bo ','Ge ','Nie ','Tang ','Juan ','Nie ','Na ','Liu ',
        'Hao ','Bang ','Yi ','Jia ','Bin ','Rong ','Biao ','Tang ','Man ','Luo ','Beng ','Yong ','Jing ','Di ','Zu ','Xuan ',
        'Liu ','Tan ','Jue ','Liao ','Pu ','Lu ','Dui ','Lan ','Pu ','Cuan ','Qiang ','Deng ','Huo ','Lei ','Huan ','Zhuo ',
        'Lian ','Yi ','Cha ','Biao ','La ','Chan ','Xiang ','Chang ','Chang ','Jiu ','Ao ','Die ','Qu ','Liao ','Mi ','Chang ',
        'Men ','Ma ','Shuan ','Shan ','Huo ','Men ','Yan ','Bi ','Han ','Bi ','Tsukaeru ','Khai ','Kang ','Beng ','Hong ','Run ',
        'San ','Nhan ','Xian ','Gian ','Min ','Xia ','Yuru ','Dou ','Zha ','Nao ','','Peng ','Xia ','Ling ','Bian ','Bi ',
        'Run ','He ','Guan ','Ge ','Ge ','Fa ','Chu ','Hong ','Gui ','Min ','Hai ','Kun ','Lang ','Lu ','Ting ','Sha ',
        'Ju ','Yue ','Yue ','Chan ','Qu ','Lin ','Chang ','Shai ','Kun ','Yan ','Wen ','Yan ','E ','Hun ','Vac ','Wen ',
        'Xiang ','Bao ','Xiang ','Qu ','Yao ','Wen ','Ban ','An ','Wei ','Yin ','Kuo ','Que ','Lan ','Du ','','Phwung ',
        'Tian ','Nie ','Ta ','Kai ','He ','Que ','Sam ','Guan ','Dou ','Qi ','Kui ','Tang ','Quan ','Piao ','Kan ','Xi ',
        'Hui ','Xen ','Pi ','Dang ','Huan ','Ta ','Wen ','','Men ','Shuan ','Shan ','Yan ','Han ','Bi ','Wen ','Chuang ',
        'Run ','Wei ','Xian ','Hong ','Jian ','Min ','Kang ','Men ','Zha ','Nao ','Gui ','Wen ','Ta ','Min ','Lu ','Kai ',
        ],
    'x96':[
        'Fa ','Ge ','He ','Kun ','Jiu ','Yue ','Lang ','Du ','Yu ','Yan ','Chang ','Xi ','Wen ','Hun ','Yan ','E ',
        'Chan ','Lan ','Qu ','Hui ','Kuo ','Que ','Ge ','Tian ','Ta ','Que ','Kan ','Huan ','Fu ','Fu ','Le ','Dui ',
        'Xin ','Qian ','Wu ','Yi ','Tuo ','Yin ','Yang ','Dou ','E ','Sheng ','Ban ','Pei ','Keng ','Yun ','Ruan ','Zhi ',
        'Pi ','Jing ','Fang ','Yang ','Yin ','Zhen ','Jie ','Cheng ','E ','Qu ','Di ','Zu ','Zuo ','Dian ','Ling ','A ',
        'Tuo ','Tuo ','Bei ','Bing ','Fu ','Ji ','Lu ','Long ','Chen ','Xing ','Duo ','Lou ','Mo ','Jiang ','Shu ','Duo ',
        'Xian ','Er ','Gui ','Yu ','Gai ','Shan ','Xun ','Qiao ','Xing ','Chun ','Fu ','Bi ','Xia ','Shan ','Thang ','Zhi ',
        'Pu ','Dou ','Yuan ','Zhen ','Chu ','Xian ','Tou ','Nie ','Yun ','Xian ','Pei ','Pei ','Zou ','Yi ','Dui ','Lun ',
        'Yin ','Ju ','Chui ','Chen ','Pi ','Lang ','Tao ','Xian ','Luc ','','Xian ','Yin ','Zhu ','Duong ','Reng ','Shan ',
        'Chong ','Yan ','Yin ','Yu ','Di ','Yu ','Long ','Wei ','Wei ','Nie ','Dui ','Sui ','An ','Huang ','Giai ','Sui ',
        'Yin ','Gai ','Yan ','Hui ','Ge ','Yun ','Wu ','Wei ','Ai ','Xi ','Tang ','Ji ','Chuong ','Dao ','Ao ','Xi ',
        'Yin ','','Rao ','Lin ','Tui ','Deng ','Pi ','Sui ','Sui ','Yu ','Xian ','Fen ','Ni ','Er ','Ji ','Dao ',
        'Thap ','Yin ','E ','Hui ','Luong ','Xi ','Li ','Li ','Li ','Zhui ','He ','Zhi ','Zhun ','Jun ','Nan ','Yi ',
        'Tuoc ','Yan ','Qin ','Ya ','Hung ','Ya ','Ji ','Gu ','Huan ','Zhi ','Gou ','Tuan ','Thu ','Yong ','Ju ','Chu ',
        'Hu ','Za ','Luo ','Yu ','Chou ','Diao ','Tuy ','Han ','Huo ','Song ','Guan ','Chu ','Za ','Yong ','Ji ','Xi ',
        'Chou ','Liu ','Li ','Nan ','Xue ','Za ','Ji ','Ji ','Yu ','Yu ','Xue ','Na ','Fou ','Se ','Mu ','Wen ',
        'Fen ','Pang ','Van ','Li ','Li ','Ang ','Ling ','Lei ','An ','Bao ','Meng ','Dian ','Dang ','Xing ','Wu ','Zhao ',
        ],
    'x97':[
        'Xu ','Ji ','Mu ','Chen ','Xiao ','Zha ','Ting ','Zhen ','Pei ','Mei ','Ling ','Qi ','Chou ','Hoac ','Sha ','Phay ',
        'Weng ','Zhan ','Yin ','Nghi ','Zhu ','Tun ','Lam ','','Dong ','Ying ','Wu ','Ling ','Suong ','Ling ','Xia ','Hong ',
        'Yin ','Mo ','Mai ','Yun ','Liu ','Meng ','Bin ','Vu ','Wei ','Huo ','Yin ','Xi ','Yi ','Ai ','Dan ','Deng ',
        'Xian ','Yu ','Lo ','Long ','Dai ','Ji ','Pang ','Yang ','Ba ','Pi ','Wei ','','Xi ','Ji ','Mai ','Meng ',
        'Mong ','Lei ','Li ','Huo ','Ai ','Fei ','Dai ','Long ','Linh ','Ai ','Feng ','Li ','Bao ','','He ','He ',
        'Bing ','Qing ','Thanh ','Jing ','Tian ','Zhen ','Jing ','Cheng ','Qing ','Jing ','Jing ','Dian ','Jing ','Tian ','Phi ','Fei ',
        'Kao ','Mi ','Mian ','Mian ','Pao ','Ye ','Tian ','Hui ','Ye ','Ge ','Ding ','Cha ','Jian ','Ren ','Di ','Du ',
        'Wu ','Ren ','Qin ','Jin ','Xue ','Niu ','Ba ','Yin ','Sa ','Na ','Mo ','Zu ','Da ','Ban ','Yi ','Yao ',
        'Tao ','Tuo ','Jia ','Hong ','Pao ','Yang ','Tomo ','Yin ','Jia ','Tao ','Ji ','Hai ','An ','An ','Hen ','Gong ',
        'Kohaze ','Da ','Qiao ','Ting ','Wan ','Ying ','Sui ','Tiao ','Qiao ','Xuan ','Kong ','Beng ','Ta ','Zhang ','Bing ','Kuo ',
        'Cuc ','La ','Xie ','Rou ','Bang ','Yi ','Qiu ','Qiu ','He ','Xiao ','Mu ','Ju ','Jian ','Bian ','Di ','Jian ',
        'On ','Tao ','Gou ','Ta ','Bei ','Xie ','Pan ','Ge ','Bi ','Kuo ','Tou ','Lou ','Gui ','Qiao ','Xue ','Ji ',
        'Jian ','Cuong ','Chan ','Da ','Huo ','Xian ','Qian ','Du ','Wa ','Jian ','Lan ','Wei ','Ren ','Fu ','Mei ','Juan ',
        'Ge ','Wei ','Qiao ','Han ','Chang ','','Rou ','Xun ','She ','Wei ','Ge ','Bei ','Tao ','Gou ','Yun ','',
        'Bi ','Wei ','Hui ','Du ','Wa ','Du ','Wei ','Ren ','Fu ','Han ','Wei ','Yun ','Tao ','Jiu ','Jiu ','Xian ',
        'Xie ','Xian ','Ji ','Yin ','Za ','Yun ','Shao ','Le ','Peng ','Heng ','Ying ','Yun ','Peng ','Yin ','Yin ','Huong ',
        ],
    'x98':[
        'Hu ','Ye ','Ding ','Qing ','Kui ','Xiang ','Shun ','Han ','Tua ','Yi ','Xu ','Gu ','Tung ','Kui ','Qi ','Hang ',
        'Yu ','Ngoan ','Ban ','Dun ','Di ','Dan ','Pan ','Po ','Ling ','Ce ','Jing ','Lei ','He ','Qiao ','E ','E ',
        'Wei ','Jie ','Gua ','Shen ','Yi ','Shen ','Hai ','Dui ','Pian ','Ping ','Lei ','Fu ','Jia ','Tou ','Hui ','Kui ',
        'Jia ','Le ','Ting ','Cheng ','Ying ','Jun ','Hu ','Han ','Jing ','Tui ','Tui ','Pin ','Lai ','Tui ','Zi ','Zi ',
        'Chui ','Ding ','Lai ','Yan ','Han ','Jian ','Ke ','Cui ','Jiong ','Qin ','Yi ','Sai ','Ti ','E ','E ','Yan ',
        'Hun ','Kan ','Dong ','Zhuan ','Nhan ','Xian ','Xin ','Yi ','Yuan ','Sang ','Dian ','Dian ','Jiang ','Ku ','Lei ','Liao ',
        'Piao ','Yi ','Man ','Qi ','Rao ','Hao ','Qiao ','Co ','Xun ','Qian ','Hui ','Zhan ','Ru ','Hong ','Bin ','Xian ',
        'Pin ','Lu ','Lan ','Nie ','Quan ','Ye ','Ding ','Qing ','Han ','Xiang ','Shun ','Xu ','Xu ','Wan ','Gu ','Dun ',
        'Qi ','Ban ','Song ','Hang ','Yu ','Lu ','Ling ','Po ','Jing ','Jie ','Jia ','Tian ','Han ','Ying ','Jiong ','Hai ',
        'Yi ','Pin ','Hui ','Tui ','Han ','Ying ','Ying ','Ke ','Ti ','Yong ','E ','Zhuan ','Yan ','E ','Nie ','Man ',
        'Dian ','Sang ','Hao ','Lei ','Zhan ','Ru ','Pin ','Quan ','Phong ','Biao ','Oroshi ','Fu ','Xia ','Zhan ','Biao ','Sa ',
        'Ba ','Tai ','Lie ','Gua ','Xuan ','Shao ','Ju ','Bi ','Si ','Wei ','Yang ','Yao ','Sou ','Kai ','Sao ','Fan ',
        'Liu ','Xi ','Liao ','Piao ','Piao ','Liu ','Biao ','Biao ','Biao ','Liao ','','Se ','Feng ','Biao ','Feng ','Yang ',
        'Zhan ','Biao ','Sa ','Ju ','Si ','Sou ','Yao ','Liu ','Piao ','Biao ','Biao ','Phi ','Fan ','Fei ','Fei ','Shi ',
        'Shi ','Can ','Co ','Ding ','Si ','Tuo ','Zhan ','Sun ','Xiang ','Tun ','Ren ','Yu ','Juan ','Chi ','Yin ','Fan ',
        'Fan ','Sun ','Yin ','Zhu ','Yi ','Zhai ','Bi ','Jie ','Tao ','Liu ','Ci ','Tie ','Si ','Bao ','Shi ','Duo ',
        ],
    'x99':[
        'Hai ','Ren ','Tian ','Jiao ','Jia ','Bing ','Yao ','Tong ','Ci ','Xiang ','Yang ','Yang ','Er ','Yan ','Le ','Yi ',
        'Can ','Bo ','Nei ','E ','Bu ','Jun ','Dou ','Su ','Du ','Shi ','Yao ','Hun ','Guo ','Shi ','Jian ','Zhui ',
        'Bing ','Xian ','Bu ','Ye ','Tan ','Fei ','Zhang ','Wei ','Guan ','E ','Nuan ','Hun ','Hu ','Huang ','Tie ','Hui ',
        'Jian ','Hou ','He ','Xing ','Fen ','Wei ','Gu ','Cha ','Song ','Tang ','Bo ','Gao ','Xi ','Kui ','Liu ','Sou ',
        'Tao ','Ye ','Yun ','Mo ','Tang ','Man ','Bi ','Yu ','Xiu ','Jin ','San ','Kui ','Zhuan ','Shan ','Chi ','Dan ',
        'Yi ','Co ','Rao ','Cheng ','Yong ','Tao ','Hui ','Xiang ','Zhan ','Fen ','Hai ','Meng ','Yan ','Mo ','Chan ','Xiang ',
        'Luo ','Zuan ','Nang ','Shi ','Ding ','Ji ','Tuo ','Xing ','Tun ','Xi ','Ren ','Yu ','Chi ','Fan ','Yin ','Jian ',
        'Shi ','Bao ','Si ','Duo ','Yi ','Er ','Rao ','Xiang ','Jia ','Le ','Jiao ','Yi ','Bing ','Bo ','Dou ','E ',
        'Yu ','Nei ','Jun ','Guo ','Hun ','Xian ','Guan ','Cha ','Kui ','Gu ','Sou ','Chan ','Ye ','Mo ','Bo ','Liu ',
        'Xiu ','Jin ','Man ','San ','Zhuan ','Nang ','Shou ','Kui ','Guo ','Huong ','Fen ','Ba ','Ni ','Bi ','Bo ','Tu ',
        'Han ','Fei ','Jian ','An ','Ai ','Fu ','Xian ','Wen ','Hanh ','Fen ','Bin ','Xing ','Ma ','Yu ','Feng ','Han ',
        'Di ','Tuo ','Tuo ','Chi ','Xun ','Zhu ','Zhi ','Pei ','Xin ','Ri ','Sa ','Yin ','Wen ','Zhi ','Dan ','Lu ',
        'You ','Bo ','Bao ','Kuai ','Tuo ','Yi ','Qu ','','Qu ','Jiong ','Bo ','Zhao ','Yuan ','Peng ','Zhou ','Ju ',
        'Tru ','Nu ','Cau ','Pi ','Zang ','Jia ','Ling ','Zhen ','Tai ','Fu ','Yang ','Shi ','Bi ','Tuo ','Tuo ','Si ',
        'Liu ','Ma ','Pian ','Tao ','Zhi ','Rong ','Teng ','Dong ','Xun ','Quan ','Shen ','Jiong ','Er ','Hai ','Bo ','',
        'Yin ','Luo ','Shuu ','Dan ','Xie ','Liu ','Ju ','Song ','Xam ','Mang ','Liang ','Han ','Tu ','Xuan ','Tui ','Tuan ',
        ],
    'x9a':[
        'E ','Cheng ','Xing ','Ai ','Lu ','Choai ','Zhou ','She ','Pian ','Kun ','Tao ','Lai ','Zong ','Ke ','Qi ','Qi ',
        'Yan ','Fei ','Sao ','Yan ','Jie ','Yao ','Wu ','Pian ','Cong ','Pian ','Qian ','Fei ','Huang ','Jian ','Huo ','Yu ',
        'Ti ','Quan ','Xia ','Zong ','Kui ','Rou ','Si ','Gua ','Tuo ','Kui ','Sou ','Qian ','Cheng ','Zhi ','Liu ','Pang ',
        'Teng ','Xi ','Cao ','Du ','Yan ','Yuan ','Zou ','Tao ','Shan ','Li ','Zhi ','Shuang ','Lu ','Xi ','Luo ','Zhang ',
        'Mo ','Ao ','Can ','Piao ','Cong ','Xui ','Bi ','Zhi ','Yu ','Xu ','Hua ','Bo ','Su ','Xiao ','Lin ','Chan ',
        'Dun ','Liu ','Tuo ','Zeng ','Tan ','Jiao ','Tie ','Yan ','Luo ','Zhan ','Kinh ','Yi ','Ye ','Tuo ','Bin ','Zou ',
        'Yan ','Peng ','Lu ','Teng ','Xiang ','Ji ','Shuang ','Ju ','Xi ','Huan ','Li ','Biao ','Ma ','Yu ','Tuo ','Xun ',
        'Chi ','Qu ','Ri ','Bo ','Lu ','Zang ','Shi ','Si ','Fu ','Ju ','Zou ','Zhu ','Tuo ','Nu ','Jia ','Yi ',
        'Tai ','Xiao ','Ma ','Yin ','Jiao ','Hua ','Luo ','Hai ','Pian ','Biao ','Li ','Cheng ','Yan ','Xin ','Qin ','Jun ',
        'Qi ','Qi ','Ke ','Zhui ','Zong ','Su ','Can ','Pian ','Zhi ','Kui ','Sao ','Wu ','Ao ','Liu ','Qian ','Shan ',
        'Piao ','Luo ','Cong ','Chan ','Zou ','Ji ','Shuang ','Xiang ','Cot ','Wei ','Wei ','Wei ','Yu ','Gan ','Yi ','Ang ',
        'Tou ','Xie ','Bao ','Bi ','Chi ','Ti ','Di ','Ku ','Hai ','Qiao ','Gou ','Kua ','Ge ','Tui ','Geng ','Pian ',
        'Bi ','Ke ','Ka ','Yu ','Sui ','Vay ','Bo ','Xiao ','Pang ','Bo ','Ci ','Kuan ','Bin ','Mo ','Liao ','Lou ',
        'Nao ','Du ','Zang ','Sui ','Ti ','Bin ','Kuan ','Lu ','Cao ','Gao ','Qiao ','Kao ','Qiao ','Lao ','Zao ','Biao ',
        'Kun ','Kun ','Ti ','Fang ','Xiu ','Ran ','Mao ','Dan ','Kun ','Bin ','Fa ','Tiao ','Pi ','Zi ','Fa ','Ran ',
        'Ti ','Pao ','Pi ','Mao ','Fu ','Er ','Rong ','Qu ','','Xiu ','Gua ','Ji ','Peng ','Zhua ','Shao ','Sha ',
        ],
    'x9b':[
        'Ti ','Li ','Ban ','Zong ','Ti ','Peng ','Song ','Zheng ','Quan ','Zong ','Shun ','Jian ','Duo ','Hu ','La ','Jiu ',
        'Qi ','Lian ','Zhen ','Bin ','Peng ','Mo ','San ','Man ','Man ','Seng ','Tu ','Lie ','Qian ','Qian ','Nong ','Huan ',
        'Kuai ','Ning ','Bin ','Lie ','Rang ','Dou ','Dou ','Nao ','Hong ','Xi ','Dou ','Han ','Dou ','Dou ','Jiu ','Chang ',
        'Yu ','Yu ','Li ','Juan ','Fu ','Qian ','Gui ','Zong ','Liu ','Gui ','Shang ','Yu ','Gui ','Mei ','Ji ','Qi ',
        'Jie ','Kui ','Hun ','Ba ','Po ','Mei ','Xu ','Yan ','Xiao ','Liang ','Yu ','Tui ','Qi ','Wang ','Liang ','Wei ',
        'Jian ','Chi ','Piao ','Bi ','Ma ','Ji ','Xu ','Chou ','Yan ','Zhan ','Ngu ','Dao ','Ren ','Ji ','Eri ','Gong ',
        'Tuo ','Diao ','Ji ','Xu ','E ','E ','Sha ','Hang ','Tun ','Mo ','Jie ','Shen ','Fan ','Yuan ','Bi ','Lu ',
        'Wen ','Hu ','Lu ','Za ','Fang ','Fen ','Na ','You ','Namazu ','Todo ','He ','Xia ','Qu ','Han ','Pi ','Ling ',
        'Tuo ','Bo ','Qiu ','Ping ','Fu ','Bi ','Ji ','Wei ','Ju ','Diao ','Bo ','You ','Gun ','Pi ','Nian ','Xing ',
        'Tai ','Bao ','Fu ','Zha ','Ju ','Gu ','Kajika ','Konoshiro ','','Ta ','Jie ','Shu ','Hou ','Xiang ','Er ','An ',
        'Wei ','Tiao ','Zhu ','Yin ','Lie ','Luo ','Tong ','Yi ','Qi ','Bing ','Wei ','Jiao ','Bu ','Gui ','Xian ','Ge ',
        'Hui ','Bora ','Mate ','Kao ','Gori ','Duo ','Jun ','Ti ','Mian ','Xiao ','Za ','Sha ','Qin ','Yu ','Nei ','Zhe ',
        'Gun ','Geng ','','Wu ','Qiu ','Ting ','Fu ','Wan ','Tiao ','Li ','Sha ','Sha ','Gao ','Meng ','Ugui ','Asari ',
        'Subashiri ','Kazunoko ','Yong ','Ni ','Zi ','Qi ','Qing ','Xiang ','Nei ','Chun ','Ji ','Diao ','Qie ','Gu ','Zhou ','Dong ',
        'Lai ','Fei ','Ni ','Yi ','Kun ','Lu ','Jiu ','Chang ','Jing ','Lun ','Ling ','Zou ','Li ','Meng ','Zong ','Zhi ',
        'Nian ','Shachi ','Dojou ','Sukesou ','Shi ','Shen ','Hun ','Shi ','Hou ','Xing ','Zhu ','La ','Zong ','Ji ','Bian ','Bian ',
        ],
    'x9c':[
        'Huan ','Quan ','Ze ','Wei ','Wei ','Yu ','Qun ','Rou ','Die ','Huang ','Lian ','Yan ','Qiu ','Qiu ','Jian ','Bi ',
        'E ','Yang ','Fu ','Sai ','Jian ','Xia ','Tuo ','Hu ','Muroaji ','Ruo ','Haraka ','Wen ','Jian ','Hao ','Wu ','Fang ',
        'Sao ','Liu ','Ma ','Shi ','Shi ','Guan ','Shi ','Teng ','Ta ','Yao ','Ge ','Rong ','Qian ','Qi ','Wen ','Ruo ',
        'Hatahata ','Lian ','Ao ','Le ','Hui ','Min ','Ji ','Tiao ','Qu ','Jian ','Sao ','Man ','Xi ','Qiu ','Biao ','Ji ',
        'Ji ','Zhu ','Jiang ','Qiu ','Zhuan ','Yong ','Zhang ','Kang ','Xue ','Bie ','Jue ','Qu ','Xiang ','Bo ','Jiao ','Xun ',
        'Su ','Huang ','Zun ','Shan ','Shan ','Fan ','Gui ','Lin ','Xun ','Ngheo ','Xi ','Eso ','Kyou ','Fen ','Guan ','Hou ',
        'Kuai ','Zei ','Sao ','Zhan ','Gan ','Gui ','Sheng ','Li ','Chang ','Hatahata ','Shiira ','Ai ','Ru ','Ji ','Xu ','Huo ',
        'Shiira ','Li ','Lie ','Li ','Mie ','Zhen ','Xiang ','E ','Lu ','Guan ','Li ','Xian ','Yu ','Dao ','Ji ','You ',
        'Tun ','Lu ','Fang ','Ba ','He ','Bo ','Ping ','Nian ','Lu ','You ','Zha ','Fu ','Bo ','Bao ','Hou ','Pi ',
        'Tai ','Gui ','Jie ','Kao ','Wei ','Er ','Tong ','Ze ','Hou ','Kuai ','Ji ','Jiao ','Xian ','Za ','Xiang ','Xun ',
        'Geng ','Li ','Lian ','Jian ','Li ','Shi ','Tiao ','Gun ','Sha ','Wan ','Jun ','Ji ','Yong ','Qing ','Ling ','Qi ',
        'Zou ','Fei ','Kun ','Chang ','Gu ','Ni ','Nian ','Diao ','Jing ','Shen ','Shi ','Zi ','Fen ','Die ','Bi ','Chang ',
        'Shi ','Wen ','Wei ','Sai ','E ','Qiu ','Fu ','Huang ','Quan ','Jiang ','Bian ','Sao ','Ao ','Qi ','Ta ','Yin ',
        'Yao ','Fang ','Jian ','Le ','Biao ','Xue ','Bie ','Man ','Min ','Yong ','Wei ','Xi ','Jue ','Shan ','Lin ','Zun ',
        'Huo ','Gan ','Li ','Zhan ','Guan ','Niao ','Yi ','Fu ','Li ','Cuu ','Bu ','Yan ','Fu ','Diao ','Ji ','Feng ',
        'Nio ','Gan ','Shi ','Feng ','Ming ','Bao ','Yuan ','Zhi ','Hu ','Qin ','Fu ','Fen ','Wen ','Jian ','Shi ','Yu ',
        ],
    'x9d':[
        'Fou ','Yao ','Jue ','Jue ','Pi ','Huan ','Zhen ','Bao ','Yan ','Ya ','Zheng ','Fang ','Feng ','Wen ','Ou ','Te ',
        'Jia ','Nu ','Ling ','Mie ','Fu ','Tuo ','Wen ','Li ','Bian ','Zhi ','Ge ','Yuan ','Zi ','Cu ','Xiao ','Chi ',
        'Dan ','Ju ','You ','Gu ','Zhong ','Yu ','Yang ','Rong ','Ya ','Tie ','Yu ','Shigi ','Ying ','Zhui ','Wu ','Er ',
        'Gua ','Ai ','Zhi ','Yan ','Heng ','Jiao ','Ji ','Lie ','Zhu ','Ren ','Yi ','Hong ','Luo ','Ru ','Mou ','Ge ',
        'Ren ','Jiao ','Xiu ','Zhou ','Zhi ','Luo ','Chidori ','Toki ','Ten ','Luan ','Jia ','Ji ','Yu ','Huan ','Tuo ','Bu ',
        'Wu ','Juan ','Coc ','Bo ','Xun ','Xun ','Bi ','Xi ','Jun ','Ju ','Tu ','Jing ','Ti ','Nga ','E ','Kuang ',
        'Hu ','Wu ','Shen ','Lai ','Ikaruga ','Kakesu ','Lu ','Ping ','Shu ','Fu ','An ','Zhao ','Peng ','Qin ','Qian ','Bei ',
        'Diao ','Lu ','Thuoc ','Jian ','Cuoc ','Tu ','Ya ','Yuan ','Qi ','Li ','Ye ','Zhui ','Kong ','Zhui ','Kun ','Sheng ',
        'Qi ','Jing ','Yi ','Yi ','Jing ','Zi ','Lai ','Dong ','Qi ','Chun ','Geng ','Ju ','Qu ','Isuka ','Kikuitadaki ','Ji ',
        'Shu ','','Chi ','Miao ','Rou ','An ','Qiu ','Ti ','Hu ','Ti ','E ','Jie ','Mao ','Fu ','Chun ','Tu ',
        'Yan ','He ','Yuan ','Pian ','Yun ','Mei ','Hu ','Ying ','Dun ','Wu ','Ju ','Tsugumi ','Cang ','Fang ','Gu ','Oanh ',
        'Yuan ','Xuan ','Weng ','Shi ','He ','Chu ','Tang ','Xia ','Ruo ','Liu ','Ji ','Gu ','Jian ','Zhun ','Han ','Zi ',
        'Zi ','Ni ','Yao ','Yan ','Ji ','Li ','Tian ','Kou ','Ti ','Ti ','Ni ','Cha ','Ma ','Jiao ','Gao ','Tian ',
        'Chen ','Li ','Zhuan ','Zhe ','Ao ','Yao ','Yi ','Ou ','Chi ','Zhi ','Liao ','Rong ','Lou ','Bi ','Shuang ','Zhuo ',
        'Yu ','Wu ','Jue ','Yin ','Quan ','Si ','Jiao ','Yi ','Hua ','Bi ','Ying ','Su ','Huang ','Fan ','Keo ','Liao ',
        'Yan ','Kao ','Jiu ','Xian ','Xian ','Tu ','Mai ','Zun ','Yu ','Ying ','Lu ','Tuan ','Xian ','Xue ','Yi ','Pi ',
        ],
    'x9e':[
        'Shu ','Luo ','Qi ','Yi ','Ji ','Zhe ','Yu ','Zhan ','Ye ','Yang ','Pi ','Ning ','Huo ','Mi ','Ying ','Meng ',
        'Di ','Yue ','Yu ','Lei ','Bao ','Lu ','He ','Long ','Shuang ','Yue ','Ying ','Guan ','Qu ','Li ','Loan ','Niao ',
        'Jiu ','Ji ','Yuan ','Ming ','Shi ','Ou ','Ya ','Cang ','Bao ','Zhen ','Gu ','Dong ','Lu ','Ya ','Xiao ','Yang ',
        'Ling ','Zhi ','Qu ','Yuan ','Xue ','Tuo ','Si ','Zhi ','Er ','Gua ','Xiu ','Heng ','Zhou ','Ge ','Luan ','Hong ',
        'Wu ','Bo ','Li ','Juan ','Hu ','E ','Yu ','Xian ','Ti ','Wu ','Que ','Miao ','An ','Kun ','Bei ','Peng ',
        'Qian ','Chun ','Geng ','Yuan ','Su ','Hu ','He ','E ','Gu ','Qiu ','Zi ','Mei ','Mu ','Ni ','Yao ','Weng ',
        'Liu ','Ji ','Ni ','Jian ','He ','Yi ','Ying ','Zhe ','Liao ','Liao ','Jiao ','Jiu ','Yu ','Lu ','Xuan ','Zhan ',
        'Ying ','Huo ','Meng ','Guan ','Shuang ','Lu ','Jin ','Ling ','Jian ','Xian ','Cuo ','Jian ','Jian ','Yan ','Cuo ','Loc ',
        'You ','Cu ','Ji ','Biao ','Cu ','Biao ','Zhu ','Jun ','Zhu ','Jian ','Mi ','Mi ','Wu ','Liu ','Chen ','Jun ',
        'Lin ','Ni ','Qi ','Lu ','Jiu ','Jun ','Jing ','Li ','Xiang ','Yan ','Jia ','Mi ','Li ','She ','Zhang ','Lan ',
        'Jing ','Ji ','Ling ','Yan ','Cu ','Mai ','Mai ','Ge ','Chao ','Fu ','Mian ','Mian ','Fu ','Pao ','Qu ','Qu ',
        'Mou ','Fu ','Xian ','Lai ','Qu ','Mian ','','Feng ','Fu ','Qu ','Mian ','Ma ','Me ','Mo ','Hui ','Ro ',
        'Zou ','Nen ','Fen ','Huang ','Hoang ','Jin ','Guang ','Tian ','Tou ','Heng ','Xi ','Kuang ','Heng ','Shu ','Li ','Nian ',
        'Chi ','Hac ','Hei ','Yi ','Qian ','Dan ','Xi ','Tuan ','Mo ','Mo ','Qian ','Dai ','Chu ','You ','Dian ','Yi ',
        'Xia ','Yan ','Qu ','Mei ','Yan ','Qing ','Yu ','Li ','Dang ','Du ','Can ','Yin ','An ','Yan ','Tan ','An ',
        'Zhen ','Dai ','Can ','Yi ','Mei ','Dan ','Yan ','Du ','Lu ','Zhi ','Fen ','Fu ','Fu ','Min ','Min ','Yuan ',
        ],
    'x9f':[
        'Cu ','Qu ','Chao ','Wa ','Zhu ','Zhi ','Mang ','Ao ','Bie ','Tuo ','Bi ','Yuan ','Chao ','Tuo ','Ding ','Mi ',
        'Nai ','Ding ','Zi ','Gu ','Gu ','Dong ','Fen ','Tao ','Yuan ','Pi ','Chang ','Gao ','Qi ','Yuan ','Tang ','Teng ',
        'Shu ','Shu ','Fen ','Fei ','Wen ','Ba ','Diao ','Tuo ','Tong ','Qu ','Sheng ','Shi ','You ','Shi ','Ting ','Wu ',
        'Nian ','Jing ','Hun ','Ju ','Yan ','Tu ','Ti ','Xi ','Xian ','Yan ','Lei ','Bi ','Yao ','Qiu ','Han ','Wu ',
        'Wu ','Hou ','Xi ','Ge ','Zha ','Xiu ','Weng ','Zha ','Nong ','Nang ','Tay ','Zhai ','Ji ','Zi ','Ji ','Ji ',
        'Qi ','Ji ','Chi ','Chen ','Chen ','He ','Ya ','Ken ','Xie ','Pao ','Cuo ','Shi ','Zi ','Chi ','Nian ','Ju ',
        'Tiao ','Ling ','Ling ','Chu ','Quan ','Xie ','Ken ','Nie ','Jiu ','Yao ','Chuo ','Kun ','Yu ','Chu ','Yi ','Ni ',
        'Cuo ','Zou ','Qu ','Nen ','Xian ','Ou ','E ','Wo ','Yi ','Chuo ','Zou ','Dian ','Chu ','Jin ','Ya ','Chi ',
        'Chen ','He ','Ken ','Ju ','Ling ','Pao ','Tiao ','Zi ','Ken ','Yu ','Chuo ','Qu ','Wo ','Long ','Pang ','Gong ',
        'Pang ','Yan ','Long ','Long ','Gong ','Kan ','Ta ','Ling ','Ta ','Long ','Gong ','Kan ','Gui ','Qiu ','Bie ','Gui ',
        'Yue ','Chui ','He ','Jue ','Xie ','Yu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Shan ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'xf9':[
        'Kay ','Kayng ','Ke ','Ko ','Kol ','Koc ','Kwi ','Kwi ','Kyun ','Kul ','Kum ','Na ','Na ','Na ','La ','Na ',
        'Na ','Na ','Na ','Na ','Nak ','Nak ','Nak ','Nak ','Nak ','Nak ','Nak ','Nan ','Nan ','Nan ','Nan ','Nan ',
        'Nan ','Nam ','Nam ','Nam ','Nam ','Nap ','Nap ','Nap ','Long ','Nang ','Nang ','Nang ','Nang ','Nay ','Nayng ','No ',
        'No ','No ','No ','No ','No ','No ','Lou ','No ','No ','No ','No ','Nok ','Nok ','Nok ','Nok ','Nok ',
        'Nok ','Non ','Nong ','Nong ','Nong ','Nong ','Noy ','Noy ','Noy ','Noy ','Nwu ','Nwu ','Nwu ','Nwu ','Nwu ','Nwu ',
        'Nwu ','Nwu ','Nuk ','Nuk ','Num ','Nung ','Nung ','Nung ','Nung ','Nung ','Twu ','La ','Lak ','Lak ','Lan ','Lyeng ',
        'Lo ','Lyul ','Li ','Pey ','Pen ','Pyen ','Pwu ','Pwul ','Pi ','Sak ','Sak ','Sam ','Sayk ','Sayng ','Sep ','Sey ',
        'Sway ','Sin ','Sim ','Sip ','Ya ','Yak ','Yak ','Yang ','Yang ','Yang ','Yang ','Yang ','Yang ','Yang ','Yang ','Ye ',
        'Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Ye ','Yek ','Yek ','Yek ','Yek ','Yen ','Yen ',
        'Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yen ','Yel ','Yel ','Yel ','Yel ',
        'Yel ','Yel ','Yem ','Yem ','Yem ','Yem ','Yem ','Yep ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yeng ',
        'Yeng ','Yeng ','Yeng ','Yeng ','Yeng ','Yey ','Yey ','Yey ','Yey ','O ','Yo ','Yo ','Yo ','Yo ','Yo ','Yo ',
        'Yo ','Yo ','Yo ','Yo ','Yong ','Wun ','Wen ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ','Yu ',
        'Yu ','Yuk ','Yuk ','Yuk ','Yun ','Yun ','Yun ','Yun ','Yul ','Yul ','Yul ','Yul ','Yung ','I ','I ','I ',
        'I ','I ','I ','I ','I ','I ','I ','I ','I ','I ','I ','Ik ','Ik ','In ','In ','In ',
        'In ','In ','In ','In ','Im ','Im ','Im ','Ip ','Ip ','Ip ','Cang ','Cek ','Ci ','Cip ','Cha ','Chek ',
        ],
    'xfa':[
        'Chey ','Thak ','Thak ','Thang ','Thayk ','Thong ','Pho ','Phok ','Hang ','Hang ','Hyen ','Hwak ','Wu ','Huo ','','Coc ',
        'Zhong ','','Qing ','','','Xi ','Zhu ','Yi ','Li ','Shen ','Xiang ','Fu ','Jing ','Jing ','Yu ','',
        'Hagi ','','Zhu ','','','Yi ','Du ','','','','Fan ','Si ','Guan ','He ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x200':[
        'Ha ','Qi ','','','','Hai ','','','','Qiu ','','','','Shi ','','',
        '','','','','jue ','','','','','','','yu ','','','','',
        '','','','','','','','Ba ','Cup ','','Kha ','','','','','',
        '','','','','Trut ','','','','','','','','','lu ','','',
        '','','','','','','','','','','','','','','','',
        '','Duoi ','','','','','','','','','Cui ','','','','','',
        '','','','','','Ga ','','','','','Nham ','','','','','',
        '','','','','','','','','Suot ','','','','','','','',
        '','','','','','','','','jie ','','','','','','','',
        '','','','','Zi ','','','','','','','','','Zung ','','',
        '','','Pai ','','Dui ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','jiu ','','','','','',
        ],
    'x201':[
        'Vu ','','','','','','','','','','','','','jie ','','',
        '','jue ','','','','','','','','','','','','','','',
        '','','','','','','Gop ','Vai ','','Hai ','','','','','','',
        '','','','Kep ','','','Nham ','','','','','Lam ','Nam ','Vai ','','wei ',
        '','','jie ','','','','','','','','','','','Mat ','Mat ','',
        'Mat ','','Mat ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','zhang ','','','Mat ','','','',
        '','','','','','','','','','','','','Yong ','','','',
        'xu ','','','','','','','','','','','','','','','',
        '','','','','','','','','','Faan ','','','','','','',
        '','','','Trum ','','','dan ','','','','','','','','','',
        '','','','','','','','','','','','','','Voi ','','',
        '','','','','','Va ','','','chu ','','','','','','','',
        '','','','','','','','','','','','','','','','qu ',
        '','','','','','','','','','','','','Hua ','Top ','','',
        ],
    'x202':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','yun ','','','','','','','','','','','',
        'dan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Nay ','',
        'Tray ','','','','','','','ju ','','du ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','jian ','','','','','','','','Ngai ','','Nho ','Thay ','','',
        '','','','','','','','Bing ','','zhuan ','shu ','','jue ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','lian ','','','','','','','','she ','',
        '','','','','','May ','Mu ','','','fu ','','','ju ','','','',
        '','','','','','','','','','','Tao ','','','','','',
        ],
    'x203':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Wu ','','','','','','','','shuai ','','',
        'gai ','','','','zhuang ','','','','','','','','','fu ','','',
        '','Man ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','But ','','','','','yao ','','','','Gap ','','bie ',
        '','','qu ','','','yang ','','','','','','','','sha ','','',
        '','','','','','','','','','','Xum ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Cap ','Bay ','','','','','jue ','',
        '','','','yu ','','','','sa ','','','','dun ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','xiao ','','','','','yu ','qu ','','','','',
        '','','','','','Ngai ','','','','','','','','Tui ','','',
        '','','','Giong ','','','','','','','','','','','','',
        ],
    'x204':[
        '','meng ','','','','','','','','jie ','shu ','','','su ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','meng ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Trom ','','','Long ','','','','',
        '','','','','','Ngua ','','','','','nei ','nei ','','','zhai ','',
        '','','','','','','','','','','','','Nhau ','','','cu ',
        '','','','','','','','','','','','','','','','',
        '','','','','wu ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Rang ','','','','','','','','','','',
        '','','','','','lian ','','Tin ','','','','','','','fan ','',
        'Truoc ','','','','','','','','','','','','','','','',
        'Quanh ','','','','Mong ','','','fu ','','','','','','','','',
        '','','','','','','','','Vao ','Nhui ','','','','','','',
        '','','','','','','','','','Lon ','','Tron ','Sip ','','','',
        ],
    'x205':[
        '','','','Xi ','','','','','','Juan ','','','','','','',
        '','hai ','','','','lun ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','heng ','','','','','','','','','Zheng ','','','','',
        '','','','','Nap ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'cheng ','','','qia ','','','yu ','','','','','','','zhao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Xuong ','','','','','','','',
        '','','','','','','','','Nap ','','','','','','','',
        '','','','','Bay ','Chong ','','','','','','','','','','Ngat ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','qiu ','xie ','','','','','','',
        '','','','','','','','','','','','die ','','','','',
        '','','','Lun ','','','Ping ','','die ','','','','','','','',
        'Tron ','','','','','','','','','Ret ','','','','liu ','','',
        ],
    'x206':[
        '','bu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','lai ','','',
        '','','he ','jiao ','','','','','','','','','','','','',
        '','','','','','','','','','','','wu ','','','','',
        '','','','','','','ju ','','','','','','','','','',
        '','','','','jiu ','wei ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','xian ','','','','chang ','','','','','',
        'Moc ','','','','he ','','','','','','','','','','','',
        '','','Ra ','','','','','','','','','','','','','Got ',
        '','zhe ','','','','ju ','','','','Shan ','Sha ','','','','','',
        '','','','','','','','','','','','','Cham ','','','',
        '','','','','','','','','','cu ','','','','','','',
        '','','','','Chem ','','','','','','Tiu ','','','','','',
        '','','','','','','','','fen ','','','','','','','',
        ],
    'x207':[
        '','','','jiu ','xu ','','','','','','','','','','Xian ','',
        'kuai ','','','','','','','','','bu ','','','','','','',
        '','','','','qia ','','','','','','','','','','Hui ','',
        '','Pai ','','','','','','','','ju ','','','Qia ','','','',
        '','','','','','','','Bao ','','','','','','','','',
        '','','','','','Cun ','','','qia ','','','','','','','',
        '','','','','','','','','','','','','','Peng ','','',
        '','','','','','','','','','Gaai ','','','','','','',
        '','','','zhe ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Got ','Bam ','','','','','','','','','','gun ','Lou ','','',
        'Jiao ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','yao ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Hoat ','','','','','','','','','','',
        '','','','','','','','','','','','ze ,bai','','','','',
        ],
    'x208':[
        '','','','','zhao ','','','','','Bua ','','','','','','',
        '','Tet ','','','du ','','','','','','','','','','','',
        'du ','','','','','','','','','Truoc ','','','','Chom ','','die ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Gang ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','duan ','','','','','','','','','Khuot ','','','','','',
        '','','','','','','','han ','','','','','','','','',
        '','Nhoc ','','','','','','','','','juan ','','','Vam ','Giup ','Giup ',
        '','','','dian ','Jue ','','','','','','','','Lu ','','','',
        '','','','','','','','','','','','','','','','',
        '','','Ruon ','','','','','','','10383.060,wan ','','','','','','',
        'yun ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','qu ','shao ','','','','',
        '','','','pao ','','','','','','','bao ','','','','fu ','jiu ',
        ],
    'x209':[
        '','','','','','','Cho ','','','','','','Cho ','','hua ','Bao ',
        '','','','','','','','','','','','','','mao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','diao ','','','',
        '','','','','','','','','','','','','','','wei ','',
        '','diao ','','','','','','','','','','','','','','',
        '','','','','Giau ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','sa ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','luan ','Muoi ','','','','','','Gan ',
        '','','','','','','','','','Chuc ','','Lung ','','','','',
        '','','','','','','Tron ','yu ','','','','','','Nhu ','','',
        '','','','','','he ','','','','shao ','','','','','','',
        '','','','','','','','','','Hui ','','','','','','',
        '','','','','','','','','','','','','','','','heng ',
        ],
    'x20a':[
        '','','','wai ','','','','','','','jue ','','','','zhuan ','',
        '','','','','','','','','','','','','','','','',
        '','','jun ','','','','','','','','','','','ju ','','',
        '','','','','','bang ','','','','','','','','','','',
        '','','','','','','','','zhu ','','','','','','','',
        '','','','','','Me ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Li ','','','','','',
        '','','','mei ','','','','','','','','','','','','',
        'liu ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','jue ','','Day ','','','','','','','','','','Rot ',
        '','','','','','','','','','','','','','','','',
        '','','','yu ','','','','','','','','','','','tu ','',
        '','','','','','','','','','shan ','','','','','','',
        ],
    'x20b':[
        '','','','','','','guan ','','','','','','','','','',
        '','','Cut ','','','','','','','','','Mo ','','fu ','','',
        'Mot ','','','bang ','','','','','','','biao ','','','','jie ','',
        '','','','','','','Jin ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Zhuo ','','','','','bian ','','','','','','tun ',
        '','','','','','','','','','','de ','','zhu ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Naai ','Leo ','','','','','','',
        '','','','','','mang ','','','','','','','','','Ngot ','sa ,san',
        '','','','','','','','','Daai6','','','Jai ','','','','',
        '','','','zhe ','','','','','ban ','jie ','','','','','','',
        '','','','','','','Thet ','','','','','','','','Hin ','pian ',
        '','','','','bian ','','','reng ','','reng ','','','Danh ','Chui ','','',
        ],
    'x20c':[
        '','','Ngoen ','','','','','','','','','Jaau ','Mut ','','','Mom ',
        '','an ','','he ','','','','','','Khen ','','hu ,gao','','','','',
        '','','','','','','','','','','','','','Meo ','','',
        '','','Eot ','','','','','Lo ','','','dai ','wai ,wai','','','','',
        '','Tam ','Dat ','Nip ','','Quai ','','','','','','','','Phom ','','',
        '','','','Ngai ','','','','','Ngaak6','','','','Chun ','','','',
        '','sa ,shai','','','','Fik ','','','','','','','','','','',
        '','','na ','','','','','Ming ','San ','','','','','','','',
        '','','','','','','','','','','','','shu ','','','Nham ',
        '','','','Hang ','','','E ','','','','','','Gianh ','','','',
        '','','','','','','Nhung ','','','','','','','','Khinh ','',
        '','ge ','','','','Mep ','','die ','','','','','','fu ','','Thoc ',
        '','Kwan ','','','','','','he ','','','','','qia ','','','Ce ',
        'Vang ','','','','','Caau ','Dap6','','Nhu ','Thay ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Tu ','','','','','','','cheng ','','',
        ],
    'x20d':[
        '','','','','','','','','','','','Phao ','Nhanh ','Nhan ','','Mang ',
        'Nuc ','','','','','Miu ','Voi ','','','','','Gung ','','','','',
        '','xiao ','','','','Ngoam ','zhu ','','','','','Thut ','','','','',
        'Gau6','hu ','ta ','Ngaau ','','zao ','','','','','','','dao ','','na ','',
        '','','','','','','Daam ','Koe ','Mui ','Hong ','','','','','','',
        'Mep ','','','','','','','','Mun ','','','','','','','',
        '','','','ya ','','','','zhen ,chun','de ','Go ','','','','','','Gwit ',
        '','E ','','','','','','xuan ','','','','','Mang ','Faat ','Waak ','Pe ',
        'Tham ','Nhu ','','','','','','','Se ','','Pha ','','','','','',
        '','U ','','','','Nhau ','Uong ','','Sat ','Bop ','','','Zai ','','','',
        '','Troi ','Du ','Mai ','','Khung ','','Dim6','','','','da ','nang ','','','Chut ',
        '','','Gap6','','','','','','jue ','he ','','','','','','',
        '','','dai ','','','zhu ','','','','','','','','ta ','','',
        '','','','','','','bian ','','','xu ','','','','','','',
        '','','','','Phao ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x20e':[
        '','pai ','Giot ','','Inh ','','','','','Kak ','Tap ','','','Me ','Naa ','Ge ',
        'Kam ','Soek ','Bou ','','','','','Xua ','Tuc ','Song ','','','','','','Bai ',
        '','','','','','','Khan ','','','','','Tau ','','','','',
        '','','','','','','','','','yu ','Ngaak6','','','','Map ','',
        'xun ','wa ','','ang ','han ','','','','','','','','Lan ','','','',
        '','yao ','','ge ','','bao ','','','xu ','','','','','','','',
        '','','','','','','','','','','','','','Ko ','','',
        '','','','Git6','','','','Ngo ','Kam ','Lan ','Maai ','Zam6','','Cay ','','',
        '','','','','','','','','','','','','Gwe ','','','',
        'huan ','','','','','','','','Long ','Thoi ','Ban ','','','Gaak ','','ku ',
        'Lung ','','Gaa ','','','','','','','Trou ','He ','Loe ','He ','','','',
        '','Hung ','','','','Chac ','Nop ','','','Ri ','Que ','Cop ','Xui ','','Chau ','Ngoan ',
        '','Guong ','Ngon ','Han ','Oang ','','','','','','','','','huan ','','zu ',
        '','','','','','','','Le ','Zeot6','he ','','','','','','',
        '','','','','Don ','zhao ','','','','','','','tu ','','','',
        '','','','','Long ','','','','','','Aa6','Bai ','Dau6','','','',
        ],
    'x20f':[
        '','','','','','','','','','','','','','','','',
        '','','','','','Paai ','','Zaam ','wu ','','','','','','','',
        '','','jiang ,qiang','','','','Muon ','','','lun ','Day ','','','But ','Ngai ','Ho ',
        'Kang ','Loe ','','','','Danh ','','Thay ','','','','Ji ','','','','',
        '','Xo ','','Zap ','Tham ','Thung ','Nuot ','','','','','Nac ','Toet ','','Nhai ','',
        'Ngo ','','Neng ','Ngon ','Thua ','','Giuc ','','','','','Oam ','','','','',
        '','','','','Kik ','','','','','','','','','','','',
        '','','','','','yu ','','','','','','zhe ','','','','',
        'Hup ','','','','','','','','','','','','','He ','','Ce ',
        '','','','','','','','','','','','Ngoang ','','','','',
        '','','shu ','Rum ','','','Bai ','','','la ','','','','We ','','',
        '','','','','Baang ','Zaa ','Ging ','','','Nuot ','','','Cyut ','Nhun ','Nhap ','',
        '','Si ','Xep ','','','','','','','','','','','','','',
        '','','Het ','sa ','','qiao ','','','','','','Lu ','hua ','','','',
        '','','','','','','','','','','Gaa ','Saau ','Soe ','Wet ','','Ngui ',
        '','','','','','Khan ','','','','','','','','','','',
        ],
    'x210':[
        '','','','','','','','','','','','','','','','',
        '','','','','Ro ','','','','','','','','','Nam6','Zip ','',
        'Bei6','','','','','Phao ','','','','Lok ','','Bam ','','','','',
        '','Hao ','Cay ','','','','','Ron ','','','xie ','','','','','',
        'han ','','','','','','','','fan ','','','','','ai ','yu ','Am ',
        '','','','','','','','','','','Hon ','','Wo ','Hang ','Xao ','',
        '','','','','','','','','','','','','','','','Dyut ',
        '','','','zhan ','','Gan ','Zit ','Doeng ','Kwaat ','','Ngon ','Ziu ','','','','',
        'Khao ','','','Hun ','','','','Mom ','Voc ','','yu ','','','Eng ','','',
        '','Ban ','','','','','Lai ','','','','','','','Zuk6','','bao ',
        '','shu ','','','','','','','','','Ze ','peng ','','','Ngau ','',
        'Ran ','','Ray ','Troi ','','','','Khoan ','','','','','','','','',
        'E ','Leng ','','','lai ','','','Bai6','Kwaak ','Gaa ','','','','Chem ','Phan ','Doe6',
        '','','Boc ','Bo ','','Gung ','Le ','Mua ','','Mut ','','','','lun ','','',
        '','','','','Laai6','','','','','','','','','','','',
        '','','','','Ceoi ','Ngung ','Sek ','','','Chen ','','','','','Phac ','Thot ',
        ],
    'x211':[
        '','Lum ','','','','','','','','','','','','Ruc ','Gam ','Ham ',
        '','','dao ','','','','','','','','','','','','','Haa ',
        '','Chay ','','','','','Lom ','','','Khan ','Toe ','Khem ','Hun ','','','Jik ',
        'Tot ','cu ','ru ','','','Ji ','','','','luan ','','','','Soe ','','',
        '','','','','','e ,ei','','','Laa ','Dang ','Bun ','Hum ','','','','Lai ',
        'Lanh ','Ngong ','','','','','','','la ','yun ','','','','','','',
        '','','','','','die ','','Nan ','','','','','Hoai ','','','',
        '','huan ','','','','','','','','','','huan ','','','','',
        'Gwang ','Nhau ','','','Nhep ','wan ','','Wok ','','','','','','','','',
        '','Nham ','','','','lian ','Trom ','','','','Gu ','','','','Giau ','',
        '','','','','','jiu ','','','','','','','','','','',
        'dun ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','die ','','','','','','Doe ','','','','','he ','',
        'zhe ','','','','','','wei ','','','tu ','','','','','','hun ',
        '','','','','','dang ','he ','tai ','Quay ','','yu ','Nhot ','ya ','','','',
        ],
    'x212':[
        '','','','','','jue ','','','','','','','','','Mui ','',
        '','','','yuan ','','','','','','You ','','','','','','',
        '','','','','','','','','yu ','','','','','','','',
        '','','','','','','lei ','','','','','','','','','',
        '','','','','','','','','','','','','','','Cong ','',
        '','','tun ','','','','Cong ','','','','','','','','','',
        '','','','','','','','','','bao ','','','','','','',
        '','','','','lu ,hu','','','jie ','','','','','','','Tum ','Moc ',
        '','','','','','','','','','','','','','shu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Sanh ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','gao ',
        '','','','','','','','','','de ','','','yu ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x213':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','guai ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'hu ','','','','','','','','Che ','Vung ','Lam ','','Mun ','Nui ','','',
        '','','','','','zhai ','','','du ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','du ','','','','','','',
        '','an ','','','','','','','','','','Bun ','Nam ','','','Hang ',
        '','','','','','','','','','','','','','Thong ','su ','',
        '','','','','Gung ','','','','','','zhu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','xia ','','','','','','','',
        '','Luong ','','','','Tret ','Xay ','Bui ','','','','','','','','bai ',
        '','','','','','','','','','','','','','','','',
        ],
    'x214':[
        '','','','','','','','','','','','','chu ','','','',
        '','','','','','','xian ','Hoc ','','','','','','fu ','','',
        '','','','','','sa ','','','','','','','','','Ve ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Coi ','Chum ','','','','Thoai ','','','','','','Lan ','Sui ','',
        '','','','','','','','','','','','','','Coi ','','',
        '','','Gom ','','','','','','','','','','','','yu ','',
        '','sa ','','Juk ','Lan ','','','','','','yu ','','','ju ','','',
        '','','shu ','xian ','','','gai ','','','','','','','','','',
        '','','','','','','','','','','','Cau ','','','Suong ','',
        '','','','','','','','','','','','','','','','',
        '','','','Loi ','Vung ','','','','','','','','','','','San ',
        '','','lai ','','Lam ','','','','','','','','','','','',
        '','','','','','Chen ','zhan ','','','','','','','','','Chum ',
        '','','','','','','','','','','','','','','','',
        ],
    'x215':[
        '','','','','','','','','','','','','','','','',
        '','','','','Lan ','','','','','','','','','','','',
        '','','','','','','','','','','shu ','','','','','',
        '','','','','yu ','','','','','','','','','','','Trau ',
        '','','','','','','','','','','','','','','','',
        '','','kua ','','','','','hai ','','','','','','','','',
        '','','','','','','','hang ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','yun ','','','','','','','','','','','','','',
        '','','','','','','','','','','guai ','','','','','su ',
        '','Bon ','','','','','','','','','','','','','','',
        '','','Sai ','','','','','','','','','Lam ','','','Tum ','',
        'Muong ','','','','','','','Peng ','','','','','','','','',
        '','','','','','chun ','','','','','','','','','','',
        '','','','','','','','','','fan ','','','','','','',
        ],
    'x216':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','zhe ','Mat ','Lon ',
        'juan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','jie ','','','','','','','bie ','','','','','',
        '','','','','Canh ','Nhon ','','','','','','','','','','',
        '','Bi ','','Xon ','','','','yan ','wei ','','','','hao ','','','',
        '','','','','meng ','','','','','','Lon ','','','','','',
        'jue ','To ','To ','','','','Hai ','','','','','','','','','',
        '','','','','','','','','','zhang ','','da ','','hao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','can ','','',
        '','','','','Nua ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x217':[
        'fan ','','hu ','','','','','','','','','','','','','',
        '','','','','','','','','','','ru ','','','','','',
        '','','','','','','','','','','','','','','','zhe ',
        '','Ji ','gao ','','','','','','','','','','','','','',
        '','','','Bua ','','','','','chu ','','zhe ','','','','','',
        '','','','','Kep ','Va ','','','','','cheng ','','du ','','','nian ',
        '','','','','','','Vu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','cu ','','','pan ',
        'hu ','','','xian ','','','','','','','fu ','nai ','','','','',
        '','','','','','','','','','','','','','','Nen ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','lian ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x218':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','hao ','','yang ','','','','','','fu ','',
        '','','','Cuoi ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'juan ','','Nhang ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','qu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhuan ','','','','','','','','dang ','','','','','','','',
        'Sau ','','','','','','','','','','man ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Sui ','','',
        '','','','','','','','','shu ','','','','','','','',
        '','','','','han ','Ban ','','','','','','','','','','',
        '','','nei ','','','','','','Cuoi ','','','','','','cai ','jie ',
        '','','','','','','','','','','','Sen ','','','','',
        ],
    'x219':[
        '','','','','','','','','','','Chua ','','','','fan ','',
        '','','','Moi ','Moi ','','','zhu ','','na ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','jiao ','','','','Nhat ','xiao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Con ','ju ,ru','','','','','','Me ','','','',
        '','xu ','','','fu ','So ','','','','','','','','','','',
        '','','','','','er ','','','','','','shu ','','','','',
        '','','','','','','','Rot ','','','','Chat ','','','Nhang ','',
        '','','','xiao ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','mian ','','','','','wa ','','pao ','','','','','','',
        '','','','','','','heng ','','zhu ','','','','','','','',
        '','','','','','','','','','dai ','','','','','','',
        ],
    'x21a':[
        '','','','','Xia ','ju ','','','','','','','','','','',
        '','','','','','','','zao ','','','','','','','','',
        '','','','yu ','','','','Tot ','','','','','','','','',
        '','','jie ','','Ning ','nai ','','','','','','','','','','yu ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','jie ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','an ','','','Xum ','','','',
        'ceng ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Sao ','','','','','','','','','','','','','','',
        '','','','','','','Lung ','','','','','','','','','',
        ],
    'x21b':[
        '','','','','','','','','Xuong ','sai ','yu ','jiao ','','','','',
        '','','','','','','','','20960.020,lao ','','','','','','yu ','',
        '','','','','','','','','','','','wu ','','','','',
        '','','','','','','','Tac ','','','','','Gang ','','','',
        '','','de ','','','','','','','Ban ','','','','','','',
        'shuan ','','','','','Cut ','','','','','','','Mon ','','','',
        '','','bai ','','','','','Chut ','','','','','Be ','','','',
        '','Chut ','Trut ','kao ','','','','','luan ','','','Nhon ','','','','',
        '','','','','','','Mon ','Chut ','','Mon ','','May ','Be ','Chut ','','',
        '','','','Choai ','','','','','','nai ','','','','','','',
        'May ','','','Be ','Be ','Be ','Zao ','','','Be ','','Nhen ','Mon ','Nhon ','Mon ','',
        '','','Tho ','','','Chuong ','Chuong ','','Nhon ','','','','','Nhon ','','',
        'Oat ','','','','','','','wu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'ga ','','','','chao ','','','','','','','','','ga ','','',
        ],
    'x21c':[
        '','','','','','hu ','','','','','','','','','','',
        'qiao ','','','','','','','','','','','','','','','',
        '','','xie ','','','','','','','','Duk ','','','','','',
        '','','','','','','','','','','','','','ai ','','pu ',
        '','','','','','','Shu ','','','','','','','','','',
        '','','','','','','','','','','','','zhao ','','','',
        '','','','xu ','','','','','','Thuoc ','','','','','','',
        '','zhu ','','','','','','die ','Gang ','','qu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Ti ','','jue ','','','qiu ','','','','','',
        '','','Ke ','jiang ','','','','','','','yun ','','Gwat6','','','',
        'qu ','','','','','','','','','','','','','','','',
        'Ngoe ','','kai ','Cuoi ','','','','','','','','','','','','',
        '','chu ','','','','','','','ju ','','','','Cuoi ','Rot ','','',
        '','','','','','Toi ','','','','','','','','','','',
        '','','','Cuoi ','lu ','','','','','','','','','','jue ','',
        ],
    'x21d':[
        '','','','','','','lu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','ya ','','',
        '','hu ,jie','','','','','','','','','','','','','','',
        '','','','','','','','','','Ngut ','','','','','','',
        '','','','','','','','','hu ','ang ','','fu ','','','','',
        '','','','','','','','','','','','','mu ','','','',
        '','','','','','','','','','','Cu ','','','','','',
        'Nui ','','yao ','ai ','','','','','','fan ','','ju ','','','','',
        'qie ','','','','','','','','','','','','','','','',
        '','','kuang ','','','','ya ','','Ngan ','','kan ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','','','','','bie ','','','han ','','na ','','',
        '','','','','wu ','gao ','','','','','','','','','','',
        '','','','','','','','','','','','ya ','','','','',
        ],
    'x21e':[
        '','','','','','','','','','','','','zhu ','','jie ','Voi ',
        '','','','','xie ','','','ya ','','','','','','','','',
        '','','','','','','ze ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','ya ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Nghi ','','','','','','','','','','','','','die ','','',
        '','','','','','','','','','hu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','die ','','','','','','','','','','','pen ','','','',
        '','','','','','','Din ','','','','','','','','','',
        '','','','','tu ','','','xia ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Voi ','','Seoi ','Von ','Chon ','','','','','','','','',
        'zhu ','','','','','','','','gun ','man ','','','zu ','','hu ','',
        '','lei ','','','','','','','','','','','','','','',
        ],
    'x21f':[
        '','','','','die ','','','','','','','','','','','',
        '','','','dian ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','wei ','','','','','','','','','','','','','kuai ','',
        '','','','','','yun ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Non ','','','','',
        '','Jie ','bang ','','','','','','','','','','','','','',
        '','','','','','','','kuang ','','','','','','','','',
        '','','','ceng ','','dang ','','','','','','','','','','',
        '','','','','','','','','hai ','','','','Doc ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','nang ','','',
        '','','','','','yu ','','','','','','','','','','yu ',
        '','','','','','','','','','','Nao ','','xun ','','ju ','',
        ],
    'x220':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','wan ','','','','','','','','',
        '','','','','','Vang ','Sua ','Tron ','Sang ','','','','Lon ','','Sam ','',
        '','To ','Lon ','','','han ','','','','','','','fu ','','','',
        'fu ','','','','','','','','','','','Trang ','','Va ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','jue ','','','','','',
        '','','','','','','','','Phuon ','','','bu ','','','','',
        'fu ','','','','xuan ','','fu ','','','','','','','','Du ','',
        'xie ','Shi ','','','','','','','','','','','Vua ','','','',
        '','','','','','','','','','','','','','','','',
        'Tranh ','yuan ','','','','','','','','mao ','qian ','','','','','',
        'wu ','','','','','','','Lei ','Long ','','Vua ','','','','','',
        '','','','','','Ta ','','han ','qian ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','la ','','','','','','','','','','','',
        ],
    'x221':[
        '','','','Phoi ','','','','','','','','','','he ,ge','bang ','',
        'meng ','','','wu ','dai ','','','','','','','','han ','Bau ','','',
        '','','','','','','','cu ','','','','','','','','Man ',
        '','','','','','xiang ','Hua ','','','','','','','','','',
        '','','','','','','Manh ','','','mao ','','ceng ','','','','Lian ',
        '','','dan ','','','','Lian ','','','','','','','dian ','','',
        '','','','','gai ','Ju ','','','','','zu ','','Chan ','','','',
        '','','','','','','','','','yao ','','','nei ','','','',
        '','','neng ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','ge ','','Jian ','',
        'Lai ','Nin ','','','','Nam ','jian ','May ','May ','','May ','','','','','',
        'hu ','','','','','','','','','','chen ','','','','','',
        '','','','','','','','Guan ','yan ','Doi ','','','','','','',
        '','','','','','','','sha ','','','','','','','han ','',
        '','Khuya ','','','','','ren ','','','','fan ','','','','','',
        '','','','','bu ','na ','','','','','','','','','','',
        ],
    'x222':[
        '','','','','','','','','Nap ','','','','','','','',
        '','','','','','bai ','','','Roku ','','','kun ','','qiu ','','',
        'cu ,la','','','','','','','','','','','','','','','',
        '','','pu ','','','','','','','','','jie ','','zhan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','du ,tu','','','',
        '','','hu ','','jia ','','','','la ','','','','','','','',
        '','','','','','','','','','','','','','Kho ','U ','ma ',
        '','','','','','','','','','','','','','Ceoi ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','yu ','','lu ','','','','','','',
        '','fen ','','','','','','','','','','','','','','',
        '','','','','','yu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','xian ','',
        '','','','','','','','','','wu ','','','','','','',
        ],
    'x223':[
        '','','','','qu ','','','','','','Rong ','','Rong ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','fu ','','yu ','','','','',
        '','','','','','','','','','','','','','','gao ','juan ',
        '','','','','','quan ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','die ','','','','','','dai ','','su ','',
        '','','','','jie ','','qu ','','han ','','','','','','','',
        '','jie ','','','','juan ','','','','','dan ','','','','','',
        '','','','','','hu ','','','','jue ','','yu ','','','','',
        '','','','','','','','','','','','','','fu ','','',
        '','Ban ','','','','','','','','','','','','','','',
        '','','Cong ','Cong ','xun ','','','','','','','','','liu ','','',
        '','','','Beng ','','','','jue ','','','','','','','','Von ',
        ],
    'x224':[
        '','','','','yuan ','','','','','','','','','','Khom ','',
        '','','','','','','','','','','','','','','cheng ','',
        '','','','','','','','King ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','jiu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','hu ','','','','','','',
        '','','','','','','','','','','','','','','Bay ','',
        '','','fu ','','chu ','','','','','','','','','','lan ','',
        '','','','','','','','','','','','','','','','',
        'yu ','','','','','','','','','','','','','','jiao ','',
        '','','','','','','','','','','','ang ','','','','',
        '','','','','sa ','','','','','','','','ge ','','','',
        '','','kua ','','','','','','','','','','xie ','','','',
        '','','wu ,hu','','','xiu ','','','','','','','','','','',
        ],
    'x225':[
        '','','yan ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','yu ','','','yu ','','','','','','','yu ','','','',
        '','','liu ','','20832.030,yu ','','','','','','','','','','','',
        '','','','','','shuai ','','','','','','yuan ','','','','',
        '','shuai ','','','','','','','','','','','','','','ao ',
        '','','','','','','','','','','jiao ','','sa ','xian ','zha ','dian ',
        '','','','','','','','','San ','','','shan ','','','','',
        'Suot ','','','','','','','','tiao ','','','','','','','su ',
        '','','','','','Sau ','Sau ','','','','','','','xian ','','',
        '','yu ','','','','','jue ','nang ','','','','','','','','',
        '','','','','','ru ','','','','','','','','','','',
        '','','','','xia ','','','','','Nuoi ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','wu ','','','','','','','chang ','','Lo ','','','',
        ],
    'x226':[
        '','','','','qiu ','Maau ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Rung ','Rap ','',
        '','','','','','','','','Jiang ','','','','','','','',
        '','wu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Hung ','','','','','','','','','Nhon ','E ','Tim ','kan ','',
        '','Lung6','','','','','','','','','','','','','','',
        'xian ','','','','','','ju ','','','','','miao ','','','','',
        '','su ','','','','','Ti ','','','','','','','','','',
        '','','','','','','','','','','hu ','','','','','',
        '','','','','','','','','','Khuay ','','zhu ','Ngop ','','','',
        '','','','qiu ','ya ','','','','','','','','','','bie ','',
        '','','','','','','xiang ','','','','ru ','wang ','','','','ya ',
        '','','','','','','','','yu ','','','','','','','',
        '','','','','Mang ','Zang ','','','','','','','','','','',
        ],
    'x227':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Vung ','','','','','','','','',
        '','','','','','','','','','','','Xing ','Duo ','','','',
        '','','','','','','sao ','','Nao ','','','','','','','jia ',
        'tu ','','du ','','','','','','','','','','mao ','yao ','','',
        '','','','','','','','','','Vui ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','wu ','Fit ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'hai ','','','','','','','','','','','','','','','gao ',
        '','','','','','','fu ','','','','','','','liu ','','',
        '','','','','','Fit ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Chua ','','Nan ','','','Nep ','','','Chac ','Cham ','','','','','','',
        '','','','yang ','','','','','','','','','','','','',
        'ai ','teng ','','','','','','','','Nhuoc ','','','','','','',
        ],
    'x228':[
        '','','','Geng6','Sung ','Thung ','','','','','','','','','','',
        'Ngo ','','','','','','','','','','','','','','','',
        '','sao ','','','','Gan ','Hon ','','','Mo ','','shu ','','','','Lang ',
        '','','fu ','Bie ','','Tang ','','xiang ','','','','','','dang ','','',
        '','','dang ','','','','','','','','','','','ge ','yu ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhao ','','','','','','','','','','','','','','','',
        '','','Ghet ','','Ngung ','','','','','','','','chang ','zhe ','','',
        '','','su ','','','','','','','','kai ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Khan ','','',
        'Ngay ','','','','Quo ','','','','','','','','','','','ai ',
        '','','','','','','','','','','','','','','','',
        'liu ','','','','','','','Khuay ','','','','','','','','',
        '','','','','','','','','','Hung ','','','','','','chu ',
        ],
    'x229':[
        '','sao ','','','','','','','','','','','','','','',
        'liu ','','','','','','','','meng ','','zhan ','','','Cham ','','',
        '','','','','zhuang ','','','','','','','','','','','',
        '','','','','','','','','','Goe ','','','','','','',
        '','','teng ','zhu ','','','Lung ','','Lo ','','','','','','','',
        '','','','','','','Trai ','','xie ','','jiao ','','','','Chong ','',
        'Sung ','','','','','','','','','','','','','','','',
        '','','','','','','','Ngoi ','','','','','','','','',
        '','','Laan ','','','','','','','','','','qu ','','qiu ','Zai ',
        '','','','','','','','','','','hua ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','shu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','han ','ge ','','','','','','','','',
        '','','Ta ','','','','','','','','','','','','','',
        ],
    'x22a':[
        '','','','','','','','','','','','','','','','jue ',
        '','','','','','','','zei ','','','','','jie ','','','',
        '','','','','','hu ','hu ','','','','','chu ','','','','',
        '','','','','','','','','','','','','','','','',
        '','ju ','','','zhu ','','','','','','Quanh ','','','','','',
        '','','','ge ','','','','','','','','','Ho ','','','',
        '','','shan ','','Muon ','','Zit ','Hat ','','','','','','Thuon ','Dat ','jue ',
        '','','','','','','','','hai ','xia ','','','','','Chop ','',
        '','','','cu ','','','','','','','','','','','','',
        '','','','','','','','Vuc ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Ngat ','Vat ','Nang ','','','','','Muc ','','','','','','','zhang ','',
        '','','','Keo ','','That ','Vun ','','','','','','Tha ','','','Kam ',
        'jie ','','','','','Wing ','Trot ','','So ','','','','Trum ','Rung ','Quay ','',
        '','','','Bac ','','','Haku ','','Ngung ','','','Lat ','','nu ','','',
        'zhe ','','','','','zu ','','','','','','nie ','','','','',
        ],
    'x22b':[
        '','','','','Bung ','','','','','','','','','','','',
        'Muc ','','','','','','','Chui ','','','','','','','','',
        '','','','Tay ','Khuong ','Giang ','','','','','','','','','Vot ','',
        '','Khep ','','','','','','nan ','','','','','dun ','','','Xoi ',
        '','','','Dau ','','','Chou ','','','','','','','','','',
        '','Thuoc ','','','','','','','','','','','Xac ','','','',
        '','','','','','bian ','','','','','','','','','','Quet ',
        '','','','Giau ','Khuay ','','','Vom ','','Lan ','Dui ','Xoi ','','','','',
        '','','','','','','','','','','ya ','','','','','bang ',
        '','Luk ','','','','','','','','','','','','','sao ','',
        '','','','','','','','','','Co ','Ron ','','Chut ','Co ','','',
        '','','','','','','','','','','','','','','','Quay ',
        '','','','','','lu ,jue','','','','xie ','Dik ','','zhai ','','Ngaau ','',
        'Co ','','','Va ','Quat ','Ngoi ','Khep ','Quay ','Huo ','','','Sap ','Buoc ','Ven ','','',
        'Va ','Roc ','Sua ','','','','Lay ','','','','','','','','yu ','',
        '','Sau ','wan ','xue ','','','','','','ge ','','','','','mao ','',
        ],
    'x22c':[
        '','','','','','','fu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Wo ','','','','','Gap ','Zung ','pan ',
        '','','','','jie ','','','','jia ','','','','jia ','','Boi ','',
        'Gieo ','Waa ','','','','Dap6','','','','Cai ','Phung ','Xoi ','','Nhot ','','Sin ',
        '','','Saak ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Kek ','','','','','','','',
        '','','','','Bung ','','','','','','','','','Run ','','',
        '','Laa ','','Rung ','Cau ','','','Gay ','','Cap ','Mai ','Mo ','','','','',
        '','Cau ','Sang ','','','Cao ','','Sou ','Lou ','','','','die ','','','zhu ',
        '','','Bat ','','','','Ngao ','','zu ','','','','','','','',
        '','lang ','','','','','','','','','','','Saai ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x22d':[
        '','','','','','','','Chap ','Daat ','','Chop ','Chong ','','','','',
        'Day ','','Phanh ','','','Ning ','','','Xay ','','','','Xau ','','Nhung ','',
        '','','fen ','','','','','','','','','','ban ','','','',
        '','lei ','xie ,jie','','','','','','','','','','','','','',
        '','','','','Cou ','','','yang ','','','','','Dui ','','','',
        '','','','Paang ','','','','','','','','','','','','',
        '','','','','','zao ','','Dan ','','Doi ','','','Don ','','','',
        '','Khoi ','','Sum ','Quay ','','Don ','Cat ','Xap ','','','','Vot ','Ro ','','',
        '','','','','','Sip ','','','','','','','','Saap ','','',
        '','Niao ','guai ','','','','','','','','','','Ngung ','','','Cui ',
        'Saau ','','','Die ','Loe ','','','','','','','','','','','Maan ',
        '','','','','','','bang ','','Bum ','','Dom ','Bung ','Ngoi ','','','Don ',
        '','Nem ','Xan ','','','Tro ','Chen ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Ban ','','','','','','','','','','Dui ','',
        '','','Hang ','','','Vo ','liu ','','','','du ','','','','','jie ',
        ],
    'x22e':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Lan ','','','',
        '','','','Niao ','','cuan ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Choc ','Gai ','Mac ','Rung ','','Xe ','','','','','yu ',
        '','Zaang6','','','','','','','','lan ','','','','','','',
        '','','','Keo ','Xau ','','','','Tum ','Suong ','','','','','','',
        '','','','xiao ','','','','','','','','','','Giam ','Que ','',
        '','','','','','','','yao ','','ta ','','Naan ','','','','',
        '','','Bung ','','Bau ','','','','','','','','','Uon ','','chan ',
        '','','','','','','','','','','','','','','','',
        '','','','Man ','yu ','','','','','Chia ','Chia ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','cheng ','','','','','','','','','hai ','','','',
        '','','','','','','','','sa ','','','','','','jie ,fu','',
        '','','','','','','','','','','','','','','','',
        ],
    'x22f':[
        '','','','','','','','','','','','','bao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','qia ','','','','','','','','jiao ','','','','',
        '','','','','','','','','','','xue ','','','','','',
        '','','','','','','','da ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','mao ','','','','','','','','','','','jiu ','','',
        '','','','','Duk ','','','','','','','','Va ','','','',
        '','wei ','','','yu ','du ','','','','','cheng ','','','','','',
        '','','kuai ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','lu ','','','',
        '','','','','','','','','','','','','','','','wen ',
        '','','meng ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','man ','','','',
        '','xie ','luan ','','','','cheng ','cheng ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x230':[
        'lei ','','','','qun ','','','','','','','','','chen ','','cheng ',
        '','','Chong ','','','','','','','','','','','','','Va ',
        '','','','fu ','','','','san ','','','','','','','','sa ',
        '','','','','','','','','','','','','','','fu ','',
        '','','','','','','','','','','','','','dao ','','',
        '','','','','Lon ','','gan ','tan ','','','','','man ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','qia ','','','','','','','','','','','',
        '','','','','','','','','','','yun ','','','','','',
        '','','','','','','','','','','','','','xiang ','','',
        '','','','','','','','','','','','','xiao ','','','',
        '','','','dang ','','zhuan ','','','','','','','','','','',
        '','','','','','','','','','dang ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','yan ','',
        ],
    'x231':[
        '','','','','','','','','','','','','','','fu ','',
        '','','','','','','','','','Huang ','','','','yan ','','hu ',
        '','','','','','','','','','','','','','','','',
        '','','','','liang ','','','','','','wei ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Khuya ','Khuya ','','','','','','',
        '','jue ','','','','','','','','','','','','','','',
        'xiang ','','','','','Tam ','Luc ','','','','','','','','','',
        '','','','','','','','','','','','','','','','Phoi ',
        'Trua ','','xu ','','','xian ','','','','gan ','','','','','','',
        '','','','','','','','hao ','','','','','','','Chang ','',
        'Giay ','','','','','fu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Sao ',
        '','','Bie ','','','','','','dai ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x232':[
        '','','','','','','','','','','mu ','','','die ','','',
        '','','','Phoi ','','Mai ','','Ngay ','','','','Quat ','Ngay ','','Hong ','',
        'bian ','','Tia ','','','tu ','','','','','','','','','','',
        'Nau ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Ui ','Trua ','',
        '','','','','','sang ','','ang ','nai ','','','','','','Gou ','',
        '','','','','','','','','','ya ','','','','','','',
        '','','','','','Rua ','','','','','','','','','','',
        '','','','mao ','','','','','','','','Se ','','Mo ','Chop ','',
        '','','','','meng ','','','','','','','','','sang ','xu ','kan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Bay ','',
        'Sao ','Toi ','','','','','','','','yu ','dan ','','','','','pu ',
        '','','','','','','','','','','','','','','ai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Som ','','',
        ],
    'x233':[
        '','Trua ','Trua ','','','','Trua ','','','Khuya ','','Som ','Rua ','','','de ',
        '','','','','','','','','','','','','','Nang ','','',
        'chun ','','','','','','','','xun ','','','','','','','',
        '','','','','','','','','','','Xeo ','','','','','',
        'Nguc ','','','','','','','ju ','','','','Cui ','','Oam ','','cha ',
        '','','','','','','','','','','','yu ','','','','',
        '','','','','','','kuang ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Luo ','','','','','','','','','',
        '','','','','nian ','','','','','','hu ','','','','Trang ','',
        '','','','','','','','','','','','','','','','',
        '','','','','Dun ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','shu ','','','','','','','','pai ',
        '','','','','','','','','','','','','','','','',
        '','','','','Jan ','','','he ','','','','','','','Qua ','Then ',
        ],
    'x234':[
        '','','','','','Nhum ','Thot ','','','','','','','','','',
        '','','','','','','','','','','','','','Xop ','','',
        '','','','','','','','','','','','','','','','',
        '','','Queo ','','','','','','','','han ','','','','','',
        '','Cung ','hu ','','','','','','','','','','','','Roi ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Gian ','','','Sim ','','','','Nen ','','','','fu ',
        '','','dian ','','','','qiao ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Mang ','','','','','','','','','','','','',
        '','Xoai ','Sao ','Cong ','','','','han ','kuang ','','','','','','','',
        '','','','','','','','','','sha ,jie','','','Gou ','','','',
        '','','shan ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Lau ',
        ],
    'x235':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Cui ','Bap ',
        '','Pha ','Xoi ','Ngoc ','','Chanh ','Nhai ','','Kang ','','','','','','','',
        '','','','','','','','','','','mao ','','Gon ','','','',
        '','','','yu ','','pao ','','','','','','','','','','',
        '','','','','','','','','Hay ','','','','','','','',
        '','','','','','','','','','','','','Noc ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','yun ','','','','','','','','','',
        '','','','','','Peng ','Chay ','Chay ','','','Ca ','','','','','',
        'Suot ','Trac ','','ju ','','','','','','','qu ','','jue ','','ang ','',
        '','','','','','','','','','ru ','','','xun ','','','',
        '','','','','','','','','','','','','','','','',
        'reng ','','','Chua ','','','','','','','','','','','','',
        '','','','','','','','','','','Cha ','','','','','',
        '','','','','','','ta ','','','yang ','','','','','Son ','',
        ],
    'x236':[
        '','Ca ','','Cay ','Thot ','','','','Son ','Cum ','','','','','','',
        '','','','','','','','Nik ','','bang ','Seot ','','','','','',
        '','','','chun ','','','Yi ','','','','','','','','','',
        '','','','','','','','','','','','','','Nau ','Vai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Rac ','','','','','','',
        '','','juan ','','','','','','','','Mo ','Sop ','','','Chay ','Rui ',
        '','','','','jie ','zhe ','hu ','','Sot ','Con ','Mam ','','','','','',
        '','','','jie ','','','','pao ','','','','ye ','','','lei ','',
        'ru ','','','juan ','','Jaap ','','','','','','','','','','',
        '','','zhuan ','','','','jiang ','hao ','','','dun ','','','','','',
        '','','','','','','','','','','Hong ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Xanh ',
        '','Gu ','','Khay ','','Be ','','','','Then ','Tu ','hu ','','','','',
        '','Dom ','','','','','','','ze ','','','die ','','zha ','','',
        ],
    'x237':[
        '','','sa ','','','','','','','','','Mo ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','juan ','','','','ai ','','','',
        'Lim ','Son ','','','','','','','','','wen ','','','','Chua ','',
        '','','hun ','','','ai ','','','','Duoi ','','ta ','','','','gao ',
        '','yu ,yu','','','','','','hu ','','','','','10389.190,bian ','su ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Khu ','Cuoi ','','','dun ','','','','','','','Tram ','',
        '','meng ','','lu ','tan ','','','liu ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'lian ','','','','','','','','','','','','','','','',
        '','','','Mong ','','','','xiao ','','huai ','','','','','','',
        '','liu ','wu ','','','','','','','','','','','','','',
        '','','','','','','','','','Dui ','','','Ran ','','','',
        'yu ','Kyo ','','','','','','','mei ','','lian ','','','lao ','','',
        ],
    'x238':[
        '','','','','','','','','','','','','','','','',
        '','','Tham ','Pheo ','','Chua ','Chua ','Que ','Gau ','','liu ','','zhao ','','','',
        '','','','','','','','','','Tram ','','','','','','',
        '','Tram ','','','','','','','','','','','','Ha ','','',
        '','','','','','','','','','yu ','','','','','cen ','',
        '','','','Tram ','','yan ','','','','','','','','Vui ','','die ',
        '','','','','Nen ','','','lei ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','xu ','','','','','',
        '','','yu ','','','','qian ','','','','','','','','','',
        '','','','','','dian ','','','','','','','','','','',
        'zu ','','','','','','chu ','','','','','','','','','',
        '','','','','','','','','dian ','','','','','','yu ','',
        '','','','','','','','','','','an ','','','','hun ','',
        '','','','dian ','','','','','','','','','','','sha ','',
        '','','xie ','','da ','','','','','','sha ','','','','','',
        ],
    'x239':[
        '','zhu ','','','','','','','ze ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','shu ',
        '','','','','','','','','','','','','','','','',
        '','','ta ','wan ','','','','','','','wang ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','guan ','','','','','','','','','','',
        '','','','tu ','','','','ta ','','chu ','','','zhu ','','da ','',
        '','','','','','','','','','','','','','Ngay ','','',
        '','','','','','','','','','','','','','','','',
        'chu ','chu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Laai ','du ','','','','','die ','','','','','','','',
        '','','','','','','','','','bai ','','dian ','','qiu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','nao ','','',
        ],
    'x23a':[
        'luan ','','die ','','qia ','','','mao ','','','','','','','','',
        '','','','wu ','tao ','','','','','','','zu ','ma ','','','',
        '','','','jiang ','xu ','','','Giuoc ','','','','','','Quan ','','',
        '','','du ','xiang ','','','','','','','','','','','','hun ',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','guan ','','','','','','er ','','','','','',
        '','','liao ','','','','Ngoeo ','shan ','','','','','','zhai ','','ye ',
        'diao ','','','','jiang ','','','','Toi ','huai ','yu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Ji ','','','','','','','','','','dian ','','','bian ','','',
        '','','','','','','','','gu ','','','','','','','',
        '','','','','','','','','hu ','','','','','','su ','',
        '','','','','','','','','','','','','dao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','xie ','','','Van ','','dai ','','','','','','',
        ],
    'x23b':[
        '','','guan ','','','','pei ','','','','','','','','jue ','juan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','ba ','ba ','','','','','','wu ','','',
        'bao ','','','Su ','','','','','','','','','','','','',
        '','','','','','','','','fu ','','','','','ge ','','',
        'ru ','','','','','','','','','','','','','','','Ria ',
        'Mao ','','','qiu ,qu','','','','','','','','Mau ','','','','',
        '','','','','','','','Ngu ','','','de ','','jie ','jie ','','',
        '','','','','','','','','','','','','','','','',
        'san ','','chun ','','','','nai ','','','','','','','','','',
        'de ','','','','','','','','','','','','','','','',
        'mao ','','','','','','','','','','','ru ','','','wu ','',
        '','','','','','','','','','','ta ','','','','','',
        '','','','','','','','','','men ','','','','','','',
        '','pei ','','','','','','','qu ','','','','su ','','','',
        ],
    'x23c':[
        '','','','','','','','','','','','qu ','','','','',
        '','','','','','sao ','','','kun ','','','','','','jie ','',
        'qu ','qu ','','','','meng ','','','','','','','du ','','','',
        '','','','','','','','','','','','qu ','','','','',
        '','','kun ','','','','Ho ','','','','','','','dan ','','',
        '','','','xiao ,hao','','','','','','','','','','','','',
        '','','','','','','','','','','','','Hoi ','','','',
        'Ram ','','','liu ','','','Vuc ','','','','','','','','','Nhop ',
        '','','','','','','','','','','','','','Ngut ','','',
        '','','','','','','','','','','','','','','','',
        'Ngot ','','','','','','','','','','','','','','','',
        '','','he ','','','','','Nap6','','','','','','','guai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','fan ','','','jie ',
        '','','','','zhan ','','','','Deoi ','','','','','piao ','','',
        '','','','','','','','','','','','','Doe ','','','',
        ],
    'x23d':[
        '','','','','','','','','','','','','','','','',
        '','','','jian ','','','','','','','Hup ','Nhung ','','','','',
        '','','zao ','zhuang ','','','','','','','','','','','','',
        '','','','','','','','','','','','','mao ','tan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Bung ','',
        '','','','','Ngam ','','','','zhu ','','','','gan ','','','',
        '','','','','','','','','','','','','','zhuang ','','',
        'pao ','','','','','','','','su ','','','','','ju ','','',
        '','can ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Loi ','',
        'Nhom ','','','','','','','','','','','','','','','',
        ],
    'x23e':[
        '','','','xu ','','','','bian ','','','','','','','huai ','',
        '','','','','','','','','','','she ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','Lut ','','Tran ','','','','','','qiao ,xiao','','Cong ',
        '','','','','','qian ','','','','xie ','','','hu ','','','xun ',
        '','','','','','na ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','tao ','',
        'qiao ','','','','','','','','','','','','','','','',
        'Nuot ','','','Bui ','','','','Xoi ','','Duoi ','','','','dang ,xiang','','',
        '','','','','','Ma ','','','','','shu ','','fu ','','','',
        'xie ','lang ','','','','','','','','zhe ','','','can ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x23f':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','','','ze ','shuai ','','','Bot ','','','','','Vui ',
        'Lung ','Ngau ','Doi ','Xop ','','','','Lot ','','','','','Tran ','Lang ','','',
        'Ngau ','','','','','','Veo ','','','ru ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','an ','jian ','','53066.030,teng ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Doi ','','','','Khoi ','','','Xoi ','Bui ','',
        '','','','Ngau ','','','fu ','','su ','','lian ','','he ','','','',
        'ze ','','','','','','','','','','','','','','','',
        '','','','xiao ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x240':[
        '','','','','','','','','','han ','','','','','','',
        '','','','Loc ','','','Ngoi ','Rua ','Vung ','','','','Tanh ','yu ','','',
        '','','','','','','la ','','','jian ','','','','','','',
        '','','bian ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Dao ','Khoi ','','','','Trong ','Bot ','','Chua ','','','','',
        'Dao ','dan ','jie ','bai ','','','xian ','','','','','','','','','',
        '','cai ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','zhuan ','','','','','Rua ','Dan ','Phun ','Loi ','Toe ','','',
        '','','','','','','','','','','lan ','','yao ','','','xuan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Leo ','','Muong ','',
        '','','','','','','','Thuot ','lan ','','','','','','','',
        '','','','','','','Deng ','','','','xun ','','','','','',
        ],
    'x241':[
        '','','','','','','','','','','','','','','','',
        '','fan ','','','','','','','','','','','','','','',
        '','','','','','ta ','','pan ','','','','','','','','Trong ',
        'Nhan ','','Can ','','','','','','','','','','','','','',
        '','','','','','','','','','','yan ','','','','man ','',
        '','','can ','','','','','','','','','','Veo ','','','',
        '','','','men ','','','','','','','','','','','','',
        '','','shuan ','','','','','','','','','','','','','',
        '','cheng ','','','','','','','','','','','','Chi ','','',
        '','','','','','','','','','','','','gua ','','xu ','',
        '','','','Saap6','','','','','','','','','','','','',
        '','','','','','','','','Tom ','','','','','','','',
        '','','','','','','','','','','','','Kho ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Say ','Phoi ','Tat ','','','','','Bep ','',
        '','','Nhum ','','','','','','','','','','','','Ying ','',
        ],
    'x242':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Lui ','',
        'Sot ','Ngut ','','','','','','he ','','','Cho ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','lao ','shao ','',
        '','','','Tro ','','Tro ','Se ','Heo ','Ngun ','','','Toa ','Rang ','','','',
        '','','','','','','','','fu ','','','kai ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Luoc ','','','','','','','','','','','','','',
        'Roi ','','','Tro ','Nhem ','','','','','Rom ','','Phoi ','Phoi ','Lom ','','',
        'Ben ','','','','','','la ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhu ','','','','','','Ranh ','Nau ','Khet ','Kho ','','Phoi ','Kho ','Choi ','Um ','',
        ],
    'x243':[
        '','','su ','','','','','','','','','','','Hok ','','',
        'han ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','gan ','','','','','','',
        '','','','Hay ','','','Ngot ','Nau ','','Ngun ','','','','','','',
        '','Chong ','','shu ','','Jau ','','','','','','','zao ','','','',
        'Jit6','','','','Zhang ','','','','','','','','','','','',
        '','','','','','','Loa ','','','','','','','','','',
        '','','','','','','','','','','','','','Quac ','','',
        '','','Phap ','','','Tat ','','','','','','Ram ','','','','',
        '','','','','','','','zhu ','','','','','','','','',
        '','Zuan ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Nhoi ','','Ho ','Thui ','Khet ','Thap ','Se ','','Rao ','Buot ','','','','',
        '','chu ','Zhou ','','','','','','','','','','','','','',
        ],
    'x244':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Ham ','Nau ','','Soi ','','',
        'Luoc ','','','','','','','','','kai ','','','','','','',
        '','','cuan ','','','','','','','','','','','','','',
        '','','','xian ','','','','','Chang ','','','','','Hung ','','',
        '','','','','','Xun ','','','','','','','','','','',
        '','','','','','','','','','','','Bung ','Loe ','','','Sem ',
        '','','','','','','','ye ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Nung ','Nau ','','yao ','','Nhui ',
        '','','Lom ','','','','Sem ','','','','','','','','','',
        '','','','','Thap ','','','','','','','ta ','','','','',
        '','','','','','','Ram ','','','','','','','','','',
        '','','','Lo ','','','','','','','','','','','','',
        '','','','','','','','','','Ben ','','','','','','',
        '','','','','','','','','','','Vau ','','','','dao ','',
        ],
    'x245':[
        '','','','','','','','','','','','ju ','','','','',
        '','','','','','','','','','','shang ','Su ','','','','',
        '','','','bao ','','','','','','','','','','','','Vuot ',
        '','','','','','','','Danh ','','','','','','','','',
        '','','','','','','','','','','shen ','','','','','',
        '','','','','Cha ','','','','','','','','','','zhu ','',
        '','','','','','','','','','','','','','Jiang ','','Jiang ',
        '','','','','','','','diao ','','','','','','','','',
        '','','','','','','zhan ','','','','','','','','','',
        '','','die ','ze ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','he ','','','','ju ','','','','Lop ','','','','xiang ','','',
        '','cu ','','','','','Mui ','','Sip ','','','','','','','pei ',
        '','','','cheng ','','','','','','','','lian ','','','','',
        '','','','','','','','','die ','','shu ','','','','','',
        '','','Tam ','','','pu ','','','','Phuon ','','chan ','','','','',
        ],
    'x246':[
        'dao ','','','','','','','','','','','Nga ','','','','',
        '','','','Nanh ','hu ','','','','','','','chun ','','','','',
        'tian ','','','chen ','','','','','','','','','','','','',
        '','','zhuang ','','','hu ','','shu ','','','','','','','','',
        '','','','','','bai ','','','','','','','','','','qu ',
        '','','xie ','','zhao ','','','','','','','tu ','','','','',
        '','','','','','','','','','','','','','','Ngau ','',
        '','','','','Caau ','','','','','','','','','','','',
        '','','','','','mu ','','Nghe ','','','die ','','','','yu ','',
        '','','','','','','','','','','du ','','','','','',
        '','du ','','','mei ','','Co ','Sao ','','','','','','','','xiu ',
        '','','','','','bu ','','','','','','','','','','',
        '','','','','','','','Chan ','','','','','','','','',
        '','','','','','','','','','','','','','su ','Nghe ','',
        'Trau ','','ceng ','ta ','','','jue ','xun ','','','','','','qun ','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x247':[
        '','','','','huai ','','','zhan ','','','','','','','','',
        '','','','','ju ','ba ','lei ','','','','','','','','','',
        '','','','','zhe ','','','','','','','','San ','Tu ','','Cop ',
        '','','','','','21335.010,yan ','','hu ','','yu ','','','','','','',
        '','','mu ','','','','','','','','','','','','','',
        'hao ','Muop ','na ','','','','','','hu ','','','','','','Chuot ','',
        '','','','','','','','bao ','','','','','','','lu ','',
        '','','','','','','','','','Chu ','','','','','','',
        '','','','','','','','','','shu ','','','','','','',
        '','','','San ','Thac ','Tay ','','','','','','zang ','','','yu ','',
        'cha ','xie ','','','','','Moi ','Khon ','','','','','','','','',
        'qiu ','','hu ','zai ','jue ','','han ','','','','','Hum ','','','','an ',
        'zao ','','','sha ','','xian ','','','','an ','','','','zhe ','jue ','',
        '','','','','','','','','lu ','','','','','xia ','xiao ','',
        '','','dun ','','','','','','','','tu ','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x248':[
        '','','','','Ga ','Voi ','','ge ','','','','Trau ','','','','',
        'ta ','Lau ','','','','','','','','','su ','','','','','ta ',
        '','','','','','','','','','','fu ','','','','','',
        'Gau ','','','','','','','','','','','','','cu ','','',
        '','','','su ','','','','','','','','','','','','',
        '','','','','','','','','','','','Nanh ','','','','huan ',
        '','','','','','','','','','','','','','','Ran ','',
        '','','','','','','xu ','','','','','','','','','',
        '','huan ','su ','','','','','Vuot ','San ','','lu ','','','','','',
        '','','','ju ,qu','Nhen ','Dou ','','','su ','','','','','','','ze ',
        '','','','','','','','','','','Lie ','','','','','',
        '','','','','','ai ','','','','','xie ','','','Nhat ','','',
        '','','','','Beo ','','','','','','','','xiao ','','','',
        '','xie ','','','','','','','','','','','','','','',
        '','Doc ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x249':[
        '','','','','','','','','','','da ','','','','','',
        'su ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','wai ','','','','',
        'Vua ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','su ','','','liu ','','','','','','','','',
        '','','','','','','','','','','','','','Xa ','','',
        'mao ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Cung ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','yu ','Cong ','','','','','',
        '','','','jian ','','','','','','wan ','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x24a':[
        '','','','','','','','','','','','','','lu ','qu ','',
        '','','','','','','hu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','zhuan ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','hao ','xiang ','','','hao ','','',
        '','dian ,tian','ge ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','chan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','qia ','jiao ','','','','','','','','Dua ',
        ],
    'x24b':[
        'Dua ','','','','','','','','Hau ','','','','','','','',
        '','','','','','','','','','','','Lu ','','yan ','','',
        '','','','','','','wa ','zu ','fan ','','','','','','','',
        '','xu ','','','','','','na ','Sanh ','','','','','','','',
        '','','','','','','','','diao ','','','','','fan ','','',
        '','wu ','','','','','','','','','','','','','','fu ',
        'na ','','','','','','','','','','','','','','','',
        '','hu ','','','su ','','','','','','','','','xu ','','',
        '','','','Ang ','','','','','','','','','','','lei ','heng ',
        '','Be ','','','','','','Lo ','','','lei ','','shan ','','','',
        'Muong ','','','','','','','lu ','Lung ','','jun ','','','Chan ','','xie ',
        '','zhe ','','','','','','liu ','lei ','','','','dai ','','Ngot ','Ngot ',
        '','','','','','','Ngon ','','','','','','','','','',
        '','Lam ','','','','','','','','','','','','','','',
        '','','','','','','','','Song ','Song ','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x24c':[
        '','','','','','','','','','','','','','','','',
        '','pu ','','','','','','','','','','','','','','hang ',
        '','','','','','','zha ','','','','','','chao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','na ','na ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','diao ','','','','','','',
        '','','','','','','','xie ','','','','','','fu ','','',
        '','','Duoi ','','','','','','','','','','Ruong ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','juan ','','','','','','','',
        'mao ','','','','','','','','','','','','','','','',
        '','','','','','cha ','Trai ','Trai ','','han ','','','','','','',
        '','','','','','yu ','','','','','','','','','','',
        '','','Trong ','','','','','','Roc ','','','','','','','zhu ',
        'Ve ','Ruong ','','','lei ','','','','','','','','','Ruong ','','',
        ],
    'x24d':[
        '','','','','','','','','','','','','','die ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Ngat ','','','','','','','','Bot ','','huan ',
        '','du ','','','','','','','','','','','','','','',
        '','','','','','','','','','','du ','','','','','',
        'wu ','','wen ','','','','','','','','To ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Si ','','','qia ','','','','hai ','','',
        '','','','','','','','','Tay ','','','','','','Chau ','',
        '','Nhan ','Ben ','','','tun ','fu ','','','','','','zhuang ','','','',
        '','','','','','','','','','','','','','','du ','',
        '','chuan ','','','','','','','Naa ','Guoc ','','Nghen ','Mang ','Mut ','','',
        '','','fei ','jian ','','','','Wak6','','','','','','','','',
        '','jiu ','','','lun ','','','','dao ','de ','','','','','','la ',
        '','','ju ','','','','','','','','Mang ','Cek ','','','','Loet ',
        '','','','Nhom ','','','Buou ','','','wai ','','','','','','',
        ],
    'x24e':[
        '','','','','','','','','','','dai ','','','','','',
        '','fu ','Ngung ','','','','','fu ','','','','','','','','',
        '','','','','','','','Hoen ','','','','yun ','','','su ','',
        '','','','','','bu ','','qun ','','','','Naa ','','','','',
        '','','','','','','','','','','','jue ','','','','',
        'Lit ','','','','','','Hen ','','Nhoc ','Choc ','','chen ','','','','',
        '','','','hu ','teng ','','','','lian ','','','','','','','',
        '','','','','','','','','','','','','Buou ','Not ','','Ngo ',
        '','','','','','','','bian ','','','','','','','','',
        '','','','Bie ','','','','','','','','','','','','',
        '','','','','','','','Zang ','','','shan ','','','Buot ','Gua ','Mun ',
        'Khom ','','','','Buou ','','','','','','','juan ','lu ','','ao ','',
        '','','','','','','','','','','','','','','Cum ','',
        'Hom ','','Toi ','','','','','','','','','','','','','',
        '','','ai ','','','','','','','','','Nhoi ','','','','',
        '','lu ','','','','','bian ','','','','','','','','','',
        ],
    'x24f':[
        '','meng ','','','','','','','','','','chan ','','','','',
        'guan ,huan','','','','','','','jue ','lei ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ju ','','','','','Dang ','','','','','','','',
        '','','','','','huan ','','','','','','','','','','',
        '','','','er ','','huan ','','Nguoi ','','','','','','','','',
        '','','','chang ','','','','','','','','','','','','',
        '','zu ','','','','Phau ','','','Trang ','bai ','lu ','','','','','nian ',
        '','','','','zhu ','hu ','','','','','','','','','','',
        '','','','Tram ','Vang ','','','','','','','miao ','','','','Ho ',
        '','','','','','','','','','','','yao ','','','','',
        'Nguoi ','','','','','bie ','','','','','','','','','','',
        '','','Saai ','','cun ','','','','','','','','','','Pi ','nan ',
        '','','','','','','','wa ','','','','','','','','xun ',
        '','','','cheng ','','','Da ','han ','xiao ','','Zaap ','','','','','',
        'Trong ','','','','lu ','','','','','','','','','ta ','','',
        ],
    'x250':[
        '','du ','','','','','','','','','','','Giay ','','','',
        '','','','liu ','lu ','','','','','','','','','','','',
        '','','','xue ,qiao','','la ','','','','','','','Jim ','','','',
        'la ','','du ','Mo ','','lu ','','','','','','','','','xiang ','',
        '','','jie ','mang ','','','','','','','','','','','','',
        '','','Ngaau ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','diao ','',
        '','','','','','','','','','','','','','','','',
        '','Jim ','','ju ','','','','','','Trom ','','tu ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','hu ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'cha ','','','','','','','','','','','','','','','',
        '','Mam ','','','qu ','','','','','','Mam ','Mam ','','','','',
        '','','','','','','','','Vuc ','','','','','','','',
        '','Nhap ','','','','fan ','','','','chuan ','yao ','','','','du ','',
        ],
    'x251':[
        '','meng ','','','','','','','mu ','','','','','','Cik ','',
        '','fu ','','','','','','','','','','','','mian ','','',
        '','','','','','','','','','','','Gap6','','','Nham ','Ngom ',
        'Nhon ','','mie ','','Xue ','xu ,yu','','','','bao ','','','','','','',
        '','','','Nhon ','','','','','Laap ','','','','','','','',
        '','dian ','fan ','','','','','','','','','','','','','Ngaau ',
        'Hau ','er ','','','','','','','','','','','','','','',
        '','','Chau ','','','wei ','','','','','xu ','','','','Zong ','',
        'Giuong ','','','Nho ','','','','','','yu ','','','jue ','','','',
        '','','','','','','','','','','','xu ','wang ','','juan ','',
        '','','','','','xie ','liu ','','','','','','','','','',
        '','','nao ','','','','wan ','jiu ','','Ngop ','Dau ','Ru ','Le ','','','Quau ',
        'Mang ','Tro ','Bet ','','','','','','Nhon ','','','','han ,qia','','','xu ',
        '','','jie ','','','','','','jun ','','','','','','dian ','',
        '','','','Gwat6','','','','','','','','','','','','mai ',
        '','','','','','','Him ','','','','','Tro ','','','','xu ',
        ],
    'x252':[
        '','','','','chuang ','','mao ','','','huan ','sha ','','','','','kuang ',
        '','','','','','','die ','','','la ','','lu ','','','','Sou ',
        '','','','','','','','','','','','','','','leng ','',
        '','','Ngap ','Chot ','Nguoc ','Nhon ','Nom ','','','','','','','','','',
        'guan ','ju ','','nai ','','ge ','','','','','ma ','teng ','','','','',
        '','','','','','','','','','','','','chen ','','','',
        '','','','','','','','','','','','','Let ','','Soc ','',
        'han ,qia','','','','','Ma ','lu ','','','','die ','','','','','',
        'Xam ','','','','','','','','','','xu ','','Caau ','','','',
        '','','','chan ','','','','','Ghe ','Zong ','','','','Chop ','Quac ','Nhan ',
        '','','','','Nguoi ','','Mu ','','','','','guan ','','zun ','','xie ',
        '','','','','Toet ','','','','','','','','','','','',
        '','','','','','','','Caang ','','','','','Sa ','','','',
        '','','Tre ','','','Trom ','','','Saau ','','','','','','','Nguoi ',
        '','','','jia ','','','','','','','','','','','','',
        '','','Lem ','Coi ','Ngam ','Him ','Lam ','','Soi ','','','','','','','',
        ],
    'x253':[
        'Xet ','','','','','','','','Trom ','','pan ','','','','','',
        'liu ','','','','','','','','','','','Lai6','','','','',
        '','','','','','Khoe ','Len ','','','','','','','xuan ','','meng ',
        'wei ','42521.120,meng ','','','','','','','Dim ','Ngam ','yao ','','','','','',
        '','','','','','','','','','','','','','Lom ','','',
        '','','Cham ','','lei ','','','','Nheo ','','bian ','Ngom ','','','','',
        '','','','hao ','','','','','','','zhai ','','','','','',
        '','ze ','na ','','','','','','','','','','','','','',
        '','','','','','','kai ','','wu ','','','','','ze ','','',
        'yu ','zan ','','','','xu ','','xu ','','','','','','','','',
        '','','cuan ','cuan ','cuan ','','','','','','','','','','','',
        '','','','','','','','','qia ','','tiao ','','','','','',
        '','','','','','','','huan ','','','','','','','','',
        '','','wu ','','','','','','jue ','','','','','ya ','','',
        '','','','','kua ','','','','','','','','','','an ','zhe ',
        '','','','','','','','','','','','','','','','Van ',
        ],
    'x254':[
        '','pu ','','','','','Van ','Ngan ','So ','Ngan ','','','','Ngan ','','Coc ',
        '','','Cut ','','Van ','ya ','','','Shi ','','','','','','Mong ','',
        '','','','','','','','','','yun ','','','','','','',
        '','','','','','','','','','','','','','zhe ','','hu ',
        '','','Chai ','','','','','die ','','','','guai ','','','','',
        '','ao ','','','','','','','','','','','','','','',
        '','','bu ','','','Sinh ','','','','','Nao ','','','','','du ',
        'guai ','','Ran ','','','','Loi ','','','','','','dian ','','','',
        'wu ','','','','','','','','','','','','','','','',
        '','','','','','','','','xun ','','','','','','','',
        '','','','','','','','ya ','lu ','','','','','chu ','','',
        '','','','kang ','','','hua ','','','','','','','','','',
        '','','','','Mai ','','','','','Sanh ','','','','du ','','',
        'jie ','','xian ,kan','','','','','','','','','','','','','',
        '','','','','','','','','','','','','dao ','','','',
        '','','','','Mai ','','','Canh ','','','','','','','','Tuo ',
        ],
    'x255':[
        'Gwang ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','yu ','','','','','','','','','','','','','',
        '','shan ','','','','Ji ','','','','','','','','','','Ham ',
        '','','','','Mai ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','zhe ','','','','','','','','','','','','',
        '','','jue ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','la ','','',
        '','','Quanh ','','','','','','','','','','','','','',
        '','','','','','','','','zao ','Cuoi ','','','','','','',
        '','','','','','','','','','','','','','','','du ',
        '','','','','','','','','','','','','','','','',
        '','','','ta ','','','','','','','dao ','','Chen ','','','',
        '','','','','','','','','Nen ','','','qu ','','ca ','','',
        '','','','','','xiang ','','','','','lan ','','','','','',
        ],
    'x256':[
        '','','','','yu ','','','','','','jiao ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','fu ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Rung ','','','','','','','','','','','','',
        '','','','xun ','','','ru ','','','Lay ','','','','','','',
        '','','','','','','','','','','','','','','','yu ',
        '','','jun ','','','','','','','','lu ','','','','','',
        '','','','','','','','','','','','','','','','',
        'zhun ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','liu ','','','','','','','','','','',
        '','nu ','','','','','','','','','','','','feng ','lu ','',
        '','','','','','zhuan ','','zhe ','','','lu ','','','','','jue ',
        'liao ','','','','','','','','','','','','','','','',
        ],
    'x257':[
        '','','','','','','','','','','','','Ao ','','','',
        '','','Yan ','','','','','','','zan ','','','','','','',
        '','','','','','Yi ','','','','','','','','','jun ','',
        '','','','','','','','','','','','','','','','',
        'she ','','','','wan ','','','','','','','','','','','',
        '','','gua ','','jie ','','he ,xie','','','','','','','','','du ',
        '','','Li ','','','jie ','','ba ','yu ','','','','','','','',
        '','','','','','','','','he ','','','','','Cay ','du ,zha','',
        '','','','','he ','','','','','','','','','he ','','zhu ',
        '','','','','','','Giong ','','zun ','','ru ','Duo ','jiang ','','','',
        '','','','','','','','heng ','','','','','','','','zu ',
        '','','','','ku ','','','','','','','','','','','',
        '','','','he ','','','','','','','','','','','','',
        '','','','','','','','','','','chang ','','','','','',
        '','','','','','','','','','','mao ','','','','','',
        '','','','','','','','','','Lui ','','','Bap ','','','',
        ],
    'x258':[
        '','','','','','huan ','','','','','','','','','','',
        '','','','','','','','','','','','','yang ','','','',
        '','','','','','','','','','','','','Trau ','Giong ','Rom ','Rom ',
        '','','','','chang ','','','liu ','','jie ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','jun ','jiao ','','','','','','','','','','','',
        '','','','','Ji ','','','','','','','','','ai ','','',
        '','','','Nanh ','Mam ','','','','','','','','','','zun ','',
        'Cau ','','','','','','','','','','','','','','','hu ',
        '','','','','','','','','','','','','','','','',
        '','','cheng ','','','','kuai ','','ge ','xie ','','jie ','','','','',
        '','','','','','','zu ','','pu ','','','','','','','',
        '','','','','','','','','','','','meng ','','','','xiang ',
        '','','','','lu ','','','','','','','','','','','',
        '','','','','','','','','mu ','ran ','','','','','','',
        ],
    'x259':[
        '','','','','','','','','','','','zhe ','','','','',
        '','','','','','','','','jue ','','','','','','','',
        '','','','','','','ai ','','nu ','','','','','','','',
        '','','','','','mian ','','','','','','','','','','',
        '','','','','','Lung ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','wa ',
        '','','','','','','','','','','','','','','','',
        '','cheng ','','','','yang ','','','','liu ','','','','qiu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','fu ','','','','','','qia ','dian ',
        '','','jiao ','','','','','','','','','','','','','',
        '','','','','','','xian ','','','','','','','','','',
        '','','','','','','','','','','','','','','Hang ','',
        '','','','','','liu ','','','','','','','','','','',
        '','','','tu ','','','','','','Nup ','','','','','zhe ','',
        'hua ','','','','','','','fu ','','Tam ','','qu ','','','','',
        ],
    'x25a':[
        '','','','','','','','','','','','','liu ','fu ','dan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Trong ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Hoam ','','Chui ','','','','','','',
        '','','','','','','','','','','','','','ca ','','',
        '','','','zhu ','hai ','','','','','','','','','','','',
        '','','Hai ','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','','','','','','fu ','','','Trong ','Trong ','',
        '','','','','','','','','','','','','','','','',
        '','cu ','','','pang ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','dun ','','','',
        'lu ','Deon6','','','','','','','','chen ','','','huang ','shi ','','',
        ],
    'x25b':[
        '','','','','','','','','','','','','','','','',
        '','','','yao ','','','','','','ju ','','','','','','',
        '','','','','','','','','Khau ','Nia ','','','','','Giang ','Kao ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Mang ','Mau ',
        '','qiu ','dun ','','','','','','','','mang ','','','miao ','yuan ','',
        'wu ','','','','','','','','','','','','fei ','','meng ','',
        '','','','','','','Mang ','','','','','','','','','',
        '','','','','','','','Buong ','Hum ','Bu ','','','','','','',
        '','','','','','hang ','','ju ','nian ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Manh ','Tre ','Mui ','','',
        '','','Toi ','Trum ','','dang ','du ','','ye ','','','','','','','pai ',
        '','','','','','','jian ,sha','','','','Trau ','','','','yu ','',
        '','','','','','','','','zhu ','','','','','','','',
        ],
    'x25c':[
        '','','','','','','','','','','Thap ','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','shan ','liu ','','','','','','','hu ','','','','','',
        '','','','xian ','','','','','','','','mu ','','','zhai ','',
        '','','nu ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Ro ','','','','Ghi ','Gianh ','','',
        '','','','','','','','','','','','','','juan ','','',
        '','','','','dan ','','','dan ','','hu ','','','','','lu ','chuan ',
        'wu ','','','','','','','du ','','','shuang ','fu ','ju ','','','diao ',
        'wang ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','fu ','','','','','','xun ','','',
        'Khay ','','','','','','bu ','','','','','','','','','',
        '','fen ','dian ','','','','','','','','suan ','','an ','','','',
        '','','du ','','','','','','dan ','','','','','','','',
        ],
    'x25d':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Thung ','Mui ','','','','','','','',
        '','','','','','','','','ai ','ge ','ju ','tun ,dian','','qia ','','',
        '','jian ','','','','suan ','','','','','','qiang ','','','','',
        '','','','','','','','','','','','','','','','dian ',
        '','','','','','','Toi ','Hom ','Ray ','','Lak6','Nong ','','','jie ','zhu ',
        '','','','','zhao ','','','','','','','','','','','sa ',
        '','','','','','','','','','','','','','','','Mung ',
        'Thung ','','Gay ','','','liu ','','','','','','','','','','',
        '','','','','','','','','','','','','hu ','','','',
        '','','','','','','','','','','','','','','Toi ','',
        '','','','','','','','','','','die ','','','','','',
        '','ban ','','','','','hu ','','','','','','','','','',
        '','','','','yu ','die ','','','','','','','','','yu ','',
        '','','','','','','','','','','','','','','','',
        '','fu ','','','','','','','','','Mo ','May ','cu ','','','',
        ],
    'x25e':[
        '','Nan ','','','','','','','dang ','','','','','','','',
        '','','','','','','','','','','','','','Trum ','','',
        '','','','shan ','yu ','','','','','','yu ','','','','','',
        '','','','','','tun ','','','','','','','','','','',
        'Tam ','','','','','','','fan ','','Nap6','','','','zhu ','','',
        '','','','','yu ','','','','','','','can ','','','','',
        '','','','','','','','','','','','','','','','',
        'Lau ','','','','bu ','chu ','','liu ','Bot ','','','','','','','',
        '','','','','','','','','','','ge ','','','','','',
        '','Tam ','','Lo ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Com ','','','','',
        '','','','','','','','xian ','','he ','','','','','','',
        '','','','','','','','','','','Nam ','','','','bu ','No6',
        '','May ','','','','','sa ','','','mian ','','','','','','',
        '','','','','xia ','','','','Bun ','','','','','','','',
        ],
    'x25f':[
        'zu ','','','ze ','','','','','','','','','','','','',
        '','','','','','Lep ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','xiao ','','','Thung ','','','','','','','','','Com ','','xian ',
        'jian ','','','','Men ','','','','Miao ','','','','','','','',
        '','Phan ','','','Xia ','','','','','','','','niang ','','','',
        '','','','','','','he ','','lian ','','','','','','','',
        '','','','Men ','','zhu ','','','','','','reng ','jie ','','','',
        '','','','','','wu ','','','','','','cu ','','','','',
        '','','','','','','','fu ','hu ','','','','','','jue ','diao ',
        '','','','','','','','','','','','','','','Buoc ','',
        '','Vuong ','Tim ','na ','','','','','','','','','','','','',
        '','','','','','','','Giay ','','','','','','dai ','','',
        '','','','','Khau ','','','','','','','','','','','pai ',
        '','','','','','','','chao ','','','','','','','','',
        ],
    'x260':[
        '','','','','','','','Jing ','','','Dai ','','','','','Thua ',
        '','','','','','','Kep ','','','','','','zhuang ','','','',
        'liu ','','','','','','','','No ','','','','','','','',
        '','','','','','','','','mao ','Thun ','Xe ','Cui ','Noi ','Keo ','Rang ','',
        'Boi ','Nuoc ','','','','','zhuan ,juan,shuan','nian ','','','hua ','','','','','yan ',
        'jue ','','','','','','','','','','','','die ','','','',
        '','','','Go ','','','','','','','','','','','','',
        '','','','','','','','','','Ro ','','','May ','Vuong ','','',
        '','','','','','','','','','','fu ','','','','','',
        '','','','','wan ','','','Sok ','','','','The ','','','','',
        '','','','','','Dam ','','','','','','','','','','',
        '','','','','','','','','','','','Luot ','','','','Buoc ',
        '','','','','','','','','','','','','','','','',
        'Tao ','','','liu ','he ','','','','','','','','','','','',
        '','','','','mu ','','','','','','','','','','Gai ','',
        '','','','','','','','','','','','','','','','',
        ],
    'x261':[
        '','Thun ','Dai ','','Quan ','','May ','','','','','','Chap ','','','',
        '','','','Xau ','die ','','','','','','','','','','Van ','',
        'Nut ','','','Cuon ','','','','','','','','','','','','',
        '','','','','Chai ','','','','Xung ','','Rang ','Quan ','','qu ','','',
        'xun ','','','','zhe ','','dian ','','','','','','','','','',
        '','xun ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Tan ','',
        '','Thua ','','','','','','','','','','','','ju ','','yun ',
        '','','','','','','','','','','','lai ','','','','',
        '','','','','','','','','','','Neo ','','','','wu ','Mung ',
        '','','','','','','','','','','','','','','','Ban ',
        '','','','','','','','','','','','la ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Roi ','','','','','','','','','la ','','','','',
        '','','','','','','','','','','','','yao ','','Chung ','',
        '','','','','','','','','he ','','','','','','','',
        ],
    'x262':[
        '','','Nhau ','nang ','','die ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','yu ','','','','','','','','','','','','',
        '','','','','','','','','yu ','','','','','','','',
        '','','','','','','Cha ','','','liu ','','','','','','',
        '','','','','','','','','Caang ','bian ','','','','','','ya ',
        '','','','','','','','ya ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','hu ','cen ','','','','','','','','','','','','',
        'ju ','','','','','','','','hu ','','Bon ','Tu ','','','','',
        '','','','','','','fu ','hu ','','','','','','','','',
        '','','','','','','','','','','','','','meng ','fu ','liu ',
        '','','','','','xie ','','','xian ','','','','','','','',
        '','','','','lu ','','','','','','','','','','','',
        '','','yu ','han ','','','Ra ','','','','dan ','','','','','yu ',
        '','','','','','','','','','','','','','','','',
        ],
    'x263':[
        '','','','','','','','','','su ','su ','','','','','',
        '','','liao ','','','lu ','','','','','','','','','','lu ',
        '','','','','','','huan ','','','','','','','','','',
        '','','','','','','','du ','','','','','','','','',
        'nan ','','','','','quan ','','','','','','','','','','fen ',
        '','','ta ','tun ','','','','','','','','','','','','',
        '','','','','','','','','','Gu ','fen ','','','','','',
        '','','','','','','','','shan ','','','','','','','',
        '','','','','su ','','','chuan ','','','','','','','','',
        '','','jie ','','','','','','yu ','','','Guong ','chuan ','','','',
        '','Xinh ','','','','','wu ','','','','','','Tanh ','fu ','','',
        'gu ','','','','','','','','','','','','','','','',
        'ren ','','','','','jue ','','','','','','','','','','',
        '','','','Bon ','','du ','','hu ','','','','','yu ','','','',
        '','','mai ','','','','','','huai ','','','','','','','',
        '','','','','','','','','','','','yu ,yu','','','','',
        ],
    'x264':[
        '','','','','','','','Taap ','Fen ','','','','','','','',
        '','','','','','','','','','','','qu ,yu','','','','',
        '','fu ','','','hai ','','','','','','','','','','','',
        'chai ','','','','','','','','','','','','','','','',
        '','','','','','','','ta ','','','','zu ','','xu ','yan ','chai ',
        '','','','','','','','','','','','','ge ','','','',
        '','','','','','','','','','','','','','','','',
        '','','ta ','','','','ta ','','','fu ','','','','','liu ','',
        '','','','','','han ','','','','','','','','','','he ',
        '','yu ','','','','','','','','','','','Zin ','','','',
        '','','','','','','la ','','','','','','','','','',
        'tai ','','','','','Khu ','shu ','Bou ','','','dao ','','','','','',
        '','','','','','Gia ','','Khu ','','Lu ','','wang ','','','nai ','',
        'jue ','','','','','','','','','','','','','','','',
        '','Ma ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x265':[
        '','','','','','tu ','','','ze ','','','','','fu ','','',
        '','','','','','','','','','Cay ','','','','','','',
        'pai ','','','','','','kuai ','','','','','','qu ','','zhe ','sha ',
        '','','','','','','','','','nai ','','','','','','tian ',
        '','','','','','','ye ','','','','','','','','','sao ',
        '','','Zim ','xu ','','','','','','qu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'duo ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','hua ','','',
        '','Nghe ','','','','','','','','','','','','','','',
        '','','','','','','','yan ','','','','','','','','',
        '','','','','','','','','','','','Tai ','hu ','','','Dap ',
        '','tian ','','','','','','','','','','','','ai ','','Lang ',
        'ai ','zhe ','','lu ','','','','zhe ','','','','','','','Ghe ','',
        '','','','hu ','','','','','','','','','','','','',
        '','','','','','','','','','','','ju ','','','','',
        ],
    'x266':[
        '','','','','','','','','','','','','','wai ,wa','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Paa ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'pan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Moc ','Mao ','Hong ','Tim ','','','','','','','','ju ','dai ',
        '','','','','zhu ','Wan ','Gu ','','','ban ','','mai ','Ci ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Ping ','','','Zaap ','','','','','','','','','',
        '','','','hen ','','','','','','','','xie ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Ruot ','','','ku ',
        'na ','','','','xuan ','','','','he ','','Nam6','','Ham ','','','',
        '','','','','','','','','','','','','','','','',
        '','','jue ','','','','','','','','Bet ','Thon ','','','Nuc ','Mang ',
        ],
    'x267':[
        '','','','xu ','','','','','','','','','','pang ','','',
        '','','','','','','Ngaa6','','Vu ','','','','','','Ron ','',
        '','','','','','','','','','','','','','','','',
        '','','','','tun ','','','','','','','','','','','',
        '','','','','Rang ','','','','Ngac ','','','Mun ','Mep ','','Phop ','',
        '','','','','','','','','','','','','','huan ','','',
        '','Jim ','','','ban ','','','','','','','','tu ','','','',
        '','','','xu ','','','','','','','','','','','','',
        '','Tuoi ','','','','','','','','','','','','','Nghen ','',
        '','','','Phay ','','','','','','','','','','','','',
        '','','Tao ','Sao ','','zhe ','','','','','','sai ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Bo ','Zin ','Gay ','Suoi ','Khu ',
        '','','','tun ','','','','Nem ','','','','','ze ','','','',
        'cu ','','','','Xiu ','','','','','','','','','','','',
        '','','hun ','ju ','','','Nem ','','','','','','','','Khu ','',
        ],
    'x268':[
        '','cu ','','','','xun ','Sun ','ceng ','','','','','','','','',
        '','','jue ','','','','pao ','','Vai ','','','','','','','',
        '','','jiu ','zhe ','','','shu ','','','','','','','','','',
        '','Phet ','','','','Roi ','Seo ','','','','','','','','','sa ',
        '','','','','du ','','Fat ','','','','','Ron ','','','','',
        '','','','','','','','','','','','','','','Ngam ','Lung ',
        'Song ','','Rau ','','','','','','san ','','','','','yu ','','',
        '','yao ,shao','','','','hun ','Lom ','','','','','','','','','',
        '','','','','','','','','','','Pok ','','Duk6','','guang ','',
        '','','','Mak6','','','','','','','','','','','','',
        'Rang ','','','','','','','meng ','','','','','','','','',
        '','','','Vai ','Lot ','','','','','','','','','','','',
        '','','','','lei ','','','Lo ','','','','','','','Nan ','',
        '','','qu ','','','','','Nhau ','','Nang ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Zak ','','','','','','','lian ','','','','','','','',
        ],
    'x269':[
        '','','','','','','','','','','ru ','yao ','','','Gao ','',
        '','','','','','','','','','wa ','','','','','','',
        '','','','','','','Hot ','zhai ','','','','','hai ','','Thoi ','Kham ',
        '','','','','','','','','','','','','','','','',
        '','wu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Xue ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','fen ','','','','','','','','Kyo ','','xiao ','','','','',
        '','','cheng ','','','','','','','yu ','','yu ','','','','',
        '','','','','','','','','','','','','','juan ,fan','','',
        '','','','Lau ','','Weng ','','','','','','','','','','',
        '','','','','','','tian ','','hu ','','','ta ','','','ta ','ta ',
        '','','','','','ta ','','','','','','','huai ','','','',
        '','ta ','Loe ','','','hua ','','','zhuan ','','Laai ','','','','','',
        ],
    'x26a':[
        '','','Mua ','','','','','','fu ','wu ','','fu ','','','ta ','',
        '','Chai ','','','','','chao ','','','','','','Qua ','','','',
        '','fu ','','','','','jia ','','','','','','','','','',
        '','','','wu ','','','','','','','','Khoang ','','','','',
        '','','','','','','','','','','','bai ','','','','',
        '','','','','','','','','','','Mui ','Gu ','','','yu ','',
        '','fu ','xian ','','','','','','','','','','','','','',
        '','sheng ','','','','jian ','','','','','','','','','','sha ',
        '','','','','','','','lu ','Ao ','','','','','','','Thong ',
        '','','','','dun ','','','','jue ','ta ','zun ','','','teng ','','',
        'hua ','','','','','','','','','','peng ','','','','','',
        '','','','','','Ghe ','','','','','','Khoang ','Ghe ','','','',
        'teng ','','','','','','','','','','','','','','','',
        '','','','','','','','','','ba ','','','','','','',
        '','','','','','','','','','','wa ','','','','','xun ',
        'meng ','','','','','','','','','','','','','','','',
        ],
    'x26b':[
        '','','wu ','zhe ','','','','','','','','','','','','',
        '','','','','','','qiu ','','','','hu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','zhu ','','','','','','','',
        '','','','','','','','','hu ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Tup ','','','Hung ','','','','','',
        'ru ','','','','','','','','','','','jiu ','','','','',
        '','jiao ','','','','','','','','','','','','','','',
        '','pu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Nen ','','','','','fu ','','','','','','',
        '','','','','','xu ','','','','','','','','','','',
        '','zao ','','','','','','','','','','','','','','',
        '','','','cu ','','','','','','','xiao ','','Dua ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x26c':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fen ','','','','Ngon ',
        '','','Nua ','','Lau ','','','','','','qiu ','','','dun ','','',
        '','','','ye ','','','','','','','fu ','','','','','',
        'yu ','','yu ','yu ','Gu ','','','','','','','meng ','','','','',
        '','','mu ','','Bei ','','Fu ','','','','','','xiao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Nhai ','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','wan ',
        '','','','','','','','Lei6','','','','Rom ','','','Muop ','',
        '','hao ,mao','','xie ','','','','','','','','','','','','',
        'nai ,na','','','fu ','du ','','','','','Tre ','','','','','bai ','',
        '','','','xun ','','','','','','','','','he ','','','',
        '','','','','','','meng ','','','','','','','juan ','ru ','',
        ],
    'x26d':[
        '','','','','','','','','','hu ','','Mong ','jun ','she ','','',
        '','','','','meng ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Ke ','','','Nu ','','','','','',
        '','','','hun ','','','','','','','','','zu ','','','',
        '','','','','jie ','','','','','','','','jun ','','','',
        '','','','','','','','','','','','shan ','','','','',
        '','ta ','','','','','','','','heng ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Kou ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Chu ','','',
        '','','','','','','qiang ','','','Bom ','','','','','','Mai ',
        '','','','hu ','','','','hai ','ru ','meng ','','','','wu ','','',
        ],
    'x26e':[
        '','','','','','','','','','qia ','','','','','','',
        'lu ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','pei ','','','','','',
        '','fu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','zhao ','','','','',
        '','','','Thom ','','','Voi ','Bui ','','Nhai ','','Dam ','','','','',
        '','','','','','','','du ','','','','','','','','',
        '','','','','','','ju ','','','','','chuan ','Lao ','','','hu ',
        '','','jie ','xiang ','','','','','xiang ','','','lang ','','','','',
        '','','shuan ','','','chu ','','','','','','','','','','',
        '','dan ','','','','sa ','','','','','','','','','','',
        'Zaau ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x26f':[
        '','','','Sang ','','','','','ju ','','leng ','lu ','','','','',
        '','','','','','','','','','','Lum ','San ','San ','','Dua ','Khay ',
        'Sung ','','she ','','','','','sa ','','','mao ','qu ','','','','Zuk6',
        '','juan ','','','','he ','','','','','','mei ','','','','',
        '','','lu ','mian ','dian ','','','','','','Waa ','','','','lu ','fu ',
        '','','zei ','','Om ','','','','','','','','dan ','','wan ','',
        '','','','','','','','','','','','','','','','',
        'Tranh ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','sha ','','','','lu ','',
        'Dua ','','','','','','','','','dan ','','','','','','',
        '','','','','','','jian ','lu ','','','','','','ta ','','',
        'chu ','fu ','','','','','dang ','','','','lu ','','','','','',
        'jie ','','','','','','lu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x270':[
        '','','','','chang ','','meng ','','','','','','su ','','','Sung ',
        '','Giong ','Non ','Ru ','','sa ','','','','','','','Sam ','','','',
        '','zhan ','','','','','','','Lop ','','','','','','','',
        '','chai ','','','','','','','','','xie ','','','','','',
        '','','','xu ','','','','','','fan ','meng ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Ghem ','','','','','','','','','','','',
        '','zhan ','jian ','han ','dan ','','jian ','','','','','','','','','',
        '','','','','hu ','','','','','','','meng ','ju ','','','',
        '','meng ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Dua ','','','','chu ',
        '','','','','','','','','','','','','','','','',
        'yu ','','','','','','','','','','','','','','','',
        '','','','','','','Muong ','Khoai ','','','','','','','','',
        ],
    'x271':[
        '','','','','','','','','','','Han ','','','','','fu ',
        '','','qu ','','','','','','','','','ju ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Mo ','','','','','','','','','','','','','',
        '','','','','','','','','diao ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Men ','Muong ','','',
        'hu ','','','','','','','','','','nang ','','','','','',
        '','','','','Thuoc ','','','','','','','','','','','',
        'gan ','','','','','','','','','','','','','','','',
        '','xu ','','lu ','','','','','','','','','','','','hu ',
        '','','','','','','','','','','','','','','','',
        '','','','','lu ','','','','zu ','','','','','','he ','',
        '','','','','','','','','','','','','','shu ','','',
        'yao ','','','','','','','','','','','','','','he ','',
        'hu ','','','','','','','','','','','','hao ','','','zu ',
        ],
    'x272':[
        '','','','','xia ','','','','','','','','ge ','','','',
        '','ge ','','','','','ge ','','','','42573.210,zhu ','','teng ','ya ','','',
        '','','','','','','','','','','','','','wu ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','tai ','','','','','','','','Trun ','Vat ','','','','','',
        '','','xue ','yu ','fan ','','','','','bu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Gwaai ','','dai ,de','','Buom ','Nhong ','','','','Vat ','',
        'Trut ','','','','','','','','ku ','','','qu ','','','','ru ',
        '','','','','','xu ','','','','','','','he ','','','',
        '','','','','','Gong ','Doe ','','','','','','','','','',
        'Chau ','','','','','','','','','','Saa ','','du ','Chet ','','',
        '','','','kao ','','','','','','','','','','','','Moi ',
        '','na ','','','','','Mei ','','','','','','','','','',
        '','','','','','Cuong ','Mot ','','','','Chay ','','Nhong ','Mang ','','',
        ],
    'x273':[
        '','','Bo ','','','','','Bang ','fu ','lu ','','','','lu ','','ta ',
        '','','','Fu ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Cua ','','','','','Ngai ','','','','Cua ',
        '','','','shuai ','','jue ','','','','fan ','','','','','','',
        'jie ','','','','','','','','','jie ','yu ','','','','','feng ',
        '','die ','','','lian ','hu ','','','','','','','','','','dian ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Chau ','','',
        '','','','','','shan ','','','','','','','','','','',
        '','','zu ','','zhe ','','','','','','','','','','','',
        '','','xie ','xie ','','','','','','','','','','','','',
        '','','','liu ','','','','','','','','','','','','',
        '','','','','','jie ','','','','','','sha ','','','','Nhuc ',
        'Sam ','','','Bo ','Choi ','','','Nhuc ','','ai ','','','','','','zhu ',
        ],
    'x274':[
        '','su ','','xie ','yu ,yu','Zeoi ','','','zu ','','','','','','','',
        '','','su ','','','','Luon ','','','wu ','','','','','','',
        '','','Hou ','','','','','','','','','','','','','',
        'du ','','','lu ','su ','','','','','','','','','','Bo ','Sung ',
        '','Sam ','','Ngao ','','Vet ','Chang ','','','','','','','','','',
        'yu ','','Giun ','','dai ','','','','dang ','zu ','','','','chuan ','','',
        'du ','','','','','','xie ','zhe ','','','','sao ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','fu ','','','Buom ','','Sau ','','Rua ','','Rom ','Rua ','Rua ','e ','',
        '','','','','','','','','','fu ','','','lei ','','','',
        '','','','','','','','','chai ','','','','','','','',
        '','','','','','','','','','','','','','lei ','','zei ',
        '','ai ','','','','','','','','','','','','Ban ','','',
        '','','','','','','fei ','','','','','','','','','',
        '','','','','','','','','','','','','','','','Ngoe ',
        'Sam ','','','','','','','','','','','','','','','',
        ],
    'x275':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ta ','','','','','','','','','du ','qiu ','','',
        '','','','','chai ','','','','','','','','e ','','','',
        '','','','','','','','','','','','','','','qu ','',
        '','','','','','','','','','','Trai ','','','','','',
        '','fu ','','','','','','chai ','zang ','','','','','','','',
        '','','','','Naan ','','','','','','shuang ','','','','','',
        '','','','','','','ta ','','','','','','','','','',
        '','','','','','','','','','','fu ','','','','','',
        '','','','','','','Moi ','','','','','','','','an ','',
        '','','','','','','','','','','','','','','','xiang ',
        '','','','','','','','','n ','','','san ','hu ','','zu ','',
        '','','','','','','','Jiku ','','','','','','','','',
        '','','','','','','','','','la ','yu ,qu','jue ','','','','',
        '','shu ,yu','','','Jung ','','','Jutsu ','jian ','','','','','','','shuai ',
        ],
    'x276':[
        '','','Chong ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','hu ','','','','','','','','','','','','','',
        '','','','','','','','','','Taai ','','','','','','',
        'La ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','pu ','','che ','','',
        '','','','','','','','53077.090,jian ','','','','','','zhan ','yuan ','',
        '','','','','','','yu ','','','','','Lot ','','','','',
        'mu ','huan ','','','e ','Long6','','','','','','peng ','','','','',
        '','','','','Tung ','','','','','','','','','','','',
        'Song ','','Xong ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Trang ','Lun ','May ','','','','','','',
        '','','','','du ','','','tu ','','','','','','','hu ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Toi ','','','','','','','','',
        ],
    'x277':[
        '','Sha ','','','','','','','','','','','','','','',
        '','','','','','','Chan ','Mo ','','Xong ','','','','','','',
        'shuai ','','','','','','su ','','','','','','','','','',
        '','','','','','','','','','','Bau ','','','','','',
        '','','','jue ','','','','','','','','','','','','',
        '','zhan ','heng ','','qu ','wei ','','','bao ','','','','','','Gei ','',
        '','','','','','','','','Cheo ','Toang ','','','','','','',
        '','','ju ','he ','','','','','','','','','','','','',
        'shu ','','','','','','','','','','','','','','','yu ',
        '','meng ','hu ','','','','','','','','','','','','','',
        '','','','','','','','','','jie ','La ','shu ','jie ','lei ','','',
        'zu ','','','','','','','','','','su ','','','','','',
        '','','','xie ','','','','','','','','','','','','',
        '','','','','','','','','nang ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x278':[
        '','','','','','','','','cha ','','mao ','','','','','',
        '','','xian ','','','','','','','','','chan ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','gao ','','','',
        '','','','','','','','','','','Thay ','','','','','',
        '','jiu ','','','','','','','','','','','','','','',
        '','yun ','','','','','','','','','','','','','','',
        '','','','','lian ','','','','','','','','','','','',
        '','','','','','','','','','','','lao ','','','','',
        '','Don ','','','','','','','','','','','','Lai6','','',
        '','','yao ','','','','','wei ','','','','','','','','',
        '','','','','','','chu ','','','','','','','e ','','',
        '','','','','','','','','Caau ','','','','qiao ','','','',
        '','','ju ','','','qiu ','','','','','','','','','','',
        '','','hun ','','','','','Dia ','','','','','','','','',
        '','','','','','lun ','','','jue ','','','ju ','hu ','','','',
        ],
    'x279':[
        '','','','','','','','','','','','','','','','',
        '','ju ','','','','qiu ','','','','','','','','','','',
        'zhe ','','','','','','','','','','','','','Ba ','','',
        '','','','','','','','','','Thoi ','','','jue ','','','',
        '','','','Choi ','','','su ','','','','','','kuang ','','jue ','',
        '','','','','Va ','','','','','','','','','','tan ','',
        '','','','','','','','','','','','','','','','hu ',
        '','fu ','','','yang ','','','ren ','','','Kwan ','','yun ','','','xun ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','pu ','',
        'Ngaak ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Beng ',
        'Ngoa ','','','','wang ','','','','','','','','','','','',
        '','','','xu ','','','','','','','','','','Ngaa6','','',
        '','','','','','','','','','','','','','','','Khoang ',
        '','','','','','','tu ','','bie ','','','zha ','','','','',
        ],
    'x27a':[
        '','','','','','','','','','','Zaa6','','','','','',
        '','','','','','','','','','','','','','','','',
        '','chen ','','','','','','','','','','','','','','',
        '','','','','','','','','','lu ','','','','','Tam ','',
        '','','','','','yan ','','','','','','','','','','',
        '','','','','','','','','','Daan ','','','','su ','','',
        '','','','','','','','','','','','','','','','',
        'bian ','','la ','','','','qia ','','','','','','','','','',
        '','','','','','nu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','he ,ge','',
        '','','','','','','','','ma ','','','','','','','',
        '','','','','','','','','','xia ','','','','','','',
        '','','','','','','','','','','yu ','','','','','',
        '','jie ','xia ','','','','','cha ','','','','yang ','','','','',
        '','','wang ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Mo ','','jiu ','',
        ],
    'x27b':[
        '','hao ','','','','','','','','','','fa ','','','','',
        '','','','','','','','','','','','','','','yun ','',
        '','','','','','','','','Wai ','','gun ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','dan ','','','','','','','meng ','','','','','',
        '','','','','teng ','','','','','','','','Leoi6','sa ','','',
        '','','','','','','','','','','','','','','','',
        '','','','he ','','','','','','','','','','shan ','','',
        '','','','','','','','','','','','','','','','',
        '','ta ','','','','','','liu ','','','','','','','','',
        '','','','','','','','','','','','jue ','','','','',
        '','fen ','','','','he ','','','','','zhan ','','tai ','qian ','','',
        '','','','','Hang ','Hang ','','','','','','','','lao ','','',
        '','','','','','','jun ','','','','','','','','','',
        '','','','','','zai ','juan ','','','chu ','','','','','','',
        'kan ','','','','','Phong ','','','','','','','','','','',
        ],
    'x27c':[
        '','','','','','','','yu ','wu ','','Tian ','','','','','',
        '','','','','','','','Nanh ','','','','','','','','',
        '','','','','','','','Shuu ','','','han ','chu ','','tun ','','',
        '','','','','','','','','','na ','','','','','','ai ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','mai ','','','','lun ','jue ,jun','','',
        '','','','','','','','','','','','','','','','',
        '','','','huai ','','','','','','','','','','','','',
        '','','','','','ceng ','','hu ','','','','ju ','sha ','meng ','','',
        '','','','','','','','wei ','','','','','','','','',
        '','','zhe ','','','hu ','','','','','','Cop ','','','','',
        '','','','','','qu ','','','','','','','Beo ','','','',
        '','','fu ','','','','','Cop ','','','','','','','wu ','pei ',
        '','','','','','','','','Hum ','','','sha ','','zhao ','wei ','',
        '','','','','','','','','','tuan ','','','mei ','','','',
        '','','','','','','','','gu ','shao ','','','','','','',
        ],
    'x27d':[
        '','','peng ','','','','','','','','huan ','Beo ','fu ','','biao ','',
        '','','','','','biao ','','','','','guai ','','','','','',
        '','','','','','pei ','','','','','Suo ','','','','','Me ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','Qua ',
        'pai ','','','','','','','','ai ','','','','','','','',
        '','','','She ','','','','','','','','','','','','',
        '','','','','Danh ','','','','','','yun ','','','xu ','','',
        '','','','','cheng ','','','','','','','','','','','',
        'yu ','','','','','','','','','','','','','','','',
        '','','','','','cha ','Faan ','ze ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'fen ','xie ','','','','','','','','','','','','Xoe ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','shan ','','Mua ','','','','','','ju ','',
        ],
    'x27e':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','Zhuan ','xue ','','','','','','','','',
        '','','','','','','lan ','ju ','','xun ','zhan ','gun ','','','','',
        '','','','','','','','','','','','Bui ','','','','chai ',
        '','','','','','','','','reng ','','','Vay ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Son ','','','xu ','','',
        '','Tham ','hu ','gan ','','','','','','','','','','','hu ','',
        'Tham ','Tham ','','','','','','','','','','','','','','',
        'jue ','','zu ','','','','','','','','','','jiao ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','chu ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','xian ','','','','','ju ','','Mut6','','','','','','',
        '','','','','','','','','','','','','','','','',
        'hu ,zao','qiu ','','fu ','lang ','sha ','','','','','','','','','','',
        ],
    'x27f':[
        '','','','','','','','','','','','','','Lanh ','','',
        '','xu ','','','leng ','','','fu ','','','','','cu ','','','',
        '','','','','dao ','','','','jie ,jue','','','yu ','','','Tang ','shu ,yu',
        '','','','','','','','','','','','','','','','',
        '','','','','jie ','','','Day ','Day ','','','','','','','',
        '','','Cau ','','','','','','','','','','','','','jie ',
        '','','','','','lu ','','chu ','','','','lian ','','','','',
        '','','','','','','e ','su ','Jue ','','','ju ','','','','',
        '','','','','','','xuan ','','','','','','Tron ','','','',
        'jiao ','','','','','','','','','','yu ','','','xun ','','',
        'xun ','','','ju ','','du ','','','','xun ,xuan','','','','','','jie ',
        '','qu ','','','','jue ','','','','','','jiu ','','','','Treo ',
        '','','','','','','','','','ku ,wu','','ku ','zha ','','','ba ',
        'Chen ','Nhac ','Dam6','hu ','nu ','e ','','','','','','','','','','',
        '','','','','','bie ','','','','ge ','','Dau ','','','','',
        '','','','','','','','yu ','','Mau ','Xoat ','ju ','','','','',
        ],
    'x280':[
        '','','','','','','','','Buoc ','','','','','Dung ','Lop ','',
        'Rong ','','','','','','hai ','','','','','cun ','','','','',
        '','','','Kei ','Choi ','','','','','','','','zai ','','','',
        'Bang ','','','','xun ','','','','','','','','','','','',
        '','xuan ','xie ','','han ','','','tun ','Gaang ','','cen ','','','Ren ','Choanh ','',
        '','','','','','','','','','','','','','Buot ','','',
        '','Noi ','','','','','','Noi ','Cuong ','','Dau ','','','','','',
        'Xui ','','','','','','','','','','','','Bon ','de ','','',
        '','','','peng ','','','','','','','','','','','','',
        'Leoi ','','','','Doc ','','','Co ','','','','','','','tan ','',
        '','','','wu ','','','chuan ','','','','','','','du ','','',
        '','hun ','','','','','','','','','','','','Dam6','Naam ','',
        '','','','','','','','','','','','','Giay ','Tot ','','Xam ',
        'Giay ','','','','','Soc ','kua ','teng ','','','ta ','sa ','','','Pun ','Pun ',
        '','','','sao ','','','','','','Sin ','','','','zu ','','',
        '','','jie ','neng ','','','','Chuc ','','','','','To ','Nhuc ','Xung ','',
        ],
    'x281':[
        '','','','','','','','','','','Te ','','','','','',
        '','','','','shuan ','zu ','','','','','','','','','','',
        'Tat ','','','','','','','','','','','','','','','yu ',
        '','','','','Sup ','','','','','','Chui ','','','','Ghe ','Giong ',
        '','Sup ','Mop ','','','','','','','Lung ','','xiao ','','Ren ','','Laam ',
        '','','shu ,chu','','','','','','','','','','','Jaang ','Nhap ','',
        '','','','','','Bay ','','','','','','','','','','',
        '','','','','','','','Doi ','','','','','','','Sum ','',
        '','','Khum ','','zhu ','','','cha ','juan ','','','','','','zei ','',
        '','','','','','','','','','','','','','Cui ','','',
        'Quay ','Dep ','','','','Tuon ','','','','','Jaang ','','','','','Buk6',
        'ta ,da','','','','','','','','','','','','','','','',
        '','kuang ','','','','bao ','lai ','','','Leo ','','','','','','',
        '','','','','','','lu ','','','','','','','','','',
        '','','','','','','chan ','','','zhan ','','','','','','',
        '','','','','','Nhao ','Khuy ','','','','','','','','','',
        ],
    'x282':[
        '','','','','','','','Laam ','die ','','','','','','','',
        '','','','leng ','','','','','','','Pei ','','','','','',
        '','','','','','','','','','','','zhu ','','','','',
        '','','','','','','','','','','ye ','','','','','',
        '','huang ','','','','','','','','Pei ','','','','','','',
        '','','','','','','Nei ','','','','','','','','Lung ','',
        'Ban ','','','','','','','','','','','','','mei ','','',
        '','tang ','','','','','','','','','','','Wu ','xiang ','','',
        '','','','','','','','','','','','','Lan ','','','',
        '','','','','','','','','','','','Laak ','','','','',
        '','','','','','','','','','','','','','','','',
        '','yu ','','','','','','','','','dai ','','xuan ','','','jue ',
        '','','','','','','','','du ','','','','','Wan ','','',
        '','','','','','','','','zha ','','','pao ','','','bu ','he ',
        '','','Lip ','','So ','','','ju ','hun ','','','','','','','Zhuai ',
        '','','','','','','','','','','','','','','','',
        ],
    'x283':[
        '','','','','zang ','','','','','','','','','','xu ','',
        '','','','','','','','','jun ','','','','','','','',
        'lu ','','','','','fu ','','','','Tang ','','','chao ','ta ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Co ','','','he ','','','','','','','mu ','',
        '','','xian ,jian','','','','','','','','','du ','','','','',
        '','','','','','','Sau ','','','peng ','','','','','','ju ',
        '','','','Yao ','','','','','','','','','','','','',
        '','','','','','','So ','','','','','','','','','',
        '','','','','yang ','','','','','','','','','','','Truoc ',
        'Truoc ','','','','','','','peng ','','','','jian ','jiao ','','','',
        '','','','peng ','Dang ','','qu ','','mu ','','','','','','fen ','',
        '','','','','','','','','','shuan ','jian ','','','','','',
        '','','','','lu ,du','','','','','','ge ','','','','','',
        '','','','','','xian ','','So ','','','','','','','','',
        '','','','xie ','ge ','','','','','jue ','','','','','','',
        ],
    'x284':[
        '','die ','','zhe ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','ku ','','qu ','','ge ','ban ','','','','','','','','Cay ','',
        '','ban ','','','','','','','','','','','','','ban ,bian','',
        '','','','','','','','','','','','','chen ','','','',
        '','','Tu ','','','','','','','','','','Xuong ','','','',
        '','','','','','wu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','pan ','','','','','','','qiu ','','','','','',
        '','','','','','','','','','','','','bie ','','kan ','',
        '','','','','','','','','nai ','','','','','','','',
        '','','','','','','','','','','Quanh ','','','','','',
        '','','','','','','','','','','die ','','','','','',
        '','','','','','','','','','','','','','','dai ','',
        '','Lung ','','','','','','','','','','','','','','',
        'jie ','','','','ya ','','','','','','','','','','','pei ',
        ],
    'x285':[
        '','','','','','','','','Choi ','','Suot ','','Co ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','shu ','','','','','','','','','ta ',
        '','','','','','','','','','','','','','','','Chuc ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'ze ','','chu ','','','','qiu ','','','','','','','','','',
        '','','','','','','','','','','','','','jie ','','',
        '','','','','','Sang ','','','','','','','yang ','','','jiu ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Mau ','','','','','','','','',
        '','xian ','','','','','xiang ','sha ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','dao ','','','','','','','','','Nhanh ','yu ,ju','','',
        '','chao ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','da ','',
        ],
    'x286':[
        '','','jiu ','','','','','','','sha ','','','','','','',
        '','','','','','','','','','xian ','','','','','xian ','',
        '','','','','','','','','','','','','','','jiu ','',
        '','Nhanh ','','','kao ','','','','','','','','','','','',
        '','','','','','','','','','','','','','Keo ','ta ','zan ',
        '','','','','zhu ','','Suot ','','','','','','','Lui ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','xiang ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','bian ','','','','','','','','','','',
        '','','','','','','','qie ','','','','','','','hao ','',
        '','','cun ','','ru ','zai ','','','','','','','','','','',
        '','','','','','','','','','','','','','shao ','han ','',
        'jun ','','bu ','','','','kuai ','','','','','','xiang ','','','',
        '','yun ','','','','pu ','','','','','','','pei ','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x287':[
        '','','','','','','','','','','','','huan ','qiao ','','',
        '','','','','','','yu ','','mei ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','he ','','','he ','','','','','','','','','','chuang ','xu ',
        '','','','','','','','','','','','zhai ','','','','',
        '','guan ','','','','','','','','','','tu ','shun ','','hu ','',
        '','','','','','','dang ','','','','','','','feng ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'cheng ','','','yu ','','zhu ,chu','','qun ','','qu ','','ge ','','','','',
        '','','','','','','','','gai ','','','meng ','','','','',
        '','','','qu ','','','','','','','','','wan ','lei ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','dai ','','','','','','','','','','','qiu ','','',
        ],
    'x288':[
        '','','','','','','','','','Tam ','','','','','','',
        '','','Faan ','','','','bao ','','','','','','','','','',
        '','','','','','wei ','','','','','','','hao ','','','',
        '','','Giam ','Gay ','Sua ','Xoang ','','','','','','','','','','',
        '','','','jiao ','','','','','','Dam ','','','nei ','','yan ','',
        '','','','','','','','zha ','','','','','','','','',
        '','','','yan ','','','','','Gay ','','','hun ','','mu ','','',
        '','','','','','','','','','','','','Giam ','','','',
        '','','','','','','','liu ','han ','','meng ','hu ','','','','',
        '','','','','','','','','','','','','','','','Cay ',
        'meng ','','mu ','','hu ','Mi ','shai ,zha','','','','chao ','','','','','nian ',
        '','','','','','','','','','','','','','','','',
        '','','','','','chuai ','','','','','','','','','','',
        '','','','','','','','hu ','meng ','pao ','','','','','','',
        '','','','','Giam ','Dau ','Zeoi6','','lan ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x289':[
        '','','','','','','','','','','','','','','','',
        '','juan ','','','','','','','','','','','','','','',
        '','guang ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','jie ','','','','','','','','','','','','','',
        '','','','','','','','','','','','hu ','','','','',
        '','','','cen ','','','','','','','','','','','','',
        '','','','','','','dai ','','','','','','','','','',
        'Keo ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','','','Nen ','','','','','','Lao ','','',
        'liu ','','','','','','','','','','','','','','','',
        '','','','','','','Bua ','','','','','','','','','',
        '','xiang ','','','','bian ','','wu ','','','','','Bong ','','','',
        'Gang ','','','Xot ','','','','','','','sao ','','','','','',
        'zu ','','','','','','','','','','','','','','','',
        ],
    'x28a':[
        '','','','','','Hoat ','','','','','','','','','','',
        '','','','','','','','quan ','','','chao ','he ','','','','',
        'Cuoc ','wu ','','','Khep ','','Mai ','Thep ','','','','','','','','',
        'ruan ','','','zu ','','','yu ','tu ','meng ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','mao ','','','yu ','','','',
        'zu ','','','','','','','','','','','','','xia ','','',
        '','','','','','jian ','','','','','','','','','yu ','',
        '','','','','','liu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ruan ','','','yan ','','','','','','','','','',
        '','','','','Bam ','Lon ','','','Choc ','','Sat ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','Han ','','','','','',
        '','','','','','Cuoc ','','','','','','','','','','',
        ],
    'x28b':[
        '','','','','','','','','','Dui ','','','','','','',
        'jue ','','','','ruan ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','zhu ','','','','','','','Baang ','Bay ','','Choang ',
        '','','Choang ','die ','','','','','','','','','','','','',
        '','Thau ','','','','','','','','','','','','','','',
        '','','','','','','','','','','Com ','','','','','',
        '','','','','','','','Bung ','Hom ','Cun ','','','','','','',
        'Nhon ','Thoi ','','','yu ','','','','Ban ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','cai ','','','','','','','','','','','jiang ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Dui ','','','','','','','',
        ],
    'x28c':[
        '','','qian ','','','','','','','','','','','','','ta ',
        '','diao ','','','','','','','','','','','jue ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','Nen ','','','','yu ','','Ben ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','duan ','','','','','',
        '','','','','','','dao ','','','','','','','','','',
        '','','','','','','','','','','','','cen ','Dai ','Dai ','',
        '','','','','jun ','','','','zhu ','','an ','','','','','',
        '','','qiu ','','','','','','','','','','','','','',
        '','','','','','','','','','','','feng ','wu ','jiao ','','',
        'peng ','','','','','','','','','','','','','','','',
        'niao ','','chan ','','','','nang ','','','','Gau ','','','Cat6','','',
        '','','Mon ','','men ','','','','tun ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','die ','','','','','',
        ],
    'x28d':[
        '','','','','','','','','','','','','','','xu ','',
        '','Kuang ','','wei ','','','','die ','','','','','','','','',
        '','','he ','yan ','','','Cua ','','','tu ','','','hu ','','','',
        'chu ','','','','','','','','','','men ','','','','','',
        '','','','','','','','','','','zhe ','','','','','',
        '','','','','','','','','','','xie ','','','ta ','','fu ',
        '','','','Cua ','','','yu ','','','','xie ','','xian ','jian ','xu ','',
        '','','','','','','','','','','','','','','','',
        '','yan ','ai ','','','','','','','','jun ','','','','','',
        '','','','','','','','lang ','','Lan ','','','','shu ','','',
        '','','yu ','','','','','','','','','','hua ','wen ','','e ',
        '','','','','','','','','','Gwaan ','','','','','','',
        '','niu ','','','xiang ','','sa ','','','','','','','','run ','',
        '','','','jian ','xu ','','','','','shu ','','','','','','',
        '','','','','','xie ','','','','','','','','','','Cua ',
        '','','','','','','Cua ','','','','','','','','dang ','',
        ],
    'x28e':[
        '','','','','','','','','','','','','','Cup ','','',
        'reng ','','','','','','','han ','','','Ji ','gai ','','','','',
        '','','','','','','','','','','','','Zhen ','','','',
        'ju ','','','','','','','','','','','','','','','',
        '','','','','','','xuan ','','','','','','','','','',
        '','','','','','','','','xu ','','cheng ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','zhao ','','','','','','','',
        '','','','','','fu ','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','duan ','','','','qiu ','','','','','','','xun ','',
        '','','','','','','','','','Jiao ','','','','','','',
        '','','yan ','','','','','','','','','','','xu ','','',
        '','','','','','','','die ','','','','','','','','',
        '','','','','','','','liu ','','','','Luong ','','','','',
        '','','Xia ','','','','Geki ','','','','','','','','','',
        ],
    'x28f':[
        '','','','','','','','','zhan ','cuan ','wu ','','','','jue ','',
        '','','','','xun ','','','','','','Be ','','','','','',
        '','','','','chen ','','','','','','','qu ','','','zhan ','',
        '','jue ','','','','','','','','','','','','qu ','','meng ',
        '','','pu ','','','','','','','','','','','du ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','xia ',
        '','','','','','','','','','','','','','','','dai ',
        '','','','','','','','','','','','','yu ','','','',
        '','','','','fang ','','','','','','','','','','','',
        '','','','','die ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','tiao ','',
        '','','','','','','','','','','','','','','','wu ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','wei ','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x290':[
        '','','','','','','','','','','','run ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','wei ','','','','','','','','','','','','',
        '','','','Song ','','','','','','','','','','','','',
        '','','','','','','','','','','','','wei ','','','',
        '','','','','','','','','','','','','','','cai ','',
        '','','','','','','Loi ','','','','','','','','','',
        '','','','','','','Ngat ','','','','','','','','','',
        'Con ','Ngut ','','shai ','tun ','','','','','','','','','','fu ','Che ',
        'Ram ','Bung ','','','fu ','Phat ','ze ','pu ','','','','','','','pao ','Mu ',
        '','','','','hua ','','','','','','','','','','','',
        '','','','Rei ','','dian ','Set ','','','','','','','','','',
        'yan ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','xuan ','','','','','',
        'dai ','','','','','','','','','','','','','','','',
        '','','','','ba ','','','dai ','','','','','','','','',
        ],
    'x291':[
        '','','','','','lu ','','','','','','ru ','','','Mua ','Bung ',
        '','','','','','dan ','meng ','xia ','','','','','','','','',
        '','','','','','','peng ','','Guot ','','','','','','','wu ',
        'Set ','','May ','','','Nap ','Xoi ','piao ','','','','','','','ze ','',
        '','','','','lu ','','','bu ','','','','','','man ','','',
        '','','','','','','','','','','','Bung ','','','','',
        'nan ','','he ','','','','','','','','','','','','cen ','',
        '','','','','','','','','','May ','Rau ','Zyu ','','','dan ','fu ',
        '','','','','','sa ','','','','','','Rao ','','Rao ','liu ','',
        'Sam ','','','','dian ','','','','','','','','','','','',
        'Mong ','Rao ','','','','','','','','','','','Mong ','','','',
        '','','','','','','','Sam ','','','','','','','Khuya ','',
        '','','','','','Mu ','Sam ','hun ','','','','','','Loa ','','',
        'qu ','','','','','','','','','','','','','','','',
        '','','Xanh ','','','','','','','','','','','','','fei ',
        '','','','','','','','','','','','','','fei ','','',
        ],
    'x292':[
        '','','Bay ','','','','','','pang ','dan ','','ai ','','','','',
        '','','','','','','','mai ','','','','','','','dao ','',
        '','','','','chu ','','','','','','','','wan ','','diao ','',
        '','','suan ','','','','','','','mian ','','','','','','',
        'lan ','','','','','','','','','','','','','','','',
        'gan ','','','','jian ','','','','','','','','hang ','','','',
        '','','','','','xuan ','','','','','','','','','','',
        'ang ','','','','','fen ','','','ju ','','','','','fu ','','qu ',
        '','','','ma ','','bao ','','yu ','','','','','','mai ','','',
        '','','','','jiao ','','','','','','','','','','','',
        '','','','','','','','','','','','','bu ','','','',
        '','','','','','zhe ','bu ','','','','jue ','xun ','','Hia ','','',
        '','','bai ','','','ta ','','','nao ','yu ','','','','','','',
        '','','','','','','','','Xie ','diao ','','','','','die ','fu ,fu',
        '','','xuan ,yun','','yu ','','','Xie ','fu ','','','xuan ','','','','',
        '','','','','','','','la ','','','gao ','','','e ','','mei ',
        ],
    'x293':[
        '','','','','','','','ta ','','ta ','','','','','','',
        'ta ','','','','','','','','ta ','','','','','','','',
        '','','','','','','','','','','ze ','lu ','','','xu ','',
        '','','xu ','','','','','','','','','','','','','',
        '','','bao ','','','','','','','','','sheng ','','','','fu ',
        '','','','','','','','Bang ','','','','','','','','',
        '','','Roi ','Dep ','','','','','','','','','','','','',
        '','','','xu ','','','','jue ','','','','','lu ','','','',
        '','','','','','','','','','','','','','','ge ','',
        '','','','','','','','','','','','fu ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','wei ','','','','yu ','','bai ','','ta ','','',
        '','','','','','yun ','yun ','duan ','','wei ','','','','','','',
        '','','','','','','hun ','','','','','','','','bai ','yu ',
        '','','','','','','','','','','','','','','','',
        '','','','','yu ','','','','','juan ','jue ','','','','','',
        ],
    'x294':[
        '','','','','','sa ','','','','','','','','','','',
        '','','','','','','','','','','fu ','peng ','','','','',
        '','zu ','','','','','','','','','','su ','','','','',
        '','','','','','','zhe ','','','','','','su ','','','',
        '','e ','','','','','','','guang ','','','','','ao ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','men ','','','','','','','','','la ','',
        '','','','','yao ','','','','','xuan ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','yan ','','','','','','','','','',
        '','','','','','','','','','','','','','','qiu ','',
        '','','','','','','','','','','fu ','','','','wu ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','fu ','','','','','Ngup ','Mang ','bie ','','',
        '','','','','an ','Ngok6','wu ','','','','lu ','','','','','',
        '','','','','','','','','','','','jue ','','','','',
        ],
    'x295':[
        'wai ','','dun ','','jie ','','','','','','zhuan ','hang ','','','','',
        '','','','','','qiu ','','Lei ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','ze ','xu ','','','','','','','','xu ','','','',
        'ao ','','','','','','','','','','','','','','','',
        'liao ','','','','','wai ','','','','','','','','','','',
        'han ','','','','dan ','','','','','','','','','Gai ','','',
        '','','','','','','','','','','','','','','yuan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','peng ','','','','',
        '','','','','tun ','','','','','','','','fu ','','','',
        '','','','','','','','','','','han ','','fu ','','','',
        '','','','To ','','','','','','sa ','','','','','','',
        'hua ','','','','','qiu ','','','','','','','','','sa ','',
        '','','','','han ','','','','','liu ','','','','','','',
        '','','','','Bung6','','','','','','','','','wu ','','',
        ],
    'x296':[
        'zhao ','','','','May ','','','','','','la ','','','yuan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','To ','yu ','','','','','','','','','','','',
        'su ','shuai ','','yu ','','','','','','su ','','yu ','','','','',
        '','','','','liu ','','cheng ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','niu ','','','','Bay ','','','','',
        '','','','','yu ','','','','','','','','','','','',
        '','','','','Nhu ','','niu ','','','','','na ','','','','',
        '','','','','','','','Qua ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','No ','Qua ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','zai ','','','mao ','','yu ','','','yu ','','',
        '','','','','','','','','','','ju ','','lu ','','','',
        ],
    'x297':[
        '','','','ju ','','','','Juan ','','','','','','','','',
        '','','','','','','','','','','','','','','','ang ',
        'Mam ','','','','','','','','','','','','','','','',
        '','','fu ','','','','','','','','','','','yan ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','wu ','','yu ','','','','','','','','',
        'Qiu ','','','','','su ','','','','','','','','','','',
        '','','','','','','','','','','','Chan ','','jiang ','','',
        '','','','','','','','','zhu ','','','','','','','',
        '','','','','','','','','','','','','','','hai ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','han ',
        '','yuan ,xuan','Qua ','','','','','ao ','','','','shan ','','','','',
        '','yu ','','','Caat ','','','','','','','','','','meng ','',
        '','','','','','','jie ','','','','','','','','huai ','',
        '','','','yu ','','','chan ,jie','','','','','Nang ','','','','',
        ],
    'x298':[
        '','','','','','','','','','','','','','','','',
        '','Ding ','','','Mao ','','','','','','','','','','','',
        'Cui ','','','','','','','Guc ','','','','','','','','wei ',
        '','Chui ','','Chui ','Cui ','Choi ','','fu ','','','','','','','','',
        '','','','yu ','','','','','','','','Thom ','','','','',
        '','','','','hai ','peng ','','','','','','','','','','bie ',
        '','','','','','','','','','','','fan ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','wan ','','','','','','','','wen ','','','',
        'zhe ','','','','ban ','bu ','','','','','','ge ','','','liu ','',
        '','','','','','','Giong ','','','','hu ','','','','','',
        'fu ','','Sai ','qu ','','','yu ','','','jiu ','','shu ','','','','fu ',
        '','','','','','','','','','','xu ','','','','','',
        '','Ngon ','','','','','','','','','','','fu ','bu ','','',
        '','','','','','','','','','zhe ','','','','','tu ','',
        '','lu ','','','','','','','fu ','','','','','','','',
        ],
    'x299':[
        '','','','','','','','','','','xian ,jian','kun ','','','','',
        '','','','','','','','','','cheng ','','','','','tan ','',
        'xie ','','','duan ','','','','','','e ','','','','','','',
        '','','','','','','','','','','yu ','','','','','',
        '','','','','','','','zhan ','','','','Au6','qia ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','yu ','','',
        '','','','','','','','','','','','','','tu ','','zu ',
        '','','','','','','','','','bie ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'bang ','yu ','Jyu ','','','','','','','','','','','','','',
        '','','','','','','','','','xian ','meng ','','','','','',
        '','','','','','','','cai ','du ','','','','','','','jue ',
        '','','ju ','','','','','','qu ','','','','','','','',
        '','jue ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x29a':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','yu ','','yu ','','','ba ','','','',
        'ya ','','','','','','','','','fan ','','','','Que ','','',
        '','','ma ','','','','','','','','','','Kheo ','','','',
        '','','','','','','','Song ','','','','','','Peng ','','',
        '','','','','','','Song ','','','','','','','','','',
        'zu ','leng ','','','','','','dan ','','','Xuong ','Xuong ','','','du ','bian ',
        '','qia ','he ','','','','yan ','','','','','teng ','','','','Hom ',
        '','','','hai ','','','','','','xu ','','','','','','',
        '','','','','','','','Jue ','','','','pu ','','','Sun ','',
        '','','','','','','','','','','','','','','','',
        '','','','','yan ','So ','','','','','','','','Cut ','','',
        'kai ','mao ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','sao ','','','','','','','','','',
        '','','','','ju ','','','','','cheng ','','','','','','',
        ],
    'x29b':[
        '','','','','','','','','','','','','','','Zam ','',
        '','Chom ','','','','','','','','','','','ju ','','','zha ',
        '','','','','','','','','','','','','','','','',
        '','dao ','','','','','','','','','','','','','','',
        '','','','','','','','','','','ju ','','','','','',
        '','','','','','','','','','','','','Xui ','','','dao ',
        '','','an ','','','han ','','','','','','','','','','',
        '','','','','','Quan ','Rau ','','','','fu ','','','','','',
        '','qia ','','','','na ','','','','','','','','','','',
        '','','','','Quan ','','','','','','','','','ya ','','',
        '','','','','','','','','','','','','','Ria ','','',
        '','','','','','','','','','','','','','','','',
        '','Rau ','','','zun ','','nao ','','','','','','','','cheng ','',
        '','','','','','','','','jiao ','','','yao ','','','can ','',
        '','','','','','','','','','','','','','Ban ','','Xoam ',
        '','pu ','zhuang ','','','','','','','','','','','la ','','',
        ],
    'x29c':[
        '','','','zhan ','','','','','Nheo ','','','','','bian ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','ju ','','','','jue ','','yu ','','','','','hu ',
        '','','','xie ','er ','','','','','','','','','','','',
        '','','','','','','','','','','er ,xian','','yu ','hu ','','',
        '','','','','','','','','','ku ','','','','','jiao ','',
        '','','','','','','','','ru ','','','','','','','',
        '','yu ','','','','','','','','','','','','','','',
        '','','','','','','','','','','hao ','','','niu ','','hua ',
        '','','','','','','','','','','','','','','','',
        'zhu ','Coi ','','','','Troi ','','','','','','','zhu ','','','',
        '','','zu ','','','','','','','','','','','','yu ','',
        '','','','','','','lai ','','','','Ranh ','','wu ','','fu ','zhuan ',
        '','','su ','','yao ','','','','','','','','','','','',
        '','','yan ','','','zhu ','','','','','','','','','','',
        '','','','Troi ','','ju ','','','','','','','','','','',
        ],
    'x29d':[
        '','','','','','','','shai ','','yun ','','','','','','',
        '','','jiang ','','','','','','ju ','','Troi ','','','teng ','wei ','',
        '','gu ','','','liao ','','','','','','','','','','','',
        '','','meng ','cha ','','','','','','qu ','','lei ','','','','',
        '','','','Troi ','','qu ','','','','','','Gyo ','','qiu ','','hua ',
        '','','','','','','','','','','du ','','','Chai ','','',
        '','','','','','','mu ','','','','','','hu ','','','',
        '','','','','','','','','','fu ','','','','Tom ','','',
        '','','zhu ','','zhu ','Ci ','','','','Pou ','','','','','','',
        '','','','','','','mu ','','','','','','','','','Buop ',
        '','meng ','','','','','guai ','jiu ','','mu ','','','Si ','wu ','','ru ',
        '','zha ','','','','','','','','','','','','','','',
        '','','xie ','','jiang ','','','Hung ','','','Thu ','','','','','',
        'ju ','','','','','Luon ','bu ','','','','','','','','','',
        '','','','','','','','','','','','','','jiang ','','',
        'xun ','','','','','','Mang ','','','','','qia ','','','','',
        ],
    'x29e':[
        '','','','tu ','hua ','','','','','','','','','','','',
        'ru ','','','','','','','','','','','','','','','',
        '','','','','','','','','Yi ','','','','','','Bong ','Chuoi ',
        'Go ','','','','','','','','Thia ','','','','','','ye ','',
        '','','','','hai ','','','','','','','','','','an ','ba ',
        '','han ','','','','','','','','','','','','','','nai ',
        '','','','','Thu ','','','','','Nau ','','Tep ','','Chay ','Mu ','Tuoi ',
        '','chu ','','','','','','','','','ge ','','han ','','na ','ge ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Bon ','','Trau ','','','','','Bong ','','Bon ','xie ','','','','Soc ',
        'yu ,wu','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Mam ','','Sop ','Dua ','','Tram ','','bu ','jian ','','wu ','Tram ','','zhuan ','','Vay ',
        '','','','','','','','','','','','','','','','',
        '','','','','','die ','','','','','Vay ','Leo ','','','','',
        ],
    'x29f':[
        'Vay ','','','','','','','','Ao ','','','','','','','',
        '','','','','','','','','','ge ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','xu ','','','Sau ','Lui ','','','','wei ','',
        '','','','','','','Ruoc ','','','','','','','','','',
        '','','','','Sau ','Luon ','','','','qu ','','','','','','',
        '','','','','','','','ba ','Nheo ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','han ,yan','','',
        '','bao ','','','','','','xun ','','','','','','','','',
        '','','','','','','jie ','','','','','hu ','','','','fu ',
        '','','mao ','','','','','','','','','','','','','',
        '','','','bao ','','','','','Mao ','','Khuou ','','','ju ','Caa ','qu ',
        '','','','','','qu ','','','Khuou ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a0':[
        '','','','','Chim ','','','','','','','','','','','',
        '','','Shi ','','','','','','jiang ','','','','','','','',
        'xun ','','','ju ','','','','','','','','','','','','',
        '','','','','','','','','','','fu ','','','','jie ','',
        'yu ','','','','Ket ','Sac ','Hau ','Song ','zhuang ','','','cheng ','','jie ','','chen ',
        '','','','','','','qu ','','','','','','','','','',
        'jue ','yan ','','','','ju ','','','','','','','','','xiu ','',
        '','','','','Coc ','Coc ','','','','','','','','su ','','',
        '','','','','','','','','','yu ','','fu ','ta ','','','',
        '','','hu ','','','','','','','','','','mei ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Cun ','','yu ','','','','','','','','pen ','fu ','',
        '','','liu ','','','','','','jie ','','','','','yu ','yu ','Mei ',
        '','mao ','','fu ','','','','','','','','jian ','','','','',
        '','','','','','','','','','','','','','','','',
        '','Hau ','','','Ga ','','','','','','','','','','','Ge ',
        ],
    'x2a1':[
        '','','xia ','','','Set ','','','','','qu ','','','','ge ','',
        '','su ','','','','','','','','','','','','','','',
        '','','','','','Cut ','','','','','','','','','hu ,gu','',
        '','','','mai ','','','','','','','','','','','','',
        '','','','','su ','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Cuoc ','Choi ','Ri ','Sam ','','','','Tu ','','',
        '','','','','','','','','jie ','','','','','','','',
        '','','qu ','','','','','','','','','xie ','','','','',
        '','','','','','','','','','','','','','','','',
        'fu ','','','','','Khuou ','Tu ','','','','','','','','','',
        'ya ','liu ','','','','','can ','64272.110,chu ','','','','','','','','jian ',
        '','','','','','','chu ,du','','ai ','','','Cui ','','','Quam ','',
        '','xun ','','','','','','','','','','','','yu ','','',
        '','','','','','','','','','Ngan ','','Cui ','','cai ','','liu ',
        '','','jie ','','','','','','','la ','','','','','','',
        ],
    'x2a2':[
        '','','','','','','','','lai ','','he ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','jue ','','','','guan ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','Muoi ','','tan ','','En ','','','','','','kan ',
        '','bian ','','','Muoi ','','','','','','','','','','','gan ',
        '','','','','','Mam ','','gan ,tan','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','xiao ','','zhu ','','yu ','','','','',
        '','jian ','','','','','','','','yu ','','','','zu ','','',
        'nuan ','','','','','','','','','','','','','su ','','',
        '','pu ','','','','','','','','','','','','','yu ','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a3':[
        '','','','','','na ','qu ','','','','','tun ','','','','',
        '','','','ku ','su ','','','','','','','','','','','ze ',
        '','','','ge ','','','','jie ','','','tiao ','','','','','',
        '','','','','','','shu ','','','','','','','hun ','','nie ',
        '','jun ','hu ','','lu ','','','','chao ','','','','','','','fu ',
        '','','','','','','','','','','','','','yun ','','',
        '','','','','','','','xuan ','','','','','','','','',
        '','','','','','','shan ','','Qu ','du ','','sao ','','','','kuang ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','liu ','','','','','','','','','','mei ','','',
        '','','','','tun ','kang ','tun ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','heng ','','','','','','Huang ','','','','','','',
        '','','','','','','','','','','kuang ','piao ','','','','',
        '','','','hu ','','','bao ','','','','','hu ','','','','',
        ],
    'x2a4':[
        'Naa ','','','','','','bie ','','','','','','','','','',
        '','','','','','','','','','','','','','dai ,tai','du ','',
        '','','','','','tai ','','shu ','','','','','','','su ','',
        '','','','','','','','','','','','','','','','',
        '','','cha ','','lu ','','yu ','','yan ','','qiao ','','yu ','','','tu ',
        '','Ngam ','tun ','','','','','','','','','','','yu ','','',
        '','','','','','','','die ','cha ','dian ','','','','','','',
        '','','','','','','','wai ','','','','','','zhai ','','',
        '','','','','','','','','','','','','','','','lu ',
        '','','','','','','','Tham ','','','','','ma ','','','',
        '','','','','','','','','','','mai ','','Nung ','','','',
        '','','','','','','','','','','','','','','dan ','teng ',
        '','','','','','','','','','','yu ','','','','','',
        '','','','','','','','','','','','','','','','',
        '','cu ','','','','','','','','','','Sam ','','','','',
        'cu ','','','','','','','','','','','','','','','',
        ],
    'x2a5':[
        '','','Ding ','','','','','','','','','','','peng ','','',
        '','','','','','','','','','','','','','','','',
        'Trong ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','hu ','','','','','','',
        '','','','','','','','','','','','','','cu ','jun ','',
        '','','','','','','','','er ','','','','','ai ','hu ','',
        '','hu ','','','','','','','','','','','','','','',
        '','','','','jiao ','','','','pu ','','','jie ','lu ','','','',
        'yao ,ya','','','','','','','','','Hou ','','qiu ','jue ','','','',
        '','','','','','','','','','xu ','','','','Ngui ','','',
        '','','','','','','su ','liao ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','pa ','','','','','','','','','na ','','',
        '','','','','','','zhan ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a6':[
        '','Kap6','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','zu ','','','zhan ','','','','','',
        '','','Ji ','','','Rang ','','','','he ','qia ','','','','','',
        '','','','','','','','','hu ','','yan ','','','','','',
        '','','','','','','','','','','','Nak ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','jue ','','','','','','','','','','',
        '','','','','','','','','','','Trong ','','','','','',
        '','','','','','zhe ','','','','Gwi ','','','gan ','','','cu ',
        '','','','','','','','','','zhu ','','','','','','',
        'xiao ','','','','','Rua ','','Rua ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a7':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2a8':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Bai ','','','','','','','Zhan ',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','Luan ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2aa':[
        '','','','','','','','','','','Song ','','','','','',
        '','','','','','','','Jue ','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','Yong ','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2ae':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Nu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Cong ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2af':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','Xian ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b0':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','Li ','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Fei ','','','','','','','',
        '','','','','','','','','','Su ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','Kou ','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b1':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Chi ','','','','','','','',
        '','','','','','','','','Xun ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b2':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Qia ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Gong ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b3':[
        'Ji ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Luo ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','Yi ','','','','','','',
        '','','Nao ','','','','','','','','','','','','','',
        'Xi ','','Xiao ','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Jiao ','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b4':[
        '','','','','Yue ','','Kuai ','','','Ling ','','','','','','',
        'Ni ','','','Bu ','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','Han ','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','Fu ','','Cong ','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b5':[
        '','','','','','','','','','','','','','','Jue ','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Duo ','','','','','','','Su ','','','','','','','Huang ','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2b6':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','Han ','Ai ','','','','Ti ','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','Xu ','Gong ','','','','','','',
        '','','Ping ','','Hui ','Shi ','','','','Pu ','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','Zhi ','','','Jue ','',
        '','','Ning ','','','','','','','','','','','','','',
        '','','','','','','Chi ','','Ti ','','','','','','','',
        ],
    'x2f8':[
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        'Gai ','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ],
    'x2f9':[
        '','','','','','','','Baan6','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        ]
}
