![React email cover](https://pbs.twimg.com/profile_banners/1733139456645795840/1705969228/1500x500)

<div align="center"><strong>Onedoc</strong></div>
<div align="center">Onedocs makes it easy for developers to design beautiful PDFs. With our API, we make document generation simpler, faster, better.</div>
<br />
<div align="center">
<a href="https://www.onedoclabs.com/">Website</a> 
<span> · </span>
<a href="https://github.com/OnedocLabs/react-print">GitHub</a> 
<span> · </span>
<a href="https://discord.com/invite/uRJE6e2rgr">Discord</a>
<span> · </span>
<a href="https://docs.onedoclabs.com">Documentation</a>
</div>

# Onedoc
Stop spending hours making ugly documents, and start creating a dynamic experience now!

Onedoc makes it easy for developers to generate beautiful PDFs. It is a comprehensive solution with:

* An [open-source library](https://github.com/OnedocLabs/react-print-pdf) to design your documents.
* A simple [API](https://docs.onedoclabs.com/api-reference/introduction) to generate your documents.
* A [cloud platform](https://app.onedoclabs.com/) to host and track your documents.


The first developer-oriented document platform. Generate, host and track documents with a single API.



https://github.com/OnedocLabs/onedoc/assets/33000377/5bbda4a8-150c-48ed-877b-b0a805fa647f



# Why do documents feel so outdated❓

Billions of PDFs are generated daily: invoices, contracts, receipts, tickets,… yet there are no toolkits to allow companies to easily build them. Developers need to get their hands dirty to produce basic documents - let alone beautiful ones. This makes PDFs hard to dynamize and maintain, leading to poor brand experience and flawed analytics.

# What does Onedoc bring to the table ✅ 
Onedoc bridges the gap between developers and documents. We make modern web technologies work for PDF generation: React, Tailwind, … In turn, developers can make highly dynamic documents and iterate quickly. **What used to take hours now takes seconds with our API.**

To make it even faster, we maintain an [open-source library](https://github.com/OnedocLabs/react-print-pdf) of beautiful components and templates and we offer a hosting and tracking service to better understand your documents.

# Our goal 🎯

Onedoc is dedicated to transforming document management. We aim to empower businesses and developers to create, manage, and utilize documents more effectively, driving productivity and innovation in today's fast-paced, digital-first world.

# What brought us here 🧐

We previously worked with giant firms, where documents were central to most workflows. They would get passed around, get into client’s hands, and everyone would complain about their layout and lack of proper information. While at a large mining company, clients would want to see shipping information and product details on their invoices. However, the development team wouldn’t be able to update these documents because the task was too complex and expensive.

# SDK 💻

- [Node.js SDK](https://www.npmjs.com/package/@onedoc/client)
- [Component library](https://www.npmjs.com/package/@onedoc/react-print)

# Our Team


- **[Auguste LEFEVRE](https://www.linkedin.com/in/augustelefevre/)**  
  *EPF Lausanne and ETH Zürich graduate in Computer Science, Auguste built extensive knowledge in machine intelligence and data analytics. Continuing his academic journey with a PhD in Quantitative Finance at the National University of Singapore, he left to co-found Onedoc with Pierre and Titouan with the idea to reshape the document management experience.*

- **[Titouan LAUNAY](https://www.linkedin.com/in/titouan-launay/)**  
  *INSA Lyon graduate in civil engineering and architecture, Titouan is a self-taught computer programmer, developing and selling software to businesses since the age of 12. Co-founded an IT consulting company while studying, providing companies with data management and cloud consulting services. He now puts his effort into improving document management around the world.*

- **[Pierre DORGE](https://www.linkedin.com/in/pierre-dorge-3372bb16a/)**  
  *EPF Lausanne and ETH Zürich graduate in Computer Science specializing in machine intelligence and information security. Pierre built extensive experience in software engineering and data management as the co-founder of an IT consulting company and now decided to focus on revolutionizing the document management experiences.*

# Contributing 🫂
There are many ways you can contribute to the sucees of Onedoc :

* **Onedoc:** Check out our [website](https://www.onedoclabs.com/) and sign-up to our app to [get started](https://app.onedoclabs.com/)
* **react-print-pdf:** Contribute to the [open-source library](https://github.com/OnedocLabs/react-print-pdf) and share components/templates with the community.
* **Join the community:** Follow us on [X](https://twitter.com/Onedoclabs), [Linkedin](https://www.linkedin.com/company/onedoclabs/), and engage with others on [Discord](https://discord.com/invite/uRJE6e2rgr)


![intro](https://github.com/OnedocLabs/onedoc/assets/33000377/ee77e121-e1df-4b43-8684-53a1bcc9fc8b)

