# coding: utf-8

"""
    Martlet Organization API

    Create/maintain organizations, access keys, addresses and permissions.   # noqa: E501

    OpenAPI spec version: 0.131.0
    Contact: apiteam@bmbix.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bmb_martlet_organization_client.api_client import ApiClient


class EncryptionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, resource_type, resource_id, **kwargs):  # noqa: E501
        """Rotate private key - create and store new key with life of 90 days.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(resource_type, resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: (required)
        :param str resource_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_with_http_info(resource_type, resource_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_with_http_info(resource_type, resource_id, **kwargs)  # noqa: E501
            return data

    def create_with_http_info(self, resource_type, resource_id, **kwargs):  # noqa: E501
        """Rotate private key - create and store new key with life of 90 days.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(resource_type, resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: (required)
        :param str resource_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_type', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_type' is set
        if ('resource_type' not in params or
                params['resource_type'] is None):
            raise ValueError("Missing the required parameter `resource_type` when calling `create`")  # noqa: E501
        # verify the required parameter 'resource_id' is set
        if ('resource_id' not in params or
                params['resource_id'] is None):
            raise ValueError("Missing the required parameter `resource_id` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_type' in params:
            path_params['resource_type'] = params['resource_type']  # noqa: E501
        if 'resource_id' in params:
            path_params['resource_id'] = params['resource_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/{resource_type}/{resource_id}/private-keys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_resource_public_key(self, resource_type, resource_id, **kwargs):  # noqa: E501
        """Get the public key for a resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resource_public_key(resource_type, resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: (required)
        :param str resource_id: (required)
        :return: PublicKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_resource_public_key_with_http_info(resource_type, resource_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_resource_public_key_with_http_info(resource_type, resource_id, **kwargs)  # noqa: E501
            return data

    def get_resource_public_key_with_http_info(self, resource_type, resource_id, **kwargs):  # noqa: E501
        """Get the public key for a resource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resource_public_key_with_http_info(resource_type, resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: (required)
        :param str resource_id: (required)
        :return: PublicKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_type', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_resource_public_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_type' is set
        if ('resource_type' not in params or
                params['resource_type'] is None):
            raise ValueError("Missing the required parameter `resource_type` when calling `get_resource_public_key`")  # noqa: E501
        # verify the required parameter 'resource_id' is set
        if ('resource_id' not in params or
                params['resource_id'] is None):
            raise ValueError("Missing the required parameter `resource_id` when calling `get_resource_public_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_type' in params:
            path_params['resource_type'] = params['resource_type']  # noqa: E501
        if 'resource_id' in params:
            path_params['resource_id'] = params['resource_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/{resource_type}/{resource_id}/public-key', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublicKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def index(self, resource_type, resource_id, **kwargs):  # noqa: E501
        """Get the private keys for a resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index(resource_type, resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: (required)
        :param str resource_id: (required)
        :return: PrivateKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.index_with_http_info(resource_type, resource_id, **kwargs)  # noqa: E501
        else:
            (data) = self.index_with_http_info(resource_type, resource_id, **kwargs)  # noqa: E501
            return data

    def index_with_http_info(self, resource_type, resource_id, **kwargs):  # noqa: E501
        """Get the private keys for a resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_with_http_info(resource_type, resource_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: (required)
        :param str resource_id: (required)
        :return: PrivateKeysResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_type', 'resource_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_type' is set
        if ('resource_type' not in params or
                params['resource_type'] is None):
            raise ValueError("Missing the required parameter `resource_type` when calling `index`")  # noqa: E501
        # verify the required parameter 'resource_id' is set
        if ('resource_id' not in params or
                params['resource_id'] is None):
            raise ValueError("Missing the required parameter `resource_id` when calling `index`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_type' in params:
            path_params['resource_type'] = params['resource_type']  # noqa: E501
        if 'resource_id' in params:
            path_params['resource_id'] = params['resource_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/{resource_type}/{resource_id}/private-keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateKeysResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, body, resource_type, resource_id, private_key_id, **kwargs):  # noqa: E501
        """Update a private key.  set_rescinded ============= {   \"op\": \"replace\",   \"path\": \"/rescinded\",   \"value\": true }   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(body, resource_type, resource_id, private_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericPatch body: Private Key Patch (required)
        :param str resource_type: (required)
        :param str resource_id: (required)
        :param str private_key_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_with_http_info(body, resource_type, resource_id, private_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_with_http_info(body, resource_type, resource_id, private_key_id, **kwargs)  # noqa: E501
            return data

    def update_with_http_info(self, body, resource_type, resource_id, private_key_id, **kwargs):  # noqa: E501
        """Update a private key.  set_rescinded ============= {   \"op\": \"replace\",   \"path\": \"/rescinded\",   \"value\": true }   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(body, resource_type, resource_id, private_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GenericPatch body: Private Key Patch (required)
        :param str resource_type: (required)
        :param str resource_id: (required)
        :param str private_key_id: (required)
        :return: PrivateKeyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'resource_type', 'resource_id', 'private_key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update`")  # noqa: E501
        # verify the required parameter 'resource_type' is set
        if ('resource_type' not in params or
                params['resource_type'] is None):
            raise ValueError("Missing the required parameter `resource_type` when calling `update`")  # noqa: E501
        # verify the required parameter 'resource_id' is set
        if ('resource_id' not in params or
                params['resource_id'] is None):
            raise ValueError("Missing the required parameter `resource_id` when calling `update`")  # noqa: E501
        # verify the required parameter 'private_key_id' is set
        if ('private_key_id' not in params or
                params['private_key_id'] is None):
            raise ValueError("Missing the required parameter `private_key_id` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_type' in params:
            path_params['resource_type'] = params['resource_type']  # noqa: E501
        if 'resource_id' in params:
            path_params['resource_id'] = params['resource_id']  # noqa: E501
        if 'private_key_id' in params:
            path_params['private_key_id'] = params['private_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['MartletOauth2']  # noqa: E501

        return self.api_client.call_api(
            '/{resource_type}/{resource_id}/private-keys/{private_key_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PrivateKeyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
