# generated by datamodel-codegen:
#   filename:  auth/emailVerificationToken.json
#   timestamp: 2025-06-18T15:57:29+00:00

from __future__ import annotations

from enum import Enum

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic


class TokenStatus(Enum):
    STATUS_PENDING = 'STATUS_PENDING'
    STATUS_CONFIRMED = 'STATUS_CONFIRMED'


class TokenType(Enum):
    REFRESH_TOKEN = 'REFRESH_TOKEN'
    EMAIL_VERIFICATION = 'EMAIL_VERIFICATION'
    PASSWORD_RESET = 'PASSWORD_RESET'
    PERSONAL_ACCESS_TOKEN = 'PERSONAL_ACCESS_TOKEN'


class EmailVerificationToken(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    token: Annotated[basic.Uuid, Field(description='Unique Refresh Token for user')]
    userId: Annotated[
        basic.Uuid, Field(description=' User this email Verification token is given to')
    ]
    tokenType: Annotated[TokenType, Field(description='Token Type')]
    tokenStatus: Annotated[TokenStatus, Field(description='Refresh Count')]
    expiryDate: Annotated[
        basic.Timestamp, Field(description='Expiry Date-Time of the token')
    ]
