# generated by datamodel-codegen:
#   filename:  metadataIngestion/storageServiceMetadataPipeline.json
#   timestamp: 2025-06-18T15:57:29+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern
from .storage import (
    storageMetadataADLSConfig,
    storageMetadataGCSConfig,
    storageMetadataHttpConfig,
    storageMetadataLocalConfig,
    storageMetadataS3Config,
)


class StorageMetadataConfigType(Enum):
    StorageMetadata = 'StorageMetadata'


class NoMetadataConfigurationSource(BaseModel):
    pass
    model_config = ConfigDict(
        extra='forbid',
    )


class StorageServiceMetadataPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[StorageMetadataConfigType],
        Field(StorageMetadataConfigType.StorageMetadata, description='Pipeline type'),
    ]
    containerFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None, description='Regex to only fetch containers that matches the pattern.'
        ),
    ]
    storageMetadataConfigSource: Annotated[
        Optional[
            Union[
                NoMetadataConfigurationSource,
                storageMetadataLocalConfig.StorageMetadataLocalConfig,
                storageMetadataHttpConfig.StorageMetadataHttpConfig,
                storageMetadataS3Config.StorageMetadataS3Config,
                storageMetadataADLSConfig.StorageMetadataAdlsConfig,
                storageMetadataGCSConfig.StorageMetadataGcsConfig,
            ]
        ],
        Field(None, title='Storage Metadata Configuration Source'),
    ]
    markDeletedContainers: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete containers in OpenMetadata if the source containers are deleted. Also, if the topic is deleted, all the associated entities with that containers will be deleted',
            title='Mark Deleted Containers',
        ),
    ]
    overrideMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName",
            title='Override Metadata',
        ),
    ]
    includeTags: Annotated[
        Optional[bool],
        Field(
            False,
            description='Optional configuration to toggle the tags ingestion.',
            title='Include Tags',
        ),
    ]
