# generated by datamodel-codegen:
#   filename:  api/data/createMlModel.json
#   timestamp: 2025-06-18T15:57:29+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import mlmodel
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateMlModelRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this ML model.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this ML model. It could be title or label from the source services',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of the ML model instance. How it was trained and for what it is used.',
        ),
    ]
    algorithm: Annotated[
        Optional[str],
        Field('mlmodel', description='Algorithm used to train the ML Model'),
    ]
    mlFeatures: Annotated[
        Optional[List[mlmodel.MlFeature]],
        Field(None, description='Features used to train the ML Model.'),
    ]
    target: Annotated[
        Optional[basic.EntityName],
        Field(None, description='For supervised ML Models, the value to estimate.'),
    ]
    mlHyperParameters: Annotated[
        Optional[List[mlmodel.MlHyperParameter]],
        Field(None, description='Hyper Parameters used to train the ML Model.'),
    ]
    dashboard: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Performance Dashboard fqn to track metric evolution'),
    ]
    mlStore: Annotated[
        Optional[mlmodel.MlStore],
        Field(
            None,
            description='Location containing the ML Model. It can be a storage layer and/or a container repository.',
        ),
    ]
    server: Annotated[
        Optional[basic.Href],
        Field(
            None,
            description='Endpoint that makes the ML Model available, e.g,. a REST API serving the data or computing predictions.',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this ML Model'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this database'),
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Link to the MLModel service fqn where this pipeline is hosted in'
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of mlModel.')
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully qualified name of the domain the MLModel belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
