# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/automatorAppConfig.json
#   timestamp: 2025-06-18T15:57:29+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .automator import (
    addCustomProperties,
    addDescriptionAction,
    addDomainAction,
    addOwnerAction,
    addTagsAction,
    addTierAction,
    lineagePropagationAction,
    mlTaggingAction,
    removeCustomPropertiesAction,
    removeDescriptionAction,
    removeDomainAction,
    removeOwnerAction,
    removeTagsAction,
    removeTierAction,
)


class AutomatorAppType(Enum):
    Automator = 'Automator'


class Resource(BaseModel):
    type: Annotated[
        Optional[List[str]],
        Field(None, description="Type of the entity. E.g., 'table', 'chart',..."),
    ]
    queryFilter: Annotated[
        Optional[str],
        Field(
            None,
            description='Query filter to be passed to ES. E.g., `{"query":{"bool":{"must":[{"bool":{"should":[{"term":{"domain.displayName.keyword":"DG Anim"}}]}}]}}}`. This is the same payload as in the Explore page.',
        ),
    ]


class Action(
    RootModel[
        Union[
            addTagsAction.AddTagsAction,
            removeTagsAction.RemoveTagsAction,
            addDomainAction.AddDomainAction,
            removeDomainAction.RemoveDomainAction,
            addDescriptionAction.AddDescriptionAction,
            addCustomProperties.AddCustomPropertiesAction,
            removeDescriptionAction.RemoveDescriptionAction,
            addTierAction.AddTierAction,
            removeTierAction.RemoveTierAction,
            addOwnerAction.AddOwnerAction,
            removeOwnerAction.RemoveOwnerAction,
            removeCustomPropertiesAction.RemoveCustomPropertiesAction,
            lineagePropagationAction.LineagePropagationAction,
            mlTaggingAction.MLTaggingAction,
        ]
    ]
):
    root: Annotated[
        Union[
            addTagsAction.AddTagsAction,
            removeTagsAction.RemoveTagsAction,
            addDomainAction.AddDomainAction,
            removeDomainAction.RemoveDomainAction,
            addDescriptionAction.AddDescriptionAction,
            addCustomProperties.AddCustomPropertiesAction,
            removeDescriptionAction.RemoveDescriptionAction,
            addTierAction.AddTierAction,
            removeTierAction.RemoveTierAction,
            addOwnerAction.AddOwnerAction,
            removeOwnerAction.RemoveOwnerAction,
            removeCustomPropertiesAction.RemoveCustomPropertiesAction,
            lineagePropagationAction.LineagePropagationAction,
            mlTaggingAction.MLTaggingAction,
        ],
        Field(
            description='Action to take on those entities. E.g., propagate description through lineage, auto tagging, etc.'
        ),
    ]


class AutomatorAppConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        AutomatorAppType,
        Field(description='Application Type', title='Application Type'),
    ]
    resources: Annotated[
        Resource, Field(description='Entities selected to run the automation.')
    ]
    actions: Annotated[
        List[Action],
        Field(
            description='Action to take on those entities. E.g., propagate description through lineage, auto tagging, etc.'
        ),
    ]
