# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/quickSightConnection.json
#   timestamp: 2025-06-18T15:57:29+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import awsCredentials
from .. import connectionBasicType


class IdentityType(Enum):
    IAM = 'IAM'
    QUICKSIGHT = 'QUICKSIGHT'
    ANONYMOUS = 'ANONYMOUS'


class QuickSightType(Enum):
    QuickSight = 'QuickSight'


class QuickSightConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[QuickSightType],
        Field(
            QuickSightType.QuickSight, description='Service Type', title='Service Type'
        ),
    ]
    awsConfig: Annotated[
        awsCredentials.AWSCredentials, Field(title='AWS Credentials Configuration')
    ]
    awsAccountId: Annotated[
        str, Field(description='AWS Account ID', title='AWS Account ID')
    ]
    identityType: Annotated[
        Optional[IdentityType],
        Field(
            IdentityType.IAM,
            description='The authentication method that the user uses to sign in.',
            title='Identity Type',
        ),
    ]
    namespace: Annotated[
        Optional[str],
        Field(
            None,
            description='The Amazon QuickSight namespace that contains the dashboard IDs in this request ( To be provided when identityType is `ANONYMOUS` )',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
