# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/nifiConnection.json
#   timestamp: 2025-06-18T15:57:29+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType
from .nifi import basicAuth, clientCertificateAuth


class NifiType(Enum):
    Nifi = 'Nifi'


class BasicAuthentication(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    username: Annotated[
        Optional[str],
        Field(
            None, description='Nifi user to authenticate to the API.', title='Username'
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='Nifi password to authenticate to the API.',
            title='Password',
        ),
    ]
    verifySSL: Annotated[
        Optional[bool],
        Field(
            False,
            description='Boolean marking if we need to verify the SSL certs for Nifi. False by default.',
            title='Verify SSL',
        ),
    ]


class ClientCertificateAuthentication(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    certificateAuthorityPath: Annotated[
        Optional[str],
        Field(
            None,
            description='Path to the root CA certificate',
            title='Certificat Authority Path',
        ),
    ]
    clientCertificatePath: Annotated[
        Optional[str],
        Field(
            None,
            description='Path to the client certificate',
            title='Client Certificat',
        ),
    ]
    clientkeyPath: Annotated[
        Optional[str],
        Field(None, description='Path to the client key', title='Client Key'),
    ]


class NifiConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[NifiType],
        Field(NifiType.Nifi, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(description='Pipeline Service Management/UI URI.', title='Host And Port'),
    ]
    nifiConfig: Annotated[
        Union[basicAuth.NifiBasicAuth, clientCertificateAuth.NifiClientCertificateAuth],
        Field(
            description='We support username/password or client certificate authentication',
            title='Nifi Credentials Configuration',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
