# generated by datamodel-codegen:
#   filename:  entity/services/connections/storage/adlsConnection.json
#   timestamp: 2025-06-18T15:57:29+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import azureCredentials
from .. import connectionBasicType


class AzureType(Enum):
    ADLS = 'ADLS'


class AdlsConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AzureType],
        Field(AzureType.ADLS, description='Service Type', title='Service Type'),
    ]
    credentials: Annotated[
        azureCredentials.AzureCredentials,
        Field(description='Azure Credentials', title='Azure Credentials'),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
