from ..utils import import_name as import_name
from .base import AbstractEntity as AbstractEntity, NameLogger as NameLogger
from .config import ValueExtractor as ValueExtractor
from collections.abc import Generator
from typing import Any, Callable, FrozenSet, Iterable, List, MutableMapping, Optional, Sequence, Set, Tuple, Type, TypeVar, Union

T = TypeVar('T')
TSeq = Union[Sequence, Set, FrozenSet]
DOT: str

class Octopus(MutableMapping):
    def items(self): ...
    def __getitem__(self, key): ...
    def __setitem__(self, key, value) -> None: ...
    def __delitem__(self, key) -> None: ...
    def __iter__(self): ...
    def __len__(self): ...
    def find_iter(self, cls: Type[T], *, exclude: Optional[Set[int]] = ...) -> Iterable[Tuple[str, T]]: ...

class Signal:
    LOG_RUN: str
    LOG_END: str
    def __init__(self, context: Context, name: str = ...) -> None: ...
    def append(self, signal: Callable, groups: TSeq = ...): ...
    def send(self, group_resolver, *, coroutine: bool = ...): ...

class GroupResolver:
    def __init__(self, include: Any | None = ..., exclude: Any | None = ..., all_groups: bool = ..., default: bool = ...) -> None: ...
    def match(self, groups): ...

class ContextProcessor:
    context: Any
    path: Any
    value: Any
    def __init__(self, context: Context, path: str, value: ValueExtractor) -> None: ...
    @classmethod
    def match(cls, context: Context, path: str, value: ValueExtractor): ...
    async def process(self) -> None: ...

class LoggingContextProcessor(ContextProcessor):
    key: str
    process: Any
    @classmethod
    def match(cls, context, path, value): ...
    def configure(self, value) -> None: ...

class GroupsContextProcessor(ContextProcessor):
    key: str
    process: Any
    @classmethod
    def match(cls, context, path, value): ...

class EntityContextProcessor(ContextProcessor):
    key: str
    entity: Any
    def __init__(self, context: Context, path: str, value: ValueExtractor) -> None: ...
    @classmethod
    def match(cls, context: Context, path: str, value: ValueExtractor) -> Optional[ContextProcessor]: ...
    async def process(self) -> None: ...

class InstanceEntityContextProcessor(EntityContextProcessor):
    key: str
    entity: Any
    def __init__(self, context: Context, path: str, value: ValueExtractor) -> None: ...
    @classmethod
    def match(cls, context: Context, path: str, value: ValueExtractor) -> Optional[ContextProcessor]: ...
    async def process(self) -> None: ...

class FuncContextProcessor(ContextProcessor):
    key: str
    process: Any
    def __init__(self, context: Context, path: str, value: ValueExtractor) -> None: ...
    @classmethod
    def match(cls, context: Context, path: str, value: ValueExtractor) -> Optional[ContextProcessor]: ...

class RootContextProcessor(ContextProcessor):
    processors: Any
    on_ready: Any
    def __init__(self, context, path: Any | None = ..., value: Any | None = ...) -> None: ...
    def __iter__(self): ...
    def processing(self, config, path: Any | None = ...) -> None: ...
    value: Any
    def build(self, config) -> None: ...
    async def process(self, config: Any | None = ...) -> None: ...

class Context(AbstractEntity, Octopus):
    logger: Any
    processors: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def set_group_resolver(self, gr) -> None: ...
    def set_config(self, config) -> None: ...
    def set_loop(self, loop) -> None: ...
    def processes(self) -> Generator[None, None, None]: ...
    @property
    def on_connect(self): ...
    @property
    def on_start(self): ...
    @property
    def on_stop(self): ...
    @property
    def on_disconnect(self): ...
    @property
    def on_cleanup(self): ...
    async def init(self) -> None: ...
    async def wait_all(self, coros, timeout: Any | None = ...) -> None: ...
    async def connect(self) -> None: ...
    async def start(self) -> None: ...
    async def stop(self) -> None: ...
    async def disconnect(self) -> None: ...
    def run_forever(self) -> None: ...
    def __dir__(self) -> List[str]: ...
    def __getitem__(self, item): ...
    def __setitem__(self, key, value) -> None: ...
    def __setattr__(self, key, value) -> None: ...
    def __getattr__(self, item): ...
    def __enter__(self): ...
    def __exit__(self, exc_type, exc_val, exc_tb) -> None: ...
    async def __aenter__(self): ...
    async def __aexit__(self, exc_type, exc_val, exc_tb) -> None: ...
    def get_object(self, path): ...
