# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_fitz')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_fitz')
    _fitz = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_fitz', [dirname(__file__)])
        except ImportError:
            import _fitz
            return _fitz
        try:
            _mod = imp.load_module('_fitz', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _fitz = swig_import_helper()
    del swig_import_helper
else:
    import _fitz
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0


import weakref
from binascii import hexlify
import math


VersionFitz = "1.13.0"
VersionBind = "1.13.20"
VersionDate = "2018-09-09 09:54:14"
version = (VersionBind, VersionFitz, "20180909095414")


#------------------------------------------------------------------------------
# Font definitions for new PyMuPDF widgets.
# IMPORTANT: do not change anything here! Line breaks are required, as well
# as are the spaces after the font ref names.
#------------------------------------------------------------------------------
Widget_fontobjects = """<</CoBI <</Type/Font/Subtype/Type1/BaseFont/Courier-BoldOblique/Encoding/WinAnsiEncoding>>\n/CoBo <</Type/Font/Subtype/Type1/BaseFont/Courier-Bold/Encoding/WinAnsiEncoding>>\n/CoIt <</Type/Font/Subtype/Type1/BaseFont/Courier-Oblique/Encoding/WinAnsiEncoding>>\n/Cour <</Type/Font/Subtype/Type1/BaseFont/Courier/Encoding/WinAnsiEncoding>>\n/HeBI <</Type/Font/Subtype/Type1/BaseFont/Helvetica-BoldOblique/Encoding/WinAnsiEncoding>>\n/HeBo <</Type/Font/Subtype/Type1/BaseFont/Helvetica-Bold/Encoding/WinAnsiEncoding>>\n/HeIt <</Type/Font/Subtype/Type1/BaseFont/Helvetica-Oblique/Encoding/WinAnsiEncoding>>\n/Helv <</Type/Font/Subtype/Type1/BaseFont/Helvetica/Encoding/WinAnsiEncoding>>\n/Symb <</Type/Font/Subtype/Type1/BaseFont/Symbol/Encoding/WinAnsiEncoding>>\n/TiBI <</Type/Font/Subtype/Type1/BaseFont/Times-BoldItalic/Encoding/WinAnsiEncoding>>\n/TiBo <</Type/Font/Subtype/Type1/BaseFont/Times-Bold/Encoding/WinAnsiEncoding>>\n/TiIt <</Type/Font/Subtype/Type1/BaseFont/Times-Italic/Encoding/WinAnsiEncoding>>\n/TiRo <</Type/Font/Subtype/Type1/BaseFont/Times-Roman/Encoding/WinAnsiEncoding>>\n/ZaDb <</Type/Font/Subtype/Type1/BaseFont/ZapfDingbats/Encoding/WinAnsiEncoding>>>>"""

def _Widget_fontdict():
    """Turns the above font definitions into a dictionary. Assumes certain line breaks and spaces.
    """
    flist = Widget_fontobjects[2:-2].splitlines()
    fdict = {}
    for f in flist:
        k, v = f.split(" ")
        fdict[k[1:]] = v
    return fdict

Widget_fontdict = _Widget_fontdict()   # needed so we can use it as a property

#------------------------------------------------------------------------------
# Class describing a PDF form field ("widget")
#------------------------------------------------------------------------------
class Widget():
    def __init__(self):
        self.border_color       = None
        self.border_style       = "S"
        self.border_width       = 0
        self.border_dashes      = None
        self.choice_values      = None           # choice fields only
        self.field_name         = None           # field name
        self.field_value        = None
        self.field_flags        = None
        self.fill_color         = None
        self.button_caption     = None           # button caption
        self.rect               = None           # annot value
        self.text_color         = (0, 0, 0)
        self.text_font          = "Helv"
        self.text_fontsize      = 0
        self.text_maxlen        = 0              # text fields only
        self.text_type          = 0              # text fields only
        self._text_da           = ""             # /DA = default apparance
        self.field_type         = 3              # valid range 0 through 6
        self.field_type_string  = None           # field type as string
        self._text_da           = ""             # /DA = default apparance
        self._dr_xref           = 0              # xref of /DR entry

    def _validate(self):
        """Validate the class entries.
        """
        checker = (self._check0, self._check1, self._check2, self._check3,
                   self._check4, self._check5)
        if not 0 <= self.field_type <= 5:
            raise NotImplementedError("unsupported widget type")
        if type(self.rect) is not Rect:
            raise ValueError("invalid rect")
        if self.rect.isInfinite or self.rect.isEmpty:
            raise ValueError("rect must be finite and not empty")
        if not self.field_name:
            raise ValueError("field name missing")

        if self.border_color:
            if not len(self.border_color) in range(1,5) or \
               type(self.border_color) not in (list, tuple):
               raise ValueError("border_color must be 1 - 4 floats")

        if self.fill_color:
            if not len(self.fill_color) in range(1,5) or \
               type(self.fill_color) not in (list, tuple):
               raise ValueError("fill_color must be 1 - 4 floats")

        if not self.text_color:
            self.text_color = (0, 0, 0)
        if not len(self.text_color) in range(1,5) or \
            type(self.text_color) not in (list, tuple):
            raise ValueError("text_color must be 1 - 4 floats")

        if not self.border_width:
            self.border_width = 0

        if not self.text_fontsize:
            self.text_fontsize = 0

        checker[self.field_type]()

    def _adjust_font(self):
        """Ensure the font name is from our list and correctly spelled.
        """
        fnames = [k for k in Widget_fontdict.keys()]
        fl = list(map(str.lower, fnames))
        if (not self.text_font) or self.text_font.lower() not in fl:
            self.text_font = "helv"
        i = fl.index(self.text_font.lower())
        self.text_font = fnames[i]
        return

    def _parse_da(self):
        """Extract font name, size and color from default appearance string (/DA object). Equivalent to 'pdf_parse_default_appearance' function in MuPDF's 'pdf-annot.c'.
        """
        if not self._text_da:
            return
        font = "Helv"
        fsize = 0
        col = (0, 0, 0)
        dat = self._text_da.split()              # split on any whitespace
        for i, item in enumerate(dat):
            if item == "Tf":
                font = dat[i - 2][1:]
                fsize = float(dat[i - 1])
                dat[i] = dat[i-1] = dat[i-2] = ""
                continue
            if item == "g":            # unicolor text
                col = [(float(dat[i - 1]))]
                dat[i] = dat[i-1] = ""
                continue
            if item == "rg":           # RGB colored text
                col = [float(f) for f in dat[i - 3:i]]
                dat[i] = dat[i-1] = dat[i-2] = dat[i-3] = ""
                continue
        self.text_font     = font
        self.text_fontsize = fsize
        self.text_color    = col
        self._text_da = " ".join([c for c in dat if c != ""])
        return

# any widget type specific checks
    def _check0(self):
        return

    def _check1(self):
        return

    def _check2(self):
        return

    def _check3(self):
        if not 0 <= self.text_type <= 4:
            raise ValueError("text subtype not in range 0 - 4")
        return

    def _check4(self):
        if type(self.choice_values) not in (tuple, list):
            raise ValueError("field type requires a value list")
        if len(self.choice_values) < 2:
            raise ValueError("too few choice values")
        return

    def _check5(self):
        if type(self.choice_values) not in (tuple, list):
            raise ValueError("field type requires a value list")
        if len(self.choice_values) < 2:
            raise ValueError("too few choice values")
        return



#------------------------------------------------------------------------------
# link kinds and link flags
#------------------------------------------------------------------------------
LINK_NONE   = 0
LINK_GOTO   = 1
LINK_URI    = 2
LINK_LAUNCH = 3
LINK_NAMED  = 4
LINK_GOTOR  = 5
LINK_FLAG_L_VALID = 1
LINK_FLAG_T_VALID = 2
LINK_FLAG_R_VALID = 4
LINK_FLAG_B_VALID = 8
LINK_FLAG_FIT_H = 16
LINK_FLAG_FIT_V = 32
LINK_FLAG_R_IS_ZOOM = 64

#------------------------------------------------------------------------------
# Text handling flags
#------------------------------------------------------------------------------
TEXT_ALIGN_LEFT     = 0
TEXT_ALIGN_CENTER   = 1
TEXT_ALIGN_RIGHT    = 2
TEXT_ALIGN_JUSTIFY  = 3

TEXT_OUTPUT_TEXT    = 0
TEXT_OUTPUT_HTML    = 1
TEXT_OUTPUT_JSON    = 2
TEXT_OUTPUT_XML     = 3
TEXT_OUTPUT_XHTML   = 4

TEXT_PRESERVE_LIGATURES  = 1
TEXT_PRESERVE_WHITESPACE = 2
TEXT_PRESERVE_IMAGES     = 4

#------------------------------------------------------------------------------
# Base 14 font names
#------------------------------------------------------------------------------

Base14_fontnames = ("Courier", "Courier-Oblique", "Courier-Bold",
    "Courier-BoldOblique", "Helvetica", "Helvetica-Oblique",
    "Helvetica-Bold", "Helvetica-BoldOblique",
    "Times-Roman", "Times-Italic", "Times-Bold",
    "Times-BoldItalic", "Symbol", "ZapfDingbats")

#------------------------------------------------------------------------------
# Emulate old linkDest class
#------------------------------------------------------------------------------
class linkDest():
    '''link or outline destination details'''
    def __init__(self, obj, rlink):
        isExt = obj.isExternal
        isInt = not isExt
        self.dest = ""
        self.fileSpec = ""
        self.flags = 0
        self.isMap = False
        self.isUri = False
        self.kind = LINK_NONE
        self.lt = Point(0, 0)
        self.named = ""
        self.newWindow = ""
        self.page = obj.page
        self.rb = Point(0, 0)
        self.uri = obj.uri
        if rlink and not self.uri.startswith("#"):
            self.uri = "#%i,%g,%g" % (rlink[0]+1, rlink[1], rlink[2])
        if obj.isExternal:
            self.page = -1
            self.kind = LINK_URI
        if not self.uri:
            self.page = -1
            self.kind = LINK_NONE
        if isInt and self.uri:
            if self.uri.startswith("#"):
                self.named = ""
                self.kind = LINK_GOTO
                ftab = self.uri[1:].split(",")
                if len(ftab) == 3:
                    self.page = int(ftab[0]) - 1
                    self.lt = Point(float(ftab[1]), float(ftab[2]))
                    self.flags = self.flags | LINK_FLAG_L_VALID | LINK_FLAG_T_VALID
                else:
                    try:
                        self.page = int(ftab[0]) - 1
                    except:
                        self.kind = LINK_NAMED
                        self.named = self.uri[1:]
            else:
                self.kind = LINK_NAMED
                self.named = self.uri
        if obj.isExternal:
            if self.uri.startswith(("http://", "https://", "mailto:", "ftp://")):
                self.isUri = True
                self.kind = LINK_URI
            elif self.uri.startswith("file://"):
                self.fileSpec = self.uri[7:]
                self.isUri = False
                self.uri = ""
                self.kind = LINK_LAUNCH
                ftab = self.fileSpec.split("#")
                if len(ftab) == 2:
                    if ftab[1].startswith("page="):
                        self.kind = LINK_GOTOR
                        self.fileSpec = ftab[0]
                        self.page = int(ftab[1][5:]) - 1
            else:
                self.isUri = True
                self.kind = LINK_LAUNCH

#-------------------------------------------------------------------------------
# "Now" timestamp in PDF Format
#-------------------------------------------------------------------------------
def getPDFnow():
    import time
    tz = "%s'%s'" % (str(time.timezone // 3600).rjust(2, "0"),
                 str((time.timezone // 60)%60).rjust(2, "0"))
    tstamp = time.strftime("D:%Y%m%d%H%M%S", time.localtime())
    if time.timezone > 0:
        tstamp += "-" + tz
    elif time.timezone < 0:
        tstamp = "+" + tz
    else:
        pass
    return tstamp

#-------------------------------------------------------------------------------
# Return a PDF string depending on its coding.
# If only ascii then "(original)" is returned,
# else if only 8 bit chars then "(original)" with interspersed octal strings
# \nnn is returned,
# else a string "<FEFF[hexstring]>" is returned, where [hexstring] is the
# UTF-16BE encoding of the original.
#-------------------------------------------------------------------------------
def getPDFstr(x):
    if x is None or x == "":
        return "()"

    utf16 = max(ord(c) for c in x) > 255
    if utf16:
# require full unicode: make a UTF-16BE hex string with BOM "feff"
        r = hexlify(bytearray([254, 255]) + bytearray(x, "UTF-16BE"))
# r is 'bytes', so convert to 'str' if Python 3
        t = r if str is bytes else r.decode()
        return "<" + t + ">"                         # brackets indicate hex

    s = x.replace("\x00", " ")
    if str is bytes:
        if type(s) is str:
            s = unicode(s, "utf-8", "replace")

# following returns ascii original string with mixed-in 
# octal numbers \nnn if <= chr(255)
    r = ""
    for c in s:
        oc = ord(c)
        if oc > 127:
            r += "\\" + oct(oc)[-3:]
        else:
            if c in ("(", ")", "\\"):
                r += "\\"
            r += c

    return "(" + r + ")"

#------------------------------------------------------------------------------
# Return a PDF string suitable for the TJ operator enclosed in "[]" brackets.
# The input string is converted to either 2 or 4 hex digits per character.
# If no glyphs are supplied, then a simple font is assumed and each character
# taken directly.
# Otherwise a char's glyph is taken and 4 hex digits per char are put out.
#------------------------------------------------------------------------------
def getTJstr(text, glyphs):
    if text.startswith("[<") and text.endswith(">]"): # already done
        return text
    if not bool(text):
        return "[<>]"
    if glyphs is None:            # this is a simple font
        otxt = "".join([hex(ord(c))[2:].rjust(2, "0") if ord(c)<256 else "3f" for c in text])
        return "[<" + otxt + ">]"
# this is not a simple font -> take the glyphs of a character
    otxt = "".join([hex(glyphs[ord(c)][0])[2:].rjust(4, "0") for c in text])
    return "[<" + otxt + ">]"

'''
Information taken from the following web sites:
www.din-formate.de
www.din-formate.info/amerikanische-formate.html
www.directtools.de/wissen/normen/iso.htm
'''
paperSizes = { # known paper formats @ 72 dpi
        'a0': (2384, 3370),
        'a1': (1684, 2384),
        'a10': (74, 105),
        'a2': (1191, 1684),
        'a3': (842, 1191),
        'a4': (595, 842),
        'a5': (420, 595),
        'a6': (298, 420),
        'a7': (210, 298),
        'a8': (147, 210),
        'a9': (105, 147),
        'b0': (2835, 4008),
        'b1': (2004, 2835),
        'b10': (88, 125),
        'b2': (1417, 2004),
        'b3': (1001, 1417),
        'b4': (709, 1001),
        'b5': (499, 709),
        'b6': (354, 499),
        'b7': (249, 354),
        'b8': (176, 249),
        'b9': (125, 176),
        'c0': (2599, 3677),
        'c1': (1837, 2599),
        'c10': (79, 113),
        'c2': (1298, 1837),
        'c3': (918, 1298),
        'c4': (649, 918),
        'c5': (459, 649),
        'c6': (323, 459),
        'c7': (230, 323),
        'c8': (162, 230),
        'c9': (113, 162),
        'card-4x6': (288, 432),
        'card-5x7': (360, 504),
        'commercial': (297, 684),
        'executive': (522, 756),
        'invoice': (396, 612),
        'ledger': (792, 1224),
        'legal': (612, 1008),
        'legal-13': (612, 936),
        'letter': (612, 792),
        'monarch': (279, 540),
        'tabloid-extra': (864, 1296),
        }
def PaperSize(s):
    """Return a tuple (width, height) for a given paper format string. 'A4-L' will
    return (842, 595), the values for A4 landscape. Suffix '-P' and no suffix
    returns portrait."""
    size = s.lower()
    f = "p"
    if size.endswith("-l"):
        f = "l"
        size = size[:-2]
    if size.endswith("-p"):
        size = size[:-2]
    rc = paperSizes.get(size, (-1, -1))
    if f == "p":
        return rc
    return (rc[1], rc[0])

def PaperRect(s):
    """Return a fitz.Rect for the paper size indicated in string 's'. Must conform to the argument of method 'PaperSize', which will be invoked.
    """
    width, height = PaperSize(s)
    return Rect(0.0, 0.0, width, height)

def CheckParent(o):
    if not hasattr(o, "parent") or o.parent is None:
        raise ValueError("orphaned object: parent is None") 

def CheckColor(c):
    if c is not None:
        if type(c) not in (list, tuple) or len(c) != 3 or \
            min(c) < 0 or max(c) > 1:
            raise ValueError("need 3 color components in range 0 to 1")

def CheckMorph(o):
    if not bool(o): return False
    if not (type(o) in (list, tuple) and len(o) == 2):
        raise ValueError("morph must be a sequence of length 2")
    if not (type(o[0]) == Point and issubclass(type(o[1]), Matrix)):
        raise ValueError("invalid morph parameter")
    if not o[1].e == o[1].f == 0:
        raise ValueError("invalid morph parameter")
    return True

def CheckFont(page, fontname):
    """Return an entry in the page's font list if reference name matches.
    """
    fl = page.getFontList()
    refname = None
    for f in fl:
        if f[4] == fontname:
            refname = f
            break
    return refname

def CheckFontInfo(doc, xref):
    """Return a font info if present in the document.
    """
    fi = None
    for f in doc.FontInfos:
        if xref == f[0]:
            fi = f
            break
    return fi

def UpdateFontInfo(doc, info):
    xref = info[0]
    found = False
    for i, fi in enumerate(doc.FontInfos):
        if fi[0] == xref:
            found = True
            break
    if found:
        doc.FontInfos[i] = info
    else:
        doc.FontInfos.append(info)

def DUMMY(*args, **kw):
    return

def ConversionHeader(i, filename = "unknown"):
    t = i.lower()
    html = """<!DOCTYPE html>
<html>
<head>
<style>
body{background-color:gray}
div{position:relative;background-color:white;margin:1em auto}
p{position:absolute;margin:0}
img{position:absolute}
</style>
</head>
<body>\n"""

    xml = """<?xml version="1.0"?>
<document name="%s">\n""" % filename

    xhtml = """<?xml version="1.0"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<style>
body{background-color:gray}
div{background-color:white;margin:1em;padding:1em}
p{white-space:pre-wrap}
</style>
</head>
<body>\n"""

    text = ""
    json = '{"document": "%s", "pages": [\n' % filename
    if t == "html":
        r = html
    elif t == "json":
        r = json
    elif t == "xml":
        r = xml
    elif t == "xhtml":
        r = xhtml
    else:
        r = text

    return r

def ConversionTrailer(i):
    t = i.lower()
    text = ""
    json = "]\n}"
    html = "</body>\n</html>\n"
    xml = "</document>\n"
    xhtml = html
    if t == "html":
        r = html
    elif t == "json":
        r = json
    elif t == "xml":
        r = xml
    elif t == "xhtml":
        r = xhtml
    else:
        r = text

    return r

#------------------------------------------------------------------------------
# 
#------------------------------------------------------------------------------
def _hor_matrix(C, P):
    """Given two points C, P calculate matrix that rotates the line C -> P parallel to the x-axis.
    """
    S = P - C                               # vector C -> P
    try:
        alfa = math.asin(abs(S.y) / abs(S)) # absolute angle from horizontal
    except ZeroDivisionError:
        print("points are too close:")
        return Matrix()
    if S.x < 0:                             # make arcsin result unique
        if S.y <= 0:                        # bottom-left
            alfa = -(math.pi - alfa)
        else:                               # top-left
            alfa = math.pi - alfa
    else:
        if S.y >= 0:                        # top-right
            pass
        else:                               # bottom-right
            alfa = - alfa
    ca = math.cos(alfa)
    sa = math.sin(alfa)
    m = Matrix(ca, -sa, sa, ca, -C.x, -C.y)
    return m

def _make_rect_AP(annot):
    """ Create /AP stream for rectangle annotation.
    """
    w = annot.border["width"]          # get line width
    sc = annot.colors["stroke"]        # get stroke color
    fc = annot.colors["fill"]          # get fill color
    ca = annot.opacity                 # get opacity value
    Alp0 = "/Alp0 gs\n" if ca >= 0 else ""
    scol = "%g %g %g RG " % (sc[0], sc[1], sc[2]) if sc else "0 0 0 RG "
    fcol = "%g %g %g rg " % (fc[0], fc[1], fc[2]) if fc else ""
    dt = annot.border.get("dashes")    # get annot dashes
    dtab = []
    if dt:
        dtab = ["[", "]0 d"]
        for n in dt:
            dtab[0] += "%i " % n
    dtab = "".join(dtab)               # make dashes command
    r = annot.rect                     # annot rectangle
    r1 = r2 = w/2.                     # rect starts bottom-left here
    r3 = r.width - w                   # rect width reduced by line width
    r4 = r.height - w                  # rect height reduced by line with
    ap = "q\n%s%g %g %g %g re %g w 1 J 1 j\n" % (Alp0, r1, r2, r3, r4, w)
    ap += scol + fcol + dtab           # appearance stream so far
    if fcol:                           # have fill color?
        ap += "\nb\nQ\n"
    else:
        ap += "\ns\nQ\n"
    return ap

def _le_annot_parms(annot, p1, p2):
    """Get common parameters for making line end symbols.
    """
    w = annot.border["width"]          # line width
    sc = annot.colors["stroke"]        # stroke color
    scol = "%g %g %g RG\n" % (sc[0], sc[1], sc[2]) if sc else "0 0 0 RG\n"
    fc = annot.colors["fill"]          # fill color
    fcol = "%g %g %g rg\n" % (fc[0], fc[1], fc[2]) if fc else "1 1 1 rg\n"
    delta = Point(annot.rect.x0, annot.rect.y0)
    nr = annot.rect - Rect(delta, delta)
    h = nr.height
    np1 = p1 - delta                   # point coord relative to annot rect
    np2 = p2 - delta                   # point coord relative to annot rect
    m = _hor_matrix(np1, np2)          # matrix makes the line horizontal
    im = ~m                            # inverted matrix
    L = np1 * m                        # converted start (left) point
    R = np2 * m                        # converted end (right) point
    return m, im, L, R, w, h, scol, fcol

def _make_circle_AP(annot):
    """Create /AP stream for circle annotation
    """
    sc = annot.colors["stroke"]        # stroke color
    scol = "%g %g %g RG " % (sc[0], sc[1], sc[2]) if sc else "0 0 0 RG "
    fc = annot.colors["fill"]          # fill color
    ca = annot.opacity                 # get opacity value
    Alp0 = "/Alp0 gs\n" if ca >= 0 else ""
    fcol = "%g %g %g rg " % (fc[0], fc[1], fc[2]) if fc else ""
    dt = annot.border.get("dashes")    # get annot dashes
    dtab = []
    if dt:
        dtab = ["[", "]0 d\n"]
        for n in dt:
            dtab[0] += "%i " % n
    dtab = "".join(dtab)               # the dashes command
    lw = annot.border["width"]         # line width
    lw2 = lw / 2.
    h = annot.rect.height
    r = Rect(lw2, lw2, annot.rect.width - lw2, h - lw2)

    ap = "q\n" + Alp0 + _oval_string(h, r.tl, r.tr, r.br, r.bl)
    ap += "%g w 1 J 1 j\n" % lw
    ap += scol + fcol + dtab           # ap stream so far
    if fcol:                           # have fill color?
        ap += "\nb\nQ\n"
    else:
        ap += "\ns\nQ\n"
    return ap

def _oval_string(h, p1, p2, p3, p4):
    """Return /AP string defining an oval within a 4-polygon provided as points
    """
    def bezier(p, q, r):
        f = "%g %g %g %g %g %g c\n"
        return f % (p.x, h - p.y, q.x, h - q.y, r.x, h - r.y)

    kappa = 0.55228474983              # magic number
    ml = p1 + (p4 - p1) * 0.5          # middle points ...
    mo = p1 + (p2 - p1) * 0.5          # for each ...
    mr = p2 + (p3 - p2) * 0.5          # polygon ...
    mu = p4 + (p3 - p4) * 0.5          # edge
    ol1 = ml + (p1 - ml) * kappa       # the 8 bezier
    ol2 = mo + (p1 - mo) * kappa       # helper points
    or1 = mo + (p2 - mo) * kappa
    or2 = mr + (p2 - mr) * kappa
    ur1 = mr + (p3 - mr) * kappa
    ur2 = mu + (p3 - mu) * kappa
    ul1 = mu + (p4 - mu) * kappa
    ul2 = ml + (p4 - ml) * kappa
# now draw, starting from middle point of left edge
    ap = "%g %g m\n" % (ml.x, h - ml.y)
    ap += bezier(ol1, ol2, mo)
    ap += bezier(or1, or2, mr)
    ap += bezier(ur1, ur2, mu)
    ap += bezier(ul1, ul2, ml)
    return ap

def _le_diamond(annot, p1, p2, lr):
    """Make stream commands for diamond line end symbol. "lr" denotes left (False) or right point.
    """
    m, im, L, R, w, h, scol, fcol = _le_annot_parms(annot, p1, p2)
    shift = 1.75             # 2*shift*width = length of square edge
    d = w * shift
    M = R - (w, 0) if lr else L + (w, 0)
    r = Rect(M, M) + (-d, -d, d, d)         # the square
# the square makes line longer by (2*shift - 1)*width
    p = (r.tl + (r.bl - r.tl) * 0.5) * im
    ap = "q\n%g %g m\n" % (p.x, h - p.y)
    p = (r.tl + (r.tr - r.tl) * 0.5) * im
    ap += "%g %g l\n"   % (p.x, h - p.y)
    p = (r.tr + (r.br - r.tr) * 0.5) * im
    ap += "%g %g l\n"   % (p.x, h - p.y)
    p = (r.br + (r.bl - r.br) * 0.5) * im
    ap += "%g %g l\n"   % (p.x, h - p.y)
    ap += "%g w\n" % w
    ap += scol + fcol + "b\nQ\n"
    return ap

def _le_square(annot, p1, p2, lr):
    """Make stream commands for square line end symbol. "lr" denotes left (False) or right point.
    """
    m, im, L, R, w, h, scol, fcol = _le_annot_parms(annot, p1, p2)
    shift = 1.25             # 2*shift*width = length of square edge
    d = w * shift
    M = R - (w, 0) if lr else L + (w, 0)
    r = Rect(M, M) + (-d, -d, d, d)         # the square
# the square makes line longer by (2*shift - 1)*width
    p = r.tl * im
    ap = "q\n%g %g m\n" % (p.x, h - p.y)
    p = r.tr * im
    ap += "%g %g l\n"   % (p.x, h - p.y)
    p = r.br * im
    ap += "%g %g l\n"   % (p.x, h - p.y)
    p = r.bl * im
    ap += "%g %g l\n"   % (p.x, h - p.y)
    ap += "%g w\n" % w
    ap += scol + fcol + "b\nQ\n"
    return ap

def _le_circle(annot, p1, p2, lr):
    """Make stream commands for circle line end symbol. "lr" denotes left (False) or right point.
    """
    m, im, L, R, w, h, scol, fcol = _le_annot_parms(annot, p1, p2)
    shift = 1.50             # 2*shift*width = length of square edge
    d = w * shift
    M = R - (w, 0) if lr else L + (w, 0)
    r = Rect(M, M) + (-d, -d, d, d)         # the square
    ap = "q\n" + _oval_string(h, r.tl * im, r.tr * im, r.br * im, r.bl * im)
    ap += "%g w\n" % w
    ap += scol + fcol + "b\nQ\n"
    return ap

def _le_butt(annot, p1, p2, lr):
    """Make stream commands for butt line end symbol. "lr" denotes left (False) or right point.
    """
    m, im, L, R, w, h, scol, fcol = _le_annot_parms(annot, p1, p2)
    M = R if lr else L
    top = (M + (0, -2 * w)) * im
    bot = (M + (0, 2 * w)) * im
    ap = "\nq\n%g %g m\n" % (top.x, h - top.y)
    ap += "%g %g l\n" % (bot.x, h - bot.y)
    ap += "%g w\n" % w
    ap += scol + "s\nQ\n"
    return ap

def _le_slash(annot, p1, p2, lr):
    """Make stream commands for slash line end symbol. "lr" denotes left (False) or right point.
    """
    m, im, L, R, w, h, scol, fcol = _le_annot_parms(annot, p1, p2)
    rw = 1.1547 * w * 0.5         # makes rect diagonal a 30 deg inclination
    M = R if lr else L
    r = Rect(M.x - rw, M.y - 2 * w, M.x + rw, M.y + 2 * w)
    top = r.tl * im
    bot = r.br * im
    ap = "\nq\n%g %g m\n" % (top.x, h - top.y)
    ap += "%g %g l\n" % (bot.x, h - bot.y)
    ap += "%g w\n" % w
    ap += scol + "s\nQ\n"
    return ap

def _le_openarrow(annot, p1, p2, lr):
    """Make stream commands for open arrow line end symbol. "lr" denotes left (False) or right point.
    """
    m, im, L, R, w, h, scol, fcol = _le_annot_parms(annot, p1, p2)
    p2 = R + (1.5 * w, 0) if lr else L - (1.5 * w, 0)
    p1 = p2 + (-3 * w, -1.5 * w) if lr else p2 + (3 * w, -1.5 * w)
    p3 = p2 + (-3 * w, 1.5 * w) if lr else p2 + (3 * w, 1.5 * w)
    p1 *= im
    p2 *= im
    p3 *= im
    ap = "\nq\n%g %g m\n" % (p1.x, h - p1.y)
    ap += "%g %g l\n" % (p2.x, h - p2.y)
    ap += "%g %g l\n" % (p3.x, h - p3.y)
    ap += "%g w\n" % w
    ap += scol + "S\nQ\n"
    return ap

def _le_closedarrow(annot, p1, p2, lr):
    """Make stream commands for closed arrow line end symbol. "lr" denotes left (False) or right point.
    """
    m, im, L, R, w, h, scol, fcol = _le_annot_parms(annot, p1, p2)
    p2 = R + (1.5 * w, 0) if lr else L - (1.5 * w, 0)
    p1 = p2 + (-3 * w, -1.5 * w) if lr else p2 + (3 * w, -1.5 * w)
    p3 = p2 + (-3 * w, 1.5 * w) if lr else p2 + (3 * w, 1.5 * w)
    p1 *= im
    p2 *= im
    p3 *= im
    ap = "\nq\n%g %g m\n" % (p1.x, h - p1.y)
    ap += "%g %g l\n" % (p2.x, h - p2.y)
    ap += "%g %g l\n" % (p3.x, h - p3.y)
    ap += "%g w\n" % w
    ap += scol + fcol + "b\nQ\n"
    return ap

def _le_ropenarrow(annot, p1, p2, lr):
    """Make stream commands for right open arrow line end symbol. "lr" denotes left (False) or right point.
    """
    m, im, L, R, w, h, scol, fcol = _le_annot_parms(annot, p1, p2)
    p2 = R - (0.5 * w, 0) if lr else L + (0.5 * w, 0)
    p1 = p2 + (3 * w, -1.5 * w) if lr else p2 + (-3 * w, -1.5 * w)
    p3 = p2 + (3 * w, 1.5 * w) if lr else p2 + (-3 * w, 1.5 * w)
    p1 *= im
    p2 *= im
    p3 *= im
    ap = "\nq\n%g %g m\n" % (p1.x, h - p1.y)
    ap += "%g %g l\n" % (p2.x, h - p2.y)
    ap += "%g %g l\n" % (p3.x, h - p3.y)
    ap += "%g w\n" % w
    ap += scol + fcol + "S\nQ\n"
    return ap

def _le_rclosedarrow(annot, p1, p2, lr):
    """Make stream commands for right closed arrow line end symbol. "lr" denotes left (False) or right point.
    """
    m, im, L, R, w, h, scol, fcol = _le_annot_parms(annot, p1, p2)
    p2 = R - (3.0 * w, 0) if lr else L + (3.0 * w, 0)
    p1 = p2 + (3 * w, -1.5 * w) if lr else p2 + (-3 * w, -1.5 * w)
    p3 = p2 + (3 * w, 1.5 * w) if lr else p2 + (-3 * w, 1.5 * w)
    p1 *= im
    p2 *= im
    p3 *= im
    ap = "\nq\n%g %g m\n" % (p1.x, h - p1.y)
    ap += "%g %g l\n" % (p2.x, h - p2.y)
    ap += "%g %g l\n" % (p3.x, h - p3.y)
    ap += "%g w\n" % w
    ap += scol + fcol + "b\nQ\n"
    return ap

def _make_line_AP(annot, nv = None, r0 = None):
    """ Create the /AP stream for 'Line', 'PolyLine' and 'Polygon' annotations.
    """
    w = annot.border["width"]          # get line width
    sc = annot.colors["stroke"]        # get stroke color
    fc = annot.colors["fill"]          # get fill color
    ca = annot.opacity                 # get opacity value
    Alp0 = "/Alp0 gs\n" if ca >= 0 else ""
    vert = nv if nv else annot.vertices # get list of points
    rn = r0 if r0 else annot.rect
    h = rn.height                      # annot rectangle height
    r = Rect(0, 0, rn.width, h)        # this is the /BBox of the /AP
    x0 = rn.x0                         # annot rect origin x
    y0 = rn.y0                         # annot rect origin y
    scol = "%g %g %g RG\n" % (sc[0], sc[1], sc[2]) if sc else "0 0 0 RG\n"
    fcol = "%g %g %g rg\n" % (fc[0], fc[1], fc[2]) if fc else ""

    dt = annot.border.get("dashes")    # get annot dashes
    dtab = []
    if dt:
        dtab = ["[", "]0 d\n"]
        for n in dt:
            dtab[0] += "%i " % n
    dtab = "".join(dtab)               # dashes command

# start /AP string with a goto command
    ap = "q\n%s%g %g m\n" % (Alp0, vert[0][0] - x0, h - (vert[0][1] - y0))

# add line commands for all subsequent points
    for v in vert[1:]:
        ap += "%g %g l\n" % (v[0] - x0, h - (v[1] - y0))

# add color triples and other stuff commands
    ap += scol + fcol + dtab + "%g w 1 J 1 j\n" % w

# add stroke / fill & stroke command depending on type
    if fcol and annot.type[0] == ANNOT_POLYGON:
        ap += "b"
    else:
        ap += "S"
    ap += "\nQ\n"

# function names for creating line end symbols
    _le_func = (None, _le_square, _le_circle, _le_diamond, _le_openarrow,
                _le_closedarrow, _le_butt, _le_ropenarrow,
                _le_rclosedarrow, _le_slash)
    valid_range = range(1, len(_le_func))

    le_left, le_right = annot.lineEnds # get line end symbol numbers

    if le_left in valid_range:         # uses points 1 and 2
        func = _le_func[le_left]       # function for left symbol
        ap += func(annot, Point(vert[0]), Point(vert[1]), False)

    if le_right in valid_range:        # uses last and second to last points
        func = _le_func[le_right]      # function for right symbol
        ap += func(annot, Point(vert[-2]), Point(vert[-1]), True)

    return ap

def _upd_my_AP(annot):
    """Update /AP stream for annotation types we are handling.
    """
    if annot.type[0] not in range(2, 8):    # not our business
        return

# this is the /AP rect for circle or square
    r = Rect(0, 0, annot.rect.width, annot.rect.height)

    if annot.type[0] == ANNOT_CIRCLE:
        ap = _make_circle_AP(annot)    # stream for circle annot
        annot._checkAP(r, ap)
        return

    if annot.type[0] == ANNOT_SQUARE:
        ap = _make_rect_AP(annot)      # stream for square annot
        annot._checkAP(r, ap)
        return

#--------------------------------------------------------------------------
# we have one of the line annotations
#--------------------------------------------------------------------------

# first calculate the rect that contains all the points, including small
# extra rects around first and last point for any line symbols.
    w = 3 * annot.border["width"]      # 3 times the line width
    ov = annot.vertices                # get all the points
    rect = Rect(Point(ov[0]), Point(ov[0])) + (-w, -w, w, w)
    for v in ov[1:-1]:                 # include remaining points
        rect |= v
    rect |= Rect(Point(ov[-1]), Point(ov[-1])) + (-w, -w, w, w)

    annot._setRect(rect)               # set this as annot rect
    r = Rect(0, 0, rect.width, rect.height) # derive the /AP rect

    ap = _make_line_AP(annot)          # make the /AP stream
    annot._checkAP(r, ap)              # create or update /AP object
    return

class Document(_object):
    """open() - new empty PDF
open('type', stream) - from bytes/bytearray
open(filename, filetype='type') - from file"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Document, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Document, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Document
    __del__ = lambda self: None

    def __init__(self, filename=None, stream=None, filetype=None, rect=None, width=0, height=0, fontsize=11):
        """__init__(self, filename=None, stream=None, filetype=None, rect=None, width=0, height=0, fontsize=11) -> Document"""

        if not filename or type(filename) == str:
            pass
        elif type(filename) == unicode:
            filename = filename.encode('utf8')
        else:
            raise TypeError("filename must be string or None")
        self.name = filename if filename else ""
        self.streamlen = len(stream) if stream else 0
        if stream and not (filename or filetype):
            raise ValueError("filetype missing with stream specified")
        if stream and type(stream) not in (bytes, bytearray):
            raise ValueError("stream must be bytes or bytearray")
        self.isClosed    = False
        self.isEncrypted = 0
        self.metadata    = None
        self.stream      = stream       # prevent garbage collecting this
        self.openErrCode = 0
        self.openErrMsg  = ''
        self.FontInfos   = []
        self.Graftmaps   = {}
        self._page_refs  = weakref.WeakValueDictionary()

        this = _fitz.new_Document(filename, stream, filetype, rect, width, height, fontsize)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if this:
            self.openErrCode = self._getGCTXerrcode()
            self.openErrMsg  = self._getGCTXerrmsg()
            self.thisown = True
            tools = Tools()
            self._graft_id = tools.gen_id()
            tools = None
            if self.needsPass:
                self.isEncrypted = 1
            else: # we won't init until doc is decrypted
                self.initData()
        else:
            self.thisown = False




    def close(self):
        """close(self)"""

        if self.isClosed:
            raise ValueError("operation illegal for closed doc")
        if hasattr(self, '_outline') and self._outline:
            self._dropOutline(self._outline)
            self._outline = None
        self._reset_page_refs()
        self.metadata    = None
        self.stream      = None
        self.isClosed    = True
        self.openErrCode = 0
        self.openErrMsg  = ''
        self.FontInfos   = []
        for gmap in self.Graftmaps:
            self.Graftmaps[gmap] = None
        self.Graftmaps = {}


        val = _fitz.Document_close(self)
        self.thisown = False

        return val


    def loadPage(self, number=0):
        """loadPage(self, number=0) -> Page"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        val = _fitz.Document_loadPage(self, number)

        if val:
            val.thisown = True
            val.parent = weakref.proxy(self)
            pageCount = self.pageCount
            n = number
            while n < 0: n += pageCount
            val.number = n
            self._page_refs[id(val)] = val
            val._annot_refs = weakref.WeakValueDictionary()


        return val


    def _loadOutline(self):
        """_loadOutline(self) -> Outline"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__loadOutline(self)


    def _dropOutline(self, ol):
        """_dropOutline(self, ol)"""
        return _fitz.Document__dropOutline(self, ol)

    @property

    def embeddedFileCount(self):
        """Return number of embedded files."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_embeddedFileCount(self)


    def embeddedFileDel(self, name):
        """Delete embedded file by name."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_embeddedFileDel(self, name)


    def embeddedFileInfo(self, id):
        """Retrieve embedded file information given its entry number or name."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_embeddedFileInfo(self, id)


    def embeddedFileUpd(self, id, buffer=None, filename=None, ufilename=None, desc=None):
        """Change an embedded file given its entry number or name."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_embeddedFileUpd(self, id, buffer, filename, ufilename, desc)


    def embeddedFileSetInfo(self, id, filename=None, ufilename=None, desc=None):
        self.embeddedFileUpd(id, filename=filename, ufilename=ufilename, desc=desc)
        return


    def embeddedFileGet(self, id):
        """Retrieve embedded file content by name or by number."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_embeddedFileGet(self, id)


    def embeddedFileAdd(self, buffer, name, filename=None, ufilename=None, desc=None):
        """Embed a new file."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_embeddedFileAdd(self, buffer, name, filename, ufilename, desc)


    def convertToPDF(self, from_page=0, to_page=-1, rotate=0):
        """Convert document to PDF selecting copy range and optional rotation. Output bytes object."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_convertToPDF(self, from_page, to_page, rotate)

    @property

    def pageCount(self):
        """pageCount(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_pageCount(self)


    def _getMetadata(self, key):
        """_getMetadata(self, key) -> char *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getMetadata(self, key)

    @property

    def needsPass(self):
        """needsPass(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_needsPass(self)


    def resolveLink(self, uri=None):
        """resolveLink(self, uri=None) -> PyObject *"""
        return _fitz.Document_resolveLink(self, uri)


    def layout(self, rect=None, width=0, height=0, fontsize=11):
        """layout(self, rect=None, width=0, height=0, fontsize=11) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        val = _fitz.Document_layout(self, rect, width, height, fontsize)

        self._reset_page_refs()
        self.initData()

        return val


    def makeBookmark(self, pno=0):
        """makeBookmark(self, pno=0) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_makeBookmark(self, pno)


    def findBookmark(self, bookmark):
        """findBookmark(self, bookmark) -> int"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_findBookmark(self, bookmark)

    @property

    def isReflowable(self):
        """isReflowable(self) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_isReflowable(self)


    def _deleteObject(self, xref):
        """Delete the object given by its xref"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__deleteObject(self, xref)


    def _getPDFroot(self):
        """PDF catalog xref number"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getPDFroot(self)

    @property

    def isPDF(self):
        """isPDF(self) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_isPDF(self)

    @property

    def isDirty(self):
        """isDirty(self) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_isDirty(self)


    def _getGCTXerrcode(self):
        """_getGCTXerrcode(self) -> int"""
        return _fitz.Document__getGCTXerrcode(self)


    def _getGCTXerrmsg(self):
        """_getGCTXerrmsg(self) -> char const *"""
        return _fitz.Document__getGCTXerrmsg(self)


    def authenticate(self, arg2):
        """Decrypt document with a password."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        val = _fitz.Document_authenticate(self, arg2)

        if val: # the doc is decrypted successfully and we init the outline
            self.isEncrypted = 0
            self.initData()
            self.thisown = True


        return val


    def save(self, filename, garbage=0, clean=0, deflate=0, incremental=0, ascii=0, expand=0, linear=0, pretty=0):
        """save(self, filename, garbage=0, clean=0, deflate=0, incremental=0, ascii=0, expand=0, linear=0, pretty=0) -> PyObject *"""

        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")
        if type(filename) == str:
            pass
        elif type(filename) == unicode:
            filename = filename.encode('utf8')
        else:
            raise TypeError("filename must be a string")
        if filename == self.name and not incremental:
            raise ValueError("save to original requires incremental")
        if incremental and (self.name != filename or self.streamlen > 0):
            raise ValueError("incremental save needs original file")


        return _fitz.Document_save(self, filename, garbage, clean, deflate, incremental, ascii, expand, linear, pretty)


    def write(self, garbage=0, clean=0, deflate=0, ascii=0, expand=0, linear=0, pretty=0):
        """Write document to a bytes object."""

        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_write(self, garbage, clean, deflate, ascii, expand, linear, pretty)


    def insertPDF(self, docsrc, from_page=-1, to_page=-1, start_at=-1, rotate=-1, links=1):
        """Copy page range ['from', 'to'] of source PDF, starting as page number 'start_at'."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")
        if id(self) == id(docsrc):
            raise ValueError("source must not equal target PDF")
        sa = start_at
        if sa < 0:
            sa = self.pageCount

        val = _fitz.Document_insertPDF(self, docsrc, from_page, to_page, start_at, rotate, links)
        self._reset_page_refs()
        if links:
            self._do_links(docsrc, from_page = from_page, to_page = to_page,
                           start_at = sa)

        return val


    def insertPage(self, pno=-1, text=None, fontsize=11, width=595, height=842, idx=0, fontname=None, fontfile=None, set_simple=0, color=None):
        """Insert a new page in front of 'pno'. Use arguments 'width', 'height' to specify a non-default page size, and optionally text insertion arguments."""

        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")
        if bool(text):
            CheckColor(color)
            if fontname and fontname[0] == "/":
                raise ValueError("invalid font reference")


        val = _fitz.Document_insertPage(self, pno, text, fontsize, width, height, idx, fontname, fontfile, set_simple, color)

        if val < 0: return val
        self._reset_page_refs()
        if not bool(text): return val
        page = self.loadPage(pno)
        val = page.insertText(Point(50, 72), text, fontsize = fontsize,
                              fontname = fontname, fontfile = fontfile,
                              color = color, idx = idx, set_simple = set_simple)


        return val


    def select(self, pyliste):
        """Build sub-pdf with page numbers in 'list'."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        val = _fitz.Document_select(self, pyliste)

        self._reset_page_refs()
        self.initData()

        return val

    @property

    def permissions(self):
        """Get permissions dictionary."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_permissions(self)


    def _getCharWidths(self, xref, limit, idx=0):
        """Return list of glyphs and glyph widths of a font."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document__getCharWidths(self, xref, limit, idx)


    def _getPageObjNumber(self, pno):
        """_getPageObjNumber(self, pno) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getPageObjNumber(self, pno)


    def _getPageInfo(self, pno, what):
        """Show fonts or images used on a page."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        val = _fitz.Document__getPageInfo(self, pno, what)

        x = []
        for v in val:
            if v not in x:
                x.append(v)
        val = x

        return val


    def extractFont(self, xref=0, info_only=0):
        """extractFont(self, xref=0, info_only=0) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_extractFont(self, xref, info_only)


    def extractImage(self, xref=0):
        """Extract image an xref points to."""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document_extractImage(self, xref)


    def _delToC(self):
        """_delToC(self) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        val = _fitz.Document__delToC(self)
        self.initData()

        return val

    @property

    def isFormPDF(self):
        """isFormPDF(self) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_isFormPDF(self)

    @property

    def FormFonts(self):
        """FormFonts(self) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_FormFonts(self)


    def _addFormFont(self, name, font):
        """_addFormFont(self, name, font) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document__addFormFont(self, name, font)


    def _getOLRootNumber(self):
        """_getOLRootNumber(self) -> int"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document__getOLRootNumber(self)


    def _getNewXref(self):
        """_getNewXref(self) -> int"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document__getNewXref(self)


    def _getXrefLength(self):
        """_getXrefLength(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getXrefLength(self)


    def _getXmlMetadataXref(self):
        """_getXmlMetadataXref(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getXmlMetadataXref(self)


    def _delXmlMetadata(self):
        """_delXmlMetadata(self) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document__delXmlMetadata(self)


    def _getObjectString(self, xref):
        """_getObjectString(self, xref) -> char const *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getObjectString(self, xref)

    _getXrefString = _getObjectString

    def _getXrefStream(self, xref):
        """_getXrefStream(self, xref) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document__getXrefStream(self, xref)


    def _updateObject(self, xref, text, page=None):
        """_updateObject(self, xref, text, page=None) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document__updateObject(self, xref, text, page)


    def _updateStream(self, xref=0, stream=None, new=0):
        """_updateStream(self, xref=0, stream=None, new=0) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document__updateStream(self, xref, stream, new)


    def _setMetadata(self, text):
        """_setMetadata(self, text) -> PyObject *"""
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")

        return _fitz.Document__setMetadata(self, text)


    def initData(self):
        if self.isEncrypted:
            raise ValueError("cannot initData - document still encrypted")
        self._outline = self._loadOutline()
        self.metadata = dict([(k,self._getMetadata(v)) for k,v in {'format':'format', 'title':'info:Title', 'author':'info:Author','subject':'info:Subject', 'keywords':'info:Keywords','creator':'info:Creator', 'producer':'info:Producer', 'creationDate':'info:CreationDate', 'modDate':'info:ModDate'}.items()])
        self.metadata['encryption'] = None if self._getMetadata('encryption')=='None' else self._getMetadata('encryption')

    outline = property(lambda self: self._outline)
    _getPageXref = _getPageObjNumber

    def getPageFontList(self, pno):
        """Retrieve a list of fonts used on a page.
        """
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")
        if self.isPDF:
            return self._getPageInfo(pno, 1)
        return []

    def getPageImageList(self, pno):
        """Retrieve a list of images used on a page.
        """
        if self.isClosed or self.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")
        if self.isPDF:
            return self._getPageInfo(pno, 2)
        return []

    def copyPage(self, pno, to=-1):
        """Copy a page to before some other page of the document. Specify 'to = -1' to copy after last page.
        """
        pl = list(range(len(self)))
        if pno < 0 or pno > pl[-1]:
            raise ValueError("'from' page number out of range")
        if to < -1 or to > pl[-1]:
            raise ValueError("'to' page number out of range")
        if to == -1:
            pl.append(pno)
        else:
            pl.insert(to, pno)
        return self.select(pl)

    def movePage(self, pno, to = -1):
        """Move a page to before some other page of the document. Specify 'to = -1' to move after last page.
        """
        pl = list(range(len(self)))
        if pno < 0 or pno > pl[-1]:
            raise ValueError("'from' page number out of range")
        if to < -1 or to > pl[-1]:
            raise ValueError("'to' page number out of range")
        pl.remove(pno)
        if to == -1:
            pl.append(pno)
        else:
            pl.insert(to-1, pno)
        return self.select(pl)

    def deletePage(self, pno = -1):
        """Delete a page from the document. First page is '0', last page is '-1'.
        """
        pl = list(range(len(self)))
        if pno < -1 or pno > pl[-1]:
            raise ValueError("page number out of range")
        if pno >= 0:
            pl.remove(pno)
        else:
            pl.remove(pl[-1])
        return self.select(pl)

    def deletePageRange(self, from_page = -1, to_page = -1):
        """Delete pages from the document. First page is '0', last page is '-1'.
        """
        pl = list(range(len(self)))
        f = from_page
        t = to_page
        if f == -1:
            f = pl[-1]
        if t == -1:
            t = pl[-1]
        if not 0 <= f <= t <= pl[-1]:
            raise ValueError("page number(s) out of range")
        for i in range(f, t+1):
            pl.remove(i)
        return self.select(pl)

    def saveIncr(self):
        """ Save PDF incrementally"""
        return self.save(self.name, incremental = True)

    def __repr__(self):
        m = "closed " if self.isClosed else ""
        if self.streamlen == 0:
            if self.name == "":
                return m + "fitz.Document(<new PDF>)"
            return m + "fitz.Document('%s')" % (self.name,)
        return m + "fitz.Document('%s', <memory>)" % (self.name,)

    def __getitem__(self, i=0):
        if type(i) is not int:
            raise ValueError("invalid page number(s)")
        if i >= len(self):
            raise IndexError("invalid page number(s)")
        return self.loadPage(i)

    def __len__(self):
        return self.pageCount

    def _forget_page(self, page):
        """Remove a page from document page dict."""
        pid = id(page)
        if pid in self._page_refs:
            self._page_refs[pid] = None

    def _reset_page_refs(self):
        """Invalidate all pages in document dictionary."""
        if self.isClosed:
            return
        for page in self._page_refs.values():
            if page:
                page._erase()
                page = None
        self._page_refs.clear()

    def __del__(self):
        if hasattr(self, "_reset_page_refs"):
            self._reset_page_refs()
        if hasattr(self, "Graftmaps"):
            for gmap in self.Graftmaps:
                self.Graftmaps[gmap] = None
        if hasattr(self, "this") and self.thisown:
            self.thisown = False
            self.__swig_destroy__(self)
        self.Graftmaps = {}
        self.stream    = None
        self._reset_page_refs = DUMMY
        self.__swig_destroy__ = DUMMY
        self.isClosed = True

Document_swigregister = _fitz.Document_swigregister
Document_swigregister(Document)

class Page(_object):
    """Proxy of C fz_page_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Page, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Page, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Page
    __del__ = lambda self: None

    def bound(self):
        """bound(self) -> Rect"""
        CheckParent(self)

        val = _fitz.Page_bound(self)

        if val:
            val.thisown = True


        return val

    rect = property(bound, doc="page rectangle")

    def run(self, dw, m):
        """run(self, dw, m) -> int"""
        CheckParent(self)

        return _fitz.Page_run(self, dw, m)


    def getSVGimage(self, matrix=None):
        """Create an SVG image from the page as a string."""
        CheckParent(self)

        return _fitz.Page_getSVGimage(self, matrix)


    def addLineAnnot(self, p1, p2):
        """Add 'Line' annot for points p1 and p2."""
        CheckParent(self)

        val = _fitz.Page_addLineAnnot(self, p1, p2)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        if val.type[0] == ANNOT_SQUARE:
            ap = _make_rect_AP(val)
        elif val.type[0] == ANNOT_CIRCLE:
            ap = _make_circle_AP(val)
        elif val.type[0] in (ANNOT_LINE, ANNOT_POLYLINE, ANNOT_POLYGON):
            ap = _make_line_AP(val)
        else:
            return val
        r = Rect(0, 0, val.rect.width, val.rect.height)
        val._checkAP(r, ap)


        return val


    def addTextAnnot(self, point, text):
        """Add a 'sticky note' at position 'point'."""
        CheckParent(self)

        val = _fitz.Page_addTextAnnot(self, point, text)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        return val


    def addFileAnnot(self, point, buffer, filename, ufilename=None, desc=None):
        """Add a 'FileAttachment' annotation."""
        CheckParent(self)

        val = _fitz.Page_addFileAnnot(self, point, buffer, filename, ufilename, desc)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        return val


    def addStrikeoutAnnot(self, rect):
        """Strike out content in a rectangle."""
        CheckParent(self)

        val = _fitz.Page_addStrikeoutAnnot(self, rect)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        return val


    def addUnderlineAnnot(self, rect):
        """Underline content in a rectangle."""
        CheckParent(self)

        val = _fitz.Page_addUnderlineAnnot(self, rect)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        return val


    def addHighlightAnnot(self, rect):
        """Highlight content in a rectangle."""
        CheckParent(self)

        val = _fitz.Page_addHighlightAnnot(self, rect)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        return val


    def addRectAnnot(self, rect):
        """Add a 'Rectangle' annotation."""
        CheckParent(self)

        val = _fitz.Page_addRectAnnot(self, rect)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        if val.type[0] == ANNOT_SQUARE:
            ap = _make_rect_AP(val)
        elif val.type[0] == ANNOT_CIRCLE:
            ap = _make_circle_AP(val)
        elif val.type[0] in (ANNOT_LINE, ANNOT_POLYLINE, ANNOT_POLYGON):
            ap = _make_line_AP(val)
        else:
            return val
        r = Rect(0, 0, val.rect.width, val.rect.height)
        val._checkAP(r, ap)


        return val


    def addCircleAnnot(self, rect):
        """Add a 'Circle' annotation."""
        CheckParent(self)

        val = _fitz.Page_addCircleAnnot(self, rect)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        if val.type[0] == ANNOT_SQUARE:
            ap = _make_rect_AP(val)
        elif val.type[0] == ANNOT_CIRCLE:
            ap = _make_circle_AP(val)
        elif val.type[0] in (ANNOT_LINE, ANNOT_POLYLINE, ANNOT_POLYGON):
            ap = _make_line_AP(val)
        else:
            return val
        r = Rect(0, 0, val.rect.width, val.rect.height)
        val._checkAP(r, ap)


        return val


    def addPolylineAnnot(self, points):
        """Add a 'Polyline' annotation for a sequence of points."""
        CheckParent(self)

        val = _fitz.Page_addPolylineAnnot(self, points)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        if val.type[0] == ANNOT_SQUARE:
            ap = _make_rect_AP(val)
        elif val.type[0] == ANNOT_CIRCLE:
            ap = _make_circle_AP(val)
        elif val.type[0] in (ANNOT_LINE, ANNOT_POLYLINE, ANNOT_POLYGON):
            ap = _make_line_AP(val)
        else:
            return val
        r = Rect(0, 0, val.rect.width, val.rect.height)
        val._checkAP(r, ap)


        return val


    def addPolygonAnnot(self, points):
        """Add a 'Polygon' annotation for a sequence of points."""
        CheckParent(self)

        val = _fitz.Page_addPolygonAnnot(self, points)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        if val.type[0] == ANNOT_SQUARE:
            ap = _make_rect_AP(val)
        elif val.type[0] == ANNOT_CIRCLE:
            ap = _make_circle_AP(val)
        elif val.type[0] in (ANNOT_LINE, ANNOT_POLYLINE, ANNOT_POLYGON):
            ap = _make_line_AP(val)
        else:
            return val
        r = Rect(0, 0, val.rect.width, val.rect.height)
        val._checkAP(r, ap)


        return val


    def addFreetextAnnot(self, pos, text, fontsize=11, color=None):
        """Add a 'FreeText' annotation at position 'point'."""
        CheckParent(self)

        val = _fitz.Page_addFreetextAnnot(self, pos, text, fontsize, color)

        if not val: return
        val.thisown = True
        val.parent = weakref.proxy(self)
        self._annot_refs[id(val)] = val

        return val


                #---------------------------------------------------------------------
                # page addWidget
                #---------------------------------------------------------------------
    def addWidget(self, widget):
        """Add a form field.
        """
        CheckParent(self)
        doc = self.parent
        if not doc.isPDF:
            raise ValueError("not a PDF")
        widget._validate()

    # Check if PDF already has our fonts.
    # If none insert all of them in a new object and store the xref.
    # Else only add any missing fonts.
    # To determine the situation, /DR object is checked.
        xref = 0
        ff = doc.FormFonts               # /DR object: existing fonts
        if not widget.text_font:         # ensure default
            widget.text_font = "Helv"
        if not widget.text_font in ff:   # if no existent font ...
            if not doc.isFormPDF or not ff:   # a fresh /AcroForm PDF!
                xref = doc._getNewXref()      # insert all our fonts
                doc._updateObject(xref, Widget_fontobjects)
            else:                        # add any missing fonts
                for k in Widget_fontdict.keys():
                    if not k in ff:      # add our font if missing
                        doc._addFormFont(k, Widget_fontdict[k])
            widget._adjust_font()        # ensure correct font spelling
        widget._dr_xref = xref           # non-zero causes /DR creation

    # now create the /DA string
        if   len(widget.text_color) == 3:
            fmt = "{:g} {:g} {:g} rg /{f:s} {s:g} Tf " + widget._text_da
        elif len(widget.text_color) == 1:
            fmt = "{:g} g /{f:s} {s:g} Tf " + widget._text_da
        elif len(widget.text_color) == 4:
            fmt = "{:g} {:g} {:g} {:g} k /{f:s} {s:g} Tf " + widget._text_da
        widget._text_da = fmt.format(*widget.text_color, f=widget.text_font,
                                     s=widget.text_fontsize)
    # create the widget at last
        annot = self._addWidget(widget)
        if annot:
            annot.thisown = True
            annot.parent = weakref.proxy(self) # owning page object
            self._annot_refs[id(annot)] = annot
        return annot


    def _addWidget(self, Widget):
        """_addWidget(self, Widget) -> Annot"""
        return _fitz.Page__addWidget(self, Widget)


    def getDisplayList(self):
        """getDisplayList(self) -> DisplayList"""
        CheckParent(self)

        return _fitz.Page_getDisplayList(self)


    def setCropBox(self, rect=None):
        """setCropBox(self, rect=None) -> PyObject *"""
        CheckParent(self)

        return _fitz.Page_setCropBox(self, rect)


    def loadLinks(self):
        """loadLinks(self) -> Link"""
        CheckParent(self)

        val = _fitz.Page_loadLinks(self)
        if val:
            val.thisown = True
            val.parent = weakref.proxy(self) # owning page object
            self._annot_refs[id(val)] = val

        return val

    firstLink = property(loadLinks)
    @property

    def firstAnnot(self):
        """Points to first annotation on page"""
        CheckParent(self)

        val = _fitz.Page_firstAnnot(self)
        if val:
            val.thisown = True
            val.parent = weakref.proxy(self) # owning page object
            self._annot_refs[id(val)] = val

        return val


    def deleteLink(self, linkdict):
        """Delete link if PDF"""
        CheckParent(self)

        val = _fitz.Page_deleteLink(self, linkdict)
        if linkdict["xref"] == 0: return
        linkid = linkdict["id"]
        try:
            linkobj = self._annot_refs[linkid]
            linkobj._erase()
        except:
            pass


        return val


    def deleteAnnot(self, fannot):
        """Delete annot if PDF and return next one"""
        CheckParent(self)

        val = _fitz.Page_deleteAnnot(self, fannot)
        if val:
            val.thisown = True
            val.parent = weakref.proxy(self) # owning page object
            val.parent._annot_refs[id(val)] = val
        fannot._erase()


        return val

    @property

    def MediaBoxSize(self):
        """Retrieve width, height of /MediaBox."""
        CheckParent(self)

        val = _fitz.Page_MediaBoxSize(self)

        if val == Point(0,0):
            r = self.rect
            val = Point(r.width, r.height)


        return val

    @property

    def CropBoxPosition(self):
        """Retrieve position of /CropBox. Return (0,0) for non-PDF, or no /CropBox."""
        CheckParent(self)

        return _fitz.Page_CropBoxPosition(self)

    @property

    def rotation(self):
        """Retrieve page rotation."""
        CheckParent(self)

        return _fitz.Page_rotation(self)


    def setRotation(self, rot):
        """Set page rotation to 'rot' degrees."""
        CheckParent(self)

        return _fitz.Page_setRotation(self, rot)


    def _addAnnot_FromString(self, linklist):
        """_addAnnot_FromString(self, linklist) -> PyObject *"""
        CheckParent(self)

        return _fitz.Page__addAnnot_FromString(self, linklist)


    def _getLinkXrefs(self):
        """_getLinkXrefs(self) -> PyObject *"""
        return _fitz.Page__getLinkXrefs(self)


    def _cleanContents(self):
        """_cleanContents(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Page__cleanContents(self)


    def _showPDFpage(self, rect, docsrc, pno=0, overlay=1, keep_proportion=1, reuse_xref=0, clip=None, graftmap=None, _imgname=None):
        """_showPDFpage(self, rect, docsrc, pno=0, overlay=1, keep_proportion=1, reuse_xref=0, clip=None, graftmap=None, _imgname=None) -> int"""
        return _fitz.Page__showPDFpage(self, rect, docsrc, pno, overlay, keep_proportion, reuse_xref, clip, graftmap, _imgname)


    def insertImage(self, rect, filename=None, pixmap=None, stream=None, overlay=1, _imgname=None):
        """Insert a new image into a rectangle."""

        CheckParent(self)
        imglst = self.parent.getPageImageList(self.number)
        ilst = [i[7] for i in imglst]
        n = "fzImg"
        i = 0
        _imgname = n + "0"
        while _imgname in ilst:
            i += 1
            _imgname = n + str(i)

        return _fitz.Page_insertImage(self, rect, filename, pixmap, stream, overlay, _imgname)


    def insertFont(self, fontname=None, fontfile=None, fontbuffer=None, xref=0, set_simple=0, idx=0):
        """insertFont(self, fontname=None, fontfile=None, fontbuffer=None, xref=0, set_simple=0, idx=0) -> PyObject *"""

        if not self.parent:
            raise ValueError("orphaned object: parent is None")
        f = CheckFont(self, fontname)
        if f is not None:         # drop out if fontname already in page list
            return f[0]
        if not fontname:
            fontname = "Helvetica"
        if xref > 0:
            _, _, _, fontbuffer = self.parent.extractFont(xref)
            if not fontbuffer:
                raise ValueError("xref is no valid font")


        val = _fitz.Page_insertFont(self, fontname, fontfile, fontbuffer, xref, set_simple, idx)

        if val:
            xref = val[0]
            f = CheckFont(self, fontname)
            if f is not None:
                val[1]["type"] = f[2]       # put /Subtype in font info
                val[1]["glyphs"] = None
            doc = self.parent               # now add to document font info
            fi = CheckFontInfo(doc, xref)
            if fi is None:                  # look if we are already present
                doc.FontInfos.append(val)   # no: add me to document object
            return xref


        return val


    def _getContents(self):
        """_getContents(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Page__getContents(self)


    def _setContents(self, xref=0):
        """Set the /Contents object in page definition"""
        CheckParent(self)

        return _fitz.Page__setContents(self, xref)


    def __str__(self):
        CheckParent(self)
        x = self.parent.name
        if self.parent.streamlen > 0:
            x += " (memory)"
        if x == "":
            x = "<new PDF>"
        return "page %s of %s" % (self.number, x)

    def __repr__(self):
        CheckParent(self)
        x = self.parent.name
        if self.parent.streamlen > 0:
            x += " (memory)"
        if x == "":
            x = "<new PDF>"
        return "page %s of %s" % (self.number, x)

    def _forget_annot(self, annot):
        """Remove an annot from reference dictionary."""
        aid = id(annot)
        if aid in self._annot_refs:
            self._annot_refs[aid] = None

    def _reset_annot_refs(self):
        """Invalidate / delete all annots of this page."""
        for annot in self._annot_refs.values():
            if annot:
                annot._erase()
        self._annot_refs.clear()

    def _getXref(self):
        """Return PDF XREF number of page."""
        CheckParent(self)
        return self.parent._getPageXref(self.number)[0]

    def _erase(self):
        self._reset_annot_refs()
        try:
            self.parent._forget_page(self)
        except:
            pass
        if getattr(self, "thisown", True):
            self.__swig_destroy__(self)
        self.parent = None
        self.thisown = False
        self.number = None

    def __del__(self):
        self._erase()

    def getFontList(self):
        CheckParent(self)
        return self.parent.getPageFontList(self.number)

    def getImageList(self):
        CheckParent(self)
        return self.parent.getPageImageList(self.number)

    @property
    def CropBox(self):
        x0 = self.CropBoxPosition.x
        y0 = self.MediaBoxSize.y - self.CropBoxPosition.y - self.rect.height
        x1 = x0 + self.rect.width
        y1 = y0 + self.rect.height
        return Rect(x0, y0, x1, y1)

    @property
    def MediaBox(self):
        return Rect(0, 0, self.MediaBoxSize)


Page_swigregister = _fitz.Page_swigregister
Page_swigregister(Page)


def _fz_transform_rect(rect, transform):
    """_fz_transform_rect(rect, transform) -> Rect"""
    return _fitz._fz_transform_rect(rect, transform)
class Rect(_object):
    """Rect() - all zeros
Rect(x0, y0, x1, y1)
Rect(top-left, x1, y1)
Rect(x0, y0, bottom-right)
Rect(top-left, bottom-right)
Rect(Rect or IRect) - new copy
Rect(sequence) - from 'sequence'"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Rect, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Rect, name)
    __repr__ = _swig_repr
    __swig_setmethods__["x0"] = _fitz.Rect_x0_set
    __swig_getmethods__["x0"] = _fitz.Rect_x0_get
    if _newclass:
        x0 = _swig_property(_fitz.Rect_x0_get, _fitz.Rect_x0_set)
    __swig_setmethods__["y0"] = _fitz.Rect_y0_set
    __swig_getmethods__["y0"] = _fitz.Rect_y0_get
    if _newclass:
        y0 = _swig_property(_fitz.Rect_y0_get, _fitz.Rect_y0_set)
    __swig_setmethods__["x1"] = _fitz.Rect_x1_set
    __swig_getmethods__["x1"] = _fitz.Rect_x1_get
    if _newclass:
        x1 = _swig_property(_fitz.Rect_x1_get, _fitz.Rect_x1_set)
    __swig_setmethods__["y1"] = _fitz.Rect_y1_set
    __swig_getmethods__["y1"] = _fitz.Rect_y1_get
    if _newclass:
        y1 = _swig_property(_fitz.Rect_y1_get, _fitz.Rect_y1_set)
    __swig_destroy__ = _fitz.delete_Rect
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(self) -> Rect
        __init__(self, s) -> Rect
        __init__(self, lt, rb) -> Rect
        __init__(self, x0, y0, rb) -> Rect
        __init__(self, lt, x1, y1) -> Rect
        __init__(self, x0, y0, x1, y1) -> Rect
        __init__(self, list) -> Rect
        """
        this = _fitz.new_Rect(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def round(self):
        """Create enclosing 'IRect'"""
        val = _fitz.Rect_round(self)
        val.thisown = True

        return val


    def includePoint(self, p):
        """Enlarge to include a 'Point' p"""
        return _fitz.Rect_includePoint(self, p)


    def intersect(self, r):
        """Shrink to intersection with another 'Rect' r"""
        return _fitz.Rect_intersect(self, r)


    def includeRect(self, r):
        """Enlarge to include another 'Rect' r"""
        return _fitz.Rect_includeRect(self, r)


    def normalize(self):
        """Make rectangle finite"""
        return _fitz.Rect_normalize(self)


    def contains(self, *args):
        """Check if containing a 'Point' or another rect"""
        return _fitz.Rect_contains(self, *args)

    @property

    def isEmpty(self):
        """isEmpty(self) -> PyObject *"""
        return _fitz.Rect_isEmpty(self)

    @property

    def isInfinite(self):
        """isInfinite(self) -> PyObject *"""
        return _fitz.Rect_isInfinite(self)


    def transform(self, m):
        """Transform rectangle with Matrix m."""
        _fitz._fz_transform_rect(self, m)
        return self

    @property
    def top_left(self):
        """Return the rectangle's top-left point."""
        return Point(self.x0, self.y0)

    @property
    def top_right(self):
        """Return the rectangle's top-right point."""
        return Point(self.x1, self.y0)

    @property
    def bottom_left(self):
        """Return the rectangle's bottom-left point."""
        return Point(self.x0, self.y1)

    @property
    def bottom_right(self):
        """Return the rectangle's bottom-right point."""
        return Point(self.x1, self.y1)

    def __getitem__(self, i):
        return (self.x0, self.y0, self.x1, self.y1)[i]

    def __setitem__(self, i, v):
        if   i == 0: self.x0 = v
        elif i == 1: self.y0 = v
        elif i == 2: self.x1 = v
        elif i == 3: self.y1 = v
        else:
            raise IndexError("index out of range")
        return

    def __len__(self):
        return 4

    def __repr__(self):
        return "fitz.Rect" + str((self.x0, self.y0, self.x1, self.y1))

    irect = property(round)
    width = property(lambda self: self.x1-self.x0)
    height = property(lambda self: self.y1-self.y0)
    tl = top_left
    tr = top_right
    br = bottom_right
    bl = bottom_left

Rect_swigregister = _fitz.Rect_swigregister
Rect_swigregister(Rect)

class IRect(_object):
    """IRect() - all zeros
IRect(x0, y0, x1, y1)
IRect(Rect or IRect) - new copy
IRect(sequence) - from 'sequence'"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IRect, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IRect, name)
    __repr__ = _swig_repr
    __swig_setmethods__["x0"] = _fitz.IRect_x0_set
    __swig_getmethods__["x0"] = _fitz.IRect_x0_get
    if _newclass:
        x0 = _swig_property(_fitz.IRect_x0_get, _fitz.IRect_x0_set)
    __swig_setmethods__["y0"] = _fitz.IRect_y0_set
    __swig_getmethods__["y0"] = _fitz.IRect_y0_get
    if _newclass:
        y0 = _swig_property(_fitz.IRect_y0_get, _fitz.IRect_y0_set)
    __swig_setmethods__["x1"] = _fitz.IRect_x1_set
    __swig_getmethods__["x1"] = _fitz.IRect_x1_get
    if _newclass:
        x1 = _swig_property(_fitz.IRect_x1_get, _fitz.IRect_x1_set)
    __swig_setmethods__["y1"] = _fitz.IRect_y1_set
    __swig_getmethods__["y1"] = _fitz.IRect_y1_get
    if _newclass:
        y1 = _swig_property(_fitz.IRect_y1_get, _fitz.IRect_y1_set)
    __swig_destroy__ = _fitz.delete_IRect
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(self) -> IRect
        __init__(self, s) -> IRect
        __init__(self, x0, y0, x1, y1) -> IRect
        __init__(self, list) -> IRect
        """
        this = _fitz.new_IRect(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    @property

    def isEmpty(self):
        """isEmpty(self) -> PyObject *"""
        return _fitz.IRect_isEmpty(self)

    @property

    def isInfinite(self):
        """isInfinite(self) -> PyObject *"""
        return _fitz.IRect_isInfinite(self)


    def normalize(self):
        """Make rectangle finite"""
        return _fitz.IRect_normalize(self)


    def contains(self, *args):
        """Check if containing a 'Point' or another rect"""
        return _fitz.IRect_contains(self, *args)


    def translate(self, xoff, yoff):
        """translate(self, xoff, yoff) -> IRect"""
        return _fitz.IRect_translate(self, xoff, yoff)


    def intersect(self, ir):
        """intersect(self, ir) -> IRect"""
        return _fitz.IRect_intersect(self, ir)


    def getRect(self):
        return Rect(self.x0, self.y0, self.x1, self.y1)

    rect = property(getRect)

    @property
    def top_left(self):
        return Point(self.x0, self.y0)

    @property
    def top_right(self):
        return Point(self.x1, self.y0)

    @property
    def bottom_left(self):
        return Point(self.x0, self.y1)

    @property
    def bottom_right(self):
        return Point(self.x1, self.y1)

    def __getitem__(self, i):
        return (self.x0, self.y0, self.x1, self.y1)[i]

    def __setitem__(self, i, v):
        if   i == 0: self.x0 = v
        elif i == 1: self.y0 = v
        elif i == 2: self.x1 = v
        elif i == 3: self.y1 = v
        else:
            raise IndexError("index out of range")
        return

    def __len__(self):
        return 4

    def __repr__(self):
        if not type(self) is IRect: return
        return "fitz.IRect" + str((self.x0, self.y0, self.x1, self.y1))

    width = property(lambda self: self.x1-self.x0)
    height = property(lambda self: self.y1-self.y0)
    tl = top_left
    tr = top_right
    br = bottom_right
    bl = bottom_left


IRect_swigregister = _fitz.IRect_swigregister
IRect_swigregister(IRect)

class Pixmap(_object):
    """Pixmap(Colorspace, width, height, samples, alpha)
Pixmap(Colorspace, Irect, alpha)
Pixmap(Colorspace, Pixmap) - converted copy
Pixmap(filename)
Pixmap(Pixmap, alpha) - copy & add / drop alpha
Pixmap(bytearray)
Pixmap(Document, xref) - from a PDF image"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Pixmap, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Pixmap, name)
    __repr__ = _swig_repr
    __swig_setmethods__["x"] = _fitz.Pixmap_x_set
    __swig_getmethods__["x"] = _fitz.Pixmap_x_get
    if _newclass:
        x = _swig_property(_fitz.Pixmap_x_get, _fitz.Pixmap_x_set)
    __swig_setmethods__["y"] = _fitz.Pixmap_y_set
    __swig_getmethods__["y"] = _fitz.Pixmap_y_get
    if _newclass:
        y = _swig_property(_fitz.Pixmap_y_get, _fitz.Pixmap_y_set)
    __swig_setmethods__["w"] = _fitz.Pixmap_w_set
    __swig_getmethods__["w"] = _fitz.Pixmap_w_get
    if _newclass:
        w = _swig_property(_fitz.Pixmap_w_get, _fitz.Pixmap_w_set)
    __swig_setmethods__["h"] = _fitz.Pixmap_h_set
    __swig_getmethods__["h"] = _fitz.Pixmap_h_get
    if _newclass:
        h = _swig_property(_fitz.Pixmap_h_get, _fitz.Pixmap_h_set)
    __swig_setmethods__["n"] = _fitz.Pixmap_n_set
    __swig_getmethods__["n"] = _fitz.Pixmap_n_get
    if _newclass:
        n = _swig_property(_fitz.Pixmap_n_get, _fitz.Pixmap_n_set)
    __swig_setmethods__["xres"] = _fitz.Pixmap_xres_set
    __swig_getmethods__["xres"] = _fitz.Pixmap_xres_get
    if _newclass:
        xres = _swig_property(_fitz.Pixmap_xres_get, _fitz.Pixmap_xres_set)
    __swig_setmethods__["yres"] = _fitz.Pixmap_yres_set
    __swig_getmethods__["yres"] = _fitz.Pixmap_yres_get
    if _newclass:
        yres = _swig_property(_fitz.Pixmap_yres_get, _fitz.Pixmap_yres_set)
    __swig_destroy__ = _fitz.delete_Pixmap
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(self, cs, bbox, alpha=0) -> Pixmap
        __init__(self, cs, spix) -> Pixmap
        __init__(self, spix, w, h, clip=None) -> Pixmap
        __init__(self, spix, alpha=1) -> Pixmap
        __init__(self, cs, w, h, samples, alpha=0) -> Pixmap
        __init__(self, filename) -> Pixmap
        __init__(self, imagedata) -> Pixmap
        __init__(self, doc, xref) -> Pixmap
        """
        this = _fitz.new_Pixmap(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def shrink(self, factor):
        """shrink(self, factor)"""
        return _fitz.Pixmap_shrink(self, factor)


    def gammaWith(self, gamma):
        """gammaWith(self, gamma)"""
        return _fitz.Pixmap_gammaWith(self, gamma)


    def tintWith(self, red, green, blue):
        """tintWith(self, red, green, blue)"""

        if not self.colorspace or self.colorspace.n > 3:
            print("warning: colorspace invalid for function")
            return

        return _fitz.Pixmap_tintWith(self, red, green, blue)


    def clearWith(self, *args):
        """
        clearWith(self)
        clearWith(self, value)
        clearWith(self, value, bbox)
        """
        return _fitz.Pixmap_clearWith(self, *args)


    def copyPixmap(self, src, bbox):
        """copyPixmap(self, src, bbox) -> PyObject *"""
        return _fitz.Pixmap_copyPixmap(self, src, bbox)

    @property

    def stride(self):
        """stride(self) -> int"""
        return _fitz.Pixmap_stride(self)

    @property

    def alpha(self):
        """alpha(self) -> int"""
        return _fitz.Pixmap_alpha(self)

    @property

    def colorspace(self):
        """colorspace(self) -> Colorspace"""
        return _fitz.Pixmap_colorspace(self)

    @property

    def irect(self):
        """irect(self) -> IRect"""
        return _fitz.Pixmap_irect(self)

    @property

    def size(self):
        """size(self) -> int"""
        return _fitz.Pixmap_size(self)


    def setAlpha(self, alphavalues=None):
        """setAlpha(self, alphavalues=None) -> PyObject *"""
        return _fitz.Pixmap_setAlpha(self, alphavalues)


    def getPNGData(self, savealpha=-1):
        """getPNGData(self, savealpha=-1) -> PyObject *"""
        return _fitz.Pixmap_getPNGData(self, savealpha)


    def _writeIMG(self, filename, format, savealpha=-1):
        """_writeIMG(self, filename, format, savealpha=-1) -> PyObject *"""
        return _fitz.Pixmap__writeIMG(self, filename, format, savealpha)


    def writePNG(self, filename, savealpha = -1):
        return self._writeIMG(filename, 1, savealpha)


    def invertIRect(self, irect=None):
        """invertIRect(self, irect=None)"""
        return _fitz.Pixmap_invertIRect(self, irect)

    @property

    def samples(self):
        """samples(self) -> PyObject *"""
        return _fitz.Pixmap_samples(self)


    width  = w
    height = h

    def __len__(self):
        return self.size

    def __repr__(self):
        if not type(self) is Pixmap: return
        if self.colorspace:
            return "fitz.Pixmap(%s, %s, %s)" % (self.colorspace.name, self.irect, self.alpha)
        else:
            return "fitz.Pixmap(%s, %s, %s)" % ('None', self.irect, self.alpha)

    def __del__(self):
        if not type(self) is Pixmap: return
        self.__swig_destroy__(self)

Pixmap_swigregister = _fitz.Pixmap_swigregister
Pixmap_swigregister(Pixmap)

CS_RGB = _fitz.CS_RGB
CS_GRAY = _fitz.CS_GRAY
CS_CMYK = _fitz.CS_CMYK
class Colorspace(_object):
    """Proxy of C fz_colorspace_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Colorspace, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Colorspace, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Colorspace
    __del__ = lambda self: None

    def __init__(self, type):
        """__init__(self, type) -> Colorspace"""
        this = _fitz.new_Colorspace(type)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    @property

    def n(self):
        """n(self) -> int"""
        return _fitz.Colorspace_n(self)


    def _name(self):
        """_name(self) -> char const *"""
        return _fitz.Colorspace__name(self)


    @property
    def name(self):
        if self.n == 1:
            return csGRAY._name()
        elif self.n == 3:
            return csRGB._name()
        elif self.n == 4:
            return csCMYK._name()
        return self._name()

    def __repr__(self):
        x = ("", "GRAY", "", "RGB", "CMYK")[self.n]
        return "fitz.Colorspace(fitz.CS_%s) - %s" % (x, self.name)

Colorspace_swigregister = _fitz.Colorspace_swigregister
Colorspace_swigregister(Colorspace)

class Device(_object):
    """Proxy of C DeviceWrapper struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Device, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Device, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, pm, clip) -> Device
        __init__(self, dl) -> Device
        __init__(self, tp, flags=0) -> Device
        """
        this = _fitz.new_Device(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fitz.delete_Device
    __del__ = lambda self: None
Device_swigregister = _fitz.Device_swigregister
Device_swigregister(Device)


def _fz_pre_scale(m, sx, sy):
    """_fz_pre_scale(m, sx, sy) -> Matrix"""
    return _fitz._fz_pre_scale(m, sx, sy)

def _fz_pre_shear(m, sx, sy):
    """_fz_pre_shear(m, sx, sy) -> Matrix"""
    return _fitz._fz_pre_shear(m, sx, sy)

def _fz_pre_rotate(m, degree):
    """_fz_pre_rotate(m, degree) -> Matrix"""
    return _fitz._fz_pre_rotate(m, degree)
class Matrix(_object):
    """Matrix() - all zeros
Matrix(a, b, c, d, e, f)
Matrix(zoom-x, zoom-y) - zoom
Matrix(shear-x, shear-y, 1) - shear
Matrix(degree) - rotate
Matrix(Matrix) - new copy
Matrix(sequence) - from 'sequence'"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Matrix, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Matrix, name)
    __repr__ = _swig_repr
    __swig_setmethods__["a"] = _fitz.Matrix_a_set
    __swig_getmethods__["a"] = _fitz.Matrix_a_get
    if _newclass:
        a = _swig_property(_fitz.Matrix_a_get, _fitz.Matrix_a_set)
    __swig_setmethods__["b"] = _fitz.Matrix_b_set
    __swig_getmethods__["b"] = _fitz.Matrix_b_get
    if _newclass:
        b = _swig_property(_fitz.Matrix_b_get, _fitz.Matrix_b_set)
    __swig_setmethods__["c"] = _fitz.Matrix_c_set
    __swig_getmethods__["c"] = _fitz.Matrix_c_get
    if _newclass:
        c = _swig_property(_fitz.Matrix_c_get, _fitz.Matrix_c_set)
    __swig_setmethods__["d"] = _fitz.Matrix_d_set
    __swig_getmethods__["d"] = _fitz.Matrix_d_get
    if _newclass:
        d = _swig_property(_fitz.Matrix_d_get, _fitz.Matrix_d_set)
    __swig_setmethods__["e"] = _fitz.Matrix_e_set
    __swig_getmethods__["e"] = _fitz.Matrix_e_get
    if _newclass:
        e = _swig_property(_fitz.Matrix_e_get, _fitz.Matrix_e_set)
    __swig_setmethods__["f"] = _fitz.Matrix_f_set
    __swig_getmethods__["f"] = _fitz.Matrix_f_get
    if _newclass:
        f = _swig_property(_fitz.Matrix_f_get, _fitz.Matrix_f_set)
    __swig_destroy__ = _fitz.delete_Matrix
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(self) -> Matrix
        __init__(self, n) -> Matrix
        __init__(self, sx, sy, shear=0) -> Matrix
        __init__(self, r, s, t, u, v, w) -> Matrix
        __init__(self, degree) -> Matrix
        __init__(self, list) -> Matrix
        """
        this = _fitz.new_Matrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def invert(self, m):
        """invert(self, m) -> int"""
        return _fitz.Matrix_invert(self, m)


    def preTranslate(self, sx, sy):
        """preTranslate(self, sx, sy) -> Matrix"""
        return _fitz.Matrix_preTranslate(self, sx, sy)


    def concat(self, m1, m2):
        """concat(self, m1, m2) -> Matrix"""
        return _fitz.Matrix_concat(self, m1, m2)


    def preScale(self, sx, sy):
        """preScale(Matrix self, float sx, float sy) -> Matrix self updated"""
        _fitz._fz_pre_scale(self, sx, sy)
        return self
    def preShear(self, sx, sy):
        """preShear(Matrix self, float sx, float sy) -> Matrix self updated"""
        _fitz._fz_pre_shear(self, sx, sy)
        return self
    def preRotate(self, degree):
        """preRotate(Matrix self, float degree) -> Matrix self updated"""
        _fitz._fz_pre_rotate(self, degree)
        return self
    def __getitem__(self, i):
        return (self.a, self.b, self.c, self.d, self.e, self.f)[i]

    def __setitem__(self, i, v):
        if   i == 0: self.a = v
        elif i == 1: self.b = v
        elif i == 2: self.c = v
        elif i == 3: self.d = v
        elif i == 4: self.e = v
        elif i == 5: self.f = v
        else:
            raise IndexError("index out of range")
        return

    def __len__(self):
        return 6
    def __repr__(self):
        return "fitz.Matrix(%s, %s, %s, %s, %s, %s)" % (self.a, self.b, self.c, self.d, self.e, self.f)


Matrix_swigregister = _fitz.Matrix_swigregister
Matrix_swigregister(Matrix)

class Outline(_object):
    """Proxy of C fz_outline_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Outline, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Outline, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["title"] = _fitz.Outline_title_get
    if _newclass:
        title = _swig_property(_fitz.Outline_title_get)
    __swig_getmethods__["page"] = _fitz.Outline_page_get
    if _newclass:
        page = _swig_property(_fitz.Outline_page_get)
    __swig_getmethods__["next"] = _fitz.Outline_next_get
    if _newclass:
        next = _swig_property(_fitz.Outline_next_get)
    __swig_getmethods__["down"] = _fitz.Outline_down_get
    if _newclass:
        down = _swig_property(_fitz.Outline_down_get)
    __swig_getmethods__["is_open"] = _fitz.Outline_is_open_get
    if _newclass:
        is_open = _swig_property(_fitz.Outline_is_open_get)
    @property

    def uri(self):
        """uri(self) -> char *"""
        val = _fitz.Outline_uri(self)

        if not val:
            return ""

        nval = "".join([c for c in val if 32 <= ord(c) <= 127])
        val = nval


        return val

    @property

    def isExternal(self):
        """isExternal(self) -> int"""
        return _fitz.Outline_isExternal(self)

    isOpen = is_open

    @property
    def dest(self):
        '''outline destination details'''
        return linkDest(self, None)

    __swig_destroy__ = _fitz.delete_Outline
    __del__ = lambda self: None
Outline_swigregister = _fitz.Outline_swigregister
Outline_swigregister(Outline)


def _fz_transform_point(point, transform):
    """_fz_transform_point(point, transform) -> Point"""
    return _fitz._fz_transform_point(point, transform)
class Point(_object):
    """Point() - all zeros
Point(x, y)
Point(Point) - new copy
Point(sequence) - from 'sequence'"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Point, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Point, name)
    __repr__ = _swig_repr
    __swig_setmethods__["x"] = _fitz.Point_x_set
    __swig_getmethods__["x"] = _fitz.Point_x_get
    if _newclass:
        x = _swig_property(_fitz.Point_x_get, _fitz.Point_x_set)
    __swig_setmethods__["y"] = _fitz.Point_y_set
    __swig_getmethods__["y"] = _fitz.Point_y_get
    if _newclass:
        y = _swig_property(_fitz.Point_y_get, _fitz.Point_y_set)

    def __init__(self, *args):
        """
        __init__(self) -> Point
        __init__(self, q) -> Point
        __init__(self, x, y) -> Point
        __init__(self, list) -> Point
        """
        this = _fitz.new_Point(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def distance_to(self, *args):
        """Return the distance to a rectangle or another point."""
        assert len(args) > 0, "at least one parameter must be given"
        x = args[0]
        if len(args) > 1:
            unit = args[1]
        else:
            unit = "px"
        u = {"px": (1.,1.), "in": (1.,72.), "cm": (2.54, 72.), "mm": (25.4, 72.)}
        f = u[unit][0] / u[unit][1]
        if type(x) is Point:
            return abs(self - x) * f

    # from here on, x is a rectangle
    # as a safeguard, make a finite copy of it
        r = Rect(x.top_left, x.top_left)
        r = r | x.bottom_right
        if self in r:
            return 0.0
        if self.x > r.x1:
            if self.y >= r.y1:
                return self.distance_to(r.bottom_right, unit)
            elif self.y <= r.y0:
                return self.distance_to(r.top_right, unit)
            else:
                return (self.x - r.x1) * f
        elif r.x0 <= self.x <= r.x1:
            if self.y >= r.y1:
                return (self.y - r.y1) * f
            else:
                return (r.y0 - self.y) * f
        else:
            if self.y >= r.y1:
                return self.distance_to(r.bottom_left, unit)
            elif self.y <= r.y0:
                return self.distance_to(r.top_left, unit)
            else:
                return (r.x0 - self.x) * f

    def transform(self, m):
        _fitz._fz_transform_point(self, m)
        return self

    def __setitem__(self, i, v):
        if i == 0:
            self.x = v
        elif i == 1:
            self.y = v
        else:
            raise IndexError("index out of range")
        return

    def __getitem__(self, i):
        return (self.x, self.y)[i]

    def __len__(self):
        return 2

    def __repr__(self):
        return "fitz.Point" + str((self.x, self.y))

    __swig_destroy__ = _fitz.delete_Point
    __del__ = lambda self: None
Point_swigregister = _fitz.Point_swigregister
Point_swigregister(Point)

ANNOT_TEXT = _fitz.ANNOT_TEXT
ANNOT_LINK = _fitz.ANNOT_LINK
ANNOT_FREETEXT = _fitz.ANNOT_FREETEXT
ANNOT_LINE = _fitz.ANNOT_LINE
ANNOT_SQUARE = _fitz.ANNOT_SQUARE
ANNOT_CIRCLE = _fitz.ANNOT_CIRCLE
ANNOT_POLYGON = _fitz.ANNOT_POLYGON
ANNOT_POLYLINE = _fitz.ANNOT_POLYLINE
ANNOT_HIGHLIGHT = _fitz.ANNOT_HIGHLIGHT
ANNOT_UNDERLINE = _fitz.ANNOT_UNDERLINE
ANNOT_SQUIGGLY = _fitz.ANNOT_SQUIGGLY
ANNOT_STRIKEOUT = _fitz.ANNOT_STRIKEOUT
ANNOT_STAMP = _fitz.ANNOT_STAMP
ANNOT_CARET = _fitz.ANNOT_CARET
ANNOT_INK = _fitz.ANNOT_INK
ANNOT_POPUP = _fitz.ANNOT_POPUP
ANNOT_FILEATTACHMENT = _fitz.ANNOT_FILEATTACHMENT
ANNOT_SOUND = _fitz.ANNOT_SOUND
ANNOT_MOVIE = _fitz.ANNOT_MOVIE
ANNOT_WIDGET = _fitz.ANNOT_WIDGET
ANNOT_SCREEN = _fitz.ANNOT_SCREEN
ANNOT_PRINTERMARK = _fitz.ANNOT_PRINTERMARK
ANNOT_TRAPNET = _fitz.ANNOT_TRAPNET
ANNOT_WATERMARK = _fitz.ANNOT_WATERMARK
ANNOT_3D = _fitz.ANNOT_3D
ANNOT_XF_Invisible = _fitz.ANNOT_XF_Invisible
ANNOT_XF_Hidden = _fitz.ANNOT_XF_Hidden
ANNOT_XF_Print = _fitz.ANNOT_XF_Print
ANNOT_XF_NoZoom = _fitz.ANNOT_XF_NoZoom
ANNOT_XF_NoRotate = _fitz.ANNOT_XF_NoRotate
ANNOT_XF_NoView = _fitz.ANNOT_XF_NoView
ANNOT_XF_ReadOnly = _fitz.ANNOT_XF_ReadOnly
ANNOT_XF_Locked = _fitz.ANNOT_XF_Locked
ANNOT_XF_ToggleNoView = _fitz.ANNOT_XF_ToggleNoView
ANNOT_XF_LockedContents = _fitz.ANNOT_XF_LockedContents
ANNOT_LE_None = _fitz.ANNOT_LE_None
ANNOT_LE_Square = _fitz.ANNOT_LE_Square
ANNOT_LE_Circle = _fitz.ANNOT_LE_Circle
ANNOT_LE_Diamond = _fitz.ANNOT_LE_Diamond
ANNOT_LE_OpenArrow = _fitz.ANNOT_LE_OpenArrow
ANNOT_LE_ClosedArrow = _fitz.ANNOT_LE_ClosedArrow
ANNOT_LE_Butt = _fitz.ANNOT_LE_Butt
ANNOT_LE_ROpenArrow = _fitz.ANNOT_LE_ROpenArrow
ANNOT_LE_RClosedArrow = _fitz.ANNOT_LE_RClosedArrow
ANNOT_LE_Slash = _fitz.ANNOT_LE_Slash
ANNOT_WG_NOT_WIDGET = _fitz.ANNOT_WG_NOT_WIDGET
ANNOT_WG_PUSHBUTTON = _fitz.ANNOT_WG_PUSHBUTTON
ANNOT_WG_CHECKBOX = _fitz.ANNOT_WG_CHECKBOX
ANNOT_WG_RADIOBUTTON = _fitz.ANNOT_WG_RADIOBUTTON
ANNOT_WG_TEXT = _fitz.ANNOT_WG_TEXT
ANNOT_WG_LISTBOX = _fitz.ANNOT_WG_LISTBOX
ANNOT_WG_COMBOBOX = _fitz.ANNOT_WG_COMBOBOX
ANNOT_WG_SIGNATURE = _fitz.ANNOT_WG_SIGNATURE
ANNOT_WG_TEXT_UNRESTRAINED = _fitz.ANNOT_WG_TEXT_UNRESTRAINED
ANNOT_WG_TEXT_NUMBER = _fitz.ANNOT_WG_TEXT_NUMBER
ANNOT_WG_TEXT_SPECIAL = _fitz.ANNOT_WG_TEXT_SPECIAL
ANNOT_WG_TEXT_DATE = _fitz.ANNOT_WG_TEXT_DATE
ANNOT_WG_TEXT_TIME = _fitz.ANNOT_WG_TEXT_TIME
WIDGET_Ff_ReadOnly = _fitz.WIDGET_Ff_ReadOnly
WIDGET_Ff_Required = _fitz.WIDGET_Ff_Required
WIDGET_Ff_NoExport = _fitz.WIDGET_Ff_NoExport
WIDGET_Ff_Multiline = _fitz.WIDGET_Ff_Multiline
WIDGET_Ff_Password = _fitz.WIDGET_Ff_Password
WIDGET_Ff_FileSelect = _fitz.WIDGET_Ff_FileSelect
WIDGET_Ff_DoNotSpellCheck = _fitz.WIDGET_Ff_DoNotSpellCheck
WIDGET_Ff_DoNotScroll = _fitz.WIDGET_Ff_DoNotScroll
WIDGET_Ff_Comb = _fitz.WIDGET_Ff_Comb
WIDGET_Ff_RichText = _fitz.WIDGET_Ff_RichText
WIDGET_Ff_NoToggleToOff = _fitz.WIDGET_Ff_NoToggleToOff
WIDGET_Ff_Radio = _fitz.WIDGET_Ff_Radio
WIDGET_Ff_Pushbutton = _fitz.WIDGET_Ff_Pushbutton
WIDGET_Ff_RadioInUnison = _fitz.WIDGET_Ff_RadioInUnison
WIDGET_Ff_Combo = _fitz.WIDGET_Ff_Combo
WIDGET_Ff_Edit = _fitz.WIDGET_Ff_Edit
WIDGET_Ff_Sort = _fitz.WIDGET_Ff_Sort
WIDGET_Ff_MultiSelect = _fitz.WIDGET_Ff_MultiSelect
WIDGET_Ff_CommitOnSelCHange = _fitz.WIDGET_Ff_CommitOnSelCHange
class Annot(_object):
    """Proxy of C fz_annot_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Annot, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Annot, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Annot
    __del__ = lambda self: None
    @property

    def rect(self):
        """Rectangle containing the annot"""
        CheckParent(self)

        return _fitz.Annot_rect(self)


    def _getXref(self):
        """Xref number of annotation"""
        CheckParent(self)

        return _fitz.Annot__getXref(self)


    def _getAP(self):
        """Get contents source of a PDF annot"""
        CheckParent(self)

        return _fitz.Annot__getAP(self)


    def _setAP(self, ap):
        """Update contents source of a PDF annot"""
        CheckParent(self)

        return _fitz.Annot__setAP(self, ap)


    def _checkAP(self, rect, c):
        """Check and update /AP object of annot"""
        CheckParent(self)

        return _fitz.Annot__checkAP(self, rect, c)


    def _setRect(self, rect):
        """_setRect(self, rect)"""
        return _fitz.Annot__setRect(self, rect)


    def setRect(self, rect):
        """Change the annot's rectangle."""
        CheckParent(self)
        if rect.isEmpty or rect.isInfinite:
            raise ValueError("Rect must be finite and not empty.")
    # only handle Circle, Square, Line, PolyLine and Polygon here
        if self.type[0] not in range(2, 8):
            self._setRect(rect)
            return

        if self.type[0] == ANNOT_CIRCLE:
            self._setRect(rect)
            ap = _make_circle_AP(self)
            self._checkAP(Rect(0, 0, rect.width, rect.height), ap)
            return

        if self.type[0] == ANNOT_SQUARE:
            self._setRect(rect)
            ap = _make_rect_AP(self)
            self._checkAP(Rect(0, 0, rect.width, rect.height), ap)
            return

        orect = self.rect
        m = Matrix(rect.width / orect.width, rect.height / orect.height)

    # now transform the points of the annot
        ov = self.vertices
        nv = [(Point(v) - orect.tl) * m + rect.tl for v in ov] # new points
        r0 = Rect(nv[0], nv[0])              # recalculate new rectangle
        for v in nv[1:]:
            r0 |= v                          # enveloping all points
        w = self.border["width"] * 3         # allow for add'l space
        r0 += (-w, -w, w, w)                 # for line end symbols
        self._setRect(r0)                    # this is the final rect
        self._setVertices(nv)                # put the points in annot
        ap = _make_line_AP(self, nv, r0)
        self._checkAP(Rect(0, 0, r0.width, r0.height), ap)

    @property

    def vertices(self):
        """Point coordinates for various annot types"""
        CheckParent(self)

        return _fitz.Annot_vertices(self)


    def _setVertices(self, vertices):
        """Change the annot's vertices. Only for 'Line', 'PolyLine' and 'Polygon' types."""
        CheckParent(self)

        return _fitz.Annot__setVertices(self, vertices)

    @property

    def colors(self):
        """dictionary of the annot's colors"""
        CheckParent(self)

        return _fitz.Annot_colors(self)


    def updateAppearance(self):
        """Update the appearance of an annotation."""
        CheckParent(self)

        return _fitz.Annot_updateAppearance(self)


    def setColors(self, colors):
        """
        setColors(dict)
        Changes the 'stroke' and 'fill' colors of an annotation. If provided, values must be lists of up to 4 floats.
        """
        CheckParent(self)

        val = _fitz.Annot_setColors(self, colors)

        if self.type[0] not in range(2, 8):
            return
        r = Rect(0, 0, self.rect.width, self.rect.height)
        if self.type[0] == ANNOT_CIRCLE:
            ap = _make_circle_AP(self)
        elif self.type[0] == ANNOT_SQUARE:
            ap = _make_rect_AP(self)
        else:
            ap = _make_line_AP(self)
        self._checkAP(r, ap)


        return val

    @property

    def lineEnds(self):
        """lineEnds(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_lineEnds(self)


    def setLineEnds(self, start, end):
        """setLineEnds(self, start, end)"""
        CheckParent(self)

        val = _fitz.Annot_setLineEnds(self, start, end)

        if self.type[0] not in range(2, 8):
            return
        if self.type[0] in (ANNOT_CIRCLE, ANNOT_SQUARE):
            return
        r = Rect(0, 0, self.rect.width, self.rect.height)
        ap = _make_line_AP(self)
        self._checkAP(r, ap)


        return val

    @property

    def type(self):
        """type(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_type(self)

    @property

    def opacity(self):
        """opacity(self) -> float"""
        CheckParent(self)

        return _fitz.Annot_opacity(self)


    def setOpacity(self, opacity):
        """setOpacity(self, opacity)"""
        CheckParent(self)

        val = _fitz.Annot_setOpacity(self, opacity)
        _upd_my_AP(self)

        return val

    @property

    def widget_type(self):
        """widget_type(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_widget_type(self)

    @property

    def widget_value(self):
        """widget_value(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_widget_value(self)

    @property

    def widget_name(self):
        """widget_name(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_widget_name(self)

    @property

    def widget_choices(self):
        """widget_choices(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_widget_choices(self)


    def fileInfo(self):
        """Retrieve attached file information."""
        CheckParent(self)

        return _fitz.Annot_fileInfo(self)


    def fileGet(self):
        """Retrieve annotation attached file content."""
        CheckParent(self)

        return _fitz.Annot_fileGet(self)


    def fileUpd(self, buffer=None, filename=None, ufilename=None, desc=None):
        """Update annotation attached file content."""
        CheckParent(self)

        return _fitz.Annot_fileUpd(self, buffer, filename, ufilename, desc)

    @property

    def info(self):
        """info(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_info(self)


    def setInfo(self, info):
        """setInfo(self, info) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_setInfo(self, info)

    @property

    def border(self):
        """border(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_border(self)


    def setBorder(self, border):
        """setBorder(self, border) -> PyObject *"""
        CheckParent(self)

        val = _fitz.Annot_setBorder(self, border)
        _upd_my_AP(self)

        return val

    @property

    def flags(self):
        """flags(self) -> int"""
        CheckParent(self)

        return _fitz.Annot_flags(self)


    def _cleanContents(self):
        """_cleanContents(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot__cleanContents(self)


    def setFlags(self, flags):
        """setFlags(self, flags)"""
        CheckParent(self)

        return _fitz.Annot_setFlags(self, flags)

    @property

    def next(self):
        """next(self) -> Annot"""
        CheckParent(self)

        val = _fitz.Annot_next(self)
        if val:
            val.thisown = True
            val.parent = self.parent # copy owning page object from previous annot
            val.parent._annot_refs[id(val)] = val

        return val


    def getPixmap(self, matrix=None, colorspace=None, alpha=0):
        """getPixmap(self, matrix=None, colorspace=None, alpha=0) -> Pixmap"""
        CheckParent(self)

        return _fitz.Annot_getPixmap(self, matrix, colorspace, alpha)


    def _updateWidget(self, Widget):
        """_updateWidget(self, Widget) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot__updateWidget(self, Widget)


    def _getWidget(self, Widget):
        """_getWidget(self, Widget) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot__getWidget(self, Widget)


    @property
    def widget(self):
        annot_type = self.type[0]
        if annot_type != ANNOT_WIDGET:
            return None
        w = Widget()
        w.field_type        = self.widget_type[0]
        w.field_type_string = self.widget_type[1]
        w.field_value       = self.widget_value
        w.field_name        = self.widget_name
        w.choice_values     = self.widget_choices
        w.rect              = self.rect
        w.text_font         = None
        self._getWidget(w)
        return w

    def updateWidget(self, widget):
        if self.widget_type[0] != widget.field_type:
            raise ValueError("cannot change widget type")
        widget._validate()
        doc = self.parent.parent
        xref = 0
        ff = doc.FormFonts
        if not widget.text_font:         # ensure default
            widget.text_font = "Helv"
        if not widget.text_font in ff:   # if no existent font ...
            if not doc.isFormPDF or not ff:   # a fresh /AcroForm PDF!
                xref = doc._getNewXref()      # insert all our fonts
                doc._updateObject(xref, Widget_fontobjects)
            else:                        # add any missing fonts
                for k in Widget_fontdict.keys():
                    if not k in ff:      # add our font if missing
                        doc._addFormFont(k, Widget_fontdict[k])
            widget._adjust_font()        # ensure correct font spelling
        widget._dr_xref = xref           # non-zero causes /DR creation
    # now create the /DA string
        if   len(widget.text_color) == 3:
            fmt = "{:g} {:g} {:g} rg /{f:s} {s:g} Tf " + widget._text_da
        elif len(widget.text_color) == 1:
            fmt = "{:g} g /{f:s} {s:g} Tf " + widget._text_da
        elif len(widget.text_color) == 4:
            fmt = "{:g} {:g} {:g} {:g} k /{f:s} {s:g} Tf " + widget._text_da
        widget._text_da = fmt.format(*widget.text_color, f=widget.text_font,
                                    s=widget.text_fontsize)
    # update the widget at last
        self._updateWidget(widget)

    def _erase(self):
        try:
            self.parent._forget_annot(self)
        except:
            pass
        if getattr(self, "thisown", True):
            self.__swig_destroy__(self)
        self.parent = None
        self.thisown = False

    def __str__(self):
        CheckParent(self)
        return "'%s' annotation on %s" % (self.type[1], str(self.parent))

    def __repr__(self):
        CheckParent(self)
        return "'%s' annotation on %s" % (self.type[1], str(self.parent))

    def __del__(self):
        self._erase()
Annot_swigregister = _fitz.Annot_swigregister
Annot_swigregister(Annot)

class Link(_object):
    """Proxy of C fz_link_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Link, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Link, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Link
    __del__ = lambda self: None
    @property

    def uri(self):
        """uri(self) -> char *"""
        CheckParent(self)

        val = _fitz.Link_uri(self)

        if not val:
            return ""
        nval = "".join([c for c in val if 32 <= ord(c) <= 127])
        val = nval


        return val

    @property

    def isExternal(self):
        """isExternal(self) -> int"""
        CheckParent(self)

        return _fitz.Link_isExternal(self)


    page = -1
    @property
    def dest(self):
        """Create link destination details."""
        if hasattr(self, "parent") and self.parent is None:
            raise ValueError("orphaned object: parent is None")
        if self.parent.parent.isClosed or self.parent.parent.isEncrypted:
            raise ValueError("operation illegal for closed / encrypted doc")
        doc = self.parent.parent

        if self.isExternal or self.uri.startswith("#"):
            uri = None
        else:
            uri = doc.resolveLink(self.uri)

        return linkDest(self, uri)

    @property

    def rect(self):
        """rect(self) -> Rect"""
        CheckParent(self)

        return _fitz.Link_rect(self)

    @property

    def next(self):
        """next(self) -> Link"""
        CheckParent(self)

        val = _fitz.Link_next(self)
        if val:
            val.thisown = True
            val.parent = self.parent # copy owning page object from previous annot
            val.parent._annot_refs[id(val)] = val

        return val


    def _erase(self):
        try:
            self.parent._forget_annot(self)
        except:
            pass
        if getattr(self, "thisown", True):
            self.__swig_destroy__(self)
        self.parent = None
        self.thisown = False

    def __str__(self):
        CheckParent(self)
        return "link on " + str(self.parent)

    def __repr__(self):
        CheckParent(self)
        return "link on " + str(self.parent)

    def __del__(self):
        self._erase()
Link_swigregister = _fitz.Link_swigregister
Link_swigregister(Link)

class DisplayList(_object):
    """Proxy of C fz_display_list_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DisplayList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DisplayList, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_DisplayList
    __del__ = lambda self: None

    def __init__(self, mediabox):
        """__init__(self, mediabox) -> DisplayList"""
        this = _fitz.new_DisplayList(mediabox)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def run(self, dw, m, area):
        """run(self, dw, m, area) -> int"""
        return _fitz.DisplayList_run(self, dw, m, area)

    @property

    def rect(self):
        """rect(self) -> Rect"""
        return _fitz.DisplayList_rect(self)


    def getPixmap(self, matrix=None, colorspace=None, alpha=0, clip=None):
        """getPixmap(self, matrix=None, colorspace=None, alpha=0, clip=None) -> Pixmap"""
        return _fitz.DisplayList_getPixmap(self, matrix, colorspace, alpha, clip)


    def getTextPage(self, flags=3):
        """getTextPage(self, flags=3) -> TextPage"""
        return _fitz.DisplayList_getTextPage(self, flags)


    def __del__(self):
        if not type(self) is DisplayList: return
        self.__swig_destroy__(self)

DisplayList_swigregister = _fitz.DisplayList_swigregister
DisplayList_swigregister(DisplayList)

class TextPage(_object):
    """Proxy of C fz_stext_page_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TextPage, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TextPage, name)
    __repr__ = _swig_repr

    def __init__(self, mediabox):
        """__init__(self, mediabox) -> TextPage"""
        this = _fitz.new_TextPage(mediabox)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fitz.delete_TextPage
    __del__ = lambda self: None

    def search(self, needle, hit_max=16):
        """search(self, needle, hit_max=16) -> PyObject *"""
        val = _fitz.TextPage_search(self, needle, hit_max)

        if val:
            nval = []
            for r in val:
                nval.append(Rect(r))
            val = nval


        return val


    def _extractTextBlocks_AsList(self):
        """_extractTextBlocks_AsList(self) -> PyObject *"""
        return _fitz.TextPage__extractTextBlocks_AsList(self)


    def _extractTextWords_AsList(self):
        """_extractTextWords_AsList(self) -> PyObject *"""
        return _fitz.TextPage__extractTextWords_AsList(self)


    def _extractText(self, format):
        """_extractText(self, format) -> PyObject *"""
        val = _fitz.TextPage__extractText(self, format)

        if format != 2:
            return val
        import base64, json

        def convertb64(s):
            if str is bytes:
                return base64.b64encode(s)
            return base64.b64encode(s).decode()

        val = json.dumps(val, separators=(",", ":"), default=convertb64)


        return val


    def extractText(self):
        return self._extractText(0)

    def extractHTML(self):
        return self._extractText(1)

    def extractJSON(self):
        return self._extractText(2)

    def extractXML(self):
        return self._extractText(3)

    def extractXHTML(self):
        return self._extractText(4)

    def extractDICT(self):
        return self._extractText(5)

    def extractRAWDICT(self):
        return self._extractText(6)


    def __del__(self):
        if not type(self) is TextPage: return
        self.__swig_destroy__(self)

TextPage_swigregister = _fitz.TextPage_swigregister
TextPage_swigregister(TextPage)

class Graftmap(_object):
    """Proxy of C pdf_graft_map_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Graftmap, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Graftmap, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Graftmap
    __del__ = lambda self: None

    def __init__(self, doc):
        """__init__(self, doc) -> Graftmap"""
        this = _fitz.new_Graftmap(doc)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __del__(self):
        self.__swig_destroy__(self)

Graftmap_swigregister = _fitz.Graftmap_swigregister
Graftmap_swigregister(Graftmap)

class Tools(_object):
    """Proxy of C Tools struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Tools, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Tools, name)
    __repr__ = _swig_repr

    def gen_id(self):
        """Return a globally unique integer."""
        return _fitz.Tools_gen_id(self)


    def store_shrink(self, percent):
        """Free 'percent' of current store size."""
        return _fitz.Tools_store_shrink(self, percent)

    @property

    def store_size(self):
        """Current store size."""
        return _fitz.Tools_store_size(self)

    @property

    def store_maxsize(self):
        """Maximum store size."""
        return _fitz.Tools_store_maxsize(self)

    @property

    def fitz_config(self):
        """Show configuration data."""
        return _fitz.Tools_fitz_config(self)


    def _store_debug(self):
        """_store_debug(self)"""
        return _fitz.Tools__store_debug(self)


    def glyph_cache_empty(self):
        """Empty the glyph cache."""
        return _fitz.Tools_glyph_cache_empty(self)


    def __init__(self):
        """__init__(self) -> Tools"""
        this = _fitz.new_Tools()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fitz.delete_Tools
    __del__ = lambda self: None
Tools_swigregister = _fitz.Tools_swigregister
Tools_swigregister(Tools)

# This file is compatible with both classic and new-style classes.


