/**
 * Build options
 */
export interface BuildOptions {
    /**
     * Entry file
     */
    readonly entry: string;
    /**
     * The output directory
     */
    readonly outDir: string;
    /**
     * Expose modules as UMD under this name
     */
    readonly global: string;
    /**
     * Minify
     */
    readonly minify?: boolean;
    /**
     * Include source maps
     */
    readonly sourceMaps?: boolean;
    /**
     * The cache directory
     */
    readonly cacheDir?: string;
    /**
     * The node version to use as target for Babel
     */
    readonly nodeVersion?: string;
}
/**
 * Build with Parcel
 */
export declare function build(options: BuildOptions): void;
