# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-03-01 21:38
from __future__ import unicode_literals

from decimal import Decimal
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import localflavor.us.models
import wellsfargo.core.fields


class Migration(migrations.Migration):

    initial = True

    replaces = [
        ('wellsfargo', '0001_squashed_0009_auto_20160729_1432'),
        ('wellsfargo', '0002_auto_20160729_1512'),
        ('wellsfargo', '0003_financingplan_is_default_plan'),
        ('wellsfargo', '0004_auto_20161122_1357'),
        ('wellsfargo', '0005_auto_20161122_1503'),
        ('wellsfargo', '0006_apicredentials'),
        ('wellsfargo', '0007_financingplan_allow_credit_application'),
        ('wellsfargo', '0008_auto_20170117_1413'),
        ('wellsfargo', '0009_drop_oscar_accounts_1'),
        ('wellsfargo', '0009_drop_oscar_accounts_2'),
        ('wellsfargo', '0009_drop_oscar_accounts_3'),
    ]

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('auth', '0006_require_contenttypes_0002'),
        ('offer', '0006_bluelightabsolutediscountbenefit_bluelightcountcondition_bluelightcoveragecondition_bluelightfixedpr'),
    ]

    operations = [
        migrations.CreateModel(
            name='APICredentials',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(max_length=200, verbose_name='WFRS API Username')),
                ('password', models.CharField(max_length=200, verbose_name='WFRS API Password')),
                ('merchant_num', models.CharField(max_length=200, verbose_name='WFRS API Merchant Number')),
                ('priority', models.IntegerField(default=1, verbose_name='Priority Order')),
                ('user_group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.Group')),
            ],
            options={
                'verbose_name': 'API Credentials',
                'verbose_name_plural': 'API Credentials',
                'ordering': ('-priority', '-id'),
            },
        ),
        migrations.CreateModel(
            name='CACreditApp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('region', models.CharField(choices=[('US', 'United States'), ('CA', 'Canada')], default='US', max_length=15, verbose_name='Region')),
                ('language', models.CharField(choices=[('E', 'English'), ('F', 'French')], default='E', max_length=1, verbose_name='Language')),
                ('app_type', models.CharField(choices=[('I', 'Individual'), ('J', 'Joint')], default='I', max_length=1, verbose_name='Application Type')),
                ('purchase_price', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(99999)], verbose_name='Requested Credit Amount')),
                ('main_first_name', models.CharField(max_length=15, verbose_name='First Name')),
                ('main_last_name', models.CharField(max_length=20, verbose_name='Last Name')),
                ('main_middle_initial', models.CharField(blank=True, max_length=1, null=True, verbose_name='Middle Initial')),
                ('main_date_of_birth', wellsfargo.core.fields.DateOfBirthField(null=True, verbose_name='Date of Birth')),
                ('main_address_line1', models.CharField(max_length=35, verbose_name='Address Line 1')),
                ('main_address_line2', models.CharField(blank=True, max_length=35, null=True, verbose_name='Address Line 2')),
                ('main_address_city', models.CharField(max_length=15, verbose_name='City')),
                ('main_home_value', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(9999999)], verbose_name='Home Value')),
                ('main_mortgage_balance', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(9999999)], verbose_name='Mortgage Balance')),
                ('main_annual_income', models.IntegerField(validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(999999)], verbose_name='Annual Income')),
                ('insurance', models.BooleanField(default=False, verbose_name='Optional Insurance')),
                ('sales_person_id', models.CharField(blank=True, max_length=4, null=True, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4)], verbose_name='Existing Sales Person ID')),
                ('new_sales_person', models.CharField(blank=True, max_length=10, null=True, verbose_name='New Sales Person Name')),
                ('email', models.EmailField(max_length=80, verbose_name='Email')),
                ('created_datetime', models.DateTimeField(auto_now_add=True)),
                ('modified_datetime', models.DateTimeField(auto_now=True)),
                ('main_ssn', wellsfargo.core.fields.CASocialInsuranceNumberField(blank=True, null=True, verbose_name='Social Insurance Number')),
                ('main_address_state', wellsfargo.core.fields.CAProvinceField(verbose_name='Province')),
                ('main_address_postcode', wellsfargo.core.fields.CAPostalCodeField(verbose_name='Postcode')),
                ('main_home_phone', wellsfargo.core.fields.CAPhoneNumberField(verbose_name='Home Phone')),
                ('main_time_at_address', models.CharField(max_length=4, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Address')),
                ('main_housing_status', models.CharField(choices=[('R', 'Rent'), ('O', 'Own')], max_length=3, verbose_name='Housing Status')),
                ('main_employer_name', models.CharField(max_length=30, verbose_name='Employer Name')),
                ('main_time_at_employer', models.CharField(max_length=4, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Employer')),
                ('main_employer_phone', wellsfargo.core.fields.CAPhoneNumberField(verbose_name='Employer Phone Number')),
                ('main_cell_phone', wellsfargo.core.fields.CAPhoneNumberField(blank=True, null=True, verbose_name='Cell Phone')),
                ('main_occupation', models.CharField(max_length=24, verbose_name='Occupation')),
                ('main_photo_id_type', models.CharField(choices=[('OA', 'Old Age Security Card'), ('DL', 'Driver’s License'), ('PI', 'Provincial ID'), ('PA', 'Canadian Passport'), ('CN', 'Certificate of Citizenship or Naturalization'), ('IS', 'Certificate of Indian Status'), ('CC', 'Canadian Citizen Form 1000 or 1442')], max_length=2, verbose_name='Photo ID Type')),
                ('main_photo_id_number', models.CharField(max_length=4, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4)], verbose_name='Photo ID Number')),
                ('main_drivers_license_province', wellsfargo.core.fields.CAProvinceField(blank=True, null=True, verbose_name='Driver’s License Province')),
                ('main_photo_id_expiration', models.DateField(verbose_name='Photo ID Expiration Date')),
                ('submitting_user', models.ForeignKey(blank=True, help_text='Select the user who filled out and submitted the credit application (not always the same as the user who is applying for credit).', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Submitting User')),
                ('user', models.ForeignKey(blank=True, help_text='Select the user user who is applying and who will own (be the primary user of) this account.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='ca_individual_credit_apps', to=settings.AUTH_USER_MODEL, verbose_name='Owner')),
                ('last4_account_number', models.CharField(blank=True, max_length=4, null=True, verbose_name='Resulting Account')),
            ],
            options={
                'verbose_name': 'CA Individual Credit Application',
                'verbose_name_plural': 'CA Individual Credit Applications',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CAJointCreditApp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('region', models.CharField(choices=[('US', 'United States'), ('CA', 'Canada')], default='US', max_length=15, verbose_name='Region')),
                ('language', models.CharField(choices=[('E', 'English'), ('F', 'French')], default='E', max_length=1, verbose_name='Language')),
                ('app_type', models.CharField(choices=[('I', 'Individual'), ('J', 'Joint')], default='I', max_length=1, verbose_name='Application Type')),
                ('purchase_price', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(99999)], verbose_name='Requested Credit Amount')),
                ('main_first_name', models.CharField(max_length=15, verbose_name='First Name')),
                ('main_last_name', models.CharField(max_length=20, verbose_name='Last Name')),
                ('main_middle_initial', models.CharField(blank=True, max_length=1, null=True, verbose_name='Middle Initial')),
                ('main_date_of_birth', wellsfargo.core.fields.DateOfBirthField(null=True, verbose_name='Date of Birth')),
                ('main_address_line1', models.CharField(max_length=35, verbose_name='Address Line 1')),
                ('main_address_line2', models.CharField(blank=True, max_length=35, null=True, verbose_name='Address Line 2')),
                ('main_address_city', models.CharField(max_length=15, verbose_name='City')),
                ('main_home_value', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(9999999)], verbose_name='Home Value')),
                ('main_mortgage_balance', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(9999999)], verbose_name='Mortgage Balance')),
                ('main_annual_income', models.IntegerField(validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(999999)], verbose_name='Annual Income')),
                ('insurance', models.BooleanField(default=False, verbose_name='Optional Insurance')),
                ('sales_person_id', models.CharField(blank=True, max_length=4, null=True, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4)], verbose_name='Existing Sales Person ID')),
                ('new_sales_person', models.CharField(blank=True, max_length=10, null=True, verbose_name='New Sales Person Name')),
                ('email', models.EmailField(max_length=80, verbose_name='Email')),
                ('created_datetime', models.DateTimeField(auto_now_add=True)),
                ('modified_datetime', models.DateTimeField(auto_now=True)),
                ('joint_first_name', models.CharField(max_length=15, verbose_name='First Name')),
                ('joint_last_name', models.CharField(max_length=20, verbose_name='Last Name')),
                ('joint_middle_initial', models.CharField(blank=True, max_length=1, null=True, verbose_name='Middle Initial')),
                ('joint_date_of_birth', wellsfargo.core.fields.DateOfBirthField(null=True, verbose_name='Date of Birth')),
                ('joint_address_line1', models.CharField(max_length=35, verbose_name='Address Line 1')),
                ('joint_address_line2', models.CharField(blank=True, max_length=35, null=True, verbose_name='Address Line 2')),
                ('joint_address_city', models.CharField(max_length=15, verbose_name='City')),
                ('joint_annual_income', models.IntegerField(validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(999999)], verbose_name='Annual Income')),
                ('main_ssn', wellsfargo.core.fields.CASocialInsuranceNumberField(blank=True, null=True, verbose_name='Social Insurance Number')),
                ('main_address_state', wellsfargo.core.fields.CAProvinceField(verbose_name='Province')),
                ('main_address_postcode', wellsfargo.core.fields.CAPostalCodeField(verbose_name='Postcode')),
                ('main_home_phone', wellsfargo.core.fields.CAPhoneNumberField(verbose_name='Home Phone')),
                ('main_time_at_address', models.CharField(max_length=4, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Address')),
                ('main_housing_status', models.CharField(choices=[('R', 'Rent'), ('O', 'Own')], max_length=3, verbose_name='Housing Status')),
                ('main_employer_name', models.CharField(max_length=30, verbose_name='Employer Name')),
                ('main_time_at_employer', models.CharField(max_length=4, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Employer')),
                ('main_employer_phone', wellsfargo.core.fields.CAPhoneNumberField(verbose_name='Employer Phone Number')),
                ('main_cell_phone', wellsfargo.core.fields.CAPhoneNumberField(blank=True, null=True, verbose_name='Cell Phone')),
                ('main_occupation', models.CharField(max_length=24, verbose_name='Occupation')),
                ('main_photo_id_type', models.CharField(choices=[('OA', 'Old Age Security Card'), ('DL', 'Driver’s License'), ('PI', 'Provincial ID'), ('PA', 'Canadian Passport'), ('CN', 'Certificate of Citizenship or Naturalization'), ('IS', 'Certificate of Indian Status'), ('CC', 'Canadian Citizen Form 1000 or 1442')], max_length=2, verbose_name='Photo ID Type')),
                ('main_photo_id_number', models.CharField(max_length=4, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4)], verbose_name='Photo ID Number')),
                ('main_drivers_license_province', wellsfargo.core.fields.CAProvinceField(blank=True, null=True, verbose_name='Driver’s License Province')),
                ('main_photo_id_expiration', models.DateField(verbose_name='Photo ID Expiration Date')),
                ('joint_ssn', wellsfargo.core.fields.CASocialInsuranceNumberField(blank=True, null=True, verbose_name='Social Insurance Number')),
                ('joint_address_state', wellsfargo.core.fields.CAProvinceField(verbose_name='Province')),
                ('joint_address_postcode', wellsfargo.core.fields.CAPostalCodeField(verbose_name='Postcode')),
                ('joint_employer_name', models.CharField(max_length=30, verbose_name='Employer Name')),
                ('joint_time_at_employer', models.CharField(max_length=4, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Employer')),
                ('joint_employer_phone', wellsfargo.core.fields.CAPhoneNumberField(verbose_name='Employer Phone Number')),
                ('joint_cell_phone', wellsfargo.core.fields.CAPhoneNumberField(blank=True, null=True, verbose_name='Cell Phone')),
                ('joint_occupation', models.CharField(max_length=24, verbose_name='Occupation')),
                ('joint_photo_id_type', models.CharField(choices=[('OA', 'Old Age Security Card'), ('DL', 'Driver’s License'), ('PI', 'Provincial ID'), ('PA', 'Canadian Passport'), ('CN', 'Certificate of Citizenship or Naturalization'), ('IS', 'Certificate of Indian Status'), ('CC', 'Canadian Citizen Form 1000 or 1442')], max_length=3, verbose_name='Photo ID Type')),
                ('joint_photo_id_number', models.CharField(max_length=4, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4)], verbose_name='Photo ID Number')),
                ('joint_drivers_license_province', wellsfargo.core.fields.CAProvinceField(blank=True, null=True, verbose_name='Driver’s License Province')),
                ('joint_photo_id_expiration', models.DateField(verbose_name='Photo ID Expiration Date')),
                ('submitting_user', models.ForeignKey(blank=True, help_text='Select the user who filled out and submitted the credit application (not always the same as the user who is applying for credit).', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Submitting User')),
                ('user', models.ForeignKey(blank=True, help_text='Select the user user who is applying and who will own (be the primary user of) this account.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='ca_joint_credit_apps', to=settings.AUTH_USER_MODEL, verbose_name='Owner')),
                ('last4_account_number', models.CharField(blank=True, max_length=4, null=True, verbose_name='Resulting Account')),
            ],
            options={
                'verbose_name': 'CA Joint Credit Application',
                'verbose_name_plural': 'CA Joint Credit Applications',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FinancingPlan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('plan_number', models.PositiveIntegerField(unique=True, validators=[django.core.validators.MinValueValidator(1001), django.core.validators.MaxValueValidator(9999)], verbose_name='Plan Number')),
                ('description', models.TextField(blank=True, default='', verbose_name='Description')),
                ('apr', models.DecimalField(decimal_places=2, default='0.00', max_digits=5, validators=[django.core.validators.MinValueValidator(Decimal('0.00')), django.core.validators.MaxValueValidator(Decimal('100.00'))], verbose_name='Annual percentage rate (0.0 – 100.0)')),
                ('term_months', models.PositiveSmallIntegerField(default=12, verbose_name='Term Length (months)')),
                ('is_default_plan', models.BooleanField(default=False, verbose_name='Is Default Plan?')),
                ('allow_credit_application', models.BooleanField(default=True, verbose_name='Allow new credit applications when user is eligible for this plan?')),
            ],
            options={
                'ordering': ('plan_number',),
            },
        ),
        migrations.CreateModel(
            name='FinancingPlanBenefit',
            fields=[
                ('benefit_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='offer.Benefit')),
                ('group_name', models.CharField(max_length=200, verbose_name='Name')),
                ('plans', models.ManyToManyField(to='wellsfargo.FinancingPlan')),
            ],
            options={
                'verbose_name': 'Benefit',
                'verbose_name_plural': 'Benefits',
                'abstract': False,
            },
            bases=('offer.benefit',),
        ),
        migrations.CreateModel(
            name='TransferMetadata',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last4_account_number', models.CharField(max_length=4, verbose_name='Last 4 digits of account number')),
                ('encrypted_account_number', models.BinaryField(null=True)),
                ('merchant_reference', models.CharField(max_length=128, null=True)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=12)),
                ('type_code', models.CharField(choices=[('5', 'Authorization for Future Charge'), ('7', 'Cancel Existing Authorization'), ('4', 'Return or Credit'), ('9', 'Time-out Reversal for Return or Credit'), ('VS', 'Void Sale'), ('VR', 'Void Return')], max_length=2, verbose_name='Transaction Type')),
                ('ticket_number', models.CharField(blank=True, max_length=12, null=True, verbose_name='Ticket Number')),
                ('auth_number', models.CharField(blank=True, default='000000', max_length=6, null=True, verbose_name='Authorization Number')),
                ('status', models.CharField(choices=[('A0', 'Transaction not approved or declined. For time-out reversal and void transactions, match was found but was already funded.'), ('A1', 'Approved. For time-out reversal and void transactions, match was found and processed.'), ('A2', 'Time-out reversal or void approved, but no matching transaction was found.'), ('A3', 'Time-out reversal or void approved, but matched duplicate transactions.')], max_length=2, verbose_name='Status')),
                ('message', models.TextField(verbose_name='Message')),
                ('disclosure', models.TextField(verbose_name='Disclosure')),
                ('created_datetime', models.DateTimeField(auto_now_add=True)),
                ('modified_datetime', models.DateTimeField(auto_now=True)),
                ('financing_plan', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='wellsfargo.FinancingPlan', verbose_name='Plan Number')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='wfrs_transfers', to=settings.AUTH_USER_MODEL, verbose_name='Requesting User')),
            ],
        ),
        migrations.CreateModel(
            name='USCreditApp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('region', models.CharField(choices=[('US', 'United States'), ('CA', 'Canada')], default='US', max_length=15, verbose_name='Region')),
                ('language', models.CharField(choices=[('E', 'English'), ('F', 'French')], default='E', max_length=1, verbose_name='Language')),
                ('app_type', models.CharField(choices=[('I', 'Individual'), ('J', 'Joint')], default='I', max_length=1, verbose_name='Application Type')),
                ('purchase_price', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(99999)], verbose_name='Requested Credit Amount')),
                ('main_first_name', models.CharField(max_length=15, verbose_name='First Name')),
                ('main_last_name', models.CharField(max_length=20, verbose_name='Last Name')),
                ('main_middle_initial', models.CharField(blank=True, max_length=1, null=True, verbose_name='Middle Initial')),
                ('main_date_of_birth', wellsfargo.core.fields.DateOfBirthField(null=True, verbose_name='Date of Birth')),
                ('main_address_line1', models.CharField(max_length=35, verbose_name='Address Line 1')),
                ('main_address_line2', models.CharField(blank=True, max_length=35, null=True, verbose_name='Address Line 2')),
                ('main_address_city', models.CharField(max_length=15, verbose_name='City')),
                ('main_home_value', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(9999999)], verbose_name='Home Value')),
                ('main_mortgage_balance', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(9999999)], verbose_name='Mortgage Balance')),
                ('main_annual_income', models.IntegerField(validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(999999)], verbose_name='Annual Income')),
                ('insurance', models.BooleanField(default=False, verbose_name='Optional Insurance')),
                ('sales_person_id', models.CharField(blank=True, max_length=4, null=True, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4)], verbose_name='Existing Sales Person ID')),
                ('new_sales_person', models.CharField(blank=True, max_length=10, null=True, verbose_name='New Sales Person Name')),
                ('email', models.EmailField(max_length=80, verbose_name='Email')),
                ('created_datetime', models.DateTimeField(auto_now_add=True)),
                ('modified_datetime', models.DateTimeField(auto_now=True)),
                ('main_ssn', wellsfargo.core.fields.USSocialSecurityNumberField(max_length=11, verbose_name='Social Security Number')),
                ('main_address_state', localflavor.us.models.USStateField(max_length=2, verbose_name='State')),
                ('main_address_postcode', localflavor.us.models.USZipCodeField(max_length=10, verbose_name='Postcode')),
                ('main_home_phone', localflavor.us.models.PhoneNumberField(max_length=20, verbose_name='Home Phone')),
                ('main_time_at_address', models.CharField(blank=True, max_length=4, null=True, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Address')),
                ('main_housing_status', models.CharField(blank=True, choices=[('R', 'Rent'), ('O', 'Own'), ('OT', 'Other')], max_length=3, null=True, verbose_name='Housing Status')),
                ('main_employer_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='Employer Name')),
                ('main_time_at_employer', models.CharField(blank=True, max_length=4, null=True, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Employer')),
                ('main_employer_phone', localflavor.us.models.PhoneNumberField(max_length=20, verbose_name='Employer Phone Number')),
                ('main_cell_phone', localflavor.us.models.PhoneNumberField(blank=True, max_length=20, null=True, verbose_name='Cell Phone')),
                ('main_occupation', models.CharField(blank=True, max_length=24, null=True, verbose_name='Occupation')),
                ('submitting_user', models.ForeignKey(blank=True, help_text='Select the user who filled out and submitted the credit application (not always the same as the user who is applying for credit).', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Submitting User')),
                ('user', models.ForeignKey(blank=True, help_text='Select the user user who is applying and who will own (be the primary user of) this account.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='us_individual_credit_apps', to=settings.AUTH_USER_MODEL, verbose_name='Owner')),
                ('last4_account_number', models.CharField(blank=True, max_length=4, null=True, verbose_name='Resulting Account')),
            ],
            options={
                'verbose_name': 'US Individual Credit Application',
                'verbose_name_plural': 'US Individual Credit Applications',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='USJointCreditApp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('region', models.CharField(choices=[('US', 'United States'), ('CA', 'Canada')], default='US', max_length=15, verbose_name='Region')),
                ('language', models.CharField(choices=[('E', 'English'), ('F', 'French')], default='E', max_length=1, verbose_name='Language')),
                ('app_type', models.CharField(choices=[('I', 'Individual'), ('J', 'Joint')], default='I', max_length=1, verbose_name='Application Type')),
                ('purchase_price', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(99999)], verbose_name='Requested Credit Amount')),
                ('main_first_name', models.CharField(max_length=15, verbose_name='First Name')),
                ('main_last_name', models.CharField(max_length=20, verbose_name='Last Name')),
                ('main_middle_initial', models.CharField(blank=True, max_length=1, null=True, verbose_name='Middle Initial')),
                ('main_date_of_birth', wellsfargo.core.fields.DateOfBirthField(null=True, verbose_name='Date of Birth')),
                ('main_address_line1', models.CharField(max_length=35, verbose_name='Address Line 1')),
                ('main_address_line2', models.CharField(blank=True, max_length=35, null=True, verbose_name='Address Line 2')),
                ('main_address_city', models.CharField(max_length=15, verbose_name='City')),
                ('main_home_value', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(9999999)], verbose_name='Home Value')),
                ('main_mortgage_balance', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(9999999)], verbose_name='Mortgage Balance')),
                ('main_annual_income', models.IntegerField(validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(999999)], verbose_name='Annual Income')),
                ('insurance', models.BooleanField(default=False, verbose_name='Optional Insurance')),
                ('sales_person_id', models.CharField(blank=True, max_length=4, null=True, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4)], verbose_name='Existing Sales Person ID')),
                ('new_sales_person', models.CharField(blank=True, max_length=10, null=True, verbose_name='New Sales Person Name')),
                ('email', models.EmailField(max_length=80, verbose_name='Email')),
                ('created_datetime', models.DateTimeField(auto_now_add=True)),
                ('modified_datetime', models.DateTimeField(auto_now=True)),
                ('joint_first_name', models.CharField(max_length=15, verbose_name='First Name')),
                ('joint_last_name', models.CharField(max_length=20, verbose_name='Last Name')),
                ('joint_middle_initial', models.CharField(blank=True, max_length=1, null=True, verbose_name='Middle Initial')),
                ('joint_date_of_birth', wellsfargo.core.fields.DateOfBirthField(null=True, verbose_name='Date of Birth')),
                ('joint_address_line1', models.CharField(max_length=35, verbose_name='Address Line 1')),
                ('joint_address_line2', models.CharField(blank=True, max_length=35, null=True, verbose_name='Address Line 2')),
                ('joint_address_city', models.CharField(max_length=15, verbose_name='City')),
                ('joint_annual_income', models.IntegerField(validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(999999)], verbose_name='Annual Income')),
                ('main_ssn', wellsfargo.core.fields.USSocialSecurityNumberField(max_length=11, verbose_name='Social Security Number')),
                ('main_address_state', localflavor.us.models.USStateField(max_length=2, verbose_name='State')),
                ('main_address_postcode', localflavor.us.models.USZipCodeField(max_length=10, verbose_name='Postcode')),
                ('main_home_phone', localflavor.us.models.PhoneNumberField(max_length=20, verbose_name='Home Phone')),
                ('main_time_at_address', models.CharField(blank=True, max_length=4, null=True, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Address')),
                ('main_housing_status', models.CharField(blank=True, choices=[('R', 'Rent'), ('O', 'Own'), ('OT', 'Other')], max_length=3, null=True, verbose_name='Housing Status')),
                ('main_employer_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='Employer Name')),
                ('main_time_at_employer', models.CharField(blank=True, max_length=4, null=True, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Employer')),
                ('main_employer_phone', localflavor.us.models.PhoneNumberField(max_length=20, verbose_name='Employer Phone Number')),
                ('main_cell_phone', localflavor.us.models.PhoneNumberField(blank=True, max_length=20, null=True, verbose_name='Cell Phone')),
                ('main_occupation', models.CharField(blank=True, max_length=24, null=True, verbose_name='Occupation')),
                ('joint_ssn', wellsfargo.core.fields.USSocialSecurityNumberField(max_length=11, verbose_name='Social Security Number')),
                ('joint_address_state', localflavor.us.models.USStateField(max_length=2, verbose_name='State')),
                ('joint_address_postcode', localflavor.us.models.USZipCodeField(max_length=10, verbose_name='Postcode')),
                ('joint_employer_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='Employer Name')),
                ('joint_time_at_employer', models.CharField(blank=True, max_length=4, null=True, validators=[django.core.validators.MinLengthValidator(4), django.core.validators.MaxLengthValidator(4), django.core.validators.RegexValidator('^[0-9]{4}$')], verbose_name='Time at Employer')),
                ('joint_employer_phone', localflavor.us.models.PhoneNumberField(max_length=20, verbose_name='Employer Phone Number')),
                ('joint_cell_phone', localflavor.us.models.PhoneNumberField(blank=True, max_length=20, null=True, verbose_name='Cell Phone')),
                ('joint_occupation', models.CharField(blank=True, max_length=24, null=True, verbose_name='Occupation')),
                ('submitting_user', models.ForeignKey(blank=True, help_text='Select the user who filled out and submitted the credit application (not always the same as the user who is applying for credit).', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Submitting User')),
                ('user', models.ForeignKey(blank=True, help_text='Select the user user who is applying and who will own (be the primary user of) this account.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='us_joint_credit_apps', to=settings.AUTH_USER_MODEL, verbose_name='Owner')),
                ('last4_account_number', models.CharField(blank=True, max_length=4, null=True, verbose_name='Resulting Account')),
            ],
            options={
                'verbose_name': 'US Joint Credit Application',
                'verbose_name_plural': 'US Joint Credit Applications',
                'abstract': False,
            },
        ),
    ]
