# coding: utf-8

"""
    CredentialIssuanceService

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from affinidi_tdk_credential_issuance_client.models.credential_issuance_id_exist_error import CredentialIssuanceIdExistError
from affinidi_tdk_credential_issuance_client.models.credential_subject_not_valid_error import CredentialSubjectNotValidError
from affinidi_tdk_credential_issuance_client.models.invalid_credential_type_error import InvalidCredentialTypeError
from affinidi_tdk_credential_issuance_client.models.invalid_parameter_error import InvalidParameterError
from affinidi_tdk_credential_issuance_client.models.missing_holder_did_error import MissingHolderDidError
from affinidi_tdk_credential_issuance_client.models.project_credential_config_not_exist_error import ProjectCredentialConfigNotExistError
from typing import Union, Any, List, TYPE_CHECKING
from pydantic import StrictStr, Field

STARTISSUANCE400RESPONSE_ONE_OF_SCHEMAS = ["CredentialIssuanceIdExistError", "CredentialSubjectNotValidError", "InvalidCredentialTypeError", "InvalidParameterError", "MissingHolderDidError", "ProjectCredentialConfigNotExistError"]

class StartIssuance400Response(BaseModel):
    """
    StartIssuance400Response
    """
    # data type: InvalidParameterError
    oneof_schema_1_validator: Optional[InvalidParameterError] = None
    # data type: InvalidCredentialTypeError
    oneof_schema_2_validator: Optional[InvalidCredentialTypeError] = None
    # data type: ProjectCredentialConfigNotExistError
    oneof_schema_3_validator: Optional[ProjectCredentialConfigNotExistError] = None
    # data type: CredentialSubjectNotValidError
    oneof_schema_4_validator: Optional[CredentialSubjectNotValidError] = None
    # data type: CredentialIssuanceIdExistError
    oneof_schema_5_validator: Optional[CredentialIssuanceIdExistError] = None
    # data type: MissingHolderDidError
    oneof_schema_6_validator: Optional[MissingHolderDidError] = None
    if TYPE_CHECKING:
        actual_instance: Union[CredentialIssuanceIdExistError, CredentialSubjectNotValidError, InvalidCredentialTypeError, InvalidParameterError, MissingHolderDidError, ProjectCredentialConfigNotExistError]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(STARTISSUANCE400RESPONSE_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = StartIssuance400Response.construct()
        error_messages = []
        match = 0
        # validate data type: InvalidParameterError
        if not isinstance(v, InvalidParameterError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InvalidParameterError`")
        else:
            match += 1
        # validate data type: InvalidCredentialTypeError
        if not isinstance(v, InvalidCredentialTypeError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InvalidCredentialTypeError`")
        else:
            match += 1
        # validate data type: ProjectCredentialConfigNotExistError
        if not isinstance(v, ProjectCredentialConfigNotExistError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ProjectCredentialConfigNotExistError`")
        else:
            match += 1
        # validate data type: CredentialSubjectNotValidError
        if not isinstance(v, CredentialSubjectNotValidError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CredentialSubjectNotValidError`")
        else:
            match += 1
        # validate data type: CredentialIssuanceIdExistError
        if not isinstance(v, CredentialIssuanceIdExistError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CredentialIssuanceIdExistError`")
        else:
            match += 1
        # validate data type: MissingHolderDidError
        if not isinstance(v, MissingHolderDidError):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MissingHolderDidError`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in StartIssuance400Response with oneOf schemas: CredentialIssuanceIdExistError, CredentialSubjectNotValidError, InvalidCredentialTypeError, InvalidParameterError, MissingHolderDidError, ProjectCredentialConfigNotExistError. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in StartIssuance400Response with oneOf schemas: CredentialIssuanceIdExistError, CredentialSubjectNotValidError, InvalidCredentialTypeError, InvalidParameterError, MissingHolderDidError, ProjectCredentialConfigNotExistError. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> StartIssuance400Response:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> StartIssuance400Response:
        """Returns the object represented by the json string"""
        instance = StartIssuance400Response.construct()
        error_messages = []
        match = 0

        # deserialize data into InvalidParameterError
        try:
            instance.actual_instance = InvalidParameterError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into InvalidCredentialTypeError
        try:
            instance.actual_instance = InvalidCredentialTypeError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ProjectCredentialConfigNotExistError
        try:
            instance.actual_instance = ProjectCredentialConfigNotExistError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CredentialSubjectNotValidError
        try:
            instance.actual_instance = CredentialSubjectNotValidError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CredentialIssuanceIdExistError
        try:
            instance.actual_instance = CredentialIssuanceIdExistError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MissingHolderDidError
        try:
            instance.actual_instance = MissingHolderDidError.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into StartIssuance400Response with oneOf schemas: CredentialIssuanceIdExistError, CredentialSubjectNotValidError, InvalidCredentialTypeError, InvalidParameterError, MissingHolderDidError, ProjectCredentialConfigNotExistError. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into StartIssuance400Response with oneOf schemas: CredentialIssuanceIdExistError, CredentialSubjectNotValidError, InvalidCredentialTypeError, InvalidParameterError, MissingHolderDidError, ProjectCredentialConfigNotExistError. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())


