import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementGatewayApiConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api.html#api_id ApiManagementGatewayApi#api_id}.
     *
     * @stability stable
     */
    readonly apiId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api.html#gateway_id ApiManagementGatewayApi#gateway_id}.
     *
     * @stability stable
     */
    readonly gatewayId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api.html#timeouts ApiManagementGatewayApi#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementGatewayApiTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementGatewayApiTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api.html#create ApiManagementGatewayApi#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api.html#delete ApiManagementGatewayApi#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api.html#read ApiManagementGatewayApi#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api.html#update ApiManagementGatewayApi#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementGatewayApiTimeoutsToTerraform(struct?: ApiManagementGatewayApiTimeoutsOutputReference | ApiManagementGatewayApiTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementGatewayApiTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementGatewayApiTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementGatewayApiTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api.html azurerm_api_management_gateway_api}.
 *
 * @stability stable
 */
export declare class ApiManagementGatewayApi extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api.html azurerm_api_management_gateway_api} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementGatewayApiConfig);
    private _apiId?;
    /**
     * @stability stable
     */
    get apiId(): string;
    /**
     * @stability stable
     */
    set apiId(value: string);
    /**
     * @stability stable
     */
    get apiIdInput(): string | undefined;
    private _gatewayId?;
    /**
     * @stability stable
     */
    get gatewayId(): string;
    /**
     * @stability stable
     */
    set gatewayId(value: string);
    /**
     * @stability stable
     */
    get gatewayIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementGatewayApiTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementGatewayApiTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementGatewayApiTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
