import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementProductConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#api_management_name ApiManagementProduct#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#approval_required ApiManagementProduct#approval_required}.
     *
     * @stability stable
     */
    readonly approvalRequired?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#description ApiManagementProduct#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#display_name ApiManagementProduct#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#product_id ApiManagementProduct#product_id}.
     *
     * @stability stable
     */
    readonly productId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#published ApiManagementProduct#published}.
     *
     * @stability stable
     */
    readonly published: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#resource_group_name ApiManagementProduct#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#subscription_required ApiManagementProduct#subscription_required}.
     *
     * @stability stable
     */
    readonly subscriptionRequired: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#subscriptions_limit ApiManagementProduct#subscriptions_limit}.
     *
     * @stability stable
     */
    readonly subscriptionsLimit?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#terms ApiManagementProduct#terms}.
     *
     * @stability stable
     */
    readonly terms?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#timeouts ApiManagementProduct#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementProductTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementProductTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#create ApiManagementProduct#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#delete ApiManagementProduct#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#read ApiManagementProduct#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html#update ApiManagementProduct#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementProductTimeoutsToTerraform(struct?: ApiManagementProductTimeoutsOutputReference | ApiManagementProductTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementProductTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementProductTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementProductTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html azurerm_api_management_product}.
 *
 * @stability stable
 */
export declare class ApiManagementProduct extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product.html azurerm_api_management_product} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementProductConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _approvalRequired?;
    /**
     * @stability stable
     */
    get approvalRequired(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set approvalRequired(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetApprovalRequired(): void;
    /**
     * @stability stable
     */
    get approvalRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _productId?;
    /**
     * @stability stable
     */
    get productId(): string;
    /**
     * @stability stable
     */
    set productId(value: string);
    /**
     * @stability stable
     */
    get productIdInput(): string | undefined;
    private _published?;
    /**
     * @stability stable
     */
    get published(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set published(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get publishedInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _subscriptionRequired?;
    /**
     * @stability stable
     */
    get subscriptionRequired(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set subscriptionRequired(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get subscriptionRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _subscriptionsLimit?;
    /**
     * @stability stable
     */
    get subscriptionsLimit(): number;
    /**
     * @stability stable
     */
    set subscriptionsLimit(value: number);
    /**
     * @stability stable
     */
    resetSubscriptionsLimit(): void;
    /**
     * @stability stable
     */
    get subscriptionsLimitInput(): number | undefined;
    private _terms?;
    /**
     * @stability stable
     */
    get terms(): string;
    /**
     * @stability stable
     */
    set terms(value: string);
    /**
     * @stability stable
     */
    resetTerms(): void;
    /**
     * @stability stable
     */
    get termsInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementProductTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementProductTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementProductTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
