import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMssqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server.html#name DataAzurermMssqlServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server.html#resource_group_name DataAzurermMssqlServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server.html#timeouts DataAzurermMssqlServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMssqlServerTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermMssqlServerIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get userAssignedIdentityIds(): string[];
}
/**
 * @stability stable
 */
export interface DataAzurermMssqlServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server.html#read DataAzurermMssqlServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMssqlServerTimeoutsToTerraform(struct?: DataAzurermMssqlServerTimeoutsOutputReference | DataAzurermMssqlServerTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermMssqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMssqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMssqlServerTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server.html azurerm_mssql_server}.
 *
 * @stability stable
 */
export declare class DataAzurermMssqlServer extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server.html azurerm_mssql_server} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlServerConfig);
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    get fullyQualifiedDomainName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermMssqlServerIdentity;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get restorableDroppedDatabaseIds(): string[];
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get version(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMssqlServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMssqlServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMssqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
