import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStorageBlobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob.html#metadata DataAzurermStorageBlob#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob.html#name DataAzurermStorageBlob#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob.html#storage_account_name DataAzurermStorageBlob#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob.html#storage_container_name DataAzurermStorageBlob#storage_container_name}.
     *
     * @stability stable
     */
    readonly storageContainerName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob.html#timeouts DataAzurermStorageBlob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStorageBlobTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageBlobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob.html#read DataAzurermStorageBlob#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStorageBlobTimeoutsToTerraform(struct?: DataAzurermStorageBlobTimeoutsOutputReference | DataAzurermStorageBlobTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageBlobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageBlobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageBlobTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob.html azurerm_storage_blob}.
 *
 * @stability stable
 */
export declare class DataAzurermStorageBlob extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob.html azurerm_storage_blob} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStorageBlobConfig);
    /**
     * @stability stable
     */
    get accessTier(): string;
    /**
     * @stability stable
     */
    get contentMd5(): string;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _storageContainerName?;
    /**
     * @stability stable
     */
    get storageContainerName(): string;
    /**
     * @stability stable
     */
    set storageContainerName(value: string);
    /**
     * @stability stable
     */
    get storageContainerNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get url(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStorageBlobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStorageBlobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStorageBlobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
