import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KeyVaultAccessPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#application_id KeyVaultAccessPolicyA#application_id}.
     *
     * @stability stable
     */
    readonly applicationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#certificate_permissions KeyVaultAccessPolicyA#certificate_permissions}.
     *
     * @stability stable
     */
    readonly certificatePermissions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#key_permissions KeyVaultAccessPolicyA#key_permissions}.
     *
     * @stability stable
     */
    readonly keyPermissions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#key_vault_id KeyVaultAccessPolicyA#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#object_id KeyVaultAccessPolicyA#object_id}.
     *
     * @stability stable
     */
    readonly objectId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#secret_permissions KeyVaultAccessPolicyA#secret_permissions}.
     *
     * @stability stable
     */
    readonly secretPermissions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#storage_permissions KeyVaultAccessPolicyA#storage_permissions}.
     *
     * @stability stable
     */
    readonly storagePermissions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#tenant_id KeyVaultAccessPolicyA#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#timeouts KeyVaultAccessPolicyA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KeyVaultAccessPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface KeyVaultAccessPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#create KeyVaultAccessPolicyA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#delete KeyVaultAccessPolicyA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#read KeyVaultAccessPolicyA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html#update KeyVaultAccessPolicyA#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function keyVaultAccessPolicyTimeoutsToTerraform(struct?: KeyVaultAccessPolicyTimeoutsOutputReference | KeyVaultAccessPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class KeyVaultAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultAccessPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html azurerm_key_vault_access_policy}.
 *
 * @stability stable
 */
export declare class KeyVaultAccessPolicyA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_access_policy.html azurerm_key_vault_access_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KeyVaultAccessPolicyAConfig);
    private _applicationId?;
    /**
     * @stability stable
     */
    get applicationId(): string;
    /**
     * @stability stable
     */
    set applicationId(value: string);
    /**
     * @stability stable
     */
    resetApplicationId(): void;
    /**
     * @stability stable
     */
    get applicationIdInput(): string | undefined;
    private _certificatePermissions?;
    /**
     * @stability stable
     */
    get certificatePermissions(): string[];
    /**
     * @stability stable
     */
    set certificatePermissions(value: string[]);
    /**
     * @stability stable
     */
    resetCertificatePermissions(): void;
    /**
     * @stability stable
     */
    get certificatePermissionsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyPermissions?;
    /**
     * @stability stable
     */
    get keyPermissions(): string[];
    /**
     * @stability stable
     */
    set keyPermissions(value: string[]);
    /**
     * @stability stable
     */
    resetKeyPermissions(): void;
    /**
     * @stability stable
     */
    get keyPermissionsInput(): string[] | undefined;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    private _secretPermissions?;
    /**
     * @stability stable
     */
    get secretPermissions(): string[];
    /**
     * @stability stable
     */
    set secretPermissions(value: string[]);
    /**
     * @stability stable
     */
    resetSecretPermissions(): void;
    /**
     * @stability stable
     */
    get secretPermissionsInput(): string[] | undefined;
    private _storagePermissions?;
    /**
     * @stability stable
     */
    get storagePermissions(): string[];
    /**
     * @stability stable
     */
    set storagePermissions(value: string[]);
    /**
     * @stability stable
     */
    resetStoragePermissions(): void;
    /**
     * @stability stable
     */
    get storagePermissionsInput(): string[] | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KeyVaultAccessPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KeyVaultAccessPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KeyVaultAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
