import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StreamAnalyticsReferenceInputBlobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#date_format StreamAnalyticsReferenceInputBlob#date_format}.
     *
     * @stability stable
     */
    readonly dateFormat: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#name StreamAnalyticsReferenceInputBlob#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#path_pattern StreamAnalyticsReferenceInputBlob#path_pattern}.
     *
     * @stability stable
     */
    readonly pathPattern: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#resource_group_name StreamAnalyticsReferenceInputBlob#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#storage_account_key StreamAnalyticsReferenceInputBlob#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#storage_account_name StreamAnalyticsReferenceInputBlob#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#storage_container_name StreamAnalyticsReferenceInputBlob#storage_container_name}.
     *
     * @stability stable
     */
    readonly storageContainerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#stream_analytics_job_name StreamAnalyticsReferenceInputBlob#stream_analytics_job_name}.
     *
     * @stability stable
     */
    readonly streamAnalyticsJobName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#time_format StreamAnalyticsReferenceInputBlob#time_format}.
     *
     * @stability stable
     */
    readonly timeFormat: string;
    /**
     * serialization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#serialization StreamAnalyticsReferenceInputBlob#serialization}
     *
     * @stability stable
     */
    readonly serialization: StreamAnalyticsReferenceInputBlobSerialization;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#timeouts StreamAnalyticsReferenceInputBlob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StreamAnalyticsReferenceInputBlobTimeouts;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsReferenceInputBlobSerialization {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#encoding StreamAnalyticsReferenceInputBlob#encoding}.
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#field_delimiter StreamAnalyticsReferenceInputBlob#field_delimiter}.
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#type StreamAnalyticsReferenceInputBlob#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function streamAnalyticsReferenceInputBlobSerializationToTerraform(struct?: StreamAnalyticsReferenceInputBlobSerializationOutputReference | StreamAnalyticsReferenceInputBlobSerialization): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsReferenceInputBlobSerializationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsReferenceInputBlobSerialization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsReferenceInputBlobSerialization | undefined);
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    /**
     * @stability stable
     */
    get fieldDelimiter(): string;
    /**
     * @stability stable
     */
    set fieldDelimiter(value: string);
    /**
     * @stability stable
     */
    resetFieldDelimiter(): void;
    /**
     * @stability stable
     */
    get fieldDelimiterInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsReferenceInputBlobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#create StreamAnalyticsReferenceInputBlob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#delete StreamAnalyticsReferenceInputBlob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#read StreamAnalyticsReferenceInputBlob#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html#update StreamAnalyticsReferenceInputBlob#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function streamAnalyticsReferenceInputBlobTimeoutsToTerraform(struct?: StreamAnalyticsReferenceInputBlobTimeoutsOutputReference | StreamAnalyticsReferenceInputBlobTimeouts): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsReferenceInputBlobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsReferenceInputBlobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsReferenceInputBlobTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html azurerm_stream_analytics_reference_input_blob}.
 *
 * @stability stable
 */
export declare class StreamAnalyticsReferenceInputBlob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_reference_input_blob.html azurerm_stream_analytics_reference_input_blob} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StreamAnalyticsReferenceInputBlobConfig);
    private _dateFormat?;
    /**
     * @stability stable
     */
    get dateFormat(): string;
    /**
     * @stability stable
     */
    set dateFormat(value: string);
    /**
     * @stability stable
     */
    get dateFormatInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _pathPattern?;
    /**
     * @stability stable
     */
    get pathPattern(): string;
    /**
     * @stability stable
     */
    set pathPattern(value: string);
    /**
     * @stability stable
     */
    get pathPatternInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountKey?;
    /**
     * @stability stable
     */
    get storageAccountKey(): string;
    /**
     * @stability stable
     */
    set storageAccountKey(value: string);
    /**
     * @stability stable
     */
    get storageAccountKeyInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _storageContainerName?;
    /**
     * @stability stable
     */
    get storageContainerName(): string;
    /**
     * @stability stable
     */
    set storageContainerName(value: string);
    /**
     * @stability stable
     */
    get storageContainerNameInput(): string | undefined;
    private _streamAnalyticsJobName?;
    /**
     * @stability stable
     */
    get streamAnalyticsJobName(): string;
    /**
     * @stability stable
     */
    set streamAnalyticsJobName(value: string);
    /**
     * @stability stable
     */
    get streamAnalyticsJobNameInput(): string | undefined;
    private _timeFormat?;
    /**
     * @stability stable
     */
    get timeFormat(): string;
    /**
     * @stability stable
     */
    set timeFormat(value: string);
    /**
     * @stability stable
     */
    get timeFormatInput(): string | undefined;
    private _serialization;
    /**
     * @stability stable
     */
    get serialization(): StreamAnalyticsReferenceInputBlobSerializationOutputReference;
    /**
     * @stability stable
     */
    putSerialization(value: StreamAnalyticsReferenceInputBlobSerialization): void;
    /**
     * @stability stable
     */
    get serializationInput(): StreamAnalyticsReferenceInputBlobSerialization | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StreamAnalyticsReferenceInputBlobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StreamAnalyticsReferenceInputBlobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StreamAnalyticsReferenceInputBlobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
