import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#admin_password WindowsVirtualMachineScaleSet#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#admin_username WindowsVirtualMachineScaleSet#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#computer_name_prefix WindowsVirtualMachineScaleSet#computer_name_prefix}.
     *
     * @stability stable
     */
    readonly computerNamePrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#custom_data WindowsVirtualMachineScaleSet#custom_data}.
     *
     * @stability stable
     */
    readonly customData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#do_not_run_extensions_on_overprovisioned_machines WindowsVirtualMachineScaleSet#do_not_run_extensions_on_overprovisioned_machines}.
     *
     * @stability stable
     */
    readonly doNotRunExtensionsOnOverprovisionedMachines?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#enable_automatic_updates WindowsVirtualMachineScaleSet#enable_automatic_updates}.
     *
     * @stability stable
     */
    readonly enableAutomaticUpdates?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#encryption_at_host_enabled WindowsVirtualMachineScaleSet#encryption_at_host_enabled}.
     *
     * @stability stable
     */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#eviction_policy WindowsVirtualMachineScaleSet#eviction_policy}.
     *
     * @stability stable
     */
    readonly evictionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#extensions_time_budget WindowsVirtualMachineScaleSet#extensions_time_budget}.
     *
     * @stability stable
     */
    readonly extensionsTimeBudget?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#health_probe_id WindowsVirtualMachineScaleSet#health_probe_id}.
     *
     * @stability stable
     */
    readonly healthProbeId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#instances WindowsVirtualMachineScaleSet#instances}.
     *
     * @stability stable
     */
    readonly instances: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#license_type WindowsVirtualMachineScaleSet#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#location WindowsVirtualMachineScaleSet#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#max_bid_price WindowsVirtualMachineScaleSet#max_bid_price}.
     *
     * @stability stable
     */
    readonly maxBidPrice?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#name WindowsVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#overprovision WindowsVirtualMachineScaleSet#overprovision}.
     *
     * @stability stable
     */
    readonly overprovision?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#platform_fault_domain_count WindowsVirtualMachineScaleSet#platform_fault_domain_count}.
     *
     * @stability stable
     */
    readonly platformFaultDomainCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#priority WindowsVirtualMachineScaleSet#priority}.
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#provision_vm_agent WindowsVirtualMachineScaleSet#provision_vm_agent}.
     *
     * @stability stable
     */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#proximity_placement_group_id WindowsVirtualMachineScaleSet#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#resource_group_name WindowsVirtualMachineScaleSet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#scale_in_policy WindowsVirtualMachineScaleSet#scale_in_policy}.
     *
     * @stability stable
     */
    readonly scaleInPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#secure_boot_enabled WindowsVirtualMachineScaleSet#secure_boot_enabled}.
     *
     * @stability stable
     */
    readonly secureBootEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#single_placement_group WindowsVirtualMachineScaleSet#single_placement_group}.
     *
     * @stability stable
     */
    readonly singlePlacementGroup?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#sku WindowsVirtualMachineScaleSet#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#source_image_id WindowsVirtualMachineScaleSet#source_image_id}.
     *
     * @stability stable
     */
    readonly sourceImageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#tags WindowsVirtualMachineScaleSet#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#timezone WindowsVirtualMachineScaleSet#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#upgrade_mode WindowsVirtualMachineScaleSet#upgrade_mode}.
     *
     * @stability stable
     */
    readonly upgradeMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#vtpm_enabled WindowsVirtualMachineScaleSet#vtpm_enabled}.
     *
     * @stability stable
     */
    readonly vtpmEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#zone_balance WindowsVirtualMachineScaleSet#zone_balance}.
     *
     * @stability stable
     */
    readonly zoneBalance?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#zones WindowsVirtualMachineScaleSet#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * additional_capabilities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#additional_capabilities WindowsVirtualMachineScaleSet#additional_capabilities}
     *
     * @stability stable
     */
    readonly additionalCapabilities?: WindowsVirtualMachineScaleSetAdditionalCapabilities;
    /**
     * additional_unattend_content block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#additional_unattend_content WindowsVirtualMachineScaleSet#additional_unattend_content}
     *
     * @stability stable
     */
    readonly additionalUnattendContent?: WindowsVirtualMachineScaleSetAdditionalUnattendContent[];
    /**
     * automatic_instance_repair block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#automatic_instance_repair WindowsVirtualMachineScaleSet#automatic_instance_repair}
     *
     * @stability stable
     */
    readonly automaticInstanceRepair?: WindowsVirtualMachineScaleSetAutomaticInstanceRepair;
    /**
     * automatic_os_upgrade_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#automatic_os_upgrade_policy WindowsVirtualMachineScaleSet#automatic_os_upgrade_policy}
     *
     * @stability stable
     */
    readonly automaticOsUpgradePolicy?: WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy;
    /**
     * boot_diagnostics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#boot_diagnostics WindowsVirtualMachineScaleSet#boot_diagnostics}
     *
     * @stability stable
     */
    readonly bootDiagnostics?: WindowsVirtualMachineScaleSetBootDiagnostics;
    /**
     * data_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#data_disk WindowsVirtualMachineScaleSet#data_disk}
     *
     * @stability stable
     */
    readonly dataDisk?: WindowsVirtualMachineScaleSetDataDisk[];
    /**
     * extension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#extension WindowsVirtualMachineScaleSet#extension}
     *
     * @stability stable
     */
    readonly extension?: WindowsVirtualMachineScaleSetExtension[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#identity WindowsVirtualMachineScaleSet#identity}
     *
     * @stability stable
     */
    readonly identity?: WindowsVirtualMachineScaleSetIdentity;
    /**
     * network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#network_interface WindowsVirtualMachineScaleSet#network_interface}
     *
     * @stability stable
     */
    readonly networkInterface: WindowsVirtualMachineScaleSetNetworkInterface[];
    /**
     * os_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#os_disk WindowsVirtualMachineScaleSet#os_disk}
     *
     * @stability stable
     */
    readonly osDisk: WindowsVirtualMachineScaleSetOsDisk;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#plan WindowsVirtualMachineScaleSet#plan}
     *
     * @stability stable
     */
    readonly plan?: WindowsVirtualMachineScaleSetPlan;
    /**
     * rolling_upgrade_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#rolling_upgrade_policy WindowsVirtualMachineScaleSet#rolling_upgrade_policy}
     *
     * @stability stable
     */
    readonly rollingUpgradePolicy?: WindowsVirtualMachineScaleSetRollingUpgradePolicy;
    /**
     * secret block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#secret WindowsVirtualMachineScaleSet#secret}
     *
     * @stability stable
     */
    readonly secret?: WindowsVirtualMachineScaleSetSecret[];
    /**
     * source_image_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#source_image_reference WindowsVirtualMachineScaleSet#source_image_reference}
     *
     * @stability stable
     */
    readonly sourceImageReference?: WindowsVirtualMachineScaleSetSourceImageReference;
    /**
     * terminate_notification block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#terminate_notification WindowsVirtualMachineScaleSet#terminate_notification}
     *
     * @stability stable
     */
    readonly terminateNotification?: WindowsVirtualMachineScaleSetTerminateNotification;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#timeouts WindowsVirtualMachineScaleSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WindowsVirtualMachineScaleSetTimeouts;
    /**
     * winrm_listener block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#winrm_listener WindowsVirtualMachineScaleSet#winrm_listener}
     *
     * @stability stable
     */
    readonly winrmListener?: WindowsVirtualMachineScaleSetWinrmListener[];
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetAdditionalCapabilities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#ultra_ssd_enabled WindowsVirtualMachineScaleSet#ultra_ssd_enabled}.
     *
     * @stability stable
     */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
}
export declare function windowsVirtualMachineScaleSetAdditionalCapabilitiesToTerraform(struct?: WindowsVirtualMachineScaleSetAdditionalCapabilitiesOutputReference | WindowsVirtualMachineScaleSetAdditionalCapabilities): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetAdditionalCapabilities | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetAdditionalCapabilities | undefined);
    private _ultraSsdEnabled?;
    /**
     * @stability stable
     */
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUltraSsdEnabled(): void;
    /**
     * @stability stable
     */
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetAdditionalUnattendContent {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#content WindowsVirtualMachineScaleSet#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#setting WindowsVirtualMachineScaleSet#setting}.
     *
     * @stability stable
     */
    readonly setting: string;
}
export declare function windowsVirtualMachineScaleSetAdditionalUnattendContentToTerraform(struct?: WindowsVirtualMachineScaleSetAdditionalUnattendContent): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetAutomaticInstanceRepair {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#enabled WindowsVirtualMachineScaleSet#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#grace_period WindowsVirtualMachineScaleSet#grace_period}.
     *
     * @stability stable
     */
    readonly gracePeriod?: string;
}
export declare function windowsVirtualMachineScaleSetAutomaticInstanceRepairToTerraform(struct?: WindowsVirtualMachineScaleSetAutomaticInstanceRepairOutputReference | WindowsVirtualMachineScaleSetAutomaticInstanceRepair): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetAutomaticInstanceRepairOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetAutomaticInstanceRepair | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    /**
     * @stability stable
     */
    get gracePeriod(): string;
    /**
     * @stability stable
     */
    set gracePeriod(value: string);
    /**
     * @stability stable
     */
    resetGracePeriod(): void;
    /**
     * @stability stable
     */
    get gracePeriodInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#disable_automatic_rollback WindowsVirtualMachineScaleSet#disable_automatic_rollback}.
     *
     * @stability stable
     */
    readonly disableAutomaticRollback: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#enable_automatic_os_upgrade WindowsVirtualMachineScaleSet#enable_automatic_os_upgrade}.
     *
     * @stability stable
     */
    readonly enableAutomaticOsUpgrade: boolean | cdktf.IResolvable;
}
export declare function windowsVirtualMachineScaleSetAutomaticOsUpgradePolicyToTerraform(struct?: WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference | WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined);
    private _disableAutomaticRollback?;
    /**
     * @stability stable
     */
    get disableAutomaticRollback(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableAutomaticRollback(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get disableAutomaticRollbackInput(): boolean | cdktf.IResolvable | undefined;
    private _enableAutomaticOsUpgrade?;
    /**
     * @stability stable
     */
    get enableAutomaticOsUpgrade(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutomaticOsUpgrade(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableAutomaticOsUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetBootDiagnostics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#storage_account_uri WindowsVirtualMachineScaleSet#storage_account_uri}.
     *
     * @stability stable
     */
    readonly storageAccountUri?: string;
}
export declare function windowsVirtualMachineScaleSetBootDiagnosticsToTerraform(struct?: WindowsVirtualMachineScaleSetBootDiagnosticsOutputReference | WindowsVirtualMachineScaleSetBootDiagnostics): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetBootDiagnostics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetBootDiagnostics | undefined);
    private _storageAccountUri?;
    /**
     * @stability stable
     */
    get storageAccountUri(): string;
    /**
     * @stability stable
     */
    set storageAccountUri(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountUri(): void;
    /**
     * @stability stable
     */
    get storageAccountUriInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetDataDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#caching WindowsVirtualMachineScaleSet#caching}.
     *
     * @stability stable
     */
    readonly caching: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#create_option WindowsVirtualMachineScaleSet#create_option}.
     *
     * @stability stable
     */
    readonly createOption?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#disk_encryption_set_id WindowsVirtualMachineScaleSet#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#disk_iops_read_write WindowsVirtualMachineScaleSet#disk_iops_read_write}.
     *
     * @stability stable
     */
    readonly diskIopsReadWrite?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#disk_mbps_read_write WindowsVirtualMachineScaleSet#disk_mbps_read_write}.
     *
     * @stability stable
     */
    readonly diskMbpsReadWrite?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#disk_size_gb WindowsVirtualMachineScaleSet#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#lun WindowsVirtualMachineScaleSet#lun}.
     *
     * @stability stable
     */
    readonly lun: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#storage_account_type WindowsVirtualMachineScaleSet#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#write_accelerator_enabled WindowsVirtualMachineScaleSet#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function windowsVirtualMachineScaleSetDataDiskToTerraform(struct?: WindowsVirtualMachineScaleSetDataDisk): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetExtension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#auto_upgrade_minor_version WindowsVirtualMachineScaleSet#auto_upgrade_minor_version}.
     *
     * @stability stable
     */
    readonly autoUpgradeMinorVersion?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#automatic_upgrade_enabled WindowsVirtualMachineScaleSet#automatic_upgrade_enabled}.
     *
     * @stability stable
     */
    readonly automaticUpgradeEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#force_update_tag WindowsVirtualMachineScaleSet#force_update_tag}.
     *
     * @stability stable
     */
    readonly forceUpdateTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#name WindowsVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#protected_settings WindowsVirtualMachineScaleSet#protected_settings}.
     *
     * @stability stable
     */
    readonly protectedSettings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#provision_after_extensions WindowsVirtualMachineScaleSet#provision_after_extensions}.
     *
     * @stability stable
     */
    readonly provisionAfterExtensions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#publisher WindowsVirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#settings WindowsVirtualMachineScaleSet#settings}.
     *
     * @stability stable
     */
    readonly settings?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#type WindowsVirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#type_handler_version WindowsVirtualMachineScaleSet#type_handler_version}.
     *
     * @stability stable
     */
    readonly typeHandlerVersion: string;
}
export declare function windowsVirtualMachineScaleSetExtensionToTerraform(struct?: WindowsVirtualMachineScaleSetExtension): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#identity_ids WindowsVirtualMachineScaleSet#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#type WindowsVirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function windowsVirtualMachineScaleSetIdentityToTerraform(struct?: WindowsVirtualMachineScaleSetIdentityOutputReference | WindowsVirtualMachineScaleSetIdentity): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#tag WindowsVirtualMachineScaleSet#tag}.
     *
     * @stability stable
     */
    readonly tag: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#type WindowsVirtualMachineScaleSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function windowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagToTerraform(struct?: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#domain_name_label WindowsVirtualMachineScaleSet#domain_name_label}.
     *
     * @stability stable
     */
    readonly domainNameLabel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#idle_timeout_in_minutes WindowsVirtualMachineScaleSet#idle_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly idleTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#name WindowsVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#public_ip_prefix_id WindowsVirtualMachineScaleSet#public_ip_prefix_id}.
     *
     * @stability stable
     */
    readonly publicIpPrefixId?: string;
    /**
     * ip_tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#ip_tag WindowsVirtualMachineScaleSet#ip_tag}
     *
     * @stability stable
     */
    readonly ipTag?: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[];
}
export declare function windowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressToTerraform(struct?: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#application_gateway_backend_address_pool_ids WindowsVirtualMachineScaleSet#application_gateway_backend_address_pool_ids}.
     *
     * @stability stable
     */
    readonly applicationGatewayBackendAddressPoolIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#application_security_group_ids WindowsVirtualMachineScaleSet#application_security_group_ids}.
     *
     * @stability stable
     */
    readonly applicationSecurityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#load_balancer_backend_address_pool_ids WindowsVirtualMachineScaleSet#load_balancer_backend_address_pool_ids}.
     *
     * @stability stable
     */
    readonly loadBalancerBackendAddressPoolIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#load_balancer_inbound_nat_rules_ids WindowsVirtualMachineScaleSet#load_balancer_inbound_nat_rules_ids}.
     *
     * @stability stable
     */
    readonly loadBalancerInboundNatRulesIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#name WindowsVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#primary WindowsVirtualMachineScaleSet#primary}.
     *
     * @stability stable
     */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#subnet_id WindowsVirtualMachineScaleSet#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#version WindowsVirtualMachineScaleSet#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * public_ip_address block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#public_ip_address WindowsVirtualMachineScaleSet#public_ip_address}
     *
     * @stability stable
     */
    readonly publicIpAddress?: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[];
}
export declare function windowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationToTerraform(struct?: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetNetworkInterface {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#dns_servers WindowsVirtualMachineScaleSet#dns_servers}.
     *
     * @stability stable
     */
    readonly dnsServers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#enable_accelerated_networking WindowsVirtualMachineScaleSet#enable_accelerated_networking}.
     *
     * @stability stable
     */
    readonly enableAcceleratedNetworking?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#enable_ip_forwarding WindowsVirtualMachineScaleSet#enable_ip_forwarding}.
     *
     * @stability stable
     */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#name WindowsVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#network_security_group_id WindowsVirtualMachineScaleSet#network_security_group_id}.
     *
     * @stability stable
     */
    readonly networkSecurityGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#primary WindowsVirtualMachineScaleSet#primary}.
     *
     * @stability stable
     */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#ip_configuration WindowsVirtualMachineScaleSet#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration[];
}
export declare function windowsVirtualMachineScaleSetNetworkInterfaceToTerraform(struct?: WindowsVirtualMachineScaleSetNetworkInterface): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#option WindowsVirtualMachineScaleSet#option}.
     *
     * @stability stable
     */
    readonly option: string;
}
export declare function windowsVirtualMachineScaleSetOsDiskDiffDiskSettingsToTerraform(struct?: WindowsVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference | WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined);
    private _option?;
    /**
     * @stability stable
     */
    get option(): string;
    /**
     * @stability stable
     */
    set option(value: string);
    /**
     * @stability stable
     */
    get optionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetOsDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#caching WindowsVirtualMachineScaleSet#caching}.
     *
     * @stability stable
     */
    readonly caching: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#disk_encryption_set_id WindowsVirtualMachineScaleSet#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#disk_size_gb WindowsVirtualMachineScaleSet#disk_size_gb}.
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#storage_account_type WindowsVirtualMachineScaleSet#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#write_accelerator_enabled WindowsVirtualMachineScaleSet#write_accelerator_enabled}.
     *
     * @stability stable
     */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
     * diff_disk_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#diff_disk_settings WindowsVirtualMachineScaleSet#diff_disk_settings}
     *
     * @stability stable
     */
    readonly diffDiskSettings?: WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings;
}
export declare function windowsVirtualMachineScaleSetOsDiskToTerraform(struct?: WindowsVirtualMachineScaleSetOsDiskOutputReference | WindowsVirtualMachineScaleSetOsDisk): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetOsDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetOsDisk | undefined);
    private _caching?;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    set caching(value: string);
    /**
     * @stability stable
     */
    get cachingInput(): string | undefined;
    private _diskEncryptionSetId?;
    /**
     * @stability stable
     */
    get diskEncryptionSetId(): string;
    /**
     * @stability stable
     */
    set diskEncryptionSetId(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryptionSetId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _storageAccountType?;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
    /**
     * @stability stable
     */
    set storageAccountType(value: string);
    /**
     * @stability stable
     */
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWriteAcceleratorEnabled(): void;
    /**
     * @stability stable
     */
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diffDiskSettings;
    /**
     * @stability stable
     */
    get diffDiskSettings(): WindowsVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference;
    /**
     * @stability stable
     */
    putDiffDiskSettings(value: WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings): void;
    /**
     * @stability stable
     */
    resetDiffDiskSettings(): void;
    /**
     * @stability stable
     */
    get diffDiskSettingsInput(): WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetPlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#name WindowsVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#product WindowsVirtualMachineScaleSet#product}.
     *
     * @stability stable
     */
    readonly product: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#publisher WindowsVirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
}
export declare function windowsVirtualMachineScaleSetPlanToTerraform(struct?: WindowsVirtualMachineScaleSetPlanOutputReference | WindowsVirtualMachineScaleSetPlan): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetPlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetPlan | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetRollingUpgradePolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#max_batch_instance_percent WindowsVirtualMachineScaleSet#max_batch_instance_percent}.
     *
     * @stability stable
     */
    readonly maxBatchInstancePercent: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#max_unhealthy_instance_percent WindowsVirtualMachineScaleSet#max_unhealthy_instance_percent}.
     *
     * @stability stable
     */
    readonly maxUnhealthyInstancePercent: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#max_unhealthy_upgraded_instance_percent WindowsVirtualMachineScaleSet#max_unhealthy_upgraded_instance_percent}.
     *
     * @stability stable
     */
    readonly maxUnhealthyUpgradedInstancePercent: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#pause_time_between_batches WindowsVirtualMachineScaleSet#pause_time_between_batches}.
     *
     * @stability stable
     */
    readonly pauseTimeBetweenBatches: string;
}
export declare function windowsVirtualMachineScaleSetRollingUpgradePolicyToTerraform(struct?: WindowsVirtualMachineScaleSetRollingUpgradePolicyOutputReference | WindowsVirtualMachineScaleSetRollingUpgradePolicy): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetRollingUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetRollingUpgradePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetRollingUpgradePolicy | undefined);
    private _maxBatchInstancePercent?;
    /**
     * @stability stable
     */
    get maxBatchInstancePercent(): number;
    /**
     * @stability stable
     */
    set maxBatchInstancePercent(value: number);
    /**
     * @stability stable
     */
    get maxBatchInstancePercentInput(): number | undefined;
    private _maxUnhealthyInstancePercent?;
    /**
     * @stability stable
     */
    get maxUnhealthyInstancePercent(): number;
    /**
     * @stability stable
     */
    set maxUnhealthyInstancePercent(value: number);
    /**
     * @stability stable
     */
    get maxUnhealthyInstancePercentInput(): number | undefined;
    private _maxUnhealthyUpgradedInstancePercent?;
    /**
     * @stability stable
     */
    get maxUnhealthyUpgradedInstancePercent(): number;
    /**
     * @stability stable
     */
    set maxUnhealthyUpgradedInstancePercent(value: number);
    /**
     * @stability stable
     */
    get maxUnhealthyUpgradedInstancePercentInput(): number | undefined;
    private _pauseTimeBetweenBatches?;
    /**
     * @stability stable
     */
    get pauseTimeBetweenBatches(): string;
    /**
     * @stability stable
     */
    set pauseTimeBetweenBatches(value: string);
    /**
     * @stability stable
     */
    get pauseTimeBetweenBatchesInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetSecretCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#store WindowsVirtualMachineScaleSet#store}.
     *
     * @stability stable
     */
    readonly store: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#url WindowsVirtualMachineScaleSet#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function windowsVirtualMachineScaleSetSecretCertificateToTerraform(struct?: WindowsVirtualMachineScaleSetSecretCertificate): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetSecret {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#key_vault_id WindowsVirtualMachineScaleSet#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#certificate WindowsVirtualMachineScaleSet#certificate}
     *
     * @stability stable
     */
    readonly certificate: WindowsVirtualMachineScaleSetSecretCertificate[];
}
export declare function windowsVirtualMachineScaleSetSecretToTerraform(struct?: WindowsVirtualMachineScaleSetSecret): any;
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetSourceImageReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#offer WindowsVirtualMachineScaleSet#offer}.
     *
     * @stability stable
     */
    readonly offer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#publisher WindowsVirtualMachineScaleSet#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#sku WindowsVirtualMachineScaleSet#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#version WindowsVirtualMachineScaleSet#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
export declare function windowsVirtualMachineScaleSetSourceImageReferenceToTerraform(struct?: WindowsVirtualMachineScaleSetSourceImageReferenceOutputReference | WindowsVirtualMachineScaleSetSourceImageReference): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetSourceImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetSourceImageReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetSourceImageReference | undefined);
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetTerminateNotification {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#enabled WindowsVirtualMachineScaleSet#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#timeout WindowsVirtualMachineScaleSet#timeout}.
     *
     * @stability stable
     */
    readonly timeout?: string;
}
export declare function windowsVirtualMachineScaleSetTerminateNotificationToTerraform(struct?: WindowsVirtualMachineScaleSetTerminateNotificationOutputReference | WindowsVirtualMachineScaleSetTerminateNotification): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetTerminateNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetTerminateNotification | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetTerminateNotification | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): string;
    /**
     * @stability stable
     */
    set timeout(value: string);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#create WindowsVirtualMachineScaleSet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#delete WindowsVirtualMachineScaleSet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#read WindowsVirtualMachineScaleSet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#update WindowsVirtualMachineScaleSet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function windowsVirtualMachineScaleSetTimeoutsToTerraform(struct?: WindowsVirtualMachineScaleSetTimeoutsOutputReference | WindowsVirtualMachineScaleSetTimeouts): any;
/**
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): WindowsVirtualMachineScaleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: WindowsVirtualMachineScaleSetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface WindowsVirtualMachineScaleSetWinrmListener {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#certificate_url WindowsVirtualMachineScaleSet#certificate_url}.
     *
     * @stability stable
     */
    readonly certificateUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html#protocol WindowsVirtualMachineScaleSet#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function windowsVirtualMachineScaleSetWinrmListenerToTerraform(struct?: WindowsVirtualMachineScaleSetWinrmListener): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html azurerm_windows_virtual_machine_scale_set}.
 *
 * @stability stable
 */
export declare class WindowsVirtualMachineScaleSet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/windows_virtual_machine_scale_set.html azurerm_windows_virtual_machine_scale_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WindowsVirtualMachineScaleSetConfig);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _computerNamePrefix?;
    /**
     * @stability stable
     */
    get computerNamePrefix(): string;
    /**
     * @stability stable
     */
    set computerNamePrefix(value: string);
    /**
     * @stability stable
     */
    resetComputerNamePrefix(): void;
    /**
     * @stability stable
     */
    get computerNamePrefixInput(): string | undefined;
    private _customData?;
    /**
     * @stability stable
     */
    get customData(): string;
    /**
     * @stability stable
     */
    set customData(value: string);
    /**
     * @stability stable
     */
    resetCustomData(): void;
    /**
     * @stability stable
     */
    get customDataInput(): string | undefined;
    private _doNotRunExtensionsOnOverprovisionedMachines?;
    /**
     * @stability stable
     */
    get doNotRunExtensionsOnOverprovisionedMachines(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set doNotRunExtensionsOnOverprovisionedMachines(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDoNotRunExtensionsOnOverprovisionedMachines(): void;
    /**
     * @stability stable
     */
    get doNotRunExtensionsOnOverprovisionedMachinesInput(): boolean | cdktf.IResolvable | undefined;
    private _enableAutomaticUpdates?;
    /**
     * @stability stable
     */
    get enableAutomaticUpdates(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutomaticUpdates(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutomaticUpdates(): void;
    /**
     * @stability stable
     */
    get enableAutomaticUpdatesInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionAtHostEnabled?;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncryptionAtHostEnabled(): void;
    /**
     * @stability stable
     */
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    /**
     * @stability stable
     */
    get evictionPolicy(): string;
    /**
     * @stability stable
     */
    set evictionPolicy(value: string);
    /**
     * @stability stable
     */
    resetEvictionPolicy(): void;
    /**
     * @stability stable
     */
    get evictionPolicyInput(): string | undefined;
    private _extensionsTimeBudget?;
    /**
     * @stability stable
     */
    get extensionsTimeBudget(): string;
    /**
     * @stability stable
     */
    set extensionsTimeBudget(value: string);
    /**
     * @stability stable
     */
    resetExtensionsTimeBudget(): void;
    /**
     * @stability stable
     */
    get extensionsTimeBudgetInput(): string | undefined;
    private _healthProbeId?;
    /**
     * @stability stable
     */
    get healthProbeId(): string;
    /**
     * @stability stable
     */
    set healthProbeId(value: string);
    /**
     * @stability stable
     */
    resetHealthProbeId(): void;
    /**
     * @stability stable
     */
    get healthProbeIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instances?;
    /**
     * @stability stable
     */
    get instances(): number;
    /**
     * @stability stable
     */
    set instances(value: number);
    /**
     * @stability stable
     */
    get instancesInput(): number | undefined;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxBidPrice?;
    /**
     * @stability stable
     */
    get maxBidPrice(): number;
    /**
     * @stability stable
     */
    set maxBidPrice(value: number);
    /**
     * @stability stable
     */
    resetMaxBidPrice(): void;
    /**
     * @stability stable
     */
    get maxBidPriceInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _overprovision?;
    /**
     * @stability stable
     */
    get overprovision(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set overprovision(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOverprovision(): void;
    /**
     * @stability stable
     */
    get overprovisionInput(): boolean | cdktf.IResolvable | undefined;
    private _platformFaultDomainCount?;
    /**
     * @stability stable
     */
    get platformFaultDomainCount(): number;
    /**
     * @stability stable
     */
    set platformFaultDomainCount(value: number);
    /**
     * @stability stable
     */
    resetPlatformFaultDomainCount(): void;
    /**
     * @stability stable
     */
    get platformFaultDomainCountInput(): number | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    set priority(value: string);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): string | undefined;
    private _provisionVmAgent?;
    /**
     * @stability stable
     */
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProvisionVmAgent(): void;
    /**
     * @stability stable
     */
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _scaleInPolicy?;
    /**
     * @stability stable
     */
    get scaleInPolicy(): string;
    /**
     * @stability stable
     */
    set scaleInPolicy(value: string);
    /**
     * @stability stable
     */
    resetScaleInPolicy(): void;
    /**
     * @stability stable
     */
    get scaleInPolicyInput(): string | undefined;
    private _secureBootEnabled?;
    /**
     * @stability stable
     */
    get secureBootEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set secureBootEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSecureBootEnabled(): void;
    /**
     * @stability stable
     */
    get secureBootEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _singlePlacementGroup?;
    /**
     * @stability stable
     */
    get singlePlacementGroup(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set singlePlacementGroup(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSinglePlacementGroup(): void;
    /**
     * @stability stable
     */
    get singlePlacementGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _sourceImageId?;
    /**
     * @stability stable
     */
    get sourceImageId(): string;
    /**
     * @stability stable
     */
    set sourceImageId(value: string);
    /**
     * @stability stable
     */
    resetSourceImageId(): void;
    /**
     * @stability stable
     */
    get sourceImageIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    /**
     * @stability stable
     */
    get uniqueId(): string;
    private _upgradeMode?;
    /**
     * @stability stable
     */
    get upgradeMode(): string;
    /**
     * @stability stable
     */
    set upgradeMode(value: string);
    /**
     * @stability stable
     */
    resetUpgradeMode(): void;
    /**
     * @stability stable
     */
    get upgradeModeInput(): string | undefined;
    private _vtpmEnabled?;
    /**
     * @stability stable
     */
    get vtpmEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vtpmEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVtpmEnabled(): void;
    /**
     * @stability stable
     */
    get vtpmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneBalance?;
    /**
     * @stability stable
     */
    get zoneBalance(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneBalance(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneBalance(): void;
    /**
     * @stability stable
     */
    get zoneBalanceInput(): boolean | cdktf.IResolvable | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _additionalCapabilities;
    /**
     * @stability stable
     */
    get additionalCapabilities(): WindowsVirtualMachineScaleSetAdditionalCapabilitiesOutputReference;
    /**
     * @stability stable
     */
    putAdditionalCapabilities(value: WindowsVirtualMachineScaleSetAdditionalCapabilities): void;
    /**
     * @stability stable
     */
    resetAdditionalCapabilities(): void;
    /**
     * @stability stable
     */
    get additionalCapabilitiesInput(): WindowsVirtualMachineScaleSetAdditionalCapabilities | undefined;
    private _additionalUnattendContent?;
    /**
     * @stability stable
     */
    get additionalUnattendContent(): WindowsVirtualMachineScaleSetAdditionalUnattendContent[];
    /**
     * @stability stable
     */
    set additionalUnattendContent(value: WindowsVirtualMachineScaleSetAdditionalUnattendContent[]);
    /**
     * @stability stable
     */
    resetAdditionalUnattendContent(): void;
    /**
     * @stability stable
     */
    get additionalUnattendContentInput(): WindowsVirtualMachineScaleSetAdditionalUnattendContent[] | undefined;
    private _automaticInstanceRepair;
    /**
     * @stability stable
     */
    get automaticInstanceRepair(): WindowsVirtualMachineScaleSetAutomaticInstanceRepairOutputReference;
    /**
     * @stability stable
     */
    putAutomaticInstanceRepair(value: WindowsVirtualMachineScaleSetAutomaticInstanceRepair): void;
    /**
     * @stability stable
     */
    resetAutomaticInstanceRepair(): void;
    /**
     * @stability stable
     */
    get automaticInstanceRepairInput(): WindowsVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    private _automaticOsUpgradePolicy;
    /**
     * @stability stable
     */
    get automaticOsUpgradePolicy(): WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference;
    /**
     * @stability stable
     */
    putAutomaticOsUpgradePolicy(value: WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy): void;
    /**
     * @stability stable
     */
    resetAutomaticOsUpgradePolicy(): void;
    /**
     * @stability stable
     */
    get automaticOsUpgradePolicyInput(): WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined;
    private _bootDiagnostics;
    /**
     * @stability stable
     */
    get bootDiagnostics(): WindowsVirtualMachineScaleSetBootDiagnosticsOutputReference;
    /**
     * @stability stable
     */
    putBootDiagnostics(value: WindowsVirtualMachineScaleSetBootDiagnostics): void;
    /**
     * @stability stable
     */
    resetBootDiagnostics(): void;
    /**
     * @stability stable
     */
    get bootDiagnosticsInput(): WindowsVirtualMachineScaleSetBootDiagnostics | undefined;
    private _dataDisk?;
    /**
     * @stability stable
     */
    get dataDisk(): WindowsVirtualMachineScaleSetDataDisk[];
    /**
     * @stability stable
     */
    set dataDisk(value: WindowsVirtualMachineScaleSetDataDisk[]);
    /**
     * @stability stable
     */
    resetDataDisk(): void;
    /**
     * @stability stable
     */
    get dataDiskInput(): WindowsVirtualMachineScaleSetDataDisk[] | undefined;
    private _extension?;
    /**
     * @stability stable
     */
    get extension(): WindowsVirtualMachineScaleSetExtension[];
    /**
     * @stability stable
     */
    set extension(value: WindowsVirtualMachineScaleSetExtension[]);
    /**
     * @stability stable
     */
    resetExtension(): void;
    /**
     * @stability stable
     */
    get extensionInput(): WindowsVirtualMachineScaleSetExtension[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): WindowsVirtualMachineScaleSetIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: WindowsVirtualMachineScaleSetIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): WindowsVirtualMachineScaleSetIdentity | undefined;
    private _networkInterface?;
    /**
     * @stability stable
     */
    get networkInterface(): WindowsVirtualMachineScaleSetNetworkInterface[];
    /**
     * @stability stable
     */
    set networkInterface(value: WindowsVirtualMachineScaleSetNetworkInterface[]);
    /**
     * @stability stable
     */
    get networkInterfaceInput(): WindowsVirtualMachineScaleSetNetworkInterface[] | undefined;
    private _osDisk;
    /**
     * @stability stable
     */
    get osDisk(): WindowsVirtualMachineScaleSetOsDiskOutputReference;
    /**
     * @stability stable
     */
    putOsDisk(value: WindowsVirtualMachineScaleSetOsDisk): void;
    /**
     * @stability stable
     */
    get osDiskInput(): WindowsVirtualMachineScaleSetOsDisk | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): WindowsVirtualMachineScaleSetPlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: WindowsVirtualMachineScaleSetPlan): void;
    /**
     * @stability stable
     */
    resetPlan(): void;
    /**
     * @stability stable
     */
    get planInput(): WindowsVirtualMachineScaleSetPlan | undefined;
    private _rollingUpgradePolicy;
    /**
     * @stability stable
     */
    get rollingUpgradePolicy(): WindowsVirtualMachineScaleSetRollingUpgradePolicyOutputReference;
    /**
     * @stability stable
     */
    putRollingUpgradePolicy(value: WindowsVirtualMachineScaleSetRollingUpgradePolicy): void;
    /**
     * @stability stable
     */
    resetRollingUpgradePolicy(): void;
    /**
     * @stability stable
     */
    get rollingUpgradePolicyInput(): WindowsVirtualMachineScaleSetRollingUpgradePolicy | undefined;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): WindowsVirtualMachineScaleSetSecret[];
    /**
     * @stability stable
     */
    set secret(value: WindowsVirtualMachineScaleSetSecret[]);
    /**
     * @stability stable
     */
    resetSecret(): void;
    /**
     * @stability stable
     */
    get secretInput(): WindowsVirtualMachineScaleSetSecret[] | undefined;
    private _sourceImageReference;
    /**
     * @stability stable
     */
    get sourceImageReference(): WindowsVirtualMachineScaleSetSourceImageReferenceOutputReference;
    /**
     * @stability stable
     */
    putSourceImageReference(value: WindowsVirtualMachineScaleSetSourceImageReference): void;
    /**
     * @stability stable
     */
    resetSourceImageReference(): void;
    /**
     * @stability stable
     */
    get sourceImageReferenceInput(): WindowsVirtualMachineScaleSetSourceImageReference | undefined;
    private _terminateNotification;
    /**
     * @stability stable
     */
    get terminateNotification(): WindowsVirtualMachineScaleSetTerminateNotificationOutputReference;
    /**
     * @stability stable
     */
    putTerminateNotification(value: WindowsVirtualMachineScaleSetTerminateNotification): void;
    /**
     * @stability stable
     */
    resetTerminateNotification(): void;
    /**
     * @stability stable
     */
    get terminateNotificationInput(): WindowsVirtualMachineScaleSetTerminateNotification | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): WindowsVirtualMachineScaleSetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WindowsVirtualMachineScaleSetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WindowsVirtualMachineScaleSetTimeouts | undefined;
    private _winrmListener?;
    /**
     * @stability stable
     */
    get winrmListener(): WindowsVirtualMachineScaleSetWinrmListener[];
    /**
     * @stability stable
     */
    set winrmListener(value: WindowsVirtualMachineScaleSetWinrmListener[]);
    /**
     * @stability stable
     */
    resetWinrmListener(): void;
    /**
     * @stability stable
     */
    get winrmListenerInput(): WindowsVirtualMachineScaleSetWinrmListener[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
