import * as cdk from '@aws-cdk/core';
/**
 * A Token postprocesser for policy documents
 *
 * Removes duplicate statements, merges statements, and assign Sids if necessary
 *
 * Because policy documents can contain all kinds of crazy things,
 * we do all the necessary work here after the document has been mostly resolved
 * into a predictable CloudFormation form.
 */
export declare class PostProcessPolicyDocument implements cdk.IPostProcessor {
    private readonly autoAssignSids;
    private readonly minimize;
    constructor(autoAssignSids: boolean, minimize: boolean);
    postProcess(input: any, _context: cdk.IResolveContext): any;
}
export declare type IamValue = string | Record<string, any> | Array<string | Record<string, any>>;
export interface StatementSchema {
    readonly Sid?: string;
    readonly Effect?: string;
    readonly Principal?: Record<string, IamValue>;
    readonly NotPrincipal?: Record<string, IamValue>;
    readonly Resource?: IamValue;
    readonly NotResource?: IamValue;
    readonly Action?: IamValue;
    readonly NotAction?: IamValue;
    readonly Condition?: unknown;
}
export declare function normalizeStatement(s: StatementSchema): any;
