from __future__ import annotations

from avilla.core.context import Context
from avilla.core.event import MetadataModified, ModifyDetail
from avilla.core.selector import Selector
from avilla.elizabeth.collector.connection import ConnectionCollector
from avilla.standard.core.inputting import InputtingStatus
from avilla.standard.core.profile import Nick, Summary

from . import ElizabethEventParse


class ElizabethEventFriendPerform((m := ConnectionCollector())._):
    m.post_applying = True

    @m.entity(ElizabethEventParse, "FriendInputStatusChangedEvent")
    async def friend_input_status_changed(self, raw_event: dict):
        account_route = Selector().land("qq").account(str(self.connection.account_id))
        account = self.protocol.avilla.accounts[account_route].account
        land = Selector().land("qq")
        friend = land.friend(str(raw_event["friend"]["id"]))
        context = Context(
            account,
            friend,
            friend,
            friend,
            account_route,
        )
        sender = raw_event["friend"]
        context._collect_metadatas(
            friend,
            Nick(sender["nickname"], sender["remark"] or sender["nickname"], None),
            Summary(sender["nickname"], "a friend contact assigned to this account"),
        )
        return MetadataModified(
            context,
            friend,
            InputtingStatus,
            {
                InputtingStatus.inh(lambda x: x.value): ModifyDetail(
                    "update", raw_event["inputting"], not raw_event["inputting"]
                )
            },
            operator=friend,
            scene=friend,
        )

    @m.entity(ElizabethEventParse, "FriendNickChangedEvent")
    async def friend_nick_changed(self, raw_event: dict):
        account_route = Selector().land("qq").account(str(self.connection.account_id))
        account = self.protocol.avilla.accounts[account_route].account
        land = Selector().land("qq")
        friend = land.friend(str(raw_event["friend"]["id"]))
        context = Context(
            account,
            friend,
            friend,
            friend,
            account_route,
        )
        sender = raw_event["friend"]
        context._collect_metadatas(
            friend,
            Nick(sender["nickname"], sender["remark"] or sender["nickname"], None),
            Summary(sender["nickname"], "a friend contact assigned to this account"),
        )
        return MetadataModified(
            context,
            friend,
            Nick,
            {Nick.inh(lambda x: x.name): ModifyDetail("update", raw_event["to"], raw_event["from"])},
            operator=friend,
            scene=friend,
        )
