# Copyright 2020, 2021, 2022, 2023, 2024 Francesco Biscani (bluescarni@gmail.com), Dario Izzo (dario.izzo@gmail.com)
#
# This file is part of the heyoka.py library.
#
# This Source Code Form is subject to the terms of the Mozilla
# Public License v. 2.0. If a copy of the MPL was not distributed
# with this file, You can obtain one at http://mozilla.org/MPL/2.0/.

# NOTE: tle data downloaded from space-track.org on July 5 2024:
# https://www.space-track.org/#recent

sgp4_test_tle = r"""0 VANGUARD 1
1 00005U 58002B   24187.49270102  .00000872  00000-0  11018-2 0  9997
2 00005  34.2494 350.7565 1842018 170.0536 194.2361 10.85456480365911
0 VANGUARD 2
1 00011U 59001A   24187.51496924  .00001069  00000-0  55482-3 0  9992
2 00011  32.8711 255.0638 1455653 332.1888  20.7734 11.88503118450690
0 VANGUARD R/B
1 00012U 59001B   24187.42856915  .00001931  00000-0  11245-2 0  9999
2 00012  32.9053 210.6531 1654775 300.3083  44.3933 11.46595143449526
0 VANGUARD R/B
1 00016U 58002A   24187.36204217  .00000350  00000-0  48865-3 0  9991
2 00016  34.2616 203.5974 2024942 354.6665   3.5038 10.49310747614128
0 VANGUARD 3
1 00020U 59007A   24187.40000270  .00003333  00000-0  13422-2 0  9994
2 00020  33.3495 304.8238 1650157 204.7865 146.3750 11.59045699401882
0 EXPLORER 7
1 00022U 59009A   24187.54249835  .00012422  00000-0  71079-3 0  9997
2 00022  50.2797 325.1969 0111908 180.9320 179.1440 15.07778085692173
0 TIROS 1
1 00029U 60002B   24187.33984709  .00001080  00000-0  18290-3 0  9996
2 00029  48.3775 162.9194 0022817  85.1744 275.1773 14.76446436436840
0 TRANSIT 2A
1 00045U 60007A   24187.45810325  .00000504  00000-0  14841-3 0  9992
2 00045  66.6943  81.3521 0257384 317.3173  40.8180 14.34783636277898
0 SOLRAD 1 (GREB)
1 00046U 60007B   24187.58585517  .00002292  00000-0  46268-3 0  9993
2 00046  66.6912   4.9995 0194928 108.0242 254.2215 14.52078523353568
0 THOR ABLESTAR R/B
1 00047U 60007C   24187.34132859  .00000949  00000-0  22663-3 0  9995
2 00047  66.6640 157.7932 0230143 299.6504  58.1857 14.43628807347981
0 DELTA 1 R/B
1 00050U 60009B   24187.39973650 -.00000086  00000-0  20217-5 0  9996
2 00050  47.2284 211.0464 0112646  53.2976 307.8102 12.20141435850797
0 ECHO 1 DEB (METAL OBJ)
1 00051U 60009C   24187.41488964 -.00000157  00000-0 -70502-3 0  9999
2 00051  47.2132  91.7606 0106592 240.8707 118.1377 12.18328911844399
0 ECHO 1 DEB (METAL OBJ)
1 00053U 60009E   24187.20145028 -.00000075  00000-0  10407-3 0  9995
2 00053  47.2790  18.5010 0100182 130.7010 230.2533 12.17339113848692
0 COURIER 1B
1 00058U 60013A   24187.32168006  .00000102  00000-0  29043-4 0  9996
2 00058  28.3252 151.7324 0164941  73.3517 288.5067 13.46379670138050
0 THOR ABLESTAR R/B
1 00059U 60013B   24187.35845604  .00000120  00000-0  44723-4 0  9998
2 00059  28.2456 180.9915 0189152  99.7153 262.4809 13.53079499146682
0 SCOUT X-1 R/B
1 00082U 61004B   24187.50382248  .00000729  00000-0  65694-3 0  9996
2 00082  38.8526 121.5730 1164672  22.7553 342.0730 12.26813251989369
0 SCOUT X-1 DEB
1 00085U 61004C   24187.41912690  .00011066  00000-0  14500-2 0  9994
2 00085  38.7385 267.7207 0261386  85.1110 277.9436 14.59014981143055
0 EXPLORER 11
1 00107U 61013A   24187.10692159  .00004592  00000-0  57428-3 0  9993
2 00107  28.7888  85.0343 0520338 345.8367  12.8102 14.15486995175235
0 THOR ABLE DEB (YO)
1 00115U 60002D   24186.80432155  .00003349  00000-0  36616-3 0  9998
2 00115  48.1651 346.9714 0031751 300.3861  59.3916 14.89777014411564
0 TRANSIT 4A
1 00116U 61015A   24187.49099637  .00000071  00000-0  11334-3 0  9993
2 00116  66.8076 191.9951 0069861  48.5095 312.1952 13.92055942197638
0 SOLRAD 3/INJUN 1
1 00117U 61015B   24187.61582719  .00000010  00000-0  68644-4 0  9996
2 00117  66.8136 299.6972 0070957  74.2315 286.6574 13.90030053195158
0 THOR ABLESTAR R/B
1 00118U 61015C   24187.61873299  .00000215  00000-0  18685-3 0  9999
2 00118  66.7646  34.9856 0076651  49.8289 310.9474 14.02221977216357
0 THOR ABLESTAR DEB
1 00119U 61015D   24187.11230656  .00000837  00000-0  37296-3 0  9998
2 00119  66.7278  78.7560 0095951  53.4640 307.5242 14.25211853256753
0 THOR ABLESTAR DEB
1 00120U 61015E   24187.55666051  .00000853  00000-0  35688-3 0  9991
2 00120  66.7052 129.2493 0111661 163.8965 196.5729 14.27494617246663
0 THOR ABLESTAR DEB
1 00121U 61015F   24187.56535430  .00000102  00000-0  11907-3 0  9994
2 00121  66.7484  10.2069 0089079 145.9514 214.7329 13.99970488226748
0 THOR ABLESTAR DEB
1 00122U 61015G   24187.41640092  .00008973  00000-0  11538-2 0  9993
2 00122  66.7490  75.2311 0050232  47.7878 312.7493 14.80658449288096
0 THOR ABLESTAR DEB
1 00123U 61015H   24187.33509917  .00001453  00000-0  46639-3 0  9992
2 00123  66.6847 164.2831 0103881  69.9532 291.2717 14.39296345276982
0 THOR ABLESTAR DEB
1 00124U 61015J   24187.57382884  .00001015  00000-0  38498-3 0  9999
2 00124  66.5452 331.8492 0081290 266.7945  92.3851 14.33369293256831
0 THOR ABLESTAR DEB
1 00125U 61015K   24187.39285009  .00000702  00000-0  45727-3 0  9996
2 00125  66.8759 270.1128 0079634 229.5964 129.8157 14.06644767217107
0 THOR ABLESTAR DEB
1 00126U 61015L   24187.47238640  .00002349  00000-0  75475-3 0  9997
2 00126  66.7095 194.8753 0056025  58.1517 302.5022 14.40228624261901
0 THOR ABLESTAR DEB
1 00127U 61015M   24187.10820552  .00002397  00000-0  71406-3 0  9990
2 00127  66.8312  48.7185 0070990 202.4676 157.3318 14.43351846263865
0 THOR ABLESTAR DEB
1 00128U 61015N   24187.32173244  .00000171  00000-0  16008-3 0  9999
2 00128  66.6738 159.6600 0086271  86.7012 274.3936 14.01621887215295
0 THOR ABLESTAR DEB
1 00130U 61015Q   24187.43064972  .00000108  00000-0  12527-3 0  9993
2 00130  66.7692 216.5896 0078784  67.6485 293.2923 13.99078565211871
0 THOR ABLESTAR DEB
1 00131U 61015R   24187.38166891  .00000174  00000-0  16324-3 0  9993
2 00131  66.7355  77.8106 0084401 210.3431 149.2753 14.01261500203713
0 THOR ABLESTAR DEB
1 00132U 61015S   24187.57377737  .00000028  00000-0  77950-4 0  9999
2 00132  66.6610 290.6847 0080557 306.5145  52.8534 13.94554686204439
0 THOR ABLESTAR DEB
1 00133U 61015T   24187.50512408  .00001059  00000-0  52131-3 0  9997
2 00133  67.1137 226.2566 0055520 338.2247  21.6489 14.20564732232291
0 THOR ABLESTAR DEB
1 00134U 61015U   24187.60179793  .00000139  00000-0  15006-3 0  9993
2 00134  66.8813 358.3205 0083845 340.3955  19.3909 13.97308780206268
0 THOR ABLESTAR DEB
1 00136U 61015W   24187.58726301  .00001935  00000-0  65921-3 0  9991
2 00136  67.5314 309.8862 0055277 318.5901  41.1024 14.37580223254285
0 THOR ABLESTAR DEB
1 00138U 61015Y   24187.00102805  .00000734  00000-0  51612-3 0  9995
2 00138  67.1554  54.0293 0036735 309.6972  50.0878 14.03272207202847
0 THOR ABLESTAR DEB
1 00141U 61015AB  24187.60767641  .00000506  00000-0  48443-3 0  9995
2 00141  66.5903 349.9481 0052230 160.2940 200.0170 13.88015442173028
0 THOR ABLESTAR DEB
1 00144U 61015AE  24187.54696172  .00000400  00000-0  37958-3 0  9993
2 00144  66.5009 348.4454 0034296  95.6787 264.8201 13.90933645185645
0 THOR ABLESTAR DEB
1 00145U 61015AF  24187.58509050  .00000444  00000-0  33474-3 0  9993
2 00145  66.9278 346.6151 0056129 102.7674 257.9693 14.02357442216895
0 THOR ABLESTAR DEB
1 00147U 61015AH  24187.33963455  .00001135  00000-0  54492-3 0  9992
2 00147  66.6183  48.3741 0059081 221.6879 137.9704 14.21654079233164
0 THOR ABLESTAR DEB
1 00148U 61015AJ  24187.41855982  .00001522  00000-0  84738-3 0  9993
2 00148  65.7720 183.2960 0152821 322.2807  36.7634 14.08144290658645
0 THOR ABLESTAR DEB
1 00150U 61015AL  24187.47183915  .00000521  00000-0  54269-3 0  9996
2 00150  66.2461 217.7181 0066824 303.8902  55.5822 13.82620730 10056
0 THOR ABLESTAR DEB
1 00152U 61015AN  24187.59046120  .00000433  00000-0  25830-3 0  9991
2 00152  66.5955 332.3101 0157325 318.0988  40.8144 14.10370565225685
0 THOR ABLESTAR DEB
1 00154U 61015AQ  24187.27012996  .00000477  00000-0  33394-3 0  9994
2 00154  66.6574 146.3909 0079084 148.6167 211.9674 14.05432466216553
0 THOR ABLESTAR DEB
1 00155U 61015AR  24187.59262112  .00003954  00000-0  11454-2 0  9992
2 00155  66.8797  12.8658 0033882  92.3667 268.1320 14.45097856257985
0 THOR ABLESTAR DEB
1 00158U 61015AU  24187.31514798  .00000389  00000-0  11270-2 0  9990
2 00158  67.0722 163.3173 0613558 315.7985  39.5528 12.65832130915233
0 THOR ABLESTAR DEB
1 00159U 61015AV  24187.55512321  .00000283  00000-0  82820-3 0  9990
2 00159  65.5274   7.7824 0357705  69.6233 294.2831 13.02628912988143
0 TIROS 3
1 00162U 61017A   24187.57464674  .00000249  00000-0  11649-3 0  9998
2 00162  47.9011   4.4441 0044602 208.3901 151.4561 14.44714302288853
0 MIDAS 3
1 00163U 61018A   24187.50160857 -.00000001  00000-0 -80021-3 0  9997
2 00163  91.0934 174.8875 0097817 216.3257 143.0947  8.91835886 50566
0 DELTA 1 DEB (YO)
1 00167U 61017D   24187.34057054  .00000423  00000-0  24190-3 0  9997
2 00167  47.8462 298.2510 0090620  75.7615 285.3313 14.23472006263232
0 THOR ABLESTAR DEB
1 00172U 61015AY  24187.56499445  .00000468  00000-0  69237-3 0  9999
2 00172  67.0690 356.6294 0138815 212.9287 146.3075 13.58470275108425
0 THOR ABLESTAR DEB
1 00177U 61015BB  24187.44528079 -.00000136  00000-0 -26244-4 0  9993
2 00177  66.6559 221.9231 0115769 229.1622 129.9388 14.14196968240495
0 THOR ABLESTAR DEB
1 00178U 61015BC  24187.55891505  .00000123  00000-0  15016-3 0  9991
2 00178  66.8664 299.7535 0075755 148.0037 212.5676 13.92734138198138
0 MIDAS 3 DEB
1 00188U 61018C   24187.36475351  .00000006  00000-0  15659-2 0  9993
2 00188  91.0892 177.5605 0134200  78.8446 282.7483  8.93833869 54590
0 MIDAS 4
1 00192U 61028A   24187.55193150 -.00000002  00000-0  91693-3 0  9994
2 00192  95.8689  74.0077 0137593 304.6639  54.1311  8.67770640986444
0 MIDAS 4 DEB
1 00194U 61028C   24187.18525606  .00000031  00000-0  14132-1 0  9992
2 00194  95.8628  98.0900 0391586 164.4861 196.8392  8.70077717991340
0 MIDAS 4 DEB
1 00195U 61028D   24187.05686906  .00000026  00000-0  13644-1 0  9991
2 00195  95.8702  55.2168 0122758  39.2261 321.7411  8.65614973981436
0 MIDAS 3 DEB
1 00196U 61018D   24187.36252550  .00000000  00000-0 -29884-3 0  9997
2 00196  91.0987 173.1241 0118015  17.8969 342.6009  8.89687009 45342
0 TRANSIT 4B
1 00202U 61031A   24187.53149888  .00000120  00000-0  11573-3 0  9996
2 00202  32.4393 326.6210 0101204 209.5335 149.9540 13.63673905123792
0 THOR ABLESTAR R/B
1 00204U 61031C   24187.26061263  .00000054  00000-0  36762-4 0  9992
2 00204  32.4445  31.1379 0099063 293.0528  65.9674 13.64986033125693
0 TRAAC
1 00205U 61031B   24187.46612005  .00000047  00000-0  31827-4 0  9990
2 00205  32.4405 115.4732 0102028 338.0169  21.6096 13.62496401121940
0 THOR ABLESTAR DEB
1 00210U 61015BE  24187.55813727  .00000682  00000-0  63749-3 0  9994
2 00210  66.4586 320.4030 0040669  32.9892 327.3707 13.87634775166609
0 THOR ABLESTAR DEB
1 00223U 61015BK  24187.56109746  .00000044  00000-0  97279-4 0  9996
2 00223  66.8895 247.4213 0061810 115.0689 245.6822 13.88841174192040
0 THOR ABLESTAR DEB
1 00224U 61015BL  24187.39275656  .00001039  00000-0  62088-3 0  9996
2 00224  66.7350 155.6691 0065143 182.2500 342.0973 14.10102018212075
0 THOR ABLESTAR DEB
1 00225U 61015BM  24187.56959009  .00001680  00000-0  58854-3 0  9995
2 00225  66.8006 323.0310 0101203  28.8157 331.8481 14.34679537255488
0 TIROS 4
1 00226U 62002A   24187.45258335  .00000327  00000-0  13323-3 0  9994
2 00226  48.2977 351.2255 0077389 200.3584 159.4224 14.46413982265381
0 DELTA 1 DEB (YO)
1 00227U 62002B   24187.36512106  .00000240  00000-0  12001-3 0  9990
2 00227  48.1483 306.0432 0129434   6.4845 353.7689 14.39488535241692
0 DELTA 1 DEB (YO)
1 00228U 62002C   24186.86139606  .00012162  00000-0  65333-3 0  9997
2 00228  48.4268  30.9159 0009074  75.5431 284.6505 15.15139962333874
0 THOR ABLESTAR DEB
1 00230U 61015BN  24187.60921787  .00000071  00000-0  10347-3 0  9996
2 00230  66.8845 357.7720 0097608 322.7440  36.6896 13.96468368206388
0 THOR ABLESTAR DEB
1 00232U 61015BQ  24187.41806692  .00000308  00000-0  25750-3 0  9991
2 00232  66.8190 178.2151 0065229 254.6981 104.6887 14.00061690207328
0 THOR ABLESTAR DEB
1 00233U 61015BR  24187.33263520  .00015857  00000-0  19761-2 0  9999
2 00233  66.8436  47.6398 0031694 290.2529  69.5190 14.82216667273041
0 THOR ABLESTAR DEB
1 00234U 61015BS  24187.13062703  .00000380  00000-0  28654-3 0  9995
2 00234  66.8760 132.2158 0078225 285.3140  73.9310 14.03192220211497
0 THOR ABLESTAR DEB
1 00235U 61015BT  24187.49206941  .00000862  00000-0  47244-3 0  9990
2 00235  66.9546 256.9039 0159821 152.9975 207.9545 14.10072120220932
0 THOR ABLESTAR DEB
1 00243U 61015BY  24187.60758019  .00001387  00000-0  99859-3 0  9992
2 00243  66.4644 355.3024 0030930 201.8983 158.0777 13.99653089183616
0 THOR ABLESTAR DEB
1 00244U 61015BZ  24187.43975455  .00000173  00000-0  18049-3 0  9993
2 00244  66.8394 178.1394 0075825 233.7271 125.6790 13.95223673199823
0 THOR ABLESTAR DEB
1 00245U 61015CA  24187.55059926  .00000839  00000-0  46070-3 0  9997
2 00245  66.1018 238.7829 0060506 257.3535 102.0781 14.16042007227028
0 THOR ABLESTAR DEB
1 00246U 61015CB  24187.50055272  .00000005  00000-0  68828-4 0  9994
2 00246  66.8693 110.9834 0072546 274.7951  84.4845 13.85980859525233
0 THOR ABLESTAR DEB
1 00252U 61015CD  24187.05220340  .00000434  00000-0  50635-3 0  9993
2 00252  67.0789  67.5585 0053860 356.8880 108.1973 13.77074522153246
0 THOR ABLESTAR DEB
1 00253U 61015CE  24187.56734682  .00013379  00000-0  18408-2 0  9992
2 00253  66.9237 258.0113 0030671 298.9478  60.8572 14.78148735273041
0 THOR ABLESTAR DEB
1 00254U 61015CF  24187.30493380  .00002188  00000-0  60408-3 0  9996
2 00254  66.7760  38.3017 0074827 262.7365  96.5233 14.47065239270431
0 THOR ABLESTAR DEB
1 00260U 61015CG  24187.57489973  .00002457  00000-0  80729-3 0  9992
2 00260  66.7706 294.5623 0055458 290.8698  68.6472 14.39050974253726
0 THOR ABLESTAR DEB
1 00261U 61015CH  24187.26844000  .00000279  00000-0  23439-3 0  9990
2 00261  66.6819  28.6483 0081283 104.0691 256.9443 14.00510135212379
0 THOR ABLESTAR DEB
1 00262U 61015CJ  24187.48653906  .00003089  00000-0  79106-3 0  9992
2 00262  66.4637 225.5912 0077708 233.4789 125.9145 14.49962007254904
0 THOR ABLESTAR DEB
1 00263U 61015CK  24187.59318494  .00001547  00000-0  45866-3 0  9998
2 00263  66.5299 251.2676 0095960  50.0560  22.6488 14.43473309280428
0 THOR ABLESTAR DEB
1 00264U 61015CL  24187.61641386  .00003795  00000-0  14176-2 0  9997
2 00264  66.5282 327.1242 0023571 184.8424 175.2450 14.32770777231446
0 THOR ABLESTAR DEB
1 00268U 61015CN  24186.85643382 -.00000055  00000-0 -19404-4 0  9993
2 00268  67.9419  73.1535 0656479 301.4273 131.3708 12.51155238864122
0 MIDAS 5 (STRONGBACK)
1 00271U 62010A   24187.38939634  .00000006  00000-0  40057-3 0  9991
2 00271  86.6542  59.3263 0327692 183.8052 176.0343  9.41306453138693
0 MIDAS 5 DEB
1 00273U 62010C   24186.99628710  .00000031  00000-0  52784-2 0  9996
2 00273  86.6612  41.2132 0319895  17.6936 343.4819  9.43800536144091
0 MIDAS 5 DEB
1 00274U 62010D   24187.15592700 -.00000031  00000-0 -70301-2 0  9992
2 00274  86.6479  76.7612 0357956 319.0016  38.4478  9.39403520133926
0 THOR ABLESTAR DEB
1 00299U 61015CQ  24187.53346392  .00000170  00000-0  24665-3 0  9994
2 00299  67.1672 244.0643 0186228 106.6858 255.4745 13.68506686131663
0 TIROS 5
1 00309U 62025A   24187.57816156  .00000441  00000-0  10872-3 0  9998
2 00309  58.0916 312.6227 0189310   7.5259 352.8540 14.58673564277918
0 DELTA 1 DEB (YO)
1 00312U 62025C   24187.53108590  .00003702  00000-0  63122-3 0  9993
2 00312  58.2469 108.5254 0206766  75.2700 287.1144 14.57941239254963
0 THOR ABLESTAR DEB
1 00318U 61015CU  24187.57483712  .00019501  00000-0  12221-2 0  9990
2 00318  66.5360 129.1918 0048813 211.0912 148.7335 15.08401771306735
0 THOR ABLESTAR DEB
1 00320U 61015CW  24187.44344009  .00000354  00000-0  15872-3 0  9996
2 00320  66.9059  89.8852 0139449 212.4555 146.7914 14.28398157266651
0 THOR ABLESTAR DEB
1 00323U 61015CZ  24187.50678079  .00000781  00000-0  43044-3 0  9999
2 00323  66.8415 108.1153 0086235 252.5210 106.6442 14.14850120227729
0 THOR ABLESTAR DEB
1 00324U 61015DA  24186.96919687  .00000800  00000-0  47091-3 0  9990
2 00324  66.8675  29.9558 0070366 199.5370 160.3022 14.11854550222467
0 THOR ABLESTAR DEB
1 00325U 61015DB  24187.53219503  .00001010  00000-0  49630-3 0  9990
2 00325  66.9147 125.4823 0063172 217.2438 142.4269 14.20669273231965
0 THOR ABLESTAR DEB
1 00327U 61015DD  24187.57464994  .00000260  00000-0  25751-3 0  9996
2 00327  66.5441 343.3758 0119569 235.8601 123.1090 13.90314646187794
0 THOR ABLESTAR DEB
1 00329U 61015DF  24187.44995936  .00000157  00000-0  26834-3 0  9997
2 00329  66.7796 242.2947 0108002 110.4105   0.6086 13.65741174132803
0 THOR ABLESTAR DEB
1 00330U 61015DG  24187.56590500  .00001046  00000-0  69207-3 0  9999
2 00330  66.9798 272.5723 0058580 289.5977  69.8792 14.04584289196679
0 THOR ABLESTAR DEB
1 00333U 61015DK  24187.59110537  .00008941  00000-0  15524-2 0  9996
2 00333  66.7096 355.1747 0037807 126.9886 233.4702 14.68115417283666
0 THOR ABLESTAR DEB
1 00334U 61015DL  24187.22661250  .00000038  00000-0  87220-4 0  9993
2 00334  66.9241 116.0469 0086129 258.0395 101.1020 13.91520621196994
0 THOR ABLESTAR DEB
1 00335U 61015DM  24187.27123071  .00001484  00000-0  72783-3 0  9996
2 00335  66.8405 156.5457 0043224 327.3983  32.4443 14.20050585226106
0 THOR ABLESTAR DEB
1 00336U 61015DN  24187.05290566  .00000125  00000-0  22137-3 0  9996
2 00336  67.0309  54.3974 0084662 284.3585 241.9221 13.68860118141719
0 THOR ABLESTAR DEB
1 00337U 61015DP  24187.56435936  .00000506  00000-0  58051-3 0  9992
2 00337  67.0075 162.7311 0096313  49.3049 311.6341 13.75492230146873
0 TELSTAR 1
1 00340U 62029A   24187.50128285 -.00000125  00000-0 -72267-3 0  9996
2 00340  44.7860 203.8994 2418240 167.7521 355.1803  9.12880060 67443
0 DELTA 1 R/B
1 00341U 62029B   24187.18614884 -.00000160  00000-0 -10749-2 0  9991
2 00341  44.8039 104.5779 2417939 280.8094 263.1601  9.14291122 69990
0 THOR ABLESTAR DEB
1   350U 61015DQ  24187.55147815  .00000260  00000-0  14297-3 0  9993
2   350  66.9117 252.7698 0130542 325.7619  33.5108 14.21660870262293
0 THOR ABLESTAR DEB
1 00351U 61015DR  24187.55309343  .00009841  00000-0  18264-2 0  9991
2 00351  66.7494 290.0241 0024879 170.5151 189.6441 14.65353172272635
0 THOR ABLESTAR DEB
1 00354U 61015DU  24187.58559727  .00000355  00000-0  62273-3 0  9991
2 00354  67.0659 261.9401 0159719  87.0842  27.3630 13.48904118381878
0 THOR ABLESTAR DEB
1 00355U 61015DV  24187.28577866  .00000503  00000-0  97607-3 0  9997
2 00355  67.2257 119.0087 0245850 348.3440 168.2399 13.33050313 54098
0 THOR ABLESTAR DEB
1 00357U 61015DX  24187.49837300  .00001033  00000-0  66776-3 0  9996
2 00357  66.8080 234.9963 0016539 312.0338  47.9340 14.06768943195634
0 FTV 3502
1 00369U 62039A   24187.57041992  .00001619  00000-0  17244-3 0  9995
2 00369  98.5396 207.0650 0084004 277.9780  81.1908 14.88055355309605
0 TIROS 6
1 00397U 62047A   24187.31391746  .00002007  00000-0  21830-3 0  9990
2 00397  58.3044 126.6111 0001368 234.7302 125.3616 14.91968323305910
0 THOR ABLESTAR DEB
1 00402U 61015EB  24187.01616577  .00008390  00000-0  20534-2 0  9990
2 00402  66.6605  44.2746 0025987 142.8261 217.4655 14.52703903236947
0 THOR ABLESTAR DEB
1 00403U 61015EC  24187.45524032  .00000048  00000-0  11547-3 0  9990
2 00403  66.8392 192.9454 0026978 301.9239 178.3755 13.81013186172868
0 THOR ABLESTAR DEB
1 00404U 61015ED  24187.34707068  .00000272  00000-0  61504-3 0  9998
2 00404  66.4683 156.2780 0561164 193.8496 164.6580 12.91558351951314
0 THOR ABLESTAR DEB
1 00405U 61015EE  24186.88892310  .00000157  00000-0  26911-3 0  9997
2 00405  66.8938  25.6606 0090875 306.4444 176.8120 13.66294156134826
0 THOR ABLESTAR DEB
1 00406U 61015EF  24187.50652344  .00000561  00000-0  70704-3 0  9997
2 00406  66.7764 230.2316 0115557 157.2207 321.3115 13.68358427123776
0 THOR ABLESTAR DEB
1 00407U 61015EG  24187.62059381  .00014866  00000-0  24561-2 0  9995
2 00407  66.3210   5.9521 0050080  29.0599  44.1618 14.69696978226379
0 THOR ABLESTAR DEB
1 00408U 61015EH  24187.60065890  .00000521  00000-0  59956-3 0  9996
2 00408  66.7876   6.9282 0073714 247.4498 188.4648 13.76140931207745
0 THOR ABLESTAR DEB
1 00409U 61015EJ  24186.99368129  .00001518  00000-0  65485-3 0  9990
2 00409  66.7155  44.7403 0070217 325.1711  34.4799 14.25874708239639
0 THOR ABLESTAR DEB
1 00410U 61015EK  24187.59005918  .00000058  00000-0  13546-3 0  9992
2 00410  66.6941 302.1346 0008986 141.1334 232.4756 13.76381227162138
0 THOR ABLESTAR DEB
1 00414U 61015EP  24187.63318242  .00000058  00000-0  13410-3 0  9998
2 00414  66.4451  30.0940 0049738 199.1877 221.3640 13.77356359164026
0 THOR ABLESTAR DEB
1 00416U 61015ER  24187.59081335  .00000487  00000-0  29229-3 0  9996
2 00416  66.5276 304.5850 0084161 287.3614  71.8282 14.13641800231227
0 THOR ABLESTAR DEB
1 00417U 61015ES  24187.40830938  .00000658  00000-0  34399-3 0  9992
2 00417  66.7445 239.2639 0078564 256.9286 102.3029 14.18987310236435
0 THOR ABLESTAR DEB
1 00420U 61015EV  24187.51929280  .00001227  00000-0  47615-3 0  9995
2 00420  66.8153 339.1316 0083506  18.1889 342.2166 14.31298753251612
0 ALOUETTE 1 (S-27)
1 00424U 62049A   24187.60911661  .00000144  00000-0  15574-3 0  9997
2 00424  80.4659 240.4277 0021774 272.6241  87.2412 13.69382799 83715
0 THOR AGENA B R/B
1 00426U 62049B   24187.60364588  .00000095  00000-0  10009-3 0  9992
2 00426  80.4699 250.9095 0016805 261.5442 206.0091 13.68632068 82780
0 ANNA 1B
1 00446U 62060A   24187.36973678 -.00000106  00000-0  40710-4 0  9993
2 00446  50.1426  48.0216 0070332  62.6415 107.4563 13.35322948  8592
0 THOR ABLESTAR R/B
1 00447U 62060B   24187.48017087 -.00000069  00000-0  10654-3 0  9991
2 00447  50.1283 230.7015 0065953 210.2552 289.8688 13.39117246 16709
0 THOR ABLESTAR DEB
1 00461U 61015EX  24187.60401147  .00008948  00000-0  13422-2 0  9992
2 00461  67.5056 276.8992 0039771 304.2702  55.4662 14.74420646279677
0 THOR ABLESTAR DEB
1 00463U 61015EZ  24187.61342004  .00004033  00000-0  10639-2 0  9999
2 00463  66.7680 179.2294 0041018  78.7159 281.8555 14.49437116265662
0 THOR ABLESTAR DEB
1 00465U 61015FB  24187.56109424  .00000849  00000-0  31812-3 0  9990
2 00465  66.3177  13.6887 0026340  43.2822 317.0339 14.36535471243718
0 THOR ABLESTAR DEB
1 00467U 61015FD  24187.60536978  .00000582  00000-0  81072-3 0  9992
2 00467  66.5585 303.0512 0238532  34.8166 326.8237 13.53486782184471
0 THOR ABLESTAR DEB
1 00469U 61015FF  24187.47527631  .00001447  00000-0  56134-3 0  9997
2 00469  66.8322 219.0859 0059915   3.9570 356.1991 14.31763245250978
0 THOR ABLESTAR DEB
1 00470U 61015FG  24187.59146719  .00000726  00000-0  47285-3 0  9992
2 00470  66.2316 304.4664 0062456  28.9425 331.5097 14.07373222212179
0 THOR ABLESTAR DEB
1 00475U 61015FM  24187.07561575  .00003497  00000-0  15976-2 0  9990
2 00475  66.2255  89.4936 0152005 185.2041 174.7476 14.16727798186606
0 THOR ABLESTAR DEB
1 00478U 61015FQ  24187.09179377  .00012766  00000-0  20688-2 0  9995
2 00478  66.0686  90.8563 0034915  33.5045 326.8267 14.71045130278485
0 THOR ABLESTAR DEB
1 00480U 61015FS  24187.41201635  .00001874  00000-0  62475-3 0  9996
2 00480  66.2366 190.4284 0091273 237.7099 121.5134 14.37527581252302
0 RELAY 1 (A-15)
1 00503U 62068A   24187.17743297 -.00000033  00000-0  00000-0 0  9999
2 00503  47.5051 256.0026 2846541  75.3606 331.5079  7.78154782750054
0 EXPLORER 16
1 00506U 62070A   24187.47410102  .00000045  00000-0  12356-3 0  9996
2 00506  52.0011 243.3541 0277142 167.2713 193.5394 13.85490685110087
0 THOR AGENA B DEB
1 00510U 62049C   24187.61642414  .00000085  00000-0  86431-4 0  9996
2 00510  80.5153 306.7461 0016478 130.8044 243.4979 13.69914872 85239
0 THOR AGENA B DEB
1 00511U 62049D   24187.01916633  .00000103  00000-0  11004-3 0  9992
2 00511  80.4271 178.1697 0031845  11.0188  44.9597 13.68413043 82179
0 DELTA 1 R/B
1 00515U 62068B   24187.05104920 -.00000029  00000-0  00000-0 0  9998
2 00515  47.4977 190.8580 2836877 133.7854 253.5557  7.79242461752338
0 THOR ABLESTAR DEB
1 00516U 61015FT  24187.27032930  .00000397  00000-0  36536-3 0  9998
2 00516  65.9936 147.3609 0080220 171.7808 188.4601 13.92098836189269
0 THOR ABLESTAR DEB
1 00530U 61015FU  24187.48650165  .00000175  00000-0  17001-3 0  9993
2 00530  66.8802 283.9277 0084139 319.6381  39.8477 13.98888950208056
0 THOR ABLESTAR DEB
1 00537U 61015FW  24187.36223760  .00000563  00000-0  72087-3 0  9990
2 00537  67.2274 313.0099 0166230 104.0164 290.0363 13.64054462918134
0 THOR ABLESTAR DEB
1 00538U 61015FX  24186.68016254  .00005690  00000-0  13764-2 0  9995
2 00538  67.8094  31.4394 0010978 288.6146  71.3780 14.53616958259556
0 THOR ABLESTAR DEB
1 00541U 61015GA  24187.57420848  .00000334  00000-0  34863-3 0  9990
2 00541  67.2194 297.9676 0069765 106.4202 254.4561 13.85642426173701
0 THOR ABLESTAR DEB
1 00543U 61015GC  24187.41041458  .00000222  00000-0  33393-3 0  9994
2 00543  67.0304 163.6496 0070071 345.4235 179.5376 13.68760129139262
0 THOR ABLESTAR DEB
1 00544U 61015GD  24187.08185098  .00000404  00000-0  61076-3 0  9998
2 00544  66.8746  54.5801 0183671  20.2710 130.4998 13.55532322105060
0 THOR ABLESTAR DEB
1 00545U 61015GE  24187.23320339  .00000403  00000-0  48710-3 0  9994
2 00545  67.2320 125.9039 0165591 227.8970 130.7925 13.70116903132719
0 THOR ABLESTAR DEB
1 00548U 61015GH  24187.29743657  .00003752  00000-0  58688-3 0  9990
2 00548  66.6714 145.9934 0114759 301.4731  57.5211 14.69649168298947
0 THOR ABLESTAR DEB
1 00549U 61015GJ  24187.05606368  .00000123  00000-0  32637-3 0  9997
2 00549  66.6951  47.8402 0209065  46.9412 102.9192 13.36139677 67762
0 THOR ABLESTAR DEB
1 00552U 61015GM  24187.61118198  .00000700  00000-0  53354-3 0  9992
2 00552  67.7383 302.9221 0113862 270.7404  88.0640 13.95863208157231
0 SYNCOM 1
1 00553U 63004A   24185.41112860 -.00000124  00000-0  00000-0 0  9997
2 00553  28.1998 287.3275 0774760 178.9851 181.2427  1.16484378 27743
0 THOR ABLESTAR DEB
1 00558U 61015GQ  24187.54894968  .00000171  00000-0  58753-3 0  9996
2 00558  65.6966 237.0609 0469663  22.6738  89.4039 12.86173632958113
0 THOR ABLESTAR DEB
1 00559U 61015GR  24187.18039258  .00008518  00000-0  19173-2 0  9995
2 00559  66.6057 112.4670 0065132 318.9145  40.7070 14.55521511245425
0 THOR ABLESTAR DEB
1 00560U 61015GS  24186.83650313  .00002810  00000-0  31228-2 0  9993
2 00560  67.1617  76.0531 0300632 106.4545 256.9780 13.55050063 57706
0 THOR ABLESTAR DEB
1 00561U 61015GT  24187.43470858  .00000209  00000-0  94988-3 0  9998
2 00561  67.7530 184.8925 0624632  63.1132  83.4651 12.40832134852794
0 TELSTAR 2 (A-41)
1 00573U 63013A   24187.51715030 -.00000080  00000-0 -47962-3 0  9993
2 00573  42.7744  15.6104 4007350   4.5087   8.4162  6.39269858540630
0 MIDAS 6 (FTV 1169)
1 00574U 63014A   24187.51577438  .00000014  00000-0  52621-2 0  9995
2 00574  87.3141 263.4902 0032919 107.1118 253.3346  8.65274233156223
0 DELTA 1 R/B
1 00575U 63013B   24187.40718071 -.00000108  00000-0 -13802-2 0  9997
2 00575  42.7681 318.7583 4001559  66.5663 348.7031  6.40248657430395
0 DASH 1
1 00589U 63014D   24186.57849504 -.00000040  00000-0 -19890-1 0  9993
2 00589  87.3091 258.4401 0131944   4.3999 355.7987  8.65631536932159
0 WESTFORD NEEDLES
1   602U 63014E   24187.21040599  .00000022  00000-0  86760-2 0  9997
2   602  87.3220 257.4762 0043036  38.9023 321.4918  8.67233808936401
0 ERS 6
1 00608U 63014C   24187.20545367 -.00000018  00000-0 -96728-2 0  9997
2 00608  87.3108 261.1222 0071922  21.4410 338.9433  8.65286593931910
0 HITCH HIKER 1
1 00614U 63025B   24187.48017531  .00300812  28988-4  81994-3 0  9995
2 00614  81.9291  42.7963 0122631  40.5378 320.4940 15.82414147817539
0 MIDAS 7/ERS 10
1 00622U 63030A   24187.53271798  .00000003  00000-0  26896-3 0  9993
2 00622  88.3917 250.6965 0033940  51.1268 309.2602  8.57932188398747
0 WESTFORD NEEDLES
1 00628U 63014F   24187.14656379  .00000003  00000-0  00000-0 0  9996
2 00628  87.3089 270.9468 0028002  81.5434 278.8591  8.63369120927507
0 WESTFORD NEEDLES
1 00629U 63014G   24187.14133279 -.00000016  00000-0 -86715-2 0  9991
2 00629  87.3118 259.1930 0102694  18.0399 342.4061  8.65569829932583
0 ATLAS AGENA B DEB
1 00630U 63030C   24187.08649119  .00000004  00000-0  88061-3 0  9991
2 00630  88.4000 242.2656 0038282 257.0348 102.6227  8.59856272913623
0 ATLAS AGENA B DEB
1 00631U 63030E   24187.12741201  .00000003  00000-0  00000-0 0  9995
2 00631  88.3842 256.7102 0179044  70.0875 291.9168  8.55880834904716
0 SYNCOM 2 (A 26)
1   634U 63031A   24181.90626983 -.00000031  00000-0  00000+0 0  9999
2   634  31.5040 310.5181 0009886 187.1499 172.3275  1.00277118223165
0 ERS 9
1 00635U 63030B   24187.34008793  .00000019  00000-0  85349-2 0  9993
2 00635  88.3918 254.5802 0050836  25.6910 334.6451  8.57943517909399
0 THOR ABLESTAR DEB
1   643U 61015GU  24187.55582992  .00001475  00000-0  23397-2 0  9996
2   643  66.3700 229.1686 0319540  75.9093 287.7243 13.33733637 15352
0 THOR ABLESTAR DEB
1 00644U 61015GV  24187.59396212  .00000679  00000-0  93047-3 0  9994
2 00644  67.0981 127.5535 0154283 266.2150 268.0992 13.59760860100923
0 THOR ABLESTAR DEB
1 00645U 61015GW  24187.41202083  .00000438  00000-0  10397-2 0  9997
2 00645  66.5883 298.6615 0412924 174.9061 251.5499 13.04304263986992
0 THOR ABLESTAR DEB
1 00648U 61015GZ  24187.61077058  .00000706  00000-0  93803-3 0  9996
2 00648  65.8764 300.3839 0204839 212.9869 246.8054 13.58421243102279
0 THOR ABLESTAR DEB
1 00649U 61015HA  24187.58314907  .00000227  00000-0  83340-3 0  9993
2 00649  66.2653 162.9195 0557831  22.5966  87.4409 12.64956669902615
0 THOR ABLESTAR DEB
1 00652U 61015HD  24187.23724504  .00002549  00000-0  13524-2 0  9992
2 00652  66.7005 128.7212 0072345 150.0556 210.4703 14.13850727193003
0 THOR ABLESTAR DEB
1 00653U 61015HE  24186.93748191  .00001313  00000-0  14708-2 0  9990
2 00653  67.4522   2.9377 0160608 188.2480 324.4383 13.68516543120341
0 THOR ABLESTAR DEB
1 00655U 61015HG  24187.61037193  .00000216  00000-0  58822-3 0  9998
2 00655  67.2585 285.4236 0357376  87.8949  27.7082 13.08670259993779
0 THOR ABLESTAR DEB
1 00656U 61015HH  24187.45794665  .00001064  00000-0  23509-2 0  9990
2 00656  66.2898 216.7047 0655500 110.3186 256.9482 12.70619043876477
0 THOR ABLESTAR DEB
1 00657U 61015HJ  24187.33848564  .00000311  00000-0  81313-3 0  9998
2 00657  66.2013 113.9005 0328464  28.0694  53.4036 13.11344247 11264
0 THOR ABLESTAR DEB
1 00658U 61015HK  24187.54979860  .00002604  00000-0  33891-2 0  9990
2 00658  65.8685 353.9538 0358519 190.0010 169.3769 13.39758785964205
0 THOR ABLESTAR DEB
1 00659U 61015HL  24186.99490748  .00000087  00000-0  37698-3 0  9995
2 00659  67.1631  46.0341 0584372  10.7185  98.1436 12.66217754900837
0 THOR ABLESTAR DEB
1 00660U 61015HM  24187.14679734  .00013600  00000-0  19810-2 0  9999
2 00660  66.5154  94.4887 0035060 340.3549 134.8750 14.75619802278900
0 THOR ABLESTAR R/B
1 00669U 63038A   24187.51635293  .00000036  00000-0  44312-4 0  9994
2 00669  90.0004 335.0834 0026300   3.7520  62.6554 13.46063809983952
0 TRANSIT 5B-1
1 00670U 63038B   24187.44798462  .00000080  00000-0  12133-3 0  9990
2 00670  89.9904 334.5279 0039544 272.1412  87.5207 13.44526377978534
0 RADIATION SAT (5E 1)
1 00671U 63038C   24187.42708426  .00000100  00000-0  15473-3 0  9993
2 00671  89.9914 334.5748 0038804 227.9283 131.8562 13.45058166979354
0 THOR ABLESTAR DEB
1 00672U 63038D   24187.46091549  .00000480  00000-0  55633-3 0  9992
2 00672  90.0082 336.2468 0029104  43.0140  30.9753 13.67464056  4526
0 VELA 2
1 00674U 63039A   24185.52623183 -.00000149  00000-0  00000-0 0  9993
2 00674  45.5203 118.1679 3594807  85.7601   0.0468  0.22201179  7799
0 VELA 1
1 00692U 63039C   24189.77072513 -.00001176  00000-0  00000-0 0  9990
2 00692  18.3468  35.9449 5953013 214.4381   0.1375  0.22154962 11607
0 ATLAS CENTAUR 2 R/B
1 00694U 63047A   24187.53785930  .00005110  00000-0  63815-3 0  9994
2 00694  30.3545   7.0709 0564848 100.5094 265.9618 14.07737318 45140
0 ATLAS CENTAUR 2 DEB
1 00698U 63047D   24187.44656796  .00001418  00000-0  51116-3 0  9993
2 00698  29.9244 108.7608 0538507 316.0384  39.8546 13.71786134981136
0 ATLAS CENTAUR 2 DEB
1 00700U 63047F   24187.47352756  .00000300  00000-0  86667-4 0  9998
2 00700  30.4859 321.5051 0720587 289.9120  62.5264 13.39434720954677
0 ATLAS CENTAUR 2 DEB
1 00701U 63047G   24187.58559199  .00000799  00000-0  24869-3 0  9998
2 00701  30.0113 295.6141 0517565  18.6560 343.2271 13.80034761 11705
0 WESTFORD NEEDLES
1 00702U 63014H   24186.65440168 -.00000108  00000-0 -51089-1 0  9993
2 00702  87.3119 257.5841 0183097  42.0829 319.3928  8.65689442932613
0 THOR ABLESTAR R/B
1 00703U 63049A   24187.45449584  .00000066  00000-0  88420-4 0  9995
2 00703  89.9163  76.0582 0016419 159.9506  13.0811 13.49924324983221
0 TRANSIT 5B-2
1 00704U 63049B   24187.44750334  .00000082  00000-0  11912-3 0  9992
2 00704  89.9140  76.4292 0034407 182.4043 351.3613 13.47002502975506
0 TRANSIT 5E 3
1 00705U 63049C   24187.62856154  .00000120  00000-0  17915-3 0  9992
2 00705  89.9142  76.3813 0034875 139.7131 282.4098 13.47522586976285
0 THOR ABLESTAR DEB
1 00706U 63049D   24187.62840620  .00000383  00000-0  53269-3 0  9997
2 00706  89.9120  79.4136 0027509 344.8356  79.0324 13.56050969986855
0 THOR ABLESTAR DEB
1 00715U 63049E   24187.49331932  .00000994  00000-0  10491-2 0  9990
2 00715  89.9116  84.3972 0031139 137.5442  37.0427 13.73790899  5593
0 TIROS 8
1 00716U 63054A   24187.60083359  .00001074  00000-0  20208-3 0  9995
2 00716  58.4937 149.6630 0028876  67.5538 292.8554 14.71275564210916
0 DELTA 1 DEB
1 00720U 63054C   24187.32120310  .00000702  00000-0  21443-3 0  9997
2 00720  58.4713 153.3169 0103702 243.6067 115.4288 14.48861166178244
0 SCOUT X-4 R/B
1 00721U 63053B   24187.44377457  .00000684  00000-0  40074-3 0  9996
2 00721  78.6034  92.7198 1089491  36.9579 330.1735 12.54399999760787
0 SCOUT X-4 DEB
1 00724U 63053E   24187.44938221  .00023436  00000-0  36462-2 0  9996
2 00724  78.5936 352.5664 0271175 264.2586  92.7626 14.51139794914976
0 THOR AGENA D R/B
1 00727U 64001A   24187.54902238  .00000054  00000-0  79301-4 0  9995
2 00727  69.9066  17.9230 0015862 246.2270 113.7171 13.95600233 77851
0 GGSE 1 (GGRS)
1 00728U 64001B   24187.59334064  .00000121  00000-0  12394-3 0  9990
2 00728  69.9085 295.8004 0013824 194.1428 165.9293 13.97485991 80246
0 SECOR 1B
1 00729U 64001C   24187.61343484  .00000035  00000-0  65936-4 0  9995
2 00729  69.9014  19.1328 0016626 269.6352  90.2848 13.95074595 77459
0 SOLRAD 7A
1   730U 64001D   24187.57478285  .00000070  00000-0  90285-4 0  9994
2   730  69.9070   4.9618 0015762 233.4069 196.5153 13.95852967961910
0 GREB
1 00731U 64001E   24187.61175708  .00000080  00000-0  97233-4 0  9995
2 00731  69.9069 355.7108 0015674 229.4892 130.4848 13.96091978 78253
0 SCOUT X-4 DEB
1 00732U 63053H   24187.62071763  .00010926  00000-0  38018-2 0  9993
2 00732  78.5681  33.2737 0464794  58.9967 305.5974 13.88497564875695
0 THOR AGENA D R/B
1 00733U 64002A   24187.55335927  .00000380  00000-0  15483-3 0  9991
2 00733  99.0749 157.9034 0032308 239.8094 119.9887 14.33245813150589
0 OPS 3367 A
1 00734U 64002B   24187.41908325  .00000167  00000-0  83961-4 0  9995
2 00734  98.9899  85.2584 0015609  92.4809 267.8159 14.29268105147078
0 OPS 3367 B
1 00735U 64002C   24187.59133170  .00000150  00000-0  79025-4 0  9991
2 00735  99.0107  80.3277 0016042 204.7354 155.3058 14.28190686145123
0 RELAY 2
1   737U 64003A   24186.71986543 -.00000012  00000-0  00000+0 0  9997
2   737  46.4696  67.7127 2596851 302.4105  35.0938  7.39541749633644
0 DELTA 1 R/B
1 00738U 64003B   24186.75926984 -.00000011  00000-0  00000-0 0  9995
2 00738  46.4684  75.8801 2601820 295.0688  40.2807  7.39354161632784
0 ATLAS CENTAUR 2 DEB
1 00739U 63047H   24187.61803779  .00001487  00000-0  23531-3 0  9999
2 00739  30.4242 299.2477 0640853 166.4773 195.3895 13.83903816 42688
0 THOR AGENA B R/B
1 00741U 64004B   24187.58863108  .00000082  00000-0  15656-3 0  9993
2 00741  81.4904  24.2571 0171486 200.9624 214.7793 13.23746628918914
0 THOR AGENA B DEB
1 00742U 64004C   24187.49958387  .00000073  00000-0  12764-3 0  9995
2 00742  81.4669 280.2515 0172817  79.7986 282.2578 13.26145474923021
0 THOR AGENA B DEB
1 00743U 64004D   24187.56978182  .00000120  00000-0  23029-3 0  9998
2 00743  81.5215  27.6993 0174005 317.8531  93.7342 13.26696002923769
0 THOR ABLESTAR DEB
1 00745U 63038E   24187.39778970  .00000269  00000-0  37709-3 0  9994
2 00745  90.0085 336.3633 0016959 202.1094 218.1317 13.55090994995073
0 ELEKTRON 1
1 00746U 64006A   24187.05476197  .00003294  00000-0  83280-3 0  9996
2 00746  60.8736  72.1866 3019638  45.1381 335.8397  9.07467745  2471
0 ELEKTRON 1 DEB
1 00750U 64006C   24187.48633014  .00017794  00000-0  18631-2 0  9998
2 00750  60.7569 250.0280 1545593  87.9129 289.7357 12.15532024758682
0 THOR ABLESTAR DEB
1 00753U 63049F   24187.48242029  .00000322  00000-0  45614-3 0  9990
2 00753  89.9130  79.0939 0028865 110.4925  64.6596 13.54410846984187
0 OPS 4412 (TRANSIT 9)
1 00801U 64026A   24187.43106676  .00000651  00000-0  32239-3 0  9996
2 00801  90.4700 151.0536 0048584 160.9432 199.3588 14.15871339 85385
0 SCOUT X-4 DEB
1 00805U 64026B   24187.43213642  .00002405  00000-0  89555-3 0  9994
2 00805  89.8777 339.9308 0032556  39.0320 321.3217 14.31526296 88019
0 SCOUT X-4 R/B
1 00809U 64026D   24187.59106574  .00000459  00000-0  25269-3 0  9999
2 00809  90.4734 141.5798 0039967 176.8363 183.3082 14.10055323 77833
0 OPS 4467 A
1 00812U 64031A   24187.21841355  .00000115  00000-0  73001-4 0  9998
2 00812  99.7936 251.0111 0004728 285.6101  74.4552 14.24232599114937
0 OPS 4467 B
1 00813U 64031B   24187.45817995  .00000115  00000-0  74416-4 0  9999
2 00813  99.8055 249.1287 0005468  18.3971 341.7401 14.23383224113664
0 THOR AGENA D R/B
1 00815U 64031C   24187.59408710  .00000227  00000-0  11353-3 0  9991
2 00815  99.8546  38.8418 0012139 141.1145 219.0907 14.27954188119426
0 ELEKTRON 3
1 00829U 64038A   24187.48182653  .00001430  00000-0  40129-3 0  9996
2 00829  60.8048 104.6244 2955187 158.5754 217.0548  9.18129716949957
0 ELEKTRON 3 DEB
1 00831U 64038C   24187.36965037  .00034319  00000-0  34068-2 0  9997
2 00831  60.6728 184.8025 1423279  22.2356 343.4480 12.41758623275840
0 OPS 3662 (VELA 3)
1 00836U 64040A   24188.38339758  .00000215  00000-0  00000-0 0  9998
2 00836  48.6385 133.1914 4914055 304.9446 359.8623  0.23908409  9306
0 OPS 3674 (VELA 4)
1 00837U 64040B   24187.44034482  .00000112  00000-0  00000-0 0  9997
2 00837  48.2551 137.1091 3601090 267.5592   0.0543  0.23995649 53010
0 SYNCOM 3
1 00858U 64047A   24187.51879787  .00000020  00000-0  00000-0 0  9998
2 00858   5.2174  71.4157 0003249 108.8120 163.9047  1.00387017 46327
0 DELTA 1 R/B
1 00862U 64047B   24187.06560613 -.00000079  00000-0  00000-0 0  9993
2 00862  15.8243 176.9964 7086450   5.5453 359.2386  2.05103036243549
0 EXPLORER 20
1 00870U 64051A   24187.49377373  .00000128  00000-0  92216-4 0  9991
2 00870  79.8990 333.1033 0096988 354.1467   5.8547 13.91487308 34443
0 SCOUT X-4 R/B
1 00871U 64051B   24187.31448521  .00000342  00000-0  22091-3 0  9998
2 00871  79.8941 134.0909 0085395 243.7458 115.4909 14.00059637 45222
0 COSMOS 44
1 00876U 64053A   24187.56892957  .00000616  00000-0  12314-3 0  9999
2 00876  65.0602 267.0882 0138441 188.9668 170.8961 14.64758066184408
0 SL-3 R/B
1 00877U 64053B   24187.58702731  .00000640  00000-0  15245-3 0  9995
2 00877  65.0787 324.5097 0067117 193.7458 166.1817 14.60391384177370
0 THOR ABLESTAR R/B
1 00893U 64063A   24187.58868594  .00000062  00000-0  74935-4 0  9994
2 00893  90.2137  59.0219 0026802 138.1437 279.9882 13.56233790955570
0 OPS 5798 (TRANSIT 5B-4)
1 00897U 64063B   24187.40103506  .00000072  00000-0  92824-4 0  9992
2 00897  90.2173  59.1621 0021642  87.3367  86.0649 13.53603303948945
0 EXPLORER 22
1 00899U 64064A   24187.46213628  .00000216  00000-0  18320-3 0  9996
2 00899  79.6892 185.6381 0118894 235.0919 123.9014 13.82624078  6604
0 CALSPHERE 1
1 00900U 64063C   24187.61953728  .00000800  00000-0  82633-3 0  9994
2 00900  90.2031  55.7759 0023882 288.4888 136.8955 13.75109330973562
0 OPS 5798 DEB
1 00901U 64063D   24187.62931079  .00000134  00000-0  18122-3 0  9993
2 00901  90.2199  59.8951 0020910  39.5589  13.2484 13.54927825950091
0 CALSPHERE 2
1 00902U 64063E   24187.59544973  .00000059  00000-0  74576-4 0  9995
2 00902  90.2183  59.4004 0019949 129.1684 295.2657 13.52803701760055
0 OPS 5798 DEB
1 00903U 64063F   24187.62031964  .00000977  00000-0  94875-3 0  9993
2 00903  90.2052  54.8266 0024851 106.1633 308.1731 13.78856665976249
0 SCOUT X-4 R/B
1 00907U 64064B   24187.59336354  .00000131  00000-0  11361-3 0  9996
2 00907  79.6904 225.0842 0120143 324.8873  34.4397 13.80655574  4437
0 EXPLORER 25 (INJUN-4)
1 00932U 64076B   24187.53249158  .00001152  00000-0  40033-3 0  9998
2 00932  81.3382 205.6734 1126540  81.0862 291.5829 12.65585660729033
0 SCOUT X-4 R/B
1 00933U 64076C   24187.52184291  .00002079  00000-0  70273-3 0  9992
2 00933  81.3379 351.0458 1060842 207.5029 146.5904 12.79913786745424
0 THOR ABLESTAR R/B
1 00953U 64083A   24187.57822819  .00000063  00000-0  73187-4 0  9991
2 00953  90.0126 191.0955 0032028   6.3442 108.5946 13.58747445951984
0 THOR ABLESTAR DEB
1 00956U 64083B   24187.43585991  .00000389  00000-0  45338-3 0  9993
2 00956  89.9390 173.5964 0023455 344.3758 168.2663 13.66919809958903
0 OPS 6582 (TRANSIT 5E-5)
1 00959U 64083C   24187.56590053  .00000247  00000-0  30592-3 0  9994
2 00959  89.9942 186.9321 0040105 242.9367 239.0122 13.62099220953313
0 OPS 6582 (TRANSIT 5B-5)
1 00965U 64083D   24187.60577385  .00000091  00000-0  11478-3 0  9998
2 00965  90.0435 198.3847 0040681 196.0651 283.2557 13.56889275947107
0 THOR ABLESTAR DEB
1 00967U 64083F   24187.46150215  .00000384  00000-0  44884-3 0  9995
2 00967  89.9533 177.1287 0022424 356.9702 157.1477 13.66802185958790
0 SCOUT X-4 DEB
1 00976U 64064C   24187.13799462  .00000834  00000-0  46902-3 0  9994
2 00976  79.3149  79.3647 0117058 117.5240 243.7876 14.06612837 42804
0 SCOUT X-4 DEB
1 00977U 64064D   24187.11453396  .00000371  00000-0  33890-3 0  9994
2 00977  80.0440 178.6894 0126958 198.2566 161.4006 13.78369872991463
0 TIROS 9
1 00978U 65004A   24187.60655503  .00000214  00000-0  27687-3 0  9991
2 00978  96.4102 312.5140 1159276 133.4371 236.9262 12.11025923625477
0 DELTA 1 R/B
1 00979U 65004B   24187.53993488  .00000138  00000-0  18811-3 0  9995
2 00979  96.4107  15.5212 1141033  11.4164 351.0603 12.15085965629119
0 TITAN 3A DEB (TRUSS)
1 01000U 65008B   24187.47784930  .00000029  00000-0  26584-2 0  9992
2 01000  32.1390 223.8354 0010623 330.0015  29.9873  9.88889967146902
0 TITAN 3A TRANSTAGE R/B
1 01001U 65008A   24187.50230372 -.00000002  00000-0 -12917-2 0  9991
2 01001  32.1514   3.0403 0017728 203.4221 156.5470  9.90723044150898
0 LES 1
1 01002U 65008C   24187.56308465  .00000017  00000-0  11393-2 0  9998
2 01002  32.1451 290.5198 0014399 223.8790 136.0564  9.88354019145789
0 THOR ABLESTAR DEB
1 01099U 64083G   24187.48074432  .00000231  00000-0  28349-3 0  9999
2 01099  89.8510 150.3643 0038256 223.0871 256.0470 13.62435442885482
0 SECOR 3
1 01208U 65016E   24187.57989927  .00000093  00000-0  10632-3 0  9994
2 01208  70.0790 259.5389 0022432 298.2326 168.5238 13.95850354 19851
0 GGSE 2
1 01244U 65016B   24187.59522986  .00000064  00000-0  85233-4 0  9992
2 01244  70.0788 261.9425 0023145 301.2000  58.6837 13.95919502 18744
0 THOR AGENA D R/B
1 01245U 65016J   24187.43428376  .00000151  00000-0  14484-3 0  9990
2 01245  70.0762 184.8252 0023942 267.6062  92.2304 13.97357561 20857
0 OPS 4988 (GREB 6)
1 01271U 65016A   24187.56115051  .00000082  00000-0  97378-4 0  9993
2 01271  70.0782 235.0337 0023329 284.6253 193.2577 13.96410730 19456
0 PORCUPINE 1
1 01272U 65016H   24187.57867705  .00000030  00000-0  61496-4 0  9990
2 01272  70.0808 321.2521 0023452 330.3449  29.6325 13.94386249 17177
0 SOLRAD 7B
1 01291U 65016D   24187.62246481  .00000050  00000-0  75735-4 0  9992
2 01291  70.0803 308.8980 0022321 329.3492  30.6308 13.94795521 17476
0 GGSE 3
1 01292U 65016C   24187.60903828  .00000229  00000-0  18752-3 0  9999
2 01292  70.0776  40.9691 0019587 179.4744 180.6389 14.01123036 24875
0 OSCAR 3
1 01293U 65016F   24187.57970592  .00000664  00000-0  42547-3 0  9990
2 01293  70.0737 145.8848 0016612  14.9302 345.2297 14.07475962 31915
0 DELTA 1 DEB
1 01312U 65004C   24184.86483514  .00000089  00000-0  11338-3 0  9996
2 01312  96.3389 150.1371 1116578 269.1896  78.1365 12.27864493638907
0 DELTA 1 DEB
1 01313U 65004D   24186.28233969  .00000750  00000-0  11311-2 0  9997
2 01313  96.4289 110.7255 1175727  37.5607 330.1979 12.00630030600886
0 OPS 4682 (SNAPSHOT)
1 01314U 65027A   24187.50855812 -.00000008  00000-0 -55185-4 0  9993
2 01314  90.2406 350.7178 0029942 349.7390  71.8710 12.91785140539148
0 SECOR 4 (EGRS 4)
1 01315U 65027B   24187.24511855 -.00000037  00000-0 -16053-3 0  9993
2 01315  90.2392 359.7034 0029396 258.7765 276.4631 12.92642787794947
0 OPS 4682 DEB
1 01316U 65027C   24187.55288592  .00001055  00000-0  25680-2 0  9991
2 01316  90.2444  10.2891 0030952 343.6889  16.3246 13.20818430824991
0 INTELSAT 1-F1
1 01317U 65028A   24187.40270431  .00000021  00000-0  00000-0 0  9999
2 01317   5.4151  70.5954 0006111 105.4891 126.6168  1.00356729120036
0 DELTA 1 R/B(2)
1 01318U 65028B   24187.02396774 -.00000060  00000-0  00000-0 0  9991
2 01318  17.4271  99.7983 6963294 150.4041 357.1042  2.11826338 92238
0 EXPLORER 27
1 01328U 65032A   24187.50145502  .00000011  00000-0  14072-3 0  9993
2 01328  41.1825 182.2933 0249055 205.0417 153.8078 13.38810638892944
0 SL-8 DEB
1 01335U 65020E   24187.48570224  .00000962  00000-0  33156-3 0  9997
2 01335  56.0751 259.2527 0539868   1.2467 358.9713 13.83189784911323
0 SCOUT X-4 R/B
1 01358U 65032B   24187.46018946 -.00000006  00000-0  12287-3 0  9993
2 01358  41.1879 229.2845 0246176 127.9816 234.3446 13.38164030892320
0 TITAN 3A TRANSTAGE R/B
1 01359U 65034A   24187.41417371  .00000032  00000-0  65188-2 0  9991
2 01359  32.1183 234.5389 0496544  16.6813 344.9389  9.17133068983300
0 LES 2
1 01360U 65034B   24186.97877014 -.00000034  00000-0  00000-0 0  9990
2 01360  32.1402  73.1547 3966926 145.9059 247.4477  4.64826078  4740
0 LCS 1
1 01361U 65034C   24187.07505043  .00000001  00000-0 -94104-3 0  9998
2 01361  32.1438  67.8207 0006276 105.1749 254.9443  9.89305621139368
0 OPS 4682 DEB
1 01389U 65027D   24187.60740499  .00000876  00000-0  23759-2 0  9991
2 01389  89.8247 229.9353 0021125 276.2840 195.1486 13.13372702817227
0 SL-8 DEB
1 01392U 65020AH  24187.55187022  .00012418  00000-0  12199-2 0  9990
2 01392  55.8736 272.2373 0270941 357.5533   2.4131 14.68896008989761
0 OPS 4682 DEB
1 01399U 65027E   24186.93722350  .00000344  00000-0  11273-2 0  9991
2 01399  90.2495   7.9687 0009379  23.9472 336.2084 12.99424995540587
0 OPS 8480 (TRANSIT 5B-6)
1 01420U 65048A   24187.58303939  .00000133  00000-0  18668-3 0  9991
2 01420  89.8955 294.6053 0072307 334.9656  35.8843 13.51664145907314
0 THOR ABLESTAR DEB
1 01425U 65048C   24187.56116973  .00000038  00000-0  43575-4 0  9994
2 01425  89.8940 293.3600 0075603 117.3814 254.3958 13.48871471904497
0 THOR ABLESTAR R/B
1 01428U 65048B   24187.53229550  .00000029  00000-0  27675-4 0  9993
2 01428  89.8929 293.6014 0058843  86.2210 285.1863 13.52609731912444
0 TIROS 10
1 01430U 65051A   24187.57336100  .00000313  00000-0  10909-3 0  9991
2 01430  98.4391 302.1290 0056812  57.2857 303.3792 14.40949211 93405
0 DELTA 1 R/B
1 01433U 65051B   24187.60566913  .00001381  00000-0  29845-3 0  9990
2 01433  98.4814 314.1821 0040104 319.3121  40.5083 14.59510047 90898
0 THOR ABLESTAR DEB
1  1435U 65048D   24187.56673453  .00000944  00000-0  10214-2 0  9994
2  1435  89.8999 298.4227 0058229 292.9915  77.7480 13.71789515929813
0 OPS 6577 (VELA 5)
1 01458U 65058A   24188.61207400 -.00001569  00000-0  00000-0 0  9997
2 01458  23.1732  21.9894 4905029 291.1794 358.1755  0.21324547 10534
0 OPS 6564 (VELA 6)
1 01459U 65058B   24190.67307789 -.00001297  00000-0  00000-0 0  9996
2 01459  41.0260  19.0781 4640696  62.1878   0.6551  0.21412718  7748
0 SL-8 DEB
1 01477U 65020BB  24186.87344018  .00001516  00000-0  24139-2 0  9992
2 01477  55.4933 237.3214 0595797 257.7440  95.6188 12.98319529785650
0 SL-8 DEB
1 01478U 65020BC  24187.33860609  .00002276  00000-0  11437-2 0  9995
2 01478  56.0796 156.1615 0611622 153.0737 210.3392 13.50705613828474
0 SL-8 DEB
1 01479U 65020BD  24187.52027574  .00000196  00000-0  59510-3 0  9997
2 01479  56.0309 117.4543 0744403 157.0190 206.5927 12.59413504706688
0 SL-8 DEB
1 01480U 65020BE  24187.36345533  .00000091  00000-0  26137-3 0  9992
2 01480  56.0676 175.8683 0841097 165.7617 196.8670 12.63597559720104
0 SCOUT B R/B
1 01502U 65063B   24187.59595972 -.00000017  00000-0  10515-3 0  9995
2 01502  69.2303 249.7394 0781910  16.4388  90.4933 11.78577406534542
0 THOR ABLESTAR DEB
1 01504U 65065A   24187.59844466  .00000195  00000-0  33593-3 0  9991
2 01504  89.9227 245.6534 0069332  80.8002  46.3351 13.39991354872397
0 SECOR 5 (EGRS 5)
1 01506U 65063A   24187.51616573  .00000000  00000-0  22547-3 0  9991
2 01506  69.2316 244.2924 0785188   8.0907  94.5047 11.78668085534381
0 THOR ABLESTAR R/B
1 01508U 65065B   24187.57845117  .00000043  00000-0  66395-4 0  9996
2 01508  90.1619 297.5556 0042222 176.7868 194.0366 13.36036809870391
0 DODECAPOLE 2
1 01510U 65065C   24187.60992020  .00004216  00000-0  27167-2 0  9997
2 01510  90.0454  20.5366 0033986 293.0615  66.6983 14.02588226933065
0 THOR ABLESTAR DEB
1 01511U 65065D   24187.63140914  .00000071  00000-0  12246-3 0  9996
2 01511  89.9538 212.8749 0070400  48.4890  66.7346 13.34104541865804
0 TEMPSAT 1
1 01512U 65065E   24187.63013808  .00000055  00000-0  90182-4 0  9996
2 01512  89.9533 213.9991 0071790  86.9578  29.7772 13.33518848865219
0 OPS 8464 (TRANSIT 5B-7)
1 01514U 65065F   24187.60348079  .00000116  00000-0  20870-3 0  9990
2 01514  89.9466 229.7672 0070453   7.1813 113.1103 13.35186670866302
0 NAVSPASUR ROD 1
1 01515U 65065G   24187.06631503  .00000628  00000-0  96487-3 0  9993
2 01515  89.9778 214.0605 0054830 213.0358 174.3938 13.49945089884201
0 CALSPHERE 4(A)
1 01520U 65065H   24187.63119640  .00000111  00000-0  19797-3 0  9991
2 01520  89.9471 127.9574 0067755 312.8510 223.7942 13.36077225867683
0 THOR ABLESTAR DEB
1 01521U 65065K   24187.57466719  .00000052  00000-0  84027-4 0  9990
2 01521  89.9775 210.0853 0071444 100.0854  21.3343 13.33228049864585
0 THOR ABLESTAR DEB
1 01522U 65065L   24187.58832149  .00000065  00000-0  11136-3 0  9990
2 01522  90.1154 120.2185 0073293  86.7449  86.4862 13.33760870864935
0 DELTA 1 DEB
1 01529U 65051D   24187.56649716  .00000312  00000-0  15644-3 0  9999
2 01529  99.0792  36.7632 0037340 107.6922 252.8337 14.23650519 54168
0 SL-8 DEB
1  1549U 65020CV  24187.19338904  .00000325  00000-0  56161-3 0  9993
2  1549  56.1651 118.3195 0846925 199.1230 157.6011 12.63563377725347
0 COSMOS 80
1 01570U 65070A   24187.45997432 -.00000065  00000-0  19483-3 0  9996
2 01570  56.0539 241.6724 0103183  77.2934 297.0466 12.52783824692167
0 COSMOS 81
1 01571U 65070B   24187.57361868 -.00000089  00000-0  37192-4 0  9992
2 01571  56.0618 317.7673 0087070 210.5184 248.5684 12.48852519683727
0 COSMOS 82
1 01572U 65070C   24187.60448087 -.00000092  00000-0  15559-4 0  9993
2 01572  56.0608   0.4585 0075819  30.5596  48.7320 12.45108734675571
0 COSMOS 83
1 01573U 65070D   24187.38057651 -.00000080  00000-0  94576-4 0  9995
2 01573  56.0550  72.8149 0066438 210.3686 149.3360 12.41032145666842
0 COSMOS 84
1 01574U 65070E   24187.24338028 -.00000110  00000-0 -14172-3 0  9999
2 01574  56.0517 141.8881 0064570  19.7146  95.5732 12.37024410658334
0 SL-8 R/B
1 01575U 65070F   24187.58780596 -.00000086  00000-0  64711-4 0  9994
2 01575  56.1235 254.0667 0098078 197.2744 312.3472 12.56996825701281
0 VANGUARD DEB
1 01576U 58002C   24187.31197805  .00001336  00000-0  12080-2 0  9996
2 01576  34.2232 183.6578 1419172 187.9891 169.5626 11.76032556717953
0 PORCUPINE 2
1 01577U 65065J   24187.63339435  .00000124  00000-0  22329-3 0  9998
2 01577  89.9856 211.2987 0068614 312.6008 167.3799 13.36045062867634
0 OPS 8068
1 01580U 65072A   24187.54721790  .00000279  00000-0  97995-4 0  9992
2 01580  98.3447 359.6997 0231713 349.4261  10.2093 14.28571067 31364
0 THOR ALTAIR R/B
1 01583U 65072D   24187.53866664  .00001691  00000-0  30847-3 0  9995
2 01583  98.4794  34.8116 0149082 290.6744  67.8526 14.60527277 62877
0 COSMOS 86
1 01584U 65073A   24187.57806992 -.00000075  00000-0  12920-3 0  9997
2 01584  56.0579 268.9010 0214676  40.4675  63.2261 12.51899724688336
0 COSMOS 87
1 01585U 65073B   24187.54398795 -.00000069  00000-0  16427-3 0  9991
2 01585  56.0621  36.3955 0204438 151.5558 242.5202 12.47447136676952
0 COSMOS 88
1 01586U 65073C   24187.59507910 -.00000113  00000-0 -13216-3 0  9992
2 01586  56.0603 120.2539 0186276 300.7326 232.8444 12.43332604669999
0 COSMOS 89
1 01587U 65073D   24187.41487149 -.00000063  00000-0  22127-3 0  9999
2 01587  56.0539 227.8391 0169741  88.9881 273.0462 12.38974370660643
0 COSMOS 90
1 01588U 65073E   24187.60287144 -.00000079  00000-0  86618-4 0  9997
2 01588  56.0586 338.4421 0155070 225.7304 225.6421 12.34580439651115
0 SL-8 R/B
1 01589U 65073F   24187.61078782 -.00000132  00000-0 -32014-3 0  9996
2 01589  56.0505 134.1312 0160188 167.8487   3.1051 12.33039881647933
0 SL-8 DEB
1 01590U 65073G   24185.49502149  .00000112  00000-0  12998-2 0  9995
2 01590  56.0835 219.9614 0175549 163.1556 342.0566 12.49386636669122
0 SL-8 DEB
1 01591U 65073H   24187.44230447 -.00000398  00000-0 -21107-2 0  9992
2 01591  56.0560 245.0032 0151304 102.2812 352.5933 12.42662933660231
0 THOR ABLESTAR DEB
1 01608U 64083H   24187.20150255  .00001074  00000-0  95329-3 0  9991
2 01608  89.7583  84.7922 0019939 122.1733  37.9363 13.84110569976381
0 OV1-2
1 01613U 65078A   24187.58852214  .00005591  00000-0  55550-3 0  9997
2 01613 144.2199 129.7078 1176284 265.6581  80.9076 12.90510613622311
0 ATLAS D R/B
1 01616U 65078B   24187.52145025  .00007378  00000-0  66333-3 0  9995
2 01616 144.2307 198.4951 1027272 176.2560 184.6392 13.23724058655804
0 SL-8 DEB
1 01617U 65073J   24187.32694897  .00000772  00000-0  64206-2 0  9992
2 01617  56.1286 130.1452 0215226 101.1658  63.6041 12.34417360642521
0 SL-8 DEB
1 01618U 65073K   24187.37970402  .00000065  00000-0  12179-2 0  9994
2 01618  56.1733 195.6934 0227640  69.9673  44.9801 12.30166332635514
0 SL-8 DEB
1 01634U 65020ED  24187.44927234  .00000126  00000-0  39429-3 0  9993
2 01634  56.1535 201.5873 0851041 202.5081 153.6305 12.48053316673602
0 OV2-1
1 01641U 65082C   24187.29894866  .00000486  00000-0  10592-3 0  9995
2 01641  32.2977  53.2602 0018759  10.7276 349.3767 14.54011121113571
0 TITAN 3C TRANSTAGE DEB
1 01642U 65082D   24187.49810175  .00001441  00000-0  17286-3 0  9998
2 01642  32.0923 219.7478 0024363 165.7777 194.3562 14.81693814131820
0 TITAN 3C TRANSTAGE DEB
1 01646U 65082H   24187.54981159  .00001775  00000-0  25652-3 0  9995
2 01646  32.3111 327.9337 0002704 222.7564 137.2878 14.74548954114930
0 TITAN 3C TRANSTAGE DEB
1 01653U 65082Q   24186.98373277  .00000772  00000-0  13818-3 0  9993
2 01653  32.1197  68.3552 0041057  90.0832 270.4517 14.63260720107069
0 TITAN 3C TRANSTAGE DEB
1 01668U 65082AF  24187.45411538  .00002182  00000-0  28922-3 0  9994
2 01668  32.0669 193.5729 0015761 204.0229 155.9685 14.78132937112765
0 TITAN 3C TRANSTAGE DEB
1 01671U 65082AJ  24187.42824013  .00000577  00000-0  12773-3 0  9994
2 01671  32.1602 242.8504 0053310  23.3844 336.9209 14.52756980 82764
0 TITAN 3C TRANSTAGE DEB
1 01672U 65082AK  24187.57495800  .00085361  00000-0  32833-2 0  9991
2 01672  32.3551 345.0559 0034378  27.7727 332.4769 15.24543930 48052
0 TITAN 3C TRANSTAGE DEB
1 01680U 65082AT  24187.35047193  .00000599  00000-0  10398-3 0  9997
2 01680  32.2565  69.4256 0021447 283.1188  76.7066 14.64596520109173
0 TITAN 3C TRANSTAGE DEB
1 01682U 65082AV  24187.51320170  .00003478  00000-0  56324-3 0  9994
2 01682  32.4114 302.2205 0051387 151.5412 208.8061 14.69185746 85516
0 TITAN 3C TRANSTAGE DEB
1 01684U 65082AX  24187.49700978  .00001362  00000-0  37521-3 0  9999
2 01684  32.2142 268.1754 0177503  15.8032 344.8058 14.36228562 39979
0 TITAN 3C TRANSTAGE DEB
1 01716U 65082BX  24187.35870610  .00000980  00000-0  21020-3 0  9993
2 01716  32.1885 159.1247 0038945  82.5303 277.9764 14.55811576104610
0 TITAN 3C TRANSTAGE DEB
1 01722U 65082CD  24187.39809073  .00001131  00000-0  21433-3 0  9996
2 01722  32.4170 197.3147 0028315 252.2192 107.5367 14.61993930 94675
0 EXPLORER 29 (GEOS 1)
1 01726U 65089A   24187.48695248 -.00000080  00000-0 -20236-4 0  9999
2 01726  59.3760 188.9018 0719732 115.5790  44.5816 11.97066316564452
0 DELTA 1 R/B
1 01729U 65089B   24187.37428468 -.00000073  00000-0  23044-4 0  9999
2 01729  59.3867 174.2139 0717684  85.8215  53.6779 11.97548816565168
0 EXPLORER 30
1 01738U 65093A   24187.59061776  .00000324  00000-0  13329-3 0  9995
2 01738  59.7063 144.6784 0139788 103.0357 258.6329 14.41025033 53792
0 SCOUT X-4 R/B
1 01739U 65093B   24187.43508636  .00001217  00000-0  31860-3 0  9992
2 01739  59.7030 166.5228 0075669 319.9141  39.6333 14.53286579 66781
0 A-1 (ASTERIX)
1 01778U 65096A   24187.04991937  .00000376  00000-0  97164-4 0  9990
2 01778  34.2592  77.9603 0745543 210.9586 144.4998 13.48397034868565
0 ALOUETTE 2
1 01804U 65098A   24187.41680556  .00000330  00000-0  11020-3 0  9991
2 01804  79.8010 161.6295 1335251 234.4731 112.4575 12.27089847591923
0 DIAMANT R/B
1 01805U 65096B   24187.33167818  .00003549  00000-0  75610-3 0  9992
2 01805  34.2481  50.0576 0599697 150.1409 213.4903 13.83728183905882
0 EXPLORER 31 (ISIS-X)
1 01806U 65098B   24187.50267273  .00000472  00000-0  15532-3 0  9999
2 01806  79.7752 216.3583 1431257  88.1450 288.2403 12.06856508562776
0 THOR AGENA B R/B
1 01807U 65098C   24187.40400972  .00000828  00000-0  27069-3 0  9997
2 01807  79.8364 284.0171 1337584  33.5738 334.3246 12.26468113585971
0 FR 1
1 01814U 65101A   24187.57992876  .00001601  00000-0  27564-3 0  9997
2 01814  75.8664 137.0782 0003380  50.6794 309.4686 14.69040626951486
0 SCOUT X-4 R/B
1 01815U 65101B   24187.50217694  .00003831  00000-0  45351-3 0  9990
2 01815  75.8426 172.9901 0003626 195.6840 164.4237 14.84783287962295
0 TITAN 3C TRANSTAGE DEB
1 01829U 65082DU  24187.46283036  .00003443  00000-0  40823-3 0  9999
2 01829  32.2915 337.7759 0027869 277.3023  82.4463 14.82947225114514
0 TITAN 3C TRANSTAGE DEB
1 01833U 65082DY  24187.59071420  .00002830  00000-0  48971-3 0  9991
2 01833  32.2252 144.6400 0069036 123.9539 236.7694 14.65424072 65113
0 TITAN 3C TRANSTAGE DEB
1 01835U 65082EA  24187.31848513  .00004467  00000-0  35314-3 0  9993
2 01835  32.3922 191.5977 0013919 252.2556 107.6585 14.99359631140040
0 TITAN 3C TRANSTAGE DEB
1 01859U 65082ES  24187.56156526  .00000576  00000-0  13973-3 0  9996
2 01859  32.1272 323.1359 0068270 207.5401 152.1612 14.47679117 83815
0 TITAN 3C TRANSTAGE R/B
1 01863U 65108A   24187.55379854  .00001128  00000-0  66366-3 0  9998
2 01863  26.8874  20.4428 6042937 327.1242   6.6757  3.92340368340137
0 OPS 1509 (TRANSIT 10)
1 01864U 65109A   24187.63178810  .00000269  00000-0  24163-3 0  9992
2 01864  89.0668 306.0535 0109527 211.3649 148.0956 13.78674433938043
0 SCOUT A R/B
1 01865U 65109B   24187.62485688  .00000120  00000-0  10600-3 0  9993
2 01865  89.0762 319.2068 0110876 336.1479  23.4570 13.76552028935725
0 TITAN 3C TRANSTAGE DEB
1 01883U 65082EY  24187.36869252  .00006245  00000-0  36417-3 0  9995
2 01883  32.0932 310.4181 0017905 266.0707  93.7904 15.10595369157064
0 TITAN 3C TRANSTAGE DEB
1 01915U 65082FZ  24187.29628300  .00000793  00000-0  16286-3 0  9994
2 01915  31.8757 165.0768 0029295 328.2109  31.6762 14.57162803111458
0 THOR ALTAIR DEB
1 01931U 65072E   24187.55540633  .00002855  00000-0  77597-3 0  9995
2 01931  99.0309 180.9294 0244553 357.3686   2.6193 14.32208322 90850
0 THOR ABLESTAR DEB
1 01942U 61015HS  24187.08570586 -.00000240  00000-0 -37577-3 0  9990
2 01942  67.2704  54.3596 0340305  20.6791 129.7275 13.12361564 23332
0 THOR ABLESTAR DEB
1 01943U 61015HT  24187.39798134  .00001253  00000-0  56829-3 0  9990
2 01943  66.8557 213.1848 0046474 111.0775 249.5300 14.24560347242636
0 THOR AGENA B DEB
1 01948U 65098F   24187.43058920  .00009822  00000-0  19415-2 0  9996
2 01948  79.8515 297.0718 0816013 230.3274 122.3119 13.45583947712731
0 THOR AGENA B DEB
1 01951U 65098G   24187.51416009  .00012253  00000-0  24190-2 0  9993
2 01951  79.6181 339.7269 0824832 212.1767 142.6413 13.43891706711374
0 OPS 1593 (TRANSIT 11)
1 01952U 66005A   24187.49448974  .00000166  00000-0  15837-3 0  9995
2 01952  90.1616 340.4393 0217198 342.2012  17.1622 13.67690555908856
0 SCOUT A R/B
1 01953U 66005B   24187.49812292  .00000230  00000-0  22678-3 0  9997
2 01953  90.1591 341.4436 0229370 135.7303 226.2460 13.64816867905797
0 TITAN 3C TRANSTAGE DEB
1 01959U 65082GU  24187.41252611  .00000953  00000-0  19104-3 0  9994
2 01959  31.7892 250.4713 0063830 268.9056  90.4268 14.57430783109779
0 TITAN 3C TRANSTAGE DEB
1 01961U 65082GW  24187.27965464  .00005870  00000-0  43218-3 0  9994
2 01961  31.8596 158.3793 0003857 100.7094 259.3992 15.02102322136468
0 TITAN 3C TRANSTAGE DEB
1 01964U 65082GZ  24187.55590569  .00001989  00000-0  71816-3 0  9990
2 01964  32.1890 148.6740 0184501 295.5620  62.6047 14.23052971 16065
0 ESSA 1 (OT-3)
1  1982U 66008A   24187.21937806  .00000455  00000-0  12931-3 0  9991
2  1982  97.9109 257.4895 0081540 141.4104 219.2957 14.47667462 75666
0 DELTA 1 R/B
1 01983U 66008B   24187.48955322  .00001509  00000-0  28122-3 0  9994
2 01983  98.0278 108.1178 0067488 189.1696 170.8281 14.65032090 68276
0 MIDAS 4 DEB
1 02009U 61028E   24187.08510065 -.00000005  00000-0 -65847-3 0  9995
2 02009  95.8620  80.1223 0121726 236.1233 122.7989  8.68991037328145
0 SCOUT X-4 DEB
1 02011U 65032D   24186.66237432  .00000894  00000-0  15203-2 0  9998
2 02011  41.1985 297.0768 0239579 171.4254 327.0713 13.39431354881716
0 DIAPASON (D1-A)
1 02016U 66013A   24187.47402016  .00001087  00000-0  30744-3 0  9998
2 02016  34.0977 102.5217 1173870 294.8195  53.4873 12.62946160650271
0 DIAMANT R/B
1 02017U 66013B   24187.46178359  .00001356  00000-0  35043-3 0  9994
2 02017  34.0743 359.9272 1056832 267.5645  80.3811 12.88750926677728
0 TITAN 3C TRANSTAGE DEB
1  2050U 65082JL  24186.91928838  .00000998  00000-0  23695-3 0  9991
2  2050  32.2670  48.8259 0087188 274.7055  84.3636 14.49230891 75831
0 SCOUT X-4 DEB
1 02088U 65093D   24187.49214731  .00002266  00000-0  49721-3 0  9996
2 02088  59.7153 165.1810 0092157 109.3412 251.7626 14.58108964 49925
0 ESSA 2 (OT-2)
1 02091U 66016A   24187.54100815 -.00000034  00000-0  51769-4 0  9997
2 02091 101.2492 102.8687 0038281 260.5626 274.3575 12.69410632703326
0 THOR AGENA B DEB
1 02092U 65098H   24187.58654185  .00002280  00000-0  73689-3 0  9993
2 02092  79.8599 248.0399 1313144 125.8891 247.1402 12.31910303592658
0 DELTA 1 R/B
1 02096U 66016B   24187.60319354  .00000002  00000-0  22144-3 0  9997
2 02096 100.9583  50.8045 0039590 185.9024 241.4193 12.69946453703746
0 TRANSIT 5B-1 DEB
1 02097U 63038G   24187.40650353  .00000754  00000-0  91398-3 0  9995
2 02097  90.0186 337.6273 0042035 144.4686 269.8439 13.65044409  2461
0 DELTA 1 DEB
1 02118U 66008D   24186.41634207  .00000973  00000-0  26531-3 0  9999
2 02118  97.9619 346.6508 0128842 248.1790 110.5655 14.44752659 32817
0 OPS 1117 (TRANSIT 12)
1 02119U 66024A   24187.54867242  .00000315  00000-0  29369-3 0  9992
2 02119  89.6337 117.3636 0148360  34.5889 326.4818 13.75016467917376
0 SCOUT A R/B
1 02120U 66024B   24187.57165395  .00000152  00000-0  14290-3 0  9993
2 02120  89.8140 185.2884 0151480 192.9260 166.8004 13.72374364914303
0 OV1-4
1 02121U 66025A   24187.53890713  .00000398  00000-0  10649-3 0  9996
2 02121 144.5067  26.7410 0083585 325.7833  33.7492 13.87137366952273
0 OV1-5
1 02122U 66025B   24187.53901526  .00000305  00000-0  55658-4 0  9990
2 02122 144.6358  85.6068 0047004  30.7120 329.6295 13.66025093907750
0 OV1-5 R/B
1 02123U 66025C   24187.48175856  .00000309  00000-0  60323-4 0  9993
2 02123 144.6429  69.1080 0046316  29.3718 330.9550 13.65770236907443
0 OV1-4 R/B
1 02124U 66025D   24187.58437657  .00000348  00000-0  63294-4 0  9998
2 02124 144.5120  77.7334 0080193  64.2896 296.6043 13.87620749952693
0 OPS 0340
1 02125U 66026A   24187.45836433  .00000645  00000-0  12842-3 0  9993
2 02125  97.9886   8.8500 0150339 316.8168  42.1321 14.58614611 55701
0 SCOUT A DEB
1 02140U 66005C   24187.58453771  .00000424  00000-0  48914-3 0  9995
2 02140  89.9337  54.3504 0319931  79.5059 284.1966 13.47835413862573
0 SCOUT A DEB
1 02141U 66005D   24187.12715962  .00000921  00000-0  54136-3 0  9994
2 02141  90.2047 240.7792 0115631 160.8718 199.6861 14.04161535968699
0 OAO 1
1 02142U 66031A   24187.49143866  .00000227  00000-0  86704-4 0  9998
2 02142  35.0447 259.9463 0006455 116.3709 243.7641 14.34275137 48836
0 ATLAS AGENA D R/B
1 02144U 66031B   24187.54094951  .00000632  00000-0  18872-3 0  9996
2 02144  35.0430 332.9909 0007511 102.6911 257.4620 14.43830596 59819
0 OPS 1527 (OV3-1)
1 02150U 66034A   24187.54017437  .00015793  00000-0  90822-3 0  9999
2 02150  82.3766 294.1834 1503521 226.8496 119.6945 12.36753394312854
0 THOR AGENA B DEB
1 02153U 65098J   24187.54329608  .00001958  00000-0  62032-3 0  9997
2 02153  79.7454 332.1443 1289568  71.7705  34.7161 12.37118124598942
0 DELTA 1 DEB
1 02154U 66008E   24187.62820773  .00001930  00000-0  33747-3 0  9999
2 02154  97.7964 320.3544 0050342  66.2751 294.3725 14.68130046 74453
0 NIMBUS 2
1 02173U 66040A   24187.49103300  .00000001  00000-0  97947-4 0  9992
2 02173 100.5840  13.7294 0055579 161.5670 254.0104 13.33652519828750
0 THOR AGENA B R/B
1 02174U 66040B   24187.60928741  .00000009  00000-0  10841-3 0  9995
2 02174 100.3244  95.5586 0055561 289.3240 134.8755 13.36213175834187
0 OPS 0082 (TRANSIT 13)
1 02176U 66041A   24187.59216246  .00000456  00000-0  27779-3 0  9990
2 02176  90.2193  65.4069 0068666 194.4370 165.4851 14.03686363967598
0 THOR ALTAIR DEB
1 02177U 66026D   24187.52053829  .00005810  00000-0  80165-3 0  9990
2 02177  98.9239  92.1553 0150013  62.8265 298.8142 14.71078786 57817
0 SCOUT A R/B
1 02180U 66041B   24187.59554742  .00000364  00000-0  23148-3 0  9995
2 02180  90.2156  65.3038 0080568  44.9134 315.8526 14.00635310963644
0 OPS 1427 (OV3-4)
1 02201U 66052A   24187.46809527 -.00000033  00000-0  27842-4 0  9991
2 02201  40.8818 232.7347 2235556  82.7680 301.9763 10.09897447125379
0 SCOUT B R/B
1 02206U 66052B   24187.48810163  .00000055  00000-0  13649-3 0  9998
2 02206  40.8605   6.4244 2209936   3.4127 357.9180 10.14207342130521
0 OPS 9381 (GGTS)
1 02207U 66053A   24187.54659756 -.00000071  00000-0  00000-0 0  9999
2 02207   7.3318  49.6506 0025098 214.8627   2.9469  1.08003070228279
0 OPS 9311 (IDSCS 1)
1 02215U 66053B   24183.42607026 -.00000070  00000-0  00000-0 0  9993
2 02215   7.3394  49.9309 0028596 202.6547 157.1478  1.07908462126647
0 OPS 9312 (IDSCS 2)
1 02216U 66053C   24184.40128368 -.00000091  00000-0  00000-0 0  9993
2 02216   7.3241  50.1143 0030562 196.7527  25.7951  1.07850459 41550
0 OPS 9313 (IDSCS 3)
1 02217U 66053D   24186.04414051 -.00000110  00000-0  00000-0 0  9995
2 02217   7.2997  50.4124 0034348 188.6505 171.2207  1.07754772131835
0 OPS 9314 (IDSCS 4)
1 02218U 66053E   24187.26693750 -.00000062  00000-0  00000-0 0  9992
2 02218   7.2181  50.9870 0042138 177.6219 310.1028  1.07584398227746
0 OPS 9315 (IDSCS 5)
1 02219U 66053F   24184.61912871 -.00000124  00000-0  00000-0 0  9996
2 02219   7.1925  51.5663 0050710 168.8892 191.1403  1.07399235 48854
0 OPS 9316 (IDSCS 6)
1 02220U 66053G   24187.47243448 -.00000108  00000-0  00000-0 0  9994
2 02220   7.0917  52.3477 0063572 160.6508  98.9951  1.07156923131425
0 OPS 9317 (IDSCS 7)
1 02221U 66053H   24184.76332278 -.00000104  00000-0  00000-0 0  9990
2 02221   7.0323  53.2555 0078909 153.5960 206.7161  1.06869735 43398
0 TITAN 3C TRANSTAGE R/B
1 02222U 66053J   24187.45918480 -.00000145  00000-0  00000-0 0  9990
2 02222   6.9915  54.2687 0160064 149.6641  89.4316  1.06721546122783
0 DELTA 1 DEB
1 02223U 66016C   24186.33954233 -.00000019  00000-0  99580-4 0  9997
2 02223 100.8219 226.7888 0092837 297.2652 126.5968 12.87726467735209
0 DELTA 1 DEB
1 02224U 66016D   24186.45952319 -.00000033  00000-0  51896-4 0  9998
2 02224 101.0848 140.4717 0137405 192.0375 296.0178 12.52133696656698
0 SCOUT A DEB
1 02226U 65109D   24186.01407359  .00000214  00000-0  26258-3 0  9996
2 02226  89.0666  14.2852 0246517 308.1286  49.7870 13.50883286857384
0 THOR AGENA D R/B
1 02255U 66056B   24186.96657079  .00000034  00000-0  30248-1 0  9992
2 02255  86.9339 242.2940 0050122 329.1241  30.6622  7.94758361683735
0 PAGEOS 1 DEB
1 02256U 66056C   24187.09734132  .00000030  00000-0  27255-1 0  9994
2 02256  86.9109 222.7389 0031600  12.1015 348.0545  7.93573891681986
0 ATLAS D DEB
1 02327U 66063B   24187.31105374  .00001836  00000-0  99427-3 0  9993
2 02327 144.1945 216.8353 0030246  24.7775 335.4366 14.02779881937982
0 ATLAS D R/B
1 02328U 66063C   24187.56924354  .00000301  00000-0  60783-4 0  9998
2 02328 144.2288 176.1823 0010024 328.5488 142.5354 13.69897942902620
0 ATLAS D DEB
1 02329U 66063D   24187.54692829  .00000807  00000-0  42902-3 0  9999
2 02329 144.2856 101.9299 0022137 193.1122 336.5339 13.90778781923066
0 SL-8 DEB
1 02334U 65020EH  24187.47187544  .00000388  00000-0  60764-3 0  9992
2 02334  55.6765 349.2480 0584531 316.9899  38.6714 13.10843302757552
0 ATLAS D DEB
1 02337U 66063E   24187.62109792  .00000413  00000-0  17853-3 0  9999
2 02337 144.2331 315.0960 0005091 164.6753 212.6272 13.72049644904292
0 SCOUT A DEB
1 02353U 66024C   24187.10041558  .00000403  00000-0  36254-3 0  9997
2 02353  89.3731  60.0128 0154488  66.3925 295.3376 13.76888630917028
0 WESTFORD NEEDLES
1 02359U 63014J   24187.13879372  .00003524  00000-0  91554+0 0  9992
2 02359  87.0112  88.2050 1034284 119.4678 251.3370  8.70224548852737
0 WESTFORD NEEDLES
1 02361U 63014L   24187.12709949 -.00000040  00000-0 -19013-1 0  9990
2 02361  87.3324 247.9718 0267494 351.0755   8.5404  8.66330654933341
0 WESTFORD NEEDLES
1 02362U 63014M   24187.20531256  .00006001  00000-0  90484-1 0  9996
2 02362  85.3623 102.4074 2425597 158.8034 213.3800  8.82751509943786
0 WESTFORD NEEDLES
1  2364U 63014P   24186.90806988 -.00000002  00000-0 -25706-2 0  9994
2  2364  87.5757 344.8778 0694294  63.6751 303.3718  8.67511664934194
0 WESTFORD NEEDLES
1 02365U 63014Q   24186.93623918  .00000106  00000-0  44576-1 0  9996
2 02365  87.3141 166.8709 0358229 301.3591  55.2677  8.67657507935246
0 WESTFORD NEEDLES
1 02367U 63014S   24174.15057807 -.00000003  00000-0  00000-0 0  9997
2 02367  84.9462 235.4878 2539886 282.9809  50.1843  8.87712911947228
0 WESTFORD NEEDLES
1 02375U 63014W   24187.54525647 -.00001381  00000-0 -15037+0 0  9991
2 02375  86.4079 149.8585 1640780 244.6959  97.5326  8.74772308309198
0 WESTFORD NEEDLES
1 02378U 63014Y   24187.05067416  .00000084  00000-0  37390-1 0  9990
2 02378  87.3443 225.4219 0067139  43.4614 317.1508  8.66556618933791
0 WESTFORD NEEDLES
1  2380U 63014AA  24182.92532203  .00000117  00000-0  49289-1 0  9992
2  2380  87.2621 149.5866 0331452 217.6425 140.0806  8.67908614936337
0 WESTFORD NEEDLES
1 02381U 63014AB  24186.38819255  .00000111  00000-0  45699-1 0  9997
2 02381  87.2871 166.8645 0417207 298.5166  57.4285  8.67590450329451
0 SCOUT A DEB
1 02386U 66024D   24187.38525794  .00000310  00000-0  26860-3 0  9991
2 02386  90.0677 327.3570 0128419 348.2642  11.5540 13.80909441223687
0 OV3-3
1 02389U 66070A   24187.57051780  .00018472  00000-0  92328-3 0  9995
2 02389  81.3316 227.9549 1120815 173.3093 188.4563 13.19990624504062
0 OPS 2366 (TRANSIT 14)
1 02401U 66076A   24187.44795803  .00000134  00000-0  17966-3 0  9994
2 02401  88.8702 148.6596 0031314 207.6417 266.5199 13.53692268854796
0 OPS 0856
1 02403U 66077A   24187.25838934  .00000008  00000-0  31391-2 0  9996
2 02403  90.3331 268.0498 0012616  76.5598 283.6659  8.59850597465261
0 SECOR 7 (EGRS 7)
1 02411U 66077B   24186.68901478 -.00000003  00000-0 -22618-2 0  9994
2 02411  90.3319 269.1330 0015066  60.0595 300.1751  8.59615526816157
0 ERS 15
1 02412U 66077C   24187.17479024  .00000002  00000-0  00000-0 0  9993
2 02412  90.3316 268.9369 0009262  66.5150 293.6674  8.59077105329315
0 SCOUT A R/B
1 02413U 66076B   24187.40751899  .00000085  00000-0  11122-3 0  9993
2 02413  88.8729 154.1427 0031077 328.5476  31.3816 13.51719691852494
0 OPS 6026 (DMSP 4A F1)
1 02418U 66082A   24187.41003341  .00000387  00000-0  11952-3 0  9994
2 02418  98.2504 347.7710 0117609  21.4128 339.1925 14.42806832  9601
0 THOR BURNER 2 R/B
1 02422U 66082B   24187.42056459  .00000738  00000-0  20665-3 0  9999
2 02422  98.1613 354.1592 0111690 218.3292 140.9925 14.45405349 12398
0 WESTFORD NEEDLES
1  2431U 63014AC  24186.17926393  .00000063  00000-0  24198-1 0  9999
2  2431  87.4406 256.8739 0500130 350.2558   8.8885  8.68780843864106
0 THOR ABLESTAR DEB
1 02432U 63049G   24187.59021086  .00000123  00000-0  18206-3 0  9992
2 02432  89.9140  76.6626 0035727 121.9026 283.2744 13.48070844976812
0 ESSA 3 (TOS-A)
1 02435U 66087A   24187.57737655 -.00000036  00000-0  34220-4 0  9993
2 02435 101.0685 121.8656 0064269  18.7752 154.5317 12.56864718649602
0 DELTA 1 R/B
1 02436U 66087B   24187.60562252 -.00000010  00000-0  18035-3 0  9994
2 02436 100.9419 176.7510 0065796  16.2740 344.0431 12.57630446650650
0 OPS 1920
1 02481U 66089A   24187.46884185  .00000002  00000-0 -76340-5 0  9998
2 02481  89.7986  35.8665 0032092 313.0422  46.7743  8.59253840811531
0 SCOUT B DEB
1 02498U 66052C   24186.58647243  .00002481  00000-0  20898-2 0  9996
2 02498  40.6426 276.0896 2086072 230.6149 109.0680 10.54155303401551
0 PAGEOS 1 DEB
1 02511U 66056D   24186.68125338 -.00000006  00000-0 -79621-2 0  9994
2 02511  86.9906 287.4037 0016768  41.5482 318.6595  7.93367145296078
0 INTELSAT 2-F1
1 02514U 66096A   24187.17142580  .00000273  00000-0  00000-0 0  9991
2 02514  16.6764 191.0987 6409940 291.9357  13.8144  2.00457617 80536
0 DELTA 1 DEB
1 02518U 66087C   24187.36799428 -.00000031  00000-0  49894-4 0  9996
2 02518 100.7913 340.0385 0081365 158.5573 277.4837 12.42677293619006
0 SECOR 8 (EGRS 8)
1 02520U 66089B   24186.98132111  .00000026  00000-0  12012-1 0  9990
2 02520  89.7986  35.9645 0014434 301.9743  57.9704  8.58895216320800
0 LES 2 AKM
1 02529U 65034D   24187.33738892 -.00000035  00000-0  00000-0 0  9990
2 02529  32.1433  72.3166 3966748 147.2125 245.1891  4.64835473987442
0 WESTFORD NEEDLES
1 02530U 63014AJ  24187.03373542  .00000207  00000-0  92013-1 0  9998
2 02530  87.6451 215.1899 0146721 126.3971 258.5478  8.67919224877805
0 SCOUT A DEB
1 02580U 66076C   24186.42628976  .00000322  00000-0  29850-3 0  9999
2 02580  89.1566 351.0261 0094240 326.1011  92.1941 13.78103524893711
0 ATS 1
1 02608U 66110A   24187.18111421 -.00000250  00000-0  00000-0 0  9999
2 02608   3.1827  75.9194 0004606 153.2614  82.3512  1.00338070127656
0 OV1-9
1 02610U 66111A   24187.60174618  .00000477  00000-0  19607-3 0  9993
2 02610  99.1189 302.9473 2278596  24.7194 344.7615 10.38428722159116
0 THOR ABLESTAR DEB
1 02620U 63049H   24187.45136251  .00000352  00000-0  46465-3 0  9999
2 02620  89.9125  78.8484 0017727  32.9033 143.1229 13.59180601993714
0 OV1-10 R/B
1 02621U 66111C   24187.44823149  .00001385  00000-0  16513-3 0  9999
2 02621  93.4092 260.8820 0060820  74.0487 286.7426 14.83203049 68768
0 OV1-9 R/B
1 02622U 66111D   24187.56129574  .00001371  00000-0  54023-3 0  9997
2 02622  99.1009  49.8174 2231307  86.8256 298.3563 10.47796346170278
0 INTELSAT 2-F2
1 02639U 67001A   24187.59725823 -.00000298  00000-0  00000-0 0  9997
2 02639   1.4193  83.6984 0004687 170.8740  23.7877  1.00221724112119
0 DELTA 1 R/B(2)
1 02643U 67001D   24186.70691295  .00007588  00000-0  32946-2 0  9993
2 02643  25.8826  29.3405 6031134 160.9080 238.3304  3.95109180727255
0 SCOUT A DEB
1 02644U 66041D   24187.61075538  .00000370  00000-0  31155-3 0  9998
2 02644  90.1353  33.8705 0214341   2.6625 357.5627 13.76461232900774
0 OPS 9321 (IDSCS 8)
1 02645U 67003A   24186.63255303 -.00000135  00000-0  00000-0 0  9991
2 02645   7.0097  50.7121 0036562  99.4056  82.6765  1.08317825226732
0 SL-8 DEB
1  2647U 65073L   24187.57095722  .00000112  00000-0  13803-2 0  9990
2  2647  56.0660 287.1316 0186718 198.4399 259.5444 12.43533335 29068
0 OPS 9322 (IDSCS 9)
1 02649U 67003B   24186.96671630 -.00000084  00000-0  00000-0 0  9999
2 02649   6.9688  50.6518 0036354  95.7091  88.2966  1.08281687131721
0 OPS 9323 (IDSCS 10)
1 02650U 67003C   24187.47683391 -.00000083  00000-0  00000-0 0  9994
2 02650   6.9529  50.8383 0036270  88.9972  89.2468  1.08221678132743
0 OPS 9324 (IDSCS 11)
1 02651U 67003D   24184.34532184 -.00000101  00000-0  00000-0 0  9992
2 02651   6.9138  51.2320 0037386  75.5562 137.7266  1.08105484133014
0 OPS 9325 (IDSCS 12)
1 02652U 67003E   24183.81819898 -.00000078  00000-0  00000-0 0  9997
2 02652   6.8950  51.9198 0041190  60.4531 299.8743  1.07942591132390
0 OPS 9326 (IDSCS 13)
1 02653U 67003F   24180.80496899 -.00000084  00000-0  00000-0 0  9993
2 02653   6.8019  52.3812 0048680  45.0488 315.2898  1.07748272124953
0 OPS 9327 (IDSCS 14)
1 02654U 67003G   24186.86966050 -.00000105  00000-0  00000-0 0  9991
2 02654   6.7679  53.2434 0060125  31.9187 187.7458  1.07511489131818
0 OPS 9328 (IDSCS 15)
1 02655U 67003H   24186.83506000 -.00000086  00000-0  00000-0 0  9992
2 02655   6.6529  53.9402 0075338  21.2942 170.1924  1.07229809131565
0 ESSA 4 (TOS-B)
1 02657U 67006A   24187.40061616 -.00000041  00000-0  43284-4 0  9996
2 02657 102.0451 340.4336 0072849 233.9484 182.8424 12.69871503662196
0 DELTA 1 R/B
1 02661U 67006B   24187.60362987 -.00000027  00000-0  11070-3 0  9999
2 02661 102.0209 230.7551 0064761  11.6304 106.2489 12.67992824657966
0 OPS 6073 (DMSP 4A F2)
1 02669U 67010A   24187.49765201  .00000247  00000-0  11840-3 0  9993
2 02669  99.0332 151.3371 0048151 277.0569  82.5136 14.27640192982759
0 DIAMANT R/B
1 02671U 67011B   24187.48309712  .00001652  00000-0  34579-3 0  9992
2 02671  39.9438 186.0404 0342856  75.4106 288.4421 14.31470129953477
0 DIADEME 1
1  2674U 67011A   24187.49171265  .00004353  00000-0  55587-3 0  9999
2  2674  39.9164 202.4914 0234025  56.6001 305.6934 14.64694825984885
0 DIADEME 2
1 02680U 67014A   24187.55027202  .00000320  00000-0  15582-3 0  9998
2 02680  39.4455  22.5439 0711586 306.8594  46.8905 13.40117451780426
0 DIAMANT R/B
1 02682U 67014B   24187.38773947  .00000481  00000-0  22699-3 0  9990
2 02682  39.4621 149.4246 0754381 268.5874  82.8396 13.30256458768984
0 DIAMANT DEB
1 02684U 67014C   24187.51251416  .00002647  00000-0  65850-3 0  9991
2 02684  39.9602 270.4639 0469069 335.3414  22.5563 14.02719610840779
0 DIAMANT DEB
1 02685U 67014F   24186.15280691  .00008595  00000-0  16909-2 0  9996
2 02685  38.9344 204.2650 0392484 293.5835  62.4164 14.23360785865245
0 DELTA 1 DEB
1 02700U 65089C   24183.85461081 -.00000317  00000-0 -12207-2 0  9995
2 02700  59.5948 130.6618 0717678 346.3313  39.0933 12.08945702624967
0 THOR ABLESTAR DEB
1 02701U 65048E   24187.36705321  .00000431  00000-0  52755-3 0  9997
2 02701  89.8948 296.0833 0063710 190.1492 237.2597 13.63314859924320
0 SCOUT A DEB
1 02702U 66076D   24187.19734351  .00000191  00000-0  33841-3 0  9994
2 02702  88.5765 358.2919 0089921 119.4415 302.4753 13.36319356801231
0 DELTA 1 DEB
1 02706U 67006C   24186.56175765 -.00000024  00000-0  13946-3 0  9990
2 02706 102.2182 185.4102 0035293 343.2624 133.8010 12.60897778642733
0 DELTA 1 DEB
1 02707U 67006D   24186.72660536 -.00000028  00000-0  90601-4 0  9992
2 02707 101.8083 112.7980 0149464   2.5635  25.3018 12.79353422681244
0 INTELSAT 2-F3
1 02717U 67026A   24187.18938137  .00000016  00000-0  00000-0 0  9997
2 02717   2.3235  69.7437 0015739 208.3497  77.9399  1.00240019116759
0 THOR BURNER 2 R/B
1  2741U 67010B   24187.53168494  .00000248  00000-0  11574-3 0  9995
2  2741  98.9054 112.9455 0052736 190.7476 169.2582 14.28568258984075
0 OPS 0100 (TRANSIT 15)
1 02754U 67034A   24187.56874869  .00000177  00000-0  23492-3 0  9991
2 02754  90.2060  19.1244 0021462  70.4887 348.0183 13.57130183829588
0 SCOUT A R/B
1 02755U 67034B   24187.55462777  .00000060  00000-0  76816-4 0  9992
2 02755  90.2400  37.5350 0023699 262.9879 154.8909 13.53857143825743
0 ESSA 5
1 02757U 67036A   24187.39915999 -.00000051  00000-0 -13726-4 0  9990
2 02757 101.9147 333.4861 0042738 210.1989 164.5925 12.68525161648724
0 DELTA 1 R/B
1 02758U 67036B   24187.60907545 -.00000006  00000-0  21372-3 0  9997
2 02758 101.9258  63.2602 0040494 293.6782  66.0051 12.68888947649038
0 OPS 6638 (VELA 7)
1 02765U 67040A   24191.21787369 -.00001435  00000-0  00000-0 0  9991
2 02765  37.2403  25.7751 4714903 260.7106 358.0572  0.21499723 11984
0 OPS 6679 (VELA 8)
1 02766U 67040B   24187.80689658 -.00001572  00000-0  00000-0 0  9996
2 02766  32.6142  19.5060 4617609  90.2248 359.7321  0.21285031  3982
0 TITAN 3C TRANSTAGE R/B
1  2770U 67040F   24187.60119134 -.00000292  00000-0  00000+0 0  9993
2  2770  17.5068 231.1797 7929414 312.8914   0.0807  0.50947652100867
0 DELTA 1 DEB
1 02775U 66087D   24186.83566848 -.00000006  00000-0  17266-3 0  9999
2 02775 100.9557 212.9953 0125166 154.2567  19.2151 12.71660789679785
0 SCOUT A DEB
1 02777U 67034C   24186.10837606  .00000948  00000-0  54835-3 0  9994
2 02777  90.2443 224.0672 0133107 210.5532 148.7849 14.04062403909332
0 SCOUT A DEB
1 02778U 67034D   24187.34747229  .00000372  00000-0  69284-3 0  9998
2 02778  89.8220  48.9253 0121841 199.2976 227.8213 13.34741391778177
0 TITAN 3C TRANSTAGE DEB
1 02789U 65082KR  24187.47763390  .00014661  00000-0  15986-2 0  9997
2 02789  32.2808 282.6976 0071753 359.7175   0.3431 14.85079614973646
0 WESTFORD NEEDLES
1 02796U 63014AQ  24185.89309788  .00000135  00000-0  57006-1 0  9998
2 02796  87.2697 157.9599 0337290 219.2972 138.2954  8.67882231863156
0 TITAN 3C TRANSTAGE DEB
1 02799U 65082KX  24187.45713079  .00002213  00000-0  34827-3 0  9991
2 02799  32.0561 307.0275 0035048 215.0705 209.3610 14.70474504 51159
0 SCOUT B DEB
1 02800U 66070D   24187.33222482  .00010600  00000-0  14260-2 0  9999
2 02800  81.4077  46.8675 1447807 162.9055 202.6628 12.29486369496751
0 COSMOS 158
1 02801U 67045A   24187.56378410  .00000059  00000-0  28336-4 0  9999
2 02801  74.0413 293.0499 0058013 314.6434  44.9996 14.36771746994267
0 SL-8 R/B
1 02802U 67045B   24187.60479258  .00000420  00000-0  12591-3 0  9994
2 02802  74.0119  50.5206 0066133 206.0198 153.7631 14.44692198   597
0 OPS 7218 (TRANSIT 16)
1 02807U 67048A   24187.57634463  .00000150  00000-0  21771-3 0  9999
2 02807  89.6711  11.1944 0019812 189.2935 235.1154 13.50527438811873
0 SCOUT A R/B
1 02811U 67048B   24187.53977353  .00000084  00000-0  11692-3 0  9995
2 02811  89.6722  13.9306 0017548 250.4249 171.0285 13.49183903810544
0 THOR AGENA D R/B
1 02825U 67053B   24187.33123155  .00000066  00000-0  84653-4 0  9995
2 02825  69.9707 161.5270 0006822 356.7643   3.3418 13.97455248992659
0 OPS 5712 (P/L 160)
1 02826U 67053A   24187.57134768  .00008418  00000-0  17698-2 0  9996
2 02826  69.9259 321.1401 0003149 357.0899   3.0221 14.59843610961645
0 GGSE 4
1 02828U 67053C   24187.29818294  .00000105  00000-0  11232-3 0  9994
2 02828  69.9704 151.9132 0007552 356.0219   4.0826 13.97782977908674
0 GGSE 5
1 02834U 67053D   24187.51456988  .00000063  00000-0  84456-4 0  9996
2 02834  69.9709 216.7474 0005601  34.5317 325.6151 13.96015152906804
0 TIMATION 1
1 02847U 67053E   24187.57185661  .00000284  00000-0  22029-3 0  9995
2 02847  69.9663 308.2771 0008634 275.6915  84.3209 14.02400195913999
0 SECOR 9 (EGRS 9)
1 02861U 67065A   24187.32163241 -.00000025  00000-0 -16595-1 0  9991
2 02861  90.0322 314.1061 0073739  58.1751 302.6239  8.36659887741510
0 OPS 9331 (IDSCS 16)
1 02862U 67066A   24187.45730157 -.00000098  00000-0  00000-0 0  9995
2 02862   1.3077 127.6504 0062473 199.3340 228.5098  1.09955872129376
0 OPS 9332 (IDSCS 17)
1 02863U 67066B   24187.11299519 -.00000098  00000-0  00000-0 0  9991
2 02863   1.2856 126.7655 0061029 197.3585  44.7226  1.09897471116897
0 OPS 9333 (IDSCS 18)
1 02864U 67066C   24185.53170375 -.00000081  00000-0  00000-0 0  9996
2 02864   1.2348 130.3739 0058051 187.3579  99.0631  1.09785876123707
0 OPS 9334 (DATS)
1  2865U 67066D   24186.13357264 -.00000112  00000-0  00000+0 0  9992
2  2865   1.1708 131.2560 0054599 176.9239 114.0165  1.09624937122551
0 LES 5
1 02866U 67066E   24187.10448877 -.00000090  00000-0  00000-0 0  9998
2 02866   1.0910 134.6570 0051848 161.5494 322.2267  1.09425761123248
0 DODGE 1
1 02867U 67066F   24187.52389243 -.00000088  00000-0  00000-0 0  9993
2 02867   0.9990 140.7483 0052057 137.4482 312.0918  1.09167936125618
0 TITAN 3C TRANSTAGE R/B
1 02868U 67066G   24187.51438481 -.00000050  00000-0  00000-0 0  9991
2 02868   0.8750 145.3414 0081587 115.2517  22.2365  1.08907144120589
0 SURCAL 159
1 02872U 67053F   24187.48367593  .00000156  00000-0  14410-3 0  9992
2 02872  69.9747  92.9935 0008323 310.5184  49.5198 13.99229011910630
0 OPS 5712 (P/L 152)
1 02873U 67053G   24187.61980106  .00000134  00000-0  13155-3 0  9990
2 02873  69.9740 139.1958 0008174 342.0748 192.9617 13.98203705909035
0 OPS 5712 (P/L 153)
1 02874U 67053H   24187.42521566  .00000051  00000-0  75404-4 0  9995
2 02874  69.9718 200.6805 0006045  20.2697 339.8647 13.96599441907394
0 AURORA 1
1 02876U 67065B   24187.32172448 -.00000026  00000-0 -17428-1 0  9993
2 02876  90.0307 313.3412 0072576  60.8364 299.9711  8.36561019330075
0 THOR BURNER 2 R/B
1 02877U 67065C   24187.30152838 -.00000029  00000-0 -18979-1 0  9998
2 02877  90.0317 313.6404 0068829  52.6147 308.0931  8.36608692741447
0 ATLAS CENTAUR 2 DEB
1 02886U 63047K   24186.73842212  .00000446  00000-0  26163-3 0  9999
2 02886  29.8713  74.0131 0644466  95.0899 272.3499 13.29646132781315
0 DELTA 1 DEB
1 02888U 65089D   24186.93923931 -.00000060  00000-0  99366-4 0  9998
2 02888  59.1993 132.6253 0721423 136.4220 346.9291 11.87402923489904
0 SCOUT A DEB
1 02889U 66005E   24187.45293229  .00000128  00000-0  28773-3 0  9993
2 02889  89.5449 188.6086 0165718 303.4850 218.3802 13.17819607742646
0 SURCAL 150B
1 02909U 67053J   24187.54664663  .00018014  00000-0  22655-2 0  9999
2 02909  69.9397 265.0728 0000687 346.1522  13.9609 14.82099219973753
0 OPS 7202 (DMSP 4A F3)
1 02920U 67080A   24187.59557782  .00000111  00000-0  79091-4 0  9997
2 02920  98.6763  49.6065 0037142 234.9910 124.7776 14.15035337932054
0 SL-8 DEB
1 02934U 65020EM  24187.62564519  .00000381  00000-0  24381-2 0  9993
2 02934  55.5972 317.4644 0362359 306.2687  63.0888 12.50732582613066
0 THOR BURNER 2 R/B
1 02940U 67080B   24187.56033859  .00000187  00000-0  11320-3 0  9993
2 02940  98.5679  30.5747 0038695  97.1105 263.4472 14.16856080934194
0 WESTFORD NEEDLES
1 02949U 63014AS  24187.61623156  .00001363  00000-0  64761-1 0  9998
2 02949  85.6257 130.4223 2010240 199.0550 344.0315  8.81676646332923
0 OPS 4947 (TRANSIT 17)
1 02965U 67092A   24187.58453450  .00000162  00000-0  22333-3 0  9997
2 02965  89.2303  64.9416 0046788 323.2177  98.6498 13.53245495799940
0 SCOUT A R/B
1  2967U 67092B   24187.57158235  .00000151  00000-0  21111-3 0  9992
2  2967  89.2309  63.6293 0047110   6.7615  58.3635 13.52228760799443
0 INTELSAT 2-F4
1 02969U 67094A   24187.33285970 -.00000161  00000-0  00000-0 0  9990
2 02969   2.2557  80.7404 0011319 112.3419 118.7724  1.00166583108175
0 DELTA 1 R/B(2) *
1 02971U 67094C   24187.50475491  .00002731  00000-0  14920-2 0  9993
2 02971  28.1552 208.5368 6582612 200.8468 109.6324  3.15978223537071
0 DELTA 1 DEB
1  2976U 67036C   24184.21667623 -.00000028  00000-0  95292-4 0  9990
2  2976 102.1055 275.3591 0098826 108.0307 309.9716 12.82061444676538
0 DELTA 1 DEB
1 02977U 67036D   24187.38505243 -.00000027  00000-0  99444-4 0  9993
2 02977 101.5032 154.2439 0059322 219.9481 295.4671 12.56829524623966
0 OPS 1264 (DMSP 4A F4)
1 02980U 67096A   24187.51965591  .00001069  00000-0  21493-3 0  9998
2 02980  99.2252 170.2543 0096928 113.9295 247.2091 14.61216867983115
0 THOR BURNER 2 R/B
1 02985U 67096B   24187.56529233  .00001635  00000-0  28820-3 0  9997
2 02985  99.1226 127.3835 0087509  94.0838 267.0371 14.66707040988753
0 SCOUT X-4 DEB
1 02986U 64026E   24187.42469318  .00000287  00000-0  16815-3 0  9993
2 02986  90.4855 154.5722 0045692 330.3356  29.5236 14.05971545 74439
0 SCOUT A DEB
1 02989U 66005F   24187.31427396  .00000606  00000-0  38998-3 0  9994
2 02989  89.6835 310.1658 0109439 332.7050  26.8402 13.99263816897395
0 SCOUT A DEB
1 02994U 67092C   24187.59628919  .00000579  00000-0  40030-3 0  9990
2 02994  89.4274  28.9591 0087661 273.3296  85.7855 13.96232049875438
0 WESTFORD NEEDLES
1 02997U 63014AU  24186.19565377  .00000330  00000-0  87353-1 0  9998
2 02997  86.7972 250.9480 0923467 327.3941  27.2991  8.77798112253905
0 ATS 3
1 03029U 67111A   24187.53168815 -.00000093  00000-0  00000-0 0  9992
2 03029   1.3401  86.0705 0018338  16.1340 268.1362  1.00271854207497
0 ESSA 6 (TOS-D)
1 03035U 67114A   24187.46649390 -.00000040  00000-0  43180-4 0  9998
2 03035 102.0253 272.0262 0048881  42.3303 329.5023 12.54234724593387
0 DELTA 1 R/B
1 03036U 67114B   24187.50022811 -.00000037  00000-0  56063-4 0  9997
2 03036 102.0358 268.1902 0048232  57.0018 314.6835 12.54121338593132
0 SL-8 DEB
1 03038U 65020EN  24187.27486917  .00004865  00000-0  12695-2 0  9991
2 03038  56.1763  19.7829 0455939 323.0486  33.9871 14.03176551125058
0 SL-8 DEB *
1 03045U 65070G   24186.95836156  .00000107  00000-0  12266-2 0  9991
2 03045  55.4327  17.3060 0291385 202.5690 323.9494 12.44419689600265
0 COSMOS 192
1 03047U 67116A   24187.55751046  .00000537  00000-0  12694-3 0  9990
2 03047  74.0131 289.4508 0009324 272.3416  87.6680 14.56592761994969
0 SL-8 R/B
1 03048U 67116B   24187.62231683  .00000968  00000-0  20006-3 0  9993
2 03048  74.0061 135.5877 0004637  67.9243 105.0324 14.61749832  1991
0 DELTA 1 DEB
1  3051U 67114C   24185.56834213 -.00000010  00000-0  17295-3 0  9999
2  3051 101.0820 181.1753 0090128 115.1544  10.7132 12.62251083609650
0 COSMOS 198
1 03081U 67127A   24187.58857020 -.00000055  00000-0  26680-4 0  9999
2 03081  65.1441 343.5924 0035995 315.2066  44.6095 13.93307121874433
0 EXPLORER 36 (GEOS 2)
1 03093U 68002A   24187.59409833 -.00000080  00000-0 -15573-4 0  9999
2 03093 105.7919 142.8995 0318865 180.9542 287.0368 12.83573070646058
0 DELTA 1 R/B
1 03094U 68002B   24187.60974937 -.00000026  00000-0  16189-3 0  9996
2 03094 105.8117 215.8314 0313201 124.2190   0.4747 12.85212358648539
0 ATLAS AGENA B DEB
1 03121U 63030F   24187.32726017  .00000024  00000-0  10680-1 0  9991
2 03121  88.3930 248.1071 0033333  59.0475 301.3645  8.57967812145711
0 SCOUT A DEB
1 03122U 67092D   24187.38173701  .00000280  00000-0  55883-3 0  9996
2 03122  89.0929 152.0131 0188218  36.8365 116.4421 13.25530584488701
0 DELTA 1 DEB
1 03123U 67114D   24187.25465941 -.00000039  00000-0  57983-4 0  9995
2 03123 102.4120 285.4368 0028642 137.9313 246.1559 12.48069809579949
0 THOR ABLESTAR DEB
1 03124U 61015HX  24187.16038442  .00000999  00000-0  11032-2 0  9999
2 03124  66.9848 112.3422 0340280 216.2383 141.5195 13.53299334 72603
0 THOR ABLESTAR DEB
1 03125U 61015HY  24187.39075543  .00000778  00000-0  14497-2 0  9991
2 03125  67.5581 326.2300 0312539 228.1704 161.0992 13.26585366 53076
0 DELTA 1 DEB
1 03126U 68002C   24185.60005498 -.00000022  00000-0  18969-3 0  9991
2 03126 106.0768 183.1574 0322197 213.8168 269.9761 12.82409919642809
0 DELTA 1 DEB
1 03127U 68002D   24187.40843506 -.00000007  00000-0  21331-3 0  9992
2 03127 105.3190  66.0201 0321104  62.0182 111.3120 12.84831522647540
0 COSMOS 203
1 03129U 68011A   24187.44417918  .00000119  00000-0  35276-3 0  9998
2 03129  74.0524  83.0094 0011686  62.4754 110.7322 13.18270091712180
0 SL-8 R/B
1 03131U 68011B   24187.48530838 -.00000225  00000-0 -52853-3 0  9992
2 03131  74.0514 101.3548 0013716  89.7194 270.5466 13.17988417711580
0 OPS 7034 (TRANSIT 18)
1 03133U 68012A   24187.47806179  .00000148  00000-0  21120-3 0  9993
2 03133  90.0226 272.4800 0072377 251.4228 119.7424 13.51367546498240
0 SCOUT A R/B
1 03137U 68012B   24187.53465149  .00000107  00000-0  15128-3 0  9998
2 03137  90.0234 271.7822 0073674 329.5909  30.0978 13.50140522772755
0 COSMOS 209
1 03158U 68023A   24187.56918419 -.00000026  00000-0  44480-4 0  9994
2 03158  65.3313 257.4573 0037997 193.2378 166.7699 13.97840441871541
0 THOR ABLESTAR DEB
1 03164U 61015HZ  24187.03433685  .00001073  00000-0  74468-3 0  9994
2 03164  66.7485  69.5722 0051530 197.3913 162.5408 14.02097726987873
0 TRANSIT 5B-1 DEB
1 03166U 63038H   24187.44793944  .00000096  00000-0  14729-3 0  9993
2 03166  89.9910 334.5742 0039597 253.4479 167.5675 13.44807753495927
0 OV1-13
1 03173U 68026A   24187.52948268  .00000100  00000-0  16161-3 0  9991
2 03173  99.9318 164.3915 3838190 139.8637 256.0492  7.25546337486573
0 OV1-14
1 03174U 68026B   24187.38001243  .00000009  00000-0  16154-4 0  9990
2 03174 100.0139 143.1366 3982005 110.1041   4.9982  6.96497772426742
0 OV1-14 R/B
1 03177U 68026C   24187.44700823  .00000336  00000-0  61075-3 0  9994
2 03177  99.9727 153.3046 3989507  91.0779   9.9700  6.97608776427542
0 OV1-13 R/B
1 03212U 68026D   24187.53738125  .00000263  00000-0  49671-3 0  9997
2 03212  99.9042 181.6512 3800884  66.5688 328.6233  7.28202545268522
0 SCOUT A DEB
1 03213U 68012C   24186.97175175  .00000566  00000-0  45959-3 0  9991
2 03213  90.2387  96.4932 0052849  28.4110  89.1226 13.88376705511583
0 SCOUT A DEB
1 03214U 68012D   24187.26001086  .00000236  00000-0  44323-3 0  9992
2 03214  89.8542 115.1525 0188983  82.7519  68.8217 13.28959642489964
0 COSMOS 220
1 03229U 68040A   24187.58464174  .00001290  00000-0  18010-3 0  9990
2 03229  74.0254 143.3919 0037205 232.4535 127.3258 14.78378826985117
0 SL-8 R/B
1 03230U 68040B   24187.37295555  .00004054  00000-0  35849-3 0  9994
2 03230  74.0348 119.0318 0025440 107.0342 253.3634 14.96423849998182
0 WESTFORD NEEDLES
1 03255U 63014BV  24186.55837935  .00000076  00000-0  33568-1 0  9994
2 03255  87.3279 236.7766 0075121  15.8033 344.5145  8.66729314319674
0 OPS 7869 (DMSP 4B F1)
1 03266U 68042A   24187.51169855  .00000123  00000-0  83292-4 0  9993
2 03266  98.6007  34.1292 0052547 185.5407 174.5192 14.15592934812433
0 WESTFORD NEEDLES *
1 03267U 63014CF  24187.32794608  .00000282  00000-0  18756-3 0  9995
2 03267  88.4095 162.2128 1691526 137.7457 236.7193 11.33337841461668
0 THOR BURNER 2 R/B
1 03271U 68042B   24187.53431752  .00000211  00000-0  12373-3 0  9998
2 03271  98.5526  17.0512 0053000  81.3760 279.3415 14.17181536896000
0 OPS 9341 (IDSCS 19)
1 03284U 68050A   24186.86946458 -.00000120  00000-0  00000-0 0  9991
2 03284   5.7520  57.6872 0013663 122.8616 156.3972  1.07854855 42527
0 OPS 9342 (IDSCS 20)
1 03285U 68050B   24186.86755698 -.00000099  00000-0  00000-0 0  9991
2 03285   5.7764  57.7720 0015509 123.7424  88.3422  1.07819290220480
0 OPS 9343 (IDSCS 21)
1 03286U 68050C   24187.44870156 -.00000079  00000-0  00000-0 0  9992
2 03286   5.7566  57.9514 0018906 122.3629 100.6449  1.07757918 39786
0 OPS 9344 (IDSCS 22)
1 03287U 68050D   24187.43765222 -.00000068  00000-0  00000-0 0  9997
2 03287   5.7148  58.2999 0025586 120.9895  86.6447  1.07639863219605
0 OPS 9345 (IDSCS 23)
1 03288U 68050E   24187.53840794 -.00000080  00000-0  00000-0 0  9991
2 03288   5.6225  58.7865 0034924 118.4578  71.5780  1.07478186131597
0 OPS 9346 (IDSCS 24)
1 03289U 68050F   24186.80236270 -.00000128  00000-0  00000-0 0  9992
2 03289   5.5888  59.3442 0045527 116.4666 130.6411  1.07288340 43004
0 OPS 9347 (IDSCS 25)
1 03290U 68050G   24187.40895543 -.00000127  00000-0  00000-0 0  9994
2 03290   5.4649  60.0777 0060284 113.9158 142.0031  1.07036025 39512
0 OPS 9348 (IDSCS 26)
1 03291U 68050H   24185.34253729 -.00000104  00000-0  00000-0 0  9995
2 03291   5.3951  60.8710 0075039 111.2795  93.0481  1.06767562218402
0 TITAN 3C TRANSTAGE R/B
1 03292U 68050J   24187.44370594 -.00000111  00000-0  00000-0 0  9997
2 03292   6.1172  58.9109 0172858 349.0377 227.5849  1.05593964 38988
0 EXPLORER 38 (RAE-A)
1 03307U 68055A   24187.33037042 -.00000010  00000-0  00000-0 0  9993
2 03307 120.8175 149.6401 0013382 199.9438 160.0641  6.42518119313691
0 DELTA 1 R/B
1 03315U 68055B   24187.54735436  .00000020  00000-0  14340-3 0  9992
2 03315 120.6546 300.6519 2641092 313.6173  35.8566  9.25545852875671
0 OPS 2222
1 03334U 68063A   24187.11257956 -.00000297  00000-0  00000-0 0  9993
2 03334   7.7512 290.7553 0937039 210.7189 157.8687  0.99255212 19060
0 EXPLORER 40 (INJUN-5)
1 03338U 68066B   24187.49974997  .00000127  00000-0  13510-3 0  9996
2 03338  80.6628 271.0519 1130048 317.8142  34.1088 12.23246186491280
0 SCOUT B R/B
1 03341U 68066C   24187.56988067  .00000272  00000-0  28843-3 0  9997
2 03341  80.6612 238.4580 1116920 228.6942 121.2642 12.25642622476310
0 ESSA 7 (TOS-E)
1 03345U 68069A   24187.56662361 -.00000046  00000-0 -17691-4 0  9991
2 03345 101.4509 165.0679 0027159 114.2275 355.6858 12.52994917555854
0 DELTA 1 R/B
1 03346U 68069B   24187.51815836 -.00000041  00000-0  14767-4 0  9999
2 03346 101.4275 163.4563 0023567 309.7280 162.9719 12.54325535558400
0 TITAN 3C TRANSTAGE DEB
1 03373U 65082ML  24187.47194623  .00003463  00000-0  88729-3 0  9998
2 03373  30.9874 345.0865 0178663 342.2643  17.1799 14.39654606947564
0 TITAN 3C TRANSTAGE DEB
1 03386U 65082MY  24187.40663645  .00003946  00000-0  39547-3 0  9990
2 03386  32.3732 280.0606 0007556   8.0200 352.0577 14.90122738139220
0 SCOUT B DEB
1 03392U 68066H   24187.13349326  .00009867  00000-0  38495-2 0  9997
2 03392  80.6652 238.4136 0409492  11.8826 349.1642 13.92256013633246
0 DELTA 1 DEB
1 03416U 68069C   24187.29870494 -.00000042  00000-0  17175-4 0  9990
2 03416 101.6358 304.0078 0119316 123.1527 265.8865 12.67117710584105
0 DELTA 1 DEB
1 03417U 68069D   24182.30259808 -.00000036  00000-0  74157-4 0  9994
2 03417 102.1039 118.2108 0065466 301.0242 214.2519 12.39752660833990
0 OV2-5
1 03428U 68081A   24187.28243873 -.00000247  00000-0  00000-0 0  9993
2 03428   1.0574 358.4790 0079889 322.8633 340.4081  1.01560664113824
0 LES 6
1 03431U 68081D   24187.31438153 -.00000286  00000-0  00000-0 0  9991
2 03431   1.2483 330.6512 0006860  11.6303 353.0346  1.00299144113644
0 TITAN 3C TRANSTAGE R/B
1 03432U 68081E   24187.11438170 -.00000091  00000-0  00000-0 0  9993
2 03432   1.0415 356.3855 0094790 318.2696 330.3429  1.01516672114755
0 TITAN 3C TRANSTAGE DEB
1 03454U 65082PP  24187.40283251  .00006313  00000-0  54490-3 0  9992
2 03454  32.2620 209.2969 0018589 294.4612  65.4106 14.96000121138579
0 TITAN 3C TRANSTAGE DEB
1 03462U 65082PT  24187.39860439  .00007466  00000-0  40306-3 0  9999
2 03462  32.0230 272.1398 0016478 218.5926 141.3554 15.13409393154931
0 TITAN 3C TRANSTAGE DEB
1 03488U 65082QJ  24186.91598015  .00002521  00000-0  36560-3 0  9996
2 03488  32.2306  37.3670 0025320  19.6706 340.4917 14.74402103 92520
0 TITAN 3C TRANSTAGE DEB
1 03494U 65082QQ  24186.81019485  .00001133  00000-0  22130-3 0  9997
2 03494  31.8930  28.6802 0027346 137.2556 223.0216 14.60227832101163
0 COSMOS 249
1 03504U 68091A   24187.49365028  .00000299  00000-0  13341-3 0  9990
2 03504  62.3537 244.4437 0984924 234.0179 116.5566 12.96571972628184
0 COSMOS 249 DEB
1 03506U 68091C   24187.43877878  .00000318  00000-0  16378-3 0  9992
2 03506  62.3527 211.3121 0985692 121.8466 248.2324 12.90320972614606
0 COSMOS 249 DEB
1 03509U 68091F   24187.60679458  .00019322  00000-0  10864-2 0  9996
2 03509  62.3523 331.7264 0233980   0.6265 359.5071 14.93020311800103
0 OPS 4078 (DMSP 4B F2)
1 03510U 68092A   24187.36261434  .00000216  00000-0  10447-3 0  9993
2 03510  98.4874 315.3660 0028848 255.6245 104.1734 14.27722459895650
0 THOR BURNER 2 R/B
1 03522U 68092B   24187.61419394  .00000365  00000-0  15712-3 0  9999
2 03522  98.7163 322.6006 0030270  90.6257 269.8394 14.30282407898522
0 COSMOS 252
1 03530U 68097A   24187.50149888 -.00000045  00000-0  26114-4 0  9994
2 03530  62.3347  99.4052 0971775 268.1578  80.8035 12.87907671614272
0 COSMOS 252 DEB
1 03549U 68097B   24187.56470648  .00027543  00000-0  33542-2 0  9993
2 03549  62.3028 339.9240 0374740 140.3346 222.5784 14.44163856766281
0 COSMOS 252 DEB
1 03551U 68097D   24187.60094126  .00001297  00000-0  36822-3 0  9997
2 03551  62.2926 323.4682 0622089 336.6536  20.7320 13.73386688710476
0 COSMOS 252 DEB
1 03554U 68097G   24187.57499787  .00009118  00000-0  19437-2 0  9990
2 03554  62.2662 316.5462 0609514 119.8504 246.4543 13.82823388726754
0 COSMOS 252 DEB
1 03555U 68097H   24187.59711041  .00000157  00000-0  96428-4 0  9994
2 03555  62.3174 278.4845 0912694  24.8003 339.4141 13.07307321643723
0 COSMOS 252 DEB
1 03557U 68097K   24187.58053260  .00001917  00000-0  59827-3 0  9993
2 03557  62.3046 313.3106 0868265  93.6233 276.4366 13.22158941660014
0 COSMOS 252 DEB
1 03559U 68097M   24187.56501340  .00008931  00000-0  15827-2 0  9994
2 03559  62.2893 324.9745 0538717  76.5920 289.4570 14.02471120743548
0 COSMOS 252 DEB
1 03561U 68097P   24187.42860661  .00015014  00000-0  22227-2 0  9998
2 03561  62.2699  76.2966 0471803 118.2014 246.7522 14.20624521739269
0 COSMOS 252 DEB
1  3565U 68097R   24187.56385032  .00011938  00000-0  19650-2 0  9998
2  3565  62.2892 359.5674 0505207  64.6234 300.6230 14.10994457741878
0 COSMOS 252 DEB
1 03569U 68097V   24187.57473368  .00002151  00000-0  54600-3 0  9995
2 03569  62.3036 287.5939 0565573 322.1593  34.0913 13.86367722719758
0 COSMOS 256
1 03576U 68106A   24187.46082325 -.00000279  00000-0 -67422-3 0  9998
2 03576  74.0493  78.0103 0034140 224.6726 308.8253 13.16850268672004
0 SL-8 R/B
1 03577U 68106B   24187.59696516 -.00000037  00000-0 -44954-4 0  9994
2 03577  74.0517 338.2461 0034350 107.2662 327.6303 13.19067461675565
0 COSMOS 249 DEB
1 03583U 68091R   24186.74458606  .00000523  00000-0  89611-3 0  9992
2 03583  62.0878  99.3608 0687075 330.5412  25.8437 12.84471270592649
0 COSMOS 249 DEB
1 03584U 68091S   24187.06689962  .00024416  00000-0  32876-2 0  9997
2 03584  62.3011  91.3938 0400968  30.2217 332.1324 14.36188219759439
0 SCOUT A DEB
1 03591U 66041E   24187.59290972  .00000443  00000-0  27058-3 0  9996
2 03591  90.2179  65.5480 0071031 214.1135 145.5471 14.03485635967542
0 THOR ABLESTAR DEB
1 03592U 65048F   24187.29471910  .00000328  00000-0  40813-3 0  9999
2 03592  89.8944 296.3813 0059590 262.4104 151.3209 13.62111051923031
0 OAO 2
1 03597U 68110A   24187.19171171  .00000437  00000-0  12480-3 0  9992
2 03597  34.9937  83.3932 0006039 321.1268  38.8988 14.46586714930361
0 ATLAS CENTAUR R/B
1 03598U 68110B   24187.40850904  .00000787  00000-0  17798-3 0  9990
2 03598  34.9912 186.6844 0048705 249.3895 110.1570 14.55983666920768
0 OPS 7684
1 03605U 68112B   24187.43694169  .00000068  00000-0  35074-3 0  9992
2 03605  80.3628 342.0752 0057278 195.4681 228.8589 12.60635060554318
0 COSMOS 249 DEB
1 03606U 68091Y   24187.16481484  .00002154  00000-0  16305-2 0  9996
2 03606  62.2470  97.3658 0778824 123.1405 244.6795 13.02950734591745
0 COSMOS 249 DEB
1 03609U 68091AB  24187.38916853  .00000852  00000-0  21216-3 0  9997
2 03609  62.2852 334.7152 0728388 324.8596  30.6369 13.60235886607825
0 ESSA 8 (TOS-F)
1 03615U 68114A   24187.58596400 -.00000036  00000-0  50094-4 0  9996
2 03615 101.5990 135.4333 0031440 267.9560  91.7914 12.56232158547205
0 DELTA 1 R/B
1 03616U 68114B   24187.46851150 -.00000035  00000-0  54044-4 0  9998
2 03616 101.5829 139.4131 0013251 320.7404 153.2729 12.51382908539575
0 OPS 7684 DEB
1 03617U 68112C   24187.31117587  .00000038  00000-0  17514-3 0  9992
2 03617  80.1875 290.2291 0046102 232.8366 153.5844 12.63467159561114
0 OPS 7684 DEB
1 03618U 68112D   24183.68234126  .00000055  00000-0  29409-3 0  9993
2 03618  80.5323  54.4544 0084494 272.8107 144.1654 12.55842493545241
0 INTELSAT 3-F2
1 03623U 68116A   24187.50382106 -.00000099  00000-0  00000-0 0  9992
2 03623   5.8627 297.6099 0090292  77.9138 300.2528  0.90194358 76364
0 ISIS 1
1 03669U 69009A   24187.39676765  .00000142  00000-0  10359-3 0  9997
2 03669  88.4365 222.1839 1708219 244.9689  96.4770 11.29929325279360
0 DELTA 1 R/B
1 03670U 69009B   24187.40043998  .00000874  00000-0  60289-3 0  9996
2 03670  88.4480 186.0081 1634766 322.6109  27.1377 11.45515655297654
0 OPS 2644
1 03673U 69010B   24187.58044584  .00000098  00000-0  50204-3 0  9996
2 03673  80.3940  38.1377 0023716 167.1910 257.7849 12.63555736553589
0 INTELSAT 3-F3
1 03674U 69011A   24187.04835030 -.00000188  00000-0  00000-0 0  9990
2 03674  11.3400 306.8993 0177847 349.1429  20.0546  0.84931308 60655
0 COSMOS 249 DEB *
1 03679U 68091AE  24187.48572720  .00008529  00000-0  17423-2 0  9999
2 03679  62.7443 222.1927 0594115 137.7922 227.0481 13.87232572685085
0 COSMOS 252 DEB *
1 03686U 68097AD  24187.19029688  .00006051  00000-0  57682-2 0  9990
2 03686  62.2609 121.5581 0656505  14.2049 347.6464 13.12010764603097
0 COSMOS 252 DEB *
1 03690U 68097AH  24187.60177672  .00001544  00000-0  14202-2 0  9991
2 03690  62.3404 326.4786 0811194 113.5708 255.2576 12.89141211580368
0 OPS 0757 (TACSAT)
1 03691U 69013A   24187.18250657 -.00000204  00000-0  00000-0 0  9991
2 03691   1.0477  73.7015 0017700 159.0722  86.2393  1.00408720106958
0 TITAN 3C TRANSTAGE R/B
1 03692U 69013B   24187.11438170 -.00000258  00000-0  00000-0 0  9992
2 03692   0.6092 285.9854 0172895 178.5392 192.8099  0.97536734 35388
0 COSMOS 249 DEB
1 03695U 68091AL  24187.46742604  .00001862  00000-0  19519-2 0  9996
2 03695  62.2318 239.3008 0696765  76.1406 291.6064 13.02323801579276
0 COSMOS 252 DEB *
1 03713U 68097AQ  24187.58711613  .00001559  00000-0  16451-2 0  9997
2 03713  62.2166 199.7719 0656794 197.6682 160.0465 13.09050240595889
0 THOR ABLESTAR DEB
1 03740U 61015JB  24187.45687131  .00000901  00000-0  53038-3 0  9996
2 03740  66.3344  82.8449 0078897 115.2023 245.7269 14.11171486221554
0 ATLAS CENTAUR 2 DEB
1 03741U 63047L   24187.28423768  .00006351  00000-0  15089-2 0  9997
2 03741  29.8788 220.1264 0287702 186.0977 173.6070 14.30214534810101
0 SL-8 DEB *
1 03743U 65020ES  24187.31816988  .00000083  00000-0  14475-2 0  9990
2 03743  56.6617 253.9228 0262592 307.6687 122.7581 12.20599253487232
0 THOR ABLESTAR DEB
1 03744U 61015JC  24187.06592087  .00002577  00000-0  17986-2 0  9994
2 03744  66.9779  63.4545 0148537 274.9326  83.4813 13.94910500780927
0 SL-8 DEB *
1 03745U 65020ET  24187.38754784  .00000007  00000-0  64142-3 0  9997
2 03745  56.0153 162.7240 0166181  69.0375  94.9419 12.50839222551917
0 THOR ABLESTAR DEB
1 03748U 61015JD  24187.59088346  .00000603  00000-0  16287-2 0  9995
2 03748  67.7442  92.1211 0522870  83.1767 350.2154 12.79448386602769
0 SL-8 DEB
1 03749U 65020EU  24187.22258922  .00002573  00000-0  99009-3 0  9997
2 03749  56.1153 110.7358 0469628 291.7505  63.4116 13.85905059701627
0 SCOUT X-4 DEB
1 03750U 63053J   24187.27164011  .00027247  00000-0  57027-2 0  9991
2 03750  78.5752 294.3513 0317251 201.1143 157.6695 14.32609348704469
0 THOR ABLESTAR DEB
1 03752U 61015JE  24187.23801883  .00000480  00000-0  76076-3 0  9996
2 03752  67.6259 241.9902 0197525  90.6575 351.3151 13.49613238709120
0 COSMOS 249 DEB *
1 03753U 68091AR  24186.89757557  .00014179  00000-0  10796-2 0  9993
2 03753  62.4242  33.1350 0160652 306.9061  51.7398 14.92609461829385
0 COSMOS 249 DEB
1 03755U 68091AT  24187.02990881  .00000312  00000-0  51501-3 0  9994
2 03755  62.2544  61.2393 0757101 324.8264  30.4890 12.79247146552244
0 COSMOS 249 DEB
1 03757U 68091AU  24187.60019450  .00014435  00000-0  22752-2 0  9990
2 03757  61.9852 309.9154 0412049 211.9113 145.6378 14.28837207731382
0 COSMOS 249 DEB *
1 03758U 68091AV  24186.97909548  .00000329  00000-0  53541-3 0  9994
2 03758  62.2737  42.3792 0752637 314.4689  39.7045 12.80164615522612
0 ESSA 9 (TOS-G)
1 03764U 69016A   24187.58259894 -.00000022  00000-0  13581-3 0  9990
2 03764 101.4169 208.7025 0051474  56.3304  64.6445 12.49849037898922
0 DELTA 1 R/B
1 03767U 69016B   24187.62214442  .00000002  00000-0  29096-3 0  9993
2 03767 101.4296 221.0178 0049023 283.7473 192.6258 12.51489052527814
0 COSMOS 252 DEB
1 03784U 68097AW  24187.11624358  .00000927  00000-0  73346-3 0  9998
2 03784  62.2528  94.3205 0616933 254.9242  98.2745 13.31300230975022
0 COSMOS 252 DEB
1 03785U 68097AX  24187.06615628  .00000899  00000-0  13351-2 0  9990
2 03785  62.2638 201.7849 0758793 279.3985  72.2064 12.76984861465317
0 COSMOS 252 DEB
1 03788U 68097BA  24187.29401488 -.00000068  00000-0 -38940-4 0  9998
2 03788  61.8768 122.7439 0569362 207.8987 323.3729 11.88370916415816
0 COSMOS 249 DEB *
1  3790U 68091AX  24187.55400048  .00000954  00000-0  45034-3 0  9998
2  3790  62.9997   2.6669 0710939 249.6553 102.6743 13.37751389671740
0 COSMOS 249 DEB
1 03793U 68091BA  24187.58581506  .00006832  00000-0  62145-2 0  9995
2 03793  62.2184 282.4310 0646008 162.9622 199.4225 13.15907931607485
0 COSMOS 249 DEB
1 03794U 68091BB  24187.59780281  .00006923  00000-0  55099-2 0  9999
2 03794  62.2654 356.7548 0638772  87.6035 279.7906 13.23418489615566
0 THOR ABLESTAR DEB
1 03810U 65065P   24187.11872517  .00000595  00000-0  89546-3 0  9992
2 03810  89.9528 217.6348 0057774 186.7861 243.7829 13.51084472162686
0 DELTA 1 DEB
1 03811U 68114C   24186.68513727 -.00000021  00000-0  12155-3 0  9994
2 03811 101.8969  84.2111 0137906 148.1877 279.7912 12.76342859587327
0 DELTA 1 DEB
1 03812U 68114D   24187.54791509 -.00000029  00000-0  13641-3 0  9996
2 03812 102.4488 185.7766 0071215  24.6742  97.7389 12.37759977509570
0 COSMOS 252 DEB
1 03814U 68097BC  24186.47873932  .00001152  00000-0  16892-2 0  9997
2 03814  62.2746 225.6813 0754605 236.4902 116.1786 12.77391412563321
0 COSMOS 272
1 03818U 69024A   24187.60085595 -.00000155  00000-0 -34790-3 0  9990
2 03818  73.9901 248.7448 0019586 220.7623 250.0492 13.17917754660109
0 SL-8 R/B
1 03819U 69024B   24187.41234069 -.00000068  00000-0 -12121-3 0  9999
2 03819  73.9868 168.8236 0009279 129.1791 343.5695 13.19545476662997
0 OV1-19
1 03825U 69025C   24187.45111861  .00001057  00000-0  50768-3 0  9991
2 03825 104.7644 101.6260 2687020  51.0552 330.0813  9.57187495917083
0 OV1-19 R/B
1 03827U 69025E   24187.26278456  .00001976  00000-0  99884-3 0  9998
2 03827 104.7692 291.8486 2620092 167.4057 200.7989  9.68253427931105
0 OPS 2644 DEB
1 03840U 69010C   24180.32774399  .00000056  00000-0  29212-3 0  9990
2 03840  80.6068 186.4990 0031159 282.9033 139.3817 12.58603583542855
0 OPS 2644 DEB
1 03841U 69010D   24186.52945138  .00000040  00000-0  17497-3 0  9995
2 03841  80.1766 271.6416 0034157 149.5737 226.3891 12.66811171560487
0 THOR ABLESTAR DEB
1 03842U 61015JF  24187.32762607  .00000455  00000-0  54988-3 0  9996
2 03842  66.7380 271.0294 0136784 224.9795 134.0130 13.71362219137537
0 COSMOS 252 DEB
1 03843U 68097BG  24187.11277925  .00001003  00000-0  12340-2 0  9990
2 03843  62.2757  77.5910 0676354 314.7858  39.9978 12.99674153574564
0 COSMOS 249 DEB
1 03874U 68091BH  24187.49757847  .00002772  00000-0  25823-2 0  9999
2 03874  62.2535   4.9084 0652690  32.4514 331.4925 13.14597420606835
0 NIMBUS 3
1 03890U 69037A   24187.56211774  .00000001  00000-0  77837-4 0  9997
2 03890  99.7963  81.2874 0038645 262.1978 163.1389 13.42611560705288
0 SECOR 13 (EGRS 13)
1 03891U 69037B   24187.61535980 -.00000009  00000-0  60030-4 0  9998
2 03891  99.7513  75.3206 0039255 194.6363 223.7539 13.42928899706241
0 THORAD AGENA D R/B
1 03892U 69037C   24187.60579243  .00000030  00000-0  13235-3 0  9995
2 03892  99.9273  98.6705 0039202 356.3792  67.2200 13.42060787703981
0 COSMOS 252 DEB
1 03898U 68097BK  24187.31968099  .00001251  00000-0  16098-2 0  9990
2 03898  62.2785 306.7679 0731366 286.0762  66.0935 12.87504503581485
0 COSMOS 252 DEB
1 03900U 68097BM  24187.40995532  .00021744  00000-0  25081-2 0  9997
2 03900  62.2040 182.0147 0333291  41.0544 321.5098 14.53044860784710
0 COSMOS 252 DEB *
1 03901U 68097BN  24187.39267208  .00001273  00000-0  10385-2 0  9994
2 03901  61.2772 184.7503 0818903 314.9812  38.7515 12.93828799585347
0 COSMOS 249 DEB *
1 03908U 68091BL  24187.56438021  .00000367  00000-0  38508-3 0  9998
2 03908  63.3518 342.3216 0550140  25.4508  44.1808 13.34346818686442
0 COSMOS 249 DEB
1 03911U 68091BP  24187.34509302  .00008188  00000-0  26693-2 0  9999
2 03911  62.9306 159.9020 0786863  14.4226 347.7905 13.34214881571985
0 COSMOS 249 DEB
1 03912U 68091BQ  24187.32538007  .00000883  00000-0  14159-2 0  9990
2 03912  62.2583 167.3783 0763715 281.0103  70.5960 12.72348105554668
0 COSMOS 249 DEB
1 03923U 68091BR  24187.25790955  .00004819  00000-0  28242-2 0  9997
2 03923  62.2239 177.2568 0629418  36.7019 327.5431 13.39252447620996
0 SCOUT X-1 DEB
1 03927U 61004F   24187.29012476  .00033324  00000-0  61207-2 0  9998
2 03927  38.9467  39.2457 0345435  40.9996 321.6191 14.33110856 25137
0 SL-8 DEB *
1 03931U 65020EV  24187.53208032 -.00000018  00000-0  54341-3 0  9994
2 03931  56.0634 291.0487 0191365 231.2359 141.3089 12.35177516689235
0 THOR ABLESTAR DEB
1 03932U 61015JG  24187.54968328  .00000513  00000-0  10939-2 0  9990
2 03932  65.7988 247.3635 0275412  71.4680  36.1358 13.25213637 57471
0 COSMOS 252 DEB *
1 03938U 68097BS  24187.48389404  .00000727  00000-0  56145-3 0  9995
2 03938  63.0401 321.3374 1056297 267.3209 155.7367 12.54324935481578
0 INTELSAT 3-F4
1 03947U 69045A   24187.05969426 -.00000087  00000-0  00000-0 0  9996
2 03947   5.6975 291.0960 0022519  71.5052  39.1494  0.90044482 59558
0 TITAN 3C TRANSTAGE R/B
1 03956U 69046F   24186.04472105 -.00001298  00000-0  00000-0 0  9993
2 03956  15.6192  19.1948 8144026 269.7771 359.4704  0.46190002 17872
0 SL-8 DEB *
1 03965U 65020EY  24187.16878667  .00000362  00000-0  35859-2 0  9990
2 03965  56.2990  77.8563 0253795 122.0127  35.7820 12.27173980661949
0 DELTA 1 DEB
1 03974U 68069E   24185.88938731 -.00000043  00000-0  17878-4 0  9992
2 03974 101.8703 271.9960 0035870 119.3531 307.1292 12.53254926557892
0 DELTA 1 DEB
1 03975U 68069F   24185.94416778 -.00000051  00000-0 -41663-4 0  9991
2 03975 101.6354 250.0153 0043703 110.5792  65.5612 12.53524390558630
0 TITAN 3C TRANSTAGE DEB
1 03978U 65082SE  24187.33217455  .00001177  00000-0  19479-3 0  9999
2 03978  32.5632 189.7887 0035042  35.8309 324.4688 14.68046110342128
0 THOR ABLESTAR DEB
1 04005U 61015JK  24186.73992394  .00000467  00000-0  53012-3 0  9990
2 04005  66.7506 289.0403 0085772  43.5501 108.7125 13.77294222789630
0 COSMOS 249 DEB *
1 04008U 68091BY  24187.14794989  .00006520  00000-0  11920-2 0  9997
2 04008  62.8440  99.6400 0595053 115.7618 250.6067 13.91196627741241
0 THOR ABLESTAR DEB
1 04014U 61015JM  24187.08867792  .00002039  00000-0  60094-2 0  9996
2 04014  67.6269  63.6401 0808305  90.0970  23.3297 12.29303735826801
0 SCOUT X-1 DEB
1 04026U 61004G   24187.55900852  .00011236  00000-0  26152-2 0  9990
2 04026  38.8231 135.7116 0473310 133.9540 230.1264 14.03235512 32869
0 THOR ABLESTAR DEB
1 04028U 61015JQ  24187.57570343  .00001945  00000-0  41531-3 0  9999
2 04028  66.7528 132.5669 0100890 189.4835 170.4377 14.58025719269860
0 OPS 1127 (DMSP 4B F3)
1 04047U 69062A   24187.56775690  .00000183  00000-0  88135-4 0  9996
2 04047  98.5193  51.7560 0043962 189.3651 170.6716 14.29100353859674
0 THOR BURNER 2 R/B
1 04048U 69062B   24187.54171535  .00000304  00000-0  12852-3 0  9990
2 04048  98.3774  31.2393 0042131  19.4159 340.8618 14.31627338862753
0 ATS 5
1  4068U 69069A   24187.18442108 -.00000233  00000-0  00000+0 0  9996
2  4068   1.7844 267.7680 0003153 348.7330  73.1664  0.99496256127838
0 ATLAS CENTAUR R/B
1 04069U 69069B   24186.09674786  .00000245  00000-0  00000-0 0  9998
2 04069  17.1076  84.9259 6681096 304.9161   9.3962  2.04798468410596
0 COSMOS 292
1 04070U 69070A   24187.50575578  .00000420  00000-0  10509-3 0  9991
2 04070  74.0463 211.5790 0010530 342.8346  17.2459 14.54503231902604
0 SL-8 R/B
1 04071U 69070B   24187.55457879  .00000844  00000-0  16422-3 0  9990
2 04071  74.0472 226.4583 0015465 264.6349  95.3055 14.64689373914454
0 SL-8 DEB
1 04084U 69070C   24187.48775430  .00000192  00000-0  60696-4 0  9991
2 04084  74.0659 202.8221 0023096 276.6795  83.1735 14.46590685892833
0 SOICAL (CONE)
1 04132U 69082K   24187.40627322  .00001924  00000-0  79410-3 0  9993
2 04132  69.9959  82.7588 0007492  28.5244 331.6288 14.28238987819117
0 THORAD AGENA D DEB
1 04133U 69082CP  24187.00017961  .00012443  00000-0  13224-2 0  9990
2 04133  69.9104  41.2463 0032099 213.1921 146.7220 14.88771787883126
0 THORAD AGENA D DEB
1 04135U 69082DP  24187.57260122  .00000691  00000-0  32753-3 0  9994
2 04135  69.9823 322.6889 0046141 143.5618 216.8658 14.23121719830147
0 COSMOS 304
1 04138U 69091A   24187.55501152  .00000091  00000-0  32992-4 0  9996
2 04138  74.0392 119.7496 0013947 298.2166  61.7583 14.46244380884846
0 SL-8 R/B
1 04139U 69091B   24187.55510265  .00000967  00000-0  18744-3 0  9992
2 04139  74.0300 204.1857 0005886 342.6452  17.4514 14.64713874905442
0 THORAD AGENA D DEB
1 04141U 69082AJ  24187.42716982  .00006416  00000-0  98483-3 0  9998
2 04141  69.8774 164.2245 0041140 122.3871 238.1266 14.73460383878865
0 THORAD AGENA D DEB
1 04143U 69082M   24187.27984073  .00000637  00000-0  32984-3 0  9994
2 04143  70.1126  29.0637 0021965 338.7406  21.2798 14.19113068817102
0 THORAD AGENA D DEB
1 04144U 69082N   24187.46491238  .00004165  00000-0  95333-3 0  9999
2 04144  70.0807 100.7797 0036817  95.2822 265.2518 14.55895768862611
0 THORAD AGENA D DEB
1 04145U 69082P   24187.61085465  .00000437  00000-0  26717-3 0  9996
2 04145  70.0589 264.6283 0057400 138.4844 222.0652 14.11451186817304
0 THORAD AGENA D DEB
1 04149U 69082T   24187.04321516  .00000893  00000-0  45465-3 0  9994
2 04149  70.3056  59.9064 0036983 341.3705  18.6058 14.18471621817511
0 THORAD AGENA D DEB
1 04154U 69082W   24187.54841147  .00000005  00000-0  35911-4 0  9993
2 04154  70.0688 261.4691 0049715 317.1662  42.5580 14.05949691549477
0 THORAD AGENA D DEB
1 04155U 69082X   24187.51426563  .00001305  00000-0  47114-3 0  9993
2 04155  70.0471 240.8148 0056075 113.7723 246.9298 14.34835745837305
0 THORAD AGENA D DEB
1 04157U 69082Z   24187.60015160  .00012320  00000-0  14189-2 0  9996
2 04157  70.0158 139.6870 0026857  81.5457 278.8738 14.85610153887686
0 THORAD AGENA D DEB
1 04158U 69082AA  24187.58924209  .00000419  00000-0  25591-3 0  9993
2 04158  69.9995 261.8327 0043156  59.8968 300.6413 14.12134284814190
0 THORAD AGENA D R/B
1 04159U 69082AB  24187.57136512  .00000072  00000-0  12635-3 0  9995
2 04159  69.9614 253.8329 0113263 125.8023 235.3660 13.72689088740913
0 THORAD AGENA D DEB
1 04161U 69082AD  24187.56602245  .00000081  00000-0  90969-4 0  9995
2 04161  70.0202 299.6593 0059385 142.5100 218.0172 13.99198128795150
0 THORAD AGENA D DEB
1 04164U 69082AG  24187.52312589  .00003265  00000-0  13063-2 0  9998
2 04164  70.0820 310.2626 0038616  30.6246 329.7120 14.28799831809136
0 TEMPSAT 2
1 04168U 69082H   24187.38483592  .00000072  00000-0  91149-4 0  9995
2 04168  70.0126 178.4446 0021248 327.8694  32.1115 13.95790618788754
0 THORAD AGENA D DEB
1 04169U 69082AM  24187.59178690  .00003265  00000-0  70915-3 0  9993
2 04169  70.1873 275.1792 0035128 359.5551   0.5551 14.58552955865490
0 THORAD AGENA D DEB
1 04171U 69082AP  24187.55859416  .00001628  00000-0  59335-3 0  9998
2 04171  70.0775 354.5510 0034943  36.0868 324.2607 14.34487240836994
0 THORAD AGENA D DEB
1 04173U 69082AR  24187.46193393  .00006450  00000-0  11027-2 0  9998
2 04173  70.0740 293.0346 0029653  12.0948 348.0902 14.69007251868330
0 THORAD AGENA D DEB
1 04174U 69082AS  24187.52124034  .00001145  00000-0  43741-3 0  9997
2 04174  69.9912 120.6501 0047757 227.0238 132.6879 14.32568072839805
0 THORAD AGENA D DEB
1 04177U 69082AV  24187.59368009  .00001129  00000-0  89845-3 0  9996
2 04177  70.0738 284.7458 0110621 206.3339 153.2117 13.90776859757173
0 THORAD AGENA D DEB
1 04178U 69082AW  24187.48147124  .00002558  00000-0  77392-3 0  9999
2 04178  69.8465 248.2831 0069891 192.7788 167.1573 14.42060798836371
0 THORAD AGENA D DEB
1 04180U 69082AY  24187.50970274  .00000834  00000-0  31270-3 0  9995
2 04180  69.9795 121.5100 0073537 143.6966 216.9182 14.33529632845723
0 THORAD AGENA D DEB
1 04187U 69082BA  24187.50513038  .00021217  00000-0  26437-2 0  9999
2 04187  69.9627 111.3182 0018800  93.5272 266.8029 14.82315454882887
0 THORAD AGENA D DEB
1 04190U 69082BD  24187.54654888  .00026166  00000-0  17438-2 0  9995
2 04190  70.0170 238.3521 0014939  27.3485 332.8461 15.06918673884430
0 THORAD AGENA D DEB
1 04193U 69082BG  24187.35061820  .00023020  00000-0  42455-2 0  9998
2 04193  69.9212 277.5068 0070997 235.3392 124.1044 14.63823608788293
0 THORAD AGENA D DEB
1 04200U 69082BP  24187.50234589  .00068243  00000-0  29420-2 0  9991
2 04200  70.0694 331.0290 0017315 221.2400 138.7465 15.22063299886982
0 THORAD AGENA D DEB
1 04205U 69082BU  24187.56379839  .00000687  00000-0  29449-3 0  9990
2 04205  70.0608 283.9632 0063932  67.7634 293.0254 14.27764134999857
0 THORAD AGENA D DEB
1 04206U 69082BV  24187.08533867  .00584698  00000-0  52886-2 0  9990
2 04206  69.8949  69.3024 0029370 203.3165 156.6698 15.65658911882875
0 THORAD AGENA D DEB
1 04207U 69082BW  24187.42847419  .00003737  00000-0  76843-3 0  9990
2 04207  69.9613 196.1470 0027118 157.2675 202.9672 14.61134903862566
0 THORAD AGENA D DEB
1 04208U 69082BX  24187.22984705  .00001079  00000-0  49475-3 0  9997
2 04208  70.0859 109.2034 0015805 243.7604 116.1893 14.23881525908486
0 THORAD AGENA D DEB
1 04209U 69082BY  24187.61768575  .00000062  00000-0  71820-4 0  9997
2 04209  70.0336 311.6753 0040658 185.9408 174.1226 14.04795722804017
0 THORAD AGENA D DEB
1 04211U 69082CA  24187.30152644  .00000602  00000-0  36438-3 0  9995
2 04211  70.0727 153.5234 0034760 226.1831 133.6408 14.10805432812597
0 THORAD AGENA D DEB
1 04214U 69082CD  24187.55377681  .00001235  00000-0  37695-3 0  9994
2 04214  70.0517 279.6253 0060087 344.6781  15.2528 14.43173128857435
0 THORAD AGENA D DEB
1 04216U 69082CF  24187.40218504  .00000639  00000-0  30124-3 0  9995
2 04216  70.1050 186.9319 0046531  34.3638 326.0477 14.23620797 60007
0 THORAD AGENA D DEB
1 04217U 69082CG  24187.57024925  .00001629  00000-0  54505-3 0  9995
2 04217  70.0402 344.4238 0036907 293.8008  65.9252 14.38709687845304
0 THORAD AGENA D DEB
1 04218U 69082CH  24187.18340206  .00003484  00000-0  84009-3 0  9999
2 04218  70.1002 103.5087 0038394 250.3085 109.3908 14.53572685855061
0 AZUR (GRS A)
1 04221U 69097A   24187.54869502  .00033470  00000-0  10523-2 0  9991
2 04221 102.6881 229.7909 0444218  45.7243 317.9508 14.71600893618527
0 THORAD AGENA D DEB
1 04227U 69082CJ  24187.59123574  .00029416  00000-0  19933-2 0  9997
2 04227  69.8701 303.0530 0024133 118.9868 241.3718 15.06120862874653
0 THORAD AGENA D DEB
1 04231U 69082CN  24187.53915995  .00003028  00000-0  85582-3 0  9997
2 04231  70.2791 324.3311 0031886  43.7902 316.5752 14.46232471848593
0 OPS 7613 (P/L 4)
1 04237U 69082E   24187.41251487  .00000065  00000-0  85932-4 0  9997
2 04237  70.0131 184.1906 0021694 331.6180 137.6992 13.95772306786970
0 OPS 7613 (P/L 5)
1 04247U 69082F   24187.37502808  .00000068  00000-0  88448-4 0  9997
2 04247  70.0130 182.8532 0021707 330.5128  29.4752 13.95762616787072
0 THORAD AGENA D DEB
1 04249U 69082CY  24187.27838381  .00000975  00000-0  46299-3 0  9990
2 04249  70.0615 148.1856 0057680 143.0091 217.5027 14.21485089820733
0 SKYNET 1
1 04250U 69101A   24187.53097760 -.00000083  00000-0  00000-0 0  9999
2 04250   1.4070 276.2093 0022511 307.4518 145.4597  1.00268027127385
0 DELTA 1 R/B
1  4251U 69101B   24187.55890033  .00001360  00000-0  77988-3 0  9996
2  4251  27.7696 294.0202 5567578  82.3026 334.4537  4.62000328646150
0 COSMOS 312
1 04254U 69103A   24187.43885134 -.00000013  00000-0  15115-4 0  9994
2 04254  74.0215  83.8549 0022290 104.1889  69.5990 13.27173895645211
0 SL-8 R/B
1 04255U 69103B   24187.62249878 -.00000028  00000-0 -16310-4 0  9990
2 04255  74.0166 313.8608 0011360 352.1079  18.9420 13.29596991649769
0 OPS 7613 (P/L 1)
1 04256U 69082B   24187.34837424  .00000181  00000-0  16275-3 0  9993
2 04256  70.0102  53.8200 0021721 276.3773  83.4861 13.98797126790903
0 TIMATION 2
1 04257U 69082C   24187.42063453  .00000088  00000-0  10244-3 0  9992
2 04257  70.0134 172.8000 0021984 324.9509 145.8349 13.96141849787292
0 OPS 7613 (P/L 3)
1 04259U 69082D   24187.51381899  .00000054  00000-0  79120-4 0  9993
2 04259  70.0131 213.5152 0021159 348.2293 121.8409 13.94947259882424
0 THORAD AGENA D DEB
1  4276U 69082DK  24187.57405963  .00019021  00000-0  20076-2 0  9995
2  4276  70.0581 292.1882 0022481 196.2818 163.7618 14.89104598875760
0 THORAD AGENA D DEB
1  4277U 69082DL  24187.53828655  .00000111  00000-0  97970-4 0  9998
2  4277  70.0218 130.4931 0038511  95.3053 265.2455 14.07148115808887
0 OPS 7613 (P/L 6)
1 04295U 69082G   24187.40021704  .00000044  00000-0  71492-4 0  9990
2 04295  70.0106 188.9833 0021009 347.1142  12.9423 13.95399344786181
0 INTELSAT 3-F6
1 04297U 70003A   24187.55466292 -.00000230  00000-0  00000-0 0  9999
2 04297   0.7984 265.7844 0009275  88.7279 295.7362  0.99161304169803
0 DELTA 1 R/B
1 04298U 70003B   24187.02781492  .00003694  00000-0  20043-2 0  9991
2 04298  27.9101  94.1479 6549292 132.0309 305.9791  3.20824058540661
0 THORAD AGENA D DEB
1 04311U 69082DR  24187.55961906  .00004545  00000-0  80620-3 0  9994
2 04311  70.3361 293.6365 0059163  22.1668 338.2015 14.66717762872673
0 ITOS 1 (TIROS M)
1 04320U 70008A   24187.50704640 -.00000006  00000-0  23826-3 0  9993
2 04320 101.4768 238.2967 0027708 261.0040 234.1036 12.52096566684786
0 OSCAR 5
1 04321U 70008B   24187.62263843 -.00000026  00000-0  10303-3 0  9990
2 04321 101.3714 218.2481 0027359 214.7906 264.3053 12.52170144488381
0 DELTA 1 R/B
1 04322U 70008C   24187.61316442 -.00000022  00000-0  13382-3 0  9990
2 04322 101.3600 212.6203 0027731 247.3122 233.0596 12.51911201487887
0 THORAD AGENA D DEB
1 04326U 69082DZ  24187.59294813  .00000968  00000-0  38855-3 0  9998
2 04326  70.0560 279.8809 0065303  59.8383 300.9189 14.29900987835646
0 SERT 2
1 04327U 70009A   24187.54800509  .00000007  00000-0  64900-4 0  9995
2 04327  99.1868 155.7625 0003992 297.7497 178.4182 13.58623002696763
0 OPS 0054 (DMSP 5A F1)
1 04331U 70012A   24187.36832406  .00000424  00000-0  16688-3 0  9997
2 04331  98.9292 327.9545 0057010 251.8134 107.6838 14.33687399835141
0 THOR BURNER 2 R/B
1 04332U 70012B   24187.58243002  .00000305  00000-0  12960-3 0  9997
2 04332  98.9132  71.2750 0061024 101.1615 259.6435 14.31392906833002
0 NATO 2A
1 04353U 70021A   24187.53416741 -.00000120  00000-0  00000-0 0  9992
2 04353   2.1685 284.3007 0002896 228.7027 223.1221  1.00272540118639
0 DELTA 1 R/B
1 04354U 70021B   24187.33528490  .00014890  00000-0  35914-2 0  9998
2 04354  25.3656  51.0782 6377486  61.8040 347.6454  3.48630712353309
0 NIMBUS 4
1 04362U 70025A   24187.53096297 -.00000011  00000-0  57197-4 0  9998
2 04362  99.9519 104.8973 0006834 295.4696 237.8972 13.44691689661195
0 TOPO 1
1 04363U 70025B   24187.53522517 -.00000021  00000-0  39345-4 0  9994
2 04363  99.9021  99.5891 0001391 319.9124 216.3900 13.46648604665406
0 THORAD AGENA D R/B
1 04367U 70025C   24187.44745911  .00000027  00000-0  11301-3 0  9999
2 04367 100.0501 255.4298 0035487 352.7946  18.0101 13.51428919686786
0 COSMOS 332
1 04369U 70028A   24187.36572076  .00000429  00000-0  11222-3 0  9993
2 04369  74.0347 167.5925 0006706 219.7578 140.3092 14.52332552864720
0 SL-8 R/B
1 04370U 70028B   24187.53207717  .00000695  00000-0  14550-3 0  9993
2 04370  74.0374 214.0299 0015531 201.6518 158.3994 14.61649799387414
0 INTELSAT 3-F7
1 04376U 70032A   24186.21669654 -.00000012  00000-0  00000-0 0  9996
2 04376   0.6177 117.2060 0000893 259.8417 342.9403  1.00257068 40217
0 DELTA 1 R/B
1 04377U 70032B   24187.41735951  .00011926  00000-0  21196-2 0  9990
2 04377  26.7931 285.2602 5826811   6.6975 358.5396  4.30773805602127
0 DFH-1
1 04382U 70034A   24187.53512609  .00000444  00000-0  75580-4 0  9995
2 04382  68.4187  70.8914 1043151 260.5898  87.5946 13.11122885552255
0 COSMOS 336
1 04383U 70036A   24187.55293043  .00000011  00000-0  18291-3 0  9993
2 04383  74.0262 215.7376 0013912 122.5014 351.5608 12.47645105468138
0 COSMOS 337
1 04384U 70036B   24187.57308014  .00000015  00000-0  22984-3 0  9999
2 04384  74.0286 263.2093 0054074 271.3896 196.9209 12.39237858451575
0 COSMOS 338
1 04385U 70036C   24187.13581935  .00000005  00000-0  14826-3 0  9992
2 04385  74.0294  65.0539 0031731  39.2864  75.4400 12.43356260459485
0 COSMOS 339
1 04386U 70036D   24187.60559338 -.00000007  00000-0  57168-4 0  9997
2 04386  74.0299   9.3117 0015175 146.9317 282.4075 12.51856810476355
0 COSMOS 340
1 04387U 70036E   24187.34834398 -.00000022  00000-0 -32113-4 0  9992
2 04387  74.0277 149.7294 0040293 252.7757 262.2785 12.56316723484981
0 COSMOS 341
1 04388U 70036F   24187.55222522 -.00000011  00000-0  29526-4 0  9997
2 04388  74.0289 110.1177 0080935 151.7614  22.9013 12.64330855500978
0 COSMOS 342
1 04389U 70036G   24187.63132520  .00000014  00000-0  16046-3 0  9999
2 04389  74.0290 269.3396 0101928 279.4106 190.8271 12.68316109508903
0 COSMOS 343
1 04390U 70036H   24187.59361127 -.00000019  00000-0 -15847-4 0  9999
2 04390  74.0294 304.5417 0059973   9.0109   2.4154 12.60440870493431
0 SL-8 R/B
1 04391U 70036J   24187.55226020  .00000033  00000-0  37717-3 0  9991
2 04391  74.0288 103.2299 0075844 149.5608  23.5300 12.34982966443177
0 SL-3 R/B
1 04394U 70037B   24187.54002302  .00056039  00000-0  49076-3 0  9997
2 04394  81.2250 201.6975 0015901 236.3606 123.6135 15.68490900960112
0 METEOR 1-5
1 04419U 70047A   24187.54706189  .00000241  00000-0  11581-3 0  9994
2 04419  81.2155 217.5047 0038324 287.1142  72.5836 14.15857382788023
0 SL-3 R/B
1  4420U 70047B   24187.55204722  .00000156  00000-0  74727-4 0  9990
2  4420  81.2313 333.6090 0087751 131.2800 229.5972 14.12367355781972
0 COSMOS 252 DEB *
1 04421U 68097CF  24187.08516306  .00018322  00000-0  26270-2 0  9997
2 04421  62.7318  59.2305 0720917  72.7024 295.1541 13.74578312460864
0 THORAD AGENA D DEB
1  4432U 69082ED  24187.20761244  .00001087  00000-0  44745-3 0  9999
2  4432  69.9777 110.0249 0051957  30.8811 329.5350 14.28793002833844
0 THORAD AGENA D DEB
1 04435U 69082EG  24187.60953081  .00008756  00000-0  13927-2 0  9995
2 04435  70.0208 280.2523 0019401 226.9117 133.0405 14.72194970861566
0 THORAD AGENA D DEB
1 04438U 69082EK  24187.33648718  .00002859  00000-0  59436-3 0  9990
2 04438  70.0995 130.3529 0049544 126.5754 233.9960 14.60344524870493
0 THORAD AGENA D DEB
1 04449U 69082EU  24187.48791602  .00002171  00000-0  67954-3 0  9990
2 04449  69.9759 308.5030 0056163 293.1637  66.3581 14.41088845837706
0 THORAD AGENA D DEB
1 04451U 69082EW  24187.54796053  .00002679  00000-0  69765-3 0  9990
2 04451  70.0365 283.2686 0033786  36.6908 323.6530 14.50284947852282
0 THORAD AGENA D DEB
1 04453U 69082EY  24187.37128344  .00000546  00000-0  33438-3 0  9994
2 04453  70.1317 283.2355 0032857  16.7000 343.5188 14.10574898808054
0 THORAD AGENA D DEB
1 04468U 69082FM  24187.58045810  .00000340  00000-0  33282-3 0  9998
2 04468  70.0726 157.6230 0084155  85.3568 275.7138 13.85463416757247
0 INTELSAT 3-F8
1 04478U 70055A   24187.10170405 -.00000309  00000-0  00000-0 0  9993
2 04478   3.7029  76.7040 0315398  93.9245  69.1387  1.02266033115544
0 DELTA 1 DEB
1 04499U 68069G   24186.56565289 -.00000016  00000-0  16993-3 0  9991
2 04499 101.4073 218.9744 0027786 307.8441 207.3817 12.51270222554125
0 NNSS 19 (TRANSIT 19)
1 04507U 70067A   24187.59931443  .00000145  00000-0  19086-3 0  9993
2 04507  89.9681 235.2189 0172661  15.3425 345.2868 13.51078361651308
0 OPS 7329
1 04510U 70069A   24187.18650962 -.00000191  00000-0  00000-0 0  9993
2 04510  10.3116 179.3525 0999211  80.4950  69.2716  1.00288129 17654
0 ATLAS AGENA D R/B
1 04511U 70046B   24186.75156550 -.00000031  00000-0  00000-0 0  9998
2 04511   0.1591 252.6747 0030680 129.9202 337.5250  1.00394261 18408
0 OPS 0203 (DMSP 5A F2)
1 04512U 70070A   24187.50566145  .00000564  00000-0  20711-3 0  9999
2 04512  98.8275 106.2474 0064287  23.6373 336.7742 14.35559207809479
0 THOR BURNER 2 R/B
1 04513U 70070B   24187.43553798  .00000321  00000-0  12851-3 0  9999
2 04513  98.8758 124.9246 0067003 155.0590 205.3856 14.33923283807517
0 SCOUT A R/B
1 04515U 70067B   24187.61854809  .00000145  00000-0  19193-3 0  9994
2 04515  89.9687 234.6888 0176164 102.0661  11.9725 13.49454361649367
0 THORAD AGENA D DEB
1 04547U 69082GN  24187.35186048  .00001889  00000-0  72033-3 0  9996
2 04547  69.9902  13.8615 0034350 110.8695 249.6113 14.31984712829966
0 SCOUT A DEB
1 04555U 66041F   24187.10651459  .00003494  00000-0  98403-3 0  9996
2 04555  90.1959  57.4459 0046621  22.8549 337.4715 14.45070541320766
0 COSMOS 367
1 04564U 70079A   24187.36007556 -.00000050  00000-0  34269-4 0  9990
2 04564  65.2786  66.5401 0066651 333.7891  25.9800 13.78505974704997
0 COSMOS 371
1 04578U 70083A   24187.45226172  .00000488  00000-0  12025-3 0  9996
2 04578  73.9986  85.0949 0003757 247.4007 112.6759 14.54862137842049
0 SL-8 R/B
1 04579U 70083B   24187.55835427  .00000769  00000-0  15929-3 0  9995
2 04579  74.0003 202.1054 0011562 297.7333  62.2660 14.62012192850737
0 COSMOS 372
1 04588U 70086A   24187.48732942  .00000238  00000-0  90130-4 0  9997
2 04588  74.0560  81.0671 0012705  19.2755 153.7457 14.36478621810706
0 SL-8 R/B
1 04589U 70086B   24187.55091810  .00000357  00000-0  11536-3 0  9992
2 04589  74.0588 233.1746 0019896 161.7716 198.4158 14.42468221817879
0 COSMOS 374
1 04594U 70089A   24187.07983851  .00000453  00000-0  23885-3 0  9990
2 04594  62.9469  58.3210 0934607 356.3068   3.1343 12.95705198576592
0 SL-11 R/B
1 04597U 70089B   24187.49523365  .00000209  00000-0  12659-3 0  9995
2 04597  62.9459 207.1463 0950754 358.5538   1.2748 12.95102610667482
0 COSMOS 375
1 04598U 70091A   24187.53722898  .00000361  00000-0  14731-3 0  9998
2 04598  62.8078 263.4839 0990547 105.5570 265.6873 12.96813085536263
0 THORAD AGENA D DEB
1 04603U 70025F   24187.48358367  .00001223  00000-0  11350-2 0  9993
2 04603  99.5126 271.3973 0018924 345.0534  28.4225 13.84251732694195
0 THORAD AGENA D DEB
1  4607U 70025K   24187.56863503  .00000181  00000-0  94957-3 0  9996
2  4607 100.1593 207.3010 0615667 139.5528 345.7275 12.30862093434148
0 THORAD AGENA D DEB
1 04611U 70025P   24187.55437745  .00000173  00000-0  13680-3 0  9990
2 04611  99.8028 122.6701 0125256 230.1524 128.8566 14.02362563755899
0 THORAD AGENA D DEB
1 04612U 70025Q   24187.59192007  .00001081  00000-0  72354-3 0  9996
2 04612  99.7169  51.7972 0084949  99.7942 261.2826 14.01561996745141
0 THORAD AGENA D DEB
1 04613U 70025R   24187.60696613  .00004800  00000-0  21528-2 0  9999
2 04613  98.6513 225.5601 0098495  77.6643 283.5539 14.20345905759859
0 THORAD AGENA D DEB
1 04614U 70025S   24187.56131011  .00001045  00000-0  86187-3 0  9992
2 04614 100.0680 137.9087 0079285 178.0422 182.1058 13.90323308727577
0 THORAD AGENA D DEB
1 04615U 70025T   24187.15793591  .00000390  00000-0  47583-3 0  9994
2 04615 100.1266 265.8799 0061200 121.8041 304.1674 13.72081466704965
0 COSMOS 374 DEB
1 04616U 70089C   24186.91978528  .00001384  00000-0  10358-2 0  9996
2 04616  62.8057  88.5251 0959224   9.3270 352.4194 12.71674716453415
0 COSMOS 374 DEB
1 04617U 70089D   24187.50246458  .00003805  00000-0  80405-3 0  9994
2 04617  62.9455  19.4291 0334029 239.0404 117.7445 14.31326605665669
0 COSMOS 374 DEB
1 04621U 70089H   24187.57308782  .00006459  00000-0  17218-2 0  9994
2 04621  62.9151 274.6541 0723056 136.8365 229.1737 13.53750101584928
0 COSMOS 375 DEB
1 04628U 70091H   24187.57823417  .00021150  00000-0  25664-2 0  9990
2 04628  62.7520 280.2817 0424179 114.4340 250.1590 14.35843566660263
0 COSMOS 375 DEB
1 04629U 70091J   24187.56876704  .00000325  00000-0  16479-3 0  9993
2 04629  62.8526 252.2847 0926457 350.4372   7.9991 13.01834869537125
0 OPS 5960
1 04630U 70093A   24187.52269353 -.00000166  00000-0  00000-0 0  9993
2 04630  14.0011  49.3643 1377123 247.3438 304.8420  1.20217295235286
0 TITAN 3C TRANSTAGE R/B
1 04632U 70093B   24187.16686259 -.00000166  00000-0  00000-0 0  9993
2 04632  14.0066  49.0396 1385803 247.4368 310.0017  1.20232214133845
0 COSMOS 375 DEB
1 04634U 70091L   24187.50859252  .00002841  00000-0  65543-3 0  9993
2 04634  62.8030  17.4841 0528218 348.1759  10.7264 13.96045200644527
0 COSMOS 375 DEB
1 04635U 70091M   24187.45217450  .00000162  00000-0  89548-4 0  9992
2 04635  62.8102  95.5022 0943015 137.1298 230.7288 13.04627779548839
0 THORAD AGENA D DEB
1 04636U 70025U   24187.44632744  .00000597  00000-0  73783-3 0  9991
2 04636  99.9880 144.8157 0033946 131.8079 343.5636 13.69396036697680
0 THORAD AGENA D DEB
1 04637U 70025V   24187.56558066  .00000173  00000-0  27415-3 0  9990
2 04637  99.9674 197.8971 0022868 327.4960 154.8056 13.64384795690571
0 THORAD AGENA D DEB
1 04639U 70025X   24187.46618455  .00000088  00000-0  26062-3 0  9992
2 04639  99.9532 267.3867 0112902 337.6145  36.0229 13.32838203634451
0 THORAD AGENA D DEB
1 04640U 70025Y   24187.57891012  .00000556  00000-0  10855-2 0  9990
2 04640  99.9851 307.5518 0120870 225.1754 148.6939 13.38328632636868
0 THORAD AGENA D DEB
1 04643U 70025AB  24187.60870999  .00000220  00000-0  38212-3 0  9994
2 04643  99.4786  56.9843 0009940 213.8196 214.8445 13.54844667675430
0 THORAD AGENA D DEB
1 04644U 70025AC  24187.62145677  .00000475  00000-0  69870-3 0  9991
2 04644  99.6141  85.2695 0012662 316.9948 103.7818 13.59754591680441
0 THORAD AGENA D DEB
1 04645U 70025AD  24187.57788301  .00000019  00000-0  18162-3 0  9995
2 04645  99.9284 303.7531 0328494  15.2677 358.7674 12.86370802543922
0 THORAD AGENA D DEB
1 04649U 70025AH  24187.55511502  .00045274  00000-0  24844-2 0  9999
2 04649  99.8595  11.3872 0039360 296.0910  63.6265 15.13330895821603
0 THORAD AGENA D DEB
1 04650U 70025AJ  24187.40805313  .00001268  00000-0  72280-3 0  9994
2 04650  99.8615 237.9043 0116989 238.5881 120.3801 14.08480177757387
0 THORAD AGENA D DEB
1 04651U 70025AK  24187.55140373  .00001911  00000-0  13272-2 0  9999
2 04651 100.1480  51.6370 0043962 186.5242 173.5351 13.99851773736022
0 THORAD AGENA D DEB
1 04652U 70025AL  24187.60143218  .00001160  00000-0  10093-2 0  9991
2 04652  99.5510 310.4150 0029979 319.5103  53.1561 13.88031805718396
0 THORAD AGENA D DEB
1 04653U 70025AM  24187.41992434  .00011610  00000-0  34616-2 0  9991
2 04653 100.0095 350.9283 0020670 208.8428 151.1615 14.43107774763589
0 THORAD AGENA D DEB
1 04654U 70025AN  24187.46503370  .00002580  00000-0  14772-2 0  9991
2 04654 100.0091 264.4427 0029030 215.7512 144.1711 14.10353480739342
0 THORAD AGENA D DEB
1 04655U 70025AP  24187.21225439  .00000324  00000-0  42699-3 0  9996
2 04655  99.9851 262.2597 0055890 155.3706 205.0125 13.68753977700390
0 THORAD AGENA D DEB
1 04656U 70025AQ  24187.52579550  .00000463  00000-0  59782-3 0  9992
2 04656  99.4414  88.7307 0026832   0.2557 176.1420 13.67631640695982
0 THORAD AGENA D DEB
1 04657U 70025AR  24187.49486520  .00000655  00000-0  79018-3 0  9990
2 04657 100.1685  15.2893 0017699  66.4387 348.5985 13.70791218697169
0 THORAD AGENA D DEB
1 04658U 70025AS  24187.44640992  .00002153  00000-0  16261-2 0  9996
2 04658  99.9171  90.6100 0024980 299.4581  60.4086 13.95242152718978
0 THORAD AGENA D DEB
1 04659U 70025AT  24187.36346446  .00001997  00000-0  16587-2 0  9991
2 04659 100.1056 236.8788 0009174 346.9154  13.1762 13.90068473709618
0 COSMOS 375 DEB
1 04665U 70091S   24187.50076332  .00003986  00000-0  84820-3 0  9997
2 04665  62.5275 249.5780 0753544  44.3865 321.5092 13.56372697558215
0 COSMOS 374 DEB
1 04667U 70089K   24187.38055434  .00008075  00000-0  20150-2 0  9991
2 04667  62.9292  51.2207 0704632  55.8402 310.7410 13.59447787591510
0 COSMOS 374 DEB
1 04668U 70089L   24187.31217505  .00000006  00000-0  56310-4 0  9999
2 04668  62.9830 162.1912 0921990 264.2351  85.2958 12.86819583518001
0 THORAD AGENA D DEB
1  4672U 70025AV  24186.60232399  .00000357  00000-0  57753-3 0  9993
2  4672  99.4566  47.9613 0039668  57.0472 321.8321 13.54842419673341
0 THORAD AGENA D DEB
1 04675U 70025AY  24187.50135603  .00000010  00000-0  86933-4 0  9995
2 04675 100.0750 140.7886 0001215  27.4448  80.8023 13.51420063673629
0 THORAD AGENA D DEB
1 04676U 70025AZ  24187.62483785  .00000161  00000-0  30167-3 0  9990
2 04676 100.1684 200.9445 0003664 334.9612 134.5376 13.55214730678119
0 THORAD AGENA D DEB
1 04677U 70025BA  24187.54931416  .00000134  00000-0  24901-3 0  9990
2 04677  99.9474 287.0246 0010348 126.7612 351.3038 13.58030810681948
0 THORAD AGENA D DEB
1 04679U 70025BC  24187.61257837  .00000449  00000-0  58934-3 0  9990
2 04679 100.1162 320.9588 0018434 189.5476 184.8979 13.67587914692918
0 THORAD AGENA D DEB
1 04681U 70025BE  24187.49851509  .00000007  00000-0  12517-3 0  9992
2 04681  99.9082  93.3612 0241556 238.8852 298.6849 13.08241850582105
0 THORAD AGENA D DEB
1 04682U 70025BF  24187.63170978  .00000372  00000-0  91509-3 0  9996
2 04682  99.8059 232.8131 0144098  42.7274  79.8671 13.23995272613904
0 THORAD AGENA D DEB
1 04683U 70025BG  24187.00035480  .00000271  00000-0  61173-3 0  9998
2 04683 100.4815 202.3116 0122068 328.9557  86.0508 13.34410635632474
0 THORAD AGENA D DEB
1 04685U 70025BJ  24187.20124312  .00000395  00000-0  62673-3 0  9998
2 04685  99.9862 254.2689 0052832 258.4686 172.0830 13.55870683672993
0 THORAD AGENA D DEB
1 04686U 70025BK  24187.17561913  .00000319  00000-0  51453-3 0  9997
2 04686 100.2329 253.0763 0036814  67.8580 316.6684 13.56911555674108
0 THORAD AGENA D DEB
1 04687U 70025BL  24187.42470709  .00000188  00000-0  35606-3 0  9994
2 04687  99.4790 351.4787 0026503 266.9258 147.2377 13.50837486668167
0 THORAD AGENA D DEB
1 04688U 70025BM  24186.78897594  .00000213  00000-0  38777-3 0  9999
2 04688 100.0632 268.6005 0021281 223.8769 264.2750 13.53267348671358
0 THORAD AGENA D DEB
1 04689U 70025BN  24187.37865652  .00000309  00000-0  49693-3 0  9991
2 04689  99.4228  44.7320 0070898  20.8852 155.3330 13.55555904673952
0 COSMOS 374 DEB
1 04698U 70089Q   24187.48614398  .00007444  00000-0  24890-2 0  9990
2 04698  63.1029 324.8627 0711058  83.2780 284.8585 13.47452598559166
0 COSMOS 374 DEB
1 04699U 70089R   24187.33174536  .00015650  00000-0  17295-2 0  9999
2 04699  62.9206 185.0525 0401524 116.2113 248.0817 14.43152467607495
0 THORAD AGENA D DEB
1  4705U 70025BT  24187.23758200  .00000473  00000-0  71580-3 0  9997
2  4705  99.9928 293.7163 0043205 211.0073 214.3716 13.57955241674107
0 THORAD AGENA D DEB
1 04706U 70025BU  24187.47217537  .00000045  00000-0  14862-3 0  9992
2 04706  99.8366  90.6564 0034266 352.2572 183.6141 13.45700447661672
0 THORAD AGENA D DEB
1 04708U 70025BW  24187.61415811  .00002172  00000-0  19161-2 0  9994
2 04708 100.0740 212.0463 0067635 174.0267 306.8431 13.85423839696535
0 THORAD AGENA D DEB
1 04709U 70025BX  24187.19704993  .00006589  00000-0  16818-2 0  9992
2 04709 100.0285 322.0077 0085713  47.4541 313.3842 14.48746638799581
0 THORAD AGENA D DEB
1 04710U 70025BY  24187.50451655  .00000244  00000-0  41966-3 0  9998
2 04710 100.1452 167.7722 0005630 120.6848 356.5063 13.55528932677092
0 COSMOS 374 DEB
1 04711U 70089S   24187.34242803  .00001461  00000-0  48032-3 0  9997
2 04711  63.1226 250.5601 0802927  39.6378 326.0597 13.33323529559643
0 COSMOS 375 DEB
1 04712U 70091T   24187.50246204  .00007749  00000-0  13346-2 0  9992
2 04712  62.7738 340.9273 0555530  54.4853 310.6713 14.00479580643685
0 THORAD AGENA D DEB
1 04715U 70025BZ  24187.44024182  .00000543  00000-0  54793-3 0  9991
2 04715  99.1868 257.7436 0035784 206.0812 167.5128 13.81487271715117
0 THORAD AGENA D DEB
1 04716U 70025CA  24187.49763501  .00001945  00000-0  12982-2 0  9992
2 04716  99.9602 260.3476 0009177  88.7213 283.2869 14.02449005725580
0 THORAD AGENA D DEB
1 04717U 70025CB  24187.36931892  .00000133  00000-0  26321-3 0  9990
2 04717 100.0970 239.2338 0002954 175.6588 244.8317 13.54651308677025
0 THORAD AGENA D DEB
1 04718U 70025CC  24187.00636945  .00001135  00000-0  72018-3 0  9990
2 04718 100.0525 211.0274 0101517 307.6942  51.5049 14.03853692754177
0 THORAD AGENA D DEB
1 04719U 70025CD  24187.59410435  .00000887  00000-0  65350-3 0  9993
2 04719  99.9798 174.0223 0122299 300.7173  58.1984 13.95192510743307
0 THORAD AGENA D DEB
1 04720U 70025CE  24186.60610935  .00001029  00000-0  67740-3 0  9997
2 04720 100.0452  62.7431 0087623  62.6362 298.3684 14.02640632750449
0 COSMOS 375 DEB
1  4724U 70091V   24187.53300545  .00017411  00000-0  26558-2 0  9993
2  4724  62.7746 116.7366 0513052  64.4569 300.8608 14.12050763658408
0 COSMOS 375 DEB
1 04727U 70091Y   24187.54133196  .00007309  00000-0  11739-2 0  9993
2 04727  62.6816 245.6411 0515571  64.2520 301.0810 14.10316792652726
0 COSMOS 375 DEB
1 04728U 70091Z   24187.47056297  .00002592  00000-0  86434-3 0  9996
2 04728  62.9013 347.1982 0676913 201.9616 155.1092 13.55059603580367
0 THORAD AGENA D DEB
1 04733U 70025CG  24187.60226005  .00003709  00000-0  76166-3 0  9992
2 04733  99.8926  63.5598 0107640 250.8212 108.1307 14.57861417801324
0 THORAD AGENA D DEB
1 04734U 70025CH  24187.51515128  .00000771  00000-0  70449-3 0  9994
2 04734 100.1742 203.4967 0083541  51.4803 309.3802 13.85240215723983
0 THORAD AGENA D DEB
1 04735U 70025CJ  24187.59789471  .00015572  00000-0  29009-2 0  9997
2 04735  99.6492  53.4031 0033794 133.5903 226.8109 14.64789631790188
0 THORAD AGENA D DEB
1 04736U 70025CK  24187.47006446  .00000544  00000-0  38622-3 0  9994
2 04736 100.0252 128.1355 0091117 320.0176  39.4301 14.00723091746896
0 THORAD AGENA D DEB
1 04737U 70025CL  24187.46445799  .00005533  00000-0  25391-2 0  9993
2 04737  99.0314 141.5065 0031072 348.2210  11.8236 14.21419589746006
0 THORAD AGENA D DEB
1 04738U 70025CM  24187.28272959  .00003259  00000-0  18326-2 0  9993
2 04738 100.0799  89.0440 0052227  57.7402 302.8810 14.10610436739690
0 THORAD AGENA D DEB
1 04739U 70025CN  24187.42419485  .00002056  00000-0  15874-2 0  9996
2 04739  99.9508 347.5796 0004762 138.6590 283.4716 13.94179110714804
0 THORAD AGENA D DEB
1 04741U 70025CQ  24187.61702292  .00000194  00000-0  12060-2 0  9996
2 04741 100.2813  62.5076 0788067 127.1085 313.0326 11.94466850364239
0 THORAD AGENA D DEB
1 04742U 70025CR  24187.39364644  .00000225  00000-0  39946-3 0  9995
2 04742 100.1021 234.0833 0020463  90.3756 280.8546 13.54071612673674
0 THORAD AGENA D DEB
1 04743U 70025CS  24187.45966253  .00000409  00000-0  63095-3 0  9993
2 04743  99.9715 248.1122 0034531 288.3930  87.8845 13.57693493676446
0 THORAD AGENA D DEB
1 04744U 70025CT  24187.56377237  .00000106  00000-0  21756-3 0  9996
2 04744 100.1669 188.7097 0015236 190.9702 169.1104 13.56649983678769
0 THORAD AGENA D DEB
1 04745U 70025CU  24187.27552953  .00001790  00000-0  13646-2 0  9993
2 04745 100.0753  88.0222 0029227  83.8931 276.5556 13.94930257721856
0 THORAD AGENA D DEB
1 04748U 70025CW  24187.60765146  .00000478  00000-0  66495-3 0  9996
2 04748 100.0525 327.8120 0007015 108.6347 251.5555 13.63566813685934
0 THORAD AGENA D DEB
1 04749U 70025CX  24187.53161183  .00001385  00000-0  12974-2 0  9990
2 04749  99.0491  38.6280 0016533 110.1453 250.1483 13.83325005704844
0 THORAD AGENA D DEB
1 04751U 70025CZ  24187.58540305  .00001517  00000-0  13821-2 0  9994
2 04751 100.1515 218.6768 0005688 115.1228 245.0515 13.85184361706934
0 THORAD AGENA D DEB
1 04752U 70025DA  24187.14760895  .00003140  00000-0  17988-2 0  9997
2 04752  99.8788 248.1082 0021614 234.2206 125.6952 14.10191320733439
0 THORAD AGENA D DEB
1 04753U 70025DB  24187.50827297  .00001189  00000-0  11485-2 0  9995
2 04753  99.9839 264.4609 0005715  24.1310 336.0108 13.82217585704417
0 THORAD AGENA D DEB
1 04754U 70025DC  24187.59262975  .00006304  00000-0  29525-2 0  9999
2 04754  99.6017  68.4597 0016293 131.2372 229.0209 14.20514579732142
0 THORAD AGENA D DEB
1 04755U 70025DD  24187.63534277  .00002340  00000-0  18380-2 0  9995
2 04755 100.1353 321.4161 0005927  96.3013 263.8819 13.93061762711496
0 THORAD AGENA D DEB
1 04756U 70025DE  24187.50921630  .00000125  00000-0  27379-3 0  9993
2 04756 100.2933 195.2862 0028721 108.9783 251.4464 13.49113137666132
0 THORAD AGENA D DEB
1 04757U 70025DF  24187.55492848  .00000487  00000-0  67411-3 0  9995
2 04757  99.4676  70.1045 0013994 103.5746 256.6956 13.63175585683779
0 THORAD AGENA D DEB
1 04759U 70025DH  24187.15886042  .00000958  00000-0  10700-2 0  9997
2 04759 100.0048 148.3849 0001644 340.9566  31.6412 13.74146212697050
0 THORAD AGENA D DEB
1  4764U 70025DJ  24187.53777196  .00009454  00000-0  41679-2 0  9993
2  4764  99.5061 172.1087 0035678 318.1400  41.7048 14.23243816725085
0 THORAD AGENA D DEB
1 04765U 70025DK  24187.44756301  .00017116  00000-0  27279-2 0  9993
2 04765  99.5884 141.9039 0047206 142.7227 217.7267 14.71292167803258
0 THORAD AGENA D DEB
1 04766U 70025DL  24187.61846138  .00000089  00000-0  19426-3 0  9998
2 04766 100.0363 314.4328 0008425 314.8210  59.0677 13.55688711680206
0 THORAD AGENA D DEB
1 04767U 70025DM  24187.47238609  .00000210  00000-0  27803-3 0  9995
2 04767  99.9591 253.1318 0052249 260.4706 114.4757 13.72751509704503
0 THORAD AGENA D DEB
1  4768U 70025DN  24187.56831094  .00000469  00000-0  58024-3 0  9998
2  4768 100.1965 178.6648 0031176  22.3155  98.3893 13.70870358700868
0 THORAD AGENA D DEB
1 04769U 70025DP  24186.78762450  .00086312  00000-0  51651-2 0  9990
2 04769  99.5920 214.0314 0019158 194.6425 165.4245 15.10486377768361
0 THORAD AGENA D DEB
1 04772U 70025DS  24187.47075431  .00000682  00000-0  15050-2 0  9996
2 04772  99.7185  16.3098 0183006 183.1884 207.0039 13.25799106607815
0 THORAD AGENA D DEB
1 04773U 70025DT  24187.63125090  .00000430  00000-0  67768-3 0  9997
2 04773 100.1075 212.6532 0030190 214.4676 264.6691 13.56201024671609
0 THORAD AGENA D DEB
1 04774U 70025DU  24187.23228550  .00001723  00000-0  17177-2 0  9993
2 04774  99.6939 291.0156 0046462 162.5932 231.8390 13.79032561692339
0 THORAD AGENA D DEB
1  4776U 70025DW  24187.56652906  .00002445  00000-0  17711-2 0  9993
2  4776 100.1205  56.7948 0018852 114.4057 309.2729 13.97519960639460
0 THORAD AGENA D DEB
1 04777U 70025DX  24187.11501681  .00001911  00000-0  16391-2 0  9998
2 04777  99.9629 240.9215 0012887 155.2607 259.5857 13.88213364708090
0 THORAD AGENA D DEB
1  4778U 70025DY  24186.61216084  .00000217  00000-0  37973-3 0  9991
2  4778 100.0549 230.1637 0035505  28.4495 123.2403 13.55207950675492
0 COSMOS 381
1 04783U 70102A   24187.50066318  .00000037  00000-0  62274-4 0  9998
2 04783  74.0328 112.4079 0031481 287.0688  72.6984 13.74928196688332
0 SL-8 R/B
1 04784U 70102B   24187.60815541  .00000109  00000-0  13333-3 0  9991
2 04784  74.0302  18.4668 0026459 189.3510 239.5502 13.76873615691220
0 COSMOS 382
1 04786U 70103A   24187.55124605 -.00000022  00000-0  00000-0 0  9991
2 04786  55.8795  13.8831 1349317 293.3126 122.9141  8.42040386648636
0 SL-12 R/B(AUX MOTOR)
1 04789U 70103B   24187.33089922  .00000042  00000-0  41167-2 0  9994
2 04789  51.5800 161.7191 1799912 132.5616  10.7441  9.06801017775117
0 SL-12 R/B(AUX MOTOR)
1 04790U 70103C   24187.53293371 -.00000113  00000-0 -40822-2 0  9991
2 04790  51.5938 324.8574 1789181  10.1751 353.0676  9.05046954771665
0 NOAA 1
1 04793U 70106A   24187.61402198 -.00000022  00000-0  13292-3 0  9995
2 04793 101.4448 239.1287 0031033 301.2624 181.7401 12.54029294451490
0 DELTA 1 R/B(CEP 1)
1 04794U 70106B   24187.59592832 -.00000019  00000-0  14787-3 0  9994
2 04794 101.3486 217.6274 0036350 305.1583 172.0658 12.53255970842271
0 COSMOS 385
1 04799U 70108A   24187.34140079  .00000013  00000-0  36182-4 0  9993
2 04799  74.0208 135.6304 0004694 240.9533 231.1762 13.76887120690575
0 SL-8 R/B
1  4800U 70108B   24187.56171798  .00000044  00000-0  65528-4 0  9992
2  4800  74.0222  40.9482 0009905 264.6625  95.3367 13.78857661694523
0 THORAD AGENA D DEB
1 04818U 70025DZ  24187.46866854  .00000334  00000-0  90270-3 0  9995
2 04818  99.8473 140.8738 0269061  35.0568  76.8198 13.09727430586627
0 THORAD AGENA D DEB
1 04819U 70025EA  24187.61796405  .00005801  00000-0  24881-2 0  9995
2 04819 100.0935  80.5451 0038983 114.4188 246.1062 14.24835258742245
0 THORAD AGENA D DEB
1 04820U 70025EB  24187.56295219  .00077799  00000-0  96208-2 0  9995
2 04820  99.6970  75.2349 0014702  99.4935 260.7934 14.82285594742292
0 THORAD AGENA D DEB
1 04821U 70025EC  24187.51978681  .00000350  00000-0  54468-3 0  9994
2 04821 100.0847 203.1267 0009579 188.2927 325.0674 13.58656261679546
0 THORAD AGENA D DEB
1 04822U 70025ED  24187.61190940  .00003973  00000-0  22463-2 0  9993
2 04822  99.3652 312.1041 0052839 292.8816  66.6780 14.10068328689893
0 COSMOS 374 DEB
1 04823U 70089T   24187.15559730  .00000173  00000-0  26414-3 0  9999
2 04823  63.0354  81.5944 0896782 331.3813  24.0606 12.65259543446489
0 DELTA 1 DEB
1 04841U 68055D   24187.31353079  .00000122  00000-0  25212-3 0  9994
2 04841 120.7332 305.4530 2679920 270.2698 137.4763  9.28978442 69285
0 THORAD AGENA D DEB
1 04842U 70025EE  24187.50948003  .00005061  00000-0  32510-2 0  9998
2 04842  99.9125 112.3084 0017831  34.7344 325.4979 14.03595029722771
0 OPS 0100 DEB *
1 04843U 67034E   24186.98635712  .00000163  00000-0  23407-3 0  9990
2 04843  90.4041 113.8728 0029155  43.1652  87.4901 13.52367805177376
0 THORAD AGENA D DEB
1 04854U 70025EJ  24187.48683075  .00000327  00000-0  52283-3 0  9993
2 04854  99.4187  44.8396 0016809 178.1172 252.4197 13.56461723675798
0 THORAD AGENA D DEB
1 04855U 70025EK  24187.26403931  .00000749  00000-0  85759-3 0  9993
2 04855  99.9132 102.4262 0017211  81.6878  72.1791 13.73276717699199
0 THORAD AGENA D DEB
1 04856U 70025EL  24187.08802597  .00001031  00000-0  55642-3 0  9998
2 04856  99.7563 242.3629 0156376 115.8832 245.8550 14.09088404770065
0 THORAD AGENA D DEB
1 04857U 70025EM  24187.42246592  .00003393  00000-0  15172-2 0  9990
2 04857  99.7794 359.9826 0047603 311.1187  48.5882 14.22810605722033
0 THORAD AGENA D DEB
1 04859U 70025EP  24187.47089804  .00000845  00000-0  11934-2 0  9999
2 04859  99.9575 263.4646 0045108 280.8262  92.0378 13.59659738670939
0 THORAD AGENA D DEB
1 04864U 70025EU  24187.31196186  .00000167  00000-0  32932-3 0  9999
2 04864  99.4451 326.1262 0047769 103.9952 330.0912 13.49164721664945
0 THORAD AGENA D DEB
1 04867U 70025EX  24187.42883347  .00000661  00000-0  44559-3 0  9993
2 04867  99.6213  82.1348 0127815 245.8890 112.8860 14.00609564755056
0 THORAD AGENA D DEB
1 04868U 70025EY  24187.58310002  .00001294  00000-0  92159-3 0  9996
2 04868  99.7594 202.5443 0056342 173.1727 187.0214 13.98739405735613
0 INTELSAT 4-F2
1 04881U 71006A   24187.14354719 -.00000255  00000-0  00000-0 0  9994
2 04881   6.1906 285.1033 0011840  90.2333 103.6723  0.98839935114463
0 ATLAS CENTAUR R/B
1 04882U 71006B   24187.44344771 -.00000083  00000-0  29438-2 0  9992
2 04882  27.6611 124.9991 7147715  43.4059  55.3325  2.20715012427476
0 THORAD AGENA D DEB
1 04895U 69082HE  24187.59227415  .00001759  00000-0  57758-3 0  9995
2 04895  70.1731 266.1148 0044043 231.7727 127.9435 14.39329227840655
0 NATO 2B
1 04902U 71009A   24187.53140652 -.00000087  00000-0  00000-0 0  9996
2 04902   2.9602 269.1556 0005585 204.2442 256.9367  1.00271063111507
0 DELTA 1 R/B
1 04903U 71009B   24187.59379439  .00005505  00000-0  17275-2 0  9993
2 04903  25.6003 353.7738 5873191  54.8534 347.0868  4.20438178567206
0 TITAN 3C TRANSTAGE DEB
1 04907U 65082SV  24187.26827302  .00000725  00000-0  14400-3 0  9999
2 04907  32.4842 238.2029 0047435  85.6360 274.9709 14.58855078114119
0 THORAD AGENA D DEB
1 04910U 70025FG  24187.32949601  .00005934  00000-0  32840-2 0  9994
2 04910  99.4306 222.9177 0108666 154.6299 206.0260 14.08746797705674
0 THORAD AGENA D DEB
1 04911U 70025FH  24187.61713455  .00004308  00000-0  18160-2 0  9996
2 04911  99.9636 314.4916 0067512 155.0395 205.4069 14.25078136769922
0 THORAD AGENA D DEB
1 04912U 70025FJ  24187.56242200  .00004140  00000-0  19511-2 0  9991
2 04912  99.7443 223.2475 0043205 139.8085 220.6296 14.20010101752828
0 THORAD AGENA D DEB
1  4913U 70025FK  24187.54389921  .00000283  00000-0  20818-3 0  9999
2  4913  99.8850 216.7216 0139097 319.7703  39.3229 14.00427775754867
0 THORAD AGENA D DEB
1 04914U 70025FL  24187.41196259  .00002701  00000-0  33316-2 0  9999
2 04914  99.4220 139.0203 0075134 251.7005 228.3420 13.64909495677465
0 THORAD AGENA D DEB
1 04918U 70025FQ  24187.46713689  .00000402  00000-0  89601-3 0  9995
2 04918  99.4312  18.3723 0161525 322.3034  36.6859 13.28822030618071
0 THORAD AGENA D DEB
1  4919U 70025FR  24187.53269309  .00002733  00000-0  14403-2 0  9995
2  4919 100.0939 182.5450 0040881 250.2904 109.3852 14.14550759749598
0 THORAD AGENA D DEB
1 04920U 70025FS  24187.59736204  .00000392  00000-0  66997-3 0  9991
2 04920  99.4635 106.8157 0091856 349.4112 133.4736 13.49570305657545
0 THORAD AGENA D DEB
1 04921U 70025FT  24187.14812612  .00005080  00000-0  16218-2 0  9990
2 04921  99.7297 243.9734 0046801   7.4870 352.7003 14.39585122772510
0 COSMOS 394
1 04922U 71010A   24187.57059098  .00004699  00000-0  13084-3 0  9998
2 04922  65.8245  58.1509 0022709 273.0633  86.7913 15.37809013948249
0 THORAD AGENA D DEB
1 04928U 70025FU  24187.60824620  .00000539  00000-0  18871-2 0  9991
2 04928  99.7097 193.4011 0436357  57.7911  57.3282 12.72750361508355
0 THORAD AGENA D DEB
1  4929U 70025FV  24187.56385488  .00000544  00000-0  20707-2 0  9998
2  4929  99.7041 282.9622 0455622 160.6862 216.6679 12.65064104495060
0 THORAD AGENA D DEB
1 04932U 70025FY  24187.50002130  .00003739  00000-0  29017-2 0  9998
2 04932  99.7794 152.4571 0033283  73.2329  45.1648 13.92981851703831
0 THORAD AGENA D DEB
1 04934U 70025GA  24187.51538769  .00000676  00000-0  77263-3 0  9997
2 04934 100.0056 268.8820 0006720 195.0301 282.9193 13.73936730698584
0 THORAD AGENA D DEB
1 04935U 70025GB  24187.20416463  .00000941  00000-0  85346-3 0  9996
2 04935  99.8400 268.0406 0065548  82.0890 334.3937 13.85440698718370
0 THORAD AGENA D DEB
1 04938U 69082HJ  24187.49334172  .00010269  00000-0  16271-2 0  9991
2 04938  70.1299 340.4044 0019784  69.6383 290.6886 14.72291082868071
0 COSMOS 375 DEB
1 04942U 70091AK  24186.89584695  .00000512  00000-0  38374-3 0  9997
2 04942  63.0873 246.3100 0853658 208.0404 147.2018 12.95078945504795
0 THORAD AGENA D DEB
1 04943U 70025GD  24187.59365293 -.00000005  00000-0  82746-4 0  9995
2 04943  99.6068 211.5640 0228415  28.7119  92.4031 13.10266014588519
0 THORAD AGENA D DEB
1 04945U 70025GF  24187.52571957  .00002466  00000-0  19789-2 0  9993
2 04945  99.8886 180.0574 0092490 203.9037 155.7810 13.89771401696105
0 THORAD AGENA D DEB
1 04946U 70025GG  24187.26337781  .00001552  00000-0  15157-2 0  9990
2 04946  99.6537 283.8148 0015382  50.8301  12.8304 13.80873530704629
0 THORAD AGENA D DEB
1 04948U 70025GJ  24187.59219374  .00001376  00000-0  19379-2 0  9999
2 04948  99.4589  59.5141 0208871 128.6909 296.7557 13.50202461642284
0 THORAD AGENA D DEB
1 04950U 70025GL  24187.38713145  .00000192  00000-0  59434-3 0  9996
2 04950  99.8364 124.3863 0219853 220.1217 265.8102 13.09960613590296
0 THORAD AGENA D DEB
1 04951U 70025GM  24187.43288784  .00000236  00000-0  37590-3 0  9997
2 04951 100.1019 145.5872 0018724  95.7243  22.3053 13.60722090686013
0 TANSEI 1 (MS-T1)
1 04952U 71011A   24187.25984838  .00000095  00000-0  38023-4 0  9993
2 04952  29.6693  22.1029 0079819 288.9378 235.2102 13.58567072651643
0 OPS 5268 (DMSP 5A F3)
1 04953U 71012A   24187.61304332  .00000470  00000-0  15773-3 0  9993
2 04953  98.5809  46.8202 0038638  43.6119 316.8112 14.41292285796244
0 THOR BURNER 2 R/B
1  4954U 71012B   24187.56224214  .00000358  00000-0  12906-3 0  9998
2  4954  98.4167  47.0127 0036249 207.5508 152.3759 14.39019293793913
0 COSMOS 397
1 04964U 71015A   24187.49416371  .00000031  00000-0  51782-4 0  9995
2 04964  65.7203 186.1545 1024648 162.8343 201.0220 12.74604337577531
0 THORAD AGENA D DEB
1 04968U 70025GN  24187.57952042  .00000335  00000-0  49607-3 0  9997
2 04968 100.1229 157.3636 0020111   1.9799  59.9378 13.62135786687504
0 THORAD AGENA D DEB
1 04970U 70025GQ  24187.30646824  .00000464  00000-0  69195-3 0  9996
2 04970  99.8734 133.1968 0035689 210.9065 305.9618 13.58970046677822
0 THORAD AGENA D DEB
1 04971U 70025GR  24187.54932434  .00000143  00000-0  58739-3 0  9994
2 04971  99.8589 180.6429 0340486 315.1781 170.0896 12.84275844536316
0 THORAD AGENA D DEB
1 04973U 70025GT  24187.13265945  .00001473  00000-0  94748-3 0  9994
2 04973 100.0219 248.1872 0094979 111.8629 249.2667 14.02771272740040
0 THORAD AGENA D DEB
1 04977U 70025GX  24187.30780944  .00000069  00000-0  17501-3 0  9990
2 04977 100.0578 306.3430 0019911 204.9467 211.0748 13.52243214673750
0 THORAD AGENA D DEB
1 04979U 70025GZ  24185.55623206  .00000221  00000-0  36293-3 0  9993
2 04979 100.1387  36.3444 0013622 100.6453 315.8094 13.59609303685051
0 THORAD AGENA D DEB
1 04980U 70025HA  24187.55830981  .00000413  00000-0  59663-3 0  9996
2 04980  99.3366  41.3562 0008170 160.9118 268.1814 13.61387406683367
0 THORAD AGENA D DEB
1 04982U 70025HC  24187.59353142  .00000184  00000-0  40354-3 0  9993
2 04982  99.5572 197.5085 0078724 226.5729 257.7953 13.40574574648138
0 THORAD AGENA D DEB
1 04986U 70025HG  24187.46581719  .00000077  00000-0  21131-3 0  9999
2 04986  99.8282  84.1323 0054537   9.4375 167.4166 13.42723666655096
0 THORAD AGENA D DEB
1 04987U 70025HH  24187.35664313  .00000078  00000-0  19124-3 0  9990
2 04987  99.5616 131.5577 0040017  91.6031  60.3608 13.48909654667097
0 THORAD AGENA D DEB
1 04988U 70025HJ  24187.45137154  .00000593  00000-0  77860-3 0  9993
2 04988  99.9592 148.1933 0014722 290.3036 193.8275 13.65918240686602
0 THORAD AGENA D DEB
1 04989U 70025HK  24187.56632567  .00002273  00000-0  25241-2 0  9996
2 04989  99.6508  45.7202 0123505 215.8113 199.7427 13.69468683663958
0 THORAD AGENA D DEB
1 04990U 70025HL  24187.11552706  .00003144  00000-0  21537-2 0  9997
2 04990 100.0076 250.8505 0058229 181.8961 178.1988 13.99648998720617
0 THORAD AGENA D DEB
1 04991U 70025HM  24187.40624279 -.00000011  00000-0  53444-4 0  9990
2 04991 100.1830 344.2947 0020895  32.1074  23.2505 13.53435404678204
0 THORAD AGENA D DEB
1 04992U 70025HN  24187.47901375  .00000199  00000-0  32682-3 0  9999
2 04992 100.1320   2.5522 0015112 331.7959  50.7524 13.60708284686389
0 THORAD AGENA D DEB
1 04993U 70025HP  24187.10554381  .00001185  00000-0  81898-3 0  9990
2 04993 100.1920 243.6538 0092099  89.7068 271.4646 13.99446576739539
0 THORAD AGENA D DEB
1 04996U 70025HS  24187.47243898  .00003455  00000-0  21468-2 0  9999
2 04996 100.3694 192.4980 0075586 184.0304 176.0258 14.04433516718025
0 THORAD AGENA D DEB
1 04997U 70025HT  24187.51837725  .00001387  00000-0  10058-2 0  9998
2 04997  99.9791  20.9862 0045912 261.3353  98.2604 13.97918819734960
0 THORAD AGENA D DEB
1 04998U 70025HU  24187.39948389  .00000004  00000-0  76032-4 0  9995
2 04998 100.0996 152.0219 0010051  32.0598 122.0588 13.52972876676983
0 THORAD AGENA D DEB
1 05000U 70025HW  24187.49081256  .00000628  00000-0  20417-2 0  9998
2 05000  99.7630 167.8211 0496311  53.8463  60.8396 12.69683735501301
0 COSMOS 397 DEB
1 05010U 71015D   24187.53737473  .00005705  00000-0  16500-2 0  9992
2 05010  65.8431 287.1824 0663878 255.5686  97.0854 13.61739330551495
0 COSMOS 397 DEB
1  5011U 71015E   24187.56040098  .00004720  00000-0  97666-3 0  9995
2  5011  65.6691 287.4228 0454725   7.3078 353.4336 14.12047033619645
0 COSMOS 397 DEB
1 05012U 71015F   24187.55673394  .00006228  00000-0  10883-2 0  9996
2 05012  65.7439 128.9585 0450737 217.4738 139.4129 14.18829014598425
0 COSMOS 397 DEB
1 05013U 71015G   24187.53091531  .00001619  00000-0  67232-3 0  9992
2 05013  65.8116 235.9060 0856073  55.5018 312.3871 13.13662544510855
0 COSMOS 397 DEB
1  5014U 71015H   24187.54191590  .00009111  00000-0  23509-2 0  9993
2  5014  65.5890 329.2875 0612835 221.0307 134.3102 13.75110505577765
0 COSMOS 397 DEB
1 05015U 71015J   24187.39833866  .00004724  00000-0  13779-2 0  9999
2 05015  65.7044 172.3596 0675591 294.4395  58.7626 13.59419164567691
0 COSMOS 397 DEB
1 05016U 71015K   24187.56966317  .00005312  00000-0  16662-2 0  9995
2 05016  65.8182   9.8572 0675572  63.9526 302.9472 13.56540142556293
0 COSMOS 397 DEB
1 05017U 71015L   24187.57880588  .00005115  00000-0  18120-2 0  9994
2 05017  65.7137 343.4359 0727772  89.5732 278.8601 13.42289510543785
0 COSMOS 397 DEB
1 05018U 71015M   24187.44344229  .00000136  00000-0  10253-3 0  9996
2 05018  65.7108 208.3381 0994255 136.6289 231.7488 12.80079917487979
0 COSMOS 397 DEB
1 05019U 71015N   24187.56468206  .00007032  00000-0  14313-2 0  9994
2 05019  65.6856 268.6732 0458328  16.2232 345.2975 14.11706521610812
0 COSMOS 374 DEB
1 05020U 70089W   24186.96508562  .00007001  00000-0  17497-2 0  9991
2 05020  62.9202  36.1303 0770819 101.2080 267.6516 13.46928964582527
0 THORAD AGENA D DEB
1 05024U 70025HY  24187.33356857  .00002577  00000-0  11604-2 0  9992
2 05024  99.8212  61.5317 0087376 322.6852  36.8272 14.21310618770713
0 THORAD AGENA D DEB
1 05025U 70025HZ  24187.62710515  .00000285  00000-0  51712-3 0  9999
2 05025 100.1569 233.3206 0043294 317.7628 162.5324 13.50293989663345
0 THORAD AGENA D DEB
1 05026U 70025JA  24187.50661256  .00001536  00000-0  16512-2 0  9992
2 05026 100.2343  33.6938 0036752  95.5583 325.7821 13.75060461686672
0 COSMOS 374 DEB *
1 05028U 70089Z   24187.39614422  .00000639  00000-0  71543-3 0  9993
2 05028  63.3142 196.8367 0637017 275.2471  77.6204 13.12724382513163
0 SCOUT A DEB
1  5036U 70067C   24187.21751547  .00002927  00000-0  12239-2 0  9997
2  5036  89.9236 256.4358 0025821 144.2974 215.9953 14.25760764755020
0 COSMOS 397 DEB
1 05042U 71015P   24187.34756277  .00005731  00000-0  14519-2 0  9996
2 05042  65.6093 183.1454 0623561 268.9823  83.9784 13.74125203553717
0 COSMOS 400
1 05050U 71020A   24187.29447043 -.00000085  00000-0 -53842-5 0  9997
2 05050  65.8239 143.4910 0006485 231.2894 235.0978 13.72176014670277
0 SL-8 R/B
1 05051U 71020B   24187.58445044 -.00000016  00000-0  66853-4 0  9997
2 05051  65.8149 256.9790 0040097  85.4508 275.1133 13.75990061675757
0 SL-8 DEB
1 05052U 71020C   24187.45030794 -.00000016  00000-0  69529-4 0  9999
2 05052  65.8211  86.4090 0008531 238.1900 297.0959 13.73521810671459
0 TITAN 34B AGENA D R/B
1 05054U 71021B   24186.88732301  .00000105  00000-0  00000-0 0  9994
2 05054  63.4300 131.2440 7044134 267.5119  17.5208  2.19924188 41441
0 THORAD AGENA D DEB
1 05060U 70025JE  24187.51634562  .00001289  00000-0  61620-3 0  9997
2 05060 100.0325 178.0541 0146886 305.5837  53.1717 14.15797641776766
0 THORAD AGENA D DEB
1 05063U 70025JH  24187.56705923  .00055289  00000-0  84235-2 0  9990
2 05063  99.8387 125.7420 0009727  10.2617 349.8782 14.73606052749985
0 THORAD AGENA D DEB
1 05066U 70025JL  24187.38925118  .00001686  00000-0  11388-2 0  9994
2 05066  99.8877 349.1775 0066578 249.3107 110.0909 14.00946217740871
0 THORAD AGENA D DEB
1 05067U 70025JM  24187.58706162  .00000428  00000-0  59279-3 0  9998
2 05067 100.0806  47.8787 0004878 235.3309 180.5227 13.64507464688241
0 COSMOS 374 DEB
1  5076U 70089AP  24187.21238975  .00001405  00000-0  51917-3 0  9997
2  5076  62.7888  49.9981 1027694 126.1220 243.9395 12.85946101504092
0 COSMOS 397 DEB
1 05088U 71015Q   24186.91442633  .00001932  00000-0  72617-3 0  9999
2 05088  65.7110  26.5271 0814055 218.8182 135.1617 13.25119588532433
0 COSMOS 397 DEB
1 05091U 71015S   24187.50458543  .00004986  00000-0  11740-2 0  9997
2 05091  65.7089 241.2685 0518362   5.3571 355.2752 13.95964199603639
0 COSMOS 397 DEB
1 05094U 71015U   24187.59082445  .00022263  00000-0  42448-2 0  9990
2 05094  65.6924  16.3385 0429781 165.3019 196.1038 14.18520905586983
0 COSMOS 397 DEB
1 05097U 71015W   24187.12161726  .00004464  00000-0  16656-2 0  9997
2 05097  65.7409  74.8246 0772325  64.1069 303.7503 13.32147970542141
0 COSMOS 397 DEB
1 05098U 71015X   24187.33310534  .00003846  00000-0  12951-2 0  9991
2 05098  65.8327 162.6137 0739145 302.7454  50.4413 13.42385550555272
0 COSMOS 397 DEB
1 05103U 71015AC  24181.04130900  .23670999  70100-5  21131-2 0  9994
2 05103  65.6772 185.8192 0011692 238.3523 121.6530 16.38455164696522
0 ISIS 2
1 05104U 71024A   24187.45010402  .00000038  00000-0  13702-3 0  9999
2 05104  88.1590  69.9711 0045422  81.6599  91.6480 12.67867623464551
0 COSMOS 402
1 05105U 71025A   24187.59662166 -.00000037  00000-0  53175-4 0  9995
2 05105  64.9810 257.1036 0035964 163.8057 301.5546 13.73117363670329
0 THOR DELTA 1 R/B
1 05106U 71024B   24187.58105167  .00000053  00000-0  21484-3 0  9991
2 05106  88.1601  66.9634 0044206   7.7590  56.1678 12.68868763466055
0 SL-3 R/B
1 05118U 71028B   24187.57711008  .00010135  00000-0  35228-3 0  9997
2 05118  81.2499  67.6041 0033153 265.1058  94.6393 15.29068247894252
0 M-4S R/B
1 05126U 71011B   24187.53490153  .00000154  00000-0  86000-4 0  9994
2 05126  29.6832 316.4568 0012151 193.0360 166.9904 13.76182780685615
0 THORAD AGENA D DEB
1 05129U 70025JN  24187.28651500  .00001778  00000-0  23935-2 0  9997
2 05129  99.3087 305.9778 0197321  85.8736 337.7882 13.53385307637185
0 COSMOS 397 DEB
1 05144U 71015AG  24187.11691389  .00014505  00000-0  33235-2 0  9991
2 05144  65.7140  90.2905 0506092  18.3121 343.5456 13.98518348598071
0 THORAD AGENA D DEB
1 05146U 70025JQ  24187.02068355  .00000141  00000-0  24157-3 0  9999
2 05146 100.0997  17.2368 0043271   2.1660 163.0971 13.62451996692317
0 THORAD AGENA D DEB
1 05149U 70025JS  24187.53492085  .00004334  00000-0  19367-2 0  9993
2 05149  99.6307 153.9171 0056096 348.6418  11.3487 14.22417912760158
0 THORAD AGENA D DEB
1 05150U 70025JT  24184.13774711  .00002223  00000-0  17490-2 0  9997
2 05150  99.5055 240.6138 0089098 220.1684 139.2865 13.91084576710643
0 THORAD AGENA D DEB
1 05151U 70025JU  24186.01218503  .00000601  00000-0  81103-3 0  9990
2 05151 100.1386  16.6774 0001990 136.8498  15.6926 13.64377848186489
0 THORAD AGENA D DEB
1 05153U 70025JW  24187.07531332  .00000504  00000-0  76888-3 0  9993
2 05153  99.9571 281.9378 0033644 223.3068 260.8212 13.57146726672578
0 COSMOS 397 DEB
1 05155U 71015AJ  24187.39967522  .00015959  00000-0  24537-2 0  9997
2 05155  65.3594 192.0458 0385959 310.7074  46.1071 14.34056099644598
0 COSMOS 397 DEB
1 05156U 71015AK  24187.18618651  .00007107  00000-0  19810-2 0  9995
2 05156  65.6856 101.7678 0670339 339.9151  17.6619 13.61787714568121
0 COSMOS 407
1 05174U 71035A   24187.61079972  .00000228  00000-0  91394-4 0  9998
2 05174  74.0455 332.0628 0018998 325.6514  34.3407 14.33770652778583
0 SL-8 R/B
1 05175U 71035B   24187.34159771  .00000479  00000-0  16357-3 0  9998
2 05175  74.0474 149.2096 0028306  79.4693 280.9648 14.38760353784853
0 COSMOS 409
1 05180U 71038A   24187.57921050  .00000219  00000-0  61242-3 0  9994
2 05180  74.0025   5.0290 0022566  29.3376  39.8363 13.17813475558506
0 SL-8 R/B
1 05181U 71038B   24187.56356841  .00000107  00000-0  30923-3 0  9992
2 05181  73.9985 224.1370 0056137 243.4364 226.3223 13.20728336563688
0 THORAD AGENA D DEB
1 05183U 70025JZ  24187.48702487  .00000924  00000-0  96918-3 0  9994
2 05183 100.0938  23.6823 0033003 318.2715 102.5103 13.77810280706585
0 THORAD AGENA D DEB
1 05185U 70025KB  24187.29396534  .00002876  00000-0  22086-2 0  9999
2 05185  99.6725 215.6892 0065144 340.1688  19.6939 13.93064009702531
0 COSMOS 397 DEB
1 05187U 71015AM  24187.42501490  .00005571  00000-0  16482-2 0  9993
2 05187  65.6484 201.0460 0617232  54.6775 311.0401 13.69405952574116
0 COSMOS 374 DEB
1 05188U 70089AZ  24185.96004897  .00000180  00000-0  27695-3 0  9990
2 05188  63.9942  33.3363 0915099 262.2962  87.3315 12.60232315782267
0 COSMOS 374 DEB *
1 05189U 70089BA  24187.50568960  .00212141  00000-0  31660-2 0  9997
2 05189  62.5561  64.6186 0054966 295.2201  64.3227 15.52317790190804
0 COSMOS 397 DEB
1 05192U 71015AP  24187.46961354  .00035597  00000-0  40728-2 0  9993
2 05192  65.5417  95.1165 0250424  32.8754 328.7649 14.65774963664894
0 COSMOS 397 DEB
1 05197U 71015AT  24187.42738246  .00001309  00000-0  48492-3 0  9997
2 05197  65.5369 317.2053 0735500 296.9513  55.8237 13.41309970538052
0 THORAD AGENA D DEB
1 05203U 70025KE  24187.46682086  .00000495  00000-0  12403-2 0  9996
2 05203  99.8818 255.7597 0218401 300.4117  71.0204 13.16755874589303
0 OPS 3811
1 05204U 71039A   24187.12946194  .00000006  00000-0  00000-0 0  9995
2 05204   1.6127 283.0265 0019068 356.1669 113.6874  0.98159103199247
0 COSMOS 411
1 05210U 71041A   24187.41006398 -.00000005  00000-0  61240-4 0  9997
2 05210  74.0128 176.0359 0112046   5.8658 147.8849 12.64976832454854
0 COSMOS 412
1 05211U 71041B   24187.60021277 -.00000017  00000-0 -15200-4 0  9991
2 05211  74.0173 312.4743 0034995  61.0645 312.0045 12.39868341645363
0 COSMOS 413
1 05212U 71041C   24187.56601525 -.00000029  00000-0 -92111-4 0  9996
2 05212  74.0148 123.2250 0021525 174.8132   0.2705 12.43837208413989
0 COSMOS 414
1 05213U 71041D   24187.62115494 -.00000025  00000-0 -60283-4 0  9990
2 05213  74.0148 133.1459 0042006  70.5731 101.4116 12.51130395428152
0 COSMOS 415
1 05214U 71041E   24187.60265092 -.00000015  00000-0  40555-5 0  9998
2 05214  74.0169 308.8404 0032221 297.2054  62.5712 12.47479356420947
0 COSMOS 416
1 05215U 71041F   24187.41578855 -.00000026  00000-0 -56706-4 0  9999
2 05215  74.0137 156.6682 0076890  37.9347  79.6535 12.58051905441273
0 COSMOS 417
1 05216U 71041G   24187.61330153 -.00000013  00000-0  23089-4 0  9992
2 05216  74.0167 350.3714 0095739 209.3262 220.8436 12.61433471448048
0 COSMOS 418
1 05217U 71041H   24187.54860135 -.00000027  00000-0 -66345-4 0  9991
2 05217  74.0171 326.4540 0060262 236.5135 195.7654 12.54562619434696
0 SL-8 R/B
1 05218U 71041J   24187.55176648 -.00000012  00000-0  19753-4 0  9996
2 05218  74.0303 331.4613 0066392  97.4351 331.1890 12.32208067607156
0 THORAD AGENA D DEB
1 05220U 70025KG  24187.35799272  .00000849  00000-0  23567-2 0  9995
2 05220  99.8425 133.1435 0391923 156.7556 356.8363 12.91425712539555
0 COSMOS 397 DEB
1 05222U 71015AW  24187.48711935  .00002315  00000-0  73377-3 0  9996
2 05222  65.7251 328.5671 0688692 266.3557  85.8549 13.54732460564519
0 SL-8 DEB
1 05225U 70102D   24187.27375272  .00000482  00000-0  40038-3 0  9993
2 05225  74.0228 258.1394 0017908   4.9836  53.8682 13.91334615708021
0 COSMOS 422
1 05238U 71046A   24187.62049307  .00000033  00000-0  60791-4 0  9992
2 05238  74.0196 269.8243 0014358  34.6830  68.6906 13.72203084659876
0 SL-8 R/B
1 05239U 71046B   24187.50186433  .00000158  00000-0  19207-3 0  9995
2 05239  74.0221 186.9148 0012007 281.6731 194.1202 13.73926477663005
0 COSMOS 374 DEB
1 05240U 70089BF  24187.59226730  .00002934  00000-0  24890-2 0  9994
2 05240  62.8649 322.3015 0874593 176.8084 183.9028 12.80339169460232
0 THOR ABLESTAR DEB
1 05265U 65065Q   24187.57698484  .00000252  00000-0  43050-3 0  9997
2 05265  90.1592 295.5804 0041492 220.6741 154.0765 13.42104501877158
0 COSMOS 397 DEB
1 05272U 71015BB  24187.42551671  .00001574  00000-0  54457-3 0  9998
2 05272  65.5552 199.2049 0761214 238.4301 114.0267 13.38658244550524
0 COSMOS 397 DEB
1 05277U 71015BE  24186.97876069  .00000369  00000-0  18546-3 0  9993
2 05277  65.7349  39.7110 0924108 240.9788 109.5614 12.99701057169317
0 COSMOS 397 DEB
1 05280U 71015BF  24187.23293836  .00001009  00000-0  36248-3 0  9993
2 05280  65.6598 127.8121 0762845 248.1980 103.6263 13.38169496547706
0 SL-8 DEB
1 05301U 71035D   24187.05686246  .00005365  00000-0  78362-3 0  9992
2 05301  74.0262 197.2960 0010213 210.7083 149.3495 14.75950662806334
0 COSMOS 252 DEB *
1 05322U 68097CJ  24187.42676838  .00004755  00000-0  32606-2 0  9998
2 05322  61.3189 168.0827 0719782  12.2097 349.5350 13.16710115619909
0 COSMOS 374 DEB
1 05337U 70089BS  24186.74358359  .00000458  00000-0  49871-3 0  9996
2 05337  62.9621  87.5514 0753130 270.1879  81.2917 12.96622953 57981
0 THORAD AGENA D DEB
1  5347U 70025KL  24187.57006623  .00000876  00000-0  80967-3 0  9998
2  5347  99.9658  48.8139 0043877 257.9813 157.5800 13.85203721658652
0 THORAD AGENA D DEB
1 05349U 70025KN  24187.37162696  .00005198  00000-0  28695-2 0  9992
2 05349  99.8152 341.8065 0061730 343.0614  16.8492 14.10974218648928
0 THORAD AGENA D DEB
1 05359U 70025KQ  24187.53844813  .00000804  00000-0  93537-3 0  9996
2 05359  99.9692 108.9228 0005850  57.2414 118.4850 13.72174804695665
0 THOR DELTA 1 DEB
1 05360U 71024C   24187.22816094  .00000014  00000-0  14431-4 0  9994
2 05360  88.2820 278.4328 0043453  59.1300 329.3744 12.67909762464426
0 OV1-5 DEB
1 05361U 66025F   24187.29037708  .00008270  00000-0  26373-2 0  9992
2 05361 144.6183 323.8384 0026663 331.5884  28.3360 14.36782028265590
0 OV1-20/OV1-21 DEB
1 05384U 71067N   24187.60846241  .00000339  00000-0  13462-3 0  9998
2 05384  87.6287 226.5716 0078013 227.6663 131.7904 14.24543581741891
0 THORAD AGENA D DEB
1 05388U 70025KT  24187.40190116  .00000816  00000-0  15617-2 0  9999
2 05388  99.8783 134.9882 0139078  81.6080  42.1756 13.37007831630676
0 THORAD AGENA D DEB
1 05389U 70025KU  24187.18170535  .00000008  00000-0  12011-3 0  9997
2 05389  99.8891 265.4668 0203909 151.7559 268.7437 13.11077871594117
0 THORAD AGENA D DEB
1 05390U 70025KV  24187.49702572  .00001165  00000-0  10691-2 0  9991
2 05390 100.0978 169.1964 0051335  14.6524 107.4006 13.84704679710598
0 THORAD AGENA D DEB
1  5392U 70025KX  24187.54240814  .00002452  00000-0  14656-2 0  9990
2  5392 100.0530  48.8365 0048632  42.3605 318.1299 14.07675363744513
0 OV1-20/OV1-21 AKM
1 05395U 71067K   24187.53128256  .00001426  00000-0  44155-3 0  9992
2 05395  87.6245 156.8901 0054615 257.0387 102.4710 14.39785013755079
0 OV1-21 R/B
1 05397U 71067B   24187.61045774  .00000169  00000-0  72429-4 0  9995
2 05397  87.6268 263.7967 0080150 309.8271  49.5881 14.17873265733605
0 RIGIDSPHERE 2 (LCS 4)
1 05398U 71067E   24187.50888246  .00001353  00000-0  45057-3 0  9995
2 05398  87.6278 176.1435 0063939  72.4029 288.4139 14.35842053771674
0 COSMOS 397 DEB *
1 05414U 71015BL  24187.31162415  .00000208  00000-0  18124-3 0  9992
2 05414  66.7682  30.0029 0080254  20.2783 340.1458 14.02518699725459
0 COSMOS 397 DEB *
1 05416U 71015BN  24187.53610920  .00001124  00000-0  11705-2 0  9992
2 05416  65.7874 331.2332 0074408 298.7685 132.0527 13.78234870194647
0 THORAD AGENA D DEB
1 05422U 70025LA  24187.10141069  .00005906  00000-0  21268-2 0  9992
2 05422 100.0043 240.3842 0087531 247.3437 111.8468 14.32033570754430
0 COSMOS 434 DEB
1 05426U 71069C   24186.92224899  .00006906  00000-0  92666-3 0  9999
2 05426  49.5305  80.8342 0067434  63.3567 297.4249 14.78682765781843
0 THORAD AGENA D DEB
1 05430U 69082HW  24186.30261293  .00001059  00000-0  52627-3 0  9994
2 05430  70.1066 159.3602 0061650 213.5451 146.1758 14.18721685812038
0 EOLE 1 (CAS-A)
1 05435U 71071A   24187.56292794  .00001920  00000-0  42710-3 0  9998
2 05435  50.1403 349.7921 0105796  98.3806 262.9133 14.57763155772072
0 SCOUT B-1 R/B
1 05438U 71071B   24187.35263135  .00001035  00000-0  23524-3 0  9994
2 05438  50.1450 159.0598 0102073 231.4778 127.6967 14.60651790774802
0 DELTA 1 DEB
1 05443U 67114E   24186.67162892 -.00000032  00000-0  67310-4 0  9994
2 05443 101.3019 156.5133 0062253 351.9189 183.1631 12.56773968597740
0 THORAD AGENA D DEB
1 05446U 70025LE  24186.34116003  .00001788  00000-0  19586-2 0  9997
2 05446 100.4560 337.6083 0084799 245.8785 142.2820 13.72491254677741
0 SCOUT A DEB
1 05447U 70067D   24186.60839699  .00000451  00000-0  80757-3 0  9991
2 05447  89.9314 246.2162 0305453 303.2954 226.0776 13.24482803593906
0 SHINSEI (MS-F2)
1 05485U 71080A   24187.60856812  .00000029  00000-0  27601-4 0  9997
2 05485  32.0554 302.0401 0639996  14.2284 347.5462 12.74198311458450
0 M-4S R/B
1  5498U 71080B   24187.50695005  .00000029  00000-0  13425-4 0  9994
2  5498  32.0327  47.3662 0574148 337.5592  20.0800 12.88432354485801
0 THORAD AGENA D DEB
1 05502U 70025LG  24187.62116659  .00047160  00000-0  48017-2 0  9994
2 05502  99.5243 317.8300 0006347  99.3763 260.8167 14.90519086754419
0 THORAD AGENA D DEB
1 05507U 70025LL  24187.39393598  .00006499  00000-0  27842-2 0  9995
2 05507  99.2832 171.8575 0027426 333.1760  26.7998 14.25000259749908
0 THORAD AGENA D DEB
1 05519U 69082HY  24187.38597732  .00001583  00000-0  50571-3 0  9999
2 05519  70.0535 174.1153 0047958 149.0700 211.3271 14.40760734848427
0 COSMOS 397 DEB *
1 05527U 71015BR  24187.29127840  .00003413  00000-0  19531-2 0  9990
2 05527  66.8950 275.1789 0073649 147.6961 212.8671 14.09296612689838
0 COSMOS 397 DEB *
1 05529U 71015BT  24187.12414751  .00002426  00000-0  82388-3 0  9998
2 05529  66.8444  86.5178 0062992 276.5546  82.8389 14.37167382756809
0 COSMOS 397 DEB *
1 05531U 71015BV  24187.52623526  .00002940  00000-0  10769-2 0  9991
2 05531  66.6652 277.6093 0036627 205.6935 154.2347 14.33863967750665
0 COSMOS 444
1 05547U 71086A   24187.53663551 -.00000028  00000-0 -66258-4 0  9992
2 05547  74.0300 338.6461 0119812  23.9799 336.6775 12.62117193429239
0 COSMOS 445
1 05548U 71086B   24187.41683256 -.00000017  00000-0 -28163-5 0  9996
2 05548  74.0262 168.8865 0103818 246.8891 229.3114 12.58209409421690
0 COSMOS 446
1 05549U 71086C   24187.58186974 -.00000017  00000-0 -82464-5 0  9994
2 05549  74.0298 351.3737 0083220  96.7396 264.3136 12.54442397414532
0 COSMOS 447
1 05550U 71086D   24187.42213502 -.00000011  00000-0  31832-4 0  9992
2 05550  74.0259 176.1462 0066581 314.0590 201.0460 12.50605847407214
0 COSMOS 448
1 05551U 71086E   24187.62708521 -.00000014  00000-0  81816-5 0  9996
2 05551  74.0297   0.5355 0048974 175.1135 253.5271 12.46746808399787
0 COSMOS 449
1 05552U 71086F   24187.63346919 -.00000003  00000-0  92073-4 0  9991
2 05552  74.0291  20.6625 0037557 303.7404 125.7409 12.38717818384370
0 COSMOS 450
1 05553U 71086G   24187.59490250  .00000000  00000-0  10735-3 0  9995
2 05553  74.0254 193.4760 0042214  60.3652  70.6055 12.42684237392003
0 COSMOS 451
1 05554U 71086H   24187.54408172  .00000012  00000-0  22022-3 0  9998
2 05554  74.0261 228.2169 0053310 202.4953 273.7829 12.34294175375874
0 SL-8 R/B
1 05555U 71086J   24187.49440494 -.00000084  00000-0 -60451-3 0  9995
2 05555  74.0161 203.4816 0076282 274.6619 195.5728 12.27000665361618
0 THOR BURNER 2 R/B
1 05556U 71087B   24187.54478357  .00000286  00000-0  14317-3 0  9994
2 05556  99.0126 123.9763 0063169  42.8625 317.7452 14.23507017733263
0 OPS 4311 (DMSP 5B F1)
1 05557U 71087A   24187.44764104  .00000349  00000-0  15812-3 0  9993
2 05557  99.0599 254.5529 0051258 166.3032 193.9552 14.27832817738846
0 ASTEX 1
1 05560U 71089A   24187.59279540  .00000817  00000-0  21358-3 0  9992
2 05560  92.7212 313.7856 0015679 359.0571   1.0602 14.49429354773597
0 PROSPERO (BLACK ARROW)
1  5580U 71093A   24187.53272470  .00002326  00000-0  50549-3 0  9999
2  5580  82.0381 194.0654 0517170 103.5073 262.4243 13.97928968650029
0 BLACK ARROW R/B
1 05581U 71093B   24187.60412854  .00001452  00000-0  32328-3 0  9994
2 05581  82.0384 227.6626 0518973 216.3817 140.1022 13.96759233647104
0 OPS 9431 (DSCS 2-1)
1 05587U 71095A   24187.53104516 -.00000073  00000-0  00000-0 0  9995
2 05587   3.4198 271.5412 0002967 299.5959 157.1106  1.00259739114885
0 OPS 9432 (DSCS 2-2)
1 05588U 71095B   24187.19164396  .00000114  00000-0  00000-0 0  9995
2 05588   3.3859 272.3316 0002101 112.4098 343.8507  1.00335730 40229
0 TITAN 3C TRANSTAGE R/B
1 05589U 71095C   24187.13546650 -.00000085  00000-0  00000-0 0  9995
2 05589   5.1722 282.0559 0168680 168.6678 335.7504  0.97187436112509
0 COSMOS 397 DEB *
1 05597U 71015CA  24187.33274603  .00022457  00000-0  31721-2 0  9996
2 05597  66.5648 154.4607 0026985 311.5629  48.3178 14.76903902767784
0 OV1-5 DEB
1 05599U 66025G   24187.33931830  .00011488  00000-0  27718-2 0  9998
2 05599 144.6245  12.5875 0043594 144.0711 216.2925 14.50279707999463
0 COSMOS 457
1 05614U 71099A   24187.61242625  .00000059  00000-0  20547-3 0  9997
2 05614  74.0364 356.0982 0022844  39.3671  29.6274 13.16087290527948
0 SL-8 R/B
1 05615U 71099B   24187.62473731  .00000177  00000-0  50451-3 0  9991
2 05615  74.0336 272.5208 0023169 285.6042 182.0819 13.17646310530960
0 TITAN 3C TRANSTAGE DEB
1 05632U 65108N   24186.31805526  .00015733  00000-0  16045-1 0  9993
2 05632  25.9691 230.2121 5714581 263.6580  32.0415  4.35068217311233
0 THORAD AGENA D DEB
1 05635U 69082JF  24187.00944197  .00004044  00000-0  13204-2 0  9994
2 05635  69.9451  41.5094 0001833  32.4151 327.7089 14.39274720765653
0 OPS 7898 (P/L 1)
1 05678U 71110A   24187.33213350  .00000003  00000-0  56044-4 0  9994
2 05678  69.9900  51.9530 0008690 338.9653  21.1083 13.74062495258993
0 THORAD AGENA D R/B
1 05679U 71110B   24187.37086135  .00000043  00000-0  82682-4 0  9999
2 05679  69.9974  55.0788 0014749 303.6696  56.2997 13.85524551270752
0 OPS 7898 (P/L 2)
1 05680U 71110C   24187.56872574  .00000025  00000-0  78833-4 0  9995
2 05680  69.9903  31.3794 0008966 327.0522  33.0012 13.74645547250411
0 OPS 7898 (P/L 3)
1 05681U 71110D   24187.55698753  .00000027  00000-0  81296-4 0  9999
2 05681  69.9896  34.1065 0009253 329.0685  30.9863 13.74536148259029
0 OPS 7898 (P/L 4)
1 05682U 71110E   24187.56268870  .00000027  00000-0  81599-4 0  9990
2 05682  69.9899  34.4286 0009233 328.6672  31.3871 13.74547417247381
0 COSMOS 465
1 05683U 71111A   24187.38579681  .00000034  00000-0  59804-4 0  9999
2 05683  74.0280  51.4082 0027829 321.5069 211.6743 13.74282884635554
0 SL-8 R/B
1 05685U 71111B   24187.57505616  .00000066  00000-0  89111-4 0  9998
2 05685  74.0290 291.8866 0022701 163.9544 207.0415 13.76997849639754
0 THORAD AGENA D DEB
1  5690U 70025LV  24187.22926111  .00000151  00000-0  30309-3 0  9995
2  5690 100.1688 173.8485 0049524  20.7054  46.7920 13.51300845670555
0 THORAD AGENA D DEB
1 05691U 70025LW  24187.17346354  .00002411  00000-0  15429-2 0  9991
2 05691  98.9419 259.3720 0038037  88.6150 271.9374 14.03990237729548
0 THORAD AGENA D DEB
1 05692U 70025LX  24186.87419156  .00000328  00000-0  52768-3 0  9992
2 05692  99.4706 235.5913 0113871 354.4796 181.0684 13.53702671467972
0 THORAD AGENA D DEB
1 05696U 70025MB  24187.57071431  .00000316  00000-0  51207-3 0  9998
2 05696  99.4683 303.8064 0056813 164.4182 209.3783 13.55304277670002
0 THORAD AGENA D DEB
1 05698U 70025MD  24187.44007036  .00000374  00000-0  56052-3 0  9993
2 05698  99.4203  54.0580 0007634 288.6589 195.4040 13.59695897493691
0 WESTFORD NEEDLES
1 05702U 63014CU  24186.34869367  .00000046  00000-0  46846-2 0  9995
2 05702  86.2453 170.8008 1692711 236.4582 106.3244  8.73626500364601
0 COSMOS 468
1 05705U 71114A   24187.27346300  .00000264  00000-0  99383-4 0  9996
2 05705  74.0184 111.2042 0015638 326.3560  33.6599 14.36226509748981
0 SL-8 R/B
1 05707U 71114B   24187.57698904  .00000492  00000-0  16498-3 0  9999
2 05707  74.0276  12.8962 0024465 174.0949 186.0499 14.39696911753023
0 INTELSAT 4-F3
1 05709U 71116A   24187.11623450 -.00000132  00000-0  00000-0 0  9998
2 05709   8.1139 297.5804 0011859 117.1858 267.2589  0.99626866111784
0 THOR ABLESTAR DEB
1 05715U 61015JS  24187.39664196  .00002012  00000-0  24691-2 0  9996
2 05715  66.5682 333.7262 0156170 146.0746 244.6112 13.62524569104689
0 THOR ABLESTAR DEB
1 05716U 61015JT  24186.39990719  .00002859  00000-0  60496-3 0  9992
2 05716  66.6982  60.0446 0078826 207.8272 151.8615 14.58876075256110
0 COSMOS 397 DEB *
1 05720U 71015CB  24187.24657738  .00000128  00000-0  12113-3 0  9994
2 05720  66.7265 245.2390 0097036 107.8118 253.3583 14.06126136661321
0 COSMOS 469
1 05721U 71117A   24187.30159109 -.00000051  00000-0  40192-4 0  9999
2 05721  64.4889  42.3662 0021201  45.9301 314.3492 13.76090118639164
0 AUREOLE 1
1 05729U 71119A   24187.58644648  .00005698  00000-0  40537-3 0  9999
2 05729  73.9535 248.2103 0751617 238.5677 113.9870 13.88767178542480
0 SL-8 R/B
1 05730U 71119B   24187.56147948  .00007598  00000-0  44041-3 0  9995
2 05730  73.8917 227.5024 0613808 318.8126  36.8188 14.22095742567940
0 METEOR 1-10
1 05731U 71120A   24187.59160540  .00000040  00000-0  15251-4 0  9991
2 05731  81.2594 353.8708 0022708 278.0093  81.8502 14.11693766695704
0 SL-3 R/B
1 05732U 71120B   24187.44517151  .00000338  00000-0  19556-3 0  9991
2 05732  81.2518 155.2456 0051472   2.8453 357.2998 14.06219743692662
0 THORAD AGENA D DEB
1 05736U 70025MH  24187.29521606  .00000279  00000-0  78466-3 0  9990
2 05736 101.3724 115.5851 0230927 359.3977 151.6085 13.13927256599539
0 THOR ABLESTAR DEB
1 05745U 61015JU  24187.46776187  .00008746  00000-0  30147-2 0  9994
2 05745  67.0682 210.2568 0090971 269.1133  89.9546 14.33934866163623
0 THOR ABLESTAR DEB
1 05746U 61015JV  24186.44985954  .00002272  00000-0  12375-2 0  9997
2 05746  66.3017 229.6190 0037953 133.7801 226.6436 14.13682033181343
0 THOR ABLESTAR DEB
1 05748U 61015JX  24187.48926348  .00000816  00000-0  99873-3 0  9997
2 05748  67.5570 260.9817 0136257 266.1135 106.7124 13.66467090 57349
0 THORAD AGENA D DEB
1 05755U 69082JP  24187.35116274  .00003776  00000-0  11611-2 0  9993
2 05755  69.9279 152.7968 0009161 292.9741  67.0421 14.42253212831744
0 THORAD AGENA D DEB
1 05758U 69082JS  24187.44714979  .00000037  00000-0  84006-4 0  9999
2 05758  69.8049 197.5273 0043637 146.7307   2.1428 13.80823886765213
0 COSMOS 397 DEB *
1 05763U 71015CF  24187.05164061  .00002430  00000-0  32153-2 0  9995
2 05763  66.9027  63.2896 0370046   2.4914 357.7869 13.37401023557474
0 INTELSAT 4-F4
1 05775U 72003A   24187.46130677  .00000116  00000-0  00000-0 0  9990
2 05775   8.4161 300.6820 0004634 153.5436 203.0624  0.99831331130287
0 SL-8 DEB
1 05778U 71114C   24187.44841594  .00007869  00000-0  99831-3 0  9995
2 05778  74.0099 334.7731 0006379 228.8507 131.2120 14.81840731793290
0 THOR ABLESTAR DEB
1 05785U 61015JZ  24187.31575524  .00000484  00000-0  47332-3 0  9990
2 05785  65.6412  34.4433 0148819 297.7818  60.8227 13.83454219187488
0 THOR ABLESTAR DEB
1 05786U 61015KA  24187.61036879  .00000687  00000-0  48249-3 0  9992
2 05786  67.1205 264.2583 0126836 336.6469  22.8885 14.00092422174854
0 THORAD AGENA D DEB
1 05794U 69082JW  24187.55503432  .00004144  00000-0  95634-3 0  9992
2 05794  70.0023 117.9498 0028753 135.0102 225.3372 14.55687474288491
0 THOR ABLESTAR DEB
1  5808U 61015KC  24186.49650838  .00070043  00000-0  21667-2 0  9996
2  5808  66.5761 326.5736 0036797 239.7691 119.9813 15.32426150298409
0 ATLAS CENTAUR R/B
1 05816U 72003B   24186.42853865  .00000185  00000-0  12753-2 0  9998
2 05816  27.6175 188.9077 7221368 244.5178 348.8751  2.20946966422592
0 THORAD AGENA D DEB *
1 05824U 70025MJ  24186.86513764  .00000774  00000-0  63628-3 0  9990
2 05824  97.8737  39.3020 0604998 299.2183  54.9736 13.28989800582253
0 THOR ABLESTAR DEB
1 05826U 61015KE  24187.35457345  .00000679  00000-0  54291-3 0  9998
2 05826  66.6803 277.5446 0073484  19.5118 340.8748 13.95730269171309
0 THORAD AGENA D DEB
1 05842U 70025ML  24187.44429555  .00128521  00000-0  70515-2 0  9992
2 05842  99.9847 254.1961 0011473 121.3462 238.8885 15.13490914796168
0 COSMOS 475
1  5846U 72009A   24187.57264948  .00000071  00000-0  96161-4 0  9993
2  5846  74.0475 232.8064 0023645 298.6590 172.6445 13.76311003629434
0 SL-8 R/B
1 05847U 72009B   24187.45478556  .00000066  00000-0  85618-4 0  9992
2 05847  74.0494  78.3293 0030078 156.2399  16.2631 13.79331874634849
0 OPS 1570
1 05851U 72010A   24187.18859816 -.00000087  00000-0  00000-0 0  9993
2 05851   1.4608 271.0625 0006161 351.7226  89.1513  0.99783255 18827
0 TITAN 3C TRANSTAGE R/B
1 05854U 72010B   24186.46420638 -.00000227  00000-0  00000-0 0  9998
2 05854   0.9402 265.6768 0063628 153.9188 301.0208  1.00676568 17730
0 SL-8 DEB
1 05858U 71114D   24187.39083059  .00010733  00000-0  11121-2 0  9991
2 05858  74.0032 172.9849 0002109  89.3609 270.7814 14.90099540798274
0 COSMOS 252 DEB *
1 05871U 68097DK  24186.80773034  .00001347  00000-0  46258-3 0  9997
2 05871  62.8078 323.3274 0942046 138.4908 229.1688 13.05305790620531
0 THOR ABLESTAR DEB
1 05876U 61015KF  24187.48092041  .00000656  00000-0  18479-2 0  9997
2 05876  65.6734 291.8053 0723170 174.8899 186.0023 12.48523119 76237
0 OPS 5058 (DMSP 5B F2)
1 05903U 72018A   24187.42061157  .00000252  00000-0  12669-3 0  9999
2 05903  99.0805 343.0384 0050507 338.8378  21.0710 14.24826352788823
0 THOR BURNER 2 R/B
1 05904U 72018B   24187.36107223  .00000184  00000-0  99633-4 0  9999
2 05904  99.0228 327.9398 0046395 302.1304  57.5376 14.23980825711533
0 COSMOS 480
1 05905U 72019A   24187.61554170  .00000044  00000-0  76623-4 0  9995
2 05905  82.9741  51.2319 0019517  45.6600  13.9079 13.19905011518235
0 SL-8 R/B
1 05907U 72019B   24187.55898771  .00000069  00000-0  13336-3 0  9996
2 05907  82.9713 359.1756 0019931 225.2206 195.7583 13.22402137522250
0 METEOR 1-11
1 05917U 72022A   24187.59788603  .00000266  00000-0  14574-3 0  9991
2 05917  81.2209 258.2784 0029255 174.0885 186.0636 14.08965509684227
0 SL-3 R/B
1 05918U 72022B   24187.58135603  .00000198  00000-0  11211-3 0  9996
2 05918  81.2384 354.2986 0057472 289.7694  69.7283 14.06097851679602
0 TIROS 2 DEB *
1 05922U 60016E   24187.42756185 -.00000056  00000-0  83937-4 0  9997
2 05922  47.0292 178.5150 0039772  64.4537  94.6928 13.69916675653856
0 THORAD AGENA D DEB
1  5957U 70025MN  24187.54143079  .00020153  00000-0  49609-2 0  9996
2  5957  99.6415 199.1178 0020117 336.7960  23.2320 14.52131254 68681
0 THORAD AGENA D DEB
1 05958U 70025MP  24187.28537572  .00000743  00000-0  99133-3 0  9994
2 05958  99.5151  98.3797 0052216 128.9018 355.7568 13.63193917678156
0 THORAD AGENA D DEB *
1 05967U 70025MQ  24187.49786192  .00000950  00000-0  35800-2 0  9991
2 05967 101.6640  30.5419 0122463 301.7882 128.3098 12.92322838546473
0 DELTA 1 DEB
1 05971U 67006E   24187.47791848 -.00000027  00000-0  10435-3 0  9997
2 05971 101.9277  90.4755 0112616 303.9163 231.7898 12.73443796670493
0 DELTA 1 DEB
1 05975U 70021C   24187.51139128  .00003305  00000-0  14856-2 0  9995
2 05975  25.5346 281.3235 6559910  40.7943 353.0583  3.20698906349814
0 DELTA 1 R/B(2)
1 05977U 69011B   24187.04702612  .00005199  00000-0  16330-2 0  9998
2 05977  29.5808 109.8813 5570397 154.9009 248.0469  4.66409433469142
0 TITAN 3C TRANSTAGE DEB
1 05986U 65108Q   24185.38273826  .00002182  00000-0  34408-2 0  9991
2 05986  26.6660 123.0218 6223167 186.1966 159.3897  3.59610585270796
0 DELTA 1 DEB *
1 05987U 67001S   24187.21912033  .00000658  00000-0  21377-2 0  9997
2 05987  26.2343 115.3336 6722636  96.0270 338.0621  2.87755204358187
0 TITAN 3C TRANSTAGE DEB
1 05991U 65108R   24186.39944341 -.00000108  00000-0  00000-0 0  9992
2 05991  27.4449 155.9938 6520615 166.5182   1.6994  2.63549094 98615
0 THORAD AGENA D DEB
1 06014U 70025MR  24187.04499173  .00003043  00000-0  20752-2 0  9992
2 06014 100.0312 228.8685 0052755 252.9618 106.5758 14.00091927719176
0 COSMOS 489
1 06019U 72035A   24187.45308906  .00000039  00000-0  63409-4 0  9998
2 06019  74.0205  70.4734 0024192 164.9494   7.8352 13.76051803618976
0 SL-8 R/B
1 06020U 72035B   24187.59573525  .00000050  00000-0  71308-4 0  9996
2 06020  74.0229 290.3537 0020305  49.5569 321.8449 13.79008528623893
0 INTELSAT 4-F5
1 06052U 72041A   24187.40281704  .00000103  00000-0  00000-0 0  9999
2 06052   7.4791 294.0379 0003918 229.7772 130.3763  1.00099367 39532
0 ATLAS CENTAUR R/B
1 06058U 72041B   24186.80967851 -.00000027  00000-0  19493-2 0  9996
2 06058  26.4332 113.8046 7183858  57.8558 352.1040  2.22442252421537
0 COSMOS 494
1 06059U 72043A   24187.60811491  .00000243  00000-0  92622-4 0  9992
2 06059  74.0566 307.3711 0011296 263.0139  96.9729 14.36064967721979
0 SL-8 R/B
1 06061U 72043B   24187.48376175  .00000424  00000-0  13898-3 0  9994
2 06061  74.0562 102.2838 0020548 303.7416  56.1781 14.41359097728903
0 SL-8 DEB
1 06063U 72043C   24187.40619902  .00025708  00000-0  14426-2 0  9995
2 06063  74.0298  63.4113 0004507 190.0286 170.0818 15.13249027764957
0 SL-8 DEB
1 06065U 72043D   24187.36328986  .00007947  00000-0  97182-3 0  9997
2 06065  74.0634 179.7609 0008207  47.7652 312.4221 14.83362857751544
0 COSMOS 482 DESCENT CRAFT
1 06073U 72023E   24187.56977842  .00113272  87851-5  18719-3 0  9999
2 06073  51.9935 264.4085 0679233 120.0460 246.9651 14.68997659704358
0 METEOR 1-12
1 06079U 72049A   24187.62254310  .00000089  00000-0  48888-4 0  9996
2 06079  81.2286 313.7516 0009825 306.8580  53.1685 14.03354929661293
0 SL-3 R/B
1 06080U 72049B   24187.61274840  .00000163  00000-0  99573-4 0  9997
2 06080  81.2386  35.8801 0047952 249.3701 110.2319 14.01119284657547
0 COSMOS 504
1 06117U 72057A   24187.59116260  .00000009  00000-0  13596-3 0  9994
2 06117  74.0277 273.7876 0111996   2.9717 102.7075 12.63604210396710
0 COSMOS 505
1 06118U 72057B   24187.51356212 -.00000005  00000-0  66532-4 0  9996
2 06118  74.0279  96.5672 0092836 214.9244 319.0259 12.59801395389446
0 COSMOS 506
1 06119U 72057C   24187.58208153  .00000011  00000-0  15936-3 0  9991
2 06119  74.0274 269.1341 0072579  49.3618  59.1687 12.56187520382657
0 COSMOS 507
1 06120U 72057D   24187.48250569  .00000004  00000-0  12538-3 0  9997
2 06120  74.0281  78.4055 0054488 241.9437 292.0912 12.52637985375830
0 COSMOS 508
1  6121U 72057E   24187.57137873  .00000014  00000-0  19573-3 0  9997
2  6121  74.0265 255.1745 0033296  82.5178  27.4555 12.48884744369049
0 COSMOS 509
1 06122U 72057F   24187.48763021  .00000002  00000-0  12551-3 0  9994
2 06122  74.0280  78.7362 0015981 316.4491 218.2715 12.44980536361412
0 COSMOS 510
1 06123U 72057G   24187.55897233  .00000014  00000-0  21975-3 0  9999
2 06123  74.0273 261.7180 0009509 286.3715 179.4237 12.41058809354022
0 COSMOS 511
1 06124U 72057H   24187.54676606 -.00000007  00000-0  63194-4 0  9991
2 06124  74.0278  95.8057 0031531 155.2815  18.8573 12.36867108346127
0 SL-8 R/B
1 06125U 72057J   24187.57634774 -.00000069  00000-0 -44998-3 0  9994
2 06125  74.0150   0.9986 0068936 154.1978 277.3923 12.30973398334460
0 LANDSAT 1 (ERTS 1)
1 06126U 72058A   24187.59550991  .00000228  00000-0  19408-3 0  9999
2 06126  99.3742 192.4541 0008796  37.6204 322.5572 13.97709788648541
0 DELTA 1 R/B
1  6127U 72058B   24187.52135380  .00003591  00000-0  43897-3 0  9999
2  6127  98.4956 354.9548 0095426  61.0919 299.9823 14.80742151 84624
0 THORAD AGENA D DEB
1 06139U 70025MV  24187.11484258  .00001973  00000-0  13900-2 0  9993
2 06139  98.9646  66.6304 0070274 145.2699 215.3082 13.98003467729341
0 COSMOS 514
1 06148U 72062A   24187.53268388  .00000079  00000-0  58764-4 0  9991
2 06148  82.9678 107.7025 0010220   7.0199 166.3127 13.81932899615241
0 SL-8 R/B
1 06149U 72062B   24187.47041325  .00000107  00000-0  83951-4 0  9993
2 06149  82.9694  84.4008 0007334 236.5911 123.4549 13.83080668617205
0 OAO 3 (COPERNICUS)
1 06153U 72065A   24187.38310108  .00000518  00000-0  11302-3 0  9995
2 06153  35.0043 183.5969 0007097 199.6685 305.3828 14.58966124756687
0 COSMOS 516
1 06154U 72066A   24187.51262194 -.00000033  00000-0  54083-4 0  9990
2 06154  64.8085 227.0523 0088059 294.3221  64.8658 13.77748787609879
0 ATLAS CENTAUR R/B
1 06155U 72065B   24187.55394042  .00001756  00000-0  26007-3 0  9998
2 06155  35.0032 285.8683 0035801 268.3454  91.3144 14.74578424750742
0 THORAD AGENA D DEB
1 06157U 70025MX  24187.20045168  .00007683  00000-0  41515-2 0  9993
2 06157  99.8760 281.1029 0012966 180.5850 179.5306 14.12858311745005
0 THORAD AGENA D DEB *
1 06159U 70025MY  24175.32330627  .00001517  00000-0  60666-2 0  9990
2 06159 101.2305 301.3855 0056741 288.9319 129.9644 12.88482739562430
0 THORAD AGENA D DEB
1 06167U 70025NB  24187.53781627  .00000655  00000-0  82740-3 0  9995
2 06167 100.0875 162.0360 0031746 326.7058 147.8054 13.67867652698017
0 TRIAD 1
1 06173U 72069A   24187.62965866  .00000885  00000-0  21840-3 0  9990
2 06173  89.9808 208.4326 0049235 313.7743 169.2708 14.50782379727327
0 COSMOS 249 DEB *
1 06176U 68091CG  24187.50669503 -.00000422  00000-0 -61084-3 0  9992
2 06176  65.7280   6.7856 0470919 339.0746  19.1555 13.07792678 66091
0 SCOUT B-1 R/B
1 06180U 72069B   24187.56595004  .00002545  00000-0  41932-3 0  9993
2 06180  90.0248 216.1237 0039231 145.0078 215.3730 14.69779627722926
0 COSMOS 520
1 06192U 72072A   24187.57325522  .00000064  00000-0  00000-0 0  9999
2 06192  71.8826 251.3198 4622672 206.5282  71.4847  2.01326961380850
0 COSMOS 521
1 06206U 72074A   24187.56663115 -.00000043  00000-0  40770-4 0  9999
2 06206  65.8265 233.9493 0006633 354.5037 116.3969 13.72481160593955
0 SL-8 R/B
1 06207U 72074B   24187.61014292 -.00000008  00000-0  75008-4 0  9995
2 06207  65.8241  28.7753 0031017 291.1367 134.4628 13.75864174598732
0 SL-8 DEB
1 06210U 72074C   24187.45084331 -.00000015  00000-0  70491-4 0  9991
2 06210  65.8231 198.2978 0005176  18.4123  91.4610 13.73531583594747
0 DELTA 1 DEB *
1 06213U 66087E   24187.55032601  .00003557  00000-0  89343-2 0  9992
2 06213 101.8524 108.1386 0061855   0.8454 175.0508 13.19611963702238
0 DELTA 1 DEB
1 06214U 66016E   24187.49944042  .00000147  00000-0  10383-2 0  9999
2 06214 101.7045 171.6103 0121597 119.1460   6.7196 12.62542572685092
0 MIDAS 3 DEB
1 06215U 61018E   24186.95670157  .00000005  00000-0  14596-2 0  9993
2 06215  91.0980 173.1427 0060125 294.3531  65.1073  8.90940464316487
0 THORAD AGENA D DEB
1 06216U 70025NE  24187.56597808  .00002404  00000-0  63547-3 0  9997
2 06216  99.0831  40.2457 0229295   7.4605 352.9896 14.35446950773763
0 OPS 8180 (STP RADSAT)
1 06217U 72076B   24187.43707426  .00001134  00000-0  20414-3 0  9996
2 06217  98.5621 121.6895 0010955  95.3517 264.8937 14.68651988734213
0 ATLAS F BURNER 2 R/B
1 06218U 72076C   24187.13969660  .00000310  00000-0  81410-4 0  9993
2 06218  98.5942 244.1103 0010695 313.3609  46.6696 14.56078572742800
0 NOAA 2 (ITOS-D)
1 06235U 72082A   24187.61418990 -.00000024  00000-0  14170-3 0  9998
2 06235 102.0148 186.7984 0004525  85.9550  22.9890 12.53182005365815
0 OSCAR 6
1 06236U 72082B   24187.57525147 -.00000030  00000-0  10643-3 0  9995
2 06236 102.0186 191.9521 0004662  68.1124  52.5113 12.53189453365827
0 DELTA 1 R/B
1 06237U 72082C   24187.57011543 -.00000026  00000-0  60862-4 0  9990
2 06237 102.8070 220.8398 0361945  88.3473  26.6483 13.18649996488646
0 SL-8 DEB *
1 06252U 65020FD  24187.19363545 -.00000079  00000-0  99345-4 0  9997
2 06252  56.0375 108.5346 0195646  66.8308  77.8166 12.30027293577476
0 METEOR 1-13
1 06256U 72085A   24187.55523873  .00000202  00000-0  10856-3 0  9998
2 06256  81.2732 122.5929 0027260   5.5527 354.5940 14.09212976654630
0 SL-3 R/B
1 06257U 72085B   24187.49773666  .00000036  00000-0  13662-4 0  9993
2 06257  81.2581 191.4044 0058453  82.2137 278.5664 14.06674717651236
0 COSMOS 528
1 06262U 72087A   24187.59387196  .00000005  00000-0  12323-3 0  9999
2 06262  74.0358  26.9360 0065545 262.0913 153.7487 12.61595546380043
0 COSMOS 529
1 06264U 72087B   24187.59895525  .00000020  00000-0  21263-3 0  9991
2 06264  74.0330 235.3573 0041606 142.2541 333.5363 12.57195625371562
0 COSMOS 530
1 06265U 72087C   24187.52448522 -.00000001  00000-0  80008-4 0  9999
2 06265  74.0324 193.0226 0086447  42.1879  77.4523 12.65655860387543
0 COSMOS 531
1 06266U 72087D   24187.62039741 -.00000017  00000-0 -36061-5 0  9999
2 06266  74.0367 349.1027 0031362 282.8650 151.9002 12.54786458367016
0 COSMOS 532
1 06267U 72087E   24187.57641715 -.00000009  00000-0  38600-4 0  9994
2 06267  74.0363 357.5790 0107944 178.6920 252.3662 12.69719072394972
0 COSMOS 533
1 06268U 72087F   24187.49928022 -.00000016  00000-0  64229-5 0  9990
2 06268  74.0353  99.9093 0098004 298.4998 235.9169 12.67590666391113
0 COSMOS 534
1 06269U 72087G   24187.57960909 -.00000002  00000-0  78632-4 0  9997
2 06269  74.0361 288.5466 0076044 152.0050 220.0693 12.63656488383745
0 COSMOS 535
1 06270U 72087H   24187.57745767 -.00000020  00000-0 -21073-4 0  9990
2 06270  74.0345 134.2500 0053984  29.8553 143.6841 12.59334008375441
0 SL-8 R/B
1 06271U 72087J   24187.51068605 -.00000085  00000-0 -55846-3 0  9999
2 06271  74.0385 212.3576 0079424  52.6780 101.2560 12.34545239328775
0 OPS 7323 (DMSP 5B F3)
1 06275U 72089A   24187.49141191  .00000511  00000-0  21806-3 0  9995
2 06275  98.4713   0.3952 0034083 255.7130 104.0266 14.28908325682999
0 THOR BURNER 2 R/B
1 06276U 72089B   24187.48764850  .00000186  00000-0  10332-3 0  9998
2 06276  98.5350   2.3664 0036201 353.6289   6.4423 14.21701577675228
0 SL-8 DEB
1 06277U 72062C   24187.55712413  .00000066  00000-0  46403-4 0  9992
2 06277  82.8542 199.0606 0006705  34.2954  90.6842 13.83396779607096
0 ANIK A1 (TELESAT 1)
1 06278U 72090A   24187.51826677 -.00000104  00000-0  00000-0 0  9991
2 06278   7.9114 298.8160 0018233 178.7329 100.8149  0.98826739112015
0 SCOUT B-1 DEB
1 06284U 72069D   24187.55612509  .00004437  00000-0  76259-3 0  9999
2 06284  90.4916 307.6963 0042445 175.0495 185.1151 14.67972056643681
0 SL-8 DEB
1 06289U 69024C   24187.61254616  .00000518  00000-0  11939-2 0  9998
2 06289  73.9892 311.8996 0007076 249.8986 124.9535 13.27674903671058
0 SL-6 R/B(2)
1 06302U 72072E   24186.50343874 -.00000555  00000-0  00000-0 0  9990
2 06302  70.0755 342.3414 5582447 286.6297  21.2640  2.03789669218155
0 NIMBUS 5
1 06305U 72097A   24187.60875282 -.00000009  00000-0  59788-4 0  9990
2 06305  99.8615  91.7033 0009219  89.1364 336.2157 13.44201600529126
0 DELTA 1 R/B
1 06306U 72097B   24187.61290685 -.00000059  00000-0 -74891-4 0  9998
2 06306  99.8244 311.3761 0270135  36.9278 335.9089 12.88459514424653
0 OPS 9390
1 06317U 72101A   24187.13337796 -.00000039  00000-0  00000-0 0  9992
2 06317  10.6529 252.1451 1283752  82.1513  65.0463  1.00158589 18370
0 ATLAS AGENA R/B
1 06318U 72101B   24186.61856530 -.00000283  00000-0  00000-0 0  9998
2 06318  10.0435 241.7085 1184502 155.3261 210.9578  1.02316210 20037
0 COSMOS 539
1 06319U 72102A   24187.43023742 -.00000005  00000-0  57718-4 0  9996
2 06319  74.0147 181.1334 0023427 140.5724  13.7159 12.75412227399422
0 SL-8 R/B
1 06320U 72102B   24187.55662979 -.00000022  00000-0 -21136-4 0  9997
2 06320  74.0149 103.4877 0023890  40.0768 133.0901 12.76986227402356
0 COSMOS 540
1 06323U 72104A   24187.62406207  .00000300  00000-0  10988-3 0  9999
2 06323  74.0819 325.1519 0017100 114.4315 245.8624 14.36984322696788
0 SL-8 R/B
1 06324U 72104B   24187.59289334  .00000465  00000-0  14254-3 0  9998
2 06324  74.0778  11.4298 0009383 211.0125 149.0479 14.44398928706942
0 COSMOS 546
1 06350U 73005A   24187.35083145  .00003374  00000-0  14673-3 0  9991
2 06350  50.6384  48.0720 0014892  30.1953 329.9867 15.24931069834388
0 OPS 6063
1 06380U 73013A   24187.24077137 -.00000102  00000-0  00000-0 0  9998
2 06380   2.1691 271.2451 0024093 233.9752 301.7869  1.00271033 19280
0 METEOR 1-14
1 06392U 73015A   24187.56183246  .00000045  00000-0  18633-4 0  9997
2 06392  81.2342 259.1515 0053193  47.7294 312.8368 14.07841301632555
0 SL-3 R/B
1 06393U 73015B   24187.53618876  .00000137  00000-0  76336-4 0  9993
2 06393  81.2564 345.6162 0057906 240.6577 118.8799 14.05234736628378
0 SL-8 DEB
1 06396U 72104D   24187.43020196  .00025415  00000-0  13587-2 0  9998
2 06396  74.1015 200.8319 0010581 244.1531 115.8574 15.14939980745244
0 ANIK A2 (TELESAT 2)
1 06437U 73023A   24187.55084913 -.00000280  00000-0  00000-0 0  9993
2 06437   8.5824 302.0194 0009505  77.7950 251.2454  0.99806011 40047
0 METEOR 1-15
1 06659U 73034A   24187.58548027  .00000101  00000-0  49784-4 0  9992
2 06659  81.1871 223.5218 0026737 256.2063 103.6132 14.10265956627118
0 SL-3 R/B
1 06660U 73034B   24187.58997008  .00000184  00000-0  10343-3 0  9990
2 06660  81.2299  32.2290 0047603  53.8453 306.7106 14.06068382619992
0 COSMOS 564
1  6675U 73037A   24187.56598508  .00000022  00000-0  23135-3 0  9993
2  6675  74.0169 235.2324 0055172 192.8658 280.0665 12.56591615343078
0 COSMOS 565
1 06676U 73037B   24187.59147414  .00000017  00000-0  21799-3 0  9991
2 06676  74.0166 230.2222 0026578 278.1050 200.1491 12.48953356328663
0 COSMOS 566
1 06677U 73037C   24187.49565081 -.00000013  00000-0  16361-4 0  9992
2 06677  74.0188 103.8228 0031055 107.2789  66.2144 12.51686674333411
0 COSMOS 567
1 06678U 73037D   24187.55726863 -.00000020  00000-0 -20706-4 0  9994
2 06678  74.0200 351.9228 0045444 336.1192  90.4343 12.54088739338114
0 COSMOS 568
1 06679U 73037E   24187.57140478 -.00000026  00000-0 -56280-4 0  9991
2 06679  74.0181 125.2869 0066847  67.1670 105.4197 12.58933706347209
0 COSMOS 569
1 06680U 73037F   24187.59552395  .00000002  00000-0  10816-3 0  9996
2 06680  74.0195  20.5483 0079256 305.5767 110.4506 12.61158056351351
0 COSMOS 570
1 06681U 73037G   24187.58835416  .00000016  00000-0  17654-3 0  9996
2 06681  74.0186 269.3218 0092022 180.5205 285.5643 12.63512156355767
0 COSMOS 571
1 06682U 73037H   24187.36794485 -.00000021  00000-0 -22676-4 0  9992
2 06682  74.0170 156.3153 0102269  46.6831 106.5676 12.65904202360219
0 SL-8 R/B
1 06683U 73037J   24187.60624706  .00000001  00000-0  12943-3 0  9999
2 06683  74.0210 277.6616 0070756 168.8467 295.6016 12.32112687297368
0 OPS 6157
1 06691U 73040A   24187.13320392 -.00000049  00000-0  00000-0 0  9995
2 06691   2.5998 262.0040 0003842  11.4818 139.7115  0.99811911 18837
0 COSMOS 574
1 06707U 73042A   24187.60917803  .00000073  00000-0  63328-4 0  9998
2 06707  82.9501 357.9804 0022597  66.1122   6.4731 13.72312977993088
0 SL-8 R/B
1 06708U 73042B   24187.50561588  .00000110  00000-0  10029-3 0  9994
2 06708  82.9469 314.3038 0011782 247.2094 182.2558 13.74421322558255
0 THOR ABLESTAR DEB
1 06747U 61015KM  24186.91297828  .00000659  00000-0  50944-3 0  9999
2 06747  66.6002 111.7307 0146474 317.5195  41.4621 13.94115995192246
0 THOR ABLESTAR DEB
1 06748U 61015KN  24187.55887366  .00007285  00000-0  32025-2 0  9994
2 06748  66.8991   7.7382 0059382 126.8592 233.7969 14.23037916188869
0 COSMOS 249 DEB
1 06752U 68091CJ  24187.32505038  .00005172  00000-0  51404-2 0  9993
2 06752  62.2803 155.0645 0647799 343.6100  14.4794 13.11541940565653
0 COSMOS 249 DEB
1 06764U 68091CK  24187.50405278  .00000016  00000-0  25692-3 0  9994
2 06764  62.3424 197.7802 0750220 224.0759 311.6430 12.37895224637057
0 THORAD AGENA D DEB
1 06765U 70025NG  24187.25269889  .00000254  00000-0  43160-3 0  9997
2 06765  99.7891 110.0105 0015549 320.5933 194.1294 13.55294362674249
0 THORAD AGENA D DEB
1 06766U 70025NH  24187.38445912  .00001696  00000-0  10681-2 0  9997
2 06766 100.1533 133.8301 0078693 205.4915 154.2358 14.04448942735360
0 THORAD AGENA D DEB
1 06767U 70025NF  24187.50898302  .00003495  00000-0  22917-2 0  9991
2 06767  99.0429  80.6354 0026329  23.7212 336.5161 14.02519834 17714
0 ATLAS CENTAUR R/B
1 06779U 71116B   24187.35953102  .00000017  00000-0  17881-2 0  9990
2 06779  27.8499 251.3815 7155493 133.3411 314.3276  2.19642798399819
0 OPS 8364 (DMSP 4)
1 06787U 73054A   24187.61277863  .00000429  00000-0  17329-3 0  9999
2 06787  98.6624  47.8860 0025625 338.6015  21.4095 14.32825601649837
0 THOR BURNER 2 R/B
1 06788U 73054B   24187.59320032  .00000189  00000-0  96441-4 0  9990
2 06788  98.7227  49.5308 0027483 338.0711  21.9291 14.26545837644005
0 OPS 7724
1 06791U 73056A   24186.88654144  .00000176  00000-0 -85118-2 0  9995
2 06791  62.0321 127.8824 7107018 273.6325  14.8769  2.00673862 35325
0 INTELSAT 4-F7
1 06796U 73058A   24187.48313275 -.00000032  00000-0  00000-0 0  9992
2 06796   8.8854 302.8923 0007666 185.4103 239.4102  0.99143307128599
0 ATLAS CENTAUR R/B
1 06797U 73058B   24184.16829706 -.00000171  00000-0  59661-3 0  9990
2 06797  27.7727  63.6767 7202885 261.5738  18.3228  2.21803440411455
0 OPS 8314 (2)
1 06822U 72079C   24187.57821215  .00000026  00000-0  23500-3 0  9997
2 06822  95.6395  45.6245 0028943 318.3374  96.6969 12.55592606370408
0 TITAN 3D DEB
1 06823U 72079D   24186.22915750 -.00000022  00000-0 -54699-4 0  9999
2 06823  95.8147 279.1674 0052768 142.2218 247.5368 12.54824023368316
0 TITAN 3D DEB
1 06824U 72079E   24187.02284829  .00000023  00000-0  20777-3 0  9993
2 06824  95.4958 205.8603 0006491 179.4748 254.1349 12.56434219371428
0 COSMOS 585
1 06825U 73064A   24187.38692089  .00000003  00000-0  10147-3 0  9997
2 06825  74.0238  63.5515 0018914 196.7698 336.8455 12.68217921352958
0 SL-8 R/B
1  6826U 73064B   24187.57522007  .00000025  00000-0  20781-3 0  9990
2  6826  74.0221 344.2267 0028612 102.8674 322.7549 12.69766593356342
0 COSMOS 586
1 06828U 73065A   24187.51626398  .00000051  00000-0  37028-4 0  9997
2 06828  82.9425 330.7672 0028272  30.3293  37.6407 13.75271622549073
0 SL-8 R/B
1 06829U 73065B   24187.54227513  .00000083  00000-0  68675-4 0  9994
2 06829  82.9426 289.7245 0022066 221.9588 148.5261 13.77329977552369
0 THOR ABLESTAR DEB
1 06842U 61015KP  24187.12676576  .00000257  00000-0  10044-2 0  9990
2 06842  66.7324  59.6181 0654425 186.7922 335.2432 12.45394150243736
0 COSMOS 397 DEB
1 06843U 71015CK  24187.52355195  .00005327  00000-0  93353-3 0  9995
2 06843  65.6703 331.5401 0410825 309.9331  46.6320 14.25710152626648
0 COSMOS 397 DEB
1 06844U 71015CL  24187.38337778  .00004372  00000-0  12281-2 0  9996
2 06844  65.8970 199.5136 0588247 120.4942 245.5563 13.76826251522212
0 COSMOS 588
1 06845U 73069A   24187.55202803  .00000013  00000-0  19008-3 0  9990
2 06845  73.9981 216.4143 0028211 139.7534 337.0360 12.48619724313574
0 COSMOS 589
1 06846U 73069B   24187.61445203 -.00000009  00000-0  43732-4 0  9999
2 06846  74.0021   4.2218 0047256 233.8388 189.8169 12.53217417322042
0 COSMOS 590
1 06847U 73069C   24187.54369249 -.00000010  00000-0  40720-4 0  9993
2 06847  74.0011 102.6251 0034476 346.0878 188.1106 12.51092831318062
0 COSMOS 591
1 06848U 73069D   24187.54327280 -.00000020  00000-0 -20751-4 0  9997
2 06848  74.0027 327.2566 0088968 131.2124 301.0236 12.61732130337747
0 COSMOS 592
1 06849U 73069E   24187.56264272  .00000020  00000-0  19544-3 0  9996
2 06849  73.9986 225.9332 0098685  10.7160 349.5970 12.63888016341758
0 COSMOS 593
1 06850U 73069F   24187.38583608  .00000007  00000-0  13711-3 0  9990
2 06850  74.0013  62.7819 0078248 239.0797 298.9191 12.59699988333919
0 COSMOS 594
1 06851U 73069G   24187.36520562 -.00000018  00000-0 -10895-4 0  9994
2 06851  73.9993 159.5215 0067446 349.6177 119.4157 12.57631723330151
0 COSMOS 595
1 06852U 73069H   24187.58363299  .00000015  00000-0  19090-3 0  9991
2 06852  74.0004 259.9185 0055062 105.0739   1.6842 12.55468687326228
0 SL-8 R/B
1 06853U 73069J   24187.61640811 -.00000053  00000-0 -32734-3 0  9998
2 06853  74.0061  27.3660 0086102 166.7412 262.3948 12.29012589277302
0 NNSS 20 (TRANSIT 20)
1 06909U 73081A   24187.60084412  .00000273  00000-0  27075-3 0  9996
2 06909  89.8365 263.6871 0154577 211.9233 147.2493 13.71056325731642
0 SCOUT A-1 R/B
1 06910U 73081B   24187.60746932  .00000166  00000-0  16583-3 0  9993
2 06910  89.8410 261.0421 0156046 277.8148  80.5324 13.69483059529425
0 COSMOS 606
1 06916U 73084A   24187.30526966  .00000131  00000-0  00000-0 0  9998
2 06916  72.0489  98.8704 5259493 148.0119   5.9152  2.00332094371186
0 NOAA 3
1 06920U 73086A   24187.60363672 -.00000036  00000-0  76865-4 0  9992
2 06920 102.2756 183.7535 0006581 356.2107 118.4085 12.40368230293671
0 DELTA 1 R/B
1  6921U 73086B   24187.52976255 -.00000022  00000-0  19009-3 0  9992
2  6921 102.3922 199.3747 0015102 123.0898 237.1614 12.37042525302313
0 OPS 6630 (2)
1 06938U 73088D   24187.52144227  .00000008  00000-0  15599-3 0  9991
2 06938  96.9221 175.6854 0025905 193.5316 285.0650 12.57164424323710
0 COSMOS 614
1 06965U 73098A   24187.57468795  .00000263  00000-0  92357-4 0  9997
2 06965  74.0566 268.3966 0022824  12.5342 347.6375 14.39581619651870
0 SL-8 R/B
1 06966U 73098B   24187.55593716  .00000534  00000-0  16384-3 0  9994
2 06966  74.0554 124.2970 0021126 174.1370 186.0038 14.43933777656702
0 OPS 9433 (DSCS 2-3)
1 06973U 73100A   24187.04460833 -.00000143  00000-0  00000-0 0  9995
2 06973   6.9576 284.9060 0034137 213.0130 157.7805  0.97656949112885
0 OPS 9434 (DSCS 2-4)
1 06974U 73100B   24187.11510322 -.00000142  00000-0  00000-0 0  9992
2 06974   6.5195 288.9262 0065173  65.8744 321.7993  0.97519962840685
0 TITAN 3C TRANSTAGE R/B
1 06976U 73100D   24187.58450626 -.00000124  00000-0  00000-0 0  9995
2 06976   8.3670 291.3598 0259084 115.6127 182.9036  0.94996049104972
0 COSMOS 617
1 06985U 73104A   24187.57574698 -.00000009  00000-0  39465-4 0  9997
2 06985  74.0302 288.4944 0095545  88.8575  12.0949 12.63511175331345
0 COSMOS 618
1 06986U 73104B   24187.49118723  .00000002  00000-0  11391-3 0  9991
2 06986  74.0264 198.5330 0026625 107.4130   7.8520 12.49911173306302
0 COSMOS 619
1 06987U 73104C   24187.42872648 -.00000006  00000-0  64154-4 0  9999
2 06987  74.0296  92.8285 0040757 343.2865  16.6841 12.52215843310494
0 COSMOS 620
1 06988U 73104D   24187.60968247 -.00000023  00000-0 -50934-4 0  9992
2 06988  74.0313 317.8586 0022487 274.8401  96.2265 12.47294484301434
0 COSMOS 621
1 06989U 73104E   24187.56287704 -.00000018  00000-0 -13218-4 0  9998
2 06989  74.0310 340.1242 0050392 204.4561 223.2817 12.54658224315009
0 COSMOS 622
1 06990U 73104F   24187.59590297 -.00000030  00000-0 -79823-4 0  9995
2 06990  74.0287 134.2146 0074214 326.7457 207.1058 12.59101293323067
0 COSMOS 623
1 06991U 73104G   24187.56346247  .00000019  00000-0  20630-3 0  9993
2 06991  74.0273 234.7572 0062097  82.9855  29.7559 12.56939052319250
0 COSMOS 624
1 06992U 73104H   24187.62987079  .00000013  00000-0  16622-3 0  9995
2 06992  74.0300  33.2504 0086281 213.0306 204.5460 12.61270410327174
0 SL-8 R/B
1 06993U 73104J   24187.63164358 -.00000065  00000-0 -42409-3 0  9995
2 06993  74.0334  10.5019 0092019 156.1696 268.4371 12.30297006269964
0 AUREOLE 2
1 07003U 73107A   24187.59398326  .00018818  00000-0  49440-3 0  9995
2 07003  73.9146 279.1616 0271866  31.2361 330.4663 15.08739957595200
0 COSMOS 626
1 07005U 73108A   24187.54186367 -.00000051  00000-0  30001-4 0  9998
2 07005  65.4381 110.9679 0055127 344.9353  15.0067 13.85443611556062
0 COSMOS 627
1 07008U 73109A   24187.55281013  .00000074  00000-0  63123-4 0  9992
2 07008  82.9542 286.2676 0032771 153.6702 217.5223 13.72980498530234
0 SL-8 R/B
1 07009U 73109B   24187.52130182  .00000176  00000-0  16271-3 0  9994
2 07009  82.9486 190.9590 0018406 228.7725 242.6296 13.76914157537459
0 DELTA 1 DEB
1 07012U 73086C   24187.50322814  .00000053  00000-0  65112-3 0  9997
2 07012 101.6582 151.0605 0060846  44.8773  70.1889 12.47595679305714
0 DELTA 1 DEB
1 07013U 73086D   24187.59836816  .00000045  00000-0  57756-3 0  9995
2 07013 101.9979 182.0650 0070207  16.9805  98.2486 12.51764736313350
0 DELTA 1 DEB
1 07014U 73086E   24187.51621180  .00000201  00000-0  39076-3 0  9993
2 07014 101.7147 156.4972 0405014  48.5883 314.9304 13.22955235442145
0 DELTA 1 DEB
1 07015U 73086F   24187.59080198  .00000014  00000-0  70809-3 0  9991
2 07015 101.8010  80.6628 0401727  94.8228 336.4278 11.66246391156857
0 DELTA 1 DEB
1 07016U 73086G   24187.55910825  .00000127  00000-0  27282-2 0  9998
2 07016 101.6903  72.6203 0516205  63.2012   0.2985 11.45435918117935
0 DELTA 1 DEB
1 07017U 73086H   24187.52204804  .00000022  00000-0  42547-3 0  9995
2 07017 102.0544  86.1681 0151257 331.4467 203.1989 12.51788485298259
0 DELTA 1 DEB
1 07018U 73086J   24187.50707330  .00000027  00000-0  55506-3 0  9990
2 07018 102.3367 189.4968 0011531 308.8215 206.2789 12.39117821290283
0 DELTA 1 DEB
1 07019U 73086K   24187.57497561  .00000060  00000-0  75888-3 0  9992
2 07019 102.2072 185.1398 0066918  80.5099  33.9135 12.42690695296453
0 DELTA 1 DEB
1 07020U 73086L   24187.17118378  .00000170  00000-0  21083-2 0  9995
2 07020 102.2527 275.7782 0159103 235.3468 153.0598 12.14981780245191
0 DELTA 1 DEB
1 07021U 73086M   24187.43679433  .00000399  00000-0  34230-2 0  9990
2 07021 101.6798 253.0430 0195357 110.5934 264.5737 12.31992299261598
0 DELTA 1 DEB
1 07022U 73086N   24187.38504687 -.00000047  00000-0 -54112-5 0  9999
2 07022 102.4070 240.1596 0180236 114.3848 260.2317 12.44373503300133
0 DELTA 1 DEB
1 07023U 73086P   24187.38636226  .00000024  00000-0  54929-3 0  9992
2 07023 102.2465 149.4627 0026559 234.6939 277.7563 12.36249496284445
0 DELTA 1 DEB
1 07024U 73086Q   24187.38431825  .00000830  00000-0  40742-2 0  9993
2 07024 101.8416 221.5013 0069514 226.7218 147.3380 12.75328741340646
0 DELTA 1 DEB
1 07025U 73086R   24187.05372074 -.00000006  00000-0  48719-3 0  9997
2 07025 101.9562 280.0235 0466016 234.9870 305.0400 11.54254725135047
0 DELTA 1 DEB
1 07026U 73086S   24187.14965815  .00000269  00000-0  16960-2 0  9991
2 07026 102.0900 265.9609 0129498  88.0619 303.4940 12.63088590324702
0 DELTA 1 DEB
1 07027U 73086T   24187.25860951  .00000159  00000-0  16097-2 0  9998
2 07027 101.9356  89.2576 0055379 285.2857 192.8246 12.35012936276140
0 DELTA 1 DEB
1 07028U 73086U   24187.56698684 -.00000015  00000-0  28622-3 0  9995
2 07028 102.6915 185.7755 0081145 282.8581 191.4155 12.24504712264246
0 DELTA 1 DEB
1 07029U 73086V   24187.60374583 -.00000031  00000-0  11538-3 0  9996
2 07029 102.3554 187.5023 0012785  96.0511  15.1489 12.37150894287781
0 DELTA 1 DEB
1 07030U 73086W   24187.03102169  .00000012  00000-0  49226-3 0  9997
2 07030 101.9231 203.8943 0090451  32.1081  26.8062 12.24019841262514
0 DELTA 1 DEB
1 07031U 73086X   24187.53363743  .00000000  00000-0  32603-3 0  9998
2 07031 101.7365 163.3494 0010511 317.9653 158.8157 12.38688121289844
0 DELTA 1 DEB
1 07032U 73086Y   24187.58080050 -.00000028  00000-0  14819-3 0  9991
2 07032 102.3954 179.6894 0029510 328.1760 147.3901 12.34746889283118
0 DELTA 1 DEB
1 07033U 73086Z   24187.36993894  .00000067  00000-0  80489-3 0  9995
2 07033 101.6710 232.5392 0027220 211.3133 161.1871 12.41813814289135
0 DELTA 1 DEB
1 07034U 73086AA  24187.52353715 -.00000005  00000-0  28922-3 0  9993
2 07034 102.0246 158.9364 0015345 259.1253 220.4257 12.43753808297441
0 DELTA 1 DEB
1 07035U 73086AB  24187.50668286  .00000036  00000-0  97285-3 0  9995
2 07035 101.7241 185.4816 0314671 226.4307 259.1971 11.83354595186151
0 DELTA 1 DEB
1 07036U 73086AC  24187.50148392  .00001589  00000-0  10140-1 0  9994
2 07036 101.5247 167.0700 0041806 156.6483 318.7298 12.54050621307869
0 DELTA 1 DEB
1 07037U 73086AD  24187.53317447  .00000210  00000-0  31640-2 0  9996
2 07037 102.0608 294.4989 0319065 297.4326  71.0671 11.86576116193599
0 DELTA 1 DEB
1 07038U 73086AE  24187.52951360 -.00000054  00000-0 -10226-3 0  9990
2 07038 101.9348  37.4777 0129558 354.2864  61.2187 12.24231976259416
0 DELTA 1 DEB
1 07039U 73086AF  24187.44690942  .00000045  00000-0  60082-3 0  9991
2 07039 102.4678 145.5867 0129017 170.7922 309.4527 12.49444583308211
0 DELTA 1 DEB
1 07040U 73086AG  24187.28640990  .00000041  00000-0  36776-3 0  9992
2 07040 102.5068 306.6125 0194028  85.2888 332.3221 12.82142695365988
0 DELTA 1 DEB
1 07041U 73086AH  24187.60989963  .00000707  00000-0  54613-2 0  9993
2 07041 101.6045 236.9189 0196525 122.6533   4.4955 12.36812246266588
0 DELTA 1 DEB
1 07042U 73086AJ  24187.59728761  .00001048  00000-0  13508-2 0  9996
2 07042 101.7214 302.9767 0320894 264.6177  91.8267 13.46299860466393
0 DELTA 1 DEB
1 07043U 73086AK  24187.47881667  .00000125  00000-0  65651-3 0  9991
2 07043 102.1718 178.9432 0216171 228.4285 288.2285 12.85178574373140
0 DELTA 1 DEB
1 07044U 73086AL  24187.51428778  .00000003  00000-0  35803-3 0  9998
2 07044 102.5821  21.7458 0089848 113.3309 320.7917 12.44473148300730
0 DELTA 1 DEB
1 07045U 73086AM  24187.50796816 -.00000008  00000-0  34102-3 0  9996
2 07045 102.6107 189.8195 0077140 158.9027 359.8766 12.26083968260284
0 DELTA 1 DEB
1 07046U 73086AN  24187.50553263 -.00000004  00000-0  36437-3 0  9993
2 07046 102.5373 191.8020 0057233 198.4385 316.1805 12.29356194266559
0 DELTA 1 DEB
1 07048U 73086AQ  24187.36942998  .00000024  00000-0  92693-3 0  9993
2 07048 101.6197 151.0617 0490794  48.1342 101.9788 11.50716181121731
0 DELTA 1 DEB
1 07049U 73086AR  24187.45532553 -.00000141  00000-0 -12653-2 0  9995
2 07049 101.7432 177.1763 0252232 326.9539 187.9971 11.93385420199631
0 DELTA 1 DEB
1 07050U 73086AS  24187.46422322  .00000421  00000-0  27581-2 0  9995
2 07050 101.5914 165.0344 0047302 144.8150  10.7988 12.57472713308932
0 DELTA 1 DEB
1 07051U 73086AT  24186.99012606  .00000006  00000-0  45116-3 0  9997
2 07051 102.5514 194.5345 0065320 283.6444 135.1747 12.28907278265222
0 DELTA 1 DEB
1 07052U 73086AU  24187.44080481  .00000020  00000-0  51466-3 0  9996
2 07052 102.3656 178.6482 0024155 116.2101  38.2327 12.37410179286897
0 DELTA 1 DEB
1 07053U 73086AV  24187.48942898  .00000039  00000-0  55712-3 0  9998
2 07053 101.8077 263.8374 0045495 221.1525 151.5708 12.48412198305420
0 DELTA 1 DEB
1  7054U 73086AW  24187.55992550 -.00000047  00000-0  12187-4 0  9997
2  7054 101.5273 168.7705 0313718 336.5017 137.1530 13.03670080407952
0 DELTA 1 DEB
1 07055U 73086AX  24187.27411336 -.00000029  00000-0  17089-3 0  9990
2 07055 102.6853 297.3000 0344988 245.9160 137.1649 11.84079453189436
0 DELTA 1 DEB
1 07056U 73086AY  24187.47571120 -.00000010  00000-0  33523-3 0  9992
2 07056 102.6860 173.7584 0087264 340.4287 171.3644 12.24120385263031
0 DELTA 1 DEB
1 07057U 73086AZ  24187.56933421 -.00000035  00000-0  95094-4 0  9998
2 07057 102.4531 193.5179 0034541 159.6779 330.9425 12.33030401280196
0 DELTA 1 DEB
1 07058U 73086BA  24187.43208766  .00000535  00000-0  36105-2 0  9992
2 07058 101.7723 167.0340 0009515  26.9248 128.2701 12.54221371309905
0 DELTA 1 DEB
1 07059U 73086BB  24187.34074853  .00000230  00000-0  23515-2 0  9994
2 07059 101.9922 315.9179 0113674 159.5626 260.5388 12.27436215262025
0 DELTA 1 DEB
1  7060U 73086BC  24187.56275652  .00000020  00000-0  46371-3 0  9993
2  7060 102.1737 194.4389 0023444 354.4284 124.6786 12.44837102300910
0 DELTA 1 DEB
1 07061U 73086BD  24187.49862374  .00000137  00000-0  10981-2 0  9995
2 07061 102.5432  27.0854 0139701 238.1642 178.5735 12.55939801318399
0 DELTA 1 DEB
1 07063U 73086BF  24187.61786958  .00000091  00000-0  39783-3 0  9995
2 07063 102.4718 188.6939 0293426  79.5166  38.9527 12.99721551399901
0 DELTA 1 DEB
1 07064U 73086BG  24187.01242642  .00000075  00000-0  54203-3 0  9993
2 07064 101.7290  15.1931 0181014 347.2100 166.8977 12.75271851355366
0 DELTA 1 DEB
1 07065U 73086BH  24187.42930361  .00000114  00000-0  12702-2 0  9992
2 07065 101.7877 176.6986 0045577 323.4532 206.8587 12.33812836276204
0 DELTA 1 DEB
1 07066U 73086BJ  24187.38933479  .00000462  00000-0  37751-2 0  9998
2 07066 101.7691 152.5475 0058638  58.8202  95.7294 12.39716462286261
0 DELTA 1 DEB
1 07068U 73086BL  24187.22413348 -.00000015  00000-0  14333-3 0  9998
2 07068 102.3300  90.8441 0213089 136.5837  14.3187 12.81517837367524
0 DELTA 1 DEB
1 07069U 73086BM  24187.43574745  .00002936  00000-0  34014-2 0  9991
2 07069 102.7787   4.4892 0256346 160.5764 200.5349 13.57186346465639
0 DELTA 1 DEB
1 07071U 73086BP  24187.57231762 -.00000006  00000-0  26516-3 0  9994
2 07071 101.5704 191.1439 0006671  10.6539 112.1438 12.41112499294837
0 DELTA 1 DEB
1 07072U 73086BQ  24187.51252771 -.00000021  00000-0  16388-3 0  9995
2 07072 101.7307 153.4474 0011059 108.5772   3.3641 12.42623345296917
0 DELTA 1 DEB
1 07073U 73086BR  24187.51007535 -.00000053  00000-0 -67417-4 0  9998
2 07073 102.4104 141.9193 0063554 204.1424 277.9194 12.28457408271481
0 DELTA 1 DEB
1 07074U 73086BS  24187.17185981 -.00000035  00000-0  59386-4 0  9998
2 07074 101.9520 259.7859 0176723  82.2009 335.5606 12.72167691351728
0 DELTA 1 DEB
1 07075U 73086BT  24187.55569521  .00000984  00000-0  33838-2 0  9991
2 07075 101.6308  38.3450 0164852  17.5718  44.6494 12.96635761373682
0 DELTA 1 DEB
1 07076U 73086BU  24187.56915594 -.00000019  00000-0  20038-3 0  9997
2 07076 102.2433 172.1815 0011703 300.2139 178.5378 12.39818935292126
0 DELTA 1 DEB
1 07079U 73086BX  24187.50171183 -.00000045  00000-0 -16514-4 0  9997
2 07079 101.8109 168.0749 0039965  80.2037  35.4854 12.34167947275289
0 DELTA 1 DEB
1 07080U 73086BY  24187.44925677  .00001130  00000-0  60039-2 0  9990
2 07080 101.8921 149.7144 0045623 146.7322 326.7160 12.68800232319778
0 DELTA 1 DEB
1 07081U 73086BZ  24186.96143692 -.00000106  00000-0 -26734-3 0  9995
2 07081 102.2775 252.5295 0166284  65.7621 105.6431 12.69723013345293
0 DELTA 1 DEB
1 07082U 73086CA  24187.60942219  .00000595  00000-0  36484-2 0  9992
2 07082 101.8126  46.7291 0023555 244.8966 181.3360 12.60924880319045
0 DELTA 1 DEB
1 07083U 73086CB  24185.97339868  .00000100  00000-0  11926-2 0  9997
2 07083 102.4409 183.2457 0068039  36.6813 348.6065 12.32414724276101
0 DELTA 1 DEB
1 07084U 73086CC  24187.52338867 -.00000019  00000-0  19642-3 0  9993
2 07084 101.7487 161.3799 0152827 206.2188 270.6896 12.25162680265124
0 DELTA 1 DEB
1 07085U 73086CD  24187.60438956  .00000092  00000-0  78466-3 0  9992
2 07085 102.0866 311.6680 0099698 138.9224 234.3540 12.60053436326507
0 DELTA 1 DEB
1 07086U 73086CE  24187.46059515  .00000077  00000-0  90371-3 0  9999
2 07086 102.0465 152.3331 0014448  85.2541  36.0749 12.40819667292719
0 DELTA 1 DEB
1 07088U 73086CG  24187.45151270  .00000439  00000-0  17622-2 0  9990
2 07088 102.4372  29.4099 0263388  74.1018 355.8520 12.83846920361188
0 DELTA 1 DEB
1 07091U 73086CK  24186.90715495  .00000276  00000-0  36839-2 0  9998
2 07091 102.0584 352.5295 0276916 276.4906 246.2554 11.96256052210946
0 DELTA 1 DEB
1 07092U 73086CL  24187.37673950  .00000065  00000-0  27481-3 0  9990
2 07092 101.8448  51.7387 0316923 118.9943  53.9542 13.06612204409394
0 DELTA 1 DEB
1 07093U 73086CM  24187.63271527 -.00000001  00000-0  39019-3 0  9995
2 07093 102.6077 197.5920 0071413  74.8291  49.0136 12.27009595258091
0 COSMOS 628
1  7094U 74001A   24187.57350814  .00000061  00000-0  47260-4 0  9997
2  7094  82.9570 348.6589 0035905 332.4449  97.1906 13.75864606533040
0 SL-8 R/B
1 07095U 74001B   24187.55815367  .00000099  00000-0  81310-4 0  9990
2 07095  82.9492 278.5246 0038597 100.3429 260.2084 13.78890069537448
0 DELTA 1 DEB
1 07124U 73086CN  24187.61195336 -.00000026  00000-0  16925-3 0  9999
2 07124 102.5234 198.0034 0053417  91.7578  25.3561 12.30065834274293
0 DELTA 1 DEB
1 07126U 73086CQ  24187.47080735  .00000856  00000-0  58478-2 0  9999
2 07126 101.9145 162.8903 0280572 158.4390 327.1217 12.40368642286119
0 DELTA 1 DEB
1 07127U 73086CR  24187.17384791 -.00000448  00000-0 -45337-2 0  9995
2 07127 101.9667 258.3186 0268024 101.7455 319.3294 12.00763520219668
0 DELTA 1 DEB
1  7128U 73086CS  24187.21988448  .00000051  00000-0  51741-3 0  9995
2  7128 101.6243 289.3662 0032946  35.0603  39.8113 12.65301245323882
0 DELTA 1 DEB
1 07129U 73086CT  24187.26349656  .00000263  00000-0  32384-2 0  9999
2 07129 102.0769  85.3740 0247290 131.7582 351.7470 12.04542286221639
0 DELTA 1 DEB
1 07130U 73086CU  24186.82266403  .00006301  00000-0  12897-1 0  9995
2 07130 102.4068 156.6147 0053465 104.5674 317.4355 13.32984489366402
0 DELTA 1 DEB
1 07131U 73086CV  24187.51622337  .00000472  00000-0  50445-2 0  9990
2 07131 101.8613 165.4379 0177781  96.0534  23.5254 12.14495857239008
0 DELTA 1 DEB
1 07132U 73086CW  24187.43337758  .00000070  00000-0  85489-3 0  9993
2 07132 102.1283 156.9208 0017935 231.4323 300.7206 12.41143688291374
0 DELTA 1 DEB
1 07133U 73086CX  24187.11130225  .00000067  00000-0  81067-3 0  9993
2 07133 101.7428 235.8046 0038298 221.9378 166.0646 12.41267719291987
0 DELTA 1 DEB
1 07134U 73086CY  24187.63409405  .00000287  00000-0  21093-2 0  9996
2 07134 101.8413 314.3462 0019307 185.3813 189.3361 12.52629810310963
0 DELTA 1 DEB
1 07135U 73086CZ  24187.26915987  .00000510  00000-0  29859-2 0  9990
2 07135 102.2225 111.4161 0140712 339.7966  19.7576 12.62883623323694
0 DELTA 1 DEB
1 07136U 73086DA  24187.51431300  .00000057  00000-0  62699-3 0  9997
2 07136 101.5208 172.5687 0053624  34.2675  82.3733 12.53513984312305
0 DELTA 1 DEB
1 07137U 73086DB  24187.51757921  .00000386  00000-0  25231-2 0  9993
2 07137 101.6659 164.9278 0044168  60.1097  60.8285 12.58475495317371
0 DELTA 1 DEB
1 07138U 73086DC  24187.62971208 -.00000048  00000-0 -40301-4 0  9996
2 07138 101.9759 139.7141 0053227 173.4909 359.9861 12.31845562278242
0 DELTA 1 DEB
1 07139U 73086DD  24187.39788679  .00000160  00000-0  15867-2 0  9999
2 07139 102.3371 338.6982 0066972  96.1005 323.4149 12.37301613277211
0 DELTA 1 DEB
1 07140U 73086DE  24187.44295668  .00000066  00000-0  88056-3 0  9994
2 07140 102.3335 158.9090 0020193 211.1759 274.5917 12.36226394284696
0 DELTA 1 DEB
1 07141U 73086DF  24187.62945090  .00000172  00000-0  16169-2 0  9999
2 07141 102.1184 231.8899 0027415 179.4562 310.7777 12.40564914286795
0 DELTA 1 DEB
1 07142U 73086DG  24187.59979767  .00000004  00000-0  38334-3 0  9997
2 07142 101.7487 179.6276 0043864 261.1731 213.1434 12.32007593277880
0 DELTA 1 DEB
1 07143U 73086DH  24187.36752672 -.00000012  00000-0  25101-3 0  9995
2 07143 101.8588 232.6188 0047509 268.5386 106.2265 12.32969357279615
0 DELTA 1 DEB
1 07145U 73086DK  24187.55140728  .00000042  00000-0  10689-2 0  9997
2 07145 101.9780  67.2428 0315606 174.1832 256.9407 11.81554171184753
0 DELTA 1 DEB
1 07146U 73086DL  24187.57989359  .00000523  00000-0  40311-2 0  9990
2 07146 101.7665  73.3011 0061754  69.8026   2.9751 12.43380123285427
0 DELTA 1 DEB
1 07147U 73086DM  24187.43246756  .00000001  00000-0  36863-3 0  9992
2 07147 102.1199 132.6217 0055076 182.7852 286.8714 12.33042641279305
0 DELTA 1 DEB
1  7148U 73086DN  24186.88185758 -.00000108  00000-0 -56770-3 0  9994
2  7148 102.1271 226.1475 0133155 137.8940  36.7938 12.25604635266568
0 DELTA 1 DEB
1 07149U 73086DP  24187.21696257  .00000448  00000-0  36648-2 0  9990
2 07149 102.0993 293.8590 0050741 241.7727 147.4990 12.40341621286734
0 DELTA 1 DEB
1 07150U 73086DQ  24187.26584971  .00000117  00000-0  13832-2 0  9999
2 07150 101.8171 177.9368 0133257 119.5549 255.3533 12.25748657259863
0 DELTA 1 DEB
1 07151U 73086DR  24187.24409112  .00000175  00000-0  21141-2 0  9997
2 07151 102.7179 305.1933 0159928 238.9219 150.2948 12.17631819247714
0 DELTA 1 DEB
1 07152U 73086DS  24186.83404472 -.00000024  00000-0  17883-3 0  9999
2 07152 102.1884 147.0567 0079598 269.5010 118.6848 12.28506099271213
0 DELTA 1 DEB
1 07153U 73086DT  24187.51720289  .00000062  00000-0  83612-3 0  9997
2 07153 102.0616 152.4164 0036600  11.4947  99.9339 12.35829910282811
0 DELTA 1 DEB
1 07155U 73086DU  24187.20074551  .00000048  00000-0  69471-3 0  9990
2 07155 102.4050  76.7061 0124147  18.4141 135.8288 12.40052092287600
0 DELTA 1 DEB
1  7156U 73086DV  24187.56633285 -.00000068  00000-0 -26071-3 0  9998
2  7156 102.0793  90.1617 0137852  11.2549 108.0969 12.14459033246428
0 DELTA 1 DEB
1 07158U 73086DW  24187.57848060 -.00000033  00000-0  11480-3 0  9999
2 07158 102.5031 201.9473 0040873 300.0116 178.9692 12.31756286277508
0 DELTA 1 DEB
1 07160U 73086DY  24187.40663346  .00000315  00000-0  28489-2 0  9994
2 07160 102.0621 152.3871 0076726 217.9155 273.2696 12.34812692277912
0 DELTA 1 DEB
1 07161U 73086DZ  24187.33648422 -.00000017  00000-0  21758-3 0  9998
2 07161 102.2612 200.2303 0014628 357.5088  15.8746 12.41202033294473
0 DELTA 1 DEB
1 07162U 73086EA  24187.48356731  .00000472  00000-0  21016-2 0  9994
2 07162 101.5713  14.5821 0097811 155.8253 262.3914 12.84578437337449
0 DELTA 1 DEB
1 07163U 73086EB  24187.61639383  .00000001  00000-0  39327-3 0  9990
2 07163 102.4934 197.0365 0063862 328.2254 145.0947 12.31293241276344
0 DELTA 1 DEB
1 07164U 73086EC  24187.02737566  .00000385  00000-0  19757-2 0  9997
2 07164 101.1384 223.8166 0086517 257.6000 166.7784 12.75494469347928
0 DELTA 1 DEB
1 07165U 73086ED  24187.57556615  .00001492  00000-0  39912-2 0  9997
2 07165 101.6621 208.5601 0171777 344.4779 143.9946 13.12343737395858
0 DELTA 1 DEB
1 07166U 73086EE  24186.94350440  .00000071  00000-0  85990-3 0  9996
2 07166 102.2049 177.3566 0014605 131.6674 286.8263 12.41292654292238
0 DELTA 1 DEB
1 07167U 73086EF  24187.35275003  .00000361  00000-0  25208-2 0  9991
2 07167 101.9352 329.6252 0043096  89.7963 327.3709 12.54283152304604
0 DELTA 1 DEB
1 07168U 73086EG  24187.35932550  .00000078  00000-0  12440-2 0  9998
2 07168 102.2263 341.8674 0179085 288.2310  99.9195 12.10914828452309
0 DELTA 1 DEB
1 07169U 73086EH  24187.15466711  .00000019  00000-0  31687-3 0  9998
2 07169 101.4817 246.9176 0132957  63.9882 356.3438 12.68322356339189
0 DELTA 1 DEB
1 07170U 73086EJ  24187.43468975  .00001550  00000-0  48197-2 0  9999
2 07170 101.6754 169.9319 0085005 213.1480 303.7847 13.05661892371213
0 DELTA 1 DEB
1 07173U 73086EK  24187.30559816 -.00000344  00000-0 -23873-2 0  9999
2 07173 102.4768 320.7106 0226845 302.1757 129.3737 12.27853174 90516
0 DELTA 1 DEB
1 07174U 73086EL  24186.45868354  .00000025  00000-0  66230-3 0  9994
2 07174 102.1168 271.1260 0291507 323.8314  96.4497 12.08884231245295
0 DELTA 1 DEB
1 07175U 73086EM  24187.58824174  .00001026  00000-0  36386-2 0  9992
2 07175 102.5836 293.6116 0198289 200.4580 171.8134 12.92884906376933
0 DELTA 1 DEB
1 07176U 73086EN  24187.59643200  .00000039  00000-0  39781-3 0  9999
2 07176 102.2739  54.3513 0176829 325.8759  89.1685 12.75586707356863
0 DELTA 1 DEB
1 07177U 73086EP  24187.41988353  .00001147  00000-0  27443-2 0  9994
2 07177 102.0137  92.8159 0247079  56.0479 354.6346 13.15183213411344
0 DELTA 1 DEB
1 07179U 73086EQ  24187.59363791  .00015951  00000-0  16457-1 0  9998
2 07179 102.6849 301.3416 0019566  11.8715   1.4568 13.75944873390450
0 DELTA 1 DEB
1 07180U 73086ER  24187.61448640  .00000304  00000-0  15128-2 0  9991
2 07180 102.2493 224.3636 0153959 114.0834  16.6989 12.78630036349717
0 DELTA 1 DEB
1 07181U 73086ES  24187.17986022  .00000191  00000-0  14147-2 0  9998
2 07181 102.3415 281.3928 0101113   6.7973  23.8655 12.56788688320954
0 DELTA 1 DEB
1 07182U 73086ET  24187.20876903  .00001070  00000-0  40655-2 0  9999
2 07182 102.4986 269.1892 0341557 181.9605 240.1181 12.76530851597042
0 DELTA 1 DEB
1 07183U 73086EU  24187.48709912  .00000936  00000-0  48812-2 0  9998
2 07183 102.3671 155.1264 0120064 194.9012 290.2505 12.69214984334339
0 DELTA 1 DEB
1 07184U 73086EV  24187.63265301  .00000973  00000-0  29564-2 0  9999
2 07184 102.2864  62.3640 0196604 230.6126 187.6637 13.03738746390554
0 DELTA 1 DEB
1 07185U 73086EW  24187.47695775  .00000240  00000-0  25175-2 0  9995
2 07185 101.7762   8.4782 0149617 159.8406 227.6946 12.23074307254890
0 DELTA 1 DEB
1 07186U 73086EX  24187.51946709  .00000869  00000-0  27057-2 0  9995
2 07186 101.7818 283.4384 0228790 265.2385 105.6813 13.00099018385855
0 DELTA 1 DEB
1 07190U 73086EY  24187.04275719  .00003540  00000-0  32255-2 0  9999
2 07190 102.7343 232.2015 0239217 149.0437 212.5050 13.72230666481763
0 DELTA 1 DEB
1 07191U 73086EZ  24187.60457358  .00000330  00000-0  35577-2 0  9997
2 07191 102.1630  98.2340 0244814 161.2067 319.7932 12.13333522809720
0 DELTA 1 DEB
1  7192U 73086FA  24186.60654602  .00000001  00000-0  61961-3 0  9990
2  7192 102.1906  54.3759 0441384 292.9732  85.7377 11.59834034144724
0 DELTA 1 DEB
1 07193U 73086FB  24187.23330039  .00000268  00000-0  30026-2 0  9998
2 07193 101.8545 295.2443 0292851  12.6309  56.5972 12.08859776228743
0 DELTA 1 DEB
1 07194U 73086FC  24187.29889859  .00000026  00000-0  98383-3 0  9997
2 07194 102.7035 307.2076 0545397 157.9203 269.6780 11.49794597122038
0 DELTA 1 DEB
1 07195U 73086FD  24186.70844297  .00001506  00000-0  18209-2 0  9992
2 07195 103.1751 269.0212 0309505  87.6034 276.0480 13.50513476458238
0 DELTA 1 DEB
1 07196U 73086FE  24187.39740630 -.00000008  00000-0  26678-3 0  9992
2 07196 102.3332 155.1054 0052426 105.5079  49.3414 12.47010859305220
0 DELTA 1 DEB
1 07198U 73086FG  24187.59070431  .00000721  00000-0  28883-2 0  9991
2 07198 102.3350  55.7975 0139786 150.2861 282.8678 12.88727161367028
0 DELTA 1 DEB
1 07200U 73086FJ  24187.55828521  .00000541  00000-0  61740-2 0  9991
2 07200 102.3591 200.1269 0302733 122.5856 359.1467 12.01623208216817
0 DELTA 1 DEB
1 07202U 73086FL  24187.53692594  .00000757  00000-0  15346-2 0  9990
2 07202 102.0413  45.7438 0292002 181.9446 250.6270 13.23358289427350
0 DELTA 1 DEB
1 07203U 73086FM  24187.23968730  .00000528  00000-0  60190-3 0  9990
2 07203 101.9930  75.3824 0447274  11.8245 349.2978 13.39907553465142
0 METEOR 1-16
1 07209U 74011A   24187.57909674  .00000100  00000-0  45911-4 0  9995
2 07209  81.2270   8.7127 0037940 269.9091  89.7734 14.14234725594643
0 SL-3 R/B
1 07210U 74011B   24187.57469655  .00000208  00000-0  10169-3 0  9992
2 07210  81.2356  45.5645 0079543 253.1682 106.0755 14.13375658593454
0 MIRANDA (X-4)
1 07213U 74013A   24187.62145443  .00001084  00000-0  30024-3 0  9994
2 07213  97.8939  85.0483 0115571   7.9971 352.3029 14.44628754616834
0 OPS 8579 (DMSP 5B F5)
1 07218U 74015A   24187.14588787  .00000354  00000-0  14882-3 0  9993
2 07218  99.0292 253.1482 0055921 219.1754 140.5373 14.31416581619055
0 THOR BURNER 2A R/B
1 07219U 74015B   24187.56763410  .00000195  00000-0  99665-4 0  9994
2 07219  98.9804 119.8478 0063817 191.6303 168.3405 14.25657938611820
0 SCOUT D-1 R/B
1 07228U 74013B   24187.60502650  .00000816  00000-0  23671-3 0  9997
2 07228  97.8674  68.9489 0108049  95.1047 266.2487 14.43395311615128
0 COSMOS 637
1 07229U 74017A   24187.55532963 -.00000085  00000-0  00000-0 0  9993
2 07229   2.6522 272.0987 0037894  48.1460 315.0141  1.00771806115033
0 OPS 4547
1 07244U 74020B   24187.55096071  .00000166  00000-0  66962-4 0  9991
2 07244  94.5941 204.0273 0025858 208.3601 151.6185 14.31506831 10210
0 WESTAR 1
1 07250U 74022A   24187.51143682  .00000119  00000-0  00000-0 0  9992
2 07250   8.7271 303.8707 0002510  73.9150 311.2778  0.99895225115221
0 COSMOS 641
1 07265U 74024A   24187.51328501  .00000008  00000-0  14748-3 0  9999
2 07265  74.0152 199.6097 0061055 281.8831 192.6755 12.57337343304156
0 COSMOS 642
1 07266U 74024B   24187.37273412 -.00000014  00000-0  11984-4 0  9992
2 07266  74.0160 166.2807 0103663 188.6298 282.5725 12.65819502319634
0 COSMOS 643
1 07267U 74024C   24187.55770872 -.00000008  00000-0  46989-4 0  9991
2 07267  74.0191   3.7563 0082283  56.4233  20.2719 12.61572455311886
0 COSMOS 644
1 07268U 74024D   24187.57578516  .00000014  00000-0  17007-3 0  9999
2 07268  74.0178 265.6139 0094909 306.1374  53.0928 12.63673813315791
0 COSMOS 645
1 07269U 74024E   24187.23331749 -.00000008  00000-0  46408-4 0  9990
2 07269  74.0181  98.8506 0072176 167.7238 309.4803 12.59522725308008
0 COSMOS 646
1 07270U 74024F   24187.60248181 -.00000020  00000-0 -26029-4 0  9992
2 07270  74.0194 305.8787 0051384  53.0185 319.1555 12.55008729299912
0 COSMOS 647
1 07271U 74024G   24187.36869740  .00000013  00000-0  18338-3 0  9999
2 07271  74.0182  44.9387 0039081 168.0986   5.5269 12.52857554295901
0 COSMOS 648
1 07272U 74024H   24187.35169635 -.00000014  00000-0  12269-4 0  9995
2 07272  74.0163 159.1468 0033556 315.4826 154.8349 12.50358777291423
0 SL-8 R/B
1 07273U 74024J   24187.59561736  .00000012  00000-0  23134-3 0  9999
2 07273  74.0266 332.2956 0075968 317.2202 115.9498 12.30475435255191
0 METEOR 1-17
1 07274U 74025A   24187.47292063  .00000188  00000-0  10184-3 0  9997
2 07274  81.2140 271.0889 0017873 183.5815 176.5230 14.08663846578099
0 SL-3 R/B
1 07275U 74025B   24187.57528616  .00000137  00000-0  73550-4 0  9996
2 07275  81.2448 342.0936 0055972 187.2301 172.8067 14.06882973575126
0 MOLNIYA 2-9
1 07276U 74026A   24185.03951545  .00000089  00000-0  00000-0 0  9990
2 07276  64.2924 126.2361 6447242 270.8128  21.2900  2.45097892267510
0 COSMOS 650
1 07281U 74028A   24187.46710751 -.00000004  00000-0  61777-4 0  9999
2 07281  74.0428  92.2643 0020579  96.7924  76.9162 12.69552216325843
0 SL-8 R/B
1 07284U 74028B   24187.58802601 -.00000056  00000-0 -19184-3 0  9993
2 07284  74.0403 358.2543 0017071 330.5020  93.6404 12.71532854329367
0 COSMOS 651
1 07291U 74029A   24187.60381505 -.00000054  00000-0  28553-4 0  9998
2 07291  64.9718  26.7774 0054234 287.1093  72.4036 13.93012701551591
0 COSMOS 654
1 07297U 74032A   24187.58701369 -.00000058  00000-0  28682-4 0  9996
2 07297  64.9501 325.9898 0070806 218.0169 222.0822 13.79550111526817
0 SMS 1
1 07298U 74033A   24187.45605652 -.00000078  00000-0  00000-0 0  9994
2 07298   5.9506 264.7884 0013890  55.3600 235.5786  0.98612091112862
0 ATS 6
1 07318U 74039A   24187.11545131  .00000055  00000-0  00000-0 0  9995
2 07318   3.7215 267.9941 0027919 305.7637 103.4000  1.01976344114746
0 TITAN 3C TRANSTAGE R/B
1 07324U 74039C   24187.19825767  .00000056  00000-0  00000-0 0  9997
2 07324   4.5754 274.0949 0032328  60.7076  68.7524  1.00726181112453
0 COSMOS 660
1 07337U 74044A   24187.57135933  .00006512  00000-0  29693-3 0  9993
2 07337  82.9416 159.8433 0486757 143.0152 220.5679 14.53411308537666
0 COSMOS 663
1 07349U 74048A   24187.57821192  .00000069  00000-0  55509-4 0  9996
2 07349  82.9514 341.9659 0026438  79.7614 351.6236 13.75740335510367
0 SL-8 R/B
1  7350U 74048B   24187.56036510  .00000088  00000-0  72747-4 0  9993
2  7350  82.9456 287.4289 0015515 294.7176  75.5736 13.77895783514274
0 METEOR 1-18
1 07363U 74052A   24187.52214610  .00000134  00000-0  82893-4 0  9992
2 07363  81.2284 332.4365 0016788 320.8027  39.1921 14.00079829552506
0 SL-3 R/B
1 07364U 74052B   24187.43563298  .00000243  00000-0  13815-3 0  9990
2 07364  81.2313 174.2478 0050645 107.4390 253.2324 14.06247755563025
0 OPS 7518 (NTS 1)
1 07369U 74054A   24186.90792323 -.00000018  00000-0  00000-0 0  9991
2 07369 124.6707 166.5505 0065269  31.9992 150.4754  3.07214369560735
0 SL-6 R/B(2)
1 07373U 74026E   24186.89535931  .00000517  00000-0  00000-0 0  9996
2 07373  64.1377  33.3481 7160047 273.1200  14.5515  2.06577419372220
0 MOLNIYA 2-10
1 07376U 74056A   24165.82282291  .00000780  00000-0  00000-0 0  9992
2 07376  65.1685  17.2177 6846350 279.3429  14.8914  2.01075943364987
0 MOLNIYA 1-S
1 07392U 74060A   24187.51356377 -.00000303  00000-0  00000-0 0  9994
2 07392   3.2000 270.3292 0010300 237.3272  62.3293  1.00228981127032
0 SL-12 R/B(AUX MOTOR)
1 07400U 74060E   24186.14503355 -.00000086  00000-0  00000-0 0  9990
2 07400  45.2455 310.4179 6495279 210.7030  85.9483  2.54704520 92993
0 OPS 6983 (DMSP 5C F1)
1 07411U 74063A   24187.57669547  .00000412  00000-0  17943-3 0  9998
2 07411  98.5744  32.4159 0040375 300.5860  59.1342 14.28817234592715
0 THOR BURNER 2A R/B
1 07412U 74063B   24187.53870561  .00000176  00000-0  95975-4 0  9994
2 07412  98.6445  32.0383 0044189 236.8311 122.8625 14.23347869587824
0 COSMOS 675
1 07424U 74069A   24187.55056003 -.00000029  00000-0 -62465-4 0  9999
2 07424  74.0588 118.7917 0038505 332.7615 200.2759 12.67170510306041
0 SL-8 R/B
1 07426U 74069B   24187.05742799  .00000038  00000-0  28084-3 0  9996
2 07426  74.0573  48.3019 0044547 246.1458 226.8768 12.68844269693777
0 COSMOS 676
1 07433U 74071A   24187.52931235  .00000234  00000-0  94904-4 0  9997
2 07433  74.0495 322.9054 0014043 341.2508  18.8124 14.33063863600881
0 SL-8 R/B
1 07434U 74071B   24187.37915654  .00000284  00000-0  10348-3 0  9992
2 07434  74.0450 163.1804 0020065 161.3545 198.8348 14.37480756606267
0 COSMOS 677
1 07435U 74072A   24187.43271141 -.00000002  00000-0  82705-4 0  9993
2 07435  74.0323 193.6573 0044032  53.6410  55.5558 12.58010924286670
0 COSMOS 678
1 07436U 74072B   24187.51129635  .00000010  00000-0  18841-3 0  9990
2 07436  74.0326 204.1278 0041951 342.3337 132.4439 12.41784820257257
0 COSMOS 679
1 07437U 74072C   24187.48079656  .00000000  00000-0  10809-3 0  9999
2 07437  74.0354  87.0491 0028301 221.2843 138.6065 12.44407392261982
0 COSMOS 680
1  7438U 74072D   24187.55848285 -.00000016  00000-0 -22425-6 0  9999
2  7438  74.0367 347.7190 0015592  93.5790 336.8356 12.46628130266233
0 COSMOS 681
1 07439U 74072E   24187.62921890  .00000018  00000-0  22228-3 0  9990
2 07439  74.0335 239.0256 0004140  13.4063 105.9985 12.49055765270471
0 COSMOS 682
1 07440U 74072F   24187.32123966 -.00000027  00000-0 -71002-4 0  9994
2 07440  74.0344 139.0493 0008592  39.6450  76.1831 12.51282060274432
0 COSMOS 683
1 07441U 74072G   24187.58189698  .00000007  00000-0  14593-3 0  9994
2 07441  74.0358  38.6415 0020886 289.4400  70.4396 12.53500827278484
0 COSMOS 684
1 07442U 74072H   24187.61554471 -.00000012  00000-0  26228-4 0  9990
2 07442  74.0368 298.5973 0032464 183.7535 187.6138 12.55703598282428
0 SL-8 R/B
1 07443U 74072J   24187.49244796 -.00000015  00000-0 -46393-5 0  9993
2 07443  74.0361 307.2975 0131770 200.4966 229.0640 12.22816539222828
0 WESTAR 2
1 07466U 74075A   24187.55952104  .00000009  00000-0  00000-0 0  9998
2 07466   8.8543 305.3838 0006950 186.4047 178.1731  0.99861243130557
0 COSMOS 689
1 07476U 74079A   24187.52308966  .00000064  00000-0  53734-4 0  9998
2 07476  82.9434 341.6260 0028932 300.6398 122.7709 13.72270566488761
0 SL-8 R/B
1 07477U 74079B   24187.54586297  .00000078  00000-0  65924-4 0  9995
2 07477  82.9448 298.6436 0034815 128.1929 242.6012 13.74180029492000
0 DELTA 1 DEB
1 07489U 73086FV  24187.46829802 -.00000001  00000-0  38639-3 0  9997
2 07489 102.5562 191.5470 0061102 157.0232   0.6039 12.29666515271830
0 METEOR 1-19
1 07490U 74083A   24187.55369929  .00000321  00000-0  17359-3 0  9996
2 07490  81.1887 115.4153 0028818 294.9983  64.8195 14.10334670554563
0 SL-3 R/B
1 07493U 74083B   24187.40079653  .00000335  00000-0  18378-3 0  9992
2 07493  81.1590 161.0509 0086678  42.0431 318.7346 14.07801826550762
0 NOAA 4
1 07529U 74089A   24187.59112579 -.00000027  00000-0  12388-3 0  9997
2 07529 101.9872 182.0220 0009389 111.8662 358.2614 12.53181297270380
0 OSCAR 7
1 07530U 74089B   24187.59305388 -.00000031  00000-0  97738-4 0  9999
2 07530 101.9780 182.4135 0012570  50.4162  64.3631 12.53676702271349
0 INTASAT
1 07531U 74089C   24187.59367182 -.00000031  00000-0  98370-4 0  9993
2 07531 101.9782 181.6686 0011783  60.5579  58.5778 12.53500704271113
0 THORAD DELTA 1 R/B
1 07532U 74089D   24187.53320537 -.00000028  00000-0  10315-3 0  9999
2 07532 101.5883 170.1020 0067200  98.0864  16.3661 12.39899591246827
0 INTELSAT 4-F8
1 07544U 74093A   24186.98153657  .00000130  00000-0  00000-0 0  9992
2 07544   9.4850 309.9210 0006597 172.6948 193.2993  0.99784737118107
0 ATLAS CENTAUR R/B
1 07545U 74093B   24186.52111645  .00000097  00000-0  22402-2 0  9998
2 07545  26.1549 292.8674 7186135 277.3959  13.3829  2.21201959271121
0 SKYNET 2B
1 07547U 74094A   24186.97962208  .00000149  00000-0  00000-0 0  9995
2 07547   5.3672 287.6666 0005280 186.9027 190.6995  1.00194797117621
0 OPS 6630 DEB
1 07559U 73088E   24185.29209550 -.00000021  00000-0 -17895-4 0  9993
2 07559  96.8044 281.8704 0048427 178.3037 247.7609 12.56067588321035
0 SL-8 DEB
1 07560U 72062D   24187.44247032  .00000552  00000-0  31590-3 0  9996
2 07560  82.9764 356.3775 0064605 240.3663 119.1066 14.06925150539472
0 METEOR 1-20
1 07574U 74099A   24187.60229728  .00000152  00000-0  76556-4 0  9991
2 07574  81.2348 295.0092 0016995 162.0039 198.1738 14.11778701550047
0 SL-3 R/B
1 07575U 74099B   24187.49207518  .00000261  00000-0  13560-3 0  9998
2 07575  81.2470 322.8304 0050525 167.7681 192.4731 14.11331804549587
0 SYMPHONIE 1
1 07578U 74101A   24187.04895947  .00000074  00000-0  00000-0 0  9999
2 07578   6.3966 285.9337 0002139 194.1385 199.2777  0.99957795110084
0 COSMOS 700
1 07593U 74105A   24187.56369375  .00000095  00000-0  80907-4 0  9999
2 07593  82.9500 216.2239 0025689 131.7591 340.5920 13.76872402487352
0 SL-8 R/B
1 07594U 74105B   24187.49954102  .00000028  00000-0  12289-4 0  9994
2 07594  82.9473 168.9154 0015539 328.9962 147.6504 13.79083481490673
0 LANDSAT 2
1 07615U 75004A   24187.49167044 -.00000216  00000-0 -12481-3 0  9992
2 07615  98.9341 147.6670 0009528 105.6012 254.6203 13.96839503519762
0 DELTA 1 R/B
1 07616U 75004B   24187.43245854  .00000036  00000-0  36225-4 0  9994
2 07616  97.7366 332.1839 0187499  48.1051 313.5944 14.05638999520387
0 COSMOS 706
1 07625U 75007A   24186.78533532  .00000823  00000-0  00000-0 0  9999
2 07625  63.9486 227.7189 6718191   3.4037 359.7077  2.00435106222144
0 SL-6 R/B(2)
1  7629U 75007D   24182.51035706  .00000528  00000-0  00000+0 0  9991
2  7629  68.8923 267.5316 5570549 316.3910  68.8566  2.00911677223649
0 STARLETTE
1 07646U 75010A   24187.51061099 -.00000128  00000-0  98867-5 0  9994
2 07646  49.8260  33.6803 0205646 231.9906 126.2262 13.82328841496099
0 DIAMANT B-P4 R/B
1 07647U 75010B   24187.44912351 -.00000040  00000-0  81860-4 0  9990
2 07647  49.8229 236.9922 0217704  55.9590 306.1768 13.82086746492592
0 SMS 2
1 07648U 75011A   24186.97840376  .00000030  00000-0  00000-0 0  9997
2 07648   7.2613 291.0746 0013695 243.7083 123.9515  0.99512067128596
0 DIAMANT B-P4 DEB
1 07654U 75010C   24187.39144443  .00000122  00000-0  17427-3 0  9998
2 07654  49.8429 175.2827 0173497 216.9035 141.9822 13.95132524510557
0 DIAMANT B-P4 DEB
1 07655U 75010D   24187.44953805  .00000218  00000-0  23993-3 0  9996
2 07655  49.7999 213.6595 0180154 339.2864  20.0798 13.94097663508970
0 DIAMANT B-P4 DEB
1 07659U 75010E   24186.96003621  .00000618  00000-0  50674-3 0  9998
2 07659  49.8150  73.1679 0187191  94.1785 268.0528 13.93197778506018
0 COSMOS 708
1 07663U 75012A   24187.55744286 -.00000017  00000-0  12631-3 0  9995
2 07663  69.2326 267.3574 0022773  45.1873  55.8189 12.68287082287293
0 SL-8 R/B
1 07665U 75012B   24187.35253993 -.00000088  00000-0 -23304-3 0  9993
2 07665  69.2265 148.1690 0021170 358.5777 113.5007 12.70451720290599
0 COSMOS 711
1 07678U 75016A   24187.62659520  .00000001  00000-0  11895-3 0  9992
2 07678  74.0043 281.5543 0020243 262.6401 205.5280 12.47068555246623
0 COSMOS 712
1 07679U 75016B   24187.56727240 -.00000015  00000-0  10462-4 0  9997
2 07679  74.0050 355.6406 0050553 268.7215 162.9339 12.53447122258082
0 COSMOS 713
1 07680U 75016C   24187.54071219  .00000018  00000-0  20635-3 0  9999
2 07680  74.0028 255.9959 0058056 145.5304 324.9637 12.55657221262071
0 COSMOS 714
1 07681U 75016D   24187.41811786 -.00000004  00000-0  79068-4 0  9998
2 07681  74.0007 182.4590 0029117 134.8130 337.2265 12.49286505250637
0 COSMOS 715
1 07682U 75016E   24187.57011341  .00000000  00000-0  11169-3 0  9997
2 07682  74.0040  25.2546 0021795  56.5342   6.7693 12.44729876813332
0 COSMOS 716
1 07683U 75016F   24187.56581985 -.00000028  00000-0 -87587-4 0  9993
2 07683  74.0029 127.3363 0022261 208.9469 325.9012 12.42432833238281
0 COSMOS 717
1 07684U 75016G   24187.60381833  .00000018  00000-0  25152-3 0  9995
2 07684  74.0020 242.8251 0035733 348.0099 126.2977 12.39819471233645
0 COSMOS 718
1 07685U 75016H   24187.45432594 -.00000006  00000-0  61904-4 0  9994
2 07685  74.0040  89.1052 0038545  16.2311 158.6369 12.51377030254353
0 SL-8 R/B
1 07686U 75016J   24187.58207069  .00000039  00000-0  49470-3 0  9994
2 07686  74.0026 343.2447 0164305 215.7836 213.0305 12.21108055199374
0 TITAN 34B R/B
1  7688U 75017B   24186.89311345  .00010427  00000-0  10158-2 0  9995
2  7688  63.2605 156.0045 5656633 268.9136  29.4899  4.59976474 81200
0 METEOR 1-21
1 07714U 75023A   24187.54785988  .00000100  00000-0  51235-4 0  9993
2 07714  81.2062 203.8077 0029475 197.0436 162.9747 14.08281863847369
0 SL-3 R/B
1 07715U 75023B   24187.55687952  .00000202  00000-0  11190-3 0  9995
2 07715  81.2199 250.2870 0051298  86.6701 274.0335 14.07001975527450
0 COSMOS 723
1 07718U 75024A   24187.55782379 -.00000052  00000-0  32364-4 0  9999
2 07718  64.7179  15.6514 0054315 216.0841 143.6550 13.89585872499890
0 COSMOS 724
1 07727U 75025A   24187.46205016 -.00000036  00000-0  35092-4 0  9991
2 07727  65.5899 106.7377 0045364  86.3000 274.3258 13.99029434516127
0 GEOS 3
1  7734U 75027A   24187.55319904 -.00000032  00000-0  68633-4 0  9996
2  7734 114.9872 127.6683 0026568 254.8908 104.9230 14.18924191548546
0 DELTA 1 R/B
1 07735U 75027B   24187.55025919  .00000075  00000-0  10721-3 0  9997
2 07735 114.9720 120.9575 0033857 178.1211 182.0002 14.25108329557043
0 COSMOS 726
1  7736U 75028A   24187.56370513  .00000087  00000-0  70817-4 0  9999
2  7736  82.9952  28.1836 0024545 244.6873 115.1742 13.78344487475907
0 SL-8 R/B
1 07737U 75028B   24187.52379759  .00000144  00000-0  12191-3 0  9991
2 07737  82.9935 345.5939 0019454  95.8480 326.1511 13.80658022478864
0 COSMOS 729
1 07768U 75034A   24187.57748228  .00000071  00000-0  60502-4 0  9997
2 07768  82.9648 294.6221 0022609 348.2242  22.3352 13.73535547465349
0 SL-8 R/B
1 07769U 75034B   24187.61127319  .00000117  00000-0  10652-3 0  9996
2 07769  82.9614 260.3896 0017916 207.9962 263.3470 13.75034855467917
0 MOLNIYA 1-29
1 07780U 75036A   24186.91384499  .00000131  00000-0 -49841-1 0  9994
2 07780  63.4737 137.7035 6711381 283.7872  14.5006  2.00580934360639
0 ANIK A3 (TELESAT-3)
1 07790U 75038A   24186.58381841  .00000110  00000-0  00000-0 0  9997
2 07790   9.2415 308.2894 0003354 160.5932 222.3635  1.00056132122838
0 SL-6 R/B(2)
1 07800U 75036D   24186.16052525  .00001121  00000-0  00000-0 0  9998
2 07800  63.7542 212.8703 6924373 288.8615  11.8625  1.96846353353154
0 INTELSAT 4-F1
1 07815U 75042A   24186.81258247 -.00000076  00000-0  00000-0 0  9991
2 07815   9.7494 311.3673 0012041 241.9087 118.0761  0.99258072114887
0 OPS 6226
1 07816U 75043A   24187.55368640  .00000420  00000-0  19689-3 0  9992
2 07816  98.6760  33.4925 0053570  90.1641 270.5677 14.24499422258490
0 THOR BURNER 2 R/B
1 07817U 75043B   24187.55821688  .00000158  00000-0  94593-4 0  9995
2 07817  98.7418  33.7776 0053487   1.6185 358.5155 14.19472588262420
0 COSMOS 732
1 07820U 75045A   24187.57443079  .00000017  00000-0  19781-3 0  9996
2 07820  74.0157 232.5873 0042687 188.0576 286.1301 12.56705538252872
0 COSMOS 733
1 07822U 75045B   24187.60285816 -.00000020  00000-0 -37079-4 0  9992
2 07822  74.0194 304.5737 0053041 167.9117 204.7596 12.38826402220889
0 COSMOS 734
1 07823U 75045C   24187.53717738  .00000000  00000-0  99469-4 0  9995
2 07823  74.0180  92.8553 0017503  94.5723  79.2921 12.51780937244014
0 COSMOS 735
1 07824U 75045D   24187.54619980  .00000005  00000-0  13895-3 0  9990
2 07824  74.0147 201.0171 0008529 258.1001 221.7560 12.49352378239707
0 COSMOS 736
1 07825U 75045E   24187.59599727 -.00000025  00000-0 -66888-4 0  9997
2 07825  74.0196 311.0171 0010255 114.3348 257.0170 12.46871835235245
0 COSMOS 737
1 07826U 75045F   24187.47186454 -.00000013  00000-0  17602-4 0  9990
2 07826  74.0149 177.3747 0036951  27.4718  92.4961 12.41729306225992
0 COSMOS 738
1 07827U 75045G   24187.17131184 -.00000002  00000-0  99515-4 0  9999
2 07827  74.0180  68.0885 0025767 249.3278 229.4335 12.44225455230448
0 COSMOS 739
1 07828U 75045H   24187.58838238 -.00000022  00000-0 -36980-4 0  9999
2 07828  74.0192 345.2499 0031388 329.0573  99.6402 12.54188811248360
0 SL-8 R/B
1 07831U 75045J   24187.56868792 -.00000032  00000-0 -16786-3 0  9991
2 07831  73.9885 325.9720 0130865  44.6937  28.5571 12.20903089188385
0 DELTA 1 DEB
1 07836U 72058G   24187.45418532  .00001229  00000-0  59660-3 0  9993
2 07836  98.0327  85.9668 0327416 144.7219 217.6102 13.95282674539584
0 DELTA 1 DEB
1 07838U 72058J   24187.47830255  .00000601  00000-0  28367-3 0  9990
2 07838  98.0657 351.6153 0316157 356.4549   3.4380 13.99831191470336
0 DELTA 1 DEB
1 07839U 72058K   24187.55329842  .00003484  00000-0  69126-3 0  9995
2 07839  98.7456   0.4974 0173007  65.8534 296.0644 14.53806293541373
0 DELTA 1 DEB
1 07846U 72058S   24187.57546412  .00000630  00000-0  15233-3 0  9999
2 07846  98.6748 238.3147 0149701 235.4329 123.2663 14.50404828564876
0 DELTA 1 DEB
1 07849U 72058V   24187.39755291  .00001052  00000-0  47804-3 0  9997
2 07849  98.0079 343.1885 0330021 283.5089  72.9513 13.98584883453533
0 DELTA 1 DEB
1 07850U 72058W   24187.41796528  .00006403  00000-0  13808-2 0  9991
2 07850  98.2008 139.7932 0184525 107.6544 254.4892 14.48609567516618
0 DELTA 1 DEB
1 07890U 72058BG  24187.59235352  .00012117  00000-0  17704-2 0  9995
2 07890  98.8880 213.4435 0136312 120.3115 241.1655 14.69684037535126
0 DELTA 1 DEB
1 07892U 72058BJ  24187.47910893  .00001982  00000-0  32403-3 0  9996
2 07892  98.5802  90.0843 0105362 159.5842 200.9621 14.68467576580495
0 DELTA 1 DEB
1 07893U 72058BK  24187.43404412  .00001379  00000-0  79833-3 0  9996
2 07893  97.7741 348.1583 0398772 167.5258 193.6131 13.76683496433856
0 ATLAS CENTAUR R/B
1 07902U 75042B   24185.83474989  .00000099  00000-0  12405-2 0  9990
2 07902  25.2962 132.6123 7196777 250.9126  23.7649  2.21088133265229
0 DELTA 1 DEB
1 07907U 72058BS  24187.61459866  .00001127  00000-0  49791-3 0  9996
2 07907  97.7163  69.5159 0275248 137.1122 225.1878 14.06490610479428
0 NIMBUS 6
1 07924U 75052A   24187.62267473 -.00000026  00000-0  34459-4 0  9998
2 07924 100.0255  96.8909 0008304 137.7351 283.8712 13.40777399400779
0 DELTA 1 DEB
1 07933U 72058CB  24187.60841232  .00003808  00000-0  11230-2 0  9990
2 07933  99.0073 190.4847 0296497  47.9122 314.6864 14.21651233494813
0 OPS 6381 (SSU 1)
1 07937U 75051C   24187.40468417  .00000016  00000-0  13372-3 0  9996
2 07937  95.0842 239.5095 0005272 252.4865 120.1332 12.68229520271152
0 SSU 1 DEB
1 07938U 75051D   24186.30476734  .00000040  00000-0  24202-3 0  9997
2 07938  94.9816 133.4952 0037391 216.8508 298.3273 12.72181245277526
0 SSU 1 DEB
1 07939U 75051E   24187.39872976  .00000002  00000-0  66763-4 0  9993
2 07939  95.1816 339.4774 0026737  38.3028  18.1256 12.64566501264322
0 DELTA 1 DEB
1 07940U 72058CF  24187.52171027  .00002271  00000-0  86446-3 0  9992
2 07940  98.0567 281.9856 0331007 148.7565 213.3753 14.05628750620893
0 DELTA 1 R/B
1 07946U 75052B   24187.57555962  .00000028  00000-0  10607-3 0  9998
2 07946  99.7138  86.5764 0045538 349.8077  73.1747 13.53721164638867
0 DELTA 1 DEB
1 07957U 72058CM  24187.60131511  .00000966  00000-0  52026-3 0  9999
2 07957  98.9883  82.0144 0521288 251.4529 102.9322 13.62392137712048
0 DELTA 1 DEB
1 07958U 72058CN  24187.58549836  .00003369  00000-0  15483-2 0  9995
2 07958  97.6981 129.6449 0305430  11.2048 349.5723 13.99893385606561
0 DELTA 1 DEB
1 07959U 72058CP  24187.53561331  .00001688  00000-0  66118-3 0  9999
2 07959  97.9427 181.4238 0239259 317.0747  41.1972 14.16182348647364
0 ATLAS AGENA R/B
1 07964U 75055B   24187.08456877 -.00000171  00000-0  00000-0 0  9995
2 07964  11.0872 250.6674 1200777 111.2970 262.0402  1.02090994 19428
0 DELTA 1 DEB
1 07979U 72058DA  24187.37124258  .00000379  00000-0  26040-3 0  9992
2 07979  97.8488 327.9123 0406691 305.0416 104.7249 13.70545600443762
0 DELTA 1 DEB
1 08004U 72058DF  24187.46376518  .00001952  00000-0  55422-3 0  9994
2 08004  97.6360 262.1689 0197580 286.5044  71.4520 14.35634799672395
0 SL-6 R/B(2)
1  8018U 75063D   24186.60600023  .00000042  00000-0  36772-3 0  9990
2  8018  63.1199  81.8015 6588386 303.7457  10.0193  2.70749239362349
0 METEOR 2-1
1 08026U 75064A   24187.60310418  .00000039  00000-0  14338-4 0  9998
2 08026  81.2796 353.8990 0022501  77.2606 283.1078 14.10578146519018
0 SL-3 R/B
1 08027U 75064B   24187.48033352  .00000083  00000-0  41535-4 0  9992
2 08027  81.2958  95.0293 0055564 209.4762 150.3272 14.07563100514440
0 SL-3 DEB
1 08039U 75064C   24187.55843975  .00000287  00000-0  15771-3 0  9991
2 08039  81.2951  39.6701 0019309  72.3029 288.0248 14.09138525517451
0 COSMOS 755
1 08072U 75074A   24187.57849549  .00000088  00000-0  78137-4 0  9999
2 08072  82.9044 253.9209 0027045 327.9761 142.7973 13.74107989450774
0 SL-8 R/B
1 08073U 75074B   24187.58426951  .00000063  00000-0  49322-4 0  9996
2 08073  82.8989 204.8102 0022572 130.7700 343.6405 13.76156820454149
0 DELTA 1 DEB
1 08084U 72058DK  24187.43073887  .00000888  00000-0  55967-3 0  9993
2 08084  98.5932 347.7786 0547011  41.9926 322.1833 13.50625575525484
0 SL-3 DEB
1 08110U 75064D   24187.44311018  .00000062  00000-0  27296-4 0  9994
2 08110  81.3477  88.8891 0032347 233.2502 126.5699 14.11274949521143
0 SYMPHONIE 2
1 08132U 75077A   24187.55949715 -.00000202  00000-0  00000-0 0  9992
2 08132   5.8687 283.8458 0001014  97.7193 259.6494  0.99984830135334
0 DELTA 1 R/B(2)
1 08134U 75077C   24187.61446690  .00001389  00000-0  20847-2 0  9994
2 08134  13.6994 326.1511 7145295 334.7839   2.8691  2.39881972264411
0 THORAD DELTA 1 DEB
1 08136U 74089E   24187.59911227 -.00000020  00000-0  11912-3 0  9994
2 08136 101.0512 202.9105 0074694  57.9238  59.9126 12.64778783 15824
0 THORAD DELTA 1 DEB
1 08137U 74089F   24186.82745663  .00000162  00000-0  10047-2 0  9992
2 08137 101.1499 128.5189 0091172 188.0766 196.3201 12.71021551300220
0 THORAD DELTA 1 DEB
1 08139U 74089H   24187.55470463 -.00000007  00000-0  20856-3 0  9997
2 08139 101.5087 148.2275 0049957 340.9633 134.9323 12.61874364285345
0 THORAD DELTA 1 DEB
1 08140U 74089J   24187.61372193 -.00000041  00000-0  26348-4 0  9998
2 08140 101.9323 137.6116 0043674 106.9203  65.8466 12.46690008258808
0 THORAD DELTA 1 DEB
1 08141U 74089K   24187.58171546  .00000030  00000-0  55458-3 0  9994
2 08141 101.4061  39.3578 0089654 340.8607  85.2980 12.36291456239526
0 THORAD DELTA 1 DEB
1  8142U 74089L   24187.56567788  .00002580  00000-0  15572-1 0  9993
2  8142 101.0898 122.5987 0352419 284.7427 254.5420 12.41145188193893
0 THORAD DELTA 1 DEB
1 08143U 74089M   24187.37530071  .00000127  00000-0  90579-3 0  9995
2 08143 101.6862 163.0408 0193462 159.7871 201.0998 12.61225675282982
0 THORAD DELTA 1 DEB
1 08144U 74089N   24187.60794199  .00000079  00000-0  73431-3 0  9999
2 08144 101.6749 136.7189 0152339 143.1784  31.7815 12.53796349270163
0 THORAD DELTA 1 DEB
1 08145U 74089P   24187.56424088  .00000160  00000-0  11577-2 0  9995
2 08145 101.1806  58.0188 0027403 126.9520 300.5204 12.60398992280595
0 THORAD DELTA 1 DEB
1 08146U 74089Q   24187.54078442  .00000010  00000-0  32312-3 0  9998
2 08146 101.9362 166.1242 0186688  66.7542  47.8996 12.54815094271857
0 THORAD DELTA 1 DEB
1 08151U 74089R   24187.47305998 -.00000091  00000-0 -14629-3 0  9997
2 08151 101.7915 259.9554 0336669  52.2127  64.3581 12.81098610317646
0 THORAD DELTA 1 DEB
1 08152U 74089S   24187.49731817  .00000012  00000-0  33597-3 0  9999
2 08152 101.8190 178.1066 0058884 297.7049 182.7339 12.60002233281045
0 THORAD DELTA 1 DEB
1 08153U 74089T   24183.89656644  .00000087  00000-0  12056-2 0  9992
2 08153 100.9398 320.1056 0282888 227.5581 288.4942 12.09288745191837
0 THORAD DELTA 1 DEB
1 08154U 74089U   24187.46316800 -.00000031  00000-0  97944-4 0  9998
2 08154 102.0291 174.1713 0005235 221.9593 290.5306 12.52406342269040
0 THORAD DELTA 1 DEB
1 08156U 74089W   24186.85204670 -.00000088  00000-0 -20833-3 0  9998
2 08156 101.8511 144.2491 0058061 325.2346  91.4130 12.67996729293009
0 THORAD DELTA 1 DEB
1 08157U 74089X   24187.44850464 -.00000002  00000-0  28497-3 0  9992
2 08157 102.0971 175.1045 0133886  82.0537  71.8266 12.47428640259093
0 THORAD DELTA 1 DEB
1 08158U 74089Y   24186.16500141  .00000065  00000-0  61338-3 0  9994
2 08158 101.4834 259.7772 0064520 188.1681 200.0900 12.61560396283816
0 THORAD DELTA 1 DEB
1 08159U 74089Z   24187.55190272  .00002893  00000-0  15461-1 0  9994
2 08159 101.4254 207.8646 0008014 183.9646 176.1373 12.66729472268623
0 THORAD DELTA 1 DEB
1 08160U 74089AA  24187.31169737 -.00000027  00000-0  99146-4 0  9995
2 08160 101.7374 306.0372 0145398  41.2948  16.8743 12.63453634287956
0 THORAD DELTA 1 DEB
1 08161U 74089AB  24187.56953914 -.00000055  00000-0 -19137-3 0  9994
2 08161 101.2317 312.7813 0364297 342.6341  75.8971 11.99064175502379
0 THORAD DELTA 1 DEB
1 08162U 74089AC  24187.25632267  .00001493  00000-0  99687-2 0  9998
2 08162 100.7709 112.7198 0136882 171.0926 345.2693 12.48189574230901
0 THORAD DELTA 1 DEB
1 08163U 74089AD  24187.54718400  .00001205  00000-0  80815-2 0  9999
2 08163 102.4939 180.2768 0315179 275.7552  80.7661 12.38322010222555
0 THORAD DELTA 1 DEB
1 08164U 74089AE  24187.41310714 -.00000033  00000-0  69379-4 0  9995
2 08164 101.5348 343.1875 0120589 232.8598 185.5100 12.28951495227171
0 THORAD DELTA 1 DEB
1 08165U 74089AF  24187.35883500  .00000055  00000-0  64631-3 0  9995
2 08165 101.6225 136.7665 0018301 165.0336 349.7219 12.50099192263813
0 THORAD DELTA 1 DEB
1 08166U 74089AG  24179.70785399  .00000122  00000-0  10842-2 0  9992
2 08166 101.9567 160.9010 0037789 288.4559 247.9120 12.51466466263944
0 THORAD DELTA 1 DEB
1 08167U 74089AH  24187.36319696  .00003503  00000-0  76114-2 0  9997
2 08167 101.4184 323.5244 0130593  88.2040 330.3938 13.26870133332651
0 THORAD DELTA 1 DEB
1 08168U 74089AJ  24187.40794704 -.00000020  00000-0  15941-3 0  9994
2 08168 101.8515 142.6973 0020173 202.8240 279.8087 12.52705648269412
0 THORAD DELTA 1 DEB
1 08169U 74089AK  24187.63316044  .00001832  00000-0  66843-2 0  9994
2 08169 102.5271  73.2890 0148378 126.3637 291.6435 12.91935377308796
0 THORAD DELTA 1 DEB
1  8170U 74089AL  24186.50687475  .00013337  00000-0  10598-1 0  9998
2  8170 101.5806  12.3503 0085569  55.5037   7.4616 13.89637622389710
0 THORAD DELTA 1 DEB
1 08172U 74089AN  24187.57767047 -.00000029  00000-0  10550-3 0  9997
2 08172 101.9826 185.9205 0053278  13.0970 100.2838 12.54903952273556
0 THORAD DELTA 1 DEB
1 08173U 74089AP  24186.88866689 -.00000013  00000-0  20531-3 0  9996
2 08173 101.8992 155.8345 0110306  44.5708  14.9745 12.51724087265865
0 THORAD DELTA 1 DEB
1 08174U 74089AQ  24187.19495252  .00000078  00000-0  77716-3 0  9993
2 08174 101.8726 163.4931 0063909 252.6162 120.5974 12.53313382269034
0 THORAD DELTA 1 DEB
1  8175U 74089AR  24186.59517420  .00002867  00000-0  15156-1 0  9995
2  8175 102.5164  59.3388 0198694 306.3229  80.9682 12.62036213239632
0 THORAD DELTA 1 DEB
1 08177U 74089AT  24187.54496727 -.00000216  00000-0 -18904-2 0  9992
2 08177 101.0659  32.2364 0262792 355.5350  59.1120 12.05287283183997
0 THORAD DELTA 1 DEB
1 08178U 74089AU  24187.33213615  .00001972  00000-0  11846-1 0  9998
2 08178 102.1989 220.8222 0179562 270.6045 100.5900 12.54163663236562
0 THORAD DELTA 1 DEB
1 08179U 74089AV  24187.34665553 -.00000005  00000-0  28492-3 0  9996
2 08179 101.4558 334.5385 0101007 146.7647 242.3342 12.33817315235099
0 THORAD DELTA 1 DEB
1 08180U 74089AW  24187.37190740  .00000078  00000-0  84863-3 0  9995
2 08180 100.8505 328.9665 0111360  75.6492 340.3178 12.39874990244910
0 THORAD DELTA 1 DEB
1 08181U 74089AX  24187.57416884  .00000026  00000-0  51407-3 0  9999
2 08181 101.6334 312.3574 0067031 264.2984 109.2107 12.40199797246152
0 THORAD DELTA 1 DEB
1  8182U 74089AY  24186.60194579  .00002438  00000-0  10640-1 0  9998
2  8182 100.3966 308.9988 0151351 188.2408 185.8796 12.78206854276077
0 THORAD DELTA 1 DEB
1 08183U 74089AZ  24186.67452012  .00000099  00000-0  10930-2 0  9999
2 08183 100.8479  86.2707 0107702  67.0205 349.9685 12.32879423232965
0 THORAD DELTA 1 DEB
1 08184U 74089BA  24187.54091777 -.00000027  00000-0  10355-3 0  9998
2 08184 101.4345 167.6086 0064481  45.4289  72.2051 12.47559736260161
0 THORAD DELTA 1 DEB
1 08185U 74089BB  24187.33316770  .00000067  00000-0  80416-3 0  9997
2 08185 101.4838 133.5620 0070749  67.6181  88.4000 12.40385218246494
0 MOLNIYA 2-14
1 08195U 75081A   24186.88080995  .00000303  00000-0  00000-0 0  9998
2 08195  63.6603 110.5414 6710632 288.6712  13.1194  2.02103704358019
0 KIKU 1 (ETS 1)
1 08197U 75082A   24187.48714490 -.00000091  00000-0  45955-4 0  9999
2 08197  46.9868 218.4853 0085761 182.4440 321.1919 13.59564338425575
0 COSMOS 761
1 08285U 75086A   24187.62531360  .00000005  00000-0  12711-3 0  9997
2 08285  74.0091 263.3490 0052027  67.8712  40.7236 12.55798067237172
0 COSMOS 762
1 08286U 75086B   24187.54453946 -.00000022  00000-0 -39356-4 0  9998
2 08286  74.0094 122.1430 0029792 332.1379 201.2050 12.50888125228383
0 COSMOS 763
1 08287U 75086C   24187.49384640  .00000000  00000-0  10795-3 0  9996
2 08287  74.0097  85.3292 0022385  74.7962  99.6577 12.43547233215283
0 COSMOS 764
1 08288U 75086D   24187.46561248  .00000001  00000-0  12024-3 0  9993
2 08288  74.0065 193.4695 0030520 225.8101 248.6534 12.41075082210944
0 COSMOS 765
1 08289U 75086E   24187.59824307 -.00000017  00000-0 -10803-4 0  9999
2 08289  74.0116 315.5076 0045877   2.7649   9.8121 12.38275150206007
0 COSMOS 766
1 08290U 75086F   24187.59629609 -.00000001  00000-0  96446-4 0  9998
2 08290  74.0105  15.6594 0042529 208.3847 209.1802 12.53279932232611
0 COSMOS 767
1 08291U 75086G   24187.55795767  .00000023  00000-0  26201-3 0  9998
2 08291  74.0070 227.1739 0019242 112.6873   2.6935 12.48508597224155
0 COSMOS 768
1  8292U 75086H   24187.56420606 -.00000024  00000-0 -56952-4 0  9997
2  8292  74.0116 333.6678 0013283 272.8503 158.7519 12.46098691220109
0 METEOR 1-22
1 08293U 75087A   24187.61219067  .00000234  00000-0  11643-3 0  9990
2 08293  81.2574 320.2375 0075025 190.5857 169.3741 14.12618227512594
0 SL-3 R/B
1 08294U 75087B   24187.57729078  .00000012  00000-0  41774-6 0  9999
2 08294  81.2121  32.0942 0103539 335.7022  23.9283 14.08873690507187
0 SL-8 R/B
1  8295U 75086J   24187.55206238 -.00000014  00000-0 -40515-5 0  9990
2  8295  74.0126 284.4082 0126547  81.4933 299.4242 12.22063987177587
0 THORAD DELTA 1 DEB
1 08296U 74089BD  24185.68080536  .00000423  00000-0  35656-2 0  9995
2 08296 102.5028 347.0790 0216223  19.8216 354.2370 12.32695463260517
0 THORAD DELTA 1 DEB
1 08299U 74089BG  24187.34066010  .00010567  00000-0  69381-2 0  9996
2 08299 102.1277 157.0703 0439982 336.0869  22.0368 13.63728126375491
0 THORAD DELTA 1 DEB
1 08300U 74089BH  24186.71265920  .00000926  00000-0  99126-2 0  9998
2 08300 100.9009 254.2289 0352546 204.6134 313.5497 12.00158301456647
0 THORAD DELTA 1 DEB
1 08301U 74089BJ  24187.27740237  .00022828  00000-0  98693-2 0  9993
2 08301 102.9702 304.1017 0206434  33.1181 328.2708 14.13619318445490
0 THORAD DELTA 1 DEB
1 08303U 74089BL  24183.53963133  .00000277  00000-0  20093-2 0  9995
2 08303 101.3480  41.8406 0034198  87.0525 305.8321 12.53073102263151
0 THORAD DELTA 1 DEB
1 08305U 74089BN  24187.43744204  .00000043  00000-0  66278-3 0  9993
2 08305 101.5255  66.9238 0092867 149.9459  22.7342 12.35150558237203
0 THORAD DELTA 1 DEB
1 08306U 74089BP  24187.56837473  .00000336  00000-0  24551-2 0  9991
2 08306 101.9616 308.7184 0073961  50.5449 323.8149 12.50827333257959
0 THORAD DELTA 1 DEB
1 08307U 74089BQ  24187.45112770  .00000033  00000-0  81449-3 0  9990
2 08307 101.1339 357.4729 0453464  72.6617 344.6223 11.75113742129693
0 THORAD DELTA 1 DEB
1 08308U 74089BR  24187.41769829 -.00000047  00000-0 -23675-4 0  9995
2 08308 101.5973 243.9913 0060868 335.8286  35.2769 12.45537546256435
0 THORAD DELTA 1 DEB
1 08310U 74089BT  24187.59770049 -.00000002  00000-0  29427-3 0  9993
2 08310 101.5154 191.9184 0066953 131.3113 346.2617 12.40328763247194
0 THORAD DELTA 1 DEB
1 08311U 74089BU  24187.48169865 -.00000046  00000-0 -22261-6 0  9991
2 08311 102.0504 147.5957 0036005 260.3308 214.1417 12.45511315256620
0 DELTA 1 DEB
1 08314U 72058EG  24187.52722606  .00003709  00000-0  41372-3 0  9999
2 08314  98.4831   4.1671 0083037  13.2519 347.0848 14.85232791741831
0 DELTA 1 DEB
1 08319U 72058EM  24187.58780031  .00001384  00000-0  30976-3 0  9991
2 08319  98.7026 210.0138 0137702  88.6168 273.0796 14.52702966714274
0 COSMOS 770
1 08325U 75089A   24187.59846714  .00000014  00000-0  83277-6 0  9991
2 08325  82.9589 126.9435 0029892 100.0670  73.3685 13.19773545349525
0 SL-8 R/B
1 08326U 75089B   24187.49989042  .00000073  00000-0  14477-3 0  9991
2 08326  82.9565  89.5882 0023450 326.9357 206.1866 13.21596529352456
0 INTELSAT 4A-F1
1 08330U 75091A   24187.54421745 -.00000347  00000-0  00000-0 0  9995
2 08330   9.3867 309.6554 0006484 208.7227  92.9509  0.99934377114350
0 ATLAS CENTAUR R/B
1 08331U 75091B   24186.64619590  .00000052  00000-0  29634-2 0  9991
2 08331  22.2080  55.2484 7215617  80.0862 347.6103  2.22083403392958
0 COSMOS 773
1 08343U 75094A   24187.54722401  .00000205  00000-0  80325-4 0  9999
2 08343  74.0535 220.4226 0011927 218.9083 141.1212 14.35472626550230
0 SL-8 R/B
1 08344U 75094B   24187.61647843  .00000444  00000-0  14920-3 0  9996
2 08344  74.0564  58.6465 0020980  32.6745 327.5703 14.39884990555914
0 N-1 R/B
1 08352U 75082B   24187.57734162 -.00000089  00000-0  46544-4 0  9992
2 08352  46.9874 115.0330 0085604 286.3534 246.0258 13.60990754426974
0 COSMOS 775
1 08357U 75097A   24187.19695234  .00000144  00000-0  00000-0 0  9991
2 08357   4.2023 274.6004 0013467 169.5834 313.0632  1.00317405124620
0 GOES 1 (SMS-C)
1 08366U 75100A   24187.45783278 -.00000067  00000-0  00000-0 0  9996
2 08366   6.4198 286.3010 0002166 278.0783 135.4994  1.00316666177934
0 THORAD DELTA 1 DEB
1 08394U 74089BW  24187.39393036  .00000015  00000-0  52475-3 0  9992
2 08394 102.1466 223.0438 0175685 134.6065 241.6205 12.20377456852636
0 THORAD DELTA 1 DEB
1 08395U 74089BX  24186.79001089  .00001890  00000-0  96815-2 0  9997
2 08395 100.8348 185.4938 0065178 192.3914 343.7740 12.69735215473312
0 THORAD DELTA 1 DEB
1 08396U 74089BY  24187.14424795 -.00000066  00000-0 -14233-3 0  9992
2 08396 102.2094 249.2994 0063360 324.1341 103.7970 12.42721478254300
0 THORAD DELTA 1 DEB
1 08398U 74089CA  24187.53308172 -.00000031  00000-0  12302-3 0  9993
2 08398 102.5121 163.8632 0077163 152.1684 321.3831 12.26574373977972
0 THORAD DELTA 1 DEB
1 08399U 74089CB  24187.48815058  .00000011  00000-0  39265-3 0  9998
2 08399 101.6709 181.7096 0154565 216.6577 299.9140 12.38794551246996
0 THORAD DELTA 1 DEB
1 08400U 74089CC  24187.50700780  .00000080  00000-0  86494-3 0  9991
2 08400 101.6952 159.0067 0052811  80.7938  45.8407 12.44750114256525
0 THORAD DELTA 1 DEB
1 08401U 74089CD  24185.73878538  .00000009  00000-0  28082-3 0  9992
2 08401 101.4752 258.6082 0066270  48.8037  76.6220 12.67011700294921
0 THORAD DELTA 1 DEB
1 08403U 74089CF  24187.29398698  .00000067  00000-0  75000-3 0  9997
2 08403 101.5124 303.5213 0053653 329.2075  58.3639 12.46928018260764
0 THORAD DELTA 1 DEB
1 08404U 74089CG  24187.49573274  .00002493  00000-0  79749-2 0  9993
2 08404 100.5916 151.4244 0088142   4.7379 120.6790 13.02569501304457
0 THORAD DELTA 1 DEB
1  8405U 74089CH  24186.92839219  .00000032  00000-0  10554-2 0  9991
2  8405 102.6809 183.6942 0699671 123.8402 243.1205 11.30192012 51379
0 THORAD DELTA 1 DEB
1 08406U 74089CJ  24187.53255631  .00000410  00000-0  27021-2 0  9997
2 08406 101.3567  61.6439 0015587 130.1609 298.2544 12.57395513272576
0 THORAD DELTA 1 DEB
1 08407U 74089CK  24187.49252132  .00000274  00000-0  15081-2 0  9997
2 08407 101.5037 160.7578 0231142 129.8841 351.7898 12.66701323295253
0 COSMOS 778
1 08419U 75103A   24187.51766479  .00000076  00000-0  63368-4 0  9998
2 08419  82.9745  98.6779 0022964  44.1202 128.4036 13.74741999440805
0 SL-8 R/B
1 08421U 75103B   24187.59042273  .00000143  00000-0  12978-3 0  9993
2 08421  82.9727  52.6615 0022088 225.4494 194.8920 13.76922762443185
0 THORAD DELTA 1 DEB
1 08435U 74089CL  24187.21255493 -.00000029  00000-0  97942-4 0  9998
2 08435 101.6465  97.6967 0166464  33.0228 122.1730 12.20792257212350
0 THORAD DELTA 1 DEB
1 08436U 74089CM  24187.32664873 -.00000046  00000-0 -24446-4 0  9996
2 08436 101.6989 318.3448 0086797 304.7382 112.9572 12.35406969238771
0 THORAD DELTA 1 DEB
1 08437U 74089CN  24187.39312677 -.00000005  00000-0  24221-3 0  9990
2 08437 101.8620 171.0286 0045436  60.5074 106.3820 12.58236475279013
0 THORAD DELTA 1 DEB
1 08438U 74089CP  24187.21925031  .00005433  00000-0  43647-2 0  9997
2 08438 101.6956 289.9020 0103560 196.3309 163.4493 13.88707043428262
0 THORAD DELTA 1 DEB
1 08439U 74089CQ  24186.70546997  .00002291  00000-0  79718-2 0  9998
2 08439 102.3302 246.7290 0039332 119.0586 241.4457 12.98133537324106
0 COSMOS 783
1 08458U 75112A   24187.51433768  .00000208  00000-0  84851-4 0  9990
2 08458  74.0575 222.5912 0011053 113.6014 246.6300 14.33307650538205
0 SL-8 R/B
1 08459U 75112B   24187.40564818  .00000343  00000-0  12295-3 0  9992
2 08459  74.0615  64.7482 0016460 306.0758  53.8871 14.37516977543866
0 COSMOS 785
1 08473U 75116A   24187.57306649 -.00000042  00000-0  41417-4 0  9992
2 08473  65.0783  27.7510 0082371 194.8652 164.9986 13.82260294450684
0 SATCOM 1
1 08476U 75117A   24186.91700498  .00000038  00000-0  00000-0 0  9996
2 08476   9.5094 309.9370 0014949 244.9671 132.7825  0.99596840 39274
0 OPS 3165
1 08482U 75118A   24187.34215882 -.00000253  00000-0  00000-0 0  9990
2 08482   4.1273 273.0444 0030058   1.1039  55.3227  1.00486346 19304
0 RADUGA 1
1 08513U 75123A   24187.20191263 -.00000008  00000-0  00000-0 0  9990
2 08513   4.6448 277.9048 0006654 245.2923 260.6251  1.00253735187677
0 TITAN 3C TRANSTAGE R/B
1 08516U 75118C   24187.46917220  .00000093  00000-0  00000-0 0  9997
2 08516   4.1032 273.2441 0014607 192.4063 167.9354  1.00529277 18623
0 METEOR 1-23
1 08519U 75124A   24187.49689044  .00000246  00000-0  12968-3 0  9999
2 08519  81.2443  98.6259 0013365 174.7177 185.4138 14.11115453496508
0 SL-3 R/B
1 08520U 75124B   24187.55983468  .00000222  00000-0  12015-3 0  9992
2 08520  81.2866 198.0656 0025563 253.4317 106.4045 14.09220062493562
0 DELTA 1 DEB
1 08539U 72058GN  24187.36069010  .00000984  00000-0  39328-3 0  9993
2 08539  97.2968 317.2717 0203503 275.6410  82.1597 14.19577796653488
0 DELTA 1 DEB
1 08542U 72058GR  24186.48039107  .00000770  00000-0  43459-3 0  9996
2 08542  97.9350 159.3981 0354631 326.5773  31.3444 13.85303331607579
0 DELTA 1 DEB
1 08544U 72058GT  24187.00729876  .00000391  00000-0  45279-3 0  9997
2 08544  97.4523  97.5528 0843528 341.7624  15.4837 12.73558916427307
0 SL-12 R/B(AUX MOTOR)
1 08546U 75123D   24186.53325991 -.00000501  00000-0 -65249-3 0  9996
2 08546  46.0626  25.7267 5949690  17.3251 356.5122  3.98195032662120
0 THORAD DELTA 1 DEB
1 08554U 74089CR  24187.52592046 -.00000004  00000-0  25676-3 0  9999
2 08554 101.8567 162.1792 0033757 245.7825 226.3302 12.56152160274468
0 THORAD DELTA 1 DEB
1 08555U 74089CS  24187.61531564  .00000546  00000-0  36051-2 0  9996
2 08555 101.3864 318.5597 0058628 353.5702  20.2438 12.54985801264116
0 THORAD DELTA 1 DEB
1 08556U 74089CT  24187.44073750  .00000093  00000-0  83429-3 0  9995
2 08556 101.2495 348.0047 0081307 128.7066 246.5161 12.53316402267796
0 THORAD DELTA 1 DEB
1 08560U 74089CX  24187.35424199  .00000482  00000-0  70828-3 0  9998
2 08560 102.1374 345.0370 0405541  91.6927 273.0671 13.31824083398968
0 THORAD DELTA 1 DEB
1 08561U 74089CY  24187.07328260  .00000304  00000-0  18180-2 0  9995
2 08561 101.5630 221.1074 0072497 150.9552 279.5962 12.66883825285106
0 THORAD DELTA 1 DEB
1 08562U 74089CZ  24187.36416306  .00000010  00000-0  45031-3 0  9997
2 08562 101.6005 344.0828 0263279  44.3498  30.1387 12.15202535268808
0 THORAD DELTA 1 DEB
1 08563U 74089DA  24186.85716193  .00000042  00000-0  52660-3 0  9999
2 08563 101.3931 298.2152 0083367 145.7791 338.4703 12.53341104266840
0 THORAD DELTA 1 DEB
1 08564U 74089DB  24187.20105441  .00000487  00000-0  27291-2 0  9992
2 08564 101.2529  92.7523 0053098  17.7688 143.0540 12.68135831283441
0 THORAD DELTA 1 DEB
1 08566U 74089DD  24187.17660832  .00000152  00000-0  10162-2 0  9998
2 08566 101.4259 264.0573 0087792  54.2798 334.1245 12.67059047208681
0 THORAD DELTA 1 DEB
1 08567U 74089DE  24187.51079912 -.00002222  00000-0 -35737-1 0  9996
2 08567 100.6407 264.6137 0684197  49.2805 328.3700 11.32804689 45181
0 CTS
1 08585U 76004A   24187.60025341  .00000076  00000-0  00000-0 0  9999
2 08585   5.7627 282.0716 0016516 239.8515 205.4200  1.00320271115166
0 COSMOS 789
1 08591U 76005A   24187.56348296  .00000056  00000-0  44070-4 0  9996
2 08591  82.9744   8.6623 0030957  39.2674  19.9570 13.73109386427486
0 THORAD DELTA 1 DEB
1 08592U 74089DF  24187.23982748  .00000026  00000-0  56296-3 0  9996
2 08592 101.8521 286.0611 0124731 308.1141  77.6461 12.31780506230407
0 THORAD DELTA 1 DEB
1 08593U 74089DG  24187.56253851 -.00000014  00000-0  14688-3 0  9996
2 08593 101.8559 104.1600 0223999  99.7252  73.9641 12.71108548301670
0 THORAD DELTA 1 DEB
1 08594U 74089DH  24187.63289479  .00000080  00000-0  58925-3 0  9994
2 08594 101.6758 131.1420 0138597  53.1364 121.0811 12.73004743302991
0 THORAD DELTA 1 DEB
1 08595U 74089DJ  24187.61461281  .00000001  00000-0  36389-3 0  9999
2 08595 101.5116  77.7687 0149467 332.7084  92.6940 12.25421179220259
0 THORAD DELTA 1 DEB
1 08596U 74089DK  24187.49508914  .00000035  00000-0  41865-3 0  9993
2 08596 101.8625  31.0877 0087417 277.5918 153.5356 12.68729997296561
0 SL-8 R/B
1 08597U 76005B   24187.52444898  .00000119  00000-0  10786-3 0  9999
2 08597  82.9738 324.5690 0024066 233.2758 197.3294 13.75350082430775
0 NTS 1 AKM
1 08599U 74054C   24186.91680152 -.00000018  00000-0  00000-0 0  9994
2 08599 124.6714 166.1358 0056102  33.0903 175.2679  3.07179558363532
0 MOLNIYA 1-32
1 08601U 76006A   24186.42441353 -.00000759  00000-0  00000-0 0  9993
2 08601  63.6526 206.6689 6829887 282.0198  14.2981  2.00067693 67629
0 COSMOS 791
1 08607U 76008A   24187.56252919 -.00000004  00000-0  75007-4 0  9991
2 08607  74.0563   5.9931 0054698 225.0361 192.1224 12.55026953219030
0 COSMOS 792
1  8608U 76008B   24187.55533056  .00000012  00000-0  17833-3 0  9995
2  8608  74.0524 209.6088 0034209 116.0138   7.0396 12.50404035211123
0 COSMOS 793
1 08609U 76008C   24187.52921647 -.00000021  00000-0 -29633-4 0  9994
2 08609  74.0552 111.7440 0046497 357.5393 178.3785 12.52628190214823
0 COSMOS 794
1 08610U 76008D   24187.57221793 -.00000019  00000-0 -24043-4 0  9993
2 08610  74.0568 308.3727 0027044 246.1655 124.1301 12.48140356206906
0 COSMOS 795
1 08611U 76008E   24187.31822759  .00000007  00000-0  15613-3 0  9992
2 08611  74.0557  52.0973 0019686  29.4002 330.8150 12.45777849202579
0 COSMOS 796
1 08612U 76008F   24187.40744951 -.00000017  00000-0 -10992-4 0  9999
2 08612  74.0529 165.5842 0027875 192.4618 321.5889 12.43152929198087
0 COSMOS 797
1 08613U 76008G   24187.59771422  .00000006  00000-0  16116-3 0  9992
2 08613  74.0552 272.6543 0032271 338.8251 127.9443 12.40673194193759
0 COSMOS 798
1 08614U 76008H   24187.36065968  .00000011  00000-0  19582-3 0  9995
2 08614  74.0556  39.2630 0047583 129.0958  48.2602 12.37745098188502
0 SL-8 R/B
1 08615U 76008J   24187.61118749 -.00000051  00000-0 -33320-3 0  9992
2 08615  74.0553  36.0999 0133523 249.5572 166.3611 12.20891187158662
0 INTELSAT 4A-F2
1 08620U 76010A   24187.44683421  .00000096  00000-0  00000-0 0  9999
2 08620   9.4274 309.2865 0005114 247.9690 118.8574  0.99684468613520
0 ATLAS CENTAUR R/B
1 08621U 76010B   24187.46373285 -.00000020  00000-0  27714-2 0  9997
2 08621  21.9563 349.4673 7192151 175.2345 218.4703  2.20668294269847
0 COSMOS 800
1 08645U 76011A   24187.61133458  .00000074  00000-0  64526-4 0  9999
2 08645  82.9729 278.9736 0022012 154.3553 320.4896 13.72105466423801
0 SL-8 R/B
1 08646U 76011B   24187.63092082  .00000063  00000-0  51050-4 0  9995
2 08646  82.9682 235.2249 0004709 335.5484 140.1381 13.73969668427009
0 DELTA 1 DEB
1 08678U 75004F   24187.47878463  .00000292  00000-0  15980-3 0  9993
2 08678  97.6869 274.9841 0176988  61.1697 300.7117 14.09778100538282
0 DELTA 1 DEB *
1 08679U 75004G   24187.42244570  .00016372  00000-0  22317-2 0  9992
2 08679  98.7931 359.2949 0164329 187.6302 172.2398 14.69786052536769
0 DELTA 1 DEB
1 08682U 75004J   24187.27309049  .00000546  00000-0  24514-3 0  9990
2 08682  97.8050 289.4774 0153483  34.8758 326.2362 14.19585580549250
0 DELTA 1 DEB
1 08685U 75004M   24187.55085237  .00000681  00000-0  17846-3 0  9994
2 08685  97.9853 290.3949 0047091 334.4043  25.4822 14.51606339605774
0 COSMOS 803
1 08688U 76014A   24187.50646475  .00007111  00000-0  14923-3 0  9999
2 08688  65.8407 163.9480 0010496 197.3591 162.7201 15.46067072681202
0 MARISAT 1
1 08697U 76017A   24187.51363606  .00000084  00000-0  00000-0 0  9995
2 08697   7.5031 300.1543 0015050 182.5797 211.1092  0.99205295175048
0 UME 1 (ISS 1)
1 08709U 76019A   24187.41796708  .00000027  00000-0  87248-4 0  9993
2 08709  69.6722 179.5160 0008679  52.3560  59.6452 13.71615998419485
0 N-1 R/B
1 08710U 76019B   24187.60916399  .00000004  00000-0  63070-4 0  9998
2 08710  69.6756 250.7322 0010200  89.4154  20.3775 13.69933399417610
0 COSMOS 807
1 08744U 76022A   24187.55840175  .00010667  00000-0  48732-3 0  9994
2 08744  82.9215 207.0741 0511269  12.4582  95.4919 14.48614528446047
0 LES 8
1 08746U 76023A   24187.16694962 -.00000106  00000-0  00000-0 0  9996
2 08746  21.0511  46.1306 0033327 133.5998  55.8604  1.00271741122548
0 LES 9
1  8747U 76023B   24184.16201715 -.00000120  00000-0  00000+0 0  9999
2  8747  21.0064  46.1777 0024388 156.4809  30.7757  1.00268016122504
0 SOLRAD 11A
1  8748U 76023C   24188.35157640 -.00001020  00000-0  00000+0 0  9992
2  8748  17.1886 338.2641 0106960 172.6689   4.9899  0.19678744  4052
0 TITAN 3C TRANSTAGE R/B
1 08751U 76023F   24187.06453652 -.00000164  00000-0  00000-0 0  9994
2 08751  20.3721  51.7209 0123306  85.1369 267.3927  0.98324936176205
0 SOLRAD 11A/B PKM
1 08752U 76023G   24186.74210169 -.00000490  00000-0  00000-0 0  9995
2 08752  21.4832 353.8937 4362215  48.0141   0.8539  0.41542804 78607
0 SOLRAD 11A/B AKM
1 08753U 76023H   24189.57822015 -.00001027  00000-0  00000-0 0  9996
2 08753  15.8024 328.5108 0318741 100.7056   4.4883  0.18715625  4089
0 SL-8 DEB
1 08756U 74071C   24187.39992376  .00008547  00000-0  89274-3 0  9992
2 08756  74.0480 234.9893 0001477  39.2908 320.8381 14.89822356783673
0 SL-8 DEB
1 08757U 75094D   24187.26016200  .00040325  00000-0  16978-2 0  9998
2 08757  74.0191 189.3102 0007139 298.3457  61.7022 15.23152281795147
0 SL-8 DEB
1 08764U 70102E   24187.07667628  .00000329  00000-0  30410-3 0  9994
2 08764  74.0369  58.2244 0022011 100.6130  50.0659 13.86242229703383
0 SATCOM 2
1 08774U 76029A   24186.76338990 -.00000132  00000-0  00000-0 0  9993
2 08774  10.3690 314.0761 0058211 216.4376 143.2627  0.98623141112503
0 THORAD DELTA 1 DEB
1 08784U 74089DL  24187.44664531  .00018347  00000-0  32993-1 0  9990
2 08784 100.8949 171.5688 0293767  63.4329  93.7027 13.26140219437097
0 THORAD DELTA 1 DEB
1 08785U 74089DM  24186.86087061  .00000204  00000-0  22807-2 0  9990
2 08785 100.9833  41.2285 0272307 288.7841  79.6662 12.12603410994799
0 THORAD DELTA 1 DEB
1 08786U 74089DN  24187.56391260  .00000074  00000-0  83693-3 0  9994
2 08786 101.9345 285.1163 0052769 255.3169 118.3435 12.44284137251706
0 THORAD DELTA 1 DEB
1 08788U 74089DQ  24187.56233648  .00000021  00000-0  49680-3 0  9991
2 08788 102.0942 281.4549 0069620 322.8072  48.4541 12.39730875246958
0 THORAD DELTA 1 DEB
1 08789U 74089DR  24187.42193378 -.00000005  00000-0  28988-3 0  9993
2 08789 102.0510 134.0264 0106073 125.2928 357.7969 12.38951133244292
0 THORAD DELTA 1 DEB
1 08790U 74089DS  24187.43560385  .00000051  00000-0  56447-3 0  9993
2 08790 101.8331 177.2977 0039964  23.7741 135.0818 12.58972374279044
0 DELTA 1 DEB *
1 08791U 66087F   24187.39718214  .00000260  00000-0  16115-2 0  9993
2 08791 101.5636 158.9798 0140794 166.7437 348.0915 12.63473203654494
0 METEOR 1-24
1 08799U 76032A   24187.55789055  .00000111  00000-0  53564-4 0  9997
2 08799  81.2548 202.0637 0035731  75.3853 285.1276 14.11702691483562
0 SL-3 R/B
1 08800U 76032B   24187.56691269  .00000112  00000-0  52844-4 0  9991
2 08800  81.2496 231.4937 0095785  92.8087 268.4051 14.10414326480953
0 NATO 3A
1 08808U 76035A   24187.51304154 -.00000233  00000-0  00000-0 0  9999
2 08808   6.6056 301.8586 0022389 305.4304 322.8923  0.99838500740162
0 OPS 6431
1 08818U 76038A   24187.58022991  .00000774  00000-0  32733-3 0  9996
2 08818  63.3491 262.9429 0437384 172.6525 188.1227 13.90763262  8213
0 LAGEOS 1
1 08820U 76039A   24187.52397020 -.00000010  00000-0  00000-0 0  9995
2 08820 109.8609 295.5622 0044145  94.8486 263.6724  6.38665085867683
0 LAGEOS 1 AKM
1 08822U 76039C   24187.23831002 -.00000013  00000-0  00000-0 0  9991
2 08822 109.8619 300.0292 0044642  90.0744 291.2805  6.38870933123679
0 METEOR 1-10 DEB
1 08826U 71120C   24187.53716679  .00012373  00000-0  21495-2 0  9990
2 08826  81.2343 354.6460 0011737 174.0843 186.0501 14.68059428745195
0 METEOR 1-10 DEB
1 08827U 71120D   24187.41102829  .00000335  00000-0  16181-3 0  9996
2 08827  81.2679 304.4906 0014316 110.0935 250.1782 14.16439328707347
0 NOAA 1 DEB *
1 08828U 70106C   24187.36966269  .00000184  00000-0  17260-2 0  9990
2 08828 102.1514 154.1970 0030863  12.0008 144.4750 12.39431272423132
0 SL-8 DEB
1 08829U 74071D   24187.38185699  .00003533  00000-0  70191-3 0  9992
2 08829  74.0583 170.6645 0012568 154.9924 205.1854 14.62484819709065
0 TITAN 3C TRANSTAGE DEB
1 08832U 76023J   24187.10092084 -.00000168  00000-0  00000-0 0  9991
2 08832  20.3650  51.7158 0140977  77.4965 109.1191  0.98259268110601
0 SSU 1
1 08835U 76038C   24187.35850754  .00000324  00000-0  18033-3 0  9994
2 08835  63.3535  61.6652 0459544 170.7807 190.2052 13.82299116260388
0 SSU 2
1 08836U 76038D   24187.05263080  .00000296  00000-0  16982-3 0  9991
2 08836  63.3533  64.2691 0458516 171.0113 189.9510 13.82157442252819
0 COMSTAR 1
1 08838U 76042A   24187.51782233  .00000082  00000-0  00000-0 0  9999
2 08838   9.4820 310.0008 0000754 297.5355  96.7525  0.99817796113472
0 ATLAS CENTAUR R/B
1 08840U 76042B   24185.86300177 -.00000047  00000-0  73507-3 0  9998
2 08840  21.5351  78.1296 7183081 174.4404  19.5680  2.22510424275481
0 METEOR 1-25
1 08845U 76043A   24187.57024679  .00000059  00000-0  24942-4 0  9996
2 08845  81.2631 288.9608 0040303 151.7279 208.6093 14.11664659624510
0 SL-3 R/B
1 08846U 76043B   24187.49724393  .00000253  00000-0  13900-3 0  9995
2 08846  81.2244 325.4968 0037809 310.6963  49.0924 14.08801694473330
0 P 76-5
1 08860U 76047A   24187.52251031  .00000127  00000-0  20463-3 0  9995
2 08860  99.9426   9.8168 0042005   7.0343  59.4792 13.68002282399079
0 SCOUT B-1 R/B
1 08861U 76047B   24187.56566355  .00000092  00000-0  16648-3 0  9999
2 08861  99.9312  26.3721 0041891 160.6701 263.6111 13.66549253397321
0 SCOUT B-1 DEB
1  8867U 76047C   24186.91546839  .00000165  00000-0  28492-3 0  9999
2  8867  99.2591  47.5309 0073338 308.9694 177.9113 13.57049988379526
0 SCOUT B-1 DEB
1 08868U 76047D   24186.94445589  .00000197  00000-0  23113-3 0  9993
2 08868 100.0145 275.6221 0049304 318.3738 105.6642 13.81093492419201
0 COSMOS 823
1 08873U 76051A   24187.58242479  .00000061  00000-0  48821-4 0  9992
2 08873  82.9673 300.3659 0023301  39.8842 330.7734 13.73436578409469
0 SL-8 R/B
1 08874U 76051B   24187.58401749  .00000121  00000-0  11055-3 0  9995
2 08874  82.9583 260.5337 0022866 310.3213  49.5945 13.75149224412132
0 MARISAT 3
1  8882U 76053A   24187.18033102 -.00000188  00000-0  00000+0 0  9994
2  8882   9.3769 305.9289 0126906 317.3940  43.3461  0.95900021114372
0 SSU 3
1 08884U 76038J   24187.59442249  .00000977  00000-0  41650-3 0  9995
2 08884  63.3516 344.9332 0449451 172.9053 187.8655 13.87176616263351
0 COSMOS 825
1 08889U 76054A   24187.59309613  .00000014  00000-0  18278-3 0  9997
2 08889  74.0001 260.0498 0058201 141.9381 327.3804 12.55724221202854
0 COSMOS 826
1 08890U 76054B   24187.55548561 -.00000013  00000-0  18777-4 0  9997
2 08890  74.0017 286.8484 0039523  39.9007 331.5614 12.38538625172776
0 COSMOS 827
1 08891U 76054C   24187.59203902 -.00000006  00000-0  64770-4 0  9995
2 08891  74.0018   6.9254 0049120 273.5134 158.0548 12.53291344616395
0 COSMOS 828
1 08892U 76054D   24187.57319856 -.00000017  00000-0 -90620-5 0  9997
2 08892  74.0009 108.9101 0035749  30.9397 143.7440 12.50970381194506
0 COSMOS 829
1 08893U 76054E   24187.54342584  .00000006  00000-0  14550-3 0  9991
2 08893  73.9978 209.3942 0025489 159.6217 317.5931 12.48663406190459
0 COSMOS 830
1 08894U 76054F   24187.58687396 -.00000019  00000-0 -21287-4 0  9991
2 08894  74.0026 314.7011 0016166 300.6855  69.6711 12.46243800186223
0 COSMOS 831
1 08895U 76054G   24187.13478753  .00000009  00000-0  17581-3 0  9996
2 08895  74.0009  63.7864 0020325 108.6830  60.0339 12.43731784181768
0 COSMOS 832
1 08896U 76054H   24187.42318520 -.00000017  00000-0 -61269-5 0  9999
2 08896  73.9985 167.9747 0025032 261.4892 267.3384 12.41306925177572
0 SL-8 R/B
1 08897U 76054J   24187.63118213 -.00000015  00000-0 -44010-5 0  9993
2 08897  73.9999 301.0277 0125279 175.1408 293.7379 12.21064820142218
0 THORAD AGENA D DEB
1 08908U 70025NJ  24187.32801638  .00057187  00000-0  14373-1 0  9999
2 08908 101.6905 311.4260 0064071  85.7691 275.0809 14.49682420646535
0 OPS 2112
1 08916U 76059A   24187.60025394  .00000108  00000-0  00000-0 0  9991
2 08916   5.2036 279.5321 0006736 209.2839 239.0319  0.99471335 18429
0 TITAN 3C TRANSTAGE R/B
1 08918U 76059C   24186.59843281 -.00000253  00000-0  00000-0 0  9995
2 08918   4.5677 274.9555 0010538 234.6409 125.5998  1.00537796 18285
0 COSMOS 836
1 08923U 76061A   24187.46175322  .00000199  00000-0  80973-4 0  9994
2 08923  74.0514 196.0602 0019173 251.7951 108.1114 14.33630174508191
0 SL-8 R/B
1 08924U 76061B   24187.39934650  .00000396  00000-0  13960-3 0  9994
2 08924  74.0577  52.9949 0013403  30.3945 142.9169 14.37886641513489
0 DELTA 1 DEB
1 08951U 75004AH  24187.52404426  .00001802  00000-0  33313-3 0  9995
2 08951  98.0409 110.9034 0029213 235.7958 124.0477 14.66352021546852
0 DELTA 1 DEB
1 08954U 75004AL  24187.51714379  .00003191  00000-0  92542-3 0  9990
2 08954  97.6772  27.5723 0129506  82.7942 278.7951 14.40177070508280
0 DELTA 1 DEB
1  8956U 75004AN  24187.51282735  .00003661  00000-0  49519-3 0  9996
2  8956  98.3071 330.8742 0027301  54.0769 306.2969 14.79411613577224
0 DELTA 1 DEB
1 08958U 75004AQ  24187.56797410  .00001672  00000-0  35237-3 0  9996
2 08958  97.9507 145.0961 0036688 145.4094 214.9504 14.60298407557804
0 DELTA 1 DEB
1 08959U 75004AR  24187.59354920  .00001156  00000-0  33175-3 0  9991
2 08959  98.5848 137.4189 0065758  50.6662 310.0332 14.45608983539618
0 DELTA 1 DEB
1 08964U 75004AW  24187.38169141  .00000915  00000-0  32346-3 0  9994
2 08964  97.7350 112.5425 0102337 292.1055  66.9292 14.33810152518411
0 DELTA 1 DEB
1 08968U 75004BA  24187.05971065  .00000962  00000-0  37337-3 0  9995
2 08968  97.6390 227.8748 0134863  72.5236 289.0636 14.26836996506767
0 DELTA 1 DEB
1 08969U 75004BB  24187.36626912  .00001998  00000-0  65270-3 0  9995
2 08969  97.6534 332.3958 0122760 108.9355 252.5185 14.35248330513628
0 DELTA 1 DEB
1  8970U 75004BC  24187.55637570  .00001682  00000-0  47925-3 0  9997
2  8970  97.2822  43.2718 0107846 260.9041  97.9937 14.42958717516722
0 DELTA 1 DEB
1 08978U 75004BL  24187.15519628  .00003409  00000-0  43672-3 0  9998
2 08978  97.8732 259.1374 0029973  33.0151 327.2925 14.81639539561623
0 DELTA 1 DEB
1 08980U 75004BN  24187.52031758  .00001879  00000-0  35621-3 0  9999
2 08980  97.9823  86.9430 0042449 110.2207 250.3568 14.64837160542876
0 DELTA 1 DEB
1 08981U 75004BP  24187.55927554  .00002778  00000-0  76268-3 0  9992
2 08981  97.6712  46.7532 0121316 185.7216 174.2598 14.43454493512859
0 DELTA 1 DEB
1 09003U 75004CM  24187.32556391  .00003946  00000-0  47964-3 0  9999
2 09003  98.2302 328.3654 0025251  41.3807 318.9312 14.83882028562225
0 PALAPA 1
1 09009U 76066A   24186.75118743 -.00000213  00000-0  00000-0 0  9997
2 09009   9.3949 310.3291 0006754 191.7470 203.6942  1.00112701120815
0 COSMOS 839
1 09011U 76067A   24187.55365490 -.00000030  00000-0  88424-4 0  9990
2 09011  65.8501 199.1548 0706956 204.5979 151.9706 12.32871061172408
0 SL-8 R/B
1 09013U 76067B   24187.34329723  .00000002  00000-0  18950-3 0  9992
2 09013  65.8654  46.3148 0709586 145.1649 219.7987 12.35380031164381
0 SL-8 DEB
1 09016U 76067C   24187.53818179  .00000000  00000-0  19813-3 0  9991
2 09016  65.8654 238.8544 0700527 174.9457 298.6116 12.32690810159734
0 COSMOS 841
1 09022U 76069A   24187.36266868  .00000266  00000-0  99784-4 0  9993
2 09022  74.0419 168.5379 0011693  63.7604 296.4749 14.36310241510153
0 SL-8 R/B
1 09023U 76069B   24187.61400217  .00000383  00000-0  12876-3 0  9996
2 09023  74.0431  22.0001 0018137 270.5277  89.3800 14.40432092515187
0 COSMOS 842
1  9025U 76070A   24187.56820215  .00000082  00000-0  70303-4 0  9994
2  9025  82.9859 219.3786 0029182  89.5041  25.3718 13.74160720404593
0 DELTA 1 DEB
1 09040U 75004DE  24187.52785557  .00000369  00000-0  10903-3 0  9999
2 09040  97.9868 284.3830 0046830  10.6637 349.5539 14.48074444510334
0 DELTA 1 DEB
1  9042U 75004DG  24187.54220338  .00000586  00000-0  19054-3 0  9991
2  9042  97.8880 175.0897 0063482  71.1027 289.7032 14.40803776537438
0 SL-8 R/B
1 09044U 76070B   24187.52559323  .00000042  00000-0  27280-4 0  9992
2 09044  82.9871 173.7199 0012447 281.0865 200.1064 13.76337949407757
0 COMSTAR 2
1 09047U 76073A   24187.11727877 -.00000044  00000-0  00000-0 0  9994
2 09047   9.4226 310.4150 0003602 165.6998 211.5163  0.99988997 40094
0 NOAA 5
1 09057U 76077A   24187.55554389 -.00000035  00000-0  84669-4 0  9990
2 09057 102.2076 160.9508 0009327 199.9582 276.4466 12.37801653166424
0 COSMOS 846
1 09061U 76078A   24187.57078536  .00000086  00000-0  71531-4 0  9992
2 09061  82.9302 230.0893 0041427   9.3126 101.7397 13.76548434677324
0 SL-8 R/B
1 09062U 76078B   24187.53821153  .00000013  00000-0 -21252-5 0  9997
2 09062  82.9321 186.8872 0028191 194.1128 283.0867 13.78578014410307
0 DELTA 1 R/B
1 09063U 76077B   24187.58903380 -.00000029  00000-0  11075-3 0  9992
2 09063 101.9654 166.1831 0060980 297.7659 178.4715 12.50480269230151
0 TITAN 34B AGENA R/B
1 09271U 76080B   24184.91640685 -.00000097  00000-0  72772-3 0  9993
2 09271  63.4137  33.7401 6788848 291.0575  11.9529  2.62844122 47831
0 DELTA 1 DEB
1 09293U 75004DU  24187.62565477  .00001096  00000-0  23739-3 0  9996
2 09293  97.8929 317.1723 0079951 261.9545  97.2578 14.58179762538482
0 DELTA 1 DEB
1 09313U 75004EQ  24187.25195789  .00000333  00000-0  11580-3 0  9997
2 09313  97.6194  93.0254 0086556 191.8463 168.0692 14.38678936533300
0 DELTA 1 DEB
1 09320U 75004EX  24187.33650676  .00000769  00000-0  14836-3 0  9995
2 09320  98.5440 218.9548 0053927 211.2343 148.5651 14.65681109465696
0 OPS 6630 DEB
1 09323U 73088F   24187.03953309  .00000014  00000-0  19219-3 0  9997
2 09323  97.0274   8.5691 0024873  74.7292  45.1523 12.59056267226904
0 ATLAS CENTAUR R/B
1 09329U 76073B   24185.07801849 -.00000098  00000-0  78697-3 0  9991
2 09329  21.8795  64.2106 7174682 278.6269  12.7868  2.23748699260696
0 THORAD DELTA 1 R/B(2)
1 09330U 74101G   24187.47010881  .00000176  00000-0  81498-3 0  9996
2 09330  12.5375 241.1297 7200846  90.0844 344.5865  2.30129151402609
0 OPS 5721
1 09415U 76091A   24187.48048331  .00000386  00000-0  17549-3 0  9991
2 09415  98.2805   2.0335 0017346 193.8887 166.1820 14.26917704250979
0 RADUGA 2
1 09416U 76092A   24187.20226072 -.00000026  00000-0  00000-0 0  9996
2 09416   5.3160 280.1823 0026491  18.7628 126.1763  1.00294132122200
0 COSMOS 858
1 09443U 76098A   24187.58393848  .00000214  00000-0  84861-4 0  9998
2 09443  74.0499  21.2221 0014473 313.0305  46.9634 14.34648238496687
0 SL-8 R/B
1 09444U 76098B   24187.59829036  .00000379  00000-0  13227-3 0  9992
2 09444  74.0497 238.1724 0011893 102.7300 257.5184 14.38633501938822
0 MARISAT 2
1 09478U 76101A   24187.46318466 -.00000194  00000-0  00000-0 0  9998
2 09478   7.2994 311.7759 0102305 338.2815 277.6625  0.97591173116415
0 METEOR 1-26
1 09481U 76102A   24187.57204749  .00000318  00000-0  17237-3 0  9993
2 09481  81.2175  19.3938 0024812 119.8580 240.5061 14.10106987453377
0 SL-3 R/B
1 09482U 76102B   24187.40131654  .00000310  00000-0  16913-3 0  9992
2 09482  81.2549 139.3549 0087442  93.2859 267.8319 14.07749777449869
0 COSMOS 860
1 09486U 76103A   24187.57369895 -.00000042  00000-0  45120-4 0  9991
2 09486  64.7009 268.6592 0053348   9.1390 351.0624 13.81346495784642
0 COSMOS 861
1 09494U 76104A   24187.49016899 -.00000061  00000-0  26318-4 0  9994
2 09494  64.8597 105.9919 0044734   2.6987 357.4304 13.81657039407612
0 COSMOS 862
1  9495U 76105A   24185.81461415 -.00000702  00000-0  00000+0 0  9995
2  9495  69.7743  83.1361 6395379 205.8452  98.9880  2.00842548227360
0 EKRAN 1
1 09503U 76107A   24186.91491644  .00000028  00000-0  00000-0 0  9997
2 09503   5.4056 280.6043 0071450 169.1434 227.1467  1.00226847191377
0 COSMOS 864
1 09509U 76108A   24187.44218684  .00000055  00000-0  41983-4 0  9993
2 09509  82.9419 317.4543 0029236 334.2503  87.6490 13.75477131392598
0 SL-8 R/B
1 09510U 76108B   24187.57326194  .00000117  00000-0  10105-3 0  9995
2 09510  82.9368 267.4674 0026558 165.9785 194.2116 13.77763388396067
0 DELTA 1 DEB
1 09567U 75004FP  24187.60038901  .00000175  00000-0  90692-4 0  9995
2 09567  97.9148 312.0129 0127147  49.7230 311.4983 14.20642321506298
0 DELTA 1 DEB
1 09568U 73086FW  24186.69573870 -.00000175  00000-0 -11762-2 0  9992
2 09568 101.4697  93.2310 0426648  18.5778   9.1135 12.07971719218949
0 SL-8 DEB *
1 09569U 73098D   24187.59762412  .00020455  00000-0  13722-2 0  9997
2 09569  74.0452 268.1136 0004453 115.6314 244.5337 15.06782916805159
0 DELTA 1 DEB
1 09570U 73086FX  24187.61838615 -.00000044  00000-0 -58285-5 0  9998
2 09570 101.6440 143.6416 0067361 283.5758 255.5113 12.41265937289589
0 COSMOS 871
1 09588U 76118A   24187.59609456 -.00000018  00000-0 -12913-4 0  9990
2 09588  74.0325 306.3299 0030142 342.9714  30.4152 12.55756641180933
0 COSMOS 872
1 09589U 76118B   24187.47958834  .00000013  00000-0  17507-3 0  9991
2 09589  74.0279 204.8768 0042113 217.5015 254.6830 12.58091344184995
0 COSMOS 873
1 09590U 76118C   24187.60484866 -.00000021  00000-0 -33512-4 0  9993
2 09590  74.0321 349.1310 0020698 239.9803 195.8357 12.46399867164691
0 COSMOS 874
1 09591U 76118D   24187.17939677 -.00000010  00000-0  37669-4 0  9995
2 09591  74.0309  92.6096 0032888   9.9197 155.6986 12.43987104160450
0 COSMOS 875
1 09592U 76118E   24187.59743725  .00000012  00000-0  17737-3 0  9993
2 09592  74.0312  44.0598 0017329  90.0164 332.2079 12.53501291176937
0 COSMOS 876
1 09593U 76118F   24187.55264659  .00000010  00000-0  18622-3 0  9996
2 09593  74.0278 206.0741 0046769 131.6778 347.3883 12.41312386155896
0 COSMOS 877
1 09594U 76118G   24187.59413639 -.00000026  00000-0 -63467-4 0  9992
2 09594  74.0298 137.9279 0006482 209.2126 324.2967 12.51322335173235
0 COSMOS 878
1 09595U 76118H   24187.60482694  .00000031  00000-0  31007-3 0  9990
2 09595  74.0290 241.1809 0006455 140.5110 332.5397 12.48929193169139
0 SL-8 R/B
1 09598U 76118J   24187.45829838  .00000087  00000-0  90845-3 0  9997
2 09598  74.0132 186.0403 0137510 257.9814 258.1865 12.24158765126022
0 COSMOS 883
1 09610U 76122A   24187.43148708  .00000097  00000-0  83527-4 0  9996
2 09610  82.9522  72.3725 0035530  46.5827 313.8277 13.76236027387062
0 SL-8 R/B
1 09613U 76122B   24187.61972622  .00000072  00000-0  57523-4 0  9999
2 09613  82.9532  39.3040 0028797 271.2066  88.5793 13.77626853389633
0 DELTA 1 DEB
1 09619U 75004FU  24187.43154603  .00003016  00000-0  82166-3 0  9995
2 09619  97.4218 250.1083 0107666  52.6306 308.4634 14.44611475568425
0 COSMOS 886
1 09634U 76126A   24187.43402224 -.00000049  00000-0  12159-4 0  9993
2 09634  65.8347  92.0317 1087680 188.4579 169.6691 12.56388036190786
0 COSMOS 887
1 09637U 76128A   24187.62989997  .00000074  00000-0  58806-4 0  9992
2 09637  82.9416 329.3815 0046402  76.0452 295.6406 13.76386080385806
0 SL-8 R/B
1 09638U 76128B   24187.60090207  .00000098  00000-0  82440-4 0  9995
2 09638  82.9383 283.4295 0029866 279.0232  80.7546 13.78398860389104
0 COSMOS 886 DEB
1 09649U 76126F   24187.59888044  .00001212  00000-0  10851-2 0  9991
2 09649  65.9297 326.0228 0923671 228.5937 123.2068 12.70275089172514
0 COSMOS 886 DEB
1 09650U 76126G   24187.55403129  .00001768  00000-0  42834-3 0  9999
2 09650  65.8127 279.5784 0883167 354.8034   4.4270 13.27716414260262
0 COSMOS 886 DEB
1 09651U 76126H   24187.52219613  .00005577  00000-0  19582-2 0  9995
2 09651  65.7950 115.2230 0801103  60.0441 307.7684 13.28903733257218
0 COSMOS 886 DEB
1 09652U 76126J   24187.46993776  .00001313  00000-0  70981-3 0  9993
2 09652  65.8288 227.2928 0911015 284.1412  66.0138 12.93591341216676
0 COSMOS 886 DEB
1 09653U 76126K   24186.94454029  .00005917  00000-0  23152-2 0  9990
2 09653  65.7699  30.6497 0802056 134.0500 232.9528 13.24595684249463
0 COSMOS 886 DEB
1 09654U 76126L   24187.57393127  .00003265  00000-0  13240-2 0  9993
2 09654  65.7747 316.7791 0720155  67.5096 300.0549 13.38803580261884
0 COSMOS 886 DEB
1 09655U 76126M   24187.03545580  .00009193  00000-0  17466-2 0  9997
2 09655  65.7917  73.4506 0681938  80.1082 287.6216 13.73118084291214
0 COSMOS 886 DEB
1 09656U 76126N   24187.49001369  .00001198  00000-0  88564-3 0  9995
2 09656  65.8184 218.3220 0872330  20.8374 342.6005 12.87906483190429
0 METEOR 2-2
1 09661U 77002A   24187.58042049  .00000127  00000-0  72736-4 0  9991
2 09661  81.2646  58.2483 0009982 180.9330 179.1821 14.03934204430470
0 SL-3 R/B
1 09662U 77002B   24187.32094838  .00000166  00000-0  10055-3 0  9995
2 09662  81.2755 133.1640 0053351  86.8164 273.9104 14.01125937426934
0 SL-3 DEB
1 09663U 77002C   24187.15844408  .00000096  00000-0  54125-4 0  9992
2 09663  81.2657  70.5733 0006800 187.3154 172.7914 14.02652569429818
0 SL-3 DEB
1 09664U 77002D   24187.51528327  .00000062  00000-0  32772-4 0  9999
2 09664  81.2661  85.6613 0007608 252.7120 107.3214 14.02085098428896
0 THORAD AGENA D DEB
1 09666U 70025NK  24187.45860421  .00003060  00000-0  36639-2 0  9991
2 09666  99.2457 169.7388 0117619 353.9074 135.7327 13.64869318655590
0 THORAD AGENA D DEB
1 09668U 70025NM  24187.34165667  .00018752  00000-0  34159-2 0  9990
2 09668 100.1095 339.2580 0047752 246.8227 112.7935 14.65377953476547
0 DELTA 1 DEB
1 09681U 75004GC  24187.18711073  .00000341  00000-0  11374-3 0  9997
2 09681  98.0564 277.9774 0054297 294.6572  64.8970 14.42397130541113
0 THORAD DELTA 1 DEB
1 09695U 74089DU  24187.39304924  .00000996  00000-0  12965-2 0  9992
2 09695 103.0040 335.4546 0287551  43.8800 318.4779 13.49875121344179
0 THORAD DELTA 1 DEB
1 09696U 74089DV  24187.49450059  .00000189  00000-0  20009-2 0  9997
2 09696 100.8519  90.9501 0184053 207.0962 328.6884 12.22350915212067
0 THORAD DELTA 1 DEB
1 09697U 74089DW  24187.23841501  .00000092  00000-0  82759-3 0  9990
2 09697 101.7798 292.9725 0144222  23.7904   5.5487 12.53568091270066
0 THORAD DELTA 1 DEB
1 09699U 74089DY  24186.93721185 -.00000006  00000-0  29232-3 0  9996
2 09699 101.5472 335.4398 0124219 196.8035 318.7914 12.29291959229950
0 DELTA 1 DEB
1 09701U 73086FZ  24187.47229267  .00005269  00000-0  13011-1 0  9991
2 09701 102.6891 266.9218 0042998  92.1073 282.4332 13.20819115355866
0 DELTA 1 DEB *
1 09703U 73086GB  24187.48806205  .00000210  00000-0  32431-3 0  9997
2 09703  65.7206 247.8543 0133135 214.5042 251.2463 13.67320604486681
0 SL-8 DEB
1 09704U 76069C   24187.41438772  .00049182  00000-0  17143-2 0  9998
2 09704  74.0314 241.6809 0007793 353.6219   6.4883 15.29379600858862
0 DELTA 1 DEB
1 09710U 75004GU  24187.32119830  .00000412  00000-0  19106-3 0  9999
2 09710  97.6999 129.9220 0154692 246.4429 112.0436 14.18879831263043
0 COSMOS 886 DEB
1 09721U 76126S   24187.30861652  .00000746  00000-0  29184-3 0  9998
2 09721  65.8421 158.2749 1073236 313.8277  37.8695 12.76387002205467
0 COSMOS 886 DEB
1 09722U 76126T   24185.84911365  .00000426  00000-0  92440-3 0  9993
2 09722  65.7557  15.2767 0802757 318.4691  35.7895 12.52731850147515
0 COSMOS 886 DEB
1 09723U 76126U   24187.55459829  .00003364  00000-0  32966-2 0  9996
2 09723  65.7577   9.8391 0718269 227.2574 126.5834 13.00697954206036
0 COSMOS 886 DEB
1  9724U 76126V   24187.54501845  .00004825  00000-0  21872-2 0  9999
2  9724  65.8244 314.5226 0788535 125.2732 242.4702 13.21498128243553
0 DELTA 1 DEB
1 09726U 73086GC  24186.94597536  .00000022  00000-0  59811-3 0  9998
2 09726 102.5909 186.3757 0079554 172.9080 247.2836 12.26549543193844
0 THORAD DELTA 1 DEB
1 09730U 74089DZ  24186.00782125  .00002971  00000-0  65324-2 0  9994
2 09730 101.7030  10.2777 0072763 216.6511 295.0181 13.28452016348210
0 COSMOS 890
1 09737U 77004A   24187.62508637  .00000069  00000-0  59050-4 0  9991
2 09737  82.9612 328.0784 0027447 100.6780 270.4843 13.71822378374772
0 SL-8 R/B
1 09738U 77004B   24187.57056494  .00000091  00000-0  81184-4 0  9993
2 09738  82.9629 284.6147 0015212 293.5473  77.8604 13.73818825378209
0 NATO 3B
1 09785U 77005A   24187.53799355 -.00000122  00000-0  00000-0 0  9992
2 09785   9.6771 314.5260 0039717  38.5754 311.4084  0.95269905109883
0 DELTA 1 R/B(1)
1 09786U 77005B   24187.37846642  .00001145  00000-0  36042-3 0  9990
2 09786  28.0092  64.4148 0413188 123.1237 240.9664 13.95652762392836
0 THORAD DELTA 1 DEB
1 09795U 74089EA  24187.36210228  .00000234  00000-0  13169-2 0  9995
2 09795 101.9547 137.1648 0294988 179.6904 336.0158 12.62975389282702
0 COSMOS 886 DEB
1 09797U 76126X   24187.51756026  .00001475  00000-0  11505-2 0  9999
2 09797  65.8184 261.4321 0904022 122.5316 246.6327 12.79370188178813
0 COSMOS 886 DEB *
1 09798U 76126Y   24187.59995779  .00000039  00000-0  14621-3 0  9996
2 09798  65.7542 252.3707 0124817 149.6712 325.3105 13.61107695351538
0 COSMOS 886 DEB *
1 09799U 76126Z   24187.34961517  .00000300  00000-0  17522-3 0  9997
2 09799  65.6053  62.1738 1011196 202.9431 152.3226 12.78598270558488
0 OPS 3151
1 09803U 77007A   24187.44884532 -.00000039  00000-0  00000-0 0  9994
2 09803   6.5479 290.8384 0078455  21.5244   9.1844  0.97528304 17714
0 COSMOS 886 DEB
1 09807U 76126AA  24187.47428777  .00006932  00000-0  11562-2 0  9991
2 09807  65.7781 101.3303 0455220 217.6543 139.1863 14.19666249332891
0 COSMOS 886 DEB
1 09816U 76126AC  24187.56325636  .00003804  00000-0  80153-3 0  9999
2 09816  65.7991 318.1379 0621969  23.8561 339.0047 13.81499212308370
0 COSMOS 886 DEB
1 09819U 76126AF  24187.47920297  .00008960  00000-0  14630-2 0  9990
2 09819  65.8914 219.2526 0487528 233.7233 121.7884 14.14537149334174
0 COSMOS 886 DEB
1 09820U 76126AG  24187.33398872 -.00000015  00000-0  15417-3 0  9994
2 09820  65.7995  35.7612 0870222  41.8999 125.2868 11.92684160939479
0 COSMOS 886 DEB
1  9821U 76126AH  24187.53626783  .00049412  00000-0  51840-2 0  9994
2  9821  65.7531 115.3375 0259537  65.2742 297.5141 14.67560564358213
0 COSMOS 886 DEB
1 09822U 76126AJ  24187.38005747  .00002192  00000-0  10646-2 0  9992
2 09822  65.7811 175.4825 0930023  33.8579 331.8398 12.93245694215249
0 COSMOS 886 DEB
1 09823U 76126AK  24187.27579822  .00000752  00000-0  35807-3 0  9998
2 09823  65.7982 276.6881 0927016 327.2120  27.4475 12.97243603222586
0 COSMOS 886 DEB
1 09824U 76126AL  24187.57126736  .00001520  00000-0  37272-3 0  9996
2 09824  65.8122 287.8840 0883103 354.1352   4.9851 13.27640663259980
0 COSMOS 886 DEB
1 09826U 76126AN  24187.38688904  .00002967  00000-0  87704-3 0  9998
2 09826  65.8418 161.5569 0774615 270.1995  81.0396 13.40866096266627
0 COSMOS 886 DEB
1 09827U 76126AP  24187.23793463  .00053409  00000-0  46420-2 0  9996
2 09827  65.7802 108.9350 0236925 350.1060   9.5428 14.77533922359709
0 DELTA 1 DEB
1 09835U 73086GD  24187.43479725  .00000181  00000-0  34193-2 0  9994
2 09835 101.3170 161.8224 0670870  88.8938  60.0791 11.33341917505923
0 TANSEI 3 (MS-T3)
1 09841U 77012A   24187.38274468 -.00000030  00000-0  14684-4 0  9994
2 09841  65.7571 174.5411 1720177 100.1791 279.6737 10.73873946857270
0 TANSEI 3 DEB
1 09843U 77012C   24187.32029110  .00000056  00000-0  26646-3 0  9999
2 09843  65.7496 140.7369 1718033 110.2179 269.1279 10.74800499858107
0 COSMOS 894
1 09846U 77013A   24187.60048530  .00000088  00000-0  77218-4 0  9998
2 09846  82.9431 263.4815 0030539  33.6642  79.8404 13.74093959374443
0 SL-8 R/B
1 09848U 77013B   24187.56477147  .00000067  00000-0  53947-4 0  9995
2 09848  82.9498 238.7684 0015189 250.9387 220.0528 13.75641123377107
0 KIKU 2 (ETS 2)
1 09852U 77014A   24186.98258084  .00000151  00000-0  00000-0 0  9995
2 09852   7.0561 290.9619 0003609 181.2192 209.3545  1.00001703120107
0 TITAN 3C TRANSTAGE R/B
1 09855U 77007C   24187.17189435 -.00000270  00000-0  00000-0 0  9998
2 09855   5.2342 279.1086 0014446  28.0541 332.3180  1.00283371 18225
0 PALAPA 2
1 09862U 77018A   24187.51958663  .00000060  00000-0  00000-0 0  9999
2 09862  10.0618 315.3629 0006492 137.3761 252.8599  1.00031131135998
0 MOLNIYA 1-36
1 09880U 77021A   24186.42605247 -.00001011  00000-0  00000-0 0  9997
2 09880  63.5713 182.0828 6757033 286.8818  13.3030  2.00679965244377
0 COSMOS 862 DEB
1 09896U 76105N   24185.50793485  .00000268  00000-0  00000-0 0  9998
2 09896  69.5304 269.3139 5974669 275.1404  23.4776  1.99785056233998
0 METEOR 1-27
1 09903U 77024A   24187.48354347 -.00000005  00000-0 -99772-5 0  9997
2 09903  81.2730 106.5544 0036268 214.2560 145.6271 14.08554437427352
0 SL-3 R/B
1 09904U 77024B   24187.45806339  .00000233  00000-0  13047-3 0  9998
2 09904  81.2614 161.1803 0054958 274.4626  85.0266 14.07112250424682
0 SL-3 DEB
1 09907U 77024C   24187.47788669  .00024517  00000-0  40962-2 0  9994
2 09907  82.9094  89.5046 0006892 139.5187 220.6535 14.69758518422005
0 SL-6 R/B(2)
1  9921U 77027D   24185.88556338  .00000516  00000-0  00000+0 0  9991
2  9921  72.4963 165.9796 5715240 168.5450 212.3372  1.98892015343092
0 ESA/GOES
1 09931U 77029A   24183.34863789 -.00000137  00000-0  00000-0 0  9995
2 09931  25.9596 172.2916 6672512  94.6407 338.3917  1.96177042337809
0 COSMOS 886 DEB
1 09951U 76126AR  24187.48914810  .00002462  00000-0  95971-3 0  9991
2 09951  65.8249 312.9439 0798047  60.4559 307.3624 13.26284648965307
0 COSMOS 886 DEB
1 09953U 76126AT  24187.46057221  .00002881  00000-0  12471-2 0  9993
2 09953  65.8191 227.2094 0861398 160.1220 203.5672 13.10221956234960
0 COSMOS 886 DEB *
1 09954U 76126AU  24187.54712748  .00000372  00000-0  18755-3 0  9990
2 09954  65.6998 277.4269 0908778 338.0598  18.3722 13.02397909534338
0 COSMOS 886 DEB
1 09955U 76126AV  24187.57451275  .00000277  00000-0  18895-3 0  9998
2 09955  65.8470 130.8153 1057843 102.4810 269.6438 12.63495512899300
0 COSMOS 886 DEB
1 09956U 76126AW  24185.30548881  .00000041  00000-0  16903-3 0  9995
2 09956  65.7919 159.9341 0930298 216.6689 136.7054 12.36604526442886
0 COSMOS 886 DEB
1 09958U 76126AY  24187.39571448  .00000418  00000-0  56555-3 0  9998
2 09958  65.8694 185.2198 0894442 164.8112 198.1745 12.60663073173649
0 COSMOS 886 DEB
1 09960U 76126BA  24187.15967174  .00000501  00000-0  41378-3 0  9990
2 09960  65.8689  82.6182 0870869 276.5010  73.7693 12.86652774186495
0 COSMOS 886 DEB
1 09961U 76126BB  24187.38706564  .00005477  00000-0  14297-2 0  9996
2 09961  65.7999 225.2677 0577126  58.2005 307.3939 13.81449184301754
0 COSMOS 886 DEB
1 09962U 76126BC  24187.59576901  .00013662  00000-0  35270-2 0  9999
2 09962  65.7700 354.3889 0601789 172.7516 188.2764 13.76921717297528
0 COSMOS 886 DEB
1 09963U 76126BD  24187.01589258  .00004364  00000-0  14418-2 0  9996
2 09963  65.7970  32.0978 0798713  38.0691 327.4106 13.31798598258859
0 COSMOS 886 DEB
1  9964U 76126BE  24186.89261794  .00001814  00000-0  90404-3 0  9991
2  9964  65.7995 354.8519 0834794 240.5338 110.9919 13.10358798232367
0 COSMOS 886 DEB
1 09965U 76126BF  24187.53590339  .00000480  00000-0  16763-2 0  9997
2 09965  65.7943 232.1013 0879132 158.9561 332.1428 12.13326341 81875
0 COSMOS 886 DEB
1 09966U 76126BG  24187.45537470  .00007667  00000-0  26951-2 0  9990
2 09966  65.7780 201.8384 0663295 329.7946  26.6362 13.54156837274452
0 COSMOS 252 DEB
1 09973U 68097DV  24186.42497141  .00004354  00000-0  12582-2 0  9997
2 09973  62.3981 230.5728 0648922  95.2788 272.2578 13.64970519933111
0 DELTA 1 DEB
1 09975U 73086GE  24187.04380969  .00000947  00000-0  70250-2 0  9991
2 09975 102.4666 121.8898 0101153  75.2017 349.8173 12.43086803  4786
0 DELTA 1 DEB
1 09976U 73086GF  24184.52719424  .00000113  00000-0  12579-2 0  9999
2 09976 102.3879 190.3334 0045402  87.6857  43.4421 12.35278042207991
0 DELTA 1 DEB
1 09977U 73086GG  24187.14760866  .00000174  00000-0  13551-2 0  9995
2 09977 101.9059 261.0514 0078120 115.4925 273.4731 12.53811728234298
0 DELTA 1 DEB
1 09978U 73086GH  24185.33641949  .00000258  00000-0  24598-2 0  9991
2 09978 101.9813 134.5820 0055316 177.5806 337.2416 12.33015520204672
0 DELTA 1 DEB
1  9979U 73086GJ  24186.93017457 -.00000440  00000-0 -59614-2 0  9992
2  9979 101.9209 217.9274 0596381  20.1302  93.5624 11.50322723324903
0 TANSEI 3 DEB
1 09981U 77012E   24187.54069177  .00000258  00000-0  82195-3 0  9998
2 09981  65.2115 349.0630 1677818  99.1825 280.1914 10.84069204873036
0 TANSEI 3 DEB
1 09982U 77012F   24187.26453151  .00000520  00000-0  14640-2 0  9998
2 09982  65.9027  47.5954 1709666 113.5526 265.3941 10.80745699869328
0 TANSEI 3 DEB
1 09983U 77012G   24182.62387276  .00000326  00000-0  11209-2 0  9990
2 09983  65.6012  43.8560 1699356  71.4898 306.2622 10.75461112860365
0 THORAD DELTA 1 DEB
1 09984U 74089EB  24187.39027867 -.00000038  00000-0  60156-4 0  9996
2 09984 102.2643 165.7158 0095464  19.2835 139.1410 12.40425127249045
0 THORAD DELTA 1 DEB
1 09985U 74089EC  24186.81746690  .00000018  00000-0  41847-3 0  9997
2 09985 101.8908 141.9398 0048219 299.5725  88.1305 12.48983027263547
0 THORAD DELTA 1 DEB
1 09986U 74089ED  24187.11976270  .00003993  00000-0  42010-2 0  9998
2 09986 103.3050 241.5254 0464088 200.2552 157.9600 13.36978941335926
0 THORAD DELTA 1 DEB
1 09987U 74089EE  24187.38318214  .00000359  00000-0  25556-2 0  9995
2 09987 101.4501 337.6592 0096526  53.4158   3.2656 12.51103155260291
0 THORAD DELTA 1 DEB
1 09988U 74089EF  24187.29483051  .00009454  00000-0  62060-2 0  9994
2 09988 103.0497 317.0572 0251214  94.4834 268.5050 13.88075494405354
0 THORAD DELTA 1 DEB
1 09989U 74089EG  24187.05752326  .00001541  00000-0  10574-1 0  9994
2 09989 102.9265  35.2114 0142900 201.2657 314.9314 12.46425521212661
0 SMS 1 AKM
1 09998U 74033F   24186.67545890 -.00000161  00000-0  00000-0 0  9996
2 09998   5.6982  84.9348 0278605 355.3164   4.2454  1.16183471 45817
0 OPS 9437 (DSCS 2-7)
1 10000U 77034A   24186.88380912 -.00000041  00000-0  00000+0 0  9997
2 10000   9.8170 299.3384 0016986 345.0234  15.0597  0.96672275158653
0 OPS 9438 (DSCS 2-8)
1 10001U 77034B   24187.54209639 -.00000114  00000-0  00000-0 0  9990
2 10001  10.4411 305.4048 0037121 143.2909 161.5693  0.95427026110739
0 TITAN 3C TRANSTAGE R/B
1 10002U 77034C   24186.97840376 -.00000156  00000-0  00000-0 0  9992
2 10002  10.4353 301.3440 0283766  89.1305 271.7113  0.95555116 38330
0 COSMOS 909
1 10010U 77036A   24187.54218144 -.00000077  00000-0 -81567-4 0  9993
2 10010  65.8608 126.2305 0709538 335.1681  21.6649 12.30347390 97764
0 SL-8 R/B
1 10011U 77036B   24187.62973235 -.00000023  00000-0  11598-3 0  9998
2 10011  65.8659  26.1637 0705850 312.8248 110.4970 12.32244806 99273
0 SL-8 DEB
1 10013U 77036C   24187.58277756 -.00000081  00000-0 -95372-4 0  9998
2 10013  65.8656 118.6229 0709655 321.7370 215.2843 12.30780977 98047
0 OPS 9751
1 10016U 77038A   24186.98640984 -.00000193  00000-0  00000-0 0  9996
2 10016   8.3243 332.4476 1311277 119.8021 264.4007  1.00232572 19312
0 COSMOS 911
1 10019U 77039A   24187.59497119  .00000052  00000-0  38048-4 0  9998
2 10019  82.9489 303.9234 0024948 167.0613 204.1771 13.75338809364044
0 SL-8 R/B
1 10020U 77039B   24187.54994278  .00000135  00000-0  11923-3 0  9997
2 10020  82.9443 246.4348 0029695 288.6378  71.1556 13.78227304368312
0 INTELSAT 4A-F4
1 10024U 77041A   24186.91577209  .00000100  00000-0  00000+0 0  9997
2 10024  10.2916 316.1203 0012664 238.7891 119.5748  0.99438960114190
0 ATLAS CENTAUR R/B
1 10025U 77041B   24187.23330733  .00000045  00000-0  18526-2 0  9996
2 10025  21.1574 144.4746 7169250  51.6786 357.9975  2.22778864382085
0 OPS 5644
1 10033U 77044A   24187.55993281  .00000450  00000-0  18974-3 0  9994
2 10033  99.1683 187.0662 0039208 127.4524 233.0234 14.30511355266371
0 GOES 2
1 10061U 77048A   24187.51305608  .00000101  00000-0  00000-0 0  9996
2 10061   8.1123 299.5399 0010501  45.7042 348.8140  0.99395808 39203
0 DELTA 1 R/B(1)
1 10062U 77048B   24187.43622819  .00000310  00000-0  72137-4 0  9990
2 10062  28.4220  85.2128 0731881 265.9441  85.7200 13.37827992291582
0 SL-6 R/B(2)
1 10089U 77047D   24186.91490542  .00000145  00000-0  00000-0 0  9998
2 10089  66.3360 139.9193 5955650 317.5795   9.1659  1.99305645246252
0 NTS 2
1 10091U 77053A   24187.25813522 -.00000068  00000-0  00000-0 0  9998
2 10091  63.5974 303.6474 0065043 225.9105 134.5727  2.00460367344419
0 COSMOS 921
1 10095U 77055A   24187.61266675  .00001416  00000-0  13206-3 0  9997
2 10095  75.8327  26.3343 0035687  16.0782 344.1535 14.94317310548019
0 SL-14 R/B
1 10096U 77055B   24187.48366714  .00001031  00000-0  10631-3 0  9990
2 10096  75.8339 102.6067 0040830 124.6898 235.8152 14.90395400545317
0 SL-3 R/B
1 10114U 77057B   24187.56243838  .00008492  00000-0  31049-3 0  9997
2 10114  97.5113 332.0244 0009513 320.2019  39.8521 15.28291754574297
0 COSMOS 923
1 10120U 77059A   24187.60638336  .00000195  00000-0  81611-4 0  9995
2 10120  74.0475 241.6379 0013533 332.2085  27.8341 14.32444191453957
0 SL-8 R/B
1 10121U 77059B   24187.41408645  .00000349  00000-0  12708-3 0  9994
2 10121  74.0469  86.9452 0018624 166.5038 193.6618 14.36674633459242
0 THORAD AGENA D DEB
1 10136U 70025NQ  24187.40138860  .00000049  00000-0  14627-3 0  9993
2 10136 100.0621 139.4782 0000801 354.2231 123.3838 13.51869264674310
0 COSMOS 926
1 10137U 77062A   24187.48969431  .00000072  00000-0  61623-4 0  9991
2 10137  82.9413 172.7669 0032310 183.3393 299.3094 13.72458691352594
0 SL-8 R/B
1 10138U 77062B   24187.60838782  .00000045  00000-0  31861-4 0  9991
2 10138  82.9402 140.2116 0022135  60.5148 113.2066 13.74049841352833
0 COSMOS 928
1 10141U 77064A   24187.56899596  .00000083  00000-0  68433-4 0  9999
2 10141  82.9678 305.0183 0037573 195.8572 164.1412 13.76789994359572
0 SL-8 R/B
1 10142U 77064B   24187.47323102  .00000088  00000-0  70961-4 0  9999
2 10142  82.9655 265.5971 0042724  48.3950 322.7673 13.78775322362633
0 HIMAWARI 1 (GMS 1)
1 10143U 77065A   24187.46537936  .00000056  00000-0  00000-0 0  9990
2 10143   8.2221 298.8616 0018886 218.3582 145.5099  0.99249759114166
0 DELTA 1 R/B(1)
1 10144U 77065B   24187.51611526  .00000706  00000-0  19118-3 0  9990
2 10144  29.0610 263.3238 0848926  25.6986 338.3367 13.23916348268436
0 COSMOS 931
1 10150U 77068A   24186.12846176 -.00000556  00000-0  00000-0 0  9998
2 10150  69.3884  90.9556 5702697 345.1710   3.4136  2.00585023344461
0 SL-6 R/B(2)
1 10155U 77054D   24186.83568036 -.00000020  00000-0  55805-2 0  9993
2 10155  64.0833 322.2949 6840505 284.2779  13.5365  2.48954566101022
0 RADUGA 3
1 10159U 77071A   24187.51617704 -.00000335  00000-0  00000-0 0  9993
2 10159   5.9453 283.1761 0008980 259.6563  32.8520  1.00320588169905
0 SL-6 R/B(2)
1 10167U 77068D   24187.45058912 -.00000903  00000-0  00000-0 0  9992
2 10167  63.6511  57.5135 7226938  43.0210 354.9886  1.99819664266596
0 DELTA 1 DEB
1 10177U 77065F   24187.32480311  .00008140  00000-0  13366-2 0  9999
2 10177  28.2301 235.0596 0516042 321.0285  35.4141 14.07401723196163
0 DELTA 1 DEB
1 10178U 77065G   24185.39879303  .00000656  00000-0  18994-2 0  9994
2 10178  28.7127 217.7501 0915752  29.5110  77.9556 12.07923158923995
0 DELTA 1 DEB
1 10183U 77065M   24187.44984963  .00002824  00000-0  72952-3 0  9991
2 10183  29.2115 104.2234 0510313 190.1829 168.8054 13.90712724310938
0 DELTA 1 DEB
1 10184U 77065N   24187.50744977  .00003306  00000-0  80071-3 0  9995
2 10184  29.0762 310.4474 0769284 137.6290 228.6341 13.46127640271155
0 DELTA 1 DEB
1 10188U 77065S   24187.38378811  .00002033  00000-0  49444-3 0  9990
2 10188  29.0612 201.2104 0678426  61.0481 305.6398 13.62585093294206
0 DELTA 1 DEB
1 10198U 77065AB  24187.33204741  .00002917  00000-0  22663-2 0  9990
2 10198  29.5659  52.8432 0618312  46.0773 318.9170 13.26097407234882
0 DELTA 1 DEB
1 10201U 77065AE  24187.37271135  .00001676  00000-0  30824-3 0  9990
2 10201  29.0853 201.4191 0685738 162.9020 199.5902 13.69949346310955
0 DELTA 1 DEB
1 10204U 77065AH  24187.39359410  .00026368  00000-0  22679-2 0  9991
2 10204  28.8250 254.4489 0174311   9.0032 351.3628 14.85121541372485
0 DELTA 1 DEB
1 10206U 77065AK  24187.40149019  .00003174  00000-0  24887-2 0  9990
2 10206  29.2099 221.1021 0547415 209.8143 147.0130 13.36703917219103
0 DELTA 1 DEB
1 10207U 77065AL  24187.21959776  .00001641  00000-0  28985-2 0  9999
2 10207  29.0855 173.2953 0695468  78.5653 289.2125 12.71751736163417
0 DELTA 1 DEB
1 10208U 77065AM  24187.46444214  .00006740  00000-0  10111-2 0  9990
2 10208  28.9406 313.6759 0398974 309.4608  47.1313 14.31076625342717
0 DELTA 1 DEB
1 10211U 77065AQ  24187.18180503  .00002270  00000-0  45722-2 0  9991
2 10211  29.4778 163.4488 0667598  50.7179 315.0690 12.69536545 20303
0 DELTA 1 DEB
1 10214U 77065AT  24187.32372665  .00002783  00000-0  10683-2 0  9999
2 10214  28.8779  62.0355 0545634 305.0507  50.0033 13.68780299255016
0 DELTA 1 DEB
1 10220U 77065AX  24187.12500227  .00003961  00000-0  14040-2 0  9991
2 10220  29.1389 114.1006 0432763 194.4206 164.3659 13.91109338276426
0 DELTA 1 DEB
1 10221U 77065AY  24187.62955291  .00013448  00000-0  14992-2 0  9999
2 10221  29.0335 296.7972 0371844 269.0450  86.7521 14.46526983368605
0 DELTA 1 DEB
1 10227U 77065BE  24187.19418618  .00006392  00000-0  21931-2 0  9995
2 10227  28.9507  16.2096 0692528 101.4982 266.4106 13.48298477278304
0 DELTA 1 DEB
1 10234U 77065BM  24187.45731300  .00009477  00000-0  87598-3 0  9997
2 10234  28.9495 247.5605 0362397 358.6618   1.2987 14.54345486376248
0 DELTA 1 DEB
1 10240U 77065BR  24187.20229689  .00000895  00000-0  60613-3 0  9993
2 10240  29.3902 122.1183 0691554 223.8532 130.5069 13.16796880960296
0 DELTA 1 DEB
1 10250U 77065CB  24187.20615902  .00007057  00000-0  14645-2 0  9991
2 10250  29.0770 121.8897 0560205 348.6408  10.1970 13.91147025208609
0 DELTA 1 DEB
1 10251U 77065CC  24187.34504027  .00004577  00000-0  63804-3 0  9998
2 10251  28.9756  74.6932 0692997 354.8419   4.5296 13.79275753318642
0 DELTA 1 DEB
1 10252U 77065CD  24187.38552177  .00002534  00000-0  10930-2 0  9994
2 10252  28.8436  72.1536 0769221 142.8808 222.7528 13.24488332245260
0 DELTA 1 DEB
1 10261U 77065CN  24187.42022764  .00031467  00000-0  23765-2 0  9990
2 10261  29.0088 330.3411 0242028  91.4666 271.3663 14.80773563384360
0 DELTA 1 DEB
1 10262U 77065CP  24187.12775979  .00002616  00000-0  56273-3 0  9996
2 10262  29.0586 121.1593 0657986 127.0620 239.1963 13.70923143308225
0 COSMOS 939
1 10282U 77079A   24187.62511453 -.00000010  00000-0  34336-4 0  9997
2 10282  74.0259   6.6479 0019105  92.8886 333.0092 12.54274593118711
0 COSMOS 940
1 10286U 77079B   24187.42126517 -.00000023  00000-0 -38556-4 0  9995
2 10286  74.0230 170.1716 0044063 224.8255 304.2824 12.58883514122602
0 COSMOS 941
1 10287U 77079C   24187.57316323  .00000004  00000-0  12327-3 0  9992
2 10287  74.0248 270.0986 0031735 349.0628 117.0398 12.56532850120658
0 COSMOS 942
1 10288U 77079D   24187.42361431 -.00000024  00000-0 -66690-4 0  9994
2 10288  74.0234 155.4595 0044188 125.1736 355.0472 12.42242594107958
0 COSMOS 943
1 10289U 77079E   24187.54563084 -.00000010  00000-0  39600-4 0  9991
2 10289  74.0250 100.0540 0007818 202.8897 331.3065 12.52080764116701
0 COSMOS 944
1 10290U 77079F   24187.48561937  .00000008  00000-0  15619-3 0  9990
2 10290  74.0221 201.8559 0005394 165.7947 306.0862 12.49690074114474
0 COSMOS 945
1 10291U 77079G   24187.58974113 -.00000018  00000-0 -17695-4 0  9996
2 10291  74.0263 305.2142 0018488 243.2874 129.0724 12.47232705112409
0 COSMOS 946
1 10292U 77079H   24187.59143676  .00000010  00000-0  17804-3 0  9991
2 10292  74.0252  43.3163 0030656   6.4334  57.5038 12.44903781110342
0 SL-8 R/B
1 10293U 77079J   24187.63100237 -.00000015  00000-0 -83315-6 0  9993
2 10293  74.0250 139.0379 0135565 202.1537 331.1645 12.25218209873308
0 SIRIO
1 10294U 77080A   24186.91717902 -.00000087  00000-0  00000-0 0  9991
2 10294   8.8204 304.9673 0009439 152.0387 231.6734  1.00270194110780
0 DELTA 1 R/B(1)
1 10295U 77080B   24187.62352428  .00000137  00000-0  11206-3 0  9997
2 10295  27.1012 310.0578 0766751 289.2436  62.6704 12.48057079115210
0 DELTA 1 DEB
1 10306U 77065DC  24187.33317601  .00005799  00000-0  14726-2 0  9993
2 10306  29.1089 241.1862 0676651 272.1919  80.1369 13.62226569293651
0 DELTA 1 DEB
1 10314U 77065DL  24186.94314674  .00008438  00000-0  30343-2 0  9991
2 10314  28.7823  27.7034 0661959 159.0452 345.1494 13.52042780262558
0 DELTA 1 DEB
1 10338U 77065DM  24187.39442599  .00002029  00000-0  38497-3 0  9994
2 10338  29.0576 211.6262 0643629  73.1813 293.8318 13.77691254315243
0 DELTA 1 DEB
1 10346U 77065DV  24186.88439824  .00002809  00000-0  12641-2 0  9991
2 10346  29.2240  18.7673 0710561 186.9325 172.0931 13.33488360241459
0 COSMOS 951
1 10352U 77087A   24187.50728334  .00000064  00000-0  51384-4 0  9999
2 10352  82.9705 336.8823 0033651 194.9904 231.4980 13.74239723346732
0 SL-8 R/B
1 10355U 77087B   24187.62305413  .00000066  00000-0  52323-4 0  9990
2 10355  82.9720 305.1850 0034579  53.6690 317.1052 13.75967939349535
0 COSMOS 952
1 10358U 77088A   24187.45056030 -.00000054  00000-0  30982-4 0  9998
2 10358  64.9340 181.8764 0063855 255.3793 104.0180 13.83676241364706
0 EKRAN 2
1 10365U 77092A   24186.91668866 -.00000135  00000-0  00000-0 0  9991
2 10365   6.0615 284.0829 0030152 351.2560  59.7722  1.00218236127714
0 THORAD DELTA 1 DEB
1 10392U 74089EH  24187.39855091 -.00000019  00000-0  14195-3 0  9999
2 10392 101.3245 244.2075 0049685 246.5306 245.1956 12.60112514285139
0 THORAD DELTA 1 DEB
1 10393U 74089EJ  24187.39679211  .00000029  00000-0  60779-3 0  9997
2 10393 101.5252 163.1125 0157692 159.7734 356.7514 12.24036939222915
0 DELTA 1 DEB *
1 10395U 73086GK  24187.59320088  .00060328  00000-0  46824-1 0  9993
2 10395 102.6826  65.5551 0412100 304.2561  52.0177 13.58842474290774
0 COSMOS 839 DEB
1 10410U 76067D   24187.61822020 -.00000077  00000-0 -80623-4 0  9994
2 10410  66.0884 151.7583 0691890 307.4438 232.2937 12.32989302160466
0 COSMOS 839 DEB
1 10411U 76067E   24187.60789787  .00000018  00000-0  29851-3 0  9994
2 10411  66.0238 332.9215 0662667 189.1838 262.2844 12.29163473153623
0 COSMOS 839 DEB
1 10412U 76067F   24187.53349194 -.00000034  00000-0  82362-4 0  9997
2 10412  65.6827 288.3134 0694825 298.0821  67.8759 12.33818874161978
0 COSMOS 839 DEB
1 10413U 76067G   24187.38040940  .00000111  00000-0  65145-3 0  9992
2 10413  65.8739 191.0069 0683535 211.5779 268.3423 12.29758922151773
0 COSMOS 839 DEB
1 10414U 76067H   24187.05793903 -.00000069  00000-0 -87395-4 0  9997
2 10414  65.8769 107.2011 0632158 331.3520  38.6883 12.18410914135542
0 COSMOS 839 DEB
1 10415U 76067J   24187.59273172 -.00000079  00000-0 -13010-3 0  9991
2 10415  65.8406 344.2768 0675830  60.1181   7.7811 12.18813219136327
0 COSMOS 839 DEB
1 10416U 76067K   24187.60971368 -.00000127  00000-0 -36015-3 0  9990
2 10416  65.7156 122.9153 0653374 356.3841 175.6585 12.20387353139032
0 COSMOS 839 DEB
1 10417U 76067L   24186.75266729  .00000087  00000-0  38322-3 0  9990
2 10417  65.5834  69.4200 0726102  51.7494   9.8064 12.47016835441097
0 COSMOS 839 DEB
1 10436U 76067M   24187.42310013  .00000035  00000-0  30751-3 0  9993
2 10436  66.0242 205.9117 0681234  61.1274  48.1407 12.37963470166320
0 COSMOS 839 DEB
1 10437U 76067N   24186.73052817 -.00000248  00000-0 -76153-3 0  9996
2 10437  65.8241  40.6861 0673351 340.4272  92.1995 12.31028081153757
0 COSMOS 839 DEB
1 10438U 76067P   24187.11291821  .00000237  00000-0  16478-2 0  9999
2 10438  65.9783  79.5306 0656633 299.9835 222.5818 12.09556349117506
0 COSMOS 839 DEB
1 10439U 76067Q   24187.63322400 -.00000047  00000-0  25943-4 0  9994
2 10439  65.7908 312.6145 0658050 127.4060 253.5684 12.24857207145809
0 COSMOS 839 DEB
1 10440U 76067R   24183.57775998  .00000081  00000-0  41666-3 0  9995
2 10440  65.6495 285.1121 0722022 335.7116  34.4888 12.40211241169387
0 COSMOS 839 DEB
1 10441U 76067S   24187.48485654 -.00000397  00000-0 -21094-2 0  9991
2 10441  65.7386   0.0665 0605966  57.1834 341.1268 12.11893343124001
0 COSMOS 839 DEB
1 10442U 76067T   24187.56036465 -.00000224  00000-0 -89132-3 0  9990
2 10442  66.0109 352.8622 0653093  16.0475  41.6970 12.16671547132702
0 COSMOS 839 DEB
1 10443U 76067U   24187.03069668  .00000216  00000-0  72295-3 0  9995
2 10443  65.8104  54.8945 0723570 161.7369 321.1239 12.47138979181361
0 COSMOS 839 DEB
1 10444U 76067V   24187.36062415  .00000159  00000-0  51029-3 0  9993
2 10444  65.7977  59.3830 0738231 136.6824 229.4703 12.51421435190069
0 COSMOS 839 DEB
1 10445U 76067W   24183.16776554 -.00000315  00000-0 -14942-2 0  9992
2 10445  65.9662  85.2268 0662763 244.6933 276.6568 12.09336704117512
0 COSMOS 839 DEB
1 10446U 76067X   24187.48663067 -.00000181  00000-0 -67925-3 0  9997
2 10446  65.8780 203.8992 0640284 340.7566 173.8061 12.16805966132803
0 COSMOS 839 DEB
1 10447U 76067Y   24187.61222523  .00000038  00000-0  30634-3 0  9997
2 10447  65.8650 339.5318 0704546 143.6364 311.6207 12.36940465166220
0 COSMOS 839 DEB
1 10448U 76067Z   24187.54942086 -.00000083  00000-0 -89693-4 0  9995
2 10448  66.1707 328.4002 0743832  40.1915  27.1990 12.37241080166584
0 COSMOS 839 DEB
1 10449U 76067AA  24187.47184338 -.00000034  00000-0  57642-4 0  9990
2 10449  66.0355 303.5355 0763475 291.4611  60.6663 12.45528672181723
0 COSMOS 839 DEB
1 10450U 76067AB  24187.18967513 -.00000021  00000-0  90779-4 0  9998
2 10450  65.7419 213.9469 0756823 323.1483  31.9694 12.46810847183862
0 COSMOS 839 DEB
1 10451U 76067AC  24187.31456904 -.00000028  00000-0  69499-4 0  9993
2 10451  65.8529  40.8440 0767929  26.6176 337.2190 12.45852245182190
0 COSMOS 839 DEB
1 10452U 76067AD  24185.69158620 -.00000345  00000-0 -19694-2 0  9990
2 10452  65.8432 152.8251 0601910 212.8931 328.4782 12.05994886113325
0 COSMOS 839 DEB
1 10453U 76067AE  24187.54560549  .00000167  00000-0  64155-3 0  9997
2 10453  65.8121 286.7273 0726303 225.3124 143.1734 12.42419699175118
0 COSMOS 839 DEB
1 10454U 76067AF  24187.57777134  .00000303  00000-0  83209-3 0  9994
2 10454  65.6626 140.4430 0725213 122.4888 244.8333 12.54861440192875
0 MOLNIYA 3-8
1 10455U 77105A   24187.22147049 -.00000001  00000-0  00000-0 0  9998
2 10455  63.6310 253.3374 7053633 282.0205  12.9366  2.00410556342165
0 TRANSAT
1 10457U 77106A   24187.54647145  .00000102  00000-0  14764-3 0  9994
2 10457  89.6543  97.2970 0023221 269.0241 265.3467 13.48817229296636
0 COSMOS 962
1 10459U 77107A   24187.61779306  .00000074  00000-0  62351-4 0  9994
2 10459  82.9517 305.9828 0027209 298.4617  72.3775 13.74803917341625
0 SL-8 R/B
1 10461U 77107B   24187.58442314  .00000096  00000-0  81458-4 0  9992
2 10461  82.9484 261.2852 0034322 138.7085 332.8826 13.76997951344898
0 SCOUT D-1 R/B
1 10462U 77106B   24187.48027551  .00000095  00000-0  13654-3 0  9994
2 10462  89.6539  97.2227 0023283 300.4287 234.4973 13.48316928720956
0 COSMOS 839 DEB
1 10463U 76067AG  24187.40847008  .00000042  00000-0  35335-3 0  9991
2 10463  65.8213 224.7733 0701261 294.9130  72.5015 12.32462403158757
0 COSMOS 839 DEB
1 10464U 76067AH  24187.38304448  .00000107  00000-0  45270-3 0  9996
2 10464  65.8297 175.9641 0710428 142.4879 341.0373 12.46474583178465
0 COSMOS 839 DEB
1 10465U 76067AJ  24186.06158609  .00000445  00000-0  10324-2 0  9993
2 10465  65.5638 183.2116 0742320 344.9623  13.0330 12.58702363476590
0 COSMOS 839 DEB
1 10466U 76067AK  24186.99073017  .00000384  00000-0  11784-2 0  9998
2 10466  65.8378  38.6221 0703812  82.3278  60.2649 12.49638364182766
0 DELTA 1 DEB
1 10469U 77065EB  24187.43757983  .00000819  00000-0  76251-3 0  9995
2 10469  29.1221 302.3895 0868426 197.9171 158.8829 12.71633570179719
0 DELTA 1 DEB
1 10470U 77065EC  24187.42473302  .00005736  00000-0  14759-2 0  9993
2 10470  29.0967  96.2406 0611431   5.2335 355.4284 13.73877957313597
0 DELTA 1 DEB
1 10471U 77065ED  24187.49972142  .00000474  00000-0  10679-3 0  9999
2 10471  29.0634 129.5761 0851528 225.2243 127.5901 13.24000840258900
0 DELTA 1 DEB
1 10478U 77065EL  24187.25737731  .00008878  00000-0  12602-2 0  9996
2 10478  29.2647  32.0880 0490807  17.0195 344.6240 14.17257848335858
0 SL-6 R/B(2)
1 10485U 77105E   24184.53318258  .00000351  00000-0  21981-2 0  9994
2 10485  63.7146 301.9027 7323365 282.4747  11.0300  1.97320066336058
0 METEOSAT 1
1 10489U 77108A   24187.54304885 -.00000313  00000-0  00000-0 0  9992
2 10489   6.8665 289.3243 0009437  96.3252 227.8154  1.00267571130075
0 DELTA 1 R/B(1)
1 10490U 77108B   24187.54767204  .00002210  00000-0  53338-3 0  9994
2 10490  28.3026   2.7799 1159114 192.7883 164.0657 12.69400796129129
0 COSMOS 963
1 10491U 77109A   24187.59018336 -.00000044  00000-0 -14778-3 0  9996
2 10491  82.9306  27.6358 0016695  71.7017 342.7278 13.17625608241993
0 SL-8 R/B
1 10492U 77109B   24187.52895707  .00000081  00000-0  16906-3 0  9999
2 10492  82.9236 347.1147 0019250 323.4126  97.8912 13.19744105244756
0 OPS 8781
1 10502U 77112A   24187.58286698  .00005949  00000-0  93796-3 0  9994
2 10502  63.3234 341.5091 0558583 150.9807 212.3560 14.03191749  8026
0 COSMOS 967
1 10512U 77116A   24187.43580360 -.00000055  00000-0  27010-4 0  9997
2 10512  65.8355  63.4298 0028579 242.5932 292.5595 13.75045586337502
0 SL-8 R/B
1 10513U 77116B   24187.53230785  .00000000  00000-0  79643-4 0  9990
2 10513  65.8307 205.5963 0032516 222.6125 261.1890 13.78730513342710
0 METEOR 2-3
1 10514U 77117A   24187.58233588  .00000163  00000-0  83856-4 0  9992
2 10514  81.2046 223.0353 0023695 186.4102 173.6770 14.10845593394466
0 SL-3 R/B
1 10515U 77117B   24187.55509126  .00000260  00000-0  14272-3 0  9997
2 10515  81.2455 296.8568 0027155 170.5792 189.5893 14.08915400392148
0 SAKURA 1A (CS-1A)
1 10516U 77118A   24186.24506840 -.00000124  00000-0  00000-0 0  9995
2 10516   9.0326 303.1368 0004274 155.6754 206.0231  0.98914039128546
0 DELTA 1 R/B(1)
1 10517U 77118B   24187.37640618  .00004206  00000-0  77746-3 0  9991
2 10517  28.6576  81.9217 0828538  72.2758 296.6432 13.43975572255407
0 SL-8 DEB
1 10518U 77116C   24187.60628899  .00000003  00000-0  84949-4 0  9998
2 10518  65.8326 320.0577 0026527 238.6239 202.0636 13.77172442339873
0 DELTA 1 DEB *
1 10519U 77118C   24187.31324886  .00002341  00000-0  69432-3 0  9994
2 10519  29.0619 254.0006 0820995 249.8176 101.2282 13.28436788241465
0 COSMOS 968
1 10520U 77119A   24187.56763367  .00000252  00000-0  94512-4 0  9992
2 10520  74.0303   7.1695 0016895  52.6408 307.6281 14.36588961436594
0 SL-8 R/B
1 10521U 77119B   24187.45044471  .00000357  00000-0  11766-3 0  9994
2 10521  74.0254 179.2161 0022118 283.3640  76.5050 14.41593248442868
0 SL-8 DEB
1 10524U 77119C   24187.57802836  .00006109  00000-0  92216-3 0  9997
2 10524  74.0272  10.0325 0009976 172.2811 187.8518 14.74496681460974
0 SL-8 DEB
1 10525U 77119D   24187.04799141  .00004689  00000-0  74421-3 0  9993
2 10525  74.0208  52.5793 0010924 248.2619 111.7391 14.72394201458828
0 SL-8 DEB
1 10526U 77116D   24187.31849307  .00000192  00000-0  26815-3 0  9990
2 10526  65.8342  30.4951 0039342 291.4901 241.3269 13.78507083338567
0 SS 1
1 10529U 77112D   24187.41210171  .00001001  00000-0  22667-3 0  9992
2 10529  63.3267 184.0172 0596781 152.1099 211.3342 13.87546635253309
0 COSMOS 970
1 10531U 77121A   24187.40942239 -.00000063  00000-0  18039-4 0  9998
2 10531  65.8539  73.5866 0145233 185.9259 174.0085 13.59833038702669
0 COSMOS 970 DEB
1 10535U 77121C   24187.32665866  .00000670  00000-0  74701-3 0  9991
2 10535  65.8503 160.5309 0113325  47.8417  68.4181 13.75216999324923
0 COSMOS 971
1 10536U 77122A   24187.63398769  .00000081  00000-0  71409-4 0  9991
2 10536  82.9349  52.5457 0020574 198.2744 214.9447 13.73325442331476
0 SL-8 R/B
1 10537U 77122B   24187.60490862  .00000025  00000-0  10511-4 0  9991
2 10537  82.9342   5.8407 0020718  37.6667  28.3508 13.75402685334842
0 COSMOS 972
1 10539U 77123A   24187.52414215  .00000065  00000-0  45649-4 0  9997
2 10539  75.8351 103.3515 0302584 304.1836  53.0952 13.88975763357235
0 SL-14 R/B
1 10541U 77123B   24187.24131051  .00000046  00000-0  34842-4 0  9995
2 10541  75.8367  95.2580 0299504 287.0725  69.7808 13.89121111357616
0 SS 2
1 10544U 77112E   24187.37070125  .00000951  00000-0  21503-3 0  9998
2 10544  63.3267 174.0554 0594191 151.9328 211.5153 13.88364355253438
0 INTELSAT 4A-F3
1 10557U 78002A   24187.51282631 -.00000262  00000-0  00000-0 0  9996
2 10557  10.3428 317.6147 0003523 217.7676  36.3593  0.99903173 41630
0 COSMOS 970 DEB
1 10562U 77121D   24187.52639517  .00000201  00000-0  51964-3 0  9993
2 10562  65.8699 112.8138 0084487  53.1633 118.8460 13.36375765266395
0 COSMOS 970 DEB
1 10563U 77121E   24187.55795898  .00001194  00000-0  98649-3 0  9995
2 10563  65.8483   4.3020 0110314 297.4300  61.5584 13.89954364338268
0 COSMOS 970 DEB
1 10564U 77121F   24187.62133168  .00000113  00000-0  20317-3 0  9997
2 10564  65.8645 278.2410 0142624  33.9479  84.7740 13.70117249323283
0 COSMOS 970 DEB
1 10565U 77121G   24187.57228280  .00000328  00000-0  47446-3 0  9992
2 10565  65.8300 345.6346 0123909 224.2034 212.7142 13.65355873311991
0 COSMOS 970 DEB *
1 10566U 77121H   24187.07612892 -.00000189  00000-0 -17211-3 0  9998
2 10566  65.7719  63.0266 0413467 212.6214 144.8661 13.24815885234555
0 COSMOS 970 DEB
1 10567U 77121J   24187.58049630  .00000022  00000-0  13897-3 0  9999
2 10567  65.7954   7.4230 0093057  93.9783 327.7644 13.55310268301399
0 COSMOS 970 DEB
1 10568U 77121K   24187.58831277  .00000350  00000-0  46973-3 0  9991
2 10568  65.7707 315.1750 0191546  84.2050 278.0808 13.64641626309803
0 COSMOS 970 DEB
1 10569U 77121L   24187.46155055  .00000379  00000-0  43551-3 0  9992
2 10569  65.3988 258.1258 0124186 109.0838 252.3719 13.77948485331679
0 COSMOS 970 DEB
1 10570U 77121M   24187.21172873  .00002209  00000-0  21613-2 0  9992
2 10570  65.3625  94.3408 0018408 278.4858 238.0675 13.81135538309239
0 COSMOS 970 DEB
1 10571U 77121N   24187.03943805  .00000589  00000-0  53992-3 0  9999
2 10571  65.9376  39.9870 0145626 350.3972   9.4318 13.85636370340588
0 COSMOS 970 DEB
1 10572U 77121P   24187.23891691  .00000146  00000-0  19915-3 0  9993
2 10572  65.0324 134.5122 0190810 220.3985 138.2772 13.78963840337285
0 COSMOS 970 DEB
1 10573U 77121Q   24187.61351854  .00000140  00000-0  31743-3 0  9995
2 10573  66.3632 133.0043 0083330 121.7869  50.4493 13.51729288293789
0 COSMOS 970 DEB
1 10574U 77121R   24187.52042806  .00000252  00000-0  42510-3 0  9998
2 10574  65.5457 225.8010 0110993 123.6340   1.9240 13.60125583304019
0 COSMOS 970 DEB
1 10575U 77121S   24187.50572999  .00000144  00000-0  28029-3 0  9997
2 10575  65.8765 208.2573 0108654 112.6958  38.2503 13.60939337308455
0 COSMOS 970 DEB
1 10576U 77121T   24187.30786885  .00000123  00000-0  22836-3 0  9994
2 10576  65.8375 122.5163 0136516 172.3370 354.8117 13.66439487317607
0 COSMOS 970 DEB
1 10577U 77121U   24187.57787837  .00000184  00000-0  28524-3 0  9999
2 10577  65.7960 296.0116 0143489 291.4885 156.2524 13.68664139320407
0 COSMOS 970 DEB
1 10578U 77121V   24187.62980652  .00000119  00000-0  21962-3 0  9993
2 10578  65.7705 272.8902 0132537  13.1742 100.8739 13.68121223319978
0 COSMOS 970 DEB
1 10579U 77121W   24187.56671838  .00000085  00000-0  32109-3 0  9997
2 10579  65.6482 329.4378 0049148  56.7324  15.8273 13.33012741261600
0 COSMOS 970 DEB
1 10580U 77121X   24187.10740200  .00000209  00000-0  47893-3 0  9993
2 10580  65.6809  51.4736 0085893 224.8967 301.3859 13.44215501278560
0 COSMOS 976
1 10581U 78005A   24187.33406876 -.00000027  00000-0 -69031-4 0  9998
2 10581  74.0299 143.0745 0004733  63.4738  48.1625 12.51279507115989
0 COSMOS 977
1 10584U 78005B   24187.55185728  .00000015  00000-0  18057-3 0  9991
2 10584  74.0284 219.5841 0040183 108.4242   7.6666 12.57970796121965
0 COSMOS 978
1 10585U 78005C   24187.50460797 -.00000016  00000-0  56063-6 0  9993
2 10585  74.0328 316.8240 0029172 230.1156 198.7928 12.55681908119929
0 COSMOS 979
1 10586U 78005D   24187.35430234  .00000011  00000-0  17175-3 0  9992
2 10586  74.0315  50.3103 0017152 326.0865 207.6506 12.53481921117966
0 COSMOS 980
1 10587U 78005E   24187.55930983  .00000020  00000-0  23967-3 0  9997
2 10587  74.0295 241.6435 0007753  26.3653  85.8898 12.48931461113901
0 COSMOS 981
1 10588U 78005F   24187.58131052 -.00000021  00000-0 -36479-4 0  9997
2 10588  74.0324 345.2206 0019993 119.5104 308.7143 12.46449995111718
0 COSMOS 982
1 10589U 78005G   24187.47705155 -.00000001  00000-0  10164-3 0  9996
2 10589  74.0312  82.3531 0033368 241.0728 292.5971 12.44121755111089
0 COSMOS 983
1 10590U 78005H   24187.44877086 -.00000002  00000-0  10083-3 0  9999
2 10590  74.0282 191.7458 0046817 354.8255   5.2301 12.41495583106654
0 SL-8 R/B
1 10591U 78005J   24187.57445021 -.00000077  00000-0 -56350-3 0  9994
2 10591  74.0323 217.1249 0144403 106.9850  11.7803 12.23333659646304
0 SS 3
1 10594U 77112F   24187.55843270  .00003766  00000-0  62914-3 0  9990
2 10594  63.3236  41.1664 0572441 152.0392 211.2713 13.99170359267549
0 COSMOS 985
1 10599U 78007A   24187.54114127  .00000082  00000-0  67214-4 0  9997
2 10599  82.9398 197.3869 0053558  26.8344 333.5565 13.76819852333943
0 SL-8 R/B
1 10600U 78007B   24187.41610590  .00000153  00000-0  13487-3 0  9992
2 10600  82.9403 159.7930 0046371 277.6012  81.9881 13.78703066336519
0 COSMOS 839 DEB
1 10613U 76067AM  24186.83466815  .00000900  00000-0  20857-2 0  9992
2 10613  65.8025  79.8261 0697789  61.4908 305.4549 12.62128120199336
0 COSMOS 839 DEB
1 10614U 76067AN  24187.57810425 -.00000040  00000-0  45753-4 0  9995
2 10614  65.7355 292.4873 0727341  81.0702   5.8805 12.41730144171655
0 COSMOS 839 DEB
1 10615U 76067AP  24186.70090130  .00000165  00000-0  55430-3 0  9992
2 10615  66.0007  43.7644 0669444 296.6843 122.8032 12.59167624468709
0 COSMOS 839 DEB
1 10616U 76067AQ  24187.20614339  .00000269  00000-0  86478-3 0  9993
2 10616  65.5961 125.3550 0722362  24.7784 338.6160 12.47518606181268
0 COSMOS 839 DEB
1 10617U 76067AR  24187.28390421 -.00000034  00000-0  67381-4 0  9999
2 10617  65.6341  24.7149 0736861  18.9344 153.3464 12.36344218165911
0 COSMOS 839 DEB
1 10618U 76067AS  24187.44073838 -.00000004  00000-0  15779-3 0  9998
2 10618  65.8393 189.1738 0722534 157.7813 354.4826 12.38828550169273
0 COSMOS 839 DEB
1 10619U 76067AT  24187.39752184 -.00000041  00000-0  57694-4 0  9995
2 10619  65.8272 184.2461 0673226 272.5727 203.2918 12.33161094160566
0 COSMOS 839 DEB
1 10620U 76067AU  24187.53878014  .00000003  00000-0  20520-3 0  9998
2 10620  65.9522 117.5078 0655062 237.5510 305.5080 12.41668741167001
0 COSMOS 839 DEB
1 10621U 76067AV  24187.48352792  .00000047  00000-0  40059-3 0  9990
2 10621  66.0233 230.4154 0664592 151.8794 320.2959 12.31052189156316
0 COSMOS 839 DEB
1 10622U 76067AW  24187.32638199 -.00000050  00000-0  12702-4 0  9992
2 10622  65.9020 175.3416 0738453  48.6755  50.5090 12.33703004161096
0 COSMOS 839 DEB
1 10623U 76067AX  24186.74394395  .00000040  00000-0  29597-3 0  9992
2 10623  65.7774 350.9847 0701545 305.7934  62.1981 12.42628071172773
0 DELTA 1 DEB
1 10626U 77065EV  24187.44439799  .00002596  00000-0  64258-3 0  9991
2 10626  29.1744 254.7387 0683380   0.3796 359.7198 13.61328259285268
0 DELTA 1 DEB
1 10627U 77065EW  24187.01872112  .00013690  00000-0  92897-2 0  9991
2 10627  28.9681  79.4804 0599575  93.6492 273.2789 13.36028395234532
0 DELTA 1 DEB
1 10629U 77065EY  24186.84921857  .00000583  00000-0  57196-3 0  9995
2 10629  29.8293  35.1717 0817961  23.2431 340.3050 12.78890955186749
0 DELTA 1 DEB
1 10630U 77065EZ  24187.56152148  .00000495  00000-0  51051-3 0  9992
2 10630  29.2353 140.6249 0790611 222.2513 131.4418 12.77162858416261
0 IUE
1 10637U 78012A   24187.08105260 -.00000275  00000-0  00000-0 0  9994
2 10637  38.3218 299.0669 1545497 253.3983  84.6389  1.00078221121949
0 DELTA 1 DEB
1 10642U 76077C   24187.44862507 -.00000014  00000-0  27107-3 0  9994
2 10642 102.1351 150.6333 0101953 218.2539 262.1794 12.21770537138107
0 DELTA 1 DEB
1 10643U 76077D   24187.51477870  .00000093  00000-0  14018-2 0  9990
2 10643 102.0304 181.7197 0169705 174.9299 310.8467 12.10258972118285
0 DELTA 1 DEB
1 10644U 76077E   24186.89686414  .00000112  00000-0  85486-3 0  9997
2 10644 101.2750 164.0087 0105044 359.9693  26.4574 12.61653642204906
0 DELTA 1 DEB
1 10645U 76077F   24187.55274296 -.00000360  00000-0 -36915-2 0  9992
2 10645 102.4112 115.5769 0225015 337.0662 199.0968 11.99159197100066
0 DELTA 1 DEB
1 10646U 76077G   24187.48352567 -.00000031  00000-0  12781-3 0  9993
2 10646 102.5520 138.2294 0143714 150.8486 321.8494 12.14429445125932
0 DELTA 1 DEB
1 10647U 76077H   24187.48811524  .00000013  00000-0  60532-3 0  9993
2 10647 102.7651 280.2506 0165291 255.8271 117.1450 12.11233797120052
0 DELTA 1 DEB
1 10648U 76077J   24187.17046799  .00000072  00000-0  10660-2 0  9995
2 10648 102.0016 249.9354 0141811 187.0840 197.5935 12.19770605133410
0 DELTA 1 DEB
1 10649U 76077K   24187.46941205  .00000048  00000-0  11226-2 0  9996
2 10649 102.2018 174.1086 0375634 182.6775 334.2271 11.80161009 52340
0 DELTA 1 DEB
1 10650U 76077L   24187.46450105 -.00000008  00000-0  40646-3 0  9998
2 10650 102.0312  17.0108 0438438  63.0052 353.5023 11.57405963 28772
0 DELTA 1 DEB
1 10652U 76077N   24186.65068761  .00000729  00000-0  90305-2 0  9998
2 10652 102.9114  81.0283 0251719 342.6295  16.6249 11.97347421 66731
0 DELTA 1 DEB
1 10653U 76077P   24187.58861683  .00000046  00000-0  82888-3 0  9996
2 10653 102.5980 292.5431 0128078 229.7784 143.2608 12.24116894142057
0 DELTA 1 DEB
1 10654U 76077Q   24187.47531411  .00000389  00000-0  14983-2 0  9998
2 10654 102.5014  35.7856 0171195 209.0253 224.4334 12.94387440250832
0 DELTA 1 DEB
1 10655U 76077R   24187.52149623 -.00000034  00000-0  12234-3 0  9991
2 10655 102.7850 276.0302 0275003 243.8519 127.8143 12.11272625120087
0 DELTA 1 DEB
1 10656U 76077S   24187.61840733  .00000005  00000-0  36647-3 0  9993
2 10656 101.7678 172.2680 0078289  11.5112 103.8235 12.37029653163720
0 DELTA 1 DEB
1 10657U 76077T   24187.54900128 -.00000016  00000-0  26545-3 0  9990
2 10657 102.5039 158.5271 0082581 233.5818 254.0729 12.25738166145105
0 DELTA 1 DEB
1 10658U 76077U   24187.57322948 -.00000032  00000-0  11294-3 0  9995
2 10658 102.3952 162.1160 0056456 202.1270 270.9334 12.29934326152435
0 DELTA 1 DEB
1 10659U 76077V   24187.54143380  .00000025  00000-0  70795-3 0  9996
2 10659 102.1056 154.2595 0173219 240.6798 242.7027 12.09247647116608
0 DELTA 1 DEB
1 10660U 76077W   24187.49893503 -.00000020  00000-0  22640-3 0  9993
2 10660 102.2317 148.1295 0397990  89.2355  30.9849 11.67399612 41036
0 DELTA 1 DEB
1 10661U 76077X   24187.61831221  .00002013  00000-0  40242-2 0  9997
2 10661 101.1870  84.4888 0136407 222.4052 206.9671 13.32742698239798
0 DELTA 1 DEB
1 10662U 76077Y   24187.44408988  .00000132  00000-0  57256-3 0  9993
2 10662 100.8339 242.5426 0265393 287.6685  84.0048 12.91301939245403
0 DELTA 1 DEB
1 10663U 76077Z   24187.27662651  .00003737  00000-0  30307-2 0  9995
2 10663 100.5891  91.2495 0131168 248.2275 110.4876 13.86915861331475
0 KYOKKO 1 (EXOS A)
1 10664U 78014A   24187.54287297  .00000222  00000-0  31319-3 0  9999
2 10664  65.3704 292.8909 1906601 187.9245 168.6971 10.75710060806214
0 OPS 6391 (FLTSATCOM 1)
1 10669U 78016A   24187.47726459 -.00000227  00000-0  00000-0 0  9992
2 10669   8.8325 298.4185 0009358 222.4824  60.4231  0.99004851747523
0 UME 2 (ISS-B)
1 10674U 78018A   24187.60188512  .00000002  00000-0  83893-4 0  9992
2 10674  69.3616 246.0734 0162695 158.6788 311.1866 13.43670420275043
0 N-1 R/B
1 10675U 78018B   24187.48523332  .00000003  00000-0  84490-4 0  9997
2 10675  69.3574 198.1038 0158842 143.8954 325.7235 13.44792570276326
0 COSMOS 990
1 10676U 78019A   24187.57734085  .00000273  00000-0  10133-3 0  9999
2 10676  74.0394  19.3954 0016474 169.8086 190.3404 14.36721527427800
0 SL-8 R/B
1 10677U 78019B   24187.54834844  .00000363  00000-0  12106-3 0  9993
2 10677  74.0365 221.5138 0014758  17.1018 343.0632 14.40943145433267
0 OPS 5111 (NAVSTAR 1)
1 10684U 78020A   24185.03808351 -.00000062  00000-0  00000+0 0  9992
2 10684  63.8277  73.8409 0080034 214.9384 144.5800  1.98072098322273
0 COSMOS 991
1 10692U 78022A   24187.62813773  .00000085  00000-0  70747-4 0  9998
2 10692  82.9873  51.7810 0037673 119.5779 300.3520 13.76459043327483
0 SL-8 R/B
1 10693U 78022B   24187.61408274  .00000053  00000-0  37667-4 0  9993
2 10693  82.9873  27.7530 0022050  32.7912  26.1309 13.77586215329241
0 LANDSAT 3
1 10702U 78026A   24187.50742304 -.00000170  00000-0 -90949-4 0  9995
2 10702  98.9628 145.5108 0013886 302.3599 167.7318 13.96848337362113
0 OSCAR 8
1 10703U 78026B   24187.55397731 -.00000165  00000-0 -81887-4 0  9996
2 10703  99.2564 161.8671 0006274  81.9819  28.2442 13.99539056364514
0 DELTA 1 R/B
1 10704U 78026C   24187.62072339  .00000088  00000-0  10593-3 0  9996
2 10704  98.8946  65.1828 0073748  71.9562 288.9614 13.88074464198851
0 DELTA 1 DEB
1 10706U 76077AB  24187.52780274  .00000571  00000-0  19052-2 0  9990
2 10706 101.5745  17.3503 0390648 170.3660 265.5788 12.82180433228220
0 DELTA 1 DEB
1 10707U 76077AC  24187.06560731 -.00000488  00000-0 -51250-2 0  9999
2 10707 102.2483 238.0001 0270786  77.1237 314.9837 11.98026193 67062
0 DELTA 1 DEB
1 10708U 76077AD  24187.59208325  .00000320  00000-0  19179-2 0  9993
2 10708 101.2339 209.2252 0163641 349.8000 129.6166 12.62639739198001
0 DELTA 1 DEB
1 10709U 76077AE  24187.40846770 -.00000267  00000-0 -15281-2 0  9998
2 10709 101.9123 251.5048 0026489  87.9029 286.0845 12.46379074177343
0 DELTA 1 DEB
1 10710U 76077AF  24187.07736649  .00000223  00000-0  30053-2 0  9990
2 10710 101.7921  44.9039 0253380 210.3579 306.0767 11.98802005 67421
0 DELTA 1 DEB
1 10711U 76077AG  24187.52473993 -.00000045  00000-0  51107-5 0  9990
2 10711 102.3926 160.3885 0063160 266.7890 217.2760 12.29230016151288
0 DELTA 1 DEB
1 10712U 76077AH  24187.59966140  .00000597  00000-0  48521-2 0  9993
2 10712 102.2208 308.1464 0064488 327.1900  44.6888 12.38838392159477
0 DELTA 1 DEB
1 10713U 76077AJ  24187.37098910  .00002659  00000-0  82314-2 0  9990
2 10713 101.5137 319.3070 0125622 332.0732  93.4945 13.03604598234656
0 DELTA 1 DEB
1 10714U 76077AK  24186.73961678 -.00000792  00000-0 -10644-1 0  9994
2 10714 103.3719 121.9374 0592367 313.6790  69.1193 11.53106769 10860
0 DELTA 1 DEB
1 10715U 76077AL  24187.46028831  .00000037  00000-0  11507-2 0  9991
2 10715 102.4678  16.9743 0432917 270.4582  96.3753 11.63876945 39384
0 DELTA 1 DEB
1 10716U 76077AM  24187.23035877  .00004867  00000-0  21937-1 0  9997
2 10716 102.8689 286.9698 0108790  55.6974   1.1190 12.77133843185702
0 DELTA 1 DEB
1 10717U 76077AN  24187.40128856 -.00000028  00000-0  15360-3 0  9998
2 10717 102.5526 160.0792 0100458 107.4826  47.1398 12.23276681140690
0 DELTA 1 DEB
1 10718U 76077AP  24187.11954117  .00000068  00000-0  79992-3 0  9998
2 10718 101.6971 229.6705 0051846 346.8435  83.2236 12.42728294172311
0 DELTA 1 DEB
1 10719U 76077AQ  24187.39758742 -.00000208  00000-0 -19017-2 0  9994
2 10719 101.9334 250.1475 0231361 242.3835 127.7042 12.01053397 95882
0 DELTA 1 DEB
1 10720U 76077AR  24187.37349062 -.00000159  00000-0 -11231-2 0  9990
2 10720 102.0491 330.8789 0357979 342.1960  43.4488 12.05500996110136
0 DELTA 1 DEB
1 10721U 76077AS  24187.37212014  .00000992  00000-0  56791-2 0  9990
2 10721 101.7815 115.0959 0050992 338.1085 139.1047 12.63517381198357
0 ATLAS CENTAUR R/B
1 10722U 78002B   24186.21062681 -.00000023  00000-0  11187-2 0  9992
2 10722  20.9783 224.3885 7175742  98.6756 354.5691  2.21833306268781
0 DELTA 1 R/B(2)
1 10723U 78012C   24187.56030488  .00544630 -20512-6  17177-2 0  9991
2 10723  29.2877 139.0944 2907785 106.8569 286.7650  9.77679352507903
0 DELTA 1 DEB
1 10728U 75027C   24187.45912538  .00000164  00000-0  14484-3 0  9993
2 10728 115.2117  15.1369 0058792 326.5166  33.2203 14.24506849553619
0 DELTA 1 DEB
1 10730U 75027E   24187.50846561  .00000370  00000-0  38597-3 0  9994
2 10730 114.9787 292.1398 0094839 164.4858 195.9146 13.94285844504926
0 COSMOS 994
1 10731U 78028A   24187.54221764  .00000067  00000-0  55205-4 0  9994
2 10731  82.9309 181.3902 0024552  86.0505  36.0693 13.73328355320126
0 SL-8 R/B
1 10732U 78028B   24187.38715549  .00000117  00000-0  10586-3 0  9994
2 10732  82.9336 139.1524 0017890 258.3550 213.5657 13.75487126323421
0 COSMOS 996
1 10744U 78031A   24187.59569731  .00000086  00000-0  72096-4 0  9994
2 10744  82.9267 268.3748 0035761 251.4092 222.5823 13.76620919323955
0 SL-8 R/B
1 10745U 78031B   24187.59597801  .00000160  00000-0  14143-3 0  9995
2 10745  82.9245 228.8195 0036459  77.0283  32.8526 13.78771316326986
0 DELTA 1 DEB
1 10746U 76077AT  24187.30654300  .00004638  00000-0  97285-2 0  9992
2 10746 101.8942 305.3147 0291438  52.4275   3.4503 13.17451507259601
0 DELTA 1 DEB
1 10747U 76077AU  24187.39300441  .00007471  00000-0  98871-2 0  9996
2 10747 101.1135  72.9936 0146718 317.9436  90.1204 13.56856394311505
0 DELTA 1 DEB
1 10748U 76077AV  24187.52576709  .00000028  00000-0  62905-3 0  9995
2 10748 102.3913 160.3704 0072604 281.6883 205.0041 12.29673663151236
0 DELTA 1 DEB
1 10749U 76077AW  24187.53102981 -.00000035  00000-0  82326-4 0  9993
2 10749 102.3743 277.3830 0091053 186.2014 187.9162 12.23520780141553
0 DELTA 1 DEB
1 10750U 76077AX  24186.88213885  .00007940  00000-0  60369-2 0  9990
2 10750 101.6637 346.7283 0435015  38.7429 324.4068 13.57279479268156
0 DELTA 1 DEB
1 10751U 76077AY  24187.15910785 -.00006520  00000-0 -84675-1 0  9995
2 10751 102.0998 263.5592 0635657  58.1564 358.8096 11.54701955 14617
0 DELTA 1 DEB
1 10752U 76077AZ  24187.54984781  .00001325  00000-0  44622-2 0  9991
2 10752 101.7044  48.4755 0372873   9.5481  53.9333 12.80611695212138
0 DELTA 1 DEB
1 10754U 76077BB  24187.53122266 -.00000034  00000-0  11109-3 0  9996
2 10754 102.6232 161.8248 0122534 245.5795 192.4437 12.21664208138531
0 DELTA 1 DEB
1 10755U 76077BC  24187.42539545 -.00000025  00000-0  18071-3 0  9992
2 10755 102.4721 153.2657 0080662 198.0177 314.5725 12.26039588145888
0 DELTA 1 DEB
1 10756U 76077BD  24187.61607535  .00000924  00000-0  68105-2 0  9998
2 10756 101.1502  78.9219 0168382  36.3375 324.8990 12.40628815151652
0 DELTA 1 DEB
1 10757U 76077BE  24187.50770623  .00000283  00000-0  36342-2 0  9992
2 10757 101.9540 287.1810 0251692 195.4888 178.9974 12.00107483 98296
0 DELTA 1 DEB
1 10758U 76077BF  24187.52353547 -.00000021  00000-0  22759-3 0  9996
2 10758 102.3621 152.1571 0156126 343.9774 133.3196 12.12775165122792
0 DELTA 1 DEB
1 10759U 76077BG  24187.46442339  .00000420  00000-0  33963-2 0  9998
2 10759 102.4872  57.6143 0064528 241.6926 243.9598 12.41894550163233
0 DELTA 1 DEB
1 10760U 76077BH  24187.43300122  .00000698  00000-0  36780-2 0  9997
2 10760 101.4830 357.3871 0546754  20.0678  32.7740 12.32635911544628
0 DELTA 1 DEB
1 10761U 76077BJ  24187.21004353  .00019742  00000-0  64114-2 0  9993
2 10761 101.4722 270.7588 0881171 277.3559  72.8360 13.16130969127033
0 DELTA 1 DEB
1 10762U 76077BK  24187.60911153 -.00001127  00000-0 -12400-1 0  9992
2 10762 102.7040 318.7427 0612584  20.0753 342.3283 11.67230460511559
0 DELTA 1 DEB
1 10763U 76077BL  24187.33849073 -.00000037  00000-0  62851-4 0  9990
2 10763 102.1362 153.0430 0045454 244.0765 281.1069 12.33788899158683
0 DELTA 1 DEB
1 10764U 76077BM  24187.39681439  .00000162  00000-0  21909-2 0  9992
2 10764 102.0501 353.9415 0226896 120.7795 271.3786 12.04537168108890
0 DELTA 1 DEB
1 10765U 76077BN  24187.57990241 -.00000018  00000-0  24013-3 0  9998
2 10765 102.0831  52.6446 0130498 188.0811 245.7726 12.16511652130024
0 DELTA 1 DEB
1 10766U 76077BP  24187.53809844 -.00000026  00000-0  16024-3 0  9995
2 10766 102.3003 157.3172 0054128  92.0781  28.0193 12.31266964154760
0 DELTA 1 DEB
1 10767U 76077BQ  24187.54926071  .00000004  00000-0  40476-3 0  9992
2 10767 102.3331 160.9719 0065698  81.7178  39.6528 12.31875092155232
0 DELTA 1 DEB
1 10768U 76077BR  24187.10733990 -.00000080  00000-0 -29867-3 0  9998
2 10768 102.4263 253.3282 0074564 144.6062 285.3997 12.28469578148723
0 DELTA 1 DEB
1 10769U 76077BS  24187.44758505  .00000041  00000-0  53357-3 0  9991
2 10769 101.7269 152.8250 0097591  50.6337  73.8947 12.52686429190327
0 COSMOS 1000
1 10776U 78034A   24187.43503588  .00000074  00000-0  61286-4 0  9999
2 10776  82.9433 156.0081 0033996 335.0181 140.3235 13.75496724321512
0 SL-8 R/B
1 10777U 78034B   24187.35922944  .00000079  00000-0  63277-4 0  9999
2 10777  82.9432 115.0257 0025845 181.2544 302.4518 13.77591068324887
0 INTELSAT 4A-F6
1 10778U 78035A   24187.11658259 -.00000022  00000-0  00000-0 0  9990
2 10778  10.1381 316.7050 0005306 269.0038  98.0965  1.00278285115022
0 ATLAS CENTAUR R/B
1 10779U 78035B   24187.31740589  .00000025  00000-0  12979-2 0  9993
2 10779  21.5099 255.7086 7173944 163.2929 246.2599  2.22718248376023
0 OPS 8790
1 10787U 78038A   24187.38591002 -.00000259  00000-0  00000-0 0  9996
2 10787   4.7825 317.4659 0013099 257.1750 130.1574  1.00493266 18118
0 YURI (BSE)
1 10792U 78039A   24186.98205870  .00000150  00000-0  00000-0 0  9992
2 10792   7.2441 291.6849 0015280 285.0093 101.5985  1.00284838111625
0 DELTA 1 R/B(1)
1 10793U 78039B   24187.37722311  .00000371  00000-0  12136-3 0  9992
2 10793  28.2242 217.3340 0879023  71.2689 298.1123 13.06506540200596
0 TRAAC DEB
1 10796U 61031D   24187.38176500  .00000085  00000-0  79438-4 0  9994
2 10796  32.4421  61.1226 0101043  59.8813 106.3977 13.63128812123051
0 OPS 6182 (DMSP 5D-1 F3)
1 10820U 78042A   24187.50449459  .00000699  00000-0  25197-3 0  9995
2 10820  98.4784  22.4867 0008641 317.7745  42.2775 14.36679401410761
0 DELTA 1 DEB
1 10823U 76077BT  24187.32718052 -.00000018  00000-0  18951-3 0  9998
2 10823 101.8928 139.2361 0044678 284.7128 231.2767 12.43702168174780
0 DELTA 1 DEB
1 10824U 76077BU  24187.35258994  .00012979  00000-0  13227-1 0  9993
2 10824 101.8784 227.8220 0046630  33.0468 341.0369 13.76346732281731
0 DELTA 1 DEB
1 10825U 76077BV  24187.41936091  .00000006  00000-0  40312-3 0  9997
2 10825 102.1715 141.1677 0044310  59.3870  55.7483 12.34729360159448
0 DELTA 1 DEB
1 10826U 76077BW  24187.46218997  .00006437  00000-0  36991-1 0  9991
2 10826 101.8204  84.7914 0179286  34.3399 139.9849 12.56127172159464
0 DELTA 1 DEB
1 10828U 76077BY  24187.61983301 -.00000039  00000-0  54991-4 0  9994
2 10828 102.4628 141.5975 0099541 149.3819  26.8440 12.22355540139768
0 DELTA 1 DEB
1 10829U 76077BZ  24187.42843289  .00000116  00000-0  12396-2 0  9990
2 10829 101.6773 164.3304 0040420   3.3556 148.7071 12.36503790161158
0 DELTA 1 DEB
1 10830U 76077CA  24187.61770712 -.00000033  00000-0  74796-4 0  9996
2 10830 101.8649 311.3098 0088907  62.5771 311.4836 12.28387311149240
0 DELTA 1 DEB
1 10831U 76077CB  24186.67522006  .00023784  00000-0  23221-1 0  9994
2 10831 101.2742 104.1134 0861759 343.0462  14.3407 12.75224659166526
0 DELTA 1 DEB
1 10832U 76077CC  24187.61012394  .00000100  00000-0  13500-2 0  9991
2 10832 102.2324 123.9078 0121134   6.3219 167.7377 12.20023945134883
0 DELTA 1 DEB
1 10833U 76077CD  24187.39698510  .00000218  00000-0  20653-2 0  9994
2 10833 102.0277 163.0584 0119400  15.5599 139.9812 12.34269336154576
0 DELTA 1 DEB
1 10834U 76077CE  24185.61290604  .00002456  00000-0  24419-1 0  9999
2 10834 100.3657 237.6484 0144032 172.8041 342.8928 12.16218856118513
0 DELTA 1 DEB
1 10835U 76077CF  24187.59497523  .00012055  00000-0  16072-1 0  9990
2 10835 102.0711 111.6509 0093161  59.9841 115.4095 13.58775427267414
0 DELTA 1 DEB
1 10836U 76077CG  24187.37002549 -.00000071  00000-0 -32474-3 0  9990
2 10836 102.0152 338.8753 0181564 204.9973 183.3732 12.07608950467694
0 DELTA 1 DEB
1 10837U 76077CH  24183.82185025  .00000263  00000-0  33738-2 0  9992
2 10837 102.2532 140.9639 0198470 328.7501  87.2741 12.04373232107490
0 DELTA 1 DEB
1 10838U 76077CJ  24187.37482741 -.00000009  00000-0  24864-3 0  9992
2 10838 101.6364 220.1664 0040475  70.3175 303.4982 12.40848254170798
0 DELTA 1 DEB
1 10840U 76077CL  24187.51376677 -.00000039  00000-0  60262-4 0  9997
2 10840 102.6311 282.0093 0142121 181.9710 191.9533 12.15999331128433
0 DELTA 1 DEB
1 10841U 76077CM  24187.56216672 -.00000001  00000-0  27725-3 0  9996
2 10841 101.8548 160.6016 0066641  38.8514  28.4693 12.52993093190516
0 DELTA 1 DEB
1 10842U 76077CN  24187.30579141 -.00000359  00000-0 -15504-2 0  9990
2 10842 102.1133 310.5892 0287250 333.3789  80.4722 12.58876317 65086
0 DELTA 1 DEB
1 10843U 76077CP  24187.13018700  .00000012  00000-0  33067-3 0  9990
2 10843 101.6069 152.6072 0116405 240.3835 183.1550 12.58479373199669
0 DELTA 1 DEB
1 10844U 76077CQ  24187.46268791  .00004413  00000-0  50752-2 0  9992
2 10844 101.2208 106.4726 0142553 177.8354 234.8589 13.65890380313250
0 DELTA 1 DEB
1 10845U 76077CR  24186.78406687  .00000055  00000-0  10161-2 0  9993
2 10845 102.3023 307.9487 0174245   4.0333 154.4623 12.10049167117280
0 OTS 2
1 10855U 78044A   24187.55125344 -.00000289  00000-0  00000-0 0  9993
2 10855   9.5427 309.3122 0005156 339.7586 342.8037  0.99142089196933
0 DELTA 1 R/B(1)
1 10856U 78044B   24187.57915054  .00000044  00000-0  41297-4 0  9996
2 10856  27.9357 206.6797 1094730 194.3720 324.7012 10.29744449737709
0 DELTA 1 DEB
1 10864U 76077CS  24187.31784285  .00000132  00000-0  22584-2 0  9995
2 10864 101.0736  31.2019 0375373 144.5778  29.7639 11.75565363 47671
0 DELTA 1 DEB
1 10865U 76077CT  24187.34765174 -.00000045  00000-0 -70639-5 0  9997
2 10865 102.2927 139.1007 0111629 327.4307 188.5912 12.20340225136041
0 DELTA 1 DEB
1 10866U 76077CU  24187.36580527 -.00000065  00000-0 -14389-3 0  9997
2 10866 102.6351 127.5207 0148723 241.4910 242.1485 12.30541835152399
0 DELTA 1 DEB
1 10867U 76077CV  24187.32037228  .00002013  00000-0  58189-2 0  9997
2 10867 101.8726 125.7272 0326576 306.0733 211.2001 12.94571118224819
0 DELTA 1 DEB
1 10868U 76077CW  24187.43118427  .00000578  00000-0  47060-2 0  9991
2 10868 102.4367   9.4462 0090804 284.0914 144.8119 12.38582703154683
0 DELTA 1 DEB
1 10869U 76077CX  24187.27580472 -.00000049  00000-0 -20969-4 0  9993
2 10869 102.2048 300.8682 0025540  33.3513 354.6212 12.43298690172843
0 DELTA 1 DEB
1 10870U 76077CY  24186.89824220  .00000573  00000-0  41503-2 0  9999
2 10870 101.6650 174.6382 0021643  90.0293 302.4977 12.48159558174964
0 DELTA 1 DEB
1 10871U 76077CZ  24187.58292108  .00000227  00000-0  18422-2 0  9991
2 10871 101.8072 176.0449 0278059  17.5730  95.6312 12.37016448159347
0 DELTA 1 DEB
1 10872U 76077DA  24187.07629799  .00000150  00000-0  16650-2 0  9992
2 10872 101.5361 237.4985 0099839 254.2279 137.2789 12.26932302144538
0 DELTA 1 DEB
1 10873U 76077DB  24187.39180067 -.00000021  00000-0  21402-3 0  9998
2 10873 102.1113 335.7117 0140339 334.2567  83.8719 12.13887667125347
0 DELTA 1 DEB
1 10874U 76077DC  24187.41287431  .00001192  00000-0  33492-2 0  9995
2 10874 102.0395 243.8538 0053942 349.0042  24.4323 13.14211435243855
0 DELTA 1 DEB
1 10875U 76077DD  24187.31367479 -.00000002  00000-0  28827-3 0  9993
2 10875 101.8808 136.1415 0032944 134.4836  23.0864 12.46984392180382
0 DELTA 1 DEB
1 10876U 76077DE  24187.56338137  .00000101  00000-0  98219-3 0  9991
2 10876 102.5828 163.1317 0101175 137.5194 345.7869 12.48657970182267
0 COSMOS 970 DEB
1 10877U 77121Y   24187.28682404  .00000292  00000-0  35537-3 0  9996
2 10877  65.7663 165.2726 0152941 284.8335  73.5829 13.75631662330574
0 COSMOS 970 DEB
1 10878U 77121Z   24187.56503525  .00000327  00000-0  47995-3 0  9994
2 10878  65.8412 356.6455 0119649 207.5439 215.1853 13.64595457311713
0 COSMOS 970 DEB
1 10879U 77121AA  24187.06744326  .00000592  00000-0  66018-3 0  9997
2 10879  65.8274  73.6476 0113858 132.5572 228.5171 13.75962367532570
0 COSMOS 970 DEB
1 10880U 77121AB  24187.54937345  .00000406  00000-0  56746-3 0  9998
2 10880  65.8418 333.6483 0115605 208.8161 227.9182 13.65426258312284
0 COSMOS 970 DEB
1 10881U 77121AC  24187.59437434  .00000347  00000-0  46671-3 0  9998
2 10881  65.8458  21.2154 0125891 128.7756 232.4630 13.68954124319874
0 COSMOS 970 DEB
1 10882U 77121AD  24187.53586623  .00000658  00000-0  71200-3 0  9999
2 10882  65.8257 357.3769 0126257 114.7623 246.6639 13.76460635328405
0 COSMOS 970 DEB
1 10883U 77121AE  24187.44729575  .00000587  00000-0  66879-3 0  9992
2 10883  65.8406 188.4210 0109888  88.1565  61.9891 13.74935108324398
0 COSMOS 970 DEB
1 10884U 77121AF  24187.59222372  .00000033  00000-0  95956-4 0  9997
2 10884  66.3890 297.5415 0198708 345.3477  14.1880 13.77406445333983
0 COSMOS 970 DEB
1 10885U 77121AG  24187.57994775  .00000728  00000-0  92521-3 0  9994
2 10885  65.7928   6.9153 0062322   4.5454  56.1038 13.68758828310083
0 COSMOS 970 DEB
1 10886U 77121AH  24187.59778273  .00000428  00000-0  53073-3 0  9996
2 10886  65.8452 294.2229 0100193 118.5062 257.9421 13.72891032322184
0 COSMOS 970 DEB
1 10887U 77121AJ  24187.48828702  .00000494  00000-0  47673-3 0  9990
2 10887  65.7433  98.1602 0165511 323.1435  35.8344 13.82804455339710
0 COSMOS 970 DEB
1 10888U 77121AK  24187.60334887  .00000304  00000-0  47279-3 0  9993
2 10888  65.5162 332.6534 0126441 213.0285 235.8159 13.61981959308294
0 COSMOS 970 DEB
1 10889U 77121AL  24186.75208740  .00000559  00000-0  62638-3 0  9995
2 10889  65.8267  61.5906 0123832 124.0572 237.2320 13.75651303326890
0 COSMOS 970 DEB
1 10890U 77121AM  24187.44819021  .00000327  00000-0  42748-3 0  9997
2 10890  65.7753 190.9714 0140286 325.0429 187.1616 13.70703986321932
0 OPS 5112 (NAVSTAR 2)
1 10893U 78047A   24186.57483051 -.00000057  00000-0  00000-0 0  9994
2 10893  63.1661 295.5774 0524658  43.9772  29.7298  2.01626403339362
0 ATLAS F R/B
1 10894U 78047B   24186.73184432  .00000975  00000-0  35912-2 0  9994
2 10894  63.8430 289.2929 5155497 194.2970 348.3038  5.03160457840650
0 COSMOS 1011
1 10917U 78053A   24187.56264691  .00000086  00000-0  72735-4 0  9994
2 10917  82.9168 247.6441 0037529 144.8806 324.8660 13.75417274314108
0 SL-8 R/B
1 10918U 78053B   24187.62213531  .00000193  00000-0  17833-3 0  9995
2 10918  82.9136 204.9937 0029981   2.2661 119.1444 13.77445965317107
0 MOLNIYA 1-40
1 10925U 78055A   24186.35385517 -.00000398  00000-0  00000-0 0  9991
2 10925  63.9126 304.0199 7145521 279.3899  12.9812  2.00524627337682
0 COSMOS 1013
1 10930U 78056A   24187.52246002 -.00000029  00000-0 -10349-3 0  9995
2 10930  74.0287 334.7326 0048153   8.8689  57.0473 12.37803687 82103
0 COSMOS 1014
1 10931U 78056B   24187.54477484  .00000021  00000-0  27179-3 0  9997
2 10931  74.0242 224.7879 0033673 243.3177 228.0825 12.40477313 86567
0 COSMOS 1015
1 10932U 78056C   24187.62294047 -.00000028  00000-0 -93201-4 0  9998
2 10932  74.0261 128.9420 0026799 110.8972  62.1671 12.42799965 90381
0 COSMOS 1016
1 10933U 78056D   24187.62312100  .00000002  00000-0  12160-3 0  9994
2 10933  74.0275  26.3951 0017284 326.2811  91.3988 12.45286981 94641
0 COSMOS 1017
1 10934U 78056E   24187.55471280 -.00000006  00000-0  64352-4 0  9998
2 10934  74.0279 290.3851 0021447 184.5351 192.9700 12.47594642 98527
0 COSMOS 1018
1 10935U 78056F   24187.46232809  .00000002  00000-0  11386-3 0  9994
2 10935  74.0240 195.0211 0028747  51.9716 117.0277 12.49891997102392
0 COSMOS 1019
1 10936U 78056G   24187.22747549 -.00000013  00000-0  20740-4 0  9999
2 10936  74.0270 101.0083 0041326 298.2974 177.8652 12.52143091106114
0 COSMOS 1020
1 10937U 78056H   24187.54809965 -.00000012  00000-0  22590-4 0  9990
2 10937  74.0280 359.9641 0049168 169.8251 190.3810 12.54539588110172
0 SL-8 R/B
1 10938U 78056J   24187.60334317 -.00000021  00000-0 -63732-4 0  9996
2 10938  74.0199 267.7400 0132501  58.8715  47.7349 12.21531291 54746
0 TITAN 3C TRANSTAGE R/B
1 10942U 78058B   24187.01059722 -.00000392  00000-0  00000-0 0  9997
2 10942   9.5116  22.6992 1446405 114.6150 261.1724  0.99627065 19672
0 SL-6 R/B(2)
1 10949U 78055E   24180.48555640  .00001025  00000-0  14473-2 0  9999
2 10949  63.8088 325.4195 7357108 279.3013  11.5311  1.97073494226009
0 GOES 3
1 10953U 78062A   24187.11475513 -.00000199  00000-0  00000-0 0  9990
2 10953   8.5145 304.6815 0002367 183.6197 185.8622  0.99364974121460
0 DELTA 1 R/B(1)
1 10954U 78062B   24187.45843443  .00000485  00000-0  11076-3 0  9994
2 10954  28.4303  98.5876 0691840 214.1623 141.2488 13.52544843264943
0 COSMOS 1023
1 10961U 78063A   24187.61552504  .00000286  00000-0  10500-3 0  9996
2 10961  74.0775 314.3633 0017165 292.3747  67.5587 14.37063453410690
0 SL-8 R/B
1 10962U 78063B   24187.57277503  .00000454  00000-0  14579-3 0  9992
2 10962  74.0783 142.8119 0023639 103.1242 257.2554 14.42041023416711
0 SEASAT 1
1 10967U 78064A   24187.54275985  .00000536  00000-0  19265-3 0  9995
2 10967 107.9979 282.2674 0002365 281.7861  78.3019 14.45006992418042
0 COSMOS 1024
1 10970U 78066A   24187.16937814  .00114617  23924-5  39718-2 0  9990
2 10970  61.9705  62.7385 7463649  46.9647 355.1046  2.09370542337158
0 SL-14 R/B
1 10974U 78067B   24187.59514212  .00000774  00000-0  79982-4 0  9997
2 10974  82.4811 248.8614 0018437  85.8939 274.4386 14.88694384469294
0 COMSTAR 3
1 10975U 78068A   24187.04869839 -.00000072  00000-0  00000-0 0  9990
2 10975  10.8191 320.0049 0019324 298.2938  59.0191  0.99199664 39125
0 ATLAS CENTAUR R/B
1 10976U 78068B   24186.76354494 -.00000100  00000-0  64787-3 0  9992
2 10976  22.0652  32.4591 7181597  40.0375  60.8104  2.22387902370311
0 GEOS 2
1 10981U 78071A   24187.18024399 -.00000251  00000-0  00000+0 0  9998
2 10981   7.3371 293.5386 0001752 336.9024  36.7836  0.99379961166908
0 RADUGA 4
1 10987U 78073A   24186.88555399  .00000096  00000-0  00000+0 0  9997
2 10987   6.5932 287.2429 0008346  19.2859 351.1517  1.00206169112441
0 THORAD DELTA 1 DEB
1 10990U 74089EK  24187.59221601 -.00000011  00000-0  16525-3 0  9990
2 10990 101.0530 206.3320 0074940  46.4582  75.3264 12.65055170291326
0 COSMOS 1027
1 10991U 78074A   24187.56342478  .00000071  00000-0  56532-4 0  9990
2 10991  82.9357 186.3277 0025812 215.6381 266.4802 13.76587354307191
0 SL-8 R/B
1 10992U 78074B   24187.46819821  .00000145  00000-0  12919-3 0  9993
2 10992  82.9335 154.9219 0020631 107.7045   8.9887 13.78090656489297
0 M-3H R/B
1 11028U 78087B   24187.49845945  .00009514  00000-0  90593-3 0  9990
2 11028  31.2214 137.9289 4106012 218.7424 103.2394  7.20489526673739
0 COSMOS 1034
1 11042U 78091A   24187.40347541  .00000006  00000-0  13479-3 0  9996
2 11042  74.0358  71.0673 0037262  34.2498 141.7216 12.53182642 93076
0 COSMOS 1035
1 11044U 78091B   24187.61781345 -.00000021  00000-0 -27576-4 0  9998
2 11044  74.0373 326.2189 0049439 263.8506 106.3276 12.55687405 97303
0 COSMOS 1036
1 11045U 78091C   24187.45644828 -.00000017  00000-0 -80458-5 0  9999
2 11045  74.0334 168.8254 0024192 147.7730  25.2127 12.50834486 89226
0 COSMOS 1037
1 11046U 78091D   24187.58364184  .00000008  00000-0  15741-3 0  9997
2 11046  74.0355 269.5649 0013369 279.6343 189.3342 12.48393658 85085
0 COSMOS 1038
1 11047U 78091E   24187.56763559  .00000001  00000-0  11346-3 0  9995
2 11047  74.0365  11.8394 0005830 118.8381 298.5997 12.45917729672485
0 COSMOS 1039
1 11048U 78091F   24187.55990781 -.00000029  00000-0 -10869-3 0  9995
2 11048  74.0374 334.9999 0046121 171.8426 257.3944 12.38013926589461
0 COSMOS 1040
1 11049U 78091G   24187.56518153  .00000013  00000-0  20907-3 0  9991
2 11049  74.0326 218.7836 0030000  43.1737  72.7749 12.40865282 72555
0 COSMOS 1041
1 11050U 78091H   24187.58822633 -.00000026  00000-0 -72417-4 0  9996
2 11050  74.0353 118.8283 0020227 267.8473 268.2323 12.43309671 76636
0 SL-8 R/B
1 11051U 78091J   24187.50301970 -.00000016  00000-0 -53747-5 0  9990
2 11051  74.0433 326.6967 0136684 249.0388 180.3762 12.20475785 38584
0 OPS 5113 (NAVSTAR 3)
1 11054U 78093A   24184.11281900 -.00000091  00000-0  00000-0 0  9990
2 11054  63.4577 321.3965 0098058 229.0504 133.5704  1.93504563326848
0 MOLNIYA 3-10
1 11057U 78095A   24187.09212961 -.00000191  00000-0 -32771-2 0  9990
2 11057  63.2798 129.9998 5651224 314.8198  11.1739  4.09908520414410
0 TIROS N
1 11060U 78096A   24187.54364842  .00000315  00000-0  17151-3 0  9993
2 11060  98.5310 227.2511 0011348 138.4330 221.7711 14.18842238577815
0 SL-6 R/B(2)
1 11076U 78083D   24186.75717947 -.00000886  00000-0  00000-0 0  9992
2 11076  65.6289 148.4468 6669511  30.3999 355.0675  1.99114457225736
0 SL-6 R/B(2)
1 11079U 78095E   24185.95577893 -.00000179  00000-0  75276-3 0  9998
2 11079  63.8039  30.1964 7139275 277.0521  13.5110  2.23590332 76610
0 NIMBUS 7
1 11080U 78098A   24187.47358419  .00000008  00000-0  48552-4 0  9991
2 11080  99.5741  51.0613 0008937   1.6742 358.4440 13.84426304308217
0 DELTA 1 R/B(+CAMEO)
1 11081U 78098B   24187.53005727  .00000067  00000-0  97385-4 0  9993
2 11081  99.3765 109.7102 0028014 254.6408 105.1652 13.85908778149444
0 COSMOS 1045
1 11084U 78100A   24187.46647394  .00000063  00000-0  70050-3 0  9999
2 11084  82.5478  84.7348 0011751 314.7899 218.9540 11.96765074996111
0 RADIO 1
1 11085U 78100B   24187.45927841  .00000004  00000-0 -54584-4 0  9998
2 11085  82.5474  88.9551 0012691 324.5930 209.0505 11.96560265995698
0 RADIO 2
1 11086U 78100C   24187.46088804  .00000057  00000-0  63119-3 0  9997
2 11086  82.5488  86.9449 0011872 315.7939 220.0592 11.96744171995766
0 SL-14 R/B
1 11087U 78100D   24187.46304971  .00000031  00000-0  29438-3 0  9992
2 11087  82.5482  79.3495 0008548 293.4399 239.3113 11.97031013996595
0 COSMOS 1048
1 11111U 78105A   24187.44612664  .00000206  00000-0  81853-4 0  9998
2 11111  74.0248 200.4152 0015319 128.6919 231.5606 14.34764449385994
0 SL-8 R/B
1 11112U 78105B   24187.51945776  .00000446  00000-0  15493-3 0  9992
2 11112  74.0307 106.5034 0033276 354.3492   5.7281 14.38042223389775
0 SL-8 DEB
1 11113U 78105C   24187.44672414  .00005768  00000-0  84381-3 0  9995
2 11113  74.0252  89.3420 0006824 131.4124 228.7637 14.75879760414380
0 SL-8 DEB
1 11114U 78105D   24187.35995907  .00010549  00000-0  11316-2 0  9991
2 11114  74.0058 169.7278 0007477 251.9992 108.0374 14.88682005422335
0 NATO 3C
1 11115U 78106A   24186.98449534  .00000012  00000-0  00000-0 0  9991
2 11115  10.4510 319.7644 0001315 266.0204 106.1559  0.98481196648209
0 COSMOS 1051
1 11128U 78109A   24187.62805056 -.00000012  00000-0  21582-4 0  9998
2 11128  74.0180 291.0687 0058265  29.3068  73.9228 12.55947669 89789
0 COSMOS 1052
1 11129U 78109B   24187.59006459  .00000003  00000-0  12002-3 0  9990
2 11129  74.0175  24.2685 0049277 146.0726 270.7557 12.53710409 86135
0 COSMOS 1053
1 11130U 78109C   24187.54690946 -.00000022  00000-0 -40364-4 0  9993
2 11130  74.0168 117.0460 0037785 253.5728 280.0297 12.51481274 82468
0 COSMOS 1054
1 11131U 78109D   24187.52900277  .00000011  00000-0  17858-3 0  9990
2 11131  74.0138 207.2750 0027312   5.7953 110.8741 12.49295282 78853
0 COSMOS 1055
1 11132U 78109E   24187.60313628 -.00000014  00000-0  13881-4 0  9995
2 11132  74.0186 304.8318 0016529 137.9784 235.0785 12.46935590 74864
0 COSMOS 1056
1 11133U 78109F   24187.58999998  .00000009  00000-0  17630-3 0  9991
2 11133  74.0170  44.4341 0020253 293.1510 131.7096 12.44499755 70816
0 COSMOS 1057
1 11134U 78109G   24187.63065038 -.00000031  00000-0 -11017-3 0  9997
2 11134  74.0156 141.9873 0021443  81.8380  92.3353 12.42114764 66885
0 COSMOS 1058
1 11135U 78109H   24187.61809977  .00000016  00000-0  23893-3 0  9990
2 11135  74.0155 249.1100 0036752 211.3085 262.2860 12.39487932 62490
0 SL-8 R/B
1 11136U 78109J   24187.59225790 -.00000013  00000-0  87623-5 0  9994
2 11136  74.0166 340.3531 0130434  77.7193 283.8410 12.19164716 29012
0 OPS 5114 (NAVSTAR 4)
1 11141U 78112A   24183.90316583 -.00000060  00000-0  00000-0 0  9997
2 11141  63.2451  92.7419 0137200  47.0988 130.6123  1.92895579215292
0 ATLAS F R/B
1 11142U 78112B   24187.17622084 -.00000044  00000-0 -12821-2 0  9996
2 11142  64.2957 114.2313 4612815 271.7482 314.3848  5.34622811877608
0 OPS 9441 (DSCS 2-11)
1 11144U 78113A   24187.58484587 -.00000141  00000-0  00000-0 0  9999
2 11144  12.1682 319.4595 0029197 183.0851 137.2187  0.94032874104857
0 OPS 9442 (DSCS 2-12)
1 11145U 78113B   24187.57063265 -.00000192  00000-0  00000-0 0  9991
2 11145   9.8131 308.6313 0008290 167.6759 189.0727  0.98443070110056
0 TITAN 3C TRANSTAGE R/B
1 11147U 78113D   24187.11614749 -.00000215  00000-0  00000-0 0  9998
2 11147  12.3566 311.2397 0256445  50.8834 321.5233  0.93756599107694
0 ANIK B1 (TELESAT-4)
1 11153U 78116A   24187.11536428 -.00000148  00000-0  00000-0 0  9990
2 11153  10.7760 320.9143 0015758 303.8090  52.2590  0.99821473128912
0 GORIZONT 1
1 11158U 78118A   24186.49764648 -.00000072  00000-0  00000-0 0  9990
2 11158  11.4829 176.8878 3247666 322.1945  18.6604  1.00250156115796
0 COSMOS 1066
1 11165U 78121A   24187.60149131  .00000123  00000-0  60070-4 0  9993
2 11165  81.2359 231.1914 0048669 316.9724  42.7646 14.11872429860901
0 SL-3 R/B
1 11166U 78121B   24187.48406264  .00000084  00000-0  36345-4 0  9997
2 11166  81.2383 178.7082 0067034 129.8318 230.8781 14.14018943347623
0 COSMOS 1067
1 11168U 78122A   24187.49912638  .00000023  00000-0  24161-4 0  9994
2 11168  82.9733 332.2386 0035813 190.3345 235.7425 13.20201977177198
0 SL-8 R/B
1 11170U 78122B   24187.53812958 -.00000002  00000-0 -36242-4 0  9998
2 11170  82.9728 296.9826 0026068  41.4765 329.5521 13.22118652178834
0 COSMOS 1072
1 11238U 79003A   24187.58472692  .00000083  00000-0  71363-4 0  9994
2 11238  82.9409  12.4669 0037946 148.7253 272.5475 13.74278684279635
0 SL-8 R/B
1 11239U 79003B   24187.56397063  .00000127  00000-0  11383-3 0  9995
2 11239  82.9395 336.8067 0041590  40.3261  31.3953 13.75997273281998
0 SCATHA
1 11256U 79007A   24187.54094400 -.00000212  00000-0  00000-0 0  9992
2 11256  11.5192 287.6841 1728538 114.9560 212.3086  1.01526991135221
0 AYAME 1 (ECS 1)
1 11261U 79009A   24187.15304507 -.00000102  00000-0  00000-0 0  9997
2 11261  10.3971 340.9822 3631957  62.2774  71.5373  1.68581850164159
0 SL-14 R/B
1 11267U 79011B   24187.39002619  .00000907  00000-0  90333-4 0  9995
2 11267  82.5256 316.9134 0015199 304.4810  55.4972 14.90453219437520
0 EKRAN 3
1 11273U 79015A   24187.58482872 -.00000276  00000-0  00000-0 0  9998
2 11273   6.9077 289.6706 0037797 348.9187 311.8624  1.00301980127878
0 METEOR 2-4
1 11288U 79021A   24187.54849166  .00000174  00000-0  87980-4 0  9992
2 11288  81.2174 115.4202 0024617 152.8639 207.3826 14.12108801334570
0 SL-3 R/B
1 11289U 79021B   24187.46982184  .00000078  00000-0  34371-4 0  9991
2 11289  81.2460 171.3817 0076330 124.4862 236.3551 14.11860029333914
0 SL-3 DEB
1 11290U 79021C   24187.52166576  .00000044  00000-0  17810-4 0  9991
2 11290  81.2037 114.5522 0030332 303.6097  56.2180 14.11060754333702
0 COSMOS 1081
1 11296U 79024A   24187.57458385  .00000011  00000-0  16114-3 0  9996
2 11296  74.0333 263.0873 0038811  71.3862  37.4106 12.57273907 79480
0 COSMOS 1082
1 11297U 79024B   24187.62363108 -.00000012  00000-0  24685-4 0  9996
2 11297  74.0356   0.7543 0026823 193.8418 234.8172 12.54945731675502
0 COSMOS 1083
1 11298U 79024C   24187.51254309 -.00000006  00000-0  66843-4 0  9992
2 11298  74.0340  96.3597 0015064 297.7633 235.7326 12.52598245 71765
0 COSMOS 1084
1 11299U 79024D   24187.50094398 -.00000006  00000-0  62017-4 0  9991
2 11299  74.0309 185.5880 0001201 111.9632   6.5268 12.50475292 68142
0 COSMOS 1085
1 11300U 79024E   24187.56499163  .00000013  00000-0  19754-3 0  9995
2 11300  74.0340  35.4928 0024284  83.5504 341.2212 12.45276873 59702
0 COSMOS 1086
1 11301U 79024F   24187.58530848 -.00000005  00000-0  74500-4 0  9997
2 11301  74.0350 290.2090 0010911 337.4471  33.4677 12.47866525 63881
0 COSMOS 1087
1 11302U 79024G   24187.62642846 -.00000025  00000-0 -66790-4 0  9990
2 11302  74.0329 133.2309 0037578 206.4766 328.9261 12.42862427 55623
0 COSMOS 1088
1 11303U 79024H   24187.61815345  .00000022  00000-0  28191-3 0  9993
2 11303  74.0322 243.2982 0052193 323.0428 150.7760 12.40145242 51265
0 SL-8 R/B
1 11304U 79024J   24187.39164297  .00000043  00000-0  51877-3 0  9992
2 11304  74.0383 167.4061 0145131 322.3636  36.7313 12.24238801 24753
0 COSMOS 1089
1 11308U 79026A   24187.47413302  .00000069  00000-0  55527-4 0  9996
2 11308  82.9766 320.2245 0021985 201.7809 224.6494 13.75311215271553
0 SL-8 R/B
1 11309U 79026B   24187.50409229  .00000090  00000-0  75144-4 0  9995
2 11309  82.9697 278.4632 0020374  71.6272 288.7099 13.77382414274387
0 COSMOS 1091
1 11320U 79028A   24187.58589053  .00000060  00000-0  47658-4 0  9998
2 11320  82.9242 301.7658 0030157 350.0360  20.3847 13.74808016269356
0 SL-8 R/B
1 11321U 79028B   24187.57682066  .00000094  00000-0  80023-4 0  9996
2 11321  82.9226 264.4526 0017962 224.5556 257.8830 13.76663431272343
0 COSMOS 1092
1 11326U 79030A   24187.56189417  .00000099  00000-0  87435-4 0  9994
2 11326  82.9473 212.9946 0027777 288.6838 182.5586 13.75532873504552
0 SL-8 R/B
1 11327U 79030B   24187.51425247  .00000004  00000-0 -11360-4 0  9995
2 11327  82.9497 183.6915 0027900 167.2411 312.1834 13.77078796273333
0 RADUGA 5
1 11343U 79035A   24186.91705778 -.00000179  00000-0  00000-0 0  9999
2 11343   7.0763 290.3912 0006329 193.9335 214.0859  1.00280856122213
0 OPS 6392 (FLTSATCOM 2)
1 11353U 79038A   24187.01390898 -.00000085  00000-0  00000-0 0  9994
2 11353   9.2950 307.8022 0015268  79.8841 102.2829  0.98544679163366
0 COSMOS 1104
1 11378U 79046A   24187.59292766  .00000080  00000-0  66195-4 0  9993
2 11378  82.9450 228.2780 0033490  36.4426  73.1865 13.75901334263718
0 SL-8 R/B
1 11379U 79046B   24187.57430973  .00000087  00000-0  72242-4 0  9993
2 11379  82.9433 192.4913 0021159 185.9403 293.7887 13.77623799228111
0 OPS 5390
1 11389U 79050A   24187.49151128  .00000323  00000-0  14521-3 0  9990
2 11389  98.5317 142.1531 0013170  72.1939 288.0679 14.28725173274055
0 OPS 7484
1 11397U 79053A   24187.58439861 -.00000051  00000-0  00000-0 0  9998
2 11397   8.8734 302.8265 0008641 261.6033  29.6848  0.98745481 18955
0 NOAA 6
1 11416U 79057A   24187.59616236  .00000539  00000-0  20652-3 0  9996
2 11416  98.6279 208.7966 0009675 199.4089 160.6729 14.34560443348898
0 COSMOS 1109
1 11417U 79058A   24186.35471407  .00000828  00000-0  00000-0 0  9993
2 11417  70.4787 227.7254 5576410 221.4276  79.1707  2.01385619219480
0 COSMOS 1110
1 11425U 79060A   24187.50032937  .00000253  00000-0  10030-3 0  9993
2 11425  74.0145 112.5375 0014207 340.5427  19.5180 14.33763063352368
0 SL-8 R/B
1 11427U 79060B   24187.58417792  .00000426  00000-0  14876-3 0  9993
2 11427  74.0178 321.9858 0020116 207.3193 152.6905 14.38144322357707
0 TITAN 3C TRANSTAGE R/B
1 11436U 79053C   24186.59008833 -.00000211  00000-0  00000-0 0  9991
2 11436   8.5469 300.8363 0057579 284.4214  75.0862  0.99450768 19455
0 GORIZONT 2
1 11440U 79062A   24186.91448132  .00000044  00000-0  00000-0 0  9995
2 11440   7.4919 293.3398 0002158 289.6092  91.0927  1.00255842130886
0 WESTAR 3
1 11484U 79072A   24186.80605039 -.00000288  00000-0  00000-0 0  9994
2 11484  11.4034 325.9579 0001982 177.9213  21.7148  0.99950436133390
0 COSMOS 1125
1 11510U 79078A   24187.56834045  .00000247  00000-0  98519-4 0  9995
2 11510  74.0348  37.4392 0011711  75.2149 285.0299 14.33652113343434
0 SL-8 R/B
1 11511U 79078B   24187.54898591  .00000370  00000-0  13176-3 0  9992
2 11511  74.0357 260.0336 0016319 237.6318 122.3257 14.37609669348252
0 COSMOS 1130
1 11538U 79084A   24187.58526363 -.00000014  00000-0  13499-4 0  9992
2 11538  74.0260 296.7101 0052400  88.7416 285.0681 12.56252128 53451
0 COSMOS 1131
1 11539U 79084B   24187.56573434 -.00000007  00000-0  58855-4 0  9999
2 11539  74.0257  13.6316 0045851 187.3194 230.9758 12.54374831 50357
0 COSMOS 1132
1 11540U 79084C   24187.47150168  .00000000  00000-0  10284-3 0  9991
2 11540  74.0252  84.2654 0036605 268.2621 265.3456 12.52650435 47543
0 COSMOS 1133
1 11541U 79084D   24187.36744954 -.00000022  00000-0 -36780-4 0  9998
2 11541  74.0228 156.5668 0028025 358.5233 155.9659 12.50866238978768
0 COSMOS 1134
1 11542U 79084E   24187.56466979  .00000017  00000-0  22100-3 0  9991
2 11542  74.0226 229.9663 0018328  93.2900  21.0880 12.49062114 41754
0 COSMOS 1135
1 11543U 79084F   24187.58303630 -.00000022  00000-0 -38968-4 0  9996
2 11543  74.0263 309.4833 0019473 220.3686 150.3367 12.47086659 38474
0 COSMOS 1136
1 11544U 79084G   24187.63032400 -.00000002  00000-0  94669-4 0  9994
2 11544  74.0253  21.7362 0015742 335.4840  93.1106 12.45293634 35530
0 COSMOS 1137
1 11545U 79084H   24187.55345547 -.00000014  00000-0  10157-4 0  9998
2 11545  74.0249 106.9504 0026057  88.1655  86.3297 12.43182386 32088
0 SL-8 R/B
1 11546U 79084J   24187.53219819  .00000086  00000-0  92648-3 0  9991
2 11546  74.0202 211.3031 0126274 347.5989 127.7778 12.22309119997927
0 SL-6 R/B(2)
1 11550U 79077D   24186.82751580  .00006314  00000-0  24919-2 0  9990
2 11550  62.5150  30.6899 7509086  54.5631 354.3320  1.99919043325888
0 OPS 1948
1 11558U 79086A   24187.44308610  .00000013  00000-0  00000-0 0  9992
2 11558   5.6613   5.6945 1312892  71.9672 198.8707  1.00205647 19072
0 TITAN 3C TRANSTAGE R/B
1 11560U 79086C   24186.97539930 -.00000356  00000-0  00000-0 0  9994
2 11560   5.5399   6.1429 1336164 119.2424 254.8878  0.99676111 19142
0 EKRAN 4
1 11561U 79087A   24186.92160953 -.00000238  00000-0  00000-0 0  9995
2 11561   7.3589 292.3865 0014643 175.5584 239.7298  1.00241157 40236
0 SL-12 R/B(2)
1 11567U 74017F   24187.13520544 -.00000323  00000-0  00000-0 0  9994
2 11567   2.5070 271.4172 0043868  59.0169  93.1826  1.01007065185484
0 SL-12 R/B(2)
1 11568U 75123F   24187.04991671  .00000153  00000-0  00000-0 0  9997
2 11568   4.3845 276.3855 0017319 193.8706 214.3415  1.00494255114846
0 SL-12 R/B(2)
1 11569U 76107F   24186.87894341 -.00000079  00000-0  00000-0 0  9995
2 11569   4.5784 275.0908 0013066 183.1539 189.3367  1.01460674178270
0 SL-12 R/B(2)
1 11570U 77071F   24187.43799362 -.00000034  00000-0  00000-0 0  9999
2 11570   7.4841 290.3647 0011956 141.6956 281.4345  0.97736641112447
0 SL-12 R/B(2)
1 11571U 77092G   24186.89841062 -.00000085  00000-0  00000-0 0  9993
2 11571   5.3504 280.1836 0012259 169.4379 209.4009  1.01287733115744
0 COSMOS 1140
1 11573U 79089A   24187.60058946  .00000273  00000-0  10055-3 0  9996
2 11573  74.0679 293.3724 0016264 219.1150 140.8829 14.37116858342612
0 SL-8 R/B
1 11574U 79089B   24187.58858201  .00000434  00000-0  14120-3 0  9992
2 11574  74.0687 143.5032 0014574 114.4588 245.8090 14.41578141347875
0 EKRAN 2 DEB
1 11581U 77092H   24187.53862324 -.00000338  00000-0  00000-0 0  9991
2 11581   5.9656 283.5884 0016007 207.7184 115.3144  1.00254303 97227
0 COSMOS 1141
1 11585U 79090A   24187.58998984  .00000079  00000-0  64409-4 0  9990
2 11585  82.9492 359.6036 0028568 330.9341  94.6487 13.77084158227700
0 SL-8 R/B
1 11586U 79090B   24187.61870833  .00000072  00000-0  54876-4 0  9997
2 11586  82.9456 312.6141 0027157 180.4906 179.6231 13.79181728229442
0 SL-8 DEB
1 11587U 78007C   24187.58877582  .00051845  00000-0  51659-2 0  9997
2 11587  82.9015 298.9789 0006202 143.4231 216.7414 14.91327754285271
0 METEOR 2-5
1 11605U 79095A   24187.56118131  .00000083  00000-0  41861-4 0  9996
2 11605  81.2081 203.6709 0011891  95.4374 264.8152 14.07280107293208
0 SL-3 R/B
1 11608U 79095B   24187.57730436  .00000171  00000-0  94443-4 0  9990
2 11608  81.2117 231.4668 0054802 126.5987 234.0242 14.06365513291783
0 OPS 9443 (DSCS 2-13)
1 11621U 79098A   24186.90396799 -.00000073  00000-0  00000-0 0  9998
2 11621  11.6620 317.8102 0010403 128.4516 231.6644  0.95598204608581
0 OPS 9444 (DSCS 2-14)
1 11622U 79098B   24187.55415325 -.00000093  00000-0  00000-0 0  9990
2 11622  10.0112 310.9352 0004412 122.9886 252.6184  0.98351337104988
0 TITAN 3C TRANSTAGE R/B
1 11623U 79098C   24186.86507606 -.00000131  00000-0  00000-0 0  9991
2 11623  11.7578 311.3457 0295770  58.8517 306.1563  0.95318216115806
0 OPS 4682 DEB
1 11631U 65027F   24187.42154186 -.00000059  00000-0 -23105-3 0  9995
2 11631  90.2399 350.3803 0042815 143.4575 245.4834 12.96413317 33549
0 SATCOM 3
1 11635U 79101A   24186.78661215 -.00000164  00000-0  00000-0 0  9993
2 11635   7.7246 152.0275 4848541 332.3999 265.3837  1.82527605210966
0 DELTA 1 R/B(1)
1 11636U 79101B   24187.56050278  .00000444  00000-0  21422-3 0  9996
2 11636  28.2236 131.4273 1264373 296.3966  51.2255 12.20472526910146
0 GORIZONT 3
1 11648U 79105A   24186.98171061  .00000153  00000-0  00000-0 0  9995
2 11648   7.6665 294.9659 0012722 235.2212 146.2651  1.00265042115346
0 COSMOS 1150
1 11667U 80003A   24187.51917324  .00000055  00000-0  41809-4 0  9992
2 11667  82.9563 343.6755 0033468 104.7583 318.6119 13.73580476224664
0 SL-8 R/B
1 11668U 80003B   24187.56414891  .00000075  00000-0  61957-4 0  9997
2 11668  82.9501 297.4209 0020660 313.5247  57.2148 13.75809287232263
0 OPS 6393 (FLTSATCOM 3)
1 11669U 80004A   24187.17754628 -.00000286  00000-0  00000-0 0  9994
2 11669   7.6519 310.0314 0024430 221.0788 120.9141  1.00348090162716
0 SL-14 R/B
1 11672U 80005B   24187.47107419  .00000940  00000-0  95909-4 0  9994
2 11672  82.5150 167.3740 0017389  47.8964 312.3730 14.89476171385300
0 SL-12 R/B(2)
1 11676U 75097F   24187.47415127  .00000118  00000-0  00000-0 0  9992
2 11676   4.2024 274.8058 0025093 201.0451 199.8059  1.00102248112015
0 COSMOS 1153
1 11680U 80007A   24187.52156054  .00000068  00000-0  55760-4 0  9992
2 11680  82.9335 337.3432 0037705 155.4447 270.8954 13.73768394224795
0 SL-8 R/B
1 11681U 80007B   24187.62226156  .00000099  00000-0  87149-4 0  9995
2 11681  82.9325 301.9689 0036182   3.1583   8.0999 13.75614617226415
0 SL-12 R/B(2)
1 11684U 79105E   24187.07063389 -.00000135  00000-0  00000-0 0  9990
2 11684   8.5747 298.7254 0015866 280.8164  99.8175  0.98686876114008
0 OPS 5117 (NAVSTAR 5)
1 11690U 80011A   24185.69552782 -.00000057  00000-0  00000-0 0  9994
2 11690  64.2737  70.4693 0480254 204.2387   1.1731  2.00575611339416
0 COSMOS 1156
1 11691U 80012A   24187.59440431  .00000008  00000-0  14651-3 0  9999
2 11691  74.0212 268.7728 0049317 276.2655 191.3597 12.56880120 36976
0 COSMOS 1157
1 11692U 80012B   24187.60134310 -.00000011  00000-0  32726-4 0  9997
2 11692  74.0224   3.4234 0039320  36.3039  29.1613 12.54550539 33206
0 COSMOS 1158
1 11693U 80012C   24187.52345843 -.00000002  00000-0  90649-4 0  9992
2 11693  74.0216  93.3291 0027183 143.7040  29.2714 12.52332448 29627
0 COSMOS 1159
1 11694U 80012D   24187.43386336 -.00000007  00000-0  56467-4 0  9990
2 11694  74.0185 182.8286 0018806 264.1335 265.2019 12.50109919 26022
0 COSMOS 1160
1 11695U 80012E   24187.59447826 -.00000003  00000-0  85126-4 0  9990
2 11695  74.0219 277.2668 0011029  52.2433  56.5625 12.47758648 22226
0 COSMOS 1161
1 11696U 80012F   24187.55122604  .00000000  00000-0  10924-3 0  9990
2 11696  74.0218  20.8168 0022159 210.0512 149.9266 12.45156043 18032
0 COSMOS 1162
1 11697U 80012G   24187.55208108 -.00000025  00000-0 -69717-4 0  9999
2 11697  74.0209 117.7004 0029904 344.7991 188.4944 12.42726610 14081
0 COSMOS 1163
1 11698U 80012H   24187.61233943  .00000015  00000-0  22374-3 0  9996
2 11698  74.0189 228.5926 0044911 111.1198  10.2747 12.39934251  9190
0 SL-8 R/B
1 11699U 80012J   24187.43769957 -.00000088  00000-0 -66583-3 0  9998
2 11699  74.0121 181.3071 0141774 180.1626 296.6096 12.22633305981421
0 ATLAS 35F R/B
1 11705U 80011B   24187.15491547  .00000002  00000-0  00000-0 0  9994
2 11705  64.4075 111.1056 4783038 277.8730  32.4076  4.97664000803856
0 RADUGA 6
1 11708U 80016A   24186.98205870  .00000149  00000-0  00000-0 0  9996
2 11708   7.4653 293.8922 0002474 225.2008 159.4107  1.00274094115028
0 AYAME 2 (ECS-2)
1 11715U 80018A   24183.77101345 -.00000134  00000-0  00000-0 0  9997
2 11715   8.3635  87.4891 4435743 192.3055 356.5235  1.75494238222473
0 SL-12 R/B(2)
1 11728U 80016D   24187.17806844 -.00000102  00000-0  00000+0 0  9997
2 11728   9.0209 300.2289 0014343 273.7616  81.0878  0.97624510112653
0 COSMOS 1168
1 11735U 80022A   24187.47373323  .00000076  00000-0  63675-4 0  9997
2 11735  82.9462  81.5728 0035241 184.6793 348.6375 13.75132162222333
0 SL-8 R/B
1 11736U 80022B   24187.58984037  .00000158  00000-0  14404-3 0  9996
2 11736  82.9418  45.7126 0034760  91.7605 268.7534 13.76669874224836
0 COSMOS 1171
1 11750U 80026A   24187.38944485 -.00000059  00000-0  22838-4 0  9999
2 11750  65.8426  66.2289 0031441 278.2855 257.5811 13.73743630219738
0 SL-8 R/B
1 11751U 80026B   24187.58560459 -.00000038  00000-0  43160-4 0  9995
2 11751  65.8394 236.7177 0019096 295.3873 222.6398 13.77213190224247
0 SL-8 DEB
1 11752U 80026C   24187.62260844 -.00000013  00000-0  70380-4 0  9993
2 11752  65.8432   6.9900 0031873 267.9249 164.0362 13.75216574221234
0 COSMOS 1174
1 11765U 80030A   24187.56001413  .00004487  00000-0  21024-3 0  9998
2 11765  66.0840  58.8564 0510809 188.0169 171.2546 14.49299111275458
0 COSMOS 1174 DEB
1 11778U 80030K   24187.59061313  .00001686  00000-0  70121-3 0  9990
2 11778  66.4801 318.3853 0443035  48.7661 315.0715 13.86523635185023
0 OPS 5118 (NAVSTAR 6)
1 11783U 80032A   24184.37139934 -.00000023  00000-0  00000-0 0  9997
2 11783  62.1966 272.7611 0539063  54.0916 335.4717  2.03456048327216
0 COSMOS 1176
1 11788U 80034A   24187.44708941 -.00000049  00000-0  32926-4 0  9999
2 11788  64.8293  96.3545 0033330 158.2737 201.9749 13.93057134242675
0 DELTA 1 R/B(2) *
1 11792U 66096C   24187.20556290  .00003451  00000-0  61819-2 0  9998
2 11792  17.7988 210.8682 6131893  45.4557 350.7252  3.70617883404454
0 COSMOS 1181
1 11803U 80039A   24187.61767025  .00000086  00000-0  75327-4 0  9991
2 11803  82.9421  22.1674 0023608  63.7497 357.9481 13.74101947212232
0 SL-8 R/B
1 11804U 80039B   24187.52625425  .00000086  00000-0  72134-4 0  9992
2 11804  82.9438 339.4107 0019615 237.1856 122.7412 13.76427971215353
0 GORIZONT 4
1 11841U 80049A   24187.50992039 -.00000005  00000-0  00000-0 0  9991
2 11841   8.8664 301.4967 0000383 279.1701 105.2337  0.98629290226501
0 SL-6 R/B(2)
1 11847U 80050B   24186.92438346  .00000237  00000-0  00000-0 0  9996
2 11847  66.2172  63.4138 6760753 332.6076   4.1589  1.99579113320358
0 OPS 1292
1 11852U 80052C   24187.53929981  .00000080  00000-0  41264-3 0  9998
2 11852  96.6086  34.7606 0003206 132.3938 227.7439 12.83639946  6674
0 SL-12 R/B(2)
1 11862U 80049F   24187.51143727 -.00000052  00000-0  00000-0 0  9999
2 11862   9.3332 302.3380 0031890 195.8869 191.1384  0.97938953113247
0 COSMOS 1190
1 11869U 80056A   24187.57469270  .00000227  00000-0  90174-4 0  9992
2 11869  74.0459 258.3470 0014756 275.9720  83.9750 14.34156453278252
0 SL-8 R/B
1 11870U 80056B   24187.37812050  .00000310  00000-0  11180-3 0  9992
2 11870  74.0521 156.8806 0016543 193.6612 166.4097 14.37699968280879
0 COSMOS 1191
1 11871U 80057A   24186.93056595  .00000350  00000-0  00000-0 0  9999
2 11871  65.6976 137.2978 6659098  28.1809 355.4002  2.01003482229155
0 COSMOS 1192
1 11875U 80058A   24187.59138677  .00000013  00000-0  17327-3 0  9998
2 11875  74.0174 255.1136 0049086 124.1035 346.2639 12.57190985 18877
0 COSMOS 1193
1 11876U 80058B   24187.57801058 -.00000018  00000-0 -13103-4 0  9993
2 11876  74.0198 345.9557 0039332 237.7283 188.6821 12.54934150 15233
0 COSMOS 1194
1 11877U 80058C   24187.13722655  .00000001  00000-0  10923-3 0  9997
2 11877  74.0186  72.9021 0027155 333.9827  25.9858 12.52783066 11771
0 COSMOS 1195
1 11878U 80058D   24187.40855476 -.00000022  00000-0 -41886-4 0  9994
2 11878  74.0163 159.6327 0015393  83.1396  35.2688 12.50599229  8376
0 COSMOS 1196
1 11879U 80058E   24187.63077575  .00000019  00000-0  23657-3 0  9995
2 11879  74.0170 247.4632 0005136 218.2415 259.4640 12.48392932483618
0 COSMOS 1197
1 11880U 80058F   24187.56784995 -.00000028  00000-0 -82254-4 0  9991
2 11880  74.0197 342.3593 0013181  42.0984 318.1075 12.45994832   897
0 COSMOS 1198
1 11881U 80058G   24187.16272480  .00000006  00000-0  15431-3 0  9995
2 11881  74.0185  70.5387 0022129 176.7355 299.9840 12.43777397997316
0 COSMOS 1199
1 11882U 80058H   24187.38945449 -.00000016  00000-0 -27843-5 0  9997
2 11882  74.0159 172.3140 0037149 285.8124 185.2518 12.41190856993154
0 SL-8 R/B
1 11883U 80058J   24187.54526240 -.00000034  00000-0 -17257-3 0  9996
2 11883  74.0099 114.7519 0133464 345.5684 187.4174 12.23976661965517
0 SL-6 R/B(2)
1 11888U 80057D   24187.09876508 -.00000274  00000-0  00000-0 0  9995
2 11888  64.3754  43.3207 7169283  34.2623 356.1004  1.99415670320547
0 MOLNIYA 3-13
1 11896U 80063A   24186.61851484 -.00000186  00000-0  00000+0 0  9995
2 11896  63.3597  33.0270 7327356 278.2122  11.8879  2.00575467322155
0 SL-6 R/B(2)
1 11909U 80063D   24183.90185988  .00001202  00000-0  00000-0 0  9998
2 11909  63.0164 115.8427 7102048 276.9694  13.8908  1.96859330315546
0 SL-12 R/B(2)
1 11926U 78118C   24186.88199318 -.00000218  00000-0  00000-0 0  9994
2 11926  11.6753 169.6931 3149066 333.6044 227.7810  1.01602425164336
0 TITAN 3C TRANSTAGE R/B
1 11940U 73040B   24187.39983007  .00000038  00000-0  00000+0 0  9990
2 11940   2.7907 263.6996 0029356  50.7781 310.0177  0.99563435 19537
0 SL-12 R/B(2)
1 11941U 78073F   24187.56507557 -.00000162  00000-0  00000-0 0  9993
2 11941   8.2302 294.4412 0017235 162.1650 185.6535  0.97571859156352
0 METEOR 2-6
1 11962U 80073A   24187.42531990  .00000211  00000-0  11049-3 0  9994
2 11962  81.2217  65.5156 0036017 357.6142   2.4851 14.10881457254353
0 SL-3 R/B
1 11963U 80073B   24187.42072989  .00000333  00000-0  17753-3 0  9996
2 11963  81.2771 148.0166 0074181 348.9729  10.9812 14.09952358253105
0 GOES 4
1 11964U 80074A   24186.89285328  .00000089  00000-0  00000-0 0  9993
2 11964   9.5376 308.5103 0032502  95.9133 265.7614  0.99226997120372
0 GOES 4 AKM
1 11970U 80074C   24187.51143734 -.00000229  00000-0  00000-0 0  9991
2 11970  18.0061 319.3215 1639445 249.0282 104.8637  0.81535437 32728
0 COSMOS 1176 FUEL CORE
1 11971U 80034D   24187.46193242 -.00000097  00000-0 -29619-5 0  9997
2 11971  64.8316 176.6614 0019496  34.9491 133.6028 13.96899119246190
0 DELTA 1 R/B(2)
1 11984U 67026C   24187.37454065  .00300024 -15154-5  27561-2 0  9994
2 11984  26.0612 273.6860 2866041 346.6381   7.1510  9.78587601515277
0 TRANSIT 11 DEB
1 11991U 66005H   24187.47778161  .00000676  00000-0  54077-3 0  9996
2 11991  90.1842 329.5011 0177709   3.0378  62.1619 13.83033220922946
0 DELTA 1 DEB
1 12000U 73086GL  24187.44615866 -.00000001  00000-0  35523-3 0  9992
2 12000 102.3077 168.8477 0020598 202.4269 313.8121 12.36336912459996
0 RADUGA 7
1 12003U 80081A   24187.49910703  .00000128  00000-0  00000-0 0  9999
2 12003   7.6696 296.0966 0009347 279.8604  86.2207  1.00217079116177
0 COSMOS 1217
1 12032U 80085A   24186.12976504  .00000039  00000-0  00000+0 0  9995
2 12032  69.9985 212.4877 5589062 266.1538  31.8232  2.01037984268013
0 OPS 6394 (FLTSATCOM 4)
1 12046U 80087A   24187.01430065 -.00000066  00000-0  00000+0 0  9999
2 12046   9.5191 309.6956 0004945 148.5769 211.5674  0.98951769123118
0 SBS 1
1 12065U 80091A   24187.32202310 -.00000176  00000-0  00000-0 0  9992
2 12065  11.2246 322.7685 0011762 163.9405 192.0450  0.99817339 39361
0 COSMOS 1223
1 12078U 80095A   24187.54304889  .00000019  00000-0  00000-0 0  9993
2 12078  72.1950  71.4249 4878457 327.6020 264.8339  2.00830956319342
0 SL-6 R/B(2)
1 12086U 80095E   24186.10765854  .00000909  00000-0  00000-0 0  9994
2 12086  64.8888 202.4440 6380640  40.0483 352.7926  1.99066154316930
0 COSMOS 1225
1 12087U 80097A   24187.54795285  .00000092  00000-0  81109-4 0  9993
2 12087  82.9467 282.0672 0055026 237.8177 132.4572 13.74641038185663
0 SL-8 R/B
1 12088U 80097B   24187.58370733  .00000053  00000-0  37615-4 0  9995
2 12088  82.9410 227.9062 0050070  58.9279 301.6778 13.77186229189449
0 INTELSAT 502
1 12089U 80098A   24186.91496480 -.00000009  00000-0  00000-0 0  9997
2 12089  12.2899 331.6317 0008771 290.7836  75.6846  0.98888692126682
0 COSMOS 1226
1 12091U 80099A   24187.49486238  .00000061  00000-0  48185-4 0  9992
2 12091  82.9408 170.9670 0032175 245.7524 233.6342 13.74619461184977
0 SL-8 R/B
1 12092U 80099B   24187.59162206  .00000071  00000-0  55640-4 0  9995
2 12092  82.9419 129.2640 0031477  94.8142  77.6610 13.77198393188457
0 OPS 4988 DEB
1 12099U 65016K   24187.55684142  .00000427  00000-0  30359-3 0  9992
2 12099  70.0770 333.6030 0017365 138.4661 292.4406 14.03962677 27105
0 OPS 4682 DEB
1 12102U 65027G   24184.72213861  .00000570  00000-0  19148-2 0  9992
2 12102  90.2406 358.4736 0027545  69.4516 303.6248 12.98260758798018
0 COSMOS 1228
1 12107U 80102A   24187.43343039 -.00000016  00000-0  35976-5 0  9996
2 12107  73.9946 171.4899 0045607 343.3202 172.4899 12.58631466    67
0 COSMOS 1229
1 12108U 80102B   24187.62984655  .00000012  00000-0  16867-3 0  9994
2 12108  73.9941 270.4710 0031252 109.9192   1.6411 12.56104047996054
0 COSMOS 1230
1 12109U 80102C   24187.48884336 -.00000005  00000-0  67105-4 0  9999
2 12109  73.9913 198.8209 0041132  25.9394  87.8857 12.57905798998931
0 COSMOS 1231
1 12110U 80102D   24187.55793742  .00000025  00000-0  24412-3 0  9993
2 12110  73.9918 230.0828 0036648  58.4180  56.3705 12.57118247997694
0 COSMOS 1232
1 12111U 80102E   24187.63182664  .00000011  00000-0  16598-3 0  9999
2 12111  73.9935 262.1927 0032319  92.5585  16.3756 12.56312432996422
0 COSMOS 1233
1 12112U 80102F   24187.54163148 -.00000007  00000-0  58147-4 0  9999
2 12112  73.9952 292.0028 0028847 121.7329 249.6055 12.55565739995205
0 COSMOS 1234
1 12113U 80102G   24187.59177455  .00000017  00000-0  19728-3 0  9992
2 12113  73.9927 247.1023 0034427  73.4129  44.7442 12.56693911996914
0 COSMOS 1235
1 12114U 80102H   24187.56671411  .00000010  00000-0  15995-3 0  9996
2 12114  73.9938 266.1006 0031838  98.5976   6.3449 12.56215441996234
0 SL-8 R/B
1 12115U 80102J   24187.34204094 -.00000002  00000-0  90902-4 0  9996
2 12115  73.9910  48.6343 0020147 298.4709 234.4796 12.52331549990156
0 EKRAN 6
1 12120U 80104A   24186.88866888  .00000052  00000-0  00000-0 0  9997
2 12120   7.9534 297.4168 0005117  90.7350 274.1632  1.00309302120276
0 COSMOS 1238
1 12138U 81003A   24187.57028076  .00005965  00000-0  41164-3 0  9998
2 12138  82.9500  60.4313 0674421  38.6028 326.1417 14.04821044169658
0 SL-8 R/B
1 12139U 81003B   24187.53291112  .00014277  00000-0  51779-3 0  9997
2 12139  82.9408 124.8100 0365341 105.7553 258.4268 14.83028245223057
0 COSMOS 1241
1 12149U 81006A   24187.13481341 -.00000062  00000-0  20213-4 0  9990
2 12149  65.8244  83.1366 0006890 161.0879 350.0569 13.72205070177101
0 SL-8 R/B
1 12150U 81006B   24187.39115642 -.00000084  00000-0 -28426-5 0  9998
2 12150  65.8194 163.7367 0049426  10.0906 350.1138 13.77325001183505
0 SL-8 DEB
1 12151U 81006C   24187.63319042 -.00000020  00000-0  64445-4 0  9995
2 12151  65.8243   1.6146 0004608 112.0586 316.3201 13.73967629179061
0 SL-3 R/B
1 12155U 81008B   24187.54709866  .00134427  00000-0  55141-3 0  9998
2 12155  81.1399 208.7764 0008848 115.8370 244.3809 15.85580328356418
0 DELTA 1 DEB
1 12164U 78026D   24187.62897786  .00002747  00000-0  89787-3 0  9994
2 12164  98.6688 205.0813 0063521  63.6955  53.9398 14.38202936404666
0 DELTA 1 DEB
1 12165U 78026E   24187.58011685  .00000217  00000-0  14503-3 0  9990
2 12165  99.0595 207.2670 0044451  54.4642  61.3947 14.10762286 19480
0 DELTA 1 DEB
1 12166U 78026F   24187.60420014  .00000643  00000-0  33453-3 0  9992
2 12166  98.9584 207.5655 0038880  83.6032  29.3387 14.17878276238949
0 DELTA 1 DEB
1 12167U 78026G   24187.59969832  .00001251  00000-0  59518-3 0  9993
2 12167  98.6700 138.9973 0163239  60.4275 112.6342 14.14315959231228
0 DELTA 1 DEB
1 12168U 78026H   24187.57296549  .00000413  00000-0  30809-3 0  9991
2 12168  98.7295  31.4232 0174305 330.8695  28.2829 13.93211627201637
0 DELTA 1 DEB
1 12169U 78026J   24186.99252873  .00001137  00000-0  42715-3 0  9992
2 12169  98.7408 195.7663 0069865  19.2646  34.4168 14.32189618258280
0 DELTA 1 DEB
1 12170U 78026K   24187.33584078  .00000649  00000-0  32209-3 0  9992
2 12170  98.9265 206.5454 0042244 277.4904  95.9332 14.20266056241850
0 DELTA 1 DEB
1 12171U 78026L   24187.57056373  .00000282  00000-0  20749-3 0  9990
2 12171  99.2346 182.8404 0036099 280.0498 191.6014 14.03718776222598
0 DELTA 1 DEB
1 12172U 78026M   24187.62579799  .00000567  00000-0  25719-3 0  9997
2 12172  98.8371 204.2830 0060182 153.8413 334.5886 14.24846823250592
0 DELTA 1 DEB
1 12174U 78026P   24187.59332572  .00000225  00000-0  15248-3 0  9998
2 12174  99.0927 205.8170 0042382 170.9502 302.3038 14.09933086231445
0 DELTA 1 DEB
1 12175U 78026Q   24187.60413300  .00000626  00000-0  47659-3 0  9996
2 12175  99.2979  66.7008 0062823 189.3148 232.5159 13.96664913207908
0 DELTA 1 DEB
1 12176U 78026R   24187.61678962  .00000121  00000-0  13320-3 0  9993
2 12176  99.0065  88.4866 0066081  67.5712 355.9218 13.88769200199496
0 DELTA 1 DEB
1 12177U 78026S   24187.32834270  .00000517  00000-0  38538-3 0  9995
2 12177  98.8994 305.5132 0153547 316.2630 106.9510 13.93825192200650
0 DELTA 1 DEB
1 12178U 78026T   24187.50901042  .00000310  00000-0  26521-3 0  9998
2 12178  99.4687  35.8640 0060808 286.0052 137.4276 13.94288489205895
0 DELTA 1 DEB
1 12179U 78026U   24187.54859084  .00001079  00000-0  60328-3 0  9997
2 12179  99.1254 111.1314 0167010 320.1650 217.1430 14.06182367213817
0 DELTA 1 DEB
1 12181U 78026W   24187.44585352  .00000277  00000-0  12820-3 0  9996
2 12181  98.8257 179.9462 0099204 182.2350 177.8399 14.25953460255169
0 DELTA 1 DEB
1 12183U 78026Y   24187.57169907  .00000510  00000-0  28639-3 0  9991
2 12183  99.0140 205.6405 0036870  23.8723 101.3650 14.14757728235799
0 DELTA 1 DEB
1 12185U 78026AA  24187.61629928  .00001044  00000-0  54119-3 0  9997
2 12185  99.1721 143.0703 0093933 143.4587  30.2277 14.14859241228603
0 DELTA 1 DEB
1 12189U 78026AE  24187.59729329  .00000142  00000-0  13661-3 0  9999
2 12189  98.7396 205.5369 0068403 151.1780 327.3530 13.93554247535626
0 DELTA 1 DEB
1 12190U 78026AF  24187.55401992  .00000084  00000-0  84196-4 0  9997
2 12190  98.9941 138.2591 0020533  49.8798  10.4611 14.01806137217051
0 DELTA 1 DEB
1 12193U 78026AJ  24187.57596722  .00002525  00000-0  18770-2 0  9993
2 12193  98.8857  47.7304 0252971 326.7037  31.8420 13.81857313152558
0 DELTA 1 DEB
1 12195U 78026AL  24187.43726318  .00000237  00000-0  20973-3 0  9993
2 12195  98.8487 148.9791 0060602 191.9040 290.3084 13.93415134204221
0 DELTA 1 DEB
1 12198U 78026AP  24187.44504728  .00001069  00000-0  68688-3 0  9995
2 12198  99.1766  88.9454 0119527  76.8202 284.6267 14.01937954211382
0 DELTA 1 DEB
1 12200U 78026AR  24187.52169791  .00000511  00000-0  19764-3 0  9997
2 12200  98.6534 157.5767 0112698  88.4102  48.4331 14.30840570262241
0 DELTA 1 DEB
1 12203U 78026AU  24187.62733419  .00001426  00000-0  48128-3 0  9997
2 12203  98.6657 196.0019 0063887 147.4480 330.8934 14.37354925261829
0 DELTA 1 DEB
1 12204U 78026AV  24187.60974672  .00000785  00000-0  31321-3 0  9998
2 12204  98.7776 195.1092 0081236 140.5017 220.2124 14.29514594255920
0 DELTA 1 DEB
1 12206U 78026AX  24187.29661943  .00001291  00000-0  79436-3 0  9991
2 12206  98.9598 300.9355 0165142 268.5435  89.6808 14.00860540201176
0 DELTA 1 DEB
1 12209U 78026BA  24187.61090046  .00001759  00000-0  60376-3 0  9992
2 12209  98.6718 203.8159 0057903 350.4956 125.4835 14.36451313245919
0 DELTA 1 DEB
1 12211U 78026BC  24187.52631756  .00000658  00000-0  39272-3 0  9992
2 12211  99.2190  75.6299 0117831 262.4469  96.3301 14.07569625219459
0 DELTA 1 DEB
1 12212U 78026BD  24187.40009523  .00000018  00000-0  41554-4 0  9998
2 12212  98.7787 238.2588 0027774  64.1967 308.4518 13.98126465212584
0 DELTA 1 DEB
1 12216U 78026BH  24187.56799731  .00000925  00000-0  58182-3 0  9997
2 12216  99.0306 301.8738 0194799 287.7332  70.2655 13.98002071194248
0 DELTA 1 DEB
1 12217U 78026BJ  24187.47246230  .00001274  00000-0  59461-3 0  9998
2 12217  98.9638 188.7507 0021895  35.3538 118.1965 14.22097481239144
0 DELTA 1 DEB
1 12218U 78026BK  24187.53530736  .00000414  00000-0  32364-3 0  9991
2 12218  99.4261  44.8545 0051507 310.7239 107.9941 13.97653974210198
0 DELTA 1 DEB
1 12222U 78026BP  24187.55437065  .00000233  00000-0  21317-3 0  9994
2 12222  99.0494 109.6265 0070322 271.3406  87.9698 13.91892900202296
0 DELTA 1 DEB
1 12223U 78026BQ  24187.55026804  .00000172  00000-0  13763-3 0  9998
2 12223  99.2275 200.2968 0039855 277.1379  82.5256 14.03841536223021
0 DELTA 1 DEB
1 12225U 78026BS  24187.41299247  .00000878  00000-0  54362-3 0  9991
2 12225  99.1372  95.9449 0038338 111.7657 314.5884 14.07594101220052
0 DELTA 1 DEB
1 12226U 78026BT  24187.44247802  .00040982  00000-0  10299-1 0  9994
2 12226  98.8507 253.7241 0099692 158.2544 202.2925 14.48091633187670
0 DELTA 1 DEB
1 12227U 78026BU  24187.23699610  .00004369  00000-0  49067-3 0  9996
2 12227  98.7412 294.2674 0081853 342.9685  16.8783 14.84954863293721
0 DELTA 1 DEB
1 12230U 78026BX  24187.46545727  .00007885  00000-0  10134-2 0  9992
2 12230  97.9531 165.0015 0053280 269.2325  90.2782 14.80432561274767
0 DELTA 1 DEB
1 12234U 78026CB  24187.45750694  .00000152  00000-0  12635-3 0  9995
2 12234  99.2296 180.1770 0027548 267.2597 256.3562 14.03425936222056
0 DELTA 1 DEB
1 12236U 78026CD  24187.62784078  .00001291  00000-0  95577-3 0  9990
2 12236  98.8394  62.8992 0218008 111.2224 317.3269 13.86237582180954
0 DELTA 1 DEB
1 12237U 78026CE  24187.21848304  .00006102  00000-0  39064-2 0  9993
2 12237  98.8297 294.5915 0270588 165.0061 195.9323 13.87281627146305
0 DELTA 1 DEB
1 12242U 78026CK  24187.42868544  .00000861  00000-0  61920-3 0  9993
2 12242  98.8646 140.3403 0068076  46.2902 314.3873 13.98408691209996
0 DELTA 1 DEB
1 12246U 78026CP  24187.55025874  .00000516  00000-0  35088-3 0  9995
2 12246  99.1647  60.8161 0055701 145.0154 288.7253 14.03886834217935
0 DELTA 1 DEB
1 12250U 78026CT  24187.51568983  .00001519  00000-0  62898-3 0  9992
2 12250  98.8506 201.2667 0023111 357.5324 155.8870 14.28001451246236
0 DELTA 1 DEB
1 12255U 78026CY  24187.58925576  .00000351  00000-0  25933-3 0  9991
2 12255  98.8685 135.1931 0018008 202.5509 157.4867 14.01751581587353
0 DELTA 1 DEB
1 12256U 78026CZ  24187.30764448  .00002865  00000-0  13966-2 0  9995
2 12256  99.1204 218.2198 0091114 167.9884 192.3491 14.16771792212114
0 DELTA 1 DEB
1 12257U 78026DA  24187.28231238  .00000395  00000-0  26684-3 0  9997
2 12257  99.2467 117.4425 0103234  82.4318 278.8560 14.03731158216399
0 DELTA 1 DEB
1 12262U 78026DF  24187.31633713  .00003475  00000-0  17709-2 0  9990
2 12262  98.9685 315.2569 0105149  73.6803 346.9853 14.13558993203560
0 DELTA 1 DEB
1 12263U 78026DG  24187.52806450  .00001938  00000-0  25409-2 0  9992
2 12263  98.8941  21.9410 0431927 324.6080  32.7069 13.29709380 74999
0 DELTA 1 DEB
1 12265U 78026DJ  24187.43966704  .00004275  00000-0  16397-2 0  9996
2 12265  98.8076 344.3310 0124938  18.5661  42.7456 14.26830249211245
0 DELTA 1 DEB
1 12266U 78026DK  24187.45105000  .00002225  00000-0  15480-2 0  9998
2 12266  98.7039 359.9521 0149541 214.6324 144.5030 13.94489312184526
0 DELTA 1 DEB
1 12269U 78026DN  24187.52225384  .00008348  00000-0  12382-2 0  9997
2 12269  98.0522 164.6520 0050392 282.9307 194.0340 14.74458437288402
0 DELTA 1 DEB
1 12270U 78026DP  24187.38063553  .00000099  00000-0  11275-3 0  9997
2 12270  99.0248 118.7242 0065650 298.9122 177.8718 13.90433495201379
0 DELTA 1 DEB
1 12274U 76077DF  24187.41159147 -.00000023  00000-0  19118-3 0  9996
2 12274 102.2784 155.0479 0105267 196.2738 319.6338 12.22238443936989
0 DELTA 1 DEB
1 12278U 78026DW  24187.60235791  .00004705  00000-0  15813-2 0  9994
2 12278  99.0879 319.1971 0043728 252.6203 119.9711 14.37127783240579
0 DELTA 1 DEB
1 12279U 78026DX  24182.31230348  .07997913  37479+0  17080-1 0  9996
2 12279  98.7420 199.7459 0016187 236.8557 123.1170 16.09374307259861
0 DELTA 1 DEB
1 12283U 78026EB  24187.50437904  .00000347  00000-0  15549-3 0  9994
2 12283  98.8269 185.4708 0092324 146.4920 345.1744 14.26542095225060
0 DELTA 1 DEB
1 12284U 78026EC  24187.49736660  .00001094  00000-0  71179-3 0  9995
2 12284  98.9358 270.5403 0091936 298.4008  74.1823 14.02567060204452
0 DELTA 1 DEB
1 12285U 78026ED  24187.43174599  .00000883  00000-0  51364-3 0  9996
2 12285  99.0492 180.7655 0051885 174.5654 185.6090 14.10640673 63251
0 DELTA 1 DEB
1 12288U 78026EG  24187.62557200  .00002247  00000-0  10624-2 0  9993
2 12288  99.1078 140.2750 0082423  25.8149 149.2023 14.19003351230041
0 DELTA 1 DEB
1 12290U 78026EJ  24187.38040749  .00000597  00000-0  33764-3 0  9991
2 12290  99.0749 166.8679 0082816 146.3847 214.2616 14.12311827213261
0 DELTA 1 DEB
1 12291U 78026EK  24187.44853153  .00002964  00000-0  11975-2 0  9999
2 12291  99.2377 324.9098 0045804 315.7620  84.5635 14.28133073231766
0 DELTA 1 DEB
1 12292U 78026EL  24187.23280240  .00001314  00000-0  86888-3 0  9992
2 12292  98.9006 295.1650 0051022  72.0560 315.6023 14.02669112190347
0 DELTA 1 DEB
1 12294U 78026EN  24187.46652906  .00000994  00000-0  29975-3 0  9998
2 12294  98.4893 158.6737 0092787 248.3403 110.7885 14.42308039271223
0 KIKU 3 (ETS 4)
1 12295U 81012A   24186.86498967  .00009385  00000-0  18249-2 0  9990
2 12295  28.3922 132.7732 4877909  66.8727 336.4493  5.80777195598713
0 COSMOS 1244
1 12297U 81013A   24187.59723562  .00000085  00000-0  72257-4 0  9995
2 12297  82.9514 252.2408 0030753  19.8641  90.2899 13.75138310821462
0 SL-8 R/B
1 12298U 81013B   24187.60194164  .00000070  00000-0  56086-4 0  9994
2 12298  82.9476 217.3001 0028467 243.4141 230.6550 13.76814390179336
0 COSMOS 1247
1 12303U 81016A   24187.02001708 -.00000612  00000-0  00000-0 0  9995
2 12303  67.8880  46.0298 6404720 359.2958   0.3085  2.02499964320759
0 ESIAFI 1 (COMSTAR 4)
1 12309U 81018A   24185.90075920 -.00000041  00000-0  00000-0 0  9991
2 12309  10.0806 316.1969 0003951 117.2026 242.9201  1.00275760160290
0 SL-6 R/B(2)
1 12311U 81016E   24186.39354120  .00000498  00000-0  00000-0 0  9993
2 12311  69.7925  65.0019 5744547 339.4350   4.7644  2.04668617324220
0 COSMOS 1249
1 12319U 81021A   24187.50514551 -.00000044  00000-0  38669-4 0  9991
2 12319  64.9620 195.7456 0042325 158.6389 201.6451 13.86698277196167
0 COSMOS 1250
1 12320U 81022A   24187.55284360  .00000023  00000-0  22992-3 0  9998
2 12320  74.0276 231.0304 0051701  62.9430  48.2172 12.58262291990399
0 COSMOS 1251
1 12321U 81022B   24187.58332122 -.00000014  00000-0  97917-5 0  9994
2 12321  74.0313 301.9437 0044116 154.0769 217.9816 12.56471097987532
0 COSMOS 1252
1 12322U 81022C   24187.60767485 -.00000001  00000-0  93983-4 0  9996
2 12322  74.0309   8.5077 0034953 227.7037 205.3649 12.54792509984884
0 COSMOS 1253
1 12323U 81022D   24187.55805223 -.00000018  00000-0 -15658-4 0  9996
2 12323  74.0311   0.4136 0017786  32.1915  37.3935 12.45824212970707
0 COSMOS 1254
1 12324U 81022E   24187.18257348  .00000002  00000-0  11184-3 0  9995
2 12324  74.0298  74.9777 0026527 307.9515 175.5942 12.53110341982178
0 COSMOS 1255
1 12325U 81022F   24187.31008642 -.00000025  00000-0 -60004-4 0  9995
2 12325  74.0289 139.7659 0016891  21.2331 133.0773 12.51473980979562
0 COSMOS 1256
1 12326U 81022G   24187.49935139  .00000007  00000-0  15356-3 0  9992
2 12326  74.0266 213.1365 0012286 150.2062 321.5852 12.49583097976698
0 COSMOS 1257
1 12327U 81022H   24187.59280946  .00000000  00000-0  10958-3 0  9999
2 12327  74.0301 281.1802 0007443 282.1884 187.1535 12.47840244973909
0 SL-8 R/B
1 12328U 81022J   24187.54226772 -.00000043  00000-0 -24508-3 0  9997
2 12328  74.0235 113.6635 0150420 308.9301 225.4869 12.23759582935894
0 KYOKKO 1 DEB
1 12329U 78014C   24186.84456777  .00000390  00000-0  52043-3 0  9995
2 12329  65.2698  78.3484 1882025  13.4360 351.0246 10.79934521810665
0 KYOKKO 1 DEB
1 12330U 78014D   24187.55253363  .00000316  00000-0  41023-3 0  9996
2 12330  65.3636 242.3850 1901155 182.6761 176.2646 10.78025438589841
0 KYOKKO 1 DEB
1 12331U 78014E   24187.26193184  .00000492  00000-0  59610-3 0  9995
2 12331  64.8154 144.5614 1803132 157.7925 211.2356 10.97431458  6401
0 COSMOS 839 DEB
1 12332U 76067AY  24187.57822490 -.00000062  00000-0 -31686-4 0  9994
2 12332  66.0579 116.8625 0719197  29.2366 138.0924 12.32342835  5103
0 COSMOS 839 DEB
1 12333U 76067AZ  24187.45562873 -.00000023  00000-0  91403-4 0  9997
2 12333  65.9290 213.2467 0735924 223.0436 252.7707 12.45197132486238
0 OPS 7350
1 12339U 81025A   24187.18024399 -.00000206  00000-0  00000-0 0  9991
2 12339   9.6200 310.1910 0017688 263.1771  93.3025  0.98828804 18793
0 COSMOS 1174 DEB
1 12343U 80030R   24186.93280355  .00029692  00000-0  37803-2 0  9991
2 12343  66.4088 126.0380 0153156 110.7498 251.0108 14.73482069238327
0 RADUGA 8
1 12351U 81027A   24187.11527726 -.00000055  00000-0  00000-0 0  9994
2 12351   8.0098 296.5434 0080806 250.2801 129.2165  1.00354327115404
0 COSMOS 1174 DEB
1 12354U 80030Y   24187.57030342  .00014121  00000-0  65149-3 0  9999
2 12354  66.1044 133.4557 0362172 334.5276  23.8363 14.77391699291213
0 ATLAS CENTAUR R/B
1 12363U 81018B   24186.91073232  .00000118  00000-0  32797-2 0  9991
2 12363  20.2041 221.8510 7154144 345.8720   1.7877  2.22043282351598
0 TITAN 3C TRANSTAGE R/B
1 12371U 81025C   24186.63666212  .00000000  00000-0  00000-0 0  9993
2 12371   8.2475 304.4404 0053892 307.0910  52.5566  1.01332686 19827
0 DELTA 1 DEB
1 12372U 78026EP  24187.32372372  .00002904  00000-0  77440-3 0  9999
2 12372  98.5121 207.7286 0038469 221.4774 150.8981 14.48777427600292
0 DELTA 1 DEB
1 12373U 78026EQ  24186.85894810 -.00000010  00000-0  22432-4 0  9992
2 12373  99.1225 144.8876 0015437  30.7853  25.2486 14.02636960192028
0 COSMOS 1261
1 12376U 81031A   24186.50013749  .00000565  00000-0  00000-0 0  9998
2 12376  68.3991 133.6629 6192626   8.5146 358.2024  2.00843878213160
0 SL-6 R/B(2)
1 12384U 81031D   24186.80437826 -.00000107  00000-0  00000-0 0  9999
2 12384  67.1463 121.8525 6382499  14.2889 123.0703  2.03530673321612
0 COSMOS 1263
1 12388U 81033A   24187.54762098  .00007237  00000-0  43365-3 0  9993
2 12388  82.8616  78.8707 0618509 101.9642 265.1531 14.19881467170026
0 SL-8 DEB
1 12404U 80022C   24187.52067756  .00008050  00000-0  24076-2 0  9997
2 12404  82.9149  87.7397 0012611 138.2826 221.9332 14.42774995263766
0 KYOKKO 1 DEB
1 12406U 78014F   24186.88216592  .00001835  00000-0  22983-2 0  9998
2 12406  65.8853  32.7998 1817505 136.1491 239.9075 10.91348173821812
0 COSMOS 1266
1 12409U 81037A   24187.28374595 -.00000044  00000-0  38766-4 0  9993
2 12409  64.7629  34.2172 0016006 145.1330 215.0783 13.90534341193698
0 DELTA 1 DEB
1 12427U 78026ET  24187.28388124  .00003956  00000-0  12936-2 0  9993
2 12427  99.1026 314.0557 0113512 247.0858 141.0226 14.35533522269384
0 COSMOS 1266 FUEL CORE
1 12435U 81037D   24187.54276972 -.00000065  00000-0  20865-4 0  9995
2 12435  64.7670 205.5939 0010166 329.9257  30.1221 13.93162689197094
0 COSMOS 1269
1 12442U 81041A   24187.51732409  .00000184  00000-0  77012-4 0  9994
2 12442  74.0523 224.2250 0011070 269.3127  90.6756 14.32679074254043
0 SL-8 R/B
1 12443U 81041B   24187.57996046  .00000391  00000-0  14544-3 0  9990
2 12443  74.0537 133.4836 0005233 304.5677  55.4981 14.35380368257114
0 ATLAS CENTAUR R/B
1 12445U 80098B   24187.35294183  .00005350  00000-0  97574-3 0  9996
2 12445  23.6055 169.0934 4144945  74.8300 326.4355  7.06678392 13420
0 TITAN 34B R/B
1 12446U 81038B   24187.20021136  .00014798  00000-0  15268-2 0  9997
2 12446  63.0503 241.7413 5690446 283.1001  22.1611  4.54426345 63062
0 SL-12 R/B(2)
1 12447U 80081F   24187.53519456 -.00000349  00000-0  00000-0 0  9992
2 12447   7.8890 297.0245 0003187  61.2795 241.0450  0.99967508157260
0 METEOR 2-7
1 12456U 81043A   24187.42228766  .00000383  00000-0  20561-3 0  9994
2 12456  81.2657  71.2180 0047297 351.1702   8.8632 14.10719193218684
0 SL-3 R/B
1 12457U 81043B   24187.38843847  .00000049  00000-0  20942-4 0  9996
2 12457  81.2743 151.7212 0066928 118.7450 242.0466 14.07465291214675
0 NOVA 1
1 12458U 81044A   24187.52503088  .00000112  00000-0  24325-3 0  9993
2 12458  89.8668  98.6849 0016010 107.8117  65.7927 13.23176651 82409
0 SL-3 R/B
1 12465U 81046B   24187.56706809  .00008065  00000-0  31578-3 0  9996
2 12465  81.2400 295.4600 0026432 329.4624  30.5069 15.25338434344594
0 SL-12 R/B(2)
1 12471U 80104E   24186.91705774 -.00000297  00000-0  00000-0 0  9998
2 12471   7.2226 294.2800 0034872 179.2785 225.1159  1.01345217112748
0 GOES 5
1 12472U 81049A   24187.58881465  .00000084  00000-0  00000-0 0  9997
2 12472  10.6367 320.5633 0001701 212.5723 185.5394  1.00304134115710
0 INTELSAT 501
1 12474U 81050A   24187.58418301 -.00000090  00000-0  00000-0 0  9994
2 12474  12.0359 329.3266 0004826 196.2378  70.0130  0.98850360130630
0 ATLAS CENTAUR R/B
1 12497U 81050B   24187.50814608  .00025588  00000-0  22930-2 0  9997
2 12497  23.9366  33.2149 3373029 104.3255 294.9025  8.56032293114996
0 COSMOS 1275
1 12504U 81053A   24187.60426164  .00000079  00000-0  67702-4 0  9992
2 12504  82.9599  70.8412 0039953   5.1936 354.9626 13.74438443161522
0 SL-8 R/B
1 12508U 81053B   24187.61587385  .00000114  00000-0  10012-3 0  9991
2 12508  82.9577  35.1523 0036845 201.0663 158.8978 13.76513292169516
0 DELTA 1 DEB
1 12527U 76077DG  24187.45774473 -.00000028  00000-0  12867-3 0  9995
2 12527 102.0477 153.8202 0037616 271.0875 208.3967 12.38017715 63878
0 DELTA 1 DEB
1 12528U 76077DH  24187.54521461 -.00000008  00000-0  32237-3 0  9994
2 12528 102.4687 159.8667 0078241 113.7238 355.6153 12.27175970 83883
0 DELTA 1 DEB
1 12529U 76077DJ  24187.41859523 -.00009478  00000-0 -12086+0 0  9991
2 12529 103.5763  11.0113 0901041  55.5104 312.7701 11.22902915751970
0 DELTA 1 DEB
1 12530U 76077DK  24187.49570821 -.00000006  00000-0  33505-3 0  9992
2 12530 102.4745 162.9721 0126713 138.8790 336.6809 12.27028067995799
0 DELTA 1 DEB
1 12531U 76077DL  24186.47166358  .00000013  00000-0  51667-3 0  9992
2 12531 101.7269  14.6189 0134794 317.0684  70.0651 12.18442173960755
0 DELTA 1 DEB
1 12532U 76077DM  24187.42625831  .00001542  00000-0  66104-2 0  9994
2 12532 102.1350 125.9502 0232923 257.7269 223.8879 12.76038754289933
0 DELTA 1 DEB
1 12533U 76077DN  24187.43389850  .00000585  00000-0  42647-2 0  9996
2 12533 101.6851 159.7716 0075553 183.8925 345.8753 12.46852559 67550
0 DELTA 1 DEB
1 12534U 76077DP  24187.53051544 -.00000277  00000-0 -18026-2 0  9998
2 12534 102.0208 257.4720 0050088 311.9142 153.5788 12.36929219 81256
0 DELTA 1 DEB
1 12535U 76077DQ  24187.50670098  .00000007  00000-0  69747-3 0  9993
2 12535 102.2662 207.2252 0399373 241.8783 282.9133 11.66296133980210
0 DELTA 1 DEB
1 12536U 76077DR  24187.42791367  .00001057  00000-0  12617-1 0  9996
2 12536 101.8896   1.8274 0510067 326.2418  86.4893 11.77476371969982
0 DELTA 1 DEB
1 12537U 76077DS  24187.48579779  .00000081  00000-0  12664-2 0  9993
2 12537 102.2094 171.9177 0163710  74.7333  50.1375 12.11505793950645
0 DELTA 1 DEB
1 12538U 76077DT  24187.21300704 -.00000081  00000-0 -40275-3 0  9997
2 12538 102.7825 283.7954 0197656  20.4799   7.5163 12.05695688946617
0 DELTA 1 DEB
1 12539U 76077DU  24186.95379102  .00002143  00000-0  76628-2 0  9995
2 12539 101.6633  68.6013 0362974 283.7224 209.8956 12.76798113 38842
0 DELTA 1 DEB
1 12540U 76077DV  24187.18859458  .00000078  00000-0  85767-3 0  9990
2 12540 102.4295 273.9214 0044878 221.2504 168.2097 12.47158139 11985
0 DELTA 1 DEB
1 12542U 76077DX  24187.41573487  .00000073  00000-0  75339-3 0  9992
2 12542 101.8552 159.7857 0058966 203.9352 325.0886 12.52252940988984
0 COSMOS 839 DEB
1 12543U 76067BA  24187.33119054  .00000680  00000-0  25735-2 0  9997
2 12543  66.0291 149.4944 0635123  15.9278 133.7678 12.43576820169322
0 METEOSAT 2
1 12544U 81057A   24187.45646843  .00000018  00000-0  00000-0 0  9998
2 12544  11.4799 324.0837 0026183   3.9673   9.8837  0.98722804116827
0 APPLE
1 12545U 81057B   24186.92084037 -.00000170  00000-0  00000-0 0  9991
2 12545   8.6684 302.9134 0029599 203.6063 198.0831  1.00024134115267
0 CAT 3
1 12546U 81057C   24187.00631255  .00000845  00000-0  41556-3 0  9994
2 12546  10.1489 142.4265 5665469 234.0651  59.2578  4.47703970383066
0 COSMOS 1249 FUEL CORE
1 12551U 81021C   24187.55279172 -.00000063  00000-0  22244-4 0  9994
2 12551  64.9665 278.5603 0026886  67.6460 292.7448 13.90522382202524
0 NOAA 7
1 12553U 81059A   24187.40305907  .00000108  00000-0  75154-4 0  9994
2 12553  98.8927 246.7431 0012197 139.0230 221.1863 14.17539587223893
0 NOAA 7 DEB
1 12559U 81059B   24187.46764189  .00004283  00000-0  96456-3 0  9992
2 12559  98.9470 257.5728 0002969  39.5165  30.2316 14.56959371253704
0 NOAA 7 DEB
1 12560U 81059C   24187.60175890  .00004255  00000-0  97306-3 0  9999
2 12560  98.9545 249.9093 0001370  22.2050 128.1497 14.56258450253556
0 EKRAN 7
1 12564U 81061A   24186.84612662 -.00000097  00000-0  00000+0 0  9996
2 12564   8.2090 299.5374 0003658  91.1226 274.9656  1.00214769122364
0 DELTA 1 DEB
1 12580U 76077DY  24185.98657006  .00000048  00000-0  15248-2 0  9998
2 12580 102.4072   0.0965 0619108 155.1855 359.8963 11.28251515904534
0 DELTA 1 DEB
1 12581U 76077DZ  24187.29615899 -.00000028  00000-0  15905-3 0  9999
2 12581 102.4824 124.8406 0380650 208.1563 311.7667 11.70206886982135
0 METEOR PRIRODA
1 12585U 81065A   24187.55870172  .00017543  00000-0  43581-3 0  9992
2 12585  97.5434 217.2964 0009547  19.5902 340.5708 15.40343999348747
0 SL-3 R/B
1 12586U 81065B   24187.55129136  .00006698  00000-0  30853-3 0  9997
2 12586  97.6916 201.7286 0015035 359.9298   0.1932 15.20539846345681
0 RADUGA 9
1 12618U 81069A   24186.98110146  .00000155  00000-0  00000-0 0  9994
2 12618   8.2662 299.9841 0004313 172.6851 200.5239  1.00247728 40205
0 DYNAMICS EXPLORER 1
1 12624U 81070A   24187.42426856  .00000114  00000-0  43167-3 0  9990
2 12624  90.7499  41.4317 6199032  80.3938 340.4962  3.52720430700041
0 COSMOS 1285
1 12627U 81071A   24187.47381097 -.00000567  00000-0  00000-0 0  9995
2 12627  68.1422 137.6301 6330350   9.4879 124.6234  1.98056324232402
0 FLTSATCOM 5
1 12635U 81073A   24187.47063392 -.00000043  00000-0  00000-0 0  9990
2 12635  15.3422 315.3341 0013191 158.7243 194.0574  0.98605297126040
0 COSMOS 1287
1 12636U 81074A   24187.36454226  .00000008  00000-0  17008-3 0  9999
2 12636  74.0339  59.5447 0030662 348.2847  11.7484 12.44338288949878
0 COSMOS 1288
1 12637U 81074B   24187.63139566 -.00000021  00000-0 -33671-4 0  9999
2 12637  74.0351 328.0423 0018027 257.3385 114.7228 12.46695874952962
0 COSMOS 1289
1 12638U 81074C   24187.57518696 -.00000001  00000-0  92772-4 0  9992
2 12638  74.0343  17.3765 0024614  87.5307 338.8252 12.54706240965528
0 COSMOS 1290
1 12639U 81074D   24187.47085273 -.00000003  00000-0  80122-4 0  9990
2 12639  74.0336  90.9737 0014967 176.7824 356.8009 12.52816609962573
0 COSMOS 1291
1 12640U 81074E   24187.41212752 -.00000017  00000-0 -97985-5 0  9992
2 12640  74.0315 167.0617 0005064 251.4192 262.4208 12.50869638959490
0 COSMOS 1292
1 12641U 81074F   24187.62747927  .00000013  00000-0  19276-3 0  9992
2 12641  74.0321 249.7282 0007762 134.3383 341.0636 12.48723741956275
0 COSMOS 1293
1 12642U 81074G   24187.57136744 -.00000011  00000-0  33662-4 0  9991
2 12642  74.0349 299.1382 0036049   2.2073   8.8645 12.56700409968912
0 COSMOS 1294
1 12643U 81074H   24187.59566677  .00000017  00000-0  19369-3 0  9998
2 12643  74.0302 217.5895 0046883 262.8812 218.5144 12.58752684971874
0 SL-8 R/B
1 12644U 81074J   24187.63231374 -.00000053  00000-0 -34343-3 0  9998
2 12644  74.0329  38.6428 0130513  67.2498 349.2804 12.25999169920525
0 INTERCOSMOS 22
1 12645U 81075A   24187.49321322  .00000200  00000-0  88072-4 0  9998
2 12645  81.2162 192.1933 0064335  91.1661 269.6886 14.18678528219123
0 SL-3 R/B
1 12646U 81075B   24187.56628951  .00000147  00000-0  66592-4 0  9998
2 12646  81.2256 255.2100 0067172 193.5242 275.7062 14.16160167216279
0 DELTA 1 DEB
1 12647U 76077EA  24186.55550708  .00000443  00000-0  56596-2 0  9997
2 12647 100.6797  37.9033 0386664  53.7453 336.1822 11.85944587  3861
0 COSMOS 1275 DEB
1 12648U 81053C   24187.60946899  .00000387  00000-0  35095-3 0  9994
2 12648  82.9696  17.9415 0015093  25.3378  39.1562 13.81102670159422
0 COSMOS 1275 DEB
1 12649U 81053D   24187.58242477  .00000952  00000-0  89401-3 0  9991
2 12649  82.9169   8.2710 0046397 356.2608  69.4209 13.80116198153081
0 COSMOS 1275 DEB
1 12650U 81053E   24187.37402025  .00000544  00000-0  50255-3 0  9999
2 12650  82.9350  44.3571 0064946  29.6418 143.5561 13.79865903153023
0 COSMOS 1275 DEB
1 12652U 81053G   24187.27260920  .00002040  00000-0  13782-2 0  9992
2 12652  82.9389 188.2639 0047509 249.4960 122.4756 13.99417380 96167
0 COSMOS 1275 DEB
1 12653U 81053H   24187.49082826  .00000796  00000-0  66168-3 0  9997
2 12653  82.9349 272.2561 0032350 165.2700 205.7176 13.87261009163626
0 COSMOS 1275 DEB
1 12654U 81053J   24187.60771964  .00001379  00000-0  81650-3 0  9990
2 12654  82.9823  54.1088 0035742 190.0432 231.1687 14.06705669187961
0 COSMOS 1275 DEB
1 12655U 81053K   24187.56697310  .00000167  00000-0  15495-3 0  9996
2 12655  82.9585  39.2706 0031851 259.6323 160.7745 13.76595241155489
0 COSMOS 1275 DEB
1 12656U 81053L   24187.56550130  .00000695  00000-0  53933-3 0  9990
2 12656  82.9601 233.5521 0023016 327.8782 157.9895 13.91176821169591
0 COSMOS 1275 DEB
1 12658U 81053N   24187.56640716  .00004685  00000-0  21190-2 0  9994
2 12658  82.9732 354.4082 0038889  80.1528 351.4260 14.21457594188786
0 COSMOS 1275 DEB
1 12659U 81053P   24187.22226839  .00001859  00000-0  15356-2 0  9991
2 12659  82.7428  57.2149 0070224  75.1522  63.9398 13.87365012155758
0 COSMOS 1275 DEB
1 12660U 81053Q   24187.29400238  .00000842  00000-0  97531-3 0  9994
2 12660  82.8526 266.4618 0134948 305.6313 115.6001 13.64247827124905
0 COSMOS 1275 DEB
1 12661U 81053R   24187.46804589  .00001171  00000-0  12397-2 0  9993
2 12661  82.7995  80.3013 0123528  19.2257 156.6541 13.70414041132447
0 COSMOS 1275 DEB
1 12662U 81053S   24187.61755374  .00000230  00000-0  21481-3 0  9998
2 12662  82.9563  30.2005 0021235 210.9321 210.1815 13.77818004156732
0 COSMOS 1275 DEB
1 12663U 81053T   24187.34806509  .00000913  00000-0  76913-3 0  9994
2 12663  82.9541 338.2047 0051535  33.1986   3.6683 13.86259598160510
0 COSMOS 1275 DEB
1 12664U 81053U   24187.50044199  .00000710  00000-0  73109-3 0  9991
2 12664  82.8915  81.3273 0080387  97.5277  77.7577 13.73370887144478
0 COSMOS 1275 DEB
1 12665U 81053V   24187.49297649  .00000433  00000-0  38136-3 0  9993
2 12665  82.9679 350.2375 0035108   2.0489  52.4895 13.82924334160928
0 COSMOS 1275 DEB
1 12666U 81053W   24187.61828421  .00000528  00000-0  54032-3 0  9994
2 12666  82.8720  32.2992 0070711  71.8243 351.5230 13.73552981145360
0 COSMOS 1275 DEB
1 12667U 81053X   24187.50690804  .00000767  00000-0  69456-3 0  9996
2 12667  82.8375 200.1673 0032423 275.3253 239.0865 13.82292799156150
0 COSMOS 1275 DEB
1 12668U 81053Y   24187.61270755  .00000803  00000-0  50874-3 0  9993
2 12668  83.1046 263.6188 0055619 137.1328 345.0574 14.02042575186511
0 COSMOS 1275 DEB
1 12669U 81053Z   24187.52197966  .00002980  00000-0  19681-2 0  9994
2 12669  83.0013 359.7003 0076881  78.6402 336.6351 13.99898755164940
0 COSMOS 1275 DEB
1 12670U 81053AA  24187.57631661  .00000566  00000-0  52449-3 0  9994
2 12670  82.9415  16.9420 0054577 269.9745 154.4056 13.80094444155574
0 COSMOS 1275 DEB
1 12671U 81053AB  24187.58133632  .00002342  00000-0  13796-2 0  9996
2 12671  82.9089  31.0909 0021314 211.6790 148.3103 14.07450229179566
0 COSMOS 1275 DEB
1 12672U 81053AC  24187.54742170  .00000879  00000-0  78920-3 0  9990
2 12672  82.9442 345.0901 0029418 114.3602 322.0308 13.82926440160006
0 COSMOS 1275 DEB
1 12673U 81053AD  24187.55554845  .00003691  00000-0  21863-2 0  9990
2 12673  82.8514 348.1817 0044954 151.5797 280.6320 14.06890710174865
0 COSMOS 1275 DEB
1 12674U 81053AE  24187.48078895  .00000728  00000-0  73540-3 0  9997
2 12674  82.9363 173.7347 0102690 165.3147 324.6042 13.73641021142051
0 COSMOS 1275 DEB
1 12675U 81053AF  24187.45389690  .00000838  00000-0  78611-3 0  9999
2 12675  82.9359  74.8605 0065664 126.5499  47.9912 13.79483075150355
0 COSMOS 1275 DEB
1 12676U 81053AG  24187.40079436  .00000656  00000-0  55745-3 0  9990
2 12676  82.9451 297.9042 0043223 324.8636  99.2839 13.85618578162104
0 HIMAWARI 2 (GMS 2)
1 12677U 81076A   24187.04678390 -.00000077  00000-0  00000-0 0  9999
2 12677   9.5098 309.5477 0007782 295.4189  62.4098  0.99556485125135
0 DELTA 1 R/B(2)
1 12679U 81070E   24187.57116889  .00000155  00000-0  63377-3 0  9998
2 12679  90.7648  42.4807 6191865  92.3845 335.0342  3.52728868550136
0 SL-6 R/B(2)
1 12680U 81071D   24186.66922423 -.00001002  00000-0  00000-0 0  9993
2 12680  65.7359 120.7001 6816805  25.7958 356.1167  1.99242835230552
0 COSMOS 1295
1 12681U 81077A   24187.57904684  .00000076  00000-0  60871-4 0  9995
2 12681  82.9188 291.0772 0045367 103.2421 268.2002 13.76533866154347
0 SL-8 R/B
1 12682U 81077B   24187.57090370  .00000101  00000-0  84359-4 0  9990
2 12682  82.9156 249.6082 0032962 321.8009  38.0813 13.78763913157451
0 COSMOS 1275 DEB
1 12690U 81053AJ  24187.55599661  .00001985  00000-0  17356-2 0  9990
2 12690  82.9534 150.1671 0093283 334.8569  91.2385 13.83312691145617
0 COSMOS 1275 DEB
1 12692U 81053AL  24187.56087742  .00002196  00000-0  83343-3 0  9990
2 12692  82.8977 257.0150 0071178  30.1437 330.3815 14.29316391216174
0 COSMOS 1275 DEB
1 12693U 81053AM  24187.58120976  .00000859  00000-0  40953-3 0  9994
2 12693  83.1478 128.5093 0050033  40.2617 135.1015 14.17584172887080
0 COSMOS 1275 DEB
1 12694U 81053AN  24187.58668815  .00000318  00000-0  37876-3 0  9994
2 12694  83.0807 245.4543 0115935  33.6551  85.9726 13.61454254126106
0 COSMOS 1275 DEB
1 12695U 81053AP  24187.16833031  .00001179  00000-0  12324-2 0  9999
2 12695  83.0078  63.1275 0105530 217.6591 307.6684 13.72045891131324
0 COSMOS 1275 DEB
1 12696U 81053AQ  24187.37916434  .00000560  00000-0  77246-3 0  9990
2 12696  83.0711  46.0889 0150382 336.4379 200.4345 13.52339184111410
0 COSMOS 1275 DEB
1 12697U 81053AR  24187.53900420  .00001123  00000-0  10378-2 0  9995
2 12697  82.7778 203.6748 0084578  15.0316 103.0746 13.80103553148557
0 COSMOS 1275 DEB
1 12698U 81053AS  24187.32632874  .00003967  00000-0  16913-2 0  9997
2 12698  82.9059 272.8178 0010319  40.9633 319.2324 14.24890836189686
0 COSMOS 1275 DEB
1 12699U 81053AT  24187.31039734  .00001371  00000-0  12326-2 0  9994
2 12699  82.9484 140.2912 0083214 279.5131 234.5110 13.81905687146565
0 COSMOS 1275 DEB
1 12700U 81053AU  24187.42122001  .00001756  00000-0  10181-2 0  9993
2 12700  82.7810  79.8958 0048177  68.1762 292.4526 14.07738415186893
0 COSMOS 1275 DEB
1 12701U 81053AV  24187.52124427  .00000951  00000-0  74361-3 0  9996
2 12701  82.8492 103.9697 0037543 249.9156 285.9770 13.90898474165316
0 COSMOS 1275 DEB
1 12703U 81053AX  24187.35263532  .00001648  00000-0  95335-3 0  9998
2 12703  82.9681  34.3711 0016777 295.6073  64.3368 14.08350438186773
0 COSMOS 1275 DEB
1 12704U 81053AY  24187.30776634  .00000576  00000-0  61990-3 0  9995
2 12704  82.9899 289.9364 0085655 156.5037 258.9599 13.70214932139695
0 COSMOS 1275 DEB
1 12705U 81053AZ  24187.58095809  .00001907  00000-0  12445-2 0  9993
2 12705  82.8885  63.0734 0028519 121.2181 275.7703 14.01641028174202
0 COSMOS 1275 DEB
1 12706U 81053BA  24187.59081172  .00002510  00000-0  23640-2 0  9993
2 12706  82.8828 116.6507 0103897 234.5303 302.1187 13.78637627140926
0 COSMOS 1275 DEB
1 12707U 81053BB  24187.49042192  .00000488  00000-0  61337-3 0  9990
2 12707  83.0114 178.9121 0128881 267.7935 214.3564 13.58924187122235
0 COSMOS 1275 DEB
1 12708U 81053BC  24187.56225775  .00009920  00000-0  26984-2 0  9997
2 12708  82.8706 296.3811 0026445 296.9846  62.8649 14.47206328209964
0 COSMOS 1275 DEB
1 12709U 81053BD  24187.48626882  .00000702  00000-0  84044-3 0  9994
2 12709  82.9713  76.1684 0123747 149.9405  23.8833 13.62446188125940
0 COSMOS 1275 DEB
1 12710U 81053BE  24187.35151404  .00000841  00000-0  87993-3 0  9995
2 12710  83.0095  62.5919 0115888 167.5899 192.8154 13.71155086132155
0 COSMOS 1275 DEB
1 12711U 81053BF  24187.49716509  .00000641  00000-0  65710-3 0  9995
2 12711  82.9630 184.6461 0062391 326.3808 156.6999 13.74105757145479
0 COSMOS 1275 DEB
1 12712U 81053BG  24187.34798022  .00001889  00000-0  15840-2 0  9993
2 12712  82.9856 132.7739 0071170 330.7093 197.1147 13.86524011152689
0 COSMOS 1275 DEB
1 12713U 81053BH  24187.40459782  .00003449  00000-0  14858-2 0  9990
2 12713  82.9485 247.1715 0021168 151.8199 208.4135 14.24218642189332
0 COSMOS 1275 DEB
1 12714U 81053BJ  24187.54910982  .00001013  00000-0  12935-2 0  9999
2 12714  82.9747 128.6203 0126621 329.1505  30.2243 13.58943811120201
0 COSMOS 1275 DEB
1 12715U 81053BK  24187.58260175  .00002065  00000-0  79927-3 0  9999
2 12715  83.1128 303.3844 0064747 258.7485 113.0538 14.28543286213621
0 COSMOS 1275 DEB
1 12719U 81053BL  24187.62918175  .00000648  00000-0  48806-3 0  9995
2 12719  82.9596 223.1245 0019436 242.3692 241.3254 13.92782023170445
0 COSMOS 1275 DEB
1 12720U 81053BM  24187.55188926  .00001380  00000-0  11474-2 0  9996
2 12720  83.2501 222.4708 0114725  53.4300  59.1421 13.84936404 11021
0 COSMOS 1275 DEB
1 12722U 81053BP  24187.47937869  .00001044  00000-0  85431-3 0  9999
2 12722  82.9009 255.5132 0067662  87.3647 273.5259 13.87597652160080
0 COSMOS 1275 DEB
1 12723U 81053BQ  24187.14764233  .00011636  00000-0  31032-2 0  9992
2 12723  82.9422  88.3418 0006871 337.9136  22.1763 14.48348460207529
0 COSMOS 1275 DEB
1 12724U 81053BR  24187.50581277  .00001820  00000-0  11222-2 0  9991
2 12724  82.9386  93.2117 0018835 168.6331   7.2242 14.04877079177919
0 COSMOS 1275 DEB
1 12725U 81053BS  24187.59415767  .00000678  00000-0  59293-3 0  9992
2 12725  83.1391 135.0861 0090986 233.8783 303.2894 13.82552268143115
0 COSMOS 1275 DEB
1 12726U 81053BT  24187.39915756  .00002094  00000-0  13664-2 0  9999
2 12726  82.9493 153.7417 0045508  43.0712 111.8288 14.01385634175144
0 COSMOS 1275 DEB
1 12727U 81053BU  24187.45874704  .00002480  00000-0  19021-2 0  9996
2 12727  83.2854 172.4198 0090995   8.1522 104.4014 13.90954073159205
0 COSMOS 1275 DEB
1 12728U 81053BV  24187.62766944  .00000572  00000-0  55767-3 0  9990
2 12728  82.8076 259.7068 0056793  35.5257  77.4458 13.76979092140325
0 COSMOS 1275 DEB
1 12729U 81053BW  24187.60743691  .00000624  00000-0  78599-3 0  9999
2 12729  83.0447 245.3754 0127159 272.4528 215.4138 13.59301008982928
0 COSMOS 1275 DEB
1 12730U 81053BX  24187.57637056  .00004363  00000-0  18026-2 0  9996
2 12730  82.9395 232.9276 0019798 115.9770  11.8365 14.26442827195230
0 COSMOS 1275 DEB
1 12731U 81053BY  24187.58633694  .00000530  00000-0  49517-3 0  9994
2 12731  82.9365  39.0056 0084294  35.1791  28.3841 13.78536583153009
0 COSMOS 1275 DEB
1 12732U 81053BZ  24187.59859497  .00000459  00000-0  35226-3 0  9999
2 12732  82.9871 242.0334 0050906 341.7931 149.8433 13.90674011172204
0 COSMOS 1275 DEB
1 12733U 81053CA  24187.56106081  .00006573  00000-0  26153-2 0  9992
2 12733  82.8634 135.1968 0018969 291.5990  68.3174 14.28446872194425
0 COSMOS 1275 DEB
1 12735U 81053CC  24187.62023803  .00000687  00000-0  74397-3 0  9995
2 12735  83.1411 212.7755 0099062 181.5838 304.5276 13.69653456136855
0 COSMOS 1275 DEB
1 12736U 81053CD  24187.58868848  .00000550  00000-0  71425-3 0  9995
2 12736  83.0296 247.5374 0130335  36.8969  86.3404 13.56872525118882
0 COSMOS 1275 DEB
1 12737U 81053CE  24187.44487080  .00001027  00000-0  10489-2 0  9998
2 12737  82.9833  79.7360 0150486 292.7783 245.8556 13.71005921129128
0 COSMOS 1275 DEB
1 12739U 81053CG  24187.28792425  .00005863  00000-0  20945-2 0  9994
2 12739  82.9373 142.4857 0008052 178.0724 182.0497 14.33978536203309
0 COSMOS 1275 DEB
1 12740U 81053CH  24187.44524910  .00004671  00000-0  18184-2 0  9994
2 12740  82.8403  74.0897 0015854 157.5297  18.3706 14.29548684195130
0 COSMOS 1275 DEB
1 12741U 81053CJ  24187.43698740  .00000877  00000-0  70609-3 0  9992
2 12741  82.9498 311.0955 0062844 303.2793 124.0437 13.88550912161991
0 COSMOS 1275 DEB
1 12742U 81053CK  24187.45756465  .00000155  00000-0  14840-3 0  9998
2 12742  82.9477  79.7001 0048701 113.6988  61.8931 13.73645886151113
0 COSMOS 1275 DEB
1 12743U 81053CL  24187.60281713  .00000683  00000-0  64282-3 0  9996
2 12743  82.9225  25.1944 0064307  19.2705  40.4363 13.79192701153139
0 COSMOS 1275 DEB
1 12744U 81053CM  24187.59941302  .00005434  00000-0  24010-2 0  9995
2 12744  82.9330 317.6678 0024159 125.4167 234.9277 14.22952597188535
0 COSMOS 1275 DEB
1 12745U 81053CN  24187.39397521  .00000828  00000-0  65728-3 0  9996
2 12745  83.1373 296.5808 0047065 177.2177 251.3271 13.89635748160134
0 COSMOS 1275 DEB
1 12746U 81053CP  24187.58333028  .00004982  00000-0  22658-2 0  9999
2 12746  82.9412   8.1113 0040164 268.7125  90.9455 14.21162555185589
0 COSMOS 1275 DEB
1 12747U 81053CQ  24187.62273898  .00000865  00000-0  10487-2 0  9996
2 12747  83.0658 269.3298 0129426 210.1397 273.7152 13.61740899122111
0 COSMOS 1275 DEB
1 12748U 81053CR  24187.49192562  .00000353  00000-0  35536-3 0  9995
2 12748  82.9874 178.5248 0045881 138.3816 348.2324 13.74312607148590
0 COSMOS 1275 DEB
1 12749U 81053CS  24187.24155470  .00000438  00000-0  43430-3 0  9992
2 12749  82.8099 253.3620 0062020   5.4077  54.8714 13.75426485148125
0 COSMOS 1275 DEB
1 12751U 81053CU  24187.49256243  .00000490  00000-0  45040-3 0  9999
2 12751  82.9439 349.5781 0029377 142.3037 273.0434 13.80684814157850
0 COSMOS 1275 DEB
1 12752U 81053CV  24187.46722756  .00001132  00000-0  12973-2 0  9996
2 12752  83.0216 181.6862 0123927 185.7691 297.8286 13.65625841123551
0 COSMOS 1275 DEB
1 12753U 81053CW  24187.38734220  .00001085  00000-0  10640-2 0  9993
2 12753  82.8052 301.4221 0094421 217.8063 205.1717 13.76223144143098
0 COSMOS 1275 DEB
1 12755U 81053CY  24187.44313915  .00456566  00000-0  10818-1 0  9990
2 12755  82.8911 190.9067 0022838 169.8009 190.3706 15.39746406226044
0 COSMOS 1275 DEB
1 12756U 81053CZ  24187.17025461  .00014786  00000-0  23488-2 0  9999
2 12756  82.9786 223.9397 0010767 280.1799 153.1271 14.71983712229236
0 COSMOS 1275 DEB
1 12757U 81053DA  24187.58239389  .00000645  00000-0  57861-3 0  9993
2 12757  82.9488  28.7201 0057402 241.7536 172.7348 13.82091216155061
0 COSMOS 1275 DEB
1 12758U 81053DB  24187.27859126  .00000646  00000-0  59045-3 0  9994
2 12758  82.8620 265.6343 0057410  48.2886  12.6651 13.80966340153351
0 COSMOS 1275 DEB
1 12759U 81053DC  24187.22062199  .00001217  00000-0  76999-3 0  9998
2 12759  82.8609 254.4814 0047829 171.5363 243.8523 14.02724971182345
0 COSMOS 1275 DEB
1 12766U 81053DK  24187.35967034  .00000376  00000-0  40119-3 0  9992
2 12766  82.9475 280.9148 0102687  90.7651 337.8170 13.69058635134398
0 COSMOS 1275 DEB
1 12767U 81053DL  24187.38815833  .00001480  00000-0  83377-3 0  9995
2 12767  82.9591 315.2736 0050962  69.1212 354.3345 14.09105629191059
0 COSMOS 1275 DEB
1 12768U 81053DM  24187.51725355  .00000672  00000-0  56405-3 0  9994
2 12768  82.9310 279.3798 0048468 337.2426  32.9759 13.86191629160942
0 COSMOS 1275 DEB
1 12769U 81053DN  24187.44650794  .00000675  00000-0  70050-3 0  9996
2 12769  82.8218 318.9253 0072858 184.2056 242.6563 13.73095342144287
0 COSMOS 1275 DEB
1 12771U 81053DQ  24187.28622259  .00001057  00000-0  11609-2 0  9995
2 12771  82.8688 293.9153 0152674 310.1036 108.3881 13.66599719122720
0 COSMOS 1275 DEB
1 12772U 81053DR  24186.78657057  .00003163  00000-0  16692-2 0  9991
2 12772  82.9265  48.0967 0041970 221.4237 138.3757 14.13176254177912
0 COSMOS 1275 DEB
1 12773U 81053DS  24187.44318408  .00016638  00000-0  51987-2 0  9997
2 12773  82.9484 189.2408 0139215 320.0331  39.0673 14.35227977173479
0 COSMOS 1275 DEB
1 12775U 81053DU  24187.07558385  .00001330  00000-0  16112-2 0  9992
2 12775  83.3335  28.7359 0149328 193.1208 296.0784 13.60998782115156
0 COSMOS 1275 DEB
1 12780U 81053DW  24187.60469616  .00000826  00000-0  65737-3 0  9992
2 12780  82.9465 255.5900 0022010  27.5806  86.2314 13.89921089166202
0 COSMOS 1275 DEB
1 12781U 81053DX  24187.52533765  .00002252  00000-0  20257-2 0  9993
2 12781  83.1707  99.3580 0069308 242.3413 237.4324 13.82580119150476
0 COSMOS 1275 DEB
1 12782U 81053DY  24187.28750361  .00000556  00000-0  57141-3 0  9998
2 12782  82.9991 269.5279 0076629  53.1749  13.4360 13.73182218135551
0 COSMOS 1299
1 12783U 81081A   24187.52520945 -.00000054  00000-0  29962-4 0  9995
2 12783  65.1163 121.7188 0024830  51.2898 309.0379 13.85463144168660
0 COSMOS 1300
1 12785U 81082A   24187.62112645  .00014000  00000-0  42977-3 0  9998
2 12785  82.4958  35.1288 0001021  94.2072 265.9287 15.33610005342761
0 SL-14 R/B
1 12786U 81082B   24187.59753580  .00000716  00000-0  79010-4 0  9992
2 12786  82.4876  59.3779 0018042  34.4517 325.7865 14.85976032295928
0 N-2 R/B(2)
1 12787U 81012C   24187.38924463  .00035493  00000-0  17124-2 0  9999
2 12787  28.0610 258.8034 5816104 194.0987 137.9005  4.38470956511713
0 COSMOS 1302
1 12791U 81084A   24187.46262077  .00000251  00000-0  98039-4 0  9998
2 12791  74.0278  96.0391 0017319  61.4497 298.8396 14.34581216240646
0 SL-8 R/B
1 12792U 81084B   24187.57396795  .00000365  00000-0  12850-3 0  9998
2 12792  74.0309 332.8401 0013763 349.8362  10.2511 14.38307642244842
0 SL-8 DEB
1 12793U 81084C   24187.28869348  .00004879  00000-0  84402-3 0  9992
2 12793  74.0273 135.0774 0004868 270.1122  89.9491 14.68626875263728
0 COSMOS 1304
1 12803U 81087A   24187.58366282  .00000109  00000-0  77963-4 0  9996
2 12803  82.9337 223.3947 0047285  91.3917 269.2664 13.87695195544219
0 SL-8 R/B
1 12804U 81087B   24187.50806155  .00000043  00000-0  22584-4 0  9993
2 12804  82.9294 185.7846 0042146 347.3333 126.5500 13.89587058170712
0 COSMOS 1299 FUEL CORE
1 12808U 81081C   24187.53885917 -.00000055  00000-0  28286-4 0  9996
2 12808  65.1155 254.5332 0022923 340.0133 117.5245 13.88633625173551
0 COSMOS 1124 DEB
1 12814U 79077E   24186.67028308  .00002381  00000-0  73837-2 0  9995
2 12814  62.4478 345.1770 7387498  48.2536 354.6489  2.05016514 48050
0 COSMOS 931 DEB
1 12815U 77068E   24160.94635836 -.00000553  00000-0  00000+0 0  9995
2 12815  68.9809 322.0106 5714684 340.6315 359.4713  2.01211415136920
0 COSMOS 1191 DEB
1 12817U 80057E   24186.89370507  .00000752  00000-0  00000+0 0  9992
2 12817  64.3437  92.4922 7072682  36.5385 355.2622  1.99824312234966
0 COSMOS 1305
1 12818U 81088A   24185.87753080 -.00000008  00000-0  16322-3 0  9999
2 12818  62.8444  26.1354 4875554 251.4950  51.0801  5.46136500853792
0 DELTA 1 DEB
1 12825U 78026EW  24187.56289297  .00000054  00000-0  75155-4 0  9997
2 12825  99.4567  38.4649 0059407 265.5714 152.2042 13.94444022205892
0 SL-6 R/B(2)
1 12827U 81088F   24187.14502330 -.00000012  00000-0  26417-3 0  9992
2 12827  63.0603  29.5504 4732082 225.3414  84.7665  5.48813228858088
0 COSMOS 1191 DEB
1 12834U 80057F   24186.52864835  .00000814  00000-0  00000-0 0  9993
2 12834  65.7050 164.4642 6490143  31.2107 354.5846  2.00182730227011
0 COSMOS 1308
1 12835U 81091A   24187.56229366  .00000075  00000-0  62717-4 0  9998
2 12835  82.9206 344.0258 0026212 282.0204 149.8891 13.75541414147721
0 SL-8 R/B
1 12836U 81091B   24187.51149826  .00000065  00000-0  50678-4 0  9998
2 12836  82.9198 319.3865 0022657 189.5540 242.1633 13.76656152533013
0 AUREOLE 3
1 12848U 81094A   24187.55282745  .00005991  00000-0  31956-3 0  9996
2 12848  82.4750 208.8487 0523690 275.7043  78.4687 14.42048655157025
0 SL-14 R/B
1 12849U 81094B   24187.56974548  .00001172  00000-0  10705-3 0  9993
2 12849  82.4919 346.8588 0883618 318.4332  35.2749 13.54602004 89731
0 SL-12 R/B(2)
1 12850U 81069F   24186.17486896 -.00000088  00000-0  00000-0 0  9997
2 12850   9.7774 305.6245 0024278 172.0093 168.3737  0.97700148109250
0 SL-12 R/B(2)
1 12851U 81061F   24187.18250657 -.00000099  00000-0  00000-0 0  9998
2 12851   7.6925 297.4660 0002169 111.2693 270.4250  1.01005601 40539
0 SL-12 DEB
1 12854U 70103G   24187.28044270  .00042297  00000-0  98007-1 0  9999
2 12854  50.3429  41.3202 0354198  31.1609 330.9746 13.03951396105555
0 SBS 2
1 12855U 81096A   24186.98362512  .00000117  00000-0  00000-0 0  9991
2 12855  11.3963 326.2884 0007709 193.8213 166.8183  1.00116866111486
0 TANSEI 3 DEB
1 12857U 77012H   24187.43109709 -.00000423  00000-0 -11818-2 0  9997
2 12857  66.3003 299.3338 1690512  80.2594 298.4330 10.78156002694943
0 SCOUT D-1 DEB
1 12858U 77106C   24186.83156578  .00000163  00000-0  24327-3 0  9990
2 12858  89.5028  21.9573 0018113   2.2201  12.1011 13.48971226195594
0 COSMOS 970 DEB
1 12860U 77121AN  24187.58934753  .00000153  00000-0  27659-3 0  9992
2 12860  65.8058 294.2718 0136475 305.2955  67.1135 13.63111063214419
0 COSMOS 970 DEB
1 12861U 77121AP  24187.51132028  .00000186  00000-0  46202-3 0  9992
2 12861  65.7730 109.5848 0106467 320.8023 215.1056 13.40022714175552
0 COSMOS 970 DEB
1 12862U 77121AQ  24187.27482385  .00001908  00000-0  10187-2 0  9995
2 12862  66.2089 139.5543 0154024 261.0246 219.7459 14.09580493250332
0 COSMOS 970 DEB
1 12863U 77121AR  24187.47748324  .00000914  00000-0  11697-2 0  9999
2 12863  65.7842  55.8534 0055013  52.3114   7.3271 13.67279396211573
0 COSMOS 970 DEB
1 12864U 77121AS  24187.49725420  .00001192  00000-0  96771-3 0  9990
2 12864  65.8311 245.9777 0099113 339.5121 130.1580 13.91493484219258
0 COSMOS 970 DEB
1 12865U 77121AT  24186.93390502  .00001349  00000-0  15172-2 0  9997
2 12865  65.7713 132.8149 0062646  19.2811  42.1550 13.73335398999310
0 COSMOS 970 DEB
1 12866U 77121AU  24187.52889194  .00000089  00000-0  22041-3 0  9998
2 12866  65.8166 254.4514 0108026 343.6031 125.0435 13.58208748207318
0 COSMOS 970 DEB
1 12867U 77121AV  24187.51641697  .00000106  00000-0  33803-3 0  9990
2 12867  65.9466 226.3203 0082486 173.0895 304.2786 13.36577936191226
0 COSMOS 970 DEB
1 12868U 77121AW  24187.35737897  .00001228  00000-0  14035-2 0  9992
2 12868  65.7628 161.8683 0049065  65.5533  82.9948 13.73010314314185
0 COSMOS 970 DEB
1 12869U 77121AX  24187.48293902  .00000740  00000-0  82099-3 0  9995
2 12869  65.7896 258.7065 0098135 287.8262  85.1222 13.75644802321021
0 COSMOS 970 DEB
1 12870U 77121AY  24187.36801440  .00001529  00000-0  13051-2 0  9993
2 12870  65.7241 150.6191 0114392   8.9467 146.9490 13.87098727330621
0 COSMOS 1312
1 12879U 81098A   24187.63303701  .00000016  00000-0  43516-4 0  9998
2 12879  82.6016 302.9450 0006714 210.7782 161.5181 12.42374689481192
0 SL-14 R/B
1 12880U 81098B   24187.60079568  .00000014  00000-0  29688-4 0  9990
2 12880  82.6016 293.6356 0007787 150.8770 221.7139 12.42854572940025
0 THOR DELTA 1 R/B
1 12889U 81100C   24187.57522838  .00000202  00000-0  12284-3 0  9994
2 12889  99.8569 179.1468 1311053 267.7140 220.7163 12.19101480894585
0 COSMOS 1261 DEB
1 12892U 81031E   24187.55208633  .00000408  00000-0  00000-0 0  9991
2 12892  62.2690 193.6706 7164365  36.1266 355.6053  2.00105009245158
0 COSMOS 1261 DEB
1 12893U 81031F   24187.43594434 -.00000136  00000-0  00000-0 0  9995
2 12893  64.7696  70.6400 7065512  31.7947 356.1045  2.01075892297799
0 COSMOS 1261 DEB
1 12894U 81031G   24186.85456855  .00000099  00000-0  00000-0 0  9992
2 12894  69.3358 132.7095 5993655   8.4926 196.2540  2.00497112287480
0 RADUGA 10
1 12897U 81102A   24186.84612662 -.00000115  00000-0  00000-0 0  9993
2 12897   8.3676 301.0977 0005479 203.1121 161.2923  1.00295593110203
0 SL-3 R/B
1 12904U 81103B   24187.52818790  .00004579  00000-0  25973-3 0  9995
2 12904  81.1618 206.9913 0020511 189.7836 170.2994 15.12603078880409
0 COSMOS 1030 DEB
1 12907U 78083E   24187.28391822 -.00000909  00000-0  00000-0 0  9991
2 12907  62.6698 119.5490 7302234  49.3015 353.9378  2.00157264320235
0 COSMOS 1030 DEB
1 12919U 78083F   24187.35772912 -.00000365  00000-0  00000-0 0  9991
2 12919  66.8377 310.5262 6200175 353.7084   0.9796  2.00026619 54344
0 OPS 4029
1 12930U 81107A   24187.30882742 -.00000351  00000-0  00000-0 0  9998
2 12930   5.5926 355.2227 1015275  37.3175 312.8806  1.00344373   729
0 TITAN 3C TRANSTAGE R/B
1 12932U 81107C   24186.70952609 -.00000039  00000-0  00000-0 0  9996
2 12932   5.1832 358.2732 1030174 112.1343 259.2574  0.99598428 19120
0 COSMOS 1317
1 12933U 81108A   24187.04887244 -.00000453  00000-0  00000-0 0  9998
2 12933  71.4964 137.8708 5035215 342.5991 222.8469  2.00282321312008
0 SL-6 R/B(2)
1 12940U 81108D   24180.92205688  .00000413  00000-0  00000-0 0  9997
2 12940  66.7489 309.0170 6482056 356.6294   0.4001  1.99090505310247
0 COSMOS 970 DEB
1 12942U 77121AZ  24187.58984929  .00000163  00000-0  43599-3 0  9995
2 12942  65.8306   8.4337 0106448 178.5108 244.7522 13.37395319 98452
0 COSMOS 1275 DEB
1 12947U 81053EB  24187.44178007  .00000539  00000-0  81554-3 0  9996
2 12947  83.0931 247.8148 0194237 265.1675 107.1012 13.43891972 85485
0 COSMOS 1275 DEB
1 12949U 81053ED  24187.51739700  .00001120  00000-0  82134-3 0  9991
2 12949  82.8449   3.0551 0031204 318.3528  96.8303 13.94751907161515
0 COSMOS 1275 DEB
1 12950U 81053EE  24187.53236476  .00001083  00000-0  54638-3 0  9993
2 12950  83.0113 278.8562 0052165 262.4123 109.9381 14.14827990199995
0 COSMOS 1275 DEB
1 12952U 81053EG  24187.33995925  .00001297  00000-0  91658-3 0  9994
2 12952  82.9616 160.3745 0011686  55.2422  68.5114 13.97147469163333
0 COSMOS 1275 DEB
1 12962U 81053EH  24187.09652910  .00001681  00000-0  11310-2 0  9995
2 12962  82.9628 202.0604 0029805  42.4960 317.8510 13.99859517160740
0 COSMOS 1275 DEB
1 12963U 81053EJ  24187.45452755  .00000569  00000-0  51107-3 0  9994
2 12963  82.9464 346.7475 0025565  72.4800 341.5505 13.82349231147489
0 COSMOS 1275 DEB
1 12964U 81053EK  24187.30308834  .00000042  00000-0  25420-4 0  9993
2 12964  82.9463 287.8694 0038279 341.1026  87.4131 13.80250273150614
0 COSMOS 1275 DEB
1 12966U 81053EM  24187.50281416  .00002801  00000-0  16503-2 0  9998
2 12966  82.9421  96.7177 0029265 227.2199 199.1374 14.07403440164973
0 SATCOM 3R
1 12967U 81114A   24187.46065962 -.00000101  00000-0  00000-0 0  9993
2 12967  12.9214 336.9339 0001468 228.1346 141.4615  1.00093809120945
0 COSMOS 1320
1 12975U 81116A   24187.57640687  .00000015  00000-0  26384-3 0  9998
2 12975  73.9812 250.2786 0096985 219.4856 251.2622 12.28031822909803
0 COSMOS 1321
1 12976U 81116B   24187.58139641  .00000020  00000-0  30021-3 0  9992
2 12976  73.9802 236.7503 0094525 207.9340 268.2384 12.28385437910367
0 COSMOS 1322
1 12977U 81116C   24187.57722725  .00000018  00000-0  28724-3 0  9997
2 12977  73.9795 224.3987 0093221 191.0362 286.6465 12.28715485910855
0 COSMOS 1323
1 12978U 81116D   24187.53382419  .00000007  00000-0  18305-3 0  9998
2 12978  73.9794 206.9351 0089910 173.0316 302.6982 12.29194003911600
0 COSMOS 1324
1 12979U 81116E   24187.49820716 -.00000007  00000-0  67033-4 0  9995
2 12979  73.9793 186.7815 0087189 149.4546 330.7236 12.29726292912435
0 COSMOS 1325
1 12980U 81116F   24187.45500728 -.00000014  00000-0  83961-5 0  9998
2 12980  73.9800 172.2881 0084922 131.9250  36.7994 12.30122893913039
0 COSMOS 1326
1 12981U 81116G   24187.62924304 -.00000023  00000-0 -69082-4 0  9996
2 12981  73.9811 144.8773 0081746  98.2482  74.3326 12.30842196894614
0 COSMOS 1327
1 12982U 81116H   24187.54489108 -.00000017  00000-0 -19738-4 0  9992
2 12982  73.9821 115.2507 0076388  68.9318 104.1739 12.31633227915383
0 SL-8 R/B
1 12983U 81116J   24187.63268272  .00000047  00000-0  55269-3 0  9999
2 12983  73.9854  13.2110 0114684 347.4814  77.1960 12.24797434639319
0 COSMOS 1247 DEB
1 12984U 81016F   24186.47638571 -.00000143  00000-0  00000-0 0  9991
2 12984  67.9384  55.5610 6339546 359.1833   0.3394  2.02658832315524
0 COSMOS 1328
1 12987U 81117A   24187.55831457  .00006336  00000-0  30836-3 0  9996
2 12987  82.4975 245.2432 0016750 170.3029 189.8531 15.18083229320691
0 SL-14 R/B
1 12988U 81117B   24187.56951646  .00000807  00000-0  89325-4 0  9996
2 12988  82.5237 176.5524 0016916 340.4840  19.5726 14.86037013280961
0 COSMOS 1247 DEB
1 12992U 81016H   24187.23090665  .00000094  00000-0  00000-0 0  9995
2 12992  67.7178  59.8690 6381810   1.8684 359.8849  2.02531955217369
0 COSMOS 1285 DEB
1 12993U 81071E   24186.90020539  .00000377  00000-0  00000+0 0  9996
2 12993  66.7559 139.7613 6614433  20.0383 356.6343  1.97851255224097
0 INTELSAT 503
1 12994U 81119A   24186.80605039 -.00000268  00000-0  00000-0 0  9994
2 12994  12.2455 331.8571 0039723 240.0793 310.4406  0.99467365119618
0 EKRAN 2 DEB
1 12996U 77092J   24187.56623311 -.00000145  00000-0  00000+0 0  9991
2 12996   6.1327 284.2439 0018600 245.8391 118.4677  1.00060249 77377
0 RADIO 3
1 12997U 81120A   24187.58661630  .00000021  00000-0  11583-3 0  9991
2 12997  82.9609 299.0689 0057286 316.4284  56.6772 12.15851414888226
0 RADIO 8
1 12998U 81120B   24187.41780461 -.00000107  00000-0 -13924-2 0  9995
2 12998  82.9591 146.3180 0019884 134.6706 346.7997 12.03178998868561
0 RADIO 5
1 12999U 81120C   24187.55473898  .00000058  00000-0  56177-3 0  9995
2 12999  82.9610 112.3308 0014282 341.6842 192.1793 12.05296641872084
0 RADIO 4
1 13000U 81120D   24187.47936293  .00000130  00000-0  13763-2 0  9997
2 13000  82.9604  88.4372 0017283 194.2203 339.7917 12.06901272874298
0 RADIO 7
1 13001U 81120E   24187.58080250  .00000083  00000-0  81067-3 0  9993
2 13001  82.9586  52.6377 0024545  40.9761  21.0095 12.08931254877455
0 RADIO 6
1 13002U 81120F   24187.45438137  .00000045  00000-0  36749-3 0  9996
2 13002  82.9618 332.8971 0052804  94.0924 321.9174 12.13827096885111
0 SL-8 R/B
1 13003U 81120G   24187.63155833  .00000060  00000-0  69034-3 0  9996
2 13003  82.9565 327.6570 0082499 173.9276 197.1814 11.91520254850678
0 ATLAS CENTAUR R/B
1 13007U 81119B   24187.51769307  .00029624 -18633-5  12284-2 0  9990
2 13007  23.5200 233.1331 2742276   5.0744 357.2413  9.87720377117117
0 MARECS A
1 13010U 81122A   24187.54115939 -.00000214  00000-0  00000-0 0  9996
2 13010  12.6074 333.0829 0114963 247.2643  19.8028  0.95039466104596
0 CAT 4
1 13011U 81122B   24187.36949871  .00002032  00000-0  49473-3 0  9996
2 13011  10.3178 223.9633 6548027 167.5876 223.7308  3.24507332337533
0 MOLNIYA 1-52
1 13012U 81123A   24186.08419500  .00001520  00000-0  29830-1 0  9991
2 13012  61.5502 174.9584 7162961 264.6536  17.5833  2.00769108311577
0 SL-6 R/B(2)
1 13016U 81123D   24185.94704055  .00000184  00000-0  61378-3 0  9991
2 13016  62.2446 148.3161 6996627 276.4696  14.7894  2.40300420343228
0 COSMOS 1275 DEB
1 13017U 81053EP  24187.59576350  .00001467  00000-0  10114-2 0  9998
2 13017  82.9306 125.0726 0033088 122.5844  54.0456 13.98367303157384
0 COSMOS 1275 DEB
1 13018U 81053EQ  24187.54756640  .00001604  00000-0  12047-2 0  9996
2 13018  82.6738 208.9410 0053076 163.9960 324.1837 13.93205721146202
0 COSMOS 1275 DEB
1 13019U 81053ER  24187.53170053  .00002641  00000-0  18199-2 0  9990
2 13019  82.9416 278.9776 0074455 216.0536 157.2038 13.97617261146796
0 COSMOS 1275 DEB
1 13020U 81053ES  24187.11053828  .00000809  00000-0  75004-3 0  9999
2 13020  82.6908  51.9572 0114961 346.8531 166.7617 13.78349779132224
0 COSMOS 1275 DEB
1 13021U 81053ET  24187.55453861  .00002157  00000-0  13830-2 0  9995
2 13021  83.1451 106.7705 0023063 122.9440  52.7819 14.02736556160056
0 COSMOS 1275 DEB
1 13022U 81053EU  24187.56263491  .00001803  00000-0  87669-3 0  9994
2 13022  82.9170 111.5956 0045559 342.7285 192.3874 14.17258714184517
0 COSMOS 1275 DEB
1 13024U 81053EW  24187.25887104  .00001803  00000-0  11291-2 0  9992
2 13024  82.9253  94.7875 0048376  12.3448 154.5033 14.03516131160307
0 COSMOS 1275 DEB
1 13026U 81053EX  24187.14525361  .00011023  00000-0  27940-2 0  9999
2 13026  82.9307  78.5081 0012020 308.6970 204.5424 14.50738690190970
0 COSMOS 1331
1 13027U 82001A   24187.60882669  .00000289  00000-0  10569-3 0  9994
2 13027  74.0478  24.5419 0023517 148.1507 212.1074 14.37197525225329
0 SL-8 R/B
1 13028U 82001B   24187.62017568  .00000432  00000-0  14777-3 0  9990
2 13028  74.0423 322.9624 0018799 129.8320 230.4493 14.39143922227197
0 SL-8 DEB *
1 13029U 82001C   24187.61508079  .00004020  00000-0  70940-3 0  9993
2 13029  73.9715  38.6644 0007687 278.6932 142.2723 14.67802128191297
0 SL-8 DEB
1 13030U 82001D   24187.32895329  .00014247  00000-0  11239-2 0  9997
2 13030  74.0149 260.5439 0011781 317.6655 159.3742 15.00700838264100
0 COSMOS 1333
1 13033U 82003A   24187.51997226  .00000077  00000-0  66657-4 0  9994
2 13033  82.9432 331.0679 0032479  12.0294  57.8422 13.73362551128502
0 SL-8 R/B
1 13034U 82003B   24187.56229206  .00000096  00000-0  84041-4 0  9994
2 13034  82.9376 286.7296 0031467 211.1244 159.4321 13.75399023131174
0 SATCOM 4
1 13035U 82004A   24186.62439105 -.00000014  00000-0  00000-0 0  9993
2 13035  13.5063 340.6378 0045215 180.4813 179.5309  0.99595239118112
0 COSMOS 1275 DEB
1 13053U 81053EY  24187.60401720  .00001222  00000-0  13199-2 0  9993
2 13053  83.0758 213.1541 0115262 262.0572 227.4321 13.69731065125991
0 EKRAN 8
1 13056U 82009A   24186.89285328  .00000090  00000-0  00000-0 0  9999
2 13056   8.7050 302.5754 0025456 319.5765  43.7682  0.99928385111502
0 COSMOS 1339
1 13065U 82012A   24187.54865114  .00000081  00000-0  68550-4 0  9991
2 13065  82.9010 130.4273 0043133 347.3816  12.6256 13.75671071126686
0 SL-8 R/B
1 13066U 82012B   24187.52113514  .00000093  00000-0  77830-4 0  9994
2 13066  82.8969  93.1212 0042384 230.5438 303.1874 13.77281187129434
0 COSMOS 1340
1 13067U 82013A   24186.95358865  .00027967  00000-0  59114-3 0  9995
2 13067  81.1756 351.2405 0002508 114.7024 245.4481 15.45013986319598
0 SL-3 R/B
1 13068U 82013B   24187.52250369  .00005889  00000-0  32057-3 0  9996
2 13068  81.1770 154.3436 0027580  76.5597 283.8702 15.13948104311451
0 WESTAR 4
1 13069U 82014A   24187.18607450 -.00000201  00000-0  00000-0 0  9991
2 13069  13.3764 340.0169 0002965 197.3590 160.8012  0.99778213 39336
0 MOLNIYA 1-53
1 13070U 82015A   24186.31478888 -.00000841  00000-0  51530-2 0  9995
2 13070  62.6576 126.3363 6943344 283.3314  13.1325  2.00414237310266
0 COSMOS 1275 DEB
1 13073U 81053EZ  24187.51646128  .00000169  00000-0  16572-3 0  9996
2 13073  82.9385 104.4513 0086162 281.0857 202.0467 13.72125513147725
0 COSMOS 1275 DEB
1 13074U 81053FA  24187.52465024  .00000744  00000-0  66256-3 0  9995
2 13074  82.9469 353.9645 0032239 100.1774 320.8057 13.83134189158087
0 SL-6 R/B(2)
1 13075U 82015D   24187.02865808  .00000527  00000-0  00000-0 0  9995
2 13075  62.9388 189.1829 7002701 278.6741  14.0688  1.98088652305051
0 COSMOS 1341
1 13080U 82016A   24186.27520616  .00000666  00000-0  00000-0 0  9997
2 13080  70.2285  39.5456 5998455 333.6394   5.5005  2.00786413220444
0 INTELSAT 504
1 13083U 82017A   24186.31954317 -.00000243  00000-0  00000-0 0  9997
2 13083  12.3451 332.3033 0014516 202.0989 171.9316  0.99226200134687
0 OPS 8701
1 13086U 82019A   24187.18233253 -.00000173  00000-0  00000+0 0  9998
2 13086  10.7401 314.4912 0003172 238.1676 125.5891  0.98190655 18668
0 TITAN 3C TRANSTAGE R/B
1 13089U 82019B   24187.35350690 -.00000210  00000-0  00000-0 0  9998
2 13089   9.0540 307.4187 0014200 138.7523 221.4816  1.01260894 18427
0 SL-6 R/B(2)
1 13090U 82016D   24187.23950293  .00001437  00000-0  99083-3 0  9992
2 13090  63.6074 213.6770 7419519 357.6623   0.3862  2.03172519314024
0 GORIZONT 5
1 13092U 82020A   24186.98136252 -.00000028  00000-0  00000-0 0  9995
2 13092   9.9410 307.0714 0033804 232.7920 134.6976  0.98531761114580
0 COSMOS 1344
1 13110U 82024A   24187.62327753  .00000076  00000-0  64199-4 0  9995
2 13110  82.9206 226.3651 0029000 164.3804 311.9619 13.74127665119819
0 SL-8 R/B
1 13111U 82024B   24187.59391743  .00000131  00000-0  11767-3 0  9996
2 13111  82.9241 194.8674 0042029  75.8397  46.3868 13.76073457122407
0 METEOR 2-8
1 13113U 82025A   24187.56797454  .00000035  00000-0  17166-4 0  9998
2 13113  82.5403 305.3085 0019163  79.9402 291.3580 13.85497970137101
0 SL-14 R/B
1 13114U 82025B   24187.59150604  .00000036  00000-0  18985-4 0  9993
2 13114  82.5412 313.3992 0015783 114.5207 256.1130 13.84737823136552
0 SL-3 R/B
1 13121U 82027B   24187.60319241  .00005593  00000-0  27867-3 0  9990
2 13121  81.1912  35.4265 0010471 176.7964 183.3334 15.17358834305378
0 COSMOS 1348
1 13124U 82029A   24187.18877221 -.00000436  00000-0  00000-0 0  9994
2 13124  71.9891 171.9691 5179694 352.8662 201.7685  2.00294611309124
0 COSMOS 1349
1 13127U 82030A   24187.50716947  .00000042  00000-0  29109-4 0  9999
2 13127  82.9310 329.5039 0029968 216.2228 211.0246 13.73927399117588
0 SL-8 R/B
1 13128U 82030B   24187.38036257  .00000096  00000-0  82647-4 0  9990
2 13128  82.9258 288.2700 0030115  72.3356 351.8841 13.75880049119538
0 INSAT 1A
1 13129U 82031A   24187.51430124 -.00000326  00000-0  00000-0 0  9994
2 13129   8.7385 304.3080 0012784 100.0613 170.8944  1.00206675159296
0 OPS 4682 DEB
1 13131U 65027H   24186.91981557  .00000446  00000-0  15057-2 0  9999
2 13131  90.2484 337.7641 0029963 142.7225  12.3116 12.97596249538319
0 N-1 DEB
1 13132U 78018C   24187.19254909 -.00000035  00000-0  25793-4 0  9994
2 13132  69.2058 161.6469 0207270 148.6120 225.2434 13.34911427258366
0 COSMOS 1354
1 13148U 82037A   24187.59941912  .00000229  00000-0  94172-4 0  9999
2 13148  74.0392 324.7059 0010087 303.7091  56.3098 14.32368663203157
0 SL-8 R/B
1 13149U 82037B   24187.51569382  .00000291  00000-0  10914-3 0  9999
2 13149  74.0396 211.5071 0012182 149.1186 211.0686 14.36023778206812
0 SL-3 R/B
1 13154U 82039B   24187.56178929  .00003241  00000-0  22942-3 0  9997
2 13154  81.1796 197.4382 0036333 169.8986 190.2975 15.04045399289414
0 COSMOS 1357
1 13160U 82040A   24187.53891884 -.00000024  00000-0 -45923-4 0  9998
2 13160  74.0133 307.4323 0049440 129.5871 309.5404 12.56047559933360
0 COSMOS 1358
1 13161U 82040B   24187.62921976  .00000004  00000-0  12333-3 0  9999
2 13161  74.0124  27.0521 0042159 231.7945 202.5811 12.53976868930131
0 COSMOS 1359
1 13162U 82040C   24187.49308991 -.00000015  00000-0  68519-5 0  9993
2 13162  74.0120 102.4851 0031311 318.9153 214.7769 12.52023554928520
0 COSMOS 1360
1 13163U 82040D   24187.41142924 -.00000015  00000-0  27385-5 0  9994
2 13163  74.0093 172.9095 0022340  50.2258  61.5002 12.50181721648825
0 COSMOS 1361
1 13164U 82040E   24187.61413505  .00000019  00000-0  23169-3 0  9990
2 13164  74.0106 248.9022 0013892 160.1005 314.7365 12.48193758921322
0 COSMOS 1362
1 13165U 82040F   24187.53073810 -.00000025  00000-0 -65961-4 0  9999
2 13165  74.0134 326.6521 0018354 287.8916 140.6459 12.46143624918060
0 COSMOS 1363
1 13166U 82040G   24187.62420334  .00000009  00000-0  17490-3 0  9990
2 13166  74.0120  42.4139 0019236  49.7120  15.7195 12.44145793915047
0 COSMOS 1364
1 13167U 82040H   24187.57430153 -.00000027  00000-0 -84010-4 0  9990
2 13167  74.0113 128.6387 0031968 154.2480  18.5236 12.41874324911868
0 SL-8 R/B
1 13168U 82040J   24187.49425736 -.00000097  00000-0 -74863-3 0  9994
2 13168  74.0479 159.4248 0136054 185.8696 174.0751 12.22887722882416
0 SL-6 R/B(2)
1 13169U 82029D   24186.68572138  .00000324  00000-0  00000-0 0  9991
2 13169  71.3879   0.8781 5535353 334.6022   6.1013  2.04136165314445
0 OPS 6553
1 13172U 82041C   24187.47434879  .00004955  00000-0  43560-3 0  9991
2 13172  95.9874  93.0165 0001559 121.5917 238.5462 14.96841084  8821
0 COSMOS 1365
1 13175U 82043A   24187.59170888 -.00000032  00000-0  46358-4 0  9998
2 13175  65.0682 261.2371 0071350 288.2799 175.5519 13.89699887141073
0 COSMOS 1366
1 13177U 82044A   24186.91668878 -.00000154  00000-0  00000+0 0  9991
2 13177   9.9216 304.1930 0009442 125.5220 265.7673  1.00276724126446
0 COSMOS 1367
1 13205U 82045A   24185.54925238 -.00000088  00000-0  00000+0 0  9994
2 13205  71.3306  94.5401 5216840 345.1668   4.0317  2.00569105308571
0 COSMOS 1371
1 13241U 82051A   24187.48432996  .00000236  00000-0  97029-4 0  9996
2 13241  74.0435 105.9136 0012628  18.1148 342.0450 14.32169315197542
0 SL-8 R/B
1 13242U 82051B   24187.61837675  .00000384  00000-0  13880-3 0  9991
2 13242  74.0446 306.4782 0025340 236.0618 123.8127 14.36688815203042
0 COSMOS 1372
1 13243U 82052A   24187.58111773 -.00000053  00000-0  32221-4 0  9998
2 13243  64.9039 304.0440 0028813 177.9514 182.1670 13.86044590547671
0 COSMOS 1375
1 13259U 82055A   24187.60005519  .00000389  00000-0  42228-3 0  9999
2 13259  65.8325  31.4436 0020934 192.7321 167.3220 13.84110889115567
0 SL-8 R/B
1 13260U 82055B   24187.62720258  .00000032  00000-0  11816-3 0  9991
2 13260  65.8331  40.7482 0045988 263.1068 169.3511 13.74462192113139
0 SL-8 DEB
1 13261U 82055C   24187.34555115 -.00000028  00000-0  56755-4 0  9997
2 13261  65.8338 152.8166 0017664 309.1914 202.3803 13.72774268108406
0 WESTAR 5
1 13269U 82058A   24187.15182676 -.00000195  00000-0  00000-0 0  9998
2 13269  13.7985 342.2659 0015334 244.4688 287.1709  0.99219070112475
0 COSMOS 1378
1 13271U 82059A   24187.57766523  .00035380  00000-0  60367-3 0  9995
2 13271  82.4537 133.5238 0003350 153.7777 206.3644 15.51163658302582
0 SL-14 R/B
1 13272U 82059B   24187.56045035  .00000659  00000-0  72629-4 0  9999
2 13272  82.5092 238.1833 0016730 247.1824 112.7626 14.85950904252993
0 COSMOS 1382
1 13295U 82064A   24186.79085442  .00001037  00000-0  00000-0 0  9991
2 13295  62.4972 233.4105 6817557  37.0841 354.6700  2.00469841266263
0 SL-6 R/B(2)
1 13298U 82064D   24186.55255305  .00000624  00000-0  00000-0 0  9996
2 13298  66.6343 135.3821 6520819  20.9195 356.3621  2.03256097235137
0 COSMOS 1383
1 13301U 82066A   24187.51794078  .00000068  00000-0  61759-4 0  9999
2 13301  82.9313 176.5090 0028628  63.4095  54.2950 13.68806084 98340
0 SL-8 R/B
1 13302U 82066B   24187.43424888  .00000113  00000-0  11110-3 0  9996
2 13302  82.9321 147.3069 0037881 305.8104 173.7261 13.70433970100908
0 COSMOS 1386
1 13353U 82069A   24187.47975381  .00000079  00000-0  65454-4 0  9990
2 13353  82.9631 272.7577 0037409 257.0895 102.6083 13.76517162109067
0 SL-8 R/B
1 13354U 82069B   24187.60396082  .00000052  00000-0  34397-4 0  9994
2 13354  82.9581 225.1367 0053329  95.9321 264.7920 13.79110268112325
0 THOR ABLESTAR DEB
1 13364U 61015KS  24187.59070654  .00000806  00000-0  87562-3 0  9993
2 13364  66.2609 260.1655 0107438 227.7954 242.6175 13.75795011314220
0 LANDSAT 4
1 13367U 82072A   24187.43823218  .00016293  00000-0  46740-3 0  9997
2 13367  98.2030 256.2628 0008749  41.0963 319.0936 15.35937903701448
0 COSMOS 1388
1 13375U 82073A   24187.57469352  .00000013  00000-0  17292-3 0  9990
2 13375  74.0142 258.2417 0051891 164.9794 306.0378 12.57489443926092
0 COSMOS 1389
1 13376U 82073B   24187.62114428 -.00000018  00000-0 -74503-5 0  9995
2 13376  74.0166 338.9200 0042325 265.5936 176.7922 12.55385424922874
0 COSMOS 1390
1 13377U 82073C   24187.40663459  .00000008  00000-0  15022-3 0  9991
2 13377  74.0154  57.0586 0030727 350.9047 182.5531 12.53359933919739
0 COSMOS 1391
1 13378U 82073D   24187.57089198 -.00000023  00000-0 -48752-4 0  9998
2 13378  74.0143 130.8388 0020073  80.0648  94.3687 12.51416348916808
0 COSMOS 1392
1 13379U 82073E   24187.50800956  .00000013  00000-0  19156-3 0  9997
2 13379  74.0122 208.8236 0009339 175.4194 300.5436 12.49372480599739
0 COSMOS 1393
1 13380U 82073F   24187.57650578 -.00000010  00000-0  41601-4 0  9998
2 13380  74.0159 289.0946 0008572 346.5160  25.4413 12.47248111910413
0 COSMOS 1394
1 13381U 82073G   24187.56853910 -.00000007  00000-0  57552-4 0  9991
2 13381  74.0158   7.3169 0013483 142.2187 275.9236 12.45175660907257
0 COSMOS 1395
1 13382U 82073H   24187.48714838 -.00000011  00000-0  34842-4 0  9990
2 13382  74.0152  95.3023 0027247 234.5069 299.5081 12.42849837903689
0 SL-8 R/B
1 13386U 82073J   24187.44374205  .00000028  00000-0  38711-3 0  9995
2 13386  74.0019 168.9655 0153896  92.0018  22.4126 12.21142312870580
0 SL-3 R/B
1 13403U 82079B   24187.55335947  .00006242  00000-0  33158-3 0  9997
2 13403  81.1492 190.8352 0031194  67.1235 293.3281 15.14725439284696
0 COSMOS 1372 FUEL CORE
1 13416U 82052D   24187.51751765 -.00000066  00000-0  20289-4 0  9999
2 13416  64.9035  31.7543 0003112  48.7163 326.1121 13.89936370137920
0 ANIK D1 (TELESAT 6)
1 13431U 82082A   24187.54603123 -.00000358  00000-0  00000-0 0  9995
2 13431  13.0097 337.9509 0001464 326.8644 308.2151  1.00129167 39478
0 COSMOS 1275 DEB
1 13456U 81053FC  24187.42396640  .00003478  00000-0  29445-2 0  9990
2 13456  82.8364 187.4069 0143253 269.8288 221.6971 13.82761440113579
0 COSMOS 1275 DEB
1 13458U 81053FE  24187.50412239  .00001701  00000-0  11380-2 0  9990
2 13458  83.0926 341.0113 0025595 120.2386 240.1323 14.00225297159329
0 COSMOS 1275 DEB
1 13460U 81053FG  24187.53733829  .00001071  00000-0  10335-2 0  9996
2 13460  83.1313 105.7163 0080907 206.9387 329.1428 13.77666724124721
0 COSMOS 1275 DEB
1 13462U 81053FJ  24187.57775238  .00001791  00000-0  18481-2 0  9991
2 13462  82.8129 219.6862 0165617  13.3624 107.5322 13.69687438 89841
0 COSMOS 1275 DEB
1 13464U 81053FL  24187.30332591  .00005804  00000-0  22846-2 0  9994
2 13464  82.9123 275.2372 0032788  82.5632 342.0182 14.28783755154771
0 COSMOS 1275 DEB
1 13466U 81053FN  24187.46108976  .00000774  00000-0  96342-3 0  9995
2 13466  83.0709 330.6953 0145703  16.0371  46.7968 13.59120350 84221
0 COSMOS 1275 DEB
1 13467U 81053FP  24187.55843943  .00008463  00000-0  26320-2 0  9997
2 13467  82.9471 103.9772 0022354 359.6495 175.7343 14.40765556186053
0 COSMOS 1275 DEB
1 13468U 81053FQ  24187.51648608  .00001693  00000-0  13393-2 0  9999
2 13468  82.7074 349.1378 0066447  60.5140   0.7795 13.89929174118078
0 COSMOS 1275 DEB
1 13470U 81053FS  24187.62360829  .00000229  00000-0  37169-3 0  9992
2 13470  82.8206 323.2711 0238394 302.9180  68.3340 13.34525764 47795
0 COSMOS 1275 DEB
1 13471U 81053FT  24187.58093122  .00002198  00000-0  14991-2 0  9991
2 13471  82.8084  28.7095 0051171 220.0779 194.6567 13.98830443127877
0 COSMOS 1275 DEB
1 13472U 81053FU  24187.47286051  .00005372  00000-0  23048-2 0  9995
2 13472  82.8498 198.0747 0013188 300.2850 188.6673 14.24589259147531
0 COSMOS 1275 DEB
1 13473U 81053FV  24187.50449142  .00004764  00000-0  22966-2 0  9994
2 13473  82.8345 193.0609 0046970  31.3418  88.7237 14.17947160146639
0 SL-8 DEB
1 13474U 78034C   24187.39667478  .00006665  00000-0  21243-2 0  9990
2 13474  82.9238 159.9508 0011370 226.3414 286.4149 14.39651744359605
0 COSMOS 1275 DEB
1 13476U 81053FW  24187.46156853  .00002501  00000-0  16828-2 0  9993
2 13476  82.8041 359.3804 0053069 139.7936 285.2611 13.99570828129671
0 COSMOS 1275 DEB
1 13477U 81053FX  24187.36569252  .00008589  00000-0  35088-2 0  9995
2 13477  82.9973 155.0514 0060448 359.3570   0.7526 14.26216164143345
0 COSMOS 1275 DEB
1 13478U 81053FY  24187.39863670  .00000791  00000-0  71955-3 0  9991
2 13478  82.8679 338.9788 0094628 252.6151 135.5719 13.80354668110874
0 COSMOS 1275 DEB
1 13479U 81053FZ  24187.50696730  .00485944  00000-0  76370-2 0  9998
2 13479  82.8571 187.7009 0024115 169.0451 191.1333 15.51646209208794
0 COSMOS 1275 DEB
1 13480U 81053GA  24187.48712821  .00002076  00000-0  14956-2 0  9990
2 13480  82.9649 353.4217 0067434 300.3044 113.4844 13.95292248122868
0 COSMOS 1275 DEB
1 13481U 81053GB  24187.25089922  .00015531  00000-0  38814-2 0  9994
2 13481  82.9905 267.7546 0033134 184.7492 175.3398 14.51103242162196
0 COSMOS 1275 DEB
1 13483U 81053GD  24187.48584244  .00002806  00000-0  13865-2 0  9998
2 13483  82.9246 296.1746 0010407  80.6880  40.2517 14.17056040146377
0 COSMOS 1275 DEB
1 13484U 81053GE  24187.17731562  .00001586  00000-0  10735-2 0  9999
2 13484  82.9188 181.6292 0027431 259.2128 222.4915 13.99544063126102
0 COSMOS 1275 DEB
1 13485U 81053GF  24187.49114896  .00000264  00000-0  23804-3 0  9994
2 13485  82.9427 336.7903 0067650 153.6220 272.8621 13.79281228115737
0 COSMOS 1275 DEB
1 13486U 81053GG  24187.34337197  .00016573  00000-0  34061-2 0  9996
2 13486  82.8815 330.0965 0008500 114.9121 245.2967 14.60499620166867
0 COSMOS 1275 DEB
1 13487U 81053GH  24187.60678755  .00018322  00000-0  47907-2 0  9991
2 13487  82.9552  44.2020 0047909  38.2848  21.6197 14.48589377144438
0 COSMOS 1275 DEB
1 13488U 81053GJ  24187.62327468  .00000908  00000-0  13103-2 0  9998
2 13488  83.0854 220.4580 0194377 212.5173 270.0503 13.47237730 56440
0 COSMOS 1275 DEB
1 13489U 81053GK  24187.44768368  .00000691  00000-0  10492-2 0  9994
2 13489  83.1369  63.3140 0237872 256.0276 282.7084 13.40513509 46597
0 COSMOS 1275 DEB
1 13490U 81053GL  24187.56306745  .00000326  00000-0  31210-3 0  9993
2 13490  82.8339 283.9728 0065654 279.4004  93.3938 13.76814501111221
0 COSMOS 926 DEB
1 13491U 77062D   24187.40059148  .00000277  00000-0  27830-3 0  9992
2 13491  82.9307 158.1669 0016906 241.2023 272.8649 13.74236118155084
0 KIKU 4 (ETS 3)
1 13492U 82087A   24187.50015861 -.00000050  00000-0  74623-4 0  9994
2 13492  44.6161  97.1503 0010379  91.2950  78.4993 13.71146298 94931
0 N-1 R/B
1 13493U 82087B   24187.57974390 -.00000059  00000-0  74629-4 0  9998
2 13493  44.6259  10.2275 0173459 280.8664 136.1762 13.44665528 55530
0 SL-8 DEB *
1 13497U 78063C   24187.53310718  .00003394  00000-0  69778-3 0  9997
2 13497  74.0552 279.2700 0012411 302.4509  70.3366 14.60952244225537
0 SL-8 DEB *
1 13498U 81041C   24187.61024965  .00003344  00000-0  63701-3 0  9998
2 13498  74.0163 237.9221 0007643 153.0303 331.4832 14.64443862296574
0 SL-8 DEB *
1 13499U 76069D   24187.60700398  .00002478  00000-0  55062-3 0  9991
2 13499  74.0547 245.5706 0016612 303.8080 175.5187 14.57479156291984
0 SL-8 DEB *
1 13500U 78019C   24187.58121848  .00005181  00000-0  82257-3 0  9995
2 13500  74.0578  23.8581 0007526 312.6561  47.3977 14.72359800521490
0 COSMOS 839 DEB
1 13501U 76067BB  24187.15497809  .00000893  00000-0  37094-2 0  9996
2 13501  66.0336 110.7602 0615407  73.0566  46.6117 12.39284254952701
0 THOR ABLESTAR DEB *
1 13502U 61015KT  24187.50172583  .00004252  00000-0  39824-2 0  9998
2 13502  66.4552  87.1577 0272271 301.7439 237.3171 13.67265256 53076
0 COSMOS 970 DEB
1 13503U 77121BA  24187.62734962  .00000302  00000-0  55740-3 0  9990
2 13503  66.4710  23.6444 0079144 158.9629 272.6703 13.51908715 60964
0 COSMOS 970 DEB
1 13504U 77121BB  24187.04769295  .00000051  00000-0  11268-3 0  9992
2 13504  66.1172  51.2548 0199119 165.2723 346.5483 13.77305111327980
0 COSMOS 970 DEB
1 13505U 77121BC  24187.53382510  .00001605  00000-0  22968-2 0  9992
2 13505  65.3571  47.0313 0024716 348.9569  90.1761 13.58776748160383
0 COSMOS 886 DEB
1 13507U 76126BK  24186.98212760  .00000142  00000-0  87720-3 0  9998
2 13507  65.7580  14.4882 0874646 149.5870   7.8732 11.92180790875886
0 N-1 DEB
1 13510U 82087C   24186.92025126  .00001103  00000-0  15260-2 0  9994
2 13510  44.5771  21.3978 0171763  88.8141  48.1274 13.57885745514408
0 THOR ABLESTAR DEB
1 13511U 61015KU  24187.40634215  .00000220  00000-0  33895-3 0  9996
2 13511  65.8407 157.9991 0117901 165.5470 358.3185 13.67228894193760
0 THOR ABLESTAR DEB
1 13512U 61015KV  24187.31295384  .00010224  00000-0  40298-2 0  9996
2 13512  65.4786 184.7821 0056019 269.5356 198.5726 14.28590616239978
0 THOR ABLESTAR DEB
1 13513U 61015KW  24186.15993198  .00001148  00000-0  10075-2 0  9991
2 13513  65.6774 206.7774 0099378 197.0620 226.1934 13.87232741220159
0 THOR ABLESTAR DEB
1 13514U 61015KX  24187.45681021  .00000356  00000-0  55635-3 0  9997
2 13514  66.7138 216.8799 0237510 123.8123 347.9938 13.50508327168425
0 COSMOS 839 DEB
1 13515U 76067BC  24187.51625191 -.00000245  00000-0 -65752-3 0  9994
2 13515  65.9006 333.8785 0651856  46.2976  14.4841 12.41811053991855
0 COSMOS 839 DEB
1 13516U 76067BD  24187.56039294 -.00000087  00000-0 -10349-3 0  9999
2 13516  65.6652 319.5641 0732634 353.1198  78.7185 12.32390045435841
0 SL-8 DEB
1 13517U 65020FF  24187.19893924  .00002956  00000-0  23720-2 0  9995
2 13517  55.5690 105.5391 0541325 352.1617 156.0607 13.40126087 40458
0 THORAD AGENA D DEB
1 13518U 70025NR  24187.17799769  .00001890  00000-0  17216-2 0  9996
2 13518 100.0201 280.3061 0004444 184.4694 241.0559 13.84769006151632
0 DELTA 1 DEB
1 13524U 73086GM  24186.77537986  .00000183  00000-0  15669-2 0  9993
2 13524 102.8078 134.6134 0043645 265.6606 124.9032 12.48106436988379
0 DELTA 1 DEB
1 13525U 73086GN  24187.36443015  .00000106  00000-0  96982-3 0  9992
2 13525 101.8461 156.1873 0075402 265.6197 253.1481 12.51058468  7825
0 THORAD DELTA 1 DEB
1 13527U 74089EN  24187.42903307  .00002666  00000-0  15911-1 0  9994
2 13527 102.9775 123.7159 0356052  74.1575  41.2654 12.41761279982404
0 THORAD DELTA 1 DEB
1 13528U 74089EP  24186.96739644  .00000285  00000-0  15214-2 0  9996
2 13528 103.1226  79.4294 0080867 345.4043  27.5333 12.78224004 38715
0 DELTA 1 DEB
1 13529U 76077EB  24187.38872660  .00000041  00000-0  11408-2 0  9990
2 13529 101.8282 348.8851 0385366  81.2496 337.8787 11.66033929858916
0 DELTA 1 DEB
1 13530U 76077EC  24187.21886542  .00000390  00000-0  33272-2 0  9998
2 13530 102.3376 278.8972 0126783 214.3005 173.0227 12.36391062974411
0 DELTA 1 DEB
1 13531U 76077ED  24187.39245634 -.00000017  00000-0  28010-3 0  9991
2 13531 102.6497 155.7179 0140583 314.2074 202.3523 12.17091419869455
0 DELTA 1 DEB
1 13532U 76077EE  24187.49344198  .00000052  00000-0  10776-2 0  9995
2 13532 102.1668 168.5488 0286530 120.6388   4.5486 11.93967738876701
0 DELTA 1 DEB
1 13533U 76077EF  24187.10465957 -.00000068  00000-0 -46114-3 0  9996
2 13533 101.8613 237.1474 0358135  11.9625  42.8609 11.74444489951868
0 DELTA 1 DEB
1 13534U 76077EG  24187.56252865  .00000034  00000-0  10542-2 0  9995
2 13534 101.8117  38.0451 0397030 283.6580 133.8470 11.68263793942234
0 DELTA 1 DEB
1 13535U 76077EH  24187.54936032 -.00000025  00000-0  13149-3 0  9997
2 13535 101.6731 176.2762 0023195 163.8216 318.1847 12.39072054 60658
0 DELTA 1 DEB
1 13536U 76077EJ  24187.62182047  .00000023  00000-0  75440-3 0  9995
2 13536 101.7272 191.6263 0421091 153.0822 336.4365 11.75830801974459
0 DELTA 1 DEB
1 13537U 76077EK  24187.43666637 -.00000009  00000-0  31185-3 0  9990
2 13537 102.4579 160.6645 0075658 115.1221  12.5749 12.27175217 45957
0 DELTA 1 DEB
1 13538U 76077EL  24187.01070017  .00000043  00000-0  79499-3 0  9993
2 13538 101.9890 196.2199 0105970 293.6631  89.3113 12.21983852959222
0 DELTA 1 DEB
1 13539U 76077EM  24187.43989022  .00000045  00000-0  11843-2 0  9995
2 13539 101.8402 357.7358 0414335 137.7314 255.1158 11.65338363870846
0 COSMOS 1408
1 13552U 82092A   24187.57289903  .00055154  00000-0  49051-3 0  9994
2 13552  82.5527 222.6930 0010767 248.1272 111.8845 15.68214417148367
0 SL-14 R/B
1 13553U 82092B   24187.56162457  .00000853  00000-0  95783-4 0  9998
2 13553  82.5686 353.5765 0021114 166.5722 259.6018 14.85468426238019
0 EKRAN 9
1 13554U 82093A   24186.91587368 -.00000011  00000-0  00000-0 0  9991
2 13554   8.6764 305.2851 0024431 353.4374  22.8573  1.00206886112864
0 DELTA 1 DEB
1 13561U 78026EY  24187.50279806  .00007163  00000-0  27565-2 0  9992
2 13561  99.0556  23.7841 0141650 210.3749 204.9567 14.25280401194778
0 DELTA 1 DEB
1 13562U 78026EZ  24187.60486861  .00001996  00000-0  73683-3 0  9996
2 13562  98.7543 202.4471 0036677  24.6958  90.2409 14.33223370251952
0 DELTA 1 DEB
1 13563U 78026FA  24187.54320536  .00000564  00000-0  27711-3 0  9997
2 13563  98.8918 195.7336 0043120 198.8872 279.4378 14.21229319181868
0 DELTA 1 DEB
1 13564U 78026FB  24187.39750909  .00000790  00000-0  59403-3 0  9996
2 13564  98.8129 149.9007 0205654  96.2162  53.4033 13.87525987121979
0 DELTA 1 DEB
1 13565U 78026FC  24187.53227541  .00000689  00000-0  52435-3 0  9999
2 13565  98.7676 163.6695 0068686 116.2237  10.7439 13.95748397137480
0 DELTA 1 DEB
1 13566U 78026FD  24187.51805182  .00001830  00000-0  67008-3 0  9992
2 13566  98.7349 208.6388 0033796 346.5941 171.4113 14.33804294183499
0 DELTA 1 DEB
1 13567U 78026FE  24187.41525793  .00003400  00000-0  20373-2 0  9997
2 13567  98.8028 345.3490 0194999 250.5969 164.0293 13.98649480111239
0 DELTA 1 DEB
1 13569U 78026FG  24187.14890594  .00003851  00000-0  18992-2 0  9997
2 13569  99.0947 263.7495 0106497  82.3538 337.8579 14.15159014182257
0 DELTA 1 DEB
1 13570U 78026FH  24187.60323404  .00001721  00000-0  55231-3 0  9993
2 13570  98.5971 210.2799 0046374 169.7201 309.9789 14.40100677247296
0 DELTA 1 DEB
1 13571U 78026FJ  24187.44919139  .00006205  00000-0  14903-2 0  9994
2 13571  98.4373 166.6641 0019282   3.5314 149.6932 14.53629235249561
0 DELTA 1 DEB
1 13572U 78026FK  24187.26494032  .00009404  00000-0  28798-2 0  9996
2 13572  99.0380 288.9563 0119608 119.6528 296.6843 14.37891018210921
0 DELTA 1 DEB
1 13573U 78026FL  24187.60796946  .00000146  00000-0  15186-3 0  9996
2 13573  98.8982  66.8852 0073577  52.9704   7.0687 13.88800385184540
0 DELTA 1 DEB
1 13574U 78026FM  24187.46112002  .00001064  00000-0  55716-3 0  9999
2 13574  98.9677 158.8647 0039050  10.1598 107.6365 14.16112942205756
0 DELTA 1 DEB
1 13575U 78026FN  24187.51879618  .00000323  00000-0  22921-3 0  9998
2 13575  99.2266 189.2989 0018112 230.1464 129.8110 14.04988021205079
0 DELTA 1 DEB
1 13579U 78026FS  24187.48098066  .00001853  00000-0  81734-3 0  9994
2 13579  98.8550 162.1712 0018723   3.8234 356.3084 14.24503124212362
0 DELTA 1 DEB
1 13580U 78026FT  24187.30639253  .00001557  00000-0  51919-3 0  9999
2 13580  98.6392 206.9836 0046640 257.6893 101.9070 14.38382345579280
0 COSMOS 1410
1 13589U 82096A   24187.51090630  .00000032  00000-0  16211-3 0  9996
2 13589  82.6084 187.8264 0007505  68.5155  46.1746 12.42336284895587
0 SL-14 R/B
1 13590U 82096B   24187.51491326  .00000009  00000-0 -78551-5 0  9997
2 13590  82.6085 180.4032 0007324  67.5002  49.2823 12.42679266895143
0 COSMOS 1365 FUEL CORE
1 13594U 82043D   24187.59630786 -.00000080  00000-0  82316-5 0  9999
2 13594  65.0697  13.7979 0065957 247.1621 112.2470 13.93169384146744
0 INTELSAT 505
1 13595U 82097A   24187.15356720 -.00000187  00000-0  00000-0 0  9997
2 13595  13.0101 336.0346 0015788  48.2846 139.0934  0.98407567121028
0 COSMOS 1412
1 13600U 82099A   24187.38040189 -.00000043  00000-0  40360-4 0  9998
2 13600  64.8143  64.2690 0075626 250.7208 283.3430 13.86305745101024
0 COSMOS 1413 (GLONASS)
1 13603U 82100A   24185.71086307 -.00000052  00000-0  00000-0 0  9994
2 13603  64.4644  91.6377 0006839  18.6818 155.9376  2.13866979325911
0 COSMOS 1414 (GLONASS)
1 13606U 82100D   24183.40342475 -.00000047  00000-0  00000-0 0  9996
2 13606  64.4021  95.8876 0077567  30.9474 145.7840  2.13103724324648
0 COSMOS 1415 (GLONASS)
1 13607U 82100E   24187.31509677 -.00000040  00000-0  00000-0 0  9993
2 13607  64.4467  91.5392 0004539  28.3923  80.1720  2.13810443325720
0 SL-12 R/B(AUX MOTOR)
1 13608U 82100F   24187.35373920  .00021066  00000-0  80890-3 0  9996
2 13608  52.0680 277.0066 3513174 295.1895  32.6964  8.38904971924613
0 SL-12 R/B(AUX MOTOR)
1 13609U 82100G   24187.34870386  .00012492  00000-0  12504-2 0  9993
2 13609  52.0306 250.7199 4871469 249.6705  52.9050  5.87161977772224
0 SL-12 R/B(2)
1 13610U 82100H   24186.79087366 -.00000045  00000-0  00000-0 0  9999
2 13610  64.4646  90.5149 0007674 208.5701 156.0665  2.14005275326543
0 COSMOS 1417
1 13617U 82102A   24187.38848125  .00000073  00000-0  59648-4 0  9998
2 13617  82.9677  64.9965 0033055 254.0116 280.1806 13.75505552 93097
0 SL-8 R/B
1 13618U 82102B   24187.59499734  .00000064  00000-0  48713-4 0  9991
2 13618  82.9667  32.6322 0033034 120.9906 293.3193 13.76931784 95437
0 COSMOS 1275 DEB
1 13619U 81053GM  24187.57780366  .00002636  00000-0  16090-2 0  9996
2 13619  83.0333 296.7785 0029484 295.9245  76.9395 14.05444730122982
0 GORIZONT 6
1 13624U 82103A   24187.18233253 -.00000220  00000-0  00000-0 0  9994
2 13624   8.8942 307.3264 0000998 222.9275 148.2460  1.00265273113814
0 SL-12 R/B(2)
1 13630U 82103E   24187.43243927 -.00000229  00000-0  00000-0 0  9997
2 13630   8.8533 307.2202 0014893 174.6567 234.7952  1.00395724114367
0 SATCOM C5
1 13631U 82105A   24187.45961405 -.00000120  00000-0  00000-0 0  9990
2 13631  12.9105 337.5022 0005417 105.4322 261.9928  1.00273365119241
0 DSCS 2-15
1 13636U 82106A   24187.15287102 -.00000147  00000-0  00000-0 0  9997
2 13636  13.1533 331.2804 0005180 178.3456  10.2519  0.95090860 97355
0 DSCS 3-1
1 13637U 82106B   24187.51587909 -.00000070  00000-0  00000-0 0  9991
2 13637  13.2093 338.3663 0021622 173.8472 186.7837  0.97827029 58352
0 TITAN 34D IUS R/B(2)
1 13643U 82106D   24186.92322300 -.00000095  00000-0  00000-0 0  9991
2 13643  10.7785 315.6152 0039855  53.5342 341.9007  0.99379060112687
0 COSMOS 1420
1 13648U 82109A   24187.35689447  .00000221  00000-0  88070-4 0  9992
2 13648  73.9944  49.3131 0020388 321.7626  38.2079 14.34327430177509
0 SL-8 R/B
1 13649U 82109B   24187.58927281  .00000439  00000-0  15405-3 0  9991
2 13649  74.0013 303.9728 0018774 218.7610 153.8921 14.37921195181364
0 SBS 3
1 13651U 82110B   24187.52473064 -.00000008  00000-0  00000-0 0  9990
2 13651  13.2587 339.4313 0010263 118.9924 259.4141  0.99920569 39430
0 ANIK C3 (TELESAT-5)
1 13652U 82110C   24187.15304507 -.00000030  00000-0  00000-0 0  9990
2 13652  13.2398 339.2397 0004113 135.0241  46.1049  0.99915136 39397
0 COSMOS 1412 FUEL CORE
1 13653U 82099E   24187.48836422 -.00000093  00000-0 -14200-5 0  9991
2 13653  64.8260 171.6088 0037633 194.1644 312.6096 13.90121001120499
0 SBS 3 R/B(PAM-D)
1 13658U 82110D   24187.49868577  .00002592  00000-0  22672-2 0  9990
2 13658  23.3076 254.9779 7093360 241.9943  31.0344  2.48236341284562
0 ANIK C3 R/B(PAM-D)
1 13666U 82110E   24187.40547879  .00000768  00000-0  13442-2 0  9997
2 13666  23.0057 222.8275 7051657 319.3161   5.3940  2.49752919319411
0 RADUGA 11
1 13669U 82113A   24187.18146230 -.00000141  00000-0  00000-0 0  9994
2 13669  10.6194 316.1223 0039481 272.9635  83.9315  0.97709824114578
0 METEOR 2-9
1 13718U 82116A   24187.63188083  .00000146  00000-0  66872-4 0  9991
2 13718  81.2512 326.0834 0053407 193.4169 166.5589 14.15708096145684
0 SL-3 R/B
1 13719U 82116B   24187.58473096  .00000178  00000-0  83721-4 0  9994
2 13719  81.2547 357.0903 0071014 204.7847 224.7424 14.14931050144497
0 SL-3 DEB
1 13720U 82116C   24187.42898193  .00000182  00000-0  85068-4 0  9999
2 13720  81.2504 324.8879 0055496 189.7518 226.0940 14.15776005145665
0 OPS 9845 (DMSP 5D-2 F6)
1 13736U 82118A   24187.48546544  .00000291  00000-0  12990-3 0  9998
2 13736  98.5913  12.9749 0006409 255.0351 105.0122 14.29912522163276
0 LES 8 9/SOL 11A B DEB *
1 13753U 76023K   24187.54984558 -.00000017  00000-0  00000-0 0  9996
2 13753   6.5936 288.9488 0001448  76.5797 265.1457  1.01339052115297
0 COSMOS 1428
1 13757U 83001A   24187.60122889  .00000087  00000-0  71944-4 0  9997
2 13757  82.9107 212.9714 0036074  74.2436  40.2157 13.76978910 83768
0 SL-8 R/B
1 13758U 83001B   24187.49880632  .00000200  00000-0  18082-3 0  9992
2 13758  82.9107 179.5738 0026267 318.3257  41.5899 13.79009902 86296
0 COSMOS 1429
1 13761U 83002A   24187.44516856  .00000001  00000-0  11542-3 0  9999
2 13761  74.0246  81.3854 0032614 109.3028  63.8441 12.43423092881925
0 COSMOS 1430
1 13762U 83002B   24187.62359538 -.00000020  00000-0 -28689-4 0  9996
2 13762  74.0254 355.8517 0020158  19.8361  48.9298 12.45709103885644
0 COSMOS 1431
1 13763U 83002C   24187.53561740  .00000001  00000-0  11507-3 0  9994
2 13763  74.0246 280.3948 0012009 263.5272 108.1001 12.47732917888422
0 COSMOS 1432
1 13764U 83002D   24187.48590907  .00000009  00000-0  16187-3 0  9993
2 13764  74.0213 200.7242 0002233  66.6255  87.8359 12.49871028891928
0 COSMOS 1433
1 13765U 83002E   24187.60052205 -.00000024  00000-0 -51678-4 0  9996
2 13765  74.0238 122.9040 0014092 317.8337 216.0379 12.51932476895059
0 COSMOS 1434
1 13766U 83002F   24187.36714402  .00000008  00000-0  14798-3 0  9995
2 13766  74.0246  52.8743 0023778 232.9013 300.6327 12.53804681897850
0 COSMOS 1435
1 13767U 83002G   24187.60809517 -.00000019  00000-0 -18015-4 0  9996
2 13767  74.0258 340.8549 0033908 154.4166 281.1041 12.55694562900411
0 COSMOS 1436
1 13768U 83002H   24187.58841638  .00000003  00000-0  11384-3 0  9996
2 13768  74.0238 264.0018 0043290  54.6046  54.7046 12.57722376903544
0 SL-8 R/B
1 13769U 83002J   24187.35034038 -.00000069  00000-0 -49702-3 0  9999
2 13769  74.0049 145.3032 0136059 350.2824 179.6004 12.21354269848820
0 SL-3 R/B
1 13771U 83003B   24187.60697363  .00007095  00000-0  31721-3 0  9993
2 13771  81.1646 267.2063 0038877  82.4890 278.0755 15.20472667262933
0 COSMOS 397 DEB *
1 13776U 71015CN  24187.37651701  .00002767  00000-0  15590-2 0  9994
2 13776  65.8608  53.5175 0488578  60.8586 109.5054 13.64666132 24703
0 IRAS
1 13777U 83004A   24187.49063332  .00000415  00000-0  30768-3 0  9999
2 13777  99.0064   5.1138 0018999 131.4241 228.8559 14.00620620786736
0 DELTA 1 R/B
1 13778U 83004B   24187.59144901  .00000223  00000-0  15869-3 0  9995
2 13778 100.0576 144.6618 0021646  49.8193 310.4864 14.09373058129479
0 SAKURA 2A (CS-2A)
1 13782U 83006A   24187.05252740  .00000050  00000-0  00000-0 0  9990
2 13782  11.4575 325.2450 0007013 301.0078  72.4115  0.99405767120771
0 IRAS DEB
1 13783U 83004C   24187.46955083  .00000170  00000-0  13339-3 0  9999
2 13783  98.9648   8.8018 0017559 127.1449 252.7286 14.04611174120013
0 OPS 0252
1 13791U 83008A   24187.18212491  .00006959  00000-0  67142-3 0  9992
2 13791  63.3022 108.3654 0773074 123.4970 244.2405 13.76507540  7804
0 SSD
1 13792U 83008B   24187.47265187  .00000509  00000-0  31502-3 0  9991
2 13792  63.3308 107.2097 0615496 132.0683 233.4422 13.46423254  7008
0 COSMOS 1275 DEB
1 13796U 81053GQ  24187.60151461  .00001052  00000-0  93838-3 0  9991
2 13796  83.0243 310.3521 0112297 339.1546  33.8279 13.80897371 84489
0 COSMOS 1275 DEB
1 13797U 81053GR  24187.34269146  .00000786  00000-0  67275-3 0  9992
2 13797  82.8375 132.9506 0053442 110.5981  15.8835 13.85101830104815
0 COSMOS 1275 DEB
1 13798U 81053GS  24187.31090239  .00001947  00000-0  18444-2 0  9998
2 13798  83.0091 271.9855 0079545 330.1038  29.5588 13.79176613144163
0 COSMOS 1275 DEB
1 13799U 81053GT  24187.36429359  .00001560  00000-0  15101-2 0  9991
2 13799  83.1353 147.4718 0089648 334.9292 179.0613 13.77414481 85913
0 COSMOS 1275 DEB
1 13800U 81053GU  24187.41012021  .00001923  00000-0  21604-2 0  9992
2 13800  83.2244 303.5996 0161696 172.1878 254.1933 13.64931098 56872
0 COSMOS 1275 DEB
1 13801U 81053GV  24187.53062971  .00003721  00000-0  19464-2 0  9994
2 13801  82.7980 202.5821 0045993 273.7570  85.8348 14.13604895118737
0 COSMOS 1275 DEB
1 13802U 81053GW  24187.28138977  .00000852  00000-0  82033-3 0  9992
2 13802  82.8013 263.0243 0062262  57.3442   6.1548 13.78115963127302
0 COSMOS 1275 DEB
1 13803U 81053GX  24187.46549881  .00003923  00000-0  23367-2 0  9999
2 13803  82.8144 327.1380 0054264 196.1354 227.7979 14.06382738112580
0 COSMOS 1275 DEB
1 13804U 81053GY  24187.19535064  .00006221  00000-0  27400-2 0  9994
2 13804  82.9478  91.4268 0047076  49.2254 102.2154 14.22697881118986
0 COSMOS 1275 DEB
1 13807U 81053HB  24187.57775412  .00003621  00000-0  15840-2 0  9998
2 13807  82.9522 241.0005 0015740  57.6373 302.6331 14.23490982878057
0 COSMOS 1275 DEB
1 13808U 81053HC  24187.42789396  .00002352  00000-0  18461-2 0  9991
2 13808  83.0339 155.5680 0063757  19.8892 102.4946 13.90587674 91223
0 COSMOS 1275 DEB
1 13809U 81053HD  24187.56823097  .00013725  00000-0  23900-2 0  9994
2 13809  82.8208 273.6729 0023458  22.7051  41.9958 14.67802012169627
0 COSMOS 1275 DEB
1 13810U 81053HE  24187.45508068  .00001220  00000-0  13875-2 0  9999
2 13810  83.0135 162.3332 0125433 172.6253 316.5351 13.66058214 58888
0 COSMOS 1275 DEB
1 13811U 81053HF  24187.17390388  .00002781  00000-0  15514-2 0  9998
2 13811  82.9368  71.0992 0015339  71.9225  85.4024 14.10524876113889
0 COSMOS 1275 DEB
1 13812U 81053HG  24187.04393458  .00006309  00000-0  26526-2 0  9991
2 13812  83.2525 202.6679 0037931   9.3135  19.5110 14.25308277123796
0 COSMOS 1275 DEB
1 13813U 81053HH  24187.12954351  .00003132  00000-0  17461-2 0  9995
2 13813  82.9383  76.1847 0046218  66.5902  87.0559 14.10114796113264
0 COSMOS 1275 DEB
1 13814U 81053HJ  24187.39302766  .00009890  00000-0  28667-2 0  9999
2 13814  82.9299 151.3960 0009085 163.5003 320.4880 14.44325329135408
0 COSMOS 1275 DEB
1 13815U 81053HK  24187.58796236  .00001723  00000-0  16031-2 0  9999
2 13815  83.0257  39.6559 0110310 280.3312 145.7963 13.78927444 71267
0 COSMOS 1275 DEB
1 13816U 81053HL  24187.60386854  .00001665  00000-0  13230-2 0  9997
2 13816  82.9838 246.8618 0166666  56.7901  66.9459 13.84401382 61643
0 COSMOS 1275 DEB
1 13817U 81053HM  24187.49948019  .00002113  00000-0  13202-2 0  9990
2 13817  82.9443 112.9849 0025568 311.0244  48.8718 14.04158232155936
0 SL-3 R/B
1 13819U 83010B   24187.57221451  .00008167  00000-0  30142-3 0  9998
2 13819  81.1100  21.8781 0024226   1.8639 358.2681 15.27346887263921
0 DELTA 1 DEB
1 13826U 78026FV  24187.52980592  .00006766  00000-0  11363-2 0  9996
2 13826  98.2360 178.2758 0034118 220.0268 139.8422 14.69604134197098
0 DELTA 1 DEB
1 13827U 78026FW  24187.46917718  .00002716  00000-0  60594-3 0  9992
2 13827  98.4069 181.2772 0067920 192.1420 329.5265 14.56252154176371
0 SSA
1 13844U 83008E   24187.47891974  .00004097  00000-0  44506-3 0  9992
2 13844  63.3007 178.0944 0794641 122.3268 245.7258 13.69312139261021
0 SSB
1 13845U 83008F   24187.42831358  .00004514  00000-0  49024-3 0  9992
2 13845  63.2999 169.9682 0790955 122.9508 245.0134 13.69942546247016
0 SSC
1 13874U 83008H   24187.43383441  .00004717  00000-0  46735-3 0  9991
2 13874  63.2972 162.0699 0794965 123.3960 244.5728 13.71701279253607
0 MOLNIYA 3-20
1 13875U 83015A   24186.62215487 -.00001020  00000-0 -64639-2 0  9992
2 13875  62.0608 238.9193 7182440 266.2828  16.8762  2.00756176238729
0 EKRAN 10
1 13878U 83016A   24186.74550676 -.00000104  00000-0  00000-0 0  9992
2 13878  11.8859 315.5316 0029235  13.0115 154.2138  0.95030537112401
0 SL-6 R/B(2)
1 13882U 83015E   24187.34199303 -.00000267  00000-0  27517-3 0  9994
2 13882  62.5808 326.0850 7465399 260.6173  16.5393  1.96839080296935
0 SL-6 R/B(2)
1 13897U 83019D   24186.78817275 -.00000122  00000-0  36728-3 0  9990
2 13897  62.7000 299.7308 7435725 272.7116  12.8484  1.97326246296578
0 SL-12 R/B(2)
1 13899U 82020F   24187.55520777 -.00000242  00000-0  00000-0 0  9991
2 13899   9.9165 306.1241 0029817 186.9499 142.5146  0.98638499113950
0 SL-12 R/B(2)
1 13900U 79015D   24187.53862308 -.00000167  00000-0  00000-0 0  9997
2 13900   6.1690 286.0156 0008531 294.8248  25.3403  1.01340652119830
0 ASTRON
1 13901U 83020A   24189.43592484 -.00000622  00000-0  00000-0 0  9991
2 13901  78.6759  65.1103 5088241  27.9368   0.7666  0.24287418  9423
0 TITAN 3C TRANSTAGE DEB
1 13906U 65108U   24187.21262104  .00000220  00000-0  16825-2 0  9997
2 13906  26.0560 216.0427 6759570  65.4620 358.7057  2.77725405323578
0 METEOSAT 1 AKM
1 13907U 77108D   24187.56476566 -.00000171  00000-0  00000-0 0  9990
2 13907   8.1457 289.5017 0090932 136.3226 221.9182  0.97801703105674
0 SL-6 DEB
1 13909U 81088J   24185.91798154 -.00000592  00000-0 -12196-1 0  9999
2 13909  63.6263 131.8712 4405343 288.2731 297.1497  5.75623249235807
0 SL-6 DEB
1 13911U 81088L   24180.89457519  .00005776  00000-0  18726-1 0  9993
2 13911  63.0852 270.2220 4564007 210.9820 111.6587  5.94330087 70908
0 OV2-3
1 13912U 65108V   24186.98801833  .00032094  00000-0  20650-2 0  9990
2 13912  26.5807 113.1627 5369427 333.3656   6.9496  5.07856687533571
0 COSMOS 1447
1 13916U 83021A   24187.49537640  .00000080  00000-0  67078-4 0  9994
2 13916  82.9454 166.7221 0038264  19.8054 102.8481 13.75234103 71257
0 SL-8 R/B
1 13917U 83021B   24187.57551545  .00000110  00000-0  95660-4 0  9996
2 13917  82.9439 133.1484 0027082 242.0605 292.5470 13.77003413 73738
0 NOAA 8
1 13923U 83022A   24187.55522669  .00000251  00000-0  11636-3 0  9993
2 13923  98.7298 187.5513 0014965 175.1030 185.0300 14.29269081149390
0 THOR ABLESTAR DEB
1 13942U 61015KZ  24187.54469058  .00000757  00000-0  17084-2 0  9996
2 13942  65.8622 118.7535 0394597 226.1370 312.7834 13.06603157975683
0 COSMOS 886 DEB *
1 13943U 76126BM  24187.14697523  .00004593  00000-0  19100-2 0  9995
2 13943  65.5799  89.9127 0080238 274.4921 204.3272 14.25579248 41315
0 COSMOS 839 DEB
1 13946U 76067BE  24187.01195699  .00000706  00000-0  22315-2 0  9999
2 13946  66.0630 188.1145 0657599 237.6210 149.5055 12.51210939883591
0 COSMOS 839 DEB
1 13947U 76067BF  24187.20909775  .00000038  00000-0  40380-3 0  9990
2 13947  65.7176 262.5299 0676137 313.1171  68.9365 12.24305429457139
0 COSMOS 970 DEB
1 13948U 77121BD  24187.46306677  .00001366  00000-0  12971-2 0  9992
2 13948  65.7619  75.2925 0069719 331.3660  81.5212 13.83128081204791
0 COSMOS 1448
1 13949U 83023A   24187.63278803  .00000092  00000-0  79080-4 0  9990
2 13949  82.9556 241.0118 0028643 315.3819 166.1842 13.76027436 71996
0 SL-8 R/B
1 13950U 83023B   24187.58948157  .00000105  00000-0  90548-4 0  9999
2 13950  82.9530 219.8269 0035693 256.9365 102.7807 13.77059219 73016
0 SL-12 R/B(2)
1 13954U 82113F   24186.74803041 -.00000103  00000-0  00000-0 0  9990
2 13954  10.6887 315.6666 0021964 265.1773 276.0401  0.97571162112934
0 TITAN 3C TRANSTAGE DEB
1 13957U 65108W   24187.17612698  .00000468  00000-0  26255-2 0  9997
2 13957  26.1621 180.3289 6757410  88.5439 354.9588  2.79528696367195
0 COSMOS 1285 DEB
1 13961U 81071F   24187.18912469 -.00000661  00000-0  00000-0 0  9993
2 13961  69.7610 113.1012 5943816 358.8558   0.1362  1.98119965308178
0 TDRS 1
1 13969U 83026B   24187.46329203 -.00000145  00000-0  00000-0 0  9999
2 13969   9.8650 323.7333 0019900 237.3223   4.5729  0.98743317123334
0 IUS R/B(2)
1 13970U 83026C   24187.51537134 -.00000125  00000-0  00000-0 0  9999
2 13970   3.4157  43.0855 1886161 189.8594  81.7736  1.32157037199147
0 IUS R/B(1)
1 13971U 83026D   24187.05445709  .00007655  00000-0  13421-2 0  9992
2 13971  25.9656  48.4182 5960827 203.7436 110.3738  4.10671038477860
0 RADUGA 12
1 13974U 83028A   24186.91577209  .00000003  00000-0  00000-0 0  9999
2 13974   9.6723 311.6349 0001894 145.2877 221.3099  1.00268675162242
0 SL-12 R/B(2)
1 13983U 83028F   24187.57063265  .00000032  00000-0  00000-0 0  9996
2 13983   9.7028 311.6929 0027163 200.4060 160.2692  1.00063020150693
0 SATCOM 1R
1 13984U 83030A   24186.31875997 -.00000296  00000-0  00000-0 0  9997
2 13984  13.8295 343.6976 0011221 124.1215 234.3678  0.99854252123357
0 COSMOS 1452
1 13991U 83031A   24187.44054920  .00000213  00000-0  86160-4 0  9999
2 13991  74.0487  63.6326 0016782 210.9061 322.2605 14.33529693154605
0 SL-8 R/B
1 13992U 83031B   24187.58442152  .00000388  00000-0  13995-3 0  9991
2 13992  74.0540 321.9915 0004855  13.9973 346.1314 14.36889777158275
0 COSMOS 1191 DEB
1 13999U 80057G   24186.03846269 -.00001121  00000-0  00000-0 0  9996
2 13999  64.8329  39.3001 7054897  29.2174 356.5283  2.01335101315698
0 SL-12 R/B(2)
1 14005U 79062D   24187.57241882 -.00000166  00000-0  00000-0 0  9997
2 14005   8.9906 299.3953 0005143 225.5717 131.4650  0.97672612114833
0 COSMOS 1455
1 14032U 83037A   24187.60254735  .00017561  00000-0  46280-3 0  9998
2 14032  82.5063  48.5551 0009259 286.0009  74.0215 15.38340280252589
0 SL-14 R/B
1 14033U 83037B   24187.21467766  .00000688  00000-0  77824-4 0  9997
2 14033  82.5069  88.6368 0015748 258.2445 101.7004 14.85008583840408
0 OPS 4682 DEB
1 14047U 65027J   24187.19152557  .00000109  00000-0  35645-3 0  9999
2 14047  90.2428 347.3366 0032651 177.6118 359.6375 12.96244226741753
0 OPS 4682 DEB
1 14048U 65027K   24187.44890355 -.00000064  00000-0 -24175-3 0  9991
2 14048  90.2385 358.8744 0014847   8.2241  20.0175 12.98816648961314
0 OPS 4682 DEB
1 14049U 65027L   24185.45242802  .00000385  00000-0  13593-2 0  9994
2 14049  90.2432 352.5549 0039461 256.9360 130.8474 12.94178865965926
0 GOES 6
1 14050U 83041A   24187.52197869  .00000000  00000-0  00000-0 0  9995
2 14050  11.3309 326.0469 0004204 176.8868 206.9981  1.00317063208885
0 DELTA 1 R/B(1)
1 14051U 83041B   24187.51407126  .00008048  00000-0  72329-3 0  9991
2 14051  25.3339  12.9823 1031739 186.5209 172.0836 13.23498637916984
0 COSMOS 1459
1 14057U 83042A   24187.53094763  .00000063  00000-0  47854-4 0  9994
2 14057  82.9738 346.3362 0049653  14.2383 346.0160 13.76710335 67819
0 SL-8 R/B
1 14059U 83042B   24187.62747853  .00000106  00000-0  89029-4 0  9999
2 14059  82.9730 309.8966 0041471 230.6931 129.0547 13.78946424 70375
0 COSMOS 1461
1 14064U 83044A   24187.45873416  .00009523  00000-0  58795-3 0  9990
2 14064  64.9941 199.2143 0057587 103.8724 256.8814 15.08987339108697
0 GOES 6 AKM
1 14069U 83041C   24186.91658117 -.00000229  00000-0  00000-0 0  9999
2 14069  17.1502 325.4791 1654134 104.4282 289.5568  0.84337467 33825
0 INTELSAT 506
1 14077U 83047A   24187.47225271  .00000034  00000-0  00000-0 0  9990
2 14077  13.2466 338.5182 0034456 336.5737 357.1540  0.99160564117025
0 COSMOS 1464
1 14084U 83048A   24187.56681145  .00000075  00000-0  63341-4 0  9991
2 14084  82.9454  11.9519 0029271 211.5070 208.3509 13.74588800 62171
0 SL-8 R/B
1 14085U 83048B   24187.55583847  .00000138  00000-0  12451-3 0  9996
2 14085  82.9447 338.0239 0034851 103.5299 256.9744 13.76467857 64643
0 SL-12 R/B(2)
1 14086U 83016F   24187.11492917  .00000048  00000-0  00000-0 0  9995
2 14086   8.2126 302.7530 0013609 300.8863  71.1581  1.01095813115779
0 DELTA 1 R/B
1 14096U 83051B   24187.31373047 -.00000257  00000-0 -39755-3 0  9995
2 14096  72.2956 156.2077 1093639 156.2701 209.2980 12.09845440815106
0 OPS 6432
1 14112U 83056A   24187.56479071  .00014718  00000-0  12401-2 0  9993
2 14112  63.3002 350.5761 0788036 119.9727 248.1921 13.76793062  9785
0 ATLAS H R/B
1 14113U 83056B   24187.32592128  .00000516  00000-0  74016-3 0  9999
2 14113  63.3399  35.2680 0139887 134.3597 226.8999 13.62096560249117
0 SL-12 R/B(2)
1 14114U 82044F   24187.54538542 -.00000281  00000-0  00000-0 0  9999
2 14114   9.8159 303.5358 0018827 180.5917 136.1521  1.00244255 40207
0 SL-12 R/B(2)
1 14115U 82093F   24186.91630880 -.00000224  00000-0  00000-0 0  9999
2 14115   8.0672 302.6634 0005604 272.8480 108.1807  1.01257914116640
0 SL-12 R/B(2)
1 14117U 82009F   24187.46550481 -.00000300  00000-0  00000-0 0  9992
2 14117   8.1095 300.2532 0041542 180.4627  88.3160  1.00983246116241
0 COSMOS 374 DEB
1 14122U 70089CW  24187.56428143  .00011193  00000-0  19247-2 0  9999
2 14122  62.8919 125.5282 0283894 283.0730  73.8798 14.45850138136336
0 EUTE 1-F1 (ECS 1)
1 14128U 83058A   24186.19342894 -.00000246  00000-0  00000-0 0  9994
2 14128  12.7510 334.5133 0013025 152.4833 207.6063  0.98872290 39666
0 OSCAR 10
1 14129U 83058B   24182.01151248 -.00000607  00000-0  00000-0 0  9994
2 14129  27.4309 337.0465 6034181 280.7676  20.3974  2.05870957280728
0 SL-6 DEB
1 14131U 81088M   24187.06285531  .00005199  00000-0  15767-1 0  9998
2 14131  62.9141 200.8447 3876937 323.5063  23.1678  7.05078108842417
0 NAHUEL I2 (ANIK C2)
1 14133U 83059B   24186.70497723 -.00000264  00000-0  00000-0 0  9990
2 14133  13.6123 341.2014 0040043 107.7926 252.6605  0.99126689 39084
0 PALAPA B1
1 14134U 83059C   24187.52301838 -.00000005  00000-0  00000-0 0  9996
2 14134  12.4917 334.4398 0005567 127.1265 250.9989  1.00143997113663
0 ANIK C2 R/B(PAM-D)
1 14135U 83059D   24187.01204191  .00002157  00000-0  18871-2 0  9991
2 14135  23.1872 100.0101 6941880 190.1053 140.6477  2.68037581302247
0 PALAPA B1 R/B(PAM-D)
1 14136U 83059E   24187.51990366  .00007890  00000-0  42418-2 0  9996
2 14136  25.8434  10.7755 6964283 103.6081 336.8423  2.66298423327851
0 OPS 3899
1 14139U 83060C   24187.42714392  .00000092  00000-0  40431-3 0  9995
2 14139  96.6602 348.9116 0001065  44.0635 316.0560 12.93928498243785
0 GB 1
1 14143U 83056C   24187.55898337  .00009608  00000-0  91859-3 0  9993
2 14143  63.3056  47.1765 0808592 119.2676 249.1656 13.69356542248766
0 GB 2
1 14144U 83056D   24187.33408420  .00008857  00000-0  86224-3 0  9995
2 14144  63.3065  50.2541 0807339 119.6472 248.7448 13.69153678258063
0 COSMOS 1470
1 14147U 83061A   24187.57684026  .00009126  00000-0  38502-3 0  9994
2 14147  82.4765  20.5814 0013063  24.1893 335.9954 15.23077913993930
0 SL-14 R/B
1 14148U 83061B   24187.60651061  .00000764  00000-0  87447-4 0  9994
2 14148  82.5181  16.4284 0022469 118.7687 241.5789 14.84521480195548
0 HILAT
1 14154U 83063A   24187.50513373  .00000644  00000-0  20819-3 0  9991
2 14154  82.0248 102.2672 0038695 287.2237 245.8958 14.37559194145282
0 SCOUT G-1 R/B
1 14155U 83063B   24187.60569558  .00000921  00000-0  27410-3 0  9991
2 14155  82.0220  49.2816 0038513 114.8869 305.2931 14.41913283148775
0 GALAXY 1
1 14158U 83065A   24187.39702169 -.00000248  00000-0  00000-0 0  9995
2 14158  14.1105 346.9674 0002945 156.3146 205.0831  1.00112663 39504
0 GORIZONT 7
1 14160U 83066A   24187.41747219 -.00000001  00000-0  00000-0 0  9994
2 14160  10.7098 317.3689 0010039 328.9227  48.7690  0.98346737147757
0 COSMOS 1473
1 14171U 83069A   24187.63164331  .00000019  00000-0  20495-3 0  9992
2 14171  74.0234 230.6289 0044545 259.8825 221.5244 12.58747950883992
0 COSMOS 1474
1 14172U 83069B   24187.48883424 -.00000015  00000-0  92814-5 0  9990
2 14172  74.0274 309.5888 0033317 357.6266  73.3324 12.56657149880873
0 COSMOS 1475
1 14173U 83069C   24187.56689604  .00000005  00000-0  12834-3 0  9994
2 14173  74.0264  28.0165 0021506  81.4793 338.8500 12.54562689877972
0 COSMOS 1476
1 14174U 83069D   24187.52530326 -.00000007  00000-0  55667-4 0  9992
2 14174  74.0258 103.7810 0010922 170.4545   2.5343 12.52526495874697
0 COSMOS 1477
1 14175U 83069E   24187.43540904 -.00000009  00000-0  43002-4 0  9998
2 14175  74.0233 181.6724 0002022 177.0524 350.9912 12.50440114871614
0 COSMOS 1478
1 14176U 83069F   24187.58068515  .00000013  00000-0  19689-3 0  9995
2 14176  74.0252 262.5121 0011700 155.4848 315.6109 12.48246333868344
0 COSMOS 1479
1 14177U 83069G   24187.61047104 -.00000022  00000-0 -42989-4 0  9993
2 14177  74.0273 341.9975 0023741 262.7406 172.9225 12.46087551865069
0 COSMOS 1480
1 14178U 83069H   24187.40265755  .00000004  00000-0  13812-3 0  9995
2 14178  74.0262  70.9104 0036094 351.3573 184.7881 12.43685443861444
0 SL-8 R/B
1 14179U 83069J   24187.56396812  .00000012  00000-0  23143-3 0  9999
2 14179  74.0239 344.1291 0130728  10.9754  53.7277 12.26102281835068
0 GB 3
1 14180U 83056G   24187.57609477  .00010791  00000-0  92769-3 0  9997
2 14180  63.3026  43.6103 0813162 119.0506 249.4470 13.71273982260940
0 COSMOS 1481
1 14182U 83070A   24186.07766174  .00000638  00000-0  00000-0 0  9990
2 14182  71.2963 288.4217 5634131 257.1197  37.4559  2.03567953225588
0 OPS 9794 (NAVSTAR 8)
1 14189U 83072A   24187.26924383 -.00000048  00000-0  00000-0 0  9995
2 14189  62.9481  89.3781 0208427  53.2962 120.6064  1.91719533213072
0 ATLAS 75E R/B
1 14190U 83072B   24187.29485813 -.00000019  00000-0  11488-2 0  9992
2 14190  63.8452 147.2428 5614967 342.5370   4.0199  3.86839727579170
0 SL-6 R/B(2)
1 14191U 83070D   24184.28681150 -.00000794  00000-0  00000-0 0  9995
2 14191  71.0734 291.6121 5786034 275.7363  24.7321  2.03396420224958
0 COSMOS 1481 DEB
1 14192U 83070E   24186.35452899 -.00000667  00000-0  00000-0 0  9991
2 14192  70.8169 271.9760 5686879 263.6505 132.0110  2.03144953225141
0 SL-12 R/B(2)
1 14193U 80060F   24187.50260249  .00000011  00000-0  00000-0 0  9994
2 14193   6.8588 291.2313 0017242 267.9209 113.1809  1.01607144 40772
0 SL-12 R/B(2)
1 14194U 81027F   24187.51305492 -.00000052  00000-0  00000-0 0  9996
2 14194   9.7168 303.2759 0019654 195.8341 195.4386  0.97663332113164
0 SL-12 R/B(2)
1 14195U 81102F   24187.06471792 -.00000057  00000-0  00000-0 0  9993
2 14195   8.2719 300.6801 0011706 199.8863 160.2223  1.00223706115864
0 SL-3 R/B
1 14208U 83075B   24187.53240126  .00006722  00000-0  29518-3 0  9998
2 14208  97.5690 166.9408 0029418 231.9372 127.9209 15.21882170236521
0 SL-3 DEB
1 14209U 83075C   24187.50486066  .00008824  00000-0  30726-3 0  9999
2 14209  97.1541 178.8515 0022929 106.6550 253.7211 15.29643269244678
0 SCOUT G-1 DEB
1 14222U 83063C   24187.51799850  .00003508  00000-0  61586-3 0  9992
2 14222  82.3722 308.9257 0017633   7.6994 352.4479 14.67398644172664
0 SCOUT G-1 DEB
1 14223U 83063D   24187.08575398  .00001071  00000-0  33271-3 0  9997
2 14223  81.6522 226.6763 0055257 106.0749 283.8987 14.39502356142876
0 COSMOS 1275 DEB
1 14228U 81053HN  24186.62217597  .00002018  00000-0  18102-2 0  9999
2 14228  82.9672 250.6850 0097698 158.4881 354.3265 13.81621413 70794
0 SL-3 DEB
1 14229U 83075D   24187.46706947  .00002647  00000-0  19669-3 0  9999
2 14229  97.8175 157.6321 0030202 218.9378 271.3328 15.03556825224214
0 ARABSAT 1DR (TELSTAR 3A)
1 14234U 83077A   24186.95166531 -.00000036  00000-0  00000-0 0  9996
2 14234  14.2906 347.2056 0029388 151.2012 208.9733  0.99519485 39258
0 COSMOS 1486
1 14240U 83079A   24187.60826962  .00000222  00000-0  87986-4 0  9997
2 14240  74.0575 272.8551 0013808   2.3632 103.8384 14.34392720139709
0 SL-8 R/B
1 14241U 83079B   24187.49330533  .00000279  00000-0  10290-3 0  9994
2 14241  74.0571 202.0997 0017362 348.4894  11.5859 14.36866272142254
0 SAKURA 2B (CS-2B)
1 14248U 83081A   24187.51446293  .00000016  00000-0  00000-0 0  9992
2 14248  12.1607 329.2240 0004046 107.8618 259.2401  0.98811365116658
0 COSMOS 1490 (GLONASS)
1 14258U 83084A   24185.50672825 -.00000051  00000-0  00000-0 0  9995
2 14258  64.4704  97.3447 0015058  12.0856 168.4901  2.13103241318235
0 COSMOS 1491 (GLONASS)
1 14259U 83084B   24184.30239082 -.00000057  00000-0  00000-0 0  9993
2 14259  64.5744  83.2586 0020012 308.7067 232.9001  2.15434865320731
0 COSMOS 1492 (GLONASS)
1 14260U 83084C   24187.44440647 -.00000037  00000-0  00000-0 0  9992
2 14260  64.4401  98.9569 0001179   0.1871 173.4012  2.12759131316431
0 SL-12 R/B(2)
1 14264U 83084F   24187.39077244 -.00000038  00000-0  00000-0 0  9990
2 14264  64.4515  98.0431 0009020 212.6762 332.3272  2.12927283318073
0 SL-12 R/B(AUX MOTOR)
1 14277U 83084G   24187.14809019  .00003834  00000-0  20399-2 0  9991
2 14277  51.8984 126.0492 5391840 165.9883 218.6742  4.89906072684623
0 SL-12 R/B(AUX MOTOR)
1 14278U 83084H   24186.39424602  .00006732  00000-0  14309-2 0  9993
2 14278  52.0365 215.8767 5293109 289.5110  22.2574  5.12334105698409
0 RADUGA 13
1 14307U 83088A   24187.52315480 -.00000106  00000-0  00000-0 0  9990
2 14307  10.9055 317.5845 0015805  60.0267 209.9037  0.98174062111954
0 INSAT 1B
1 14318U 83089B   24187.05000374  .00000111  00000-0  00000-0 0  9999
2 14318  12.1475 331.9281 0012878 201.2728 151.5047  1.00314817118068
0 SATCOM 2R
1 14328U 83094A   24187.51565175  .00000061  00000-0  00000-0 0  9996
2 14328  14.6838 351.2343 0016747  74.0479 273.6688  0.99407941148474
0 SL-12 R/B(2)
1 14333U 83088F   24187.45940581 -.00000039  00000-0  00000-0 0  9992
2 14333  11.1977 318.3440 0017523 135.0710 250.7715  0.97614188109382
0 SL-8 DEB *
1 14344U 82037C   24187.53885649  .00002416  00000-0  64024-3 0  9998
2 14344  74.0586  99.6971 0015713  21.8643  33.5730 14.49215633145683
0 SL-8 DEB *
1 14345U 79089C   24187.63266042  .00005099  00000-0  81832-3 0  9999
2 14345  74.0221 271.4311 0007040 123.0108 354.3399 14.71900983173739
0 SL-8 DEB
1 14346U 81041D   24187.42384241  .00008311  00000-0  99538-3 0  9992
2 14346  74.0357 169.6326 0004525 120.9670   4.8729 14.84230023188318
0 COSMOS 1275 DEB
1 14357U 81053HQ  24187.06422458  .00002550  00000-0  13549-2 0  9996
2 14357  82.8467 203.3235 0041435 359.7411  61.1887 14.12765105103021
0 COSMOS 1275 DEB
1 14358U 81053HR  24187.41212647  .00007541  00000-0  41756-2 0  9999
2 14358  82.8139 163.6987 0179474 345.5819 135.5605 14.03367354 82798
0 COSMOS 1275 DEB
1 14364U 81053HX  24187.11992620  .00004436  00000-0  22008-2 0  9998
2 14364  82.7823 138.2361 0027617 202.3710 157.6267 14.16790996126412
0 GALAXY 2
1 14365U 83098A   24187.05396527  .00000107  00000-0  00000-0 0  9994
2 14365  14.1131 347.2877 0007711 111.3654 248.4457  1.00159327125096
0 COSMOS 1500
1 14372U 83099A   24187.55285809  .00023447  00000-0  56695-3 0  9994
2 14372  82.5082 301.9719 0009012  81.8688 278.3580 15.40965106229053
0 SL-14 R/B
1 14373U 83099B   24187.51798993  .00000746  00000-0  84356-4 0  9997
2 14373  82.5398 356.5987 0019944   9.0283 351.1287 14.85028859181723
0 EKRAN 11
1 14377U 83100A   24186.80954776 -.00000262  00000-0  00000-0 0  9992
2 14377   9.2779 309.8307 0001568 223.5099 136.5922  1.00232667 40232
0 SL-12 R/B(2)
1 14394U 83100F   24187.51835911 -.00000323  00000-0  00000-0 0  9997
2 14394   8.7717 307.9771 0021776 146.7294 125.6299  1.01052965149820
0 SL-8 DEB *
1 14398U 82051C   24187.55962220  .00002962  00000-0  67285-3 0  9994
2 14398  74.0463 359.5251 0002600 310.8277 113.7030 14.56451947249632
0 COSMOS 1503
1 14401U 83103A   24187.56584553  .00000233  00000-0  95053-4 0  9992
2 14401  74.0455 332.9171 0014203 268.7619  91.1905 14.32677144127556
0 SL-8 R/B
1 14402U 83103B   24187.47775711  .00000298  00000-0  10969-3 0  9994
2 14402  74.0432 207.9117 0025645 137.1363 223.1796 14.36690905131699
0 COSMOS 1275 DEB
1 14405U 81053JA  24187.48695809  .00001085  00000-0  98774-3 0  9994
2 14405  83.2654 257.1444 0070993 169.6774 251.5022 13.81355542146813
0 COSMOS 1275 DEB
1 14406U 81053JB  24187.20255980  .00003228  00000-0  16595-2 0  9998
2 14406  82.8387 240.8313 0024417 173.7943 249.6458 14.14870186120838
0 COSMOS 1275 DEB
1 14407U 81053JC  24187.54488100  .00003581  00000-0  18114-2 0  9999
2 14407  82.7695 110.9993 0041853 224.6639 135.1166 14.15470095120934
0 COSMOS 1275 DEB
1 14408U 81053JD  24186.41443814  .00001590  00000-0  16836-2 0  9995
2 14408  82.9628 336.9202 0115664 209.2011 179.5779 13.71022743605700
0 COSMOS 1275 DEB
1 14409U 81053JE  24187.33342881  .00001373  00000-0  14860-2 0  9994
2 14409  83.0289 132.8762 0122448 323.9584 190.6994 13.69308415199775
0 COSMOS 249 DEB
1 14410U 68091CL  24187.42629972  .00011964  00000-0  47125-2 0  9999
2 14410  62.2057 182.8572 0428879  95.9455  50.3730 13.89189659  4205
0 COSMOS 249 DEB
1 14412U 68091CN  24186.88193849  .00002623  00000-0  32704-2 0  9998
2 14412  62.2944 351.6496 0764022 181.0906 178.8445 12.81966537996987
0 INTELSAT 507
1 14421U 83105A   24186.91229050 -.00000065  00000-0  00000-0 0  9990
2 14421  12.8310 336.0579 0007408 121.0164 237.4168  0.99688476130121
0 COSMOS 249 DEB
1 14430U 68091CV  24187.16955508  .00001412  00000-0  17285-2 0  9990
2 14430  62.2409 242.7461 0686998  19.3026  15.5396 12.97038606  8313
0 COSMOS 1275 DEB
1 14440U 81053JG  24187.45327446  .00001130  00000-0  13605-2 0  9999
2 14440  82.9217 355.5400 0116191 197.9485 191.3005 13.63063703116557
0 COSMOS 1275 DEB
1 14441U 81053JH  24187.46331909  .00004396  00000-0  25884-2 0  9999
2 14441  83.1147  99.8199 0041486 284.1532  75.5034 14.07337698172746
0 COSMOS 970 DEB
1 14442U 77121BE  24187.19007737  .00002893  00000-0  28133-2 0  9990
2 14442  65.3697 118.6564 0023630 281.8148 190.3438 13.80921946303287
0 COSMOS 970 DEB
1 14443U 77121BF  24187.42849007  .00004399  00000-0  98437-3 0  9999
2 14443  65.5795 198.2175 0113933 182.8878 177.1580 14.53784873232095
0 COSMOS 970 DEB
1 14444U 77121BG  24186.93470362  .00001432  00000-0  15546-2 0  9993
2 14444  65.7966 173.6724 0064012 303.0091  81.7383 13.75210950138462
0 COSMOS 970 DEB
1 14445U 77121BH  24186.90752463  .00010944  00000-0  36433-2 0  9992
2 14445  66.4748  10.5874 0088373 245.2077 113.9810 14.35687962 88736
0 COSMOS 397 DEB *
1 14446U 71015CQ  24186.96844447  .00000731  00000-0  10140-2 0  9999
2 14446  65.5706 257.6248 0046920  82.0331  92.7750 13.63762010547232
0 COSMOS 1506
1 14450U 83108A   24187.59180208  .00000096  00000-0  82385-4 0  9994
2 14450  82.9301  80.9830 0042508 189.0619 225.9908 13.76416314859766
0 SL-8 R/B
1 14451U 83108B   24187.61193085  .00000155  00000-0  13838-3 0  9997
2 14451  82.9280  49.6204 0033547  65.8502 294.6157 13.78213110 45650
0 METEOR 2-10
1 14452U 83109A   24187.60432659  .00000302  00000-0  11354-3 0  9996
2 14452  81.1617 356.1428 0091053 108.8022 252.3062 14.26905484115921
0 SL-3 R/B
1 14453U 83109B   24187.56606440  .00000225  00000-0  85352-4 0  9997
2 14453  81.1656  34.9818 0104269 171.4311 188.8681 14.25108088114259
0 SL-3 DEB
1 14454U 83109C   24187.52463366  .00000264  00000-0  99973-4 0  9999
2 14454  81.1624   4.3380 0095651 127.6151 290.1187 14.26073955115523
0 DELTA 1 DEB
1 14458U 78026FY  24187.33157560  .00000253  00000-0  17711-3 0  9997
2 14458  98.8772 130.9575 0068530 298.3557 215.9116 14.06115302110657
0 DELTA 1 DEB
1 14460U 78026GA  24187.44663108  .00000395  00000-0  48113-3 0  9999
2 14460  98.7605 168.4092 0258037 101.4060  49.7411 13.57846973 41452
0 DELTA 1 DEB
1 14461U 78026GB  24187.10108223  .00002108  00000-0  90008-3 0  9999
2 14461  99.2102 246.0032 0091592  10.4516  19.1320 14.23944499218940
0 DELTA 1 DEB
1 14463U 78026GD  24187.12676000  .00001623  00000-0  80232-3 0  9995
2 14463  98.9411  69.8887 0123535 249.5533 270.5616 14.14908628197117
0 DELTA 1 DEB
1 14464U 78026GE  24187.51290887  .00000127  00000-0  13002-3 0  9993
2 14464  99.4947  25.9006 0059948 291.6111  96.8754 13.93999842121562
0 DELTA 1 DEB
1 14465U 78026GF  24187.38283891  .00003976  00000-0  20907-2 0  9992
2 14465  98.7200 348.5602 0116693 108.6268 311.4406 14.11151578118196
0 THORAD AGENA D DEB
1 14466U 70025NS  24187.40082873  .00006901  00000-0  20234-2 0  9998
2 14466  99.9760 234.7506 0060133 186.5870 173.4531 14.43196366209073
0 THORAD AGENA D DEB
1 14467U 70025NT  24185.02531512  .00000510  00000-0  70421-3 0  9998
2 14467 100.1198  29.2483 0002670  22.8386 134.1150 13.63789378 64411
0 THORAD AGENA D DEB
1 14469U 70025NV  24186.53101546  .00000452  00000-0  12742-2 0  9993
2 14469 101.6567  46.8744 0269076 239.3992 147.5427 13.06969763 52795
0 DELTA 1 DEB
1 14470U 73086GP  24186.82414331  .00000417  00000-0  19013-2 0  9995
2 14470 101.7916  42.9984 0111070 209.6185 161.9951 12.83568763940240
0 DELTA 1 DEB
1 14471U 76077EN  24187.48573244  .00000135  00000-0  15728-2 0  9997
2 14471 102.3651 154.8728 0132306  57.9610  63.0430 12.25310500852049
0 DELTA 1 DEB
1 14472U 76077EP  24187.40571295 -.00000017  00000-0  28050-3 0  9997
2 14472 102.7370 160.6175 0155794  13.5622 141.3012 12.16327431846747
0 DELTA 1 DEB
1 14473U 73086GQ  24187.22780162  .00002895  00000-0  20283-1 0  9993
2 14473 102.6071 273.3521 0223164 247.5537 133.7985 12.39747367846498
0 THORAD DELTA 1 DEB
1 14474U 74089EQ  24186.74416943  .00000067  00000-0  10295-2 0  9999
2 14474 100.6597 189.5013 0276920 310.0662 226.6135 12.07646285834417
0 THORAD DELTA 1 DEB
1 14475U 74089ER  24187.45833459  .00000476  00000-0  29104-2 0  9997
2 14475 101.0242  10.0002 0130641 176.5580 212.9719 12.59331441892387
0 THORAD AGENA D DEB
1 14478U 70025NW  24186.84721529  .00007223  00000-0  25292-1 0  9992
2 14478 100.9255  28.0097 0528119  70.3546 295.3729 12.58104738519129
0 DELTA 1 DEB
1 14480U 73086GR  24187.35168318  .00020961  00000-0  22774-1 0  9999
2 14480 102.6856 119.0618 0128249 335.5992 144.1210 13.69355988959930
0 COSMOS 1508
1 14483U 83111A   24187.51194411  .00008040  00000-0  54145-3 0  9996
2 14483  82.9031  91.9340 0707507  42.4844 322.8902 13.98811862 21447
0 DELTA 1 DEB
1 14493U 77065FJ  24187.27234162  .00002488  00000-0  47930-3 0  9993
2 14493  28.9465 153.1270 0590060 144.6263 219.4948 13.87136343133005
0 DELTA 1 DEB
1 14496U 77065FM  24187.50128228  .00032760  00000-0  55446-2 0  9993
2 14496  29.1424 315.8588 0178507  10.5963  54.4861 14.58215298136988
0 DELTA 1 DEB
1 14497U 77065FN  24186.21774287  .00001694  00000-0  55893-2 0  9991
2 14497  29.3012 349.2219 0889032 249.8343 286.2175 12.06805497894810
0 COSMOS 886 DEB
1 14501U 76126BN  24187.59344157  .00042355  00000-0  45016-2 0  9990
2 14501  65.6858   4.5559 0281635 148.5410 213.2892 14.63858757 58775
0 COSMOS 886 DEB
1 14502U 76126BP  24187.10833076  .00006217  00000-0  20350-2 0  9992
2 14502  65.7814  66.2523 0748301  10.3534 155.4752 13.41361980 62236
0 COSMOS 886 DEB
1 14503U 76126BQ  24187.39244791  .00001124  00000-0  17468-2 0  9992
2 14503  65.8608 330.6134 1002788 162.4364 201.4124 12.31320129485735
0 COSMOS 1275 DEB
1 14504U 81053JJ  24187.37973146  .00002560  00000-0  15796-2 0  9996
2 14504  83.1951 150.7404 0028069  18.3295 135.3092 14.04847776182414
0 OPS 1294 (DMSP 5D-2 F7)
1 14506U 83113A   24187.42406431  .00000441  00000-0  19058-3 0  9993
2 14506  98.3323 349.0276 0011244 167.8402 246.3750 14.28957203113808
0 DELTA 1 DEB
1 14509U 76077EQ  24187.52544726  .00000061  00000-0  10548-2 0  9990
2 14509 102.2663 170.1626 0160414  45.9146  75.3337 12.12258766846409
0 DELTA 1 DEB
1 14510U 76077ER  24187.37070644 -.00000406  00000-0 -42311-2 0  9996
2 14510 102.3528 144.3314 0222443 336.2304 177.4080 11.99422408842407
0 COSMOS 970 DEB
1 14511U 77121BJ  24187.22077604  .00000077  00000-0  34481-3 0  9997
2 14511  64.6806 347.2944 0165276 304.4223 231.0438 13.22098675 14382
0 TANSEI 3 DEB
1 14512U 77012K   24186.69713313  .00000019  00000-0  15375-3 0  9998
2 14512  65.7506  27.1499 1710963  98.5819 281.1823 10.76795906 23193
0 OPS 4682 DEB
1 14515U 65027M   24186.89630534  .00000366  00000-0  12428-2 0  9999
2 14515  90.2427 352.2121 0029560 143.5270 216.7872 12.96965445491965
0 COSMOS 1510
1 14521U 83115A   24187.50552693 -.00000010  00000-0  57369-4 0  9994
2 14521  73.6148 184.4928 0028443 270.7334 243.8723 12.41186488840731
0 SL-14 R/B
1 14522U 83115B   24187.55988163 -.00000029  00000-0 -82883-4 0  9995
2 14522  73.6157 167.1496 0026700 257.0750 241.2043 12.41586473840874
0 INSAT 1B R/B(PAM-D)
1 14524U 83089C   24187.39153846  .00010485  00000-0  22238-2 0  9992
2 14524  24.3991 111.7976 5936665 324.9722   7.5626  4.13219918465523
0 GORIZONT 8
1 14532U 83118A   24187.17972185 -.00000153  00000-0  00000-0 0  9998
2 14532  10.9248 319.3457 0029856 167.4954 177.0865  0.98270836113506
0 COSMOS 1513
1 14546U 83120A   24187.61628072  .00000083  00000-0  71530-4 0  9999
2 14546  82.9382  39.3990 0039932  81.2837 341.0817 13.74353068 34564
0 SL-8 R/B
1 14547U 83120B   24187.51954583  .00000061  00000-0  45965-4 0  9997
2 14547  82.9326 334.2439 0045901 217.0252 142.7735 13.77292210794664
0 SL-12 R/B(2)
1 14548U 83118F   24186.89771618  .00000048  00000-0  00000-0 0  9993
2 14548   9.9221 315.8903 0044177 327.5560  22.8234  1.00255798130751
0 COSMOS 1515
1 14551U 83122A   24187.34319827  .00019395  00000-0  51305-3 0  9995
2 14551  82.4925 131.3537 0002499 357.8758   2.2475 15.38266971960955
0 SL-14 R/B
1 14552U 83122B   24187.54265446  .00000727  00000-0  82944-4 0  9998
2 14552  82.5230 184.5902 0015489 307.3944  52.5860 14.84702586169967
0 COSMOS 1275 DEB
1 14556U 81053JL  24187.58855443  .00001539  00000-0  16755-2 0  9996
2 14556  83.0133 135.2953 0132963 125.0319   1.2534 13.68379652 14677
0 COSMOS 1275 DEB
1 14557U 81053JM  24186.52440409  .00004639  00000-0  21326-2 0  9996
2 14557  82.7940 195.0661 0040425 252.7229 231.9341 14.20587768178148
0 COSMOS 1275 DEB
1 14558U 81053JN  24187.62733356  .00004902  00000-0  19547-2 0  9990
2 14558  82.9231 232.0393 0016634 226.1700 258.4649 14.28318476191564
0 DELTA 1 DEB
1 14559U 78026GG  24158.10685204  .05470379  51762-1  14752-1 0  9990
2 14559  98.9618 289.8056 0030599 290.7592  69.0402 15.98332018235174
0 DELTA 1 DEB
1 14563U 77065FP  24187.32223341  .00009292  00000-0  14415-2 0  9995
2 14563  29.1648  49.5726 0461762  72.7891 292.2691 14.19363459685896
0 DELTA 1 DEB
1 14564U 77065FQ  24187.05116956  .00012053  00000-0  11021-1 0  9997
2 14564  28.6995 323.7415 0762042 177.4337 183.0421 12.94805321978434
0 DELTA 1 DEB
1 14565U 77065FR  24187.19823016  .00001413  00000-0  23489-2 0  9995
2 14565  29.2050 144.3859 0863585  98.6399 271.2823 12.47583767952915
0 SL-8 DEB
1 14568U 83001C   24187.28724052  .00006965  00000-0  24884-2 0  9992
2 14568  82.8946  15.1791 0019915 169.4516 190.7095 14.33897916195135
0 N-1 DEB
1 14569U 82087D   24187.24769900 -.00000078  00000-0  50591-4 0  9999
2 14569  44.8414 126.2782 0122553  11.3824 135.4506 13.55780167107800
0 COSMOS 1519 (GLONASS)
1 14590U 83127A   24187.58924375 -.00000081  00000-0  00000-0 0  9995
2 14590  66.6469 352.3039 0011452 178.1539 189.2148  2.13099486255984
0 COSMOS 1520 (GLONASS)
1 14591U 83127B   24187.52612441 -.00000081  00000-0  00000-0 0  9998
2 14591  66.6391 352.1961 0023423 171.9358 193.4986  2.13102239255799
0 COSMOS 1521 (GLONASS)
1 14592U 83127C   24183.89924905 -.00000065  00000-0  00000-0 0  9998
2 14592  66.5625 348.3433 0060609 193.4583 165.7786  2.13837130316294
0 SL-12 R/B(2)
1 14595U 83127F   24184.89738350 -.00000072  00000-0  00000-0 0  9997
2 14595  66.5353 347.5280 0066264 190.4519 179.6566  2.13938018256116
0 SL-12 R/B(AUX MOTOR)
1 14607U 83127G   24187.26061893  .00002508  00000-0  12828-2 0  9994
2 14607  51.9488 148.8179 5590873 102.1128 322.7755  4.59251947658371
0 SL-12 R/B(AUX MOTOR)
1 14608U 83127H   24186.00817990  .00001492  00000-0  75709-3 0  9992
2 14608  51.6035  88.1796 5410518 243.1516  52.4880  4.88161210603531
0 COSMOS 1522
1 14611U 84001A   24187.54842157 -.00000004  00000-0  79332-4 0  9997
2 14611  74.0089 284.3025 0019677 164.4243 208.0329 12.47048844843653
0 COSMOS 1523
1 14612U 84001B   24187.52147367  .00000014  00000-0  18055-3 0  9991
2 14612  74.0023 215.3671 0042060 218.9011 295.7498 12.58638012860746
0 COSMOS 1524
1 14613U 84001C   24187.57610130 -.00000002  00000-0  88974-4 0  9996
2 14613  74.0094 288.6855 0032385 306.1448  65.0203 12.56727936857903
0 COSMOS 1525
1 14614U 84001D   24187.57223769 -.00000013  00000-0  17345-4 0  9991
2 14614  74.0097 356.6789 0021774  17.5698  50.7712 12.54892846855173
0 COSMOS 1526
1 14615U 84001E   24187.09797809  .00000011  00000-0  16823-3 0  9996
2 14615  74.0086  65.5242 0011712 100.3981  11.7025 12.53037381852387
0 COSMOS 1527
1 14616U 84001F   24187.33183806 -.00000025  00000-0 -60084-4 0  9996
2 14616  74.0076 137.2255 0001481 159.9955 353.7999 12.51086956438346
0 COSMOS 1528
1 14617U 84001G   24187.52944028  .00000014  00000-0  19715-3 0  9999
2 14617  74.0053 212.4988 0009582  52.8002  58.9202 12.49021205846566
0 COSMOS 1529
1 14618U 84001H   24187.61059207 -.00000012  00000-0  28852-4 0  9998
2 14618  74.0096   4.6206 0031948 242.7503 181.8200 12.44851168667003
0 SL-8 R/B
1 14619U 84001J   24187.59322319 -.00000069  00000-0 -47874-3 0  9990
2 14619  73.9982 347.6076 0127767 355.9033  69.4442 12.24830351810908
0 DELTA 1 DEB
1 14620U 81070J   24187.51278819  .00001687  00000-0  44598-2 0  9996
2 14620  90.4801  33.6253 6013022  58.6524 346.7042  3.83430694493623
0 DELTA 1 DEB
1 14621U 81070K   24187.30757757  .00001656  00000-0  54963-2 0  9990
2 14621  90.4998  34.5966 6031538 131.1831 299.2555  3.78635589450091
0 COSMOS 1531
1 14624U 84003A   24187.59146353  .00000076  00000-0  67079-4 0  9996
2 14624  82.9329 303.0894 0018311 286.7264  83.6493 13.72307482 26893
0 SL-8 R/B
1 14625U 84003B   24187.61251937  .00000123  00000-0  11359-3 0  9997
2 14625  82.9252 256.8785 0023031 110.7752 359.1114 13.74536124 29822
0 COSMOS 1275 DEB
1 14627U 81053JQ  24187.45742270  .00001951  00000-0  12298-2 0  9990
2 14627  82.7814 253.8311 0037149 285.2608  87.9911 14.03469881 61411
0 SL-3 DEB
1 14631U 83075E   24187.59668859  .00328933  48510-4  60801-3 0  9994
2 14631  97.7747 223.4801 0003844 195.9413 164.1744 16.01172337235838
0 SL-3 DEB
1 14632U 77002E   24187.33018395  .00000038  00000-0  16767-4 0  9998
2 14632  81.2762 142.5940 0053599 110.7164   6.3805 14.00645404248813
0 YURI 2A (BS-2A)
1 14659U 84005A   24187.52315507 -.00000199  00000-0  00000-0 0  9992
2 14659  12.1173 329.4120 0020560 192.8281  64.8591  0.99050696111265
0 STTW-T1
1 14670U 84008A   24187.31318929  .00002216  00000-0  10245-2 0  9991
2 14670  36.1217 130.1641 2988715 358.0491   1.0347  9.01327830319748
0 OPS 0441
1 14675U 84009A   24187.30882742 -.00000353  00000-0  00000-0 0  9992
2 14675   6.0197 357.9500 0864957  16.8337 332.6389  1.00242733   606
0 TITAN 34D TRANSTAGE R/B
1 14677U 84009C   24186.71048766 -.00000073  00000-0  00000-0 0  9997
2 14677   6.1317 355.3632 1052828  97.8554 274.3445  0.99450568 18785
0 COSMOS 1535
1 14679U 84010A   24187.51188677  .00000057  00000-0  42959-4 0  9990
2 14679  82.9593 321.1801 0042569 160.5778 273.5017 13.75315695997051
0 SL-8 R/B
1 14680U 84010B   24187.53449991  .00000074  00000-0  59612-4 0  9996
2 14680  82.9578 292.2070 0038828  51.7857 319.0823 13.76611431 30118
0 OPS 8737
1 14690U 84012A   24187.27887003  .00023203  00000-0  13678-2 0  9999
2 14690  63.2980  34.2325 0763245 111.9420 256.4507 13.91037555  7908
0 ATLAS H R/B
1 14691U 84012B   24187.45983091  .00023264  00000-0  29873-2 0  9995
2 14691  63.2743 214.3871 0140589 142.0792 219.0302 14.74436135266803
0 COSMOS 1536
1 14699U 84013A   24187.56540990  .00004667  00000-0  26222-3 0  9995
2 14699  82.5499 351.3178 0016943 255.3438 104.5914 15.12959012179713
0 SL-14 R/B
1 14700U 84013B   24187.60972601  .00000743  00000-0  85068-4 0  9996
2 14700  82.5366 269.7147 0020733 112.3479   7.6854 14.84450091161725
0 OPS 4682 DEB
1 14715U 65027N   24186.87590353  .00000242  00000-0  82005-3 0  9995
2 14715  90.2495 333.3147 0039523 208.4300 305.3014 12.96145212916647
0 OPS 4682 DEB
1 14716U 65027P   24187.46450265  .00000826  00000-0  27496-2 0  9999
2 14716  90.2412 358.0612 0030345  36.7903 351.1678 12.99148822347042
0 OPS 4682 DEB
1 14717U 65027Q   24187.42858503  .00000473  00000-0  16094-2 0  9993
2 14717  90.2546 334.8594 0033398 146.1265 270.7498 12.96995854 23803
0 RADUGA 14
1 14725U 84016A   24186.91476465 -.00000179  00000-0  00000-0 0  9999
2 14725   9.9567 315.7482 0005328 159.3071 221.4870  1.00289815110966
0 JD 1
1 14728U 84012C   24187.53510148  .00004990  00000-0  49015-3 0  9990
2 14728  63.3019 182.6665 0826556 116.1844 252.6558 13.65475030246062
0 JD 2
1 14729U 84012D   24187.43870496  .00005047  00000-0  48641-3 0  9993
2 14729  63.2967 180.2704 0824938 115.5771 253.2850 13.66317631246230
0 COSMOS 1317 DEB
1 14734U 81108E   24185.34560007 -.00000037  00000-0  00000-0 0  9993
2 14734  71.4834  92.1405 4939300 339.6426 230.9424  2.01748846269247
0 COSMOS 1317 DEB
1 14735U 81108F   24180.54688831  .00000007  00000-0  00000+0 0  9992
2 14735  71.3013 115.1409 4975316 343.5218 204.1112  2.01439140279956
0 COSMOS 1317 DEB
1 14736U 81108G   24187.31386578 -.00000393  00000-0  00000-0 0  9998
2 14736  71.5406 142.2887 5055435 343.8410  58.0386  2.00257692219069
0 COSMOS 1275 DEB
1 14739U 81053JU  24187.33208368  .00002684  00000-0  18277-2 0  9993
2 14739  83.0081  28.4542 0060260 120.8204 239.8915 13.98728006162248
0 COSMOS 1275 DEB
1 14740U 81053JV  24187.31178912  .00002059  00000-0  17807-2 0  9998
2 14740  83.1354 143.2443 0099969 272.3480 243.3760 13.83674732 19303
0 COSMOS 1275 DEB
1 14741U 81053JW  24187.54168655  .00000973  00000-0  13147-2 0  9993
2 14741  82.9654 289.2366 0155641 259.5529 111.7501 13.53903433106689
0 TITAN 3C TRANSTAGE DEB
1 14756U 65108Y   24187.50228733  .01584661 -79669-5  50894-3 0  9998
2 14756  26.5061 343.9227 0870665 267.9865  82.0863 14.36517619625643
0 COSMOS 1538
1 14759U 84019A   24187.34138082  .00000236  00000-0  93601-4 0  9993
2 14759  74.0395 142.3101 0019731 106.2677 254.0647 14.34067626110906
0 SL-8 R/B
1 14760U 84019B   24187.11780135  .00000373  00000-0  13521-3 0  9996
2 14760  74.0434  77.0997 0027046  22.4288 337.8040 14.36546286112987
0 LANDSAT 5
1 14780U 84021A   24187.58548179  .00003872  00000-0  31282-3 0  9993
2 14780  98.1142  66.0915 0080107 336.0148  23.7350 14.97971012684587
0 OSCAR 11 (UoSAT 2)
1 14781U 84021B   24187.53020201  .00002378  00000-0  27253-3 0  9993
2 14781  97.7052 156.2524 0008703  27.4633 332.7042 14.86818999151215
0 COSMOS 1540
1 14783U 84022A   24186.85952465 -.00000120  00000-0  00000-0 0  9998
2 14783  10.8241 310.8643 0008063 228.7833 131.1448  1.00282839113871
0 INTELSAT 508
1 14786U 84023A   24187.55382772 -.00000073  00000-0  00000-0 0  9995
2 14786  14.2981 342.6162 0017396 220.9806 169.6826  0.97290983 39041
0 COSMOS 1541
1 14790U 84024A   24186.92759675 -.00000433  00000-0  00000-0 0  9991
2 14790  71.8099 176.8347 5350067   1.1171   3.5678  2.00348402267669
0 JD 3
1 14795U 84012F   24187.59567452  .00009147  00000-0  64364-3 0  9993
2 14795  63.2954 143.5362 0821598 113.3169 255.6462 13.74918427256186
0 SL-6 R/B(2)
1 14796U 84024D   24187.49910703 -.00000502  00000-0  00000-0 0  9998
2 14796  71.1120 114.5195 5314042 353.4601 200.5019  2.02879653298668
0 COSMOS 886 DEB
1 14799U 76126BR  24187.00991992 -.00000150  00000-0 -66758-3 0  9996
2 14799  65.8125  46.5971 0889092 285.5343 238.5819 11.69352045736814
0 COSMOS 886 DEB
1 14800U 76126BS  24187.35574910 -.00000569  00000-0 -73891-2 0  9993
2 14800  65.7541 137.2868 0625947 311.5461 220.4819 11.50326306744897
0 SL-8 DEB *
1 14801U 75112D   24187.31542420  .00003232  00000-0  66768-3 0  9999
2 14801  74.0615  37.6216 0006150  98.7333  76.0491 14.60780462384065
0 SL-8 DEB *
1 14802U 77059C   24187.36055823  .00004974  00000-0  84339-3 0  9991
2 14802  74.0525 160.0114 0007339 103.8449  46.4145 14.69493481262131
0 SL-8 DEB
1 14805U 79078C   24187.62382983  .00021577  00000-0  14741-2 0  9993
2 14805  74.0508 141.5056 0005509 215.0812 319.5351 15.06091841218669
0 SL-8 DEB *
1 14806U 79078D   24187.57608073  .00003022  00000-0  69221-3 0  9998
2 14806  74.0343 358.2928 0003789  21.6660  43.2979 14.56056232436097
0 SL-8 DEB *
1 14807U 79089D   24187.37332120  .02636524  86882-2  35683-2 0  9995
2 14807  74.0158 294.7565 0017269 300.3699  59.5836 16.08158093322543
0 SL-8 DEB *
1 14808U 80056C   24187.34046000  .00002076  00000-0  58337-3 0  9993
2 14808  74.0377 159.6338 0015784 291.6870 222.5358 14.46497284125851
0 SL-8 DEB *
1 14809U 80056D   24187.56756133  .00002584  00000-0  65228-3 0  9994
2 14809  74.0363 355.3900 0010019 102.6955 324.9205 14.51526965188928
0 SL-8 DEB *
1 14810U 81084D   24187.63062446  .00002695  00000-0  69553-3 0  9991
2 14810  73.9521 134.8108 0013877  76.3809  97.9785 14.50447389166684
0 SL-8 DEB
1 14811U 82037D   24187.63041270  .00002338  00000-0  65175-3 0  9993
2 14811  74.0266 141.8142 0018776 323.4227 211.2624 14.46775467203380
0 SL-8 DEB
1 14812U 83031C   24187.36983426  .00002063  00000-0  57837-3 0  9998
2 14812  74.0576 316.5496 0015950 258.7538 132.2122 14.46597760149016
0 SL-8 DEB *
1 14813U 83079C   24187.44104860  .00001974  00000-0  56390-3 0  9990
2 14813  74.0324 176.9190 0016975 339.3059 182.1791 14.45715542240207
0 SL-8 DEB *
1 14816U 76098C   24187.53489333  .00003286  00000-0  69255-3 0  9999
2 14816  74.0368 279.2555 0013055  34.3082 338.8492 14.59823338332077
0 SL-8 DEB *
1 14817U 76098D   24187.51943200  .00032658  00000-0  15457-2 0  9995
2 14817  74.0635 213.5057 0010970 288.6123 221.8377 15.19158227358588
0 SL-8 DEB *
1 14818U 77059D   24187.58326939  .00012188  00000-0  12343-2 0  9992
2 14818  74.0624   2.9097 0003826  14.6879  49.4510 14.90988524310353
0 COSMOS 1544
1 14819U 84027A   24187.38487050  .00413599  70218-4  86568-3 0  9990
2 14819  82.4570 286.7949 0009578 244.1863 115.8426 15.98870686210258
0 SL-14 R/B
1 14820U 84027B   24187.46900549  .00000664  00000-0  75173-4 0  9998
2 14820  82.5426  98.7271 0017823 195.1432 164.9253 14.84817240156746
0 EKRAN 12
1 14821U 84028A   24187.52315499 -.00000113  00000-0  00000-0 0  9994
2 14821  11.7101 317.6584 0009908 149.9655 120.6867  0.96062628127186
0 DELTA 1 DEB
1 14839U 77065FS  24186.93221147  .00001517  00000-0  50077-2 0  9995
2 14839  28.9909 257.2193 0986095 190.7341 337.5719 11.91157425 74939
0 SL-8 DEB *
1 14865U 75094E   24187.61677800  .00005988  00000-0  93840-3 0  9993
2 14865  74.0229 143.3628 0004254 275.6651 258.9182 14.72899892643315
0 SL-8 DEB *
1 14866U 79060C   24187.09089958  .00023078  00000-0  13922-2 0  9996
2 14866  74.0264 194.0325 0003458 288.7220 135.4182 15.10663047151614
0 COSMOS 1546
1 14867U 84031A   24186.89285328 -.00000042  00000-0  00000-0 0  9995
2 14867  10.0503 316.3871 0021375   1.9260 356.4839  1.00263573 40225
0 THORAD DELTA 1 DEB
1 14879U 74089ES  24187.22155160  .00000012  00000-0  47888-3 0  9992
2 14879 101.2060 180.3123 0213083 308.9608 114.3023 12.15494994470777
0 THORAD DELTA 1 DEB
1 14880U 74089ET  24187.48527520 -.00000003  00000-0  29763-3 0  9998
2 14880 101.1310 179.6097 0152311 290.4773 226.0219 12.30449863921851
0 THORAD DELTA 1 DEB
1 14881U 74089EU  24187.34998054 -.00000023  00000-0  14638-3 0  9995
2 14881 101.6785 148.0412 0065340 242.4629 275.8471 12.42139035952155
0 DELTA 1 DEB
1 14883U 73086GS  24187.18658023 -.00000321  00000-0 -31850-2 0  9990
2 14883 102.0574  79.5686 0243295 304.8754 213.1745 11.99978338542183
0 COSMOS 1547
1 14884U 84033A   24184.23086426  .00000533  00000-0  00000-0 0  9994
2 14884  73.1804   4.5826 5699358 280.5134  23.0770  2.00689163234983
0 SL-6 R/B(2)
1 14894U 84033D   24185.96895796 -.00000300  00000-0  00000-0 0  9997
2 14894  72.3836 320.0647 5649958 250.7923  42.2390  2.03826535238695
0 STTW-T2
1 14899U 84035A   24187.11884519  .00000055  00000-0  00000-0 0  9990
2 14899  10.6799 322.6107 0010714 169.4439 204.0758  1.00264716 40237
0 CZ-3 R/B
1 14900U 84035B   24187.11855517  .00000093  00000-0  74679-3 0  9997
2 14900  30.5134 223.5915 7124653 325.2774   4.3956  2.34416117275018
0 DELTA 1 DEB
1 14904U 76077ES  24182.81823983  .00000853  00000-0  44198-2 0  9998
2 14904 102.7403  14.1791 0005560  21.0835 352.1743 12.72360746502140
0 DELTA 1 DEB
1 14905U 76077ET  24187.22572839  .00000191  00000-0  25041-2 0  9991
2 14905 102.3454 267.9149 0185319 157.0474 226.3261 12.07307205832432
0 COSMOS 970 DEB
1 14906U 77121BK  24187.26858976  .00000542  00000-0  65276-3 0  9991
2 14906  65.9514 128.7544 0108426 116.9196 319.2445 13.72224901 32641
0 COSMOS 970 DEB
1 14907U 77121BL  24187.13388113  .00000127  00000-0  29169-3 0  9999
2 14907  66.0268 234.9783 0059501  80.9815  17.3253 13.54581829104897
0 DELTA 1 DEB
1 14908U 78026GH  24187.38813728  .00002841  00000-0  14940-2 0  9992
2 14908  99.1334 225.1985 0095352  21.0000 339.5046 14.12585502172375
0 DELTA 1 DEB
1 14909U 78026GJ  24187.12624334  .00003943  00000-0  24816-2 0  9995
2 14909  98.7629 251.1435 0145841  40.8572  20.9249 13.99742843146306
0 DELTA 1 DEB
1 14910U 78026GK  24187.57020196  .00002156  00000-0  97691-3 0  9999
2 14910  99.0332 132.2762 0017740  37.6411  18.0813 14.22974293 90246
0 DELTA 1 DEB
1 14913U 78026GN  24187.28610249  .00002025  00000-0  79576-3 0  9991
2 14913  98.8160 205.9188 0095649  88.3123 333.8396 14.27909104144958
0 DELTA 1 DEB
1 14914U 78026GP  24187.51392382  .00001808  00000-0  58831-3 0  9992
2 14914  98.6162 208.0244 0043116 239.6195 280.6370 14.39467794215528
0 COSMOS 839 DEB
1 14919U 76067BG  24187.54654215 -.00000042  00000-0  44663-4 0  9998
2 14919  65.8041 275.3237 0724462   3.4955 103.0550 12.30361526546996
0 COSMOS 1275 DEB
1 14925U 81053JX  24187.34310274  .00006073  00000-0  25579-2 0  9990
2 14925  82.8583 151.4232 0027485  74.3920 286.0294 14.25403654178816
0 SL-3 DEB
1 14928U 83075F   24187.50519444  .00008746  00000-0  37358-3 0  9995
2 14928  97.7690 102.0448 0027065  40.6942 319.6310 15.22796769209792
0 OPS 7641
1 14930U 84037A   24187.48475025 -.00000252  00000-0  00000-0 0  9996
2 14930  11.4878 320.9829 0008316 241.2317  36.6692  0.98682917 17964
0 TITAN 34D TRANSTAGE R/B
1 14931U 84037B   24186.24182038 -.00000217  00000-0  00000-0 0  9990
2 14931  10.1495 316.3428 0028739 306.3802  53.4381  1.01161507 18722
0 GORIZONT 9
1 14940U 84041A   24187.58366057 -.00000280  00000-0  00000-0 0  9998
2 14940  10.1002 317.1909 0004998 237.0860  36.2860  1.00261299114809
0 SL-12 R/B(2)
1 14943U 84041D   24187.58881510  .00000001  00000-0  00000-0 0  9997
2 14943  10.9087 319.8015 0017154 197.1892 202.4968  0.98626661114269
0 SL-12 R/B(2)
1 14948U 84022F   24187.17876461 -.00000278  00000-0  00000-0 0  9992
2 14948  10.9669 311.2558 0024953 137.2329 210.6402  0.99873001154163
0 SL-3 DEB
1 14950U 77117C   24187.57033245  .00000251  00000-0  13703-3 0  9998
2 14950  81.2539 299.9362 0035857 153.9372 219.3420 14.08928985392400
0 SL-12 R/B(2)
1 14951U 84031F   24187.50880574  .00000087  00000-0  00000-0 0  9990
2 14951  10.4353 317.5219 0014860 226.3134 140.5561  0.99424876112731
0 COSMOS 1550
1 14965U 84043A   24187.57015760  .00000096  00000-0  87657-4 0  9999
2 14965  82.9725  23.2560 0025236 196.4386 217.5618 13.72921787 12418
0 SL-8 R/B
1 14966U 84043B   24187.61581002  .00000166  00000-0  15867-3 0  9993
2 14966  82.9741 354.4801 0017577  80.0638 350.4356 13.74742203 13526
0 COSMOS 1553
1 14973U 84046A   24187.37717300  .00000091  00000-0  77734-4 0  9998
2 14973  82.9355  60.4950 0033556  99.8998  74.8310 13.75496845 13869
0 SL-8 R/B
1 14974U 84046B   24187.61718965  .00000041  00000-0  26481-4 0  9992
2 14974  82.9356  26.2130 0044909 355.4679  63.3181 13.77060159 16322
0 COSMOS 1554 (GLONASS)
1 14977U 84047A   24187.14077122 -.00000080  00000-0  00000-0 0  9996
2 14977  66.6038 351.3712 0016370 218.5833 135.1406  2.13099610 88702
0 COSMOS 1555 (GLONASS)
1 14978U 84047B   24183.85824942 -.00000063  00000-0  00000-0 0  9992
2 14978  66.6152 351.9513 0012129 175.3832 177.8004  2.13101913284257
0 COSMOS 1556 (GLONASS)
1 14979U 84047C   24186.85948657 -.00000079  00000-0  00000-0 0  9993
2 14979  66.6365 352.9171 0009524 194.8410 143.7861  2.12912348311927
0 SL-12 R/B(2)
1 14984U 84047F   24182.85998461 -.00000057  00000-0  00000-0 0  9999
2 14984  66.6187 351.8097 0008047 229.7086 124.7008  2.13162981312278
0 CHINASAT 5 (SPACENET 1)
1 14985U 84049A   24187.15617788  .00000065  00000-0  00000-0 0  9998
2 14985  14.6342 353.7118 0010325 205.7477 338.0620  0.99993571124180
0 COSMOS 1559
1 14998U 84052A   24187.33997972  .00000010  00000-0  18402-3 0  9990
2 14998  74.0130  39.5617 0025299  97.7105  75.0495 12.43963783821013
0 COSMOS 1560
1 14999U 84052B   24187.52251259 -.00000022  00000-0 -42563-4 0  9994
2 14999  74.0140 321.9121 0013786 358.9054  69.4542 12.46100979824180
0 COSMOS 1561
1 15000U 84052C   24187.62242600  .00000016  00000-0  21482-3 0  9996
2 15000  74.0113 253.9857 0015578 239.0205 234.2177 12.47974153826960
0 COSMOS 1562
1 15001U 84052D   24187.41814444 -.00000007  00000-0  60337-4 0  9999
2 15001  74.0098 182.9858 0014475 112.1666 357.0278 12.49948621829841
0 COSMOS 1563
1 15002U 84052E   24187.26511944 -.00000020  00000-0 -26489-4 0  9998
2 15002  74.0121 114.6731 0024244  22.1290  92.6326 12.51822158565111
0 COSMOS 1564
1 15003U 84052F   24187.36057780  .00000008  00000-0  15514-3 0  9993
2 15003  74.0129  51.1422 0033213 302.4182 230.8263 12.53566803835066
0 COSMOS 1565
1 15004U 84052G   24187.61578472 -.00000014  00000-0  16801-4 0  9997
2 15004  74.0141 341.9012 0043761 224.1474 211.3309 12.55444366837843
0 COSMOS 1566
1 15005U 84052H   24187.57128764  .00000001  00000-0  99121-4 0  9999
2 15005  74.0125 271.4995 0050962 133.5288 329.4390 12.57364877840665
0 SL-8 R/B
1 15006U 84052J   24187.62891675  .00000034  00000-0  44492-3 0  9990
2 15006  74.0137  35.4686 0132898 220.1851 197.1488 12.23727391791583
0 COSMOS 1570
1 15031U 84056A   24187.37688899  .00000239  00000-0  98130-4 0  9992
2 15031  74.0666 147.3878 0012019  28.2826  89.3247 14.32233460 92507
0 SL-8 R/B
1 15032U 84056B   24187.58789336  .00000330  00000-0  12361-3 0  9997
2 15032  74.0702  46.7319 0017993 277.9046  82.0065 14.35471838 96052
0 SL-8 DEB
1 15033U 84056C   24187.55079525  .00002120  00000-0  59398-3 0  9997
2 15033  74.0713 320.0842 0013229   1.4022 122.4939 14.46637565 99309
0 NAVSTAR 9 (USA 1)
1 15039U 84059A   24185.66654284 -.00000062  00000-0  00000-0 0  9994
2 15039  63.0724  84.9270 0229804  50.5410 129.2277  1.92302772284403
0 SL-12 R/B(AUX MOTOR)
1 15053U 84047G   24187.30232716  .00003665  00000-0  99008-3 0  9992
2 15053  51.9779 200.1832 5587246  62.1027 343.1271  4.64401723650716
0 SL-12 R/B(AUX MOTOR)
1 15054U 84047H   24187.21396406  .00015243  00000-0  22308-2 0  9993
2 15054  51.9628  53.3116 4794977  82.7330 327.4551  5.97207568649990
0 COSMOS 1574
1 15055U 84062A   24187.60278863  .00000089  00000-0  78067-4 0  9997
2 15055  82.9561 243.7951 0026210 233.4361 234.9968 13.74447751  7802
0 SL-8 R/B
1 15056U 84062B   24187.59626387  .00000120  00000-0  10615-3 0  9994
2 15056  82.9549 209.3491 0026577  89.1637  23.6468 13.76497417 10442
0 RADUGA 15
1 15057U 84063A   24187.06507972  .00000123  00000-0  00000-0 0  9993
2 15057  10.0980 316.7531 0005824 183.5716 187.8256  1.00303862133966
0 USA 3
1 15071U 84065C   24187.56641608  .00005344  00000-0  41757-3 0  9998
2 15071  95.8873 210.9839 0004136 299.7286  60.3531 15.01357449  7830
0 COSMOS 1577
1 15077U 84067A   24187.57763361  .00000095  00000-0  82715-4 0  9996
2 15077  82.9569  12.9625 0035667 182.2377 242.3880 13.75563778755649
0 SL-8 R/B
1 15078U 84067B   24187.50730884  .00000136  00000-0  12119-3 0  9990
2 15078  82.9557 340.9091 0026446  78.2196 282.1926 13.77431689 10932
0 COSMOS 1579
1 15085U 84069A   24187.57794537 -.00000069  00000-0  17171-4 0  9992
2 15085  65.0502 130.1152 0063259 274.7671  84.6169 13.86144637 27142
0 COSMOS 1581
1 15095U 84071A   24186.86658088  .00000648  00000-0  00000-0 0  9998
2 15095  66.2386  81.4536 6831347  17.0171 357.7271  1.99718834266241
0 SL-6 R/B(2)
1 15098U 84071D   24185.84361974  .00000565  00000-0  00000-0 0  9991
2 15098  71.8998  36.5405 5683351 313.8833  11.3416  2.04054819298110
0 METEOR 2-11
1 15099U 84072A   24187.58775472  .00000077  00000-0  55221-4 0  9995
2 15099  82.5297 246.6546 0011843 291.7752  68.2148 13.85194127 21825
0 SL-14 R/B
1 15100U 84072B   24187.56888224  .00000061  00000-0  40998-4 0  9994
2 15100  82.5295 251.8595 0011002 322.1639  37.8747 13.84503895 21000
0 SL-12 R/B(2)
1 15139U 84028F   24187.54432513 -.00000106  00000-0  00000-0 0  9998
2 15139   8.5349 306.6347 0017521  41.2583 267.3591  1.01426275117233
0 SL-12 R/B(2)
1 15141U 83066F   24187.50444750 -.00000090  00000-0  00000-0 0  9996
2 15141  11.1070 318.1571 0012755 171.6113 186.7094  0.97617979110978
0 GORIZONT 10
1 15144U 84078A   24187.18024399 -.00000266  00000-0  00000-0 0  9995
2 15144  10.2195 318.2242 0000872 234.0610 114.5654  1.00312469147431
0 HIMAWARI 3 (GMS 3)
1 15152U 84080A   24187.46079713 -.00000059  00000-0  00000-0 0  9998
2 15152  11.7057 328.4335 0009382 135.5708 242.6210  0.99825878145548
0 EUTE 1-F2 (ECS 2)
1 15158U 84081A   24186.43313427 -.00000095  00000-0  00000+0 0  9993
2 15158  13.3108 337.8078 0012617 191.2481 192.7653  0.98795914110262
0 TELECOM 1A
1 15159U 84081B   24186.72079233 -.00000235  00000-0  00000-0 0  9997
2 15159  13.5457 338.8120 0033594  43.2529 328.3033  0.98398174111602
0 ARIANE 3 DEB (SYLDA)
1 15166U 84081D   24186.57504618  .00000367  00000-0  70069-2 0  9997
2 15166   6.5732 174.7398 7014106 313.1294   6.2940  2.42586887258876
0 COSMOS 1589
1 15171U 84084A   24187.56496392  .00000050  00000-0  29171-3 0  9993
2 15171  82.5959 231.8904 0007062 136.7865 334.5699 12.42237998809747
0 SL-14 R/B
1 15172U 84084B   24187.61616481  .00000030  00000-0  14654-3 0  9991
2 15172  82.5966 225.4554 0007432 133.8175 342.0539 12.42597557810029
0 SL-12 R/B(2)
1 15181U 84078F   24187.51205792 -.00000299  00000-0  00000-0 0  9997
2 15181  10.2909 318.5857 0024815 190.6864  59.5537  1.00204762115878
0 CCE 1 (AMPTE)
1 15199U 84088A   24187.19260120 -.00000074  00000-0  00000-0 0  9998
2 15199   4.8294  23.2789 7642881 185.2317 118.9669  1.53315543189501
0 DELTA 1 R/B(1)
1 15202U 84088D   24187.23703292  .00000903  00000-0  55151-3 0  9990
2 15202  28.9047  86.7264 1985244  21.0581 346.1296 10.81489999572749
0 DELTA 1 DEB
1 15205U 84088E   24186.66322821  .00001706  00000-0  10250-2 0  9996
2 15205  28.7331 295.6610 1917392 219.5593 124.8253 10.94564379159664
0 DELTA 1 R/B(2)
1 15206U 84088F   24187.62049010  .00000214  00000-0  20933-2 0  9992
2 15206  27.4983 279.6500 7814310  22.2871 358.0887  1.58620875227163
0 EKRAN 13
1 15219U 84090A   24187.05952260 -.00000114  00000-0  00000-0 0  9997
2 15219  12.1706 321.6074 0020172 179.1586 192.1981  0.96024980110224
0 USA 4
1 15226U 84091A   24186.04318303  .00001027  00000-0  00000-0 0  9991
2 15226  62.7652 152.4854 6423654 283.6310  16.4848  2.00929235 36392
0 TITAN 34B R/B
1 15227U 84091B   24187.59069382  .00001309  00000-0  15034-2 0  9991
2 15227  63.3929   4.6594 7433426 268.8118  13.8535  2.06858569 39738
0 SBS 4
1 15235U 84093B   24187.05635639  .00000018  00000-0  00000-0 0  9998
2 15235  14.0819 346.7302 0011762 112.0481 260.8463  0.98761196 38951
0 LEASAT 2
1 15236U 84093C   24187.18381192 -.00000160  00000-0  00000-0 0  9994
2 15236  12.1910 317.7707 0029337 257.3705 111.3266  0.97456843121121
0 TELSTAR 302
1 15237U 84093D   24186.72018317 -.00000203  00000-0  00000-0 0  9998
2 15237  14.5189 350.6963 0006679 145.2932 210.5055  0.99787836 39326
0 LEASAT 2 PKM
1 15244U 84093E   24187.60989792  .00445769 -41711-5  97724-3 0  9999
2 15244  27.2135 326.5388 2117784 293.9471  45.3961 11.45756398882722
0 SBS 4 R/B(PAM-D)
1 15245U 84093F   24187.39620121  .00007001  00000-0  20961-2 0  9995
2 15245  22.4499 183.4071 6896484 266.4926  19.1387  2.76939283369807
0 TELSTAR 3C R/B(PAM-D)
1 15246U 84093G   24186.98694165  .00000548  00000-0  85796-3 0  9996
2 15246  24.5624 186.3028 7078046 139.0585 304.5965  2.48485968339555
0 COSMOS 1593 (GLONASS)
1 15259U 84095A   24186.24089130 -.00000047  00000-0  00000-0 0  9998
2 15259  64.4778  97.3120 0023887 211.6687 325.4351  2.13104722263186
0 COSMOS 1594 (GLONASS)
1 15260U 84095B   24186.68350207 -.00000044  00000-0  00000-0 0  9991
2 15260  64.4166  98.9744 0004900 190.8177 351.6648  2.12637104309348
0 COSMOS 1595 (GLONASS)
1 15261U 84095C   24186.40574289 -.00000047  00000-0  00000-0 0  9993
2 15261  64.4170  95.7822 0048044 216.1837 322.2245  2.13102463284332
0 SL-12 R/B(2)
1 15264U 84095F   24185.15605057 -.00000052  00000-0  00000-0 0  9991
2 15264  64.4357  96.6816 0013128  58.6960 120.8029  2.13046711304402
0 SL-12 R/B(AUX MOTOR)
1 15265U 84095G   24187.56143709  .00034074  00000-0  40101-2 0  9998
2 15265  51.9369 266.2345 4674236 179.3081 181.8226  6.19337235639648
0 SL-12 R/B(AUX MOTOR)
1 15266U 84095H   24184.15534045  .00002162  00000-0  57771-3 0  9993
2 15266  52.0047  81.9032 5460673 266.3578  32.9606  4.84518461659615
0 COSMOS 1596
1 15267U 84096A   24186.88630628 -.00000603  00000-0  00000-0 0  9990
2 15267  65.8279 192.4743 6377357  34.5889 353.8230  2.00723780291729
0 SL-6 R/B(2)
1 15270U 84096D   24186.30483425 -.00000339  00000-0  00000-0 0  9998
2 15270  69.5555  89.8737 5971271   7.1084 358.5995  2.04777205297732
0 NAVSTAR 10 (USA 5)
1 15271U 84097A   24187.40937056 -.00000083  00000-0  00000-0 0  9992
2 15271  62.6989 312.3501 0144366 227.9080 133.7290  1.92618915282611
0 ATLAS 14E R/B
1 15272U 84097B   24186.32015941  .00000024  00000-0  00000-0 0  9997
2 15272  64.5903 120.4413 5245314 305.7294 270.0461  3.90012195567126
0 COSMOS 1598
1 15292U 84100A   24187.51919666  .00000066  00000-0  55272-4 0  9994
2 15292  82.9471 337.8992 0031855 205.9878 220.5661 13.73096795994345
0 SL-8 R/B
1 15293U 84100B   24187.54052828  .00000105  00000-0  93400-4 0  9995
2 15293  82.9412 299.6264 0023619  80.1572 280.2250 13.75296972941284
0 GALAXY 3
1 15308U 84101A   24186.95014705 -.00000026  00000-0  00000-0 0  9992
2 15308  14.4935 350.4422 0004977  65.4232 283.8800  0.99829694 39360
0 COSMOS 1579 FUEL CORE
1 15330U 84069D   24187.54303289 -.00000052  00000-0  30027-4 0  9999
2 15330  65.0541 245.1410 0044700 226.2234 242.8164 13.89892350 33076
0 COSMOS 1602
1 15331U 84105A   24187.43711632  .00013652  00000-0  47108-3 0  9990
2 15331  82.5328 310.8653 0010095 356.3930   3.7235 15.29799591171740
0 SL-14 R/B
1 15332U 84105B   24187.42472887  .00000837  00000-0  95825-4 0  9997
2 15332  82.5350 299.7767 0021300 150.9188 277.3068 14.84641129127333
0 COSMOS 1603
1 15333U 84106A   24187.48648375  .00000019  00000-0  34567-4 0  9990
2 15333  71.0280  99.1028 0021747 248.8516 111.0283 14.14342824 52106
0 SL-12 R/B(2)
1 15334U 84106B   24187.58121290 -.00000126  00000-0 -40139-4 0  9997
2 15334  71.0027  35.0618 0004737 326.1605  33.9215 14.15353981933202
0 SL-12 R/B(AUX MOTOR)
1 15335U 84106C   24187.33263337  .00000076  00000-0  71850-4 0  9996
2 15335  66.5532  40.5143 0016719 325.4159 206.9914 14.22657264 62868
0 SL-12 R/B(AUX MOTOR)
1 15338U 84106F   24187.62883466  .00000282  00000-0  17609-3 0  9992
2 15338  66.5722 305.0557 0004840  76.3845 283.7785 14.18776532 57268
0 OPS 4682 DEB
1 15340U 65027R   24187.43365230  .00000106  00000-0  33121-3 0  9991
2 15340  90.2386 350.1417 0037880 101.5789 314.7693 12.98490259891135
0 COSMOS 1604
1 15350U 84107A   24184.80740514  .00000294  00000-0  00000-0 0  9997
2 15350  71.3011  29.1331 5633495 349.2227   2.5988  2.00683090291048
0 SL-6 R/B(2)
1 15355U 84107D   24186.28511589  .00000917  00000-0  00000-0 0  9996
2 15355  63.0876 204.9098 6867478  40.8620 354.1506  2.03345809295205
0 COSMOS 1605
1 15359U 84109A   24187.62816324  .00000077  00000-0  63171-4 0  9995
2 15359  82.9412 319.7314 0047153 146.8991 223.9777 13.75313535994013
0 SL-8 R/B
1 15360U 84109B   24187.54012614  .00000092  00000-0  77211-4 0  9995
2 15360  82.9405 294.6597 0042310  50.3920 310.0960 13.76930864995690
0 NOVA 3
1 15362U 84110A   24187.58762395  .00000102  00000-0  22221-3 0  9993
2 15362  90.1167  74.6385 0031509 340.5509  81.9270 13.22947412917559
0 COSMOS 1606
1 15369U 84111A   24187.24479345  .00015775  00000-0  47678-3 0  9999
2 15369  82.5216  96.0241 0009005 290.3237  69.7038 15.34065414171355
0 SL-14 R/B
1 15370U 84111B   24187.29051232  .00000697  00000-0  78935-4 0  9995
2 15370  82.5167 112.4193 0019963 194.5098 165.5547 14.84898217124958
0 COSMOS 1607
1 15378U 84112A   24187.48190371 -.00000061  00000-0  25001-4 0  9995
2 15378  64.9923 103.8382 0056122 237.3765 122.1871 13.83642303  6510
0 ARABSAT 1D (ANIK D2)
1 15383U 84113B   24187.60327153 -.00000163  00000-0  00000-0 0  9997
2 15383  14.1112 346.6501 0023335  18.7249 322.0300  0.98909100107806
0 LEASAT 1
1 15384U 84113C   24186.78722131 -.00000245  00000-0  00000-0 0  9992
2 15384  12.0648 341.8315 0027709 277.9975  87.8318  0.98546261116903
0 SPACENET 2
1 15385U 84114A   24186.99023883 -.00000084  00000-0  00000-0 0  9996
2 15385  14.8144 357.4207 0010380  89.0410 276.1090  0.99751570119872
0 MARECS B2
1 15386U 84114B   24187.46408339 -.00000157  00000-0  00000-0 0  9994
2 15386  14.3335 337.6544 0110651  39.8082 338.1207  0.95928632105857
0 ANIK D2 R/B(PAM-D)
1 15387U 84113D   24187.34503187  .00000976  00000-0  14268-2 0  9999
2 15387  25.1510 167.6324 7056112  49.0123 353.3494  2.49599085346836
0 ARIANE 3 R/B
1 15388U 84114C   24187.10352549  .00000411  00000-0  83024-3 0  9990
2 15388   7.2065  99.8237 6887281 246.7309  29.9287  2.71875793285580
0 LEASAT 1 PKM
1 15390U 84113E   24187.56996720  .00077988  00000-0  14400-2 0  9991
2 15390  27.0900 276.7770 4168711  70.6293 329.1416  7.22253545760339
0 NATO 3D
1 15391U 84115A   24187.05792280 -.00000162  00000-0  00000-0 0  9993
2 15391  14.3384 359.3257 0104855 115.1666 254.5402  0.94954450141128
0 DELTA 1 R/B(1)
1 15392U 84115B   24187.34542782  .00000259  00000-0  83697-4 0  9999
2 15392  21.4966  62.4375 1033136 195.4270 161.2194 12.45853821787579
0 COSMOS 1610
1 15398U 84118A   24187.57929685  .00000066  00000-0  54031-4 0  9990
2 15398  82.9500 299.2023 0030981 323.0919  52.4757 13.73853314987177
0 SL-8 R/B
1 15399U 84118B   24187.59978455  .00000127  00000-0  11340-3 0  9995
2 15399  82.9446 254.6897 0034435 154.3005 314.7705 13.76310606989949
0 DELTA 1 R/B(2)
1 15402U 84115C   24187.22054302  .00000303  00000-0  16513-2 0  9995
2 15402  22.7757 185.3957 7122076 348.6459   1.2515  2.37137292276517
0 ATLAS AGENA R/B(2)
1 15422U 77038C   24187.18177008 -.00000031  00000-0  00000-0 0  9998
2 15422   7.3121 330.4929 1489753 166.4143 198.3131  1.02334691 18949
0 NOAA 9
1 15427U 84123A   24187.61670053  .00000220  00000-0  13350-3 0  9996
2 15427  99.1178 185.5051 0014316 200.4611 267.9525 14.16614081 42655
0 MOLNIYA 1-63
1 15429U 84124A   24186.14248341 -.00001326  00000-0  00000-0 0  9991
2 15429  63.6201  87.5240 7050573 256.2112 346.3956  2.00804947289754
0 SL-6 R/B(2)
1 15439U 84124H   24186.71998376 -.00000160  00000-0  00000-0 0  9990
2 15439  63.4179  98.3133 7198143 253.8840  22.0832  1.96346423240735
0 USA 7
1 15453U 84129A   24187.05952260 -.00000036  00000-0  00000-0 0  9993
2 15453  12.6536 326.2846 0003357 192.7169 179.3308  0.98856392 19019
0 TITAN 34D TRANSTAGE R/B
1 15454U 84129B   24187.34553230 -.00000273  00000-0  00000-0 0  9993
2 15454  11.5543 321.5825 0007704 203.6935 156.3254  1.01159211 18547
0 COSMOS 1617
1 15469U 85003A   24187.56218257  .00000044  00000-0  18668-3 0  9999
2 15469  82.6109 208.1249 0002522  99.9269  15.2714 12.62521939818630
0 COSMOS 1618
1 15470U 85003B   24187.41458462  .00000013  00000-0  12033-4 0  9996
2 15470  82.6025 186.2950 0005629  54.6774  75.9938 12.62990755819520
0 COSMOS 1619
1 15471U 85003C   24187.38932514  .00000011  00000-0 -39910-6 0  9992
2 15471  82.6076 138.3066 0018191 223.9927 264.2169 12.66247557823963
0 COSMOS 1620
1 15472U 85003D   24187.42995521 -.00000003  00000-0 -74308-4 0  9995
2 15472  82.6015 148.1245 0014214 295.7547 184.9956 12.65061532822497
0 COSMOS 1621
1 15473U 85003E   24187.43831388  .00000001  00000-0 -53267-4 0  9995
2 15473  82.6108 170.4487 0011462 326.4089 190.0762 12.64477875821607
0 COSMOS 1622
1 15474U 85003F   24187.40799045  .00000008  00000-0 -17146-4 0  9999
2 15474  82.6079 178.3899 0008909   0.2053 123.0364 12.63798095820623
0 SL-14 R/B
1 15475U 85003G   24187.44902455 -.00000007  00000-0 -10526-3 0  9999
2 15475  82.6128 327.3816 0037180 355.1846  67.9507 12.55170516808229
0 COSMOS 1624
1 15482U 85006A   24187.38257693  .00000226  00000-0  90940-4 0  9990
2 15482  74.0425  55.2450 0013637 114.3247  58.2807 14.33504635 62245
0 SL-8 R/B
1 15483U 85006B   24187.57809593  .00000389  00000-0  13965-3 0  9995
2 15483  74.0469 306.9375 0018566  10.2051   0.7879 14.37088715 66075
0 GORIZONT 11
1 15484U 85007A   24186.98336404  .00000122  00000-0  00000-0 0  9995
2 15484  10.4387 320.3208 0004619 184.8382 180.5379  1.00164916145493
0 SL-12 R/B(2)
1 15487U 85007D   24187.18328978 -.00000037  00000-0  00000-0 0  9994
2 15487   9.0743 315.7909 0015793 276.1939  91.2346  1.03023440148382
0 SL-8 DEB
1 15490U 85006C   24186.60889668  .00002625  00000-0  56499-3 0  9991
2 15490  74.0331 260.2813 0003386 241.1409 118.9417 14.59001789 79395
0 SL-8 DEB
1 15491U 85006D   24187.51497097  .00001916  00000-0  52787-3 0  9992
2 15491  74.0426 250.5875 0014221 140.0728 220.1480 14.47506346 68189
0 COSMOS 1626
1 15494U 85009A   24187.45499645  .00039402  00000-0  57637-3 0  9992
2 15494  82.4642 171.1892 0003702  98.3989 261.7684 15.55422682161662
0 SL-14 R/B
1 15495U 85009B   24187.56514371  .00000785  00000-0  88885-4 0  9991
2 15495  82.5246 294.0037 0021106 108.9328 251.4178 14.85008239110762
0 COSMOS 1607 FUEL CORE
1 15503U 84112C   24187.43912037 -.00000063  00000-0  22687-4 0  9990
2 15503  64.9923 213.5405 0038586 230.8254 128.9378 13.87523496997295
0 COSMOS 1627
1 15505U 85011A   24187.57270661  .00000088  00000-0  76441-4 0  9999
2 15505  82.9198 215.5567 0042335 169.3967 303.1926 13.74490399977347
0 SL-8 R/B
1 15506U 85011B   24187.50163131  .00000180  00000-0  16814-3 0  9996
2 15506  82.9185 183.7135 0037574  51.3365  59.8530 13.76383901979353
0 METEOR 2-12
1 15516U 85013A   24187.47652745  .00000077  00000-0  54396-4 0  9992
2 15516  82.5312 179.8386 0016949 118.8679 241.4185 13.85756978993232
0 SL-14 R/B
1 15517U 85013B   24187.53122176  .00000044  00000-0  25586-4 0  9993
2 15517  82.5350 190.4902 0015348 153.9469 206.2468 13.84951931991503
0 COSMOS 252 DEB
1 15519U 68097EF  24187.57254689  .00001290  00000-0  51678-3 0  9991
2 15519  62.3651 273.6118 0911541 140.4296 226.7008 13.05739465726576
0 SL-3 DEB
1 15521U 74083C   24187.38948903  .00000102  00000-0  50835-4 0  9990
2 15521  81.2165 161.8582 0057527 325.8709 153.9230 14.09380432558050
0 COSMOS 839 DEB
1 15523U 76067BH  24187.44554167  .00000005  00000-0  15500-3 0  9999
2 15523  65.9321  69.1280 0742396 164.1728   7.4743 12.47582792567044
0 SL-8 DEB *
1 15528U 82109D   24187.54569426  .00003304  00000-0  70756-3 0  9992
2 15528  74.0220 359.3189 0009979 261.7882 156.0175 14.59101813113052
0 OPS 4682 DEB
1 15529U 65027S   24187.41948862 -.00000253  00000-0 -88044-3 0  9995
2 15529  90.2375 350.8095 0033797  60.0921 328.1279 12.98794816 64677
0 OPS 4682 DEB
1 15530U 65027T   24186.97867913 -.00000145  00000-0 -52071-3 0  9995
2 15530  90.2598  14.7456 0035347 106.0134  54.8288 12.98207254965299
0 COSMOS 249 DEB
1 15535U 68091CY  24187.55437355  .00014859  00000-0  19913-2 0  9994
2 15535  62.4017  21.6113 0439558  34.5092 328.3683 14.29849593854062
0 DELTA 1 DEB
1 15540U 76077EU  24186.94864568  .00000187  00000-0  26818-2 0  9996
2 15540 102.6532 188.5197 0577239  74.6435 357.8893 11.67534460415906
0 COSMOS 1275 DEB
1 15541U 81053JZ  24186.94512924  .00000522  00000-0  43867-3 0  9990
2 15541  82.8902 158.6931 0031210 220.6824 194.6485 13.86065064 23428
0 COSMOS 1275 DEB
1 15542U 81053KA  24187.42703883  .00001107  00000-0  10331-2 0  9990
2 15542  83.0026 232.9722 0073443 203.0797 217.3288 13.79909248128491
0 USA 8
1 15543U 85010B   24187.26368655 -.00000366  00000-0  00000-0 0  9991
2 15543  13.9758 320.4319 0126096  38.1816 326.2767  0.99814604   729
0 IUS R/B(1)
1 15544U 85010C   24187.28089896  .00005375  00000-0  27376-2 0  9992
2 15544  27.9543  12.9903 6873949 124.3941 320.1746  2.78291507 52051
0 IUS R/B(2)
1 15545U 85010D   24187.39028877 -.00000183  00000-0  00000-0 0  9993
2 15545  14.0918 319.5893 0026301 276.6113  83.1273  1.00822011 19741
0 COSMOS 886 DEB
1 15555U 76126BT  24187.08844655  .00001276  00000-0  15096-2 0  9994
2 15555  65.7872  43.0524 0953299 100.6521 270.3144 12.52413977477592
0 THOR ABLESTAR DEB
1 15558U 61015LE  24187.45524498  .00000166  00000-0  15874-3 0  9991
2 15558  65.5873 252.8703 0045019  43.2888 317.1710 14.04235120 24311
0 COSMOS 970 DEB
1 15559U 77121BM  24187.22852498  .00000172  00000-0  29454-3 0  9992
2 15559  65.5776 169.9195 0129516 332.0835  40.6909 13.64907157963572
0 ARABSAT 1A
1 15560U 85015A   24186.91229050 -.00000209  00000-0  00000-0 0  9997
2 15560  12.6960 336.2493 0033036 210.5355 147.4198  1.00396285118861
0 BRAZILSAT 1
1 15561U 85015B   24187.47768115  .00000071  00000-0  00000-0 0  9996
2 15561  14.5170 350.1731 0000841  67.8723 261.9689  0.99547042 39254
0 ARIANE 3 R/B
1 15562U 85015C   24187.30637111  .00001368  00000-0  11630-2 0  9993
2 15562   6.7695 241.5746 6655558  96.5244 337.2569  3.04926772343457
0 COSMOS 1629
1 15574U 85016A   24187.18250657 -.00000225  00000-0  00000-0 0  9998
2 15574  10.4333 319.3731 0006787 218.3227 141.5442  1.00243869143314
0 SL-12 R/B(2)
1 15581U 85016F   24187.44587007 -.00000035  00000-0  00000-0 0  9996
2 15581  10.9189 321.1188 0025882 230.6247  84.1564  0.99408211114854
0 SL-14 R/B
1 15593U 85020B   24187.58130741  .00000780  00000-0  87280-4 0  9993
2 15593  82.5372  11.6373 0011683 162.5385 197.6236 14.85621195105284
0 GEOSAT
1 15595U 85021A   24187.54180737  .00000286  00000-0  13616-3 0  9994
2 15595 108.0609  40.6178 0002152 256.4651 103.6250 14.39048482 60350
0 ATLAS 41E R/B
1 15596U 85021B   24187.58904292  .00000699  00000-0  24688-3 0  9998
2 15596 108.0346 173.8974 0031355  45.4432  57.1386 14.43129054 64360
0 COSMOS 1634
1 15597U 85022A   24187.61663025  .00000083  00000-0  70528-4 0  9992
2 15597  82.9395  23.2879 0034591 220.8372 200.4757 13.75218628972435
0 SL-8 R/B
1 15598U 85022B   24187.58596083  .00000030  00000-0  14216-4 0  9992
2 15598  82.9380 352.7001 0023476 105.5247 325.6060 13.76713378974552
0 ATLAS 41E DEB
1 15614U 85021D   24187.14715637  .00002759  00000-0  45151-3 0  9991
2 15614 108.2347 352.6417 0013273 153.6567 206.5268 14.73302332 91581
0 ATLAS 41E DEB
1 15615U 85021E   24187.28904115  .00001421  00000-0  40413-3 0  9999
2 15615 107.8142 223.3578 0042850 173.7888 252.4842 14.49319625 64870
0 COSMOS 1635
1 15617U 85023A   24187.25097852 -.00000017  00000-0 -14256-4 0  9990
2 15617  74.0555 109.9456 0024202 138.0949 335.5289 12.43241881783238
0 COSMOS 1636
1 15618U 85023B   24187.58516443  .00000008  00000-0  16652-3 0  9998
2 15618  74.0559  35.3810 0012541  40.9665  18.8402 12.45341217786280
0 COSMOS 1637
1 15619U 85023C   24187.57725928 -.00000028  00000-0 -83292-4 0  9997
2 15619  74.0572 328.7569 0015388 277.6209 156.2284 12.47226923789243
0 COSMOS 1638
1 15620U 85023D   24187.55746199  .00000015  00000-0  20203-3 0  9996
2 15620  74.0550 259.2284 0015232 154.9636 313.6696 12.49197050791869
0 COSMOS 1639
1 15621U 85023E   24187.50640986  .00000000  00000-0  10203-3 0  9992
2 15621  74.0525 193.6244 0024455  69.0806  51.4836 12.51040238794506
0 COSMOS 1640
1 15622U 85023F   24187.31089611 -.00000025  00000-0 -59969-4 0  9996
2 15622  74.0551 130.5037 0033930 348.8429 127.7216 12.52822561797165
0 COSMOS 1641
1 15623U 85023G   24187.44983903  .00000008  00000-0  14872-3 0  9990
2 15623  74.0559  68.6999 0044076 279.1145 256.4693 12.54544000799461
0 COSMOS 1642
1 15624U 85023H   24187.58417867 -.00000012  00000-0  24581-4 0  9992
2 15624  74.0566   2.9259 0051072 193.9973 238.7574 12.56374112802098
0 SL-8 R/B
1 15625U 85023J   24187.47170933  .00000010  00000-0  22778-3 0  9993
2 15625  74.0521 193.9971 0146258   6.5526 162.8730 12.19897721629820
0 EKRAN 14
1 15626U 85024A   24186.93035613 -.00000137  00000-0  00000-0 0  9992
2 15626  13.1633 325.8370 0015902 347.4840 267.8269  0.94798139115528
0 INTELSAT 510
1 15629U 85025A   24187.05813194 -.00000212  00000-0  00000-0 0  9992
2 15629  14.3220 345.4430 0028104   9.3710 282.0094  0.98283210108170
0 SL-12 R/B(2)
1 15630U 85024D   24187.33547285  .00000096  00000-0  00000-0 0  9998
2 15630   9.5739 313.9515 0015238 223.1664  43.4565  1.01226230145262
0 NAHUEL I1 (ANIK C1)
1 15642U 85028B   24187.42115186 -.00000117  00000-0  00000-0 0  9991
2 15642  14.9095 357.5535 0017814 131.6583 214.2003  0.99659262 39292
0 LEASAT 3
1 15643U 85028C   24186.98223275 -.00000081  00000-0  00000-0 0  9991
2 15643  12.7561 313.3264 0074495 285.6514  79.6641  0.96962264129712
0 ANIK C1 R/B(PAM-D)
1 15644U 85028D   24187.54647789  .00002380  00000-0  16022-2 0  9991
2 15644  22.8446 128.9692 6871582  90.2982 341.8594  2.76831302366856
0 GSTAR 1
1 15677U 85035A   24187.60128669 -.00000121  00000-0  00000-0 0  9992
2 15677  14.5875 354.1319 0008122 111.7818 289.2312  1.00272635118074
0 TELECOM 1B
1 15678U 85035B   24187.49798263  .00000117  00000-0  00000-0 0  9997
2 15678  11.2813 325.7653 0002767 152.2617 186.6508  1.00205396129879
0 ARIANE 3 DEB (SYLDA)
1 15680U 85035D   24187.32340386  .00340666  00000-0  12741-1 0  9993
2 15680   6.7744  42.4906 1770100 115.9401 263.3477 11.88091106760316
0 SL-12 R/B(2)
1 15693U 84063F   24187.44683420 -.00000121  00000-0  00000-0 0  9993
2 15693   8.5060 311.2082 0017456 235.0236 129.6812  1.03290761119724
0 COSMOS 1650 (GLONASS)
1 15697U 85037A   24186.31937667 -.00000047  00000-0  00000-0 0  9996
2 15697  64.5101  97.7672 0033569  26.4407 163.2579  2.13102512281106
0 COSMOS 1651 (GLONASS)
1 15698U 85037B   24184.71463897 -.00000052  00000-0  00000-0 0  9994
2 15698  64.4973  97.3908 0014612  22.5698 346.2799  2.13123178304562
0 COSMOS 1652 (GLONASS)
1 15699U 85037C   24184.51981951 -.00000051  00000-0  00000-0 0  9998
2 15699  64.4928  97.6775 0017791  23.9473 161.0936  2.13067406304438
0 SL-12 R/B(2)
1 15702U 85037F   24183.40342441 -.00000047  00000-0  00000-0 0  9990
2 15702  64.5081  96.3352 0033505  19.9953 157.0932  2.13322407304605
0 SL-12 R/B(AUX MOTOR)
1 15714U 85037G   24187.58533216  .00004794  00000-0  31032-2 0  9991
2 15714  51.9176 335.6339 5424872 111.1396 313.4650  4.83069836643816
0 SL-12 R/B(AUX MOTOR)
1 15715U 85037H   24186.72492843  .00010966  00000-0  16225-2 0  9992
2 15715  52.0304 322.1106 5100309 231.1608  71.2618  5.46376772582668
0 MOLNIYA 3-24
1 15738U 85040A   24186.87665294  .00000019  00000-0 -10723-3 0  9996
2 15738  62.7700 295.0315 6907935 249.7709  27.9172  2.55654616323006
0 SL-6 R/B(2)
1 15741U 85040D   24185.65490077  .00000809  00000-0  00000-0 0  9990
2 15741  63.4405  40.8810 7400975 251.2447  21.2398  1.96812412280953
0 COSMOS 1655
1 15751U 85041A   24187.56396734  .00000069  00000-0  60331-4 0  9994
2 15751  82.9478 230.5342 0025233 271.7774 198.5702 13.71830898957122
0 SL-8 R/B
1 15752U 85041B   24187.54565809  .00000174  00000-0  17059-3 0  9999
2 15752  82.9487 206.7335 0024489 164.3063 195.8857 13.73236952959047
0 COSMOS 1656
1 15755U 85042A   24187.58451193  .00000199  00000-0  11336-3 0  9996
2 15755  71.1126 336.5858 0034988   7.0453 353.1158 14.20724482 26088
0 SL-8 DEB
1 15756U 83079D   24187.25464974  .00006159  00000-0  92620-3 0  9997
2 15756  74.0466 137.2077 0007128 135.1483 225.0268 14.74666837 72874
0 COSMOS 886 DEB
1 15762U 76126BU  24187.09725877  .00000130  00000-0  39009-3 0  9998
2 15762  65.6616 210.5712 0736249  69.0136 298.8005 12.58997372612472
0 SCOUT A-1 DEB
1 15764U 73081C   24187.14189314  .00000319  00000-0  33969-3 0  9991
2 15764  90.4571 242.8796 0185326 129.6402 287.0039 13.65033257 39307
0 COSMOS 1275 DEB
1 15766U 81053KB  24187.40293695  .00006696  00000-0  23796-2 0  9998
2 15766  82.9403 163.5952 0003971 261.4939  98.5800 14.34269543 11562
0 COSMOS 1275 DEB
1 15767U 81053KC  24187.58332781  .00015912  00000-0  42997-2 0  9993
2 15767  82.9088 128.9388 0003613 308.6446  51.4427 14.47716719 13819
0 COSMOS 1275 DEB
1 15768U 81053KD  24187.35275309  .00003455  00000-0  18736-2 0  9994
2 15768  83.0647  37.4884 0051116 291.2917 128.5382 14.11517162992891
0 SL-3 DEB
1 15769U 81043C   24187.37799996  .00000164  00000-0  88757-4 0  9995
2 15769  81.2761 158.1093 0061144 133.4476 227.1804 14.07077982 54475
0 SL-12 R/B(2)
1 15772U 85042D   24187.61807561  .00000104  00000-0  68604-4 0  9990
2 15772  71.1089 300.5626 0035508 354.8633  16.0338 14.21642856 27396
0 SL-12 R/B(AUX MOTOR)
1 15773U 85042E   24187.58274196  .00000210  00000-0  11961-3 0  9990
2 15773  66.5894 351.4869 0032601 358.2204  66.5342 14.27575609 34363
0 SL-12 R/B(AUX MOTOR)
1 15774U 85042F   24187.48500205  .00000296  00000-0  16351-3 0  9995
2 15774  66.5874  97.8816 0017153  84.0146  88.5388 14.24670736 31678
0 COSMOS 249 DEB
1 15775U 68091DA  24186.99463577  .00002420  00000-0  29368-2 0  9998
2 15775  62.2974  40.8439 0692377 173.2964 187.7910 12.95340266475154
0 COSMOS 1275 DEB
1 15780U 81053KE  24186.77485560  .00001825  00000-0  13649-2 0  9992
2 15780  82.8164  86.7395 0057130  34.6025  28.9813 13.93402626980886
0 THOR ABLESTAR DEB
1 15783U 61015LG  24187.49245248  .00005812  00000-0  10454-2 0  9999
2 15783  67.0390 224.6000 0039212 109.6112  11.0091 14.66794095 77751
0 SL-8 DEB
1 15784U 79060D   24187.36623039  .00005998  00000-0  89049-3 0  9995
2 15784  74.0004 295.5731 0003553 283.9856 132.7980 14.75243681 86961
0 SL-8 DEB
1 15785U 84019C   24186.85877916  .00003196  00000-0  60189-3 0  9996
2 15785  74.0344 227.3652 0006780  91.8992 268.2953 14.64979612229474
0 DELTA 1 DEB
1 15788U 78026GT  24187.09598212  .00001510  00000-0  11557-2 0  9998
2 15788  98.8749 118.6995 0122769  14.8385 102.5007 13.91384140103925
0 DELTA 1 DEB *
1 15789U 73086GT  24187.51956065  .00000619  00000-0  37375-2 0  9996
2 15789 103.5587 185.4645 0354644 299.8382 220.6430 12.45959791558211
0 COSMOS 1660
1 15821U 85047A   24187.36486601 -.00000017  00000-0  27405-5 0  9999
2 15821  73.6244  58.0881 0027167   6.7132 166.7255 12.40786009769187
0 SL-14 R/B
1 15822U 85047B   24187.60977686  .00000000  00000-0  12961-3 0  9995
2 15822  73.6259  38.7461 0025134 350.2126  75.0506 12.41271547769970
0 MORELOS 1
1 15824U 85048B   24187.48042806  .00000066  00000-0  00000-0 0  9991
2 15824  14.4185 348.2208 0006977 130.8497 204.6357  0.99466916110169
0 ARABSAT 1B
1 15825U 85048C   24187.52187867 -.00000382  00000-0  00000-0 0  9996
2 15825  13.1378 339.2345 0011345  26.2130 220.9487  1.00419663128286
0 TELSTAR 303
1 15826U 85048D   24187.05813194 -.00000257  00000-0  00000-0 0  9995
2 15826  14.5535 351.6328 0004450 171.1922 117.2563  0.99884050 39382
0 COSMOS 1661
1 15827U 85049A   24186.73589032 -.00000654  00000-0  00000-0 0  9993
2 15827  67.8304 147.9792 5422307  78.3454 335.0882  2.00605823286007
0 SL-6 R/B(2)
1 15830U 85049D   24186.91766676  .00391470 -66741-6  11181-2 0  9991
2 15830  62.6454  99.2072 7483910  50.1029 354.5125  2.08717167283315
0 MORELOS 1 R/B(PAM-D)
1 15832U 85048F   24187.49317141  .00000258  00000-0  92948-3 0  9996
2 15832  25.6035 312.5732 7131733  85.2843 345.8035  2.38162898278899
0 ARABSAT 1B R/B(PAM-D)
1 15836U 85048G   24187.31641174  .00000368  00000-0  10205-2 0  9994
2 15836  26.9279 293.3410 7111671 302.5515   8.0997  2.41093056 93013
0 TELSTAR 3D R/B(PAM-D)
1 15837U 85048H   24187.28516896  .00000198  00000-0  12197-2 0  9996
2 15837  25.3030 204.7643 7192058 333.4150   3.0850  2.28355524267856
0 INTELSAT 511
1 15873U 85055A   24187.47500341  .00000082  00000-0  00000-0 0  9993
2 15873  13.8075 343.9662 0015835  97.1779 233.8403  1.00087078117389
0 ATLAS CENTAUR R/B
1 15874U 85055B   24187.50914791  .00001998  00000-0  10683-2 0  9993
2 15874  23.3153  38.0545 6494163 295.4932  12.3800  3.29378715413609
0 ARIANE 1 R/B
1 15876U 85056B   24187.51352933  .00001750  00000-0  57286-2 0  9997
2 15876   8.7363 247.9169 6212113 293.1617  14.8414  3.54718783160217
0 COSMOS 1666
1 15889U 85058A   24187.60948084  .00021382  00000-0  51924-3 0  9998
2 15889  82.4802 304.0626 0010204  59.7922 300.4333 15.40825351133523
0 SL-14 R/B
1 15890U 85058B   24187.60997495  .00000684  00000-0  77906-4 0  9991
2 15890  82.5257   9.5720 0020726  10.4710 349.6933 14.84623666 85609
0 COSMOS 1670
1 15930U 85064A   24187.41180801 -.00000057  00000-0  28355-4 0  9996
2 15930  64.9376 186.9135 0082054 274.8081  84.3613 13.83810493955315
0 OSCAR 30
1 15935U 85066A   24187.53602205  .00000152  00000-0  25554-3 0  9995
2 15935  90.1802  91.0469 0169514 125.0434  48.7707 13.35923853894409
0 OSCAR 24
1 15936U 85066B   24187.46507554  .00000140  00000-0  23549-3 0  9998
2 15936  90.1850  83.0229 0170163 131.3922  41.5424 13.35783341896306
0 SCOUT G-1 R/B
1 15938U 85066C   24187.42837691  .00000113  00000-0  18871-3 0  9996
2 15938  90.1851  85.3372 0169670 152.3337 208.6962 13.35315254893705
0 COSMOS 1674
1 15944U 85069A   24187.46468427  .00020586  00000-0  48955-3 0  9999
2 15944  82.4965 181.5900 0014282 113.1244 247.1510 15.41403927129598
0 SL-14 R/B
1 15945U 85069B   24187.56919291  .00000680  00000-0  76114-4 0  9993
2 15945  82.5264 240.0750 0020544  61.6520 298.6765 14.85250931 81938
0 RADUGA 16
1 15946U 85070A   24187.18250657 -.00000224  00000-0  00000-0 0  9990
2 15946  10.6651 321.6037 0002589 193.7214 163.7818  1.00264296115088
0 SCOUT G-1 DEB
1 15950U 85066D   24187.55472583  .00006204  00000-0  38334-2 0  9991
2 15950  89.8571 306.0722 0099580 334.4280  25.1993 14.02805213942690
0 SCOUT G-1 DEB
1 15951U 85066E   24186.97799109  .00007600  00000-0  55742-2 0  9996
2 15951  89.8565 186.7623 0137605  18.8105   9.9126 13.91278749935030
0 COSMOS 1675
1 15952U 85071A   24187.00758561  .00000084  00000-0 -16218-4 0  9992
2 15952  65.5594 185.2419 6229604 298.6539  13.0530  3.14132360367325
0 SL-12 R/B(2)
1 15963U 85070F   24187.46214587 -.00000109  00000-0  00000-0 0  9994
2 15963  11.9657 325.7859 0013855 164.2370 168.6203  0.97804316112614
0 COSMOS 1677
1 15986U 85075A   24187.58212988 -.00000048  00000-0  36512-4 0  9993
2 15986  64.6840  19.0979 0074440 218.4266 141.1478 13.86629746959272
0 OPTUS A1 (AUSSAT 1)
1 15993U 85076B   24187.18929434 -.00000091  00000-0  00000-0 0  9996
2 15993  13.9027 344.0295 0002099  88.4890 283.7314  0.99768154112499
0 ASC 1
1 15994U 85076C   24187.44354819 -.00000248  00000-0  00000-0 0  9999
2 15994  14.2548 348.6765 0006567 114.4865 258.2582  1.00265408110848
0 LEASAT 4
1 15995U 85076D   24187.63390995 -.00000054  00000-0  00000-0 0  9991
2 15995  10.9835 333.7776 0003156 323.9088 310.2203  0.97798261111172
0 OPTUS A1 R/B(PAM-D)
1 15996U 85076E   24187.06393334 -.00000031  00000-0  53558-3 0  9993
2 15996  26.0343 104.2367 7129668 227.4041  45.2044  2.37939298277942
0 LEASAT 4 PKM
1 16001U 85076F   24187.36344371  .00002002  00000-0  93161-3 0  9994
2 16001  27.3690 208.3476 5023198  27.6976 351.9073  5.48584461752953
0 ASC 1 R/B(PAM-D)
1 16007U 85076G   24187.05735387  .00000682  00000-0  12152-2 0  9999
2 16007  26.2463 142.1328 7158989  82.9562 346.5631  2.36761377329553
0 COSMOS 1680
1 16011U 85079A   24187.46513058  .00000208  00000-0  84309-4 0  9990
2 16011  74.0516 185.7317 0014997 180.8548 179.2581 14.33698769 29785
0 SL-8 R/B
1 16012U 85079B   24187.43775066  .00000374  00000-0  13472-3 0  9993
2 16012  74.0593  90.7112 0013737  69.9695 290.2936 14.37060910 33283
0 SCOUT G-1 DEB
1 16020U 85066F   24186.69862218  .00000203  00000-0  33222-3 0  9997
2 16020  90.2118 356.4597 0140571 170.8223 310.6751 13.40753141900430
0 COSMOS 1684
1 16064U 85084A   24187.13254204 -.00000598  00000-0  00000-0 0  9998
2 16064  67.2711 117.7910 5033430 111.6084 307.9689  2.00454260284041
0 SL-6 R/B(2)
1 16070U 85084D   24187.04365109 -.00000405  00000-0  00000-0 0  9999
2 16070  70.6039 109.1723 5506281  10.9857 155.5549  2.03982165288841
0 INTELSAT 512
1 16101U 85087A   24187.44354819 -.00000094  00000-0  00000-0 0  9991
2 16101  14.5449 348.9529 0005517 288.3639  82.1073  0.99112829123272
0 COSMOS 1687
1 16103U 85088A   24187.48355170  .00000286  00000-0  00000-0 0  9991
2 16103  70.7774  43.7202 5740470   0.8719 221.2595  2.00845172283968
0 SL-6 R/B(2)
1 16106U 85088D   24184.20923970  .00000805  00000-0  00000-0 0  9997
2 16106  65.0162 202.6440 6430688  38.3943 353.2938  2.04647918289451
0 USA 11
1 16116U 85092B   24187.11299519  .00000030  00000-0  00000-0 0  9991
2 16116  14.6871 352.7038 0005096 155.4686 213.0042  0.99324950 18852
0 USA 12
1 16117U 85092C   24187.15522064 -.00000119  00000-0  00000-0 0  9999
2 16117  14.6509 351.4838 0008167 119.8126  60.7419  0.98991224 18678
0 IUS R/B(1)
1 16118U 85092D   24187.14205243  .00000059  00000-0  16611-2 0  9995
2 16118  25.5582  52.7025 7171299 113.1073 333.3635  2.28898200 44495
0 IUS R/B(2)
1 16119U 85092E   24187.08435058  .00000110  00000-0  00000-0 0  9999
2 16119  11.3309 320.4080 0061336 163.8093 196.4656  1.01082975 18855
0 NAVSTAR 11 (USA 10)
1 16129U 85093A   24186.60941958 -.00000050  00000-0  00000+0 0  9992
2 16129  63.1827 104.3212 0318058  53.0795 131.4443  1.89368909215916
0 ATLAS 55E R/B
1 16137U 85093B   24186.57634412  .00000010  00000-0  60271-2 0  9995
2 16137  64.0923 281.2460 5553721 338.0242   5.3503  3.90989779553209
0 COSMOS 1690
1 16138U 85094A   24187.60139995  .00000016  00000-0  28808-4 0  9996
2 16138  82.6091 316.5100 0022765 118.6847 252.4110 12.66072748789945
0 COSMOS 1691
1 16139U 85094B   24187.57828586  .00000042  00000-0  17431-3 0  9992
2 16139  82.6118  22.0710 0001058  61.7881   4.7889 12.62443970785447
0 COSMOS 1692
1 16140U 85094C   24187.42976839 -.00000006  00000-0 -89014-4 0  9992
2 16140  82.6024 325.4296 0017537 184.4999 233.5223 12.64912009788393
0 COSMOS 1693
1 16141U 85094D   24187.51596014  .00000003  00000-0 -44328-4 0  9991
2 16141  82.6118 346.3052 0014269 211.6458 217.1908 12.64355041787600
0 COSMOS 1694
1 16142U 85094E   24187.43723442  .00000004  00000-0 -36410-4 0  9994
2 16142  82.6092 355.6924 0010531 243.3865 179.7252 12.63681447786767
0 COSMOS 1695
1 16143U 85094F   24187.57550852  .00000006  00000-0 -23459-4 0  9994
2 16143  82.6036   1.3884 0006213 300.7977 128.3213 12.62893001785913
0 SL-14 R/B
1 16144U 85094G   24187.39963446  .00000002  00000-0 -48114-4 0  9993
2 16144  82.6091 139.7156 0035112 247.2878 231.1029 12.54884026774473
0 COSMOS 1697
1 16181U 85097A   24187.11042645 -.00000069  00000-0 -11170-4 0  9992
2 16181  70.9650  66.7226 0017517   1.8743 358.2441 14.13550753863041
0 SL-16 R/B
1 16182U 85097B   24187.60604338 -.00000206  00000-0 -79450-4 0  9998
2 16182  71.0037 349.0224 0005458 117.7065 311.6538 14.16430445   550
0 COSMOS 1698
1 16183U 85098A   24187.35416885  .00000110  00000-0  00000-0 0  9993
2 16183  71.2067 134.8446 5459299   9.4200 194.7483  2.00676326283452
0 SL-6 R/B(2)
1 16186U 85098D   24187.57914204  .00000413  00000-0  00000-0 0  9994
2 16186  70.3427  44.0731 5764364   5.0983 236.9367  2.03412947287360
0 METEOR 3-1
1 16191U 85100A   24187.47915317 -.00000029  00000-0 -10557-3 0  9995
2 16191  82.5474 179.5789 0019412 341.3525 131.3363 13.17279205860636
0 SL-14 R/B
1 16194U 85100B   24187.56911049  .00001017  00000-0  30213-2 0  9992
2 16194  82.6293  31.1513 0017638 106.5646 306.2965 13.06976374845228
0 COSMOS 1700
1 16199U 85102A   24186.91942588 -.00000244  00000-0  00000-0 0  9990
2 16199  10.9123 323.5840 0007416 190.0562 191.2717  1.00299434144537
0 COSMOS 1375 DEB
1 16202U 82055D   24187.56706559  .00000397  00000-0  33050-3 0  9999
2 16202  65.8297 332.5720 0084638 346.4805  84.3820 13.97775865138589
0 COSMOS 1375 DEB
1 16203U 82055E   24187.56236184  .00000000  00000-0  67862-4 0  9992
2 16203  65.8344 255.4076 0069507 343.8772 129.0213 13.89081735131866
0 COSMOS 1375 DEB
1 16204U 82055F   24187.49386657 -.00000023  00000-0  56611-4 0  9992
2 16204  65.8345  80.1762 0015461 122.6461  52.0828 13.79941272949607
0 COSMOS 1375 DEB
1 16205U 82055G   24187.62846619  .00000343  00000-0  41144-3 0  9995
2 16205  65.8268 134.7375 0053214  45.2338 128.4440 13.78914175939663
0 COSMOS 1375 DEB
1 16206U 82055H   24187.33984248  .00000107  00000-0  19989-3 0  9995
2 16206  65.8333 157.8105 0016702 356.5832 113.1980 13.73670769108584
0 COSMOS 1375 DEB
1 16207U 82055J   24187.59576321 -.00000043  00000-0  45613-4 0  9997
2 16207  65.8366 300.8338 0080359 179.1767 193.6060 13.57652917918391
0 COSMOS 1375 DEB
1 16208U 82055K   24187.59570027 -.00000046  00000-0  36016-4 0  9995
2 16208  65.8356 307.2462 0051078 233.4969 137.3508 13.76093440944262
0 COSMOS 1375 DEB
1 16209U 82055L   24187.48439604 -.00000029  00000-0  56076-4 0  9998
2 16209  65.8336 219.8089 0020625 332.3380 130.0721 13.71364186942824
0 COSMOS 1375 DEB
1 16210U 82055M   24187.01967491 -.00000013  00000-0  71110-4 0  9998
2 16210  65.8348  37.9940 0017793  63.7366  55.4741 13.74508961942023
0 COSMOS 1375 DEB
1 16211U 82055N   24187.57076361  .00000029  00000-0  12279-3 0  9993
2 16211  65.8365 327.8711 0022544  54.6793  21.1236 13.70245247935160
0 SL-12 R/B(2)
1 16214U 85102D   24187.54410991 -.00000275  00000-0  00000-0 0  9990
2 16214  10.6629 322.7686 0023027 143.9209 146.3183  1.00620045117683
0 LEASAT 3 PKM
1 16229U 85028E   24186.98068789  .00004555  00000-0  14980-2 0  9992
2 16229  26.9190  67.4391 4742772 138.2233 269.8351  5.98190151666993
0 RADUGA 17
1 16250U 85107A   24187.11753985 -.00000008  00000-0  00000-0 0  9995
2 16250  10.8207 323.0946 0015295 203.0830 162.7224  1.00178823144541
0 COSMOS 1703
1 16262U 85108A   24187.59879606  .00009852  00000-0  39568-3 0  9999
2 16262  82.4691 228.9953 0008813  42.0563 318.1350 15.24785245108000
0 SL-14 R/B
1 16263U 85108B   24187.60446483  .00000665  00000-0  76093-4 0  9993
2 16263  82.5020 217.1956 0020695 139.3709 337.4929 14.84319887 65081
0 COSMOS 1691 DEB
1 16266U 85094K   24187.51597324  .00000093  00000-0  43435-3 0  9999
2 16266  82.6043 342.5870 0010532 170.7704 255.7736 12.66335745787393
0 COSMOS 1691 DEB
1 16267U 85094L   24187.30511108  .00005224  00000-0  13838-1 0  9996
2 16267  82.6308 291.9235 0077999 150.5543 237.5735 13.14480184450630
0 COSMOS 1691 DEB
1 16268U 85094M   24187.31082043  .00000267  00000-0  15403-2 0  9992
2 16268  82.7101 281.4885 0077859 294.2879 121.7824 12.56214797767422
0 COSMOS 1691 DEB
1 16269U 85094N   24187.39872285  .00000062  00000-0  28535-3 0  9990
2 16269  82.6233  42.5935 0010856 296.0089 241.1475 12.62237812783828
0 COSMOS 1691 DEB
1 16270U 85094P   24187.19691407  .00000162  00000-0  68487-3 0  9996
2 16270  82.7305  76.5519 0259305 245.8585 275.6657 12.68833358791470
0 COSMOS 1691 DEB
1 16271U 85094Q   24187.47139008  .00000024  00000-0  71833-4 0  9999
2 16271  82.6081   7.3248 0005000 316.4041  71.4232 12.63007984785663
0 COSMOS 1691 DEB
1 16272U 85094R   24187.39797914  .00000364  00000-0  16577-2 0  9996
2 16272  82.6159 239.0178 0049282 161.2546 214.3488 12.74749870797306
0 MORELOS 2
1 16274U 85109B   24186.95738346 -.00000157  00000-0  00000-0 0  9993
2 16274  14.7448   2.0409 0008214 130.7030  52.4850  0.99561000 39268
0 OPTUS A2 (AUSSAT 2)
1 16275U 85109C   24186.58555888  .00000087  00000-0  00000-0 0  9992
2 16275  13.9280 345.3321 0001050 223.8084 131.2544  0.99945564 39407
0 SATCOM K2
1 16276U 85109D   24186.72201065 -.00000164  00000-0  00000-0 0  9991
2 16276  14.8497 357.7769 0007839 228.6138 129.5159  0.99615277118499
0 COSMOS 1704
1 16291U 85110A   24187.52918558  .00000075  00000-0  63194-4 0  9998
2 16291  82.9361 292.3185 0029702 240.8296 130.0588 13.74785016936152
0 SL-8 R/B
1 16292U 85110B   24187.56527502  .00000138  00000-0  12345-3 0  9999
2 16292  82.9300 246.6411 0031719  82.3059 278.1699 13.77131980939223
0 MORELOS 2 R/B(PAM-D)
1 16293U 85109F   24187.05349400  .00001436  00000-0  16510-2 0  9990
2 16293  25.6994  92.7458 7176873 320.8974   4.9064  2.36551344263877
0 OPTUS A2 R/B(PAM-D)
1 16294U 85109G   24186.98628033  .00000652  00000-0  13457-2 0  9990
2 16294  26.1074  70.4390 7150348 131.3693 316.4940  2.37663256285250
0 SATCOM K2 R/B(PAM-D2)
1 16295U 85109H   24187.32239769  .00001464  00000-0  24994-2 0  9994
2 16295  26.4335 284.0540 7131236 165.2345 238.8486  2.41472849258612
0 COSMOS 1707
1 16326U 85113A   24187.47602934  .00011666  00000-0  41137-3 0  9992
2 16326  82.5013 186.2548 0007297  32.3030 327.8655 15.29111952107290
0 SL-14 R/B
1 16327U 85113B   24187.54695420  .00000675  00000-0  76673-4 0  9995
2 16327  82.5328 203.7765 0019907 129.2543 346.2807 14.84652710 62591
0 SL-12 R/B(2)
1 16339U 85107F   24187.48507337 -.00000168  00000-0  00000-0 0  9998
2 16339  12.2083 327.4807 0020341 115.6363 153.7772  0.97495978120436
0 COSMOS 1709
1 16368U 85116A   24187.49963903  .00000071  00000-0  59523-4 0  9996
2 16368  82.9458 279.8239 0033777 310.1336  61.2028 13.74607960933069
0 SL-8 R/B
1 16369U 85116B   24187.61612598  .00000152  00000-0  13783-3 0  9999
2 16369  82.9357 232.7553 0037108 149.5320 322.0648 13.77035839936088
0 COSMOS 1375 DEB
1 16375U 82055P   24187.46266387  .00000037  00000-0  11352-3 0  9991
2 16375  65.8345  84.9950 0021298 159.7442  14.1143 13.80323421949782
0 COSMOS 1375 DEB
1 16376U 82055Q   24187.53550895  .00000932  00000-0  75709-3 0  9990
2 16376  65.8287 327.0109 0013371  34.3620  36.8046 13.94785999960709
0 COSMOS 1375 DEB
1 16377U 82055R   24187.08709002  .00001270  00000-0  85969-3 0  9992
2 16377  65.8251  53.6997 0033857  24.1183 138.7362 14.03566613966968
0 COSMOS 1375 DEB
1 16378U 82055S   24187.45102922  .00000105  00000-0  17504-3 0  9998
2 16378  65.8331  70.1102 0030931 177.0705 356.8266 13.81328983950014
0 COSMOS 1375 DEB
1 16379U 82055T   24187.42770267 -.00000026  00000-0  55022-4 0  9990
2 16379  65.8348 194.5981 0007638  84.7008  26.8575 13.78049038527022
0 COSMOS 1375 DEB
1 16380U 82055U   24187.55740010 -.00000062  00000-0  20334-4 0  9997
2 16380  65.8377 299.5431 0040940  99.3365 272.3837 13.63941797927438
0 COSMOS 1375 DEB
1 16381U 82055V   24187.61560751 -.00000047  00000-0  39360-4 0  9999
2 16381  65.8384 319.0314 0056052 144.3851 227.6611 13.63603988926975
0 COSMOS 1375 DEB
1 16382U 82055W   24187.18457322  .00006532  00000-0  23449-2 0  9994
2 16382  65.7427 106.5721 0039558 263.1755 211.6114 14.34025999987729
0 COSMOS 1375 DEB
1 16383U 82055X   24187.55621774  .00000340  00000-0  43501-3 0  9993
2 16383  65.8285 240.5803 0050500 337.2997 137.4735 13.75186465937228
0 COSMOS 1375 DEB
1 16384U 82055Y   24187.07039627  .00000165  00000-0  27759-3 0  9993
2 16384  65.8335  40.5306 0034770  31.2240 125.1910 13.69945700933272
0 COSMOS 1375 DEB
1 16385U 82055Z   24187.06512925  .00000848  00000-0  80775-3 0  9995
2 16385  65.8280 159.2028 0038638 273.5521 155.0072 13.85712387947593
0 COSMOS 1375 DEB
1 16386U 82055AA  24187.60146019 -.00000071  00000-0  96699-5 0  9996
2 16386  65.8377 322.1809 0048508 324.5104 118.3455 13.69685917104806
0 COSMOS 1375 DEB
1 16387U 82055AB  24187.38549184 -.00000035  00000-0  42169-4 0  9994
2 16387  65.8354 151.1403 0043730  50.6135 115.3090 13.84848297956429
0 SL-16 DEB
1 16389U 85097C   24187.55780322  .00000148  00000-0  17110-3 0  9996
2 16389  71.0009 124.9804 0186731 115.5868 246.4665 13.76457225943140
0 SL-16 DEB
1 16390U 85097D   24187.59601246  .00000056  00000-0  92892-4 0  9998
2 16390  70.9742 262.4670 0207771 343.1758  16.2518 13.72423877937176
0 SL-16 DEB
1 16391U 85097E   24187.48989514  .00000129  00000-0  15280-3 0  9990
2 16391  70.9949  98.2893 0188877 136.4907  35.9787 13.76909093943831
0 SL-16 DEB
1 16392U 85097F   24187.35670767  .00000113  00000-0  14276-3 0  9991
2 16392  70.9688 159.2472 0202636 244.8206 269.7895 13.74718316940309
0 MOLNIYA 3-27
1 16393U 85117A   24186.81990341 -.00000039  00000-0  00000-0 0  9993
2 16393  63.3625 334.7185 7177397 245.7568  27.3183  2.12400418290072
0 COSMOS 1710 (GLONASS)
1 16396U 85118A   24185.59663772 -.00000077  00000-0  00000-0 0  9998
2 16396  66.3213 347.7852 0012556 199.7453 150.6810  2.13102843299916
0 COSMOS 1711 (GLONASS)
1 16397U 85118B   24187.59632214 -.00000083  00000-0  00000-0 0  9995
2 16397  66.3354 347.9159 0009067 190.6781 228.7430  2.13101856299594
0 COSMOS 1712 (GLONASS)
1 16398U 85118C   24186.43989204 -.00000080  00000-0  00000-0 0  9999
2 16398  66.3274 348.5127 0010707  15.8737 344.3604  2.12920045298876
0 SL-6 R/B(2)
1 16402U 85117F   24185.92254411  .00001001  00000-0  00000-0 0  9995
2 16402  63.6673 126.1686 7019102 252.5796  24.7927  1.96547301276554
0 SL-12 R/B(2)
1 16404U 85118F   24184.88027550 -.00000073  00000-0  00000-0 0  9993
2 16404  66.3183 347.5397 0007341  19.8030 325.2604  2.13165575300064
0 METEOR 2-13
1 16408U 85119A   24187.50142780  .00000064  00000-0  43462-4 0  9995
2 16408  82.5370 101.5049 0015306 326.3145  33.7042 13.85484436947459
0 SL-14 R/B
1 16409U 85119B   24187.52283512  .00000041  00000-0  23158-4 0  9992
2 16409  82.5376 109.0908 0014904 358.4490   1.6622 13.84873692947256
0 SL-12 R/B(AUX MOTOR)
1 16445U 85118K   24186.98949441  .00000522  00000-0  14384-2 0  9993
2 16445  65.0017  93.4458 5723861  32.1106 352.5600  4.26524736591172
0 SL-12 R/B(AUX MOTOR)
1 16446U 85118L   24187.39272538  .00000218  00000-0  33605-3 0  9996
2 16446  64.8828 243.2612 5626936  42.5538 349.5187  4.40220230606481
0 COSMOS 1716
1 16449U 86002A   24187.55429115  .00000008  00000-0  15973-3 0  9990
2 16449  73.9885 262.4838 0017176 108.2177 355.2109 12.46902096752117
0 COSMOS 1717
1 16450U 86002B   24187.60517304  .00000005  00000-0  14883-3 0  9992
2 16450  73.9897  38.8015 0024338 317.8869 104.4813 12.42976609746372
0 COSMOS 1718
1 16451U 86002C   24187.53096516 -.00000026  00000-0 -74243-4 0  9994
2 16451  73.9908 325.8374 0013515 219.8109 211.4633 12.45078711749299
0 COSMOS 1719
1 16452U 86002D   24187.46852179 -.00000002  00000-0  94247-4 0  9991
2 16452  73.9864 194.5803 0018986 352.2502 117.6737 12.48863147754651
0 COSMOS 1720
1 16453U 86002E   24187.31347873 -.00000030  00000-0 -88274-4 0  9991
2 16453  73.9883 133.1265 0028559 277.0004 251.5435 12.50617837757126
0 COSMOS 1721
1 16454U 86002F   24187.19353080  .00000006  00000-0  14294-3 0  9996
2 16454  73.9895  72.2044 0036468 200.6679 335.8225 12.52367699759569
0 COSMOS 1722
1 16455U 86002G   24187.61167924 -.00000003  00000-0  80203-4 0  9996
2 16455  73.9899  13.1719 0045593 133.6762 297.3415 12.54023890761856
0 COSMOS 1723
1 16456U 86002H   24187.60167716 -.00000017  00000-0 -64394-5 0  9995
2 16456  73.9908 311.2391 0052160  52.2954 320.0630 12.55785808764315
0 SL-8 R/B
1 16457U 86002J   24187.45288201 -.00000001  00000-0  12522-3 0  9998
2 16457  73.9919  73.8261 0134324 121.1895  51.1618 12.20753507618856
0 SATCOM K1
1 16482U 86003B   24186.25559812 -.00000231  00000-0  00000-0 0  9993
2 16482  14.8678 356.4827 0006140 153.6037 211.5035  0.99561780117357
0 SATCOM K1 R/B(PAM-D2)
1 16483U 86003C   24187.14944722  .00002365  00000-0  18286-2 0  9997
2 16483  27.0548  96.4495 7097385 344.0613   1.9937  2.48308579336442
0 COSMOS 1725
1 16493U 86005A   24187.56475663  .00000061  00000-0  48361-4 0  9999
2 16493  82.9337 350.9757 0022706  20.7124  46.3487 13.74807684974400
0 SL-8 R/B
1 16494U 86005B   24187.61265866  .00000052  00000-0  37604-4 0  9996
2 16494  82.9330 316.0638 0018430 233.4660 137.0181 13.76649561931976
0 COSMOS 1726
1 16495U 86006A   24187.48007615  .00057771  00000-0  64083-3 0  9999
2 16495  82.4578 344.5917 0005060  92.1871 267.9966 15.62705801109621
0 SL-14 R/B
1 16496U 86006B   24187.31726068  .00000715  00000-0  80156-4 0  9998
2 16496  82.5253 115.4406 0018150 202.0217 275.4685 14.85344417 58251
0 RADUGA 18
1 16497U 86007A   24187.45500031  .00000026  00000-0  00000-0 0  9996
2 16497  11.6771 325.9084 0074932 182.9524 185.9927  0.98811093138832
0 COSMOS 1727
1 16510U 86008A   24187.61579125  .00000059  00000-0  45773-4 0  9997
2 16510  82.9490 139.3710 0039311  57.5108 115.4333 13.74559306927982
0 SL-8 R/B
1 16511U 86008B   24187.52968523  .00000074  00000-0  60572-4 0  9993
2 16511  82.9443 109.9506 0022826 289.8450 243.7636 13.75891609930138
0 STTW-1
1 16526U 86010A   24186.98606175  .00000021  00000-0  00000-0 0  9991
2 16526  11.6840 328.3977 0002826 194.5188 177.2895  1.00217471148325
0 COSMOS 1729
1 16527U 86011A   24183.25788604  .00000166  00000-0  00000+0 0  9997
2 16527  70.7620 212.8237 4203154  60.6203  72.2893  2.00644796281501
0 CZ-3 R/B
1 16528U 86010B   24186.85354732 -.00000113  00000-0  43317-3 0  9992
2 16528  30.6395 132.8060 7147729 178.0635 188.2971  2.32129490272758
0 SL-6 R/B(2)
1 16533U 86011F   24187.45569498 -.00000282  00000-0  00000-0 0  9999
2 16533  71.0716 154.5854 5333788  21.7731 130.2150  2.04051913269534
0 USA 15
1 16591U 86014A   24187.56525488  .00020136  00000-0  10411-2 0  9997
2 16591  63.2896 135.2616 0812203  99.1539 270.2217 13.84147527  8162
0 ATLAS H R/B
1 16592U 86014B   24187.58947611  .00001747  00000-0  13050-2 0  9995
2 16592  63.3344 321.7507 0357066 133.3390 229.8003 13.71216756262522
0 COSMOS 1732
1 16593U 86015A   24187.47264360 -.00000013  00000-0  32834-4 0  9997
2 16593  73.6081 179.1504 0026516   3.0687 357.0515 12.41009671739525
0 SL-14 R/B
1 16594U 86015B   24187.41696682 -.00000034  00000-0 -12009-3 0  9993
2 16594  73.6083 161.4652 0026995 352.4019 120.9342 12.41497330740156
0 BS-2B (YURI 2B)
1 16597U 86016A   24187.05304953  .00000040  00000-0  00000-0 0  9994
2 16597  13.0977 337.2073 0015868 192.2509 171.6603  0.99289707121052
0 COSMOS 1733
1 16611U 86018A   24187.51267174  .00014916  00000-0  43231-3 0  9990
2 16611  82.4813 355.7402 0008551   9.5198 350.6205 15.35389191 99846
0 SL-14 R/B
1 16612U 86018B   24187.57966672  .00000660  00000-0  73636-4 0  9990
2 16612  82.5156  39.1182 0015753 291.4723  68.4813 14.85483345952425
0 SPOT 1
1 16613U 86019A   24187.56953759  .00002122  00000-0  33385-3 0  9994
2 16613  98.6989  65.6440 0136193 331.4788  27.9010 14.67721670706452
0 VIKING
1 16614U 86019B   24187.33935973 -.00000002  00000-0 -37137-4 0  9995
2 16614  98.7698 128.1017 4695864 257.8512 329.0541  5.50580755771064
0 ARIANE 1 R/B
1 16615U 86019C   24187.63290830  .00000426  00000-0  17197-3 0  9996
2 16615  98.2762 223.4942 0011272 350.0781 124.4052 14.32564480  7976
0 ARIANE 1 DEB
1 16616U 86019D   24187.62677536  .00000586  00000-0  24208-3 0  9996
2 16616  98.2734 207.3173 0007805 173.3384 299.0830 14.30188257996506
0 USA 16
1 16624U 86014E   24187.52028877  .00007306  00000-0  62255-3 0  9998
2 16624  63.2978 247.6556 0867405 103.0213 266.9019 13.60658817251636
0 USA 17
1 16625U 86014F   24187.49019289  .00007576  00000-0  63121-3 0  9994
2 16625  63.2979 238.7545 0862440 102.6434 267.2335 13.62246306245356
0 USA 18
1 16631U 86014H   24187.40735320  .00011806  00000-0  67837-3 0  9992
2 16631  63.2888 213.1099 0861307  98.5039 271.4459 13.71596859245870
0 COSMOS 1736
1 16647U 86024A   24187.63318218 -.00000056  00000-0  30708-4 0  9992
2 16647  64.9897 320.3047 0027376  76.1185 295.4205 13.79499957930283
0 GSTAR 2
1 16649U 86026A   24186.93035613 -.00000304  00000-0  00000-0 0  9997
2 16649  14.5689 351.2064 0004059  91.0564 134.9435  0.99800191109539
0 BRAZILSAT 2
1 16650U 86026B   24186.75542733 -.00000250  00000-0  00000-0 0  9995
2 16650  14.7401 355.7614 0001679 103.5092  77.2582  0.99646214 39285
0 ARIANE 3 R/B
1 16657U 86026C   24186.92444101  .00000043  00000-0  51904-3 0  9992
2 16657   7.0755 340.3544 7211959  30.9003 356.3901  2.25324185263878
0 COSMOS 1738
1 16667U 86027A   24187.21091181 -.00000293  00000-0  00000-0 0  9999
2 16667  11.4821 323.0440 0015810 132.5853  44.9399  1.00249228140217
0 SL-12 R/B(2)
1 16676U 86027F   24187.60897024 -.00000189  00000-0  00000-0 0  9996
2 16676  12.8592 327.6805 0038554 132.4713 192.5832  0.97691643113068
0 COSMOS 1741
1 16681U 86030A   24187.57659730  .00000209  00000-0  85096-4 0  9996
2 16681  74.0239 270.2786 0019064   0.0465   0.0684 14.33467607997268
0 SL-8 R/B
1 16682U 86030B   24187.40414830  .00000282  00000-0  10470-3 0  9993
2 16682  74.0239 175.7007 0015860 251.0449 216.8252 14.36633475   505
0 THORAD AGENA D DEB
1 16715U 70025PA  24187.63343078  .00000235  00000-0  37300-3 0  9996
2 16715 100.0561 331.1663 0007069  55.2859 319.3995 13.60916644948936
0 COSMOS 1743
1 16719U 86034A   24187.46470532  .00009560  00000-0  34413-3 0  9996
2 16719  82.5466 339.4016 0008823 332.9137  27.1641 15.28412856 85930
0 SL-14 R/B
1 16720U 86034B   24187.58038672  .00000729  00000-0  83362-4 0  9992
2 16720  82.5539 359.4493 0018320 239.7195 188.6048 14.84554054 40017
0 COSMOS 1745
1 16727U 86037A   24187.59488632  .00000079  00000-0  67793-4 0  9996
2 16727  82.9583 270.8802 0031981  30.3071  91.0394 13.74312188911413
0 SL-8 R/B
1 16728U 86037B   24187.57640403  .00000144  00000-0  13014-3 0  9990
2 16728  82.9535 227.4811 0030488 194.3069 276.5507 13.76927705914685
0 EKRAN 15
1 16729U 86038A   24187.11936733 -.00000137  00000-0  00000-0 0  9997
2 16729  12.6119 326.9760 0006865   3.3464   9.1264  0.96547030111486
0 SL-12 R/B(2)
1 16732U 86038D   24187.56819117  .00000050  00000-0  00000-0 0  9999
2 16732  10.0340 318.6293 0023660 163.5333 168.4167  1.01368200117320
0 METEOR 2-14
1 16735U 86039A   24187.62713328  .00000060  00000-0  39368-4 0  9991
2 16735  82.5366 131.1627 0015872  48.1797 124.9965 13.85435931926177
0 SL-14 R/B
1 16736U 86039B   24187.57659725  .00000030  00000-0  13475-4 0  9994
2 16736  82.5385 137.2359 0014211  66.7827 293.4828 13.84809431925868
0 COSMOS 1748
1 16758U 86042A   24187.41517117 -.00000022  00000-0 -37526-4 0  9999
2 16758  74.0165 161.8136 0009844  83.1380  33.9721 12.50770681738837
0 COSMOS 1749
1 16759U 86042B   24187.57012914  .00000009  00000-0  14578-3 0  9996
2 16759  74.0181 267.2136 0047829 133.5053 333.8839 12.58089208748940
0 COSMOS 1750
1 16760U 86042C   24187.61449859 -.00000023  00000-0 -41111-4 0  9997
2 16760  74.0200 334.8053 0039735 221.1874 218.2426 12.56147916746254
0 COSMOS 1751
1 16761U 86042D   24187.57832693 -.00000011  00000-0  32938-4 0  9998
2 16761  74.0195   4.1100 0023856  80.1061 338.8461 12.44876851730857
0 COSMOS 1752
1 16762U 86042E   24187.58467376 -.00000008  00000-0  51589-4 0  9991
2 16762  74.0192 291.0630 0011820 357.2508  14.5966 12.46999733733614
0 COSMOS 1753
1 16763U 86042F   24187.60253904  .00000017  00000-0  21891-3 0  9996
2 16763  74.0155 226.0732 0010433 225.6954 252.3233 12.48887908736240
0 COSMOS 1754
1 16764U 86042G   24187.51319047 -.00000011  00000-0  32056-4 0  9999
2 16764  74.0184  98.4802 0020311   4.3492 168.8378 12.52592763565975
0 COSMOS 1755
1 16765U 86042H   24187.60391543  .00000012  00000-0  17560-3 0  9993
2 16765  74.0189  38.4748 0029539 290.8200 133.2126 12.54325590743748
0 SL-8 R/B
1 16766U 86042J   24187.54930094  .00000057  00000-0  64493-3 0  9993
2 16766  74.0113 352.8595 0133092 207.7594 210.5369 12.23561596700905
0 GORIZONT 12
1 16769U 86044A   24187.51430142 -.00000334  00000-0  00000-0 0  9994
2 16769  11.1892 325.8513 0002169 239.1253   9.4459  1.00237653140129
0 COSMOS 1758
1 16791U 86046A   24187.59843096  .00006498  00000-0  35691-3 0  9998
2 16791  82.4635  35.2949 0017261 310.4366  49.5359 15.13823725 73075
0 SL-14 R/B
1 16792U 86046B   24187.55804462  .00000811  00000-0  93050-4 0  9996
2 16792  82.4832 298.0033 0025127  89.9999 270.4096 14.84433157 56671
0 SL-12 R/B(2)
1 16797U 86044F   24187.54782937 -.00000174  00000-0  00000-0 0  9992
2 16797  12.4484 329.7867 0012159 181.2596 108.5450  0.97670896135898
0 COSMOS 1759
1 16798U 86047A   24187.56187245  .00000068  00000-0  55117-4 0  9993
2 16798  82.9210 357.3844 0025935  79.3558 345.1685 13.75093602908892
0 SL-8 R/B
1 16799U 86047B   24187.62963529  .00000060  00000-0  45424-4 0  9990
2 16799  82.9209 317.5982 0065092 264.1584  95.2150 13.77480342845560
0 COSMOS 1736 FUEL CORE
1 16809U 86024E   24187.42740470 -.00000078  00000-0  92570-5 0  9998
2 16809  64.9871 181.5049 0017267  48.9071 113.3742 13.81674579933783
0 COSMOS 1761
1 16849U 86050A   24187.54000655  .00000374  00000-0  00000-0 0  9998
2 16849  69.8140  81.4568 5810893  23.2903 104.4833  2.00600478278314
0 SL-6 R/B(2)
1 16854U 86050D   24187.33830476 -.00000700  00000-0  00000-0 0  9997
2 16854  67.3777 342.5818 6386915  14.9158 359.2870  2.02808849281512
0 COSMOS 1763
1 16860U 86052A   24187.18764520  .00000245  00000-0  87874-4 0  9996
2 16860  74.0337  80.3983 0032014 261.5742  98.1783 14.38762656991378
0 SL-8 R/B
1 16864U 86052B   24187.60038726  .00000453  00000-0  14709-3 0  9996
2 16864  74.0295   7.6291 0032934 195.2570 164.7596 14.41424035993556
0 SL-8 DEB
1 16867U 86052E   24187.46656740  .00007956  00000-0  87268-3 0  9990
2 16867  74.0167 229.9866 0014921 303.6198  56.3558 14.87781264 22121
0 SL-12 R/B(2)
1 16870U 86007F   24186.74716019 -.00000110  00000-0  00000-0 0  9992
2 16870  12.1958 327.2659 0035151 158.9784   5.3133  0.97799512135677
0 COSMOS 1766
1 16881U 86055A   24187.60516971  .00010888  00000-0  44447-3 0  9996
2 16881  82.4994  13.4642 0011451 207.7703 152.2924 15.24220941 49604
0 SL-14 R/B
1 16882U 86055B   24187.50285117  .00000850  00000-0  97915-4 0  9998
2 16882  82.5215 341.6225 0018995 191.8284 229.6578 14.84454242 28500
0 EGS (AJISAI)
1 16908U 86061A   24187.55358007 -.00000109  00000-0 -82249-4 0  9991
2 16908  50.0064 175.6366 0011262 169.1420 349.6198 12.44506523391779
0 JAS 1 (FUJI 1)
1 16909U 86061B   24187.43576352 -.00000097  00000-0  17391-5 0  9996
2 16909  50.0120 181.5705 0011131 150.5791  14.8053 12.44479543723463
0 H-1 R/B(MABES)
1 16910U 86061C   24187.30949574 -.00000089  00000-0  37515-4 0  9994
2 16910  50.0064  37.7238 0072284 299.1371 232.1011 12.32631011706642
0 COSMOS 1771
1 16917U 86062A   24187.26354080 -.00000048  00000-0  37144-4 0  9992
2 16917  64.9841  32.7751 0051445 190.4265 169.5732 13.82582805913344
0 COSMOS 1777
1 16952U 86070A   24187.59366823  .00000210  00000-0  85095-4 0  9992
2 16952  74.0060 347.2308 0026707 305.8853  53.9819 14.33619127976906
0 SL-8 R/B
1 16953U 86070B   24187.52800480  .00000402  00000-0  14118-3 0  9998
2 16953  74.0098 209.9611 0012049 183.7602 176.3464 14.38116283981865
0 COSMOS 1778 (GLONASS)
1 16961U 86071A   24187.26627531 -.00000039  00000-0  00000-0 0  9992
2 16961  64.5115  96.7907 0004686 216.5390 320.1316  2.13102153294206
0 COSMOS 1779 (GLONASS)
1 16962U 86071B   24184.36961916 -.00000051  00000-0  00000-0 0  9993
2 16962  64.5136  96.9610 0012563  40.4191 123.7305  2.13102733294017
0 COSMOS 1780 (GLONASS)
1 16963U 86071C   24186.73506208 -.00000044  00000-0  00000-0 0  9998
2 16963  64.5028  96.5972 0003039 344.0136 205.0595  2.13107751294149
0 SL-12 R/B(2)
1 16968U 86071F   24183.28799498 -.00000046  00000-0  00000-0 0  9997
2 16968  64.5204  96.0474 0026063 220.0022 322.8466  2.13265966294330
0 NOAA 10
1 16969U 86073A   24187.56547737  .00000239  00000-0  11252-3 0  9999
2 16969  98.6411 173.3259 0010931 279.8164 189.9786 14.28641934967779
0 COSMOS 1782
1 16986U 86074A   24187.34251648  .00007432  00000-0  36887-3 0  9991
2 16986  82.5333 130.1537 0006681 186.3360 173.7790 15.17532067 37937
0 SL-14 R/B
1 16987U 86074B   24187.61993073  .00000687  00000-0  78938-4 0  9996
2 16987  82.5151  57.4808 0019152  55.7359   4.2941 14.84229177 19138
0 COSMOS 1783
1 16993U 86075A   24187.36761500  .00832394  34554-5  53350-3 0  9998
2 16993  62.0355  53.9894 1921840  67.2314 311.9805 11.94762309613871
0 SL-6 R/B(2)
1 16996U 86075D   24187.31400180  .00061406  87990-6  37142-3 0  9992
2 16996  62.2197 330.6049 4846295 302.6955  19.4926  6.06357857566222
0 DELTA 1 DEB
1 17000U 76077EX  24187.39893381  .00000348  00000-0  62750-2 0  9998
2 17000 102.4977   2.0772 0688608 357.0102  29.3740 11.31730746656197
0 COSMOS 839 DEB
1 17018U 76067BJ  24187.43887012  .00000202  00000-0  87807-3 0  9995
2 17018  66.0232  42.3667 0626055  22.7295  33.0947 12.46475255795117
0 THORAD DELTA 1 DEB
1 17023U 74089EW  24186.81885997  .00000162  00000-0  11153-2 0  9999
2 17023 101.4163 152.3372 0050538 258.6174 130.0573 12.64363251818669
0 DELTA 1 DEB
1 17024U 77065FT  24187.49286777  .00000168  00000-0  28406-3 0  9999
2 17024  29.4344 254.9533 0863456  68.6352 300.4073 12.34832917468516
0 COSMOS 1275 DEB
1 17025U 81053KF  24187.14868696  .00000825  00000-0  75700-3 0  9999
2 17025  82.8256 254.5500 0072424 252.3572 136.8251 13.80661826965933
0 COSMOS 1771 FUEL CORE
1 17035U 86062C   24187.45259848 -.00000094  00000-0 -43653-5 0  9996
2 17035  64.9917 166.9889 0029272 158.7949 335.8127 13.86425437909949
0 RADUGA 19
1 17046U 86082A   24186.98640984  .00000007  00000-0  00000-0 0  9998
2 17046  12.2073 330.0030 0014299 169.7649 202.4870  0.98458747135904
0 SL-12 R/B(2)
1 17065U 86082F   24186.98736708 -.00000048  00000-0  00000-0 0  9995
2 17065  12.6437 330.9033 0030472 153.7472 222.9811  0.97597190108731
0 COSMOS 1791
1 17066U 86086A   24187.60162785  .00000109  00000-0  96276-4 0  9999
2 17066  82.9468  69.1465 0042260  68.6628 355.9348 13.75932429890335
0 SL-8 R/B
1 17067U 86086B   24187.62335630  .00000152  00000-0  13633-3 0  9996
2 17067  82.9430  34.8338 0033308 318.2462  95.7199 13.77943127892341
0 POLAR BEAR
1 17070U 86088A   24187.57088412  .00000135  00000-0  12916-3 0  9993
2 17070  89.6016 204.9762 0037093 264.5420 211.8511 13.75062674887612
0 SCOUT G-1 R/B
1 17071U 86088B   24187.60366963  .00000146  00000-0  13996-3 0  9999
2 17071  89.5994 196.7899 0036660 243.4128 116.3279 13.75398117887902
0 MOLNIYA 1-69
1 17078U 86089A   24169.19921634 -.00000930  00000-0  00000+0 0  9993
2 17078  63.8371 110.4433 7028870 252.9103  24.5014  2.00458133275515
0 SL-6 R/B(2)
1 17081U 86089D   24186.42245516 -.00000353  00000-0  00000+0 0  9999
2 17081  63.5899 196.8530 6629585 257.0457  26.4630  1.95715052269027
0 GORIZONT 13
1 17083U 86090A   24186.31989126 -.00000138  00000-0  00000-0 0  9995
2 17083  13.2211 333.3741 0012335 351.5158  23.6704  0.96726820111754
0 COSMOS 1375 DEB
1 17090U 82055AC  24187.41166187 -.00000019  00000-0  56997-4 0  9994
2 17090  65.8334 204.9337 0047243   6.8638  98.5943 13.83930445953158
0 OPS 4682 DEB
1 17093U 65027U   24187.42670619 -.00000161  00000-0 -57705-3 0  9994
2 17093  90.2393 352.8789 0027322  99.8261 288.9923 12.97729127854646
0 COSMOS 1375 DEB
1 17102U 82055AD  24187.51248199 -.00000036  00000-0  54225-4 0  9994
2 17102  65.8350 108.5671 0065046 113.5300  59.4886 13.60974596922982
0 COSMOS 1375 DEB
1 17103U 82055AE  24187.18701247  .00000509  00000-0  59696-3 0  9996
2 17103  65.8288 102.4980 0027401 343.7910 167.4142 13.76875362940394
0 COSMOS 1375 DEB
1 17104U 82055AF  24187.53777664  .00000219  00000-0  30959-3 0  9991
2 17104  65.8341 112.0496 0043939 295.0119 240.3207 13.75476822940275
0 COSMOS 1375 DEB
1 17105U 82055AG  24187.38659477  .00000322  00000-0  42193-3 0  9994
2 17105  65.8294 177.8867 0023416  22.8926 124.8958 13.74795026938538
0 COSMOS 1375 DEB
1 17106U 82055AH  24187.15902485  .00000460  00000-0  47547-3 0  9991
2 17106  65.8307 326.3020 0018710 178.1150 356.6883 13.85399357121626
0 COSMOS 1375 DEB
1 17107U 82055AJ  24187.39469324  .00001706  00000-0  11207-2 0  9995
2 17107  65.8214  45.0726 0020576  22.9438 151.0355 14.04491304967110
0 COSMOS 1375 DEB
1 17108U 82055AK  24187.33179620  .00000616  00000-0  65839-3 0  9997
2 17108  65.8317 277.8675 0026913 290.9317 130.0399 13.80973062944453
0 ARIANE 1 DEB
1 17117U 86019M   24187.61547885  .00007012  00000-0  17659-2 0  9997
2 17117  98.2381 207.7896 0075396 357.5749 118.8796 14.49738897956087
0 ARIANE 1 DEB
1 17118U 86019N   24187.61874567  .00002796  00000-0  10871-2 0  9991
2 17118  98.5399 210.8149 0129753 259.6250 219.1460 14.26106272933283
0 ARIANE 1 DEB
1 17121U 86019R   24187.57456896  .00001880  00000-0  69150-3 0  9999
2 17121  98.2697 196.9218 0057037  34.3316  85.0683 14.32836091955593
0 ARIANE 1 DEB
1 17122U 86019S   24187.45009459  .00022936  00000-0  16633-2 0  9998
2 17122  97.7968 246.3376 0005136 273.7710  96.7562 15.03921372993744
0 SL-12 R/B(2)
1 17125U 86090D   24187.00315048  .00000131  00000-0  00000-0 0  9997
2 17125  11.4389 327.5052 0012063 162.0463 198.0588  1.00193166137728
0 ARIANE 1 DEB
1 17129U 86019Y   24187.57816620  .00000328  00000-0  15501-3 0  9999
2 17129  98.3599 222.1645 0033995 118.1510 357.8200 14.25506565905236
0 COSMOS 1794
1 17138U 86092A   24187.52580590 -.00000024  00000-0 -58516-4 0  9998
2 17138  74.0160 330.6617 0021514 288.6061 136.5627 12.45653494710685
0 COSMOS 1795
1 17139U 86092B   24187.56219228  .00000015  00000-0  20611-3 0  9992
2 17139  74.0130 257.4701 0009939 188.1017 281.3253 12.47798611713775
0 COSMOS 1796
1 17140U 86092C   24187.50515281  .00000001  00000-0  11412-3 0  9990
2 17140  74.0109 195.3203 0014788  67.0114  50.4468 12.49626125716274
0 COSMOS 1797
1 17141U 86092D   24187.55626888 -.00000025  00000-0 -57830-4 0  9995
2 17141  74.0137 127.3373 0018891 310.5095 224.2300 12.51626410718977
0 COSMOS 1798
1 17142U 86092E   24187.39177501  .00000008  00000-0  14977-3 0  9994
2 17142  74.0141  64.5672 0028751 236.0446 298.2669 12.53457476721468
0 COSMOS 1799
1 17143U 86092F   24187.59697804 -.00000006  00000-0  59976-4 0  9998
2 17143  74.0153   2.6960 0037279 159.7161 265.7309 12.55260041723964
0 COSMOS 1800
1 17144U 86092G   24187.63047704 -.00000017  00000-0 -64747-5 0  9998
2 17144  74.0154 301.5206 0047059  90.7137 282.2266 12.57027166726380
0 COSMOS 1801
1 17145U 86092H   24187.57668896  .00000024  00000-0  23294-3 0  9999
2 17145  74.0119 239.0317 0054649   9.9184 109.4491 12.58834785728888
0 SL-8 R/B
1 17146U 86092J   24187.57110803  .00000003  00000-0  15677-3 0  9993
2 17146  74.0164 341.3230 0124024  68.7147 357.6762 12.23654676680669
0 SL-6 R/B(2)
1 17147U 86091D   24186.84227366 -.00000016  00000-0  00000-0 0  9991
2 17147  69.6527  91.4896 6005712 352.8398   1.4858  2.03995640280265
0 ARIANE 1 DEB
1 17153U 86019AG  24187.58216008  .00004305  00000-0  91496-3 0  9997
2 17153  98.0055 200.3482 0015530   4.5422 355.5917 14.59485180931144
0 COSMOS 1802
1 17159U 86093A   24187.56484087  .00000066  00000-0  55149-4 0  9993
2 17159  82.9301 347.2487 0041290 302.3592 125.6451 13.72869219883981
0 SL-8 R/B
1 17160U 86093B   24187.60652181  .00000062  00000-0  48391-4 0  9999
2 17160  82.9294 313.5878 0039187 168.8937 202.1076 13.74777079886435
0 SCOUT G-1 DEB
1 17164U 85066G   24187.24283806  .00000076  00000-0  11805-3 0  9990
2 17164  89.3470 257.4604 0204278  32.9955  29.5949 13.32954945891445
0 COSMOS 1691 DEB
1 17168U 85094S   24187.49806132  .00003782  00000-0  10938-1 0  9996
2 17168  82.5476 302.7638 0029193 117.0492   5.9048 13.09316915810085
0 COSMOS 1803
1 17177U 86094A   24187.48821839  .00000027  00000-0  12520-3 0  9997
2 17177  82.6057  85.9208 0002972 177.6016 355.6540 12.41547567703632
0 SL-14 R/B
1 17178U 86094B   24187.48922422  .00000023  00000-0  91691-4 0  9991
2 17178  82.6057  78.1109 0001704 213.6620 320.2090 12.42045828704252
0 FLTSATCOM 7 (USA 20)
1 17181U 86096A   24187.46105039 -.00000184  00000-0  00000-0 0  9991
2 17181  13.2843 344.6483 0036961 313.4222 265.9238  0.98928205144923
0 COSMOS 1805
1 17191U 86097A   24187.57158527  .00012099  00000-0  47584-3 0  9993
2 17191  82.4693   2.4176 0003610 156.7877 203.3524 15.25530356 53129
0 SL-14 R/B
1 17192U 86097B   24187.61814825  .00000692  00000-0  78759-4 0  9994
2 17192  82.5066 358.3686 0015180 246.8368 208.0249 14.84743843  9482
0 ARIANE 1 DEB
1 17203U 86019BF  24187.39564468  .00000647  00000-0  38414-3 0  9994
2 17203  98.6914 229.7429 0130813 359.7228  13.1333 14.06701137925841
0 COSMOS 1806
1 17213U 86098A   24186.92005580  .00000128  00000-0  00000+0 0  9995
2 17213  68.6399 173.5597 4595845  97.5746  43.2715  2.00702451275065
0 SL-6 R/B(2)
1 17216U 86098D   24186.64644829  .00000452  00000-0  00000-0 0  9993
2 17216  69.9782 126.1799 5518572  36.4733  91.0383  2.04008401279870
0 ARIANE 1 DEB
1 17219U 86019BR  24187.62980428  .00003444  00000-0  83402-3 0  9990
2 17219  98.4614  82.3024 0039155 130.9624 300.6937 14.53191998971174
0 ARIANE 1 DEB
1 17233U 86019CF  24187.53065973  .00074352  00000-0  28296-2 0  9990
2 17233  98.4342 205.6493 0006340 180.3564 179.7668 15.26437334999028
0 COSMOS 1808
1 17239U 86100A   24187.53301122  .00000066  00000-0  55679-4 0  9994
2 17239  82.9356 337.3092 0033520  38.6351  28.0974 13.72138849879823
0 SL-8 R/B
1 17240U 86100B   24187.39836366  .00000066  00000-0  54206-4 0  9998
2 17240  82.9328 300.5009 0028441 245.3873 177.4543 13.74152869523586
0 COSMOS 1809
1 17241U 86101A   24187.57007286  .00000090  00000-0  67636-4 0  9999
2 17241  82.5308 127.4283 0015616   3.8165 169.3681 13.84336860896360
0 SL-14 R/B
1 17242U 86101B   24187.60719124  .00000026  00000-0  10136-4 0  9997
2 17242  82.5312 135.9285 0015932  37.5372 135.9943 13.83346608895513
0 ARIANE 3 DEB *
1 17254U 86026F   24187.18899188 -.00000158  00000-0 -16583-3 0  9997
2 17254   8.5443 233.4307 6667282 109.4010 329.9735  2.92433610323544
0 ARIANE 1 DEB
1 17255U 85056C   24186.91589149  .00002222  00000-0  88314-2 0  9995
2 17255   8.3389 300.3563 6495863 351.1250   1.3800  3.15858744322937
0 SL-14 DEB
1 17268U 86101C   24187.49909366  .00000780  00000-0  54491-3 0  9999
2 17268  82.6137 102.4455 0029174  93.5459  82.1261 13.97170860907381
0 SL-14 DEB
1 17269U 86101D   24187.61022885  .00000578  00000-0  45766-3 0  9996
2 17269  82.6356 255.5306 0015729 212.3376 274.6859 13.89863919897979
0 SL-14 DEB
1 17270U 86101E   24187.26043020  .00000600  00000-0  45620-3 0  9998
2 17270  82.4333 276.8186 0003420  49.3003   5.3295 13.92297122901561
0 SL-14 DEB
1 17271U 86101F   24187.51626701  .00000925  00000-0  60432-3 0  9998
2 17271  82.4073  92.7400 0028391  27.8151 148.2956 14.01117134912205
0 SL-14 DEB
1 17272U 86101G   24187.58463469  .00001470  00000-0  85221-3 0  9995
2 17272  82.4862 146.5271 0014006 152.2714 207.9209 14.08199557917533
0 SL-14 DEB
1 17273U 86101H   24187.35462103  .00001477  00000-0  82626-3 0  9998
2 17273  82.5427 190.7954 0026025 130.7072 295.0384 14.10018195919189
0 SL-14 DEB
1 17274U 86101J   24187.41356713  .00000938  00000-0  69875-3 0  9997
2 17274  82.5269  68.1527 0032585 107.6761  66.1972 13.93723073900058
0 METEOR 2-15
1 17290U 87001A   24187.59330554  .00000044  00000-0  26237-4 0  9993
2 17290  82.4682 308.1501 0013320  15.3535 344.8026 13.85162563895313
0 SL-14 R/B
1 17291U 87001B   24187.62493221  .00000032  00000-0  15722-4 0  9993
2 17291  82.4690 312.3196 0011829  29.7756 330.4075 13.84639532894819
0 COSMOS 1812
1 17295U 87003A   24187.53733245  .00014699  00000-0  46640-3 0  9998
2 17295  82.5080 118.0090 0003978 126.0663 234.0948 15.32549687 49338
0 SL-14 R/B
1 17296U 87003B   24187.59473157  .00000825  00000-0  94858-4 0  9999
2 17296  82.5299 135.3177 0018830  12.6881 347.4805 14.84471702  3850
0 COSMOS 1814
1 17303U 87006A   24187.56654776  .00000298  00000-0  11237-3 0  9999
2 17303  74.0559 122.0602 0023864  35.6628 324.6113 14.35514909960121
0 SL-8 R/B
1 17304U 87006B   24187.55553323  .00000393  00000-0  13683-3 0  9998
2 17304  74.0583  35.5278 0029924 307.9889  51.8563 14.38429098963211
0 ARIANE 1 DEB
1 17316U 86019CY  24187.55340663  .00049815  00000-0  23115-2 0  9997
2 17316  98.2035   3.6998 0007698 215.3552 189.3202 15.19838504  2567
0 ARIANE 1 DEB
1 17325U 85056D   24187.13842324  .00001391  00000-0  13145-2 0  9991
2 17325   8.0400 150.9194 6358689 161.5187 240.5470  3.45031897344985
0 MOLNIYA 3-31
1 17328U 87008A   24186.58398598 -.00000483  00000-0 -37385-3 0  9996
2 17328  63.2324  26.3980 7387195 253.4487  20.2938  2.00574724270873
0 SL-6 R/B(2)
1 17333U 87008D   24185.05532901  .00000294  00000-0  00000+0 0  9999
2 17333  63.8505 128.2978 7005046 251.7317  25.4525  1.97093075269529
0 COSMOS 1816
1 17359U 87009A   24187.52197942  .00000091  00000-0  79423-4 0  9999
2 17359  82.9232 192.6670 0033293  34.7259  78.2066 13.74555524877387
0 SL-8 R/B
1 17360U 87009B   24187.62835388  .00000084  00000-0  69118-4 0  9997
2 17360  82.9196 148.0511 0032083 187.2164 346.2656 13.76910175880377
0 COSMOS 1818
1 17369U 87011A   24187.43900941  .00000003  00000-0  38632-4 0  9994
2 17369  65.0115  81.5228 0022108 268.3755  91.4797 14.31665225  6896
0 ARIANE 1 DEB
1 17423U 86019FJ  24187.08446022  .00000613  00000-0  37951-3 0  9997
2 17423  98.7688 220.0786 0178671 222.9860 200.3524 14.01240968915285
0 CZ-3 DEB
1 17425U 86010C   24187.52608084  .00014701  00000-0  25526-1 0  9993
2 17425  30.7515  99.2081 6487396 105.8710 330.1539  3.22600949137961
0 ARIANE 1 DEB
1 17429U 86019FQ  24187.42939745  .00008112  00000-0  15485-2 0  9999
2 17429  99.0989   5.9376 0051595 348.4367  11.5643 14.63400283967192
0 ARIANE 1 DEB
1 17478U 86019HR  24187.55929604  .00000787  00000-0  32157-3 0  9996
2 17478  98.2764 203.1065 0039295 358.4682 132.3766 14.29464392955232
0 USA 21
1 17506U 87015A   24169.22744431  .00001749  00000-0  83851-3 0  9998
2 17506  62.8414   9.1502 7450433 272.7838  12.4945  2.01034580 36092
0 TITAN 34B R/B
1 17507U 87015B   24186.29583830  .00001309  00000-0  00000-0 0  9993
2 17507  63.0474 203.1086 6997131 266.4402  18.3554  2.04987039 37891
0 COSMOS 1821
1 17525U 87017A   24187.54547532  .00000059  00000-0  45884-4 0  9997
2 17525  82.9138 336.3637 0037938 126.7041 306.8445 13.73844490857503
0 SL-8 R/B
1 17526U 87017B   24187.59899368  .00000108  00000-0  94156-4 0  9991
2 17526  82.9013 275.1865 0039254 317.7151  42.0981 13.77078266860373
0 MOS 1A (MOMO 1)
1 17527U 87018A   24187.58097841 -.00000061  00000-0 -10954-4 0  9992
2 17527  98.9467 242.1754 0008965  21.3987 104.3552 14.02896087910274
0 N-2 R/B
1 17528U 87018B   24187.43623393  .00001325  00000-0  28701-3 0  9994
2 17528  97.4623 250.8438 0148804 142.0801 219.0990 14.52887355952775
0 COSMOS 1823
1 17535U 87020A   24187.56944635  .00000034  00000-0  37508-3 0  9995
2 17535  73.6025 277.6998 0028226 186.6638 275.9842 12.41356039693551
0 SL-14 R/B
1 17536U 87020B   24187.61265073 -.00000015  00000-0  16413-4 0  9997
2 17536  73.6110 275.0898 0026481 164.2803 305.2229 12.41630900657890
0 ARIANE 1 DEB
1 17543U 86019HX  24187.33818672  .00000927  00000-0  49330-3 0  9994
2 17543  98.5335 206.4721 0118968 353.3532  19.8230 14.12208637931453
0 GOES 7
1 17561U 87022A   24186.93035613 -.00000294  00000-0  00000-0 0  9996
2 17561  13.5772 342.7229 0003892  95.4829 143.0554  0.99905348119847
0 DELTA 1 R/B(2)
1 17563U 87022C   24187.21836815  .00005154  00000-0  20471-2 0  9998
2 17563  17.7818 240.2686 6065121 288.9717  17.1197  3.90617465371319
0 COSMOS 1825
1 17566U 87024A   24187.52758728  .00021164  00000-0  48748-3 0  9990
2 17566  82.4949 239.8001 0003778 162.5243 197.6135 15.42467360 45508
0 SL-14 R/B
1 17567U 87024B   24187.61058922  .00000855  00000-0  97161-4 0  9998
2 17567  82.5297 307.4735 0019948 123.9692 236.3423 14.84964619997328
0 COSMOS 1827
1 17582U 87026A   24187.51521871  .00000032  00000-0  11700-3 0  9995
2 17582  82.5700 288.9849 0011248 340.3360  19.7297 12.64982807722665
0 COSMOS 1828
1 17583U 87026B   24187.61416247  .00000033  00000-0  11853-3 0  9997
2 17583  82.5659 264.0442 0017767 252.3655 220.4909 12.66242950724487
0 COSMOS 1829
1 17584U 87026C   24187.47427596  .00000016  00000-0  27473-4 0  9998
2 17584  82.5730 327.5341 0001574  94.5487 265.5784 12.62689843719587
0 COSMOS 1830
1 17585U 87026D   24187.59282505  .00000019  00000-0  45663-4 0  9995
2 17585  82.5626 302.1975 0005554  56.0174 315.5183 12.63586496720775
0 COSMOS 1831
1 17586U 87026E   24187.47856442  .00000030  00000-0  10668-3 0  9999
2 17586  82.5594 268.7188 0013989 307.9469  62.7106 12.65515497723414
0 COSMOS 1832
1 17587U 87026F   24187.54529113  .00000022  00000-0  63111-4 0  9993
2 17587  82.5692 298.0662 0008626   9.3421   1.5321 12.64312491721775
0 SL-14 R/B
1 17588U 87026G   24187.47363094  .00000028  00000-0  10615-3 0  9996
2 17588  82.5683  74.3876 0037428 313.6483 220.3075 12.55707018710249
0 COSMOS 1833
1 17589U 87027A   24187.37267349 -.00000037  00000-0  57626-5 0  9999
2 17589  70.9128 173.0158 0020261  43.8322 316.4403 14.12953345923818
0 SL-16 R/B
1 17590U 87027B   24187.55333853 -.00000124  00000-0 -37943-4 0  9992
2 17590  71.0032 126.2527 0006400 316.3624  43.6993 14.16984388928664
0 RADUGA 20
1 17611U 87028A   24186.91725786 -.00000086  00000-0  00000-0 0  9992
2 17611  14.2880 333.3592 0030980 155.5223 214.3300  0.95960703131481
0 COSMOS 1275 DEB
1 17614U 81053KH  24187.22862924  .00002822  00000-0  17261-2 0  9996
2 17614  82.7860 277.6702 0045593 334.0286  54.7918 14.05073234987866
0 COSMOS 1275 DEB
1 17615U 81053KJ  24187.10583289  .00003050  00000-0  16729-2 0  9990
2 17615  82.8578 319.4062 0041748 327.9402 205.3678 14.11099272992496
0 COSMOS 1275 DEB
1 17616U 81053KK  24187.37388093  .00001447  00000-0  16013-2 0  9990
2 17616  83.0437 151.3949 0117620 321.3427 193.3907 13.68271761944752
0 COSMOS 1275 DEB
1 17617U 81053KL  24187.30006764  .00001408  00000-0  15356-2 0  9992
2 17617  82.8595 287.5535 0177130 309.5116 104.6287 13.65570187945111
0 COSMOS 1275 DEB
1 17618U 81053KM  24187.45753222  .00004493  00000-0  26462-2 0  9994
2 17618  82.8493 346.9685 0052050 128.7371 286.6908 14.07069629993702
0 COSMOS 1275 DEB
1 17619U 81053KN  24187.60401646  .00004068  00000-0  16483-2 0  9992
2 17619  82.9432 239.4986 0023016 147.3326 340.5675 14.27397670 13216
0 COSMOS 1275 DEB
1 17620U 81053KP  24187.58721320  .00006895  00000-0  26799-2 0  9996
2 17620  83.1761 310.4825 0021784 305.0338  54.8805 14.29610622 11455
0 COSMOS 1275 DEB
1 17621U 81053KQ  24186.75608387  .00007533  00000-0  28537-2 0  9994
2 17621  82.7847  92.9545 0034975 314.1299  45.7011 14.30716135  5178
0 COSMOS 1275 DEB
1 17623U 81053KS  24187.14130943  .00002258  00000-0  16507-2 0  9991
2 17623  82.8044  65.9085 0059303  51.6273 101.8777 13.94724062980235
0 COSMOS 1275 DEB
1 17624U 81053KT  24187.33115225  .00006958  00000-0  23870-2 0  9991
2 17624  82.8457 314.7863 0013419 227.0824 162.2715 14.35990535 21271
0 COSMOS 1275 DEB
1 17625U 81053KU  24187.38082047  .00002989  00000-0  20537-2 0  9999
2 17625  82.7900 334.4553 0044485 159.9873 200.3054 13.98669309668898
0 COSMOS 1275 DEB
1 17626U 81053KV  24187.34662402  .00000312  00000-0  35488-3 0  9995
2 17626  82.8703 316.6993 0143556  45.8082 347.2590 13.62875159942631
0 COSMOS 1275 DEB
1 17627U 81053KW  24187.41465267  .00002245  00000-0  15679-2 0  9990
2 17627  82.9243 186.2177 0046483 338.5220  21.3997 13.97627238986083
0 COSMOS 1275 DEB
1 17629U 81053KY  24186.97572837  .00002001  00000-0  22053-2 0  9998
2 17629  82.9885 167.3225 0162987 355.9992  58.1808 13.66042815941615
0 COSMOS 1275 DEB
1 17631U 81053LA  24186.62074748  .00001333  00000-0  15291-2 0  9994
2 17631  82.9295  28.5000 0124993 246.1558 178.7425 13.65721427944761
0 COSMOS 1275 DEB
1 17632U 81053LB  24186.72775166  .00000814  00000-0  97862-3 0  9996
2 17632  83.0856 352.4553 0148219  24.7144 348.6317 13.61134460938770
0 COSMOS 1275 DEB
1 17633U 81053LC  24187.56909568  .00004110  00000-0  34809-2 0  9999
2 17633  83.0695 302.0629 0171461 256.3246 114.9656 13.80851793942993
0 COSMOS 1275 DEB
1 17635U 81053LE  24187.14494874  .00003229  00000-0  16337-2 0  9990
2 17635  82.8222 239.1525 0037518 247.2323 112.4889 14.15520225997120
0 COSMOS 1275 DEB
1 17637U 81053LG  24187.31770862  .00001093  00000-0  12834-2 0  9990
2 17637  83.0711 314.3576 0133027  43.4862 346.3375 13.63649298939528
0 COSMOS 1275 DEB
1 17638U 81053LH  24187.18784310  .00002035  00000-0  21714-2 0  9993
2 17638  82.9922  90.3356 0112374  51.0142 100.5817 13.70802883947266
0 COSMOS 1275 DEB
1 17639U 81053LJ  24187.56679493  .00000671  00000-0  80837-3 0  9997
2 17639  82.9978 268.4253 0153847 316.5686 107.5169 13.60576693934331
0 COSMOS 1275 DEB
1 17640U 81053LK  24186.02432604  .00003655  00000-0  15227-2 0  9995
2 17640  82.9127 204.7219 0024257 192.0784 167.9822 14.25934440709158
0 COSMOS 1275 DEB
1 17641U 81053LL  24187.61861762  .00005658  00000-0  28555-2 0  9996
2 17641  82.7543 131.8109 0056386   6.0790 169.7717 14.15291282 10894
0 COSMOS 1275 DEB
1 17642U 81053LM  24187.39111821  .00006010  00000-0  21632-2 0  9998
2 17642  82.8661 344.3381 0037266 154.7181 205.5842 14.33232821 34428
0 THOR ABLESTAR DEB
1 17648U 61015LH  24187.17207384  .00004138  00000-0  19492-2 0  9996
2 17648  65.7360 244.5343 0063503 163.3821 196.9366 14.19867119655622
0 THORAD AGENA D DEB
1 17658U 69082KU  24187.36897042  .00000540  00000-0  41805-3 0  9993
2 17658  70.3562 169.0524 0057686 192.2326 320.1055 13.96907642471663
0 OPS 4682 DEB
1 17666U 65027V   24187.47500340  .00000760  00000-0  25968-2 0  9996
2 17666  90.2461 355.9399 0042171 154.4334 234.8106 12.97038121857549
0 ARIANE 1 DEB
1 17702U 86019LU  24187.36680898  .00002120  00000-0  53322-3 0  9994
2 17702  98.1074 224.3751 0006812 137.5704 222.6020 14.52169732975562
0 SL-12 R/B(2)
1 17705U 87028D   24187.08333339  .00000030  00000-0  00000-0 0  9992
2 17705  12.2860 326.1854 0027410 104.7538  73.2781  0.99878102137353
0 AGILA 1 (PALAPA B2P)
1 17706U 87029A   24187.15504659  .00000028  00000-0  00000-0 0  9994
2 17706  14.6570 353.5690 0004465  98.7094  78.9001  0.99917843 35411
0 THOR ABLESTAR DEB
1 17713U 61015LR  24187.32099089  .00000562  00000-0  44625-3 0  9991
2 17713  66.2121 301.4553 0073260 220.7238 170.5577 13.97676962   808
0 THORAD AGENA D DEB
1 17716U 70025PE  24187.54783344  .00034758  00000-0  65526-2 0  9999
2 17716  99.5066 306.6453 0015927 314.9078  45.0827 14.64312360 14946
0 THORAD AGENA D DEB
1 17717U 70025PF  24187.56953999  .00015218  00000-0  18265-2 0  9995
2 17717  99.9805  55.4315 0064891  32.2184 328.2961 14.82640865 58059
0 THORAD AGENA D DEB
1 17719U 70025PH  24187.36381253  .00048261  00000-0  78176-2 0  9994
2 17719  99.0354 136.9429 0047524 280.1096 232.8006 14.70268456 17427
0 THORAD AGENA D DEB
1 17720U 70025PJ  24187.48605281  .00004641  00000-0  24258-2 0  9995
2 17720  99.6433  11.5244 0034579  33.7050  21.7267 14.14614893  4826
0 OPS 4682 DEB
1 17722U 65027W   24187.41981149  .00000346  00000-0  11477-2 0  9993
2 17722  90.2469 338.7322 0003102 331.9452  85.4959 12.98550641851962
0 COSMOS 374 DEB *
1 17725U 70089DC  24187.44260896  .00002365  00000-0  79505-3 0  9992
2 17725  62.7424  70.4815 0801283  11.4526 160.1674 13.31725191879524
0 THORAD DELTA 1 DEB
1 17728U 74089EX  24187.28282785  .00000063  00000-0  80780-3 0  9992
2 17728 101.4108  14.2584 0108143 145.6222  29.9638 12.34990122774384
0 COSMOS 970 DEB *
1 17732U 77121BP  24187.36510689  .00003162  00000-0  20873-2 0  9992
2 17732  65.8100 318.2157 0179198 220.0720 138.7022 13.95499882990613
0 SL-8 DEB
1 17754U 85079C   24187.44077216  .00002372  00000-0  63416-3 0  9993
2 17754  74.0398 324.8293 0015146 213.7411 210.1685 14.48798568 36770
0 SL-3 DEB
1 17755U 82116D   24187.60915491  .00000164  00000-0  77262-4 0  9999
2 17755  81.2547   2.7941 0068381 221.7881 212.3956 14.14497819144311
0 DELTA 1 DEB
1 17764U 78026GW  24187.33593294  .00000346  00000-0  21338-3 0  9991
2 17764  99.0628 206.0292 0048041  62.1770 311.4755 14.11586349 19639
0 DELTA 1 DEB
1 17765U 78026GX  24187.20818853  .00000475  00000-0  36004-3 0  9998
2 17765  99.0410 281.6058 0043313  97.5073 292.9607 13.98323212   432
0 DELTA 1 DEB
1 17768U 78026HA  24186.94750397  .00001876  00000-0  56791-3 0  9990
2 17768  98.6079 185.9317 0079932  73.7952 319.0008 14.41660727219604
0 COSMOS 1275 DEB
1 17792U 81053LN  24187.47202130  .00002423  00000-0  13990-2 0  9999
2 17792  82.9547  90.7637 0011225 154.8551 273.0621 14.08633294996291
0 COSMOS 1275 DEB
1 17793U 81053LP  24186.62400316  .00001019  00000-0  17291-2 0  9990
2 17793  83.1481 250.2889 0272440 211.8907 304.0832 13.30996093902368
0 COSMOS 1375 DEB
1 17794U 82055AL  24187.39077445  .00001689  00000-0  12465-2 0  9993
2 17794  65.8195 301.1989 0054190 302.2922  57.2909 13.97376175952584
0 COSMOS 1375 DEB
1 17795U 82055AM  24187.36542490 -.00000060  00000-0  22449-4 0  9996
2 17795  65.8323 174.1089 0068639 170.0709 300.9379 13.59813609921439
0 COSMOS 1375 DEB
1 17796U 82055AN  24187.56888709  .00001632  00000-0  10199-2 0  9997
2 17796  65.8217 113.3177 0050786 287.9863 130.5376 14.06819881631262
0 COSMOS 1375 DEB
1 17797U 82055AP  24187.60386737  .00000818  00000-0  73728-3 0  9990
2 17797  65.8279 299.3296 0019684 241.2706 132.3554 13.89371708952905
0 COSMOS 1375 DEB
1 17798U 82055AQ  24187.49732787 -.00000020  00000-0  76661-4 0  9994
2 17798  65.8339 218.8737 0073478 173.1859 300.8889 13.59220452920388
0 COSMOS 1375 DEB
1 17799U 82055AR  24187.55221478  .00000872  00000-0  71476-3 0  9994
2 17799  65.8388 337.8226 0018663  20.7814  54.9912 13.94565402960543
0 COSMOS 1375 DEB
1 17800U 82055AS  24187.63189947 -.00000054  00000-0  28850-4 0  9992
2 17800  65.8365 314.4614 0023629  57.5814  51.6269 13.70591598935167
0 COSMOS 1375 DEB
1 17801U 82055AT  24187.01830051  .00004143  00000-0  17045-2 0  9998
2 17801  65.8288  63.9710 0038137 250.5513 109.1455 14.27570173983467
0 COSMOS 1375 DEB
1 17802U 82055AU  24187.46849183  .00000244  00000-0  32750-3 0  9993
2 17802  65.8344  89.9695 0048388 291.2415 242.5195 13.76714147940115
0 COSMOS 1375 DEB
1 17803U 82055AV  24187.44842372  .00000215  00000-0  28147-3 0  9998
2 17803  65.8304 203.7870 0050209 228.3303 248.9998 13.80292241945628
0 COSMOS 1375 DEB
1 17804U 82055AW  24187.40275769  .00001975  00000-0  13910-2 0  9990
2 17804  65.8182  38.0514 0023851 233.8096 186.9341 14.00191976957622
0 COSMOS 1375 DEB
1 17805U 82055AX  24187.21928561  .00002382  00000-0  16442-2 0  9991
2 17805  65.8227 343.0801 0024375 252.7779 283.9793 14.00900655958858
0 COSMOS 1375 DEB
1 17806U 82055AY  24187.35046429  .00000028  00000-0  10309-3 0  9993
2 17806  65.8350  51.1701 0054335 167.0107   5.6704 13.80655193948451
0 COSMOS 1375 DEB
1 17807U 82055AZ  24187.14328707  .00000887  00000-0  90544-3 0  9995
2 17807  65.8314  82.6786 0064349 307.6751 206.2737 13.80765045941105
0 ARIANE 1 DEB
1 17815U 86019ME  24187.58014538  .00001700  00000-0  54038-3 0  9993
2 17815  98.1512 189.3664 0028666 113.5014  11.6639 14.40862707959930
0 COSMOS 839 DEB
1 17838U 76067BK  24186.04848078  .00001140  00000-0  40952-2 0  9991
2 17838  65.9844  36.3202 0630438 138.1363  14.8112 12.45553382476686
0 SL-8 DEB
1 17842U 86030C   24187.25333352  .00002158  00000-0  60854-3 0  9999
2 17842  74.0231 125.0358 0014003  72.1718  78.9895 14.46310490963184
0 SL-8 DEB
1 17843U 86030D   24187.56354792  .00002355  00000-0  65852-3 0  9997
2 17843  74.0322 125.8418 0012370  28.6047 331.5788 14.46681807  1980
0 SL-14 DEB
1 17844U 86101K   24187.39615878  .00001412  00000-0  81277-3 0  9995
2 17844  82.5101 161.2590 0017652 160.7489 351.9235 14.08547309917852
0 SL-12 R/B(2)
1 17872U 76092F   24187.30674461  .00000079  00000-0  00000-0 0  9998
2 17872   5.2991 280.5282 0018717 179.1286 351.6321  1.00241716111789
0 SL-12 R/B(2)
1 17873U 79035E   24186.49563199 -.00000218  00000-0  00000-0 0  9999
2 17873   7.0088 290.0473 0028857 227.4608 226.0360  1.00141254178031
0 SL-12 R/B(2)
1 17874U 84016F   24186.91438087 -.00000170  00000-0  00000-0 0  9996
2 17874   9.9587 315.8240 0037844 206.6842 172.0675  1.00325495115716
0 SL-12 R/B(2)
1 17875U 84090F   24187.44891383 -.00000113  00000-0  00000-0 0  9997
2 17875   9.2082 311.6741 0018885 153.3988 217.0467  1.01265574149665
0 COSMOS 1842
1 17911U 87038A   24187.43874845  .00009064  00000-0  35470-3 0  9991
2 17911  82.5153 183.9457 0007071 357.2962   2.8237 15.25662020 31196
0 SL-14 R/B
1 17912U 87038B   24187.42983057  .00000794  00000-0  91771-4 0  9995
2 17912  82.5022 153.0782 0020513  31.1842 329.0586 14.84218594988371
0 SL-12 R/B(2)
1 17939U 79087C   24187.49698549  .00000138  00000-0  00000-0 0  9998
2 17939   7.1076 291.2094 0035764 330.5658  40.6444  1.00473914 40290
0 GORIZONT 14
1 17969U 87040A   24187.21696753 -.00000179  00000-0  00000-0 0  9990
2 17969  11.9425 324.4524 0031620 191.7671 349.1507  0.97660339112909
0 SL-12 R/B(2)
1 17972U 87040D   24186.74637698 -.00000110  00000-0  00000-0 0  9999
2 17972   9.0792 313.5836 0014453 298.6797 235.1690  1.03016134118699
0 COSMOS 1844
1 17973U 87041A   24187.60719200  .00000102  00000-0  78081-4 0  9995
2 17973  70.8988 245.0184 0032499 224.8199 135.0297 14.14338354917038
0 SL-16 R/B
1 17974U 87041B   24187.60526556 -.00000174  00000-0 -62356-4 0  9995
2 17974  71.0071 243.1481 0011933  54.6235  55.9432 14.17459743921343
0 USA 22
1 17997U 87043A   24187.42189826  .00027094  00000-0  13929-2 0  9995
2 17997  63.2939  68.9547 0826215  94.3685 275.2115 13.81279021  6895
0 ATLAS H R/B
1 17998U 87043B   24187.58241011  .00003365  00000-0  96120-3 0  9998
2 17998  63.3162 299.0681 0744388 107.5850 260.7856 13.47868586255194
0 USA 23
1 18009U 87043E   24187.37046664  .00012640  00000-0  75922-3 0  9999
2 18009  63.2902 167.1546 0878387  91.3598 278.8101 13.66937384247356
0 USA 24
1 18010U 87043F   24187.40710632  .00012506  00000-0  74481-3 0  9998
2 18010  63.2937 166.6628 0880618  91.1767 279.0172 13.66685026247362
0 USA 25
1 18025U 87043H   24187.37919789  .00013852  00000-0  76665-3 0  9995
2 18025  63.2880 170.2679 0881717  89.1402 281.0432 13.68166468253574
0 COSMOS 1850
1 18095U 87049A   24187.55976071  .00000234  00000-0  93718-4 0  9994
2 18095  74.0394 278.6637 0013839 107.7223 252.5441 14.33674924937899
0 SL-8 R/B
1 18096U 87049B   24187.43018775  .00000457  00000-0  16156-3 0  9997
2 18096  74.0402 174.9701 0020241  72.7379 287.5987 14.37277322941497
0 COSMOS 1851
1 18103U 87050A   24184.72664933  .00000170  00000-0  00000+0 0  9999
2 18103  70.8277 211.9345 4305319  60.1117  72.8483  2.00773340271527
0 SL-6 R/B(2)
1 18106U 87050D   24186.92442081 -.00000537  00000-0  00000-0 0  9993
2 18106  70.2379 155.0224 5196486  45.0410  64.0419  2.03580150272861
0 COSMOS 1852
1 18113U 87051A   24187.57424420 -.00000025  00000-0 -64211-4 0  9992
2 18113  74.0057 342.0475 0017203 282.9894  76.9232 12.44869276683879
0 COSMOS 1853
1 18114U 87051B   24187.59467130  .00000007  00000-0  15397-3 0  9998
2 18114  74.0038 270.5382 0006096 171.1605 296.1846 12.47001991686806
0 COSMOS 1854
1 18115U 87051C   24187.48536924  .00000007  00000-0  15497-3 0  9996
2 18115  74.0008 210.0250 0013764  47.6810  60.4765 12.48810709689230
0 COSMOS 1855
1 18116U 87051D   24187.39258198 -.00000028  00000-0 -78225-4 0  9995
2 18116  74.0029 146.4920 0020090 302.0718 177.7922 12.50715391691813
0 COSMOS 1856
1 18117U 87051E   24187.48686843 -.00000002  00000-0  89548-4 0  9999
2 18117  74.0042  85.4448 0029946 233.8175 299.6315 12.52513965694248
0 COSMOS 1857
1 18118U 87051F   24187.59063117  .00000003  00000-0  12030-3 0  9996
2 18118  74.0046  26.6621 0038336 162.9300 197.3052 12.54255211696555
0 COSMOS 1858
1 18119U 87051G   24187.62583022 -.00000028  00000-0 -70908-4 0  9991
2 18119  74.0057 326.5946 0048105  96.2537 276.3008 12.56021948698940
0 COSMOS 1859
1 18120U 87051H   24187.60231317  .00000019  00000-0  20828-3 0  9991
2 18120  74.0035 261.5591 0057110  13.1558  94.2884 12.57936413701520
0 SL-8 R/B
1 18121U 87051J   24187.59851148  .00000030  00000-0  39959-3 0  9998
2 18121  74.0097 357.5425 0131739  65.1268 359.2960 12.22577172653616
0 COSMOS 1860
1 18122U 87052A   24187.10711071 -.00000042  00000-0  41360-4 0  9991
2 18122  65.0110  75.6978 0034408  61.4358 299.0158 13.84896435874203
0 DMSP 5D-2 F8 (USA 26)
1 18123U 87053A   24187.60447370  .00000324  00000-0  17481-3 0  9994
2 18123  98.7282  12.8536 0013603  49.6854 310.5508 14.19357460915880
0 COSMOS 1861
1 18129U 87054A   24187.59285462  .00000067  00000-0  55877-4 0  9997
2 18129  82.9266 129.6384 0012745 127.2824  46.5843 13.73158195855870
0 SL-8 R/B
1 18130U 87054B   24187.41936999  .00000125  00000-0  11130-3 0  9996
2 18130  82.9237  71.5296 0017151   9.9569 350.1924 13.76815290860177
0 SL-8 DEB
1 18131U 87054C   24187.30017685  .00000309  00000-0  30799-3 0  9993
2 18131  82.9182 120.8454 0031677 127.4389  26.6090 13.74847244855294
0 COSMOS 1862
1 18152U 87055A   24187.41803111  .00007429  00000-0  37891-3 0  9996
2 18152  82.4926 301.0719 0011281   9.3999 350.7443 15.16537176996566
0 SL-14 R/B
1 18153U 87055B   24187.51364387  .00000619  00000-0  70526-4 0  9992
2 18153  82.4987 205.6144 0019849 233.6405 126.2979 14.84472620979081
0 COSMOS 1864
1 18160U 87057A   24187.51672028  .00000059  00000-0  45169-4 0  9999
2 18160  82.9342 334.7405 0032424  23.9656  42.7315 13.75707648837006
0 SL-8 R/B
1 18161U 87057B   24187.60957861  .00000108  00000-0  93531-4 0  9992
2 18161  82.9348 314.9740 0029970 306.8959  64.0319 13.77269152838429
0 COSMOS 1867
1 18187U 87060A   24187.56152554 -.00000004  00000-0  36271-4 0  9999
2 18187  65.0090 220.7529 0021004 270.9372  88.9305 14.31311877932318
0 COSMOS 1869
1 18214U 87062A   24187.47502211  .00008746  00000-0  41457-3 0  9992
2 18214  82.5197  96.2634 0027722  61.3262 299.0754 15.18808827995838
0 SL-14 R/B
1 18215U 87062B   24187.62080909  .00000661  00000-0  75557-4 0  9992
2 18215  82.5114  28.7970 0018450 276.9668 141.2987 14.84441365976683
0 VIKING DEB
1 18231U 86019RN  24183.70090716  .00000205  00000-0  17543-2 0  9996
2 18231  98.7508 152.8097 4700988 223.6365 344.1850  5.53695505718317
0 DELTA 1 DEB
1 18232U 76077EY  24186.86399008  .00008310  00000-0  84451-2 0  9993
2 18232 102.9060 147.5655 0221484 189.9091 231.1905 13.67038519929270
0 COSMOS 1860 FUEL CORE
1 18241U 87052D   24187.42245027 -.00000078  00000-0  95182-5 0  9992
2 18241  65.0066 187.8713 0033173 355.3027 171.2665 13.88951345539763
0 COSMOS 1814 DEB *
1 18257U 87006C   24187.58814421  .00003569  00000-0  68567-3 0  9997
2 18257  74.0368 262.1294 0004222 209.6546 150.4383 14.64041738 50660
0 OPS 4682 DEB
1 18268U 65027X   24180.21921093  .00000642  00000-0  21870-2 0  9999
2 18268  90.2423 348.7706 0033598 161.2111 199.0258 12.97262999568709
0 OPS 4682 DEB
1 18269U 65027Y   24186.71264927  .00000307  00000-0  10599-2 0  9991
2 18269  90.2496 357.0111 0029235 256.0860 103.7007 12.95476584477629
0 OPS 4682 DEB
1 18270U 65027Z   24187.38997244 -.00000112  00000-0 -41455-3 0  9994
2 18270  90.2416 344.2322 0030347 169.4429 218.9042 12.96739982824325
0 OPS 4682 DEB
1 18271U 65027AA  24187.45963687  .00000644  00000-0  21985-2 0  9990
2 18271  90.2426 351.6818 0032412 188.4094 238.3167 12.97115514797102
0 COSMOS 839 DEB
1 18272U 76067BL  24187.26148174  .00000247  00000-0  99857-3 0  9995
2 18272  65.8548 284.3692 0684566 157.1432 239.3540 12.40197957676077
0 SL-8 DEB
1 18274U 86052F   24187.36320187  .00003636  00000-0  69983-3 0  9991
2 18274  74.0475  50.6813 0027547 138.5872  36.1847 14.63713591  3702
0 COSMOS 1275 DEB
1 18275U 81053LQ  24187.42707566  .00001335  00000-0  14705-2 0  9990
2 18275  82.9289 346.3179 0138014 112.2459 278.6001 13.67328161959080
0 SL-8 DEB
1 18276U 87054D   24187.24244073  .00000307  00000-0  29564-3 0  9995
2 18276  82.9299 101.7652 0015093  34.0408 119.6102 13.77055222857468
0 COSMOS 1375 DEB
1 18278U 82055BA  24187.34127488  .00000818  00000-0  73919-3 0  9994
2 18278  65.8309 298.3855 0038251 194.3519 199.3743 13.88985994952949
0 COSMOS 1375 DEB
1 18279U 82055BB  24186.90497057  .00003663  00000-0  26711-2 0  9996
2 18279  65.7941 125.8620 0052172 353.4120 113.6769 13.96620359947906
0 COSMOS 1691 DEB
1 18282U 85094T   24186.24009859  .00000786  00000-0  35341-2 0  9994
2 18282  82.6215 277.8861 0008591 146.2687 242.1746 12.77372844795049
0 ARIANE 1 DEB *
1 18290U 86019RY  24187.55162301  .00000833  00000-0  23714-3 0  9993
2 18290  97.9367 128.5711 0093600  86.6795 274.5100 14.45118625 44089
0 DELTA 1 DEB
1 18302U 78026HD  24187.26632633  .00000679  00000-0  56376-3 0  9992
2 18302  98.8706 304.6390 0236938 275.9741 112.1760 13.79934847974895
0 METEOR 2-16
1 18312U 87068A   24187.56990293  .00000039  00000-0  21191-4 0  9999
2 18312  82.5570 139.6141 0011147 238.2404 121.7671 13.84850580863819
0 SL-14 R/B
1 18313U 87068B   24187.42822135  .00000032  00000-0  15287-4 0  9996
2 18313  82.5581 146.5783 0008634 273.0358  86.9814 13.84250540863308
0 KIKU 5 (ETS 5)
1 18316U 87070A   24187.15060844 -.00000223  00000-0  00000-0 0  9999
2 18316  13.5193 340.3116 0006459  93.2479  73.6706  0.99337685121765
0 EKRAN 16
1 18328U 87073A   24187.15208782 -.00000162  00000-0  00000-0 0  9992
2 18328  13.2525 332.4676 0004436 214.6077 328.4839  0.96485557130142
0 SL-12 R/B(2)
1 18331U 87073D   24187.44354819 -.00000257  00000-0  00000-0 0  9996
2 18331  10.7449 324.5051 0019407 143.5307 246.3088  1.01385736123288
0 COSMOS 1875
1 18334U 87074A   24187.51816575  .00000025  00000-0  76888-4 0  9993
2 18334  82.5695 356.0994 0012327 295.4375 120.0921 12.66311654701998
0 COSMOS 1876
1 18335U 87074B   24187.17603990  .00000045  00000-0  18941-3 0  9998
2 18335  82.5727  57.8993 0004297 302.4411 179.6670 12.62782585697229
0 COSMOS 1877
1 18336U 87074C   24187.59289733  .00000055  00000-0  24254-3 0  9995
2 18336  82.5634  33.7629 0001413 163.1577 250.9934 12.63630430698362
0 COSMOS 1878
1 18337U 87074D   24187.56684001  .00000043  00000-0  17380-3 0  9999
2 18337  82.5696  29.0193 0004008  55.2678 359.0668 12.64353075699365
0 COSMOS 1879
1 18338U 87074E   24187.57801858  .00000036  00000-0  13921-3 0  9991
2 18338  82.5710  19.9862 0006863  31.3691  33.2354 12.65001103700083
0 COSMOS 1880
1 18339U 87074F   24187.58825905  .00000017  00000-0  36359-4 0  9992
2 18339  82.5624   0.5906 0009310   0.9234  69.3998 12.65506172700943
0 SL-14 R/B
1 18340U 87074G   24187.48971775  .00000000  00000-0 -63081-4 0  9995
2 18340  82.5693 165.5752 0039757   1.3754 117.5113 12.55570060687699
0 OPTUS A3 (AUSSAT 3)
1 18350U 87078A   24186.25585919 -.00000244  00000-0  00000-0 0  9993
2 18350  14.5737 356.3139 0004244  45.4215 321.3889  0.98908828 38996
0 EUTE 1-F4 (ECS 4)
1 18351U 87078B   24187.05548616  .00000000  00000-0  00000-0 0  9995
2 18351  14.3377 347.1608 0009311  50.9689 316.7062  0.98687503119737
0 COSMOS 1883 (GLONASS)
1 18355U 87079A   24187.61241545 -.00000085  00000-0  00000-0 0  9997
2 18355  65.9221 342.5779 0005157 255.6386 164.0062  2.13101040286376
0 COSMOS 1884 (GLONASS)
1 18356U 87079B   24186.58290546 -.00000084  00000-0  00000-0 0  9997
2 18356  65.9469 342.9394 0020198 208.8180 214.9241  2.13102756286483
0 COSMOS 1885 (GLONASS)
1 18357U 87079C   24186.84149199 -.00000085  00000-0  00000-0 0  9995
2 18357  65.9427 342.8639 0021591 211.8791 125.8590  2.13102430269958
0 SL-12 R/B(2)
1 18360U 87079F   24186.46745481 -.00000084  00000-0  00000-0 0  9992
2 18360  65.9062 341.2877 0008240 246.3568 115.0549  2.13417283286718
0 OSCAR 27
1 18361U 87080A   24187.56049396  .00000134  00000-0  21102-3 0  9993
2 18361  90.3603  60.0574 0102315 289.3064  69.7041 13.44741736804984
0 OSCAR 29
1 18362U 87080B   24187.61923685  .00000106  00000-0  16479-3 0  9992
2 18362  90.3617  60.4683 0104409 311.3222 110.1186 13.44305277804542
0 SCOUT G-1 R/B
1 18363U 87080C   24187.56230250  .00000107  00000-0  16683-3 0  9994
2 18363  90.3611  60.2218 0103682 327.5314  93.7400 13.44013030804506
0 SCOUT G-1 DEB
1 18365U 87080E   24186.55782451  .00000520  00000-0  74810-3 0  9994
2 18365  90.3294  44.7736 0107464 319.5613  69.1396 13.52492196811481
0 SL-12 R/B(AUX MOTOR)
1 18374U 87079G   24187.53866677  .00004019  00000-0  18454-2 0  9992
2 18374  64.9362 184.2583 5758212  20.6181 355.3752  4.34782068574574
0 SL-12 R/B(AUX MOTOR)
1 18375U 87079H   24186.50453854 -.00000028  00000-0  00000-0 0  9991
2 18375  64.4814 275.3545 5693252 200.3648 122.2942  4.00056314552130
0 COSMOS 1888
1 18384U 87084A   24186.98353809  .00000081  00000-0  00000-0 0  9996
2 18384  11.8075 330.8476 0004420 177.2256 178.2630  1.00379680134547
0 SL-12 R/B(2)
1 18387U 87084D   24187.18363787 -.00000235  00000-0  00000-0 0  9990
2 18387  11.9436 331.4202 0029376 226.0282 127.4133  1.00057849141648
0 COSMOS 1891
1 18402U 87087A   24187.58901178  .00000066  00000-0  54366-4 0  9996
2 18402  82.9218  22.6071 0049785 340.6560  19.2704 13.73820808840894
0 SL-8 R/B
1 18403U 87087B   24187.47936014  .00000136  00000-0  12109-3 0  9998
2 18403  82.9197 333.0468 0057546 181.1645 178.9387 13.76716407844353
0 SL-16 DEB
1 18410U 87041C   24187.46219749  .00000132  00000-0  16210-3 0  9997
2 18410  70.9859  76.1409 0202837 342.4775 193.6895 13.73795110861165
0 SL-16 DEB
1 18411U 87041D   24187.61304422  .00000180  00000-0  20065-3 0  9994
2 18411  71.0318  32.6913 0188052 149.5603 282.8691 13.76092964864330
0 SL-16 DEB
1 18412U 87041E   24187.57023216  .00000150  00000-0  17199-3 0  9990
2 18412  71.0284  12.8054 0192124 172.1398 188.2794 13.76524378864700
0 COSMOS 1375 DEB
1 18413U 82055BC  24186.75027562  .00000591  00000-0  74743-3 0  9995
2 18413  65.8242 286.0814 0070621 138.8827  21.9960 13.70134774927291
0 COSMOS 1375 DEB
1 18414U 82055BD  24187.46485369  .00000357  00000-0  41082-3 0  9998
2 18414  65.8292 204.8428 0026594 256.6773 220.8146 13.81504134946857
0 COSMOS 1375 DEB
1 18415U 82055BE  24187.50817428  .00000734  00000-0  88569-3 0  9999
2 18415  65.8263 176.1785 0057711  96.2369 349.8086 13.71931642929401
0 SL-16 DEB
1 18416U 87027C   24187.53891968  .00000145  00000-0  16656-3 0  9992
2 18416  71.0334 219.1894 0186135  34.6255  79.9429 13.77233898873697
0 SL-16 DEB
1 18417U 87027D   24187.55871774  .00000197  00000-0  21982-3 0  9993
2 18417  71.0000 301.0237 0202875 209.3932 164.0342 13.74328123869736
0 THORAD AGENA D DEB
1 18418U 70025PL  24187.31253868  .00001679  00000-0  17501-2 0  9993
2 18418 100.1522 297.8004 0000797 109.9090 316.1458 13.77037930692528
0 COSMOS 1892
1 18421U 87088A   24187.59859043  .00014228  00000-0  41420-3 0  9993
2 18421  82.4911 238.8864 0008444 288.3909  71.6415 15.35250019  9498
0 SL-14 R/B
1 18422U 87088B   24187.55749382  .00000740  00000-0  85516-4 0  9993
2 18422  82.5118 282.5785 0017989 230.1858 129.7774 14.84191476962472
0 SCOUT G-1 DEB
1 18426U 86088C   24187.38248828  .00000309  00000-0  31269-3 0  9992
2 18426  89.1293 318.6319 0070927 133.3032 291.9319 13.73459444883227
0 OPS 4682 DEB
1 18427U 65027AB  24187.46237821  .00000606  00000-0  18858-2 0  9991
2 18427  90.2486 347.0213 0018558 329.2173  87.9974 13.03695785865557
0 COSMOS 839 DEB
1 18428U 76067BM  24187.00714233  .00000573  00000-0  17449-2 0  9993
2 18428  65.7288 142.6415 0780932 192.3628 305.4208 12.35824647514772
0 DELTA 1 DEB
1 18429U 76077EZ  24187.11213829  .00000135  00000-0  19026-2 0  9999
2 18429 102.5765 250.6716 0227159 330.8382  58.5447 12.06289467529815
0 COSMOS 252 DEB
1 18431U 68097EJ  24187.32236989  .00001508  00000-0  55117-3 0  9997
2 18431  62.3507 120.2840 0860737  10.0911 351.6201 13.18409229354405
0 COSMOS 1894
1 18443U 87091A   24187.44178819  .00000067  00000-0  00000-0 0  9992
2 18443  11.7760 330.3295 0002218  80.0705 254.1700  1.00367487113675
0 SL-12 R/B(2)
1 18446U 87091D   24187.45919713 -.00000086  00000-0  00000-0 0  9994
2 18446  11.8031 330.5069 0021363 238.8484 133.6420  1.00150102122876
0 DELTA 1 DEB
1 18463U 76077FA  24186.84387086 -.00000040  00000-0  43763-4 0  9996
2 18463 102.4849 152.6808 0095127  80.3455 310.0083 12.23574867141276
0 DELTA 1 DEB
1 18467U 78026HE  24187.29601227  .00000674  00000-0  29671-3 0  9995
2 18467  98.8573 195.3980 0092944 302.0543  70.7532 14.24532220 43408
0 COSMOS 249 DEB
1 18468U 68091DD  24187.04204600  .00000314  00000-0  52850-3 0  9990
2 18468  62.2659  65.2006 0748049 296.2310  56.3651 12.79736900508231
0 DELTA 1 DEB
1 18469U 78026HF  24186.84069300  .00000456  00000-0  35199-3 0  9997
2 18469  98.7954 151.2273 0046773   9.0993  21.6201 13.97317282  6089
0 DELTA 1 DEB
1 18470U 73086GU  24186.80907461 -.00000033  00000-0  75134-4 0  9991
2 18470 101.7640  35.9507 0180045 270.0559 101.7940 12.06631563733486
0 COSMOS 839 DEB *
1 18471U 76067BN  24187.56349844  .00001247  00000-0  27222-2 0  9993
2 18471  65.7567 343.3743 0968401 165.4478 285.6765 12.20430911640304
0 DELTA 1 DEB
1 18472U 73086GV  24186.64647645 -.00000017  00000-0  12183-3 0  9996
2 18472 101.1452 240.6818 0015254  74.1470  80.8613 12.77520210833385
0 DELTA 1 DEB
1 18475U 75004HK  24186.71836701  .00000631  00000-0  14882-3 0  9991
2 18475  97.8178 188.5103 0046600 280.2753  79.3194 14.56767972 44102
0 SL-16 DEB
1 18476U 87041F   24187.61118782  .00000210  00000-0  23545-3 0  9997
2 18476  70.9888 121.0103 0208358 340.8942 198.2905 13.72907716860205
0 COSMOS 1375 DEB
1 18477U 82055BF  24186.61917348  .00007328  00000-0  28081-2 0  9998
2 18477  65.8239  16.4335 0019496 338.3114  21.7149 14.30978619975504
0 OPS 4682 DEB
1 18479U 65027AC  24186.69646135  .00000339  00000-0  11436-2 0  9992
2 18479  90.2394 350.2599 0031149 136.2410 239.3883 12.97143771855372
0 COSMOS 252 DEB
1 18490U 68097EN  24187.46254307  .00002869  00000-0  58115-3 0  9993
2 18490  62.7466 141.8046 0432067 228.3244 128.0079 14.17782701611076
0 COSMOS 970 DEB
1 18494U 77121BQ  24187.08784435  .00000113  00000-0  23850-3 0  9991
2 18494  65.8206 109.0082 0124354 296.6559  76.4673 13.61033539770557
0 SCOUT A-1 DEB
1 18496U 73081D   24187.57487465  .00000324  00000-0  27998-3 0  9992
2 18496  89.9560 118.1145 0134851 207.4870 280.5986 13.80566421829124
0 SL-8 DEB *
1 18500U 75112E   24187.34587132  .00002789  00000-0  64925-3 0  9990
2 18500  74.0418 157.0086 0014008 233.2022 277.6403 14.55279181 70676
0 SL-8 DEB *
1 18501U 78019E   24187.48672632  .00004857  00000-0  82391-3 0  9990
2 18501  74.0568  83.3686 0007138  66.8387 349.4134 14.69477874 82878
0 SL-8 DEB *
1 18502U 82051D   24187.39985148  .00002558  00000-0  58933-3 0  9992
2 18502  74.0617  41.3080 0000967 167.9303 254.4273 14.55853786 67709
0 SL-8 DEB *
1 18504U 76098E   24187.45487824  .00008348  00000-0  96392-3 0  9997
2 18504  74.0319 183.9480 0009012 189.6826 323.5040 14.85718105 89014
0 COSMOS 1275 DEB
1 18505U 81053LS  24186.57912655  .00002593  00000-0  18424-2 0  9997
2 18505  83.2875 242.9274 0071832 240.8351 118.5618 13.96002198973725
0 COSMOS 1375 DEB
1 18507U 82055BG  24187.32754250 -.00000052  00000-0  31751-4 0  9990
2 18507  65.8322 160.8460 0036918  44.8534  67.8760 13.66243237 99839
0 SL-8 DEB *
1 18509U 82051E   24187.62972656  .00002869  00000-0  64361-3 0  9992
2 18509  74.0051 271.1937 0007061  97.6770  20.6714 14.57041546973828
0 SL-8 DEB *
1 18510U 82051F   24187.55964623  .00003080  00000-0  70977-3 0  9997
2 18510  73.9928 286.6611 0011595 178.1943 194.4537 14.55730861985396
0 SL-8 DEB *
1 18512U 77119E   24187.07567374  .00007522  00000-0  90881-3 0  9998
2 18512  74.0274 192.0790 0005714 251.5732 183.0048 14.83886655102037
0 THORAD AGENA D DEB
1 18513U 70025PN  24187.45248065  .00002898  00000-0  13182-2 0  9992
2 18513  99.7709   4.8368 0051716 276.0905 138.9650 14.21960126 23312
0 COSMOS 374 DEB
1 18517U 70089DD  24187.36548034  .00023818  00000-0  39459-2 0  9995
2 18517  62.3931 168.9820 0417379  25.4727 336.6268 14.25877068771119
0 COSMOS 886 DEB
1 18518U 76126BW  24186.95786454  .00001054  00000-0  15764-2 0  9999
2 18518  65.7550 183.5915 0728889 344.2362  32.5252 12.80188814657571
0 SL-8 DEB *
1 18519U 84019D   24187.56990359  .00003317  00000-0  62341-3 0  9997
2 18519  74.0440 240.8895 0008534  80.6616 279.5517 14.65051649956599
0 SCOUT G-1 DEB
1 18525U 86088D   24186.72329093  .00000376  00000-0  31891-3 0  9998
2 18525  89.9313 348.6076 0006982 105.8758 266.7001 13.85808368899568
0 SL-8 DEB
1 18526U 87049C   24187.25257486  .00003297  00000-0  70036-3 0  9991
2 18526  74.0372 120.0544 0004971 219.6739 290.6567 14.59498796955300
0 SL-16 DEB
1 18527U 87027E   24187.52858468  .00000155  00000-0  17914-3 0  9991
2 18527  70.9961 244.2408 0195438 202.8720 156.3591 13.75500611871322
0 SCOUT G-1 DEB
1 18530U 87080F   24186.34364907  .00000223  00000-0  30190-3 0  9990
2 18530  90.3419 149.9300 0083511 270.7619 245.2471 13.55877036818761
0 OPS 4682 DEB
1 18533U 65027AD  24187.47832337  .00000229  00000-0  78254-3 0  9991
2 18533  90.2400 350.8000 0024875 190.4128 239.8023 12.95764723801927
0 OPS 4682 DEB
1 18534U 65027AE  24186.97829740  .00000570  00000-0  19877-2 0  9994
2 18534  90.2526   6.7856 0027863 178.3966 334.0715 12.95644277748925
0 OPS 4682 DEB
1 18538U 65027AF  24186.91992302  .00000292  00000-0  10133-2 0  9994
2 18538  90.2420 348.1215 0027520 232.1464 280.0867 12.95000798403465
0 THORAD DELTA 1 DEB
1 18539U 74089EZ  24187.24764802  .00000199  00000-0  15160-2 0  9993
2 18539 101.5663 108.2935 0031184  52.0392 103.5927 12.53743463503346
0 DELTA 1 DEB
1 18540U 76077FC  24187.05213367  .00017605  00000-0  10098+0 0  9990
2 18540 103.6824 220.3487 0479115 129.2639 294.7651 12.31043299527461
0 SL-8 DEB
1 18545U 86100C   24187.19353113  .00003518  00000-0  20321-2 0  9993
2 18545  82.9223 332.9108 0015614 138.8837  36.4350 14.08703151905186
0 COSMOS 249 DEB
1 18549U 68091DE  24187.14916579  .00002808  00000-0  31418-2 0  9992
2 18549  62.2123 115.5524 0698282 115.0789   1.9174 12.98147311536827
0 SL-16 DEB
1 18550U 87027F   24187.54728590  .00000225  00000-0  23255-3 0  9994
2 18550  71.0241 134.7340 0181878  19.9802 340.8302 13.78946609875867
0 COSMOS 249 DEB
1 18551U 68091DF  24187.40329306  .00001948  00000-0  84481-3 0  9993
2 18551  62.2919 231.6705 0739491  31.2672 344.7399 13.33837115551329
0 SL-8 DEB
1 18552U 86086C   24187.43665167  .00003845  00000-0  18334-2 0  9990
2 18552  82.9206 343.1042 0027393 295.0378  93.6898 14.18864392921815
0 COSMOS 252 DEB
1 18556U 68097EP  24187.36995487  .00013765  00000-0  71223-2 0  9997
2 18556  62.1897 167.7747 0496135  74.2001 291.3139 13.66266379399852
0 COSMOS 1375 DEB
1 18560U 82055BH  24187.02288299  .00000136  00000-0  24457-3 0  9997
2 18560  65.8324  43.9984 0038718  21.7993 126.7393 13.69688621840840
0 SCOUT G-1 DEB
1 18561U 87080G   24187.49493737  .00000495  00000-0  70980-3 0  9997
2 18561  90.3802  83.4723 0110114 335.7619 202.0567 13.52437831811115
0 SCOUT G-1 DEB
1 18562U 87080H   24186.91164865  .00000288  00000-0  46784-3 0  9996
2 18562  89.9274 160.2629 0180568  20.1964  40.7725 13.39681590795426
0 COSMOS 1691 DEB
1 18565U 85094U   24181.85739279  .00009572  00000-0  13497-1 0  9995
2 18565  82.4766 324.1050 0140138 255.2255 234.6734 13.52875228810807
0 TVSAT 1
1 18570U 87095A   24186.75011895 -.00000226  00000-0  00000-0 0  9998
2 18570  12.2202 332.5375 0065445 120.0459  54.6292  0.98921274121795
0 ARIANE 3 DEB
1 18571U 87078F   24187.51419465  .00000460  00000-0  72934-3 0  9997
2 18571   6.6992  88.3015 5558246 131.0622 292.1044  4.53055436397096
0 COSMOS 1897
1 18575U 87096A   24187.58319934 -.00000301  00000-0  00000-0 0  9995
2 18575  12.0072 331.6873 0010089 126.8891 131.8838  1.00288461134059
0 SL-12 R/B(2)
1 18578U 87096D   24187.11553832 -.00000034  00000-0  00000-0 0  9997
2 18578  11.8164 330.9941 0022912 221.3341 125.4006  1.00557444130869
0 USA 28
1 18583U 87097A   24186.32084851 -.00000181  00000-0  00000-0 0  9999
2 18583  12.7073 342.4839 0024167 255.4475 115.1740  0.98388172 17713
0 TITAN 34D TRANSTAGE R/B
1 18584U 87097B   24187.15232421  .00000072  00000-0  00000-0 0  9998
2 18584  11.5752 337.9837 0007481 231.7014 128.2619  1.01236054 18243
0 COSMOS 1898
1 18585U 87098A   24187.55698514  .00000269  00000-0  10532-3 0  9995
2 18585  74.0065 336.7912 0020354 141.9967 218.2625 14.34094360913387
0 SL-8 R/B
1 18586U 87098B   24187.56301477  .00000292  00000-0  10591-3 0  9997
2 18586  74.0048 231.2211 0020118  36.0024 324.2480 14.37640737916979
0 ELEKTRON 1 DEB *
1 18589U 64006N   24186.88704652  .00002526  00000-0  99877-2 0  9995
2 18589  58.9247  15.2031 2109909  37.6622 335.4660  9.94864293409202
0 DELTA 1 DEB *
1 18591U 76077FD  24187.20686328 -.00000452  00000-0 -93920-2 0  9996
2 18591 100.9854  98.6845 1102665  61.5167  92.3286 10.59179463516434
0 COSMOS 1275 DEB
1 18592U 81053LU  24187.61453797  .00005297  00000-0  22713-2 0  9996
2 18592  82.9394 291.3923 0013678 164.3413 259.5088 14.24610824602005
0 COSMOS 252 DEB *
1 18597U 68097EQ  24186.39839201  .00000868  00000-0  14062-2 0  9993
2 18597  62.2626 186.0324 0752950 258.6034  92.9517 12.73643811493236
0 DELTA 1 DEB *
1 18599U 76077FE  24187.58311686  .00005198  00000-0  40082-1 0  9997
2 18599 100.6777 117.6770 0652180 197.0854 342.0084 11.90530724696168
0 DELTA 1 DEB
1 18600U 76077FF  24187.44748833 -.00000622  00000-0 -14148-1 0  9996
2 18600 102.0473  80.6979 0789562 331.0898  71.9061 10.91650849390539
0 COSMOS 1275 DEB
1 18601U 81053LW  24187.13862647  .00003891  00000-0  19965-2 0  9995
2 18601  82.7848 237.3409 0060431 111.4552 269.5452 14.14231186880130
0 COSMOS 249 DEB
1 18602U 68091DG  24187.42052719  .00002627  00000-0  27078-2 0  9996
2 18602  62.2262 180.6818 0685986  91.7805  52.3485 13.04280656552423
0 MIDAS 5 DEB
1 18603U 62010G   24186.69671961 -.00000012  00000-0 -32440-2 0  9993
2 18603  86.6663  69.0821 0286853 217.0004 165.4947  9.41010784311529
0 COSMOS 839 DEB
1 18606U 76067BP  24187.21694671  .00000807  00000-0  29012-2 0  9996
2 18606  65.8332  93.5089 0624975 144.4287  11.5726 12.47531415725781
0 COSMOS 1678 DEB *
1 18608U 85077K   24187.54231756  .00003559  00000-0  74120-3 0  9994
2 18608  74.0466   1.4096 0010077 188.8545 171.2445 14.60346062975171
0 THORAD AGENA D DEB
1 18616U 69082LB  24187.19808048  .00001256  00000-0  10102-2 0  9997
2 18616  70.1376 264.7201 0167386 112.3645 249.5291 13.86333190845784
0 RADUGA 21
1 18631U 87100A   24186.36507983 -.00000289  00000-0  00000-0 0  9997
2 18631  12.3296 330.4263 0003324 162.2122 214.4986  1.00212386133940
0 SL-12 R/B(2)
1 18634U 87100D   24186.98545259 -.00000153  00000-0  00000-0 0  9996
2 18634  10.8630 325.0973 0016246 240.4789 131.0599  1.03401828138113
0 COSMOS 1275 DEB
1 18637U 81053LX  24187.07877592  .00004978  00000-0  24443-2 0  9996
2 18637  82.9672 113.9531 0056701 119.1560 241.5310 14.16708827995997
0 COSMOS 1275 DEB
1 18639U 81053LZ  24187.55453407  .00001297  00000-0  14493-2 0  9991
2 18639  83.0612 291.6293 0144243 320.3523  51.7670 13.66196169941083
0 COSMOS 1275 DEB
1 18640U 81053MA  24186.88371618  .00001941  00000-0  16766-2 0  9992
2 18640  83.2064 238.1386 0090643 128.9827 356.5818 13.84046177963087
0 DELTA 1 DEB
1 18645U 73086GX  24187.25815975  .00000031  00000-0  58506-3 0  9993
2 18645 102.2487 305.8682 0111770 299.7586  88.9950 12.37154893775916
0 COSMOS 252 DEB *
1 18648U 68097ED  24187.39433956  .00009123  00000-0  74561-2 0  9991
2 18648  62.2122 334.0675 0584436 176.5457 183.9873 13.30905688560516
0 SL-8 DEB *
1 18650U 79078E   24187.57223641  .00064954  00000-0  21392-2 0  9990
2 18650  74.0492 341.9973 0005148 126.5159 233.6520 15.31158995 77069
0 THOR ABLESTAR DEB *
1 18651U 61015LW  24187.46011580 -.00000025  00000-0  90545-4 0  9996
2 18651  65.6954 201.8045 0746377 183.7705 305.3132 12.40388800516028
0 COSMOS 1900
1 18665U 87101A   24187.44105768  .00000164  00000-0  61551-4 0  9993
2 18665  66.0824 214.6447 0036729 192.6223 167.3967 14.55064902944938
0 OPS 4682 DEB
1 18670U 65027AG  24187.39389816  .00000391  00000-0  13366-2 0  9995
2 18670  90.2471 340.5744 0022334 207.8606 152.1320 12.96600956570502
0 DELTA 1 DEB
1 18671U 73086GZ  24185.86280809  .00000135  00000-0  13151-2 0  9990
2 18671 101.7695 151.7786 0111336 271.7260 146.3180 12.39574037548033
0 OPS 4682 DEB
1 18675U 65027AH  24187.40582078  .00000128  00000-0  40313-3 0  9998
2 18675  90.2547 338.3528 0026759 357.3730  58.4850 12.99354395766149
0 SL-14 DEB
1 18680U 86101L   24187.58702909  .00001299  00000-0  75403-3 0  9994
2 18680  82.5450 227.6479 0015818  95.2357 265.0622 14.08036651917015
0 SL-8 DEB
1 18681U 87049D   24187.58788656  .00002138  00000-0  60556-3 0  9996
2 18681  74.0307 130.3274 0016998 172.8559   2.1608 14.46077295942532
0 WESTFORD NEEDLES
1 18688U 63014DM  24187.34141719  .00000008  00000-0  23699-2 0  9996
2 18688  87.3205 270.2472 0031536  98.4702 279.9886  8.65101063 57775
0 COSMOS 839 DEB *
1 18689U 76067BR  24186.56569998 -.00000045  00000-0 -96717-5 0  9992
2 18689  65.8208  29.8961 0932636  40.2865 352.3296 11.55685428308514
0 OPS 4682 DEB
1 18691U 65027AJ  24187.38598128 -.00000129  00000-0 -47675-3 0  9997
2 18691  90.2362 341.7812 0026254 173.8698 216.3377 12.96356193732855
0 THORAD DELTA 1 DEB
1 18693U 74089FA  24186.64220157  .00000817  00000-0  27942-2 0  9995
2 18693 101.7407  74.9380 0193734 149.6366 227.5581 12.96043303691469
0 SL-8 DEB
1 18697U 87098C   24187.55546329  .00002417  00000-0  53288-3 0  9997
2 18697  73.9964 223.9106 0008212 293.6114 187.8172 14.57931962929206
0 SL-8 DEB
1 18698U 87098D   24187.29171825  .00002148  00000-0  58384-3 0  9997
2 18698  73.9861 126.8176 0015611 213.0098 299.4799 14.48083520919560
0 COSMOS 1903
1 18701U 87105A   24185.42366305  .00000148  00000-0  00000+0 0  9999
2 18701  69.0086 221.6739 4740626 113.0378 302.8988  2.00684168268346
0 SL-6 R/B(2)
1 18704U 87105D   24187.12330731  .00000110  00000-0  00000-0 0  9995
2 18704  68.8294 307.4769 5642306  74.7541 338.5166  2.04196651236310
0 COSMOS 1904
1 18709U 87106A   24187.56432226  .00000088  00000-0  76879-4 0  9996
2 18709  82.9130 239.2479 0026599 221.5730 248.6210 13.74362326832224
0 SL-8 R/B
1 18710U 87106B   24187.61323839  .00000185  00000-0  17390-3 0  9993
2 18710  82.9105 206.9470 0024640  96.3545  27.9721 13.76180440834265
0 EKRAN 17
1 18715U 87109A   24187.59771418 -.00000143  00000-0  00000-0 0  9990
2 18715  14.2589 339.5356 0043458 217.4143 136.3181  0.95883055113981
0 SL-12 R/B(2)
1 18718U 87109D   24186.91724258 -.00000313  00000-0  00000-0 0  9997
2 18718  11.8683 331.5415 0064703 259.2523 109.8614  1.00840000124889
0 COSMOS 1823 DEB
1 18725U 87020C   24187.56613583  .00000100  00000-0  87848-3 0  9998
2 18725  73.7626 214.2351 0071339  99.6428  25.5793 12.38512250651298
0 COSMOS 1823 DEB
1 18727U 87020E   24187.59183523  .00000114  00000-0  71161-3 0  9995
2 18727  73.3604 305.2158 0087931 257.2422 115.5824 12.65007666686832
0 COSMOS 1823 DEB
1 18728U 87020F   24187.34923405 -.00000051  00000-0 -26881-3 0  9991
2 18728  73.6171 144.5662 0065272   8.2882 146.1029 12.35903282647905
0 COSMOS 1823 DEB
1 18729U 87020G   24187.27534502  .00000084  00000-0  89400-3 0  9990
2 18729  73.8150  17.0621 0129833 137.7263  36.0923 12.23549268631910
0 COSMOS 1823 DEB
1 18730U 87020H   24187.22279605 -.00000204  00000-0 -18917-2 0  9997
2 18730  73.9325 102.7087 0180764 330.5586 201.3833 12.13368215618514
0 COSMOS 1823 DEB
1 18731U 87020J   24187.55760148  .00000150  00000-0  11918-2 0  9993
2 18731  73.6270 264.8208 0018710  93.1549  29.0187 12.43849199657909
0 COSMOS 1823 DEB
1 18733U 87020L   24187.11039218  .00077080  00000-0  36832-1 0  9991
2 18733  73.4298  71.9548 0085397  65.9791  89.0034 14.16707774751135
0 COSMOS 1823 DEB
1 18737U 87020Q   24187.50216637  .00000027  00000-0  32840-3 0  9994
2 18737  73.6052 276.4196 0027622 176.2434 196.5954 12.41525812656302
0 COSMOS 1823 DEB
1 18742U 87020V   24187.59176311  .00001644  00000-0  97470-2 0  9998
2 18742  73.5158 130.2037 0059260 116.6748  58.2238 12.58199519672276
0 COSMOS 1823 DEB
1 18746U 87020Z   24187.46316861  .00003047  00000-0  12619-1 0  9994
2 18746  73.4780 192.9027 0073240 334.3723 148.2156 12.83973382674637
0 COSMOS 1823 DEB
1 18747U 87020AA  24187.62234029 -.00000005  00000-0  96750-4 0  9991
2 18747  73.6278  28.2516 0041871 236.8390 182.5242 12.38761350652506
0 COSMOS 1908
1 18748U 88001A   24187.59406429  .00012600  00000-0  41715-3 0  9996
2 18748  82.4633  23.7314 0009004 319.9679  40.0897 15.31147802995972
0 SL-14 R/B
1 18749U 88001B   24187.60451328  .00000657  00000-0  75085-4 0  9994
2 18749  82.5130  50.7300 0019924 100.3659 259.9804 14.84385370951177
0 COSMOS 1823 DEB
1 18751U 87020AC  24187.55991862  .00000103  00000-0  96967-3 0  9990
2 18751  73.6284 237.2688 0075982  82.7024  35.2586 12.32934509644511
0 COSMOS 1823 DEB
1 18752U 87020AD  24187.59497079  .00000136  00000-0  87219-3 0  9992
2 18752  73.9215  25.0595 0059149 314.8560 103.6511 12.60169278679813
0 COSMOS 1823 DEB
1 18753U 87020AE  24187.58950634  .00000122  00000-0  97574-3 0  9993
2 18753  73.4486   8.9557 0022790 328.5020  91.2976 12.45608770660334
0 COSMOS 1823 DEB
1 18754U 87020AF  24187.58826667  .00000313  00000-0  17868-2 0  9991
2 18754  73.6342 296.9318 0073726 235.1649 137.7609 12.64347465684941
0 COSMOS 1823 DEB
1 18755U 87020AG  24187.38721769  .00000026  00000-0  31241-3 0  9990
2 18755  73.6404 307.3500 0034662 127.8778 291.9860 12.42348544656617
0 COSMOS 1823 DEB
1 18756U 87020AH  24187.51103802  .00000103  00000-0  85282-3 0  9998
2 18756  73.6313 262.9206 0030499  84.2397 291.7622 12.43938722657858
0 COSMOS 1823 DEB
1 18757U 87020AJ  24187.59172249  .00006217  00000-0  13221-1 0  9992
2 18757  73.7090 293.1825 0089017  40.8941 336.1624 13.29200997704993
0 COSMOS 1823 DEB
1 18758U 87020AK  24186.83667008 -.00000003  00000-0  10680-3 0  9997
2 18758  73.6266  66.9965 0052574 285.9731 156.1657 12.37966676650049
0 SL-12 DEB
1 18764U 85042G   24187.31832291  .00000693  00000-0  20986-3 0  9992
2 18764  66.5912 147.0176 0085472 117.9636 358.6560 14.46421985900907
0 SL-12 DEB
1 18765U 85042H   24187.39226793  .00003608  00000-0  89886-3 0  9998
2 18765  66.5766 200.6431 0014998 262.2710  97.6695 14.52730733911527
0 SL-12 DEB
1 18766U 85042J   24187.28619598  .00005941  00000-0  20341-2 0  9998
2 18766  66.5670 134.6438 0051422 353.4868 127.1688 14.36114361887275
0 SL-12 DEB
1 18767U 85042K   24187.40226217  .00001160  00000-0  75454-3 0  9990
2 18767  66.5845 227.0413 0142845 357.7468   2.2953 14.01159804850858
0 DELTA 1 DEB
1 18775U 78026HH  24187.47844443  .00000596  00000-0  43906-3 0  9996
2 18775  99.1942  80.7844 0064626 144.4055 216.1444 13.98524067816947
0 DELTA 1 DEB
1 18779U 78026HJ  24187.40884573  .00006894  00000-0  27135-2 0  9993
2 18779  99.0387 158.1203 0078293  68.3195  81.4947 14.27845672891312
0 OPS 4682 DEB
1 18783U 65027AK  24187.24066145  .00000657  00000-0  21482-2 0  9994
2 18783  90.2478   9.4081 0025368 292.9215 243.7047 13.00304893487934
0 OPS 4682 DEB
1 18784U 65027AL  24187.18896508  .00000086  00000-0  27150-3 0  9997
2 18784  90.2512 348.0608 0040923 187.1882 351.1888 12.96584301710091
0 THORAD AGENA D DEB
1 18785U 70025PQ  24186.90657031  .00000311  00000-0  47597-3 0  9995
2 18785 100.0956  59.4415 0001687 330.3569  43.0276 13.60660672822574
0 COSMOS 1909
1 18788U 88002A   24187.55027924  .00000029  00000-0  10359-3 0  9998
2 18788  82.6119   9.9781 0002349 120.8987 294.8443 12.62838414680982
0 COSMOS 1910
1 18789U 88002B   24187.55048549  .00000017  00000-0  34297-4 0  9990
2 18789  82.6036 347.3097 0004452  30.6947  37.1654 12.63603599681990
0 COSMOS 1911
1 18790U 88002C   24187.57312645  .00000011  00000-0  16840-5 0  9994
2 18790  82.6102 342.4860 0006625 316.9434  96.1975 12.64354747683021
0 COSMOS 1912
1 18791U 88002D   24187.49983341  .00000009  00000-0 -99296-5 0  9997
2 18791  82.6108 333.0632 0009646 283.8778 140.5617 12.65041113683905
0 COSMOS 1913
1 18792U 88002E   24187.58601892  .00000019  00000-0  45285-4 0  9994
2 18792  82.6010 312.2768 0012875 248.0814 123.1715 12.65712795684738
0 COSMOS 1914
1 18793U 88002F   24187.57311229  .00000021  00000-0  53892-4 0  9992
2 18793  82.6081 308.6295 0017365 193.7022 177.6931 12.66429020685717
0 SL-14 R/B
1 18794U 88002G   24187.54883149 -.00000002  00000-0 -73334-4 0  9999
2 18794  82.6013 109.7917 0036539 269.0914 274.5655 12.55575410671432
0 COSMOS 1823 DEB
1 18800U 87020AL  24186.89680053 -.00000024  00000-0 -47080-4 0  9995
2 18800  73.5925 358.8945 0051206 304.3430 208.4810 12.38939086652547
0 COSMOS 1823 DEB
1 18801U 87020AM  24187.16711257  .00000183  00000-0  92968-3 0  9996
2 18801  73.1281  90.6025 0130339 277.0799 235.2303 12.75168586696811
0 COSMOS 1823 DEB
1 18802U 87020AN  24187.41796166  .00000130  00000-0  12240-2 0  9993
2 18802  73.5921 311.5562 0101956 271.2678 147.9844 12.30674359639494
0 COSMOS 1823 DEB
1 18803U 87020AP  24187.46631039  .00000029  00000-0  37796-3 0  9997
2 18803  73.4499  81.7548 0084551  31.4723 142.6855 12.31941991642670
0 COSMOS 1823 DEB
1 18804U 87020AQ  24187.27533560 -.00000006  00000-0  80237-4 0  9992
2 18804  73.6039 274.3342 0027202 180.7251 207.7376 12.41489472655542
0 COSMOS 1823 DEB
1 18805U 87020AR  24187.41132229 -.00000003  00000-0  99651-4 0  9993
2 18805  73.7095 333.4514 0020756 328.4508  60.9956 12.43277934656417
0 COSMOS 1823 DEB
1 18806U 87020AS  24186.58158601  .00000259  00000-0  21804-2 0  9998
2 18806  73.4819  45.5687 0082885 264.2315 124.1060 12.35267663644780
0 COSMOS 1823 DEB
1 18807U 87020AT  24187.11489230  .00049248  00000-0  27588-1 0  9999
2 18807  73.7339 208.3176 0147704 346.3126  69.1923 14.04982885399092
0 METEOR 2-17
1 18820U 88005A   24187.48283490  .00000070  00000-0  48870-4 0  9998
2 18820  82.5422 170.7021 0014998 283.9956 192.8148 13.85549005841629
0 SL-14 R/B
1 18821U 88005B   24187.49334174  .00000035  00000-0  17470-4 0  9999
2 18821  82.5424 172.1560 0013150 297.4327  62.5495 13.85175329841506
0 DMSP 5D-2 F9 (USA 29)
1 18822U 88006A   24187.54154164  .00000397  00000-0  17667-3 0  9994
2 18822  98.3212  15.0653 0006734  21.9022 338.2447 14.28029717894704
0 COSMOS 375 DEB
1 18866U 70091AV  24186.48629860  .00001766  00000-0  55918-3 0  9991
2 18866  62.6680   0.0980 0783353  15.8363 346.5709 13.38006350619381
0 DELTA 1 DEB
1 18870U 73086HA  24186.94064902  .00000016  00000-0  61990-3 0  9998
2 18870 101.7362 181.1581 0343959 295.8210  60.7729 11.94586040497987
0 CS 3A
1 18877U 88012A   24187.19051266 -.00000179  00000-0  00000-0 0  9990
2 18877  15.3918 356.9805 0004391 319.9972  45.4853  0.98137158120681
0 COSMOS 1922
1 18881U 88013A   24186.77877930 -.00000228  00000-0  00000-0 0  9998
2 18881  68.8704 112.5764 5588422  60.1867 343.6475  2.00850197266243
0 SL-6 R/B(2)
1 18883U 88013C   24187.48565730 -.00000612  00000-0  00000-0 0  9998
2 18883  67.0987 355.6254 6383186  35.9641 358.2190  2.04051688270753
0 COSMOS 1275 DEB
1 18902U 81053MB  24186.93119605  .00008903  00000-0  29320-2 0  9990
2 18902  82.9531 176.3777 0012516 335.1041  24.9545 14.38040112605486
0 LEASAT 1 DEB *
1 18904U 84113F   24187.36526650  .00029875  00000-0  42043-2 0  9990
2 18904  26.5987 193.0698 3779365  98.6654 305.0037  7.75230649307949
0 DELTA 1 DEB
1 18906U 73086HB  24187.01395726 -.00000021  00000-0  16446-3 0  9991
2 18906 102.3509  25.1769 0089078   7.1514 157.0290 12.55900897682653
0 COSMOS 886 DEB
1 18907U 76126BY  24187.12320407  .00002289  00000-0  55453-3 0  9994
2 18907  65.8126 228.5834 0885612 354.0107   5.0863 13.26793151753114
0 THOR ABLESTAR DEB
1 18908U 61015LY  24187.23748995  .00021219  00000-0  29000-2 0  9996
2 18908  65.7173 111.0915 0085941 338.1889  21.5572 14.76028662933405
0 COSMOS 1823 DEB
1 18910U 87020AU  24187.40829943  .00000221  00000-0  16032-2 0  9996
2 18910  73.6741 189.8211 0017795 261.6602 217.4020 12.48349615661979
0 STTW-2
1 18922U 88014A   24186.91926757 -.00000220  00000-0  00000-0 0  9995
2 18922  13.8420 344.8961 0008388 148.2291 206.7049  1.00294478132965
0 COSMOS 1924
1 18937U 88016A   24187.57322230 -.00000020  00000-0 -29428-4 0  9990
2 18937  74.0070 346.5011 0034536  14.1996  51.2160 12.44605943650373
0 COSMOS 1925
1 18938U 88016B   24187.60665054  .00000004  00000-0  13490-3 0  9990
2 18938  74.0055 273.6371 0024481 307.1350 161.6450 12.46832268653086
0 COSMOS 1926
1 18939U 88016C   24187.53198631  .00000013  00000-0  19171-3 0  9997
2 18939  74.0023 207.9502 0012688 229.1509 248.2473 12.48840256655798
0 COSMOS 1927
1 18940U 88016D   24187.62026346 -.00000025  00000-0 -59549-4 0  9991
2 18940  74.0046 140.1919 0008076 223.3514 310.0751 12.50902787658547
0 COSMOS 1928
1 18941U 88016E   24187.19002681  .00000002  00000-0  11244-3 0  9992
2 18941  74.0057  75.5940 0011167 217.6955 311.9471 12.52875600567694
0 COSMOS 1929
1 18942U 88016F   24187.62635730 -.00000005  00000-0  67528-4 0  9999
2 18942  74.0064  11.8095 0020120 159.0327 269.0298 12.54789777663630
0 COSMOS 1930
1 18943U 88016G   24187.49427929 -.00000019  00000-0 -19306-4 0  9991
2 18943  74.0071 311.1037 0029074 100.8260 328.2789 12.56621701666032
0 COSMOS 1931
1 18944U 88016H   24187.55779780  .00000023  00000-0  23275-3 0  9996
2 18944  74.0054 246.7956 0040215  18.9743  91.3489 12.58557188668599
0 SL-8 R/B
1 18945U 88016J   24187.56321288 -.00000012  00000-0  22679-4 0  9991
2 18945  74.0091 291.3566 0140050  33.5095 339.2024 12.24023994622848
0 MOLNIYA 1-71
1 18946U 88017A   24186.05769165  .00000017  00000-0  60188-3 0  9996
2 18946  62.9894  13.1460 7461110 258.2280  17.3992  2.00678481266056
0 SL-6 R/B(2)
1 18949U 88017D   24185.27418648 -.00000169  00000-0  25518-2 0  9995
2 18949  62.8968 301.1203 7239572 256.0454  20.7073  2.10119058257878
0 SPACENET 3R
1 18951U 88018A   24185.88834810 -.00000270  00000-0  00000+0 0  9998
2 18951  14.5758   5.0133 0002387 168.5702   7.6034  0.99661457117496
0 TELECOM 1C
1 18952U 88018B   24187.15783131 -.00000167  00000-0  00000-0 0  9996
2 18952  15.3398 354.5314 0104239 136.9813  53.8846  0.97958222108479
0 ARIANE 3 R/B
1 18953U 88018C   24187.25215661  .00002549  00000-0  39791-2 0  9992
2 18953   6.4098 199.4640 7133522 280.3828  12.5504  2.41300574308028
0 COSMOS 1932
1 18957U 88019A   24187.33317569 -.00000069  00000-0  17208-4 0  9993
2 18957  65.0430 161.0484 0031137 125.4248 234.9725 13.79755651830939
0 COSMOS 1933
1 18958U 88020A   24187.59280751  .00005601  00000-0  34163-3 0  9990
2 18958  82.5172 133.1359 0006437 134.4743 225.7014 15.10145874957625
0 SL-14 R/B
1 18959U 88020B   24187.55524006  .00000684  00000-0  78108-4 0  9995
2 18959  82.5365  23.3961 0014950 281.8387  78.1152 14.84569744941340
0 IRS 1A
1 18960U 88021A   24187.47363212  .00000333  00000-0  26945-3 0  9991
2 18960  98.9517 253.5801 0014561  16.3388 354.6264 13.96994863753794
0 SL-3 R/B
1 18961U 88021B   24187.41793876 -.00000175  00000-0 -86697-4 0  9996
2 18961  99.0140 247.4176 0053639 346.4191  26.1673 14.00800091855933
0 WESTFORD NEEDLES
1 18962U 63014DN  24165.18649275 -.00000793  00000-0 -11520+0 0  9999
2 18962  86.4728 250.9642 1443435 344.5328  11.5491  8.76700345163151
0 OPS 4682 DEB
1 18964U 65027AM  24186.93377819  .00000516  00000-0  17575-2 0  9995
2 18964  90.2510 343.8387 0032724 179.2062 336.3260 12.97046382763098
0 OPS 4682 DEB
1 18965U 65027AN  24187.44797922  .00000024  00000-0  54988-4 0  9999
2 18965  90.2538   8.7181 0046503 154.0859 236.0436 12.98932880858064
0 OPS 4682 DEB
1 18967U 65027AP  24187.43194800 -.00000008  00000-0 -55527-4 0  9990
2 18967  90.2417 354.5257 0026480 211.9988 176.8269 12.95684962726135
0 COSMOS 1823 DEB
1 18969U 87020AW  24187.51823279  .00000126  00000-0  10256-2 0  9994
2 18969  73.6210 278.6784 0036971 117.9147 256.4653 12.43437251655854
0 COSMOS 1934
1 18985U 88023A   24187.63212646  .00000064  00000-0  49346-4 0  9994
2 18985  82.9576 322.5968 0040269 320.9248  38.9001 13.76574954698100
0 SL-8 R/B
1 18986U 88023B   24187.52804718  .00000111  00000-0  92992-4 0  9998
2 18986  82.9550 287.3333 0041614 185.3477 174.7243 13.78807115825210
0 COSMOS 970 DEB
1 18998U 77121BS  24186.51482708  .00000605  00000-0  66375-3 0  9990
2 18998  65.8270  15.1238 0119407 114.3570 276.0756 13.76530065842517
0 DELTA 1 DEB
1 19000U 76077FH  24187.55967179 -.00000041  00000-0  38152-4 0  9997
2 19000 102.5136 162.0098 0078599 136.4196 292.8398 12.26743978639664
0 COSMOS 1823 DEB
1 19005U 87020BA  24187.41064640  .00000092  00000-0  77654-3 0  9992
2 19005  73.8701 172.1884 0032847 114.2396  40.2782 12.43162149657042
0 COSMOS 1823 DEB
1 19006U 87020BB  24187.37058461  .00096807  00000-0  36279-1 0  9997
2 19006  73.4196 170.8467 0051290 236.7895 274.6038 14.30281790747023
0 DELTA 1 DEB
1 19008U 84088G   24187.01975871  .00002742  00000-0  15639-2 0  9997
2 19008  28.7309 118.0395 1805508 108.5672 271.8771 11.18414439489518
0 GORIZONT 15
1 19017U 88028A   24187.14632559 -.00000176  00000-0  00000-0 0  9996
2 19017  13.5955 335.9633 0037225 174.9763 155.3902  0.97829512112536
0 SL-12 R/B(2)
1 19020U 88028D   24187.51655597 -.00000069  00000-0  00000-0 0  9999
2 19020  13.6086 335.6959 0022874 119.3479 245.6072  0.97783339129518
0 COSMOS 397 DEB *
1 19024U 71015DN  24187.59192425  .00000315  00000-0  45045-3 0  9999
2 19024  66.2760 245.7843 0498120  41.5458  29.2076 13.25176248751366
0 COSMOS 1275 DEB
1 19025U 81053MC  24187.43986907  .00006036  00000-0  27463-2 0  9991
2 19025  82.7085 351.8426 0027352 147.1533 213.1356 14.21392346  1716
0 COSMOS 1275 DEB
1 19026U 81053MD  24186.26928941  .00001559  00000-0  15199-2 0  9994
2 19026  83.1663 295.0666 0114584 305.8406  82.2251 13.75914471953571
0 COSMOS 1275 DEB
1 19027U 81053ME  24186.72451564  .00004930  00000-0  27940-2 0  9991
2 19027  83.0067  67.2079 0069961 117.5889 307.1729 14.08621598981164
0 WESTFORD NEEDLES
1 19030U 63014DY  24187.24622241  .00000002  00000-0 -59505-3 0  9992
2 19030  87.3606 298.3930 0057665  60.2278 300.4296  8.64528376327435
0 DELTA 1 DEB
1 19033U 73086HC  24187.44945396  .00000361  00000-0  25633-2 0  9997
2 19033 101.9211 181.2658 0044559  50.4154 108.6377 12.52895143794619
0 COSMOS 1937
1 19038U 88029A   24187.58665278  .00000266  00000-0  10095-3 0  9999
2 19038  74.0472 330.1314 0024740 232.6068 202.4590 14.35676386897607
0 SL-8 R/B
1 19039U 88029B   24187.60787711  .00000375  00000-0  12894-3 0  9990
2 19039  74.0464 235.1189 0022393 131.2057 229.1033 14.39236300900860
0 SL-3 R/B
1 19046U 88032B   24187.54480246  .00004447  00000-0  27269-3 0  9994
2 19046  97.4494 168.8212 0031453 192.0663 167.9817 15.10232632959388
0 COSMOS 1275 DEB
1 19047U 81053MF  24187.34561052  .00003932  00000-0  19933-2 0  9990
2 19047  82.7844 140.1178 0026251 238.3135 275.2493 14.15638137  3418
0 SL-8 DEB
1 19048U 88029C   24187.58063028  .00004195  00000-0  74415-3 0  9996
2 19048  74.0216  23.9393 0011099 247.9674 174.8965 14.67525796918866
0 WESTFORD NEEDLES
1 19051U 63014EA  24187.05524981  .00000122  00000-0  50081-1 0  9996
2 19051  87.3237 219.6959 0437146 342.1349  16.4554  8.66976500381633
0 OSCAR 23
1 19070U 88033A   24187.48834128  .00000115  00000-0  21624-3 0  9994
2 19070  90.3133   0.1659 0188965 200.6148 214.5948 13.27660181752830
0 OSCAR 32
1 19071U 88033B   24187.53405377  .00000106  00000-0  19589-3 0  9998
2 19071  90.3137   0.2748 0187795 187.7576 236.7518 13.27833420752955
0 SCOUT G-1 R/B
1 19072U 88033C   24187.53553297  .00000097  00000-0  18141-3 0  9996
2 19072  90.3134 359.9614 0187949 214.9737 209.6454 13.27353494752543
0 COSMOS 1940
1 19073U 88034A   24187.51000431  .00000077  00000-0  00000-0 0  9993
2 19073  11.9531 331.4798 0019085 270.1551  77.3067  1.00665678114185
0 SL-12 R/B(2)
1 19076U 88034D   24187.46072795 -.00000098  00000-0  00000-0 0  9996
2 19076  12.2322 332.4517 0026565 170.1724 204.1276  1.00081646131988
0 SCOUT G-1 DEB
1 19077U 88033D   24187.39030185  .00001422  00000-0  21055-2 0  9991
2 19077  90.3030 331.3891 0176561 171.6474 246.1517 13.47401984768340
0 SCOUT G-1 DEB
1 19078U 88033E   24187.36857575  .00000226  00000-0  36679-3 0  9999
2 19078  90.5731 317.7766 0162792 139.3238 276.9416 13.40558672768372
0 EKRAN 18
1 19090U 88036A   24186.24950654 -.00000139  00000-0  00000-0 0  9994
2 19090  14.2471 337.1527 0012262  94.9349 256.4589  0.95180007110224
0 SL-12 R/B(2)
1 19094U 88036E   24186.80605039 -.00000195  00000-0  00000-0 0  9996
2 19094  11.2476 327.5221 0025058 166.0987  33.3914  1.01114555114625
0 SL-8 DEB *
1 19102U 82051G   24187.54557906  .00003353  00000-0  71969-3 0  9991
2 19102  74.0477 285.4168 0010367  45.2446 328.0959 14.58981914911164
0 DELTA 1 DEB
1 19105U 75004HN  24187.45211019  .00000742  00000-0  17628-3 0  9997
2 19105  98.7754  73.0272 0062432 182.2035 352.7160 14.55957443 79442
0 WESTFORD NEEDLES
1 19109U 63014EJ  24187.33581899  .00000806  00000-0  30912+0 0  9990
2 19109  87.2753 144.6369 0562825 133.0778 231.8621  8.68773822396488
0 COSMOS 1691 DEB
1 19111U 85094W   24186.31130068  .00000292  00000-0  14202-2 0  9996
2 19111  82.6067 304.7472 0014304 233.9916 156.4972 12.69758636682807
0 COSMOS 886 DEB
1 19112U 76126BZ  24187.37090668  .00002556  00000-0  64315-3 0  9997
2 19112  65.8244 211.6377 0917066  52.8362 315.2902 13.19175543465979
0 OPS 4682 DEB
1 19113U 65027AQ  24186.71415682  .00000633  00000-0  19236-2 0  9995
2 19113  90.2383 357.6510 0035053 162.4316 211.1362 13.05188213541983
0 COSMOS 1943
1 19119U 88039A   24187.51073896  .00000253  00000-0  15410-3 0  9994
2 19119  71.0042  92.6541 0009359 102.3195  70.0627 14.15466326866179
0 SL-16 R/B
1 19120U 88039B   24187.55501924 -.00000056  00000-0 -36768-5 0  9992
2 19120  71.0152 282.7384 0022737 204.3292 155.6762 14.19422413871513
0 NSS 513 (INTELSAT 513)
1 19121U 88040A   24186.71983508 -.00000260  00000-0  00000-0 0  9995
2 19121  14.9456 354.0076 0016083 106.1199 244.1611  0.98575303107518
0 ARIANE 2 R/B
1 19122U 88040B   24186.29549921  .00000762  00000-0  58559-2 0  9996
2 19122   6.9907 218.2871 7106348  14.0654 358.4737  2.35701848257207
0 SL-16 DEB
1 19125U 88039C   24187.58705976  .00000202  00000-0  21253-3 0  9995
2 19125  71.0333 311.9956 0180003 242.2921 115.9822 13.79369329818035
0 SL-16 DEB
1 19126U 88039D   24187.62134087  .00000116  00000-0  14142-3 0  9993
2 19126  71.0327  28.7984 0185505 258.4710 170.0272 13.77622894815833
0 SL-16 DEB
1 19127U 88039E   24187.43073247  .00000123  00000-0  15483-3 0  9990
2 19127  70.9868 192.9179 0208426 157.7573 317.7994 13.72446973809042
0 SL-16 DEB
1 19128U 88039F   24187.41568712  .00000093  00000-0  12802-3 0  9993
2 19128  70.9813 174.3716 0203750 183.9190 339.3512 13.72585732809396
0 SL-14 DEB
1 19133U 78100F   24187.34733162  .00004583  00000-0  24166-1 0  9994
2 19133  82.3281  49.7687 0135537 319.5615 217.2211 12.63834851 46522
0 SL-14 DEB
1 19134U 78100G   24187.50719794  .00005555  00000-0  23464-1 0  9998
2 19134  82.3359 214.1595 0047640  23.0411 130.4440 12.82421191 58997
0 SL-14 DEB
1 19136U 78100J   24187.41050685 -.00001774  00000-0 -44786-2 0  9999
2 19136  82.4204 303.0143 0408435  10.6606  52.8018 12.93362126116400
0 SL-14 DEB
1 19137U 78100K   24187.42716814  .00006076  00000-0  30502-1 0  9992
2 19137  82.3052 346.3444 0090569 234.0910 192.0976 12.68961368 45530
0 SL-14 DEB
1 19138U 78100L   24187.19500851  .00000224  00000-0  17542-2 0  9998
2 19138  82.3070  93.1919 0163331 229.1232 286.1698 12.30165814620238
0 SL-14 DEB
1 19139U 78100M   24187.14365980  .00000074  00000-0  11631-2 0  9992
2 19139  82.1420  79.1713 0145559 239.1718 276.8250 11.70389487543820
0 SCOUT G-1 DEB
1 19140U 88033F   24187.17372390  .00003306  00000-0  36490-2 0  9997
2 19140  90.2992 351.9281 0237722 102.7551 324.1372 13.60278911775112
0 COSMOS 1823 DEB
1 19141U 87020BD  24187.13571201  .00051858  00000-0  33648-1 0  9997
2 19141  73.8888  76.1477 0014296 159.8312 351.2025 14.02197521723544
0 SL-14 DEB
1 19143U 78100P   24187.11763013  .00000969  00000-0  40285-2 0  9993
2 19143  81.6980 228.6441 0310382 214.9404 172.3781 12.69424571667391
0 SL-14 DEB
1 19144U 78100Q   24187.49537465  .00000109  00000-0  13993-2 0  9997
2 19144  82.6158 265.9198 0051120  69.9720 303.1883 11.89572718568748
0 THORAD AGENA D DEB
1 19150U 70025PS  24187.25155847  .00008697  00000-0  53131-2 0  9994
2 19150 100.3282  11.2433 0025198 282.5739  77.2606 14.06040419804581
0 COSMOS 1932 FUEL CORE
1 19162U 88019D   24187.62171095 -.00000060  00000-0  25497-4 0  9996
2 19162  65.0442 276.6240 0008256  61.7173  39.8571 13.83910492825632
0 COSMOS 1946 (GLONASS)
1 19163U 88043A   24187.17624095 -.00000040  00000-0  00000+0 0  9993
2 19163  64.5919  97.9847 0003315  90.3593  92.7428  2.13103327280555
0 COSMOS 1947 (GLONASS)
1 19164U 88043B   24187.54938262 -.00000036  00000-0  00000-0 0  9995
2 19164  64.5894  97.8940 0024308 224.4326 310.3526  2.13103824276139
0 COSMOS 1948 (GLONASS)
1 19165U 88043C   24186.26670608 -.00000047  00000-0  00000-0 0  9993
2 19165  64.5784  97.7446 0002893 309.5629 223.8478  2.13102933280818
0 SL-12 R/B(2)
1 19168U 88043F   24187.17545774 -.00000040  00000-0  00000-0 0  9995
2 19168  64.6079  95.8603 0012960 221.5141 317.1146  2.13498467281563
0 SL-12 R/B(AUX MOTOR)
1 19169U 88043G   24187.25694919  .00002182  00000-0  17409-2 0  9992
2 19169  65.0896 173.5967 5782440 349.5434   2.2414  4.27155240560433
0 SL-12 R/B(AUX MOTOR)
1 19170U 88043H   24187.25473598  .00000078  00000-0  17535-3 0  9995
2 19170  65.2338 184.2511 5585058  58.3962 344.3753  4.25031312559793
0 SL-14 DEB
1 19174U 78100R   24187.31604135  .00000029  00000-0  18743-3 0  9990
2 19174  81.9057 126.0706 0145771 174.9141 340.9525 12.22156747611742
0 SL-14 DEB
1 19175U 78100S   24187.60592976  .00014029  00000-0  30153-1 0  9994
2 19175  82.3956  19.0803 0274084 150.2128 275.5393 13.16725313666243
0 SL-14 DEB
1 19176U 78100T   24187.54214471  .00000202  00000-0  24293-2 0  9996
2 19176  82.0938  17.8413 0152096  57.5872  13.7260 11.96016582575596
0 SL-14 DEB
1 19178U 78100U   24187.37906213  .00003241  00000-0  32422-1 0  9999
2 19178  82.1179 142.5244 0038457  56.6164  62.9959 12.16931842599272
0 SCOUT G-1 DEB
1 19181U 88033G   24187.56676668  .00000204  00000-0  40691-3 0  9993
2 19181  89.8466 288.7880 0247913 270.3186 102.8374 13.21748672743546
0 THORAD DELTA 1 DEB
1 19183U 74089FD  24187.45122498  .00001352  00000-0  29259-2 0  9997
2 19183 103.5293 166.2515 0187168 285.1185 236.4228 13.26267995686270
0 OPS 4682 DEB
1 19185U 65027AR  24187.46365295  .00000539  00000-0  18323-2 0  9992
2 19185  90.2479 348.2818 0037245 146.9949 277.4514 12.97189752857814
0 COSMOS 1950
1 19195U 88046A   24187.61364873 -.00000022  00000-0 -33251-4 0  9995
2 19195  73.6015 339.2037 0023346 135.1278 297.8088 12.40909215635336
0 SL-14 R/B
1 19196U 88046B   24187.50846645 -.00000029  00000-0 -87166-4 0  9997
2 19196  73.6017 321.4630 0020120 120.4720 308.0309 12.41401537636008
0 COSMOS 1953
1 19210U 88050A   24187.60892027  .00006571  00000-0  34519-3 0  9994
2 19210  82.5138  48.3154 0015970 105.3304 254.9695 15.15424338944659
0 SL-14 R/B
1 19211U 88050B   24187.61491122  .00000769  00000-0  88760-4 0  9998
2 19211  82.5272 312.6426 0019826 267.6688  92.2258 14.84240276927470
0 METEOSAT 3
1 19215U 88051A   24186.91517995 -.00000084  00000-0  00000-0 0  9990
2 19215  14.8797 346.8344 0001478 113.2809 241.7195  0.96946792116494
0 PAS 1
1 19217U 88051C   24186.25786072 -.00000186  00000-0  00000-0 0  9996
2 19217  14.2708   9.8790 0002208  95.1588 268.5534  0.99396190141099
0 ARIANE 44LP DEB
1 19219U 88051E   24187.22618080  .00004333  00000-0  14139-2 0  9996
2 19219   9.9584 194.5382 6785816 287.9389  12.7271  2.91475329336507
0 COSMOS 886 DEB
1 19221U 76126CB  24187.22319074  .00000757  00000-0  86290-3 0  9994
2 19221  65.8369 109.4293 0851947  91.8779 277.9899 12.73394681475503
0 NOVA 2
1 19223U 88052A   24187.62478186  .00000062  00000-0  12641-3 0  9999
2 19223  89.9829  79.2052 0031572  23.7977  38.7328 13.22846659740055
0 SL-14 DEB
1 19226U 78100V   24187.02085161  .00000290  00000-0  34578-2 0  9991
2 19226  82.5328  37.7096 0041129 234.9701 284.1204 12.00509960580696
0 SL-14 DEB
1 19228U 78100X   24187.54985944  .00000457  00000-0  12095-2 0  9993
2 19228  82.4618 109.8896 0187549 347.9597 189.1537 13.08235138651822
0 SL-14 DEB
1 19229U 78100Y   24187.50115780  .00086616  00000-0  67281-1 0  9990
2 19229  82.3029 182.0086 0188619  49.4775  72.4601 13.83954402 89694
0 SL-14 DEB
1 19230U 78100Z   24187.36434124  .00000079  00000-0  88614-3 0  9996
2 19230  82.5343  45.6638 0014666 240.0790 239.9994 11.98709554581052
0 SL-14 DEB
1 19232U 78100AB  24186.77128635  .00000003  00000-0 -62952-4 0  9995
2 19232  82.3331 298.6650 0192855 227.8755 292.3131 11.67536915539902
0 SL-14 DEB
1 19233U 78100AC  24186.86791965  .00000173  00000-0  18688-2 0  9990
2 19233  82.5586 339.3502 0056422 240.8622 273.6333 12.06602567588993
0 SL-14 DEB
1 19234U 78100AD  24186.53017711  .00000252  00000-0  37626-2 0  9996
2 19234  82.4276 220.9587 0141849 349.1017 166.4278 11.80022172554827
0 SL-8 DEB
1 19235U 70102G   24187.47508284  .00000333  00000-0  28850-3 0  9995
2 19235  74.0183 213.5699 0005645 327.2948 103.3891 13.90120321987365
0 THORAD AGENA D DEB
1 19238U 70025PT  24186.92404933  .00001975  00000-0  20353-2 0  9999
2 19238  99.8424 341.1051 0046640 136.5816  14.9496 13.76895068841904
0 OPS 4682 DEB
1 19242U 65027AS  24187.25992226 -.00000464  00000-0 -15354-2 0  9993
2 19242  90.2453   9.2964 0028305 195.3551 341.6611 13.01284196544718
0 COSMOS 886 DEB
1 19244U 76126CA  24187.31837317  .00000383  00000-0  99186-3 0  9997
2 19244  66.0500 264.4471 0718690 140.6470 291.3796 12.56890523552044
0 P/L 153 DEB
1 19245U 67053K   24187.58723882  .00001200  00000-0  57932-3 0  9999
2 19245  69.9574 129.8858 0004058 343.7168 191.1736 14.20983220929125
0 THORAD AGENA D DEB
1 19250U 70025PU  24187.55330899  .00003596  00000-0  34624-2 0  9999
2 19250  99.4650 286.8299 0180088 183.2195 304.7946 13.73760834787287
0 COSMOS 1954
1 19256U 88053A   24187.58205931  .00000231  00000-0  90940-4 0  9994
2 19256  74.0472 266.0473 0014909  95.3909 264.8944 14.34503468884932
0 SL-8 R/B
1 19257U 88053B   24187.38257823  .00000311  00000-0  11071-3 0  9996
2 19257  74.0466 160.5622 0019341 136.2006 334.6939 14.38212745888548
0 SL-8 DEB
1 19260U 88053C   24187.61281001  .00002468  00000-0  57203-3 0  9993
2 19260  74.0607 259.3094 0007591 252.1732 228.9186 14.55588608898012
0 SL-8 DEB
1 19261U 88053D   24187.50104775  .00002483  00000-0  58198-3 0  9995
2 19261  74.0538 265.7469 0011407 286.6258  84.9764 14.55035420897558
0 OKEAN 1
1 19274U 88056A   24187.41526489  .00007077  00000-0  36096-3 0  9999
2 19274  82.4756 157.9679 0018378 154.7926 205.4208 15.16434401941792
0 SL-14 R/B
1 19275U 88056B   24187.40558695  .00000710  00000-0  82281-4 0  9998
2 19275  82.5152  79.6006 0019766   7.4720 352.6785 14.83934956923828
0 THORAD AGENA D DEB
1 19290U 70025PV  24187.32447378  .00000367  00000-0  56651-3 0  9997
2 19290  99.8277 123.8693 0025623 212.4575 299.5985 13.58348800941866
0 DELTA 1 DEB
1 19291U 73086HD  24187.45569306  .00000346  00000-0  25248-2 0  9992
2 19291 101.7521 162.2217 0040012  81.3078  76.3447 12.51080354644459
0 THOR ABLESTAR DEB
1 19293U 61015MA  24186.38741368  .00000412  00000-0  98534-3 0  9997
2 19293  66.9878 323.3214 0343056 295.5606  91.5047 13.12185385734199
0 COSMOS 252 DEB
1 19294U 68097EE  24183.89117076  .00007920  00000-0  78282-2 0  9999
2 19294  62.2225 349.4532 0665055 150.4444 213.5937 13.08680200711787
0 SL-14 DEB
1 19295U 78100AE  24186.70803105 -.00000159  00000-0 -12996-2 0  9993
2 19295  81.9831  88.8137 0493917 252.2956 129.5241 12.06526014587211
0 THOR ABLESTAR DEB
1 19302U 61015MC  24187.36148476  .00001273  00000-0  77544-3 0  9992
2 19302  66.8437 159.4211 0050243 146.7556 213.6706 14.08707303854478
0 DELTA 1 DEB
1 19306U 76077FJ  24187.13378935  .00000022  00000-0  64526-3 0  9997
2 19306 102.1631 312.9254 0144373 223.6278 313.1496 12.15392459588732
0 COSMOS 252 DEB
1 19309U 68097ES  24187.05922836  .00001351  00000-0  51150-3 0  9994
2 19309  62.3689 307.9494 0935767 124.6179 244.6715 13.03051694578349
0 DELTA 1 DEB
1 19311U 75004HP  24187.55562510  .00001322  00000-0  46456-3 0  9998
2 19311  97.6366 212.5059 0139943 263.7178  94.8053 14.31035754885666
0 TANSEI 3 DEB
1 19314U 77012L   24187.11361378  .00000898  00000-0  11030-2 0  9999
2 19314  65.3706 338.1989 1859015 141.8487 232.9966 10.85164934491800
0 DELTA 1 DEB
1 19316U 76077FK  24187.40913411  .00000193  00000-0  25997-2 0  9999
2 19316 102.0708 358.9031 0209502 206.8938 180.9009 12.03611826726386
0 COSMOS 249 DEB
1 19317U 68091DH  24185.86280144  .00003410  00000-0  93471-3 0  9993
2 19317  62.8341   0.7750 0791890 132.9555 234.0725 13.40355487751635
0 COSMOS 1959
1 19324U 88062A   24187.59080476  .00000078  00000-0  64198-4 0  9991
2 19324  82.9513 290.6640 0032946 311.4349  59.2206 13.76240321805821
0 SL-8 R/B
1 19325U 88062B   24187.58151299  .00000100  00000-0  84497-4 0  9993
2 19325  82.9504 268.5858 0032959 216.2572 258.9839 13.77785019769863
0 INSAT 1C
1 19330U 88063A   24186.98658388 -.00000006  00000-0  00000-0 0  9994
2 19330  12.2795 332.6843 0012411 140.7776 229.5230  1.00236517113209
0 EUTE 1-F5 (ECS 5)
1 19331U 88063B   24187.54635358 -.00000186  00000-0  00000-0 0  9999
2 19331  14.9287 351.0827 0014549 142.2944 117.7454  0.98166038107351
0 METEOR 3-2
1 19336U 88064A   24187.56236875 -.00000105  00000-0 -30400-3 0  9990
2 19336  82.5438 114.6548 0016770 182.6423 351.3339 13.17242353727969
0 SL-14 R/B
1 19337U 88064B   24187.53622537  .00000114  00000-0  26368-3 0  9998
2 19337  82.5476 117.4748 0014828 215.0261 319.7124 13.17254729728048
0 COSMOS 1961
1 19344U 88066A   24186.90022006 -.00000139  00000-0  00000-0 0  9993
2 19344  12.3648 334.5419 0007367 143.6241 207.4608  1.00262599131860
0 SL-12 R/B(2)
1 19347U 88066D   24187.54632894 -.00000082  00000-0  00000-0 0  9996
2 19347  13.0353 336.6062 0035967 129.0794 220.7064  0.98658800128937
0 THORAD AGENA D DEB
1 19351U 70025PW  24187.40141501  .00000619  00000-0  73811-3 0  9990
2 19351 100.1112 346.0949 0028663 200.8909 188.8999 13.71654494833083
0 OPS 4682 DEB
1 19355U 65027AT  24187.38555479 -.00000177  00000-0 -63285-3 0  9995
2 19355  90.2430 342.0436 0047008 117.7334 271.0839 12.97616837710367
0 DELTA 1 DEB
1 19359U 78026HM  24186.46558684  .00003763  00000-0  10250-2 0  9996
2 19359  98.5818 183.3724 0018310 193.9215 319.0817 14.47919246398948
0 DELTA 1 DEB
1 19360U 73086HE  24187.41045718  .00000937  00000-0  59462-2 0  9992
2 19360 101.8829 249.9651 0047659  66.8984 306.1698 12.55978768790421
0 COSMOS 249 DEB
1 19362U 68091DJ  24187.28469367  .00002652  00000-0  59739-3 0  9993
2 19362  62.7908 291.7008 0461135 312.3512  43.9335 14.08864420819001
0 THORAD AGENA D DEB
1 19363U 70025PY  24184.81904583  .00000421  00000-0  60946-3 0  9998
2 19363  99.9631 292.7770 0004975  38.4890 116.1746 13.61714052599618
0 DELTA 1 DEB
1 19365U 75004HQ  24186.97200701  .00002058  00000-0  72187-3 0  9990
2 19365  97.6292 193.9575 0138379 337.2731  22.2365 14.30705969877711
0 COSMOS 397 DEB *
1 19367U 71015DS  24187.28916174  .00000487  00000-0  48211-3 0  9998
2 19367  65.7131  22.4993 0160999  55.9926 118.1983 13.81733244824405
0 THORAD AGENA D DEB
1 19391U 70025PZ  24187.10244417  .00002647  00000-0  17651-2 0  9993
2 19391  98.7894  61.2105 0149128 117.5270  39.2062 13.96657920819506
0 TIROS 8 DEB
1 19396U 63054E   24187.38205531  .00005337  00000-0  43035-3 0  9991
2 19396  58.4681 183.3808 0022566 134.8054 225.4838 15.01096836927110
0 GORIZONT 16
1 19397U 88071A   24187.39146458 -.00000219  00000-0  00000-0 0  9998
2 19397  12.4310 334.6388 0013358  84.3871 286.2314  0.99969615131126
0 SL-12 R/B(2)
1 19400U 88071D   24187.29402674 -.00000177  00000-0  00000-0 0  9990
2 19400  12.1707 333.9016 0020229 212.0122 352.8328  1.00533256125547
0 OSCAR 25
1 19419U 88074A   24187.54111507  .00000127  00000-0  20445-3 0  9995
2 19419  90.0174  18.7843 0094574 305.3948 116.2994 13.42464412755931
0 OSCAR 31
1 19420U 88074B   24187.63002634  .00000096  00000-0  15095-3 0  9997
2 19420  90.0189  19.0535 0092685 299.1846 127.9749 13.42453169756057
0 SCOUT G-1 R/B
1 19421U 88074C   24187.56500043  .00000090  00000-0  14181-3 0  9996
2 19421  90.0190  19.1607 0094694 333.5406  84.3518 13.41871641755640
0 THORAD AGENA D DEB
1 19422U 70025QA  24186.87431891  .00000495  00000-0  66314-3 0  9995
2 19422 100.1597 211.1338 0009577 284.6262 200.0561 13.65855951949396
0 COSMOS 886 DEB *
1 19425U 76126CC  24187.13383377  .00000590  00000-0  24073-2 0  9992
2 19425  66.2223  89.3945 0329899 163.8472 345.9285 12.75952406524225
0 DELTA 1 DEB
1 19429U 77065FY  24186.79683630  .00006475  00000-0  84278-3 0  9997
2 19429  29.1094   7.6712 0434386 242.2439 113.3448 14.29939557783858
0 COSMOS 839 DEB
1 19439U 76067BS  24187.22849745  .00000403  00000-0  16047-2 0  9992
2 19439  65.8691 129.1384 0687250 132.1243 304.9440 12.36073850494797
0 COSMOS 1823 DEB
1 19440U 87020CA  24187.17584587  .00000032  00000-0  22559-3 0  9993
2 19440  73.7534 351.1131 0162816 270.5970 205.0520 12.75829852687710
0 SL-14 DEB
1 19450U 78100AH  24187.16792478  .00000098  00000-0  11297-2 0  9990
2 19450  82.5492  67.4601 0013131 248.4505 274.8072 11.98156659573198
0 SL-8 DEB
1 19451U 88016K   24187.47985049  .00000232  00000-0  21280-2 0  9993
2 19451  74.0030 226.9124 0129409 330.4981  94.9105 12.27237964614490
0 COSMOS 1375 DEB
1 19453U 82055BL  24187.28287972  .00004784  00000-0  16679-2 0  9993
2 19453  65.8044 119.0559 0040862 115.3921  45.8538 14.35721163869710
0 USA 31
1 19458U 88077A   24187.35614915  .00000283  00000-0  43681-2 0  9990
2 19458  26.6290 215.2991 7313662 203.0220  91.0374  2.00559480  1020
0 USA 32
1 19460U 88078A   24187.48328924  .00000286  00000-0  95393-4 0  9992
2 19460  84.9873 166.7687 0002130 185.5096 174.6074 14.33971577  7173
0 FENGYUN 1A
1 19467U 88080A   24187.58186522 -.00000162  00000-0 -74763-4 0  9992
2 19467  99.1286 231.3412 0014650 152.8158 207.3778 14.03327760834086
0 CZ-4 R/B
1 19468U 88080B   24187.59495684 -.00000009  00000-0  21669-4 0  9992
2 19468  99.0620 231.4770 0072340 108.7111   7.4581 14.03668846834359
0 COSMOS 1375 DEB
1 19473U 82055BM  24187.35894012  .00001415  00000-0  11658-2 0  9992
2 19473  65.8256 305.8404 0035048 235.8593 158.5635 13.92053508866927
0 COSMOS 886 DEB
1 19475U 76126CD  24186.88628324  .00001976  00000-0  98956-3 0  9993
2 19475  65.8590 152.7891 0820445 185.1474 174.0725 13.12631009615887
0 COSMOS 252 DEB
1 19479U 68097ET  24186.91988722  .00001343  00000-0  36016-3 0  9997
2 19479  62.8057 325.4280 0557951 344.3047  14.1284 13.87017112793191
0 GSTAR 3
1 19483U 88081A   24187.41457808 -.00000108  00000-0  00000-0 0  9999
2 19483  12.2956 324.0428 0009441 179.7184 184.0646  1.00272605127462
0 SBS 5
1 19484U 88081B   24186.75768992 -.00000172  00000-0  00000-0 0  9996
2 19484  14.4395   6.2377 0002395 319.1279 223.4931  0.99798289 39355
0 TITAN 34D TRANSTAGE R/B
1 19490U 88077C   24187.38337503 -.00000577  00000-0  13561-2 0  9995
2 19490  27.2251 304.8603 7388988 322.1529   4.1300  2.03279143 37888
0 COSMOS 1970 (GLONASS)
1 19501U 88085A   24186.57723025 -.00000086  00000-0  00000-0 0  9992
2 19501  65.6077 338.6381 0009766  44.1624  23.0150  2.13102010278592
0 COSMOS 1971 (GLONASS)
1 19502U 88085B   24187.14632559 -.00000086  00000-0  00000-0 0  9998
2 19502  65.6013 338.5419 0022167  16.7864 333.8088  2.13101574264170
0 COSMOS 1972 (GLONASS)
1 19503U 88085C   24185.58989153 -.00000083  00000-0  00000-0 0  9997
2 19503  65.6364 339.0272 0004042 210.3031 120.5310  2.13102139278423
0 SL-12 R/B(2)
1 19505U 88085E   24187.12015052 -.00000086  00000-0  00000-0 0  9992
2 19505  65.5815 337.3583 0010453 212.7888 145.9712  2.13368783278842
0 CS 3B
1 19508U 88086A   24187.05809684  .00000053  00000-0  00000-0 0  9993
2 19508  14.9846 359.0530 0001227   0.3179   9.3484  0.99220956130198
0 OPS 4682 DEB
1 19511U 65027AU  24187.61414498  .00000779  00000-0  26527-2 0  9993
2 19511  90.2435 343.0358 0034573 129.1764   1.9056 12.97426427709618
0 DELTA 1 DEB
1 19512U 73086HF  24185.91762258  .00000001  00000-0  37532-3 0  9996
2 19512 102.3828 178.8928 0029083 311.1004  78.0805 12.35163711629408
0 SCOUT G-1 DEB
1 19515U 88074D   24187.44591279  .00000426  00000-0  63632-3 0  9996
2 19515  89.9018 343.5668 0092728  12.1574  42.4977 13.50157640761820
0 SCOUT G-1 DEB
1 19516U 88074E   24186.54456514  .00000463  00000-0  69302-3 0  9990
2 19516  90.0162  21.8961 0086294 343.5791  42.9284 13.50435691762393
0 TITAN 3C TRANSTAGE DEB
1 19518U 65108Z   24187.59680891 -.00000007  00000-0  25667-3 0  9999
2 19518  26.3249 243.6152 6670716 246.2247 143.3180  2.91217350323980
0 NOAA 11
1 19531U 88089A   24187.59461202  .00000099  00000-0  71840-4 0  9995
2 19531  98.5190 149.3493 0011068 175.9317 184.1950 14.15547867846795
0 SL-12 R/B(AUX MOTOR)
1 19535U 88085F   24187.24907036  .00001285  00000-0  15882-2 0  9997
2 19535  65.0749 165.6108 5590264  47.2250 347.9221  4.51363034566491
0 SL-12 R/B(AUX MOTOR)
1 19537U 88085G   24187.47661889  .00000102  00000-0  34444-3 0  9990
2 19537  65.1098 221.4487 5555848 115.8426 310.6103  4.36691304563713
0 TDRS 3
1 19548U 88091B   24187.26368655 -.00000307  00000-0  00000-0 0  9997
2 19548  13.1483 345.7969 0033443 341.3486   2.4177  1.00264771118243
0 IUS R/B(1)
1 19549U 88091C   24187.23421567  .00002129  00000-0  11414-2 0  9993
2 19549  26.4527 248.1726 6826024 337.3967   3.3441  2.83686195335950
0 IUS R/B(2)
1 19550U 88091D   24187.58117984  .00000090  00000-0  00000-0 0  9990
2 19550  13.0658 336.2537 0016859 281.6222  86.3094  1.00473558122969
0 COSMOS 1974
1 19554U 88092A   24184.52659413  .00000180  00000-0  00000+0 0  9993
2 19554  69.9685 210.0256 4342342  84.4926  48.1148  2.00596638261846
0 SL-6 R/B(2)
1 19557U 88092D   24186.44862118 -.00000511  00000-0  00000+0 0  9996
2 19557  69.3615 136.7753 5358251  56.3267  59.8301  2.04134477266539
0 SCOUT G-1 DEB
1 19559U 88074F   24187.20391235  .00000238  00000-0  37427-3 0  9992
2 19559  89.3648  83.7945 0095650 178.6335 336.1023 13.45240472758520
0 COSMOS 252 DEB
1 19561U 68097EU  24187.56029008  .00082450  00000-0  33353-2 0  9992
2 19561  62.2405 359.0855 0159796  82.3024 279.6187 15.13226960787900
0 COSMOS 1823 DEB
1 19562U 87020CD  24187.13708795  .00012693  00000-0  13350-1 0  9996
2 19562  74.3802  70.0447 0122354 109.5668  42.3224 13.71592853134293
0 COSMOS 1975
1 19573U 88093A   24187.58140216  .00007582  00000-0  40694-3 0  9990
2 19573  82.5253   6.0384 0015415 150.9555 209.2538 15.14691448926301
0 SL-14 R/B
1 19574U 88093B   24187.58775615  .00000648  00000-0  73850-4 0  9995
2 19574  82.5311 256.1588 0019617 261.5365 215.2859 14.84504987910186
0 OPS 4682 DEB
1 19576U 65027AV  24187.24760597  .00001020  00000-0  33522-2 0  9990
2 19576  90.2377 353.4263 0024315 301.7282 181.3607 13.00230665705815
0 SCOUT G-1 DEB
1 19577U 88074G   24185.95482431  .00000227  00000-0  36573-3 0  9990
2 19577  90.5499  97.8403 0088832 221.7351 269.3722 13.44935567757656
0 SL-14 DEB
1 19580U 78100AL  24187.03445789  .00000173  00000-0  83975-3 0  9997
2 19580  82.6542  28.5799 0304500 294.8256 223.5718 12.56397855607170
0 DELTA 1 DEB
1 19590U 73086HG  24187.51844005 -.00000032  00000-0  11772-3 0  9994
2 19590 102.4822 192.5567 0045550 249.2956 263.3150 12.31836388558524
0 TITAN 3C TRANSTAGE DEB
1 19592U 65108AA  24187.20251304  .00000670  00000-0  33428-2 0  9990
2 19592  26.4205 156.6298 6733865  78.7328 351.1184  2.82929538325110
0 OPS 4682 DEB
1 19593U 65027AW  24187.25267542  .00000437  00000-0  15309-2 0  9996
2 19593  90.2406 350.9069 0028954 186.8718 295.1129 12.95022829709936
0 DELTA 1 DEB
1 19594U 78026HN  24187.30481953  .00009431  00000-0  34492-2 0  9997
2 19594  98.9402 204.4221 0099629 106.2908 254.9260 14.30391111603436
0 TITAN 3C TRANSTAGE DEB
1 19595U 65108AB  24186.55983060  .00000868  00000-0  92552-3 0  9994
2 19595  27.0066 308.7843 5977737  37.6251 351.9175  3.97042514415224
0 RADUGA 22
1 19596U 88095A   24187.05157014  .00000125  00000-0  00000-0 0  9993
2 19596  12.4389 335.0196 0008497 167.7219 190.2509  1.00343801114504
0 DELTA 1 DEB
1 19599U 84088H   24186.55846759  .00001865  00000-0  11241-2 0  9992
2 19599  28.7256 297.8159 1915421 230.8611 110.5651 10.94930053158973
0 COSMOS 1977
1 19608U 88096A   24185.49404247  .00000535  00000-0  00000-0 0  9992
2 19608  69.2183 148.4910 5100269  68.4177  13.6667  2.00821132261487
0 SL-6 R/B(2)
1 19611U 88096D   24187.24900295  .00000414  00000-0  00000-0 0  9991
2 19611  68.2483  50.2241 6115167  47.7030 350.2232  2.04282269266177
0 TDF 1
1 19621U 88098A   24187.46358992 -.00000035  00000-0  00000-0 0  9999
2 19621  14.9362 355.6640 0010332 222.2798 134.7687  0.99191871126781
0 ARIANE 2 R/B
1 19622U 88098B   24187.46648061  .00022808  00000-0  30874-2 0  9994
2 19622   3.9301  63.2349 6177032  72.2150 343.1399  3.79906322397369
0 DELTA 1 DEB *
1 19638U 77065GB  24186.86678775  .00001274  00000-0  32806-2 0  9992
2 19638  31.0105 359.5730 0688777 265.9071 243.6942 12.51716341485204
0 COSMOS 1823 DEB
1 19640U 87020CE  24187.62083091 -.00000054  00000-0 -36282-3 0  9993
2 19640  73.5493 324.5877 0168370  34.0459 338.1415 12.16882005506356
0 SL-3 DEB
1 19643U 78121C   24187.10606941  .00000289  00000-0  13811-3 0  9997
2 19643  81.2396 157.7980 0066013  69.9945  51.0645 14.15579178842765
0 SL-14 DEB
1 19646U 78100AM  24187.51929072  .00029978  00000-0  75250-1 0  9994
2 19646  82.1064  89.2764 0210042  25.2558 150.1314 13.11666723322661
0 COSMOS 1980
1 19649U 88102A   24187.34442369  .00000087  00000-0  69769-4 0  9991
2 19649  71.0001  60.2558 0005713 339.0547  21.0340 14.14959225838510
0 SL-16 R/B
1 19650U 88102B   24187.61166899 -.00000132  00000-0 -42493-4 0  9992
2 19650  71.0001 359.2221 0015901 228.4853 131.4906 14.15979770840246
0 SL-16 DEB
1 19656U 88102C   24187.34853447  .00000126  00000-0  15859-3 0  9996
2 19656  70.9791 143.5332 0209883 130.1272 231.8429 13.71602262781565
0 SL-16 DEB
1 19657U 88102D   24187.26538527  .00000180  00000-0  20880-3 0  9997
2 19657  70.9809 130.0657 0208940  93.9008  71.9782 13.71889828782003
0 SL-16 DEB
1 19658U 88102E   24187.40173292  .00000055  00000-0  90424-4 0  9991
2 19658  71.0211  62.6548 0198494 307.2117 229.3376 13.74765667785756
0 SL-16 DEB
1 19659U 88102F   24187.51444321  .00000189  00000-0  20609-3 0  9993
2 19659  71.0373 339.0378 0187836 191.6131 241.4801 13.77058340788798
0 OPS 4682 DEB
1 19664U 65027AX  24187.41124816  .00000662  00000-0  20807-2 0  9998
2 19664  90.2394 341.9994 0023951 282.4872 106.0348 13.03093479963950
0 THORAD AGENA D DEB
1 19667U 70025QC  24187.45215029  .00000369  00000-0  13056-2 0  9998
2 19667  99.7021 172.9230 0336402 270.0476 246.7779 12.85172052690388
0 EKRAN 19
1 19683U 88108A   24187.53748571 -.00000134  00000-0  00000-0 0  9993
2 19683  14.2958 341.2561 0029254 192.2765  62.5296  0.96652189126694
0 SL-12 R/B(2)
1 19686U 88108D   24187.38591002 -.00000263  00000-0  00000-0 0  9997
2 19686  12.1000 333.0044 0017381 181.1150 190.5767  1.01518094117227
0 SKYNET 4B
1 19687U 88109A   24187.39702169 -.00000179  00000-0  00000-0 0  9994
2 19687  13.7763 342.0670 0002659 203.5351 160.6985  0.99668651111078
0 ASTRA 1A
1 19688U 88109B   24187.08959902 -.00000062  00000-0  00000-0 0  9991
2 19688  14.4404  11.0822 0020147 109.1202  57.5636  0.98338427109088
0 ARIANE 44LP R/B
1 19689U 88109C   24187.13700707 -.00000020  00000-0  61886-3 0  9991
2 19689   6.6157 172.8860 7165347 187.1621 149.8196  2.29711304261737
0 STTW-3
1 19710U 88111A   24187.05396527  .00000110  00000-0  00000-0 0  9998
2 19710  14.4293 350.9418 0008096 149.5070 202.0341  1.00298292123698
0 COSMOS 1987 (GLONASS)
1 19749U 89001A   24186.82618568 -.00000043  00000-0  00000-0 0  9991
2 19749  64.5495  96.7149 0004007 219.1890 329.0830  2.13103387276112
0 COSMOS 1988 (GLONASS)
1 19750U 89001B   24187.26343184 -.00000039  00000-0  00000-0 0  9996
2 19750  64.5645  97.0337 0015170 219.3057 232.4431  2.13101842276112
0 COSMOS 1989 (ETALON 1)
1 19751U 89001C   24187.24961186 -.00000040  00000-0  00000-0 0  9995
2 19751  64.5611  96.6177 0023803 215.9514 276.7256  2.13156176276199
0 SL-12 DEB
1 19753U 89001E   24187.44400432 -.00000038  00000-0  00000-0 0  9998
2 19753  64.5620  96.5836 0024454 215.1304 322.8977  2.13160718276510
0 SL-12 R/B(2)
1 19754U 89001F   24185.27888324 -.00000052  00000-0  00000-0 0  9994
2 19754  64.5746  95.3574 0015373 236.9202 301.0511  2.13421063276464
0 SL-12 R/B(AUX MOTOR)
1 19755U 89001G   24187.50329288  .00000072  00000-0  63980-3 0  9992
2 19755  65.2387 251.2424 5541600 114.1065 312.1247  4.25591208550825
0 GORIZONT 17
1 19765U 89004A   24186.91507233 -.00000030  00000-0  00000-0 0  9994
2 19765  13.0671 338.1028 0023485 151.8992 210.3998  0.99063719128524
0 COSMOS 1992
1 19769U 89005A   24187.51872848  .00000246  00000-0  94685-4 0  9997
2 19769  74.0467 113.3470 0021497 137.5948 222.6871 14.35349958854715
0 SL-8 R/B
1 19770U 89005B   24187.62323587  .00000415  00000-0  14119-3 0  9993
2 19770  74.0463 341.3298 0004336 151.0886 285.5771 14.39579314856724
0 INTELSAT 515
1 19772U 89006A   24187.15617788 -.00000077  00000-0  00000-0 0  9999
2 19772  14.9764 359.5099 0025917 107.2352  70.3627  0.99104649117560
0 ARIANE 2 R/B
1 19773U 89006B   24186.86680008  .00000170  00000-0  17198-2 0  9993
2 19773   8.6741 332.8603 7180047 294.5053   9.1615  2.28826688294338
0 SL-12 R/B(2)
1 19776U 89004F   24187.15095653 -.00000207  00000-0  00000-0 0  9997
2 19776  13.5789 339.3497 0025479 118.3740  51.0522  0.97995448111412
0 SL-12 R/B(2)
1 19777U 88095F   24187.18616153 -.00000194  00000-0  00000+0 0  9998
2 19777  13.5196 338.4815 0014534 234.3914 126.2406  0.97939762115306
0 COSMOS 1994
1 19785U 89009A   24187.49973874  .00000040  00000-0  15617-3 0  9996
2 19785  82.6207  85.0010 0013591 126.2734  47.0223 12.64315571633448
0 COSMOS 1995
1 19786U 89009B   24187.56462670  .00000017  00000-0  33073-4 0  9993
2 19786  82.6232 120.0639 0002559 314.8186 218.8955 12.62201559630560
0 COSMOS 1996
1 19787U 89009C   24187.50698219  .00000029  00000-0  10245-3 0  9996
2 19787  82.6136  98.6797 0005454 220.3613 312.9340 12.62896192631593
0 COSMOS 1997
1 19788U 89009D   24187.24441778  .00000028  00000-0  96511-4 0  9994
2 19788  82.6195  93.6575 0009683 155.8522 323.1526 12.63663528632583
0 COSMOS 1998
1 19789U 89009E   24187.60609090  .00000045  00000-0  18456-3 0  9998
2 19789  82.6107  65.7235 0017034 100.7755 259.5256 12.64902818634051
0 COSMOS 1999
1 19790U 89009F   24187.63332497  .00000049  00000-0  20607-3 0  9992
2 19790  82.6176  61.2032 0020517  48.3188  10.6505 12.65718595635234
0 SL-14 R/B
1 19791U 89009G   24187.60931022  .00000034  00000-0  14387-3 0  9991
2 19791  82.6116 217.8697 0035938  92.3491  27.7937 12.54872745621301
0 SL-6 R/B(2)
1 19799U 89011D   24187.22616464 -.00000894  00000-0  00000-0 0  9999
2 19799  64.4068 287.9555 6884370  46.5238 353.0857  2.04174250227018
0 NAVSTAR 13 (USA 35)
1 19802U 89013A   24186.62533316 -.00000047  00000-0  00000-0 0  9993
2 19802  54.6147 118.6766 0041421 234.8116 302.6353  1.85325063245063
0 MOLNIYA 1-75
1 19807U 89014A   24182.37259531  .00000256  00000-0  00000-0 0  9992
2 19807  63.8383 209.0559 6616164 261.6728  24.0902  2.00569954258912
0 SL-6 R/B(2)
1 19810U 89014D   24186.13059996  .00000742  00000-0  00000-0 0  9997
2 19810  64.1074 131.5159 6801042 254.4643  26.1137  2.07388013267802
0 EXOS D (AKEBONO)
1 19822U 89016A   24187.40997317  .00187373  60880-5  10705-2 0  9999
2 19822  74.9256 176.6780 0679590 188.2189 170.7392 14.53933721229061
0 COSMOS 2004
1 19826U 89017A   24187.45080359  .00000084  00000-0  74472-4 0  9997
2 19826  82.9521  87.6504 0031506  68.4660 104.7056 13.72438600770854
0 SL-8 R/B
1 19827U 89017B   24187.58300472  .00000165  00000-0  15903-3 0  9996
2 19827  82.9504  57.8916 0030718 320.9884 101.7556 13.74249624773190
0 SL-8 DEB
1 19831U 89005C   24187.49798837  .00003004  00000-0  66271-3 0  9993
2 19831  74.0675  91.3378 0014081 281.6045 132.0433 14.57749054868637
0 DELTA 1 DEB
1 19834U 72058JM  24187.55928015  .00002025  00000-0  38151-3 0  9994
2 19834  98.5252 297.2470 0133958  94.9331 266.7176 14.60098977836055
0 METEOR 2-18
1 19851U 89018A   24187.61144565  .00000079  00000-0  55680-4 0  9998
2 19851  82.5208  17.7855 0011909 339.4775  88.7736 13.85894832787251
0 SL-14 R/B
1 19852U 89018B   24187.61281927  .00000062  00000-0  42575-4 0  9994
2 19852  82.5207  40.4421 0018319  44.8943 315.3695 13.84118489785605
0 COSMOS 1275 DEB
1 19853U 81053MH  24186.10739726  .00001132  00000-0  12697-2 0  9993
2 19853  82.9894  62.5517 0125523  40.7829 113.7804 13.66801324596987
0 SL-12 R/B(AUX MOTOR)
1 19856U 89001H   24187.47395013 -.00000021  00000-0 -52285-3 0  9991
2 19856  65.1872 271.5551 5573944  59.0771 344.0829  4.25371087550256
0 ARIANE 1 DEB
1 19857U 85056P   24187.07941737 -.00000002  00000-0  17077-2 0  9991
2 19857   7.0930 281.2323 7100076 335.8914 305.0375  2.29213230 81394
0 JCSAT 1
1 19874U 89020A   24186.72409919 -.00000091  00000-0  00000-0 0  9991
2 19874  14.9452 358.5354 0006774 133.4243 236.0809  0.99539089121704
0 METEOSAT 4 (MOP 1)
1 19876U 89020B   24187.05813194 -.00000170  00000-0  00000-0 0  9992
2 19876  15.2532 351.3572 0023137 182.3126 104.1552  0.97110435106012
0 TDRS 4
1 19883U 89021B   24187.15495956 -.00000165  00000-0  00000-0 0  9998
2 19883  12.8802 358.9911 0012446 297.7763 233.8016  0.98483771301033
0 WESTFORD NEEDLES
1 19891U 63014ET  24175.11655552  .00000143  00000-0  60448-1 0  9992
2 19891  87.2733 225.6478 0372084 326.6006  49.9039  8.66923595327213
0 COSMOS 2008
1 19902U 89025A   24187.62036314  .00000003  00000-0  11420-3 0  9996
2 19902  74.0108 278.9291 0050498 271.2416 193.4602 12.57850790620074
0 COSMOS 2009
1 19903U 89025B   24187.62020080 -.00000019  00000-0 -17078-4 0  9995
2 19903  74.0119 341.0298 0041347 351.2769  91.7203 12.55930179617621
0 COSMOS 2010
1 19904U 89025C   24187.62575106  .00000011  00000-0  16765-3 0  9991
2 19904  74.0108  41.6114 0030287  58.1897   8.6002 12.54054863528751
0 COSMOS 2011
1 19905U 89025D   24187.55045617 -.00000009  00000-0  42061-4 0  9990
2 19905  74.0103 101.4201 0020665 133.7560  39.7326 12.52192772612832
0 COSMOS 2012
1 19906U 89025E   24187.43200730 -.00000023  00000-0 -44901-4 0  9999
2 19906  74.0084 164.6757 0010720 213.4756 315.5334 12.50229010610311
0 COSMOS 2013
1 19907U 89025F   24187.57907314  .00000019  00000-0  23324-3 0  9995
2 19907  74.0078 230.2487 0009807 354.7465 122.0067 12.48160600607838
0 COSMOS 2014
1 19908U 89025G   24187.54627050 -.00000006  00000-0  65187-4 0  9990
2 19908  74.0111 290.3975 0012153 127.1883 244.1809 12.46273152605181
0 COSMOS 2015
1 19909U 89025H   24187.55685687 -.00000013  00000-0  16380-4 0  9991
2 19909  74.0115   1.1131 0025611 204.4749 224.4805 12.44050073602289
0 SL-8 R/B
1 19910U 89025J   24187.58213400 -.00000015  00000-0  31595-5 0  9994
2 19910  74.0078 288.3416 0132088 240.5555 129.1301 12.23397194575575
0 IUS R/B(2)
1 19913U 89021D   24186.98588770 -.00000040  00000-0  00000-0 0  9991
2 19913   9.8686 324.3383 0027338 174.7458 200.3383  1.00621065118490
0 TELE-X
1 19919U 89027A   24186.65445437 -.00000090  00000-0  00000-0 0  9994
2 19919  15.0270 357.7036 0009535 144.5581 209.7834  0.99176286110134
0 ARIANE 2 R/B
1 19920U 89027B   24187.05614105  .00005427  00000-0  12555-2 0  9999
2 19920   4.0040 110.4863 5305536 281.5760  25.7826  5.09710195543773
0 COSMOS 2016
1 19921U 89028A   24187.57711278  .00000074  00000-0  61322-4 0  9998
2 19921  82.9626 353.5112 0040190  20.6897  47.8866 13.75226147768067
0 SL-8 R/B
1 19922U 89028B   24187.60939267  .00000062  00000-0  46593-4 0  9993
2 19922  82.9599 316.0778 0035427 229.7581 130.0476 13.77357871771470
0 RADUGA 23
1 19928U 89030A   24187.05396527  .00000115  00000-0  00000-0 0  9995
2 19928  12.6335 336.8637 0022524 182.1199 186.8373  1.00210531127710
0 SL-12 R/B(2)
1 19931U 89030D   24187.05396527 -.00000082  00000-0  00000-0 0  9993
2 19931  13.6761 340.1771 0019743 181.6123 183.2169  0.97922981113088
0 SL-8 DEB
1 19945U 89005D   24187.63116638  .00002368  00000-0  60690-3 0  9999
2 19945  74.0592 270.8221 0019675 139.5335 348.4878 14.50780217684113
0 WESTFORD NEEDLES
1 19946U 63014EU  24185.57156660  .00000258  00000-0  10905+0 0  9998
2 19946  87.1649  35.1429 0352246 264.4705 115.1759  8.68467811126995
0 THORAD AGENA D DEB
1 19948U 70025QD  24186.64105532  .00000219  00000-0  84627-3 0  9994
2 19948  99.6228 122.6350 0413273 169.6923 316.5642 12.74421560548730
0 COSMOS 375 DEB
1 19949U 70091AX  24187.17312719  .00005096  00000-0  97322-3 0  9998
2 19949  62.6017 217.3750 0573856  67.5979 298.4814 13.93851284779865
0 OPS 4682 DEB
1 19950U 65027AY  24186.71479515  .00000022  00000-0  51455-4 0  9992
2 19950  90.2404 353.6482 0027652 256.6723 103.1312 12.94681289460448
0 ARIANE 1 DEB
1 19951U 85056Q   24187.01486623 -.00000181  00000-0 -39248-2 0  9991
2 19951   7.4157 147.0574 7033152 213.7963  37.7979  2.27497810 91452
0 OPS 4682 DEB
1 19954U 65027AZ  24187.11397214  .00001474  00000-0  45723-2 0  9997
2 19954  90.3701  53.6223 0028945 244.4677 270.8159 13.04372690682680
0 COSMOS 375 DEB
1 19960U 70091AY  24187.23496593  .00001678  00000-0  59940-3 0  9997
2 19960  62.9092  11.6446 0885334 149.6654 215.8806 13.14194089699322
0 THOR ABLESTAR DEB *
1 19961U 61015MJ  24187.44341645  .00000359  00000-0  39781-3 0  9990
2 19961  65.6403 189.3560 0165633 325.1700 188.1460 13.77885275842427
0 OPS 4682 DEB
1 19964U 65027BA  24187.47427193  .00000751  00000-0  25959-2 0  9993
2 19964  90.2517   0.3598 0019223 249.0141 138.6824 12.96515434459828
0 IUS R/B(1)
1 19970U 89033C   24187.45589615  .00009525  00000-0  19723-2 0  9999
2 19970  28.0071  38.6733 5949664  41.0149 351.1580  4.11492085475674
0 MIDAS 5 DEB
1 19981U 62010H   24187.10374976  .00000068  00000-0  12377-1 0  9991
2 19981  86.6700  58.4872 0319969  89.7136 274.0423  9.42930082238396
0 TITAN 34D TRANSTAGE R/B
1 19983U 89035C   24187.14575962  .00000016  00000-0  00000-0 0  9993
2 19983   7.9672   4.3720 1036592  44.8585 323.1414  0.99427807 18417
0 DELTA 1 DEB
1 20008U 78026HR  24187.23966297  .00000580  00000-0  44337-3 0  9996
2 20008  98.8949 103.2195 0201921 178.5566 181.6217 13.88068267913168
0 COSMOS 249 DEB
1 20011U 68091DN  24187.05171487  .00003671  00000-0  37526-2 0  9995
2 20011  62.2182  71.3883 0675679 139.5554 225.7749 13.05940979549662
0 DELTA 1 DEB
1 20012U 76077FM  24186.49391747  .00000885  00000-0  35024-2 0  9994
2 20012 102.0462 180.7147 0084247  13.2635 140.4196 12.90478841498926
0 COSMOS 839 DEB
1 20014U 76067BT  24187.10312381  .00000209  00000-0  84906-3 0  9995
2 20014  65.8996 230.8052 0654406  23.2809 357.6545 12.46368285518308
0 SL-14 DEB
1 20016U 78100AQ  24187.29721866  .00073980  00000-0  11868+0 0  9998
2 20016  82.7641 300.4422 0531779 190.1428 168.8615 13.03280162517892
0 COSMOS 2022 (GLONASS)
1 20024U 89039A   24187.61270494 -.00000086  00000-0  00000-0 0  9997
2 20024  65.3275 335.2572 0008324 211.9683 198.9795  2.13102123273175
0 COSMOS 2023 (GLONASS)
1 20025U 89039B   24186.81807809 -.00000087  00000-0  00000-0 0  9996
2 20025  65.3519 335.5634 0018717 197.0443 150.4588  2.13104057273074
0 COSMOS 2024 (ETALON 2)
1 20026U 89039C   24187.25129126 -.00000087  00000-0  00000-0 0  9995
2 20026  65.3302 334.9471 0019501 216.9023 312.5989  2.13204431273325
0 SL-12 R/B(2)
1 20028U 89039E   24183.79489676 -.00000075  00000-0  00000-0 0  9998
2 20028  65.3058 333.7790 0007734 290.2463  56.3340  2.13484942259059
0 DELTA 1 DEB
1 20029U 78026HS  24186.97016214  .00001757  00000-0  54771-3 0  9994
2 20029  98.6115 192.7586 0061269 319.3517  70.1499 14.41083366838618
0 OPS 4682 DEB
1 20031U 65027BB  24187.49275326  .00000056  00000-0  16549-3 0  9995
2 20031  90.2389 344.0542 0034199 128.6473 297.6053 12.97482409674902
0 COSMOS 970 DEB *
1 20032U 77121BW  24187.61232112  .00004112  00000-0  78390-3 0  9993
2 20032  65.6678  14.1371 0428629 305.9453 113.9257 14.19797349553469
0 SUPERBIRD A
1 20040U 89041A   24186.92171694 -.00000184  00000-0  00000-0 0  9992
2 20040  13.0015 337.2748 0007204 128.2861 244.7624  0.99743344127364
0 DFS 1
1 20041U 89041B   24186.45584406 -.00000270  00000-0  00000-0 0  9996
2 20041  14.3306 351.9922 0009265 281.0244  88.0731  1.00667826117327
0 SL-12 DEB
1 20044U 89039F   24186.56017012 -.00000087  00000-0  00000-0 0  9998
2 20044  65.3301 334.9610 0019120 211.3369 197.8128  2.13205425271464
0 COSMOS 2026
1 20045U 89042A   24187.57478718  .00000076  00000-0  61355-4 0  9990
2 20045  82.9391 216.5808 0040667 149.1820 322.8120 13.76160019761414
0 SL-8 R/B
1 20046U 89042B   24187.48728830  .00000207  00000-0  18791-3 0  9995
2 20046  82.9362 183.5085 0043112  47.3534 313.1244 13.78447375763789
0 OPS 4682 DEB
1 20048U 65027BC  24184.65828493  .00001183  00000-0  38511-2 0  9991
2 20048  90.2669 337.4097 0029618 334.9741  38.5856 13.00913269523434
0 DELTA 1 DEB
1 20051U 76077FN  24171.38939608 -.00000023  00000-0  21273-3 0  9990
2 20051 102.4547 130.8876 0152217 212.0698 301.7419 12.14618575529485
0 NAVSTAR 14 (USA 38)
1 20061U 89044A   24186.67276988 -.00000003  00000-0  00000-0 0  9992
2 20061  53.7412 265.6014 0025906 196.2612 153.0122  1.88858611248325
0 USA 39
1 20066U 89046A   24186.71905187 -.00000280  00000-0  00000-0 0  9991
2 20066  13.4382 346.2265 0003644 166.2402 187.6417  0.98822420 18786
0 IUS R/B(2)
1 20069U 89046D   24186.95584142 -.00000286  00000-0  00000-0 0  9990
2 20069  12.7887 343.2422 0041730 358.4915   1.5113  1.01305868 19027
0 SL-12 R/B(AUX MOTOR)
1 20081U 89039G   24187.54104786  .00001235  00000-0  14228-2 0  9997
2 20081  64.8282 268.3686 5641490 146.2499 267.8341  4.44795333553372
0 SL-12 R/B(AUX MOTOR)
1 20082U 89039H   24187.55241353  .00000304  00000-0  74750-3 0  9994
2 20082  64.9899 276.5508 5607067 128.7121 296.3660  4.42294752552277
0 RADUGA 1-1
1 20083U 89048A   24187.54482369 -.00000109  00000-0  00000-0 0  9996
2 20083  13.4686 340.0390 0022385 135.6053 203.7654  0.98709999124245
0 SL-12 R/B(2)
1 20086U 89048D   24186.58616803 -.00000112  00000-0  00000-0 0  9998
2 20086  13.8470 340.8718 0024460 131.6696 231.7540  0.97890589125241
0 COSMOS 1275 DEB
1 20087U 81053MJ  24186.33943153  .00001581  00000-0  15095-2 0  9993
2 20087  82.9905 305.0631 0104004 324.5078  89.5132 13.77657948756236
0 DELTA 1 DEB
1 20088U 76077FP  24186.38283569  .00000021  00000-0  57792-3 0  9996
2 20088 102.4291 155.4242 0084060 184.0112 332.1305 12.26721074569905
0 COSMOS 1275 DEB
1 20089U 81053MK  24186.53324177  .00002982  00000-0  17736-2 0  9996
2 20089  82.7526 231.7229 0045265  43.1860 317.2848 14.06620629633855
0 COSMOS 397 DEB
1 20090U 71015DU  24187.38695696  .00016366  00000-0  33963-2 0  9997
2 20090  65.6817 150.5523 0475532   0.5502  75.3849 14.07570229583510
0 COSMOS 1275 DEB
1 20100U 81053ML  24186.83052279  .00000108  00000-0  14855-3 0  9992
2 20100  82.8921 212.5454 0173267 113.3940  60.4727 13.43169498759471
0 NADEZHDA 1
1 20103U 89050A   24187.52113755  .00000068  00000-0  55299-4 0  9997
2 20103  82.9613 107.1560 0036178 294.4802 239.2273 13.74734564755662
0 SL-8 R/B
1 20104U 89050B   24187.60728235  .00000084  00000-0  68505-4 0  9994
2 20104  82.9556  60.1160 0043725 168.5265 191.6900 13.77481990758917
0 GORIZONT 18
1 20107U 89052A   24186.58608101  .00000038  00000-0  00000-0 0  9995
2 20107  13.1502 339.3224 0033425 331.9806  32.0384  0.99401547127332
0 SL-12 R/B(2)
1 20110U 89052D   24186.31841187 -.00000116  00000-0  00000-0 0  9991
2 20110  11.5524 333.6493 0031211 252.8248 113.3697  1.03059863131644
0 OLYMPUS 1
1 20122U 89053A   24187.43799362 -.00000279  00000-0  00000-0 0  9996
2 20122  12.9962 339.2210 0008366 333.4724  44.9520  1.01370657113657
0 ARIANE 3 DEB
1 20127U 88063E   24187.41216791  .00000045  00000-0  65110-3 0  9995
2 20127   7.3749 182.1451 7139364 187.6879 147.9190  2.34520624302177
0 SL-14 DEB
1 20129U 89080E   24187.50898663  .00003461  00000-0  13757-2 0  9995
2 20129  82.5028 199.6575 0971308 302.5732 220.5014 12.91563162610437
0 OPS 4682 DEB
1 20131U 65027BD  24186.90883436 -.00000092  00000-0 -33278-3 0  9998
2 20131  90.2432 348.6999 0035116  41.9294 113.2798 12.99623762672421
0 COSMOS 2034
1 20149U 89059A   24187.56625287  .00000082  00000-0  70830-4 0  9992
2 20149  82.9408  20.8867 0032642  66.4753 347.5696 13.73589065751413
0 SL-8 R/B
1 20150U 89059B   24187.54976244  .00000039  00000-0  24449-4 0  9991
2 20150  82.9416 343.5211 0027585 291.5787 134.6803 13.75787802754262
0 TVSAT 2
1 20168U 89062A   24187.58660521  .00000084  00000-0  00000-0 0  9999
2 20168  14.7085   1.1650 0009830 152.8984 195.6251  0.99848024127399
0 HIPPARCOS
1 20169U 89062B   24187.59037002  .00000040  00000-0  78594-3 0  9991
2 20169   6.6229 237.0045 7179482 158.8347 261.2028  2.26300965253239
0 ARIANE 44LP R/B
1 20170U 89062C   24186.94825273  .00000764  00000-0  20574-2 0  9993
2 20170   7.3191  78.1037 7066820  88.3425 343.9230  2.47420290297279
0 THOR ABLESTAR DEB
1 20174U 61015MK  24186.55964418  .00000389  00000-0  51358-3 0  9995
2 20174  67.0624  36.5346 0495534 251.9203 102.7283 13.27681931587149
0 NAVSTAR 15 (USA 42)
1 20185U 89064A   24187.17867758 -.00000050  00000-0  00000-0 0  9990
2 20185  54.5125 113.7133 0012364 308.7472 231.5072  1.86087682242954
0 SIRIUS W (MARCOPOLO 1)
1 20193U 89067A   24187.05687852  .00000057  00000-0  00000-0 0  9990
2 20193  14.6833   5.6310 0007039  69.1377 286.9001  0.99183383 39753
0 COSMOS 2037
1 20196U 89068A   24187.45257726 -.00000015  00000-0  19676-4 0  9999
2 20196  73.5639 176.9830 0024047 131.8804 345.2410 12.40524524577455
0 SL-14 R/B
1 20197U 89068B   24187.43205690 -.00000026  00000-0 -61216-4 0  9991
2 20197  73.5633 169.3633 0023563 125.8925 351.4803 12.40767075577765
0 USA 43
1 20202U 89069A   24187.26021557 -.00000262  00000-0  00000-0 0  9999
2 20202  13.6078 341.3349 0016685 242.7568 299.3208  0.98613176 18788
0 USA 44
1 20203U 89069B   24187.05792280  .00000049  00000-0  00000-0 0  9997
2 20203  14.4408   9.2894 0009622  23.4302 334.6693  0.99116653 17928
0 TITAN 34D TRANSTAGE R/B
1 20205U 89069D   24186.29601611 -.00000239  00000-0  00000-0 0  9993
2 20205  12.0030 332.6204 0067630 330.1499  29.4878  1.01244618 19788
0 HIMAWARI 4 (GMS 4)
1 20217U 89070A   24186.43869139 -.00000101  00000-0  00000-0 0  9993
2 20217  15.1448 351.8697 0049767 129.5834 243.0761  0.97411281125601
0 ARIANE 3 DEB
1 20229U 89053C   24186.89227719  .00000294  00000-0  11340-2 0  9992
2 20229   6.7759  19.6386 7178083 210.0626  75.4284  2.31653996282506
0 COSMOS 2038
1 20232U 89074A   24187.57450336  .00000024  00000-0  73661-4 0  9995
2 20232  82.5746 286.3411 0010594 236.6991 134.3707 12.65398880581462
0 COSMOS 2039
1 20233U 89074B   24187.53325808  .00000018  00000-0  40972-4 0  9999
2 20233  82.5809 281.2987 0014951 177.4174 193.8618 12.66250847608531
0 COSMOS 2040
1 20234U 89074C   24187.53994918  .00000013  00000-0  13529-4 0  9997
2 20234  82.5874 341.2808 0005793 131.2161 294.4576 12.62600049603828
0 COSMOS 2041
1 20235U 89074D   24187.59824771  .00000020  00000-0  49975-4 0  9995
2 20235  82.5850 305.4957 0007402 274.3901  96.2665 12.64817575606556
0 COSMOS 2042
1 20236U 89074E   24187.41769266  .00000002  00000-0 -44651-4 0  9991
2 20236  82.5839 313.8719 0004121 316.3018 107.0212 12.64201863721738
0 COSMOS 2043
1 20237U 89074F   24187.60198296  .00000019  00000-0  43751-4 0  9999
2 20237  82.5783 318.3251 0004244  51.3963 320.1768 12.63517235605039
0 SL-14 R/B
1 20238U 89074G   24187.50171633  .00000004  00000-0 -38968-4 0  9994
2 20238  82.5923  95.4810 0039155 204.1279 328.9461 12.55315755594809
0 FLTSATCOM 8 (USA 46)
1 20253U 89077A   24187.54327922 -.00000375  00000-0  00000-0 0  9995
2 20253  12.6278 355.4413 0004960 105.0188 144.5538  1.00283268253489
0 INTERCOSMOS 24
1 20261U 89080A   24187.28989499  .00000509  00000-0  15249-3 0  9994
2 20261  82.6080 142.4231 1193103 272.4287  74.1043 12.58094960589740
0 SL-14 R/B
1 20262U 89080C   24187.50465919  .00000457  00000-0  12968-3 0  9993
2 20262  82.5912 206.1419 1234334 143.4533 225.7599 12.49709584583652
0 GORIZONT 19
1 20263U 89081A   24187.05396527  .00000122  00000-0  00000-0 0  9993
2 20263  12.8592 338.4235 0004274 218.7032 143.0682  1.00246797 40206
0 SL-12 R/B(2)
1 20266U 89081D   24187.05513807  .00000036  00000-0  00000-0 0  9992
2 20266  12.6788 337.8307 0029430 112.1931 262.8625  1.00616129112198
0 MAGION 2
1 20281U 89080B   24187.53247155  .00000692  00000-0  19844-3 0  9998
2 20281  82.6035 117.6738 1180581 174.6013 186.9252 12.61056921592291
0 COSMOS 839 DEB
1 20283U 76067BW  24187.52989824  .00000267  00000-0  10856-2 0  9997
2 20283  65.7124 349.3467 0627384  86.8699 339.8114 12.47204397595696
0 COSMOS 1691 DEB
1 20284U 85094X   24187.35762274  .00000207  00000-0  15178-2 0  9993
2 20284  83.1950 156.8865 0231747 322.1303 194.8960 12.31151458477995
0 COSMOS 1823 DEB
1 20285U 87020DP  24187.16105505  .00000006  00000-0  18889-3 0  9992
2 20285  73.6458 353.1308 0081851 143.4117 336.3381 12.30363223510782
0 COSMOS 1980 DEB
1 20301U 88102J   24187.40991734 -.00000220  00000-0 -90390-4 0  9995
2 20301  70.9984  77.2314 0014685 159.3355 200.8364 14.14298651804695
0 NAVSTAR 16 (USA 47)
1 20302U 89085A   24187.27380558  .00000068  00000-0  00000-0 0  9991
2 20302  54.0268 208.8128 0007979  67.3116   4.1702  1.89426437245053
0 METEOR 3-3
1 20305U 89086A   24187.61843216  .00000971  00000-0  29841-2 0  9997
2 20305  82.5483 239.1877 0008386 104.6673   7.4662 13.04665347653829
0 SL-14 R/B
1 20306U 89086B   24187.45295809 -.00000105  00000-0 -30764-3 0  9997
2 20306  82.5533  81.1385 0015334 244.9185 288.7185 13.16255315666766
0 SL-14 DEB
1 20308U 89080G   24187.47621535  .00007858  00000-0  24886-2 0  9991
2 20308  82.6889 193.1106 0913802 324.9422  29.4671 13.10672425625661
0 INTELSAT 602
1 20315U 89087A   24187.51462400 -.00000127  00000-0  00000-0 0  9998
2 20315  13.9235  12.5748 0006106 167.0162  32.5196  0.99005323124272
0 ARIANE 44L R/B
1 20316U 89087B   24187.50085848  .00066148  00000-0  28437-2 0  9995
2 20316   7.1625 241.9115 6001333 234.8472  53.5179  4.10506122350362
0 HIMAWARI 4 AKM
1 20317U 89070C   24186.58486270 -.00000078  00000-0  00000-0 0  9994
2 20317  13.2743 341.8302 0238663  46.6796 310.1387  0.98763475 39613
0 COBE
1 20322U 89089A   24187.61114354  .00000361  00000-0  25014-3 0  9995
2 20322  98.8824 192.5039 0007501 270.9773 196.2926 14.05177930774715
0 DELTA 1 R/B
1 20323U 89089B   24187.42569215  .00000536  00000-0  14472-3 0  9995
2 20323  97.1164 119.2994 0068706 254.5126 104.8477 14.49569493806994
0 COBE DEB
1 20324U 89089C   24187.54662178  .00001143  00000-0  57092-3 0  9991
2 20324  98.7096 198.2825 0012946  37.9900  82.2138 14.18733030784538
0 THORAD AGENA D DEB
1 20326U 70025QE  24173.45293745  .18477113  38466-5  12812-1 0  9992
2 20326  99.8001 173.8813 0019883 218.0175 141.9701 16.15899797818110
0 COSMOS 970 DEB *
1 20327U 77121BY  24187.32088025  .00022885  00000-0  13733-2 0  9996
2 20327  65.7867 157.2970 0303790  91.6211 271.9722 14.79680619652754
0 COBE DEB
1 20328U 89089D   24187.60386205  .00000545  00000-0  37012-3 0  9991
2 20328  98.9150 193.0052 0001526 309.7421 160.5180 14.04329621773223
0 COSMOS 2050
1 20330U 89091A   24182.79971407  .00000666  00000-0  00000+0 0  9993
2 20330  64.6835 137.9957 6352682 170.2347 213.4471  2.00534952253494
0 SL-6 R/B(2)
1 20333U 89091D   24187.62295797  .00000096  00000-0  00000-0 0  9992
2 20333  69.4553 166.8491 4974708  67.6803  15.9783  2.04206946231180
0 USA 40 R/B
1 20344U 89061D   24187.42293687  .00000126  00000-0  12274-3 0  9998
2 20344  57.0334 352.4743 3560433 302.9221  27.7318  7.87788105156593
0 SL-3 DEB
1 20348U 72049C   24187.57875584  .00000198  00000-0  12060-3 0  9990
2 20348  81.2385  24.5655 0047829 216.8934 142.8939 14.01994774658298
0 DELTA 1 DEB
1 20349U 76077FR  24185.06872434  .00000103  00000-0  24038-2 0  9992
2 20349 102.5409  35.0595 0625036 159.5205 354.1178 11.33490641474856
0 USA 48
1 20355U 89090B   24187.30830660 -.00000362  00000-0  00000-0 0  9991
2 20355  17.4046 347.6451 0293553  97.6210 263.4186  1.00734004   583
0 IUS R/B(1)
1 20356U 89090C   24187.57932393  .00007273  00000-0  16073-2 0  9993
2 20356  27.6728  20.1581 6456006 158.0909 251.6024  3.37925263 61676
0 IUS R/B(2)
1 20357U 89090D   24185.95202414 -.00000212  00000-0  00000-0 0  9996
2 20357  17.7263 349.3364 0335362  83.9859 279.8396  0.99516136 18262
0 THORAD AGENA D DEB
1 20360U 70025QF  24187.01401122  .00007958  00000-0  54639-2 0  9996
2 20360 100.4168  22.1564 0025426 331.1488 182.7753 13.99611500732167
0 NAVSTAR 17 (USA 49)
1 20361U 89097A   24187.23707579 -.00000086  00000-0  00000+0 0  9991
2 20361  56.0172  35.6541 0022205 309.8273 227.9125  1.89175192235878
0 RADUGA 24
1 20367U 89098A   24187.63347934 -.00000290  00000-0  00000-0 0  9995
2 20367  13.2731 338.9358 0002541 193.3001  75.8423  1.00225357125838
0 SL-12 R/B(2)
1 20370U 89098D   24187.11855253 -.00000137  00000-0  00000-0 0  9990
2 20370  14.3091 342.3522 0021081 170.1530 196.8556  0.97854350110960
0 COSMOS 2054
1 20391U 89101A   24187.18424704 -.00000195  00000-0  00000-0 0  9992
2 20391  12.9983 339.2313 0005485 153.4720 195.4714  1.00259107126721
0 SL-12 R/B(2)
1 20394U 89101D   24186.98597472 -.00000022  00000-0  00000-0 0  9994
2 20394  13.9158 342.3440 0011712 200.7874 156.4882  0.98246394112178
0 SKYNET 4A
1 20401U 90001A   24187.05731363  .00000047  00000-0  00000-0 0  9998
2 20401  12.7598 353.6712 0009771 292.9240  77.8279  0.98995923 39725
0 JCSAT 2
1 20402U 90001B   24187.05813194 -.00000239  00000-0  00000-0 0  9996
2 20402  15.4212  16.8635 0055024 308.4278 314.9983  0.98540139108311
0 SKYNET 4A R/B(PAM-D2)
1 20404U 90001D   24186.76682017  .00001185  00000-0  10620-2 0  9994
2 20404  21.7654  54.0726 7047454 196.1576 117.6621  2.54387812293409
0 LEASAT 5
1 20410U 90002B   24187.40858400 -.00000283  00000-0  00000-0 0  9993
2 20410  11.2563 355.8429 0005947  86.0710 143.6873  0.99601144111335
0 LEASAT 5 PKM (SSUS-A)
1 20411U 90002C   24187.31073066  .00042889  00000-0  17996-2 0  9992
2 20411  27.2646 170.3561 4441502 311.7000  17.9686  6.67655342686373
0 SL-12 R/B(2)
1 20413U 83020D   24191.21734934 -.00000715  00000-0  00000-0 0  9997
2 20413  77.8384  65.7421 5334347  27.5899   1.0197  0.24732417  9606
0 COSMOS 2056
1 20432U 90004A   24187.60848076  .00000220  00000-0  88399-4 0  9990
2 20432  74.0325  28.9517 0023298 258.1816 101.6723 14.33807109801725
0 SL-8 R/B
1 20433U 90004B   24187.58534137  .00000483  00000-0  17075-3 0  9991
2 20433  74.0374 306.6645 0040200 168.9618 202.2539 14.36817131804655
0 SL-8 DEB
1 20434U 90004C   24187.50492076  .00001692  00000-0  47865-3 0  9992
2 20434  74.0425 247.4958 0016403 329.4140  97.1446 14.46301528807115
0 SL-8 DEB
1 20435U 90004D   24187.51180521  .00002526  00000-0  54364-3 0  9992
2 20435  74.0251 232.7320 0013285  40.3047  86.9437 14.58982243818371
0 SPOT 2
1 20436U 90005A   24187.50799205  .00003410  00000-0  50087-3 0  9999
2 20436  98.6434 286.1707 0137792 162.5120 198.0898 14.69940146810598
0 OSCAR 14 (UOSAT 3)
1 20437U 90005B   24187.63148361  .00000238  00000-0  10422-3 0  9999
2 20437  98.8899 210.3614 0010400 183.4588 304.9548 14.32822429799676
0 OSCAR 15 (UOSAT 4)
1 20438U 90005C   24187.62794958  .00000140  00000-0  70436-4 0  9992
2 20438  98.8837 220.7220 0008728 272.8999 199.6340 14.31407842798413
0 OSCAR 16 (PACSAT)
1 20439U 90005D   24187.56326079  .00000286  00000-0  12046-3 0  9994
2 20439  98.8992 193.2024 0011212 152.7714 323.9527 14.33404509799964
0 OSCAR 17 (DOVE)
1 20440U 90005E   24187.57751022  .00000314  00000-0  12948-3 0  9990
2 20440  98.8895 187.2722 0011649 129.2868 355.8753 14.33886764800335
0 OSCAR 18 (WEBERSAT)
1 20441U 90005F   24187.57463639  .00000262  00000-0  11158-3 0  9999
2 20441  98.8941 185.1771 0012004 142.3479 331.9451 14.33451540800081
0 OSCAR 19 (LUSAT)
1 20442U 90005G   24187.51028115  .00000267  00000-0  11321-3 0  9997
2 20442  98.8827 178.2596 0012541 128.6228 231.6080 14.33565108800404
0 ARIANE 40 R/B
1 20443U 90005H   24187.45263521  .00000478  00000-0  16893-3 0  9996
2 20443  98.3929 252.6022 0009251 240.5723 119.4542 14.38990009804724
0 NAVSTAR 18 (USA 50)
1 20452U 90008A   24186.21922725  .00000024  00000-0  00000-0 0  9997
2 20452  54.7484 158.5644 0015632 272.2927  90.9048  1.89597872242912
0 DELTA 2 R/B(1)
1 20453U 90008B   24187.42015301  .00013586  00000-0  50106-3 0  9997
2 20453  35.6188  81.1708 0198651 185.5074 174.3455 15.10460766832280
0 COSMOS 2058
1 20465U 90010A   24187.54155898  .00004629  00000-0  33458-3 0  9991
2 20465  82.4875 286.5053 0012485 239.9058 120.0930 15.03787699849986
0 SL-14 R/B
1 20466U 90010B   24187.56269352  .00000696  00000-0  83524-4 0  9995
2 20466  82.5034 121.8776 0020853 152.2098 208.0235 14.82483962837756
0 CRRES DEB (CANISTER)
1 20469U 90065T   24187.27629283  .00001518  00000-0  11110-2 0  9993
2 20469  17.5490 209.7498 6944424 103.2774 336.7356  2.68046595265613
0 STTW-4
1 20473U 90011A   24187.58150907 -.00000302  00000-0  00000-0 0  9990
2 20473  14.5024 351.8020 0006938 137.1765 100.7599  1.00253294125903
0 CZ-3 R/B
1 20474U 90011B   24187.21167327  .00009821  00000-0  25977-2 0  9991
2 20474  30.3652  79.6172 6606593  33.4812 354.6044  3.16412782129952
0 MOS 1B (MOMO 1B)
1 20478U 90013A   24187.55005757  .00000296  00000-0  25048-3 0  9999
2 20478  99.3219 233.1568 0004863 332.2656  27.8245 13.95800197672749
0 DEBUT (ORIZURU)
1 20479U 90013B   24187.57243637  .00000023  00000-0  13252-3 0  9995
2 20479  99.0440 238.2979 0538062 303.3356  51.7325 12.83953489612247
0 JAS 1B (FUJI 2)
1 20480U 90013C   24187.39093168  .00000009  00000-0  99716-4 0  9993
2 20480  99.0394 233.4208 0539610 317.7654  38.3045 12.83459456612020
0 ARIANE 3 DEB
1 20488U 88063F   24187.18404768 -.00000008  00000-0  00000+0 0  9995
2 20488   7.1798 141.2267 4851976 128.3670 286.0653  4.96557407620191
0 H-1 R/B
1 20491U 90013D   24187.61011916 -.00000816  00000-0 -14636-2 0  9995
2 20491  99.0338 231.0381 0468260  28.2043 334.3599 13.03668039636306
0 RADUGA 25
1 20499U 90016A   24187.44801513 -.00000004  00000-0  00000-0 0  9993
2 20499  13.0686 339.7129 0006435 170.9198 168.9106  1.00373468125761
0 SL-12 R/B(2)
1 20502U 90016D   24187.26021557 -.00000279  00000-0  00000-0 0  9994
2 20502  13.1933 340.1939 0040798 221.8354 323.7605  1.00039524125641
0 COSMOS 839 DEB *
1 20503U 76067BX  24187.33314734  .00000744  00000-0  34650-3 0  9992
2 20503  65.7346 210.8922 0916622 265.9456  83.6444 13.00191479575001
0 COSMOS 1275 DEB
1 20505U 81053MM  24184.23835438  .00007366  00000-0  22826-2 0  9998
2 20505  83.1524 113.9087 0020730  94.4161 265.9401 14.40948384865789
0 NADEZHDA 2
1 20508U 90017A   24187.57099292  .00000098  00000-0  87265-4 0  9996
2 20508  82.9548 239.7182 0042659 263.5004 207.2405 13.74434740722627
0 SL-8 R/B
1 20509U 90017B   24187.59574831  .00000144  00000-0  13264-3 0  9995
2 20509  82.9520 218.1254 0043414 167.1025 193.1253 13.75744475724087
0 OKEAN 2
1 20510U 90018A   24187.55442103  .00004148  00000-0  27773-3 0  9998
2 20510  82.5093 212.3533 0008105 259.0921 216.4798 15.06653070846512
0 SL-14 R/B
1 20511U 90018B   24187.40238625  .00000589  00000-0  72781-4 0  9990
2 20511  82.5216  75.0160 0015375 309.5123  50.4730 14.81094416831917
0 INTELSAT 603
1 20523U 90021A   24187.54613844 -.00000350  00000-0  00000-0 0  9990
2 20523  13.5593  14.3476 0007369  73.8666 166.4138  0.99483511118320
0 COSMOS 2061
1 20527U 90023A   24187.48921742  .00000052  00000-0  39905-4 0  9996
2 20527  82.9380 334.6525 0032429  81.6530 339.3404 13.72282260717193
0 SL-8 R/B
1 20528U 90023B   24187.60416279  .00000047  00000-0  34023-4 0  9995
2 20528  82.9373 320.5207 0033145  68.9994 302.0910 13.73018370718140
0 NAVSTAR 19 (USA 54)
1 20533U 90025A   24187.39007782 -.00000017  00000-0  00000-0 0  9996
2 20533  53.9503 272.0097 0044595 214.3193 150.7025  1.91039331241420
0 COSMOS 2063
1 20536U 90026A   24186.25023900 -.00000114  00000-0  00000-0 0  9992
2 20536  66.7649 211.0793 5871043 142.4468 278.5004  1.99624837249826
0 USA 55
1 20547U 90028B   24187.50986526  .00006594  00000-0  19163-3 0  9997
2 20547  94.1096 104.9059 0068121 336.0012  23.8066 15.33218894892424
0 COSMOS 2064
1 20549U 90029A   24187.60882422  .00000019  00000-0  23853-3 0  9998
2 20549  73.9796 227.4805 0017202 352.8990 125.4228 12.47208243559386
0 COSMOS 2065
1 20550U 90029B   24187.40899053 -.00000018  00000-0 -13951-4 0  9996
2 20550  73.9796 166.0710 0008722 321.2500 155.8621 12.49188621561820
0 COSMOS 2066
1 20551U 90029C   24187.52130752  .00000000  00000-0  93995-4 0  9999
2 20551  73.9788 197.3142 0048656  90.4703  27.8562 12.59693530574937
0 COSMOS 2067
1 20552U 90029D   24187.58074167  .00000018  00000-0  20209-3 0  9999
2 20552  73.9808 253.2184 0039663 162.3875 311.0052 12.57918096572717
0 COSMOS 2068
1 20553U 90029E   24187.60273646 -.00000022  00000-0 -34335-4 0  9999
2 20553  73.9836 305.5783 0031261 215.0045 157.1149 12.56254790570612
0 COSMOS 2069
1 20554U 90029F   24187.55140093 -.00000013  00000-0  21641-4 0  9998
2 20554  73.9830 359.7835 0022237 273.4399 143.7366 12.54523038568441
0 COSMOS 2070
1 20555U 90029G   24187.40391236  .00000012  00000-0  17860-3 0  9995
2 20555  73.9823  54.4086 0013699 318.2709 214.8172 12.52786860566261
0 COSMOS 2071
1 20556U 90029H   24187.52038648 -.00000022  00000-0 -35944-4 0  9991
2 20556  73.9817 112.0678 0002348  41.9985 131.8236 12.50924711563935
0 SL-8 R/B
1 20557U 90029J   24187.56060056 -.00000044  00000-0 -27173-3 0  9992
2 20557  73.9837 242.7279 0151475  95.1483  16.9426 12.23256852528957
0 ASIASAT 1
1 20558U 90030A   24186.75638457 -.00000251  00000-0  00000-0 0  9997
2 20558  14.8258   4.3622 0001615 108.3853  68.6500  0.99246439 39146
0 CZ-3 R/B
1 20559U 90030B   24187.01541814  .00032822  00000-0  86496-3 0  9992
2 20559  30.8101 109.2638 4705852 222.7788  89.1110  6.24205152199941
0 USA 56
1 20560U 90031A   24187.33140904  .00001192  00000-0  16960-3 0  9990
2 20560  89.8492 274.2203 0061331 283.7154  75.7244 14.75051139  7652
0 USA 57
1 20561U 90031B   24187.50064719  .00001081  00000-0  16529-3 0  9997
2 20561  89.8444 278.5897 0070794  56.7605 304.0372 14.71399803 10459
0 USA 58
1 20562U 90031C   24187.34028416  .00001024  00000-0  14844-3 0  9999
2 20562  89.8497 276.5551 0063522 316.2241  43.3952 14.74074775  8684
0 ATLAS 28E R/B
1 20563U 90031D   24187.50260354  .00001872  00000-0  25435-3 0  9996
2 20563  89.8545 268.9622 0060450 200.4349 159.4454 14.77210424265354
0 ATLAS 28E DEB
1 20564U 90031E   24187.22805903  .00002069  00000-0  24186-3 0  9992
2 20564  89.8447 277.9993 0054928 316.5151  43.1749 14.83708524266313
0 ATLAS 28E DEB
1 20565U 90031F   24187.57682427  .00002132  00000-0  24539-3 0  9998
2 20565  89.8823 254.1910 0053005 283.8089  75.7242 14.84445985277848
0 NEWSAT-1 (PALAPA B2R)
1 20570U 90034A   24187.54772148 -.00000353  00000-0  00000-0 0  9992
2 20570  14.5117   8.2251 0012981 126.4739 125.0232  0.99532339 39208
0 DELTA 2 R/B
1 20571U 90034B   24187.48165349  .00004814  00000-0  65081-3 0  9993
2 20571  22.7476 252.3993 0487075 228.2089 127.5756 14.17377564757210
0 ATLAS 28E DEB
1 20575U 90031G   24187.24311990  .00005157  00000-0  49691-3 0  9993
2 20575  90.3575 266.0965 0031704 125.5810 234.8382 14.92454360288524
0 ATLAS 28E DEB
1 20576U 90031H   24187.34218825  .00009165  00000-0  57554-3 0  9998
2 20576  89.4422 323.4436 0046199  27.3376 333.0279 15.08275483279135
0 COSMOS 2074
1 20577U 90036A   24187.62079376  .00000079  00000-0  67407-4 0  9995
2 20577  82.9431 273.1182 0027632  34.7861  78.3193 13.74774040715958
0 SL-8 R/B
1 20578U 90036B   24187.60241513  .00000125  00000-0  11254-3 0  9998
2 20578  82.9425 247.7987 0012214 341.3842 127.5232 13.76507537717970
0 HST
1 20580U 90037B   24187.46455794  .00005228  00000-0  24091-3 0  9996
2 20580  28.4669 222.6531 0002396 227.1186 132.9206 15.17982776679817
0 COSMOS 2076
1 20596U 90040A   24187.47435830 -.00000516  00000-0  00000-0 0  9994
2 20596  68.5924 229.5169 5142837 123.0723 302.4622  2.00396378250486
0 SL-6 R/B(2)
1 20599U 90040D   24185.55474328  .00000627  00000-0  00000-0 0  9991
2 20599  69.7002 164.0515 5231666  59.2618 341.9375  2.03482811254049
0 MACSAT 1 (M 1)
1 20607U 90043A   24187.23215552  .00000848  00000-0  11992-3 0  9993
2 20607  89.7263 267.6756 0092510   6.5369 353.7033 14.73326571830337
0 MACSAT 2 (M 2)
1 20608U 90043B   24187.49198062  .00001751  00000-0  22682-3 0  9990
2 20608  89.7287 268.6091 0084739 194.3354 165.5464 14.77899862833164
0 COSMOS 2079 (GLONASS)
1 20619U 90045A   24187.15304507 -.00000087  00000-0  00000+0 0  9998
2 20619  65.1225 332.9785 0045962 205.8749 337.9493  2.13102996265621
0 COSMOS 2080 (GLONASS)
1 20620U 90045B   24187.59575983 -.00000086  00000-0  00000-0 0  9996
2 20620  65.1175 332.9120 0024214  35.5482  36.9523  2.13102918265443
0 COSMOS 2081 (GLONASS)
1 20621U 90045C   24187.51501653 -.00000086  00000-0  00000-0 0  9992
2 20621  65.1407 333.1933 0042338 216.8828 146.4996  2.13104737265523
0 SL-12 R/B(2)
1 20623U 90045E   24184.83807955 -.00000082  00000-0  00000-0 0  9996
2 20623  65.1044 331.7800 0013948 344.9277  17.7615  2.13418738266095
0 COSMOS 2082
1 20624U 90046A   24187.50166003  .00000324  00000-0  19286-3 0  9994
2 20624  71.0382 223.1371 0013148  54.5664 305.6684 14.14594748761040
0 SL-16 R/B
1 20625U 90046B   24187.33579318  .00000221  00000-0  13895-3 0  9999
2 20625  70.9992 143.8132 0013478 163.7581 196.3976 14.14846535761779
0 SL-16 DEB
1 20626U 90046C   24187.36250905  .00000157  00000-0  18595-3 0  9991
2 20626  71.0148 159.3616 0204664  74.7717  38.5966 13.72644281708409
0 SL-16 DEB
1 20627U 90046D   24187.40679793  .00000114  00000-0  15034-3 0  9995
2 20627  70.9724 180.5842 0213925 213.5989 266.4155 13.70681276706110
0 SL-16 DEB
1 20628U 90046E   24187.55126281  .00000102  00000-0  13582-3 0  9994
2 20628  70.9761 129.0863 0206697 142.5474 219.0238 13.72150418707849
0 SL-16 DEB
1 20629U 90046F   24187.24316963  .00000296  00000-0  31378-3 0  9996
2 20629  71.0231 117.5090 0198814 357.7880 154.3663 13.73868356709988
0 SL-12 R/B(AUX MOTOR)
1 20630U 90045F   24187.17052095  .00000052  00000-0  24858-3 0  9997
2 20630  65.4377 136.5711 5538983  83.2965 333.6916  4.31997773535254
0 SL-12 R/B(AUX MOTOR)
1 20631U 90045G   24186.83593635  .00002067  00000-0  24228-2 0  9998
2 20631  64.7625 335.6583 5606669 165.3747 222.0698  4.50484034544877
0 USA 59
1 20641U 90050A   24186.24616639 -.00000005  00000-0  00000-0 0  9991
2 20641  63.3855 126.2570 4054086 265.6568  48.3357  6.02577847  3372
0 INSAT 1D
1 20643U 90051A   24186.98989074 -.00000174  00000-0  00000-0 0  9998
2 20643  14.6888 359.3933 0018972 166.7436 194.4659  1.00265381111611
0 GORIZONT 20
1 20659U 90054A   24186.91647348 -.00000254  00000-0  00000-0 0  9995
2 20659  13.3806 341.1625 0007339 195.6338 165.7656  1.00310464124556
0 SL-12 R/B(2)
1 20662U 90054D   24186.90374401 -.00000311  00000-0  00000-0 0  9999
2 20662  13.2379 340.6206 0016000  96.7324 263.4673  1.00518779124637
0 COSMOS 2084
1 20663U 90055A   24187.57978163  .00003676  00000-0  28219-3 0  9991
2 20663  62.7908 254.4800 0109896 121.8616 239.3234 14.98971647844325
0 SL-6 R/B(2)
1 20666U 90055D   24187.36761728  .00002489  00000-0  20993-3 0  9990
2 20666  62.7826 169.1126 0083466 144.9767 215.6860 14.98323121846251
0 INTELSAT 604
1 20667U 90056A   24186.99493713 -.00000208  00000-0  00000-0 0  9998
2 20667  14.1330  15.0615 0001882 316.1540 271.8911  0.98435146 39463
0 TITAN 3 R/B(2)
1 20669U 90056C   24187.17279045  .00001624  00000-0  11317-2 0  9998
2 20669  24.2194  74.5915 7038049 107.1859 335.4327  2.55913103292133
0 METEOR 2-19
1 20670U 90057A   24187.58802898  .00000084  00000-0  61072-4 0  9998
2 20670  82.5466 124.8019 0014702 283.3084  76.6437 13.84799232719148
0 SL-14 R/B
1 20671U 90057B   24187.56629468  .00000034  00000-0  17339-4 0  9999
2 20671  82.5477 124.9307 0013940 284.3739  75.5874 13.84685513719186
0 TITAN 3C TRANSTAGE DEB
1 20672U 65108AD  24184.63801394 -.00000072  00000-0  21395-3 0  9993
2 20672  26.7334 150.4887 6789537 171.4866 358.9358  2.69933135 28210
0 COSMOS 886 DEB
1 20673U 76126CG  24187.10104203  .00007976  00000-0  12480-2 0  9999
2 20673  65.5758  76.8889 0374281 221.0025 136.2375 14.35705816623827
0 ARIANE 3 DEB
1 20674U 84081E   24187.36420185 -.00000159  00000-0 -19178-2 0  9996
2 20674   7.1841 311.7841 6968847  43.2239 356.8485  2.40757981280358
0 USA 60
1 20682U 90050B   24187.57193153  .00006804  00000-0  54976-3 0  9990
2 20682  63.3005 319.0777 0912933  69.2196 300.4151 13.52736269  7073
0 USA 61
1 20691U 90050C   24187.62453258  .00006805  00000-0  57302-3 0  9998
2 20691  63.3014 318.3306 0910828  71.6456 298.1381 13.52100946  9639
0 USA 62
1 20692U 90050D   24187.59313215  .00006652  00000-0  55843-3 0  9991
2 20692  63.3021 318.2619 0910158  71.2200 298.5281 13.52335041  7999
0 COSMOS 2085
1 20693U 90061A   24186.98771517 -.00000069  00000-0  00000-0 0  9998
2 20693  13.3567 341.5533 0008716  48.8811 318.6906  1.00271325124363
0 SL-12 R/B(2)
1 20696U 90061D   24186.98701899 -.00000016  00000-0  00000-0 0  9999
2 20696  13.3232 341.4374 0034330 194.7637 168.9000  1.00177039123261
0 TDF 2
1 20705U 90063A   24187.09055626 -.00000021  00000-0  00000-0 0  9991
2 20705  15.1265   3.6741 0038931 310.6252 229.6772  0.98607127125542
0 DFS 2
1 20706U 90063B   24185.88895726 -.00000267  00000-0  00000-0 0  9992
2 20706  14.3113   8.8948 0004130 227.9527 307.4575  0.99548621115821
0 COSMOS 2087
1 20707U 90064A   24183.82967014  .00000525  00000-0  00000-0 0  9992
2 20707  67.7112 231.1359 5815483  43.0469 350.1416  2.00538812248470
0 SL-6 R/B(2)
1 20710U 90064D   24186.47108166 -.00000062  00000-0  00000-0 0  9992
2 20710  69.2232 146.4602 6155411  33.0371 353.3226  2.04549544253493
0 CRRES
1 20712U 90065A   24186.54432011  .00000721  00000-0  73526-3 0  9999
2 20712  17.6562 250.4815 7091215  73.5887 348.5085  2.48305358292014
0 ATLAS 1 CENTAUR R/B
1 20713U 90065B   24187.07198138  .00000959  00000-0  87462-3 0  9995
2 20713  17.5529 135.8213 6875507 251.4122  27.1208  2.74469910323057
0 ARIANE 44L R/B
1 20717U 90063C   24187.08100664  .00000391  00000-0  12864-2 0  9998
2 20717   4.0563  56.8310 7149266 163.4498 244.3362  2.35577047279686
0 ARIANE 44L DEB (SPELDA)
1 20718U 90063D   24187.12013744  .00005432  00000-0  38527-2 0  9991
2 20718   5.2948   1.6553 6120471 254.8704  33.5085  3.79238313394671
0 COSMOS 2088
1 20720U 90066A   24187.57446735  .00000017  00000-0  25599-3 0  9996
2 20720  73.5987 264.6834 0025573 199.4277 269.2555 12.40765800536883
0 SL-14 R/B
1 20721U 90066B   24187.59442285  .00000008  00000-0  18955-3 0  9993
2 20721  73.5987 253.4705 0023929 189.9693 280.2233 12.41076743537515
0 NAVSTAR 20 (USA 63)
1 20724U 90068A   24187.04286788 -.00000062  00000-0  00000-0 0  9992
2 20724  54.3619  99.3945 0038201 318.4173 225.8771  1.87185929236570
0 COSMOS 2090
1 20735U 90070A   24187.57671983  .00000036  00000-0  13446-3 0  9991
2 20735  82.5670   9.5488 0013387 243.6786 180.5856 12.65333609565938
0 COSMOS 2091
1 20736U 90070B   24187.44453797  .00000045  00000-0  19250-3 0  9998
2 20736  82.5771  62.5542 0002585 294.8118 238.8080 12.62530992562491
0 COSMOS 2092
1 20737U 90070C   24187.60467788  .00000046  00000-0  19302-3 0  9991
2 20737  82.5682  41.3207 0003761 319.5588 102.5018 12.63318901563505
0 COSMOS 2093
1 20738U 90070D   24187.61622480  .00000044  00000-0  18342-3 0  9996
2 20738  82.5744  36.6467 0007894 288.6595 140.3616 12.64065422564474
0 COSMOS 2094
1 20739U 90070E   24187.61642583  .00000039  00000-0  15183-3 0  9997
2 20739  82.5755  28.0367 0010520 269.4272 158.1462 12.64725796565272
0 COSMOS 2095
1 20740U 90070F   24187.54107627  .00000030  00000-0  10496-3 0  9999
2 20740  82.5740   5.1381 0019061 197.2096 231.4875 12.66111410566976
0 SL-14 R/B
1 20741U 90070G   24187.42389832  .00000004  00000-0 -38902-4 0  9992
2 20741  82.5767 159.0071 0035113 208.8048 320.2206 12.55709226554195
0 TITAN 3C TRANSTAGE DEB
1 20760U 65108AE  24186.67615296  .00000656  00000-0  63957-2 0  9997
2 20760  27.1963 281.7778 6695561 133.6634 272.4626  2.83600030131083
0 THOR 1 (MARCOPOLO 2)
1 20762U 90074A   24187.37336328  .00000003  00000-0  00000-0 0  9997
2 20762  14.2020  11.8398 0003719 160.0775  95.8938  0.99208745 39147
0 DELTA 2 R/B
1 20763U 90074B   24187.48161077  .00008071  00000-0  72224-3 0  9990
2 20763  24.7603 125.1347 0361618 343.7167  15.1986 14.54715616773862
0 MARCOPOLO 2 R/B(PAM-D)
1 20764U 90074C   24187.08947374  .00000073  00000-0  19313-2 0  9992
2 20764  20.7921 136.2244 7260007  16.4623 357.9401  2.18221936268221
0 BS-3A (YURI 3A)
1 20771U 90077A   24187.63412532 -.00000100  00000-0  00000-0 0  9990
2 20771  15.5700   2.9520 0009914 237.6430  12.8479  0.98810756128548
0 COSMOS 2098
1 20774U 90078A   24187.56403953  .00007118  00000-0  51955-3 0  9996
2 20774  82.9421 264.8923 0778722 108.7018 260.0246 13.82118919673896
0 SL-8 R/B
1 20775U 90078B   24187.17245663  .00009846  00000-0  39182-3 0  9994
2 20775  82.9156  70.8579 0465334 234.7188 120.9657 14.61321482718950
0 SKYNET 4C
1 20776U 90079A   24187.11299519  .00000117  00000-0  00000-0 0  9995
2 20776  13.5684 354.6738 0001939 127.7415 235.2971  1.00278617123755
0 EUTE 2-F1
1 20777U 90079B   24186.28991184 -.00000287  00000-0  00000-0 0  9999
2 20777  14.8333   3.3035 0004094 184.3449 358.6930  0.99350711103688
0 FENGYUN 1B
1 20788U 90081A   24187.53325895  .00000293  00000-0  21621-3 0  9994
2 20788  98.8869 169.9223 0016458 151.4195 208.7877 14.02965174731758
0 CZ-4 R/B
1 20791U 90081D   24187.59633941  .00000168  00000-0  16073-3 0  9994
2 20791  98.9283 161.4441 0052278 211.1583 265.2926 13.92851290719522
0 CZ-4 DEB
1 20792U 90081E   24187.49760846  .00001026  00000-0  52269-3 0  9990
2 20792  98.7007 175.4879 0013511 282.4731  77.4933 14.17909785742481
0 CZ-4 DEB
1 20793U 90081F   24187.56564240  .00001471  00000-0  73331-3 0  9996
2 20793  98.7069 173.1169 0019229 222.0136 251.1169 14.18366909742497
0 CZ-4 DEB
1 20797U 90081G   24187.54986005  .00001262  00000-0  66076-3 0  9991
2 20797  98.7350 171.7723 0009308  20.3432  96.4650 14.16051339740881
0 CZ-4 DEB
1 20798U 90081H   24187.53462743  .00001308  00000-0  64017-3 0  9993
2 20798  98.7024 172.3545 0008392 191.5068 168.5918 14.19606253743613
0 GOES 2 AKM
1 20799U 77048G   24187.17789437 -.00000331  00000-0  00000-0 0  9999
2 20799   5.9154 284.5852 0206507  85.8705 286.2761  1.00570287110677
0 METEOSAT 4 AKM
1 20800U 89020E   24187.11928030 -.00000010  00000-0  00000-0 0  9997
2 20800  11.8442 335.7663 0127890 235.7909 125.8003  1.00438357109052
0 GOES 3 AKM
1 20801U 78062D   24187.51440883 -.00000297  00000-0  00000-0 0  9998
2 20801   8.2273 292.7517 0103950  72.1150 209.3903  0.99474038 39880
0 COSMOS 2100
1 20804U 90083A   24187.54377794  .00000058  00000-0  45046-4 0  9998
2 20804  82.9405 334.8054 0038218 101.5363 328.7362 13.74458403695473
0 SL-8 R/B
1 20805U 90083B   24187.61449885  .00000104  00000-0  90690-4 0  9995
2 20805  82.9376 308.5155 0031483  41.1194 329.5132 13.76110103697299
0 CRRES DEB (CANISTER)
1 20811U 90065C   24187.26641548  .00001935  00000-0  10917-2 0  9998
2 20811  17.5554 223.1169 6953989  78.9167 346.3100  2.67576531102284
0 METEOR 2-20
1 20826U 90086A   24187.55423912  .00000057  00000-0  38013-4 0  9995
2 20826  82.5241  44.7827 0012482 217.9966 142.0314 13.84361003705850
0 SL-14 R/B
1 20827U 90086B   24187.57485033  .00000070  00000-0  46472-4 0  9993
2 20827  82.5281  49.5900 0103688 171.4509 188.8450 13.84584797705829
0 NAVSTAR 21 (USA 64)
1 20830U 90088A   24185.49506682 -.00000087  00000-0  00000-0 0  9994
2 20830  56.1105  34.1002 0021252 279.0376 264.7311  1.87752483239406
0 SMS 2 AKM
1 20835U 75011F   24187.45180645  .00000039  00000-0  00000-0 0  9999
2 20835   5.6282 282.8026 0096623 124.5063 281.0605  0.98586261 39568
0 SL-12 R/B(2)
1 20836U 74060F   24187.13181156 -.00000063  00000-0  00000-0 0  9994
2 20836   3.1777 269.6475 0018435 200.0905 296.3350  1.00174801 38867
0 METEOSAT 2 AKM (MAGE 1)
1 20837U 81057F   24186.84656174  .00000026  00000-0  00000+0 0  9990
2 20837   9.2002 304.4956 0079607 190.0654 173.2859  0.99360727112316
0 IUS R/B(1)
1 20843U 90090C   24186.77530628  .00000638  00000-0  41599-3 0  9992
2 20843  28.2848  61.6086 6706425 295.4178  11.3265  2.99465497343962
0 CZ-4 DEB
1 20846U 90081J   24187.62848267  .00000828  00000-0  88554-3 0  9994
2 20846  98.9777 223.9723 0197920 254.6063 229.6080 13.68511885684383
0 CZ-4 DEB
1 20848U 90081L   24187.42433625  .00001228  00000-0  10817-2 0  9993
2 20848  98.9830 333.0643 0208212 242.1350 185.0452 13.77808271688758
0 CZ-4 DEB
1 20849U 90081M   24187.60736693  .00001891  00000-0  97732-3 0  9993
2 20849  98.6111 175.4586 0040942 346.6330  13.3757 14.15719060735141
0 CZ-4 DEB
1 20850U 90081N   24187.14721903  .00000849  00000-0  33051-3 0  9998
2 20850  98.5471 240.9756 0074447 165.8147 218.3189 14.30782657761089
0 CZ-4 DEB
1 20852U 90081Q   24187.50434489  .00002725  00000-0  12222-2 0  9991
2 20852  98.6373 173.5876 0018232 133.4638 226.8060 14.23185352744302
0 CZ-4 DEB
1 20853U 90081R   24187.58941354  .00008949  00000-0  23527-2 0  9998
2 20853  98.2401 190.1027 0019308 339.5905 132.6427 14.49214938754566
0 CZ-4 DEB
1 20855U 90081T   24187.59836104  .00000001  00000-0  25382-4 0  9991
2 20855  98.7527 175.2168 0023770 347.5843 120.6491 14.08928951739091
0 CZ-4 DEB
1 20858U 90081W   24187.60708568  .00005344  00000-0  14011-2 0  9998
2 20858  98.3127 222.4948 0035364 129.9701 348.3808 14.49263768762454
0 CZ-4 DEB
1 20861U 90081Z   24187.56950296  .00015227  00000-0  26409-2 0  9999
2 20861  98.1038 227.3449 0014074 160.3967 199.7782 14.68259375768090
0 CZ-4 DEB
1 20862U 90081AA  24187.62100442  .00000070  00000-0  12267-3 0  9995
2 20862  98.9935  67.2157 0231868 249.0311 165.4187 13.61086411676348
0 CZ-4 DEB
1 20864U 90081AC  24187.50620031  .00001411  00000-0  90583-3 0  9992
2 20864  98.9158 266.1029 0069530  43.2080 327.8703 14.03646141719803
0 CZ-4 DEB
1 20865U 90081AD  24187.58594287  .00022284  00000-0  35453-2 0  9999
2 20865  98.1933 179.7180 0026380  87.7299  29.7296 14.71796650769441
0 CZ-4 DEB
1 20866U 90081AE  24186.88203868  .00001018  00000-0  61510-3 0  9990
2 20866  98.8579 165.0291 0071259 152.6138 238.0009 14.07534382727212
0 CZ-4 DEB
1 20867U 90081AF  24187.49990760  .00000228  00000-0  15997-3 0  9993
2 20867  98.8781 167.9098 0104377 184.4557 299.7552 14.05164128726581
0 CZ-4 DEB
1 20868U 90081AG  24187.34193083  .00000305  00000-0  30783-3 0  9997
2 20868  99.0311 147.8777 0170512 309.4080  49.2080 13.78690163694972
0 CZ-4 DEB
1 20870U 90081AJ  24187.53900422  .00000844  00000-0  48791-3 0  9990
2 20870  98.8182 170.2924 0032684 203.9275 270.8314 14.11403715732386
0 SBS 6
1 20872U 90091A   24187.04702324 -.00000262  00000-0  00000-0 0  9993
2 20872  11.5601  33.9224 0009497 108.7608 127.2994  0.98994668 39046
0 GALAXY 6
1 20873U 90091B   24186.95747049 -.00000183  00000-0  00000-0 0  9998
2 20873  13.5459  15.1288 0004811 167.9551   2.4605  0.99757441 39344
0 CZ-4 DEB
1 20876U 90081AL  24187.57279847  .00003119  00000-0  11229-2 0  9993
2 20876  98.4490 191.8498 0017686 120.8353   1.2599 14.34324309755207
0 CZ-4 DEB
1 20877U 90081AM  24187.61830477  .00016392  00000-0  28371-2 0  9994
2 20877  98.1953 201.4047 0020423  83.3502  33.9959 14.68261562764704
0 CZ-4 DEB
1 20878U 90081AN  24187.60840149  .00023084  00000-0  34023-2 0  9998
2 20878  98.1166 209.4041 0014252 138.8441 221.3845 14.75264881763727
0 CZ-4 DEB
1 20879U 90081AP  24187.47206328  .00001418  00000-0  91544-3 0  9998
2 20879  99.4089 353.8434 0100907 324.2854 100.8170 14.02250306541776
0 CZ-4 DEB
1 20881U 90081AR  24187.55415624  .00001434  00000-0  47122-3 0  9992
2 20881  98.4720 190.2060 0077501 262.5269  96.7108 14.38113671749535
0 CZ-4 DEB
1 20883U 90081AT  24187.55118959  .00003292  00000-0  12176-2 0  9999
2 20883  98.5508 179.3577 0012447 328.2245 152.0876 14.32985385748175
0 CZ-4 DEB
1 20884U 90081AU  24187.55870070  .00002252  00000-0  10691-2 0  9994
2 20884  98.5127 207.7874 0028860 180.6319 179.4827 14.20235867554250
0 CZ-4 DEB
1 20885U 90081AV  24187.30606372  .00000188  00000-0  17956-3 0  9998
2 20885  98.8194 199.5675 0068110 114.3956 259.8859 13.90665758711185
0 CZ-4 DEB
1 20886U 90081AW  24187.49276404  .00000389  00000-0  50993-3 0  9999
2 20886  98.9652  20.7493 0244965 145.4910 271.9211 13.55045589665953
0 CZ-4 DEB
1 20887U 90081AX  24187.58975506  .00003101  00000-0  92977-3 0  9992
2 20887  98.4107 190.6472 0021755 156.7964 325.1653 14.43336374756576
0 CZ-4 DEB
1 20888U 90081AY  24187.48256425  .00007146  00000-0  25818-2 0  9996
2 20888  99.2219   1.8590 0194292 122.0557 239.9654 14.23876235725689
0 CZ-4 DEB
1 20889U 90081AZ  24187.22948315  .00001411  00000-0  88744-3 0  9992
2 20889  98.9320 271.8886 0071071  41.1949 319.4552 14.04760491720323
0 CZ-4 DEB
1 20890U 90081BA  24187.39868254  .00000188  00000-0  13919-3 0  9997
2 20890  98.8514 168.1854 0012801 313.8207  46.1903 14.06632501730309
0 CZ-4 DEB
1 20891U 90081BB  24187.19788694  .00000319  00000-0  37968-3 0  9991
2 20891  99.0770 253.4970 0212479 317.1255 108.9681 13.65502051678869
0 CZ-4 DEB
1 20892U 90081BC  24187.57791707  .00001119  00000-0  98261-3 0  9995
2 20892  98.9632  49.4756 0163808  86.9774 345.2978 13.81505849692315
0 CZ-4 DEB
1 20893U 90081BD  24187.62366484  .00015416  00000-0  28929-2 0  9990
2 20893  98.1562 204.1105 0004885 319.4568 168.5627 14.64795766761148
0 CZ-4 DEB
1 20894U 90081BE  24187.48769832  .00002080  00000-0  81335-3 0  9993
2 20894  98.5206 185.4150 0017750 248.3437 265.1075 14.30506413748428
0 CZ-4 DEB
1 20895U 90081BF  24187.06400556  .00002237  00000-0  58473-3 0  9994
2 20895  98.3742 225.5593 0026527 199.9989 221.8230 14.50159280761261
0 CZ-4 DEB
1 20898U 90081BJ  24187.57022775  .00017864  00000-0  24383-2 0  9990
2 20898  98.1892 231.0100 0027640  45.6031  88.5724 14.78412478775932
0 CZ-4 DEB
1 20899U 90081BK  24187.19994979  .00008114  00000-0  20939-2 0  9994
2 20899  98.3424 259.6248 0011483 221.4481 201.9045 14.50205470752727
0 CZ-4 DEB
1 20900U 90081BL  24187.47905140  .00011796  00000-0  28387-2 0  9995
2 20900  99.0698 186.9779 0034881 206.1036 306.3367 14.53091580743663
0 CZ-4 DEB
1 20902U 90081BN  24187.59892883  .00000607  00000-0  43529-3 0  9994
2 20902  99.2689 317.0053 0077376 331.1056  41.9276 13.99673298715263
0 CZ-4 DEB
1 20903U 90081BP  24187.57910249  .00001105  00000-0  45142-3 0  9997
2 20903  98.4280 202.2960 0057146  21.8603 100.2270 14.28333852752523
0 CZ-4 DEB
1 20904U 90081BQ  24187.56474939  .00007644  00000-0  20970-2 0  9993
2 20904  98.4052 184.2190 0022895 122.0735   3.4595 14.47185248754901
0 CZ-4 DEB
1 20906U 90081BS  24187.47096419  .00000142  00000-0  16483-3 0  9999
2 20906  99.1094 260.2258 0106615 142.2434 233.1168 13.81652072700247
0 CZ-4 DEB
1 20907U 90081BT  24187.38683231  .00026444  00000-0  32105-2 0  9995
2 20907  98.0888 218.3469 0009151 111.9167  20.6387 14.83470847768414
0 CZ-4 DEB
1 20912U 90081BV  24187.57511556  .00002487  00000-0  94455-3 0  9990
2 20912  98.5128 185.0043 0013454 214.2763 263.4608 14.31861075747500
0 CZ-4 DEB
1 20913U 90081BW  24187.49392226  .00000625  00000-0  35537-3 0  9991
2 20913  98.8058 172.3584 0099986 208.9928 272.7702 14.10956652731180
0 CZ-4 DEB
1 20915U 90081BY  24186.93708303  .00001203  00000-0  52475-3 0  9991
2 20915  98.5160 187.0481 0035693 306.2875  84.6861 14.25397181747253
0 INMARSAT 2-F1
1 20918U 90093A   24187.12746043  .00000025  00000-0  00000-0 0  9997
2 20918  12.6945  10.5875 0006757  27.0315 345.1355  0.98874960 40481
0 GORIZONT 21
1 20923U 90094A   24187.11855253  .00000109  00000-0  00000-0 0  9990
2 20923  13.4151 341.9014 0005975 217.2271 151.2447  1.00346162123310
0 SL-12 R/B(2)
1 20926U 90094D   24187.54633404 -.00000169  00000-0  00000-0 0  9999
2 20926  13.1876 341.1954 0037631 137.7688 251.7754  1.00865107124055
0 USA 65
1 20929U 90095A   24186.95014705 -.00000008  00000-0  00000-0 0  9996
2 20929  14.4484 349.0199 0006578 101.8502 246.2529  0.98395666 18457
0 IUS R/B(2)
1 20932U 90095D   24187.39354047 -.00000139  00000-0  00000-0 0  9990
2 20932  14.3525 347.3373 0005344  62.8143 297.2523  0.99253015 18663
0 SATCOM C1
1 20945U 90100A   24187.15765727 -.00000020  00000-0  00000-0 0  9995
2 20945  12.7941  20.1788 0014095  23.0894 141.5863  0.99185581119923
0 GSTAR 4
1 20946U 90100B   24187.54613875 -.00000307  00000-0  00000-0 0  9993
2 20946  13.7906  15.1972 0002561  14.5719 223.4829  0.99146690 39753
0 ARIANE 42P R/B
1 20947U 90100C   24186.81469323  .00012849  00000-0  20745-2 0  9993
2 20947   7.0399 240.0600 5926413 283.5130  20.1480  4.16184007349299
0 GORIZONT 22
1 20953U 90102A   24187.18868519 -.00000027  00000-0  00000-0 0  9999
2 20953  13.3858 342.3359 0001246  15.2257 355.0427  1.00269771123233
0 NAVSTAR 22 (USA 66)
1 20959U 90103A   24184.35250371 -.00000081  00000-0  00000+0 0  9992
2 20959  55.5575  76.2423 0021156  77.9198 282.3489  1.88155390242586
0 GOES 1 AKM
1 20962U 75100F   24187.38316685 -.00000035  00000-0  00000-0 0  9993
2 20962   4.0989 269.9446 0275706  62.5438 300.5836  1.01932912128897
0 USA 67 R/B(2)
1 20965U 90097D   24187.59516856  .00033968  00000-0  11092-2 0  9998
2 20965  24.8427 301.0383 5432328 248.6249  46.9008  5.00909754 81220
0 CZ-4 DEB
1 20969U 90081CB  24187.62659689  .00004587  00000-0  14284-2 0  9992
2 20969  98.4250 191.2926 0043790 347.6073 128.7503 14.40833243754092
0 CZ-4 DEB
1 20972U 90081CE  24186.97263009  .00003405  00000-0  11546-2 0  9996
2 20972  98.4594 186.8303 0018938  16.3072   5.3195 14.37250551752154
0 CZ-4 DEB
1 20973U 90081CF  24187.41746696  .00005210  00000-0  11801-2 0  9995
2 20973  98.2461 236.9451 0039847 249.8905 239.5339 14.56055275766509
0 CZ-4 DEB
1 20974U 90081CG  24187.47074515  .00002221  00000-0  87169-3 0  9996
2 20974  98.5289 184.7673 0012932 286.2352 224.7219 14.30301586747822
0 DMSP 5D-2 F10 (USA 68)
1 20978U 90105A   24187.56844154  .00000464  00000-0  16030-3 0  9997
2 20978  98.7100 228.7600 0071158 244.8387 114.5408 14.39138154760113
0 COSMOS 2109 (GLONASS)
1 21006U 90110A   24185.55466894 -.00000052  00000-0  00000+0 0  9994
2 21006  64.5320  95.6290 0080923 199.9827 342.5263  2.13101779261295
0 COSMOS 2110 (GLONASS)
1 21007U 90110B   24184.83858818 -.00000053  00000-0  00000-0 0  9998
2 21007  64.5485  96.0679 0044207 201.4030 335.7870  2.13101118261244
0 COSMOS 2111 (GLONASS)
1 21008U 90110C   24186.73484699 -.00000044  00000-0  00000-0 0  9992
2 21008  64.5329  95.6724 0018011 239.3493 308.7160  2.13098687261210
0 SL-12 R/B(2)
1 21011U 90110F   24186.42410495 -.00000047  00000-0  00000-0 0  9998
2 21011  64.5438  94.9546 0005836 250.6638 288.6619  2.13261670261496
0 SL-12 R/B(AUX MOTOR)
1 21012U 90110G   24186.71236765  .00000445  00000-0  63664-3 0  9996
2 21012  65.3436 350.1157 5674125  46.1412 348.6741  4.38072955174081
0 SL-12 R/B(AUX MOTOR)
1 21013U 90110H   24186.37196516  .00003806  00000-0  10105-2 0  9993
2 21013  65.0049 286.6933 5508021  13.6818 356.6541  4.77438242554115
0 COSMOS 2112
1 21014U 90111A   24187.37770353  .00000204  00000-0  82425-4 0  9998
2 21014  74.0456 166.7602 0027530 174.4107 185.7357 14.33849654755230
0 SL-8 R/B
1 21015U 90111B   24187.44592195  .00000370  00000-0  13422-3 0  9997
2 21015  74.0507  92.8318 0020448  80.2890 280.0572 14.36594879855569
0 RADUGA 26
1 21016U 90112A   24187.05592127  .00000060  00000-0  00000-0 0  9992
2 21016  13.4762 342.9823 0006696 120.6546 253.3993  1.00282982123122
0 SL-12 R/B(2)
1 21019U 90112D   24187.63326451 -.00000216  00000-0  00000-0 0  9998
2 21019  13.5315 343.1437 0029151 162.1964  98.7246  1.00012038112819
0 COSMOS 2114
1 21028U 90114A   24187.46988959  .00000008  00000-0 -13472-4 0  9998
2 21028  82.5793 328.3042 0006038 106.7762 314.6343 12.62772224545561
0 COSMOS 2115
1 21029U 90114B   24187.61201731  .00000018  00000-0  40335-4 0  9990
2 21029  82.5696 307.4349 0003608  35.9784 335.5050 12.63505430546549
0 COSMOS 2116
1 21030U 90114C   24187.55687797  .00000013  00000-0  12773-4 0  9995
2 21030  82.5758 302.9427 0003592 279.7750  91.6434 12.64294780547507
0 COSMOS 2117
1 21031U 90114D   24187.52833875  .00000026  00000-0  82927-4 0  9995
2 21031  82.5761 293.9046 0007344 240.8417 130.0363 12.64998710548296
0 COSMOS 2118
1 21032U 90114E   24187.49212618  .00000030  00000-0  10169-3 0  9991
2 21032  82.5663 276.2733 0010744 208.9997 151.0500 12.65527621548916
0 COSMOS 2119
1 21033U 90114F   24187.52203573  .00000028  00000-0  93253-4 0  9999
2 21033  82.5727 271.7396 0015168 154.2037 217.2384 12.66342370549953
0 SL-14 R/B
1 21034U 90114G   24187.43407067  .00000035  00000-0  15244-3 0  9995
2 21034  82.5661  59.8663 0039382 168.7287   4.7898 12.55529115536793
0 RADUGA 1-2
1 21038U 90116A   24186.57964413  .00000011  00000-0  00000-0 0  9993
2 21038  13.5159 343.0365 0008031 129.1543  81.3304  1.00223264 40194
0 SL-12 R/B(2)
1 21041U 90116D   24186.98858541 -.00000039  00000-0  00000-0 0  9997
2 21041  14.4663 346.1358 0033942  87.3286 280.8896  0.97941113119455
0 SL-12 R/B(2)
1 21046U 90102D   24187.11980243 -.00000160  00000-0  00000-0 0  9993
2 21046  14.4359 345.8137 0020637 185.4256 169.9124  0.97867338111614
0 NATO 4A
1 21047U 91001A   24187.40272807 -.00000236  00000-0  00000-0 0  9999
2 21047  13.1024 358.8375 0005954 166.8625  52.4181  0.98285382121126
0 DELTA 2 R/B
1 21048U 91001B   24187.49245534  .00000202  00000-0  62789-4 0  9994
2 21048  18.4629 331.8027 1188578 305.5128  43.9956 11.85381424451983
0 NATO 4A R/B(PAM-D)
1 21049U 91001C   24187.50447530  .00000037  00000-0  34111-2 0  9999
2 21049  25.4204 217.7008 7050540 170.3762 357.3993  2.26564813277177
0 ATS 5 AKM
1 21052U 69069C   24187.59133065 -.00000018  00000-0  00000-0 0  9994
2 21052   2.4642 277.1879 0123119 290.6978 178.8976  0.98180567 39393
0 ITALSAT 1
1 21055U 91003A   24187.39702169 -.00000250  00000-0  00000-0 0  9993
2 21055  14.7182 356.9079 0014219  57.1486 298.1518  0.99960205109964
0 EUTE 2-F2
1 21056U 91003B   24186.95938498 -.00000140  00000-0  00000-0 0  9999
2 21056  14.7030   6.8587 0007461 135.6565  54.6186  0.98940374109176
0 INFORMATOR 1
1 21087U 91006A   24187.53662109  .00000070  00000-0  56820-4 0  9990
2 21087  82.9442 292.6938 0036361  64.0175 307.5339 13.75412501677717
0 SL-8 R/B
1 21088U 91006B   24187.57558020  .00000084  00000-0  69464-4 0  9994
2 21088  82.9422 265.3621 0021355 311.9314 172.0165 13.77352477679809
0 COSMOS 2123
1 21089U 91007A   24187.63131558  .00000057  00000-0  43395-4 0  9991
2 21089  82.9237 145.7276 0030252 128.4265  44.4345 13.74788333676140
0 SL-8 R/B
1 21090U 91007B   24187.54113736  .00000072  00000-0  58170-4 0  9995
2 21090  82.9215 120.5379 0021643  38.7739 321.4966 13.76543085677992
0 SL-8 DEB
1 21091U 91007C   24187.04726817  .00000321  00000-0  29147-3 0  9999
2 21091  82.9305  96.4680 0026610 304.7264  66.6718 13.80467668680856
0 COSMOS 2125
1 21100U 91009A   24187.48625502 -.00000003  00000-0  86983-4 0  9999
2 21100  74.0272 186.1251 0010074 192.1538 286.8773 12.49949330523806
0 COSMOS 2126
1 21101U 91009B   24187.60011752 -.00000014  00000-0  91656-5 0  9996
2 21101  74.0318 303.6610 0018859  44.5314 315.7247 12.46050361519070
0 COSMOS 2127
1 21102U 91009C   24187.62718201  .00000023  00000-0  26208-3 0  9990
2 21102  74.0281 239.8797 0007187 324.1071 151.4906 12.48161793521620
0 COSMOS 2128
1 21103U 91009D   24187.59233893 -.00000021  00000-0 -31489-4 0  9994
2 21103  74.0297 127.0107 0014247  69.8736 290.3848 12.51907417526186
0 COSMOS 2129
1 21104U 91009E   24187.43955749  .00000008  00000-0  14900-3 0  9990
2 21104  74.0303  71.7617 0024848   6.5295 166.9084 12.53725341528315
0 COSMOS 2130
1 21105U 91009F   24187.54199463 -.00000019  00000-0 -14635-4 0  9996
2 21105  74.0319 326.8303 0043907 247.0314 181.9826 12.57161723532521
0 COSMOS 2131
1 21106U 91009G   24187.55602733  .00000011  00000-0  15857-3 0  9993
2 21106  74.0303 272.3507 0051748 175.6850 293.3810 12.58944022534704
0 COSMOS 2132
1 21107U 91009H   24187.56482397 -.00000001  00000-0  91916-4 0  9998
2 21107  74.0311  18.2509 0034336 302.1212 113.3458 12.55483408530489
0 SL-8 R/B
1 21108U 91009J   24187.63232009 -.00000004  00000-0  10896-3 0  9990
2 21108  74.0541  53.5477 0175866 242.5315 177.7732 12.18491023378981
0 SL-8 DEB
1 21109U 91009K   24187.58581547  .00000203  00000-0  20123-2 0  9992
2 21109  74.0320  12.4027 0164039 249.7743 167.4984 12.20543882486569
0 SL-8 DEB
1 21110U 91009L   24187.60762002 -.00000024  00000-0 -97563-4 0  9991
2 21110  74.0499 343.3122 0221956 219.6870 218.8806 12.10527691472871
0 COSMOS 2133
1 21111U 91010A   24187.02007458 -.00000148  00000-0  00000-0 0  9999
2 21111  13.7222 347.8081 0008087 158.2312 223.1809  1.00262906122300
0 SL-8 DEB
1 21115U 91009M   24186.81994094  .00000133  00000-0  14197-2 0  9995
2 21115  74.0396 106.0548 0181786 327.8441  89.1707 12.16794190482528
0 MOLNIYA 1-80
1 21118U 91012A   24185.07500473  .00000220  00000-0  00000-0 0  9996
2 21118  65.0089 257.1077 6486101 267.4693  22.5609  2.05236471246304
0 SL-6 R/B(2)
1 21121U 91012D   24187.10838539 -.00000556  00000-0  00000-0 0  9996
2 21121  64.6517 228.2382 6406626 264.2765  24.8310  2.05806176 82471
0 SL-3 DEB
1 21126U 64053C   24187.57291321  .00001064  00000-0  20614-3 0  9999
2 21126  65.0785 101.8180 0051109 166.4371 258.4435 14.67409974161435
0 COSMOS 839 DEB
1 21128U 76067BY  24187.22308589  .00000461  00000-0  17185-2 0  9994
2 21128  66.0375 158.7798 0671435  18.7623  84.1459 12.41485801528180
0 SL-12 R/B(2)
1 21129U 91010F   24187.33441479  .00000014  00000-0  00000-0 0  9998
2 21129  13.6452 347.3825 0018418 202.0833  37.3067  1.00144836122547
0 COSMOS 2135
1 21130U 91013A   24187.60645756  .00000096  00000-0  78514-4 0  9996
2 21130  82.8274  35.7668 0066683  35.6205 324.9375 13.78681087677962
0 SL-8 R/B
1 21131U 91013B   24187.57634226  .00000093  00000-0  73861-4 0  9990
2 21131  82.8268   8.6892 0062366 299.3828  60.1112 13.80478969679885
0 RADUGA 27
1 21132U 91014A   24187.58407530 -.00000322  00000-0  00000-0 0  9996
2 21132  14.0045 342.2779 0003573 138.0068 115.5500  1.00184271122177
0 SL-12 R/B(2)
1 21135U 91014D   24186.91804925 -.00000189  00000-0  00000-0 0  9995
2 21135  12.6734 337.1855 0027930 131.3359 224.8420  1.03432246125976
0 SL-8 DEB
1 21136U 91009N   24186.66835191  .00000042  00000-0  65144-3 0  9991
2 21136  73.9973 259.2612 0286791 299.1617 230.4596 11.97213451458547
0 SL-8 DEB
1 21137U 91009P   24187.08366557 -.00000030  00000-0 -14515-3 0  9999
2 21137  74.0451  59.9737 0151612 274.7562 241.4715 12.18040320483815
0 SL-8 DEB
1 21138U 91009Q   24187.25143326 -.00000025  00000-0 -80739-4 0  9992
2 21138  74.0814 122.7308 0216953 197.8908 331.7803 12.29174426498365
0 ASTRA 1B
1 21139U 91015A   24187.06392736 -.00000050  00000-0  00000-0 0  9996
2 21139  12.4810  27.1770 0010912  17.6466 355.4682  0.98509119109275
0 METEOSAT 5 (MOP 2)
1 21140U 91015B   24187.48281620 -.00000034  00000-0  00000-0 0  9995
2 21140  14.8859 355.1126 0008362 227.2259 103.8203  0.98450602123193
0 INMARSAT 2-F2
1 21149U 91018A   24187.33027414 -.00000073  00000-0  00000-0 0  9993
2 21149  12.3583  13.3127 0001945 115.3817 120.9139  0.98724254 36424
0 INMARSAT 2-F2 R/B(PAM-D)
1 21151U 91018C   24187.40029465  .00016460  00000-0  11282-2 0  9994
2 21151  23.1958 177.9061 4049424 210.2669 118.4850  7.33795884685677
0 NADEZHDA 3
1 21152U 91019A   24187.52922714  .00000066  00000-0  54455-4 0  9994
2 21152  82.9274 111.6751 0040189 259.5918 274.4013 13.74388334670398
0 SL-8 R/B
1 21153U 91019B   24187.48197050  .00000103  00000-0  89608-4 0  9997
2 21153  82.9250  86.7016 0029575 153.2118  19.4691 13.76189857672557
0 SL-8 DEB
1 21154U 91009R   24187.29636094  .00000242  00000-0  29600-2 0  9990
2 21154  74.2594  24.2913 0191095 240.8808 296.6861 12.01246829463952
0 SL-8 DEB
1 21155U 91009S   24187.54415770 -.00000016  00000-0  42269-6 0  9995
2 21155  73.9242 295.1259 0144117 349.5680  23.3893 12.30713947500256
0 SL-8 DEB
1 21156U 91009T   24187.40953022 -.00000006  00000-0  80636-4 0  9995
2 21156  73.9107 190.3774 0147354 248.1272 227.5388 12.33862640501472
0 SL-8 DEB
1 21157U 91009U   24187.38822222 -.00000044  00000-0 -25809-3 0  9993
2 21157  73.9495 152.1794 0174628 177.9197 351.0662 12.24116906489650
0 SL-8 DEB
1 21158U 91009V   24187.54445899  .00000101  00000-0  11625-2 0  9995
2 21158  74.0989 234.5192 0142334 355.5811 117.9166 12.13929732477162
0 SL-8 DEB
1 21159U 91009W   24187.42233152 -.00000007  00000-0  65191-4 0  9995
2 21159  73.9432   2.5612 0144209  23.3983 348.3016 12.29065019495561
0 SL-8 DEB
1 21160U 91009X   24187.41318406  .00000021  00000-0  31433-3 0  9998
2 21160  74.0384 223.1888 0130742  48.4910 326.0965 12.24752737490388
0 SL-8 DEB
1 21161U 91009Y   24187.09510601  .00000022  00000-0  34398-3 0  9998
2 21161  74.0737  48.9398 0132219 197.1487 325.2477 12.19437194483878
0 SL-8 DEB
1 21162U 91009Z   24187.45058297  .00000009  00000-0  20432-3 0  9996
2 21162  73.9785  72.5444 0137236  18.3151 154.1013 12.27817604494077
0 SL-8 DEB
1 21163U 91009AA  24187.42539476  .00000017  00000-0  26983-3 0  9993
2 21163  73.9450 324.0050 0138719 334.2103  83.7227 12.30857893497232
0 SL-8 DEB
1 21164U 91009AB  24187.59317190 -.00000006  00000-0  75234-4 0  9992
2 21164  74.0473 307.1286 0125595 139.9591 234.2720 12.22019920485838
0 SL-8 DEB
1 21165U 91009AC  24187.56715503  .00000236  00000-0  25627-2 0  9993
2 21165  74.1644 339.7057 0160233 333.4270  96.1527 12.12138698474842
0 SL-8 DEB
1 21166U 91009AD  24187.38769111 -.00000003  00000-0  11210-3 0  9995
2 21166  74.0632  48.0142 0122140 223.2417 311.2435 12.19214958483578
0 SL-8 DEB
1 21167U 91009AE  24187.55153521 -.00000024  00000-0 -76803-4 0  9991
2 21167  73.9167 329.6799 0136982  46.9524  29.2070 12.29308932495935
0 SL-8 DEB
1 21168U 91009AF  24187.54993201 -.00000011  00000-0  27749-4 0  9998
2 21168  73.8988 356.4988 0198815 121.8386 301.3884 12.27757475493838
0 SL-8 DEB
1 21169U 91009AG  24187.58038073  .00000031  00000-0  41617-3 0  9990
2 21169  73.9941 236.3703 0131716 172.8928 301.5058 12.22886882488137
0 SL-8 DEB
1 21170U 91009AH  24187.59210811 -.00000219  00000-0 -20888-2 0  9991
2 21170  74.1118 270.2261 0151513  11.6899  99.1695 12.12955994476020
0 SL-8 DEB
1 21171U 91009AJ  24187.47805492  .00000021  00000-0  32501-3 0  9999
2 21171  73.9494 222.5592 0194425 257.3880 213.2026 12.21738478486709
0 SL-8 DEB
1 21172U 91009AK  24187.61887166 -.00000020  00000-0 -42599-4 0  9994
2 21172  74.0339 130.3426 0133852 311.0583 224.7336 12.27702931493910
0 SL-8 DEB
1 21173U 91009AL  24187.51061435 -.00000023  00000-0 -86244-4 0  9995
2 21173  74.1108  89.2228 0136378 155.0283  17.9788 12.19261436483729
0 SL-8 DEB
1 21174U 91009AM  24187.26196832 -.00000116  00000-0 -11662-2 0  9991
2 21174  74.0899 273.4677 0278008 115.7595 314.1843 11.99358764459148
0 SL-8 DEB
1 21175U 91009AN  24187.56188698 -.00000009  00000-0  44541-4 0  9990
2 21175  73.9368   9.2733 0146712  45.8251  22.4565 12.28571503495011
0 SL-8 DEB
1 21176U 91009AP  24187.45317274 -.00000008  00000-0  64575-4 0  9991
2 21176  74.0627  72.1627 0206773 238.7565 297.7469 12.18030123482189
0 SL-8 DEB
1 21177U 91009AQ  24187.55879984 -.00000006  00000-0  84383-4 0  9991
2 21177  74.1065 252.9387 0145931   0.9636 120.9843 12.13523222476632
0 SL-8 DEB
1 21178U 91009AR  24187.37148163 -.00000136  00000-0 -11916-2 0  9995
2 21178  74.0951 160.9570 0141248 270.8214 208.1150 12.16323536482800
0 SL-8 DEB
1 21179U 91009AS  24187.38835865  .00000018  00000-0  31754-3 0  9999
2 21179  73.9910  65.8370 0121700  52.9355 120.9126 12.16203272482685
0 SL-8 DEB
1 21180U 91009AT  24187.62467094  .00000073  00000-0  75300-3 0  9999
2 21180  74.0608 148.4477 0106679 260.4948 275.6331 12.28794505493282
0 SL-8 DEB
1 21181U 91009AU  24187.35874294  .00000058  00000-0  64731-3 0  9993
2 21181  73.9457 208.3147 0206199 248.8167 124.1983 12.22549846487121
0 SL-8 DEB
1 21182U 91009AV  24187.57934042  .00000045  00000-0  54564-3 0  9995
2 21182  73.9987 285.8512 0152777 226.1021 147.5105 12.21911535485991
0 SL-8 DEB
1 21183U 91009AW  24187.47297815  .00000341  00000-0  38189-2 0  9998
2 21183  74.1808 181.2304 0217194 157.7274   0.7610 12.05577297465915
0 SL-8 DEB
1 21184U 91009AX  24187.51234944 -.00000042  00000-0 -25220-3 0  9991
2 21184  74.0257  12.8834 0132903 270.0195 117.2158 12.19097100482257
0 SL-8 DEB
1 21185U 91009AY  24187.52038429 -.00000129  00000-0 -10847-2 0  9997
2 21185  74.0230  90.8150 0204486 357.9560 177.7066 12.16123000479478
0 SL-8 DEB
1 21186U 91009AZ  24187.47995896 -.00000211  00000-0 -20176-2 0  9990
2 21186  74.1033 267.6943 0148803  28.4563 345.6050 12.13035883475707
0 SL-8 DEB
1 21187U 91009BA  24187.30749899 -.00000219  00000-0 -21611-2 0  9996
2 21187  74.2431 140.7364 0178552 332.3523 183.2805 12.09337920471247
0 MOLNIYA 3-40
1 21196U 91022A   24186.58143587 -.00000523  00000-0  00000-0 0  9996
2 21196  64.8213 251.0758 6518948 264.6578  23.6026  2.03006052244874
0 SL-6 R/B(2)
1 21199U 91022D   24186.46523021  .00000137  00000-0  00000-0 0  9991
2 21199  64.4605 209.9341 6441067 261.6069  25.8746  2.05832130249927
0 SL-8 DEB
1 21208U 91009BB  24187.54537105  .00000047  00000-0  50711-3 0  9992
2 21208  73.9603 338.0015 0147662 317.6503 108.1072 12.31001008494297
0 SL-8 DEB
1 21209U 91009BC  24187.60152045  .00000002  00000-0  14305-3 0  9996
2 21209  74.0368 252.0761 0133695  89.7273  19.6774 12.23727576486240
0 SL-8 DEB
1 21210U 91009BD  24187.30861633 -.00000022  00000-0 -66622-4 0  9999
2 21210  74.0949 128.6816 0137353 239.6981 277.1740 12.17439840478537
0 SL-8 DEB
1 21211U 91009BE  24187.14594031  .00000200  00000-0  19524-2 0  9990
2 21211  74.0968  78.7201 0200651 167.1129   1.6180 12.19686019480404
0 SL-8 DEB
1 21212U 91009BF  24187.57815256 -.00000024  00000-0 -11725-3 0  9995
2 21212  74.1609 119.1731 0232365 139.2007  36.6679 12.06916716465846
0 COSMOS 2139 (GLONASS)
1 21216U 91025A   24183.34478254 -.00000075  00000-0  00000-0 0  9997
2 21216  64.8014 329.3956 0016255 222.2771 137.5916  2.13106325258679
0 COSMOS 2140 (GLONASS)
1 21217U 91025B   24186.78274649 -.00000087  00000-0  00000-0 0  9994
2 21217  64.7890 329.1726 0025906 219.6640 113.4578  2.13101165258755
0 COSMOS 2141 (GLONASS)
1 21218U 91025C   24184.58829067 -.00000082  00000-0  00000-0 0  9996
2 21218  64.7832 329.1523 0004999 226.7404 207.0145  2.13103469258741
0 SL-12 R/B(AUX MOTOR)
1 21220U 91025F   24187.25923657  .00000517  00000-0  78922-3 0  9999
2 21220  64.7338 148.2492 5636526 151.2082 257.3846  4.43491786519266
0 SL-12 R/B(2)
1 21221U 91025E   24186.77206545 -.00000087  00000-0  00000-0 0  9998
2 21221  64.7841 328.8942 0014589 216.3211 121.5792  2.13168226258844
0 ANIK E2
1 21222U 91026A   24186.75899525 -.00000200  00000-0  00000-0 0  9991
2 21222  13.5110  17.4516 0006357  62.3558 115.6958  0.99131123110002
0 ARIANE 44P R/B
1 21223U 91026B   24187.13955077  .00000227  00000-0  11648-2 0  9990
2 21223   3.5926 143.9484 7185698 158.4848 261.9413  2.31645498256249
0 SL-12 R/B(AUX MOTOR)
1 21226U 91025G   24187.33467504  .00006272  00000-0  18919-2 0  9991
2 21226  64.6028 192.7456 4469061  79.6780 326.3539  6.45046531617337
0 SPACENET 4 (ASC 2)
1 21227U 91028A   24187.59151047  .00000067  00000-0  00000-0 0  9991
2 21227  13.1459  18.8892 0003294 330.6262   1.4337  0.99567532119280
0 DELTA 2 R/B
1 21228U 91028B   24187.38431142  .00001441  00000-0  58423-3 0  9998
2 21228  23.9947 164.3497 1137616 333.7491  20.9381 12.54540449520941
0 SPACENET 4 R/B(PAM-D)
1 21229U 91028C   24187.37595934 -.00000117  00000-0  00000-0 0  9993
2 21229  21.8499 122.6610 6883553 238.5290 243.3843  2.19703870266644
0 COSMOS 2142
1 21230U 91029A   24187.58541969  .00000081  00000-0  71078-4 0  9994
2 21230  82.9550  43.5428 0038734  30.2329  26.8980 13.73269299664683
0 SL-8 R/B
1 21231U 91029B   24187.56312488  .00000087  00000-0  73505-4 0  9998
2 21231  82.9524   0.6997 0034209 232.5059 188.5451 13.75987845667655
0 METEOR 3-4
1 21232U 91030A   24187.46742405  .00000177  00000-0  42919-3 0  9990
2 21232  82.5443 327.7570 0013663 133.4435 286.7023 13.16673340595440
0 SL-14 R/B
1 21233U 91030B   24187.49767341  .00000214  00000-0  52804-3 0  9996
2 21233  82.5484 336.1048 0017318 158.2578 262.6966 13.16369046595112
0 SL-8 DEB
1 21234U 91009CT  24186.87731434  .00000098  00000-0  90453-3 0  9990
2 21234  74.0109 339.1103 0125761 195.5192 320.4300 12.32738199498850
0 SL-8 DEB
1 21249U 91009BG  24187.57435583 -.00000022  00000-0 -71627-4 0  9992
2 21249  74.0739 332.8833 0123286 108.3922   8.2444 12.22298749486991
0 SL-8 DEB
1 21250U 91009BH  24187.45015670 -.00000061  00000-0 -44162-3 0  9998
2 21250  74.0612  67.7251 0139998 246.1373 185.4281 12.18791441482635
0 SL-8 DEB
1 21251U 91009BJ  24187.39537501  .00000115  00000-0  98860-3 0  9996
2 21251  73.9513 188.3675 0148554 144.5048 338.3436 12.36160837503344
0 SL-8 DEB
1 21252U 91009BK  24187.53923760  .00000067  00000-0  72355-3 0  9996
2 21252  74.1064 295.6823 0125651 340.6667  31.9089 12.24859149489863
0 SL-8 DEB
1 21253U 91009BL  24187.18773808 -.00000023  00000-0 -84659-4 0  9999
2 21253  74.1113 227.6199 0148190 314.2444 102.8667 12.14586692477869
0 SL-8 DEB
1 21254U 91009BM  24187.62566284 -.00000016  00000-0 -78087-5 0  9998
2 21254  73.8911   0.9392 0188877  86.4431 342.8430 12.39374657508074
0 SL-8 DEB
1 21255U 90111C   24187.35504418  .00002049  00000-0  55608-3 0  9991
2 21255  74.0385 294.9893 0013309 262.1764 154.1899 14.48182055762383
0 SL-8 DEB
1 21256U 91009BN  24187.57854171 -.00000061  00000-0 -67926-3 0  9997
2 21256  73.9756 249.8839 0246766  60.0944  55.8390 11.84099897437103
0 SL-8 DEB
1 21257U 91007D   24187.60873403  .00000346  00000-0  33047-3 0  9990
2 21257  82.9200 123.4218 0034648  50.7239  12.5994 13.77651025676154
0 NOAA 12
1 21263U 91032A   24187.58540320  .00000191  00000-0  97577-4 0  9998
2 21263  98.5577 178.2863 0012799 311.6952  48.3133 14.26331293723500
0 DELTA 1 DEB
1 21268U 75052D   24187.51688020  .00000030  00000-0  18902-3 0  9996
2 21268  99.9114 272.2840 0200589 127.7265 247.3040 13.06488283580841
0 DELTA 1 DEB
1 21269U 75052E   24187.50874606  .00000096  00000-0  31470-3 0  9990
2 21269  99.7947  93.0684 0117495 260.3988 276.4580 13.23497069601362
0 DELTA 1 DEB
1 21270U 75052F   24187.39521615  .00000758  00000-0  31496-2 0  9990
2 21270  99.4371 343.5610 0441461 299.9976  82.7646 12.60068286519478
0 DELTA 1 DEB
1 21271U 75052G   24187.21858588  .00000086  00000-0  34143-3 0  9991
2 21271  99.6199 285.4792 0246911 145.8767 246.1592 13.02191123575139
0 DELTA 1 DEB
1 21272U 75052H   24187.03673043  .00000156  00000-0  56777-3 0  9998
2 21272  99.8256  30.0701 0309445  57.4669 107.1348 12.93112193497576
0 DELTA 1 DEB
1 21273U 75052J   24187.52729858  .00000048  00000-0  17045-3 0  9994
2 21273  99.7671  50.7365 0035830 185.0022 245.5723 13.37817977398213
0 DELTA 1 DEB
1 21275U 75052L   24187.63265531  .00000067  00000-0  17075-3 0  9995
2 21275  99.9192  87.2409 0034163 136.5278 292.1929 13.51690783636133
0 DELTA 1 DEB
1 21276U 75052M   24187.59409133  .00000025  00000-0  13626-3 0  9991
2 21276 100.0645  88.7146 0046498  10.9693  63.8654 13.35459947616745
0 DELTA 1 DEB
1 21277U 75052N   24187.50350031  .00000144  00000-0  44074-3 0  9998
2 21277  99.6645   4.9333 0134254 100.1928 329.3799 13.18981522596150
0 DELTA 1 DEB
1 21278U 75052P   24187.52402861 -.00000014  00000-0  77308-4 0  9994
2 21278  99.8415  64.1390 0392389 343.6789  80.4822 12.77324796545685
0 DELTA 1 DEB
1 21279U 75052Q   24187.46544965  .00000116  00000-0  21791-3 0  9996
2 21279  99.3897   6.6524 0056558  82.2236 333.4401 13.57329045642484
0 DELTA 1 DEB
1 21280U 75052R   24187.56204708  .00000098  00000-0  19833-3 0  9990
2 21280  99.3920  23.9852 0050550 194.9555 237.7307 13.55836775640862
0 DELTA 1 DEB
1 21281U 75052S   24187.61514617  .00000064  00000-0  21355-3 0  9995
2 21281  99.9372 127.0778 0056506 197.3361 336.5591 13.34141870614835
0 DELTA 1 DEB
1 21282U 75052T   24187.45882041  .00000067  00000-0  24332-3 0  9998
2 21282  99.7301 153.2658 0100073 171.3843 313.3895 13.24706475603622
0 DELTA 1 DEB
1 21283U 75052U   24187.41082347 -.00000349  00000-0 -93550-3 0  9999
2 21283  99.7278 344.9171 0243930  72.5130 345.2503 12.97692311570430
0 DELTA 1 DEB
1 21284U 75052V   24187.50857877  .00000104  00000-0  30508-3 0  9999
2 21284  99.8644 285.6751 0076254 254.2192 116.9752 13.31149431610897
0 DELTA 1 DEB
1 21285U 75052W   24187.55981125  .00000031  00000-0  13219-3 0  9998
2 21285  99.7328  57.2436 0018740 268.9649 148.5602 13.41173771623966
0 DELTA 1 DEB
1 21286U 75052X   24187.49711656  .00000001  00000-0  83500-4 0  9990
2 21286  99.6440   8.5777 0054384  98.5271 317.2535 13.33396076614472
0 DELTA 1 DEB
1 21287U 75052Y   24187.51575219  .00000006  00000-0  11065-3 0  9998
2 21287  99.6713  18.8347 0131572 127.2352 289.5517 13.17897371595798
0 DELTA 1 DEB
1 21288U 75052Z   24187.32088660 -.00000021  00000-0  60305-4 0  9997
2 21288  99.6334 211.4096 0353581 300.0137  69.7627 12.75631004544266
0 DELTA 1 DEB
1 21289U 75052AA  24187.36640677 -.00000154  00000-0 -33317-3 0  9994
2 21289  99.9121 226.8776 0247906 177.7759 195.3697 12.99776386572062
0 DELTA 1 DEB
1 21290U 75052AB  24187.07841635  .00000250  00000-0  12719-2 0  9998
2 21290  99.5221 224.6041 0513146 203.1342 183.2000 12.43208902504349
0 DELTA 1 DEB
1 21291U 75052AC  24187.60919731  .00000639  00000-0  59059-3 0  9991
2 21291  99.8039 308.3584 0139708 108.2829 266.1536 13.82244398669299
0 DELTA 1 DEB
1 21292U 75052AD  24187.57955311  .00000443  00000-0  56992-3 0  9998
2 21292  99.8659  51.6781 0226016  64.8917 350.8788 13.58061429640822
0 DELTA 1 DEB
1 21293U 75052AE  24187.53107395  .00000007  00000-0  13621-3 0  9994
2 21293  99.8570  26.5737 0273149 130.2692 297.4504 12.91492286561306
0 DELTA 1 DEB
1 21294U 75052AF  24187.58539431  .00000251  00000-0  90601-3 0  9994
2 21294  99.8185  30.3983 0250562 345.3375  78.9761 12.94325453564535
0 DELTA 1 DEB
1 21295U 75052AG  24187.52519823  .00000245  00000-0  50905-3 0  9998
2 21295  99.7623  27.3443 0018460 258.6549 157.6284 13.42521479622256
0 DELTA 1 DEB
1 21296U 75052AH  24187.58208280  .00000416  00000-0  11317-2 0  9990
2 21296  99.6284  65.7520 0235879 120.9832 305.2733 13.10287393583088
0 DELTA 1 DEB
1 21297U 75052AJ  24187.58957630  .00000136  00000-0  35905-3 0  9990
2 21297  99.7336  44.3512 0069242 241.6084 174.2229 13.33034922611372
0 COSMOS 2143
1 21299U 91033A   24187.58374918  .00000041  00000-0  16699-3 0  9995
2 21299  82.5741  38.4025 0012038 227.6174 193.7371 12.63901058528671
0 COSMOS 2144
1 21300U 91033B   24187.60555634  .00000044  00000-0  18583-3 0  9994
2 21300  82.5768  63.5456 0004089 291.7972  68.2683 12.62362469526671
0 COSMOS 2145
1 21301U 91033C   24187.61935532  .00000045  00000-0  19311-3 0  9996
2 21301  82.5662  42.7535 0007391 265.6693  94.3554 12.63184284527666
0 COSMOS 2146
1 21302U 91033D   24187.60590730  .00000041  00000-0  16624-3 0  9993
2 21302  82.5754  30.4711 0015416 205.1472 154.8872 12.64524232529388
0 COSMOS 2147
1 21303U 91033E   24187.59291625  .00000042  00000-0  16597-3 0  9993
2 21303  82.5669  12.4051 0018897 179.7473 243.6868 12.65135576530164
0 COSMOS 2148
1 21304U 91033F   24187.52719913  .00000036  00000-0  13415-3 0  9991
2 21304  82.5737   7.5479 0023940 135.2155 279.4148 12.65960195531059
0 SL-14 R/B
1 21305U 91033G   24187.39687220  .00000014  00000-0  19524-4 0  9996
2 21305  82.5655 156.9394 0037937 174.6727 299.9922 12.54816609517720
0 DELTA 1 DEB
1 21317U 75052AK  24187.48784328  .00001339  00000-0  24199-2 0  9992
2 21317 100.0950 120.7608 0214638 228.7340 195.1130 13.34726626585362
0 DELTA 1 DEB
1 21318U 75052AL  24187.37605584  .00026404  00000-0  59704-2 0  9997
2 21318  99.3590 108.3090 0115767 122.2510   4.3848 14.52069173686929
0 DELTA 1 DEB
1 21319U 75052AM  24187.59562185  .00000016  00000-0  14212-3 0  9998
2 21319  99.6816  57.3545 0239213  40.2688  14.0557 13.06385974577270
0 DELTA 1 DEB
1 21320U 75052AN  24187.57073334  .00000347  00000-0  39904-3 0  9993
2 21320  99.6004  56.6606 0128583 153.0046 269.0792 13.73116395657870
0 DELTA 1 DEB
1 21324U 75052AS  24187.41631784  .00000213  00000-0  56849-3 0  9998
2 21324  99.5835 241.6392 0316338 107.5941 268.1768 13.08988606572822
0 DELTA 1 DEB
1 21325U 75052AT  24187.43649846  .00004763  00000-0  32366-2 0  9990
2 21325  99.7392 131.7509 0105127 264.6387 218.7062 13.97939128663623
0 DELTA 1 DEB
1 21326U 75052AU  24187.47799167  .00000146  00000-0  34009-3 0  9995
2 21326  99.9004  82.0312 0031009 346.9250 188.6734 13.41507144620538
0 DELTA 1 DEB
1 21327U 75052AV  24187.51425588  .00000115  00000-0  48645-3 0  9991
2 21327  99.6865 165.1236 0279980  39.9861  85.4263 12.89872024559409
0 DELTA 1 DEB
1 21329U 75052AX  24187.42225530  .00011038  00000-0  43733-2 0  9996
2 21329  99.7044 132.3062 0174592 269.0893 212.8876 14.21071752666039
0 DELTA 1 DEB
1 21330U 75052AY  24187.60042590  .00000036  00000-0  12776-3 0  9991
2 21330 100.0368  83.4505 0305670 234.7005 192.9071 13.33423901610427
0 DELTA 1 DEB
1 21331U 75052AZ  24187.21529233  .00000040  00000-0  15224-3 0  9999
2 21331  99.7454  53.1325 0026769  34.8403  90.3499 13.39636601621541
0 SL-8 DEB
1 21332U 91009CP  24187.25112744  .00000122  00000-0  13096-2 0  9994
2 21332  74.1980 287.4681 0144448 185.7416 188.3753 12.17817210431929
0 DELTA 1 DEB
1 21333U 75052BB  24187.38388062  .00000042  00000-0  14412-3 0  9992
2 21333  99.7125 352.1163 0004506  81.3162 338.9350 13.45328432628433
0 DELTA 1 DEB
1 21335U 75052BD  24187.46905977  .00123708  00000-0  22602-1 0  9996
2 21335  99.1013 153.1431 0040226  79.9828 280.5907 14.64640004645762
0 DELTA 1 DEB
1 21336U 75052BE  24187.56592965  .00006131  00000-0  11332-1 0  9995
2 21336  99.2102 139.3370 0166247 194.9035 227.7953 13.34874193596056
0 DELTA 1 DEB
1 21338U 75052BG  24187.47938963  .00000038  00000-0  15451-3 0  9997
2 21338  99.6013 132.5832 0060819 159.3348 310.6199 13.34813599613632
0 DELTA 1 DEB
1 21339U 75052BH  24187.19180830  .00000033  00000-0  24758-3 0  9994
2 21339  99.5798  67.5934 0372970 343.6096 173.6312 12.73701586538975
0 DELTA 1 DEB
1 21341U 75052BK  24187.41542701  .00000090  00000-0  44319-3 0  9999
2 21341  99.7317 340.3306 0500196 110.8063 310.9853 12.58075059520310
0 DELTA 1 DEB
1 21342U 75052BL  24187.42419167  .00004670  00000-0  16766-2 0  9992
2 21342  99.9783  83.2343 0143138 139.1782 277.2777 14.28870598703149
0 DELTA 1 DEB
1 21343U 75052BM  24186.80479241  .00039070  00000-0  10537-1 0  9994
2 21343  98.9971 311.1887 0032760 107.8928 252.5839 14.47387361672227
0 DELTA 1 DEB
1 21345U 75052BP  24187.40224649  .00000289  00000-0  85550-3 0  9992
2 21345  99.3902 150.3516 0188124 266.3837 247.9529 13.10539462581353
0 DELTA 1 DEB
1 21347U 75052BR  24187.46668521  .00004908  00000-0  74406-2 0  9990
2 21347  99.3674  16.9715 0412191 222.4086 164.5238 13.23402253570071
0 DELTA 1 DEB
1 21351U 75052BV  24187.41162109  .00000015  00000-0  11681-3 0  9993
2 21351  99.7468 334.7084 0064985 222.6680 200.8406 13.31531809609474
0 DELTA 1 DEB
1 21352U 75052BW  24187.30805163  .00000949  00000-0  20716-2 0  9990
2 21352  99.5389 294.3680 0292813  90.3167 336.2200 13.16488261580325
0 DELTA 1 DEB
1 21353U 75052BX  24185.97091588  .00000061  00000-0  43111-3 0  9990
2 21353  99.5162 189.2580 0521338 350.4731  60.6752 12.40610024499183
0 DELTA 1 DEB
1 21354U 75052BY  24187.48724765  .00001813  00000-0  35273-2 0  9994
2 21354  99.5043 138.7916 0225730 242.9863 240.8359 13.28569430594139
0 DELTA 1 DEB
1 21355U 75052BZ  24187.33779388  .00000018  00000-0  14862-3 0  9998
2 21355  99.6170 215.3376 0149320 230.9739 142.6213 13.14121639588639
0 DELTA 1 DEB
1 21356U 75052CA  24187.39589258  .00000111  00000-0  31635-3 0  9991
2 21356  99.6745 135.6037 0092227 189.1207 289.1707 13.30497600607532
0 DELTA 1 DEB
1 21358U 75052CC  24187.34419921  .00000175  00000-0  53792-3 0  9995
2 21358  99.6475 124.8167 0167817 281.9099 206.9287 13.14919113586431
0 DELTA 1 DEB
1 21360U 75052CE  24187.50525146  .00000003  00000-0  96952-4 0  9999
2 21360  99.8674 275.1263 0076701 316.9857  53.6837 13.29365905607135
0 DELTA 1 DEB
1 21361U 75052CF  24183.60769057  .00004616  00000-0  24760-1 0  9997
2 21361  99.5866 236.6392 0741439 152.5960   2.4930 12.02525333445664
0 DELTA 1 DEB
1 21362U 75052CG  24187.18867892 -.00003942  00000-0 -13910-1 0  9999
2 21362  99.4330  90.9743 0614009 258.0257 265.4524 12.45493898483113
0 DELTA 1 DEB
1 21363U 75052CH  24187.52258480  .00000001  00000-0  10351-3 0  9994
2 21363  99.6705 157.0909 0175705 120.8421   5.8702 13.10090598583258
0 DELTA 1 DEB
1 21364U 75052CJ  24187.34783807 -.00000101  00000-0 -19539-3 0  9991
2 21364  99.6330 211.3548 0255705 107.4660  10.9430 12.96806032565099
0 DELTA 1 DEB
1 21365U 75052CK  24187.62699678 -.00000587  00000-0 -16478-2 0  9991
2 21365  99.7296 317.8510 0231012 349.3167  23.5813 12.98341753569003
0 DELTA 1 DEB
1 21366U 75052CL  24187.63080655  .00000179  00000-0  38658-3 0  9992
2 21366  99.7425  60.4730 0020845 267.1142 148.5930 13.43419672622301
0 DELTA 1 DEB
1 21367U 75052CM  24187.55230052  .00000119  00000-0  33494-3 0  9999
2 21367  99.8584 279.3811 0073184 251.6251 119.6018 13.31171185608090
0 DELTA 1 DEB
1 21368U 75052CN  24187.48808681  .00000030  00000-0  97221-4 0  9992
2 21368  99.4801   4.3058 0075306 235.7966 140.8210 13.59207749642816
0 DELTA 1 DEB
1 21369U 75052CP  24187.50879337  .00023400  00000-0  61171-2 0  9991
2 21369  99.6589 165.9211 0062939 321.8379 163.0861 14.48178090691414
0 DELTA 1 DEB
1 21370U 75052CQ  24187.62563014  .00000001  00000-0  91298-4 0  9995
2 21370  99.8263 330.0358 0080656  85.4039 286.7023 13.28080645605262
0 DELTA 1 DEB
1 21371U 75052CR  24187.56374093 -.00000014  00000-0  68497-4 0  9996
2 21371  99.7970 299.8662 0151703 325.9363  47.1989 13.14188408588509
0 DELTA 1 DEB
1 21372U 75052CS  24187.47055400  .00000090  00000-0  27231-3 0  9998
2 21372 100.2628  83.8912 0061044 180.4413 355.6472 13.33416162611294
0 DELTA 1 DEB
1 21373U 75052CT  24187.49705566  .00000135  00000-0  36342-3 0  9999
2 21373  99.9913  92.4709 0074183 284.3778 252.4301 13.32403343609526
0 DELTA 1 DEB
1 21374U 75052CU  24187.45032122  .00000908  00000-0  10213-2 0  9993
2 21374  99.9019  11.8045 0259911 281.4979 105.2655 13.60237624636937
0 DELTA 1 DEB
1 21377U 75052CX  24187.53067670  .00001622  00000-0  29366-2 0  9994
2 21377 100.2796 181.2071 0224492 273.7887 208.3596 13.33583763598526
0 DELTA 1 DEB
1 21380U 75052DA  24187.42095765  .00000371  00000-0  53315-3 0  9994
2 21380  99.3343 164.1364 0057630 184.0586 339.5561 13.61651969641689
0 DELTA 1 DEB
1 21382U 75052DC  24187.51095027  .00210796  00000-0  43799-1 0  9994
2 21382 100.2363  29.2744 0130989 347.0947  12.6902 14.53566331569158
0 DELTA 1 DEB
1 21383U 75052DD  24187.47262848  .00000096  00000-0  47102-3 0  9991
2 21383  99.6544 176.1962 0367977  97.9028  52.1810 12.72993947537872
0 DELTA 1 DEB
1 21384U 75052DE  24187.23015720 -.00000096  00000-0 -18027-3 0  9997
2 21384  99.6856 111.1440 0297057 344.3372 175.0959 12.90998768559049
0 DELTA 1 DEB
1 21386U 75052DG  24187.52937610  .00000738  00000-0  15597-2 0  9991
2 21386  99.6028 274.0449 0185798 126.2512 248.9008 13.28008971598320
0 DELTA 1 DEB
1 21387U 75052DH  24186.83531941  .00000263  00000-0  50783-3 0  9992
2 21387  99.4216 146.7688 0045270 231.2882 158.2105 13.45746161623863
0 DELTA 1 DEB
1 21388U 75052DJ  24187.46571110  .00000077  00000-0  18506-3 0  9995
2 21388  99.6153  81.1764 0070898 236.1727 301.2580 13.50456971631251
0 AURORA 2
1 21392U 91037A   24186.29139123 -.00000261  00000-0  00000-0 0  9998
2 21392  14.3797  10.4676 0002944 198.3546 345.7623  0.99020500119678
0 DELTA 2 R/B
1 21393U 91037B   24187.26007954  .00005505  00000-0  39876-3 0  9994
2 21393  24.9769 157.9616 0841673 162.8807 200.1955 13.67416821600437
0 AURORA 2 R/B(PAM-D)
1 21394U 91037C   24187.06044116 -.00000029  00000-0  00000-0 0  9995
2 21394  23.5949 241.0264 6813936 319.0410   6.3783  2.22012082268592
0 OKEAN 3
1 21397U 91039A   24187.53389221  .00003509  00000-0  29118-3 0  9990
2 21397  82.5179 207.3651 0014511 244.0109 115.9620 14.98444999773149
0 SL-14 R/B
1 21398U 91039B   24187.57501662  .00000656  00000-0  81696-4 0  9990
2 21398  82.5230 347.8813 0021579  21.9652 338.2481 14.80821635763775
0 SL-8 DEB
1 21400U 91009BP  24187.43113374  .00000009  00000-0  17489-3 0  9995
2 21400  73.9666 163.7706 0182328  81.5540  75.0285 12.36757780431453
0 SL-8 DEB
1 21401U 91009BQ  24186.79289231 -.00000049  00000-0 -33297-3 0  9991
2 21401  74.1320 188.7175 0143370 219.3068 318.6816 12.16907628480020
0 SL-8 DEB
1 21402U 91009BR  24187.31474604  .00000008  00000-0  21952-3 0  9999
2 21402  74.0273  46.3569 0135336 304.5765 172.9417 12.18336946482039
0 SL-8 DEB
1 21403U 91009BS  24187.59102032  .00000073  00000-0  71939-3 0  9995
2 21403  73.9368 303.1247 0135047 329.3022  42.0798 12.31666997496929
0 SL-8 DEB
1 21404U 91009BT  24187.59554278  .00000015  00000-0  21866-3 0  9999
2 21404  73.9603  18.7246 0184491 290.2916 128.1283 12.41383297508597
0 SL-8 DEB
1 21405U 91009BU  24187.40738391  .00000013  00000-0  25221-3 0  9997
2 21405  73.9601 319.8747 0227763 348.3251  66.8352 12.18778476481220
0 SL-8 DEB
1 21406U 91009BV  24187.28320227  .00000046  00000-0  49494-3 0  9993
2 21406  73.9141 282.7832 0136457 356.3957  33.7269 12.31660982492964
0 SL-8 DEB
1 21407U 91009BW  24187.44936074  .00000124  00000-0  10951-2 0  9997
2 21407  73.8498 192.4320 0176138  38.2624 116.6621 12.32473250498853
0 SL-8 DEB
1 21408U 91009BX  24186.80083543 -.00000070  00000-0 -53498-3 0  9997
2 21408  74.0262 117.0970 0200336  19.3412   9.4407 12.15862708478842
0 COSMOS 2150
1 21418U 91041A   24187.54687216  .00000231  00000-0  95345-4 0  9998
2 21418  74.0379 331.3025 0017913 291.6976  68.2267 14.32194238727336
0 SL-8 R/B
1 21419U 91041B   24187.60005919  .00000307  00000-0  11694-3 0  9998
2 21419  74.0396 267.5550 0041712 286.0552  73.6008 14.34609196729310
0 SL-8 DEB
1 21420U 91041C   24187.51736830  .00001541  00000-0  45831-3 0  9994
2 21420  74.0643 209.2006 0006259 317.8409 194.5364 14.44017953732718
0 COSMOS 2151
1 21422U 91042A   24187.63362829  .00002834  00000-0  25037-3 0  9995
2 21422  82.5000 312.2921 0012503 328.8605  31.1874 14.95963500771541
0 SL-14 R/B
1 21423U 91042B   24187.40147548  .00000611  00000-0  76011-4 0  9990
2 21423  82.4932  74.0008 0018872  91.8843 268.4532 14.80818847762420
0 MOLNIYA 1-81
1 21426U 91043A   24186.73411140  .00000141  00000-0  00000-0 0  9990
2 21426  63.5545 253.9414 6855842 263.0977  21.1563  2.00592279242175
0 SL-6 R/B(2)
1 21429U 91043D   24170.51958102  .00000845  00000-0  00000-0 0  9997
2 21429  64.2948 331.2081 7095490 265.8419  17.6883  1.96660130237030
0 DELTA 1 DEB
1 21433U 75052DR  24187.22628925  .00000272  00000-0  49284-3 0  9991
2 21433  99.6690 357.2198 0058882 208.6195 327.1550 13.49778491632031
0 DELTA 1 DEB
1 21434U 75052DS  24187.11396413 -.00000047  00000-0 -78280-4 0  9995
2 21434  99.4571  63.7536 0655602 247.5486 277.3622 12.16217838472271
0 DELTA 1 DEB
1 21437U 75052DV  24187.16712352  .00000181  00000-0  43313-3 0  9992
2 21437 100.2528  75.5942 0056613 349.2737 165.7227 13.37084756617249
0 DELTA 1 DEB
1 21438U 75052DW  24186.79064671  .00000110  00000-0  31375-3 0  9992
2 21438  99.6872 131.1357 0079430 185.8349 203.6160 13.30643689609481
0 DELTA 1 DEB
1 21439U 75052DX  24185.98934969  .00005075  00000-0  82621-2 0  9993
2 21439 100.0061 197.3874 0354336 318.0615  39.3858 13.26226165517852
0 DELTA 1 DEB
1 21441U 75052DZ  24187.33323083  .00000103  00000-0  48207-3 0  9996
2 21441  99.6604  30.8318 0302363 283.1674 255.5065 12.84092280554209
0 DELTA 1 DEB
1 21442U 75052EA  24187.16801188  .00005521  00000-0  12785-1 0  9994
2 21442  99.5315 151.2127 0349213  96.5017 279.3855 13.05180342546153
0 DELTA 1 DEB
1 21443U 75052EB  24187.41100937  .00000056  00000-0  20077-3 0  9990
2 21443  99.7293 342.0965 0067727 219.3155 197.7010 13.31555417611906
0 DELTA 1 DEB
1 21444U 75052EC  24187.43445970  .00000366  00000-0  12440-2 0  9990
2 21444  99.6370 173.3086 0263140 221.9499 294.3089 12.94323433564780
0 DELTA 1 DEB
1 21445U 75052ED  24187.39898596  .00000017  00000-0  12569-3 0  9998
2 21445  99.7325 237.4323 0081326 350.4393  22.8327 13.28465257608229
0 DELTA 1 DEB
1 21446U 75052EE  24187.50339775  .00000152  00000-0  68871-3 0  9998
2 21446  99.6713 170.5566 0374220 154.1797 329.0380 12.71574679538961
0 DELTA 1 DEB
1 21448U 75052EG  24187.54499760  .00000009  00000-0  11912-3 0  9990
2 21448  99.7238 285.7743 0130206  38.9482 335.3827 13.18160252595774
0 DELTA 1 DEB
1 21450U 75052EJ  24187.18609810  .00000147  00000-0  37294-3 0  9996
2 21450  99.9182  85.9790 0058638 163.2743 351.5469 13.34989956614399
0 DELTA 1 DEB
1 21452U 75052EL  24186.79174458  .00000984  00000-0  44961-2 0  9996
2 21452  99.7376 199.4732 0573262 286.8497 254.0939 12.37321938486617
0 DELTA 1 DEB
1 21453U 75052EM  24187.50087330  .00000178  00000-0  47741-3 0  9994
2 21453  99.7947   4.8918 0119066 316.5609 114.4302 13.26510032604395
0 DELTA 1 DEB
1 21457U 75052ER  24187.31279049  .00002807  00000-0  40063-2 0  9997
2 21457  99.9637  97.6877 0296279  90.3338  26.6949 13.40641730606781
0 DELTA 1 DEB
1 21458U 75052ES  24187.40680596  .00000192  00000-0  90959-3 0  9996
2 21458  99.7924 146.5122 0563375   0.6327 113.7233 12.44277127505030
0 DELTA 1 DEB
1 21459U 75052ET  24187.36878565  .00000194  00000-0  42332-3 0  9991
2 21459  99.6784  24.7858 0053251  49.7257  72.5609 13.41008832621660
0 DELTA 1 DEB
1 21460U 75052EU  24187.41960875  .00000116  00000-0  34010-3 0  9993
2 21460  99.7080 136.5248 0081370 310.1054 171.1367 13.28271648607269
0 DELTA 1 DEB
1 21461U 75052EV  24187.33366064  .00000190  00000-0  51478-3 0  9994
2 21461  99.6786 323.9880 0204620 289.1621 124.4122 13.20177128596757
0 DELTA 1 DEB
1 21463U 75052EX  24184.54927987  .00000373  00000-0  54921-3 0  9992
2 21463  99.9186  46.6407 0154658 212.4486 214.2580 13.56621602638486
0 DELTA 1 DEB
1 21464U 75052EY  24187.41250557  .00001397  00000-0  35539-2 0  9994
2 21464  99.8596 149.5722 0203498 264.2253 252.0748 13.13353641567810
0 DELTA 1 DEB
1 21465U 75052EZ  24187.17174414  .00000260  00000-0  48159-3 0  9996
2 21465  99.7046  64.4629 0070378  49.8727 105.7037 13.48245555629112
0 DELTA 1 DEB
1 21466U 75052FA  24185.80740854  .00000262  00000-0  69665-3 0  9999
2 21466  99.6729  34.9786 0136539  14.3750 114.7348 13.21751087597685
0 DELTA 1 DEB
1 21467U 75052FB  24186.97561235  .00000235  00000-0  43856-3 0  9997
2 21467  99.6578 355.5041 0026132 208.4564 318.0346 13.49780424631997
0 DELTA 1 DEB
1 21469U 75052FD  24186.90787437  .00000279  00000-0  11187-2 0  9995
2 21469  99.6453 172.2779 0367667  71.1671 321.1836 12.74664683540441
0 DELTA 1 DEB
1 21470U 75052FE  24187.47114150  .00000258  00000-0  46402-3 0  9992
2 21470  99.6604   3.8392 0098380 233.1564 196.8044 13.49482716630834
0 DELTA 1 DEB
1 21471U 75052FF  24187.37208302  .00000525  00000-0  66256-3 0  9991
2 21471  99.8725 327.4381 0250292 328.6637  54.8371 13.56523764639895
0 DELTA 1 DEB
1 21472U 75052FG  24187.06644124  .00001066  00000-0  12564-2 0  9997
2 21472  99.8416  42.8193 0251157 122.6702 239.8932 13.57742110635093
0 DELTA 1 DEB
1 21473U 75052FH  24187.41711067  .00000712  00000-0  84901-3 0  9990
2 21473  99.8984 356.9422 0241711 314.9985 107.3109 13.59398655636473
0 DELTA 1 DEB
1 21475U 75052FK  24186.75473062  .00000080  00000-0  17753-3 0  9997
2 21475  99.5598   6.5800 0091038 217.4912 156.7386 13.53967824635088
0 DELTA 1 DEB
1 21492U 75052FM  24187.35335505  .00000068  00000-0  21930-3 0  9990
2 21492  99.7354 330.8352 0063050 118.6714 259.7611 13.33547757613841
0 DELTA 1 DEB
1 21493U 75052FN  24187.17628777 -.00003460  00000-0 -13786-1 0  9996
2 21493  99.6172  74.9160 0749794   9.1881 143.4702 12.18881908465506
0 DELTA 1 DEB
1 21496U 75052FR  24187.34794925  .00000147  00000-0  60627-3 0  9992
2 21496  99.8378 136.4975 0341722 159.2154   5.8808 12.82355340551271
0 DELTA 1 DEB
1 21497U 75052FS  24187.59619826  .00000024  00000-0  13701-3 0  9991
2 21497  99.9744 123.7442 0058084 262.2515 274.3173 13.32874474613198
0 DELTA 1 DEB
1 21498U 75052FT  24186.95093316  .00000455  00000-0  15141-2 0  9998
2 21498  99.6461 175.2314 0262010 228.2589 162.0971 12.94604938563951
0 DELTA 1 DEB
1 21499U 75052FU  24186.93700057  .00002884  00000-0  52823-2 0  9990
2 21499  99.6701 342.6354 0149770 197.5853 315.5815 13.36936427599120
0 DELTA 1 DEB
1 21500U 75052FV  24187.14450716  .00002277  00000-0  73380-3 0  9999
2 21500 100.0277 249.2819 0178001 302.0367 111.6775 14.31905943710713
0 DELTA 1 DEB
1 21501U 75052FW  24187.58823874  .00000202  00000-0  93970-3 0  9990
2 21501  99.7579 198.5380 0548373 227.8609 263.1475 12.47444465508614
0 DELTA 1 DEB
1 21504U 75052FZ  24186.63745807  .00000368  00000-0  15741-2 0  9999
2 21504  99.8040 229.7492 0547663 203.7454 324.4689 12.48231076506095
0 DELTA 1 DEB
1 21506U 75052GB  24187.20855903  .00000665  00000-0  17496-2 0  9993
2 21506  99.6423  93.0874 0180092 356.3654 156.7375 13.14502200583011
0 DELTA 1 DEB
1 21512U 75052GH  24187.29030093  .00000176  00000-0  40084-3 0  9991
2 21512  99.9558  86.3299 0037281 117.3266   7.5874 13.40253296613435
0 DELTA 1 DEB
1 21514U 75052GK  24187.46083355  .00000325  00000-0  77238-3 0  9998
2 21514  99.8646 258.4754 0314461  85.2252 290.2099 13.13664710568816
0 DELTA 1 DEB
1 21515U 75052GL  24187.29004052 -.00000163  00000-0 -36080-3 0  9999
2 21515  99.7365 301.7923 0271513  47.6440 331.7034 12.98368116570282
0 DELTA 1 DEB
1 21516U 75052GM  24186.20111091  .00000194  00000-0  47823-3 0  9991
2 21516  99.7223 343.5034 0069651 223.5805 311.2837 13.32587055599279
0 DELTA 1 DEB
1 21523U 75052GU  24187.45482476  .00000257  00000-0  15084-2 0  9998
2 21523  99.5661  20.8517 0717379  34.1962  31.3302 12.05994426421217
0 REX
1 21527U 91045A   24187.55057145  .00000235  00000-0  95312-4 0  9994
2 21527  89.5352 298.5336 0069893 149.5749 210.9528 14.23268941714101
0 SCOUT G-1 R/B
1 21528U 91045B   24187.60586898  .00000480  00000-0  18801-3 0  9992
2 21528  89.5361 298.8531 0068384  35.1519 336.1983 14.26772420716069
0 SCOUT G-1 DEB
1 21529U 91045C   24187.43335635  .00001221  00000-0  40348-3 0  9990
2 21529  89.5862 332.8451 0052544   8.7755 351.4350 14.36753952723263
0 SCOUT G-1 DEB
1 21532U 91045D   24187.39540574  .00001219  00000-0  41603-3 0  9991
2 21532  89.5267 236.4952 0067831 132.2912 241.3863 14.34570460720963
0 GORIZONT 23
1 21533U 91046A   24187.52343398  .00000025  00000-0  00000-0 0  9990
2 21533  14.2687 346.5585 0003613 308.6931  58.4397  0.98907048 39657
0 SL-12 R/B(2)
1 21536U 91046D   24187.52619257 -.00000154  00000-0  00000-0 0  9997
2 21536  13.4358 343.7703 0015977 217.9206 157.6509  1.00934976116624
0 DELTA 1 DEB
1 21542U 75052GW  24186.12409773  .00000264  00000-0  58475-3 0  9991
2 21542 100.3663  46.0537 0049331 275.9686 236.8771 13.38059302617689
0 DELTA 1 DEB
1 21545U 75052GZ  24187.46815425  .00000158  00000-0  41747-3 0  9993
2 21545  99.6172  11.0876 0230112 322.9328  63.6558 13.21925350598831
0 DELTA 1 DEB
1 21546U 75052HA  24187.17610041  .00000524  00000-0  26499-2 0  9992
2 21546  99.5604 274.9859 0608642 321.2256  61.3105 12.27814922481124
0 DELTA 1 DEB
1 21547U 75052HB  24187.60291141  .00000737  00000-0  91385-3 0  9990
2 21547  99.8132  51.2978 0249872 203.9958 225.1853 13.56077000634731
0 DELTA 1 DEB
1 21548U 75052HC  24187.36898582 -.00000184  00000-0 -45078-3 0  9992
2 21548  99.7717 331.5367 0247154 190.2292 228.1593 12.95571651567277
0 DELTA 1 DEB
1 21549U 75052HD  24187.06979593  .00000198  00000-0  62558-3 0  9997
2 21549  99.7989 223.9852 0203541  89.0549 301.4690 13.08711175580049
0 DELTA 1 DEB
1 21550U 75052HE  24186.99025515  .00000204  00000-0  95686-3 0  9992
2 21550  99.8057 197.1937 0551782  27.0307   1.5944 12.45620410503777
0 DELTA 1 DEB
1 21551U 75052HF  24187.26875089  .00000147  00000-0  42670-3 0  9994
2 21551  99.8033 112.9346 0105495 195.8591 318.5550 13.24323805600370
0 NAVSTAR 23 (USA 71)
1 21552U 91047A   24186.06160341 -.00000093  00000-0  00000-0 0  9991
2 21552  56.4136  17.7928 0035999 121.1499  61.5874  1.91857528237704
0 DELTA 1 DEB
1 21565U 75052HK  24187.51453631  .00000690  00000-0  23708-2 0  9995
2 21565  99.8182  37.2126 0371056  86.3710 340.8667 12.80296783543020
0 DELTA 1 DEB
1 21566U 75052HL  24186.74825146  .00000235  00000-0  90906-3 0  9994
2 21566  99.6370 283.3010 0325724 280.7384 237.8152 12.83596759552249
0 DELTA 1 DEB
1 21567U 75052HM  24186.91040462  .00001380  00000-0  15427-2 0  9990
2 21567  99.7856 338.8257 0247951 230.9503 283.9631 13.60657351639167
0 DELTA 1 DEB
1 21568U 75052HN  24187.53291267  .00001077  00000-0  12715-2 0  9991
2 21568  99.9413  16.4650 0244997  90.6735 336.8586 13.58217298631056
0 DELTA 1 DEB
1 21570U 75052HQ  24186.96525722  .00001532  00000-0  82153-2 0  9995
2 21570  99.5244 177.5546 0714948  30.3652  24.4015 12.06986651262041
0 ERS 1
1 21574U 91050A   24187.57312832  .00000363  00000-0  13303-3 0  9992
2 21574  98.7777 179.6829 0031678 215.5519 144.3557 14.38574760727696
0 OSCAR 22 (UoSAT 5)
1 21575U 91050B   24187.43740067  .00000362  00000-0  12442-3 0  9995
2 21575  98.4379 256.5829 0007812 152.0068 208.1543 14.41638940731968
0 ORBCOMM-X
1 21576U 91050C   24187.45873259  .00000509  00000-0  16641-3 0  9996
2 21576  98.3890 254.3888 0004458 140.8654 219.2859 14.42576942732111
0 TUBSAT A
1 21577U 91050D   24187.43324833  .00000255  00000-0  94997-4 0  9993
2 21577  98.4684 257.2491 0005321 229.3399 130.7327 14.40004338730922
0 SARA
1 21578U 91050E   24187.37949437  .00001363  00000-0  31618-3 0  9991
2 21578  98.1961 239.4142 0002233 192.1464 178.1836 14.56563971742588
0 CRRES DEB (CANISTER)
1 21588U 90065D   24187.10486394  .00000476  00000-0  55472-3 0  9994
2 21588  18.0848 124.8702 7023660 270.8732  16.4896  2.53744430108085
0 CRRES DEB (CANISTER)
1 21589U 90065E   24187.29814447  .00001769  00000-0  13370-2 0  9995
2 21589  17.6768 237.3319 6971493  48.9906 353.0529  2.64505156112268
0 CRRES DEB (CANISTER)
1 21590U 90065F   24187.46699571  .00000428  00000-0  55374-3 0  9997
2 21590  20.3403 307.6940 6933393  54.0646 351.9172  2.66520099110583
0 CRRES DEB (CANISTER)
1 21591U 90065G   24187.55114200 -.00000078  00000-0  63801-3 0  9995
2 21591  18.4871 263.6884 7038365  44.5578 358.3887  2.40987256267955
0 CRRES DEB (CANISTER)
1 21594U 90065K   24186.50977250 -.00000290  00000-0  44455-3 0  9994
2 21594  17.3841 355.3845 7060977 312.8922   6.1472  2.44653909290163
0 DELTA 1 DEB
1 21598U 75052HS  24186.72253205  .00000503  00000-0  17325-2 0  9999
2 21598  99.6083 264.4063 0349223 254.5898 261.9686 12.83956256552558
0 DELTA 1 DEB
1 21599U 75052HT  24170.72131194  .00000599  00000-0  21857-2 0  9995
2 21599  99.8167 159.0420 0429390 290.3056 250.6185 12.70971088526688
0 DELTA 1 DEB
1 21601U 75052HV  24186.65161132  .00000223  00000-0  97127-3 0  9991
2 21601  99.8203 250.7541 0545549 139.3040  12.8004 12.49899809507342
0 DELTA 1 DEB
1 21602U 75052HW  24187.59426987  .00002307  00000-0  33084-2 0  9994
2 21602  99.6923 219.5089 0083544 156.6358 335.2712 13.55538804606617
0 ARIANE 40 R/B
1 21610U 91050F   24187.19564891  .00000563  00000-0  18498-3 0  9997
2 21610  98.2889 248.5988 0004282 120.4184 239.7429 14.41914112730695
0 CRRES DEB (CANISTER)
1 21635U 90065M   24185.08383964  .00000842  00000-0  76607-3 0  9991
2 21635  17.8636 163.2142 6898119 170.0497 218.5372  2.72131148112066
0 CRRES DEB (CANISTER)
1 21636U 90065N   24183.38631202  .00000153  00000-0  83123-3 0  9990
2 21636  17.5765 242.3428 7137540 154.1459 273.7016  2.34319094104222
0 CRRES DEB (CANISTER)
1 21637U 90065P   24187.00614524  .00000399  00000-0  53550-3 0  9995
2 21637  17.8338 124.3184 6907354 250.6045  27.2483  2.68778770304353
0 TDRS 5
1 21639U 91054B   24186.38896972 -.00000311  00000-0  00000-0 0  9999
2 21639  14.1599 358.9842 0002903 208.0859 153.4450  1.00278651120574
0 IUS R/B(1)
1 21640U 91054C   24187.55801745  .00002742  00000-0  89026-3 0  9992
2 21640  26.5983  55.8433 6702954 303.0242   9.5708  3.02580005318108
0 IUS R/B(2)
1 21641U 91054D   24187.15260995  .00000011  00000-0  00000-0 0  9994
2 21641  14.5346 338.8672 0033379 330.6848 208.6543  1.00243642 40221
0 COSMOS 2054 DEB
1 21648U 89101G   24186.32023935 -.00000148  00000-0  00000-0 0  9992
2 21648  14.0753 342.7319 0021481 303.2067  64.2969  0.97851023108795
0 INTELSAT 605
1 21653U 91055A   24186.76110832 -.00000120  00000-0  00000-0 0  9990
2 21653  12.8382  22.5677 0003402 130.7220  53.8324  0.99328371119857
0 METEOR 3-5
1 21655U 91056A   24187.35793762 -.00000042  00000-0 -14150-3 0  9996
2 21655  82.5567 282.3792 0014415 116.6341 243.6260 13.17129903580860
0 SL-14 R/B
1 21656U 91056B   24187.60631101  .00000039  00000-0  64607-4 0  9990
2 21656  82.5473 274.0752 0025613  60.4660  52.0795 13.20254634581515
0 SL-12 DEB *
1 21657U 87036M   24187.46601477 -.00039779  00000-0 -29959+0 0  9992
2 21657  64.7794 292.7742 1677241  73.9402 303.9115 10.36829942 61009
0 WESTFORD NEEDLES
1 21660U 63014FG  24187.45871736  .00000077  00000-0  69634-2 0  9996
2 21660  86.6476 353.6063 1635248  79.1573 345.4768  8.78930096  3214
0 COSMOS 2154
1 21666U 91059A   24187.49242100  .00000069  00000-0  57808-4 0  9996
2 21666  82.9069 277.9061 0025748  34.1109 336.6222 13.73440744647146
0 SL-8 R/B
1 21667U 91059B   24187.59155128  .00000102  00000-0  90929-4 0  9990
2 21667  82.9052 251.1546 0019330 274.6787 194.1209 13.75192069649379
0 BS-3B (YURI 3B)
1 21668U 91060A   24187.48551876  .00000010  00000-0  00000-0 0  9996
2 21668  13.3852   1.4288 0007990 142.1178 186.0288  0.98790877122271
0 DELTA 1 DEB
1 21674U 75052JA  24187.24980694  .00007666  00000-0  23151-2 0  9992
2 21674 100.0612 292.4342 0126087  35.1081 325.8329 14.38247320707820
0 DELTA 1 DEB
1 21677U 75052JD  24186.55846839  .00000139  00000-0  55545-3 0  9991
2 21677  99.8858  41.5188 0477743 277.7421 105.6749 12.71650110537428
0 DELTA 1 DEB
1 21678U 75052JE  24187.25872804  .00001317  00000-0  25348-2 0  9997
2 21678 100.0209 118.1423 0358389 162.3178 358.1741 13.17075256582665
0 DELTA 1 DEB
1 21680U 75052JG  24186.59952110  .00000135  00000-0  60796-3 0  9999
2 21680  99.5936  62.9111 0383441  52.5798 337.9566 12.72488515533473
0 DELTA 1 DEB
1 21682U 75052JJ  24187.36221127  .00001765  00000-0  10845-1 0  9992
2 21682  99.4375 346.9826 0869741 149.2745 290.2794 11.76054027411522
0 DELTA 1 DEB
1 21686U 75052JN  24187.07782528  .00008924  00000-0  47621-2 0  9998
2 21686  99.9921 114.3304 0175193  99.3500 262.7519 14.05980886654020
0 IRS 1B
1 21688U 91061A   24187.61885980  .00000367  00000-0  29225-3 0  9998
2 21688  99.3654 168.1004 0025057 135.4716 339.7345 13.97632883569081
0 SL-3 R/B
1 21689U 91061B   24187.48345224  .00000456  00000-0  32923-3 0  9994
2 21689  99.4702   1.2712 0025443 224.0205 135.8933 14.02118854680319
0 SCOUT G-1 DEB
1 21691U 91045E   24187.25740556  .00002145  00000-0  53270-3 0  9996
2 21691  89.7911 271.9275 0017407  69.5975 350.6493 14.51499759737268
0 TITAN 3C TRANSTAGE DEB
1 21692U 65108AF  24185.85008558  .00001523  00000-0  60214-2 0  9995
2 21692  27.8773 241.2177 6188675 157.1063   1.5842  3.55775588138953
0 COSMOS 2155
1 21702U 91064A   24187.18990351  .00000008  00000-0  00000-0 0  9998
2 21702  13.7148 344.4528 0001529 181.8254 193.0519  1.00224264120208
0 SL-12 R/B(2)
1 21703U 91064B   24187.46211205 -.00000095  00000-0  00000-0 0  9991
2 21703  13.8980 345.1109 0002525  92.8595 272.1627  0.99883924113047
0 MOLNIYA 3-41
1 21706U 91065A   24186.12887271 -.00001348  00000-0  00000+0 0  9990
2 21706  63.8571  73.2396 7258694 251.1277  22.8872  2.04354064242201
0 SL-8 DEB
1 21711U 91041D   24187.41481632  .00002291  00000-0  59803-3 0  9990
2 21711  74.0207 344.1001 0011930 300.2298  91.0873 14.49989401737481
0 SCOUT G-1 DEB
1 21712U 91045F   24187.32569269  .00001126  00000-0  44365-3 0  9991
2 21712  89.2644 293.4551 0135284  68.9679 356.1297 14.23624658708453
0 THORAD AGENA D DEB
1 21721U 70025QG  24187.21962868  .00001286  00000-0  15476-2 0  9993
2 21721 100.0895  93.3927 0004521 321.9588 202.8043 13.68853499626693
0 SL-8 DEB
1 21722U 91009BY  24187.58505045  .00000091  00000-0  13953-2 0  9990
2 21722  74.0537 124.8589 0370848 133.0628  38.8858 11.77183534408194
0 COSMOS 397 DEB
1 21723U 71015DW  24186.73431565  .00017323  00000-0  25001-2 0  9990
2 21723  65.6829 306.7603 0307096  83.7395 279.8586 14.48980329666829
0 SL-8 DEB
1 21724U 91009BZ  24187.54417281  .00000141  00000-0  14117-2 0  9991
2 21724  73.9807 293.0497 0206095 270.2178 100.7831 12.20526031459791
0 SL-12 DEB
1 21725U 87036N   24187.03557918  .00006765  00000-0  26219-1 0  9996
2 21725  64.7949 109.8213 0965817 342.5804  14.4050 11.88370913179310
0 ANIK E1
1 21726U 91067A   24186.72688391 -.00000061  00000-0  00000-0 0  9994
2 21726  13.5459  17.6717 0007377 316.6916  48.1019  0.99177278110232
0 ARIANE 44P R/B
1 21727U 91067B   24187.26809828  .00001274  00000-0  27115-2 0  9999
2 21727   4.6741 354.6030 7185821  87.2624 345.7084  2.33286253237822
0 COSMOS 2157
1 21728U 91068A   24187.56068496  .00000054  00000-0  23928-3 0  9996
2 21728  82.5786  52.5956 0004471 330.5746  29.5093 12.63220574510864
0 COSMOS 2158
1 21729U 91068B   24187.59590318  .00000056  00000-0  24570-3 0  9999
2 21729  82.5836  46.3074 0004319 224.9727 194.0214 12.64039577511810
0 COSMOS 2159
1 21730U 91068C   24187.62898303  .00000033  00000-0  11951-3 0  9994
2 21730  82.5834  17.2127 0014672  99.1827 325.8634 12.66015086514197
0 COSMOS 2160
1 21731U 91068D   24187.60406963  .00000042  00000-0  17173-3 0  9992
2 21731  82.5863  39.8785 0008396 184.2268 240.3326 12.64675938512587
0 COSMOS 2161
1 21732U 91068E   24187.60096788  .00000036  00000-0  13494-3 0  9998
2 21732  82.5768  21.5367 0011289 150.0813 275.6424 12.65248148513275
0 COSMOS 2162
1 21733U 91068F   24187.46421278  .00000038  00000-0  15439-3 0  9992
2 21733  82.5880  73.1828 0007688  35.6426 138.1615 12.62411999510132
0 SL-14 R/B
1 21734U 91068G   24187.61148366  .00000023  00000-0  75540-4 0  9998
2 21734  82.5812 176.8714 0108357 168.2276 283.3610 12.54245287500597
0 SL-8 DEB
1 21750U 91009CQ  24187.01822422  .00000241  00000-0  21436-2 0  9992
2 21750  74.0714 183.6970 0128802 323.0517  65.7302 12.29251763490460
0 SL-12 DEB
1 21752U 83127J   24187.35447163  .00008388  00000-0  65778-1 0  9994
2 21752  53.9770 188.8965 0805552 176.0462 184.7278 11.69288692209860
0 DELTA 1 DEB
1 21754U 75052JQ  24187.60751365  .00000171  00000-0  41998-3 0  9996
2 21754 100.0233 113.7961 0074841 222.3599 263.0577 13.34916206602333
0 GORIZONT 24
1 21759U 91074A   24187.46530821 -.00000035  00000-0  00000-0 0  9995
2 21759  14.4829 348.5465 0019699 240.7282 128.0840  0.98442414117950
0 SL-12 R/B(2)
1 21762U 91074D   24187.58607381  .00000081  00000-0  00000-0 0  9998
2 21762  13.9760 346.4846 0004404 159.4223 205.4791  0.99703734112586
0 INTELSAT 601
1 21765U 91075A   24187.26646574 -.00000108  00000-0  00000-0 0  9995
2 21765  12.6796  21.8939 0001840  86.4000  91.4171  0.99595763119284
0 USA 72
1 21775U 91076A   24187.33456387  .00000007  00000-0  00000-0 0  9993
2 21775  63.3424 143.4294 3343257 272.1653  50.6680  5.53396462  3164
0 CRRES DEB (CANISTER)
1 21778U 90065R   24186.99060141  .00001592  00000-0  10508-2 0  9999
2 21778  17.6492 140.6472 7038491 273.8936  15.3423  2.55344073112791
0 COSMOS 2165
1 21779U 91077A   24187.46476662  .00000011  00000-0  13899-5 0  9990
2 21779  82.6080 326.8161 0009934 231.6664 189.3060 12.64890986507015
0 COSMOS 2166
1 21780U 91077B   24187.53000454  .00000021  00000-0  58941-4 0  9999
2 21780  82.6007 340.0807 0002989 349.9907  75.3668 12.63418826505303
0 COSMOS 2167
1 21781U 91077C   24187.49400913  .00000013  00000-0  10294-4 0  9999
2 21781  82.6069 334.8461 0006094 258.0232 163.2980 12.64259286506018
0 COSMOS 2168
1 21782U 91077D   24187.60239437  .00000014  00000-0  19244-4 0  9999
2 21782  82.5983 308.5020 0013499 202.7134 168.2485 12.65506193507790
0 COSMOS 2169
1 21783U 91077E   24187.56599965  .00000010  00000-0 -38009-5 0  9998
2 21783  82.6048 304.3652 0018615 153.9029 206.3007 12.66282651508958
0 COSMOS 2170
1 21784U 91077F   24187.54407637  .00000034  00000-0  13006-3 0  9994
2 21784  82.6096   1.5320 0003408 103.0108 323.9212 12.62558940504276
0 SL-14 R/B
1 21785U 91077G   24187.53309429  .00000013  00000-0  14415-4 0  9997
2 21785  82.5971  93.1029 0038265 179.2172 354.3379 12.55082111495484
0 COSMOS 2172
1 21789U 91079A   24187.05470296  .00000100  00000-0  00000-0 0  9999
2 21789  13.8032 345.5653 0002421  75.9081 288.6674  1.00167728 40227
0 SL-12 R/B(2)
1 21792U 91079D   24187.54646116 -.00000208  00000-0  00000-0 0  9993
2 21792  14.5101 348.0106 0009145 122.0916 136.5578  0.98618461117419
0 COSMOS 2173
1 21796U 91081A   24187.53379508  .00000064  00000-0  49979-4 0  9998
2 21796  82.9569 337.6395 0049526 168.5387 259.8337 13.75648494636559
0 SL-8 R/B
1 21797U 91081B   24187.57112890  .00000110  00000-0  94414-4 0  9998
2 21797  82.9546 309.2003 0039223  72.4165 298.8597 13.77713448638698
0 DMSP 5D-2 F11 (USA 73)
1 21798U 91082A   24187.59017504  .00000215  00000-0  12837-3 0  9992
2 21798  98.7660 217.5645 0013570 149.4728 210.7239 14.17043087684339
0 USA 74
1 21799U 91076C   24187.56189808  .00005538  00000-0  54471-3 0  9993
2 21799  63.3034 242.5554 0902238  59.7505 308.9721 13.49905649  7097
0 EUTE 2-F3
1 21803U 91083A   24187.33605766 -.00000135  00000-0  00000-0 0  9993
2 21803  14.6019   6.9148 0003798 128.1768  93.2903  0.99301329114496
0 ATLAS 2 CENTAUR R/B
1 21804U 91083B   24185.06564891 -.00000040  00000-0  56225-2 0  9992
2 21804  16.6153 118.5582 7355262 268.9188  14.5119  1.91162821227565
0 USA 75
1 21805U 91080B   24187.42138939 -.00000067  00000-0  00000-0 0  9999
2 21805  14.3904 350.6148 0006966 106.8998 247.2363  0.99184516 18643
0 IUS R/B(1)
1 21806U 91080C   24186.18351699 -.00000042  00000-0  47958-3 0  9991
2 21806  26.6730 117.6773 7129328 208.3335  80.2056  2.38048406 46052
0 IUS R/B(2)
1 21807U 91080D   24186.69082211  .00000065  00000-0  00000-0 0  9997
2 21807  13.9489 348.1564 0018076 335.2772  24.6447  1.01276218 18752
0 USA 76
1 21808U 91076D   24187.50684265  .00004407  00000-0  45222-3 0  9993
2 21808  63.3065 247.6818 0901885  61.5767 307.3146 13.49049318  9604
0 USA 77
1 21809U 91076E   24187.55385842  .00002991  00000-0  31082-3 0  9993
2 21809  63.3048 247.1533 0903706  61.4386 307.4572 13.48861422  7974
0 TELECOM 2A
1 21813U 91084A   24187.60934884 -.00000013  00000-0  00000-0 0  9996
2 21813  14.2460  11.6044 0004604 140.6497 249.9510  0.98949013117052
0 INMARSAT 2-F3
1 21814U 91084B   24187.12789554 -.00000091  00000-0  00000-0 0  9992
2 21814  13.5254  17.7881 0017583  74.9253 292.5534  0.96061438116335
0 ARIANE 44L R/B
1 21815U 91084C   24187.18070741  .00002603  00000-0  47988-2 0  9998
2 21815   3.9787  96.7047 7188660  23.5115 357.1263  2.33501057272205
0 ARIANE 44L DEB (SPELDA)
1 21818U 91084D   24187.32296290  .00004733  00000-0  29394-2 0  9993
2 21818   3.6142 199.2354 6017521 177.1023 189.3183  3.94671331335960
0 INTERCOSMOS 25
1 21819U 91086A   24187.43262402  .00001219  00000-0  24038-3 0  9993
2 21819  82.6058 319.3712 1500212 354.0153   4.4596 12.08914220422601
0 SL-14 R/B
1 21820U 91086B   24187.56990251  .00000455  00000-0  91980-4 0  9991
2 21820  82.5618  38.2253 1567325 291.1908  52.9030 11.95161950414070
0 RADUGA 28
1 21821U 91087A   24187.51754468 -.00000374  00000-0  00000-0 0  9996
2 21821  13.8971 346.2598 0008114 152.1001  81.1038  1.00324151119184
0 SL-12 R/B(2)
1 21824U 91087D   24187.31229213 -.00000206  00000-0  00000-0 0  9996
2 21824  14.8068 349.2930 0016159  74.5126 147.2659  0.98020752116491
0 SL-14 DEB
1 21826U 91086C   24187.47169513  .00055421  00000-0  21312-2 0  9999
2 21826  82.5362 351.4700 0324199 261.7628  94.6711 14.89028775554134
0 STTW-5
1 21833U 91088A   24187.10292772 -.00000018  00000-0  00000-0 0  9995
2 21833  31.4434 239.2670 6524770 302.5229  10.6585  2.27645152343022
0 MAGION 3
1 21835U 91086E   24187.56814230  .00004182  00000-0  77646-3 0  9992
2 21835  82.5359 263.0746 1473574 211.6866 138.6723 12.16098966426844
0 COSMOS 2177 (GLONASS)
1 21853U 92005A   24184.55720480 -.00000053  00000-0  00000+0 0  9993
2 21853  64.4880  94.5500 0007931 200.1682 348.0448  2.13101715252385
0 COSMOS 2178 (GLONASS)
1 21854U 92005B   24183.71730376 -.00000050  00000-0  00000-0 0  9994
2 21854  64.4918  94.6282 0031136  29.6826 155.3588  2.13105685252287
0 COSMOS 2179 (GLONASS)
1 21855U 92005C   24185.32912508 -.00000053  00000-0  00000-0 0  9996
2 21855  64.4916  94.5852 0012346 237.6779 285.7686  2.13102628252133
0 SL-12 R/B(2)
1 21858U 92005F   24186.53568685 -.00000046  00000-0  00000-0 0  9998
2 21858  64.4984  94.0236 0006932  44.8023 141.2067  2.13216713241167
0 SL-8 DEB
1 21861U 91009CA  24187.51810865  .00000090  00000-0  91498-3 0  9996
2 21861  74.0216 222.2386 0136397  87.4122  34.7205 12.24985155489608
0 USA 78
1 21873U 92006A   24186.91924171 -.00000265  00000-0  00000-0 0  9997
2 21873  14.5965   7.9367 0002371 343.1158 224.9231  0.99042021 18136
0 COSMOS 2180
1 21875U 92008A   24187.61671534  .00000085  00000-0  74391-4 0  9998
2 21875  82.9265  28.8461 0038223 150.2174 271.3851 13.73865594623115
0 SL-8 R/B
1 21876U 92008B   24187.56498502  .00000034  00000-0  18936-4 0  9992
2 21876  82.9272   2.9491 0035739  45.9092  14.5549 13.75833777625245
0 IABS R/B
1 21877U 92006C   24186.96750540 -.00000189  00000-0  00000-0 0  9998
2 21877   8.4825 326.6044 0645151  84.0311 283.3676  1.10787041 19989
0 OSCAR 30 DEB
1 21878U 85066H   24187.57449649  .00001330  00000-0  19397-2 0  9999
2 21878  90.1544  58.2941 0151331  73.5745 350.2790 13.49828071902881
0 NAVSTAR 24 (USA 79)
1 21890U 92009A   24182.33301326  .00000111  00000-0  00000-0 0  9991
2 21890  54.2255 192.1841 0047529  48.6048  30.2148  1.91828773232346
0 DELTA 2 R/B(1)
1 21891U 92009B   24187.19344046  .00003368  00000-0  30720-3 0  9999
2 21891  19.9975   9.3104 0042292 234.2003 125.4480 14.88125563728344
0 SUPERBIRD B1
1 21893U 92010A   24187.39933737 -.00000314  00000-0  00000-0 0  9990
2 21893  14.2167  11.4737 0016672 114.0990  88.7462  0.99058542117269
0 INSAT 2R (ARABSAT 1C)
1 21894U 92010B   24187.18591243 -.00000205  00000-0  00000-0 0  9999
2 21894  13.8116  16.7233 0024084 255.7267  79.8170  0.98685845117217
0 COSMOS 2181
1 21902U 92012A   24187.57637041  .00000064  00000-0  53204-4 0  9991
2 21902  82.9439 112.8684 0027034 256.0783 277.8996 13.72484186618702
0 SL-8 R/B
1 21903U 92012B   24187.47085718  .00000095  00000-0  82911-4 0  9990
2 21903  82.9364  75.9658 0043928 113.7427  59.1113 13.74657796621082
0 METEOSAT 5 AKM
1 21904U 91015E   24186.54477651 -.00000001  00000-0  00000-0 0  9994
2 21904  12.8906 343.0795 0156295 216.7045 142.2331  1.00129080109230
0 SL-14 DEB
1 21905U 91086F   24187.59121435  .00099657  00000-0  67086-2 0  9998
2 21905  82.4632 142.7655 0513225  12.3539 348.9686 14.37530654535459
0 GALAXY 5
1 21906U 92013A   24187.02861247 -.00000108  00000-0  00000-0 0  9995
2 21906  12.7194  23.3477 0017000  81.5483 104.2745  0.99286191 39175
0 ATLAS 1 CENTAUR R/B
1 21907U 92013B   24187.41529737 -.00000053  00000-0  00000-0 0  9993
2 21907  18.9539 164.8068 6932667 212.2436 353.3282  2.25609374266354
0 DELTA 1 DEB
1 21910U 75052JR  24187.00855942  .00000165  00000-0  69197-3 0  9994
2 21910  99.6850 271.2245 0330388 150.7738  24.3343 12.80439849532851
0 CZ-4 DEB
1 21911U 90081CH  24187.02212356  .00001224  00000-0  45985-3 0  9998
2 21911  98.3920 208.1199 0051509 206.8271 182.4442 14.32571208748426
0 COSMOS 1934 DEB
1 21912U 88023C   24187.46873861  .00000624  00000-0  53948-3 0  9995
2 21912  82.9551 259.3936 0039648  77.1053 295.5987 13.84477654703203
0 SL-14 DEB
1 21913U 78100AR  24187.11500084  .00000284  00000-0  34223-2 0  9993
2 21913  82.5450  59.5327 0019659 218.6028 297.8710 11.99793362422855
0 DELTA 1 DEB
1 21914U 75052JS  24187.51838169  .00000099  00000-0  70543-3 0  9999
2 21914  99.4477  13.4535 0633856  48.5512  15.1479 12.13642557440085
0 SL-8 DEB
1 21918U 91009CB  24187.38511250  .00000134  00000-0  13502-2 0  9998
2 21918  74.0827 359.7450 0127472 122.6662 319.3783 12.22170952485273
0 SL-8 DEB
1 21919U 91009CC  24187.51462611  .00000116  00000-0  18320-2 0  9993
2 21919  74.0624 208.8116 0356777 215.4579 301.0622 11.75074279425009
0 GORIZONT 25
1 21922U 92017A   24186.95014705  .00000029  00000-0  00000-0 0  9998
2 21922  14.0087 347.7477 0028093 102.0437 242.3418  0.99842266117825
0 SL-12 R/B(2)
1 21925U 92017D   24186.72070530  .00000033  00000-0  00000-0 0  9999
2 21925  13.6069 345.8709 0021328  60.9716 302.7613  1.01084317118116
0 NAVSTAR 25 (USA 80)
1 21930U 92019A   24185.51011810 -.00000112  00000-0  00000+0 0  9997
2 21930  55.5051 330.0273 0029581 330.3596  30.5786  1.87660477228041
0 DELTA 1 DEB
1 21933U 75052JT  24186.78989503  .00000452  00000-0  10851-2 0  9995
2 21933  99.3378 309.3067 0163400 212.8770 306.3436 13.23102375578000
0 DELTA 1 DEB
1 21934U 75052JU  24187.37301515  .00000227  00000-0  79827-3 0  9992
2 21934  99.6516 149.4959 0291885 172.0953 343.2741 12.92846946551543
0 SL-8 DEB
1 21936U 91009CD  24187.15863528 -.00000058  00000-0 -50513-3 0  9992
2 21936  74.0599 203.7406 0262049  96.4057 340.9556 12.01142151423259
0 COSMOS 2184
1 21937U 92020A   24187.50170168  .00000073  00000-0  62559-4 0  9996
2 21937  82.9330 281.6663 0032612 334.4544  36.1472 13.73286096614652
0 SL-8 R/B
1 21938U 92020B   24187.57646628  .00000081  00000-0  68778-4 0  9991
2 21938  82.9294 248.3434 0028663 203.6999 265.3257 13.75425852616982
0 TELECOM 2B
1 21939U 92021A   24186.72366407 -.00000113  00000-0  00000-0 0  9990
2 21939  14.2837   8.9514 0020781  90.4215 265.9891  0.99517815110295
0 INMARSAT 2-F4
1 21940U 92021B   24186.46106543 -.00000122  00000-0  00000-0 0  9996
2 21940  11.5043  19.3037 0009589 133.7107 236.6332  0.97943598 43677
0 ARIANE 44L+ DEB (SPELDA)
1 21942U 92021D   24187.34791299  .00005483  00000-0  36174-2 0  9991
2 21942   4.3082 247.2770 5977835 345.9068   2.9742  4.00003575369359
0 SL-8 DEB
1 21943U 91009CE  24187.57887009 -.00000057  00000-0 -39630-3 0  9992
2 21943  73.9559 304.6680 0137308 356.0714  15.8539 12.19240757483288
0 CRRES DEB (CANISTER)
1 21948U 90065S   24187.49820645  .00008080  00000-0  16317-2 0  9990
2 21948  17.7355 215.5505 6272914 273.0618  21.7146  3.64259189337332
0 USA 81
1 21949U 92023A   24187.55916731  .00000297  00000-0  10355-3 0  9995
2 21949  85.0088 124.5497 0002052 111.0266 249.1146 14.31919583  7170
0 SL-8 DEB
1 21955U 91009CF  24186.56994017 -.00000398  00000-0 -41371-2 0  9993
2 21955  74.2975 230.9005 0162363 334.7373 177.3618 12.08219292469219
0 COSMOS 839 DEB *
1 21957U 76067BV  24187.41081962  .00000240  00000-0  56244-3 0  9993
2 21957  65.4628  72.9678 0734938 226.1589 127.6388 12.64923952506923
0 SL-8 DEB
1 21958U 91009CG  24186.99055544  .00000010  00000-0  23153-3 0  9994
2 21958  73.9649  28.9426 0133862  74.0611  78.9179 12.16774815480159
0 SL-8 DEB
1 21959U 91009CH  24187.40172395  .00000045  00000-0  56808-3 0  9997
2 21959  73.9699 347.5984 0130686  17.8465   8.7940 12.18834003481681
0 PALAPA B4
1 21964U 92027A   24187.41694736 -.00000158  00000-0  00000-0 0  9999
2 21964  12.5214  22.2705 0003940  67.6895 149.5392  0.99952582 40077
0 DELTA 2 R/B(1)
1 21965U 92027B   24187.52625628  .00000892  00000-0  21903-3 0  9998
2 21965  19.6742 139.3976 1365825 133.1720 239.1184 12.20573674428873
0 DELTA 2 R/B(2)
1 21966U 92027C   24187.09666531 -.00000122  00000-0  00000-0 0  9998
2 21966  22.0513 229.2756 6439205 169.3842 216.7997  2.05329445241141
0 DELTA 1 DEB
1 21969U 75052JV  24187.04420269  .00000677  00000-0  12755-2 0  9997
2 21969  99.0100 226.0497 0111210 355.7353  33.1007 13.39511587604417
0 THOR ABLESTAR DEB *
1 21970U 61015ML  24185.99856550  .00085428  00000-0  10243-2 0  9998
2 21970  65.9653  45.4608 0081576 141.3041 219.3999 15.56426920739802
0 DELTA 1 DEB
1 21972U 75052JW  24187.26513508  .00000122  00000-0  46662-3 0  9994
2 21972  99.6617 110.7296 0334088 255.2899 263.7017 12.91870433522466
0 COSMOS 2187
1 21976U 92030A   24187.58561219 -.00000021  00000-0 -26548-4 0  9992
2 21976  74.0048 346.8552 0050457 339.8329  87.9896 12.55717737470914
0 COSMOS 2188
1 21977U 92030B   24187.53581716 -.00000011  00000-0  33348-4 0  9996
2 21977  74.0046 293.4790 0058575 270.9589  99.7020 12.57533635473015
0 COSMOS 2189
1 21978U 92030C   24187.56715731  .00000011  00000-0  16907-3 0  9996
2 21978  74.0039  37.1484 0040337  35.6854  28.6212 12.54010537468936
0 COSMOS 2190
1 21979U 92030D   24187.50395486  .00000001  00000-0  11033-3 0  9996
2 21979  74.0034  88.0707 0031139  98.7086  75.9971 12.52267598466857
0 COSMOS 2191
1 21980U 92030E   24187.57926736 -.00000020  00000-0 -30273-4 0  9994
2 21980  74.0052 312.2559 0017958  98.8261 274.4001 12.44556407457632
0 COSMOS 2192
1 21981U 92030F   24187.58058806  .00000012  00000-0  19435-3 0  9995
2 21981  74.0019 250.6292 0009027 350.2424 118.2634 12.46676961460427
0 COSMOS 2193
1 21982U 92030G   24187.31786094 -.00000028  00000-0 -78224-4 0  9995
2 21982  74.0023 141.9310 0021474 163.6773 307.6196 12.50439055464763
0 COSMOS 2194
1 21983U 92030H   24187.54203747 -.00000001  00000-0  98161-4 0  9992
2 21983  74.0001 198.9344 0017528 259.8744 222.9577 12.48458627462493
0 SL-8 R/B
1 21984U 92030J   24187.59369696 -.00000077  00000-0 -57826-3 0  9990
2 21984  73.9991 224.2129 0123300 137.9015 338.2700 12.22252310431697
0 DELTA 1 DEB
1 21985U 75052JX  24187.04540066  .00006345  00000-0  48791-2 0  9990
2 21985  99.5355  21.9922 0027152 292.5861 219.8197 13.93253657605785
0 THOR ABLESTAR DEB
1 21986U 61015MM  24187.59990834  .00000272  00000-0  20595-3 0  9993
2 21986  66.8759 142.9509 0098465 197.1131 338.2564 14.05641848652852
0 NSS K (INTELSAT K)
1 21989U 92032A   24187.05813194 -.00000173  00000-0  00000-0 0  9990
2 21989  14.3965  17.4044 0077855 347.4915 275.6699  0.97182511125561
0 COSMOS 2195
1 22006U 92036A   24187.58533492  .00000099  00000-0  87371-4 0  9999
2 22006  82.9330 226.0284 0038450  99.4424   9.5195 13.75081938606335
0 SL-8 R/B
1 22007U 92036B   24187.46641731  .00000166  00000-0  14950-3 0  9990
2 22007  82.9315 181.0386 0028981 303.2731  56.5651 13.78138844537892
0 USA 82
1 22009U 92037A   24187.58439847 -.00000090  00000-0  00000-0 0  9994
2 22009  13.7498  14.6432 0007545  44.1291 175.3682  0.98810522 18117
0 IABS R/B
1 22011U 92037C   24186.68122469  .00000050  00000-0  00000-0 0  9991
2 22011  12.8023 339.2443 0017552  89.8793 270.3409  1.01646921 19067
0 NAVSTAR 26 (USA 83)
1 22014U 92039A   24186.49902649 -.00000007  00000-0  00000-0 0  9994
2 22014  55.3322 143.8509 0005240 278.1269  81.7621  1.87912114 61867
0 DELTA 2 R/B(1)
1 22015U 92039B   24187.14311395  .00146665  00000-0  10240-2 0  9999
2 22015  20.7039 120.4771 0015249 304.5299  55.3712 15.72327006783811
0 SL-8 DEB
1 22025U 91009CJ  24186.61595583 -.00000019  00000-0 -21597-4 0  9993
2 22025  73.9406 302.1547 0143543 316.0726  55.5757 12.31589068498029
0 INSAT 2A
1 22027U 92041A   24187.18938137 -.00000021  00000-0  00000-0 0  9995
2 22027  14.6474 357.2722 0006086 244.9409 113.7653  1.00212053116919
0 EUTE 2-F4
1 22028U 92041B   24186.95781858 -.00000111  00000-0  00000-0 0  9996
2 22028  14.4133  10.6654 0005435 225.8186 311.2475  0.99075898 39698
0 COSMOS 2197
1 22034U 92042A   24187.45532317  .00000004  00000-0 -36633-4 0  9990
2 22034  82.5960 323.7266 0013603  94.5443 326.9310 12.64216953475351
0 COSMOS 2198
1 22035U 92042B   24187.54701247  .00000026  00000-0  83858-4 0  9995
2 22035  82.5986 347.7197 0007117 125.1619 235.0140 12.62644572473605
0 COSMOS 2199
1 22036U 92042C   24187.58121627  .00000040  00000-0  16414-3 0  9997
2 22036  82.5999  12.3158 0012066 139.6501 283.0222 12.61021330471546
0 COSMOS 2200
1 22037U 92042D   24187.49314903  .00000012  00000-0  66637-5 0  9992
2 22037  82.5897 329.9339 0008957 123.1154 300.4675 12.63294718474349
0 COSMOS 2201
1 22038U 92042E   24187.56578921  .00000029  00000-0  10567-3 0  9990
2 22038  82.5918 353.3410 0009613 126.7629 297.6111 12.61755322472555
0 COSMOS 2202
1 22039U 92042F   24187.54360633  .00000017  00000-0  36790-4 0  9992
2 22039  82.5978 347.0648 0009321 117.7975 306.0418 12.62633467473591
0 SL-14 R/B
1 22040U 92042G   24187.49704037  .00000010  00000-0 -13613-6 0  9993
2 22040  82.6049  94.0219 0042330  29.4769 143.7630 12.55339240465129
0 GORIZONT 26
1 22041U 92043A   24187.52280853  .00000042  00000-0  00000-0 0  9998
2 22041  14.2422 349.8531 0032275 250.0782 112.2246  0.99241147116410
0 SL-12 R/B(2)
1 22044U 92043D   24187.51430147 -.00000101  00000-0  00000-0 0  9990
2 22044  14.9814 351.6093 0026789 173.7533  49.8054  0.97830489112595
0 GEOTAIL
1 22049U 92044A   24190.82532173 -.00001505  00000-0  00000-0 0  9995
2 22049  47.4361  20.5794 5406823 240.1704 359.9633  0.19246944 14403
0 COSMOS 2206 (GLONASS)
1 22056U 92047A   24183.45675476 -.00000076  00000-0  00000-0 0  9993
2 22056  64.5922 327.2535 0010286 246.3447 117.7032  2.13107448248374
0 COSMOS 2204 (GLONASS)
1 22057U 92047B   24184.77998788 -.00000084  00000-0  00000-0 0  9993
2 22057  64.6066 327.3946 0015305 344.2210   2.1748  2.13103368248306
0 COSMOS 2205 (GLONASS)
1 22058U 92047C   24184.96924486 -.00000085  00000-0  00000-0 0  9990
2 22058  64.6005 327.3282 0018084 224.6318 316.2107  2.13102888248315
0 SL-12 R/B(2)
1 22061U 92047F   24183.88981303 -.00000079  00000-0  00000-0 0  9998
2 22061  64.5763 326.3232 0002126 292.1870  73.6391  2.13332418248645
0 SL-12 R/B(AUX MOTOR)
1 22066U 92047G   24186.92521270  .00000445  00000-0  56030-3 0  9997
2 22066  64.7859  38.1287 5692500 184.1974 167.5906  4.36370318494722
0 TOPEX/POSEIDON
1 22076U 92052A   24187.45214308 -.00000058  00000-0  12537-4 0  9990
2 22076  66.0389 170.8763 0008248 268.2113 261.5488 12.81065837492312
0 OSCAR 23 (KITSAT 1)
1 22077U 92052B   24187.59902779 -.00000056  00000-0  22673-4 0  9992
2 22077  66.0864 331.8403 0015759 267.3592 168.0845 12.86577594498145
0 S80/T
1 22078U 92052C   24187.59444649 -.00000046  00000-0  63421-4 0  9995
2 22078  66.0864 319.8377 0017049 263.7595  96.1482 12.86825788498676
0 ARIANE 42P R/B
1 22079U 92052D   24187.61786330 -.00000074  00000-0 -60604-4 0  9997
2 22079  66.0665 334.6654 0076433 266.8448 168.2842 12.77923250488462
0 COSMOS 2208
1 22080U 92053A   24187.59246201  .00000224  00000-0  94764-4 0  9994
2 22080  74.0419 129.4504 0012084 135.7395 224.4724 14.31102530664823
0 SL-8 R/B
1 22081U 92053B   24187.35061438  .00000383  00000-0  14508-3 0  9999
2 22081  74.0439  50.8119 0034841 109.9989 250.4920 14.34169564667386
0 OPTUS B1 (AUSSAT B1)
1 22087U 92054A   24187.28746186 -.00000019  00000-0  00000-0 0  9994
2 22087  12.0015  29.1158 0012710 100.3994 101.4290  0.99205565127641
0 OPTUS B1 R/B(STAR 63F)
1 22089U 92054C   24186.79055931 -.00000025  00000-0  44534-3 0  9992
2 22089  22.9883 108.0381 7240124 245.5997  26.4491  2.23739395256975
0 SATCOM C4
1 22096U 92057A   24187.10743804  .00000031  00000-0  00000-0 0  9995
2 22096  13.0598  21.2086 0001871  49.0624 300.4040  0.99016129117858
0 DELTA 2 R/B(1)
1 22097U 92057B   24187.11855068  .00000085  00000-0  61142-3 0  9999
2 22097  25.2009  22.4065 0506929 172.3597 353.4600 10.92085189271716
0 DELTA 2 R/B(2)
1 22098U 92057C   24187.24455405 -.00000131  00000-0  00000-0 0  9991
2 22098  19.7287 122.8538 6768084 159.5447 358.7107  2.17553294253065
0 ARIANE 3 DEB
1 22101U 88063G   24184.70715479  .00010435  00000-0  48834-2 0  9992
2 22101   7.8474  56.6336 4309967 287.9239  30.5793  6.66395417656679
0 NAVSTAR 27 (USA 84)
1 22108U 92058A   24186.40347204  .00000073  00000-0  00000-0 0  9992
2 22108  54.6672 191.1229 0015068  31.5856 328.5289  1.87561608229651
0 DELTA 2 R/B(1)
1 22109U 92058B   24186.95515159  .00002485  00000-0  29056-3 0  9993
2 22109  19.7832  41.4596 0034475 128.0439 232.3091 14.76775700710715
0 COSMOS 2209
1 22112U 92059A   24187.41346535 -.00000113  00000-0  00000-0 0  9992
2 22112  14.0672 347.9236 0006110 324.4609  11.4526  1.00384478116473
0 SL-12 R/B(2)
1 22115U 92059D   24186.31954317 -.00000300  00000-0  00000-0 0  9994
2 22115  14.2747 348.7287 0008200 315.0542  42.3165  0.99796444115164
0 HISPASAT 1A
1 22116U 92060A   24186.95807964 -.00000143  00000-0  00000-0 0  9997
2 22116  13.7023  15.3689 0001017  66.6264 107.1032  0.99314520112428
0 SATCOM C3
1 22117U 92060B   24187.19529891 -.00000110  00000-0  00000-0 0  9999
2 22117  13.1487  24.8744 0023810  13.5784 350.1043  0.97011524114865
0 SL-8 DEB
1 22132U 91009CR  24187.54367478  .00000090  00000-0  10198-2 0  9995
2 22132  74.0576 112.5530 0141798 309.5121 226.7287 12.16896547480565
0 FREJA
1 22161U 92064A   24187.56374479  .00000964  00000-0  37275-3 0  9996
2 22161  62.9853 275.7250 0785527 176.9717 183.6493 13.31936651539130
0 HELLAS-SAT 1 (DFS 3)
1 22175U 92066A   24186.46045626 -.00000272  00000-0  00000-0 0  9996
2 22175  13.8634  12.2322 0004365 121.6503 252.6120  0.99730313113448
0 DELTA 2 R/B(1)
1 22176U 92066B   24187.49152031  .00000068  00000-0  17089-3 0  9990
2 22176  25.0771 160.6819 0965581  93.6902  60.0714 10.85569773259652
0 DELTA 2 R/B(2)
1 22177U 92066C   24187.37410595 -.00000171  00000-0  00000-0 0  9998
2 22177  19.5989 311.7294 6858352 201.3844 196.8293  2.18733765 34139
0 MOLNIYA 3-42
1 22178U 92067A   24186.40420593  .00000062  00000-0  00000-0 0  9990
2 22178  64.6645 135.9496 6614385 255.0493  27.8227  2.20434931 96541
0 SL-6 R/B(2)
1 22181U 92067D   24185.18977345  .00000453  00000-0  00000-0 0  9994
2 22181  64.1602 228.5134 6717286 260.9622  23.4814  2.00807166229111
0 COSMOS 2211
1 22182U 92068A   24187.63345520  .00000046  00000-0  19476-3 0  9990
2 22182  82.5947  55.9407 0007386 337.1561  89.1956 12.64036224462844
0 COSMOS 2212
1 22183U 92068B   24187.59970427  .00000045  00000-0  19233-3 0  9996
2 22183  82.5884  62.8168 0002677  10.4236 349.6911 12.63117687461749
0 COSMOS 2213
1 22184U 92068C   24187.46069774  .00000042  00000-0  17531-3 0  9993
2 22184  82.5994  80.1003 0002408 326.0769 208.1383 12.62582025461138
0 COSMOS 2214
1 22185U 92068D   24187.49176212  .00000027  00000-0  93519-4 0  9997
2 22185  82.5915  86.4870 0008329 330.4374 202.4622 12.61573063459908
0 COSMOS 2215
1 22186U 92068E   24187.50672246  .00000024  00000-0  74157-4 0  9992
2 22186  82.6008 104.3422 0012722 352.1348   7.9541 12.60927884459170
0 COSMOS 2216
1 22187U 92068F   24187.42551738  .00000038  00000-0  15179-3 0  9999
2 22187  82.5955  77.1586 0004814 323.3746  36.7016 12.62555489461073
0 SL-14 R/B
1 22188U 92068G   24187.47723365  .00000017  00000-0  45317-4 0  9997
2 22188  82.5977 181.8894 0044151 271.6499 203.0297 12.54909019452333
0 SL-6 R/B(2)
1 22192U 92069D   24187.45243296 -.00000525  00000-0  00000-0 0  9992
2 22192  67.9180 146.4425 6726856  14.4505 147.4058  2.02811993229900
0 LAGEOS 2
1 22195U 92070B   24187.31404911 -.00000009  00000-0  00000-0 0  9992
2 22195  52.6794 356.5374 0137520 235.6555 295.0104  6.47293410749339
0 IRIS R/B
1 22196U 92070D   24187.30245067  .00097621  61689-5  13132-2 0  9999
2 22196  41.1349  37.5928 0969365  63.1195 306.5314 13.76830073289279
0 LAGEOS 2 AKM (MAGE 1S)
1 22197U 92070E   24186.87183780 -.00000009  00000-0  00000-0 0  9992
2 22197  52.6756 353.4485 0136742 238.5860 120.1263  6.47397925751843
0 SL-8 DEB
1 22198U 91009CS  24187.28311272 -.00000001  00000-0  11733-3 0  9999
2 22198  73.9170 298.9974 0146725  11.6473  18.7011 12.30590556496650
0 GALAXY 7
1 22205U 92072A   24187.48184524 -.00000367  00000-0  00000-0 0  9996
2 22205  14.2646   8.5288 0007797  61.4610 159.1463  0.99706877109782
0 COSMOS 2218
1 22207U 92073A   24187.61932929  .00000067  00000-0  55927-4 0  9992
2 22207  82.9224 302.4986 0032732 176.1297 195.2407 13.72989392587296
0 SL-8 R/B
1 22208U 92073B   24187.57845178  .00000093  00000-0  80622-4 0  9996
2 22208  82.9183 267.8965 0035395  56.5653  63.1609 13.75300600589704
0 EKRAN 20
1 22210U 92074A   24186.94987021 -.00000107  00000-0  00000-0 0  9999
2 22210  14.1115 349.5295 0006733 163.1871 185.2623  1.00327653 40227
0 SL-12 R/B(2)
1 22213U 92074D   24187.05400677 -.00000026  00000-0  00000-0 0  9992
2 22213  13.7318 348.1160 0024255 132.1049 226.3005  1.01144224118564
0 COSMOS 2219
1 22219U 92076A   24187.52837204 -.00000031  00000-0  85604-5 0  9996
2 22219  71.0596 217.5929 0016356  49.8046 310.4504 14.13880825631842
0 SL-16 R/B
1 22220U 92076B   24187.63360103  .00000326  00000-0  18717-3 0  9994
2 22220  71.0004  37.5014 0014561 302.8800 113.2435 14.16668930635142
0 SL-16 DEB
1 22221U 92076C   24187.47672157  .00000173  00000-0  19194-3 0  9992
2 22221  71.0421 193.8107 0181138  80.1040  38.5415 13.77388920589220
0 SL-16 DEB
1 22222U 92076D   24187.33727872  .00000045  00000-0  84187-4 0  9996
2 22222  70.9979  45.3451 0215853 357.9310   2.0873 13.70420755581140
0 SL-16 DEB
1 22223U 92076E   24187.59300700  .00000174  00000-0  19483-3 0  9991
2 22223  71.0372 247.4704 0193334 169.1950 307.0726 13.75844490587320
0 SL-16 DEB
1 22224U 92076F   24187.52506698  .00000072  00000-0  10646-3 0  9998
2 22224  70.9899 226.0280 0197160 275.8489  82.0169 13.74748698586623
0 NAVSTAR 28 (USA 85)
1 22231U 92079A   24187.28569553 -.00000018  00000-0  00000-0 0  9992
2 22231  55.3251 138.3382 0026050 347.3819  12.5006  1.89108618 48670
0 COSMOS 2221
1 22236U 92080A   24187.57005603  .00002863  00000-0  28005-3 0  9999
2 22236  82.5065 143.5918 0017486  85.2565 275.0651 14.91892421689371
0 SL-14 R/B
1 22237U 92080B   24187.58962745  .00000533  00000-0  68267-4 0  9997
2 22237  82.5108 241.1390 0020663  63.4961 296.8368 14.79375196703901
0 SL-6 R/B(2)
1 22241U 92081D   24186.99395237 -.00000518  00000-0  00000-0 0  9994
2 22241  68.7127  59.9588 6309451  37.2347 353.2707  2.03442725234838
0 GORIZONT 27
1 22245U 92082A   24186.62375694  .00000095  00000-0  00000-0 0  9993
2 22245  14.1478 349.2673 0010334  26.9569 336.1146  1.00179510119980
0 SL-12 R/B(2)
1 22248U 92082D   24186.95712240 -.00000071  00000-0  00000-0 0  9999
2 22248  15.0234 352.2774 0011407 103.4061  88.7135  0.98022406113146
0 SUPERBIRD A1
1 22253U 92084A   24186.32589582 -.00000260  00000-0  00000-0 0  9999
2 22253  11.6982  27.0703 0014762 145.4402 208.0122  0.99121884114746
0 HIMAWARI 3 AKM
1 22266U 84080E   24187.58333765 -.00000269  00000-0  00000-0 0  9998
2 22266  10.7842 320.9675 0136184  96.7674 171.0219  0.99743634110385
0 COSMOS 2224
1 22269U 92088A   24187.18842412 -.00000047  00000-0  00000-0 0  9992
2 22269  13.9383 353.0838 0004925 212.3323 145.4537  1.00249944114947
0 SL-12 R/B(2)
1 22272U 92088D   24187.63347973 -.00000247  00000-0  00000-0 0  9990
2 22272  14.0248 353.5212 0012439 141.7631 111.3468  1.00046762 40160
0 NAVSTAR 29 (USA 87)
1 22275U 92089A   24185.88417102  .00000017  00000-0  00000-0 0  9995
2 22275  54.8850 152.9043 0067510  69.8870 292.7233  1.88246672223459
0 DELTA 2 R/B(1)
1 22276U 92089B   24187.29258221  .00003577  00000-0  31029-3 0  9990
2 22276  20.2835 169.6260 0056911  99.6999 260.9860 14.89837585685125
0 COSMOS 2226
1 22282U 92092A   24187.59877481 -.00000024  00000-0 -47800-4 0  9990
2 22282  73.6260 339.0519 0029645 326.1581 104.8501 12.41286495428908
0 SL-14 R/B
1 22283U 92092B   24187.62110091 -.00000036  00000-0 -12545-3 0  9992
2 22283  73.6257 134.2642 0058075  78.2690  95.8608 12.48293279437072
0 COSMOS 2227
1 22284U 92093A   24187.54075303  .00000217  00000-0  14034-3 0  9995
2 22284  70.9759 235.9896 0020497 240.7601 119.1471 14.13544491626252
0 SL-16 R/B
1 22285U 92093B   24187.49257781 -.00000196  00000-0 -76441-4 0  9991
2 22285  71.0199 209.2791 0004106 194.5601 165.5404 14.15268127626539
0 COSMOS 2228
1 22286U 92094A   24187.50394656  .00002873  00000-0  27731-3 0  9997
2 22286  82.5201 101.5516 0018918 193.7006 166.3704 14.92409162684588
0 SL-14 R/B
1 22287U 92094B   24187.56248824  .00000527  00000-0  67756-4 0  9995
2 22287  82.5231 202.6051 0024301 179.1047 181.0214 14.79110691678006
0 SL-16 DEB
1 22289U 92093D   24187.46998382  .00000385  00000-0  15822-3 0  9994
2 22289  70.8322  72.4599 0060385   1.4820 174.4027 14.32301942645920
0 SL-16 DEB
1 22290U 92093E   24187.56200093  .00000201  00000-0  22188-3 0  9992
2 22290  71.0504  16.2394 0196022 213.1247 209.9401 13.75037428580670
0 SL-16 DEB
1 22291U 92093F   24187.48424638  .00000112  00000-0  14566-3 0  9999
2 22291  71.0102  76.5492 0209273 334.3541 204.2707 13.72247338578099
0 SL-16 DEB
1 22292U 92093G   24187.57089858  .00000201  00000-0  23346-3 0  9996
2 22292  71.0047 121.6385 0209450  40.9077 131.4490 13.70768720571614
0 SL-16 DEB
1 22293U 92093H   24187.03213018  .00000101  00000-0  13205-3 0  9997
2 22293  71.0560  45.3740 0197502 192.1475 167.4829 13.74382818574744
0 SL-16 DEB
1 22294U 92093J   24187.47026318 -.00000032  00000-0  77881-5 0  9997
2 22294  71.0590  82.4201 0098936 160.8926  11.6553 14.10371113622651
0 SL-16 DEB
1 22295U 92093K   24187.46887711  .00000374  00000-0  24290-3 0  9991
2 22295  71.0038 199.5503 0095800  52.7217  98.2629 14.06634229617051
0 SL-16 DEB
1 22296U 92093L   24187.49054823  .00016013  00000-0  36790-2 0  9999
2 22296  70.8400  90.7440 0053900  65.1991 108.7032 14.54611658632872
0 SL-16 DEB
1 22297U 92093M   24187.39696843  .00000156  00000-0  11922-3 0  9995
2 22297  70.9454 206.9225 0101652 232.3680 126.8181 14.05730247613334
0 COSMOS 2230
1 22307U 93001A   24187.51303056  .00000077  00000-0  66487-4 0  9991
2 22307  82.9412  94.7925 0024352 349.8448 183.1342 13.73759621569369
0 SL-8 R/B
1 22308U 93001B   24187.59243936  .00000077  00000-0  63576-4 0  9996
2 22308  82.9344  56.0301 0022658 207.7871 213.2980 13.75852878580144
0 TDRS 6
1 22314U 93003B   24186.93035613 -.00000305  00000-0  00000-0 0  9997
2 22314  14.1630   2.2818 0011761 155.5160  54.7171  1.00270149115263
0 IUS R/B(1)
1 22315U 93003C   24184.95479622  .00009659  00000-0  98531-3 0  9999
2 22315  26.9382  68.5566 6154490 246.7204  39.3215  3.84425331155103
0 IUS R/B(2)
1 22316U 93003D   24187.18650962 -.00000129  00000-0  00000-0 0  9991
2 22316  12.2908 348.6086 0071073 110.0279 242.7369  1.00139080120054
0 COSMOS 2232
1 22321U 93006A   24186.67308923  .00000767  00000-0  00000+0 0  9996
2 22321  67.2945 224.0182 5825861 138.7332 284.4013  2.00535353230290
0 SL-6 R/B(2)
1 22324U 93006D   24184.25842513  .00000595  00000-0  00000-0 0  9999
2 22324  68.2808 201.5346 5197107 113.5603 308.1978  2.03720786233668
0 SL-16 DEB
1 22326U 92093P   24187.30696882  .00001368  00000-0  95129-3 0  9999
2 22326  70.6616 130.1502 0143783 179.5037 335.1405 13.95755947595019
0 SL-16 DEB
1 22327U 92093Q   24187.55809787  .00007312  00000-0  83835-3 0  9993
2 22327  71.1189 235.0878 0075595 121.5752 349.0860 14.84147400657058
0 SL-16 DEB
1 22329U 92093S   24187.19079768  .00020394  00000-0  19196-2 0  9996
2 22329  70.8926 111.8566 0051566 328.5543  31.2539 14.92828399655401
0 SL-16 DEB
1 22330U 92093T   24187.58227434  .00000571  00000-0  34389-3 0  9993
2 22330  70.4165 299.1113 0115935 295.2910  75.8746 14.08036415613888
0 SL-16 DEB
1 22331U 92093U   24187.39185933  .00000178  00000-0  13679-3 0  9992
2 22331  70.9217 147.7907 0078927 266.2090 266.1583 14.04760609615103
0 SL-16 DEB
1 22333U 92093W   24187.46774535  .00000496  00000-0  14480-3 0  9998
2 22333  71.0024 208.3418 0128123 270.1341  88.5116 14.44666421637216
0 SL-16 DEB
1 22335U 92093Y   24187.43439106  .00000684  00000-0  49258-3 0  9999
2 22335  71.1634 175.2866 0114309 233.6255 241.1021 13.97189252600989
0 SL-16 DEB
1 22336U 92093Z   24187.49644579  .00000681  00000-0  51354-3 0  9995
2 22336  71.1312 216.4260 0117845 354.9309   5.0599 13.94469985598292
0 SL-16 DEB
1 22337U 92093AA  24187.60187053  .00000081  00000-0  10124-3 0  9992
2 22337  71.2902 278.5286 0149851 235.2251 123.4677 13.84390965591155
0 SL-16 DEB
1 22338U 92093AB  24187.54318622  .00005524  00000-0  93264-3 0  9997
2 22338  70.6192 307.5131 0075882 114.3257  12.1545 14.67995339650700
0 SL-16 DEB
1 22339U 92093AC  24187.57615269  .00000464  00000-0  16745-3 0  9995
2 22339  70.8114 288.6201 0126276 177.7882 182.3837 14.34671244627983
0 SL-16 DEB
1 22340U 92093AD  24187.60474215  .00000058  00000-0  74856-4 0  9992
2 22340  70.8755 132.3789 0102792 316.3938 218.3220 13.94375873603414
0 SL-16 DEB
1 22341U 92093AE  24187.19107422  .00000678  00000-0  50868-3 0  9994
2 22341  70.7457 135.6920 0141316 303.5608 181.9566 13.93608637598454
0 SL-16 DEB
1 22342U 92093AF  24187.05733420  .00000440  00000-0  34833-3 0  9994
2 22342  70.6997  51.3426 0119574  18.0833 133.5386 13.93862803598772
0 SL-16 DEB
1 22343U 92093AG  24187.37210472  .00000833  00000-0  47691-3 0  9999
2 22343  70.9568 165.9368 0094660 176.5967 294.2529 14.10179398615777
0 SL-16 DEB
1 22344U 92093AH  24187.43479333  .00001799  00000-0  10120-2 0  9998
2 22344  71.0937 201.8678 0108005 182.1230 177.9448 14.08854138608834
0 SL-16 DEB
1 22347U 92093AL  24187.26570253  .00004710  00000-0  28388-2 0  9996
2 22347  70.8397 123.7616 0166287 348.2421 163.9101 14.00524233590182
0 SL-16 DEB
1 22348U 92093AM  24187.51839762  .00000727  00000-0  43253-3 0  9991
2 22348  71.2583 229.1259 0104787  39.0837  79.1565 14.07830859613158
0 SL-16 DEB
1 22349U 92093AN  24187.55332082  .00000656  00000-0  57602-3 0  9993
2 22349  70.8207 290.2097 0182449  80.3329 292.5550 13.81795730584535
0 SL-16 DEB
1 22350U 92093AP  24187.53626093  .00000136  00000-0  10975-3 0  9996
2 22350  70.9105 105.1312 0067531  54.9734 117.4280 14.05910348615889
0 SL-16 DEB
1 22351U 92093AQ  24187.59648811  .00000520  00000-0  34789-3 0  9991
2 22351  70.9079 304.0627 0103389  63.8480 310.5239 14.02954583609821
0 SL-16 DEB
1 22352U 92093AR  24187.62101986  .00000058  00000-0  68662-4 0  9997
2 22352  70.8909 263.4013 0074060  97.4309  16.5395 14.00585394609202
0 SL-16 DEB
1 22353U 92093AS  24187.63159245  .00001631  00000-0  89041-3 0  9991
2 22353  70.9704 283.3237 0114406 231.3687 238.9445 14.10276575611357
0 SL-16 DEB
1 22354U 92093AT  24187.46889470  .00000105  00000-0  10593-3 0  9994
2 22354  71.1437 180.0313 0143306 176.5298 301.6182 13.92629918599163
0 SL-16 DEB
1 22356U 92093AV  24187.58318726  .00268230  00000-0  10549-1 0  9994
2 22356  70.6497 113.9763 0033943 190.2423 169.8067 15.23863794638198
0 SL-16 DEB
1 22357U 92093AW  24187.51605258  .00015942  00000-0  13556-2 0  9999
2 22357  70.8605 207.9479 0050204  19.7379 101.8861 14.96906789662437
0 SL-16 DEB
1 22358U 92093AX  24187.52354631  .00000107  00000-0  12257-3 0  9992
2 22358  71.2260 204.0218 0146759 349.7236 124.0532 13.84708307592311
0 SL-16 DEB
1 22359U 92093AY  24187.54784456  .00001560  00000-0  10847-2 0  9993
2 22359  70.7428 335.4295 0166071  65.3663   4.1200 13.93904417591757
0 SL-16 DEB
1 22361U 92093BA  24187.62145448  .00000530  00000-0  48182-3 0  9997
2 22361  70.7654 265.9169 0186467 216.6375 256.9118 13.80561700584487
0 SL-16 DEB
1 22362U 92093BB  24187.56684235  .00002256  00000-0  17253-2 0  9994
2 22362  70.8961 107.6736 0192300  96.6631  77.6528 13.86109146582373
0 SL-16 DEB
1 22363U 92093BC  24187.13492099  .00000659  00000-0  49191-3 0  9995
2 22363  71.0358  84.6937 0143634  53.2461 308.1738 13.93557193598896
0 SL-16 DEB
1 22366U 92093BF  24187.39781481  .00016000  00000-0  45292-2 0  9996
2 22366  71.1147 173.7063 0094335  55.4866  56.2528 14.43002454620224
0 SL-16 DEB
1 22367U 92093BG  24187.56127049  .00000077  00000-0  97355-4 0  9996
2 22367  70.9001 245.3289 0188728 326.2842 140.8401 13.83143042589664
0 SL-16 DEB
1 22368U 92093BH  24187.61443541  .00000650  00000-0  17132-3 0  9992
2 22368  71.2446   3.7289 0115398 353.8699  74.0261 14.48957677638977
0 SL-16 DEB
1 22369U 92093BJ  24187.32858595  .00000003  00000-0  35949-4 0  9999
2 22369  70.8858 140.1704 0102524 293.0518  65.9808 13.94331957602659
0 SL-16 DEB
1 22370U 92093BK  24187.54892573  .00000623  00000-0  38632-3 0  9998
2 22370  70.9750 269.4213 0110011 197.1748 265.9742 14.06028036612398
0 SL-16 DEB
1 22371U 92093BL  24187.45466495  .00000199  00000-0  17639-3 0  9991
2 22371  71.1653 192.4829 0113730 250.9757 216.8185 13.93423806600214
0 SL-16 DEB
1 22374U 92093BP  24187.35018069  .00001617  00000-0  12279-2 0  9993
2 22374  70.7878 152.7192 0175651  70.0785  80.3513 13.88285237587823
0 SL-16 DEB
1 22375U 92093BQ  24187.52783118  .00000206  00000-0  16293-3 0  9991
2 22375  70.8143 180.5673 0089312   6.5580 128.9463 14.01185799609666
0 SL-16 DEB
1 22376U 92093BR  24187.29954698  .00003316  00000-0  13992-2 0  9996
2 22376  70.8904 125.7299 0056140  51.9526 110.1046 14.25513028624319
0 SL-16 DEB
1 22377U 92093BS  24187.62999669  .00000758  00000-0  46413-3 0  9993
2 22377  71.0958 323.6623 0056571 355.8296   4.2344 14.08208356615220
0 SL-16 DEB
1 22379U 92093BU  24187.28414861  .00001403  00000-0  81649-3 0  9991
2 22379  70.7058  32.4614 0087280  97.0877 264.0175 14.08490773609840
0 SL-16 DEB
1 22382U 92093BX  24187.22119391  .00000587  00000-0  46235-3 0  9993
2 22382  70.8666 139.0339 0163285 212.3241 213.2272 13.89882344590496
0 SL-16 DEB
1 22387U 92093CC  24187.52671524  .00002079  00000-0  12531-2 0  9991
2 22387  70.8914 334.8612 0109319 137.6547 333.0547 14.04907314606893
0 SL-16 DEB
1 22388U 92093CD  24187.57369172  .00002324  00000-0  11890-2 0  9990
2 22388  70.9663 252.7664 0103823 253.3125 231.0296 14.13820200611637
0 SL-16 DEB
1 22390U 92093CF  24187.53874771  .00000728  00000-0  46655-3 0  9999
2 22390  71.1711 227.1056 0080773 326.3219  33.2781 14.04964925573485
0 SL-16 DEB
1 22392U 92093CH  24187.53616459  .00007036  00000-0  90788-3 0  9993
2 22392  70.8905 321.2734 0090421  96.9945 338.7819 14.78470108658142
0 SL-16 DEB
1 22393U 92093CJ  24187.58896034  .00001154  00000-0  67712-3 0  9994
2 22393  71.1208 247.7678 0119823  15.8319  55.0624 14.06651784607908
0 SL-16 DEB
1 22394U 92093CK  24187.60920163  .00000673  00000-0  40747-3 0  9993
2 22394  71.2772 304.3217 0075040  75.8098 285.1344 14.08485985610861
0 SL-16 DEB
1 22395U 92093CL  24187.61714822  .00008842  00000-0  28693-2 0  9999
2 22395  71.1447 252.0492 0070109 118.0056 357.3701 14.37695751618457
0 SL-16 DEB
1 22397U 92093CN  24186.84172780  .00001787  00000-0  74506-3 0  9992
2 22397  70.8022 226.0517 0037399 202.6044 157.3439 14.27286141627986
0 SL-16 DEB
1 22398U 92093CP  24187.47575467  .00000756  00000-0  45709-3 0  9990
2 22398  70.9536 337.6291 0113050 316.4830  42.7407 14.06616165608905
0 SL-16 DEB
1 22400U 92093CR  24187.31964334  .00000331  00000-0  28368-3 0  9993
2 22400  71.2394 155.8775 0159282 259.3025 225.2081 13.88076483594216
0 SL-16 DEB
1 22403U 92093CU  24187.54097486  .00000828  00000-0  52397-3 0  9996
2 22403  70.8913 251.5866 0081051  92.7194  19.9352 14.05365879609384
0 SL-16 DEB
1 22404U 92093CV  24187.62908404  .00021305  00000-0  14599-2 0  9991
2 22404  71.0435  29.9488 0056437 178.0033 239.5819 15.04709534662112
0 SL-16 DEB
1 22405U 92093CW  24187.59386280  .00000419  00000-0  13366-3 0  9995
2 22405  71.0364   8.7425 0126229 287.5826  71.1554 14.41345989631991
0 SL-16 DEB
1 22406U 92093CX  24187.43839627  .00000345  00000-0  31903-3 0  9992
2 22406  70.7528 176.3452 0174519 191.8562 324.5182 13.82756718585362
0 SL-16 DEB
1 22407U 92093CY  24187.43885290  .00000432  00000-0  38370-3 0  9992
2 22407  70.8608 290.7468 0181359 334.3250  24.8931 13.83188570585570
0 SL-16 DEB
1 22408U 92093CZ  24187.37922884  .00002314  00000-0  12657-2 0  9997
2 22408  71.0892 181.6987 0121094  56.0356  59.1091 14.09284267607637
0 SL-16 DEB
1 22409U 92093DA  24187.53069925  .00001780  00000-0  35875-3 0  9998
2 22409  71.1342 318.4072 0119681  68.0813   4.5678 14.58506018644837
0 SL-16 DEB
1 22410U 92093DB  24187.57305778  .00000283  00000-0  22510-3 0  9992
2 22410  71.0862 353.5330 0109043 335.9584  87.2526 13.96722907602432
0 SL-16 DEB
1 22415U 92093DG  24187.30661330  .00001010  00000-0  61473-3 0  9997
2 22415  71.1157 152.6391 0124524 310.8176  48.2194 14.04762566608989
0 SL-16 DEB
1 22416U 92093DH  24187.40556690  .00000402  00000-0  26657-3 0  9990
2 22416  70.9580 180.5124 0080470 332.3996 141.1639 14.05839867615571
0 SL-16 DEB
1 22417U 92093DJ  24187.62293822  .00000125  00000-0  11637-3 0  9994
2 22417  71.1842  33.3634 0084874  80.1492 337.1450 13.97411267606228
0 SL-16 DEB
1 22418U 92093DK  24187.50388376  .00001102  00000-0  68549-3 0  9991
2 22418  71.1264 317.7566 0127928  56.4992  13.5817 14.03113594605938
0 SL-16 DEB
1 22419U 92093DL  24187.37670908  .00000244  00000-0  20278-3 0  9995
2 22419  71.1785 161.2909 0106525 184.4925 175.5244 13.95379670601767
0 SL-16 DEB
1 22420U 92093DM  24187.17357373  .00018269  00000-0  14522-2 0  9993
2 22420  70.9850  88.3267 0040447  65.1675  55.2144 14.99804101660059
0 SL-16 DEB
1 22421U 92093DN  24187.41919861  .00000468  00000-0  27742-3 0  9998
2 22421  71.0328 168.4240 0095966 307.2821 217.1323 14.10496643616692
0 SL-16 DEB
1 22422U 92093DP  24187.05639358  .00000528  00000-0  37703-3 0  9994
2 22422  71.1845  36.5164 0091893  70.8482  91.6897 13.99691892604708
0 SL-16 DEB
1 22423U 92093DQ  24187.43870890  .00000071  00000-0  81080-4 0  9996
2 22423  71.2781 220.5356 0101505 289.6670  69.3513 13.95303046602373
0 SL-16 DEB
1 22425U 92093DS  24187.35551895  .00000287  00000-0  23555-3 0  9991
2 22425  71.1755 204.6061 0114017 224.2557 150.5488 13.94370318599208
0 SL-16 DEB
1 22426U 92093DT  24187.53807898  .00002067  00000-0  84285-3 0  9994
2 22426  71.3521 345.8310 0129723 279.7885 150.1504 14.24031637621658
0 SL-16 DEB
1 22430U 92093DX  24187.52601122  .00000302  00000-0  24072-3 0  9998
2 22430  71.2344 216.1681 0114347  37.7748  80.7910 13.95454762601160
0 SL-16 DEB
1 22432U 92093DZ  24187.37672531  .00000823  00000-0  51690-3 0  9999
2 22432  70.8341 291.5470 0103290 312.0904 108.1330 14.04894208605805
0 SL-16 DEB
1 22433U 92093EA  24187.16026017  .00023481  00000-0  41492-2 0  9992
2 22433  71.1503  98.9425 0053717 295.3470  64.2123 14.66406422633334
0 SL-16 DEB
1 22435U 92093EC  24187.60863911  .00046313  00000-0  63089-2 0  9990
2 22435  71.3275  25.4286 0045996  95.6315 326.0902 14.77718950631328
0 SL-16 DEB
1 22436U 92093ED  24187.44448212  .00007551  00000-0  13136-2 0  9995
2 22436  71.5119 320.8311 0050049 239.4723 178.1795 14.67556065660396
0 SL-16 DEB
1 22437U 92093EE  24187.44965126  .00003049  00000-0  83308-3 0  9991
2 22437  71.3342 251.3105 0039768 303.1754  56.5576 14.47559270645589
0 SL-16 DEB
1 22441U 92093EJ  24187.62193536  .00000316  00000-0  22284-3 0  9994
2 22441  71.1956 282.1158 0086902 288.7029 185.9029 14.03604344610259
0 SL-16 DEB
1 22442U 92093EK  24187.53605492  .00007975  00000-0  27134-2 0  9990
2 22442  71.1038 243.7663 0117315 110.6263 250.7497 14.32955848616886
0 SL-16 DEB
1 22443U 92093EL  24187.52089305  .00019356  00000-0  38782-2 0  9996
2 22443  71.0909 238.7259 0049000 341.3217  18.6130 14.60989600626830
0 SL-16 DEB
1 22444U 92093EM  24187.60593719  .00000641  00000-0  39768-3 0  9998
2 22444  71.3210 282.3816 0080660 280.3463 197.9861 14.07173541612236
0 SL-16 DEB
1 22445U 92093EN  24186.99045839  .00000842  00000-0  45599-3 0  9997
2 22445  71.2878  36.5912 0077596 222.1850 137.3288 14.13745885617666
0 NAVSTAR 30 (USA 88)
1 22446U 93007A   24186.58699985 -.00000011  00000-0  00000-0 0  9990
2 22446  53.7342 268.7540 0025443  31.6095 289.0801  1.88095040220599
0 SL-16 DEB
1 22451U 92093EQ  24187.59507755  .00000129  00000-0  12153-3 0  9999
2 22451  71.1380 124.9113 0130426 159.4246  15.1906 13.93938910600503
0 SL-16 DEB
1 22453U 92093ES  24187.28001102  .00001351  00000-0  10556-2 0  9994
2 22453  70.8047 140.5672 0169424  20.4750 137.6956 13.87477655588318
0 SL-16 DEB
1 22454U 92093ET  24187.10018516  .00000396  00000-0  29058-3 0  9999
2 22454  70.9176  70.3247 0104820 137.3607 223.5704 13.99181912605338
0 SL-16 DEB
1 22455U 92093EU  24186.93632708  .00018278  00000-0  56467-2 0  9996
2 22455  70.8624 114.0208 0090684 352.5511 125.0375 14.38957749613136
0 SL-16 DEB
1 22456U 92093EV  24187.59290248  .00011081  00000-0  35687-2 0  9995
2 22456  71.2455 262.9969 0096751  65.8371  52.0355 14.36746229611312
0 SL-16 DEB
1 22458U 92093EX  24187.52217782  .00000195  00000-0  15503-3 0  9992
2 22458  70.8515 215.2077 0073875 205.0467 280.5909 14.02102426609029
0 SL-16 DEB
1 22459U 92093EY  24187.62336831  .00078959  00000-0  78206-2 0  9992
2 22459  71.1604 282.0125 0035821 125.6122 347.1757 14.90897790629028
0 SL-16 DEB
1 22468U 92093FH  24187.52676115  .00034882  00000-0  55831-2 0  9999
2 22468  71.1424 224.9854 0053600  48.7966 311.7789 14.70638768619597
0 SL-16 DEB
1 22473U 92093FN  24187.55571104  .00073953  00000-0  69482-2 0  9999
2 22473  71.3176 235.5861 0037830 289.7397  69.9690 14.92969205624694
0 SL-16 DEB
1 22474U 92093FP  24187.40492353  .00006655  00000-0  36409-2 0  9990
2 22474  71.3033 287.3945 0159533 179.9648 180.1513 14.05966287589858
0 SL-16 DEB
1 22476U 92093FR  24186.90810280  .00001932  00000-0  24972-2 0  9994
2 22476  71.5458 159.4509 0474143 254.4275 100.4002 13.24700919509117
0 SL-16 DEB
1 22477U 92093FS  24187.39186438  .00021712  00000-0  19316-2 0  9994
2 22477  70.8585 174.4120 0041930 109.8721  52.2168 14.95366852670805
0 SL-16 DEB
1 22480U 92093FV  24187.10503449  .00033984  00000-0  55200-2 0  9998
2 22480  71.1045  70.4222 0044780  70.4457  48.5969 14.70296413631832
0 COSMOS 2233
1 22487U 93008A   24187.53913587  .00000062  00000-0  48386-4 0  9997
2 22487  82.9453 350.4826 0036899 305.6092 118.0886 13.75929200572154
0 SL-8 R/B
1 22488U 93008B   24187.61754361  .00000055  00000-0  39264-4 0  9997
2 22488  82.9438 321.7066 0024778 204.3826 166.2969 13.77859975578604
0 OXP 1
1 22489U 93009A   24187.53236358  .00000843  00000-0  17950-3 0  9993
2 22489  24.9643 272.4228 0040088 193.2222 166.7236 14.46011214658029
0 SCD 1
1 22490U 93009B   24187.58106396  .00000646  00000-0  12774-3 0  9998
2 22490  24.9694 279.1730 0042469 169.5938 214.8767 14.45319686658021
0 PEGASUS R/B
1 22491U 93009C   24187.42995502  .00001339  00000-0  25315-3 0  9992
2 22491  24.9765 242.4742 0045930   1.8117 358.2555 14.55545181665714
0 SL-16 DEB
1 22493U 92093GC  24187.52923623  .00002495  00000-0  62883-3 0  9997
2 22493  71.0406 359.9404 0103206 250.6175 108.3788 14.48984788667726
0 SL-16 DEB
1 22494U 92093GD  24187.27041054  .00008443  00000-0  47732-2 0  9993
2 22494  70.8172 140.4924 0166182  36.3895  86.7855 14.03661251588908
0 SL-16 DEB
1 22496U 92093GF  24187.20038615  .00000200  00000-0  16759-3 0  9996
2 22496  71.2161  84.3725 0089075  29.9592 127.2468 13.97513137603332
0 SL-16 DEB
1 22499U 92093GJ  24187.31888471  .00109197  00000-0  93670-2 0  9995
2 22499  71.3797 136.8885 0021621 312.9705 173.8994 14.96701189628092
0 SL-16 DEB
1 22500U 92093GK  24187.26255453  .00001237  00000-0  52148-3 0  9992
2 22500  70.8480 131.2166 0061320 138.6276 221.9520 14.26658304628751
0 SL-16 DEB
1 22502U 92093GM  24187.19199851  .00000406  00000-0  33928-3 0  9997
2 22502  70.8172 340.5700 0154593 229.7230 307.0613 13.89019089595444
0 SL-16 DEB
1 22509U 92093GU  24187.59382197  .00004155  00000-0  18635-2 0  9997
2 22509  71.1322  15.0406 0115948 156.0360 264.2369 14.19479300614158
0 COSMOS 2234 (GLONASS)
1 22512U 93010A   24187.24988477 -.00000040  00000-0  00000-0 0  9991
2 22512  64.5046  94.5497 0022780 209.8530 281.4245  2.13103583243969
0 COSMOS 2236 (GLONASS)
1 22513U 93010B   24184.39904365 -.00000053  00000-0  00000-0 0  9993
2 22513  64.4979  94.5543 0004538  78.4002 110.4568  2.13104617244140
0 COSMOS 2235 (GLONASS)
1 22514U 93010C   24185.73515837 -.00000051  00000-0  00000-0 0  9993
2 22514  64.5167  94.8176 0009388 208.7948 335.3681  2.13102096244087
0 SL-12 R/B(2)
1 22517U 93010F   24186.68227187 -.00000045  00000-0  00000-0 0  9992
2 22517  64.5229  93.2372 0026979 226.7237 323.3901  2.13421540245313
0 THORAD AGENA D DEB
1 22532U 70025QN  24186.92387667  .00001374  00000-0  16743-2 0  9995
2 22532 100.0562 332.6866 0004576 202.3465 322.6352 13.67950212556306
0 THORAD AGENA D DEB
1 22533U 70025QP  24187.36320837  .00001897  00000-0  22539-2 0  9991
2 22533 100.0479 326.4127 0004240 222.3850 193.2479 13.68932526555774
0 SL-16 DEB
1 22537U 92093GX  24187.53780982  .00002783  00000-0  15141-2 0  9990
2 22537  71.1736 346.1075 0108245  71.7711 289.5156 14.10104047603902
0 SL-16 DEB
1 22543U 92093HD  24187.45571519  .00020154  00000-0  42982-2 0  9997
2 22543  71.3553 313.4658 0057653 298.9172  60.6200 14.57842608620137
0 SL-16 DEB
1 22544U 92093HE  24187.05930736  .00027485  00000-0  51664-2 0  9995
2 22544  71.2350  54.4563 0072248 313.1260 210.0626 14.62862100612593
0 SL-16 DEB
1 22545U 92093HF  24187.47842700  .00003764  00000-0  42042-2 0  9999
2 22545  71.5619 353.5174 0399894 170.7795 190.0931 13.42122430526755
0 SL-16 DEB
1 22546U 92093HG  24187.15085413  .00029398  00000-0  51341-2 0  9998
2 22546  71.3686 249.3107 0051372 189.8957 170.1189 14.66944743622604
0 SL-16 DEB
1 22549U 92093HK  24187.17800227  .00002715  00000-0  13277-2 0  9991
2 22549  71.2449 252.3925 0101743 220.7954 138.5523 14.16100206610784
0 SL-16 DEB
1 22551U 92093HM  24187.07234571  .00000167  00000-0  14836-3 0  9998
2 22551  70.8648  66.8231 0096017 312.0451  47.2518 13.96694389604055
0 SL-16 DEB
1 22554U 92093HQ  24187.34904449  .00037380  00000-0  60895-2 0  9991
2 22554  71.3944 141.0660 0038778  26.1610 135.8671 14.70307028631154
0 RADUGA 29
1 22557U 93013A   24186.95014705 -.00000023  00000-0  00000-0 0  9995
2 22557  14.2277 350.4201 0007080 147.9889 194.0775  1.00161192114530
0 START 1
1 22561U 93014A   24187.44017152  .00000276  00000-0  10821-3 0  9999
2 22561  75.7619  80.2675 0193459   0.6432 359.4933 14.22220355622661
0 SL-18 R/B
1 22562U 93014B   24187.58493527  .00000413  00000-0  14362-3 0  9996
2 22562  75.7609 245.3480 0163198  82.0938 279.8708 14.29797613630095
0 UFO 1 (USA 98)
1 22563U 93015A   24186.16941203 -.00000073  00000-0  00000-0 0  9994
2 22563  24.0737  83.5383 0002999 280.7915 251.5983  0.99249796117629
0 COSMOS 2237
1 22565U 93016A   24187.61157947 -.00000067  00000-0 -96510-5 0  9992
2 22565  70.8206  16.8952 0008557 242.3896 117.6356 14.12520099612871
0 SL-16 R/B
1 22566U 93016B   24187.40370293  .00000356  00000-0  20760-3 0  9992
2 22566  71.0079  61.0233 0010465 186.3405 173.7587 14.15141289615540
0 SL-18 DEB
1 22567U 93014C   24187.50348052  .00003196  00000-0  88950-3 0  9990
2 22567  75.7511 199.8268 0155171  29.9556  90.9777 14.39739115631348
0 SL-18 DEB
1 22568U 93014D   24187.61006855  .00002919  00000-0  80279-3 0  9993
2 22568  75.7469 178.9847 0155351  20.5318 142.7885 14.40300272631880
0 SL-16 DEB
1 22571U 92093HT  24187.23683203  .00020428  00000-0  59972-2 0  9999
2 22571  71.3480 110.0227 0102114 338.8329  20.8597 14.40757986600884
0 SL-16 DEB
1 22574U 92093HW  24187.29002561  .00002689  00000-0  14196-2 0  9998
2 22574  71.0884 261.7771 0134084 145.4045 275.7919 14.10197690600570
0 SL-16 DEB
1 22575U 93016C   24187.59563131  .00000097  00000-0  12953-3 0  9994
2 22575  71.0042 250.6371 0203655  96.4591  15.5706 13.73049852566526
0 SL-16 DEB
1 22576U 93016D   24187.53525823  .00000160  00000-0  18841-3 0  9998
2 22576  70.9947 228.3275 0198673 128.9718 346.6829 13.73269347566931
0 SL-16 DEB
1 22577U 93016E   24187.19564998  .00000244  00000-0  81954-4 0  9996
2 22577  71.0408  88.7584 0115240 135.6668  24.3585 14.43334948646289
0 SL-16 DEB
1 22578U 93016F   24187.58015289  .00000744  00000-0  18589-3 0  9992
2 22578  71.0646 289.1787 0111954 302.8433  66.3736 14.51334794651987
0 SL-16 DEB
1 22579U 93016G   24187.08530545  .00000723  00000-0  20626-3 0  9997
2 22579  71.0299  69.8548 0103459 134.5629 336.6822 14.45582683646436
0 NAVSTAR 31 (USA 90)
1 22581U 93017A   24185.59339359 -.00000109  00000-0  00000-0 0  9995
2 22581  54.7501 323.7858 0003403  93.0629 341.8423  1.88945742 75709
0 COSMOS 2239
1 22590U 93020A   24187.59963916  .00000066  00000-0  52896-4 0  9998
2 22590  82.9325 309.2429 0024282 118.5644 252.4978 13.75530027568958
0 SL-8 R/B
1 22591U 93020B   24187.56379896  .00000095  00000-0  79953-4 0  9999
2 22591  82.9296 280.5764 0025235   5.4858   5.5424 13.77603049571032
0 SL-16 DEB
1 22598U 92093HX  24187.32541801  .00000609  00000-0  40466-3 0  9993
2 22598  70.6452  43.5280 0090680 274.5454  84.5307 14.03600026607460
0 SL-18 DEB
1 22599U 93014E   24187.41917308  .00002242  00000-0  55386-3 0  9999
2 22599  75.7553  74.6224 0142395 208.2069 151.1337 14.46442596636424
0 SL-16 DEB
1 22600U 93016J   24187.61971990  .00000061  00000-0  87991-4 0  9998
2 22600  70.9132 149.1540 0158359 147.7915  26.3244 13.82248912577317
0 SL-16 DEB
1 22601U 93016K   24187.02924203  .00000069  00000-0  98928-4 0  9999
2 22601  71.0429  84.3789 0177453 219.5432 139.2616 13.78758623572998
0 SL-16 DEB
1 22602U 93016L   24187.59163921  .00000059  00000-0  93566-4 0  9996
2 22602  71.0445 266.0436 0199066  28.6330  74.2642 13.73832817567393
0 SL-16 DEB
1 22603U 93016M   24187.61212811 -.00000010  00000-0  30577-4 0  9994
2 22603  70.9968   7.2947 0161178 305.3255 120.0633 13.78655141573506
0 SL-16 DEB
1 22604U 93016N   24187.51461072  .00000017  00000-0  55488-4 0  9993
2 22604  70.9933  87.1060 0169444  11.4272 163.9011 13.76416339571090
0 SL-16 DEB
1 22605U 93016P   24187.44553990  .00000131  00000-0  13161-3 0  9995
2 22605  70.9985 335.5906 0130559 356.6683  65.3524 13.90591684585319
0 SL-16 DEB
1 22606U 93016Q   24187.30320050  .00000590  00000-0  48783-3 0  9997
2 22606  71.0008 147.8672 0146692 123.5523  27.0252 13.88064088580454
0 SL-16 DEB
1 22607U 93016R   24187.22486925  .00000015  00000-0  53086-4 0  9998
2 22607  70.9923 107.7602 0172594  31.1735  94.9520 13.75851686570269
0 SL-16 DEB
1 22608U 93016S   24187.29564203 -.00000008  00000-0  29933-4 0  9999
2 22608  71.0036 146.8172 0129511 143.6898 330.1846 13.84629363580399
0 SL-16 DEB
1 22609U 93016T   24187.52616499  .00000572  00000-0  47813-3 0  9992
2 22609  70.9929 106.4250 0135996 126.8803  47.6201 13.88293586581272
0 SL-16 DEB
1 22610U 93016U   24187.03079080  .00000010  00000-0  52996-4 0  9995
2 22610  71.0010  52.3833 0215123 231.3717 126.7952 13.67803939561221
0 SL-16 DEB
1 22611U 93016V   24187.12551169  .00000281  00000-0  28909-3 0  9995
2 22611  70.9911  72.9297 0170592   9.1487 142.6098 13.78256856571307
0 SL-16 DEB
1 22612U 93016W   24186.88798760  .00004968  00000-0  19237-2 0  9997
2 22612  70.9811  33.5985 0071093 290.9681 176.8500 14.29115655604757
0 SL-16 DEB
1 22613U 93016X   24187.46556105  .00000553  00000-0  53121-3 0  9995
2 22613  70.9988 226.6097 0193638 101.5309  16.0778 13.76364326566982
0 SL-16 DEB
1 22614U 93016Y   24187.20936669  .00000568  00000-0  47639-3 0  9998
2 22614  70.9989  97.5666 0127232 112.1805  39.4428 13.88601068581479
0 SL-16 DEB
1 22615U 93016Z   24187.12186711  .00001306  00000-0  97623-3 0  9994
2 22615  71.0030  73.7898 0133682  86.2159  62.5403 13.92357089582366
0 SL-16 DEB
1 22616U 93016AA  24187.47343847  .00000126  00000-0  15895-3 0  9998
2 22616  70.9938 214.7971 0185652 107.9584  13.3346 13.73705702567336
0 SL-16 DEB
1 22617U 93016AB  24187.49571420  .00001014  00000-0  78730-3 0  9995
2 22617  71.0006 101.4575 0134822 110.6483  63.1455 13.90696436581498
0 SL-16 DEB
1 22618U 93016AC  24187.55286360  .00000336  00000-0  31679-3 0  9996
2 22618  70.9931 279.6568 0158285 246.5494 111.8905 13.82864492576073
0 SL-16 DEB
1 22619U 93016AD  24187.58391705  .00000042  00000-0  79774-4 0  9993
2 22619  70.9981 196.8994 0184218  74.2416  61.0276 13.73743355567360
0 SL-16 DEB
1 22620U 93016AE  24187.45446080  .00000004  00000-0  40179-4 0  9993
2 22620  71.0045 175.6509 0133743 160.3863   4.7729 13.84000293579057
0 SL-12 R/B(2)
1 22624U 93013D   24186.98832433 -.00000037  00000-0  00000-0 0  9994
2 22624  15.1416 353.4914 0018554 115.2036 243.7829  0.98012907111921
0 COSMOS 2242
1 22626U 93024A   24187.40865208  .00002510  00000-0  24434-3 0  9999
2 22626  82.5211 130.4911 0017036 194.7129 165.3597 14.92056861688930
0 SL-14 R/B
1 22627U 93024B   24187.59635279  .00000509  00000-0  65248-4 0  9998
2 22627  82.5208 227.6849 0023009 183.6881 176.4166 14.79144083682641
0 ALEXIS
1 22638U 93026A   24187.51345077  .00000283  00000-0  12224-3 0  9992
2 22638  69.9211 121.2171 0057344  51.5911 309.0342 14.33166143  8170
0 PEGASUS R/B
1 22639U 93026B   24187.35766496  .00000311  00000-0  13396-3 0  9990
2 22639  69.9186 165.3646 0061072  87.3140 273.4973 14.32373742  7438
0 SL-16 DEB
1 22645U 93016AF  24187.15930735  .00000829  00000-0  69099-3 0  9998
2 22645  70.9872 332.4175 0170891 290.6505 246.4177 13.84914443573672
0 COSMOS 2245
1 22646U 93030A   24187.60280804  .00000050  00000-0  21431-3 0  9994
2 22646  82.5844  45.3614 0012788  77.5467 346.2916 12.64043874437170
0 COSMOS 2246
1 22647U 93030B   24187.58811526  .00000048  00000-0  20634-3 0  9994
2 22647  82.5849  51.5443 0011002  89.1645 271.0707 12.63606575436657
0 COSMOS 2247
1 22648U 93030C   24187.59984904  .00000045  00000-0  18894-3 0  9999
2 22648  82.5790  50.7845 0009052 109.3983 307.4274 12.63246220436236
0 COSMOS 2248
1 22649U 93030D   24187.55325262  .00000038  00000-0  14884-3 0  9999
2 22649  82.5780  46.3943 0010150 105.5535 254.6678 12.63493182436735
0 COSMOS 2249
1 22650U 93030E   24187.44139556  .00000043  00000-0  17828-3 0  9995
2 22650  82.5851  57.8599 0008344 109.6486  66.3134 12.63158102436164
0 COSMOS 2250
1 22651U 93030F   24187.60627416  .00000040  00000-0  16376-3 0  9995
2 22651  82.5830  55.6366 0010655 101.2996 317.4213 12.63088725436185
0 SL-14 R/B
1 22652U 93030G   24187.58426137  .00000043  00000-0  17863-3 0  9995
2 22652  82.5866  58.4366 0008554 109.8998 313.6640 12.63174991436191
0 ASTRA 1C
1 22653U 93031A   24186.93313337 -.00000250  00000-0  00000+0 0  9994
2 22653  11.8676  30.5470 0006389  65.2305 145.5843  0.98843433108422
0 ARASENE
1 22654U 93031B   24186.97071933 -.00000122  00000-0  00000-0 0  9991
2 22654   4.0950  68.2691 2817906 287.1811 291.4551  1.42203603157294
0 ARIANE 42L R/B
1 22655U 93031C   24187.07939093  .00003123  00000-0  14010-2 0  9995
2 22655   5.2841 343.0040 6724876 232.0304  46.4600  2.97828366294512
0 NAVSTAR 32 (USA 91)
1 22657U 93032A   24186.69246608 -.00000089  00000-0  00000-0 0  9999
2 22657  54.1811 306.2003 0040729  78.3268 271.8811  1.87695773220526
0 SL-16 DEB
1 22665U 92093JA  24186.83939775  .00000504  00000-0  32547-3 0  9999
2 22665  71.0785  23.5175 0067726 110.7878 264.3037 14.06466014601626
0 TITAN 34D TRANSTAGE DEB
1 22668U 88077D   24187.04126728  .00001151  00000-0  22948-2 0  9991
2 22668  27.2467  54.5829 7339059   7.9830 359.3642  2.15242977 39799
0 TITAN 34D TRANSTAGE DEB
1 22669U 88077E   24186.76742671  .00000178  00000-0  71745-3 0  9999
2 22669  26.8446  79.2450 7368957 335.5983   2.7247  2.11228549 39036
0 ARIANE 42P+ DEB
1 22670U 92072C   24187.57081126  .00009709  00000-0  18863-2 0  9992
2 22670   6.5955 164.4278 6123443  80.6773 339.7015  3.86047144733362
0 MOLNIYA 1-86
1 22671U 93035A   24187.44393709  .00001077  00000-0  89595-3 0  9993
2 22671  63.0226 159.9796 4895321  19.2216 354.1443  5.63374966394467
0 COSMOS 2251
1 22675U 93036A   24187.44345315  .00000159  00000-0  67660-4 0  9998
2 22675  74.0373 195.4715 0024001  45.8513 314.4606 14.32904961622488
0 SL-8 R/B
1 22676U 93036B   24187.32643117  .00000395  00000-0  14877-3 0  9990
2 22676  74.0412 150.9265 0019963 267.5453  92.3413 14.34637382624185
0 COSMOS 2252
1 22687U 93038A   24187.46008806  .00000008  00000-0 -14384-4 0  9995
2 22687  82.5840 322.7149 0008682 148.3602 274.3748 12.63301933430654
0 COSMOS 2253
1 22688U 93038B   24187.52845899  .00000015  00000-0  23147-4 0  9998
2 22688  82.5882 350.3114 0011875 174.9752 185.1460 12.61570237428761
0 COSMOS 2254
1 22689U 93038C   24187.60458686  .00000021  00000-0  54092-4 0  9992
2 22689  82.5823 300.1275 0012960 128.2553 242.7549 12.64884792432170
0 COSMOS 2255
1 22690U 93038D   24187.50227369  .00000007  00000-0 -19029-4 0  9991
2 22690  82.5860 324.2177 0006476 152.9392 279.5650 12.63300093431368
0 COSMOS 2256
1 22691U 93038E   24187.59444962  .00000016  00000-0  31857-4 0  9993
2 22691  82.5767 307.2842 0007673 157.8926 213.3211 12.63917603431924
0 COSMOS 2257
1 22692U 93038F   24187.46028554 -.00000005  00000-0 -88651-4 0  9999
2 22692  82.5802 332.7108 0008768 160.2638 199.8794 12.62234005429992
0 SL-14 R/B
1 22693U 93038G   24187.48142932  .00000032  00000-0  12830-3 0  9992
2 22693  82.5852  77.1349 0046797 113.8507  59.8151 12.54825288421756
0 HGS 4 (GALAXY 4)
1 22694U 93039A   24186.60034462 -.00000098  00000-0  00000-0 0  9991
2 22694  14.6066   0.5359 0012650  50.2961 161.1121  1.00266868111853
0 RADCAL
1 22698U 93041A   24187.52085720  .00000264  00000-0  10568-3 0  9990
2 22698  89.5040 101.2723 0088370 356.0832   3.9658 14.23811206610910
0 SCOUT G-1 R/B
1 22699U 93041B   24187.50052478  .00000494  00000-0  19499-3 0  9990
2 22699  89.5016  98.8087 0084390 306.4576  52.8860 14.25896567611824
0 NAVSTAR 33 (USA 92)
1 22700U 93042A   24185.57084012  .00000089  00000-0  00000-0 0  9993
2 22700  54.7188 193.7641 0010580  16.6009  23.7644  1.89432220223614
0 SCOUT G-1 DEB
1 22706U 93041C   24187.56805972  .00001784  00000-0  51185-3 0  9991
2 22706  89.2841 116.6509 0025737 289.4308 246.2027 14.44422372627277
0 SCOUT G-1 DEB
1 22707U 93041D   24187.27936908  .00001532  00000-0  57496-3 0  9996
2 22707  90.1590 288.0308 0143802 115.1589 246.4599 14.25688724608023
0 USA 93
1 22719U 93046A   24187.05948920  .00000034  00000-0  00000-0 0  9999
2 22719  13.2838  19.1802 0004444  93.8351 262.9925  0.99047483 18136
0 HISPASAT 1B
1 22723U 93048A   24187.46488111 -.00000102  00000-0  00000-0 0  9999
2 22723  13.1408  18.1307 0006713  32.4386 305.1752  0.99717963112736
0 INSAT 2B
1 22724U 93048B   24186.99493713 -.00000300  00000-0  00000-0 0  9991
2 22724  14.2266   7.8760 0016541 190.3681  45.0500  0.99982295113454
0 ARIANE 44L+ R/B
1 22725U 93048C   24187.12069368  .00001515  00000-0  13078-2 0  9992
2 22725   7.1684   9.6652 6914174 210.4796  79.3512  2.70197376293659
0 IABS R/B
1 22738U 93046C   24185.96169256 -.00000258  00000-0  00000-0 0  9994
2 22738  13.1205 342.3141 0088423 125.1188 235.7294  1.02140911 19040
0 NOAA 13
1 22739U 93050A   24187.48235310  .00000188  00000-0  12262-3 0  9991
2 22739  98.6068 144.2923 0009686   8.5554 351.5782 14.13232766592836
0 SL-6 R/B(2)
1 22744U 93051D   24187.62155069  .00000628  00000-0  00000-0 0  9999
2 22744  68.7136 351.4673 6338619  94.5944 335.3193  2.05605008230606
0 NAVSTAR 34 (USA 94)
1 22779U 93054A   24186.30148519  .00000045  00000-0  00000-0 0  9999
2 22779  53.5508 243.6267 0051703 242.6611 118.0316  1.89129710222546
0 METEOR 2-21
1 22782U 93055A   24187.63057696  .00000032  00000-0  14990-4 0  9999
2 22782  82.5497 139.6258 0023523  47.5937 125.0964 13.83934675557623
0 TEMISAT
1 22783U 93055B   24187.38582374  .00000051  00000-0  32663-4 0  9996
2 22783  82.5517 142.7460 0023924  48.2060 312.1138 13.83809317557263
0 SL-14 R/B
1 22784U 93055C   24187.42716359  .00000031  00000-0  14675-4 0  9995
2 22784  82.5508 144.3887 0023248  60.2642  54.7682 13.83497023557309
0 UFO 2 (USA 95)
1 22787U 93056A   24186.10327170  .00000116  00000-0  00000-0 0  9999
2 22787  11.6610   7.2878 0003248  90.0129 251.2061  1.00276243111390
0 ACTS
1 22796U 93058B   24187.53097784 -.00000121  00000-0  00000-0 0  9991
2 22796  14.5972   0.9836 0050488  67.6516 300.9325  1.00273835119774
0 TOS R/B
1 22797U 93058D   24186.34517537  .00000541  00000-0  65397-3 0  9991
2 22797  15.5813 327.2098 7387223 315.7595   4.8027  2.12262635233200
0 COSMOS 2263
1 22802U 93059A   24187.57009310  .00000018  00000-0  35296-4 0  9995
2 22802  70.9306 308.9371 0025549 318.4513  41.4665 14.13444431588761
0 SL-16 R/B
1 22803U 93059B   24187.50444483  .00000144  00000-0  95388-4 0  9991
2 22803  70.9884 221.9437 0015226  59.3890 300.8733 14.17037311592807
0 SL-16 DEB
1 22804U 93059C   24187.31603788  .00000188  00000-0  21802-3 0  9993
2 22804  70.9735 138.8490 0208093  64.4088  49.6705 13.71740909541141
0 SL-16 DEB
1 22805U 93059D   24187.45242584  .00000129  00000-0  16453-3 0  9993
2 22805  70.9708 179.1849 0211206 125.3019  36.3815 13.70429954539830
0 SL-16 DEB
1 22806U 93059E   24187.54258557  .00000135  00000-0  16582-3 0  9991
2 22806  71.0181 119.2961 0202521 295.4359 243.2449 13.73615980543380
0 SL-16 DEB
1 22807U 93059F   24187.39448459  .00000258  00000-0  28322-3 0  9998
2 22807  71.0159 165.9689 0206517 356.4616 120.1315 13.72342975541882
0 SL-16 DEB
1 22812U 92093JB  24187.55985853  .00001718  00000-0  10319-2 0  9991
2 22812  70.6874 359.0592 0131744 353.9201   6.0307 14.04099343582924
0 SL-16 DEB
1 22816U 92093JC  24187.13581447  .00013728  00000-0  43191-2 0  9998
2 22816  71.4547 239.4601 0093030 114.0550 247.0358 14.38014234605702
0 TITAN 34D TRANSTAGE DEB
1 22818U 88077F   24186.05371154  .00003024  00000-0  70801-2 0  9995
2 22818  26.8613 121.2163 7007614  24.8647 356.5996  2.54683719 45840
0 SPOT 3
1 22823U 93061A   24187.60988943  .00000251  00000-0  14027-3 0  9990
2 22823  98.9591 236.0877 0017803 118.8300 241.4665 14.19678102593591
0 STELLA
1 22824U 93061B   24187.60507196 -.00000014  00000-0  12999-4 0  9993
2 22824  98.8772 234.1764 0007069 138.1101 344.0106 14.27427132603252
0 EYESAT A
1 22825U 93061C   24187.37361665  .00000198  00000-0  93214-4 0  9998
2 22825  98.7874 240.3380 0008923  32.8206 327.3529 14.30516212605217
0 ITAMSAT
1 22826U 93061D   24187.41723771  .00000222  00000-0  10167-3 0  9997
2 22826  98.7823 240.2464 0009165  18.0021 342.1484 14.30899641605501
0 HEALTHSAT 1
1 22827U 93061E   24187.40744939  .00000296  00000-0  12714-3 0  9997
2 22827  98.7377 243.5555 0008172 326.7789  46.2470 14.31939146606201
0 KITSAT B
1 22828U 93061F   24187.59531629  .00000253  00000-0  11268-3 0  9994
2 22828  98.7852 239.7367 0009345 340.4282  19.6541 14.31273943573990
0 POSAT 1
1 22829U 93061G   24187.58836539  .00000204  00000-0  93951-4 0  9998
2 22829  98.7647 240.9010 0008994 324.4241  35.6341 14.31493172606225
0 ARIANE 40 R/B
1 22830U 93061H   24187.44406150  .00000355  00000-0  14823-3 0  9994
2 22830  98.5707 254.8558 0009707 296.4551  63.5636 14.32150027606449
0 RADUGA 30
1 22836U 93062A   24187.02035443 -.00000155  00000-0  00000-0 0  9996
2 22836  14.3384 352.4357 0000863 287.0449  90.3782  1.00262091 38861
0 SL-12 R/B(2)
1 22839U 93062D   24186.98710602 -.00000021  00000-0  00000-0 0  9992
2 22839  14.2813 352.1780 0011371  88.5056 265.0292  1.00153325111713
0 SL-8 DEB
1 22840U 91009CK  24185.35803657  .00000468  00000-0  34754-2 0  9995
2 22840  73.9549 159.9790 0170260 104.2785  45.7758 12.39296250441192
0 SL-8 DEB
1 22841U 91009CL  24185.68505795 -.00000018  00000-0 -39171-4 0  9997
2 22841  74.0439 280.9762 0129367 113.3325  37.5636 12.22956297487493
0 SL-8 DEB
1 22842U 91009CM  24187.19931470  .00000060  00000-0  58267-3 0  9990
2 22842  73.8830 116.9092 0137900 238.1047 239.5847 12.36368907502169
0 SL-8 DEB
1 22843U 91009CN  24183.58848424  .00000330  00000-0  23624-2 0  9994
2 22843  74.0231 232.1825 0238591  59.6332  91.5826 12.39107025404185
0 DELTA 2 DEB
1 22849U 92089D   24187.23554257  .00440138  29889-6  33514-3 0  9999
2 22849  34.8270 231.2284 0452160 256.8824  98.1066 15.27913401404614
0 ARIANE 44L+ DEB
1 22850U 92021E   24187.18882495 -.00000122  00000-0  52765-2 0  9991
2 22850   3.1169 175.8743 7034359 135.6731 354.1592  2.24793978256363
0 INTELSAT 701
1 22871U 93066A   24187.19860576  .00000084  00000-0  00000-0 0  9990
2 22871   9.3276  52.2777 0004982  58.4581 295.1662  0.99317613112029
0 NAVSTAR 35 (USA 96)
1 22877U 93068A   24187.29447292 -.00000110  00000-0  00000-0 0  9996
2 22877  55.5824   2.1162 0009916 119.7779  56.1312  1.88540868223031
0 GORIZONT 28
1 22880U 93069A   24187.26021557 -.00000303  00000-0  00000-0 0  9994
2 22880  14.4119 353.2386 0034839 152.0136  24.3264  0.99659452112034
0 SL-12 R/B(2)
1 22883U 93069D   24186.95014705 -.00000195  00000-0  00000-0 0  9998
2 22883  14.1989 352.0153 0004885  80.3264 270.8708  1.00504433111908
0 COSMOS 2266
1 22888U 93070A   24187.56292731  .00000084  00000-0  71757-4 0  9997
2 22888  82.9499 247.8681 0048392  15.0640  95.4086 13.75066277536458
0 SL-8 R/B
1 22889U 93070B   24187.54469251  .00000010  00000-0 -49511-5 0  9993
2 22889  82.9445 201.3175 0049122 208.0580 151.7929 13.78117900542050
0 GORIZONT 29
1 22907U 93072A   24187.11299519  .00000113  00000-0  00000-0 0  9995
2 22907  14.3061 352.6186 0008211 359.2275   9.6899  1.00130132112043
0 SL-12 R/B(2)
1 22910U 93072D   24186.75168536 -.00000086  00000-0  00000-0 0  9992
2 22910  13.1898 348.5695 0021166 150.9984  15.8566  1.03162718115409
0 SOLIDARIDAD 1
1 22911U 93073A   24187.60934866 -.00000146  00000-0  00000-0 0  9993
2 22911  14.1635   7.6742 0004956 189.7357 204.6036  1.00271464110735
0 METEOSAT 6
1 22912U 93073B   24187.05257759 -.00000267  00000-0  00000-0 0  9996
2 22912  14.3073   6.3442 0007364 188.1130  77.2688  0.98986032109965
0 ARIANE 44LP+ R/B
1 22913U 93073C   24187.39086460  .00141275 -34429-5  21764-2 0  9997
2 22913   6.7360 155.5058 2698681  30.2231 342.9407 10.07738305632342
0 USA 97
1 22915U 93074A   24187.12545891 -.00000043  00000-0  00000-0 0  9997
2 22915  13.1246  20.3219 0006224  31.8866 319.1424  0.98533658 17886
0 IABS R/B
1 22916U 93074B   24186.91181160 -.00000249  00000-0  00000-0 0  9997
2 22916  14.2880 347.3661 0065997  93.0312 267.7373  0.99975848 18787
0 COSMOS 1934 DEB
1 22919U 88023D   24187.03608291  .00001257  00000-0  95931-3 0  9990
2 22919  82.9466 187.3111 0033005 191.1184 225.6766 13.92562671708155
0 NATO 4B
1 22921U 93076A   24186.25612027 -.00000228  00000-0  00000-0 0  9990
2 22921  12.7959   5.1418 0003989 103.9484 255.3829  0.98519766111589
0 DELTA 2 R/B(2)
1 22923U 93076C   24185.60563137 -.00000109  00000-0  19738-2 0  9995
2 22923  22.9202 140.5623 7081448 194.0369 355.8269  2.24119036250375
0 TELSTAR 401
1 22927U 93077A   24187.46351991 -.00000166  00000-0  00000-0 0  9992
2 22927  14.6418 356.2879 0012586 128.8770 227.3290  1.00279846111435
0 DIRECTV 1 (DBS 1)
1 22930U 93078A   24187.41735594 -.00000266  00000-0  00000-0 0  9998
2 22930  10.8997  39.1807 0008308 152.5508  46.2918  0.98988761118977
0 THAICOM 1
1 22931U 93078B   24187.03374679 -.00000217  00000-0  00000-0 0  9996
2 22931  10.6793  40.0636 0004608 149.8575  47.6174  0.99183044 39101
0 MOLNIYA 1-87
1 22949U 93079A   24181.90423013 -.00001029  00000-0  00000-0 0  9995
2 22949  64.9174   4.6472 6974104 277.9628  14.4175  2.02855019 90018
0 SL-6 R/B(2)
1 22952U 93079D   24185.58002831  .00000763  00000-0  00000-0 0  9991
2 22952  64.7209 297.1082 6859243 272.4696  17.2868  2.06879944230008
0 GALS 1
1 22963U 94002A   24187.51293369 -.00000362  00000-0  00000-0 0  9999
2 22963  14.6140 359.2525 0011910 194.6107  19.6761  1.00327784111578
0 SL-12 R/B(2)
1 22966U 94002D   24186.93035613 -.00000292  00000-0  00000-0 0  9995
2 22966  14.3698 349.2940 0045457 129.9434 102.0665  0.99471116109992
0 METEOR 3-6
1 22969U 94003A   24187.58168978  .00000136  00000-0  32013-3 0  9990
2 22969  82.5610 229.6210 0015161 181.6172 178.4904 13.17032952463564
0 SL-14 R/B
1 22970U 94003B   24187.56943235 -.00000023  00000-0 -92225-4 0  9996
2 22970  82.5608 229.4747 0016195 179.9927 292.9009 13.16990776463319
0 TUBSAT B
1 22971U 94003C   24187.60231799  .00000154  00000-0  36768-3 0  9999
2 22971  82.5609 228.2726 0016446 175.9254 305.5242 13.17122160463396
0 VEP
1 22979U 94007B   24185.25758270  .00000139  00000-0  45686-3 0  9990
2 22979  28.5800 268.4055 7233438 252.7285  22.4297  2.25781279250168
0 H-2 R/B
1 22980U 94007C   24187.55279980  .00004234  00000-0  18605-2 0  9993
2 22980  28.2619 149.4034 6689803  61.7135 349.2118  3.02717705304950
0 RADUGA 1-3
1 22981U 94008A   24187.63401784 -.00000319  00000-0  00000-0 0  9992
2 22981  14.4546 353.5522 0004270 142.3602 114.1345  1.00300308111348
0 SL-12 R/B(2)
1 22984U 94008D   24187.01809181 -.00000043  00000-0  00000-0 0  9994
2 22984  15.2931 356.3961 0024503  52.8406 319.2822  0.97963691108657
0 USA 99
1 22988U 94009A   24187.08938084 -.00000213  00000-0  00000-0 0  9990
2 22988  16.5369  35.2655 0001748  86.6929 103.7905  1.00271119 25821
0 TITAN 4 CENTAUR R/B
1 22989U 94009B   24186.91690521 -.00000281  00000-0  00000-0 0  9998
2 22989  15.9129  29.8475 0012226 207.8118 152.1373  1.00586238 18121
0 SJ-4
1 22996U 94010A   24187.01891876  .00000701  00000-0  37332-3 0  9993
2 22996  28.9684 149.6126 5569519   4.2773 358.9054  4.63285225414368
0 COSMOS 2268
1 22999U 94011A   24187.18166073  .00000045  00000-0  19492-3 0  9997
2 22999  82.5762  74.0234 0010762  17.4143 138.6883 12.61198162399004
0 COSMOS 2269
1 23000U 94011B   24187.61608429  .00000054  00000-0  24563-3 0  9990
2 23000  82.5673  55.4774 0007441   9.7491  48.4993 12.61916021399924
0 COSMOS 2270
1 23001U 94011C   24187.62120381  .00000047  00000-0  19975-3 0  9991
2 23001  82.5729  48.6697 0007542   1.2701  65.8974 12.62904209400839
0 COSMOS 2271
1 23002U 94011D   24187.54138040  .00000046  00000-0  19270-3 0  9991
2 23002  82.5652  33.1308 0007357  15.3524 344.7790 12.63492105401616
0 COSMOS 2272
1 23003U 94011E   24187.55480695  .00000038  00000-0  14683-3 0  9993
2 23003  82.5717  27.5533 0011386 338.4983  21.5630 12.64371403402499
0 COSMOS 2273
1 23004U 94011F   24187.57041039  .00000046  00000-0  19889-3 0  9993
2 23004  82.5740  49.8237 0005596  14.4877  48.3276 12.62888258400921
0 SL-14 R/B
1 23005U 94011G   24187.40256088 -.00000010  00000-0 -12084-3 0  9991
2 23005  82.5776 151.2126 0040017 265.4883 208.4255 12.55211482392453
0 SL-8 DEB
1 23007U 93036C   24187.57187162  .00002061  00000-0  59830-3 0  9999
2 23007  74.0275   5.4269 0011528 132.4715 300.7261 14.44942465627383
0 RADUGA 31
1 23010U 94012A   24187.05418082  .00000100  00000-0  00000-0 0  9993
2 23010  14.4211 353.5665 0005210 132.6201 220.8489  1.00266140111205
0 SL-12 R/B(2)
1 23013U 94012D   24186.99023883 -.00000041  00000-0  00000-0 0  9994
2 23013  15.2044 356.2405 0036680 108.6128 258.3048  0.98106580108759
0 GALAXY 1R
1 23016U 94013A   24187.52014184 -.00000219  00000-0  00000-0 0  9999
2 23016  12.0401  27.3295 0001368  98.1461  98.1142  0.99221619 39126
0 DELTA 2 R/B(2)
1 23018U 94013C   24186.81475601  .00000042  00000-0  00000-0 0  9990
2 23018  25.7937   4.7423 6473063 356.4137   0.5151  2.02374979224325
0 NAVSTAR 36 (USA 100)
1 23027U 94016A   24187.59771418 -.00000076  00000-0  00000-0 0  9992
2 23027  53.7708 299.4793 0032815 204.5754 153.9705  1.86674471219933
0 TITAN 34D TRANSTAGE DEB
1 23038U 88077H   24186.61834369  .00004806  00000-0  45938-2 0  9996
2 23038  27.1206 350.4339 6893583 255.8028  24.3967  2.73036091 46737
0 TITAN 34D TRANSTAGE DEB
1 23039U 88077J   24186.85751775 -.00000759  00000-0  27724-2 0  9999
2 23039  27.5125 337.0826 7359870 265.8007  15.5973  2.03583566 36688
0 TITAN 34D TRANSTAGE DEB
1 23040U 88077K   24186.58266627  .00000246  00000-0  67125-3 0  9998
2 23040  26.6844 271.9317 7308221 255.7584  20.1244  2.18070745 41248
0 TITAN 34D TRANSTAGE DEB
1 23041U 88077L   24186.34883892  .00001016  00000-0  27491-2 0  9999
2 23041  26.6702 265.1845 7279799 266.6182  15.9511  2.20793354 40907
0 COSMOS 2276 (GLONASS)
1 23043U 94021A   24184.64752420 -.00000084  00000-0  00000-0 0  9990
2 23043  64.4500 326.0462 0018546 186.8173 170.6262  2.13099102235005
0 COSMOS 2277 (GLONASS)
1 23044U 94021B   24186.76569987 -.00000086  00000-0  00000-0 0  9992
2 23044  64.4373 325.8404 0057007 211.1525 148.9030  2.13104084235237
0 COSMOS 2275 (GLONASS)
1 23045U 94021C   24186.58138190 -.00000086  00000-0  00000-0 0  9991
2 23045  64.4262 325.7450 0027086  35.1779  12.9419  2.13101416235040
0 SL-12 R/B(2)
1 23048U 94021F   24182.88713383 -.00000073  00000-0  00000-0 0  9992
2 23048  64.4302 325.2138 0013222 225.4826 135.3071  2.13315652235458
0 GOES 8
1 23051U 94022A   24187.02896056 -.00000086  00000-0  00000-0 0  9991
2 23051  13.8168  18.9116 0006380  68.9997 123.6296  0.98903861117081
0 COSMOS 2278
1 23087U 94023A   24187.57818066  .00000060  00000-0  56448-4 0  9998
2 23087  71.0530  15.5281 0010711 247.1406 112.8586 14.14102429558269
0 SL-16 R/B
1 23088U 94023B   24187.56718021  .00000364  00000-0  21308-3 0  9991
2 23088  71.0002 276.2692 0002869 185.7568 174.3522 14.14854681559502
0 SL-16 DEB
1 23089U 94023C   24187.29567561  .00000065  00000-0  10043-3 0  9995
2 23089  71.0241  38.6203 0200127 253.8507 104.0485 13.73995719513851
0 SL-16 DEB
1 23090U 94023D   24187.58144564  .00000192  00000-0  21342-3 0  9998
2 23090  71.0331 353.9380 0192250 180.1767 179.9301 13.75367337515412
0 SL-16 DEB
1 23091U 94023E   24187.63013609  .00000096  00000-0  12876-3 0  9995
2 23091  70.9827   7.3731 0202817 340.3403  84.1545 13.73520727513359
0 COSMOS 2279
1 23092U 94024A   24187.58554948  .00000104  00000-0  89476-4 0  9998
2 23092  82.9487  22.8508 0036576  82.4610 278.0700 13.76530978516150
0 SL-8 R/B
1 23093U 94024B   24187.52495575  .00000156  00000-0  14020-3 0  9992
2 23093  82.9460 358.4770 0009821 353.1151   6.9870 13.78083366985839
0 SL-16 DEB
1 23094U 94023F   24187.58420147  .00000075  00000-0  10897-3 0  9999
2 23094  70.9880 355.5865 0202296 294.2562 128.3371 13.74074460513808
0 STEP 2
1 23105U 94029A   24187.53940630  .00005189  00000-0  59348-3 0  9992
2 23105  81.9401 176.4790 0096806  66.3140 294.8195 14.82439931614103
0 PEGASUS R/B
1 23106U 94029B   24187.59183986  .00001631  00000-0  22502-3 0  9992
2 23106  81.9586 247.5370 0118211 251.6830 107.1489 14.72899245610365
0 GORIZONT 30
1 23108U 94030A   24187.18807603 -.00000061  00000-0  00000-0 0  9993
2 23108  14.3479 353.5118 0002957 199.8911 155.4442  1.00252643110315
0 SL-12 R/B(2)
1 23111U 94030D   24187.20257696 -.00000073  00000-0  00000-0 0  9994
2 23111  13.0369 348.6873 0047590 170.4720 171.3256  1.03837641114269
0 METEOSAT 6 AKM
1 23118U 93073E   24187.12363144  .00000103  00000-0  00000-0 0  9997
2 23118  14.5292 352.4612 0070002  94.0684 276.4277  0.99987434 40094
0 INTELSAT 702
1 23124U 94034A   24186.90334870 -.00000006  00000-0  00000-0 0  9994
2 23124   9.5762  50.6924 0015359  30.0939 204.8838  0.98938927123831
0 STRV 1A
1 23125U 94034B   24186.76159801  .00001745  00000-0  59759-3 0  9996
2 23125   7.5854   1.2583 6461946   6.1442 358.9743  3.35261321309980
0 ARIANE 44LP+ R/B
1 23127U 94034D   24186.71550200  .00000287  00000-0  17822-2 0  9995
2 23127   7.0979 232.1129 7215702 294.9599   8.8687  2.25927683245484
0 TITAN 34D TRANSTAGE DEB
1 23130U 88077M   24187.16095003 -.00000508  00000-0 -83797-2 0  9996
2 23130  26.9851 272.4885 7263542 102.3387 340.4889  2.00316477 36758
0 UFO 3 (USA 104)
1 23132U 94035A   24187.54317200 -.00000373  00000-0  00000-0 0  9990
2 23132  12.0567   9.8051 0002937 142.7552  94.8596  1.00211376124564
0 USA 40 R/B DEB
1 23159U 89061N   24187.28088659  .00080740  00000-0  21265-1 0  9998
2 23159  56.9470 183.2395 2105598  39.6546 334.0723 10.81688331177058
0 COSMOS 2282
1 23168U 94038A   24187.05813194 -.00000226  00000-0  00000-0 0  9998
2 23168  13.9992 357.8060 0009819 115.1919 165.1761  1.00266963109862
0 SL-12 R/B(2)
1 23171U 94038D   24186.43869139 -.00000189  00000-0  00000-0 0  9991
2 23171  14.3025 359.0122 0027431 130.0001 238.7183  0.99428127108930
0 INTELSAT 2 (PAS 2)
1 23175U 94040A   24187.41735649 -.00000258  00000-0  00000-0 0  9992
2 23175  10.9876  40.0304 0006601  56.7461 142.2484  0.99196914108589
0 BS-3N
1 23176U 94040B   24186.45915093 -.00000170  00000-0  00000-0 0  9992
2 23176  12.5667  24.9574 0005093  55.3179 298.6757  0.99150796 95235
0 ARIANE 44L+ R/B
1 23177U 94040C   24187.18134881  .00000991  00000-0  28631-2 0  9994
2 23177   7.7224  45.0552 7193907 109.7821 335.5845  2.31375196247877
0 NADEZHDA 4
1 23179U 94041A   24187.56936039  .00000080  00000-0  65846-4 0  9994
2 23179  82.9456 195.4741 0033723 281.4582 196.9033 13.76696885505603
0 SL-8 R/B
1 23180U 94041B   24187.49109929  .00000167  00000-0  15080-3 0  9998
2 23180  82.9462 174.5221 0028239 200.4200 274.5814 13.78171142507177
0 APSTAR 1
1 23185U 94043A   24186.61854909  .00000003  00000-0  00000-0 0  9995
2 23185  12.5850  22.8135 0005627  61.1727 139.5989  0.99372876 37990
0 COSMOS 2285
1 23189U 94045A   24187.51456830  .00000038  00000-0  65918-4 0  9993
2 23189  74.0269 209.5920 0025256   0.1388 109.5547 13.72423914498750
0 SL-8 R/B
1 23190U 94045B   24187.34052243 -.00000025  00000-0 -30742-5 0  9992
2 23190  74.0282 154.8992 0020224 278.3389  81.5437 13.74244337500694
0 DIRECTV 2 (DBS 2)
1 23192U 94047A   24187.19764852 -.00000018  00000-0  00000-0 0  9995
2 23192  11.8989  31.4682 0007110   0.9375   8.4873  0.98633083118642
0 COSMOS 2286
1 23194U 94048A   24187.31976341 -.00000678  00000-0  00000-0 0  9992
2 23194  66.9814 192.0296 5843450 134.1310 292.0938  2.00724107219194
0 SL-6 R/B(2)
1 23197U 94048D   24186.42256045 -.00000363  00000-0  00000-0 0  9999
2 23197  67.7805 174.8168 5345285 109.5396 311.9632  2.03854834222713
0 APEX R/B
1 23198U 94046B   24187.59081565  .00011328  00000-0  47207-3 0  9995
2 23198  69.9477 289.3700 0756169 294.2974  58.0973 14.01005718446246
0 BRAZILSAT B1
1 23199U 94049A   24186.33068207 -.00000156  00000-0  00000-0 0  9993
2 23199  11.6901  31.7249 0006112 130.4149 244.4529  0.99251671 39138
0 TURKSAT 1B
1 23200U 94049B   24186.96280029 -.00000219  00000-0  00000-0 0  9993
2 23200  13.0033  21.5174 0020441  97.4462  95.8231  0.99048012108248
0 ARIANE 44LP+ R/B
1 23201U 94049C   24187.38785435  .00001132  00000-0  15390-2 0  9996
2 23201   7.4155 330.8078 7147728 338.3605   2.3900  2.40013841251404
0 COSMOS 2287 (GLONASS)
1 23203U 94050A   24183.96123595  .00000088  00000-0  00000-0 0  9992
2 23203  65.4292 225.4425 0010729  21.9819 335.7885  2.13101314232601
0 COSMOS 2289 (GLONASS)
1 23204U 94050B   24186.95895178  .00000080  00000-0  00000-0 0  9990
2 23204  65.4176 225.2131 0009358 320.1793  39.8372  2.13102138232491
0 COSMOS 2288 (GLONASS)
1 23205U 94050C   24183.09349333  .00000082  00000-0  00000-0 0  9992
2 23205  65.4236 225.4102 0002066 295.3806  64.9723  2.13101298232570
0 SL-12 R/B(2)
1 23208U 94050F   24187.47123828  .00000075  00000-0  00000-0 0  9992
2 23208  65.4293 224.0209 0035527 203.2704 162.2367  2.13430090233068
0 OPTUS B3
1 23227U 94055A   24187.12763447  .00000012  00000-0  00000-0 0  9998
2 23227  11.2383  35.3283 0006847  39.1727 308.4988  0.98694945108883
0 OPTUS B3 PKM
1 23229U 94055C   24186.49401083  .00000450  00000-0  95996-3 0  9991
2 23229  23.3713 261.6548 7361662  53.6061 353.5872  2.12968862229058
0 ETS 6
1 23230U 94056A   24187.61625411 -.00000098  00000-0  00000-0 0  9990
2 23230  13.8683 296.4936 4997709  74.0725   5.3143  1.67087498182355
0 DMSP 5D-2 F12 (USA 106)
1 23233U 94057A   24187.57515753  .00000087  00000-0  66473-4 0  9993
2 23233  98.7755 241.5662 0011648 144.2759 215.9196 14.15873692541261
0 ARIANE 44L+ DEB
1 23237U 92021G   24187.24367882 -.00000179  00000-0  26759-3 0  9993
2 23237   3.1539 163.5936 7032091 167.0158 355.2967  2.24995174249716
0 ARIANE 44L+ DEB
1 23238U 92021H   24187.19538593  .00000152  00000-0  20849-1 0  9999
2 23238   3.5138 249.7350 7014669 358.5391  48.2818  2.24420765266183
0 ARIANE 44L+ DEB
1 23239U 92021J   24187.51587922 -.00000152  00000-0  00000-0 0  9993
2 23239   4.0256 339.5432 6984207 181.2407 174.0069  2.23795987253072
0 ARIANE 44L+ DEB
1 23240U 92021K   24187.52028013 -.00000207  00000-0  00000-0 0  9998
2 23240   4.0203   4.9527 6988214 133.3890 141.4988  2.23446016247897
0 ARIANE 44L+ DEB
1 23241U 92021L   24187.32626545 -.00000245  00000-0 -43973-2 0  9992
2 23241   3.0619 175.5030 7031461 147.1562 358.9807  2.24656587248023
0 ARIANE 44L+ DEB
1 23242U 92021M   24187.26122663 -.00000028  00000-0  63858-2 0  9990
2 23242   3.1623 225.7482 7041113  46.0864 354.2824  2.24575163101000
0 ARIANE 2 DEB
1 23243U 89027C   24186.42542834  .00000536  00000-0  78914-2 0  9998
2 23243   3.2250 354.8439 7196601 210.9189  73.8724  2.21223093 38763
0 ARIANE 44L+ DEB
1 23244U 92021N   24186.99519912 -.00000042  00000-0  00000-0 0  9992
2 23244   4.2241 262.7761 6867905 318.0239 134.2469  2.21517050243335
0 ARIANE 44L+ DEB
1 23245U 92021P   24186.76255669 -.00000036  00000-0  00000-0 0  9997
2 23245   3.8596 294.7612 6977359 274.4562  15.9632  2.24989995 99861
0 TITAN 4 CENTAUR R/B
1 23247U 94054B   24186.06765458  .00000026  00000-0  00000-0 0  9990
2 23247  12.3304 358.3176 0112623 338.3576  21.1740  0.99581254 18429
0 ETS 6 DEB
1 23248U 94056C   24187.41303240 -.00000077  00000-0  00000-0 0  9997
2 23248  11.5809 216.0434 5266068 227.0253 106.7381  1.70301412185581
0 DMSP 5D-2 F12 DEB
1 23250U 94057D   24187.60483545  .00012828  00000-0  24649-2 0  9992
2 23250  98.1145 214.0995 0002670 298.7175 183.1967 14.63777761562485
0 CZ-4 DEB
1 23254U 90081CK  24187.12901509  .00001778  00000-0  57581-3 0  9995
2 23254  98.5607 241.5184 0068974 182.1938 205.5119 14.38889106575136
0 CZ-4 DEB
1 23258U 90081CP  24187.44926062  .00000919  00000-0  46280-3 0  9995
2 23258  98.6427 178.8372 0020938 301.6903  58.2231 14.18675867658641
0 CZ-4 DEB
1 23259U 90081CQ  24186.94370579  .00001758  00000-0  69082-3 0  9993
2 23259  98.5220 184.6817 0016696 300.5406  59.4129 14.30461016708225
0 CZ-4 DEB
1 23260U 90081CR  24186.58623083  .20998986  27573-5  53067-2 0  9990
2 23260  97.8822 214.8374 0017296 245.7646 114.1838 16.28511843737113
0 CZ-4 DEB
1 23261U 90081CS  24187.50778384  .00009106  00000-0  21161-2 0  9995
2 23261  98.2856 202.3359 0020874  22.0917 132.1232 14.55011806738395
0 SL-8 DEB
1 23263U 91009CU  24185.96240943  .00000015  00000-0  29346-3 0  9995
2 23263  74.1312  17.4992 0167713  99.6558  53.7199 12.10802198354160
0 SL-8 DEB
1 23265U 91009CW  24186.32618124  .00000460  00000-0  38964-2 0  9997
2 23265  73.9965 134.0943 0162196  71.1364  81.8875 12.29409146492246
0 COSMOS 2291
1 23267U 94060A   24187.45548238 -.00000083  00000-0  00000-0 0  9992
2 23267  14.3879 354.9713 0007694 182.6501 156.2209  1.00385999109059
0 SL-12 R/B(2)
1 23270U 94060D   24187.36229616 -.00000271  00000-0  00000-0 0  9991
2 23270  14.4766 355.4061 0011180 132.8684 214.0743  1.00065263108419
0 SL-16 DEB
1 23275U 92093JF  24186.76827559  .00000497  00000-0  36617-3 0  9998
2 23275  71.2451 201.2141 0104565  15.4227 345.0032 13.97543285561606
0 COSMOS 2292
1 23278U 94061A   24187.51581925  .00005353  00000-0  45639-3 0  9996
2 23278  82.9749  78.6858 0846704 345.1592  12.6021 13.64201317460698
0 SL-8 R/B
1 23279U 94061B   24187.42458920  .00017528  00000-0  99685-3 0  9992
2 23279  82.9676 153.3168 0667954  17.6651 344.6577 14.11360025484480
0 SL-16 DEB
1 23282U 92093JG  24187.52605005  .00008822  00000-0  27062-2 0  9994
2 23282  71.1808 236.0950 0069345  46.0591  75.7112 14.40479864571015
0 SL-12 DEB
1 23292U 85118P   24186.38345349  .00001764  00000-0  13479-2 0  9995
2 23292  65.0804 230.2911 5621185 329.7890   7.3507  4.50867431508291
0 SL-12 DEB
1 23294U 85118R   24185.24143363  .00001624  00000-0  46383-2 0  9998
2 23294  65.2372 329.3145 5405772  80.0773 357.1784  4.69570289  6202
0 SL-16 DEB
1 23302U 92093JH  24187.42409247  .00002233  00000-0  12023-2 0  9997
2 23302  71.1252 186.4760 0122096 315.1514 194.2891 14.10114050553714
0 NSS 703 (INTELSAT 703)
1 23305U 94064A   24187.46403645 -.00000270  00000-0  00000-0 0  9990
2 23305  10.4359  42.2287 0003328 241.6690 328.3037  0.99308584108669
0 COSMOS 700 DEB
1 23308U 74105C   24187.23990786  .00001581  00000-0  11971-2 0  9995
2 23308  82.9434  92.2169 0023132  48.7176 108.6851 13.93263923577572
0 DELTA 1 DEB
1 23309U 75052JY  24187.18871435  .00000290  00000-0  11716-2 0  9994
2 23309  99.6855 153.5942 0389647 190.3134 295.2380 12.71950678535411
0 DELTA 1 DEB
1 23310U 75052JZ  24187.21568125  .00000202  00000-0  74004-3 0  9992
2 23310  99.8707 341.0018 0321625 244.9218 296.2536 12.89630696493163
0 SOLIDARIDAD 2
1 23313U 94065A   24187.52459904 -.00000205  00000-0  00000-0 0  9994
2 23313  11.2001  36.3838 0004573  45.8491 150.4305  0.98865175108309
0 THAICOM 2
1 23314U 94065B   24187.19660425  .00000091  00000-0  00000-0 0  9992
2 23314  10.1484  44.0947 0003505 112.3122 238.7195  0.99588764 39278
0 OKEAN 4
1 23317U 94066A   24187.57983289  .00002366  00000-0  22946-3 0  9997
2 23317  82.5342 212.6216 0019431 140.7275 219.5359 14.92131451609006
0 SL-14 R/B
1 23318U 94066B   24187.58698278  .00000698  00000-0  89029-4 0  9992
2 23318  82.5420 299.4354 0024730  83.0913 277.3112 14.79896933603052
0 EXPRESS 1
1 23319U 94067A   24187.19016457 -.00000057  00000-0  00000-0 0  9992
2 23319  14.3151   7.2878 0005206 192.7662 160.3792  0.99831656108467
0 SL-12 R/B(2)
1 23322U 94067D   24187.12041160  .00000066  00000-0  00000-0 0  9997
2 23322  14.2667 350.2201 0010490 129.5637 224.5876  1.00213549108862
0 IRS P2
1 23323U 94068A   24187.60882858  .00000198  00000-0  10584-3 0  9996
2 23323  98.9856 214.3114 0001152  87.6751 272.4558 14.24252643543759
0 IRS P2 R/B
1 23324U 94068B   24187.40750115  .00000100  00000-0  70549-4 0  9996
2 23324  98.9326 250.5610 0057841 143.5227 216.9909 14.17152427536713
0 ELEKTRO (GOMS)
1 23327U 94069A   24186.98997777 -.00000182  00000-0  00000-0 0  9991
2 23327  14.7226 354.7550 0007038 221.3164 145.1386  1.00280865108734
0 SL-12 R/B(2)
1 23330U 94069D   24187.46435781 -.00000152  00000-0  00000-0 0  9998
2 23330  14.7208 354.7997 0025332 134.4206 225.5090  1.00097238108523
0 ASTRA 1D
1 23331U 94070A   24186.32850650 -.00000222  00000-0  00000-0 0  9999
2 23331  11.2210  33.5993 0008418  95.0042 266.2558  0.98953059108892
0 RESURS O1
1 23342U 94074A   24187.56848736  .00001990  00000-0  25574-3 0  9992
2 23342  97.7274 220.4164 0000907 108.5736 251.5576 14.82235642598388
0 SL-16 R/B
1 23343U 94074B   24187.62078398  .00000781  00000-0  11474-3 0  9990
2 23343  97.7862 229.9794 0007907  58.9080  59.5429 14.78136706596783
0 RESURS O1 DEB
1 23344U 94074C   24187.62304505  .00002251  00000-0  46321-3 0  9996
2 23344  97.9972 213.1046 0123288 144.6497 334.2795 14.56783896569502
0 RESURS O1 DEB
1 23345U 94074D   24187.55635598  .00000685  00000-0  21966-3 0  9995
2 23345  97.8276  43.4205 0193313 164.9392 262.0954 14.32114140545823
0 RESURS O1 DEB
1 23346U 94074E   24187.22255127  .00000927  00000-0  28196-3 0  9997
2 23346  98.4688 285.1790 0175629  47.8146 313.7802 14.35912047548899
0 RESURS O1 DEB
1 23347U 94074F   24187.51870713  .00001960  00000-0  42586-3 0  9991
2 23347  97.8753 282.6707 0128138 226.5385 145.4470 14.54129601566483
0 USA 40 R/B DEB
1 23351U 89061X   24186.14108728  .00014195  00000-0  75178-2 0  9990
2 23351  56.9507 243.5742 2373931 355.3394   2.8443 10.13025522193538
0 USA 40 R/B DEB
1 23353U 89061Z   24186.79887637  .00016919  00000-0  12633-1 0  9998
2 23353  56.9864  72.5424 2910833   8.9990 355.3084  9.04903861  7736
0 USA 40 R/B DEB
1 23354U 89061AA  24187.53951863  .00012923  00000-0  11748-1 0  9992
2 23354  56.9857 295.2193 3095262  80.8680 312.4468  8.67010153168416
0 USA 40 R/B DEB
1 23356U 89061AC  24187.47462630  .00021745  00000-0  12488-1 0  9990
2 23356  56.8966 187.4210 2607772 120.3937 268.0276  9.67055459185038
0 USA 40 R/B DEB
1 23359U 89061AF  24186.93601119  .00038829  00000-0  20841-1 0  9993
2 23359  56.8970  25.8222 2361101 133.2471 249.1392 10.14989528195467
0 USA 40 R/B DEB
1 23360U 89061AG  24187.42213279  .00012881  00000-0  87013-2 0  9991
2 23360  56.9774 348.5742 3143452  77.2459 315.6861  8.65015747  8475
0 USA 40 R/B DEB
1 23361U 89061AH  24187.29524528  .00013571  00000-0  84651-2 0  9991
2 23361  56.9711 139.1788 2809627  95.9430 296.4384  9.27714132179646
0 USA 40 R/B DEB
1 23362U 89061AJ  24186.94591832  .00023547  00000-0  20624-1 0  9998
2 23362  56.8849 167.6228 2708611 329.5891  17.1869  9.37777580180567
0 USA 40 R/B DEB
1 23370U 89061AS  24187.14074447  .00094504  00000-0  34225-1 0  9991
2 23370  57.0520 344.0108 2498834 141.8689 238.8521  9.98317938188936
0 USA 40 R/B DEB
1 23372U 89061AU  24187.49832742  .00007858  00000-0  57921-2 0  9996
2 23372  56.9994 287.1479 2806511  46.1206 333.9759  9.24375504176575
0 USA 40 R/B DEB
1 23373U 89061AV  24186.59564084  .00001663  00000-0  19821-2 0  9993
2 23373  56.9726 145.9064 3050152 145.1253 239.3816  8.69057705169297
0 USA 40 R/B DEB
1 23378U 89061BA  24186.94909660  .00009965  00000-0  53487-2 0  9999
2 23378  56.9538  39.2229 3000845 226.0194 105.0764  8.95928027129883
0 USA 40 R/B DEB
1 23379U 89061BB  24187.29878499  .00010158  00000-0  65694-2 0  9993
2 23379  56.9630 221.6781 3087044 151.2664 230.0356  8.76192166169284
0 USA 40 R/B DEB
1 23380U 89061BC  24186.09190721  .00015342  00000-0  12083-1 0  9990
2 23380  57.0650 335.2418 3000030 207.2392 133.3388  8.87462651 21692
0 USA 40 R/B DEB
1 23381U 89061BD  24186.77224305  .00032201  00000-0  16831-1 0  9990
2 23381  56.9316 335.4264 2516132 191.3578 161.8176  9.86469287188578
0 USA 40 R/B DEB
1 23383U 89061BF  24186.64000179  .00010308  00000-0  52735-2 0  9997
2 23383  57.0439  45.3787 2827433 350.9601   4.9034  9.28979087176784
0 USA 40 R/B DEB
1 23385U 89061BH  24186.82962512  .00011653  00000-0  76096-2 0  9997
2 23385  57.0097   9.2575 3135792  60.9607 326.9057  8.67140014167598
0 USA 40 R/B DEB
1 23388U 89061BL  24187.36076418  .00008153  00000-0  44230-2 0  9997
2 23388  56.9707 231.2406 2527548  31.9739 341.2105  9.83608267 11044
0 USA 40 R/B DEB
1 23392U 89061BQ  24185.47484994  .00008583  00000-0  50182-2 0  9994
2 23392  56.9891 106.7013 3057551 203.7243 138.6626  8.83741548169796
0 USA 40 R/B DEB
1 23395U 89061BT  24185.93255744  .00025916  00000-0  19374-1 0  9993
2 23395  57.1020  18.5146 3047238 177.8381 183.9891  8.80087276 17829
0 COSMOS 2295 (GLONASS)
1 23396U 94076A   24183.10252661 -.00000047  00000-0  00000-0 0  9992
2 23396  64.4454  93.7987 0038584 202.5642 338.9572  2.13102604230241
0 COSMOS 2296 (GLONASS)
1 23397U 94076B   24186.68164216 -.00000045  00000-0  00000-0 0  9995
2 23397  64.4368  93.5393 0010396 259.0762 282.1759  2.13099740230306
0 COSMOS 2294 (GLONASS)
1 23398U 94076C   24185.55041640 -.00000052  00000-0  00000-0 0  9994
2 23398  64.4277  93.4208 0004103  18.9023 152.9408  2.13101847230476
0 SL-12 R/B(2)
1 23401U 94076F   24186.56749047 -.00000046  00000-0  00000-0 0  9990
2 23401  64.4601  91.6975 0012218 291.0606 254.3045  2.13555836230992
0 SL-12 R/B(AUX MOTOR)
1 23402U 94076G   24187.27863484  .00000463  00000-0  58573-3 0  9995
2 23402  64.9996 197.1078 5746474 156.0402 247.6175  4.27180220459314
0 SL-12 R/B(AUX MOTOR)
1 23403U 94076H   24187.32370524  .00000166  00000-0  35530-3 0  9998
2 23403  65.2057 213.8257 5694498 149.1342 344.8777  4.27398176460261
0 COSMOS 2297
1 23404U 94077A   24187.61030977 -.00000094  00000-0 -24778-4 0  9992
2 23404  71.0159 301.1856 0016269 206.1856 153.8445 14.13747180527970
0 SL-16 R/B
1 23405U 94077B   24187.43320270  .00000309  00000-0  18299-3 0  9998
2 23405  70.9809 200.4199 0002881 329.2885  30.8069 14.15399315529597
0 SL-16 DEB
1 23406U 94077C   24187.60754885  .00000089  00000-0  12302-3 0  9995
2 23406  71.0322   3.9073 0202703 211.6420 216.4678 13.73130763483434
0 SL-16 DEB
1 23407U 94077D   24187.58980133  .00000164  00000-0  19249-3 0  9991
2 23407  71.0348 352.9938 0199471 172.8910 261.6051 13.73471268483838
0 SL-16 DEB
1 23408U 94077E   24187.34013691  .00000093  00000-0  12979-3 0  9996
2 23408  70.9862  29.2566 0214412 315.9627 225.5050 13.71035553481137
0 SL-16 DEB
1 23409U 94077F   24187.58598210  .00000226  00000-0  18404-3 0  9995
2 23409  70.8815  38.7489 0092819 250.5872 108.5192 13.98397266510631
0 SL-16 DEB
1 23410U 94077G   24187.52538418  .00000113  00000-0  15231-3 0  9995
2 23410  70.9791 112.5133 0220451  50.7319 122.8626 13.68482256478438
0 GEO IK
1 23411U 94078A   24187.58458134  .00000001  00000-0  13755-3 0  9994
2 23411  73.6144  38.6863 0029270 290.4457 130.4990 12.40847802340798
0 SL-14 R/B
1 23412U 94078B   24187.58338480 -.00000001  00000-0  12339-3 0  9994
2 23412  73.6171  32.6549 0044081 242.1930 178.4435 12.41001631341094
0 TELSTAR 11 (ORION 1)
1 23413U 94079A   24187.19373250 -.00000105  00000-0  00000-0 0  9991
2 23413  13.1204  21.6998 0018358  26.3301 331.8178  0.98581196106938
0 DFH-3 1
1 23415U 94080A   24187.05609532 -.00000074  00000-0  00000-0 0  9990
2 23415  14.0860 349.9734 0094139   5.5612   2.0310  1.00968665128480
0 SL-16 DEB
1 23418U 94077J   24184.10119470  .00000436  00000-0  26996-3 0  9995
2 23418  71.0043 220.1687 0076780 179.4884 180.6328 14.09307971562642
0 MOLNIYA 1-88
1 23420U 94081A   24187.08428085 -.00000095  00000-0  00000-0 0  9995
2 23420  64.4389  28.2431 5903060 269.5907  26.7335  3.34492510138748
0 LUCH
1 23426U 94082A   24186.25092955 -.00000138  00000-0  00000-0 0  9991
2 23426  14.8048   0.1348 0007950 163.3781 196.6540  1.00272900108113
0 SL-12 R/B(2)
1 23429U 94082D   24186.75708075 -.00000033  00000-0  00000-0 0  9990
2 23429  14.6469 359.6641 0031321 121.8158  63.5142  1.00789718108711
0 COSMOS 2298
1 23431U 94083A   24187.58648850  .00000228  00000-0  96916-4 0  9990
2 23431  74.0301   4.3350 0015521 117.8701 242.4023 14.30758711541895
0 SL-8 R/B
1 23432U 94083B   24187.58684264  .00000215  00000-0  86338-4 0  9993
2 23432  74.0323 267.4897 0005896 222.7184 239.7089 14.33970019545135
0 COSMOS 2298 DEB
1 23433U 94083C   24187.42353873  .00001676  00000-0  51954-3 0  9993
2 23433  74.0059 176.5918 0012425 294.7745 217.5468 14.41902934547377
0 COSMOS 2298 DEB
1 23434U 94083D   24187.58149095  .00001461  00000-0  50819-3 0  9991
2 23434  74.0301 351.3910 0011469 351.8421  80.3056 14.36311469542225
0 USA 107
1 23435U 94084A   24186.30396652 -.00000206  00000-0  00000-0 0  9996
2 23435  14.5433   0.1574 0004051 239.3935  92.6787  0.99077428 25743
0 IUS R/B(2)
1 23438U 94084D   24186.31390461 -.00000152  00000-0  00000-0 0  9992
2 23438  14.2616 358.7366 0005507 124.3085 235.7507  1.01179355 19001
0 RADIO ROSTO
1 23439U 94085A   24187.56133666 -.00000049  00000-0 -17729-3 0  9999
2 23439  64.8186  14.0536 0149726 140.2520 220.9487 11.27577620215668
0 SL-19 R/B
1 23440U 94085B   24187.50169490 -.00000046  00000-0 -10980-3 0  9998
2 23440  64.8350  37.8810 0168348 117.3329 293.3938 11.27132171215409
0 COSMOS 2299
1 23441U 94086A   24187.55456175  .00000054  00000-0  23912-3 0  9990
2 23441  82.5690  32.7533 0007814  23.4792 336.6655 12.63767029361812
0 COSMOS 2300
1 23442U 94086B   24187.63340572  .00000050  00000-0  22103-3 0  9990
2 23442  82.5624  39.1364 0003316  61.1672 354.1726 12.62777949360782
0 COSMOS 2301
1 23443U 94086C   24187.61849784  .00000048  00000-0  20797-3 0  9992
2 23443  82.5714  55.1483 0001732   1.1332  57.6739 12.62196349360137
0 COSMOS 2302
1 23444U 94086D   24187.38203972  .00000044  00000-0  18831-3 0  9992
2 23444  82.5649  61.3873 0007340   1.4844 173.3013 12.61243799359083
0 COSMOS 2303
1 23445U 94086E   24187.49833137  .00000041  00000-0  17395-3 0  9998
2 23445  82.5743  78.8852 0011919  19.6335 154.0664 12.60531596358319
0 COSMOS 2304
1 23446U 94086F   24187.37366378  .00000050  00000-0  21842-3 0  9996
2 23446  82.5705  54.7593 0004256   2.4374 171.2100 12.62173619359881
0 SL-14 R/B
1 23447U 94086G   24187.61166501 -.00000014  00000-0 -14622-3 0  9990
2 23447  82.5683 134.8331 0036686 241.2031 292.2675 12.55505682352966
0 RADUGA 32
1 23448U 94087A   24187.01809208 -.00000155  00000-0  00000-0 0  9991
2 23448  14.4951 356.3132 0006499 218.4599 154.0951  1.00264775125742
0 SL-12 R/B(2)
1 23451U 94087D   24187.54635372 -.00000374  00000-0  00000-0 0  9995
2 23451  14.5171 356.3233 0012755 122.6311 131.3178  1.00083704 40154
0 NOAA 14
1 23455U 94089A   24187.55415031  .00000111  00000-0  79482-4 0  9992
2 23455  98.4321 182.5417 0008959 336.8601  23.2169 14.14406074522591
0 INTELSAT 704
1 23461U 95001A   24186.89007812 -.00000243  00000-0  00000-0 0  9997
2 23461  10.5992  41.0035 0013692 121.2764  67.0750  0.99184355107413
0 TSIKADA
1 23463U 95002A   24187.52904046  .00000058  00000-0  47416-4 0  9995
2 23463  82.9267 182.1888 0037913 318.0143 164.8146 13.72632187474671
0 ASTRID
1 23464U 95002B   24187.55271881  .00000149  00000-0  14543-3 0  9998
2 23464  82.9269 185.1363 0040044 328.5652  31.3109 13.72858080474382
0 FAISAT
1 23465U 95002C   24187.50365535  .00000051  00000-0  39943-4 0  9998
2 23465  82.9263 188.8756 0037073 344.7726 126.8183 13.71965585474260
0 SL-8 R/B
1 23466U 95002D   24187.40683684  .00000140  00000-0  13121-3 0  9994
2 23466  82.9253 155.0216 0033493 223.5471 248.6008 13.74595880476788
0 UFO 4 (USA 108)
1 23467U 95003A   24187.42520987 -.00000030  00000-0  00000-0 0  9992
2 23467   9.6662  15.4174 0004919 106.2986 127.5672  1.00275496107811
0 ATLAS 2 CENTAUR R/B
1 23468U 95003B   24187.26117746  .00014455  00000-0  25219-2 0  9996
2 23468  26.5936 153.1252 5833859   6.5915 358.4978  4.29764479386005
0 SL-19 DEB
1 23479U 94085C   24187.58287156 -.00001336  00000-0 -30365-1 0  9998
2 23479  65.0482 328.6721 0096186 151.2985 296.3764 11.45379092231725
0 SL-19 DEB
1 23480U 94085D   24187.28250216  .00000384  00000-0  95478-2 0  9991
2 23480  64.7015 245.0921 0234784 260.3357 166.2016 11.45589982495753
0 SL-19 DEB
1 23482U 94085E   24186.72735501 -.00008306  00000-0 -19272+0 0  9995
2 23482  64.7019 322.5650 0412145 298.2785 167.0749 11.30615060216016
0 SL-19 DEB
1 23483U 94085F   24187.60317318 -.00000048  00000-0 -16727-3 0  9997
2 23483  64.7266 122.2114 0203867 285.8127 249.0180 11.22864686210590
0 SL-19 DEB
1 23484U 94085G   24187.51480792  .00000192  00000-0  67629-2 0  9999
2 23484  64.7303 222.5663 0251070 251.9365 266.6443 11.22399060207944
0 SL-19 DEB
1 23485U 94085H   24187.39208919 -.00001049  00000-0 -27759-1 0  9998
2 23485  64.6453 259.5203 0175900 292.0732  66.1595 11.29380615216855
0 SL-19 DEB
1 23486U 94085J   24186.73406007  .00000072  00000-0  32932-2 0  9997
2 23486  64.9129 187.1661 0170396  12.0541 163.4678 11.25529631522947
0 SL-19 DEB
1 23487U 94085K   24187.55882236 -.00000066  00000-0 -64032-3 0  9993
2 23487  64.9410 351.7975 0176189 319.0732 165.9932 11.30394417218519
0 SL-19 DEB
1 23488U 94085L   24187.37127969  .00000093  00000-0  36256-2 0  9993
2 23488  64.9988 146.4888 0241848 260.1582 274.3093 11.29097238214536
0 SL-19 DEB
1 23489U 94085M   24187.23410486  .00001053  00000-0  30179-1 0  9992
2 23489  64.9334  94.9634 0192044 337.5245 184.1122 11.28944435215605
0 SL-19 DEB
1 23490U 94085N   24187.54847568 -.00000026  00000-0  49297-3 0  9996
2 23490  64.8277 278.1424 0124794 138.6672 324.0466 11.20498769208071
0 SL-19 DEB
1 23491U 94085P   24187.36345220 -.00008897  00000-0 -21293+0 0  9992
2 23491  64.8291 142.6277 0280938 341.3187 192.8193 11.36600231222537
0 SL-19 DEB
1 23492U 94085Q   24171.51177118 -.00000068  00000-0 -68949-3 0  9997
2 23492  64.9543 358.5911 0182507 304.1236  83.1631 11.31155616217032
0 SL-19 DEB
1 23493U 94085R   24186.79604696 -.00000074  00000-0 -83699-3 0  9996
2 23493  64.9414 313.0295 0152333 314.5661 200.9966 11.31853615219825
0 SL-19 DEB
1 23494U 94085S   24187.29739943  .00003227  00000-0  55458-1 0  9998
2 23494  64.9453 178.0298 0304875 218.5752 253.3674 11.64268196500950
0 SL-19 DEB
1 23495U 94085T   24187.27748244 -.00000034  00000-0  22908-3 0  9991
2 23495  65.0250  22.7896 0184298 201.4053 334.0239 11.31067118219278
0 SL-19 DEB
1 23496U 94085U   24187.34372068  .00002637  00000-0  73191-1 0  9995
2 23496  64.8466 288.7614 0042824 107.2396 315.4682 11.33094922218604
0 COSMOS 2307 (GLONASS)
1 23511U 95009A   24186.58262751 -.00000087  00000-0  00000-0 0  9998
2 23511  64.4696 326.3985 0006679 125.9597 302.9356  2.13105337228017
0 COSMOS 2308 (GLONASS)
1 23512U 95009B   24186.48454131 -.00000087  00000-0  00000-0 0  9993
2 23512  64.4577 326.2996 0005616 312.0804 101.3151  2.13099694228020
0 COSMOS 2309 (GLONASS)
1 23513U 95009C   24185.61204490 -.00000086  00000-0  00000-0 0  9998
2 23513  64.4657 326.5505 0035468 214.8453 151.9276  2.13052419228108
0 SL-12 R/B(2)
1 23516U 95009F   24183.78944012 -.00000079  00000-0  00000-0 0  9990
2 23516  64.4523 325.6771 0022124 237.1571 116.1203  2.13307757228417
0 HIMAWARI 5 (GMS 5)
1 23522U 95011B   24187.63401773 -.00000154  00000-0  00000-0 0  9994
2 23522  14.0112   9.5017 0010251 129.4082 111.9486  0.99402345106522
0 H-2 R/B(2)
1 23523U 95011C   24187.24308760  .00005503  00000-0  11753-2 0  9995
2 23523  25.4293  17.5770 6529117 300.6039  10.8659  3.28028583310384
0 HIMAWARI 5 AKM
1 23524U 95011D   24187.37336307 -.00000033  00000-0  00000-0 0  9993
2 23524  13.8916 353.5542 0216714 357.2767 278.4335  1.01257050 39871
0 COSMOS 2310
1 23526U 95012A   24187.42869584  .00000063  00000-0  52641-4 0  9994
2 23526  82.9477 313.3927 0023703 109.5420 313.6239 13.72220060466300
0 SL-8 R/B
1 23527U 95012B   24187.53390784  .00000100  00000-0  90645-4 0  9996
2 23527  82.9432 288.2269 0019776 353.4751   6.6144 13.73823351467884
0 INTELSAT 705
1 23528U 95013A   24187.12911385  .00000053  00000-0  00000-0 0  9998
2 23528  10.4005  43.1951 0021933  90.2944 257.7992  0.98971065106486
0 DMSP 5D-2 F13 (USA 109)
1 23533U 95015A   24187.63131547  .00000292  00000-0  16886-3 0  9993
2 23533  98.8203 196.9912 0007419  36.0502  76.6700 14.16524524512437
0 DMSP 5D-2 F13 DEB
1 23535U 95015C   24187.49116841  .00020179  00000-0  30837-2 0  9996
2 23535  98.6013 101.6559 0001317 351.5456   8.5728 14.73809746535838
0 BRAZILSAT B2
1 23536U 95016A   24187.19381953 -.00000024  00000-0  00000-0 0  9998
2 23536  10.9661  36.7033 0003334 125.4683 217.8892  0.99239247107020
0 HOT BIRD 1
1 23537U 95016B   24186.73918377 -.00000082  00000-0  00000-0 0  9998
2 23537  12.1954  27.7282 0006298  82.4935  94.9796  0.99317697106639
0 ARIANE 44LP+ R/B
1 23538U 95016C   24186.92454958  .00004938  00000-0  14767-2 0  9990
2 23538   6.5053  32.3545 6221991 321.2003   7.4517  3.69676159300307
0 ORBCOMM FM 1
1 23545U 95017A   24187.51448245  .00005401  00000-0  70816-3 0  9991
2 23545  69.9650 212.9009 0003922 166.3743 193.7513 14.80859252561011
0 ORBCOMM FM 2
1 23546U 95017B   24187.55742990  .00006945  00000-0  91424-3 0  9992
2 23546  69.9673 232.3111 0005234 145.1911 214.9582 14.80535765560669
0 ORBVIEW 1 (MICROLAB)
1 23547U 95017C   24187.58035948  .00002207  00000-0  43921-3 0  9990
2 23547  69.9785 131.5517 0012662 273.1475  86.8217 14.63383864554008
0 PEGASUS R/B
1 23548U 95017D   24187.59471544  .00000645  00000-0  17561-3 0  9993
2 23548  69.9888  35.7990 0008588  35.2293  33.6200 14.51820061547310
0 AMSC 1
1 23553U 95019A   24186.72731903 -.00000087  00000-0  00000-0 0  9991
2 23553  12.6315  21.2248 0012380 295.2031  68.3197  0.98910225107045
0 ARIANE 40+ R/B
1 23561U 95021B   24187.63406257  .00000493  00000-0  17433-3 0  9996
2 23561  98.5268 253.9772 0007230 164.5858 318.5895 14.38900005531199
0 SL-19 DEB
1 23564U 94085V   24186.86907553 -.00000003  00000-0  10317-2 0  9998
2 23564  64.9926 228.4813 0200729 228.6320 308.5565 11.34866386207332
0 TITAN 4 CENTAUR R/B
1 23568U 95022B   24185.33630510 -.00000213  00000-0  00000-0 0  9990
2 23568  17.9125  13.2179 0005020 358.8716   1.1352  1.00540458 18726
0 INTELSAT 706
1 23571U 95023A   24187.24598087  .00000050  00000-0  00000-0 0  9997
2 23571   9.4866  50.6935 0001374   6.2012 184.8674  0.99050244106274
0 GOES 9
1 23581U 95025A   24187.59883583 -.00000005  00000-0  00000-0 0  9997
2 23581  13.3252  19.5351 0007976 129.4581 247.2931  0.98798202105739
0 SL-6 R/B(2)
1 23587U 95026D   24186.91039012  .00000843  00000-0  00000-0 0  9998
2 23587  67.1404 260.0338 6155967  49.5924 349.7505  2.03311998216102
0 UFO 5 (USA 111)
1 23589U 95027A   24185.36369088 -.00000216  00000-0  00000-0 0  9993
2 23589  11.5488  13.8125 0002933  66.0880 287.6058  0.98752278105944
0 ATLAS 2 CENTAUR R/B
1 23590U 95027B   24187.15819997  .00017533  00000-0  35025-2 0  9999
2 23590  26.7445 127.4119 5896113 352.9998   1.3912  4.19660774386177
0 DIRECTV 3 (DBS/NIMIQ 3)
1 23598U 95029A   24187.10074681 -.00000094  00000-0  00000-0 0  9995
2 23598  10.7484  40.5143 0001396 114.6515  84.4757  0.99000957105710
0 COSMOS 2315
1 23603U 95032A   24187.57582935  .00000110  00000-0  10218-3 0  9996
2 23603  82.9035  59.9387 0031774  36.1849  27.9467 13.72986283453047
0 SL-8 R/B
1 23604U 95032B   24187.61272906  .00000058  00000-0  45697-4 0  9997
2 23604  82.9033  40.5749 0022805 269.2741  90.5801 13.74436899454537
0 CERISE
1 23606U 95033B   24187.53563004  .00010019  00000-0  65679-3 0  9992
2 23606  98.2888 318.4485 0010063 146.1381 214.0489 15.07881672571634
0 UPM/LBSAT
1 23607U 95033C   24187.55327019  .00001798  00000-0  23748-3 0  9994
2 23607  98.2163 124.0174 0004347 309.1760  50.9065 14.81326879560478
0 ARIANE 40+3 R/B
1 23608U 95033D   24187.62998023  .00012800  00000-0  75101-3 0  9998
2 23608  98.2547 312.8930 0015511 356.9828   3.1304 15.11803967573306
0 TDRS 7
1 23613U 95035B   24186.99058692 -.00000211  00000-0  00000-0 0  9991
2 23613  13.6737 353.1050 0028085  72.1817 299.7045  1.00270792106113
0 IUS R/B(1)
1 23614U 95035C   24187.54120714  .00000756  00000-0  68579-3 0  9990
2 23614  26.2840  11.4600 7002890 353.8629   0.7240  2.59405377259106
0 IUS R/B(2)
1 23615U 95035D   24186.98658388 -.00000069  00000-0  00000-0 0  9991
2 23615  16.1558 348.0037 0013058 153.3785 201.0936  1.00512299106242
0 SL-12 DEB
1 23616U 92047J   24186.85993608  .00094762  00000-0  19933-2 0  9994
2 23616  64.2491 247.4541 3926119 188.5952 162.1098  7.66159423 82776
0 COSMOS 2316 (GLONASS)
1 23620U 95037A   24187.14632559  .00000078  00000-0  00000-0 0  9999
2 23620  65.4812 225.8874 0013690 160.4422  21.5411  2.13101524225265
0 COSMOS 2317 (GLONASS)
1 23621U 95037B   24185.30549852  .00000090  00000-0  00000-0 0  9993
2 23621  65.4912 226.0850 0010016 170.3130 264.1802  2.13101714225045
0 COSMOS 2318 (GLONASS)
1 23622U 95037C   24186.29100477  .00000085  00000-0  00000-0 0  9993
2 23622  65.4831 225.9414 0016529  78.0466 346.9018  2.13101790225043
0 SL-12 R/B(2)
1 23625U 95037F   24186.26822380  .00000087  00000-0  00000-0 0  9999
2 23625  65.4864 224.7543 0008282 194.4734 232.0083  2.13424635225560
0 USA 113
1 23628U 95038A   24187.59984661 -.00000005  00000-0  00000-0 0  9992
2 23628  12.7511  20.3614 0003553 155.4764 219.7592  0.98663389 25749
0 INTELSAT 4 (PAS 4)
1 23636U 95040A   24187.13224667 -.00000060  00000-0  00000-0 0  9998
2 23636  10.5612  45.8341 0023504 212.5971 149.9208  0.97126552104233
0 ARIANE 42L+3 R/B
1 23637U 95040B   24187.54432288  .00000049  00000-0  21005-2 0  9990
2 23637   3.9534 240.6292 7227071 214.5932 135.3950  2.18754658231002
0 KOREASAT 1
1 23639U 95041A   24186.48778137 -.00000007  00000-0  00000-0 0  9996
2 23639  14.6324   3.9536 0002526 141.3966  27.7158  0.99662626105424
0 DELTA 2 R/B(1)
1 23640U 95041B   24187.48963085  .00000124  00000-0  25646-4 0  9993
2 23640  26.6741 125.8773 0289259 287.9857  68.9333 13.28117866404729
0 DELTA 2 R/B(2)
1 23641U 95041C   24187.26405057 -.00000068  00000-0  00000-0 0  9991
2 23641  20.7357 315.9507 6425575 276.1860  13.3839  2.70400456285781
0 MOLNIYA 3-47
1 23642U 95042A   24186.46989770 -.00000948  00000-0  00000-0 0  9990
2 23642  64.9840 346.1130 6952257 277.9516  14.5938  2.01981647212127
0 SL-6 R/B(2)
1 23645U 95042D   24167.75267899  .00001047  00000-0  00000-0 0  9995
2 23645  64.5013  41.8798 7044811 278.5595  13.7770  1.99200546207352
0 ATLAS 2 CENTAUR R/B(2)
1 23648U 95038C   24186.22242429  .00000015  00000-0  00000-0 0  9992
2 23648  14.1025 350.7808 0015645 274.7477  85.0791  1.01262833 18867
0 JCSAT 3
1 23649U 95043A   24187.19138289 -.00000112  00000-0  00000-0 0  9993
2 23649  12.2135  22.1428 0017500  67.7953 277.2129  0.99149905 62597
0 NSTAR A
1 23651U 95044A   24187.58957777  .00000008  00000-0  00000-0 0  9994
2 23651  12.3560  26.2909 0018572   9.3665 353.8886  0.99125706104865
0 COSMOS 2319
1 23653U 95045A   24187.11855253  .00000115  00000-0  00000-0 0  9991
2 23653  14.4793 358.0950 0005872 197.3086 162.6196  1.00356522105646
0 SL-12 R/B(2)
1 23656U 95045D   24187.54624620 -.00000367  00000-0  00000-0 0  9993
2 23656  14.5246 358.3770 0018936  49.3425 203.6526  1.00167726105531
0 SICH 1
1 23657U 95046A   24187.60257084  .00002757  00000-0  28195-3 0  9990
2 23657  82.5256 358.0508 0020215 181.3207 178.7962 14.90067112559824
0 SL-14 R/B
1 23659U 95046C   24187.47565778  .00000594  00000-0  76148-4 0  9998
2 23659  82.5296  75.0617 0026780  87.3619  86.0074 14.79333993554743
0 TELSTAR 4 (TELSTAR 402R)
1 23670U 95049A   24187.61439166 -.00000149  00000-0  00000-0 0  9998
2 23670  13.0182  17.7473 0001858  59.9613 327.5859  1.00244041105370
0 ARIANE 42L+3 R/B
1 23671U 95049B   24187.30664833  .00000305  00000-0  93869-3 0  9997
2 23671   7.7803 351.1553 7213119  47.2961 354.3049  2.28517449236069
0 LUCH 1
1 23680U 95054A   24187.05983729 -.00000103  00000-0  00000-0 0  9992
2 23680  14.9240   4.8398 0010360 124.3838 249.0151  1.00269061105218
0 SL-12 R/B(2)
1 23683U 95054D   24187.19199205  .00000077  00000-0  00000-0 0  9997
2 23683  14.8957   4.6868 0021925  88.9723 277.3190  1.00310446105235
0 ASTRA 1E
1 23686U 95055A   24186.33024696 -.00000190  00000-0  00000-0 0  9994
2 23686  10.1394  45.9750 0008488  18.0337 339.7723  0.98794418104723
0 ARIANE 42L+3 R/B
1 23687U 95055B   24186.98570060 -.00000111  00000-0  50291-3 0  9990
2 23687   4.6039 164.5156 7225737 171.2914 216.7467  2.22078563232225
0 UFO 6 (USA 114)
1 23696U 95057A   24187.24259109 -.00000031  00000-0  00000-0 0  9991
2 23696  10.9372  18.0693 0007563 139.6729  68.1511  0.98764951104742
0 ATLAS 2 CENTAUR R/B
1 23697U 95057B   24187.44021093  .00329446 -19454-6  19535-2 0  9991
2 23697  26.7978 103.8257 3729539  80.4183 318.9658  8.11242745463351
0 COSMOS 2322
1 23704U 95058A   24187.07226476  .00000431  00000-0  25354-3 0  9999
2 23704  70.9863  46.3194 0009103 166.2092 193.9280 14.13621905479472
0 SL-16 R/B
1 23705U 95058B   24187.55279220 -.00000221  00000-0 -88819-4 0  9993
2 23705  71.0220  25.3017 0013877 324.4383  35.5814 14.15350396481233
0 SL-16 DEB
1 23706U 95058C   24187.30342687  .00000026  00000-0  63653-4 0  9995
2 23706  71.0013  32.7094 0199731 334.6324 202.3421 13.74105566437514
0 SL-16 DEB
1 23707U 95058D   24187.45319913  .00000130  00000-0  16216-3 0  9996
2 23707  70.9954  86.7850 0204456  46.5428 127.7958 13.72237759435714
0 SL-16 DEB
1 23708U 95058E   24187.59122282  .00000148  00000-0  17190-3 0  9994
2 23708  71.0518   0.9842 0186037 194.4171 233.4958 13.76395381440186
0 SL-16 DEB
1 23709U 95058F   24187.34521044  .00000083  00000-0  11575-3 0  9996
2 23709  71.0386  59.0780 0199528 287.9578 183.2521 13.74468103437909
0 RADARSAT
1 23710U 95059A   24187.56011604  .00000401  00000-0  16692-3 0  9998
2 23710  98.5521 195.6082 0001231  77.7564 282.3757 14.31587035496492
0 SURFSAT
1 23711U 95059B   24187.58832328 -.00000010  00000-0  74272-4 0  9991
2 23711 100.5656 210.9355 0367106 266.4270 214.5746 13.12794101373533
0 USA 115
1 23712U 95060A   24187.48730184 -.00000030  00000-0  00000-0 0  9996
2 23712  13.8075   8.8987 0000838  76.6554 253.8100  1.00271831 25743
0 TITAN 401 CENTAUR R/B
1 23713U 95060B   24186.91866817 -.00000384  00000-0  00000-0 0  9999
2 23713  14.2986   4.2583 0035014 200.0398 159.8326  1.00596840 18269
0 ISO
1 23715U 95062A   24186.94903762  .00000008  00000-0  13786-1 0  9995
2 23715   5.3320 338.6134 8298915 217.3766  38.8891  1.02078377106420
0 ARIANE 44P+3 R/B
1 23716U 95062B   24186.09584802 -.00000436  00000-0  57883-2 0  9995
2 23716   1.6226  54.6931 8333662 267.1381   6.4605  0.95001708 99431
0 GALS 2
1 23717U 95063A   24187.42257543 -.00000186  00000-0  00000-0 0  9993
2 23717  14.2585   7.8706 0004141 344.8017 357.9675  0.99880184104512
0 SL-12 R/B(2)
1 23720U 95063D   24187.54844392 -.00000336  00000-0  00000-0 0  9991
2 23720  14.4386 353.5169 0044299 171.4201  92.1481  1.00256832104858
0 AMOS 5I (ASIASAT 2)
1 23723U 95064A   24186.96776057 -.00000273  00000-0  00000-0 0  9992
2 23723   9.8910  47.3584 0007270 342.8784 211.2238  0.99309158104254
0 ASIASAT 2 PKM
1 23725U 95064C   24186.92219909  .00003997  00000-0  90857-3 0  9995
2 23725  25.7483 218.7227 5550801 333.6957   6.4650  4.71213505413589
0 TELECOM 2C
1 23730U 95067A   24186.46080435 -.00000122  00000-0  00000-0 0  9999
2 23730  13.4115  20.9787 0009605 284.3887  82.5875  0.97938732103484
0 INSAT 2C
1 23731U 95067B   24187.15722215  .00000056  00000-0  00000-0 0  9991
2 23731  13.8830  13.4994 0004936  69.1486  99.5759  0.99785610104304
0 ARIANE 44L+3 R/B
1 23732U 95067C   24187.08318217  .00002046  00000-0  11743-2 0  9996
2 23732   6.7768 127.2896 6702969 254.5093  27.0550  2.99598652276431
0 COSMOS 2325 (GLONASS)
1 23734U 95068A   24187.24373473  .00000077  00000-0  00000-0 0  9996
2 23734  65.4855 225.8536 0019831 224.7487 137.5121  2.13102880222226
0 COSMOS 2324 (GLONASS)
1 23735U 95068B   24185.48230263  .00000089  00000-0  00000-0 0  9993
2 23735  65.4826 225.8558 0002044 146.9184 213.1799  2.13102615222257
0 COSMOS 2323 (GLONASS)
1 23736U 95068C   24187.62333130  .00000073  00000-0  00000-0 0  9992
2 23736  65.4739 225.6910 0009282 192.5590 281.7313  2.13103113222044
0 SL-12 R/B(2)
1 23739U 95068F   24186.34358174  .00000086  00000-0  00000-0 0  9992
2 23739  65.4841 224.8216 0011856 195.6341 157.6488  2.13374893222475
0 GALAXY 3R
1 23741U 95069A   24187.49291979 -.00000282  00000-0  00000-0 0  9991
2 23741  12.6058  21.2628 0007280  92.2702 273.8872  1.00276055104683
0 IRS 1C
1 23751U 95072A   24187.57340806  .00000179  00000-0  99933-4 0  9990
2 23751  99.0118 177.4052 0001029  95.5657 264.5638 14.23130384480334
0 SKIPPER
1 23752U 95072B   24187.22021686  .00000050  00000-0  40104-4 0  9999
2 23752  98.8289 246.3795 0006106  41.2373 318.9267 14.25994123483869
0 SL-6 R/B
1 23753U 95072C   24187.58765900  .00000115  00000-0  66296-4 0  9995
2 23753  98.7992 247.1007 0003833  18.7852 341.3469 14.26761306484434
0 ECHOSTAR 1
1 23754U 95073A   24186.97457477 -.00000168  00000-0  00000-0 0  9992
2 23754   6.8529  70.5507 0003426  56.8239 150.7881  0.98935003 44954
0 ECHOSTAR 1 PKM
1 23756U 95073C   24187.53288739  .00025839  00000-0  16397-2 0  9999
2 23756  24.2835  46.4161 5805601  94.2618 330.1683  4.39008258328743
0 INTELSAT 3R (PAS 3R)
1 23764U 96002A   24187.29321400  .00000008  00000-0  00000-0 0  9990
2 23764  10.4634  42.1652 0008319 263.4574 295.7066  0.99088471103739
0 AFRICASAT 1 (MEASAT 1)
1 23765U 96002B   24187.62023699  .00000000  00000-0  00000-0 0  9999
2 23765  11.3411  34.3504 0002734   1.6024   8.7212  0.99060168103805
0 ARIANE 44L+3 R/B
1 23766U 96002C   24187.28220711  .00001534  00000-0  10424-2 0  9992
2 23766   7.6590 217.6442 6320024 124.4486 312.0319  3.51647049303223
0 ABS 1A (KOREASAT 2)
1 23768U 96003A   24187.53519432 -.00000364  00000-0  00000-0 0  9992
2 23768  11.6325  30.5938 0005323  93.9354 115.3461  0.99796966104074
0 DELTA 2 R/B(2)
1 23770U 96003C   24186.48569282 -.00000243  00000-0  00000-0 0  9992
2 23770  21.5165 333.8760 6905648 339.7768 271.9430  2.19757601228671
0 COSMOS 2327
1 23773U 96004A   24187.53123999  .00000070  00000-0  56890-4 0  9993
2 23773  82.9843 288.7069 0049213  85.3607 285.8690 13.74662747427857
0 SL-8 R/B
1 23774U 96004B   24187.55042564  .00000082  00000-0  67438-4 0  9997
2 23774  82.9783 258.2777 0043184 341.5362  18.4226 13.76728126429869
0 GORIZONT 31
1 23775U 96005A   24187.11299519  .00000094  00000-0  00000-0 0  9996
2 23775  14.4650 359.8615 0020558 219.7543 139.7112  0.99890042103935
0 SL-12 R/B(2)
1 23778U 96005D   24187.52177067 -.00000130  00000-0  00000-0 0  9999
2 23778  15.2893   2.5239 0015561 163.8099  60.6400  0.97672079101423
0 PAKSAT 1 (ANATOLIA 1)
1 23779U 96006A   24187.19930194  .00000101  00000-0  00000-0 0  9999
2 23779   9.3712  51.9220 0006571 122.1428 236.6435  0.99588688103756
0 NSTAR B
1 23781U 96007A   24186.62837595  .00000067  00000-0  00000-0 0  9992
2 23781  11.7906  30.8658 0004090 289.6020 250.9845  0.99257274103379
0 GONETS D1 1
1 23787U 96009A   24187.59567984  .00000040  00000-0  16201-3 0  9993
2 23787  82.5763  34.5519 0010397 216.5106 198.4594 12.64079024309409
0 GONETS D1 2
1 23788U 96009B   24187.61719606  .00000054  00000-0  24033-3 0  9994
2 23788  82.5698  39.7857 0005975 241.2115 118.8377 12.63187349308256
0 GONETS D1 3
1 23789U 96009C   24187.58825008  .00000048  00000-0  20563-3 0  9992
2 23789  82.5781  54.1895 0004325 233.5488 126.5205 12.62653203307844
0 COSMOS 2328
1 23790U 96009D   24187.60028777  .00000043  00000-0  18074-3 0  9994
2 23790  82.5772  53.8970 0006764 226.5059 133.5470 12.62574885307672
0 COSMOS 2329
1 23791U 96009E   24187.17693086  .00000044  00000-0  19038-3 0  9990
2 23791  82.5715  60.0350 0007796 234.3455 242.0564 12.61676217306574
0 COSMOS 2330
1 23792U 96009F   24187.42217983  .00000036  00000-0  14389-3 0  9992
2 23792  82.5805  76.8016 0010447 246.0072 113.9925 12.60947943305933
0 SL-14 R/B
1 23793U 96009G   24187.58980626  .00000004  00000-0 -43249-4 0  9995
2 23793  82.5704 137.1637 0045924 119.2767  54.2421 12.55081980300085
0 POLAR
1 23802U 96013A   24185.84112491  .00000241  00000-0  00000+0 0  9990
2 23802  79.1350 234.4898 5884451 233.1935  57.2773  1.29847235135574
0 TITAN 34B AGENA D DEB
1 23811U 83078C   24187.22202951  .00001962  00000-0  25648-2 0  9991
2 23811  63.4282 163.5882 4880444 246.9739  55.4446  5.59188883 97792
0 TITAN 34B AGENA D DEB
1 23812U 83078D   24187.04388822 -.00000004  00000-0  22104-4 0  9997
2 23812  63.6543  86.7662 3901182 248.8423  65.8069  7.14958863132208
0 REX 2
1 23814U 96014A   24187.46676600  .00000230  00000-0  93641-4 0  9997
2 23814  90.0297 339.5931 0020495 319.7393  40.2281 14.24948164471827
0 PEGASUS R/B
1 23815U 96014B   24187.47230453  .00000259  00000-0  10543-3 0  9991
2 23815  90.0153 338.4256 0020119 314.2696  45.6845 14.25251386472264
0 INTELSAT 707
1 23816U 96015A   24187.10074681 -.00000055  00000-0  00000-0 0  9991
2 23816   8.9925  56.5627 0071361 346.2317 196.1044  0.98479710102935
0 OPS 0856 DEB
1 23820U 66077D   24170.92139431  .00001599  00000-0  68300-1 0  9999
2 23820  87.9953 348.3033 1976541 184.7200 173.2174  8.92852221 24973
0 IRS B3
1 23827U 96017A   24187.58588818  .00000266  00000-0  13815-3 0  9993
2 23827  99.0326 180.5250 0003512 163.0807 197.0488 14.23211418468620
0 PSLV R/B
1 23828U 96017B   24187.60637057  .00000136  00000-0  81884-4 0  9995
2 23828  99.0271 174.6556 0032770 230.9742 128.8516 14.22339341467913
0 NAVSTAR 37 (USA 117)
1 23833U 96019A   24187.37893230 -.00000062  00000-0  00000-0 0  9990
2 23833  53.4243 293.2737 0007905   2.7918  41.0844  1.94618800 68915
0 COSMOS 985 DEB
1 23836U 78007D   24187.33357519  .00001881  00000-0  12277-2 0  9991
2 23836  82.9333 310.3234 0040561 204.1903 185.1868 14.01425237541391
0 INMARSAT 3-F1
1 23839U 96020A   24187.53953931 -.00000146  00000-0  00000-0 0  9994
2 23839   9.1037  52.7562 0006851  72.0342 261.3218  0.99979692103133
0 ATLAS 2A CENTAUR R/B
1 23840U 96020B   24186.64502654 -.00000055  00000-0  00000-0 0  9998
2 23840  21.8165 314.8863 6978164 241.2315  33.4360  2.24208112231517
0 ASTRA 1F
1 23842U 96021A   24187.57754377 -.00000210  00000-0  00000-0 0  9998
2 23842   3.5803  82.3581 0004021  49.8151 171.2622  0.99122105 45045
0 SL-12 R/B(2)
1 23845U 96021D   24187.17798140 -.00000118  00000-0  00000-0 0  9990
2 23845   6.5799 281.7630 4054418 181.7814 204.2142  1.64339299169505
0 MSAT M1
1 23846U 96022A   24187.19425464 -.00000085  00000-0  00000-0 0  9993
2 23846  11.3773  33.2279 0019093 176.4768 172.4869  0.98646544103056
0 ARIANE 42P+3 R/B
1 23847U 96022B   24186.81957886  .00002809  00000-0  13309-2 0  9993
2 23847   6.7724  72.6766 6639125 258.0531  25.5922  3.09793461283800
0 MSX
1 23851U 96024A   24187.57251357 -.00000174  00000-0 -91631-4 0  9995
2 23851  98.9714 126.5525 0008247  42.0432 318.1363 13.98247946438891
0 MSX DEB
1 23859U 96024C   24187.60993039 -.00000054  00000-0 -66665-5 0  9994
2 23859  99.0520 129.4221 0085579 254.3447 281.8554 13.97893107436901
0 PALAPA C2
1 23864U 96030A   24187.51716237 -.00000134  00000-0  00000-0 0  9994
2 23864  10.3326  44.0434 0008927  87.1959 267.3254  0.99001481102660
0 INTELSAT 24 (AMOS 1)
1 23865U 96030B   24187.31955903 -.00000072  00000-0  00000-0 0  9999
2 23865  11.3299  39.3663 0009301 153.7873  90.8090  0.97117085101666
0 ARIANE 44L+3 R/B
1 23866U 96030C   24187.17757306  .00002313  00000-0  11752-2 0  9998
2 23866   4.3465 280.3606 6811542  63.6222 349.3707  2.86241266261731
0 ARIANE 44L+3 DEB (SPELDA
1 23867U 96030D   24187.43527373  .00008287  00000-0  50568-2 0  9991
2 23867   3.9975 342.4082 6659496 306.0548   9.0756  3.05723850276639
0 GALAXY 9
1 23877U 96033A   24187.16368940  .00000088  00000-0  00000-0 0  9993
2 23877  10.9065  37.6764 0010024 134.9309 213.0898  0.99538186 39269
0 DELTA 2 R/B(2)
1 23879U 96033C   24186.82226700 -.00000172  00000-0  00000-0 0  9999
2 23879  22.8711  81.3326 6753448  79.3277 344.6140  2.11146760 81871
0 GORIZONT 32
1 23880U 96034A   24187.18903328 -.00000033  00000-0  00000-0 0  9996
2 23880  14.4308   0.3199 0006517   2.2918 351.7215  1.00203955102895
0 SL-12 R/B(2)
1 23883U 96034D   24187.29945317 -.00000211  00000-0  00000-0 0  9993
2 23883  15.2313   3.1306 0032572  88.0600 111.2516  0.97947067100563
0 USA 119
1 23893U 96029A   24187.50555131  .00000846  00000-0  21139-3 0  9995
2 23893  63.3310 248.5892 0814957  38.7001 326.9616 13.43007761  9569
0 USA 120
1 23907U 96029B   24187.50804901  .00000979  00000-0  24103-3 0  9994
2 23907  63.3308 249.4433 0813930  39.4115 326.3318 13.43032201  7936
0 USA 121
1 23908U 96029C   24187.52526480  .00000928  00000-0  22825-3 0  9993
2 23908  63.3307 248.0581 0815308  38.9771 326.7214 13.43036982  7667
0 INTELSAT 709
1 23915U 96035A   24187.34685829  .00000002  00000-0  00000-0 0  9992
2 23915   9.2054  53.8005 0012133 208.1334 352.9832  0.99181168102349
0 USA 124
1 23937U 96029F   24187.57718137  .00039834  58432-5  71362-3 0  9997
2 23937  63.2886 269.2648 0596054  73.6828 292.8926 14.53335555  7597
0 TOMS EP
1 23940U 96037A   24187.38060890  .00001165  00000-0  26564-3 0  9998
2 23940  98.4266 330.9743 0026324 242.8288 117.0226 14.57548823488236
0 APSTAR 1A
1 23943U 96039A   24186.76136939 -.00000126  00000-0  00000-0 0  9993
2 23943  11.8576  24.5700 0018777 341.9114 202.0080  0.99193633 35577
0 USA 125 DEB
1 23947U 96038C   24186.85371988 -.00000031  00000-0  77089-4 0  9991
2 23947  55.3943  28.7841 4915609 293.1944  23.2340  5.56436650100906
0 ARABSAT 2A
1 23948U 96040A   24186.72644880 -.00000065  00000-0  00000-0 0  9997
2 23948  13.8068  14.1234 0007467 117.0041 249.1977  0.99230452101798
0 TURKSAT 1C
1 23949U 96040B   24187.51503900 -.00000285  00000-0  00000-0 0  9997
2 23949  10.9551  35.3527 0007119 121.8916  48.6777  1.00175795102547
0 ARIANE 44L+3 R/B
1 23950U 96040C   24187.13493206  .00002537  00000-0  16146-2 0  9995
2 23950   6.6873 160.5684 6929060 245.7402  30.1695  2.69667052251899
0 NAVSTAR 38 (USA 126)
1 23953U 96041A   24187.32921458 -.00000070  00000-0  00000-0 0  9996
2 23953  55.3792  71.3169 0060357  97.8409  81.0060  1.88695783201351
0 ARIANE 2 DEB
1 23966U 88098F   24187.32185283  .00041435  00000-0  12410-1 0  9999
2 23966   3.4882  66.6412 6079444  71.9469 342.5634  3.90294174362511
0 UFO 7 (USA 127)
1 23967U 96042A   24187.52740671 -.00000086  00000-0  00000-0 0  9997
2 23967  10.4417  20.5704 0009158  94.7715 246.1991  1.00384375102343
0 ATLAS 2 CENTAUR R/B
1 23968U 96042B   24187.45827739  .00002106  00000-0  13746-2 0  9998
2 23968  26.7731 272.3256 6354825 122.9984 314.1269  3.46472384332882
0 PEGASUS DEB
1 23986U 94029AG  24187.57170486  .00011733  00000-0  67483-3 0  9998
2 23986  82.0507  15.3407 0051729 123.2626 237.3575 15.11190185522225
0 PEGASUS DEB
1 24007U 94029BC  24187.31914075  .00004260  00000-0  36297-3 0  9991
2 24007  81.9241 285.3979 0073330  84.3556 334.4031 14.95424994518182
0 PEGASUS DEB
1 24051U 94029CY  24187.59447418  .00012493  00000-0  29536-2 0  9996
2 24051  81.2973  25.3023 0405625  62.3319 352.8704 14.14015948415348
0 PEGASUS DEB
1 24082U 94029ED  24187.57628003  .00010192  00000-0  82544-3 0  9992
2 24082  81.9024   6.9137 0069186  89.1156 334.2573 14.97710079513065
0 PEGASUS DEB
1 24091U 94029EN  24187.58288331  .00005896  00000-0  48147-3 0  9995
2 24091  81.9959  31.1370 0075656  54.6733   2.9345 14.96975885523422
0 PEGASUS DEB
1 24126U 94029FZ  24187.56639706  .00013831  00000-0  32119-2 0  9997
2 24126  81.8068 301.8988 0316564 152.1533 224.4066 14.28428291451780
0 PEGASUS DEB
1 24129U 94029GC  24187.50709294  .00001850  00000-0  48364-3 0  9992
2 24129  81.4793  93.9834 0562578 219.2780 320.1661 13.83073148401181
0 PEGASUS DEB
1 24151U 94029HA  24187.40142753  .00001750  00000-0  30081-3 0  9993
2 24151  82.0194 157.5360 0159148 127.7126 233.8626 14.60041310488886
0 PEGASUS DEB
1 24163U 94029HN  24187.57863752  .00059471  00000-0  12576-2 0  9994
2 24163  82.0618 322.1864 0022017 251.6902 108.1950 15.44643729528202
0 PEGASUS DEB
1 24165U 94029HQ  24187.58414207  .00012370  00000-0  16234-2 0  9996
2 24165  82.1733 131.9571 0189231 209.4444 149.6000 14.68397822454162
0 PEGASUS DEB
1 24197U 94029JY  24187.57375329  .00005206  00000-0  58231-3 0  9995
2 24197  82.0922 297.1575 0082427 130.0454 243.3822 14.84256291590903
0 ITALSAT 2
1 24208U 96044A   24187.10188644 -.00000042  00000-0  00000-0 0  9990
2 24208  13.4301  12.0117 0027930 129.5509 232.8889  1.00789804102420
0 TELECOM 2D
1 24209U 96044B   24187.53519441 -.00000180  00000-0  00000-0 0  9994
2 24209  12.1109  29.4242 0016287  18.1523 192.8868  0.98448205101543
0 PEGASUS DEB
1 24213U 94029KL  24187.47238835  .00002353  00000-0  58504-3 0  9996
2 24213  81.4650  86.8053 0544581 244.5970 109.7883 13.88300860 62951
0 PEGASUS DEB
1 24227U 94029LA  24187.21037052  .00003641  00000-0  49087-3 0  9998
2 24227  82.0430  60.9889 0149459  44.1531  93.6016 14.71358126496828
0 PEGASUS DEB
1 24236U 94029LK  24187.49854541  .00005271  00000-0  80978-3 0  9993
2 24236  81.4399 314.6521 0387253 343.0035  15.8463 14.33590959431981
0 PEGASUS DEB
1 24239U 94029LN  24187.41743171  .00007828  00000-0  12178-2 0  9990
2 24239  81.5176 183.8276 0184468 294.3531  63.8508 14.62074749471504
0 ADEOS
1 24277U 96046A   24187.54438630  .00000243  00000-0  11240-3 0  9992
2 24277  98.8963 218.8219 0002013  58.2571 301.8806 14.29948304453947
0 JAS 2
1 24278U 96046B   24187.53073259 -.00000026  00000-0  73902-5 0  9999
2 24278  98.5804 119.7824 0350672 140.6158 222.1050 13.53191837376918
0 H-2 R/B
1 24279U 96046C   24187.56932843  .00000051  00000-0  10900-3 0  9990
2 24279  98.6910 204.8273 0299264 200.5923 273.9203 13.47311240370730
0 CHINASAT 7
1 24282U 96048A   24187.33249110 -.00000109  00000-0  00000-0 0  9991
2 24282  17.3600 208.2949 3457024 236.8800 213.3773  1.06659152111120
0 SL-16 DEB
1 24284U 95058G   24187.26111032  .00000485  00000-0  25259-3 0  9998
2 24284  70.8628 119.6156 0010917 135.0958 225.1051 14.19653988482667
0 FAST
1 24285U 96049A   24187.11089597  .00007742  00000-0  61053-3 0  9999
2 24285  82.9516  73.2919 1792558 142.5854 231.4740 11.70548822148856
0 PEGASUS R/B
1 24286U 96049B   24187.45136871  .00006495  00000-0  48640-3 0  9996
2 24286  82.9468   4.6057 1731330 250.3460  90.3262 11.84287931156526
0 MAGION 5
1 24292U 96050B   24187.19532958 -.00000073  00000-0 -85329-5 0  9997
2 24292  62.8011  63.3194 5620771 256.3251  38.1366  4.14714209421698
0 INTERBALL AURORA
1 24293U 96050C   24186.31505425 -.00000078  00000-0  00000-0 0  9992
2 24293  62.8026  63.5622 5621121 256.4109  38.0683  4.14718941421751
0 SL-6 R/B(2)
1 24296U 96050F   24187.14169207 -.00000057  00000-0 -88312-5 0  9996
2 24296  62.8386  96.2766 5567037 249.3442  44.5130  4.15051802422107
0 COSMOS 2333
1 24297U 96051A   24187.57115962 -.00000230  00000-0 -95975-4 0  9999
2 24297  70.9049  33.4152 0026221 298.6093  61.2391 14.13586941435728
0 SL-16 R/B
1 24298U 96051B   24187.56683339 -.00000206  00000-0 -84779-4 0  9990
2 24298  70.8016  29.9459 0017644 314.5246  45.4432 14.12468806435211
0 SL-16 DEB
1 24299U 96051C   24187.60233910  .00000084  00000-0  11575-3 0  9997
2 24299  71.0378  33.9960 0190927 313.1665  45.3612 13.75564666396858
0 SL-16 DEB
1 24300U 96051D   24187.35546389  .00000195  00000-0  21832-3 0  9999
2 24300  71.0286  68.1582 0195270  20.8892  93.0720 13.74464110395467
0 SL-16 DEB
1 24301U 96051E   24187.19150417  .00000207  00000-0  23424-3 0  9998
2 24301  70.9931 104.8134 0206040 105.0375  43.1895 13.72273372393276
0 SL-16 DEB
1 24302U 96051F   24187.58177721  .00000042  00000-0  81648-4 0  9999
2 24302  70.9845 136.1991 0207079 170.1228   5.7850 13.70853111392056
0 SL-16 DEB
1 24303U 96051G   24187.13470772  .00000032  00000-0  44698-4 0  9996
2 24303  71.1069  62.4846 0070602 356.1974 167.8883 14.08253629430411
0 COSMOS 2334
1 24304U 96052A   24187.62165267  .00000091  00000-0  80936-4 0  9992
2 24304  82.9334 247.3665 0031208  83.2410  30.5070 13.73705458394935
0 UNAMSAT
1 24305U 96052B   24187.56752522  .00000101  00000-0  91176-4 0  9992
2 24305  82.9357 246.8947 0031474  74.5395 285.9232 13.73962708394892
0 SL-8 R/B
1 24306U 96052C   24187.59666784  .00000150  00000-0  14077-3 0  9998
2 24306  82.9336 230.7097 0026946  39.6649 320.6472 13.75117743396405
0 INMARSAT 3-F2
1 24307U 96053A   24187.60896988 -.00000258  00000-0  00000-0 0  9991
2 24307   8.2289  60.7892 0008490  43.7981 189.4870  1.00004353101805
0 ECHOSTAR 2
1 24313U 96055A   24187.02974376 -.00000252  00000-0  00000-0 0  9998
2 24313  10.8241  36.8225 0015947  71.7367 106.8859  1.00210942101877
0 AMC-1 (GE-1)
1 24315U 96054A   24187.47516931  .00000092  00000-0  00000-0 0  9998
2 24315   7.4115  66.3933 0003721 190.8832  59.6911  0.99504939 39156
0 NAVSTAR 39 (USA 128)
1 24320U 96056A   24187.57817316  .00000006  00000-0  00000-0 0  9993
2 24320  54.1190 261.6657 0028800 203.9938 126.1168  1.86499243197231
0 PEGASUS DEB
1 24340U 94029NR  24187.35373157  .00004958  00000-0  21352-2 0  9994
2 24340  81.6031 152.4271 0868172  75.4946 294.0790 13.07946090432091
0 PEGASUS DEB
1 24378U 94029QF  24187.51447289  .00001038  00000-0  19175-3 0  9998
2 24378  82.0283 212.1242 0165432 268.2935  89.9310 14.56165692594967
0 EXPRESS 2
1 24435U 96058A   24187.58407534 -.00000345  00000-0  00000-0 0  9997
2 24435  14.6331 359.7585 0007979  24.2197 213.1207  1.00264865101670
0 SL-12 R/B(2)
1 24438U 96058D   24186.98736708 -.00000070  00000-0  00000-0 0  9996
2 24438  14.5601 356.4435 0011485 115.5921 234.5416  1.00356464101694
0 PEGASUS DEB
1 24529U 94029WD  24187.57478137  .00003479  00000-0  36363-3 0  9997
2 24529  81.9772 120.0770 0117690  95.8897  77.5006 14.84323821146490
0 PEGASUS DEB
1 24581U 94029YH  24187.59595057  .00004187  00000-0  16053-2 0  9998
2 24581  81.5465 250.5033 0765661  45.4372  66.9718 13.31465617340848
0 PEGASUS DEB
1 24594U 94029YW  24187.50005843  .00010953  00000-0  25570-2 0  9994
2 24594  81.4679 313.3594 0489828 190.9349 168.0865 14.00400968407527
0 PEGASUS DEB
1 24602U 94029ZE  24187.11365440  .00009730  00000-0  32692-2 0  9997
2 24602  81.5279  77.1250 0763208  37.4631 327.7253 13.37027611349949
0 ARABSAT 2B
1 24652U 96063A   24187.52441443 -.00000294  00000-0  00000-0 0  9998
2 24652   9.0375  55.0968 0004974  88.3478  90.3116  0.99413161101387
0 MEASAT 2
1 24653U 96063B   24186.93313337 -.00000213  00000-0  00000+0 0  9993
2 24653  11.1833  34.0469 0005409 142.8694  69.8568  0.99661236101070
0 ARIANE 44L R/B
1 24654U 96063C   24186.70900826  .00001029  00000-0  15224-2 0  9996
2 24654   4.3584 302.7234 7122915 281.7579  12.6936  2.41593957235646
0 EUTE 48A (HB2)
1 24665U 96067A   24187.42020417 -.00000232  00000-0  00000-0 0  9991
2 24665  10.6868  40.9512 0009645  92.1985 109.4691  0.98383860101055
0 INMARSAT 3-F3
1 24674U 96070A   24186.80880858  .00000129  00000-0  00000-0 0  9993
2 24674   8.7620  56.0756 0005244  63.7558 133.7777  0.99989484100787
0 ATLAS 2A CENTAUR R/B
1 24675U 96070B   24186.80173191 -.00000220  00000-0  00000-0 0  9992
2 24675  23.0238  12.2915 7007941 321.9262   8.9032  2.22626587224052
0 COSMOS 2336
1 24677U 96071A   24187.58056687  .00000062  00000-0  51427-4 0  9997
2 24677  82.9414  10.9617 0025189  92.8759 326.7634 13.71595652378479
0 SL-8 R/B
1 24678U 96071B   24187.54011360  .00000075  00000-0  64438-4 0  9993
2 24678  82.9397 343.4237 0024284 352.5543  73.0209 13.73732065380616
0 SL-19 DEB
1 24679U 94085Y   24183.17452434  .00000008  00000-0  13465-2 0  9991
2 24679  64.9873 321.4618 0194081 250.0160 286.2492 11.32287036385124
0 ISO DEB
1 24700U 95062C   24184.19582407 -.00000313  00000-0  00000-0 0  9998
2 24700   1.1581 348.8657 8219603 332.3762   3.7966  1.00349927 35821
0 TRANSIT 10 DEB
1 24705U 65109E   24187.53710802  .00004050  00000-0  23686-2 0  9993
2 24705  89.0449 273.2911 0088479 181.9156 191.2764 14.06211027400554
0 ARIANE 3 DEB
1 24712U 86026G   24187.35596663  .00000885  00000-0  32328-2 0  9994
2 24712   8.8117 236.1601 6558834 114.1411 325.1412  3.08753040287762
0 AMC-2 (GE-2)
1 24713U 97002A   24187.57479874 -.00000192  00000-0  00000-0 0  9991
2 24713   9.3400  51.1297 0006722  90.1970  93.1451  0.99467729100347
0 NAHUEL 1A
1 24714U 97002B   24187.63495229 -.00000208  00000-0  00000-0 0  9999
2 24714  11.4305  33.5263 0007077 152.4857 137.1328  0.99390542 99979
0 HALCA (MUSES B)
1 24720U 97005A   24187.12859172  .00000279  00000-0  12091-2 0  9996
2 24720  31.3698  11.8031 5991004 234.9308  60.0190  3.83886841382275
0 M-5 R/B
1 24721U 97005B   24187.56397395  .00152402 -42902-6  12025-2 0  9996
2 24721  31.0912 244.5819 1153867 316.9586  34.6175 13.43716696863027
0 ARIANE 44L DEB
1 24722U 91003E   24186.48163536  .00008020  00000-0  17359-1 0  9993
2 24722   6.9144 111.7229 6589404 322.8572   6.1218  3.07736687116509
0 ARIANE 44L DEB
1 24723U 91003F   24186.88230086  .00000068  00000-0  22028-2 0  9997
2 24723   6.7449  52.8268 6833971 111.7075 210.9373  2.64928464272359
0 ARIANE 44L DEB
1 24724U 91003G   24185.44017416  .00000624  00000-0  19342-2 0  9992
2 24724   5.9673 338.4600 6760753 261.7137  22.7490  2.83842553284295
0 COSMOS 2337
1 24725U 97006A   24187.58124306  .00000026  00000-0  87802-4 0  9990
2 24725  82.6094  11.0418 0008263 295.2105  64.8129 12.60699740260180
0 COSMOS 2338
1 24726U 97006B   24187.53787510  .00000017  00000-0  34856-4 0  9999
2 24726  82.6013 355.6285 0004200 259.4218 100.6399 12.61370141260758
0 COSMOS 2339
1 24727U 97006C   24187.51907616  .00000013  00000-0  14033-4 0  9990
2 24727  82.6059 347.9049 0000976 129.4849 292.9485 12.62355711261785
0 GONETS D1 4
1 24728U 97006D   24187.51035339  .00000007  00000-0 -20871-4 0  9996
2 24728  82.6061 330.1486 0007588   5.1580 354.9589 12.63894885263301
0 GONETS D1 5
1 24729U 97006E   24187.53461490  .00000012  00000-0  91088-5 0  9994
2 24729  82.6003 335.9865 0005014  72.6437 354.6334 12.62959088262629
0 GONETS D1 6
1 24730U 97006F   24187.53875758  .00000028  00000-0  95257-4 0  9990
2 24730  82.6088 349.5371 0003342 120.0333 240.1090 12.62468232261872
0 SL-14 R/B
1 24731U 97006G   24187.17909510  .00000029  00000-0  11331-3 0  9996
2 24731  82.5998  66.8868 0041240 176.8506 300.9267 12.55262027254703
0 INTELSAT 26 (JCSAT 4)
1 24732U 97007A   24186.76084725 -.00000163  00000-0  00000-0 0  9992
2 24732  11.1841  34.4528 0006350 266.7776 264.2703  0.98908735100001
0 USA 130
1 24737U 97008A   24186.99171822 -.00000049  00000-0  00000-0 0  9991
2 24737  14.1702   8.8501 0007310 304.9780  56.5881  0.99027222 11765
0 IUS R/B(1)
1 24739U 97008C   24186.98275428  .00005409  00000-0  23040-2 0  9994
2 24739  27.6133 183.3247 7179201 276.3772  13.4320  2.39638241 45626
0 IUS R/B(2)
1 24740U 97008D   24186.66809515  .00000030  00000-0  00000-0 0  9995
2 24740  14.3584   9.2402 0025635 171.7361 188.3168  0.99500271 18702
0 ARIANE 44L DEB
1 24741U 91003H   24187.56641693  .00000491  00000-0  63077-2 0  9992
2 24741   6.5135 139.7915 6828968 301.2420 281.3469  2.65317358272154
0 INTELSAT 801
1 24742U 97009A   24186.03383021 -.00000241  00000-0  00000+0 0  9992
2 24742  11.0314  38.3917 0010868  12.2445 225.6572  0.98737555 99582
0 DIRECTV 6 (TEMPO 2)
1 24748U 97011A   24186.66072000  .00000030  00000-0  00000-0 0  9998
2 24748  12.2308  27.7301 0022099 307.6191  50.2190  0.99029738 99420
0 ARIANE 44L DEB
1 24751U 91003K   24187.47835303  .00001383  00000-0  42028-2 0  9990
2 24751   7.9266 312.4353 6214002 273.6042  22.1847  3.54832292329388
0 SL-8 DEB
1 24752U 91006C   24186.53585583  .00000419  00000-0  37910-3 0  9996
2 24752  82.9089 217.2492 0023032 206.3065 306.3097 13.81478957453044
0 DMSP 5D-2 F14 (USA 131)
1 24753U 97012A   24187.55625116  .00000167  00000-0  10693-3 0  9999
2 24753  98.8588 232.2890 0008018 329.7572  30.3138 14.16282548407546
0 COSMOS 2340
1 24761U 97015A   24186.75868408 -.00000576  00000-0  00000-0 0  9998
2 24761  65.3404 211.9736 6699216 159.7109 250.5569  2.00642379199558
0 SL-6 R/B(2)
1 24764U 97015D   24187.21513150 -.00000677  00000-0  00000-0 0  9996
2 24764  65.5060 129.0583 6313426 147.1785 276.0753  2.03168103202067
0 THAICOM 3
1 24768U 97016A   24187.53883869 -.00000224  00000-0  00000-0 0  9991
2 24768  12.0422  30.1790 0091895  36.1275 177.8599  0.98753500 98916
0 BSAT-1A
1 24769U 97016B   24187.16703663  .00000022  00000-0  00000-0 0  9999
2 24769   9.7699  46.3964 0000697  15.4321 173.9803  0.99118109 39742
0 COSMOS 2341
1 24772U 97017A   24187.54991123  .00000068  00000-0  58054-4 0  9992
2 24772  82.9228 290.4825 0026871  75.8025 295.1943 13.71528344561526
0 SL-8 R/B
1 24773U 97017B   24187.57408612  .00000080  00000-0  69291-4 0  9991
2 24773  82.9209 264.4146 0023742 341.6767 133.4630 13.73835077364191
0 DMSP 5D-2 F14 DEB
1 24778U 97012E   24187.14966450  .00014197  00000-0  26199-2 0  9995
2 24778  98.8167 248.4712 0005340 116.6468 265.2241 14.65580696426724
0 GOES 10
1 24786U 97019A   24187.06253500 -.00000028  00000-0  00000-0 0  9997
2 24786  12.2826  25.9895 0028515 216.1015 150.0633  0.99121268 99010
0 IRIDIUM 7
1 24793U 97020B   24187.42459771  .00000595  00000-0  20112-3 0  9992
2 24793  86.3971 322.1926 0002137  99.6895 260.4542 14.35278301422145
0 IRIDIUM 5
1 24795U 97020D   24187.57320109  .00003710  00000-0  35101-3 0  9998
2 24795  86.3914 242.6646 0118712 297.4726  61.4469 14.88105181433802
0 IRIDIUM 4
1 24796U 97020E   24187.41969294  .00000610  00000-0  20236-3 0  9995
2 24796  86.3967 319.3015 0002004  94.7743 265.3682 14.36205204422682
0 DELTA 2 R/B
1 24797U 97020F   24187.60729601  .00002004  00000-0  41086-3 0  9998
2 24797  86.8971 129.6126 0219856   5.0985 167.3812 14.46065033429673
0 DFH-3 2
1 24798U 97021A   24187.19451571  .00000113  00000-0  00000-0 0  9999
2 24798  12.9012  18.8855 0011942  97.9470 267.0235  1.00221660 99387
0 COSMOS 2342
1 24800U 97022A   24186.30772585  .00000501  00000-0  00000-0 0  9998
2 24800  67.4388 308.0868 6729097 144.9985 287.6179  1.99539909198186
0 SL-6 R/B(2)
1 24803U 97022D   24187.19485554  .00000365  00000-0  00000-0 0  9994
2 24803  69.4457 343.6085 6136608  90.7943 335.3417  2.04224464202429
0 THOR 2A
1 24808U 97025A   24187.43303314 -.00000193  00000-0  00000-0 0  9992
2 24808  10.8475  37.7477 0002536   2.2471 218.9811  0.98974775 39037
0 DELTA 2 R/B(1)
1 24809U 97025B   24187.60099495  .00000210  00000-0  58965-4 0  9990
2 24809  26.2936 299.9710 0664307  55.4724 310.6706 13.30555327319137
0 DELTA 2 R/B(2)
1 24810U 97025C   24186.82827281 -.00000056  00000-0  00000-0 0  9999
2 24810  19.7539  40.3724 6952224 176.5792 182.1020  2.16106889214235
0 GALAXY 25 (TELSTAR 5)
1 24812U 97026A   24186.84368999  .00000075  00000-0  00000+0 0  9999
2 24812   5.5844  75.9263 0011137   1.2700 215.1107  0.99090671 99152
0 SL-12 R/B(2)
1 24815U 97026D   24187.36232598 -.00000042  00000-0  00000-0 0  9991
2 24815  17.7400  88.6024 5330829 292.3667 338.9707  1.89869402188027
0 PEGASUS DEB
1 24817U 94029ABU 24187.58937244  .00002049  00000-0  55038-3 0  9999
2 24817  81.6922 304.8951 0389732 350.2887  20.6142 14.11128389419958
0 SL-8 DEB
1 24818U 77087C   24187.50149733  .00000495  00000-0  45109-3 0  9996
2 24818  82.9667 265.1280 0030235 266.0555 107.1732 13.81300620351340
0 INMARSAT 3-F4
1 24819U 97027A   24187.24424378  .00000081  00000-0  00000-0 0  9994
2 24819  10.2181  43.1500 0013576  50.8683 141.9218  0.99496885 98971
0 INSAT 2D
1 24820U 97027B   24185.88712978 -.00000218  00000-0  00000-0 0  9993
2 24820  13.0536 351.3374 0340504 110.5343  68.6089  1.04793308 42025
0 COSMOS 2344
1 24827U 97028A   24187.56952399  .00000030  00000-0  85449-3 0  9995
2 24827  63.3133 319.4403 1073875  60.4540  14.1207 11.07969458 95715
0 SL-12 R/B(2)
1 24829U 97028C   24187.58665727  .00000095  00000-0  16210-2 0  9995
2 24829  63.3322   0.8041 1064236  38.4145  19.9957 11.07247989 94962
0 SL-12 DEB
1 24833U 97028F   24187.25870302 -.00000348  00000-0 -34743-2 0  9995
2 24833  63.3292  22.8662 1067530  40.7740 121.6547 11.06766749 94216
0 FENGYUN 2A
1 24834U 97029A   24186.99250142 -.00000168  00000-0  00000-0 0  9997
2 24834  15.2951  11.0259 0102329 219.5364 143.7083  0.96050603 96562
0 IRIDIUM 914
1 24836U 97030A   24187.47094706  .00000715  00000-0  22050-3 0  9996
2 24836  86.3950 328.9066 0000565  49.9598 310.1650 14.40070396557210
0 IRIDIUM 16
1 24841U 97030F   24187.54322277  .00000705  00000-0  22678-3 0  9992
2 24841  86.4044 350.8982 0004108 107.5322 252.6325 14.37959237417170
0 IRIDIUM 911
1 24842U 97030G   24187.49888847  .00000964  00000-0  26146-3 0  9998
2 24842  86.4469 350.0269 0014731 165.1757 194.9880 14.46613637424945
0 COSMOS 2344 DEB
1 24843U 97028G   24187.55423887 -.00000078  00000-0 -36154-3 0  9990
2 24843  63.3299 288.2515 1046897  37.6482  44.4191 11.09970497 95465
0 INTELSAT 802
1 24846U 97031A   24186.90909392 -.00000026  00000-0  00000-0 0  9995
2 24846   9.9457  48.5968 0021081 278.4396   7.2461  0.98107641 97946
0 SL-16 DEB
1 24866U 96051H   24187.61351028 -.00000137  00000-0 -49755-4 0  9992
2 24866  71.1244  23.6237 0063227 285.2628  74.1509 14.10561307432196
0 IRIDIUM 17
1 24870U 97034B   24187.59353922  .00000640  00000-0  20914-3 0  9993
2 24870  86.3956  20.4605 0003710  79.6410 280.5205 14.37051148413795
0 IRIDIUM 920
1 24871U 97034C   24187.55477907  .00000691  00000-0  20983-3 0  9992
2 24871  86.3982   0.5166 0012920 137.8011 222.4185 14.40768789416653
0 IRIDIUM 921
1 24873U 97034E   24187.51349368  .00033903  00000-0  82791-3 0  9996
2 24873  86.3813 279.0316 0005360 160.8642 199.2815 15.40682128478005
0 NAVSTAR 43 (USA 132)
1 24876U 97035A   24187.22637664 -.00000032  00000-0  00000-0 0  9995
2 24876  55.6757 126.4274 0080765  52.4444 308.2464  2.00565556197670
0 SUPERBIRD C
1 24880U 97036A   24186.67411154  .00000049  00000-0  00000-0 0  9990
2 24880  10.8549  39.0869 0006849  13.5251 346.4865  0.99069822 57812
0 ORBVIEW 2 (SEASTAR)
1 24883U 97037A   24187.62930704  .00000471  00000-0  18305-3 0  9996
2 24883  98.7776 327.8093 0003213  74.3170 285.8369 14.34581524420682
0 PAS 6
1 24891U 97040A   24187.15104355 -.00000214  00000-0  00000+0 0  9997
2 24891   9.9229 329.8397 0671350 238.9685 307.3379  0.93698659 92526
0 ARIANE 44P R/B
1 24892U 97040B   24187.43472634  .00013388  00000-0  22872-2 0  9996
2 24892   7.3564 189.9252 6265729 100.9975 330.9069  3.66039534299577
0 SL-3 DEB
1 24893U 88032C   24187.52565346  .00002092  00000-0  16624-3 0  9990
2 24893  97.5382 161.2773 0028830  95.7408  42.3225 15.01201840721878
0 COSMOS 2345
1 24894U 97041A   24186.34030521 -.00000184  00000-0  00000-0 0  9991
2 24894  14.3476   3.1434 0162424 281.7046 284.4936  1.00268813 98503
0 SL-12 R/B(2)
1 24897U 97041D   24187.53253744 -.00000157  00000-0  00000-0 0  9990
2 24897  14.4490   3.4504 0356803 283.9490  80.3835  0.99992075 98240
0 ABS 3 (AGILA 2)
1 24901U 97042A   24187.24424378  .00000067  00000-0  00000-0 0  9997
2 24901   9.7666  48.5470 0003807  94.9050  97.4844  0.99258856 98167
0 IRIDIUM 26
1 24903U 97043A   24187.58027872  .00000518  00000-0  17022-3 0  9991
2 24903  86.3950 256.0368 0002344  99.2496 260.8966 14.36424055406970
0 IRIDIUM 22
1 24907U 97043E   24187.58046298  .00000540  00000-0  18178-3 0  9996
2 24907  86.3954 259.2890 0002239  93.7794 266.3658 14.35312125407047
0 DELTA 1 DEB
1 24911U 81070M   24186.80602046  .00000079  00000-0  29540-3 0  9999
2 24911  90.5798  38.6963 6196704  86.1503   6.7078  3.52403898345628
0 NOAA 7 DEB
1 24914U 81059F   24187.58439860  .00001176  00000-0  37951-3 0  9991
2 24914  98.5445 230.5890 0023008 102.1258 258.2510 14.40858294402066
0 INTELSAT 5 (PAS 5)
1 24916U 97046A   24187.41918175 -.00000074  00000-0  00000-0 0  9998
2 24916   8.8404  55.3210 0003265  92.3681  93.2554  1.00271914 98481
0 SL-12 R/B(2)
1 24919U 97046D   24187.47632623 -.00000052  00000-0  00000-0 0  9994
2 24919  12.1253 189.0430 4866439 240.8383 153.8252  1.79819653176340
0 FORTE
1 24920U 97047A   24187.39196058  .00000274  00000-0  13562-3 0  9990
2 24920  69.9520 180.9985 0021987 175.4519 184.6807 14.27166306397097
0 PEGASUS R/B
1 24921U 97047B   24187.49833278  .00000181  00000-0  99393-4 0  9998
2 24921  69.9697 213.5633 0019552 153.0985 316.9066 14.26081779396792
0 DUMMY MASS 1
1 24925U 97048A   24187.57352578  .00000674  00000-0  73525-4 0  9997
2 24925  86.3349 295.4926 0004733 307.0463  53.0328 14.86270983453870
0 DUMMY MASS 2
1 24926U 97048B   24187.54580802  .00000665  00000-0  72906-4 0  9990
2 24926  86.3349 297.0520 0005838 320.1169  39.9625 14.86028741453411
0 W75/ABS-1B (HOT BIRD 3)
1 24931U 97049A   24187.19817066 -.00000169  00000-0  00000-0 0  9995
2 24931  10.2327  37.6635 0027163  35.8003 330.3290  1.02481377 99409
0 METEOSAT 7
1 24932U 97049B   24187.05853196 -.00000014  00000-0  00000-0 0  9994
2 24932  13.0561  19.6899 0010287  54.5890 296.3872  0.98308034 97748
0 AMC-3 (GE-3)
1 24936U 97050A   24187.17415241 -.00000270  00000-0  00000+0 0  9991
2 24936   6.3915  71.9943 0002474  43.8009 158.5291  1.00270733 98308
0 ATLAS 2AS CENTAUR R/B
1 24937U 97050B   24187.30026765  .00001958  00000-0  19438-2 0  9997
2 24937  18.4484 222.0954 7312637 190.9282 133.4067  2.20627968199140
0 IRIDIUM 29
1 24944U 97051A   24187.57759777  .00000580  00000-0  19387-3 0  9995
2 24944  86.3955 289.1934 0002005  90.2024 269.9403 14.35761592403521
0 IRIDIUM 33
1 24946U 97051C   24187.55190286  .00000466  00000-0  15869-3 0  9993
2 24946  86.3871 288.4544 0009778 122.3819 237.8324 14.34408136403046
0 IRIDIUM 28
1 24948U 97051E   24187.56930247  .00000611  00000-0  20074-3 0  9991
2 24948  86.3959 286.9092 0002513 102.0079 258.1400 14.36716306404066
0 COSMOS 2346
1 24953U 97052A   24187.45937928  .00000070  00000-0  52110-4 0  9995
2 24953  82.9225 160.1895 0040005 162.2554 318.2891 13.79717552348225
0 FAISAT 2V
1 24954U 97052B   24187.42361477  .00000091  00000-0  72273-4 0  9998
2 24954  82.9229 157.6928 0040034 152.2084  18.8272 13.80201163348816
0 SL-8 R/B
1 24955U 97052C   24187.38692406  .00000059  00000-0  40080-4 0  9998
2 24955  82.9213 136.8461 0031191  72.6429 287.8138 13.81769855350105
0 NIMBUS 2 DEB
1 24956U 66040C   24187.29298350  .00002355  00000-0  31942-2 0  9998
2 24956 100.4626 314.5791 0042418 353.1042  35.7667 13.60179814842406
0 NSS 5 (INTELSAT 803)
1 24957U 97053A   24186.91299477 -.00000107  00000-0  00000-0 0  9999
2 24957   8.9900  53.9834 0002285 150.8844  61.3597  0.99105633 97894
0 OPS 0856 DEB
1 24959U 66077R   24186.07768755 -.00000211  00000-0 -60931-2 0  9998
2 24959  87.2373 214.4411 2115630  78.5578 354.6300  8.99440065115144
0 MOLNIYA 1-90
1 24960U 97054A   24187.41404201 -.00000104  00000-0  28013-2 0  9996
2 24960  64.2943 354.3720 6091116 291.3731  16.0373  3.18685939231878
0 IRIDIUM 36
1 24967U 97056C   24187.43893768  .00000714  00000-0  23498-3 0  9996
2 24967  86.3976 318.6294 0002290  90.4872 269.6587 14.36874705402414
0 IRS 1D
1 24971U 97057A   24187.48748775  .00000314  00000-0  12463-3 0  9990
2 24971  98.7631 156.2253 0053006 162.8167 197.4827 14.34784065400529
0 PEGASUS DEB
1 24973U 94029ACF 24187.42469260  .00007202  00000-0  16155-2 0  9995
2 24973  82.0173 343.5502 0317763 130.7121 262.6848 14.29650173446864
0 SL-8 DEB
1 24974U 92053C   24187.36534898  .00001077  00000-0  39955-3 0  9992
2 24974  74.0531 250.0839 0021365  70.8357  55.1624 14.33290560419518
0 PEGASUS DEB
1 24978U 94029ACL 24187.21337012  .00045415  00000-0  28736-2 0  9992
2 24978  81.4289 276.4292 0198267 140.3478 221.2435 14.93917916450105
0 PEGASUS DEB
1 24980U 94029ACN 24187.32760324  .00017681  00000-0  26507-2 0  9991
2 24980  81.5853 203.0297 0241944  90.9059 271.9866 14.56576920443087
0 PEGASUS DEB
1 24985U 94029ACT 24186.98976495  .00010503  00000-0  32893-2 0  9996
2 24985  81.5151  76.6457 0636061  33.7226 330.2735 13.63103492501833
0 SL-12 DEB
1 24990U 87079J   24186.91388438  .00000459  00000-0  31975-2 0  9995
2 24990  64.8559  48.6193 5252999  51.7063 345.0055  4.80142099470096
0 PEGASUS DEB
1 24996U 94029ADD 24187.40371627  .00031587  00000-0  59516-2 0  9998
2 24996  82.1814 322.3883 0276569 137.0028 225.3146 14.42666509393800
0 TITAN 3C TRANSTAGE DEB
1 25000U 68081G   24187.51577319  .00000065  00000-0  00000-0 0  9991
2 25000   1.2120 349.2335 0115073 330.6570 344.7428  1.01030451118125
0 TITAN 3C TRANSTAGE DEB
1 25001U 68081H   24187.18764091  .00000071  00000-0  00000-0 0  9997
2 25001   0.9905   2.3537 0067169  35.0381 309.7632  1.01691947111070
0 ECHOSTAR 3
1 25004U 97059A   24187.48281687  .00000037  00000-0  00000-0 0  9997
2 25004   7.8534  62.4216 0014411 343.6356 281.3775  0.98872406 97566
0 APSTAR 2R (TELSTAR 10)
1 25010U 97062A   24186.98261201 -.00000262  00000-0  00000-0 0  9993
2 25010   9.1892  53.9301 0006293 294.1213 264.1365  0.99213653 97463
0 USA 134
1 25019U 97065A   24187.52726450 -.00000074  00000-0  00000-0 0  9999
2 25019  11.9308  26.7289 0001619  42.1354 292.8592  1.00273391 25810
0 IABS R/B
1 25021U 97065C   24187.48507353 -.00000179  00000-0  00000-0 0  9992
2 25021  14.3175 357.6033 0042465 174.2140  64.6816  1.01050957 99300
0 MAQSAT H
1 25023U 97066A   24187.54304918  .00000762  00000-0  49090-2 0  9995
2 25023   7.9190  13.9384 6514085  96.3238  71.6816  3.10575577301764
0 MAQSAT B
1 25024U 97066B   24187.54538557  .00000012  00000-0  83258-3 0  9997
2 25024   7.9140  16.9741 6528277  89.1834  92.0273  3.08908098301039
0 TEAMSAT
1 25025U 97066C   24187.36856303  .00000006  00000-0  39356-3 0  9993
2 25025   7.8861  49.2154 6523753  25.3674 126.7501  3.08003978113251
0 ARIANE 5 DEB (SPELTRA)
1 25026U 97066D   24187.35064267  .00000039  00000-0  81325-3 0  9992
2 25026   7.9134  31.2659 6531700  60.7842 330.5066  3.08277021300484
0 SL-8 DEB
1 25027U 92053D   24187.57569468  .00001779  00000-0  55901-3 0  9994
2 25027  74.0325 352.4412 0003260 290.6334 141.0453 14.41233649426544
0 SL-8 DEB
1 25028U 93036D   24187.45690640  .00001455  00000-0  47894-3 0  9994
2 25028  74.0402 184.3607 0010960 214.0730 274.3000 14.39075747501388
0 NAVSTAR 44 (USA 135)
1 25030U 97067A   24185.30480506  .00000097  00000-0  00000-0 0  9991
2 25030  55.6130 197.4710 0021186 254.4317 111.7883  1.88437724193247
0 IRIDIUM 39
1 25042U 97069D   24187.52871786  .00001003  00000-0  26399-3 0  9996
2 25042  86.3923 359.6990 0019235  29.6327 330.5962 14.48041659398770
0 IRIDIUM 38
1 25043U 97069E   24187.57995246  .00000642  00000-0  20876-3 0  9992
2 25043  86.3958  18.9327 0003263 119.3219 240.8304 14.37321832396154
0 KUPON
1 25045U 97070A   24186.97636623 -.00000208  00000-0  00000-0 0  9993
2 25045  14.6070   0.0258 0001492 236.6121 123.3828  1.00240372 97505
0 SL-12 R/B(2)
1 25048U 97070D   24186.99015181 -.00000061  00000-0  00000-0 0  9995
2 25048  14.8067 359.6224 0018255 141.1161 221.3927  0.99631263 96936
0 SIRIUS 2 (GE-1E)
1 25049U 97071A   24187.08938084 -.00000140  00000-0  00000-0 0  9992
2 25049  10.7959  39.2334 0005839  73.3072 123.0489  0.99402341 97043
0 INDOSTAR 1
1 25050U 97071B   24187.06366628 -.00000287  00000-0  00000-0 0  9993
2 25050  12.1526  25.0527 0001713  79.2393 294.2394  1.00353785 97660
0 SL-12 R/B(AUX MOTOR)
1 25053U 97070E   24187.12677588  .00000052  00000-0  00000-0 0  9991
2 25053  44.9360 221.0809 6709885  95.1299 338.4529  2.41728284234688
0 SL-12 R/B(AUX MOTOR)
1 25054U 97070F   24187.54448406  .00122480  00000-0  19475-2 0  9991
2 25054  46.6125 160.0607 3728426  43.2854 340.7011  8.05305038548083
0 SL-8 DEB
1 25057U 90036C   24187.42660566  .00000424  00000-0  37046-3 0  9997
2 25057  82.9396 182.2154 0022034  39.4726 113.3274 13.83408913612812
0 JCSAT 5
1 25067U 97075A   24186.76685181 -.00000034  00000-0  00000-0 0  9999
2 25067  10.1740  44.8807 0018487 154.6508  38.7271  0.98653459 99806
0 EQUATOR S
1 25068U 97075B   24186.45310019 -.00000366  00000-0  32743-2 0  9990
2 25068   8.4776 346.4568 8265995 145.9572 316.7845  1.07769561104773
0 ASTRA 1G
1 25071U 97076A   24187.51514662 -.00000073  00000-0  00000-0 0  9997
2 25071   7.8515  61.3653 0008509 112.6583  32.2809  0.99035625 97329
0 SL-12 R/B(2)
1 25074U 97076D   24187.16764580 -.00000099  00000-0  00000-0 0  9995
2 25074  12.6437  64.6637 4328184 310.9385 263.6419  1.71946439166956
0 IRIDIUM 42
1 25077U 97077A   24187.58489929  .00000588  00000-0  19744-3 0  9996
2 25077  86.3959  24.6727 0002276 104.4520 255.6929 14.35615848391459
0 IRIDIUM 44
1 25078U 97077B   24187.56585197  .00000700  00000-0  21863-3 0  9990
2 25078  86.3960   7.5398 0003992  88.1957 271.9699 14.39461327393827
0 SL-8 DEB
1 25085U 91009CX  24185.54653653  .00000267  00000-0  24375-2 0  9994
2 25085  74.1106  29.4458 0187837  69.4220 316.9873 12.23910529324099
0 GALAXY 8
1 25086U 97078A   24187.53319550 -.00000059  00000-0  00000-0 0  9990
2 25086  13.5729  15.0094 0009400  65.8587 292.6076  0.99695524 96849
0 ARIANE 1 DEB
1 25098U 79104D   24185.36355145  .00004207  00000-0  45044-2 0  9999
2 25098  17.6227 279.6925 5447755 135.0778 284.7545  4.74377625409473
0 IRIDIUM 45
1 25104U 97082A   24187.58556873  .00013451  00000-0  73651-3 0  9996
2 25104  86.3728 213.6104 0158828 171.4141 188.9872 15.03833895399623
0 IRIDIUM 24
1 25105U 97082B   24187.56194181  .00000646  00000-0  19359-3 0  9992
2 25105  86.3911 227.0939 0013121 135.2867 224.9393 14.41247251393272
0 INTELSAT 804
1 25110U 97083A   24187.05257759 -.00000265  00000-0  00000-0 0  9992
2 25110  12.4228  22.6592 0006882  46.0087 200.8947  1.00215287 97197
0 ORBCOMM FM 8
1 25112U 97084A   24187.55449409  .00001667  00000-0  53661-3 0  9995
2 25112  45.0138 228.4068 0009500 293.3722  66.6128 14.42876134391255
0 ORBCOMM FM 10
1 25113U 97084B   24187.56535300  .00001880  00000-0  60111-3 0  9998
2 25113  45.0141 230.2600 0007383 270.9967  89.0038 14.42778209566406
0 ORBCOMM FM 11
1 25114U 97084C   24187.51973269  .00001657  00000-0  53639-3 0  9993
2 25114  45.0136 230.5938 0008122 270.7572  89.2347 14.42643265391369
0 ORBCOMM FM 12
1 25115U 97084D   24187.55019963  .00001541  00000-0  50225-3 0  9990
2 25115  45.0143 230.1635 0007151 271.4482  88.5549 14.42605748391165
0 ORBCOMM FM 9
1 25116U 97084E   24187.56293258  .00001591  00000-0  51762-3 0  9995
2 25116  45.0148 230.8065 0008064 260.3630  99.6310 14.42570633391377
0 ORBCOMM FM 5
1 25117U 97084F   24187.48270494  .00001570  00000-0  50684-3 0  9993
2 25117  45.0147 229.2549 0004860 280.7801  79.2502 14.43018323390473
0 ORBCOMM FM 6
1 25118U 97084G   24187.53015699  .00001839  00000-0  58537-3 0  9997
2 25118  45.0129 229.1658 0004115 286.3116 186.6828 14.43100217391398
0 ORBCOMM FM 7
1 25119U 97084H   24187.43393053  .00001657  00000-0  53261-3 0  9997
2 25119  45.0125 230.1983 0005597 274.1594  85.8616 14.43001316391371
0 HGS 1 (ASIASAT 3)
1 25126U 97086A   24187.31507458  .00000088  00000-0  00000-0 0  9997
2 25126  12.0069  37.8576 0052375  34.0586 160.3854  1.00239630 97995
0 SKYNET 4D
1 25134U 98002A   24187.61817949  .00000017  00000-0  00000-0 0  9999
2 25134  12.3218  15.0050 0006915 131.7706 249.9465  0.99150801 96323
0 DELTA 2 R/B(1)
1 25135U 98002B   24187.51126707  .00000195  00000-0  72374-4 0  9998
2 25135  26.8815 195.7898 0355846  45.5113  89.1186 13.62586611319729
0 DELTA 2 R/B(2)
1 25136U 98002C   24187.29050624 -.00000105  00000-0  00000-0 0  9993
2 25136  23.9353 314.4478 6962422 283.0027  10.5062  2.19854775212746
0 DELTA 2 DEB
1 25138U 98002E   24187.42547141  .00001675  00000-0  11885-2 0  9992
2 25138  26.8762 156.9636 0327409 358.4516 144.8389 13.70733475324157
0 ATLAS 2A R/B
1 25149U 98005B   24187.54447958  .00000863  00000-0  11988-1 0  9996
2 25149  62.0831 268.3124 7110202 274.5226  14.7191  2.06878126 37261
0 BRAZILSAT B3
1 25152U 98006A   24186.86276925 -.00000016  00000-0  00000-0 0  9992
2 25152   9.2711  53.8098 0004658  62.8256 144.4966  0.99218145 36149
0 INMARSAT 3-F5
1 25153U 98006B   24187.18791617 -.00000300  00000-0  00000-0 0  9995
2 25153   8.0859  59.9370 0004345  44.2958 193.0301  1.00276188 96756
0 TRANSIT 5B-2 DEB
1 25156U 63049N   24187.46533510  .00000758  00000-0  10658-2 0  9992
2 25156  89.9148  78.0240 0041884 310.5860 223.1723 13.55916496302520
0 GFO
1 25157U 98007A   24187.59899264  .00015427  00000-0  58688-3 0  9995
2 25157 108.0275 219.1722 0121032   1.7069 358.4506 15.20531108416638
0 ORBCOMM FM 3
1 25158U 98007B   24187.60272209  .00001895  00000-0  73957-3 0  9992
2 25158 107.9693 144.5785 0045668 134.8159 225.6705 14.32391893374376
0 ORBCOMM FM 4
1 25159U 98007C   24187.58087507  .00001811  00000-0  70662-3 0  9993
2 25159 107.9680 147.5097 0041237 132.5657 227.8973 14.32662020374541
0 CELESTIS 02/TAURUS R/B
1 25160U 98007D   24187.41335013  .00000128  00000-0  11392-3 0  9990
2 25160 108.0031 335.8827 0063985 269.3638 102.9546 14.22011743369317
0 TAURUS DEB
1 25161U 98007E   24187.58103062  .00000474  00000-0  24436-3 0  9993
2 25161 108.0002  65.6146 0059611 202.4343 222.9962 14.26840415371914
0 GLOBALSTAR M001
1 25162U 98008A   24187.57276441 -.00000077  00000-0  14770-3 0  9996
2 25162  52.0028 262.0575 0001730 223.4172 228.3580 12.38187494200775
0 GLOBALSTAR M004
1 25163U 98008B   24187.34127071 -.00000030  00000-0  40478-3 0  9999
2 25163  52.0014  32.2716 0002191 233.1760 297.9860 12.63364315217844
0 GLOBALSTAR M002
1 25164U 98008C   24187.26697825 -.00000063  00000-0  25949-3 0  9992
2 25164  52.0034  30.0435 0000616 201.8938 158.1855 11.61502820143752
0 GLOBALSTAR M003
1 25165U 98008D   24187.58972527  .00000056  00000-0  15543-2 0  9992
2 25165  51.9903  48.4554 0007578 320.3798  74.7693 12.12016219191199
0 COMETS
1 25175U 98011A   24186.60847758 -.00000084  00000-0  00000-0 0  9998
2 25175  30.1929 340.4986 5292560 345.1001   3.8461  4.38926177431561
0 SL-14 DEB
1 25187U 87068N   24186.92961994  .00011740  00000-0  38307-2 0  9998
2 25187  82.5437 160.0664 0007198 195.5364 164.5607 14.38536164357178
0 SL-14 DEB
1 25199U 87068AA  24187.51191543  .00001333  00000-0  12689-2 0  9994
2 25199  82.3637 109.3006 0095853 304.6813  54.5338 13.78134833320511
0 SL-14 DEB
1 25203U 87068AE  24187.28594557  .00002359  00000-0  98438-3 0  9992
2 25203  82.2683 129.4208 0093747 331.1504  28.4511 14.23574257363683
0 SL-14 DEB
1 25204U 87068AF  24187.59361608  .00004508  00000-0  29857-2 0  9992
2 25204  82.4301  35.1141 0112906  96.1306 318.9446 13.98240223330883
0 SL-14 DEB
1 25205U 87068AG  24187.39205068  .00000702  00000-0  52663-3 0  9992
2 25205  82.5368  54.5804 0015399  21.2729 154.7289 13.93186657337653
0 SL-14 DEB
1 25214U 87068AR  24187.43448296  .00002652  00000-0  15747-2 0  9996
2 25214  82.5432 334.1923 0011069 102.8836 311.5947 14.07154353344554
0 SL-14 DEB
1 25221U 87068AY  24187.37161012  .00000498  00000-0  64458-3 0  9995
2 25221  82.2985 292.0296 0166947 160.0310 264.3945 13.54872570301887
0 SL-14 DEB
1 25225U 87068BC  24187.54533781  .00009414  00000-0  42482-2 0  9993
2 25225  82.5003 321.8045 0061370 229.2609 248.6623 14.21055933342661
0 SL-14 DEB
1 25226U 87068BD  24187.62066474  .00005878  00000-0  32912-2 0  9990
2 25226  82.5182  51.3895 0061788 124.0417 236.6646 14.09576592337403
0 SL-14 DEB
1 25227U 87068BE  24187.45249771  .00009106  00000-0  33767-2 0  9992
2 25227  82.5266 185.7185 0012093 353.3294   6.7730 14.32109862354223
0 EUTE 16B (HB 4)
1 25237U 98013A   24187.12946194 -.00000006  00000-0  00000-0 0  9995
2 25237   9.5442  52.2228 0004536   8.0576 332.8000  0.98274961 33222
0 NSS 806 (INTELSAT 806)
1 25239U 98014A   24187.17225799 -.00000079  00000-0  00000-0 0  9994
2 25239   5.3015  78.2215 0007166  48.4061 137.5899  0.99076691 39916
0 SL-14 DEB
1 25246U 87068BP  24187.44193470  .00001343  00000-0  65353-3 0  9998
2 25246  82.2495 213.2868 0078796 324.7412 101.5457 14.16033125355935
0 ATLAS CENTAUR DEB
1 25253U 78068C   24187.60417203 -.00000126  00000-0  67661-3 0  9990
2 25253  21.5954 277.7559 7067390  44.1414 358.1148  2.25038617221949
0 SL-16 DEB
1 25254U 93059H   24187.20409851  .00000658  00000-0  31517-3 0  9994
2 25254  70.9878 105.0053 0016455 338.3403 184.4085 14.22699681396273
0 SL-3 DEB
1 25255U 81043D   24187.30900912  .00000377  00000-0  21103-3 0  9998
2 25255  81.2850 147.2158 0048040  80.2110  44.9789 14.08291493421774
0 UFO 8 (USA 138)
1 25258U 98016A   24186.75786396 -.00000076  00000-0  00000-0 0  9992
2 25258  10.2695  26.6409 0002609 217.9594 304.6379  1.00308097 96711
0 SPOT 4
1 25260U 98017A   24187.53945638  .00000640  00000-0  15962-3 0  9991
2 25260  98.2575 280.6952 0011596 261.7946  98.1936 14.54818493375785
0 ARIANE 40 R/B
1 25261U 98017B   24187.55778667  .00000649  00000-0  24338-3 0  9996
2 25261  98.8476 189.5125 0004623  70.0315 290.1367 14.35169612373865
0 IRIDIUM 51
1 25262U 98018A   24187.58162177  .00020429  00000-0  91227-3 0  9993
2 25262  86.3939 223.3755 0145533 114.9423 246.7018 15.12113128394198
0 DELTA 1 DEB
1 25270U 68055E   24187.27911675  .00000150  00000-0  59505-3 0  9993
2 25270 120.6613 307.8413 2147302 344.1501  10.1217 10.01183058373507
0 IRIDIUM 57
1 25273U 98019B   24187.34271464  .00000525  00000-0  17678-3 0  9993
2 25273  86.3960 290.5160 0002199  94.9230 265.2217 14.35270635375022
0 ARIANE 44LP DEB
1 25279U 89062E   24186.47355634  .00001371  00000-0  21533-2 0  9996
2 25279   7.6720   1.0847 7034079 243.6852  30.6377  2.53534214245814
0 TRACE
1 25280U 98020A   24187.51402356  .00020083  00000-0  59743-3 0  9998
2 25280  97.4500  19.6084 0016309  96.2960 264.0141 15.34633739440340
0 PEGASUS R/B
1 25281U 98020B   24187.53797320  .00016692  00000-0  50296-3 0  9994
2 25281  97.4038  35.9927 0007955 147.9914 212.1813 15.34367904443109
0 ARIANE 44LP DEB
1 25282U 89062F   24187.07144371  .00006164  00000-0  97983-2 0  9998
2 25282   7.4241 104.6086 6848397  33.9384 354.9721  2.76425354258609
0 START 1 DEB
1 25284U 93014F   24187.59936388  .00000527  00000-0  18571-3 0  9990
2 25284  75.7624   1.4569 0180960 248.7506 176.8559 14.27593123367481
0 IRIDIUM 63
1 25286U 98021B   24187.56847803  .00000539  00000-0  17964-3 0  9993
2 25286  86.3984 227.3217 0002173  89.2164 270.9282 14.35821463374090
0 GLOBALSTAR M014
1 25306U 98023A   24187.62440831 -.00000064  00000-0  24592-3 0  9994
2 25306  51.9859 319.6595 0001510  99.7169 273.3562 11.65469379150769
0 GLOBALSTAR M006
1 25307U 98023B   24187.52821990 -.00000093  00000-0 -36020-3 0  9995
2 25307  51.9961 359.4189 0003729 187.8243 244.3907 11.58163109176663
0 GLOBALSTAR M015
1 25308U 98023C   24187.44522792 -.00000140  00000-0 -15060-2 0  9998
2 25308  51.9829  82.2032 0012096 178.1476 353.1292 11.48851585154228
0 GLOBALSTAR M008
1 25309U 98023D   24187.59423875 -.00000105  00000-0 -73651-4 0  9990
2 25309  51.9960 122.8955 0002221 157.1675  14.1333 12.36044955194987
0 NILESAT
1 25311U 98024A   24187.19747448 -.00000075  00000-0  00000-0 0  9994
2 25311   9.0674  57.5768 0020909 282.9749  59.2165  0.97393587 43409
0 BSAT-1B
1 25312U 98024B   24187.19999814  .00000068  00000-0  00000-0 0  9992
2 25312  10.0134  50.7734 0000656 162.7287 200.3090  0.99116982 39102
0 COSMOS 2350
1 25315U 98025A   24187.02133124 -.00000160  00000-0  00000-0 0  9996
2 25315  13.6997   8.9119 0009881 139.8492 221.4109  1.00283568 95874
0 SL-12 R/B(2)
1 25318U 98025D   24186.75708075 -.00000156  00000-0  00000-0 0  9996
2 25318  13.7222   8.9496 0034122 115.0617  60.9527  1.00065299 95642
0 IRIDIUM 69
1 25319U 98026A   24187.58291007  .00000660  00000-0  20322-3 0  9993
2 25319  86.3971 241.6459 0004629  90.0741 270.0988 14.40065939373164
0 IRIDIUM 71
1 25320U 98026B   24187.57896489  .00000601  00000-0  18340-3 0  9991
2 25320  86.3973 236.4051 0003919 120.5044 239.6542 14.40375514373681
0 COSMOS 2351
1 25327U 98027A   24186.97114137  .00000982  00000-0  00000-0 0  9998
2 25327  63.6443 208.2601 7152500 179.1624 183.6448  2.00576407191675
0 ECHOSTAR 4
1 25331U 98028A   24186.62907213  .00000047  00000-0  00000-0 0  9993
2 25331  10.5969  35.9041 0008312 302.0521 237.4095  0.98948682 95283
0 SL-12 R/B(2)
1 25334U 98028D   24187.20078133 -.00000201  00000-0  00000-0 0  9994
2 25334  17.0511  53.6677 4876670 233.8639  71.4813  1.82178218174082
0 TITAN 4B CENTAUR R/B
1 25337U 98029B   24187.11496116  .00000090  00000-0  00000-0 0  9998
2 25337   8.1956 342.0366 0050003 161.5279 198.7312  1.00222424 18708
0 NOAA 15
1 25338U 98030A   24187.54216016  .00000340  00000-0  15862-3 0  9990
2 25338  98.5675 214.2851 0009064 271.0816  88.9326 14.26619704359801
0 SL-12 R/B(2)
1 25339U 96053D   24186.95781858 -.00000079  00000-0  00000-0 0  9994
2 25339  14.9111   8.3520 0049438 296.7178 243.3098  0.98094283 93652
0 IRIDIUM 73
1 25344U 98032C   24187.51237501  .00000833  00000-0  20733-3 0  9998
2 25344  86.4439 193.8546 0002983  89.7729 270.3817 14.50609810380287
0 TITAN 4B CENTAUR R/B
1 25349U 96026B   24186.92172972 -.00000247  00000-0  00000-0 0  9990
2 25349   7.1946 347.8048 0438006  27.0042 335.2703  0.99560988 18547
0 METEOSAT 7 AKM
1 25353U 97049E   24186.60985219  .00000024  00000-0  00000-0 0  9994
2 25353  14.0701   4.5602 0071361 317.7785  41.6794  1.00649728104335
0 CHINASAT 5A (CHINASTAR1)
1 25354U 98033A   24186.91021476 -.00000066  00000-0  00000-0 0  9996
2 25354   7.2173  68.3911 0004867  95.1116 110.0148  0.98994331 38885
0 THOR 3
1 25358U 98035A   24187.54072887 -.00000248  00000-0  00000-0 0  9996
2 25358  10.4482  44.5917 0004377 126.6095  78.2649  0.98830521 95459
0 DELTA 2 R/B(1)
1 25359U 98035B   24187.52088676  .00000136  00000-0  79772-4 0  9999
2 25359  26.3853  14.8630 0513289  68.9541 316.5172 12.94546785234360
0 DELTA 2 R/B(2)
1 25360U 98035C   24187.54357153 -.00000034  00000-0  00000-0 0  9994
2 25360  19.8234   8.8066 6930807  37.6978 246.7148  2.11092357200808
0 COSMOS 2352
1 25363U 98036A   24187.17695840  .00000021