# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecurityZoneResult',
    'AwaitableGetSecurityZoneResult',
    'get_security_zone',
    'get_security_zone_output',
]

@pulumi.output_type
class GetSecurityZoneResult:
    """
    A collection of values returned by getSecurityZone.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, inherited_by_compartments=None, lifecycle_details=None, security_zone_id=None, security_zone_recipe_id=None, security_zone_target_id=None, state=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inherited_by_compartments and not isinstance(inherited_by_compartments, list):
            raise TypeError("Expected argument 'inherited_by_compartments' to be a list")
        pulumi.set(__self__, "inherited_by_compartments", inherited_by_compartments)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if security_zone_id and not isinstance(security_zone_id, str):
            raise TypeError("Expected argument 'security_zone_id' to be a str")
        pulumi.set(__self__, "security_zone_id", security_zone_id)
        if security_zone_recipe_id and not isinstance(security_zone_recipe_id, str):
            raise TypeError("Expected argument 'security_zone_recipe_id' to be a str")
        pulumi.set(__self__, "security_zone_recipe_id", security_zone_recipe_id)
        if security_zone_target_id and not isinstance(security_zone_target_id, str):
            raise TypeError("Expected argument 'security_zone_target_id' to be a str")
        pulumi.set(__self__, "security_zone_target_id", security_zone_target_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment for the security zone
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The security zone's description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The security zone's display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that can’t be changed after creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inheritedByCompartments")
    def inherited_by_compartments(self) -> Sequence[str]:
        """
        List of inherited compartments
        """
        return pulumi.get(self, "inherited_by_compartments")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, this can be used to provide actionable information for a zone in the `Failed` state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="securityZoneId")
    def security_zone_id(self) -> str:
        return pulumi.get(self, "security_zone_id")

    @property
    @pulumi.getter(name="securityZoneRecipeId")
    def security_zone_recipe_id(self) -> str:
        """
        The OCID of the recipe (`SecurityRecipe` resource) for the security zone
        """
        return pulumi.get(self, "security_zone_recipe_id")

    @property
    @pulumi.getter(name="securityZoneTargetId")
    def security_zone_target_id(self) -> str:
        """
        The OCID of the target associated with the security zone
        """
        return pulumi.get(self, "security_zone_target_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the security zone
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the security zone was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the security zone was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSecurityZoneResult(GetSecurityZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityZoneResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            inherited_by_compartments=self.inherited_by_compartments,
            lifecycle_details=self.lifecycle_details,
            security_zone_id=self.security_zone_id,
            security_zone_recipe_id=self.security_zone_recipe_id,
            security_zone_target_id=self.security_zone_target_id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_security_zone(security_zone_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityZoneResult:
    """
    This data source provides details about a specific Security Zone resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a security zone (SecurityZone resource) identified by securityZoneId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_zone = oci.CloudGuard.get_security_zone(security_zone_id=test_security_zone_oci_cloud_guard_security_zone["id"])
    ```


    :param str security_zone_id: The unique identifier of the security zone (`SecurityZone` resource).
    """
    __args__ = dict()
    __args__['securityZoneId'] = security_zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getSecurityZone:getSecurityZone', __args__, opts=opts, typ=GetSecurityZoneResult).value

    return AwaitableGetSecurityZoneResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        inherited_by_compartments=pulumi.get(__ret__, 'inherited_by_compartments'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        security_zone_id=pulumi.get(__ret__, 'security_zone_id'),
        security_zone_recipe_id=pulumi.get(__ret__, 'security_zone_recipe_id'),
        security_zone_target_id=pulumi.get(__ret__, 'security_zone_target_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_security_zone_output(security_zone_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityZoneResult]:
    """
    This data source provides details about a specific Security Zone resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a security zone (SecurityZone resource) identified by securityZoneId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_zone = oci.CloudGuard.get_security_zone(security_zone_id=test_security_zone_oci_cloud_guard_security_zone["id"])
    ```


    :param str security_zone_id: The unique identifier of the security zone (`SecurityZone` resource).
    """
    __args__ = dict()
    __args__['securityZoneId'] = security_zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getSecurityZone:getSecurityZone', __args__, opts=opts, typ=GetSecurityZoneResult)
    return __ret__.apply(lambda __response__: GetSecurityZoneResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        inherited_by_compartments=pulumi.get(__response__, 'inherited_by_compartments'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        security_zone_id=pulumi.get(__response__, 'security_zone_id'),
        security_zone_recipe_id=pulumi.get(__response__, 'security_zone_recipe_id'),
        security_zone_target_id=pulumi.get(__response__, 'security_zone_target_id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
