# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSchedulerDefinitionScheduledFleetsResult',
    'AwaitableGetSchedulerDefinitionScheduledFleetsResult',
    'get_scheduler_definition_scheduled_fleets',
    'get_scheduler_definition_scheduled_fleets_output',
]

@pulumi.output_type
class GetSchedulerDefinitionScheduledFleetsResult:
    """
    A collection of values returned by getSchedulerDefinitionScheduledFleets.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, scheduled_fleet_collections=None, scheduler_definition_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scheduled_fleet_collections and not isinstance(scheduled_fleet_collections, list):
            raise TypeError("Expected argument 'scheduled_fleet_collections' to be a list")
        pulumi.set(__self__, "scheduled_fleet_collections", scheduled_fleet_collections)
        if scheduler_definition_id and not isinstance(scheduler_definition_id, str):
            raise TypeError("Expected argument 'scheduler_definition_id' to be a str")
        pulumi.set(__self__, "scheduler_definition_id", scheduler_definition_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSchedulerDefinitionScheduledFleetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="scheduledFleetCollections")
    def scheduled_fleet_collections(self) -> Sequence['outputs.GetSchedulerDefinitionScheduledFleetsScheduledFleetCollectionResult']:
        """
        The list of scheduled_fleet_collection.
        """
        return pulumi.get(self, "scheduled_fleet_collections")

    @property
    @pulumi.getter(name="schedulerDefinitionId")
    def scheduler_definition_id(self) -> str:
        return pulumi.get(self, "scheduler_definition_id")


class AwaitableGetSchedulerDefinitionScheduledFleetsResult(GetSchedulerDefinitionScheduledFleetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulerDefinitionScheduledFleetsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            scheduled_fleet_collections=self.scheduled_fleet_collections,
            scheduler_definition_id=self.scheduler_definition_id)


def get_scheduler_definition_scheduled_fleets(compartment_id: Optional[str] = None,
                                              display_name: Optional[str] = None,
                                              filters: Optional[Sequence[Union['GetSchedulerDefinitionScheduledFleetsFilterArgs', 'GetSchedulerDefinitionScheduledFleetsFilterArgsDict']]] = None,
                                              scheduler_definition_id: Optional[str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulerDefinitionScheduledFleetsResult:
    """
    This data source provides the list of Scheduler Definition Scheduled Fleets in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of ScheduledFleets

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_definition_scheduled_fleets = oci.FleetAppsManagement.get_scheduler_definition_scheduled_fleets(scheduler_definition_id=test_scheduler_definition["id"],
        compartment_id=compartment_id,
        display_name=scheduler_definition_scheduled_fleet_display_name)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str scheduler_definition_id: unique SchedulerDefinition identifier
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['schedulerDefinitionId'] = scheduler_definition_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getSchedulerDefinitionScheduledFleets:getSchedulerDefinitionScheduledFleets', __args__, opts=opts, typ=GetSchedulerDefinitionScheduledFleetsResult).value

    return AwaitableGetSchedulerDefinitionScheduledFleetsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        scheduled_fleet_collections=pulumi.get(__ret__, 'scheduled_fleet_collections'),
        scheduler_definition_id=pulumi.get(__ret__, 'scheduler_definition_id'))
def get_scheduler_definition_scheduled_fleets_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                     display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSchedulerDefinitionScheduledFleetsFilterArgs', 'GetSchedulerDefinitionScheduledFleetsFilterArgsDict']]]]] = None,
                                                     scheduler_definition_id: Optional[pulumi.Input[str]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulerDefinitionScheduledFleetsResult]:
    """
    This data source provides the list of Scheduler Definition Scheduled Fleets in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of ScheduledFleets

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_definition_scheduled_fleets = oci.FleetAppsManagement.get_scheduler_definition_scheduled_fleets(scheduler_definition_id=test_scheduler_definition["id"],
        compartment_id=compartment_id,
        display_name=scheduler_definition_scheduled_fleet_display_name)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str scheduler_definition_id: unique SchedulerDefinition identifier
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['schedulerDefinitionId'] = scheduler_definition_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getSchedulerDefinitionScheduledFleets:getSchedulerDefinitionScheduledFleets', __args__, opts=opts, typ=GetSchedulerDefinitionScheduledFleetsResult)
    return __ret__.apply(lambda __response__: GetSchedulerDefinitionScheduledFleetsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        scheduled_fleet_collections=pulumi.get(__response__, 'scheduled_fleet_collections'),
        scheduler_definition_id=pulumi.get(__response__, 'scheduler_definition_id')))
