"""
    IRN API v1

    Allows users to extract, create, update and configure IRN data.  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.IRNConfiguration.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.IRNConfiguration.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.IRNConfiguration.exceptions import ApiException
from fds.sdk.IRNConfiguration.model.custom_symbol_custom_field_config_dto import CustomSymbolCustomFieldConfigDto
from fds.sdk.IRNConfiguration.model.custom_symbol_type_detail_dto import CustomSymbolTypeDetailDto
from fds.sdk.IRNConfiguration.model.custom_symbol_type_dto import CustomSymbolTypeDto
from fds.sdk.IRNConfiguration.model.new_item_dto import NewItemDto
from fds.sdk.IRNConfiguration.model.problem_details import ProblemDetails
from fds.sdk.IRNConfiguration.model.reorder_custom_symbol_type_dto import ReorderCustomSymbolTypeDto
from fds.sdk.IRNConfiguration.model.save_custom_symbol_type_dto import SaveCustomSymbolTypeDto
from fds.sdk.IRNConfiguration.model.update_custom_symbol_type_dto import UpdateCustomSymbolTypeDto





class CustomSymbolsTypesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.create_custom_symbol_type_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 201: (NewItemDto,), 400: (ProblemDetails,), 0: (ProblemDetails,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/custom-symbol-types',
                'operation_id': 'create_custom_symbol_type',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'save_custom_symbol_type_dto',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'save_custom_symbol_type_dto':
                        (SaveCustomSymbolTypeDto,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'save_custom_symbol_type_dto': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )

        self.delete_custom_symbol_type_async_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/custom-symbol-types/{customSymbolTypeId}',
                'operation_id': 'delete_custom_symbol_type_async',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'custom_symbol_type_id',
                ],
                'required': [
                    'custom_symbol_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'custom_symbol_type_id':
                        (str,),
                },
                'attribute_map': {
                    'custom_symbol_type_id': 'customSymbolTypeId',
                },
                'location_map': {
                    'custom_symbol_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_custom_symbol_type_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (CustomSymbolTypeDetailDto,), 404: (ProblemDetails,), 0: (ProblemDetails,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/custom-symbol-types/{customSymbolTypeId}',
                'operation_id': 'get_custom_symbol_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'custom_symbol_type_id',
                ],
                'required': [
                    'custom_symbol_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'custom_symbol_type_id':
                        (str,),
                },
                'attribute_map': {
                    'custom_symbol_type_id': 'customSymbolTypeId',
                },
                'location_map': {
                    'custom_symbol_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_custom_symbol_types_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: ([CustomSymbolTypeDto],),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/custom-symbol-types',
                'operation_id': 'get_custom_symbol_types',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_symbol_custom_fields_for_custom_symbol_type_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: ([CustomSymbolCustomFieldConfigDto],), 404: (ProblemDetails,), 0: (ProblemDetails,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/custom-symbol-types/{customSymbolTypeId}/custom-fields',
                'operation_id': 'get_symbol_custom_fields_for_custom_symbol_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'custom_symbol_type_id',
                ],
                'required': [
                    'custom_symbol_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'custom_symbol_type_id':
                        (str,),
                },
                'attribute_map': {
                    'custom_symbol_type_id': 'customSymbolTypeId',
                },
                'location_map': {
                    'custom_symbol_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.update_custom_symbol_type_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/custom-symbol-types/{customSymbolTypeId}',
                'operation_id': 'update_custom_symbol_type',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'custom_symbol_type_id',
                    'update_custom_symbol_type_dto',
                ],
                'required': [
                    'custom_symbol_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'custom_symbol_type_id':
                        (str,),
                    'update_custom_symbol_type_dto':
                        (UpdateCustomSymbolTypeDto,),
                },
                'attribute_map': {
                    'custom_symbol_type_id': 'customSymbolTypeId',
                },
                'location_map': {
                    'custom_symbol_type_id': 'path',
                    'update_custom_symbol_type_dto': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )

        self.update_custom_symbol_type_order_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/custom-symbol-types/reorder',
                'operation_id': 'update_custom_symbol_type_order',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'reorder_custom_symbol_type_dto',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'reorder_custom_symbol_type_dto':
                        (ReorderCustomSymbolTypeDto,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'reorder_custom_symbol_type_dto': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def create_custom_symbol_type(
        self,
        **kwargs
    ) -> NewItemDto:
        """Create a Custom symbol type  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            save_custom_symbol_type_dto (SaveCustomSymbolTypeDto): saveCustomSymbolTypeDto object to save. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NewItemDto
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.create_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def create_custom_symbol_type_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[NewItemDto, int, typing.MutableMapping]:
        """Create a Custom symbol type  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            save_custom_symbol_type_dto (SaveCustomSymbolTypeDto): saveCustomSymbolTypeDto object to save. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NewItemDto
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.create_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def create_custom_symbol_type_async(
        self,
        **kwargs
    ) -> "ApplyResult[NewItemDto]":
        """Create a Custom symbol type  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            save_custom_symbol_type_dto (SaveCustomSymbolTypeDto): saveCustomSymbolTypeDto object to save. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[NewItemDto]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.create_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def create_custom_symbol_type_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[NewItemDto, int, typing.MutableMapping]]":
        """Create a Custom symbol type  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            save_custom_symbol_type_dto (SaveCustomSymbolTypeDto): saveCustomSymbolTypeDto object to save. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(NewItemDto, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.create_custom_symbol_type_endpoint.call_with_http_info(**kwargs)


    def delete_custom_symbol_type_async(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> None:
        """Delete a Custom symbol type  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to delete associated record

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.delete_custom_symbol_type_async_endpoint.call_with_http_info(**kwargs)

    def delete_custom_symbol_type_async_with_http_info(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """Delete a Custom symbol type  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to delete associated record

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.delete_custom_symbol_type_async_endpoint.call_with_http_info(**kwargs)

    def delete_custom_symbol_type_async_async(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> "ApplyResult[None]":
        """Delete a Custom symbol type  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to delete associated record

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.delete_custom_symbol_type_async_endpoint.call_with_http_info(**kwargs)

    def delete_custom_symbol_type_async_with_http_info_async(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """Delete a Custom symbol type  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to delete associated record

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.delete_custom_symbol_type_async_endpoint.call_with_http_info(**kwargs)


    def get_custom_symbol_type(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> CustomSymbolTypeDetailDto:
        """Get a specific Custom symbol type's details  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to get associated record

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            CustomSymbolTypeDetailDto
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.get_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def get_custom_symbol_type_with_http_info(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> typing.Tuple[CustomSymbolTypeDetailDto, int, typing.MutableMapping]:
        """Get a specific Custom symbol type's details  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to get associated record

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            CustomSymbolTypeDetailDto
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.get_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def get_custom_symbol_type_async(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> "ApplyResult[CustomSymbolTypeDetailDto]":
        """Get a specific Custom symbol type's details  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to get associated record

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[CustomSymbolTypeDetailDto]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.get_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def get_custom_symbol_type_with_http_info_async(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[CustomSymbolTypeDetailDto, int, typing.MutableMapping]]":
        """Get a specific Custom symbol type's details  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to get associated record

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(CustomSymbolTypeDetailDto, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.get_custom_symbol_type_endpoint.call_with_http_info(**kwargs)


    def get_custom_symbol_types(
        self,
        **kwargs
    ) -> typing.List[CustomSymbolTypeDto]:
        """Get all the custom symbol types  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            typing.List[CustomSymbolTypeDto]
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_custom_symbol_types_endpoint.call_with_http_info(**kwargs)

    def get_custom_symbol_types_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[typing.List[CustomSymbolTypeDto], int, typing.MutableMapping]:
        """Get all the custom symbol types  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            typing.List[CustomSymbolTypeDto]
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_custom_symbol_types_endpoint.call_with_http_info(**kwargs)

    def get_custom_symbol_types_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.List[CustomSymbolTypeDto]]":
        """Get all the custom symbol types  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[typing.List[CustomSymbolTypeDto]]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_custom_symbol_types_endpoint.call_with_http_info(**kwargs)

    def get_custom_symbol_types_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[typing.List[CustomSymbolTypeDto], int, typing.MutableMapping]]":
        """Get all the custom symbol types  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(typing.List[CustomSymbolTypeDto], int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_custom_symbol_types_endpoint.call_with_http_info(**kwargs)


    def get_symbol_custom_fields_for_custom_symbol_type(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> typing.List[CustomSymbolCustomFieldConfigDto]:
        """Get Custom fields for Custom Symbol type  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to get associated Custom fileds

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            typing.List[CustomSymbolCustomFieldConfigDto]
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.get_symbol_custom_fields_for_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def get_symbol_custom_fields_for_custom_symbol_type_with_http_info(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> typing.Tuple[typing.List[CustomSymbolCustomFieldConfigDto], int, typing.MutableMapping]:
        """Get Custom fields for Custom Symbol type  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to get associated Custom fileds

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            typing.List[CustomSymbolCustomFieldConfigDto]
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.get_symbol_custom_fields_for_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def get_symbol_custom_fields_for_custom_symbol_type_async(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> "ApplyResult[typing.List[CustomSymbolCustomFieldConfigDto]]":
        """Get Custom fields for Custom Symbol type  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to get associated Custom fileds

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[typing.List[CustomSymbolCustomFieldConfigDto]]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.get_symbol_custom_fields_for_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def get_symbol_custom_fields_for_custom_symbol_type_with_http_info_async(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[typing.List[CustomSymbolCustomFieldConfigDto], int, typing.MutableMapping]]":
        """Get Custom fields for Custom Symbol type  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to get associated Custom fileds

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(typing.List[CustomSymbolCustomFieldConfigDto], int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.get_symbol_custom_fields_for_custom_symbol_type_endpoint.call_with_http_info(**kwargs)


    def update_custom_symbol_type(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> None:
        """Edit a Custom symbol type  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to update associated record

        Keyword Args:
            update_custom_symbol_type_dto (UpdateCustomSymbolTypeDto): updateCustomSymbolTypeDto object to update. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.update_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def update_custom_symbol_type_with_http_info(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """Edit a Custom symbol type  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to update associated record

        Keyword Args:
            update_custom_symbol_type_dto (UpdateCustomSymbolTypeDto): updateCustomSymbolTypeDto object to update. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.update_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def update_custom_symbol_type_async(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> "ApplyResult[None]":
        """Edit a Custom symbol type  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to update associated record

        Keyword Args:
            update_custom_symbol_type_dto (UpdateCustomSymbolTypeDto): updateCustomSymbolTypeDto object to update. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.update_custom_symbol_type_endpoint.call_with_http_info(**kwargs)

    def update_custom_symbol_type_with_http_info_async(
        self,
        custom_symbol_type_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """Edit a Custom symbol type  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            custom_symbol_type_id (str): customSymbolTypeId to update associated record

        Keyword Args:
            update_custom_symbol_type_dto (UpdateCustomSymbolTypeDto): updateCustomSymbolTypeDto object to update. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['custom_symbol_type_id'] = \
            custom_symbol_type_id
        return self.update_custom_symbol_type_endpoint.call_with_http_info(**kwargs)


    def update_custom_symbol_type_order(
        self,
        **kwargs
    ) -> None:
        """update_custom_symbol_type_order  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            reorder_custom_symbol_type_dto (ReorderCustomSymbolTypeDto): [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.update_custom_symbol_type_order_endpoint.call_with_http_info(**kwargs)

    def update_custom_symbol_type_order_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """update_custom_symbol_type_order  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            reorder_custom_symbol_type_dto (ReorderCustomSymbolTypeDto): [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.update_custom_symbol_type_order_endpoint.call_with_http_info(**kwargs)

    def update_custom_symbol_type_order_async(
        self,
        **kwargs
    ) -> "ApplyResult[None]":
        """update_custom_symbol_type_order  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            reorder_custom_symbol_type_dto (ReorderCustomSymbolTypeDto): [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.update_custom_symbol_type_order_endpoint.call_with_http_info(**kwargs)

    def update_custom_symbol_type_order_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """update_custom_symbol_type_order  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            reorder_custom_symbol_type_dto (ReorderCustomSymbolTypeDto): [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.update_custom_symbol_type_order_endpoint.call_with_http_info(**kwargs)


