from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonMath
import vtkmodules.vtkCommonTransforms

VTK_21_POINT_WEDGE:bool
VTK_3D_EXTENT:int
VTK_BEZIER_CURVE:int
VTK_BEZIER_HEXAHEDRON:int
VTK_BEZIER_PYRAMID:int
VTK_BEZIER_QUADRILATERAL:int
VTK_BEZIER_TETRAHEDRON:int
VTK_BEZIER_TRIANGLE:int
VTK_BEZIER_WEDGE:int
VTK_BIQUADRATIC_QUAD:int
VTK_BIQUADRATIC_QUADRATIC_HEXAHEDRON:int
VTK_BIQUADRATIC_QUADRATIC_WEDGE:int
VTK_BIQUADRATIC_TRIANGLE:int
VTK_CELL_SIZE:int
VTK_CONVEX_POINT_SET:int
VTK_CUBIC_LINE:int
VTK_EMPTY:int
VTK_EMPTY_CELL:int
VTK_HEXAGONAL_PRISM:int
VTK_HEXAHEDRON:int
VTK_HIGHER_ORDER_EDGE:int
VTK_HIGHER_ORDER_HEXAHEDRON:int
VTK_HIGHER_ORDER_POLYGON:int
VTK_HIGHER_ORDER_PYRAMID:int
VTK_HIGHER_ORDER_QUAD:int
VTK_HIGHER_ORDER_TETRAHEDRON:int
VTK_HIGHER_ORDER_TRIANGLE:int
VTK_HIGHER_ORDER_WEDGE:int
VTK_ICP_MODE_AV:int
VTK_ICP_MODE_RMS:int
VTK_LAGRANGE_CURVE:int
VTK_LAGRANGE_HEXAHEDRON:int
VTK_LAGRANGE_PYRAMID:int
VTK_LAGRANGE_QUADRILATERAL:int
VTK_LAGRANGE_TETRAHEDRON:int
VTK_LAGRANGE_TRIANGLE:int
VTK_LAGRANGE_WEDGE:int
VTK_LINE:int
VTK_MIN_SUPERQUADRIC_THICKNESS:float
VTK_NUMBER_OF_CELL_TYPES:int
VTK_PARAMETRIC_CURVE:int
VTK_PARAMETRIC_HEX_REGION:int
VTK_PARAMETRIC_QUAD_SURFACE:int
VTK_PARAMETRIC_SURFACE:int
VTK_PARAMETRIC_TETRA_REGION:int
VTK_PARAMETRIC_TRI_SURFACE:int
VTK_PENTAGONAL_PRISM:int
VTK_PERIODIC_ARRAY_AXIS_X:int
VTK_PERIODIC_ARRAY_AXIS_Y:int
VTK_PERIODIC_ARRAY_AXIS_Z:int
VTK_PIECES_EXTENT:int
VTK_PIXEL:int
VTK_POLYGON:int
VTK_POLYHEDRON:int
VTK_POLY_LINE:int
VTK_POLY_VERTEX:int
VTK_PYRAMID:int
VTK_QUAD:int
VTK_QUADRATIC_EDGE:int
VTK_QUADRATIC_HEXAHEDRON:int
VTK_QUADRATIC_LINEAR_QUAD:int
VTK_QUADRATIC_LINEAR_WEDGE:int
VTK_QUADRATIC_POLYGON:int
VTK_QUADRATIC_PYRAMID:int
VTK_QUADRATIC_QUAD:int
VTK_QUADRATIC_TETRA:int
VTK_QUADRATIC_TRIANGLE:int
VTK_QUADRATIC_WEDGE:int
VTK_SINGLE_POINT:int
VTK_TETRA:int
VTK_TIME_EXTENT:int
VTK_TOL:float
VTK_TRIANGLE:int
VTK_TRIANGLE_STRIP:int
VTK_TRIQUADRATIC_HEXAHEDRON:int
VTK_TRIQUADRATIC_PYRAMID:int
VTK_UNCHANGED:int
VTK_VERTEX:int
VTK_VOXEL:int
VTK_WEDGE:int
VTK_XYZ_GRID:int
VTK_XY_PLANE:int
VTK_XZ_PLANE:int
VTK_X_LINE:int
VTK_YZ_PLANE:int
VTK_Y_LINE:int
VTK_Z_LINE:int
vtkBoundaryCentered:int
vtkCellCentered:int
vtkColor3:Template
vtkColor4:Template
vtkPointCentered:int
vtkRect:Template
vtkVector:Template
vtkVector2:Template
vtkVector3:Template
vtkVector4:Template

class vtkAMRBox(object):
    bytesize:'getset_descriptor'
    dimensions:'getset_descriptor'
    hi_corner:'getset_descriptor'
    lo_corner:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_nodes:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other:'vtkAMRBox') -> None: ...
    @overload
    def __init__(self, ilo:int, jlo:int, klo:int, ihi:int, jhi:int, khi:int) -> None: ...
    @overload
    def __init__(self, origin:Sequence[float], dimensions:Sequence[int], spacing:Sequence[float], globalOrigin:Sequence[float], gridDescription:int=...) -> None: ...
    @overload
    def __init__(self, lo:Sequence[int], hi:Sequence[int]) -> None: ...
    @overload
    def __init__(self, dims:Sequence[int]) -> None: ...
    def Coarsen(self, r:int) -> None: ...
    def ComputeDimension(self) -> int: ...
    @staticmethod
    def ComputeStructuredCoordinates(box:'vtkAMRBox', dataOrigin:Sequence[float], h:Sequence[float], x:Sequence[float], ijk:MutableSequence[int], pcoords:MutableSequence[float]) -> int: ...
    @overload
    def Contains(self, i:int, j:int, k:int) -> bool: ...
    @overload
    def Contains(self, I:Sequence[int]) -> bool: ...
    @overload
    def Contains(self, __a:'vtkAMRBox') -> bool: ...
    def Deserialize(self, buffer:MutableSequence[int], bytesize:int) -> None: ...
    def DoesBoxIntersectAlongDimension(self, other:'vtkAMRBox', q:int) -> bool: ...
    def DoesIntersect(self, other:'vtkAMRBox') -> bool: ...
    def Empty(self) -> bool: ...
    def EmptyDimension(self, i:int) -> bool: ...
    @staticmethod
    def GetBounds(box:'vtkAMRBox', origin:Sequence[float], spacing:Sequence[float], bounds:MutableSequence[float]) -> None: ...
    @staticmethod
    def GetBoxOrigin(box:'vtkAMRBox', X0:Sequence[float], spacing:Sequence[float], x0:MutableSequence[float]) -> None: ...
    @staticmethod
    def GetBytesize() -> int: ...
    @staticmethod
    def GetCellLinearIndex(box:'vtkAMRBox', i:int, j:int, k:int, imageDimension:MutableSequence[int]) -> int: ...
    @overload
    def GetDimensions(self, lo:MutableSequence[int], hi:MutableSequence[int]) -> None: ...
    @overload
    def GetDimensions(self, dims:MutableSequence[int]) -> None: ...
    def GetGhostVector(self, r:int, nghost:MutableSequence[int]) -> None: ...
    def GetHiCorner(self) -> Pointer: ...
    def GetLoCorner(self) -> Pointer: ...
    @overload
    def GetNumberOfCells(self) -> int: ...
    @overload
    def GetNumberOfCells(self, num:MutableSequence[int]) -> None: ...
    @overload
    def GetNumberOfNodes(self, ext:MutableSequence[int]) -> None: ...
    @overload
    def GetNumberOfNodes(self) -> int: ...
    def GetValidHiCorner(self, hi:MutableSequence[int]) -> None: ...
    def Grow(self, byN:int) -> None: ...
    @staticmethod
    def HasPoint(box:'vtkAMRBox', origin:Sequence[float], spacing:Sequence[float], x:float, y:float, z:float) -> bool: ...
    def Intersect(self, other:'vtkAMRBox') -> bool: ...
    def Invalidate(self) -> None: ...
    def IsInvalid(self) -> bool: ...
    def Refine(self, r:int) -> None: ...
    def RemoveGhosts(self, r:int) -> None: ...
    @overload
    def Serialize(self, buffer:MutableSequence[int], bytesize:int) -> None: ...
    @overload
    def Serialize(self, buffer:MutableSequence[int]) -> None: ...
    @overload
    def SetDimensions(self, ilo:int, jlo:int, klo:int, ihi:int, jhi:int, khi:int, desc:int=...) -> None: ...
    @overload
    def SetDimensions(self, lo:Sequence[int], hi:Sequence[int], desc:int=...) -> None: ...
    @overload
    def SetDimensions(self, dims:Sequence[int], desc:int=...) -> None: ...
    @overload
    def Shift(self, i:int, j:int, k:int) -> None: ...
    @overload
    def Shift(self, I:Sequence[int]) -> None: ...
    def Shrink(self, byN:int) -> None: ...

class vtkAMRDataInternals(vtkmodules.vtkCommonCore.vtkObject):
    number_of_blocks:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CompositeShallowCopy(self, src:'vtkObject') -> None: ...
    def DeepCopy(self, src:'vtkObject') -> None: ...
    def Empty(self) -> bool: ...
    def GetDataSet(self, compositeIndex:int) -> 'vtkUniformGrid': ...
    def GetNumberOfBlocks(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def Insert(self, index:int, grid:'vtkUniformGrid') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRDataInternals': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRDataInternals': ...
    def ShallowCopy(self, src:'vtkObject') -> None: ...

class vtkAMRInformation(vtkmodules.vtkCommonCore.vtkObject):
    amr_block_source_index:'getset_descriptor'
    bounds:'getset_descriptor'
    grid_description:'getset_descriptor'
    num_blocks:'getset_descriptor'
    number_of_levels:'getset_descriptor'
    origin:'getset_descriptor'
    total_number_of_blocks:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Audit(self) -> bool: ...
    def ComputeIndexPair(self, index:int, level:int, id:int) -> None: ...
    def DeepCopy(self, other:'vtkAMRInformation') -> None: ...
    def FindCell(self, q:MutableSequence[float], level:int, index:int, cellIdx:int) -> bool: ...
    def FindGrid(self, q:MutableSequence[float], level:int, gridId:int) -> bool: ...
    def GenerateParentChildInformation(self) -> None: ...
    def GenerateRefinementRatio(self) -> None: ...
    def GetAMRBlockSourceIndex(self, index:int) -> int: ...
    def GetAMRBox(self, level:int, id:int) -> 'vtkAMRBox': ...
    @overload
    def GetBounds(self) -> Pointer: ...
    @overload
    def GetBounds(self, level:int, id:int, bb:MutableSequence[float]) -> None: ...
    def GetChildren(self, level:int, index:int, numChildren:int) -> Pointer: ...
    def GetCoarsenedAMRBox(self, level:int, id:int, box:'vtkAMRBox') -> bool: ...
    def GetGridDescription(self) -> int: ...
    def GetIndex(self, level:int, id:int) -> int: ...
    def GetNumBlocks(self) -> Tuple[int, int]: ...
    def GetNumberOfDataSets(self, level:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    @overload
    def GetOrigin(self, origin:MutableSequence[float]) -> None: ...
    @overload
    def GetOrigin(self) -> Pointer: ...
    @overload
    def GetOrigin(self, level:int, id:int, origin:MutableSequence[float]) -> bool: ...
    def GetParents(self, level:int, index:int, numParents:int) -> Pointer: ...
    def GetRefinementRatio(self, level:int) -> int: ...
    def GetSpacing(self, level:int, spacing:MutableSequence[float]) -> None: ...
    def GetTotalNumberOfBlocks(self) -> int: ...
    def HasChildrenInformation(self) -> bool: ...
    def HasRefinementRatio(self) -> bool: ...
    def HasSpacing(self, level:int) -> bool: ...
    def Initialize(self, numLevels:int, blocksPerLevel:Sequence[int]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRInformation': ...
    def PrintParentChildInfo(self, level:int, index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRInformation': ...
    def SetAMRBlockSourceIndex(self, index:int, sourceId:int) -> None: ...
    def SetAMRBox(self, level:int, id:int, box:'vtkAMRBox') -> None: ...
    def SetGridDescription(self, description:int) -> None: ...
    def SetOrigin(self, origin:Sequence[float]) -> None: ...
    def SetRefinementRatio(self, level:int, ratio:int) -> None: ...
    def SetSpacing(self, level:int, h:Sequence[float]) -> None: ...

class vtkAMRUtilities(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def BlankCells(amr:'vtkOverlappingAMR') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def HasPartiallyOverlappingGhostCells(amr:'vtkOverlappingAMR') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRUtilities': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRUtilities': ...
    @staticmethod
    def StripGhostLayers(ghostedAMRData:'vtkOverlappingAMR', strippedAMRData:'vtkOverlappingAMR') -> None: ...

class vtkAbstractCellArray(vtkmodules.vtkCommonCore.vtkObject):
    max_cell_size:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_connectivity_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DeepCopy(self, ca:'vtkAbstractCellArray') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, cellSize:int, cellPoints:Sequence[int]) -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, cellSize:int, cellPoints:Sequence[int], ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, pts:'vtkIdList') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, cellSize:int, cellPoints:MutableSequence[int]) -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfConnectivityIds(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfOffsets(self) -> int: ...
    def GetOffset(self, cellId:int) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsHomogeneous(self) -> int: ...
    def IsStorageShareable(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractCellArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractCellArray': ...
    def ShallowCopy(self, ca:'vtkAbstractCellArray') -> None: ...

class vtkAbstractCellLinks(vtkmodules.vtkCommonCore.vtkObject):
    class CellLinksTypes(int): ...
    CELL_LINKS:'CellLinksTypes'
    LINKS_NOT_DEFINED:'CellLinksTypes'
    STATIC_CELL_LINKS_IDTYPE:'CellLinksTypes'
    STATIC_CELL_LINKS_SPECIALIZED:'CellLinksTypes'
    STATIC_CELL_LINKS_UINT:'CellLinksTypes'
    STATIC_CELL_LINKS_USHORT:'CellLinksTypes'
    actual_memory_size:'getset_descriptor'
    build_time:'getset_descriptor'
    data_set:'getset_descriptor'
    sequential_processing:'getset_descriptor'
    type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def BuildLinks(self, data:'vtkDataSet') -> None: ...
    @overload
    def BuildLinks(self) -> None: ...
    @overload
    @staticmethod
    def ComputeType(maxPtId:int, maxCellId:int, ca:'vtkCellArray') -> int: ...
    @overload
    @staticmethod
    def ComputeType(maxPtId:int, maxCellId:int, connectivitySize:int) -> int: ...
    def DeepCopy(self, src:'vtkAbstractCellLinks') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetBuildTime(self) -> int: ...
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSequentialProcessing(self) -> bool: ...
    def GetType(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractCellLinks': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractCellLinks': ...
    def SelectCells(self, minMaxDegree:MutableSequence[int], cellSelection:MutableSequence[int]) -> None: ...
    def SequentialProcessingOff(self) -> None: ...
    def SequentialProcessingOn(self) -> None: ...
    def SetDataSet(self, __a:'vtkDataSet') -> None: ...
    def SetSequentialProcessing(self, _arg:bool) -> None: ...
    def ShallowCopy(self, src:'vtkAbstractCellLinks') -> None: ...
    def Squeeze(self) -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkLocator(vtkmodules.vtkCommonCore.vtkObject):
    automatic:'getset_descriptor'
    build_time:'getset_descriptor'
    data_set:'getset_descriptor'
    level:'getset_descriptor'
    max_level:'getset_descriptor'
    tolerance:'getset_descriptor'
    use_existing_search_structure:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutomaticOff(self) -> None: ...
    def AutomaticOn(self) -> None: ...
    def BuildLocator(self) -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    def GetAutomatic(self) -> int: ...
    def GetBuildTime(self) -> int: ...
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetLevel(self) -> int: ...
    def GetMaxLevel(self) -> int: ...
    def GetMaxLevelMaxValue(self) -> int: ...
    def GetMaxLevelMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def GetUseExistingSearchStructure(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLocator': ...
    def SetAutomatic(self, _arg:int) -> None: ...
    def SetDataSet(self, __a:'vtkDataSet') -> None: ...
    def SetMaxLevel(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetUseExistingSearchStructure(self, _arg:int) -> None: ...
    def Update(self) -> None: ...
    def UseExistingSearchStructureOff(self) -> None: ...
    def UseExistingSearchStructureOn(self) -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkAbstractCellLocator(vtkLocator):
    cache_cell_bounds:'getset_descriptor'
    number_of_cells_per_node:'getset_descriptor'
    retain_cell_lists:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CacheCellBoundsOff(self) -> None: ...
    def CacheCellBoundsOn(self) -> None: ...
    def ComputeCellBounds(self) -> None: ...
    @overload
    def FindCell(self, x:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindCellsAlongLine(self, p1:Sequence[float], p2:Sequence[float], tolerance:float, cells:'vtkIdList') -> None: ...
    def FindCellsAlongPlane(self, o:Sequence[float], n:Sequence[float], tolerance:float, cells:'vtkIdList') -> None: ...
    def FindCellsWithinBounds(self, bbox:MutableSequence[float], cells:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float], closestPoint:MutableSequence[float], cellId:int, subId:int, dist2:float) -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float], closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float) -> None: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cellId:int, subId:int, dist2:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float, inside:int) -> int: ...
    def GetCacheCellBounds(self) -> int: ...
    def GetNumberOfCellsPerNode(self) -> int: ...
    def GetNumberOfCellsPerNodeMaxValue(self) -> int: ...
    def GetNumberOfCellsPerNodeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRetainCellLists(self) -> int: ...
    def InsideCellBounds(self, x:MutableSequence[float], cell_ID:int) -> bool: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList', cell:'vtkGenericCell') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractCellLocator': ...
    def RetainCellListsOff(self) -> None: ...
    def RetainCellListsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractCellLocator': ...
    def SetCacheCellBounds(self, _arg:int) -> None: ...
    def SetNumberOfCellsPerNode(self, _arg:int) -> None: ...
    def SetRetainCellLists(self, _arg:int) -> None: ...
    def ShallowCopy(self, __a:'vtkAbstractCellLocator') -> None: ...

class vtkDataObject(vtkmodules.vtkCommonCore.vtkObject):
    class AttributeTypes(int): ...
    class FieldAssociations(int): ...
    class FieldOperations(int): ...
    CELL:'AttributeTypes'
    EDGE:'AttributeTypes'
    FIELD:'AttributeTypes'
    FIELD_ASSOCIATION_CELLS:'FieldAssociations'
    FIELD_ASSOCIATION_EDGES:'FieldAssociations'
    FIELD_ASSOCIATION_NONE:'FieldAssociations'
    FIELD_ASSOCIATION_POINTS:'FieldAssociations'
    FIELD_ASSOCIATION_POINTS_THEN_CELLS:'FieldAssociations'
    FIELD_ASSOCIATION_ROWS:'FieldAssociations'
    FIELD_ASSOCIATION_VERTICES:'FieldAssociations'
    FIELD_OPERATION_MODIFIED:'FieldOperations'
    FIELD_OPERATION_PRESERVED:'FieldOperations'
    FIELD_OPERATION_REINTERPOLATED:'FieldOperations'
    FIELD_OPERATION_REMOVED:'FieldOperations'
    NUMBER_OF_ASSOCIATIONS:'FieldAssociations'
    NUMBER_OF_ATTRIBUTE_TYPES:'AttributeTypes'
    POINT:'AttributeTypes'
    POINT_THEN_CELL:'AttributeTypes'
    ROW:'AttributeTypes'
    VERTEX:'AttributeTypes'
    actual_memory_size:'getset_descriptor'
    data_object_type:'getset_descriptor'
    data_released:'getset_descriptor'
    extent_type:'getset_descriptor'
    field_data:'getset_descriptor'
    global_release_data_flag:'getset_descriptor'
    information:'getset_descriptor'
    m_time:'getset_descriptor'
    update_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ALL_PIECES_EXTENT() -> 'vtkInformationIntegerVectorKey': ...
    @staticmethod
    def BOUNDING_BOX() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def CELL_DATA_VECTOR() -> 'vtkInformationInformationVectorKey': ...
    def CopyInformationFromPipeline(self, info:'vtkInformation') -> None: ...
    def CopyInformationToPipeline(self, info:'vtkInformation') -> None: ...
    def Crop(self, updateExtent:Sequence[int]) -> None: ...
    @staticmethod
    def DATA_EXTENT() -> 'vtkInformationIntegerPointerKey': ...
    @staticmethod
    def DATA_EXTENT_TYPE() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def DATA_NUMBER_OF_GHOST_LEVELS() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def DATA_NUMBER_OF_PIECES() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def DATA_OBJECT() -> 'vtkInformationDataObjectKey': ...
    @staticmethod
    def DATA_PIECE_NUMBER() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def DATA_TIME_STEP() -> 'vtkInformationDoubleKey': ...
    @staticmethod
    def DATA_TYPE_NAME() -> 'vtkInformationStringKey': ...
    @staticmethod
    def DIRECTION() -> 'vtkInformationDoubleVectorKey': ...
    def DataHasBeenGenerated(self) -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @staticmethod
    def EDGE_DATA_VECTOR() -> 'vtkInformationInformationVectorKey': ...
    @staticmethod
    def FIELD_ACTIVE_ATTRIBUTE() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def FIELD_ARRAY_TYPE() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def FIELD_ASSOCIATION() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def FIELD_ATTRIBUTE_TYPE() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def FIELD_NAME() -> 'vtkInformationStringKey': ...
    @staticmethod
    def FIELD_NUMBER_OF_COMPONENTS() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def FIELD_NUMBER_OF_TUPLES() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def FIELD_OPERATION() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def FIELD_RANGE() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def GetActiveFieldInformation(info:'vtkInformation', fieldAssociation:int, attributeType:int) -> 'vtkInformation': ...
    def GetActualMemorySize(self) -> int: ...
    @staticmethod
    def GetAssociationTypeAsString(associationType:int) -> str: ...
    @staticmethod
    def GetAssociationTypeFromString(associationName:str) -> int: ...
    def GetAttributeTypeForArray(self, arr:'vtkAbstractArray') -> int: ...
    def GetAttributes(self, type:int) -> 'vtkDataSetAttributes': ...
    def GetAttributesAsFieldData(self, type:int) -> 'vtkFieldData': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkDataObject': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkDataObject': ...
    def GetDataObjectType(self) -> int: ...
    def GetDataReleased(self) -> int: ...
    def GetExtentType(self) -> int: ...
    def GetFieldData(self) -> 'vtkFieldData': ...
    def GetGhostArray(self, type:int) -> 'vtkUnsignedCharArray': ...
    @staticmethod
    def GetGlobalReleaseDataFlag() -> int: ...
    def GetInformation(self) -> 'vtkInformation': ...
    def GetMTime(self) -> int: ...
    @staticmethod
    def GetNamedFieldInformation(info:'vtkInformation', fieldAssociation:int, name:str) -> 'vtkInformation': ...
    def GetNumberOfElements(self, type:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUpdateTime(self) -> int: ...
    def GlobalReleaseDataFlagOff(self) -> None: ...
    def GlobalReleaseDataFlagOn(self) -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObject': ...
    @staticmethod
    def ORIGIN() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def PIECE_EXTENT() -> 'vtkInformationIntegerVectorKey': ...
    @staticmethod
    def POINT_DATA_VECTOR() -> 'vtkInformationInformationVectorKey': ...
    def PrepareForNewData(self) -> None: ...
    def ReleaseData(self) -> None: ...
    @staticmethod
    def RemoveNamedFieldInformation(info:'vtkInformation', fieldAssociation:int, name:str) -> None: ...
    @staticmethod
    def SIL() -> 'vtkInformationDataObjectKey': ...
    @staticmethod
    def SPACING() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObject': ...
    @staticmethod
    def SetActiveAttribute(info:'vtkInformation', fieldAssociation:int, attributeName:str, attributeType:int) -> 'vtkInformation': ...
    @staticmethod
    def SetActiveAttributeInfo(info:'vtkInformation', fieldAssociation:int, attributeType:int, name:str, arrayType:int, numComponents:int, numTuples:int) -> None: ...
    def SetFieldData(self, __a:'vtkFieldData') -> None: ...
    @staticmethod
    def SetGlobalReleaseDataFlag(val:int) -> None: ...
    def SetInformation(self, __a:'vtkInformation') -> None: ...
    @staticmethod
    def SetPointDataActiveScalarInfo(info:'vtkInformation', arrayType:int, numComponents:int) -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    def SupportsGhostArray(self, type:int) -> bool: ...
    @staticmethod
    def VERTEX_DATA_VECTOR() -> 'vtkInformationInformationVectorKey': ...

class vtkAbstractElectronicData(vtkDataObject):
    data_object_type:'getset_descriptor'
    electron_density:'getset_descriptor'
    homo:'getset_descriptor'
    homo_orbital_number:'getset_descriptor'
    lumo:'getset_descriptor'
    lumo_orbital_number:'getset_descriptor'
    number_of_electrons:'getset_descriptor'
    number_of_m_os:'getset_descriptor'
    padding:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DeepCopy(self, obj:'vtkDataObject') -> None: ...
    def GetDataObjectType(self) -> int: ...
    def GetElectronDensity(self) -> 'vtkImageData': ...
    def GetHOMO(self) -> 'vtkImageData': ...
    def GetHOMOOrbitalNumber(self) -> int: ...
    def GetLUMO(self) -> 'vtkImageData': ...
    def GetLUMOOrbitalNumber(self) -> int: ...
    def GetMO(self, orbitalNumber:int) -> 'vtkImageData': ...
    def GetNumberOfElectrons(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfMOs(self) -> int: ...
    def GetPadding(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    def IsHOMO(self, orbitalNumber:int) -> bool: ...
    def IsLUMO(self, orbitalNumber:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractElectronicData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractElectronicData': ...

class vtkAbstractPointLocator(vtkLocator):
    bounds:'getset_descriptor'
    number_of_buckets:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def FindClosestNPoints(self, N:int, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindClosestNPoints(self, N:int, x:float, y:float, z:float, result:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def FindClosestPoint(self, x:float, y:float, z:float) -> int: ...
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], dist2:float) -> int: ...
    @overload
    def FindPointsWithinRadius(self, R:float, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindPointsWithinRadius(self, R:float, x:float, y:float, z:float, result:'vtkIdList') -> None: ...
    @overload
    def GetBounds(self) -> Pointer: ...
    @overload
    def GetBounds(self, __a:MutableSequence[float]) -> None: ...
    def GetNumberOfBuckets(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractPointLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractPointLocator': ...

class vtkAdjacentVertexIterator(vtkmodules.vtkCommonCore.vtkObject):
    graph:'getset_descriptor'
    vertex:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetGraph(self) -> 'vtkGraph': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVertex(self) -> int: ...
    def HasNext(self) -> bool: ...
    def Initialize(self, g:'vtkGraph', v:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAdjacentVertexIterator': ...
    def Next(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAdjacentVertexIterator': ...

class vtkAnimationScene(vtkmodules.vtkCommonCore.vtkAnimationCue):
    class PlayModes(int): ...
    PLAYMODE_REALTIME:'PlayModes'
    PLAYMODE_SEQUENCE:'PlayModes'
    animation_time:'getset_descriptor'
    frame_rate:'getset_descriptor'
    loop:'getset_descriptor'
    number_of_cues:'getset_descriptor'
    play_mode:'getset_descriptor'
    time_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddCue(self, cue:'vtkAnimationCue') -> None: ...
    def GetFrameRate(self) -> float: ...
    def GetLoop(self) -> int: ...
    def GetNumberOfCues(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlayMode(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInPlay(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAnimationScene': ...
    def Play(self) -> None: ...
    def RemoveAllCues(self) -> None: ...
    def RemoveCue(self, cue:'vtkAnimationCue') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnimationScene': ...
    def SetAnimationTime(self, time:float) -> None: ...
    def SetFrameRate(self, _arg:float) -> None: ...
    def SetLoop(self, _arg:int) -> None: ...
    def SetModeToRealTime(self) -> None: ...
    def SetModeToSequence(self) -> None: ...
    def SetPlayMode(self, _arg:int) -> None: ...
    def SetTimeMode(self, mode:int) -> None: ...
    def Stop(self) -> None: ...

class vtkAnnotation(vtkDataObject):
    data_object_type:'getset_descriptor'
    m_time:'getset_descriptor'
    selection:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def COLOR() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def DATA() -> 'vtkInformationDataObjectKey': ...
    def DeepCopy(self, other:'vtkDataObject') -> None: ...
    @staticmethod
    def ENABLE() -> 'vtkInformationIntegerKey': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkAnnotation': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkAnnotation': ...
    def GetDataObjectType(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelection(self) -> 'vtkSelection': ...
    @staticmethod
    def HIDE() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def ICON_INDEX() -> 'vtkInformationIntegerKey': ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def LABEL() -> 'vtkInformationStringKey': ...
    def NewInstance(self) -> 'vtkAnnotation': ...
    @staticmethod
    def OPACITY() -> 'vtkInformationDoubleKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnnotation': ...
    def SetSelection(self, selection:'vtkSelection') -> None: ...
    def ShallowCopy(self, other:'vtkDataObject') -> None: ...

class vtkAnnotationLayers(vtkDataObject):
    current_annotation:'getset_descriptor'
    current_selection:'getset_descriptor'
    data_object_type:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_annotations:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddAnnotation(self, ann:'vtkAnnotation') -> None: ...
    def DeepCopy(self, other:'vtkDataObject') -> None: ...
    def GetAnnotation(self, idx:int) -> 'vtkAnnotation': ...
    def GetCurrentAnnotation(self) -> 'vtkAnnotation': ...
    def GetCurrentSelection(self) -> 'vtkSelection': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkAnnotationLayers': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkAnnotationLayers': ...
    def GetDataObjectType(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfAnnotations(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAnnotationLayers': ...
    def RemoveAnnotation(self, ann:'vtkAnnotation') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnnotationLayers': ...
    def SetCurrentAnnotation(self, ann:'vtkAnnotation') -> None: ...
    def SetCurrentSelection(self, sel:'vtkSelection') -> None: ...
    def ShallowCopy(self, other:'vtkDataObject') -> None: ...

class vtkImplicitFunction(vtkmodules.vtkCommonCore.vtkObject):
    m_time:'getset_descriptor'
    transform:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    @overload
    def FunctionGradient(self, x:Sequence[float], g:MutableSequence[float]) -> None: ...
    @overload
    def FunctionGradient(self, x:Sequence[float]) -> Tuple[float, float, float]: ...
    @overload
    def FunctionGradient(self, x:float, y:float, z:float) -> Tuple[float, float, float]: ...
    @overload
    def FunctionValue(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def FunctionValue(self, x:Sequence[float]) -> float: ...
    @overload
    def FunctionValue(self, x:float, y:float, z:float) -> float: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitFunction': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitFunction': ...
    @overload
    def SetTransform(self, __a:'vtkAbstractTransform') -> None: ...
    @overload
    def SetTransform(self, elements:Sequence[float]) -> None: ...

class vtkAnnulus(vtkImplicitFunction):
    axis:'getset_descriptor'
    center:'getset_descriptor'
    inner_radius:'getset_descriptor'
    outer_radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    @overload
    def GetAxis(self, x:float, y:float, z:float) -> None: ...
    @overload
    def GetAxis(self, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetAxis(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, x:float, y:float, z:float) -> None: ...
    @overload
    def GetCenter(self, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetInnerRadius(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOuterRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAnnulus': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnnulus': ...
    @overload
    def SetAxis(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetAxis(self, axis:MutableSequence[float]) -> None: ...
    @overload
    def SetAxis(self, axis:'vtkVector3d') -> None: ...
    @overload
    def SetCenter(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetCenter(self, xyz:Sequence[float]) -> None: ...
    @overload
    def SetCenter(self, xyz:'vtkVector3d') -> None: ...
    def SetInnerRadius(self, radius:float) -> None: ...
    def SetOuterRadius(self, radius:float) -> None: ...

class vtkArrayData(vtkDataObject):
    data_object_type:'getset_descriptor'
    number_of_arrays:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddArray(self, __a:'vtkArray') -> None: ...
    def ClearArrays(self) -> None: ...
    def DeepCopy(self, other:'vtkDataObject') -> None: ...
    def GetArray(self, index:int) -> 'vtkArray': ...
    def GetArrayByName(self, name:str) -> 'vtkArray': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkArrayData': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkArrayData': ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayData': ...
    def ShallowCopy(self, other:'vtkDataObject') -> None: ...

class vtkAtom(object):
    atomic_number:'getset_descriptor'
    id:'getset_descriptor'
    molecule:'getset_descriptor'
    position:'getset_descriptor'
    def __init__(self, __a:'vtkAtom') -> None: ...
    def GetAtomicNumber(self) -> int: ...
    def GetId(self) -> int: ...
    def GetMolecule(self) -> 'vtkMolecule': ...
    @overload
    def GetPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPosition(self) -> 'vtkVector3f': ...
    def SetAtomicNumber(self, atomicNum:int) -> None: ...
    @overload
    def SetPosition(self, pos:Sequence[float]) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPosition(self, pos:'vtkVector3f') -> None: ...

class vtkGenericSubdivisionErrorMetric(vtkmodules.vtkCommonCore.vtkObject):
    data_set:'getset_descriptor'
    generic_cell:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDataSet(self) -> 'vtkGenericDataSet': ...
    def GetError(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> float: ...
    def GetGenericCell(self) -> 'vtkGenericAdaptorCell': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericSubdivisionErrorMetric': ...
    def RequiresEdgeSubdivision(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericSubdivisionErrorMetric': ...
    def SetDataSet(self, ds:'vtkGenericDataSet') -> None: ...
    def SetGenericCell(self, cell:'vtkGenericAdaptorCell') -> None: ...

class vtkAttributesErrorMetric(vtkGenericSubdivisionErrorMetric):
    absolute_attribute_tolerance:'getset_descriptor'
    attribute_tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAbsoluteAttributeTolerance(self) -> float: ...
    def GetAttributeTolerance(self) -> float: ...
    def GetError(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAttributesErrorMetric': ...
    def RequiresEdgeSubdivision(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAttributesErrorMetric': ...
    def SetAbsoluteAttributeTolerance(self, value:float) -> None: ...
    def SetAttributeTolerance(self, value:float) -> None: ...

class vtkBSPCuts(vtkDataObject):
    data_object_type:'getset_descriptor'
    kd_node_tree:'getset_descriptor'
    number_of_cuts:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def CreateCuts(self, bounds:MutableSequence[float], ncuts:int, dim:MutableSequence[int], coord:MutableSequence[float], lower:MutableSequence[int], upper:MutableSequence[int], lowerDataCoord:MutableSequence[float], upperDataCoord:MutableSequence[float], npoints:MutableSequence[int]) -> None: ...
    @overload
    def CreateCuts(self, kd:'vtkKdNode') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    def Equals(self, other:'vtkBSPCuts', tolerance:float=0.0) -> int: ...
    def GetArrays(self, len:int, dim:MutableSequence[int], coord:MutableSequence[float], lower:MutableSequence[int], upper:MutableSequence[int], lowerDataCoord:MutableSequence[float], upperDataCoord:MutableSequence[float], npoints:MutableSequence[int]) -> int: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkBSPCuts': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkBSPCuts': ...
    def GetDataObjectType(self) -> int: ...
    def GetKdNodeTree(self) -> 'vtkKdNode': ...
    def GetNumberOfCuts(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBSPCuts': ...
    def PrintArrays(self) -> None: ...
    def PrintTree(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBSPCuts': ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...

class vtkBSPIntersections(vtkmodules.vtkCommonCore.vtkObject):
    compute_intersections_using_data_bounds:'getset_descriptor'
    cuts:'getset_descriptor'
    number_of_regions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeIntersectionsUsingDataBoundsOff(self) -> None: ...
    def ComputeIntersectionsUsingDataBoundsOn(self) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> int: ...
    def GetComputeIntersectionsUsingDataBounds(self) -> int: ...
    def GetCuts(self) -> 'vtkBSPCuts': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRegions(self) -> int: ...
    def GetRegionBounds(self, regionID:int, bounds:MutableSequence[float]) -> int: ...
    def GetRegionDataBounds(self, regionID:int, bounds:MutableSequence[float]) -> int: ...
    @overload
    def IntersectsBox(self, regionId:int, x:MutableSequence[float]) -> int: ...
    @overload
    def IntersectsBox(self, regionId:int, x0:float, x1:float, y0:float, y1:float, z0:float, z1:float) -> int: ...
    @overload
    def IntersectsBox(self, ids:MutableSequence[int], len:int, x:MutableSequence[float]) -> int: ...
    @overload
    def IntersectsBox(self, ids:MutableSequence[int], len:int, x0:float, x1:float, y0:float, y1:float, z0:float, z1:float) -> int: ...
    @overload
    def IntersectsCell(self, regionId:int, cell:'vtkCell', cellRegion:int=-1) -> int: ...
    @overload
    def IntersectsCell(self, ids:MutableSequence[int], len:int, cell:'vtkCell', cellRegion:int=-1) -> int: ...
    @overload
    def IntersectsSphere2(self, regionId:int, x:float, y:float, z:float, rSquared:float) -> int: ...
    @overload
    def IntersectsSphere2(self, ids:MutableSequence[int], len:int, x:float, y:float, z:float, rSquared:float) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBSPIntersections': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBSPIntersections': ...
    def SetComputeIntersectionsUsingDataBounds(self, c:int) -> None: ...
    def SetCuts(self, cuts:'vtkBSPCuts') -> None: ...

class vtkCell(vtkmodules.vtkCommonCore.vtkObject):
    bounds:'getset_descriptor'
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    faces:'getset_descriptor'
    length2:'getset_descriptor'
    number_of_points:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    point_ids:'getset_descriptor'
    points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', connectivity:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def ComputeBoundingSphere(self, center:MutableSequence[float]) -> float: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def DeepCopy(self, c:'vtkCell') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFaces(self) -> Pointer: ...
    def GetLength2(self) -> float: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def GetPointId(self, ptId:int) -> int: ...
    def GetPointIds(self) -> 'vtkIdList': ...
    def GetPoints(self) -> 'vtkPoints': ...
    def Inflate(self, dist:float) -> int: ...
    @overload
    def Initialize(self, npts:int, pts:Sequence[int], p:'vtkPoints') -> None: ...
    @overload
    def Initialize(self, npts:int, p:'vtkPoints') -> None: ...
    @overload
    def Initialize(self) -> None: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weight:MutableSequence[float]) -> None: ...
    @overload
    def IntersectWithCell(self, other:'vtkCell', tol:float=0.0) -> int: ...
    @overload
    def IntersectWithCell(self, other:'vtkCell', boudingBox:'vtkBoundingBox', otherBoundingBox:'vtkBoundingBox', tol:float=0.0) -> int: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsExplicitCell(self) -> int: ...
    def IsLinear(self) -> int: ...
    def IsPrimaryCell(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCell': ...
    def RequiresExplicitFaceRepresentation(self) -> int: ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCell': ...
    def SetFaces(self, faces:MutableSequence[int]) -> None: ...
    def ShallowCopy(self, c:'vtkCell') -> None: ...
    def Triangulate(self, index:int, ptIds:'vtkIdList', pts:'vtkPoints') -> int: ...
    def TriangulateIds(self, index:int, ptIds:'vtkIdList') -> int: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkNonLinearCell(vtkCell):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsLinear(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNonLinearCell': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNonLinearCell': ...
    def StableClip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', connectivity:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> bool: ...

class vtkHigherOrderCurve(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    order:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrder(self) -> Pointer: ...
    @overload
    def GetOrder(self, i:int) -> int: ...
    def GetParametricCenter(self, center:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def Initialize(self) -> None: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHigherOrderCurve': ...
    @staticmethod
    def PointCountSupportsUniformOrder(pointsPerCell:int) -> bool: ...
    def PointIndexFromIJK(self, i:int, __b:int, __c:int) -> int: ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHigherOrderCurve': ...
    def SetParametricCoords(self) -> None: ...
    @overload
    def SubCellCoordinatesFromId(self, ijk:'vtkVector3i', subId:int) -> bool: ...
    @overload
    def SubCellCoordinatesFromId(self, i:int, subId:int) -> bool: ...
    def TransformApproxToCellParams(self, subCell:int, pcoords:MutableSequence[float]) -> bool: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkBezierCurve(vtkHigherOrderCurve):
    cell_type:'getset_descriptor'
    rational_weights:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRationalWeights(self) -> 'vtkDoubleArray': ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBezierCurve': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBezierCurve': ...
    def SetRationalWeightsFromPointData(self, point_data:'vtkPointData', numPts:int) -> None: ...

class vtkHigherOrderHexahedron(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    face_cell:'getset_descriptor'
    interpolation:'getset_descriptor'
    order:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    uniform_order_from_num_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFaceCell(self) -> 'vtkHigherOrderQuadrilateral': ...
    def GetInterpolation(self) -> 'vtkHigherOrderInterpolation': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrder(self) -> Pointer: ...
    @overload
    def GetOrder(self, i:int) -> int: ...
    def GetParametricCenter(self, center:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def Initialize(self) -> None: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHigherOrderHexahedron': ...
    @staticmethod
    def NodeNumberingMappingFromVTK8To9(order:Sequence[int], node_id_vtk8:int) -> int: ...
    @staticmethod
    def PointCountSupportsUniformOrder(pointsPerCell:int) -> bool: ...
    @overload
    @staticmethod
    def PointIndexFromIJK(i:int, j:int, k:int, order:Sequence[int]) -> int: ...
    @overload
    def PointIndexFromIJK(self, i:int, j:int, k:int) -> int: ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHigherOrderHexahedron': ...
    def SetOrder(self, s:int, t:int, u:int) -> None: ...
    @overload
    def SetOrderFromCellData(self, cell_data:'vtkCellData', numPts:int, cell_id:int) -> None: ...
    @overload
    @staticmethod
    def SetOrderFromCellData(cell_data:'vtkCellData', numPts:int, cell_id:int, order:MutableSequence[int]) -> None: ...
    def SetParametricCoords(self) -> None: ...
    def SetUniformOrderFromNumPoints(self, numPts:int) -> None: ...
    @overload
    def SubCellCoordinatesFromId(self, ijk:'vtkVector3i', subId:int) -> bool: ...
    @overload
    def SubCellCoordinatesFromId(self, i:int, j:int, k:int, subId:int) -> bool: ...
    def TransformApproxToCellParams(self, subCell:int, pcoords:MutableSequence[float]) -> bool: ...
    def TransformFaceToCellParams(self, bdyFace:int, pcoords:MutableSequence[float]) -> bool: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkBezierHexahedron(vtkHigherOrderHexahedron):
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    face_cell:'getset_descriptor'
    interpolation:'getset_descriptor'
    rational_weights:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFaceCell(self) -> 'vtkHigherOrderQuadrilateral': ...
    def GetInterpolation(self) -> 'vtkHigherOrderInterpolation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRationalWeights(self) -> 'vtkDoubleArray': ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBezierHexahedron': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBezierHexahedron': ...
    def SetRationalWeightsFromPointData(self, point_data:'vtkPointData', numPts:int) -> None: ...

class vtkHigherOrderInterpolation(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def AppendCurveCollocationPoints(pts:'vtkPoints', order:(int)) -> None: ...
    @staticmethod
    def AppendHexahedronCollocationPoints(pts:'vtkPoints', order:Sequence[int]) -> None: ...
    @staticmethod
    def AppendQuadrilateralCollocationPoints(pts:'vtkPoints', order:Sequence[int]) -> None: ...
    @staticmethod
    def AppendWedgeCollocationPoints(pts:'vtkPoints', order:Sequence[int]) -> None: ...
    @staticmethod
    def GetEdgeIndicesBoundingHexFace(faceId:int) -> Tuple[int, int, int, int]: ...
    @staticmethod
    def GetEdgeIndicesBoundingWedgeFace(faceId:int) -> Tuple[int, int, int, int]: ...
    @staticmethod
    def GetFixedParameterOfHexFace(faceId:int) -> int: ...
    @staticmethod
    def GetFixedParameterOfWedgeFace(faceId:int) -> int: ...
    @staticmethod
    def GetFixedParametersOfHexEdge(edgeId:int) -> 'vtkVector2i': ...
    @staticmethod
    def GetFixedParametersOfWedgeEdge(edgeId:int) -> 'vtkVector2i': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetParametricHexCoordinates(vertexId:int) -> 'vtkVector3d': ...
    @staticmethod
    def GetParametricWedgeCoordinates(vertexId:int) -> 'vtkVector3d': ...
    @staticmethod
    def GetPointIndicesBoundingHexEdge(edgeId:int) -> 'vtkVector2i': ...
    @staticmethod
    def GetPointIndicesBoundingHexFace(faceId:int) -> Tuple[int, int, int, int]: ...
    @staticmethod
    def GetPointIndicesBoundingWedgeEdge(edgeId:int) -> 'vtkVector2i': ...
    @staticmethod
    def GetPointIndicesBoundingWedgeFace(faceId:int) -> Tuple[int, int, int, int]: ...
    @staticmethod
    def GetVaryingParameterOfHexEdge(edgeId:int) -> int: ...
    @staticmethod
    def GetVaryingParameterOfWedgeEdge(edgeId:int) -> int: ...
    @staticmethod
    def GetVaryingParametersOfHexFace(faceId:int) -> 'vtkVector2i': ...
    @staticmethod
    def GetVaryingParametersOfWedgeFace(faceId:int) -> 'vtkVector2i': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHigherOrderInterpolation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHigherOrderInterpolation': ...
    def Tensor3EvaluateDerivative(self, order:Sequence[int], pcoords:Sequence[float], points:'vtkPoints', fieldVals:Sequence[float], fieldDim:int, fieldDerivs:MutableSequence[float]) -> None: ...
    def WedgeEvaluate(self, order:Sequence[int], numberOfPoints:int, pcoords:Sequence[float], fieldVals:MutableSequence[float], fieldDim:int, fieldAtPCoords:MutableSequence[float]) -> None: ...
    def WedgeEvaluateDerivative(self, order:Sequence[int], pcoords:Sequence[float], points:'vtkPoints', fieldVals:Sequence[float], fieldDim:int, fieldDerivs:MutableSequence[float]) -> None: ...

class vtkBezierInterpolation(vtkHigherOrderInterpolation):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def DeCasteljauSimplex(dim:int, deg:int, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def DeCasteljauSimplexDeriv(dim:int, deg:int, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def EvaluateShapeAndGradient(order:int, pcoord:float, shape:MutableSequence[float], grad:MutableSequence[float]) -> None: ...
    @staticmethod
    def EvaluateShapeFunctions(order:int, pcoord:float, shape:MutableSequence[float]) -> None: ...
    @staticmethod
    def FlattenSimplex(dim:int, deg:int, coord:'vtkVector3i') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBezierInterpolation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBezierInterpolation': ...
    @staticmethod
    def Tensor1ShapeDerivatives(order:(int), pcoords:Sequence[float], derivs:MutableSequence[float]) -> int: ...
    @staticmethod
    def Tensor1ShapeFunctions(order:(int), pcoords:Sequence[float], shape:MutableSequence[float]) -> int: ...
    @staticmethod
    def Tensor2ShapeDerivatives(order:Sequence[int], pcoords:Sequence[float], derivs:MutableSequence[float]) -> int: ...
    @staticmethod
    def Tensor2ShapeFunctions(order:Sequence[int], pcoords:Sequence[float], shape:MutableSequence[float]) -> int: ...
    def Tensor3EvaluateDerivative(self, order:Sequence[int], pcoords:Sequence[float], points:'vtkPoints', fieldVals:Sequence[float], fieldDim:int, fieldDerivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def Tensor3ShapeDerivatives(order:Sequence[int], pcoords:Sequence[float], derivs:MutableSequence[float]) -> int: ...
    @staticmethod
    def Tensor3ShapeFunctions(order:Sequence[int], pcoords:Sequence[float], shape:MutableSequence[float]) -> int: ...
    @staticmethod
    def UnFlattenSimplex(dim:int, deg:int, flat:int) -> 'vtkVector3i': ...
    def WedgeEvaluate(self, order:Sequence[int], numberOfPoints:int, pcoords:Sequence[float], fieldVals:MutableSequence[float], fieldDim:int, fieldAtPCoords:MutableSequence[float]) -> None: ...
    def WedgeEvaluateDerivative(self, order:Sequence[int], pcoords:Sequence[float], points:'vtkPoints', fieldVals:Sequence[float], fieldDim:int, fieldDerivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def WedgeShapeDerivatives(order:Sequence[int], numberOfPoints:int, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def WedgeShapeFunctions(order:Sequence[int], numberOfPoints:int, pcoords:Sequence[float], shape:MutableSequence[float]) -> None: ...

class vtkHigherOrderQuadrilateral(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    order:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    uniform_order_from_num_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrder(self) -> Pointer: ...
    @overload
    def GetOrder(self, i:int) -> int: ...
    def GetParametricCenter(self, center:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def Initialize(self) -> None: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHigherOrderQuadrilateral': ...
    @staticmethod
    def PointCountSupportsUniformOrder(pointsPerCell:int) -> bool: ...
    @overload
    def PointIndexFromIJK(self, i:int, j:int, k:int) -> int: ...
    @overload
    @staticmethod
    def PointIndexFromIJK(i:int, j:int, order:Sequence[int]) -> int: ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHigherOrderQuadrilateral': ...
    def SetOrder(self, s:int, t:int) -> None: ...
    @overload
    def SetOrderFromCellData(self, cell_data:'vtkCellData', numPts:int, cell_id:int) -> None: ...
    @overload
    @staticmethod
    def SetOrderFromCellData(cell_data:'vtkCellData', numPts:int, cell_id:int, order:MutableSequence[int]) -> None: ...
    def SetParametricCoords(self) -> None: ...
    def SetUniformOrderFromNumPoints(self, numPts:int) -> None: ...
    @overload
    def SubCellCoordinatesFromId(self, ijk:'vtkVector3i', subId:int) -> bool: ...
    @overload
    def SubCellCoordinatesFromId(self, i:int, j:int, k:int, subId:int) -> bool: ...
    def TransformApproxToCellParams(self, subCell:int, pcoords:MutableSequence[float]) -> bool: ...
    def TriangulateLocalIds(self, index:int, ptId:'vtkIdList') -> int: ...

class vtkBezierQuadrilateral(vtkHigherOrderQuadrilateral):
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    rational_weights:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRationalWeights(self) -> 'vtkDoubleArray': ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBezierQuadrilateral': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBezierQuadrilateral': ...
    def SetRationalWeightsFromPointData(self, point_data:'vtkPointData', numPts:int) -> None: ...

class vtkHigherOrderTetra(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    face_cell:'getset_descriptor'
    order:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def BarycentricIndex(index:int, bindex:MutableSequence[int], order:int) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    @overload
    def ComputeOrder(self) -> int: ...
    @overload
    @staticmethod
    def ComputeOrder(nPoints:int) -> int: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFaceCell(self) -> 'vtkHigherOrderTriangle': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrder(self) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    @staticmethod
    def Index(bindex:Sequence[int], order:int) -> int: ...
    def Initialize(self) -> None: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHigherOrderTetra': ...
    @staticmethod
    def PointCountSupportsUniformOrder(pointsPerCell:int) -> bool: ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHigherOrderTetra': ...
    def SetParametricCoords(self) -> None: ...
    def ToBarycentricIndex(self, index:int, bindex:MutableSequence[int]) -> None: ...
    def ToIndex(self, bindex:Sequence[int]) -> int: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkBezierTetra(vtkHigherOrderTetra):
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    face_cell:'getset_descriptor'
    rational_weights:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFaceCell(self) -> 'vtkHigherOrderTriangle': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRationalWeights(self) -> 'vtkDoubleArray': ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBezierTetra': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBezierTetra': ...
    def SetRationalWeightsFromPointData(self, point_data:'vtkPointData', numPts:int) -> None: ...

class vtkHigherOrderTriangle(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    order:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def BarycentricIndex(index:int, bindex:MutableSequence[int], order:int) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def ComputeOrder(self) -> int: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def Deta(n:int, chi:int, sigma:float) -> float: ...
    @staticmethod
    def Eta(n:int, chi:int, sigma:float) -> float: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrder(self) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    @staticmethod
    def Index(bindex:Sequence[int], order:int) -> int: ...
    def Initialize(self) -> None: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHigherOrderTriangle': ...
    @staticmethod
    def PointCountSupportsUniformOrder(pointsPerTri:int) -> bool: ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHigherOrderTriangle': ...
    def SetParametricCoords(self) -> None: ...
    def ToBarycentricIndex(self, index:int, bindex:MutableSequence[int]) -> None: ...
    def ToIndex(self, bindex:Sequence[int]) -> int: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkBezierTriangle(vtkHigherOrderTriangle):
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    rational_weights:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRationalWeights(self) -> 'vtkDoubleArray': ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBezierTriangle': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBezierTriangle': ...
    def SetRationalWeightsFromPointData(self, point_data:'vtkPointData', numPts:int) -> None: ...

class vtkHigherOrderWedge(vtkNonLinearCell):
    boundary_quad:'getset_descriptor'
    boundary_tri:'getset_descriptor'
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    interpolation:'getset_descriptor'
    number_of_approximating_wedges:'getset_descriptor'
    order:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    uniform_order_from_num_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetBoundaryQuad(self) -> 'vtkHigherOrderQuadrilateral': ...
    def GetBoundaryTri(self) -> 'vtkHigherOrderTriangle': ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetInterpolation(self) -> 'vtkHigherOrderInterpolation': ...
    @overload
    @staticmethod
    def GetNumberOfApproximatingWedges(order:Sequence[int]) -> int: ...
    @overload
    def GetNumberOfApproximatingWedges(self) -> int: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrder(self) -> Pointer: ...
    @overload
    def GetOrder(self, i:int) -> int: ...
    def GetParametricCenter(self, center:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def Initialize(self) -> None: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHigherOrderWedge': ...
    @staticmethod
    def PointCountSupportsUniformOrder(pointsPerCell:int) -> bool: ...
    @overload
    @staticmethod
    def PointIndexFromIJK(i:int, j:int, k:int, order:Sequence[int]) -> int: ...
    @overload
    def PointIndexFromIJK(self, i:int, j:int, k:int) -> int: ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHigherOrderWedge': ...
    def SetOrder(self, s:int, t:int, u:int, numPts:int) -> None: ...
    @overload
    def SetOrderFromCellData(self, cell_data:'vtkCellData', numPts:int, cell_id:int) -> None: ...
    @overload
    @staticmethod
    def SetOrderFromCellData(cell_data:'vtkCellData', numPts:int, cell_id:int, order:MutableSequence[int]) -> None: ...
    def SetParametricCoords(self) -> None: ...
    def SetUniformOrderFromNumPoints(self, numPts:int) -> None: ...
    @overload
    def SubCellCoordinatesFromId(self, ijk:'vtkVector3i', subId:int) -> bool: ...
    @overload
    def SubCellCoordinatesFromId(self, i:int, j:int, k:int, subId:int) -> bool: ...
    def TransformApproxToCellParams(self, subCell:int, pcoords:MutableSequence[float]) -> bool: ...
    def TransformFaceToCellParams(self, bdyFace:int, pcoords:MutableSequence[float]) -> bool: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkBezierWedge(vtkHigherOrderWedge):
    boundary_quad:'getset_descriptor'
    boundary_tri:'getset_descriptor'
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    interpolation:'getset_descriptor'
    rational_weights:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBoundaryQuad(self) -> 'vtkHigherOrderQuadrilateral': ...
    def GetBoundaryTri(self) -> 'vtkHigherOrderTriangle': ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetInterpolation(self) -> 'vtkHigherOrderInterpolation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRationalWeights(self) -> 'vtkDoubleArray': ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBezierWedge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBezierWedge': ...
    def SetRationalWeightsFromPointData(self, point_data:'vtkPointData', numPts:int) -> None: ...

class vtkBiQuadraticQuad(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBiQuadraticQuad': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBiQuadraticQuad': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkBiQuadraticQuadraticHexahedron(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tetras:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBiQuadraticQuadraticHexahedron': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBiQuadraticQuadraticHexahedron': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkBiQuadraticQuadraticWedge(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tetras:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBiQuadraticQuadraticWedge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBiQuadraticQuadraticWedge': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkBiQuadraticTriangle(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBiQuadraticTriangle': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBiQuadraticTriangle': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkBond(object):
    begin_atom:'getset_descriptor'
    begin_atom_id:'getset_descriptor'
    end_atom:'getset_descriptor'
    end_atom_id:'getset_descriptor'
    id:'getset_descriptor'
    length:'getset_descriptor'
    molecule:'getset_descriptor'
    order:'getset_descriptor'
    def __init__(self, __a:'vtkBond') -> None: ...
    def GetBeginAtom(self) -> 'vtkAtom': ...
    def GetBeginAtomId(self) -> int: ...
    def GetEndAtom(self) -> 'vtkAtom': ...
    def GetEndAtomId(self) -> int: ...
    def GetId(self) -> int: ...
    def GetLength(self) -> float: ...
    def GetMolecule(self) -> 'vtkMolecule': ...
    def GetOrder(self) -> int: ...

class vtkBoundingBox(object):
    bounds:'getset_descriptor'
    diagonal_length:'getset_descriptor'
    diagonal_length2:'getset_descriptor'
    max_length:'getset_descriptor'
    max_point:'getset_descriptor'
    min_point:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, bounds:Sequence[float]) -> None: ...
    @overload
    def __init__(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def __init__(self, bbox:'vtkBoundingBox') -> None: ...
    def AddBounds(self, bounds:Sequence[float]) -> None: ...
    def AddBox(self, bbox:'vtkBoundingBox') -> None: ...
    @overload
    def AddPoint(self, p:MutableSequence[float]) -> None: ...
    @overload
    def AddPoint(self, px:float, py:float, pz:float) -> None: ...
    @staticmethod
    def ClampDivisions(targetBins:int, divs:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def ComputeBounds(pts:'vtkPoints', bounds:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ComputeBounds(pts:'vtkPoints', ptUses:Sequence[int], bounds:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ComputeBounds(pts:'vtkPoints', ptIds:Sequence[int], numPointIds:int, bounds:MutableSequence[float]) -> None: ...
    @overload
    def ComputeBounds(self, pts:'vtkPoints') -> None: ...
    @overload
    def ComputeBounds(self, pts:'vtkPoints', ptUses:MutableSequence[int]) -> None: ...
    def ComputeDivisions(self, totalBins:int, bounds:MutableSequence[float], divs:MutableSequence[int]) -> int: ...
    def ComputeInnerDimension(self) -> int: ...
    @staticmethod
    def ComputeLocalBounds(points:'vtkPoints', u:MutableSequence[float], v:MutableSequence[float], w:MutableSequence[float], outputBounds:MutableSequence[float]) -> None: ...
    def Contains(self, bbox:'vtkBoundingBox') -> int: ...
    @staticmethod
    def ContainsLine(x:Sequence[float], s:Sequence[float], lineEnd:Sequence[float], t:float, xInt:MutableSequence[float], plane:int) -> bool: ...
    @overload
    def ContainsPoint(self, p:Sequence[float]) -> int: ...
    @overload
    def ContainsPoint(self, px:float, py:float, pz:float) -> int: ...
    def GetBound(self, i:int) -> float: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    def GetCenter(self, center:MutableSequence[float]) -> None: ...
    def GetCorner(self, corner:int, p:MutableSequence[float]) -> None: ...
    def GetDiagonalLength(self) -> float: ...
    def GetDiagonalLength2(self) -> float: ...
    def GetLength(self, i:int) -> float: ...
    def GetLengths(self, lengths:MutableSequence[float]) -> None: ...
    def GetMaxLength(self) -> float: ...
    @overload
    def GetMaxPoint(self) -> Tuple[float, float, float]: ...
    @overload
    def GetMaxPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def GetMaxPoint(self, x:MutableSequence[float]) -> None: ...
    @overload
    def GetMinPoint(self) -> Tuple[float, float, float]: ...
    @overload
    def GetMinPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def GetMinPoint(self, x:MutableSequence[float]) -> None: ...
    @overload
    def Inflate(self, delta:float) -> None: ...
    @overload
    def Inflate(self, deltaX:float, deltaY:float, deltaZ:float) -> None: ...
    @overload
    def Inflate(self) -> None: ...
    def InflateSlice(self, delta:float) -> None: ...
    def IntersectBox(self, bbox:'vtkBoundingBox') -> int: ...
    def IntersectPlane(self, origin:MutableSequence[float], normal:MutableSequence[float]) -> bool: ...
    def Intersects(self, bbox:'vtkBoundingBox') -> int: ...
    def IntersectsLine(self, p1:Sequence[float], p2:Sequence[float]) -> bool: ...
    def IntersectsSphere(self, center:MutableSequence[float], squaredRadius:float) -> bool: ...
    def IsSubsetOf(self, bbox:'vtkBoundingBox') -> bool: ...
    @overload
    def IsValid(self) -> int: ...
    @overload
    @staticmethod
    def IsValid(bounds:Sequence[float]) -> int: ...
    def Reset(self) -> None: ...
    @overload
    def Scale(self, s:MutableSequence[float]) -> None: ...
    @overload
    def Scale(self, sx:float, sy:float, sz:float) -> None: ...
    @overload
    def ScaleAboutCenter(self, s:float) -> None: ...
    @overload
    def ScaleAboutCenter(self, s:MutableSequence[float]) -> None: ...
    @overload
    def ScaleAboutCenter(self, sx:float, sy:float, sz:float) -> None: ...
    @overload
    def SetBounds(self, bounds:Sequence[float]) -> None: ...
    @overload
    def SetBounds(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def SetMaxPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetMaxPoint(self, p:MutableSequence[float]) -> None: ...
    @overload
    def SetMinPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetMinPoint(self, p:MutableSequence[float]) -> None: ...

class vtkBox(vtkImplicitFunction):
    bounds:'getset_descriptor'
    x_max:'getset_descriptor'
    x_min:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddBounds(self, bounds:Sequence[float]) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetXMax(self, p:MutableSequence[float]) -> None: ...
    @overload
    def GetXMax(self, x:float, y:float, z:float) -> None: ...
    @overload
    def GetXMin(self, p:MutableSequence[float]) -> None: ...
    @overload
    def GetXMin(self, x:float, y:float, z:float) -> None: ...
    @staticmethod
    def IntersectBox(bounds:Sequence[float], origin:Sequence[float], dir:Sequence[float], coord:MutableSequence[float], t:float, tolerance:float=0.0) -> str: ...
    @staticmethod
    def IntersectWithInfiniteLine(bounds:Sequence[float], p1:Sequence[float], p2:Sequence[float], t1:float, t2:float, x1:MutableSequence[float], x2:MutableSequence[float], plane1:int, plane2:int) -> bool: ...
    @staticmethod
    def IntersectWithLine(bounds:Sequence[float], p1:Sequence[float], p2:Sequence[float], t1:float, t2:float, x1:MutableSequence[float], x2:MutableSequence[float], plane1:int, plane2:int) -> int: ...
    @overload
    @staticmethod
    def IntersectWithPlane(bounds:MutableSequence[float], origin:MutableSequence[float], normal:MutableSequence[float]) -> int: ...
    @overload
    @staticmethod
    def IntersectWithPlane(bounds:MutableSequence[float], origin:MutableSequence[float], normal:MutableSequence[float], xout:MutableSequence[float]) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsBoxInFrustum(planes:MutableSequence[float], bounds:MutableSequence[float]) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBox': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBox': ...
    @overload
    def SetBounds(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def SetBounds(self, bounds:Sequence[float]) -> None: ...
    @overload
    def SetXMax(self, p:MutableSequence[float]) -> None: ...
    @overload
    def SetXMax(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetXMin(self, p:MutableSequence[float]) -> None: ...
    @overload
    def SetXMin(self, x:float, y:float, z:float) -> None: ...

class vtkCell3D(vtkCell):
    cell_dimension:'getset_descriptor'
    merge_tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', connectivity:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def GetCellDimension(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, faceIds:Sequence[int]) -> None: ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faceIds:Sequence[int]) -> int: ...
    def GetMergeTolerance(self) -> float: ...
    def GetMergeToleranceMaxValue(self) -> float: ...
    def GetMergeToleranceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointToIncidentEdges(self, pointId:int, edgeIds:Sequence[int]) -> int: ...
    def GetPointToIncidentFaces(self, pointId:int, faceIds:Sequence[int]) -> int: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    def Inflate(self, dist:float) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInsideOut(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCell3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCell3D': ...
    def SetMergeTolerance(self, _arg:float) -> None: ...

class vtkCellArray(vtkAbstractCellArray):
    actual_memory_size:'getset_descriptor'
    connectivity_array:'getset_descriptor'
    connectivity_array32:'getset_descriptor'
    connectivity_array64:'getset_descriptor'
    data:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_connectivity_entries:'getset_descriptor'
    number_of_connectivity_ids:'getset_descriptor'
    offsets_array:'getset_descriptor'
    offsets_array32:'getset_descriptor'
    offsets_array64:'getset_descriptor'
    size:'getset_descriptor'
    traversal_cell_id:'getset_descriptor'
    traversal_location:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Allocate(self, sz:int, ext:int=1000) -> int: ...
    def AllocateCopy(self, other:'vtkCellArray') -> bool: ...
    def AllocateEstimate(self, numCells:int, maxCellSize:int) -> bool: ...
    def AllocateExact(self, numCells:int, connectivitySize:int) -> bool: ...
    def Append(self, src:'vtkCellArray', pointOffset:int=0) -> None: ...
    @overload
    def AppendLegacyFormat(self, data:'vtkIdTypeArray', ptOffset:int=0) -> None: ...
    @overload
    def AppendLegacyFormat(self, data:Sequence[int], len:int, ptOffset:int=0) -> None: ...
    def CanConvertTo32BitStorage(self) -> bool: ...
    def CanConvertTo64BitStorage(self) -> bool: ...
    def CanConvertToDefaultStorage(self) -> bool: ...
    def ConvertTo32BitStorage(self) -> bool: ...
    def ConvertTo64BitStorage(self) -> bool: ...
    def ConvertToDefaultStorage(self) -> bool: ...
    def ConvertToSmallestStorage(self) -> bool: ...
    def DeepCopy(self, ca:'vtkAbstractCellArray') -> None: ...
    def EstimateSize(self, numCells:int, maxPtsPerCell:int) -> int: ...
    def ExportLegacyFormat(self, data:'vtkIdTypeArray') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetCell(self, loc:int, npts:int, pts:Sequence[int]) -> None: ...
    @overload
    def GetCell(self, loc:int, pts:'vtkIdList') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, cellSize:int, cellPoints:Sequence[int], ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, pts:'vtkIdList') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, cellSize:int, cellPoints:MutableSequence[int]) -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, cellSize:int, cellPoints:Sequence[int]) -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetConnectivityArray(self) -> 'vtkDataArray': ...
    def GetConnectivityArray32(self) -> 'vtkTypeInt32Array': ...
    def GetConnectivityArray64(self) -> 'vtkTypeInt64Array': ...
    def GetData(self) -> 'vtkIdTypeArray': ...
    def GetInsertLocation(self, npts:int) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    @overload
    def GetNextCell(self, npts:int, pts:Sequence[int]) -> int: ...
    @overload
    def GetNextCell(self, pts:'vtkIdList') -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfConnectivityEntries(self) -> int: ...
    def GetNumberOfConnectivityIds(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfOffsets(self) -> int: ...
    def GetOffset(self, cellId:int) -> int: ...
    def GetOffsetsArray(self) -> 'vtkDataArray': ...
    def GetOffsetsArray32(self) -> 'vtkTypeInt32Array': ...
    def GetOffsetsArray64(self) -> 'vtkTypeInt64Array': ...
    def GetSize(self) -> int: ...
    def GetTraversalCellId(self) -> int: ...
    @overload
    def GetTraversalLocation(self) -> int: ...
    @overload
    def GetTraversalLocation(self, npts:int) -> int: ...
    @overload
    def ImportLegacyFormat(self, data:'vtkIdTypeArray') -> None: ...
    @overload
    def ImportLegacyFormat(self, data:Sequence[int], len:int) -> None: ...
    def InitTraversal(self) -> None: ...
    def Initialize(self) -> None: ...
    def InsertCellPoint(self, id:int) -> None: ...
    @overload
    def InsertNextCell(self, cell:'vtkCell') -> int: ...
    @overload
    def InsertNextCell(self, npts:int, pts:Sequence[int]) -> int: ...
    @overload
    def InsertNextCell(self, pts:'vtkIdList') -> int: ...
    @overload
    def InsertNextCell(self, npts:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsHomogeneous(self) -> int: ...
    def IsStorage64Bit(self) -> bool: ...
    def IsStorageShareable(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsValid(self) -> bool: ...
    def NewInstance(self) -> 'vtkCellArray': ...
    def NewIterator(self) -> 'vtkCellArrayIterator': ...
    def ReplaceCell(self, loc:int, npts:int, pts:Sequence[int]) -> None: ...
    @overload
    def ReplaceCellAtId(self, cellId:int, list:'vtkIdList') -> None: ...
    @overload
    def ReplaceCellAtId(self, cellId:int, cellSize:int, cellPoints:Sequence[int]) -> None: ...
    def ReplaceCellPointAtId(self, cellId:int, cellPointIndex:int, newPointId:int) -> None: ...
    def Reset(self) -> None: ...
    def ResizeExact(self, numCells:int, connectivitySize:int) -> bool: ...
    def ReverseCell(self, loc:int) -> None: ...
    def ReverseCellAtId(self, cellId:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellArray': ...
    def SetCells(self, ncells:int, cells:'vtkIdTypeArray') -> None: ...
    @overload
    def SetData(self, offsets:'vtkIdTypeArray', connectivity:'vtkIdTypeArray') -> None: ...
    @overload
    def SetData(self, offsets:'vtkAOSDataArrayTemplate_IiE', connectivity:'vtkAOSDataArrayTemplate_IiE') -> None: ...
    @overload
    def SetData(self, offsets:'vtkAOSDataArrayTemplate_IlE', connectivity:'vtkAOSDataArrayTemplate_IlE') -> None: ...
    @overload
    def SetData(self, offsets:'vtkAOSDataArrayTemplate_IxE', connectivity:'vtkAOSDataArrayTemplate_IxE') -> None: ...
    @overload
    def SetData(self, offsets:'vtkTypeInt32Array', connectivity:'vtkTypeInt32Array') -> None: ...
    @overload
    def SetData(self, offsets:'vtkTypeInt64Array', connectivity:'vtkTypeInt64Array') -> None: ...
    @overload
    def SetData(self, offsets:'vtkDataArray', connectivity:'vtkDataArray') -> bool: ...
    @overload
    def SetData(self, cellSize:int, connectivity:'vtkDataArray') -> bool: ...
    def SetNumberOfCells(self, __a:int) -> None: ...
    def SetTraversalCellId(self, cellId:int) -> None: ...
    def SetTraversalLocation(self, loc:int) -> None: ...
    def ShallowCopy(self, ca:'vtkAbstractCellArray') -> None: ...
    def Squeeze(self) -> None: ...
    def UpdateCellCount(self, npts:int) -> None: ...
    def Use32BitStorage(self) -> None: ...
    def Use64BitStorage(self) -> None: ...
    def UseDefaultStorage(self) -> None: ...

class vtkCellArrayIterator(vtkmodules.vtkCommonCore.vtkObject):
    cell_array:'getset_descriptor'
    current_cell:'getset_descriptor'
    current_cell_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellArray(self) -> 'vtkCellArray': ...
    @overload
    def GetCellAtId(self, cellId:int, numCellPts:int, cellPts:Sequence[int]) -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, cellIds:'vtkIdList') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int) -> 'vtkIdList': ...
    @overload
    def GetCurrentCell(self, cellSize:int, cellPoints:Sequence[int]) -> None: ...
    @overload
    def GetCurrentCell(self, ids:'vtkIdList') -> None: ...
    @overload
    def GetCurrentCell(self) -> 'vtkIdList': ...
    def GetCurrentCellId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GoToCell(self, cellId:int) -> None: ...
    def GoToFirstCell(self) -> None: ...
    def GoToNextCell(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellArrayIterator': ...
    @overload
    def ReplaceCurrentCell(self, list:'vtkIdList') -> None: ...
    @overload
    def ReplaceCurrentCell(self, npts:int, pts:Sequence[int]) -> None: ...
    def ReverseCurrentCell(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellArrayIterator': ...

class vtkCellAttribute(vtkmodules.vtkCommonCore.vtkObject):
    colormap:'getset_descriptor'
    id:'getset_descriptor'
    name:'getset_descriptor'
    number_of_components:'getset_descriptor'
    space:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def DecodeSpace(space:str, base:str, exp:float, halfspace:int, quiet:bool=False) -> bool: ...
    @staticmethod
    def EncodeSpace(base:str, __b:int, halfspace:int=0) -> str: ...
    def GetArrayForCellTypeAndRole(self, cellType:'vtkStringToken', arrayRole:'vtkStringToken') -> 'vtkAbstractArray': ...
    def GetColormap(self) -> 'vtkScalarsToColors': ...
    def GetId(self) -> int: ...
    def GetName(self) -> 'vtkStringToken': ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSpace(self) -> 'vtkStringToken': ...
    def Initialize(self, name:'vtkStringToken', space:'vtkStringToken', numberOfComponents:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellAttribute': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellAttribute': ...
    def SetColormap(self, colormap:'vtkScalarsToColors') -> bool: ...
    def SetId(self, _arg:int) -> None: ...
    def ShallowCopy(self, other:'vtkCellAttribute', copyArrays:bool=True) -> None: ...

class vtkCellAttributeCalculator(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellAttributeCalculator': ...
    def PrepareForGrid(self, cell:'vtkCellMetadata', field:'vtkCellAttribute') -> 'vtkCellAttributeCalculator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellAttributeCalculator': ...

class vtkFieldData(vtkmodules.vtkCommonCore.vtkObject):
    actual_memory_size:'getset_descriptor'
    ghost_array:'getset_descriptor'
    ghosts_to_skip:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_components:'getset_descriptor'
    number_of_tuples:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddArray(self, array:'vtkAbstractArray') -> int: ...
    def Allocate(self, sz:int, ext:int=1000) -> int: ...
    def AllocateArrays(self, num:int) -> None: ...
    def CopyAllOff(self, unused:int=0) -> None: ...
    def CopyAllOn(self, unused:int=0) -> None: ...
    def CopyFieldOff(self, name:str) -> None: ...
    def CopyFieldOn(self, name:str) -> None: ...
    def CopyStructure(self, __a:'vtkFieldData') -> None: ...
    def DeepCopy(self, da:'vtkFieldData') -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkFieldData': ...
    @overload
    def GetAbstractArray(self, i:int) -> 'vtkAbstractArray': ...
    @overload
    def GetAbstractArray(self, arrayName:str, index:int) -> 'vtkAbstractArray': ...
    @overload
    def GetAbstractArray(self, arrayName:str) -> 'vtkAbstractArray': ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetArray(self, i:int) -> 'vtkDataArray': ...
    @overload
    def GetArray(self, arrayName:str, index:int) -> 'vtkDataArray': ...
    @overload
    def GetArray(self, arrayName:str) -> 'vtkDataArray': ...
    def GetArrayContainingComponent(self, i:int, arrayComp:int) -> int: ...
    def GetArrayName(self, i:int) -> str: ...
    def GetField(self, ptId:'vtkIdList', f:'vtkFieldData') -> None: ...
    @overload
    def GetFiniteRange(self, name:str, range:MutableSequence[float], comp:int=0) -> bool: ...
    @overload
    def GetFiniteRange(self, index:int, range:MutableSequence[float], comp:int=0) -> bool: ...
    def GetGhostArray(self) -> 'vtkUnsignedCharArray': ...
    def GetGhostsToSkip(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfArrays(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    @overload
    def GetRange(self, name:str, range:MutableSequence[float], comp:int=0) -> bool: ...
    @overload
    def GetRange(self, index:int, range:MutableSequence[float], comp:int=0) -> bool: ...
    def HasAnyGhostBitSet(self, bitFlag:int) -> bool: ...
    def HasArray(self, name:str) -> int: ...
    def Initialize(self) -> None: ...
    def InsertNextTuple(self, j:int, source:'vtkFieldData') -> int: ...
    def InsertTuple(self, i:int, j:int, source:'vtkFieldData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFieldData': ...
    def NullData(self, id:int) -> None: ...
    def PassData(self, fd:'vtkFieldData') -> None: ...
    @overload
    def RemoveArray(self, name:str) -> None: ...
    @overload
    def RemoveArray(self, index:int) -> None: ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFieldData': ...
    def SetGhostsToSkip(self, __a:int) -> None: ...
    def SetNumberOfTuples(self, number:int) -> None: ...
    def SetTuple(self, i:int, j:int, source:'vtkFieldData') -> None: ...
    def ShallowCopy(self, da:'vtkFieldData') -> None: ...
    def Squeeze(self) -> None: ...

class vtkDataSetAttributes(vtkFieldData):
    class AttributeCopyOperations(int): ...
    class AttributeLimitTypes(int): ...
    class AttributeTypes(int): ...
    class CellGhostTypes(int): ...
    class PointGhostTypes(int): ...
    ALLCOPY:'AttributeCopyOperations'
    COPYTUPLE:'AttributeCopyOperations'
    DUPLICATECELL:'CellGhostTypes'
    DUPLICATEPOINT:'PointGhostTypes'
    EDGEFLAG:'AttributeTypes'
    EXACT:'AttributeLimitTypes'
    EXTERIORCELL:'CellGhostTypes'
    GLOBALIDS:'AttributeTypes'
    HIDDENCELL:'CellGhostTypes'
    HIDDENPOINT:'PointGhostTypes'
    HIGHCONNECTIVITYCELL:'CellGhostTypes'
    HIGHERORDERDEGREES:'AttributeTypes'
    INTERPOLATE:'AttributeCopyOperations'
    LOWCONNECTIVITYCELL:'CellGhostTypes'
    MAX:'AttributeLimitTypes'
    NOLIMIT:'AttributeLimitTypes'
    NORMALS:'AttributeTypes'
    NUM_ATTRIBUTES:'AttributeTypes'
    PASSDATA:'AttributeCopyOperations'
    PEDIGREEIDS:'AttributeTypes'
    PROCESSIDS:'AttributeTypes'
    RATIONALWEIGHTS:'AttributeTypes'
    REFINEDCELL:'CellGhostTypes'
    SCALARS:'AttributeTypes'
    TANGENTS:'AttributeTypes'
    TCOORDS:'AttributeTypes'
    TENSORS:'AttributeTypes'
    VECTORS:'AttributeTypes'
    copy_attribute:'getset_descriptor'
    copy_global_ids:'getset_descriptor'
    copy_higher_order_degrees:'getset_descriptor'
    copy_normals:'getset_descriptor'
    copy_pedigree_ids:'getset_descriptor'
    copy_process_ids:'getset_descriptor'
    copy_rational_weights:'getset_descriptor'
    copy_scalars:'getset_descriptor'
    copy_t_coords:'getset_descriptor'
    copy_tangents:'getset_descriptor'
    copy_tensors:'getset_descriptor'
    copy_vectors:'getset_descriptor'
    global_ids:'getset_descriptor'
    higher_order_degrees:'getset_descriptor'
    normals:'getset_descriptor'
    pedigree_ids:'getset_descriptor'
    process_ids:'getset_descriptor'
    rational_weights:'getset_descriptor'
    scalars:'getset_descriptor'
    t_coords:'getset_descriptor'
    tangents:'getset_descriptor'
    tensors:'getset_descriptor'
    vectors:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CopyAllOff(self, ctype:int=...) -> None: ...
    def CopyAllOn(self, ctype:int=...) -> None: ...
    @overload
    def CopyAllocate(self, pd:'vtkDataSetAttributes', sze:int=0, ext:int=1000) -> None: ...
    @overload
    def CopyAllocate(self, pd:'vtkDataSetAttributes', sze:int, ext:int, shallowCopyArrays:int) -> None: ...
    @overload
    def CopyAllocate(self, list:'vtkDataSetAttributesFieldList', sze:int=0, ext:int=1000) -> None: ...
    @overload
    def CopyData(self, fromPd:'vtkDataSetAttributes', fromId:int, toId:int) -> None: ...
    @overload
    def CopyData(self, fromPd:'vtkDataSetAttributes', fromIds:'vtkIdList', toIds:'vtkIdList') -> None: ...
    @overload
    def CopyData(self, fromPd:'vtkDataSetAttributes', fromIds:'vtkIdList', destStartId:int=0) -> None: ...
    @overload
    def CopyData(self, fromPd:'vtkDataSetAttributes', dstStart:int, n:int, srcStart:int) -> None: ...
    @overload
    def CopyData(self, list:'vtkDataSetAttributesFieldList', dsa:'vtkDataSetAttributes', idx:int, fromId:int, toId:int) -> None: ...
    @overload
    def CopyData(self, list:'vtkDataSetAttributesFieldList', dsa:'vtkDataSetAttributes', idx:int, dstStart:int, n:int, srcStart:int) -> None: ...
    def CopyGlobalIdsOff(self) -> None: ...
    def CopyGlobalIdsOn(self) -> None: ...
    def CopyHigherOrderDegreesOff(self) -> None: ...
    def CopyHigherOrderDegreesOn(self) -> None: ...
    def CopyNormalsOff(self) -> None: ...
    def CopyNormalsOn(self) -> None: ...
    def CopyPedigreeIdsOff(self) -> None: ...
    def CopyPedigreeIdsOn(self) -> None: ...
    def CopyProcessIdsOff(self) -> None: ...
    def CopyProcessIdsOn(self) -> None: ...
    def CopyRationalWeightsOff(self) -> None: ...
    def CopyRationalWeightsOn(self) -> None: ...
    def CopyScalarsOff(self) -> None: ...
    def CopyScalarsOn(self) -> None: ...
    def CopyStructuredData(self, inDsa:'vtkDataSetAttributes', inExt:Sequence[int], outExt:Sequence[int], setSize:bool=True) -> None: ...
    def CopyTCoordsOff(self) -> None: ...
    def CopyTCoordsOn(self) -> None: ...
    def CopyTangentsOff(self) -> None: ...
    def CopyTangentsOn(self) -> None: ...
    def CopyTensorsOff(self) -> None: ...
    def CopyTensorsOn(self) -> None: ...
    def CopyTuple(self, fromData:'vtkAbstractArray', toData:'vtkAbstractArray', fromId:int, toId:int) -> None: ...
    @overload
    def CopyTuples(self, fromData:'vtkAbstractArray', toData:'vtkAbstractArray', fromIds:'vtkIdList', toIds:'vtkIdList') -> None: ...
    @overload
    def CopyTuples(self, fromData:'vtkAbstractArray', toData:'vtkAbstractArray', dstStart:int, n:int, srcStart:int) -> None: ...
    def CopyVectorsOff(self) -> None: ...
    def CopyVectorsOn(self) -> None: ...
    def DeepCopy(self, pd:'vtkFieldData') -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkDataSetAttributes': ...
    def GetAbstractAttribute(self, attributeType:int) -> 'vtkAbstractArray': ...
    def GetAttribute(self, attributeType:int) -> 'vtkDataArray': ...
    def GetAttributeIndices(self, indexArray:MutableSequence[int]) -> None: ...
    @staticmethod
    def GetAttributeTypeAsString(attributeType:int) -> str: ...
    def GetCopyAttribute(self, index:int, ctype:int) -> int: ...
    def GetCopyGlobalIds(self, ctype:int=...) -> int: ...
    def GetCopyHigherOrderDegrees(self, ctype:int=...) -> int: ...
    def GetCopyNormals(self, ctype:int=...) -> int: ...
    def GetCopyPedigreeIds(self, ctype:int=...) -> int: ...
    def GetCopyProcessIds(self, ctype:int=...) -> int: ...
    def GetCopyRationalWeights(self, ctype:int=...) -> int: ...
    def GetCopyScalars(self, ctype:int=...) -> int: ...
    def GetCopyTCoords(self, ctype:int=...) -> int: ...
    def GetCopyTangents(self, ctype:int=...) -> int: ...
    def GetCopyTensors(self, ctype:int=...) -> int: ...
    def GetCopyVectors(self, ctype:int=...) -> int: ...
    @overload
    def GetGlobalIds(self) -> 'vtkDataArray': ...
    @overload
    def GetGlobalIds(self, name:str) -> 'vtkDataArray': ...
    @overload
    def GetHigherOrderDegrees(self) -> 'vtkDataArray': ...
    @overload
    def GetHigherOrderDegrees(self, name:str) -> 'vtkDataArray': ...
    @staticmethod
    def GetLongAttributeTypeAsString(attributeType:int) -> str: ...
    @overload
    def GetNormals(self) -> 'vtkDataArray': ...
    @overload
    def GetNormals(self, name:str) -> 'vtkDataArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPedigreeIds(self) -> 'vtkAbstractArray': ...
    @overload
    def GetPedigreeIds(self, name:str) -> 'vtkAbstractArray': ...
    @overload
    def GetProcessIds(self) -> 'vtkDataArray': ...
    @overload
    def GetProcessIds(self, name:str) -> 'vtkDataArray': ...
    @overload
    def GetRationalWeights(self) -> 'vtkDataArray': ...
    @overload
    def GetRationalWeights(self, name:str) -> 'vtkDataArray': ...
    @overload
    def GetScalars(self) -> 'vtkDataArray': ...
    @overload
    def GetScalars(self, name:str) -> 'vtkDataArray': ...
    @overload
    def GetTCoords(self) -> 'vtkDataArray': ...
    @overload
    def GetTCoords(self, name:str) -> 'vtkDataArray': ...
    @overload
    def GetTangents(self) -> 'vtkDataArray': ...
    @overload
    def GetTangents(self, name:str) -> 'vtkDataArray': ...
    @overload
    def GetTensors(self) -> 'vtkDataArray': ...
    @overload
    def GetTensors(self, name:str) -> 'vtkDataArray': ...
    @overload
    def GetVectors(self) -> 'vtkDataArray': ...
    @overload
    def GetVectors(self, name:str) -> 'vtkDataArray': ...
    @staticmethod
    def GhostArrayName() -> str: ...
    def Initialize(self) -> None: ...
    @overload
    def InterpolateAllocate(self, pd:'vtkDataSetAttributes', sze:int=0, ext:int=1000) -> None: ...
    @overload
    def InterpolateAllocate(self, pd:'vtkDataSetAttributes', sze:int, ext:int, shallowCopyArrays:int) -> None: ...
    @overload
    def InterpolateAllocate(self, list:'vtkDataSetAttributesFieldList', sze:int=0, ext:int=1000) -> None: ...
    def InterpolateEdge(self, fromPd:'vtkDataSetAttributes', toId:int, p1:int, p2:int, t:float) -> None: ...
    @overload
    def InterpolatePoint(self, fromPd:'vtkDataSetAttributes', toId:int, ids:'vtkIdList', weights:MutableSequence[float]) -> None: ...
    @overload
    def InterpolatePoint(self, list:'vtkDataSetAttributesFieldList', fromPd:'vtkDataSetAttributes', idx:int, toId:int, ids:'vtkIdList', weights:MutableSequence[float]) -> None: ...
    def InterpolateTime(self, from1:'vtkDataSetAttributes', from2:'vtkDataSetAttributes', id:int, t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsArrayAnAttribute(self, idx:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetAttributes': ...
    def PassData(self, fd:'vtkFieldData') -> None: ...
    @overload
    def RemoveArray(self, index:int) -> None: ...
    @overload
    def RemoveArray(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetAttributes': ...
    @overload
    def SetActiveAttribute(self, name:str, attributeType:int) -> int: ...
    @overload
    def SetActiveAttribute(self, index:int, attributeType:int) -> int: ...
    def SetActiveGlobalIds(self, name:str) -> int: ...
    def SetActiveHigherOrderDegrees(self, name:str) -> int: ...
    def SetActiveNormals(self, name:str) -> int: ...
    def SetActivePedigreeIds(self, name:str) -> int: ...
    def SetActiveProcessIds(self, name:str) -> int: ...
    def SetActiveRationalWeights(self, name:str) -> int: ...
    def SetActiveScalars(self, name:str) -> int: ...
    def SetActiveTCoords(self, name:str) -> int: ...
    def SetActiveTangents(self, name:str) -> int: ...
    def SetActiveTensors(self, name:str) -> int: ...
    def SetActiveVectors(self, name:str) -> int: ...
    def SetAttribute(self, aa:'vtkAbstractArray', attributeType:int) -> int: ...
    def SetCopyAttribute(self, index:int, value:int, ctype:int=...) -> None: ...
    def SetCopyGlobalIds(self, i:int, ctype:int=...) -> None: ...
    def SetCopyHigherOrderDegrees(self, i:int, ctype:int=...) -> None: ...
    def SetCopyNormals(self, i:int, ctype:int=...) -> None: ...
    def SetCopyPedigreeIds(self, i:int, ctype:int=...) -> None: ...
    def SetCopyProcessIds(self, i:int, ctype:int=...) -> None: ...
    def SetCopyRationalWeights(self, i:int, ctype:int=...) -> None: ...
    def SetCopyScalars(self, i:int, ctype:int=...) -> None: ...
    def SetCopyTCoords(self, i:int, ctype:int=...) -> None: ...
    def SetCopyTangents(self, i:int, ctype:int=...) -> None: ...
    def SetCopyTensors(self, i:int, ctype:int=...) -> None: ...
    def SetCopyVectors(self, i:int, ctype:int=...) -> None: ...
    def SetGlobalIds(self, da:'vtkDataArray') -> int: ...
    def SetHigherOrderDegrees(self, da:'vtkDataArray') -> int: ...
    def SetNormals(self, da:'vtkDataArray') -> int: ...
    def SetPedigreeIds(self, da:'vtkAbstractArray') -> int: ...
    def SetProcessIds(self, da:'vtkDataArray') -> int: ...
    def SetRationalWeights(self, da:'vtkDataArray') -> int: ...
    def SetScalars(self, da:'vtkDataArray') -> int: ...
    def SetTCoords(self, da:'vtkDataArray') -> int: ...
    def SetTangents(self, da:'vtkDataArray') -> int: ...
    def SetTensors(self, da:'vtkDataArray') -> int: ...
    def SetVectors(self, da:'vtkDataArray') -> int: ...
    def SetupForCopy(self, pd:'vtkDataSetAttributes') -> None: ...
    def ShallowCopy(self, pd:'vtkFieldData') -> None: ...
    def Update(self) -> None: ...

class vtkCellData(vtkDataSetAttributes):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkCellData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellData': ...

class vtkCellGrid(vtkDataObject):
    actual_memory_size:'getset_descriptor'
    cell_attribute_list:'getset_descriptor'
    cell_types:'getset_descriptor'
    content_version:'getset_descriptor'
    data_object_type:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    schema_name:'getset_descriptor'
    schema_version:'getset_descriptor'
    shape_attribute:'getset_descriptor'
    unordered_cell_attribute_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ARRAY_GROUP_IDS() -> 'vtkInformationIntegerVectorKey': ...
    def AddAllCellMetadata(self) -> int: ...
    def AddCellAttribute(self, attribute:'vtkCellAttribute') -> bool: ...
    @overload
    def AddCellMetadata(self, cellType:'vtkCellMetadata') -> 'vtkCellMetadata': ...
    @overload
    def AddCellMetadata(self, cellTypeName:'vtkStringToken') -> 'vtkCellMetadata': ...
    def ClearRangeCache(self, attributeName:str=...) -> None: ...
    def CopyStructure(self, other:'vtkCellGrid', byReference:bool=True) -> bool: ...
    @staticmethod
    def CorrespondingArray(gridA:'vtkCellGrid', arrayA:'vtkDataArray', gridB:'vtkCellGrid') -> 'vtkDataArray': ...
    def DeepCopy(self, baseSrc:'vtkDataObject') -> None: ...
    @overload
    def FindAttributes(self, type:int) -> 'vtkDataSetAttributes': ...
    @overload
    def FindAttributes(self, type:'vtkStringToken') -> 'vtkDataSetAttributes': ...
    def GetActualMemorySize(self) -> int: ...
    def GetAttributeTypeForArray(self, arr:'vtkAbstractArray') -> int: ...
    @overload
    def GetAttributes(self, type:int) -> 'vtkDataSetAttributes': ...
    @overload
    def GetAttributes(self, type:'vtkStringToken') -> 'vtkDataSetAttributes': ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCellAttributeById(self, attributeId:int) -> 'vtkCellAttribute': ...
    def GetCellAttributeByName(self, name:str) -> 'vtkCellAttribute': ...
    def GetCellAttributeList(self) -> Tuple['vtkCellAttribute', 'vtkCellAttribute']: ...
    def GetCellAttributeRange(self, attribute:'vtkCellAttribute', componentIndex:int, range:MutableSequence[float], finiteRange:bool=False) -> bool: ...
    def GetCellType(self, cellTypeName:'vtkStringToken') -> 'vtkCellMetadata': ...
    def GetCellTypes(self) -> Tuple[str, str]: ...
    def GetContentVersion(self) -> int: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkCellGrid': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkCellGrid': ...
    def GetDataObjectType(self) -> int: ...
    def GetGhostArray(self, type:int) -> 'vtkUnsignedCharArray': ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfElements(self, type:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSchemaName(self) -> 'vtkStringToken': ...
    def GetSchemaVersion(self) -> int: ...
    def GetShapeAttribute(self) -> 'vtkCellAttribute': ...
    def GetUnorderedCellAttributeIds(self) -> Tuple[int, int]: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGrid': ...
    def Query(self, query:'vtkCellGridQuery') -> bool: ...
    def RemoveCellAttribute(self, attribute:'vtkCellAttribute') -> bool: ...
    def RemoveCellMetadata(self, meta:'vtkCellMetadata') -> bool: ...
    def RemoveUnusedCellMetadata(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGrid': ...
    def SetContentVersion(self, _arg:int) -> None: ...
    def SetSchema(self, name:'vtkStringToken', version:int) -> None: ...
    def SetShapeAttribute(self, shape:'vtkCellAttribute') -> bool: ...
    def ShallowCopy(self, baseSrc:'vtkDataObject') -> None: ...
    def SupportsGhostArray(self, type:int) -> bool: ...

class vtkCellGridQuery(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def Finalize(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPass(self) -> int: ...
    def Initialize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsAnotherPassRequired(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridQuery': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridQuery': ...
    def StartPass(self) -> None: ...

class vtkCellGridBoundsQuery(vtkCellGridQuery):
    def __init__(self, **properties:Any) -> None: ...
    def AddBounds(self, bbox:'vtkBoundingBox') -> None: ...
    def GetBounds(self, bds:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridBoundsQuery': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridBoundsQuery': ...

class vtkCellGridCopyQuery(vtkCellGridQuery):
    copy_array_values:'getset_descriptor'
    copy_arrays:'getset_descriptor'
    copy_cell_types:'getset_descriptor'
    copy_cells:'getset_descriptor'
    copy_only_shape:'getset_descriptor'
    copy_schema:'getset_descriptor'
    deep_copy_arrays:'getset_descriptor'
    source:'getset_descriptor'
    target:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddAllSourceCellAttributeIds(self) -> bool: ...
    def AddSourceCellAttributeId(self, attributeId:int) -> bool: ...
    def CopyArrayValuesOff(self) -> None: ...
    def CopyArrayValuesOn(self) -> None: ...
    def CopyArraysOff(self) -> None: ...
    def CopyArraysOn(self) -> None: ...
    def CopyAttributeArrays(self, srcAtt:'vtkCellAttribute', cellType:'vtkStringToken') -> None: ...
    def CopyCellTypesOff(self) -> None: ...
    def CopyCellTypesOn(self) -> None: ...
    def CopyCellsOff(self) -> None: ...
    def CopyCellsOn(self) -> None: ...
    def CopyOnlyShapeOff(self) -> None: ...
    def CopyOnlyShapeOn(self) -> None: ...
    def CopyOrUpdateAttributeRecord(self, srcAtt:'vtkCellAttribute', cellType:'vtkStringToken') -> 'vtkCellAttribute': ...
    def CopySchemaOff(self) -> None: ...
    def CopySchemaOn(self) -> None: ...
    def DeepCopyArraysOff(self) -> None: ...
    def DeepCopyArraysOn(self) -> None: ...
    def Finalize(self) -> bool: ...
    def GetCellAttributeIds(self, ids:'vtkIdList') -> None: ...
    def GetCopyArrayValues(self) -> int: ...
    def GetCopyArrays(self) -> int: ...
    def GetCopyCellTypes(self) -> int: ...
    def GetCopyCells(self) -> int: ...
    def GetCopyOnlyShape(self) -> int: ...
    def GetCopySchema(self) -> int: ...
    def GetDeepCopyArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSource(self) -> 'vtkCellGrid': ...
    def GetTarget(self) -> 'vtkCellGrid': ...
    def Initialize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridCopyQuery': ...
    def RemoveSourceCellAttributeId(self, attributeId:int) -> bool: ...
    def ResetCellAttributeIds(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridCopyQuery': ...
    def SetCopyArrayValues(self, _arg:int) -> None: ...
    def SetCopyArrays(self, _arg:int) -> None: ...
    def SetCopyCellTypes(self, _arg:int) -> None: ...
    def SetCopyCells(self, _arg:int) -> None: ...
    def SetCopyOnlyShape(self, _arg:int) -> None: ...
    def SetCopySchema(self, _arg:int) -> None: ...
    def SetDeepCopyArrays(self, _arg:int) -> None: ...
    def SetSource(self, source:'vtkCellGrid') -> None: ...
    def SetTarget(self, target:'vtkCellGrid') -> None: ...

class vtkCellGridEvaluator(vtkCellGridQuery):
    class Phases(int): ...
    Classify:'Phases'
    ClassifyAndInterpolate:'Phases'
    Interpolate:'Phases'
    None_:'Phases'
    cell_attribute:'getset_descriptor'
    classifier_cell_indices:'getset_descriptor'
    classifier_cell_offsets:'getset_descriptor'
    classifier_cell_types:'getset_descriptor'
    classifier_point_i_ds:'getset_descriptor'
    classifier_point_parameters:'getset_descriptor'
    input_points:'getset_descriptor'
    interpolated_values:'getset_descriptor'
    locator:'getset_descriptor'
    phases_to_perform:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClassifyPoints(self, points:'vtkDataArray') -> None: ...
    def Finalize(self) -> bool: ...
    def GetCellAttribute(self) -> 'vtkCellAttribute': ...
    def GetClassifierCellIndices(self) -> 'vtkTypeUInt64Array': ...
    def GetClassifierCellOffsets(self) -> 'vtkTypeUInt64Array': ...
    def GetClassifierCellTypes(self) -> 'vtkTypeUInt32Array': ...
    def GetClassifierPointIDs(self) -> 'vtkTypeUInt64Array': ...
    def GetClassifierPointParameters(self) -> 'vtkDataArray': ...
    def GetInputPoints(self) -> 'vtkDataArray': ...
    def GetInterpolatedValues(self) -> 'vtkDataArray': ...
    def GetLocator(self) -> 'vtkStaticPointLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhasesToPerform(self) -> vtkCellGridEvaluator.Phases: ...
    def Initialize(self) -> bool: ...
    def InterpolateCellParameters(self, cellTypes:'vtkTypeUInt32Array', cellOffsets:'vtkTypeUInt64Array', cellIndices:'vtkTypeUInt64Array', pointParameters:'vtkDataArray') -> None: ...
    def InterpolatePoints(self, points:'vtkDataArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsAnotherPassRequired(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridEvaluator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridEvaluator': ...
    def SetCellAttribute(self, _arg:'vtkCellAttribute') -> None: ...
    def StartPass(self) -> None: ...

class vtkCellGridRangeQuery(vtkCellGridQuery):
    cell_attribute:'getset_descriptor'
    cell_grid:'getset_descriptor'
    component:'getset_descriptor'
    finite_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Finalize(self) -> bool: ...
    def GetCellAttribute(self) -> 'vtkCellAttribute': ...
    def GetCellGrid(self) -> 'vtkCellGrid': ...
    def GetComponent(self) -> int: ...
    def GetFiniteRange(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetRange(self, component:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GetRange(self, range:MutableSequence[float]) -> None: ...
    def Initialize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridRangeQuery': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridRangeQuery': ...
    def SetCellAttribute(self, _arg:'vtkCellAttribute') -> None: ...
    def SetCellGrid(self, grid:'vtkCellGrid') -> None: ...
    def SetComponent(self, _arg:int) -> None: ...
    def SetFiniteRange(self, _arg:int) -> None: ...

class vtkCellGridResponderBase(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def EvaluateQuery(self, query:'vtkCellGridQuery', cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridResponderBase': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridResponderBase': ...

class vtkCellGridResponders(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GetCacheData(self, key:int) -> 'vtkObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridResponders': ...
    def Query(self, cellType:'vtkCellMetadata', query:'vtkCellGridQuery') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridResponders': ...
    def SetCacheData(self, key:int, value:'vtkObject', overwrite:bool=False) -> bool: ...

class vtkCellGridSidesCache(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridSidesCache': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridSidesCache': ...

class vtkCellGridSidesQuery(vtkCellGridQuery):
    class SideFlags(int): ...
    class SummaryStrategy(int): ...
    class PassWork(int): ...
    class SelectionMode(int): ...
    AllSides:'SideFlags'
    AnyOccurrence:'SummaryStrategy'
    Boundary:'SummaryStrategy'
    EdgesOfInputs:'SideFlags'
    EdgesOfSurfaces:'SideFlags'
    EdgesOfVolumes:'SideFlags'
    GenerateSideSets:'PassWork'
    HashSides:'PassWork'
    Input:'SelectionMode'
    NextLowestDimension:'SideFlags'
    Output:'SelectionMode'
    Summarize:'PassWork'
    SurfacesOfInputs:'SideFlags'
    SurfacesOfVolumes:'SideFlags'
    VerticesOfEdges:'SideFlags'
    VerticesOfInputs:'SideFlags'
    VerticesOfSurfaces:'SideFlags'
    VerticesOfVolumes:'SideFlags'
    Winding:'SummaryStrategy'
    omit_sides_for_renderable_inputs:'getset_descriptor'
    output_dimension_control:'getset_descriptor'
    preserve_renderable_inputs:'getset_descriptor'
    selection_type:'getset_descriptor'
    side_cache:'getset_descriptor'
    strategy:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Finalize(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOmitSidesForRenderableInputs(self) -> int: ...
    def GetOutputDimensionControl(self) -> int: ...
    def GetPreserveRenderableInputs(self) -> int: ...
    def GetSelectionType(self) -> 'SelectionMode': ...
    def GetSideCache(self) -> 'vtkCellGridSidesCache': ...
    def GetStrategy(self) -> 'SummaryStrategy': ...
    def Initialize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsAnotherPassRequired(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridSidesQuery': ...
    def OmitSidesForRenderableInputsOff(self) -> None: ...
    def OmitSidesForRenderableInputsOn(self) -> None: ...
    def OutputDimensionControlOff(self) -> None: ...
    def OutputDimensionControlOn(self) -> None: ...
    def PreserveRenderableInputsOff(self) -> None: ...
    def PreserveRenderableInputsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridSidesQuery': ...
    @staticmethod
    def SelectionModeFromLabel(token:'vtkStringToken') -> 'SelectionMode': ...
    @staticmethod
    def SelectionModeToLabel(mode:'SelectionMode') -> 'vtkStringToken': ...
    def SetOmitSidesForRenderableInputs(self, _arg:int) -> None: ...
    def SetOutputDimensionControl(self, _arg:int) -> None: ...
    def SetPreserveRenderableInputs(self, _arg:int) -> None: ...
    @overload
    def SetSelectionType(self, _arg:'SelectionMode') -> None: ...
    @overload
    def SetSelectionType(self, selnType:int) -> None: ...
    def SetSideCache(self, cache:'vtkCellGridSidesCache') -> None: ...
    @overload
    def SetStrategy(self, _arg:'SummaryStrategy') -> None: ...
    @overload
    def SetStrategy(self, strategy:int) -> None: ...
    def SetStrategyToAnyOccurrence(self) -> None: ...
    def SetStrategyToBoundary(self) -> None: ...
    def SetStrategyToWinding(self) -> None: ...
    def StartPass(self) -> None: ...
    @staticmethod
    def SummaryStrategyFromLabel(token:'vtkStringToken') -> 'SummaryStrategy': ...
    @staticmethod
    def SummaryStrategyToLabel(strategy:'SummaryStrategy') -> 'vtkStringToken': ...

class vtkCellIterator(vtkmodules.vtkCommonCore.vtkObject):
    cell_dimension:'getset_descriptor'
    cell_faces:'getset_descriptor'
    cell_id:'getset_descriptor'
    cell_type:'getset_descriptor'
    faces:'getset_descriptor'
    number_of_faces:'getset_descriptor'
    number_of_points:'getset_descriptor'
    point_ids:'getset_descriptor'
    points:'getset_descriptor'
    serialized_cell_faces:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCell(self, cell:'vtkGenericCell') -> None: ...
    def GetCellDimension(self) -> int: ...
    def GetCellFaces(self) -> 'vtkCellArray': ...
    def GetCellId(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetFaces(self) -> 'vtkIdList': ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetPointIds(self) -> 'vtkIdList': ...
    def GetPoints(self) -> 'vtkPoints': ...
    def GetSerializedCellFaces(self) -> 'vtkIdList': ...
    def GoToNextCell(self) -> None: ...
    def InitTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellIterator': ...

class vtkCellLinks(vtkAbstractCellLinks):
    actual_memory_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddCellReference(self, cellId:int, ptId:int) -> None: ...
    def Allocate(self, numLinks:int, ext:int=1000) -> None: ...
    def BuildLinks(self) -> None: ...
    def DeepCopy(self, src:'vtkAbstractCellLinks') -> None: ...
    def DeletePoint(self, ptId:int) -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetCells(self, ptId:int) -> Pointer: ...
    def GetNcells(self, ptId:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def InsertNextCellReference(self, ptId:int, cellId:int) -> None: ...
    def InsertNextPoint(self, numLinks:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellLinks': ...
    def RemoveCellReference(self, cellId:int, ptId:int) -> None: ...
    def Reset(self) -> None: ...
    def ResizeCellList(self, ptId:int, size:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellLinks': ...
    def SelectCells(self, minMaxDegree:MutableSequence[int], cellSelection:MutableSequence[int]) -> None: ...
    def ShallowCopy(self, src:'vtkAbstractCellLinks') -> None: ...
    def Squeeze(self) -> None: ...

class vtkCellLocator(vtkAbstractCellLocator):
    number_of_buckets:'getset_descriptor'
    number_of_cells_per_bucket:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildLocator(self) -> None: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindCellsAlongLine(self, p1:Sequence[float], p2:Sequence[float], tolerance:float, cellsIds:'vtkIdList') -> None: ...
    def FindCellsWithinBounds(self, bbox:MutableSequence[float], cells:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float], closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float) -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float], closestPoint:MutableSequence[float], cellId:int, subId:int, dist2:float) -> None: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float, inside:int) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cellId:int, subId:int, dist2:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float) -> int: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    def GetCells(self, bucket:int) -> 'vtkIdList': ...
    def GetNumberOfBuckets(self) -> int: ...
    def GetNumberOfCellsPerBucket(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList', cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellLocator': ...
    def SetNumberOfCellsPerBucket(self, N:int) -> None: ...
    def ShallowCopy(self, locator:'vtkAbstractCellLocator') -> None: ...

class vtkFindCellStrategy(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def CopyParameters(self, from_:'vtkFindCellStrategy') -> None: ...
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', gencell:'vtkGenericCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float, inside:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, ps:'vtkPointSet') -> int: ...
    def InsideCellBounds(self, x:MutableSequence[float], cellId:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFindCellStrategy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFindCellStrategy': ...

class vtkCellLocatorStrategy(vtkFindCellStrategy):
    cell_locator:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CopyParameters(self, from_:'vtkFindCellStrategy') -> None: ...
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', gencell:'vtkGenericCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float, inside:int) -> int: ...
    def GetCellLocator(self) -> 'vtkAbstractCellLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, ps:'vtkPointSet') -> int: ...
    def InsideCellBounds(self, x:MutableSequence[float], cellId:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellLocatorStrategy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellLocatorStrategy': ...
    def SetCellLocator(self, __a:'vtkAbstractCellLocator') -> None: ...

class vtkCellMetadata(vtkmodules.vtkCommonCore.vtkObject):
    caches:'getset_descriptor'
    cell_grid:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    responders:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ClearResponders() -> None: ...
    def DeepCopy(self, other:'vtkCellMetadata') -> None: ...
    def GetCaches(self) -> 'vtkCellGridResponders': ...
    def GetCellGrid(self) -> 'vtkCellGrid': ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetResponders() -> 'vtkCellGridResponders': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def NewInstance(self) -> 'vtkCellMetadata': ...
    @overload
    @staticmethod
    def NewInstance(className:'vtkStringToken', grid:'vtkCellGrid'=...) -> 'vtkCellMetadata': ...
    def Query(self, query:'vtkCellGridQuery') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellMetadata': ...
    def SetCellGrid(self, parent:'vtkCellGrid') -> bool: ...
    def ShallowCopy(self, other:'vtkCellMetadata') -> None: ...

class vtkCellTreeLocator(vtkAbstractCellLocator):
    large_ids:'getset_descriptor'
    number_of_buckets:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildLocator(self) -> None: ...
    @overload
    def FindCell(self, pos:MutableSequence[float], tol2:float, cell:'vtkGenericCell', subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindCellsAlongLine(self, p1:Sequence[float], p2:Sequence[float], tolerance:float, cellsIds:'vtkIdList') -> None: ...
    def FindCellsWithinBounds(self, bbox:MutableSequence[float], cells:'vtkIdList') -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    def GetLargeIds(self) -> bool: ...
    def GetNumberOfBuckets(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def IntersectWithLine(self, a0:Sequence[float], a1:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList', cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellTreeLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellTreeLocator': ...
    def SetNumberOfBuckets(self, _arg:int) -> None: ...
    def ShallowCopy(self, locator:'vtkAbstractCellLocator') -> None: ...

class vtkCellTypes(vtkmodules.vtkCommonCore.vtkObject):
    actual_memory_size:'getset_descriptor'
    cell_locations_array:'getset_descriptor'
    cell_types_array:'getset_descriptor'
    number_of_types:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Allocate(self, sz:int=512, ext:int=1000) -> int: ...
    def DeepCopy(self, src:'vtkCellTypes') -> None: ...
    def DeleteCell(self, cellId:int) -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetCellLocationsArray(self) -> 'vtkIdTypeArray': ...
    def GetCellType(self, cellId:int) -> int: ...
    def GetCellTypesArray(self) -> 'vtkUnsignedCharArray': ...
    @staticmethod
    def GetClassNameFromTypeId(typeId:int) -> str: ...
    @staticmethod
    def GetDimension(type:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTypes(self) -> int: ...
    @staticmethod
    def GetTypeIdFromClassName(classname:str) -> int: ...
    def InsertCell(self, id:int, type:int, loc:int) -> None: ...
    def InsertNextCell(self, type:int, loc:int) -> int: ...
    def InsertNextType(self, type:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsLinear(type:int) -> int: ...
    def IsType(self, type:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellTypes': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellTypes': ...
    def SetCellTypes(self, ncells:int, cellTypes:'vtkUnsignedCharArray') -> None: ...
    def Squeeze(self) -> None: ...

class vtkClosestPointStrategy(vtkFindCellStrategy):
    point_locator:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CopyParameters(self, from_:'vtkFindCellStrategy') -> None: ...
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', gencell:'vtkGenericCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float, inside:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointLocator(self) -> 'vtkAbstractPointLocator': ...
    def Initialize(self, ps:'vtkPointSet') -> int: ...
    def InsideCellBounds(self, x:MutableSequence[float], cellId:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClosestPointStrategy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClosestPointStrategy': ...
    def SelectCell(self, self_:'vtkPointSet', cellId:int, cell:'vtkCell', gencell:'vtkGenericCell') -> 'vtkCell': ...
    def SetPointLocator(self, __a:'vtkAbstractPointLocator') -> None: ...

class vtkClosestNPointsStrategy(vtkClosestPointStrategy):
    closest_n_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CopyParameters(self, from_:'vtkFindCellStrategy') -> None: ...
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', gencell:'vtkGenericCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def GetClosestNPoints(self) -> int: ...
    def GetClosestNPointsMaxValue(self) -> int: ...
    def GetClosestNPointsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, ps:'vtkPointSet') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClosestNPointsStrategy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClosestNPointsStrategy': ...
    def SetClosestNPoints(self, _arg:int) -> None: ...

class vtkColor3_IdE(vtkmodules.vtkCommonMath.vtkTuple_IdLi3EE):
    blue:'getset_descriptor'
    green:'getset_descriptor'
    red:'getset_descriptor'
    def GetBlue(self) -> float: ...
    def GetGreen(self) -> float: ...
    def GetRed(self) -> float: ...
    def Set(self, red:float, green:float, blue:float) -> None: ...
    def SetBlue(self, blue:float) -> None: ...
    def SetGreen(self, green:float) -> None: ...
    def SetRed(self, red:float) -> None: ...

class vtkColor3_IfE(vtkmodules.vtkCommonMath.vtkTuple_IfLi3EE):
    blue:'getset_descriptor'
    green:'getset_descriptor'
    red:'getset_descriptor'
    def GetBlue(self) -> float: ...
    def GetGreen(self) -> float: ...
    def GetRed(self) -> float: ...
    def Set(self, red:float, green:float, blue:float) -> None: ...
    def SetBlue(self, blue:float) -> None: ...
    def SetGreen(self, green:float) -> None: ...
    def SetRed(self, red:float) -> None: ...

class vtkColor3_IhE(vtkmodules.vtkCommonMath.vtkTuple_IhLi3EE):
    blue:'getset_descriptor'
    green:'getset_descriptor'
    red:'getset_descriptor'
    def GetBlue(self) -> int: ...
    def GetGreen(self) -> int: ...
    def GetRed(self) -> int: ...
    def Set(self, red:int, green:int, blue:int) -> None: ...
    def SetBlue(self, blue:int) -> None: ...
    def SetGreen(self, green:int) -> None: ...
    def SetRed(self, red:int) -> None: ...

class vtkColor3d(vtkColor3_IdE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, scalar:float) -> None: ...
    @overload
    def __init__(self, init:Sequence[float]) -> None: ...
    @overload
    def __init__(self, r:float, g:float, b:float) -> None: ...
    @overload
    def __init__(self, __a:'vtkColor3d') -> None: ...

class vtkColor3f(vtkColor3_IfE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, scalar:float) -> None: ...
    @overload
    def __init__(self, init:Sequence[float]) -> None: ...
    @overload
    def __init__(self, r:float, g:float, b:float) -> None: ...
    @overload
    def __init__(self, __a:'vtkColor3f') -> None: ...

class vtkColor3ub(vtkColor3_IhE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, init:Sequence[int]) -> None: ...
    @overload
    def __init__(self, hexSigned:int) -> None: ...
    @overload
    def __init__(self, r:int, g:int, b:int) -> None: ...
    @overload
    def __init__(self, __a:'vtkColor3ub') -> None: ...

class vtkColor4_IdE(vtkmodules.vtkCommonMath.vtkTuple_IdLi4EE):
    alpha:'getset_descriptor'
    blue:'getset_descriptor'
    green:'getset_descriptor'
    red:'getset_descriptor'
    def GetAlpha(self) -> float: ...
    def GetBlue(self) -> float: ...
    def GetGreen(self) -> float: ...
    def GetRed(self) -> float: ...
    @overload
    def Set(self, red:float, green:float, blue:float) -> None: ...
    @overload
    def Set(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def SetAlpha(self, alpha:float) -> None: ...
    def SetBlue(self, blue:float) -> None: ...
    def SetGreen(self, green:float) -> None: ...
    def SetRed(self, red:float) -> None: ...

class vtkColor4_IfE(vtkmodules.vtkCommonMath.vtkTuple_IfLi4EE):
    alpha:'getset_descriptor'
    blue:'getset_descriptor'
    green:'getset_descriptor'
    red:'getset_descriptor'
    def GetAlpha(self) -> float: ...
    def GetBlue(self) -> float: ...
    def GetGreen(self) -> float: ...
    def GetRed(self) -> float: ...
    @overload
    def Set(self, red:float, green:float, blue:float) -> None: ...
    @overload
    def Set(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def SetAlpha(self, alpha:float) -> None: ...
    def SetBlue(self, blue:float) -> None: ...
    def SetGreen(self, green:float) -> None: ...
    def SetRed(self, red:float) -> None: ...

class vtkColor4_IhE(vtkmodules.vtkCommonMath.vtkTuple_IhLi4EE):
    alpha:'getset_descriptor'
    blue:'getset_descriptor'
    green:'getset_descriptor'
    red:'getset_descriptor'
    def GetAlpha(self) -> int: ...
    def GetBlue(self) -> int: ...
    def GetGreen(self) -> int: ...
    def GetRed(self) -> int: ...
    @overload
    def Set(self, red:int, green:int, blue:int) -> None: ...
    @overload
    def Set(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def SetAlpha(self, alpha:int) -> None: ...
    def SetBlue(self, blue:int) -> None: ...
    def SetGreen(self, green:int) -> None: ...
    def SetRed(self, red:int) -> None: ...

class vtkColor4d(vtkColor4_IdE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, scalar:float) -> None: ...
    @overload
    def __init__(self, init:Sequence[float]) -> None: ...
    @overload
    def __init__(self, r:float, g:float, b:float, a:float=1.0) -> None: ...
    @overload
    def __init__(self, __a:'vtkColor4d') -> None: ...

class vtkColor4f(vtkColor4_IfE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, scalar:float) -> None: ...
    @overload
    def __init__(self, init:Sequence[float]) -> None: ...
    @overload
    def __init__(self, r:float, g:float, b:float, a:float=1.0) -> None: ...
    @overload
    def __init__(self, __a:'vtkColor4f') -> None: ...

class vtkColor4ub(vtkColor4_IhE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, init:Sequence[int]) -> None: ...
    @overload
    def __init__(self, hexSigned:int) -> None: ...
    @overload
    def __init__(self, r:int, g:int, b:int, a:int=255) -> None: ...
    @overload
    def __init__(self, c:'vtkColor3ub') -> None: ...
    @overload
    def __init__(self, __a:'vtkColor4ub') -> None: ...

class vtkCompositeDataIterator(vtkmodules.vtkCommonCore.vtkObject):
    current_data_object:'getset_descriptor'
    current_flat_index:'getset_descriptor'
    current_meta_data:'getset_descriptor'
    data_set:'getset_descriptor'
    reverse:'getset_descriptor'
    skip_empty_nodes:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCurrentDataObject(self) -> 'vtkDataObject': ...
    def GetCurrentFlatIndex(self) -> int: ...
    def GetCurrentMetaData(self) -> 'vtkInformation': ...
    def GetDataSet(self) -> 'vtkCompositeDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReverse(self) -> int: ...
    def GetSkipEmptyNodes(self) -> int: ...
    def GoToFirstItem(self) -> None: ...
    def GoToNextItem(self) -> None: ...
    def HasCurrentMetaData(self) -> int: ...
    def InitReverseTraversal(self) -> None: ...
    def InitTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeDataIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataIterator': ...
    def SetDataSet(self, ds:'vtkCompositeDataSet') -> None: ...
    def SetSkipEmptyNodes(self, _arg:int) -> None: ...
    def SkipEmptyNodesOff(self) -> None: ...
    def SkipEmptyNodesOn(self) -> None: ...

class vtkCompositeDataSet(vtkDataObject):
    actual_memory_size:'getset_descriptor'
    data_object_type:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CURRENT_PROCESS_CAN_LOAD_BLOCK() -> 'vtkInformationIntegerKey': ...
    def CompositeShallowCopy(self, src:'vtkCompositeDataSet') -> None: ...
    def CopyStructure(self, input:'vtkCompositeDataSet') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkCompositeDataSet': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkCompositeDataSet': ...
    def GetDataObjectType(self) -> int: ...
    @overload
    def GetDataSet(self, iter:'vtkCompositeDataIterator') -> 'vtkDataObject': ...
    @overload
    def GetDataSet(self, flatIndex:int) -> 'vtkDataObject': ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfElements(self, type:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def NAME() -> 'vtkInformationStringKey': ...
    def NewInstance(self) -> 'vtkCompositeDataSet': ...
    def NewIterator(self) -> 'vtkCompositeDataIterator': ...
    def RecursiveShallowCopy(self, src:'vtkDataObject') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataSet': ...
    def SetDataSet(self, iter:'vtkCompositeDataIterator', dataObj:'vtkDataObject') -> None: ...
    def SupportsGhostArray(self, type:int) -> bool: ...

class vtkCone(vtkImplicitFunction):
    angle:'getset_descriptor'
    axis:'getset_descriptor'
    is_double_cone:'getset_descriptor'
    origin:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetAngle(self) -> float: ...
    def GetAngleMaxValue(self) -> float: ...
    def GetAngleMinValue(self) -> float: ...
    def GetAxis(self) -> Tuple[float, float, float]: ...
    def GetIsDoubleCone(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    def IsDoubleConeOff(self) -> None: ...
    def IsDoubleConeOn(self) -> None: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCone': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCone': ...
    def SetAngle(self, _arg:float) -> None: ...
    @overload
    def SetAxis(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetAxis(self, axis:MutableSequence[float]) -> None: ...
    def SetIsDoubleCone(self, _arg:bool) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, xyz:Sequence[float]) -> None: ...

class vtkConvexPointSet(vtkCell3D):
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', connectivity:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellType(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faceIds:Sequence[int]) -> int: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetPointToIncidentEdges(self, pointId:int, edgeIds:Sequence[int]) -> int: ...
    def GetPointToIncidentFaces(self, pointId:int, faceIds:Sequence[int]) -> int: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    def HasFixedTopology(self) -> int: ...
    def Initialize(self) -> None: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], sf:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsPrimaryCell(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvexPointSet': ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvexPointSet': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkCoordinateFrame(vtkImplicitFunction):
    origin:'getset_descriptor'
    x_axis:'getset_descriptor'
    y_axis:'getset_descriptor'
    z_axis:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetXAxis(self) -> Tuple[float, float, float]: ...
    def GetYAxis(self) -> Tuple[float, float, float]: ...
    def GetZAxis(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCoordinateFrame': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCoordinateFrame': ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetXAxis(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetXAxis(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetYAxis(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetYAxis(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetZAxis(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetZAxis(self, _arg:Sequence[float]) -> None: ...

class vtkCubicLine(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', lines:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCubicLine': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCubicLine': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkCylinder(vtkImplicitFunction):
    axis:'getset_descriptor'
    center:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetAxis(self) -> Tuple[float, float, float]: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCylinder': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCylinder': ...
    @overload
    def SetAxis(self, ax:float, ay:float, az:float) -> None: ...
    @overload
    def SetAxis(self, a:MutableSequence[float]) -> None: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkDataAssembly(vtkmodules.vtkCommonCore.vtkObject):
    class TraversalOrder(int): ...
    BreadthFirst:'TraversalOrder'
    DepthFirst:'TraversalOrder'
    root_node:'getset_descriptor'
    root_node_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddDataSetIndex(self, id:int, dataset_index:int) -> bool: ...
    def AddDataSetIndexRange(self, id:int, index_start:int, count:int) -> bool: ...
    def AddDataSetIndices(self, id:int, dataset_indices:Sequence[int]) -> bool: ...
    def AddNode(self, name:str, parent:int=0) -> int: ...
    def AddNodes(self, names:Sequence[str], parent:int=0) -> Tuple[int, int]: ...
    def AddSubtree(self, parent:int, other:'vtkDataAssembly', otherParent:int=0) -> int: ...
    def DeepCopy(self, other:'vtkDataAssembly') -> None: ...
    def FindFirstNodeWithName(self, name:str, traversal_order:int=...) -> int: ...
    def FindNodesWithName(self, name:str, sort_order:int=...) -> Tuple[int, int]: ...
    def GetAttribute(self, id:int, name:str, value:int) -> bool: ...
    @overload
    def GetAttributeOrDefault(self, id:int, name:str, default_value:str) -> str: ...
    @overload
    def GetAttributeOrDefault(self, id:int, name:str, default_value:int) -> int: ...
    def GetChild(self, parent:int, index:int) -> int: ...
    def GetChildIndex(self, parent:int, child:int) -> int: ...
    def GetChildNodes(self, parent:int, traverse_subtree:bool=True, traversal_order:int=...) -> Tuple[int, int]: ...
    @overload
    def GetDataSetIndices(self, id:int, traverse_subtree:bool=True, traversal_order:int=...) -> Tuple[int, int]: ...
    @overload
    def GetDataSetIndices(self, ids:Sequence[int], traverse_subtree:bool=True, traversal_order:int=...) -> Tuple[int, int]: ...
    def GetFirstNodeByPath(self, path:str) -> int: ...
    def GetNodeName(self, id:int) -> str: ...
    def GetNodePath(self, id:int) -> str: ...
    def GetNumberOfChildren(self, parent:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParent(self, id:int) -> int: ...
    @staticmethod
    def GetRootNode() -> int: ...
    def GetRootNodeName(self) -> str: ...
    def HasAttribute(self, id:int, name:str) -> bool: ...
    def Initialize(self) -> None: ...
    def InitializeFromXML(self, xmlcontents:str) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsNodeNameReserved(name:str) -> bool: ...
    @staticmethod
    def IsNodeNameValid(name:str) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeValidNodeName(name:str) -> str: ...
    def NewInstance(self) -> 'vtkDataAssembly': ...
    def RemoveAllDataSetIndices(self, id:int, traverse_subtree:bool=True) -> bool: ...
    def RemoveDataSetIndex(self, id:int, dataset_index:int) -> bool: ...
    def RemoveNode(self, id:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataAssembly': ...
    def SelectNodes(self, path_queries:Sequence[str], traversal_order:int=...) -> Tuple[int, int]: ...
    def SerializeToXML(self, indent:'vtkIndent') -> str: ...
    @overload
    def SetAttribute(self, id:int, name:str, value:str) -> None: ...
    @overload
    def SetAttribute(self, id:int, name:str, value:int) -> None: ...
    def SetNodeName(self, id:int, name:str) -> None: ...
    def SetRootNodeName(self, name:str) -> None: ...
    def SubsetCopy(self, other:'vtkDataAssembly', selected_branches:Sequence[int]) -> None: ...
    @overload
    def Visit(self, visitor:'vtkDataAssemblyVisitor', traversal_order:int=...) -> None: ...
    @overload
    def Visit(self, id:int, visitor:'vtkDataAssemblyVisitor', traversal_order:int=...) -> None: ...

class vtkDataAssemblyUtilities(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def GenerateCompositeDataSetFromHierarchy(input:'vtkPartitionedDataSetCollection', hierarchy:'vtkDataAssembly') -> 'vtkCompositeDataSet': ...
    @staticmethod
    def GenerateHierarchy(input:'vtkCompositeDataSet', hierarchy:'vtkDataAssembly', output:'vtkPartitionedDataSetCollection'=...) -> bool: ...
    @staticmethod
    def GetDataAssembly(name:str, cd:'vtkCompositeDataSet') -> 'vtkDataAssembly': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetSelectedCompositeIds(selectors:Sequence[str], hierarchyOrAssembly:'vtkDataAssembly', data:'vtkPartitionedDataSetCollection'=..., leaf_nodes_only:bool=False) -> Tuple[int, int]: ...
    @staticmethod
    def GetSelectorForCompositeId(id:int, hierarchy:'vtkDataAssembly') -> str: ...
    @staticmethod
    def GetSelectorsCompositeIdsForCompositeIds(ids:Sequence[int], hierarchy:'vtkDataAssembly') -> Tuple[int, int]: ...
    @overload
    @staticmethod
    def GetSelectorsForCompositeIds(ids:Sequence[int], hierarchy:'vtkDataAssembly') -> Tuple[str, str]: ...
    @overload
    @staticmethod
    def GetSelectorsForCompositeIds(ids:Sequence[int], hierarchy:'vtkDataAssembly', assembly:'vtkDataAssembly') -> Tuple[str, str]: ...
    @staticmethod
    def HierarchyName() -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataAssemblyUtilities': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataAssemblyUtilities': ...

class vtkDataAssemblyVisitor(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataAssemblyVisitor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataAssemblyVisitor': ...

class vtkDataObjectCollection(vtkmodules.vtkCommonCore.vtkCollection):
    next_item:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddItem(self, ds:'vtkDataObject') -> None: ...
    def GetItem(self, i:int) -> 'vtkDataObject': ...
    def GetNextItem(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectCollection': ...

class vtkDataObjectTree(vtkCompositeDataSet):
    actual_memory_size:'getset_descriptor'
    data_object_type:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_children:'getset_descriptor'
    number_of_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CompositeShallowCopy(self, src:'vtkCompositeDataSet') -> None: ...
    def CopyStructure(self, input:'vtkCompositeDataSet') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetChild(self, index:int) -> 'vtkDataObject': ...
    def GetChildMetaData(self, index:int) -> 'vtkInformation': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkDataObjectTree': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkDataObjectTree': ...
    def GetDataObjectType(self) -> int: ...
    @overload
    def GetDataSet(self, iter:'vtkCompositeDataIterator') -> 'vtkDataObject': ...
    @overload
    def GetDataSet(self, flatIndex:int) -> 'vtkDataObject': ...
    def GetMetaData(self, iter:'vtkCompositeDataIterator') -> 'vtkInformation': ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def HasChildMetaData(self, index:int) -> int: ...
    def HasMetaData(self, iter:'vtkCompositeDataIterator') -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectTree': ...
    def NewIterator(self) -> 'vtkCompositeDataIterator': ...
    def NewTreeIterator(self) -> 'vtkDataObjectTreeIterator': ...
    def RecursiveShallowCopy(self, src:'vtkDataObject') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectTree': ...
    def SetDataSet(self, iter:'vtkCompositeDataIterator', dataObj:'vtkDataObject') -> None: ...
    def SetDataSetFrom(self, iter:'vtkDataObjectTreeIterator', dataObj:'vtkDataObject') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...

class vtkDataObjectTreeIndex(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkDataObjectTreeIndex') -> None: ...

class vtkDataObjectTreeInternals(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkDataObjectTreeInternals') -> None: ...

class vtkDataObjectTreeItem(object):
    @overload
    def __init__(self, dobj:'vtkDataObject'=..., info:'vtkInformation'=...) -> None: ...
    @overload
    def __init__(self, __a:'vtkDataObjectTreeItem') -> None: ...

class vtkDataObjectTreeIterator(vtkCompositeDataIterator):
    current_data_object:'getset_descriptor'
    current_flat_index:'getset_descriptor'
    current_meta_data:'getset_descriptor'
    traverse_sub_tree:'getset_descriptor'
    visit_only_leaves:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCurrentDataObject(self) -> 'vtkDataObject': ...
    def GetCurrentFlatIndex(self) -> int: ...
    def GetCurrentMetaData(self) -> 'vtkInformation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTraverseSubTree(self) -> int: ...
    def GetVisitOnlyLeaves(self) -> int: ...
    def GoToFirstItem(self) -> None: ...
    def GoToNextItem(self) -> None: ...
    def HasCurrentMetaData(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectTreeIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectTreeIterator': ...
    def SetTraverseSubTree(self, _arg:int) -> None: ...
    def SetVisitOnlyLeaves(self, _arg:int) -> None: ...
    def TraverseSubTreeOff(self) -> None: ...
    def TraverseSubTreeOn(self) -> None: ...
    def VisitOnlyLeavesOff(self) -> None: ...
    def VisitOnlyLeavesOn(self) -> None: ...

class vtkDataObjectTypes(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def GetClassNameFromTypeId(typeId:int) -> str: ...
    @staticmethod
    def GetCommonBaseTypeId(typeA:int, typeB:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetTypeIdFromClassName(classname:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    @staticmethod
    def NewDataObject(classname:str) -> 'vtkDataObject': ...
    @overload
    @staticmethod
    def NewDataObject(typeId:int) -> 'vtkDataObject': ...
    def NewInstance(self) -> 'vtkDataObjectTypes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectTypes': ...
    @staticmethod
    def TypeIdIsA(typeId:int, targetTypeId:int) -> bool: ...

class vtkDataSet(vtkDataObject):
    class FieldDataType(int): ...
    CELL_DATA_FIELD:'FieldDataType'
    DATA_OBJECT_FIELD:'FieldDataType'
    POINT_DATA_FIELD:'FieldDataType'
    actual_memory_size:'getset_descriptor'
    bounds:'getset_descriptor'
    cell_data:'getset_descriptor'
    cell_ghost_array:'getset_descriptor'
    center:'getset_descriptor'
    data_object_type:'getset_descriptor'
    length:'getset_descriptor'
    length2:'getset_descriptor'
    m_time:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    max_spatial_dimension:'getset_descriptor'
    mesh_m_time:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_points:'getset_descriptor'
    point_data:'getset_descriptor'
    point_ghost_array:'getset_descriptor'
    points:'getset_descriptor'
    scalar_range:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllocateCellGhostArray(self) -> 'vtkUnsignedCharArray': ...
    def AllocatePointGhostArray(self) -> 'vtkUnsignedCharArray': ...
    def CheckAttributes(self) -> int: ...
    def ComputeBounds(self) -> None: ...
    def CopyAttributes(self, ds:'vtkDataSet') -> None: ...
    def CopyStructure(self, ds:'vtkDataSet') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    def FindAndGetCell(self, x:MutableSequence[float], cell:'vtkCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> 'vtkCell': ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', gencell:'vtkGenericCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindPoint(self, x:float, y:float, z:float) -> int: ...
    @overload
    def FindPoint(self, x:MutableSequence[float]) -> int: ...
    @overload
    def GenerateGhostArray(self, zeroExt:MutableSequence[int]) -> None: ...
    @overload
    def GenerateGhostArray(self, zeroExt:MutableSequence[int], cellOnly:bool) -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetAttributesAsFieldData(self, type:int) -> 'vtkFieldData': ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetCell(self, cellId:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, cellId:int, cell:'vtkGenericCell') -> None: ...
    def GetCellBounds(self, cellId:int, bounds:MutableSequence[float]) -> None: ...
    def GetCellData(self) -> 'vtkCellData': ...
    def GetCellGhostArray(self) -> 'vtkUnsignedCharArray': ...
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList') -> None: ...
    def GetCellNumberOfFaces(self, cellId:int, cellType:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def GetCellPoints(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetCellType(self, cellId:int) -> int: ...
    def GetCellTypes(self, types:'vtkCellTypes') -> None: ...
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, center:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkDataSet': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkDataSet': ...
    def GetDataObjectType(self) -> int: ...
    def GetGhostArray(self, type:int) -> 'vtkUnsignedCharArray': ...
    def GetLength(self) -> float: ...
    def GetLength2(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    def GetMaxSpatialDimension(self) -> int: ...
    def GetMeshMTime(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfElements(self, type:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    def GetPoint(self, ptId:int) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint(self, id:int, x:MutableSequence[float]) -> None: ...
    def GetPointCells(self, ptId:int, cellIds:'vtkIdList') -> None: ...
    def GetPointData(self) -> 'vtkPointData': ...
    def GetPointGhostArray(self) -> 'vtkUnsignedCharArray': ...
    def GetPoints(self) -> 'vtkPoints': ...
    @overload
    def GetScalarRange(self, range:MutableSequence[float]) -> None: ...
    @overload
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def HasAnyBlankCells(self) -> bool: ...
    def HasAnyBlankPoints(self) -> bool: ...
    def HasAnyGhostCells(self) -> bool: ...
    def HasAnyGhostPoints(self) -> bool: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewCellIterator(self) -> 'vtkCellIterator': ...
    def NewInstance(self) -> 'vtkDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSet': ...
    def SetCellOrderAndRationalWeights(self, cellId:int, cell:'vtkGenericCell') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    def Squeeze(self) -> None: ...
    def SupportsGhostArray(self, type:int) -> bool: ...
    def UpdateCellGhostArrayCache(self) -> None: ...
    def UpdatePointGhostArrayCache(self) -> None: ...

class vtkDataSetAttributesFieldList(object):
    number_of_arrays:'getset_descriptor'
    def __init__(self, number_of_inputs:int=0) -> None: ...
    def BuildPrototype(self, protoDSA:'vtkDataSetAttributes', ordering:'vtkDataSetAttributes'=...) -> None: ...
    def CopyAllocate(self, output:'vtkDataSetAttributes', ctype:int, sz:int, ext:int) -> None: ...
    @overload
    def CopyData(self, inputIndex:int, input:'vtkDataSetAttributes', fromId:int, output:'vtkDataSetAttributes', toId:int) -> None: ...
    @overload
    def CopyData(self, inputIndex:int, input:'vtkDataSetAttributes', inputStart:int, numValues:int, output:'vtkDataSetAttributes', outStart:int) -> None: ...
    def GetNumberOfArrays(self) -> int: ...
    def InitializeFieldList(self, dsa:'vtkDataSetAttributes') -> None: ...
    def InterpolatePoint(self, inputIndex:int, input:'vtkDataSetAttributes', inputIds:'vtkIdList', weights:MutableSequence[float], output:'vtkDataSetAttributes', toId:int) -> None: ...
    def IntersectFieldList(self, dsa:'vtkDataSetAttributes') -> None: ...
    def Reset(self) -> None: ...
    def UnionFieldList(self, dsa:'vtkDataSetAttributes') -> None: ...

class vtkDataSetCellIterator(vtkCellIterator):
    cell_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetCellIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetCellIterator': ...

class vtkDataSetCollection(vtkmodules.vtkCommonCore.vtkCollection):
    next_data_set:'getset_descriptor'
    next_item:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddItem(self, ds:'vtkDataSet') -> None: ...
    def GetDataSet(self, i:int) -> 'vtkDataSet': ...
    def GetItem(self, i:int) -> 'vtkDataSet': ...
    def GetNextDataSet(self) -> 'vtkDataSet': ...
    def GetNextItem(self) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetCollection': ...

class vtkGraph(vtkDataObject):
    actual_memory_size:'getset_descriptor'
    data_object_type:'getset_descriptor'
    distributed_graph_helper:'getset_descriptor'
    edge_data:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_edges:'getset_descriptor'
    number_of_vertices:'getset_descriptor'
    points:'getset_descriptor'
    vertex_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddEdgePoint(self, e:int, x:Sequence[float]) -> None: ...
    @overload
    def AddEdgePoint(self, e:int, x:float, y:float, z:float) -> None: ...
    def CheckedDeepCopy(self, g:'vtkGraph') -> bool: ...
    def CheckedShallowCopy(self, g:'vtkGraph') -> bool: ...
    def ClearEdgePoints(self, e:int) -> None: ...
    def ComputeBounds(self) -> None: ...
    def CopyStructure(self, g:'vtkGraph') -> None: ...
    def DeepCopy(self, obj:'vtkDataObject') -> None: ...
    def DeepCopyEdgePoints(self, g:'vtkGraph') -> None: ...
    def Dump(self) -> None: ...
    def FindVertex(self, pedigreeID:'vtkVariant') -> int: ...
    def GetActualMemorySize(self) -> int: ...
    def GetAdjacentVertices(self, v:int, it:'vtkAdjacentVertexIterator') -> None: ...
    def GetAttributesAsFieldData(self, type:int) -> 'vtkFieldData': ...
    @overload
    def GetBounds(self) -> Pointer: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkGraph': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkGraph': ...
    def GetDataObjectType(self) -> int: ...
    def GetDegree(self, v:int) -> int: ...
    def GetDistributedGraphHelper(self) -> 'vtkDistributedGraphHelper': ...
    def GetEdgeData(self) -> 'vtkDataSetAttributes': ...
    def GetEdgeId(self, a:int, b:int) -> int: ...
    def GetEdgePoint(self, e:int, i:int) -> Tuple[float, float, float]: ...
    def GetEdgePoints(self, e:int, npts:int, pts:MutableSequence[float]) -> None: ...
    def GetEdges(self, it:'vtkEdgeListIterator') -> None: ...
    def GetGraphInternals(self, modifying:bool) -> 'vtkGraphInternals': ...
    def GetInDegree(self, v:int) -> int: ...
    @overload
    def GetInEdge(self, v:int, index:int) -> 'vtkInEdgeType': ...
    @overload
    def GetInEdge(self, v:int, index:int, e:'vtkGraphEdge') -> None: ...
    def GetInEdges(self, v:int, it:'vtkInEdgeIterator') -> None: ...
    def GetInducedEdges(self, verts:'vtkIdTypeArray', edges:'vtkIdTypeArray') -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfEdgePoints(self, e:int) -> int: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfElements(self, type:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfVertices(self) -> int: ...
    def GetOutDegree(self, v:int) -> int: ...
    @overload
    def GetOutEdge(self, v:int, index:int) -> 'vtkOutEdgeType': ...
    @overload
    def GetOutEdge(self, v:int, index:int, e:'vtkGraphEdge') -> None: ...
    def GetOutEdges(self, v:int, it:'vtkOutEdgeIterator') -> None: ...
    @overload
    def GetPoint(self, ptId:int) -> Pointer: ...
    @overload
    def GetPoint(self, ptId:int, x:MutableSequence[float]) -> None: ...
    def GetPoints(self) -> 'vtkPoints': ...
    def GetSourceVertex(self, e:int) -> int: ...
    def GetTargetVertex(self, e:int) -> int: ...
    def GetVertexData(self) -> 'vtkDataSetAttributes': ...
    def GetVertices(self, it:'vtkVertexListIterator') -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsSameStructure(self, other:'vtkGraph') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraph': ...
    def ReorderOutVertices(self, v:int, vertices:'vtkIdTypeArray') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraph': ...
    def SetDistributedGraphHelper(self, helper:'vtkDistributedGraphHelper') -> None: ...
    @overload
    def SetEdgePoint(self, e:int, i:int, x:Sequence[float]) -> None: ...
    @overload
    def SetEdgePoint(self, e:int, i:int, x:float, y:float, z:float) -> None: ...
    def SetEdgePoints(self, e:int, npts:int, pts:Sequence[float]) -> None: ...
    def SetPoints(self, points:'vtkPoints') -> None: ...
    def ShallowCopy(self, obj:'vtkDataObject') -> None: ...
    def ShallowCopyEdgePoints(self, g:'vtkGraph') -> None: ...
    def Squeeze(self) -> None: ...
    def ToDirectedGraph(self, g:'vtkDirectedGraph') -> bool: ...
    def ToUndirectedGraph(self, g:'vtkUndirectedGraph') -> bool: ...

class vtkDirectedGraph(vtkGraph):
    data_object_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkDirectedGraph': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkDirectedGraph': ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsStructureValid(self, g:'vtkGraph') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDirectedGraph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDirectedGraph': ...

class vtkDirectedAcyclicGraph(vtkDirectedGraph):
    data_object_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkDirectedAcyclicGraph': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkDirectedAcyclicGraph': ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDirectedAcyclicGraph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDirectedAcyclicGraph': ...

class vtkDistributedGraphHelper(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def Clone(self) -> 'vtkDistributedGraphHelper': ...
    @staticmethod
    def DISTRIBUTEDEDGEIDS() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def DISTRIBUTEDVERTEXIDS() -> 'vtkInformationIntegerKey': ...
    def GetEdgeIndex(self, e_id:int) -> int: ...
    def GetEdgeOwner(self, e_id:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVertexIndex(self, v:int) -> int: ...
    def GetVertexOwner(self, v:int) -> int: ...
    def GetVertexOwnerByPedigreeId(self, pedigreeId:'vtkVariant') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeDistributedId(self, owner:int, local:int) -> int: ...
    def NewInstance(self) -> 'vtkDistributedGraphHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDistributedGraphHelper': ...
    def Synchronize(self) -> None: ...

class vtkEdgeBase(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, id:int) -> None: ...
    @overload
    def __init__(self, __a:'vtkEdgeBase') -> None: ...

class vtkEdgeListIterator(vtkmodules.vtkCommonCore.vtkObject):
    graph:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetGraph(self) -> 'vtkGraph': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasNext(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEdgeListIterator': ...
    def Next(self) -> 'vtkEdgeType': ...
    def NextGraphEdge(self) -> 'vtkGraphEdge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEdgeListIterator': ...
    def SetGraph(self, graph:'vtkGraph') -> None: ...

class vtkEdgeTable(vtkmodules.vtkCommonCore.vtkObject):
    number_of_edges:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNextEdge(self, p1:int, p2:int) -> int: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitEdgeInsertion(self, numPoints:int, storeAttributes:int=0) -> int: ...
    def InitPointInsertion(self, newPts:'vtkPoints', estSize:int) -> int: ...
    def InitTraversal(self) -> None: ...
    def Initialize(self) -> None: ...
    @overload
    def InsertEdge(self, p1:int, p2:int) -> int: ...
    @overload
    def InsertEdge(self, p1:int, p2:int, attributeId:int) -> None: ...
    @overload
    def InsertEdge(self, p1:int, p2:int, ptr:Pointer) -> None: ...
    def InsertUniquePoint(self, p1:int, p2:int, x:MutableSequence[float], ptId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsEdge(self, p1:int, p2:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEdgeTable': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEdgeTable': ...

class vtkEdgeType(vtkEdgeBase):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, s:int, t:int, id:int) -> None: ...
    @overload
    def __init__(self, __a:'vtkEdgeType') -> None: ...

class vtkEmptyCell(vtkCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', pts:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts1:'vtkCellArray', lines:'vtkCellArray', verts2:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEmptyCell': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEmptyCell': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkPointSet(vtkDataSet):
    actual_memory_size:'getset_descriptor'
    cell_locator:'getset_descriptor'
    data_object_type:'getset_descriptor'
    editable:'getset_descriptor'
    m_time:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_points:'getset_descriptor'
    point_locator:'getset_descriptor'
    points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildCellLocator(self) -> None: ...
    def BuildLocator(self) -> None: ...
    def BuildPointLocator(self) -> None: ...
    def ComputeBounds(self) -> None: ...
    def CopyStructure(self, pd:'vtkDataSet') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    def EditableOff(self) -> None: ...
    def EditableOn(self) -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkPointSet': ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', gencell:'vtkGenericCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindPoint(self, x:MutableSequence[float]) -> int: ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetCell(self, __a:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, __a:int, cell:'vtkGenericCell') -> None: ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    def GetCellLocator(self) -> 'vtkAbstractCellLocator': ...
    @overload
    def GetCellPoints(self, __a:int, idList:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    def GetCellSize(self, __a:int) -> int: ...
    def GetCellType(self, __a:int) -> int: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkPointSet': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkPointSet': ...
    def GetDataObjectType(self) -> int: ...
    def GetEditable(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    def GetPoint(self, ptId:int, x:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint(self, ptId:int) -> Tuple[float, float, float]: ...
    def GetPointCells(self, __a:int, idList:'vtkIdList') -> None: ...
    def GetPointLocator(self) -> 'vtkAbstractPointLocator': ...
    def GetPoints(self) -> 'vtkPoints': ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewCellIterator(self) -> 'vtkCellIterator': ...
    def NewInstance(self) -> 'vtkPointSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointSet': ...
    def SetCellLocator(self, __a:'vtkAbstractCellLocator') -> None: ...
    def SetEditable(self, _arg:bool) -> None: ...
    def SetPointLocator(self, __a:'vtkAbstractPointLocator') -> None: ...
    def SetPoints(self, __a:'vtkPoints') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    def Squeeze(self) -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkExplicitStructuredGrid(vtkPointSet):
    actual_memory_size:'getset_descriptor'
    cells:'getset_descriptor'
    data_dimension:'getset_descriptor'
    data_object_type:'getset_descriptor'
    dimensions:'getset_descriptor'
    extent:'getset_descriptor'
    extent_type:'getset_descriptor'
    faces_connectivity_flags_array_name:'getset_descriptor'
    links:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    max_spatial_dimension:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BlankCell(self, cellId:int) -> None: ...
    def BuildLinks(self) -> None: ...
    def CheckAndReorderFaces(self) -> None: ...
    def ComputeCellId(self, i:int, j:int, k:int, adjustForExtent:bool=True) -> int: ...
    def ComputeCellStructuredCoords(self, cellId:int, i:int, j:int, k:int, adjustForExtent:bool=True) -> None: ...
    def ComputeFacesConnectivityFlagsArray(self) -> None: ...
    def CopyStructure(self, ds:'vtkDataSet') -> None: ...
    @overload
    def Crop(self, updateExtent:Sequence[int]) -> None: ...
    @overload
    def Crop(self, input:'vtkExplicitStructuredGrid', updateExtent:Sequence[int], generateOriginalCellIds:bool) -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @overload
    def GenerateGhostArray(self, zeroExt:MutableSequence[int], cellOnly:bool) -> None: ...
    @overload
    def GenerateGhostArray(self, zeroExt:MutableSequence[int]) -> None: ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetCell(self, cellId:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, cellId:int, cell:'vtkGenericCell') -> None: ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    def GetCellBounds(self, cellId:int, bounds:MutableSequence[float]) -> None: ...
    def GetCellDims(self, cellDims:MutableSequence[int]) -> None: ...
    @overload
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList') -> None: ...
    @overload
    def GetCellNeighbors(self, cellId:int, neighbors:MutableSequence[int], wholeExtent:MutableSequence[int]=...) -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int) -> Pointer: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:MutableSequence[int]) -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetCellType(self, cellId:int) -> int: ...
    def GetCells(self) -> 'vtkCellArray': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkExplicitStructuredGrid': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkExplicitStructuredGrid': ...
    def GetDataDimension(self) -> int: ...
    def GetDataObjectType(self) -> int: ...
    def GetDimensions(self, dim:MutableSequence[int]) -> None: ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetExtentType(self) -> int: ...
    def GetFacesConnectivityFlagsArrayName(self) -> str: ...
    def GetLinks(self) -> 'vtkAbstractCellLinks': ...
    def GetMaxCellSize(self) -> int: ...
    def GetMaxSpatialDimension(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointCells(self, ptId:int, cellIds:'vtkIdList') -> None: ...
    def HasAnyBlankCells(self) -> bool: ...
    def HasAnyGhostCells(self) -> bool: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCellGhost(self, cellId:int) -> int: ...
    def IsCellVisible(self, cellId:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExplicitStructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExplicitStructuredGrid': ...
    def SetCells(self, _arg:'vtkCellArray') -> None: ...
    @overload
    def SetDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetDimensions(self, dim:MutableSequence[int]) -> None: ...
    @overload
    def SetExtent(self, x0:int, x1:int, y0:int, y1:int, z0:int, z1:int) -> None: ...
    @overload
    def SetExtent(self, extent:MutableSequence[int]) -> None: ...
    def SetFacesConnectivityFlagsArrayName(self, _arg:str) -> None: ...
    def SetLinks(self, _arg:'vtkAbstractCellLinks') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    def UnBlankCell(self, cellId:int) -> None: ...

class vtkExtractStructuredGridHelper(vtkmodules.vtkCommonCore.vtkObject):
    output_whole_extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeBeginAndEnd(self, inExt:MutableSequence[int], voi:MutableSequence[int], begin:MutableSequence[int], end:MutableSequence[int]) -> None: ...
    def CopyCellData(self, inExt:MutableSequence[int], outExt:MutableSequence[int], cd:'vtkCellData', outCD:'vtkCellData') -> None: ...
    def CopyPointsAndPointData(self, inExt:MutableSequence[int], outExt:MutableSequence[int], pd:'vtkPointData', inpnts:'vtkPoints', outPD:'vtkPointData', outpnts:'vtkPoints') -> None: ...
    def GetMappedExtentValue(self, dim:int, outExtVal:int) -> int: ...
    def GetMappedExtentValueFromIndex(self, dim:int, outIdx:int) -> int: ...
    def GetMappedIndex(self, dim:int, outIdx:int) -> int: ...
    def GetMappedIndexFromExtentValue(self, dim:int, outExtVal:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    @staticmethod
    def GetPartitionedOutputExtent(globalVOI:Sequence[int], partitionedVOI:Sequence[int], outputWholeExtent:Sequence[int], sampleRate:Sequence[int], includeBoundary:bool, partitionedOutputExtent:MutableSequence[int]) -> None: ...
    @staticmethod
    def GetPartitionedVOI(globalVOI:Sequence[int], partitionedExtent:Sequence[int], sampleRate:Sequence[int], includeBoundary:bool, partitionedVOI:MutableSequence[int]) -> None: ...
    def GetSize(self, dim:int) -> int: ...
    def Initialize(self, voi:MutableSequence[int], wholeExt:MutableSequence[int], sampleRate:MutableSequence[int], includeBoundary:bool) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsValid(self) -> bool: ...
    def NewInstance(self) -> 'vtkExtractStructuredGridHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractStructuredGridHelper': ...

class vtkGenericAdaptorCell(vtkmodules.vtkCommonCore.vtkObject):
    dimension:'getset_descriptor'
    geometry_order:'getset_descriptor'
    id:'getset_descriptor'
    length2:'getset_descriptor'
    number_of_dof_nodes:'getset_descriptor'
    number_of_points:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clip(self, value:float, f:'vtkImplicitFunction', attributes:'vtkGenericAttributeCollection', tess:'vtkGenericCellTessellator', insideOut:int, locator:'vtkIncrementalPointLocator', connectivity:'vtkCellArray', outPd:'vtkPointData', outCd:'vtkCellData', internalPd:'vtkPointData', secondaryPd:'vtkPointData', secondaryCd:'vtkCellData') -> None: ...
    def Contour(self, values:'vtkContourValues', f:'vtkImplicitFunction', attributes:'vtkGenericAttributeCollection', tess:'vtkGenericCellTessellator', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', outPd:'vtkPointData', outCd:'vtkCellData', internalPd:'vtkPointData', secondaryPd:'vtkPointData', secondaryCd:'vtkCellData') -> None: ...
    def CountEdgeNeighbors(self, sharing:MutableSequence[int]) -> None: ...
    def CountNeighbors(self, boundary:'vtkGenericAdaptorCell') -> int: ...
    def Derivatives(self, subId:int, pcoords:MutableSequence[float], attribute:'vtkGenericAttribute', derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:MutableSequence[float], x:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float) -> int: ...
    def GetAttributeOrder(self, a:'vtkGenericAttribute') -> int: ...
    def GetBoundaryIterator(self, boundaries:'vtkGenericCellIterator', dim:int=-1) -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Pointer: ...
    def GetDimension(self) -> int: ...
    def GetEdgeArray(self, edgeId:int) -> Pointer: ...
    def GetFaceArray(self, faceId:int) -> Pointer: ...
    def GetGeometryOrder(self) -> int: ...
    def GetHighestOrderAttribute(self, ac:'vtkGenericAttributeCollection') -> int: ...
    def GetId(self) -> int: ...
    def GetLength2(self) -> float: ...
    def GetNeighbors(self, boundary:'vtkGenericAdaptorCell', neighbors:'vtkGenericCellIterator') -> None: ...
    def GetNumberOfBoundaries(self, dim:int=-1) -> int: ...
    def GetNumberOfDOFNodes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetNumberOfVerticesOnFace(self, faceId:int) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Pointer: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def GetPointIds(self, id:MutableSequence[int]) -> None: ...
    def GetPointIterator(self, it:'vtkGenericPointIterator') -> None: ...
    def GetType(self) -> int: ...
    @overload
    def InterpolateTuple(self, a:'vtkGenericAttribute', pcoords:MutableSequence[float], val:MutableSequence[float]) -> None: ...
    @overload
    def InterpolateTuple(self, c:'vtkGenericAttributeCollection', pcoords:MutableSequence[float], val:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:MutableSequence[float], p2:MutableSequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsAttributeLinear(self, a:'vtkGenericAttribute') -> int: ...
    def IsFaceOnBoundary(self, faceId:int) -> int: ...
    def IsGeometryLinear(self) -> int: ...
    def IsInDataSet(self) -> int: ...
    def IsOnBoundary(self) -> int: ...
    def IsPrimary(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewCellIterator(self) -> 'vtkGenericCellIterator': ...
    def NewInstance(self) -> 'vtkGenericAdaptorCell': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericAdaptorCell': ...
    def Tessellate(self, attributes:'vtkGenericAttributeCollection', tess:'vtkGenericCellTessellator', points:'vtkPoints', locator:'vtkIncrementalPointLocator', cellArray:'vtkCellArray', internalPd:'vtkPointData', pd:'vtkPointData', cd:'vtkCellData', types:'vtkUnsignedCharArray') -> None: ...
    def TriangulateFace(self, attributes:'vtkGenericAttributeCollection', tess:'vtkGenericCellTessellator', index:int, points:'vtkPoints', locator:'vtkIncrementalPointLocator', cellArray:'vtkCellArray', internalPd:'vtkPointData', pd:'vtkPointData', cd:'vtkCellData') -> None: ...

class vtkGenericAttribute(vtkmodules.vtkCommonCore.vtkObject):
    actual_memory_size:'getset_descriptor'
    centering:'getset_descriptor'
    component_type:'getset_descriptor'
    max_norm:'getset_descriptor'
    name:'getset_descriptor'
    number_of_components:'getset_descriptor'
    size:'getset_descriptor'
    type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DeepCopy(self, other:'vtkGenericAttribute') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetCentering(self) -> int: ...
    @overload
    def GetComponent(self, i:int, c:'vtkGenericCellIterator', values:MutableSequence[float]) -> None: ...
    @overload
    def GetComponent(self, i:int, p:'vtkGenericPointIterator') -> float: ...
    def GetComponentType(self) -> int: ...
    def GetMaxNorm(self) -> float: ...
    def GetName(self) -> str: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetRange(self, component:int=0) -> Pointer: ...
    @overload
    def GetRange(self, component:int, range:MutableSequence[float]) -> None: ...
    def GetSize(self) -> int: ...
    @overload
    def GetTuple(self, c:'vtkGenericAdaptorCell') -> Pointer: ...
    @overload
    def GetTuple(self, c:'vtkGenericAdaptorCell', tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuple(self, c:'vtkGenericCellIterator') -> Pointer: ...
    @overload
    def GetTuple(self, c:'vtkGenericCellIterator', tuple:MutableSequence[float]) -> None: ...
    @overload
    def GetTuple(self, p:'vtkGenericPointIterator') -> Pointer: ...
    @overload
    def GetTuple(self, p:'vtkGenericPointIterator', tuple:MutableSequence[float]) -> None: ...
    def GetType(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericAttribute': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericAttribute': ...
    def ShallowCopy(self, other:'vtkGenericAttribute') -> None: ...

class vtkGenericAttributeCollection(vtkmodules.vtkCommonCore.vtkObject):
    active_attribute:'getset_descriptor'
    active_component:'getset_descriptor'
    actual_memory_size:'getset_descriptor'
    attributes_to_interpolate:'getset_descriptor'
    m_time:'getset_descriptor'
    max_number_of_components:'getset_descriptor'
    number_of_attributes_to_interpolate:'getset_descriptor'
    number_of_components:'getset_descriptor'
    number_of_point_centered_components:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DeepCopy(self, other:'vtkGenericAttributeCollection') -> None: ...
    def FindAttribute(self, name:str) -> int: ...
    def GetActiveAttribute(self) -> int: ...
    def GetActiveComponent(self) -> int: ...
    def GetActualMemorySize(self) -> int: ...
    def GetAttribute(self, i:int) -> 'vtkGenericAttribute': ...
    def GetAttributeIndex(self, i:int) -> int: ...
    def GetAttributesToInterpolate(self) -> Tuple[int, int]: ...
    def GetMTime(self) -> int: ...
    def GetMaxNumberOfComponents(self) -> int: ...
    def GetNumberOfAttributes(self) -> int: ...
    def GetNumberOfAttributesToInterpolate(self) -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointCenteredComponents(self) -> int: ...
    def HasAttribute(self, size:int, attributes:MutableSequence[int], attribute:int) -> int: ...
    def InsertAttribute(self, i:int, a:'vtkGenericAttribute') -> None: ...
    def InsertNextAttribute(self, a:'vtkGenericAttribute') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsEmpty(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericAttributeCollection': ...
    def RemoveAttribute(self, i:int) -> None: ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericAttributeCollection': ...
    def SetActiveAttribute(self, attribute:int, component:int=0) -> None: ...
    def SetAttributesToInterpolate(self, size:int, attributes:MutableSequence[int]) -> None: ...
    def SetAttributesToInterpolateToAll(self) -> None: ...
    def ShallowCopy(self, other:'vtkGenericAttributeCollection') -> None: ...

class vtkGenericCell(vtkCell):
    cell_dimension:'getset_descriptor'
    cell_faces:'getset_descriptor'
    cell_type:'getset_descriptor'
    faces:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    point_ids:'getset_descriptor'
    points:'getset_descriptor'
    representative_cell:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', connectivity:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def DeepCopy(self, c:'vtkCell') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    @overload
    def GetCellFaces(self) -> 'vtkCellArray': ...
    @overload
    def GetCellFaces(self, faces:'vtkCellArray') -> None: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFaces(self) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetRepresentativeCell(self) -> 'vtkCell': ...
    def Initialize(self) -> None: ...
    @staticmethod
    def InstantiateCell(cellType:int) -> 'vtkCell': ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsLinear(self) -> int: ...
    def IsPrimaryCell(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericCell': ...
    def RequiresExplicitFaceRepresentation(self) -> int: ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericCell': ...
    def SetCellFaces(self, faces:'vtkCellArray') -> int: ...
    def SetCellType(self, cellType:int) -> None: ...
    def SetCellTypeToBezierCurve(self) -> None: ...
    def SetCellTypeToBezierHexahedron(self) -> None: ...
    def SetCellTypeToBezierQuadrilateral(self) -> None: ...
    def SetCellTypeToBezierTetra(self) -> None: ...
    def SetCellTypeToBezierTriangle(self) -> None: ...
    def SetCellTypeToBezierWedge(self) -> None: ...
    def SetCellTypeToBiQuadraticQuad(self) -> None: ...
    def SetCellTypeToBiQuadraticQuadraticHexahedron(self) -> None: ...
    def SetCellTypeToBiQuadraticQuadraticWedge(self) -> None: ...
    def SetCellTypeToBiQuadraticTriangle(self) -> None: ...
    def SetCellTypeToConvexPointSet(self) -> None: ...
    def SetCellTypeToCubicLine(self) -> None: ...
    def SetCellTypeToEmptyCell(self) -> None: ...
    def SetCellTypeToHexagonalPrism(self) -> None: ...
    def SetCellTypeToHexahedron(self) -> None: ...
    def SetCellTypeToLagrangeCurve(self) -> None: ...
    def SetCellTypeToLagrangeHexahedron(self) -> None: ...
    def SetCellTypeToLagrangeQuadrilateral(self) -> None: ...
    def SetCellTypeToLagrangeTetra(self) -> None: ...
    def SetCellTypeToLagrangeTriangle(self) -> None: ...
    def SetCellTypeToLagrangeWedge(self) -> None: ...
    def SetCellTypeToLine(self) -> None: ...
    def SetCellTypeToPentagonalPrism(self) -> None: ...
    def SetCellTypeToPixel(self) -> None: ...
    def SetCellTypeToPolyLine(self) -> None: ...
    def SetCellTypeToPolyVertex(self) -> None: ...
    def SetCellTypeToPolygon(self) -> None: ...
    def SetCellTypeToPolyhedron(self) -> None: ...
    def SetCellTypeToPyramid(self) -> None: ...
    def SetCellTypeToQuad(self) -> None: ...
    def SetCellTypeToQuadraticEdge(self) -> None: ...
    def SetCellTypeToQuadraticHexahedron(self) -> None: ...
    def SetCellTypeToQuadraticLinearQuad(self) -> None: ...
    def SetCellTypeToQuadraticLinearWedge(self) -> None: ...
    def SetCellTypeToQuadraticPolygon(self) -> None: ...
    def SetCellTypeToQuadraticPyramid(self) -> None: ...
    def SetCellTypeToQuadraticQuad(self) -> None: ...
    def SetCellTypeToQuadraticTetra(self) -> None: ...
    def SetCellTypeToQuadraticTriangle(self) -> None: ...
    def SetCellTypeToQuadraticWedge(self) -> None: ...
    def SetCellTypeToTetra(self) -> None: ...
    def SetCellTypeToTriQuadraticHexahedron(self) -> None: ...
    def SetCellTypeToTriQuadraticPyramid(self) -> None: ...
    def SetCellTypeToTriangle(self) -> None: ...
    def SetCellTypeToTriangleStrip(self) -> None: ...
    def SetCellTypeToVertex(self) -> None: ...
    def SetCellTypeToVoxel(self) -> None: ...
    def SetCellTypeToWedge(self) -> None: ...
    def SetFaces(self, faces:MutableSequence[int]) -> None: ...
    def SetPointIds(self, pointIds:'vtkIdList') -> None: ...
    def SetPoints(self, points:'vtkPoints') -> None: ...
    def ShallowCopy(self, c:'vtkCell') -> None: ...
    def Triangulate(self, index:int, ptIds:'vtkIdList', pts:'vtkPoints') -> int: ...
    def TriangulateIds(self, index:int, ptIds:'vtkIdList') -> int: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkGenericCellIterator(vtkmodules.vtkCommonCore.vtkObject):
    cell:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Begin(self) -> None: ...
    @overload
    def GetCell(self, c:'vtkGenericAdaptorCell') -> None: ...
    @overload
    def GetCell(self) -> 'vtkGenericAdaptorCell': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsAtEnd(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewCell(self) -> 'vtkGenericAdaptorCell': ...
    def NewInstance(self) -> 'vtkGenericCellIterator': ...
    def Next(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericCellIterator': ...

class vtkGenericCellTessellator(vtkmodules.vtkCommonCore.vtkObject):
    error_metrics:'getset_descriptor'
    measurement:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetErrorMetrics(self) -> 'vtkCollection': ...
    def GetMaxErrors(self, errors:MutableSequence[float]) -> None: ...
    def GetMeasurement(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitErrorMetrics(self, ds:'vtkGenericDataSet') -> None: ...
    def Initialize(self, ds:'vtkGenericDataSet') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericCellTessellator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericCellTessellator': ...
    def SetErrorMetrics(self, someErrorMetrics:'vtkCollection') -> None: ...
    def SetMeasurement(self, _arg:int) -> None: ...
    def Tessellate(self, cell:'vtkGenericAdaptorCell', att:'vtkGenericAttributeCollection', points:'vtkDoubleArray', cellArray:'vtkCellArray', internalPd:'vtkPointData') -> None: ...
    def TessellateFace(self, cell:'vtkGenericAdaptorCell', att:'vtkGenericAttributeCollection', index:int, points:'vtkDoubleArray', cellArray:'vtkCellArray', internalPd:'vtkPointData') -> None: ...
    def Triangulate(self, cell:'vtkGenericAdaptorCell', att:'vtkGenericAttributeCollection', points:'vtkDoubleArray', cellArray:'vtkCellArray', internalPd:'vtkPointData') -> None: ...

class vtkGenericDataSet(vtkDataObject):
    actual_memory_size:'getset_descriptor'
    attributes:'getset_descriptor'
    cell_dimension:'getset_descriptor'
    data_object_type:'getset_descriptor'
    estimated_size:'getset_descriptor'
    length:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_points:'getset_descriptor'
    tessellator:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeBounds(self) -> None: ...
    def FindPoint(self, x:MutableSequence[float], p:'vtkGenericPointIterator') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetAttributes(self) -> 'vtkGenericAttributeCollection': ...
    @overload
    def GetAttributes(self, type:int) -> 'vtkDataSetAttributes': ...
    @overload
    def GetBounds(self) -> Pointer: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCellDimension(self) -> int: ...
    def GetCellTypes(self, types:'vtkCellTypes') -> None: ...
    @overload
    def GetCenter(self) -> Pointer: ...
    @overload
    def GetCenter(self, center:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkGenericDataSet': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkGenericDataSet': ...
    def GetDataObjectType(self) -> int: ...
    def GetEstimatedSize(self) -> int: ...
    def GetLength(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfCells(self, dim:int=-1) -> int: ...
    def GetNumberOfElements(self, type:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetTessellator(self) -> 'vtkGenericCellTessellator': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewBoundaryIterator(self, dim:int=-1, exteriorOnly:int=0) -> 'vtkGenericCellIterator': ...
    def NewCellIterator(self, dim:int=-1) -> 'vtkGenericCellIterator': ...
    def NewInstance(self) -> 'vtkGenericDataSet': ...
    def NewPointIterator(self) -> 'vtkGenericPointIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericDataSet': ...
    def SetTessellator(self, tessellator:'vtkGenericCellTessellator') -> None: ...

class vtkGenericEdgeTable(vtkmodules.vtkCommonCore.vtkObject):
    number_of_components:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CheckEdge(self, e1:int, e2:int, ptId:int) -> int: ...
    def CheckEdgeReferenceCount(self, e1:int, e2:int) -> int: ...
    @overload
    def CheckPoint(self, ptId:int) -> int: ...
    @overload
    def CheckPoint(self, ptId:int, point:MutableSequence[float], scalar:MutableSequence[float]) -> int: ...
    def DumpTable(self) -> None: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IncrementEdgeReferenceCount(self, e1:int, e2:int, cellId:int) -> int: ...
    def IncrementPointReferenceCount(self, ptId:int) -> None: ...
    def Initialize(self, start:int) -> None: ...
    @overload
    def InsertEdge(self, e1:int, e2:int, cellId:int, ref:int, ptId:int) -> None: ...
    @overload
    def InsertEdge(self, e1:int, e2:int, cellId:int, ref:int=1) -> None: ...
    def InsertPoint(self, ptId:int, point:MutableSequence[float]) -> None: ...
    def InsertPointAndScalar(self, ptId:int, pt:MutableSequence[float], s:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LoadFactor(self) -> None: ...
    def NewInstance(self) -> 'vtkGenericEdgeTable': ...
    def RemoveEdge(self, e1:int, e2:int) -> int: ...
    def RemovePoint(self, ptId:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericEdgeTable': ...
    def SetNumberOfComponents(self, count:int) -> None: ...

class vtkGenericInterpolatedVelocityField(vtkmodules.vtkCommonMath.vtkFunctionSet):
    cache_hit:'getset_descriptor'
    cache_miss:'getset_descriptor'
    caching:'getset_descriptor'
    last_cell:'getset_descriptor'
    last_data_set:'getset_descriptor'
    vectors_selection:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddDataSet(self, dataset:'vtkGenericDataSet') -> None: ...
    def CachingOff(self) -> None: ...
    def CachingOn(self) -> None: ...
    def ClearLastCell(self) -> None: ...
    def CopyParameters(self, from_:'vtkGenericInterpolatedVelocityField') -> None: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float]) -> int: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float], userData:Pointer) -> int: ...
    def GetCacheHit(self) -> int: ...
    def GetCacheMiss(self) -> int: ...
    def GetCaching(self) -> int: ...
    def GetLastCell(self) -> 'vtkGenericAdaptorCell': ...
    def GetLastDataSet(self) -> 'vtkGenericDataSet': ...
    def GetLastLocalCoordinates(self, pcoords:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVectorsSelection(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericInterpolatedVelocityField': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericInterpolatedVelocityField': ...
    def SelectVectors(self, fieldName:str) -> None: ...
    def SetCaching(self, _arg:int) -> None: ...

class vtkGenericPointIterator(vtkmodules.vtkCommonCore.vtkObject):
    id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Begin(self) -> None: ...
    def GetId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPosition(self) -> Pointer: ...
    @overload
    def GetPosition(self, x:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsAtEnd(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericPointIterator': ...
    def Next(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericPointIterator': ...

class vtkGeometricErrorMetric(vtkGenericSubdivisionErrorMetric):
    absolute_geometric_tolerance:'getset_descriptor'
    relative:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAbsoluteGeometricTolerance(self) -> float: ...
    def GetError(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRelative(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGeometricErrorMetric': ...
    def RequiresEdgeSubdivision(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGeometricErrorMetric': ...
    def SetAbsoluteGeometricTolerance(self, value:float) -> None: ...
    def SetRelativeGeometricTolerance(self, value:float, ds:'vtkGenericDataSet') -> None: ...

class vtkGraphEdge(vtkmodules.vtkCommonCore.vtkObject):
    id:'getset_descriptor'
    source:'getset_descriptor'
    target:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSource(self) -> int: ...
    def GetTarget(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphEdge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphEdge': ...
    def SetId(self, _arg:int) -> None: ...
    def SetSource(self, _arg:int) -> None: ...
    def SetTarget(self, _arg:int) -> None: ...

class vtkGraphInternals(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphInternals': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphInternals': ...

class vtkHexagonalPrism(vtkCell3D):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    @staticmethod
    def ComputeCentroid(points:'vtkPoints', pointIds:Sequence[int], centroid:MutableSequence[float]) -> bool: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, pts:Sequence[int]) -> None: ...
    @staticmethod
    def GetEdgeToAdjacentFacesArray(edgeId:int) -> Tuple[int, int]: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetFaceToAdjacentFacesArray(faceId:int) -> Tuple[int, int, int, int, int, int]: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetPointToIncidentEdges(self, pointId:int, edgeIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentEdgesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToIncidentFaces(self, pointId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentFacesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToOneRingPointsArray(pointId:int) -> Tuple[int, int, int]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInsideOut(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHexagonalPrism': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHexagonalPrism': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkHexahedron(vtkCell3D):
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    @staticmethod
    def ComputeCentroid(points:'vtkPoints', pointIds:Sequence[int], centroid:MutableSequence[float]) -> bool: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellType(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Tuple[int, int]: ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, pts:Sequence[int]) -> None: ...
    @staticmethod
    def GetEdgeToAdjacentFacesArray(edgeId:int) -> Tuple[int, int]: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Tuple[int, int, int, int]: ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetFaceToAdjacentFacesArray(faceId:int) -> Tuple[int, int, int, int]: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetPointToIncidentEdges(self, pointId:int, edgeIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentEdgesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToIncidentFaces(self, pointId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentFacesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToOneRingPointsArray(pointId:int) -> Tuple[int, int, int]: ...
    @staticmethod
    def GetTriangleCases(caseId:int) -> Pointer: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHexahedron': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHexahedron': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkUniformGridAMR(vtkCompositeDataSet):
    data_object_type:'getset_descriptor'
    grid_description:'getset_descriptor'
    number_of_levels:'getset_descriptor'
    total_number_of_blocks:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CompositeShallowCopy(self, src:'vtkCompositeDataSet') -> None: ...
    def CopyStructure(self, src:'vtkCompositeDataSet') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Pointer: ...
    def GetCompositeIndex(self, level:int, index:int) -> int: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkUniformGridAMR': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkUniformGridAMR': ...
    def GetDataObjectType(self) -> int: ...
    @overload
    def GetDataSet(self, iter:'vtkCompositeDataIterator') -> 'vtkDataObject': ...
    @overload
    def GetDataSet(self, level:int, idx:int) -> 'vtkUniformGrid': ...
    @overload
    def GetDataSet(self, flatIndex:int) -> 'vtkDataObject': ...
    def GetGridDescription(self) -> int: ...
    def GetLevelAndIndex(self, compositeIdx:int, level:int, idx:int) -> None: ...
    def GetMax(self, max:MutableSequence[float]) -> None: ...
    def GetMin(self, min:MutableSequence[float]) -> None: ...
    def GetNumberOfDataSets(self, level:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def GetTotalNumberOfBlocks(self) -> int: ...
    @overload
    def Initialize(self) -> None: ...
    @overload
    def Initialize(self, numLevels:int, blocksPerLevel:Sequence[int]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUniformGridAMR': ...
    def NewIterator(self) -> 'vtkCompositeDataIterator': ...
    def RecursiveShallowCopy(self, src:'vtkDataObject') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUniformGridAMR': ...
    @overload
    def SetDataSet(self, iter:'vtkCompositeDataIterator', dataObj:'vtkDataObject') -> None: ...
    @overload
    def SetDataSet(self, level:int, idx:int, grid:'vtkUniformGrid') -> None: ...
    def SetGridDescription(self, gridDescription:int) -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...

class vtkOverlappingAMR(vtkUniformGridAMR):
    amr_info:'getset_descriptor'
    data_object_type:'getset_descriptor'
    origin:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Audit(self) -> None: ...
    def FindGrid(self, q:MutableSequence[float], level:int, gridId:int) -> bool: ...
    def GenerateParentChildInformation(self) -> None: ...
    def GetAMRBlockSourceIndex(self, level:int, id:int) -> int: ...
    def GetAMRBox(self, level:int, id:int) -> 'vtkAMRBox': ...
    def GetAMRInfo(self) -> 'vtkAMRInformation': ...
    @overload
    def GetBounds(self, level:int, id:int, bb:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self, b:MutableSequence[float]) -> None: ...
    def GetChildren(self, level:int, index:int, numChildren:int) -> Pointer: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkOverlappingAMR': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkOverlappingAMR': ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrigin(self) -> Pointer: ...
    @overload
    def GetOrigin(self, level:int, id:int, origin:MutableSequence[float]) -> None: ...
    def GetParents(self, level:int, index:int, numParents:int) -> Pointer: ...
    @overload
    def GetRefinementRatio(self, level:int) -> int: ...
    @overload
    def GetRefinementRatio(self, iter:'vtkCompositeDataIterator') -> int: ...
    def GetSpacing(self, level:int, spacing:MutableSequence[float]) -> None: ...
    def HasChildrenInformation(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def NUMBER_OF_BLANKED_POINTS() -> 'vtkInformationIdTypeKey': ...
    def NewInstance(self) -> 'vtkOverlappingAMR': ...
    def NewIterator(self) -> 'vtkCompositeDataIterator': ...
    def PrintParentChildInfo(self, level:int, index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOverlappingAMR': ...
    def SetAMRBlockSourceIndex(self, level:int, id:int, sourceId:int) -> None: ...
    def SetAMRBox(self, level:int, id:int, box:'vtkAMRBox') -> None: ...
    def SetAMRInfo(self, info:'vtkAMRInformation') -> None: ...
    def SetOrigin(self, origin:Sequence[float]) -> None: ...
    def SetRefinementRatio(self, level:int, refRatio:int) -> None: ...
    def SetSpacing(self, level:int, spacing:Sequence[float]) -> None: ...

class vtkHierarchicalBoxDataSet(vtkOverlappingAMR):
    data_object_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkHierarchicalBoxDataSet': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkHierarchicalBoxDataSet': ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHierarchicalBoxDataSet': ...
    def NewIterator(self) -> 'vtkCompositeDataIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHierarchicalBoxDataSet': ...

class vtkHyperTree(vtkmodules.vtkCommonCore.vtkObject):
    actual_memory_size:'getset_descriptor'
    actual_memory_size_bytes:'getset_descriptor'
    branch_factor:'getset_descriptor'
    dimension:'getset_descriptor'
    global_index_from_local:'getset_descriptor'
    global_index_start:'getset_descriptor'
    global_node_index_max:'getset_descriptor'
    number_of_children:'getset_descriptor'
    number_of_leaves:'getset_descriptor'
    number_of_levels:'getset_descriptor'
    number_of_nodes:'getset_descriptor'
    number_of_vertices:'getset_descriptor'
    tree_index:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildFromBreadthFirstOrderDescriptor(self, descriptor:'vtkBitArray', numberOfBits:int, startIndex:int=0) -> None: ...
    @overload
    def ComputeBreadthFirstOrderDescriptor(self, depthLimiter:int, inputMask:'vtkBitArray', numberOfVerticesPerDepth:'vtkTypeInt64Array', descriptor:'vtkBitArray', breadthFirstIdMap:'vtkIdList') -> None: ...
    @overload
    def ComputeBreadthFirstOrderDescriptor(self, inputMask:'vtkBitArray', numberOfVerticesPerDepth:'vtkTypeInt64Array', descriptor:'vtkBitArray', breadthFirstIdMap:'vtkIdList') -> None: ...
    def CopyStructure(self, ht:'vtkHyperTree') -> None: ...
    @staticmethod
    def CreateInstance(branchFactor:int, dimension:int) -> 'vtkHyperTree': ...
    def Freeze(self, mode:str) -> 'vtkHyperTree': ...
    def GetActualMemorySize(self) -> int: ...
    def GetActualMemorySizeBytes(self) -> int: ...
    def GetBranchFactor(self) -> int: ...
    def GetDimension(self) -> int: ...
    def GetElderChildIndex(self, index_parent:int) -> int: ...
    def GetElderChildIndexArray(self, nbElements:int) -> Pointer: ...
    def GetGlobalIndexFromLocal(self, index:int) -> int: ...
    def GetGlobalIndexStart(self) -> int: ...
    def GetGlobalNodeIndexMax(self) -> int: ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLeaves(self) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def GetNumberOfNodes(self) -> int: ...
    def GetNumberOfVertices(self) -> int: ...
    @overload
    def GetScale(self, s:MutableSequence[float]) -> None: ...
    @overload
    def GetScale(self, d:int) -> float: ...
    def GetTreeIndex(self) -> int: ...
    def HasScales(self) -> bool: ...
    def Initialize(self, branchFactor:int, dimension:int, numberOfChildren:int) -> None: ...
    def InitializeForReader(self, numberOfLevels:int, nbVertices:int, nbVerticesOfLastLevel:int, isParent:'vtkBitArray', isMasked:'vtkBitArray', outIsMasked:'vtkBitArray') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsGlobalIndexImplicit(self) -> bool: ...
    def IsLeaf(self, index:int) -> bool: ...
    def IsTerminalNode(self, index:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTree': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTree': ...
    def SetGlobalIndexFromLocal(self, index:int, global_:int) -> None: ...
    def SetGlobalIndexStart(self, start:int) -> None: ...
    def SetTreeIndex(self, treeIndex:int) -> None: ...
    def SubdivideLeaf(self, index:int, level:int) -> None: ...

class vtkHyperTreeData(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkHyperTreeData') -> None: ...

class vtkHyperTreeGrid(vtkDataObject):
    actual_memory_size:'getset_descriptor'
    actual_memory_size_bytes:'getset_descriptor'
    axes:'getset_descriptor'
    bounds:'getset_descriptor'
    branch_factor:'getset_descriptor'
    cell_data:'getset_descriptor'
    cell_dims:'getset_descriptor'
    center:'getset_descriptor'
    data_object_type:'getset_descriptor'
    depth_limiter:'getset_descriptor'
    dimension:'getset_descriptor'
    dimensions:'getset_descriptor'
    extent:'getset_descriptor'
    extent_type:'getset_descriptor'
    freeze_state:'getset_descriptor'
    ghost_cells:'getset_descriptor'
    global_node_index_max:'getset_descriptor'
    has_interface:'getset_descriptor'
    interface_intercepts_name:'getset_descriptor'
    interface_normals_name:'getset_descriptor'
    mask:'getset_descriptor'
    max_number_of_trees:'getset_descriptor'
    mode_squeeze:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_children:'getset_descriptor'
    number_of_leaves:'getset_descriptor'
    number_of_levels:'getset_descriptor'
    number_of_non_empty_trees:'getset_descriptor'
    orientation:'getset_descriptor'
    pure_mask:'getset_descriptor'
    transposed_root_indexing:'getset_descriptor'
    tree_ghost_array:'getset_descriptor'
    x_coordinates:'getset_descriptor'
    y_coordinates:'getset_descriptor'
    z_coordinates:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllocateTreeGhostArray(self) -> 'vtkUnsignedCharArray': ...
    def ComputeBounds(self) -> None: ...
    def CopyCoordinates(self, output:'vtkHyperTreeGrid') -> None: ...
    def CopyEmptyStructure(self, __a:'vtkDataObject') -> None: ...
    def CopyStructure(self, __a:'vtkDataObject') -> None: ...
    @staticmethod
    def DIMENSION() -> 'vtkInformationIntegerKey': ...
    def DeepCopy(self, __a:'vtkDataObject') -> None: ...
    def FindDichotomicX(self, value:float, tol:float=0.0) -> int: ...
    def FindDichotomicY(self, value:float, tol:float=0.0) -> int: ...
    def FindDichotomicZ(self, value:float, tol:float=0.0) -> int: ...
    def FindNonOrientedGeometryCursor(self, x:MutableSequence[float]) -> 'vtkHyperTreeGridNonOrientedGeometryCursor': ...
    def Get1DAxis(self, axis:int) -> None: ...
    def Get2DAxes(self, axis1:int, axis2:int) -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetActualMemorySizeBytes(self) -> int: ...
    def GetAttributesAsFieldData(self, type:int) -> 'vtkFieldData': ...
    def GetAxes(self) -> Pointer: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetBranchFactor(self) -> int: ...
    def GetCellData(self) -> 'vtkCellData': ...
    @overload
    def GetCellDims(self) -> Tuple[int, int, int]: ...
    @overload
    def GetCellDims(self, cellDims:MutableSequence[int]) -> None: ...
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, center:MutableSequence[float]) -> None: ...
    def GetChildMask(self, __a:int) -> int: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkHyperTreeGrid': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkHyperTreeGrid': ...
    def GetDataObjectType(self) -> int: ...
    def GetDepthLimiter(self) -> int: ...
    def GetDimension(self) -> int: ...
    @overload
    def GetDimensions(self) -> Tuple[int, int, int]: ...
    @overload
    def GetDimensions(self, dim:MutableSequence[int]) -> None: ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetExtentType(self) -> int: ...
    def GetFreezeState(self) -> bool: ...
    def GetGhostCells(self) -> 'vtkUnsignedCharArray': ...
    def GetGlobalNodeIndexMax(self) -> int: ...
    def GetGridBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetHasInterface(self) -> bool: ...
    def GetIndexFromLevelZeroCoordinates(self, __a:int, __b:int, __c:int, __d:int) -> None: ...
    def GetInterfaceInterceptsName(self) -> str: ...
    def GetInterfaceNormalsName(self) -> str: ...
    def GetLevelZeroCoordinatesFromIndex(self, __a:int, __b:int, __c:int, __d:int) -> None: ...
    def GetLevelZeroOriginAndSizeFromIndex(self, __a:int, __b:MutableSequence[float], __c:MutableSequence[float]) -> None: ...
    def GetLevelZeroOriginFromIndex(self, __a:int, __b:MutableSequence[float]) -> None: ...
    def GetMask(self) -> 'vtkBitArray': ...
    def GetMaxNumberOfTrees(self) -> int: ...
    def GetModeSqueeze(self) -> str: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfElements(self, type:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLeaves(self) -> int: ...
    @overload
    def GetNumberOfLevels(self, __a:int) -> int: ...
    @overload
    def GetNumberOfLevels(self) -> int: ...
    def GetNumberOfNonEmptyTrees(self) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetPureMask(self) -> 'vtkBitArray': ...
    def GetShiftedLevelZeroIndex(self, __a:int, __b:int, __c:int, __d:int) -> int: ...
    def GetTransposedRootIndexing(self) -> bool: ...
    def GetTree(self, __a:int, create:bool=False) -> 'vtkHyperTree': ...
    def GetTreeGhostArray(self) -> 'vtkUnsignedCharArray': ...
    def GetXCoordinates(self) -> 'vtkDataArray': ...
    def GetYCoordinates(self) -> 'vtkDataArray': ...
    def GetZCoordinates(self) -> 'vtkDataArray': ...
    def HasAnyGhostCells(self) -> bool: ...
    def HasInterfaceOff(self) -> None: ...
    def HasInterfaceOn(self) -> None: ...
    def HasMask(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InitializeLocalIndexNode(self) -> None: ...
    def InitializeNonOrientedCursor(self, cursor:'vtkHyperTreeGridNonOrientedCursor', index:int, create:bool=False) -> None: ...
    def InitializeNonOrientedGeometryCursor(self, cursor:'vtkHyperTreeGridNonOrientedGeometryCursor', index:int, create:bool=False) -> None: ...
    def InitializeNonOrientedMooreSuperCursor(self, cursor:'vtkHyperTreeGridNonOrientedMooreSuperCursor', index:int, create:bool=False) -> None: ...
    def InitializeNonOrientedMooreSuperCursorLight(self, cursor:'vtkHyperTreeGridNonOrientedMooreSuperCursorLight', index:int, create:bool=False) -> None: ...
    def InitializeNonOrientedUnlimitedGeometryCursor(self, cursor:'vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor', index:int, create:bool=False) -> None: ...
    def InitializeNonOrientedUnlimitedMooreSuperCursor(self, cursor:'vtkHyperTreeGridNonOrientedUnlimitedMooreSuperCursor', index:int, create:bool=False) -> None: ...
    def InitializeNonOrientedVonNeumannSuperCursor(self, cursor:'vtkHyperTreeGridNonOrientedVonNeumannSuperCursor', index:int, create:bool=False) -> None: ...
    def InitializeNonOrientedVonNeumannSuperCursorLight(self, cursor:'vtkHyperTreeGridNonOrientedVonNeumannSuperCursorLight', index:int, create:bool=False) -> None: ...
    def InitializeOrientedCursor(self, cursor:'vtkHyperTreeGridOrientedCursor', index:int, create:bool=False) -> None: ...
    def InitializeOrientedGeometryCursor(self, cursor:'vtkHyperTreeGridOrientedGeometryCursor', index:int, create:bool=False) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def LEVELS() -> 'vtkInformationIntegerKey': ...
    def NewInstance(self) -> 'vtkHyperTreeGrid': ...
    def NewNonOrientedCursor(self, index:int, create:bool=False) -> 'vtkHyperTreeGridNonOrientedCursor': ...
    def NewNonOrientedGeometryCursor(self, index:int, create:bool=False) -> 'vtkHyperTreeGridNonOrientedGeometryCursor': ...
    def NewNonOrientedMooreSuperCursor(self, index:int, create:bool=False) -> 'vtkHyperTreeGridNonOrientedMooreSuperCursor': ...
    def NewNonOrientedMooreSuperCursorLight(self, index:int, create:bool=False) -> 'vtkHyperTreeGridNonOrientedMooreSuperCursorLight': ...
    def NewNonOrientedUnlimitedGeometryCursor(self, index:int, create:bool=False) -> 'vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor': ...
    def NewNonOrientedUnlimitedMooreSuperCursor(self, index:int, create:bool=False) -> 'vtkHyperTreeGridNonOrientedUnlimitedMooreSuperCursor': ...
    def NewNonOrientedVonNeumannSuperCursor(self, index:int, create:bool=False) -> 'vtkHyperTreeGridNonOrientedVonNeumannSuperCursor': ...
    def NewNonOrientedVonNeumannSuperCursorLight(self, index:int, create:bool=False) -> 'vtkHyperTreeGridNonOrientedVonNeumannSuperCursorLight': ...
    def NewOrientedCursor(self, index:int, create:bool=False) -> 'vtkHyperTreeGridOrientedCursor': ...
    def NewOrientedGeometryCursor(self, index:int, create:bool=False) -> 'vtkHyperTreeGridOrientedGeometryCursor': ...
    @staticmethod
    def ORIENTATION() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def SIZES() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGrid': ...
    def SetBranchFactor(self, __a:int) -> None: ...
    def SetDepthLimiter(self, _arg:int) -> None: ...
    @overload
    def SetDimensions(self, dims:Sequence[int]) -> None: ...
    @overload
    def SetDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetExtent(self, extent:Sequence[int]) -> None: ...
    @overload
    def SetExtent(self, x1:int, x2:int, y1:int, y2:int, z1:int, z2:int) -> None: ...
    def SetFixedCoordinates(self, axis:int, value:float) -> None: ...
    def SetHasInterface(self, _arg:bool) -> None: ...
    def SetIndexingModeToIJK(self) -> None: ...
    def SetIndexingModeToKJI(self) -> None: ...
    def SetInterfaceInterceptsName(self, _arg:str) -> None: ...
    def SetInterfaceNormalsName(self, _arg:str) -> None: ...
    def SetMask(self, __a:'vtkBitArray') -> None: ...
    def SetModeSqueeze(self, _arg:str) -> None: ...
    def SetTransposedRootIndexing(self, _arg:bool) -> None: ...
    def SetTree(self, __a:int, __b:'vtkHyperTree') -> None: ...
    def SetXCoordinates(self, __a:'vtkDataArray') -> None: ...
    def SetYCoordinates(self, __a:'vtkDataArray') -> None: ...
    def SetZCoordinates(self, __a:'vtkDataArray') -> None: ...
    def ShallowCopy(self, __a:'vtkDataObject') -> None: ...
    def Squeeze(self) -> None: ...
    def SupportsGhostArray(self, type:int) -> bool: ...

class vtkHyperTreeGridLocator(vtkmodules.vtkCommonCore.vtkObject):
    htg:'getset_descriptor'
    tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def FindCell(self, point:Sequence[float], tol:float, cell:'vtkGenericCell', subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def GetHTG(self) -> 'vtkHyperTreeGrid': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def Initialize(self) -> None: ...
    @overload
    def IntersectWithLine(self, p0:Sequence[float], p1:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p0:Sequence[float], p1:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList', cell:'vtkGenericCell') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridLocator': ...
    def Search(self, point:Sequence[float]) -> int: ...
    def SetHTG(self, __a:'vtkHyperTreeGrid') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def Update(self) -> None: ...

class vtkHyperTreeGridGeometricLocator(vtkHyperTreeGridLocator):
    htg:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def FindCell(self, point:Sequence[float], tol:float, cell:'vtkGenericCell', subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def IntersectWithLine(self, p0:Sequence[float], p1:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p0:Sequence[float], p1:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList', cell:'vtkGenericCell') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridGeometricLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridGeometricLocator': ...
    @overload
    def Search(self, point:Sequence[float]) -> int: ...
    @overload
    def Search(self, point:Sequence[float], cursor:'vtkHyperTreeGridNonOrientedGeometryCursor') -> int: ...
    def SetHTG(self, candHTG:'vtkHyperTreeGrid') -> None: ...

class vtkHyperTreeGridNonOrientedCursor(vtkmodules.vtkCommonCore.vtkObject):
    dimension:'getset_descriptor'
    global_index_from_local:'getset_descriptor'
    global_index_start:'getset_descriptor'
    global_node_index:'getset_descriptor'
    grid:'getset_descriptor'
    level:'getset_descriptor'
    mask:'getset_descriptor'
    number_of_children:'getset_descriptor'
    tree:'getset_descriptor'
    vertex_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clone(self) -> 'vtkHyperTreeGridNonOrientedCursor': ...
    def CloneFromCurrentEntry(self) -> 'vtkHyperTreeGridNonOrientedCursor': ...
    def GetDimension(self) -> int: ...
    def GetGlobalNodeIndex(self) -> int: ...
    def GetGrid(self) -> 'vtkHyperTreeGrid': ...
    def GetLevel(self) -> int: ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTree(self) -> 'vtkHyperTree': ...
    def GetVertexId(self) -> int: ...
    def HasTree(self) -> bool: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', tree:'vtkHyperTree', level:int, index:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLeaf(self) -> bool: ...
    def IsMasked(self) -> bool: ...
    def IsRoot(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedCursor': ...
    def SetGlobalIndexFromLocal(self, index:int) -> None: ...
    def SetGlobalIndexStart(self, index:int) -> None: ...
    def SetMask(self, state:bool) -> None: ...
    def SubdivideLeaf(self) -> None: ...
    def ToChild(self, ichild:int) -> None: ...
    def ToParent(self) -> None: ...
    def ToRoot(self) -> None: ...

class vtkHyperTreeGridNonOrientedGeometryCursor(vtkmodules.vtkCommonCore.vtkObject):
    dimension:'getset_descriptor'
    global_index_from_local:'getset_descriptor'
    global_index_start:'getset_descriptor'
    global_node_index:'getset_descriptor'
    level:'getset_descriptor'
    mask:'getset_descriptor'
    number_of_children:'getset_descriptor'
    origin:'getset_descriptor'
    size:'getset_descriptor'
    tree:'getset_descriptor'
    vertex_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clone(self) -> 'vtkHyperTreeGridNonOrientedGeometryCursor': ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetDimension(self) -> int: ...
    def GetGlobalNodeIndex(self) -> int: ...
    def GetHyperTreeGridOrientedGeometryCursor(self, grid:'vtkHyperTreeGrid') -> 'vtkHyperTreeGridOrientedGeometryCursor': ...
    def GetLevel(self) -> int: ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Pointer: ...
    def GetPoint(self, point:MutableSequence[float]) -> None: ...
    def GetSize(self) -> Pointer: ...
    def GetTree(self) -> 'vtkHyperTree': ...
    def GetVertexId(self) -> int: ...
    def HasTree(self) -> bool: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', tree:'vtkHyperTree', level:int, index:int, origin:MutableSequence[float]) -> None: ...
    @overload
    def Initialize(self, cursor:'vtkHyperTreeGridNonOrientedGeometryCursor') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLeaf(self) -> bool: ...
    def IsMasked(self) -> bool: ...
    def IsRoot(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedGeometryCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedGeometryCursor': ...
    def SetGlobalIndexFromLocal(self, index:int) -> None: ...
    def SetGlobalIndexStart(self, index:int) -> None: ...
    def SetMask(self, state:bool) -> None: ...
    def SubdivideLeaf(self) -> None: ...
    def ToChild(self, ichild:int) -> None: ...
    def ToParent(self) -> None: ...
    def ToRoot(self) -> None: ...

class vtkHyperTreeGridNonOrientedSuperCursor(vtkmodules.vtkCommonCore.vtkObject):
    dimension:'getset_descriptor'
    global_index_from_local:'getset_descriptor'
    global_index_start:'getset_descriptor'
    global_node_index:'getset_descriptor'
    grid:'getset_descriptor'
    indice_central_cursor:'getset_descriptor'
    level:'getset_descriptor'
    mask:'getset_descriptor'
    number_of_children:'getset_descriptor'
    number_of_cursors:'getset_descriptor'
    origin:'getset_descriptor'
    size:'getset_descriptor'
    tree:'getset_descriptor'
    vertex_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clone(self) -> 'vtkHyperTreeGridNonOrientedSuperCursor': ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self, icursor:int, bounds:MutableSequence[float]) -> None: ...
    def GetDimension(self) -> int: ...
    @overload
    def GetGlobalNodeIndex(self) -> int: ...
    @overload
    def GetGlobalNodeIndex(self, icursor:int) -> int: ...
    def GetGrid(self) -> 'vtkHyperTreeGrid': ...
    def GetIndiceCentralCursor(self) -> int: ...
    def GetInformation(self, icursor:int, level:int, leaf:bool, id:int) -> 'vtkHyperTree': ...
    @overload
    def GetLevel(self) -> int: ...
    @overload
    def GetLevel(self, icursor:int) -> int: ...
    def GetNonOrientedGeometryCursor(self, icursor:int) -> 'vtkHyperTreeGridNonOrientedGeometryCursor': ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfCursors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientedGeometryCursor(self, icursor:int) -> 'vtkHyperTreeGridOrientedGeometryCursor': ...
    @overload
    def GetOrigin(self) -> Pointer: ...
    @overload
    def GetOrigin(self, icursor:int) -> Pointer: ...
    @overload
    def GetPoint(self, point:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint(self, icursor:int, point:MutableSequence[float]) -> None: ...
    def GetSize(self) -> Pointer: ...
    @overload
    def GetTree(self) -> 'vtkHyperTree': ...
    @overload
    def GetTree(self, icursor:int) -> 'vtkHyperTree': ...
    @overload
    def GetVertexId(self) -> int: ...
    @overload
    def GetVertexId(self, icursor:int) -> int: ...
    @overload
    def HasTree(self) -> bool: ...
    @overload
    def HasTree(self, icursor:int) -> bool: ...
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsLeaf(self) -> bool: ...
    @overload
    def IsLeaf(self, icursor:int) -> bool: ...
    @overload
    def IsMasked(self) -> bool: ...
    @overload
    def IsMasked(self, icursor:int) -> bool: ...
    def IsRoot(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedSuperCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedSuperCursor': ...
    def SetGlobalIndexFromLocal(self, index:int) -> None: ...
    def SetGlobalIndexStart(self, index:int) -> None: ...
    @overload
    def SetMask(self, state:bool) -> None: ...
    @overload
    def SetMask(self, icursor:int, state:bool) -> None: ...
    def SubdivideLeaf(self) -> None: ...
    def ToChild(self, ichild:int) -> None: ...
    def ToParent(self) -> None: ...
    def ToRoot(self) -> None: ...

class vtkHyperTreeGridNonOrientedMooreSuperCursor(vtkHyperTreeGridNonOrientedSuperCursor):
    def __init__(self, **properties:Any) -> None: ...
    def GetCornerCursors(self, __a:int, __b:int, __c:'vtkIdList') -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedMooreSuperCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedMooreSuperCursor': ...

class vtkHyperTreeGridNonOrientedSuperCursorLight(vtkmodules.vtkCommonCore.vtkObject):
    dimension:'getset_descriptor'
    global_index_from_local:'getset_descriptor'
    global_index_start:'getset_descriptor'
    global_node_index:'getset_descriptor'
    grid:'getset_descriptor'
    level:'getset_descriptor'
    mask:'getset_descriptor'
    number_of_children:'getset_descriptor'
    number_of_cursors:'getset_descriptor'
    origin:'getset_descriptor'
    size:'getset_descriptor'
    tree:'getset_descriptor'
    vertex_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clone(self) -> 'vtkHyperTreeGridNonOrientedSuperCursorLight': ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetDimension(self) -> int: ...
    @overload
    def GetGlobalNodeIndex(self) -> int: ...
    @overload
    def GetGlobalNodeIndex(self, icursor:int) -> int: ...
    def GetGrid(self) -> 'vtkHyperTreeGrid': ...
    def GetInformation(self, icursor:int, level:int, leaf:bool, id:int) -> 'vtkHyperTree': ...
    @overload
    def GetLevel(self) -> int: ...
    @overload
    def GetLevel(self, icursor:int) -> int: ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfCursors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Pointer: ...
    def GetPoint(self, point:MutableSequence[float]) -> None: ...
    def GetSize(self) -> Pointer: ...
    @overload
    def GetTree(self) -> 'vtkHyperTree': ...
    @overload
    def GetTree(self, icursor:int) -> 'vtkHyperTree': ...
    @overload
    def GetVertexId(self) -> int: ...
    @overload
    def GetVertexId(self, icursor:int) -> int: ...
    @overload
    def HasTree(self) -> bool: ...
    @overload
    def HasTree(self, icursor:int) -> bool: ...
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsLeaf(self) -> bool: ...
    @overload
    def IsLeaf(self, icursor:int) -> bool: ...
    @overload
    def IsMasked(self) -> bool: ...
    @overload
    def IsMasked(self, icursor:int) -> bool: ...
    def IsRoot(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedSuperCursorLight': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedSuperCursorLight': ...
    def SetGlobalIndexFromLocal(self, index:int) -> None: ...
    def SetGlobalIndexStart(self, index:int) -> None: ...
    @overload
    def SetMask(self, state:bool) -> None: ...
    @overload
    def SetMask(self, icursor:int, state:bool) -> None: ...
    def SubdivideLeaf(self) -> None: ...
    def ToChild(self, __a:int) -> None: ...
    def ToParent(self) -> None: ...
    def ToRoot(self) -> None: ...

class vtkHyperTreeGridNonOrientedMooreSuperCursorLight(vtkHyperTreeGridNonOrientedSuperCursorLight):
    def __init__(self, **properties:Any) -> None: ...
    def GetCornerCursors(self, __a:int, __b:int, __c:'vtkIdList') -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedMooreSuperCursorLight': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedMooreSuperCursorLight': ...

class vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor(vtkmodules.vtkCommonCore.vtkObject):
    dimension:'getset_descriptor'
    global_index_from_local:'getset_descriptor'
    global_index_start:'getset_descriptor'
    global_node_index:'getset_descriptor'
    last_real_level:'getset_descriptor'
    level:'getset_descriptor'
    mask:'getset_descriptor'
    number_of_children:'getset_descriptor'
    origin:'getset_descriptor'
    size:'getset_descriptor'
    tree:'getset_descriptor'
    vertex_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clone(self) -> 'vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor': ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetDimension(self) -> int: ...
    def GetGlobalNodeIndex(self) -> int: ...
    def GetHyperTreeGridNonOrientedGeometryCursor(self, grid:'vtkHyperTreeGrid') -> 'vtkHyperTreeGridNonOrientedGeometryCursor': ...
    def GetHyperTreeGridOrientedGeometryCursor(self, grid:'vtkHyperTreeGrid') -> 'vtkHyperTreeGridOrientedGeometryCursor': ...
    def GetLastRealLevel(self) -> int: ...
    def GetLevel(self) -> int: ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Pointer: ...
    def GetPoint(self, point:MutableSequence[float]) -> None: ...
    def GetSize(self) -> Pointer: ...
    def GetTree(self) -> 'vtkHyperTree': ...
    def GetVertexId(self) -> int: ...
    def HasTree(self) -> bool: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', tree:'vtkHyperTree', level:int, index:int, origin:MutableSequence[float]) -> None: ...
    @overload
    def Initialize(self, cursor:'vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLeaf(self) -> bool: ...
    def IsMasked(self) -> bool: ...
    def IsRealLeaf(self) -> bool: ...
    def IsRoot(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsVirtualLeaf(self) -> bool: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor': ...
    def SetGlobalIndexFromLocal(self, index:int) -> None: ...
    def SetGlobalIndexStart(self, index:int) -> None: ...
    def SetMask(self, state:bool) -> None: ...
    def ToChild(self, ichild:int) -> None: ...
    def ToParent(self) -> None: ...
    def ToRoot(self) -> None: ...

class vtkHyperTreeGridNonOrientedUnlimitedSuperCursor(vtkmodules.vtkCommonCore.vtkObject):
    dimension:'getset_descriptor'
    extensive_property_ratio:'getset_descriptor'
    global_index_from_local:'getset_descriptor'
    global_index_start:'getset_descriptor'
    global_node_index:'getset_descriptor'
    grid:'getset_descriptor'
    last_real_level:'getset_descriptor'
    level:'getset_descriptor'
    mask:'getset_descriptor'
    number_of_children:'getset_descriptor'
    number_of_cursors:'getset_descriptor'
    origin:'getset_descriptor'
    size:'getset_descriptor'
    tree:'getset_descriptor'
    vertex_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clone(self) -> 'vtkHyperTreeGridNonOrientedUnlimitedSuperCursor': ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self, icursor:int, bounds:MutableSequence[float]) -> None: ...
    def GetDimension(self) -> int: ...
    @overload
    def GetExtensivePropertyRatio(self) -> float: ...
    @overload
    def GetExtensivePropertyRatio(self, index:int) -> float: ...
    @overload
    def GetGlobalNodeIndex(self) -> int: ...
    @overload
    def GetGlobalNodeIndex(self, icursor:int) -> int: ...
    def GetGrid(self) -> 'vtkHyperTreeGrid': ...
    def GetInformation(self, icursor:int, level:int, leaf:bool, id:int) -> 'vtkHyperTree': ...
    @overload
    def GetLastRealLevel(self) -> int: ...
    @overload
    def GetLastRealLevel(self, icursor:int) -> int: ...
    @overload
    def GetLevel(self) -> int: ...
    @overload
    def GetLevel(self, icursor:int) -> int: ...
    def GetNonOrientedGeometryCursor(self, icursor:int) -> 'vtkHyperTreeGridNonOrientedGeometryCursor': ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfCursors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientedGeometryCursor(self, icursor:int) -> 'vtkHyperTreeGridOrientedGeometryCursor': ...
    def GetOrigin(self) -> Pointer: ...
    @overload
    def GetPoint(self, point:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint(self, icursor:int, point:MutableSequence[float]) -> None: ...
    def GetSize(self) -> Pointer: ...
    @overload
    def GetTree(self) -> 'vtkHyperTree': ...
    @overload
    def GetTree(self, icursor:int) -> 'vtkHyperTree': ...
    @overload
    def GetVertexId(self) -> int: ...
    @overload
    def GetVertexId(self, icursor:int) -> int: ...
    @overload
    def HasTree(self) -> bool: ...
    @overload
    def HasTree(self, icursor:int) -> bool: ...
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsLeaf(self) -> bool: ...
    @overload
    def IsLeaf(self, icursor:int) -> bool: ...
    @overload
    def IsMasked(self) -> bool: ...
    @overload
    def IsMasked(self, icursor:int) -> bool: ...
    @overload
    def IsRealLeaf(self) -> bool: ...
    @overload
    def IsRealLeaf(self, icursor:int) -> bool: ...
    def IsRoot(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def IsVirtualLeaf(self) -> bool: ...
    @overload
    def IsVirtualLeaf(self, icursor:int) -> bool: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedUnlimitedSuperCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedUnlimitedSuperCursor': ...
    def SetGlobalIndexFromLocal(self, index:int) -> None: ...
    def SetGlobalIndexStart(self, index:int) -> None: ...
    @overload
    def SetMask(self, state:bool) -> None: ...
    @overload
    def SetMask(self, icursor:int, state:bool) -> None: ...
    def ToChild(self, ichild:int) -> None: ...
    def ToParent(self) -> None: ...
    def ToRoot(self) -> None: ...

class vtkHyperTreeGridNonOrientedUnlimitedMooreSuperCursor(vtkHyperTreeGridNonOrientedUnlimitedSuperCursor):
    def __init__(self, **properties:Any) -> None: ...
    def GetCornerCursors(self, __a:int, __b:int, __c:'vtkIdList') -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedUnlimitedMooreSuperCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedUnlimitedMooreSuperCursor': ...

class vtkHyperTreeGridNonOrientedVonNeumannSuperCursor(vtkHyperTreeGridNonOrientedSuperCursor):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedVonNeumannSuperCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedVonNeumannSuperCursor': ...

class vtkHyperTreeGridNonOrientedVonNeumannSuperCursorLight(vtkHyperTreeGridNonOrientedSuperCursorLight):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridNonOrientedVonNeumannSuperCursorLight': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridNonOrientedVonNeumannSuperCursorLight': ...

class vtkHyperTreeGridOrientedCursor(vtkmodules.vtkCommonCore.vtkObject):
    dimension:'getset_descriptor'
    global_index_from_local:'getset_descriptor'
    global_index_start:'getset_descriptor'
    global_node_index:'getset_descriptor'
    grid:'getset_descriptor'
    level:'getset_descriptor'
    mask:'getset_descriptor'
    number_of_children:'getset_descriptor'
    tree:'getset_descriptor'
    vertex_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clone(self) -> 'vtkHyperTreeGridOrientedCursor': ...
    def GetDimension(self) -> int: ...
    def GetGlobalNodeIndex(self) -> int: ...
    def GetGrid(self) -> 'vtkHyperTreeGrid': ...
    def GetLevel(self) -> int: ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTree(self) -> 'vtkHyperTree': ...
    def GetVertexId(self) -> int: ...
    def HasTree(self) -> bool: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', tree:'vtkHyperTree', level:int, index:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLeaf(self) -> bool: ...
    def IsMasked(self) -> bool: ...
    def IsRoot(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridOrientedCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridOrientedCursor': ...
    def SetGlobalIndexFromLocal(self, index:int) -> None: ...
    def SetGlobalIndexStart(self, index:int) -> None: ...
    def SetMask(self, state:bool) -> None: ...
    def SubdivideLeaf(self) -> None: ...
    def ToChild(self, ichild:int) -> None: ...

class vtkHyperTreeGridOrientedGeometryCursor(vtkmodules.vtkCommonCore.vtkObject):
    dimension:'getset_descriptor'
    global_index_from_local:'getset_descriptor'
    global_index_start:'getset_descriptor'
    global_node_index:'getset_descriptor'
    level:'getset_descriptor'
    mask:'getset_descriptor'
    number_of_children:'getset_descriptor'
    origin:'getset_descriptor'
    size:'getset_descriptor'
    tree:'getset_descriptor'
    vertex_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clone(self) -> 'vtkHyperTreeGridOrientedGeometryCursor': ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetDimension(self) -> int: ...
    def GetGlobalNodeIndex(self) -> int: ...
    def GetLevel(self) -> int: ...
    def GetNumberOfChildren(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Pointer: ...
    def GetPoint(self, point:MutableSequence[float]) -> None: ...
    def GetSize(self) -> Pointer: ...
    def GetTree(self) -> 'vtkHyperTree': ...
    def GetVertexId(self) -> int: ...
    def HasTree(self) -> bool: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', treeIndex:int, create:bool=False) -> None: ...
    @overload
    def Initialize(self, grid:'vtkHyperTreeGrid', tree:'vtkHyperTree', level:int, index:int, origin:MutableSequence[float]) -> None: ...
    @overload
    def Initialize(self, cursor:'vtkHyperTreeGridOrientedGeometryCursor') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLeaf(self) -> bool: ...
    def IsMasked(self) -> bool: ...
    def IsRoot(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridOrientedGeometryCursor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridOrientedGeometryCursor': ...
    def SetGlobalIndexFromLocal(self, index:int) -> None: ...
    def SetGlobalIndexStart(self, index:int) -> None: ...
    def SetMask(self, state:bool) -> None: ...
    def SubdivideLeaf(self) -> None: ...
    def ToChild(self, ichild:int) -> None: ...

class vtkHyperTreeGridScales(object):
    branch_factor:'getset_descriptor'
    current_fail_level:'getset_descriptor'
    def __init__(self, branchfactor:float, scale:Sequence[float] ) -> None: ...
    def GetBranchFactor(self) -> float: ...
    def GetCurrentFailLevel(self) -> int: ...
    @overload
    def GetScale(self, level:int) -> Pointer: ...
    @overload
    def GetScale(self, level:int, scale:MutableSequence[float]) -> None: ...
    def GetScaleX(self, level:int) -> float: ...
    def GetScaleY(self, level:int) -> float: ...
    def GetScaleZ(self, level:int) -> float: ...

class vtkImageData(vtkDataSet):
    actual_memory_size:'getset_descriptor'
    cell_types_array:'getset_descriptor'
    cells:'getset_descriptor'
    data_description:'getset_descriptor'
    data_dimension:'getset_descriptor'
    data_object_type:'getset_descriptor'
    dimensions:'getset_descriptor'
    direction_matrix:'getset_descriptor'
    extent:'getset_descriptor'
    extent_type:'getset_descriptor'
    increments:'getset_descriptor'
    index_to_physical_matrix:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    max_spatial_dimension:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_points:'getset_descriptor'
    number_of_scalar_components:'getset_descriptor'
    origin:'getset_descriptor'
    physical_to_index_matrix:'getset_descriptor'
    points:'getset_descriptor'
    scalar_pointer:'getset_descriptor'
    scalar_size:'getset_descriptor'
    scalar_type:'getset_descriptor'
    scalar_type_max:'getset_descriptor'
    scalar_type_min:'getset_descriptor'
    spacing:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AllocateScalars(self, dataType:int, numComponents:int) -> None: ...
    @overload
    def AllocateScalars(self, pipeline_info:'vtkInformation') -> None: ...
    def ApplyIndexToPhysicalMatrix(self, source:'vtkMatrix4x4') -> None: ...
    def ApplyPhysicalToIndexMatrix(self, source:'vtkMatrix4x4') -> None: ...
    @overload
    def BlankCell(self, ptId:int) -> None: ...
    @overload
    def BlankCell(self, i:int, j:int, k:int) -> None: ...
    @overload
    def BlankPoint(self, ptId:int) -> None: ...
    @overload
    def BlankPoint(self, i:int, j:int, k:int) -> None: ...
    def ComputeBounds(self) -> None: ...
    def ComputeCellId(self, ijk:MutableSequence[int]) -> int: ...
    @staticmethod
    def ComputeIndexToPhysicalMatrix(origin:Sequence[float], spacing:Sequence[float], direction:Sequence[float], result:MutableSequence[float]) -> None: ...
    def ComputeInternalExtent(self, intExt:MutableSequence[int], tgtExt:MutableSequence[int], bnds:MutableSequence[int]) -> None: ...
    @staticmethod
    def ComputePhysicalToIndexMatrix(origin:Sequence[float], spacing:Sequence[float], direction:Sequence[float], result:MutableSequence[float]) -> None: ...
    def ComputePointId(self, ijk:MutableSequence[int]) -> int: ...
    def ComputeStructuredCoordinates(self, x:Sequence[float], ijk:MutableSequence[int], pcoords:MutableSequence[float]) -> int: ...
    @overload
    def CopyAndCastFrom(self, inData:'vtkImageData', extent:MutableSequence[int]) -> None: ...
    @overload
    def CopyAndCastFrom(self, inData:'vtkImageData', x0:int, x1:int, y0:int, y1:int, z0:int, z1:int) -> None: ...
    def CopyInformationFromPipeline(self, information:'vtkInformation') -> None: ...
    def CopyInformationToPipeline(self, information:'vtkInformation') -> None: ...
    def CopyStructure(self, ds:'vtkDataSet') -> None: ...
    def Crop(self, updateExtent:Sequence[int]) -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkImageData': ...
    def FindAndGetCell(self, x:MutableSequence[float], cell:'vtkCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> 'vtkCell': ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', gencell:'vtkGenericCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindPoint(self, x:MutableSequence[float]) -> int: ...
    def GetActualMemorySize(self) -> int: ...
    def GetArrayIncrements(self, array:'vtkDataArray', increments:MutableSequence[int]) -> None: ...
    def GetArrayPointer(self, array:'vtkDataArray', coordinates:MutableSequence[int]) -> Pointer: ...
    def GetArrayPointerForExtent(self, array:'vtkDataArray', extent:MutableSequence[int]) -> Pointer: ...
    def GetAxisUpdateExtent(self, axis:int, min:int, max:int, updateExtent:Sequence[int]) -> None: ...
    @overload
    def GetCell(self, cellId:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, cellId:int, cell:'vtkGenericCell') -> None: ...
    def GetCellBounds(self, cellId:int, bounds:MutableSequence[float]) -> None: ...
    def GetCellDims(self, cellDims:MutableSequence[int]) -> None: ...
    @overload
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList') -> None: ...
    @overload
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList', seedLoc:MutableSequence[int]) -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetCellType(self, cellId:int) -> int: ...
    def GetCellTypesArray(self) -> 'vtkConstantArray_IiE': ...
    def GetCells(self) -> 'vtkStructuredCellArray': ...
    @overload
    def GetContinuousIncrements(self, extent:MutableSequence[int], incX:int, incY:int, incZ:int) -> None: ...
    @overload
    def GetContinuousIncrements(self, scalars:'vtkDataArray', extent:MutableSequence[int], incX:int, incY:int, incZ:int) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkImageData': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkImageData': ...
    def GetDataDescription(self) -> int: ...
    def GetDataDimension(self) -> int: ...
    def GetDataObjectType(self) -> int: ...
    @overload
    def GetDimensions(self) -> Tuple[int, int, int]: ...
    @overload
    def GetDimensions(self, dims:MutableSequence[int]) -> None: ...
    def GetDirectionMatrix(self) -> 'vtkMatrix3x3': ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetExtentType(self) -> int: ...
    @overload
    def GetIncrements(self) -> Tuple[int, int, int]: ...
    @overload
    def GetIncrements(self, incX:int, incY:int, incZ:int) -> None: ...
    @overload
    def GetIncrements(self, inc:MutableSequence[int]) -> None: ...
    @overload
    def GetIncrements(self, scalars:'vtkDataArray') -> Tuple[int, int, int]: ...
    @overload
    def GetIncrements(self, scalars:'vtkDataArray', incX:int, incY:int, incZ:int) -> None: ...
    @overload
    def GetIncrements(self, scalars:'vtkDataArray', inc:MutableSequence[int]) -> None: ...
    def GetIndexToPhysicalMatrix(self) -> 'vtkMatrix4x4': ...
    def GetMaxCellSize(self) -> int: ...
    def GetMaxSpatialDimension(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    @staticmethod
    def GetNumberOfScalarComponents(meta_data:'vtkInformation') -> int: ...
    @overload
    def GetNumberOfScalarComponents(self) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetPhysicalToIndexMatrix(self) -> 'vtkMatrix4x4': ...
    @overload
    def GetPoint(self, ptId:int) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint(self, id:int, x:MutableSequence[float]) -> None: ...
    def GetPointCells(self, ptId:int, cellIds:'vtkIdList') -> None: ...
    def GetPointGradient(self, i:int, j:int, k:int, s:'vtkDataArray', g:MutableSequence[float]) -> None: ...
    def GetPoints(self) -> 'vtkPoints': ...
    def GetScalarComponentAsDouble(self, x:int, y:int, z:int, component:int) -> float: ...
    def GetScalarComponentAsFloat(self, x:int, y:int, z:int, component:int) -> float: ...
    @overload
    def GetScalarIndex(self, coordinates:MutableSequence[int]) -> int: ...
    @overload
    def GetScalarIndex(self, x:int, y:int, z:int) -> int: ...
    def GetScalarIndexForExtent(self, extent:MutableSequence[int]) -> int: ...
    @overload
    def GetScalarPointer(self, coordinates:MutableSequence[int]) -> Pointer: ...
    @overload
    def GetScalarPointer(self, x:int, y:int, z:int) -> Pointer: ...
    @overload
    def GetScalarPointer(self) -> Pointer: ...
    def GetScalarPointerForExtent(self, extent:MutableSequence[int]) -> Pointer: ...
    @overload
    def GetScalarSize(self, meta_data:'vtkInformation') -> int: ...
    @overload
    def GetScalarSize(self) -> int: ...
    @overload
    @staticmethod
    def GetScalarType(meta_data:'vtkInformation') -> int: ...
    @overload
    def GetScalarType(self) -> int: ...
    def GetScalarTypeAsString(self) -> str: ...
    @overload
    def GetScalarTypeMax(self, meta_data:'vtkInformation') -> float: ...
    @overload
    def GetScalarTypeMax(self) -> float: ...
    @overload
    def GetScalarTypeMin(self, meta_data:'vtkInformation') -> float: ...
    @overload
    def GetScalarTypeMin(self) -> float: ...
    def GetSpacing(self) -> Tuple[float, float, float]: ...
    def GetTupleIndex(self, array:'vtkDataArray', coordinates:MutableSequence[int]) -> int: ...
    def GetVoxelGradient(self, i:int, j:int, k:int, s:'vtkDataArray', g:'vtkDataArray') -> None: ...
    def HasAnyBlankCells(self) -> bool: ...
    def HasAnyBlankPoints(self) -> bool: ...
    @staticmethod
    def HasNumberOfScalarComponents(meta_data:'vtkInformation') -> bool: ...
    @staticmethod
    def HasScalarType(meta_data:'vtkInformation') -> bool: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCellVisible(self, cellId:int) -> int: ...
    def IsPointVisible(self, ptId:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageData': ...
    def PrepareForNewData(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageData': ...
    def SetAxisUpdateExtent(self, axis:int, min:int, max:int, updateExtent:Sequence[int], axisUpdateExtent:MutableSequence[int]) -> None: ...
    @overload
    def SetDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetDimensions(self, dims:Sequence[int]) -> None: ...
    @overload
    def SetDirectionMatrix(self, m:'vtkMatrix3x3') -> None: ...
    @overload
    def SetDirectionMatrix(self, elements:Sequence[float]) -> None: ...
    @overload
    def SetDirectionMatrix(self, e00:float, e01:float, e02:float, e10:float, e11:float, e12:float, e20:float, e21:float, e22:float) -> None: ...
    @overload
    def SetExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def SetExtent(self, x1:int, x2:int, y1:int, y2:int, z1:int, z2:int) -> None: ...
    @staticmethod
    def SetNumberOfScalarComponents(n:int, meta_data:'vtkInformation') -> None: ...
    @overload
    def SetOrigin(self, i:float, j:float, k:float) -> None: ...
    @overload
    def SetOrigin(self, ijk:Sequence[float]) -> None: ...
    def SetScalarComponentFromDouble(self, x:int, y:int, z:int, component:int, v:float) -> None: ...
    def SetScalarComponentFromFloat(self, x:int, y:int, z:int, component:int, v:float) -> None: ...
    @staticmethod
    def SetScalarType(__a:int, meta_data:'vtkInformation') -> None: ...
    @overload
    def SetSpacing(self, i:float, j:float, k:float) -> None: ...
    @overload
    def SetSpacing(self, ijk:Sequence[float]) -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    @overload
    def TransformContinuousIndexToPhysicalPoint(self, i:float, j:float, k:float, xyz:MutableSequence[float]) -> None: ...
    @overload
    def TransformContinuousIndexToPhysicalPoint(self, ijk:Sequence[float], xyz:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def TransformContinuousIndexToPhysicalPoint(i:float, j:float, k:float, origin:Sequence[float], spacing:Sequence[float], direction:Sequence[float], xyz:MutableSequence[float]) -> None: ...
    @overload
    def TransformIndexToPhysicalPoint(self, i:int, j:int, k:int, xyz:MutableSequence[float]) -> None: ...
    @overload
    def TransformIndexToPhysicalPoint(self, ijk:Sequence[int], xyz:MutableSequence[float]) -> None: ...
    def TransformPhysicalNormalToContinuousIndex(self, xyz:Sequence[float], ijk:MutableSequence[float]) -> None: ...
    def TransformPhysicalPlaneToContinuousIndex(self, pplane:Sequence[float], iplane:MutableSequence[float]) -> None: ...
    @overload
    def TransformPhysicalPointToContinuousIndex(self, x:float, y:float, z:float, ijk:MutableSequence[float]) -> None: ...
    @overload
    def TransformPhysicalPointToContinuousIndex(self, xyz:Sequence[float], ijk:MutableSequence[float]) -> None: ...
    @overload
    def UnBlankCell(self, ptId:int) -> None: ...
    @overload
    def UnBlankCell(self, i:int, j:int, k:int) -> None: ...
    @overload
    def UnBlankPoint(self, ptId:int) -> None: ...
    @overload
    def UnBlankPoint(self, i:int, j:int, k:int) -> None: ...

class vtkImageTransform(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageTransform': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageTransform': ...
    @staticmethod
    def TransformNormals(m3:'vtkMatrix3x3', spacing:Sequence[float], da:'vtkDataArray') -> None: ...
    @overload
    @staticmethod
    def TransformPointSet(im:'vtkImageData', ps:'vtkPointSet') -> None: ...
    @overload
    @staticmethod
    def TransformPointSet(im:'vtkImageData', ps:'vtkPointSet', transNormals:bool, transVectors:bool) -> None: ...
    @staticmethod
    def TransformPoints(m4:'vtkMatrix4x4', da:'vtkDataArray') -> None: ...
    @staticmethod
    def TransformVectors(m3:'vtkMatrix3x3', spacing:Sequence[float], da:'vtkDataArray') -> None: ...
    @staticmethod
    def TranslatePoints(t:Sequence[float], da:'vtkDataArray') -> None: ...

class vtkImplicitBoolean(vtkImplicitFunction):
    class OperationType(int): ...
    VTK_DIFFERENCE:'OperationType'
    VTK_INTERSECTION:'OperationType'
    VTK_UNION:'OperationType'
    VTK_UNION_OF_MAGNITUDES:'OperationType'
    function:'getset_descriptor'
    m_time:'getset_descriptor'
    operation_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddFunction(self, in_:'vtkImplicitFunction') -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetFunction(self) -> 'vtkImplicitFunctionCollection': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOperationType(self) -> int: ...
    def GetOperationTypeAsString(self) -> str: ...
    def GetOperationTypeMaxValue(self) -> int: ...
    def GetOperationTypeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitBoolean': ...
    def RemoveFunction(self, in_:'vtkImplicitFunction') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitBoolean': ...
    def SetOperationType(self, _arg:int) -> None: ...
    def SetOperationTypeToDifference(self) -> None: ...
    def SetOperationTypeToIntersection(self) -> None: ...
    def SetOperationTypeToUnion(self) -> None: ...
    def SetOperationTypeToUnionOfMagnitudes(self) -> None: ...

class vtkImplicitDataSet(vtkImplicitFunction):
    data_set:'getset_descriptor'
    m_time:'getset_descriptor'
    out_gradient:'getset_descriptor'
    out_value:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutGradient(self) -> Tuple[float, float, float]: ...
    def GetOutValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitDataSet': ...
    def SetDataSet(self, __a:'vtkDataSet') -> None: ...
    @overload
    def SetOutGradient(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOutGradient(self, _arg:Sequence[float]) -> None: ...
    def SetOutValue(self, _arg:float) -> None: ...

class vtkImplicitFunctionCollection(vtkmodules.vtkCommonCore.vtkCollection):
    next_item:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddItem(self, __a:'vtkImplicitFunction') -> None: ...
    def GetNextItem(self) -> 'vtkImplicitFunction': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitFunctionCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitFunctionCollection': ...

class vtkImplicitHalo(vtkImplicitFunction):
    center:'getset_descriptor'
    fade_out:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetFadeOut(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitHalo': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitHalo': ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetFadeOut(self, _arg:float) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkImplicitSelectionLoop(vtkImplicitFunction):
    automatic_normal_generation:'getset_descriptor'
    loop:'getset_descriptor'
    m_time:'getset_descriptor'
    normal:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutomaticNormalGenerationOff(self) -> None: ...
    def AutomaticNormalGenerationOn(self) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def GetAutomaticNormalGeneration(self) -> int: ...
    def GetLoop(self) -> 'vtkPoints': ...
    def GetMTime(self) -> int: ...
    def GetNormal(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitSelectionLoop': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitSelectionLoop': ...
    def SetAutomaticNormalGeneration(self, _arg:int) -> None: ...
    def SetLoop(self, __a:'vtkPoints') -> None: ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:Sequence[float]) -> None: ...

class vtkImplicitSum(vtkImplicitFunction):
    m_time:'getset_descriptor'
    normalize_by_weight:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddFunction(self, in_:'vtkImplicitFunction', weight:float) -> None: ...
    @overload
    def AddFunction(self, in_:'vtkImplicitFunction') -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNormalizeByWeight(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitSum': ...
    def NormalizeByWeightOff(self) -> None: ...
    def NormalizeByWeightOn(self) -> None: ...
    def RemoveAllFunctions(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitSum': ...
    def SetFunctionWeight(self, f:'vtkImplicitFunction', weight:float) -> None: ...
    def SetNormalizeByWeight(self, _arg:int) -> None: ...

class vtkImplicitVolume(vtkImplicitFunction):
    m_time:'getset_descriptor'
    out_gradient:'getset_descriptor'
    out_value:'getset_descriptor'
    volume:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutGradient(self) -> Tuple[float, float, float]: ...
    def GetOutValue(self) -> float: ...
    def GetVolume(self) -> 'vtkImageData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitVolume': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitVolume': ...
    @overload
    def SetOutGradient(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOutGradient(self, _arg:Sequence[float]) -> None: ...
    def SetOutValue(self, _arg:float) -> None: ...
    def SetVolume(self, __a:'vtkImageData') -> None: ...

class vtkImplicitWindowFunction(vtkImplicitFunction):
    implicit_function:'getset_descriptor'
    m_time:'getset_descriptor'
    window_range:'getset_descriptor'
    window_values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def GetImplicitFunction(self) -> 'vtkImplicitFunction': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWindowRange(self) -> Tuple[float, float]: ...
    def GetWindowValues(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitWindowFunction': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitWindowFunction': ...
    def SetImplicitFunction(self, __a:'vtkImplicitFunction') -> None: ...
    @overload
    def SetWindowRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetWindowRange(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetWindowValues(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetWindowValues(self, _arg:Sequence[float]) -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkInEdgeIterator(vtkmodules.vtkCommonCore.vtkObject):
    graph:'getset_descriptor'
    vertex:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetGraph(self) -> 'vtkGraph': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVertex(self) -> int: ...
    def HasNext(self) -> bool: ...
    def Initialize(self, g:'vtkGraph', v:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInEdgeIterator': ...
    def Next(self) -> 'vtkInEdgeType': ...
    def NextGraphEdge(self) -> 'vtkGraphEdge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInEdgeIterator': ...

class vtkInEdgeType(vtkEdgeBase):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, s:int, id:int) -> None: ...
    @overload
    def __init__(self, __a:'vtkInEdgeType') -> None: ...

class vtkIncrementalOctreeNode(vtkmodules.vtkCommonCore.vtkObject):
    bounds:'getset_descriptor'
    id:'getset_descriptor'
    max_bounds:'getset_descriptor'
    max_data_bounds:'getset_descriptor'
    min_bounds:'getset_descriptor'
    min_data_bounds:'getset_descriptor'
    number_of_levels:'getset_descriptor'
    number_of_points:'getset_descriptor'
    point_id_set:'getset_descriptor'
    point_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ContainsPoint(self, pnt:Sequence[float]) -> int: ...
    def ContainsPointByData(self, pnt:Sequence[float]) -> int: ...
    def DeleteChildNodes(self) -> None: ...
    def ExportAllPointIdsByDirectSet(self, pntIdx:MutableSequence[int], idList:'vtkIdList') -> None: ...
    def ExportAllPointIdsByInsertion(self, idList:'vtkIdList') -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetChild(self, i:int) -> 'vtkIncrementalOctreeNode': ...
    def GetChildIndex(self, point:Sequence[float]) -> int: ...
    @overload
    def GetDistance2ToBoundary(self, point:Sequence[float], rootNode:'vtkIncrementalOctreeNode', checkData:int) -> float: ...
    @overload
    def GetDistance2ToBoundary(self, point:Sequence[float], closest:MutableSequence[float], rootNode:'vtkIncrementalOctreeNode', checkData:int) -> float: ...
    def GetDistance2ToInnerBoundary(self, point:Sequence[float], rootNode:'vtkIncrementalOctreeNode') -> float: ...
    def GetID(self) -> int: ...
    def GetMaxBounds(self) -> Tuple[float, float, float]: ...
    def GetMaxDataBounds(self) -> Pointer: ...
    def GetMinBounds(self) -> Tuple[float, float, float]: ...
    def GetMinDataBounds(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetPointIdSet(self) -> 'vtkIdList': ...
    def GetPointIds(self) -> 'vtkIdList': ...
    def InsertPoint(self, points:'vtkPoints', newPnt:Sequence[float], maxPts:int, pntId:MutableSequence[int], ptMode:int, numberOfNodes:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsLeaf(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIncrementalOctreeNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIncrementalOctreeNode': ...
    def SetBounds(self, x1:float, x2:float, y1:float, y2:float, z1:float, z2:float) -> None: ...

class vtkIncrementalPointLocator(vtkAbstractPointLocator):
    def __init__(self, **properties:Any) -> None: ...
    def FindClosestInsertedPoint(self, x:Sequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def InitPointInsertion(self, newPts:'vtkPoints', bounds:Sequence[float]) -> int: ...
    @overload
    def InitPointInsertion(self, newPts:'vtkPoints', bounds:Sequence[float], estSize:int) -> int: ...
    def InsertNextPoint(self, x:Sequence[float]) -> int: ...
    def InsertPoint(self, ptId:int, x:Sequence[float]) -> None: ...
    def InsertUniquePoint(self, x:Sequence[float], ptId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsInsertedPoint(self, x:float, y:float, z:float) -> int: ...
    @overload
    def IsInsertedPoint(self, x:Sequence[float]) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIncrementalPointLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIncrementalPointLocator': ...

class vtkIncrementalOctreePointLocator(vtkIncrementalPointLocator):
    bounds:'getset_descriptor'
    build_cubic_octree:'getset_descriptor'
    locator_points:'getset_descriptor'
    max_points_per_leaf:'getset_descriptor'
    number_of_nodes:'getset_descriptor'
    number_of_points:'getset_descriptor'
    root:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildCubicOctreeOff(self) -> None: ...
    def BuildCubicOctreeOn(self) -> None: ...
    def BuildLocator(self) -> None: ...
    def FindClosestInsertedPoint(self, x:Sequence[float]) -> int: ...
    def FindClosestNPoints(self, N:int, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def FindClosestPoint(self, x:float, y:float, z:float) -> int: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float], miniDist2:MutableSequence[float]) -> int: ...
    @overload
    def FindClosestPoint(self, x:float, y:float, z:float, miniDist2:MutableSequence[float]) -> int: ...
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], dist2:float) -> int: ...
    def FindClosestPointWithinSquaredRadius(self, radius2:float, x:Sequence[float], dist2:float) -> int: ...
    def FindPointsWithinRadius(self, R:float, x:Sequence[float], result:'vtkIdList') -> None: ...
    def FindPointsWithinSquaredRadius(self, R2:float, x:Sequence[float], result:'vtkIdList') -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, polysData:'vtkPolyData') -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Pointer: ...
    def GetBuildCubicOctree(self) -> int: ...
    def GetLocatorPoints(self) -> 'vtkPoints': ...
    def GetMaxPointsPerLeaf(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def GetNumberOfNodes(self) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetRoot(self) -> 'vtkIncrementalOctreeNode': ...
    @overload
    def InitPointInsertion(self, points:'vtkPoints', bounds:Sequence[float]) -> int: ...
    @overload
    def InitPointInsertion(self, points:'vtkPoints', bounds:Sequence[float], estSize:int) -> int: ...
    def Initialize(self) -> None: ...
    def InsertNextPoint(self, x:Sequence[float]) -> int: ...
    def InsertPoint(self, ptId:int, x:Sequence[float]) -> None: ...
    def InsertPointWithoutChecking(self, point:Sequence[float], pntId:int, insert:int) -> None: ...
    def InsertUniquePoint(self, point:Sequence[float], pntId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsInsertedPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def IsInsertedPoint(self, x:float, y:float, z:float) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIncrementalOctreePointLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIncrementalOctreePointLocator': ...
    def SetBuildCubicOctree(self, _arg:int) -> None: ...
    def SetMaxPointsPerLeaf(self, _arg:int) -> None: ...

class vtkInformationQuadratureSchemeDefinitionVectorKey(vtkmodules.vtkCommonCore.vtkInformationKey):
    def __init__(self, **properties:Any) -> None: ...
    def Append(self, info:'vtkInformation', value:'vtkQuadratureSchemeDefinition') -> None: ...
    def Clear(self, info:'vtkInformation') -> None: ...
    def DeepCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...
    def Get(self, info:'vtkInformation', idx:int) -> 'vtkQuadratureSchemeDefinition': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Length(self, info:'vtkInformation') -> int: ...
    def NewInstance(self) -> 'vtkInformationQuadratureSchemeDefinitionVectorKey': ...
    def Resize(self, info:'vtkInformation', n:int) -> None: ...
    def RestoreState(self, info:'vtkInformation', element:'vtkXMLDataElement') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationQuadratureSchemeDefinitionVectorKey': ...
    def SaveState(self, info:'vtkInformation', element:'vtkXMLDataElement') -> int: ...
    def Set(self, info:'vtkInformation', value:'vtkQuadratureSchemeDefinition', i:int) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...
    def Size(self, info:'vtkInformation') -> int: ...

class vtkIntersectionCounter(object):
    tolerance:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tol:float, length:float) -> None: ...
    @overload
    def __init__(self, __a:'vtkIntersectionCounter') -> None: ...
    def AddIntersection(self, t:float) -> None: ...
    def CountIntersections(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def Reset(self) -> None: ...
    def SetTolerance(self, tol:float) -> None: ...

class vtkIterativeClosestPointTransform(vtkmodules.vtkCommonTransforms.vtkLinearTransform):
    check_mean_distance:'getset_descriptor'
    landmark_transform:'getset_descriptor'
    locator:'getset_descriptor'
    maximum_mean_distance:'getset_descriptor'
    maximum_number_of_iterations:'getset_descriptor'
    maximum_number_of_landmarks:'getset_descriptor'
    mean_distance:'getset_descriptor'
    mean_distance_mode:'getset_descriptor'
    number_of_iterations:'getset_descriptor'
    source:'getset_descriptor'
    start_by_matching_centroids:'getset_descriptor'
    target:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CheckMeanDistanceOff(self) -> None: ...
    def CheckMeanDistanceOn(self) -> None: ...
    def GetCheckMeanDistance(self) -> int: ...
    def GetLandmarkTransform(self) -> 'vtkLandmarkTransform': ...
    def GetLocator(self) -> 'vtkCellLocator': ...
    def GetMaximumMeanDistance(self) -> float: ...
    def GetMaximumNumberOfIterations(self) -> int: ...
    def GetMaximumNumberOfLandmarks(self) -> int: ...
    def GetMeanDistance(self) -> float: ...
    def GetMeanDistanceMode(self) -> int: ...
    def GetMeanDistanceModeAsString(self) -> str: ...
    def GetMeanDistanceModeMaxValue(self) -> int: ...
    def GetMeanDistanceModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetSource(self) -> 'vtkDataSet': ...
    def GetStartByMatchingCentroids(self) -> int: ...
    def GetTarget(self) -> 'vtkDataSet': ...
    def Inverse(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeTransform(self) -> 'vtkAbstractTransform': ...
    def NewInstance(self) -> 'vtkIterativeClosestPointTransform': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIterativeClosestPointTransform': ...
    def SetCheckMeanDistance(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkCellLocator') -> None: ...
    def SetMaximumMeanDistance(self, _arg:float) -> None: ...
    def SetMaximumNumberOfIterations(self, _arg:int) -> None: ...
    def SetMaximumNumberOfLandmarks(self, _arg:int) -> None: ...
    def SetMeanDistanceMode(self, _arg:int) -> None: ...
    def SetMeanDistanceModeToAbsoluteValue(self) -> None: ...
    def SetMeanDistanceModeToRMS(self) -> None: ...
    def SetSource(self, source:'vtkDataSet') -> None: ...
    def SetStartByMatchingCentroids(self, _arg:int) -> None: ...
    def SetTarget(self, target:'vtkDataSet') -> None: ...
    def StartByMatchingCentroidsOff(self) -> None: ...
    def StartByMatchingCentroidsOn(self) -> None: ...

class vtkKdNode(vtkmodules.vtkCommonCore.vtkObject):
    bounds:'getset_descriptor'
    data_bounds:'getset_descriptor'
    dim:'getset_descriptor'
    division_position:'getset_descriptor'
    id:'getset_descriptor'
    left:'getset_descriptor'
    max_bounds:'getset_descriptor'
    max_data_bounds:'getset_descriptor'
    max_id:'getset_descriptor'
    min_bounds:'getset_descriptor'
    min_data_bounds:'getset_descriptor'
    min_id:'getset_descriptor'
    number_of_points:'getset_descriptor'
    right:'getset_descriptor'
    up:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddChildNodes(self, left:'vtkKdNode', right:'vtkKdNode') -> None: ...
    def ContainsBox(self, x1:float, x2:float, y1:float, y2:float, z1:float, z2:float, useDataBounds:int) -> int: ...
    def ContainsPoint(self, x:float, y:float, z:float, useDataBounds:int) -> int: ...
    def DeleteChildNodes(self) -> None: ...
    def GetBounds(self, b:MutableSequence[float]) -> None: ...
    def GetDataBounds(self, b:MutableSequence[float]) -> None: ...
    def GetDim(self) -> int: ...
    @overload
    def GetDistance2ToBoundary(self, x:float, y:float, z:float, useDataBounds:int) -> float: ...
    @overload
    def GetDistance2ToBoundary(self, x:float, y:float, z:float, boundaryPt:MutableSequence[float], useDataBounds:int) -> float: ...
    def GetDistance2ToInnerBoundary(self, x:float, y:float, z:float) -> float: ...
    def GetDivisionPosition(self) -> float: ...
    def GetID(self) -> int: ...
    def GetLeft(self) -> 'vtkKdNode': ...
    def GetMaxBounds(self) -> Tuple[float, float, float]: ...
    def GetMaxDataBounds(self) -> Tuple[float, float, float]: ...
    def GetMaxID(self) -> int: ...
    def GetMinBounds(self) -> Tuple[float, float, float]: ...
    def GetMinDataBounds(self) -> Tuple[float, float, float]: ...
    def GetMinID(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetRight(self) -> 'vtkKdNode': ...
    def GetUp(self) -> 'vtkKdNode': ...
    def IntersectsBox(self, x1:float, x2:float, y1:float, y2:float, z1:float, z2:float, useDataBounds:int) -> int: ...
    def IntersectsCell(self, cell:'vtkCell', useDataBounds:int, cellRegion:int=-1, cellBounds:MutableSequence[float]=...) -> int: ...
    def IntersectsRegion(self, pi:'vtkPlanesIntersection', useDataBounds:int) -> int: ...
    def IntersectsSphere2(self, x:float, y:float, z:float, rSquared:float, useDataBounds:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkKdNode': ...
    def PrintNode(self, depth:int) -> None: ...
    def PrintVerboseNode(self, depth:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkKdNode': ...
    @overload
    def SetBounds(self, x1:float, x2:float, y1:float, y2:float, z1:float, z2:float) -> None: ...
    @overload
    def SetBounds(self, b:Sequence[float]) -> None: ...
    @overload
    def SetDataBounds(self, x1:float, x2:float, y1:float, y2:float, z1:float, z2:float) -> None: ...
    @overload
    def SetDataBounds(self, v:MutableSequence[float]) -> None: ...
    def SetDim(self, _arg:int) -> None: ...
    def SetID(self, _arg:int) -> None: ...
    def SetLeft(self, left:'vtkKdNode') -> None: ...
    def SetMaxBounds(self, mb:Sequence[float]) -> None: ...
    def SetMaxDataBounds(self, mb:Sequence[float]) -> None: ...
    def SetMaxID(self, _arg:int) -> None: ...
    def SetMinBounds(self, mb:Sequence[float]) -> None: ...
    def SetMinDataBounds(self, mb:Sequence[float]) -> None: ...
    def SetMinID(self, _arg:int) -> None: ...
    def SetNumberOfPoints(self, _arg:int) -> None: ...
    def SetRight(self, right:'vtkKdNode') -> None: ...
    def SetUp(self, up:'vtkKdNode') -> None: ...

class vtkKdTree(vtkLocator):
    cuts:'getset_descriptor'
    data_set:'getset_descriptor'
    data_sets:'getset_descriptor'
    fudge_factor:'getset_descriptor'
    generate_representation_using_data_bounds:'getset_descriptor'
    include_region_boundary_cells:'getset_descriptor'
    min_cells:'getset_descriptor'
    new_bounds:'getset_descriptor'
    number_of_regions:'getset_descriptor'
    number_of_regions_or_less:'getset_descriptor'
    number_of_regions_or_more:'getset_descriptor'
    timing:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddDataSet(self, set:'vtkDataSet') -> None: ...
    def AllGetRegionContainingCell(self) -> Pointer: ...
    def BuildLocator(self) -> None: ...
    @overload
    def BuildLocatorFromPoints(self, pointset:'vtkPointSet') -> None: ...
    @overload
    def BuildLocatorFromPoints(self, ptArray:'vtkPoints') -> None: ...
    def BuildMapForDuplicatePoints(self, tolerance:float) -> 'vtkIdTypeArray': ...
    @staticmethod
    def CopyTree(kd:'vtkKdNode') -> 'vtkKdNode': ...
    @overload
    def CreateCellLists(self, dataSetIndex:int, regionReqList:MutableSequence[int], reqListSize:int) -> None: ...
    @overload
    def CreateCellLists(self, set:'vtkDataSet', regionReqList:MutableSequence[int], reqListSize:int) -> None: ...
    @overload
    def CreateCellLists(self, regionReqList:MutableSequence[int], listSize:int) -> None: ...
    @overload
    def CreateCellLists(self) -> None: ...
    def DeleteCellLists(self) -> None: ...
    def FindClosestNPoints(self, N:int, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:MutableSequence[float], dist2:float) -> int: ...
    @overload
    def FindClosestPoint(self, x:float, y:float, z:float, dist2:float) -> int: ...
    @overload
    def FindClosestPointInRegion(self, regionId:int, x:MutableSequence[float], dist2:float) -> int: ...
    @overload
    def FindClosestPointInRegion(self, regionId:int, x:float, y:float, z:float, dist2:float) -> int: ...
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], dist2:float) -> int: ...
    @overload
    def FindPoint(self, x:MutableSequence[float]) -> int: ...
    @overload
    def FindPoint(self, x:float, y:float, z:float) -> int: ...
    def FindPointsInArea(self, area:MutableSequence[float], ids:'vtkIdTypeArray', clearArray:bool=True) -> None: ...
    def FindPointsWithinRadius(self, R:float, x:Sequence[float], result:'vtkIdList') -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    @overload
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    @overload
    def GenerateRepresentation(self, regionList:MutableSequence[int], len:int, pd:'vtkPolyData') -> None: ...
    def GenerateRepresentationUsingDataBoundsOff(self) -> None: ...
    def GenerateRepresentationUsingDataBoundsOn(self) -> None: ...
    def GetBoundaryCellList(self, regionID:int) -> 'vtkIdList': ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCellList(self, regionID:int) -> 'vtkIdList': ...
    @overload
    def GetCellLists(self, regions:'vtkIntArray', set:int, inRegionCells:'vtkIdList', onBoundaryCells:'vtkIdList') -> int: ...
    @overload
    def GetCellLists(self, regions:'vtkIntArray', set:'vtkDataSet', inRegionCells:'vtkIdList', onBoundaryCells:'vtkIdList') -> int: ...
    @overload
    def GetCellLists(self, regions:'vtkIntArray', inRegionCells:'vtkIdList', onBoundaryCells:'vtkIdList') -> int: ...
    def GetCuts(self) -> 'vtkBSPCuts': ...
    @overload
    def GetDataSet(self, n:int) -> 'vtkDataSet': ...
    @overload
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetDataSetIndex(self, set:'vtkDataSet') -> int: ...
    def GetDataSets(self) -> 'vtkDataSetCollection': ...
    def GetFudgeFactor(self) -> float: ...
    def GetGenerateRepresentationUsingDataBounds(self) -> int: ...
    def GetIncludeRegionBoundaryCells(self) -> int: ...
    def GetMinCells(self) -> int: ...
    def GetNumberOfDataSets(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRegions(self) -> int: ...
    def GetNumberOfRegionsOrLess(self) -> int: ...
    def GetNumberOfRegionsOrMore(self) -> int: ...
    def GetPointsInRegion(self, regionId:int) -> 'vtkIdTypeArray': ...
    def GetRegionBounds(self, regionID:int, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetRegionContainingCell(self, set:'vtkDataSet', cellID:int) -> int: ...
    @overload
    def GetRegionContainingCell(self, set:int, cellID:int) -> int: ...
    @overload
    def GetRegionContainingCell(self, cellID:int) -> int: ...
    def GetRegionContainingPoint(self, x:float, y:float, z:float) -> int: ...
    def GetRegionDataBounds(self, regionID:int, bounds:MutableSequence[float]) -> None: ...
    def GetTiming(self) -> int: ...
    def IncludeRegionBoundaryCellsOff(self) -> None: ...
    def IncludeRegionBoundaryCellsOn(self) -> None: ...
    def InvalidateGeometry(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewGeometry(self) -> int: ...
    def NewInstance(self) -> 'vtkKdTree': ...
    def OmitNoPartitioning(self) -> None: ...
    def OmitXPartitioning(self) -> None: ...
    def OmitXYPartitioning(self) -> None: ...
    def OmitYPartitioning(self) -> None: ...
    def OmitYZPartitioning(self) -> None: ...
    def OmitZPartitioning(self) -> None: ...
    def OmitZXPartitioning(self) -> None: ...
    def PrintRegion(self, id:int) -> None: ...
    def PrintTree(self) -> None: ...
    def PrintVerboseTree(self) -> None: ...
    def RemoveAllDataSets(self) -> None: ...
    @overload
    def RemoveDataSet(self, index:int) -> None: ...
    @overload
    def RemoveDataSet(self, set:'vtkDataSet') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkKdTree': ...
    def SetCuts(self, cuts:'vtkBSPCuts') -> None: ...
    def SetDataSet(self, set:'vtkDataSet') -> None: ...
    def SetFudgeFactor(self, _arg:float) -> None: ...
    def SetGenerateRepresentationUsingDataBounds(self, _arg:int) -> None: ...
    def SetIncludeRegionBoundaryCells(self, _arg:int) -> None: ...
    def SetMinCells(self, _arg:int) -> None: ...
    def SetNewBounds(self, bounds:MutableSequence[float]) -> None: ...
    def SetNumberOfRegionsOrLess(self, _arg:int) -> None: ...
    def SetNumberOfRegionsOrMore(self, _arg:int) -> None: ...
    def SetTiming(self, _arg:int) -> None: ...
    def TimingOff(self) -> None: ...
    def TimingOn(self) -> None: ...
    def ViewOrderAllRegionsFromPosition(self, directionOfProjection:Sequence[float], orderedList:'vtkIntArray') -> int: ...
    def ViewOrderAllRegionsInDirection(self, directionOfProjection:Sequence[float], orderedList:'vtkIntArray') -> int: ...
    def ViewOrderRegionsFromPosition(self, regionIds:'vtkIntArray', directionOfProjection:Sequence[float], orderedList:'vtkIntArray') -> int: ...
    def ViewOrderRegionsInDirection(self, regionIds:'vtkIntArray', directionOfProjection:Sequence[float], orderedList:'vtkIntArray') -> int: ...

class vtkKdTreePointLocator(vtkAbstractPointLocator):
    def __init__(self, **properties:Any) -> None: ...
    def BuildLocator(self) -> None: ...
    def FindClosestNPoints(self, N:int, x:Sequence[float], result:'vtkIdList') -> None: ...
    def FindClosestPoint(self, x:Sequence[float]) -> int: ...
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], dist2:float) -> int: ...
    def FindPointsWithinRadius(self, R:float, x:Sequence[float], result:'vtkIdList') -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkKdTreePointLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkKdTreePointLocator': ...

class vtkLagrangeCurve(vtkHigherOrderCurve):
    cell_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangeCurve': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangeCurve': ...

class vtkLagrangeHexahedron(vtkHigherOrderHexahedron):
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    face_cell:'getset_descriptor'
    interpolation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFaceCell(self) -> 'vtkHigherOrderQuadrilateral': ...
    def GetInterpolation(self) -> 'vtkHigherOrderInterpolation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangeHexahedron': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangeHexahedron': ...

class vtkLagrangeInterpolation(vtkHigherOrderInterpolation):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def EvaluateShapeAndGradient(order:int, pcoord:float, shape:MutableSequence[float], grad:MutableSequence[float]) -> None: ...
    @staticmethod
    def EvaluateShapeFunctions(order:int, pcoord:float, shape:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangeInterpolation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangeInterpolation': ...
    @staticmethod
    def Tensor1ShapeDerivatives(order:(int), pcoords:Sequence[float], derivs:MutableSequence[float]) -> int: ...
    @staticmethod
    def Tensor1ShapeFunctions(order:(int), pcoords:Sequence[float], shape:MutableSequence[float]) -> int: ...
    @staticmethod
    def Tensor2ShapeDerivatives(order:Sequence[int], pcoords:Sequence[float], derivs:MutableSequence[float]) -> int: ...
    @staticmethod
    def Tensor2ShapeFunctions(order:Sequence[int], pcoords:Sequence[float], shape:MutableSequence[float]) -> int: ...
    def Tensor3EvaluateDerivative(self, order:Sequence[int], pcoords:Sequence[float], points:'vtkPoints', fieldVals:Sequence[float], fieldDim:int, fieldDerivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def Tensor3ShapeDerivatives(order:Sequence[int], pcoords:Sequence[float], derivs:MutableSequence[float]) -> int: ...
    @staticmethod
    def Tensor3ShapeFunctions(order:Sequence[int], pcoords:Sequence[float], shape:MutableSequence[float]) -> int: ...
    def WedgeEvaluate(self, order:Sequence[int], numberOfPoints:int, pcoords:Sequence[float], fieldVals:MutableSequence[float], fieldDim:int, fieldAtPCoords:MutableSequence[float]) -> None: ...
    def WedgeEvaluateDerivative(self, order:Sequence[int], pcoords:Sequence[float], points:'vtkPoints', fieldVals:Sequence[float], fieldDim:int, fieldDerivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def WedgeShapeDerivatives(order:Sequence[int], numberOfPoints:int, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def WedgeShapeFunctions(order:Sequence[int], numberOfPoints:int, pcoords:Sequence[float], shape:MutableSequence[float]) -> None: ...

class vtkLagrangeQuadrilateral(vtkHigherOrderQuadrilateral):
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangeQuadrilateral': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangeQuadrilateral': ...

class vtkLagrangeTetra(vtkHigherOrderTetra):
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    face_cell:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFaceCell(self) -> 'vtkHigherOrderTriangle': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangeTetra': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangeTetra': ...

class vtkLagrangeTriangle(vtkHigherOrderTriangle):
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangeTriangle': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangeTriangle': ...

class vtkLagrangeWedge(vtkHigherOrderWedge):
    boundary_quad:'getset_descriptor'
    boundary_tri:'getset_descriptor'
    cell_type:'getset_descriptor'
    edge_cell:'getset_descriptor'
    interpolation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBoundaryQuad(self) -> 'vtkHigherOrderQuadrilateral': ...
    def GetBoundaryTri(self) -> 'vtkHigherOrderTriangle': ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeCell(self) -> 'vtkHigherOrderCurve': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetInterpolation(self) -> 'vtkHigherOrderInterpolation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangeWedge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangeWedge': ...

class vtkLine(vtkCell):
    class ToleranceType(int): ...
    class IntersectionType(int): ...
    Absolute:'ToleranceType'
    AbsoluteFuzzy:'ToleranceType'
    Intersect:'IntersectionType'
    NoIntersect:'IntersectionType'
    OnLine:'IntersectionType'
    Relative:'ToleranceType'
    RelativeFuzzy:'ToleranceType'
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', lines:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def DistanceBetweenLineSegments(l0:MutableSequence[float], l1:MutableSequence[float], m0:MutableSequence[float], m1:MutableSequence[float], closestPt1:MutableSequence[float], closestPt2:MutableSequence[float], t1:float, t2:float) -> float: ...
    @staticmethod
    def DistanceBetweenLines(l0:MutableSequence[float], l1:MutableSequence[float], m0:MutableSequence[float], m1:MutableSequence[float], closestPt1:MutableSequence[float], closestPt2:MutableSequence[float], t1:float, t2:float) -> float: ...
    @overload
    @staticmethod
    def DistanceToLine(x:Sequence[float], p1:Sequence[float], p2:Sequence[float], t:float, closestPoint:MutableSequence[float]=...) -> float: ...
    @overload
    @staticmethod
    def DistanceToLine(x:Sequence[float], p1:Sequence[float], p2:Sequence[float]) -> float: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def Inflate(self, dist:float) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    @staticmethod
    def Intersection(p1:Sequence[float], p2:Sequence[float], x1:Sequence[float], x2:Sequence[float], u:float, v:float, tolerance:float=1e-6, toleranceType:int=...) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLine': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLine': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkMarchingCubesPolygonCases(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkMarchingCubesPolygonCases') -> None: ...

class vtkMarchingCubesTriangleCases(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkMarchingCubesTriangleCases') -> None: ...

class vtkMarchingSquaresLineCases(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkMarchingSquaresLineCases') -> None: ...

class vtkMeanValueCoordinatesInterpolator(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def ComputeInterpolationWeights(x:Sequence[float], pts:'vtkPoints', tris:'vtkIdList', weights:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ComputeInterpolationWeights(x:Sequence[float], pts:'vtkPoints', tris:'vtkCellArray', weights:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMeanValueCoordinatesInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMeanValueCoordinatesInterpolator': ...

class vtkPointLocator(vtkIncrementalPointLocator):
    divisions:'getset_descriptor'
    number_of_points_per_bucket:'getset_descriptor'
    points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildLocator(self) -> None: ...
    def FindClosestInsertedPoint(self, x:Sequence[float]) -> int: ...
    def FindClosestNPoints(self, N:int, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def FindClosestPoint(self, x:float, y:float, z:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], dist2:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], inputDataLength:float, dist2:float) -> int: ...
    @overload
    def FindDistributedPoints(self, N:int, x:Sequence[float], result:'vtkIdList', M:int) -> None: ...
    @overload
    def FindDistributedPoints(self, N:int, x:float, y:float, z:float, result:'vtkIdList', M:int) -> None: ...
    def FindPointsWithinRadius(self, R:float, x:Sequence[float], result:'vtkIdList') -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    def GetDivisions(self) -> Tuple[int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointsPerBucket(self) -> int: ...
    def GetNumberOfPointsPerBucketMaxValue(self) -> int: ...
    def GetNumberOfPointsPerBucketMinValue(self) -> int: ...
    def GetPoints(self) -> 'vtkPoints': ...
    def GetPointsInBucket(self, x:Sequence[float], ijk:MutableSequence[int]) -> 'vtkIdList': ...
    @overload
    def InitPointInsertion(self, newPts:'vtkPoints', bounds:Sequence[float]) -> int: ...
    @overload
    def InitPointInsertion(self, newPts:'vtkPoints', bounds:Sequence[float], estNumPts:int) -> int: ...
    def Initialize(self) -> None: ...
    def InsertNextPoint(self, x:Sequence[float]) -> int: ...
    def InsertPoint(self, ptId:int, x:Sequence[float]) -> None: ...
    def InsertUniquePoint(self, x:Sequence[float], ptId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsInsertedPoint(self, x:float, y:float, z:float) -> int: ...
    @overload
    def IsInsertedPoint(self, x:Sequence[float]) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointLocator': ...
    @overload
    def SetDivisions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetDivisions(self, _arg:Sequence[int]) -> None: ...
    def SetNumberOfPointsPerBucket(self, _arg:int) -> None: ...

class vtkMergePoints(vtkPointLocator):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InsertUniquePoint(self, x:Sequence[float], ptId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsInsertedPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def IsInsertedPoint(self, x:float, y:float, z:float) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergePoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergePoints': ...

class vtkUndirectedGraph(vtkGraph):
    data_object_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkUndirectedGraph': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkUndirectedGraph': ...
    def GetDataObjectType(self) -> int: ...
    def GetInDegree(self, v:int) -> int: ...
    @overload
    def GetInEdge(self, v:int, i:int) -> 'vtkInEdgeType': ...
    @overload
    def GetInEdge(self, v:int, i:int, e:'vtkGraphEdge') -> None: ...
    def GetInEdges(self, v:int, it:'vtkInEdgeIterator') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsStructureValid(self, g:'vtkGraph') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUndirectedGraph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUndirectedGraph': ...

class vtkMolecule(vtkUndirectedGraph):
    actual_memory_size:'getset_descriptor'
    atom_data:'getset_descriptor'
    atom_ghost_array:'getset_descriptor'
    atomic_number_array:'getset_descriptor'
    atomic_number_array_name:'getset_descriptor'
    atomic_position_array:'getset_descriptor'
    bond_data:'getset_descriptor'
    bond_ghost_array:'getset_descriptor'
    bond_orders_array:'getset_descriptor'
    bond_orders_array_name:'getset_descriptor'
    data_object_type:'getset_descriptor'
    electronic_data:'getset_descriptor'
    lattice:'getset_descriptor'
    lattice_origin:'getset_descriptor'
    number_of_atoms:'getset_descriptor'
    number_of_bonds:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllocateAtomGhostArray(self) -> None: ...
    def AllocateBondGhostArray(self) -> None: ...
    @overload
    def AppendAtom(self) -> 'vtkAtom': ...
    @overload
    def AppendAtom(self, atomicNumber:int, x:float, y:float, z:float) -> 'vtkAtom': ...
    @overload
    def AppendAtom(self, atomicNumber:int, pos:'vtkVector3f') -> 'vtkAtom': ...
    @overload
    def AppendAtom(self, atomicNumber:int, pos:MutableSequence[float]) -> 'vtkAtom': ...
    @overload
    def AppendBond(self, atom1:int, atom2:int, order:int=1) -> 'vtkBond': ...
    @overload
    def AppendBond(self, atom1:'vtkAtom', atom2:'vtkAtom', order:int=1) -> 'vtkBond': ...
    def CheckedDeepCopy(self, g:'vtkGraph') -> bool: ...
    def CheckedShallowCopy(self, g:'vtkGraph') -> bool: ...
    def ClearLattice(self) -> None: ...
    def DeepCopy(self, obj:'vtkDataObject') -> None: ...
    def DeepCopyAttributes(self, m:'vtkMolecule') -> None: ...
    def DeepCopyStructure(self, m:'vtkMolecule') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetAtom(self, atomId:int) -> 'vtkAtom': ...
    def GetAtomAtomicNumber(self, atomId:int) -> int: ...
    def GetAtomData(self) -> 'vtkDataSetAttributes': ...
    def GetAtomGhostArray(self) -> 'vtkUnsignedCharArray': ...
    @overload
    def GetAtomPosition(self, atomId:int) -> 'vtkVector3f': ...
    @overload
    def GetAtomPosition(self, atomId:int, pos:MutableSequence[float]) -> None: ...
    def GetAtomicNumberArray(self) -> 'vtkUnsignedShortArray': ...
    def GetAtomicNumberArrayName(self) -> str: ...
    def GetAtomicPositionArray(self) -> 'vtkPoints': ...
    def GetBond(self, bondId:int) -> 'vtkBond': ...
    def GetBondData(self) -> 'vtkDataSetAttributes': ...
    def GetBondGhostArray(self) -> 'vtkUnsignedCharArray': ...
    def GetBondId(self, a:int, b:int) -> int: ...
    def GetBondLength(self, bondId:int) -> float: ...
    def GetBondOrder(self, bondId:int) -> int: ...
    def GetBondOrdersArray(self) -> 'vtkUnsignedShortArray': ...
    def GetBondOrdersArrayName(self) -> str: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkMolecule': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkMolecule': ...
    def GetDataObjectType(self) -> int: ...
    def GetElectronicData(self) -> 'vtkAbstractElectronicData': ...
    @overload
    def GetLattice(self) -> 'vtkMatrix3x3': ...
    @overload
    def GetLattice(self, a:'vtkVector3d', b:'vtkVector3d', c:'vtkVector3d') -> None: ...
    @overload
    def GetLattice(self, a:'vtkVector3d', b:'vtkVector3d', c:'vtkVector3d', origin:'vtkVector3d') -> None: ...
    def GetLatticeOrigin(self) -> 'vtkVector3d': ...
    def GetNumberOfAtoms(self) -> int: ...
    def GetNumberOfBonds(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    @staticmethod
    def GetPlaneFromBond(bond:'vtkBond', normal:'vtkVector3f', plane:'vtkPlane') -> bool: ...
    @overload
    @staticmethod
    def GetPlaneFromBond(atom1:'vtkAtom', atom2:'vtkAtom', normal:'vtkVector3f', plane:'vtkPlane') -> bool: ...
    def HasLattice(self) -> bool: ...
    @overload
    def Initialize(self) -> None: ...
    @overload
    def Initialize(self, atomPositions:'vtkPoints', atomicNumberArray:'vtkDataArray', atomData:'vtkDataSetAttributes') -> int: ...
    @overload
    def Initialize(self, atomPositions:'vtkPoints', atomData:'vtkDataSetAttributes') -> int: ...
    @overload
    def Initialize(self, molecule:'vtkMolecule') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMolecule': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMolecule': ...
    def SetAtomAtomicNumber(self, atomId:int, atomicNum:int) -> None: ...
    @overload
    def SetAtomPosition(self, atomId:int, pos:'vtkVector3f') -> None: ...
    @overload
    def SetAtomPosition(self, atomId:int, x:float, y:float, z:float) -> None: ...
    @overload
    def SetAtomPosition(self, atomId:int, pos:MutableSequence[float]) -> None: ...
    def SetAtomicNumberArrayName(self, _arg:str) -> None: ...
    def SetBondOrder(self, bondId:int, order:int) -> None: ...
    def SetBondOrdersArrayName(self, _arg:str) -> None: ...
    def SetElectronicData(self, __a:'vtkAbstractElectronicData') -> None: ...
    @overload
    def SetLattice(self, matrix:'vtkMatrix3x3') -> None: ...
    @overload
    def SetLattice(self, a:'vtkVector3d', b:'vtkVector3d', c:'vtkVector3d') -> None: ...
    def SetLatticeOrigin(self, _arg:'vtkVector3d') -> None: ...
    def ShallowCopy(self, obj:'vtkDataObject') -> None: ...
    def ShallowCopyAttributes(self, m:'vtkMolecule') -> None: ...
    def ShallowCopyStructure(self, m:'vtkMolecule') -> None: ...

class vtkMultiBlockDataSet(vtkDataObjectTree):
    data_object_type:'getset_descriptor'
    number_of_blocks:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBlock(self, blockno:int) -> 'vtkDataObject': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkMultiBlockDataSet': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkMultiBlockDataSet': ...
    def GetDataObjectType(self) -> int: ...
    @overload
    def GetMetaData(self, blockno:int) -> 'vtkInformation': ...
    @overload
    def GetMetaData(self, iter:'vtkCompositeDataIterator') -> 'vtkInformation': ...
    def GetNumberOfBlocks(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def HasMetaData(self, blockno:int) -> int: ...
    @overload
    def HasMetaData(self, iter:'vtkCompositeDataIterator') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiBlockDataSet': ...
    def RemoveBlock(self, blockno:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiBlockDataSet': ...
    def SetBlock(self, blockno:int, block:'vtkDataObject') -> None: ...
    def SetNumberOfBlocks(self, numBlocks:int) -> None: ...

class vtkPartitionedDataSet(vtkDataObjectTree):
    data_object_type:'getset_descriptor'
    number_of_partitions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkPartitionedDataSet': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkPartitionedDataSet': ...
    def GetDataObjectType(self) -> int: ...
    @overload
    def GetMetaData(self, idx:int) -> 'vtkInformation': ...
    @overload
    def GetMetaData(self, iter:'vtkCompositeDataIterator') -> 'vtkInformation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPartitions(self) -> int: ...
    def GetPartition(self, idx:int) -> 'vtkDataSet': ...
    def GetPartitionAsDataObject(self, idx:int) -> 'vtkDataObject': ...
    @overload
    def HasMetaData(self, idx:int) -> int: ...
    @overload
    def HasMetaData(self, iter:'vtkCompositeDataIterator') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPartitionedDataSet': ...
    def RemoveNullPartitions(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPartitionedDataSet': ...
    def SetNumberOfPartitions(self, numPartitions:int) -> None: ...
    def SetPartition(self, idx:int, partition:'vtkDataObject') -> None: ...

class vtkMultiPieceDataSet(vtkPartitionedDataSet):
    data_object_type:'getset_descriptor'
    number_of_pieces:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkMultiPieceDataSet': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkMultiPieceDataSet': ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetPiece(self, pieceno:int) -> 'vtkDataSet': ...
    def GetPieceAsDataObject(self, pieceno:int) -> 'vtkDataObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiPieceDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiPieceDataSet': ...
    def SetNumberOfPieces(self, numpieces:int) -> None: ...
    def SetPiece(self, pieceno:int, piece:'vtkDataObject') -> None: ...

class vtkMutableDirectedGraph(vtkDirectedGraph):
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddChild(self, parent:int, propertyArr:'vtkVariantArray') -> int: ...
    @overload
    def AddChild(self, parent:int) -> int: ...
    @overload
    def AddEdge(self, u:int, v:int) -> 'vtkEdgeType': ...
    @overload
    def AddEdge(self, u:int, v:int, propertyArr:'vtkVariantArray') -> 'vtkEdgeType': ...
    @overload
    def AddEdge(self, u:'vtkVariant', v:int, propertyArr:'vtkVariantArray'=...) -> 'vtkEdgeType': ...
    @overload
    def AddEdge(self, u:int, v:'vtkVariant', propertyArr:'vtkVariantArray'=...) -> 'vtkEdgeType': ...
    @overload
    def AddEdge(self, u:'vtkVariant', v:'vtkVariant', propertyArr:'vtkVariantArray'=...) -> 'vtkEdgeType': ...
    def AddGraphEdge(self, u:int, v:int) -> 'vtkGraphEdge': ...
    @overload
    def AddVertex(self) -> int: ...
    @overload
    def AddVertex(self, propertyArr:'vtkVariantArray') -> int: ...
    @overload
    def AddVertex(self, pedigreeId:'vtkVariant') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LazyAddEdge(self, u:int, v:int, propertyArr:'vtkVariantArray'=...) -> None: ...
    @overload
    def LazyAddEdge(self, u:'vtkVariant', v:int, propertyArr:'vtkVariantArray'=...) -> None: ...
    @overload
    def LazyAddEdge(self, u:int, v:'vtkVariant', propertyArr:'vtkVariantArray'=...) -> None: ...
    @overload
    def LazyAddEdge(self, u:'vtkVariant', v:'vtkVariant', propertyArr:'vtkVariantArray'=...) -> None: ...
    @overload
    def LazyAddVertex(self) -> None: ...
    @overload
    def LazyAddVertex(self, propertyArr:'vtkVariantArray') -> None: ...
    @overload
    def LazyAddVertex(self, pedigreeId:'vtkVariant') -> None: ...
    def NewInstance(self) -> 'vtkMutableDirectedGraph': ...
    def RemoveEdge(self, e:int) -> None: ...
    def RemoveEdges(self, arr:'vtkIdTypeArray') -> None: ...
    def RemoveVertex(self, v:int) -> None: ...
    def RemoveVertices(self, arr:'vtkIdTypeArray') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMutableDirectedGraph': ...
    def SetNumberOfVertices(self, numVerts:int) -> int: ...

class vtkMutableUndirectedGraph(vtkUndirectedGraph):
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddEdge(self, u:int, v:int) -> 'vtkEdgeType': ...
    @overload
    def AddEdge(self, u:int, v:int, propertyArr:'vtkVariantArray') -> 'vtkEdgeType': ...
    @overload
    def AddEdge(self, u:'vtkVariant', v:int, propertyArr:'vtkVariantArray'=...) -> 'vtkEdgeType': ...
    @overload
    def AddEdge(self, u:int, v:'vtkVariant', propertyArr:'vtkVariantArray'=...) -> 'vtkEdgeType': ...
    @overload
    def AddEdge(self, u:'vtkVariant', v:'vtkVariant', propertyArr:'vtkVariantArray'=...) -> 'vtkEdgeType': ...
    def AddGraphEdge(self, u:int, v:int) -> 'vtkGraphEdge': ...
    @overload
    def AddVertex(self) -> int: ...
    @overload
    def AddVertex(self, propertyArr:'vtkVariantArray') -> int: ...
    @overload
    def AddVertex(self, pedigreeId:'vtkVariant') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def LazyAddEdge(self, u:int, v:int) -> None: ...
    @overload
    def LazyAddEdge(self, u:int, v:int, propertyArr:'vtkVariantArray') -> None: ...
    @overload
    def LazyAddEdge(self, u:'vtkVariant', v:int, propertyArr:'vtkVariantArray'=...) -> None: ...
    @overload
    def LazyAddEdge(self, u:int, v:'vtkVariant', propertyArr:'vtkVariantArray'=...) -> None: ...
    @overload
    def LazyAddEdge(self, u:'vtkVariant', v:'vtkVariant', propertyArr:'vtkVariantArray'=...) -> None: ...
    @overload
    def LazyAddVertex(self) -> None: ...
    @overload
    def LazyAddVertex(self, propertyArr:'vtkVariantArray') -> None: ...
    @overload
    def LazyAddVertex(self, pedigreeId:'vtkVariant') -> None: ...
    def NewInstance(self) -> 'vtkMutableUndirectedGraph': ...
    def RemoveEdge(self, e:int) -> None: ...
    def RemoveEdges(self, arr:'vtkIdTypeArray') -> None: ...
    def RemoveVertex(self, v:int) -> None: ...
    def RemoveVertices(self, arr:'vtkIdTypeArray') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMutableUndirectedGraph': ...
    def SetNumberOfVertices(self, numVerts:int) -> int: ...

class vtkNonMergingPointLocator(vtkPointLocator):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InsertUniquePoint(self, x:Sequence[float], ptId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsInsertedPoint(self, __a:Sequence[float]) -> int: ...
    @overload
    def IsInsertedPoint(self, __a:float, __b:float, __c:float) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNonMergingPointLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNonMergingPointLocator': ...

class vtkNonOverlappingAMR(vtkUniformGridAMR):
    data_object_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkNonOverlappingAMR': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkNonOverlappingAMR': ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNonOverlappingAMR': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNonOverlappingAMR': ...

class vtkOctreePointLocator(vtkAbstractPointLocator):
    bounds:'getset_descriptor'
    create_cubic_octants:'getset_descriptor'
    fudge_factor:'getset_descriptor'
    maximum_points_per_region:'getset_descriptor'
    number_of_leaf_nodes:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildLocator(self) -> None: ...
    def FindClosestNPoints(self, N:int, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def FindClosestPoint(self, x:float, y:float, z:float, dist2:float) -> int: ...
    @overload
    def FindClosestPointInRegion(self, regionId:int, x:MutableSequence[float], dist2:float) -> int: ...
    @overload
    def FindClosestPointInRegion(self, regionId:int, x:float, y:float, z:float, dist2:float) -> int: ...
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], dist2:float) -> int: ...
    def FindPointsInArea(self, area:MutableSequence[float], ids:'vtkIdTypeArray', clearArray:bool=True) -> None: ...
    def FindPointsWithinRadius(self, radius:float, x:Sequence[float] , result:'vtkIdList') -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    @overload
    def GetBounds(self) -> Pointer: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCreateCubicOctants(self) -> int: ...
    def GetFudgeFactor(self) -> float: ...
    def GetMaximumPointsPerRegion(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLeafNodes(self) -> int: ...
    def GetPointsInRegion(self, leafNodeId:int) -> 'vtkIdTypeArray': ...
    def GetRegionBounds(self, regionID:int, bounds:MutableSequence[float]) -> None: ...
    def GetRegionContainingPoint(self, x:float, y:float, z:float) -> int: ...
    def GetRegionDataBounds(self, leafNodeID:int, bounds:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOctreePointLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOctreePointLocator': ...
    def SetCreateCubicOctants(self, _arg:int) -> None: ...
    def SetFudgeFactor(self, _arg:float) -> None: ...
    def SetMaximumPointsPerRegion(self, _arg:int) -> None: ...

class vtkOctreePointLocatorNode(vtkmodules.vtkCommonCore.vtkObject):
    bounds:'getset_descriptor'
    data_bounds:'getset_descriptor'
    id:'getset_descriptor'
    max_bounds:'getset_descriptor'
    max_data_bounds:'getset_descriptor'
    min_bounds:'getset_descriptor'
    min_data_bounds:'getset_descriptor'
    min_id:'getset_descriptor'
    number_of_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeOctreeNodeInformation(self, Parent:'vtkOctreePointLocatorNode', NextLeafId:int, NextMinId:int, coordinates:MutableSequence[float]) -> None: ...
    def ContainsPoint(self, x:float, y:float, z:float, useDataBounds:int) -> int: ...
    def CreateChildNodes(self) -> None: ...
    def DeleteChildNodes(self) -> None: ...
    def GetBounds(self, b:MutableSequence[float]) -> None: ...
    def GetChild(self, i:int) -> 'vtkOctreePointLocatorNode': ...
    def GetDataBounds(self, b:MutableSequence[float]) -> None: ...
    @overload
    def GetDistance2ToBoundary(self, x:float, y:float, z:float, top:'vtkOctreePointLocatorNode', useDataBounds:int) -> float: ...
    @overload
    def GetDistance2ToBoundary(self, x:float, y:float, z:float, boundaryPt:MutableSequence[float], top:'vtkOctreePointLocatorNode', useDataBounds:int) -> float: ...
    def GetDistance2ToInnerBoundary(self, x:float, y:float, z:float, top:'vtkOctreePointLocatorNode') -> float: ...
    def GetID(self) -> int: ...
    def GetMaxBounds(self) -> Pointer: ...
    def GetMaxDataBounds(self) -> Pointer: ...
    def GetMinBounds(self) -> Pointer: ...
    def GetMinDataBounds(self) -> Pointer: ...
    def GetMinID(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetSubOctantIndex(self, point:MutableSequence[float], CheckContainment:int) -> int: ...
    def IntersectsRegion(self, pi:'vtkPlanesIntersection', useDataBounds:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOctreePointLocatorNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOctreePointLocatorNode': ...
    @overload
    def SetBounds(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def SetBounds(self, b:Sequence[float]) -> None: ...
    def SetDataBounds(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    def SetMaxBounds(self, maxBounds:MutableSequence[float]) -> None: ...
    def SetMaxDataBounds(self, maxDataBounds:MutableSequence[float]) -> None: ...
    def SetMinBounds(self, minBounds:MutableSequence[float]) -> None: ...
    def SetMinDataBounds(self, minDataBounds:MutableSequence[float]) -> None: ...
    def SetNumberOfPoints(self, numberOfPoints:int) -> None: ...

class vtkOrderedTriangulator(vtkmodules.vtkCommonCore.vtkObject):
    number_of_points:'getset_descriptor'
    pre_sorted:'getset_descriptor'
    use_templates:'getset_descriptor'
    use_two_sort_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddTetras(self, classification:int, ugrid:'vtkUnstructuredGrid') -> int: ...
    @overload
    def AddTetras(self, classification:int, connectivity:'vtkCellArray') -> int: ...
    @overload
    def AddTetras(self, classification:int, locator:'vtkIncrementalPointLocator', outConnectivity:'vtkCellArray', inPD:'vtkPointData', outPD:'vtkPointData', inCD:'vtkCellData', cellId:int, outCD:'vtkCellData') -> int: ...
    @overload
    def AddTetras(self, classification:int, ptIds:'vtkIdList', pts:'vtkPoints') -> int: ...
    @overload
    def AddTetras(self, classification:int, ptIds:'vtkIdList') -> int: ...
    @overload
    def AddTriangles(self, connectivity:'vtkCellArray') -> int: ...
    @overload
    def AddTriangles(self, id:int, connectivity:'vtkCellArray') -> int: ...
    def GetNextTetra(self, classification:int, tet:'vtkTetra', cellScalars:'vtkDataArray', tetScalars:'vtkDoubleArray') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetPointId(self, internalId:int) -> int: ...
    def GetPointLocation(self, internalId:int) -> Pointer: ...
    def GetPointPosition(self, internalId:int) -> Pointer: ...
    def GetPreSorted(self) -> int: ...
    def GetTetras(self, classification:int, ugrid:'vtkUnstructuredGrid') -> int: ...
    def GetUseTemplates(self) -> int: ...
    def GetUseTwoSortIds(self) -> int: ...
    def InitTetraTraversal(self) -> None: ...
    @overload
    def InitTriangulation(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float, numPts:int) -> None: ...
    @overload
    def InitTriangulation(self, bounds:MutableSequence[float], numPts:int) -> None: ...
    @overload
    def InsertPoint(self, id:int, x:MutableSequence[float], p:MutableSequence[float], type:int) -> int: ...
    @overload
    def InsertPoint(self, id:int, sortid:int, x:MutableSequence[float], p:MutableSequence[float], type:int) -> int: ...
    @overload
    def InsertPoint(self, id:int, sortid:int, sortid2:int, x:MutableSequence[float], p:MutableSequence[float], type:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOrderedTriangulator': ...
    def PreSortedOff(self) -> None: ...
    def PreSortedOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrderedTriangulator': ...
    def SetPreSorted(self, _arg:int) -> None: ...
    def SetUseTemplates(self, _arg:int) -> None: ...
    def SetUseTwoSortIds(self, _arg:int) -> None: ...
    def TemplateTriangulate(self, cellType:int, numPts:int, numEdges:int) -> None: ...
    def Triangulate(self) -> None: ...
    def UpdatePointType(self, internalId:int, type:int) -> None: ...
    def UseTemplatesOff(self) -> None: ...
    def UseTemplatesOn(self) -> None: ...
    def UseTwoSortIdsOff(self) -> None: ...
    def UseTwoSortIdsOn(self) -> None: ...

class vtkOutEdgeIterator(vtkmodules.vtkCommonCore.vtkObject):
    graph:'getset_descriptor'
    vertex:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetGraph(self) -> 'vtkGraph': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVertex(self) -> int: ...
    def HasNext(self) -> bool: ...
    def Initialize(self, g:'vtkGraph', v:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOutEdgeIterator': ...
    def Next(self) -> 'vtkOutEdgeType': ...
    def NextGraphEdge(self) -> 'vtkGraphEdge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOutEdgeIterator': ...

class vtkOutEdgeType(vtkEdgeBase):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, t:int, id:int) -> None: ...
    @overload
    def __init__(self, __a:'vtkOutEdgeType') -> None: ...

class vtkPartitionedDataSetCollection(vtkDataObjectTree):
    data_assembly:'getset_descriptor'
    data_object_type:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_partitioned_data_sets:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CompositeShallowCopy(self, src:'vtkCompositeDataSet') -> None: ...
    def CopyStructure(self, input:'vtkCompositeDataSet') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @overload
    def GetCompositeIndex(self, idx:int) -> int: ...
    @overload
    def GetCompositeIndex(self, idx:int, partition:int) -> int: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkPartitionedDataSetCollection': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkPartitionedDataSetCollection': ...
    def GetDataAssembly(self) -> 'vtkDataAssembly': ...
    def GetDataObjectType(self) -> int: ...
    def GetMTime(self) -> int: ...
    @overload
    def GetMetaData(self, idx:int) -> 'vtkInformation': ...
    @overload
    def GetMetaData(self, iter:'vtkCompositeDataIterator') -> 'vtkInformation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPartitionedDataSets(self) -> int: ...
    def GetNumberOfPartitions(self, idx:int) -> int: ...
    def GetPartition(self, idx:int, partition:int) -> 'vtkDataSet': ...
    def GetPartitionAsDataObject(self, idx:int, partition:int) -> 'vtkDataObject': ...
    def GetPartitionedDataSet(self, idx:int) -> 'vtkPartitionedDataSet': ...
    @overload
    def HasMetaData(self, idx:int) -> int: ...
    @overload
    def HasMetaData(self, iter:'vtkCompositeDataIterator') -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPartitionedDataSetCollection': ...
    def RemovePartitionedDataSet(self, idx:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPartitionedDataSetCollection': ...
    def SetDataAssembly(self, assembly:'vtkDataAssembly') -> None: ...
    def SetNumberOfPartitionedDataSets(self, numDataSets:int) -> None: ...
    def SetNumberOfPartitions(self, idx:int, numPartitions:int) -> None: ...
    def SetPartition(self, idx:int, partition:int, object:'vtkDataObject') -> None: ...
    def SetPartitionedDataSet(self, idx:int, dataset:'vtkPartitionedDataSet') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...

class vtkPath(vtkPointSet):
    class ControlPointType(int): ...
    CONIC_CURVE:'ControlPointType'
    CUBIC_CURVE:'ControlPointType'
    LINE_TO:'ControlPointType'
    MOVE_TO:'ControlPointType'
    codes:'getset_descriptor'
    data_object_type:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    max_spatial_dimension:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Allocate(self, size:int=1000, extSize:int=1000) -> None: ...
    @overload
    def GetCell(self, __a:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, __a:int, __b:'vtkGenericCell') -> None: ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    @overload
    def GetCellPoints(self, __a:int, ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    def GetCellType(self, __a:int) -> int: ...
    def GetCodes(self) -> 'vtkIntArray': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkPath': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkPath': ...
    def GetDataObjectType(self) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    def GetMaxSpatialDimension(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointCells(self, ptId:int, cellIds:'vtkIdList') -> None: ...
    @overload
    def InsertNextPoint(self, pts:MutableSequence[float], code:int) -> None: ...
    @overload
    def InsertNextPoint(self, x:float, y:float, z:float, code:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPath': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPath': ...
    def SetCodes(self, __a:'vtkIntArray') -> None: ...

class vtkPentagonalPrism(vtkCell3D):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    @staticmethod
    def ComputeCentroid(points:'vtkPoints', pointIds:Sequence[int], centroid:MutableSequence[float]) -> bool: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, pts:Sequence[int]) -> None: ...
    @staticmethod
    def GetEdgeToAdjacentFacesArray(edgeId:int) -> Tuple[int, int]: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetFaceToAdjacentFacesArray(faceId:int) -> Tuple[int, int, int, int, int]: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetPointToIncidentEdges(self, pointId:int, edgeIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentEdgesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToIncidentFaces(self, pointId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentFacesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToOneRingPointsArray(pointId:int) -> Tuple[int, int, int]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInsideOut(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPentagonalPrism': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPentagonalPrism': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkPerlinNoise(vtkImplicitFunction):
    amplitude:'getset_descriptor'
    frequency:'getset_descriptor'
    phase:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def GetAmplitude(self) -> float: ...
    def GetFrequency(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhase(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPerlinNoise': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPerlinNoise': ...
    def SetAmplitude(self, _arg:float) -> None: ...
    @overload
    def SetFrequency(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetFrequency(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPhase(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPhase(self, _arg:Sequence[float]) -> None: ...

class vtkPiecewiseFunction(vtkDataObject):
    class SearchMethod(int): ...
    BINARY_SEARCH:'SearchMethod'
    INTERPOLATION_SEARCH:'SearchMethod'
    MAX_ENUM:'SearchMethod'
    allow_duplicate_scalars:'getset_descriptor'
    automatic_search_method:'getset_descriptor'
    clamping:'getset_descriptor'
    custom_search_method:'getset_descriptor'
    data_object_type:'getset_descriptor'
    data_pointer:'getset_descriptor'
    first_non_zero_value:'getset_descriptor'
    range:'getset_descriptor'
    size:'getset_descriptor'
    type:'getset_descriptor'
    use_custom_search_method:'getset_descriptor'
    use_log_scale:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddPoint(self, x:float, y:float) -> int: ...
    @overload
    def AddPoint(self, x:float, y:float, midpoint:float, sharpness:float) -> int: ...
    def AddSegment(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def AdjustRange(self, range:MutableSequence[float]) -> int: ...
    def AllowDuplicateScalarsOff(self) -> None: ...
    def AllowDuplicateScalarsOn(self) -> None: ...
    def BuildFunctionFromTable(self, x1:float, x2:float, size:int, table:MutableSequence[float], stride:int=1) -> None: ...
    def ClampingOff(self) -> None: ...
    def ClampingOn(self) -> None: ...
    def DeepCopy(self, f:'vtkDataObject') -> None: ...
    def EstimateMinNumberOfSamples(self, x1:float, x2:float) -> int: ...
    def FillFromDataPointer(self, __a:int, __b:MutableSequence[float]) -> None: ...
    def GetAllowDuplicateScalars(self) -> int: ...
    def GetAutomaticSearchMethod(self) -> int: ...
    def GetClamping(self) -> int: ...
    def GetCustomSearchMethod(self) -> int: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkPiecewiseFunction': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkPiecewiseFunction': ...
    def GetDataObjectType(self) -> int: ...
    def GetDataPointer(self) -> Pointer: ...
    def GetFirstNonZeroValue(self) -> float: ...
    def GetNodeValue(self, index:int, val:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetSize(self) -> int: ...
    def GetTable(self, x1:float, x2:float, size:int, table:MutableSequence[float], stride:int=1, logIncrements:int=0, epsilon:float=1e-5) -> None: ...
    def GetType(self) -> str: ...
    def GetUseLogScale(self) -> bool: ...
    def GetValue(self, x:float) -> float: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPiecewiseFunction': ...
    def RemoveAllPoints(self) -> None: ...
    @overload
    def RemovePoint(self, x:float) -> int: ...
    @overload
    def RemovePoint(self, x:float, y:float) -> int: ...
    def RemovePointByIndex(self, id:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPiecewiseFunction': ...
    def SetAllowDuplicateScalars(self, _arg:int) -> None: ...
    def SetClamping(self, _arg:int) -> None: ...
    def SetCustomSearchMethod(self, type:int) -> None: ...
    def SetNodeValue(self, index:int, val:MutableSequence[float]) -> int: ...
    def SetUseCustomSearchMethod(self, use:bool) -> None: ...
    def SetUseLogScale(self, _arg:bool) -> None: ...
    def ShallowCopy(self, f:'vtkDataObject') -> None: ...
    def UpdateSearchMethod(self, epsilon:float=1e-12, thresh:float=1e-4) -> None: ...
    def UseLogScaleOff(self) -> None: ...
    def UseLogScaleOn(self) -> None: ...

class vtkPixel(vtkCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def ComputeBoundingSphere(self, center:MutableSequence[float]) -> float: ...
    def ComputeNormal(self, n:MutableSequence[float]) -> int: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def Inflate(self, dist:float) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPixel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPixel': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkPixelExtent(object):
    data:'getset_descriptor'
    data_u:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other:'vtkPixelExtent') -> None: ...
    @overload
    def CellToNode(self) -> None: ...
    @overload
    @staticmethod
    def CellToNode(inputExt:'vtkPixelExtent') -> 'vtkPixelExtent': ...
    def Clear(self) -> None: ...
    @overload
    def Contains(self, other:'vtkPixelExtent') -> int: ...
    @overload
    def Contains(self, i:int, j:int) -> int: ...
    def Disjoint(self, other:'vtkPixelExtent') -> int: ...
    def Empty(self) -> int: ...
    def GetData(self) -> Pointer: ...
    def GetDataU(self) -> Pointer: ...
    def GetEndIndex(self, last:MutableSequence[int]) -> None: ...
    @overload
    def GetStartIndex(self, first:MutableSequence[int]) -> None: ...
    @overload
    def GetStartIndex(self, first:MutableSequence[int], origin:Sequence[int]) -> None: ...
    @overload
    def Grow(self, n:int) -> None: ...
    @overload
    def Grow(self, q:int, n:int) -> None: ...
    @overload
    @staticmethod
    def Grow(inputExt:'vtkPixelExtent', n:int) -> 'vtkPixelExtent': ...
    @overload
    @staticmethod
    def Grow(inputExt:'vtkPixelExtent', problemDomain:'vtkPixelExtent', n:int) -> 'vtkPixelExtent': ...
    @overload
    def GrowHigh(self, q:int, n:int) -> None: ...
    @overload
    @staticmethod
    def GrowHigh(ext:'vtkPixelExtent', q:int, n:int) -> 'vtkPixelExtent': ...
    @overload
    def GrowLow(self, q:int, n:int) -> None: ...
    @overload
    @staticmethod
    def GrowLow(ext:'vtkPixelExtent', q:int, n:int) -> 'vtkPixelExtent': ...
    @overload
    def NodeToCell(self) -> None: ...
    @overload
    @staticmethod
    def NodeToCell(inputExt:'vtkPixelExtent') -> 'vtkPixelExtent': ...
    def SetData(self, ext:'vtkPixelExtent') -> None: ...
    @overload
    def Shift(self) -> None: ...
    @overload
    def Shift(self, ext:'vtkPixelExtent') -> None: ...
    @overload
    def Shift(self, n:MutableSequence[int]) -> None: ...
    @overload
    def Shift(self, q:int, n:int) -> None: ...
    @overload
    @staticmethod
    def Shift(ij:MutableSequence[int], n:int) -> None: ...
    @overload
    @staticmethod
    def Shift(ij:MutableSequence[int], n:MutableSequence[int]) -> None: ...
    @overload
    def Shrink(self, n:int) -> None: ...
    @overload
    def Shrink(self, q:int, n:int) -> None: ...
    @overload
    @staticmethod
    def Shrink(inputExt:'vtkPixelExtent', problemDomain:'vtkPixelExtent', n:int) -> 'vtkPixelExtent': ...
    @overload
    @staticmethod
    def Shrink(inputExt:'vtkPixelExtent', n:int) -> 'vtkPixelExtent': ...
    @overload
    def Size(self) -> int: ...
    @overload
    @staticmethod
    def Size(ext:'vtkPixelExtent') -> int: ...
    def Split(self, dir:int) -> 'vtkPixelExtent': ...

class vtkPixelTransfer(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkPixelTransfer') -> None: ...
    @overload
    @staticmethod
    def Blit(ext:'vtkPixelExtent', nComps:int, srcType:int, srcData:Pointer, destType:int, destData:Pointer) -> int: ...
    @overload
    @staticmethod
    def Blit(srcWhole:'vtkPixelExtent', srcSubset:'vtkPixelExtent', destWhole:'vtkPixelExtent', destSubset:'vtkPixelExtent', nSrcComps:int, srcType:int, srcData:Pointer, nDestComps:int, destType:int, destData:Pointer) -> int: ...

class vtkPlane(vtkImplicitFunction):
    normal:'getset_descriptor'
    origin:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ComputeBestFittingPlane(pts:'vtkPoints', origin:MutableSequence[float], normal:MutableSequence[float]) -> bool: ...
    @overload
    @staticmethod
    def DistanceToPlane(x:MutableSequence[float], n:MutableSequence[float], p0:MutableSequence[float]) -> float: ...
    @overload
    def DistanceToPlane(self, x:MutableSequence[float]) -> float: ...
    @staticmethod
    def Evaluate(normal:MutableSequence[float], origin:MutableSequence[float], x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def GeneralizedProjectPoint(x:Sequence[float], origin:Sequence[float], normal:Sequence[float], xproj:MutableSequence[float]) -> None: ...
    @overload
    def GeneralizedProjectPoint(self, x:Sequence[float], xproj:MutableSequence[float]) -> None: ...
    def GetNormal(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    @staticmethod
    def IntersectWithFinitePlane(n:MutableSequence[float], o:MutableSequence[float], pOrigin:MutableSequence[float], px:MutableSequence[float], py:MutableSequence[float], x0:MutableSequence[float], x1:MutableSequence[float]) -> int: ...
    @overload
    def IntersectWithFinitePlane(self, pOrigin:MutableSequence[float], px:MutableSequence[float], py:MutableSequence[float], x0:MutableSequence[float], x1:MutableSequence[float]) -> int: ...
    @overload
    @staticmethod
    def IntersectWithLine(p1:Sequence[float], p2:Sequence[float], n:MutableSequence[float], p0:MutableSequence[float], t:float, x:MutableSequence[float]) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], t:float, x:MutableSequence[float]) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlane': ...
    @overload
    @staticmethod
    def ProjectPoint(x:Sequence[float], origin:Sequence[float] , normal:Sequence[float], xproj:MutableSequence[float]) -> None: ...
    @overload
    def ProjectPoint(self, x:Sequence[float], xproj:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ProjectVector(v:Sequence[float], origin:Sequence[float], normal:Sequence[float], vproj:MutableSequence[float]) -> None: ...
    @overload
    def ProjectVector(self, v:Sequence[float], vproj:MutableSequence[float]) -> None: ...
    def Push(self, distance:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlane': ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...

class vtkPlaneCollection(vtkmodules.vtkCommonCore.vtkCollection):
    next_item:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddItem(self, __a:'vtkPlane') -> None: ...
    def GetItem(self, i:int) -> 'vtkPlane': ...
    def GetNextItem(self) -> 'vtkPlane': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlaneCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlaneCollection': ...

class vtkPlanes(vtkImplicitFunction):
    bounds:'getset_descriptor'
    frustum_planes:'getset_descriptor'
    normals:'getset_descriptor'
    points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def GetNormals(self) -> 'vtkDataArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPlanes(self) -> int: ...
    @overload
    def GetPlane(self, i:int) -> 'vtkPlane': ...
    @overload
    def GetPlane(self, i:int, plane:'vtkPlane') -> None: ...
    def GetPoints(self) -> 'vtkPoints': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlanes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlanes': ...
    @overload
    def SetBounds(self, bounds:Sequence[float]) -> None: ...
    @overload
    def SetBounds(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def SetFrustumPlanes(self, planes:MutableSequence[float]) -> None: ...
    def SetNormals(self, normals:'vtkDataArray') -> None: ...
    def SetPoints(self, __a:'vtkPoints') -> None: ...

class vtkPlanesIntersection(vtkPlanes):
    num_region_vertices:'getset_descriptor'
    number_of_region_vertices:'getset_descriptor'
    region_vertices:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def Convert3DCell(cell:'vtkCell') -> 'vtkPlanesIntersection': ...
    def GetNumRegionVertices(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRegionVertices(self) -> int: ...
    def GetRegionVertices(self, v:MutableSequence[float], nvertices:int) -> int: ...
    def IntersectsRegion(self, R:'vtkPoints') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlanesIntersection': ...
    @staticmethod
    def PolygonIntersectsBBox(bounds:MutableSequence[float], pts:'vtkPoints') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlanesIntersection': ...
    @overload
    def SetRegionVertices(self, pts:'vtkPoints') -> None: ...
    @overload
    def SetRegionVertices(self, v:MutableSequence[float], nvertices:int) -> None: ...

class vtkPointData(vtkDataSetAttributes):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkPointData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointData': ...

class vtkPointSetCellIterator(vtkCellIterator):
    cell_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointSetCellIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointSetCellIterator': ...

class vtkPointsProjectedHull(vtkmodules.vtkCommonCore.vtkPoints):
    size_ccw_hull_x:'getset_descriptor'
    size_ccw_hull_y:'getset_descriptor'
    size_ccw_hull_z:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCCWHullX(self, pts:MutableSequence[float], len:int) -> int: ...
    def GetCCWHullY(self, pts:MutableSequence[float], len:int) -> int: ...
    def GetCCWHullZ(self, pts:MutableSequence[float], len:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSizeCCWHullX(self) -> int: ...
    def GetSizeCCWHullY(self) -> int: ...
    def GetSizeCCWHullZ(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointsProjectedHull': ...
    @overload
    def RectangleIntersectionX(self, R:'vtkPoints') -> int: ...
    @overload
    def RectangleIntersectionX(self, ymin:float, ymax:float, zmin:float, zmax:float) -> int: ...
    @overload
    def RectangleIntersectionY(self, R:'vtkPoints') -> int: ...
    @overload
    def RectangleIntersectionY(self, zmin:float, zmax:float, xmin:float, xmax:float) -> int: ...
    @overload
    def RectangleIntersectionZ(self, R:'vtkPoints') -> int: ...
    @overload
    def RectangleIntersectionZ(self, xmin:float, xmax:float, ymin:float, ymax:float) -> int: ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointsProjectedHull': ...
    def Update(self) -> None: ...

class vtkPolyData(vtkPointSet):
    ERR_INCORRECT_FIELD:int
    ERR_NON_MANIFOLD_STAR:int
    ERR_NO_SUCH_FIELD:int
    MAXIMUM:int
    MINIMUM:int
    REGULAR_POINT:int
    SADDLE:int
    actual_memory_size:'getset_descriptor'
    data_object_type:'getset_descriptor'
    ghost_level:'getset_descriptor'
    lines:'getset_descriptor'
    links:'getset_descriptor'
    m_time:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    max_spatial_dimension:'getset_descriptor'
    mesh_m_time:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_lines:'getset_descriptor'
    number_of_polys:'getset_descriptor'
    number_of_strips:'getset_descriptor'
    number_of_verts:'getset_descriptor'
    piece:'getset_descriptor'
    polys:'getset_descriptor'
    strips:'getset_descriptor'
    verts:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddCellReference(self, cellId:int) -> None: ...
    def AddReferenceToCell(self, ptId:int, cellId:int) -> None: ...
    @overload
    def Allocate(self, numCells:int=1000, extSize:int=1000) -> None: ...
    @overload
    def Allocate(self, inPolyData:'vtkPolyData', numCells:int=1000, extSize:int=1000) -> None: ...
    def AllocateCopy(self, pd:'vtkPolyData') -> bool: ...
    @overload
    def AllocateEstimate(self, numCells:int, maxCellSize:int) -> bool: ...
    @overload
    def AllocateEstimate(self, numVerts:int, maxVertSize:int, numLines:int, maxLineSize:int, numPolys:int, maxPolySize:int, numStrips:int, maxStripSize:int) -> bool: ...
    @overload
    def AllocateExact(self, numCells:int, connectivitySize:int) -> bool: ...
    @overload
    def AllocateExact(self, numVerts:int, vertConnSize:int, numLines:int, lineConnSize:int, numPolys:int, polyConnSize:int, numStrips:int, stripConnSize:int) -> bool: ...
    def AllocateProportional(self, pd:'vtkPolyData', ratio:float) -> bool: ...
    def BuildCells(self) -> None: ...
    def BuildLinks(self, initialSize:int=0) -> None: ...
    def ComputeCellsBounds(self) -> None: ...
    def CopyCells(self, pd:'vtkPolyData', idList:'vtkIdList', locator:'vtkIncrementalPointLocator'=...) -> None: ...
    def CopyStructure(self, ds:'vtkDataSet') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    def DeleteCell(self, cellId:int) -> None: ...
    def DeleteCells(self) -> None: ...
    def DeleteLinks(self) -> None: ...
    def DeletePoint(self, ptId:int) -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkPolyData': ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetCell(self, cellId:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, cellId:int, cell:'vtkGenericCell') -> None: ...
    @overload
    def GetCell(self, cellId:int, pts:Sequence[int]) -> int: ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    def GetCellBounds(self, cellId:int, bounds:MutableSequence[float]) -> None: ...
    def GetCellEdgeNeighbors(self, cellId:int, p1:int, p2:int, cellIds:'vtkIdList') -> None: ...
    def GetCellIdRelativeToCellArray(self, cellId:int) -> int: ...
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int]) -> int: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetCellType(self, cellId:int) -> int: ...
    def GetCellsBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkPolyData': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkPolyData': ...
    def GetDataObjectType(self) -> int: ...
    def GetGhostLevel(self) -> int: ...
    def GetLines(self) -> 'vtkCellArray': ...
    def GetLinks(self) -> 'vtkAbstractCellLinks': ...
    def GetMTime(self) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    def GetMaxSpatialDimension(self) -> int: ...
    def GetMeshMTime(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLines(self) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetNumberOfPolys(self) -> int: ...
    def GetNumberOfStrips(self) -> int: ...
    def GetNumberOfVerts(self) -> int: ...
    def GetPiece(self) -> int: ...
    @overload
    def GetPointCells(self, ptId:int, cellIds:'vtkIdList') -> None: ...
    @overload
    def GetPointCells(self, ptId:int, ncells:int, cells:MutableSequence[int]) -> None: ...
    def GetPolys(self) -> 'vtkCellArray': ...
    @overload
    def GetScalarFieldCriticalIndex(self, pointId:int, scalarField:'vtkDataArray') -> int: ...
    @overload
    def GetScalarFieldCriticalIndex(self, pointId:int, fieldId:int) -> int: ...
    @overload
    def GetScalarFieldCriticalIndex(self, pointId:int, fieldName:str) -> int: ...
    def GetStrips(self) -> 'vtkCellArray': ...
    def GetVerts(self) -> 'vtkCellArray': ...
    def Initialize(self) -> None: ...
    @overload
    def InsertNextCell(self, type:int, npts:int, pts:Sequence[int]) -> int: ...
    @overload
    def InsertNextCell(self, type:int, pts:'vtkIdList') -> int: ...
    def InsertNextLinkedCell(self, type:int, npts:int, pts:Sequence[int]) -> int: ...
    @overload
    def InsertNextLinkedPoint(self, numLinks:int) -> int: ...
    @overload
    def InsertNextLinkedPoint(self, x:MutableSequence[float], numLinks:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsEdge(self, p1:int, p2:int) -> int: ...
    def IsPointUsedByCell(self, ptId:int, cellId:int) -> int: ...
    def IsTriangle(self, v1:int, v2:int, v3:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NeedToBuildCells(self) -> bool: ...
    def NewInstance(self) -> 'vtkPolyData': ...
    def RemoveCellReference(self, cellId:int) -> None: ...
    def RemoveDeletedCells(self) -> None: ...
    def RemoveGhostCells(self) -> None: ...
    def RemoveReferenceToCell(self, ptId:int, cellId:int) -> None: ...
    @overload
    def ReplaceCell(self, cellId:int, ids:'vtkIdList') -> None: ...
    @overload
    def ReplaceCell(self, cellId:int, npts:int, pts:Sequence[int]) -> None: ...
    @overload
    def ReplaceCellPoint(self, cellId:int, oldPtId:int, newPtId:int) -> None: ...
    @overload
    def ReplaceCellPoint(self, cellId:int, oldPtId:int, newPtId:int, cellPointIds:'vtkIdList') -> None: ...
    def ReplaceLinkedCell(self, cellId:int, npts:int, pts:Sequence[int]) -> None: ...
    def Reset(self) -> None: ...
    def ResizeCellList(self, ptId:int, size:int) -> None: ...
    def ReverseCell(self, cellId:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyData': ...
    def SetLines(self, l:'vtkCellArray') -> None: ...
    def SetLinks(self, _arg:'vtkAbstractCellLinks') -> None: ...
    def SetPolys(self, p:'vtkCellArray') -> None: ...
    def SetStrips(self, s:'vtkCellArray') -> None: ...
    def SetVerts(self, v:'vtkCellArray') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    def Squeeze(self) -> None: ...

class vtkPolyDataCollection(vtkmodules.vtkCommonCore.vtkCollection):
    next_item:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddItem(self, pd:'vtkPolyData') -> None: ...
    def GetNextItem(self) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataCollection': ...

class vtkPolyLine(vtkCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', lines:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    @overload
    @staticmethod
    def GenerateSlidingNormals(pts:'vtkPoints', lines:'vtkCellArray', normals:'vtkDataArray') -> int: ...
    @overload
    @staticmethod
    def GenerateSlidingNormals(pts:'vtkPoints', lines:'vtkCellArray', normals:'vtkDataArray', firstNormal:MutableSequence[float], threading:bool=False) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsPrimaryCell(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyLine': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyLine': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkPolyPlane(vtkImplicitFunction):
    m_time:'getset_descriptor'
    poly_line:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyLine(self) -> 'vtkPolyLine': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyPlane': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyPlane': ...
    def SetPolyLine(self, __a:'vtkPolyLine') -> None: ...

class vtkPolyVertex(vtkCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsPrimaryCell(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyVertex': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyVertex': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkPolygon(vtkCell):
    class EarCutMeasureTypes(int): ...
    BEST_QUALITY:'EarCutMeasureTypes'
    DOT_PRODUCT:'EarCutMeasureTypes'
    PERIMETER2_TO_AREA_RATIO:'EarCutMeasureTypes'
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    tolerance:'getset_descriptor'
    use_mvc_interpolation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BoundedTriangulate(self, outTris:'vtkIdList', tol:float) -> int: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tris:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    @overload
    def ComputeArea(self) -> float: ...
    @overload
    @staticmethod
    def ComputeArea(p:'vtkPoints', numPts:int, pts:Sequence[int], normal:MutableSequence[float]) -> float: ...
    @overload
    @staticmethod
    def ComputeCentroid(p:'vtkPoints', numPts:int, pts:Sequence[int], centroid:MutableSequence[float]) -> bool: ...
    @overload
    @staticmethod
    def ComputeCentroid(ids:'vtkIdTypeArray', pts:'vtkPoints', centroid:MutableSequence[float]) -> bool: ...
    @overload
    @staticmethod
    def ComputeNormal(p:'vtkPoints', numPts:int, pts:Sequence[int], n:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ComputeNormal(p:'vtkPoints', n:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ComputeNormal(ids:'vtkIdTypeArray', pts:'vtkPoints', n:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ComputeNormal(numPts:int, pts:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def DistanceToPolygon(x:MutableSequence[float], numPts:int, pts:MutableSequence[float], bounds:MutableSequence[float], closest:MutableSequence[float]) -> float: ...
    @overload
    def EarCutTriangulation(self, measure:int=...) -> int: ...
    @overload
    def EarCutTriangulation(self, outTris:'vtkIdList', measure:int=...) -> int: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def GetUseMVCInterpolation(self) -> bool: ...
    def InterpolateFunctions(self, x:Sequence[float], sf:MutableSequence[float]) -> None: ...
    @staticmethod
    def IntersectConvex2DCells(cell1:'vtkCell', cell2:'vtkCell', tol:float, p0:MutableSequence[float], p1:MutableSequence[float]) -> int: ...
    @staticmethod
    def IntersectPolygonWithPolygon(npts:int, pts:MutableSequence[float], bounds:MutableSequence[float], npts2:int, pts2:MutableSequence[float], bounds2:MutableSequence[float], tol:float, x:MutableSequence[float]) -> int: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsConvex(self) -> bool: ...
    @overload
    @staticmethod
    def IsConvex(p:'vtkPoints', numPts:int, pts:Sequence[int]) -> bool: ...
    @overload
    @staticmethod
    def IsConvex(ids:'vtkIdTypeArray', p:'vtkPoints') -> bool: ...
    @overload
    @staticmethod
    def IsConvex(p:'vtkPoints') -> bool: ...
    def IsPrimaryCell(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolygon': ...
    def NonDegenerateTriangulate(self, outTris:'vtkIdList') -> int: ...
    def ParameterizePolygon(self, p0:MutableSequence[float], p10:MutableSequence[float], l10:float, p20:MutableSequence[float], l20:float, n:MutableSequence[float]) -> int: ...
    @staticmethod
    def PointInPolygon(x:MutableSequence[float], numPts:int, pts:MutableSequence[float], bounds:MutableSequence[float], n:MutableSequence[float]) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolygon': ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetUseMVCInterpolation(self, _arg:bool) -> None: ...
    @overload
    def Triangulate(self, index:int, ptIds:'vtkIdList', pts:'vtkPoints') -> int: ...
    @overload
    def Triangulate(self, outTris:'vtkIdList') -> int: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...
    @overload
    def UnbiasedEarCutTriangulation(self, seed:int, measure:int=...) -> int: ...
    @overload
    def UnbiasedEarCutTriangulation(self, seed:int, outTris:'vtkIdList', measure:int=...) -> int: ...

class vtkPolyhedron(vtkCell3D):
    cell_faces:'getset_descriptor'
    cell_type:'getset_descriptor'
    faces:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    poly_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, scalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', connectivity:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, scalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def DeepCopy(self, c:'vtkCell') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    @overload
    def GetCellFaces(self) -> 'vtkCellArray': ...
    @overload
    def GetCellFaces(self, faces:'vtkCellArray') -> None: ...
    def GetCellType(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faceIds:Sequence[int]) -> int: ...
    def GetFaces(self) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetPointToIncidentEdges(self, pointId:int, edgeIds:Sequence[int]) -> int: ...
    def GetPointToIncidentFaces(self, pointId:int, faceIds:Sequence[int]) -> int: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    def GetPolyData(self) -> 'vtkPolyData': ...
    def Initialize(self) -> None: ...
    def InterpolateDerivs(self, x:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, x:Sequence[float], sf:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsConvex(self) -> bool: ...
    def IsInside(self, x:Sequence[float], tolerance:float) -> int: ...
    def IsPrimaryCell(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyhedron': ...
    def RequiresExplicitFaceRepresentation(self) -> int: ...
    def RequiresInitialization(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyhedron': ...
    def SetCellFaces(self, faces:'vtkCellArray') -> int: ...
    def SetFaces(self, faces:MutableSequence[int]) -> None: ...
    def ShallowCopy(self, c:'vtkCell') -> None: ...
    @overload
    def TriangulateFaces(self, newFaces:'vtkIdList') -> int: ...
    @overload
    def TriangulateFaces(self, newFaces:'vtkCellArray') -> int: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkPolyhedronUtilities(object):
    def __init__(self, __a:'vtkPolyhedronUtilities') -> None: ...
    @staticmethod
    def Decompose(polyhedron:'vtkPolyhedron', inPd:'vtkPointData', cellId:int, inCd:'vtkCellData') -> 'vtkUnstructuredGrid': ...

class vtkPyramid(vtkCell3D):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    @staticmethod
    def ComputeCentroid(points:'vtkPoints', pointIds:Sequence[int], centroid:MutableSequence[float]) -> bool: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Tuple[int, int]: ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, pts:Sequence[int]) -> None: ...
    @staticmethod
    def GetEdgeToAdjacentFacesArray(edgeId:int) -> Tuple[int, int]: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Tuple[int, int, int, int]: ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetFaceToAdjacentFacesArray(faceId:int) -> Tuple[int, int, int, int]: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetPointToIncidentEdges(self, pointId:int, edgeIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentEdgesArray(pointId:int) -> Tuple[int, int, int, int]: ...
    def GetPointToIncidentFaces(self, pointId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentFacesArray(pointId:int) -> Tuple[int, int, int, int]: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToOneRingPointsArray(pointId:int) -> Tuple[int, int, int, int]: ...
    @staticmethod
    def GetTriangleCases(caseId:int) -> Pointer: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInsideOut(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPyramid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPyramid': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuad(vtkCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeArray(self, edgeId:int) -> Pointer: ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], sf:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], sf:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuad': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuad': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticEdge(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', lines:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticEdge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticEdge': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticHexahedron(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tetras:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticHexahedron': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticHexahedron': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticLinearQuad(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticLinearQuad': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticLinearQuad': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticLinearWedge(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tetras:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticLinearWedge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticLinearWedge': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticPolygon(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    use_mvc_interpolation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    @staticmethod
    def ComputeCentroid(ids:'vtkIdTypeArray', pts:'vtkPoints', centroid:MutableSequence[float]) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def DistanceToPolygon(x:MutableSequence[float], numPts:int, pts:MutableSequence[float], bounds:MutableSequence[float], closest:MutableSequence[float]) -> float: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseMVCInterpolation(self) -> bool: ...
    def InterpolateFunctions(self, x:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def IntersectConvex2DCells(cell1:'vtkCell', cell2:'vtkCell', tol:float, p0:MutableSequence[float], p1:MutableSequence[float]) -> int: ...
    @staticmethod
    def IntersectPolygonWithPolygon(npts:int, pts:MutableSequence[float], bounds:MutableSequence[float], npts2:int, pts2:MutableSequence[float], bounds2:MutableSequence[float], tol:float, x:MutableSequence[float]) -> int: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsPrimaryCell(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticPolygon': ...
    def NonDegenerateTriangulate(self, outTris:'vtkIdList') -> int: ...
    def ParameterizePolygon(self, p0:MutableSequence[float], p10:MutableSequence[float], l10:float, p20:MutableSequence[float], l20:float, n:MutableSequence[float]) -> int: ...
    @staticmethod
    def PointInPolygon(x:MutableSequence[float], numPts:int, pts:MutableSequence[float], bounds:MutableSequence[float], n:MutableSequence[float]) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticPolygon': ...
    def SetUseMVCInterpolation(self, _arg:bool) -> None: ...
    @overload
    def Triangulate(self, index:int, ptIds:'vtkIdList', pts:'vtkPoints') -> int: ...
    @overload
    def Triangulate(self, outTris:'vtkIdList') -> int: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticPyramid(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tets:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticPyramid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticPyramid': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticQuad(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticQuad': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticQuad': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticTetra(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tetras:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticTetra': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticTetra': ...
    def StableClip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tetras:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> bool: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticTriangle(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticTriangle': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticTriangle': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadraticWedge(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tetras:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraticWedge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraticWedge': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkQuadratureSchemeDefinition(vtkmodules.vtkCommonCore.vtkObject):
    cell_type:'getset_descriptor'
    number_of_nodes:'getset_descriptor'
    number_of_quadrature_points:'getset_descriptor'
    quadrature_key:'getset_descriptor'
    quadrature_weights:'getset_descriptor'
    shape_function_weights:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clear(self) -> None: ...
    @staticmethod
    def DICTIONARY() -> 'vtkInformationQuadratureSchemeDefinitionVectorKey': ...
    def DeepCopy(self, other:'vtkQuadratureSchemeDefinition') -> int: ...
    def GetCellType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNodes(self) -> int: ...
    def GetNumberOfQuadraturePoints(self) -> int: ...
    def GetQuadratureKey(self) -> int: ...
    def GetQuadratureWeights(self) -> Pointer: ...
    @overload
    def GetShapeFunctionWeights(self) -> Pointer: ...
    @overload
    def GetShapeFunctionWeights(self, quadraturePointId:int) -> Pointer: ...
    @overload
    def Initialize(self, cellType:int, numberOfNodes:int, numberOfQuadraturePoints:int, shapeFunctionWeights:MutableSequence[float]) -> None: ...
    @overload
    def Initialize(self, cellType:int, numberOfNodes:int, numberOfQuadraturePoints:int, shapeFunctionWeights:MutableSequence[float], quadratureWeights:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadratureSchemeDefinition': ...
    @staticmethod
    def QUADRATURE_OFFSET_ARRAY_NAME() -> 'vtkInformationStringKey': ...
    def RestoreState(self, root:'vtkXMLDataElement') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadratureSchemeDefinition': ...
    def SaveState(self, root:'vtkXMLDataElement') -> int: ...

class vtkQuadric(vtkImplicitFunction):
    coefficients:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetCoefficients(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadric': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadric': ...
    @overload
    def SetCoefficients(self, a:MutableSequence[float]) -> None: ...
    @overload
    def SetCoefficients(self, a0:float, a1:float, a2:float, a3:float, a4:float, a5:float, a6:float, a7:float, a8:float, a9:float) -> None: ...

class vtkVector_IdLi4EE(vtkmodules.vtkCommonMath.vtkTuple_IdLi4EE):
    def Dot(self, other:'vtkVector_IdLi4EE') -> float: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> float: ...
    def Normalized(self) -> 'vtkVector_IdLi4EE': ...
    def SquaredNorm(self) -> float: ...

class vtkRect_IdE(vtkVector_IdLi4EE):
    bottom:'getset_descriptor'
    bottom_left:'getset_descriptor'
    bottom_right:'getset_descriptor'
    center:'getset_descriptor'
    height:'getset_descriptor'
    left:'getset_descriptor'
    right:'getset_descriptor'
    top:'getset_descriptor'
    top_left:'getset_descriptor'
    top_right:'getset_descriptor'
    width:'getset_descriptor'
    x:'getset_descriptor'
    y:'getset_descriptor'
    @overload
    def AddPoint(self, point:Sequence[float]) -> None: ...
    @overload
    def AddPoint(self, x:float, y:float) -> None: ...
    def AddRect(self, rect:'vtkRect_IdE') -> None: ...
    def GetBottom(self) -> float: ...
    def GetBottomLeft(self) -> 'vtkVector2_IdE': ...
    def GetBottomRight(self) -> 'vtkVector_IdLi2EE': ...
    def GetCenter(self) -> 'vtkVector2d': ...
    def GetHeight(self) -> float: ...
    def GetLeft(self) -> float: ...
    def GetRight(self) -> float: ...
    def GetTop(self) -> float: ...
    def GetTopLeft(self) -> 'vtkVector_IdLi2EE': ...
    def GetTopRight(self) -> 'vtkVector_IdLi2EE': ...
    def GetWidth(self) -> float: ...
    def GetX(self) -> float: ...
    def GetY(self) -> float: ...
    def Intersect(self, other:'vtkRect_IdE') -> bool: ...
    def IntersectsWith(self, rect:'vtkRect_IdE') -> bool: ...
    def MoveTo(self, x:float, y:float) -> None: ...
    def Set(self, x:float, y:float, width:float, height:float) -> None: ...
    def SetHeight(self, height:float) -> None: ...
    def SetWidth(self, width:float) -> None: ...
    def SetX(self, x:float) -> None: ...
    def SetY(self, y:float) -> None: ...

class vtkVector_IfLi4EE(vtkmodules.vtkCommonMath.vtkTuple_IfLi4EE):
    def Dot(self, other:'vtkVector_IfLi4EE') -> float: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> float: ...
    def Normalized(self) -> 'vtkVector_IfLi4EE': ...
    def SquaredNorm(self) -> float: ...

class vtkRect_IfE(vtkVector_IfLi4EE):
    bottom:'getset_descriptor'
    bottom_left:'getset_descriptor'
    bottom_right:'getset_descriptor'
    center:'getset_descriptor'
    height:'getset_descriptor'
    left:'getset_descriptor'
    right:'getset_descriptor'
    top:'getset_descriptor'
    top_left:'getset_descriptor'
    top_right:'getset_descriptor'
    width:'getset_descriptor'
    x:'getset_descriptor'
    y:'getset_descriptor'
    @overload
    def AddPoint(self, point:Sequence[float]) -> None: ...
    @overload
    def AddPoint(self, x:float, y:float) -> None: ...
    def AddRect(self, rect:'vtkRect_IfE') -> None: ...
    def GetBottom(self) -> float: ...
    def GetBottomLeft(self) -> 'vtkVector2_IfE': ...
    def GetBottomRight(self) -> 'vtkVector_IfLi2EE': ...
    def GetCenter(self) -> 'vtkVector2d': ...
    def GetHeight(self) -> float: ...
    def GetLeft(self) -> float: ...
    def GetRight(self) -> float: ...
    def GetTop(self) -> float: ...
    def GetTopLeft(self) -> 'vtkVector_IfLi2EE': ...
    def GetTopRight(self) -> 'vtkVector_IfLi2EE': ...
    def GetWidth(self) -> float: ...
    def GetX(self) -> float: ...
    def GetY(self) -> float: ...
    def Intersect(self, other:'vtkRect_IfE') -> bool: ...
    def IntersectsWith(self, rect:'vtkRect_IfE') -> bool: ...
    def MoveTo(self, x:float, y:float) -> None: ...
    def Set(self, x:float, y:float, width:float, height:float) -> None: ...
    def SetHeight(self, height:float) -> None: ...
    def SetWidth(self, width:float) -> None: ...
    def SetX(self, x:float) -> None: ...
    def SetY(self, y:float) -> None: ...

class vtkVector_IiLi4EE(vtkmodules.vtkCommonMath.vtkTuple_IiLi4EE):
    def Dot(self, other:'vtkVector_IiLi4EE') -> int: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> float: ...
    def Normalized(self) -> 'vtkVector_IiLi4EE': ...
    def SquaredNorm(self) -> int: ...

class vtkRect_IiE(vtkVector_IiLi4EE):
    bottom:'getset_descriptor'
    bottom_left:'getset_descriptor'
    bottom_right:'getset_descriptor'
    center:'getset_descriptor'
    height:'getset_descriptor'
    left:'getset_descriptor'
    right:'getset_descriptor'
    top:'getset_descriptor'
    top_left:'getset_descriptor'
    top_right:'getset_descriptor'
    width:'getset_descriptor'
    x:'getset_descriptor'
    y:'getset_descriptor'
    @overload
    def AddPoint(self, point:Sequence[int]) -> None: ...
    @overload
    def AddPoint(self, x:int, y:int) -> None: ...
    def AddRect(self, rect:'vtkRect_IiE') -> None: ...
    def GetBottom(self) -> int: ...
    def GetBottomLeft(self) -> 'vtkVector2_IiE': ...
    def GetBottomRight(self) -> 'vtkVector_IiLi2EE': ...
    def GetCenter(self) -> 'vtkVector2d': ...
    def GetHeight(self) -> int: ...
    def GetLeft(self) -> int: ...
    def GetRight(self) -> int: ...
    def GetTop(self) -> int: ...
    def GetTopLeft(self) -> 'vtkVector_IiLi2EE': ...
    def GetTopRight(self) -> 'vtkVector_IiLi2EE': ...
    def GetWidth(self) -> int: ...
    def GetX(self) -> int: ...
    def GetY(self) -> int: ...
    def Intersect(self, other:'vtkRect_IiE') -> bool: ...
    def IntersectsWith(self, rect:'vtkRect_IiE') -> bool: ...
    def MoveTo(self, x:int, y:int) -> None: ...
    def Set(self, x:int, y:int, width:int, height:int) -> None: ...
    def SetHeight(self, height:int) -> None: ...
    def SetWidth(self, width:int) -> None: ...
    def SetX(self, x:int) -> None: ...
    def SetY(self, y:int) -> None: ...

class vtkRectd(vtkRect_IdE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:float, y:float, width:float, height:float) -> None: ...
    @overload
    def __init__(self, init:Sequence[float]) -> None: ...
    @overload
    def __init__(self, __a:'vtkRectd') -> None: ...

class vtkRectf(vtkRect_IfE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:float, y:float, width:float, height:float) -> None: ...
    @overload
    def __init__(self, init:Sequence[float]) -> None: ...
    @overload
    def __init__(self, __a:'vtkRectf') -> None: ...

class vtkRecti(vtkRect_IiE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:int, y:int, width:int, height:int) -> None: ...
    @overload
    def __init__(self, init:Sequence[int]) -> None: ...
    @overload
    def __init__(self, __a:'vtkRecti') -> None: ...

class vtkRectilinearGrid(vtkDataSet):
    actual_memory_size:'getset_descriptor'
    cell_types_array:'getset_descriptor'
    cells:'getset_descriptor'
    data_description:'getset_descriptor'
    data_dimension:'getset_descriptor'
    data_object_type:'getset_descriptor'
    dimensions:'getset_descriptor'
    extent:'getset_descriptor'
    extent_type:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    max_spatial_dimension:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_points:'getset_descriptor'
    number_of_scalar_components:'getset_descriptor'
    points:'getset_descriptor'
    scalar_type:'getset_descriptor'
    x_coordinates:'getset_descriptor'
    y_coordinates:'getset_descriptor'
    z_coordinates:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def BlankCell(self, ptId:int) -> None: ...
    @overload
    def BlankCell(self, i:int, j:int, k:int) -> None: ...
    @overload
    def BlankPoint(self, ptId:int) -> None: ...
    @overload
    def BlankPoint(self, i:int, j:int, k:int) -> None: ...
    def ComputeBounds(self) -> None: ...
    def ComputeCellId(self, ijk:MutableSequence[int]) -> int: ...
    def ComputePointId(self, ijk:MutableSequence[int]) -> int: ...
    def ComputeStructuredCoordinates(self, x:MutableSequence[float], ijk:MutableSequence[int], pcoords:MutableSequence[float]) -> int: ...
    def CopyStructure(self, ds:'vtkDataSet') -> None: ...
    def Crop(self, updateExtent:Sequence[int]) -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkRectilinearGrid': ...
    def FindAndGetCell(self, x:MutableSequence[float], cell:'vtkCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> 'vtkCell': ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], cell:'vtkCell', gencell:'vtkGenericCell', cellId:int, tol2:float, subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindPoint(self, x:MutableSequence[float]) -> int: ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetCell(self, cellId:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, cellId:int, cell:'vtkGenericCell') -> None: ...
    def GetCellBounds(self, cellId:int, bounds:MutableSequence[float]) -> None: ...
    def GetCellDims(self, cellDims:MutableSequence[int]) -> None: ...
    @overload
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList') -> None: ...
    @overload
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList', seedLoc:MutableSequence[int]) -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetCellType(self, cellId:int) -> int: ...
    def GetCellTypesArray(self) -> 'vtkConstantArray_IiE': ...
    def GetCells(self) -> 'vtkStructuredCellArray': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkRectilinearGrid': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkRectilinearGrid': ...
    def GetDataDescription(self) -> int: ...
    def GetDataDimension(self) -> int: ...
    def GetDataObjectType(self) -> int: ...
    def GetDimensions(self) -> Tuple[int, int, int]: ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetExtentType(self) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    def GetMaxSpatialDimension(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    @staticmethod
    def GetNumberOfScalarComponents(meta_data:'vtkInformation') -> int: ...
    @overload
    def GetNumberOfScalarComponents(self) -> int: ...
    @overload
    def GetPoint(self, ptId:int) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint(self, id:int, x:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint(self, i:int, j:int, k:int, p:MutableSequence[float]) -> None: ...
    def GetPointCells(self, ptId:int, cellIds:'vtkIdList') -> None: ...
    @overload
    def GetPoints(self) -> 'vtkPoints': ...
    @overload
    def GetPoints(self, points:'vtkPoints') -> None: ...
    @overload
    @staticmethod
    def GetScalarType(meta_data:'vtkInformation') -> int: ...
    @overload
    def GetScalarType(self) -> int: ...
    def GetScalarTypeAsString(self) -> str: ...
    def GetXCoordinates(self) -> 'vtkDataArray': ...
    def GetYCoordinates(self) -> 'vtkDataArray': ...
    def GetZCoordinates(self) -> 'vtkDataArray': ...
    def HasAnyBlankCells(self) -> bool: ...
    def HasAnyBlankPoints(self) -> bool: ...
    @staticmethod
    def HasNumberOfScalarComponents(meta_data:'vtkInformation') -> bool: ...
    @staticmethod
    def HasScalarType(meta_data:'vtkInformation') -> bool: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCellVisible(self, cellId:int) -> int: ...
    def IsPointVisible(self, ptId:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGrid': ...
    @overload
    def SetDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetDimensions(self, dim:Sequence[int]) -> None: ...
    @overload
    def SetExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def SetExtent(self, xMin:int, xMax:int, yMin:int, yMax:int, zMin:int, zMax:int) -> None: ...
    @staticmethod
    def SetNumberOfScalarComponents(n:int, meta_data:'vtkInformation') -> None: ...
    @staticmethod
    def SetScalarType(__a:int, meta_data:'vtkInformation') -> None: ...
    def SetXCoordinates(self, __a:'vtkDataArray') -> None: ...
    def SetYCoordinates(self, __a:'vtkDataArray') -> None: ...
    def SetZCoordinates(self, __a:'vtkDataArray') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    @overload
    def UnBlankCell(self, ptId:int) -> None: ...
    @overload
    def UnBlankCell(self, i:int, j:int, k:int) -> None: ...
    @overload
    def UnBlankPoint(self, ptId:int) -> None: ...
    @overload
    def UnBlankPoint(self, i:int, j:int, k:int) -> None: ...

class vtkReebGraph(vtkMutableDirectedGraph):
    ERR_INCORRECT_FIELD:int
    ERR_NOT_A_SIMPLICIAL_MESH:int
    ERR_NO_SUCH_FIELD:int
    data_object_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def Build(self, mesh:'vtkPolyData', scalarField:'vtkDataArray') -> int: ...
    @overload
    def Build(self, mesh:'vtkUnstructuredGrid', scalarField:'vtkDataArray') -> int: ...
    @overload
    def Build(self, mesh:'vtkPolyData', scalarFieldId:int) -> int: ...
    @overload
    def Build(self, mesh:'vtkUnstructuredGrid', scalarFieldId:int) -> int: ...
    @overload
    def Build(self, mesh:'vtkPolyData', scalarFieldName:str) -> int: ...
    @overload
    def Build(self, mesh:'vtkUnstructuredGrid', scalarFieldName:str) -> int: ...
    def CloseStream(self) -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkReebGraph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkReebGraph': ...
    def Set(self, g:'vtkMutableDirectedGraph') -> None: ...
    def Simplify(self, simplificationThreshold:float, simplificationMetric:'vtkReebGraphSimplificationMetric') -> int: ...
    def StreamTetrahedron(self, vertex0Id:int, scalar0:float, vertex1Id:int, scalar1:float, vertex2Id:int, scalar2:float, vertex3Id:int, scalar3:float) -> int: ...
    def StreamTriangle(self, vertex0Id:int, scalar0:float, vertex1Id:int, scalar1:float, vertex2Id:int, scalar2:float) -> int: ...

class vtkReebGraphSimplificationMetric(vtkmodules.vtkCommonCore.vtkObject):
    lower_bound:'getset_descriptor'
    upper_bound:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeMetric(self, mesh:'vtkDataSet', field:'vtkDataArray', startCriticalPoint:int, vertexList:'vtkAbstractArray', endCriticalPoint:int) -> float: ...
    def GetLowerBound(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUpperBound(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkReebGraphSimplificationMetric': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkReebGraphSimplificationMetric': ...
    def SetLowerBound(self, _arg:float) -> None: ...
    def SetUpperBound(self, _arg:float) -> None: ...

class vtkSelection(vtkDataObject):
    data_object_type:'getset_descriptor'
    expression:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_nodes:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddNode(self, __a:'vtkSelectionNode') -> str: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    def Dump(self) -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkSelection': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkSelection': ...
    def GetDataObjectType(self) -> int: ...
    def GetExpression(self) -> str: ...
    def GetMTime(self) -> int: ...
    @overload
    def GetNode(self, idx:int) -> 'vtkSelectionNode': ...
    @overload
    def GetNode(self, name:str) -> 'vtkSelectionNode': ...
    def GetNodeNameAtIndex(self, idx:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNodes(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSelection': ...
    def RemoveAllNodes(self) -> None: ...
    @overload
    def RemoveNode(self, idx:int) -> None: ...
    @overload
    def RemoveNode(self, name:str) -> None: ...
    @overload
    def RemoveNode(self, __a:'vtkSelectionNode') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSelection': ...
    def SetExpression(self, _arg:str) -> None: ...
    def SetNode(self, name:str, __b:'vtkSelectionNode') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    @overload
    def Subtract(self, selection:'vtkSelection') -> None: ...
    @overload
    def Subtract(self, node:'vtkSelectionNode') -> None: ...
    @overload
    def Union(self, selection:'vtkSelection') -> None: ...
    @overload
    def Union(self, node:'vtkSelectionNode') -> None: ...

class vtkSelectionNode(vtkmodules.vtkCommonCore.vtkObject):
    class SelectionContent(int): ...
    class SelectionField(int): ...
    BLOCKS:'SelectionContent'
    BLOCK_SELECTORS:'SelectionContent'
    CELL:'SelectionField'
    EDGE:'SelectionField'
    FIELD:'SelectionField'
    FRUSTUM:'SelectionContent'
    GLOBALIDS:'SelectionContent'
    INDICES:'SelectionContent'
    LOCATIONS:'SelectionContent'
    NUM_CONTENT_TYPES:'SelectionContent'
    NUM_FIELD_TYPES:'SelectionField'
    PEDIGREEIDS:'SelectionContent'
    POINT:'SelectionField'
    QUERY:'SelectionContent'
    ROW:'SelectionField'
    THRESHOLDS:'SelectionContent'
    USER:'SelectionContent'
    VALUES:'SelectionContent'
    VERTEX:'SelectionField'
    content_type:'getset_descriptor'
    field_type:'getset_descriptor'
    m_time:'getset_descriptor'
    properties:'getset_descriptor'
    query_string:'getset_descriptor'
    selection_data:'getset_descriptor'
    selection_list:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ASSEMBLY_NAME() -> 'vtkInformationStringKey': ...
    @staticmethod
    def CELLGRID_CELL_TYPE_INDEX() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def CELLGRID_SOURCE_SPECIFICATION_INDEX() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def COMPONENT_NUMBER() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def COMPOSITE_INDEX() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def CONNECTED_LAYERS() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def CONNECTED_LAYERS_REMOVE_INTERMEDIATE_LAYERS() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def CONNECTED_LAYERS_REMOVE_SEED() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def CONTAINING_CELLS() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def CONTENT_TYPE() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def ConvertAttributeTypeToSelectionField(val:int) -> int: ...
    @staticmethod
    def ConvertSelectionFieldToAttributeType(val:int) -> int: ...
    def DeepCopy(self, src:'vtkSelectionNode') -> None: ...
    @staticmethod
    def EPSILON() -> 'vtkInformationDoubleKey': ...
    def EqualProperties(self, other:'vtkSelectionNode', fullcompare:bool=True) -> bool: ...
    @staticmethod
    def FIELD_TYPE() -> 'vtkInformationIntegerKey': ...
    def GetContentType(self) -> int: ...
    @staticmethod
    def GetContentTypeAsString(type:int) -> str: ...
    def GetFieldType(self) -> int: ...
    @staticmethod
    def GetFieldTypeAsString(type:int) -> str: ...
    @staticmethod
    def GetFieldTypeFromString(type:str) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperties(self) -> 'vtkInformation': ...
    def GetQueryString(self) -> str: ...
    def GetSelectionData(self) -> 'vtkDataSetAttributes': ...
    def GetSelectionList(self) -> 'vtkAbstractArray': ...
    @staticmethod
    def HIERARCHICAL_INDEX() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def HIERARCHICAL_LEVEL() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def INVERSE() -> 'vtkInformationIntegerKey': ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSelectionNode': ...
    @staticmethod
    def PIXEL_COUNT() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def PROCESS_ID() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def PROP() -> 'vtkInformationObjectBaseKey': ...
    @staticmethod
    def PROP_ID() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def SELECTORS() -> 'vtkInformationStringVectorKey': ...
    @staticmethod
    def SOURCE() -> 'vtkInformationObjectBaseKey': ...
    @staticmethod
    def SOURCE_ID() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSelectionNode': ...
    def SetContentType(self, type:int) -> None: ...
    def SetFieldType(self, type:int) -> None: ...
    def SetQueryString(self, _arg:str) -> None: ...
    def SetSelectionData(self, data:'vtkDataSetAttributes') -> None: ...
    def SetSelectionList(self, __a:'vtkAbstractArray') -> None: ...
    def ShallowCopy(self, src:'vtkSelectionNode') -> None: ...
    def SubtractSelectionList(self, other:'vtkSelectionNode') -> None: ...
    def UnionSelectionList(self, other:'vtkSelectionNode') -> None: ...
    @staticmethod
    def ZBUFFER_VALUE() -> 'vtkInformationDoubleKey': ...

class vtkSimpleCellTessellator(vtkGenericCellTessellator):
    fixed_subdivisions:'getset_descriptor'
    generic_cell:'getset_descriptor'
    max_adaptive_subdivisions:'getset_descriptor'
    max_subdivision_level:'getset_descriptor'
    subdivision_levels:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFixedSubdivisions(self) -> int: ...
    def GetGenericCell(self) -> 'vtkGenericAdaptorCell': ...
    def GetMaxAdaptiveSubdivisions(self) -> int: ...
    def GetMaxSubdivisionLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, ds:'vtkGenericDataSet') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimpleCellTessellator': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimpleCellTessellator': ...
    def SetFixedSubdivisions(self, level:int) -> None: ...
    def SetMaxSubdivisionLevel(self, level:int) -> None: ...
    def SetSubdivisionLevels(self, fixed:int, maxLevel:int) -> None: ...
    def Tessellate(self, cell:'vtkGenericAdaptorCell', att:'vtkGenericAttributeCollection', points:'vtkDoubleArray', cellArray:'vtkCellArray', internalPd:'vtkPointData') -> None: ...
    def TessellateFace(self, cell:'vtkGenericAdaptorCell', att:'vtkGenericAttributeCollection', index:int, points:'vtkDoubleArray', cellArray:'vtkCellArray', internalPd:'vtkPointData') -> None: ...
    def Triangulate(self, cell:'vtkGenericAdaptorCell', att:'vtkGenericAttributeCollection', points:'vtkDoubleArray', cellArray:'vtkCellArray', internalPd:'vtkPointData') -> None: ...

class vtkSmoothErrorMetric(vtkGenericSubdivisionErrorMetric):
    angle_tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAngleTolerance(self) -> float: ...
    def GetError(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSmoothErrorMetric': ...
    def RequiresEdgeSubdivision(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSmoothErrorMetric': ...
    def SetAngleTolerance(self, value:float) -> None: ...

class vtkSortFieldData(vtkmodules.vtkCommonCore.vtkSortDataArray):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSortFieldData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSortFieldData': ...
    @overload
    @staticmethod
    def Sort(fd:'vtkFieldData', arrayName:str, k:int, returnIndices:int) -> Pointer: ...
    @overload
    @staticmethod
    def Sort(fd:'vtkFieldData', arrayName:str, k:int, returnIndices:int, dir:int) -> Pointer: ...

class vtkSphere(vtkImplicitFunction):
    center:'getset_descriptor'
    radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    @staticmethod
    def ComputeBoundingSphere(pts:MutableSequence[float], numPts:int, sphere:MutableSequence[float], hints:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def ComputeBoundingSphere(pts:MutableSequence[float], numPts:int, sphere:MutableSequence[float]) -> None: ...
    @staticmethod
    def Evaluate(center:MutableSequence[float], R:float, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphere': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphere': ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkSpheres(vtkImplicitFunction):
    centers:'getset_descriptor'
    radii:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], n:MutableSequence[float]) -> None: ...
    def GetCenters(self) -> 'vtkPoints': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSpheres(self) -> int: ...
    def GetRadii(self) -> 'vtkDataArray': ...
    @overload
    def GetSphere(self, i:int) -> 'vtkSphere': ...
    @overload
    def GetSphere(self, i:int, sphere:'vtkSphere') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSpheres': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSpheres': ...
    def SetCenters(self, __a:'vtkPoints') -> None: ...
    def SetRadii(self, radii:'vtkDataArray') -> None: ...

class vtkSphericalPointIterator(vtkmodules.vtkCommonCore.vtkObject):
    class AxesType(int): ...
    class SortType(int): ...
    CUBE_AXES:'AxesType'
    CUBE_OCTAHEDRON_AXES:'AxesType'
    DODECAHEDRON_AXES:'AxesType'
    ICOSAHEDRON_AXES:'AxesType'
    OCTAHEDRON_AXES:'AxesType'
    SORT_ASCENDING:'SortType'
    SORT_DESCENDING:'SortType'
    SORT_NONE:'SortType'
    XY_CCW_AXES:'AxesType'
    XY_CW_AXES:'AxesType'
    XY_SQUARE_AXES:'AxesType'
    axes:'getset_descriptor'
    current_point:'getset_descriptor'
    data_set:'getset_descriptor'
    number_of_axes:'getset_descriptor'
    sorting:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildRepresentation(self, pd:'vtkPolyData') -> None: ...
    def GetAxes(self) -> 'vtkDoubleArray': ...
    def GetAxisPoints(self, axis:int, npts:int, pts:Sequence[int]) -> None: ...
    @overload
    def GetCurrentPoint(self, ptId:int, x:MutableSequence[float]) -> None: ...
    @overload
    def GetCurrentPoint(self) -> int: ...
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetNumberOfAxes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint(self, axis:int, ptIdx:int) -> int: ...
    def GetSorting(self) -> int: ...
    def GetSortingMaxValue(self) -> int: ...
    def GetSortingMinValue(self) -> int: ...
    def GoToFirstPoint(self) -> None: ...
    def GoToNextPoint(self) -> None: ...
    @overload
    def Initialize(self, center:MutableSequence[float], neighborhood:'vtkIdList') -> bool: ...
    @overload
    def Initialize(self, center:MutableSequence[float], numNei:int, neighborhood:MutableSequence[int]) -> bool: ...
    @overload
    def Initialize(self, center:MutableSequence[float]) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphericalPointIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphericalPointIterator': ...
    @overload
    def SetAxes(self, _arg:'vtkDoubleArray') -> None: ...
    @overload
    def SetAxes(self, axesType:int, resolution:int=6) -> None: ...
    def SetDataSet(self, _arg:'vtkDataSet') -> None: ...
    def SetSortTypeToAscending(self) -> None: ...
    def SetSortTypeToDescending(self) -> None: ...
    def SetSortTypeToNone(self) -> None: ...
    def SetSorting(self, _arg:int) -> None: ...

class vtkSpline(vtkmodules.vtkCommonCore.vtkObject):
    clamp_value:'getset_descriptor'
    closed:'getset_descriptor'
    left_constraint:'getset_descriptor'
    left_value:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_points:'getset_descriptor'
    parametric_range:'getset_descriptor'
    right_constraint:'getset_descriptor'
    right_value:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddPoint(self, t:float, x:float) -> None: ...
    def ClampValueOff(self) -> None: ...
    def ClampValueOn(self) -> None: ...
    def ClosedOff(self) -> None: ...
    def ClosedOn(self) -> None: ...
    def Compute(self) -> None: ...
    def DeepCopy(self, s:'vtkSpline') -> None: ...
    def Evaluate(self, t:float) -> float: ...
    def FillFromDataPointer(self, nb:int, data:MutableSequence[float]) -> None: ...
    def GetClampValue(self) -> int: ...
    def GetClosed(self) -> int: ...
    def GetLeftConstraint(self) -> int: ...
    def GetLeftConstraintMaxValue(self) -> int: ...
    def GetLeftConstraintMinValue(self) -> int: ...
    def GetLeftValue(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetParametricRange(self, tRange:MutableSequence[float]) -> None: ...
    def GetRightConstraint(self) -> int: ...
    def GetRightConstraintMaxValue(self) -> int: ...
    def GetRightConstraintMinValue(self) -> int: ...
    def GetRightValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSpline': ...
    def RemoveAllPoints(self) -> None: ...
    def RemovePoint(self, t:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSpline': ...
    def SetClampValue(self, _arg:int) -> None: ...
    def SetClosed(self, _arg:int) -> None: ...
    def SetLeftConstraint(self, _arg:int) -> None: ...
    def SetLeftValue(self, _arg:float) -> None: ...
    @overload
    def SetParametricRange(self, tMin:float, tMax:float) -> None: ...
    @overload
    def SetParametricRange(self, tRange:MutableSequence[float]) -> None: ...
    def SetRightConstraint(self, _arg:int) -> None: ...
    def SetRightValue(self, _arg:float) -> None: ...

class vtkStaticCellLinks(vtkAbstractCellLinks):
    actual_memory_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildLinks(self) -> None: ...
    def DeepCopy(self, src:'vtkAbstractCellLinks') -> None: ...
    def GetActualMemorySize(self) -> int: ...
    def GetCells(self, ptId:int) -> Pointer: ...
    def GetNcells(self, ptId:int) -> int: ...
    def GetNumberOfCells(self, ptId:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStaticCellLinks': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStaticCellLinks': ...
    def SelectCells(self, minMaxDegree:MutableSequence[int], cellSelection:MutableSequence[int]) -> None: ...
    def ShallowCopy(self, src:'vtkAbstractCellLinks') -> None: ...
    def Squeeze(self) -> None: ...

class vtkStaticCellLocator(vtkAbstractCellLocator):
    divisions:'getset_descriptor'
    large_ids:'getset_descriptor'
    max_number_of_buckets:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildLocator(self) -> None: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindCellsAlongLine(self, p1:Sequence[float], p2:Sequence[float], tolerance:float, cellsIds:'vtkIdList') -> None: ...
    def FindCellsAlongPlane(self, o:Sequence[float], n:Sequence[float], tolerance:float, cells:'vtkIdList') -> None: ...
    def FindCellsWithinBounds(self, bbox:MutableSequence[float], cells:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float], closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float) -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float], closestPoint:MutableSequence[float], cellId:int, subId:int, dist2:float) -> None: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float, inside:int) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cellId:int, subId:int, dist2:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float) -> int: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    def GetDivisions(self) -> Tuple[int, int, int]: ...
    def GetLargeIds(self) -> bool: ...
    def GetMaxNumberOfBuckets(self) -> int: ...
    def GetMaxNumberOfBucketsMaxValue(self) -> int: ...
    def GetMaxNumberOfBucketsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InsideCellBounds(self, x:MutableSequence[float], cellId:int) -> bool: ...
    @overload
    def IntersectWithLine(self, a0:Sequence[float], a1:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList', cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStaticCellLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStaticCellLocator': ...
    @overload
    def SetDivisions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetDivisions(self, _arg:Sequence[int]) -> None: ...
    def SetMaxNumberOfBuckets(self, _arg:int) -> None: ...
    def ShallowCopy(self, locator:'vtkAbstractCellLocator') -> None: ...

class vtkStaticPointLocator(vtkAbstractPointLocator):
    class TraversalOrderType(int): ...
    BIN_ORDER:'TraversalOrderType'
    POINT_ORDER:'TraversalOrderType'
    bounds:'getset_descriptor'
    divisions:'getset_descriptor'
    large_ids:'getset_descriptor'
    max_number_of_buckets:'getset_descriptor'
    number_of_points_per_bucket:'getset_descriptor'
    traversal_order:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def BuildLocator(self) -> None: ...
    @overload
    def BuildLocator(self, inBounds:Sequence[float]) -> None: ...
    @overload
    def FindClosestNPoints(self, N:int, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindClosestNPoints(self, N:int, x:float, y:float, z:float, result:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def FindClosestPoint(self, x:float, y:float, z:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], dist2:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], inputDataLength:float, dist2:float) -> int: ...
    @overload
    def FindPointsWithinRadius(self, R:float, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindPointsWithinRadius(self, R:float, x:float, y:float, z:float, result:'vtkIdList') -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    @overload
    def GetBounds(self) -> Pointer: ...
    @overload
    def GetBounds(self, __a:MutableSequence[float]) -> None: ...
    def GetBucketIds(self, bNum:int, bList:'vtkIdList') -> None: ...
    def GetDivisions(self) -> Tuple[int, int, int]: ...
    def GetLargeIds(self) -> bool: ...
    def GetMaxNumberOfBuckets(self) -> int: ...
    def GetMaxNumberOfBucketsMaxValue(self) -> int: ...
    def GetMaxNumberOfBucketsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointsInBucket(self, bNum:int) -> int: ...
    def GetNumberOfPointsPerBucket(self) -> int: ...
    def GetNumberOfPointsPerBucketMaxValue(self) -> int: ...
    def GetNumberOfPointsPerBucketMinValue(self) -> int: ...
    @overload
    def GetSpacing(self) -> Pointer: ...
    @overload
    def GetSpacing(self, spacing:MutableSequence[float]) -> None: ...
    def GetTraversalOrder(self) -> int: ...
    def GetTraversalOrderMaxValue(self) -> int: ...
    def GetTraversalOrderMinValue(self) -> int: ...
    def Initialize(self) -> None: ...
    def IntersectWithLine(self, a0:MutableSequence[float], a1:MutableSequence[float], tol:float, t:float, lineX:MutableSequence[float], ptX:MutableSequence[float], ptId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePoints(self, tol:float, mergeMap:MutableSequence[int]) -> None: ...
    def MergePointsWithData(self, data:'vtkDataArray', mergeMap:MutableSequence[int]) -> None: ...
    def NewInstance(self) -> 'vtkStaticPointLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStaticPointLocator': ...
    @overload
    def SetDivisions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetDivisions(self, _arg:Sequence[int]) -> None: ...
    def SetMaxNumberOfBuckets(self, _arg:int) -> None: ...
    def SetNumberOfPointsPerBucket(self, _arg:int) -> None: ...
    def SetTraversalOrder(self, _arg:int) -> None: ...
    def SetTraversalOrderToBinOrder(self) -> None: ...
    def SetTraversalOrderToPointOrder(self) -> None: ...

class vtkStaticPointLocator2D(vtkAbstractPointLocator):
    bounds:'getset_descriptor'
    divisions:'getset_descriptor'
    large_ids:'getset_descriptor'
    max_number_of_buckets:'getset_descriptor'
    number_of_points_per_bucket:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildLocator(self) -> None: ...
    def FindCloseNBoundedPoints(self, N:int, x:Sequence[float], result:'vtkIdList') -> float: ...
    @overload
    def FindClosestNPoints(self, N:int, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindClosestNPoints(self, N:int, x:float, y:float, z:float, result:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float]) -> int: ...
    @overload
    def FindClosestPoint(self, x:float, y:float, z:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], dist2:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, radius:float, x:Sequence[float], inputDataLength:float, dist2:float) -> int: ...
    @overload
    def FindPointsWithinRadius(self, R:float, x:Sequence[float], result:'vtkIdList') -> None: ...
    @overload
    def FindPointsWithinRadius(self, R:float, x:float, y:float, z:float, result:'vtkIdList') -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Pointer: ...
    def GetBucketIds(self, bNum:int, bList:'vtkIdList') -> None: ...
    def GetBucketIndex(self, x:Sequence[float]) -> int: ...
    def GetBucketIndices(self, x:Sequence[float], ij:MutableSequence[int]) -> None: ...
    def GetDivisions(self) -> Tuple[int, int]: ...
    def GetLargeIds(self) -> bool: ...
    def GetMaxNumberOfBuckets(self) -> int: ...
    def GetMaxNumberOfBucketsMaxValue(self) -> int: ...
    def GetMaxNumberOfBucketsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointsInBucket(self, bNum:int) -> int: ...
    def GetNumberOfPointsPerBucket(self) -> int: ...
    def GetNumberOfPointsPerBucketMaxValue(self) -> int: ...
    def GetNumberOfPointsPerBucketMinValue(self) -> int: ...
    @overload
    def GetSpacing(self) -> Pointer: ...
    @overload
    def GetSpacing(self, spacing:MutableSequence[float]) -> None: ...
    def Initialize(self) -> None: ...
    def IntersectWithLine(self, a0:MutableSequence[float], a1:MutableSequence[float], tol:float, t:float, lineX:MutableSequence[float], ptX:MutableSequence[float], ptId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePoints(self, tol:float, mergeMap:MutableSequence[int]) -> None: ...
    def NewInstance(self) -> 'vtkStaticPointLocator2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStaticPointLocator2D': ...
    @overload
    def SetDivisions(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetDivisions(self, _arg:Sequence[int]) -> None: ...
    def SetMaxNumberOfBuckets(self, _arg:int) -> None: ...
    def SetNumberOfPointsPerBucket(self, _arg:int) -> None: ...

class vtkStructuredCellArray(vtkAbstractCellArray):
    max_cell_size:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_connectivity_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DeepCopy(self, ca:'vtkAbstractCellArray') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, cellSize:int, cellPoints:Sequence[int], ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellAtId(self, cellId:int, cellSize:int, cellPoints:MutableSequence[int]) -> None: ...
    @overload
    def GetCellAtId(self, ijk:MutableSequence[int], ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellAtId(self, ijk:MutableSequence[int], cellSize:int, cellPoints:MutableSequence[int]) -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfConnectivityIds(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfOffsets(self) -> int: ...
    def GetOffset(self, cellId:int) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsHomogeneous(self) -> int: ...
    def IsStorageShareable(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredCellArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredCellArray': ...
    def SetData(self, extent:MutableSequence[int], usePixelVoxelOrientation:bool) -> None: ...
    def ShallowCopy(self, ca:'vtkAbstractCellArray') -> None: ...

class vtkStructuredData(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def ComputeCellId(dim:Sequence[int], ijk:Sequence[int], dataDescription:int=...) -> int: ...
    @staticmethod
    def ComputeCellIdForExtent(extent:Sequence[int], ijk:Sequence[int], dataDescription:int=...) -> int: ...
    @staticmethod
    def ComputeCellStructuredCoords(cellId:int, dim:Sequence[int], ijk:MutableSequence[int], dataDescription:int=...) -> None: ...
    @staticmethod
    def ComputeCellStructuredCoordsForExtent(cellIdx:int, ext:Sequence[int], ijk:MutableSequence[int], dataDescription:int=...) -> None: ...
    @staticmethod
    def ComputeCellStructuredMinMaxCoords(cellId:int, dim:Sequence[int], ijkMin:MutableSequence[int], ijkMax:MutableSequence[int], dataDescription:int=...) -> None: ...
    @staticmethod
    def ComputePointId(dim:Sequence[int], ijk:Sequence[int], dataDescription:int=...) -> int: ...
    @staticmethod
    def ComputePointIdForExtent(extent:Sequence[int], ijk:Sequence[int], dataDescription:int=...) -> int: ...
    @staticmethod
    def ComputePointStructuredCoords(ptId:int, dim:Sequence[int], ijk:MutableSequence[int], dataDescription:int=...) -> None: ...
    @staticmethod
    def ComputePointStructuredCoordsForExtent(ptId:int, ext:Sequence[int], ijk:MutableSequence[int], dataDescription:int=...) -> None: ...
    @staticmethod
    def GetCellArray(extent:MutableSequence[int], usePixelVoxelOrientation:bool) -> 'vtkStructuredCellArray': ...
    @staticmethod
    def GetCellDimensionsFromExtent(ext:Sequence[int], celldims:MutableSequence[int], dataDescription:int=...) -> None: ...
    @staticmethod
    def GetCellDimensionsFromPointDimensions(pntdims:Sequence[int], cellDims:MutableSequence[int]) -> None: ...
    @staticmethod
    def GetCellExtentFromPointExtent(pntExtent:Sequence[int], cellExtent:MutableSequence[int], dataDescription:int=...) -> None: ...
    @overload
    @staticmethod
    def GetCellNeighbors(cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList', dim:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def GetCellNeighbors(cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList', dim:MutableSequence[int], seedLoc:MutableSequence[int]) -> None: ...
    @staticmethod
    def GetCellPoints(cellId:int, ptIds:'vtkIdList', dataDescription:int, dim:MutableSequence[int]) -> None: ...
    @staticmethod
    def GetDataDescription(dims:MutableSequence[int]) -> int: ...
    @staticmethod
    def GetDataDescriptionFromExtent(ext:MutableSequence[int]) -> int: ...
    @overload
    @staticmethod
    def GetDataDimension(dataDescription:int) -> int: ...
    @overload
    @staticmethod
    def GetDataDimension(ext:MutableSequence[int]) -> int: ...
    @staticmethod
    def GetDimensionsFromExtent(ext:Sequence[int], dims:MutableSequence[int], dataDescription:int=...) -> None: ...
    @staticmethod
    def GetGlobalStructuredCoordinates(lijk:Sequence[int], ext:Sequence[int], ijk:MutableSequence[int], dataDescription:int=...) -> None: ...
    @staticmethod
    def GetLocalStructuredCoordinates(ijk:Sequence[int], ext:Sequence[int], lijk:MutableSequence[int], dataDescription:int=...) -> None: ...
    @staticmethod
    def GetNumberOfCells(ext:Sequence[int], dataDescription:int=...) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetNumberOfPoints(ext:Sequence[int], dataDescription:int=...) -> int: ...
    @staticmethod
    def GetPointCells(ptId:int, cellIds:'vtkIdList', dim:MutableSequence[int]) -> None: ...
    @staticmethod
    def GetPoints(xCoords:'vtkDataArray', yCoords:'vtkDataArray', zCoords:'vtkDataArray', extent:MutableSequence[int], dirMatrix:MutableSequence[float]) -> 'vtkPoints': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsCellVisible(cellId:int, dimensions:MutableSequence[int], dataDescription:int, cellGhostArray:'vtkUnsignedCharArray', pointGhostArray:'vtkUnsignedCharArray'=...) -> bool: ...
    @staticmethod
    def IsPointVisible(cellId:int, ghosts:'vtkUnsignedCharArray') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredData': ...
    @staticmethod
    def SetDimensions(inDim:MutableSequence[int], dim:MutableSequence[int]) -> int: ...
    @staticmethod
    def SetExtent(inExt:MutableSequence[int], ext:MutableSequence[int]) -> int: ...

class vtkStructuredExtent(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def Clamp(ext:MutableSequence[int], wholeExt:Sequence[int]) -> None: ...
    @staticmethod
    def GetDimensions(ext:Sequence[int], dims:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    @staticmethod
    def Grow(ext:MutableSequence[int], count:int) -> None: ...
    @overload
    @staticmethod
    def Grow(ext:MutableSequence[int], count:int, wholeExt:MutableSequence[int]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredExtent': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredExtent': ...
    @staticmethod
    def Smaller(ext:Sequence[int], wholeExt:Sequence[int]) -> bool: ...
    @staticmethod
    def StrictlySmaller(ext:Sequence[int], wholeExt:Sequence[int]) -> bool: ...
    @staticmethod
    def Transform(ext:MutableSequence[int], wholeExt:MutableSequence[int]) -> None: ...

class vtkStructuredGrid(vtkPointSet):
    actual_memory_size:'getset_descriptor'
    cell_types_array:'getset_descriptor'
    cells:'getset_descriptor'
    data_description:'getset_descriptor'
    data_dimension:'getset_descriptor'
    data_object_type:'getset_descriptor'
    dimensions:'getset_descriptor'
    extent:'getset_descriptor'
    extent_type:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    max_spatial_dimension:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BlankCell(self, ptId:int) -> None: ...
    def BlankPoint(self, ptId:int) -> None: ...
    def CopyStructure(self, ds:'vtkDataSet') -> None: ...
    def Crop(self, updateExtent:Sequence[int]) -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkStructuredGrid': ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetCell(self, cellId:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, cellId:int, cell:'vtkGenericCell') -> None: ...
    def GetCellBounds(self, cellId:int, bounds:MutableSequence[float]) -> None: ...
    def GetCellDims(self, cellDims:MutableSequence[int]) -> None: ...
    @overload
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList') -> None: ...
    @overload
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList', seedLoc:MutableSequence[int]) -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetCellType(self, cellId:int) -> int: ...
    def GetCellTypesArray(self) -> 'vtkConstantArray_IiE': ...
    def GetCells(self) -> 'vtkStructuredCellArray': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkStructuredGrid': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkStructuredGrid': ...
    def GetDataDescription(self) -> int: ...
    def GetDataDimension(self) -> int: ...
    def GetDataObjectType(self) -> int: ...
    @overload
    def GetDimensions(self) -> Tuple[int, int, int]: ...
    @overload
    def GetDimensions(self, dims:MutableSequence[int]) -> None: ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetExtentType(self) -> int: ...
    def GetMaxCellSize(self) -> int: ...
    def GetMaxSpatialDimension(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    def GetPoint(self, ptId:int) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint(self, ptId:int, p:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint(self, i:int, j:int, k:int, p:MutableSequence[float], adjustForExtent:bool=True) -> None: ...
    def GetPointCells(self, ptId:int, cellIds:'vtkIdList') -> None: ...
    def HasAnyBlankCells(self) -> bool: ...
    def HasAnyBlankPoints(self) -> bool: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCellVisible(self, cellId:int) -> int: ...
    def IsPointVisible(self, ptId:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGrid': ...
    @overload
    def SetDimensions(self, i:int, j:int, k:int) -> None: ...
    @overload
    def SetDimensions(self, dims:Sequence[int]) -> None: ...
    @overload
    def SetExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def SetExtent(self, xMin:int, xMax:int, yMin:int, yMax:int, zMin:int, zMax:int) -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    def UnBlankCell(self, ptId:int) -> None: ...
    def UnBlankPoint(self, ptId:int) -> None: ...

class vtkStructuredPoints(vtkImageData):
    data_object_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredPoints': ...

class vtkStructuredPointsCollection(vtkmodules.vtkCommonCore.vtkCollection):
    next_item:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddItem(self, ds:'vtkStructuredPoints') -> None: ...
    def GetNextItem(self) -> 'vtkStructuredPoints': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredPointsCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredPointsCollection': ...

class vtkSuperquadric(vtkImplicitFunction):
    center:'getset_descriptor'
    phi_roundness:'getset_descriptor'
    scale:'getset_descriptor'
    size:'getset_descriptor'
    theta_roundness:'getset_descriptor'
    thickness:'getset_descriptor'
    toroidal:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhiRoundness(self) -> float: ...
    def GetScale(self) -> Tuple[float, float, float]: ...
    def GetSize(self) -> float: ...
    def GetThetaRoundness(self) -> float: ...
    def GetThickness(self) -> float: ...
    def GetThicknessMaxValue(self) -> float: ...
    def GetThicknessMinValue(self) -> float: ...
    def GetToroidal(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSuperquadric': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSuperquadric': ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetPhiRoundness(self, e:float) -> None: ...
    @overload
    def SetScale(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetScale(self, _arg:Sequence[float]) -> None: ...
    def SetSize(self, _arg:float) -> None: ...
    def SetThetaRoundness(self, e:float) -> None: ...
    def SetThickness(self, _arg:float) -> None: ...
    def SetToroidal(self, _arg:int) -> None: ...
    def ToroidalOff(self) -> None: ...
    def ToroidalOn(self) -> None: ...

class vtkTable(vtkDataObject):
    actual_memory_size:'getset_descriptor'
    data_object_type:'getset_descriptor'
    number_of_columns:'getset_descriptor'
    number_of_rows:'getset_descriptor'
    row_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddColumn(self, arr:'vtkAbstractArray') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    def Dump(self, colWidth:int=16, rowLimit:int=-1) -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkTable': ...
    def GetActualMemorySize(self) -> int: ...
    def GetAttributesAsFieldData(self, type:int) -> 'vtkFieldData': ...
    def GetColumn(self, col:int) -> 'vtkAbstractArray': ...
    def GetColumnByName(self, name:str) -> 'vtkAbstractArray': ...
    def GetColumnIndex(self, name:str) -> int: ...
    def GetColumnName(self, col:int) -> str: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkTable': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkTable': ...
    def GetDataObjectType(self) -> int: ...
    def GetNumberOfColumns(self) -> int: ...
    def GetNumberOfElements(self, type:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRows(self) -> int: ...
    @overload
    def GetRow(self, row:int) -> 'vtkVariantArray': ...
    @overload
    def GetRow(self, row:int, values:'vtkVariantArray') -> None: ...
    def GetRowData(self) -> 'vtkDataSetAttributes': ...
    def GetValue(self, row:int, col:int) -> 'vtkVariant': ...
    def GetValueByName(self, row:int, col:str) -> 'vtkVariant': ...
    def Initialize(self) -> None: ...
    def InsertColumn(self, arr:'vtkAbstractArray', index:int) -> None: ...
    def InsertNextBlankRow(self, default_num_val:float=0.0) -> int: ...
    def InsertNextRow(self, values:'vtkVariantArray') -> int: ...
    def InsertRow(self, row:int) -> None: ...
    def InsertRows(self, row:int, n:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTable': ...
    def RemoveAllColumns(self) -> None: ...
    def RemoveAllRows(self) -> None: ...
    def RemoveColumn(self, col:int) -> None: ...
    def RemoveColumnByName(self, name:str) -> None: ...
    def RemoveRow(self, row:int) -> None: ...
    def RemoveRows(self, row:int, n:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTable': ...
    def SetNumberOfRows(self, __a:int) -> None: ...
    def SetRow(self, row:int, values:'vtkVariantArray') -> None: ...
    def SetRowData(self, data:'vtkDataSetAttributes') -> None: ...
    def SetValue(self, row:int, col:int, value:'vtkVariant') -> None: ...
    def SetValueByName(self, row:int, col:str, value:'vtkVariant') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    def SqueezeRows(self) -> None: ...

class vtkTetra(vtkCell3D):
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def BarycentricCoords(x:MutableSequence[float], x1:MutableSequence[float], x2:MutableSequence[float], x3:MutableSequence[float], x4:MutableSequence[float], bcoords:MutableSequence[float]) -> int: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    @staticmethod
    def Circumsphere(x1:MutableSequence[float], x2:MutableSequence[float], x3:MutableSequence[float], x4:MutableSequence[float], center:MutableSequence[float]) -> float: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', connectivity:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    @staticmethod
    def ComputeCentroid(points:'vtkPoints', pointIds:Sequence[int], centroid:MutableSequence[float]) -> bool: ...
    @staticmethod
    def ComputeVolume(p1:MutableSequence[float], p2:MutableSequence[float], p3:MutableSequence[float], p4:MutableSequence[float]) -> float: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellType(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Tuple[int, int]: ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, pts:Sequence[int]) -> None: ...
    @staticmethod
    def GetEdgeToAdjacentFacesArray(edgeId:int) -> Tuple[int, int]: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Tuple[int, int, int]: ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetFaceToAdjacentFacesArray(faceId:int) -> Tuple[int, int, int]: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def GetPointToIncidentEdges(self, pointId:int, edgeIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentEdgesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToIncidentFaces(self, pointId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentFacesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToOneRingPointsArray(pointId:int) -> Tuple[int, int, int]: ...
    @staticmethod
    def GetTriangleCases(caseId:int) -> Pointer: ...
    @staticmethod
    def Insphere(p1:MutableSequence[float], p2:MutableSequence[float], p3:MutableSequence[float], p4:MutableSequence[float], center:MutableSequence[float]) -> float: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInsideOut(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTetra': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTetra': ...
    @staticmethod
    def TetraCenter(p1:MutableSequence[float], p2:MutableSequence[float], p3:MutableSequence[float], p4:MutableSequence[float], center:MutableSequence[float]) -> None: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkTree(vtkDirectedAcyclicGraph):
    data_object_type:'getset_descriptor'
    root:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetChild(self, v:int, i:int) -> int: ...
    def GetChildren(self, v:int, it:'vtkAdjacentVertexIterator') -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkTree': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkTree': ...
    def GetDataObjectType(self) -> int: ...
    def GetLevel(self, v:int) -> int: ...
    def GetNumberOfChildren(self, v:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParent(self, v:int) -> int: ...
    def GetParentEdge(self, v:int) -> 'vtkEdgeType': ...
    def GetRoot(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsLeaf(self, vertex:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTree': ...
    def ReorderChildren(self, parent:int, children:'vtkIdTypeArray') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTree': ...

class vtkTreeIterator(vtkmodules.vtkCommonCore.vtkObject):
    start_vertex:'getset_descriptor'
    tree:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStartVertex(self) -> int: ...
    def GetTree(self) -> 'vtkTree': ...
    def HasNext(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeIterator': ...
    def Next(self) -> int: ...
    def Restart(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeIterator': ...
    def SetStartVertex(self, vertex:int) -> None: ...
    def SetTree(self, tree:'vtkTree') -> None: ...

class vtkTreeBFSIterator(vtkTreeIterator):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeBFSIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeBFSIterator': ...

class vtkTreeDFSIterator(vtkTreeIterator):
    class ModeType(int): ...
    DISCOVER:'ModeType'
    FINISH:'ModeType'
    mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMode(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeDFSIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeDFSIterator': ...
    def SetMode(self, mode:int) -> None: ...

class vtkTriQuadraticHexahedron(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tetras:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTriQuadraticHexahedron': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTriQuadraticHexahedron': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkTriQuadraticPyramid(vtkNonLinearCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', tets:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Pointer: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Pointer: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTriQuadraticPyramid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTriQuadraticPyramid': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkTriangle(vtkCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def BarycentricCoords(x:Sequence[float], x1:Sequence[float], x2:Sequence[float], x3:Sequence[float], bcoords:MutableSequence[float]) -> int: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    @staticmethod
    def Circumcircle(p1:Sequence[float], p2:Sequence[float], p3:Sequence[float], center:MutableSequence[float]) -> float: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def ComputeArea(self) -> float: ...
    @staticmethod
    def ComputeCentroid(points:'vtkPoints', pointIds:Sequence[int], centroid:MutableSequence[float]) -> bool: ...
    @overload
    @staticmethod
    def ComputeNormal(p:'vtkPoints', numPts:int, pts:Sequence[int], n:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ComputeNormal(v1:Sequence[float], v2:Sequence[float], v3:Sequence[float], n:MutableSequence[float]) -> None: ...
    @staticmethod
    def ComputeNormalDirection(v1:Sequence[float], v2:Sequence[float], v3:Sequence[float], n:MutableSequence[float]) -> None: ...
    @overload
    @staticmethod
    def ComputeQuadric(x1:Sequence[float], x2:Sequence[float], x3:Sequence[float], quadric:MutableSequence[MutableSequence[float]]) -> None: ...
    @overload
    @staticmethod
    def ComputeQuadric(x1:Sequence[float], x2:Sequence[float], x3:Sequence[float], quadric:'vtkQuadric') -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetEdgeArray(self, edgeId:int) -> Pointer: ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetParametricDistance(self, pcoords:Sequence[float]) -> float: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], sf:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], sf:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTriangle': ...
    @staticmethod
    def PointInTriangle(x:Sequence[float], x1:Sequence[float], x2:Sequence[float], x3:Sequence[float], tol2:float) -> int: ...
    @staticmethod
    def ProjectTo2D(x1:Sequence[float], x2:Sequence[float], x3:Sequence[float], v1:MutableSequence[float], v2:MutableSequence[float], v3:MutableSequence[float]) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTriangle': ...
    @staticmethod
    def TriangleArea(p1:Sequence[float], p2:Sequence[float], p3:Sequence[float]) -> float: ...
    @staticmethod
    def TriangleCenter(p1:Sequence[float], p2:Sequence[float], p3:Sequence[float], center:MutableSequence[float]) -> None: ...
    @staticmethod
    def TrianglesIntersect(p1:Sequence[float], q1:Sequence[float], r1:Sequence[float], p2:Sequence[float], q2:Sequence[float], r2:Sequence[float]) -> int: ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkTriangleStrip(vtkCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    @staticmethod
    def DecomposeStrip(npts:int, pts:Sequence[int], tris:'vtkCellArray') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsPrimaryCell(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTriangleStrip': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTriangleStrip': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkUniformGrid(vtkImageData):
    data_object_type:'getset_descriptor'
    grid_description:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CopyStructure(self, ds:'vtkDataSet') -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkUniformGrid': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkUniformGrid': ...
    def GetDataObjectType(self) -> int: ...
    def GetGridDescription(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewImageDataCopy(self) -> 'vtkImageData': ...
    def NewInstance(self) -> 'vtkUniformGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUniformGrid': ...

class vtkUniformGridAMRDataIterator(vtkCompositeDataIterator):
    current_data_object:'getset_descriptor'
    current_flat_index:'getset_descriptor'
    current_index:'getset_descriptor'
    current_level:'getset_descriptor'
    current_meta_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCurrentDataObject(self) -> 'vtkDataObject': ...
    def GetCurrentFlatIndex(self) -> int: ...
    def GetCurrentIndex(self) -> int: ...
    def GetCurrentLevel(self) -> int: ...
    def GetCurrentMetaData(self) -> 'vtkInformation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GoToFirstItem(self) -> None: ...
    def GoToNextItem(self) -> None: ...
    def HasCurrentMetaData(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUniformGridAMRDataIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUniformGridAMRDataIterator': ...

class vtkUniformHyperTreeGrid(vtkHyperTreeGrid):
    actual_memory_size_bytes:'getset_descriptor'
    data_object_type:'getset_descriptor'
    grid_scale:'getset_descriptor'
    origin:'getset_descriptor'
    x_coordinates:'getset_descriptor'
    y_coordinates:'getset_descriptor'
    z_coordinates:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CopyCoordinates(self, output:'vtkHyperTreeGrid') -> None: ...
    def CopyStructure(self, __a:'vtkDataObject') -> None: ...
    def DeepCopy(self, __a:'vtkDataObject') -> None: ...
    def GetActualMemorySizeBytes(self) -> int: ...
    def GetDataObjectType(self) -> int: ...
    def GetGridBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetGridScale(self) -> Tuple[float, float, float]: ...
    def GetLevelZeroOriginAndSizeFromIndex(self, __a:int, __b:MutableSequence[float], __c:MutableSequence[float]) -> None: ...
    def GetLevelZeroOriginFromIndex(self, __a:int, __b:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetTree(self, __a:int, create:bool=False) -> 'vtkHyperTree': ...
    def GetXCoordinates(self) -> 'vtkDataArray': ...
    def GetYCoordinates(self) -> 'vtkDataArray': ...
    def GetZCoordinates(self) -> 'vtkDataArray': ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUniformHyperTreeGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUniformHyperTreeGrid': ...
    def SetFixedCoordinates(self, axis:int, value:float) -> None: ...
    @overload
    def SetGridScale(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetGridScale(self, __a:MutableSequence[float]) -> None: ...
    @overload
    def SetGridScale(self, __a:float) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetXCoordinates(self, XCoordinates:'vtkDataArray') -> None: ...
    def SetYCoordinates(self, YCoordinates:'vtkDataArray') -> None: ...
    def SetZCoordinates(self, ZCoordinates:'vtkDataArray') -> None: ...
    def ShallowCopy(self, __a:'vtkDataObject') -> None: ...

class vtkUnstructuredGridBase(vtkPointSet):
    data_object_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Allocate(self, numCells:int=1000, extSize:int=1000) -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkUnstructuredGridBase': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkUnstructuredGridBase': ...
    def GetDataObjectType(self) -> int: ...
    def GetIdsOfCellsOfType(self, type:int, array:'vtkIdTypeArray') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def InsertNextCell(self, type:int, npts:int, ptIds:Sequence[int]) -> int: ...
    @overload
    def InsertNextCell(self, type:int, ptIds:'vtkIdList') -> int: ...
    @overload
    def InsertNextCell(self, type:int, npts:int, ptIds:Sequence[int], nfaces:int, faces:Sequence[int]) -> int: ...
    @overload
    def InsertNextCell(self, type:int, npts:int, ptIds:Sequence[int], faces:'vtkCellArray') -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsHomogeneous(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridBase': ...
    def ReplaceCell(self, cellId:int, npts:int, pts:Sequence[int]) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridBase': ...

class vtkUnstructuredGrid(vtkUnstructuredGridBase):
    actual_memory_size:'getset_descriptor'
    cell_links:'getset_descriptor'
    cell_locations_array:'getset_descriptor'
    cell_types_array:'getset_descriptor'
    cells:'getset_descriptor'
    data_object_type:'getset_descriptor'
    distinct_cell_types_array:'getset_descriptor'
    face_locations:'getset_descriptor'
    faces:'getset_descriptor'
    ghost_level:'getset_descriptor'
    links:'getset_descriptor'
    max_cell_size:'getset_descriptor'
    max_spatial_dimension:'getset_descriptor'
    mesh_m_time:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    piece:'getset_descriptor'
    polyhedron_face_locations:'getset_descriptor'
    polyhedron_faces:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddReferenceToCell(self, ptId:int, cellId:int) -> None: ...
    def Allocate(self, numCells:int=1000, extSize:int=1000) -> None: ...
    def AllocateEstimate(self, numCells:int, maxCellSize:int) -> bool: ...
    def AllocateExact(self, numCells:int, connectivitySize:int) -> bool: ...
    def BuildLinks(self) -> None: ...
    @overload
    @staticmethod
    def ConvertFaceStreamPointIds(faceStream:'vtkIdList', idMap:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def ConvertFaceStreamPointIds(nfaces:int, faceStream:MutableSequence[int], idMap:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def ConvertFaceStreamPointIds(faces:'vtkCellArray', idMap:MutableSequence[int]) -> None: ...
    def CopyStructure(self, ds:'vtkDataSet') -> None: ...
    @overload
    @staticmethod
    def DecomposeAPolyhedronCell(polyhedronCellArray:'vtkCellArray', nCellpts:int, nCellfaces:int, cellArray:'vtkCellArray', faces:'vtkIdTypeArray') -> None: ...
    @overload
    @staticmethod
    def DecomposeAPolyhedronCell(polyhedronCellStream:Sequence[int], nCellpts:int, nCellfaces:int, cellArray:'vtkCellArray', faces:'vtkIdTypeArray') -> None: ...
    @overload
    @staticmethod
    def DecomposeAPolyhedronCell(nCellFaces:int, inFaceStream:Sequence[int], nCellpts:int, cellArray:'vtkCellArray', faces:'vtkIdTypeArray') -> None: ...
    def DeepCopy(self, src:'vtkDataObject') -> None: ...
    @staticmethod
    def ExtendedNew() -> 'vtkUnstructuredGrid': ...
    def GetActualMemorySize(self) -> int: ...
    @overload
    def GetCell(self, cellId:int) -> 'vtkCell': ...
    @overload
    def GetCell(self, cellId:int, cell:'vtkGenericCell') -> None: ...
    @overload
    def GetCell(self, i:int, j:int, k:int) -> 'vtkCell': ...
    def GetCellBounds(self, cellId:int, bounds:MutableSequence[float]) -> None: ...
    def GetCellLinks(self) -> 'vtkAbstractCellLinks': ...
    def GetCellLocationsArray(self) -> 'vtkIdTypeArray': ...
    @overload
    def GetCellNeighbors(self, cellId:int, ptIds:'vtkIdList', cellIds:'vtkIdList') -> None: ...
    @overload
    def GetCellNeighbors(self, cellId:int, npts:int, ptIds:Sequence[int], cellIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int]) -> None: ...
    @overload
    def GetCellPoints(self, cellId:int, npts:int, pts:Sequence[int], ptIds:'vtkIdList') -> None: ...
    def GetCellSize(self, cellId:int) -> int: ...
    def GetCellType(self, cellId:int) -> int: ...
    def GetCellTypes(self, types:'vtkCellTypes') -> None: ...
    def GetCellTypesArray(self) -> 'vtkUnsignedCharArray': ...
    def GetCells(self) -> 'vtkCellArray': ...
    @overload
    @staticmethod
    def GetData(info:'vtkInformation') -> 'vtkUnstructuredGrid': ...
    @overload
    @staticmethod
    def GetData(v:'vtkInformationVector', i:int=0) -> 'vtkUnstructuredGrid': ...
    def GetDataObjectType(self) -> int: ...
    def GetDistinctCellTypesArray(self) -> 'vtkUnsignedCharArray': ...
    def GetFaceLocations(self) -> 'vtkIdTypeArray': ...
    @overload
    def GetFaceStream(self, cellId:int, ptIds:'vtkIdList') -> None: ...
    @overload
    def GetFaceStream(self, cellId:int, nfaces:int, ptIds:Sequence[int]) -> None: ...
    @overload
    def GetFaces(self, cellId:int) -> Pointer: ...
    @overload
    def GetFaces(self) -> 'vtkIdTypeArray': ...
    def GetGhostLevel(self) -> int: ...
    def GetIdsOfCellsOfType(self, type:int, array:'vtkIdTypeArray') -> None: ...
    def GetLinks(self) -> 'vtkAbstractCellLinks': ...
    def GetMaxCellSize(self) -> int: ...
    def GetMaxSpatialDimension(self) -> int: ...
    def GetMeshMTime(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetPiece(self) -> int: ...
    @overload
    def GetPointCells(self, ptId:int, cellIds:'vtkIdList') -> None: ...
    @overload
    def GetPointCells(self, ptId:int, ncells:int, cells:MutableSequence[int]) -> None: ...
    def GetPolyhedronFaceLocations(self) -> 'vtkCellArray': ...
    @overload
    def GetPolyhedronFaces(self, cellId:int, faces:'vtkCellArray') -> None: ...
    @overload
    def GetPolyhedronFaces(self) -> 'vtkCellArray': ...
    def Initialize(self) -> None: ...
    def InitializeFacesRepresentation(self, numPrevCells:int) -> int: ...
    def InsertNextLinkedCell(self, type:int, npts:int, pts:Sequence[int]) -> int: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsCellBoundary(self, cellId:int, npts:int, ptIds:Sequence[int], neighborCellId:int) -> bool: ...
    @overload
    def IsCellBoundary(self, cellId:int, npts:int, ptIds:Sequence[int]) -> bool: ...
    @overload
    def IsCellBoundary(self, cellId:int, npts:int, ptIds:Sequence[int], cellIds:'vtkIdList') -> bool: ...
    def IsHomogeneous(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewCellIterator(self) -> 'vtkCellIterator': ...
    def NewInstance(self) -> 'vtkUnstructuredGrid': ...
    def RemoveGhostCells(self) -> None: ...
    def RemoveReferenceToCell(self, ptId:int, cellId:int) -> None: ...
    def Reset(self) -> None: ...
    def ResizeCellList(self, ptId:int, size:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGrid': ...
    @overload
    def SetCells(self, type:int, cells:'vtkCellArray') -> None: ...
    @overload
    def SetCells(self, types:MutableSequence[int], cells:'vtkCellArray') -> None: ...
    @overload
    def SetCells(self, cellTypes:'vtkUnsignedCharArray', cells:'vtkCellArray') -> None: ...
    @overload
    def SetCells(self, cellTypes:'vtkUnsignedCharArray', cells:'vtkCellArray', faceLocations:'vtkIdTypeArray', faces:'vtkIdTypeArray') -> None: ...
    @overload
    def SetCells(self, cellTypes:'vtkUnsignedCharArray', cellLocations:'vtkIdTypeArray', cells:'vtkCellArray') -> None: ...
    @overload
    def SetCells(self, cellTypes:'vtkUnsignedCharArray', cellLocations:'vtkIdTypeArray', cells:'vtkCellArray', faceLocations:'vtkIdTypeArray', faces:'vtkIdTypeArray') -> None: ...
    def SetLinks(self, _arg:'vtkAbstractCellLinks') -> None: ...
    def SetPolyhedralCells(self, cellTypes:'vtkUnsignedCharArray', cells:'vtkCellArray', faceLocations:'vtkCellArray', faces:'vtkCellArray') -> None: ...
    def ShallowCopy(self, src:'vtkDataObject') -> None: ...
    def Squeeze(self) -> None: ...

class vtkUnstructuredGridCellIterator(vtkCellIterator):
    cell_id:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GoToCell(self, cellId:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsDoneWithTraversal(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridCellIterator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridCellIterator': ...

class vtkVector_IdLi2EE(vtkmodules.vtkCommonMath.vtkTuple_IdLi2EE):
    def Dot(self, other:'vtkVector_IdLi2EE') -> float: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> float: ...
    def Normalized(self) -> 'vtkVector_IdLi2EE': ...
    def SquaredNorm(self) -> float: ...

class vtkVector2_IdE(vtkVector_IdLi2EE):
    x:'getset_descriptor'
    y:'getset_descriptor'
    def GetX(self) -> float: ...
    def GetY(self) -> float: ...
    def Set(self, x:float, y:float) -> None: ...
    def SetX(self, x:float) -> None: ...
    def SetY(self, y:float) -> None: ...

class vtkVector_IfLi2EE(vtkmodules.vtkCommonMath.vtkTuple_IfLi2EE):
    def Dot(self, other:'vtkVector_IfLi2EE') -> float: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> float: ...
    def Normalized(self) -> 'vtkVector_IfLi2EE': ...
    def SquaredNorm(self) -> float: ...

class vtkVector2_IfE(vtkVector_IfLi2EE):
    x:'getset_descriptor'
    y:'getset_descriptor'
    def GetX(self) -> float: ...
    def GetY(self) -> float: ...
    def Set(self, x:float, y:float) -> None: ...
    def SetX(self, x:float) -> None: ...
    def SetY(self, y:float) -> None: ...

class vtkVector_IiLi2EE(vtkmodules.vtkCommonMath.vtkTuple_IiLi2EE):
    def Dot(self, other:'vtkVector_IiLi2EE') -> int: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> float: ...
    def Normalized(self) -> 'vtkVector_IiLi2EE': ...
    def SquaredNorm(self) -> int: ...

class vtkVector2_IiE(vtkVector_IiLi2EE):
    x:'getset_descriptor'
    y:'getset_descriptor'
    def GetX(self) -> int: ...
    def GetY(self) -> int: ...
    def Set(self, x:int, y:int) -> None: ...
    def SetX(self, x:int) -> None: ...
    def SetY(self, y:int) -> None: ...

class vtkVector2d(vtkVector2_IdE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:float, y:float) -> None: ...
    @overload
    def __init__(self, s:float) -> None: ...
    @overload
    def __init__(self, i:Sequence[float]) -> None: ...
    @overload
    def __init__(self, o:'vtkTuple_IdLi2EE') -> None: ...
    @overload
    def __init__(self, o:'vtkVector_IdLi2EE') -> None: ...
    @overload
    def __init__(self, __a:'vtkVector2d') -> None: ...
    def Normalized(self) -> 'vtkVector2d': ...

class vtkVector2f(vtkVector2_IfE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:float, y:float) -> None: ...
    @overload
    def __init__(self, s:float) -> None: ...
    @overload
    def __init__(self, i:Sequence[float]) -> None: ...
    @overload
    def __init__(self, o:'vtkTuple_IfLi2EE') -> None: ...
    @overload
    def __init__(self, o:'vtkVector_IfLi2EE') -> None: ...
    @overload
    def __init__(self, __a:'vtkVector2f') -> None: ...
    def Normalized(self) -> 'vtkVector2f': ...

class vtkVector2i(vtkVector2_IiE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:int, y:int) -> None: ...
    @overload
    def __init__(self, s:int) -> None: ...
    @overload
    def __init__(self, i:Sequence[int]) -> None: ...
    @overload
    def __init__(self, o:'vtkTuple_IiLi2EE') -> None: ...
    @overload
    def __init__(self, o:'vtkVector_IiLi2EE') -> None: ...
    @overload
    def __init__(self, __a:'vtkVector2i') -> None: ...
    def Normalized(self) -> 'vtkVector2i': ...

class vtkVector_IdLi3EE(vtkmodules.vtkCommonMath.vtkTuple_IdLi3EE):
    def Dot(self, other:'vtkVector_IdLi3EE') -> float: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> float: ...
    def Normalized(self) -> 'vtkVector_IdLi3EE': ...
    def SquaredNorm(self) -> float: ...

class vtkVector3_IdE(vtkVector_IdLi3EE):
    x:'getset_descriptor'
    y:'getset_descriptor'
    z:'getset_descriptor'
    def Cross(self, other:'vtkVector3_IdE') -> 'vtkVector3_IdE': ...
    def GetX(self) -> float: ...
    def GetY(self) -> float: ...
    def GetZ(self) -> float: ...
    def Set(self, x:float, y:float, z:float) -> None: ...
    def SetX(self, x:float) -> None: ...
    def SetY(self, y:float) -> None: ...
    def SetZ(self, z:float) -> None: ...

class vtkVector_IfLi3EE(vtkmodules.vtkCommonMath.vtkTuple_IfLi3EE):
    def Dot(self, other:'vtkVector_IfLi3EE') -> float: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> float: ...
    def Normalized(self) -> 'vtkVector_IfLi3EE': ...
    def SquaredNorm(self) -> float: ...

class vtkVector3_IfE(vtkVector_IfLi3EE):
    x:'getset_descriptor'
    y:'getset_descriptor'
    z:'getset_descriptor'
    def Cross(self, other:'vtkVector3_IfE') -> 'vtkVector3_IfE': ...
    def GetX(self) -> float: ...
    def GetY(self) -> float: ...
    def GetZ(self) -> float: ...
    def Set(self, x:float, y:float, z:float) -> None: ...
    def SetX(self, x:float) -> None: ...
    def SetY(self, y:float) -> None: ...
    def SetZ(self, z:float) -> None: ...

class vtkVector_IiLi3EE(vtkmodules.vtkCommonMath.vtkTuple_IiLi3EE):
    def Dot(self, other:'vtkVector_IiLi3EE') -> int: ...
    def Norm(self) -> float: ...
    def Normalize(self) -> float: ...
    def Normalized(self) -> 'vtkVector_IiLi3EE': ...
    def SquaredNorm(self) -> int: ...

class vtkVector3_IiE(vtkVector_IiLi3EE):
    x:'getset_descriptor'
    y:'getset_descriptor'
    z:'getset_descriptor'
    def Cross(self, other:'vtkVector3_IiE') -> 'vtkVector3_IiE': ...
    def GetX(self) -> int: ...
    def GetY(self) -> int: ...
    def GetZ(self) -> int: ...
    def Set(self, x:int, y:int, z:int) -> None: ...
    def SetX(self, x:int) -> None: ...
    def SetY(self, y:int) -> None: ...
    def SetZ(self, z:int) -> None: ...

class vtkVector3d(vtkVector3_IdE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:float, y:float, z:float) -> None: ...
    @overload
    def __init__(self, s:float) -> None: ...
    @overload
    def __init__(self, i:Sequence[float]) -> None: ...
    @overload
    def __init__(self, o:'vtkTuple_IdLi3EE') -> None: ...
    @overload
    def __init__(self, o:'vtkVector_IdLi3EE') -> None: ...
    @overload
    def __init__(self, __a:'vtkVector3d') -> None: ...
    def Cross(self, other:'vtkVector3d') -> 'vtkVector3d': ...
    def Normalized(self) -> 'vtkVector3d': ...

class vtkVector3f(vtkVector3_IfE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:float, y:float, z:float) -> None: ...
    @overload
    def __init__(self, s:float) -> None: ...
    @overload
    def __init__(self, i:Sequence[float]) -> None: ...
    @overload
    def __init__(self, o:'vtkTuple_IfLi3EE') -> None: ...
    @overload
    def __init__(self, o:'vtkVector_IfLi3EE') -> None: ...
    @overload
    def __init__(self, __a:'vtkVector3f') -> None: ...
    def Cross(self, other:'vtkVector3f') -> 'vtkVector3f': ...
    def Normalized(self) -> 'vtkVector3f': ...

class vtkVector3i(vtkVector3_IiE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:int, y:int, z:int) -> None: ...
    @overload
    def __init__(self, s:int) -> None: ...
    @overload
    def __init__(self, i:Sequence[int]) -> None: ...
    @overload
    def __init__(self, o:'vtkTuple_IiLi3EE') -> None: ...
    @overload
    def __init__(self, o:'vtkVector_IiLi3EE') -> None: ...
    @overload
    def __init__(self, __a:'vtkVector3i') -> None: ...
    def Cross(self, other:'vtkVector3i') -> 'vtkVector3i': ...
    def Normalized(self) -> 'vtkVector3i': ...

class vtkVector4_IdE(vtkVector_IdLi4EE):
    w:'getset_descriptor'
    x:'getset_descriptor'
    y:'getset_descriptor'
    z:'getset_descriptor'
    def GetW(self) -> float: ...
    def GetX(self) -> float: ...
    def GetY(self) -> float: ...
    def GetZ(self) -> float: ...
    def Set(self, x:float, y:float, z:float, w:float) -> None: ...
    def SetW(self, w:float) -> None: ...
    def SetX(self, x:float) -> None: ...
    def SetY(self, y:float) -> None: ...
    def SetZ(self, z:float) -> None: ...

class vtkVector4_IiE(vtkVector_IiLi4EE):
    w:'getset_descriptor'
    x:'getset_descriptor'
    y:'getset_descriptor'
    z:'getset_descriptor'
    def GetW(self) -> int: ...
    def GetX(self) -> int: ...
    def GetY(self) -> int: ...
    def GetZ(self) -> int: ...
    def Set(self, x:int, y:int, z:int, w:int) -> None: ...
    def SetW(self, w:int) -> None: ...
    def SetX(self, x:int) -> None: ...
    def SetY(self, y:int) -> None: ...
    def SetZ(self, z:int) -> None: ...

class vtkVector4d(vtkVector4_IdE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:float, y:float, z:float, w:float) -> None: ...
    @overload
    def __init__(self, s:float) -> None: ...
    @overload
    def __init__(self, i:Sequence[float]) -> None: ...
    @overload
    def __init__(self, o:'vtkTuple_IdLi4EE') -> None: ...
    @overload
    def __init__(self, o:'vtkVector_IdLi4EE') -> None: ...
    @overload
    def __init__(self, __a:'vtkVector4d') -> None: ...
    def Normalized(self) -> 'vtkVector4d': ...

class vtkVector4i(vtkVector4_IiE):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x:int, y:int, z:int, w:int) -> None: ...
    @overload
    def __init__(self, s:int) -> None: ...
    @overload
    def __init__(self, i:Sequence[int]) -> None: ...
    @overload
    def __init__(self, o:'vtkTuple_IiLi4EE') -> None: ...
    @overload
    def __init__(self, o:'vtkVector_IiLi4EE') -> None: ...
    @overload
    def __init__(self, __a:'vtkVector4i') -> None: ...
    def Normalized(self) -> 'vtkVector4i': ...

class vtkVertex(vtkCell):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def Clip(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', pts:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData', insideOut:int) -> None: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts1:'vtkCellArray', lines:'vtkCellArray', verts2:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetEdge(self, __a:int) -> 'vtkCell': ...
    def GetFace(self, __a:int) -> 'vtkCell': ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def Inflate(self, __a:float) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVertex': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVertex': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkVertexAdjacencyList(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkVertexAdjacencyList') -> None: ...

class vtkVertexListIterator(vtkmodules.vtkCommonCore.vtkObject):
    graph:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetGraph(self) -> 'vtkGraph': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasNext(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVertexListIterator': ...
    def Next(self) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVertexListIterator': ...
    def SetGraph(self, graph:'vtkGraph') -> None: ...

class vtkVoxel(vtkCell3D):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    def ComputeBoundingSphere(self, center:MutableSequence[float]) -> float: ...
    @staticmethod
    def ComputeCentroid(points:'vtkPoints', pointIds:Sequence[int], centroid:MutableSequence[float]) -> bool: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Tuple[int, int]: ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, pts:Sequence[int]) -> None: ...
    @staticmethod
    def GetEdgeToAdjacentFacesArray(edgeId:int) -> Tuple[int, int]: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> Tuple[int, int, int, int]: ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faces:Sequence[int]) -> int: ...
    @staticmethod
    def GetFaceToAdjacentFacesArray(faceId:int) -> Tuple[int, int, int, int]: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetPointToIncidentEdges(self, pointId:int, edges:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentEdgesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToIncidentFaces(self, pointId:int, faces:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentFacesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToOneRingPointsArray(pointId:int) -> Tuple[int, int, int]: ...
    @staticmethod
    def GetTriangleCases(caseId:int) -> Pointer: ...
    def Inflate(self, dist:float) -> int: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInsideOut(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVoxel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVoxel': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkWedge(vtkCell3D):
    cell_dimension:'getset_descriptor'
    cell_type:'getset_descriptor'
    parametric_coords:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellBoundary(self, subId:int, pcoords:Sequence[float], pts:'vtkIdList') -> int: ...
    @staticmethod
    def ComputeCentroid(points:'vtkPoints', pointIds:Sequence[int], centroid:MutableSequence[float]) -> bool: ...
    def Contour(self, value:float, cellScalars:'vtkDataArray', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', outPd:'vtkPointData', inCd:'vtkCellData', cellId:int, outCd:'vtkCellData') -> None: ...
    def Derivatives(self, subId:int, pcoords:Sequence[float], values:Sequence[float], dim:int, derivs:MutableSequence[float]) -> None: ...
    def EvaluateLocation(self, subId:int, pcoords:Sequence[float], x:MutableSequence[float], weights:MutableSequence[float]) -> None: ...
    def EvaluatePosition(self, x:Sequence[float], closestPoint:MutableSequence[float], subId:int, pcoords:MutableSequence[float], dist2:float, weights:MutableSequence[float]) -> int: ...
    def GetCellDimension(self) -> int: ...
    def GetCellType(self) -> int: ...
    def GetCentroid(self, centroid:MutableSequence[float]) -> bool: ...
    def GetEdge(self, edgeId:int) -> 'vtkCell': ...
    @staticmethod
    def GetEdgeArray(edgeId:int) -> Tuple[int, int]: ...
    def GetEdgePoints(self, edgeId:int, pts:Sequence[int]) -> None: ...
    def GetEdgeToAdjacentFaces(self, edgeId:int, pts:Sequence[int]) -> None: ...
    @staticmethod
    def GetEdgeToAdjacentFacesArray(edgeId:int) -> Tuple[int, int]: ...
    def GetFace(self, faceId:int) -> 'vtkCell': ...
    @staticmethod
    def GetFaceArray(faceId:int) -> (int): ...
    def GetFacePoints(self, faceId:int, pts:Sequence[int]) -> int: ...
    def GetFaceToAdjacentFaces(self, faceId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetFaceToAdjacentFacesArray(faceId:int) -> Tuple[int, int, int, int]: ...
    def GetNumberOfEdges(self) -> int: ...
    def GetNumberOfFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricCenter(self, pcoords:MutableSequence[float]) -> int: ...
    def GetParametricCoords(self) -> Tuple[float, float]: ...
    def GetPointToIncidentEdges(self, pointId:int, edgeIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentEdgesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToIncidentFaces(self, pointId:int, faceIds:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToIncidentFacesArray(pointId:int) -> Tuple[int, int, int]: ...
    def GetPointToOneRingPoints(self, pointId:int, pts:Sequence[int]) -> int: ...
    @staticmethod
    def GetPointToOneRingPointsArray(pointId:int) -> Tuple[int, int, int]: ...
    @staticmethod
    def GetTriangleCases(caseId:int) -> Pointer: ...
    def InterpolateDerivs(self, pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    def InterpolateFunctions(self, pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationDerivs(pcoords:Sequence[float], derivs:MutableSequence[float]) -> None: ...
    @staticmethod
    def InterpolationFunctions(pcoords:Sequence[float], weights:MutableSequence[float]) -> None: ...
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInsideOut(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWedge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWedge': ...
    def TriangulateLocalIds(self, index:int, ptIds:'vtkIdList') -> int: ...

class vtkXMLDataElement(vtkmodules.vtkCommonCore.vtkObject):
    attribute_encoding:'getset_descriptor'
    character_data:'getset_descriptor'
    character_data_width:'getset_descriptor'
    id:'getset_descriptor'
    name:'getset_descriptor'
    number_of_attributes:'getset_descriptor'
    parent:'getset_descriptor'
    root:'getset_descriptor'
    xml_byte_index:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddCharacterData(self, c:str, length:int) -> None: ...
    def AddNestedElement(self, element:'vtkXMLDataElement') -> None: ...
    def DeepCopy(self, elem:'vtkXMLDataElement') -> None: ...
    def FindNestedElement(self, id:str) -> 'vtkXMLDataElement': ...
    def FindNestedElementWithName(self, name:str) -> 'vtkXMLDataElement': ...
    def FindNestedElementWithNameAndAttribute(self, name:str, att_name:str, att_value:str) -> 'vtkXMLDataElement': ...
    def FindNestedElementWithNameAndId(self, name:str, id:str) -> 'vtkXMLDataElement': ...
    def GetAttribute(self, name:str) -> str: ...
    def GetAttributeEncoding(self) -> int: ...
    def GetAttributeEncodingMaxValue(self) -> int: ...
    def GetAttributeEncodingMinValue(self) -> int: ...
    def GetAttributeName(self, idx:int) -> str: ...
    def GetAttributeValue(self, idx:int) -> str: ...
    def GetCharacterData(self) -> str: ...
    def GetCharacterDataWidth(self) -> int: ...
    def GetId(self) -> str: ...
    def GetName(self) -> str: ...
    def GetNestedElement(self, index:int) -> 'vtkXMLDataElement': ...
    def GetNumberOfAttributes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNestedElements(self) -> int: ...
    def GetParent(self) -> 'vtkXMLDataElement': ...
    def GetRoot(self) -> 'vtkXMLDataElement': ...
    @overload
    def GetScalarAttribute(self, name:str, value:int) -> int: ...
    @overload
    def GetScalarAttribute(self, name:str, value:float) -> int: ...
    @overload
    def GetVectorAttribute(self, name:str, length:int, value:MutableSequence[int]) -> int: ...
    @overload
    def GetVectorAttribute(self, name:str, length:int, value:MutableSequence[float]) -> int: ...
    def GetWordTypeAttribute(self, name:str, value:int) -> int: ...
    def GetXMLByteIndex(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsEqualTo(self, elem:'vtkXMLDataElement') -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LookupElement(self, id:str) -> 'vtkXMLDataElement': ...
    def LookupElementWithName(self, name:str) -> 'vtkXMLDataElement': ...
    def NewInstance(self) -> 'vtkXMLDataElement': ...
    def PrintXML(self, fname:str) -> None: ...
    def RemoveAllAttributes(self) -> None: ...
    def RemoveAllNestedElements(self) -> None: ...
    def RemoveAttribute(self, name:str) -> None: ...
    def RemoveNestedElement(self, __a:'vtkXMLDataElement') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkXMLDataElement': ...
    def SetAttribute(self, name:str, value:str) -> None: ...
    def SetAttributeEncoding(self, _arg:int) -> None: ...
    def SetCharacterData(self, data:str, length:int) -> None: ...
    def SetCharacterDataWidth(self, _arg:int) -> None: ...
    def SetDoubleAttribute(self, name:str, value:float) -> None: ...
    def SetFloatAttribute(self, name:str, value:float) -> None: ...
    def SetId(self, _arg:str) -> None: ...
    def SetIntAttribute(self, name:str, value:int) -> None: ...
    def SetName(self, _arg:str) -> None: ...
    def SetParent(self, parent:'vtkXMLDataElement') -> None: ...
    def SetUnsignedLongAttribute(self, name:str, value:int) -> None: ...
    @overload
    def SetVectorAttribute(self, name:str, length:int, value:Sequence[int]) -> None: ...
    @overload
    def SetVectorAttribute(self, name:str, length:int, value:Sequence[float]) -> None: ...
    def SetXMLByteIndex(self, _arg:int) -> None: ...

