//  main.cpp
//  forautocompl
//
//  Created by Martin Steinegger on 26.11.12.
//  Copyright (c) 2012 -. All rights reserved.
//
#include <iostream>
#include <string.h>
#include <cmath>
#include <PSSMCalculator.h>
#include "Sequence.h"
#include "Indexer.h"
#include "ExtendedSubstitutionMatrix.h"
#include "SubstitutionMatrix.h"
#include "ReducedMatrix.h"
#include "KmerGenerator.h"
#include "BaseMatrix.h"
#include "StripedSmithWaterman.h"
#include "Parameters.h"

const char* binary_name = "test_profilealignment";

int main (int argc, const char * argv[])
{

    const size_t kmer_size=6;

    Parameters& par = Parameters::getInstance();
    SubstitutionMatrix subMat(par.scoringMatrixFile.c_str(), 2.0, 0);
    std::cout << "Subustitution matrix:";
    SubstitutionMatrix::print(subMat.subMatrix,subMat.int2aa,subMat.alphabetSize);
    //   BaseMatrix::print(subMat.subMatrix, subMat.alphabetSize);
    std::cout << "";

    std::cout << "subMatrix:";
    //    ReducedMatrix subMat(subMat.probMatrix, 20);
    //   BaseMatrix::print(subMat.subMatrix, subMat.alphabetSize);
    std::cout << "";
    //static const char ref_seq[40] = {'C', 'A', 'G', 'C', 'C', 'T', 'T', 'T', 'C', 'T', 'G', 'A', 'C', 'C', 'C', 'G', 'G', 'A', 'A', 'A', 'T',
    //						'C', 'A', 'A', 'A', 'A', 'T', 'A', 'G', 'G', 'C', 'A', 'C', 'A', 'A', 'C', 'A', 'A', 'A', '\0'};
    //static const char read_seq[16] = {'C', 'T', 'G', 'A', 'G', 'C', 'C', 'G', 'G', 'T', 'A', 'A', 'A', 'T', 'C', '\0'};	// read sequence
    std::string profile = "\x7f\x7b\x80\x85\x7a\x7d\x7e\x82\x7f\x81\x7c\x7f"
            "\x80\x7e\x7f\x80\x7f\x7c\x79\x7c\x7a\x78\x83\x7f"
            "\x76\x7b\x7a\x76\x7b\x77\x77\x84\x80\x7f\x80\x84"
            "\x84\x76\x76\x77\x7c\x79\x73\x74\x82\x75\x76\x7f"
            "\x7a\x86\x80\x74\x7c\x76\x7c\x77\x79\x80\x7b\x7f"
            "\x80\x76\x83\x83\x78\x7e\x7f\x7c\x81\x7c\x7c\x81"
            "\x81\x82\x7f\x82\x7f\x7c\x7a\x7e\x80\x74\x83\x85"
            "\x7a\x7b\x7f\x7b\x7d\x7b\x7e\x7f\x7c\x84\x80\x7f"
            "\x80\x78\x77\x77\x84\x83\x7c\x7a\x7c\x77\x76\x81"
            "\x74\x83\x80\x75\x7b\x7b\x75\x7e\x7c\x81\x81\x80"
            "\x7d\x7e\x7a\x7e\x7e\x79\x76\x84\x7d\x82\x7f\x74"
            "\x7b\x7e\x7d\x76\x7e\x83\x80\x81\x80\x76\x82\x83"
            "\x7a\x7c\x80\x7d\x81\x7d\x7d\x81\x7d\x84\x82\x80"
            "\x7f\x7a\x77\x7d\x80\x78\x7b\x81\x7d\x79\x80\x80"
            "\x81\x82\x81\x7e\x74\x84\x81\x7f\x81\x7f\x7f\x81"
            "\x86\x80\x79\x7c\x7d\x80\x77\x7e\x7b\x7f\x81\x7a"
            "\x74\x76\x75\x7f\x80\x80\x7e\x79\x7f\x7e\x7c\x7f"
            "\x7f\x76\x7c\x82\x7e\x84\x81\x7c\x7c\x7f\x80\x7b"
            "\x7d\x7f\x82\x80\x82\x78\x80\x83\x7a\x7d\x7d\x7d"
            "\x83\x7e\x79\x81\x76\x83\x81\x81\x7f\x7d\x75\x77"
            "\x80\x77\x80\x80\x7a\x7d\x83\x76\x81\x7b\x7c\x85"
            "\x77\x82\x81\x80\x7f\x7c\x7d\x80\x7b\x7b\x81\x7b"
            "\x7d\x79\x84\x7a\x7a\x7c\x79\x86\x77\x80\x81\x83"
            "\x7e\x76\x79\x80\x7d\x77\x7d\x7f\x7e\x7c\x80\x7b"
            "\x80\x80\x77\x7f\x87\x7f\x7d\x7f\x7d\x7d\x77\x7f"
            "\x81\x76\x83\x84\x7b\x7e\x7c\x7c\x80\x7e\x7c\x80"
            "\x7b\x82\x80\x81\x81\x7d\x7f\x7d\x7e\x78\x77\x7b"
            "\x80\x76\x78\x83\x76\x84\x82\x7c\x75\x7c\x7a\x78"
            "\x7d\x82\x7d\x81\x81\x77\x7b\x81\x76\x79\x7b\x7f"
            "\x84\x80\x7d\x7f\x7a\x85\x82\x7d\x7d\x7e\x79\x7c"
            "\x83\x73\x7e\x81\x75\x7d\x78\x81\x81\x7e\x80\x7e"
            "\x74\x84\x80\x82\x7e\x80\x7f\x7e\x85\x74\x7d\x7e"
            "\x7e\x79\x7d\x7e\x7f\x80\x7e\x7d\x7a\x83\x79\x82"
            "\x7f\x7e\x77\x80\x7f\x74\x7e\x82\x79\x7d\x7e\x7b"
            "\x83\x7d\x7f\x7f\x73\x84\x83\x80\x7f\x7e\x80\x80"
            "\x84\x72\x7d\x80\x7e\x7b\x80\x7f\x80\x81\x7c\x80"
            "\x74\x82\x7d\x80\x7f\x7e\x75\x82\x80\x71\x83\x82"
            "\x74\x7e\x7c\x7c\x82\x7d\x7c\x82\x74\x84\x83\x80"
            "\x7e\x78\x7d\x7c\x7f\x75\x74\x81\x7e\x78\x7f\x82"
            "\x7f\x83\x7f\x7b\x7a\x81\x80\x7c\x7f\x82\x7e\x81"
            "\x81\x7c\x82\x84\x74\x7d\x7f\x7b\x81\x7f\x7c\x80"
            "\x75\x83\x81\x7f\x7f\x7d\x73\x7f\x83\x73\x7d\x81"
            "\x75\x7d\x78\x81\x81\x7e\x7f\x7e\x74\x84\x7f\x82"
            "\x7d\x7e\x75\x7b\x85\x74\x7c\x7f\x7c\x7b\x7c\x7d"
            "\x7f\x80\x7e\x7e\x73\x81\x7d\x83\x7f\x7b\x77\x7e"
            "\x7f\x74\x7f\x84\x7b\x7d\x80\x7b\x83\x7f\x7e\x7f"
            "\x73\x85\x82\x7f\x7e\x7b\x76\x7d\x84\x72\x7b\x80"
            "\x7d\x7e\x7f\x7c\x7f\x80\x7f\x7f\x74\x82\x7f\x82"
            "\x7f\x7d\x7f\x83\x80\x71\x83\x83\x74\x7d\x7c\x7e"
            "\x7f\x7f\x7e\x82\x74\x84\x81\x80\x7e\x7d\x74\x7b"
            "\x81\x75\x74\x7e\x7e\x73\x80\x81\x7f\x83\x7e\x7b"
            "\x7c\x7f\x81\x7e\x7e\x82\x79\x82\x80\x72\x82\x82"
            "\x7b\x7f\x7e\x7d\x83\x7e\x7c\x80\x7a\x83\x82\x80"
            "\x7f\x7d\x73\x76\x82\x73\x7e\x81\x7a\x7d\x78\x81"
            "\x7f\x7f\x7f\x80\x74\x84\x80\x82\x80\x7f\x75\x7e"
            "\x85\x74\x7c\x7e\x7d\x7d\x7e\x7e\x7e\x7e\x7b\x7e"
            "\x7b\x80\x7e\x82\x80\x80\x80\x7e\x7e\x76\x7e\x80"
            "\x7f\x80\x7f\x7b\x84\x7f\x7c\x80\x7e\x82\x82\x81"
            "\x80\x7b\x7f\x7c\x83\x79\x80\x7d\x7c\x82\x7d\x7d"
            "\x80\x7e\x7b\x80\x7f\x81\x7f\x83\x7e\x7d\x80\x7e"
            "\x81\x76\x82\x81\x7c\x81\x7f\x79\x80\x7f\x79\x81"
            "\x80\x83\x80\x81\x7f\x7c\x83\x7f\x7e\x79\x7e\x7e"
            "\x83\x7d\x80\x7c\x7e\x81\x7e\x80\x82\x7f\x81\x7e"
            "\x7f\x7e\x84\x84\x7e\x78\x81\x7b\x80\x7d\x7b\x7e"
            "\x80\x84\x81\x81\x7c\x7e\x7f\x7c\x7e\x7d\x82\x84"
            "\x79\x75\x7c\x76\x7b\x7e\x76\x79\x75\x7d\x7b\x76"
            "\x89\x77\x77\x7b\x7b\x7b\x80\x7b\x7e\x78\x80\x82"
            "\x7a\x7e\x80\x7c\x81\x7c\x7f\x80\x7e\x83\x81\x83"
            "\x83\x7f\x7c\x7d\x7f\x78\x73\x75\x82\x7b\x77\x83"
            "\x74\x83\x80\x74\x7d\x7b\x77\x7b\x7c\x84\x79\x7c"
            "\x80\x71\x83\x80\x7d\x81\x7a\x7a\x7e\x78\x7d\x83"
            "\x76\x7f\x7f\x84\x83\x7d\x79\x7f\x83\x74\x73\x73"
            "\x82\x7f\x7c\x81\x74\x83\x80\x75\x77\x75\x7a\x7b"
            "\x7d\x81\x7f\x7f\x80\x6f\x81\x80\x7f\x81\x7c\x7c"
            "\x7d\x7d\x7f\x82\x74\x82\x7f\x84\x82\x7f\x78\x80"
            "\x83\x74\x7a\x79\x80\x83\x7b\x7f\x7b\x80\x7f\x7a"
            "\x7a\x7c\x79\x81\x7f\x81\x7b\x83\x81\x71\x81\x81"
            "\x7f\x82\x79\x7b\x7c\x7c\x7f\x82\x7c\x83\x81\x83"
            "\x81\x7c\x77\x7c\x80\x75\x7b\x7b\x81\x7f\x80\x7e"
            "\x7c\x7f\x7d\x7f\x7d\x7f\x7f\x7e\x7f\x7f\x80\x87"
            "\x80\x71\x7f\x7e\x7e\x82\x7d\x7c\x7e\x7e\x7d\x82"
            "\x7e\x81\x7f\x83\x83\x7f\x7d\x80\x80\x73\x7f\x7f"
            "\x80\x7e\x81\x7e\x7f\x7f\x7c\x82\x81\x80\x82\x80"
            "\x81\x7e\x82\x84\x80\x71\x80\x7f\x7e\x80\x7f\x7e"
            "\x7d\x7f\x7d\x82\x7c\x83\x7f\x83\x82\x7f\x7f\x80"
            "\x80\x71\x82\x80\x7f\x81\x80\x7d\x7f\x7c\x76\x82"
            "\x80\x81\x82\x81\x81\x7e\x7f\x81\x80\x71\x81\x80"
            "\x80\x82\x7f\x7a\x80\x7b\x7c\x82\x81\x82\x7e\x82"
            "\x82\x7d\x76\x80\x80\x71\x82\x7d\x80\x81\x7e\x7c"
            "\x79\x7e\x7e\x82\x82\x82\x7e\x82\x81\x7f\x76\x81"
            "\x7f\x71\x81\x7f\x7f\x80\x7f\x7f\x7e\x7e\x76\x82"
            "\x81\x82\x81\x82\x82\x7e\x76\x80\x7f\x71\x82\x80"
            "\x7d\x80\x7c\x7f\x7f\x7d\x7e\x82\x82\x80\x7e\x82"
            "\x82\x7e\x7e\x81\x82\x71\x80\x7e\x7f\x80\x7c\x80"
            "\x7e\x7f\x7c\x82\x80\x80\x7c\x82\x82\x7e\x76\x81"
            "\x7f\x71\x81\x7f\x81\x80\x7e\x7a\x7f\x7f\x7e\x82"
            "\x81\x81\x7f\x83\x82\x7f\x7d\x80\x80\x71\x81\x80"
            "\x80\x82\x74\x78\x7e\x7c\x7d\x82\x81\x82\x7f\x82"
            "\x82\x7e\x76\x7f\x80\x71\x80\x7f\x7f\x81\x7b\x7f"
            "\x7e\x7f\x7e\x81\x81\x82\x7a\x82\x82\x80\x76\x7f"
            "\x80\x71\x81\x80\x7d\x80\x80\x7d\x80\x7c\x76\x82"
            "\x81\x80\x81\x82\x82\x7d\x7e\x80\x80\x71\x80\x7f"
            "\x7f\x80\x7e\x7e\x7f\x7c\x7c\x82\x81\x83\x81\x82"
            "\x81\x7e\x7d\x80\x7f\x71\x82\x80\x80\x80\x7f\x7b"
            "\x7e\x7c\x7e\x83\x81\x80\x7e\x82\x82\x7d\x80\x80"
            "\x81\x72\x81\x80\x7c\x80\x7d\x7b\x7e\x7d\x80\x82"
            "\x7e\x82\x7f\x82\x82\x7f\x7f\x83\x7f\x71\x7d\x7d"
            "\x81\x80\x81\x7e\x7b\x7d\x7f\x81\x7f\x81\x7d\x82"
            "\x83\x80\x84\x83\x7f\x72\x7f\x80\x7e\x80\x7f\x7d"
            "\x7e\x7e\x80\x82\x79\x83\x7f\x83\x81\x7f\x7d\x81"
            "\x83\x71\x7a\x72\x80\x82\x74\x80\x72\x82\x7d\x7f"
            "\x7d\x7b\x79\x7d\x80\x82\x79\x82\x80\x6f\x7e\x80"
            "\x7c\x84\x78\x7c\x7f\x7c\x7e\x82\x7a\x80\x80\x82"
            "\x82\x7b\x7e\x80\x81\x71\x73\x7a\x83\x7f\x74\x82"
            "\x72\x83\x80\x75\x7d\x7b\x72\x78\x7e\x83\x7e\x7a"
            "\x80\x7c\x7f\x7f\x7d\x82\x7e\x7c\x7e\x79\x7e\x83"
            "\x7f\x82\x80\x83\x83\x7e\x7a\x7e\x82\x74\x73\x79"
            "\x81\x7f\x75\x81\x73\x83\x80\x7a\x7c\x7b\x73\x7d"
            "\x7f\x83\x7b\x81\x7f\x72\x7e\x7f\x7d\x80\x79\x7d"
            "\x80\x79\x7e\x83\x7b\x80\x80\x84\x84\x7e\x77\x7e"
            "\x7e\x77\x7d\x7c\x7f\x7e\x7a\x80\x7e\x7f\x81\x80"
            "\x79\x86\x7b\x80\x7f\x80\x85\x82\x80\x71\x81\x7f"
            "\x77\x7f\x74\x7b\x7d\x7f\x7d\x82\x86\x7f\x7d\x81"
            "\x82\x7d\x76\x7c\x7e\x79\x7a\x77\x81\x7d\x79\x84"
            "\x7b\x84\x7e\x7c\x7e\x7d\x7c\x7f\x7b\x81\x7d\x7d"
            "\x79\x78\x7d\x7d\x86\x7d\x7f\x80\x74\x7f\x80\x7a"
            "\x7f\x7d\x7b\x7d\x7e\x7e\x85\x85\x7f\x7a\x84\x81"
            "\x7b\x7f\x7d\x79\x7e\x7c\x7c\x83\x7f\x82\x80\x82"
            "\x82\x7c\x7e\x7e\x7e\x79\x7e\x7d\x83\x84\x7c\x7c"
            "\x7f\x80\x80\x81\x82\x7f\x7e\x7f\x7f\x7e\x83\x7d"
            "\x80\x73\x81\x7e\x80\x84\x7c\x7a\x7e\x7f\x7e\x80"
            "\x80\x80\x7d\x81\x80\x7d\x7d\x7e\x81\x76\x7f\x7f"
            "\x7e\x80\x79\x7f\x83\x80\x7e\x80\x7d\x82\x82\x80"
            "\x80\x7e\x79\x7f\x7e\x78\x7f\x7f\x81\x7f\x7f\x80"
            "\x80\x7f\x80\x80\x7c\x7e\x82\x7f\x81\x7f\x86\x82"
            "\x82\x72\x7f\x7e\x7d\x81\x7f\x7f\x81\x7d\x7f\x82"
            "\x7e\x81\x82\x82\x80\x7c\x7e\x80\x83\x71\x80\x7f"
            "\x7c\x80\x7c\x7c\x7f\x7d\x7e\x83\x7c\x83\x7f\x82"
            "\x82\x7e\x76\x7f\x82\x75\x7d\x7f\x7c\x7f\x7c\x81"
            "\x82\x81\x7e\x80\x7e\x82\x81\x7e\x80\x7f\x78\x81"
            "\x80\x75\x80\x81\x7a\x7d\x7d\x7e\x83\x7e\x7d\x81"
            "\x7c\x82\x82\x7f\x81\x80\x78\x80\x83\x72\x80\x80"
            "\x7d\x7c\x7f\x7f\x81\x81\x7f\x7f\x75\x83\x81\x81"
            "\x7e\x7e\x75\x7d\x84\x74\x7d\x80\x77\x7c\x77\x7d"
            "\x80\x7f\x7f\x81\x7c\x83\x7f\x82\x7f\x7d\x77\x7d"
            "\x81\x74\x7f\x82\x74\x7c\x79\x7e\x83\x7e\x7c\x80"
            "\x73\x84\x82\x80\x7f\x7d\x7e\x7b\x83\x72\x7e\x81"
            "\x7d\x7c\x81\x80\x82\x80\x7e\x81\x74\x82\x7f\x80"
            "\x7f\x7e\x75\x7d\x83\x71\x80\x82\x7b\x7e\x78\x7e"
            "\x81\x7f\x7f\x81\x74\x83\x80\x80\x80\x7d\x74\x81"
            "\x84\x72\x7d\x81\x7b\x7c\x7f\x7f\x81\x80\x7f\x7f"
            "\x75\x81\x80\x80\x7f\x80\x75\x80\x81\x71\x81\x83"
            "\x79\x7e\x7e\x7d\x82\x80\x78\x81\x74\x84\x81\x80"
            "\x7e\x7c\x74\x7d\x82\x73\x7d\x81\x7c\x7d\x7e\x81"
            "\x7f\x80\x81\x81\x7a\x83\x80\x80\x7f\x7f\x80\x81"
            "\x84\x74\x7c\x80\x7c\x7d\x7e\x7d\x7f\x7f\x7d\x7e"
            "\x73\x84\x7f\x82\x80\x7d\x77\x7d\x80\x74\x7f\x83"
            "\x74\x7e\x7f\x7f\x82\x7d\x7e\x80\x7c\x83\x82\x81"
            "\x7e\x7d\x80\x7e\x83\x72\x7e\x82\x7f\x7b\x80\x7f"
            "\x7e\x81\x7e\x7f\x74\x82\x7e\x80\x80\x7d\x80\x81"
            "\x81\x71\x82\x82\x74\x7d\x78\x7b\x81\x7f\x7f\x82"
            "\x74\x83\x82\x80\x81\x7d\x74\x7b\x80\x75\x7c\x7f"
            "\x81\x7b\x7e\x7f\x7e\x83\x7d\x7d\x72\x80\x80\x7e"
            "\x80\x80\x81\x84\x80\x71\x81\x83\x7c\x7a\x80\x7b"
            "\x81\x7e\x7e\x81\x74\x84\x83\x80\x7f\x7d\x74\x7d"
            "\x81\x73\x81\x82\x7d\x7e\x7e\x7f\x81\x7f\x80\x80"
            "\x74\x84\x80\x81\x7f\x7e\x75\x80\x83\x74\x7e\x81"
            "\x7c\x7b\x7c\x7f\x80\x80\x7d\x80\x73\x80\x7f\x81"
            "\x82\x81\x77\x7f\x7f\x74\x7c\x82\x7b\x79\x7e\x7e"
            "\x83\x7f\x80\x80\x73\x84\x83\x7f\x80\x7f\x76\x7e"
            "\x80\x7b\x80\x81\x7c\x7b\x7a\x7f\x80\x81\x7e\x82"
            "\x75\x85\x82\x80\x7f\x7d\x7d\x7d\x80\x74\x83\x84"
            "\x7a\x7e\x7e\x7c\x80\x7e\x7e\x82\x77\x84\x80\x80"
            "\x80\x7c\x7b\x7d\x7e\x77\x75\x7a\x7f\x74\x79\x83"
            "\x7f\x84\x7e\x7a\x74\x7f\x7b\x7b\x81\x83\x7e\x80"
            "\x82\x73\x7f\x81\x7b\x7d\x7d\x82\x80\x80\x7f\x7f"
            "\x7a\x82\x80\x80\x80\x81\x75\x81\x81\x75\x7d\x81"
            "\x80\x7d\x7d\x7f\x80\x81\x7c\x81\x75\x83\x80\x80"
            "\x81\x7f\x80\x82\x80\x78\x83\x84\x79\x7e\x7c\x7a"
            "\x81\x7d\x7a\x83\x78\x84\x81\x80\x7f\x7a\x7b\x7c"
            "\x81\x7c\x7b\x74\x80\x7b\x76\x83\x72\x81\x7f\x7a"
            "\x74\x76\x75\x7b\x82\x84\x7d\x7e\x82\x7a\x7e\x7f"
            "\x7c\x7a\x7f\x80\x81\x7f\x81\x7f\x78\x82\x81\x81"
            "\x82\x80\x7b\x80\x7e\x76\x80\x82\x76\x7d\x7e\x7e"
            "\x83\x7e\x7f\x81\x78\x84\x81\x82\x81\x7c\x7e\x7c"
            "\x85\x7c\x7e\x7c\x7c\x7c\x7d\x7e\x7d\x80\x7d\x80"
            "\x76\x80\x7f\x81\x80\x80\x7e\x7d\x7e\x7c\x75\x7a"
            "\x83\x75\x7e\x7b\x7c\x80\x7f\x77\x74\x7e\x7d\x7a"
            "\x78\x7d\x85\x88\x7e\x79\x7e\x7f\x82\x7c\x7e\x80"
            "\x7f\x81\x7d\x80\x77\x81\x80\x80\x80\x7e\x84\x85"
            "\x80\x7a\x83\x83\x7a\x7f\x7e\x79\x7f\x7c\x7e\x84"
            "\x76\x83\x80\x80\x81\x79\x7f\x7e\x81\x7c\x79\x7b"
            "\x7f\x7b\x7d\x82\x7d\x83\x81\x7a\x76\x7c\x7b\x7e"
            "\x7f\x82\x82\x84\x80\x7c\x7d\x80\x7f\x75\x80\x80"
            "\x7d\x83\x80\x7f\x74\x83\x81\x7e\x7f\x80\x82\x82"
            "\x81\x7b\x7d\x81\x7f\x7e\x7f\x7e\x81\x81\x7f\x7f"
            "\x74\x83\x82\x81\x80\x7e\x76\x82\x85\x7d\x7d\x7d"
            "\x77\x7c\x7e\x7d\x7e\x81\x7d\x7f\x73\x81\x7f\x82"
            "\x7f\x7d\x77\x81\x7d\x7c\x80\x82\x7a\x7c\x7d\x7f"
            "\x83\x7e\x80\x80\x73\x85\x83\x7f\x7e\x7c\x7f\x80"
            "\x83\x7b\x80\x83\x7a\x7c\x7e\x7b\x82\x7d\x79\x80"
            "\x74\x84\x7f\x80\x80\x7c\x75\x7d\x80\x7d\x80\x82"
            "\x7d\x7a\x7c\x7f\x81\x80\x81\x81\x75\x84\x82\x80"
            "\x7e\x7e\x77\x78\x80\x75\x79\x7c\x7d\x79\x7f\x82"
            "\x7f\x84\x7f\x7c\x72\x81\x7f\x78\x7c\x81\x7d\x81"
            "\x81\x72\x81\x83\x7a\x7d\x7d\x7c\x83\x7a\x7e\x81"
            "\x7c\x83\x82\x80\x7f\x7f\x73\x7c\x82\x73\x7e\x7f"
            "\x7e\x7b\x78\x82\x7e\x82\x80\x80\x74\x82\x7e\x7e"
            "\x80\x82\x7e\x80\x84\x74\x7e\x7d\x7c\x7c\x77\x7f"
            "\x7c\x82\x7f\x7e\x73\x83\x7f\x80\x81\x7d\x7d\x82"
            "\x7f\x74\x80\x84\x74\x7a\x80\x7a\x82\x7e\x7c\x80"
            "\x73\x85\x83\x7f\x7f\x7c\x76\x7b\x83\x72\x81\x83"
            "\x7a\x7d\x7d\x7d\x82\x7e\x79\x80\x74\x83\x81\x81"
            "\x7f\x79\x75\x7d\x81\x7a\x7e\x81\x7c\x7a\x7f\x80"
            "\x7f\x7f\x7f\x83\x74\x83\x80\x82\x81\x7e\x7c\x80"
            "\x7f\x75\x79\x81\x7f\x79\x7e\x82\x80\x83\x80\x7b"
            "\x72\x81\x7f\x7e\x7e\x81\x79\x82\x82\x73\x83\x83"
            "\x74\x7c\x7c\x7a\x82\x7d\x7d\x81\x75\x83\x82\x80"
            "\x7f\x7c\x73\x75\x82\x73\x7e\x81\x7f\x7c\x7e\x7e"
            "\x7d\x81\x7d\x82\x74\x82\x81\x81\x7f\x7f\x7c\x80"
            "\x84\x7c\x7b\x7b\x7e\x7a\x7f\x80\x79\x82\x80\x80"
            "\x73\x80\x7d\x82\x81\x7e\x77\x81\x7f\x74\x81\x83"
            "\x7c\x7d\x7f\x7b\x83\x7e\x7c\x81\x73\x84\x82\x7f"
            "\x7f\x7d\x76\x7d\x82\x72\x80\x83\x7b\x7d\x7d\x7c"
            "\x83\x7e\x79\x80\x74\x82\x81\x81\x81\x7d\x75\x7c"
            "\x80\x7a\x76\x7f\x7f\x7a\x81\x80\x7f\x82\x80\x82"
            "\x74\x84\x80\x7f\x80\x7e\x80\x80\x7f\x75\x7a\x7f"
            "\x7f\x79\x7e\x80\x7d\x84\x7e\x7c\x72\x7f\x81\x7b"
            "\x7d\x81\x7e\x84\x81\x73\x82\x83\x74\x7d\x80\x7d"
            "\x82\x7b\x78\x82\x75\x83\x82\x81\x7f\x7c\x73\x7b"
            "\x81\x73\x80\x80\x7a\x7b\x7f\x81\x80\x81\x82\x80"
            "\x74\x83\x81\x81\x80\x7f\x75\x7f\x84\x74\x7a\x7c"
            "\x7b\x7b\x7c\x81\x7d\x80\x81\x7f\x73\x7f\x7c\x81"
            "\x83\x81\x77\x80\x7f\x74\x7f\x84\x7a\x79\x7d\x78"
            "\x83\x7e\x7e\x7f\x73\x85\x82\x7f\x80\x7d\x7c\x7b"
            "\x83\x74\x7f\x81\x7a\x7e\x7d\x7e\x82\x7f\x7f\x80"
            "\x76\x82\x81\x81\x80\x7e\x77\x7c\x81\x7a\x7f\x7f"
            "\x7e\x7f\x7e\x7a\x82\x81\x80\x80\x7a\x82\x84\x80"
            "\x7c\x78\x7b\x7f\x7f\x79\x7a\x7e\x83\x7a\x7f\x80"
            "\x7e\x81\x7c\x7c\x7b\x80\x7f\x7b\x7b\x82\x7e\x86"
            "\x80\x75\x82\x84\x74\x7d\x7a\x7a\x83\x7b\x7d\x82"
            "\x77\x83\x82\x80\x7d\x7c\x75\x77\x83\x75\x7e\x80"
            "\x75\x7c\x7f\x7f\x7f\x80\x7f\x82\x77\x83\x7f\x81"
            "\x80\x80\x76\x7f\x7c\x76\x7f\x7e\x76\x87\x7d\x75"
            "\x7e\x77\x7c\x7e\x7a\x80\x7f\x7c\x7b\x75\x76\x78"
            "\x7f\x76\x80\x82\x7c\x7d\x7e\x80\x81\x82\x81\x80"
            "\x7a\x81\x81\x80\x7f\x80\x7a\x7f\x82\x7b\x7c\x79"
            "\x7f\x7f\x78\x83\x7f\x81\x7f\x7a\x7d\x7e\x7f\x81"
            "\x81\x82\x7b\x7d\x81\x77\x82\x7e\x7a\x7e\x7d\x7d"
            "\x7e\x7d\x7c\x81\x83\x7f\x7f\x83\x83\x79\x7d\x78"
            "\x80\x77\x7f\x82\x7e\x7e\x7e\x7f\x82\x80\x7d\x81"
            "\x82\x82\x81\x80\x7f\x7d\x7b\x7f\x82\x75\x80\x80"
            "\x80\x7c\x7d\x80\x7f\x81\x77\x81\x7e\x80\x7e\x82"
            "\x82\x80\x7d\x80\x7f\x74\x87\x84\x74\x79\x7d\x7b"
            "\x7b\x79\x79\x7e\x76\x82\x7c\x7d\x7d\x75\x76\x7b"
            "\x7f\x78\x75\x7b\x7f\x79\x79\x81\x7d\x83\x80\x7b"
            "\x7b\x7e\x7f\x7c\x7c\x84\x7e\x83\x80\x79\x7f\x80"
            "\x7f\x76\x7d\x80\x7e\x83\x82\x80\x7a\x81\x80\x7f"
            "\x80\x7f\x7b\x81\x80\x73\x81\x82\x7a\x79\x7c\x7d"
            "\x81\x7f\x7d\x81\x74\x85\x83\x81\x80\x7d\x7d\x7d"
            "\x85\x74\x77\x7b\x7f\x7b\x77\x7f\x7d\x81\x80\x7c"
            "\x7b\x7f\x79\x81\x80\x80\x7d\x7e\x7d\x74\x80\x84"
            "\x7a\x76\x7d\x7b\x83\x7e\x79\x80\x73\x85\x82\x7f"
            "\x7e\x7c\x76\x7c\x84\x72\x7b\x7e\x76\x7e\x78\x7f"
            "\x7e\x80\x80\x80\x74\x82\x7d\x81\x82\x81\x75\x7e"
            "\x82\x71\x81\x83\x74\x7a\x7d\x7c\x81\x7e\x7c\x81"
            "\x7b\x83\x82\x81\x7f\x7c\x74\x80\x7e\x75\x7a\x7d"
            "\x7f\x7b\x7d\x80\x7f\x84\x7f\x79\x72\x81\x7e\x7b"
            "\x7e\x80\x82\x84\x83\x73\x80\x82\x7a\x7c\x7f\x7e"
            "\x80\x80\x80\x80\x75\x82\x80\x81\x80\x7f\x73\x7f"
            "\x81\x73\x80\x82\x7a\x7d\x7c\x7d\x80\x7e\x80\x83"
            "\x74\x85\x80\x81\x81\x7c\x7d\x77\x85\x74\x7e\x7c"
            "\x7e\x79\x7c\x7f\x7d\x80\x7f\x7e\x73\x80\x7e\x82"
            "\x80\x7f\x77\x7f\x7d\x74\x80\x84\x7a\x76\x79\x7f"
            "\x83\x7e\x7e\x7f\x73\x85\x83\x7f\x7f\x7c\x76\x7b"
            "\x84\x72\x7e\x7f\x7a\x7d\x7c\x7f\x7f\x80\x79\x81"
            "\x7d\x82\x7f\x83\x80\x7d\x75\x80\x82\x71\x82\x83"
            "\x7a\x7e\x7c\x7b\x80\x7e\x7c\x82\x74\x85\x81\x80"
            "\x7e\x7d\x74\x7b\x7e\x75\x79\x7f\x7e\x78\x7c\x81"
            "\x7f\x84\x7d\x7e\x72\x81\x81\x7f\x7f\x81\x7d\x82"
            "\x82\x73\x7e\x82\x79\x7a\x7d\x82\x7f\x81\x7e\x80"
            "\x7c\x81\x80\x80\x80\x80\x73\x7b\x81\x73\x81\x82"
            "\x7b\x7b\x7c\x7d\x81\x7d\x7f\x82\x7a\x85\x81\x81"
            "\x81\x7d\x75\x77\x85\x74\x77\x7d\x77\x76\x77\x80"
            "\x7c\x81\x7f\x7e\x73\x81\x7c\x81\x80\x7f\x7e\x80"
            "\x7f\x74\x7e\x83\x7a\x79\x7f\x7d\x83\x7e\x7c\x7f"
            "\x7a\x85\x83\x7e\x7f\x7a\x7f\x7d\x83\x72\x7d\x7f"
            "\x7d\x7f\x7c\x7f\x7f\x7f\x7d\x82\x74\x82\x80\x81"
            "\x81\x7e\x75\x83\x80\x71\x83\x83\x7a\x7d\x7e\x7a"
            "\x80\x7d\x80\x83\x74\x84\x80\x81\x7e\x7b\x74\x76"
            "\x7f\x7e\x74\x80\x7f\x73\x7d\x81\x7f\x84\x7f\x7f"
            "\x72\x80\x80\x7c\x7d\x80\x7c\x83\x81\x7b\x81\x83"
            "\x7b\x7b\x7f\x7f\x82\x7f\x7e\x82\x75\x84\x80\x7f"
            "\x80\x7c\x73\x7f\x80\x73\x81\x81\x7b\x7a\x7d\x81"
            "\x80\x80\x7f\x82\x74\x83\x80\x81\x81\x80\x75\x7e"
            "\x85\x7b\x7d\x7e\x7c\x7b\x7e\x7e\x7e\x80\x7b\x81"
            "\x73\x81\x7e\x81\x7f\x7f\x7d\x7f\x7e\x74\x7b\x82"
            "\x7e\x79\x7c\x7e\x83\x81\x80\x80\x73\x83\x83\x7e"
            "\x7f\x7e\x76\x82\x83\x72\x7f\x80\x7d\x7c\x7f\x7f"
            "\x7f\x81\x81\x81\x7a\x80\x80\x80\x80\x7e\x75\x81"
            "\x81\x78\x81\x82\x7d\x7b\x7f\x7d\x82\x7d\x7d\x82"
            "\x75\x84\x82\x80\x80\x7b\x7c\x7f\x7e\x79\x73\x73"
            "\x81\x75\x76\x81\x79\x85\x80\x74\x74\x7b\x7a\x7a"
            "\x79\x7f\x80\x80\x81\x7e\x7f\x82\x7d\x7d\x7e\x7d"
            "\x82\x80\x80\x82\x7b\x82\x81\x81\x7e\x7d\x7d\x7d"
            "\x80\x76\x7f\x81\x7e\x7d\x7f\x7e\x81\x7f\x80\x82"
            "\x79\x82\x81\x81\x81\x80\x7e\x81\x81\x78\x7d\x7e"
            "\x80\x78\x7c\x81\x7e\x84\x7f\x7c\x7a\x80\x7d\x7d"
            "\x7e\x80\x80\x81\x7e\x7c\x73\x7b\x81\x7a\x78\x81"
            "\x7c\x83\x85\x7a\x7d\x7b\x7d\x7e\x84\x80\x7f\x7c"
            "\x7d\x77\x81\x7e\x7a\x86\x7f\x74\x7e\x79\x77\x83"
            "\x7d\x81\x7d\x7f\x7c\x7b\x77\x7c\x7e\x7d\x7c\x81"
            "\x7d\x7d\x7e\x81\x80\x82\x81\x80\x7c\x81\x82\x80"
            "\x80\x81\x7c\x80\x7f\x75\x83\x81\x7b\x7e\x7f\x7b"
            "\x81\x7f\x80\x81\x84\x81\x7e\x82\x7f\x7e\x78\x7f"
            "\x7f\x7c\x80\x80\x7e\x7f\x7d\x81\x80\x7f\x80\x81"
            "\x85\x7d\x7f\x80\x7f\x7f\x7f\x82\x7f\x77\x83\x82"
            "\x7e\x7f\x7c\x7e\x7d\x7e\x7e\x81\x83\x80\x7d\x82"
            "\x82\x7e\x7e\x7e\x80\x7d\x82\x82\x7e\x7f\x7d\x7f"
            "\x7d\x7c\x7e\x80\x82\x82\x7f\x82\x82\x7e\x7a\x7d"
            "\x80\x7d\x81\x81\x80\x7d\x77\x81\x80\x80\x7f\x82"
            "\x81\x80\x7c\x81\x7f\x81\x7a\x7e\x81\x7d\x80\x82"
            "\x7f\x7f\x78\x80\x7e\x7f\x7d\x82\x80\x80\x7f\x82"
            "\x82\x81\x7e\x7e\x80\x7c\x82\x82\x7b\x7f\x80\x7f"
            "\x80\x7f\x7d\x81\x7f\x81\x80\x81\x81\x81\x77\x7e"
            "\x7e\x7d\x7d\x7e\x81\x7b\x79\x82\x7d\x83\x80\x7c"
            "\x81\x7d\x7e\x81\x80\x81\x7f\x80\x81\x72\x83\x81"
            "\x7d\x7f\x7e\x7c\x81\x7d\x77\x82\x82\x81\x7d\x82"
            "\x81\x7f\x76\x7e\x7f\x77\x80\x7c\x80\x80\x78\x81"
            "\x7f\x80\x7d\x80\x83\x7f\x7b\x82\x81\x81\x7c\x7e"
            "\x80\x74\x82\x82\x7c\x80\x76\x7f\x80\x7e\x77\x80"
            "\x81\x81\x7f\x81\x82\x7d\x7f\x7e\x81\x72\x82\x81"
            "\x7f\x7f\x7f\x7b\x7e\x7f\x7f\x80\x83\x80\x7f\x81"
            "\x82\x7e\x77\x7a\x7d\x79\x80\x7f\x84\x7e\x7d\x81"
            "\x7d\x81\x7d\x80\x80\x7f\x7d\x7e\x80\x7f\x82\x83"
            "\x81\x72\x80\x80\x7f\x7f\x7e\x7f\x80\x7f\x77\x80"
            "\x82\x82\x7f\x82\x82\x7f\x7e\x80\x81\x75\x81\x7f"
            "\x80\x7d\x7d\x7e\x7e\x81\x79\x80\x83\x81\x7c\x81"
            "\x81\x7f\x7b\x80\x81\x7e\x82\x80\x7d\x7e\x7e\x7f"
            "\x80\x7d\x80\x81\x83\x81\x7f\x81\x82\x7e\x76\x7e"
            "\x81\x7c\x81\x81\x7e\x7f\x7e\x7f\x81\x7f\x7c\x80"
            "\x82\x81\x80\x80\x81\x7f\x81\x7f\x80\x7c\x7f\x7e"
            "\x79\x7e\x7e\x7f\x7f\x81\x7f\x80\x84\x82\x7f\x81"
            "\x80\x80\x79\x7e\x80\x79\x80\x80\x7f\x7e\x7d\x81"
            "\x7e\x81\x81\x7c\x83\x81\x7b\x80\x80\x80\x80\x80"
            "\x80\x77\x83\x81\x7c\x7e\x7c\x7d\x7c\x7d\x7c\x81"
            "\x83\x80\x7f\x83\x83\x7c\x76\x78\x80\x78\x7c\x80"
            "\x81\x78\x79\x80\x7a\x84\x80\x7b\x81\x7d\x7d\x7f"
            "\x7e\x80\x80\x7f\x80\x76\x83\x83\x7c\x7e\x7e\x7d"
            "\x81\x7d\x7c\x81\x80\x82\x80\x81\x7f\x7c\x7e\x7d"
            "\x80\x76\x83\x84\x7b\x7f\x7d\x7a\x7f\x7c\x78\x81"
            "\x7f\x83\x81\x7f\x80\x7e\x79\x7f\x83\x82\x7d\x7c"
            "\x80\x7c\x7b\x80\x7c\x82\x7f\x7c\x7d\x7e\x7d\x7f"
            "\x80\x80\x83\x81\x7f\x7e\x7e\x7f\x80\x78\x7c\x83"
            "\x7e\x82\x80\x7d\x81\x7e\x7e\x7e\x7d\x81\x81\x81"
            "\x81\x76\x82\x83\x7a\x7c\x7d\x7c\x81\x7e\x7c\x80"
            "\x7e\x83\x81\x82\x81\x7d\x77\x7e\x81\x77\x81\x82"
            "\x7a\x7d\x7f\x7f\x80\x80\x82\x80\x7b\x83\x81\x81"
            "\x81\x7d\x80\x7f\x85\x81\x7d\x7d\x7f\x7e\x76\x7f"
            "\x7a\x81\x82\x7c\x75\x7c\x7b\x80\x7f\x80\x7d\x7e"
            "\x80\x7a\x7c\x81\x7f\x79\x7e\x82\x7e\x84\x81\x7d"
            "\x7e\x80\x7f\x7f\x7d\x7f\x80\x7f\x82\x78\x81\x83"
            "\x7b\x7d\x80\x7c\x82\x7e\x79\x81\x7a\x82\x81\x82"
            "\x80\x7c\x76\x77\x80\x77\x80\x80\x7d\x7e\x81\x7b"
            "\x80\x7d\x7e\x85\x7e\x82\x81\x81\x80\x7a\x76\x80"
            "\x7c\x7b\x80\x7c\x7b\x7a\x84\x77\x7c\x7d\x7c\x86"
            "\x7d\x7e\x84\x83\x7d\x76\x79\x80\x7f\x76\x7f\x7f"
            "\x7d\x7b\x80\x7d\x7e\x80\x7b\x7e\x87\x7f\x7d\x7f"
            "\x7e\x79\x77\x7e\x81\x7b\x84\x83\x7b\x7e\x7c\x7c"
            "\x80\x7c\x7e\x80\x7e\x81\x80\x7f\x80\x7e\x7c\x7d"
            "\x7d\x78\x77\x7d\x81\x79\x78\x84\x76\x83\x81\x7a"
            "\x75\x79\x7b\x7d\x7d\x82\x7f\x82\x81\x77\x7b\x80"
            "\x7a\x7b\x7f\x7c\x84\x81\x7f\x7f\x7c\x84\x82\x7e"
            "\x7d\x7f\x7d\x7b\x83\x73\x7d\x82\x75\x7e\x78\x80"
            "\x80\x7f\x81\x7f\x74\x84\x80\x82\x7e\x7e\x7d\x7b"
            "\x85\x74\x7c\x7c\x7e\x7a\x77\x7d\x7e\x82\x7f\x7b"
            "\x7a\x83\x7f\x80\x7e\x7c\x77\x80\x80\x74\x7f\x83"
            "\x74\x79\x7f\x7e\x83\x7f\x7f\x80\x73\x84\x83\x7e"
            "\x7f\x7c\x80\x7e\x83\x72\x7e\x81\x7e\x7e\x80\x7e"
            "\x7f\x81\x7f\x7f\x7b\x83\x7e\x81\x7f\x79\x7e\x82"
            "\x81\x71\x81\x82\x7a\x7f\x78\x79\x81\x7e\x7d\x83"
            "\x74\x84\x81\x81\x80\x7c\x74\x7e\x7f\x75\x7c\x80"
            "\x7e\x79\x79\x83\x7e\x82\x7e\x7d\x72\x81\x7e\x7c"
            "\x80\x83\x7e\x80\x82\x7b\x82\x84\x7a\x79\x7e\x7c"
            "\x82\x7f\x78\x80\x74\x83\x82\x80\x7e\x7c\x73\x7f"
            "\x83\x73\x7d\x81\x75\x7c\x7d\x81\x80\x7f\x81\x7d"
            "\x74\x83\x7f\x82\x7e\x7f\x75\x7b\x85\x74\x7a\x7f"
            "\x7a\x7d\x77\x7e\x80\x7f\x7f\x7e\x73\x82\x7e\x82"
            "\x7f\x7c\x77\x7e\x7e\x74\x80\x84\x79\x7a\x7f\x7c"
            "\x83\x7d\x7c\x81\x73\x84\x83\x7e\x7e\x7b\x76\x7b"
            "\x84\x72\x7b\x80\x7d\x7b\x80\x7e\x80\x7f\x7c\x7e"
            "\x74\x83\x80\x81\x80\x7c\x80\x82\x80\x71\x82\x82"
            "\x74\x7f\x78\x7d\x80\x7e\x7f\x82\x74\x85\x81\x80"
            "\x7e\x7d\x74\x7e\x81\x75\x74\x7e\x7d\x7a\x7e\x83"
            "\x7e\x83\x7b\x7b\x7b\x80\x80\x7c\x7e\x82\x7e\x82"
            "\x80\x71\x82\x82\x7c\x7e\x78\x7d\x83\x7e\x7c\x82"
            "\x7a\x82\x81\x80\x80\x7d\x74\x76\x82\x73\x7d\x81"
            "\x7d\x7c\x78\x81\x80\x81\x7f\x7e\x74\x83\x80\x82"
            "\x80\x80\x7d\x7e\x85\x7c\x7c\x80\x7d\x79\x77\x7f"
            "\x7e\x7e\x7d\x7e\x7b\x82\x7e\x82\x81\x7f\x77\x7b"
            "\x7e\x76\x7e\x80\x7d\x7e\x7e\x7c\x85\x7e\x7c\x7f"
            "\x7e\x82\x84\x7f\x7f\x7d\x7d\x7d\x83\x79\x7f\x7e"
            "\x7c\x81\x80\x7d\x80\x7f\x7d\x80\x7b\x80\x80\x83"
            "\x7f\x7b\x7b\x7e\x81\x76\x82\x81\x7a\x81\x7b\x7a"
            "\x80\x7e\x7e\x82\x7e\x82\x80\x83\x7f\x7a\x80\x80"
            "\x7f\x79\x7f\x7e\x83\x7f\x81\x7d\x7d\x80\x80\x80"
            "\x80\x81\x82\x7f\x7f\x7d\x84\x84\x7e\x78\x7d\x7e"
            "\x80\x7d\x7c\x7e\x81\x83\x80\x7f\x7d\x81\x81\x7d"
            "\x7e\x7f\x83\x84\x79\x75\x75\x79\x7e\x7c\x76\x79"
            "\x79\x79\x77\x76\x89\x7b\x77\x7e\x7c\x7b\x7f\x76"
            "\x7e\x77\x82\x80\x7a\x7d\x80\x7b\x81\x7c\x7e\x82"
            "\x7d\x84\x81\x82\x83\x7e\x7c\x7c\x7e\x78\x73\x79"
            "\x81\x7b\x77\x84\x79\x83\x7e\x74\x7c\x7b\x77\x77"
            "\x7d\x83\x7f\x7b\x7f\x71\x83\x80\x7f\x81\x7d\x78"
            "\x7e\x78\x7e\x83\x75\x80\x7e\x84\x82\x7e\x79\x80"
            "\x82\x74\x73\x73\x82\x7e\x7c\x81\x74\x84\x7e\x75"
            "\x7c\x75\x79\x7c\x7b\x82\x7f\x80\x7e\x6f\x7e\x7f"
            "\x82\x81\x7b\x7d\x7f\x7d\x80\x83\x74\x81\x7f\x83"
            "\x82\x7f\x78\x80\x84\x74\x7d\x73\x80\x83\x7b\x80"
            "\x73\x80\x7f\x7b\x7e\x75\x73\x7d\x7f\x82\x7e\x82"
            "\x7f\x71\x80\x80\x7f\x82\x79\x7b\x7e\x7c\x7e\x83"
            "\x7b\x82\x80\x84\x81\x7e\x77\x7f\x82\x74\x73\x7d"
            "\x81\x81\x7c\x80\x7d\x80\x7e\x7d\x7e\x76\x7d\x7c"
            "\x7d\x81\x81\x86\x7f\x71\x80\x7f\x7e\x83\x7c\x7b"
            "\x7e\x7d\x7f\x82\x7b\x80\x7e\x83\x82\x7d\x76\x81"
            "\x80\x72\x7f\x7f\x81\x7f\x7f\x7f\x7e\x7f\x7c\x81"
            "\x80\x81\x81\x81\x81\x80\x7d\x84\x81\x71\x80\x80"
            "\x7e\x80\x7f\x7f\x7d\x7e\x7e\x83\x7c\x83\x7f\x82"
            "\x82\x7f\x7d\x81\x81\x71\x82\x7e\x7f\x81\x7b\x7e"
            "\x7f\x7a\x7c\x83\x7e\x82\x81\x82\x81\x7d\x76\x80"
            "\x80\x71\x82\x7e\x7d\x81\x7e\x7e\x7f\x7e\x76\x82"
            "\x81\x82\x80\x81\x82\x7e\x76\x82\x81\x71\x81\x7e"
            "\x7f\x80\x7e\x7e\x7f\x7d\x7e\x82\x83\x80\x80\x83"
            "\x81\x7d\x7e\x7e\x80\x71\x81\x7e\x81\x80\x74\x7e"
            "\x7d\x80\x80\x82\x82\x82\x79\x81\x82\x7f\x76\x81"
            "\x81\x71\x81\x80\x80\x80\x7c\x7e\x7d\x7f\x7f\x82"
            "\x80\x80\x7e\x83\x82\x7e\x76\x7e\x80\x7c\x80\x7f"
            "\x80\x81\x7c\x7f\x7d\x7d\x80\x83\x81\x81\x7e\x81"
            "\x81\x7f\x76\x81\x81\x71\x81\x74\x7f\x81\x74\x7d"
            "\x73\x7f\x7e\x82\x82\x80\x7c\x83\x82\x7d\x76\x7f"
            "\x82\x71\x7f\x7e\x80\x80\x74\x7e\x81\x7f\x80\x82"
            "\x80\x81\x80\x80\x82\x7f\x76\x80\x80\x71\x81\x80"
            "\x7d\x80\x74\x7d\x7e\x7f\x76\x82\x82\x82\x7f\x82"
            "\x82\x7f\x76\x7f\x7f\x71\x82\x7e\x77\x81\x7d\x78"
            "\x80\x80\x7e\x82\x82\x7f\x82\x82\x80\x7e\x76\x81"
            "\x7f\x7e\x82\x7e\x7e\x83\x74\x7e\x7d\x77\x7e\x82"
            "\x82\x81\x7c\x82\x82\x7d\x7f\x7f\x82\x7d\x80\x7f"
            "\x7d\x81\x7d\x7f\x7d\x7e\x7d\x83\x81\x80\x7f\x82"
            "\x82\x7b\x76\x7f\x81\x7d\x7f\x7e\x81\x80\x7d\x7c"
            "\x7f\x7d\x7f\x82\x82\x81\x80\x82\x80\x80\x7f\x81"
            "\x81\x71\x81\x7c\x80\x82\x7d\x7e\x7e\x7f\x7d\x82"
            "\x81\x81\x7c\x81\x82\x7d\x80\x7d\x80\x7d\x7f\x7e"
            "\x7f\x81\x7e\x7e\x7c\x7f\x80\x83\x80\x81\x7f\x82"
            "\x81\x7e\x80\x80\x81\x7c\x82\x7e\x81\x80\x7e\x7e"
            "\x7d\x7d\x7c\x81\x82\x82\x7d\x82\x82\x7f\x7e\x7e"
            "\x80\x75\x7f\x7f\x83\x7f\x7a\x7e\x73\x7e\x80\x82"
            "\x80\x80\x7e\x80\x82\x7e\x82\x84\x80\x71\x83\x81"
            "\x7b\x80\x7e\x7c\x7f\x7d\x7f\x83\x7f\x81\x7e\x81"
            "\x82\x7e\x81\x7f\x80\x71\x81\x80\x7f\x80\x7e\x7d"
            "\x7f\x7a\x7f\x83\x82\x80\x80\x82\x82\x7f\x80\x7e"
            "\x80\x71\x81\x7e\x80\x80\x7c\x7e\x80\x7e\x7f\x80"
            "\x7f\x81\x7e\x83\x82\x7e\x76\x80\x7f\x71\x80\x7e"
            "\x7f\x80\x7d\x7e\x80\x7e\x7f\x83\x81\x81\x81\x82"
            "\x82\x7e\x81\x7f\x80\x71\x81\x80\x7f\x80\x7f\x7d"
            "\x80\x7e\x7f\x82\x7f\x81\x80\x82\x82\x7e\x76\x82"
            "\x80\x71\x82\x7f\x7f\x81\x7a\x7c\x7d\x7e\x7c\x83"
            "\x82\x80\x80\x81\x82\x7e\x7d\x80\x7f\x7b\x80\x80"
            "\x7e\x81\x7e\x7e\x7d\x7e\x7f\x82\x7e\x83\x7f\x82"
            "\x82\x7c\x7f\x82\x80\x71\x7d\x7d\x83\x7e\x7e\x7f"
            "\x7a\x81\x7d\x80\x7f\x80\x7c\x7f\x80\x7f\x87\x83"
            "\x7e\x72\x7e\x80\x80\x82\x7c\x7d\x7d\x7e\x80\x83"
            "\x79\x82\x81\x83\x82\x7d\x79\x81\x83\x71\x72\x72"
            "\x82\x80\x7b\x81\x72\x81\x7c\x7d\x7f\x7d\x73\x7e"
            "\x7f\x83\x79\x7f\x7f\x6f\x7f\x7e\x7e\x84\x78\x7e"
            "\x7b\x7c\x81\x80\x79\x81\x7e\x83\x82\x7d\x78\x7e"
            "\x82\x71\x72\x72\x81\x7e\x74\x82\x72\x83\x80\x75"
            "\x7f\x75\x72\x7b\x7b\x83\x79\x7a\x7e\x74\x7e\x7f"
            "\x7c\x82\x7d\x7d\x7d\x79\x7e\x82\x7e\x83\x80\x84"
            "\x83\x7e\x7a\x7c\x82\x74\x73\x73\x83\x7e\x75\x81"
            "\x73\x83\x81\x75\x7a\x7c\x73\x78\x7e\x83\x7e\x7f"
            "\x7f\x72\x80\x80\x7b\x7e\x7c\x7b\x80\x7a\x7e\x82"
            "\x7d\x82\x7f\x85\x83\x7e\x77\x7c\x7e\x7a\x7a\x7c"
            "\x81\x7b\x7d\x82\x7d\x82\x82\x7c\x7e\x83\x7b\x7d"
            "\x7f\x81\x87\x82\x7e\x74\x7f\x7f\x77\x7d\x7a\x7b"
            "\x7e\x7d\x77\x82\x87\x7e\x7d\x81\x81\x7a\x78\x79"
            "\x7c\x76\x75\x75\x82\x7a\x77\x84\x76\x84\x7c\x7b"
            "\x7e\x7b\x77\x7a\x79\x81\x81\x7b\x7c\x79\x80\x7d"
            "\x86\x7e\x7a\x7f\x76\x81\x7d\x7e\x7d\x7d\x7a\x7d"
            "\x7e\x7e\x83\x84\x7f\x7a\x84\x80\x7c\x7d\x7e\x7c"
            "\x7d\x7e\x7e\x83\x7f\x82\x7f\x82\x82\x7d\x7a\x7c"
            "\x81\x78\x7f\x7d\x82\x84\x7e\x7c\x7d\x7d\x7c\x80"
            "\x80\x7f\x81\x80\x7e\x7d\x85\x80\x7f\x76\x7e\x7e"
            "\x81\x85\x7d\x7d\x7e\x7d\x80\x82\x7f\x80\x7e\x80"
            "\x7f\x7c\x7f\x80\x81\x76\x7f\x80\x79\x7f\x7d\x7d"
            "\x83\x7e\x7f\x81\x7f\x81\x83\x82\x80\x7e\x79\x7f"
            "\x7f\x76\x7f\x7c\x7e\x7e\x80\x7f\x81\x80\x7e\x82"
            "\x7d\x81\x83\x7f\x82\x7f\x80\x80\x81\x76\x80\x7f"
            "\x7c\x80\x7f\x7e\x82\x7e\x7d\x81\x7e\x82\x83\x82"
            "\x80\x7e\x81\x80\x84\x72\x7e\x7d\x7e\x7f\x80\x7f"
            "\x7e\x7e\x7d\x82\x7d\x81\x80\x82\x7f\x7c\x7d\x80"
            "\x81\x75\x7f\x82\x78\x80\x7f\x7c\x83\x7d\x7f\x81"
            "\x7d\x83\x82\x80\x7d\x7d\x78\x80\x80\x75\x7a\x7e"
            "\x7c\x7a\x7e\x83\x7f\x82\x81\x7c\x72\x7e\x80\x7c"
            "\x80\x83\x7d\x82\x81\x71\x80\x83\x74\x7c\x7e\x7b"
            "\x83\x7e\x7e\x81\x74\x84\x83\x80\x80\x7b\x74\x76"
            "\x83\x73\x7d\x82\x75\x7d\x78\x80\x81\x7e\x80\x7f"
            "\x74\x84\x81\x81\x7f\x7c\x75\x7e\x85\x74\x7a\x7d"
            "\x77\x7c\x77\x7b\x7f\x7f\x7f\x7d\x73\x82\x7d\x82"
            "\x80\x7c\x77\x7e\x7e\x74\x7f\x83\x74\x76\x7e\x7d"
            "\x84\x7c\x80\x7f\x7c\x84\x83\x80\x7f\x7d\x76\x7d"
            "\x84\x72\x7c\x80\x7e\x7c\x7f\x80\x7e\x81\x7f\x80"
            "\x74\x81\x7f\x81\x7f\x7e\x7d\x81\x82\x71\x82\x83"
            "\x7a\x7d\x78\x77\x81\x7f\x7f\x83\x74\x84\x82\x80"
            "\x7e\x7c\x74\x7b\x81\x75\x79\x80\x7c\x73\x7f\x81"
            "\x80\x83\x7d\x7d\x72\x81\x7e\x7f\x7e\x81\x7e\x83"
            "\x81\x72\x81\x84\x74\x7d\x7b\x7b\x82\x80\x7d\x81"
            "\x74\x83\x80\x80\x7f\x79\x73\x7a\x83\x73\x7e\x81"
            "\x75\x7c\x7c\x7f\x81\x7f\x80\x80\x74\x84\x81\x81"
            "\x7e\x7e\x75\x7d\x85\x74\x7c\x7d\x7c\x7c\x7c\x7e"
            "\x7e\x80\x81\x7e\x73\x82\x7d\x82\x80\x7e\x77\x7d"
            "\x7e\x74\x7f\x84\x7b\x7b\x7f\x7e\x83\x7e\x7e\x7f"
            "\x73\x84\x82\x7f\x7d\x7f\x7c\x7d\x83\x72\x7f\x81"
            "\x7e\x79\x7d\x7f\x7e\x82\x7c\x81\x74\x82\x7e\x80"
            "\x7f\x7e\x7f\x82\x81\x71\x82\x83\x74\x79\x7d\x79"
            "\x80\x7f\x7c\x83\x74\x84\x81\x80\x80\x7d\x74\x7b"
            "\x80\x75\x79\x7f\x81\x79\x7f\x80\x80\x83\x7f\x79"
            "\x72\x81\x80\x7d\x80\x80\x79\x84\x81\x72\x83\x84"
            "\x7b\x7a\x7c\x7d\x81\x7c\x7e\x81\x75\x83\x81\x80"
            "\x7e\x7c\x73\x7b\x81\x73\x81\x82\x7c\x7d\x7c\x7d"
            "\x81\x80\x7f\x82\x74\x84\x80\x80\x7f\x7e\x75\x80"
            "\x84\x74\x77\x80\x7d\x7c\x7c\x7e\x80\x81\x7f\x7f"
            "\x73\x82\x7f\x80\x82\x80\x77\x7b\x7f\x7b\x7d\x82"
            "\x74\x7b\x7e\x7f\x83\x80\x7d\x7e\x73\x83\x84\x7f"
            "\x7e\x7f\x76\x7e\x81\x7b\x81\x80\x7b\x7c\x7d\x7f"
            "\x81\x81\x7d\x83\x74\x83\x83\x7e\x7f\x7e\x7d\x7b"
            "\x80\x73\x82\x82\x7b\x7d\x7c\x7c\x81\x7e\x7f\x82"
            "\x75\x84\x81\x80\x81\x7b\x77\x7c\x83\x74\x77\x7a"
            "\x7d\x79\x77\x83\x7e\x83\x80\x7b\x73\x80\x79\x7e"
            "\x81\x81\x77\x80\x81\x74\x7e\x82\x7e\x76\x7e\x80"
            "\x82\x7f\x7f\x7e\x7c\x83\x82\x7f\x7f\x80\x7e\x80"
            "\x83\x72\x7d\x7f\x7f\x7c\x7d\x7e\x7e\x82\x7f\x81"
            "\x74\x83\x80\x81\x80\x7d\x75\x82\x80\x75\x83\x84"
            "\x77\x7c\x7e\x79\x80\x7d\x7a\x81\x75\x84\x80\x80"
            "\x80\x7b\x76\x7b\x80\x7a\x7b\x79\x7f\x79\x7d\x83"
            "\x7b\x82\x80\x74\x74\x7e\x74\x7d\x81\x84\x7f\x7f"
            "\x81\x7a\x81\x81\x7d\x7b\x80\x7e\x81\x7f\x7f\x80"
            "\x78\x82\x82\x82\x81\x7f\x7e\x7f\x80\x74\x81\x82"
            "\x76\x7d\x7d\x7d\x82\x7c\x7e\x82\x76\x84\x80\x82"
            "\x80\x7e\x76\x7d\x85\x79\x7e\x7e\x7e\x7e\x7d\x7f"
            "\x7b\x80\x7e\x7f\x76\x7f\x7e\x80\x82\x7f\x7d\x7f"
            "\x7e\x79\x7b\x7c\x82\x75\x80\x7f\x7c\x80\x80\x78"
            "\x75\x7f\x7f\x7c\x7d\x80\x84\x87\x81\x73\x7e\x80"
            "\x81\x7c\x7f\x7f\x7f\x80\x7c\x82\x74\x83\x80\x80"
            "\x81\x7d\x80\x83\x81\x75\x83\x82\x7a\x7e\x7f\x7a"
            "\x7f\x7e\x79\x83\x77\x83\x82\x81\x80\x7c\x7b\x7e"
            "\x80\x7d\x74\x7c\x7f\x73\x7f\x82\x7c\x83\x81\x79"
            "\x72\x80\x7f\x7c\x7d\x81\x79\x83\x7f\x7d\x7f\x83"
            "\x7b\x7b\x7e\x7e\x81\x81\x7e\x81\x7a\x84\x82\x7f"
            "\x7f\x7e\x76\x80\x82\x73\x7d\x81\x7d\x7d\x7f\x7e"
            "\x80\x81\x7f\x81\x74\x82\x82\x82\x81\x7f\x75\x7d"
            "\x85\x7c\x7d\x7d\x7e\x7c\x7e\x7e\x7d\x81\x7f\x80"
            "\x73\x81\x7e\x82\x80\x7c\x77\x80\x7f\x7e\x80\x82"
            "\x7b\x7c\x7f\x7e\x82\x80\x7e\x81\x73\x84\x82\x7e"
            "\x80\x7e\x80\x7f\x83\x7b\x80\x83\x7b\x79\x7c\x7d"
            "\x82\x7d\x7d\x81\x74\x84\x81\x81\x80\x7c\x75\x7c"
            "\x80\x76\x7f\x82\x7b\x78\x7d\x7d\x80\x80\x7e\x80"
            "\x75\x85\x82\x82\x80\x7f\x78\x7e\x7f\x7b\x7a\x7d"
            "\x80\x73\x7f\x83\x7e\x83\x82\x7d\x72\x7f\x7f\x7a"
            "\x7c\x81\x80\x81\x81\x7b\x82\x83\x7b\x7e\x80\x7c"
            "\x82\x7c\x78\x81\x75\x82\x82\x7f\x7f\x7e\x73\x75"
            "\x82\x73\x7f\x80\x7d\x7b\x7f\x81\x7f\x81\x7f\x80"
            "\x74\x82\x7f\x82\x81\x80\x75\x7e\x84\x74\x7c\x7d"
            "\x7c\x7a\x7b\x7e\x7e\x82\x7f\x7e\x73\x82\x7e\x80"
            "\x80\x7e\x7d\x82\x7e\x74\x7f\x84\x74\x7b\x7d\x7d"
            "\x83\x7d\x7e\x80\x7a\x84\x82\x7f\x7e\x7c\x76\x7c"
            "\x83\x72\x80\x83\x7a\x7d\x7c\x7d\x82\x7e\x7c\x80"
            "\x74\x84\x80\x81\x7f\x7c\x75\x79\x82\x7b\x7e\x80"
            "\x7c\x7d\x7c\x7f\x80\x7e\x7d\x82\x75\x84\x7f\x82"
            "\x80\x7e\x77\x7d\x7f\x75\x7b\x7f\x7d\x7a\x7f\x82"
            "\x7f\x83\x80\x79\x72\x81\x7f\x7e\x7d\x82\x79\x82"
            "\x81\x73\x82\x84\x7b\x7b\x7e\x7d\x82\x7c\x78\x80"
            "\x7f\x83\x81\x7f\x7f\x7e\x73\x7a\x83\x73\x7e\x81"
            "\x7d\x7c\x80\x7b\x7f\x81\x7d\x81\x74\x83\x80\x81"
            "\x80\x7f\x75\x80\x85\x74\x7e\x7b\x7e\x7c\x7e\x7d"
            "\x7d\x81\x80\x81\x73\x80\x7d\x81\x80\x7d\x77\x80"
            "\x7f\x74\x80\x84\x79\x7c\x7c\x7d\x82\x7c\x7c\x81"
            "\x73\x85\x83\x80\x7f\x7c\x76\x7c\x82\x74\x7f\x83"
            "\x7a\x7d\x7d\x7e\x83\x7f\x79\x7f\x76\x82\x81\x7f"
            "\x80\x7d\x77\x7e\x82\x72\x7e\x80\x7b\x7c\x7f\x7f"
            "\x7f\x7f\x79\x82\x74\x84\x80\x82\x80\x80\x7d\x80"
            "\x7e\x75\x7c\x7e\x81\x78\x7d\x7f\x7d\x84\x80\x7b"
            "\x72\x7f\x80\x7e\x7d\x81\x7f\x85\x81\x73\x82\x83"
            "\x7a\x7c\x7e\x7a\x82\x7b\x7c\x82\x7a\x82\x83\x80"
            "\x7f\x7b\x73\x80\x81\x73\x80\x80\x7d\x7e\x7c\x81"
            "\x7f\x81\x80\x80\x7b\x83\x7f\x80\x80\x7f\x7d\x7e"
            "\x84\x7c\x7b\x7e\x7d\x76\x7c\x81\x7c\x7f\x81\x7f"
            "\x73\x80\x7c\x80\x81\x80\x77\x82\x7d\x7c\x7e\x84"
            "\x7b\x7b\x79\x7d\x83\x7f\x7f\x80\x73\x84\x83\x80"
            "\x7f\x7e\x76\x77\x82\x75\x7f\x82\x7b\x7c\x7f\x7e"
            "\x83\x7f\x7e\x80\x77\x82\x82\x81\x80\x7d\x78\x79"
            "\x82\x7a\x7e\x80\x7d\x7e\x7e\x7c\x82\x81\x82\x7f"
            "\x75\x83\x83\x7f\x7b\x7b\x7f\x7e\x7d\x7a\x77\x7c"
            "\x85\x77\x7f\x7b\x7c\x80\x7d\x7e\x77\x7d\x7e\x7c"
            "\x78\x7f\x80\x87\x80\x74\x82\x84\x74\x7d\x7f\x7c"
            "\x83\x7b\x7d\x82\x77\x83\x81\x80\x7f\x79\x75\x77"
            "\x83\x75\x7f\x81\x7d\x7d\x7f\x7d\x80\x81\x7e\x82"
            "\x7b\x83\x80\x81\x7f\x7e\x76\x7d\x7d\x76\x7f\x7f"
            "\x76\x87\x7d\x75\x7e\x77\x7c\x80\x7a\x7f\x7f\x7d"
            "\x79\x75\x76\x78\x7f\x76\x7e\x81\x7e\x7e\x7e\x80"
            "\x81\x83\x82\x7f\x7c\x81\x81\x7e\x80\x7f\x7a\x7c"
            "\x82\x77\x7d\x7f\x7d\x80\x7b\x83\x81\x7f\x7e\x7f"
            "\x7c\x7f\x80\x7f\x81\x81\x7b\x7d\x7e\x77\x82\x7e"
            "\x74\x7e\x78\x78\x7e\x7c\x7b\x83\x80\x7d\x7c\x84"
            "\x85\x7a\x75\x76\x7f\x76\x7d\x80\x7e\x7c\x7e\x80"
            "\x80\x82\x81\x80\x82\x82\x80\x7e\x80\x80\x81\x82"
            "\x7f\x75\x80\x80\x7f\x7b\x7b\x81\x80\x82\x80\x80"
            "\x7f\x81\x7f\x82\x82\x80\x7d\x80\x7f\x73\x86\x85"
            "\x74\x79\x7b\x73\x7d\x7a\x7e\x7c\x7b\x82\x7d\x7f"
            "\x80\x7b\x76\x76\x7e\x78\x75\x7e\x81\x75\x77\x80"
            "\x7b\x84\x7e\x79\x78\x7b\x7e\x7b\x7d\x83\x7f\x82"
            "\x80\x79\x7a\x7f\x7c\x7a\x7e\x81\x7f\x84\x80\x7d"
            "\x7a\x80\x7f\x7e\x80\x7f\x7e\x80\x80\x73\x83\x83"
            "\x75\x7d\x7b\x7d\x80\x7e\x7e\x82\x74\x84\x81\x81"
            "\x80\x7c\x75\x7b\x85\x74\x77\x7e\x7d\x7a\x7c\x7f"
            "\x7d\x7f\x7f\x7e\x73\x7e\x7c\x82\x7f\x80\x77\x7d"
            "\x7e\x74\x7c\x84\x7c\x79\x7d\x7c\x82\x7f\x7e\x7f"
            "\x73\x86\x82\x7d\x7f\x7c\x76\x7d\x83\x72\x7d\x80"
            "\x76\x7b\x7c\x7f\x7f\x7f\x7d\x82\x74\x83\x82\x81"
            "\x81\x81\x75\x79\x82\x71\x82\x83\x7a\x7d\x78\x7c"
            "\x80\x7e\x7e\x81\x7a\x84\x81\x81\x81\x7c\x74\x7e"
            "\x7f\x7b\x74\x7e\x7f\x78\x7f\x80\x7e\x84\x7d\x79"
            "\x72\x7f\x7f\x7c\x7d\x81\x80\x84\x81\x73\x80\x82"
            "\x80\x7c\x80\x7f\x80\x81\x7f\x7f\x75\x82\x80\x81"
            "\x81\x7e\x73\x81\x81\x73\x81\x83\x7b\x7d\x78\x7a"
            "\x80\x7e\x7e\x83\x74\x84\x80\x81\x81\x7d\x75\x77"
            "\x85\x74\x7e\x7e\x7e\x7a\x7e\x7f\x7c\x80\x7e\x7e"
            "\x73\x7f\x7b\x82\x81\x7f\x77\x7e\x7d\x74\x7f\x84"
            "\x7b\x7b\x7d\x7c\x83\x7e\x80\x7f\x73\x85\x83\x7f"
            "\x7c\x7c\x7d\x7d\x83\x72\x7a\x7f\x7d\x7d\x7d\x81"
            "\x7f\x81\x7f\x82\x7c\x82\x80\x81\x80\x7f\x75\x80"
            "\x82\x71\x82\x82\x7a\x7e\x7c\x7b\x80\x7d\x7e\x83"
            "\x74\x84\x82\x81\x7f\x7b\x74\x7b\x7f\x75\x74\x7e"
            "\x80\x78\x7f\x80\x7e\x84\x7f\x7d\x72\x80\x7f\x7e"
            "\x7d\x81\x80\x84\x82\x7b\x7f\x81\x7b\x78\x7e\x82"
            "\x80\x81\x7d\x81\x7e\x81\x80\x7e\x80\x81\x7c\x7f"
            "\x81\x73\x81\x82\x75\x7b\x78\x7d\x80\x7d\x7f\x82"
            "\x74\x85\x80\x81\x80\x7d\x7d\x7b\x85\x74\x7c\x7d"
            "\x7a\x7c\x7e\x7f\x7b\x80\x80\x80\x73\x7f\x7b\x82"
            "\x81\x7d\x7d\x7e\x7e\x7b\x7e\x83\x79\x76\x7f\x80"
            "\x83\x80\x7d\x7f\x73\x84\x83\x7d\x7f\x7e\x76\x7f"
            "\x83\x72\x7d\x7e\x81\x7e\x7b\x7f\x7e\x80\x7d\x82"
            "\x74\x81\x7f\x81\x80\x7f\x75\x84\x81\x71\x84\x82"
            "\x74\x7b\x7e\x7c\x80\x7d\x7f\x84\x74\x84\x80\x7f"
            "\x7f\x7b\x74\x76\x7f\x75\x79\x7f\x80\x7c\x7f\x80"
            "\x7f\x83\x7f\x7e\x72\x7f\x81\x7c\x78\x80\x7f\x85"
            "\x82\x71\x7f\x81\x7e\x7a\x80\x7f\x81\x81\x7e\x81"
            "\x74\x83\x80\x7e\x7e\x7f\x83\x7f\x80\x73\x7f\x80"
            "\x7c\x7a\x78\x82\x80\x81\x80\x81\x74\x83\x81\x80"
            "\x80\x80\x75\x7f\x85\x7b\x7f\x7c\x77\x7d\x7f\x7d"
            "\x7f\x7f\x7e\x81\x73\x81\x7d\x82\x7f\x7d\x77\x80"
            "\x7f\x7b\x7d\x81\x7f\x7c\x7e\x7f\x82\x80\x7e\x7f"
            "\x73\x84\x82\x7f\x7f\x7e\x81\x82\x84\x7d\x7d\x7f"
            "\x7f\x7c\x7e\x81\x7e\x80\x80\x80\x7a\x80\x7e\x7f"
            "\x80\x80\x7f\x81\x81\x73\x81\x83\x79\x7d\x7d\x7b"
            "\x80\x7f\x7e\x83\x76\x83\x82\x80\x80\x7d\x79\x7e"
            "\x7c\x7c\x73\x74\x80\x75\x76\x81\x7c\x85\x83\x74"
            "\x74\x7a\x74\x76\x7b\x80\x80\x81\x81\x7c\x80\x82"
            "\x7d\x7d\x7e\x7e\x82\x80\x7f\x81\x7b\x82\x82\x80"
            "\x7b\x7d\x7d\x82\x7f\x75\x7e\x81\x7e\x79\x80\x7f"
            "\x82\x80\x7e\x80\x79\x82\x83\x81\x7f\x7d\x7f\x83"
            "\x83\x7c\x7d\x7f\x7e\x78\x7e\x80\x7e\x83\x80\x7b"
            "\x7a\x7f\x7d\x7f\x80\x80\x7e\x81\x7f\x7e\x7b\x7d"
            "\x80\x77\x78\x82\x7a\x83\x84\x7c\x75\x7f\x7d\x80"
            "\x83\x80\x7e\x7e\x80\x77\x7d\x7e\x75\x86\x7e\x79"
            "\x7c\x7a\x76\x80\x7c\x7f\x7d\x80\x78\x79\x76\x7d"
            "\x80\x79\x80\x81\x7c\x81\x7e\x7f\x81\x80\x7f\x81"
            "\x7f\x82\x81\x80\x81\x80\x7a\x80\x7e\x77\x81\x80"
            "\x80\x7f\x7f\x7f\x80\x82\x80\x80\x83\x80\x7e\x81"
            "\x80\x7d\x78\x7f\x80\x7d\x81\x81\x7f\x7f\x7f\x7f"
            "\x80\x80\x7e\x81\x82\x81\x7f\x82\x80\x7f\x7b\x80"
            "\x80\x78\x82\x82\x7f\x7f\x7c\x7c\x80\x7e\x7e\x82"
            "\x81\x80\x7f\x80\x82\x7e\x7b\x81\x80\x77\x82\x83"
            "\x7e\x81\x7a\x79\x81\x7c\x7a\x81\x7f\x82\x7e\x81"
            "\x82\x7d\x7b\x80\x7f\x73\x81\x81\x77\x7e\x75\x7d"
            "\x80\x7d\x77\x81\x84\x81\x80\x82\x83\x80\x81\x7f"
            "\x7e\x7a\x79\x82\x81\x7d\x79\x84\x80\x82\x81\x7e"
            "\x80\x7f\x7a\x7f\x7c\x81\x7c\x7e\x80\x76\x81\x80"
            "\x7a\x7e\x7b\x81\x7a\x81\x7a\x83\x7e\x82\x80\x80"
            "\x83\x7f\x7b\x7c\x81\x82\x82\x80\x78\x81\x77\x79"
            "\x80\x7e\x78\x83\x81\x82\x76\x82\x81\x7c\x78\x7b"
            "\x80\x79\x79\x78\x82\x7f\x7a\x83\x77\x83\x7e\x7b"
            "\x7b\x7b\x80\x7b\x7d\x81\x7f\x7e\x7f\x77\x7d\x81"
            "\x7a\x7e\x7a\x7a\x80\x7a\x7a\x85\x7d\x7f\x81\x82"
            "\x83\x80\x7a\x7c\x81\x77\x84\x80\x78\x7d\x7d\x78"
            "\x7e\x81\x79\x82\x7e\x82\x7d\x83\x7e\x7a\x7a\x7a"
            "\x85\x7a\x7c\x7c\x7d\x7c\x7d\x7d\x7d\x80\x7c\x7e"
            "\x82\x7e\x7d\x7e\x7e\x7d\x85\x83\x7d\x7c\x78\x79"
            "\x84\x7b\x7c\x7e\x79\x83\x80\x7b\x79\x7c\x7b\x81"
            "\x7d\x7e\x7f\x85\x7f\x79\x82\x7f\x7a\x84\x7d\x79"
            "\x7e\x80\x7a\x7f\x7f\x7f\x7e\x84\x7f\x7a\x7a\x7b"
            "\x7f\x7a\x7f\x7e\x7b\x82\x7d\x7b\x83\x7b\x7b\x80"
            "\x86\x7f\x7e\x80\x80\x7c\x7b\x7c\x7f\x7b\x83\x83"
            "\x7b\x7f\x7e\x7b\x7f\x7d\x7c\x7e\x84\x80\x7e\x7f"
            "\x83\x7c\x7c\x7d\x7f\x79\x84\x80\x7c\x7f\x7c\x7c"
            "\x7f\x7d\x7c\x80\x7f\x7f\x83\x7f\x80\x82\x7c\x7d"
            "\x83\x7a\x80\x80\x7d\x7f\x7e\x7c\x7e\x7c\x7c\x84"
            "\x80\x7f\x7e\x84\x80\x7d\x7d\x7e\x7f\x7b\x80\x81"
            "\x7d\x7e\x7e\x7e\x7f\x7e\x7e\x7f\x80\x80\x7f\x80"
            "\x86\x7e\x7d\x7e\x7f\x7b\x80\x7f\x7d\x7f\x7f\x7d"
            "\x7e\x7d\x7d\x86\x80\x7f\x7f\x80\x80\x7e\x7e\x7e"
            "\x80\x7a\x7f\x7f\x7d\x7e\x7d\x7d\x7e\x7d\x7d\x7e"
            "\x87\x7f\x7f\x80\x7f\x7e\x7d\x7d\x7f\x7a\x81\x86"
            "\x7c\x7e\x7e\x7c\x7f\x7c\x7d\x7f\x80\x80\x7f\x80"
            "\x7f\x7d\x7d\x7d";
    std::cout << "Sequence (id 0):";
    //const char* sequence = read_seq;
    PSSMCalculator pssmCalculator(&subMat, 10000, 10000, 1.4, 2.5);
    const size_t setSize = 1;
    const char * msaSeq[setSize] = {"LFILNIISMNKQTKVKGYLLLLLVISSLFISLVGHGYTANKVSAPNPAKEYPQDNLSVIDMKNLPGTQIKSMVKDELQQFLEEQGFRRLKNKSLVDLRRIWLGFMYEDFFYTMHKKTDLPISVIYAFFIIEATNAGIESKLMAKALNPGGIKYRGTGKKMKAMDDCY",
                        };
    char * msaSequence[setSize];

    size_t centerSeqSize = strlen(msaSeq[0]);
    for (size_t k = 0; k < setSize; ++k) {
        msaSequence[k] = new char[centerSeqSize];
        for (unsigned int pos = 0; pos < centerSeqSize; ++pos) {
            msaSequence[k][pos] = (msaSeq[k][pos] == '-') ?
                                  21 : subMat.aa2int[(int) msaSeq[k][pos]];
        }
    }
    PSSMCalculator::Profile pssmRet = pssmCalculator.computePSSMFromMSA(setSize,centerSeqSize, (const char **) msaSequence, false);
    const char * sequence = pssmRet.pssm;
    char * data = new char[centerSeqSize*20+1];
    for (size_t i = 0; i < centerSeqSize*20; i++) {
        // Avoid a null byte result
        std::cout << (int)sequence[i] << std::endl;
        data[i] = sequence[i] ^ 0x80;
    }
    data[centerSeqSize*20] = '\0';

    //const char* sequence = profile.c_str();
//    std::cout << sequence << "";
    Sequence* s = new Sequence(10000, Sequence::HMM_PROFILE, &subMat, kmer_size, true, true);
    s->mapSequence(0,0,data);
    s->printProfile();
    Sequence* dbSeq = new Sequence(10000, Sequence::AMINO_ACIDS, &subMat, kmer_size, true, true);
    //dbSeq->mapSequence(1,"lala2",ref_seq);
    const char* sequence2 = "LFILNIISMNKQTKVKGYLLLLLVISSLFISLVGHGYTANKVSAPNPAKEYPQDNLSVIDMKNLPGTQIKSMVKDELQQFLEEQGFRRLKNKSLVDLRRIWLGFMYEDFFYTMHKKTDLPISVIYAFFIIEATNAGIESKLMAKALNPGGIKYRGTGKKMKAMDDCY";

    dbSeq->mapSequence(1,1,sequence2);
    SmithWaterman aligner(15000, subMat.alphabetSize, false);
    int8_t * tinySubMat = new int8_t[subMat.alphabetSize*subMat.alphabetSize];

    aligner.ssw_init(s, s->getAlignmentProfile(), &subMat, subMat.alphabetSize, 2);
    int32_t maskLen = s->L / 2;
    int gap_open = 10;
    int gap_extend = 1;
    EvalueComputation evalueComputation(100000, &subMat, gap_open, gap_extend, true );
    s_align alignment = aligner.ssw_align(dbSeq->int_sequence, dbSeq->L, gap_open, gap_extend, 0, 10000, &evalueComputation, 0, 0.0, maskLen);
    if(alignment.cigar){
        std::cout << "Cigar" << std::endl;

        int32_t targetPos = alignment.dbStartPos1, queryPos = alignment.qStartPos1;
        for (int32_t c = 0; c < alignment.cigarLen; ++c) {
            char letter = SmithWaterman::cigar_int_to_op(alignment.cigar[c]);
            uint32_t length = SmithWaterman::cigar_int_to_len(alignment.cigar[c]);
            for (uint32_t i = 0; i < length; ++i){
                if (letter == 'M') {
                    fprintf(stdout,"%c",subMat.int2aa[dbSeq->int_sequence[targetPos]]);
                    if (dbSeq->int_sequence[targetPos] == s->int_sequence[queryPos]){
                        fprintf(stdout, "|");
                    }
                    else fprintf(stdout, "*");
                    fprintf(stdout,"%c",subMat.int2aa[s->int_sequence[queryPos]]);
                    ++queryPos;
                    ++targetPos;
                } else {
                    if (letter == 'I'){
                        fprintf(stdout,"%c |",subMat.int2aa[s->int_sequence[queryPos]]);
                        ++queryPos;
                    } else{
                        fprintf(stdout,"| %c",subMat.int2aa[dbSeq->int_sequence[targetPos]]);
                        ++targetPos;
                    }
                }
                std::cout << std::endl;
            }
        }
    }
    std::cout << alignment.score1 << " " << alignment.qStartPos1  << "-"<< alignment.qEndPos1 << " "
            << alignment.dbStartPos1 << "-"<< alignment.dbEndPos1 << std::endl;
    double lambda= 0.267;
    size_t  dbSize = 30*pow(10,6);
    std::cout << dbSize << std::endl;
//    double K= 0.041;
//    double Kmn=(qL * seqDbSize * dbSeq->L);
    std::cout << exp(-(alignment.score1 * lambda)) << " " <<  dbSize * exp(-(alignment.score1 * lambda)) << std::endl;
    delete [] tinySubMat;
    delete [] alignment.cigar;
    delete s;
    delete dbSeq;
    return 0;
}

