"""NLQL - Natural Language Query Language for unstructured text and RAG retrieval.

NLQL is a SQL-like query language designed for querying unstructured text,
vector databases, and RAG (Retrieval-Augmented Generation) systems.

Example:
    >>> from nlql import NLQL
    >>> nlql = NLQL(source=my_data)
    >>> results = nlql.execute('''
    ...     SELECT SENTENCE
    ...     WHERE SIMILAR_TO("AI agents") > 0.8
    ...     ORDER BY SIMILARITY DESC
    ...     LIMIT 5
    ... ''')
"""

from nlql.api import NLQL
from nlql.config import NLQLConfig
from nlql.errors import (
    NLQLAdapterError,
    NLQLConfigError,
    NLQLError,
    NLQLExecutionError,
    NLQLParseError,
    NLQLRegistryError,
    NLQLTypeError,
)
from nlql.registry import (
    register_embedding_provider,
    register_function,
    register_operator,
    register_splitter,
)
from nlql.result import Result
from nlql.types import (
    BaseType,
    DateType,
    NumberType,
    TextType,
    register_meta_field,
)
from nlql.version import __version__

__all__ = [
    # Main API
    "NLQL",
    "NLQLConfig",
    # Results
    "Result",
    # Errors
    "NLQLError",
    "NLQLParseError",
    "NLQLExecutionError",
    "NLQLTypeError",
    "NLQLAdapterError",
    "NLQLRegistryError",
    "NLQLConfigError",
    # Type system
    "BaseType",
    "NumberType",
    "TextType",
    "DateType",
    "register_meta_field",
    # Registry/extensibility
    "register_operator",
    "register_function",
    "register_splitter",
    "register_embedding_provider",
    # Version
    "__version__",
]

