from collections.abc import Callable, Iterator, Sequence
import enum

import sgl


class Button(Widget):
    def __init__(self, parent: Widget | None, label: str = '', callback: Callable[[], None] | None = None) -> None: ...

    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def callback(self) -> Callable[[], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[], None], /) -> None: ...

class CheckBox(ValuePropertyBool):
    def __init__(self, parent: Widget | None, label: str = '', value: bool = False, callback: Callable[[bool], None] | None = None) -> None: ...

class ComboBox(ValuePropertyInt):
    def __init__(self, parent: Widget | None, label: str = '', value: int = 0, callback: Callable[[int], None] | None = None, items: Sequence[str] = []) -> None: ...

    @property
    def items(self) -> list[str]: ...

    @items.setter
    def items(self, arg: Sequence[str], /) -> None: ...

class Context(sgl.Object):
    def __init__(self, device: sgl.Device) -> None: ...

    def new_frame(self, width: int, height: int) -> None: ...

    def render(self, framebuffer: sgl.Framebuffer, command_buffer: sgl.CommandBuffer) -> None: ...

    def handle_keyboard_event(self, event: sgl.KeyboardEvent) -> bool: ...

    def handle_mouse_event(self, event: sgl.MouseEvent) -> bool: ...

    def process_events(self) -> None: ...

    @property
    def screen(self) -> Screen: ...

class DragFloat(ValuePropertyFloat):
    def __init__(self, parent: Widget | None, label: str = '', value: float = 0.0, callback: Callable[[float], None] | None = None, speed: float = 1.0, min: float = 0.0, max: float = 0.0, format: str = '%.3f', flags: SliderFlags = 0) -> None: ...

    @property
    def speed(self) -> float: ...

    @speed.setter
    def speed(self, arg: float, /) -> None: ...

    @property
    def min(self) -> float: ...

    @min.setter
    def min(self, arg: float, /) -> None: ...

    @property
    def max(self) -> float: ...

    @max.setter
    def max(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class DragFloat2(ValuePropertyFloat2):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.float2 = ..., callback: Callable[[sgl.math.float2], None] | None = None, speed: float = 1.0, min: float = 0.0, max: float = 0.0, format: str = '%.3f', flags: SliderFlags = 0) -> None: ...

    @property
    def speed(self) -> float: ...

    @speed.setter
    def speed(self, arg: float, /) -> None: ...

    @property
    def min(self) -> float: ...

    @min.setter
    def min(self, arg: float, /) -> None: ...

    @property
    def max(self) -> float: ...

    @max.setter
    def max(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class DragFloat3(ValuePropertyFloat3):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.float3 = ..., callback: Callable[[sgl.math.float3], None] | None = None, speed: float = 1.0, min: float = 0.0, max: float = 0.0, format: str = '%.3f', flags: SliderFlags = 0) -> None: ...

    @property
    def speed(self) -> float: ...

    @speed.setter
    def speed(self, arg: float, /) -> None: ...

    @property
    def min(self) -> float: ...

    @min.setter
    def min(self, arg: float, /) -> None: ...

    @property
    def max(self) -> float: ...

    @max.setter
    def max(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class DragFloat4(ValuePropertyFloat4):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.float4 = ..., callback: Callable[[sgl.math.float4], None] | None = None, speed: float = 1.0, min: float = 0.0, max: float = 0.0, format: str = '%.3f', flags: SliderFlags = 0) -> None: ...

    @property
    def speed(self) -> float: ...

    @speed.setter
    def speed(self, arg: float, /) -> None: ...

    @property
    def min(self) -> float: ...

    @min.setter
    def min(self, arg: float, /) -> None: ...

    @property
    def max(self) -> float: ...

    @max.setter
    def max(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class DragInt(ValuePropertyInt):
    def __init__(self, parent: Widget | None, label: str = '', value: int = 0, callback: Callable[[int], None] | None = None, speed: float = 1.0, min: int = 0, max: int = 0, format: str = '%d', flags: SliderFlags = 0) -> None: ...

    @property
    def speed(self) -> int: ...

    @speed.setter
    def speed(self, arg: int, /) -> None: ...

    @property
    def min(self) -> int: ...

    @min.setter
    def min(self, arg: int, /) -> None: ...

    @property
    def max(self) -> int: ...

    @max.setter
    def max(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class DragInt2(ValuePropertyInt2):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.int2 = ..., callback: Callable[[sgl.math.int2], None] | None = None, speed: float = 1.0, min: int = 0, max: int = 0, format: str = '%d', flags: SliderFlags = 0) -> None: ...

    @property
    def speed(self) -> int: ...

    @speed.setter
    def speed(self, arg: int, /) -> None: ...

    @property
    def min(self) -> int: ...

    @min.setter
    def min(self, arg: int, /) -> None: ...

    @property
    def max(self) -> int: ...

    @max.setter
    def max(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class DragInt3(ValuePropertyInt3):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.int3 = ..., callback: Callable[[sgl.math.int3], None] | None = None, speed: float = 1.0, min: int = 0, max: int = 0, format: str = '%d', flags: SliderFlags = 0) -> None: ...

    @property
    def speed(self) -> int: ...

    @speed.setter
    def speed(self, arg: int, /) -> None: ...

    @property
    def min(self) -> int: ...

    @min.setter
    def min(self, arg: int, /) -> None: ...

    @property
    def max(self) -> int: ...

    @max.setter
    def max(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class DragInt4(ValuePropertyInt4):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.int4 = ..., callback: Callable[[sgl.math.int4], None] | None = None, speed: float = 1.0, min: int = 0, max: int = 0, format: str = '%d', flags: SliderFlags = 0) -> None: ...

    @property
    def speed(self) -> int: ...

    @speed.setter
    def speed(self, arg: int, /) -> None: ...

    @property
    def min(self) -> int: ...

    @min.setter
    def min(self, arg: int, /) -> None: ...

    @property
    def max(self) -> int: ...

    @max.setter
    def max(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class Group(Widget):
    def __init__(self, parent: Widget | None, label: str = '') -> None: ...

    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

class InputFloat(ValuePropertyFloat):
    def __init__(self, parent: Widget | None, label: str = '', value: float = 0.0, callback: Callable[[float], None] | None = None, step: float = 1.0, step_fast: float = 100.0, format: str = '%.3f', flags: InputTextFlags = 0) -> None: ...

    @property
    def step(self) -> float: ...

    @step.setter
    def step(self, arg: float, /) -> None: ...

    @property
    def step_fast(self) -> float: ...

    @step_fast.setter
    def step_fast(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> InputTextFlags: ...

    @flags.setter
    def flags(self, arg: InputTextFlags, /) -> None: ...

class InputFloat2(ValuePropertyFloat2):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.float2 = ..., callback: Callable[[sgl.math.float2], None] | None = None, step: float = 1.0, step_fast: float = 100.0, format: str = '%.3f', flags: InputTextFlags = 0) -> None: ...

    @property
    def step(self) -> float: ...

    @step.setter
    def step(self, arg: float, /) -> None: ...

    @property
    def step_fast(self) -> float: ...

    @step_fast.setter
    def step_fast(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> InputTextFlags: ...

    @flags.setter
    def flags(self, arg: InputTextFlags, /) -> None: ...

class InputFloat3(ValuePropertyFloat3):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.float3 = ..., callback: Callable[[sgl.math.float3], None] | None = None, step: float = 1.0, step_fast: float = 100.0, format: str = '%.3f', flags: InputTextFlags = 0) -> None: ...

    @property
    def step(self) -> float: ...

    @step.setter
    def step(self, arg: float, /) -> None: ...

    @property
    def step_fast(self) -> float: ...

    @step_fast.setter
    def step_fast(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> InputTextFlags: ...

    @flags.setter
    def flags(self, arg: InputTextFlags, /) -> None: ...

class InputFloat4(ValuePropertyFloat4):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.float4 = ..., callback: Callable[[sgl.math.float4], None] | None = None, step: float = 1.0, step_fast: float = 100.0, format: str = '%.3f', flags: InputTextFlags = 0) -> None: ...

    @property
    def step(self) -> float: ...

    @step.setter
    def step(self, arg: float, /) -> None: ...

    @property
    def step_fast(self) -> float: ...

    @step_fast.setter
    def step_fast(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> InputTextFlags: ...

    @flags.setter
    def flags(self, arg: InputTextFlags, /) -> None: ...

class InputInt(ValuePropertyInt):
    def __init__(self, parent: Widget | None, label: str = '', value: int = 0, callback: Callable[[int], None] | None = None, step: int = 1, step_fast: int = 100, format: str = '%d', flags: InputTextFlags = 0) -> None: ...

    @property
    def step(self) -> int: ...

    @step.setter
    def step(self, arg: int, /) -> None: ...

    @property
    def step_fast(self) -> int: ...

    @step_fast.setter
    def step_fast(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> InputTextFlags: ...

    @flags.setter
    def flags(self, arg: InputTextFlags, /) -> None: ...

class InputInt2(ValuePropertyInt2):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.int2 = ..., callback: Callable[[sgl.math.int2], None] | None = None, step: int = 1, step_fast: int = 100, format: str = '%d', flags: InputTextFlags = 0) -> None: ...

    @property
    def step(self) -> int: ...

    @step.setter
    def step(self, arg: int, /) -> None: ...

    @property
    def step_fast(self) -> int: ...

    @step_fast.setter
    def step_fast(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> InputTextFlags: ...

    @flags.setter
    def flags(self, arg: InputTextFlags, /) -> None: ...

class InputInt3(ValuePropertyInt3):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.int3 = ..., callback: Callable[[sgl.math.int3], None] | None = None, step: int = 1, step_fast: int = 100, format: str = '%d', flags: InputTextFlags = 0) -> None: ...

    @property
    def step(self) -> int: ...

    @step.setter
    def step(self, arg: int, /) -> None: ...

    @property
    def step_fast(self) -> int: ...

    @step_fast.setter
    def step_fast(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> InputTextFlags: ...

    @flags.setter
    def flags(self, arg: InputTextFlags, /) -> None: ...

class InputInt4(ValuePropertyInt4):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.int4 = ..., callback: Callable[[sgl.math.int4], None] | None = None, step: int = 1, step_fast: int = 100, format: str = '%d', flags: InputTextFlags = 0) -> None: ...

    @property
    def step(self) -> int: ...

    @step.setter
    def step(self, arg: int, /) -> None: ...

    @property
    def step_fast(self) -> int: ...

    @step_fast.setter
    def step_fast(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> InputTextFlags: ...

    @flags.setter
    def flags(self, arg: InputTextFlags, /) -> None: ...

class InputText(ValuePropertyString):
    def __init__(self, parent: Widget | None, label: str = '', value: str = False, callback: Callable[[str], None] | None = None, multi_line: bool = False, flags: InputTextFlags = 0) -> None: ...

class InputTextFlags(enum.IntFlag):
    __str__ = __repr__

    def __repr__(self, /):
        """Return repr(self)."""

    none = 0

    chars_decimal = 1

    chars_hexadecimal = 2

    chars_uppercase = 4

    chars_no_blank = 8

    auto_select_all = 16

    enter_returns_true = 32

    callback_completion = 64

    callback_history = 128

    callback_always = 256

    callback_char_filter = 512

    allow_tab_input = 1024

    ctrl_enter_for_new_line = 2048

    no_horizontal_scroll = 4096

    always_overwrite = 8192

    read_only = 16384

    password = 32768

    no_undo_redo = 65536

    chars_scientific = 131072

    escape_clears_all = 1048576

class ListBox(ValuePropertyInt):
    def __init__(self, parent: Widget | None, label: str = '', value: int = 0, callback: Callable[[int], None] | None = None, items: Sequence[str] = [], height_in_items: int = -1) -> None: ...

    @property
    def items(self) -> list[str]: ...

    @items.setter
    def items(self, arg: Sequence[str], /) -> None: ...

    @property
    def height_in_items(self) -> int: ...

    @height_in_items.setter
    def height_in_items(self, arg: int, /) -> None: ...

class ProgressBar(Widget):
    def __init__(self, parent: Widget | None, fraction: float = 0.0) -> None: ...

    @property
    def fraction(self) -> float: ...

    @fraction.setter
    def fraction(self, arg: float, /) -> None: ...

class Screen(Widget):
    """
    This is the main widget that represents the screen. It is intended to
    be used as the parent for ``Window`` widgets.
    """

    def dispatch_events(self) -> None: ...

class SliderFlags(enum.IntFlag):
    __str__ = __repr__

    def __repr__(self, /):
        """Return repr(self)."""

    none = 0

    always_clamp = 16

    logarithmic = 32

    no_round_to_format = 64

    no_input = 128

class SliderFloat(ValuePropertyFloat):
    def __init__(self, parent: Widget | None, label: str = '', value: float = 0.0, callback: Callable[[float], None] | None = None, min: float = 0.0, max: float = 0.0, format: str = '%.3f', flags: SliderFlags = 0) -> None: ...

    @property
    def min(self) -> float: ...

    @min.setter
    def min(self, arg: float, /) -> None: ...

    @property
    def max(self) -> float: ...

    @max.setter
    def max(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class SliderFloat2(ValuePropertyFloat2):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.float2 = ..., callback: Callable[[sgl.math.float2], None] | None = None, min: float = 0.0, max: float = 0.0, format: str = '%.3f', flags: SliderFlags = 0) -> None: ...

    @property
    def min(self) -> float: ...

    @min.setter
    def min(self, arg: float, /) -> None: ...

    @property
    def max(self) -> float: ...

    @max.setter
    def max(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class SliderFloat3(ValuePropertyFloat3):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.float3 = ..., callback: Callable[[sgl.math.float3], None] | None = None, min: float = 0.0, max: float = 0.0, format: str = '%.3f', flags: SliderFlags = 0) -> None: ...

    @property
    def min(self) -> float: ...

    @min.setter
    def min(self, arg: float, /) -> None: ...

    @property
    def max(self) -> float: ...

    @max.setter
    def max(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class SliderFloat4(ValuePropertyFloat4):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.float4 = ..., callback: Callable[[sgl.math.float4], None] | None = None, min: float = 0.0, max: float = 0.0, format: str = '%.3f', flags: SliderFlags = 0) -> None: ...

    @property
    def min(self) -> float: ...

    @min.setter
    def min(self, arg: float, /) -> None: ...

    @property
    def max(self) -> float: ...

    @max.setter
    def max(self, arg: float, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class SliderInt(ValuePropertyInt):
    def __init__(self, parent: Widget | None, label: str = '', value: int = 0, callback: Callable[[int], None] | None = None, min: int = 0, max: int = 0, format: str = '%d', flags: SliderFlags = 0) -> None: ...

    @property
    def min(self) -> int: ...

    @min.setter
    def min(self, arg: int, /) -> None: ...

    @property
    def max(self) -> int: ...

    @max.setter
    def max(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class SliderInt2(ValuePropertyInt2):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.int2 = ..., callback: Callable[[sgl.math.int2], None] | None = None, min: int = 0, max: int = 0, format: str = '%d', flags: SliderFlags = 0) -> None: ...

    @property
    def min(self) -> int: ...

    @min.setter
    def min(self, arg: int, /) -> None: ...

    @property
    def max(self) -> int: ...

    @max.setter
    def max(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class SliderInt3(ValuePropertyInt3):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.int3 = ..., callback: Callable[[sgl.math.int3], None] | None = None, min: int = 0, max: int = 0, format: str = '%d', flags: SliderFlags = 0) -> None: ...

    @property
    def min(self) -> int: ...

    @min.setter
    def min(self, arg: int, /) -> None: ...

    @property
    def max(self) -> int: ...

    @max.setter
    def max(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class SliderInt4(ValuePropertyInt4):
    def __init__(self, parent: Widget | None, label: str = '', value: sgl.math.int4 = ..., callback: Callable[[sgl.math.int4], None] | None = None, min: int = 0, max: int = 0, format: str = '%d', flags: SliderFlags = 0) -> None: ...

    @property
    def min(self) -> int: ...

    @min.setter
    def min(self, arg: int, /) -> None: ...

    @property
    def max(self) -> int: ...

    @max.setter
    def max(self, arg: int, /) -> None: ...

    @property
    def format(self) -> str: ...

    @format.setter
    def format(self, arg: str, /) -> None: ...

    @property
    def flags(self) -> SliderFlags: ...

    @flags.setter
    def flags(self, arg: SliderFlags, /) -> None: ...

class Text(Widget):
    def __init__(self, parent: Widget | None, text: str = '') -> None: ...

    @property
    def text(self) -> str: ...

    @text.setter
    def text(self, arg: str, /) -> None: ...

class ValuePropertyBool(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> bool: ...

    @value.setter
    def value(self, arg: bool, /) -> None: ...

    @property
    def callback(self) -> Callable[[bool], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[bool], None], /) -> None: ...

class ValuePropertyFloat(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> float: ...

    @value.setter
    def value(self, arg: float, /) -> None: ...

    @property
    def callback(self) -> Callable[[float], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[float], None], /) -> None: ...

class ValuePropertyFloat2(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> sgl.math.float2: ...

    @value.setter
    def value(self, arg: sgl.math.float2, /) -> None: ...

    @property
    def callback(self) -> Callable[[sgl.math.float2], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[sgl.math.float2], None], /) -> None: ...

class ValuePropertyFloat3(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> sgl.math.float3: ...

    @value.setter
    def value(self, arg: sgl.math.float3, /) -> None: ...

    @property
    def callback(self) -> Callable[[sgl.math.float3], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[sgl.math.float3], None], /) -> None: ...

class ValuePropertyFloat4(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> sgl.math.float4: ...

    @value.setter
    def value(self, arg: sgl.math.float4, /) -> None: ...

    @property
    def callback(self) -> Callable[[sgl.math.float4], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[sgl.math.float4], None], /) -> None: ...

class ValuePropertyInt(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> int: ...

    @value.setter
    def value(self, arg: int, /) -> None: ...

    @property
    def callback(self) -> Callable[[int], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[int], None], /) -> None: ...

class ValuePropertyInt2(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> sgl.math.int2: ...

    @value.setter
    def value(self, arg: sgl.math.int2, /) -> None: ...

    @property
    def callback(self) -> Callable[[sgl.math.int2], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[sgl.math.int2], None], /) -> None: ...

class ValuePropertyInt3(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> sgl.math.int3: ...

    @value.setter
    def value(self, arg: sgl.math.int3, /) -> None: ...

    @property
    def callback(self) -> Callable[[sgl.math.int3], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[sgl.math.int3], None], /) -> None: ...

class ValuePropertyInt4(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> sgl.math.int4: ...

    @value.setter
    def value(self, arg: sgl.math.int4, /) -> None: ...

    @property
    def callback(self) -> Callable[[sgl.math.int4], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[sgl.math.int4], None], /) -> None: ...

class ValuePropertyString(Widget):
    @property
    def label(self) -> str: ...

    @label.setter
    def label(self, arg: str, /) -> None: ...

    @property
    def value(self) -> str: ...

    @value.setter
    def value(self, arg: str, /) -> None: ...

    @property
    def callback(self) -> Callable[[str], None]: ...

    @callback.setter
    def callback(self, arg: Callable[[str], None], /) -> None: ...

class Widget(sgl.Object):
    """Base class for Python UI widgets. Widgets own their children."""

    @property
    def parent(self) -> Widget: ...

    @parent.setter
    def parent(self, arg: Widget, /) -> None: ...

    @property
    def children(self) -> list[Widget]: ...

    @property
    def visible(self) -> bool: ...

    @visible.setter
    def visible(self, arg: bool, /) -> None: ...

    @property
    def enabled(self) -> bool: ...

    @enabled.setter
    def enabled(self, arg: bool, /) -> None: ...

    def child_index(self, child: Widget) -> int: ...

    def add_child(self, child: Widget) -> None: ...

    def add_child_at(self, child: Widget, index: int) -> None: ...

    def remove_child(self, child: Widget) -> None: ...

    def remove_child_at(self, index: int) -> None: ...

    def remove_all_children(self) -> None: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[Widget]: ...

    def __getitem__(self, arg: int, /) -> Widget: ...

    def __delitem__(self, arg: int, /) -> None: ...

class Window(Widget):
    def __init__(self, parent: Widget | None, title: str = '', position: sgl.math.float2 = ..., size: sgl.math.float2 = ...) -> None: ...

    def show(self) -> None: ...

    def close(self) -> None: ...

    @property
    def title(self) -> str: ...

    @title.setter
    def title(self, arg: str, /) -> None: ...

    @property
    def position(self) -> sgl.math.float2: ...

    @position.setter
    def position(self, arg: sgl.math.float2, /) -> None: ...

    @property
    def size(self) -> sgl.math.float2: ...

    @size.setter
    def size(self, arg: sgl.math.float2, /) -> None: ...
