import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FrontdoorCustomHttpsConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#custom_https_provisioning_enabled FrontdoorCustomHttpsConfiguration#custom_https_provisioning_enabled}.
     *
     * @stability stable
     */
    readonly customHttpsProvisioningEnabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#frontend_endpoint_id FrontdoorCustomHttpsConfiguration#frontend_endpoint_id}.
     *
     * @stability stable
     */
    readonly frontendEndpointId: string;
    /**
     * custom_https_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#custom_https_configuration FrontdoorCustomHttpsConfiguration#custom_https_configuration}
     *
     * @stability stable
     */
    readonly customHttpsConfiguration?: FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#timeouts FrontdoorCustomHttpsConfiguration#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FrontdoorCustomHttpsConfigurationTimeouts;
}
/**
 * @stability stable
 */
export interface FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#azure_key_vault_certificate_secret_name FrontdoorCustomHttpsConfiguration#azure_key_vault_certificate_secret_name}.
     *
     * @stability stable
     */
    readonly azureKeyVaultCertificateSecretName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#azure_key_vault_certificate_secret_version FrontdoorCustomHttpsConfiguration#azure_key_vault_certificate_secret_version}.
     *
     * @stability stable
     */
    readonly azureKeyVaultCertificateSecretVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#azure_key_vault_certificate_vault_id FrontdoorCustomHttpsConfiguration#azure_key_vault_certificate_vault_id}.
     *
     * @stability stable
     */
    readonly azureKeyVaultCertificateVaultId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#certificate_source FrontdoorCustomHttpsConfiguration#certificate_source}.
     *
     * @stability stable
     */
    readonly certificateSource?: string;
}
export declare function frontdoorCustomHttpsConfigurationCustomHttpsConfigurationToTerraform(struct?: FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference | FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration): any;
/**
 * @stability stable
 */
export declare class FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration | undefined);
    private _azureKeyVaultCertificateSecretName?;
    /**
     * @stability stable
     */
    get azureKeyVaultCertificateSecretName(): string;
    /**
     * @stability stable
     */
    set azureKeyVaultCertificateSecretName(value: string);
    /**
     * @stability stable
     */
    resetAzureKeyVaultCertificateSecretName(): void;
    /**
     * @stability stable
     */
    get azureKeyVaultCertificateSecretNameInput(): string | undefined;
    private _azureKeyVaultCertificateSecretVersion?;
    /**
     * @stability stable
     */
    get azureKeyVaultCertificateSecretVersion(): string;
    /**
     * @stability stable
     */
    set azureKeyVaultCertificateSecretVersion(value: string);
    /**
     * @stability stable
     */
    resetAzureKeyVaultCertificateSecretVersion(): void;
    /**
     * @stability stable
     */
    get azureKeyVaultCertificateSecretVersionInput(): string | undefined;
    private _azureKeyVaultCertificateVaultId?;
    /**
     * @stability stable
     */
    get azureKeyVaultCertificateVaultId(): string;
    /**
     * @stability stable
     */
    set azureKeyVaultCertificateVaultId(value: string);
    /**
     * @stability stable
     */
    resetAzureKeyVaultCertificateVaultId(): void;
    /**
     * @stability stable
     */
    get azureKeyVaultCertificateVaultIdInput(): string | undefined;
    private _certificateSource?;
    /**
     * @stability stable
     */
    get certificateSource(): string;
    /**
     * @stability stable
     */
    set certificateSource(value: string);
    /**
     * @stability stable
     */
    resetCertificateSource(): void;
    /**
     * @stability stable
     */
    get certificateSourceInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FrontdoorCustomHttpsConfigurationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#create FrontdoorCustomHttpsConfiguration#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#delete FrontdoorCustomHttpsConfiguration#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#read FrontdoorCustomHttpsConfiguration#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html#update FrontdoorCustomHttpsConfiguration#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function frontdoorCustomHttpsConfigurationTimeoutsToTerraform(struct?: FrontdoorCustomHttpsConfigurationTimeoutsOutputReference | FrontdoorCustomHttpsConfigurationTimeouts): any;
/**
 * @stability stable
 */
export declare class FrontdoorCustomHttpsConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FrontdoorCustomHttpsConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FrontdoorCustomHttpsConfigurationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html azurerm_frontdoor_custom_https_configuration}.
 *
 * @stability stable
 */
export declare class FrontdoorCustomHttpsConfiguration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration.html azurerm_frontdoor_custom_https_configuration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FrontdoorCustomHttpsConfigurationConfig);
    private _customHttpsProvisioningEnabled?;
    /**
     * @stability stable
     */
    get customHttpsProvisioningEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customHttpsProvisioningEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get customHttpsProvisioningEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frontendEndpointId?;
    /**
     * @stability stable
     */
    get frontendEndpointId(): string;
    /**
     * @stability stable
     */
    set frontendEndpointId(value: string);
    /**
     * @stability stable
     */
    get frontendEndpointIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _customHttpsConfiguration;
    /**
     * @stability stable
     */
    get customHttpsConfiguration(): FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference;
    /**
     * @stability stable
     */
    putCustomHttpsConfiguration(value: FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration): void;
    /**
     * @stability stable
     */
    resetCustomHttpsConfiguration(): void;
    /**
     * @stability stable
     */
    get customHttpsConfigurationInput(): FrontdoorCustomHttpsConfigurationCustomHttpsConfiguration | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FrontdoorCustomHttpsConfigurationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FrontdoorCustomHttpsConfigurationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FrontdoorCustomHttpsConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
