import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ResourcePolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#description ResourcePolicyAssignment#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#display_name ResourcePolicyAssignment#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#enforce ResourcePolicyAssignment#enforce}.
     *
     * @stability stable
     */
    readonly enforce?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#location ResourcePolicyAssignment#location}.
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#metadata ResourcePolicyAssignment#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#name ResourcePolicyAssignment#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#not_scopes ResourcePolicyAssignment#not_scopes}.
     *
     * @stability stable
     */
    readonly notScopes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#parameters ResourcePolicyAssignment#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#policy_definition_id ResourcePolicyAssignment#policy_definition_id}.
     *
     * @stability stable
     */
    readonly policyDefinitionId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#resource_id ResourcePolicyAssignment#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId: string;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#identity ResourcePolicyAssignment#identity}
     *
     * @stability stable
     */
    readonly identity?: ResourcePolicyAssignmentIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#timeouts ResourcePolicyAssignment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ResourcePolicyAssignmentTimeouts;
}
/**
 * @stability stable
 */
export interface ResourcePolicyAssignmentIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#type ResourcePolicyAssignment#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function resourcePolicyAssignmentIdentityToTerraform(struct?: ResourcePolicyAssignmentIdentityOutputReference | ResourcePolicyAssignmentIdentity): any;
/**
 * @stability stable
 */
export declare class ResourcePolicyAssignmentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ResourcePolicyAssignmentIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ResourcePolicyAssignmentIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ResourcePolicyAssignmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#create ResourcePolicyAssignment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#delete ResourcePolicyAssignment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#read ResourcePolicyAssignment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html#update ResourcePolicyAssignment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function resourcePolicyAssignmentTimeoutsToTerraform(struct?: ResourcePolicyAssignmentTimeoutsOutputReference | ResourcePolicyAssignmentTimeouts): any;
/**
 * @stability stable
 */
export declare class ResourcePolicyAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ResourcePolicyAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ResourcePolicyAssignmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html azurerm_resource_policy_assignment}.
 *
 * @stability stable
 */
export declare class ResourcePolicyAssignment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/resource_policy_assignment.html azurerm_resource_policy_assignment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ResourcePolicyAssignmentConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enforce?;
    /**
     * @stability stable
     */
    get enforce(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforce(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnforce(): void;
    /**
     * @stability stable
     */
    get enforceInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    set metadata(value: string);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _notScopes?;
    /**
     * @stability stable
     */
    get notScopes(): string[];
    /**
     * @stability stable
     */
    set notScopes(value: string[]);
    /**
     * @stability stable
     */
    resetNotScopes(): void;
    /**
     * @stability stable
     */
    get notScopesInput(): string[] | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): string;
    /**
     * @stability stable
     */
    set parameters(value: string);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): string | undefined;
    private _policyDefinitionId?;
    /**
     * @stability stable
     */
    get policyDefinitionId(): string;
    /**
     * @stability stable
     */
    set policyDefinitionId(value: string);
    /**
     * @stability stable
     */
    get policyDefinitionIdInput(): string | undefined;
    private _resourceId?;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    set resourceId(value: string);
    /**
     * @stability stable
     */
    get resourceIdInput(): string | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): ResourcePolicyAssignmentIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: ResourcePolicyAssignmentIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): ResourcePolicyAssignmentIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ResourcePolicyAssignmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ResourcePolicyAssignmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ResourcePolicyAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
