PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE data_source (
	id INTEGER NOT NULL, 
	name VARCHAR(100), 
	uri VARCHAR(200), 
	md5 VARCHAR(32), 
	date DATETIME, 
	notes VARCHAR(1000), 
	PRIMARY KEY (id), 
	UNIQUE (md5)
);
INSERT INTO data_source VALUES(1,'Import of Phytophthora_ITS_database_v0.006.fasta','legacy/Phytophthora_ITS_database_v0.006.fasta','bea0011f0c16e82d274ebbc9123256ae',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(2,'Import of 2019-04-03-ITS_Peronosporales_16394.fasta','2019-04-03-ITS_Peronosporales_16394.fasta','55eef105f49e9994413485c4990ed03c',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(3,'Import of 75-BT3-1gDNA-P-austrocedrae-F08_S68_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/75-BT3-1gDNA-P-austrocedrae-F08_S68_L001.fasta','91a6b1fb167e4b615680031c633460ba',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(4,'Import of 76-GA3-1gDNA-P-austrocedrae-G08_S80_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/76-GA3-1gDNA-P-austrocedrae-G08_S80_L001.fasta','40c6d2c3e17e8dfdbade47e8569d3c03',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(5,'Import of 78-CPB-DNA-from-FR-dil-1-100-P-obscura-H08_S92_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/78-CPB-DNA-from-FR-dil-1-100-P-obscura-H08_S92_L001.fasta','72686f1f47bd516ea7de57e2cc2e0408',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(6,'Import of 88069-P-infestans-56-A04_S4_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/88069-P-infestans-56-A04_S4_L001.fasta','40c7bdbb9ab307da56d97da74c78c517',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(7,'Import of P-Europaea-DNA-from-FR-dil-1-100-F07_S67_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/P-Europaea-DNA-from-FR-dil-1-100-F07_S67_L001.fasta','362352516e70a8116a84f5cce9abd4a2',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(8,'Import of P-cinnamomi-82-1-10-A07_S7_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/P-cinnamomi-82-1-10-A07_S7_L001.fasta','5ef0372106ea4dc54a9a45a9e1db7715',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(9,'Import of SCRP-1161-P-austrocedrae-1-C03_S27_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1161-P-austrocedrae-1-C03_S27_L001.fasta','83cd452c6a16dde6e0fc7895518eff4e',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(10,'Import of SCRP-1161-P-austrocedrae-1-G01_S73_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1161-P-austrocedrae-1-G01_S73_L001.fasta','b08c90370731937fb5b887946f49f7f5',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(11,'Import of SCRP-1161-P-austrocedrae-2-D03_S39_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1161-P-austrocedrae-2-D03_S39_L001.fasta','6aace8f3bf2b4cfb62ce61ebc8d4c003',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(12,'Import of SCRP-1161-P-austrocedrae-2-D10_S46_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1161-P-austrocedrae-2-D10_S46_L001.fasta','b648167be2bcf3def0b5256d9131f7aa',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(13,'Import of SCRP-1161-P-austrocedrae-2-H01_S85_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1161-P-austrocedrae-2-H01_S85_L001.fasta','bf916aae414b5570566164d40842cf32',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(14,'Import of SCRP-1161-P-austrocedrae-3-A02_S2_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1161-P-austrocedrae-3-A02_S2_L001.fasta','b98e937b9f5837a2238c63d2bf4b98f8',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(15,'Import of SCRP-1161-P-austrocedrae-3-E03_S51_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1161-P-austrocedrae-3-E03_S51_L001.fasta','bd4539cf9b923c4a024ce4fb2f86916f',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(16,'Import of SCRP-1161-P-austrocedrae-3-E10_S58_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1161-P-austrocedrae-3-E10_S58_L001.fasta','7559bf5be31c34c77a7f069aa08b068b',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(17,'Import of SCRP-1163-P-gonapodyides-C06_S30_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1163-P-gonapodyides-C06_S30_L001.fasta','8f0e2627f751907d3b0d9c5bbac5a56e',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(18,'Import of SCRP-1170-P-Erythroseptica-B08_S20_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1170-P-Erythroseptica-B08_S20_L001.fasta','560774c336ff940e83f269420a49f844',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(19,'Import of SCRP-1171-P-Erythroseptica-C08_S32_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1171-P-Erythroseptica-C08_S32_L001.fasta','da3953b858c0c5b4fe87028acf47f5aa',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(20,'Import of SCRP-1197-P-nicotianae-50-or-51-C04_S28_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-1197-P-nicotianae-50-or-51-C04_S28_L001.fasta','6d0905da1ee09536b032bbbb2e90f069',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(21,'Import of SCRP-734-P-pseudosyringae-1-D01_S37_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-734-P-pseudosyringae-1-D01_S37_L001.fasta','8734ef27511bd8a5b7e8dfe415202da6',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(22,'Import of SCRP-734-P-pseudosyringae-1-H02_S86_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-734-P-pseudosyringae-1-H02_S86_L001.fasta','c834d39d726e8fc3c1fa87f3935af931',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(23,'Import of SCRP-734-P-pseudosyringae-2-A03_S3_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-734-P-pseudosyringae-2-A03_S3_L001.fasta','8206630676a298b4aed933521b84fbfd',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(24,'Import of SCRP-734-P-pseudosyringae-2-A10_S10_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-734-P-pseudosyringae-2-A10_S10_L001.fasta','1ce5277d2bc5365d224b0570183a8f4e',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(25,'Import of SCRP-734-P-pseudosyringae-2-E01_S49_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-734-P-pseudosyringae-2-E01_S49_L001.fasta','1d16e645064951debc14ccfd4d533c2d',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(26,'Import of SCRP-734-P-pseudosyringae-3-B03_S15_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-734-P-pseudosyringae-3-B03_S15_L001.fasta','b888eba3db745c92948aa47bae985054',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(27,'Import of SCRP-734-P-pseudosyringae-3-B10_S22_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-734-P-pseudosyringae-3-B10_S22_L001.fasta','b8a895774a433bd020ccad3f5c618d60',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(28,'Import of SCRP-734-P-pseudosyringae-3-F01_S61_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP-734-P-pseudosyringae-3-F01_S61_L001.fasta','b7ac7889d17e8a7685542c4f8757c9a8',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(29,'Import of SCRP10-P-aln-G06_S78_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP10-P-aln-G06_S78_L001.fasta','69640424bd3b5adb623553d8314fefb8',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(30,'Import of SCRP1022-P-capsici-40-B05_S17_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP1022-P-capsici-40-B05_S17_L001.fasta','2c5a418bb927ce55b77803b4beb671ef',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(31,'Import of SCRP1161-P-austrocedrae-1-20-1-C10_S34_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP1161-P-austrocedrae-1-20-1-C10_S34_L001.fasta','3230e84230698dcc975fedcaf39ea53f',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(32,'Import of SCRP1162-P-austrocedrae-E08_S56_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP1162-P-austrocedrae-E08_S56_L001.fasta','0d795fffcf901205d19e3d1a2c6d2e3a',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(33,'Import of SCRP165-P-citricola-T-60-D05_S41_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP165-P-citricola-T-60-D05_S41_L001.fasta','56fbc648d2541664b53cc60a9436b85f',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(34,'Import of SCRP207-P-Cryptogea-72-or-73-A08_S8_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP207-P-Cryptogea-72-or-73-A08_S8_L001.fasta','be73c9ef9f8ee205e8ebeae897088819',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(35,'Import of SCRP23-P-boehmeriae-1-B09_S21_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP23-P-boehmeriae-1-B09_S21_L001.fasta','a9c4bc4a77a846a7776111a31e7169c8',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(36,'Import of SCRP231-P-cajani-71-1-10-C07_S31_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP231-P-cajani-71-1-10-C07_S31_L001.fasta','0cfd74dc21f96231901af963edab5db6',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(37,'Import of SCRP333-P-rubi-race-3-45-E07_S55_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP333-P-rubi-race-3-45-E07_S55_L001.fasta','f49e8569c06751a4c73a3b76b2c526d5',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(38,'Import of SCRP35-1-or-2-P-cactorum-CAC17-R222-E04_S52_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP35-1-or-2-P-cactorum-CAC17-R222-E04_S52_L001.fasta','5b1b350c6ba4f387171cc34fb68d9d0a',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(39,'Import of SCRP37-P-cactorum-CAC19-145H-F04_S64_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP37-P-cactorum-CAC19-145H-F04_S64_L001.fasta','973a7da7b5456a9ababe4e1d0491ae4a',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(40,'Import of SCRP371-P-idaei-41-A05_S5_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP371-P-idaei-41-A05_S5_L001.fasta','626e61ade2e891869ae791a7612b9595',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(41,'Import of SCRP372-P-idaei-47-H04_S88_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP372-P-idaei-47-H04_S88_L001.fasta','9e3a6fa4c55ffdd6b4fb89625149dfba',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(42,'Import of SCRP377-P-ilicis-62-E05_S53_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP377-P-ilicis-62-E05_S53_L001.fasta','f213cbb46c9617853dbb7f6603e83751',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(43,'Import of SCRP386-P-iranica-48-D04_S40_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP386-P-iranica-48-D04_S40_L001.fasta','23b7bc0d46c8dfd3950adff668b2b312',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(44,'Import of SCRP388-P-castaneae-44-H05_S89_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP388-P-castaneae-44-H05_S89_L001.fasta','8cb064f67b32b9a236044229d7b17109',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(45,'Import of SCRP417-1-OR-2-P-megasperma-B06_S18_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP417-1-OR-2-P-megasperma-B06_S18_L001.fasta','e6473127f23983be6e919785811bc520',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(46,'Import of SCRP420-P-megasperma-66-A06_S6_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP420-P-megasperma-66-A06_S6_L001.fasta','ecbd644156cc882785a54e2439d2d19d',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(47,'Import of SCRP455-P-melonis-70-B07_S19_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP455-P-melonis-70-B07_S19_L001.fasta','826df35be1fed50f4c0e636af394e914',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(48,'Import of SCRP474-P-palmivora-11-F05_S65_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP474-P-palmivora-11-F05_S65_L001.fasta','7af8f85ce05be6570d084141e1bc8860',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(49,'Import of SCRP526-P-palmivora-64A-G05_S77_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP526-P-palmivora-64A-G05_S77_L001.fasta','bf57deba192fbff245d7b53e0099dcb0',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(50,'Import of SCRP538-P-pseudotsugae-54-B04_S16_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP538-P-pseudotsugae-54-B04_S16_L001.fasta','754f6ad30471634e5ca30ce98a8b32c2',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(51,'Import of SCRP56-P-cactorum-CH97-46-G04_S76_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP56-P-cactorum-CH97-46-G04_S76_L001.fasta','a265079ea980848b82ab14d420c17e4b',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(52,'Import of SCRP607-P-fallax-12-A09_S9_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP607-P-fallax-12-A09_S9_L001.fasta','290762d2bff38ddea6b93f0cd1614403',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(53,'Import of SCRP645-P-inundata-68-D06_S42_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP645-P-inundata-68-D06_S42_L001.fasta','5e82bcd90cb36bb2d72db31cbb3f74a9',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(54,'Import of SCRP660-P-syringae-83-H07_S91_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP660-P-syringae-83-H07_S91_L001.fasta','9bc7668851ce0d11539efde4ff5bc7ea',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(55,'Import of SCRP71-P-cambivora-69-cam5-H06_S90_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP71-P-cambivora-69-cam5-H06_S90_L001.fasta','ec9a90c42fc2607bdadb34ce342afa73',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(56,'Import of SCRP734-1-or-2-P-pseudosyringae-1-H09_S93_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP734-1-or-2-P-pseudosyringae-1-H09_S93_L001.fasta','1da67019fefe9707eee96d8f79f9dee8',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(57,'Import of SCRP893-P-sojae-22-D07_S43_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP893-P-sojae-22-D07_S43_L001.fasta','332654a3603df94112a24fb41e015d46',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(58,'Import of SCRP9-P-aln-F06_S66_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/SCRP9-P-aln-F06_S66_L001.fasta','bd714bd948296304627e9f1b09ce1c92',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(59,'Import of T-30-4-1-A01_S1_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/T-30-4-1-A01_S1_L001.fasta','f7d1c9ba07c484f6c0a6e848e2623826',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(60,'Import of T-30-4-1-E02_S50_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/T-30-4-1-E02_S50_L001.fasta','30442eb34dfe0655060e5871aab8d60d',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(61,'Import of T-30-4-2-B01_S13_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/T-30-4-2-B01_S13_L001.fasta','af0ee11925db5b931ed845268982810a',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(62,'Import of T-30-4-2-F02_S62_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/T-30-4-2-F02_S62_L001.fasta','a5d87fb1473e41f64b3b5143c1cc5307',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(63,'Import of T-30-4-2-F09_S69_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/T-30-4-2-F09_S69_L001.fasta','e7d0fd96035a15b0a0afc63d4d0a292b',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(64,'Import of T-30-4-3-C01_S25_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/T-30-4-3-C01_S25_L001.fasta','a5d4384fd43d349ee7bd2dd185bdb678',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(65,'Import of T-30-4-3-G02_S74_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/T-30-4-3-G02_S74_L001.fasta','eb9e7fc57dd2bd27b57c4645908e3bc4',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(66,'Import of T-30-4-3-G09_S81_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/T-30-4-3-G09_S81_L001.fasta','d4de04855485222c331d639491bbd067',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(67,'Import of T30-4-P-infestans-55-1-20-1-E09_S57_L001.fasta','thapbi20180709p1_MetaControls/prepared_reads_v0.4.2/T30-4-P-infestans-55-1-20-1-E09_S57_L001.fasta','a0bf9adf24db5be670edb8c7b5299aee',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
INSERT INTO data_source VALUES(68,'Import of controls.fasta','controls.fasta','296b208ef0cc09aebe6a1a6eae1eb368',NULL,'Imported with thapbi_pict legacy_import v0.4.2');
CREATE TABLE taxonomy (
	id INTEGER NOT NULL, 
	ncbi_taxid INTEGER, 
	genus VARCHAR(100) NOT NULL, 
	species VARCHAR(100) NOT NULL, 
	PRIMARY KEY (id)
);
INSERT INTO taxonomy VALUES(1,4765,'Achlya','');
INSERT INTO taxonomy VALUES(2,4769,'Saprolegnia','');
INSERT INTO taxonomy VALUES(3,4778,'Bremia','');
INSERT INTO taxonomy VALUES(4,4780,'Plasmopara','');
INSERT INTO taxonomy VALUES(5,4783,'Phytophthora','');
INSERT INTO taxonomy VALUES(6,4797,'Pythium','');
INSERT INTO taxonomy VALUES(7,4802,'Lagenidium','');
INSERT INTO taxonomy VALUES(8,65356,'Albugo','');
INSERT INTO taxonomy VALUES(9,70742,'Peronospora','');
INSERT INTO taxonomy VALUES(10,74556,'Thraustotheca','');
INSERT INTO taxonomy VALUES(11,74559,'Dictyuchus','');
INSERT INTO taxonomy VALUES(12,92968,'Pythiopsis','');
INSERT INTO taxonomy VALUES(13,92971,'Aplanopsis','');
INSERT INTO taxonomy VALUES(14,92975,'Leptolegnia','');
INSERT INTO taxonomy VALUES(15,92980,'Apodachlya','');
INSERT INTO taxonomy VALUES(16,100860,'Aphanomyces','');
INSERT INTO taxonomy VALUES(17,100862,'Plectospira','');
INSERT INTO taxonomy VALUES(18,100865,'Leptomitus','');
INSERT INTO taxonomy VALUES(19,100873,'Sapromyces','');
INSERT INTO taxonomy VALUES(20,112093,'Brevilegnia','');
INSERT INTO taxonomy VALUES(21,120399,'Aplanes','');
INSERT INTO taxonomy VALUES(22,120403,'Calyptralegnia','');
INSERT INTO taxonomy VALUES(23,120410,'Pachymetra','');
INSERT INTO taxonomy VALUES(24,120422,'Scoliolegnia','');
INSERT INTO taxonomy VALUES(25,127445,'Halophytophthora','');
INSERT INTO taxonomy VALUES(26,134688,'Isoachlya','');
INSERT INTO taxonomy VALUES(27,135472,'Haliphthoros','');
INSERT INTO taxonomy VALUES(28,135475,'Atkinsiella','');
INSERT INTO taxonomy VALUES(29,135478,'Halocrusticida','');
INSERT INTO taxonomy VALUES(30,143452,'Pseudoperonospora','');
INSERT INTO taxonomy VALUES(31,159316,'Eurychasma','');
INSERT INTO taxonomy VALUES(32,162127,'Basidiophora','');
INSERT INTO taxonomy VALUES(33,162129,'Sclerospora','');
INSERT INTO taxonomy VALUES(34,162131,'Paraperonospora','');
INSERT INTO taxonomy VALUES(35,184462,'Hyaloperonospora','');
INSERT INTO taxonomy VALUES(36,184464,'Perofascia','');
INSERT INTO taxonomy VALUES(37,230838,'Peronosclerospora','');
INSERT INTO taxonomy VALUES(38,244731,'Viennotia','');
INSERT INTO taxonomy VALUES(39,335372,'Protobremia','');
INSERT INTO taxonomy VALUES(40,369777,'Benua','');
INSERT INTO taxonomy VALUES(41,369781,'Plasmoverna','');
INSERT INTO taxonomy VALUES(42,369783,'Graminivora','');
INSERT INTO taxonomy VALUES(43,371951,'Protoachlya','');
INSERT INTO taxonomy VALUES(44,377433,'Haptoglossa','');
INSERT INTO taxonomy VALUES(45,414971,'Halodaphnea','');
INSERT INTO taxonomy VALUES(46,416807,'Olpidiopsis','');
INSERT INTO taxonomy VALUES(47,421926,'Diasporangium','');
INSERT INTO taxonomy VALUES(48,442664,'Myzocytiopsis','');
INSERT INTO taxonomy VALUES(49,461276,'Novotelnova','');
INSERT INTO taxonomy VALUES(50,467175,'Sclerophthora','');
INSERT INTO taxonomy VALUES(51,485443,'Chlamydomyzium','');
INSERT INTO taxonomy VALUES(52,572136,'Wilsoniana','');
INSERT INTO taxonomy VALUES(53,572138,'Pustula','');
INSERT INTO taxonomy VALUES(54,650118,'Halioticida','');
INSERT INTO taxonomy VALUES(55,795339,'Phytopythium','');
INSERT INTO taxonomy VALUES(56,944615,'Pythiogeton','');
INSERT INTO taxonomy VALUES(57,983658,'Salisapilia','');
INSERT INTO taxonomy VALUES(58,1009718,'Eraphthora','');
INSERT INTO taxonomy VALUES(59,1432540,'Geolegnia','');
INSERT INTO taxonomy VALUES(60,1440114,'Paralagenidium','');
INSERT INTO taxonomy VALUES(61,1448050,'Elongisporangium','');
INSERT INTO taxonomy VALUES(62,1448052,'Globisporangium','');
INSERT INTO taxonomy VALUES(63,1448054,'Ovatisporangium','');
INSERT INTO taxonomy VALUES(64,1489788,'Lagena','');
INSERT INTO taxonomy VALUES(65,1495611,'Aquastella','');
INSERT INTO taxonomy VALUES(66,1618012,'Newbya','');
INSERT INTO taxonomy VALUES(67,1635158,'Pilasporangium','');
INSERT INTO taxonomy VALUES(68,1663099,'Anisolpidium','');
INSERT INTO taxonomy VALUES(69,1672053,'Blastulidium','');
INSERT INTO taxonomy VALUES(70,1682048,'Lagenisma','');
INSERT INTO taxonomy VALUES(71,1702222,'Salilagenidium','');
INSERT INTO taxonomy VALUES(72,1729147,'Phragmosporangium','');
INSERT INTO taxonomy VALUES(73,1779447,'Baobabopsis','');
INSERT INTO taxonomy VALUES(74,1862710,'Salispina','');
INSERT INTO taxonomy VALUES(75,2025987,'Nothophytophthora','');
INSERT INTO taxonomy VALUES(76,2050023,'Calycofera','');
INSERT INTO taxonomy VALUES(77,2182427,'Crypticola','');
INSERT INTO taxonomy VALUES(78,2203426,'Miracula','');
INSERT INTO taxonomy VALUES(79,4766,'Achlya','bisexualis');
INSERT INTO taxonomy VALUES(80,4767,'Achlya','klebsiana');
INSERT INTO taxonomy VALUES(81,4768,'Achlya','ambisexualis');
INSERT INTO taxonomy VALUES(82,4770,'Saprolegnia','ferax');
INSERT INTO taxonomy VALUES(83,4779,'Bremia','lactucae');
INSERT INTO taxonomy VALUES(84,4781,'Plasmopara','halstedii');
INSERT INTO taxonomy VALUES(85,4784,'Phytophthora','capsici');
INSERT INTO taxonomy VALUES(86,4785,'Phytophthora','cinnamomi');
INSERT INTO taxonomy VALUES(87,4786,'Phytophthora','cryptogea');
INSERT INTO taxonomy VALUES(88,4787,'Phytophthora','infestans');
INSERT INTO taxonomy VALUES(89,4788,'Phytophthora','megasperma');
INSERT INTO taxonomy VALUES(90,4790,'Phytophthora','nicotianae');
INSERT INTO taxonomy VALUES(91,4792,'Phytophthora','parasitica');
INSERT INTO taxonomy VALUES(92,4793,'Phytophthora','citrophthora');
INSERT INTO taxonomy VALUES(93,4794,'Phytophthora','drechsleri');
INSERT INTO taxonomy VALUES(94,4795,'Phytophthora','megakarya');
INSERT INTO taxonomy VALUES(95,4796,'Phytophthora','palmivora');
INSERT INTO taxonomy VALUES(96,4798,'Pythium','hydnosporum');
INSERT INTO taxonomy VALUES(97,4799,'Pythium','torulosum');
INSERT INTO taxonomy VALUES(98,4803,'Lagenidium','giganteum');
INSERT INTO taxonomy VALUES(99,29920,'Phytophthora','cactorum');
INSERT INTO taxonomy VALUES(100,36331,'Pythium','irregulare');
INSERT INTO taxonomy VALUES(101,37553,'Saprolegnia','monoica');
INSERT INTO taxonomy VALUES(102,41045,'Pythium','oligandrum');
INSERT INTO taxonomy VALUES(103,49446,'Pythium','pachycaule');
INSERT INTO taxonomy VALUES(104,53983,'Phytophthora','cambivora');
INSERT INTO taxonomy VALUES(105,53984,'Phytophthora','citricola');
INSERT INTO taxonomy VALUES(106,53985,'Phytophthora','fragariae');
INSERT INTO taxonomy VALUES(107,53986,'Phytophthora','idaei');
INSERT INTO taxonomy VALUES(108,53987,'Phytophthora','pseudotsugae');
INSERT INTO taxonomy VALUES(109,54510,'Phytophthora','medicaginis');
INSERT INTO taxonomy VALUES(110,54511,'Phytophthora','trifolii');
INSERT INTO taxonomy VALUES(111,65069,'Pythium','acanthicum');
INSERT INTO taxonomy VALUES(112,65070,'Pythium','aphanidermatum');
INSERT INTO taxonomy VALUES(113,65357,'Albugo','candida');
INSERT INTO taxonomy VALUES(114,67591,'Phytophthora','macrochlamydospora');
INSERT INTO taxonomy VALUES(115,67592,'Phytophthora','iranica');
INSERT INTO taxonomy VALUES(116,67593,'Phytophthora','sojae');
INSERT INTO taxonomy VALUES(117,67594,'Phytophthora','syringae');
INSERT INTO taxonomy VALUES(118,67595,'Phytophthora','vignae');
INSERT INTO taxonomy VALUES(119,70743,'Peronospora','sparsa');
INSERT INTO taxonomy VALUES(120,74555,'Achlya','intricata');
INSERT INTO taxonomy VALUES(121,74557,'Thraustotheca','clavata');
INSERT INTO taxonomy VALUES(122,74560,'Dictyuchus','sterilis');
INSERT INTO taxonomy VALUES(123,78236,'Phytophthora','quercina');
INSERT INTO taxonomy VALUES(124,78237,'Phytophthora','gonapodyides');
INSERT INTO taxonomy VALUES(125,82926,'Pythium','splendens');
INSERT INTO taxonomy VALUES(126,82932,'Pythium','arrhenomanes');
INSERT INTO taxonomy VALUES(127,82933,'Phytopythium','chamaehyphon');
INSERT INTO taxonomy VALUES(128,82934,'Pythium','coloratum');
INSERT INTO taxonomy VALUES(129,82935,'Pythium','deliense');
INSERT INTO taxonomy VALUES(130,82936,'Pythium','dissotocum');
INSERT INTO taxonomy VALUES(131,82937,'Pythium','graminicola');
INSERT INTO taxonomy VALUES(132,82938,'Pythium','inflatum');
INSERT INTO taxonomy VALUES(133,82940,'Pythium','middletonii');
INSERT INTO taxonomy VALUES(134,82941,'Pythium','myriotylum');
INSERT INTO taxonomy VALUES(135,82942,'Pythium','nunn');
INSERT INTO taxonomy VALUES(136,82945,'Pythium','periilum');
INSERT INTO taxonomy VALUES(137,82946,'Pythium','periplocum');
INSERT INTO taxonomy VALUES(138,82947,'Pythium','rostratum');
INSERT INTO taxonomy VALUES(139,82949,'Pythium','sulcatum');
INSERT INTO taxonomy VALUES(140,82950,'Pythium','sylvaticum');
INSERT INTO taxonomy VALUES(141,82951,'Pythium','vanterpoolii');
INSERT INTO taxonomy VALUES(142,82952,'Pythium','violae');
INSERT INTO taxonomy VALUES(143,82953,'Pythium','volutum');
INSERT INTO taxonomy VALUES(144,83917,'Pythium','catenulatum');
INSERT INTO taxonomy VALUES(145,86334,'Peronospora','manshurica');
INSERT INTO taxonomy VALUES(146,86335,'Peronospora','destructor');
INSERT INTO taxonomy VALUES(147,88834,'Pythium','porphyrae');
INSERT INTO taxonomy VALUES(148,89334,'Phytophthora','clandestina');
INSERT INTO taxonomy VALUES(149,89335,'Phytophthora','ilicis');
INSERT INTO taxonomy VALUES(150,92964,'Pythium','monospermum');
INSERT INTO taxonomy VALUES(151,92966,'Achlya','apiculata');
INSERT INTO taxonomy VALUES(152,92969,'Pythiopsis','cymosa');
INSERT INTO taxonomy VALUES(153,92972,'Aplanopsis','terrestris');
INSERT INTO taxonomy VALUES(154,92976,'Leptolegnia','caudata');
INSERT INTO taxonomy VALUES(155,92981,'Apodachlya','brachynema');
INSERT INTO taxonomy VALUES(156,92984,'Leptolegnia','chapmanii');
INSERT INTO taxonomy VALUES(157,92985,'Leptolegnia','sp.');
INSERT INTO taxonomy VALUES(158,100861,'Aphanomyces','euteiches');
INSERT INTO taxonomy VALUES(159,100863,'Plectospira','myriandra');
INSERT INTO taxonomy VALUES(160,100864,'Apodachlya','pirifera');
INSERT INTO taxonomy VALUES(161,100866,'Leptomitus','lacteus');
INSERT INTO taxonomy VALUES(162,100870,'Phytophthora','litchii');
INSERT INTO taxonomy VALUES(163,100874,'Sapromyces','elongatus');
INSERT INTO taxonomy VALUES(164,101203,'Saprolegnia','parasitica');
INSERT INTO taxonomy VALUES(165,102135,'Peronospora','cristata');
INSERT INTO taxonomy VALUES(166,102136,'Peronospora','viciae');
INSERT INTO taxonomy VALUES(167,104971,'Pythium','prolatum');
INSERT INTO taxonomy VALUES(168,105151,'Pythium','echinulatum');
INSERT INTO taxonomy VALUES(169,105152,'Pythium','nodosum');
INSERT INTO taxonomy VALUES(170,105153,'Pythium','ornacarpum');
INSERT INTO taxonomy VALUES(171,109152,'Phytophthora','boehmeriae');
INSERT INTO taxonomy VALUES(172,110438,'Pythium','contiguanum');
INSERT INTO taxonomy VALUES(173,111171,'Phytophthora','erythroseptica');
INSERT INTO taxonomy VALUES(174,112026,'Achlya','americana');
INSERT INTO taxonomy VALUES(175,112027,'Achlya','conspicua');
INSERT INTO taxonomy VALUES(176,112028,'Achlya','aquatica');
INSERT INTO taxonomy VALUES(177,112029,'Achlya','crenulata');
INSERT INTO taxonomy VALUES(178,112030,'Achlya','heterosexualis');
INSERT INTO taxonomy VALUES(179,112031,'Achlya','oligacantha');
INSERT INTO taxonomy VALUES(180,112032,'Achlya','proliferoides');
INSERT INTO taxonomy VALUES(181,112078,'Achlya','caroliniana');
INSERT INTO taxonomy VALUES(182,112079,'Achlya','colorata');
INSERT INTO taxonomy VALUES(183,112081,'Achlya','dubia');
INSERT INTO taxonomy VALUES(184,112082,'Achlya','flagellata');
INSERT INTO taxonomy VALUES(185,112083,'Achlya','glomerata');
INSERT INTO taxonomy VALUES(186,112087,'Achlya','racemosa');
INSERT INTO taxonomy VALUES(187,112088,'Achlya','radiosa');
INSERT INTO taxonomy VALUES(188,112089,'Achlya','recurva');
INSERT INTO taxonomy VALUES(189,112090,'Aphanomyces','astaci');
INSERT INTO taxonomy VALUES(190,112091,'Aphanomyces','cochlioides');
INSERT INTO taxonomy VALUES(191,112092,'Aphanomyces','laevis');
INSERT INTO taxonomy VALUES(192,112094,'Brevilegnia','bispora');
INSERT INTO taxonomy VALUES(193,112097,'Pythium','aquatile');
INSERT INTO taxonomy VALUES(194,112098,'Saprolegnia','diclina');
INSERT INTO taxonomy VALUES(195,114742,'Pythium','insidiosum');
INSERT INTO taxonomy VALUES(196,114966,'Pythium','erinaceum');
INSERT INTO taxonomy VALUES(197,115416,'Pythium','heterothallicum');
INSERT INTO taxonomy VALUES(198,115417,'Pythium','iwayamai');
INSERT INTO taxonomy VALUES(199,115418,'Pythium','mamillatum');
INSERT INTO taxonomy VALUES(200,115419,'Pythium','paddicum');
INSERT INTO taxonomy VALUES(201,115420,'Pythium','pulchrum');
INSERT INTO taxonomy VALUES(202,120023,'Phytophthora','melonis');
INSERT INTO taxonomy VALUES(203,120396,'Achlya','papillosa');
INSERT INTO taxonomy VALUES(204,120397,'Achlya','treleaseana');
INSERT INTO taxonomy VALUES(205,120398,'Aphanomyces','stellatus');
INSERT INTO taxonomy VALUES(206,120400,'Aplanes','androgynus');
INSERT INTO taxonomy VALUES(207,120401,'Achlya','ornata');
INSERT INTO taxonomy VALUES(208,120402,'Brevilegnia','megasperma');
INSERT INTO taxonomy VALUES(209,120404,'Calyptralegnia','achlyoides');
INSERT INTO taxonomy VALUES(210,120407,'Dictyuchus','monosporus');
INSERT INTO taxonomy VALUES(211,120411,'Pachymetra','chaunorhiza');
INSERT INTO taxonomy VALUES(212,120412,'Peronospora','ficariae');
INSERT INTO taxonomy VALUES(213,120415,'Saprolegnia','anisospora');
INSERT INTO taxonomy VALUES(214,120416,'Saprolegnia','eccentrica');
INSERT INTO taxonomy VALUES(215,120417,'Saprolegnia','hypogyna');
INSERT INTO taxonomy VALUES(216,120418,'Saprolegnia','litoralis');
INSERT INTO taxonomy VALUES(217,120419,'Saprolegnia','monilifera');
INSERT INTO taxonomy VALUES(218,120420,'Saprolegnia','torulosa');
INSERT INTO taxonomy VALUES(219,120421,'Saprolegnia','unispora');
INSERT INTO taxonomy VALUES(220,120423,'Scoliolegnia','asterophora');
INSERT INTO taxonomy VALUES(221,120571,'Dictyuchus','sp. AR_29');
INSERT INTO taxonomy VALUES(222,120572,'Peronospora','bulbocapni');
INSERT INTO taxonomy VALUES(223,121062,'Pythium','perplexum');
INSERT INTO taxonomy VALUES(224,126844,'Phytopythium','helicoides');
INSERT INTO taxonomy VALUES(225,126845,'Phytopythium','megacarpum');
INSERT INTO taxonomy VALUES(226,126846,'Phytopythium','ostracodes');
INSERT INTO taxonomy VALUES(227,127442,'Phytophthora','insolita');
INSERT INTO taxonomy VALUES(228,127443,'Phytophthora','richardiae');
INSERT INTO taxonomy VALUES(229,127444,'Phytophthora','undulata');
INSERT INTO taxonomy VALUES(230,127446,'Halophytophthora','batemanensis');
INSERT INTO taxonomy VALUES(231,129347,'Phytophthora','arecae');
INSERT INTO taxonomy VALUES(232,129348,'Phytophthora','botryosa');
INSERT INTO taxonomy VALUES(233,129349,'Phytophthora','cajani');
INSERT INTO taxonomy VALUES(234,129350,'Phytophthora','colocasiae');
INSERT INTO taxonomy VALUES(235,129351,'Phytophthora','heveae');
INSERT INTO taxonomy VALUES(236,129352,'Phytophthora','humicola');
INSERT INTO taxonomy VALUES(237,129353,'Phytophthora','inflata');
INSERT INTO taxonomy VALUES(238,129354,'Phytophthora','katsurae');
INSERT INTO taxonomy VALUES(239,129355,'Phytophthora','lateralis');
INSERT INTO taxonomy VALUES(240,129356,'Phytophthora','mirabilis');
INSERT INTO taxonomy VALUES(241,129357,'Phytophthora','multivesiculata');
INSERT INTO taxonomy VALUES(242,129358,'Phytophthora','phaseoli');
INSERT INTO taxonomy VALUES(243,129359,'Phytophthora','porri');
INSERT INTO taxonomy VALUES(244,129360,'Phytophthora','primulae');
INSERT INTO taxonomy VALUES(245,129361,'Phytophthora','sinensis');
INSERT INTO taxonomy VALUES(246,129362,'Phytophthora','tentaculata');
INSERT INTO taxonomy VALUES(247,129364,'Phytophthora','rubi');
INSERT INTO taxonomy VALUES(248,132615,'Phytophthora','glovera');
INSERT INTO taxonomy VALUES(249,134455,'Phytophthora','quininea');
INSERT INTO taxonomy VALUES(250,134457,'Phytophthora','cf. cryptogea/drechsleri');
INSERT INTO taxonomy VALUES(251,134686,'Apodachlya','minima');
INSERT INTO taxonomy VALUES(252,134689,'Isoachlya','toruloides');
INSERT INTO taxonomy VALUES(253,134690,'Salilagenidium','chthamalophilum');
INSERT INTO taxonomy VALUES(254,134698,'Peronospora','farinosa');
INSERT INTO taxonomy VALUES(255,135473,'Haliphthoros','milfordensis');
INSERT INTO taxonomy VALUES(256,135474,'Haliphthoros','philippinensis');
INSERT INTO taxonomy VALUES(257,135477,'Atkinsiella','dubia');
INSERT INTO taxonomy VALUES(258,135479,'Halocrusticida','okinawaensis');
INSERT INTO taxonomy VALUES(259,135480,'Salilagenidium','callinectes');
INSERT INTO taxonomy VALUES(260,135481,'Lagenidium','caudatum');
INSERT INTO taxonomy VALUES(261,135482,'Lagenidium','humanum');
INSERT INTO taxonomy VALUES(262,135483,'Pythium','myophilum');
INSERT INTO taxonomy VALUES(263,135484,'Salilagenidium','thermophilum');
INSERT INTO taxonomy VALUES(264,135850,'Dictyuchus','sp. Petersen-4.2');
INSERT INTO taxonomy VALUES(265,135851,'Dictyuchus','sp. Petersen-5.6');
INSERT INTO taxonomy VALUES(266,135852,'Leptolegnia','sp. Soerensen-1.6');
INSERT INTO taxonomy VALUES(267,135853,'Leptolegnia','sp. Soerensen-3.1');
INSERT INTO taxonomy VALUES(268,135856,'Aphanomyces','piscicida');
INSERT INTO taxonomy VALUES(269,137729,'Phytophthora','tropicalis');
INSERT INTO taxonomy VALUES(270,140044,'Pythium','aristosporum');
INSERT INTO taxonomy VALUES(271,140045,'Pythium','butleri');
INSERT INTO taxonomy VALUES(272,140046,'Pythium','polymastum');
INSERT INTO taxonomy VALUES(273,140047,'Pythium','salpingophorum');
INSERT INTO taxonomy VALUES(274,140048,'Pythium','tracheiphilum');
INSERT INTO taxonomy VALUES(275,141266,'Pythium','dimorphum');
INSERT INTO taxonomy VALUES(276,143451,'Plasmopara','viticola');
INSERT INTO taxonomy VALUES(277,143453,'Pseudoperonospora','cubensis');
INSERT INTO taxonomy VALUES(278,147702,'Pythium','buismaniae');
INSERT INTO taxonomy VALUES(279,147703,'Pythium','jasmonium');
INSERT INTO taxonomy VALUES(280,147704,'Pythium','mastophorum');
INSERT INTO taxonomy VALUES(281,147705,'Pythium','megalacanthum');
INSERT INTO taxonomy VALUES(282,147706,'Pythium','uncinulatum');
INSERT INTO taxonomy VALUES(283,156628,'Pythium','diclinum');
INSERT INTO taxonomy VALUES(284,156629,'Pythium','pectinolyticum');
INSERT INTO taxonomy VALUES(285,157072,'Aphanomyces','invadans');
INSERT INTO taxonomy VALUES(286,159317,'Eurychasma','dicksonii');
INSERT INTO taxonomy VALUES(287,162088,'Pythium','aff. vanterpoolii');
INSERT INTO taxonomy VALUES(288,162094,'Peronospora','hiemalis');
INSERT INTO taxonomy VALUES(289,162095,'Peronospora','pulveracea');
INSERT INTO taxonomy VALUES(290,162096,'Peronospora','trivialis');
INSERT INTO taxonomy VALUES(291,162097,'Peronospora','alsinearum');
INSERT INTO taxonomy VALUES(292,162098,'Peronospora','myosotidis');
INSERT INTO taxonomy VALUES(293,162099,'Peronospora','coronillae');
INSERT INTO taxonomy VALUES(294,162100,'Peronospora','boni-henrici');
INSERT INTO taxonomy VALUES(295,162101,'Peronospora','rumicis');
INSERT INTO taxonomy VALUES(296,162102,'Peronospora','variabilis');
INSERT INTO taxonomy VALUES(297,162103,'Peronospora','trifoliorum');
INSERT INTO taxonomy VALUES(298,162104,'Peronospora','trifolii-minoris');
INSERT INTO taxonomy VALUES(299,162105,'Peronospora','trifolii-hybridi');
INSERT INTO taxonomy VALUES(300,162106,'Peronospora','trifolii-alpestris');
INSERT INTO taxonomy VALUES(301,162107,'Peronospora','aestivalis');
INSERT INTO taxonomy VALUES(302,162108,'Peronospora','calotheca');
INSERT INTO taxonomy VALUES(303,162109,'Peronospora','aparines');
INSERT INTO taxonomy VALUES(304,162110,'Peronospora','violacea');
INSERT INTO taxonomy VALUES(305,162111,'Peronospora','potentillae-sterilis');
INSERT INTO taxonomy VALUES(306,162112,'Peronospora','sanguisorbae');
INSERT INTO taxonomy VALUES(307,162113,'Peronospora','conglomerata');
INSERT INTO taxonomy VALUES(308,162114,'Peronospora','silvestris');
INSERT INTO taxonomy VALUES(309,162115,'Peronospora','arvensis');
INSERT INTO taxonomy VALUES(310,162116,'Peronospora','grisea');
INSERT INTO taxonomy VALUES(311,162117,'Peronospora','alta');
INSERT INTO taxonomy VALUES(312,162118,'Peronospora','lamii');
INSERT INTO taxonomy VALUES(313,162119,'Pseudoperonospora','urticae');
INSERT INTO taxonomy VALUES(314,162120,'Pseudoperonospora','humuli');
INSERT INTO taxonomy VALUES(315,162122,'Hyaloperonospora','barbareae');
INSERT INTO taxonomy VALUES(316,162123,'Hyaloperonospora','dentariae');
INSERT INTO taxonomy VALUES(317,162124,'Hyaloperonospora','thlaspeos-arvensis');
INSERT INTO taxonomy VALUES(318,162125,'Hyaloperonospora','brassicae');
INSERT INTO taxonomy VALUES(319,162128,'Basidiophora','entospora');
INSERT INTO taxonomy VALUES(320,162130,'Sclerospora','graminicola');
INSERT INTO taxonomy VALUES(321,162132,'Paraperonospora','leptosperma');
INSERT INTO taxonomy VALUES(322,162136,'Plasmopara','sii');
INSERT INTO taxonomy VALUES(323,162137,'Plasmopara','pimpinellae');
INSERT INTO taxonomy VALUES(324,162138,'Plasmopara','geranii');
INSERT INTO taxonomy VALUES(325,162139,'Plasmopara','pusilla');
INSERT INTO taxonomy VALUES(326,162140,'Plasmopara','obducens');
INSERT INTO taxonomy VALUES(327,162141,'Plasmopara','densa');
INSERT INTO taxonomy VALUES(328,162142,'Plasmoverna','isopyrithalictroides');
INSERT INTO taxonomy VALUES(329,164328,'Phytophthora','ramorum');
INSERT INTO taxonomy VALUES(330,166937,'Pythium','longandrum');
INSERT INTO taxonomy VALUES(331,166938,'Pythium','terrestris');
INSERT INTO taxonomy VALUES(332,170619,'Aphanomyces','helicoides');
INSERT INTO taxonomy VALUES(333,170620,'Leptolegnia','sp. CBS 177.86');
INSERT INTO taxonomy VALUES(334,172234,'Pythium','grandisporangium');
INSERT INTO taxonomy VALUES(335,173901,'Pythium','proliferatum');
INSERT INTO taxonomy VALUES(336,174576,'Phytophthora','pistaciae');
INSERT INTO taxonomy VALUES(337,175300,'Phytophthora','hibernalis');
INSERT INTO taxonomy VALUES(338,180900,'Phytophthora','europaea');
INSERT INTO taxonomy VALUES(339,180901,'Phytophthora','psychrophila');
INSERT INTO taxonomy VALUES(340,180902,'Phytophthora','uliginosa');
INSERT INTO taxonomy VALUES(341,181666,'Pythium','macrosporum');
INSERT INTO taxonomy VALUES(342,182683,'Pythium','okanoganense');
INSERT INTO taxonomy VALUES(343,182783,'Pythium','canariense');
INSERT INTO taxonomy VALUES(344,184463,'Hyaloperonospora','niessleana');
INSERT INTO taxonomy VALUES(345,184465,'Perofascia','lepidii');
INSERT INTO taxonomy VALUES(346,184466,'Peronospora','arborescens');
INSERT INTO taxonomy VALUES(347,186163,'Pythium','cylindrosporum');
INSERT INTO taxonomy VALUES(348,187813,'Phytophthora','brassicae');
INSERT INTO taxonomy VALUES(349,187986,'Phytophthora','bisheria');
INSERT INTO taxonomy VALUES(350,189821,'Pythium','bifurcatum');
INSERT INTO taxonomy VALUES(351,190219,'Pythium','abappressorium');
INSERT INTO taxonomy VALUES(352,192020,'Pythium','carolinianum');
INSERT INTO taxonomy VALUES(353,192975,'Phytophthora','meadii');
INSERT INTO taxonomy VALUES(354,196599,'Pythium','regulare');
INSERT INTO taxonomy VALUES(355,198420,'Phytophthora','kelmania');
INSERT INTO taxonomy VALUES(356,209243,'Pythium','segnitium');
INSERT INTO taxonomy VALUES(357,210167,'Peronospora','corydalis');
INSERT INTO taxonomy VALUES(358,214887,'Phytopythium','montanum');
INSERT INTO taxonomy VALUES(359,216130,'Pythium','destruens');
INSERT INTO taxonomy VALUES(360,220750,'Phytopythium','carbonicum');
INSERT INTO taxonomy VALUES(361,221518,'Phytophthora','pseudosyringae');
INSERT INTO taxonomy VALUES(362,221743,'Phytopythium','citrinum');
INSERT INTO taxonomy VALUES(363,222716,'Plasmopara','angustiterminalis');
INSERT INTO taxonomy VALUES(364,222890,'Pythium','rhizosaccharum');
INSERT INTO taxonomy VALUES(365,226325,'Albugo','occidentalis');
INSERT INTO taxonomy VALUES(366,227376,'Saprolegnia','multispora');
INSERT INTO taxonomy VALUES(367,228342,'Pythium','campanulatum');
INSERT INTO taxonomy VALUES(368,228749,'Pythium','glomeratum');
INSERT INTO taxonomy VALUES(369,228916,'Saprolegnia','bulbosa');
INSERT INTO taxonomy VALUES(370,230109,'Saprolegnia','oliviae');
INSERT INTO taxonomy VALUES(371,230111,'Saprolegnia','longicaulis');
INSERT INTO taxonomy VALUES(372,230362,'Peronospora','romanica');
INSERT INTO taxonomy VALUES(373,230363,'Peronospora','meliloti');
INSERT INTO taxonomy VALUES(374,230364,'Peronospora','mayorii');
INSERT INTO taxonomy VALUES(375,230365,'Peronospora','ervi');
INSERT INTO taxonomy VALUES(376,230368,'Peronospora','trifolii-repentis');
INSERT INTO taxonomy VALUES(377,230369,'Peronospora','potentillae');
INSERT INTO taxonomy VALUES(378,230370,'Peronospora','aff. potentillae');
INSERT INTO taxonomy VALUES(379,230371,'Peronospora','violae');
INSERT INTO taxonomy VALUES(380,230372,'Peronospora','agrestis');
INSERT INTO taxonomy VALUES(381,230373,'Peronospora','flava');
INSERT INTO taxonomy VALUES(382,230374,'Peronospora','sordida');
INSERT INTO taxonomy VALUES(383,230375,'Hyaloperonospora','nesliae');
INSERT INTO taxonomy VALUES(384,230378,'Hyaloperonospora','arabidis-alpinae');
INSERT INTO taxonomy VALUES(385,230379,'Peronospora','astragalina');
INSERT INTO taxonomy VALUES(386,230421,'Peronospora','asperuginis');
INSERT INTO taxonomy VALUES(387,230422,'Peronospora','lotorum');
INSERT INTO taxonomy VALUES(388,230423,'Peronospora','ranunculi');
INSERT INTO taxonomy VALUES(389,230424,'Peronospora','illyrica');
INSERT INTO taxonomy VALUES(390,230425,'Peronospora','aff. ranunculi');
INSERT INTO taxonomy VALUES(391,230426,'Peronospora','alpicola');
INSERT INTO taxonomy VALUES(392,230427,'Peronospora','dicentrae');
INSERT INTO taxonomy VALUES(393,230428,'Peronospora','chrysosplenii');
INSERT INTO taxonomy VALUES(394,230429,'Peronospora','esulae');
INSERT INTO taxonomy VALUES(395,230430,'Peronospora','paula');
INSERT INTO taxonomy VALUES(396,230431,'Peronospora','parva');
INSERT INTO taxonomy VALUES(397,230432,'Peronospora','arenariae');
INSERT INTO taxonomy VALUES(398,230433,'Peronospora','claytoniae');
INSERT INTO taxonomy VALUES(399,230434,'Peronospora','polygoni');
INSERT INTO taxonomy VALUES(400,230435,'Peronospora','holostei');
INSERT INTO taxonomy VALUES(401,230436,'Peronospora','arthurii');
INSERT INTO taxonomy VALUES(402,230438,'Peronospora','obovata');
INSERT INTO taxonomy VALUES(403,230439,'Peronospora','tabacina');
INSERT INTO taxonomy VALUES(404,230440,'Peronospora','kochiae-scopariae');
INSERT INTO taxonomy VALUES(405,230441,'Peronospora','chenopodii-polyspermi');
INSERT INTO taxonomy VALUES(406,230442,'Peronospora','valerianellae');
INSERT INTO taxonomy VALUES(407,230443,'Peronospora','tranzscheliana');
INSERT INTO taxonomy VALUES(408,230444,'Peronospora','stigmaticola');
INSERT INTO taxonomy VALUES(409,230445,'Peronospora','radii');
INSERT INTO taxonomy VALUES(410,230446,'Peronospora','silvatica');
INSERT INTO taxonomy VALUES(411,230447,'Peronospora','sherardiae');
INSERT INTO taxonomy VALUES(412,230448,'Peronospora','knautiae');
INSERT INTO taxonomy VALUES(413,230449,'Peronospora','alchemillae');
INSERT INTO taxonomy VALUES(414,230450,'Hyaloperonospora','camelinae');
INSERT INTO taxonomy VALUES(415,230451,'Hyaloperonospora','lunariae');
INSERT INTO taxonomy VALUES(416,230452,'Hyaloperonospora','tribulina');
INSERT INTO taxonomy VALUES(417,230839,'Peronosclerospora','sorghi');
INSERT INTO taxonomy VALUES(418,231958,'Pythium','debaryanum');
INSERT INTO taxonomy VALUES(419,235575,'Plasmopara','wildemaniana');
INSERT INTO taxonomy VALUES(420,235576,'Plasmopara','solidaginis');
INSERT INTO taxonomy VALUES(421,235577,'Plasmopara','baudysii');
INSERT INTO taxonomy VALUES(422,235579,'Plasmopara','angelicae');
INSERT INTO taxonomy VALUES(423,235580,'Plasmopara','peucedani');
INSERT INTO taxonomy VALUES(424,235581,'Plasmopara','pastinacae');
INSERT INTO taxonomy VALUES(425,235582,'Plasmopara','mei-foeniculi');
INSERT INTO taxonomy VALUES(426,235584,'Plasmopara','chaerophylli');
INSERT INTO taxonomy VALUES(427,235585,'Plasmopara','epilobii');
INSERT INTO taxonomy VALUES(428,235586,'Plasmopara','skvortzovii');
INSERT INTO taxonomy VALUES(429,239968,'Phytophthora','nemorosa');
INSERT INTO taxonomy VALUES(430,240413,'Hyaloperonospora','aff. dentariae MG 18-6');
INSERT INTO taxonomy VALUES(431,240414,'Peronospora','aquatica');
INSERT INTO taxonomy VALUES(432,240415,'Hyaloperonospora','erophilae');
INSERT INTO taxonomy VALUES(433,240417,'Hyaloperonospora','thlaspeos-perfoliati');
INSERT INTO taxonomy VALUES(434,240418,'Peronospora','verna');
INSERT INTO taxonomy VALUES(435,240424,'Plasmopara','megasperma');
INSERT INTO taxonomy VALUES(436,240425,'Hyaloperonospora','aff. dentariae MG 5-8');
INSERT INTO taxonomy VALUES(437,241406,'Pythium','attrantheridium');
INSERT INTO taxonomy VALUES(438,244122,'Phytophthora','inundata');
INSERT INTO taxonomy VALUES(439,244167,'Phytophthora','rosacearum');
INSERT INTO taxonomy VALUES(440,244732,'Viennotia','oplismeni');
INSERT INTO taxonomy VALUES(441,253176,'Aphanomyces','cladogamus');
INSERT INTO taxonomy VALUES(442,255163,'Pythium','hypogynum');
INSERT INTO taxonomy VALUES(443,255165,'Pythium','longisporangium');
INSERT INTO taxonomy VALUES(444,255166,'Pythium','viniferum');
INSERT INTO taxonomy VALUES(445,266018,'Phytophthora','niederhauserii');
INSERT INTO taxonomy VALUES(446,272952,'Hyaloperonospora','arabidopsidis');
INSERT INTO taxonomy VALUES(447,272953,'Hyaloperonospora','berteroae');
INSERT INTO taxonomy VALUES(448,272956,'Hyaloperonospora','cardaminopsidis');
INSERT INTO taxonomy VALUES(449,272957,'Hyaloperonospora','cheiranthi');
INSERT INTO taxonomy VALUES(450,272958,'Hyaloperonospora','cochleariae');
INSERT INTO taxonomy VALUES(451,272962,'Hyaloperonospora','galligena');
INSERT INTO taxonomy VALUES(452,272963,'Hyaloperonospora','hesperidis');
INSERT INTO taxonomy VALUES(453,272965,'Hyaloperonospora','isatidis');
INSERT INTO taxonomy VALUES(454,272967,'Hyaloperonospora','nasturtii-aquatici');
INSERT INTO taxonomy VALUES(455,272970,'Hyaloperonospora','sisymbrii-loeselii');
INSERT INTO taxonomy VALUES(456,272973,'Hyaloperonospora','teesdaliae');
INSERT INTO taxonomy VALUES(457,278112,'Haliphthoros','sp. NJM 0034');
INSERT INTO taxonomy VALUES(458,281399,'Aphanomyces','frigidophilus');
INSERT INTO taxonomy VALUES(459,281400,'Saprolegnia','salmonis');
INSERT INTO taxonomy VALUES(460,281401,'Saprolegnia','semihypogyna');
INSERT INTO taxonomy VALUES(461,281402,'Saprolegnia','australis');
INSERT INTO taxonomy VALUES(462,281403,'Achlya','prolifera');
INSERT INTO taxonomy VALUES(463,283007,'Phytophthora','ipomoeae');
INSERT INTO taxonomy VALUES(464,283009,'Phytophthora','andina');
INSERT INTO taxonomy VALUES(465,283010,'Phytophthora','hybrid Dutch variant');
INSERT INTO taxonomy VALUES(466,285430,'Dictyuchus','sp. BP-S2');
INSERT INTO taxonomy VALUES(467,286561,'Achlya','spiralis');
INSERT INTO taxonomy VALUES(468,289317,'Aphanomyces','repetans');
INSERT INTO taxonomy VALUES(469,289596,'Pythium','adhaerens');
INSERT INTO taxonomy VALUES(470,289597,'Pythium','chondricola');
INSERT INTO taxonomy VALUES(471,289598,'Pythium','angustatum');
INSERT INTO taxonomy VALUES(472,289599,'Pythium','conidiophorum');
INSERT INTO taxonomy VALUES(473,289600,'Pythium','apleroticum');
INSERT INTO taxonomy VALUES(474,289601,'Pythium','capillosum');
INSERT INTO taxonomy VALUES(475,289602,'Pythium','pyrilobum');
INSERT INTO taxonomy VALUES(476,289603,'Pythium','acrogynum');
INSERT INTO taxonomy VALUES(477,289604,'Pythium','multisporum');
INSERT INTO taxonomy VALUES(478,289605,'Pythium','pleroticum');
INSERT INTO taxonomy VALUES(479,289606,'Pythium','anandrum');
INSERT INTO taxonomy VALUES(480,289607,'Pythium','helicandrum');
INSERT INTO taxonomy VALUES(481,289609,'Pythium','cucurbitacearum');
INSERT INTO taxonomy VALUES(482,289610,'Halophytophthora','avicenniae');
INSERT INTO taxonomy VALUES(483,289612,'Pythium','amasculinum');
INSERT INTO taxonomy VALUES(484,289613,'Pythium','folliculosum');
INSERT INTO taxonomy VALUES(485,289614,'Pythium','zingiberis');
INSERT INTO taxonomy VALUES(486,289615,'Pythium','scleroteichum');
INSERT INTO taxonomy VALUES(487,289616,'Pythium','dissimile');
INSERT INTO taxonomy VALUES(488,289617,'Pythium','plurisporium');
INSERT INTO taxonomy VALUES(489,289618,'Pythium','lutarium');
INSERT INTO taxonomy VALUES(490,289619,'Pythium','marinum');
INSERT INTO taxonomy VALUES(491,289620,'Pythium','flevoense');
INSERT INTO taxonomy VALUES(492,289621,'Pythium','radiosum');
INSERT INTO taxonomy VALUES(493,289622,'Pythium','parvum');
INSERT INTO taxonomy VALUES(494,289623,'Globisporangium','marsipium');
INSERT INTO taxonomy VALUES(495,289624,'Pythium','kunmingense');
INSERT INTO taxonomy VALUES(496,289625,'Pythium','nagaii');
INSERT INTO taxonomy VALUES(497,289626,'Pythium','indigoferae');
INSERT INTO taxonomy VALUES(498,290088,'Pythium','minus');
INSERT INTO taxonomy VALUES(499,291619,'Peronospora','campestris');
INSERT INTO taxonomy VALUES(500,291620,'Peronospora','trigonotidis');
INSERT INTO taxonomy VALUES(501,291622,'Pseudoperonospora','cannabina');
INSERT INTO taxonomy VALUES(502,291623,'Pseudoperonospora','celtidis');
INSERT INTO taxonomy VALUES(503,295094,'Albugo','ipomoeae-panduratae');
INSERT INTO taxonomy VALUES(504,295481,'Phytophthora','hedraiandra');
INSERT INTO taxonomy VALUES(505,295491,'Pythium','cystogenes');
INSERT INTO taxonomy VALUES(506,295492,'Pythium','rostratifingens');
INSERT INTO taxonomy VALUES(507,299391,'Phytophthora','alni');
INSERT INTO taxonomy VALUES(508,299392,'Phytophthora','x alni');
INSERT INTO taxonomy VALUES(509,299393,'Phytophthora','uniformis');
INSERT INTO taxonomy VALUES(510,299394,'Phytophthora','x multiformis');
INSERT INTO taxonomy VALUES(511,299625,'Pythium','rhizo-oryzae');
INSERT INTO taxonomy VALUES(512,309403,'Brevilegnia','macrospora');
INSERT INTO taxonomy VALUES(513,319040,'Pythium','phragmitis');
INSERT INTO taxonomy VALUES(514,323840,'Albugo','chardoni');
INSERT INTO taxonomy VALUES(515,323849,'Albugo','trianthemae');
INSERT INTO taxonomy VALUES(516,324745,'Phytophthora','medicaginis x cryptogea');
INSERT INTO taxonomy VALUES(517,325452,'Phytophthora','kernoviae');
INSERT INTO taxonomy VALUES(518,327753,'Saprolegnia','megasperma');
INSERT INTO taxonomy VALUES(519,330677,'Albugo','evolvuli');
INSERT INTO taxonomy VALUES(520,330678,'Albugo','caryophyllacearum');
INSERT INTO taxonomy VALUES(521,330679,'Albugo','gomphrenae');
INSERT INTO taxonomy VALUES(522,330680,'Wilsoniana','amaranthi');
INSERT INTO taxonomy VALUES(523,334524,'Saprolegnia','subterranea');
INSERT INTO taxonomy VALUES(524,334525,'Saprolegnia','furcata');
INSERT INTO taxonomy VALUES(525,334526,'Saprolegnia','mixta');
INSERT INTO taxonomy VALUES(526,334527,'Saprolegnia','polymorpha');
INSERT INTO taxonomy VALUES(527,334528,'Saprolegnia','terrestris');
INSERT INTO taxonomy VALUES(528,334529,'Saprolegnia','turfosa');
INSERT INTO taxonomy VALUES(529,334530,'Pythiopsis','humphreyana');
INSERT INTO taxonomy VALUES(530,334531,'Pythiopsis','terrestris');
INSERT INTO taxonomy VALUES(531,335373,'Protobremia','sphaerosperma');
INSERT INTO taxonomy VALUES(532,337960,'Peronospora','narbonensis');
INSERT INTO taxonomy VALUES(533,337961,'Peronospora','sepium');
INSERT INTO taxonomy VALUES(534,338422,'Plasmopara','geranii-sylvatici');
INSERT INTO taxonomy VALUES(535,340183,'Phytopythium','litorale');
INSERT INTO taxonomy VALUES(536,343460,'Plasmopara','wilsonii');
INSERT INTO taxonomy VALUES(537,343461,'Plasmopara','praetermissa');
INSERT INTO taxonomy VALUES(538,349325,'Pythium','apiculatum');
INSERT INTO taxonomy VALUES(539,358102,'Phytophthora','sansomea');
INSERT INTO taxonomy VALUES(540,359324,'Phytophthora','gallica');
INSERT INTO taxonomy VALUES(541,360399,'Phytophthora','fallax');
INSERT INTO taxonomy VALUES(542,360400,'Phytophthora','captiosa');
INSERT INTO taxonomy VALUES(543,362222,'Saprolegnia','anomalies');
INSERT INTO taxonomy VALUES(544,364101,'Achlya','oblongata');
INSERT INTO taxonomy VALUES(545,369778,'Benua','kellermanii');
INSERT INTO taxonomy VALUES(546,369779,'Plasmopara','nivea');
INSERT INTO taxonomy VALUES(547,369782,'Plasmoverna','pygmaea');
INSERT INTO taxonomy VALUES(548,369784,'Graminivora','graminicola');
INSERT INTO taxonomy VALUES(549,369823,'Pythium','sterilum');
INSERT INTO taxonomy VALUES(550,370328,'Saprolegnia','cf. ferax');
INSERT INTO taxonomy VALUES(551,370329,'Leptolegnia','sp. SAP248');
INSERT INTO taxonomy VALUES(552,371029,'Plasmoverna','anemones-ranunculoides');
INSERT INTO taxonomy VALUES(553,371952,'Protoachlya','paradoxa');
INSERT INTO taxonomy VALUES(554,371956,'Protoachlya','polysporus');
INSERT INTO taxonomy VALUES(555,373630,'Pythium','spiculum');
INSERT INTO taxonomy VALUES(556,374175,'Phytophthora','polonica');
INSERT INTO taxonomy VALUES(557,376151,'Phytophthora','cactorum x hedraiandra');
INSERT INTO taxonomy VALUES(558,376158,'Phytophthora','nicotianae x cactorum');
INSERT INTO taxonomy VALUES(559,377434,'Haptoglossa','heterospora');
INSERT INTO taxonomy VALUES(560,377435,'Haptoglossa','sp. TK01');
INSERT INTO taxonomy VALUES(561,377436,'Haptoglossa','sp. NI01');
INSERT INTO taxonomy VALUES(562,377437,'Haptoglossa','sp. SZ01');
INSERT INTO taxonomy VALUES(563,410723,'Pythium','quercum');
INSERT INTO taxonomy VALUES(564,413847,'Haliphthoros','sp. NJM 0443');
INSERT INTO taxonomy VALUES(565,413848,'Haliphthoros','sp. NJM 0440');
INSERT INTO taxonomy VALUES(566,413849,'Halodaphnea','panulirata');
INSERT INTO taxonomy VALUES(567,413850,'Halocrusticida','parasitica');
INSERT INTO taxonomy VALUES(568,413851,'Halocrusticida','baliensis');
INSERT INTO taxonomy VALUES(569,414967,'Haliphthoros','sp. NJM 0143');
INSERT INTO taxonomy VALUES(570,414968,'Haliphthoros','sp. NJM 0449');
INSERT INTO taxonomy VALUES(571,414969,'Haliphthoros','sp. NJM 0535');
INSERT INTO taxonomy VALUES(572,415976,'Phytophthora','foliorum');
INSERT INTO taxonomy VALUES(573,416808,'Olpidiopsis','porphyrae');
INSERT INTO taxonomy VALUES(574,421928,'Diasporangium','sp. CCD-2007');
INSERT INTO taxonomy VALUES(575,429562,'Pythium','guiyangense');
INSERT INTO taxonomy VALUES(576,434349,'Peronospora','fulva');
INSERT INTO taxonomy VALUES(577,434350,'Peronospora','medicaginis-minimae');
INSERT INTO taxonomy VALUES(578,434351,'Peronospora','lathyri-verni');
INSERT INTO taxonomy VALUES(579,434352,'Peronospora','lathyrina');
INSERT INTO taxonomy VALUES(580,434353,'Peronospora','tetragonolobi');
INSERT INTO taxonomy VALUES(581,434355,'Peronospora','medicaginis-orbicularis');
INSERT INTO taxonomy VALUES(582,434356,'Peronospora','ornithopi');
INSERT INTO taxonomy VALUES(583,434360,'Peronospora','trifolii-arvensis');
INSERT INTO taxonomy VALUES(584,434361,'Peronospora','orobi');
INSERT INTO taxonomy VALUES(585,436079,'Phytophthora','siskiyouensis');
INSERT INTO taxonomy VALUES(586,436701,'Plasmopara','penniseti');
INSERT INTO taxonomy VALUES(587,438833,'Plasmopara','constantinescui');
INSERT INTO taxonomy VALUES(588,442665,'Myzocytiopsis','glutinospora');
INSERT INTO taxonomy VALUES(589,445396,'Phytophthora','cuyabensis');
INSERT INTO taxonomy VALUES(590,445398,'Phytophthora','sulawesiensis');
INSERT INTO taxonomy VALUES(591,453155,'Hyaloperonospora','parasitica species group');
INSERT INTO taxonomy VALUES(592,459882,'Phytophthora','mexicana');
INSERT INTO taxonomy VALUES(593,459883,'Phytophthora','quercetorum');
INSERT INTO taxonomy VALUES(594,461275,'Bremia','centaureae');
INSERT INTO taxonomy VALUES(595,461277,'Novotelnova','scorzonerae');
INSERT INTO taxonomy VALUES(596,461278,'Paraperonospora','tanaceti');
INSERT INTO taxonomy VALUES(597,461279,'Plasmopara','euphrasiae');
INSERT INTO taxonomy VALUES(598,463007,'Leptolegnia','sp. PSCR0503');
INSERT INTO taxonomy VALUES(599,467161,'Peronosclerospora','sacchari');
INSERT INTO taxonomy VALUES(600,467162,'Peronosclerospora','heteropogonis');
INSERT INTO taxonomy VALUES(601,467163,'Peronosclerospora','noblei');
INSERT INTO taxonomy VALUES(602,467166,'Peronosclerospora','sp. BRIP 46698A');
INSERT INTO taxonomy VALUES(603,467176,'Sclerophthora','macrospora');
INSERT INTO taxonomy VALUES(604,468623,'Albugo','lepidii');
INSERT INTO taxonomy VALUES(605,468624,'Albugo','capparis');
INSERT INTO taxonomy VALUES(606,468625,'Albugo','sp. SMK13752');
INSERT INTO taxonomy VALUES(607,468626,'Albugo','sp. SMK15670');
INSERT INTO taxonomy VALUES(608,475204,'Pythium','aff. phragmitis');
INSERT INTO taxonomy VALUES(609,476099,'Olpidiopsis','sp. 4439');
INSERT INTO taxonomy VALUES(610,481581,'Achlya','stellata');
INSERT INTO taxonomy VALUES(611,482632,'Leptolegnia','sp. K08');
INSERT INTO taxonomy VALUES(612,485441,'Myzocytiopsis','intermedia');
INSERT INTO taxonomy VALUES(613,485442,'Myzocytiopsis','vermicola');
INSERT INTO taxonomy VALUES(614,485444,'Chlamydomyzium','sp. SL02');
INSERT INTO taxonomy VALUES(615,485445,'Haptoglossa','sp. IMI#395179');
INSERT INTO taxonomy VALUES(616,485446,'Myzocytiopsis','sp. venatrix');
INSERT INTO taxonomy VALUES(617,490914,'Pythium','ornamentatum');
INSERT INTO taxonomy VALUES(618,496858,'Albugo','sp. BPI877752');
INSERT INTO taxonomy VALUES(619,496859,'Albugo','sp. BPI877753');
INSERT INTO taxonomy VALUES(620,496860,'Albugo','sp. BPI877754');
INSERT INTO taxonomy VALUES(621,496861,'Albugo','sp. SAU80');
INSERT INTO taxonomy VALUES(622,502111,'Bremia','microspora');
INSERT INTO taxonomy VALUES(623,502112,'Bremia','ovata');
INSERT INTO taxonomy VALUES(624,502113,'Bremia','saussureae');
INSERT INTO taxonomy VALUES(625,502114,'Bremia','sonchicola');
INSERT INTO taxonomy VALUES(626,502252,'Paraperonospora','minor');
INSERT INTO taxonomy VALUES(627,505981,'Haptoglossa','zoospora');
INSERT INTO taxonomy VALUES(628,505982,'Haptoglossa','sp. KG01');
INSERT INTO taxonomy VALUES(629,505983,'Haptoglossa','sp. KG02');
INSERT INTO taxonomy VALUES(630,505984,'Haptoglossa','sp. SZ03');
INSERT INTO taxonomy VALUES(631,507576,'Peronospora','perillae');
INSERT INTO taxonomy VALUES(632,515321,'Protoachlya','sp. Argentina 3.1');
INSERT INTO taxonomy VALUES(633,515322,'Thraustotheca','sp. Argentina 3.8');
INSERT INTO taxonomy VALUES(634,529119,'Pythium','cryptoirregulare');
INSERT INTO taxonomy VALUES(635,538568,'Phytophthora','pinifolia');
INSERT INTO taxonomy VALUES(636,540036,'Phytophthora','parvispora');
INSERT INTO taxonomy VALUES(637,542832,'Peronospora','effusa');
INSERT INTO taxonomy VALUES(638,544909,'Phytophthora','parsiana');
INSERT INTO taxonomy VALUES(639,546104,'Phytopythium','mercuriale');
INSERT INTO taxonomy VALUES(640,555429,'Phytophthora','sansomeana');
INSERT INTO taxonomy VALUES(641,558704,'Achlya','primoachlya');
INSERT INTO taxonomy VALUES(642,562958,'Plasmopara','siegesbeckiae');
INSERT INTO taxonomy VALUES(643,562961,'Plasmopara','sp. KUS-F 23331');
INSERT INTO taxonomy VALUES(644,562962,'Plasmopara','sp. KUS-F 23332');
INSERT INTO taxonomy VALUES(645,562963,'Plasmopara','sp. KUS-F 23333');
INSERT INTO taxonomy VALUES(646,562964,'Plasmopara','sp. KUS-F 23334');
INSERT INTO taxonomy VALUES(647,562965,'Plasmopara','sp. KUS-F 23336');
INSERT INTO taxonomy VALUES(648,562966,'Plasmopara','sp. KUS-F 23337');
INSERT INTO taxonomy VALUES(649,565057,'Phytophthora','gemini');
INSERT INTO taxonomy VALUES(650,565287,'Phytophthora','irrigata');
INSERT INTO taxonomy VALUES(651,565288,'Phytophthora','hydropathica');
INSERT INTO taxonomy VALUES(652,572137,'Wilsoniana','portulacae');
INSERT INTO taxonomy VALUES(653,572139,'Pustula','tragopogonis');
INSERT INTO taxonomy VALUES(654,572926,'Phytophthora','citricola I');
INSERT INTO taxonomy VALUES(655,572927,'Phytophthora','citricola II');
INSERT INTO taxonomy VALUES(656,572928,'Phytophthora','citricola III');
INSERT INTO taxonomy VALUES(657,572929,'Phytophthora','citricola IV');
INSERT INTO taxonomy VALUES(658,581215,'Phytophthora','morindae');
INSERT INTO taxonomy VALUES(659,596104,'Phytophthora','multivora');
INSERT INTO taxonomy VALUES(660,596297,'Pythium','oopapillum');
INSERT INTO taxonomy VALUES(661,598569,'Peronospora','swinglei');
INSERT INTO taxonomy VALUES(662,601994,'Aphanomyces','iridis');
INSERT INTO taxonomy VALUES(663,610363,'Pythium','echinogynum');
INSERT INTO taxonomy VALUES(664,611798,'Phytophthora','aquimorbida');
INSERT INTO taxonomy VALUES(665,621210,'Leptolegnia','sp. VI04813');
INSERT INTO taxonomy VALUES(666,622444,'Peronospora','belbahrii');
INSERT INTO taxonomy VALUES(667,631358,'Phytophthora','asparagi');
INSERT INTO taxonomy VALUES(668,631361,'Phytophthora','austrocedri');
INSERT INTO taxonomy VALUES(669,631433,'Phytophthora','cf. botryosa');
INSERT INTO taxonomy VALUES(670,638948,'Phytophthora','chrysanthemi');
INSERT INTO taxonomy VALUES(671,639000,'Phytophthora','plurivora');
INSERT INTO taxonomy VALUES(672,642600,'Pustula','spinulosa');
INSERT INTO taxonomy VALUES(673,642601,'Wilsoniana','bliti');
INSERT INTO taxonomy VALUES(674,642602,'Wilsoniana','platensis');
INSERT INTO taxonomy VALUES(675,642603,'Wilsoniana','achyranthis');
INSERT INTO taxonomy VALUES(676,643143,'Pythium','senticosum');
INSERT INTO taxonomy VALUES(677,643144,'Pythium','takayamanum');
INSERT INTO taxonomy VALUES(678,643578,'Albugo','capparidis');
INSERT INTO taxonomy VALUES(679,650119,'Halioticida','noduliformans');
INSERT INTO taxonomy VALUES(680,653948,'Albugo','laibachii');
INSERT INTO taxonomy VALUES(681,657220,'Pythium','emineosum');
INSERT INTO taxonomy VALUES(682,657222,'Pythium','camurandrum');
INSERT INTO taxonomy VALUES(683,658183,'Peronospora','elsholtziae');
INSERT INTO taxonomy VALUES(684,658425,'Phytophthora','pini');
INSERT INTO taxonomy VALUES(685,658426,'Phytophthora','mengei');
INSERT INTO taxonomy VALUES(686,658966,'Pythium','guangxiense');
INSERT INTO taxonomy VALUES(687,660914,'Hyaloperonospora','environmental samples');
INSERT INTO taxonomy VALUES(688,669489,'Phytophthora','frigida');
INSERT INTO taxonomy VALUES(689,680264,'Peronospora','trigonellae');
INSERT INTO taxonomy VALUES(690,682055,'Albugo','mauginii');
INSERT INTO taxonomy VALUES(691,683824,'Leptolegnia','sp. EM32A');
INSERT INTO taxonomy VALUES(692,683825,'Leptolegnia','sp. NT');
INSERT INTO taxonomy VALUES(693,683826,'Leptolegnia','sp. SP');
INSERT INTO taxonomy VALUES(694,697875,'Hyaloperonospora','drabae');
INSERT INTO taxonomy VALUES(695,697890,'Hyaloperonospora','norvegica');
INSERT INTO taxonomy VALUES(696,707993,'Halophytophthora','exoprolifera');
INSERT INTO taxonomy VALUES(697,707994,'Phytopythium','kandeliae');
INSERT INTO taxonomy VALUES(698,707995,'Phytophthora','alticola');
INSERT INTO taxonomy VALUES(699,707996,'Phytophthora','himalayensis');
INSERT INTO taxonomy VALUES(700,714891,'Hyaloperonospora','lobulariae');
INSERT INTO taxonomy VALUES(701,714893,'Hyaloperonospora','rorippae-islandicae');
INSERT INTO taxonomy VALUES(702,714894,'Hyaloperonospora','sisymbrii-sophiae');
INSERT INTO taxonomy VALUES(703,743708,'Halophytophthora','porrigovesica');
INSERT INTO taxonomy VALUES(704,749328,'Peronospora','verbenae');
INSERT INTO taxonomy VALUES(705,749329,'Hyaloperonospora','sp. KUS-F24009');
INSERT INTO taxonomy VALUES(706,758748,'Halophytophthora','elongata');
INSERT INTO taxonomy VALUES(707,758750,'Halophytophthora','mycoparasitica');
INSERT INTO taxonomy VALUES(708,758751,'Halophytophthora','polymorphica');
INSERT INTO taxonomy VALUES(709,758752,'Halophytophthora','cf. polymorphica');
INSERT INTO taxonomy VALUES(710,758753,'Halophytophthora','cf. batemanensis');
INSERT INTO taxonomy VALUES(711,758754,'Halophytophthora','epistomium');
INSERT INTO taxonomy VALUES(712,758755,'Halophytophthora','bahamensis');
INSERT INTO taxonomy VALUES(713,758758,'Halophytophthora','cf. exoprolifera');
INSERT INTO taxonomy VALUES(714,758760,'Halophytophthora','vesicula');
INSERT INTO taxonomy VALUES(715,758762,'Halophytophthora','sp. P7166');
INSERT INTO taxonomy VALUES(716,759903,'Halophytophthora','sp. WA26-091603');
INSERT INTO taxonomy VALUES(717,760138,'Halophytophthora','sp. P7666');
INSERT INTO taxonomy VALUES(718,760139,'Halophytophthora','sp. P7667');
INSERT INTO taxonomy VALUES(719,760140,'Halophytophthora','sp. P7892');
INSERT INTO taxonomy VALUES(720,760141,'Halophytophthora','sp. P7893');
INSERT INTO taxonomy VALUES(721,795340,'Phytopythium','sindhum');
INSERT INTO taxonomy VALUES(722,858704,'Hyaloperonospora','praecox');
INSERT INTO taxonomy VALUES(723,864584,'Albugo','resedae');
INSERT INTO taxonomy VALUES(724,880411,'Phytophthora','gibbosa');
INSERT INTO taxonomy VALUES(725,880412,'Phytophthora','gregata');
INSERT INTO taxonomy VALUES(726,880414,'Phytophthora','thermophila');
INSERT INTO taxonomy VALUES(727,884617,'Lagenidium','sp. PWL-2010a');
INSERT INTO taxonomy VALUES(728,884618,'Lagenidium','sp. PWL-2010b');
INSERT INTO taxonomy VALUES(729,884619,'Lagenidium','deciduum');
INSERT INTO taxonomy VALUES(730,884620,'Lagenidium','sp. PWL-2010d');
INSERT INTO taxonomy VALUES(731,884621,'Lagenidium','sp. PWL-2010e');
INSERT INTO taxonomy VALUES(732,884622,'Lagenidium','sp. PWL-2010f');
INSERT INTO taxonomy VALUES(733,884623,'Lagenidium','sp. PWL-2010g');
INSERT INTO taxonomy VALUES(734,884624,'Lagenidium','sp. PWL-2010h');
INSERT INTO taxonomy VALUES(735,884625,'Lagenidium','sp. PWL-2010i');
INSERT INTO taxonomy VALUES(736,886948,'Peronosclerospora','philippinensis');
INSERT INTO taxonomy VALUES(737,886949,'Peronosclerospora','maydis');
INSERT INTO taxonomy VALUES(738,887151,'Albugo','sp. SSP-2010');
INSERT INTO taxonomy VALUES(739,905063,'Phytophthora','elongata');
INSERT INTO taxonomy VALUES(740,905064,'Phytophthora','cf. elongata');
INSERT INTO taxonomy VALUES(741,907744,'Phytophthora','aff. infestans');
INSERT INTO taxonomy VALUES(742,907745,'Phytophthora','aff. rosacearum');
INSERT INTO taxonomy VALUES(743,907748,'Phytophthora','aff. primulae');
INSERT INTO taxonomy VALUES(744,907947,'Phytopythium','vexans');
INSERT INTO taxonomy VALUES(745,911891,'Phytophthora','capensis');
INSERT INTO taxonomy VALUES(746,913021,'Albugo','leimonios');
INSERT INTO taxonomy VALUES(747,913022,'Albugo','hesleri');
INSERT INTO taxonomy VALUES(748,913023,'Albugo','hohenheimia');
INSERT INTO taxonomy VALUES(749,913185,'Pustula','centaurii');
INSERT INTO taxonomy VALUES(750,913194,'Bremia','cirsii');
INSERT INTO taxonomy VALUES(751,913195,'Bremia','lapsanae');
INSERT INTO taxonomy VALUES(752,913196,'Bremia','tulasnei');
INSERT INTO taxonomy VALUES(753,913197,'Bremia','taraxaci');
INSERT INTO taxonomy VALUES(754,913886,'Albugo','leimonios s.l.');
INSERT INTO taxonomy VALUES(755,914078,'Albugo','sp. 28A');
INSERT INTO taxonomy VALUES(756,914079,'Albugo','sp. 22A');
INSERT INTO taxonomy VALUES(757,914080,'Albugo','sp. 34A');
INSERT INTO taxonomy VALUES(758,914081,'Albugo','sp. 14A');
INSERT INTO taxonomy VALUES(759,914083,'Pustula','sp. CU13');
INSERT INTO taxonomy VALUES(760,914084,'Pustula','sp. CU24');
INSERT INTO taxonomy VALUES(761,914085,'Pustula','sp. A76');
INSERT INTO taxonomy VALUES(762,914086,'Pustula','sp. A72');
INSERT INTO taxonomy VALUES(763,914087,'Pustula','sp. A19');
INSERT INTO taxonomy VALUES(764,914088,'Pustula','sp. D158');
INSERT INTO taxonomy VALUES(765,914089,'Pustula','sp. A69');
INSERT INTO taxonomy VALUES(766,914090,'Pustula','sp. A91');
INSERT INTO taxonomy VALUES(767,914091,'Pustula','sp. D178');
INSERT INTO taxonomy VALUES(768,914092,'Pustula','sp. CU4');
INSERT INTO taxonomy VALUES(769,914093,'Pustula','sp. HOH-HUH 880a');
INSERT INTO taxonomy VALUES(770,914094,'Pustula','sp. HOH-HUH 880b');
INSERT INTO taxonomy VALUES(771,914095,'Pustula','sp. HOH-HUH 936');
INSERT INTO taxonomy VALUES(772,914096,'Pustula','sp. D179');
INSERT INTO taxonomy VALUES(773,914097,'Pustula','sp. A71');
INSERT INTO taxonomy VALUES(774,914098,'Pustula','sp. A73');
INSERT INTO taxonomy VALUES(775,914099,'Pustula','sp. D150');
INSERT INTO taxonomy VALUES(776,914100,'Pustula','sp. D147');
INSERT INTO taxonomy VALUES(777,914101,'Pustula','sp. A59');
INSERT INTO taxonomy VALUES(778,914102,'Pustula','sp. D153');
INSERT INTO taxonomy VALUES(779,914103,'Pustula','sp. D181');
INSERT INTO taxonomy VALUES(780,914104,'Pustula','sp. D149');
INSERT INTO taxonomy VALUES(781,914105,'Pustula','sp. A75');
INSERT INTO taxonomy VALUES(782,914106,'Pustula','sp. D157');
INSERT INTO taxonomy VALUES(783,914107,'Pustula','sp. A163b');
INSERT INTO taxonomy VALUES(784,914108,'Pustula','sp. D177');
INSERT INTO taxonomy VALUES(785,914109,'Pustula','sp. D155');
INSERT INTO taxonomy VALUES(786,914110,'Pustula','sp. A60');
INSERT INTO taxonomy VALUES(787,914111,'Pustula','sp. A50');
INSERT INTO taxonomy VALUES(788,914112,'Pustula','sp. D146');
INSERT INTO taxonomy VALUES(789,914113,'Pustula','sp. HOH-HUH 679');
INSERT INTO taxonomy VALUES(790,914114,'Pustula','sp. A30-1');
INSERT INTO taxonomy VALUES(791,914115,'Pustula','sp. D180');
INSERT INTO taxonomy VALUES(792,914116,'Pustula','sp. A81');
INSERT INTO taxonomy VALUES(793,928215,'Phytophthora','himalsilva');
INSERT INTO taxonomy VALUES(794,929565,'Phytophthora','constricta');
INSERT INTO taxonomy VALUES(795,929574,'Phytophthora','arenaria');
INSERT INTO taxonomy VALUES(796,934032,'Albugo','sp. YJC-2010a');
INSERT INTO taxonomy VALUES(797,934033,'Albugo','rorippae');
INSERT INTO taxonomy VALUES(798,935871,'Aphanomyces','salsuginosus');
INSERT INTO taxonomy VALUES(799,942735,'Aphanomyces','cf. repetans');
INSERT INTO taxonomy VALUES(800,943233,'Lagenidium','sp. PWL-2011a');
INSERT INTO taxonomy VALUES(801,944587,'Achlya','sparrowii');
INSERT INTO taxonomy VALUES(802,944588,'Brevilegnia','gracilis');
INSERT INTO taxonomy VALUES(803,944594,'Brevilegnia','unisperma');
INSERT INTO taxonomy VALUES(804,944596,'Brevilegnia','variabilis');
INSERT INTO taxonomy VALUES(805,944600,'Phytophthora','aff. botryosa');
INSERT INTO taxonomy VALUES(806,944601,'Phytophthora','aff. sansomeana');
INSERT INTO taxonomy VALUES(807,944602,'Phytophthora','batemanensis');
INSERT INTO taxonomy VALUES(808,944609,'Phytophthora','tabaci');
INSERT INTO taxonomy VALUES(809,944610,'Phytopythium','aff. vexans');
INSERT INTO taxonomy VALUES(810,944611,'Pythium','afertile');
INSERT INTO taxonomy VALUES(811,944616,'Pythiogeton','zeae');
INSERT INTO taxonomy VALUES(812,944618,'Pythium','aff. diclinum');
INSERT INTO taxonomy VALUES(813,944619,'Pythium','aff. dictyosporum');
INSERT INTO taxonomy VALUES(814,944620,'Pythium','aff. dissotocum');
INSERT INTO taxonomy VALUES(815,944621,'Pythium','aff. hydnosporum');
INSERT INTO taxonomy VALUES(816,944622,'Pythium','aff. hypogynum');
INSERT INTO taxonomy VALUES(817,944623,'Pythium','aff. periilum');
INSERT INTO taxonomy VALUES(818,944624,'Pythium','aff. perplexum');
INSERT INTO taxonomy VALUES(819,944625,'Pythium','aff. pleroticum');
INSERT INTO taxonomy VALUES(820,944626,'Pythium','aff. polymastum');
INSERT INTO taxonomy VALUES(821,944627,'Pythium','aff. torulosum');
INSERT INTO taxonomy VALUES(822,944628,'Pythium','aff. volutum');
INSERT INTO taxonomy VALUES(823,944629,'Pythium','cf. dictyosporum');
INSERT INTO taxonomy VALUES(824,944634,'Pythium','kashmirense');
INSERT INTO taxonomy VALUES(825,944635,'Pythium','lucens');
INSERT INTO taxonomy VALUES(826,944636,'Pythium','lycopersicum');
INSERT INTO taxonomy VALUES(827,944637,'Pythium','sukuiense');
INSERT INTO taxonomy VALUES(828,944638,'Pythium','tardicrescens');
INSERT INTO taxonomy VALUES(829,944640,'Saprolegnia','asterophora');
INSERT INTO taxonomy VALUES(830,944641,'Saprolegnia','delica');
INSERT INTO taxonomy VALUES(831,944642,'Saprolegnia','lapponica');
INSERT INTO taxonomy VALUES(832,944643,'Thraustotheca','terrestris');
INSERT INTO taxonomy VALUES(833,946367,'Leptolegnia','sp. BOLD:AAX5717');
INSERT INTO taxonomy VALUES(834,946373,'Phytopythium','oedochilum');
INSERT INTO taxonomy VALUES(835,946379,'Achlya','rodrigueziana');
INSERT INTO taxonomy VALUES(836,946380,'Pythium','aff. iwayamai');
INSERT INTO taxonomy VALUES(837,977741,'Phytophthora','litoralis');
INSERT INTO taxonomy VALUES(838,977911,'Phytophthora','citricola E');
INSERT INTO taxonomy VALUES(839,980194,'Halophytophthora','sp. P15740');
INSERT INTO taxonomy VALUES(840,980195,'Halophytophthora','sp. P15746');
INSERT INTO taxonomy VALUES(841,980196,'Halophytophthora','sp. P7846');
INSERT INTO taxonomy VALUES(842,980197,'Salispina','spinosa');
INSERT INTO taxonomy VALUES(843,980346,'Halophytophthora','masteri');
INSERT INTO taxonomy VALUES(844,983655,'Halophytophthora','sp. LT6430');
INSERT INTO taxonomy VALUES(845,983656,'Halophytophthora','sp. LT6465');
INSERT INTO taxonomy VALUES(846,983659,'Salisapilia','nakagirii');
INSERT INTO taxonomy VALUES(847,983660,'Salisapilia','sapeloensis');
INSERT INTO taxonomy VALUES(848,983661,'Salisapilia','tartarea');
INSERT INTO taxonomy VALUES(849,983662,'Salisapilia','sp. LT6460');
INSERT INTO taxonomy VALUES(850,983663,'Salisapilia','sp. LT6466');
INSERT INTO taxonomy VALUES(851,983664,'Salisapilia','sp. LT6471');
INSERT INTO taxonomy VALUES(852,983690,'Leptolegnia','CAL-2011b');
INSERT INTO taxonomy VALUES(853,1005363,'Pustula','helianthicola');
INSERT INTO taxonomy VALUES(854,1009719,'Eraphthora','butleri');
INSERT INTO taxonomy VALUES(855,1027885,'Pythium','aff. canariense OW1707');
INSERT INTO taxonomy VALUES(856,1034759,'Phytophthora','cf. arenaria');
INSERT INTO taxonomy VALUES(857,1049196,'Phytopythium','boreale');
INSERT INTO taxonomy VALUES(858,1049198,'Leptolegnia','sp. CBS 582.85');
INSERT INTO taxonomy VALUES(859,1049225,'Phytophthora','aff. asparagi');
INSERT INTO taxonomy VALUES(860,1049592,'Phytophthora','fluvialis');
INSERT INTO taxonomy VALUES(861,1077222,'Pythium','aff. monospermum');
INSERT INTO taxonomy VALUES(862,1077223,'Pythium','aff. heterothallicum');
INSERT INTO taxonomy VALUES(863,1077224,'Pythium','aff. macrosporum');
INSERT INTO taxonomy VALUES(864,1077225,'Pythium','aff. canariense');
INSERT INTO taxonomy VALUES(865,1081074,'Peronosclerospora','eriochloae');
INSERT INTO taxonomy VALUES(866,1081075,'Peronosclerospora','cf. eriochloae');
INSERT INTO taxonomy VALUES(867,1081076,'Peronosclerospora','miscanthi');
INSERT INTO taxonomy VALUES(868,1081077,'Peronosclerospora','sp. ST-2011');
INSERT INTO taxonomy VALUES(869,1089797,'Plasmopara','majewskii');
INSERT INTO taxonomy VALUES(870,1099854,'Peronospora','dianthicola');
INSERT INTO taxonomy VALUES(871,1104319,'Phytophthora','obscura');
INSERT INTO taxonomy VALUES(872,1125843,'Aphanomyces','sinensis');
INSERT INTO taxonomy VALUES(873,1126000,'Halophytophthora','sp. NBRC 32444');
INSERT INTO taxonomy VALUES(874,1126001,'Halophytophthora','sp. NBRC 32445');
INSERT INTO taxonomy VALUES(875,1130067,'Phytopythium','fagopyri');
INSERT INTO taxonomy VALUES(876,1130069,'Phytopythium','iriomotense');
INSERT INTO taxonomy VALUES(877,1130980,'Phytopythium','delawarense');
INSERT INTO taxonomy VALUES(878,1131323,'Phytophthora','pisi');
INSERT INTO taxonomy VALUES(879,1151129,'Peronospora','saturejae-hortensis');
INSERT INTO taxonomy VALUES(880,1154630,'Albugo','sp. FR0046008');
INSERT INTO taxonomy VALUES(881,1154631,'Albugo','sp. FR0046009');
INSERT INTO taxonomy VALUES(882,1154632,'Albugo','sp. FR0046010');
INSERT INTO taxonomy VALUES(883,1154633,'Albugo','sp. FR0046011');
INSERT INTO taxonomy VALUES(884,1154634,'Albugo','sp. FR0046012');
INSERT INTO taxonomy VALUES(885,1154635,'Albugo','sp. FR0046013');
INSERT INTO taxonomy VALUES(886,1154636,'Albugo','sp. FR0046014');
INSERT INTO taxonomy VALUES(887,1154637,'Albugo','sp. FR0046017');
INSERT INTO taxonomy VALUES(888,1154638,'Albugo','sp. FR0046018');
INSERT INTO taxonomy VALUES(889,1154639,'Albugo','sp. FR0046019');
INSERT INTO taxonomy VALUES(890,1154640,'Albugo','sp. FR0046020');
INSERT INTO taxonomy VALUES(891,1154641,'Albugo','sp. FR0046021');
INSERT INTO taxonomy VALUES(892,1154642,'Albugo','sp. FR0046022');
INSERT INTO taxonomy VALUES(893,1154643,'Albugo','sp. FR0046023');
INSERT INTO taxonomy VALUES(894,1168480,'Hyaloperonospora','sp. KUS-F25091');
INSERT INTO taxonomy VALUES(895,1176157,'Lagenidium','sp. MTLA-01');
INSERT INTO taxonomy VALUES(896,1176158,'Lagenidium','sp. MTLA-03');
INSERT INTO taxonomy VALUES(897,1176159,'Lagenidium','sp. MTLA-04');
INSERT INTO taxonomy VALUES(898,1176160,'Lagenidium','sp. MTLA-05');
INSERT INTO taxonomy VALUES(899,1185511,'Phytophthora','riparia');
INSERT INTO taxonomy VALUES(900,1185512,'Phytophthora','borealis');
INSERT INTO taxonomy VALUES(901,1190534,'Phytophthora','lacustris');
INSERT INTO taxonomy VALUES(902,1190596,'Chlamydomyzium','dictyuchoides');
INSERT INTO taxonomy VALUES(903,1196443,'Plasmopara','muralis');
INSERT INTO taxonomy VALUES(904,1196597,'Phytophthora','amnicola');
INSERT INTO taxonomy VALUES(905,1197709,'Phytophthora','cf. gregata');
INSERT INTO taxonomy VALUES(906,1197710,'Phytophthora','bilorbang');
INSERT INTO taxonomy VALUES(907,1201160,'Pythium','breve');
INSERT INTO taxonomy VALUES(908,1201161,'Pythium','baisense');
INSERT INTO taxonomy VALUES(909,1202772,'Achlya','hypogyna');
INSERT INTO taxonomy VALUES(910,1203047,'Leptolegnia','sp. WLL-2012');
INSERT INTO taxonomy VALUES(911,1214257,'Phytophthora','aff. arenaria');
INSERT INTO taxonomy VALUES(912,1214258,'Phytophthora','aff. humicola');
INSERT INTO taxonomy VALUES(913,1216510,'Phytophthora','thermophila x amnicola');
INSERT INTO taxonomy VALUES(914,1216624,'Phytophthora','cf. tropicalis');
INSERT INTO taxonomy VALUES(915,1216625,'Phytophthora','cf. insolita');
INSERT INTO taxonomy VALUES(916,1216626,'Phytophthora','cf. mexicana');
INSERT INTO taxonomy VALUES(917,1217585,'Pythiogeton','zizaniae');
INSERT INTO taxonomy VALUES(918,1217586,'Pythiogeton','ramosum');
INSERT INTO taxonomy VALUES(919,1217587,'Pythiogeton','uniforme');
INSERT INTO taxonomy VALUES(920,1217588,'Pythiogeton','puliense');
INSERT INTO taxonomy VALUES(921,1217589,'Pythiogeton','oblongilobum');
INSERT INTO taxonomy VALUES(922,1217590,'Pythiogeton','microzoosporum');
INSERT INTO taxonomy VALUES(923,1217591,'Pythiogeton','abundans');
INSERT INTO taxonomy VALUES(924,1217592,'Pythiogeton','paucisporum');
INSERT INTO taxonomy VALUES(925,1217593,'Pythiogeton','proliferatum');
INSERT INTO taxonomy VALUES(926,1217863,'Aphanomyces','sp. WLL-2012');
INSERT INTO taxonomy VALUES(927,1218935,'Phytophthora','cf. citricola FM-2012');
INSERT INTO taxonomy VALUES(928,1218936,'Phytophthora','aff. citricola 1 FM-2012');
INSERT INTO taxonomy VALUES(929,1218937,'Phytophthora','aff. citricola 2 FM-2012');
INSERT INTO taxonomy VALUES(930,1218938,'Phytophthora','cf. citrophthora 1b FM-2012');
INSERT INTO taxonomy VALUES(931,1218939,'Phytophthora','cf. citrophthora 2 FM-2012');
INSERT INTO taxonomy VALUES(932,1218940,'Phytophthora','cf. cryptogea 1 FM-2012');
INSERT INTO taxonomy VALUES(933,1218942,'Phytophthora','cf. heveae 1 FM-2012');
INSERT INTO taxonomy VALUES(934,1218943,'Phytophthora','cf. heveae 2 FM-2012');
INSERT INTO taxonomy VALUES(935,1218944,'Phytophthora','cf. katsurae 1 FM-2012');
INSERT INTO taxonomy VALUES(936,1218945,'Phytophthora','cf. katsurae 2 FM-2012');
INSERT INTO taxonomy VALUES(937,1218947,'Phytophthora','cf. cryptogea 2 FM-2012');
INSERT INTO taxonomy VALUES(938,1234294,'Halophytophthora','sp. EMTD10');
INSERT INTO taxonomy VALUES(939,1234295,'Halophytophthora','sp. EMTD11');
INSERT INTO taxonomy VALUES(940,1234296,'Halophytophthora','sp. EMTD12');
INSERT INTO taxonomy VALUES(941,1234297,'Halophytophthora','sp. EMTD7');
INSERT INTO taxonomy VALUES(942,1234298,'Halophytophthora','sp. EMTS10');
INSERT INTO taxonomy VALUES(943,1234299,'Halophytophthora','sp. EMTS12');
INSERT INTO taxonomy VALUES(944,1234300,'Halophytophthora','sp. EMTS19');
INSERT INTO taxonomy VALUES(945,1234301,'Halophytophthora','sp. EMTS2');
INSERT INTO taxonomy VALUES(946,1234302,'Halophytophthora','sp. EMTS20');
INSERT INTO taxonomy VALUES(947,1234303,'Halophytophthora','sp. EMTS21');
INSERT INTO taxonomy VALUES(948,1234304,'Halophytophthora','sp. EMTS22');
INSERT INTO taxonomy VALUES(949,1234305,'Halophytophthora','sp. EMTS23');
INSERT INTO taxonomy VALUES(950,1234306,'Halophytophthora','sp. EMTS4');
INSERT INTO taxonomy VALUES(951,1234307,'Halophytophthora','sp. EMTS6');
INSERT INTO taxonomy VALUES(952,1234308,'Halophytophthora','sp. EMTS7');
INSERT INTO taxonomy VALUES(953,1234309,'Halophytophthora','sp. EMTS8');
INSERT INTO taxonomy VALUES(954,1234955,'Peronospora','jagei');
INSERT INTO taxonomy VALUES(955,1241941,'Phytophthora','acerina');
INSERT INTO taxonomy VALUES(956,1243776,'Lagenidium','sp. ''albertoi''');
INSERT INTO taxonomy VALUES(957,1243777,'Lagenidium','sp. LM-2012b');
INSERT INTO taxonomy VALUES(958,1243779,'Lagenidium','sp. ''vilelae''');
INSERT INTO taxonomy VALUES(959,1244139,'Lagenidium','sp. LC1');
INSERT INTO taxonomy VALUES(960,1266951,'Dictyuchus','sp. JVS-2012');
INSERT INTO taxonomy VALUES(961,1266952,'Leptolegnia','sp. JVS-2012');
INSERT INTO taxonomy VALUES(962,1273180,'Phytophthora','cyperi');
INSERT INTO taxonomy VALUES(963,1277646,'Pythium','schmitthenneri');
INSERT INTO taxonomy VALUES(964,1277647,'Pythium','selbyi');
INSERT INTO taxonomy VALUES(965,1279233,'Myzocytiopsis','sp. GPR-2013');
INSERT INTO taxonomy VALUES(966,1283836,'Phytophthora','cactorum/hedraiandra SP-2013');
INSERT INTO taxonomy VALUES(967,1286608,'Phytophthora','hydrogena');
INSERT INTO taxonomy VALUES(968,1286650,'Phytophthora','x pelgrandis');
INSERT INTO taxonomy VALUES(969,1287862,'Peronospora','plantaginis');
INSERT INTO taxonomy VALUES(970,1320215,'Phytophthora','cichorii');
INSERT INTO taxonomy VALUES(971,1320216,'Phytophthora','dauci');
INSERT INTO taxonomy VALUES(972,1320217,'Phytophthora','lactucae');
INSERT INTO taxonomy VALUES(973,1320378,'Peronospora','digitalis');
INSERT INTO taxonomy VALUES(974,1330343,'Phytophthora','pluvialis');
INSERT INTO taxonomy VALUES(975,1334604,'Phytopythium','cf. citrinum A PB-2013');
INSERT INTO taxonomy VALUES(976,1334605,'Phytopythium','cf. citrinum B PB-2013');
INSERT INTO taxonomy VALUES(977,1334606,'Phytophthora','cf. rosacearum PB-2013');
INSERT INTO taxonomy VALUES(978,1344363,'Plasmopara','laserpitii');
INSERT INTO taxonomy VALUES(979,1344364,'Hyaloperonospora','cardamines-laciniatae');
INSERT INTO taxonomy VALUES(980,1344365,'Hyaloperonospora','dentariae-macrophyllae');
INSERT INTO taxonomy VALUES(981,1344366,'Hyaloperonospora','malyi');
INSERT INTO taxonomy VALUES(982,1344368,'Hyaloperonospora','cardamines-enneaphyllos');
INSERT INTO taxonomy VALUES(983,1344369,'Plasmopara','sp. 1 HV-2013');
INSERT INTO taxonomy VALUES(984,1380738,'Phytophthora','pachypleura');
INSERT INTO taxonomy VALUES(985,1385620,'Phytophthora','occultans');
INSERT INTO taxonomy VALUES(986,1385621,'Phytophthora','terminalis');
INSERT INTO taxonomy VALUES(987,1391457,'Pythium','phragmiticola');
INSERT INTO taxonomy VALUES(988,1396423,'Phytophthora','mississippiae');
INSERT INTO taxonomy VALUES(989,1401295,'Phytophthora','stricta');
INSERT INTO taxonomy VALUES(990,1401296,'Phytophthora','macilentosa');
INSERT INTO taxonomy VALUES(991,1432543,'Geolegnia','helicoides');
INSERT INTO taxonomy VALUES(992,1437524,'Pythiogeton','sp. BV1');
INSERT INTO taxonomy VALUES(993,1440115,'Paralagenidium','karlingii');
INSERT INTO taxonomy VALUES(994,1440157,'Lagenidium','sp. CICR-Hop');
INSERT INTO taxonomy VALUES(995,1441741,'Lagenidium','aff. deciduum strain LEV5864');
INSERT INTO taxonomy VALUES(996,1441742,'Lagenidium','sp. strain LEV5863');
INSERT INTO taxonomy VALUES(997,1441743,'Lagenidium','sp. strain LEV5848');
INSERT INTO taxonomy VALUES(998,1441771,'Paralagenidium','sp. C06-TW60');
INSERT INTO taxonomy VALUES(999,1441772,'Paralagenidium','sp. C09-TL95');
INSERT INTO taxonomy VALUES(1000,1446881,'Halophytophthora','fluviatilis');
INSERT INTO taxonomy VALUES(1001,1448053,'Globisporangium','intermedium');
INSERT INTO taxonomy VALUES(1002,1448060,'Pythium','salinum');
INSERT INTO taxonomy VALUES(1003,1448062,'Ovatisporangium','sp. 1 KC-2014');
INSERT INTO taxonomy VALUES(1004,1448063,'Ovatisporangium','sp. 2 KC-2014');
INSERT INTO taxonomy VALUES(1005,1448070,'Ovatisporangium','sp. KC-2014');
INSERT INTO taxonomy VALUES(1006,1450233,'Leptolegnia','sp. CBS 392.81');
INSERT INTO taxonomy VALUES(1007,1450477,'Pythium','cederbergense');
INSERT INTO taxonomy VALUES(1008,1452752,'Globisporangium','sp. KC-2014');
INSERT INTO taxonomy VALUES(1009,1452753,'Halophytophthora','sp. 1 KC-2014');
INSERT INTO taxonomy VALUES(1010,1452754,'Halophytophthora','sp. 2 KC-2014');
INSERT INTO taxonomy VALUES(1011,1452755,'Halophytophthora','sp. 3 KC-2014');
INSERT INTO taxonomy VALUES(1012,1458840,'Plasmopara','sp. HV-2014a');
INSERT INTO taxonomy VALUES(1013,1463539,'Plasmopara','invertifolia');
INSERT INTO taxonomy VALUES(1014,1464076,'Phytophthora','aff. cactorum FNM-2014');
INSERT INTO taxonomy VALUES(1015,1470262,'Paralagenidium','sp. ''ajelloi''');
INSERT INTO taxonomy VALUES(1016,1471603,'Pustula','obtusata');
INSERT INTO taxonomy VALUES(1017,1477121,'Phytophthora','virginiana');
INSERT INTO taxonomy VALUES(1018,1484098,'Bremia','aff. lagoseridis GLM68027');
INSERT INTO taxonomy VALUES(1019,1484099,'Bremia','picridis');
INSERT INTO taxonomy VALUES(1020,1484100,'Bremia','elliptica');
INSERT INTO taxonomy VALUES(1021,1484102,'Peronospora','anagallidis');
INSERT INTO taxonomy VALUES(1022,1484356,'Peronospora','valerianae');
INSERT INTO taxonomy VALUES(1023,1484358,'Peronospora','honckenyae');
INSERT INTO taxonomy VALUES(1024,1484359,'Peronospora','phacae');
INSERT INTO taxonomy VALUES(1025,1484360,'Peronospora','potentillae-anserinae');
INSERT INTO taxonomy VALUES(1026,1484361,'Peronospora','potentillae-reptantis');
INSERT INTO taxonomy VALUES(1027,1484362,'Peronospora','rubi');
INSERT INTO taxonomy VALUES(1028,1484363,'Peronospora','salviae-plebeiae');
INSERT INTO taxonomy VALUES(1029,1484364,'Peronospora','saxifragae');
INSERT INTO taxonomy VALUES(1030,1484365,'Peronospora','schachtii');
INSERT INTO taxonomy VALUES(1031,1484366,'Peronospora','stachydis');
INSERT INTO taxonomy VALUES(1032,1484367,'Peronospora','symphyti');
INSERT INTO taxonomy VALUES(1033,1484368,'Peronospora','scleranthi');
INSERT INTO taxonomy VALUES(1034,1484369,'Peronospora','scutellariae');
INSERT INTO taxonomy VALUES(1035,1484371,'Peronospora','teucrii');
INSERT INTO taxonomy VALUES(1036,1484372,'Peronospora','tomentosa');
INSERT INTO taxonomy VALUES(1037,1484373,'Peronospora','vernalis');
INSERT INTO taxonomy VALUES(1038,1484374,'Peronospora','verbasci');
INSERT INTO taxonomy VALUES(1039,1484375,'Peronospora','debaryi');
INSERT INTO taxonomy VALUES(1040,1484376,'Peronospora','dipsaci');
INSERT INTO taxonomy VALUES(1041,1484377,'Peronospora','echii');
INSERT INTO taxonomy VALUES(1042,1484378,'Peronospora','erodii');
INSERT INTO taxonomy VALUES(1043,1484379,'Peronospora','galii');
INSERT INTO taxonomy VALUES(1044,1484380,'Peronospora','glechomae');
INSERT INTO taxonomy VALUES(1045,1484381,'Peronospora','affinis');
INSERT INTO taxonomy VALUES(1046,1484382,'Peronospora','antirrhini');
INSERT INTO taxonomy VALUES(1047,1484383,'Peronospora','argemones');
INSERT INTO taxonomy VALUES(1048,1484384,'Peronospora','cerastii-anomali');
INSERT INTO taxonomy VALUES(1049,1484385,'Peronospora','cerastii-brachypetali');
INSERT INTO taxonomy VALUES(1050,1484386,'Peronospora','consolidae');
INSERT INTO taxonomy VALUES(1051,1484387,'Peronospora','corydalis-intermediae');
INSERT INTO taxonomy VALUES(1052,1484431,'Peronospora','cyparissiae');
INSERT INTO taxonomy VALUES(1053,1484475,'Peronospora','lapponica');
INSERT INTO taxonomy VALUES(1054,1484476,'Peronospora','lepigoni');
INSERT INTO taxonomy VALUES(1055,1484477,'Peronospora','linariae');
INSERT INTO taxonomy VALUES(1056,1484478,'Peronospora','linariae-genistifoliae');
INSERT INTO taxonomy VALUES(1057,1484480,'Peronospora','lithospermi');
INSERT INTO taxonomy VALUES(1058,1484481,'Peronospora','meconopsidis');
INSERT INTO taxonomy VALUES(1059,1484482,'Peronospora','melandryi-noctiflori');
INSERT INTO taxonomy VALUES(1060,1484483,'Peronospora','minor');
INSERT INTO taxonomy VALUES(1061,1484484,'Peronospora','oblatispora');
INSERT INTO taxonomy VALUES(1062,1484485,'Peronospora','polygoni-convolvuli');
INSERT INTO taxonomy VALUES(1063,1484486,'Myzocytiopsis','osiris');
INSERT INTO taxonomy VALUES(1064,1484556,'Lagenidium','sp. YJC-2014');
INSERT INTO taxonomy VALUES(1065,1484560,'Halophytophthora','sp. YJC-2014');
INSERT INTO taxonomy VALUES(1066,1484563,'Albugo','sp. YJC-2014');
INSERT INTO taxonomy VALUES(1067,1485010,'Pythium','brassicum');
INSERT INTO taxonomy VALUES(1068,1486344,'Phytophthora','amaranthi');
INSERT INTO taxonomy VALUES(1069,1487174,'Peronosclerospora','sp. YJC-2014');
INSERT INTO taxonomy VALUES(1070,1489738,'Pythium','polare');
INSERT INTO taxonomy VALUES(1071,1489740,'Pythium','solare');
INSERT INTO taxonomy VALUES(1072,1489741,'Pythium','recalcitrans');
INSERT INTO taxonomy VALUES(1073,1489786,'Lagenidium','sp. SLG-2014a');
INSERT INTO taxonomy VALUES(1074,1489787,'Lagenidium','sp. SLG-2014b');
INSERT INTO taxonomy VALUES(1075,1489789,'Lagena','radicicola');
INSERT INTO taxonomy VALUES(1076,1490495,'Phytophthora','fragariaefolia');
INSERT INTO taxonomy VALUES(1077,1491441,'Peronospora','apula');
INSERT INTO taxonomy VALUES(1078,1491442,'Peronospora','somniferi');
INSERT INTO taxonomy VALUES(1079,1492783,'Dictyuchus','sp. MA-2014');
INSERT INTO taxonomy VALUES(1080,1495612,'Aquastella','attenuata');
INSERT INTO taxonomy VALUES(1081,1495613,'Aquastella','acicularis');
INSERT INTO taxonomy VALUES(1082,1499098,'Phytophthora','lacustris x riparia');
INSERT INTO taxonomy VALUES(1083,1499989,'Pustula','sp. LdT-2014');
INSERT INTO taxonomy VALUES(1084,1503226,'Leptolegnia','sp. SR-2014');
INSERT INTO taxonomy VALUES(1085,1525374,'Pythium','cf. amazonianum C022');
INSERT INTO taxonomy VALUES(1086,1525375,'Pythium','cf. amazonianum C024');
INSERT INTO taxonomy VALUES(1087,1525376,'Pythium','cf. vexans C061');
INSERT INTO taxonomy VALUES(1088,1525714,'Phytophthora','nagaii');
INSERT INTO taxonomy VALUES(1089,1529059,'Phytophthora','asiatica');
INSERT INTO taxonomy VALUES(1090,1532566,'Leptolegnia','sp. SAP0772');
INSERT INTO taxonomy VALUES(1091,1542445,'Halophytophthora','environmental samples');
INSERT INTO taxonomy VALUES(1092,1547593,'Leptolegnia','sp. MNS-2014a');
INSERT INTO taxonomy VALUES(1093,1564265,'Plasmopara','sphagneticolae');
INSERT INTO taxonomy VALUES(1094,1567491,'Phytophthora','x serendipita');
INSERT INTO taxonomy VALUES(1095,1577959,'Phytophthora','moyootj');
INSERT INTO taxonomy VALUES(1096,1579205,'Brevilegnia','minutandra');
INSERT INTO taxonomy VALUES(1097,1582016,'Phytophthora','cf. lacustris NJG-2014');
INSERT INTO taxonomy VALUES(1098,1588901,'Pythium','utonaiense');
INSERT INTO taxonomy VALUES(1099,1588902,'Pythium','brachiatum');
INSERT INTO taxonomy VALUES(1100,1588903,'Pythium','biforme');
INSERT INTO taxonomy VALUES(1101,1588904,'Pythium','junctum');
INSERT INTO taxonomy VALUES(1102,1602131,'Phytopythium','mirpurense');
INSERT INTO taxonomy VALUES(1103,1602133,'Phytopythium','palingenes');
INSERT INTO taxonomy VALUES(1104,1617996,'Aphanomyces','scaber');
INSERT INTO taxonomy VALUES(1105,1618013,'Newbya','spinosa');
INSERT INTO taxonomy VALUES(1106,1618014,'Pythiopsis','intermedia');
INSERT INTO taxonomy VALUES(1107,1618016,'Achlya','debaryana');
INSERT INTO taxonomy VALUES(1108,1618017,'Achlya','bonariensis');
INSERT INTO taxonomy VALUES(1109,1618018,'Leptolegnia','sp. LB-2015');
INSERT INTO taxonomy VALUES(1110,1618019,'Aplanes','treleaseanus');
INSERT INTO taxonomy VALUES(1111,1618020,'Newbya','dichotoma');
INSERT INTO taxonomy VALUES(1112,1628356,'Achlya','androgyna');
INSERT INTO taxonomy VALUES(1113,1628357,'Achlya','catenulata');
INSERT INTO taxonomy VALUES(1114,1629122,'Pythium','barbulae');
INSERT INTO taxonomy VALUES(1115,1631664,'Haptoglossa','sp. UK');
INSERT INTO taxonomy VALUES(1116,1631665,'Albugo','lepigoni');
INSERT INTO taxonomy VALUES(1117,1631803,'Brevilegnia','longicaulis');
INSERT INTO taxonomy VALUES(1118,1632203,'Pythium','kandovanense');
INSERT INTO taxonomy VALUES(1119,1632271,'Basidiophora','simplex');
INSERT INTO taxonomy VALUES(1120,1632272,'Basidiophora','sp. 1 AS-2015');
INSERT INTO taxonomy VALUES(1121,1632273,'Basidiophora','sp. 2 AS-2015');
INSERT INTO taxonomy VALUES(1122,1632274,'Basidiophora','sp. 3 AS-2015');
INSERT INTO taxonomy VALUES(1123,1632275,'Basidiophora','sp. 4 AS-2015');
INSERT INTO taxonomy VALUES(1124,1632276,'Basidiophora','sp. 5 AS-2015');
INSERT INTO taxonomy VALUES(1125,1632285,'Pythium','burgundicum');
INSERT INTO taxonomy VALUES(1126,1632325,'Peronospora','litoralis');
INSERT INTO taxonomy VALUES(1127,1632326,'Peronospora','polycarpi');
INSERT INTO taxonomy VALUES(1128,1632327,'Peronospora','atriplicis-hastatae');
INSERT INTO taxonomy VALUES(1129,1635159,'Pilasporangium','apinafurcum');
INSERT INTO taxonomy VALUES(1130,1638924,'Olpidiopsis','feldmanni');
INSERT INTO taxonomy VALUES(1131,1642459,'Phytophthora','agathidicida');
INSERT INTO taxonomy VALUES(1132,1642464,'Phytophthora','cocois');
INSERT INTO taxonomy VALUES(1133,1642465,'Phytophthora','castaneae');
INSERT INTO taxonomy VALUES(1134,1663100,'Anisolpidium','ectocarpii');
INSERT INTO taxonomy VALUES(1135,1672054,'Blastulidium','paedophthorum');
INSERT INTO taxonomy VALUES(1136,1679947,'Peronospora','cf. fagopyri MK-2015');
INSERT INTO taxonomy VALUES(1137,1682049,'Lagenisma','coscinodisci');
INSERT INTO taxonomy VALUES(1138,1686415,'Olpidiopsis','pyropiae');
INSERT INTO taxonomy VALUES(1139,1686789,'Saprolegnia','aenigmatica');
INSERT INTO taxonomy VALUES(1140,1686790,'Saprolegnia','racemosa');
INSERT INTO taxonomy VALUES(1141,1692154,'Phytophthora','chlamydospora');
INSERT INTO taxonomy VALUES(1142,1696062,'Phytophthora','ornamentata');
INSERT INTO taxonomy VALUES(1143,1697476,'Baobabopsis','donbarrettii');
INSERT INTO taxonomy VALUES(1144,1697477,'Baobabopsis','enneapogonis');
INSERT INTO taxonomy VALUES(1145,1697482,'Peronosclerospora','sp. YJC-2015');
INSERT INTO taxonomy VALUES(1146,1697570,'Bremia','cf. lagoseridis YJC-2015');
INSERT INTO taxonomy VALUES(1147,1702223,'Salilagenidium','myophilum');
INSERT INTO taxonomy VALUES(1148,1702224,'Chlamydomyzium','anomalum');
INSERT INTO taxonomy VALUES(1149,1702225,'Myzocytiopsis','humicola');
INSERT INTO taxonomy VALUES(1150,1702226,'Myzocytiopsis','lenticularis');
INSERT INTO taxonomy VALUES(1151,1702227,'Myzocytiopsis','subuliformis');
INSERT INTO taxonomy VALUES(1152,1702228,'Haptoglossa','sp. DM2 4/12');
INSERT INTO taxonomy VALUES(1153,1702229,'Haptoglossa','sp. SL20');
INSERT INTO taxonomy VALUES(1154,1702230,'Lagenidium','sp. SL23');
INSERT INTO taxonomy VALUES(1155,1702231,'Haptoglossa','sp. SL32');
INSERT INTO taxonomy VALUES(1156,1702233,'Lagenidium','sp. DAOM 242348');
INSERT INTO taxonomy VALUES(1157,1702234,'Lagenidium','sp. IMI395810');
INSERT INTO taxonomy VALUES(1158,1702235,'Lagenidium','sp. SL10');
INSERT INTO taxonomy VALUES(1159,1704119,'Phytophthora','cf. fluvialis hybrid DH117');
INSERT INTO taxonomy VALUES(1160,1704120,'Phytophthora','cf. fluvialis hybrid VHS29992');
INSERT INTO taxonomy VALUES(1161,1704121,'Phytophthora','cf. thermophila hybrid DH106');
INSERT INTO taxonomy VALUES(1162,1704123,'Phytophthora','moyootj x thermophila');
INSERT INTO taxonomy VALUES(1163,1704125,'Phytophthora','amnicola x moyootj');
INSERT INTO taxonomy VALUES(1164,1704126,'Phytophthora','moyootj x fluvialis');
INSERT INTO taxonomy VALUES(1165,1704127,'Phytophthora','fluvialis x moyootj');
INSERT INTO taxonomy VALUES(1166,1704128,'Phytophthora','moyootj x litoralis');
INSERT INTO taxonomy VALUES(1167,1704129,'Phytophthora','litoralis x moyootj');
INSERT INTO taxonomy VALUES(1168,1704130,'Phytophthora','thermophila x moyootj');
INSERT INTO taxonomy VALUES(1169,1729143,'Achlya','orion');
INSERT INTO taxonomy VALUES(1170,1729144,'Achlya','oviparvula');
INSERT INTO taxonomy VALUES(1171,1729145,'Dictyuchus','pseudodictyon');
INSERT INTO taxonomy VALUES(1172,1729146,'Leptolegnia','eccentrica');
INSERT INTO taxonomy VALUES(1173,1729148,'Phragmosporangium','uniseriatum');
INSERT INTO taxonomy VALUES(1174,1729207,'Pythiopsis','irregularis');
INSERT INTO taxonomy VALUES(1175,1729208,'Saprolegnia','truncata');
INSERT INTO taxonomy VALUES(1176,1747825,'Phytophthora','intercalaris');
INSERT INTO taxonomy VALUES(1177,1761981,'Peronospora','chlorae');
INSERT INTO taxonomy VALUES(1178,1762014,'Peronospora','statices');
INSERT INTO taxonomy VALUES(1179,1763597,'Phytopythium','sp. 1 ROH-2015');
INSERT INTO taxonomy VALUES(1180,1771314,'Phytopythium','sp. B57');
INSERT INTO taxonomy VALUES(1181,1771315,'Phytopythium','sp. D37');
INSERT INTO taxonomy VALUES(1182,1771316,'Phytopythium','sp. F65');
INSERT INTO taxonomy VALUES(1183,1771325,'Phytophthora','cf. inundata D0S1P25');
INSERT INTO taxonomy VALUES(1184,1771326,'Pythium','cf. deliense D2.5S2P21-2');
INSERT INTO taxonomy VALUES(1185,1771327,'Pythium','cf. periplocum 4SE010');
INSERT INTO taxonomy VALUES(1186,1771328,'Pythium','cf. porphyrae D0S3P02');
INSERT INTO taxonomy VALUES(1187,1771973,'Phytophthora','crassamura');
INSERT INTO taxonomy VALUES(1188,1785729,'Phytophthora','boodjera');
INSERT INTO taxonomy VALUES(1189,1792277,'Pythium','yorkensis');
INSERT INTO taxonomy VALUES(1190,1792278,'Pythium','aff. intermedium JEB-2016');
INSERT INTO taxonomy VALUES(1191,1792279,'Pythium','aff. undulatum JEB-2016');
INSERT INTO taxonomy VALUES(1192,1798950,'Haliphthoros','sp.');
INSERT INTO taxonomy VALUES(1193,1806582,'Phytophthora','aff. meadii AdP-2013');
INSERT INTO taxonomy VALUES(1194,1821206,'Phytophthora','pseudocryptogea');
INSERT INTO taxonomy VALUES(1195,1825568,'Plasmopara','australis');
INSERT INTO taxonomy VALUES(1196,1844468,'Halophytophthora','sp. Zostera');
INSERT INTO taxonomy VALUES(1197,1846162,'Haliphthoros','sp. IPMB 1402');
INSERT INTO taxonomy VALUES(1198,1855969,'Peronospora','agrimoniae');
INSERT INTO taxonomy VALUES(1199,1857252,'Phytophthora','chesapeakensis');
INSERT INTO taxonomy VALUES(1200,1857766,'Phytophthora','aff. meadii');
INSERT INTO taxonomy VALUES(1201,1861792,'Salispina','intermedia');
INSERT INTO taxonomy VALUES(1202,1861846,'Phytophthora','attenuata');
INSERT INTO taxonomy VALUES(1203,1861847,'Phytophthora','x heterohybrida');
INSERT INTO taxonomy VALUES(1204,1861857,'Phytophthora','formosana');
INSERT INTO taxonomy VALUES(1205,1861858,'Phytophthora','x incrassata');
INSERT INTO taxonomy VALUES(1206,1861859,'Phytophthora','flexuosa');
INSERT INTO taxonomy VALUES(1207,1861860,'Phytophthora','intricata');
INSERT INTO taxonomy VALUES(1208,1862603,'Phytophthora','rhizophorae');
INSERT INTO taxonomy VALUES(1209,1862604,'Phytophthora','estuarina');
INSERT INTO taxonomy VALUES(1210,1869342,'Peronospora','mesembryanthemi');
INSERT INTO taxonomy VALUES(1211,1873451,'Saprolegnia','milanezii');
INSERT INTO taxonomy VALUES(1212,1880901,'Phytophthora','bishii');
INSERT INTO taxonomy VALUES(1213,1882210,'Pythium','cedri');
INSERT INTO taxonomy VALUES(1214,1884448,'Lagenidium','juracyae');
INSERT INTO taxonomy VALUES(1215,1891364,'Peronosclerospora','sargae');
INSERT INTO taxonomy VALUES(1216,1891365,'Peronosclerospora','australiensis');
INSERT INTO taxonomy VALUES(1217,1897510,'Phytopythium','sp.');
INSERT INTO taxonomy VALUES(1218,1897522,'Pythiogeton','sp.');
INSERT INTO taxonomy VALUES(1219,1903600,'Pythium','ershadii');
INSERT INTO taxonomy VALUES(1220,1903601,'Pythium','pyrioosporum');
INSERT INTO taxonomy VALUES(1221,1903602,'Pythium','urmianum');
INSERT INTO taxonomy VALUES(1222,1904033,'Halophytophthora','sp.');
INSERT INTO taxonomy VALUES(1223,1909805,'Pustula','junggarensis');
INSERT INTO taxonomy VALUES(1224,1910894,'Peronospora','aconiti');
INSERT INTO taxonomy VALUES(1225,1913598,'Phytophthora','formosa');
INSERT INTO taxonomy VALUES(1226,1926936,'Anisolpidium','rosenvingei');
INSERT INTO taxonomy VALUES(1227,1935391,'Hyaloperonospora','sp.');
INSERT INTO taxonomy VALUES(1228,1935936,'Globisporangium','lacustre');
INSERT INTO taxonomy VALUES(1229,1938505,'Phytopythium','sp. ''sterile''');
INSERT INTO taxonomy VALUES(1230,1938515,'Pythium','heteroogonium');
INSERT INTO taxonomy VALUES(1231,1938517,'Pythium','longipapillum');
INSERT INTO taxonomy VALUES(1232,1938518,'Pythium','oryzicollum');
INSERT INTO taxonomy VALUES(1233,1940654,'Paralagenidium','sp. MTLA-26');
INSERT INTO taxonomy VALUES(1234,1945754,'Peronospora','cf. ducometii');
INSERT INTO taxonomy VALUES(1235,1955676,'Globisporangium','oryzicola');
INSERT INTO taxonomy VALUES(1236,1971756,'Calycofera','operculata');
INSERT INTO taxonomy VALUES(1237,1971757,'Calycofera','cryptica');
INSERT INTO taxonomy VALUES(1238,1980703,'Halophytophthora','sp. GHJ-2017a');
INSERT INTO taxonomy VALUES(1239,1980704,'Halophytophthora','sp. GHJ-2017b');
INSERT INTO taxonomy VALUES(1240,1980705,'Plectospira','gemmifera');
INSERT INTO taxonomy VALUES(1241,1982524,'Aphanomyces','sp.');
INSERT INTO taxonomy VALUES(1242,1982665,'Peronospora','sp.');
INSERT INTO taxonomy VALUES(1243,1985165,'Phytophthora','castanetorum');
INSERT INTO taxonomy VALUES(1244,1985166,'Phytophthora','tubulina');
INSERT INTO taxonomy VALUES(1245,1985167,'Phytophthora','tyrrhenica');
INSERT INTO taxonomy VALUES(1246,1985168,'Phytophthora','vulcanica');
INSERT INTO taxonomy VALUES(1247,2013512,'Sclerophthora','sp.');
INSERT INTO taxonomy VALUES(1248,2014980,'Phytopythium','leanoi');
INSERT INTO taxonomy VALUES(1249,2014981,'Phytopythium','dogmae');
INSERT INTO taxonomy VALUES(1250,2017131,'Phytopythium','sp. SL-2017a');
INSERT INTO taxonomy VALUES(1251,2017132,'Phytopythium','sp. UZ612');
INSERT INTO taxonomy VALUES(1252,2017134,'Phytophthora','aff. capsici');
INSERT INTO taxonomy VALUES(1253,2017135,'Phytophthora','aff. cichorii');
INSERT INTO taxonomy VALUES(1254,2017136,'Phytophthora','aff. citrophthora');
INSERT INTO taxonomy VALUES(1255,2017137,'Phytophthora','aff. cryptogea');
INSERT INTO taxonomy VALUES(1256,2017138,'Phytophthora','aff. dauci');
INSERT INTO taxonomy VALUES(1257,2017139,'Phytophthora','aff. erythroseptica');
INSERT INTO taxonomy VALUES(1258,2017140,'Phytophthora','aff. hedraiandra');
INSERT INTO taxonomy VALUES(1259,2017141,'Phytophthora','aff. himalsilva');
INSERT INTO taxonomy VALUES(1260,2017142,'Phytophthora','aff. parsiana');
INSERT INTO taxonomy VALUES(1261,2017143,'Phytophthora','aff. pseudotsugae');
INSERT INTO taxonomy VALUES(1262,2017144,'Phytophthora','gondwanensis');
INSERT INTO taxonomy VALUES(1263,2017540,'Pilasporangium','sp.');
INSERT INTO taxonomy VALUES(1264,2019373,'Plasmopara','velutina');
INSERT INTO taxonomy VALUES(1265,2019374,'Plasmopara','destructor');
INSERT INTO taxonomy VALUES(1266,2020009,'Olpidiopsis','sp. YB-2017a');
INSERT INTO taxonomy VALUES(1267,2020010,'Olpidiopsis','sp. YB-2017b');
INSERT INTO taxonomy VALUES(1268,2020011,'Olpidiopsis','sp. YB-2017c');
INSERT INTO taxonomy VALUES(1269,2023236,'Phytophthora','aff. citricola');
INSERT INTO taxonomy VALUES(1270,2025988,'Nothophytophthora','amphigynosa');
INSERT INTO taxonomy VALUES(1271,2025989,'Nothophytophthora','caduca');
INSERT INTO taxonomy VALUES(1272,2025990,'Nothophytophthora','chlamydospora');
INSERT INTO taxonomy VALUES(1273,2025991,'Nothophytophthora','intricata');
INSERT INTO taxonomy VALUES(1274,2025992,'Nothophytophthora','valdiviana');
INSERT INTO taxonomy VALUES(1275,2025993,'Nothophytophthora','vietnamensis');
INSERT INTO taxonomy VALUES(1276,2028483,'Peronospora','aff. claytoniae');
INSERT INTO taxonomy VALUES(1277,2028484,'Perofascia','sp.');
INSERT INTO taxonomy VALUES(1278,2028485,'Peronospora','cf. viciae');
INSERT INTO taxonomy VALUES(1279,2036925,'Phytopythium','sp. AQ-2017a');
INSERT INTO taxonomy VALUES(1280,2047754,'Olpidiopsis','heterosiphoniae');
INSERT INTO taxonomy VALUES(1281,2051935,'Salispina','sp.');
INSERT INTO taxonomy VALUES(1282,2052682,'Globisporangium','ultimum');
INSERT INTO taxonomy VALUES(1283,2054050,'Phytophthora','balyanboodja');
INSERT INTO taxonomy VALUES(1284,2054051,'Phytophthora','condilina');
INSERT INTO taxonomy VALUES(1285,2054052,'Phytophthora','cooljarloo');
INSERT INTO taxonomy VALUES(1286,2054053,'Phytophthora','kwongonina');
INSERT INTO taxonomy VALUES(1287,2054054,'Phytophthora','pseudorosacearum');
INSERT INTO taxonomy VALUES(1288,2056922,'Phytophthora','x cambivora');
INSERT INTO taxonomy VALUES(1289,2056924,'Pythium','rishiriense');
INSERT INTO taxonomy VALUES(1290,2056925,'Pythium','alternatum');
INSERT INTO taxonomy VALUES(1291,2057904,'Peronospora','pseudostellaria');
INSERT INTO taxonomy VALUES(1292,2057905,'Peronospora','stellariae-aquaticae');
INSERT INTO taxonomy VALUES(1293,2057906,'Peronospora','stellariae-uliginosae');
INSERT INTO taxonomy VALUES(1294,2057907,'Hyaloperonospora','arabidis-glabrae');
INSERT INTO taxonomy VALUES(1295,2057908,'Hyaloperonospora','nasturtii-montanii');
INSERT INTO taxonomy VALUES(1296,2057909,'Hyaloperonospora','nasturtii-palustris');
INSERT INTO taxonomy VALUES(1297,2064827,'Phytophthora','aff. syringae');
INSERT INTO taxonomy VALUES(1298,2065305,'Phytophthora','humicola x inundata');
INSERT INTO taxonomy VALUES(1299,2065306,'Phytophthora','cf. megasperma');
INSERT INTO taxonomy VALUES(1300,2065307,'Phytophthora','cf. parsiana');
INSERT INTO taxonomy VALUES(1301,2069634,'Pustula','cancriniae');
INSERT INTO taxonomy VALUES(1302,2069635,'Pustula','xinyuanensis');
INSERT INTO taxonomy VALUES(1303,2077275,'Phytophthora','pseudolactucae');
INSERT INTO taxonomy VALUES(1304,2077276,'Phytophthora','lilii');
INSERT INTO taxonomy VALUES(1305,2093902,'Paralagenidium','sp. 1391');
INSERT INTO taxonomy VALUES(1306,2107226,'Phytophthora','oleae');
INSERT INTO taxonomy VALUES(1307,2108448,'Pythium','cf. salpingophorum/conidiophorum');
INSERT INTO taxonomy VALUES(1308,2125992,'Globisporangium','acanthophoron');
INSERT INTO taxonomy VALUES(1309,2125993,'Globisporangium','sp. MA-2018a');
INSERT INTO taxonomy VALUES(1310,2125994,'Globisporangium','orthogonon');
INSERT INTO taxonomy VALUES(1311,2125995,'Globisporangium','paroecandrum');
INSERT INTO taxonomy VALUES(1312,2125996,'Globisporangium','sp. MA-2018b');
INSERT INTO taxonomy VALUES(1313,2125997,'Globisporangium','sp. MA-2018c');
INSERT INTO taxonomy VALUES(1314,2125998,'Globisporangium','spinosum');
INSERT INTO taxonomy VALUES(1315,2126763,'Hyaloperonospora','erucae');
INSERT INTO taxonomy VALUES(1316,2126764,'Peronospora','erucastri');
INSERT INTO taxonomy VALUES(1317,2136986,'Leptolegnia','sp. BS1');
INSERT INTO taxonomy VALUES(1318,2136987,'Leptolegnia','sp. BS11');
INSERT INTO taxonomy VALUES(1319,2136988,'Leptolegnia','sp. BS13');
INSERT INTO taxonomy VALUES(1320,2136989,'Leptolegnia','sp. BS14');
INSERT INTO taxonomy VALUES(1321,2136990,'Leptolegnia','sp. BS16');
INSERT INTO taxonomy VALUES(1322,2136991,'Leptolegnia','sp. BS6');
INSERT INTO taxonomy VALUES(1323,2136992,'Leptolegnia','sp. BS8');
INSERT INTO taxonomy VALUES(1324,2136993,'Saprolegnia','sp. BF1');
INSERT INTO taxonomy VALUES(1325,2136994,'Saprolegnia','sp. BMF11');
INSERT INTO taxonomy VALUES(1326,2136995,'Saprolegnia','sp. BMF12');
INSERT INTO taxonomy VALUES(1327,2136996,'Saprolegnia','sp. BMF13');
INSERT INTO taxonomy VALUES(1328,2136997,'Saprolegnia','sp. BMF15');
INSERT INTO taxonomy VALUES(1329,2136998,'Saprolegnia','sp. BMF16');
INSERT INTO taxonomy VALUES(1330,2136999,'Saprolegnia','sp. BMF19');
INSERT INTO taxonomy VALUES(1331,2137000,'Saprolegnia','sp. BMF3');
INSERT INTO taxonomy VALUES(1332,2137001,'Saprolegnia','sp. BMF4');
INSERT INTO taxonomy VALUES(1333,2137002,'Saprolegnia','sp. BMF5');
INSERT INTO taxonomy VALUES(1334,2137003,'Saprolegnia','sp. BMF6');
INSERT INTO taxonomy VALUES(1335,2137004,'Saprolegnia','sp. BMF7');
INSERT INTO taxonomy VALUES(1336,2137005,'Saprolegnia','sp. BMF8');
INSERT INTO taxonomy VALUES(1337,2137006,'Saprolegnia','sp. BMF9');
INSERT INTO taxonomy VALUES(1338,2137007,'Saprolegnia','sp. BMS11');
INSERT INTO taxonomy VALUES(1339,2137008,'Saprolegnia','sp. BMS14');
INSERT INTO taxonomy VALUES(1340,2153462,'Phytophthora','cf. citricola/pini');
INSERT INTO taxonomy VALUES(1341,2153463,'Phytophthora','cf. niederhauserii');
INSERT INTO taxonomy VALUES(1342,2174906,'Aphanomyces','sp. SH-2018a');
INSERT INTO taxonomy VALUES(1343,2175193,'Pythium','aff. pachycaule');
INSERT INTO taxonomy VALUES(1344,2182428,'Crypticola','clavulifera');
INSERT INTO taxonomy VALUES(1345,2202004,'Dictyuchus','sp. 1 HM-2018');
INSERT INTO taxonomy VALUES(1346,2202005,'Dictyuchus','sp. 2 HM-2018');
INSERT INTO taxonomy VALUES(1347,2202006,'Dictyuchus','sp. 3 HM-2018');
INSERT INTO taxonomy VALUES(1348,2202007,'Dictyuchus','sp. 4 HM-2018');
INSERT INTO taxonomy VALUES(1349,2202008,'Dictyuchus','sp. 5 HM-2018');
INSERT INTO taxonomy VALUES(1350,2202009,'Dictyuchus','sp. 6 HM-2018');
INSERT INTO taxonomy VALUES(1351,2202010,'Dictyuchus','sp. 7 HM-2018');
INSERT INTO taxonomy VALUES(1352,2202011,'Dictyuchus','sp. 8 HM-2018');
INSERT INTO taxonomy VALUES(1353,2202155,'Paralagenidium','sp.');
INSERT INTO taxonomy VALUES(1354,2203415,'Albugo','tropica');
INSERT INTO taxonomy VALUES(1355,2203424,'Olpidiopsis','drebesii');
INSERT INTO taxonomy VALUES(1356,2203427,'Miracula','helgolandica');
INSERT INTO taxonomy VALUES(1357,2268959,'Saprolegnia','maragheica');
INSERT INTO taxonomy VALUES(1358,2292440,'Phytopythium','sp. 1 JJC-2018');
INSERT INTO taxonomy VALUES(1359,2305848,'Brevilegnia','sp.');
INSERT INTO taxonomy VALUES(1360,2306272,'Dictyuchus','sp. 10 HM-2018');
INSERT INTO taxonomy VALUES(1361,2306273,'Dictyuchus','sp. 11 HM-2018');
INSERT INTO taxonomy VALUES(1362,2306274,'Dictyuchus','sp. 12 HM-2018');
INSERT INTO taxonomy VALUES(1363,2306275,'Dictyuchus','sp. 13 HM-2018');
INSERT INTO taxonomy VALUES(1364,2306276,'Dictyuchus','sp. 14 HM-2018');
INSERT INTO taxonomy VALUES(1365,2306277,'Dictyuchus','sp. 9 HM-2018');
INSERT INTO taxonomy VALUES(1366,2306489,'Basidiophora','sp.');
INSERT INTO taxonomy VALUES(1367,2358452,'Lagenidium','sp.');
INSERT INTO taxonomy VALUES(1368,2358464,'Olpidiopsis','gillii');
INSERT INTO taxonomy VALUES(1369,2483409,'Nothophytophthora','sp. Chile5');
INSERT INTO taxonomy VALUES(1370,2492455,'Miracula','moenusica');
INSERT INTO taxonomy VALUES(1371,2496075,'Phytophthora','aleatoria');
INSERT INTO taxonomy VALUES(1372,2507044,'Dictyuchus','sp.');
INSERT INTO taxonomy VALUES(1373,2507514,'Bremia','itoana');
INSERT INTO taxonomy VALUES(1374,2517218,'Paralagenidium','ajellopsis');
INSERT INTO taxonomy VALUES(1375,2575701,'Phytophthora','chlamydospora x amnicola');
INSERT INTO taxonomy VALUES(1376,2579937,'Phytophthora','cf. citricola');
INSERT INTO taxonomy VALUES(1377,2603265,'Pythium','aff. attrantheridum');
INSERT INTO taxonomy VALUES(1378,2603266,'Pythium','aff. cederbergense');
INSERT INTO taxonomy VALUES(1379,2603267,'Pythium','aff. rostratum');
INSERT INTO taxonomy VALUES(1380,2603268,'Pythium','aff. undulatum');
INSERT INTO taxonomy VALUES(1381,0,'synthetic','construct C1');
INSERT INTO taxonomy VALUES(1382,0,'synthetic','construct C2');
INSERT INTO taxonomy VALUES(1383,0,'synthetic','construct C3');
INSERT INTO taxonomy VALUES(1384,0,'synthetic','construct C4');
CREATE TABLE its1_sequence (
	id INTEGER NOT NULL, 
	md5 VARCHAR(32), 
	sequence VARCHAR(250), 
	PRIMARY KEY (id), 
	UNIQUE (md5), 
	UNIQUE (sequence)
);
INSERT INTO its1_sequence VALUES(1,'980e9fec07c0a30e566ea39832d23e56','CCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(2,'c5e9f1b490c4460e4bacbc38375d1247','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3,'cbba1048d56b95024d0c52f40d28bf3c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(4,'0712f0304dbba3c6f3920a6f4c3fd27a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(5,'f268199c80febde21c5d04a43de06fc7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(6,'719f40055d5bbbb2e66a709cd8405089','ACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(7,'22ae0e46eb98104686ac3365dd9dec85','CCACACCTAAAACTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTAAACCCATTCCGAACTACTGAACCATAC');
INSERT INTO its1_sequence VALUES(8,'0c3931da51a6044ab3e7f1f6293def02','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(9,'6174f93351c5dae139596dd9bfa0fe46','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(10,'6f0cff54e4360da752e8c83822523202','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(11,'525a3661cd8bda8cbdc7484fc10694c2','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(12,'3c4155c6359604e463ac2f4e5a2b34a2','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(13,'a08775e6912465fea86f48d01b08db41','CCACACCTAAAAAACTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(14,'ad7a0a890e3133a9a203f1481b5c9917','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCATTTTAAACTCATTCAATAATATACTGAACATACT');
INSERT INTO its1_sequence VALUES(15,'9ad832693b5c5832e1081f6b77396622','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(16,'3f521bb5945bbc319227361d93c0d7b4','CACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCTTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACCCAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(17,'f5d2057006c0e3511c1b39c0be67234c','CCACACCTAAAACTTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAACCATAC');
INSERT INTO its1_sequence VALUES(18,'df02db00df453e2bc7df425c835ba48c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(19,'0a3d7eea3d524edb9a5df0f454be89d7','CCACACCTAAAAAACTTTCCACGTGAACCGTTAAAAAACTAGTTGGGGGCTCCTCGTTGGCAGTTTCGACTGTTAGTGGGTTGAGTTCTATCAAACGATCGATTTGGGCTGCAAAGTCGGAATTGAGAGTTTCTTTTTTAAACCCATTACTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(20,'2b8e7a64e493e5c191e92f21596b4256','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(21,'80891abd03ae483240281bf586d79d5a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGCTTCTGTTCGGCTGGCTTTTGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGTCTTCTTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(22,'2b08a5f633adfd3da3c3244768ca7fec','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(23,'34d9d73bbfa15fed070bfc2e3488439d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(24,'eaf42569c8b95c8bf4f9bf1b65a96ce4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(25,'e676955541771aa079f8df2b42434244','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(26,'bf4a60b0145cdf1e8a75ae64a7af8507','CCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(27,'2929ee2d94b2b2d23829e7f3f05472c4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(28,'462cf71f3d70fcc507b068772f2c0c9f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGATGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(29,'e891f7704c69a08fca0857b10e4405a9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGTAGGCTCTATCGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATTAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(30,'befad40d083bec4f9b9429ac3d785d42','CCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTAACTTTGTAAACCCTTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(31,'d55e0766deed1eb84a3b4dbea1984238','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(32,'ea751db251437905bbe528dae16315a5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(33,'db57a319bcca7afb842443b1cd34e63c','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(34,'9e8f051c64c2b9cc3b6fcb27559418ca','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(35,'ec8a23ee0ea436218120d41bc97acc15','CCACACCTAAAAAACTGTCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGGGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTCCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATAC');
INSERT INTO its1_sequence VALUES(36,'a26540b661da0669ed602b193bb52b49','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGTGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(37,'7c2695c56bc0f1120274427544a24f55','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(38,'f06499c4defb475e5ca5da06c9ada23e','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTCATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(39,'2ddda9f735fe02f701050bb4c7f7a017','CCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGATGTTGGGGGCTGGGCTGGCGTTTGTTCGTCGGTTGGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTTTAAGTTTTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(40,'150e9358daed8561d292a4abc5b3d76a','CCACACCTTAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGATTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(41,'593c97a6e7398518a955ffd767c5a51e','CCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(42,'fbc6fcd7e66bed1a036f142df6dfd8ba','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGGCTGGGTGGCGGCTCTATCATGGCGACCGCTCTGGGCTTCGGCCTGGAGTTAGTAGCTCACTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(43,'794edee98bcbc94cf10f0dca7ebd6d5c','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(44,'7df3bf6d032335fb3bdfc48b4d8f9139','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(45,'f1506ffab388e3ff301a2481ddc8f1e8','CCACACCTAAAAACTTCCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTCTTTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(46,'07a58d5162a967d5a6683831a6c5ff8e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(47,'ad818f5c2cb3b67396be2190b5b64273','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(48,'e44b850550f84b1cd788cc985ae67e52','CCACACCTTAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGACTCCTTGCTAGTGTGCTTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGACTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(49,'8bae16e348c81b1ea88233aafd0e2f45','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(50,'365ce375e47cf6eb8f6dc880d21f67b1','CCACACCTAAAAAACTTTCCACGTGAACCGTATTACCACCCAGTTGGGGACTCTCTGTTGGTGGTTGGGGCTGGCTAGCGCTGGCTTTGACTGTCGATGGGTTGAGACCTATCAAACGACGCGTTTGGGCTGCAAGGCCTGAGTGTTGTCTGTTTCTCTTGTAAACCCATTTCTAAAAACTGAATATACT');
INSERT INTO its1_sequence VALUES(51,'a86f24bdd6d1842ef3ac39f2f5b171cf','CCACACCTAAAAAAACTTTCCACTAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(52,'5dfdb6cbb0a00156a974337c2e939e7c','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(53,'dbd1f2bed757ef347ad9c52e417791e5','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(54,'7b892415d41ad9ae38657642816d8434','CCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(55,'982bd781b8363a701875761a5e620622','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(56,'37ee66b3ee1603fe2d48d3faca659268','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(57,'fa93530802067877d700cc90c3173fba','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTGGGGGTCTTGCTTGGTGTGCGGCTGGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGCCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTATTTTTAAACCCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(58,'95ad5307ccfb777d7c554933fdc153d7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(59,'6844d9a2a4b3170bfed0b5b40e354d34','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTGTTTTAAACCCATTTCACAATACTGATAATACT');
INSERT INTO its1_sequence VALUES(60,'8707e10ad8f963095d7690908d7bc023','CCACACCTAAAAAACTTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGTCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(61,'29343a17e15a432d81aaf0d27ca3f9d9','CCACACCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(62,'e20b78caaa69e8d6890cdbe4b974985e','CCACACCTAAAATATTTCCACGTGAACCGTTTCAACCAAAAAAATTTGGGGGTCTTGTTTGGCGGCGGCTACTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTAACGCGAAAGTTTAGACTTCGGTCTGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(63,'d4a052b770b5e74c629e6291675accd4','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACTCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(64,'91a38e24a13e11c51a527d91f1623e03','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACCGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(65,'9e61afd307bc62163e5672ab8e7898e5','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(66,'96f5454ca3692f81977bfff75a557f5b','CCACACCTAAAAAACACTTTTCCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(67,'5dbdc2578f089afaf903039a0128c520','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(68,'5122dde24762f8e3d6a54e3f79077254','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(69,'9ade309821cf8cdf93b701944a357ee7','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(70,'2314aa26f1c544e8f549159d657c447b','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTGTTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(71,'cdb9f7305c0bd86b7ea817de2767ca93','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(72,'763616e0c55ed2e52ad4bdaadf69c3d1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(73,'75415d58ea015b1e6f99c8f798d5e7cc','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(74,'6803c088eb1e53bb2e44bffecbaa0fdd','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(75,'0f9802179910685462de58b962f93822','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTCAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(76,'ea0d1b4619e6f692916582819da0b440','CCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGTCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(77,'efc5cfc793421779caf4635e7fee7916','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(78,'232c0397f921878f730c8a0c4f14fbf1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(79,'0ee525e2775c6477dfac46999fa46bbb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(80,'317ed67556ddb70b4bad8633226c087b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGAGCTTTCGTCTGGCCGGCCGGCTTTTGGCTGGTTGGGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(81,'d641674c9256311bc04156d61e42e90f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAAAACTGAACATACT');
INSERT INTO its1_sequence VALUES(82,'76c4afb590f2e0b68074eb14bf4aae55','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(83,'0701cd8ca3190c2a577a94f14af1bbba','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(84,'90af9efe656ccbae156a12334e2b2831','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(85,'100daeac2033cfa5578d5dcd33d3f511','CCACACCTAAAAAAACTTTCCACGTGAACTGTATCAACCAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGTTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(86,'a0a58165fa44ea01d82d93a36ea9d904','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(87,'afade6db5b603dc96278d94aff50c0b9','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(88,'0d7e198eb09de1f6cd25af2ec1e07465','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(89,'ad240a8165454651b8ab686cf05e1b64','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(90,'b2b4b857d5c7962d6981b7f5251a58ed','CCACACCTAAAAAACTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(91,'9aad9f9d70e14d727a03fc76c7f0bd9d','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTTCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(92,'29bf7cc29246eb4908b074dd1b4a2ee1','CCACACCTAAAAAACTGTCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGAGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTTCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATAC');
INSERT INTO its1_sequence VALUES(93,'be5d4dea7a82e2274db49501b887cc8c','CCACACCTAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(94,'1160e5ab7fdd0189461f9ba0f3b5821f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(95,'86a569580f4f3a164400eb7d22ac8f99','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(96,'7c335e9cb08d8ec4619d28e0c0215b5d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(97,'ffb8fbb83fa26a101c2fddf2af13cf95','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAATCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCGCTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(98,'4d9648816160bb50f00b10a3c0c35a3b','CCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATAC');
INSERT INTO its1_sequence VALUES(99,'2b8fedf163d883035a076d47488fba84','CCACACCTAAAAAACTTCCCACGTGAACCGTATCAACCCTTTAATATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAATTACTGTAATAC');
INSERT INTO its1_sequence VALUES(100,'e30266ab31c5e8cd7c540e67c451b6dc','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTATTATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTTAAACCCATTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(101,'8e1e843860a8433d3910c6ee8d1bc4bf','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGGCTGCTGCTGCTGCTTCGGTGGCGGCGTGCTCCCATCAAACGAGGCCCTGGGCTGCAAAGTCGGGGGTAGTAGTTACTTTTTGTAAACCCTTTTCCTGTATTTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(102,'42df4f979e4c348f6d6c3e515a266c2b','CCACACCTAAAAACTTTCCACGTGAACTGTATTGTCTGTTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCTGGGGTAGTAGTTACATTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(103,'1bf4866df697f78bfc242eff225ed740','CCACACCTAAAAAACTTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(104,'a935bc95fa4748d56d76bdd91c534df5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(105,'26e7c7783e8afa76a62e0af7a31e59e1','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTGCTTGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTTAAACCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(106,'4ed3c2ecd546ab52aa34ef3f9fcd7dab','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(107,'35121de1fff8a12907aa14a67e7409ee','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGTTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(108,'c0a2ac9f5bebb6a682afd9d0ae745171','CCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(109,'cf41a6013fba34f90c8ccfe4e3ef3ca2','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTACTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(110,'a6de7a6dd87e36944d306d590b754b8b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(111,'0800f46e751d919d9331191c30ec81a9','AAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(112,'56094be45f3e7d4fb226cff6903a7ca5','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(113,'a559aa4d00a28f11b83012e762391259','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(114,'66584c744c0d0f9c4d3a655512221d7f','CCACACCTAAAATTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAACCATAC');
INSERT INTO its1_sequence VALUES(115,'ff62de5d2cda18374828ea19674b9e06','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTTCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(116,'3529f3cc48f335df64870915b7b41edb','CCACACCTAAAAATTTCCACGTGAACCGTTTCAACCCAAAAAATTGGGGGTCTTGTTTGGTGGTGGCTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGATGAGCCCTAACGCGAAAGTTTAGACTTCGGTCCGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(117,'af3654932ad7a06c5f4af3c738706c76','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(118,'d8786b78097044326b6dd2b917750db8','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(119,'2018643edf769f3be37aa89b6902dc7c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGAATGAGCCCTATCATGGCGAGCGTTTAGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(120,'cdbd8d36c22d9ddea25658bf3ca1525e','CCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCTTCAAATCGAGGGCTTGCTCGGCGGTGGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTGAATAACTGAAATAC');
INSERT INTO its1_sequence VALUES(121,'0b34d6377cbcab37b5236cde043db9fd','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(122,'97b28b7cc79cf5fa7d9bd57750f19fd8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(123,'f6f37f390d693320390edba8a949cb4d','CCACACCTAAAAAACTATCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGAGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTCCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATAC');
INSERT INTO its1_sequence VALUES(124,'2b8652c49d748f4a106c3a600b827272','CCACACCTAAAAAACTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(125,'e936b0512a1cee5d0363e840b0ad553f','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(126,'93058b06e59eab3c0c8abd087b821b23','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCAAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(127,'2b199c95189a60fc531d1787b015028c','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(128,'75299449acf0c73376b38f5203e6db38','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(129,'8ab45a4d9960869e5f1f7fd4fce84262','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(130,'190617e32eec7a67ebcefd2b7eff3bf3','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(131,'a63b98bc92cfbca4e4dce5989b605b24','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(132,'f3a4567aa9e5033acbf851fbc0ed4376','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(133,'986a833a86a4f0a750df7c30261babc6','CCACACCTAAAAAACTTTCCACGTGAACCGCATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(134,'f21947a21986b3c72466d0974b28d3b0','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(135,'e2574b4904a183c5f2212bbd93310786','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGAGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(136,'791003473ab97eded747c88f093f9453','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCGCTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(137,'7f27d3a8f7150e0ee7ad64073e6da6b5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCTTGAGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(138,'b017372183f8bda347de07647c49bc8a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(139,'47f1ae35f9e647433b6ab4af27144bcd','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(140,'b831dfeddd1d11a31991ce8953001a61','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(141,'b4213ed5419ffe12554e936ab2108c8d','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(142,'15eb76e6c319cff36f5ccb4f2ec22326','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAGTTGGGGGTCTTGCTTGGCGTGCGGCTGCTGGCCTTTATTGGTTGGCTGGCTGCGTGCTGGGCGAGCCCTATCATGGCGATCGTTTGGACCTCGGTCTGAGCTAGTAGCTTTTGTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(143,'c7683aa1157672f6e555163acf02b5f9','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACACCCTTAGTTGGGGGCTGCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(144,'9577aa1a6c2da294ebbfa5c84cff65aa','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(145,'321837425b87665e7f06282308704ac8','AAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(146,'2088a3a2d3b5bc07eb1e3a2a4c1677d9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCACCTAGTTGGGGTTCTCGGTAGCCGTGTGGCATGTGGACTCGTTCTACGTGCTGCTGGCGGCTGAGACCTATCATGGCGAGCGTTTGGGCTTTCGGGCCTGGATTAGTAGCCCTCTTTTAAACTCATTCTGTAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(147,'806e8f5e903d0c5cce976b5db5dd25de','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(148,'f9d2b4805bee73b2eb89a96e82c0ad01','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(149,'40542cc3039e5fbb1eeb0e576cda383c','CCACACCTAAAAAACTTTCCACGTGAACCGTTAAAACTTTAGTTGGGGACTCCTCATTGGCAGTTTGTTCTGTTGGTGAGTTGAGGCCTATCAAACGATCAATTTGGGCTGCAAAGTCGGAGTTGAGAGTTTCTTTTTTAAACCCATGCTTTTATTACTGAAAATACT');
INSERT INTO its1_sequence VALUES(150,'59a829338bc84a0cb54872095965dea7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(151,'d79faa46fcb5623f00f35a5118ae7c0d','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(152,'9ae5bfe4a2b1b984c840257b94addcfd','CCACACCTAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(153,'d13307e6f5a198db1519323d8561b11e','CCACACCTTAAAAAACCATCCACGTGAACCGTATTGTCAAAACATTTGGGGACTCCTTGCTAGCGGGCTTTCGGGCTTGCCGGTCGGTTGAGACCTAACACGAGAGCCTTGGCTGAAAAGCCGGGGTGAGTAGTTTCTTTTTAAACCCTTTACTAAAAACTGAAAA');
INSERT INTO its1_sequence VALUES(154,'213078ce5a17705827465b0d3dafaf2a','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(155,'51443865032d8211ace3505685cb117f','CCACAACTAAAAATTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(156,'fd8dbba570bfaef625f30f59f9c084cd','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCATGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(157,'0b19d00f153b346a1b2f404da3913307','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(158,'c453a349db27bd5f507b8b0714a20b7a','CCACACCTAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(159,'c38eede78b16a616f16cfcb835e942fc','CCACACCTAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(160,'5a637be438643dd0d19f4ec554492ce3','AACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTGCTGTTTTTTTAATGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(161,'e034b6cf4c365a75c22a161da44a6742','AAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTGCTGTTTTTTTAATGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(162,'0756791b46adb524e7ddb59e8ba20921','CTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGATCTTAATGGAGGCTACTGGTCATTTTTGACTGGAGGCTACTATCGAGTGAACTTCATCATGACGAAAAATTAGGCTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(163,'71d4e062275062a6ed3863c71f137e77','CTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(164,'20ee7ddec1302520941e932cf1ae0b6a','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGATCTTAATGGAGGCTACTGGTCATTTTTGACTGGAGGCTACTATCGAGTGAACTTCATCATGACGAAAAATTAGGCTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(165,'9c304bf46e6f6730035a08ada530ffd2','CTAAAAAACTTCCACGTGAACTGTATCAACAATTTAAATTGGGGATGATCTTGGTGATGACTACTGGTCTTTTGACTGGTGACTATTACTGGGTGAATCTCATCATTTCGAACYATYGGACTTTGTCTGGTGTAGTAGTGTAAAAATTATAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(166,'d15c4b92d315466abdb47a7fd515f534','CCACACCTAAAAACTATCCACGTGAACTGTATCAACAAATTATAATTGGGGGTGATCTCGGTAGTGGCTACTAGTCTTTTGGCTGGCGGCTATAACTGGGTGAAGCTCATCATGGCGAATCATTGGGCTTCTGTCTAATGTAGTAGTGAAATTTTAAACCCTTACTTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(167,'272a8e2bab11e186569657720f914798','CACGTGAACTGTATCAACAAATTATAATTGGGGGTGATCTCGGTAGTGGCTACTAGTCTTTTGGCTGGCGGCTATAACTGGGTGAAGCTCATCATGGCGAATCATTGGGCTTCTGTCTAATGTAGTAGTGAAATTTTAAACCCTTACTTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(168,'c08039b03aa30757c78af369cca2d4f0','TAAAAACTATCCACGTGAACTGTATCAACAAATTATAATTGGGGGTGATCTCGGTAGTGGCTACTAGTCTTTTGGCTGGCGGCTATAACTGGGTGAAGCTCATCATGGCGAATCATTGGGCTTCTGTCTAATGTAGTAGTGAAATTTTAAACCCTTACTTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(169,'11454b0acd59c6c6fed638394fc708ec','CACGTGAACCGTATCAACAATTATAATTGGGGGTGACCTTGGTAGTGGCTACTAGTCTATTTTGGCTGGTGGTTATAACTGAGTGAGCCTCATCATGGCGAAAAGTTAGACTTTTGTTTAACCGAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(170,'439e5f5f825391e72e902ba1672c7371','CCACACCTAAAAACTTTCCACGTGAACTGTATAAACCAAAATTTGGGAGTTTATAAGGTATATACTGCTAACATTTTTATATGCGGTTAATACTTTATAAACTCTATCATGGCGAATGCTTGGATTTCGGTCTAAAGCTAGTAGCTTTTTTAAACCATTAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(171,'630f2a74ff07e5344c4971b361367780','CCACACCTAAAAACTTTCCACGTGAACTGTATAAACCAAAATTTGGGAGTTTATAAGGTATATACTGCTAACATTTTTATATGCGGTTAATACTTTATAAACTCTATCATGGCGAATGCTTGGATTTCGGTCTAAAGCTAGTAGCTGTTTTAAACCATTAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(172,'02ca1b1d52b86ff31712a5b38dc41306','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(173,'a6434c6c9a5e94ca2f73c39946d47588','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCGGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(174,'2418402042ce3cb61fbb86e2fa3c6fdc','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCRACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(175,'453ec34bcc7ee370593e5f1194a8a4a9','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAACTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(176,'53b513a8f00852e4ca5bec4f624fec1a','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(177,'de55bd5f798ae179ddb8027ed899fe95','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCTCCTGGTGATCGTTTCGACCTTTGGTTGGAATTAGTAGCTAAAAATTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(178,'5d134c0fa6979617eac04db6b52625f5','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTACAGACTTTATTAGTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(179,'77f85a8f97248c50d3894f4fd26ab5ba','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTACAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(180,'f90d45d9014419a1a4aee83536d902d5','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAATTTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(181,'953d310a51258647185a119947e2ad59','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(182,'2a05fd6e930857ecf7ef79b7d6772ea2','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGTGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(183,'045635fe0b1707741a2ee38f5dcd4998','CCACACCTAAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGACCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(184,'6489247f1e67a8c697211bcd09e5abae','CCACACCTAAAAAAAACTTTCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAACGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(185,'b5f13488982487344c85d20c823f6dd0','CCACACCTAAAAAAAACTTCCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAATGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(186,'b75711f2f69385d475423e38a47a9ae6','CCACACCTAAAAAAAACTTTCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAATGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(187,'8dd762a01f061a7af1e79ff5c3f8bd0f','CCACMCCTAAAAAAACTTCCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAATGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(188,'fc2f06b474b8e71033eb6247632352e7','CCACACCTAAAAAAACTTCCACGTGAACCGTATCAAATTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAACGTTTCGACTTTTGTTGAAATGAGTAGCTAAATTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(189,'43fc8607c8bbf3f7e2482cb0806940c9','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAACTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAGCATTTCGACCTTGGTTGAAATGAGTAGCTAAATTTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(190,'2f037054855d4a734b73939de35ada3e','CCACACCTAAAAAAACTTCCACGTGAACTGTATCAAACTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAGCATTTCGACCTTGGTTGAAATGAGTAGCTGAATTTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(191,'1259af67c2bcba897129b1624011e7be','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCAACCTTGGTTGAAATTAGTAGCTAAACTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(192,'b13875d2ec88a7c32a680d7e8a5cb7c7','CCACACCAAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGTGATCGTTTCAACCTCGGTTGAAATAAGTAGCTAAATTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(193,'fc51eaf93d6c93a382d2f7d1f2b281be','CCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAGTTGGGGACAATTCGGGCGGCGACTGTAGACTTAATTGTCGGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTTGGTTGAAGTTAGTAGCTGAATTTTTAAACCTTTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(194,'f1ef4e93a3355b1c83a1d3ca3506ba3b','CCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAGTTGGGGACAATTCGGGCGGCGACTGTAGACTTAATTGTCGGCGGTTGCTGCTAGATGCGTCCTATCGTGGCGATCGTTTCAACCTTGGTTGAAGTTAGTAGCTGAATTTTAAACCTTTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(195,'f5079f850ddcbae9ffd92187890f9f84','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(196,'dce7ad80662139708b461a1a316e6069','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACTTCGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(197,'1a8cc17d70b447d2ba5ee22f7864b0e3','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCGACCTTGGTTGAGATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(198,'351d7e9306b8989608ce48ece7b6167f','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATTGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(199,'f633fb81b8abd9063d85f88224c9f532','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTTTTGTCAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(200,'27f33a86e7bfa971d32f559b14968155','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATCGTTTCAACCTTGGTTGAGATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(201,'996459a66b59603e24804efbedb3060d','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(202,'122b03567ed55d6485e9e13ac5766ffb','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTACTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAGATTAGTAGCTACATTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(203,'f719b81a9af64ce6c68cb42272aafe38','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCGACCTTGGTTGAGATTAGTAGCTACATTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(204,'92a444c9b1ea063b244e32df959ed61c','CCACACCTAAAATCTTTCCACGTGAACCGTTTTGTGTAATAGTTGGGCTTCGCTGCCTGGCAGTCTGCGCTCGCAGTCTGTTGGAACGCTTGAGGCTATCAAGTGGGTGTGTGGTCTGTCGCTCTCGGGCGCGGGTCGCACTTCCGCTTCTGTTTGAACCCATACTTAACTTCTGAACATACT');
INSERT INTO its1_sequence VALUES(205,'ad6d645fc31c38517aaf4e5c4e33f145','AGTTGGGCTTCGCTGCGTGGCAGTCTGCGCTCGCAGTCTGTTGGAACGCTTGAGGCTATCAAGTGGGTGTGTGGTCTGTCGCTCTCGGGCGCGGGTCGCACTTCCGCTTCTGTTTGAACCCATACTTAACTTCTGAACATACT');
INSERT INTO its1_sequence VALUES(206,'d2a3c4de7110154bb70b388bb4047ac5','CCACACCTTAAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTTTTTTGATTGGCTGGCTGCTACTTTGTGAGCTTCATCATATCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTATTTTAAACCATTACTTCATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(207,'c6b37de0f57080a61c91b9b1ca74dfca','CCACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGCGACCTTGGTTGGTAGTTATACTAGTCATTTTTGGCTGGCGGCTACTACTGGGCGAGCCTCATCATGGCGAACCATTGGGCTTTGGTCTGATGTAGTAGTATCAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(208,'c72959b240c163fdcc1444d91ea7b416','TAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGCGACCTTGGTTGGTAGTTATACTAGTCATTTTTGGCTGGCGGCTACTACTGGGCGAGCCTCATCATGGCGAACCATTGGGCTTTGGTCTGATGTAGTAGTATCAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(209,'fa6b522e153ebd7673cc9da788dfceaf','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTAAATTGGGAGTGATCTTGGTAGTATTCTACTAGTCTATGACTGGCGGTAACTACTAGGTAAAAACACTTCATCATGGCGAACTATTGGGCTTTTGCCTAATGTAGTAGTGTAAATTGTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(210,'39b9da5c1cc2ffc256e1f364103da622','TAAAAACTTTTCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTTTACTGGCGGTAACCATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGCCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(211,'7068ec71a49ff122f544fbc8db1f5b84','TAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTTTACTGGCGGTAACCATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGCCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(212,'205c6038984b07895a731db53953ed54','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGCGATCTTGACGGTAGCTACTGGTTTTTTACTGGCGGTAACCATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGCCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(213,'5db3748c5dacd70c417d1f291ff6b6f7','CACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTTTACTGGCGGTAACCATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGCCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(214,'e29a4c3d458c94842a8dc420dcfe946e','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTTTACTGGCGGTAACCATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGCCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(215,'973fc001bf5fe682f8c05baf0c16f8ca','TAAAAACTTTCCACGTGGACCGTTGCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTCTGTGAGCTTCATCGTGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(216,'e91f485a28f58a56cb06ec1c6ed87d12','AACTTTCCACGTGGACCGTTGCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTCTGTGAGCTTCATCGTGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(217,'856a782030ef38e61fde9f6657be1c30','AAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTCTGTGAGCTTCATCGTGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(218,'b15442193b49e5f5ff52d6ae63cdc11f','AAAACTTTCCACGTGGACCGTTGCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTCTGTGAGCTTCATCGTGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(219,'abc5c2133a6a943be273a12c246396ae','CACGTGGACCGTTGCACAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTCTGTGAGCTTCATCGTGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(220,'36735b1a200345a40703f46ec45b451e','AAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGACAATGATCTTGGTGGAGGCTTCTAGTCTTTTGGCTAGCTGTTCACTACTATAAGTGAGTCCTATCATATCGAACCATTAGACATGAATTTGTCATATGAAGTAGAAGAAGTTATAAACCCTTACCTAATTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(221,'0e38388566f132f20ccdf03b3cb031d1','CTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGCGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGACGAAAAATTAGRCTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(222,'7793f0814b4c4c0f724f7692459f3587','CTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(223,'33627a510d3e295c4026c1375b8c357f','CCACACCTAAAAAACTTTCCACGTGAACCCGTATTAACAATTATAATGGGGGGCGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGACGAAAAATTAGACTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(224,'d33c36e493629ddc66caf64a0e92a887','CCACACCTAAAAAACTTCCACGTGAACCGTATTAACAATTATAATTGGGGGCGATCTTAATAGAGGCTACTAGTCATTTTGGCTGGAGGCTACTGTCGAGTGAACCTCATCATGACGAAAAATTAGGCTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(225,'2efe1621290208baf5035c8fd6327da3','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAAWTATAATTGGGGGCGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGACGAAAAATTAGACTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(226,'320df1a347406a2eb13fbe329264ceb1','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(227,'e79c3379a070a89222b030a351354a7b','ATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAATTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(228,'8cf580c76e0bd142da13bd5c24b5a080','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(229,'b36ebefe04f8be3391d9b6cb4ef8391e','GTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(230,'5673ac2ed39197f80cc594b5636deb4f','CACACTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(231,'5cca9de4d189d5e56843e99f70ffeaa3','ATCTTGGCTGGAGGCTACCATCTGGTGAACCCCATCATGGGAAAAAATTAGGCTTCGGTCTGGTGAAGTAATGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(232,'12e35a5727f277857ff5d90756b5ca22','CCACACCTAAAAACTTTCCACGTGAACCGTATTACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGCGGCTACTATCGAGTGAATCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(233,'525e6e202bd4f9869d48c60ef8be3e3d','CCACACTTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATGGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(234,'940ce3042e81368bb1701c651c7477d7','CACTAAAAAACTTTCCACCTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(235,'db8115bdf05918b9a4c4156f462baf13','CCACACTTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(236,'13ffc31e79363ae8c2075fa2273ac16c','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATGGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(237,'cb6a25ef1502309f9a592da3f296a86c','CACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATGGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(238,'49c4a20d5f2943c7d3d09da72a1d3f86','CCACACATAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(239,'fba60ed0dbf51043e4cb14b692c8ecb1','CACACTAAAAAACTTTCCACGTGAACCGTTTTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(240,'611e4fd2f269fdf8187d01869812ae91','CACACTAAAAAACTTTCCACCTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(241,'3d4d57092ef166791332124b26940374','CCACACTTAAAAACTTTCCACGTGAACCGTATTACCAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(242,'b1873ec38da68614119886f29597f78b','CCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATGGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(243,'a769b7cedc2e85254228c84a6b01f5dd','CCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(244,'304b161c249ef940fba657b712b3c05a','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGAGTCGTGATCTTGGTGACATCTACTAGTTTATGACTGGTGGTAACTACTAGGTGAACTTCATCATGACGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATT');
INSERT INTO its1_sequence VALUES(245,'f8a7f7a75b4a97850b93ff1aa297a8b4','AAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGAGTCGTGATCTTGGTGACATCTACTAGTTTATGACTGGTAGTAACTACTAGGTGAACTTCATCATGACGAACCATTGGGCTTTTGTCTAATGTAGTAGTATTAATTTTAAACCCTTACTTAATTACTGATT');
INSERT INTO its1_sequence VALUES(246,'19279e677a87b51e5560b3f52afaf503','TAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGAGTCGTGATCTTGGTGACATCTACTAGTTTATGACTGGTGGTAACTACTAGGTGAACTTCATCATGACGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATT');
INSERT INTO its1_sequence VALUES(247,'8ac3e3f4ef36315738048ffc894490d4','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGAGTCGTGATCTTGGTGACATCTACTAGTTTATGACTGGTAGTAACTACTAGGTGAACTTCATCATGACGAACCATTGGGCTTTTGTCTAATGTAGTAGGTATTAATTTTAAACCCTTACTTAATTACTGATT');
INSERT INTO its1_sequence VALUES(248,'733bdf0aa0032cb39896687d0482cf9b','CGTATCAACAACTTTAATTGGGAGTCGTGATCTTGGTGACATCTACTAGTTTATGACTGGTAGTAACTACTAGGTGAACTTCATCATGACGAACCATTGGGCTTTTGTCTAATGTAGTAGTATTAATTTTAAACCCTTACTTAATTACTGATT');
INSERT INTO its1_sequence VALUES(249,'2b8ba6ed7e6a288d544bd4c639faed5a','CCACACCTAAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGACTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(250,'c65d9ab0cd39fa87f955899020431784','CCACACCTAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGACTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(251,'2f4e7e74c405014fcaf389b5413f7a82','AACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTAGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCTTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(252,'09b189321f88eb118258b42c1c1a36f8','TAAAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTAGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCTTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(253,'0c1eba4153eb664c49580df9f798ab0f','CCACACCTAAAAAACTTTCCACGTGAACCGTATTCAAAAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(254,'5188efa4944aa454fcd66b34d09aa704','CCACACCTAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(255,'e5eb0ef084bb911ac7d93f2b97ab046a','TAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(256,'410e55cf09ae0f543d53d1137953e481','TAAAAACTTTTCACGTGAACTGTATCAACAAATTATAATTGGGGGTGATCTTGATGGTAGCTACTAGTCTCTGACTGGCGGTAACTATTGGGCGAACCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGAAGTAGTAAATTTTAAACCCTTACTTAATTACTGAT');
INSERT INTO its1_sequence VALUES(257,'5d5b7797f268a5f33ae1c73a3a4c627f','TAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(258,'e28103b5eaf66950d03f95d2c11ded77','AAAAACTTTCCACGTGAACCGTATCAACAACTTTGATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATATTTTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(259,'4591bfcbbf634db0065da5c9539c8e64','CCACACCTAAAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTAGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCTTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(260,'2351f0f6be0768b826fd7497a8fca31d','CTAAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(261,'57431d457a94ea7487c9f190c5a00632','CTTTCCACGTGAACCGTATTCAACAWTTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATRGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(262,'f397a000c5080864a4a750aaa094b6bb','CTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(263,'c6a67307a51655c5dd63b6d664e2417b','AAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(264,'3bc4bce4b7474628babb9c01350e48ff','CCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(265,'7340b3d60d03776e41864e007110a2cb','TTTCCACGTGAACCGTATTCAAAAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(266,'919b285bdb82966939bc19d9d6a27064','CCACACCTAAAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTAGTCTTTTGATTGGCTGGYTGCTACTTTGTGAGCTTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(267,'fc5f33b56f863014a0a21fc1b1a8ac98','CCACACCTAAAACTTTCCACGTGGACCGTTTCACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTAGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCTTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(268,'6b5f5d5b03e888a302d72c2e100da7f9','CCACACCTAAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTAGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCTTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(269,'57189f233431505caeb31e2b8b9c64ff','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(270,'94cfa27a0bc6c49a97cb2e3791e834d2','CCACACCTAAAACTTTCCACGTGAACCGTATCAACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(271,'1929e8b2f4a84d6cb0498f9480def466','TAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTCTACTGGTGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(272,'fa375db682d1af58a4a2d2b8497cce10','CGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTTTTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(273,'8211354fe662d79c44ec7f31e1638430','CACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTCTACTGGTGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(274,'262df667c59254634a394f9292c8c2c5','TTTCACGTGACCGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTCTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(275,'6bca07d3ad80eabdf4e2a875561123f8','CACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTCTACTGGTGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(276,'5642325d2b2dc06acd06f88539143a12','CACACCTAAAAACTATCCACGTGAACCGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTCTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(277,'ce4a468d079da6d9c743fa7cace5c199','ACTATCCACGTGAACCGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTCTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(278,'97ab7a34a26818cb6d9afd22185fac3d','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTCTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(279,'f641dc15976040ae0db016c81bf08185','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTCTACTGGTGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(280,'b3c15dbce16cf3bedccb8cc320fde2e9','CCACACCTAAAAACTATCCACGTGAACCGTATCAACAATTATATTTGGGGGTGATCTTGGTGGTGCTACCAGTCTCTGACTGGCGGCCTACTGAGTGAGCCCTATCATGGCGAACCATTAGGCTTTGGTCTGATGTAGTAGTAAATTTTTAAACCCATACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(281,'a738455f1bea75aba561376d1c111f8c','CCACGTGAACCGTATCAACCTTTTAAATTGGGGACAATGATCTTGGTGGAGGCTTCTAGTCTTTTGGCTAGCTGTTCACTACTATAAGTGAGTCCTATCATATCGAACCATTAGGCATGAATTTGTCAGATGAAGTAGAAGAAATTGTAAACCCTTACCTAATTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(282,'0f9ff41eadab9fa7bb39a53ca0aae6f9','AAATTGGGGACAATGATCTTGGTGGAGGCTTCTAGTCTTTTGGCTAGCTGTTCACTACTATAAGTGAGTCCTATCATATCGAACCATTAGGCATGAATTTGTCAGATGAAGTAGAAGAAATTGTAAACCCTTACCTAATTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(283,'b3ccd3be57dc7476c966cd18dceadcc6','GTATCAACCTTTTAAATTGGGGACAATGATCTTGGTGGAGGCTTCTAGTCTTTTGGCTAGCTGTTCACTACTATAAGTGAGTCCTATCATATCGAACCATTAGGCATGAATTTGTCAGATGAAGTAGAAGAAATTGTAAACCCTTACCTAATTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(284,'435c4a51de2881e64308cc29a11f4c75','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGACAATGATCTTGGTGGAGGCTTCTAGTCTTTTGGCTAGCTGTTCACTACTATAAGTGAGTCCTATCATATCGAACCATTAGGCATGAATTTGTCAGATGAAGTAGAAGAAATTGTAAACCCTTACCTAATTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(285,'abfd981cb4f17e16f7be5a58a87bf671','TAAAAACTTTCCACGTGAACCGTATCAACAATTTGAATTGGGGGCGATCTTGGTGGTTGCTACTAGTCTATGACTGGCGGTAACAACTGGGTGAGTCTCATCATGGCGAACCATTGGGCATTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(286,'05bd31975b258323d5b143f2ddb6e12e','TAAAAACTTTCCACGTGAACCGTATCAACAATTTTAATTGGGGGCGATCTTRGTGGTTGCTACTAGTCTATGACTGGCGGTAACAACTGGGTGAGTCTCATCATGGCGAACCATTGGGCATTTGTCTGATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(287,'55cd4007c8834a3d36b37bc935cf1d87','TAAAAACTTTCCACGTGAACCGTATCAACAATTTTAATTGGGGGCGATCTTGGTGGTTGCTACTGGTCTATGACTGGCGGTMACAACTGGGTGAGKCTCATYATGGCGAACCATTGGGCMTTTGTCTGATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(288,'478fd32a1737ba8bcef9276bab2a2f75','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTTAATTGGGGGCGATCTTGGTGGTTGCTACTAGTCTATGACTGGCGGTAACAACTGGGTGAGTCTCATCATGGCGAACCATTGGGCATTTGTCTGATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(289,'285f08d1ac86f327feb2375098b6c6ed','CTTTCCACGTGAACCGTATTAACAATTTTATTGGTAGCGAGCTTGGTGGTATCTGCTAGTCTATGACTGGCGGTAACTATAGAGTGAGCCTCAACATAAGCGACTCATTGGGCTTTTGTCTGATGTAGTAGTATCGATTTTAAACCCTTACTTAATTACTGATT');
INSERT INTO its1_sequence VALUES(290,'984e71537da0d9f02ef48b89b20a846b','CCACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTTTATTGGTAGCGAGCTTGGTGGTATCTGCTAGTCTATGACTGGCGGTAACTATAGAGTGAGCCTCAMCATAAGCGACTCATTGGGCTTTTGTCTGATGTAGTAGTATCGATTTTAAACCCTTACTTAATTACTGATT');
INSERT INTO its1_sequence VALUES(291,'dd08d16289b49508583b06625dc5537b','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTTTATTGGTAGCGAGCTTGGTGGTATCTGCTAGTCTATGACTGGCGGTAACTATAGAGTGAGCCTCAACATAAGCGACTCATTGGGCTTTTGTCTGATGTAGTAGTATCGATTTTAAACCCTTACTTAATTACTGATT');
INSERT INTO its1_sequence VALUES(292,'1efbbc007afa596433be3182f73d8684','CTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGATCTTAATGGAGGCTACTGGTCATTTTTGACTGGAGGCTACTATCGAGTGAACCTTATCATGACGAAAAATTAGGCTTATGTCTAGTGAAGTAGTGAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(293,'263122950d736ffecaf438e621e63250','CCACACCTTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGNAGGGTGATCTTAATGGAGGGCTACTGGTCATTTTTGACTGGAGGCTACTATCGAGTGAACCTTATCATGACGAAAAATTAGGCTTATGTCTAGTGAAGTAGTGAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(294,'cb5da6bfc521fef90fab2b50b8d48421','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGCGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGACGAAAAATTAGGCTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(295,'3ec87761aa4edcc9512be60c9396d398','CTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGCGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGACGAAAAATTAGGCTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(296,'615990223a7c20091bc61309cc811a26','CGTGAACCGTATTAACAATTATAATTGGGGGCGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGACGAAAAATTAGGCTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(297,'ba7d3ac7a500324d5b6fc1ef690d53de','CACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGCGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGACGAAAAATTAGGCTTCTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(298,'b9b046b7919e2ff7ea2f1f777e2c6b60','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCRRTAACTATTGAGTGAACCTCATCATAACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATTTTTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(299,'41e8ae2a2505bcb504e647e048fdc99a','CCACACCTAAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(300,'0446cc56bcca7607723f0ac347ffae15','CCACACCTAAAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(301,'3c246fc4607760d67b5a17e7da4ecd9c','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTCAATTGGAGGCAATCTTGGTGGAGGCTACTGGTCAATAGACCGGAGGCTACTACCGAGGGAGCCTCATCATGGCGAATCATTGAGTTTCGGCTTGATGTAGTAGTAAACTTGTAAACCCTTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(302,'fb849aeb15c710f055a2701e9235a306','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTCAATTGGAGGCAATCTTGGTGGAGGCTACTGGTCAATAGACCGGAGGCTACTACCGAGGGAGCCTCATCATGGCGAATCATTGAGTTTCGGCTTGATGTAGTAGTAAATTTGTAAACCCTTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(303,'d0ecb6a1f6d35b5baa691ed48d220a1d','CCACACCTAAAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTCGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(304,'40e2a7facd4c917d334f5e5cb9b904dc','TAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGGTGGTGGCTACTAGTCTTTGGCTGGTGGTAACTACTAGGTGAACCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTTTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(305,'a96e615969e86e5b5abd3e947ecb4cce','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGGTGGTGGCTACTAGTCTTTGGCTGGTGGTAACTACTAGGTGAACCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTTTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(306,'225e86d730e4d23ab7f81bab3840557d','CCACACCTAAAAACTTTTCACGTGAACCGTATCAACACTTATAATTGGGGGTGATCTTGGTGGCGGCTACTAGTCTTTTGGCTGGCGGCTACTACTGAGTGAGCCTCATCATGGCGAACCATTGGGCTCTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(307,'dc85c945bd492fea8f7494581a08a32c','CCACACCTAAAAACTTTTCACGTGAACCGTATCAACACTTATAATTGGGGGTGATCTTGGTGGCGGCTACTAGTCTTTTGGCTGGCGGCTACTACTGAGTGAGCCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATACATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(308,'c72620b8bd360af51cf02670546c3926','TAAAAACTTTTCACGTGAACCGTATCAACACTTATAATTGGGGGTGATCTTGGTGGCGGCTACTAGTCTTTTGGCTGGCGGCTACTACTGAGTGAGCCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATACATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(309,'fb17d4c12a3d694894e00e131a6b2dca','TAAAAACTTTTCACGTGAACCGTATCAACACTTATAATTGGGGGTGATCTTGGTGGCGGCTACTAGTCTTTTGGCTGGCGGCTACTACTGGGTGAGCCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATACATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(310,'6ddd3e4a82e69e628a8c89d30c6666c0','CGTGAACCGTATCAACACTTATAATTGGGGGTGATCTTGGTGGCGGCTACTAGTCTTTTGGCTGGCGGCTACTACTGAGTGAGCCTCATCATGGCGAACCATTGGGCTYTTGTCTAATGTAGTAGTATACATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(311,'c0175cf2bb2325796257e57fa53256ce','TGGCGGCTACTAGTCTTTTGGCTGGCGGCTACTACTGAGTGAGCCTCATCATGGCGAACCATTGGGCTCTTGTCTAATGTAGTAGTATACATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(312,'641f35acf9149f3ebcca79a335045687','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACACTTATAATTGGGGGTGATCTTGGTGGCGGCTACTAGTCTTTTGGCTGGCGGCTACTACTGAGTGAGCCTCATCATGGCGAACCATTGGGCTCTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(313,'881c9b85fca6daeb142558e097e0726a','CCACACCTAAAACTTTCCACGTGAACCGTATCAACAAATATAATTGGGGGTTTGCTAGGTGGTGACTGCTGCCTTTTTGGCTGGCGGATACTACTAGGCGAACCTCATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATACATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(314,'16a7d5b895180b3f69b5193f2f812db8','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAAATATAATTGGGGGTTTGCTAGGTGGTGACTGCTGCCTTTTTGGCTGGCGGATACTACTAGGCGAACCTCATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATACATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(315,'60f75d0680f0341087903f4c2ab66f79','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACATTTATAATTGGGGGCGATCTTGGCGGCGGCTACTAGTCTATGACTGGCGGCGGCTACTGGGTGAGCCTCATCATGACGAATCGTTGGGCTTTTGTCTAATGTAGTAGTAAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(316,'857cb98c480a1d5cc643f3a25a4e3f8f','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGTGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(317,'a1f0753c728111e3a0f0f0b858585ff2','CCACACCTAAAAAACTTCCACGTGAACTGTATCAACAACTTAAATTGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTTATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(318,'498cf84be637970b3c86cd8b9525cdeb','CCACACCTAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(319,'54feb0eb8f75454e374cdb5fb4cd1f9d','CCACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(320,'42f4f5e25dc4b99cce1e1a7bcdb95d77','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAACTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(321,'07e5ef6f7e0c6dd49d724b46d3a2013d','CCACACCTAAAAAACTTCCACGTGAACTGTATCAACAACTTAAATTGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(322,'b984ad2a4417a9d89bca7f03e5c87da1','CCACACCTAAAAACTTCCACGTGAACTGTATCAACAACTTAAATTGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(323,'e4e40eaf0b6d98dc8e320154726dd2d5','CCACACCTAAAACTTTCCACGTGGACCGTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTCATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(324,'db4042fd4a89bdd855f9b01d23e6e98c','CCACACCTAAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAATTAGGCTTTTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(325,'cafa6536732407fc65d292e04c76ad1a','CCACACCTAAAAACTTTCCACGTGGACCGTTTCACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTCATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(326,'d26ea30393e4c17e6c7f5ec65049abcc','CACACCTAAAACTTTCCACGTGACGTATCACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGACTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(327,'45008c8e3430a2ce3ba431961c1cf7f8','CCACACCTAAAACTTTCCACGTGAACTGTATCACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(328,'612f198a486d7a833ddaae1315ac727c','CCACACCTAAAACTTTCCACGTGAACCGTATCACAATTATAATTGGGGGTGATCTTGGTGATGGCTACCAGTCTATGACTGGCGGTCTACTGAGTGAACCCTATCATGGCGAACCATTGGGCTTTGGTCTAATGTAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATT');
INSERT INTO its1_sequence VALUES(329,'da83650a956eceaa7fb542f7b6082605','CCACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGCGGCTACTATCGAGTGAATCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(330,'7ae3a433fb681073c6a467899f6db908','CCACACCTAAAAACTTTCCACGTGACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGCGGCTACTATCGAGTGAATCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(331,'438fd4a1caa7d931907c30c5a465e45b','CCACACCTAAAAACTTTCCACGTGGACCGTCTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTCGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(332,'33905f99372021ed4a9ac9717953fcf3','CCACACCTAAAACTTTCCACGTGGACGTTTTACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTCGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(333,'3fb926601c6b486cbd78a8a3448fba20','CCACACCTAAAACTTTCCACGTGGACCGTTTCACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTTATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(334,'a2b7f5fe954f956c7e303b2c296c209b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTTAATTGGGGGTGATCTTGGCGGTAGCTACTGGTTTTGTACTGGCGGTAACTATTGAGTGAACCTTATCATGACGAACCGTTGGGCTTTTGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(335,'96029ad612560cd0cc160b0085d6a11c','CCACACCTAAAACTTTCCACGTGAACCGTATCAACATTTATAATTGGGGGCGATCTTGGCGGCGGCTACTAGTCTATGACTGGCGGCGGCTACTGGGTGAGCCTCATCATGACGAATCGTTGGGCTTTTGTCTAATGTAGTAGTAAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(336,'a6c6f6e399fca1fced034ff9e6e8aa21','AAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTTTTTTGATTGGCTGGCTGCTACTTTGTGAGCTTCATCATATCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTATTTTAAACCATTACTTCATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(337,'0f275f4ac09ac11cb98960f067acd298','CTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATGTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(338,'2dbcec73b609f2b95e454137d7eba1d3','CCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAGCTATTGAGTGAACCTCATCATAACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATTTTTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(339,'ceef43a1538f907b300c82db77c323fe','CTAAAAAACTTCCACGTGAACTGTATCAACAACTTAAATTGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTTATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(340,'21f2ba4d57958025767a720571717dea','TGGGGGTGATCTTGGTGGCGGCTACTAGTCATTTTGGCTAGAGGCTACTATAGAGTGAACCTCATCATGACGAACCATTGGGCTTTTGCTTGATGAAGTAGTGTATATTTTAAACCCTTAACTAATTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(341,'2b8d92df1a44515d3ab76e82c8af63d3','AAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(342,'50becfbdfe012979a55e7f36f6c9ae61','TTGGGGGTGATCTTGACGGTAGCTGCTGTTTTTTTAATGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(343,'f39ed1f853fbe1094c2977b5342aeb99','CACACCTAAAAAACTTTCCACGTGAACCGTATTCAACAATTATAATTGGGGGTGATCTTGGTGGAAGCTACTAGTCATTTTGGCTGGAGGCTACTATAGAGTGAACCTCATCATGACGAAAAAGTAGACTTTTGTCTAGTGAAGTAGTGAACATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(344,'8e3099dc34fa2948e9e33f8da52fa9df','TGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTACTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(345,'b581632f4a18a48a9013f4a0ae672b2e','CACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTTAATTGGGGGTGATCTTGACGGCAGCTGCTGGTGTTTTACTGGCGGTAACTATTGAGTGAACCTTATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(346,'54221c8921b3f578a7a012e08547317d','AAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTAGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCTTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(347,'ee94c37305f502d037ec5cb1ab02bc9b','CACACCTAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATGTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(348,'b962624133516e972b9b65a5ab90794d','CACACTAAAAACTTTCCACGTGAACTGTATCAACATTATAATTGGGGGTGATCTTGGTGGCGGCTACTAGTCATTTTGGCTAGAGGCTACTATAGAGTGAACCTCATCATGACGAACCATTGGGCTTTTGCTTGATGAAGTAGTGTATATTTTAAACCCTTAACTAATTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(349,'3af045617ec5e204722a4ebd6f13cd7b','TTATAATTGGGGGTGATCTCGGTAGTGGCTACTAGTCTTTTGGCTGGCGGCTATAACTGGGTGAAGCTCATCATGGCGAATCATTGGGCTTCTGTCTAATGTAGTAGTGAAATTTTAAACCCTTACTTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(350,'c46dfd68a0ca97bf5cb81ddefddc9c46','CCACACCTAAAAAACATTCCACGTGAACCGTATTAACATCTATAATTGGGGACGATCTTGGTGGTGTTACTAGTCTTTGACTGGTGGCGCTAACTGGGTGAGTTTCATCATGGCGAATCATTAGGCTTTTGCTTAGTGTAGTAGTAAAAATTATAAACCCTTACTTAATTACTGAT');
INSERT INTO its1_sequence VALUES(351,'02c556c4c1d683824281dd479df9b084','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAACATAAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTCATCATGACGAACCGTTGGGCTTTTGTCTGGCGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(352,'f2828ed97bffc8eabf6478b824434b03','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGATCTTAATGGAGGCTACTGGTCATTTTTGACTGGAGGCTACTGTCGAGTGAACTTCATCATGACGAAACATTAGGCTTATGTCTATTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(353,'f315c9ae61b68fedf6567bf6d22a0d1a','TTAACAATTATAATTGGGGGCGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTGTCGAGTGAGCTTCATCATGACGAAACATTAGGCTTCTGTCTAGTAAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(354,'5e0b943374a12be0dbad84b9e59bcbf7','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATGTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(355,'d0f5ae831770eaabc558604b2b29d45b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTATAATTGGGGGTGACCTTGGTAGTGGCTACTAGTCTATTTTGGCTGGTGGTTATAACTGAGTGAGCCTCATCATGGCGAAAAGTTAGACTTTTGTTTAACCGAGTAGTATAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(356,'46361f1896e09875397aa1a78d3640dc','TGGGGACGAAGATCTTGGTGGTAACTACTAGTCTCGACTGGTGGTAGCTACTAGGTGAGTAGTCTTATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(357,'f546cff537bb235ebd568adc5d143162','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGCGATCTTAATGGAGGCTACCAGTCATTTTGGCTGGAGGCTACTGTCGAGTGAGCTTCATCATGACGAAACATTAGGCTTCTGTCTAGTAAAGTAGTGAAAATTTTAAACCTTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(358,'44816dd353da1007fcaa11cac98e83e7','CCACCCCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(359,'180b1952cf4fc76c63cac7aa5112e2cc','GACTGGTGGTAGCTACTAGGTGAGTAGTCTCATCATGGCGAACCATTGGGCTTTTGTCTAATGTAGTAGTATAAATTGTAAACACTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(360,'c64ffce84629cd8ac8d5c512a6050eab','GGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTTATCATGGCGAAAAACTAGACTTTTGTTTGGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(361,'daf9e274e8377724d708e9a1d035481a','AGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(362,'9310c04379c4df0084d5c9b8bec87248','TATAATTGGGGGTCGTGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAAAATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(363,'09821920017d950c8518e446640accd7','TTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGTGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTTATCATATCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(364,'6a3d0330a11ae47b72129a55d8069bbe','ACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGTGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTTATCATATCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(365,'6d2240a5313ee1cbb18db331e53330d4','AAAACTTTCCACGTGGACCGTTTCAACAAATGAATTGGAGGTGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTTATCATATCGAACAATTGGACTTCGGTCTGATGTAGTAGTACTTTTTTAAACCATTACTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(366,'cc59ff83faa50feaf5562ffab6c49d40','CTTTCCACGTGAACCGTATTAACAAATTATAATTGGGGGTGATCTTGGTAGTGGCTGCTAGTCATTTTGGCTGGTGGCTATAACTGAGTGAGCCTCATCATGGCGAATCATTGGACTTTTGTCTAATGTAGTAGTGAAAATTGTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(367,'cef89201651b910906447a7a7d813058','CTAAAAAACTTTCCACGTGAACCGTATTAACAAATTATAATTGGGGGTGATCTTGGTAGTGGCTGCTAGTCTTTTTGGCTGGTGGCTATAACTGAGTGAGCCTCATCATGGCGAATCATTGGACTTTTGTCTAATGTAGTAGTGAAAATTGTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(368,'44028fa6f7f159a4609f252aa0e1302b','AACTTTCCACGTGAACCGTATCAACAATTTAAATTGGGAGCGATCTTGGTGGTGGCTACTAGTCTTTTGGCTGGTGGCTACTATTGGGTGAGCTCCATCATGGCGAACCATTGGACTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(369,'791b2f4f1967e7cc9d0cc2d9436c71a8','TAAAAACTTTCCACGTGAACCGTATCAACAATTTAAATTGGGAGCGATCTTGGTGGTGGCTACTAGTCTTTTGGCTGGTGGCTACTATTGGGTGAGCTCCATCATGGCGAACCATTGGACTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(370,'f545e333441cbad3655f0dfb46ff8edc','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTAAATTGGGAGCGATCTTGGTGGTGGCTACTAGTCTTTTGGCTGGTGGCTACTATTGGGTGAGCTCCATCATGGCGAACCATTGGACTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(371,'45e472f85dbd05748b64083c68214fa2','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTTAAATTGGGAGCGATCTTGGTGGTGGCTTCTAGTCTTTTGACTGGTGGCTACTATTGGGTGAGCTCCATCATGGCGAACCATTGGACTTTGTCTAATGTAGTAGTATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(372,'cd02bf69bab7dda96033b09296c6b525','GTATCAACAATTTAAATTGGGGATGATCTTGGTGATGACTACTGGTCTTTTGACTGGTGACTATTACTGGGTGAATCTCATCATTTCGAACCATCGGACTTTGTCTGGTGTAGTAGTGTAAAAATTATAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(373,'f2d628aa23b6b6be0fd9866fc5ed8657','CCACACCTAAAACTTTCCACGTGGACCGTTTCACAAATGAATTGGAGGCGATCTCGGTGGCGGCTGCTGGTCTTTTGATTGGCTGGCTGCTACTTTGTGAGCCTCATCATGTCGAACAATTGGACTTCGGTCTGATGTAGTAGTATTCTTTTAAACCATTACTTCATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(374,'c4a5bb1d66e085979b4828259cb69b30','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGGGGCGATCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTGTCGAGTGAGCTTCATCATGACGAAACATTAGGCTTCTGTCTAGTAAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(375,'3fb68f391fdc110f87f2de2683bae7a5','TAAAAAACTTTCCACGTGAACCGTATCAACAATTATAATTGGGGGTGATCTCAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAGCCTCATCATGACGAAAAACTAGGCCGGTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(376,'ebe2f3849e7736a1c750a6c3cda3e43f','CTTTCCACGTGAACCGTATCAACAATTATAATTGGGGGTGATCTCAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAGCCTCATCATGACGAAAAACTAGGCCGGTGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(377,'bb490e57dfc660b3e25add5710c6c191','TAAAAACTTTCCACGTGAACCGTATCAACATTTATAATTGGGGGCGATCTTGGCGGCGGCTACTAGTCTATGACTGGCGGCGGCTACTGGGTGAGCCTCATCATGACGAATCGTTGGGCTTTTGTCTAATGTAGTAGTAAAATTTTAAACCCTTACCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(378,'c59bbf08cadbf40d1243ad2ba4733e65','TTTCCACGTGAACCGTATCAACAAACTTAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGACCCTTATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAACTTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(379,'1cc1b5f84540e592f60dc5855bd3f9e7','TAAAAACTTTCCACGTGAACCGTATCAMCAAACTTAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGASCCTTATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAACTTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(380,'575b8663135290364ed9ad32a604fbab','ACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTTATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(381,'710b0cf78fe4c7f3f363be3c5d539288','TAAAAACTTTCCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTTATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(382,'8d82e789818ee06ce723809205043a96','TTTCACGTGAACCGTATCAACAACTTTAATTGGGGGTGATCTTGACGGTAGCTGCTGGTTTTTTACTGGCGGTAACTATTGAGTGAACCTTATCATGACGAACCGTTGGGCTTTTGTCTGACGTAGTAGAATAAATTTTAAACCCTTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(383,'3a3a984731514e7c3ed5013080a55a9b','CCACACCTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAACATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(384,'e2047c9d9f9e5dd1afcc2ea0f3a76c1e','CTAAAAAACTTTCCACGTGAACCGTATTAACAATTATAATTGGAGGTGACCTTAATGGAGGCTACTAGTCATTTTGGCTGGAGGCTACTATCGAGTGAACCTCATCATGGCGAAACATTAGGCTTCGGTCTAGTGAAGTAGTGAAAATTTTAAACCTTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(385,'0de8c93202280c1c22800f37c551a100','CCACACCTAAAAAAACTTCCACGTGAACTGTATCAAACTTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGAGCATTTCGACCTTGGTTGAAATGAGTAGCTAAATTTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(386,'73b7622c82e210ae82a886c51ffbdef7','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCRACTGCAGACTTAATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATTGCGATCGTTTCGACCTTGGTTGAAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(387,'2dc11195be70634359fb6b93a399ad9d','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATCAGGCGGCGACAGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCCATCATGGCGATCGTTTCAACTTCGGTTGAAACTAGTAGCTAAATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(388,'f5eb913c0c48640895602e09d2280880','CCACACCTAAAAAACTTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTKGRATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(389,'e433a0a6f431b0a38ac707de341e632f','CCACACCTAAAAAACTTCCACGTGACCTGTATACAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGAATTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(390,'58eeebda7c6ffbf98e6d1395f6b0b5fd','CCACACCTAAAAAACTTCCACGTGAACTGGTATACAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGAATTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(391,'d1f7c3a519f1c5c9e93dcaece9ef34f9','CCACACCTAAAAAACTTCCACGTGGACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAAATGCGTCCCATCATGGCGATCGTTTCGACCTCGGTTGGAATTAGTAGCTACATTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(392,'da6b114b8e65a87a7306eda24554c4af','CCACACCTAAAAACAATCCACGTGAACCGTATCAACCAACTTGTAATTGGGGCCTCCCTGCTGTATTGTGGGTTGAGGCCTATCAGCGAACGCTTTGTTTCTGTTTGTTGTTGGCTGTCTGTTTTT');
INSERT INTO its1_sequence VALUES(393,'2811d266d16920f7cd8eb5901eed7341','TTTTKGGGGGACTCGCTTGGGCGCCCGGTTTGATTAAGTTCGCTGGGAGGAAAGGTTTGAGGCTCTTTTTGGACGGACGGCTGGCTTTGGACATAAAGTTAGTAGCTTTTTTTAAACCCTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(394,'5694ef9fa16a5bd547b88f725832ed66','TTTTTTGGGGGACTCGCTTGGGCGCCCGGTTTGATTAAGTTCGCTGGGAGGAAAGGTTTGAGGCTCTTTTTGGACGGACGGCTGGCTTTGGACATAAAGTTAGTAGCTTTTTTTAAACCCTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(395,'c0852146c0ddc5fc2ff30db5bebfc9b8','CGTGAACCGTATCAACCCCCCTTTAATTGGGGCTTCCCTGCTGTATTGTGTTTGGCTGGACGATTTATTTTGTTCGGCCGGCCGAAGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTGTGTG');
INSERT INTO its1_sequence VALUES(396,'3b5192fbaede84863a2fea52496958cf','TTTTTTGGGGACTCGCTTGGGCGCCCGGCTTGATTAAGTTCGCTGGGAGGAAAGGCTTGAGACTCTTTTTGACGGACGGATGGCTTTCGACTTTTGAGTTAGTAGCTTTTTTTTT');
INSERT INTO its1_sequence VALUES(397,'3790398ada966ed8fe9a0389467c5988','CCCTTTAATTGGGGCTTCCCTGCTGTATTGTGTTTGGCTGGACGATTTATTTTGTTCGGCCGGCCGAAGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTGTGT');
INSERT INTO its1_sequence VALUES(398,'bcbc894fd55f538456643fe3ea93bc59','CACGTGAACCGTATCAACCCCCCTTTAATTGGGGCTTCCCTGCTGTATTGTGTTTGGCTGGACGATTTATTTTGTTCGGCCGGCCGAAGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTGT');
INSERT INTO its1_sequence VALUES(399,'c774038d3555e45fd60b2f1e4706e6b3','GAACCGTATCAACCCCCCTTTAATTGGGGCTTCCCTGCTGTATTGTGTTTGGCTGGACGATTTATTTTGTTCGGCCGGCCGAAGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTGTGT');
INSERT INTO its1_sequence VALUES(400,'ca7e369d369948d7e8289a60e1ad7e37','CCACGTGAACCGTATCAACCCCCCTTTAATTGGGGCTTCCCTGCTGTATTGTGTTTGGCTGGACGATTTATTTTGTTCGGCCGGCCGAAGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTGT');
INSERT INTO its1_sequence VALUES(401,'fac5f4d7c3fffcf7f3a600e763872815','CCACACCTAAAAACAATCCACGTGAACCGTATCAACCCCCCTTTAATTGGGGCTTCCCTGCTGTATTGTGTTTGGCTGGACGATTTATTTTGTTCGGCCGGCCGAAGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTGTGTG');
INSERT INTO its1_sequence VALUES(402,'39d8387b507fe8d82aaa93a1a1f39bb6','TCCACGTGAACCGTATCAACCCCCCTTTAATTGGGGCTTCCCTGCTGTATTGTGTTTGGCTGGACGATTTATTTTGTTCGGCCGGCCGAAGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTGTGT');
INSERT INTO its1_sequence VALUES(403,'20b449f9ea5a978a29c6fddb79e12bb2','TCCACGTGAACCGTATCAACCCCCCTTTAATTGGGGCTTCCCTGCTGTATTGTGTTTGGCTGGACGATTTATTTTGTTCGGCCGGCCGAAGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTGTGTG');
INSERT INTO its1_sequence VALUES(404,'75d91098aba3de61aedafa50d815a1f9','CCACACCTAAAACAATCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTT');
INSERT INTO its1_sequence VALUES(405,'4e677de33da4bd3c572af56c30319ffc','CGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTT');
INSERT INTO its1_sequence VALUES(406,'0bcea141487a32d2e87407aca75df9e1','TCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTT');
INSERT INTO its1_sequence VALUES(407,'3045a2575bc72951a1262986cd4ddc6a','CCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTT');
INSERT INTO its1_sequence VALUES(408,'98c09f3ba53d7312cf370c3a46143146','CCACACCTAAAAACAATCCACGTGAACCGTATCAACCACCCCTTAATTGGGGCTTCCCTGCTGTATTGTGCTGGCTGAGCTTTAATTGTTCGGCCGGTCAAAGCGGTGGGTTGAGGCCTATCAGCGAACGCTTTTCAAGTTAGTAGCTTTTTGTGAAC');
INSERT INTO its1_sequence VALUES(409,'c6bdfe15b9e510659412b175aaef462b','CCACACCTAAAAACAATCCACGTGAACCGTATCAACCACCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTAATTGTTCGGYCGGTCAAAGCGGTGGGTTGAGGCCTATCAGCGAACGCTTTTCAAGTTAGTAGCTTTTTGTGAAC');
INSERT INTO its1_sequence VALUES(410,'22738984180627cc790faf82e87fb972','CCACACCTAAAAAACCTCCACGTGAACTGTATCAAAACTTAGTTGGGGACAAATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGCGTCCTATCATGGCGATTGTTCTGACCTTGGTCGGAACAAGTAGCTAAACTTTTAACCCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(411,'d7baa62b5326c6d1c105319dd9d6fd93','CCACACCTAAAAAACTTCCACGTGAACTGTATTAAAAATTAGTTGGGGATTTATCAGGCGGAGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGAGTCCTATCATGATGGCGAGCGTAACGACCTTGGTCGGAGCTAGTAGCTATTTTTATAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(412,'9fc91a82a9a9f882066283620168ac78','CCACACCTAAAAAACTTCCACGTGAACTGTATTAAAATTAGTTGGGGGCTTATTAGGCGGCGACTGCAGACTTTATTGTTAGCGGTTGCTGCTAGATGAGTCCTATCATAATAGCGAGCGTAACGACCTTGGTCGAAGCTAGTAGCTATATTTGAAACCTTTACTAACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(413,'e7ebf400ceecdcb503e598fcd6c6127e','CCACACCTAAAAAACTCCACCGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATA');
INSERT INTO its1_sequence VALUES(414,'81f6004b7c9e274b99e0751f70e065a7','CCACACCTAAAAACTCCACGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTCTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATA');
INSERT INTO its1_sequence VALUES(415,'2643d6a79a47ff732f4c2009f2283443','CCACACCTAAAAACTCCACCGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGCCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATA');
INSERT INTO its1_sequence VALUES(416,'d2b34603621dfafe8f514f857e3a829b','CCACACCTAAAAACTCCACCGTGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATA');
INSERT INTO its1_sequence VALUES(417,'be17a8673d3b46cec5c8cc454263da09','CTAAAAAACTCCACCGTGGAACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATA');
INSERT INTO its1_sequence VALUES(418,'b813caab793ca2258e780d86c2086722','TATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATA');
INSERT INTO its1_sequence VALUES(419,'af77330895c8b1ee4ac6587372996ee0','CTGGGGACGCTACGTGGCCATTGCCGATCTTTTTGACTGGCAATTGCTACTATGCGACTCAACCGTGGCTAAGGTCACGCTTCTGTTTGATACCTTAGTGATATTGTAAACCATTCTTTAATTACTGTATA');
INSERT INTO its1_sequence VALUES(420,'8530b1344a6d46c63038b290014084f3','AACCGTATCAACTTTTTTAATTCGGGGGACGCTAGGTGGCGATTGCCGGTCTTTTTGACTGGCGATTGCTACTAGGCGACTCAACCGTGGCTAAGGTCAGGCTTCTGTTTGATAACTTAGTGATATTGTAAACCATTCTTTAATTACTGTATA');
INSERT INTO its1_sequence VALUES(421,'1a04e1fa1823bfb835f834499f8fec5c','CCACACCTAAAAAACTCCACCGTGAACCGTATCAACTTTTTTTAAATAGGGGGATGCTAGGTGGCGATTGCTGGTCTTTTTGACTGGCGAATGCTACTAGGCGACCCTACCGTGGCTAAGATTTCAGGCTTCTGTCTGATAACTTAGTTGGATTGTAAACCATTACTTAAATACTGTATA');
INSERT INTO its1_sequence VALUES(422,'4e9d5c6f3a9cbd310d3b63722898342e','CCACACCTAAAAAACTCCACCGTGAACCGTATCAACTTTTTTAAATAGGGGGATGCTAGGTGGCGATTGCTGGTCTTTTTGACTGGCGAATGCTACTAGGCGACCCTACCGTGGCTAAGATTTCAGGCTTCTGTCTGATAACTTAGTTGGATTGTAAACCATTACTTAAATACTGTATA');
INSERT INTO its1_sequence VALUES(423,'549ada701f225d36b095308369ea0985','CCACACCTAAAACTTTCCACGTGAACCGTTTAAAATTAATTGGGGGCTTTTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGGCTTTAGTCTAATCTAGTAGCTTATTGTAAACCATTTTCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(424,'6dac44b704bafaec10f92f2e9eedba89','TCCACGTGAACCGTTTAAAATTAATTGGGGGCTTTTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGGCTTTAGTCTAATCTAGTAGCTTATTGTAAACCATTTTCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(425,'914ee9dcc24d77395a2c4d94736bbe6a','TCCACGTGAACCGTTTAAAATTAATTGGGGGCTTTTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGAGGCTTTAGTCTAATCTAGTAGCTTATTGTAAACCATTTTCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(426,'3ccfcd7be7dbac1133b309b699f30d7e','TCCACGTGAACCGTTTAAAATTAATTGGGGGCTATTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATAAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATTTCCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(427,'d2a86851f1b157b78806a5e3050d9e7f','CCACGCCGAACCGTTTAAAATTAATTGGGGGCTATTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACGTTAGTCTAATCTAGTAGCTTCTTGTAAACCATTTCCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(428,'70e953f1ac2f7dc4d6d73660d1342889','CGTCGACCGTTTAAATTAATTGGGGGCTATTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATTTCCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(429,'c508f8529b6da46026416690ab134e98','ATTAATTGGGGGCTATTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATTTCCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(430,'0b5810cc1ae245746285f230a5aa1c20','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATGCCTAAGTACGCTGATTATACT');
INSERT INTO its1_sequence VALUES(431,'f87b5831ffe4dc1024c6212260deaa66','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAGCCATTTCCTAGTAGACTGATTATACT');
INSERT INTO its1_sequence VALUES(432,'73974b58fd97213939313a4ed00b00f9','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCTAACCATACCTAAGAAACCCTGATTATACT');
INSERT INTO its1_sequence VALUES(433,'ecef84deee03a2d66415d69276664c03','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATGCCTAAGTAGCCTGATTATACT');
INSERT INTO its1_sequence VALUES(434,'1e1a18ec2c30d001cbcc58b4c0c3a065','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATGCCTATTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(435,'9b581cd807868eff17adddfb65d752b0','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAGCCATTACCTAAGTTCGCTGATTATACT');
INSERT INTO its1_sequence VALUES(436,'ee3977ad493c7fb7baffeb0360e59f71','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAATCCATTCCTAGAACATACTGATTATACT');
INSERT INTO its1_sequence VALUES(437,'6d12415fe7cd871534f4c4013b3c03f8','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATGCCCTAAGTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(438,'3d8d45114a4b05d79c3b26fa8400a869','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCTAACCATGGCGCTAATATACTGATTATACT');
INSERT INTO its1_sequence VALUES(439,'310fb5e42d64b9ed879536515cb52db5','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATGGCTAACTTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(440,'6834dd4291ac02339859302d62ed3371','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAACCCATCCTAAGTATATACTGATTATACT');
INSERT INTO its1_sequence VALUES(441,'eef511aa09d22f393411107c2e143724','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAACCCATACGCTAAGTCTACTGATTATACT');
INSERT INTO its1_sequence VALUES(442,'4f3bf9b99ff63e61b91209877d80b57f','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCTAGCCATGTCGCTACGTTGCTGATTATACT');
INSERT INTO its1_sequence VALUES(443,'abdbe06325c2e393edc45d3b4540f026','GCGGCTTTTTAAGCTGCAGGCTATTGCTGAGGGGCCTCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATTTCCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(444,'2b057a19fe7661d79c8b18173a017798','TCCACGTGAACCGTTTAAAATTAATTGGGGGCTATTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATTTCCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(445,'df09aade9fd85e4b566aedb06273fc21','ACCGTTTAAATTAATTGGGGGCTATTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACTTTAGTCTAATCTAGTAGCTTATTGCAAACCATTTCCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(446,'9d9aae728e32d06255ce70c76cc4043a','CCACACCTAAAACTTTCCACGTGAACCGTTAAAATTAATTGGGGGCTATTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGGCTTTAGTCTAATCTAGTAGCTTATTGTAAACCATTTTCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(447,'1cccff6f29be697111aa771d553ccbfa','TCCACGTGAACCGTTTAAAATTAATTGGGGGCTATTCGGTGAAGGCTAGCGGCTTTTTAAGCTGCAGGCTATTGCTGAAGGGCTCCATCAAGCGAACGTTTGGACGTTAGTCTAATCTAGTAGCTTCTTGTAAACCATTTCCTAATTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(448,'75368bffb43d7af175ee1400259d205c','CCACACCTAAAAACTTTCCACGTGAACCGTATCACCCCATTAATTCGGGGGTTTAATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTGCTGCTGAGCGAATCCCATCATGGCGAGCGCTCGGACCTCGGTCGGAGCTAGTAGCGTTAATTTTAAACCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(449,'192a10e8386917e457aac0b7c290b6fb','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACAACAAATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATCTTTTTTGCTAGCGGCTGCTGCTAAGCAAGCCCTATCATGGCGAGCGTTCGGACCTCGGTCGGAGCCAGTAGCTTTCATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(450,'49da8f2bffc835c2d821cf0136479ae8','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAATTAATTGGGGGTTTGCTTGGCGGAAACTGCAGGCATCTTTTTGTTGCCGGTGGTTGCTGCCGAAAAAGCCCTATCATGGCGAGGGTTCGGACTTCGGTCGGAGCCAGTAGCTTATTGTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(451,'a6f91a65923b23d851b83fe6de5cd83e','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAATTAATTGGGGGTTTGCTTGGCGGAAACTGCAGGCATCTTTTTGTTGCCGGTGGTTGCTGCCGAAAAAGCCCTATCATGGCGAGCGTTCGGACCTCGGTCGGAGCCAGTAGCTTGTTGTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(452,'2e06faa024babf80dcc5f6b22067ee50','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGTTTCATTGGCGGCTGCTACTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCAAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGAATTTTTAACCCATTCTTACATACTGAAATTACT');
INSERT INTO its1_sequence VALUES(453,'a2ba1bd3d6b6116c930201043984ec53','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTGTATTGGGGGCTTGTTTGGCGGCGGCTGCCGGCATCTTTTTGCTGGCGGCAGCAGCTGGTCGAGCTCCATCAGTGAGCGTTCTGGTCTCGACCGGAGCTAGTAGCTTTCCTTTGAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(454,'ee9ea29449ffa461494f9007cc347420','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCATTAGTTGGGGGTTTGATTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCTTGGCGATTGTTCTGACCTTCGGTTGGAGTGAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(455,'dec7838c13f3342d3eedd620044535c3','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAAATTGGGGGTTTGTTTGGTAGCGGCTATTGGCATCTTTTGCTGATTAGCTGTTGCGGAGCAAGCTCTATCATGGCGAATGTTTGGACTTCGGTCTGAATTAGTAGCTTCATTTTAAACCATTTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(456,'8f42a714ca5a8a680d0b414f5c5ff461','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAACTAATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTAGACGAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTAATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(457,'34fc70d1055c38f0734680650723fed5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(458,'be83c565cc42aaba43617739660b9e91','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTAATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTGTATTTTAAACCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(459,'b841187c332bfec81fb53a49c549840e','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGTGGTTGCTGCTGATATTTTATTGCTGGCTAGCGACTGCTGAGTGAATCCTATCATCGTGAGCACTCTGACCTCGGTTGGAGCTAGCTTAAATTATAAACCCATTCTTATATACTGAATATACT');
INSERT INTO its1_sequence VALUES(460,'6745c9c4b1865fc621c02e9838500dcc','CCACACCTAAAAACTTTCCACGTGAACCGTATCACCCAATTAATTGGGGGTTTAATTGGTGGTTGCTGCTGGCATTTTATTGCTGGCTGGCGACTGCTGAGTGAATCCTATCATCGTGAGCACTCTGACCTCGGTTGGAGCTAGCTTAAATTATAAACCCATTCTTATATACTGAATATACT');
INSERT INTO its1_sequence VALUES(461,'0c4f6e345d153f0b4f03ad80aad555e8','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGTGGTTGCTGCTGGCATTTTATTGCTGGCTGGCGACTGCTGAGTGAATCCTATCATCGTGAGCACTCTGACCTCGGTTGGAGCTAGCTTAAATTATAAACCCATTCTTATATACTGAATATACT');
INSERT INTO its1_sequence VALUES(462,'161c97e3b9fd0d005bab4a5af52177cd','CCACACCTAAAATCTTTCCACGTGAACTGTATCAAAACATTTAATTGGGGTATGTTCAGCGGCGGTCCTAGCATGTATTTGCTGGTTGATTGTAGCGGAACGATTGTTTAGTGGCGGCCCTAGCAATTTATTGCTGGTTGACTGTAACTCGACTTGCCCTATCGTGAGCGCTTGGACCTTGTCGGTCGAAGCTAGTAACCCTTTTTATACTCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(463,'8cf5a4f1040cfd7912876a7324c25439','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATATTGCTGGCTGGCTGCTGCTAAGCGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCGGAGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(464,'d062b73a846804c00d59ee5352fbef58','CCACACCTAAAAGCTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTTAACTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGTGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCGTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(465,'a11c0a40335c5e68eb0ddd5a84f5cbd1','CCACACCTAAAAGCTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTTAACTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCGTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(466,'e8a7251609fdc3b40f231c2192a67d31','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCCTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(467,'447f55b5786010cf9d97af75c9e9986d','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(468,'c2da3ab1a6542d9f75907f5e7a0a8fed','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(469,'ac0e315c2de48ce255fbaafc1909bee8','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGTGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(470,'533735e7458e2e30ddf22262348df055','TGGGGGTTTCGTTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGTGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(471,'2b6f4f7c533b7954e82f8d9ba46f4313','GTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTAGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(472,'d8719d2963567e0da55444ae29f4be5b','TTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAACCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(473,'301343863f13bafcc61476c0257c6365','TCGTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTAGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(474,'6348593ba7c2f2ebcb5179ae7e95ddc0','TTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(475,'c1fb2aa55788104c2bdfc1e26630e676','TTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(476,'abf4bd359551f64707e816dd46d3513f','TTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTAGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(477,'18ce4fb85709d511f6729a0c9ce1c911','CGTTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(478,'1e224fd56ecdc92bcff049f3a7886c6b','CGTTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(479,'ff8c8314aaad353198bba403a2d15e3f','TGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(480,'60584445995564f5ba6d26bfc9afaa98','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCSTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(481,'5afd196f1665c9c352a98cbf762ef71c','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTAGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(482,'e218de6a541ef420829efb4b91fea168','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCCTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAACCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(483,'bba6a261207925198603e0061ac003da','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTRGCAGCTGCTGAGTAARCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(484,'c9831962a23033d437fc76e34d47bf09','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTTAATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(485,'e7b5641df138717e0e74db5681f3eec3','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTTAACTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCGTAATTTTAAACACATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(486,'2f86d815d0a3708df635df96d19019c3','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTAACTTTTAAACCCATTCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(487,'2bb5b4ffd5622f6262e5a5adb72fbfd8','CCAATTAATTGGGGGTTTCATGGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTAACTTTTAAACCCATTCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(488,'33b47ed1db2608cb9febd0421ecbd489','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAAACTTGGGGGTTTGTTTGGTAGCGGCTATTGGCATCTTTTTGCTGGTTAGCTGTTGCTGAGCAAGCTCTATCATGGCGAATGTTTGGACTTCGGTCTGAATTAGTAGCTTACTTGTAAACCATTTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(489,'e4a6670679732fe95a4df1130751a33e','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGTAGCTGCTGACATCTTTTTGTTGGCGGCTGTTGCTGAGCAAACCCTATCATGGCGAATGTTCGGATTTCGGTCTGAGCTAGTAGCTTTCATTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(490,'f3b2ca8ee675218509bbbf6a832bc7e6','CCACACCTAAAAACATTCCACGTGAACCGTATCAACAAACCAATTTGGGGATATGTTTGGTGGCGGCTACTAGCGAAATTATTTTTGCTGGCTGCTGCTACTGGGCAAGTCCTATCATGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCGCTAATTTTAAACCCATTCCTAATTACTGATATAC');
INSERT INTO its1_sequence VALUES(491,'e32e4d886a8047895dadc954bdb3d017','CCACACCTAAAAACATTCCACGTGAACCGTATCAACAAACCAATTTGGGGATATGTTTGGTGGCGGCTACTAGCGAAATTATTTTTGCTGGCTGCTGCTACTGGGCAAGTCCTATCATGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCACTAATTTTAAACCCATTCCTAATTACTGATATAC');
INSERT INTO its1_sequence VALUES(492,'01b32bd25deb5990217e8db2f45c15c1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGCTGCTGCTGGTAACTTTTTTGCTGGCTGGCGGCTGCTGAGCGAATCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(493,'73c6f70e9f0ed30574f4b0b9158e2028','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(494,'36de540cec25bb126b7f2a8450ff8121','CCACACATAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(495,'48ac66c0e13c3713e147434f3a3505c7','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGCTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(496,'a86169a9dd9b0e67af49e2d2b7b55f6b','CGTATCACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(497,'332540d5ace24a6f722e596666069070','CACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTGGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTCTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(498,'9908d8ffc4665576da9e06a9143e627f','CACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(499,'81425b206db3f0efd12a606a51cbbe74','AAAACTTTCACGTGAACCGTATCAACCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(500,'382e6d8a8c28201519ac3162c4584412','CTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(501,'851fd68546a1abebd20ed18ebabc0f8c','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGYGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(502,'8039057ef7728c79f97b4c7da857a3e3','GCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTNTGGACCTTTGTCTGAACANGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(503,'de3c6f8051b49c5c1f50786ec4275136','CTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTGGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTCTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(504,'892561d54d6f478a9d78b35f3faa5d4b','AAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTGGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTCTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(505,'fc2be8ccce83fa7779e3c3d139b3956e','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGTGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(506,'5f228486589701a710d6e61d6bf04479','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(507,'f5a50edd5a40cf3909405c61ab09caa1','AACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(508,'a4263a24e1a1a530d68f12c87a2c7dfd','GAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(509,'1b9dbed7fce480b510a17780e6140014','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(510,'942ad3c8e2aa415fbbb596365fdc7d09','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(511,'59df7839c5cfe16586cb5921c811ac5f','CCACACCTAAAAACTATCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATATTGCTGGCTGGCTGCTGCTGAGCGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCTGAGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(512,'d81cb15092d8e8a8d3abd76258311118','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCAATTAATTGGGGGATTCAATTGGTGGTTGCTGTTGGCATCTTTTTGCTGACTGGCGACTGCTGAGCGAATCCTATCATCGTGAGCGCTCTGACCTCGGTTGGAGTTAGCTTCAATTATAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(513,'88c56e7438dc20381c38de2d03aaff81','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGTGAGCGCTCTGACCTCGGTTGGAGCTAGTAGCTTGAATTGTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(514,'797ad3a0008af7aeeae36a7d65f18a1b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTCAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(515,'f2a9538527c9e11256338696c9a44918','CCACACCAAAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTAATGCTGAGCGGACCCTATCGCGAGCGTTCTGACCTTGGTTGGAGCTAGTAGCTTACATTATAAACCCATTCCTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(516,'a43bdb5ad81961b79f11721b7a8191cb','CCACACCAAAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTAATGCTGAGCGGACCCTATCGCGAGCGTTCTGACCTTGGTTGGAGCTAGTAGCTTACAGTTATAAACCCATTCCTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(517,'4d5530c3f508ad70250413693712a8c7','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTAGCATACTGCTAGCGTCTGGTGCTGAGCGAGCCCTATCATGGCGAGCGCTTTGGCTTCGGTCGGAGTTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(518,'5b278585070fde9e1f102fd2e2db66fd','TGGGGGTTTAATTGGCGGCGGCTGCTAGCATACTGCTAGCGTCTGGTGCTGAGCGAGCCCTATCATGGCGAGCGCTTTGGCTTCGGTCGGAGTTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(519,'ffb848b37fb2cc974b8ba37188e10381','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGACTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTAACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(520,'8a4019ab11783f23b091a9dccf4f3d59','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGACTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGTATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(521,'984a6e078300df5bdc34ffbd58406fc9','CCACACCTAAAATCTTTCCACGTGAACCGTATCAACCCAATACATTGGGGGTTAGCTTGGTGGTGGCTGCTGGCATCTTTTTGCTGGCTGGCTGCTGCTGAGCAAGCCCTATCATGGCGATCGTACGGACTTCGGTCTGAACTAGTAGCTTCAATTGTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(522,'2581e91d011efbbfe067d1c2fa59132f','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAACTATTGGGGGTTTGTTTGGCGGCGGCTGCAGGCATCGTTTTGCTGGCGGCTGCTGCGGAGCAATCCTTATCAAGGCGAGCACTCGGATTTCGGTCTGAGTTAGTAGCATACATTTTAAACCCATTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(523,'95ca9eb5f871165a9584e7d2238bc6db','CTTTCCACGTGAACCGTATCAAACCAACTATTGGGGGTTTGTTTGGCGGCGGCTGCAGGCATCATTTTGCTGGCGGCTGCTGCTGAGCAATCCCTATCAAGGCGAGCACTCGGATTTCGGTCTGAGTTAGTAGCATACATTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(524,'4b35a1e7d233eb305da958f1b143dad3','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAACTATTGGGGGTTTGTTTGGCGGCGGCTGCAGGCATCATTTTGCTGGCGGCTGCTGCTGAGCAATCCCTATCAAGGCGAGCACTCGGATTTCGGTCTGAGTTAGTAGCATACATTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(525,'c7998b9b2e7999fe8bc5462f2833126f','TTGGCGGCGGCTGCAGGCATCATTTTGCTGGCGGCTGCTGCTGAGCAATCCCTATCAAGGCGAGCACTCGGATTTCGGTCTGAGTTAGTAGCATACATTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(526,'eae07e1164a3e7f761f15ba2686ddb29','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTTATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(527,'bfa5e3795777ba985d869d8d162a3474','CCACACCTAAAAACTTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTTATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAACGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(528,'e70ef7de684718bb39548dcfb2898523','CCACACCTAAAAACTTCCACGTGAACGTATCAACCCTATAAATTGGGGGTTCAACTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTYGGAGCTAGTAGCGTAATTTTAAACCCATYCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(529,'bca0dbce71cc95dd975dfaaf2d5b9d96','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTTAACTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCGTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(530,'a63dd18fa7eb553693c3cfd07134e7fb','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTCAACTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCGTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(531,'cea05e10efca2ad23c261d696e9c8172','TGGCGGCTGCTTCTGGCAGCTGCTGAGCGAACCCCATCATGGCGAGTGCTCGGACTTCGGTCGGAGTTAGTAGCTTGAATTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(532,'e39a46cc3bde1cb5d2935166f388b41f','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAACAAATTGGGGGTTTCATTGGCGGCTGCTTCTGGCAGCTGCTGAGCGAACCCCATCATGGCGAGTGCTCGGACTTCGGTCGGAGTTAGTAGCTTGAATTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(533,'b47cb24cc2853c0b50d8b4b9c9da13a5','CTGGCAGCTGCTGAGCGAACCCCATCATGGCGAGTGCTCGGACTTCGGTCGGAGTTAGTAGCTTGAATTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(534,'a90f49ea884eb304919439b028727788','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTTAACTGGTGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAATAGCGTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(535,'03794dcc2e1d2211c2a6bfbbf59e4807','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGGTGGCATGTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGCGAGTGTTCTGACCTCGGTTGGAGCTAGTAGCTTAAATTGTAAACCCATTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(536,'f154f90e74ea6ba7f2d8c3cb6cb62b95','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGGTGGCATGTTTTTGCTGGCTGGCTACTGCTGAGCGCACCCTATCATGGCGAGTGTTCTGACCTCGGTTGGAGCTAGTAGCTTAAATTGTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(537,'192788ece5b273e1d62dac6396e302df','ACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGGTGGCATGTTTTTGCTGGCTGGCTACTGCTGAGCGCACCCTATCATGGCGAGTGTTCTGACCTCGGTTGGAGCTAGTAGCTTAAATTGTAAACCCATTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(538,'1d4f6ed7ed0ddce96660f1fb84359924','GAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGGTGGCATGTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGCGAGTGTTCTGACCTCGGTTGGAGCTAGTAGCTTAAATTGTAAACCCATTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(539,'125b77ba7eae58ea8f033e93162d87d7','ACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCTGCTGGTGGCATGTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCATGGCGAGTGTTCTGACCTCGGTTGGAGCTAGTAGCTTAAATTGTAAACCCATTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(540,'de435dfee17f3c83e006dd80a16c14d6','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTATTTGGTGGCTGCTGCTGGCATCTTTTTGCTGACTGGCTACTGCTGAGCGAACCCTATCATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGAATTTTTAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(541,'06a4143d2878090d11206e877c7ccefa','CCACACCTAAAAACTTTCCACGCGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(542,'ab7dd18671382e61764f4fb9082d4385','ATCTTGGGGGTTTGTTTCATGACCGCTGTTGGCATCTTTTTGCTTGATGGCTACTATGGAATGAGCCCTATCATGCGTGTTTTGACCTTGGTCTGAACAAGTAGCATTACCATTATAAACCTTTTTATTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(543,'b7f25a07f76488b1b7e78c1c2ab81a43','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAACTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(544,'746eb96f8b0d043f949c3be20180964d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(545,'59910bf321c571758e0c4b5777b5dd03','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATGAATAGGGGGTTTATTTGGCGGCGGCTGCTGGCATTTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTGAGAAGGTGAATGTTCCGACTTTGGTTGGAATTAGTAGCTTGAATTGCAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(546,'952535f9ba4b53ed751c54a83b3d909c','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(547,'5d6efa0044044aaff2af122de912ad8e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGCATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(548,'8a26bc1dd2a61ecac22f4449575824b4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTTGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(549,'7b89740a6c5e0dd4fb5961d9fa58c821','CCACACCTAAAAAACTTTCCACGTGAAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(550,'0f9433a57a47ff7013613c0a9ecf6803','CCACACCTAAAAACTTTCCACGTGAACCGTATCACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTCATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(551,'bf75670042d5e01377ed75083cde9b60','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCGGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(552,'70ddfd95b2e9a40e9be0fc22b77db76b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCAACTAATTGGGGGTTTATTTGGTGGCGGCTGCTGGCATCTTTTTGCTGTCTGCTGCTACTGAGTGAACCCTATCATGGCGAGTGTTCGGACCTCGGTCTGAATTAGTAGCTCTCATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(553,'e836c8508b58435dbe79b48529b790fb','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCAATTAATTGGGGGTTTTATTGGTGGTGGCTGCTGCTAGCATCTTTTTGCTGGCTGGCGACTGCTAAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(554,'9e24e10e7fa26e027272832520186582','CCACACCTAAAAACAATCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTCCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(555,'bd52719c849ca23301624879072208ef','CCACACCTAAAAACAATCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(556,'4762a24b073d49ff18161575fa9d9e3e','CCACACCTAAAACAATCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(557,'25c2737d2c015a20dba2abb5a8a5bc36','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGACTGCTGCTGGTAACTTTTTTGCTGGCTGGCGGCTGCTGAGCGAATCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(558,'982d8929fe0c2cd1b4de504bf88859b7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(559,'913af3c0f83345e984abbe55870ed17d','CCACACCTAAAAACTTTCCCGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(560,'144ab8d7c75cc9acd8a367e267f06929','GAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGCTGCTGCTGGTAACTTTTTTGCTGGCTGGCGGCTGCTGAGCGAATCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(561,'37cb20ee7ceb70e0940a953840ba63b5','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGCTGCTGCCGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAACTTGAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(562,'a550662f2e33c362aa80af9633772c1c','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGACATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCCTGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(563,'42ad0e3b64bdd16f7855be4b5750c08a','CCACACCTAAACAACTTTCCACGTGAACCGTATCAACCCTATATCTTGGGGGTTTGTTTCATGACCGCTGTTGGCATGTTTTGCTTGATGGCTACTATGGAACGAGCCCTATCGTGCGTGTTTGGACCTTGGTCTAAACAAGTAGCATTAATATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(564,'6576d1633ccb1bd2ebdbccbed19c7511','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTCGGACCTCGGTCTGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(565,'73b504755747c7108a9c14891ca0f6d8','TTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTCGGACCTCGGTCTGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(566,'8945c3725578f0413183a4cdcbf848b6','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATCGTTTTGCTGGCTGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTCGGACCTCGGTCTGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(567,'5739c3a4f005f21eafbcb0c9cd25cdf5','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAAATTGGGAGTTTGTTTGGTAGCGGCTATTGGCAATTTTTGCTGGTTAGCTGTTGCGGAGCAAGCTCTATCATGGCGAATGTTTGGACTTCGGTCTGAATTAGTAGCTTCATTTTAAACCATTTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(568,'459626de2401cd7f0828a9cc7387b618','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAAATTGGGAGTTTGTTTGGTAGCGGCTATTGGCAATTTTTGCTGGTTAGCTGTTGCGGAGCAAGCTCTATCATGGCGAATGTCTGGACTTCGGTCTGAATTAGTAGCTTCATTTTAAACCATTTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(569,'518eeb9c19f21cd83f42f1f4384c7a35','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCTTGGTGATCGTTCTGACCTTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(570,'7a0def44c25fd0bedc77a50cafccbca0','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCRACTGCTGAGCGAACCCTATCTTGGTGATCGTTCTGACCTTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(571,'915771bebd8fceaf6f5eb6c9f8c3617a','CCACACCTAAAAAACTTCCACGTGAACCGTATCAACCCAATAAGTTGGGGGTTTAATTGACAGCTGCTGCTGGCATCTTTTTGCTGGCTGGCTATTGTTGAGCGAACCCCATCGTGAGCGTTCTGACTTCGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(572,'cb3bf8db724fbe8a125ac42ee04e91b3','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGCTGTTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCCTGGCGATCGCTCTGACCTTCGGTTGGAGCTAGTAACTTGCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(573,'0dd453c045f250a2c246d9d7b49e1464','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGTGGCTGCTGGCATCTTTTTGTTGGCTGGCTGCTGCTGAGCGAGCCCTATCATGGCGAGCGCTTGGACTTCGGTCTGAGCTAGTAGCTTTTATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(574,'f18a78fbdf6068cde9338f141e994dd5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATGAATAGGGGGTTTATTTGGCGGCGGCTGCTGGCATTTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCTGAGAAGGTGAATGTTCCGACTTTGGTTGGAATTAGTAGCTTGAATTGCAAACCCTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(575,'6fcdcfdb90fa9f2be155b3c8580386e5','CCACACCTAAAAACTTTTCACGTGAACCGTATCAAACACTTTATTGGGGGCTGACTTGGTGGCGGCTGCTGGTATCTATTTTTTTACTGACTGGCTGCTGCTTTGAGAAAGCCCTATCATGGCGATCGCTTGGACTTATATTCGAGCTAGTAGCTACTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(576,'1991caa1f8e1c0754cc7e9d05b66fc1d','CCACACCTAAAAACTTTTCACGTGAACCGTATCAAACACTTTATTGGGGGCTGACTTGGTGGCGGCTGCTGGTATCTATTTTTTTACTGACTGGCTGCTGCTTTGAGAAAGCCCTATCATGGCGATCGCTGGGACTTATATTCGAGCTAGTAGCTACTATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(577,'4333501f684812ff8a4fe68364ba0e08','CCACACCTAAAAACTTTTCACGTGAACCGTATCAAACATGTTATTGGGGGCTGACTTGGTGGCGGCTGCTGGTATCTATTTTTTGTACTGGCTGGCTGCTGCTTTGAGAAAGCCCTATCATGGCGATCGCTTGGACTTCTATTCGAGCTAGTAGCTACTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(578,'aa031aef1edb5eb198e117eada9f1f48','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAAGTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(579,'4826f33a9ac9ad3763ee5f5d1ce02ab3','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAGCTAATTGGGGGCTTATTTAGCGGCGGCGGCTGGCATATTTTTGCTGGTAGCTGCTGTTGAGTAAGCCCTATCATGGCGAGTGTTCGGACTTTGGTCTGAACTAGTAGCTTTAATTCTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(580,'243bd61035bda048c6ff7190654b3aa5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGCTGCTGCTGGTATCTTTTTTGCTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(581,'f15c7ad109f8b29a12ba4a4034f0c2ff','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAACTATTGGGGGTTTGTTCGGCGGCGGCTGCAGGCATCGTTTTGCTGGCGGCTGCTGCGGAGCAATCCCTATCAAGGCGAGCACTCGGATTTCGGTCGGAGTTAGTAGCATACATTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(582,'f979d65e106b376661320ca37b5fd622','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAATTCATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCGAGCCCTATCATGGCAAGCGCTCGGACCTCGGTCGGAGCTAGTAGCATTCATTTTAAACCCATTCCTAATGACTGAATGTACT');
INSERT INTO its1_sequence VALUES(583,'1e103dda06321e984555017050791d30','CCACACCTAAAAACTTTNCACGTGAACCGTATCAAACCAATTCATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCGAGCCCTATCATGGCAAGCGCTCGGACCTCGGTCGGAGCTAGTAGCATTCATTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(584,'62d3b89907028a84c9e11ac6e86c75fa','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAATTCATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCGAGCCCTATCATGGCAAGCGCTCGGACCTCGGTCGGAGCTAGTAGCATTCATTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(585,'0993e2f0f207174b8435fee54646b4f3','CTAAAACTTCCCACGTGAACCGTATCAAACCAATTCATTGGGGGTTTGTTTGGCGGCGGGCTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCGAGCCCTATCATGGCAAGCGCTCGGACCTCGGTCGGAGCTAGTAGCATTCATTTTAAACCCATTCCTAATGACTAAATATACT');
INSERT INTO its1_sequence VALUES(586,'6316aa7aed210d6fc9807a8e99279026','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTAACTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCGTTAATTTCAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(587,'645b1fa40f835008930a2dc779d738cd','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTYAACTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCGTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(588,'de9ba152c3fb8a486d707b65222f72a2','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAAATTGGGGGTTTAACTGGYGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCGTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(589,'8c8e43e240534b8017946495d2e645a5','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAATTAATTGGGGGTTTGCTTGACGGCAACTGCAGGCATCTTTTTGTTGCTGGTGGTTGCTGCCGAAAAAGCCCTATCATGGCGAGCGTTCGGACCTCGGTCGGAGCGAGTAGCTTTATTGTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(590,'9db70f1f7bbe240a4177b01c7d755404','CCGTATCAAACCAATTAATTGGGGGTTTGCTTGACGGCAACTGCAGGCATCTTTTTGTTGCTGGTGGTTGCTGCCGAAAAAGCCCTATCATGGCGAGCGTTCGGACCTCGGTCGGAGCGAGTAGCTTTATTGTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(591,'05e606210adc95c74408f44552e6881f','CGTATCAAACCAATTAATTGGGGGTTTGCTTGACGGCAACTGCAGGCATCTTTTTGTTGCTGGTGGTTGCTGCCGAAAAAGCCCTATCATGGCGAGCGTTCGGACCTCGGTCGGAGCGAGTAGCTTTATTGTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(592,'9a22e9768dda969d3d29226ad4f9a516','CTTTCCACGTGAACCGTATCAAACAACAAATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATCTTTTTTGCTAGCGGCTGCTGCTGAGCAAGCCCTATCATGGCGAGCGTTCGGACCTCGGTCGGAGCCAGTAGCTTTCATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(593,'31bf0ca3fc38cf7b8eff825035c378e4','CCACATCTAAAAACTTTCCACGTGAACCGTATCAAACCAATACATTGGGGGATTGTTTGGCGGCAGTTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCAATCTCTATCAATGGTGAGCGTTCGGACCTCGATCTGAACCAGTAGCTTCATTGTAAACCCATTTCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(594,'e756a7e92c794e777cec11a1a7ebe85a','CACATCTAAAAACTTTCCACGTGAACCGTATCAAACCAATACATTGGGGGATTGTTTGGCGGCAGTTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCAATCTCTATCAATGGTGAGCGTTCGGACCTCGATCTGAACCAGTAGCTTCATTGTAAACCCATTTCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(595,'01a22a8b1b298d689938313998d51613','CATTGGGGGATTGTTTGGCGGCAGTTGCTGGCATCTTTTTGCTGGCTGCTGCTGCTGAGCAATCTCTATCAATGGTGAGCGTTCGGACCTCGATCTGAACCAGTAGCTTCATTGTAAACCCATTTCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(596,'3d4d38bbb0a4f4719eecd0e0faeed6aa','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCGGCTGCTGGCATTTTTTTGCTGGCTGGCTACTGCTGAGTGAACCCTATCATAGTGAGTGTTCTGACTTCGGTTGGAACTAGTAGCTTGAATTACAAACCCTTTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(597,'a3f61e0fb9b4c8c68a0f84e13e667dbf','TTGCTGGCTGGCTACTGCTGAGTGAACCCTATCATAGTGAGTGTTCTGACTTCGGTTGGAACTAGTAGCTTGAATTACAAACCCTTTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(598,'21609791c4e36f5a363bb23d5ec9d233','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTAATTGGCGGCTGCTGCTGGCATTTTTTTGCTGGCTGGCTACTGCTGAGCAAACCCTATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(599,'f749a65bb20a090651431cf51957a470','CCACACCTAAAAACTTTCCACGTGAACTGTATCAAAACAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTGACATCTTTTTGTTGGCGGCTGCTGCTGAGCAAGCCCTATCATGGCGAATGTTCGGACCTCGGTCTGAGCTAGTAGCTTTCATTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(600,'99a486ed1fd1e702ecd2d32c36107b00','CCACACCTAAAAACTTTCCAAGTGAACCGTATCAAACAAACAAATTGGGGGCTTATTCAGCGGCGGCGGCTGGCATCTTTTTGCTGGTAGCTGCTGTTGAGTAAGCCCTATCATGGCGAGTGTTTGGACTTTAGTCTGAACTAGTAGCTTTAATTGTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(601,'338d7b048b5d961af5b0c5b8488e94f3','CCACACCTAAAACAACTTTCCACGTGAACCGTATCAACCCAATGCATTGGGGGCTTGTTTGGTGGCAACTGGTGGCACGTTTGTGCGGACTGGTTAATACGAGACAAGCCCTATCATGGCGAACGTCTGGGCCTTGGCCTGAATGAACTAGTAGCTTTTATTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(602,'a0484f21eb97a86f97af5afb296fee60','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCAACTATTGGGGGTTTGTTTGGCGGCGGCTGCAGGCATCATTTTGCTGGCGGCTGCTGCTGAGCAATCCCTATCAAGGCGAGCACTCGGATTTCGGTCTGAGTTAGTAGCATACATTTCAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(603,'6c616e901108ef3820c8e0308f7ab036','CTTTCCACGTGAACCGTATCAAACCAACTATTGGGGGTTTGTTTGGCGGCGGCTGCAGGCATCATTTTGCTGGCGGCTGCTGCTGAGCAATCCCTATCAAGGCGAGCACTCGGATTTCGGTCTGAGTTAGTAGCATACATTTYAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(604,'d4575fa744c00ef7200125abbf72c2a4','ACCGTATCAAACCAACTATTGGGGGTTTGTTTGGCGGCGGCTGCAGGCATCATTTTGCTGGCGGCTGCTGCTGAGCAATCCCTATCAAGGCGAGCACTCGGATTTCGGTCTGAGTTAGTAGCATACATTTCAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(605,'f4ad03a3d122c4267973b92c9d3fd160','CAAATAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGKTCTGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(606,'8474b0e0dd86a7e0600570c744b49bdb','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGATTTAATTGGTGGTTGCTGCTGGCATCTTTTTGCTGACTAGCGACTGCTGAGCGAATCCTATCATCGTGAGCGCTCTGACCTCGGTTGGAGCTAGCTTCAATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(607,'e40928cdd34d4a3507d5cfab96a657d5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACCTATACATTGGGGGTTTATTTGGTGGCGGCTGCTGACATTTTTTTGCTGGCTGGCTACTGCTGAGTAAGCTCTATCACGAGCGTTTGGACCTTGGTCTGAGCTAGTAGTTTATATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(608,'32a952ec1444ab020794601119551e02','TATTGGGGGTTTGTTTGGTGGCGGCTGCCGGCATGTTTCGATTTGCTGGCTGGCTGCTGCAGGGCAAGCCCTATCGCGAGCGTTTGGACCTTGGTCTGGACTAGTAGCTTGATGTCAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(609,'035db4406846bd6e6879edd99bfb5277','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTATATTGGGGGCTTGTTTGGCGGCGGCTGCCGGCATCTTTTTGCTGGCGGCAGCAGCTGGTCAAGCTCCATCAGTGAGCGTTCTGGTCTCGACCGGAGCTAGTAGCTTTCCTTTGAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(610,'d405a687fd4244faf882371f361139b4','TTTTTGCTGGCGGGCAGCAGCTGGTCGAGCTCCCATCAGTGAGCGTTTCTGGTCTCGACCGGAGCTAGTAGCTTTCCTTTGAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(611,'bc3b0573f8fcb9c21af9c9ef4cd5e19f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTATATTGGGGGCTTGTTTGGCGGCGGCTGCCGGCATCTTTTTGCTGGCGGCAGCAGCTGGTCAAGCTCCATCAGTGAGCGTTCTGGTCTCGACCGGAGCTAGTAGCTTTCCTTTGAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(612,'80299c6a630d968cbcd9ed0c1fb6de07','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGATTCAATTGGCGGTTGCTGTTGGCATCTTTTTGCTGACTGGCGACTGCTGAGCGAATCCTATCATCGTGAGCGCTCTGACCTCGGTTGGAGTTAGCTTCAATTATAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(613,'a54b32a74d44e3965dab2035a972de88','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCTAATAAATTGGGGGTTTAATTGGCGGTGGCTGCTGGCATCTTTTTGTTGGCGGCTGTTGCTGAGCAAGCCCTATCATGGCGAACGTTTGGACCTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(614,'8b000e94c05c43fce49205bcbd2b4cbe','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGTGGCTGCTGGCATCTTTTTGTTGGCGGCTGTTGCTGAGCAAGCCCTATCATGGCGAACGTTTGGACCTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(615,'389e397f191d8d7cfbc37656884ea265','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTTGATTGGCGGCTGCTGCTGGTATCTTTTTACTGGCTGGCGGCTGCTGAGCGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTAAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(616,'76ab4b1d40d9b70a17ecbcf44994790e','CCACACCTAAAACACCTTTCCACGTGAACCGTATCAATCCAATGAGTTGGGGGTTTATTTGGTAATGGCTGCTGGCATGTTTTATGCAGGCTGGCTGTTGCTGAGTAAGTCCTATCGTGAGCGTTTGGACCTCGTCGGTCTGAGCTAGTAACTTGAAATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(617,'02a5f2ac7ba8c3a175eae4f2c7f55e8c','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTAATTAATTGGGGGCTTAATTGGCGGCGGCTGCTGGCATCTTGCTGGCTGGCTGCTGCTGAACGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCTGGGTTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(618,'cd442bd7b7de9e8423b60f9a1ce616d5','CCACACCTAAAAACTATCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATATTGCTGGCTGGTTGCTGCTGAGCGAGCCCTATCATGGCGAGCGCTTGGGCTTCGGTCTGAGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(619,'bd7e03771e6ffe5aad7cce13e7ba7eaa','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGYGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(620,'9158777aacc05ef2df3f83d0d8e828f8','TCGTTGGCGGCTGTTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(621,'3026406c0b45f91ffcc0748adc90dc6b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTCTGTTTGGTGGCGGCTGCTAGCTTTTTTTTGCTGGCTGGCTGCTACTGGGCGAGCCCTATCATGGTGAGCGTTTGGACCTCGGTCTGAGCGAGTAGCCGTAATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(622,'c329d8a6dfa9922636ab376e67752661','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTATGTTTGGTGGCGGCTGCTAGCATTTTCTTACTGGCTGGCTGCTACTGGGCGAGCCCTATCATGGTGAGCGTTTGGACCTCGGTCTGAGCGAGTAGCCGAAATTGTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(623,'f4929571744dd0e9fe0baa1a4752bafa','CCACACCTAAACAACTTTCCACGTGAACCGTATCAACCCTATGTCTTGGGGGTTTGTTTCATGACCGCTGTTGGCATGTTTTGCTTGATGGCTACTATGGAACGAGCCCTATCGTGCGTGTTTGGACCTTGGTCTAAACAAGTAGCATTAATATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(624,'db28d42e303db6a4bacba75dff7942d3','CCACACCTAAAACAACTTTCCACGTGAACCGTATCAACCCTATATCTTGGGGGTTTGTTTCATGACCGCTGTTGGCATCTTTTTGCTTGATGGCTACTATGGAACGAGCCCTATCGTGCGTGTTTCGACCTTGGTCTGAACAAGTAGCATTAACATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(625,'817fde82e46166a7c04dc9e9b796fd12','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGACTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCAAACCCTATCATCGTGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(626,'dfb0bb3f3599cd816b6a8f76146b315f','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAAATTGGGGGTTTAATTGGCGACTGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGCAAACCCTATCATCGTGAGCGTTCTGACCTCGGTTGGAGGCTAGTAGCTTGAATTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(627,'b24ee0addb1922781bf34eb9ecaafe5c','CCACACCTAAAAACATTCCACGTGAACCGTATCAACCCCAAGTTGGGGGTTCGATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCCGAGAGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTTATTATAAACCCATTCCTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(628,'865016a66ebf96e71b4468361b0d95d5','TTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(629,'5609aad2ef87e4166ecf0f9eb83f9384','AAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTGTTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(630,'19f257676d655fbe98ef18e93391581f','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(631,'1d4e5f285ec9049817af92b4a3e7ee0f','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGGCGGCTGCTACTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGAGCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGTATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(632,'931d9910e55a11e01f37a1aec0300554','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTAATTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGCGAACCCCATCATAGTGAGCGTTCTAACCTCGGTTGGAGCTAGTAACTTACATTTTAAACCCATTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(633,'3015963462e1ae071fb43aec62428338','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTAATTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGACTACTGCTGAGCGAACCCCATCATAGTGAGCGTTCTAACCTCGGTTGGAGCTAGTAACTTACATTTTAAACCCATTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(634,'3490140ceef19f03e83ec5fe6bf74bec','AAAACTTTCCACGTGACCGGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(635,'14f794562a84cd56c159d336f23a0232','CCACACCTAAAAACATTCCACGTGAACCGTATCAACCCCAAGTTGGGGGTTCGATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCCGAGAGAACCCTATCGTGAGCGTTCCGACCTTGGTTGGAGCTAGTAACTTTATTATAAACCCATTCCTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(636,'37b3d343317074889e4966f6e9f15ed2','CCACACCTAAAAACTTTCCACGTGAACCGTATCACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(637,'9d055fac8544d245498a81b8fbff08a9','TAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(638,'12801b50eb94f47d95455fb954d89a2e','AAGCATTTATTTGGTGGCAGCTGCTAGCATATTGTATTTTTTTTTGCTAGTAACTGCTACTGAGTATATCCTGTCATGGCAAGCGCTCGGATCTTGGTTTGAGCAGGAGCATGAATTTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(639,'3fa58388cc2f430d85bc88dfe828dce0','TAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTCTTTTGCTGGCTACTGCTGTTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(640,'c240b3536e46b53a3e0df682bb43fbb5','CATTTATTTGGTGACAGCGGCTAGCATATTGTATTTGTTTTTGCTGGCTACTGCTACTGGGTATACCCTGTCATGGTAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(641,'434d8103d4e35ea4e2ffbb52846d36fb','CACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTAAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTCAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(642,'473553e8983c333646f700cfe202b11f','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTTATTGGGGGTTTCATTGACGGCTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCATGGCGATCGTTCTGACCTCGGTTGGAGCTAGTAGCTTGCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(643,'1e69abb3467057e92daad28a48e14d06','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(644,'ff559e0f90b9693d857e07390dff0732','CCACMCCTAAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTCTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(645,'82b9b4d8752f97602e9caedad0ad8fe8','TAAGCATTTATTTGGCGGCAGCGGCTAGCATATCGTATTTTCTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAACGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(646,'345b07b6e58fe6967f75afc715e8974d','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGCGAGTGTTTGGACCTCGGTCTGAACTAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(647,'cf1d2abeb347da5425be6050447364e6','CGTATCAAACAATTAATTGGGGGCTTACTTGGCGGCAGCAGCTAGCATATCGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATAC');
INSERT INTO its1_sequence VALUES(648,'bc6276a5c3f0b4fe993a6068e5d0ef8f','ATTTATTCGGCGGCAGCAGCTAGCATATCGTATTATTTTTGCTGACGACTGCTATTAGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGATTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(649,'3c54096865ddf0480c671661491ef95b','CCACACCTAAAAACTTTTCACGTGAACCGTATCAAACACTTTATTGGGGGCTGACTTGGTGGCGGCTGCTGGTATCTATTTTTTGTACTGGCTGGCTGCTGCTTTGAGAAAGCCCTATCATGGCGATCGCTTGGACTTCTATTCGAGCTAGTAGCTACTATTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(650,'c70bf434308bdca4e91f2fffe2ee5be4','CCACACCTAAAAACTTTGCACGTGAACGCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(651,'da159c01a9b0afceb0f5bc7b15e480e3','CCACACCTAAAAACTTTCCCGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(652,'96d91bf134a32b78e7277d45169214a2','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(653,'043a37efee8b65487f2cfb6bb91b0629','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(654,'86c7291634227699e98fd3490d101ab3','CCACACCTAAAAACTTTCCACGGTGAACCCGTATCAACCCCAATAATTTGGGGGGTTAATTTGGTAATGGCTGCTGGCATCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCGAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(655,'523bf55473d79f70efc0c66c87ca8b65','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACATTAGTTGGGGGTTTGATTGGCGGTTGCTGCTGGCATCTTTTTGCTGGCTGGCGACTGCTGAGCGAACCCTATCCTGGCGATCGTTCTGACCTCAGTTGGAGCTAGTAGCGCGAATTTTAAACCCATATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(656,'e3a3135c7914340684363d7d1655a438','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTCGTTGGCGGCTGCTGCTGGCATGTTTTTGCTGGCTGGCAGCTGCTGAGTAAGCCCTATCATGGCGAGTGCTCTGATCTCGGTCGGAGCTAGTAGCTTCAATTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(657,'241ca53cd1d4b98214ecf19e96c0108d','CCMCMCCTAAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTCTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(658,'048fade7640b274e4ec77c89ffe171d8','CCACACCTAAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTT');
INSERT INTO its1_sequence VALUES(659,'7cd05c7fc57941203267693f11d867b2','TTGGCGGCAGCAGCTAGCATATCGTATTTTTTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(660,'0cf51702404edea00d5f0c4967fdde30','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTGTTTGGCGGTGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(661,'52b33a7883f94b505a9052440346297f','CCACACCTAAAACAACTTTCCACGTGAACCGTATCAACCCAATGCATTGGGGGCCTGTTTGGTGGCAACTGGTGGCACGTTTGTGCGGACTGGTTAATACGAGACAAGCCCTATCATGGCGAACGTCTGGGCCTTGGCCTGAATGAACTAGTAGCTTTTATTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(662,'776b638c353a20079808de079a757a81','CCACACCTAAAACCTTCCACGTGAACCGTATCAACCCAATAATTTGGGGGTTAATTTGGTAATGGCTGCTGGCACCTTTTTGTTGGCTGGCTGTTACTGAGTAAGCCCTATCATGGCAAGAGTTTGGACCTTTGTCTGAACAAGTAGCTACGATTGTAAACCCGTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(663,'f4cfaa729b8b75c4ff56582ec26f2488','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTGTTTGGTGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(664,'baa5aecb4c0acf3fa5d929b3310104ba','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTATTTGGTGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(665,'1928e3f387668ca8c4e9f3ac4c204491','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTATTTGGCGGCGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(666,'1d541f0ffeb31f6f9803356cb3cc7c0f','CCACACCTAAAAAACTTTCCACGAGGAATCCGTATCAACCCAACATAATTGGGGGTTTATTTGGCGGCGACTGCTGGCATTTTTGTGCTGGCTGGCTGCTACTGGGCAAACCCTATCGCGGAGCGTTTGGGCCTTGGCCTGAACTAGTAGCTTTTATTTTAAACCCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(667,'7e332cf4c5336adea3ed1f0c92e8b7b6','CCACACCTTAAAAACTTTTCACGTGAACCCGATCAACCAACATAATTGGGGGGTTGTTTGGCGGTGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(668,'987b9e8b13c90ea34fb557f346235fa8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCANCNACATAATTGGGGGTTTGTTTGGCGGTGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(669,'c2a0adedd84665d8dc790e8008ae9fba','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACATAATTGGGGGTTTGTTTNGCGGTGGCTGCTGGCATTTTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(670,'f2f12891c11f0c10483f3d699017d1bf','TTGGGGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(671,'228d1c7598a9ca7acdfd2dd0edd25c81','TTGTGCTGGCTGGCTGCTACTGGGCAAGCCCTATCGCGAGCGTTTGGGCCTTGGCCTGAGCTAGTAGCTTTTATTTTAAACCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(672,'832567ffddaa1cc13bc59114b9524e2f','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAACTAATTGGGGATTTAATTGGTGGTTGCTGTTGGCATCTTTTTGCTGACTGGCGACTGCTGAACGAATCCTATCATCGTGAGCGCTCTGACCTTGGTTGGAGTTAGCTTCAATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(673,'61a71fa75f2ffe5383b4edcbeec363dc','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAACTAATTGGGGATTTAATTGGTGGTTGCTGTTGGCATCTTTTTGCTGACTGGCGACTGCTGAGCGAATCCTATCATCGTGAGCGCTCTGACCTTGGTTGGAGTTAGCTTCAATTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(674,'570fc9938849fa23d6d4dc2dc5040dfa','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGAWTCAATTGGCGGCTGCTGTTGGCATCTTTTTGCTGACTGGCGACTGCTGAGCGAATCCTATCATCGTGAGCGCTCTGACCTCGGTTGGAGTTAGCTTCAATTATAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(675,'34218020a198fa23eceff1a1dc2106a7','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGCGGCTGCTGGCATCTTTTTGTTGGCGGCTGCTGCTGAGCAAGCCCTATCATGGCGAACGTTTGGACTTTGGTCTGAGCTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(676,'c013d70b7618ed888bcb4a390b539e21','CCACACCTAAAAACATTCCACGTGAACCGTATCAACCCCAAGTTGGGGGTTTCATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGAGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTATTATAAACCCATTCCTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(677,'05325503378ea51a75efefbb28719fa3','CCACACCTNANANCATTCCACGTGAACCGTATCAACCCCAAGTTGGGGGTTTCATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGAGAACCCATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTATTATAAACCCATTCCTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(678,'8b869b68bcf62a985cfabdd2193fda53','ACCTAAAAACATTCCACGTGAACCGTATCAACCCCAAGTTGGGGGTTTCATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGAGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTATTATAAACCCATTCCTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(679,'405b35eb49019dcd313e46ef6968e879','AACCGTATCACCCCAAGTTGGGGGTTTCATTGGCGGCGGCTGCTGGCATCTTTTTGCTGGCTGGCTACTGCTGAGAGAACCCTATCGTGAGCGTTCTGACCTTGGTTGGAGCTAGTAACTTATTATAAACCCATTCCTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(680,'1a2e7f6178d03a031d93fbb907f5c731','AAAAACTTTCCACGTGAACCGTATCAAACCAACTATTGGGGGTTTGTTTGGCGGCGGCTGCAGGCATCATTTTGCTGGCGGCTGCTGCTGAGCAATCCCTATCAAGGCGAGCACTCGGATTTCGGTCTGAGTTAGTAGCATACATTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(681,'49e139bcab078eac2532f45883ad23d9','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCAATAAATTGGGGGTTTAATTGGCGGCGGCTGCTGACATCTTTTTGTTGGCGGCTGCTGCTGAGCAAGCCCTATCATGGCGAACGTTTGGACTTCGGTCTGAGCTAGTAACTTTTATTTTAAACCCTTTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(682,'08f0942be6d23bf1fa4505ecce4b72d0','CCACACCTAAAAATTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTTTTTGCTGGCTACTGCTGCTGT');
INSERT INTO its1_sequence VALUES(683,'9ffa1643a31ae286245071e147d75cf2','CAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCAT');
INSERT INTO its1_sequence VALUES(684,'8800d0ff374871dc2be9644f136cef14','CCACACCTAAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTTTTTTGCTGGCTACTGTTGCTG');
INSERT INTO its1_sequence VALUES(685,'4092daf9f0b223362a514ca8874b4be7','AGCATTTATTTGGTGGCAGTTGCTAGCATTTTGTATTTTCTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAACGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(686,'620fade8a7d66e0f4c26d75222b0239e','CCACACCTAAAACTTTCCACGTGAACCGTATCAAACAATTCATTGGGGGCTTATTTGGCGGCAGCAACTAGCATATCGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTT');
INSERT INTO its1_sequence VALUES(687,'743df6616e42ce51f843d8780930f2c3','ATTTATTCGGCGGCAGCAGCTAGCATATCGTATTATTTTTGCTGACGACTGCTACTAGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGATTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(688,'151246a37f4f5e896e62cb964b85d07b','ATTTATTCGGCGGCGGCAGCAGCTAGCATATCGTATTATTTTTGCTGACGACTGCTACTAGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGATTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(689,'a8dff6ffc814b18449ccbfa8ed906eff','TTCCACGTGAACCGTATCAAACAATTCATTGGGGGCTTATTTGGCGGCAGCAACTAGCATATCGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTT');
INSERT INTO its1_sequence VALUES(690,'f8846359f69bb9503ae9577fed775d64','CCACSCCTAAAACTTTCCACGTGARCMGYATCMAACAATTCATTGGGGGCTTATTTGGCGGCAGCAACTAGCATATCGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTT');
INSERT INTO its1_sequence VALUES(691,'54c94d599b3db0c7b9af546f7550a693','AAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(692,'b3a57e7b377d98ecbd549b8bba63db8e','AGCATTTATTTGGTGGCAGCTGCTAGCATATTGTATTTTTCTTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(693,'d986804cc700daff1cc0f4f88855b1ef','CAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGG');
INSERT INTO its1_sequence VALUES(694,'37de848f4f8f8c6e99336807a57cc30a','CCACACCTAAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGTGGCAGCTGCTAGCATATTGTATTTTTCTTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(695,'d60115f9d54e42b3ec216c198eb7c1b3','CAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(696,'e773546a05a99c1f2eaddce7fe0f6912','CATTTAYTTGGTGGCAGCTGCTAGCATATTGTATTTTTCTTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(697,'6a7b05b97c5550642ea0a8270ab793b8','GTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(698,'aadefc3ab242dfb4fccab1bab0f5e030','AAGCATTTATTTGGTGGCAGCTGCTAGCATATTGTATTTTTCTTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(699,'9295d87d278c24703a14ad144b71e225','ATTAATTGGGGGCTTATTTGGTGGCAGCTGCTAGCATATTGTATTTTTCTTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(700,'68d7604469fa3d927cc5221190773cfb','CCACACCTAAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATCGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATAC');
INSERT INTO its1_sequence VALUES(701,'e6818f80f44af062728160f3865ec24b','TTTTTGCTGACGACTGCTACTAGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGATTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(702,'5dd3cb5c57e0f21f3a81bc79a8ea5aca','GTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATCGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATA');
INSERT INTO its1_sequence VALUES(703,'f2431a6147d3483bbbad11757427bd8b','ATTTTTGCTGACGACTGCTACTAGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGATTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(704,'e72646777ee29c7e293bf4d7264d72c9','AGCATTTATTTGGTGGCAACTGCTAGCATATTGTATTTTTTTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(705,'2c024c791c61914923a7df728e57f349','GCATTTATTTGGTGGCAACTGCTAGCATATTGTATTTTTTTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(706,'7d5c65eaad5460747d74e3187996a1f4','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAATTAATTGGGGGCTTATTTGGCGGTAGCAGCTAGCATATTGTATTTTTTTGCTGGCTACTGCTGCTGTGT');
INSERT INTO its1_sequence VALUES(707,'aeea330f2847d1a2758398136d3b1c46','CCACACCTAAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGTAGCAGCTAGCATATTGTATTTTTTTGCTGGCTACTGCTGCTG');
INSERT INTO its1_sequence VALUES(708,'7f7c0a94a2746991b0350f72a3a4f995','CATTTATTTGGTGGCAACTGCTAGCATATTGTATTTTTTTTGCTGGCAACTGCTACTGGGTATACCCTGTCATGGCAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(709,'a109c3ee00953bb3a8d116d6c6ef0e6c','CCACACCTAAAACTTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGTAGCAGCTAGCATATTGTATTTTTTTGCTGGCTACTGCTGCTGTGT');
INSERT INTO its1_sequence VALUES(710,'b53deb63a0a95ca3047ce07d067166e0','CCACACCTAAAAATTTCCACGTGAACCGTATCAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(711,'56da0a6906b750dded1c6769571c3792','CATTTATTTGGTGACAGCGGCAAGCATATTATATTTGTTTTTGCTGGCTACTGCTACTGGGTATACCCTGTCATGGTAAGCGCTCGGACCTTGGTTTGAGCAGGAGCATGAATTTTAAACCATTTACTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(712,'8fa1321457e93f62fb2d48802ff20e0d','CAAACAATTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(713,'e58aff77b0befd6871cefe4d8e33f59e','TAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(714,'f2a3aa70873631303931a5bf6f18f602','TTAATTGGGGGCTTATTTGGCGGCAGCAGCTAGCATATTGTATTATTTTTGCTGGCTACTGCTGCTGTGTAAGCTCTATCATGGGTATACTTGGCGGCAGCAGCTAGCA');
INSERT INTO its1_sequence VALUES(715,'ebdeb1ca76ed94a9dcbb3d56f2bf5bb9','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCAACAAATTGGGGGTTTGTTTGGCGACAGCTGCTGGCATCTTTTTTGCTAGCGGCTGCTGCTGAGCAACCCTATCATGGCGAGCGTTCGGACCTCGGTCGGAGCCAGTAGCTTTCATTGTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(716,'4b220b3c851f703e8f0dd03f853d83bb','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACAATTTATTGGGAGGTTATTTGGCAAGGCTACTGGCATGTATTTGCTGGCGGCTGCTGTTGAGTAAGCTCTATCATGGCGAACGCTCGGACTTTGGTCGAAGCTAGTAGCATTATTTTAAACCATTTCTTAATTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(717,'d3f0cbdbad4c80b938cad0f90d81dd6d','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGTGGTTGCTGCTGGCATGTTTTTGCTGACTGGCGACTACTGAGTGAATCCTATCATAGTGAGCACTCTAACCTCGGTTAGAGCTAGCTTCAATTATAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(718,'0d2bbc06f62c68cc158fac1c4460cdc3','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACCCATTTGGGGGTTTGTTTGGCGACTGCTACTGGCATCTTTTTGCTGGCTGCTGTTTCTGGGCAAACCCTATCATGGCGAGCGCTCGGACCTTGGTCGGAGCTAGTAGCTTTCTTTTAAACCCATTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(719,'a9ce085146c2388b361e39fa2f2da2fd','TGGGGGTTTACTTGGCGGCGGCTGCTAGCRTCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(720,'de6d22e460311268b29547c8d71dcb88','CGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(721,'5b2e9ee5e092be5db3516a595f82068d','GAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(722,'ccaa61d43f9a9bab86267a7c40ed0a16','CCACACCTAAAAACAATCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(723,'216fce2ff9c6684d5df3e21e8c12a4e4','ATCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTTGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(724,'a09f19dab321d2e42a79c77b8452fb61','CCACACCTAAAAACAATCCACGTGAACCGTATCAACCCAATAATTGGGGGTTTACTGGGCGGCGGCTGCTAGCATCTTTTTGCTGGCTGGCTACTGCTGAGTGAATCCTATCGCGAGCGTTCTGACTTCGGTTGGAGCTAGTAGCTTAACTTATAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(725,'3504d1ac4b710111170c93077becfa86','CCACACCTAAAACACAACTTTCCACGTGAACCGTATCAACCCCATATCTTGGGGGTTTGTTCATGACGGCTGCTGGCATGTATTTGCTGGATGGCTATTATGAAGCAAACCCTATCGTGAGCGTTTCGACCTTGGTCTGAACTAGTAGCATTAACATTATAAACCTTTTCTTAACTACTGAATATACT');
INSERT INTO its1_sequence VALUES(726,'7d3ebf43179f0fb913b0f3fcd4468c05','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGTGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTCAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(727,'cc9e34420e0e88712195e924e462fe9d','GTATCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGTGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTCAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(728,'c7b1a51cd408f881c4e34144e58b8751','TCAACCCAATTAATTGGGGGTTTACTTGGCGGCGGCTGCTGGCATAGTTTTGCTGGCTGCTGCTGCCGAGTGAGCCCTATCATGGTGAGTGTTTGGACCTCGGTCTGAGCTAGTAGCTTTAATTTCAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(729,'e92d864d2e56fef0f496c6cc4a10bd06','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCACTTAATTTGGGGGTTTAATTGGCGGCGGCTGCTGGCATCTTTTTGTTGGCTGGCTGCTGCTGAGCGAACCCTATCATGGCGAACGCTTGGACTTTGGTCTGAGCTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(730,'e6792a7670c75f3da3c48c7ce5cfd093','CCACACCTAAAAATCTTCCACGTGAACCGTATCAACCAATTAATTGGGGGCTTTCTTGGCAACGGCTGCGAGCATCTTTTTGCTGGCTAGTTCTTGCGGAGGAAGCCCTATCATGGCGAGCGTTCGGACCTCGGTCTGAACTAGTAGCTTCAACTTGTAAACCCTTTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(731,'f10e2218d3a81b412ef5f112a9ab695b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGAATKAGCCCTATCATGGCGAGCGTTTAGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(732,'0daccf1206cae47d10b677e5fe7d6135','GTTTCAACCCAATTAGTTGGGGGCTTGCTTTGGCGCGCGGCTGTTGACCTGTCATGGGTGGACGGCTGCTGCTGGGGCGGGCTCTATCAAAGGCGATCGTTTGGACCTCGGTCCGAGCTCGTAGCTTTGTCTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(733,'707dc330e7972f099770e491a744dcb5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(734,'bf698a6be6085a3cb8bfb9068e9adbad','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(735,'21682e55384889609de1965cddbb0e06','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTTAACATTCTTGATTATTC');
INSERT INTO its1_sequence VALUES(736,'5b88a50a15b1ff895088923bb328a32b','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(737,'a16d78e86a620d1b749510f781b0a01a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(738,'e5e453b5bfcb8cc22fc7a260ea40e8f4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(739,'463b2a9211f6bf84c1202b5c08549993','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(740,'590f2dd809d88edb14370800e7e4a3a8','CCACACTTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(741,'3ee305508aa4b52189e3adac189f8bbd','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGAGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(742,'d0e76cca856398dcbeb2433a857d1b47','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(743,'162f6682da2c38c979419260c38efa0f','CCTAAAAACTTTCCCCGGGACCCGAACCACCCCCAATAATTGGGGGCTTGGTTGGCGGCGTGTGGGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCCATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(744,'26f7c2d377cd57feaabf8e548286328d','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(745,'5a11b68ba3c47725f0eb39bab982be19','GTGAACCGTATCTCCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGACCTTGTTACGACTTCCTCNANAGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(746,'098a04c599f066aaac50ccaf5de36ceb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTAGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(747,'8335674b30bdc31336d3f777a88565a1','CGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(748,'1b63c73b085d72f2cd1696adac7a1213','CCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(749,'3062de7a3647193babd7d6b21c9158cf','TAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(750,'d580d0b844fc060c959dba5aaf4e8f4c','CACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(751,'20548d2ef6df0a07d89f6f0164bca0c3','TGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(752,'c1dd8f5ea16baa93782eeb30e041cdab','CTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(753,'1d44fdf2743284d8ed6d74281623a512','CACCCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(754,'d436c6fd4a8cbc04c7b3fa80d0fa763d','CCACACCTAAAAAACTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(755,'7adb26dcf1bde455043dafa7ea06312c','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(756,'8860dedc79b2b29e053d4746a9a02ed2','CACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(757,'258ad9c509ae62cde5e7de5dde5b96fa','CCACCCCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(758,'87ab5c6dc5179b6b36e7c60218def3bd','CCCACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(759,'8230d095ad57b14996016b01e17de8de','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCNNGTCCNNGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(760,'4037737223e84259f5833f83f519760a','CCACCCCTAAAAAACTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGNGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(761,'5e11dbaa117d79dbcbb0a5ab5fdf505e','CACACTAAAAAACTTTCCACGTGACCCGTATCAACCCACTTAGTTGGGGGCCTGTCCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(762,'ebdb5d73372cb0355662d9eb62574d64','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCNTGTCCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(763,'42b8fa15db5d6521884c0fb0a8f2a204','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(764,'9edd490e0c2d7fd181dc18c65fbeb8a6','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGCCTCTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(765,'9d46cc7b50129505b28c69f9cc3e8588','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(766,'dab6b2f506c6f8da9fcc79355d9dbf49','CACACTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(767,'84f6607fa151e6819465d76c18cd95b2','CCACACCTAAAAACTTTCCACGTGACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(768,'df101d5a3248d32439a533d81bfbff20','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(769,'2fee507d77de25c53cbfab9b81827bbe','CCACACCTAAAAAACTTCCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCCTGGCTGTCGATATCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(770,'5418ddf75881bbc1062b3d113b9ff629','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(771,'1fc48b1eea8ba63b4498855dfd99ea5a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTCGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(772,'ccddc475fb6723ee1aec81e76e2450a1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGGCGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTCGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(773,'925b2fc0f10628fbd04dc66c3af0ff2c','TTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(774,'0145f11b63e5ea47927a320e6154dd64','TTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(775,'601d092e6a05f9810c082ead3a578cd1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(776,'ea1a48610a0e5c6b877056e46c562c3d','TCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(777,'5c73a8901cc0bea6d8cd7213ab37acb6','TTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(778,'de8e1f1637ea80da74a3d8ce0683d81a','GAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(779,'6c27ba33f6f12ad46194b1fd2917073c','TTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(780,'f5196c11ce34657205c165a12639aa67','CCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(781,'75c03ae3f23ccc95975bc2dc6ae53396','TGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(782,'106fd17be04334c00b55d29fc0945137','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYNGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(783,'75c60309233c7b093b6201ef15641ab8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(784,'d38b45c5d3870477f5ce3188f972d6bf','CACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(785,'7f9fbe27cda5f14ee5fa3f603150b7cb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(786,'428932a4654020a9ea003c0c8844deec','TTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(787,'dc40a07d01c2c94e9b558a3c69a9ca46','TGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(788,'ea9a25c99f56c7f840377a335aafaa11','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(789,'83c46dc61777a5659d2867cabcea81d4','CCACACCTAAAAAANCTTTCCACGTGAACCGTATCAACCCYTTTWAWTTGGGGGCTTGTTCGGCGGCGTGYGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACNCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(790,'86f618dfcfed6daa1976a8084fdbd4b4','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCYTTTWAWTTGGGGGCTTGTTCGGCGGCGTGYGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACNCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(791,'0368431c779b6d3b2555f68f90d047c5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(792,'63cc2d6383721803ebd2fc25fcf507f2','CACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(793,'0cbc02e59354a7832e7f76cd76220851','CTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(794,'408cfdec243d93207a2f3197675023d6','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(795,'dc4a15a87c5e72343119fe26b0dc98bd','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(796,'8d474e01fb442258c1b219c70011533f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGGCGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(797,'a9bcb2f6d1a0164a0dbd298b88bb1a67','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACTTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(798,'101d44a1b3d48121589b42d566dda15d','CCACACCCTAAAAAACTTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(799,'7ad149f17cc9641b5f5a86b1c9a76257','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(800,'d4d9f34f7717b6f7f73d47c296dcfa06','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(801,'958748123d4f56aac51beaf0a945e354','CCACACCTAAAAAACTTTCCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGGCGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(802,'2ebda2ec0fb63e409c4df006537853ba','AAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(803,'49483de834ce589edd829fabd60712c2','CTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACCGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(804,'1ccb4f343b5421beb44b1095d4901c07','CCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCGCTCTGGGCTTCGGCTTGGGAGTTAGTAGCCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(805,'82684ba72f5fdd816d8056445ccaddbc','TCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCGCTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(806,'524d893a8554155adc63fd07d949535d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGTCTGGGTGGCGGCTCTATCATGGTGACCRCTCTGGGCTTCGGCTTGGAGTTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(807,'ac9d65d0f83541a9291a94bc6647f51b','CCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCCTTCAAATCGGGGGCTTGCTCGGCGGTGGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTGAATAACTGAAATAC');
INSERT INTO its1_sequence VALUES(808,'7839843fa34bd922342b7bf867ee6f1c','CCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCTTCAAATCGGGGGCTTGCTCGGCGGTGGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTGAATAACTGAAATAC');
INSERT INTO its1_sequence VALUES(809,'b55c05d42d690aae1c1301cd1e3404b1','CACACCTCAAATCTTTCCACGTGAACCGTTGTGATTGCCCTGGTTGGGCATGACGTGGGGCTTCCCTGCGTGTGTGCGTGCGTGCGTGTTTGCGCGTGCATGCGTGCGTGCGGGTTGAGGCTCCGTCTGGGTGTTGTCGTGCTGTGCGATGCGTTGTAGCGTTGTGCGGCGTGGCGTTGCCTGGCGCGTTTTCTTTTGAACCCTTTGCGAAATGACTGAGTATACT');
INSERT INTO its1_sequence VALUES(810,'a04dd171b69fefcfa3077e644f71edc8','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(811,'74c6f7cf507ae0baf197a3c0e9f23ff0','CTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(812,'28e393b563aa5cb0945922fb04311475','CCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTGCTTGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTTAAACCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(813,'782f80aad23135ed7aaf3ecf0c3e48a2','TGAACCGTATCATCATTAATATAGAGAAAGGATATATGGCATTGGTGTGCGGCTAGCTGGCCTTTATTTGGCTGGCAGGCTGCGTGCTGGGCGAGTCCAATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTTTTAAACCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(814,'371b61e21b915673c18d0298efd88599','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTGCTGGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTTTTTTTAAAACCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(815,'2188ef1300af10780cd5ecbd5f050d78','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTGCTTGGTGTGCGGCTAGCTGGCCTTTATTTGGCTGGCAGGCTGCGTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTTTTAAACCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(816,'4d58590ca68274a03e94965d0e737594','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCCAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(817,'76eca1aee1892b9696241fdff252bd94','CACCTAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGTTGGTGGGTTGAGGCCTATCAAAGCGAGTGATTTGGGCCGCAAGGTCTGAGTTGCGAGTTTTCCTTTTAAACCCATTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(818,'ecbd49e3533e7912b42048857713c336','TGGGGACTCCTCGTCGGCGGCTTTCGGGCTGTTGGTGGGTTGAGGCCTATCAAAGCGAGTGATTTGGGCCGCAAGGTCTGAGTTGCGAGTTTTTCCTTTTAAACCCATTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(819,'d4e4c1d69571f42564597ade02cec705','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGTTGGTGGGTTGAGGCCTATCAAAGCGAGTGATTTGGGCCGCAAGGTCTGAGTTGCGAGTTTTCCTTTTAAACCCATTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(820,'8e02434d0d0ad4338cfd1b72ba8ad6b1','CCACCCCTAAAAATCTTTCCACGTGAACCCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGCCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(821,'aa75fd1eabc9a50c6abe86d43daf7393','CACCCTAAAAACTTTTCACGTGGGACGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCCAGTAGCCCTTTTTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(822,'9bf5e139cc41ce5bd9d92d36369a3bc6','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(823,'78bb3170f386c0fff2445e30b0829e3b','CCCCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(824,'931ab09633090bb91d9a01e72df965ea','CCACACCTAAAAAACTTTCCACGTGAACCCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(825,'bb9fdd97590a82432237c7e29a37d18e','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGATGGGTTGAGACCTATCAAAGCGAGTGATTTGGGCTGCAAGGTCCGAGTTGCGAGTTTTTAATTTTAAACCCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(826,'82355e72488705feebe39d0e9676afab','CCACACCTAAAAAACTTTCCACGTGACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGATGGGTTGAGACCTATCAAAGCGAGTGATTTGGGCCGCAAGGTCCGAGTTGCGAGTTTTTAATTTTAAACCCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(827,'6148968e70eb8f60a7c057c925d065b3','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGATGGGTTGAGACCTATCAAAGCGAGTGATTTGGGCCGCAAGGTCCGAGTTGCGAGTTTTTAATTTTAAACCCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(828,'6052abc151eab1a8cae42379b129a131','CCACACCTAAAAAACTTTCCACGTGACCCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGATGGGTTGAGACCTATCAAAGCGAGTGATTTGGGCCGCAAGGTCCGAGTTGCGAGTTTTTAATTTTAAACCCATTACTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(829,'31aea79c8db23782b0e0d215d4472a96','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGTTGGTGGGTTGAGACCTATCAAAGCGAGTGATTTGGGCTGCAAGGTCCGAGTTGCGAGTTTTCCTTTTAAACCCATTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(830,'16f4d42c1693c68610913dc42f4e62bd','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTCGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(831,'34ff3ee09166a3375e98722920351da9','CACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(832,'ab0f894fd9e6535f535f95f5c40bc8c6','CCACACATAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(833,'d7ee599d33e46e36a56b573e86d800c6','CCACACCTAAAAAGCTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(834,'2f782260293f40cfb2968cd4a20a7f2c','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGTTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(835,'90dad4088628b08cbb48ef1a8040956b','CCACACCTAAAAAACCTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(836,'4751d674c2ddff5b556ba867d091a1e1','CACACTAAAAAACTTTCCACGTGAACCGTCAACCTTTTAGTTGGGGACTCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGCGACCTATCAAAACGAGTGATTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(837,'deb6f07ef578e9c1a0b70ff2083f453d','CCACACGTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(838,'6fd68086e28cac589f66894dadeac7f4','CCACACCTAGAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(839,'7eb19b15e9aa4b7b664d1d684c35836b','CCACACCTAAAAAACTTTCCACGTGAGCCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(840,'8242cf4836548aae2779c2ef0c0a0ecc','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACTTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(841,'d82522206e9c6b73cbc45933b2e0ea53','CACACTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(842,'ea05507fbe9ea9a6113b4aba499eb58a','CTAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(843,'817b204fa6a76d72da48b41a429e27ad','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTCTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTCTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(844,'01de34d8a85a2f0f4c6ebf4c5e6cf6df','CCACACCTAAAAAAATTCCACGTGAACCCCTCAACCCTTTAGTCGGGGGTCCTCGTCGTCGGCTCTCGGGCTGCTCGTGGATTGAGACCTATCAAAACGAGCGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTCATACTGATTATACT');
INSERT INTO its1_sequence VALUES(845,'622ca240a4e36e5e0a4c97e5ef6379c3','CCACACCAAAAAAACTTTCCACGTGACCCGTTCAACCTTTAAGTGGGGGACTCCTTGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(846,'edcfd86269d16b1efe1a20cc24385449','CCACACCTAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGCGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(847,'6dc4293bb4d3a7bb432bffdc52be4c0d','CACACTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(848,'408586447e14afe457ce39fffdc8c307','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(849,'9ab6cc74ae4af0f7ce3a5fefb3f8872e','CACCACTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(850,'1a3d7ce8ab87bd0ad9dacdb59073c827','CCACAACTAAAAAACTTTCCACGTGACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(851,'f374f22f5cd768165fffe24bc16f08a7','CTAAAAAACTTTCCACGTGAACCGTTCAACATTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(852,'2ae6d663c4891b45a9fc4bd8bce2cad8','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACCTGTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(853,'4afe90a5b2de7e9b65f6877c2e2da091','CCACACCTAAGAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(854,'8b4f9a6e159e72a73613fe2b85b14fca','CACACTAAAAAACTTCCACGTGAACGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(855,'4c7b27dbc2b3a51530af600cc167b594','CCACACCTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(856,'c5e078c144497ab0d7ef57ced064c4e5','CACACTAAAAAACTTTCCACGTGAACCGTTCAACTTTTAGTTGGGGACCCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(857,'1670f38e4f17fbc9dc9140c16cad90cb','CCACACCCAAAAAAACTTTCCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(858,'49db29a241059e2dd8e978af2827f30d','AAAAAACCTTTCCCGTGAACCGTTCACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGCTGGTGGGTTGAGACCTATCAAAACGAGTGATTTGGGCTGCAAGGTCTGAGTTGCGAGTTTTCTTTTTAAACCCATTACCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(859,'fc270df94607729db705dde632584e89','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGYTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(860,'5af6dcf2c1fb2f7028a65c2992751ee0','CTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(861,'e190649c148da45255fcbfa6f84b2e10','CCACACCTAAAAAACTTTCCACGTGAACTGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(862,'7e15b0bec81fea91ed376ac5a36b4978','CCACACCTAAAAAAACTTTCCACGTGCAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(863,'c274ceb448d1457b7310f5ac3664202b','CTAAAACTTTCCACGTGAACCGTTTCAACCCTTTTAGTTGGGGGTGGTGCTTGGGGTTTTGTTGAGCCCCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(864,'109ed8ebdaa42dbb4dd9ef4596984028','CCTAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTAGTTTGGGGTGTTGCTTGGCGTTTTGTTGAAGCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(865,'c3c2a331dc9932eb72b57ee848f6e3d4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(866,'edc4b8e61a5a665de1d574108c3f3e75','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGGCTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(867,'0106a183fbbc7e4b49c1d1ebf791932a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTTAAAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(868,'32f165124b2c1a80c768922c2b55eea0','CCACACCTAAAAAACTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(869,'a406ffe0470f4c1456156beb6ec2a874','AAAACTTTCCACGTGAACCGTTTCAACCCTTTTAGTTGGGGGTGGTGCTTGGGGTTTTGTTGAGCCCCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(870,'dfc37c081f5d9536e1e33d1d256e0448','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(871,'4426628df1e2c30ec1edd9d390661b50','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCCTGGCGTTCCGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(872,'a0c20032cbd1f983885b722fb3c34623','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(873,'bd4362babe5db4291b7844968e961bdb','CCACACCTAAAAAACTTTCCACGTGAACTGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(874,'483758c8c326f5829c99f3202c8eac6a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCRTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(875,'583f833ae4ccbf524ebdeca31290c137','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(876,'eb149536e1f3d0336bb89545c4c8680d','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAAWTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(877,'bac36289958770f861725d7bed5b6024','GTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(878,'0040dd009f7001ec6970d7d4c32b6cad','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(879,'e4f8f3a06763f3fefec251158837702c','CACTTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(880,'a06f055fc577da22cb2d23942e34f143','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(881,'2a9e538e40e929e9b9e7865d3006410c','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(882,'5f86a140790d98341840257ca8fb2ebd','CCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(883,'2a7f9a448077312b06db4e376e19ea40','AAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(884,'0a72798a39eb08fbcbb688f0dceb5ddb','CTAAAAAACTTTCCACGTGAACGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(885,'9ed408f4e373fb7b4a5f7906c923494f','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTAGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTATTTTAAACCCATTCTTAAWTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(886,'a8645535b96953fed97de54839eb9a57','CCACACCTAAAAAACTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(887,'caff48ddb09ba6f03cbcef92c6628981','AAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGNGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(888,'069da0c13b61eaf659c59f8f9e496cd5','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(889,'bf7358f03ca8fb2f99a4504f5d8891c0','CCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(890,'c8f2b9eebbdb6c4a004d9dd7571fcb04','TCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(891,'c293ce4e3158310335ffaff3b457ce64','CACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(892,'5bd00de3a4fede21f5ba110efe4029bb','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGGGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(893,'733871cfc49092e993d4f19be7bb83b2','CCACACCTAAAAACCTTCCACGTGAACCGTTTCAAACCCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(894,'96717f77d3d3bc769868d43692c12661','CCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTAGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(895,'88d9bec50e0d9a7764eb132da186fa33','TGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(896,'86c86ffec342b070610b233de009d49d','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAACTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(897,'c3044d9a6c1e6510cccc33857d5e32c5','TTCCACGTGAACCGTTTCAAACCAAATAGTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(898,'3e5df164f3aec898a45da4bf957822c0','TTCCACGAGAACCGTTTCAAACCAAATAGTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(899,'a6d1182760e629810a918ee2585448dd','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(900,'189607fedeb49285d0fc32414fde5543','CCACACCTTAAAAACTTTCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(901,'f8a9009ee073ccf2af1a611d978995bd','CCACACCCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(902,'c84083f8e6fb953bcc547c66c1cc3941','CCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(903,'5d29e94da1fec6111eb835b44added6b','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(904,'0eafb740b1a4390dcf4b4c39d04ee1a8','CCACACCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(905,'cd58ba1a389c3329ed6c1134f80a389d','CCACACCTTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(906,'0122feb429a698af8ab2f8eb16e907f2','CCACACCTAAAAACTTTCCACGTGACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(907,'f8088b876aea88e44b0f648fc48b5504','GTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(908,'f62d8c0581fb23042ae9295f1ab20fd6','GTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(909,'95d90fd2fc8255b787314ddf78145269','CCACACCTAAAAACTTTCCACGTGGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(910,'a6120f1c548976fb77b71a6dc9da8dcf','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTAGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(911,'88d1b26a9da7f0cbb95f935e6a286680','CCACACCTAAAAACTTTCCACGTGGAACCGGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(912,'96f0606fa6e1b6adcdd78ae6794e68b5','CCACACCTAAAAACTTTCCACGGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(913,'83ff022dfdc12d927125b8de3c916ff5','CCACACCCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTAGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(914,'3125248cea14790f8dd49db50f282a2e','CGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(915,'43b851fac9ac3280e33ceb7195905ed8','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(916,'80458f6aa7e6e10ced09624bc782c3b3','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGNCTTTATTGTTGGCGGCTGCTGCTGGNCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(917,'e8995eb976a1ded3d832f0627e8d35ef','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(918,'bd07a656927c2ec31bc187d492a0215f','CCACACCTAAAAACTTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(919,'12dd49e0bdbb90ea9aaca55e27cfd983','CTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGRCTTTATTGTTGGCGGCTGCTGCTGGRTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(920,'3edc4242db0446117ea01c0e0cf59342','CTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGRCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(921,'a32543194f3f68cb3accdfe8f725b7a6','CTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(922,'9d054321e1025f570fd5809b1e97ee64','CCACACCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCCTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(923,'b1a727cd197d10a1c41f0c99f29acabd','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(924,'facc1af13a4e19555f58a895ad465ea5','CTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(925,'9570b30686798dd59597cbad7c645e4a','CACACTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(926,'8b6c7deab47dab302baf38233c6742ec','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(927,'fcc36a4d94f55bfa3b6fe97fb888b30a','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(928,'9feb725c7c56600222439baed9be20de','CCACACCTAAAAACTTTCCACGTGAACCGTTTCCAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(929,'ebf0783025a4835e2c78ed5ea7d8931b','CCACACCTAAAAACTTTCCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(930,'78414c3f3b851f77c5daf85731cdec47','CACACTAAAAACTTTCCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(931,'a58650ef0e189a36ba763d86da5a54d8','CACACTAAAACTTTACACGTGAACCGTTTCAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(932,'5b923a5170663f7d5c147f093f2cc02b','CCACGTRAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(933,'1ebc84c7bf78106fbf44764ebf5cc8b8','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTGTACT');
INSERT INTO its1_sequence VALUES(934,'d79fdc137665a807756b2970da495e3d','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATAGCGTGCAATTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTAAACTTTTTTTCCCTTTAAT');
INSERT INTO its1_sequence VALUES(935,'1e69c1ba8bf258b9f82e39e65b170e97','ACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(936,'6d686f5584c81535e524f8b0811e0d43','AAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(937,'657c97494e9697aec9f3ea2c4db86e7d','AAAAACTTTCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(938,'6b1053ec82542898e32c8a8908c257c1','TGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(939,'084117861ef3ced883be1ee38133be56','CCCCCAAAAAATTTTTTCCGGGGACCGTTTTCAAACCAAAATATTTGGGGGGTTTTTTTTGGTGGCGCCCCCCGGCCTTTTTTTGTGTTTGGCCGCCCGCTGGGGGGAACCCCATAAGGGCAAGGGTTTGGGGCTTCGCCTGAACCTAATAGCTTTTTTTTTTAAACCATTCCTTAAATACGGAATA');
INSERT INTO its1_sequence VALUES(940,'f099d35c09c84b7a1f3fdd7914a98d36','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTNGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(941,'80811f14b14f1637f3926bd599ace7e5','CACCTAAAAACTTTCCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTCGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(942,'5d1060bbb4d6c109162ba9ffc5836334','ACCGTTTCAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAACCCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(943,'4ee43a2b65eb65a7c20465fcd8d178e0','CCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGRCTTTATTGTTGGCGGCTGCTGCTGGRYGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(944,'f49c88abc1b19b9f29392c51faac3198','CCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(945,'e99a785fe299a4091004044102477fac','CGTGAACCGTTTCNAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(946,'1a6d997b1c95218a4528b04c9c1124cb','AAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(947,'8314450c67876f860f432105d4929770','TAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(948,'42815e8fb9e8b847b0d3a0a398cbacf0','ACTTTCCNCGTGAACCGTTTCNAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(949,'bcafabe1600ebce7de0ac8e7ed1a8484','CTTTCCNCGTGAACCGTTTCNAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(950,'0a15d0264981eb5faa4d1e971b103855','CGTGAACCGTTTCNAACCNAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(951,'86335fb094d038c2b3699a2f08198dff','CNCNCCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(952,'e9380752933a58dc98b29c98973c41b9','CCTTTCCCGTGAACCGTTTCAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(953,'7aef3779b6dbef906b16ddd8bd5046f2','TCAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(954,'795035d102961d30d7d351fe6488d337','ATAGTTGGGGGTCTTGTCTGGTGGTGGCTGCTGGCTTTATTGTTGGCGGCTGCTGGTGGGTGAGCCCTATCATGGCTAGCGTTTGGGCTTCTGCCTGAGCTAGTAACTTTTCTTTTAAACCCATTCCTTACTACTGATTATACT');
INSERT INTO its1_sequence VALUES(955,'c506875ad2b72a3e6b104c27a0a4d8fa','CCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(956,'061b860d26bafac37131d42da66d5293','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTTTGATTATACT');
INSERT INTO its1_sequence VALUES(957,'49bf96c334463219a30ab2e9a25385b8','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGRCTTTATTGTTGGCGGCTGCTGCTGGRYGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(958,'ba8662ba4d4e7cd33306e5142591a5f0','AAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(959,'f14ecc8919db299dd688b2640197502f','CCACACCTAAAAAACTTTCCACGTGAACGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(960,'b3c20d4143ea27ee7b724914901e0c2c','GATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(961,'8a7c3d210ce46b3dee8532ac442e350e','TCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(962,'e919f3f7297afbd8e336401af6e23676','AGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(963,'c35f4b7563541d003370676c0c80cfcd','TGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(964,'b406757aeac3d2657e22eb339fc6f4db','TTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(965,'ed32b8a394b3905aa0f204e9d35e3023','AAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(966,'03899246da9d9a7c3fb359b83b899e8b','CTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(967,'a2eec72e3cb89b4faa8a6704fbe0f4e8','TTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(968,'b7bd91d8158b66bcdb7f9e7dbadaa74c','AAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(969,'3ad4759eee115a19f64ec5e04261431b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTATTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(970,'eb02e8644cb2760fd36fc40460349a37','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGNCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(971,'0b98df1a968dfde735e64021f84f08d2','CCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(972,'2b911cd2baf8c127a7cfbe1a618c6302','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTATGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCAGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(973,'0e8422dec3d03a8ead0c53322325ea7a','TTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(974,'0908d6647e66d975b297126d0e6dde47','CTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(975,'f2f55b9592d905471d7d34dced1a0ada','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(976,'32a14142a53f88342eabcb7b0c934e00','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(977,'ab572f5bd869a115da7662140a0577d1','CCCCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(978,'ab8016291560ac8598945e165ba61f6d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCNGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTNTNTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(979,'0bad4e308b7f2958dfdb56fe2281ce44','CCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(980,'2f542a0108f5cd465052419a91ae0d30','CACCTTAAAAAACTTTCCCGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(981,'678121efa0f9ea42d71a1ae7d86d5d87','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(982,'d240387d5165151a788b5feedb5b14c8','CCACCCCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(983,'568b3ad2552f16a8e29a03648b3b92c4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(984,'3aed7048c25976a6bf582ee02225f59b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(985,'80b2e3fa8540c64828831b539e7e52ec','CCACACCTAAAAACCTTTACACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCCGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(986,'9534cf3c6f9c2b36d3c63788fb78739e','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(987,'273d83135d7abe48edca01d525b74d27','CACACTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(988,'8dc7cc1243398552c1947fa835ca51e6','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(989,'9e3f60c16cdd3b894179ae6279aacdad','CACACCTAAAATTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(990,'4ad191db95f7cc8fa2db2c48da68b910','CCACACCTAAAAAACTTTCCACGTGAACCGTATCACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(991,'29b0a67f1512157b43d63abc28edb0ab','ACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(992,'5b9cbe2470baf5b0502f064bfd9d979e','TTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(993,'cb43a8c8ccf8aff8d0d130d3d8f6cf49','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(994,'9a8d716bc483428d0f71b5b93bd8e1a8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATYTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(995,'643879abb3f7f43efc294e0a625630d0','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(996,'df3eff5de6067ee6b50c214f7372bde3','CACCACTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(997,'e9d01e54932b05fb31c4eecdc2425f5a','CCACACCTTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(998,'ed76e3c77f7c10fb0efc0f03d605267d','CTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(999,'dc1f49e57863c50a086a90ab973c2c29','TAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1000,'4f4812fd69c45910b95add831cfea511','CCNCACCTAAAAAACTTTNNACGTGAACCCGTATCAACCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1001,'852f2d061a295c6ab84391f4559a7265','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1002,'c06e7953d43da5287f6ed2f6f59e9218','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATYTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1003,'735b1c6f37c805ee5ac9b2138e47e69e','ACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1004,'ebfa4c937f9d195f6a685a4d5276ec6b','CTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1005,'a5fa20fcc6afb4f1422a7088a24072b5','CCACACCTAAAAACTTTCTCCCACGTGAACCGTATCAACCCACTTAGTTTGGGGGCTAGTCCCGGCGGCTGGCTTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1006,'bb70dd68c251bcc28a5150f1eaa7ca60','CGTGAACCGTATCAACCCACTTAGTTTGGGGGCTAGTCCCGGCGGCTGGCTTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1007,'90bb17457b16c8e7860ce03b37b1385a','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTTGGGGGCTAGTCCCGGCGGCTGGCTTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1008,'9b0cfbdd2b0d5bb1251b6faf73ed1112','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1009,'d864845ab4377475e54d579a0b82af04','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGKCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1010,'421fc27fc5c49ff848f4dda1e07eca0b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTYTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1011,'f568de34b1972a1dfd68700fd460bffe','CCACACCTAAAAACTTTCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1012,'d785dc25a166816ccb2e4110784407d4','CCACACCTAAAAACTTTCACGTGAACGTATCAACCCACTTAGTTGGGGCTAGTCCCGGCGGCTGGCCGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1013,'80f769bb3eb317d8415ff98e01f00270','GTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1014,'af704de1bf4e8393ad589246c7ff4eb0','CACCTAANNCTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1015,'421c5930000071bfa52c92900eb1de93','CTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1016,'feaa8884a8a8170b8fdcfdcf005a1339','CNCNCCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1017,'d95cb78c458c85b88cfeaf0f64f726d5','CCNCACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1018,'4b5d52bde6e6da681c1a68cdcaf3bbf4','CACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1019,'5dbf01edfa9791975de27091331d0872','CNCNCCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1020,'89e3356fbeb7f27bfe8bcfc507f61557','CTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1021,'061760beb45c504c781cf67cf662c44e','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1022,'12ada38eac5339dd3168a14bb2ee9107','AAANCTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1023,'3bf12eba79dcfe2011fbeb6b23cf37aa','CCACACCTAAANCTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1024,'8b5643eff38cfe1e85a6535cc6f10560','CTTTCNNCGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1025,'0ff9d4298643553636a0f28c28298160','CGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1026,'a292be35285767f82c82d7a832357677','TCNNCGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1027,'a8ba0c6d0cee8f9c5cf56bfc364cf770','AACTTTCCNCGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1028,'09f3701a8566d2df8fa438bcb68ce837','AAANCTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1029,'fe8eb1e4a547c76c8a3027de3eb54e20','CNCNCCTAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1030,'c30ff937bfe402b9c73a50a4ace82a06','GTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1031,'25ada5a5bc2f2905b300499475b671df','AACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1032,'670c460342fbd35eaad5ac809ff40d69','AAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1033,'3d91e3aed8b433919e3393631fdbeacb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCAAYAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1034,'20098893420a90c40fb2403479c7b6f7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCAAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1035,'85875796627a29909f71f76e57aa7512','CCACACCAAAAATCCTTTCCACGTGAACTGTCTTACGAGATTCGCGCCGTGACGCGTGTTAGCGCTGTGTGTATATGTCTGTGTCTTCTTTCGGGGAGATGTGGATTGTGTGCACATGGTGCTGACTGCGTGGGTCGGCTGATCGAAGGTCGCTTTGTGCTGTATGTATAGTGCAAAGTGGCTGACTTATTCTTTCAAACCCATTACTCAATACTACTGATT');
INSERT INTO its1_sequence VALUES(1036,'d9e1dd053dd7497698ad443763c5bfca','CACACCTAAAAAATCCCCACGTGAACCGTNTCAACCCTTTTAGTNGGGGGTCTTGTNCCCTATCATGGGGAATGTTGGGACTNCGGNCCGGGCGAGTAGCTTTTGGTTTTAAACCCATTCNANAATCCTGATTNTNC');
INSERT INTO its1_sequence VALUES(1037,'ecf496300eb7576ddc52093941ede79e','CACACCTAAAAAATCCCACGTGAACGNNTCAACCCTTTTAGTTGGGGGTCTTGTNCCCTATCATGGNGAATGTTGGGACTNCGGNCCGGGCGAGTAGCTTTTGGTTTTAAACCATTTCANAATNCTGATTATNCT');
INSERT INTO its1_sequence VALUES(1038,'dcc4377c0ead2e9798179e47f42fca46','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTCCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1039,'ce3f40c902702a58bdfb5bd9ccb62464','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTNTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1040,'02783f69bf873e9be58d19e52eb32187','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1041,'338b3d2661fd1056d919fdb008359f03','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGNCTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1042,'c4a295cb0326fafc1809f4467b110e16','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1043,'2ef8b8e408b3f02186bea5099b1cb2f9','CCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1044,'2c9587ab06651ae7699938f60750ed71','CACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1045,'0ffcd9aaab9b7b9b9e81141d473879a5','CTTTCACGGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1046,'5912101cf808ceb73f19bce44f2cb1e1','CACGGTGGAACCGTATCAACCCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCNCAATTCNGATTATAC');
INSERT INTO its1_sequence VALUES(1047,'bf0e3511927303ac87a7839c555765a6','TTTCACGTGAACCGGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGNCGNATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATAC');
INSERT INTO its1_sequence VALUES(1048,'9b851e58e79f1f9b3676bfe7768eb4f0','CTTTCACGGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATNNCCTAANGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGCCTTAAACCNATTTCACAATTCTGATTATAC');
INSERT INTO its1_sequence VALUES(1049,'846d30294f77a328aed446f16eb8f4bf','CTTTCACGGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGCCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCNGATTATAC');
INSERT INTO its1_sequence VALUES(1050,'e9a8f335f4ab8e22db82de4371f531a7','TTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1051,'dfd871fae566e1f78e778baae2ed577a','ACTTTCCACGGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1052,'25451a1488138fa6a4c03b9f89626370','ACTTTCCACGGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGCCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1053,'82aacb5aa27d1e26b379c5b8afbe0446','TTTCACGTGAACNGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGGCTTCGGNCCGGGCGAGTAGNTTTTTGTTTNAAACCNTTTTCACNTTTCNGATTATACT');
INSERT INTO its1_sequence VALUES(1054,'cdc71c496d58374dac1a2c56d3e1848d','CTTTCACGGTGAACCGGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1055,'0342c2a4cd4eba896a4cd6d82577f3ea','TTTCACGTGAACCGGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAAGTTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGCTTTAAACCCATTTCACAATTCNGATTATAC');
INSERT INTO its1_sequence VALUES(1056,'1c1f817da0f3afc220bba98190fdb4e1','CTTTCACGGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGCCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATAC');
INSERT INTO its1_sequence VALUES(1057,'b7010fd6961cf6ae0025f58c7267d3d2','ACTTTCCACGGNGAACCGGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCNTTNCNNAATNCNNATN');
INSERT INTO its1_sequence VALUES(1058,'aa47e52a88b5b02c8373a258fbb62500','CTTTCACGGNGAACCGGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGCCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1059,'7621441189430b074f9844c357810145','TTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATNCCNNATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTNTTAAACCCATTTCACAATTCNGATTATAC');
INSERT INTO its1_sequence VALUES(1060,'9fe95808d84adab17fd000d34eb131d1','CTTTCACGGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATAC');
INSERT INTO its1_sequence VALUES(1061,'9f972e8c13d25a83a036a24ac3c6a9b6','TTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCNGATNA');
INSERT INTO its1_sequence VALUES(1062,'e0dfa612f88e18b399091053e43acd61','CACGGTGGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1063,'a66020ce0bc0ece17096536570f181d0','TTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1064,'06b5f9aa53e0006e170d46c0f83b798b','CTTTCACGGNGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1065,'47aaed1c4cc909ca83582b587d12d66d','ACTTTCCCGGTGAACCGTATCAACCCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTANACT');
INSERT INTO its1_sequence VALUES(1066,'af2f897fd13ecf50441f0b78a8e4bafd','CTTTCACGGTGAACCGGTATCAACCCCTTTTAGTTGGGGGTCTTGTACCCTATCATGCCGNATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCNGATTATAC');
INSERT INTO its1_sequence VALUES(1067,'738b4d101b7cd5450e77323807631415','CTTTCACGGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGNCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1068,'04c846c1f28a3796c12aab0289ca6ce2','TTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATCNCTNNAGGGNTGGACTTCGGTCCGGGCGAGTAGCTTTTTGCCNCCTAAANNAATTTCACAATTNTGATTANAC');
INSERT INTO its1_sequence VALUES(1069,'9a219b94dc6bf50f782fc5a9987d7648','CTTTCACGGGGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGCCTAATGNTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCNGATTATAC');
INSERT INTO its1_sequence VALUES(1070,'42233711170ecdd15aae5ac93312bd3f','TTGGGGTTTGTTCGGACGAGGCTGCAACGGCCTTGAGGCCATCAGAGCGTTTTATTTGTGCTTTTGNACGAGTAATCNCTCTTTTTTGTAAACCCCTTTTTTTTAACATGAAAACTGATT');
INSERT INTO its1_sequence VALUES(1071,'cbdf4e710ca8911e89bf3da6f38f8110','AAACTTTCCCGTGACGGTATCACCCCTTTTAGTTGGGGGCCTGGACCCCAACATGGCCGAAGGTCGGGCCTCCGGCCGGGCCAAGANCCCTTTGGTTTTAACCCCTTTCCCCAAACCGGATTAT');
INSERT INTO its1_sequence VALUES(1072,'ca99a2fb1063c31259072ce7ca0cddbd','AAACTTTCCCGTGACGGTATCACCCCTTTTAGTTGGGGGGGCTGGACCCCAACATGGCCGAGAGGGGCCTCCGGGAAGGGGAAAGAGGGANATCCTTTTTAAAACCATTTTTT');
INSERT INTO its1_sequence VALUES(1073,'fd4139574bbbf39a939a1679d18e2d5b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAGTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1074,'e8aa0b53937b895bcbd83b1ce87aad64','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1075,'27a37664ad7e7969638ce6be3b2759b9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1076,'80f8cc91938b7df4f9d0bea25ce4e557','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAGTTGGGGGTCTTGTACCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1077,'cc2020359a12eb14ab97613788b7cf2a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1078,'1051fb791c25b2bab6709b5db992a055','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1079,'ec4dbef832837909b9865efecf99a97c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1080,'e422edf31143863c9b6d8fa50590d8e5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1081,'566d664368341bffb89026f6f689a151','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTATGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAATCTGATTATACT');
INSERT INTO its1_sequence VALUES(1082,'782bca86a7344c4c7524ab0481e9a06c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAGTTTGGGGTCTGTACCCTATCATGGCGAATGTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTAAACCCATTTCACAAATCTGATTATACT');
INSERT INTO its1_sequence VALUES(1083,'302a832fc024888da38cbec09a07686c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTCTGGACTTCGGTCTGGGCGAGTAGCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1084,'8bba127b291879185b65b3b0291936e8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTCTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1085,'6451f2ded88706c229449fe4b5ea7d7d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1086,'90a4dbd7ce401cd3f37c398c4f4e3917','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTKGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGYTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1087,'478905082dd2964c92e4a9f3f65dbfd9','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1088,'ea089a9cb89fc0166e5e491737f7b1e8','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAGCTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1089,'d6ab6f57d7333f07a758329a0329809f','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTATGTTTTAAACCCATTTCACAATTCTGAGCATACT');
INSERT INTO its1_sequence VALUES(1090,'394a1245c064de7493b87ab13d83a315','CACACTAAAAAACTTTCCACGCTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTAAAACCCATTTCACAATTCTGAGCATACT');
INSERT INTO its1_sequence VALUES(1091,'6020b18f688fd93bf98a46038e1ddf37','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGACTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCAGGCGAGTAGCTTTTTGTTATAAACCCATTTCGCAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1092,'1b32a566ab368322d10847b6d564d013','CACACTAAAAAACTTTCCACGTGAACCGTATCTACCCTTTTAGTTGGGGGTCTTGTACCGTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGAATATACT');
INSERT INTO its1_sequence VALUES(1093,'c5540e0771e76df64d286625508d1059','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCGATCCATGGCGAATGTTTGGACTTCGGTCCGGGGCAGTAGCATTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1094,'e41cbac45b40910b243e71d1d5b66007','CACACTAAAAAACTTTCCACGTGAACCGTATGAACCCTTTTAGTTGGGGGTCTTGTACGCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1095,'124712cbc4d419ba2b7c34882c97855d','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGCCGAGTAGCTTTTTGTTTTAAACCCATTAGACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1096,'46711df92b579bbac6d4e6deb2007c62','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTACTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1097,'382eaf3aed2543ee933cc6776b362d31','CACACTAAAAAACTTTCCACTGAAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTACCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1098,'0423b02a6707afb3949e853ccc92a1d7','AAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1099,'3d5b760ade275ed3aaf89dd1f0647036','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1100,'8ce06883d58159539b4901c36f3ef0ca','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1101,'d2bc0b2362fb15d8af73375fe44c4cc0','CACCTAAAAAACTTTCCCGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1102,'6e5e86d7fb1c3c07e916eb5e40ea3bc7','CCACACCTAAAAAACTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1103,'eddee5659de1650c3de39d09b4635207','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1104,'2b045088625c99f109c7a71c22e2e8fb','CCCCTAAACAACTTTCCCCGTGAACCGTATCCACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGATAGCTTTTTGTTTTAAACCCATTTCTCAGTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1105,'d0e181ec55b4b5848c0872f076526ef7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGACTTCGGTCCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1106,'1497070cffbf5e36eae25404958beabc','CCCTAAAAAANTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1107,'448d04438b075d4606dc38ae3c94e67f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCTTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1108,'3a70b262b3b9aecefcb3a54ed778e77e','CCTAAAAACTTTCCACGTGCACCGTATCCAACCCTTTTAGTTGGGGGTCCTTGACCCCTATCATGGCGAATGTTTGGACTTCGGTTCTGGACGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1109,'a25a5eabd9168eb92b03f271f5d517a1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGNCGAGATAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1110,'00142fa85ed10c06b122da6303ea7b58','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCRGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1111,'605a72221b05cc4d4fbbfd6d2ed1c499','CCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1112,'e5d3ec3b0800d788dbd0c61746b90aae','CCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1113,'ff79553c6c3f7ae8b06ddf77d52f467e','CACACCTTAAAACTTTTCACGTGAACCGTATCAAACCCTTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1114,'3ff39ca1465b38fe1d7bd4b74404e25f','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1115,'db2087b16194597405cbc5682484ed1d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCYGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1116,'7ad899eba3e0bd98bd1d6122e0a2f718','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1117,'641d37b9ee7e108bd887bd2f3caf4807','CACACTAAAAAACTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTACGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1118,'f73b42ef6ec6c48632ea9b7c659106fb','TTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1119,'ff114e90f0f47c191c62278f1aa2ad38','CCACACCTAAAAAAACTTTCCACGTGACCCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1120,'1b0ef744d39c286a595392961d780bf6','CCTAAAAAACTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1121,'641bd99ae4f71ddceb7298d39b29ad24','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1122,'51857ace315a1922da5d46302e6b3d4a','CCACACCTAAAAAACTTTCCACGTAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1123,'ef688657726e4813a23ea6df81c8beb3','CCACGGCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1124,'12bd15c5f7b83812a7a0c133a81ed584','CCACACCTAAAAAAACCTTTCCACGTGACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1125,'bbf6a715e5bba49808f58cdd5c42ed77','CCACACCTAAAAAACCTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1126,'26a10f2b2f29b2614424bf84f1cc4690','CCTAAAAAACTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1127,'27803f2178fec098f7298fb85c5f14ac','CCTAAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1128,'164fcf363f596aed732e10d9c97cbc04','CCACACCTAAAAACTTTCCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1129,'2fa006ecee34791fe66dd153133c3e46','CCACACCTAAAAAACTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCTATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1130,'e0f62dfa4a5512a82599521c6b9646a0','CACCCCAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1131,'4dfc9ed364b48458fd3570f12c17a4c2','CCACACTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1132,'715c7531bac96fde58d9ac081a6de21b','CACACTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1133,'8a740e04180ccc4bdcfc29b370b23d17','CCACACCTAAAAACTTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1134,'7c6bd374c0044af7c1f807f4a9b0652c','CCACCCCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1135,'cb3fe055efdf951b857ad23358c22156','CCACACCTAAAAACTTTCCACGTGACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1136,'41503a2d82da09266fddbb41c4303fc5','CCACACCTAAAAACTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1137,'6094b1adf384b05adf7e15f4d30522ff','CCACACCTAAAAAACTTTACACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1138,'e50d77c6538e37ca71ce9564ddac5dd7','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1139,'fbdd6b5fdce4f1413167422f499d5381','CCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1140,'c2e141fd1f041b28be8f7b3345f7829e','CCACACCTAAAAAAACTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTCTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1141,'1230d7e7d231e974baffa0eefd1f7369','CCAAACCTAAAAACTTTCCACGTGACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1142,'bfb648b5d64cf9b2fd9f266a7c5919ab','CCACCCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1143,'73fd842c692f6f1b5e77ffb903cb4a7b','CCACACCTAAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1144,'4321db581cb2fda3e506371338609c62','ACATAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1145,'26522097cd9b14b616040384f77d9008','CCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTCTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1146,'06487ba50bcb13f9779747854ac48720','CCACCCCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1147,'ee73da4df25c3961809b5c8fbe3e7a51','CCACCCCTAAAAAACTTTTCACGTTGACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCCTGGCGAATGTTTGGACTTCGGTCCGGGCGAGGAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1148,'36b7bd02195cae602656a55366a198ab','CCACCCCTTAAAAACTTTTCCACGTGAACCGTATCCACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGAATTCGGTCCGGGCGAGGAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1149,'2f9bdcbb6b9335f112a3fef94035bfe9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1150,'b70937a2c85686dd9e3ac2a998e5d483','CACCCCTAAAAACTTTTTCACGGTAACCGGATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCAAGCCGAATGTTTGGATTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1151,'93913ba48a08da00ef8809862e30cb20','CCACCCCTAAAAAACTTTTCCACGTGACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1152,'6ecf2be4a1e3c5d9d2b00e186de81b0c','CCGTTTCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1153,'59d1bb2e44f3b0cd48986ba83dda4b9d','GAACCGTTTCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1154,'8cf70f52c07fafae48d51015f2013077','ACGTGAACCGTTTCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1155,'041c2e4bebe3e5666f987330cd296fcb','ACTTTCCACGTGAACCGTTTCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1156,'4ebf57f053c1432d1c9c0afc3ac8409a','GAACCGTTTCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTYCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1157,'d5c4b1a6cf347e4d3d8e4bf7c2adafbb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGRCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1158,'97d68cbdc23dfb573ae65c8c507c62b1','CCACACGTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1159,'faef444845406a6f8d63124d217260e8','CCACGCCTAAAAAACTTTCCACGTGAACCATATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTCCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1160,'553f762c95654b14d434127354912a52','TAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTCCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1161,'f4d51ec433a89c11499a5df48e1b142b','TAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTCCACAATYCTRATTATAC');
INSERT INTO its1_sequence VALUES(1162,'c8db2d9774072efb6d2c83c425e5a0b2','TAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1163,'2d1b3e0be2247c219b0a1c26a1a29022','CACCACTAAAAAACCTTTCAAGTTGACCGTATTAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGAATTTGGTTCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1164,'c7d683281e910f12cd2f4fe64bb0ea2f','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1165,'23bbcd9c5f3a18ee23d665011fcf6853','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTACGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1166,'f9fb378458cee748df4774170c6eb3ca','CCTTTCACGTGACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1167,'a4a38cbddaaf2483778e4548be3a5659','CTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1168,'53a6786b095b834e1664b3cbe3b38d00','CTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1169,'ed1bb1f6ca0bc264d66e3f2e5568531f','CTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1170,'60fc1e32505f984c5cc1f43fcd41a576','TTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1171,'4a68675b037d4608a36330c91ab6d688','CACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1172,'91cc32d2e229fb4f09d729f40a378aef','CCACACCCCAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1173,'e2515fddfa685418e704b182dd8b3c14','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1174,'2e908c1a6b9341836635bef4ff679ba2','CACCCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1175,'9694091604dba46fb72e71e21d73374a','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1176,'743417d73511b766f3f4b351a71cab18','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1177,'686f0a832bce893868c0994eb07ee69b','CCACACTTAAAAACTTCCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGTACCCTATCAGGCGAAGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1178,'441a3c0f340062c5e3b53ef2648d2f11','CCACACCTAAAAACTTTCCACGTGAACCCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1179,'10205c6d0fbe0f47cb8d5f89e2dfd3ea','CCACGCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1180,'79f208231ef96b615f52ba530ec5b47e','CCACACATAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1181,'7b48c710c22939387687955602c57cd2','CACCACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1182,'7fc062db2f59565554520ffe1940a2c3','CCGTATCACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1183,'f420ce64d68f6d3895c97bfe59538780','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1184,'3a5f91665c84aabf2c3dac3158329ead','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTACACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1185,'a8aa4d99a6badfe48f6ab9c38ee822c6','CCACACCTCTAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1186,'12da81c3c8dcc49fe64c978ac7b5091b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1187,'d580243c50b6d4c7d69ddc9b5efe6571','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTTCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1188,'0dc8c925f8965b873c896acb843c3867','AAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATAC');
INSERT INTO its1_sequence VALUES(1189,'dfba85d1b4e852ca9f15a995f7361cdb','AAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1190,'9803739d4281c0a5d42330f1f8d2ce21','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1191,'9eb3eb8bcde1d6953eda5dac5ebdf350','CACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1192,'d9caff485ebad16bcbfc21bcd890279d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCCGAATGTTTGGGAATTTCGGTCCGGGCGAGTAAGCTTTTTGTTTTAAACCCTTTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1193,'41aaa6e94eb77be70f73d8e32998fd39','CACTTAAAAAACCTTTCCACTTGAACCGGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCATATCAATGGCGGAATGTTTTTGGGATTTCGTTCCGGGCGAGTAGCTTTTTGTTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1194,'67d9fe3865a179e9f7858197dbbab8e9','ACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1195,'45d4cebc9cdc7c1b6a9bc0f7c1ed60a3','CTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1196,'9e802f7669a62f1372ea137cb318ecac','CCACACCTAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGGACCCTATCATGGGGAAAGGTTGGACTTCCGTCTGGGCTAATAGCTTTTTGTTTTAAACCCCTTTACCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1197,'1daf68d9109671e63c614503e53efc6c','CACACCTAAAAAACTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1198,'4994f74723ca31fb0d44313107ff0602','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGGCTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCTTTTCACAATTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1199,'12367c8dbb2202d724001479ca16f121','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATA');
INSERT INTO its1_sequence VALUES(1200,'d92a5fdbdfc4e2246149685855aa9226','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1201,'0fc651e9e109abed793104cfcdee669f','CCACCCCTAAAAAACCTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTTTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1202,'fedcb760e016072e60e2e37ed45746a8','ACCGTATCAACCCTTTTAGTTGGGGGTCCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCWTTYCACAWTYCTRATWATMC');
INSERT INTO its1_sequence VALUES(1203,'3c1d675c59888f611fedeec3dd53ca71','CCACACCTAAAAAACTTTCCACGTGACCCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1204,'2c46502ed96d2836a8aaa012cd136440','CCACACCTAATAAACTTTCCACGTGAACCGTATCAACCCTATTAGTTGGCGGTCTTGTACGCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTATTGTTATAAACCCATATCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1205,'c68f8cd8145704d984dd44b5c2215f31','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1206,'f14ec7e3468a4d534da0aebbda22f06d','TTTCACGTGCACCGTATCACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1207,'e392c7cda85ed695fefc5f00045efaed','TAAAACTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1208,'3edfe4b9874853d1817653e6563b6cfd','CCACACCTTAAAAAATTTCCACGTGAACTGTATTGTCAACCAAATTCGGGGACTCCTTGCTAGTGTGCTTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGACTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(1209,'c906f0bfb4202f4ca80e9721eeb28992','CCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCCAATTCGGGACTCCTTGCTGGTGTGCTTTCGGGCGTGCCGGTCGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(1210,'9ff7ff6cb740a3c7d8eb27b20bab6503','CTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1211,'43633d26fa236167092e080c1794fc49','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAATTTGGCGGCGGCTGCTGGCTTCGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1212,'38a4b65da014a7c1b3ec83eecab15118','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGTTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1213,'f565415e78388480e16186b15a55031a','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGARTTTGGCGGCGGCTGCTGGCTTCGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1214,'88b45f99f9fa330a029ff38897aa7722','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTCGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1215,'942ae4a9c27ef76b2caeb2820399e488','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1216,'ff4b4932d8f5d9a00a7cadd0aeec99e3','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGAATTAGCCCTATCATGGCGAGCGTTTAGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1217,'1d8c06fb5ec9bc8dfd245d128dd5fd7c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1218,'fd165671de189177e8c340e1f554bd8a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1219,'f1c90f98db73aa783c086ef8be0bc453','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGYTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1220,'0987ceb803dd18c295eb52e4fb5216fb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAANTTGGGGGCTNCCGTNTGGCCGGCCGGTTTTNGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1221,'141f291990dccfc3b113670c959b4cb9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCCTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1222,'8b3d207602c258c01ebed0910a6b684e','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTNGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1223,'3d511b0e50b98eeeb0c656746fcabd31','CCACACCTAAAAAANCTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGYTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCANTTTTAAACNCWTTYMWTWAWATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1224,'acca4806e5471167c10948ae05212763','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGYTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCANTTTTAAACNCMTTYMWTAAWATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1225,'fd5d98cdaf80289f659b4a5c77211953','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1226,'224b2533b10f10351ccb91d2e36649f2','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTATAATGGGTTGGTGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1227,'083cc0d9d034d0b3d4c5d2cd9d9e31e5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTYGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTYCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1228,'1b7da494ce2b5d91fbe0374261525056','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGKCTGTCGATGTCAAAGTCGACGGCTGGCTGCTRTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1229,'10ec842d2f9c77321acaadf9f1dfb5d9','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACGCAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1230,'62fffbd542bc7cf8017643d962e22101','TGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1231,'d07a268b78bd0d71fc2aaac7181136d3','CCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1232,'453af2ca71e342585e9701effdb1facc','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1233,'960de1f847006e357b4fca2404a43952','TGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1234,'744b5eba5078acb195a0c80039f54413','AAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1235,'4fe8433cde3fe029b9bb9164e4910943','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTWWAWTTGGGGGCTTGYTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAAWACTGAACATACT');
INSERT INTO its1_sequence VALUES(1236,'38613f82dcb1fcacfb1d98e248b16d82','CTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1237,'a24363e739e765e34b4cbf2f98f7bca5','CACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1238,'1608eac9ad898e86aec0b7f9d0f4195a','CCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1239,'7f0c943298bc23cfa90e09d0d8ff5a91','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1240,'3d84d8a2b428416e294c715c45b08a7f','ACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCNTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1241,'6f6df99ff758c8a54f1b8535b7b85164','CCGTTTCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1242,'85ec737678171bbd34caa384bfc45761','CCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTGGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1243,'d49ff2e27053164a47e9b315bca45b49','TGTCTGCGTGCTGCTGCTGGGCAGGCTCTATCACATGCGAGCGCGTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1244,'86ffaa3f3a52e052ba5f378c7a499341','TGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1245,'7fd9f6f841e4a8e55dd43c3d60308443','GTTTCAACCCCTTAAATTTGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1246,'49702c6b2431030322cf4fd13b8434b9','GCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1247,'a5c1312c9ff90b8a8006d82c5a442e67','CGTTTCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1248,'fa4b137a4e7d02fc9f5bc3f1cd0f6969','AATTTGGGGGCTTGCTCGGCGGCGTGCGTGATGGGCCGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1249,'e184c1819d6e2132d2f02cfffbbc331b','GTTTCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1250,'b8c49e6de068e6b87c4c3a638acf13b8','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACYCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1251,'d9a97aef6dd6468fe33f24243b4e96f9','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGRCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1252,'097073b1ad3893233f0c48a2162df26f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1253,'110d2c8ea672040eb239d61f15ac44f3','CCACACCTAAAACTTTCCACGTGAACTGTGTTGTCTGTTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCTGGGGTAGTAGTTACATTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1254,'501c8ca82525bf26b5892c4ad623f0bd','GTGAACTGTATTGTCTGTTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTTCGGGCTGCAAAGTCTGGGGTAGTAGTTACATTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1255,'4f1baaf0e3ed7f28b71cd2fcc1edee10','CCACACCTAAAAACTTTCCACGTGAACTGTRTTGTCTGTTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCTGGGGTAGTAGTTACATTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1256,'84dd05898c6fcc97c506c93c98495a91','GTTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCTGGGGTAGTAGTTACATTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1257,'0218ec16770741ceb21d66bb3c0bfaac','TTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCTGGGGTAGTAGTTACATTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1258,'c39e35533a15d3940b11f1075afcf452','CCACACCTAAAAAACTTCCACGTGAACCGTATCAACCCTTTAATATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAATTACTGTAATAC');
INSERT INTO its1_sequence VALUES(1259,'e5ab9ec2df076b6d281bac7b11152d0f','AAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1260,'360e7fe2494d1006e7c18e759e823c7b','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGTTGTCGATGTCAAAGTCGACGGTTGTCTGTTGCGTGGGGGGCCCATATCACTGGCGAGCGTTTGGGTCCCCCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTCCACCCATCCTGTAATACTATAACATAC');
INSERT INTO its1_sequence VALUES(1261,'0b9dc5a6bd25baee693a8a75b5b6ce18','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGTTGTCGATGTCAAAGTCGACGGTTGCTGTTGCGTGGGGGGCCCTATCACTGGCGAGCGTTTGGGTCCCCCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATCCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1262,'e2762071f2fc1a4dbdb8d9e143a613b3','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGTTGTCGATGTCAAAGTCGACGGTTGCTGCTGCGTGGGGGGCCCTATCACTGGCGAGCGTTTGGGTCCCCCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATCCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1263,'88b639a866dfc6f4315c7a5da7fcc8ce','CCACACCTAAAAAACTTTCCACGTGAACTGTTTTACTGTACCTTTGGGCCTCGCCGTGGTCTTGTCCTTTGGTAAGAGAAAGGGAAAGGCGCGGTTGGAGGCCACCAGGGGTGTGTTCGTCGCGGGTTGTTTCTTTTGTTGGAACTTGGGGGCCCGAGTAGTCCCTCTCTTTCCAACCCATTTTTTGAATGAAAAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1264,'0312845f000c9be5373a9bd53a896720','CCACACCTCCAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1265,'7f41b6edf60470bfe2b77d68b4b745b4','CCACACCTAAAAAACTTTCCACGTGGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1266,'7a2ee946e66ce801d999b3ab11691cb7','ACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1267,'9834b47d0b0b0de66b05240d6125a269','AAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1268,'077b7db5c9167e7bd713f63201295c5b','CCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1269,'9435aa095943eef8ae27c414b5be4866','CCACACCTAAAAAACTCTCCGCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1270,'8235813a8237b3eaa0c9f5a80936fe3a','CCACACCTAATAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1271,'8f89b861e19e73383eac5b0e16566677','CCACACCTAAAAAAATTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1272,'cf328172c9cf75ed9f07ce85d5f835f9','CCACACCTAAAAAACTTTCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1273,'eb810687000f545c1c744f1382971f18','CACCTAAAAAACTTTCCCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1274,'491404c37a45f5f8229f757bb5873bc3','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCAAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1275,'0256b95c6f5c845891a360e0808de30e','TGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1276,'2747e26f31426d4d730a257cee127d86','ACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1277,'c183c7d4064493170885398b3233f07e','CACCCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1278,'d050235a1c6911ea065559f5c69852c6','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1279,'7373b39659468ae0aaa7a27bb637363a','CCCTAAAAACTTTCCCGTGAACCGTATTAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1280,'9272598c62681533cc745aeaf08ed6bb','CCACACCTAAAAAACTTTCACGTGACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1281,'8a28a255cbc94492245de30198cb643e','CCCCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1282,'dc3adc9ab556331308a561160225ea01','CCACACATAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1283,'75e8e41346cd9e253e9f706f6e73db0e','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1284,'03e4fd4a58494f24485808084c7ed778','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1285,'7e001f8573bf2788b5095f57095a5151','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCMTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1286,'a23dd4f59fac13d2caadb8df40952e09','CCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCATTAGTTGGGGGCTTGCTCTGTGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTACGCGGCGGGCCCTATCACTGGCGATCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCAGCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1287,'99336879205188be4a6517694bb7a05c','CCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGCCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1288,'ea15b5c7dd9c7c2a9ccdff72c5f8071f','CCACACCTAAAAATCTTTCCACGTGAACCCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1289,'91dbe362830ab8faf659ec4ed3a63c4c','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1290,'4ed3d910ed19fc8c7103e326dfa63a88','AAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1291,'39d47925c0d62f15c831c2336e31eec3','AACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1292,'fc14b63af239034844f2ce0f8933dcbc','TAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAKCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1293,'026a893ca2c8c581662f404f6ed55d5f','AAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1294,'feeaf44b18d69610735b6f1c9d8311fc','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGCCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1295,'6140e9e60bf574b20f80a8ba8810c002','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1296,'4ae71639ac3b87d3959b1616630bbbaf','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGGGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1297,'26d0529bddeb57046500a9bf5db4275c','CCACACCTAAAAAACTTTNCACGTGAACCCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1298,'3eb9553a09e6a31a15d20bb4ff6664f7','CACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1299,'6b07a7bc742603f0f0a6a3ecd5fd67d5','GCTGCTGCGTGGCGGGCCCTATCACTGGCSAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1300,'5e143ee65aab9125ae81969d0f94bbc4','TTTCCACGTGAACCGTATCAACCCATTAGTTGGGGGCTTGCTCTGTGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTACGCGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCAACTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1301,'cbab839d3baef30f657b36b350f2e6b1','CCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGGCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1302,'754f092900a9997e54e6b73140c4b331','AAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1303,'869b65bd3055e3280980966767361cf2','AAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1304,'1608564daea5e9a6a7d4343130a42506','CCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1305,'a9e78b94e6968d9ca76b03801dc8227b','CCACACGTAAAAAACTTTGCACGTGGACCTGTATCAACCCAATTAGTTGGGGGCATGTTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1306,'9f6b1d292361be67c01662f9f5233b62','TATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTNGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1307,'b470e2c1c08f177af717c538efe03027','ACGTGAACCGTATCAACCCAATTAGTTGGGGGCNTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1308,'de4797cdcc3255b3bff23023dc5d726d','TAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1309,'a6137329d1b89ffe5d83b92fc2740eb6','AACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1310,'9e3393f10282722ec28c71c5fa67b7ef','TGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1311,'0f5ac8b62605785e9217a9480a7d95ea','GTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1312,'0b4d0e2bbfaff8d4c834fa84a5d04020','CGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1313,'481cd28cac6ce64b8c8f68fdc10b9c54','CCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1314,'95b6af262f3feb3c470a76d0a08000a0','GTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1315,'49fa9c34b8e5f552094a425ad2d87fcd','ACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1316,'8fb8aa98384ef242268a2304f6567606','CAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGNTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1317,'69290338c8f6475e24a4ee1678390a60','TTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1318,'2944a92efc2a120b8fbf5680aaf4ecef','ATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1319,'ea9552e26a01a94fc57cefc9cd388326','CGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1320,'f4dd7d5a28163d230cd3ae067e74ac41','ACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1321,'a8f87a466cc832db848239a35ef759e1','GGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1322,'4e5e24df8e2dbc61067ea01fd2b7cbdf','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1323,'69038d4e3ec509d0f8ea04b3055602a0','CGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCCTGGGCGGCGGCTGTCGATGTCAAAGTCGACTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1324,'42d0347016fa908974b5e803b80e4509','AAAAAACTTNCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACNCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1325,'e0e4edb6aa347aebfa1756cf3a7cd66e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCANCCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1326,'cf24483cc93f856adbfe93d1f6ecc27f','CTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGATTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1327,'a26862c6e04cfa10041e880e2a6d350c','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1328,'d9aca2220fb489dfbae9d2eeccacc6e5','CTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1329,'30a9590a45959a634616b9b614036530','CCACACCTAAAANCTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1330,'bf99c966b7e29170d3519b72e829740b','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1331,'775d6635b88666da42c9d3b7f3d4ecad','TGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1332,'0ec04cd9701b057bd92dcc23aad4ad2e','TCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1333,'8bace23d0a39b8b72d2af29df6fec10f','TGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1334,'71582749d654ac970076c0b5bad7a046','GCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1335,'88bb4de7040681655fd8ab1cf1ec6dc2','GATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1336,'a15340cc72a9bfd79bd6da0dc5c96395','AACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1337,'584e7b420578664fc2480dc573ab2f60','TTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1338,'aef1246e6e48bf6a27142ce45acbe07c','AAANCTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1339,'5a50acf4d8c30db211af9a1bc2b6155a','CCACNCCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1340,'42b0886bff8bf20db8ec344994b518a7','CCNCACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1341,'258aa6523b2e78659de26a11e518f997','CNCNCCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1342,'d269dd87a27bce4c0fceb46204bc363a','AACTTTCNNCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1343,'23784e47c9f5a3c304cea6e75308ae99','CCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1344,'57c616bb92d59a6cb5d73ad47648ca01','CTAANAACTTTCCNCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1345,'a1c16ca520341c013010c195841befe0','CTTTCNNCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1346,'2838614d61689b407cd43bfe4305a8e4','CACCTAANNCTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1347,'b7bf140a69c9a8280e913e3953aff7d8','CTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1348,'d714015f59a3846f6df24532c910ed75','AAATCTTTCCACGTGAACCGTATCAACCCATTAGTTGGGGGCTTGCTCTGTGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTACGCGGCGGGCCCTATCACTGGCGATCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCAGCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1349,'196684ca3136d63c0d75787cdc11095a','CAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1350,'5deea2986ecca3c090b7118258b775c3','AACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1351,'818d883dc348adc086ace83669de7899','ACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1352,'bcbadaf280c11bf75753fe2f2a517e99','CCACGTGAACCCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1353,'215b7676d41415827abdd07843e29f7d','GTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1354,'30447fac68501cdff39d4ed0c809c8fa','GCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1355,'6b26f9a370e0ad375057358ec6624c9e','CGTGAACCCGTATCAACCCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1356,'60b0bfa711e8783a5d3a1550779160ec','ACGTGAACCCGTATCAACCCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1357,'4abf8c84207e1f40121ffc6801cc49cc','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGCCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1358,'2120905b1e2e5cc360231f37558dc461','CCACACCTAAAAAACTTTCCCGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1359,'b091e20efe148fce28cf0071dca28338','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCATGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1360,'5387c38a3982e5a54709c8180564cad2','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1361,'db001a8077d3ce9914bf23ed2c2bfd10','CGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1362,'f0c0e6422de6426c0d6403830cb18845','ACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1363,'ce44bc3084e6dca3efd1b2a972ef26c4','CTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1364,'5241da9c0c2610b2995c9594d5310923','CACACCTAAAAAACTTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1365,'9549b4abd4afe73d67f0dff4e9772491','CACGGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGCCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1366,'e84a00934d15fe2fca29508a9a922017','CCACACCTAAAAATCTTTTCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGCCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1367,'ac4ca76dfa266fed1688af32169b6af3','TGTCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1368,'0d57b541eabe079d275771314459397e','AAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGCCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1369,'552c43ab89ce279aede96a0676a57c1b','AAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1370,'4c54382993013c851d9d4580bc565a24','CCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1371,'835b61d35fa26b7c755f0ddfad025260','AAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1372,'3d5240383778143cffa74638edcae34f','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1373,'81880f400a60fdf88507a0332d6f382a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1374,'2cfe6a6a4b898613b61af2f34bd99fcf','CTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1375,'a4ac91670d773c77300482a33d1140fb','CACCTAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1376,'4b31a7ca04592b9ccd4401a0661b8932','CACCTAAAACTTTTCACGTGAACCGTATCAACCCTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1377,'d4d5488ba84882d687a779cf9f01279d','CCACACCTTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1378,'0deda92f8ff12f057363ad8fc1f4fdae','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACCTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1379,'2bea12005a37a6dfd53848f62a0b44a5','CCACACCTAAAAAACTTTTTCACGTGAACCGGTATCAACCCTTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1380,'f47136bd7c892afd3a3c4f3c41e36c13','CCACACCTAAAAAACTTTTCACGTGAAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1381,'d3074af191e112d8f9d8525885d69965','ACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1382,'3444abaf7c3c7700c956122160481697','CCGTATCAACCCTTTCAGTGGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1383,'0b9fe448638203d6e809c130dbc053fb','CCACACCTAAAAAACTTTTCACGTGANCCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1384,'925f14e050f45d3fa8e1a11801922554','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTNGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1385,'301af5ee423b25703bb8c0f17dd45a59','CCACACCTAAAAAAACTTTTCACGTGAACCGAATCACCCCTTTTAGTTGGGGGTCTGGCTTTTTTGCAAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1386,'68c3159eef287eb96016bad37b696176','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1387,'60ff2a867b17062d795552fc6a06f00d','CCACACCTAAAAAAACTTTTCACGTGAACCGAATCACCCCTTTTATTTGGGGGCCTGGCTTTTTTGCGACCCCTATCAGGGCAAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1388,'8b057adc23e33f16f1ebc02c0f7e382f','CCACACCTAAAAAACTTTTCACGGGGACCCGAACCACCCCTTTAATTGGGGGGCCTGGTTTTTGCGAGCCCTATCATGGCGAATGTGTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1389,'c409d11d1b1e66a3381c7412538a617e','CCACACCTAAAAAACTTTTCACGGTGAACCGGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1390,'babf457c1103aeb8c6c719d12fe4a29a','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCATTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1391,'49d41b11d6bb8bd56fa26bdf15c83803','CTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGGTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1392,'98400afca44b5c9458d248e4306c83f8','CCCCTAAAAAACTTTCCACGTGACCGTATCACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1393,'d788465ae37f056fd52eb1684e005bc3','CCACACCTTAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1394,'9ed48ee5e2801e7b8fd2b296e76298c4','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1395,'928db31685edb3911a6b68da7e678ef8','CCACACCTAAAAAACTTTTCACGTGACCGTTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1396,'be4a722ea6d78dce980058ca3da3456f','CCACACCTATAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1397,'4d40cd5ec15a2a50032da93145de1c65','CTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTCTCTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1398,'eec71539857a6f8f102d1bc848721ba3','CTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1399,'1420bcdb446ca13aa224679fd344bdca','CCACACCTAAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1400,'797f08b7170212261d5186425eca4382','GGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1401,'67cb83a42f35cfa4825dc7f463876d98','CACCTAAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTTGGGGGTCTTGTCTGGGTGGCGGCCGCCGGGCTTTTATTGGTTTGGCCGCGCCGCTGGGGTGAACCTATCAGGGCGAGGTTTTGGGGCTTCGCCTGAGCTAGTAGCTTTTCTTTTAAACCATTCCTTAATACTGAATTATAC');
INSERT INTO its1_sequence VALUES(1402,'b8b05b7637124ab559ebaccddec04f89','CTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACYTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1403,'93de89a7d61de5bd8b5aa7eec727f444','CCACACCTAAAAACACTTTTCCTGAACCGTATCACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCAAGCCCTATCATGGCGAATGTTTGGACTTCGATTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATCC');
INSERT INTO its1_sequence VALUES(1404,'92890cd95588327295d7986e5f254808','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1405,'337295a1bf42e0d12a262083448275cf','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTCTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1406,'dd0e19d30266af019d380f0f2118f123','GGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1407,'dbc7006a7eb4a52393741625ee0bafba','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1408,'1c362411e39201424087c96974f7fe1b','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGTTATAC');
INSERT INTO its1_sequence VALUES(1409,'5d9d4e6389d81ef530320cadf101f89e','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTACGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1410,'0ffcce5fcbf912b56df2205a77cb0b96','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTGGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1411,'25062c830e304c3c4ba4d051da405610','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1412,'c08d2e19ec681099f8f97f5c6e1a8122','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTGTCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1413,'fddef349feb38adf082b40620cf79acf','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCGATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1414,'f59d9e6d4e55eb64dcebc1469000fe00','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTGGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1415,'59d4ec7056736fe92f03d5d5848d506f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTCTGCTGAGCCGCGCCCCATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1416,'87c7d3c28b6dfb8e1fe90f6f9f016387','CCACACATAAAAAAACTTTCCACGTGAACGGTATCAACCTTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1417,'f760d139e86fc38e91db52dc77869361','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1418,'4f8a267c51158a3025daed560f96ba2d','CCACGCCGAAAAAAACTTTTCCACGTGGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1419,'eac47afa956df93200fcac2ec861c785','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1420,'fffd24bb6abb4d47341290957ab32774','CTTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1421,'fcec81131b86d59282c925d44646ef9e','CCACACTTAAAAAAACTTTACACGTGAACCGTATCACCTTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1422,'67b2f89e7581f94bdd65cfc976486cfa','CCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1423,'472691651204becf61f2d5eef7d3f2df','CCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAGTTGGGGGTGTTGCTTGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1424,'8e2994998fb66020c75f95070beadf05','CTTAAAAAAACTTTCCACGTGAACCGAATCAACCCTTTTAGTTGGGGGTGTTGCTTGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTTTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1425,'b4963b0d3b42a3fda12ec36d80c247ef','CTAAAAAACTTTCCACGTGACCGTTCAACCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1426,'3adcbe13b13b19c80c6a272800dc763d','TTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1427,'fc1e7f946c77382a1f9258ab2c124206','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1428,'a4b25a33d1534fc1955cb431a7146f49','CGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1429,'d6055e14b4ade35f8be5a2a0431c5e07','TAGTTGGGGGTGTTCCTTGGCATTTAAATGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1430,'7360e356e00c9153dad3dede1e45a96b','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTANTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1431,'77429e27ebca4784c88182c3299e819a','CCACACCTAAAAAAACTTTCCACGTGTACCGTTCAACCCTTTTAGTTGGGGGTGTTGCTTGGGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1432,'5503f17c0ead2d34d902f7078803aceb','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGGGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1433,'550bb0995b0995e88fd4db1d1deace36','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTTCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTACAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1434,'b8959b31fb098aac662ad641d99fcdd2','AAAATTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1435,'fdd0b2434ed8ab5380717a737a5fe0e4','TTTCACGTGACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1436,'3c6b1e64a8003d3fa1b1a8f6102f0f36','TTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1437,'b6649ccae11ca26a5b97f512212bd1dc','CCACACCAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1438,'3cb692c2b6b4309a13d3557b3b883b0b','CCTAAAAAACTTTCAAGTGAACCGTATCACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1439,'e90d72d3881de9faadeaafc4be7fb370','CCACACCTAAAAACCTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1440,'12bacd72c5a83a144f209585642585de','CCACACCTTAAAAAAACTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAACCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1441,'293ebed170498da17495c3cc7f8c4645','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAAGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1442,'a9906c3456216449fd65e4f5047f4b19','CTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1443,'ddf4a7c5f14c586dd936fa411b6921cb','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGACGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1444,'82b886f18d9ae6f6b069b530a6bc9057','CCACACTTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1445,'9f4d5cf6a27bcd9a2964dd918844254b','CCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1446,'77d4d92fe20b6d7929bb74c79ec27c91','CCACACCTTAAAAAACTTTCACGTGAACCGTATCACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1447,'5837e205c9ad70cff0db86aade28e151','CCCACCTAACAAAAACTTTTCTCGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1448,'5b2186af695e3af0ca82024b0aee6dd1','CACACGTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1449,'b23ef877c72f8c74fa11707ccfa46b05','CCACACATAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1450,'84b81f159d2160030ad7449731566cb0','CCACACTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1451,'29342585ca429208ab4186278e4527f1','CCACACCTAAAAAAACTTTCCACGTGACCCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1452,'2cdf0df1bcb21ae524d0e8efc45c1da2','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1453,'0f4fc793d80054c11a702a13f4e82fa0','AAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1454,'7875131a8649bd919846ab51e7ab353f','AAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1455,'17608a45c06dcd648dc6383fe3f6af7b','CTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1456,'562afde29922942dfbc67de909d33ba6','CACCTTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1457,'98c533be486a260afd49da4f339a9578','TGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1458,'61fb58c5fc18a58b7581d3fdab703639','GCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1459,'26f42612132975f09a9baf27a47450d0','TTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1460,'01ad6fa12f9a75a34a8cfcf3240e9172','GCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAASAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1461,'58332a2f524ddb642297ee3c00432d5a','TTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAASAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1462,'83b49c9713b5631fcdc49bf4fbccb65b','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1463,'d7780a088c7670e35519fc43511cde8c','CCACACCTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1464,'de76bdee5e91061726320c375d91e5b5','TGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1465,'b32f1bb7eb8ea2b344aa8a03e6edb37f','ACCGTATCACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGANCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1466,'882dfeb5a8d49bd47be3b68753b4e218','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAAGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1467,'fe121180259833012b5f11f6b504f7e7','GGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1468,'9563f273681a645f8f114434bdaf536a','CTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1469,'ae746d49529a59111c59bba4beab69df','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGTCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAAGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1470,'6ef822f4b072f5313e26abbeb62f772e','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1471,'961adc6f30f56a3d9e6b7ded5ad170cc','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTGGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAAGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1472,'179914f04c63a26d8d63cbb62097cf01','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAAGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1473,'86349c1c908e63b346afea5c13169982','CCACACATAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTGGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1474,'ae8afe9f7af0a9c689cdf1b4c5800260','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAAGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1475,'cec30e486bfe8a4bae0e0a6f105e4ef1','CCACACCTAAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1476,'715a68c65cbb2c351e4db16dd56f044d','CCACACCTAAAAAAACTTTCCACGTGATCCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGTGCGTTTTTGCTGACCCACGCCCTACCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTCTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1477,'ca09561871d1a7edfeeaa69fff5c177b','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGACCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTATCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1478,'06e11abdf4fc1e5336df91a217e88d85','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCTGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCCTTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1479,'865b93b37239214d09175f2af7e9c6f1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTGGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1480,'11e3fad291b26d1adb0b7c8cc83f904a','CCACACCTTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1481,'386a26b0f08a37ccfc457c87053d1f14','CCACACCCTTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1482,'80239a5b3a0784860a6d0d377373611d','CCACACCCTTAAAAAAACTTTCCACCTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTAACCCACCCCCTATCATGGCAAATGTTAGGACTTCGGTCTGGGCCTAGTAGCTTTTTTGTTTTAAACCCATTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1483,'4e58f1082c1ecb67edbb7076fdeaad2c','TGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1484,'b523ac14c176cce1136f6f606fa4abaf','TTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1485,'e2d1f6a7ba619621117159eaf8d2082e','CGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1486,'7b7a8a9cf05a12fe5f69148da214e36a','CGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1487,'67b96a9a3e47bfa2871e17323c78e246','ACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1488,'6325e478bf9baea7f89dde970e3cb276','TCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCCTTTAACAATACTGATTTTACT');
INSERT INTO its1_sequence VALUES(1489,'fafa02cca8aad543c693d51945765481','TTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1490,'c2efc2da70ec36bf0ae637cf75288ee9','TTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1491,'d225d779a4e97a1f625c2d575c28739b','CACCACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTCGCATTTTGCTGAGCCGCGCCGTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGGTTTTAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1492,'82e852235c51f3be66322214082e5cda','CCCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1493,'8f2a6a6d3a826e04759cd06ac1b758e8','TAAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1494,'f2e405b2c4a5ca69b9d3525573d12086','CACTTAAAAAAACTTTTCACGTGAACCGTATCAACCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1495,'9b5cef9b889f5ba6386b0337ae17a9c2','AAAAAACTTTCCACGTGAACCGTATCAACCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1496,'b975b8465b9c22ded054d554a2199bb1','CCACACCTAAAAAATTCCACGTGAACCGTTTCAACCCAAAAAATTGGGGGTCTTGTTTGGTGGTGGCTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGATGAGCCCTAACGCGAAAGTTTAGACTTCGGTCCGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1497,'9e100a3617346972a66e64948c89b10f','ACACCTAAAAAAATTCCACGTGAACCGTTTCAACCCAAAAAATTGGGGGTCTTGTTTGGTGGTGGCTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGATGAGCCCTAACGCGAAAGTTTAGACTTCGGTCCGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1498,'90f681c5615e2e7988e02a20c54d4ba2','CCACCCCTAAAAAAATTCCACGTGACCGTTTCACCCAAAAAATTGGGGGTCTGTTTGGTGGTGGCTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGATGAGCCCTAACGCGAAAGTTTAGACTTCGGTCCGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1499,'b60ed84f4644a160d69cdaa70f5f2da6','CCACACCTAAAAAAATTCCACGTGAACCGTTTCAACCCAAAAAAATTGGGGGTCTTGTTTGGTGGTGGCTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGATGAGCCCTAACGCGAAAGTTTAGACTTCGGTCCGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1500,'2aaf3d233d0208d667e3615234a882bb','CCACACCTAAAAAAATTCCACGTGAACCGTTTCAACCCAAAAAATTGGGGGTCTTGTTTGGTGGTGGCTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGATGAGCCCTAACGCGAAAGTTTAGACTTCGGTCCGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1501,'7eeadbd595d4f6c6125500e8adb0baae','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1502,'1ae88307137e108d42473302951eb99c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTAACATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1503,'df9fa8b4e091974984e3faa55bc8b014','CCACACCTAAAAAACTTTCCACGTGACCCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1504,'ad5f15020b6b6d38a975483da12b7317','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1505,'ac69d5267e0ac1dd5d7005885e244cf3','TAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1506,'7ad829bff371a25e4cb9d15c05314978','CTTTCCCGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1507,'6a02d0b3d8f0000faf35e030fee4c4b6','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1508,'36757a3dce0ffc2c9442bbafc717a07c','CCCATAATACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTTTGGCGTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1509,'8eded369ce4dd7f8c5e51d4714e7d1c4','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAACCTTTTAGTTGGGGGTGTTACTTGGCATTTTGCTGAGCCGCGCCCTATCAAGGCGAACGTTTGGGCTTCGGCCTGGGCTAGTAGTTTTTTCTTTCAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1510,'feb9750b6f64d8032d61477cb4d02405','CCCCTATAAAACTTTCCACGTGAACCGTTTCAAACCCAATAGTTGGGGGTCTTATTTGGCGGCCTGCTGGCCCGAGCCCTATCAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTTTTTTCTTTTAAACCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1511,'96d264b261e895b5101e4397c7c76dfc','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGATGCTGGTCCTAATTGTTGGCGGCTGCTGGTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1512,'d09091a9604768adf05c84ce115b0202','CCCATAATACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTTTGGCGGCGGCTGCTGGCCCTAATTGTTGGCGGCTGCTGCTGAGTGAACCCTATCATAAAAAAGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1513,'933cb55fb80c4df15bd2208634162303','CCCCTATAAAACTTTCCACGTGAACCGTTTCAAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCCCTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1514,'5b2909f6ccdbd5a2e64cb339e01860e3','CACGTGAACCGTTTCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1515,'c0bb9f29799604d800efa09ac0ef68c3','CGTGAACCGTTTCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGNTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1516,'6c43b8ad6f844ae99242eb7d36db05fa','CCACGTGAACCGTTTCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1517,'9f1708d0bf7c429eebc0faf64e484eb9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGAGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1518,'5ab2fbdfeb7cdf74dc985eebf8d0df40','CCACACATAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1519,'dab6f375fc7266fdf54aeec0f26a6016','CCACACCTATAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1520,'2a28042b8ba7483dc078a3d0daced8be','CCACACCTAAAACTCTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1521,'9422af14ddaa724b6ab73bb164512e39','CCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1522,'30669c590aafc7691fb48a6e6c672e9e','CCACACACTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1523,'b792f0e4f6ad7224175cfaf0a0866239','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1524,'4ce1747457f073dc3ac75bc8ce91ea33','CCACACCTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1525,'2047857de7a10b68083d8cb923151f05','CCACACCTAAAAAACTTTCCACGTGAGCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1526,'4a00edec72cc80f70b6d628b7883e4c9','CCCCTTTAAAATCTTTCACGTGAACCGTATCAACCCTTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCATTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1527,'b92afbfa7cbca6e540a60df60455abd2','CACACATATAAAACTCTACACATGAGCAGTATCTCCACTCTTAGTGGGGGGTGTGGCTCGGCACTTTGTTGAGACGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1528,'0dd14303c2bd37e412de0e1291e66897','AAACTTTCCCGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTCGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1529,'dcbfe46a5d410f47289a9c393525b01b','AGAACTTTCACGTGAACGTATCACCTTTTAGTTGGGGGTGTTGCCTGGACTTTTGCTGAACCGCCCTACATGGCAGGTTGGACTCGGTACGAGCTAGTACTTTTGTT');
INSERT INTO its1_sequence VALUES(1530,'57d23a5f47c710b4dc375c0da9ab0422','TTAAAAACTTTCCCGATGACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1531,'c739e024b51e643c39b1990eac86fd88','CTCCTAAAAGACTTTCCACGTGAGCCGTATCTACCCTTTTAGTTGGGGGTGTTGCTTTGGCATTTTGCTGAGCCGCGCCCTATCGTGGCAAATGTTTGGACTTCGGTCTGGGCTAATATCTTTTTTTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1532,'ed63ea96104bc8722a62c686cf09f3f4','TCAAAAACTTTCCCGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1533,'99cbd4b8570345d1bd358d9306992026','CTTTCAGGTGGAACGTATCACCCTTTATTGGGGGGTGTTGCTTGGCATTTTTGCTGAGCCCGCCCTATCATGGGGAAAGTTTGGGACCTCGGTCTGGACAATACCTTTTGTGTTTTACCCTTTAACAATACT');
INSERT INTO its1_sequence VALUES(1534,'c5a73228c47241fdcca1dbd586773707','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1535,'254ccb308a22bb9bada7b7ce66bcf27a','CACCACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1536,'4dd49ed0bf27107166792f0d22aa124f','CCACCCCTAAAAAACTTTCACGTGAACCGTATCAACCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1537,'446f9dfd4a97763e0ce141dac06ac2fb','CCACACCTAAAAAAACTTTTCCCACGTGAACCGGTATTCAACCCCTTTAGTTGGGGGGTTGTTGGCTAGGCATTTTGGTGAGCCGCGACCCTATCATGGCGAATGTTTGGACTTCGGTTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1538,'a173a98aa138210193d7202bc10790c5','CCACACCTAAAAACTTGCACACGTGACCGGTAATCAACCCATTTTAGTTGGGGGGTGATGCTGGGCATTTTGCTGAAGCCGCGCCCTATCATGGCGATTGTTTAGAACTCCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1539,'428fc2532df416a412a6150713e185ab','CCCCTTTTAGTTGGGGGGTGTTGCTTGGGCATTTTGTTGAGCCGCGCCCTATCATGGCGAAATGTTTGGACTTCGGTCTGGCCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1540,'87107e113b2d394bd0776991a7fffdfe','CCACACCTAAAAAACTTTCCACGTGAACTGTATCAAACCGTTTTAGTTGGGGGTCTTGCTTGGCATTTTGCTGAGCCGCCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCATTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1541,'d1b8e0e79a1dd6bfced1c95d18b75eb8','CCCCTTTTAGTTGGGGGTGTTGCTTGGGCATTTTGTTGAGCCGCGCCCTATCATGGCGAAATGTTTGGACTTCGGTCTGGCCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1542,'4c12da777257a185e6ce78cce8e39cd4','CCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1543,'b84ea7c6d8e44648ac7f32411d09ad72','CACCTAAAAAAACTTTCCACGTGAAGCGTATCAGCCCCTTTAGATGGGGGTGTGCTTGGCATATTGTTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1544,'d05c826595f7a6fde18b906e62ae9cde','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCTCTCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1545,'ab3ec99f4ea61bb80b4cf96298cd8f77','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTCGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1546,'edc49ef7dd27b50c9d3700a8ac0bc526','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTWTCTTTTAAACCCATTCTTGAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(1547,'8da48eaba098f14de0eafc609afbaee1','CCACACAAAAAAAACTTTACACGAGAACCGTATCACCCCTTTTAGGGGGGGGTGTTGCTTGGCATTTTGGAGAGGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAATCCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1548,'3c2c25cd858926bab799a05916ef18d5','TTTCCACGTGAAGCGTATCAGCCCCTTTAGATGGGGGTGTGCTTGGCATATTGTTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1549,'0e4498ec36aea3bc1d9fc00ebefbdd98','ACCTAAAAAAACTTTCCACGTGAAGCGTATCAGCCCCTTTAGATGGGGGTGTGCTTGGCATATTGTTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1550,'7fd19b8f6b31bdc16429f4cd14edd23e','CTAAAAAAACTTTCCACGTGAAGCGTATCAGCCCCTTTAGATGGGGGTGTGCTTGGCATATTGTTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1551,'ed3203618fd9d4b0b58c5a1c28dfe4c2','AAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1552,'39d660d0df73b3aaa6467d0f236a7cd6','CCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1553,'9ff73789f836d246a8510dae7bea2118','AAAAACTTTCCACGTGAACCGTATCAACTCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1554,'9f1fe52660c758b157cb5ea240eef21d','AACCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1555,'4bf1baad5ddd21656c9dadbeae7cd8f7','AACTTTCCACGTGAACCGTATCAACCCTTTTAGTTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGCATTATAC');
INSERT INTO its1_sequence VALUES(1556,'3d51a7ebc9b295629b2dc5d7b9ea8bf2','ATCTAAAAAAACTTTCCACGTGAAGCGTATCAGCCCCTTTAGATGGGGGTAATGCTTGGCATATTGTTTTTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCTTTAACATATACTG');
INSERT INTO its1_sequence VALUES(1557,'d31c2349a5de0411e8991b33f3059973','CTTGGCATATTGTTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGAAAGCTAGTAGCTTTTTGTTTTAAACCCTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1558,'bd5d3efe28dedc8eb659f3251bf2bc33','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTAAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1559,'b8babeb062776d1e1054166c7c5bd514','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGWAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1560,'e8a8da5330b611f3e0993305ef67a2e9','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTWAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1561,'76506dc3465b43d970226a373fb8cce9','CCACACCTTAAAAAACCATCCACGTGAACCGTATCGTCAAAACATTTGGGGACTCCTTGCTAGCGGGCTTTCGGGCTTGCCGGTCGGTTGAGACCTAACACGAGAGCCTTGGCTGAAAAGCCGGGGTGAGTAGTTTCTTTTTAAACCCTTTACTAAAAACTGAAAA');
INSERT INTO its1_sequence VALUES(1562,'1cf7e2e8774bdebfd3c41c72917b841c','CCACACCTAAAAAAACCATCCACGTGAACCGTATTGTCAAAACATTTGGGGACTCCTTGCTAGCGGGCTTTCGGGCTTGCCGGTCGGTTGAGACCTAACACGAGAGCCTTGGCTGAAAAGCCGGGGTGAGTAGTTTCTTTTTAAACCCTTTACTAAAAACTGAAAA');
INSERT INTO its1_sequence VALUES(1563,'24c642c43aa53e16a6e861c03b20e3e5','CCACACCTTAAAAAACCATCCACGTGAACCGTATTGTCAAAACATTTGGGGACTCCTTGCTAGCGGGCTTTCGGGCTTGCCGGTCGGTTGAGACCTAACACGAGAGCCTTGGCTGAAAAGCCGGGGTGAGTAGTTTCTTTTAAACCCTTTACTAAAAACTGAAAA');
INSERT INTO its1_sequence VALUES(1564,'f1b8518e19cf23cc0e1903eee5914a90','CCACACATAAAAAACCATCCACGTGACCCGTATTGTCAAAACATTTGGGGACTCCTTGCTAGCGGGCTTTCGGGCTTGCCGGTCGGTTGAGACCTAACACGAGAGCGTTGGCTGAAAAGCCGGGGTGAGTAGTTTCTTTTTAAACCCTTTACTAAAAACTGAAAA');
INSERT INTO its1_sequence VALUES(1565,'c682d5cd4c106c3d0e644a26feef0696','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAACGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1566,'682b1264c4e18a1b7c3a567a3f54d301','CCACACCTAAAAAACTTTCCACGTGAACCCGTATTCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1567,'d44c8af6b605feb0d482759f36886c68','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGRGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1568,'59f08ad1747e45145dcf8051fe3da9d5','AAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1569,'a497867a2a4c7b55b4a96bf847d9c1bd','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGTTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGGAAAAAC');
INSERT INTO its1_sequence VALUES(1570,'e2455cdc05f2cb4cf6e910efcf2c1d2f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(1571,'3a71a800593afc0d1ef43c30b7d6c3e7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1572,'e2f41ed8593f54186face9c89725c708','CCACACCTAAAAAACTTTCCACGTGAAACCGTATCAACCCTTTAAATTGGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCAGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAAAACTGGACATACT');
INSERT INTO its1_sequence VALUES(1573,'6b044d5be1fcb4ffa43a67225b42493c','CCACACCTAAAAAATTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTCCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGGTAGTAGCGTATTTTTTAAACCCATTCCTAATTAACTGAATATACT');
INSERT INTO its1_sequence VALUES(1574,'f221ea2dfc65bf7e52c9f47815312117','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGGATATACT');
INSERT INTO its1_sequence VALUES(1575,'decd4415ce17b4771955cc1ea174845d','CCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCTTAAATTGGGGGCTTTGTCGGCGGCGTTCGTTCTGGCCTGGAATGGGTCGGCGTTCTTCTTCTGGGCGGGCTCTATCATGGGCGAACGTTTGGGCCTCGGCTCGAACTATTAACTATCACTTTTAAACCCCTTTCTTAAAAAACTGGACAAAC');
INSERT INTO its1_sequence VALUES(1576,'acb2804cd707ab967aabb5a4e504f0f9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGTTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGGATAAACT');
INSERT INTO its1_sequence VALUES(1577,'235c9d01267219782619e42b386e5ae2','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1578,'2393e76284127c5bc177e9771ca6fa59','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1579,'4205081d7fd0ea003fcbb46768b05094','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCKTMTYTTTTAAACCCATTCCTAATKACTGAATATACT');
INSERT INTO its1_sequence VALUES(1580,'dee85c9fd835a7aeaadd6e05ed88a801','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGATGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1581,'c38763a82522bd51b1f4832d5eb98c03','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATCCGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1582,'5c2f3e3af3e02518ff555f68b1f9a318','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGYTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCRTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1583,'267d70685c4fcdf8644fa56381bf9dea','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1584,'a418a9ffbd05f4752f9ad71e71251a22','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCTGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1585,'764eab3f2d1be190278146d91e23d048','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1586,'7d56bd7ef81cab9548acd16c86ddd360','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1587,'dadfcf04f16d386159d8b15e58c404fb','CCACACCTAAAAAANNCTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1588,'259742a81c2bce4ca71d8a59a752a7a1','CCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1589,'cc02942fa913d04b529b3a9a4c3456ba','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1590,'ec39d0339d6f61e77de69bf681c0607e','CCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1591,'5970d1143f6dbf56c892492d44928ef4','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTNAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1592,'0b6d1187aa37496d73ec268ce5b43b03','CCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1593,'dd2ff7a0d2f6a3cf4ffe56a6584ef71c','CCACACCTAAAAAATTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1594,'9addb7abb616b8365d90d4b06338f52f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1595,'54a20f18553e7df75657ebacda3f76a1','CCACACCTAAAAAACTTTCCACGTGAATCCGTATCAACCATATTTTAATTTGGGGGCTTCCGTCTGGCCGGCCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1596,'75359eb9c3cd59ce873bada9f6ba85ca','CCACACCTAAAAAACTTTCCACGTGAACTCGTATCAACCTATTTTAATTTGGGGGCTTCCGTCTGGCCGGCCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1597,'3adb3456044f5c1eef1dd1eda2890875','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTATTAAATTGGGGGCTCCCGTCTGGCCGGCCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1598,'c1dfefa7cb48abe8e1c3b7f7a74b7174','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGTTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1599,'62211e6e82148409098f1b403e12d634','CCACACCTAAAAAACTTTCCACGTGAACTCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1600,'e9199f2fcedc640f84a49293419ff7f3','CCACACCTAAAAAACTTTCCACGTGAACCCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1601,'0b4fd6f911914462329363b7eade9aa2','CCACACCTAAAAAACTTTCCACGTGAATCCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1602,'66cd2a16dc48e292e7355f48033fefda','CCACACCTAAAAAACTTTCCACGTGAATCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1603,'416c6aff033211c1a04ced190ce48625','CCACACCTAAAAAACTTTCCACGTGAATCGTATCAACCTTATTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1604,'0c4dd6292f2b1b8cde620a71ac3b70d2','CCACACCTAAAAAACTTTCCACGTGAATCGTATCAACCTTTTTTAAATTGGGGGTTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1605,'81c114d7ac476b71f75b09276d2cb2de','CCACACCTAAAAAACTTTCCACGTGAACTCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1606,'56a86e1477bd48a37aaf31fae3d622b9','CCACACCTAAAAAACTTTCCACGTGAACTCGTATCAACCTTTATTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1607,'a1c742f651f2e5d20fb6d2769ac47b6d','CCACACCTAAAAAACTTTCACGTGAACTCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1608,'6d2cc6bbdb8220d9c7da61cf4eac59ac','CCACACCTAAAAAACTTTCCACGTGAATCCGTATCAACCTATTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1609,'6169d73cd59724f2f19b0fb713fd136f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1610,'92bd24b5ad003966c8218770c539edda','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATGGGGGGCTCCCGTCTGGCCGCCCGGTTTTCGGCTGCCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1611,'956563c671ec0de352fe51f29896ed3d','CGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1612,'e6b80c71550f45bb537db7c96cc208c8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1613,'f3746a0a107e795b9da348096def4fea','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1614,'b99aa30d19ba214ed07caac5fed0056e','ACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1615,'7d7460df04491f70daa0f907c9298d66','CCACACCTAAAAAACTTTCCACGTGANCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1616,'1305d73e3340dbb4fcc0aabba32c0387','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1617,'04c52cb5b29468e48882e5ee31000de0','CCACACCTAAAAAACTTTCNACGTGANCCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1618,'d47ced48fd6e1885a80a54692a9ec44f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1619,'dd94cdfd8056fea351f086a9df41d859','CCCTAAAAATTTCCACGTGAACGTATCAACCTTTTTAAATTGGGGGCTCCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1620,'a0a64a99a1831d288fd5ac1f5be24c99','CCACCCCTTAAAAACTTTCCACGTGAACGTATCAACCTTTTTAAATTGGGGGCTCCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1621,'d4beed4f660045e41db6929767c2c42f','CCACACCAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1622,'2a123d5dc8f1fe7fc48f02afe487adf9','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1623,'c57623355490d5cb1e50dd4f01c4fb5e','CCACACCNNAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1624,'1c2b704e2eb4877fc812baae6ab054e2','TAAAAACTTTCCACGTGAACCGTTTCAACCTTTTAGTTGGGGGATGCTGTGCGTCTGGCTTCGGCTGGCTGTGCGGCGGCTCTATCATGGCGATCGTTTGGGCTTCGGCTGAGCTAGTAGCTTTCAATTTTAAACCCATTCTTTATTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(1625,'ee8228d8bfed048ff914855f4d81e5ca','CCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAATCCTTACTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1626,'5759c4dd791b4fea034163827b465ab4','AAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAATCCTTACTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1627,'1435c301ff94e8ed2993355cb7b91f27','CACACTAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAATCCTTACTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1628,'a963b1645d346c00af9f4723b251ea9f','CACACTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAATCCTTACTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1629,'e528ed135c06ec6c13bb731917ca6f25','CACACTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1630,'77082fc7b89855282bc8c62921148f71','CACACTAAAAACTTTCACGTGAACGTATCAACCTTTTAGTTGGGGCTGCTGTGCGTCTGGCTTCGGCTGGCTGTGCGGCGGCCCTATCATGGCGAGCGTTTGGGCTTCGGCTGAGCTAGTAGCTTTCAATTTTAAACCCATTCTTTATTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(1631,'d7942c105ebd2f62be841cf558cb6b0c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTYTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1632,'70a49c00039a6c427c5b05767e1ca140','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCCCTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1633,'dcf32303b6f1b537e5c371fffd277055','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1634,'8d971b82a16707f51c06ba8dc849c3c3','CCACACCTTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGTCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1635,'52dba83b871ae652d65f88e2116168c3','CACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1636,'8930368c5adb599e8bacd52c28380e74','CCACACCTAAAAAACTTTCCACGTGAACCGTATCACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1637,'a2857a93b4ff89ad1c2a72fd89ed075f','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCTTTTAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1638,'9edbb55687b91d5606e09f3d29fdcaf8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAAATATAC');
INSERT INTO its1_sequence VALUES(1639,'062a93ba68fc553388eaabce055afa2d','CTTAAAAAACTTTCCACGTGACCCGTATCACCCTTTTTAATTTGGGGGTTTCCTTCTGCCCGCCCGGTTTTCGGCTGGCTGGGTGGCGGTTTTATCATGGCGACCGCTTGGCCTTCGCCCTGGGTTATTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1640,'1a7257ee1ebe9ea45adb6a7e65b9b495','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAWTTGGGGGCTYCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1641,'4b9cc8d18f90ef7609e735c37c4f7804','CTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1642,'ccc05fc10229b1daed8fed3a21febd21','AAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1643,'1d075799ecc331c6c75218663e9eb2a8','AAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1644,'e3e784d43362c883bb6f414be535f1e7','AAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1645,'5096780d59c9840dd83572ed3c46bea2','AAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1646,'c82f9eb2d69885a8741298d144389fc2','CTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1647,'b48d82a27bb917a58053c4dde87945f6','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1648,'b0c4eb73f904ea4b8b0c32e3c543d4ad','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1649,'5746443c51fcd15c8bba669747929276','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1650,'38cb69a315bd7b962792da8a549b2f97','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCATCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1651,'e0f4aefb01d24558d75a2090cd1d46fb','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1652,'30973f83caf5e75dda5897f52d6f0c2c','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1653,'25e9e805c4ac94e1085be58f4802198f','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCTTTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1654,'08dbc38136bba57069859e73540c08d7','CACCTAAAAAACTTTCCACGTGAAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1655,'8072f2d3a99148c01cbf7b63aac69c89','TTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1656,'1edb0795ba8b6305ae81adbe4c7a7fe4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCYAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1657,'5ed6c5b495e6b5bc7f45db9e113a69d2','GAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1658,'270901a1b10cd43acb1dd1f68de5912b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTTCTTAATTCCTGATT');
INSERT INTO its1_sequence VALUES(1659,'974d36039e1c0f6e786cc5d4b3f7e51d','CCACACCTAAAACTTTCCACGTGACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1660,'f3c4789ffc3468ff274e14512a918e58','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTYCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1661,'aa08c87390af0194cc57214a53e32eeb','CGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1662,'bfae2684d89b70a654f11ee6add4bc20','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCAGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1663,'c4a8b8a4dff846dd3d98d9dd60d3238e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTTTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1664,'5be59dee9a118836b2e273fd88c3f6af','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTYCCGTCTGGCCGGCCGGTTCTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1665,'e79cd4fed9cb14dd9f426d9eaaca1b88','CGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1666,'609d9a3f25d8b347b64659c4f5aeaa3f','TAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1667,'3a4813e88f2b5a21bf06203aeedba47e','ACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1668,'0a300d51dadf261056805af579808825','CACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1669,'6c17bb118d9b99e5e62a10f17810a8f8','AAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1670,'01b4911929e48f83d4571cfde7580038','CACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1671,'66f9efa8b620a3a1ecc7c8c8b5807948','CACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1672,'eecdbd8641665f43806d4d2d731311d4','CCACACCTAAAAACACCCTTCCACGTGAACCGTTTTGTTTTGCTTTCGAGTGCTTTGTTGCGCTCGGAGCATGTTTGGGCTTCGCTGCTGGCGCTTGATTGTGCTGGCGGCTCGAGGCCATCAAGCGGCGTTTTGAGTGTGTGTTCGCATACAATTGAAACGTCCAAACCTTTTAAACCCATTTGATTGAAAACTGAAGTATAC');
INSERT INTO its1_sequence VALUES(1673,'4427e262d3e3c979667090af3e1879a1','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTNTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1674,'a292a01829eaeea0f0e1fa9968372d9f','GGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTCGGGCCTCGGCCCGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1675,'3d6191e55f830f09dbf607fed48942be','CACCTTAAAAACTCTCTCCCACGTGAACCGTATCAACCTTTTTAAATTCGGGGGCTTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1676,'b34dc0013a4df5614cbb837ebf9fa60a','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1677,'b3c0b1a94bf23b94139b85839592e885','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1678,'7c050ccd09e55e22abe70f631db2d0b2','CCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1679,'19ef8e7fc594103c42aef1e43536b6b3','CTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1680,'ca6da0874ed3ac549293b31b97d638d6','CCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1681,'53bab3a8e843f8a9ca75986369cc7864','CNCNCCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1682,'cfcd30c5202e2d1a2742f2e1ef2dc9af','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1683,'a40c898046e9177468829be17dff5285','CCACNCCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1684,'0c8285ac26f22a517cb65fe43f4c43da','CGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1685,'7a830cc204c1b01f31191d20050550ef','CGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTNTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1686,'a253b0a5293c404d99f7de3e791b9e96','CGTGAACCGTATCAACCTTTTNAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCNCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1687,'b9da4ec13b89a209eba5b02b6076650e','ACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1688,'d9ecd8502f2f937913679a5b5f9b5443','CGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCNCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1689,'92c1c23bd3cb2504ed1d405726da42db','CGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1690,'27a5bbd771c1eeecaf873807ae349c45','AACTTTCCNCGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1691,'ee65215d900925b70996f196a0c06cab','CCNCACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1692,'554e39beb660278b20530371f76de424','NCCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1693,'a365e198011f817e5bddb1cb37f2f059','TTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1694,'13b84d942c97ddf72259748b32d2c613','CCACACCTAAAANACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1695,'a9003bdfd47cf3030881118073330ead','CCTAAANCTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1696,'f3f681e79029430b6a54c342282b0a2c','AACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1697,'0ddf53d2ae63906eab18696b9923e686','CCTAAAANCTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1698,'64a710672294fde68e4cef8c48e9e949','CCTAANAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1699,'43ba684a9bef8e9adaad737216866a59','AAANCTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1700,'30a96450ab4f7652342c0f5b05299918','CCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1701,'fdb8d3711459855eeaef69b65e9abac2','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1702,'ed03c8ff404fb1f5a7e2d636f3e51276','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCATATTTTCTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1703,'389a72ca61713b5e296e2138aefb91bd','CCGTATCACCTTTTTTAAATTGGGGCGCTCCGTCTGCCCGCCCGGTTTTTCCGCCGGCCGGGTGGTGGCTCTATCATGGCGACCGCCTGGGCCCTGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1704,'3f2ec7a8da24bb5005f9b7506cb3fd13','GAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1705,'ea79435897aff8a6d215cff50908a476','AAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1706,'c87f0229a9b1e8cf39e0a278bd2c8f4e','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1707,'b2ef326ca8ddbcf055e5aab42a5f7e1a','AACTTTCCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1708,'43d62e51321061fb4ddf971fac7260ca','CCACACCCTAATAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCCGCTTGCGGTGGCTTCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTCGTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1709,'5b30d0b36311ea02ecdaf8a03149c615','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCCGCTTGCGGTGGCTTCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTCGTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1710,'7640fdff870216b67b5379a76060dff1','CCACACCTAAAAAACTTTCCACGTGAACCGCATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1711,'2e451f11a4536d38f009a058168428c1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(1712,'bf1bf5efeb7878ebd8d5f5e3b6dfdd50','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1713,'efe94cb10495f7ab2040de0ec59cc2b1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGCTTGTTTGGCGGGGTGTGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGAGCTTTATCATGGGCGAGCGTGTTGGGTTTCGGCTCGAGGTAGTAGCTATTTATTTTAAACCCATTTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1714,'11899cc4da75213c08d159b6fe8baf00','CCACACCTAAAACAAACTAACCACGTGAACCGTATCAACCCTTTTAATTTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGACCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAAAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1715,'f14545579c61eebde857414cc131333d','CCACACCTAAAAAACTTTCCACGTGGACCGTAACCACCAAGAAATGGGGGGCTTCCCGTTTGGGCCGGCGTTCGGTTTCCAAGTCGACGGCTGGCTTCCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAACCCACTTTTTAAACCCATTCTTAAAAACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1716,'10c8be289a9d17eb63b18cc2e29e51aa','CCACACCTAAAACAAACTTACCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGACCGTTTGGGCTTCGGCTCGAACTATTAGCTATCAATTTTAAACCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1717,'20cc3b7ce06a49708f0903d437b6be4c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1718,'3028c4353a136039819b2cd744b0fd48','CCACACCTAAAACAAACTAACCACGTGAACCGTATCAACCCCTATAGTTTGGGGGGTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1719,'aba4fab4999e7749b954f0cc4c8f489d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGACGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1720,'994ed6b0ad828df962b6edf3bc1e962a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGATGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1721,'33bd0ed3686af47c3627919a96cb5981','CCACACCTAAAAAACTTCCACGTGAACCGTACTCAACCTTTTCAAATAGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1722,'f0a3707620d08c3e1a62c7bb7c400367','CCACACCTAAAAAACTTCCACGTGAACCGTACTCAACCTTTTTAAATAGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1723,'da3fba9a21d17c3998ea2b73eb2fdfff','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCATCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1724,'30f6b2d6c991244cc294c7379714fc14','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCAGTATTTTTTAAACCATTCCTAATTACTTGAAAAAA');
INSERT INTO its1_sequence VALUES(1725,'a94dc78a9a9f37119697653bdff6e162','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCAGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1726,'a1752fe7cfdcdd323f9589f0366fa886','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTTGAAAAAA');
INSERT INTO its1_sequence VALUES(1727,'5711a4d2f87f04bd5f690b22dacd5b52','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCNGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1728,'dc46ce691e372f14d84e7b41e967af61','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCAGTATTTTTTAAACCATTCCTAATTACTAGAA');
INSERT INTO its1_sequence VALUES(1729,'ca7136c20315e32bd961c9b344de2fb8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATGGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1730,'e3c18a4a775f78c8e75c53c1dc47730b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCGCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1731,'5c600d52909624c0357a2115a056178c','CCACACCTAAAAAACTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTTGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1732,'a80c5f62c6b5f2ed121f6ba0d0074de3','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1733,'f2ed4c6acee03aabd4d10c6f0a98b7e6','CCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1734,'ea358c02e11cef5187f7167c4699739c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCRTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTWAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1735,'71941192b31d5144817ecf9915a19c74','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1736,'538081b323f6215cd26c81328bda2e80','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGGCCTCGGCCTGGGCTAGTGGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1737,'4007ef7ba7930027e2c23e1e89ecba09','CCACACCTAGAAAACTTTCCACGTGAACCGTATCAACCCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1738,'f551a20f9d08698d4071d972f96e0d76','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAGAAACT');
INSERT INTO its1_sequence VALUES(1739,'fa25c8ac56bfec1874c7f1fda25062fc','CCACACCTAAAAGACTTTCCACGTGAACCGTATCAACCCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1740,'579a69da5789128ec824d09362c37dbe','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAAATTGGGGGCTTCCGTCTAGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1741,'12266a689ebf593470847881ed9ba00b','CCACACCTAAAAAACTTTCCACGTGAACCGTGTCAACCCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1742,'04899687d734b7192a772dc919b8c555','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1743,'b30d83951885b3f937c375105690772f','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1744,'f8359e907087f0ebc99a59859c0a4960','CTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1745,'bd07375dbf02de3fdc9ea22badb11545','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1746,'55a547a91a78a5744e720307ece7b582','CCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1747,'3b5a3ceeca7edd7dbed268e58378ab90','ACTCTTTTCCCGTGACCCGTGTCGCCCCTATGGTTTGGGGGCTTGCTTGGCGGTGTGCGTGCTGGCCTTTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCAAGTAGCTTTTCCTTTTAAGCCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1748,'cb0ead574c36a3c3882f2ce80fa15198','GCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1749,'368bde27d30df49fd49d51d236f1f3ad','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1750,'0ba4207984895b9a71c47092a8a0ca88','CCACACATAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1751,'8c093623405def71b4c8643c0b404a80','CGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1752,'a5e077ab09fd5926f718e40e6131960d','AAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1753,'95eab4cb57ad21a62329e58e137cef2e','AACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1754,'d36e78e75194bcfea5f4e39a5db919f5','AAACTTTCCACGTGAACCGTATCAACCTTTTTTAAATTGGGGGCTTCCCGTCTGGCCGGCCGGTTCCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1755,'40ae145821d6282ff6ddf4cae9f89735','CTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1756,'bdb22a69af561f6c1c85c3786b3593fc','TTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTCGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1757,'3d817c3a95f966b1c6f049b5dcc6cabe','CCACACCTAAAACTTTCCCGTGAACCGTATCAACCTTTTTAAATTGGTGGCTTCCGTCTGGCCGGCCGGTTCTCGTTTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGYATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1758,'ef7f8b712a34cda1b6ca51d738430679','GCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1759,'141bbe941cd8db28e3d846269bc09b87','CCACACCTAAACACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1760,'132554a5dcd759bcf734209fce008cc1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGTTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAA');
INSERT INTO its1_sequence VALUES(1761,'aeefd3edbb9f20ef3afd7b32b6a5d2e2','CCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCCTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCATTCCTAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(1762,'5e286009ecc9cedc98aaec4e078ae6e3','AAAAACTTTCCACGTGCACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1763,'ba8e4098986a70394f987cf24b2b864e','ACTTTCCACGTGCACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCCTGGGGAACTAAATCATGAGCCCCCTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1764,'56a779bc5995e577cb6dc5da4f18e748','AAAAACTTTCCACGTGCACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCCATGTCAAAATCCGCCACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCCTGGGGAACTAAATCCTGAACCCCCTTTTTAAACCCCTTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1765,'e3d8ce59f35f64753ce880f05d809e8d','AAAAACTTTCCACGTGCACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAACTGTCCATGTCAAAATCCGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCCTGGGGAACTAAATCATGAACCCCCTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1766,'46770a19a41be4a001ffd0e2182c72db','TCCACGTGCACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAATCATGAGCCTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1767,'c35a809a48b1f112052da1733c33a28a','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTGGGGGTCTTGCTTGGTGTGCGGCTGGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGCCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTATTTTTAAACCCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1768,'6d0150a7b9dbc16066fe68506a719bc2','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTGGGGGTCTTGCTTGGTGTGCGGCTGGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGCCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTATTTTTAAACCCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1769,'b1789d7b3996174aae003a68215aae4a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTNCGTNTGGCCGGCCGGTTTTGGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1770,'3c5018de045a2211534c0070726947ea','CCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1771,'3d8e9a6dfe355778a47f32c371dbfacb','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1772,'319e7c94d7709ea8bf50068fb48b612c','CACCCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1773,'cec0eb4c30586ab01719502e39ba3523','CACTAAAAACCTTTCACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1774,'cac310d5a3d88256a869aab921de60c8','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1775,'7fdc0451612f84e659b2b215fd5d3cf9','CCACACCTAAAAAACTTTCCACGTGAGCCGCATCATCCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1776,'f230c51922fff6a0de37d183158d6397','CCACACCTAAAAAACTTTCCACGTGACCGTATCACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1777,'70eba820413b7fdbff978f3d58ba5a9c','GGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1778,'7f1624f737f98af8f8d07aa138ec2e8d','TAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1779,'0c7e65a5ba0628757dcda26d9d4135a0','CACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(1780,'a2be2a1e77f63fc036bd4651a3f914ef','CACGTGAACCGTATCAACAAGTAGTTGGGGGTCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1781,'a2594e20f5aaf7cadb122ee6f09124ba','CCACACCTAAAACTTTCCACGTGAACTGTGTTGTTTGTTGTTGGGAGCTTGGCTGACGTTTCGGCGTTGGTAGAGGTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTGTAAACCCTTTCTTAAATTCTGATGATACT');
INSERT INTO its1_sequence VALUES(1782,'110e10415ce41e129b9c1c7264599ed3','AAAACTTTCCACGTGAACTGTGTTGTTTGTTGTTGGGAGCTTGGCTGGCGTTTCGGCGTTGGTAGAGGTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTGTAAACCCTTTCTTAAATTCTGATGATACT');
INSERT INTO its1_sequence VALUES(1783,'dbfa21bb182584994ae4b5bbd0be6baf','CCGCACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1784,'57dd63148020c4cc910034c792219bce','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTTAGTTGGGGGCCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1785,'0476baa9bcf9b356e0b812bf6a420c8f','CCACACCTAAAAAAACTTTCCACGTGAACCCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1786,'d0a3162784b54062f19e7abeddc8b09f','AAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1787,'33e7ffefc038193a9c2b44355b7221a0','CCACACCTAAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGACTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTATTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(1788,'fbe4fa2dd83eb3ad81463bdb464b0006','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCATTTTAAACTCATTCAATTATATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1789,'2ebe1cc622f1080ad51406ab5f32fb9c','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCATTTTAAACTCATTCAATWATATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1790,'8ebd1034ffb8e738a874f04090421a4e','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGTTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAYTTTWAACTCMTTTMATTATATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1791,'5c3f938ab36bf19a89fe6e8daa6b533c','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCATTTTAAACTCATTCAATTATATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1792,'8e237326b105ce5e44abcf10536d2e35','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGYTTCGGCTCGAGCTAGTAGCTATCATTTTAAACTCATTCAATAATATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1793,'4a2bbf667e64706d07a7ec16977e8510','CCACACCTAAAAAANCTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGYTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCANTTTTAAACNCMTTYMWTAAWATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1794,'18239a239ac0192fe942a1b737bedcf2','CCACACCTAAAAAANCTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGYTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCANTTTTAAACNCMTTYMWTWAWATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1795,'bebb954b20fe8301d1f9b490c989b13d','CCACACCTAAAAAAACTTYCCACGTGAACCGTATCAACCCTTTTTRATTGGGGGCTTGYTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCANTTTTAAACTCMTTYMWTWAWATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1796,'1a757792ee175409b47632888037da1b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACACCCTTAGTTGGGGGCTGCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1797,'76d318bb2c9db9286a09a94098e15779','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACACCCTTAGTTGGGGGCTGCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1798,'cd2b32f8a6cc25e727b6fa4e05d5040f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACACCCCTTAGTTGGGGGCTGCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1799,'4e6d461740493679a69794883f9c02ac','AACTTTCCACGTGAACCGTATCAACACCCTTAGTTGGGGGCTGCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGCCCACTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1800,'5afe32930e44366aacaa3c72246c4abc','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1801,'97de2f1d70961a3e6b86d7361f0d7bf5','AAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGAGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1802,'03530b83ac12d9f304f91564d3469e92','CTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1803,'38da0ca175a5dc87f91ab466dbd1159d','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1804,'2ba87367bdbb87cc37521bed773ffa37','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1805,'903f04fc0c9e4cb882b5aafdd7b4400f','CCACACCTAAAAAAACTTTCCCACGTGAACCCGTATCAACCCACTTAGTTGGGGGGCCTGTCCTGGCGGCTGGCTGTCCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGGGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1806,'84689141ec6b74300c4f30f0ffab1ce2','TAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1807,'8e080676faf1b19d32d15cd4ce990e37','CCACACCTAAAAAACTGTCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGAGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTTCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATA');
INSERT INTO its1_sequence VALUES(1808,'86f387de46d29e81f6183d4a23669d79','CCACACCTAAAAAACTATCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGAGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTCCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATA');
INSERT INTO its1_sequence VALUES(1809,'22c551b2f799878432124a2c62a2a25e','CACACCTTAAAAACACTTTTCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1810,'8ca9568fe048642952b1c3ca5b45e779','CCACACCTTAAAAAAACTTTTCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1811,'45f4925e1241216a11b3f66ec03724da','CCACACCTAAAAAAAACTTTTCCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGCTTGGGCTTCGGCTTGAGCTAGTAGCTGTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1812,'f8b30a5df9811c73261f920fb4bfb3c2','CCACACCTAAAAAAAACTTTTCCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGCTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1813,'971f9182b8e62c5af100a56970babd68','CCACACCTAAAAAAAACTTTTCCACTTGAACCGTATCAACCTTTTTAATGGGGGATTTGCTCGGTGTGGGGCTAGCTGGTCTTTATGGGCTGGCAGGCTGCTTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGTTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1814,'b569449ae9e79892b24c70fb5b40ef9d','GTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1815,'aa94c637d4a3ad63f8a21292f3e2e72c','CCACACCTAAAAAAAACTTTTCCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1816,'c59a9a8ae7a55ab0854861c397c31812','ACACYTTTTCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1817,'1776d0255bc852fe18f1fc68fa7a5170','CCACACCTAAAAACACTTTTCCACGTGAACCGTATCACCCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGCTTGAGCTAGTAGCTTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1818,'5756ebefd58f35b87cb137f19983a996','CCACACCTAAAAACTTTCCACGTGAACCGTATTACCACCCAGTTGGGGACTCTCTGTTGGTGGTTGGGGCTGGCTAGCGCTGGCTTTGACTGTCGATGGGTTGAGACCTATCAAACGACGCGTTTGGGCTGCAAGGCCTGAGTGTTGTCTGTTTCTCTTGTAAACCCATTTCTAAAAACTGAATATACT');
INSERT INTO its1_sequence VALUES(1819,'5edd5679341d53d2dfb5f693351b3ddc','CCACACCTAAAAAACTTTCCACGTGAACCGTATTACCACCCAGTTGGGGACTCTCTGTTGGTGGTTGGGGCTGGCTAGCGCTGGCTTTGACTGTCGATGGKTTGAGACCTATCAAACGACGCGTTTGGGCTGCAAGGCCTGAGTGTTGTCTGTTTCTCTTGTAAACCCATTTCTAAAAACTGAATATACT');
INSERT INTO its1_sequence VALUES(1820,'96ea89e111b15f31d7b39bf396e44399','CAGTTGGGGACTCTCTGTTGGTGGTTGGGGCTGGCTAGCGCTGGCTTTGACTGTCGATGGGTTGAGACCTATCAAACGACGCGTTTGGGCTGCAAGGCCTGAGTGTTGTCTGTTTCTCTTGTAAACCCATTTCTAAAAACTGAATATACT');
INSERT INTO its1_sequence VALUES(1821,'45da6e91f4a1f33e5fd3e802984381e0','CTTTCCACGTGAACCGTATTACCACCCAGTTGGGGACTCTCTGTTGGTGGTTGGGGCTGGCTAGCGCTGGCTTTGACTGTCGATGGGTTGAGACCTATCAAACGACGCGTTTGGGCTGCAAGGCCTGAGTGTTGTCTGTTTCTCTTGTAAACCCATTTCTAAAAACTGAATATACT');
INSERT INTO its1_sequence VALUES(1822,'41a192205aebe4139b96e3735b7746db','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTATTATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGCGAGCGYTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTTAAACCCATTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1823,'2c94fcaae00c71265f5827de4862bcb6','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATYGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTATTATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGCGAGCGYTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTTAAACCCATTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1824,'c6c7efc71b016e0c67b394de811cfe17','CCCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(1825,'bbbebaa17b279d747e1710689568c4af','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGTCGGGCTCTATCATGGGCGAGCGTTTGGGCTTGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1826,'ecc0b24fcaa6af8fd17f58705354da5e','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGTCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1827,'2b0ce61e5aa7cf7b117e383d8d465766','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1828,'21c20f13111a9ee725b2ae36ff953ea3','CCACACCTAAAAAAGCTTTCCAAGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1829,'4b8d640b15b8e94a5acc2fe519a220ae','CCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1830,'d9bdcda6648382f7e19445426bd93bc4','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1831,'3dbd39571f19fea72f69ddfdaee370b0','CCACACCTAGAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1832,'d54c9b8dace5d8a32a5a14eb17a7a509','CCACACCTAGAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1833,'7fb504900f4e047f6c7f9f1730a94048','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1834,'dd946b4114853ff2effaaeefe609a2e2','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCCTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1835,'d311de0bb207dc25cb4fc345772971c0','CCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1836,'69d814bcc469a500610a5c1e92921ad5','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTNGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1837,'7aa21700b88e76a4148b2e0f479a7a0b','CTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1838,'868e1ad838c7ec587dfd05b9dd4556ec','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1839,'018a1194692036d56dd4513292cc9514','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGGAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1840,'951df58788d275d3f17518a2fb90b124','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1841,'9bda7d98c35b316ff899a148c94a3941','CCACACCTATAAAACTTTCCACGTGACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1842,'900b4b5b04caa9940187bc9d706581ca','CCACACCTAAAAACTTTCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1843,'59be72ace4f654f8af2260fcc6747702','CCACACCTAAAAAAACTTTCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1844,'84677386774b50a3a69a271699216bb4','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1845,'956749b2c7b42d73cb1f03485545918f','CCACACCTAAAAAAACTTTCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1846,'515d0f20a87d095adbcda06924a1311b','CCACACCTAAAAAAACTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1847,'b41bd96ee5ab588676231f733c548e02','CACACCTAAAAAAACTTTCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1848,'d8eff8b913e45f23e78c98fd6cf490be','CACACCTTAAAAAACTTTCCACGTGAACCCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1849,'87343fe8a2bcb231c543bc406f3e8cea','CCACACCTAAAAAAACTTTCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1850,'0ed12f0998797b2737647c5eaa9e23f9','CACACTTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1851,'e9467f0be89f59df8b231dacb37e3a1c','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGCGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1852,'5e2f6656bf570c0fb4357379dfbf81ee','CCACACTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1853,'63f91612ec16b2dbea978e4c9e422a74','CCACACTAAAAAAACTTTCCACGTGAACCGTATCAAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1854,'3084debf7e8358104b7e548738dc2bf8','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGGTCGGCGGCGTGCGTGCTGGCCTGGAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCCAGCTAGTAACTTTCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1855,'bc110b85b0bfe75baa7311cb5883a1b9','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1856,'94567229428179d159f630446688bd27','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1857,'00a267d4cf6e51efe2d39cb9d7eee763','CCACACCTAAAAAAGCTTTCCAAGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1858,'4f4c6dd2e64d0d62d94c60acd3ab569c','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1859,'81c494ab475c57b797843fc6beb9027d','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGACCATACT');
INSERT INTO its1_sequence VALUES(1860,'2c0f263b370fcf9f14f9e7a034e8bfb7','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCACGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1861,'413fd707123434afbaffe3694dd12a64','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATAC');
INSERT INTO its1_sequence VALUES(1862,'f88223986e494de11e2011a690fa1cd7','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTYGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1863,'8e0251d6b9b6c69b0ba60c7e11026a7b','CCACACTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACTCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1864,'09497408b5c708f975a1b3c5ea6ab81a','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTTGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1865,'fdaa9c310982ca1215016d0e72d9f884','TTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1866,'37efab93746aee50757ac302de93721d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1867,'92ee16ce5bd3e7635cfba23b1e29559b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTYGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1868,'6d2b164399869300cdf8a80f170573b0','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1869,'b619f23d0bffac184de737b6ad190557','CTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1870,'2944da3e44e9965aef69b0034c8b4ebe','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1871,'b2977cece21d9b196b70d936375aff2b','TTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1872,'7ab4d7058809a5ddf0fd05c82064d9c7','TTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1873,'dda39e27d94402fd249118d751f90ab2','CCCACCTTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTNGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1874,'f26e7cf3cffef7453d666651c8790840','CTAAAAAAACTTTCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1875,'036d4f9cb297e9e2b337a25db9bb0e47','CACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1876,'607ccced6d5d2838e2ecf290cbe8559c','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1877,'df20583cc3ca288a1e485ce4b0461895','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTNGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1878,'24bbed496e4225c533b43db060dc5bce','TTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1879,'762be4ff3f4f7aeed2ee5d0e22972f80','CTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1880,'5ca767b8bad2a0da2bd921ffd6edf573','CACCTAAAAAACTTTCCCGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1881,'18f838154941c39d9cfe9443eaa5677e','AACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1882,'7ee5f4f83582f470b7a4ef6084a58706','CACCTAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1883,'ff29fda2f2cd0509b87e4c24984834f1','AAAAACTTTCCACGTGAACCGTATCAACCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1884,'d4e69951ac0f91f400004ff2fb30202f','AATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1885,'1cd62b5765d25ecd6c11eb7ce1c510db','TTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1886,'3145e3067f70b49194d63f2d9fe91e61','CTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTYGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1887,'b9339e4326e442062f596fc38dc5ba89','CNCACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTNGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTNGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1888,'015ad787aec290c0b15e3d03bad58650','CCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1889,'1fffb3be37fe2273b711fabd5d73da8d','CCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1890,'3887847a05fda5ef035a056a8a145bf4','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1891,'2d8bfa7d20baba5ecc1cc3e7c205ba78','ACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1892,'fa10dabe9ca86af9c2e8f520068c6500','CCACACCTAAAAAAACTTTNCACGTGANCCGTATCAACCCCTATAATTTGGGGGCTTGNTNGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTNGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTNGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1893,'d908a5bbb6ab4a263467062d745a3e04','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTYGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1894,'a0330343d5859d0283a1ac7ee4991cd5','AAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTYGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1895,'2d163ba40842bb3291503a87ca163957','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1896,'bcc26e8cb5045864ed52a98f8c04f54a','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1897,'5a9ec8b7085eeacbc5b9ddadf53b8bb6','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1898,'0cd1baa6b20b157df48c417557041d7b','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1899,'9e80ea5d14b896d6840b168e6ca77020','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1900,'1d796bd1d2250962c03e05409a6695aa','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1901,'a87f54bd03677474cb2b0e08517e29e1','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTAGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1902,'bd4a78e5a9c002eda7c5e7a5b5ef2973','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1903,'ef6d9495503cc8e5125e48f8e8dd4146','ACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1904,'ea1c6490cb6a45a3a63fd2b81d1f5aae','ACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1905,'31d93a34a3b17a8e0fadbe1ab52c95a3','CTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1906,'e16dbd4adbf20b30afdb0be91bfda6e8','CTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1907,'261a96b2c57b786506c4f40b248c1f5f','CTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1908,'c2c4410ed60f15fa52ae4f9ec45e29e8','AAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1909,'9ca72306aab041b2a3211a669114e3c8','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTYGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1910,'549314808d2a98494eb83bf23495ef23','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTYGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1911,'6acf055927de9f5b14f7b1d179a96ecd','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCWTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1912,'34c1acdd82cf93a9dcfe37d5c2b6b379','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCSGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1913,'778fb2455bcc46659190d634935542d1','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1914,'d1e731dd1f1d8f2b960dc1df4b9ac025','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1915,'2eee81a1d83fa6de7247f5a37a37603e','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCTCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1916,'3bebc271e315edabccaf5bbc26f9d27c','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1917,'7bb501e3ab5562891205338cbf37d285','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(1918,'7cb111dd09e63ef369c8a78f4d7eef84','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAACGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1919,'9dc213b553158343c50cfb60b3419b76','CTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(1920,'51f3be131560164f15814cf8c4c903b6','TAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1921,'e2f128821d7356eafc3eb168c5ec2fcc','AACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1922,'6b1dbb1a77bcf2acb8b9ea24a1664b57','ATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1923,'8eb80216f242194f34be71edf76bad1b','CTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1924,'be7ff5b41566335a9564616aaf3dd610','TTCACGTGACCGTTTCAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1925,'03ad6a21e29cb1db21980f6ae9ad4b24','CACACTAAAACTTTCCACGTAACCGTTTCAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1926,'8abbcb7eac0a252f7bbdcd704b0fb9ed','CCACACCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1927,'c5428f2ab1e98f4fa9bf33e5bfc49de1','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGCGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1928,'0205738b9a2de8d97a72d0a0e1c3a20b','CCACACCTAAAAAATTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTACTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1929,'efe61ca56bdbf0ce32a373df8a8a6c11','CCACACCTAAAAAACTTTCACTGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCTGCTGTTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1930,'1016198dd48c2bf696aea6003eb2265f','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1931,'f1bebec1e0673d09125009a6e840319f','CCCTAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1932,'9b43b70d56a7dd3ed87d13e20b17c2f6','CCCTAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTACTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1933,'b47e89f48196b5fb0c7299638939bacf','CCCCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1934,'0dc6543d6278100b1288df412cf6ad7c','CCCCTAAAAAACCTTTCCACGTGAACCGTAACAAACCCAATAGTTGGGGGCGAGTTTGGCGGCTGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1935,'497e6de49080620a563cb682e6bfa177','ACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTACTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1936,'15c61b41e4a0d339150b02443bcca90e','ACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1937,'3a194f149393ff1381bd02fd134eb9a2','CCACACGTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTACTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1938,'8685f94074c93d92aee7d440eaf2b573','CCTAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCTACTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1939,'fd2b99e9422292f92b610ab0352ed694','TTTCCACGTGAACCGTAACAAACCAATTAGTTTGGGGGCGAAGTTTGGCGGCTACTGCTGCTGGACGAGCTACTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(1940,'11ababf3abb6d359347d6496f4c12c6c','CCGTATCAACCCTTTTAGTTGGGGGCTTCTGTTCGGCTGGCTTTTGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGTCTTCTTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1941,'ec78c5ca48d4e5201ead8274bacf5090','CCACACCTAAAAAACTTTCCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGCTTCTGTTCGGCTGGCTTTTGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGTCTTCTTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1942,'649bb2ee8824b67cc69fc78336b58bf7','AAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGCTTCTGTTCGGCTGGCTTTTGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGTCTTCTTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1943,'3c3d19310a92470a1819180ab65a7abe','CGTATCACCCTTTTAGTTGGGGGCTTCTGTTCGGCTGGCTTTTGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGTCTTCTTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1944,'bf948ec4c868546c25cd0bca6dcbbd30','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGCTTCTGTTCGGCTGGCTTTTGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCCTGGGCCTTCGGGTCTGAGCTAGTAGTCTTCTTTTAAACCCTTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(1945,'cb9addac22beaae1dd11caa24bce1c98','CCACACCTAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(1946,'f78644f0e45a9be23d333ae188eea33b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGGCTNNTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1947,'dd24541aceb5e1226c1744e08a807f0a','CCAGACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAACTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1948,'017d406608eb00abb4a57c00a35cc727','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1949,'2ff948b2a038c128dc6c803eea1f1782','CCACACCTAAAACTTTCCCCCTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1950,'6b29b1211f3cb42c95e1702cebe50bd3','CCACACCTTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1951,'1aa82ef8bd254389a4a1a2e6db8bb861','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1952,'900b3a0be598b4a0897db8599cf80574','CCACACCTAAAAAACTTTCCACGTGAACCGTATCACCCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1953,'993d4abefb1945ac15bc28920b17ede6','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGSMWGKAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(1954,'a4e6e87e279af3c2b765528c8a86cd49','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAAA');
INSERT INTO its1_sequence VALUES(1955,'bf2a0d16a907b2fbe3fa8c9bff1fb255','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCCTTGGTGGTGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTGTTGTAAACCCTTTTGTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1956,'191290e66169ddf2c65fdebf500ae0c7','CTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCCTTGGTGGTGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTGTTGTAAACCCTTTTGTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1957,'6a46183877be78efd1aec52d18d09f43','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCCAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1958,'4f69336239b93e5560bbc0b947d4076d','CCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGGTCCCGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1959,'fbbe03092f2af0a717f480d089dda35b','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCKGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1960,'84fe8c7f0723bc620be7ab7509fe0fb7','CCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCTGCCNGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1961,'08d1fafd2850a4093aa2b6821e6a976b','CCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1962,'f2cc39866f8951b1f255d46051386462','CCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCTTTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1963,'32568465b027a65d9a4d6fe2c752480b','CACCTAAAAACTTTCCCGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1964,'2a0ea1425a0fd7d23f1e78d03ac581d6','CTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1965,'648e05d4e59bf331dc0464580773673a','CCACACTTAAAACTTTCCACGTGAACTGTCTGTGATGTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1966,'4e7356158d73648a735c3c957b47f0b5','CCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTGGGGGCTGTCTGCCTTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1967,'d20e05640a68404b7c05ce9e1482fa1b','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGAGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1968,'ddefc2bffe53fb486842f54b90a0d07b','TGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(1969,'a2980fd7f8434c9224b6db8adce97ca7','ACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGTGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGNGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1970,'91f766116f19c97fb909590372e51939','TTCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGTGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1971,'86b11bc6b2eb0b8a3fff47b334c98ef0','TGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1972,'a595030beff6c24ae61327db22dcb51b','CCACACCTAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1973,'4143414aaeee32ad172ff5ccf0f3b581','CCCACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1974,'3ef0ea24ee899b564c815197991b70b7','CCCTAAAAAACTTTCACGTGAACCGTATCACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1975,'a2c2e59d9c4ee76a61057e5c96b3f7e2','CACCTAAAAAACTTTCACGTGAACCGTATCACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1976,'65cfa8d069c17473fcced590c785081a','CACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1977,'edad491738f3879239043bc1dcee8b0d','CCACACCTATAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTACGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(1978,'de928ff2ad435516c12dc0251d56fc47','CCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGTGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1979,'9db906281e67f7dce80fe899b645ba9e','CCACACCTAAAAACTGTCCACGTGAACTGTGTNGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGANGAGGCGGGTCGNAAGGCCTGNGTTCTTTGTTACTGTTTTAAATCCTTNTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1980,'7b3531e383eb18368c5585fedf499f1f','CTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1981,'118e4118e6a313aebb7aabd24e633a4f','CCACACCTAAAAACTGTCCACGTGAAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1982,'e26334b7e1f51f54b2e0e7c10ac05dfe','CCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTTTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGYGTTCTTTGTTACTGTTTTAAATCCTTCTTRTAGACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1983,'64ded0f33478557a01aa588b9a1d638d','CCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCGTTCTTTGTTACTGTTTTAAATCCTTCTTATAGACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1984,'545ca55054e00330d1e806689d576951','CCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGYGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1985,'2c1af6dc434d1f8f031b5c20060dc916','CCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGTGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1986,'52d42be7759be59ded3c0f9c478c8f3d','CCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCGTTCTTTGTTACTGTTTTAAATCCTTTTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1987,'9949c0745c54aa894bbcf2116a8ae67a','CCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGARGAGGCGGGTCGCAAGGCCTGYGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1988,'06880b2fd23df7afd8097f2003cde914','CCACACCTAAAAACTGTCCACGTGAACTGTGTTGATGTTGGGGCGTGCTGGGCGTGCGTGTTTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAAGAGGCGGGTCTTGAGGCCTGCGTTATTAGTTTCTTTTTAAACCATTTTGTAAACTCTGATTGTACT');
INSERT INTO its1_sequence VALUES(1989,'3b92466383503ef016a746df4d2441ae','TGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTTTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCGTTCTTTGTTACTGTTTTAAATCCTTCTTGTACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1990,'84fcb1972a935e4e6cfbe93eb00d331f','CCACACCTAAAAACTGTCCACGTGAACTGTGTCGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCGTTCTTTGTTACTGTTTTAAATCCTTCTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(1991,'f4e2fb297b2f3bf1aa6394f5abc43c4e','CCACACCTAAAAACTGTCCACGTGAACTGTGTTGATGTTGGGGCGTGCTGGGCGTGCGTGTTTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAAGAGGCGGGTCTTGAGGCCTGCGTTAGTAGTTTCTTTTTAAACCATTTTGTAAACTCTGATTGTACT');
INSERT INTO its1_sequence VALUES(1992,'d8cf3f021a9487e0b4e84cd98c8b58dd','CCACACCTAAAAAACTTTCCACGTGAACCGTATTASCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1993,'f12f2d78c6b537b7d29c2170bd98b6bd','CCACACCTAAAAAACTTACCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1994,'f9c7b19ac5737340ea94f1243bd8606b','CTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1995,'067fc138edd03b20c9f94e8f3bb69b7b','CTTTCCACGTGAACCGTATTAGCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1996,'4c8c1153ca86cee65830bb0ec9f8b1fe','CGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1997,'8170238505e8940df0c3b8f620830d3e','CCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1998,'870c1e62f53f502510b87eb4858755d8','CCACACCTAAAAAACTTTTCCACGTGAACCCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(1999,'b41f75b65314857d711fcf9344c6e2a8','TGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(2000,'c31c7a2c026fc93d0d1b046b11c9edae','CCACACCTAAAAAACTTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(2001,'006a922b70cfc75264185b85764c86a2','CCACACCTAAAAAACTTTCCACGTGAACCCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(2002,'3a7b4e8b63f2b44b19fde657e923f412','CCACACCTAAAAACTTTCCACGTGAACCCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(2003,'eead1f9396cf63642b55255858576471','CCACACCTAAAAACTTTCCACGTGAACCGTATTACCAAAGTTAGTTGGGGACTCCCTGTTGTTGGTCGATGTAGCAATATGTTGACCGGCGGCGGGTTGAGACCTATCAAACGACGGCGACGAATGTGCGGGCTGAAAAGTCGGCACGTTTGTTTCTGAAGTTTCTCTTTTAAACTCCTTCTTATTTAACTGAACATACT');
INSERT INTO its1_sequence VALUES(2004,'8c55b2a8dee86ff6200495da5befa6f6','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTATAATGGGTTGGTGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2005,'3d83308c73fcc85b137850c43e0615ac','CCACACCTAAAAACACTTTCCAACGTGAACCGTATCCAACCCCTTAAGATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTCTAATGACTGAAATAC');
INSERT INTO its1_sequence VALUES(2006,'2ca6ffb4f1154369a698af5ef33235df','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2007,'6b3140f7761bdbd67ad2921b21cbe09a','CCCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2008,'13f79624cdde2f25b7b2d6f628d6c820','CCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTCTAATGACTGAAATAC');
INSERT INTO its1_sequence VALUES(2009,'2e818f1e1711206469a4f49ce6f187ac','CCACCCCTAAAAAACTTTTCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2010,'8e44513efd44e3ca79fc89f8dcfae332','CCACACCTAAACACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTCTAATGACTGAAATAC');
INSERT INTO its1_sequence VALUES(2011,'d66f2886b2bfea971f61c63fd20d8398','CCACACCTAAAAACTTTCCACGTGACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2012,'0c6736108f2820096290ede561e78f76','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAAATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2013,'543b679b871791755c48523c62c550fc','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGTGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2014,'d3d95c873ecaac00e3028e3c0cf2c23f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2015,'93e2e7878ede54c45282e2710acc473c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2016,'30cf56a4f654c490dd583a9a923eed86','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTCCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2017,'951be407f1655f486ec73b6481f2f07c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGTGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2018,'95ecc7f6332b09fe57e7f7ce9072b564','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGYGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2019,'6a642af394d1c2fe58dd0a0efc7f40f6','ACCGTATCAACCCCTTAAGATGGGAGCTTGCTCGGCGGCTGGTGCTGGCCTGTAATGGGTCGGCTGCTGCTGCTGGGCGGGCTCTATCAGGGGAGCGTTTGGGCTTCGGCTCGAGTAGTACTTTTTTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2020,'20ba5fd37dcd3c6d7604edf983042bd6','CCACCCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2021,'438305781e10bade3ef7962f929314fd','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTGGGCGGCGTGCGTGCTGGCGTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2022,'6acfa714f08c681160edd5766982f960','CCTACAAACTTTCCCGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2023,'049d4b5864db2aa3967a5788cff56436','CTAAAACTTTCCCGTGAACCGTATCAACCCCTTAAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2024,'a25f16694b83ebb1aa2b486a6069108a','CCACACTTAAAAACTTTCCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2025,'486325cd29bbc343a5bcc385d644a15b','CCACACTTAAAAACTTTYCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2026,'7e1f7c03e3a1940e495b62c367769c7b','TGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2027,'95ef12e99031aed56be96a5d3d16a81a','CCACACCTAAAACACTTTCCCGTGAACCGTATCAACCCCTTAAGATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTCTAATGACTGAAATAC');
INSERT INTO its1_sequence VALUES(2028,'8eb4270f7a5cdfc8153e28a2535861e0','AAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2029,'d8bae7a8d95e037a94583383be9dad03','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2030,'e9f1ff82d85097996396fdb475e2cba2','CCACACCTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2031,'c3b988cfea3d80a81a53faa6520eb146','CCACACCTAAAATATTTCCACGTGAACCGTTTCAACCAAAAAAATTGGGGGGTCTTGTTTGGCGGCGGCTACTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTAACGCGAAAGTTTAGACTACGGTCTGGGCTAGTAGCTTTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2032,'4de6918868a6c85e6e8f2e3e669e761c','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTACTATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2033,'9a1a60d0a54ab77cdee6f254324aa43a','AAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTACTATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2034,'a1f1e48e1b2ddcaa1141abdb566f0a5f','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTAATATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2035,'08e4f90b7e22b0a92120f5a5c4b14d9d','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTAMTATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2036,'830ef50e1a600ce4476f9ab6321135c2','CTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTAMTATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2037,'dce332cab7737e980fb06fc04c37ea38','AAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTACTATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2038,'3b2526508f32d917fd94fba1245789f3','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCTGGTCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTTTGTAAACCCTTTTTAATATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2039,'cf435223aa14cdd1d922e73370297faa','GGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2040,'f33e778817b1fefa94681a97266df642','CCACACCTAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2041,'39c990ccd12a8a4f8da8d1bc4074d4bf','CCACACCCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTTCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2042,'c0e8b64d98f767e776ce18009e3990d4','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAATTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2043,'679b7cef3c4e83d2f76c5fb19bfe70f8','CCACACCTAAAAACTTTCCACGTGACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTCCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2044,'6db45608a2fc182ab92a6d0d1dcf66a6','CACACTAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTTCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2045,'8da9e059dc7c090195f4db29110d6e77','CCACACCTAAAAAACTTTCCACGTGAACCGTAACAAACCAATAGTTGGGGGCGAAGTTTGGCGGCGGCTGCTGGCTTTGGCTGGCTGGCTGCTGCTGGACGAGCTCTATCATGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCCCTTCTTTTAAACCCATTTCTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2046,'bae5bbd87cedc2a6eb1979f0806fbc4d','CCACACCTTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCAGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2047,'ddaed989d1ef5778b6814bb2bc4cb0d7','CCACACCCAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2048,'ef3abbb3600e1e4e142df01c0abb341b','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2049,'05f2d98d1d746a4d30596e2775299ce0','CCACACCCTAAAAAACTTTCCACGTGAACGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2050,'62bc01bf6d5ab86fdb5581a50f140d33','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2051,'61c11e3f47c917cc7f3fe20d85eda0e0','TAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2052,'938e931cfe5c54146f877b0f0858d0b4','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2053,'f4a0a6f15c8488fcd2c14154a23ee51b','CCNCACCTAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2054,'b44d68a8437a6fb26bf84d896c79608e','CCACACCTAAAAACTTCTCTACGTGTGCCGTGTCATCGCTTTGTAAATTGAGGGGCTTGTTGCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2055,'22968818b31897361e50af8a5592328d','CACCTAAAAACTCTTTCCACGTGAACCGTATCAACCTTTTTAAATTTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2056,'f4f45d2d863720dbaf4910d2e4d14bf9','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2057,'64b7309cb98bab77ebdb55677c47a0a3','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCRTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2058,'0dd3c2369ca3ed3b74d93fe747827dfb','CGTGAACCGTTAAAAAACTAGTTGGGGGCTCCTCGTTGGCAGTTTCGACTGTTAGTGGGTTGAGTTCTATCAAACGATCGATTTGGGCTGCAAAGTCGGAATTGAGAGTTTCTTTTTTAAACCCATTACTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2059,'d53e17767c7b90306ab5c71586c65df0','AACTAGTTGGGGGCTCCTCGTTGGCAGTTTCGACTGTTAGTGGGTTGAGTTCTATCAAACGATCGATTTGGGCTGCAAAGTCGGAATTGAGAGTTTCTTTTTTAAACCCATTACTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2060,'4121903393f022697061e944ae7cba7e','CCACACCTAAAAAACTTTCCACGTGAACCGTTAAAAAACTAGTTGGGGGCTCCTCGTTGGCAGTTTCGACTGTTTAGTGGGTTGAGTTCTATCAAACGATCGATTTGGGCTGCAAAGTCGGAATTGAGAGTTTCTTTTTTAAACCCATTACTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2061,'4089b353ce59d7edc32861485b6fa99b','CACACCTAAAAAACTTTCCACGTGAACCGTTAAAAAACTAGTTGGGGGCTCCTCGTTGGCAGTTTCGACTGTTAGTGGGTTGAGTTCTATCAAACGATCGATTTGGGCTGCAAAGTCGGAATTGAGAGTTTCTTTTTTAAACNCATTACTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2062,'9dbafa54403dff1733297d7d578b59ad','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCATGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2063,'aa079221f098693c13f58818285c29f3','CCACACCTAAAAAACTTTCCACGTAGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCATTCTTTTAAATACCTGAACATAC');
INSERT INTO its1_sequence VALUES(2064,'ba9e7fd17aabaea4ca6b9af336e0e411','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCCGTAATGGGTCGGCGTGCTGCTGCTGGCCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2065,'0f61031c76cd479f5a6298956d533371','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAGACCCCTATAATTGCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAGATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGCTACGCTTTTCTCTTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2066,'ed9f3ae37cf6180c92d0efcb0c0f9cf2','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2067,'83d37e641dd0207fd9f49bb11b3cf047','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCGGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCCTGGGCTTCGGCTCGAGCTAGTAGCTTTCTCTCTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2068,'40e57cfebd12d0d15cf499dffbd1e695','CACCTAAAAAAATTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2069,'304ac7d6489359aa05ef38a6669da99b','CCACACCTAAAAAACTTTCCACGTGAACCGTACCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2070,'f793f60066ca4a85c9a362a0456965fc','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGAGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2071,'8bfe7f1a3c5bada16b84f857227b18e0','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGCGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2072,'ffdaa75798b1049b36d8cb63ff74eb7a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2073,'3fb02899d685792117d58668d6d4538b','CCACACCTAGAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAGCATACT');
INSERT INTO its1_sequence VALUES(2074,'05f69123d4b3a233f50f5203c0090966','CCACACCTAAAAAACTTTCCACGATGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAGCATACT');
INSERT INTO its1_sequence VALUES(2075,'5fe00a93359651bd04af0fff31a6c447','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2076,'796592cf8e54906053266d4db3a682fb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATAGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2077,'5ddb6b957af0998db14ab4274471cf6c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2078,'bee20494ab348fb2ccf92f28b686cd62','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAMTTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2079,'3c0715087ddd9dbec025400e91929e83','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTSGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2080,'cd4c5306b509b1744cc88d460556f113','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2081,'ba8ec51ad9e7bc1dd56ed6f30c947c6b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2082,'f8d8ee1bee04e6ac2aa7892d808ffe75','CCACACCTAAAAATTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2083,'fd796790bb7e5ba3eb44edbd97264b44','CCACACCCTAAAAAACTTTTCCACCGTGAACCCGTATCAACCCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2084,'ab1867147c1e4fc0d4856f8427cdbbbb','CCACACCCTAAAAAACATTTCCGTGAGCCGTATCAACCCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2085,'5d21fdd336fa54e22a18e8e3898c3d52','CCACACCCTAAAAAACTTTTCCACGTGAACCCGTATCAACCCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2086,'de82cf683dd47aaeefc93dd739c59e07','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRRGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2087,'77d53dd27268fbf58d794ead04c13dc9','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAMTTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGRGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2088,'86bccc8a87ba35bd41854d5e2b0dbf55','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGRGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2089,'bdd745b7b83439831e2d717ff93eb73e','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2090,'66aa046730f74e231ed563bbe306c175','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2091,'f461196b0cd85e0768218c6334884458','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGRGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2092,'7a586a7f6e2d2c8f81a832efbf7720cf','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGRGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTYGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2093,'4c9ac913aed68d483d513d803628ba39','CACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTATAMTTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGRGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2094,'547d8fc3aeaac82a9712445869794c50','CTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2095,'62a960425bd498027cf6dc3c7e7a0960','TATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2096,'9fd3c296abe684bdcf6cfb87f4c3ef10','TTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2097,'9f1a8a536d01bfbd947d506f77b282a1','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2098,'731895d3f93c770f059881878f80005b','ATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2099,'1ce57553a61ff874d69fd47536369ee2','TGCTGCTGCTGGGCGGGCTCTATAATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2100,'7b11ff18faa6e7ba3b36e5d55848355e','GGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2101,'7a18c4b853af983768d117e933c19f67','TTCGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2102,'83faf7af854d8127e68b7345dd46fa68','TTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2103,'30da6c61e9afbf7facfdc19d104804bf','AACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2104,'87290452e4962c611063ffac5be976e8','ATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2105,'73f3e6606c25a81738ccdfad0edb5fa9','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2106,'57165f7655412222556e08f32be746ed','GGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2107,'b6b944d382d289ad1dd525d1557e876c','TTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGACTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2108,'1b05f011e1a8f575f7ca8efd7857018d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGAGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2109,'b434525e4689b9acde96679db86de551','CTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2110,'4bb70a700f16bd3c0a01a9687cccd9a4','CTTTCCACGTGAACCGTATCAACCCCTATAATTYGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2111,'1efa30010e92a90b822814cffaa3d74d','TAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2112,'2b159b5d3de950ce9bfec97658b42eb8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2113,'8334e252729bb2452898b364e466b3e0','CCACACATAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2114,'14ff516c85ed96537c5e34bb406b1da2','ACGTGAACCGTATCCAACCCCTATAATTCCGGGGGCTTGCTTGGCCGGCGTGCGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTTTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2115,'ef2cb460d91cd3b8a90663af1986b36a','AATGGGTTGGGCGTGCTGCTGCTGGGCGGGCTTTTTTCCTGGGCGAGCGCTTGGGCTTTGGCTTGAGCTTGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2116,'8778694aad7c8de64a0e57a1593f2af7','CTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTTCTTGGCGGCGTGCGTTCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTTTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2117,'892cb2c7e2208bb1966090afb7f92c62','AAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCCTGCGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTTTATCCTGGGCGAGCGGTTGGGGTTTGGCTTGAGGTTGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2118,'0432e7d0d5d332e08ee2193a4676be65','AACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCCTGCGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCCGGCTTTATCATGGGCGAGCGGTTGGGGTTTGGCTTGAGGTTGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2119,'5140e354f5198cdab56a95adf5a2e560','AAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTTTATCCTGGGCGAGCGGTTGGGGTTTGGCTTGAGGTTGTAGGTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2120,'a470e5aa4bc0141a49c3bc0f0c3697b1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTGGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2121,'2bcc7e003d06d43d59679fb0d0580a0a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2122,'4a4aac6f867cbf30fb8864b6341d14ce','TTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2123,'ce737a099bb57fc3797fcc8c779ae3fb','TTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTACTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGAGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2124,'0f83439146574f45ebc6dc1694ae6400','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCCTGCCTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCCGGCTTTATCATGGGCGAGCGGTTGGGGTTTGGCTTGAGGTTGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2125,'c4877351e614832e0bda0ac05c077db7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTTGGCGGCCTGCCTTCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTTTATCATGGGCGAGCGCTTGGGCTTTGGCTCGAGCTTGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2126,'53653181ea70814f99051b44bdbce08c','AAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2127,'79720a7c5f4600b40e6f710a2797102e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCYCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2128,'e5fdcae790b47c5214d148e0683dd8fd','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2129,'21e127075eca85be8344fe612caac23f','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTTGTTGGCGGGGTTGCGTGCTGGCCTGTAATGGGTTGGGCGTGGTGGTGCTAGGCGGGCTCTATTATGGGCGAGCGCTTGGGATTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2130,'fa82580cb7f5d5333e0fbdbf673def1b','CCACACCTAAAAAACTTTACACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2131,'017b982c30844b125908fd42e19a1549','GTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2132,'922c4a6603ac6e315e70924f974f8e93','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2133,'cf83ab25b39742bb312c2ca7a5549a5d','GCGAGCTGGTGCTGGGCGGGGCTTTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2134,'43f9add64095a540c3cd5a211d9ad1d0','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCCCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2135,'f0563ba2979f878a798d548c7ac994ae','CCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2136,'ff895a6052b3f58b9c31b336692cc660','CCTATACTTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2137,'8f2302584aef9400e14944d9618184b2','CCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2138,'38a71f3e9cd2465d777ffa823ef1af6e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTYCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2139,'4375a72aae84d650c1b3e7f432eedc08','CCACACCTAAAAAACTTTYCACGTGAACCGTATCAACCCCTATAATTYGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2140,'67f5acc14921f61b33c55758648bc85c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTYGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAAYGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTYCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2141,'50a70095e0c0000df0e93da821a03e13','AAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2142,'88a119610d108015fd3d79d1ed44c900','AACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGRCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2143,'910a1a7a33fd4d9e6ea435b405395f25','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2144,'2bf9a4d7a458a95f0383b5a42711b2cb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2145,'3b8b925056c7542869200c1b07119a36','CCACACCTAAAAAACTTTCCACGTGAACCCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2146,'c85e4fb616e911f25032d33d47834375','CCACACCTAAAAAACTTTCCACGTGACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2147,'6faa74c326a2cbd0735411bc4a5378b1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAGTTGGGGGCTTCTGTTCGGGTGGCTTCGGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2148,'d0be1f9c521df5d06e079d66ccbdede3','CCACACCTAAAAAACTTTCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTTCGGCTGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGCGAGCGCATGGGCCTTCGGGTCTGAGCTAGTAGCCCTCTTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2149,'7f1ca2b91a44a9c2c62f893beb02955d','CCACACCTAAAAAACTTTTCACGTGAACCGTTGAGTATTGTTGGGGACTTGTTCGGCGGCGTGCGCTTTTCGGAGCGCGTGCTACTGGGCGAGACCTATCATGGGCGCGATCGCTCGGGCTTCGGTCTGGGCTAGTAGCTGCTCTTTTTTAAACCCATTCGTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2150,'96538efc5c74a33b531427bbe93cab64','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2151,'43adeec0d09c33743543caea89c5c8da','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAAATTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGTGGCTGTTGTTGGACGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2152,'687e5e98f0c74c92f15dcd4a1f49b6fe','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGTGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2153,'865efab38f6068d9f8d975eee7c6b480','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGCTTGTTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2154,'dac329505ffad5a11748d2dc88faa24f','CCACACCTAAAAAACTTTCCACGTGAGCCGTATCAACCCTTTTAATTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTAATGTGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGMTAGTAGCTATCACTTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2155,'100acc11ad2bf5759f4fcd8a16cbe97f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTNTAATTGGGGGCTTGTTYGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGRGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTNAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2156,'1e4c1ae2b1856ea881069501d2a1bcb9','CCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGATGTTGGGGGCTGGGCTGGCGTTTGTTCGTCAGTTGGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTTTAAGTTTTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(2157,'219b5b53071b6b58174d5bd6b4bd1d88','CTTTCCACGTGAACTGTGTTGTCGATGTTGGGGGCTGGGCTGGCGTTTGTTCGTCRGTTGGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTTTAAGTTTTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(2158,'c5f79aa5103f9767055bc066085e45e2','CCACACCTAAAACTTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAATCATAC');
INSERT INTO its1_sequence VALUES(2159,'6dc2195935e5f65563344bf0e6c98cd9','CCACACCCAAAACTTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAATCATAC');
INSERT INTO its1_sequence VALUES(2160,'8195c67033a5e9560d3c55eee3980316','CCACCCCTAAAACTTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCTTTTTTTTAAACCCATTCTAAACTACTGAACCATAC');
INSERT INTO its1_sequence VALUES(2161,'3a84a79cdc6bc7fa90bc5af5cd3f4ddb','CCACACCTAAAACTTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCTTTTTTTTAAACCCATTCTAAACTACTGAACCATAC');
INSERT INTO its1_sequence VALUES(2162,'620fb5b93ca7a47f321b91a756ec2ae3','CCACACCTAAAACTTTTCCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAAYCATAC');
INSERT INTO its1_sequence VALUES(2163,'46dbd5da34a89b84c65ac54be7a0bab4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGGTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2164,'4b305d079862fef525b669f3991bad96','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2165,'06e8478b4370f33b91f345909b94fcd2','CACCCCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2166,'33786393fabec4b8f9cc336e91db8cfe','CCTAAAAACTTTCCACGTGACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2167,'2d5b0da3c1c6a1193586ebc4921822a8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGTTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2168,'bdf4042b5b9e3e5e0a9a94870fc0c7bf','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2169,'5de8083fcbfaa01130e85040d833bdc6','GTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2170,'ff9411d8ab3d5611e3fef54cf445f665','CCACACCTAAAAAACTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2171,'68010da4734c0012dfc72f4e8f201500','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGYCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2172,'275c2fb0e8851c77aae0d38f66f44536','CGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2173,'d9024c6e26c3268bbba59d47477fdae1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTATGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGGCTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2174,'bfccd30cbc326a78a097e698ea4765ae','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGTCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2175,'57515ef2ab469baf028df492afe32e59','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCMTTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2176,'3efc7c2fc169e5ed1da62fff7fbe3ac9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGGGTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2177,'e514df1a50f19a5b6c55a186e5407376','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTTTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2178,'cb78ac3ff317b54afaae2a0909827872','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2179,'5555d0a9dcea7659c7abc51bcfc51a2c','TTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2180,'8f95bf4e0d4b5356438f6a887e68843f','CCACACCTAAAAACTTCCACGTGAACCGTATCACCCTTTAAATTGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2181,'9efe0acff5f054e766495a0a59f9b05c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGCAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2182,'7e688f8ca13c7ac6bc450395a3cb7f2f','TTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2183,'a6fa21fa284bad4800924ffd18bebabf','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2184,'315a306e40e77c1608c568671ce4745e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGCCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2185,'5c649e6aa4adff5879b942da7bf348ab','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGTTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2186,'f7c4488bcf414c6ff3c1e076d2b79f07','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGTTAGTAGCTTCTCTTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2187,'eff38e71458c9175b54c4238de65c908','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGACTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2188,'e3e4efa5497a07a06b29f2a0881afcf9','CCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2189,'0232fb52028dbc40acfb318701c95197','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2190,'4db761426fd6ce75b0460e54d8a523f3','ACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2191,'c353238c924a86746474b2d604652fd3','CCACACCTAAAAACTTTCCCCGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2192,'b0bfa69e1400a1a614256f9fea2ac709','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2193,'0a8110f5a8f798b257f918f0df3f6dfd','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTCAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2194,'c58c367b9e5252e79f3ae9c73155ea7c','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCATTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTACTTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2195,'30e18f4d9be8851e95205e9fe5028695','CCACACCTAAACTTTCCACGTGAACCGTTCAACCTTTAGTTGGGGTTCTTTTTCGGCGGCGGCTGCTGGTTTATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2196,'2a1b7c49405a47c5b3f5969c753a48e8','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTATTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2197,'30b4b58be4101df150c74104789ad0df','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGYGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2198,'0561d8536f5eddb607acd26e93402d97','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTAGTTGGGGGTCTTTTTCGGCGGCGGCTGCTGGTTTAATTACTGGCGGTTGCTGCTGGGAGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTAAACCCATTCATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2199,'b69acb1dd90b29f378c2221b4aafed2b','TTCCACGTGACCGTATCAACCCCTAATTGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2200,'6f8b8626e04bfe041cecf93ae18ef910','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGAGCTTTCGTCTGGCCGGCCGGCTTTCCGGCTGGTTGGGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2201,'22335d514edb7d3fd430a6ab8c2d16b4','CCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2202,'65fe2787cb7b1eae64a55b028e20d94c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2203,'657c5e0794c687361fa9307e4f8a0de4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTTGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2204,'abffb615c8ab2c63802bf33d3cb589ef','ACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2205,'23a03060e2a66f5c95fdb6acf3c9a628','CCACACCTAAAAAACTGTCCACGTGAACCGTATCAACCCAAGTAGTTGGGGGCGTTACTGTTCTGCGCAGGCTGTCGATGTGAAAGTCGGCGGCTGGTGCGGGGCGGTGATGCCCTATCATGGCGAAGGTGTTGTGTCCCTCTCGGGGGACGTGATGTCGGCTGCCCTCTGTTTTAAACCCATTCCTAATAACTGATTAATA');
INSERT INTO its1_sequence VALUES(2206,'77d78efe44702f5522e99d3f3798ac13','CGTATCAACCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGCTGACTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2207,'1c60e21b9548e7b07cc5ca9fd47b7264','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAACTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2208,'d21f8cd153cf76378517a4150efd5a4d','CCACACCTAAAAAACTTTCCACGTGANCCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2209,'f73af00e7a8a8dd18bab07c7365cd9f5','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2210,'d91bc10ce546d1fe8c7f44b954c2181f','CCACACCTAAAAAACTTTCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2211,'0292c58871bfab86e42562d902f73577','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2212,'0ecbc02e946d07603cc0d698a7adc53c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2213,'15117841758dd9d96c6d1ffcbb9b621b','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2214,'470940b9d34cf632a3fb9d0cc14862fd','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2215,'32e1934c7032acd155a5d7700d9f1349','CCACACCTAAAAAACTTTCCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2216,'ca2d3837f052be5fc9af1015c6343f97','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2217,'f15922eb744f6bfaeea61c6e08163965','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2218,'6955aee6c5d5861295806dacedae6311','CCACACCATAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2219,'1500b6b8a4299d81a0606610b8d96b0c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2220,'944accfa80bb362629d258dd43b81fb4','GGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2221,'baac591df64ab9c5ef1fa1c3969b5679','CTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2222,'4f8134a5d22b7a33daaf35a790619b10','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGRGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2223,'e349c0c224496490bd8566fa07298ac9','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2224,'77cf3fece26fe825513d5297a13a3b57','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2225,'df2ca44e99fe7cdf5652fe1bc160e563','CACCTAAAAACTTTCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2226,'8c7fb746bbc2ee4a90c69c98fd7b5825','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTGAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2227,'d9269687b0683a950de35469286fde4b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTCTCATGGGCGAGCGTTTGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2228,'42e576ec6747546513542a9494c801e0','TAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2229,'e017caca5faa79cd07463c2cd3286914','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2230,'2378be2724c6b1f877f42a95b304d558','AAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2231,'54f37e87eb5841c3565be44d79e05a40','CTAATAACTTTCCACGTGACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2232,'f48b3a2f8db3e829bb48ee258abcfc78','ACCTCTAAAACTTTCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2233,'662832152f52ba40550551b7f0c51eef','GAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2234,'d758224b8fe951befc09078876385ed8','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2235,'8796dabe461f25bd1b700d858e6c3a85','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2236,'68a573b62553b5bc5bf5258f46c50415','CACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2237,'a121e805f8216a18cc8eea9138a9d392','GGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCAGGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2238,'31a5c3d444e07116d7b12e022c5d5bbb','CCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2239,'b23a719611eb19dbd7a94bbfc25b127b','GCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2240,'7ec70010ac55fe2133c40a1687e68a32','GTGCTGGCCTGTAATGGGTCGGCGTGTTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2241,'4ff52064c6847361b0d49ca747771768','CCCACCTAAAAAACTTTCCMCGTGAACCGTATCAACCCCTTAAATTKGGGGGCTTGTTCGGCGGCGTCCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGAGCGTTGGGCTTCGGCTCGAGCTAGTAGCTTTCAATTTTAAACCCATTCCTAAATACTGAACATCC');
INSERT INTO its1_sequence VALUES(2242,'514e46983f50ba3b6ef7e73481b2ace8','CCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2243,'860378a9f7e81768263142654bdea35f','CTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2244,'2e5cc5609a8e1bc39d6248dfbed395d6','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTKCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2245,'11ce54e340803a004897b68348365f5d','GCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2246,'e613b496680e956136922aad56206bff','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGYTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2247,'084039ec590586815d621d62bf0f29fe','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCCGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2248,'8d50cbe2d0b664341b92d23c85b651e1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTKGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2249,'82d719cf3eacdf8600779666eb359115','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2250,'5acb71639a5ebd3bab4e370a77e7599b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGCGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2251,'ac82e2ab9e0f1c1d7973fab5400c5ddb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTCTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2252,'767ad551ed9cccc047d259ec4797b91d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2253,'267eccd75030d53e36d773edf3acea8b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAATAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2254,'08e95ce3e692040e07e2654bca8baced','CGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2255,'63739f92dc4274315ae0fb6d7fcd3d90','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2256,'ee391d6f31c5201a3f106a91d7bcd07a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2257,'debb87d9fc1c9754b0c90bf66023d9cf','CCACACCTAAAAAACCTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2258,'17b45783522eccb09593984b99b85c0b','ACCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2259,'4d7d6ab15ad04746cc1ed740cb6912f4','CACCTATAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2260,'24a58f5173b7be2e96d455edc45df0e9','CATCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2261,'c5e91553b2f6cc69bb5744a1273a22e7','CTAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2262,'4d3a08f39584cf5418edeb3577ddf788','CACCTAGAACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2263,'9c52603edcf12b2afea32a61a6c29fa0','TAGAACTTTCCACGTGTACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2264,'70ae5814e237b08f912068c8042a1b68','CACCTAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2265,'ad86e62242a9bbb45a65f74d062d3f63','CTATAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAATGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2266,'197fc4501b4e9ac600be72a6c3e9196d','CTCCTAAGAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2267,'757ba2468bb4e23c059c802c7ccf66aa','CCACACCTAAACAACTTTCCACGTGAACCGTATCAACAAGTAGTTGCGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2268,'3e873a1371d89a48ddec1eb97f29fbbb','CACCTAGAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2269,'25fb6ba29be04f1a549b957591037b6b','CACCTAACAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2270,'e079e8b6ed575b8b7b1127f1e57b03e0','ACCTAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2271,'5808980fd1adafd38077f56585a6d7c9','AGAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2272,'4a0bf43a2d66375ccbaab5af27580359','AAAACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2273,'e0741c540e4ba3edc259bd0c0025689d','AAACTTTCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTTAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2274,'efcf23c60c9d48f35b906265ac1c3537','ACCTAAAACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2275,'daec0e96cd2ed40f0efbb7bb25f80395','ACCTAAAACTTTCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2276,'0108195fa7637520c34831e0215e681b','CACCTAGAACTTTCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2277,'289eabe7303564a400445fda7f6ef186','ACAACTTTCCCGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTAAAGACGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2278,'2b6ba2053a05e7b9a899730151ca9918','ACTTTCCCGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTAAAGACGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2279,'17fdc988c98fea4f33c96446fd5d6ced','ACCTAGGACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2280,'31eb02f47150ef784105f13f54e506ff','CACCTAGAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2281,'ce0210b5e9de5754473cfedf2493b75c','TACTTTCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2282,'8d2de479c8a806c823edb2afbf777060','CCCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2283,'f2590151471ecc6a1d2ba52d584ab552','ACAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2284,'f056abbb146dcbe414cf584cd097120a','CTAGAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2285,'1a402bf5c600d368b6079e1ec03c5df7','CCTAGAACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAATTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2286,'e539086912f3de57a449ba62021b9fb9','AGAACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2287,'b3329fa3552fe0bd29b9ecb18c28351e','CCTAGAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2288,'239ebad37cc2f6e502745b35a8aa341a','CACCCTAGAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2289,'692bd7dc366fba14f2c5cc93486dccea','CACCCTAGAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2290,'22036c1d0b3138d4dc21a743b22aa8ec','CACCTAAGACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2291,'c8e6061fcf8d32ac342a0bf7f10e326f','CGTGCACCGTGATGCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2292,'b9a3bd3203374711a22bc47c8b5c8229','ACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2293,'04c55ffdeda347a195edbf4b46f51770','ATTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2294,'41e361f3ca6aa4d7b1db3b7b1cab3014','CACCTAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2295,'e916c94de23b3eefa07d00181a4289f1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2296,'5de6beee33fedd68b08f3d70b6ef3dad','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCATGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2297,'b878a3fbe3d2e2139f658350791ef55f','CACCTATAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2298,'0ac9ecd7466cbad9c08cfabb59004d62','ACCCTACAACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2299,'d96ddc695ac1abc79b43bf54fbb1c883','CTAAAAAACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2300,'e8e840ebf779b3b48d14472367dad423','CACCTAAAACTTTCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2301,'7a91abac085e3595e19aa2f9b31c3400','CACCTAAACTTTCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2302,'39c32784992f2ce535d35497576f5469','CCTAGAACTTTCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2303,'1a9e2b7ca86356a47e705c30a235f73b','AATAACTTTCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2304,'0a6c417daa56e68eb11fe0979016344f','AAAACTTTCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2305,'f7e493fe737776f295e6410bc74fea9c','CACCTACAACTTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2306,'4535466123a2b63e9f7c344219823b3b','CAACTTTCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2307,'376b2636fe2126a66a5bfd6fd555a68f','TTCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2308,'7bca1b8fac4b5777dd5cb98cc1fc7cba','CCTAAAACTTTCCCGTGCACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTAAAAACGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2309,'642406679e5b513ea15bf47de1a4222a','TCTAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2310,'f6c9e78826555554e069afa4920d5185','ACCCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2311,'0e311850a01129306b1493708731dbee','TTTCCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2312,'897224441c6a50210166ab4fb91b7087','CACCTACAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2313,'e5e22c35a6df2fafe0857036337ab2d6','ACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGGGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2314,'e3601bee2e904653f4ad4e1a57447715','TCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2315,'a68531c1d986301755e950f1f60a94cd','NAAAACCTTTCCGGTGACCGTCAACAGATTGGGGCCTCTGTGTGGGCAACTGTCAATTCAAATCGCGACTGGTTGTATGTGCGGTCTCATCAGGCGATTGGTTTGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2316,'7165b68c7e4671afaec8eea13cc882ba','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2317,'35c298045f4733dcc44d4087e1e74efe','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2318,'097ff8cb0d8722715738a30c924cf9eb','AAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2319,'ada6787ff0e6390a7dfc3a870557918e','CCACANCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2320,'70285a35776b39295dc6c8443ef2ea0f','CCCACCTAAAAACTTTCCCCGTGAACCGGTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2321,'ec9d79850db38b930e44d088c06d2e32','CACACTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2322,'216aba823c39acc79275dd99c0fa15b5','CCACCCCTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2323,'443903cb2be9cd15c469894f3f97659e','CCCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2324,'fdaa073eec168a8eca1cf45a9e774fa3','CCACACCTTAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2325,'932ed2bab562bbc1450b1a941b4ba947','CACACTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2326,'51119771ba95c5d253bf4bad113a7c9f','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2327,'b44fb80be02eb62f97597205cb9be4e2','CGTATCACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCNTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2328,'e91b2a1f5df7ec40d28c036040df489a','TGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2329,'4c865cd7d4686bf5c3370f28b75c4c09','CCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2330,'ec8da8f69131277181df783832e3a893','GTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2331,'366e94b5ebc005f8037cfbcdb9dc4cb9','ACCGTTTCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2332,'00e6f8afa9bd892168839a1b296b77c3','GCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2333,'da925f7c45ff98c1655a116edd93cabb','GGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2334,'360387037102500d0fabc163b6425a40','TGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2335,'eb98de4bcb86523a8c5c928f456a0284','GCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2336,'6956a292a03e7b5e109ef75da6b8e5a2','TGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2337,'d86bfd6a95bcb40287f1948288a636d0','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCANTTTTAAACNCMTTYMWTWAWATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2338,'169b257997c5c074634ccf712d0eef1d','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGYTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCANTTTTAAACNCMTTYMWTWAWATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2339,'f9054d503ab0adfa4f3a8e4eeffbd2ec','CCACACCTAAAAAANCTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGYTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTYTYANTTTTAAACNCMTTYMTTWAWATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2340,'711f0230787d3f5c609f2afe4e44f70e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTNTATTTGGGGGCTTGTTYGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGRGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2341,'613d03b8b26db54b9e3f94ff91fec84f','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGTTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2342,'2d4f4bbe8611738ced2768dc53b0d957','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAGTTGGGGGTCTTGCTTGGCGTGCGGCTGCTGGCCTTTATTGGTTGGCTGGCTGCGTGCTGGGCGAGCCCTATCATGGCGATCGTTTGGACCTCGGTCTGAGCTAGTAGCTTTTGTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2343,'42f019372cb1215d0b1e451362ce7881','NCNTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2344,'1601155554df9086a182683a34bba6f7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGYCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2345,'731b367171e46e3b402b3f3828c03817','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2346,'ecfeb7dd60677816fd1ca984fb8545e6','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGTCTTGCTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2347,'097c2a06951ee13e3ddb9511413cc9a0','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTMTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2348,'0d1a48b2e0d3bbc03fc64fd17472ad12','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2349,'b030ab22a02363ad368e30890cc61bdb','CTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2350,'60216e0b76ab40942c6df7cd047b3c48','CCACACCAAATTTCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2351,'aa2bd605fe5a4df2d6e933d7e405a122','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2352,'b9ebc59aab2af2e5d6a7aa3bd04e36d8','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2353,'3b7428e125c83a0ac6ed673d2840a9a4','AACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2354,'a54196b531f2684066681b3aeba478d0','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2355,'399240fa9a7284210af6a2ec829d4a90','TCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2356,'76d79b33d5ecb742b71b93c8b9c1e468','ACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2357,'0081ecc55820100d5405ca6c0d064dd7','CCCACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2358,'898f97ec764e00c7fdcd04b3988258eb','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2359,'773a2717be53923fccc4f78044e45b57','AAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2360,'8b45176515016857364884ca2e198cdf','CTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2361,'b595e744b3b2a153cf6214ddec616c3c','TAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2362,'0ba9fc24f948788c9701b2ff27ae7d44','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2363,'5c18a418045fb63500d482548095d4b6','CNCNCCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2364,'2595f59e5ffe19d920ae9ead2a7770fd','ACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2365,'1859b451af8d2631c300093dfce08930','CTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2366,'b553b2bbb5337cd7232d4b035e05da2d','AAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2367,'8f780ad896e78db28e202da9741a77ee','TTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2368,'669117e2d4417ab6140d31d4c83f95e7','CGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCAAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2369,'433e13adbbf8383761b31a7840fa369f','CTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCAAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2370,'e4fff75fc0a4440990ceeab0bed9468a','AAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2371,'f639acf3d1f0c7231f3659ebdb837dcc','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGGGGGGGCTTCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCCACCAAAAAAAAGGCGAGCGTTTGGGCCCCGGCCTGAATTAGTAATCCTTTTTTCCTTTTAAACCCATCCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2372,'e9b77d26d08652c7f1b4e670721d5885','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCTAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2373,'07566a154e84f6455cc3b63a13090d5e','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2374,'c5fb7fd74a5f09b41956680442b4397a','CCACACCCAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2375,'7c96b1b4cd00003aaeb9078a779dfbcb','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2376,'1395598c671bbd6b0c3e2e935d81a44d','CCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2377,'df4efc9912103bc5d67a349cf2b3a4f4','CTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2378,'8dab4c601413fc19e2b921f131c3392b','CACCTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2379,'8d20119e2ae58fb5a9c25448ac8075f6','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTAAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2380,'42429230dbd6f03912a2a1bfb5e08dae','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAATAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2381,'9742db3a6e5abc05aa511cbaa43c7c5e','CCACACCTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2382,'5d06bd2c02bd8d9b339ddbc59e539a74','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2383,'59ad907d1708372894e3fe552a383705','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2384,'e94de8bd79c1314906f0873d1fee017e','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTGTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2385,'f4d13571d19a2d56e2910b28a0b6ea67','CCACACCTAAAAAACTTTCCCGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2386,'1fba5139a55c368d4324c334584350c2','AGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2387,'16678fca804c9d46424ddd6764e763e3','CCACACCTAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCATGATTTAGTAGTCTTTTTTCTTTAAACCCATTCGTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2388,'8ca7f625a99f79af40649922c1e1482f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCRGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2389,'985702a34b002c1278694301c5ecbfe8','GAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2390,'b2fc0ec005c59e45be46ac0f1c620e3f','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2391,'0dbc9ccba103c306cefa611af431fb42','CCACACCTAAAAACTTTCCACGTGAACCCGTTTCAACCCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGCTGGCGGCTGCTGCTTGAGTGAGCCCTATCAAAAAAAAGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2392,'9111d385767bf74d672dcee238ed5383','CCACACCTAAAAAACTTTCCACGTGAACCCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2393,'ac2c088f33a571ffea46213bb05872bb','CCACACCTAAAAAACTTTCCACGTGAACCCGTTTCAACCCAATAGTTGGGGGTTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGGGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2394,'a9192fbe1701f19b81c1c99ba47ac68c','CCACACCTAAAAAACTTTCCACGTGACCCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2395,'3561f11abde9d3e104234d3be38c85df','CCACACCTAAAAACTTTCCACGTGAACGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2396,'3dca71fdff44a65a3829a1df6164e33a','ACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2397,'f94503235d3d7c8c3efaa9d940533f42','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCSGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2398,'61c0b36da8526ac0eac667124db363d6','CCACACCTAAAAACTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2399,'2b3e7dc266cca652b2e64000e37357f6','CCACACCTAAAAAAACTTTCCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2400,'39967d0d983f6a3111d3aa228c1b9927','TTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2401,'81662df08435605d08b310c89f1c28b1','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2402,'5e6a7185731b4e36cdc383e1d0143ab2','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2403,'6fdbfac8f91ca2bb9a017d19eefc972f','GTGAACCTTGCGGATTTAACCAAGTAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2404,'e4865de58d4cb25e588988991a5bc814','CCACCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2405,'f1910d4cb01fc18d365e6baf14a762f8','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2406,'554dd1bd2ce3c99ffba3e0ea82680f23','CACACTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2407,'228ced95a1c99e65685ab92a08bc1771','CCACACCCAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2408,'d09c6288515ec97c3adee506bd3054dd','CCACACCCCTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2409,'320734fff9c82d490806365a8d6b23ef','CCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTTTTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2410,'03726aa8a190543bf37a001367417ead','CCACACATAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2411,'0e91027594c2c360c6442b45cac3d532','CCACACCTAAATAACTTTCCACGTGANCCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2412,'57ab3cf3154c4dea8bb5f32b384459c2','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCNTGATTTAGTAGTCTTTTTTTCTTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2413,'6328b8c4bab861e032a82c0cbc6a49e8','CCACACCTAAAAAACTTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2414,'0e94a111f47f69577b42f2f5bc88f6ef','CCACACCTAAAAACTTTCACGTGAACCGTTTCCACCCCATAGTTGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2415,'5ccab5006f7e868a392dee7c63911274','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCCATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTTGCTTAATTGGTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2416,'11eaa4fad534af991a1d06ec4ddc476d','CCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2417,'84b5ba987ef07d2a906efc18b4bf309f','CCACACCTTAAAAACTTTCTACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGGGAAAGTTTGGGCTTCGGCCTGATTTTTTAGTCTTTTTTTCTTTTTAACCCCTTCCTTATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2418,'78ef9e3a454797bf7d0a0ae49e915192','CACACTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2419,'de9cf5495a39a23f9ec4520afa09e8e6','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2420,'849fd13db757c2d308ec34f07efa7363','CCACACCTAAAAAACTTTCCACGTGTGACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2421,'6f66a26fa6333bc3fa488a3710a0241d','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTGGGCTTTCGGCCTGATTTAGTATTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2422,'43c1d7f42029e31a053f26da477498a4','CCACACCTAAAAAACTTTCCACGTGAACAGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2423,'b20caaa98c76889f03d3963daa066a83','CCACACATAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGGTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2424,'530b22c4857c164fdfa2950698110004','CCACACCTAAAACACTTTCCACGTGAACGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGGACGTTTGGGCTTCGGCCTGAATTAGTAATCCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2425,'17439baf24b16a49926791ae718ee97b','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTTCGGCCTGATTTAGTAGTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2426,'a38828e6d5413d23e95e6c89d9648c18','CCACACCTAAAAAACTTTCCACGTGACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2427,'ff7f844c0cbef071eff276f6070af1dd','CCACACCTAAAAAACTTTCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCCGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2428,'35ea85cfd50fa9361a614f1ca99e37d4','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGGAAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2429,'28658f9ff08ac3ac5ec4fce63087de68','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGACCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2430,'ce0426de10a12b6fed008549de181309','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGGAAACGTTGGGGTTTCGCCCGGATTTAGTATTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2431,'1d127f6fc03388e9d61502cfd160fc7f','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCCATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTATTAGTCTTTTTTTTTTTTTAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2432,'a811fe3f849a44a05ea8fbf8a440d8aa','CACCCTAAAAACTTTCCCGTGGACCGTTTCAACCCATAGTTGGGGGTCTTATTTGGCCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2433,'6fe0cf6320fc71b24d744763cc03b677','CCCGTAAAAAACTTTCCACGTACCCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGGGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2434,'e3d3d60c03eecc3bd17a07a34d99993f','CACACTAAAAAACTTCCCACGTGACCCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2435,'362415c5b5f246bdbafef62e10e534d0','CCACACCTAAAAAACTTTACACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAGAAAGGCAAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2436,'789b0bcf9cafc87e039b92eb90343c4c','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2437,'c73af4484511fa9a38b962563fe24166','CCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2438,'96cb88e260f097c0b8bf613a6e400115','CACACTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2439,'8daacc2284f3b7024b94f0db1489b84e','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGGAAACGTTTGGGCTTCGGCCTGATTTANTANTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2440,'44a5e664b2ac8ea06dbc37195e87ba68','CCACACCCAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCACTCCTTAATACTGAATATCC');
INSERT INTO its1_sequence VALUES(2441,'c365e48e2ff849d5e8617fa9145050f1','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2442,'0e6d32acb81601d0f2b0bd2f1066f9c9','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGATGGCTTAATTGTTGGCGGCGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2443,'ce8931c3efe7e0c87f7f064c851f96d5','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2444,'b099d6365f8bb01e926a170687bf7d51','ACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2445,'9cf40123df2efde696eb21357b6d79b0','TTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTCTTTTAAACCCMTTCCYTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2446,'c035599be1bcd46f988b26804e56708b','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGRACSTTTGGGSTTCGGCCTGAWTTAGTAGTYTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2447,'b389b001e883b2dbde09877aee8673a0','AAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2448,'8a43666a75b87a812b5fa4f0d88fcdd0','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCCGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2449,'ad4b1c2b574146f7f430dabd66c0f286','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2450,'6ae71f1a14726de6453c646804ce3363','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGTGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2451,'54cd40437b7725b02f49793885266d64','CCACACCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2452,'09d950011bb24362aaa9918fbaabd4df','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCCGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2453,'27e1307dc9b8e58f7f828eec7ff17627','CCACACCTAAAAAACTTTCCCCGTGAACCGTTTCAACCCAATAGTTCGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2454,'73944fd489e67b7a37a078bb952df333','CCACACCTAAAAAACTTTCCACGTGAACGCGTTTCAACCCAATAGTTCGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2455,'93ed378d4d58e8086555a6de7380239d','CCACACCTAAAAAACTCTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2456,'0cf4864f60c53c48701308627b0bed35','CACCTAAAAAACCTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGGTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2457,'14a2015c5b6bd06554e392eaa4c51252','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTTGGGGGTCTTATTTGGCGGGCGGCTGCTGGCTTAAATTGTGGGCGGCTGCTGTTGAGTTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2458,'269e9a66c62b635b1852da5c80e8867b','CCACACCTAAGAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGGGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2459,'2fff5e8a3e489279f2b7fc02542cba9f','CCACACCTAAAAAACTTTCCACGCGAGACGTTTCAACCCAATAGATGGGGGTCTTATTTGGCGGCGGGCTGCTGGCTTAATTGTTGGCGGGTGCTGCTGAGAGAGACCTATCAAAAAAAAAGGGGAACCGTTGGGGTTTGGCCCGAATTTACTATTTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2460,'7f9efdcb7557d6e6850a3897e5f8b757','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCCAATAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2461,'64dd9cbf8979f3974e3afa08a5e1ab60','CCACACCTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTATTAGTCTTTTTTTCTTTTAAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2462,'1fb59c225e3ce822c3e45f545d4a615c','CACACTAAAAACTTCCACGTGAACCGTCTCATCCAATAGTTGGGGTGTCATATTGGGCGGCGGCTGCTGGCATAATTGTTCGCGGCTGCTGCTGAGAGAGCCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2463,'db56e4b78fe8e027690d092983c83b74','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTCAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2464,'6c7bdfd00782189c920776b38c3ec9c1','TAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2465,'edfce1c8940695afd742008daaf1a93f','GGGCGGCGGCTGGCTGGCTTTATTGGTGGCGGCTGCTGCTGGAATCAGCTCCTAACAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2466,'4f4e0fe521f050a5aa094e1e07fc0a3c','CCACACTCATAAAACTCTCCACGTGAGAAGTGTCACACCCTAGTGGGGGGTCTCATTTGGCGGGGGGTGTGGGCTTATTTGTGGGCGCCTGTGGTGGAGTGAGCCCTCTCTCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2467,'2a9343607219eedb4ba726da3e4dce16','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCTAATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2468,'8f46d7f20b681cb8495f5d237232d3a7','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGCCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGGGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2469,'045be2cafce7115630a5e878c2a72687','CCACACTTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGTTCTTATTGGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2470,'c94a004bb5c0a3183963082758780958','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTAATTGGCGGCGGTTGTTGGCTTAATTGTTGGCGGTTGTTGTTGAATAAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2471,'569f172dbdb44bada7a2b2fda47bbb7e','GTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCAAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2472,'d49b56adfbe2bd04a42351daf8bbe284','CCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2473,'8dc7bdc238a2d74678c8634565353372','CCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTATTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2474,'afe10ebe5b8d9bdbeb23aa393702de2f','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATTATTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2475,'7094ef9b943248b3376b5e9049f2995a','TAAAAAACTTTCCCGTGACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2476,'73a355ce6ed000c134cdee0b11f7fca2','CCACAACTAAAAAACTTTCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2477,'c528a551350f167a3653a2799fad8a41','CCACACCTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2478,'1b216173a9714c350f5624ca82126b5d','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGCCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2479,'81b4668e5e5908baac6e67e63bca3eb8','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2480,'887745ad2004c2b2553c47382104c146','CCCACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2481,'8a9f7650e652862e2b886a81d62144c0','CCACACCTAAAAACCTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2482,'19ef9052387aa1380fe235b935408635','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGGGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2483,'90f49ba6fd1f59bbf644d54d5533c96d','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAATTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2484,'f225b77be919d4445cd29edc3854cf43','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2485,'4c77f923fbfe574b1be5ac6600e0701c','ACTTTCACGTGACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2486,'bbb5be674eccf10d533ebd2d847fa3ca','CACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2487,'6fc9c600c31f8469451ed152e06bba18','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2488,'a61890f8fbee0436763446c200bcc26c','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2489,'0d4a42e4a85bc81f88aec0cf0342fd51','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2490,'2ba36164a35d0dcd9473efc1523607a4','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2491,'6219de11b2c13de0488c4b0a085e4187','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2492,'22c56f10c5b032de506e7440ee2162a1','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2493,'88c1c5f68be2518d62e1322fabd0ddb7','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2494,'6896c8b531cc1e775a4388bb3a89099d','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2495,'772a1b9c7c08cfd9fbf52d49740fb283','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2496,'195a7b2c8ce7c17ddfca96ee3fdf66ef','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCTTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2497,'1b2c804542b2b78f3b749f18a8f49f0e','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCTTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2498,'0a097bb08f1c47dcc896de58c2aa021b','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2499,'a572442f80913497a1264fe040a63720','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2500,'026cbb51cbfd48c02c61abefdcd089b0','TATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2501,'71e4d66b53cb05bcd79d4bde3ed6cc25','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2502,'3b0f95e51201513a70b3db4f8b7d51f0','CCACTCATAAAAATCTTTACACGAGCACTGTCACAACACTATAGTGGGTGGTCTTATGTGGCGGCGGCTGGTGGCATAATTGGTGGCGGCTGCTGATGAGTGAGCCCTTATCAAAAAAAAGCGCAAACGTTGGGGTTTCCCCGAGATTATGTAGTCTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2503,'830f997fb2134b836d4fabadd96e3e3d','CCACTCATAAAAATCTTTACACGAGCACTGTCACAACACTATAGTGGGGTGTCTTATTTGGCGGCGTCTGCTGGCTTAATTGTGGGCGTCTGCTGGTGAGTGACCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2504,'e548d00399b378d9e0159e379094546d','CCCAAAAAAACTTTCCCCGTGAACCGTTTCAACCCCCAATTGGGGGGGTTTTTTTTGGGGGCGGGCGGCGGGTATAATTGTGGGGGGCTGTTGCTGAGTGACCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2505,'7dd031efd459c743103736244d85ac8c','CCCCCAAAAAACTTTCCCCCTGAACCCTTTTCACCCCAAAATTTGGGGGTTTTTTTTGGGGGGGGCGCCGGGTTTAATTTTTGGCGGCGGTTGCGGAGGAACCCCAACCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2506,'f9e4572c535dcb805d9672d1bbeed06e','CACACTCAATAAAACTTCACATGAACCGTTCAACCCATAGTTGGGGGTCTCATATGCGGCGGCGTGCTGGCGTTAATTGTTGGCGCGCTGCTGCTGAGTGTGCCCTATCTCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2507,'eae39e1beaa3fe4d2f3a2de69ab1c6e9','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTATTATTCTTTTTTCTTTTAAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2508,'21ce2b791c152b7f1e4e93b1fe03fb43','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGGGAACGTTTGGGCTTCGGCCTGATTTATTAGTCTTTTTTCTTTTAAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2509,'e0726a205fb61e0927c5b1d42706d13c','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCCGCCTGATTTAATAGTCTTTTTTTCTTTTAAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2510,'54167f8c005f597e4acb6a20cf819c9a','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGCCTTTTTTTCTTTTAACCCCTTTCCTTAAAACGGAATATACT');
INSERT INTO its1_sequence VALUES(2511,'6770b09353eec1f551431d24c2227c35','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2512,'c456fc656c6a61b6584890cfdcbfb26b','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGGGAACGTTTGGGCTTCCGCCTGATTTAATAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2513,'9a356032d704526ca398c21fc34e2f1d','CACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2514,'612ec8cc9a98ce300db0697b9395972f','CCACACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2515,'49c505375132066f206ea25dfa9adcdb','GCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGCTTTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2516,'5c610e25a9706ebfca97a08fc5314fe7','TCCACGTGAACCGTTCCAACCCAATCGTTGGGGGTCTTGGCGGCGGCCGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCAAACGTTGGGGCTTCGGCCTGATTTATTAGTCTTTTTTTCTTTTAAACCCATTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2517,'da24a943ce7cb1b684167f0a7ec5302c','ACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGGGAACGTTTGGGCTTCGGCCTGATTTAATAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2518,'88bbc43b83a121e2b21a85072e282f5e','GTGTACCGTATCAACCCCTAGTTGGGGGCCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAAAATACT');
INSERT INTO its1_sequence VALUES(2519,'d770c650438dadf4efb7b26e10c84036','CCACACCTAAAAACTTTTCCACGTGAACCGTTCCAACCCAATCGTTGGGGGTCTTCTTCGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2520,'7c73e2ba870f31537fa7a1f66e053f4c','CCACACCTAAAAACTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGGGAACGTTTGGGCTTCGGCCTGATTTAATAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2521,'949e88897871db0f427de9204e6c060a','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCCTCCGCCCGATTTAATAATCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2522,'fa40f7028847be20a07d863f21997556','TTGGGGGGCTTATTTGGCGGCGGCTGCTAACTTTTTTAGTTGCGGCTCCTGCTGAGTGAGCCCTATCATAAAAAAGGCGAAAGTTTGGGCTTCGGCCCGATTGAGTAGCCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2523,'6cc591200f26a25cd2045aef80538a10','CCACACCTAAAAAACTCTACATGTACAGCTTTTCAACCCTATAGGGGGGTGTTTTTTTGGGGCGGGGGTGCGGGTTTTATTGTTCGGCGGTGGTTGTGAGTGACCCCTCTCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2524,'dd4e9b0088ea0a38ba21dd1ae2b03289','CCACACCTAAAAACTTTCCACGTGCACCGTTTACACCCTATAGTGGGGTGTCTTATTGCGGCGGCGGGTGCGGGTTATAATTGTGGGCGGGTTGGTGGTGAGTGAGCCCCTCTCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2525,'29a2ea72a6729a9d0052d44f46ab2ac1','CACACCTAAAAACTTTACACGTACCCGTCTACACCTAGAGTGGGGTGTTTTATTGCGGCGGCGGGCTGCGGGCTTTTAGTGTGGGCGTGTGGTTCTGAGTGCGCCTCTAAAAAAAAAAAGGCGAACGTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2526,'5342f0909790e42c1932633c74d2bd50','CACACTAAAAACTTACACGTACCCGTTACACCTATAGTGGGGTGTCTTATTGCGGCCGCGGGTGCGGGTTATAATTGTGGGCGTGTGTTGCTGAGTGCGCCCCTAACAAAAAAAAAGGCGAACGTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2527,'adaca21673791d49d7e3501d346eef01','CCACACCTAAAAAACTTACAGGTAACTGTTTACAACCCTATTGTTGGGGTGTTTTTATTGCGCGGCGCGCGGCGGGTTTTAATTGTCGGCGGGTTGCTGCTGAGCGCCCCCTCTAAAAAAAAAAGGCGAACGTTTGGGCTTCCGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2528,'82b1af75748424b77b2080e339cd4475','CACACTAAAAACTTTACACGTGCCCTGTCTACACCTATAGTGGGGTGTTTTTATTGGGCGGCGGGTGCGGGCTTTAATTGTGGGCGGGTTGCTGTGAGAGAGCCCTCTCAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2529,'96b70dd6dc0bbc026aa0b05e2c7cfec8','CCACACCTAAAAAACTTTACACGTACACCGTTTCAACCCTATAGTGGGGTGTTTTTTTGGGGGGGGGGCGCGGGCTATATTGTTGGCGGGTGGTGGTGAGAGACCCCTCTCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2530,'5c2cd7255084e9284ad83d56e67b760c','CACACTAAAAACTTTACACGTGCCCGTCTACAACCTATAGTGGGGTGTCTTATTGCGGCGGCGGGCTGCGGGCTTTATTGTGGGCGGGTTGTTGCAGAGAGAGCCCCCAAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2531,'1fed338bce7c340f74a0af7d24e29837','CCACACCTAAAAAACTTTACACGTGCACCGTTTCCACCCCATAGTGGGGTGTTTTTTGGGGGGGGCGGGCGGGGGTTTAATTGTGGGCGGGTGGTTGTGAGTGACCCCTCACAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2532,'73eb19d41a6fa33cdae25bb6954c84af','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATAC');
INSERT INTO its1_sequence VALUES(2533,'f42ed472195751e146de18263c4fd004','CCCACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2534,'4a7125d8e70cbb345a13256c49d0a8a2','AAAAAACTTTCNCGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2535,'dbc5858c8db31500023215d58219ab19','AAAAACTTTCACGTGACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAANGGCAACGTTTGGGCTTCCGCCNGNTTTAATAANCCTTTTTTTTTTTNAACCCCNTCCCTAAAACNGAAAATAC');
INSERT INTO its1_sequence VALUES(2536,'440d22fb94c59c5c52f1ae00423bf914','TTTCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGNNAACGTTTGGGCTTCCGCCNGATTTAATAATCTTTTTTTNTTTTAAACCCCTTCCTTAAAACTGAAAATACT');
INSERT INTO its1_sequence VALUES(2537,'9095bb1309a70d7b4d90a69717878bbf','AAAAACTTTCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGNGAAAGTTTGGGCTTCTNCCNGANTTNTNANNCTTTTTTTNTTTTTNACCCCTTCCTNANTACTNAATANA');
INSERT INTO its1_sequence VALUES(2538,'dc1066c41302efdcb13c8bb2ffd0d61e','AAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTATTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2539,'6c6e2ee581d42b29cc9e9bdefde08e9c','TTCCCCCGTGAACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2540,'2df380c8f312624b1d2f998388246dfa','CACCCAAAAAAACTTTCCCCTGGACCCGTTTCAACCCAAAAGTTGGGGGTTTTTTTTGGGGGGGGGGGCGGGTTTAATTTTTGGGGGCGGTGGTGGAGGGGCCCCATTCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2541,'69e980f5dd978762052c439f19dd6182','CCCAAAAAAACTTTCCCCGTGAACTTTTCACCCCAATAGTGGGGGGTTTTTTTTGGGGGCGGCTGGGGGTTTAATTTTTGGGGGGGGGGGGGGAGGGACCCCTTTAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2542,'b31eec8ae8cedb7aef657057251f095d','CCCACCTAAAAAACTTTCCCCGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGGGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGACCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2543,'4de59cef4ee72a9fb698e6200dbe28c1','CCCACCTAAAAAACTTTCCACGTAAACCTTTTCAACCCCAAGTTGGGGGGTTTTATTTGGGGGCGGGCTGGGGGTTTAATTGTGGGGGGCTGCTGAGGAGGGGCCCCTTAAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2544,'08e6bda5d3716fa35167dcd15494f1af','CCACACCTAAAAAACTTTCCACGTGGACCGTTTCAACCCCATAGTTGGGGGTTTTATTTGGGGGGGGGTGGTGGCTTAATTTTTGGCGGGTGCTGCTGAGTGAACCCCATCAAAAAAAAGGCGAAAGTTTGGGCTTCCGCCTAATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2545,'c043c7892c04b6dfe9a027e459f0c89b','CCCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTTTTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGACCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2546,'dadeea40d32729148bcaf409a650145b','CCCAAAAAAACTTTCCCCGTGAACCCGTTTCAACCCAAAAGTTGGGGGTTTTTTTTGGGGGGGGCGGCGGGTTTAATTTTTGGCGGCGGTTGCGGAGGGACCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2547,'8d63f496fa945ef8a0455fc6e5760ca3','ATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2548,'07b7e16c75eb386da70da1cc626a90a3','CCNCACCTAAANCTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2549,'f903b33bf3bd81192949e9eb49ff201a','CCNCACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2550,'00d4da0b9d34c679e257945487e46471','ACCGTTTCAACACAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2551,'b4ae9c268e6b111d886a9d88b2cd1753','GAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2552,'bcf46e53518debfcbb7b11ce31bd518d','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTATTATTCTTTTTTTCTTTTAAACCCATTCCTTAAAACTGAAAATAC');
INSERT INTO its1_sequence VALUES(2553,'2b58c32b4b1c9ebc3bdb9686f73fd2db','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAAGGGAAACGTTTGGGCTCCGCCCGGATTTATAATCCTTTTTTTTTTTTAAACCCTTTCCTTAAAACTGAAAATACT');
INSERT INTO its1_sequence VALUES(2554,'67045f28435c3fd7d4e90ee8785947fa','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAATTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAACCCTATCAAAAAAAAAGGGAAAATTTTGGGCTCCGCCCGGTTTTATAATCCTTTTTTTTTTTTAAACCCCTTCCTTATAATGGAAAATAC');
INSERT INTO its1_sequence VALUES(2555,'7aa90e17632ac8ee54499bfb4153a18f','CCACACCTAAAAACTTTCCACGTGAACCGTTTCCACCCAATAATTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAATGAACCCCATCAAAAAAAAAGGGAAAATTTGGGCCTCCGCCCGATTTTTTAATCTTTTTTTTTTTTTAACCCCTTCCTTAATAATGAAAA');
INSERT INTO its1_sequence VALUES(2556,'805c154bcb2f39ab328f38e1e22ef5d4','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAAGGGAAAATTTGGGGCTCCGCCCGGTTTTATAATCCTTTTTTTCTTTTAAACCCTTTCCTTAAAACGGAAAATAC');
INSERT INTO its1_sequence VALUES(2557,'703bbd86e1cb9ec7eef43979f2cf09ae','CCACACCTAAAAACCTTCCCCTGAACCCGTTCCACCCCATAATTGGGGGTCCTAATTGGCCGCCGCCGGCGGCTTAATTGGTGGCCGCCGCCGGCGAATGGACCCCAACCAAAAAAAAAGGGAAAATTTGGGCTCCTCCCCGATTTTTTATTCTTTTTTTTTTTTTAACCCCTTCCCTTAAACAGAAAATAC');
INSERT INTO its1_sequence VALUES(2558,'f748592c2987a7004fbdb19afa95438c','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAAGGGAAACGTTTGGGCTTCGGCCCGATTTATAATCCTTTTTTTTTTTTAAACCCCTTCCTTAAAACGGAAAAAA');
INSERT INTO its1_sequence VALUES(2559,'f4ebffbaa48811a74bd766ccf9fd0473','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAATGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTATTATTCTTTTTTTCTTTTAAACCCCTTCCTTAAAACTGAAAATAC');
INSERT INTO its1_sequence VALUES(2560,'96971fcef3b9086eeeb3fdd9fa562a29','CCACACCTAAAAAACTTTCCCCGTGAACCGTTTCAACCCAATATTTGGGGGCCTTATTTGCCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCGGCTGACTGAGCCCTTTCAAAAAAAAGCCCAACGTTTGGGCTTCGGCCTAATTTAGTATTCTTTTTTTCCTCTAAACCCATTCCTTAATACT');
INSERT INTO its1_sequence VALUES(2561,'72f5316df7c3351ff1812cb3c44c3f1d','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGRCTTAATTGYTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2562,'9dfd28599feed13106f10164fd008002','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGRCTTAATTGYTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2563,'2df0eb287f0d756c53e19f02bd56f9b8','TAATTGTTGGCGGCTGCTGATGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTTCGGCCTGATTTAGTAGTCTTTTTTTTTTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2564,'3224ff0da07bcec534443bca8da783ea','CCACACCTCAAAAACTTCTCACGTGAACCGTTTCAACCCAATAGTTGGGGGTATTATTTGGCGGCGGCTGCTGGTGTAATAGTTGTCGGCTGCTGCTGAGTAATCCCTATCAAAAAAAAAGGCGAACGTTTGGGGCTTCGGCCTGATTTAGTTAGTTTTTTTTTCTTTTACAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2565,'791600f7a1c6655ca7e4733e0a99cc63','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTTTTATTCGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2566,'dbc7a4053a55b5c44425318666e54573','CCACCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2567,'787e9259d909e5859e28ea566f125493','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2568,'a396453a50116f1202cfb296d0f05cd6','TGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2569,'9f0590c7d029562fad13afe9f65563ac','TGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGRTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2570,'e74c909c6173e4fcef062d6c5966cfed','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2571,'720f975192ef70e5d67d30589e8362f6','CCACACCTAAAAAACTTTCCACGTGAACCGTCTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2572,'89d873041e0b595f35cc1a2667f0bdd8','AAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2573,'f8d5c9dd7d648fcc3f967cbdbfbfdace','TAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2574,'8b1cab45c426cee9c565d7ffaa980b3c','CTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2575,'1bbf8f80c12b8e90f9996380fb8d1009','CACATAAAAAACTTTCACACGTGAACCGTTTCAACGCAATAGTGTGGGGGTCTTATTTGGCGGCTGCTGCTGGCCTTAATTGTTGGCGGCTGATGCTGAGTGAGCCCCTATCAAAAAAAAGGCTGACCGTTTGGGGCTTTCGGCCCGATGTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTTATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2576,'f4a37074d75cdd276a7f9fecfba3f4d2','CACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCCTATCAAAAAAAAGGCGAACCGTTTGGGCTTTCGGCCTGATCTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2577,'857c5ebf353d4e1397b16dc963dbe237','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTATTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGACTATACT');
INSERT INTO its1_sequence VALUES(2578,'bbbd0b7620f211299394cfe6ff1e3a09','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCCGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2579,'5a2d9705ce3e0e2b758a194523cfa700','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2580,'a3365f2f6b3b8394242ab6be4861e6d9','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTGGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2581,'8aaf2350870e73b23a7cc928c08234c2','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGACTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2582,'57206f251401d43daec161bf791ee84c','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2583,'0fa52bc5d780a3a656213f3ba58f4309','CCACGCCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2584,'b353c20fc22396237a39adbdcfdd5a4f','CCACACCTAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2585,'2e87c2a8dd8b94c23c07cf4eb6ab691f','CCACACCTAAAAAACTTTCCACGTGAACCCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2586,'bfb44c39d647db8d5758db834f079567','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2587,'903c060f903b7cb64327e9b456fcc960','TGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2588,'2202b36bfec301adf8c7cd8098dc9e4f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAATTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2589,'589413672a2d0a890fca65c314041bf7','CTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2590,'58b81dfc69059b52a7e855e7c3d0d9ae','CTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2591,'4a728764a8b709536a3cc722a5a4c132','TTTCMCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2592,'ba54daeb56b72db517cb3aa241071f79','TTTCACGTGACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2593,'f227e533522ed166b99f5c2728ed69d3','CTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAACACTGAATATACT');
INSERT INTO its1_sequence VALUES(2594,'5b050da8787e58be47b2673683067bcb','CTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2595,'69ee97b51cedeab32cd7c03b2f975305','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTACTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2596,'3b8a19293025d471dc95c44fa6db008b','TTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2597,'b60571de034f1ba4b853a4898d2c257b','CCACACCTAAAAAAACTTTCCACGTGACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2598,'d1d689eec1dcb43b26afd70cbc12d71d','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2599,'307fa1706752d7a218d372e77b30c4c1','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2600,'37299aa7753d62d46cf5c11f02494511','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCACTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2601,'8a2fa7ae9d1842f58ed2ff60645655ea','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACTTATTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2602,'6fa3c0e98f357b2202a89cace311b2b7','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGCGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2603,'e6d0d0f6db399afb44cd88fada05f7e9','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2604,'b706f60043b744d2ef06b712125adff1','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTATCGGTCGCGCGGCTGCTGCGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTAGGCTTCGGTCTGAACTAGTAGCGTTTTTTAAACCCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2605,'aef779144835651bf0370b7cf0a9a739','CCACACCTAAAAACTTTCCCCGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2606,'b1ed8bcf19f3c4c8babd745f7a874ee4','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGCAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2607,'8f118926793ee108427d561b16a9d74e','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2608,'fa32e7f9f9ceea89ce61d2812d7ebccc','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2609,'09a1d364322bc9fab1e708901b33ec4f','CCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2610,'10029c6ea141879b77923e034a99aca6','CCACACCTCAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2611,'f9058b6572bd7a2839fd45516bd9769d','CCACACCTAAAACTTTCCACGTGAACCGTATCAAACTTAGTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2612,'c94a078014581474e0b3bbb453434a8a','CCACACCTAAAAATTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2613,'f5f5620f0a551a4c119319c850b2a8a0','CCACACCTAAAAACTTTCCACGTCAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATA');
INSERT INTO its1_sequence VALUES(2614,'b37f92e2d7a5351b008a6d17e038f178','CCACACCTAAAAACCTTTCCACGTGACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2615,'1e1792fb4274aa4e59d16360eae57fff','CCACACCTAAAACCTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2616,'1bc28b2cf502b714fe7be49148300f8d','CACCCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2617,'d1869ace5b5a698f200f56ab2fe68d1b','CCACACCTAAAAACTTTCCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2618,'b5a29d672d6f4097bd01d739c69de8de','CCTAAAAATAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2619,'0e879a69f0ed9a15e19a2deec118befc','CCCTAAAAACTTTTCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2620,'8669c924acd2200f69d51e2017e03640','CCACACCTAAAAACTTTCCCCGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2621,'c79fbd73657973d142f5f522b8598c2c','CCACACTTAGAAACTATCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2622,'76c0785fbc62ba96413f54c65d1a2e8b','TGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2623,'b9d4d04d02f513b518160731803f3c54','CTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAAGTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2624,'e1abb295e18c9e468441f460546e115c','ATGCTGGCGGCTGCTGGTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAAGTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2625,'1781f604594653d561b7c4fc31fc0748','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2626,'c60d3d769c1f6944f43a6af1498b95db','CACACTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2627,'b28f81a68cc7cd8b2152ced6f3746224','ACACACTAAAACCTTTCCACGTGACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCCGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2628,'88ece736b7e14b91a28832746fd5c4f0','CCACACCTAAACTTTCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2629,'794f33c3c5effab6e1d468bba0b45882','CACACTAAAACTTTCCACGTGACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2630,'80a9a4effb70878215388372a9f6b9f6','CCACACCTATAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2631,'43f4d8f0bc4589005bb0002e515616e0','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2632,'eb4d435b378fa139f3ac87056a4be994','CCCCTAAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCCCTTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2633,'589049b0bbaca56b4491bd7fc82699c4','CACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2634,'0ff44120badf00a98dcb143af07f149b','CCACACCTAAAAACTTCCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2635,'25ecf81703ad93278214652c6cc050a8','AAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCKTYATTGCTGRCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2636,'42e2c3556466094096e02c9390c1d1cb','ACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2637,'b2a0ac2c5093a7046b4bc58a3a4acc33','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGAAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2638,'a59867cbc5310c4ac8ded37b9b1a9471','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2639,'02deb48d96011935f51e4f5c66f95bac','CACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2640,'f2eaa84855e9be59a41f845f76e8b003','TGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2641,'55c1bca9b9c2da5dc14a2fc6028c353d','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTTTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2642,'d2b8d6f440bd5af57b47ca2389f656ce','CGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2643,'7201110e7920b2a6ef52eb0397518dd0','ACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2644,'9a61700d95450d709659c49f31db657b','TGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2645,'7cd75af17789fc9e1f97ddb3f1264c04','GTATCAAACTTATTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2646,'e7e76628957757190c6d9b5b0c585915','GGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2647,'01d30f3c06eb375080f4aefafa4614c6','ACTTTCACGTGACCGTATCAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2648,'00cf471cb334bd75452274888b117a6e','TTTCACGTGACCGTATCAAACTTATTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2649,'e99e92511e4339ebfe22666efe0fa7d4','CCACACCTAAAAACTTTCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTTTTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2650,'0f3057d97d158602baa1e1f4abf0f729','CCACACATAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2651,'c6eb4faad46126badc9d4e32c48fd9db','GTATCAAACTTATTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTACCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2652,'910012ab1581e09e07f2b2ecaf7a8d73','GTATCAACTTATTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2653,'3bd945a3ba4527cfbe35b5922c1cec26','CCACACGTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2654,'8ad433727dc042ed08da6cf55b397502','CGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTTGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2655,'1c83e6990a7cd64e89dde6fa2f57c81f','TTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2656,'6444d765e12282f1caea9b9fe35fcd22','AACCGTATCAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2657,'a32f565e66c6ca949d3886931d6e33f0','ACCGTATCAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2658,'d9d30e31644d7dd69098eed84b2e51c4','GTGAACCGTATCAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAAGCTCTATCATGGCGAAGCGTTTGGGCTTCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2659,'af5e4e5006194ada30bc44b024caeef7','ACCGTATCAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGGTTATACT');
INSERT INTO its1_sequence VALUES(2660,'433d15b7a6200891e605df713f48a383','CTTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGCCGGCTGCAGTTGGGGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATGATACT');
INSERT INTO its1_sequence VALUES(2661,'e0e423b8d46a32906be752381f30df5e','TCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGCCGGCTGCTGTTGGGGAGCTCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTAAAACCCATTCTTTATAACTGATGATACT');
INSERT INTO its1_sequence VALUES(2662,'cc564fe84337083ba900f2dc8424efdb','GAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGCGGGCTGCAGTTGGGGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATGATACT');
INSERT INTO its1_sequence VALUES(2663,'e3a6e4ee3dfd62a150e37c424cc65a35','ACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGCCGGCTGCTGTTGGGGAGCTCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTAAAACCCATTCTTTATAACTGATGATACT');
INSERT INTO its1_sequence VALUES(2664,'ec1e05acd0fb83629aeb1a6b1f0a76c0','AAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGCCGGCTGCTGTTGGGGAGCTCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTAAAACCCATTCTTTAAAACTGATGATACT');
INSERT INTO its1_sequence VALUES(2665,'c7238f3adb386fb965be056b7b747f9b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGCGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2666,'6dfa3064621c915fb0e3784a5c3257c5','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTGTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2667,'fd5adc5c42f3634769240bd1227f087e','CACACTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTTGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2668,'a2d39b276065918d5580ecbfd6f48592','TTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2669,'d63d6939d36173fbaab5415ca5d90530','TTAGTTGGGGGTCTCTTTCGGCGGCTGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2670,'0bc0f360f5f2069ac617b0f647befc97','CTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2671,'795234f3a594660e0747cccde64d14f3','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTTGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2672,'673713362cb548d8b3e604754ff1cfd4','GCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2673,'69faab8165fd60f30e1b247095ed9487','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2674,'24d4c8884594feaffdf5cd6b8f0fc2c3','CACACTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2675,'be2f51985c409f7326c810acc3dbc2c6','CTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2676,'09ce3cfb9a4afff069643699572383f0','AAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2677,'7df65fafd21b2e8083f8c71ce8152ba3','CCACACCTAAAAACTTTCCACGTGACCGTATCAAAACTTAGTTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2678,'cc0300019b60b9e8fc0ce3ce25a22ee5','CTTTCCCGTGAACCGTATCAAACTTATTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGTCGAACTATAGCTTTTTTAAACCCTTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2679,'fd2804478e7a0114a69c2fc4763c5273','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAATTAGTTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2680,'12bbbe1c63d6ea148f8bc2ccc829d7a9','CCGTATCAAAACTTAGTTGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2681,'d2afdf8c7848433b12536f1149184289','TATCAAAACTTAGTTGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2682,'434252654d0ce1b2d3f2aa914363127a','AAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2683,'c9b85cadabf14218286114796c686342','GTGAACCGTATCAAAACTTAGTTGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2684,'59ee192c43a31dbba9ab23f4623b085f','CCACACTTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2685,'02b606f97443797a7c9b4c5e0ce19d00','CGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2686,'a2d99c50e1fadedc76bbb73852120919','CTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2687,'9fa957c06cd4570f9223b87603f05a8c','GTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2688,'fbe3c88ce4820be5819c951d3c3e5fd1','CTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2689,'3106b486bdccdcab8ec091019aa4c7c9','TAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2690,'cce57dd54d7fb4ae48c5f9ea1f933cfe','TGACCGTATCAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2691,'9c83951ac0ee6f10073cb7a7b7a2473a','GTATCAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2692,'3bede0b1b5c56d22163b7eee48aa4fec','GGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2693,'90388aa2ce3ec52c88de7fbd3d887c8c','CCACACCTAAAACTTTTCCACGTGACCGTATCAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTGGGGCTTCGGTCTGACTAGTAGCTTTTTTAAACCCATTCTTTATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2694,'d136e382acdbfa13496ae17f643ec8fa','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCCCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2695,'261f72e6edf9257ae86afa770dd15658','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2696,'05319dec3b336019398e4202c67f84fe','ACCTAAAAAACTTTCCACGTGAACCGTATCTAAACTTATTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2697,'214bb9050883c32516a2c9b25b895513','CTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2698,'2268d21a30b4fce2370726d40b1d2b5c','GCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2699,'0eb9f2782cc8c18ed5463a9e065f2a03','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTNAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2700,'06ec94ebf522eedeeb950e714b3e1517','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTNTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2701,'0a8a9cd025bfada505f952a94b0ec41d','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTATAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2702,'ee8706e15dfd1ab4ed6210d5da5cd594','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAGCTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2703,'31f560536f0006d557cd178d76142d14','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTCCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2704,'aab02744fa8e5969a6ad2a66d7ad87b7','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGATTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2705,'36ca24801937e9cbdedccfc69763d04a','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGATTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGACTATACT');
INSERT INTO its1_sequence VALUES(2706,'8db0e3914f36ddd1f77112a156cc1480','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCGTTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2707,'923b4a38a4eae57e70181ccd7659a45c','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2708,'3c36124d7c73f3c447500bb3cf12f117','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTTTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2709,'91dbfa7f4701609bae20a4cb590958a1','TACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTTGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2710,'a4c8e9ad76a3f326f9cf4ac0da3a8dbb','TATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2711,'41c6de6af8ccd39da5cefe4c0b2f2c2f','GAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2712,'bfca3bea78649e45db6ff536c63c5c6d','GAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGGTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2713,'05a44fe71c08070813dedc24eb93b7d1','GAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2714,'3b6ce022db1a9537121eff43a9265cda','AAAACTTTCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2715,'4ccbc47cd8384a636b94e9939e8e7f18','AACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2716,'895b79eb4ba525dc94367f58c8b6432c','ACCGTTCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2717,'6868b132ea830f2442df0c8943b22426','AAAACTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2718,'ac7b7ea8a99cf33d83c40cb050897b34','ACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2719,'6907467adad6769e400bcc48281dc12a','CACACTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2720,'c3d9f90486d3ec4b46b58694aec54f72','AAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCATYATTGCTGRCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2721,'aa600939b3a4fe5b19f5908941a74e81','CACACCTAAAAACCTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCCGGCTTCAATGCTGGCCGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCCTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2722,'a90c1c55413ebe0834360c75fb3ecb37','CACACCTAAAAACCTTCCACGTGGACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCCATGCTGGCGGCTGCTGTTGGGAGAACTCTATCATGGCGAGCGGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCCTTCCTTATAACTGATTAT');
INSERT INTO its1_sequence VALUES(2723,'3a495355270ef32fc1177b69f079d312','CACACCTAAAAACCTTCCACGTGGACCGTATCAAAACTTAGTTGGGGGTCTCTTTTGGCGGCGGCTGCTGGCTTCCATGCTGGCCGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGGTTTGGGGTTCGGTCTGAACTAGTAGCTTTTTTAAACCCCTTTCTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2724,'63fa728c0fe76536f13eb593df99bd46','CACACCTAAAAACCTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGCTGGCTGGCTTCAATGCTTGCCGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2725,'a42d385f25a9f1b10d0642ad8a72a584','TGGGGGGTGCTTGGGTAGCCCGTTTGGGGACCCGTTTGTTTGGTGGGGCCTTAATGGGGGAGTGTTTGATTCGCGGTATGGTTGGGTTTGGGTGAACCAACGGTTTTTAAATATTT');
INSERT INTO its1_sequence VALUES(2726,'c8ab8ed9729ba8e145019f86039f2dc5','CTTTCACGTGACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2727,'630cb1a3a49b2e55c3cdf71f9cc59154','GTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2728,'74e82480f8ec993f5c06238f5af9212a','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCCGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2729,'1dddcbe8664c0347ca78026c4b5d23f7','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACCAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2730,'ee7245f120172d9472dfe43e83b544fd','CCACACCTAAAAACTTTCCACGTGAATCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2731,'928c9f15bb8825dd9d40476c57487aff','AAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2732,'e13c31375a95ba63f915650421a79738','TAAAAACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2733,'56dcc8e20face3feea9dd41354222bcc','CCACACCTAANACTTTCCACGTGAACCGTATCAAAACTTAGTTGGGGGTCTCTTTCGGCGGCGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGGAGAGCTCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(2734,'1fe25afa74dafdb6800d973ffed55a8e','TCAACCCAATAGTGGGGGTCTATTGGCGGCGGCTGCTGGCNTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2735,'ad2785d127babee4c15115901dc61077','ACACCTAAAAACTTTCACGTGTACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCCGCCTGATTTATTATTCTTTTTTTTTTTTTAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2736,'540cc6623aa735cf4c08c570fb8ed1b3','CCCACATAAAAAACTCTCCACGTGAACCGTTTCACCCCAATAGTGGGTGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGCCTTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2737,'fcc6a4f34b39f36041fd58129add6b63','TCGGGCGGGCGGCTGTGCTGTCATTAATTGGGTGGGCTGCTGCTGACTGAGTCCACGCCTCAACAAAAAAAAAGGCGGAACGTTTGGGCTTCGGCCCTGATTTAGTAGTCCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2738,'ac725c8d3578dc0784dc0a2029a43fd7','CCACACTTAAAAACTTTCCACGTGACCCGTTTCACCCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2739,'2cacbb102ec8ee3c6bb157b1ed2aa728','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTACGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2740,'0aafb1f53a7506291948b060445de7b3','CCACACCCAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2741,'b8f21db7e29be62ab67bfe761b20f2c4','CCACACCTAAAAACTTTCCCCTGAACCGTTTCACCCCATAATTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGGTGGCGGCTGCTGCTGAATGAACCCCATCAAAAAAAAAGGGAAAATTTGGGCTTCCGCCCGATTTTTTAATCTTTTTTTTTTTTTAACCCCTTCCTTAAAAATGAAAA');
INSERT INTO its1_sequence VALUES(2742,'a7aafe3924915b802bfc975aff05665b','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCCTTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2743,'1a7f4c97f242d25bf875ea35efb709b1','TTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2744,'945c80ee269ab8d3ff36e8df2af61790','GGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2745,'2a9784027283ce432c3b55b8decb215a','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGCGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2746,'1d7143a495e94d09b72d1ddfb32ed8a5','TTTCCACGTGAACCGTTTCAACCCAATAGTTGGGTGTCTTATTTGGCGGCGGCTGCTGACTTAATTGCTGGGGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2747,'26aeff7d37496476026add8ab0a0f772','AACTTTCCCGTGACCGTTTCACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCAAACGTTTGGGCTTCGGCCTGATTTATTATTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2748,'28b412dca148e4ce6aa90be145c141c3','CCACACCATGCAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2749,'225b80c0cf96d1a9c1f4c8bfcd650e9b','CGCACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCTTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACCCAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2750,'5e055207ad2e2111bcb91dc41ae67ef4','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGAGGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2751,'3af0957fe12698512b7ac3ba88408345','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCAAGGGTAGTAGTTACTTTTTGTAAACCCTCTACCACTTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2752,'b4e739f30392e73adedc5264a70438fc','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACACAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2753,'a3d6245be8a1cba37bfd7ba71be998a3','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCAACAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTCATCCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2754,'d64a41c3bb566f41b9a9337c91291c67','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACCTATACTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2755,'27627f638f9ca4a902d813e9c83acb34','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTMCTTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2756,'d474d670b580623566c5c8a98ae2dfa2','CCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTCAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2757,'025afb9966494ebe0b07eaeb70fbbc85','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2758,'b738c8d62d1e802c2d00a4016fe006fe','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCATTCCAATATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2759,'501f1a8864bda050f3694c3321ea0d5d','CCACACCTAAAAACTTTCCACGTGGACTGTCTGTGATGTTGGGGGCCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGAGTAGTAGTTACTTTTTGTAAACCCATTCCAATATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(2760,'e2dca2ebda07e16d4afa9de48e98ee73','CCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGYCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2761,'c0a19e2d9b367be1f7ea890d53a09c6c','TAAAAATCTTTCCACGTGAACCGTATCAACCCCCTTCGTTGGGGGCCTGCTCTGGGCGGCGGCTGCCGATGTCAAAGTCGGCGGCTGCTGCTGCGTGGCGGGCCCTATCACTGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCCTATTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2762,'2d948270e24642d4bfa20b9bec00badd','CCACACNTAANAAACTTNCCACGTGAAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2763,'3ca1a8af64000adc07735336e57cf1f9','CCACACCCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2764,'8a50ebd916f5caca50d788cfc3376140','CCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTTTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2765,'1e5b9fd312cdc97aaf29056e81c44fc3','CCACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2766,'aa412e75886bb7d1ce157c8fbe8e3053','CCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACYTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2767,'dab64a62451d7f98647f7a6d0378f443','CCACACCTAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2768,'bb38b8632c106cd625fc106b0c7089f9','CACCTAAAAAACTCTCTTTCACGTGAACCGTATCAACCCTTCTTAGTTTGGGGGTCTTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2769,'3cf0b1af36665d5cd346781ec6968c14','CTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2770,'c9c12df26a9b337ac7512954c1276959','AAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2771,'73a6cf900ffc8a86626bdc9cc91e75e4','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGTAGGCTCTATCGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATTAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2772,'5b019d1c6c8c96271f4d4f0834e4f57b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGTAGGCTCTATCGCTAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATTAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2773,'7cd7593826ecc381595248f0c9539c6d','TCACAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2774,'9de81ac755616a50bd443f4425e1c8ca','CTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2775,'5aeac1332eaf57eb4990ad58e72d4892','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGTCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAATCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2776,'5110ea86f538d2c3665f83d8391a7a7d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2777,'c632f0e969fbb2c02c469b81ed9f7784','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2778,'1498d318085688e51ff771f06b15afe2','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGTGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2779,'f222837176a54cb4cf834b17c22d0530','CCACACCTAAAAAACTTTCCACGTGAACCGCATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCCGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGCGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2780,'50991327d415984cf98e1d651d984897','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGGCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2781,'da34e7820d13abdc7f5565ba34ee72f8','CCACACCTAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2782,'77ba3646883bd3c348670b649df50110','ACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2783,'ab754c3da53f3d8fcc48814f078b88c3','CCACACCTAAAAACTTTTCATGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2784,'a290bb7ca42202e586ec437ed4355a88','AAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2785,'95f13946561d02651a120a46e65389dc','CACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2786,'76fd7d51d7535b9d951bfd6c2f241de0','ACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2787,'70d5f73fab101221a85782d9cddf1292','AAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2788,'f06fe8b636ceb86391cf943ac2f4f3d3','TTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2789,'c2bacc4f2540b5812c6ac492be5227d4','TTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2790,'20d38c0e7b132d2d19b4ed6521feba2f','CACACTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2791,'288162124a9a9f0653d68cffdc17feea','CCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2792,'69e4e4f54f783c9683a70cebe4b2f645','CCACACCTAAAAAAGTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2793,'5dd4e5df6131dbec41c4fb56c8546fd8','ACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2794,'ad8baca7489dbd1e6972c3c455b0c02d','GTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2795,'b01ab23fc61e3bbb295d1a9cbffd8dec','GTAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2796,'9db69a3c3faec50ecccd88b764a0bd11','ACACGTAAAAAACTTTTCCGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2797,'f30a04487c77cfc8da2306bcf17f5707','CACACCTAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2798,'4f6fab2da81d06551aa8255f4252d033','AACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2799,'053c1893fe73796e9dab0c9b4b9f1967','AACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2800,'3ad7a12e0d2febce1ebe6af9f3371797','CCACACCTAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2801,'2caa59c916e327c745944bb6fa4a9884','CTAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2802,'d3a5ab391764d0bf4885de6456f3fbdb','CGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2803,'d70071976be6e0cdec8f3f5579ff379d','CCNCACCTAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2804,'98cc6e6fcf0abcdd7e769f6f38040dfa','CCTAAANCTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2805,'20d21c999d8ef61bd9113590390f8a9c','AAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2806,'e9e9aaccf94b4b630e26e20522fdc4eb','CCACACCTAAAAAAACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2807,'5863157b088fbb04d7fc0f9de195f883','TTCACGTGACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2808,'1b9c17942ea3853b113e3505f0ee38cd','AACTTTTCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2809,'0be3d5f6fc055451fcb9296543dd4fdc','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCYGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAACTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2810,'f7c8da0ca494252a6ed2db874d1dbbcf','CCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAAATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAAATGATATAC');
INSERT INTO its1_sequence VALUES(2811,'618ddd58a31b8050d35d6c6e88005e14','CCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCCGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2812,'8082f163d22c10781351f03f690b5cd6','CACACTTAAAAACTGTCCACGTGACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2813,'1b5431eed59427d831c9a00129174fb3','GCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2814,'6b69abf1a0bc81d9eef5b0efd886b428','CCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCKTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTAYTGTTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2815,'6aa4dfc401c9645f276f4f32ca591e7d','TGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2816,'881f91c648c48806b306a56439d318be','ACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2817,'937ac5a33e1f896ac2c80d4f5e6070ee','TAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2818,'90677922354535c6fa3ccd3aa199b450','TCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCCCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTATTTTAAACCCTTTTACTGTTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2819,'c27d331378c28f41088424d3bb33378c','CCACACCTAAAAACTGTCCACGTGAACTGTACTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTCTTTTAAACCCTTTTACTATTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2820,'586e21248aac58896aab9f1abc9b660b','CCACACCTAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTCTTTTAAACCCTTTTACTATTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2821,'ab60e0cc664cc600b0e10f64b9203ddc','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2822,'8e00aa60a9ae4c8c3ade0e0ec54fa6ab','ACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2823,'d05ddc110572f11ce1a6cc4bd2728e13','TCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2824,'d74071dc4e56fe7cf7afded5e71cd47c','TTATTGSGGGCTGCTGACTGGACTGGCTTCSGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAKTAGCTTTCTTTTTAAACCATTCTTAATTWACTGAAATAC');
INSERT INTO its1_sequence VALUES(2825,'32c51d7e5146f29e6abfe2bf19f96734','CTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2826,'041a0bac7dbbfd619855d3dac1af19cb','CTGGCTTCGGCTGGACTGRGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2827,'de265ab5546620f5ddfb19d3437dc38f','CTGGCTTCGGCTGGACTGGGTGGCGGYTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2828,'cc7db561f1dd72290515aab196d35efc','ACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGRCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2829,'ced63634727dac5f150f98daa7423f87','ACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTCTTTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2830,'a7787b68be99326ed423bcd6e8d488ab','GACTGGCTTCGGYTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2831,'70faa0c2631bfe5ec81d39c32a705882','TTGGGGGCTGCTGACTGGACTGGCTTCKGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2832,'9de3e6d51ec148ae17c0f5ad6aa5bdf2','CTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2833,'4c7aed4f4530d379a50e26c85e1e13b4','TTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAKCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2834,'a8985489076a83e04af6b3d7fcf96d6d','CACCTAAAAAACTTCACGTGAACCGTATCAACCCTTTAATATTGGGGGCTGCTGACTGGACTGTCTTCGGCTGGACTGGGTGGCAGCTCTAGCGCGAGCCTTCTGGGCTTCGGCTTGGGGCTAGTAACTTTTTTTAAACCCATTCTTAATTACTGTAATAC');
INSERT INTO its1_sequence VALUES(2835,'2b10505e19446f879ed3350cf6f4a74a','CCACACCTAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGAGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2836,'a6b9993d3b7f5142aecccd1af386dc69','CCACACCTAAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2837,'98096682f34e1ade4df3aa2fcf0410a7','CCACACCTAAAAACTTTCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGRGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCCTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2838,'f46c0648f75ae2369f86970de1cca54e','CCACACCTAAAAACTTCCCCCGTGAACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTCTTTTTAAACCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2839,'715f4b0d0bb349c7f27dcbe6b74a93fd','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGAATGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(2840,'a888e80748382c5f37214ec520599987','ACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAKYTTTCTTTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2841,'1c1f83c69a87d70739ba27f4869f0a0b','CCACACCTAAAAACTTCCCCCGTGACCGTATCAACCCTTTTTTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGTGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTCTTTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(2842,'b5e4bfcd140a2b95060d7e497ba9c9a9','CACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2843,'b8be1d33d53f8833bc167d51e533e47b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTMTYTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2844,'dd8ccc8ba6eaf8f00c359b3c425557bd','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAWTTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2845,'6f01b6802b015e31cdce39a0cd0080ad','CCACACYTAAAAAACTYTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2846,'d771c5203db536fb4cdbe3cc07a6511f','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGAGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2847,'c9d0d9c60c9558c8d73a746f0ef4bc13','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTTTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2848,'4d6f5f433c4da4229311d8f593750bb0','CACACTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2849,'43445713b1dd32ecf992aacd1549888c','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGMTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2850,'a6a625e3080dc21fd531c4f9472aa48a','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGAGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2851,'102619991e8fcf8ae19de6843513d2aa','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2852,'f928c6d7046747a40ed79900a22ff04a','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCRAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2853,'48e89d0ea3549e9fa03f83618c7c0c0c','CACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2854,'533375c002f207009de3cb227e5a67fe','CCACACCTAAAAAACTTTCCACGTGAACCGTATCGAACAAGTAGTTGGGGGTCTTGCTGTGGCGTGCGGCTGCCGGCTTTATTGCTGGTGGCTGCTGCTGTGGCGAGCCCTATCATGGCGAGCGTTTGGACCTCGGTCTGAGCTAGTAGCTTTACTTTTAAACCCATTCCTAATAACTGAATATACT');
INSERT INTO its1_sequence VALUES(2855,'3e051d44f3aa0766a0408e5c71704766','CACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCATTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2856,'fe951e2a3b77bea283dc2ecac48641db','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTYTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2857,'7f72d404b4f3adc93f0867e6e9dbb215','CCACACCTAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTYGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCRAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2858,'93fb315190add23f97eb946d220c0aed','CTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2859,'d0c6fe5fec563446b14d0b8de8576223','CACCTAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTGTTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGNGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2860,'c4a6072993b2cfcad3d57fe8b49172df','CCACACCTAAAAACTTTCCACGTGACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTGTTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2861,'bb602192baa319a3a1da1085ef24ce22','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGGCTTTGTTGTTGGCGGCTGCTGCTGGGTGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2862,'c41f5c0b1c7d0a39546dc4c2e9c7af92','CCACACCTAAAAAACTTTCCACGTGAACTGTATCAACCAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGTTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2863,'2077e53488064fb87d85c5024f941a27','ACAACTAAAAAACTTTCCACGTGAACTGTATCAACCAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGTTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2864,'939acd42f1787372d3c23d0f35a5db50','CCACACCTAAAAAAACTTTCCACGTGACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGATGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2865,'152d1befafcb28fe98ca3fa38ff64838','CCACACCTAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGGATGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2866,'2253f5312c3fd8dca02c4bd5554d7433','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTATAAACCATTACTTTTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2867,'e231d5c40f37316529106133fccd4d7f','CCACACCTAAAAAAACTTTCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2868,'39fc539c5ff6f0f07081faea896a2aa9','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2869,'0b503f6e5c1c8eebeaff8e46b49c4d12','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2870,'af43987d5da204b05277a02ef27c27a9','AACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2871,'dba7c0adfad0f1ffd14d0719910ae014','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(2872,'48e3e224b5fe02f6c18e02eb668a3f63','CCACACCTAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCSYTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACYCWTTGCMTTWTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2873,'c62167798957cc33f7a795dc236681b4','AAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACTCATTGCATTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(2874,'8043cab74205f66843eba36ea37e0160','CCACACCTAAAACTTTTCCACGTGAACCGTATTTTGGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAACCATAC');
INSERT INTO its1_sequence VALUES(2875,'745364326f666e2c75e1b6dcaa737a16','CCACACCTAAAACTTTTCACGTGAACCGTATTTTTGACGTTGGGGACTCCTGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAACCATAC');
INSERT INTO its1_sequence VALUES(2876,'758dfe2193b0f1b3a678bff502ec4a78','CCACACCCCAAAACTTTTCCCGTGAACCGTATTTTTGACGTTGGGGACTCCKGGCTTCGGCCGGTTGAGACCTATCACGCGACCGCTCGGGCTGAAAAGTCGGGGCCAGTAGCCTTTTTTTAAACCCATTCCGAACTACTGAACCATAC');
INSERT INTO its1_sequence VALUES(2877,'ea55d33f6f6efca88e394034df7e40e4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAAYGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2878,'c364c809d629c4d700fcad142346c851','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGKCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2879,'5ed9593ef26f45bdd1a42b33586b6538','CACCTTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2880,'74443d67217bb47d87cf4c4db7c2657a','TTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2881,'661de3c41431f7271a5079a31b05d71f','CTTTCCACGTGAACCGTATCAACCCCTATAATTYGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2882,'00719c65ce2b15449c47f0660610dbee','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGYGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2883,'7fefda2b079d456c3de044e8f5c5bde8','CCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCTTGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2884,'ae085626d30f1b38e858b888d589ec14','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAACGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2885,'9af678f4ddf77bd4cc41330bb525b5b4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGRCGGCGTGCGTGCTGGCCTGTAAYGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2886,'78a0849db249f9f6b27bfe59895bcfb1','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTRGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2887,'76228a8ac7881874021131edf319c3e5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGTTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTCCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(2888,'3654753e36b96b0c38b63fbfc3699e73','CCACACCTTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2889,'a2e27254486cc32e420441891cb49584','ACTATCCACGTGCACCGTATCAACCCCTATAATTTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2890,'ddf64104c3481991c786219d1178ca1f','CCTAAAAAACTTTCCACGTGAACCGTATCATCCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGCCCTGTTAAGGATTTCCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2891,'870b465e2350140d66255c3316866ad0','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2892,'548733927a7bf26da3cf2a3c06362197','CCCACTTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2893,'9cff3204a8cf2fe386ef02cdaaca85bb','CTTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2894,'29dd2bffc3f785a22df353a75fb43caa','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGTTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2895,'e5cec969e95a35162c64b14de4eecfbf','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTTGGGAGCTTGTTTGGCGGCGTGTGTGTTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2896,'1316a6c46b310cb56410032e55611a2c','TCTGCTACGGCTTGGCGTGCTGCTGCTGGGCCACGGCCGGATGGCCGTTTCGTGCCGGCCTTCCGATCTAGGGAGTAGCTTTTCCTTTTAAACCCCTTCCTAGCTACTGACCCTAC');
INSERT INTO its1_sequence VALUES(2897,'a258fb656e6f9418c022ab7c57b2e990','CCACACCAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2898,'c37cc1403603ee080e43fc52b368cea9','GTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2899,'98019ad37b2d793e1a2d04ad3be20036','TGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2900,'171c562cbf27c3e094a1e649767c89ac','CCACACCTAATAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2901,'9c4f5b93653b8a6694a3ffb55363e3ea','TGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2902,'a05029061072d8f6d3e277362a6e4aa1','GCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2903,'86748d3203fb72d12e4998418fb2ebb3','CTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2904,'fc0470aa93e9b38d025dc457b75606a8','GTGGGGGCCTGTCTTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2905,'04b1a04991afefd5d1c267e66b87f182','CTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2906,'9112e17bb7e631004a1663eb3b28d02f','GGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2907,'a31a9f7021370f7a4126a4a0d8d40c03','AAGTTGGGGGCCTGTCTTGGCGGCTGGCTGTCGATGCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTTCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2908,'d6dff13f09ad08fb003698447157b9d7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTTCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2909,'6a290d1991224918539e1c65b6462cd8','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2910,'3ba443e54664f8e7ed1fa3fb2389cd0c','CACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGYCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2911,'2012f15c2b76ace43ece59f4180198ac','AAAACTTTCCCGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2912,'2f8a3811320b4c95ceb9dc517e29172f','CTAAAACTTTCCCGTGAACCGTATAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2913,'3ad937eb562b03fce963d4138a93cbeb','CTAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2914,'cd86ea87af1f52e4ca293362cd185627','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2915,'ab4b647c42a3dbf3fe6324d1b842a837','CACGTGAACCGTATCAACCTTCTTTAAATTCGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2916,'72c66884d77d6217121d4d19f9bbb1ca','CACCTAAAACTTTCCCGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2917,'99b5f8fbc837e082691d54535216eb90','CACCTAAAAACTTTCCCGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGTCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2918,'0dff71ed4658caa7c3ae891b75ead2d2','CCTAAAACTTTCACGTGAACCGTATCAACCTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2919,'4cba4fd0ad0e021f8f6ca9d952104097','CCACACCAAAAACTTTCCCGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2920,'c4b492e5c2147e619b4f6aee3a4f9027','CTTTCCACGTGAACCGTATCACCTTTTAAATTGTTGGCTTCCGTCTGGCCGGCCGGCTTTCGTTTTGCTGGGTGGCGGCTCTATCATGGCGACCGYTTGGGCCTCGGACTGGGTTAGTAGCTTCTCTTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2921,'c566f92bd0fe1a5c863eae1401206a41','TTCCCGTGAACCGTATCAGCCTTTTTAAATTAGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2922,'53ca617471ff2675e5f42c1d2bf4f1cd','TTTCACGTGAACCGTATCAACCTTTTTAAATTGTTGGCTTCCGTCTGGCCGGCCGGCTTTCGTTTGGCTGTGTGGCGGCTCTATCATGGCGACCGTTTGCGCCTCGGACTGGGTTATTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2923,'0a34974958c9374cf6b1bbae2a675b27','CCTAAAAAACTTTCCCGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2924,'393e3c21fe135d3fae1d5247dc825d2b','TTCCCGTGAACCGTATCAACCTTTTTAAATTGGGGCTTCCGTCTGGCCGGCCGGCTTTCGGTTGGCTGGGTGGCGGCTCTATCATGGCGACCCTTTGGGCCTCGGCCTGGGTTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2925,'531d841a31ada764e8e63b8dacbf8862','CTAAAACTTTCCCGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2926,'d1d9a96cda104da53f4de18c4d26a5fc','CCTAAAACTTTCCCGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2927,'60e8d8a20d4c26e387307903f89ed3f7','CACCTAAAAACTTTCCCGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2928,'7f12ffe0c66a93876d021f74f3614ddd','GTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTCTCTTTTAAACCCATTCCTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(2929,'501e4964bb17d547a58d1eb8c79e5179','GTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2930,'4766448bb373bbe6ec586fc92cdd8f70','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCCTGCTCTGGGCGGCTAGCTGTCGATGTCAAAGTCGACGGCTGGCTGCTGCGTGGCGGGCCCTATCACTGGCGATTGGTTTGGGTCCTTCTCGTGGGGAACTGGATCTATGAGCCCACCTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(2931,'50251d12ea6f01a6620b042b41dda006','CCACACTTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTGTTTTAAACCCATTTCACAATACTGATAATACT');
INSERT INTO its1_sequence VALUES(2932,'8fced3c09df9235f873de8f0f75340a3','CCACACCTAAGAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2933,'2d991e58934d1c7e664a3946067bcc96','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2934,'aebaf0391e18bbfa147291725d7b9d28','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTTGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2935,'4e6be20567e44fbf4fd0d733b670dbe6','CCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2936,'1d8e329103be8a29762c0d4c1e5b1495','CCACACCTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2937,'772fe6bc96613d0daa97f61a45832c34','TAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2938,'02a46d01ede7e58a6ad5c3df9742ad92','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGRTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2939,'64aea6fff042ba6f771c0ad3dc91ced1','CCACCCCTAAAAACTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2940,'26f5d13e2cd784b25581962fcdd57425','CACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2941,'82f10d119e7ca5dc4e652367abbe4fe2','CCACGCCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2942,'6b850a77a8153aeefd92a506cc6f8345','CCACACMTRAAAASWTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGAYGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2943,'4bba5302de44697454a860263a39f157','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGAGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2944,'3ac1d189f6bdef71f56e750523143750','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2945,'032b87d44326ccb0ff4d90422debf21f','TAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2946,'027ad62d85b2cdc902303733ea7db9d4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGATTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2947,'9d14a42221d980b62db8708ca9f5391a','GTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTNTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2948,'47e7d2f8aed062a47164dea92ef36d99','AACCGTATAACAAGTAGTGGAGGCCTGCTCTGTGTGACTGTCTGTCGAAGWCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGTATTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTATACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2949,'733c172cee5bfe6e3cadeae2d85f08a9','AACCGTATCAACAAGTATCTGCGTGCCTGCTCTGTGTGCATGTCTGTCGATGTCAAAGTCGGCGGCTGCCTGCTGTGTGGCGGGCGTCTATCATGGCGATTGGTTTGGCGCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2950,'a8d4c99e83aa37a9805d7726a9f29c22','CTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGAGGCCTGCTCTGTGTGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGAGCGCTCTATCATGGAGATGGTATTGGCTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2951,'81d5137ebb99ad3f5a6a97c6944c98e3','TAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2952,'c0897d0e81a564989a6fd3107e8c83f0','CCACACCTAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2953,'c2e35943127f2216ffb6b34289578e4d','CTAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2954,'51c38f761a4399f61e9df03b4b63b100','TGGGGGCTCTCTGGTGCTGTCTTCGAGTCAAATCGGCGGCTGCTGCTGTGGGCGGGCTCTATCATGGCGATGGTTTGGGTCCTCCTCGTGGGGGAACTGGATCATGAGCCCMCTTTCYAAGWCYCWTTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2955,'1511db5b52f2239c78aad8831f9e4800','CTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGTTCTATCATGCAGATTGGTTTGGGTCCTCCWCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2956,'a6c92c59bd9da033ee68e6cb25193c8a','CTAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTTGGTCTCCTCCTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCACTCCTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2957,'a9cb3626912483ad2b492e91e06b7350','CACCTAAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGATTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2958,'76ef3334c5dbdb3a99b899c8cefcbd7a','AAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2959,'341f4959d2e6b61a76b866bec36e34fd','CCTAAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGCTGCTTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2960,'6a444394967abd7dc9b23f4cadfc3fe9','CCTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2961,'fb42ab5e72df4dc5579646378963791a','CACCTAAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2962,'ea45339377cca09919d6ba666751ef03','CTAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2963,'b664e19a822812024b14fbc86e65637f','ACCCTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2964,'4b4f26ba4ba98c12ed609768179dc709','CACCTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2965,'b5b1fe5d8db5cf0230fcf2f1c4aa074c','CTAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2966,'48af372fa38be2d2d58fca8d595706b8','CACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2967,'b62f7592c89d7412c357bcbe2c82c768','CCTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2968,'0a8853038521f6f55e22a91a8a447a4f','AATCGGCGGCTGGCTGCTGTGTGGCGRCTCTATCATAACGATTGGTTTGGCTCCTCCTCGTGGGGATCTGGATCATGAGCCCACTTTTTAAACYTATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2969,'1e4139dd4e51982f3cf3cc014e7d279e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGAYGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2970,'4adb075235d4367758a71e460fca3f47','TTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2971,'ef6ffa4167d256725cc210dd77250fa1','CGGGCGGCTGKCTGCTGTGWGCGGTTACTATCATGACGATTGGTTTGGGTCCTCCACCTAGGGAAMTGGATCATGAGCCCMCCCTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2972,'94714e485d693bda1359ca9fcb96bef9','TTTCCAGAGAACCGCATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGACTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGTTTCTATCATGGCGATTGGTTTGGGTCCTCCTCCTGGGGAACTGGATCATGAGCCCCCCCTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2973,'9bcf4707a22bb46a3040a2be38203e9b','CACACCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2974,'57d7403ffbb587b8018b8c227933f5c1','CACCTAAAAAACTTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2975,'0f48950c50ca1943132289ce5cc7448b','CCACACCTTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2976,'55cbc4c17889ca678244bfe44541ff5c','CCACACCTAAAAAACTTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2977,'02f99691601d65ad9b04d31206ad68a6','CCACACCCTAAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2978,'25ddc809fd973bb28447be00543df1f0','TTCSWTGTGAACCGTATCAACAAGTAGTTGGGARCCTGCTCGGTGTGGCTGTCTTTSGATGTCAAAGTCGGCGGCTGGCTGCYGTGTGGCGGGTTCGATCATGGCGATTGGTTTGGGTCCTCCKGATGGTGGATTGGATCATGAGCCCACTTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2979,'3730bb99f79c45f00df814ee2e6e5950','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATTTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2980,'4faf2df8146f8c62b5f700c4dfd9c0a7','CCAGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2981,'92ac0bc8820518b5319a9d08dae80e12','CCTAAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGCTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2982,'a2209d3043c032410bd58d6a7a8b6726','CCTAAAACTTTCCCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2983,'1ccc1beec38b718f6fa610ef4371784b','TTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGATTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2984,'220b95ba259d63b868c0d467e57e739f','CACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2985,'27d96625f277fce813ce7e4821868b06','CACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2986,'aa41741ae71f3a3fc568d5db76a14a08','CCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2987,'d580bdbb428508765fb06b7e245b1898','GTACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGACGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2988,'8d14d2dd1b82acf33c6924e86ff5f84e','AAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2989,'647f8f63d99173f298c87ed2d998b317','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGATTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(2990,'ff0d6d27a9565c20783ad88d417dea2a','CCACACCTAAAAAAACTTCCACGTGAACTGTATCAACCAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGTTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2991,'e6aad2a9fd3f709fdd0e3508bb714d99','CACCTAAAAAAACTTTCCCGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTCTGCTATTACTCCCTTCATGCAGCTGGTGGACGACCTCTATGGTGGACTACTCGTGTTGGGGTTCGGCTCGAGCGAGTAGCTTCTCCTTTAACCCCCACTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2992,'07dbdb35ad8f7818647b5c523449feba','GTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(2993,'41ef6918215df7391656490f0d91c0ba','GGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTTAATAACTGAAATAC');
INSERT INTO its1_sequence VALUES(2994,'1d7f4c83f35c49b35ebc5fa3469a7863','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTGGCGTGCTGAGCAAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTGTTTTAAACCCATTCGAAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2995,'6b7086b1c112b47a776dd198672a6734','CTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTGGCGTGCTGAGCAAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCGAAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(2996,'9e2ece01dd3968cc7fb9fc8d32d422eb','CCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTCTTTTAAACCCTTTTACTATTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2997,'8adf416f99191fefef69a5ac849daa6c','CACACCTAAAAACTGTCCACGTGAACTGTACTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTCTTTTAAACCCTTTTACTATTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2998,'a5d25c6f5c5eb638a656dd99125aac7e','CCACACCTAAAAACTGTCCACGTGAACTGTACTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTTACTCTTTTAAACCCTTTTACTATTAACTGATATAC');
INSERT INTO its1_sequence VALUES(2999,'97f7b20dd91f1f99e123e133de2266c7','CCACACCTAAAAACTTTCCACGTGAACTGTATTGTGAAGCCTTTGGGGACTCCTGGTTGGCTGGCTTTCGGGCTGGCTGGTCGGTTGAGACCCATCAAACGAAAACCCGGGCTGAAAAGTCGGGGCCAGTAGTTACTTTGTAAACCCTTTTGTATCAAACTGAATATACT');
INSERT INTO its1_sequence VALUES(3000,'dbbf9497ffe754f3e34f2cad6eaee169','CCACACCTAAAAACTTTCCACGTGAACTGTATTGTGAAGCCTTTGGGGACTCCTGGTTGGCGGGCCTTCGGGCTTGCTGGTCGGTCGAGACCCATCAAACGAACACTCGGGCTGAAAAGTCGGGGCCAGTAGTTACTTTGTAAACCCTTTGTATGAAACTGAATATACT');
INSERT INTO its1_sequence VALUES(3001,'2cb967692801515f4e9a428991be4b36','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTTCTCGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGTAGGCTGCGTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTAAACCATTTCTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3002,'f35a21e9cba6e43f4695376fb9736b3d','CCACACCTAAAAAAATTCCACGTGAACCGTATCAAATTTTTAAGTTGGGGGTCTTGTTTGGCGTGCGACTGCTTCGGTAGTTGCTGCTGGGCAAGCCCTATCGCGAACCGTTTGGACTTCGGTCTGAGCTAGTAGCTAAATTTTTTAAACCCATTAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3003,'5904af30cdaa241cd4aa80609e307b1b','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(3004,'1c9a69ab3e1b72ba5c878b93e09a01b5','CCACACCTCAAAAACATCTCACCTGAACCGCTTCAACACCATAGTAGTGGGTGTTATTTTGCGGCGGCTGCTGGCGGTAATATGTTGGCGGCTGCTGCTGAGTGAGCCCCCTTCAAAAAAAAAAAGGCGGACCGTTTGGGCCTCGGCCTGATTTTAGTAATCCTTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3005,'5bfaa69fb490b6458479d1cf9dc65701','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(3006,'abd371858152a64d9784960cb61e653d','CCACACCTAAAAATCTTTCCACGTGAACCGTATCAACCCATTAGTTGGGGGCTTGCTCTGTGCGGCGGCTGTCGATGTCAAAGTCGACGGCTGCTGCTACGCGGCGGGCCCTATCACTGGCGATCGTTTGGGTCCCTCTCGGGGGAACTGAGCTAGTAGCCCARCTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3007,'df18c1e779dc50bd17454ef1c8445b62','CCACACCTAARAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGKTGCTYGGCGTTTTTGCTGAGCCACGCCCTATCATGGCGAATGKTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3008,'9d701ce98b9a5f4f03b415763c6e0523','CCACACCTAAAAACTGTCCACGTGAACTGTGCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGCGTGCGTGTGTTTGGYGTGCYCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTMTTTTAAACCCTTTTACTRTTAMCTGATATAC');
INSERT INTO its1_sequence VALUES(3009,'da09b2084cf0d05cd185bab3f3e19a0c','CCACACCTAAAAACTGTCCACGTGAACTGTRCTGAAGATGATTGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGYGTGCGTGTGTTTGGYGTGCYCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTMTTTTAAACCCTTTTACTRTTAMCTGATATAC');
INSERT INTO its1_sequence VALUES(3010,'56dc3c90adb3d8d30c85ad40e55c4e40','CCACACCTAAAAACTTTCCACGTGACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3011,'cfbcae31c8e553be17a74cecd240c08f','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCYCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACWTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3012,'d4300db830f7a7bd21c78162d042a909','CTAAACACTTCCACGTGACCGTATCAACCCCTTAAGATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTCTAATGACTGAAATAC');
INSERT INTO its1_sequence VALUES(3013,'d8b295764162f1ccea096fdb3d11d0ef','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3014,'12e6035bde63e999b3cf5acfb7d064bb','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3015,'9142c7d3bcdc3242d52facf73d1eadfd','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTCAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3016,'2d644cf0eac386bc1208a696e99ef7f0','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACTTTAGTTGGGGGTCTTTTCGGCGACGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGAATGAGCCCTATCATGGCGAGCGTTTAGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3017,'f21e77bde73b3053f8e9dada3bc6f2b4','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGAGCTTGCTTGGCGGCGTGCGTGCTGGCCTAAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(3018,'f1809501911d494188450de3af7a924c','CCACACCTAAAAAAACTTTCCACGTAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGTCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3019,'6dfca43747096d540315894a8aea95dd','CCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGYGTGTTYGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTTTTTTAAATCCTTCTKTWWAACTGATTATACT');
INSERT INTO its1_sequence VALUES(3020,'c5e0d2ed60560a44e134a77895e172c0','CCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTTTTTTAAATCCTTCTKTWWAACTGATTATACT');
INSERT INTO its1_sequence VALUES(3021,'e6629152426f96e2771a5da989a32ab9','CCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTTTTTTAAATCCTTCTTGTTAACTGATTATACT');
INSERT INTO its1_sequence VALUES(3022,'015f41aff4481719efee2d5b8a538497','CACGTGACGTATCCACCCCCTATAATTGGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCAGGGGCGAGCGTTTGGGCTTCGGCTTGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3023,'5ade1f2776800dd9c7da9c5811029543','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAAAACTGAACATACT');
INSERT INTO its1_sequence VALUES(3024,'29c90b94e839ed8351b5a9a5903d4f77','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTWAATTTGGGGGCTTGYTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAMTTTTAAACTCCTTTCTTWAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3025,'dfd8d941a1be21f29015841554537f39','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3026,'b12a4b691670154761a840f6ba632a6f','CACGTGAACCGTATCACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3027,'56125e1217d0a91faf241921a62461e5','CCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCTGTTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCTGGGGTAGTAGTTACATTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3028,'82f6f18852465ee1e9bc0ee6c9df0b72','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCATTTTAAACCCTTTCTTAACATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3029,'259a57cad52dd1419c0660ea1d12752a','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCATTTTAAACCCTTTCTTAATATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3030,'b65fee664b04a1097815f732a143f888','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3031,'e3c0a6d76220caca7c172367286d2f2f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3032,'dd2a68ba9025846eb1856a9f50e8a85f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTCATGGGTGGACGGCTGCTGCTGGGGCGGGCTCTATCAAAGGCGATCGTTTGGACCTCGGTCCGAGCTCGTAGCTTTGTCTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3033,'5494bda514e7aa5e0b4c0660cf534432','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTACGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3034,'784b3f800eb66332b982bb5c77f88171','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTATAATTGGGGGCTTGCTTGGCGGCGTGCGTGCTGGCCTATTATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTTAAACCCATTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(3035,'cfa1b00763a62b8ce67e41d55b9fb925','CACACCTAAAAAATTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGGCGGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATAC');
INSERT INTO its1_sequence VALUES(3036,'7f4a108ba7167f497fb1970f26e0c0d0','CGGCTGCTGGCTTCATTGCTGGCGGCTGCTGTTGAATGAGCCCTATCATGGCGAGCGTTTAGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTCTTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3037,'0dae0c31b7e008ac4e8e7904207f4129','CCACACCTAAAAACTTTCCACGTGAACCGTTCTGTTGTCGGGTTTCCTGCGCGGCTTGTCTGTGCGGTTGAGACCATCAAGCGAGGGCCTGGGCTGCAAAGTCTGTGTTCTTCGTTTCTTTTTGTAAACCCTTTTCTTTCAAAACTGAACATACT');
INSERT INTO its1_sequence VALUES(3038,'50c88a762e765d8555e1deb9b96a2649','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCAACTAGTTGGGGACTTGTCTGGCGGTGGCTGTCTGCTTTATTGCGGACGGCCGCTGTTGGGCGAGACCTATCATCGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCATTTTTTAAACCATTCCTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3039,'3f342191b4531349fb88e11875b3e2eb','CCACACCTAAAAAAATTTCACGTGAACCGTTTCAAACAAATAGTTGGGGGTTTTGTTTGGCGGCGGCTGCTGACTTTATTGCTGGCGGCTGCTGCTGGGCGAGCCCTATCATGGCGAACGTTTGGACTTTGGTCTGAGCTAGTAGCTTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3040,'dc78426b170c23c260a2c3c449615f89','CCACACCTAAAAAACTTTCCACGTGAACCGTATCGAACAATTAATTGGGGGTTTGCTTGGCGGCGGCTGCTGACTTCATTGTCGGCTGGCTGCTGCTGGGCGAGCCCTATCATGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTCAATTTTTAAATCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3041,'689faebcb92f5bd3c57b7018d1c77a06','CCACACCTAAAAACATTTCACGTGAACCGTTTCAAACAAATAGTTGGGGGTTTTGTTTGGCGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGGCGAGCCTTATCATGGCAAACATTTGGACTTTGGTCTGAACTAGTAGCTTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3042,'6e6da631fa523ae022b4da72d606c952','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTTGTTTTAAACCATTTAAGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3043,'62bd5d0b2b1866f1f54d88e48bb859d2','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCCTTGCTTTTTTGCGAGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTCTGTAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3044,'a0b15d49beb8ce92e393b8bd979987ec','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAAGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3045,'f5b1e48014181ef08db0cb1f2281b9af','CCACACCTAAAAAACTTTCCACGTGAACCGTATCGAACAAGTAGTTGGGGGTCTTGCTAGGCGGCGGCTGCTGCTGGGCGAGCCCTATCATGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3046,'8db7e39eb3b6b810db8a61bb63649955','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGACGGTGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3047,'ea9b8197108691474a24a1b5e1b49a9f','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCCTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTAGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3048,'0c08465c0ccdd1748f5167d72bd98136','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGCTTACTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3049,'91691579c36ca1c227e8cf5236d8568a','AAAACTTTCCACGTGAACCGTATCAAAACCCTTAGTTGGGGGCTTCTGTCTGGCTGGCTTCGGCTGGTTGGATGGCGGCTCTATCATGGCGATCGCTTAGGCTTCGGCCCGAGCTCGTAGCCGACCTTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3050,'33a834de5c8768b852aa1342f20bdcc3','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTCAGTTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3051,'bcd8428c56a22fd54f35240246e6990c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCTTCGGCTGGCTGGGCGGCGGCTCTATCATGGTGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCTTTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3052,'53372be507fa6a221a946af23bf60921','CCACACCTTAAAAACTTCCACGTGAACTGTATTGTCAACCATGATCGGGGACTCCTTGCTAGCGTGCTTTCGGGCGTGCCGGTAGGTTGAGACCCAACACGAAAACATCGGCTGAAAGGTCGGTGCGATTAGTTACCTTTTTGTAAACCCTTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(3053,'487afcbe5196598ae0a3d8f651a0f57b','CCACACCTTAAAAAATTCCACGTGAACTGTATTGTCAACCAAATTCGGGGACTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACAAAAACTTCGGCTGAAAGGCTGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(3054,'28f76cb3d3f401f7efe963a4f908563a','CCACACCTAAAAAACTTTCCCGTGAACCGTATCAACCCCTTAATTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAAGGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3055,'3031c34cd7aefc24a75ef4fd684753ee','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTGGGGGGCCTGCTCTGTGTGGCTGTCCGTCGATGTCAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3056,'1cd4c964a68e9ef648f11f737577506d','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAGTAGGTGGGGGCCTGCTCTGTGTGGCTGTCCGTCGATGTCAAAGTCGACGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3057,'87c93bbfbe905ed3b6b1981d77591eed','GTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3058,'a73f62deb0f41308c418e9603163c98e','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTGGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3059,'c9075e5a2ac67b7cac78051cb06b3895','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAYTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTCATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3060,'b09106c65fc2c918aa02e15c426d7a08','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAATTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTCATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3061,'86d64fa4cd7eba91ea07f774fe3fca05','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAACTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTCATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3062,'bfc5c958e5fbbc9831d1ce4016ef8253','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCACCTAGTTGGGGTTCTCGGTAGCTGTGTGGCATGTGGACTCGTTCTACGTGCTGCTGGCGGCTGAGACCTATCATGGCGAGCGTTTGGGCTTTCGGGCCTGGATTAGTAGCCCTCTTTTAAACTCATTCTGTAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(3063,'61f6f53e2d28008e3b6df39fd18d414e','TAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3064,'4054304471ba12a8b37835533c5d6cdb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAACTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3065,'3c9b525b635348f577c2db9eccffa9ca','CCACACCTAAAAACTTTCCACGTGAACCGTATCAAACCTTAGTTGGGGACTCCTCATTGGCGGCTTCGGCTGCTGGTGGGTTGAGACCTATCAAACGATTAGCTTGGGCTGCAAAGTCTGAGTTGAGAGTTTCTTTTTTAAACCCTTTATTATTTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3066,'c4722a675d069c732e04e6b65613ed9a','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGCTTGGCGTGCGGCTGCTGGCCTTTATTGGTTAGCTGGCTGCGTGCTGGGCGAGCCCTATCATGGCGATCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTGTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3067,'2108c932d1be001556238dddbc7c2a5f','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTGCTGGGTGTGCGGCTAGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGTCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCAAGTAGCTTTTTTTTTTTAAAACCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3068,'6ce3f949a712d7551a25870c2ac4866b','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGAGCGGGCTCTATCATGGGCGATCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3069,'a70ae30dc13613d526af1ef10ba86cad','TTAGTTGGGGGCTTCCGTCCGGCTGGCTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGAGCTAGTAGCCCTTATTTTAAACCCATTCGTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(3070,'ae113d8cb4c52217844e60d66cf724a0','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAGTTGGGGGTCTTGCTTGGCGTGCGGCTGCTGGCCTTTATTGGTTGGCTGGCTGCGTGCTGGGCGAGCCCTATCATGGCGATCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTGTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3071,'83ed9a152435e119ad0e3abcaed8352e','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCGCCGCTTGCGGAGGCTTCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTCGTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3072,'b07efb04f60cc4567c67721f2f62acb7','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTTATGGGTCGGCGTGCTGCTGCTGGGTGAGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTCATTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3073,'1936875791856a0f8ec0860c904fe79a','GCCTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGTTCGGCTTGAGCTAGTAGCTTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3074,'0e1aefe422cd776637e7c0011433e90b','CCACACCTAAAAAACCTTCCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3075,'4885e846779428170b6c5d1e8e44d15b','CCACACCTAAAAAACTTTCCACGTGANCCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3076,'e394b22a23851d76f83cbfd430769de5','CCACGTGAACCGTTCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGTTGGTGGGTCGAGGCCTATCAAAGCGAGTGATTTGGGCCGCAAGGTCTGAGTTGCGAGTTTTCCTTTTAAACCCATTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3077,'d2642daa048fd104d29fa3b55e8a5411','TCAACCTTTTAGTTGGGGACTCCTCGTCGGCGGCTTTCGGGCTGTTGGTGGGTTGAGGCCTATCAAAGCGAGTGATTTGGGCCGCAAGGTCTGAGTTGCGAGTTTTCCTTTTAAACCCATTACTTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3078,'586b918358d9d767090930f91c17fe5c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAAAAGTAGTTGGGGCGTGAGTTTGGCGGCTTCGGCTGCTGATCTCTGCCTATCAAAGTGATCGTCTGGGCTTCGGTCTGGATGAGAGCTTCTCTTTTTAAACCCATTTCTAAATAACTGATTATACT');
INSERT INTO its1_sequence VALUES(3079,'ad6b65d97c9aa91f55df29811294933c','AAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3080,'89b106b674c4c6f1d64e333251140bea','CACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3081,'502bc5e5baf0c6403b62597c0a1ad19e','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTCGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACCTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3082,'2287731e1f441914bcb5941ded77c753','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTCATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3083,'0731a4ee1b229706de8e4be94a89d410','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3084,'5439dcdc9913f10b29a5ecb4e7faa6cf','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCYTTTWAWTTGGGGGCTTGYTCGGCGGYGTGYGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCANTTTTAAACNCCTTTCTTAAMATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3085,'1cd3d0b484c09bd6bb56e2f61d08ff1e','CCACACCTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTAATTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3086,'53eac43a900a1b452a158a1010bd4b7e','CCACACCTAAAAAAAACTTTCCACGTGAAACGTATCAACCCCTCACTAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3087,'1adc0ea2ea904e761975d71a1fe35fd2','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTWWAATTYGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCRGGCTCTATCATGGGCGAGCGYTTGGGCTTCGGCTCGARCTAGTAGCTWTYWMTTTTAAACCCWTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3088,'84eeb3f5bab6e07ad1e5c97e8fc32252','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTYGGGGGCTTRCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTYCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3089,'9db228c2ea6cf15ea15c92e4b4a68b9b','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCTCTGGGCTGMAAAGTCGAGGGTAGTAGTTACTTTTTGTAAAYCMTTACCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3090,'c4f2dd50e26e6322dda600f193b5cdc3','AAACTTTCCACGTGAACTGTATTGTCTGTTGTTGGGGGCTTGGGCTGGCGTTTCGGCGCCGGCTCGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCTGGGGTAGTAGTTACTTTTTTGTAAACCCTTTTCTTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3091,'4aec1700902332fbb5b816e7e9501443','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCCGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3092,'7abf503afa74a3cbfa561abbb5e25e7f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCRTATTTTYTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3093,'9f6c38f3070455353acae806eae98b62','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCCAGCGCGAGCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTCTTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(3094,'6bcd84486a0dd7384d6e8262712e516f','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3095,'26a24e7e07a608a1b7fa7eb96d227d1b','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGTGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3096,'49607ad30ab420b69fa4a59c16344340','CCACACCTAAAAAACTTTCCACGTGAACCGTTAAAAAACTAGTTGGGGGCTCCTCGTTGGCAGTTTCGACTGCTAGTGGGTTGAGTTCTATCAAACGATCGATTTGGGCTGCAAAGTCGGAATTGAGAGTTTCTTTTTTAAACCCATTACTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3097,'22990817c5288dee74460bac5a641595','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGCTTCTGTGCGGCTGGCTTCGGCTGGCTGTGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGAGCTAGTAGCTCTATTTTTTAAACCCATTCCTAAATACTGAATGTACT');
INSERT INTO its1_sequence VALUES(3098,'283e23ea087e76f442378d56ef93f60e','CCACACCTAAAAAACTTTCCACGTGAACCGTTAAAAAACTAGTTGGGGGCTCCTCGTTGGCAGTTTCGACTGCTAGTGAGTTGAGTTCTATCAAACGATCGATTTGGGCTGCAAAGTCGGAATTGAGAGTTTCTTTTTTAAACCCATTACTTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3099,'520f037239d209788717e575c13e7b85','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3100,'60828fd26d7caae5f5de87372a92e9b2','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3101,'2bc39fe40ce4b1f8d4b0bef1fbf780c6','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3102,'6a21bc608f3ae74d7c889a677d6dd2d1','ATTGGGGGCGTGCTGGGCGTGCGTGTGCGGCTTCGGCTGTGTGCGTGTGTTTGGTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGCTTTAGTAGTTACTCTTTTAAACCCTTTTACTATTACCTGATATACT');
INSERT INTO its1_sequence VALUES(3103,'8e3b74dd0e66db6c131ed51fc3ace017','CCACACCTAAAAAAACTTTCCACGTGAACTGTATCGAACAACTAGTTGGGGGTCTTGTTTGGCGTGCGGCTGCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3104,'0b8cd05ff4b81a597c554172ab1a5446','TTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3105,'3882b80cd59319968f5f40c0fa4b9391','CCACACCTAAAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3106,'216a68aab1a17dc508144e5a6c3203f4','CTTTCCACGTGAACCTGTCTGTGATGTTGGGGGCTGTCTGCCTGTTGGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTATATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3107,'794588936794b2b7c8734435bbbdbb4c','TAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3108,'20463e8309b2d5525f87df2c7acdfb69','CCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGCTGTTGGGGGCTGGGCTGGCGCTTTTGGGCGTCGGCTGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTCTTCTTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3109,'131e7d400d4cc655077672741ce31ad5','CACACTAAAAACTTTCCACGTGAACTGTGTTGTCGCTGTTGGGGGCTGGGCTGGCGCTTTTGGGCGTCGGCTGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTTCTTTTTCTGATC');
INSERT INTO its1_sequence VALUES(3110,'8db7de00adbbeed579364ce3208ad0ef','CCACACCTAAAACTTTCACGTGAACTGTGTTGTCGCTGTTGGGGGCTGGGCTGGCGCTTTTGGGCGTCGGCTGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTCTTCTTTTTCTGATCATAC');
INSERT INTO its1_sequence VALUES(3111,'a172e6c444ad40661f8dcc06f45b5445','CCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGCTGTTGGGGGCTGGGCTGGCGCTTTTGGGCGTCGGCTGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTCTTCTTTTTCTGATCTTACT');
INSERT INTO its1_sequence VALUES(3112,'5674f5581ca60cf72a8bcda2f6743da7','CCACACCTAAAACTTTCCACGTGAACTGTGTTGTCGCTGTTGGGGGCCGGGCTGGCGCTTTTGGGCGTCGGCTGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTCTTCTTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3113,'f4fe90f2fc158242d74123ab537663fd','AAAACTTTCCACGTGAACTGTGTTGTTTGTTGTTGGGGGTTCGCTGGCGCTTCGGCGTGGGTTGAGCCCTATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTTGTAAACCCTTTTTCTTATTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(3114,'e4acafafa03ec1c8471741005c175e50','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTARTGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3115,'baebd3ec28916622b3775ddaec142d58','CCACACATAAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3116,'e9fe71b709ac1db4c810d031bc4c9363','TTCACGTGACCGTTTCACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3117,'4e5098affe1a32a11d3eb216f2d0b074','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3118,'3b360f2cb99d7a7c582e898df3a58833','CCACACCTAAAAAATTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGGCGGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATAC');
INSERT INTO its1_sequence VALUES(3119,'acab54da53d7f61ef2945f09f648f6bb','CCACACCAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3120,'e14917143d7c25f762f44e42cfe066f1','CCACACCTAAAAAACCTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3121,'e2a31bd5d6a65414c132bb4d82d51020','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3122,'de7b7405dd064024f4b36870ffd24921','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAATTTAGTTGGGGGTCTTTTTCGGTGGCGGCTGCTGGCTTTATTGCTGGTGGCTGCTGCTGGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTTTAAACCCATTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3123,'9afe97782880dd9788387e700830f5e2','CCACACCTAAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACTTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3124,'7ac8e23f42b633ed88a6cdf38e8afca9','CCACACCTAAAAAACTTTCCACGTGACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3125,'fbe6c1a12518404191bced5c50d19481','CCACACCTAAAAAACTTTCCACGTGAACGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCGCGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3126,'8c48f869013a252371c7e1366f7082c4','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACCCAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3127,'c90cd52f35a8e8643937cd4384b122ad','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTYGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3128,'2afb90bc208dc272c8959b761a410990','CCACACTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAACTTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3129,'1edb32f0211320f603c336e011734c0a','CCACCCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3130,'2749953bce7013f1093868d5f54bb14b','CCACACCTAAAAAACTTTCCACGTGAACCGTATCACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGTTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3131,'5f4743eb499fb56b0269bc1b33ffe4d9','CCACACGTAAAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3132,'2ec072731c10e0b08bec25e15db49b4a','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3133,'aec9b7d1cf6e2b6dfe17de149aa7cb2b','CCCAAAAAACTTTCCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3134,'bf08381ca0d88d89093c92f7bdfc09f0','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3135,'c869ad12b31c26d96ff3543aa34f97f3','CCTGTAATGGGTCGGCGTGCTGTTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3136,'ae1a2ae68b4e98194f5e9a0c7c6ae6b3','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTAACCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3137,'34a7afad9c167d5e78784f48527a15de','CTTTCCACGTGAACCGTATCAACCCCTTAAGATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCCTTCTCTAATGACTGAAATAC');
INSERT INTO its1_sequence VALUES(3138,'89c8aee643b4d89cca7fa042e5505161','CCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGCTGTTGGGGGCTGGGCTGGCGTTTCGGCGTCGGCTGGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTCTTATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3139,'e4d8bcea13315042749d7c0b844335f9','CCACACCTAAAAACTGTCCACGTGAACTGTGCTTGAGATTGGGTCGTGCTGGGCGTGCGTGTGCGGCTTTGGCTGCGTGCGCGTGTTTGGCGTGTCCATCAAACGACGAGGCGGGTCGCAAGGCCTGCGCTAGTCGTTTCTGTTTTAAACCCTTTTGTATTGACTGATTATACT');
INSERT INTO its1_sequence VALUES(3140,'08dc8a77a79eae38cba66ec6c1917adc','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAACCCCTATAAATTCGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTTTCTTTTAAACCCATTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3141,'331c0ae3da69bd8aebe5cae6c1b42f7f','TTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTAGGACTTCGGTCCGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCACAATTCTGATTATACT');
INSERT INTO its1_sequence VALUES(3142,'492b204f75e959d705b0d307fdc72baf','GCTGCTGTGTGAGCCCCCTCTAAAAAAAAAAGGCGAACGTTTGGGCTTCGCCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3143,'dce35d8a2bff492caa22833c67de3339','ATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCCGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTT');
INSERT INTO its1_sequence VALUES(3144,'6ca571b150f243f53e440765de2d228b','ATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTT');
INSERT INTO its1_sequence VALUES(3145,'c3bc5bac5695c4f48112a5a87bef170b','CACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTYCCGTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3146,'7970f7666270552ec0737850a340d6af','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCTTTCCTAATTACGGAATATAC');
INSERT INTO its1_sequence VALUES(3147,'0c0af9548d97e3b1bec1385cd127c694','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTCCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACGGAATATAC');
INSERT INTO its1_sequence VALUES(3148,'c7dc257d2b1b376211dca3322dd7411c','TCCACGTGAACCGTATCAACCCCCCTTAATTGGGGCTTCCCTGCTGTCTTGTGCTGGCTGAGCTTTGTTGTTCGGCTGGTCGAGGCGGCGGGTTGAGGCCTATCAGCGAACGCTTTTTGTTAGTAGCTTTTTTTT');
INSERT INTO its1_sequence VALUES(3149,'6f4277025e59b848dc23ab48094836e8','CACGTGAACCGTATCAACCTTTTTAAWTTGGGGGCTYCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3150,'ec8dd6fb8a51f34cd8b8f2973b3dedbe','CACGTGAACCGTATCAACCTTTTTAAWTTGGGGGCTYCCGTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3151,'969428ccb92249cd7f580087e428be16','CCACACCTAAAAACTGTCCACGTGAACTGTGTTGAGCTTGGGGCGTGCTGGGCGTGCGTGTGCGTGTGGCTTCGGCCGCGTGCGTGCGTGTGTTTGGCGTGCTCATCAAACGAAGAGGCGGGTCGCAAGGCCTGCTTTGGTAGTTACTGTTTTAAATCCTTCTTGTTAACTGATTATACT');
INSERT INTO its1_sequence VALUES(3152,'2b2569936da353c0fe81fa8366f4ef68','CACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTTCCGTCTGGCCGGCCGGYTCTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCRTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3153,'ddd613f300fecf1264fc4a92d852dab1','CACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTYCCRTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3154,'f330e15f6f784ff2b28da50e4dde9498','CACGTGAACCGTATCAACCTTTTTAAATTGGGGGCTYCCGTCTGGCCGGCCGGTTYTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCKTMTYTTTTAAACCCATTCCTAATKACTGAATATACT');
INSERT INTO its1_sequence VALUES(3155,'c014a710582e2b11c8e48d9b44ec1979','CACGTGAACCGTATCAACCTTTTTAAWTTGGGGGCTTCCGTCTGGCCGGCCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3156,'9c5f1c87e5da48289e0a487675b21a61','CCACACCTAAAAACAATTTCCACGTGAACCGTATTAACCCACTAGTTGGGGACTCCCTGTTGTTGTGGCGAAGGTGCCAGCGTAAGCTGGTGTTTTGGCTGTGGTGGCAGGTTGAGACCTATCAAACGAGTGTCCGCCGGCTGAAAGGTTGGTAGGCGCGAGTTTCTCTTCTAAACCCATTACTAAATTACTGAAAAAACT');
INSERT INTO its1_sequence VALUES(3157,'c00cba1a98632184cc83286374a4e2bc','CCACACCTAAAAACTTTCCACGTGAACTGTGTTGTCGATGTTGGGGGCTGGGCTGGCGTTTGTTCGTCRGTTGGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTTTAAGTTTTTCTGAATATACT');
INSERT INTO its1_sequence VALUES(3158,'a79b21220b9a17c659614bca72d8e351','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCTTGATTATTGGGGGCTGCTGACTGGACTGGCTTCGGCTGGACTGGGCGGCGGCTCTAGCGCGACCGTTCTGGGCTTCGGCTTGGGGCTAGTAGCTTTTATTTTAAACCCATTCTTAATTTACTGAAATAC');
INSERT INTO its1_sequence VALUES(3159,'ac0869210e3c1e189f45a977bb4b82be','CCACACCTTAAAAATTTCCACGTGAACTGTATTGTCAACCAAATTCGGGGACTCCTTGCTAGCGTGCCTTCGGGCGTGCCGGTAGGTTGAGACCCATCAAACGAAAACATCGGCTGAAAGGTCGGAGCCAGTAGTTACCTTTGTAAACCCTTTACTAAATACTGAAAA');
INSERT INTO its1_sequence VALUES(3160,'1b3d0a7cd04f587390c84bf0ae0e8224','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACGCATCTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3161,'5711fb2550211daebd69012824239ab2','CCACACCTAAAAACTTTCGACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACGCATCTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3162,'e7154600cc9be8df11c73b37434d4758','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCTGCCTGTTGGCGGGCGGCTCCATCAAACGAGGCCCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTACGCAACCTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3163,'ce7c759342a87dfeda5af5c98c39beb5','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3164,'098fb8c562415f551747e90f858d908b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCATTCTTTAATTACTGAAATAC');
INSERT INTO its1_sequence VALUES(3165,'f4703252bc17fe77c80bde60735b82f8','CCACACCTAAAAAAACTTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGATTTGCTCGGTGTGCGGCTAGCTGGTCTTTATTGGCTGGCAGGCTGCGTGCTAGGCGAGTCCTATCATGGCAAACGTTTGGGCTTYGGCTTGARCTAGTAGCTTTTTTTAAACCATTTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3166,'ba35d5ffabc2b77c66871f9ad09deb43','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTCCTTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3167,'9c0309d625e4fda24e4bd7e089963218','AATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACTCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3168,'918f5eb6749ac7b50fb841e57c556d55','TTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCCTTGGTGGTGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTGTTGTAAACCCTTTTGTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3169,'aaf939282a5e1ea7dbfeae371b7f8c25','AAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCTGCCCTTTGTGGTGGCTCCATCAAACGAGGCCCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTGTTGTAAACCCTTTTGTAATTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3170,'495d97623fc117f35e1945e55fbae7b9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTTAATTGGGGCTTGTTCGGCGGCGTGTGTGCTGCCCTGTAATGGGTCGCCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3171,'aacafd0e9f9a022916540ccbd2e20828','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTTAAGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGATCGTTTGGGCTTCGGCTCGAGCGAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3172,'746bcd1616b3306de92332eef70cc0c3','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTGGGGGTCTTGCTGGTGTGCGGCTGGCTGGCCTTTATTGGCTGGCAGGCTGCGTGCTGGGCGAGCCCTATCATGGCAAACGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTATTTTTAAACCCATTTCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3173,'f2d51d013bc4b0061958e1d4dd5d8a54','CACGTGAACCGTATCAACCTTTTTAATTTGGGGGCTTCCGTCTGGCCGGMCGGTTTTCGGCTGGCTGGGTGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCCTGGGCTAGTAGCGTATTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3174,'1fffde4230acbd1657695c5107a6f974','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGGTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3175,'ab9e243b0931b7d84b2644c00fce9f66','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAGTGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3176,'cbbf09cf79c5abd82db4edf4a924bced','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGYGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3177,'590ee28a41a910fb2d73bdc37abb9d5e','CCACACCTAAAACACTTTCCACGTGAACCGTATCAACCCCTTCAAATTGGGGGCTTGCTCGGCGGTGGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTTAATAACTGAAATAC');
INSERT INTO its1_sequence VALUES(3178,'93ef3b2aa046b7ccfdaa081519bef673','CCACACCTAAAAACACTTTCCACGTGAACCGTATCAACCCCTTCAAATTGGGGGCTTGCTCGGCGGTGGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGTTGCTGGGTGGGCTCTATCATGGGCGAGCGTTTGAGCTTCGGCTCGAGCTAGTAGCTTTTCTTTTAAACCCCTTCTTTAATAACTGAAATAC');
INSERT INTO its1_sequence VALUES(3179,'2b9aec217a23f6073495a73a7486899d','CCACACCTAAAAAANCTTTCCACGTGAACCGTATCAACCCYTTTWAWTTGGGGGCTTGYTCGGCGGCGTGYGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACNCCTTTCTTAAMATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3180,'d7b3083392b68708e35183ad4d3f64e3','CTAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3181,'3dbab45cb8d0312cfb58ed0553eacf21','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCGTTTTGCTGAGCCCCGCCCTATCATGGCGAATGTTTGGACTTCGGTTTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3182,'403b997292061bc008b470e0b2a0deea','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCRTTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCCATTTAACAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3183,'cf5dcb7cea7b4f505a3c895d6ea58027','CCACACCTAAAAACTGTCCACGTGAACTGTGTYGATGTTGGGGCGTGCTGGGCGTGCGTGTGTGTGTGGCTTCGGCCGCGTGCGTGCGCGTGTTCGGTTGTGCTCATCAAACGAGGAGGCGGGTCGCAAGGCCTGYGTTCTTTGTTACTGTTTTAAATCCTTYTTATACACTGATTGTACT');
INSERT INTO its1_sequence VALUES(3184,'6eb390098dc6c4b57f875d52d9477859','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCYCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3185,'1fe44ebc74b1c1b2de741c2bbff182ec','CCACACCTAAAAACTTTCCACRTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGCAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3186,'66d1e3b190ce5afaf783790138488ce7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTGTTGCTTGGCATTTTGCTGAGCCACGCCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCTAGTAGCTTTTTGTTTTAAACCATTTAAGAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3187,'7ed5867acaa0e58974f98c3b925b3128','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGTCGTTCGCGGCGGCTCCATCAAACGAGGCCYTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACTTTTTCTGATGATACT');
INSERT INTO its1_sequence VALUES(3188,'3d60428551ee25bf566c99da019f5994','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGYCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGMAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACWTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3189,'280172fe5e263c64ca3725f09d1a3e66','AAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCCTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3190,'3b9020cdda33cf2af72482d2a96d6b33','AAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCYTTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3191,'66c3bc21a53d834f65b9a7bece6f2538','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGYCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACWTTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3192,'360c27eda91e8a5f9ac704ededff31b7','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCCTTTCTTAAAGTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3193,'316c3460e97472858a1faf0058b9b5bf','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACYCCTTTCTTAAAAWACTGAACATACT');
INSERT INTO its1_sequence VALUES(3194,'2f67459289b7f83dcdf3b3eb2070720d','CCACACCTAAAAACTTTCCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3195,'f4c5d06b932a0c419892f8309b836dd2','CCACACCTAAAAACTTTTCCACGTGAACTGTCTGTGATGTTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAATCGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3196,'4435e6b4ec5c13a8286ed0014a94f257','CTTTCCACGTGAACCGTATCAACCACCTAGTTGGGGTTCTCGGTAGCYGTGTGGCATGTGGACTCGTTCTACGTGCTGCTGGCGGCTGAGACCTATCATGGCGAGCGTTTGGGCTTTCGGGCCTGGATTAGTAGCCCTCTTTTAAACTCATTCTGTAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(3197,'ef501e0e869698b47ace2aaa8eef9e2f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGCTTGCTTGGCGGCTTGGCGTGCTGGCCTGTCATGGGTCGGCGTGCTGCTGCTGAGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTTCAATTTTAAACCCATTCGTAATGACTGATTATACT');
INSERT INTO its1_sequence VALUES(3198,'19dcddcffa510168e1f0442531acaf71','CCACACCTAAAAAACTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3199,'4a63f5da0603f71a6587ae4b606b2d47','CCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3200,'8c6e10fa36f2753c52bcf6d59c9da3a4','CCACACCTAAAAAACTTACCACGTGAATCGTATCAAAACCCTTTTAATGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGTCTGGAGCTAGTAGCCCACTTTTTAAACCCTTTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3201,'b87a53f839798f875bbc282d79bc3280','CCACACCTAAAAAACTTTCCCACGTGAACCGTATCAAAACCCTTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3202,'0a3328a178242ca1c70c7f50cfd3f161','CCACACCTAAAAACTTTCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3203,'a891f880d9f98a19b6eda34cefa435ee','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3204,'3dfd71feadef7ef811f06508f981752b','GGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3205,'5d57850cb1445a960c3f4afe6a2d1d5b','TCTGGCTTCKGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCWTTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3206,'e928e09bbce39eb1bced8f321e0a542f','GCTTCGGTAGCTGCTGCTAGGCGAGCCCTATCACGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTATTTTTTAAACCCATTCTTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3207,'0c3a28d64419311c3e5b83a54a1eddfc','AAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3208,'cf176dbd5520da68aa0b854d772ee6fa','CCACACCTAAAAAACTTTCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3209,'6ba4cbcb402212853ca2042cd87a202a','AAAACTCTTCACGTGAACCGTATCAAAACCCTTTTAATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3210,'e38a96f7379768d59ff81232a813ae5b','CCACACCTAAAAAACTTTCCACGTGACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3211,'8fd9bfb6e7f3197796336bab3917edd4','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACG');
INSERT INTO its1_sequence VALUES(3212,'4313fb8602a77b077187a26deb2d0715','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGCCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3213,'01db98d0cbea82508def830a5ad12c62','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGGGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3214,'4e01dfb7998f8b190b00f5189946b26a','CCACACCTAAAAAACTTCCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3215,'245141760ecdcbc2caa7caf46d7bacb0','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGTTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3216,'d80934ce8f3c9fa61b1e811f89c23d87','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3217,'2e83dde2765324d44885fca312079b1f','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTCCTGTCTGGCCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3218,'9107f1d14bcd07780c794ccb1326b4f0','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGTCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3219,'53a9dd3b5124ba68818330beb49b3368','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAGCCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTCTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3220,'02945f1c9a4aff43a8bdbf8ca89e545c','GTACCATATCGAGCAATTTGTTTGGAGAGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3221,'2dabf04d25b67b2c0f3ff9fe0039cd56','AAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3222,'d21f64d60bda9afe8340850c6b1adf16','CACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3223,'93732a61d6b17cae34bb20fa70701608','GGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3224,'16533f4d8e7546a6ce80a44c2911c150','TATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3225,'475f7facb03868442a01ce17f43aaa0a','GGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3226,'a94a1ba5390d0992c048580711258545','TCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3227,'a017db80bde61ddb0ec1f001b031b8fe','GCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3228,'cc9046d40c96aa55e0cd7c5c69968054','TTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3229,'56815816ec4f7e340246ffd275fa268c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGYTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3230,'41146bde8b404bb7a692f8c57bd415bf','CTTTCCACGTGAACCGTATCAAAACCCTTTTATTGGGGGCTTCTGTCTGGTCTGGCTTCGGCTGGATTGGGTGGCGGCTCTATCATGGCGACCGCTCTGAGCTTCGGCCTGGAGCTAGTAGCCCACTTTTTAAACCCATTCTTAATTACTGAACAAACT');
INSERT INTO its1_sequence VALUES(3231,'77d62090a90342f04215657d41f7eda0','CCACACCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3232,'8e35b13ef3d6639b0eb1dcf63f53a2c3','CCCCTTAAATTTGGGGGCTTTCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3233,'b6b664f858acdd6ef23b3a353dd247a8','CCACACCTAAAAAACTTTCCACGTGAACCGTTGAGTATTGTTGGGGACTTGTTCGGCGGCGTGCGCTTTTCGGAGCGCGTGCTACTGGGCGAGACCTATCATGGGCGCGATCGCTCGGGCTTCGGTCTGGGCTAGTAGCTGCTCTTTTTTAAACCCATTCGTAATGACTGAATATACT');
INSERT INTO its1_sequence VALUES(3234,'06b5102c0eb58de37377ddd5f1fd9c77','CACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3235,'7a7f496cdafb70864cfc6ecd4aeab9fd','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(3236,'b4407fc3571a13187fc5f3a46aa860bf','CCACACCTAAAAAACTTTCCACGTGAACCGTAWCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(3237,'d05f263855a3e494720705c08df24d7e','CCACACCTAAAAAACTTTCCACGTGAACCGTAWCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3238,'11a597f16b08c1a3aca0b84427e93b83','GTGCTGGCCCTGTTAATGGGTCGGCGTGCTGCTGCTGGGGCGGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3239,'531e464f06d5ae176846da96adf9ec2e','TTAATTTGGGGGCTTGCTCGGCGGGCGTGCGTGCTGGCCCTGTTAATGGGTCGGCGTGCTGCTGCTGGGGCGGGGCTCTATCATGGGCGAGCGCTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3240,'11685e5efd7cd8d8cf36b861900125c5','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTAGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATTTTTTAAACCCATTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3241,'88ce1a637fdc97955897fe7311bd250c','CCACACCTAAAAACTTTCCACGTGAACTGTCTGTGATGTTGGGGGTCTTTCTGGCCCCATCAAACGAGGCGCTGGGCTGCAAAGTCTGGCGTAGTAGTTACTTTTTGTAAACCCCTTTACCTTATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3242,'675722298700b03a35f21b37a7a976c4','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3243,'bbb7237c6a6011e96debe1edff98ec1b','CCACACCTAAAAAAACTTTCCACGTGATCCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3244,'95abcdd291111c143f39cc8618d16d90','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCCTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3245,'f5beb13d951e299ea620ead1339be1f5','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCGACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3246,'cc1a95571658ec7222ecf2cb64aafe49','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACTCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3247,'852c084638a95f28dab45f46a975749e','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGRCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGMGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(3248,'f9621e185b545e6d26fedd6accc66680','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGMGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAAYATACT');
INSERT INTO its1_sequence VALUES(3249,'5472fb787ee448a3d1fcce5ab304b40a','CCACACTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3250,'6bf6188d70bc3b18b8e9a8a510b165bc','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACYCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3251,'8a6e18704209488f4db8f93b9dbdab45','AAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3252,'c67f05e6b2cf95a3899bfbd5ed422389','TTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3253,'977d381c96ac7faca5b2868678decf92','AAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3254,'0a725c52f98e6f06f2337f4ffadf82a1','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3255,'058e568bbe95da4b65240d6936f89a96','CCACACCTAAAAAACTTTCCACGTGATCCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACYCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3256,'848a26b7162c4b6975cf78b6265fdf90','CGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3257,'9f645ac4d5b390d8cc5e43dacc19cafa','CGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACNCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3258,'598e5625685a9d63be86bbe6d2499a48','CCACNCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3259,'d74cca771cc9a14f7dc4903add200e67','CCNCACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3260,'c79b481db18dd55c1713e7e068e1688e','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3261,'8d8c265a3a75477ac60169747e50bc19','CNCNCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3262,'9bb1f829ea3f43e48c9b1b61d07496c8','NCCTAANAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3263,'eca6e82b2bdb569231b8ddd403a4448b','CNCNCCTAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACTCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3264,'b7e0a91908888277d92700db13c5ca2d','NCCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3265,'b0d5b1a829bd2ad2a48cb138fb899dcd','AAACTTTCCNCGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCAGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAACTAGTAGCTATCAATTTTAAACCCTTTCTTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3266,'5a0a5956318b50c05409a699fbdee097','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTTTAATTTTAAACCCATTCTTTAAATACTGGACATACT');
INSERT INTO its1_sequence VALUES(3267,'cdb06599f7a10c889ea65e73cfbd5c57','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTCATGGGTGGACGGCTGCTGCTGGGGCGGGCTCTATCAAAGGCGATCGTTTGGACCTCGGTCCGAGCTGGTAGCTTTGTCTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3268,'7058de10cd9adb0ebf2ca85ae980050b','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTYTGGCGCGCGGCTGTTGACCTGTCATGGGTGGACGGCTGCTGCTGGGGCGGGCTCTATCAAAGGCGATCGTTTGGACCTCGGTCCGAGCTSGTAGCTTTGTCTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3269,'0f6d287afdfefa04eedc4877d12b0521','ACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3270,'d1e8470da89703fd2e0b08c760b308e9','CACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3271,'28ef1f2b35f6dd280fd273afc63847c1','AAAAAACTTTCCACGTGAACCGTATCAACCCCTATAGTTTGGGGGCTTGTTTGGCGGCGTGCGTGCTGGCCTGTTACGGGTTGGCGTGCTGCTGCTGGGCGAGCTCTATCATGGGCGACTCGTGTTGGGCTTCGGCTCGAGCGAGTAGCTTTTCCTTTTAAACCCATTCCTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3272,'6f36e8ea8101f53cc7bfbb98dc2d5043','CCACACCTAAAAAAATTTTCCACGTGCAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3273,'f3f889a88a050df7f3b1d3ef20281aad','CCACACCAAAAAAATTTCCACGTGAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3274,'3deae43fefe284ba634f078b7a76fdca','AAAAATTTCCACGTGAACCGTTTCAACCAAAAGTTGGGGGTCTTGTTTGGCGGTGACTGCTGGCTTTATTGCTGGCGGCTGCTGCTGGACGAGCCCTATCATGGCGAAAGTTTGGACTTCGGTCTGAGCTAGTAGTTATTATTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3275,'f796a4dab99d24b5d881515e973b520a','CCACACCTAAAAAACTTTCCACGCGAACTGTCTGTATTTGTTGTGTGTCTGTGCGTGCTGGCGTGCGTTTTGCGTGCCGGCGTGTGCGGACTGAACGAAGGTCGTGTCGCTGTGCGGCTGCTGCATTGCTGACTTTGCATTAAGTTGTATCGTCTTGGCGGAGCGGCGGGTGCTGATGCGATCGGCTGACTTATTTGTTCAAACCCCATACCTAACTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3276,'18553de4727eb042414071fec845ad1c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTAAATTTGGGGGCTTGTTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGTTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACCCTTTCTTAAAAAACTGAACATACT');
INSERT INTO its1_sequence VALUES(3277,'98095d02e5337bc7f69da829823a4591','TATCAACCCTTTAAATTTGGGGGCTTGCTCGGCGGCGTGTGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACTCTTTCTTAAAAAACTGAACATACT');
INSERT INTO its1_sequence VALUES(3278,'00b88a47c44ebe77a9a3ec8baf9f8c8a','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCYTTWAATTTGGGGGCTTGYTCGGCGGCGTGYGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACNCCTTTCTTAAAAWACTGAACATACT');
INSERT INTO its1_sequence VALUES(3279,'daaad49fa01ac5adcc567890f8e81c9c','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACNCCTTTCTTAAAAWACTGAACATACT');
INSERT INTO its1_sequence VALUES(3280,'8374b3c126c60150141083149ee75363','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCCTTTAATTTGGGGGCTTGYTCGGCGGCGTGYGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCACTTTTAAACNCCTTTCTTAAAAWACTGAACATACT');
INSERT INTO its1_sequence VALUES(3281,'7016c94621fac09b9be779b3e4ec5768','CCACACCTAAAAAACCTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGGAGCTTTCGTCTGGCCGGCCGGCTTTTGGCTGGTTGGGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3282,'ada2f769d88325fc5cce301ccc3d6fe9','CCACACCTAAATAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGAGCTTTCGTCTGGCCGGCCGGCTTTTGGCTGGTTGGGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3283,'9d53369f49513026ee85e4c76c8f3133','CCACACNAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGAGCTTTCGTCTGGCCGGCCGGCTTTTGGCTGGTTGGGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3284,'a1302aaab7db45bd9e79b16ecf76e8b3','CACACTAAAAAACTTTCCACGTGAACCGTATCAACCTTTTAAATTGGGAGCTTTCGTCTGGCCGGCCGGCTTTTGGCTGGTTGGGCGGCGGCTCTATCATGGCGACCGCTTGGGCCTCGGCTTGGGCTAGTAGCTTCTTTTAAACCCATTCCTAATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3285,'1106dfe3659538dbe5c56db7c00f20ed','CCACACCTAAAAAACTTTCCACGTGAACCGTATCGACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3286,'916e3c46ce8f9f39589e02325a3bab5a','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCTTGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(3287,'64b6f4d6ee2d9c3de84310cbf29329b2','CACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3288,'2f83fac5460d489cae5ba36d2ca3a21e','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGRCGAGTAGCYTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3289,'91149fd6efc6a67bab16638df73b41e5','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCGTGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3290,'a0cd4850a526bb9e31b0e854ff59ee66','CCACACCTAAAAAACTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3291,'8d2e787bec799c0f1e33a9a9761d123b','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCCTTTTGTTTTAAACCCATTTCACAAAACTGATTATACT');
INSERT INTO its1_sequence VALUES(3292,'32c99495a331b26f4141f19bbdd356b4','CCACACCTAAAAAGCTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGCCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3293,'fccd9d4d153010e74eaf4403af8571eb','CCACACCTAAAAAACTTTCCACGTGAGCCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3294,'5b864185c6959f27c22e587d8af43cd9','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGRCGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3295,'3202e6c3f635c2f8409670368e7084fc','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCYTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3296,'dfcb43a3b56798cbe032c027ad87ec75','CACACCTAAAAAACTTTCCCGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGGCGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3297,'a71c73afd02e52b3daddf5eb01acb18c','CCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCCTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3298,'d5de86387f0cbf1b6b5a017fae425ff1','TAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAGTTGGGGGTCTTGTACCCTATCATGGCGAATGTTTGGACTTCGGTCTGGACGAGTAGCTTTTTGTTTTAAACCCATTTCTCAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3299,'4b17608a216c4d60a0b0d32bdea06dc6','CCACACCTAAAAAAACTTTCCACGTGAACCGTATCAACCCTTTTAATTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3300,'841eb892ab187d3af8c4929329281844','TATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3301,'f7655ce4531695e7d8b2fa03ce94eb94','CCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGTCCTGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3302,'408f13e4d6e6ac7027cf2f7f1653fa12','CCACACCAAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3303,'d1e69c939cc1b792c0b7fb67482af36c','ACCAAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3304,'d34786bb527c3e3fb2e8f7df0aced67d','CAAAAACTTTCCCGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3305,'2130b930eeb8a5e08fae1022e995af0f','CCACACCAAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTGATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3306,'0e227b61ac4c78e5e2d13e60c20f477e','CCACACCAAAACTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTGATTAGGCTAAMCGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3307,'81a9492f24ae18bcde5fba50230a173b','AAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3308,'f846343eb31b766289e8bec781177a52','CACCAAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3309,'c479780627ae34681512c42e8185265e','CCACACCTAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3310,'bc5df00584b57ae7a754357fa08bbdce','AAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3311,'1a0733f7037bea133b1e020e00000b0b','CACCAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3312,'c44680d22c029f6f2994f26515a570ee','CACNCCNAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3313,'e6733ed774127d942810e602973b8333','CCACACCAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3314,'7b168582713022c386489c9eb85c4113','AAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3315,'a2d67d9c634ed51539691a8d678fa8de','CCACACCNAAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3316,'98157b16f23410e51f10445c46ea124d','CCACACCNAAACTTTCCACGTGAACTGTCATTGCATGTTTTGTGCCTTTAATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3317,'e95dff23dd548c59d63ae7c4301bf881','CTTTCCACGTGAACTGTCTTAGCATGTTTTGTGCCTTTGATTAGGCTAAACGAAGGTCGGAGTAAAATCTGGCTGATCTATTTTTTAAACCCATTCTTAAACACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3318,'4571dc6ddda8817932cfe0670797eb38','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3319,'0a528030daded53b84e3e4f34acb36e9','CCACACCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGATAGACCCGGAGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3320,'c5f7cacf3e46b666dabdf2ca68b92c2e','CACACTAAAACTTCCACGTGACCGTATCAACCCACTTAGTGGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3321,'1b0fa015634d94105dd50d9800ff3c4b','CTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3322,'191c78b5a5c914b8058a45cc820ca9ee','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTAAAAGGCGGTGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3323,'dd08a6cf4ff1ff0d20e641712d71726e','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCAAATATTTTGGGGGTCTTGTCTGGCGTATGGCTGCTGCTGTGAAAGGCGGCGGCTGTTGCTGGGTGAGCCCTATCATGGCGAACGTTTGGGCTTCGGTCTGAACAAGTAGCTCTTTTTTAAACCATTACTTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3324,'4c9e98f437ca0f55d0d8ba3b2928239c','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3325,'3d50d11ba25c4be2619182451b70f275','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCNGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTNGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3326,'a04036df5453eeb969d8a0d86ab4e0f1','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3327,'5e7ae00c0b410237cc67621b8f399551','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3328,'10876a2e52ec098c4930c72b39d863f0','CCACACCTAAAAACTTTCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3329,'531236700cc445dcb99cadb7612d3cd0','CCACACCTAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3330,'4f609fa89ece4450ceace4bcb82050e6','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3331,'f149a7c9da8d5867304c046fbf0df58b','CCACACCTAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3332,'47c7541ae98f4614da1db05b8245fa9c','AAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACTGGCTGCTATGTGACGGGCTCTATCATGGCAATTGGTTTGGGTCCTCCTCGTGGGGAACTAGATCATGAGCCCACTTTTTAAACCCATTCTTGATTACTGAATATACT');
INSERT INTO its1_sequence VALUES(3333,'158774f117b3e6058b22ba9ef877f346','CCACACCTAAAAAAACTTTCCACGTGAACCGTTTCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTAGCTGTCGATGTCAAAGTCGGCGACGGGCTGCTATGTGACGGGCTCTATCAGGGCAATTGGGTTTGGGGTCTCCTCGTGGGGGAACTAGAATCAGGAGCCACTTTTTTAAACCCATTCTTGGATTACGGAAT');
INSERT INTO its1_sequence VALUES(3334,'7fa896f24e680e2cc69bdb50b4a711eb','CCACACCTAAAAACCTTCCACGTGAACTGTCTGTGATGGTGGGGGCGTGCCGTTCGCGGCGGCTCCATCAAACGAGGCTCTGGGCTGAAAAGTCGAGGGTAGTAGTTACTTTTTGTAAACCCTTTACCACATTTTCTGATCATACT');
INSERT INTO its1_sequence VALUES(3335,'b20eea3853149a223cb2d51f883a13ff','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3336,'e73782422d1643f0961acc1192d78015','CCTAAAAAACTTTCCACGTGAACCGTATCAACCCATTTAGTTGGGGGCTTGCTCGGGTGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGGCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTCTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3337,'e585fd7b65197613f8f1ef3678626181','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3338,'2d9ee1bcda60ad3f57b25e58b18bcdba','TCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3339,'84c01c47056b19c200ffa7753f8565b7','CCCNCTTAGTTGGGGGCNNGTCCNNGGCGGCTGGCTGTCGATGTCAAAGTTGACNGNNTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTNTCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3340,'9fb31b73b6cfb695787cd77aa7c056b1','CCCTAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3341,'471e278ec6c4201a87b2d8f87d501a9d','CACCTAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3342,'5c20f37195b54e98f1de9dc0cf2403ba','CCTAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3343,'899a433ef9f93d7efba36b90ada0b163','CAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3344,'78cf3616cb8e018268c625b075a86bfc','TTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3345,'c89d9b441a49bafa9a2eabaa353d562f','TTCCACGTGAACTGTCATTATTTGTTGTGCGCTCTCTGCGGTGTCGGTGGCGTCTGTTGGCTGTATTTGATACTGCTGGCGGGTGCGAGCCGGATGCAGAGGCTGAACGAAGGTCGAGTTGCTTTGCTCTCGGCTGACTTATTTTTCAAACCCAATACCCAACTTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3346,'c4826db09abc9ea51aa0155d3130c857','CCACACCTAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3347,'22fe9795dea9ff1ad3e826f727cffb55','CCACACCTANAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3348,'1f9808fe7dfed71f56e4844ba485f7af','CCNCACCTAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCTAGTCCCGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATTTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3349,'40b0d7f0ec989f92988f784387751841','CTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGRTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3350,'3acc3ee06a0e6da66f7f69bf73c0f596','AAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGRTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3351,'725b8c6dee4feeb797aa3afc265731fc','GGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGRTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3352,'ab6ac0f4ef6e83711febde1981c45eeb','TAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGRTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3353,'8992ea2cc5144a8c1687c923c97bce33','GTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGRTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3354,'a48ae33009f360bf0ad5cf517b24657c','TCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGRTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3355,'d0e0e98d78fb1187793f1f6ac4c6926c','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGRTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3356,'27db023c9ce5ab29a40d1b9e7aab9950','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCCTGTCCTGGCGGCTGGCTGTCGAYGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGRTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTCAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3357,'1b2a1ad7b46aa0694e07823664cfd807','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3358,'f95de4d3738b3082b63c7107e798b4bb','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCACTTAGTTGGGGGCYWGTCCYGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTTTCTTTTAAACCCATTCTTGAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3359,'fc107af8c533566a38fbc8c465897eda','CACACTTAAAAACTTTAGCACCTAATCCGAATCAACCCCCTTAGTTGGGGACCGTCCCGCCAGGTCGGCAGTTATCTACAAAGTGGACGCCTGCTGCAGTGTATCGGGCCATATCATGTCGAGCGTATGGGTCCCTGTCGGGGGACCTGAGCCCAGTAGCCCTTATGTTTTAAACCCATTCTCGAATACTGCACATA');
INSERT INTO its1_sequence VALUES(3360,'8cb245b7e39aa446c623090a2790b7bb','CACCCCTAATATCTTTCGACGTGAACCTTACCAACACACTTAGTTGGGGGCCTGTCCCGGCGGCTGACTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGAGCCCTATCATGGACGAGCGTTTGGGTCCCTCTCGGGGGAACTGAACCAGTAGCCCTTATCCTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3361,'6141f0231149f9d31706a01eb876d43b','CTTTCGTTGGGGGCCTGTTCCTGGCGGCTGGCTGTCGATGTCAAAGTTGACGGCTGCTGCTGTGTGTCGGGCCCTATCATGGCGAGCGTTTGGGTCCCTCTCGGGGGAACTGAGCCAGTAGCCCTTATCTTTTAAACCCATTCTTGAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3362,'a093041e22c069d057a398bfdf79483a','CCGTTTCAACCCAATAGTTGGGGGTCTTRTTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAGTAGTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3363,'76f19d781ef06a78d2a021ec3be690c3','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTATTTGGCGGCGGCTGCTGGCTTAATTGTTGGCGGCTGCTGCTGAGTGAGCCCTATCAAAAAAAAGGCGAACGTTTGGGCTTCGGCCTGATTTAKTAKTCTTTTTTTCTTTTAAACCCATTCCTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3364,'f76253a33d2395ba401d94fc2549ea5f','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAACCAAATAGTTGGGGGTCTTGTCTGGTGGCGGCTGCTGACTTTATTGTTGGCGGCTGCTGCTGGATGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGCCTGAGCTAGTAGCTTTTCTTTTAAACCCATTCCTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3365,'69cfe58bddfff852fb14fc5e078c9886','CCACACCTAAAAAACTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGTTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAATTACTGAACATACT');
INSERT INTO its1_sequence VALUES(3366,'6782aec114249648b100bd8018eacdfa','CTTTCCACGTGAACCGTATCAACCCCTTAAATTTGGGGGCTTGCTCGGCGGCGTGCGTGCTGGCCTGTAATGGGTCGGCGTGCTGCTGCTGGGCGGGCTCTATCATGGGCGAGCGTTTGGGCTTCGGCTCGAGCTAGTAGCTATCAATTTTAAACCCTTCTTAAATACTGAACATACT');
INSERT INTO its1_sequence VALUES(3367,'b4c99c224fc2c2b104dbfc7b5ae41250','CCACACCTAAAAACTTTTCACGTGAACCGTATCAAACAAAAATTTGGGGACGAGTTAGGCGGCAATTGCTGACTTTATTGTTGGTGGTTAATGCTAGACGAGTCCTGTCATAGTGAAGTGGTTTGGACTTCGGTTCGAGCTAGTAACTATTTTTAAACCATTAATTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3368,'f586b81c3dc99f6c2151295c65427070','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATAAGTTAGGCGGCGACTGCTGACATTATTGTTGGCGGTTGCTGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3369,'f3bca120a47809382abd5692a1c5dad8','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGACTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3370,'2d941703981cfd2b50805e2dac13202d','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCCTTACTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3371,'fac327ec49afbdcd6dfbff998d90624f','CCACACCTAAAAAYTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGRCTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3372,'525b6cdc2a60e25fba2bf363f08198ad','CCACACCTAAAAAYTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGACTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3373,'99105407c2b99f5b645f7bb0a726eae1','CCACACCTAAAAATTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAATTAGGCGGCGACTGCTGACTTTATTGTTGGCGGATGCTGCTAGATGAATCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3374,'aed9f8109ea19bf0bd550aa52e64df8b','CCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTAGCGACTGCTGACATTACTGTTGGTGGTTACTGCTCGATAAGTCCTATCATAGTGAAGTGGTTTGGACTTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTAAACT');
INSERT INTO its1_sequence VALUES(3375,'f099b837ef37a88bb262a02521d020dd','CCACACCTAAAAAAATACCACGTGAACCGTTTCAACCAAATAGTTGGGGACAAATTAGGTAGCGACTGCTGACATTACTGTTGGTGGTTACTGCTCGATAGGTCCTATCATAGTGAAGTGGTTTGGATTTCGGTCCGAGCTAGTAGCTATTTTAAAACCATTACTAAATACTGATAATACT');
INSERT INTO its1_sequence VALUES(3376,'37f9011863cfd27501f49ea16579e333','CCACACCTAAAAAAATACCACGTGAACCGTTTCAACCAAATAGTTGGGGACAAATTAGGTAGCGACTGCTGACATTACTGTTGGTGGTTACTGCTCGATAAGTCCTATCATAGTGAAGTGGTTTGGATTTCGGTCCGAGCTAGTAGCTATTTTAAAACCATTACTAAATACTGATAATACT');
INSERT INTO its1_sequence VALUES(3377,'372cd1fe59d83d66144d44878dc9c002','CCACACCTAAAAACTTTTCACGTGAACCGTTTCAAAAATTAATTTGGGAACGAGTTAGGCGGCGACTGCTGACTTAATTGTTGGCGGTTACTGCTAGACGAGTTCTATCATAGTGAAGTGGTTTGGACTTCGGTTCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3378,'cd6702599d9e59c7581cfcae6e72fa3b','CCACACCTAAAAACTTTTCACGTGAACCGTTTCAAAAAATTAATTTGGGAACGAGTTAGGCGGCGACTGCTGACTTAATTGTTGGCGGTTACTGCTAGACGAGTTCTATCATAGTGAAGTGGTTTGGACTTCGGTTCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3379,'3877ca4b33344e53b2af89f24a2684c9','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCTTTAATTGGGAGCTTGATGGCGACGGCGTGTTGGCCTATATGGGTTGACGTGCTGCTGCCGGTCAGGCTCTATCAAAGCGATCGTTTGGACCTC');
INSERT INTO its1_sequence VALUES(3380,'92e35077c9273e7942311de9ec527210','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGCGGCTGCTGCTGACATAATTGTTGGCGGCTGCTGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACCTCGGTCCGAGCTAGTAGCTATTTTTAAACCATTAATTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3381,'fd37bb9c04c0d1cbf4ca58a4747dae3f','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3382,'bc8f633d5aa3f1b0b6db5b7fe4f2b776','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3383,'51d26a3855e85f5267c9302b9b429ead','CGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATCTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3384,'2dc25a7110cb25e39bdf31080550a728','CGTGAACCGTTTCAACCGAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTAACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTCTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3385,'a1b29defb2a6ff01e614f30809cccbb7','CGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTAACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3386,'00584e1b8388bc82261bdd2775c03e97','CGTGAACCGTTTCAACCAAAGAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCCTTACTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3387,'82c558a5a5c4ba48eb5f446242445d28','CGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCCTTACTTAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3388,'2ac4f92b9908fa108c8a197225261dbe','CGTGAACCGTTTCAACCAAATAGTTGGGGATGAGTTAGGTGGCAGCTGCTGACTTTAATGTTGGCGGTAGCCGCTAGACGAGTCCTATCATAGTGAAGTGGTTTGGACATTATAGTCCGAGCTAGTAGCTATTTTTAAACCATTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3389,'b0ff3aa31241971406e65016f668be3d','CCACACCTAAAAAATTCCACGTGAACCGTTTCAACCTAATAGTTGGGGATAAGTTAACGGCGACTGCTGACTTTATTGTTAGAGGTTGCTGCTAAACGAGTCCTATCATAGTGAAGTAGTTTGGACTCATGTCCGAGCTTAGTAGCTTTTTAAACCATTACTTAAATTTGATTATACT');
INSERT INTO its1_sequence VALUES(3390,'3732e534fd8addcc532e19651f7a5096','CCACACCTAAAAAAATATCACGTGAACCGTTTCAACCAAATAGTTGGGGATAAATTAGGCAGCGACTGCTGACATTACTGTTGGTGGTTACTGCTCGATAAGTCCTATCATAGTGAGGTGGCTTGGACTTCGGTCCGTGCTAGTAGCTATTTTAAAACCATTACTAAATTCTGATAATACT');
INSERT INTO its1_sequence VALUES(3391,'d181b48a0d9abbf53b97ec897af544eb','CCACACCTAAAAAAATATCACGTGAACCGTTTCAACCAAATAGTTGGGGATAAATTAGGCAGCGACTGCTGACATTACTGTTGGTGGTTACTGCTCGATAAGTCCTATCATAGTGAAGTGGCTTGGACTTCGGTCCGTGCTAGTAGCTATTTTAAAACCATTACTAAATTCTGATAATACT');
INSERT INTO its1_sequence VALUES(3392,'cce1a882e70a91b0e2ca3c84f4c6f688','CCACACCTAAAAAACTTTCCTCGTGAACCGTATCAACAAGTAGTTGGGGGCCTGCTCTGTGTGGCTGTCTGTCGATGTCAAAGTCGGCGGCTGGCTGCTGTGTGGCGGGCTCTATCATGGCGATTGGTTTGGGTCCTCCTCGTGGGGAACTGGATCATGAGCCCACTTTTTAAACCCATTCTTAAATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3393,'f8b9513147406c92a4dbc8c10260340d','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAAATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATGGATTCCTATCATAGTGAAATAGTTTGGAATTTATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3394,'4a2af1ca0f45eac12bce2a51d1eb4fa5','TCAACCAAATAGTTGGGGATGAAATAGGCAGCGATAACTGACTTTATTGTCGGTGGTTGCAGCTAATTGATTCCTATCATAGTGAAATAGCTTGGAATTTATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3395,'b9cfa0b14e489c05194a70799f3944df','TCAACCAAATAGTTGGGGATGAAATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATGGATTCCTATCATAGTGAAATAGTTTGGAATTTATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3396,'2adedbc2b0017114e37563e30308bfe4','ATCAACCAAATAGTTGGGGATGACATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATTGATTCCTATCATAGTGAAATAGCATGGAATTAATTCCGAGCTAGTAGCTATTTTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3397,'725ebdc8c90cbe52693c4abba8e89333','TCAACCAAATAGTTGGGGATGACATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATTGATTTCTATCATAGTGAAATAGTTTGGAATTTATTCCGAGCTAGTAGCTATTTTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3398,'060b4c10a8e1aef1441b4519141b29b9','TCAACCAAATAGTTGGGGATGAAATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATTGATTCCTATCATAGTGAAATAGTTTGGAATTTATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3399,'a9f251736b7ddef31327fd4c59e7d85b','CACCAAATAGTTGGGGATGAAATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATGGATTCCTATCATAGTGAAATAGTTTGGAATTTATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3400,'467f67425852d162ae86630d765dd24c','TAGTTGGGGATGAAATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATGGATTCCTATCATAGTGAAATAGTTTGGAATTTATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3401,'c255d21366adf3b120eebdd1e12f74f4','TAGTTGGGGATGACATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATTGATTCCTATCATAGTGAAATAGTTTGGAATTAATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3402,'80fa75da414e934a1eecf548e6a7a043','TAGTTGGGGATGACATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATTGATTCCTATCATAGTGAAATAGTTTGGAATTTATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3403,'c4ddb9365b05917d23a1332367e18f2e','TAGTTGGGGATGAAATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATTGATTCCTATCATAGTGAAATAGTTTGGAATTTATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3404,'4aeffda6f89321452e258ce1c01381fa','TAGTTGGGGATGACATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATTGATTCCTATCATAGTGAAATAGCATGGAATTAATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3405,'ad8a73dc3f0025a7871e02a5cefe9431','TAGTTGGGGATGACATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATTGATTCCTATCATAGTGAAATAGCATGGAATTCATTCCGAGCTAGTAGCTATTTTTAAACCATTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3406,'d1b456e60e759e4e5ae2bcc9aa70e5ce','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGATGAAATAGGCAGCGACTACTGACTTTATTGTTGGCGGTTGCAGCTAATGGATTCCTATCATAGTGAAATAGTTTGGAATTTATTCCGAGCTAGTAGCTATTTTTAAACCTTTACTAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3407,'b37498b2b31c9358d89251efea6876b4','CCACACCTAAAAAACTTTCACGTGAACCGTTTCAACAAAAATTTGGGGAGGAAGGGTGCGACTGCTGACATTAATGTTGGAGGTTGCCGCCTGATAAATCCTAACATAGTGAAGTGGTTTGAACCTCGGTTCGAGCTAGTAGCTATTTTTAAACCATTAATTAATACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3408,'685b574471ffb575b0c55a8084b37293','CCACACCTAAAAAACTTTCACGTGAACCGTTTCAACAAAAATTTGGGGAGGAAGGGTGCGACTGCTGACATTAATGTTGGAGGTTGCCGCCTGATAAATCCTAACATAGTGAAGTGGTTTGAGCCTCGGTTCGAGCTAGTAGCTATTTTTAAACCATTAATTAATACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3409,'1abef2524621fbcc89edef3731ccb7f6','CCACACCTAAAAAACTTTCACGTGAACCGTTTCAACAAAAATTTGGGGAGGAAGGGTGCGACTGCTGACATTAATGTCGGAGGTTGCCGCCTGATAAATCCCAACATAGTGAAGTGGTTTGAACCTCGGTTCGAGCTAGTAGCTATTTTTAAACCATTAATTAATACTGATTTATAC');
INSERT INTO its1_sequence VALUES(3410,'1539c0e7c76c9858fab676ce99fb9c10','CCACACCTAAAAACTTTCCACGTGAACTGTATTAACCAAATAGTTGGGGATTTGCTAGGTAGTGACTGCTGACTTAATTGTTGGCTGTTGCTGCTAGGCGAATCCTATCATGACGAGCGTTTAGACTTCGGTCTAAGCTAGTAGTTATTTTTTAAACCATTCATAAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3411,'aa8743786ddf8d8f23ced19781e1a321','CCACACCTAAAAATTCCACGTGAACCGTTTCAACCCAATAGTNGGGGGTCTTACTTGGNGGCGGCTGCTGGNTTTATTGCTGGCGGNTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTGGGACTCCGGNCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3412,'89a44043139b91a506ed4e4eea1df283','CCACACCTAAAAACNNCCACGTGAAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGNGGNGGTTGCTGGCTTTATTGCTGGCGGTTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTGGGNCTCCGGTCTGAGCTAGTAGCTTTNNTATTTNAAACCCTTTACTTACTACTGATNATACT');
INSERT INTO its1_sequence VALUES(3413,'216b68a196ca8e672c1bd360e3ad9243','CACACCTAAAAATNCCACGTGAAACCGTTTCACCCAATAGTNGGGGGTCTTACTNGGCGGCGGNTGCTGGNTTTATTGCTGGCGGTTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTGGGACTCCGGNCTGAGCTAGTAGCTTTTTTATTTTAANCCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3414,'ec22f2d921e6c76eacf00f6b9c38ef8e','CACACCTAAAAATCCCACGTGAACCGTTNCAACCCAATAGTNGGGGGTCTTACTTGGNGGCGGNTGCTGGNTTTATTGCTGGCGGTTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTGGGACTCCGGNCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3415,'233ff2e2213e7ad61cd7058440ae54f7','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTTGATTATACT');
INSERT INTO its1_sequence VALUES(3416,'12747ca126a16cf131da285ec5c5bb17','CCACACCTAAAAACTTTCCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3417,'100881f8d1431748347429e9dad498b7','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3418,'f913fea03d4dedfc252bed0cc8a67c27','CCACACCTAAAAACTTTCCACGTGAACCCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3419,'01e67e65efc879fccfd78d8ba6bbce6f','CCACACCTAAAAACCTTTTCCACGTGAACCGGTTTCAACCCAATAGTGGGGGGTCTTACTGGGCGGCGGCTGCTGCCTTTATTGCTGCCGGCTACTGCTGGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3420,'5974a52e99e8d869347183e3825f027d','CCACACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3421,'5b046b9d316fce481a4b755202bae140','CCACACCTAAAAACTTTCCCACGTGAAACCCGTTTCAACCCCAATTAGTTGGGGGGTCTTACTTGGCGGCGGCTGCCTGGCTTTAATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3422,'177839904a61f5065e04daf71502362d','CTAAAACTTTCCCCTGAACCGTTCCACCCAATAGTGGGGGGTCTTACTTGGCGCCGGCTGCTGGCTTTATTGCTGGCGGCTAACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTAATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3423,'f60e85169523fe86b220dc1190b6cb6d','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACACAATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3424,'9c36295794884678f88385ccadd39e65','CCACACCTAAAAACTCTTCCACGGTGAACCGGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3425,'03212e06a37863fd8344c9853fffaa29','CCTAAAACTTTCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3426,'7848ec59848a9cfaf7977295c4f318dc','CACCCTAAAACTTTCACGTGAAACGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3427,'ba20fafb1ff42953f68257be15c49b62','CCACACCTAAAAACTTTTCCACGCTGAACCGCTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3428,'97f3cb25d87dc5ba70ac9ed10fb371c8','TGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3429,'86b8b8909ffb7b780c77ae33d8c98241','CCCTAAAAACTTTCCCGGGAAACGTTCCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGGCTGCTGGCTTTATTGCTGGCGGCTAATGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3430,'4d3bbe19e2f10a9cc070615a9ab8e64d','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3431,'b9eeebcf73c52fe103ae8d773d6c38b9','CCTAAAATCTCAGCATGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3432,'ee3e2ea60d632ce4110e7c804b84787a','CACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3433,'3042544ef27c20780e89d8ce243446d3','CCACACCTAAAACTTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3434,'d30067a3cf553ecfe9e779d1939a1f2a','ATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3435,'075151746a336b584f08224f5f6ced8a','CACACTAAAAACTTTCCACGTGAACCGTTTCAACCAATAGTTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3436,'ef31faf90a2052f9c92fe94ff3893a80','CCACACTTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3437,'0ff6aa811e7a657b9853eb37fd5a2588','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3438,'6668bf759924288884e77660f40733e8','CCACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3439,'5cf65efc076edf7c870e9afe8b7eb1a6','TTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3440,'1cc63aa67489cd182c1df2309574bb2a','ACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3441,'be51d6d2c259a47eac6d5d75e9fea550','AAAAACTTTCCACGTGAACCGTTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3442,'c138a948258bc1fbb75b530010de357a','CCACACCTAAAAAACTTTCCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3443,'ec1aab8f32113821f72fb60c3cc05944','CACCCTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3444,'71fc84faec9e893084eb10dd56120220','CTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3445,'42224af495c6f6afc16a5cb84ed33e7c','CCACACTTAAAAACTTTCCACGTGAACCGTTTCACCCCAATAGTTGGGGTTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGTTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3446,'d0e9d47ef8487cfa0cf68f945bd4ee3a','CCACCCCTAAAAAACTTTTCCACGTGAACCGTTTTCAAACCCCAATAGTTGGGGGTTCTTACTTGGCGGCGGCTGCTGGCCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3447,'592be0350b97080159d7cb3937af6f53','CCACACCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3448,'db3e4038a2f7c5e7b4271e2917ac8da7','CCACACCTAATAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3449,'b52a9ad21df47a97d7f3f517c39c3916','CCTAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3450,'3d94cddfbc7f8bbc294885b7bfe6ddcf','CCACACCTAAAAACTTTCCACGTGACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3451,'48897c1259306f1a9ed7ae40675aa064','CCACCCCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3452,'01d2f09679ff159cce9899c56467550a','CACACCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3453,'aed808d260569b3f6ba0dcdb198b34a6','AAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3454,'d471e45127938da7222951a99c56c8a7','CCACACCTAAAAAATTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3455,'0efe73d75224820011d6d0595ba79144','CCTAAAACTTTCCACGTGACCGTTTCCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3456,'e79b138f97a7afd6f1a76dbb3c70845a','CCCCTAAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3457,'4a99c56e659b3d16372051bbe8c1c90b','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCCATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3458,'83fa4906b0982563d9df61e5e281e32c','CCACANCTAAAACTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3459,'4b7481694cb71c5d67c673276c83a4c8','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCCATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3460,'a6a285e0bb95730082488dcddb53ddcb','CCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3461,'452386034b0312d64e2ccb6b81231689','CCACACCCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3462,'bd774a6d1c4d1d112c76d35cfa0ae39a','CCTAAAAATTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3463,'441d0487e3f5b77b48e39a2d98f3bae9','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3464,'8ce335700011d5e0f481f3a30da664a1','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3465,'4eeb025f41b0be95cdce7c279daee46c','CCACACCTAAAAACTTTCCCACGTGAACCGTTTCAACCCCATAGTTGGGGGTCTTACTTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3466,'99b31b5ff78843bcc88868905f31048c','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAAAACAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3467,'f68b9b507a7491dcca10936ab23a5d5a','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3468,'7927bc9f16c418f6e0593119fcfafc2f','CCTAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTTTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3469,'e586a4d5f80df69139bad9434929cd6c','CCACACCTAAAAACTTTCCACGTGAAVCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3470,'38d7db007a9970b07219a07d9af1b2a0','CCTAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3471,'e55575db922ca4e391dcca7a11b599b7','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGACGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3472,'7a300d71b9f9591343a9931c1fc0d602','CCCCTAAAAACTTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3473,'ec0748a6664f9023196559634320e75b','CCCTAAAAACTTTCCACGTCAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3474,'a8a3d50ea09c91445e1b3b09f095271f','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3475,'510f298ec9a6fd644c46e4aaf553567e','CCACACCTAAAAAACTTTCCACGTGAACCCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3476,'d66b1423d813c2102e77bb21b34b8678','CCCTAAAAACTTTCCACGTGAACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3477,'caa9f65d91d17168ae5bbe9f2abf01fe','CACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3478,'5bc43951daf40427724a22f079ab781d','CCACACCTAAAAACTTCCACGTGAACCGTATCAACCCAATTAGTTGGGGGCTTGCTCTGGCGTGCGGCTGTTGACCTGTAATGGGCTGACGGCTGCTGCTGGGCGGGCTCTATCAAAGGCGAGCGTTTGGACCTCGGTCCGAGCTAGTAGCTTTACTTTTTTAAACCCATTCTTTACATACTGAATATACT');
INSERT INTO its1_sequence VALUES(3479,'508e8dda676927169ada6749e3a4cb34','CCACACCTAAAAACTTTCCTACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3480,'67895b815ee9e67727a717e933a27aac','CCACACCTAAAAACTTTCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3481,'2b3ce227b2426d520cca99925209b554','CCCTAAAAACTTTCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3482,'2b10dc3d9803e81601c54a74a02755a1','CCACACCTAAAAACTTTCCACGTGGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3483,'4cfca33bab43fb14f8863c618490134c','CTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3484,'4b5e02fdfd0da1375f45828879b5703d','AAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3485,'30bdc4923ba02c8ed19c4f3f5093adab','ACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3486,'95bfb0336441a08beb437b20ae4e168b','AAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3487,'e3ed288ec384b802c124ae401f6a4494','CCACCCCTAAAAACTTTCCACGTGACCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3488,'e9889dd8edde1f54d5a16bcd525e0492','CCACACCTAAAAACTTTCCACGTGTAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3489,'6abd2807d163670049d1acf8b46aec6b','CCACACCAAAACACTTTCCACGTGGACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3490,'3a846c27cbf2522d3166e6df4c2dbb18','CACACCTAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3491,'f46c4c9b12cb9d5a39db259a9e705e36','CCACACCATAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3492,'ff2a32906e755d269dda86a1eb02cc47','CACACCTAAAAACTTCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3493,'7e80956b660cca3743556b84500d5d49','CCACACCTAAAAACTTTTCCACGGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3494,'0a4d02a4fa8ab67f8bda06ccad30072e','CACACTAAAAACTTTCCACGTGACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3495,'d1517712aec3b564ef43861a39ca4db3','CCACACCCTAAAAACCTTTCCACGTGACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGAGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3496,'a33a0c1a6217e9e642bb55aba44f5c4e','CCACACCTAAAAACTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3497,'b4123b7e463283fc0438ba58dc40ee34','AACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3498,'9a6300e7c7d9993ac006fa04f042972f','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGSTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3499,'a39b3827cf0f51822aa58fc5922d6f6b','CCACACCTTAAAACTTTCCACTTGAACCGTTTCAACCCAATAATTGGGGGTCTTACTTGGCTGGCGGTCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3500,'567ad031a6b4d3d371b6cc4732299dbc','CCACACCTAAAAACTTTCCACTTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTTCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3501,'bfb883283edc7e43ab63d967125b3b6d','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3502,'8d5d6306cfd9b2ba9c7e5fadf9e05060','TGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3503,'e5adf36da1c5a520d6a4379a90e99760','TCAACCCAATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3504,'11fdcb22aac709b8d980b6e51b3af8ad','AACCCAATAGTTGGGGGTCTTACTTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3505,'fedaed76ecea21b6d10517252db3fec8','TAGTTGGGGGTCTTACTCGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTACACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3506,'c0c2001b29dff7684ffd2d938484d7c7','CGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3507,'e89592e83b4cf80f66132677104c1f03','ACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3508,'06c6b4c32f217991fa5c8846284cf05c','ACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3509,'432b9cc968c78b5d5651c09c093d7578','ATAGTTGGGGGTCTTACTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3510,'cc4698498709f9b51e107b7a38a10e6a','TAGCTTTATCGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3511,'ceb777504a0c0399ef35f26be6cfbde5','TAGTTGGGGGTCTTACTTGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3512,'f33c56073056e67121365fbdef39fe3b','CACCCTAAAAACTTTCCACGTGAACCGTTTCAATCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3513,'a8c1a110e1149c854e6dc4641251dd34','CCACACCTAAAAACTTTCCACGTGAACCGTTTAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3514,'5e8c101f508c96dadbc1b06167b00c5f','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAATCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3515,'6a6b8d204dc0c99c6c884d2538afc85d','ACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3516,'beec5f5dfac0c249b36ec880bed0a4dc','CCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3517,'3710a8048f45c20815705b9cd35c2230','CCACACCTAAAACTTTCCACGTGACTCGTTTCACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3518,'91f391c1cc7ba0d741542deadaff6636','AGACTTTCCACGTGACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3519,'e38b323f3e030f1d7d31fe58f21b5c35','CCACACCTAAGAACATAACATGTGACAAGTGGAACGACATAGTGGGGGCTATGACTTGGCTGTGGCTGCTGGCTAGATAGCTGGATGCAACTGCCGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTCAGCTAGTAGATTTTATATGCGCACCCTTCACTTGATGCTGATCATAC');
INSERT INTO its1_sequence VALUES(3520,'c50f3a8098f00488fc574aefd1e657bc','CCACACCTAAAGAACTTACATTTCCCAATTTCATCCCCATAGTTGGGGGTCTTACTGGGCGGCGGCTGCGGGATTTATAGCTGGATGCAAATGCTGAGCGAGCCGTATCATGATGCGACAGTCCGGACTTCGGTCTGAGCTAGTACCTTTTTTATTTTAAATCCTTCACTTAATACTGATCATACT');
INSERT INTO its1_sequence VALUES(3521,'5984b473c7bef430b0a585eb997ea019','CCACACCTAAGAACACTCCATGTGCCCAGTGTCATCCCCATAGTGGGGGGTATGACGCGGCGCTGGCTGCTGACTATCAAAACTGGCGGCAACTGCCAAGCGAGACCTATCATAGAGGCGAGCGTTTGGACTGCGGTCTGAGCTAGTTGCTTTTATATTTTAAACCCTTCACCCGATACTGATCATAC');
INSERT INTO its1_sequence VALUES(3522,'71fa298ac510be72a12f69554784868d','CCACACATAAAAACTTTCCACGTGAACCGTTTTCAACCCAATAGTTGGGGGGTCTTACTTGGCGGCGGGCTGCTGGCTTTATTGCTGGCGGATACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTAGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3523,'306b1b75397c3227c777e6034a3194e8','CCACACCTAAAAACACTACATGTGACACGTTGCAACGCAATAGTGGGGGGTATGACTCCGCTGCGGTTGCTGGCTTGCAAAGCTCGATTCTACTGCCAGGCGAGAGAGATCAAGAGGCGAGCGTCTGGACTTCGGTCTCAGCTAGTAGCTTTTTTATTTTAAACCCTTCACTCGATGCTGATCATACT');
INSERT INTO its1_sequence VALUES(3524,'df28e3082363000352974c74c5d70ee9','CCACACGTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3525,'85deaf9e7438bfb0053fcaf94be4c9ed','CCACACCTAAAAACTTTCCACGTGACCGTTTCAACCCAATAGTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3526,'1b055de5a6914bb0141a5b14b95c6f91','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTCGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3527,'b5341ec4e01830c1b8363d237f464db3','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3528,'e20590bc190e684c73c5a698e771fbb8','CCACACATAAAAACTCTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3529,'42dd7c5907ba2fd02b5c0fbc4a2012e0','CCCACTTAAAAAACTTTCCACGCGAACCGTTTCAACCCAATAGGGGGGGTCCTACTTGGCGGCGGCTGCAGGCTTTATTGCTGGCGGTTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3530,'6cc8e64ee75e596f05076ff6ce1e5e65','CCACACATAAAAACTTTCCACGTGAACCGATCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3531,'01b0295b2c18c40c23ae744070487562','CCACACATAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3532,'37a4bf203f5a52bd728e42fb9d470c4d','CCACACCTAAAAAACTTTCCACGTGAACCGTTTTCAACCCCAATAGTGGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGTGGAGGTTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3533,'00dc2296f940176701a17a1226058667','CCACACCCGAAAAACTTTCACACGTGCACAGTTGCATCCCCATAGTGCGGGGTCTTACTGCCCCTCGGCTTCGGGATTTATAGCTGGATGCTACTGCTGGGCGAGCACTATCAAGAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTGCAAACCGTTCACCCGAAACCAATCATACT');
INSERT INTO its1_sequence VALUES(3534,'e1e2e0563b1f396448accccd94425a39','CCACACCTAAAAACTCAACATTTCCCCGTTTCATCGCCATACTGGGGGCTCTTACTCGGCGTCTACTTCGGGATAGAAAGGTCGAGGCAACTGCTGAGCGAGCCGTATCAAGAGGCGAGCGTTCGGCCTTCGGTCTGAGCTAGTAGCTCTCTATATAGTAAACCCTTCACCTGATACCGATCATAC');
INSERT INTO its1_sequence VALUES(3535,'ce1567646d36f9d4f169c18743ba33d0','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3536,'a1c374a7711f7977935d00366166eb4c','CACACCGAAGAACTTAACATGTGCACAGTGGCAACGACAATAGTGGGGGCTATGACTTGACTGTGGTTGCTGGCATTAAAGCTGGCTGCTACTGCCGGGCGAGAGATATCATAATGGCGAGCGTTTGGACTGCGGTCTGAGCTAGTAGCTTTTAATATTTTAATCCTTCACTTGATACCGATTATACT');
INSERT INTO its1_sequence VALUES(3537,'99e3ed0db81dc68bc498a8407108126e','CACACCTAAAAACTTCSRMGTGWACCGTTTCACCCRRTAGTSGGGGTCTACTTGGCGGCGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACYTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3538,'3cba5a0b3cde1737f25ab502d0e2cdf7','CACACTAAAAACTTTCCACTGACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3539,'764aa45770d4e1d99d5b913706216757','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACGGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3540,'740253cc8a0fbd3d570718c2cd20ae56','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCCAATAGTTGGGGGTCTTACTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3541,'e2ab342a740ea4c02390e255ce6781d7','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACAAGTGGATGATTATACT');
INSERT INTO its1_sequence VALUES(3542,'d50303ba2f8c169816e9f3ae87491358','AAAAACTTCCCACGTGAACCGTTTCAACCCAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3543,'fd48102ef8657a2604cec814346b6822','GCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTATTTTAAACCCTTTACTTAATACTGATTATACT');
INSERT INTO its1_sequence VALUES(3544,'a32680676de350fa3f338b05611a1cbe','CCACACCTAAAAACTTTCCACGTGAACCGTTTCAACCAAATAGTTGGGGGTCTTACTTGGCGGCGGCTGCTGGCTTTATTGCTGGCGGCTACTGCTGGGCGAGCCCTATCAAAAGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTTTTTTTTTTAAACCCTTTACAAGTGGATGATTATACT');
INSERT INTO its1_sequence VALUES(3545,'14b32beb48c48bca832b59873796c107','CCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAATTGGGGACAAATTAGGCGGCGACTGCAGACTTTGATGTTAGCGGTTGCTGCTAGATAAGTCTCATCATGGCGATTGTTTCGACCTTGGTCGGGACTAGCAGCTGTTCTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3546,'1e42856e9d813c042fa9c0199b758701','CCACACCTAAAAAACTTCCACGTGAACTGTATTAAAACTTAATTGGGGACAAATTAGGCGGCGACTGCAGACTTTGATGTTAGCGGTTGCTGCTAGATAAGTCTCATCATGGCGATTGTTTCGACCTTGGTCGGGACTAGTAGCTGTTCTTTTAAACCTTTAATTATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3547,'eb59b1ad6d8704a7cd2084aee012496a','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGAGGCTTTGTTTGACGGCGACCGCTGGCTTTTTGCTGGCTGGTTGCTGTCAGTCAAGCCCTATCATGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTCTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3548,'f4b5c8dab10fbdc055b2eb08041c5104','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGCTTTGTTTGACGGCGACCGCTGGCTTTTTGCTGGCTGGTTGCTGTCAGTCAAGCCCTATCATGGCGAGCGTTTGGACTTCGGTCTGAGCTAGTAGCTTCTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3549,'6cd2e4b2ceaaf18e87ca56d06fcc6e63','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGCTTTGCTTGGTGGCGATCGCTGGCTTAGTTGCTGGCTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTCTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3550,'2c2831b15a6ab4a72db4723e03167676','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTCTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3551,'c0db18eb00e78be8432bdee85898aeb7','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGTGGTGATCGCTGGCTTAGTTGCTGGCTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTCTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3552,'c607fb12b6001aa30b3d22fcf7523f47','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCATAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3553,'aa41f3f897330570d13bd71676777753','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3554,'431dee1fce341a2d86c41983f01f4789','TTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3555,'4d268dadc912bbdef791e727bb08a986','CCACAACTAAAAACTTTCCACGTGGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3556,'693a7a516ae632ee75da3b4601775687','CACACCTTACCACTTGCCCCGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3557,'b102f3b4a789a047ed86798e77aca02a','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACGGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3558,'6ae4e57b0d28eb4d454db528c52d6e68','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAACTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3559,'e129e0c4c8a14f3b6ef25bc25fa37771','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTATTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3560,'822f6b22442122b79ed32b62de0c99fc','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTCTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3561,'457b40fcf88b98c822f9acd7186ea913','CCACACCTATTAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3562,'877e9f823b9767e194061a80c90de64f','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCWTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3563,'077066a239cfa40b773dbd3e10f50b2e','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGTTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAACTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3564,'df06f1903eb7fb6c89c346fe9e884f99','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGTTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3565,'5203874f8bf94ddbce89558744fee37f','CCACACCTAAAAACTTTCCACGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3566,'64174203bba036ce4489e03ed261412b','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAGCTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3567,'3b644beff7259b9c9d643c7b2fdda09e','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTTGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3568,'f5bca301bb7414e7547a262399ffe1e6','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGATGATCGCTAACTTAATTGCTGGTTGATTACTGCTAGGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3569,'95ffbe46ef012e5e02edde45e4d44584','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGTTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGCTAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3570,'7e3cee41d7d628fab633a50667d4c59d','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGGTGATCGCTAGCTTAATTGCTGGTTGATTACTGATAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3571,'0e9e444614741eb48d1e4b677ed0c9d5','CCACACCTAAAAACTTTCCACGTGAACTGTATCAACCCCATTAATTGGGGGTTTTGGTTGGCGATGATCGCTAACTTAATTGCTGGTTGATTACTGCTAAGCGAGCCCTATCATGGCGAGCGTTTGGGCTTCGGTCTGAACTAGTAGCTTTTATTTTAAACCCTTTCTTAATTACTGATTATACT');
INSERT INTO its1_sequence VALUES(3572,'f02b064a7b84c76675dad7e8d2217cf0','CCAC