import unittest
from Aplicacion_Ventas.gestor_ventas import GestorVentas
from Aplicacion_Ventas.exceptions import ImpuestoInvalidoError,DescuentoInvalidoError

"""Creamos la clase"""
class TestGestorVentas(unittest.TestCase):
    
    def test_calculo_precio_final(self):
        gestor=GestorVentas(100,0.05,0.1)
        self.assertEqual(gestor.calcular_precio_final(),95) #comprobar si dos valores son iguales
    
    def test_impuesto_invalido(self):
        with self.assertRaises(ImpuestoInvalidoError):
            GestorVentas(100,1.4,0.15) #comprobar si la excepcion/error se ejecuta como se debe
            
    def test_decuento_invalido(self):
        with self.assertRaises(DescuentoInvalidoError):
            GestorVentas(120,0.15,1.3)

if __name__=="__main__":
    unittest.main()





