"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
import pydantic
from pydantic.functional_validators import AfterValidator
from speakeasy.new_openapi.models import SDKBaseError
from speakeasy.new_openapi.types import BaseModel
from speakeasy.new_openapi.utils import validate_const
from typing import Literal, Optional
from typing_extensions import Annotated


class ErrorType1Data(BaseModel):
    error: str

    message: int

    CODE: Annotated[
        Annotated[
            Optional[Literal["rate_limit_exceeded"]],
            AfterValidator(validate_const("rate_limit_exceeded")),
        ],
        pydantic.Field(alias="code"),
    ] = "rate_limit_exceeded"


class ErrorType1(SDKBaseError):
    data: ErrorType1Data

    def __init__(
        self,
        data: ErrorType1Data,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data
